<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Sub-rede ou endereço IP',
    'access-network.subnetOrIpAddressHint' => 'Por exemplo, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newsletters',
    'admin.announcement-settings.getConsentLoading' => 'A recuperar informação sobre newsletters...',
    'admin.announcement-settings.getConsentWarning' => 'Não foi possível recuperar o estado da sua assinatura.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Gostaria de receber newsletters da Plesk. Podem conter informações sobre produtos relacionados com segurança, técnicos e gerais. Consinto e autorizo ​​a Plesk a recolher, processar e utilizar os meus dados pessoais (e-mail), incluindo o processamento transfronteiriço, de acordo com a legislação de proteção de dados aplicável em vigor, para me enviar newsletters diretamente ou através de um serviço de terceiros. A anulação desta caixa de seleção revoga o meu consentimento e solicita à Plesk que pare de me enviar e-mails e que remova de forma permanente os meus dados pessoais dos seus sistemas.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Sim, concordo em receber a minha newsletter personalizada do Plesk. A Plesk International GmbH e as suas afiliadas podem armazenar e processar os dados que forneço com o objetivo de enviar a newsletter de acordo com a %%privacyPolicy%%. Para personalizar as suas mensagens e ofertas, a Plesk poderá igualmente utilizar informações adicionais para criação de perfil, como dados de utilização e comportamento. Posso cancelar a inscrição da(s) lista(s) de envio a qualquer momento.',
    'admin.announcement-settings.privacyPolicy' => 'Política de Privacidade da Plesk',
    'admin.announcement-settings.noConsent' => 'Cancelar a minha inscrição na newsletter do Plesk.',
    'admin.announcement-settings.reportConsentError' => 'Não foi possível guardar as suas configurações para receber informações da Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Lamentamos, nesta altura, não podemos atualizar o seu perfil. Por favor tente de novo mais tarde.',
    'admin.announcement-settings.invalidConsentType' => "Tipo de consentimento desconhecido: '%%type%%'",
    'admin.announcement-settings.retry' => 'Voltar a tentar',
    'admin.announcement-settings.consentGivenInfo' => 'Esperamos que aprecie a nossa newsletter genérica do Plesk. Agora, podemos oferecer-lhe uma alternativa melhor - personalizada, com informação útil e conselhos práticos, de acordo com as suas necessidades. Para receber a sua newsletter personalizada do Plesk, escolha a primeira afirmação a seguir e clique em OK.',
    'admin.announcement-settings.consentNotGivenInfo' => 'Parece que não possui assinatura da nossa newsletter genérica.Podemos fornecer-lhe uma alternativa melhor - uma newsletter personalizada, com informação e conselhos úteis, de acordo com as suas necessidades.',

    'admin.personal-info.title' => 'Edição de perfil do administrador',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Configurações do Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Definições',

    'admin-alias.login' => 'Nome de utilizador',
    'admin-alias.password' => 'Palavra-passe',
    'admin-alias.passwordConfirmation' => 'Confirmar a palavra-passe',
    'admin-alias.email' => 'E-mail',
    'admin-alias.contact' => 'Nome de contacto',
    'admin-alias.comments' => 'Comentários',
    'admin-alias.emptyLogin' => 'Por favor, introduza um nome de utilizador.',
    'admin-alias.loginTooLong' => 'O comprimento do nome de utilizador excede os 20 carateres.',
    'admin-alias.emptyEmail' => 'Por favor, introduza um e-mail.',
    'admin-alias.emptyContactName' => 'Por favor, introduza um nome para contacto.',
    'admin-alias.contactNameTooLong' => 'O nome de contacto excede os 255 símbolos.',
    'admin-alias.emptyPassword' => 'Por favor, introduza uma palavra-passe.',
    'admin-alias.commentsTooLong' => 'O comprimento do comentário\\ excede os 255 símbolos.',
    'admin-alias.emailActivation' => 'Ativar conta por e-mail',
    'admin-alias.simplePanel' => 'Ativar modo restrito',
    'admin-alias.simplePanelHint' => 'Selecione esta opção para limitar o número de ações que o administrador pode admitir no Plesk. Para alterar quais ações estão disponíveis, vá para %%link%%.',
    'admin-alias.simplePanelLink' => 'Ferramentas e Configurações> Definições de modo restrito',
    'admin-alias.lockPowerUser' => 'Forçar a apresentação de utilizador avançado para administrador adicional',
    'admin-alias.lockPowerUserHint' => 'Capacidade de restringir a visualização a administradores adicionais do Plesk (sem acesso a clientes, revendedores e planos de serviço).',

    'admin-info.plesk-settings.multiplyLogin' => 'Permitir várias sessões sob esta conta',
    'admin-info.plesk-settings.adminLanguage' => 'Linguagem de interface do administrador',
    'admin-info.plesk-settings.password' => 'Senha',
    'admin-info.plesk-settings.passwordConfirmation' => 'Confirmar a palavra-passe',

    'admin-panel.form.contact-info.contactName' => 'Nome de contacto',
    'admin-panel.form.contact-info.emptyContactName' => 'Por favor, introduza um nome para contacto.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Nome de contacto é muito longo (máximo de %max% símbolos são permitidos).',
    'admin-panel.form.contact-info.email' => 'Endereço de e-mail',
    'admin-panel.form.contact-info.emptyEmail' => 'Por favor, introduza um endereço de email.',
    'admin-panel.form.contact-info.companyName' => 'Nome da empresa',
    'admin-panel.form.contact-info.longCompanyName' => 'O nome da empresa é muito longo (máximo de %max% símbolos são permitidos).',
    'admin-panel.form.contact-info.phone' => 'Número de telefone',
    'admin-panel.form.contact-info.longPhone' => 'O número do telefone é muito longo (máximo de %max% símbolos são permitidos).',
    'admin-panel.form.contact-info.fax' => 'Número de fax',
    'admin-panel.form.contact-info.imNumber' => 'Mensagens Instantâneas',
    'admin-panel.form.contact-info.longFax' => 'O número do fax é muito longo (máximo de %max% símbolos são permitidos).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'O número de telefone especificado não é válido.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Este número de fax está incorreto.',
    'admin-panel.form.contact-info.address' => 'Morada',
    'admin-panel.form.contact-info.longAddress' => 'O endereço é muito longo (máximo de %max% símbolos são permitidos).',
    'admin-panel.form.contact-info.city' => 'Cidade',
    'admin-panel.form.contact-info.longCity' => 'O nome da cidade é muito longo.',
    'admin-panel.form.contact-info.shortCity' => 'O nome da cidade é muito curto.',
    'admin-panel.form.contact-info.state' => 'Estado/Província',
    'admin-panel.form.contact-info.postalCode' => 'Código Postal/CEP',
    'admin-panel.form.contact-info.country' => 'País',
    'admin-panel.form.contact-info.additionalInfo' => 'Informação adicional',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Unicamente em texto: todas as etiquetas HTML serão ignoradas.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Um utilizador com este endereço de e-mail já existe no sistema.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Assinatura',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Propriedades do website fornecidas em conjunto com a assinatura.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Propriedades do website fornecidas em conjunto com a assinatura.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Propriedades do website fornecidas em conjunto com a assinatura.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Criar uma assinatura para o cliente',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Desmarque esta caixa se não pretender criar uma assinatura de serviço de alojamento ou configurar um website para o cliente nesta altura. Sem a assinatura, o cliente não poderá entrar no Painel de Cliente.',
    'admin-panel.form.domain-info-section.domainName' => 'Nome do domínio',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Deve fornecer um nome de domínio.',
    'admin-panel.form.domain-info-section.shared' => 'partilhado',
    'admin-panel.form.domain-info-section.exclusive' => 'dedicado',
    'admin-panel.form.domain-info-section.userName' => 'Nome de utilizador',
    'admin-panel.form.domain-info-section.userNameHint' => 'Conta de utilizador do sistema utilizada para gerir ficheiros e pastas dos websites criados com a assinatura.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Deve fornecer um nome de utilizador.',
    'admin-panel.form.domain-info-section.password' => 'Palavra-passe',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Deve fornecer uma palavra-passe.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Confirmar a palavra-passe',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "O endereço IP no qual o site está hospedado é um endereço de rede do host virtual do site.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Endereço IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "O endereço IP no qual o site está hospedado é um endereço de rede do host virtual do site.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Endereço IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Nenhum',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Definições adicionais da subscrição',
    'admin-panel.form.domain-info-section.credentials' => 'Credenciais de sistema do utilizador',
    'admin-panel.form.domain-info-section.credentialsHint' => 'para aceder a ficheiros armazenados através de FTP e SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'para aceder a ficheiros armazenados através de FTP e RDP',

    'admin-panel.form.login-info.userName' => 'Nome de utilizador',
    'admin-panel.form.login-info.emptyUserName' => 'Por favor, introduza um nome de utilizador.',
    'admin-panel.form.login-info.password' => 'Palavra-passe',
    'admin-panel.form.login-info.emptyPassword' => 'Por favor, introduza uma palavra-passe.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Repetir a palavra-passe',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Alterar a palavra-passe também irá alterar a palavra-passe do endereço de e-mail interno',
    'admin-panel.form.login-info.emailActivation' => 'Ativar conta por e-mail',
    'admin-panel.form.login-info.emailActivationHint' => 'Uma conta criada fica inativa até que o utilizador a ative através da hiperligação enviada por e-mail ou o administrador ative manualmente a conta.',

    'admin-panel.form.subscription-info-section.subscription' => 'Assinatura',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Plano de serviço',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Plano de serviço atual',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Novo plano de serviço',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Plano simples',
    'admin-panel.form.subscription-info-section.none' => 'Nenhum',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Planos de complemento',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Continuar com a personalização de parâmetros da assinatura depois que a associação do plano for alterada. Note que tal bloqueará a sincronização da assinatura.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Avance para a pesonalização dos parâmetros de subscrição após a sua criação.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Avance para a personalização dos parâmetros de subscrição após a criação do cliente.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Continuar com a personalização dos parâmetros da assinatura após a sua criação. Note que tal bloqueará a sincronização da assinatura.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Tenha em conta que isto irá bloquear a subscrição para sincronização.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Adicionar assinatura',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Impossível sincronizar a assinatura com o plano de serviços. As seguintes configurações da assinatura entram em conflito com o plano de serviços: %%problems%%.',

    'app.configure.otherSettings' => 'Outros',
    'app.configure.passwordConfirmation' => 'Confirmar a palavra-passe',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Forçar atualizações para todas as apps instaladas',
    'app.update-settings.forceUpdatesHint' => 'Todas as apps dos clientes serão automaticamente atualizadas assim que as atualizações estiverem disponíveis. Os clientes não poderão desativar as atualizações automáticas das suas apps. Atenção: Utilize esta opção com cuidado, pois atualizações podem afetar a funcionalidade da app de forma significativa. Por exemplo, extensões de app podem parar de funcionar com outra versão da mesma.',
    'app.update-settings.suggestUpdates' => 'Deixe a opção "Atualizar automaticamente esta app" como padrão.',
    'app.update-settings.suggestUpdatesHint' => 'Para apps instaladas recentemente, a opção "Atualizar automaticamente esta app" nas configurações da app poderá ser ativada.',

    'backup.server-settings.rotation' => 'Número máximo de ficheiros de cópia de segurança completos a serem armazenados (incluindo cópias de segurança agendadas e manuais)',
    'backup.server-settings.rotationDescription' => 'Os utilizadores podem agendar imensas cópias de segurança no armazenamento do servidor. Se o número de cópias de segurança completas no armazenamento exceder o limite, apenas as mais recentes serão mantidas. As cópias de segurança incrementais não são afetadas.',
    'backup.server-settings.maxProcesses' => 'O número máximo de processos de backup programados a funcionar simultaneamente.',
    'backup.server-settings.niceScheduled' => 'Deixar os processos de backup programados a funcionar com baixa prioridade',
    'backup.server-settings.niceScheduledPriority' => 'Prioridade',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Introduza um valor entre 1 e 19, inclusivo, sendo o número mais elevado a prioridade mais baixa.',
    'backup.server-settings.niceScheduledIoPriority' => 'Prioridade de E/S',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Introduza um valor entre 0 e 7, inclusivo, sendo o número mais elevado a prioridade mais baixa.',
    'backup.server-settings.niceAlways' => 'Deixar os processos de backup a funcionar com baixa prioridade',
    'backup.server-settings.niceAlwaysPriority' => 'Prioridade',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Introduza um valor entre 1 e 19, inclusivo, sendo o número mais elevado a prioridade mais baixa.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Prioridade de E/S',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Introduza um valor entre 0 e 7, inclusivo, sendo o número mais elevado a prioridade mais baixa.',
    'backup.server-settings.compressionLevel' => 'Nível de compressão',
    'backup.server-settings.compressionLevelNoCompression' => 'Sem compressão',
    'backup.server-settings.compressionLevelFastest' => 'Mais rápido',
    'backup.server-settings.compressionLevelFast' => 'Rápido',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'Máximo',
    'backup.server-settings.freeSpaceRequired' => 'Faça o backup apenas se o seu servidor tiver a quantidade suficiente de espaço em disco (em megabytes).',
    'backup.server-settings.checkBackupDiskSpace' => 'Inicie a cópia de segurança apenas se o servidor tiver a quantidade suficiente de espaço livre em disco',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Usar funcionalidade de cópia de segurança nativa MS SQL (Para bases de dados remotas, certifique-se de que define as configurações do backup do servidor remoto MS SQL em Ferramentas e Configurações> Servidores da Base de Dados)',
    'backup.server-settings.localFtpRestriction' => 'Permitir a configuração do armazenamento de backup do FTP no servidor local',
    'backup.server-settings.backupSecuritySettings' => 'Definições de segurança de cópia de segurança',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Guarde cópias de segurança no servidor se o carregamento para o armazenamento remoto falhar.',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'As cópias de segurança manuais e agendadas destinadas ao armazenamento remoto serão guardadas no armazenamento do servidor local em caso de falha de carregamento para o armazenamento remoto. Os utilizadores deverão ter autorização para guardar as cópias de segurança no servidor.',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => 'Clientes do Administrador',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => 'Todas as contas de cliente pertencentes ao administrador na versão anterior do Plesk foram convertidas para as próprias contas de cliente do administrador: (1) Os recursos de legado de cada cliente foram preservados (podem ser encontrados em \'Meus Recursos\', na parte superior da lista de assinaturas do cliente) e podem ser removidos quando a transição é finalizada; (2) Todos os seus domínios foram convertidos para as assinaturas (uma nova assinatura de cada domínio); (3) Os administradores do domínio foram convertidos para os utilizadores de cliente que possuem acesso apenas à assinatura que contém seus domínios.',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => 'Estado de Cliente Anterior',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => 'Número de Clientes',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => 'Esquema de Transição',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => 'Um domínio; ajustes de limite não são permitidos.',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => 'Novas fontes de assinaturas são as mesmas para o mínimo do cliente ou limites de domínios anteriores.',
    'business-model-upgrade.bunch.t1s1-apply' => 'Transição para estes clientes',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => 'Um domínio; ajustes de limite são permitidos.',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => 'Novas fontes de assinaturas são as mesmas para os limites de cliente anteriores.',
    'business-model-upgrade.bunch.t1s2-apply' => 'Transição para estes clientes',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => 'Diversos domínios; não é permitido criar domínios e ajustar limites.',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => 'Novas fontes de assinaturas são obtidas dos limites de domínios anteriores.',
    'business-model-upgrade.bunch.t1s3-apply' => 'Transição para estes clientes',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => 'Diversos domínios; é permitido criar domínios e ajustar limites.',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => 'Transição como:',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => 'Revendedor. Um ex-cliente é promovido para revendedor. Fontes de assinaturas de revendedor são obtidas dos limites de clientes anteriores. Se a conta do administrador do domínio foi ativada para um domínio anterior, ela será atualizada para uma conta de cliente e a assinatura correspondente com a qual ela está associada. Caso contrário, as assinaturas pertencerão diretamente ao revendedor.',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => 'Cliente. Um ex-cliente continua sendo cliente. As fontes de cliente são igualmente distribuídas entre as suas assinaturas.',
    'business-model-upgrade.bunch.t1s6r-solutionName' => 'Revendedores',
    'business-model-upgrade.bunch.t1s6c-solutionName' => 'Clientes',
    'business-model-upgrade.bunch.t1s6-apply' => 'Transição para estes clientes como',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => 'Clientes dos Revendedores',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => 'Todas as contas de cliente que pertenciam a um revendedor no Plesk 9 foram convertidas em contas de cliente, propriedade dos respetivos revendedores: (1) Os recursos de legado de cada cliente foram preservados (podem ser encontrados em \'Meus Recursos\', na parte superior da lista de assinaturas do cliente) e podem ser removidos quando a transição é finalizada; (2) Todos os seus domínios foram convertidos para as assinaturas (uma nova assinatura de cada domínio); (3) Os administradores do domínio foram convertidos para os utilizadores de cliente que possuem acesso apenas à assinatura que contém os seus domínios.',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => 'Estado de Cliente Anterior',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => 'Número de Clientes',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => 'Esquema de Transição',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => 'Um domínio; ajustes de limite não são permitidos.',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => 'Novas fontes de assinaturas são as mesmas para o mínimo do cliente ou limites de domínios anteriores.',
    'business-model-upgrade.bunch.t2s1-apply' => 'Transição para estes clientes',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => 'Um domínio; ajustes de limite são permitidos.',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => 'Novas fontes de assinaturas são as mesmas para os limites de cliente anteriores.',
    'business-model-upgrade.bunch.t2s2-apply' => 'Transição para estes clientes',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => 'Diversos domínios; não é permitido criar domínios e ajustar limites.',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => 'Novas fontes de assinaturas são obtidas dos limites de domínios anteriores.',
    'business-model-upgrade.bunch.t2s3-apply' => 'Transição para estes clientes',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => 'Diversos domínios; é permitido criar domínios e ajustar limites.',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => 'As fontes de cliente são igualmente distribuídas entre suas assinaturas.',
    'business-model-upgrade.bunch.t2s6-apply' => 'Transição para estes clientes',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => 'Assinaturas do Administrador',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Todos os domínios pertencentes ao administrador na versão anterior do Plesk foram convertidos para as próprias assinatura do administrador. Os administradores do domínio foram convertidos para os utilizadores do Painel de Cliente e possuem acesso apenas à assinatura que contém o seu domínio. Utilize as ações recomendadas para a transição entre estas assinaturas ou selecione um esquema de transição personalizado para cada esquema no separador \'Transição Seletiva de Assinaturas\'.',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => 'Estado de Domínio Anterior',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => 'Número de Assinaturas',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => 'Esquema de Transição',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => 'Domínio do administrador; A conta de administrador do domínio está ativada.',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => 'O administrador de Domínio Anterior foi atualizado para o cliente e tornou-se um assinante, o que significa que a assinatura está atribuída a ele.',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => 'Transição para estas assinaturas',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => 'Assinaturas dos Revendedores',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Todos os domínios pertencentes aos revendedores na versão anterior do Plesk foram convertidos para as próprias assinaturas revendedores, preservando os respetivos proprietários. Os administradores do domínio foram convertidos para os utilizadores do Painel de Cliente e possuem acesso apenas à assinatura que contém o seu domínio. Utilize as ações recomendadas para a transição entre estas assinaturas ou selecione um esquema de transição personalizado para cada esquema no separador \'Transição Seletiva de Assinaturas\'.',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => 'Estado de Domínio Anterior',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => 'Número de Assinaturas',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => 'Esquema de Transição',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => 'Domínio do revendedor; A conta de administrador do domínio está ativada.',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => 'O administrador de Domínio Anterior foi atualizado para o cliente e torna-se um assinante, o que significa que a assinatura está atribuída a eles.',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => 'Transição para estas assinaturas',
    'business-model-upgrade.bunch.thereWereSomeErrors' => 'Alguns dos clientes e assinaturas selecionados não passaram pela transição.',

    'change-current-subscription.hint' => 'Aqui, é onde pode alterar a associação com planos de serviço para a assinatura. Ao selecionar \'Nenhum\' como um novo plano de serviço, a assinatura será desvinculada do plano de serviço e será \'Personalizada\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Impossível sincronizar a assinatura com o plano de serviços. As seguintes configurações da assinatura entram em conflito com o plano de serviços: %%problems%%.',

    'change-password.oldPassword' => 'Palavra-passe antiga',
    'change-password.password' => 'Nova palavra-passe',
    'change-password.passwordConfirmation' => 'Confirmar a palavra-passe',
    'change-password.oldPasswordIsIncorrect' => 'A palavra-passe antiga é incorreta. Por favor, tente novamente.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Não foi possível localizar a conta de administrador adicional.',
    'change-password.warningAboutAdminPasswordSyntax' => "A palavra-passe deve conter entre %%min%% - %%max%% carateres e não pode conter o nome do utilizador.\nNão use aspas, espaços e carateres alfabéticos nacionais na palavra-passe.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Não use dois pontos, espaços, ponto e vírgula e carateres alfabéticos nacionais na palavra-passe.\nA palavra-passe deve conter entre %%min%% e %%max%% carateres e não pode conter o nome do utilizador.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Política de venda excessiva',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'A  venda excessiva é permitida',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'A venda excessiva permite que um revendedor venda mais recursos do que lhe é alocado com um plano. Se a venda excessiva for permitida, um revendedor será controlado pelo uso de recurso atual, ao contrário da alocação de recurso inicial.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'A venda excessiva não é permitida',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Se a venda excessiva não for permitida, um revendedor pode vender apenas a quantidade de recursos alocadas inicialmente a ele com um plano, independentemente do quanto destes recursos são atualmente utilizados.',

    'change-reseller-subscription.hint' => 'Aqui, é onde pode alterar a associação com o plano de serviço para a assinatura do revendedor. Ao selecionar \'Nenhum\' como um novo plano de serviço, a assinatura será desvinculada do plano de serviço e será \'Personalizada\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Impossível sincronizar a assinatura com o plano de serviços. As seguintes configurações da assinatura entram em conflito com o plano de serviços: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Novo plano',
    'change-reseller-subscription.oldSubscription' => 'Plano atual',
    'change-reseller-subscription.none' => 'nenhum',
    'change-reseller-subscription.infoSubscriptionChanged' => 'A associação da assinatura com o plano de serviço foi atualizada.',
    'change-reseller-subscription.customizeSubscription' => 'Continuar para a personalização dos parâmetros de assinatura depois que a sua associação ao plano de serviço é atualizada. Note que tal bloqueará a sincronização da assinatura.',

    'change-subscription.hint' => 'Aqui, é onde pode alterar a associação com planos de serviço para as assinaturas selecionadas.',
    'change-subscription.selectPlanLegend' => 'Plano de serviço',
    'change-subscription.selectPlanDescription' => 'Para alterar para outro plano de serviço, escolha o novo plano na lista. Ao selecionar \'Nenhum\', as assinaturas serão desvinculadas do plano de serviço e serão \'Personalizadas\'.',
    'change-subscription.servicePlan' => 'Novo plano de serviço',
    'change-subscription.selectAddonPlansLegend' => 'Planos de complemento',
    'change-subscription.selectAddonPlansDescription' => 'Adicionar ou remover planos de complemento.',
    'change-subscription.noChange' => 'sem alterações',
    'change-subscription.none' => 'nenhum',
    'change-subscription.add' => 'adicionar',
    'change-subscription.del' => 'eliminar',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Sub-rede ou endereço IP',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Por exemplo, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Acesso com privilégios de administrador Plesk.',
    'control-panel-access.settings.policyAllow' => 'Permitidos, excluindo as redes na lista.',
    'control-panel-access.settings.policyDeny' => 'Recusado das redes que não estão listadas.',

    'create-subscription.title' => 'Adicionar uma assinatura',
    'create-subscription.titleOwn' => 'Adicionar a sua própria assinatura',
    'create-subscription.poolIsEmpty' => 'Impossível criar uma assinatura porque não existem endereços IP partilhados e endereços dedicados gratuitos no Plesk.',
    'create-subscription.infoNewSubscriptionCreated' => 'O %%name%% de assinatura foi criado.',
    'create-subscription.createBeforeAppInstall' => 'Tem de ter uma assinatura para instalar a aplicação.',

    'customer.hint' => 'Aqui, regista um novo cliente dos seus serviços de alojamento. Com este registo, cria uma conta de cliente no Plesk e uma assinatura para um dos seus planos de alojamento e, em opção, suplementos. A assinatura pode igualmente fornecer um conjunto completo de recursos e serviços, totalmente personalizado, sem vinculação a qualquer plano. Para tal, selecione \'Nenhum\', ao lado do Plano de Serviço.',
    'customer.contactInfoSection' => 'Informação de contacto',
    'customer.additionalInfoSection' => 'Informações adicionais do cliente',
    'customer.accessToPanelSection' => 'Acesso ao Plesk',
    'customer.contactInfoSectionHint' => 'Insira as informações de contato do cliente.',
    'customer.accessToPanelSectionHint' => 'Credenciais a utilizar pelo cliente para aceder ao seu Painel de Cliente.',
    'customer.unableCreateSubscription' => 'A assinatura não pode ser criada: %%reason%%',
    'customer.poolIsEmpty' => 'O repositório de IP está vazio.',
    'customer.buttonOk' => 'Adicionar cliente',

    'database-settings.dbPrefixRadio' => 'Adicionar prefixo e underline no início dos nomes de bases de dados',
    'database-settings.dbPrefixNone' => 'Nenhum',
    'database-settings.dbPrefixUsername' => 'Nome de usuário',
    'database-settings.dbPrefixExternalId' => 'ID Externa de uma assinatura',
    'database-settings.dbUserPrefix' => 'Adicionar o nome de utilizador e sublinhar até ao início dos nomes dos utilizadores da base de dados',
    'database-settings.dbUserPrefixHint' => 'Os nomes de utilizadores de bases de dados serão exibidos como <plesk_username>_<database_user_name>. Devido à restrição do comprimento do nome do utilizador da base de dados, <plesk_username> pode ser abreviado.',
    'database-settings.grantAlterDatabase' => 'Conceder a autorização ALTER DATABASE a todos os utilizadores da base de dados do Servidor Microsoft SQL.',
    'database-settings.grantAlterDatabaseHint' => 'Utilizadores novos e existentes receberão esta autorização.',
    'database-settings.enableBackupOperator' => 'Ative a associação de funções db_backupoperator para todos os utilizadores da base de dados do Servidor Microsoft SQL',
    'database-settings.enableBackupOperatorHint' => 'Utilizadores novos e existentes serão um membro desta função.',
    'database-settings.aclRadio' => 'Configurações predefinidas para acesso remoto de utilizadores da base de dados',
    'database-settings.aclLocalhost' => 'Permitir apenas ligações locais',
    'database-settings.aclAny' => 'Permitir ligações remotas de qualquer host',
    'database-settings.aclCustom' => 'Permitir ligações remotas de',
    'database-settings.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOs hosts especificados podem aceder à base de dados para este utilizador.",
    'database-settings.aclDescription' => 'Esta configuração modifica somente as permissões dos utilizadores. Para ativar o acesso remoto ao servidor MySQL Local, selecione a opção correspondente em <a href="/server/db_server_edit.php?db_server_id=%d">Configurações locais MySQL</a>.',
    'database-settings.example' => "Por exemplo:\n%%example%%",

    'dns.template.synchronize-done' => 'O modelo de zona DNS foi aplicado com sucesso.',
    'dns.template.synchronize-error' => 'O modelo de zona  DNS não foi aplicado a algumas zonas de DNS.',
    'dns.template.synchronize-progress' => 'Aplicar o modelo de zona DNS.',

    'domain-restriction.name' => 'Nome de domínio',
    'domain-restriction.nameDescription' => 'É possível especificar um padrão genérico utilizando o asterisco (*). Por exemplo, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'O nome de domínio especificado já se encontra na lista.',

    'event-handler.eventLabel' => 'Evento',
    'event-handler.priorityLabel' => 'Prioridade',
    'event-handler.userLabel' => 'Utilizador',
    'event-handler.commandLabel' => 'Comando',
    'event-handler.commandHint' => 'Para melhores resultados, introduza o caminho completo no ficheiro guião no campo \'command\'. Não recomendamos a introdução de comandos do sistema dado que podem não funcionar. Por exemplo, os comandos com operadores de redirecionamento de saída /&gt; ou &lt; não funcionarão.',
    'event-handler.priorityHighestText' => 'mais elevado',
    'event-handler.priorityHighText' => 'elevado',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'baixo',
    'event-handler.priorityLowestText' => 'menor',
    'event-handler.priorityCustomText' => 'personalizar',
    'event-handler.priorityHighestOption' => 'mais elevado (%%value%%)',
    'event-handler.priorityHighOption' => 'elevado (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'baixo (%%value%%)',
    'event-handler.priorityLowestOption' => 'mais baixo (%%value%%)',

    'extension.upload.fileUpload' => 'Caminho para o ficheiro do pacote de extensão',

    'external-webmail.hint' => 'Assim que registar um webmail adicional no Plesk, este estará disponível para os seus clientes: surgirá como uma opção nas propriedades de \'Correio\', nos planos de alojamento e assinaturas. O nome do webmail será apresentado na lista de opções de webmail e o URL abrirá quando se clica no ícone do webmail ao lado de uma caixa de correio no Painel de Cliente.',
    'external-webmail.name' => 'Nome de serviço do webmail',
    'external-webmail.url' => 'URL de serviço do webmail',
    'external-webmail.enabled' => 'Disponível',

    'ftp-settings.generalSection' => 'Geral',
    'ftp-settings.portRange' => 'Porta ou intervalos de portas para ligações em modo FTP passivo.',
    'ftp-settings.hintPortRange' => '(valor predefinido: %%defaultPortRange%%)',

    'health.upload.hint' => 'Atualize a sua configuração do monitor de integridade do servidor. As configurações serão aplicadas após a atualização.',
    'health.upload.selectFile' => 'Ficheiro de configuração',

    'install-local-package.selectUploadType' => 'Escolha uma das seguintes:',
    'install-local-package.uploadAsFile' => 'Carregue um pacote APS',
    'install-local-package.downloadFromCatalog' => 'Selecione uma app do Catálogo de Aplicações',
    'install-local-package.formInfo' => "Aumentar a lista de aplicações disponíveis, transferindo uma nova aplicação ou adicionando uma aplicação do Catálogo de Aplicações para configuração posterior.",
    'install-local-package.invalidFileExtension' => 'A app carregada deverá ser um ficheiro ZIP com uma extensão .zip.',
    'install-local-package.packagesNotSelected' => 'Nenhum dos pacotes foi selecionado.',
    'install-local-package.visible' => 'Disponibilizar aos clientes',
    'install-local-package.isCommercial' => 'Esta aplicação é comercial e uma chave de licença deverá ser adquirida.',
    'install-local-package.visibleDescription' => 'Disponibilizar a app para que os clientes a instalem.',

    'ip-address.generalSection' => 'Geral',
    'ip-address.interface' => 'Interface',
    'ip-address.addressAndSubnetPrefixLength' => 'endereço IP e máscara da rede',
    'ip-address.publicIp' => 'Endereço IP público',
    'ip-address.hintPublicIp' => 'Pode utilizar um endereço IP público se o seu servidor Plesk estiver por trás do NAT',
    'ip-address.distributionType' => 'O endereço IP é distribuído como',
    'ip-address.distributionTypeShared' => 'Partilhado',
    'ip-address.distributionTypeExclusive' => 'Dedicado',
    'ip-address.certificate' => 'Certificado SSL/TLS',
    'ip-address.defaultSite' => 'Site predefinido',
    'ip-address.ftpOverSslNotSupportedByServer' => 'O servidor FTP instalado não suporta FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'O servidor FTP instalado não suporta endereços IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'Não é possível adicionar o endereço IP.Esta interface de rede obtém os endereços IP automaticamente.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Atenção: O URL Plesk personalizado está ativo para todos os domínios desconhecidos; será apresentado o interface Plesk em vez do site predefinido em "https://%%ip%%/"',

    'ip-ban.filter.name' => 'Nome',
    'ip-ban.filter.content' => 'Conteúdo',
    'ip-ban.filter.filterExistsError' => 'Já existe um filtro com esse nome.',

    'ip-ban.jail.name' => 'Nome',
    'ip-ban.jail.filter' => 'Filtro',
    'ip-ban.jail.filterDescription' => 'Selecione o filtro.',
    'ip-ban.jail.action' => 'Ação',
    'ip-ban.jail.actionDescription' => 'Selecione uma ação e clique no botão para a adicionar.',
    'ip-ban.jail.logPath' => 'Local do Log',
    'ip-ban.jail.banTime' => 'Período de exclusão do endereço IP',
    'ip-ban.jail.maxRetry' => 'Número máximo de tentativas de login fracassadas.',
    'ip-ban.jail.timeUnit' => 'segundos',
    'ip-ban.jail.addAction' => 'Adicionar',
    'ip-ban.jail.chooseAction' => 'Selecione:',
    'ip-ban.jail.apache-auth-filter-description' => 'Erros de autorização do Apache (ao iniciar sessão no ficheiro)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Erros de autorização do Apache (qualquer início de sessão)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Erros de autorização do Apache (ao iniciar sessão no syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spambots e web crawlers maus',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Falhas de autenticação do Courier IMAP e POP3',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Falhas de autenticação do Dovecot IMAP, POP3 e Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Erros de autenticação Dovecot IMAP, POP3 e Sieve (modo agressivo)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Falhas de autenticação do webmail Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Violações de segurança e controlo de acesso do Web Application Firewall (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Falhas de autenticação do Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Falhas de autenticação de SMTP do QMail',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Falhas de autenticação do webmail Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Erros de autenticação do WordPress',
    'ip-ban.jail.postfix-filter-description' => 'Erros do cliente SMTP do Postfix (incluindo RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Erros do cliente SMTP do Postfix, falhas de autenticação e ataques DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Falhas de autenticação SASL e SMTP do Postfix',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Ataques DDoS SMTP do Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Erros do cliente SMTP do Postfix e falhas de autenticação',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Erros do cliente SMTP do Postfix (incluindo RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Erros do cliente SMTP (apenas RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Falhas de login do ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Hosts banidos repetidamente pelo Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Falhas de login SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Erros de início de sessão SSH, falhas de negociação e ataques DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Erros de início de sessão SSH e ataques DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Erros de início de sessão e negociação de SSH',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Proibir através de firewall firewalld, em todas as portas',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Proibir através de firewall firewalld, em várias portas',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Proibir através de firewall firewalld, numa única porta',
    'ip-ban.jail.iptables-action-description' => 'Banir pelas tabelas de IP da firewall, porta única',
    'ip-ban.jail.iptables-allports-action-description' => 'Banir pelas tabelas de IP da firewall, todas as portas',
    'ip-ban.jail.iptables-multiport-action-description' => 'Banir pelas tabelas de IP da firewall, múltiplas portas',
    'ip-ban.jail.sendmail-action-description' => 'Enviar notificação por e-mail via sendmail',
    'ip-ban.jail.jailExistsError' => 'Já existe uma área de bloqueio com esse nome.',
    'ip-ban.jail.invalidInteger' => 'O valor especificado é inválido. Especifique um número inteiro.',

    'ip-ban.settings.pageHint' => 'Aqui, poderá configurar a exclusão de endereços IP para proteger o seu servidor e websites alojados contra tráfego malicioso.',
    'ip-ban.settings.detectionEnabled' => 'Permitir a deteção de intrusão',
    'ip-ban.settings.banPeriod' => 'Período de exclusão do endereço IP',
    'ip-ban.settings.banTimeWindow' => 'Intervalo de tempo para deteção de ataques subsequentes',
    'ip-ban.settings.maxRetries' => 'Número de falhas antes de o endereço IP ser excluído',
    'ip-ban.settings.timeUnit' => 'segundos',
    'ip-ban.settings.invalidInteger' => 'Um valor inválido foi fornecido. Forneça um valor inteiro e positivo.',

    'ip-ban.trusted-ip.ipAddress' => 'Endereço IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'Forneça um endereço de IP, uma máscara CIDR ou um nome de host de DNS',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'O endereço de IP, endereço de rede ou nome de host fornecidos são inválidos.',

    'login-info.hint' => 'Aqui é onde pode alterar o nome de utilizador e a palavra-passe que o cliente utiliza para aceder ao seu Painel de Cliente.',
    'login-info.resellerHint' => 'É aqui que altera o nome de utilizador e/ou senha que o revendedor utiliza para aceder ao Plesk.',
    'login-info.myProfileHint' => 'Também pode alterar a senha que utiliza para aceder ao seu Plesk.',

    'mail.lists-server-settings.email' => "Email de administrador para lista de envio.",
    'mail.lists-server-settings.emptyEmail' => 'Forneça um endereço de email.',
    'mail.lists-server-settings.newPassword' => 'Nova palavra-passe',
    'mail.lists-server-settings.emptyPassword' => 'Por favor, forneça uma palavra-passe.',
    'mail.lists-server-settings.passwordConfirmation' => 'Confirmar a palavra-passe',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'O software da lista de envio foi configurado.',

    'mail.outgoing-messages.hint' => 'Aqui é possível especificar um limite para a saída de mensagens de uma caixa de correio.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Número máximo de mensagens de e-mail enviadas',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Padrão (%%domainOutgoingMessages%% mensagens por hora)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Valor personalizado para esta caixa de correio',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'mensagens por hora',

    'mail-gate-settings.host' => 'Nome de Host ou endereço IP',
    'mail-gate-settings.port' => 'Porta',
    'mail-gate-settings.login' => 'Nome de utilizador',
    'mail-gate-settings.password' => 'Palavra-passe',
    'mail-gate-settings.encryption' => 'O servidor SMTP precisa de uma ligação encriptada.',
    'mail-gate-settings.allowUsers' => 'Permite que scripts de utilizadores enviem mensagens através deste servidor SMTP (através de um nome de utilizador e senha específicos)',
    'mail-gate-settings.useDefaultSettings' => 'Utilizar um servidor de correio instalado no Plesk e a conta de correio predefinida criada pelo Plesk',

    'mail-gate.hint' => 'Aqui pode especificar o servidor SMTP a ser utilizado quando o servidor de correio do Plesk não estiver instalado ou proibido de enviar mensagens. Este servidor será utilizado como um relé do SMTP através do Plesk e scripts do utilizador para enviar mensagens, como notificações de e-mail.',
    'mail-gate.enableMailGate' => 'Permite que o Plesk envie notificações de e-mail através deste servidor de SMTP.',
    'mail-gate.notifications' => 'Notificações de correio através de um servidor SMTP externo',
    'mail-gate.smtpSettings' => 'Configurações do servidor de SMTP externo',

    'optimization-settings.apacheModulesSection' => 'Módulos Apache',
    'optimization-settings.apacheSettingsSection' => 'Configurações gerais',
    'optimization-settings.additionalPageHint' => 'Alterne apenas entre módulos se tiver compreendido totalmente as consequências das suas ações. Algumas modificações podem diminuir o desempenho do Apache ou até deixá-lo inoperativo.',
    'optimization-settings.pageHint' => 'Aqui pode melhorar o Plesk desligando os módulos Apache que não estiverem a ser utilizados. Esta ação melhora o uso da memória e permite que sirva mais clientes de alojamento. Alguns módulos são interdependentes e podem ser desativados (ou ativados) apenas quando os módulos dos quais eles dependem estiverem desativados (ou ativados).',
    'optimization-settings.advancedUsersOnlyWarning' => 'Recurso apenas para utilizadores avançados.',
    'optimization-settings.apacheRestartInterval' => 'Intervalo de reinício do Apache (segundos)',
    'optimization-settings.apacheRestartIntervalHint' => 'Quando estiver num intervalo específico, o Plesk verificará se foram feitas mudanças nos domínios e subdomínios. Caso haja mudanças que obriguem o servidor da web a reiniciar, o Plesk irá reiniciar o Apache.',
    'optimization-settings.gracefulRestart' => 'Reinicialização graciosa do Apache',
    'optimization-settings.gracefulRestartHint' => 'Selecione para evitar o tempo de inatividade de todos os websites alojados no servidor, sempre que alterar as configurações de alojamento.',
    'optimization-settings.pipedLog' => 'Registos transferidos',
    'optimization-settings.mpmMode' => 'Modo MPM',
    'optimization-settings.moduleDeprecated' => '(Descontinuado)',

    'personal-info.contactInfoSection' => 'Informaçaõ de contacto',
    'personal-info.hint' => 'Aqui as informações de contato do utilizador podem ser editadas.',
    'personal-info.hintMyProfile' => 'Aqui as informações de contato podem ser editadas.',

    'php-handler.ini.formHint' => 'Este ficheiro php.ini está a ser utilizado apenas por este manipulador.',
    'php-handler.ini.formHintSharedIni' => 'Este ficheiro php.ini também está a ser utilizado pelos seguintes manipuladores do PHP: %%handlers%%. As configurações aplicam-se a todos os sites que utilizam estes manipuladores.',
    'php-handler.ini.incorrectTextForIniFile' => "As definições especificadas estão incorretas e não podem ser guardadas no ficheiro php.ini. Erro: %%message%%.",

    'php-handler.modules.formHint' => 'Estas configurações das extensões do PHP são apenas para este manipulador.',
    'php-handler.modules.formHintSharedModules' => 'Estas configurações são comuns para os seguintes manipuladores PHP: %%handlers%%. As configurações aplicam-se a todos os sites que utilizam estes manipuladores.',

    'plan-item-custom.planItemName' => 'Nome do serviço',
    'plan-item-custom.buttonLabel' => 'Este nome também será utilizado como um rótulo do botão personalizar.',
    'plan-item-custom.planItemDescription' => 'Descrição do serviço',
    'plan-item-custom.buttonTooltip' => 'Este texto também será utilizado como uma dica de ferramenta do botão personalizar.',
    'plan-item-custom.url' => 'URL vinculada ao botão personalizado.',
    'plan-item-custom.backgroundImage' => 'Imagem de segundo plano para o botão personalizar.',
    'plan-item-custom.emptyItemName' => 'Forneça um rótulo para o serviço.',
    'plan-item-custom.emptyItemDescription' => 'Forneça um texto para a dica de ferramenta de serviço.',
    'plan-item-custom.emptyUrl' => 'Por favor, introduza uma URL',
    'plan-item-custom.longItemName' => 'O rótulo de serviço é muito longo. O comprimento máximo permitido é de %max% símbolos.',
    'plan-item-custom.longItemDescription' => 'O texto de serviço é muito longo. O comprimento máximo permitido é de %max% símbolos.',
    'plan-item-custom.longUrl' => 'A URL é muito longa. O comprimento máximo permitido é de %max% símbolos.',
    'plan-item-custom.useCustomButton' => 'Utilize o botão personalizado para o serviço',
    'plan-item-custom.useCustomButtonHint' => 'Coloque o botão personalizado sobre a home page do utilizador e páginas da web.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Abra a URL no Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Especificar se a URL deve abrir numa página do Plesk ou numa nova janela do navegador.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Não utilizar janelas',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Se adicionar uma tecla personalizada que leve para uma extensão do Plesk ou uma aplicação no Painel de Cliente, pode definir de que forma esta extensão/aplicação deve ser apresentada: num quadro ou como parte do GUI do Plesk.',
    'plan-item-custom.includeDomId' => 'Incluir identificação da assinatura',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Incluir o nome do domínio principal',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Incluir o nome de utilizador FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Incluir a palavra-passe de FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Incluir identificação do cliente',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Incluir nome da empresa do cliente",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Incluir nome de contacto do cliente",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Incluir e-mail do cliente",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Escolha como pré-visualizar os sites',
    'preview-domain-settings.previewQuick' => 'Pré-visualização rápida predefinida',
    'preview-domain-settings.previewDisabled' => 'Desactivar Pré-visualização rápida',
    'preview-domain-settings.previewQuickDescription' => 'Uma opção recomendada, pronta para uso.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Pré-visualização rápida num nome de domínio no Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Selecione um dos seus sítios web servidos pelo Plesk para a pré-visualização.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Para utilizar este recurso, %%link%% pelo menos um domínio.',
    'preview-domain-settings.subscriptionCreateLink' => 'criar',
    'preview-domain-settings.previewZoneTypeExternal' => 'Pré-visualização Rápida no nome de domínio externo',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Utilizar um nome de domínio externo (zona DNS). Caso utilize esta opção, adicione o seguinte registo DNS (tipo A) à zona de domínio: *.<Plesk_IP>.external.dom. Aqui encontra-se o <Plesk_IP />IP do servidor Plesk, no qual os pontos (.) de IPv4 ou dois pontos (:) de IPv6 são substituidos por traços (-). Por exemplo, *.192-0-2-12.external.dom. Se o Plesk possuir mais de um IP registado, adicione um registo para cada endereço.',
    'preview-domain-settings.sitePreviewProtection' => 'Exigir autenticação',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Exigir registo e palavra-chave no FTP para aceder à pré-visualização.',
    'preview-domain-settings.nginxNotInstalled' => 'A pré-visualização rápida predefinida não está disponível porque o servidor de rede nginx não está instalado.',
    'preview-domain-settings.nginxDisabled' => 'A pré-visualização rápida predefinida não está disponível porque o servidor de rede nginx está desativado.',

    'reseller-preferences.settingsSection' => 'Configurações',
    'reseller-preferences.multiLogin' => 'Permitir diversas sessões',
    'reseller-preferences.language' => 'Língua da interface',
    'reseller-preferences.interfaceView' => 'Selecione a sua interface',
    'reseller-preferences.serviceProviderView' => 'Visualização do Service Provider',
    'reseller-preferences.serviceProviderViewHint' => 'Esta visualização destina-se a revendedores que possuem clientes. É possível gerir clientes bem como seus websites e serviços de alojamento nesta visualização.',
    'reseller-preferences.powerUserView' => 'Visualização Power User',
    'reseller-preferences.powerUserViewHint' => 'Esta visualização proporciona uma interface simples para que revendedores giram os seus próprios websites, contas de e-mail e outros serviços de alojamento. Nesta visualização não é possível gerir clientes.',

    'reseller.hint' => 'Aqui você fará o registo para um novo revendedor para os seus serviços de alojamento.',
    'reseller.contactInfoSection' => 'Informação de contacto',
    'reseller.contactInfoSectionHint' => 'Insira as informações de contacto do revendedor.',
    'reseller.accessToPanelSection' => 'Acesso ao Plesk',
    'reseller.accessToPanelSectionHint' => 'Credenciais que o revendedor utilizará para aceder ao Plesk e gerir serviços para os quais eles estão atribuídos.',
    'reseller.subscription' => 'Assinatura',
    'reseller.subscriptionSectionHint' => 'Selecione um plano de serviço para o qual o revendedor realizará a assinatura.',
    'reseller.servicePlan' => 'Plano de serviço',
    'reseller.none' => 'nenhum',
    'reseller.customizeSubscription' => 'Continuar com a personalização de parâmetros de assinatura depois de o revendedor ter sido criado. Note que tal bloqueará a sincronização da assinatura.',
    'reseller.subscriptionNotSynchronized' => 'Impossível sincronizar a assinatura com o plano de serviços. As seguintes configurações da assinatura entram em conflito com o plano de serviços: %%problems%%.',

    'security-policy.encryptionSection' => 'Modo de segurança melhorado',
    'security-policy.encryptionSectionHint' => 'O modo de segurança melhorado introduz uma proteção avançada dos dados sensíveis no Plesk. Neste modo, o Plesk emprega múltiplos mecanismos de segurança absolutamente transparentes para os utilizadores do Plesk. Para melhorar a segurança do Plesk, recomendamos que deixe este modo ativo.',
    'security-policy.encryptionEnable' => 'Modo de segurança melhorado',
    'security-policy.securePassword' => 'Modo de segurança melhorado',
    'security-policy.strengthSection' => 'Resistência da palavra-passe',
    'security-policy.strengthSectionHint' => 'Quando os usuários definem uma nova senha no sistema (criam uma nova senha ou alteram uma senha existente), eles precisam ajustar a senha de acordo com a força mínima necessária para a página especificada. A força de uma senha é calculada com base em seu comprimento e complexidade totais (uso de números, caracteres minúsculos e maiúsculos e caracteres especiais). Recomendamos que você force seus usuários a utilizarem senhas mais fortes.',
    'security-policy.passwordStrength' => 'Palavra-passe fraca',
    'security-policy.passwordStrengthVeryWeakHint' => 'Disse passordene er vanligvis korte og bruker bare én tegntype (store eller små bokstaver eller tall). Exemplo:passord. Dette sikkerhetsnivået forhindrer de enkleste passordgjetting angrep.',
    'security-policy.passwordStrengthWeakHint' => 'Essas senhas são geralmente curtas e utilizam em sua maior parte um tipo de caractere (caracteres minúsculos, maiúsculos ou números) com alguns caracteres de outro tipo. Exemplo:password12. Essas senhas proporcionam proteção básica contra advinhações de senha.',
    'security-policy.passwordStrengthMediocreHint' => 'Estas palavras-passe são geralmente curtas e contêm carateres de pelo menos dois tipos (carateres maiúsculos ou minúsculos, números ou carateres especiais). Exemplo:Password12. Tais senhas proporcionam proteção confiável contra ataques que capturam senhas.',
    'security-policy.passwordStrengthStrongHint' => 'Estas palavras-passe contêm, pelo menos, 8 carateres e incluem várias ocorrências de carateres maiúsculos e minúsculos, números e carateres especiais. Exemplo:P@ssw0rd12. Tais senhas proporcionam forte proteção contra ataques.',
    'security-policy.passwordStrengthStrongerHint' => 'Estas palavras-passe contêm, pelo menos, 16 carateres e incluem várias ocorrências de carateres maiúsculos e minúsculos, números e carateres especiais. Exemplo:~!my_P@$$w0rD123. Tais senhas proporcionam a melhor proteção possível, mas são de difícil memorização.',
    'security-policy.secureFtpSection' => 'FTP Seguro',
    'security-policy.ftpOverSsl' => 'Política do uso do FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS é utilizado para proteger a comunicação entre o servidor FTP e clientes FTP externos usando o protocolo SSL/TLS. Aqui você pode selecionar quais tipos de ligações devem ser permitidas.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS é utilizado para proteger a comunicação entre o servidor FTP e clientes FTP externos usando o protocolo SSL/TLS. Aqui você pode selecionar quais tipos de ligações devem ser permitidas. A opção selecionada será aplicada a todos os endereços IP no servidor. Para utilizar configurações padrão para cada endereço IP, selecione a opção correspondente e altere a política FTPS em Ferramentas & Configurações > Endereços IP.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS é utilizado para proteger a comunicação entre o servidor FTP e clientes FTP externos usando o protocolo SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS é utilizado para proteger a comunicação entre o servidor FTP e clientes FTP externos usando o protocolo SSL/TLS. Caso queira ajustar as configurações de FTPS por endereço IP, selecione primeiro a opção "Utilize configurações de FTPS para cada endereço IP" em Ferramentas & Configurações > Política de Segurança > FTP Seguro.',
    'security-policy.ftpOverSslOptionRequired' => 'Permite apenas ligações FTPS seguras',
    'security-policy.ftpOverSslOptionEnabled' => 'Permite ligações FTPS seguras e não seguras',
    'security-policy.ftpOverSslOptionDisabled' => 'Permite apenas ligações FTP não seguras. Não utilizar FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Utilize a política FTPS padrão para cada endereço IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Política de processadores personalizados',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Ative essa opção para proibir os clientes de ignorarem os manipuladores IIS definidos a nível do servidor através do ficheiro web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Proibir a capacidade de substituir os manipuladores através de web.config',

    'service-instance.setup-instance.resourcesSection' => 'Recursos Necessários',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Já instalado',
    'service-instance.setup-instance.requirementsSection' => 'Serviços Necessários',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'Não selecionado',

    'service-node.ipAddress' => 'Endereço IP do nó de serviço',
    'service-node.ipAddressLocal' => 'Nó de serviço local',
    'service-node.description' => 'Descrição do nó de serviço',
    'service-node.accessKey' => 'Palavra-passe',
    'service-node.useAccessKey' => 'Utilize a autenticação',
    'service-node.useAccessKeyDescription' => 'Dica sobre o uso da autenticação.',
    'service-node.oldAccessKey' => 'Palavra-passe antiga',
    'service-node.newAccessKey' => 'Nova palavra-passe',
    'service-node.noAccessKeySpecified' => 'Palavra-passe não especificada',

    'service-plan.admin-plan.subscription_section' => 'Comum',
    'service-plan.admin-plan.tools_section' => 'Ferramentas & Recursos',
    'service-plan.admin-plan.apps_section' => 'Aplicações e bases de dados',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Aparência do Plesk',
    'service-plan.admin-plan.statistics_section' => 'Estatísticas',
    'service-plan.admin-plan.general_section' => 'Geral',
    'service-plan.admin-plan.mail_section' => 'Correio',
    'service-plan.admin-plan.server_section' => 'Servidor',
    'service-plan.admin-plan.modules_section' => 'Extensões',
    'service-plan.admin-plan.simplePanel' => 'Modo restrito',
    'service-plan.admin-plan.enabled' => 'Ativar modo restrito',
    'service-plan.admin-plan.enabledDescription' => 'Selecione esta opção para limitar o número de ações que o administrador pode realizar no Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Selecione esta opção para limitar o número de ações que o administrador pode admitir no Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Fornecer apenas aplicações selecionadas por mim',
    'service-plan.applications-subscription.useFilterDescription' => 'Utilize esta opção para selecionar as aplicações que deverão estar disponíveis para o assinante.',
    'service-plan.applications-subscription.applications' => 'Aplicações',
    'service-plan.applications-subscription.isCommercial' => 'Esta aplicação é comercial e uma chave de licença deverá ser adquirida.',

    'service-plan.applications.useFilterLabel' => 'Fornecer apenas aplicações selecionadas por mim',
    'service-plan.applications.useFilterDescription' => 'Utilize esta opção para selecionar as aplicações que deverão estar disponíveis para os assinantes.',
    'service-plan.applications.applications' => 'Aplicações',
    'service-plan.applications.isCommercial' => 'Esta aplicação é comercial e uma chave de licença deverá ser adquirida.',

    'service-plan.dns.dnsZoneType' => 'Zona de DNS do domínio',
    'service-plan.dns.dnsZoneTypeMaster' => 'Mestre',
    'service-plan.dns.dnsZoneTypeSlave' => 'Escravo',

    'service-plan.extras.groupOtherServices' => 'Outros serviços',
    'service-plan.extras.none' => 'Nenhum',

    'service-plan.hosting.enablePhysicalHosting' => 'Alojamento é permitido',
    'service-plan.hosting.sectionCoreHosting' => 'Propriedades Gerais',
    'service-plan.hosting.sectionScripting' => 'Scripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Servidor de Base de Dados Padrão',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avançado',
    'service-plan.hosting.phpSettingsHelpLink' => 'Saiba como escolher as configurações PHP adequadas',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Estado de páginas web nesta assinatura estão suspensos',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Estado de páginas web em assinaturas suspensas',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'O estado selecionado será aplicado a todos os sites que tenham a assinatura do plano quando esta for suspensa (por exemplo, quando ela expira ou o período de pagamento expira).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'O estado selecionado será aplicado a todos os sites quando a assinatura for suspensa (por exemplo, quando ela expira ou o período de pagamento expira).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Desativado',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Visitantes de sites serão redirecionados para a página padrão do servidor da web.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Suspenso',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Visitantes de sites serão redirecionados com o código HTTP 503 de pesquisas para a página do documento de erro personalizada.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Ativo',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Sites continuarão acessíveis pela Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Endereços IP partilhados alocados',
    'service-plan.ip.allocateExclusiveIp' => 'Endereços IP dedicados alocados',
    'service-plan.ip.allocateExclusiveIpV4' => 'Endereços IPv4 dedicados alocados',
    'service-plan.ip.allocateExclusiveIpV6' => 'Endereços IPv6 dedicados alocados',

    'service-plan.mail.mailService' => 'Ativar o serviço de correio',
    'service-plan.mail.webMail' => 'Correio',
    'service-plan.mail.mailingLists' => 'Ativar listas de envio',
    'service-plan.mail.mailToNonExistentUser' => 'Política sobre correios para utilizadores não-existentes',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Devolver incluindo mensagem',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Enviar para endereço determinado',
    'service-plan.mail.mailToNonExistentUserReject' => 'Rejeitar',
    'service-plan.mail.mailAutodiscovery' => 'Ativar deteção automática de e-mail.',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Veja como funciona numa <a href="%%link%%" target="_blank">base de conhecimento</a>',
    'service-plan.mail.bounceMessage' => 'Este endereço não aceita mais correio.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Redirecionar para um servidor de correio externo com o endereço IP',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - desativado',

    'service-plan.misc.retainEnabled' => 'Reter estatísticas de tráfego e Web por',
    'service-plan.misc.logRotation' => 'Rotação de Log',
    'service-plan.misc.logRotationCondition' => 'Condição de rotação de registo',
    'service-plan.misc.logRotationBySize' => 'Por tamanho',
    'service-plan.misc.logRotationByTime' => 'Por tempo',
    'service-plan.misc.logRotationDaily' => 'Diariamente',
    'service-plan.misc.logRotationWeekly' => 'Semanalmente',
    'service-plan.misc.logRotationMonthly' => 'Mensalmente',
    'service-plan.misc.logRotationSizeDescription' => 'Valor do tamanho deve estar entre %%min%% e %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Número máximo de ficheiros de registo',
    'service-plan.misc.compress' => 'Comprimir ficheiros de log',
    'service-plan.misc.sendLogToEmail' => 'Depois de o Plesk recuperar dados dos ficheiros de registos da web e servidores FTP, envie um e-mail com os registos para este endereço.',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'meses',
    'service-plan.misc.logRotationPeriodGreater' => 'O período de rotação do registo não pode ser maior do que o limite de todo o servidor %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Se desligado, todas as páginas web de uma subscrição usam o mesmo conjunto de aplicações IIS dedicado à subscrição.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Seleciona serviços e privilégios fornecidos com a assinatura.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Exibe mais permissões disponíveis',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Apresentar menos permissões',
    'service-plan.permissions-subscription.noShellManagement' => 'Não permitida',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Capacidade de gestão do acesso ao sistema',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Permite que os clientes mudem SSH no seu utilizador de sistema. Faz o parâmetro de alojamento "Acesso SSH ao shell do servidor na assinatura do utilizador de sistema" agir como predefinição.',

    'service-plan.permissions.permissionsTabDescription' => 'Seleccione os serviços e permissões facultadas com o plano.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Selecionar serviços e privilégios que serão adicionados às assinaturas com este plano de complemento. As permissões não selecionadas no plano e complemento não modificarão os parâmetros de assinatura de nenhuma forma.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'As permissões permitem que os clientes modifiquem definições específicas das suas subscrições. Quando uma subscrição é criada, o Plesk aplica os valores predefinidos do plano às definições que o cliente pode modificar. Posteriormente, atualizar o plano ou aplicar um plano suplementar não substitui alterações efetuadas pelo cliente.',
    'service-plan.permissions.showMorePermissions' => 'Exibe mais permissões disponíveis',
    'service-plan.permissions.hideMorePermissions' => 'Apresentar menos permissões',
    'service-plan.permissions.noShellManagement' => 'Não permitida',
    'service-plan.permissions.systemAccessLabel' => 'Gestão do acesso ao servidor através de SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Faz o parâmetro de alojamento SSH aceder ao shell do servidor sob o utilizador do sistema da assinatura agindo como predefinido.',

    'service-plan.resources-subscription.overusePolicy' => 'Politica de sobre-utilização',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'A sobre-utilização não é permitida',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Não permite a sobre-utilização de recursos. Uma assinatura é automaticamente suspensa se o uso de recursos excede os valores de limite.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'É permitida a sobre-utilização de espaço em disco e tráfego',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Permite a sobre-utilização do espaço em disco e tráfego. Não permite a sobre-utilização de outros recursos.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Sobre-utilização é permitida (não recomendado)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Permite que o assinante utilize mais recursos do que inicialmente fornecido com a assinatura.',
    'service-plan.resources-subscription.overuseNotify' => 'Notifique-me por e-mail em caso de sobre-utilização.',
    'service-plan.resources-subscription.oversellPolicy' => 'Política de venda excessiva',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'A  venda excessiva é permitida',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'A venda excessiva permite que um revendedor venda mais recursos do que lhes são alocados com uma assinatura. Se a venda excessiva for permitida, um revendedor será controlado pelo uso de recurso atual, ao contrário da alocação de recurso inicial.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'A venda excessiva não é permitida',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Se a venda excessiva não for permitida, um revendedor pode vender apenas a quantidade de recursos alocadas inicialmente a ele com uma assinatura, independentemente do quanto destes recursos são atualmente utilizados.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Define limites de uso de recursos fornecidos com a assinatura.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Exibe mais recursos disponíveis',
    'service-plan.resources-subscription.hideMoreResources' => 'Exibe menos recursos',

    'service-plan.resources.overusePolicy' => 'Politica de sobreutilização',
    'service-plan.resources.overusePolicyNotAllowed' => 'A sobre-utilização não é permitida',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Não permitir a sobreutilização de recursos. Uma assinatura é automaticamente suspensa se a utilização de recursos exceder os valores limite.',
    'service-plan.resources.overusePolicySoftAllowed' => 'A sobreutilização de espaço em disco e de tráfego é permitida',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Permite a sobre-utilização do espaço em disco e tráfego. Não permite a sobre-utilização de outros recursos.',
    'service-plan.resources.overusePolicyAllowed' => 'Sobre-utilização é permitida (não recomendado)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Permite que os clientes utilizem mais recursos do que inicialmente fornecido pelo plano.',
    'service-plan.resources.overuseNotify' => 'Avisar-me por email em caso de sobreutilização.',
    'service-plan.resources.oversellPolicy' => 'Política de venda excessiva',
    'service-plan.resources.oversellPolicyAllowed' => 'A  venda excessiva é permitida',
    'service-plan.resources.oversellPolicyAllowedHint' => 'A venda excessiva permite que um revendedor venda mais recursos do que lhes são alocados com um plano. Se a venda excessiva for permitida, um revendedor será controlado pelo uso de recurso atual, ao contrário da alocação de recurso inicial.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'A venda excessiva não é permitida',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Se a venda excessiva não for permitida, um revendedor pode vender apenas a quantidade de recursos alocadas inicialmente a ele com um plano, independentemente do quanto destes recursos são atualmente utilizados.',
    'service-plan.resources.mainGroupTitle' => 'Definir os recursos fornecidos com o plano.',
    'service-plan.resources.additionalGroupTitle' => 'Exibe mais recursos disponíveis',
    'service-plan.resources.hideMoreResources' => 'Exibe menos recursos',
    'service-plan.resources.allowSitebuilderUpsell' => 'Permite que o cliente crie sites de teste Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Esta configuração permite que o cliente crie mais sites no Presence Builder do que é fornecido no plano de serviço. O cliente terá que adquirir estes sites para publicá-los.',

    'service-plan.servicePlanName' => 'Nome do plano de serviço',
    'service-plan.resellerPlanName' => 'Nome do plano do revendedor',
    'service-plan.addonPlanName' => 'Nome do plano de complemento',
    'service-plan.adminPlanPermissionsTab' => 'Ferramentas Administrativas',
    'service-plan.adminPlanPermissionsTabDescription' => 'Selecione os recursos disponíveis para o administrador quando o modo restrito estiver ativado.',
    'service-plan.hostingPermissionsTab' => 'Ferramentas de Alojamento',
    'service-plan.hostingPermissionsTabDescription' => 'Selecione as ferramentas e configurações de alojamento de rede disponíveis para o administrador na apresentação de utilizador avançado quando o modo restrito estiver ativado.',
    'service-plan.resourcesTab' => 'Recursos',
    'service-plan.resourcesTabDescription' => 'Define os recursos fornecidos com o plano e as políticas de uso de recursos.',
    'service-plan.subscriptionResourcesTabDescription' => 'Define os recursos fornecidos com a assinatura e as políticas de uso de recursos.',
    'service-plan.hostingTab' => 'Parâmetros de alojamento',
    'service-plan.hostingTabDescription' => 'Especificar parâmetros do serviço de alojamento fornecidos com o plano. Repare que as configurações de hospedagem especificadas no plano de add-on não são aplicadas às assinaturas que receberam a permissão da "Gestão das configurações de hospedagem", seja pelo plano de serviço ou pelo plano de add-on.',
    'service-plan.secureSettingsDescription' => 'Caso queira que o alojamento fornecido seja mais seguro, %%link%%. Algumas destas permissões, se concedidas, permitem que os assinantes alterem estas configurações. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'aplicar predefinições de configurações seguras',
    'service-plan.secureSettingsHelpLink' => 'Aprenda sobre as configurações de alojamento seguras',
    'service-plan.mailTab' => 'Correio',
    'service-plan.mailTabDescription' => 'Especificar parâmetros do serviço de correio fornecidos com o plano.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Especificar parâmetros do serviço DNS fornecidos com o plano.',
    'service-plan.performanceTab' => 'Desempenho',
    'service-plan.performanceTabDescription' => 'Especifica os parâmetros do sistema afetando o desempenho de todos os serviços fornecidos com o plano.',
    'service-plan.permissionsTab' => 'Permissões',
    'service-plan.miscTab' => 'Logs & Estatísticas',
    'service-plan.miscTabDescription' => 'Especifica como estatísticas e logs das assinaturas do plano devem ser armazenados. Estas configurações não sincronizam nas assinaturas.',
    'service-plan.miscTabAdminPlanDescription' => 'Especificar como devem ser armazenadas as estatísticas e registos das assinaturas.',
    'service-plan.extrasTab' => 'Serviços adicionais',
    'service-plan.extrasTabDescription' => 'Selecione os serviços que devem ser incluídos no plano, além dos serviços de web hosting, DNS e correios.',
    'service-plan.ipTab' => 'Endereços IP',
    'service-plan.ipTabDescription' => 'Definir parâmetros de recursos de IP fornecidos com o plano.',
    'service-plan.applicationsTab' => 'Aplicações',
    'service-plan.applicationsTabDescription' => 'Selecione as aplicações que deverão estar disponíveis no plano. Você pode escolher fornecer todas as aplicações disponíveis do Catálogo de Aplicações, além daqueles já transferidos para o servidor, ou selecioná-los manualmente. Caso queira fornecer todas as aplicações disponíveis, não há a necessidade de fazer nada neste separador, vá apenas ao separador Permissões e selecione a opção Acesso ao Catálogo de Aplicações. Caso queira selecionar as aplicações manualmente, pode fazer isso neste separador.',
    'service-plan.applicationsTabDescription-addon' => 'Selecione as aplicações que deverão estar disponíveis no plano de complemento.',
    'service-plan.applicationsTabDescription-subscription' => 'Selecione as aplicações que deverão estar disponíveis na assinatura. Você pode escolher para fornecer todas as aplicações disponíveis do Catálogo de Aplicações, além daquelas já transferidas para o servidor, ou selecioná-las manualmente. Caso queira fornecer todas as aplicações disponíveis, não há a necessidade de fazer nada neste separador, vá apenas ao separador Permissões e selecione a opção Acesso ao Catálogo de Aplicações. Caso queira selecionar as aplicações manualmente, pode fazer isso neste separador.',
    'service-plan.planSyncSubsriptionWarning' => 'Algumas assinaturas não estão sincronizadas com o plano. Elas foram marcadas como \'Não sincronizadas\' na lista de assinaturas. Para tentar a sincronização novamente, vá à página geral da assinatura e clique no botão "Sync".',
    'service-plan.planSyncResellerWarning' => 'Alguns revendedores não estão sincronizados com o plano. Eles foram marcados como \'Não sincronizados\' na lista de revendedores. Para tentar a sincronização novamente, vá à página geral do revendedor e clique no botão \'Sync\'.',
    'service-plan.planSyncAdminWarning' => 'Impossível aplicar as alterações às assinaturas porque o Plesk não fornece alguns dos serviços ou recursos afetados por estas alterações. Razão: %%reason%%',
    'service-plan.duplicateName' => 'Já existe um plano com esse nome.',
    'service-plan.phpSettingsTab' => 'Definições PHP',
    'service-plan.phpSettingsTabDescription' => 'Aqui pode especificar definições PHP por assinatura que substituem as definições do ficheiro php.ini comum ao servidor. Isto pode ser útil, por exemplo, quando você deseja limitar o consumo de recursos do sistema através dos scripts PHP dos clientes. Os clientes (se for permitido) podem substituir essa configuração do PHP pela sua própria configuração por domínio. Ao definir um parâmetro para o valor Padrão, o PHP utilizará este valor a partir das configurações PHP em todo o servidor. Note-se que os seguintes espaços reservados são suportados: {DOCROOT} e {WEBSPACEROOT} significam o diretório de raiz do documento de um domínio e o diretório de raiz de uma assinatura com configuração PHP personalizada; {TMP} significa o diretório que armazena os ficheiros temporários.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Aqui pode especificar definições PHP por assinatura, sendo que estas anulam as definições do plano de serviço principal. Isto pode ser útil, por exemplo, quando desejar remover algumas limitações de PHP definidas no plano de serviço principal. Ao definir um parâmetro para o valor Padrão, o PHP utilizará este valor a partir das configurações PHP do plano de serviço. Note-se que os seguintes espaços reservados são suportados: {DOCROOT} e {WEBSPACEROOT} significam o diretório de raiz do documento de um domínio e o diretório de raiz de uma assinatura com configuração PHP personalizada; {TMP} significa o diretório que armazena os ficheiros temporários.',
    'service-plan.phpSettingsPhpVersion' => 'A sua versão atual do PHP é %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Aqui pode especificar definições PHP por assinatura que substituem as definições do ficheiro php.ini comum ao servidor. Ao definir um parâmetro para o valor Padrão, o PHP utilizará este valor a partir das configurações PHP em todo o servidor.',
    'service-plan.webServerSettingsTab' => 'Servidor de Web',
    'service-plan.webServerSettingsTabDescription' => 'Aqui pode especificar as configurações do servidor da web Apache para este plano de serviço. Se o Apache estiver a funcionar com o nginx como servidor de plano de frente, pode especificar as configurações de nginx nesta página também. Todos os domínios recentemente criados receberão as configurações especificadas. No entanto, quando altera estas configurações, os domínios existentes não receberão as mudanças.',
    'service-plan.servicesTab' => 'Serviços',
    'service-plan.servicesTabDescription' => 'Aqui pode especificar os serviços atribuídos ao plano de serviço.',
    'service-plan.servicePropertiesTab' => 'Propriedades %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Aqui você pode especificar as propriedades do serviço %%serviceName%% atribuído ao plano de serviço.',
    'service-plan.longTaskWarning' => 'Você tem %%subscriptionsCount%% assinaturas neste plano. Repare que a tarefa de sincronização pode exigir um certo tempo e será feita em segundo plano.',
    'service-plan.hostingParametersTab' => 'Parâmetros de Alojamento',
    'service-plan.adminInfoSection' => 'Informações para o administrador',
    'service-plan.descriptionInPanel' => 'Descrição',
    'service-plan.longDescription' => 'A descrição especificada é muito longa.',
    'service-plan.conflictPermissions' => 'Não é possível conceder as seguintes permissões porque estão em conflito com o plano de revendedor: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Tipo de inicialização',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automático',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manual',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Desligar',
    'services.change-startup-type.autoActionError' => 'Não é possível definir tipo de inicialização para \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Impossível definir o tipo de inicialização para \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Impossível definir o tipo de inicialização para \'disabled\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Repor predefinição',
    'sessions.settings.restoreDefaultButtonDescription' => 'Restaurar parâmetros de sessão para os valores padrão.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Os parâmetros de sessão possuem valores predefinidos.',
    'sessions.settings.idleTime' => 'Tempo de sessão ocioso',
    'sessions.settings.disableCheckSessionIp' => 'Permitir mudanças de endereço IP durante uma única sessão',
    'sessions.settings.minuteShortTitle' => 'min',

    'settings-ui.controls.title' => 'Controlos',

    'settings-ui.interface-views.description' => "Existem diversas visualizações de IU de produto disponíveis. Dependendo da visualização que utilizar as funcionalidades e definições podem estar localizadas em diferentes locais ou mesmo ativadas/desativadas. Diferentes visualizações são mais adequadas a diferentes tipos de utilizadores.",
    'settings-ui.interface-views.panelSimpleLink' => 'Ferramentas e Configurações> Definições de modo restrito',
    'settings-ui.interface-views.useCustomView' => 'Ativar modo restrito',
    'settings-ui.interface-views.useCustomViewHint' => 'Selecione esta opção para limitar o número de ações que o administrador pode admitir no painel do Plesk. Para alterar a disponibilidade das ações, vá para %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => "Esta visualização destina-se a ativar uma interface única simplificada para administradores de servidores para gerirem os seus próprios websites, contas de email e outros serviços",
    'settings-ui.interface-views.selectUiModeTitle' => "Selecione a sua interface",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Visualização Power User",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Visualização Service Provider",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "Esta visualização oferece interfaces para utilização pelo administrador do servidor, revendedores e utilizadores finais do alojamento.",

    'sitebuilder.trial.description' => 'Esta página permite que você configure o modo Try and Buy (anterior Cenário de Aquisição do Cliente). Neste modo, o cliente pode criar um site com toda a funcionalidade disponível na aplicação do SiteBuilder. No entanto, publicar sites de teste não está disponível para clientes até que eles adquiram um plano de serviço de alojamento ou um plano de complemento. O modo Try and Buy também pode ser concedido aos seus clientes já existentes através de um plano de alojamento ou de complemento. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Verifique a documentação para mais informações.',
    'sitebuilder.trial.lifetimeLabel' => 'Duração do site de teste',
    'sitebuilder.trial.lifetimeUnits' => 'dias',
    'sitebuilder.trial.lifetimeDescription' => 'Este é o tempo que deverá passar antes que os sites de teste que não foram adquiridos pelos clientes sejam removidos do servidor.',
    'sitebuilder.trial.signupLabel' => 'Permita o acesso público ao modo de teste',
    'sitebuilder.trial.signupDescription' => 'Caso queira atrair clientes através do alojamento de propagandas com o SiteBuilder e fornecendo uma cópia demo do mesmo para eles, permita o acesso público ao modo de teste e publique a URL de acesso ao modo de teste no seu site.',
    'sitebuilder.trial.signupLinkLabel' => 'URL de acesso ao modo de teste',
    'sitebuilder.trial.signupLinkDescription' => 'Esta URL abrirá o SiteBuilder no modo de teste. Publique esta URL no seu site para que o alojamento tenha a publicidade do SiteBuilder e atraia clientes.',
    'sitebuilder.trial.promotionLabel' => 'Exibe notificações do modo de teste no editor do SiteBuilder',
    'sitebuilder.trial.promotionDescription' => 'Utilize esta opção se quiser exibir notificações adicionais sobre o trabalho como SiteBuilder no modo de teste.',

    'update-settings.policyHintForPum' => 'Pode configurar a instalação automática de atualizações aqui. O email de notificação pode ser enviado quando as atualizações estão disponíveis para instalação manual ou instalação automática.',
    'update-settings.policyHint' => 'O email de notificação pode ser enviado quando as atualizações estão disponíveis para instalação manual ou instalação automática.',
    'update-settings.branchDisabledDescription' => 'Não notifique-me sobre atualizações disponíveis',
    'update-settings.automaticPatchesInstallation' => 'Instalar automaticamente as atualizações do Plesk (recomendado)',
    'update-settings.automaticPatchesInstallationHint' => 'Atualizações críticas de segurança são sempre instaladas automaticamente.',
    'update-settings.automaticPatchesThirdParty' => 'Instalar automaticamente atualizações para componentes de terceiros fornecidos pelo Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Instalar automaticamente atualizações de pacotes do sistema',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Note que tal instalará também automaticamente as atualizações para componentes de terceiros fornecidos pelo Plesk',
    'update-settings.automaticPatchesNotification' => 'Notificar sobre atualizações ao pacote disponíveis e instaladas',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Endereço de e-mail',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Frequência de e-mail de notificação',
    'update-settings.daily' => 'Diariamente',
    'update-settings.weekly' => 'Semanal',
    'update-settings.generalSection' => 'Geral',
    'update-settings.notificationsSection' => 'Notificações',
    'update-settings.safeUpdatesSection' => 'Atualizações de segurança',
    'update-settings.safeUpdatesSectionHint' => 'O Plesk certifica-se que as atualizações de pacotes do sistema são instaladas a partir do mesmo repositório de onde os pacotes foram inicialmente instalados. Essas atualizações são considerados seguras. Se desativar as atualizações de segurança, o seu gestor de pacotes de sistema poderá instalar atualizações de qualquer repositório no sistema.',
    'update-settings.safeUpdatesSectionWarn' => 'Recomendamos que deixe as atualizações de segurança ativadas a menos que seja um utilizador avançado. As atualizações indiscriminadas de pacotes de sistema de repositórios diferentes podem afetar negativamente o funcionamento do seu servidor.',
    'update-settings.allowSafeUpdates' => 'Ativar as atualizações de segurança para pacotes de sistema',

    'requiredFields' => 'Campos obrigatórios',
];