<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream ha enviat una capçalera massa gran mentre responia a la capçalera de la resposta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "Error intern del servidor 500: aquí no es permet l\'opció FollowSymLinks"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "el servidor ha assolit l\'opció max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Símptomes</h4><ul><li><p>Aquells llocs web que tenguin el controlador PHP configurat com <strong>aplicació FPM servida per Apache</strong> o bé <strong>aplicació FPM servida per nginx</strong> a <strong>Dominis</strong> &gt; <strong>example.com</strong> &gt; <strong>Configuració PHP</strong> experimenten un dels següents problemes:</p><ul><li><p>càrrega lenta</p></li><li><p>no accessible (de forma permanent o periòdica) amb un error 50x a un navegador web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>A l\'arxiu de registre d\'errors de PHP-FPM apareix el següent missatge <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (on <em>XX</em> és la versión de PHP emprada pels llocs web):</p><pre>ADVERTENCIA: el servidor [pool example.com] ha assolit l\'opció max_children (*), consideri incrementar-la</pre><ul><li><p>El missatge que es mostra a dalt sol anar acompanyat del següent error:</p><pre>no ha estat possible llegir allò que diu el secundari: descriptor d\'arxiu incorrecte (9)</pre></li></ul></li><li><p>Si al servidor s\'ha activat nginx, és possible que el següents missatges d\'error apareixin a l\'arxiu de registre d\'errors del domini <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>El <code>pm.max_children</code> de PHP-FPM ha estat assolit pel(s) lloc(s) web.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Incrementi el límit <code>pm.max_children</code> pels dominis afectats:</p><ol><li><p>Connecti\'s al servidor Plesk mitjançant <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Trobi els dominis afectats emprant la següent ordre:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Nota:</strong> el número a l\'esquerra indica quants cops el lloc web ha assolit el límit <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Accedeixi a Plesk</a>.</p></li><li><p>Vagi a <strong>Dominis</strong> &gt; <strong>example.com</strong> &gt; <strong>Configuració PHP</strong> &gt; <strong>Configuració PHP-FPM</strong>.</p></li><li><p>Incrementi el valor <code>pm.max_children</code> pel dominio i apliqui els canvis. Incrementi aquest valor per tots els dominis detallats al pas 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Massa arxius oberts"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx no pot iniciar-se o tornar-se a carregar en un servidor Plesk, ja que hi ha massa arxius oberts</p><h4>Símptomes</h4><ul><li><p>El servei nginx no pot iniciar-se o tornar-se a carregar a causa del següent error a l\'arxiu <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>No és possible accedir a alguns o a tots els llocs web</p></li><li><p>L\'advertència es mostra a <strong>Eines i configuració &gt; Diagnosticar i reparar</strong>:</p><pre style="white-space: pre-wrap;">Al comprovar el valor ULIMIT de nginx es van trobar N dominis al servidor. És possible que existeixi un problema amb el límit predeterminat de nginx pel que fa als arxius oberts</pre></li><li><p>Les aplicacions web NodeJS i Ruby mostren l\'error 502 Bad Gateway quan es duen a terme algunes tasques de Plesk, com per exemple la creació de dominis, subscripcions, canvis a Apache o Nginx, etc:</p><pre style="white-space: pre-wrap;">Error del servidor<br>502 Bad Gateway <br>El servidor web ha rebut una resposta no vàlida quan actuava com a passarel·la o servidor proxy.</pre></li><li><p>Un cop <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instal·lat un nou certificat pel domini</a>, el certificat anterior encara es mostra a un navegador web, si bé el certificat correcte es troba seleccionat a la pàgina <strong>Dominis &gt; example.com &gt; Configuració de hosting</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>El host virtual de nginx obre 4 arxius de registre para cada host virtual amb hosting físic:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>És per aquest motiu que s\'excedeix la quantitat màxim d\'arxius oberts per part del servidor nginx a causa de la gran quantitat de dominis (generalment més de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Advertència:</strong> L\'execució de l\'utilitat <code>websrv_ulimits</code> sense l\'opció <strong>--no-restart</strong> inicia la reacreació d\'arxius de configuració web per tots els dominis, el que pot ocasionar un temps d\'interrupció significatiu en cas d\'allotjar una gran quantitat de llocs web.<br><br>Executi l\'ordre durant la franja horària del manteniment.</div><p>Un bona pràctica és establir un valor límit d\'arxius oberts superior a la <strong>quantitat de dominios a Plesk * 16</strong>. A l\'exemple que pot veure a continuació s\'indiquen les accions necessàries per establir el límit a 4096:</p><ol><li><p>Connecti\'s al servidor a través de <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Estableixi el límit d\'arxius oberts a 4096 tant per Apache com per nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Reinicii els serveis Apache i nginx a <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Eines i configuració &gt; Gestió de serveis</strong> per així aplicar els canvis.</p></li><li><p>Comprovi que \'Max open files limit\' s\'ha aplicat correctament un cop reiniciats els serveis web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Si aquests passos no l\'ajuden a solucionar el problema, estableixi el límit a través de l\'utilitat <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Cos de la resposta massa gran"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Accés denegat amb codi 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Error intern del servidor 500: Tamany de memòria permès de XXX esgotat"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restricció open_basedir en efecte"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Prohibit AH01797: client denegat per la configuració del servidor"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "No és possible accedir a un directori de lloc web: 403 Prohibit"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "No és possible accedir a un directori de lloc web: 403 Prohibit"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "el servidor ha assolit l\'opció MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Límit de cos de petició PHP "el client pretenia enviar un cos massa gran"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Límit de cos de petició PHP "el client pretenia enviar un cos massa gran"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sessions PHP "Error intern del servidor 503" o "No s\'han pogut llegir les dades de la sessió"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Prohibit: pcfg_openfile: no ha estat possible comprovar l\'arxiu htaccess. Verifiqui que aquest es pot llegir"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];