<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Simptome</h4><ul><li><p>Site-urile care au handlerul PHP setat la <strong>Aplicația FPM de la Apache</strong> sau <strong>Aplicația FPM de la nginx</strong> în <strong>Domenii</strong> &gt; <strong>exemplu.ro</strong> &gt; <strong>Setări PHP</strong> se confruntă cu una dintre următoarele probleme:</p><ul><li><p>se încarcă încet</p></li><li><p>sunt inaccesibile (continuu sau ocazional) cu eroare 50x în browser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Următorul mesaj apare în jurnalul de erori PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (unde <em>XX</em> este versiunea de PHP folosită de site-uri):</p><pre>AVERTIZARE: [pool exemplu.ro] server reached max_children setting (*), luați în calcul mărirea setării</pre><ul><li><p>De obicei, mesajul de mai sus este însoțit de următoarea eroare:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Dacă nginx este activat pe server, în jurnalul de erori al domeniului poate apărea unul dintre următoarele mesaje <code>/var/www/vhosts/system/exemplu.ro/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> a fost atins de site(-uri).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Măriți limita <code>pm.max_children</code> pentru domeniile afectate:</p><ol><li><p>Conectați-vă la serverul Plesk prin <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Găsiți domeniile afectate, folosind comanda:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Observație:</strong> Numărul din stânga indică de câte ori a atins site-ul limita <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 exemplu.ro<br>50 exemplu.net<br>25 exemplu.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Conectați-vă la Plesk</a>.</p></li><li><p>Accesați <strong>Domenii</strong> &gt; <strong>exemplu.ro</strong> &gt; <strong>Setări PHP</strong> &gt; <strong>Setări PHP-FPM</strong>.</p></li><li><p>Măriți valoarea <code>pm.max_children</code> pentru domeniu și aplicați modificările. Măriți această valoare pentru toate domeniile menționate în pasul 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx nu pornește/nu se reîncarcă pe un server Plesk: Too many open files</p><h4>Simptome</h4><ul><li><p>Serviciul nginx nu pornește/nu se reîncarcă și apare următoarea eroare în fișierul <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Unele site-uri (sau toate) nu sunt accesibile</p></li><li><p>Apare o avertizare în <strong>Instrumente &amp; Setări &gt; Diagnosticare și reparare</strong>:</p><pre style="white-space: pre-wrap;">Se verifică valoarea nginx ULIMIT. S-au găsit N domenii pe server. Pot apărea probleme cu limita implicită de fișiere deschise în nginx</pre></li><li><p>Aplicațiile web NodeJS și Ruby afișează eroarea 502 Bad Gateway la executarea unor sarcini Plesk, cum ar fi crearea de domenii, abonamente, modificări în Apache sau Nginx etc.:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Serverul web a primit răspuns incorect în timp ce executa o funcție de gateway sau de server proxy.</pre></li><li><p>După <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instalarea unui certificat nou pentru domeniu</a>, cel vechi continuă să apară în browser, dar în pagina <strong>Domenii &gt; exemplu.ro &gt; Setări de găzduire</strong> este selectat certificatul corect.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Gazda virtuală nginx deschide 4 fișiere jurnal pentru fiecare gazdă virtuală cu găzduire fizică:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Drept urmare, numărul maxim de fișiere deschise este depășit de serverul nginx din cauza numărului mare de domenii (de obicei, peste 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Avertizare:</strong> Executarea utilitarului <code>websrv_ulimits</code> fără opțiunea <strong>--no-restart</strong> declanșează regenerarea fișierelor de configurare web pentru toate domeniile și poate duce la indisponibilitate prelungită dacă numărul de site-uri găzduite este mare.<br><br>Executați comanda în perioada de întreținere.</div><p>Este o practică bună să setați numărul limită de fișiere deschise la o valoare cel puțin mai mare decât <strong>numărul domeniilor în Plesk * 16</strong>. În exemplul de mai jos, prezentăm acțiunile necesare pentru a seta limita la 4096:</p><ol><li><p>Conectați-vă la server prin <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Setați limita de fișiere deschise la 4096, atât pentru Apache, cât și pentru nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Reporniți serviciile Apache și nginx prin <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Instrumente &amp; Setări &gt; Administrare servicii</strong> pentru a aplica modificările.</p></li><li><p>Verificați dacă s-a aplicat corect „Max open files limit”, după repornirea serviciilor web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Dacă abordarea de mai sus nu a rezolvat problema, setați limita folosind utilitarul <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sesiuni PHP "503 Internal Server Error" sau "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];