<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => '"502 Bad Gateway: upstream sent too big header while reading response header" ng nginx',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => '"500 Internal Server Error: Option FollowSymLinks not allowed here" ng Apache',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => '"Umabot ang server sa setting ng max_children" ng PHP-FPM',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Mga Sintomas</h4><ul><li><p>Mga website na may PHP handler na nakatakda bilang <strong>FPM application na inihahatid ng Apache</strong> o <strong>FPM application na inihahatid ng nginx</strong> sa <strong>Mga Domain</strong> &gt; <strong>example.com</strong> &gt; Nararanasan ng <strong>Mga Setting ng PHP</strong> ang isa sa mga sumusunod na isyu:</p><ul><li><p>mabagal mag-load</p></li><li><p>hindi naa-access (nang permanente o pana-panahon) na may 50x error sa web browser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Lumalabas ang sumusunod na mensahe sa logfile ng error ng PHP-FPM<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (kung saan ang <em>XX</em> ay isang bersyon ng PHP na ginagamit ng mga website):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>Karaniwang kasama ng mensahe sa itaas ang error na ito:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Kung naka-enable ang nginx sa server, puwedeng lumabas ang isa sa mga sumusunod na error sa logfile ng error ng domain<code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Umabot na sa <code>pm.max_children</code> ng PHP-FPM ang (mga) website.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Taasan ang limitasyong <code>pm.max_children</code> para sa mga apektadong domain:</p><ol><li><p>Kumonekta sa server ng Plesk sa pamamagitan ng <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Maghanap ng mga apektadong domain gamit ang command sa ibaba:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Tandaan:</strong> Isinasaad ng bilang sa kaliwa kung ilang beses umabot ang website sa limitasyong <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Mag-log in sa Plesk</a>.</p></li><li><p>Go to <strong>Mga Domain</strong> &gt; <strong>example.com</strong> &gt; <strong>Mga Setting ng PHP</strong> &gt; <strong>Mga Setting ng PHP-FPM</strong>.</p></li><li><p>Taasan ang value ng <code>pm.max_children</code> para sa domain at ilapat ang mga pagbabago. Taasan ang value na ito para sa lahat ng domain na nakalista sa hakbang 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => '"Too many open files" ng nginx',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Hindi nakakapagsimula/nagre-reload ang nginx sa isang server ng Plesk: Masyadong maraming nakabukas na file</p><h4>Mga Sintomas</h4><ul><li><p>Hindi nakakapagsimula/nagre-reload ang serbisyo ng nginx dahil sa sumusunod na error sa file na <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Masyadong maraming nakabukas na file)</pre></li><li><p>Hindi naa-access ang ilan o lahat ng website</p></li><li><p>Magpapakita ng babala sa <strong>Mga Tool at Setting &gt; I-diagnose at ayusin</strong>:</p><pre style="white-space: pre-wrap;">May mga nakitang domain sa server na nagsusuri ng value N ng ULIMIT ng nginx. Posibleng may problema sa default na limitasyon ng nginx para sa mga nakabukas na file</pre></li><li><p>Nagpapakita ang NodeJS at Ruby web application ng error na 502 Bad Gateway kapag nagsasagawa ng ilang gawain sa Plesk gaya ng paggawa ng mga domain, subscription, pagbabago sa Apache o Nginx, atbp:</p><pre style="white-space: pre-wrap;">Error sa Server<br>502 Bad Gateway <br>Nakatanggap ang web server ng invalid na tugon habang nagsisilbi bilang gateway o proxy server.</pre></li><li><p>Pagkatapos <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">mag-install ng bagong certificate para sa domain</a>, ipinapakita pa rin ang luma sa isang web browser, gayunpaman, napili ang tamang certificate sa page na <strong>Mga Domain &gt; example.com &gt; Mga Setting ng Pag-host</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Ang virtual host ng nginx ay nagbubukas ng 4 na file ng log para sa bawat virtual host na may pisikal na pag-host:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Bilang resulta nito, lalampas ang server ng nginx sa maximum na bilang ng mga nakabukas na file dahil sa maraming domain (karaniwang lampas 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Babala:</strong> Papasimulan ng pagsasagawa ng utility na <code>websrv_ulimits</code> nang wala ang opsyong <strong>--no-restart</strong> ang muling pagbuo ng mga file ng configuration sa web para sa lahat ng domain at puwede itong magdulot ng matagal-tagal na downtime kung sakaling maraming naka-host na website.<br><br>Isagawa ang command sa panahon ng maintenance.</div><p>Mainam na kasanayang itakda ang value ng limitasyon sa mga nakabukas na file nang lampas sa <strong>bilang ng mga domain sa Plesk * 16</strong> sa pinakamababa. Sa halimbawa sa ibaba, nagbigay ng mga pagkilos kung paano itakda ang limitasyon sa 4096:</p><ol><li><p>Kumonekta sa server sa pamamagitan ng <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Itakda ang limitasyon sa mga nakabukas na file sa 4096 para sa Apache at Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>I-restart ang serbisyo ng Apache at nginx sa <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Mga Tool at Setting &gt; Pamamahala ng Mga Serbisyo</strong> para ilapat ang mga pagbabago.</p></li><li><p>Tingnan kung nailapat nang tama ang \'Limitasyon sa max na mga nakabukas na file\', pagkatapos mag-restart ang mga serbisyo sa web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Kung hindi nakatulong ang solusyon sa itaas, itakda ang limitasyon gamit ang utility na <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => '"Response body too large" ng ModSecurity',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => '"Access denied with code 403" ng ModSecurity',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => '"Internal Server error 500: Allowed memory size of XXX exhausted" ng PHP',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => '"open_basedir restriction in effect" ng PHP',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => '"403 Forbidden AH01797: client denied by server configuration" ng .htaccess ng Apache',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => '"Cannot access a website directory in Plesk: 403 Forbidden" ng Apache',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => '"Cannot access a website directory in Plesk: 403 Forbidden" ng nginx',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => '"Server reached MaxRequestWorkers setting" ng Apache',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => '"Client intended to send too large body" ng limitasyon sa body ng kahilingan sa PHP',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => '"Client intended to send too large body" ng limitasyon sa body ng kahilingan sa PHP',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => '"503 Internal Server Error" o "Failed to read session data" ng mga session ng PHP',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => '"403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable" ng .htaccess ng Apache',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];