<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Geçersiz Ağ Geçidi: yanıt başlığı okunurken yukarı akış çok büyük başlık gönderdi"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Dahili Sunucu Hatası: FollowSymLinks seçeneğine burada izin verilmez"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "sunucu max_children ayarına ulaştı"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Belirtiler</h4><ul><li><p>PHP işleyicisinin <strong>Apache tarafından sunulan FPM uygulaması</strong> veya <strong>nginx tarafından sunulan FPM uygulaması</strong> olarak <strong>Alan adları</strong> &gt; <strong>örnek.com</strong> olan &gt; <strong>PHP Ayarları</strong> aşağıdaki sorunlardan biriyle karşılaştı:</p><ul><li><p>yavaş yüklenme</p></li><li><p>bir web tarayıcısında 50x hatasıyla erişilemiyor (kalıcı veya geçici olarak):</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>PHP-FPM hata günlüğü dosyasında şu mesaj görünüyor <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (<em>XX</em>, web siteleri tarafından kullanılan bir PHP sürümüdür):</p><pre>DİKKAT:[pool example.com] sunucusu max_children ayarına ulaştı (*), artırmayı bir düşünün</pre><ul><li><p>Yukarıdaki mesaj genelde bu hatayla birlikte görünür:</p><pre>alt nesnede yazan okunamıyor: Bozuk dosya tanımlayıcısı (9)</pre></li></ul></li><li><p>Sunucuda nginx etkinse alan adının hata günlüğü dosyasında aşağıdaki mesajlardan biri görünebilir <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock yukarı akışa bağlanırken başarısız oldu (11: Kaynak geçici olarak kullanılamaz), istemci: 203.0.113.2, sunucu: örnek.com, talep: "GET / HTTP/1.1" üst akış: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", barındıran: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 yukarı akıştan yanıt başlığı okunurken bağlantı, yukarı akış zamanından önce kapandı, istemci 203.0.113.2, sunucu: örnek.com, talep: "POST /path/to/some/file HTTP/2.0", yukarı akış:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM<code>pm.max_children</code>\'a web siteleri tarafından ulaşıldı.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Etkilenen alan adları için <code>pm.max_children</code> limitini artırın:</p><ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a> ile Plesk sunucusuna bağlanın.</p></li><li><p>Aşağıdaki kodu kullanarak etkilenen alan adlarını bulun:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Not:</strong> Soldaki kod, <code>pm.max_children</code> limitine web sitesinin kaç kez ulaşıldığını gösterir.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 örnek.com<br>50 örnek.net<br>25 örnek.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Plesk\'e giriş yapın</a>.</p></li><li><p><strong>Alan adlarına</strong> gidin &gt;<strong>örnek.com</strong> &gt; <strong>PHP Ayarları</strong> &gt; <strong>PHP-FPM Ayarları</strong>.</p></li><li><p>Alan adı için <code>pm.max_children</code> değerini artırın ve değişiklikleri uygulayın. 2. adımdaysa bu değeri tüm alan adları için artırın.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Çok fazla açık dosya var"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Bir Plesk sunucusunda nginx başlatılamadı/yeniden yüklenemedi: Çok fazla açık dosya var</p><h4>Belirtiler</h4><ul><li><p>nginx hizmeti, aşağıdaki hatadan dolayı başlatılamadı/yeniden yüklenemedi <code>/var/log/nginx/error.log</code> dosya:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: çok fazla dosya)</pre></li><li><p>Web sitelerinin bazılarına veya tümüne erişilemiyor</p></li><li><p>Uyarı, <strong>Araçlar &amp; Ayarlar &gt; Tanı &amp; tamir et</strong> seçenekleriyle görülebilir:</p><pre style="white-space: pre-wrap;">Nginx ULIMIT değeri kontrol ediliyor Sunucuda N alan adı bulundu. Açık dosyalar için nginx varsayılan sınırıyla ilgili sorun olabilir</pre></li><li><p>NodeJS ve Ruby web uygulamaları, alan adları, abonelikler, Apache veya Nginx\'te değişiklikler vb. gibi bazı Plesk görevlerini gerçekleştirirken 502 Bad Gateway hatası gösteriyor:</p><pre style="white-space: pre-wrap;">Sunucu Hatası<br>502 Bad Gateway <br>Web sunucusu, gateway veya proxy sunucusu gibi davranırken geçersiz bir cevap aldı.</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">Alan adı için yeni bir sertifika kurduktan sonra</a> eski sertifika web tarayıcısında gösterilse de doğru sertifika <strong>Alan adları &gt; örnek.com &gt; Barındırma Ayarları</strong> sayfasında gösterilir.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx\'in sanal ana bilgisayarı, fiziksel barındırma ile her sanal ana bilgisayar için 4 günlük dosyası açar:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Bu durumun bir sonucu olarak, çok sayıda alan alanı nedeniyle (genellikle 100\'den fazla) nginx sunucusu tarafından maksimum açık dosya sayısı aşılır',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Dikkat:</strong> <code>websrv_ulimits</code> yardımcı programının <strong>--no-restart</strong> seçeneği olmadan yürütülmesi, tüm alan adları için web yapılandırma dosyalarının yeniden oluşturulmasını başlatır ve çok sayıda barındırılan web sitesi olması durumunda önemli kesinti sürelerine neden olabilir.<br><br>Komutu, bakım zamanı çerçevesinde yürütün.</div><p>Açık dosya sınır değerini <strong>Plesk\'te alan sayısından</strong> daha fazla (en az 16) ayarlamak iyi bir uygulamadır. Aşağıdaki örnek, sınırın 4096\'ya nasıl ayarlanacağını gösterir:</p><ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p> ile sunucuya bağlanın. Hem Apache hem de Nginx için açık dosya limitini 4096 olarak ayarlayın:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> üzerinden Apache ve nginx hizmetlerini yeniden başlatın</strong> Değişiklikleri uygulamak için <strong>Araçlar &amp; Ayarlar &gt; Hizmet Yönetimi</strong> seçeneklerine gidin.</p></li><li><p>Web hizmetleri yeniden başlatıldıktan sonra "Maks. açık dosya limitinin" doğru şekilde uygulanıp uygulanmadığını kontrol edin:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Yukarıdaki çözüm yardımcı olmazsa <code>ulimit</code> yardımcı programını kullanarak limiti ayarlayın:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Yanıt gövdesi çok büyük"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "403 koduyla erişim reddedildi"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Dahili Sunucu hatası 500: İzin verilen bellek boyutunun XXX kadarı tükendi"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir kısıtlaması yürülükte"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: Sunucu yapılandırması tarafından istemci reddedildi"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Plesk\'teki bir web sitesinin dizinine ulaşılamıyor: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Plesk\'teki bir web sitesinin dizinine ulaşılamıyor: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "sunucu MaxRequestWorkers ayarına ulaştı"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP istek gövdesi sınırı "istemci çok büyük gövde göndermeyi amaçlıyor"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP istek gövdesi sınırı "istemci çok büyük gövde göndermeyi amaçlıyor"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP oturumları "503 Dahili Sunucu Hatası" veya "Oturum verisini okuma başarısız"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfb_openfile: htaccess dosyası kontrol edilemiyor, okunabilir olduğuna emin olun"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];