<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx „502 Hibás átjáró: Túl nagy élőlábat küldött a felsőbb szintű válasz fejléc olvasása közben.”',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache „500 Belső kiszolgáló hiba: FollowSymLinks beállítás itt nem engedélyezett.”',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM „kiszolgáló elérte a beállított max_children értéket.”',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Hibajelenségek</h4><ul><li><p>A következő beállítású PHP-kezelővel rendelkező webhelyek <strong>Apache által kiszolgált FPM alkalmazás</strong> vagy <strong>nginx által kiszolgált FPM alkalmazás</strong> <strong>domaineknél</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-beállítások esetén</strong> a következő problémák egyikét tapasztalja:</p><ul><li><p>lassú betöltés</p></li><li><p>nem érhető el (tartósan vagy időközönként) 50x hibával a webböngészőben:</p><pre>502 Hibás átjáró</pre><hr><pre>503 Ideiglenesen nem érhető el a szolgáltatás.</pre><hr><pre>504 Átjáró időtúllépés</pre></li></ul></li><li><p>A következő üzenet jelenik meg a PHP-FPM hiba naplófájlban <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (ahol <em>XX</em> a webhelyek által használt PHP-verzió):</p><pre>FIGYELMEZTETÉS: [pool example.com] kiszolgáló elérte a max_children beállítást (*), fontolja meg az emelését.</pre><ul><li><p>A fenti üzenetet általában ezen hiba kíséri:</p><pre>nem olvasható, amit a gyermek mond: Hibás fájlleíró (9)</pre></li></ul></li><li><p>Ha a kiszolgálón engedélyezve van az nginx, akkor a következő hibaüzenetek egyike jelenhet meg domain hiba naplófájljában <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 nem sikerült a kapcsolódás unix:///var/www/vhosts/system/example.com/php-fpm.sock esetén (11: Erőforrás ideiglenesen nem érhető el), amíg a felsőbb szinthez kapcsolódik, ügyfél: 203.0.113.2, kiszolgáló: example.com, kérelem: "GET / HTTP/1.1", felső szint: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", állomás: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 a felső szint idő előtt bezárta a kapcsolatot, a felsőbb szintű válasz fejléc olvasása közben, ügyfél: 203.0.113.2, kiszolgáló: example.com, kérelem: "POST /path/to/some/file HTTP/2.0", felsőbb szint:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>A webhely(ek) elérték a PHP-FPM <code>pm.max_children</code> értéket.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Increase the pm.max_children limit',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Az érintett domainek<code>pm.max_children</code> korlátjának az emelése:</p><ol><li><p>Kapcsolódás Plesk kiszolgálóhoz <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a> útján.</p></li><li><p>Az alábbi parancs segítségével keresse meg az érintett domaineket:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Megjegyzés:</strong> A bal oldali szám jelzi, hogy hányszor érte el <code>pm.max_children</code> korlátot a webhely.</div><pre style="white-space: pre-wrap;"># grep -r "kiszolgáló elérte a max_children beállítást" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Bejelentkezés a Plesk kiszolgálóba</a>.</p></li><li><p>Ugrás <strong>domainekre</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-beállítások</strong> &gt; <strong>PHP-FPM beállítások</strong>.</p></li><li><p>Növelje a domain<code>pm.max_children</code> értékét, és alkalmazza a változtatásokat. A 2. lépésben összes domain esetén növelje ezen értéket.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx „Túl sok a megnyitott fájl.”',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Nem sikerül nginx szolgáltatás indítása/újratöltése egy Plesk kiszolgálón: Túl sok fájl van megnyitva</p><h4>Hibajelenségek</h4><ul><li><p>Nem sikerül az nginx szolgáltatás indítása/újratöltése a következő hibák miatt <code>/var/log/nginx/error.log</code> fájlban:</p><pre style="white-space: pre-wrap;">nginx: [emerg] Nem sikerült () "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" megnyitása (24: Túl sok fájl van megnyitva.)</pre></li><li><p>Nem érhető el néhány vagy az összes webhely.</p></li><li><p>Figyelmeztetés jelenik meg az <strong>Eszközök és beállítások &gt; Diagnózis és javítás</strong> menüpontban:</p><pre style="white-space: pre-wrap;">Az nginx ULIMIT érték ellenőrzésekor N domain volt található a kiszolgálón. Valószínűleg a megnyitott fájlok nginx alapérelmezett korlátja miatt jelentkezik a hiba</pre></li><li><p>NodeJS és Ruby webalkamazások esetén 502 Hibás átjáró hiba jelentkezik néhány Plesk feladat végzése során, mint például domainek létrehozása, előfizetések, változtatás az Apache vagy Nginx esetén stb:</p><pre style="white-space: pre-wrap;">Kiszolgáló hiba<br>502 Hibás átjáró <br>Érvénytelen választ kapott a webkiszolgáló, amíg átjárókét vagy proxy kiszolgálóként működott.</pre></li><li><p>A <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer"> által a domain számára történt új tanúsítvány telepítését követően </a>, a régi még látható a böngészőben, azonbna a helyes tanúsítvány van kiválasztva a <strong>Domainek &gt; example.com &gt; Üzemeltetési beállítások</strong> oldalon.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Az nginx virtuális állomása 4 naplófájlt nyit meg mindegyik fizikai üzemeltetésű virtuális állomás számára:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Ennek eredményeként a domainek nagy száma (általában 100-nál több) miatt az nginx kiszolgálók túllépték a megnyitott fájlok maximális számát.</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Increase the open files limit',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Figyelmeztetés:</strong> <code>websrv_ulimits</code> segédprogram <strong>--no-restart</strong> beállítása nélküli végrehajtása valamennyi domain webkonfigurációs fájljának újraépítését kezdeményezi, és jelentős állásidőt okozhat nagy számú üzemeltetett webhely esetében.<br><br>Karbantartási időszakban hajtsa végre a parancsot.</div><p>Jó gyakorlat a megnyitott fájl korlátnak <strong> a Plesk domainjei számánál nagyobbra való beállítása * legalább 16-ra</strong>. Az alábbi példában kerül ismertetésre a korlát 4096-ra való beállítása:</p><ol><li><p>Kapcsolódás a kiszolgálóhoz <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH útján</a></p></li><li><p>A megnyitott fájl korlát 4096-ra állítása Apache és Nginx esetén:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Apache és nginx szolgáltatás újraindítása <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk helyen</a> &gt;</strong> <strong>Eszközök és beállítások &gt; Szolgáltatások kezelése</strong> a változtatások alkalmazására.</p></li><li><p>Ellenőrizze, hogy megfelelően történt-e a „Maximálisan megnyitott fájl korlát” alkalmazása a webszolgáltatások újraindítása után:</p><pre># grep „Megnyitott fájlok maximális száma” /proc/$(cat /var/run/nginx.pid)/limits<br>4096 a megnyitott fájlok maximális száma, 4096 fájl</pre></li><li><p>Ha nem segít a fenti megoldás, akkor az <code>ulimit</code> segédprogram használatával végezz el a korlát beállítását:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity „Túl nagy a válasz szövegtörzse.”',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity „403 kóddal elutasítva a hozzáférés."',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP „500-as belső kiszolgáló hiba”: Elfogyott az engedélyezett XXX memóriaméret."',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP „open_basedir korlátozás van érvényben.”',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess „403 Tiltott AH01797: a kiszolgáló elutasított az ügyfelet."',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache „Nem lehet hozzáférni a webhely könyvtárához a Plesk kiszolgálóban: 403 tiltott”',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx „Nem lehet hozzáférni a webhely könyvtárához a Plesk kiszolgálóban: 403 tiltott”',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache „kiszolgáló elérte a MaxRequestWorkers beállítást”.',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'A PHP-kérelem szövegtörzs korlátja „túl nagy szövegtörzset akar az ügyfél küldeni.”',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'A PHP-kérelem szövegtörzs korlátja „túl nagy szövegtörzset akar az ügyfél küldeni.”',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP-munkamenetek „ 503 Belső kiszolgáló hiba” vagy „Nem sikerült a munkamenet adatainak az olvasás.”',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess „403 Tiltott: pcfg_openfile: nem ellenőrizhető htaccess fájl, gondoskodjon arról, hogy olvasható legyen.”',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];