<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptom</h4><ul><li><p>Webbplatser som har PHP-hanterare inställd som <strong>FPM-applikation från Apache</strong> eller <strong>FPM-applikation från nginx</strong> i <strong>Domäner</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-inställningar</strong> uppvisar ett av följande problem:</p><ul><li><p>laddar långsamt</p></li><li><p>ej tillgängliga (permanent eller periodiskt) med 50x-fel i webbläsaren:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Följande meddelande visas i felloggfilen för PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (där <em>XX</em> är en PHP-version som används av webbplatserna):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>The message above is usually accompanied with this error:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>If nginx is enabled on the server, one of the following error messages may appear in domain\'s error logfile <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> har nåtts av webbplats(erna).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Höj gränsen pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Höj gränsen för <code>pm.max_children</code> för de påverkade domänerna:</p><ol><li><p>Anslut till Plesk-servern via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Hitta de påverkade domänerna med kommandot nedan:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Obs:</strong> Siffran till vänster anger hur många gånger gränsen för <code>pm.max_children</code> har nåtts av webbplatsen.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Logga in på Plesk</a>.</p></li><li><p>Gå till <strong>Domäner</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-inställningar</strong> &gt; <strong>PHP-FPM-inställningar</strong>.</p></li><li><p>Höj <code>pm.max_children</code>-värdet för domänen och verkställ ändringarna. Höj värdet för alla domäner som listas i steg 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx kan inte starta/ladda om på en Plesk-server: Too many open files</p><h4>Symptom</h4><ul><li><p>nginx-tjänsten kan inte starta/ladda om med följande fel i <code>/var/log/nginx/error.log</code>-filen:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Some or all websites are not accessible</p></li><li><p>Varningen visas i <strong>Verktyg &amp; inställningar &gt; Diagnostisera &amp; reparera</strong>:</p><pre style="white-space: pre-wrap;">Checking for nginx ULIMIT value N domains have been found on server. Problem with nginx default limit for open files is possible</pre></li><li><p>Webbapplikationerna NodeJS och Ruby visar 502 Bad Gateway-fel när man utför vissa Plesk-uppgifter, som att skapa domäner, prenumerationer, ändringar i Apache eller Nginx etc.:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>Efter <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">att ha installerat ett nytt certifikat för domänen</a> så visas det gamla fortfarande i webbläsaren, men rätt certifikat är valt i sidan för <strong>Domäner &gt; example.com &gt; Värdtjänstinställningar</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx virtuella värd öppnar fyra loggfiler för varje virtuell värd med fysisk värdtjänst:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Detta resulterar i att maxantalet öppna filer överskrids av nginx-servern, på grund av det höga antalet domäner (vanligtvis fler än 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Höj gränsen för öppna filer',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Varning:</strong> Att köra verktyget <code>websrv_ulimits</code> utan alternativet <strong>--no-restart</strong> påbörjar återuppbyggning av webbkonfigurationsfilerna för alla domäner och kan leda till betydande nedtid om man är värd för många webbplatser.<br><br>Kör kommandot under underhållstiden.</div><p>Det är god praxis att ställa in gränsvärdet för öppna filer till högre än <strong>antalet domäner i Plesk * 16</strong>, minst. I exemplet nedan beskrivs det hur man ställer in gränsen till 4096:</p><ol><li><p>Anslut till servern via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Ställ in gränsen för öppna filer till 4096 för både Apache och Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Starta om Apache- och nginx-tjänsterna i <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Verktyg &amp; inställningar &gt; Tjänstehantering</strong> för att verkställa ändringarna.</p></li><li><p>Kontrollera att "Max open files limit" verkställdes ordentligt efter att webbtjänsterna startat om:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Om lösningen ovan inte hjälpte, ställ in gränsen med verktyget <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP-gräns för förfrågningskropp "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP-gräns för förfrågningskropp "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP-sessioner "503 Internal Server Error" eller "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];