<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: wysłano zbyt duży nagłówek podczas odczytywania nagłówka odpowiedzi"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Wewnętrzny błąd serwera: opcja FollowSymLinks nie jest tutaj dozwolona”',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "serwer osiągnął ustawienie max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptomy</h4><ul><li><p>Witryny, które obsługują moduł obsługi PHP ustawiony jako <strong>aplikację FPM obsługiwaną przez Apache</strong> lub <strong>aplikację FPM application obsługiwaną przez nginx</strong> w <strong>Domeny</strong> &gt; <strong>example.com</strong> &gt; <strong>Ustawienia PHP</strong> doświadczają jednego z następujących problemów:</p><ul><li><p>powolne ładowanie</p></li><li><p>brak dostępności (całkowite lub okresowe) z błędem 50x w przeglądarce:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Następująca wiadomość błędu pojawia się w logach PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (gdzie <em>XX</em> jest wersją PHP używaną przez witryny):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>Wiadomość powyższa idzie zazwyczaj w parze z następującym błędem:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Jeśli nginx jest włączony na serwerze, jedna z następujących wiadomości błędu może się pojawić w dzienniku błędów domeny <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Parametr PHP-FPM <code>pm.max_children</code> został osiągnięty dla witryny lub witryn.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Increase the pm.max_children limit',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Zwiększ limit <code>pm.max_children</code> dla wybranych domen:</p><ol><li><p>Podłącz serwer Pleska przez <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Znajdź domeny dotknięte problemem, używając poniższej komendy:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Uwaga:</strong> Numer po lewej wskazuje, ile razy limit <code>pm.max_children</code> został osiągnięty przez witrynę.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Zaloguj się do Pleska</a>.</p></li><li><p>Przejdź do <strong>Domeny</strong> &gt; <strong>example.com</strong> &gt; <strong>Ustawienia PHP</strong> &gt; <strong>Ustawienia PHP-FPM</strong>.</p></li><li><p>Zwiększ wartość <code>pm.max_children</code> dla domeny i zastosuj zmiany. Zwiększ tę wartość dla wszystkich domen z listy kroku nr 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Za dużo otwartych plików"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx nie był w stanie uruchomić lub przeładować serwera Plesk: Zbyt dużo otwartych plików</p><h4>Symptomy</h4><ul><li><p>Usługa nginx nie uruchomiła się z następującym błędem w pliku <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Niektóre lub wszystkie witryny przestały być dostępne</p></li><li><p>Ostrzeżenie jest widoczne w <strong>Narzędzia &amp; Ustawienia &gt; Diagnoza &amp; Naprawa</strong>:</p><pre style="white-space: pre-wrap;">Sprawdzanie, czy wartość ULIMIT dla N domen została osiągnięta na serwerze. Problem z domyślnym ograniczeniem nginx w zakresie liczby otwartych plików jest możliwy w tym wypadku</pre></li><li><p>Aplikacje NodeJS i Ruby pokazują błąd 502 Bad Gateway, kiedy wykonują niektóre zadania Pleska, jak na przykład tworzenie domen, subskrypcji, zmian w Apache lub Nginx, etc:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>Po <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">zainstalowaniu nowego certyfikatu dla domeny</a>, poprzedni jest wciaż widoczny w przeglądarce, chociaż właściwy certyfikat jest wybrany na stronie <strong>Domeny &gt; example.com &gt; Ustawienia Hostingu</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Wirtualny host Nginx otwiera 4 pliki logów dla każdgo wirtualnego hosta z fizycznym hostingiem:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>W rezultacie maksymalna liczba otwartych plików jest przekroczona przez serwer nginx z powodu zbyt dużej liczby domen (zazwyczaj więcej niż 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Increase the open files limit',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Uwaga:</strong> Uruchomienie <code>websrv_ulimits</code> bez opcji <strong>--no-restart</strong> zainicjuje przebudowę plików konfiguracyjnych stron dla wszystkich domen i spowoduje znaczącą przerwę w dostępie do dużej liczby hostowanych serwisów.<br><br>Wykonaj tę komendę podczas przerwy administracyjnej.</div><p>Jest dobrą praktyką, by ustawić limit otwartych plików co najmniej na większy niż <strong>liczba domen w Plesk * 16</strong>. W poniższym przykładzie pokazujemy, jak ustawić limit na 4096:</p><ol><li><p>Podłącz się do serwera przez <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Ustaw limit otwartych plików na 4096 zarówno dla Apache, jak i Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Zrestartuj Apache i nginx w <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Narzędzia &amp; Ustawienia &gt; Zarządzanie usługami</strong>, aby zastosować zmiany.</p></li><li><p>Sprawdź, czy \'Max open files limit\' został ustawiony właściwie po tym, jak usługi sieciowe zostaną zrestartowane:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Jeśli powyższe rozwiązanie nie pomoże, ustaw limit poprzez <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Za duża treść odpowiedzi"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Odmowa dostępu z kodem 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Wewnętrzny błąd serwera 500: wyczerpano dozwolony rozmiar pamięci XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "obowiązuje ograniczenie open_basedir"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: klient odrzucony przez konfigurację serwera"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Nie można uzyskać dostępu do katalogu stron internetowych w Plesku: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Nie można uzyskać dostępu do katalogu witryny w Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "serwer osiągnął ustawienie MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Limit treści żądania PHP "klient zamierza wysłać zbyt dużą treść"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Limit treści żądania PHP "klient zamierza wysłać zbyt dużą treść"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sesje PHP "503 Internal Server Error” lub "Nie udało się odczytać danych sesji"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: nie można sprawdzić pliku htaccess, upewnij się, że jest możliwy do odczytu"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];