<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptomer</h4><ul><li><p>Nettsider som har PHP-behandler angitt som <strong>FPM-applikasjon betjent av Apache</strong> eller <strong>FPM-applikasjon betjent av nginx</strong> på <strong>domener</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP -innstillinger</strong> opplever ett av følgende problemer:</p><ul><li><p>laster inn langsomt</p></li><li><p>ikke tilgjengelig (permanent eller periodisk) med en 50x-feil i en nettleser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Følgende melding vises i PHP-FPM-feilloggfilen <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (der <em>XX</em> er en PHP-versjon brukt av nettsidene):</p><pre>ADVARSEL: [pool example.com]-serveren nådde max_children setting (*). Vurder å øke den</pre><ul><li><p>Meldingen ovenfor er vanligvis ledsaget med denne feilen:</p><pre>kunne ikke lese det barnet sa: Bad file descriptor (9)</pre></li></ul></li><li><p>Hvis nginx er aktivert på serveren, kan det være at en av følgende feilmeldinger vises i feilloggfilen for domenet <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM-en <code>pm.max_children</code> er nådd av nettsiden(e).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Increase the pm.max_children limit',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Øk grensen for <code>pm.max_children</code> for de berørte domenene:</p><ol><li><p>Koble til Plesk-serveren via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Finn berørte domener ved hjelp av kommandoen nedenfor:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Merk:</strong> Tallet til venstre indikerer hvor mange ganger grensen for <code>pm.max_children</code> er nådd av nettsiden.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Logg på Plesk</a>.</p></li><li><p>Gå til <strong>Domener</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-innstillinger</strong> &gt; <strong>PHP-FPM-innstillinger</strong>.</p></li><li><p>Øk verdien for <code>pm.max_children</code> for domenet, og ta i bruk endringene. Øk denne verdien for alle domener oppført i trinn 2 .</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx fails to start/reload on a Plesk server: Too many open files</p><h4>Symptomer</h4><ul><li><p>nginx-tjenesten kan ikke starte / laste inn på nytt med følgende feil i <code>/var/log/nginx/error.log</code>-filen:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Noen av eller alle nettsidene er ikke tilgjengelig</p></li><li><p>Advarselen vises i <strong>Verktøy og innstillinger &gt; Diagnosereperasjon</strong>:</p><pre style="white-space: pre-wrap;">Sjekker om nginx ULIMIT value N-domener er funnet på serveren. Problem med nginx default limit for åpne filer er mulig</pre></li><li><p>NodeJS- og Ruby-nettapplikasjoner viser 502 Bad Gateway-feil under utførelse av noen Plesk-oppgaver som å opprette domener, abonnementer, endringer på Apache eller Nginx etc.:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Nettserveren mottok et ugyldig svar under funksjonen som en gateway eller proxy-server.</pre></li><li><p>Etter <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">å ha installert et nytt sertifikat for domenet,</a>, vises fortsatt det gamle i en nettleser, men det riktige sertifikatet er imidlertid valgt på siden <strong>Domener &gt; example.com &gt; Innstillinger for hosting</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx sin virtuelle vert åpner 4 loggfiler for hver virtuelle vert med fysisk hosting:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Som et resultat av dette, er det maksimale antallet åpnet filer overskredet av nginx-serveren på grunn av et høyt antall domener (vanligvis mer enn 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Increase the open files limit',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Advarsel:</strong> Gjennomføring av <code>websrv_ulimits</code>-verktøyet uten <strong>--no-restart</strong>-alternativet påbegynner gjenoppbygging av nettkonfigurasjonsfilene for alle domener, og kan forårsake betydelig nedetid ved hosting av et stort antall nettsider.<br><br>Utfør kommandoen under vedlikeholdstidsrammen.</div><p>En anbefalt fremgangsmåte er å angi verdien for grensen for åpne filer til mer enn <strong>antallet domener i Plesk * 16</strong> som et minimum. I eksemplet nedenfor ser du hvordan tilgjengelige handlinger settes til grense på 4096:</p><ol><li><p>Koble til serveren via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Angi grensen for åpne filer til 4096 for både Apache og Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Staert Apache- og nginx-tjenestene på nytt på <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Verktøy og innstillinger &gt; Administrasjon av tjenester</strong> for å ta i bruk endringene.</p></li><li><p>Sjekk at «Maksgrensen for åpne filer» ble tatt i bruk på riktig måte etter at nettjenestene starter på nytt:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Hvis løsningen ovenfor ikke hjalp, kan du angi grrensen ved hjelp av <code>ulimit</code>-verktøyet:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP sessions "503 Internal Server Error" or "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];