<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "Erreur 502 Passerelle incorrecte : envoi d\'un en-tête trop volumineux par upstream lors de la lecture de l\'en-tête de la réponse"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Erreur interne du serveur : Option FollowSymLinks non autorisée ici"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "paramètre max_children atteint par le serveur"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptômes</h4><ul><li><p>Les sites Web avec le gestionnaire PHP défini comme <strong>application FPM servie par Apache</strong> ou <strong>application FPM application servie par nginx</strong> sous <strong>Domaines</strong> &gt; <strong>example.com</strong> &gt; <strong>Les paramètres PHP</strong> ont l\'un des problèmes suivants :</p><ul><li><p>charge lentement</p></li><li><p>non accessible (en permanence ou temporairement) avec une erreur 50x dans un navigateur Web :</p><pre>502 Passerelle incorrecte</pre><hr><pre>503 Service temporairement indisponible</pre><hr><pre>504 Expiration de la passerelle</pre></li></ul></li><li><p>Le message d\'erreur suivant s\'affiche dans le fichier journal PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (<em>XX</em> correspond à la version PHP utilisée par les sites Web):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>Le message ci-dessus est accompagné de l\'erreur :</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>If nginx is enabled on the server, one of the following error messages may appear in domain\'s error logfile <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> a été atteint par le ou les sites Web.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Augmenter la limite pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Augmentez la limite <code>pm.max_children</code> pour les domaines concernés :</p><ol><li><p>Connectez-vous au serveur Plesk via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Trouvez les domaines concernés à l\'aide de la commande suivante :</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Remarque :</strong> le nombre à gauche indique le nombre de fois que la limite <code>pm.max_children</code> a été atteinte par le site Web.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Connectez-vous à Plesk</a>.</p></li><li><p>Allez sous <strong>Domaines</strong> &gt; <strong>example.com</strong> &gt; <strong>Paramètres PHP</strong> &gt; <strong>Paramètres PHP-FPM</strong>.</p></li><li><p>Augmentez la valeur <code>pm.max_children</code> pour le domaine et appliquez les modifications. Augmentez cette valeur pour tous les domaines répertoriés à l\'étape 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Trop de fichiers ouverts"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx ne parvient pas à démarrer/se recharger sur un serveur Plesk : trop de fichiers ouverts</p><h4>Symptômes</h4><ul><li><p>Le service nginx ne parvient pas à démarrer/se recharger et le fichier <code>/var/log/nginx/error.log</code> contient l\'erreur suivante :</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24 : trop de fichiers ouverts)</pre></li><li><p>Certains ou tous les sites Web sont inaccessibles</p></li><li><p>L\'avertissement est affiché dans <strong>Outils &amp; Paramètres &gt; Diagnostiquer &amp; réparer</strong>:</p><pre style="white-space: pre-wrap;">Lors de la vérification de la valeur de nginx ULIMIT, N domaines ont été trouvés sur le serveur. Il y a peut-être un problème avec la limite par défaut nginx concernant le nombre de fichiers ouverts</pre></li><li><p>Les applications Web NodeJS et Ruby affichent une erreur 502 Passerelle incorrecte lors de l\'exécution de certaines tâches de Plesk comme la création de domaines, d\'abonnements, lors de modifications sur Apache ou Nginx :</p><pre style="white-space: pre-wrap;">Erreur serveur<br>502 Passerelle incorrecte <br>Le serveur Web a reçu une réponse non valide en agissant comme passerelle ou serveur proxy.</pre></li><li><p>Après <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">l\'installation d\'un nouveau certificat pour le domaine</a>, l\'ancien s\'affiche toujours dans un navigateur Web. Toutefois, le certificat correct est sélectionné sur la page <strong>Domaines &gt; example.com &gt; Paramètres d\'hébergement</strong> .</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>L\'hôte virtuel Nginx ouvre 4 fichiers journaux pour chaque hôte virtuel avec un hébergement physique :</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Par conséquent, le nombre maximum de fichiers ouverts est dépassé par serveur lenginx, car il y a un nombre élevé de domaines (en général, plus de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Augmenter la limite des fichiers ouverts',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Avertissement :</strong> l\'exécution de l\'utilitaire <code>websrv_ulimits</code> sans l\'option <strong>--no-restart</strong> initie la reconstruction des fichiers de configuration Web pour tous les domaines et peut entraîner des périodes d\'interruption significatives pour tous les domaines lorsque de nombreux sites Web sont hébergés.<br><br>Exécutez la commande pendant les périodes de maintenance.</div><p>Nous vous recommandons de définir la valeur limite des fichiers ouverts sur une valeur supérieure au <strong>nombre de domaines sur Plesk * 16</strong> au moins. Dans l\'exemple suivant, découvrez comment définir la limite sur 4096 :</p><ol><li><p>connectez-vous au serveur via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Définissez la limite sur 4096 pour Apache et Nginx :</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Redémarrez les services Apache et nginx sous <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Outils &amp; Paramètres &gt; Gestion de services</strong> pour appliquer les modifications.</p></li><li><p>Vérifiez si \'la limite max de fichiers ouverts\' a été appliquée correctement après le redémarrage des services Web :</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Si la solution ci-dessus ne résout pas le problème, définissez la limite à l\'aide de l\'utilitaire <code>ulimit</code> :</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Corps de la réponse trop volumineux"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Accès refusé avec le code 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Erreur 500 - Erreur interne du serveur : taille de mémoire de XXX autorisée dépassée"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restriction open_basedir en vigueur"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Interdit AH01797: client refusé par la configuration serveur"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Impossible d\'accéder à un répertoire d\'un site Web Plesk: 403 Interdit"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Impossible d\'accéder à un répertoire d\'un site Web Plesk: 403 Interdit"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "paramètre MaxRequestWorkers atteint par le serveur"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Limite du corps pour la requête PHP "le client tente d\'envoyer un corps trop volumineux "',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Limite du corps pour la requête PHP "le client tente d\'envoyer un corps trop volumineux "',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sessions PHP "Erreur interne du serveur 503" ou "Échec de la lecture des données de la session"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Interdit : pcfg_openfile: impossible de vérifier le fichier htaccess, vérifiez si la lecture est possible"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];