<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream enviou cabeçalho demasiado grande ao ler o cabeçalho de resposta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Opção FollowSymLinks não permitida aqui"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "servidor atingiu a configuração max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Sintomas</h4><ul><li><p>Nos websites que têm o processador PHP definido como <strong>Aplicação FPM servida por Apache</strong> ou <strong>Aplicação FPM servida por nginx</strong> em <strong>Domínios</strong> &gt; <strong>exemplo.com</strong> &gt; <strong>as Definições PHP</strong> apresentam um dos seguintes problemas:</p><ul><li><p>lento ao carregar</p></li><li><p>não acessível (permanente ou periodicamente) com um erro 50x num browser da web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>A seguinte mensagem aparece no ficheiro de registo de erros PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (em que <em>XX</em> é uma versão de PHP utilizada pelos websites):</p><pre>AVISO: [pool exemplo.com] servidor atingiu a configuração max_children (*), considere aumentá-la</pre><ul><li><p>A mensagem acima é geralmente acompanhada por este erro:</p><pre>não é possível ler o que diz o subordinado: descritor do ficheiro com erro (9)</pre></li></ul></li><li><p>Se nginx estiver ativado no servidor, pode parecer uma das seguintes mensagens de erro no ficheiro de registo de erros do domínio <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 ligar() a unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Recurso temporariamente indisponível) ao ligar a upstream, cliente: 203.0.113.2, servidor: exemplo.com, pedido: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", anfitrião: "exemplo.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream fechou prematuramente a ligação ao ler o cabeçalho de resposta de upstream, cliente: 203.0.113.2, servidor: exemplo.com, pedido: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> foi atingido pelo(s) website(s).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Aumentar o limite pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Aumente o limite <code>pm.max_children</code> para os domínios afetados:</p><ol><li><p>Ligue-se ao servidor Plesk através de <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Encontre os domínios afetados utilizando o comando abaixo:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Nota:</strong> o número do lado esquerdo indica quantas vezes o limite <code>pm.max_children</code> foi atingido pelo website.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 exemplo.com<br>50 exemplo.net<br>25 exemplo.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Inicie sessão no Plesk</a>.</p></li><li><p>Aceda a <strong>Domínios</strong> &gt; <strong>exemplo.com</strong> &gt; <strong>Definições PHP</strong> &gt; <strong>Definições PHP-FPM</strong>.</p></li><li><p>Aumente o valor de <code>pm.max_children</code> para o domínio e aplique as alterações. Aumente este valor para todos os domínios enumerados no passo 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Demasiados ficheiros abertos"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx falha ao iniciar/recarregar num servidor Plesk: demasiados ficheiros abertos</p><h4>Sintomas</h4><ul><li><p>O serviço nginx falha ao iniciar/recarregar com o seguinte erro no ficheiro <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" falhou (24: Demasiados ficheiros abertos)</pre></li><li><p>Alguns ou todos os websites não estão acessíveis</p></li><li><p>O aviso é mostrado em <strong>Ferramentas e Configurações &gt; Diagnóstico e reparação</strong>:</p><pre style="white-space: pre-wrap;">Ao verificar o valor de nginx ULIMIT foram encontrados N domínios no servidor. É possível que haja um problema com o limite predefinido de ficheiros abertos de nginx</pre></li><li><p>As aplicações web NodeJS e Ruby mostram o erro 502 Bad Gateway ao realizar algumas tarefas do Plesk como criar domínios, subscrições, alterações em Apache ou Nginx, etc:</p><pre style="white-space: pre-wrap;">Erro do servidor<br>502 Bad Gateway <br>O servidor web recebeu uma resposta inválida ao atuar como gateway ou servidor proxy.</pre></li><li><p>Após <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instalar um novo certificado para o domínio</a>, o antigo ainda é mostrado num browser da web, porém o certificado correto está selecionado na página <strong>Domínios &gt; exemplo.com &gt; Definições de alojamento</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>O anfitrião virtual de nginx abre 4 ficheiros de registo para cada anfritrião virtual com alojamento físico:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Consequentemente, o número máximo de ficheiros abertos é ultrapassado pelo servidor nginx devido a um grande número de domínios (geralmente, mais de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Aumentar o limite de ficheiros abertos',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Warning:</strong> A execução do utilitário <code>websrv_ulimits</code> sem a opção <strong>--no-restart</strong> inicia a reconstrução dos ficheiros de configuração web para todos os domínios e pode causar um tempo de inatividade significativo caso haja um grande números de websites alojados.<br><br>Execute o comando durante o período de manutenção.</div><p>É boa prática definir um valor de limite de ficheiros abertos superior ao <strong>número de domínios no Plesk * 16</strong>, pelo menos. No exemplo abaixo, mostra-se como definir o limite para 4096:</p><ol><li><p>Ligue-se ao servidor através de <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Defina o limite de ficheiros abertos para 4096, tanto para Apache como para Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Reinicie os serviços Apache e nginx em <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Ferramentas e Configurações &gt; Gestão de Serviços</strong> para aplicar as alterações.</p></li><li><p>Verifique se \'Limite máx. de ficheiros aberto\' foi corretamente aplicado, após o reinício dos serviços web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Se a solução acima não ajudar, defina o limite utilizando o utilitário <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Corpo de resposta muito grande"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Acesso negado com código 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Erro interno do servidor 500: tamanho de memória permitido de XXX esgotado"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restrição open_basedir em vigor"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Proibido AH01797: cliente negado pela configuração do servidor"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Não é possível aceder a um diretório de websites no Plesk: 403 Proibido"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Não é possível aceder a um diretório de websites no Plesk: 403 Proibido"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "servidor atingiu a definição MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Limite do corpo do pedido PHP "cliente pretendia enviar corpo demasiado grande"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Limite do corpo do pedido PHP "cliente pretendia enviar corpo demasiado grande"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sessões PHP "503 Erro Interno do Servidor" ou "Falha ao ler os dados da sessão"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: não foi possível verificar o ficheiro htaccess, certifique-se de que pode ser lido"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];