<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'title' => 'Website Log Check',

    'regularCheck' => 'Automatic check',
    'manualCheck' => 'Manuelle Überprüfung',

    'promoTitle' => 'Nicht verfügbare oder fehlerhafte Websites rasch erkennen',
    'promoDescription' => 'Website issues are often visible to visitors but not to administrators unless they constantly analyze website logs. Our brand new Website Log Check automates this routine and helps to resolve found issues efficiently.',
    'promoMore' => 'Mehr erfahren',
    'promoButton' => 'OK',
    'checkEnabledTitle' => 'Automatic check is on',
    'checkDisabledTitle' => 'Automatic check is off',
    'disabledDescription' => 'Turn on to automatically detect issues that can make websites unavailable or cause their incorrect operation.',
    'websitesAllChecked' => '{count, plural, one {# Website wird} other {# Websites werden}} täglich überprüft',
    'websitesAllCheckedAt' => '{count, plural, one {# Website wird} other {# Websites werden}} täglich um %%time%% überprüft',
    'websitesChecked' => '%%count%% von %%totalCount%% Websites werden täglich überprüft',
    'websitesCheckedAt' => '%%count%% von %%totalCount%% Websites werden täglich um %%time%% überprüft',
    'checkedWebsites' => 'Liste der überprüften Websites',
    'lastCheckDescription' => 'The last check took %%duration%% minutes.',
    'durationLess' => 'weniger als 0,1',
    'month0' => '%%date%% Jan.',
    'month1' => '%%date%% Feb.',
    'month2' => '%%date%% März',
    'month3' => '%%date%% Apr.',
    'month4' => '%%date%% Mai',
    'month5' => '%%date%% Juni',
    'month6' => '%%date%% Juli',
    'month7' => '%%date%% Aug.',
    'month8' => '%%date%% Sept.',
    'month9' => '%%date%% Okt.',
    'month10' => '%%date%% Nov.',
    'month11' => '%%date%% Dez.',
    'export' => 'Bericht als CSV exportieren',
    'buttonRun' => 'Manuelle Überprüfung durchführen',
    'buttonRunDescription' => 'To recheck fixed websites or find issues that did not appear during the last check.',

    'websites.title' => 'Zu überprüfende Websites',
    'websites.description' => '%%selected%% von %%total%% Websites sind ausgewählt',
    'websites.search' => 'Websites suchen...',
    'websites.new' => 'Alle neu erstellten Websites',
    'websites.newHint' => 'Select to automatically start checking all new websites.',
    'websites.existing' => 'Alle vorhandenen Websites',
    'websites.buttonSave' => 'Speichern',
    'websites.buttonCancel' => 'Abbrechen',
    'websites.updateSuccess' => 'Einstellungen wurden aktualisiert',

    'tabs.problemDetails' => 'Issue details',
    'tabs.affectedWebsites' => 'Betroffene Websites',

    'chart.requests' => 'Anfragen',
    'chart.errors' => 'Fehler',

    'affected-websites.selected' => '%%selectedCount%% von %%totalCount%% Websites sind ausgewählt',
    'affected-websites.none' => 'Ohne',
    'affected-websites.all' => 'Alle',
    'affected-websites.searchForWebsite' => 'Websites suchen',
    'affected-websites.websites' => 'Websites',
    'affected-websites.showProblemDetails' => 'Show problem details',

    'problem-report.domainTitle' => 'Issue reported on %%domain%%',
    'problem-report.cumulativeTitle' => 'Issue reported on {count, plural, one {# website} other {# websites}}',
    'problem-report.serverwideTitle' => 'Server-wide issue reported',
    'problem-report.problemAppearsOn' => 'The issue appears on {count, plural, one {# website} other {# websites}} in total',
    'problem-report.seeTheConsolidatedReport' => 'Konsolidierten Bericht anzeigen',
    'problem-report.cause' => 'Ursache',
    'problem-report.possibleSolutions' => 'Mögliche Lösungen',
    'problem-report.useAnOption' => 'Eine Option zur automatischen Lösung verwenden',
    'problem-report.repairTheWebsite' => 'Website reparieren',
    'problem-report.selectAndRepair' => 'Mehrere Websites auswählen und reparieren',
    'problem-report.distributionOfTheProblem' => 'Distribution of the issue over time',
    'problem-report.serverTimezone' => 'Zeitzone des Servers (UTC%%utcShift%%)',
    'problem-report.yourTimezone' => 'Ihre Zeitzone (UTC%%utcShift%%)',
    'problem-report.logEntries' => 'Examples of log entries indicating the issue',
    'problem-report.pleaseKeepInMind' => 'Note: Plesk constantly rotates logs and will eventually archive or delete the mentioned log entries.',
    'problem-report.weRecommendToRecheck' => '%%recheckWebsite%%—we recommend it after each fixing attempt.',
    'problem-report.recheckWebsite' => 'Website manuell erneut überprüfen',
    'problem-report.option' => 'Option %%number%%:',
    'problem-report.recommended' => 'empfohlen',
    'problem-report.numberOfEntries' => 'Anzahl der Einträge',
    'problem-report.logEntry' => 'Protokolleintrag',
    'problem-report.logFile' => 'Logfile',
    'problem-report.openWebsiteLogs' => 'Websiteprotokolle öffnen',
    'problem-report.thisIsServerWideProblem' => 'This is a server-wide issue that affects all hosted websites',
    'problem-report.serverWideTitle' => 'Server-wide issue reported',

    'distribution-over-time.title' => 'Distribution of the issue over time',
    'distribution-over-time.serverTimezone' => 'Zeitzone des Servers (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Ihre Zeitzone (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'We recommend that you compare the error distribution chart with %%link%% in Monitoring',
    'distribution-over-time.resourceUsageCharts' => 'Diagramme zur Ressourcennutzung',

    'report.title' => 'Bericht zur letzten Überprüfung',
    'report.groupByWebsites' => 'Gruppiert nach Websites',
    'report.groupByProblems' => 'By issues',
    'report.columnWebsite' => 'Webseite',
    'report.columnStatus' => 'Issues',
    'report.columnProblem' => 'Issue',
    'report.columnAppearedOn' => 'Detected on',
    'report.serverWideName' => 'Server-wide issues',
    'report.serverWideDescription' => 'These issues affect the whole server and its hosted websites.',
    'report.statusProblemsFound' => '%%count%% erkannt',
    'report.statusProblemsFoundFull' => '{count, plural, one {# issue} other {# issues}} found',
    'report.statusProblemsSolved' => '%%count%% gelöst',
    'report.statusProblemsSolvedFull' => '{count, plural, one {# issue} other {# issues}} disappeared',
    'report.statusSuccess' => 'No issues',
    'report.serverWide' => 'Der ganze Server',
    'report.appearedOn' => '{count, plural, one {# Website} other {# Websites}}',
    'report.recheckWebsite' => 'Website erneut überprüfen',
    'report.actionOpen' => 'Öffnen',
    'report.actionManage' => 'Verwalten',
    'report.actionLogs' => 'Protokolle anzeigen',
    'report.searchWebsite' => 'Websites suchen...',
    'report.searchProblem' => 'Find issues...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# issue} other {# issues}} on {websitesCount, plural, one {# website} other {# websites}}',
    'report.noProblemsTitle' => 'No issues were found on {websitesCount, plural, one {# website} other {# websites}}',
    'report.noProblemsDescription' => 'Ihre Websites scheinen gut in Schuss zu sein. Gut gemacht!',

    'problems.columnTitle' => 'Issue',
    'problems.columnRegular' => 'Automatic check',
    'problems.columnManual' => 'Manuelle Überprüfung',
    'problems.run' => '%%fromDate%% %%fromTime%% – %%toDate%% %%toTime%%',
    'problems.runSameDay' => '%%toDate%% von %%fromTime%% bis %%toTime%%',
    'problems.notRun' => 'not performed yet',
    'problems.resultDetected' => 'Erkannt',
    'problems.resultNotDetected' => 'Nicht erkannt',
    'problems.resultNoProblems' => 'No issues',

    'new-check.title' => 'Manuelle Überprüfung',
    'new-check.titleForWebsite' => 'Manuelle Überprüfung von %%website%%',
    'new-check.titleRunning' => 'Manuelle Überprüfung von {count, plural, one {# Website} other {# Websites}}',
    'new-check.description' => '%%selected%% von %%total%% Websites sind ausgewählt',
    'new-check.depth' => 'Prüfzeitraum',
    'new-check.checkTheLast' => 'Überprüfen der letzten',
    'new-check.selectHours' => 'Stunden',
    'new-check.selectMinutes' => 'Minuten',
    'new-check.ifYouHaveAnyProblemActivities' => 'If you tried fixing the website issues, set the time period after this attempt. Otherwise Plesk can detect issues you have already resolved.',
    'new-check.weAlsoRecommendVisiting' => 'Before running a manual check, we recommend that you %%visitingTheWebsite%% and try to reproduce the issue.',
    'new-check.visitingTheWebsite' => 'visit the website',
    'new-check.hours' => 'letzte Stunden',
    'new-check.websites' => 'Zu überprüfende Websites',
    'new-check.buttonSave' => 'Überprüfen',
    'new-check.buttonCancel' => 'Abbrechen',
    'new-check.search' => 'Websites suchen...',
    'new-check.checkProblems' => 'Websites with issues during the last check',
    'new-check.allWebsites' => 'Alle Websites',
];