<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Acceso denegado. Su cuenta ha sido suspendida.",
    'login_up__login_has_been_locked' => "Ha intentado iniciar sesión demasiadas veces usando una contraseña incorrecta. Por motivos de seguridad, durante unos minutos no podrá iniciar sesión usando este nombre de usuario.",
    'login_up__login_label_plesk' => "Acceder a %1", // PFU
    'login_up__login_label_parallels' => "Acceder a Plesk %1",
    'login_up__login_text' => "Indique su nombre de usuario y contraseña.",
    'login_up__unable_to_check_pass' => "No se puede verificar la contraseña: %1",
    'login_up__warning_limits_licence_key' => "Uno de los siguientes elementos ha excedido el límite definido por su llave de licencia: número de cuentas de usuario, dominios, cuentas de correo o usuarios web alojados en su servidor.\nPóngase en contacto con el departamento comercial de Plesk para comprar una llave que le permita alojar el número deseado de usuarios y dominios. Si ha recibido este mensaje por error, póngase en contacto con el equipo de soporte técnico de Plesk.\nLímite de cuentas de usuario/dominios/cuentas de correo/usuarios web/paquetes de idioma de la licencia: %2.\nNúmero de cuentas de usuario/dominios/cuentas de correo/usuarios web/paquetes de idioma alojados en este momento: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "La cantidad de recursos usada ha excedido los límites definidos por su licencia de producto actual. Póngase en contacto con el departamento comercial de Plesk y compre una llave de licencia nueva.",
    'login_up__grace_period' => 'En este momento está operando dentro del periodo de gracia de su licencia. Para actualizar su licencia del producto, seleccione la opción Recuperar llaves en la %1página de administración de licencias%2.',
    'login_up__partner_license_message' => 'En este momento está usando una licencia limitada del producto que requiere registro antes de la activación de todas las prestaciones. Para actualizar su licencia del producto, seleccione la opción Recuperar llaves en la %1página de administración de licencias%2.',
    'login_up__system_admin_disabled' => 'Por motivos de seguridad, el súper usuario (cuenta de administrador o root) no puede acceder a Plesk.',
    'login_up__mobile_application_message' => 'Si desea disfrutar de una mejor experiencia, le recomendamos instalar la aplicación %%name%%.',
    'login_up__mobile_application_install' => 'Instalar ahora',
    'login_up__mobile_application_hide' => 'No, gracias',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Guía del administrador de Plesk",
    'plesk_guide_reseller' => "Guía del revendedor de Plesk",
    'plesk_guide_client' => "Guía del cliente de Plesk",
    'plesk_guide_domain_admin' => "Guía del administrador de dominio de Plesk",
    'plesk_guide_mailuser' => "Guía del usuario de correo de Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Buscar', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Clientes',
    'ui__reseller_unknown__quick-search' => 'Revendedores',
    'ui__client/domain_unknown__quick-search' => 'Dominios',
    'nav__general' => 'Menú principal',
    '__home' => 'Inicio',
    '__resellers' => 'Revendedores',
    '__clients' => 'Clientes',
    '__domains' => 'Dominios',
    '__applications' => 'Aplicaciones',
    '__settings' => 'Configuración',
    'nav__system' => 'Sistema',
    '__master' => 'Principal',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Nivel superior',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Eliminar',
    'bt_make_default' => 'Hacer predeterminado',

    // common list object operation errors
    'class_cList__empty_selection' => 'No ha seleccionado ningún objeto.',

    // common list object search keys
    'clist__search_show' => 'Mostrar búsqueda',
    'clist__search_hide' => 'Ocultar búsqueda',

    'bt_show_all' => "Restablecer búsqueda",

    // common object list info keys
    'clist__first' => 'Primera',
    'clist__last' => 'Última',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Páginas',
    'clist__page_size' => 'Entradas por página',
    'clist__info' => 'Total %1: %4',
    'clist__info_empty' => 'No existen %1',
    'clist__info_filter' => '%5 %1 encontrado (%4 en total)',
    'clist__info_paging' => '%2-%3 %1 de %4 en total',
    'clist__info_paging_filter' => '%2-%3 %1 de %5 encontrados (%4 en total)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Activo',
    '__object_off' => 'Suspendido',

    '__home_description' => 'Vuelva a la página principal.',
    'indicator_title' => '%1% usado, %2% disponible', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Se ha solicitado una URL no válida.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Cuentas de revendedor",
    'ui__reseller_unknown__title' => "Cuentas de revendedor",
    'ui__reseller_unknown__description' => "Administre cuentas de revendedor.",
    'ui__reseller/client_unknown__short-title' => 'Cuentas de cliente',
    'ui__reseller/client_unknown__title' => 'Cuentas de cliente',
    'ui__reseller/client_unknown__description' => 'Administre cuentas de cliente.',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => 'Asignar propietario nuevo a cuentas de cliente',
    'ui__reseller/client/chowner_multi-select__short-title' => 'Asignar propietario nuevo',
    'ui__reseller/client/chowner_multi-select__description' => 'Asigne un propietario nuevo a las cuentas de cliente seleccionadas.',
    'ui__client/to-reseller_multi__title' => 'Convertir cuentas de cliente a cuentas de revendedor',
    'ui__client/to-reseller_multi__short-title' => 'Convertir a revendedores',
    'ui__client/to-reseller_multi__description' => 'Convierta cuentas de cliente seleccionadas a cuentas de revendedor.',
    'ui__reseller/to-client_multi__title' => 'Convertir cuentas de revendedor a cuentas de cliente',
    'ui__reseller/to-client_multi__short-title' => 'Convertir a clientes',
    'ui__reseller/to-client_multi__description' => 'Convertir cuentas de revendedor seleccionadas a cuentas de cliente',
    'ui__admin-alias_unknown__title' => "Cuentas adicionales de administrador", // PFW
    'ui__admin-alias_unknown__short-title' => "Cuentas adicionales de administrador", // PFW
    'ui__admin-alias_unknown__description' => "Vea y gestione cuentas adicionales del administrador.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Configuración del servidor de correo",
    'ui__server/mail__title' => "Configuración del servidor de correo",
    'ui__server/mail__description' => "Configure su servidor de correo y configure las opciones de correo a nivel del servidor.",
    'ui__server/dns__short-title' => 'Configuración DNS',
    'ui__server/dns__title' => 'Configuración DNS',
    'ui__server/dns__description' => 'Revise y actualice la configuración DNS a nivel de servidor.',
    'ui__server/components__short-title' => 'Componentes del servidor',
    'ui__server/components__title' => 'Componentes del servidor',
    'ui__server/components__description' => 'Vea la información acerca de los componentes del sistema instalados en el servidor y usados por Plesk.',
    'ui__server/services__short-title' => 'Administración de servicios',
    'ui__server/services__title' => 'Administración de servicios',
    'ui__server/services__description' => 'Inicie, detenga o reinicie servicios de Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Tareas programadas',
    'ui__server/crontab/task_unknown__title' => 'Tareas programadas',
    'ui__server/crontab/task_unknown__description' => 'Añada y elimine tareas programadas a nivel de servidor.',
    'ui__server/ip-address_unknown__short-title' => 'Direcciones IP',
    'ui__server/ip-address_unknown__title' => 'Direcciones IP',
    'ui__server/ip-address_unknown__description' => 'Vea, añada y elimine direcciones IP y asigne direcciones IP a revendedores.',
    'ui__promotion/smartermail__short-title' => 'Descargar SmarterMail',
    'ui__promotion/smartermail__title' => 'Descargar SmarterMail',
    'ui__promotion/smartermail__description' => 'Abra una ventana nueva con el sitio web de SmarterMail, donde puede descargar la última versión del servidor de correo SmarterMail. El sitio web de SmarterMail es producido y soportado por SmarterTools Inc. Plesk no se responsabiliza del contenido del sitio web de SmarterMail y no ofrece soporte para el servidor de correo SmarterMail Lite.',
    // dropdowns
    'ui__server/time__title' => 'Fecha y hora del sistema',
    'ui__server/time__short-title' => 'Fecha y hora del sistema',
    'ui__server/time__description' => 'Cambie la fecha y hora del sistema y configure la sincronización con un servidor NTP.',
    'ui__server/odbc__title' => 'Orígenes de datos ODBC', // PFW
    'ui__server/odbc__short-title' => 'Orígenes de datos ODBC', // PFW
    'ui__server/odbc__description' => 'Configure orígenes de datos ODBC.', // PFW
    'ui__server/ftp-settings__short-title' => "Configuración FTP", // PFW
    'ui__server/ftp-settings__title' => "Configuración FTP", // PFW
    'ui__server/ftp-settings__description' => "Configure opciones FTP a nivel de servidor.", // PFW
    'ui__server/maillists__title' => 'Configurar servidor de listas de correo', // PFU
    'ui__server/maillists__short-title' => 'Configurar servidor de listas de correo', // PFU
    'ui__server/maillists__description' => 'Configure el servidor de listas de correo Mailman.', // PFU
    'ui__mass-email__short-title' => "Mensajes de email masivos", // PFW
    'ui__mass-email__title' => "Mensajes de email masivos", // PFW
    'ui__mass-email__description' => "Enviar mensajes de email a varios usuarios a la vez.", // PFW
    'ui__mass-mail__title' => 'Mensajes de email masivos', // PFU
    'ui__mass-mail__short-title' => 'Mensajes de email masivos', // PFU
    'ui__mass-mail__description' => 'Enviar mensajes de email a varios usuarios a la vez.', // PFU
    'ui__server/spam-filter__title' => 'Configuración del filtro antispam',
    'ui__server/spam-filter__short-title' => 'Configuración del filtro antispam',
    'ui__server/spam-filter__description' => 'Configure un filtro antispam a nivel de servidor.',
    'ui__server/preferences__title' => "Configuración del servidor",
    'ui__server/preferences__short-title' => "Configuración del servidor",
    'ui__server/preferences__description' => "Configure el cálculo de estadísticas a nivel de servidor y edite el nombre de host del servidor y otros parámetros del servidor.",

    // help & support
    // icons
    'ui__support__short-title' => 'Soporte',
    'ui__support__title' => 'Soporte',
    'ui__support__description' => 'Envíe una petición de soporte técnico o revise los tickets de soporte tramitados por sus clientes.',
    'ui__license__short-title' => 'Administración de licencias',
    'ui__license__title' => 'Administración de licencias de Plesk',
    'ui__license__description' => 'Vea la información acerca de su licencia de Plesk y compre llaves de licencia nuevas.',
    'ui__help__short-title' => 'Ayuda',
    'ui__help__title' => 'Ayuda online',
    'ui__help__description' => 'Vea la ayuda online.',
    'ui__news__short-title' => "Novedades",
    'ui__news__title' => "Novedades",
    'ui__news__description' => "Vea la lista de cambios en esta versión de Plesk.",
    'ui__server/autoinstaller__short-title' => 'Actualizaciones',
    'ui__server/autoinstaller__title' => 'Actualizaciones',
    'ui__server/autoinstaller__description' => 'Actualice Plesk y sus componentes.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Dominios',
    'ui__client/domain_unknown__title' => 'Dominios',
    'ui__client/domain_unknown__description' => 'Administre dominios.',
    'ui__server/skeleton__short-title' => 'Plantilla de host virtual',
    'ui__server/skeleton__title' => 'Plantilla de host virtual',
    'ui__server/skeleton__description' => 'Especifique los archivos y carpetas que deberían incorporarse a los directorios de los dominios nuevos.',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => 'Crear dominio',
    'ui__client/domain/properties_unknown-new__short-title' => 'Crear dominio',
    'ui__client/domain/properties_unknown-new__description' => 'Cree y configure un dominio.',
    'ui__client/domain/chowner_multi-select__title' => 'Asignar propietario nuevo a suscripciones',
    'ui__client/domain/chowner_multi-select__short-title' => 'Asignar propietario nuevo a la suscripción',
    'ui__client/domain/chowner_multi-select__description' => 'Asignar propietario nuevo a las suscripciones seleccionadas',
    'ui__client/domain/to-client_multi__title' => 'Convertir cuentas de administrador de dominio a cuentas de cliente',
    'ui__client/domain/to-client_multi__short-title' => 'Convertir a clientes',
    'ui__client/domain/to-client_multi__description' => 'Convertir las cuentas de administrador de dominio seleccionadas a cuentas de cliente',
    'ui__client/domain/disable_multi__title' => 'Suspender dominios',
    'ui__client/domain/disable_multi__short-title' => 'Suspender dominios',
    'ui__client/domain/disable_multi__description' => 'Suspender dominios seleccionados',
    'ui__client/domain/enable_multi__title' => 'Activar dominios',
    'ui__client/domain/enable_multi__short-title' => 'Activar dominios',
    'ui__client/domain/enable_multi__description' => 'Activar dominios seleccionados',

    // icons
    'ui__admin/extras-domain__short-title' => 'Herramientas de MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Herramientas de MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Obtenga herramientas y servicios adicionales en MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Configuración ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Configuración ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Establezca la configuración ASP.NET a nivel de servidor.', // PFW
    'ui__server/sitebuilder__short-title' => 'Configuración de Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Configuración de Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Configurar Presence Builder para editar sitios web alojados en este servidor.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Registrar dominio',
    'ui__admin/register-domain__short-title' => 'Registrar dominio',
    'ui__admin/register-domain__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Administrar dominio',
    'ui__admin/manage-domain__short-title' => 'Administrar dominio',
    'ui__admin/manage-domain__description' => 'Administre nombres de dominio registrados a través de MyPlesk.com.',
    'ui__server/register__title' => 'Registrar su servidor',
    'ui__server/register__short-title' => 'Registrar servidor',
    'ui__server/register__description' => 'Registrar su servidor para adherirse a un programa de afiliación',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Registro de acciones',
    'ui__actionlog__title' => 'Registro de acciones',
    'ui__actionlog__description' => 'Descargue el registro de acciones y gestione las opciones de registro de acciones.',
    'ui__notification_unknown__short-title' => 'Notificaciones',
    'ui__notification_unknown__title' => 'Notificaciones',
    'ui__notification_unknown__description' => 'Vea y edite las notificaciones que se envían cuando acontecen eventos importantes en Plesk.',
    'ui__server/resources__short-title' => 'Uso de recursos',
    'ui__server/resources__title' => 'Uso de recursos',
    'ui__server/resources__description' => 'Vea el uso de recursos del sistema.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Información del servidor',
    'ui__server/statistics__title' => 'Información del servidor',
    'ui__server/statistics__description' => 'Estadísticas acerca de los servicios gestionados por Plesk.',
    'ui__admin/report__title' => 'Informe resumido',
    'ui__admin/report__short-title' => 'Informe resumido',
    'ui__admin/report__description' => 'Vea un informe acerca del uso del tráfico y recursos por parte de revendedores, clientes y dominios.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Tiempo de inactividad de la sesión',
    'ui__sessions/properties__title' => 'Tiempo de inactividad de la sesión',
    'ui__sessions/properties__description' => 'Establezca el tiempo de inactividad de sesión para las sesiones de Plesk.',
    'ui__cp-access__short-title' => 'Acceso a Plesk',
    'ui__cp-access__title' => 'Acceso a Plesk',
    'ui__cp-access__description' => 'Limite el acceso a Plesk.',
    'ui__sessions__short-title' => 'Sesiones activas',
    'ui__sessions__title' => 'Sesiones activas',
    'ui__sessions__description' => 'Vea las sesiones activas de Plesk.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Certificados SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Certificados SSL/TLS',
    'ui__server/certificate_unknown__description' => 'La lista de certificados SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Datos personales',
    'ui__admin-info__title' => 'Datos personales',
    'ui__admin-info__description' => 'Edite la información personal de su cuenta.',
    'ui__admin-password__short-title' => 'Cambiar la contraseña',
    'ui__admin-password__title' => 'Cambiar la contraseña',
    'ui__admin-password__description' => 'Cambie la contraseña de su cuenta.',
    'ui__admin/interface__short-title' => 'Preferencias del interfaz',
    'ui__admin/interface__title' => 'Preferencias de interfaz del administrador',
    'ui__admin/interface__description' => 'Cambie las preferencias de interfaz del administrador del servidor.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'Administrador de archivos',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'Administrador de archivos',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'Use archivos y directorios a través del administrador de archivos.',
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'Use el terminal SSH para acceder al servidor.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Directorios protegidos con contraseña',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Directorios protegidos con contraseña',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Proteja el acceso a determinadas áreas de un sitio web.',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => 'Cree y administre directorios virtuales en un dominio.', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Use directorios y archivos físicos y virtuales en un sitio web.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => 'Estadísticas web',
    'ui__client/domain/report/web-stats_unknown__title' => 'Estadísticas web',
    'ui__client/domain/report/web-stats_unknown__description' => 'Vea estadísticas de visitas al sitio web.',
    'ui__reseller/limits__short-title' => 'Uso de recursos',
    'ui__reseller/limits__title' => 'Uso de recursos',
    'ui__reseller/limits__description' => 'Vea y administre el uso de recursos del revendedor %1.',
    'ui__reseller/limits_unknown__short-title' => 'Uso de recursos',
    'ui__reseller/limits_unknown__title' => 'Uso de recursos',
    'ui__reseller/limits_unknown__description' => 'Vea y administre el uso de recursos del revendedor.',
    'ui__reseller/limits_self__short-title' => 'Uso de recursos',
    'ui__reseller/limits_self__title' => 'Uso de recursos',
    'ui__reseller/limits_self__description' => "Vea y gestione su uso de recursos.",
    'ui__reseller/limits_readonly-self__short-title' => 'Uso de recursos',
    'ui__reseller/limits_readonly-self__title' => 'Uso de recursos',
    'ui__reseller/limits_readonly-self__description' => "Vea y gestione su uso de recursos.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Uso de tráfico por parte de clientes',
    'ui__reseller/client/traffic_unknown__title' => 'Ver uso de tráfico por clientes',
    'ui__reseller/client/traffic_unknown__description' => 'Vea informes de uso de tráfico para cuentas de cliente.',
    'ui__client/traffic_unknown__short-title' => "Uso de tráfico por parte de clientes", // temporary for presets
    'ui__client/traffic_unknown__title' => "Vea el uso de tráfico por parte de los clientes", // temporary for presets
    'ui__client/traffic_unknown__description' => "Vea informes de uso de tráfico para cuentas de cliente.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Administrador de registros',
    'ui__client/domain/hosting/logs_unknown__title' => 'Administrador de registros',
    'ui__client/domain/hosting/logs_unknown__description' => 'Vea registros y configure su rotación.',
    // dropdowns
    'ui__reseller/report__title' => 'Informe resumido',
    'ui__reseller/report__short-title' => 'Informe resumido',
    'ui__reseller/report__description' => 'Vea un informe del uso de tráfico y recursos para este revendedor.',
    'ui__reseller/report_unknown__title' => 'Informe resumido',
    'ui__reseller/report_unknown__short-title' => 'Informe resumido',
    'ui__reseller/report_unknown__description' => 'Vea un informe sobre el uso de tráfico y recursos del revendedor.',
    'ui__reseller/report_self__title' => 'Informe resumido',
    'ui__reseller/report_self__short-title' => 'Informe resumido',
    'ui__reseller/report_self__description' => 'Vea un informe sobre su uso de tráfico y recursos.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Personalización de Plesk',
    'ui__client/logo_reseller__short-title' => 'Personalización de Plesk',
    'ui__client/logo_reseller__description' => 'Personalice Plesk para el revendedor %1.',
    'ui__client/logo_unknown__title' => 'Personalización de Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Personalización de Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Personalice Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Personalización de Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Personalización de Plesk',
    'ui__client/logo_self-reseller__description' => 'Personalice su Plesk.',
    'ui__reseller/permissions__title' => 'Permisos',
    'ui__reseller/permissions__short-title' => 'Permisos',
    'ui__reseller/permissions__description' => "Vea o cambie las acciones que el revendedor %1 puede realizar en Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Permisos',
    'ui__reseller/permissions_unknown__title' => 'Permisos',
    'ui__reseller/permissions_unknown__description' => "Vea o cambie las acciones que el revendedor puede realizar en Plesk.",
    'ui__reseller/permissions_self__title' => 'Permisos',
    'ui__reseller/permissions_self__short-title' => 'Permisos',
    'ui__reseller/permissions_self__description' => 'Vea la lista de acciones que puede realizar en Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Permisos',
    'ui__reseller/permissions_readonly-self__short-title' => 'Permisos',
    'ui__reseller/permissions_readonly-self__description' => 'Vea la lista de acciones que puede realizar en Plesk.',
    // dropdowns
    'ui__reseller/to-client__title' => 'Convertir cuenta de revendedor a cuenta de cliente',
    'ui__reseller/to-client__short-title' => 'Convertir revendedor a cliente',
    'ui__reseller/to-client__description' => 'Convierta esta cuenta de revendedor a cuenta de cliente.',
    'ui__reseller/to-client_unknown__title' => 'Convertir cuenta de revendedor a cuenta de cliente',
    'ui__reseller/to-client_unknown__short-title' => 'Convertir revendedor a cliente',
    'ui__reseller/to-client_unknown__description' => 'Convierta una cuenta de revendedor a cuenta de cliente.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Plantilla de host virtual',
    'ui__client/skeleton__short-title' => 'Plantilla de host virtual',
    'ui__client/skeleton__description' => 'Especifique los archivos y carpetas que deben situarse en los directorios de los dominios creados recientemente.',
    'ui__client/skeleton_unknown__short-title' => 'Plantilla de host virtual',
    'ui__client/skeleton_unknown__title' => 'Plantilla de host virtual',
    'ui__client/skeleton_unknown__description' => 'Indique los archivos y carpetas que deben situarse en los directorios de los dominios nuevos.',
    // dropdowns
    'ui__client/domain/properties_new__title' => 'Crear dominio',
    'ui__client/domain/properties_new__short-title' => 'Crear dominio',
    'ui__client/domain/properties_new__description' => "Cree un dominio para %1.",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Alias de dominio',
    'ui__client/domain/domain-alias_unknown__title' => 'Alias de dominio',
    'ui__client/domain/domain-alias_unknown__description' => 'Vea la lista de nombres alternativos para su dominio.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Configuración DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_unknown__description' => 'Administre los parámetros de configuración de la zona DNS para un dominio.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Vea la configuración de zona DNS para un dominio.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Herramientas de MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Herramientas de MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Obtenga herramientas y servicios adicionales de MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Herramientas de MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Herramientas de MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Obtenga herramientas y servicios adicionales en MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Herramientas de MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Herramientas de MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Obtenga servicios y herramientas adicionales de MyPlesk.com.',
    'ui__client/domain/odbc_unknown__short-title' => 'Fuentes de datos ODBC', // PFW
    'ui__client/domain/odbc_unknown__title' => 'Fuentes de datos ODBC', // PFW
    'ui__client/domain/odbc_unknown__description' => 'Configure fuentes de datos ODBC para un dominio.', // PFW
    'ui__reseller/register-domain__short-title' => 'Registrar dominio',
    'ui__reseller/register-domain__title' => 'Registrar dominio',
    'ui__reseller/register-domain__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Registrar dominio',
    'ui__reseller/register-domain_unknown__title' => 'Registrar dominio',
    'ui__reseller/register-domain_unknown__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Registrar dominio',
    'ui__reseller/register-domain_self__title' => 'Registrar dominio',
    'ui__reseller/register-domain_self__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Administrar dominio',
    'ui__reseller/manage-domain__short-title' => 'Administrar dominio',
    'ui__reseller/manage-domain__description' => 'Administre nombres de dominio registrados a través de MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Administrar dominio',
    'ui__reseller/manage-domain_unknown__short-title' => 'Administrar dominio',
    'ui__reseller/manage-domain_unknown__description' => 'Administre nombres de dominio registrados a través de MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Administrar dominio',
    'ui__reseller/manage-domain_self__short-title' => 'Administrar dominio',
    'ui__reseller/manage-domain_self__description' => 'Administre nombres de dominio registrados a través de MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Direcciones IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Direcciones IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Administre direcciones IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'Certificados SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Certificados SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Instale y gestione certificados SSL/TLS.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'Protección contra Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'Protección contra Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'Proteja los archivos contra hotlinking.', // PFW
    'ui__reseller/sessions__short-title' => 'Sesiones activas',
    'ui__reseller/sessions__title' => 'Sesiones activas',
    'ui__reseller/sessions__description' => 'Vea las sesiones activas de Plesk.',
    'ui__reseller/sessions_unknown__short-title' => 'Sesiones activas',
    'ui__reseller/sessions_unknown__title' => 'Sesiones activas',
    'ui__reseller/sessions_unknown__description' => 'Vea las sesiones activas de Plesk.',
    'ui__reseller/sessions_self__short-title' => 'Sesiones activas',
    'ui__reseller/sessions_self__title' => 'Sesiones activas',
    'ui__reseller/sessions_self__description' => 'Vea las sesiones activas de Plesk.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_unknown__title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_unknown__description' => 'Vea y edite el límite de uso de ancho de banda  y el número de conexiones simultáneas a un sitio web.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'Vea el límite de uso de ancho de banda  y el número de conexiones simultáneas a un sitio web.',
    'ui__client/domain/hosting/php_unknown__short-title' => 'Configuración de PHP', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'Configuración de PHP', // PFW
    'ui__client/domain/hosting/php_unknown__description' => 'Configure PHP en un dominio.', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Cuentas de correo bajo la cuenta de usuario %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Plantilla de host virtual',
    'ui__client/skeleton_self__title' => 'Plantilla de host virtual',
    'ui__client/skeleton_self__description' => 'Indique los archivos y carpetas que deben situarse en los directorios de los dominios creados recientemente.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Uso de recursos',
    'ui__client/limits__title' => 'Uso de recursos',
    'ui__client/limits__description' => "Vea y administre el uso de recursos del cliente %1.",
    'ui__client/limits_unknown__short-title' => 'Uso de recursos',
    'ui__client/limits_unknown__title' => 'Uso de recursos',
    'ui__client/limits_unknown__description' => 'Vea y administre el uso de recursos del cliente.',
    'ui__client/limits_readonly__short-title' => 'Uso de recursos',
    'ui__client/limits_readonly__title' => 'Uso de recursos',
    'ui__client/limits_readonly__description' => 'Vea el uso de recursos del cliente %1.',
    'ui__client/limits_self__short-title' => 'Uso de recursos',
    'ui__client/limits_self__title' => 'Uso de recursos',
    'ui__client/limits_self__description' => "Vea y administre su uso de recursos.",
    'ui__client/limits_readonly-self__short-title' => 'Uso de recursos',
    'ui__client/limits_readonly-self__title' => 'Uso de recursos',
    'ui__client/limits_readonly-self__description' => "Vea su uso de recursos.",
    'ui__client/domain/traffic_unknown__short-title' => "Uso de tráfico por parte de los dominios %1",
    'ui__client/domain/traffic_unknown__title' => "Ver uso de tráfico por parte de los dominios",
    'ui__client/domain/traffic_unknown__description' => "Vea informes de uso de tráfico de dominios.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Informe resumido',
    'ui__client/report__short-title' => 'Informe resumido',
    'ui__client/report__description' => 'Vea un informe acerca del uso de tráfico y recursos para este cliente.',
    'ui__client/report_unknown__short-title' => 'Informe resumido',
    'ui__client/report_unknown__title' => 'Informe resumido',
    'ui__client/report_unknown__description' => 'Vea un informe acerca del uso de tráfico y recursos para el cliente.',
    'ui__client/report_self__short-title' => 'Informe resumido',
    'ui__client/report_self__title' => 'Informe resumido',
    'ui__client/report_self__description' => 'Vea un informe sobre el uso de recursos y tráfico.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Preferencias del interfaz',
    'ui__client/preferences__title' => 'Preferencias del interfaz',
    'ui__client/preferences__description' => 'Establezca las preferencias del interfaz de Plesk para el cliente %1.',
    'ui__client/preferences_unknown__short-title' => 'Preferencias del interfaz',
    'ui__client/preferences_unknown__title' => 'Preferencias del interfaz',
    'ui__client/preferences_unknown__description' => "Establezca las preferencias del interfaz para el Plesk del cliente.",
    'ui__client/preferences_self__short-title' => 'Preferencias del interfaz',
    'ui__client/preferences_self__title' => 'Preferencias del interfaz',
    'ui__client/preferences_self__description' => 'Establezca las preferencias del interfaz para su Plesk.',
    'ui__client/logo__title' => 'Personalización de Plesk',
    'ui__client/logo__short-title' => 'Personalización de Plesk',
    'ui__client/logo__description' => "Personalice Plesk para el cliente %1.",
    'ui__client/logo_self__title' => 'Personalización de Plesk',
    'ui__client/logo_self__short-title' => 'Personalización de Plesk',
    'ui__client/logo_self__description' => 'Personalice Plesk cambiando la imagen del logo y el texto que se muestra en la barra de nombre del navegador.',
    'ui__client/permissions__title' => 'Permisos',
    'ui__client/permissions__short-title' => 'Permisos',
    'ui__client/permissions__description' => "Vea o cambie las acciones que el cliente %1 puede realizar en Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Permisos',
    'ui__client/permissions_unknown__title' => 'Permisos',
    'ui__client/permissions_unknown__description' => "Vea o cambie las acciones que el cliente puede realizar en Plesk.",
    'ui__client/permissions_self__title' => 'Permisos',
    'ui__client/permissions_self__short-title' => 'Permisos',
    'ui__client/permissions_self__description' => "Vea la lista de acciones que puede realizar en Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Permisos',
    'ui__client/permissions_readonly-self__short-title' => 'Permisos',
    'ui__client/permissions_readonly-self__description' => "Vea la lista de acciones que puede realizar en Plesk.",
    // dropdowns
    'ui__client/chowner_select__title' => 'Asignar propietario nuevo a la cuenta del cliente',
    'ui__client/chowner_select__short-title' => 'Asignar propietario nuevo al cliente',
    'ui__client/chowner_select__description' => 'Asigne un propietario nuevo a esta cuenta de cliente.',
    'ui__client/chowner_unknown-select__short-title' => 'Asignar propietario nuevo a la cuenta del cliente',
    'ui__client/chowner_unknown-select__title' => 'Asignar propietario nuevo al cliente',
    'ui__client/chowner_unknown-select__description' => 'Asigne un propietario nuevo a la cuenta del cliente.',
    'ui__client/to-reseller__title' => 'Convertir cuenta de cliente a cuenta de revendedor',
    'ui__client/to-reseller__short-title' => 'Convertir cliente a revendedor',
    'ui__client/to-reseller__description' => 'Convierta esta cuenta de cliente a cuenta de revendedor.',
    'ui__client/to-reseller_unknown__title' => 'Convertir cuenta de cliente a cuenta de revendedor',
    'ui__client/to-reseller_unknown__short-title' => 'Convertir cliente a revendedor',
    'ui__client/to-reseller_unknown__description' => 'Convierta esta cuenta de cliente a cuenta de revendedor.',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Herramientas de MyPlesk.com',
    'ui__client/extras-domain__title' => 'Herramientas de MyPlesk.com',
    'ui__client/extras-domain__description' => 'Obtenga herramientas y servicios adicionales de MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Herramientas de MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Herramientas de MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Obtenga servicios y herramientas adicionales de MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Herramientas de MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Herramientas de MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Obtenga herramientas y servicios adicionales en MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Registrar dominio',
    'ui__client/register-domain__short-title' => 'Registrar dominio',
    'ui__client/register-domain__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Registrar dominio',
    'ui__client/register-domain_unknown__short-title' => 'Registrar dominio',
    'ui__client/register-domain_unknown__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Registrar dominio',
    'ui__client/register-domain_self__short-title' => 'Registrar dominio',
    'ui__client/register-domain_self__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Administrar dominio',
    'ui__client/manage-domain__short-title' => 'Administrar dominio',
    'ui__client/manage-domain__description' => 'Administre nombres de dominio registrados a través de MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Administrar dominio',
    'ui__client/manage-domain_unknown__short-title' => 'Administrar dominio',
    'ui__client/manage-domain_unknown__description' => 'Administre nombres de dominio registrados a través de MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Administrar dominio',
    'ui__client/manage-domain_self__short-title' => 'Administrar dominio',
    'ui__client/manage-domain_self__description' => 'Administre nombres de dominio registrados a través de MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Direcciones IP',
    'ui__client/ipaddress_unknown__short-title' => "Direcciones IP",
    'ui__client/ipaddress_unknown__description' => "Administre direcciones IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Alias de dominio',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Alias de dominio',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Vea la lista de nombres alternativos para su dominio.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'Sesiones activas',
    'ui__client/sessions__title' => 'Sesiones activas',
    'ui__client/sessions__description' => 'Vea las sesiones activas de Plesk.',
    'ui__client/sessions_unknown__short-title' => 'Sesiones activas',
    'ui__client/sessions_unknown__title' => 'Sesiones activas',
    'ui__client/sessions_unknown__description' => 'Vea las sesiones activas de Plesk.',
    'ui__client/sessions_self__short-title' => 'Sesiones activas',
    'ui__client/sessions_self__title' => 'Sesiones activas',
    'ui__client/sessions_self__description' => 'Vea las sesiones activas de Plesk.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'Administrador de archivos',
    'ui__client/domain/hosting/file-manager__title' => 'Administrar archivos en el dominio %1',
    'ui__client/domain/hosting/file-manager__description' => "Use archivos y directorios en el dominio %1 a través del administrador de archivos.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'Administrador de archivos',
    'ui__client/domain/hosting/file-manager_self__title' => 'Administrador de archivos',
    'ui__client/domain/hosting/file-manager_self__description' => "Use sus archivos y directorios a través del administrador de archivos.",
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'Use el terminal SSH para acceder al servidor.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'Use el terminal SSH para acceder al servidor.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'Directorios protegidos con contraseña',
    'ui__client/domain/hosting/protected-directories__title' => 'Directorios protegidos con contraseña',
    'ui__client/domain/hosting/protected-directories__description' => 'Proteja el acceso a determinadas áreas de un sitio web.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Directorios protegidos con contraseña',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Directorios protegidos con contraseña',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Proteja el acceso a determinadas áreas de un sitio web.',
    'ui__client/domain/hosting/virtual-directories__short-title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => 'Cree y administre directorios virtuales en el dominio %1.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => 'Cree y administre directorios virtuales en su dominio.', // PFW
    'ui__client/domain/hosting/web-directories__title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Use directorios y archivos físicos y virtuales en el sitio %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Directorios virtuales', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Use directorios y archivos físicos y virtuales en su sitio web.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => 'Estadísticas web',
    'ui__client/domain/report/web-stats__title' => 'Estadísticas web',
    'ui__client/domain/report/web-stats__description' => 'Vea estadísticas de visitas al sitio web.',
    'ui__client/domain/report/web-stats_self__short-title' => 'Estadísticas web',
    'ui__client/domain/report/web-stats_self__title' => 'Estadísticas web',
    'ui__client/domain/report/web-stats_self__description' => 'Vea estadísticas de visitas al sitio web.',
    'ui__client/domain/traffic__short-title' => 'Uso de tráfico de %1',
    'ui__client/domain/traffic__title' => 'Estadísticas de transferencia de datos para el dominio %1',
    'ui__client/domain/traffic__description' => 'Vea estadísticas de transferencia de datos para el dominio %1.',
    'ui__client/domain/traffic_self__short-title' => 'Uso de tráfico',
    'ui__client/domain/traffic_self__title' => 'Vea el uso de tráfico para su dominio',
    'ui__client/domain/traffic_self__description' => 'Vea un informe del uso de tráfico para su dominio.',
    'ui__client/domain/hosting/logs__short-title' => 'Administrador de registros',
    'ui__client/domain/hosting/logs__title' => 'Administrador de registros',
    'ui__client/domain/hosting/logs__description' => 'Vea registros y configure su rotación.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Administrador de registros',
    'ui__client/domain/hosting/logs_self__title' => 'Administrador de registros',
    'ui__client/domain/hosting/logs_self__description' => 'Vea registros y configure su rotación.',
    // dropdowns
    'ui__client/domain/report__title' => 'Informe resumido',
    'ui__client/domain/report__short-title' => 'Informe resumido',
    'ui__client/domain/report__description' =>  'Vea un informe sobre el uso de tráfico y recursos.',
    'ui__client/domain/report_unknown__short-title' => 'Informe resumido',
    'ui__client/domain/report_unknown__title' => 'Informe resumido',
    'ui__client/domain/report_unknown__description' => 'Vea un informe sobre el uso de tráfico y recursos.',
    'ui__client/domain/report_self__short-title' => 'Informe resumido',
    'ui__client/domain/report_self__title' => 'Informe resumido',
    'ui__client/domain/report_self__description' => 'Vea el informe sobre el uso de tráfico y recursos.',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => 'Información personal',
    'ui__client/domain/properties__title' => 'Información personal',
    'ui__client/domain/properties__description' => 'Edite la información personal para la cuenta del administrador del dominio.',
    'ui__client/domain/properties_unknown__short-title' => 'Información personal',
    'ui__client/domain/properties_unknown__title' => 'Información personal',
    'ui__client/domain/properties_unknown__description' => 'Edite la información personal de la cuenta.',
    'ui__client/domain/properties_self__short-title' => 'Información personal',
    'ui__client/domain/properties_self__title' => 'Información personal',
    'ui__client/domain/properties_self__description' => 'Edite la información personal de su cuenta.',
    // dropdowns
    'ui__client/domain/rename__title' => 'Renombrar dominio',
    'ui__client/domain/rename__short-title' => 'Renombrar dominio',
    'ui__client/domain/rename__description' => 'Cambiar el nombre del dominio %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Renombrar dominio',
    'ui__client/domain/rename_unknown__title' => 'Renombrar dominio',
    'ui__client/domain/rename_unknown__description' => 'Renombrar dominio',
    'ui__client/domain/chowner_select__title' => 'Asignar propietario nuevo al dominio',
    'ui__client/domain/chowner_select__short-title' => 'Asignar propietario nuevo a la suscripción',
    'ui__client/domain/chowner_select__description' => 'Asignar propietario nuevo a la suscripción',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Asignar propietario nuevo a la suscripción',
    'ui__client/domain/chowner_unknown-select__title' => 'Asignar propietario nuevo a la suscripción',
    'ui__client/domain/chowner_unknown-select__description' => 'Asigne un propietario nuevo a una suscripción.',
    'ui__client/domain/to-client__title' => 'Convertir cuenta de administrador de dominio a cuenta de cliente',
    'ui__client/domain/to-client__short-title' => 'Convertir administrador de dominio a cliente',
    'ui__client/domain/to-client__description' => 'Convertir esta cuenta de administrador de dominio a cuenta de cliente',
    'ui__client/domain/to-client_unknown__short-title' => 'Convertir administrador de dominio a cliente',
    'ui__client/domain/to-client_unknown__title' => 'Convertir cuenta de administrador de dominio a cuenta de cliente',
    'ui__client/domain/to-client_unknown__description' => 'Convertir cuenta de administrador de dominio a cuenta de cliente',
    'ui__client/domain/toggle__title' => 'Suspender o activar dominio', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Suspender o activar dominio', // for HP customization
    'ui__client/domain/toggle__description' => 'Suspenda o active el dominio %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Suspender o activar dominio', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Suspender o activar dominio', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Suspenda o active un dominio.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Activar dominio',
    'ui__client/domain/toggle_enable__short-title' => 'Activar dominio',
    'ui__client/domain/toggle_enable__description' => 'Active el dominio %1.',
    'ui__client/domain/toggle_disable__title' => 'Suspender dominio',
    'ui__client/domain/toggle_disable__short-title' => 'Suspender dominio',
    'ui__client/domain/toggle_disable__description' => 'Suspenda el dominio %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Configuración DNS',
    'ui__client/domain/dns__short-title' => 'Configuración DNS',
    'ui__client/domain/dns__description' => 'Administre los parámetros de configuración de la zona DNS para el dominio %1.',
    'ui__client/domain/dns_self__title' => 'Configuración DNS',
    'ui__client/domain/dns_self__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_self__description' => 'Administre los parámetros de configuración de la zona DNS para su dominio.',
    'ui__client/domain/dns_disabled__title' => 'Configuración DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_disabled__description' => 'Administre la configuración de la zona DNS para el dominio %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Configuración DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Administre los parámetros de configuración de la zona DNS para su dominio.',
    'ui__client/domain/dns_readonly__title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly__description' => 'Examine la configuración de zona DNS para el dominio %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Vea la configuración de zona DNS para su dominio.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Vea la configuración de zona DNS para su dominio.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Vea la configuración de zona DNS para su dominio.',
    'ui__client/domain/dns_slave__title' => 'Configuración DNS',
    'ui__client/domain/dns_slave__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_slave__description' => 'Administre los parámetros de configuración de la zona DNS para el dominio %1.',
    'ui__client/domain/dns_self-slave__title' => 'Configuración DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Configuración DNS',
    'ui__client/domain/dns_self-slave__description' => 'Administre los parámetros de configuración de la zona DNS para su dominio.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Herramientas de MyPlesk.com',
    'ui__client/domain/extras__title' => 'Herramientas de MyPlesk.com',
    'ui__client/domain/extras__description' => 'Obtenga herramientas y servicios adicionales de MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Herramientas de MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Herramientas de MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Obtenga herramientas y servicios adicionales en MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Herramientas de MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Herramientas de MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Obtenga herramientas y servicios adicionales en MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'Fuentes de datos ODBC', // PFW
    'ui__client/domain/odbc__title' => 'Fuentes de datos ODBC', // PFW
    'ui__client/domain/odbc__description' => 'Configure fuentes de datos ODBC para el dominio %1.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'Fuentes de datos ODBC', // PFW
    'ui__client/domain/odbc_self__title' => 'Fuentes de datos ODBC', // PFW
    'ui__client/domain/odbc_self__description' => 'Configure fuentes de datos ODBC para su dominio.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Registrar dominio',
    'ui__client/domain/register__title' => 'Registrar dominio',
    'ui__client/domain/register__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Registrar dominio',
    'ui__client/domain/register_unknown__title' => 'Registrar dominio',
    'ui__client/domain/register_unknown__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Registrar dominio',
    'ui__client/domain/register_self__title' => 'Registrar dominio',
    'ui__client/domain/register_self__description' => 'Registre un nombre de dominio a través de MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'Protección contra Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'Protección contra Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'Proteja los archivos en el dominio %1 contra hotlinking.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'Protección contra Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'Protección contra Hotlink', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'Proteja sus archivos contra hotlinking.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance__title' => 'Limitar uso de ancho de banda y número de conexiones permitidas a su sitio web',
    'ui__client/domain/hosting/performance__description' => 'Vea y edite el límite de uso de ancho de banda para el dominio %1 y el número de conexiones simultáneas a este.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_readonly__title' => 'Límite de uso de ancho de banda y número de conexiones permitidas a su sitio web',
    'ui__client/domain/hosting/performance_readonly__description' => 'Vea el límite de uso de ancho de banda para el dominio %1 y el número de conexiones simultáneas a este.',
    'ui__client/domain/hosting/performance_self__short-title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_self__title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_self__description' => 'Vea y edite el límite de uso de ancho de banda para su dominio y el número de conexiones simultáneas a este.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'Limitación de ancho de banda',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'Vea el límite de uso de ancho de banda para su dominio y el número de conexiones simultáneas a este.',
    'ui__client/domain/hosting/php__short-title' => 'Configuración de PHP', // PFW
    'ui__client/domain/hosting/php__title' => 'Configuración de PHP', // PFW
    'ui__client/domain/hosting/php__description' => 'Configure PHP en el dominio %1.', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'Configuración de PHP', // PFW
    'ui__client/domain/hosting/php_self__title' => 'Configuración de PHP', // PFW
    'ui__client/domain/hosting/php_self__description' => 'Configure PHP en su dominio.', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => 'Seleccione las cuentas de cliente que desea convertir a cuentas de revendedor',
    'ui__client/chowner__empty_selection' => 'Seleccione las cuentas de cliente que desea asignar a un propietario nuevo',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Herramientas",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Ver estadísticas',
    'ui__client/domain-summary-report_unknown__title' => 'Ver estadísticas',
    'ui__client/domain-summary-report_unknown__description' => 'Vea la información acerca del uso de recursos por parte de los dominios.',
    'ui__client/domain-summary-report__short-title' => "Ver estadísticas",
    'ui__client/domain-summary-report__title' => "Ver estadísticas",
    'ui__client/domain-summary-report__description' => "Vea la información acerca del uso de recursos por parte de los dominios.",
    'ui__client/domain-summary-report_self__short-title' => "Ver estadísticas",
    'ui__client/domain-summary-report_self__title' => "Ver estadísticas",
    'ui__client/domain-summary-report_self__description' => "Vea la información acerca del uso de recursos por parte de sus dominios.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Dominios", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => 'Comprobar permisos',
    'ui__client/domain/check-permissions_multi__title' => 'Verificación de permisos',
    'ui__client/domain/check-permissions_multi__description' => 'Verifique los permisos de acceso a carpetas y archivos en un dominio. En el caso de encontrar algún error, este se corregirá automáticamente.',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Seleccione los dominios que desea eliminar',
    'ui__client/domain/properties__empty_selection' => 'Seleccione los dominios que desea modificar',
    'ui__client/domain/chowner__empty_selection' => 'Seleccione los dominios que desea asignar al propietario nuevo',
    'ui__client/domain/check-permissions__empty_selection' => 'Seleccione los dominios cuyos permisos de carpeta y archivo desea comprobar',
    'ui__client/domain/to-client__empty_selection' => 'Seleccione los dominios cuyas cuentas de administrador desea convertir a cuentas de cliente',

    // list objects filtering
    'domains_list__name__filter_title' => 'Nombre',
    'domains_list__state__filter_title' => 'Uso de recursos',
    'domains_list__filter_state_any' => 'Cualquiera',
    'domains_list__filter_state_overuse' => 'Sobreuso',
    'domains_list__filter_state_normal' => 'Dentro de los límites',
    'domains_list__status__filter_title' => 'Estado',
    'domains_list__filter_status_any' => 'Cualquiera',
    'domains_list__filter_status_blocked' => 'Suspendido',
    'domains_list__filter_status_active' => 'Activo',
    'domains_list__ownership__filter_title' => 'Propiedad',
    'domains_list__filter_ownership_all' => 'Todos los dominios',
    'domains_list__filter_ownership_personal' => 'Solo mis dominios',
    'domains_list__filter_owner_pname__filter_title' => 'Nombre del propietario',
    'domains_list__subrows__filter_title' => 'Mostrar',
    'domains_list__subrows_off' => 'Solo dominios',
    'domains_list__subrows_subdomain_domainaliases' => 'Con subdominios y alias',
    'domains_list__subrows_subdomain' => 'Con subdominios',
    'domains_list__subrows_domainaliases' => 'Con alias',

    // objects list
    'domains_list__owner__title' => 'Propietario',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Examinar aplicaciones",
    'site_apps__promo_main_text' => "El catálogo Application Packaging Standard (APS) contiene la lista de aplicaciones que pueden aprovisionarse en un dominio o espacio web. Si desea aprovisionar aplicaciones que o están en el catálogo, puede hacerlo muy fácilmente siguiendo las indicaciones de paquetización de APS detalladas en www.apsstandard.com",
    'site_apps__promo_download_now' => "Descarga de aplicaciones:",
    'site_apps__promo_close' => "Cerrar este bloque",
    'site_apps__promo_preset__mostused' => '%1 más popular',
    'site_apps__promo_preset__lessused' => 'Siguientes %1 más populares',
    'site_apps__promo_preset__all' => "Todo",
    'site_apps__promo_disclaimer_note' => 'Tenga en cuenta que las aplicaciones instaladas desde el Catálogo APS son proporcionadas por terceros y Plesk no ofrece soporte para las mismas.',
    'site_apps__promo_preset__page_title' => '%1 aplicaciones APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Añadiendo aplicaciones...',

    // Errors
    'site_apps__no_applications_for_update' => 'En el Application Vault no tiene instalada ninguna aplicación.',
    'site_apps__incorrect_download_preset_configuration' => 'Se han encontrado errores en la configuración de la definición de descarga del catálogo APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'La URL especificada no es válida.',
    'site_apps__no_updates_at_the_moment' => 'En este momento no existe ninguna actualización para la aplicación.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Se ha recibido información incorrecta del catálogo de aplicaciones APS. Inténtelo de nuevo transcurridos unos minutos.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'La configuración del catálogo APS ha sido guardada pero Plesk no pudo conectarse al catálogo APS especificado en la configuración del catálogo APS (%1). Compruebe que la dirección del catálogo APS es correcta y que el catálogo APS en dicha dirección está activo.',
    'site_apps__cannot_retrieve_updates' => 'En este momento no se pueden descargar actualizaciones para la aplicación: no se ha podido establecer una conexión con el catálogo APS (%1). Compruebe que la dirección del catálogo APS es correcta y que el catálogo APS en esta dirección está activo.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'No existe ninguna aplicación web que pueda instalarse.',
    'site_apps__site_applications_already_installed_in_root' => 'En los directorios root de estos hosts virtuales ya se han instalado otras aplicaciones web',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "En una plataforma Unix/Linux no se soportan aplicaciones web .NET",
    'site_apps__server_wide_packages_not_supported' => 'No se soportan aplicaciones web a nivel de servidor',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "Se ha programado la adición de %1 aplicaciones web más al Application Vault.",
    'site_apps__applications_all_in_vault' => "Las aplicaciones web seleccionadas ya están presentes en el Application Vault.",
    'site_apps__applications_already_in_download_queue' => "En este momento se están añadiendo %1 aplicaciones web seleccionadas al Application Vault.",
    'site_apps__applications_already_in_valut' => "%1 aplicaciones web seleccionadas ya están presentes en el Application Vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Otro (sin categoría)',

    // Errors
    'site_apps__no_applications_in_category' => 'En esta categoría no existe ninguna aplicación. Seleccione otra categoría.',
    'site_apps__no_category_selected__please_specify' => 'Seleccione una categoría en el menú a la izquierda. En esta ventana se enumeran todas las aplicaciones disponibles en la categoría seleccionada.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Cuenta de administrador',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'General',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Cambiar nombre de host',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Seguridad',
    'bt_setup_firewall' => 'Configurar firewall',
    'bt_manage_firewall_rules' => 'Administrar reglas del firewall',
    'cu_firewall__rule' => 'Crear una regla de firewall',
    'cu_firewall__protocol' => 'Definir un protocolo para la regla (\'tcp\' o \'udp\')',
    'cu_firewall__name' => "Definir un nombre de regla",
    'cu_firewall__disabled' => 'De ser \'true\', la regla se desactiva tras la creación',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Seleccionar servidor DNS', // PFW
    'bt_soa_records_template' => 'Plantilla de registros SOA',
    'bt_restrict_creation_of_subzones' => 'Restricción de creación de subzonas',

    'databases' => 'Bases de datos',
    'bt_select_mssqlwebadmin' => 'Seleccionar MS SQL Webadmin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplicaciones',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Correo',
    'bt_select_mailserver' => 'Seleccionar servidor de correo', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Seleccionar antivirus', // PFW
    'bt_virus_protection_settings' => 'Configuración de la protección antivirus',
    'bt_select_spamfilter' => 'Seleccionar filtro antispam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Seleccionar webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Registros  y estadísticas',
    'bt_server_statistics_settings' => 'Configuración de estadísticas del servidor',
    'bt_select_web_statistics' => 'Software disponible de estadísticas web', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interfaz de Plesk',

    'components_and_modules' => 'Componentes y módulos',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Configurar Watchdog', // PFU
    'bt_setup_vpn' => 'Configurar VPN', // PFU
    'bt_setup_samba' => 'Configurar Samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Configuración',
    'ui__client/domain/settings_self__short-title' => 'Configuración',
    'ui__client/domain/settings_self__description' => 'Vea y edite la configuración del dominio.',

    'domain_administrator_account' => 'Cuenta de administrador de dominio',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Configuración de cuenta',

    'domain' => 'Dominio',
    'bt_dns_soa_records' => 'Registros SOA DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Configuración del programador de tareas',

    'website' => 'Sitio web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripting para usuarios web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Seleccione el certificado SSL/TLS',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Estadísticas web',
    'bt_log_rotation_settings' => 'Configuración de rotación de registros',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Límites", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Directiva de sobre venta y sobre uso de recursos",
    'limits__overuse_policy_legend' => "Sobreuso",
    'limits__oversell_policy_legend' => "Sobre venta",
    'limits__reseller_overuse_description' => "La directiva de sobreuso indica a Plesk cómo actuar cuando se haga un uso excesivo de los recursos.",
    'limits__overuse_text' => "Directiva de sobreuso",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Espacio en disco y tráfico',
    'limit__disk_space' => 'Espacio en disco',
    'limit__max_traffic' => 'Tráfico',
    'limit_group__client' => 'Clientes',
    'limit__max_cl' => 'Clientes',
    'limit_group__domain' => 'Dominios',
    'limit__max_dom' => 'Dominios',
    'limit__max_dom_powerUser' => 'Suscripciones',
    'limit__max_subdom' => 'Subdominios',
    'limit__max_dom_aliases' => 'Alias de dominio',
    'limit__max_wu' => 'Usuarios web',
    'limit__max_subftp_users' => 'Cuentas FTP adicionales', // PFW
    'limit_group__mail' => 'Correo',
    'limit__max_box' => 'Buzones de correo',
    'limit__mbox_quota' => 'Tamaño del buzón de correo',
    'limit__total_mboxes_quota' => 'Cuota total de buzones', // PFW
    'limit__max_maillists' => 'Listas de correo',
    'limit_group__database' => 'Bases de datos',
    'limit__max_mssql_db' => 'Bases de datos Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Cuota total de bases de datos MS SQL', // PFW
    'limit__max_odbc' => 'Conexiones ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Cuota de bases de datos MySQL', // PFW?
    'limit_group__application' => 'Aplicaciones',
    'limit__max_iis_app_pools' => 'Grupos de aplicaciones IIS', // PFW
    'limit_group__security' => 'Seguridad',
    'limit_group__validity' => 'Fecha de expiración',
    'limit__expiration' => 'Fecha de expiración',
    'limit__validity' => 'Periodo de validez',
    'limit__max_site_builder' => 'Sitios publicados con Presence Builder',
    'limit__max_site' => 'Dominios',
    'limit__mssql_dbase_filesize' => 'Tamaño del archivo de una base de datos MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Tamaño del archivo de registro de una base de datos MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'El tamaño máximo de un archivo de una base de datos Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'El tamaño máximo de un archivo de registro de una base de datos Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Límite de dominios incorrecto. El valor mínimo es  1.',

    'property__has_wrong_value' => 'La propiedad %1 presenta una valor que no es correcto.',
    'property__name_outgoing_messages_domain_limit' => 'Establece el límite de correos salientes desde un dominio (por hora). Para definir un valor ilimitado, indique "-1". Especifique "default" para establecer el valor especificado en la configuración a nivel del servidor.',
    'property__name_outgoing_messages_mbox_limit' => 'Estable el límite de correos salientes desde un buzón (por hora). Para definir un valor ilimitado, indique "-1". Especifique "default" para establecer el valor especificado en la configuración a nivel del servidor.',
    'property__name_outgoing_messages_subscription_limit' => 'Estable el límite de correos salientes desde una suscripción (por hora). Para definir un valor ilimitado, indique "-1". Especifique "default" para establecer el valor especificado en la configuración a nivel del servidor.',

    // for CLI report & email notifications
    '__resource_notify' => 'Notificar',
    '__general' => 'General',
    '__template_shared' => 'Plantilla compartida',
    'limit__overuse' => 'Directiva de sobreuso',
    'limit__max_traffic_soft' => 'Notificarme cuando el uso de tráfico alcance',
    'limit__disk_space_soft' => 'Notificar cuando el uso del espacio en disco alcance',
    '__overuse' => 'Directiva de sobreuso',
    'performance__title' => 'Rendimiento',
    'performance__bandwidth' => 'Uso máximo de ancho de banda (KB/s)',
    'performance__max_connections' => 'Conexiones limitadas a',

    'gch__hosting_php_isapi' => 'Ejecutar PHP como extensión ISAPI',
    'gch__hosting_ssi_html' => 'Usar SSI para archivos *.htm, *.html',
    'gch__hosting_php_handler_type' => 'ejecutar PHP como',
    'gch__hosting_php_handler_id' => 'ejecutar PHP como',
    'gch__hosting_php_served_by_nginx' => 'PHP servido por nginx',
    'gch__hosting_unpaid_website_status' => 'Estado de los sitios web en suscripciones suspendidas',
    'gch__mn_no_autoresponder' => 'No se han configurado respuestas automáticas para la cuenta de correo.',
    'gch__no_clients_selected' => "No ha seleccionado ninguna cuenta de cliente",
    'gch__no_domains_selected' => "No ha seleccionado ningún dominio",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/mes",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nombre del recurso',
    '__resource_usage' => 'Usado',
    '__resource_limit' => 'Límite',

    '__used' => 'Usado',
    '__limit' => 'Límite',

    '__never_expires' => 'Nunca expira',
    '__resource_free' => '%1 disponible de %2',
    '__resource_unlimited' => '%1 usado de Ilimitado',

    '__unlimited' => 'Ilimitado',
    '__increment' => "Incrementar (+)",
    '__decrement' => "Decrementar (-)",
    '__pt' => 'unidades',
    '__procent' => '%',
    '__overused' => 'Usado en exceso',
    '__left' => 'pendientes',
    '__available' => 'disponible',
    '__not_available' => 'No incluido',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Ver historial de tráfico',
    'ui__admin/report/traffic-history__title' => 'Ver historial de tráfico',
    'ui__admin/report/traffic-history__description' => 'Vea el historial de tráfico de revendedores, clientes y dominios.',
    'admin_traffic_history__title' => 'Historial de tráfico',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Programación de entrega',
    'ui__admin/report/layout/auto_unknown__title' => 'Programación de entrega de informe',
    'ui__admin/report/layout/auto_unknown__description' => 'Seleccione la programación de entrega de informe para un diseño de informe.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Añadir programación de entrega de informe',
    'ui__admin/report/layout/auto/properties_new__title' => 'Añadir programación de entrega de informe',
    'ui__admin/report/layout/auto/properties_new__description' => 'Añada una programación de entrega de informes para el informe %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Programación de entrega de informe',
    'ui__admin/report/layout/auto/properties__title' => 'Programación de entrega de informe',
    'ui__admin/report/layout/auto/properties__description' => 'Vea y modifique las propiedades de la programación de entrega del informe.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Eliminar programación de entrega de informe',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Eliminar programación de entrega de informe',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Elimine las programaciones de entrega de informes seleccionadas.',

    'ui__admin/report/layout_unknown__short-title' => 'Diseños de informe',
    'ui__admin/report/layout_unknown__title' => 'Diseños de informe',
    'ui__admin/report/layout_unknown__description' => 'Examine y administre diseños de informe.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Crear diseño de informe',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Crear diseño de informe',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Cree un diseño de informe.',
    'ui__admin/report/layout/delete_multi__short-title' => 'Eliminar diseños de informe',
    'ui__admin/report/layout/delete_multi__title' => 'Eliminar diseños de informe',
    'ui__admin/report/layout/delete_multi__description' => 'Eliminar los diseños de informe seleccionados',
    'ui__admin/report/layout/properties__short-title' => 'Propiedades',
    'ui__admin/report/layout/properties__title' => 'Propiedades de diseño de informe',
    'ui__admin/report/layout/properties__description' => 'Edite propiedades de diseño de informe.',

    // reseller
    'reseller_traffic_history__title' => "Historial de tráfico del revendedor %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Ver uso de tráfico para el revendedor %1',
    'ui__reseller/traffic__description' => 'Vea informes de uso de tráfico para la cuenta del revendedor %1.',
    'ui__reseller/traffic_self__short-title' => 'Mi',
    'ui__reseller/traffic_self__title' => 'Ver uso de tráfico por clientes',
    'ui__reseller/traffic_self__description' => 'Vea informes de uso de tráfico para sus cuentas de cliente.',

    'ui__reseller/report/traffic-history__short-title' => 'Ver historial de tráfico',
    'ui__reseller/report/traffic-history__title' => 'Ver historial de tráfico',
    'ui__reseller/report/traffic-history__description' => "Vea el historial de tráfico del revendedor %1.",
    'ui__reseller/report/traffic-history_self__short-title' => 'Ver historial de tráfico',
    'ui__reseller/report/traffic-history_self__title' => 'Ver historial de tráfico',
    'ui__reseller/report/traffic-history_self__description' => 'Vea su historial de tráfico.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Programación de entrega',
    'ui__reseller/report/layout/auto_unknown__title' => 'Programación de entrega de informe',
    'ui__reseller/report/layout/auto_unknown__description' => 'Seleccione la programación de entrega de informe para un diseño de informe.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Añadir programación de entrega de informe',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Añadir programación de entrega de informe',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Añada una programación de entrega de informes para el informe %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Programación de entrega de informe',
    'ui__reseller/report/layout/auto/properties__title' => 'Programación de entrega de informe',
    'ui__reseller/report/layout/auto/properties__description' => 'Vea y modifique propiedades de programación entrega del informe.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Eliminar programación de entrega de informe',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Eliminar programación de entrega de informe',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Eliminar programaciones de entrega de informe seleccionadas.',

    'ui__reseller/report/layout_unknown__short-title' => 'Diseños de informes',
    'ui__reseller/report/layout_unknown__title' => 'Diseños de informes',
    'ui__reseller/report/layout_unknown__description' => 'Vea y administre diseños de informes.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Crear diseño de informe',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Crear diseño de informe',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Cree un diseño de informe.',
    'ui__reseller/report/layout/properties_new__short-title' => 'Crear diseño de informe',
    'ui__reseller/report/layout/properties_new__title' => 'Crear diseño de informe',
    'ui__reseller/report/layout/properties_new__description' => 'Cree un diseño de informe.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Eliminar diseños de informe',
    'ui__reseller/report/layout/delete_multi__title' => 'Eliminar diseños de informe',
    'ui__reseller/report/layout/delete_multi__description' => 'Eliminar diseños de informe seleccionados',
    'ui__reseller/report/layout/properties__short-title' => 'Propiedades',
    'ui__reseller/report/layout/properties__title' => 'Propiedades del diseño de informe',
    'ui__reseller/report/layout/properties__description' => 'Edite las propiedades de un diseño de informe.',

    // customer
    'cl_traffic_history__title' => "Historial de tráfico del cliente %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Ver uso de tráfico para el cliente %1',
    'ui__client/traffic__description' => 'Vea informes de uso de tráfico para la cuenta de cliente %1.',
    'ui__client/traffic_self__short-title' => 'Uso de tráfico',
    'ui__client/traffic_self__title' => 'Uso de tráfico por dominios',
    'ui__client/traffic_self__description' => 'Vea informes de uso de tráfico para sus dominios.',

    'ui__client/report/traffic-history__short-title' => 'Ver historial de tráfico',
    'ui__client/report/traffic-history__title' => 'Ver historial de tráfico',
    'ui__client/report/traffic-history__description' => 'Vea el historial de tráfico para el cliente %1.',
    'ui__client/report/traffic-history_self__short-title' => 'Ver historial de tráfico',
    'ui__client/report/traffic-history_self__title' => 'Ver historial de tráfico',
    'ui__client/report/traffic-history_self__description' => 'Vea su historial de tráfico.',



    // domain
    'dom_traffic_history__title' => "Historial de tráfico del dominio %1",

    'ui__client/domain/report/traffic-history__short-title' => 'Ver historial de tráfico',
    'ui__client/domain/report/traffic-history__title' =>  'Ver historial de tráfico',
    'ui__client/domain/report/traffic-history__description' => 'Vea el historial de tráfico del dominio %1.',
    'ui__client/domain/report/traffic-history_self__short-title' => 'Ver historial de tráfico',
    'ui__client/domain/report/traffic-history_self__title' =>  'Ver historial de tráfico',
    'ui__client/domain/report/traffic-history_self__description' => 'Vea el historial de tráfico para su dominio.',



    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => 'Estadísticas sobre visitas seguras al sitio',
    'ui__client/domain/report/web-stats-ssl__title' => 'Estadísticas sobre visitas seguras al sitio %1',
    'ui__client/domain/report/web-stats-ssl__description' => 'Estadísticas sobre visitas seguras al sitio %1.',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => 'SSL/TLS estad Web',
    'ui__client/domain/report/web-stats-ssl_self__title' => 'Estadísticas sobre visitas seguras a su sitio',
    'ui__client/domain/report/web-stats-ssl_self__description' => 'Estadísticas sobre visitas seguras a su sitio.',
    'ui__client/domain/report/ftp-stats__short-title' => 'Estadísticas FTP',
    'ui__client/domain/report/ftp-stats__title' => 'Estadísticas FTP del dominio %1',
    'ui__client/domain/report/ftp-stats__description' => 'Estadísticas del FTP del dominio %1',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'Estadísticas FTP',
    'ui__client/domain/report/ftp-stats_self__title' => 'Estadísticas FTP para su dominio',
    'ui__client/domain/report/ftp-stats_self__description' => 'Estadísticas FTP para su dominio.',
    'ui__client/domain/report/anon-ftp-stats__short-title' => 'Estadísticas FTP anónimo',
    'ui__client/domain/report/anon-ftp-stats__title' => 'Estadísticas del FTP anónimo para el dominio %1',
    'ui__client/domain/report/anon-ftp-stats__description' => 'Estadísticas del FTP anónimo para el dominio %1',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => 'Estadísticas FTP anónimo',
    'ui__client/domain/report/anon-ftp-stats_self__title' => 'Estadísticas FTP anónimo para el dominio %1',
    'ui__client/domain/report/anon-ftp-stats_self__description' => 'Estadísticas FTP anónimo para el dominio %1',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'Configuración de Webalizer',
    'ui__client/domain/report/webalizer-preferences__title' => 'Configuración de Webalizer para %1',
    'ui__client/domain/report/webalizer-preferences__description' => 'Defina el diseño de los informes estadísticos de Webalizer para %1.',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'Configuración de Webalizer',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'Configuración de Webalizer para %1',
    'ui__client/domain/report/webalizer-preferences_self__description' => 'Defina el diseño de informes estadísticos de Webalizer para %1.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'Estado',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nombre del revendedor', // reseller report
    'report__full_client_name' => 'Nombre del cliente', // customer report
    'report__full_domain_name' => 'Nombre del dominio', // domain report
    'report__full_owner' => 'Propietario', // customer & domain reports
    'report__full_creation_date' => 'Fecha de creación',
    'report__full_size' => 'Tamaño',
    'report__full_traffic' => 'Tráfico',
    'report__full_active_clients' => 'Clientes activos', // reseller report
    'report__full_clients' => 'Clientes', // reseller report
    'report__full_active_domains' => 'Dominios activos', // reseller & customer reports
    'report__full_domains' => 'Dominios', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'BuzonesC',
    'report__full_disk_space' => 'Espacio en disco',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'ListCorr',
    'report__full_web_users' => 'UsrWeb',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => 'General',
    'report__version' => 'Versión del producto',
    'report__build' => 'Build del producto',
    'report__status' => 'Estado',
    'report__company_name' => 'Nombre de la empresa',
    'report__personal_name' => 'Nombre',
    'report__login' => 'Nombre de usuario',
    'report__phone' => 'Teléfono',
    'report__fax' => 'Fax',
    'report__email' => 'Email',
    'report__address' => 'Dirección',
    'report__city' => 'Ciudad',
    'report__state' => 'Estado/provincia',
    'report__zip_code' => 'Código postal',
    'report__country' => 'País',
    'report__creation_date' => 'Fecha de creación',
    'report__expiration_date' => 'Fecha de expiración',
    'report__dumps_total_size' => 'Tamaño total de archivos de backup',
    'report__section_resellers' => 'Revendedores',
    'report__active_resellers' => 'Revendedores con suscripciones activas',
    'report__resellers' => 'Revendedores',
    'report__section_full_resellers' => 'Revendedores',
    'report__section_clients' => 'Clientes',
    'report__active_clients' => 'Clientes con suscripciones activas',
    'report__clients' => 'Clientes',
    'report__section_full_clients' => 'Clientes',
    'report__section_personal_clients' => 'Mis clientes',
    'report__active_personal_clients' => 'Sus clientes con suscripciones activas',
    'report__personal_clients' => 'Mis clientes',
    'report__section_full_personal_clients' => 'Mis clientes',
    'report__section_domains' => 'Dominios',
    'report__disk_usage' => 'Uso de disco',
    'report__traffic' => 'Tráfico',
    'report__active_domains' => 'Dominios activos',
    'report__domains' => 'Dominios',
    'report__subdomains' => 'Subdominios',
    'report__mboxes' => 'Buzones de correo',
    'report__mail_groups' => 'Reenvíos de correo electrónico',
    'report__mail_autoresp' => 'Respuestas automáticas',
    'report__mail_lists' => 'Listas de correo',
    'report__web_users' => 'Usuarios web',
    'report__mysql_databases' => 'Bases de datos MySQL',
    'report__mssql_databases' => 'Bases de datos MSSQL',
    'report__section_full_domains' => 'Dominios',
    'report__section_personal_domains' => 'Dominios personales',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Dominios personales',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Sitios publicados con Presence Builder',
    'report__invalid_email' => 'Indique una dirección de email válida.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Usuarios web',
    'report__section_mailnames' => 'Cuentas de correo',
    'report__section_maillists' => 'Listas de correo',
    'report__section_databases' => 'Bases de datos',
    'report__section_siteapps' => 'Aplicaciones web',
    'report__section_aspnetapps' => 'Aplicaciones ASP.NET', // PFW
    'report__owner_pname' => "Nombre del proveedor",
    'report__owner_login' => "Nombre de usuario del proveedor",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'El paquete de idioma especificado está instalado pero no está habilitado en el sistema.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Eliminar sesiones',
    'ui__sessions/delete__title' => 'Eliminar sesiones',
    'ui__sessions/delete__description' => 'Elimine las sesiones seleccionadas.',
    'ui__ftp-sessions__short-title' => 'Sesiones FTP',
    'ui__ftp-sessions__title' => 'Sesiones FTP',
    'ui__ftp-sessions__description' => 'Vea sesiones FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Eliminar sesiones FTP',
    'ui__ftp-sessions/delete__title' => 'Eliminar sesiones FTP',
    'ui__ftp-sessions/delete__description' => 'Eliminar sesiones FTP seleccionadas.',
    'ui__ts-sessions__short-title' => 'Sesiones TS',
    'ui__ts-sessions__title' => 'Sesiones TS',
    'ui__ts-sessions__description' => 'Vea sesiones de servicio terminal.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Eliminar sesiones',
    'ui__reseller/sessions/delete__title' => 'Eliminar sesiones',
    'ui__reseller/sessions/delete__description' => 'Eliminar sesiones seleccionadas.',
    'ui__reseller/sessions/delete_self__short-title' => 'Eliminar sesiones',
    'ui__reseller/sessions/delete_self__title' => 'Eliminar sesiones',
    'ui__reseller/sessions/delete_self__description' => 'Eliminar sesiones seleccionadas.',
    'ui__reseller/ftp-sessions__short-title' => 'Sesiones FTP',
    'ui__reseller/ftp-sessions__title' => 'Sesiones FTP',
    'ui__reseller/ftp-sessions__description' => 'Vea sesiones FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Sesiones FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Sesiones FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Vea sesiones FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Eliminar sesiones FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Eliminar sesiones FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Eliminar sesiones FTP seleccionadas.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Eliminar sesiones FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Eliminar sesiones FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Eliminar sesiones FTP seleccionadas.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Eliminar sesiones',
    'ui__client/sessions/delete__title' => 'Eliminar sesiones',
    'ui__client/sessions/delete__description' => 'Eliminar sesiones seleccionadas.',
    'ui__client/sessions/delete_self__short-title' => 'Eliminar sesiones',
    'ui__client/sessions/delete_self__title' => 'Eliminar sesiones',
    'ui__client/sessions/delete_self__description' => 'Eliminar sesiones seleccionadas.',

    // domain administrator

    'forgery_token_expired' => 'El token de la sesión ha expirado.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Las siguientes cuentas de revendedor se convertirán a cuentas de cliente',
    'downgradeResellers__downgrade' => 'Cuentas de revendedor que se convertirán',
    // controls
    'downgradeResellers__submit_downgrade' => 'Realizar conversión de cuenta.',
    'downgradeResellers__cancel_downgrade' => 'Cancelar conversión de cuenta.',
    'downgradeResellers__confirm' => 'Confirme la conversión',
    'downgradeResellers__confirm_message' => 'Confirme la conversión de la cuenta para proceder',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Selección de cuentas de cliente',
    'upgradeClients__upgrade_clients' => 'Las siguientes cuentas de cliente se convertirán a cuentas de revendedor',
    'upgradeClients__upgrade' => 'Las cuentas de cliente que se convertirán',
    // controls
    'upgradeClients__submit_upgrade' => 'Convierta cuentas.',
    'upgradeClients__cancel_upgrade' => 'Cancele la conversión de la cuenta.',
    'upgradeClients__confirm' => 'Confirme la conversión',
    'upgradeClients__confirm_message' => 'Confirme la conversión de la cuenta para proceder',
    // errors
    'upgradeClient__user_is_already_reseller' => 'No se pudo convertir la cuenta \'%1\' en una cuenta de revendedor: \'%1\' ya es un revendedor.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Las siguientes cuentas de administrador de dominio se convertirán a cuentas de cliente',
    'upgradeDomainUser__upgrade' => 'Las cuentas de administrador de dominio que no se convertirán',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Convierta cuentas.',
    'upgradeDomainUser__cancel_upgrade' => 'Cancele la conversión de cuentas.',
    'upgradeDomainUser__confirm' => 'Confirme la conversión',
    'upgradeDomainUser__confirm_message' => 'Confirme la conversión de la cuenta para proceder',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Las cuentas de administrador de dominio que no pueden convertirse',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Las siguientes cuentas de administrador de dominio no han podido convertirse a cuentas de cliente:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Varias cuentas de administrador de dominio no se pudieron convertir a cuentas de cliente.%%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'La cuenta de administrador de dominio no existe',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "El dominio debería pertenecer directamente al administrador del servidor o a un revendedor.",
    'upgradeDomainUser__all_logins_already_used' => 'No se ha podido crear una cuenta para el cliente resultante.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'La cuenta de administrador de dominio ha sido convertida',
    'upgradeDomainUser__upgrade_notification_body' => 'Su cuenta de administrador de dominio se ha convertido en una cuenta de cliente con nombre de usuario \'%%login%%\' y contraseña \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => 'Asignar propietario nuevo a la cuenta de cliente %1', // customer home
    'ui__client/chowner_multi__wizard-title' => 'Asignar propietario nuevo a las cuentas de cliente seleccionadas', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => 'Asignar propietario nuevo a cuentas de usuario seleccionadas', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => 'Selección de cuentas de cliente',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => 'Seleccione las cuentas de cliente que desea transferir a otro propietario.',
    //  owner selection
    'client_chown__select_title' => 'Seleccione el propietario nuevo para la cuenta de cliente',
    'client_chown__select-multi_title' => 'Seleccione el propietario nuevo para las cuentas de cliente',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "Seleccione el propietario nuevo para las cuentas de cliente seleccionadas.", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => 'Seleccione un propietario nuevo para las cuentas de cliente seleccionadas.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => 'Seleccione el propietario nuevo para las cuentas de cliente seleccionadas.', // reseller & admin home
    // changes check page
    'client_chown__check_title' => 'Revisar cambios y salir del asistente',
    'ui__client/chowner__wizard__2' => 'Revise los cambios y haga clic en Finalizar para completar el asistente.', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => 'Revise los cambios y haga clic en Finalizar para completar el asistente.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => 'Revise los cambios y haga clic en Finalizar para salir del asistente.', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => 'Seleccione el propietario nuevo para las cuentas de cliente seleccionadas',
    'clientOwnerChanger__unable_to_transfer_some_clients' => 'Una o más de las cuentas de usuario seleccionadas no pueden transferirse al propietario nuevo.',
    'client_chown__client_warn' => 'Descripción',

    'clientOwnerChanger__owner_has_no_permission' => 'El revendedor seleccionado no dispone del permiso \'%1\' pero algunos de los clientes sí que disponen de este permiso.',
    'clientOwnerChanger__application_not_allowed' => 'La aplicación \'%1\' no está disponible para el revendedor seleccionado pero sí para algunos de los clientes.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Reasignando las suscripciones seleccionadas',
    // errors
    'domain_chown__empty_selection' => 'Seleccione un propietario nuevo para los dominios seleccionados',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'Rendimiento',
    'hosting_performance__traffic_bandwidth_legend' => 'Activar limitación de ancho de banda',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'Limitación de ancho de banda',
    'hosting_performance__traffic_bandwidth_label' => 'Uso máximo de ancho de banda (%1)',
    'hosting_performance__traffic_bandwidth_hint' => 'El límite de uso de ancho de banda solo es aplicable a datos transferidos a través del protocolo HTTP.',
    'hosting_performance__max_connection_legend' => 'Activar limitación de conexiones',
    'hosting_performance__max_connection_legend_ro' => 'Limitación de conexiones',
    'hosting_performance__max_connection_label' => 'Conexiones limitadas a',
    'hosting_performance__max_connection_hint' => 'Si limita el uso del ancho de banda, le recomendamos que también limite el número de conexiones simultáneas al sitio. De lo contrario, en el caso de peticiones frecuentes al sitio, los procesos del servidor web aumentarán la carga del servidor.',

    // errors:
    'performance__qos_not_installed' => 'Función desactivada porque QoS no está instalado',
    'performance__bandwidth_throttling' => 'No puede controlar la limitación de ancho de banda porque QoS no está instalado.',
    'performance__invalid_value' => "Valor no válido. Debe ser entre %1 y %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Clientes webmail disponibles',
    'webmail__none' => 'Ninguna',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Grupo de direcciones IP del servidor',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'La base de datos no será restaurada: no existe ningún servidor de base de datos apropiado',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Backup del servidor.",
    '__default_backup_comment_reseller' => "Backup de la cuenta de revendedor creado por %1.",
    '__default_backup_comment_client' => "Backup de la cuenta de cliente creado por %1.",
    '__default_backup_comment_domain' => "Backup de la suscripción creado por %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Definición de la asignación de direcciones IP',
    'backup__ip_mapping__download' => 'Guardar asignación IP actual en archivo',
    'b_backup__ip_mapping__download' => 'Haga clic para descargar la configuración de asignación de IP.',
    'b_backup__ip_mapping__download_is_empty' => 'La configuración de asignación de IP está vacía.',
    'backup__ip_mapping_upload__title' => 'Carga de un archivo de asignación de IPs',
    'backup__ip_mapping__upload' => 'Cargar archivo de asignación de IPs',
    'b_backup__ip_mapping__upload' => 'Haga clic para cargar la configuración de asignación de IP.',
    'backup__ip_mapping__list__header' => 'Asignación de IP',
    'backup__ip_mapping__list__adddress' => 'Direcciones IP anteriores',
    'backup__ip_mapping__list__select_ip' => 'Direcciones IP nuevas',
    'backup__ip_mapping__clients_ip' => "Grupo de direcciones IP del cliente %1",
    'backup__ip_mapping__resellers_ip' => "Grupo de direcciones IP del revendedor %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Las direcciones IP dedicadas deberían asignarse a direcciones IP únicas. Seleccione una dirección IP única para cada una de las direcciones IP dedicadas de la lista',
    'backup__ip_mapping__legend' => 'Asignación de IP',
    'backup__ip_mapping__upload_legend' => 'Cargar',
    'backup__ip_mapping__upload_file_text' => 'Archivo de asignación de IPs',
    'backup__ip_mapping__upload_file_hint' => 'El archivo de asignación de IPs es un archivo de texto sin formato. Cada línea de este archivo contiene una asignación de IP en el siguiente formato: <dirección IP anterior> <dirección IP nueva>',
    'backup__ip_mapping__ip_address_not_found' => 'No existen direcciones IP de este tipo disponibles.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'No se ha podido realizar la transferencia de datos porque la asignación de direcciones IP no está completa debido a que no existen direcciones IP libres en el grupo de direcciones IP del servidor de destino.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Se prohibirán las conexiones FTP que no sean seguras para los dominios que tengan esta dirección IP.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Se prohibirán las conexiones FTPS seguras para los dominios que tengan esta dirección IP.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Conflictos',
    'backup__restore__object_vhost' => 'Host virtual',
    'backup__restore__object_plesk_admin' => 'Administrador de Plesk',
    'backup__restore__object_ftpuser' => 'Cuenta FTP',
    'backup__restore__object_frontpageuser' => 'cuenta FrontPage',
    'backup__restore__object_webuser' => 'usuario web',
    'backup__restore__object_domain' => 'dominio',
    'backup__restore__object_subdomain' => 'subdominio',
    'backup__restore__object_domainalias' => 'alias de dominio',
    'backup__restore__object_client' => 'cliente',
    'backup__restore__object_reseller' => 'revendedor',
    'backup__restore__object_autoresponder' => 'respuesta automática',
    'backup__restore__object_mailalias' => 'alias de correo',
    'backup__restore__object_database' => 'base de datos',
    'backup__restore__object_mailname' => 'cuenta de correo',
    'backup__restore__object_db_user' => 'usuario de base de datos',
    'backup__restore__object_ssl_certificate' => 'Certificado SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'No se pueden restaurar los siguientes revendedores porque estos se han convertido en clientes: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'No se pueden restaurar los siguientes clientes porque estos se han convertido en revendedores: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'No se pueden restaurar los siguientes clientes porque estos han sido transferidos a otro revendedor: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'En el servidor de destino no se dispone de suficiente espacio en disco para transferir todas las suscripciones seleccionadas. Espacio disponible: %1 MB. Espacio requerido: %2 MB. Tenga en cuenta que el espacio requerido es la suma del contenido web, de correo y de la base de datos de los dominios. El espacio requerido se calcula una vez al día y se copia en caché, por lo que es posible que el tamaño actual de los dominios no coincida con el tamaño calculado. Si los dominios seleccionados no ocupan más espacio que el disponible, puede proceder con la transferencia.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Libere espacio en disco en el servidor de destino.',
    'backup__restore__capability_source_not_enough_disk_text' => 'En el servidor de origen no dispone de suficiente espacio en disco para guardar los archivos temporales para la transferencia. Espacio en disco disponible: %1 MB. Espacio en disco requerido: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Libere espacio en disco en el servidor de origen.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Información del servidor',

    'backup__restore__capability_not_installed_component_text' => 'El componente %1 no está instalado en el servidor de destino. %1 no estará disponible para todos los objetos restaurados.',
    'backup__restore__capability_not_installed_component_resolution' => 'Instale %1. Tenga en cuenta que esta operación puede tardar unos minutos en completarse.',
    'backup__restore__capability_existing_sys_user_text' => 'Ya existe un usuario del sistema con el nombre %1 en el servidor de destino.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Cambie el nombre del usuario del sistema existente en el servidor de destino.',
    'backup__restore__capability_license_usage_text' => 'Los siguientes límites de recursos del servidor de destino (determinados por la llave de licencia) se excederán tras realizar la transferencia de datos:',
    'backup__restore__capability_license_usage_resolution' => 'Instale en el servidor de destino otra llave de licencia que proporcione la cantidad necesaria de recursos.',
    'backup__restore__capability_max_allowed_packet_text' => "El parámetro 'max_allowed_packet' del servidor de base de datos de origen es %1, por lo que tiene un valor superior al del servidor de destino, cuyo valor es %2. Es posible que algunos elementos de la base de datos de los dominios especificados a continuación no se restauren.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Incremente el valor 'max_allowed_packet' del servidor de base de datos de destino.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'No se han podido transferir las bases de datos PostgreSQL porque la versión de PostgreSQL del servidor de destino es anterior a la del servidor de origen. La versión actual es %1 y la versión requerida es %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Instale la versión adecuada de PostgreSQL en el servidor de destino.',
    'backup__restore__capability_db_server_connection_problems' => 'No ha sido posible conectar con el servidor de base de datos PostgreSQL. Las bases de datos no se transferirán hasta que restaure la conexión.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Compruebe la configuración de la conexión en el servidor de bases de datos de destino.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'El componente %1 está desactivado en el servidor de destino.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Active %1 en el servidor de destino.',
    'backup__restore__capability_not_configured_component_text' => 'El componente %1 no está configurado en el servidor de destino.',
    'backup__restore__capability_not_configured_component_resolution' => 'Configure %1 en la página de Herramientas y utilidades.',

    'backup__restore__capability_webmail_is_not_available' => 'El servicio de webmail %1 no está disponible en el servidor de destino. En su lugar, Plesk utilizará el siguiente servicio de webmail: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Si desea utilizar el mismo webmail que en el servidor de origen, deberá instalarlo en este servidor.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Si desea utilizar el mismo webmail que en el servidor de origen, deberá instalarlo en el servidor de destino.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "El servicio de webmail '%1' no está disponible en el servidor de destino. En su lugar, en las siguientes suscripciones: %3, Plesk usará el siguiente servicio de webmail: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Instale el webmail requerido en el servidor de destino.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Configuración de webmail',

    'backup__restore__capability_shell_is_not_available' => 'El shell %1 no está disponible en el servidor de destino. Se utilizará uno de los shells disponibles en su lugar.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Para utilizar el mismo shell que en el servidor de origen, deberá activarlo (en /etc/shells) o instalarlo en el servidor de destino.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'El servidor DNS de destino no soporta redes en la plantilla de restricciones de transferencia. Los registros con direcciones IP de red de las restricciones de transferencia DNS no se restaurarán.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'El servidor DNS de destino no soporta redes en la plantilla de restricciones de transferencia, pero las restricciones de transferencia de zona DNS de algunas suscripciones las tienen. Los registros con direcciones IP de red de las restricciones de transferencia DNS no se restaurarán.',

    'backup__restore__capability_wrong_php_handler_text' => 'El controlador PHP %1 no está disponible en el servidor de destino. En su lugar, Plesk utilizará el siguiente controlador PHP: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Para utilizar el mismo controlador PHP que en el servidor de origen, es necesario activarlo o instalarlo en el servidor de destino.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'El controlador PHP %1 no está disponible. En su lugar, Plesk utilizará %2 para los siguientes planes de servicio: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'El controlador PHP %1 no está disponible. En su lugar, Plesk utilizará %2 para los siguientes sitios web: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'El controlador de PHP %1 no se encuentra disponible. Este no estará disponible para los siguientes sitios web: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 no está disponible en el servidor de destino. Se utilizará la versión por omisión en su lugar.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Si desea utilizar el mismo %1 que en el servidor de origen, es necesario activarlo o instalarlo en el servidor de destino.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'La política de uso de antivirus del servidor de destino no permite la configuración personal (por dirección de email) del antivirus para el correo saliente. Dicha configuración no se transferirá.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'La política de uso de antivirus del servidor de destino no permite la configuración personal (por dirección de email) del antivirus para el correo entrante. Dicha configuración no se transferirá.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'La política de uso de antivirus del servidor de destino no permite la configuración personal (por dirección de email) de antivirus. Dicha configuración no se transferirá.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Para transferir la configuración personal del antivirus (de forma individualizada para cada dirección de email), active las opciones correspondientes en Herramientas y utilidades > Configuración del antivirus.",
    'backup__restore__capability_antivirus_not_active_text' => 'No hay ningún software antivirus activado. Los ajustes de la configuración de antivirus del servidor de origen no funcionarán hasta que seleccione el software antivirus en el servidor de destino.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Seleccione el software antivirus en Herramientas y utilidades > Configuración de la protección antivirus > sección Configuración del antivirus.',

    'backup__restore__capability_antivirus_another_active_text' => 'El software antivirus %2 no está disponible en el servidor de destino. En su lugar, se utilizará %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Si desea utilizar el mismo antivirus que en el servidor de origen, instálelo y selecciónelo en Herramientas y utilidades > Configuración de la protección antivirus > sección Configuración del antivirus.',
    'backup__restore__capability_not_available_sni_text' => 'SNI no está disponible en el servidor de destino. Los sitios web con la misma dirección IP no podrán utilizar certificados SSL/TLS individuales.',
    'backup__restore__capability_not_available_sni_resolution' => "Verifique que el sistema operativo del servidor de destino soporta SNI y que dicho soporte está activado en Plesk (la casilla 'Activar el soporte SNI, que permite el uso de certificados SSL/TLS individuales en sitios web con la misma dirección IP' en Herramientas y configuración> Configuración del servidor).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Configuración del servidor',

    'backup__restore__capability_vhost_already_exists_text' => 'El sitio web %1 no puede transferirse: ya existe un sitio web con el mismo nombre en el servidor de destino.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Cambie el nombre del sitio web con el mismo nombre o elimínelo del servidor.',
    'backup__restore__capability_removed_vhosts' => 'Las suscripciones detalladas a continuación no serán restauradas porque contienen nombres de dominios ya existentes en el servidor de destino: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Existen %3 controladores PHP diferentes del tipo %1 y versión %2 en el servidor de origen. En su lugar, se utilizará un controlador con el tipo y la versión adecuados en el servidor de destino. Tenga en cuenta que la configuración PHP de los servidores de origen y destino puede variar.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer no ofrece soporte para Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer no ofrece soporte para Python. Instale Python de forma manual.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Configuración del servidor de correo',

    'backup__restore__capability_ftps_disabled' => 'El uso de FTPS seguro se permite en el servidor de origen pero se prohíbe en el servidor de destino. Puede que las aplicaciones de los usuarios que utilicen FTP no funcionen correctamente.',
    'backup__restore__capability_ftps_required' => 'El uso de FTP que no sea seguro se permite en el servidor de origen pero se prohíbe en el servidor de destino. Puede que las aplicaciones de los usuarios que utilicen FTP no funcionen correctamente.',
    'backup__restore__capability_ftps_policy_resolution' => 'Cambie la directiva de FTP seguro en Herramientas y configuración > Directiva de seguridad.',

    'backup__restore__capability_too_much_download_time_text' => 'Se transferirán %1 megabytes de datos del servidor de origen al servidor de destino en %2 horas.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Para que la transferencia se realice más rápido, compruebe su conexión de red entre el servidor de origen y el de destino y resuelva cualquier posible incidencia.',
    'backup__restore__too_low_download_speed' => "inferior a 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Para que la transferencia se realice más rápido, compruebe su conexión de red entre el servidor de origen y el de destino y resuelva cualquier posible incidencia.',
    'backup__restore__capability_zero_download_speed_text' => 'La velocidad mínima de descarga aceptable es de %1 MBps. La velocidad de descarga entre el servidor de origen y el servidor de destino es de 0 MBps. Esto puede deberse a la existencia de problemas con la conexión de red. No es posible realizar la transferencia.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Compruebe su conexión de red entre el servidor de origen y el servidor de destino y resuelva las posibles incidencias.',
    'backup__restore__capability_too_slow_download_speed_text' => 'La velocidad mínima de descarga aceptable es de %2 MBps. La velocidad de descarga entre el servidor de origen y el servidor de destino es de %1 MBps. Esto puede aumentar el tiempo necesario para completar la transferencia. En su entorno actual, la migración de %3 MB tardará %4 horas en completarse.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'La velocidad mínima de descarga aceptable es de %2 MBps. La velocidad de descarga entre el servidor de origen y el servidor de destino es de %1 MBps. Esto puede aumentar el tiempo necesario para completar la transferencia.',

    'backup__restore__capability_remote_database_migration' => "Los siguientes dominios están usando bases de datos remotas: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "¡Si la versión de Plesk presente en el servidor de origen es anterior a la versión 11.5, no elimine estos dominios del servidor de origen tras la transferencia! En su lugar, suspéndalos. Si elimina estos dominios, las bases de datos se eliminarán del servidor remoto. Nota: los archivos de volcado de las bases de datos remotas se almacenarán en el directorio %1 del servidor de origen.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Los backups de archivos de servidores de base de datos MySQL anteriores a la versión 5.1 (%1) puede que no sean restaurados en MySQL 5.1.x, puesto que MySQL 5.1.x gestiona los caracteres Unicode de otra forma.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Lea el artículo 136850 de la base de conocimiento',

    'backup__restore__capability_firewall_not_installed_text' => 'La extensión Firewall no está instalada en el servidor de destino. Si estableció reglas de restricción de acceso, estas reglas no funcionarán.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'Instale la extensión de firewall a través de Plesk Installer.',
    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP no está instalado en el servidor de destino.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Instale Courier-IMAP a través de Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot no está instalado en el servidor de destino.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Instale Dovecot a través de Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'El periodo de conservación de las estadísticas de tráfico de los objetos detallados a continuación es inferior al valor a nivel del servidor en el servidor de destino.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Cambie el valor a nivel del servidor para el tiempo durante el cual deben conservarse las estadísticas en el servidor de destino. Este periodo de conservación debe ser igual o inferior al valor mínimo en las configuraciones de los dominios.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'El periodo de conservación de las estadísticas de tráfico en algunos dominios es inferior al valor a nivel del servidor (%1). El valor se cambiará a %1 para estos dominios.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'El periodo de conservación de las estadísticas de tráfico en algunos planes de servicio es inferior al valor a nivel del servidor (%1). El valor se cambiará a %1 para estos planes de servicio.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'A menos que se haya activado el soporte para SNI, la asignación de una dirección IP exclusiva a una dirección compartida deshabilitará el HTTPS y el FTP anónimo.',

    'backup__restore__no_postgresql_commands_text' => 'La suscripción utiliza una base de datos PostgreSQL remota y su archivo de backup temporal no puede generarse porque los comandos pg_dump y psql no están presentes en el servidor de origen.',
    'backup__restore__no_postgresql_commands_resolution' => 'Instale cualquier paquete de cliente PostgreSQL que soporte estos comandos.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Los siguientes módulos de Apache están deshabilitados en el servidor de destino: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Habilite estos módulos para evitar la aparición de posibles problemas.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Los siguientes módulos de Apache no están instalados en el servidor de destino: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Instale y habilite estos módulos para evitar posibles problemas.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Su licencia no soporta la limitación de los correos salientes. Los parámetros de configuración correspondientes no serán transferidos.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'En el servidor de destino, instale otra llave de licencia que proporcione las prestaciones requeridas.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'La limitación de los correos salientes está desactivada en el servidor de destino. Los parámetros de configuración correspondientes no serán transferidos.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Active la limitación de los correos salientes en el servidor de destino.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Configuración de correo a nivel de servidor',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'La limitación de los correos salientes desde un buzón de correo no es soportada por el servidor de correo utilizado en el servidor de destino. El valor de este límite no será transferido.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Cambie el servidor de correo para que sea el mismo que el que utiliza en el servidor de origen.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Configuración de correo a nivel de servidor',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'La limitación de los correos salientes desde un dominio no es soportada por el servidor de correo utilizado en el servidor de destino. El valor de este límite no será transferido.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Cambie el servidor de correo para que sea el mismo que el que utiliza en el servidor de origen.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Configuración de correo a nivel de servidor',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'La limitación de los correos salientes desde una suscripción no es soportada por el servidor de correo utilizado en el servidor de destino. El valor de este límite no será transferido.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Cambie el servidor de correo para que sea el mismo que el que utiliza en el servidor de origen.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Configuración de correo a nivel de servidor',

    'bu_conflict_resolver_absent_phosting' => 'No se pudieron restaurar los archivos especificados porque no existe hosting físico para restaurarlos. En primer lugar, cree un dominio con hosting físico y a continuación reinicie la restauración del backup.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Los datos de los revendedores no serán restaurados, puesto que no se soporta la gestión de revendedores.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'El componente ModSecurity no está instalado en el servidor de destino.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Instale ModSecurity para que el firewall para aplicaciones web siga funcionando para los sitios transferidos. Tenga en cuenta que la instalación puede tardar unos minutos en completarse.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Instale ModSecurity si desea transferir la configuración del firewall para aplicaciones web. Tenga en cuenta que la instalación puede tardar unos minutos en completarse.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'El componente ModSecurity no está configurado en el servidor de destino.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Configure ModSecurity si desea que el firewall para aplicaciones web siga funcionando para los sitios transferidos.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall para aplicaciones web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity está desactivado en el servidor de destino.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Active ModSecurity si desea que el firewall para aplicaciones web siga funcionando para los sitios transferidos.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall para aplicaciones web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'El componente ModSecurity no está instalado. No se restaurará la configuración del firewall para aplicaciones web para los siguientes objetos: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Los sitios web no pueden restaurarse porque pertenecen a la suscripción %1, que no ha sido encontrada en Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'El componente %1 no está instalado en el servidor de destino. El servicio DNS no estará disponible y se perderá la configuración DNS. Los sitios web de todos los clientes no estarán operativos.',
    'bu_conflict_resolver_dns_not_installed' => 'El servicio DNS no está instalado. No se restaurará la configuración DNS para los siguientes objetos: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Las suscripciones detalladas a continuación no pueden ser restauradas porque fueron transferidas a otros propietarios: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Las suscripciones detalladas a continuación no pueden ser restauradas porque fueron transferidas a otros proveedores: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'No se pudo encontrar la utilidad de restauración de Web Presence Builder para restaurar los datos de Web Presence Builder. Probablemente este no está instalado.',
    'backup__restore__capability_renamed_db' => 'El nombre de la base de datos "%1" ya lo utiliza otra suscripción. El nombre de la base de datos restaurada será "%2".',
    'backup__restore__capability_renamed_db_user' => 'El nombre de usuario de la base de datos "%1" ya lo utiliza otra suscripción. El nombre de usuario de la base de datos restaurada será "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer no ofrece soporte para Perl. Instale ActiveState Perl de forma manual.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% servido por Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% servido por nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Conflictos de sincronización',
    'backup__restore__hint_timing_conflicts' => 'Los conflictos de sincronización se producen cuando el objeto restaurado ya exista en el sistema con una fecha de modificación más reciente o cuando el objeto restaurado no existe en el sistema.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Usar configuración y datos del backup',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Sobrescribir completamente los datos y la configuración del objeto presentes en el sistema por los datos y la configuración del archivo de backup. Si ahora el objeto restaurado pertenece a otro propietario, el objeto se restaurará bajo el propietario anterior.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Usar configuración del sistema actual y datos del backup',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Sobrescribir los datos actuales del objeto por los datos del archivo de backup, pero conservar la configuración del objeto presente en el sistema. Si ahora el objeto restaurado pertenece a otro propietario, el objeto se restaurará bajo el propietario actual.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'No restaurar',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'No restaurar objetos que presenten conflictos de sincronización.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Conflictos de uso de recursos',
    'backup__restore__hint_resource_usage_conflicts' => 'Los conflictos de uso de recursos se producen cuando se exceden los límites de uso de recursos del objeto restaurado tras la restauración.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Permitir sobreuso',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Restaurar el objeto y permitirle usar más recursos de los proporcionados inicialmente.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'No restaurar',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'No restaurar objetos que presenten conflictos de uso de recursos.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Conflictos de configuración',
    'backup__restore__hint_configuration_conflicts' => 'Los conflictos de configuración se producen cuando el objeto restaurado presenta parámetros de configuración y aplicaciones web que no están disponibles o que están prohibidos por la directiva actual del propietario del objeto o servidor. Por ejemplo, pueden aparecer conflictos de configuración si se restauran cuentas de correo que tienen una configuración individual de filtración de spam cuando la directiva actual a nivel de servidor prohíbe que estas cuentas tengan este tipo de configuración.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automático',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Restaurar objeto y habilitar automáticamente todas las opciones de configuración en conflicto que sus permisos le permitan administrar.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'No restaurar',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'No restaurar objetos que presenten conflictos de configuración.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'No se permiten grupos de aplicaciones IIS dedicados en la configuración de grupos de aplicaciones IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Cambie la configuración de su grupo de aplicaciones IIS a través de Herramientas y configuración > Grupo de aplicaciones IIS > Configuración global.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'No se permiten grupos de aplicaciones IIS compartidos en la configuración de grupos de aplicaciones IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Cambie la configuración de su grupo de aplicaciones IIS a través de Herramientas y configuración > Grupo de aplicaciones IIS > Configuración global.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'No se permite el uso de nombres cortos de cuentas de correo POP3/IMAP en el servidor de destino.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Los nombres cortos para cuentas de correo no estarán disponibles una vez completada la restauración de los datos.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'No se ha podido abrir el archivo de registro.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'No se pudo restaurar la suscripción %1 porque esta fue eliminada de su cuenta y no dispone del permiso necesario para crear suscripciones. Si necesita restaurarla, póngase en contacto con su proveedor de servicios.',

    'backup__error11' => 'No dispone de suficiente espacio en disco para crear el backup.',
    'backup__error3011' => 'La conexión ha sido rechazada ? No existe ningún programa que esté escuchando en el puerto y la dirección especificados.',
    'backup__error3012' => 'Tiempo de espera de la conexión.',
    'backup__error3013' => 'No se puede acceder a la red.',
    'backup__error3014' => 'Ninguna ruta al host.',
    'backup__error3015' => 'Error de conexión.',
    'backup__error3016' => 'No se pudo resolver el nombre de host.',
    'backup__error3017' => 'El nombre de usuario o la contraseña no son correctos.',
    'backup__error3018' => 'Error de conexión SSH.',

    'backup__error3110' => 'No ha sido posible conectarse al agente de migración remoto ? La conexión al host no está disponible.',
    'backup__error3111' => 'El agente de migración está bloqueado por una tarea de migración fallida o bien está siendo usado por otro proceso de migración. Reinicie el agente de migración en el servidor origen.',
    'backup__error3112' => 'La conexión al host no está disponible o el agente de migración no está ejecutándose en el host de origen.',
    'backup__error3113' => 'No se pudo desplegar el agente de migración en un host Linux. Verifique que la conexión SSH al host de origen funciona debidamente.',
    'backup__error3114' => 'No se pudo desplegar el agente de migración en un host Linux ? Error de conexión SSH.',
    'backup__error3115' => 'El nombre de usuario o la contraseña no son correctos.',
    'backup__error3116' => 'El usuario especificado no dispone de privilegios administrativos.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Toda la configuración y contenido',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Toda la configuración y contenido excepto el correo',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Solo el contenido y la configuración de correo',

    'dns_t__unable_to_remove_ns_record' => 'No se puede eliminar el registro NS de la plantilla DNS: cada zona DNS debe tener al menos un registro NS.',
    'dns__unsupported_server_zone_transfer' => 'No se puede transferir la plantilla de restricciones de transferencia debido a la configuración DNS a nivel del servidor: en el servidor de origen, las siguientes direcciones de red están permitidas para transferencias de zona, si bien Microsoft DNS Server las prohíbe: %1',
    'dns__unsupported_domain_zone_transfer' => 'No se puede transferir la plantilla de restricciones de transferencia debido a la configuración DNS del dominio: en algunos dominios, las siguientes direcciones de red están permitidas para transferencias de zona, si bien Microsoft DNS Server las prohíbe: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Definición de la asignación de servidores de base de datos',
    'dbbackup__check_network_settings_failed' => 'No se pudo acceder al directorio de red temporal y compartido para archivos de backup. Compruebe el directorio de red y las opciones de nombre de usuario y contraseña. Error: %1',

    'migration_select_exist_db_server' => 'Seleccione el servidor de bases de datos de destino',

    'dbbackup__temp_dir_wrong_value' => 'Se ha especificado un valor para el directorio temporal que no es válido.',
    'dbbackup__network_temp_dir_wrong_value' => 'Se ha especificado un valor para el directorio de red temporal que no es válido.',
    'dbbackup__server_backup_not_configured' => 'En el servidor no se han configurado las opciones de backup de bases de datos.',
    'dbbackup__temp_dir' => 'Directorio temporal',
    'dbbackup__temp_dir_hint' => 'La ruta a una carpeta física presente en el servidor remoto donde se encuentra el servidor MS SQL. Este servidor debe poder acceder a esta carpeta para leer y escribir en archivos temporales de backup. Por ejemplo: C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'La ruta al recurso compartido de red asignado a la carpeta físico indicada arriba. Plesk accederá a la carpeta compartida para descargar y cargar archivos de backup. Por ejemplo, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'El nombre de usuario de un usuario de red creado en el servidor remoto, como por ejemplo, ServerName\\UserName. El usuario debe poder acceder a la carpeta compartida especificada arriba.',
    'dbbackup__network_password_hint' => 'La contraseña del usuario de red',

    'dbbackup__success_import_without_dublicate_users' => 'No se importaron los siguientes usuarios: %1. Estos ya están presentes en el servidor de bases de datos.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Comprimir archivos de registro",
    'log_rot__log_rot_status' => "Estado de rotación de registros",
    'log_rot__log_rot_period' => "Condición de rotación de registros",
    'log_rot__log_rot_size' => "por tamaño",
    'log_rot__log_rot_time' => "por hora",
    'log_rot__logrotation_enable' => "Activar rotación de archivos",
    'log_rot__mail' => "Enviar archivos de registro procesados a la dirección de e-mail",
    'log_rot__max_number_of_logfiles' => "Número máximo de archivos de registro",
    'log_rot__time_period' => "periodo",
    'log_rot__unable_turn_off' => 'No pudo desactivarse la rotación de registros porque esta se impone a nivel del servidor',
    'log_rot__unable_set_period' => 'No pudo establecerse un periodo de rotación de registros distinto a \'a diario\', porque este se impone a nivel del servidor',
    'log_rot__unable_set_max_log_files' => 'No pudo establecerse un número máximo de archivos de registro superior al límite a nivel del servidor de %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Nº esperado: %1",
    'actionlog__incorrect_rotation' => "Ha indicado unos parámetros de rotación de registros no válidos: %1",
    'actionlog__unknown_rot_period' => "Período de rotación desconocido: %1",
    'actionlog__unknown_rot_type' => "Tipo de rotación desconocido: %1",
    'actionlog__session_preferences' => 'Configuración de sesión',
    // items (PFU schema)
    'actionlog__admin_info' => 'Información del administrador',
    'actionlog__admin_preferences' => "Preferencias del administrador",
    'actionlog__service' => 'Servicio',
    'actionlog__ip_addr' => 'Dirección IP',
    'actionlog__client' => 'Cuenta de cliente',
    'actionlog__client_status' => 'Estado de la cuenta del cliente',
    'actionlog__client_preferences' => "Preferencias de interfaz del cliente",
    'actionlog__client_ip_pool' => "Grupo de direcciones IP  del cliente",
    'actionlog__client_siteapp' => "Grupo de aplicaciones web del cliente",
    'actionlog__client_guid' => "GUID del cliente",
    'actionlog__domain' => 'Dominio predeterminado (el primer dominio añadido a una suscripción)',
    'actionlog__domain_owner' => 'Propietario de la suscripción',
    'actionlog__domain_plan' => 'Plan de servicio de la suscripción',
    'actionlog__domain_status' => 'Dominio predeterminado, estado',
    'actionlog__domain_dns' => 'Dominio predeterminado, zona DNS',
    'actionlog__subdomain' => 'Subdominio de un dominio predeterminado',
    'actionlog__domain_alias' => 'Dominio predeterminado, alias',
    'actionlog__domain_alias_dns' => 'Dominio predeterminado, zona DNS del alias',
    'actionlog__site' => 'Dominio',
    'actionlog__site_status' => 'Estado del dominio',
    'actionlog__site_dns' => 'Zona DNS del dominio',
    'actionlog__site_guid' => 'GUID del dominio',
    'actionlog__site_subdomain' => 'Subdominio',
    'actionlog__site_alias' => 'Alias de dominio',
    'actionlog__site_alias_dns' => 'Zona DNS de alias de dominio',
    'actionlog__domain_limits' => 'Límites de la suscripción',
    'actionlog__domain_limit_size' => 'Límite de espacio en disco para la suscripción',
    'actionlog__domain_limit_traffic' => 'Límite de tráfico para la suscripción',
    'actionlog__domain_limits_powerUser' => 'Límites de la suscripción',
    'actionlog__domain_limit_size_powerUser' => 'Límite de espacio en disco para la suscripción',
    'actionlog__domain_limit_traffic_powerUser' => 'Límite de tráfico para la suscripción',
    'actionlog__domain_guid' => "Dominio predeterminado, GUID",
    'actionlog__cp_user' => 'Usuario de Plesk',
    'actionlog__mailname' => 'Cuenta de correo',
    'actionlog__maillist' => 'Lista de correo',
    'actionlog__phosting' => 'Configuración de hosting',
    'actionlog__forwarding' => 'Hosting con redireccionamiento estándar o por marcos',
    'actionlog__webuser' => 'Cuenta de usuario web',
    'actionlog__site_application' => 'Aplicación web',
    'actionlog__license' => 'Llave de licencia',
    'actionlog__additional_license' => 'Llave de licencia adicional',
    'actionlog__template_domain' => "Plan de servicio de revendedor",
    'actionlog__template_admin' => "Plan de servicio de administrador",
    'actionlog__template_reseller' => 'Plan de revendedor',
    'actionlog__admin_alias' => 'Cuenta de administrador adicional', // PFW
    'actionlog__ftpuser' => 'Cuenta FTP adicional', // PFW
    'actionlog__db_server' => 'Servidor de bases de datos',
    'actionlog__db' => 'Base de datos',
    'actionlog__db_user' => 'Cuenta de usuario de base de datos',
    'actionlog__client_sapppkg_pool' => "Aplicación web del usuario", // PFW, not used?
    'actionlog__remote_dns' => 'Estado del servidor DNS remoto', // PFW
    'actionlog__reseller' => 'Cuenta de revendedor',
    'actionlog__reseller_guid' => 'GUID del revendedor',
    'actionlog__reseller_ip_pool' => "Grupo de direcciones IP del revendedor",
    'actionlog__reseller_limit_size' => 'Límite de espacio en disco para la cuenta de revendedor',
    'actionlog__reseller_limit_traffic' => 'Límite de tráfico para la cuenta de revendedor',
    'actionlog__reseller_limits' => 'Límites de la cuenta de revendedor',
    'actionlog__reseller_permissions' => 'Permisos del revendedor',
    'actionlog__reseller_preferences' => "Preferencias de interfaz del revendedor",
    'actionlog__reseller_siteapp' => "Aplicaciones web en el grupo del revendedor",
    'actionlog__reseller_status' => 'Estado de la cuenta de revendedor',
    'actionlog__health_status' => 'Estado del servidor',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'alcanzado',
    'actionlog__added' => 'añadido',
    'actionlog__removed' => 'eliminado',
    'actionlog__change' => 'modificado',
    'actionlog__update' => 'actualizado',
    'actionlog__move' => 'transferido',
    'actionlog__upgrade' => 'actualizado', // PFU?
    'actionlog__update_or_add' => 'actualizado o añadido',
    'actionlog__expired' => 'expirado',
    'actionlog__create' => 'creado',
    'actionlog__delete' => 'eliminado',
    'actionlog__service_stop' => 'detenido',
    'actionlog__service_restart' => 'reiniciado',
    'actionlog__service_start' => 'iniciado',
    'actionlog__login' => 'conectado',
    'actionlog__logout' => 'desconectado',
    'actionlog__install' => 'instalado',
    'actionlog__uninstall' => 'desinstalado',
    'actionlog__reconfigure' => 'reconfigurado',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Petición de restablecimiento de contraseña',
    'actionlog__event_admin_update' => 'Información del administrador actualizada',
    'actionlog__event_admin_preferences_update' => "Preferencias del administrador actualizadas",
    'actionlog__event_service_restart' => 'Servicio reiniciado',
    'actionlog__event_service_start' => 'Servicio iniciado',
    'actionlog__event_service_stop' => 'Servicio detenido',
    'actionlog__event_ip_address_create' => 'Dirección IP creada',
    'actionlog__event_ip_address_delete' => 'Dirección IP eliminada',
    'actionlog__event_ip_address_update' => 'Dirección IP actualizada',
    'actionlog__event_client_create' => 'Cuenta de cliente creada',
    'actionlog__event_client_delete' => 'Cuenta de cliente eliminada',
    'actionlog__event_client_update' => 'Cuenta del cliente actualizada',
    'actionlog__event_client_status_update' => 'Estado de la cuenta del cliente actualizado',
    'actionlog__event_client_preferences_update' => "Preferencias de interfaz del cliente actualizadas",
    'actionlog__event_client_siteapp_added' => "Aplicación web añadida al grupo de aplicaciones de la cuenta del cliente",
    'actionlog__event_client_siteapp_removed' => "Aplicación web eliminada del grupo de aplicaciones de la cuenta del cliente",
    'actionlog__event_domain_limit_size_reached' => 'Límite de espacio en disco alcanzado para la suscripción',
    'actionlog__event_domain_limit_traffic_reached' => 'Límite de tráfico alcanzado para la suscripción',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Límite de espacio en disco alcanzado para la suscripción',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Límite de tráfico alcanzado para la suscripción',

    'actionlog__domain_limit_database' => 'Cuota de bases de datos para la suscripción',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Se alcanzó la cuota de bases de datos MySQL para la suscripción',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Se alcanzó la cuota de advertencia de las bases de datos MySQL para la suscripción',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Se alcanzó la cuota de bases de datos de Microsoft SQL Server para la suscripción',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Se alcanzó la cuota de advertencia de las bases de datos de Microsoft SQL Server para la suscripción',
    'actionlog__event_plesk_component_upgrade' => 'Componente de Plesk actualizado',
    'actionlog__event_plesk_component_install' => 'Componente de Plesk instalado',
    'actionlog__event_plesk_component_uninstall' => 'Componente de Plesk desinstalado',
    'actionlog__event_domain_create' => 'Dominio predeterminado (el primer dominio añadido a una suscripción) creado',
    'actionlog__event_domain_delete' => 'Dominio predeterminado (el primer dominio añadido a una suscripción) eliminado',
    'actionlog__event_domain_update' => 'Dominio predeterminado (el primer dominio añadido a una suscripción) actualizado',
    'actionlog__event_domain_owner_change' => 'Propietario de la suscripción modificado',
    'actionlog__event_domain_plan_change' => 'El plan de servicio de la suscripción ha sido modificado',
    'actionlog__event_domain_status_update' => 'Dominio predeterminado, estado actualizado',
    'actionlog__event_domain_dns_update' => 'Dominio predeterminado, zona DNS actualizada',
    'actionlog__event_subdomain_create' => 'Subdominio de un dominio predeterminado creado',
    'actionlog__event_subdomain_delete' => 'Subdominio de un dominio predeterminado eliminado',
    'actionlog__event_subdomain_update' => 'Subdominio de un dominio predeterminado actualizado',
    'actionlog__event_domain_alias_create' => 'Dominio predeterminado, alias creado',
    'actionlog__event_domain_alias_delete' => 'Dominio predeterminado, alias eliminado',
    'actionlog__event_domain_alias_update' => 'Dominio predeterminado, alias actualizado',
    'actionlog__event_domain_limits_update' => 'Límites de suscripción actualizados',
    'actionlog__event_cp_user_login' => 'El usuario de Plesk inició sesión',
    'actionlog__event_cp_user_logout' => 'El usuario de Plesk cerró la sesión',
    'actionlog__event_mailname_create' => 'Cuenta de correo creada',
    'actionlog__event_mailname_delete' => 'Cuenta de correo eliminada',
    'actionlog__event_mailname_update' => 'Cuenta de correo actualizada',
    'actionlog__event_maillist_create' => 'Lista de correo creada',
    'actionlog__event_maillist_delete' => 'Lista de correo eliminada',
    'actionlog__event_maillist_update' => 'Lista de correo actualizada',
    'actionlog__event_phys_hosting_create' => 'Hosting físico creado',
    'actionlog__event_phys_hosting_delete' => 'Hosting físico eliminado',
    'actionlog__event_phys_hosting_update' => 'Hosting físico actualizado',
    'actionlog__event_forwarding_create' => 'Hosting con redireccionamiento estándar o por marcos creado',
    'actionlog__event_forwarding_delete' => 'Hosting con redireccionamiento estándar o por marcos eliminado',
    'actionlog__event_forwarding_update' => 'Hosting con redireccionamiento estándar o por marcos actualizado',
    'actionlog__event_webuser_create' => 'Cuenta de usuario web creada',
    'actionlog__event_webuser_delete' => 'Cuenta de usuario web eliminada',
    'actionlog__event_webuser_update' => 'Cuenta de usuario web actualizada',
    'actionlog__event_siteapp_install' => 'Aplicación web instalada',
    'actionlog__event_siteapp_reconfigure' => 'Aplicación web reconfigurada',
    'actionlog__event_siteapp_uninstall' => 'Aplicación web desinstalada',
    'actionlog__event_license_update' => 'Llave de licencia actualizada',
    'actionlog__event_admin_alias_create' => 'Cuenta de administrador adicional creada',
    'actionlog__event_admin_alias_delete' => 'Cuenta de administrador adicional eliminada',
    'actionlog__event_admin_alias_update' => 'Cuenta de administrador adicional actualizada',
    'actionlog__event_ftpuser_create' => 'Cuenta FTP adicional creada',
    'actionlog__event_ftpuser_update' => 'Cuenta FTP adicional actualizada',
    'actionlog__event_ftpuser_delete' => 'Cuenta FTP adicional eliminada',
    'actionlog__event_template_domain_create' => "Plan de servicio de revendedor creado",
    'actionlog__event_template_domain_update' => "Plan de servicio de revendedor actualizado",
    'actionlog__event_template_domain_delete' => "Plan de servicio de revendedor eliminado",
    'actionlog__event_template_admin_create' => "Plan de servicio de administrador creado",
    'actionlog__event_template_admin_update' => "Plan de servicio de administrador actualizado",
    'actionlog__event_template_admin_delete' => "Plan de servicio de administrador eliminado",
    'actionlog__event_database_server_create' => 'Servidor de base de datos creado',
    'actionlog__event_database_server_update' => 'Servidor de base de datos actualizado',
    'actionlog__event_database_server_delete' => 'Servidor de base de datos eliminado',
    'actionlog__event_remote_dns_status_update' => 'Estado del servidor DNS remoto actualizado',
    'actionlog__event_session_preferences_update' => 'Configuración de sesión actualizada',
    'actionlog__event_domain_alias_dns_update' => 'Dominio predeterminado, zona DNS del alias de dominio actualizada',
    'actionlog__event_domain_move' => 'Dominio predeterminado transferido a una suscripción nueva',
    'actionlog__event_site_move' => 'Dominio transferido a una suscripción nueva',
    'actionlog__event_site_subdomain_move' => 'Subdominio transferido a una nueva suscripción',
    'actionlog__event_subdomain_move' => 'Subdominio de un dominio predeterminado transferido a una suscripción nueva',
    'actionlog__event_license_expired' => 'La licencia de Plesk ha expirado',
    'actionlog__event_database_create' => 'Base de datos creada',
    'actionlog__event_database_delete' => 'Base de datos eliminada',
    'actionlog__event_database_user_create' => 'Cuenta de usuario de base de datos creada',
    'actionlog__event_database_user_update' => 'Configuración de la cuenta de usuario de base de datos actualizada',
    'actionlog__event_database_user_delete' => 'Cuenta de usuario de base de datos eliminada',
    'actionlog__event_client_guid_update' => "GUID del cliente actualizado",
    'actionlog__event_domain_guid_update' => 'Dominio predeterminado, GUID actualizado',
    'actionlog__event_reseller_create' => 'Cuenta de revendedor creada',
    'actionlog__event_reseller_delete' => 'Cuenta de revendedor eliminada',
    'actionlog__event_reseller_update' => 'Cuenta del revendedor actualizada',
    'actionlog__event_reseller_guid_update' => 'GUID del revendedor actualizado',
    'actionlog__event_reseller_ip_pool_update' => "Grupo de direcciones IP del revendedor actualizado",
    'actionlog__event_reseller_limit_size_reached' => 'Límite de espacio en disco alcanzado para la cuenta de revendedor',
    'actionlog__event_reseller_limit_traffic_reached' => 'Límite de tráfico alcanzado para la cuenta del revendedor',
    'actionlog__event_reseller_limits_update' => 'Límites de la cuenta del revendedor actualizados',
    'actionlog__event_reseller_permissions_update' => 'Permisos de la cuenta del revendedor actualizados',
    'actionlog__event_reseller_preferences_update' => "Preferencias del interfaz del revendedor actualizadas",
    'actionlog__event_reseller_siteapp_added' => "Aplicación añadida al grupo de aplicaciones de la cuenta del revendedor",
    'actionlog__event_reseller_siteapp_removed' => "Aplicación eliminada del grupo de aplicaciones de la cuenta del revendedor",
    'actionlog__event_reseller_status_update' => 'Estado de la cuenta del revendedor actualizado',
    'actionlog__event_template_reseller_create' => 'Plan de revendedor creado',
    'actionlog__event_template_reseller_delete' => 'Plan de revendedor eliminado',
    'actionlog__event_template_reseller_update' => 'Plan de revendedor actualizado',
    'actionlog__event_health_status_change' => 'Estado del servidor cambiado',
    'actionlog__event_siteapp_upgrade' => 'App web actualizada',
    'actionlog__event_extension_install' => 'Extensión instalada',
    'actionlog__event_extension_uninstall' => 'Extensión desinstalada',
    'actionlog__event_extension_upgrade' => 'Extensión actualizada',
    'actionlog__event_extension_status_update' => 'Estado de la extensión actualizado',
    'actionlog__event_additional_license_expired' => 'La licencia adicional ha expirado',
    'actionlog__event_hostname_changed' => 'Nombre de host del servidor cambiado',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "La API RPC de Plesk no está instalada en el host remoto. Póngase en contacto con su proveedor de servicios para obtener asistencia.",
    'rsession_no_account_errmsg' => "No se puede acceder al servicio remoto con su cuenta. Lo más probable es que el servicio para su cuenta aún no haya sido activado. Espere unos minutos e inténtelo de nuevo. Si vuelve a experimentar este error, contacte con su administrador de sistema.",
    'rsession_no_domain_errmsg' => "No se puede acceder al servicio remoto para este dominio.Lo más probable es que el servicio para este dominio aún no haya sido activado. Espere unos minutos e inténtelo de nuevo. Si vuelve a experimentar este error, contacte con su administrador de sistema.",
    'rsession_unknown_errmsg' => "El servidor remoto ha rechazado el intento de establecer una sesión. Contacte con su administrador de sistema para obtener soporte.El error fue: %1",
    'rsession_unknown2_errmsg' => "Error desconocido durante el establecimiento de una sesión remota. Lo más probable es que el servidor remoto no responde correctamente o simplemente no responda. Solicite a su administrador de sistema que compruebe los detalles del error presentes en el registro de errores del servidor web.",
    'rsession_no_connect_errmsg' => "No se puede acceder al servicio remoto: error de conexión a la sesión remota. Contacte con su administrador de sistema para obtener soporte.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Permitir cargas al directorio entrante",
    'anonftp__allow_create_dirs' => 'Permitir la creación de directorios en el directorio entrante',
    'anonftp__allow_download_incoming' => 'Permitir descargas desde el directorio entrante',
    'anonftp__display_login' => 'Mostrar mensaje de bienvenida',
    'anonftp__login_text' => 'Texto del mensaje',
    'anonftp__limit_incoming_disk_space' => "Limitar espacio en disco en el directorio entrante",
    'anonftp__limit_maximum_bandwidth' => "Limitar ancho de banda de descarga para este dominio FTP virtual",
    'anonftp__limit_maximum_connections' => "Limitar número de conexiones simultáneas",
    'anonftp__unable_init' => "No se puede inicializar la cuenta de FTP anónimo: %1",
    'anonftp__unable_set_quota' => "No se puede establecer el límite de espacio en disco del directorio entrante: %1",
    'anonftp__unable_update' => "No se pueden actualizar las propiedades de la cuenta de FTP anónimo: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Certificados SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "El certificado CA no firma el certificado.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Par de clave privada/certificado incompatible.",
    'class_sslcertificate__invalid_cert_format' => "Formato del certificado no válido.",
    'class_sslcertificate__invalid_private_key_format' => "Formato de la clave privada no válido.",
    'class_sslcertificate__prob_invalid_priv_key' => "Seguramente el formato de la clave privada no es válido.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Crear directorio virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Crear directorio virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Cree un directorio virtual.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Crear directorio virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Crear directorio virtual',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Cree un directorio virtual.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Crear directorio',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Crear directorio',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Cree un directorio.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Crear directorio',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Crear directorio',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Cree un directorio.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Propiedades del directorio',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Propiedades del directorio virtual',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Vea y modifique las propiedades del directorio virtual.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Propiedades del directorio',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Propiedades del directorio virtual',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Vea y modifique las propiedades del directorio virtual.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Permisos de acceso al directorio',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Permisos de acceso al directorio',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Defina los permisos de acceso al directorio.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Permisos de acceso al directorio',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Permisos de acceso al directorio',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Defina los permisos de acceso al directorio.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Configuración ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Configuración ASP.NET para %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Defina la configuración de ASP.NET para el directorio virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Configuración ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Configuración ASP.NET para %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Defina la configuración de ASP.NET para el directorio virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'Cambiar versión',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'Cambiar versión',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'Cambie la versión de ASP.NET usada por el directorio virtual %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'Cambiar versión',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'Cambiar versión',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'Cambie la versión de ASP.NET usada por el directorio virtual %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Configuración de PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Configuración PHP para %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Defina la configuración PHP para el directorio virtual %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Configuración de PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Configuración PHP para %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Defina la configuración PHP para el directorio virtual %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Eliminar',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Eliminar directorios virtuales',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Elimine los directorios virtuales seleccionados.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Eliminar',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Eliminar directorios virtuales',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Elimine los directorios virtuales seleccionados.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Se eliminarán los siguientes directorios virtuales:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Seleccione los directorios que desea eliminar.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Tipos MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Tipos MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Consulte la lista de tipos MIME registrados.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Añadir tipo MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Adición de un tipo MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Registre un tipo MIME nuevo.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Documentos de error',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Documentos de error',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Vea y edite documentos de error.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Protección',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Protección de directorios',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Limite el acceso al directorio estableciendo una contraseña.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Protección',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Protección de directorio',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Limite el acceso al directorio estableciendo una contraseña.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Configuración',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Vea la ubicación del directorio y especifique un nombre para el área protegida.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Añadir usuario',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Añada una cuenta de usuario para permitir el acceso al directorio protegido.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'La configuración nueva ha sido aplicada.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'La cuenta de usuario ha sido añadida.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Elimine usuarios del directorio protegido.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Eliminar cuentas de usuario',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Confirme la eliminación de cuentas de usuario.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Las cuentas de usuario han sido eliminadas.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => 'Se ha iniciado el proceso de verificación de permisos. Una vez completado el proceso de verificación, se enviará una notificación a la siguiente dirección de email: %1', // PFW
    'additional_keys__install_done' => 'Instalación de la llave de licencia iniciada.',

    // UI
    'ui____done' => 'Operación completada correctamente.',
    'ui__admin/extras-domain__done' => 'La página de MyPlesk.com ha sido abierta.',
    'ui__admin/interface__done' => 'Los cambios realizados en la preferencias de interfaz del administrador del servidor se han guardado correctamente.',
    'ui__admin/report/layout/delete_multi__done' => 'Los diseños de informe seleccionados han sido eliminados.',
    'ui__admin/report/traffic-history__done' => 'Operación completada correctamente.',
    'ui__admin/report__done' => 'Operación completada correctamente.',
    'ui__admin-alias/delete_multi__done' => "Las cuentas de administrador adicionales seleccionadas han sido eliminadas.",
    'ui__admin-alias/properties__done' => "Las propiedades de la cuenta adicional de administrador han sido actualizadas.",
    'ui__admin-alias/properties_new__done' => "La cuenta adicional del administrador ha sido creada.",
    'ui__admin-alias/properties_unknown__done' => "Las propiedades de la cuenta adicional de administrador han sido actualizadas.",
    'ui__admin-alias__done' => "La información de la cuenta adicional del administrador ha sido actualizada.",
    'ui__admin/manage-domain__done' => 'La página de MyPlesk.com ha sido abierta.',
    'ui__admin/register-domain__done' => 'La página MyPlesk.com ha sido abierta.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Las programaciones de entrega de informes seleccionadas han sido eliminadas.',
    'ui__admin/report/layout/auto/properties__done' => 'La programación de entrega de informe ha sido actualizada.',
    'ui__admin/report/layout/auto/properties_new__done' => 'La programación de entrega de informe ha sido creada.',
    'ui__admin/report/layout/properties__done' => 'El diseño de informe %1 ha sido actualizado.',
    'ui__admin/report/layout/properties_new__done' => 'El diseño de informe %1 ha sido creado.',
    'ui__client/chowner__done' => 'Se ha asignado un propietario nuevo a la cuenta de cliente %1.',
    'ui__client/chowner_multi__done' => "Las cuentas de usuario seleccionadas han sido transferidas a otro propietario.",
    'ui__client/chowner_multi-select__done' => 'Operación completada correctamente.',
    'ui__client/chowner_select__done' => 'Operación completada correctamente.',
    'ui__client/domain/certificate/properties__done' => 'Las propiedades del certificado SSL/TLS han sido actualizadas.',
    'ui__client/domain/certificate/properties_new__done' => 'El certificado SSL/TLS nuevo ha sido añadido. Para poderlo usar, selecciónelo en la configuración de hosting del sitio web (en la pestaña Sitios web y dominios> nombre del dominio).',
    'ui__client/domain/certificate__done' => 'Operación completada correctamente.',
    'ui__client/domain/certificate_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/check-permissions_multi__done' => 'La verificación de permisos para los dominios seleccionados ha finalizado.', // PFW
    'ui__client/domain/chowner__done' => 'Ahora la suscripción %1 pertenece a otro usuario.',
    'ui__client/domain/chowner_multi__done' => 'El propietario de la suscripción ha sido modificado.',
    'ui__client/domain/chowner_multi-select__done' => 'Operación completada correctamente.',
    'ui__client/domain/chowner_select__done' => 'Operación completada correctamente.',
    'ui__client/domain/dbbackup/create__done' => "La base de datos se ha copiado correctamente.", // PFW
    'ui__client/domain/dbbackup/get__done' => "La base de datos se ha copiado correctamente.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "El usuario huérfano se ha reparado correctamente.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Los archivos de backup se han eliminado correctamente.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "El contenido de la base de datos se ha restaurado correctamente.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Operación completada correctamente.", // PFW
    'ui__client/domain/dbbackup__done' => "Operación completada correctamente.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Operación completada correctamente.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Operación completada correctamente.", // PFW
    'ui__client/domain/delete__done' => "El dominio %1 ha sido eliminado.",
    'ui__client/domain/delete_multi__done' => "Los dominios han sido eliminados.",
    'ui__client/domain/disable__done' => 'El dominio %1 ha sido suspendido.',
    'ui__client/domain/disable_multi__done' => 'Los dominios seleccionados han sido suspendidos.',
    'ui__client/domain/enable__done' => 'El sitio web %1 ha sido activado.',
    'ui__client/domain/enable_multi__done' => 'Los sitios web seleccionados han sido activados.',
    'ui__client/domain/extras__done' => 'La página de MyPlesk.com ha sido abierta.',
    'ui__client/domain/extras_self__done' => 'La página de MyPlesk.com ha sido abierta.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'Los directorios y archivos seleccionados han sido copiados o movidos.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'El directorio ha sido creado.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'El archivo ha sido creado.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'El archivo ha sido actualizado.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'Los permisos de acceso para el archivo o directorio han sido actualizados.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'El nombre del archivo o directorio ha sido cambiado.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'Los archivos y directorios seleccionados han sido eliminados.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'Los archivos y directorios seleccionados han sido eliminados.',
    'ui__client/domain/hosting/file-manager/view__done' => 'Operación completada correctamente.',
    'ui__client/domain/hosting/file-manager__done' => 'Operación completada correctamente.',
    'ui__client/domain/hosting/file-manager_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'La configuración de rotación de registros ha sido actualizada.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'La configuración de rotación de registros ha sido actualizada.',
    'ui__client/domain/hosting/logs__done' => 'Operación completada correctamente.',
    'ui__client/domain/hosting/logs_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/hosting/performance__done' => 'La configuración de rendimiento de hosting para el sitio web %1 ha sido actualizada.',
    'ui__client/domain/hosting/performance_self__done' => 'La configuración de rendimiento de hosting para su sitio web ha sido actualizada.',
    'ui__client/domain/hosting/performance_unknown__done' => 'La configuración de rendimiento de hosting web ha sido actualizada.',
    'ui__client/domain/hosting/php__done' => 'La configuración PHP ha sido actualizada.', // PFW
    'ui__client/domain/hosting/php_self__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/hosting/protected-directories__done' => 'Operación completada correctamente.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/hosting/setup__done' => 'El hosting para %1 ha sido configurado.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operación completada correctamente.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operación completada correctamente.', // PFU
    'ui__client/domain/hosting/virtual-directories__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'La versión de ASP.NET ha sido cambiada.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'La configuración ASP.NET para %1 ha sido modificada.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'El directorio virtual se ha creado bajo el sitio web %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'El directorio virtual ha sido creado.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Los directorios seleccionados han sido eliminados.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Los directorios seleccionados han sido eliminados.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Los documentos de error personalizados han sido actualizados.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Los tipos MIME seleccionados han sido eliminados', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'El tipo MIME nuevo ha sido registrado.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Los permisos de acceso al directorio han sido actualizados.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Los permisos de acceso al directorio han sido actualizados.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'La configuración PHP para %1 ha sido actualizada.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'La configuración PHP para %1 ha sido actualizada.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Las propiedades del directorio han sido actualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Las propiedades del directorio han sido actualizadas.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'La configuración de protección de directorios ha sido actualizada.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'La configuración de protección del directorio ha sido actualizada.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Operación realizada correctamente.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Certificados SSL/TLS disponibles en la tienda online',
    'ui__client/domain/mpc-certificates_self__done' => 'Certificados SSL/TLS disponibles en la tienda online',
    'ui__client/domain/odbc__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/odbc_self__done' => 'Operación completada correctamente.', // PFW
    'ui__client/domain/properties__done' => "La cuenta de administrador de dominio ha sido modificada.",
    'ui__client/domain/properties_new__done' => "Se ha creado el dominio %1.",
    'ui__client/domain/properties_self__done' => "Las propiedades de su dominio han sido modificadas.",
    'ui__client/domain/register__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__client/domain/register_self__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__client/domain/rename__done' => 'Se ha cambiado el nombre del dominio.',
    'ui__client/domain/rename_self__done' => "El nombre del dominio se ha cambiado correctamente.",
    'ui__client/domain/report/anon-ftp-stats__done' => 'Operación completada correctamente.',
    'ui__client/domain/report/ftp-stats__done' => 'Operación completada correctamente.',
    'ui__client/domain/report/ftp-stats_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/report/traffic-history__done' => 'Operación completada correctamente.',
    'ui__client/domain/report/traffic-history_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/report/webalizer-preferences__done' => 'Operación completada correctamente.', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => 'Operación completada correctamente.', // PFU
    'ui__client/domain/report/web-stats__done' => 'Se ha abierto la página de estadísticas web.',
    'ui__client/domain/report/web-stats_self__done' => 'Se ha abierto la página de estadísticas web.',
    'ui__client/domain/report/web-stats-ssl__done' => 'Se ha abierto la página de estadísticas web.',
    'ui__client/domain/report/web-stats-ssl_self__done' => 'Se ha abierto la página de estadísticas web.',
    'ui__client/domain/report__done' => 'Operación completada correctamente.',
    'ui__client/domain/report_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/settings_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/to-client__done' => 'La cuenta de administrador de dominio %1 se convirtió a cuenta de cliente.',
    'ui__client/domain/to-client_multi__done' => 'Las cuentas de administrador de dominio se han convertido a cuentas de cliente.',
    'ui__client/domain/toggle_disable__done' => "El dominio %1 ha sido suspendido.",
    'ui__client/domain/toggle_enable__done' => "El dominio %1 ha sido activado.",
    'ui__client/domain/traffic__done' => 'Operación completada correctamente.',
    'ui__client/domain/traffic_self__done' => 'Operación completada correctamente.',
    'ui__client/domain/traffic_unknown__done' => 'Operación completada correctamente.',
    'ui__client/domain/web-stats__done' => 'Operación completada correctamente.',
    'ui__client/domain-summary-report__done' => 'Operación completada correctamente.',
    'ui__client/domain-summary-report_self__done' => 'Operación completada correctamente.',
    'ui__client/domain-summary-report_unknown__done' => 'Operación completada correctamente.',
    'ui__client/extras-domain__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__client/extras-domain_self__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__client/ipaddress/delete_multi__done' => 'Operación completada correctamente.',
    'ui__client/ipaddress/properties__done' => 'Operación completada correctamente.',
    'ui__client/ipaddress/properties_new__done' => 'Operación completada correctamente.',
    'ui__client/ip-pool/properties__done' => "Se ha actualizado el grupo de direcciones IP del cliente %1.",
    'ui__client/ip-pool/properties_self__done' => 'Operación completada correctamente.',
    'ui__client/limits__done' => "Los límites de recursos del cliente %1 han sido actualizados.",
    'ui__client/limits_self__done' => 'Operación completada correctamente.',
    'ui__client/logo__done' => 'La nueva configuración de personalización para el cliente %1 ha sido aplicada.',
    'ui__client/logo_reseller__done' => 'La configuración de la personalización nueva del panel se ha aplicado correctamente.',
    'ui__client/logo_self__done' => 'La configuración de personalización ha sido aplicada.',
    'ui__client/logo_self-reseller__done' => 'La configuración de personalización de su panel ha sido aplicada.',
    'ui__client/manage-domain__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__client/manage-domain_self__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__client/permissions__done' => "Los permisos del cliente %1 han sido actualizados.",
    'ui__client/permissions_self__done' => 'Operación completada correctamente.',
    'ui__client/preferences__done' => "Las preferencias para el cliente %1 han sido actualizadas.",
    'ui__client/preferences_self__done' => "Sus preferencias han sido actualizadas.",
    'ui__client/register-domain__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__client/register-domain_self__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__client/report/traffic-history__done' => 'Operación completada correctamente.',
    'ui__client/report/traffic-history_self__done' => 'Operación completada correctamente.',
    'ui__client/report__done' => 'Operación completada correctamente.',
    'ui__client/report_self__done' => 'Operación completada correctamente.',
    'ui__client/sessions/delete__done' => 'Operación completada correctamente.',
    'ui__client/sessions/delete_self__done' => 'Operación completada correctamente.',
    'ui__client/sessions__done' => 'Operación completada correctamente.',
    'ui__client/sessions_self__done' => 'Operación completada correctamente.',
    'ui__client/skeleton__done' => 'Operación completada correctamente.',
    'ui__client/skeleton_self__done' => 'Operación completada correctamente.',
    'ui__client/to-reseller__done' => 'La cuenta de cliente %1 se ha convertido a cuenta de revendedor.',
    'ui__client/to-reseller_multi__done' => "Las cuentas de cliente seleccionadas se han convertido a cuentas de revendedor.",
    'ui__client/traffic__done' => "Operación completada correctamente.",
    'ui__client/traffic_unknown__done' => 'Operación completada correctamente.',
    'ui__cp-access__done' => 'Operación completada correctamente.',
    'ui__cp-session/properties__done' => 'Operación completada correctamente.',
    'ui__cp-session__done' => 'Operación completada correctamente.',
    'ui__ftp-sessions__done' => 'Operación completada correctamente.',
    'ui__license__done' => 'Operación completada correctamente.',
    'ui__logo__done' => "Las propiedades de personalización de Plesk han sido modificadas.",
    'ui__longtasks/longtask/properties__done' => "La configuración de la tarea en segundo plano se ha actualizado correctamente.",
    'ui__mass-email/delete__done' => "Se ha eliminado la plantilla de mensaje %1.", // PFW
    'ui__mass-email/delete_multi__done' => "Se han eliminado las plantillas de correo.",  // PFW
    'ui__mass-email/send_main__done' => "Operación finalizada correctamente.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Las cuentas de cliente se han seleccionado correctamente.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Cuentas de administrador de dominio seleccionadas correctamente.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Cuentas de revendedor seleccionadas correctamente.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Los cambios realizados en la plantilla de mensajes de email masivos se han guardado.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Se ha creado la plantilla de mensajes de email masivos.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Se han seleccionado las cuentas de clientes para la plantilla de mensajes de email masivos.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Se han seleccionado las cuentas de administrador de dominios para la plantilla de mensajes de email masivos.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Se han seleccionado las cuentas de revendedores para la plantilla de mensajes de email masivos.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Se ha cambiado la plantilla de mensajes de email masivos.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Los valores especificados no son válidos.', // PFW
    'ui__mass-email__done' => "Operación finalizada correctamente.", // PFW
    'ui__mass-mail__done' => "Operación completada correctamente.", // PFU
    'ui__mass-mail/delete__done' => 'La plantilla de mensaje %1 ha sido eliminada.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Las plantillas de mensaje han sido eliminadas.', // PFU
    'ui__mass-mail/properties__done' => 'La plantilla %1 ha sido cambiada.', // PFU
    'ui__mass-mail/properties_new__done' => 'La plantilla %1 ha sido creada.', // PFU
    'ui__mass-mail/send__done' => 'Los mensajes han sido enviados.', // PFU
    'ui__mass-mail/send_new__done' => 'Los mensajes han sido enviados.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Los mensajes han sido enviados.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Los mensajes han sido enviados.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Se ha creado la nueva plantilla de mensaje', // PFU
    'ui__mass-mail/template/properties__done' => 'La plantilla de mensaje ha sido actualizada.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Las nuevas opciones de monitorización del disco han sido aplicadas.', // PFU
    'ui__modules__done' => 'Operación completada correctamente.',
    'ui__modules__short-title' => 'Extensiones',
    'ui__modules__title' => 'Extensiones',
    'ui__reseller/client/chowner_multi__done' => 'Las cuentas de cliente seleccionadas han sido transferidas a otro propietario.',
    'ui__reseller/client/chowner_multi-select__done' => 'Operación completada correctamente.',
    'ui__reseller/client/traffic_unknown__done' => 'Operación completada correctamente.',
    'ui__reseller/extras-domain__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__reseller/extras-domain_self__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__reseller/ftp-sessions_self__done' => 'Operación completada correctamente.',
    'ui__reseller/limits__done' => "Los límites de recursos del revendedor y las directivas de uso de recursos se han actualizado.",
    'ui__reseller/limits_readonly-self__done' => 'Operación completada correctamente.',
    'ui__reseller/limits_self__done' => 'Se han actualizado sus directivas de uso y sus límites de recursos.',
    'ui__reseller/manage-domain__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__reseller/manage-domain_self__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__reseller/permissions__done' => 'Se han cambiado los permisos del revendedor %1.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operación completada correctamente.',
    'ui__reseller/register-domain__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__reseller/register-domain_self__done' => 'Se ha abierto la página MyPlesk.com.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Se han eliminado las programaciones de entrega de informe seleccionadas.',
    'ui__reseller/report/layout/auto/properties__done' => 'Se ha actualizado la programación de entrega del informe.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Se ha añadido la programación de entrega de informe.',
    'ui__reseller/report/layout/properties__done' => 'El diseño del informe ha sido actualizado.',
    'ui__reseller/report/layout/properties_new__done' => 'El nuevo diseño de informe ha sido creado .',
    'ui__reseller/report/traffic-history__done' => 'Operación completada correctamente.',
    'ui__reseller/report/traffic-history_self__done' => 'Operación completada correctamente.',
    'ui__reseller/report__done' => 'Operación completada correctamente.',
    'ui__reseller/report_self__done' => 'Operación completada correctamente.',
    'ui__reseller/sessions/delete__done' => 'Operación completada correctamente',
    'ui__reseller/sessions/delete_self__done' => 'Operación completada correctamente',
    'ui__reseller/sessions__done' => 'Operación completada correctamente.',
    'ui__reseller/sessions_self__done' => 'Operación completada correctamente.',
    'ui__reseller/to-client__done' => 'La cuenta de revendedor %1 se convirtió a cuenta de cliente.',
    'ui__reseller/to-client_multi__done' => "Las cuentas de revendedor seleccionadas se convirtieron a cuentas de cliente.",
    'ui__reseller/traffic__done' => 'Operación completada correctamente.',
    'ui__reseller/traffic_self__done' => 'Operación completada correctamente.',
    'ui__reseller/traffic_unknown__done' => 'Operación completada correctamente.',
    'ui__reseller/logo_self__title' => 'Personalización de Plesk',
    'ui__reseller/logo_self__done' => 'Su configuración de personalización para Plesk ha sido aplicada.',
    'ui__server/aspdotnet__done' => 'La configuración ASP.NET a nivel de servidor ha sido actualizada.', // PFW
    'ui__server/certificate/default_multi__done' => 'El certificado SSL/TLS seleccionado se usará para la protección de las conexiones a sitios web alojados recientemente.',
    'ui__server/certificate/delete_multi__done' => 'Los certificados SSL/TLS seleccionados han sido eliminados.',
    'ui__server/certificate/download__done' => 'El certificado SSL/TLS ha sido descargado.',
    'ui__server/certificate/properties__done' => 'Las propiedades del certificado SSL/TLS han sido actualizadas.',
    'ui__server/certificate/properties_new__done' => 'El certificado SSL/TLS %1 ha sido creado.',
    'ui__server/certificate/setup_multi__done' => 'El certificado SSL/TLS seleccionado ha sido configurado para usarse para la protección de las conexiones a Plesk.',
    'ui__server/certificate__done' => 'Operación completada correctamente.',
    'ui__server/components__done' => 'Operación completada correctamente.',
    'ui__server/cp-certificate-download__done' => "El certificado SSL/TLS de Plesk ha sido descargado.",
    'ui__server/crontab/properties__done' => 'Las tareas programadas de %1 han sido modificadas.',
    'ui__server/crontab/task/delete__done' => 'La tarea ha sido eliminada.',
    'ui__server/crontab/task/delete_multi__done' => 'Las tareas  se han eliminado.',
    'ui__server/crontab/task/properties__done' => 'Las tareas programadas han sido actualizadas.',
    'ui__server/crontab/task/properties_new__done' => 'La nueva tarea ha sido programada.',
    'ui__server/crontab/task/toggle_disable__done' => 'La tarea programada %1 ha sido desactivada.',
    'ui__server/crontab/task/toggle_enable__done' => 'La tarea programada %1 ha sido activada.',
    'ui__server/crontab__done' => 'Operación completada correctamente.',
    'ui__server/dns__done' => 'Operación completada correctamente.',
    'ui__server/ftp-settings__done' => "La configuración FTP se ha actualizado correctamente.",
    'ui__server/ip-address/client/delete__done' => "La dirección IP se ha eliminado del grupo de direcciones IP del usuario.",
    'ui__server/ip-address/client/delete_multi__done' => "La dirección IP se ha eliminado de los grupos de direcciones IP de los usuarios.",
    'ui__server/ip-address/client/properties_new__done' => 'La dirección IP ha sido asignada a usuarios.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'La dirección IP %1 ha sido asignada a los clientes seleccionados.',
    'ui__server/ip-addresses__done' => "Operación completada correctamente.",
    'ui__server/mail/statistics/spam/recipients__done' => "Operación completada correctamente.",
    'ui__server/mail/statistics/spam/summary__done' => "Operación finalizada correctamente.",
    'ui__server/mail/statistics/spam__done' => "Operación finalizada correctamente.",
    'ui__server/mail/statistics/virus/recipients__done' => "Operación completada correctamente.",
    'ui__server/mail/statistics/virus/summary__done' => "Operación finalizada correctamente.",
    'ui__server/mail/statistics/virus/viruses__done' => "Operación completada correctamente.",
    'ui__server/mail/statistics/virus__done' => "Operación finalizada correctamente.",
    'ui__server/mail/statistics__done' => "Operación finalizada correctamente.",
    'ui__server/mail__done' => 'La configuración del servidor de correo ha sido actualizada.',
    'ui__server/maillists__done' => 'Operación completada correctamente.',
    'ui__server/mpc-certificates__done' => 'Se ha abierto la página de la tienda online que muestra todos los certificados SSL/TLS disponibles.',
    'ui__server/odbc__done' => 'La configuración ODBC a nivel de servidor ha sido modificada.', // PFW
    'ui__server/pmm__done' => 'Operación completada correctamente.',
    'ui__server/preferences__done' => "La configuración del servidor ha sido modificada.",
    'ui__server/register__done' => 'La página de MyPlesk.com ha sido abierta.',
    'ui__server/resources__done' => 'Operación completada correctamente.',
    'ui__server/services__done' => 'Operación completada correctamente.',
    'ui__server/sitebuilder__done' => 'Operación completada correctamente.',
    'ui__server/skeleton__done' => 'Operación completada correctamente.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'La dirección %1 ha sido eliminada de la lista negra del servidor.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Las direcciones han sido eliminadas de la lista negra del servidor.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Las direcciones han sido añadidas a la lista negra.',
    'ui__server/spam-filter/black-list/address__done' => 'Las direcciones han sido añadidas a la lista negra.',
    'ui__server/spam-filter/black-list__done' => 'Operación completada correctamente.', // PFU
    'ui__server/spam-filter/properties__done' => 'La configuración del filtro antispam ha sido modificada.',
    'ui__server/spam-filter/toggle_disable__done' => 'La filtración de spam fue desactivada a nivel de sistema.',
    'ui__server/spam-filter/toggle_enable__done' => 'La filtración de spam fue activada a nivel de sistema.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'La dirección %1 se eliminó de la lista blanca del servidor.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Las direcciones se eliminaron de la lista blanca a nivel de servidor.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Las direcciones se añadieron a la lista blanca.',
    'ui__server/spam-filter/white-list/address__done' => 'Las direcciones se han añadido a la lista blanca.',
    'ui__server/spam-filter/white-list__done' => 'Operación completada correctamente.', // PFU
    'ui__server/spam-filter__done' => 'Operación completada correctamente.',
    'ui__server/statistics__done' => 'Operación completada correctamente.',
    'ui__server/time__done' => "La fecha y hora del sistema ha sido actualizada.",
    'ui__server__done' => "Operación completada correctamente.",
    'ui__sessions/properties__done' => 'Operación completada correctamente.',
    'ui__sessions__done' => 'Operación completada correctamente.',
    'ui__sessions/delete__done' => 'Las sesiones seleccionadas han sido eliminadas.',
    'ui__start-page__done' => 'Operación completada correctamente.',
    'ui__support__done' => 'El formulario de petición de asistencia se abrió en una ventana o pestaña nueva.',
    'ui__ts-sessions__done' => 'Operación completada correctamente.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Ningún archivo a cargar.',
    'login_up__access_denied_no_permission' => "Acceso denegado. No dispone del permiso necesario para iniciar sesión.",
    'mail__unable_remove_pattern' => "No se ha podido eliminar la dirección de la lista negra del servidor: %1", // PFW
    'mail__incorrect_network_format' => 'Formato de red incorrecto: %1', // PFW
    'dbbackup__new_remote_backup_available' => 'En estos momentos, este servidor de bases de datos MS SQL opera en un host remoto. Si desea importar y exportar bases de datos usando volcados nativos de bases de datos, especifique la configuración de backup para este servidor de bases de datos.', // PFW
    'dbbackup__local_to_remote_backup_available' => 'Ahora este servidor de base de datos MS SQL está operando en un host remoto. Puede especificar la configuración de backup para este servidor de base de datos en su página %1.', // PFW
    'initconf__unable_change_passwd' => "No se pudo cambiar la contraseña del administrador: %1",
    'initconf__unable_get_passwd' => 'No ha sido posible obtener la contraseña del administrador actual: error en %1: %2',
    'initconf__invalid_hostname' => 'Error en el nombre de host "%1"',
    'initconf__unable_reconfig' => 'No ha sido posible configurar Plesk: error de reconfig: %1',
    'initconf__unable_update_admin' => 'No ha sido posible actualizar la info de contacto del administrador: %1',
    '__refresh' => 'Actualizar',
    '__dalias_not_exist' => 'El alias de dominio no existe.',
    '__bug146523_explanation' => 'Las versiones anteriores de Plesk permitían el uso de hasta 16 caracteres en los nombres de usuario FTP. Esta versión de Plesk limita el número máximo de caracteres permitidos en los nombres de usuario FTP a 15 caracteres. Para resolver el problema, use nombres de usuario FTP que contengan un máximo de 15 caracteres y cambie al menos un carácter en los nombres de usuario FTP afectados para así evitar incidencias de colisión de nombres de usuario. Rogamos disculpe las molestias ocasionadas por este cambio.',
    'domain__cannot_change_webmail' => 'No se ha podido cambiar el webmail para el dominio: %1',
    'sb_publish_disable_warning' => 'Si desactiva la creación de sitios web con Presence Builder, el sitio web creado anteriormente en Presence Builder será eliminado y se perderán todos los datos del sitio web.Si desea continuar, haga clic en ACEPTAR.',
    '__sbnet_client_use_sbnet' => "Crear una cuenta de usuario correspondiente en Presence Builder",
    'mail_resp_activate' => 'Activar respuesta automática',
    'limitsManger__limit_available_error' => 'No se ha podido asignar la cantidad requerida de recursos ("%%limitName%%"): solo dispone de %%available%% para su cuenta.',
    'limitsManger__limit_reserved_error' => 'No se han podido asignar menos recursos ("%%limitName%%") de los ya usados.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'No se pudo cambiar el nombre del dominio. Ya existe un directorio virtual con el nombre especificado.',
    'domain_unable_to_rename' => 'No se pudo cambiar el nombre del dominio.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'General',
    'spamfilter__spamassassin_status_legend' => 'Filtración antispam SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Configuración de SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Activar filtración antispam SpamAssassin a nivel de servidor",
    'spamfilter__spamassassin_user_status_legend' => 'Activar filtración antispam SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Activar protección antispam greylisting a nivel de servidor',
    'spamfilter__personal_settings_not_allowed' => 'La directiva del sistema no permite el uso de parámetros individuales de filtración antispam.',
    'spamfilter__required_score' => 'Puntuación que debe recibir el mensaje para cualificarse como spam',
    'spamfilter__rewrite_header_subject' => 'Añadir el siguiente texto al inicio del asunto de cada mensaje reconocido como spam',
    'spamfilter__use_mailuser_prefs' => 'Aplicar configuración individual al filtro antispam',
    'spamfilter_addresses__text_hint' => 'Separe múltiples direcciones con una línea nueva, con un espacio en blanco, tabulación, coma o comillas. No puede haber caracteres no ASCII a la izquierda de @. Las direcciones pueden contener "*" y "?" (por ejemplo *@domain.com, user?@*.com). Las partes no ASCII de los nombres de dominio no pueden contener caracteres wildcard.',
    'spamfilter__spamassassin__antivirus_settings_legend' => 'Usar opciones del servidor',
    'spamfilter__antivirus_use_mailuser_prefs' => 'Permitir opciones personales',
    'spamfilter__score_error' => 'La puntuación no debería ser negativa. La parte que precede al punto decimal debería ser inferior a 100 y no debe incluir más de dos dígitos tras el punto decimal.',
    'spamfilter__rewrite_header_error' => 'El asunto del mensaje puede contener cualquier carácter imprimible a excepción del signo (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Devolver',
    'nonexistent_mail__mode_discard' => 'Descartar',
    'nonexistent_mail__mode_catch_addr' => 'Reenviar a la dirección de email',
    'nonexistent_mail__mode_catch_ip' => 'Reenviar a IP',
    'nonexistent_mail__bounce_not_supported' => 'Modo de devolución no soportado',
    'nonexistent_mail__discard_not_supported' => 'Modo descartar no soportado',
    'nonexistent_mail__catch_not_supported' => 'Reenvío a dirección de email no soportado',
    'nonexistent_mail__redirect_not_supported' => 'Reenvío a IP no soportado',
    'nonexistent_mail__ip_used_on_this_host' => 'La dirección IP resuelve a localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Como el control del correo saliente esté activado, la dirección de email %1 para destinatarios inexistentes debería pertenecer al dominio seleccionado. De lo contrario se aplicará la directiva "Rechazar" en vez de la de reenvío.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Como el control del correo saliente está activado, la dirección de email indicada para el reenvío de correo (%1) debería pertenecer al dominio seleccionado. De lo contrario, los mensajes enviados a esta dirección no serán contabilizados en el control del correo saliente.',
    // mail acc extras
    '__antivirus' => "Antivirus",

    // additional keys
    'additional_keys__select_to_install' => 'No ha seleccionado ninguna llave. Seleccione las llaves que desea instalar.',
    'additional_key_update__title' => "Actualización de llave adicional",
    'additional_key_update__legend' => "Estado de la actualización de la llave adicional",
    'additional_key_update__new_key' => "Propiedades de la llave adicional",
    'bt_additional_key_install' => "Instalar llave",
    'b_additional_key_install' => 'Haga clic para instalar la llave de licencia actual.',
    'bt_additional_key_update' => "Recuperar llave adicional",
    'bt_additional_key_revert' => "Revertir llave",
    'b_additional_key_upload' => 'Cargar una llave de licencia nueva.',
    'b_additional_key_download' => 'Descargar la llave de licencia actual.',
    'b_additional_key_remove' => 'Eliminar la llave de licencia actual.',
    'b_additionalkeyslist_install' => 'Instalar llaves de licencia seleccionadas.',

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'No existe ninguna cuenta adicional de administrador.', // PFW
    'ui__client/domain/certificate__none-available' => 'El cliente no dispone de ningún certificado SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'El cliente no dispone de ningún dominio con certificados SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'El dominio no dispone de ningún certificado SSL/TLS.',
    'ui__reseller/client__none-available' => 'No existe ningún revendedor con clientes.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Seleccione las direcciones IP que desea eliminar del grupo de direcciones IP.',
    'ui__reseller/client/chowner__empty_selection' => 'Seleccione las cuentas de cliente que desea asignar a un propietario nuevo.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Es necesario seleccionar las cuentas de revendedor de cuyos grupos de direcciones IP desea revocar una dirección IP.',
    'ui__server/crontab/task/delete__empty_selection' => 'Seleccione la tarea que desea cancelar.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'El soporte de PHP está deshabilitado para este sitio web.',
    'phosting__aspdotnet_not_enabled' => 'El soporte de ASP.NET está deshabilitado para este sitio web.',
    'phosting__php_forced_by_site_isolation' => 'No se puede cambiar la configuración de PHP: no se ha concedido el permiso para reemplazar la directiva de seguridad a nivel del servidor.',
    'phosting__option_forced_by_site_isolation' => 'No se pudo cambiar la configuración de %1: no se ha concedido el permiso para reemplazar la directiva de seguridad a nivel del servidor.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'mod_bw está desactivado porque Plesk opera en modo optimizado para VPSs.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'mod_php está desactivado porque Plesk opera en modo optimizado para VPSs.',
    'phosting__perl_disabled_by_vps_optimized' => 'Perl está desactivado porque Plesk opera en modo optimizado para VPSs.',
    'phosting__asp_disabled_by_vps_optimized' => 'ASP está desactivado porque Plesk opera en modo optimizado para VPSs.',
    'phosting__python_disabled_by_vps_optimized' => 'Python está desactivado porque Plesk opera en modo optimizado para VPSs.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'fastcgi está desactivado porque Plesk opera en modo optimizado para VPSs.',
    'phosting__php_handler_id_not_registered' => 'El controlador  PHP no está permitido en la configuración de aislamiento de sitio. Se utilizará el controlador PHP predeterminado.',
    'phosting__php_served_by_nginx_is_not_available' => 'La configuración de aislamiento de sitios no admite el controlador de PHP (aplicación FPM servida por nginx). Se utilizará el controlador PHP predeterminado.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Ver la lista de direcciones IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Ver la lista de direcciones IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Vea la lista de direcciones IP disponibles para este usuario.',
    'ui__server/certificate__short-title' => 'Certificados SSL/TLS',
    'ui__server/certificate__title' => 'Certificados SSL/TLS',
    'ui__server/certificate__description' => 'Vea y gestione certificados SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Eliminar tipos MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Eliminar tipos MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Elimine los tipos MIME seleccionados.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Añadir tipo MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Añadir tipo MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Registre un tipo MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Eliminar direcciones IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Seleccione las direcciones IP que desea eliminar del grupo de direcciones IP del cliente %1',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'Crear archivo',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'Crear archivo',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'Cree un archivo.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'Crear carpeta',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'Crear carpeta',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'Cree una carpeta.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'Editar archivo o carpeta',
    'ui__client/domain/hosting/file-manager/edit__title' => 'Editar archivo o carpeta',
    'ui__client/domain/hosting/file-manager/edit__description' => 'Edite el archivo o carpeta seleccionado.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'Cambiar nombre de archivo o carpeta',
    'ui__client/domain/hosting/file-manager/rename__title' => 'Cambiar nombre de archivo o carpeta',
    'ui__client/domain/hosting/file-manager/rename__description' => 'Cambie el nombre del archivo o carpeta seleccionado.',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'Cambiar permisos',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'Cambiar permisos',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'Cambie los permisos de acceso para un archivo o carpeta.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'Eliminar archivo o carpeta',
    'ui__client/domain/hosting/file-manager/remove__title' => 'Eliminar archivo o carpeta',
    'ui__client/domain/hosting/file-manager/remove__description' => 'Elimine este archivo o carpeta.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'Eliminar archivo o carpeta',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'Eliminar archivo o carpeta',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'Elimine este archivo o carpeta.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'Copiar o mover archivos o directorios',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'Copiar o mover archivos o directorios',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'Copie o mueva los directorios o archivos seleccionados.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'Ver archivo',
    'ui__client/domain/hosting/file-manager/view__title' => 'Ver archivo',
    'ui__client/domain/hosting/file-manager/view__description' => 'Vea el archivo seleccionado.',

    'ui__client/ipaddress__short-title' => 'Dirección IP',
    'ui__client/ipaddress__title' => 'Dirección IP',
    'ui__client/ipaddress__description' => 'Vea la información sobre la dirección IP.',
    'ui__server/ip-address__short-title' => 'Dirección IP',
    'ui__server/ip-address__title' => 'Dirección IP',
    'ui__server/ip-address__description' => 'Vea información sobre la dirección IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Configuración de hosting web',
    'ui__client/domain/hosting/setup__title' => 'Configuración de hosting web',
    'ui__client/domain/hosting/setup__description' => 'Defina la configuración de hosting web para el sitio web %1.',
    'ui__reseller/client/chowner_multi__description' => 'Seleccione el propietario nuevo para las cuentas de cliente seleccionadas.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Tipo MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Propiedades del tipo MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Examine las propiedades del tipo MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Documento de error', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Documento de error', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Propiedades del documento de error.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Eliminar los diseños de informe seleccionados.',
    'b_resellerreportslist_search' => 'Indique un patrón de búsqueda y haga clic para buscar diseños de informes.',
    'b_resellerreportslist_show_all' => 'Mostrar todos los diseños de informe disponibles.',

    'l_resellerreportslist_auto' => 'Ordenar diseños de informe por automatización de entrega.',
    'l_resellerreportslist_clients' => 'Ordenar diseños de informe por presencia de información acerca de clientes.',
    'l_resellerreportslist_domains' => 'Ordenar diseños de informe por presencia de información acerca de dominios.',
    'l_resellerreportslist_general' => 'Ordenar diseños de informe por presencia de información general.',
    'l_resellerreportslist_name' => 'Ordenar diseños de informe por nombre del informe.',
    'l_resellerreportslist_personal_domains' => 'Ordenar diseños de informe por presencia de información acerca de dominios personales.',

    'b_adminreportslist_remove' => 'Eliminar los diseños de informe seleccionados.',
    'b_adminreportslist_search' => 'Indique un patrón de búsqueda y haga clic para buscar diseños de informes.',
    'b_adminreportslist_show_all' => 'Mostrar todos los diseños de informe disponibles.',

    'l_adminreportslist_auto' => 'Ordenar diseños de informe por automatización de entrega.',
    'l_adminreportslist_clients' => 'Ordenar diseños de informe por presencia de información acerca de clientes.',
    'l_adminreportslist_domains' => 'Ordenar diseños de informe por presencia de información acerca de dominios.',
    'l_adminreportslist_general' => 'Ordenar diseños de informe por presencia de información general.',
    'l_adminreportslist_name' => 'Ordenar diseños de informe por nombre del informe.',
    'l_adminreportslist_personal_clients' => 'Ordenar diseños de informe por presencia de información acerca de sus clientes.',
    'l_adminreportslist_personal_domains' => 'Ordenar diseños de informe por presencia de información acerca de sus dominios.',
    'l_adminreportslist_resellers' => 'Ordenar diseños de informe por presencia de información acerca de revendedores.',

    'b_clientsonlylist_remove' => 'Eliminar las cuentas de cliente seleccionadas.',
    'b_clientsonlylist_search' => 'Indique un patrón de búsqueda y haga clic para buscar cuentas de cliente.',
    'b_clientsonlylist_show_all' => 'Mostrar todas las cuentas de cliente.',
    'l_clientsonlylist_cname' => 'Ordene las cuentas de cliente por nombre de la empresa.',
    'l_clientsonlylist_date' => 'Ordenar cuentas de cliente por fecha de creación.',
    'l_clientsonlylist_domains' => 'Ordenar cuentas de cliente por número de dominios.',
    'l_clientsonlylist_name' => 'Ordenar cuentas de cliente por nombre.',
    'l_clientsonlylist_owner' => 'Ordenar cuentas de cliente por propietario.',
    'l_clientsonlylist_type' => 'Ordenar cuentas de cliente por tipo.',

    'b_get_password_cancel' => 'Volver a la pantalla anterior sin enviar el email.',
    'b_get_password_send' => 'Haga clic en ACEPTAR para enviar un mensaje de recuperación de contraseña a la dirección de email registrada en el sistema.',



    'b_personaltrafficlist_search' => 'Indique un patrón de búsqueda y haga clic para buscar dominios.',
    'b_personaltrafficlist_show_all' => 'Mostrar todos los dominios.',

    'b_back' => 'Volver a la página anterior.',
    'b_next' => 'Ir a la próxima página.',

    'b_dnsnstemplatelist_remove' => 'Eliminar los servidores de nombres seleccionados.',
    'b_dnsnstemplatelist_search' => 'Indique un patrón de búsqueda y haga clic para buscar servidores de nombres.',
    'b_dnsnstemplatelist_show_all' => 'Mostrar todos los servidores de nombres.',

    'l_dnsnstemplatelist_ns' => 'Ordenar registros de plantilla DNS por servidor de nombres.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Generar vínculos seguros a archivos y carpetas',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Habilitar archivos públicos',
    'cu__serverfilesharing_fsPublicFolder' => 'Carpeta para el almacenamiento de archivos públicos',
    'cu__serverfilesharing_fsPublicUrl' => 'URL donde los visitantes pueden acceder a los archivos públicos',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Activar la protección de los archivos públicos mediante una contraseña',
    'cu__serverfilesharing_fsPartnerFolder' => 'Carpeta para almacenamiento de archivos protegidos con contraseña',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nombre de usuario para el acceso a los archivos',
    'cu__serverfilesharing_fsPartnersPassword' => 'Contraseña para el acceso a los archivos',
    'cu__serverfilesharing_fsDomain' => 'Dirección URL raíz de la carpeta web. Nombre de dominio',
    'cu__serverfilesharing_fsPrefix' => 'Dirección URL raíz de la carpeta web. Prefijo',
    'cu__serverfilesharing_commandUpdate' => 'Actualizar configuración de compartición de archivos',
    'cu__serverfilesharing_commandInfo' => 'Mostrar configuración actual de compartición de archivos',
    'server_preferences_include_admin_dumps_into_client_usage' => 'archivos de backup creados por el administrador',
    'server_preferences__forbid_subscription_rename' => 'Prohibir a los clientes y revendedores cambiar su nombre de dominio principal',
    'subscription_rename_is_forbidden' => 'La directiva a nivel del servidor no permite cambiar el nombre de las suscripciones.',
    'server_preferences__allow_sys_user_rename' => 'Los clientes pueden modificar el nombre de sus usuarios de sistema',
    'server_preferences__allow_sys_user_rename_false' => 'Siempre',
    'server_preferences__allow_sys_user_rename_true' => 'Únicamente si se concede el permiso de administración del hosting',
    'server_preferences__allow_sys_user_rename_forced' => 'Nunca',
    'server_preferences__preferred_domain' => 'Dominio preferido para los sitios web',
    'server_preferences__preferred_domain_none' => 'Ninguno',
    'server_preferences__preferred_domain_to_landing' => 'domain.tld',
    'server_preferences__preferred_domain_to_www' => 'www.domain.tld',
    'server_preferences__anonymize_ips' => 'Anonimizar direcciones IP',
    'server_preferences__anonymize_ips_text' => 'Anonimizar las direcciones IP durante la rotación de registros y la recopilación de estadísticas web',
    'server_preferences__anonymize_ips_description' => 'El script postrotate reemplaza el último octeto de direcciones IPv4 en los archivos de registro rotados por "0" antes del archivado. En el caso de las direcciones IPv6, el script reemplaza la última sección de la dirección (dos octetos tras los últimos dos puntos) por "0000" (en forma completa) o por "0" (en forma abreviada)',
    'server_preferences__logrotate' => 'Rotación de registros',
    'server_preferences__logrotate_force' => 'Forzar la rotación diaria para todos los dominios',
    'server_preferences__logrotate_period' => 'Permitir el almacenamiento de archivos de registro de sitio web durante',
    'server_preferences__logrotate_period_days' => 'días',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Administrar tareas programadas en el servidor',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Seleccione el usuario de sistema cuyas tareas programadas desea gestionar.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Tarea programada %1',
    'ui__server/crontab/task__description' => 'Vea las propiedades de la tarea programada %1',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Usuarios del sistema',
    'ui__server/crontab_unknown__title' => 'Usuarios del sistema',
    'ui__server/crontab_unknown__description' => 'Usuarios de sistema que pueden ser los propietarios de tareas programadas.',


    'ui__server/crontab__none-available' => 'No tiene ninguna cuenta de usuario de sistema.',
    'ui__server/crontab_readonly-unknown__description' => 'Vea tareas programadas.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Tareas programadas',
    'ui__server/crontab_readonly-unknown__title' => 'Ver tareas programadas',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Vea tareas programadas.',
    'ui__server/crontab_readonly__description' => 'Vea las tareas programadas de %1.',
    'ui__server/crontab_readonly__short-title' => 'Tarea programada de %1',
    'ui__server/crontab_readonly__title' => 'Ver tareas programadas de %1',
    'ui__server/crontab_unknown__wizard-title' => 'Gestione tareas programadas.',

    'ui__server/crontab/properties__description' => 'Edite las tareas programadas de %1.',

    'ui__server/crontab/properties__short-title' => 'Configuración',
    'ui__server/crontab/properties__title' => 'Editar tareas programadas de %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Vea tareas programadas.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Configuración',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Ver tareas programadas',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Vea tareas programadas.',
    'ui__server/crontab/properties_readonly__description' => 'Vea tareas programadas de %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Configuración',
    'ui__server/crontab/properties_readonly__title' => 'Ver tareas programadas de %1',
    'ui__server/crontab/properties_unknown__description' => 'Edite tareas programadas.',
    'ui__server/crontab/properties_unknown__short-title' => 'Propiedades',
    'ui__server/crontab/properties_unknown__title' => 'Editar tareas programadas',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Edite tareas programadas.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Seleccione el usuario de sistema cuyas tareas desea ver.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Seleccione el usuario de sistema cuyas tareas desea modificar.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Haga clic en Finalizar para aplicar los cambios y salga del asistente.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Haga clic en Finalizar para salir del asistente.',

    'ui__server/crontab/task__none-available' => 'No tiene ninguna tarea programada.',
    'ui__server/crontab/task__none-available__2' => 'El usuario de sistema %1 no tiene ninguna tarea programada.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Tareas programadas.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Tareas',
    'ui__server/crontab/task_readonly-unknown__title' => 'Tareas programadas',

    'ui__server/crontab/task/delete__description' => 'Eliminar la tarea programada %1',

    'ui__server/crontab/task/delete__short-title' => 'Eliminar',
    'ui__server/crontab/task/delete__title' => 'Eliminar la tarea programada %1',
    'ui__server/crontab/task/delete_multi__description' => 'Elimine tareas programadas.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Eliminar',
    'ui__server/crontab/task/delete_multi__title' => 'Eliminar tareas programadas',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Elimine tareas programadas.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Seleccione el usuario de sistema cuyas tareas desea eliminar.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Seleccione las tareas  que desea eliminar.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Confirme la eliminación de la tarea seleccionando la casilla y haga clic en Finalizar para salir del asistente.',
    'ui__server/crontab/task/delete_unknown__description' => 'Elimine una tarea programada.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Eliminar',
    'ui__server/crontab/task/delete_unknown__title' => 'Eliminar una tarea programada',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Elimine una tarea programada.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Seleccione el usuario de sistema cuya tarea desea eliminar.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Seleccione la tarea que desea eliminar.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Confirme la eliminación de la tarea seleccionando la casilla y haga clic en Finalizar para salir del asistente.',

    'ui__server/crontab/task/properties__description' => 'Edite tareas programadas.',

    'ui__server/crontab/task/properties__short-title' => 'Editar la tarea %1',
    'ui__server/crontab/task/properties__title' => 'Editar tareas programadas',
    'ui__server/crontab/task/properties_new__description' => 'Cree tareas programadas para %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Añadir tarea',
    'ui__server/crontab/task/properties_new__title' => 'Crear tareas programadas para %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Cree una tarea programada.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Seleccione el usuario de sistema para el que desea crear la tarea programada.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Haga clic en Finalizar para aplicar los cambios y salir del asistente.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Vea las tareas programadas.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Propiedades',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Ver las tareas programadas',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Vea las tareas programadas.',
    'ui__server/crontab/task/properties_readonly__description' => 'Vea tareas programadas.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Ver tarea %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Ver tareas programadas',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Cree tareas programadas.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Añadir tarea',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Crear tareas programadas',
    'ui__server/crontab/task/properties_unknown__description' => 'Edite tareas programadas.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Propiedades',
    'ui__server/crontab/task/properties_unknown__title' => 'Editar tareas programadas',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Edite tareas programadas.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Seleccione el usuario de sistema cuyas tareas desea ver.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Seleccione el usuario de sistema cuyas tareas desea modificar.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Seleccione la tarea programada.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Seleccione la tarea programada que desea modificar.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Haga clic en Finalizar para aplicar los cambios y salir del asistente.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Haga clic en Finalizar para salir del asistente.',

    'ui__server/crontab/task/toggle_disable__description' => 'Desactive la tarea programada %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Desactivar',
    'ui__server/crontab/task/toggle_disable__title' => 'Desactivar la tarea programada %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Active la tarea programada %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Activar',
    'ui__server/crontab/task/toggle_enable__title' => 'Activar la tarea programada  %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Active o desactive tareas programadas.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Activar o desactivar',
    'ui__server/crontab/task/toggle_unknown__title' => 'Activar o desactivar tareas programadas',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Activar o desactivar tareas programadas',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Seleccione la cuenta de usuario de sistema cuyas tareas desea activar o desactivar.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Seleccione la tarea que desea activar o desactivar.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Cuentas de cliente', // not used on HP?
    'ui__client_unknown__title' => 'Cuentas de cliente', // not used on HP?
    'ui__client_unknown__description' => 'Administre cuentas de cliente.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Suspender dominio', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Suspender dominio', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Suspenda un dominio.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Activar dominio', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Activar dominio', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Active un dominio.', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => 'Asignar propietario nuevo a cuentas de cliente',
    'ui__client/chowner_multi-select__short-title' => 'Asignar propietario nuevo',
    'ui__client/chowner_multi-select__description' => 'Asigne un propietario nuevo a las cuentas de cliente seleccionadas.',


    //Additional FTP Accounts
    'directory_browser__select_folder' => 'Seleccionar carpeta',
    'ftp__management_domain' => "Cuentas FTP bajo el dominio %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Cuentas FTP",
    'ftp__user_name' => "Nombre de la cuenta FTP",
    'ftp__user_home' => "Directorio principal",
    'ftp__invalid_path' => "Ruta especificada incorrecta",
    'ftp__physical_path_not_exist' => "La ruta física no existe",
    'i_ftp_ses_sub_user' => 'Sesión de cuenta FTP.',
    '__new_passwd' => "Nueva contraseña %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'No se pudo configurar un servidor web en el host <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "No se pudo generar el archivo de configuración del servidor web en el host <%%host%%> debido al/a los siguiente(s) error(es):\n\n%%error%%\n\nCorrija el/los error(es) en las plantillas de configuración del servidor web e intente volver a generar el archivo.",

    'apacheConfigurationMessageAdminTitle' => 'Error de generación de la configuración del servidor web',
    'apacheConfigurationMessageClientTitle' => 'Advertencia',

    'apacheConfigurationFailedAdminHomeMessage' => 'El archivo de configuración nuevo no ha sido creado debido a errores en las plantillas de configuración. El mensaje de error detallado ha sido enviado a su email. Examínelo, corrija los errores y haga clic en %1 para volver a intentar generar la configuración.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'aquí', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'La configuración nueva para el dominio %1 no ha sido creada debido a errores en las plantillas de configuración. El mensaje de error detallado ha sido enviado a su email. Examínelo, corrija los errores y haga clic en %2 para volver a intentar generar la configuración.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'aquí', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'La configuración del servidor web para el dominio %1 puede no ser coherente. Póngase en contacto con el administrador del servidor para resolver el problema.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'La configuración nueva para algunos de los dominios ha sido creada debido a errores en las plantillas de configuración. El mensaje de error detallado ha sido enviado a su email. Examínelo, corrija los errores y haga clic en %1 para volver a intentar generar la configuración.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'aquí', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Puede que la configuración del servidor web para algunos de sus dominios no sea coherente. Póngase en contacto con el administrador del servidor para resolver el problema.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Documentos de error personalizados",
    'dom_pref__webusers_script' => "Permitir a los usuarios web el uso de scripts",
    '__seoRedirect' => 'Configurar el dominio preferido como',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Ninguno',

    '__sites' => 'Dominios',
    'domain_plan__perm_denied_manage_phosting' => 'No dispone del permiso necesario para administrar la configuración de hosting.',
    '__owned_by_client' => 'propiedad del cliente',
    'ui__client/permissions_readonly__description' => "Vea las acciones que el cliente %1 puede realizar en Plesk.",
    'client_chown_subscription_will_be_anonymous' => 'Se cancelará la suscripción de los clientes a sus planes de servicios actuales.',
    'backup__restore__object_client_template' => 'Plantilla de cliente',
    '__template_name' => 'Nombre del plan de servicio',
    'template__not_exists' => 'Este plan de servicio no existe',
    'template__exists' => 'Ya existe un plan con el nombre %1.',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => 'El cliente tiene dominios suscritos a planes de servicio %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'La dirección IP especificada no está presente en el grupo del revendedor.',

    //// Change owner of subscription
    'chown__select_title' => "Seleccionar suscriptor nuevo",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Seleccione el propietario nuevo para las suscripciones seleccionadas y haga clic en Siguiente >>.',
    'domains__client_info' => "%1 suscripciones, %2 suscripciones activas, %3 espacio en disco usado, %4 tráfico usado",
    '__possible_owners' => 'Posibles propietarios nuevos de suscripciones',

    'clients_list__filter_owner__filter_title' => 'Proveedor',
    'clients_list__filter_owner_any' => 'Todos los usuarios',
    'clients_list__filter_owner_my' => 'Solo mis suscriptores',
    'clients_list__filter_owner_name__filter_title' => 'Nombre del proveedor',

    '__owner' => "Proveedor",
    'l_clientslist_owner' => 'Ordenar cuentas de usuario por proveedor.',
    'l_clientslist_date' => 'Ordenar cuentas de usuario por fecha de creación.',
    'l_clientslist_name' => 'Ordenar cuentas de usuario por nombre.',
    'l_clientslist_domains' => 'Ordenar cuentas de usuario por dominios.',
    'l_clientslist_cname' => 'Ordenar cuentas de usuario por nombre de empresa.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Reasignando las suscripciones seleccionadas',
    'chown__check_title' => 'Cambiar suscriptor',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Haga clic en Finalizar para completar la reasignación. Una vez hecho esto, las suscripciones seleccionadas se asignarán a un propietario nuevo, su proveedor pasará a ser el proveedor del propietario nuevo y estas se desvincularán de sus planes de servicio, conviertiéndose en 'Personalizadas'.",

    'chown__error_check' => 'Se han producido algunos problemas cuando se intentaba asignar algunas de las suscripciones al propietario nuevo.',
    'domain_chown_subscription_will_be_anonymous' => "Las suscripciones se desvincularán de sus planes de servicio actuales y se convertirán en 'Personalizadas'.",
    'chown__error_domains_exclude' => "Se han producido algunos problemas cuando se intentaba asignar algunas de las suscripciones al propietario nuevo.Estas suscripciones aparecen destacadas en color.",
    'chown__ip_not_in_client_pool' => "La dirección IP asociada con esta suscripción no se ha añadido al grupo de direcciones IP del propietario nuevo.",
    'chown__already_owned_by_client' => "Esta suscripción ya pertenece a este usuario.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Directorio protegido /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Administración del directorio protegido /%1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'Creación de un directorio protegido bajo el sitio %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'Añadir directorio protegido',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'Cree un directorio protegido.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'El directorio protegido /%1 se ha creado correctamente.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'Configuración del directorio protegido /%1',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'Configuración de directorios',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'Cambie la ubicación, nombre y nombre del área para el directorio protegido.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'La configuración del directorio protegido ha sido modificada.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'Confirmación de eliminación',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'Eliminar protección',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'Elimine la protección de los directorios seleccionados.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'Seleccione el directorio al que desea retirar la protección.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'Como resultado de esta operación, se eliminará la protección de los directorios. Los usuarios de Internet podrán acceder sin ningún tipo de problema a estos directorios.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'La protección se ha eliminado correctamente de los directorios seleccionados.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Añadir un usuario',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Añadir un usuario',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Crear una cuenta de usuario para acceder al directorio protegido %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'La cuenta de usuario para acceder al directorio protegido ha sido creada.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "Las credenciales del usuario han sido guardadas.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Eliminación de usuarios de directorio protegido',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Seleccione los usuarios que desea eliminar.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Elimine usuarios del directorio.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Se eliminarán los siguientes usuarios del directorio protegido:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'Las cuentas de usuario seleccionadas han sido eliminadas.',

    '__redirect_hint' => 'En 15 segundos se le redireccionará a la dirección nueva... De no ser así, habilite javascript o haga clic en el hipervínculo %%link%%.',

    'backup__restore__object_maillist' => 'Lista de correo',
    'backup__restore__object_site' => 'Sitio',
    'backup__restore__object_user' => 'Usuario',
    'backup__restore__object_role' => 'Rol',

    'limit__name_max_site' => 'sitios',

    'iis_pool__unable_rename_client' => "No se puede cambiar el nombre del grupo de aplicaciones IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'El servicio FTP anónimo solo se soporta para el dominio principal de una suscripción.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'El servicio FTP anónimo solo se soporta para el dominio principal de una suscripción.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/mes',
    '__tb_month' => 'TB/mes',

    '__customers' => 'Clientes',
    '__customer_name' => 'Nombre del cliente',
    '__customer_total' => 'Total de clientes',
    '__site' => 'Sitio',
    '__def_site' => 'Sitio predeterminado',
    '__subscription_name' => 'Nombre de la suscripción',
    '__subscription_name_powerUser' => 'Nombre de la suscripción',

    'limit__units_max_traffic_suffix' => '/mes',

    'dom_pref__discard' => "Rechazar",

    'mail__pattern_already_exists' => 'El patrón "%1" ya se encuentra en la lista negra.',

    '__not_supported' => 'No soportado',

    'plesk_key__sitebuilder' => 'Sitios publicados con Presence Builder',
    'limit__name_max_site_builder' => 'Sitios publicados con Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Soporte para sitios en múltiples idiomas en Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Estadísticas de transferencia de datos para el dominio %1',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Estadísticas de transferencia de datos para el dominio %1',
    'ui__client/domain/traffic-hosting#list__title' => "Transferencia de datos por servicios",

    'login_up__access_denied_no_subscriptions' => "Acceso denegado. No existe ninguna suscripción disponible para esta cuenta.",

    'interval__day' => '%1 día(s)',
    'interval__hour' => '%1 hora(s)',
    'interval__minute' => '%1 minuto(s)',
    'interval__second' => '%1 segundo(s)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Está intentando utilizar una llave de licencia creada para otra versión de Plesk. Póngase en contacto con el equipo comercial de Plesk para obtener una llave de licencia correcta.',
    //Standalone or virtualization
    'virtualization_any' => "Servidor físico o cualquier solución de virtualización",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Servidor Virtuozzo",
    'plesk_key__virtualization' => "Válido para los siguientes entornos:",
    'plesk_key__virtualization_only_key' => 'La llave de licencia solo puede utilizarse con Plesk operando en un entorno virtual %1.',
    'plesk_key__virtualizations_only_key' => 'La llave de licencia solo puede utilizarse con Plesk operando en los siguientes entornos virtuales: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Se prohíbe el uso de paquetes de idioma personalizados.',
    'plesk_key__allowed-locales' => 'Idiomas disponibles',
    'plesk_key__allowed-locales-any' => 'Cualquier idioma',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'directorio cgi-bin presente en',
    '_cgi_bin_mode_webspace' => 'el directorio raíz de la suscripción',
    '_cgi_bin_mode_www_root' => 'la raíz del documento de este dominio',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'Añadir un DSN ODBC',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'Añada un origen de datos ODBC.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'Eliminar',
    'ui__server/odbc/dsn/delete_multi__title' => 'Confirmación de eliminación',
    'ui__server/odbc/dsn/delete_multi__description' => 'Elimine orígenes de datos DSN ODBC seleccionados.',
    'ui__server/odbc/dsn/delete#legend__description' => 'Se eliminarán las siguientes conexiones DSN ODBC:',
    'ui__server/odbc/dsn/delete__empty_selection' => 'No ha seleccionado ninguna conexión DSN ODBC.',
    'ui__server/odbc/dsn/delete_multi__done' => 'Los orígenes de datos seleccionados han sido eliminados.',
    'ui__server/odbc/dsn__title' => 'Conexión DSN ODBC %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'Añadir un DSN ODBC',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'Añada un origen de datos ODBC.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'Confirmación de eliminación',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'Elimine orígenes de datos DSN ODBC seleccionados.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'Se eliminarán las siguientes conexiones DSN ODBC:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'No ha seleccionado ninguna conexión DSN ODBC.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'Los orígenes de datos seleccionados han sido eliminados.',
    'ui__client/domain/odbc/dsn__title' => 'Conexión DSN ODBC %1',


    /// Custom buttons
    'custom_button__sort_key' => 'Prioridad',
    'custom_button__place' => 'Ubicación',
    'custom_button__place_navigation' => 'Acceso común',
    'custom_button__place_admin' => 'Página principal del administrador',
    'custom_button__place_admin-settings' => 'Página de configuración y herramientas del administrador',
    'custom_button__place_reseller' => "Página principal del revendedor",
    'custom_button__place_reseller-settings' => 'Página de utilidades y herramientas del revendedor',
    'custom_button__place_client' => 'Página principal del cliente',
    'custom_button__place_domain' => "Página de sitios web y dominios de la suscripción",
    'custom_button__place_domain_powerUser' => "Página de sitios web y dominios de la suscripción",
    'custom_button__place_domain-properties' => 'Herramientas para sitios web',
    'custom_button__private' => 'Solo mostrármelo a mí',
    'custom_button__image' => 'Imagen de fondo',
    'custom_button__conhelp' => "Texto de ayuda contextual",
    'custom_button__edit' => "Configuración de un vínculo a un servicio adicional",
    'custom_button__include_client_cname' => "Incluir el nombre de la empresa del cliente",
    'custom_button__include_client_email' => "Incluir el email del cliente",
    'custom_button__include_client_id' => "Incluir el ID del cliente",
    'custom_button__include_client_pname' => "Incluir el nombre de contacto del cliente",
    'custom_button__include_domain_id' => "Incluir el ID de la suscripción, el ID del dominio y el ID del alias de dominio",
    'custom_button__include_domain_id_powerUser' => "Incluir el ID de la suscripción, el ID del dominio y el ID del alias de dominio",

    'custom_button__include_domain_name' => "Incluir el nombre del dominio principal",
    'custom_button__include_ftp_user' => "Incluir el nombre de usuario FTP",
    'custom_button__include_ftp_pass' => "Incluir la contraseña FTP",
    'custom_button__internal_open' => "Abrir URL en Plesk",
    'custom_button__text' => "Etiqueta del botón",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'El archivo no es un archivo de imagen.',
    'custom_button__big_image' => 'El tamaño del archivo no debería ser superior a 100 KB.',
    'custom_button__failed_copy_image' => 'No se pudo copiar el archivo: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'No se puede restaurar un backup que no sea de Power User en vista Power User.',
    '__unknown_network_interface' => 'Interfaz de red desconocido',

    'init_conf__ip_address' => 'Dirección IP',

    //Confirmation page
    'bt_confirm' => 'Confirmar',
    'b_confirm' => 'Confirme la propiedad de sus sitios.',

    //// New VZPP Integration
    '__vzpp_integration_warning' => 'Esta instancia de Plesk está instalada en un contenedor Virtuozzo. Debido a la configuración actual de gestión offline del contenedor, Plesk no está disponible.',
    '__vzpp_integration_contact_admin' => 'Si dispone de suficientes privilegios para modificar la configuración del contenedor, %1. De lo contrario, póngase en contacto con su proveedor para que realice esta acción.',
    '__vzpp_integration_help_link' => 'cambiar la configuración de gestión offline',



    'performance__iss_app_pool_forced_by_site_isolation' => 'Los parámetros del grupo de aplicaciones IIS dedicado se  configuran de acuerdo con la directiva de seguridad a nivel de servidor (configuración de aislamiento de sitios).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Los parámetros del grupo de aplicaciones IIS dedicado se configuran de acuerdo con las opciones de rendimiento a nivel de servidor.',

    '__current' => 'Actual',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Las propiedades del usuario han sido actualizadas.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Ha usado casi todos los dominios proporcionados con su licencia de Plesk (90% o más).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Usted ha usado casi todos los dominios.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Ha usado casi todos los sitios Presence Builder proporcionados con su licencia de Plesk (90 % o incluso más).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Usted ha usado casi todos los sitios Presence Builder.',
    'promo__button_hide' => 'Ocultar',
    'promo__button_next' => 'Siguiente >>',
    'promo__button_prev' => '<< Anterior',
    'promo__button_license' => 'Actualizar licencia',

    'promo__google_integration_title' => 'Integración con servicios Google',
    'promo__google_integration' => 'Configure la integración con servicios Google como AdSense, Google Apps y herramientas para Webmasters.',
    'promo__google_integration_button' => 'Configurar',

    'promo__button_learn_more' => 'Más info',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Puede personalizar la apariencia del interfaz y las opciones de personalización mediante temas personalizados. Si desea más información acerca de la personalización de los temas de Plesk, consulte la %1.',
    'panel_branding__description_link' => 'siguiente documento',
    'mail__enable_mail_ui_label' => 'Habilitar funciones de gestión de correo en Plesk',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extraer archivos',
    'b_filemanager__extract' => 'Extraiga archivos de los archivos comprimidos seleccionados al directorio actual. Tenga en cuenta que si los nombres de archivo contienen caracteres nacionales, puede que no se muestren correctamente una vez extraídos.',
    'filemanager_error_extracting_files' => 'Se ha producido un error mientras se extraían los archivos comprimidos: %1',
    'filemanager_no_archive_files_specified' => 'Especifique los archivos que desea extraer.',
    'filemanager_not_zip_archive_specified' => '%1 no puede extraerse porque no es un archivo ZIP.',
    'filemanager_files_successfully_extracted' => 'Los archivos han sido extraídos.',
    'filemanager_error_file_download' => 'Error de descarga del archivo: %1',
    'filemanager__user_poolgrp' => 'Grupo del conjunto de aplicaciones',

    'loading' => 'Cargando...',
    'bt_create_archive' => 'Añadir a archivo',
    'filemanager__pack' => "Ruta al archivo: %1",
    'filemanager__archive_name' => 'Nombre del archivo comprimido',
    'filemanager__empty_filename' => 'Introduzca el nombre del archivo comprimido.',
    'filemanager_archive_created' => 'El archivo se ha creado correctamente.',
    'filemanager_error_creating_archive' => 'No se puede crear el archivo: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Este registro entrará en conflicto con el registro AAAA para la zona.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(El servidor FTP no soporta direcciones IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Este registro entrará en conflicto con el registro glue para la zona \'%1\'.',
    '__ftp_ipv6_not_supported' => "(El servidor FTP no soporta direcciones IPv6.)",
    '__ipv6_not_supported' => 'IPv6 no soportado.',
    'mail__ipv6_not_supported' => 'IPv6 no soportado por el servidor de correo.',
    'mail__relay_while_list_ipv6_not_supported' => 'Lista blanca de retransmisión IPv6 no soportada por el servidor de correo.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'El valor de la máscara debe ser múltiple de 16.',
    'mail__ip_or_mask_is_invalid' => 'Máscara o dirección IP no válida.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Redireccionamiento a direcciones IP IPv6 no soportado.',
    'sa__invalid_trusted_networks' => 'Redes de confianza especificas de forma incorrecta: %1',
    'dns_add__enter_ipv6_address' => "Dirección IPv6",
    'license_trial_days_left' => 'Su Plesk está operando con una licencia de prueba que expirará en %1 días.',
    'excl_ipv6_num' => 'Dirección IPv6 dedicada',
    '__ip_mask' => "Máscara de subred",
    '__ipv4_addr' => 'Dirección IPv4',
    '__ipv6_addr' => 'Dirección IPv6',
    'template__num_excl_ipv6s' => 'Asignar direcciones IPv6 dedicadas al revendedor',
    'anonftp__exclusive_ipv4_required' => 'Para configurar y usar el servicio FTP anónimo se necesita una dirección IPv4 dedicada.',
    'anonftp__ipv4_already_used' => 'Usted no puede configurar el servicio FTP anónimo para este sitio porque este ya está configurado en otro dominio en la misma dirección IPv4.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'Ver el registro',

    'chown__ip_address_warn' => 'Antes de mover la suscripción al propietario nuevo, seleccione una dirección IP nueva para dicha suscripción.',
    'chown__no_ip_address' => 'Ninguna',
    'chown__no_ipv4_address' => 'Ninguna dirección IPv4',
    'chown__no_ipv6_address' => 'Ninguna dirección IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'La suscripción %1 ya pertenece a este usuario.',
    'chown__error_ip_absent_in_ip_pool' => 'La dirección IP %1 no está presente en el grupo de direcciones IP del usuario de destino.',
    'chown__error_ip_not_exist' => 'La dirección IP con ID \'%1\' no existe.',
    'chown__error_domain_ip_not_selected' => 'Al menos debería seleccionarse una dirección IP para el dominio %1. Compruebe los valores seleccionados para la asignación de IPs.',

    '__new_passwd_single' => "Contraseña",
    '__confirm_passwd_single' => "Confirme la contraseña",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Máscara o dirección IPv6 no válida: La dirección IP debería ser una dirección unicast válida.',

    '__subscriptions' => 'Suscripciones',

    '__owned_by_reseller' => 'propiedad del revendedor',
    '__owned_by_provider' => 'propiedad del proveedor',

    'service_plan__anonymous' => 'Personalizado',
    'subscription_not_locked__change_limits_warning' => 'Esta suscripción no está bloqueada: Los límites de uso de recursos se cambiarán durante la sincronización con el plan de servicio.',
    'subscription_not_locked__change_permissions_warning' => 'Esta suscripción no está bloqueada: Los permisos se cambiarán durante la sincronización con el plan de servicio.',

    'subscription__conflict_resolution_policy' => 'Directiva de resolución de conflictos',
    'subscription__conflict_resolution_policy_lock' => "Bloquear suscripción",

    'backup__list__backup_warnings' => 'Advertencias',
    'backup__list__backup_info' => 'Información',
    'backup__restore__object_reseller_template' => 'Plantilla de revendedor',
    'backup__restore__object_domain_template' => 'Plantilla de dominio',

    'ui__client/permissions_readonly__title' => 'Permisos',
    'ui__client/permissions_readonly__short-title' => 'Permisos',

    'subscription__unable_lock_anonymous' => 'Esta suscripción no está vinculada a ningún plan de servicio, por lo que no puede desbloquearse.',
    'subscription__unable_sync_anonymous' => 'Esta suscripción no está vinculada a ningún plan de servicio, por lo que no puede sincronizarse.',
    'subscription__unable_sync_locked' => 'Esta suscripción está bloqueada y por este motivo no puede sincronizarse.',
    'subscription__locked' => 'Suscripción bloqueada.',
    'component_name__urlrewrite' => "URL Rewrite",
    '__quantity' => 'Cantidad',
    'hst__www_root_dir_absent' =>  'Advertencia: El directorio especificado como raíz del documento no existe.',
    'object_creation__domain_is_not_a_webspace' => 'Este objeto solo puede crearse en una suscripción.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'La suscripción contiene sitios, por lo que no puede cambiar el tipo de hosting o eliminarlo.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Error: no se pudo actualizar la dirección IP. A los dominios complementarios no puede asignárseles una dirección IP no asignada al dominio principal de la suscripción.',
    'domain_plan__unable_change' => 'No se ha podido cambiar el plan de servicio: %1.',
    'domain_plan__different_hosting_type' => 'El tipo actual de hosting es distinto del tipo especificado en el plan de servicio.',
    'domain_plan__addon_text' => 'Plan complementario',
    'domain_plan__addon_description' => 'Plan complementario usado para complementar un plan de hosting.',
    'asp_net__managed_runtime_version' => 'Versión en tiempo de ejecución de ASP.NET',
    'plan__can_not_change_hosting_type' => 'No se puede cambiar el tipo de hosting cuando edite un plan.',
    'plan__apply_problems' => 'El plan no se aplicó debido a problemas con la siguiente funcionalidad: %1',
    'plan_save__subscription_update_problem' => 'No se pueden aplicar cambios de plan a %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "La suscripción se ha suspendido temporalmente hasta que finalice el proceso de backup o restauración. Inténtelo en unos minutos.",
    'mail__whitenet_exists' => "La lista blanca con prefijo %1 ya existe.",
    '__login_incorrect_plain_shadow_password' => 'Ha indicado una contraseña incorrecta para la cuenta del administrador. Use las credenciales del administrador del sistema (root)u obtenga la contraseña correcta. Para más información acerca de la obtención de la contraseña, lea el archivo /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'No puede enviar una dirección IP que no es suya',

    'dns__dns_zone_not_synchronized' => 'La zona DNS ha sido modificada. Si desea aplicar los cambios de la plantilla DNS a esta zona, haga clic en el botón \'Aplicar cambios de plantilla DNS\' presente en esta página o seleccione la opción \'Aplicar cambios a todas las zonas\' en el panel de administración del servidor > Herramientas y configuración > Configuración de plantilla DNS > Aplicar cambios de plantilla DNS.',
    'dns__dns_zone_synchronize_link' => 'Haga clic en',
    'dns__dns_zone_synchronize_done' => 'La zona DNS se ha sincronizado correctamente.',

    'dns__dns_zone_template_not_synchronized' => 'La plantilla de zona DNS fue modificada y se aplicará a todos los dominios nuevos. También puede %1.',
    'dns__dns_zone_soa_template_not_synchronized' => 'La plantilla SOA fue modificada y se aplicará a todos los dominios nuevos. También puede %1.',
    'dns__dns_zone_template_synchronize_link' => 'aplicar los cambios a todos los dominios alojados',
    'dns__dns_zone_template_error_details' => 'Detalles',
    'dns__dns_zone_template_error' => 'Se produjeron algunas incidencias al sincronizar las zonas DNS con la plantilla de la zona DNS.%1',

    'dns__soa_rname_type_owner' => 'Dirección de email del propietario del sitio web',
    'dns__soa_rname_type_domain' => 'Dirección de email del dominio',
    'dns__soa_rname_type_external' => 'Dirección de email externa',
    'dns__soa_rname_enforce_email' => 'Prohibir el cambio de la dirección de email RNAME de forma individualizada para cada dominio',
    'dns__soa_rname_label' => 'Email (RNAME)',
    'dns__soa_rname_hint' => 'La dirección de email de la persona responsable de la zona DNS del dominio. Devuelta por el servidor DNS en respuesta a consultas SOA.',

    'dns__dns_zone_soa_sync_title' => 'Reemplazar la configuración SOA para todos los dominios existentes',
    'dns__dns_zone_soa_sync_legend' => 'Se requiere confirmación',
    'dns__dns_zone_soa_sync_text' => '¿Desea actualizar los registros SOA de todos los dominios alojados aplicando los cambios efectuados a la plantilla SOA?',

    'cu_db__repair_mysql_dbus' => "Repare contraseñas de usuario de MySQL. Es necesario realizar esta operación si actualizó una versión anterior a Plesk 11.",

    'scheduled_backup_settings__start_at_hint' => 'El intervalo de comprobación para las tareas de backup programadas es de 15 minutos. Si desea que Plesk inicie el proceso de backup a una hora determinada, programe la tarea para al menos 15 minutos antes de la hora deseada.',
    'cu_scheduled_backup_comment' => 'Backup programado',
    'cu_scheduled_backup_error' => 'Se ha producido un error durante el proceso de backup: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Se ha producido un error durante el backup programado.',
    'cu_scheduled_backup_mail_message' => "%1\nPunto de entrada a Plesk: %2\n\nSe han producido los siguientes errores durante el proceso de backup programado:\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'Backup programado. Toda la configuración y el contenido.',
    'cu_scheduled_backup_comment_backup_vhost' => 'Backup programado. Toda la configuración y contenido excepto el correo.',
    'cu_scheduled_backup_comment_backup_mail' => 'Backup programado. Únicamente el contenido y la configuración de correo.',
    'cu_scheduled_backup_comment_backup_domain' => 'Backup programado. Configuración del dominio.',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'El almacenamiento de backups programados en un almacenamiento cloud remoto es una prestación premium. Póngase en contacto con su proveedor de hosting para desbloquearla.',

    'i_backup_invalid_file' => 'Este archivo no es un backup válido. Los datos no pueden restaurarse a través de este archivo. Haga clic en el nombre del backup para obtener más información.',

    'ui__server/migration/download-agent__short-title' => 'Descargar agente de migraciones y transferencias',
    'ui__server/migration/download-agent__title' => 'Descargar agente de migraciones y transferencias',
    'ui__server/migration/download-agent__description' => 'Descargue la versión más reciente del agente de migraciones y transferencias en el sitio web de Plesk.',

    'filemanager_resulting_archive_exists' => 'El archivo %1 ya existe en el directorio de destino.',

    'agent_unable_to_connect' => 'No pudo conectarse al agente en \'%2\'. Compruebe que el agente está instalado y en ejecución y que no existe ningún problema de conexión con el host \'%2\'.',
    'agent_test_connection_failed' => 'Error de conexión al agente en \'%2\'.',

    'agent_unable_to_resolve_host' => 'No se puede encontrar el host remoto \'%1\'. Compruebe que no existe ningún problema de conexión con el host.',
    'agent_unknown_curl_error' => 'Se ha producido el error \'%1\' durante la conexión al agente en \'%2\'.',
    'agent_unexpected_htp_code' => 'Se ha recibido el código HTTP inesperado \'%1\' en la petición HTTP al agente en \'%2\'.',
    'agent_unable_to_auth' => 'No fue posible autenticarse en el host \'%1\'. Para resolver el problema, siga los pasos detallados en http://kb.plesk.com/es/116606.',
    'agent_internal_server_error' => 'Se ha producido un error interno de servidor durante la ejecución del comando en el host remoto \'%1\'.',
    'agent_response_is_empty' => 'Se ha recibido una respuesta vacía en la petición HTTP al agente en \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'No se pudo encontrar el agente de migraciones y transferencias en la caché local. Vuelva a abrir el agente para resolver la incidencia.',

    '__hosting_webdeploy' => "Publicación de despliegue web",
    'cu_domain__webdeploy' => "Publicación de despliegue web (predeterminado: %1)",
    'cu_dom_tpl__webdeploy' => "Publicación de despliegue web (predeterminado: %1)",
    'cu_subdomain__webdeploy' => "Publicación de despliegue web (predeterminado: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy no está instalado en el servidor",
    'webdeploy__forced_by_site_isolation' => "No se ha podido cambiar la configuración de publicación de despliegue web: No dispone del permiso necesario para sobrescribir la directiva de seguridad a nivel de servidor. Póngase en contacto con su proveedor para obtener más información.",



    'backup__restore_options__admin__server_configuration_license' => 'Llave de licencia',
    'migration_start_migrate_server_license' => 'Transferir la llave de licencia',

    'defaultcomponents__delegation_rule_not_exist' => '(la regla de delegación requerida \'appPoolPipeline, appPoolNetFx\' no existe)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'El backup ha sido creado por el administrador.',
    'i_backup_created_by_reseller' => 'El backup ha sido creado por un revendedor.',
    'i_backup_created_by_client' => 'El backup ha sido creado por un cliente.',

    'migration__object_exists_on_target_host' => '(ya existe en el host de destino)',

    '__customers_total' => 'Total por clientes',
    '__resellers_total' => 'Total por revendedores',
    '__reseller_total' => 'Total de revendedor',


    'cu__mailserver_update_webmail_command' => "Especifica el cliente webmail que desea activar o desactivar",
    'cu__mailserver_webmail_state' => "Especifica el estado del cliente webmail seleccionado (true activa el cliente,false lo desactiva)",

    'cu_db_set_default_user' => 'Especifique un usuario para que sea el predeterminado para una base de datos. Esta opción se usa con los comandos: add_user, update_user',

    'cu_role__opt_subscription_name' => 'Permitir a los usuarios acceder únicamente a una suscripción especificada',
    'cu_role__opt_for_all_subscription' => 'Permitir a los usuarios acceder a todas las suscripciones dentro de una cuenta de hosting',
    'cu_role__subscription_not_found_role_is_not_limited' => 'No se pueden aplicar los cambios al rol: No se ha encontrado la suscripción %1.',

    'cu_cl_pref__manage_website_maintenance' => 'Acceso a operaciones avanzadas: Copia de sitio web',
    'cu_cl_pref__manage_protected_dirs' => 'Gestión de directorios protegidos con contraseña',
    'cu_cl_pref__manage_mail_settings' => 'Habilidad para cambiar la configuración de correo',


    'cu__command_update_php_settings' => 'Actualiza la configuración PHP.',
    'cu__php_settings_option' => 'Establece la ruta al archivo con la configuración PHP.',

    'cu__additional_php_settings_option' => 'Establece la ruta al archivo con las directivas PHP adicionales.',
    'cu__command_show_php_settings' => 'Muestra la configuración PHP actual.',
    'cu__general_settings' => 'Configuración general:',
    'cu__performance_settings' => 'Configuración de rendimiento:',
    'cu__php_fpm_settings' => 'Configuración de PHP-FPM:',
    'cu__additional_directives' => 'Directivas adicionales:',

    'b_filemanager__pack' => 'Añada los archivos seleccionados a un archivo.',

    'php_settings_permission_required' => 'Gestión de configuración PHP común',
    'php_settings_performance_permission_required' => 'Administración de configuración de rendimiento de hosting',
    'php_settings_customized' => 'La configuración PHP ha sido personalizada.',
    'php_settings_synchronized_with_plan' => 'La configuración PHP debe estar sincronizada con el plan.',
    'phosting__unknown_shell_type' => 'Shell no disponible',

    'login_up__access_denied_subscription_deleted' => 'Acceso denegado: Su suscripción ha sido eliminada.',

    'role_restricted_to_subscription' => '(transferido con la suscripción: %1)',

    'filemanager__extract' => "Extraer archivos en: %1",

    'cu__license_command_check_installed_license' => 'Compruebe la validez de la llave de licencia instalada (devuelve el código de salida 0 si la llave es válida y 1 si esta no es válida)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Amplíe la funcionalidad de Plesk para así poder controlar y monitorizar el servidor mediante dispositivos móviles (BlackBerry, iPhone y Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Obtenga en cualquier momento y desde cualquier sitio la información más importante acerca de los servidores Plesk mediante un dispositivo móvil (BlackBerry, iPhone y Android).',
    'promo__mobile_button' => 'Más info',

    'ui__server/migration/video__short-title' => 'Tutoriales en vídeo',
    'ui__server/migration/video__title' => 'Vea tutoriales en vídeo',
    'ui__server/migration/video__description' => 'Vea los tutoriales en vídeo.',

    'auto_install_updates_moved_to_separate_page' => 'Configurar directiva de actualización',

    '__system_preferences' => 'Configuración del sistema',
    'subDomainNameHint' => 'Introduzca * como nombre de subdominio para crear un subdominio wildcard. Los visitantes del sitio serán redireccionados a este subdominio, sin importar el nombre de subdominio que estos introduzcan en el navegador.',
    'subdomains__wildcard_name_invalid' => "El nombre del subdominio no es válido. En los nombres de los subdominios wildcard solo puede utilizar caracteres alfanuméricos, un guión (-) y un asterisco (*).",
    'subdomains__name_invalid' => "El nombre del subdominio no es válido. En los nombres de los subdominios solo puede utilizar caracteres alfanuméricos y un guión (-).",

    'domain__wildcard_no_www_prefix' => 'No se puede utilizar el prefijo www para subdominios wildcard.',

    '__service_title__milter' => "Milter Plesk Postfix",
    '__service_description__milter' => "Filtro de correo Plesk Postfix",
    '__milter' => "Milter de Postfix",
    'restart__milter' => "Milter de Plesk (%1)",
    'restart__pop3' => "Servidor Courier POP3",
    'restart__pop3s' => "Servidor Courier POP3 con soporte para SSL/TLS",
    'restart__imap' => "Servidor Courier IMAP",
    'restart__imaps' => "Servidor Courier IMAP con soporte para SSL/TLS",
    'restart__authdaemon' => "Daemon de autenticación de Courier IMAP",
    'restart__imap-pop3' => "Servidor IMAP y POP3 Dovecot",


    'addon_packages_not_supported' => 'No se soportan complementos para aplicaciones web paquetizadas en APS.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'No se pudo asignar automáticamente una dirección IP al dominio. Especifique una dirección IP usando la opción -ip.',

    'plesk_key__mb_accounts' => 'Cuentas de usuario (revendedores y clientes) en Customer & Business Manager',

    'actionlog__subdomain_dns' => 'Zona DNS del subdominio',
    'actionlog__site_subdomain_dns' => 'Zona DNS de un subdominio bajo un dominio adicional',

    // PfW only
    'actionlog__event_site_create' => 'Dominio creado',
    'actionlog__event_site_delete' => 'Dominio eliminado',
    'actionlog__event_site_update' => 'Dominio actualizado',

    'actionlog__event_site_status_update' => 'Estado del dominio actualizado',
    'actionlog__event_site_dns_update' => 'Zona DNS del dominio actualizada',
    'actionlog__event_site_guid_update' => 'GUID del dominio actualizado',

    'actionlog__event_site_subdomain_create' => 'Subdominio creado',
    'actionlog__event_site_subdomain_delete' => 'Subdominio eliminado',
    'actionlog__event_site_subdomain_update' => 'Subdominio actualizado',

    'actionlog__event_site_alias_create' => 'Alias de dominio creado',
    'actionlog__event_site_alias_delete' => 'Alias de dominio eliminado',
    'actionlog__event_site_alias_update' => 'Alias de dominio actualizado',

    'actionlog__event_site_alias_dns_update' => 'Se ha actualizado la zona DNS de un alias de dominio',
    'actionlog__event_subdomain_dns_update' => 'Se ha actualizado la zona DNS de un subdominio bajo el dominio predeterminado',
    'actionlog__event_site_subdomain_dns_update' => 'Se ha actualizado la zona DNS de un subdominio',
    // End of PfW only

    'win_policy__bad_password' => 'Error de validación. La contraseña no es válida.',
    'win_policy__password_too_short' => 'Error de validación. La contraseña no cumple los requisitos de la directiva de contraseñas porque es demasiado corta.',
    'win_policy__password_too_long' => 'Error de validación. La contraseña no cumple los requisitos de la directiva de contraseñas porque es demasiado larga.',
    'win_policy__password_not_complex_enough' => 'Error de validación. La contraseña no es suficientemente compleja y no cumple los requisitos de la directiva de contraseñas. Las contraseñas seguras deben contener al menos todo lo siguiente: ocho caracteres, un carácter en minúscula o mayúscula, tres números y un carácter especial (!, @, #, $, %, ^, &, *, ?, _, ~) o bien un número y dos caracteres especiales.',

    //// Activation Code feature
    'key__tabs_activation' => 'Activación de llave de licencia',
    'key__description' => 'Aquí puede instalar su llave de licencia introduciendo un código de activación o cargando un archivo de llave de licencia.',
    'key__description_code_only' => 'Aquí puede instalar su llave de licencia introduciendo un código de activación.',
    'key__license_key' => 'Seleccione una de las siguientes opciones:',
    'key__code_text' => 'Introduzca un código de activación',
    'key__code_hint' => 'Pegue el código de activación recibido.',
    'key__file_text' => 'Cargar un archivo de llave de licencia',
    'key__file_hint' => 'Especifique la ruta al archivo que contiene la llave de licencia.',
    'plesk_key__code_check_wrong' => 'El código de activación no es válido.',
    'plesk_key__license_update_failed' => 'No es posible actualizar la licencia del producto.',


    'filemanager__error_path_is_not_allowed' => 'La ruta no está permitida',
    'filemanager__error_path_is_invalid' => 'La ruta no es válida',
    'filemanager__error_path_not_found' => 'Ruta no encontrada',
    'filemanager__error_path_already_exists' => 'La ruta ya existe',
    'filemanager__error_access_is_denied' => 'Acceso denegado',
    'filemanager__error_directory_not_empty' => 'La carpeta no está vacía',
    'filemanager__error_sharing_violation' => 'Infracción al compartir',
    'filemanager__error_not_same_device' => 'La ruta de destino no está en el mismo dispositivo',
    'filemanager__binary_data_access' => 'Este archivo puede ser un archivo binario. ¿Desea abrirlo?',
    'filemanager__unable_to_resolve_realpath' => "En la ubicación especificada no se pudo encontrar el archivo %1",
    'filemanager__access_to_realpath_denied' => "Acceso a realpath denegado: %1 a %2.",
    'bt_exit' => 'Salir',

    'filemanager__chdir_error__' => "No se puede cambiar el directorio a %1: %2",
    'filemanager__chmod_dir' => "Cambiar permisos para el directorio %1",
    'filemanager__chmod_error__' => "No se pudieron cambiar los permisos para el archivo %1: %2",
    'filemanager__chmod_file' => "Cambiar permisos para el archivo %1",
    'filemanager__copy_error__' => "No se puede copiar %1 a %2: %3",
    'filemanager__copy_move' => "Copiar (mover) archivos de %1",
    'filemanager__count_size__' => 'Tamaño de la selección: %1',
    'filemanager__count_size_error__' => 'No se pudo calcular el tamaño para %1: %2',
    'filemanager__create_dir' => "Creación de directorio",
    'filemanager__create_dir_error__' => "No se pudo crear el directorio %1: %2",
    'filemanager__dir_not_exists' => "El directorio %1 no existe.",
    'filemanager__dirname' => "Nombre del directorio",
    'filemanager__filename' => "Nombre del archivo",
    'filemanager__is_no_such' => "No existe ningún archivo o directorio denominado %1",
    'filemanager__empty_selection' => "Ningún archivo seleccionado.",
    'filemanager__file_exists' => "El archivo %1 ya existe.",
    'filemanager__move_error__' => "No se pudo mover %1 a %2: %3",
    'filemanager__new_dir' => "Nombre del directorio",
    'filemanager__not_allowed' => "No puede cambiar los permisos para este archivo.",
    'filemanager__r_perm_dir' => "Listar directorio",
    'filemanager__r_perm_file' => "Leer datos",
    'filemanager__remove' => "Eliminar archivos de %1",
    'filemanager__remove_error__' => "No pudo eliminar el archivo %1: %2",
    'filemanager__rename_dir' => "Cambiar el nombre del directorio %1",
    'filemanager__rename_error__' => "No pudo cambiar el nombre de %1 a %2: %3",
    'filemanager__rename_file' => "Cambiar el nombre del archivo %1",
    'filemanager__set_win_permissions_dir' => "Establecer permisos para la carpeta %1",
    'filemanager__set_win_permissions_file' => "Establecer permisos para el archivo %1",
    'filemanager__touch_confirm' => "¿Está seguro de que desear cambiar la fecha de los archivos seleccionados?",
    'filemanager__no_perms_or_unsupported_file_type' => 'No se pudo leer el archivo o el formato del archivo no está soportado.',
    'filemanager__upload_error__' => "No se pudo cargar %1 a %2: %3",
    'filemanager__upload_file' => "Cargar archivo",
    'filemanager__upload_file_src' => "Ruta al archivo",
    'filemanager__username' => "Usuario",
    'filemanager__w_perm_dir' => "Crear archivos",
    'filemanager__w_perm_file' => "Escribir datos",
    'filemanager__x_perm_dir' => "Directorio Traverse",
    'filemanager__x_perm_file' => "Ejecutar archivo",
    'filemanager__max_image_size_exceeded' => 'No se pudo mostrar la imagen. El tamaño de la imagen no puede ser superior a %2 bytes',

    '__fastcgi_unix_support' => 'Soporte para FastCGI',

    'ts_sessions_list' => 'Esta página muestra la lista de todas las sesiones de Terminal Services.',
    'b_tssessionslist_search' => 'Busque sesiones por nombre.',
    'b_tssessionslist_show_all' => 'Vea todas las sesiones de servicios de terminal.',
    'l_tssessionslist_state' => 'Ordenar por estado.',
    'l_tssessionslist_name' => 'Ordenar por nombre.',
    'l_tssessionslist_user' => 'Ordenar por usuario.',
    'b_tssessionslist_logoff' => 'Haga clic para finalizar las sesiones seleccionadas.',
    'b_tssessionslist_disconnect' => 'Haga clic para desconectar las sesiones seleccionadas.',
    'tssessions_info' => 'Viendo las propiedades de la sesión.',
    'tssessions_disconnect' => 'Seleccione la casilla Confirmar la eliminación y haga clic en ACEPTAR para desconectar las sesiones de terminal seleccionadas.',
    'tssessions_logoff' => 'Seleccione la casilla Confirmar eliminación y haga clic en ACEPTAR para cerrar las sesiones de servidor terminal seleccionadas.',
    'b_tssession_disconnect_submit' => 'Haga clic para aplicar los cambios.',
    'b_tssession_logoff' => 'Haga clic para cerrar la sesión.',
    'b_tssession_logoff_submit' => 'Haga clic para aplicar los cambios.',
    'i_tssession_active' => 'Activo',
    'i_tssession_connected' => 'Conectado',
    'i_tssession_disconnected' => 'Desconectado',
    'i_tssession_listen' => 'Escuchando',
    'tssessions__tssessionslist' => 'Sesiones',
    'tssessionslist__state' => 'Estado',
    'tssessionslist__name' => 'Nombre',
    'tssessionslist__user' => 'Usuario',
    'bt_logoff_selected' => 'Cerrar sesión',
    'bt_logoff' => "Cerrar sesión",
    'bt_disconnect_selected' => 'Cerrar sesión',
    'bt_tssession_logoff' => 'Cerrar sesión',
    'bt_tssession_disconnect' => 'Desconectar',
    'bt_tssession_disconect' => 'Desconectar',
    'b_tssession_disconnect' => 'Haga clic para desconectar la sesión.',
    'b_tssession_logoff_disabled' => 'No se pudo cerrar la sesión.',
    'b_tssession_disconnect_disabled' => 'No se pudo desconectar la sesión.',
    'tssessions_info__title' => 'Propiedades sesión %1',
    'tssessions_info__property_name' => 'Nombre propiedad',
    'tssessions_info__property_value' => 'Valor propiedad',
    'tssessions__disconnect_title' => 'Se desconectarán las siguientes sesiones de terminal:',
    'tssessions__session_cant_disconnect' => 'la sesión no puede desconectarse',
    'tssessions__logoff_title' => 'Se cerrarán las siguientes sesiones de terminal:',
    'tssessions__session_cant_logoff' => 'la sesión no puede cerrarse',
    'tssessions__select_sessions_to_logoff' => 'Seleccione las sesiones que desea cerrar.',
    'tssessions__select_sessions_to_disconnect' => 'Seleccione las sesiones que desea desconectar.',
    'dns__subdomain_dns_zone_parent' => 'Los registros DNS de este subdominio se almacenan en la zona DNS principal. Usted puede modificar la zona principal %1 o crear otra zona para el subdominio.',
    'dns__subdomain_dns_zone_parent_link' => 'aquí',
    'dns__no_dns_zone' => 'No se ha asignado ninguna zona DNS al dominio. Para administrar la zona DNS de su dominio, deberá hacer clic en el botón \'Restaurar valores predeterminados\'.',
    'dns__unable_turn_on_subdomain_zone' => 'La zona del subdominio no pudo activarse porque existe un registro CNAME para este subdominio en la zona de su dominio principal.',

    '__hosting_write_modify' => 'Permisos adicionales de escritura/modificación',


    'aspdotnet__title' => "Configuración ASP.NET a nivel del servidor",
    'aspdotnet__dom_title' => "Configuración de ASP.NET para el sitio web",
    'aspdotnet__wdir_title' => "Configuración ASP.NET para el directorio virtual %1",
    'aspdotnet__group_cas_settings' => "Seguridad de acceso del código",
    'aspdotnet__group_client_scripts' => "Configuración de librería de scripts",
    'aspdotnet__group_conn_strings' => "Administrador de cadenas de conexión",
    'aspdotnet__group_custom_errors' => "Configuración de errores personalizados",
    'aspdotnet__group_framework_version' => "Versión de framework",
    'aspdotnet__group_globalization' => "Configuración de globalización",
    'aspdotnet__group_other' => "Configuración de sesión",
    'aspdotnet__group_page_and_runtime' => "Compilación y depuración",
    'aspdotnet__invalid_dom_config_file' => "El archivo de configuración de ASP.NET para este sitio web está dañado. Para restaurarlo, aplique la configuración ASP.NET predeterminada del servidor haciendo clic en Establecer como predeterminado.",
    'aspdotnet__invalid_file_enc' => "Valor no válido para el parámetro de codificación del archivo.",
    'aspdotnet__invalid_req_enc' => "Valor no válido para el parámetro de codificación de la petición.",
    'aspdotnet__invalid_res_enc' => "Valor no válido para el parámetro de codificación de respuesta.",
    'aspdotnet__invalid_parent_wdir_config_file' => "El archivo de configuración de ASP.NET está dañado porque la configuración de ASP.NET para el directorio principal %1 también lo está. \nPara solucionar este problema, restaure la configuración ASP.NET para %1.",
    'aspdotnet__invalid_global_config_file_admin' => "La configuración de ASP.NET está dañada porque el archivo de configuración ASP.NET del servidor también lo está.",
    'aspdotnet__invalid_global_config_file' => "La configuración de ASP.NET está dañada porque el archivo de configuración ASP.NET del servidor también lo está. Póngase en contacto con su proveedor de servicios.",
    'aspdotnet__invalid_sess_timeout' => "Valor no válido para el parámetro de tiempo de espera de la sesión. Introduzca un valor entero positivo inferior o igual a %1.",
    'aspdotnet__invalid_wdir_config_file' => "El archivo de configuración de ASP.NET para este directorio virtual está dañado. Para restaurarlo, aplique la configuración ASP.NET del directorio virtual principal haciendo clic en Establecer como predeterminado.",
    'aspdotnet__param_auth_mode' => "Modo de autenticación",
    'aspdotnet__param_conn_strings' => "Cadenas de conexión",
    'aspdotnet__param_conn_string_name' => "Nombre",
    'aspdotnet__param_conn_string_value' => "Parámetros de conexión",
    'aspdotnet__param_culture' => "Cultura",
    'aspdotnet__param_custom_err_mode' => "Modo de error personalizado",
    'aspdotnet__param_custom_error_redirect' => "URL de reenvío",
    'aspdotnet__param_custom_error_status' => "Código de estado",
    'aspdotnet__param_custom_errors' => "Errores personalizados",
    'aspdotnet__param_debug_mode' => "Activar depuración",
    'aspdotnet__param_def_language' => "Idioma predeterminado de la página web",
    'aspdotnet__param_temp_directory' => "Directorio temporal",
    'aspdotnet__param_file_enc' => "Codific. archivos",
    'aspdotnet__param_req_enc' => "Codific. solicitud",
    'aspdotnet__param_res_enc' => "Codific. respuesta",
    'aspdotnet__param_sess_timeout' => "Tiempo de espera de la sesión (minutos)",
    'aspdotnet__param_trust_level' => "Nivel de seguridad CAS",
    'aspdotnet__param_ui_culture' => "Cultura IU",
    'aspdotnet__param_version' => "Versión",
    'aspdotnet__param_trust_level_allow_override' => 'Permitir la modificación del nivel de seguridad CAS para sitios web individuales',
    'aspdotnet__restore_default_confirm' => "¿Desea restaurar la configuración predeterminada de ASP.NET?",

    'bt_restore_default' => "Establecer como predeterminado",
    'b_aspdotnet' => 'Edite parámetros de configuración ASP.NET',
    'b_aspdotnet__restore_default' => 'Restaure la configuración predeterminada de ASP.NET.',
    'b_aspdotnet__restore_wdir_default' => "Restaure la configuración de ASP.NET del directorio principal para este directorio virtual.",
    'b_aspdotnet__restore_default_disabled' => 'Restauración de la configuración predeterminada de ASP.NET no disponible: la configuración ASP.NET está dañada a nivel de servidor o del directorio principal.',
    'b_autoinstaller' => 'Actualice Plesk o sus componentes.',
    'b_autoinstaller_configure' => 'Actualice la configuración.',
    'b_autoinstaller_install' => 'Instalar los componentes seleccionados.',

    '__iis_app_pool__use_dedicated' => 'Grupo de aplicaciones IIS dedicado',
    '__iis_app_pool__use_dedicated_addons' => 'Grupo de aplicaciones IIS dedicado para cada sitio web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Habilite aplicaciones en 32 bits',
    'bt_iis_app_pool' => "Grupo de aplicaciones IIS",

    'performance__cpu_usage' => 'Uso máximo de la CPU (%)',
    'performance__cpu_usage_action' => 'Acción de límite',
    'performance__cpu_usage_interval' => 'Intervalo límite (minutos)',
    'performance__cpu_usage_action_not_supported' => 'La acción especificada no es soportada por el servidor web.',

    'performance__idle_timeout_action_not_supported' => 'La acción de tiempo de inactividad especificada no es soportada por el servidor web.',
    'performance__max_worker_processes' => 'El número máximo de procesos de trabajo',
    'performance__idle_timeout' => 'Tiempo de inactividad (minutos)',
    'performance__idle_timeout_action' => 'Acción de tiempo de inactividad',
    'performance__recycling_by_time' => 'Reciclar a intervalos de tiempo regulares (minutos)',
    'performance__recycling_by_requests' => 'Reciclar cuando se alcance el número máximo de peticiones',
    'performance__recycling_by_virtual_memory' => 'Reciclar cuando se utilice la cantidad máxima de memoria virtual',
    'performance__recycling_by_private_memory' => 'Reciclar cuando se utilice la cantidad máxima de memoria privada',
    'performance__managed_pipeline_mode' => 'Modo de canalización administrada',
    'performance__managed_pipeline_mode_not_supported' => 'El servidor web no soporta el modo especificado.',

    'iis_app_pool' => 'Administración del grupo de aplicaciones IIS.',
    'b_iis_app_pool' => 'Administre el grupo de aplicaciones IIS.',
    'iis_app_pool_cl_dom' => 'Administración del grupo de aplicaciones IIS.',

    'i_webdirs_not_protected' => 'Este directorio no está protegido.',
    'i_webdirs_protected' => 'Este directorio está protegido.',
    'i_webdirs_manage_protection' => 'Administre la protección.',
    'i_webdirs_open' => 'Abra el directorio/archivo en el navegador.',
    'i_webdirs_preferences_disabled' => 'Este directorio no es un directorio virtual.',
    'i_webdirs_permissions' => 'Administre permisos.',
    'i_webdirs_permissions_disabled' => 'La administración de los permisos del directorio no está disponible.',
    'i_webdirs_type_dir' => 'Directorio físico',
    'i_webdirs_type_vdir' => 'Directorio virtual',
    'i_webdirs_browse' => 'Examine el contenido del directorio.',
    'i_webdirs_preferences' => 'Administración de configuración de directorio web.',

    'l_webdirslist_type' => 'Ordenar directorios por tipo.',
    'l_webdirslist_protected' => 'Ordenar directorios por estado de la protección.',
    'l_webdirslist_name' => 'Ordenar directorios por nombre.',

    'b_webdirslist_remove' => 'Elimine los directorios virtuales seleccionados.',
    'b_webdirslist_search' => 'Indique un patrón de búsqueda y haga clic para buscar directorios virtuales.',
    'b_webdirslist_show_all' => 'Vea todos los directorios.',

    'l_webdirerrordocslist_code' => 'Ordenar documentos de error por número de código de error.',
    'l_webdirerrordocslist_name' => 'Ordenar documentos de error por su descripción.',
    'l_webdirerrordocslist_type' => 'Ordenar documentos de error por tipo.',
    'l_webdirerrordocslist_location' => 'Ordenar documentos de error por su ubicación.',

    'b_webdirerrordocslist_search' => 'Introduzca un patrón de búsqueda y haga clic para buscar documentos de error.',
    'b_webdirerrordocslist_remove' => 'Elimine los documentos de error seleccionados.',
    'b_webdirerrordocslist_show_all' => 'Vea todos los documentos de error.',

    'l_webdirmimetypeslist_name' => 'Ordene los tipos MIME por extensión.',
    'l_webdirmimetypeslist_content' => 'Ordene los tipos MIME por contenido.',

    'b_webdirmimetypeslist_remove' => 'Elimine los tipos MIME seleccionados.',
    'b_webdirmimetypeslist_search' => 'Introduzca un patrón de búsqueda y haga clic para encontrar tipos MIME.',
    'b_webdirmimetypeslist_show_all' => 'Vea todos los tipos MIME.',

    'b_webdir_preferences' => "Configuración de directorio virtual.",
    'b_webdir_permissions' => "Permisos de directorio virtual.",
    'b_webdir_permissions_disabled' => "La administración de los permisos del directorio no está disponible.",
    'b_to_webdirs' => 'Vuelva a la administración de directorios.',
    'b_to_webdir_mime_types' => 'Vuelva a la administración de tipos MIME.',
    'b_to_webdir_error_docs' => 'Vuelva a la administración de documentos de error.',
    'b_to_webdir_protection' => 'Vuelva a la administración de la protección de directorios virtuales.',

    'webdirs__title' => 'Directorio virtual %1',
    'webdirs__preferences_title' => 'Configuración de directorios virtuales',
    'webdirs__list_legend' => 'Directorios virtuales',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Nombre',
    'webdirs__list_header' => '%1 elementos',
    'webdirs__tabs_general' => 'General',
    'webdirs__tabs_mime_types' => 'Tipos MIME',
    'webdirs__tabs_error_docs' => 'Documentos de error',

    'webdirs__tabs_permissions' => 'Permisos',
    'webdir__remove_vdirs' => 'Se eliminarán los siguientes directorios virtuales:',
    'webdir__remove_mime_types' => 'Se eliminarán los siguientes tipos MIME:',
    'webdir__mime_types_title' => 'Tipos MIME',
    'webdir__protection_disable_confirm' => '¿Seguro que desea eliminar la protección del directorio?',
    'webdir__protect_title' => 'Usuarios de URL protegida',
    'webdirs__permissions_title' => 'Permisos de directorio virtual',
    'webdirs__browse_content_permission_denied' => 'No dispone de permisos para ver el contenido de este directorio.',
    'error_doc__list_code' => 'Error',
    'error_doc__list_code_description' => 'Descripción',
    'error_doc__list_type' => 'Tipo',
    'error_doc__list_location' => 'Ubicación',
    'error_doc__code' => 'Error',
    'error_doc__type' => 'Tipo',
    'error_doc__type_file' => 'Archivo',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Ubicación',
    'error_doc__legend' => 'Documento de error',
    'error_doc__edit_title' => 'Editar documento de error',
    'error_doc_erorr_invalid_url_location' => 'La URL no es válida. Especifique la URL correcta.',
    'error_doc_erorr_invalid_file_location' => 'Ruta al archivo no es válida. Especifique una ruta correcta.',
    'error_doc__type_default' => 'Predeterminado',

    'webdirs__tabs_protection' => 'Protección',
    'pb_webdirs' => 'Directorios virtuales',

    'webdirs_remove_title' => 'Se eliminarán los siguientes directorios virtuales:',
    'webdirs_mime_types_remove_title' => 'Se eliminarán los siguientes tipos MIME:',
    'webdirs_preferences_title' => 'Configuración de directorios virtuales',
    'webdirs_permissions_title' => 'Permisos especiales para archivos y carpetas',
    'webdi_protection_disable_confirm' => '¿Está seguro de que desea eliminar la protección del directorio virtual? Esto también eliminará todos los usuarios del directorio protegido y la configuración de protección del directorio.',
    'bt_protect' => 'Proteger',
    'bt_unprotect' => 'Eliminar protección',
    'bt_show_additional_users' => 'Mostrar más usuarios',
    'bt_hide_additional_users' => 'Mostrar menos usuarios',
    'error_doc__list_title' => 'Documentos de error',
    'error_doc__list_header' => 'Documentos de error',
    'error_doc__code_400' => 'Solicitud no válida',
    'error_doc__code_401' => 'No autorizado',
    'error_doc__code_401.1' => 'No autorizado - Usuario erróneo',
    'error_doc__code_401.2' => 'No autorizado - Error de inicio de sesión debido a la configuración en servidor',
    'error_doc__code_401.3' => 'No autorizado - No autorizado debido a una ACL en el recurso',
    'error_doc__code_401.4' => 'No autorizado - Error de autorización por filtro',
    'error_doc__code_401.5' => 'No autorizado - Error de autorización por aplicación ISAPI/CGI',
    'error_doc__code_401.7' => 'No autorizado - Denegado debido a la directiva de autorización URL',
    'error_doc__code_403' => 'Prohibido',
    'error_doc__code_403.1' => 'Prohibido - Acceso de ejecución denegado',
    'error_doc__code_403.2' => 'Prohibido - Acceso de lectura denegado',
    'error_doc__code_403.3' => 'Prohibido - Acceso de escritura denegado',
    'error_doc__code_403.4' => 'Prohibido - SSL requerido',
    'error_doc__code_403.5' => 'Prohibido - SSL 128 requerido',
    'error_doc__code_403.6' => 'Prohibido - Dirección IP rechazada',
    'error_doc__code_403.7' => 'Prohibido - Certificado cliente requerido',
    'error_doc__code_403.8' => 'Prohibido - Acceso al sitio denegado',
    'error_doc__code_403.9' => 'Prohibido - Demasiados usuarios',
    'error_doc__code_403.10' => 'Prohibido - Configuración incorrecta',
    'error_doc__code_403.11' => 'Prohibido - Cambio de contraseña',
    'error_doc__code_403.12' => 'Prohibido - Acceso al mapeador denegado',
    'error_doc__code_403.13' => 'Prohibido - Certificado cliente revocado',
    'error_doc__code_403.14' => 'Prohibido - Enumeración de directorios denegada',
    'error_doc__code_403.15' => 'Prohibido - Licencias de acceso cliente excedidas',
    'error_doc__code_403.16' => 'Prohibido - El certificado cliente no es de confianza o está formado incorrectamente',
    'error_doc__code_403.17' => 'Prohibido - El certificado cliente ha expirado o aún no es válido',
    'error_doc__code_403.18' => 'Prohibido - No se puede ejecutar la solicitud desde este grupo de aplicaciones',
    'error_doc__code_403.19' => 'Prohibido - Acceso denegado a CGI',
    'error_doc__code_403.20' => 'Prohibido - Error de acceso a Passport',
    'error_doc__code_404' => 'No encontrado',
    'error_doc__code_404.2' => 'No encontrado - Denegado debido a directiva de bloqueo',
    'error_doc__code_404.3' => 'No encontrado - Denegado debido a directiva MIMEMAP',
    'error_doc__code_405' => 'Método no permitido',
    'error_doc__code_406' => 'No aceptable',
    'error_doc__code_407' => 'Se requiere autenticación del proxy',
    'error_doc__code_412' => 'Error en la condición previa',
    'error_doc__code_414' => 'El URI de la solicitud es demasiado largo',
    'error_doc__code_415' => 'Tipo de medio no compatible',
    'error_doc__code_500' => 'Error interno del servidor',
    'error_doc__code_500.12' => 'Error interno del servidor - Reinicio de aplicación',
    'error_doc__code_500.13' => 'Error interno del servidor - Servidor demasiado ocupado',
    'error_doc__code_500.15' => 'Error interno del servidor - Solicitudes directas a GLOBAL.ASA prohibidas',
    'error_doc__code_500.16' => 'Error interno del servidor - Error de acceso a UNC',
    'error_doc__code_500.17' => 'Error interno del servidor - Almacén de autorizaciones de direcciones URL no encontrado',
    'error_doc__code_500.18' => 'Error interno del servidor - No se puede abrir el almacén de autorizaciones de direcciones URL',
    'error_doc__code_500.19' => 'Error interno del servidor - Metadatos de archivo no válidos',
    'error_doc__code_500.100' => 'Error interno del servidor - Error de ASP',
    'error_doc__code_501' => 'No implementado',
    'error_doc__code_502' => 'Pasarela no válida',
    'error_doc__code_503' => 'Servicio no disponible actualmente',

    'mimetype__extension' => 'Extensión',
    'mimetype__content' => 'Contenido',
    'mimetypeslist__title' => 'Tipos MIME',
    'mimetypes__title' => 'Tipos MIME',
    'mimetypes__select_to_remove' => 'Seleccione los tipos MIME que desea eliminar.',
    'mimetypes__select_for_remove' => "Seleccione los tipos MIME a eliminar.",
    'mimetypes_remove__title' => 'Eliminar tipo MIME',
    'mimetype__legend' => 'Tipo MIME',
    'mimetype_edit__title' => 'Editar tipo MIME',
    'mimetype_edit__already_exists' => 'El tipo MIME ya está definido para esta extensión.',
    'mimetype_edit__not_exists' => 'El tipo MIME no existe.',
    'mimetype__content_type_other' => 'Personalizado...',

    'b_webdir_protection_enable' => 'Hacer que la URL que corresponde con el directorio esté protegida por contraseña.',
    'b_webdir_protection_disable' => 'Hacer que la URL que corresponde con el directorio sean accesible para todos.',
    'b_webdir_protection_disabled' => 'La protección para el directorio virtual está desactivada.',

    'b_pd_usr_create' => 'Haga clic para crear el usuario de esta URL protegida.',
    'php__changeversion_title' => "Seleccionar la versión PHP",
    'php__group_php_version' => "Versión PHP",

    'virtualdir__name' => 'Nombre',
    'virtualdir__path' => 'Ruta',
    'virtualdir__read' => 'Permiso de lectura',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Permiso de escritura',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Acceso al código fuente de scripts',
    'virtualdir__source_short' => 'Estado',
    'virtualdir__browse' => 'Examen de directorios',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Permisos de ejecución',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Registrar visitas',
    'virtualdir__app_create' => 'Crear aplicación',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Activa la autenticación anónima.',
    'virtualdir__auth_windows' => 'Activa la autenticación de Windows.',
    'virtualdir__auth_not_enabled' => 'Es necesario tener activada la autenticación de Windows o anónima.',
    'virtualdir__require_ssl' => 'Requerir SSL/TLS',
    'virtualdir__enable_default_doc' => 'Usar documentos predeterminados',
    'virtualdir__default_doc' => 'Orden de búsqueda de documentos predeterminados',
    'virtualdir__enable_parent_paths' => 'Permitir el uso de rutas principales',
    'virtualdir__execute_in_mta' => 'Permitir la ejecución de la aplicación en modo MTA (multi-threaded apartment)',
    'virtualdir_create__title' => 'Crear directorio virtual en %1',
    'virtualdir_edit__title' => 'Propiedades del directorio virtual %1',
    'virtualdir_edit__legend' => 'Directorio virtual',
    'virtualdir_edit__application_legend' => 'Configuración de la aplicación',
    'virtualdir_edit__security_legend' => 'Seguridad del directorio',
    'virtualdir_edit__documents_legend' => 'Documentos',
    'virtualdir_edit__list_legend' => 'Directorios virtuales anidados',
    'virtualdir_error__path_not_in__' => 'La ruta indicada no es válida',
    'virtualdir_error__already_exists' => 'Ya existe un directorio con este nombre.',
    'virtualdir_root' => 'Directorios virtuales',
    'virtualdir_root__title' => 'Directorios virtuales',
    'virtualdir_root__list_legend' => 'Directorios virtuales',
    'virtualdir_se__none' => 'Ninguno',
    'virtualdir_se__script' => 'Solo scripts',
    'virtualdir_se__script_execute' => 'Scripts y ejecutables',
    'virtualdirs__title' => 'Directorios virtuales',
    'virtualdirs__path_not_exists' => 'Ruta no válida.',
    'virtualdirs__select_for_remove' => "Seleccione los directorios virtuales a eliminar.",
    'virtualdirs_remove__title' => 'Eliminar directorios virtuales',
    'virtualdirs_phys_dir_exist' => 'Ya existe un directorio físico con este nombre. De continuar, no se podrá acceder al mismo. ¿Desea continuar?',
    'virtualdir_auto_create_dir' => "Crear directorio físico con el mismo nombre que el directorio virtual",

    'asp_max_default_text' => 'Definido por directorio principal (%1 KB)',
    'asp_max_default_text_site' => 'Definido por IIS (%1 KB)',
    'asp_max_buffer_text' =>'Tamaño máximo del búfer ASP (KB)',
    'asp_max_body_text' => 'Tamaño máximo del cuerpo de una petición ASP (KB)',
    'asp_buffers_legend' =>'Configuración ASP',

    'asp_debug_default_text' =>'Definido por el directorio principal',
    'asp_debug_default_text_site' =>'Definido por IIS',
    'asp_client_debug_text' =>'Activar depuración de scripts ASP a nivel del cliente',
    'asp_server_debug_text' =>'Activar depuración de scripts ASP a nivel del servidor',

    'webdirs__list_with_broken_dirs' => "Existen directorios virtuales vinculados a carpetas físicas inexistentes.",
    'webdirs__vdir_physical_path_not_exist' => "El directorio virtual está vinculado a una carpeta física que no existe.",
    'webdirs__physical_path_not_exist' => "La ruta especificada no existe.",

    'filemanager__new_dir_title' => 'Crear directorio',
    'php__configuration_title' => "Configuración PHP",

    'permissions__title' => 'Establecer permisos de acceso',
    'permissions__title_advanced' => 'Estableciendo permisos avanzados de acceso',
    'permissions__inherit_from_parent' => 'Permitir que los permisos permisos heredables del objeto principal se propaguen a este objeto y a todos los objetos secundarios. Esto incluye las entradas definidas aquí de forma explícita.',
    'permissions__replace_on_children' => 'Reemplazar entradas de permisos en todos los objetos secundarios por las entradas mostradas aquí.',
    'permissions__group_or_user_name' => 'Nombres de usuario o grupo',
    'permissions__Permissions_for' => 'Permisos para',
    'permissions__allow' => 'Permitir',
    'permissions__deny' => 'Denegar',
    'permissions__FullControl' => 'Control total',
    'permissions__Modify' => 'Modificar',
    'permissions__ReadAndExecute' => 'Lectura y ejecución',
    'permissions__ListFolderContents' => 'Listar contenido de la carpeta',
    'permissions__Read' => 'Lectura',
    'permissions__Write' => 'Escribir',
    'permissions__ReadControl' => 'Control de lectura',
    'permissions__WriteControl' => 'Control de escritura',
    'permissions__ExecuteControl' => 'Control de ejecución',
    'permissions__TraverseFolderOrExecuteFile' => 'Recorrer carpeta / Ejecutar archivo',
    'permissions__ListFolderOrRead' => 'Listar carpeta / leer datos',
    'permissions__CreateFilesOrWrite' => 'Crear archivos / escribir datos',
    'permissions__CreateFoldersOrAppend' => 'Crear carpetas / añadir datos',
    'permissions__DeleteSubfoldersandFiles' => 'Eliminar subcarpetas y archivos',
    'permissions__Delete' => 'Eliminar',
    'permissions__ChangePermissions' => 'Cambiar permisos',
    'permissions__TakeOwnership' => 'Establecer propietario',
    'permissions__inherited_from' => 'Heredados de',
    'permissions__not_inherited' => '<no heredado>',
    'permissions__apply_to' => 'Aplicar a',
    'permissions__apply_onto' => 'Aplicar a:',
    'permissions__apply_onto1' => 'Solo esta carpeta',
    'permissions__apply_onto2' => 'Solo subcarpetas',
    'permissions__apply_onto3' => 'A esta carpeta y subdirectorios',
    'permissions__apply_onto4' => 'Solo archivos',
    'permissions__apply_onto5' => 'Esta carpeta y archivos',
    'permissions__apply_onto6' => 'Solo subcarpetas y archivos',
    'permissions__apply_onto7' => 'Esta carpeta, subcarpetas y archivos',

    'filemanager__not_allowed_dir' => "No puede cambiar los permisos para esta carpeta.",

    'filemanager__allow' => "Permitir",
    'filemanager__deny' => "Rechazar",
    'filemanager__user_domusr' => 'Administrador del sitio web',
    'filemanager__user_webusr' => 'Usuario web',
    'filemanager__user_admins' => 'Administradores',
    'filemanager__user_system' => 'SISTEMA',
    'filemanager__user_aspnet' => 'Usuario ASP.NET',
    'filemanager__user_poolusr' => 'Grupo de aplicaciones del usuario',
    'filemanager__user_sysaccount' => 'Usuario adicional del sistema',

    'bt_permissions_advanced' => 'Avanzado',
    'b_permissions_advanced' => 'Haga clic para ver y establecer permisos especiales.',

    'b_hotlinkprotection' => 'Configure protección hotlink para el sitio web.',
    'b_hotlinkprotection_on' => 'Active la protección hotlink del contenido del sitio web.',
    'b_hotlinkprotection_off' => 'Desactive la protección hotlink del contenido del sitio web.',

    'bt_hotlinkprotection' => 'Protección Hotlink',
    'hotlinkprotection__title' =>'Protección Hotlink',
    'hotlinkprotection__friend_domains' => 'Direcciones de sitios web conocidos',
    'hotlinkprotection__extensions' => 'Extensiones archivos protegidos',

    'hotlinkprotection_invalid_friend_domains' => 'Nombres no válidos para dominios conocidos.',
    'hotlinkprotection_invalid_extensions' => 'Las extensiones de archivo contienen caracteres no válidos.',

    'i_domain_alias_status_on' => 'Alias de dominio activado.',
    'i_domain_alias_status_off' => 'Alias de dominio desactivado.',
    'i_domain_alias_status_with_parent' => 'El alias de dominio está desactivado porque el dominio está apagado.',
    'i_domain_alias_turn_off' => 'Haga clic para desactivar.',
    'i_domain_alias_turn_on' => 'Haga clic para activar.',
    'i_domain_alias_mail_on' => 'El servicio de correo de para este alias de dominio está activado.',
    'i_domain_alias_mail_off' => 'El servicio de correo de para este alias de dominio está desactivado.',
    'i_domain_alias_mail_with_parent' => 'El servicio de correo está desactivado porque el alias de dominio está apagado.',
    'i_domain_alias_web_on' => 'El servicio web está activado para este alias de dominio.',
    'i_domain_alias_web_off' => 'El servicio web está desactivado para este alias de dominio.',
    'i_domain_alias_web_with_parent' => 'El servicio web está desactivado porque el alias de dominio está apagado.',
    'i_domain_alias_dns_on' => 'El servicio de alias DNS está activado para este alias de dominio.',
    'i_domain_alias_dns_off' => 'El servicio de alias DNS está desactivado para este alias de dominio.',
    'i_domain_alias_dns_with_parent' => 'La sincronización del DNS con el dominio principal está deshabilitada porque el alias de dominio está desactivado.',
    'i_domain_alias_seoRedirect_on' => 'El redireccionamiento con el código HTTP 301 está activado para este alias de dominio.',
    'i_domain_alias_seoRedirect_off' => 'El redireccionamiento con el código HTTP 301 se encuentra desactivado para este alias de dominio.',
    'i_domain_alias_seoRedirect_with_parent' => 'El redireccionamiento con el código HTTP 301 se encuentra desactivado porque el alias de dominio está desactivado.',

    'domain_alias__control_title' => 'Alias de dominio %1',
    'domain_alias__control_info_legend' => 'Información',
    'domain_alias__control_status_title' => 'Estado',
    'domain_alias__control_name_title' => 'Nombre del servicio',
    'domain_alias__control_details_title' => 'Detalles',

    'domain_alias__invalid_values' => 'El nombre de dominio especificado no es válido. Los nombres de dominio pueden contener letras, dígitos y guiones. Cada parte del nombre de dominio entre puntos no debería tener más de 63 símbolos.',
    'domain_alias__domain_already_exists' => "Nombre incorrecto del alias de dominio %1. El dominio %1 ya existe.",
    'domain_alias__www_prefix_domain_already_exists' => "Nombre incorrecto del alias de dominio www.%1. E ste alias ya se ha creado para el dominio %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nombre incorrecto del alias de dominio webmail.%1. Este alias ya ha sido creado para el dominio %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nombre incorrecto del alias de dominio lists.%1. Este alias ya ha sido creado para el dominio %1.',
    'domain_alias__dns_record_already_exists' => 'No se puede configurar el alias de dominio %1 porque ya existe un registro DNS que apunta al host %1.',
    'domain_alias__domain_alias_already_exists' => "Ya existe un alias de dominio con este nombre.",
    'domain_aliases__mail_server_not_support_aliases' => 'El servidor de correo no soporta la prestación de aliases de dominio. Puede que los aliases de dominio no funcionen correctamente.',
    'domain_alias__restrict_domain_creation' => 'La directiva a nivel del servidor prohíbe el uso del nombre indicado para el alias de dominio. Si usted es el propietario de este alias de dominio, rogamos contacte con su proveedor de hosting.',
    'domain_alias__restrict_creation_with_www' => 'Indique un nombre de dominio sin el prefijo \'www\'. El prefijo www para el dominio se añadirá automáticamente a la configuración del servidor web.',
    'domain_unable_to_set_name' => 'El nombre %1 no es correcto.',

    'domain_alias__domain_service_dns_disabled' => 'Este dominio está servidor por otro servidor DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Este servidor DNS actúa como servidor de nombres principal para esta zona DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Este servidor DNS actúa como servidor de nombres secundario para esta zona DNS.',
    'domain_alias__domain_service_mail_enabled' => 'El servicio de correo está habilitado para el dominio.',
    'domain_alias__domain_service_mail_disabled' => 'El servicio de correo está deshabilitado para el dominio.',
    'domain_alias__domain_service_mail_mx' => '%1 se usa como servidor de correo.',

    'domain_alias__service_seoRedirect_hint' => 'Cuando los visitantes abran la URL del alias, estos serán redireccionados a la URL del dominio principal. Plesk utiliza el redireccionamiento HTTP 301 compatible con motores de búsqueda, lo que significa que el posicionamiento de los motores de búsqueda no se dividirá entre las URLs.',

    'bt_task_run_now' => 'Ejecutar ahora',
    'ftp__read_perm' => "Permiso de lectura",
    'ftp__write_perm' => "Permiso de escritura",

    'filemanager__upload_backup_file_hint' => 'Aquí puede cargar archivos de backup al almacenamiento de Plesk. El tamaño máximo del archivo es de dos gigabytes.',

    'additional_key__used' => 'activada',

    '__default_for_mssql' => 'predeterminado para MS SQL',

    '__login_does_not_pass_validation' => "El nombre de usuario no es válido. Compruebe que cumple los siguientes requisitos: %1",
    '__login_allowed_symbols' => 'Solo se permite el uso de caracteres alfanuméricos, incluyendo puntos, guiones y guiones bajos. El primer carácter debería ser alfanumérico.',

    'restart__nginx' => 'Servidor proxy inverso (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Deseo recibir información general del producto y noticias de Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Deseo recibir información de seguridad y otras notificaciones técnicas de Plesk.",

    'server_preferences__webdeploy_include_password' => 'Incluir la contraseña del usuario en el archivo con la configuración de publicación de Web Deploy',

    '__login_status_inactive' => 'Su cuenta no está activa. Póngase en contacto con el administrador de Plesk.',

    'migration__task_keep_in_process' => 'ACEPTAR',
    'migration__task_keep_in_process_conhelp' => 'Volver a la página Herramientas y configuración. La migración continuará en segundo plano.',

    'ui__admin-alias-info__description' => "Edite la información de contacto de la cuenta de administrador adicional.",
    'ui__admin-alias-info__short-title' => "Información de contacto",
    'ui__admin-alias-info__title' => "Información adicional de la cuenta de administrador",
    'ui__admin-alias-password__description' => "Cambie la contraseña del administrador adicional.",

    'ui__admin-alias-password__short-title' => "Cambiar la contraseña",
    'ui__admin-alias-password__title' => "Contraseña del administrador adicional",
    'ui__admin-alias__description' => "Vea y edite la información de cuentas de administrador adicionales.",

    'chk_js__warning_about_login_syntax' => "En el nombre de usuario puede utilizar alfanuméricos en minúsculas, guiones y guiones bajos. El nombre de usuario debe empezar por un carácter alfabético. La contraseña no debe contener el nombre de usuario ni comillas.",
    'chk_js__warning_about_ftp_login_syntax' => "En el nombre de usuario puede usar caracteres alfanuméricos, guiones y guiones bajos.",
    'chk_js__warning_about_login_syntax_win' => "En el nombre de usuario puede utilizar alfanuméricos en minúsculas, guiones, puntos y guiones bajos.El nombre de usuario debe empezar por un carácter alfabético o un número.La contraseña no debe contener el nombre de usuario ni comillas.",
    'chk_js__warning_about_passwd_syntax' => "No utilice comillas, espacios ni caracteres del alfabeto nacional en la contraseña.\nLa contraseña debe tener entre %1 y %2 caracteres y no debe de contener el nombre de usuario.",
    'chk_js__warning_about_plesk_login_syntax' => "En el nombre de usuario puede usar alfanuméricos en minúsculas, puntos, guiones y guiones bajos.",
    'chk_js__warning_about_plesk_login_syntax_win' => "En el nombre de usuario puede usar alfanuméricos en minúsculas, guiones y guiones bajos. El nombre de usuario debe empezar por un símbolo alfabético.",
    'chk_js__warning_about_plesk_passwd_syntax' => "No utilice comillas, espacios ni caracteres del alfabeto nacional en la contraseña.\nLa contraseña debe tener entre %1 y %2 caracteres y no debe de contener el nombre de usuario.",
    'chk_js__warning_about_pam_passwd_error' => "Se ha indicado una cuenta de usuario del sistema que no es correcta: %1",

    'cmd_server__admin_alias_not_found' => "No se pudo encontrar la cuenta de administrador adicional.",

    'panel_branding__skins_already_exists' => "Nota: el tema '%1' ya existe. Este será reemplazado por el tema que está instalando en este momento.",
    'panel_branding__skins_file_exists' => "No se pudo crear el directorio para el tema '%1': Ya existe un archivo con este nombre.",

    'actionlog__login_failed' => 'error de acceso',
    'actionlog__event_cp_user_login_failed' => 'El usuario de Plesk no pudo iniciar sesión',
    'actionlog__api_login_failed' => 'error de acceso mediante API',
    'actionlog__event_cp_user_api_login_failed' => 'El usuario de Plesk no pudo iniciar sesión mediante la API',
    'actionlog__pw_reset' => 'restablecimiento de contraseña solicitado',

    'ch_pass_by_secret__email_subject' => "Recordatorio de la contraseña de Plesk",
    'ch_pass_by_secret__email_body' => "Hola %2,\n\nPara establecer una nueva contraseña, haga clic en el siguiente enlace: %1\n\nSu nombre de usuario: %3",
    'ch_pass_by_secret__message_send_error' => 'No se pudo enviar el código secreto: %1',
    'ch_pass_by_secret__title' => 'Cambiar su contraseña',
    'ch_pass_by_secret__secret' => 'Código secreto',

    'custom_button__noframe' => "No usar marcos",

    'custom_button__internal_hint' => 'Especifique si desea abrir la URL en una página de Plesk o en una ventana nueva del navegador.',
    'custom_button__noframe_hint' => 'Si añade un botón personalizado que redirecciona a una extensión de Plesk o a una aplicación del panel del cliente, puede indicar cómo desea que se muestre esa extensión o aplicación: en un marco o como parte del GUI de Plesk.',


    'actionlog__patch' => 'Actualización',
    'actionlog__patch_available' => 'disponible',
    'actionlog__event_patch_available' => 'Actualización disponible',
    'actionlog__patch_installed' => 'instalado',
    'actionlog__event_patch_installed' => 'Actualización instalada',

    'actionlog__extension' => 'Extensión',
    'actionlog__extension_status' => 'Estado de la extensión',
    'actionlog__cloning' => 'Clonación de servidores',
    'actionlog__cloning_complete' => 'completada',
    'actionlog__event_cloning_complete' => 'Clonación de servidores completada',

    'actionlog__ssl_web_binding' => 'Certificado SSL/TLS en el dominio',
    'actionlog__ssl_web_binding_update' => 'asignado/no asignado',
    'actionlog__event_ssl_web_binding_update' => 'Certificado SSL/TLS en el dominio asignado/no asignado',

    'actionlog__ssl_web_mail_binding' => 'Certificado SSL/TLS en el webmail',
    'actionlog__ssl_web_mail_binding_update' => 'asignado/no asignado',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certificado SSL/TLS en el webmail asignado/no asignado',

    'actionlog__ssl_mail_binding' => 'Certificado SSL/TLS en el servidor de correo',
    'actionlog__ssl_mail_binding_update' => 'asignado/no asignado',
    'actionlog__event_ssl_mail_binding_update' => 'Certificado SSL/TLS en el servidor de correo asignado/no asignado',

    'actionlog__ssl_panel_binding' => 'Certificado SSL/TLS en Plesk',
    'actionlog__ssl_panel_binding_update' => 'asignado/no asignado',
    'actionlog__event_ssl_panel_binding_update' => 'Certificado SSL/TLS en Plesk asignado/no asignado',

    'actionlog__hostname' => 'Nombre de host del servidor',
    'actionlog__hostname_changed' => 'modificado',

    'actionlog__event_mail_management_status_update' => 'Actualización del estado de gestión de correo',
    'actionlog__mail_management' => 'Estado de gestión de correo',
    'actionlog__mail_management_status_update' => 'actualizado',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Total por dominios',

    'chk_js__warning_about_admin_passwd_syntax' => "No use comillas, espacios, punto y coma ni caracteres del alfabeto nacional en la contraseña.\nLa contraseña debe tener entre %1 y %2 caracteres y no debe contener el nombre de usuario.",

    'passwordSecurityLevelCheckFailed' => 'Su contraseña no es suficientemente compleja. De acuerdo con la directiva del servidor, la seguridad mínima de la contraseña debe ser %1. Para mejorar la seguridad de la contraseña, use número, caracteres en mayúsculas y minúsculas y caracteres especiales como por ejemplo !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Muy poco segura',
    'passwordSecurityLevelCheckFailedWeak' => 'Poco segura',
    'passwordSecurityLevelCheckFailedMediocre' => 'Media',
    'passwordSecurityLevelCheckFailedStrong' => 'Segura',
    'passwordSecurityLevelCheckFailedStronger' => 'Muy segura',

    'cu__php_settings__command_update_all' => "Actualice la configuración PHP por dominio de todos los dominios de acuerdo con el archivo php.ini a nivel del servidor.",
    'cu__php_settings__update_all_done' => "La configuración PHP por dominio de todos los dominios se ha actualizado correctamente.",

    'filemanager__invalid_path' => "La ruta especificada no es válida",

    'additional_key__descr_app' => 'Aplicación',
    'additional_keys__used_keys' => ', %1 llaves usadas',
    'additional_key__descr_key_mailboxes' => 'Buzones de correo',

    'ui__client/domain/dns/sync__description' => 'Aplique los cambios de la plantilla DNS a nivel de servidor a la zona.',
    'ui__client/domain/dns/sync__disabled-warning' => 'No se pudieron aplicar los cambios de la plantilla DNS a la zona porque la zona está servida por otro servidor DNS.',
    'ui__client/domain/dns/sync__short-title' => 'Aplicar cambios de plantilla DNS',
    'ui__client/domain/dns/sync__done' => 'Los cambios de la plantilla DNS se han aplicado correctamente a la zona.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Aplique los cambios de la plantilla DNS a nivel de servidor a la zona.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'No se pudieron aplicar los cambios de la plantilla DNS a la zona porque la zona está servida por otro servidor DNS.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Aplicar cambios de plantilla DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Los cambios de la plantilla DNS se han aplicado correctamente a la zona.',
    'dns__dns_zone_sync_form' => 'Aplicar cambios de plantilla DNS',
    'dns__dns_zone_sync_legend' => 'Opciones',
    'dns__dns_zone_sync_ways' => 'Seleccione una de las siguientes opciones',
    'dns__dns_zone_sync_way_safe' => 'Aplicar los cambios a las zonas sin modificar. Si una zona fue personalizada (se añadieron registros nuevos o se modificó algún registro existente), Plesk no aplicará los cambios de la plantilla a dichas zonas.',
    'dns__dns_zone_sync_way_forced' => 'Aplicar los cambios a todas las zonas. Plesk aplicará los cambios de la plantilla a todas las zonas DNS, incluyendo las personalizadas. Tenga en cuenta que los registros modificados por los usuarios siempre permanecerán intactos. Por ejemplo, si la plantilla contiene un registro nuevo que ya había sido añadido por un cliente, Plesk conservará el registro del cliente.',
    'dns__dns_default_ipv4_modified' => 'Los registros con esta dirección IP se considerarán como modificados por el usuario y no se sincronizarán con la plantilla DNS a nivel del servidor.',
    'dns__dns_default_ipv6_modified' => 'Los registros con esta dirección IP se considerarán como modificados por el usuario y no se sincronizarán con la plantilla DNS a nivel del servidor.',

    'dns__view_dns_record_master_title' => 'Visualización de registros de recurso',
    'dns__view_dns_record_off_title' => 'Visualización de registros de servidor de nombres',
    'dns__view_dns_record_slave_title' => 'Visualización de registros de servidor DNS principal',

    'dns_unable_to_resolve_hostname' => "No se ha podido resolver el nombre de host \"%1\": %2\nVerifique que la resolución DNS del sistema operativo está configurada y funciona correctamente.",

    'no_database_server_available' => 'No existe ningún servidor de base de datos disponible para esta suscripción.',

    'database_server_edit_form__admin_add_hint' => "Especifique las credenciales del administrador de la base de datos que Plesk usará para acceder al servidor de bases de datos. En el servidor de bases de datos ya debe existir una cuenta de administrador con estas credenciales.",
    'database_server_edit_form__admin_edit_hint' => "Aquí puede cambiar las credenciales que Plesk utiliza para acceder al servidor de bases de datos. Estas credenciales deben coincidir con las credenciales del administrador de la base de datos. Por ejemplo, una vez haya cambiado las credenciales del administrador en el servidor de bases de datos, también deberá cambiarlas en Plesk.",
    'database_server_edit_form__admin_change_hint' => 'Aquí puede cambiar las credenciales que Plesk utiliza para acceder al servidor de bases de datos. Si modifica el nombre de usuario y la contraseña aquí abajo, se actualizará la cuenta del usuario de la base de datos con permisos administrativos tanto en el servidor de bases de datos como en Plesk.',
    'database_server_edit_form__version' => 'Versión del servidor de bases de datos',
    'database_used_by_application_can_not_be_moved' => 'No se pudo mover la base de datos porque esta es usada por una aplicación del sitio web.',
    'database_server_database_list__subscription' => 'Suscripción',
    'database_server_database_list__webspace' => 'Suscripción',
    'bt_assign_subscription_selected' => 'Mover a la suscripción',
    'bt_cp_login' => 'Abrir en el panel del cliente',
    'bt_cp_login_classic_mode' => 'Administrar hosting',
    'hint_cp_login' => 'Administre la base de datos en el panel del cliente del suscriptor.',
    'hint_cp_admin_login' => 'Administre la base de datos.',
    'hint_cp_login_classic_mode' => 'Administre la base de datos.',
    'database_user_update_orphaned_is_restricted' => 'No se permite la actualización de cuentas de usuario huérfanos de la base de datos. En este caso solo puede eliminarlas o repararlas.',

    'database_unable_to_get_max_filesize_default_message' => 'No se pudo determinar el tamaño máximo del archivo de la base de datos: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'No se pudo establecer el tamaño máximo del archivo de la base de datos: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'No se pudo determinar el tamaño máximo del archivo de registro de la base de datos: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'No se pudo establecer el tamaño máximo del archivo de registro de la base de datos: \'%1\'',

    'database_unable_to_get_max_filesize' => 'No se pudo determinar el límite actual del tamaño del archivo de la base de datos Microsoft SQL \'%1\'. No es posible establecer un límite nuevo.',
    'database_unable_to_set_max_filesize' => 'No se pudo establecer el límite de tamaño del archivo de la base de datos Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'No se pudo determinar el límite actual del tamaño del archivo de registro de la base de datos Microsoft SQL \'%1\'. No es posible establecer un límite nuevo.',
    'database_unable_to_set_max_log_filesize' => 'No se pudo establecer el límite de tamaño del archivo de registro de la base de datos Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'No se pudo crear la base de datos Microsoft SQL \'%1\'. El tamaño de su archivo es superior al tamaño máximo permitido.',
    'database_unable_to_move_because_max_filesize' => 'No se pudo mover la base de datos Microsoft SQL \'%1\'. El tamaño de su archivo es superior al tamaño máximo permitido: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'No se pudo crear la base de datos Microsoft SQL \'%1\'. El tamaño de su archivo de registro es superior al tamaño máximo permitido.',
    'database_unable_to_move_because_max_log_filesize' => 'No se pudo mover la base de datos Microsoft SQL \'%1\'. El tamaño de su archivo de registro es superior al tamaño máximo permitido: %2.',
    'database_unable_to_restore_because_max_filesize' => 'No se pudo restaurar la base de datos Microsoft SQL \'%1\'. El tamaño de su archivo es superior al tamaño máximo permitido.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'En Plesk ya se ha registrado un MS SQL Server idéntico. Especifique otro MS SQL Server como entorno de pruebas.',
    'database_server__mssql_server_registered_as_sandbox' => 'En Plesk ya se ha registrado un entorno de pruebas MS SQL Server idéntico. Especifique otro MS SQL Server como entorno de pruebas.',

    'database_server_mysql_unable_to_connect_via_cli' => 'No fue posible conectarse al servidor mediante \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'La prestación %1 no es soportada por los siguientes nodos de servicio: %2. Esta prestación será deshabilitada para todos los objetos creados en estos nodos.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'La prestación %1 no es soportada por este servidor. Esta prestación será deshabilitada para todos los objetos restaurados.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'El componente %1 no está instalado. Este no estará disponible para los siguientes sitios web: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'El componente %1 no está instalado. Este será reemplazado por %2 para los siguientes sitios web: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'La versión actual de Plesk no soporta el uso de nombres de usuario que incluyan puntos (.). No se restaurarán los clientes y revendedores que presenten este tipo de nombres de usuario.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'No se pudo encontrar ningún archivo de backup con los datos para el %1 %2. Los datos para el %1 %2 no serán restaurados.',

    'bu_conflict_resolver_zone_master_removed' => "No se pudo restaurar el registro DNS principal: el registro en la zona secundaria apunta a la dirección IP existente %1. El registro DNS principal se eliminará de la zona secundaria.",

    'bu_conflict_resolver_not_available_scripting' => 'No existe soporte para %1.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => 'No existe soporte para %1. Este no estará disponible para los siguientes sitios web: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'El componente %1 no está instalado.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Este no estará disponible para los siguientes nodos de servicio: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Este no estará disponible para los siguientes objetos: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Los siguientes servidores de bases de datos no están disponibles en este servidor: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'El archivo de backup de la base de datos MS SQL se guarda en el formato nativo de MS SQL, que solo puede restaurarse en el servidor MS SQL local o bien en un servidor MS SQL remoto que tenga configuradas todas las opciones de backup. Algunas de sus bases de datos no se restauraron porque en Plesk no se ha registrado ningún servidor MS SQL apropiado. Los dominios que se vieron afectados son los siguientes: {{objects}}. Póngase en contacto con su proveedor de hosting.',

    'bu_conflict_resolver_not_available_webmail' => 'El servicio de webmail %1 no está disponible. Este será reemplazado por %2 para los siguientes objetos: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'El servicio de webmail %1 no está disponible. Este será reemplazado por %2 para los siguientes planes de servicio: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Las bases de datos de tipo '%1' no soportan nombres de usuario que coincidan con nombres de bases de datos. El nombre del usuario '%2' se cambiará a '%3' para la base de datos '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'En la configuración del servidor de destino no se ha definido el límite para el uso del espacio en disco. El valor de esta opción se cambiará a "Ilimitado".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'En la configuración del servidor de destino no se ha definido el límite para el número de conexiones. El valor de esta opción se cambiará a "Ilimitado".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'En la configuración del servidor de destino no se ha definido el límite para el uso de tráfico. El valor de esta opción se cambiará a "Ilimitado".',
    'cu__pleskrestore_backup_file_extracted' => 'El archivo de backup se ha extraído a "%1".',
    '__mod_bw_not_supported' => 'El módulo mod_bw para el servidor web Apache no es soportado debido a la configuración del sistema de archivos. Los límites de uso de tráfico y el número máximo de conexiones no funcionarán.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'No se soporta la autorización POP3 para la retransmisión de correo. En su lugar, se usará la autorización SMTP antes de POP3. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Plan de servicio \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => 'No existe soporte para %1. Este será reemplazado por %2 para los siguientes planes de servicio: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => 'No existe soporte para %1. Este será reemplazado por %2 para los siguientes sitios web: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'En el archivo de backup no se encontraron los siguientes objetos: %1',
    'bu_conflict_resolver_absent_domains' => 'Algunos objetos no pueden restaurarse porque pertenecen a los dominios detallados a continuación, que no han sido encontrados en Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Algunos sitios web no pueden restaurarse porque pertenecen a los dominios principales detallados a continuación, que no han sido encontrados en Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'No se pudieron restaurar las zonas DNS: el servicio DNS está desactivado en la configuración del servidor.',
    'bu_conflict_resolver_mail_not_supported' => 'No se pudieron restaurar los buzones de correo: el servicio de correo está desactivado en la configuración del servidor.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'El tiempo de inactividad especificado no es soportado por el servidor web IIS. El valor se restablecerá a %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'La acción especificada de límite de CPU no es soportada por el servidor web IIS. El valor se restablecerá a %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Certificado SSL/TLS %1 del servidor',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certificado SSL/TLS %2 del dominio %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certificado SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'El contenido de los siguientes objetos no puede restaurarse porque en Plesk no se han encontrado dichos objetos: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'El contenido de los siguientes buzones de correo no puede restaurarse porque en Plesk no se han encontrado dichos buzones: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'El contenido de las siguientes listas de correo no puede restaurarse porque en Plesk no se han encontrado dichas listas: %1',
    'bu_conflict_resolver_absent_objects_database' => 'El contenido de las siguientes bases de datos no puede restaurarse porque en Plesk no se han encontrado dichas bases de datos: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Se ha producido un error al restaurar la aplicación "%1" en "%2" debido a que ya existe otra aplicación instalada en "%3". Puede eliminar la aplicación instalada y volver a intentarlo.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'No se soporta la función de respuestas automáticas de correo.',
    'bu_conflict_resolver_not_available_mail_content' => 'No se soporta la restauración del contenido de correo.',
    'bu_conflict_resolver_invalid_mail_name' => 'Los siguientes buzones de correo no han sido restaurados porque el subdireccionamiento de email está activado y algunas direcciones de email contienen el signo "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Los siguientes usuarios no han sido restaurados porque el subdireccionamiento de email está activado y algunas direcciones de email contienen el signo "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Las siguientes licencias han expirado y no serán restauradas: {{objects}}',
    'expiration_unsupported' => "No se soporta el límite 'expiración'.",

    'component_name__dbconnector' => "Conector de bases de datos",
    'component_name__mysqlserver' => 'MySQL Server',
    'component_name__troubleshooting' => 'Resolución de problemas',

    '__subscription_has_no_license_key' => 'Los recursos de la suscripción son proporcionados por el nodo de servicio #%1, que no tiene asociada ninguna llave de licencia.',
    '__subscription_has_expired_license_key' => 'Los recursos de la suscripción son proporcionados por el nodo de servicio #%1, cuya llave de licencia %2 ha expirado.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> No se han podido guardar los archivos de configuración',
    '__cfgmonConfigurationFileSaveErrorBody' => "No se han podido guardar algunos archivos de configuración en el host <%%host%%>: se han producido los siguientes errores: \n\n%%errors%%",

    'mail__allow_short_pop3_names' => "Nombres para cuentas de correo POP3/IMAP",
    'mail__allow_short_pop3_names_disabled' => "Solo se permite el uso de nombres completos de cuentas de correo POP3/IMAP",
    'mail__allow_short_pop3_names_enabled' => "Pueden usarse nombres cortos (webmaster) y completos (webmaster@domain.com) de cuentas de correo POP3/IMAP.",
    'mail__baddomain_exists' => "Este dominio ya está presente en la lista negra.",
    'mail__block_mail_from_doms' => "Lista negra",
    'mail__blockers' => "Dominios bloqueados",
    'mail__blockers_remove' => "Eliminar dominios bloqueados",
    'mail__blocker_add' => "Añadir dominios a la lista negra",
    'mail__closed' => "cerrado",
    'mail__crypted_passwd_match' => "Existen cuentas de correo que coinciden con las contraseñas cifradas.",
    'mail__enable_email_subaddressing' => 'Activar subdireccionamiento de email',
    'mail__enable_email_subaddressing_hint' => 'Esta opción permite configurar direcciones de email %%verpStyleLink%% para listas de correo',
    'mail__enable_email_subaddressing_cli_desc' => 'Esta opción permite configurar direcciones de email de estilo VERP para listas de correo',
    'mail__dom_in_list' => "Este dominio ya está presente en la lista negra.",
    'mail__enable_rbl' => "Activar protección antispam basada en listas negras del DNS",
    'mail__enter_rbl_server' => "Introduzca la zona DNS.",
    'mail__enter_right_ip_mask' => "Introduzca una máscara IP entre 1 y 32",
    'mail__enter_right_ip_mask_24' => "Introduzca una máscara IP entre 24 y 32",
    'mail__install_rblsmtpd_program' => "Instale el software rblsmtp.",
    'mail__invalid_dom_name' => "El nombre de dominio %1 no es válido.",
    'mail__invalid_pop_lock_time' => "El tiempo de bloqueo POP3 no es válido.",
    'mail__invalid_rbl_server' => "El nombre de la zona DNS no válido.",
    'mail__ip_and_mask' => "Máscara/dirección IP",
    'mail__ip_and_mask_exists' => "Este par dirección IP/máscara de red ya existe.",
    'mail__lock_time' => "tiempo de bloqueo",
    'mail__general_options' => 'Opciones generales',
    'mail__relay_options' => 'Opciones de retransmisión',
    'mail__mailnames_passwd_match' => "Hay coincidencias de cuentas de correo y contraseñas.",
    'mail__select_domains_for_remove' => "Seleccione los dominios a eliminar.",
    'mail__max_size' => "Tamaño máximo del mensaje",
    'mail__mbox_quota' => "Cuota de buzón",
    'mail__min' => "min",
    'mail__total_files_size' => "Tamaño total del repositorio: %1",
    'mail__filename_already_in_repository' => "En el repositorio ya existe un archivo con este nombre",
    'mail__no_white_list_mask_feature_24' => "Use un valor de máscara de 24 o superior.\nSu servidor de correo no soporta la configuración de máscaras. Nosotros solo podemos emularla para valores superiores a 24.",
    'mail__open' => "abierto",
    'mail__open_relay_warning' => "Abrir su transmisión de correo expone su servidor de correo a la recepción de spam.\n\nConserve la configuración únicamente si desea probar el servidor de correo de forma temporal o si su servidor Plesk se encuentra en una red interna a la que no es posible acceder a través de Internet.\n\n¿Desea conservarla?",
    'mail__pop3' => "POP3 antes que SMTP",
    'mail__rbl_zones' => "Zonas DNS para el servicio DNSBL",
    'mail__rbl_zones_hint' => "Separe las entradas con un punto y coma, por ejemplo: 'zen.spamhaus.org;dnsbl.example.net'",
    'mail__relay_from_ip' => "Lista blanca",
    'mail__relaying' => "En retransmisión",
    'mail__reqr_auth' => "autorización obligatoria:",
    'mail__smtp' => "SMTP",
    'mail__unable_add_new_mail_name' => "No se pudo añadir la cuenta de correo: %1",
    'mail_server_is_not_installed' => 'El servidor de correo (Potsfix o Qmail) no está instalado. Instálelo para seguir estando operativo.',
    'mail_server_not_available' => 'No hay servidores de correo soportados disponibles en el nodo de servicio.',
    '__not_installed' => '(no instalado)',
    'mail__server_name_label' => 'Servidor de correo instalado',
    'mail__imap_server_name_label' => 'Servidor POP3/IMAP instalado',
    'mail__server_change_hint' => 'Puede %%serverChangeLink%%',
    'mail__server_change_link' => 'instalar y usar otro servidor de correo',
    'mail__imap_server_change_link' => 'instalar y usar otro servidor IMAP/POP3',
    'mail__message_submission' => 'Activar el servicio SMTP en el puerto 587',
    'mail__message_submission_on_all_ips' => 'Activar el servicio SMTP en el puerto 587 en todas las direcciones IP',
    'mail__message_submission_bind_to' => 'Activado',
    'mail__message_submission_all_ip_addresses' => 'todas las direcciones IP',
    'mail__service_node_outgoing_messages_is_disabled' => 'La filtración antispam para los correos salientes está desactivada.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'El nodo de servicio no soporta la limitación del número de correos salientes desde un dominio para el dominio %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'El nodo de servicio no soporta la limitación del número de correos salientes desde un buzón de correo para el dominio %1.',
    'mail__max_outgoing_messages_enable_text' => 'Activar limitaciones de correos salientes',
    'mail__max_outgoing_messages_enable_hint' => 'Estos son los límites predeterminados. Estos pueden sobrescribirse en cada suscripción y plan de servicio. Los límites no funcionan a nivel del servidor, pero actúan como plantilla para aquellos planes y suscripciones para los que no se ha especificado ningún límite personalizado. Tenga en cuenta que la activación de la limitación de los correos salientes puede afectar al rendimiento del servidor de correo.',
    'mail__outgoing_messages_mbox_limit_text' => 'Límite predeterminado de correos salientes desde un buzón de correo (por hora)',
    'mail__outgoing_messages_domain_limit_text' => 'Límite predeterminado de correos salientes desde un dominio (por hora)',
    'mail__outgoing_messages_subscription_limit_text' => 'Límite predeterminado de correos salientes desde una suscripción (por hora)',
    'mail__outgoing_messages_enable_sendmail_text' => 'Permitir a los scripts y usuarios utilizar Sendmail',
    'mail__outgoing_messages_enable_sendmail_hint' => 'Los scripts y usuarios podrán enviar correos (en nombre del usuario de sistema de la suscripción) usando Sendmail incluso si se han excedido los límites de un buzón de correo y un dominio. El número máximo de mensajes que puede enviarse mediante Sendmail se definirá por el límite para toda una suscripción. Esta opción no permite a los scripts hacer uso de Sendmail a nivel del servidor, si bien actúa como opción predeterminada para los planes de servicio y las suscripciones.',
    'mail__outgoing_messages_report_period_text' => 'Mostrar informes basándose en las estadísticas de las últimas',
    'mail__max_outgoing_messages_period_P1D' => '1 día',
    'mail__max_outgoing_messages_period_P1W' => '1 semana',
    'mail__max_outgoing_messages_period_P2W' => '2 semanas',
    'mail__max_outgoing_messages_period_P1M' => '1 mes',
    'mail__outgoing_messages_report_period_hint' => 'Se crean los informes y en la página principal se muestra una alerta acerca de los intentos de exceder los límites de correo saliente durante el periodo especificado.',
    'mail__outgoing_messages_notification_period_text' => 'Enviar una notificación por email cada',
    'mail__max_outgoing_messages_period_PT15M' => '15 minutos',
    'mail__max_outgoing_messages_period_PT1H' => '1 hora',
    'mail__max_outgoing_messages_period_PT6H' => '6 horas',
    'mail__max_outgoing_messages_period_PT12H' => '12 horas',
    'mail__outgoing_messages_notification_period_hint' => 'Las notificaciones proporcionan estadísticas acerca de los intentos de exceder los límites de correo saliente durante el periodo especificado.',
    'mail__outgoing_count_number_recipients_text' => 'Contar el número de destinatarios en vez de mensajes',
    'mail__outgoing_count_number_recipients_hint' => 'Activa el modo que cuenta el número de destinatarios en vez de los mensajes cuando se limita el correo saliente y el recuento de estadísticas. Por ejemplo, un mensaje enviado a 10 destinatarios se contabilizará como diez mensajes.',

    'mail__outgoing_email_mode_explicit_ip_none' => 'Ninguna',
    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Especifique una dirección de al menos un tipo (IPv4 o IPv6).',

    'mail__max_connections_text_courier' => 'Número máximo de conexiones (IMAP, POP3, IMAP a través de SSL/TLS o POP3 a través de SSL/TLS).',
    'mail__max_connections_text_dovecot' => 'Número máximo de conexiones (IMAP, POP3, IMAP a través de SSL/TLS o POP3 a través de SSL/TLS).',
    'mail__max_connections_hint_courier' => 'El número máximo de servidores (IMAP o POP3) iniciados.',
    'mail__max_connections_hint_dovecot' => 'El número máximo de usuarios de correo que pueden iniciar sesión de forma simultánea.',

    'mail__max_connections_per_ip_text_courier' => 'Número máximo de conexiones por dirección IP',
    'mail__max_connections_per_ip_text_dovecot' => 'Número máximo de conexiones para un usuario por dirección IP',
    'mail__max_connections_per_ip_hint_courier' => 'El número máximo de conexiones (IMAP, POP3, IMAP mediante SSL/TLS o POP3 mediante SSL/TLS) a aceptar desde la misma dirección IP.',
    'mail__max_connections_per_ip_hint_dovecot' => 'El número máximo de conexiones (IMAP, POP3, IMAP mediante SSL/TLS o POP3 mediante SSL/TLS) que puede establecer un usuario de correo desde cada dirección IP.',

    'mail__outgoing_email_mode' => 'Modo de envío del correo saliente',
    'mail__outgoing_email_mode_domain_ip' => 'Enviar desde las direcciones IP del dominio',
    'mail__outgoing_email_mode_domain_name' => 'Enviar desde las direcciones IP del dominio y usar los nombres de dominio en el saludo SMTP',
    'mail__outgoing_email_mode_explicit_ip' => 'Enviar desde las direcciones IP especificadas',
    'mail__outgoing_email_mode_explicit_ip_v4' => 'IPv4',
    'mail__outgoing_email_mode_explicit_ip_v6' => 'IPv6',
    'mail__outgoing_email_mode_invalid' => 'Se ha indicado un modo de envío del correo saliente que no es válido.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Se ha indicado una dirección IPv4 que no es válida.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Se ha indicado una dirección IPv6 que no es válida.',
    'mail__outgoing_email_mode_unavailable' => 'No se soporta el cambio del modo de correo saliente, probablemente porque en este servidor no se ha instalado el servidor de correo Postfix.',

    'mail__smtp_settings_change_hint' => 'Para que Plesk pueda enviar notificaciones cuando la retransmisión esté cerrada, puede %%changeLink%%',
    'mail__smtp_settings_change_link' => 'cambiar la configuración SMTP',

    'mail__autoresponder_attachment_not_supported' => 'El servidor de correo usado en este momento no soporta la gestión de adjuntos de respuesta automática.',

    'mail__autoresponder_headers' => 'Encabezados de respuesta automática adicionales',
    'mail__autoresponder_headers_hint' => 'Configure encabezados adicionales para cualquier mensaje de respuesta automática procedente del servidor Plesk.',
    'mail__autoresponder_headers_label' => 'Encabezados adicionales',

    'mail__smtp_white_list_not_supported' => 'El servidor de correo usado en este momento no soporta la inclusión de direcciones IP en la lista blanca.',
    'mail__smtp_whitelist_cidr_not_supported' => 'El servidor de correo seleccionado en este momento no soporta máscaras CIDR. Indique la dirección IP en formato \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'El servidor de correo seleccionado en este momento no soporta patrones de IP wildcard. Indique la dirección IP en formato \'192.0.0.0/8\'.',

    'sfdk_server_wide_legend' => 'Protección antispam DKIM',
    'sfdk_server_wide_sign_text' => 'Permitir la firma del correo saliente',
    'sfdk_server_wide_verify_text' => 'Comprobar correo entrante',
    'sfdk_server_wide_verify_failed' => 'No se puede cambiar la configuración para el servicio de verificación DKIM',

    'sfdk_domain__serverwide_disabled' => 'Desactivado de acuerdo con la directiva del servidor',
    'feature__domainkeys__serverwide_disabled' => 'La protección antispam DKIM a nivel de servidor está desactivada',

    'defaultcomponents__error_set_default' => 'No se puede establecer %1 como %2 predeterminado',
    'defaultcomponents__required_package_not_default' => 'El componente %1 necesario para el trabajo no está predeterminado.',

    '__percentage' => '%',
    '__seconds' => 'Segundos',
    '__resource_remain' => 'Pendiente',

    '__not_registered' => '(no está registrado)',
    '__php_handler_id' => 'Versión de PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'El controlador PHP "%1" no está registrado. Probablemente haya sido eliminado del servidor. Registre un controlador con las mismas propiedades e inténtelo de nuevo.',
    '__php_handler_not_registered_on_domain' => 'Dominio "%1": el controlador PHP "%2" no está registrado. Probablemente haya sido eliminado del servidor. Registre un controlador con las mismas propiedades e inténtelo de nuevo.',
    '__php_fpm_handler' => 'Aplicación FPM',
    '__php_fpm-dedicated_handler' => 'Aplicación FPM dedicada',

    'mailname_create_assigned_user_dublicate_error' => 'No se ha podido crear un usuario para el buzón. El usuario con nombre %1 ya existe y tiene otro buzón.',
    'mailname_create_assigned_user_role_absent_error' => 'No se ha podido crear un usuario para el buzón. El rol predeterminado %1 del usuario no existe.',

    'gphd__mime_types' => 'Tipos MIME',
    'gphd__handlers' => 'Controladores de Apache',
    'gphd__ip_restrictions_allow' => 'Permitir el acceso al sitio a las redes y hosts especificados (excluyendo los denegados)',
    'gphd__ip_restrictions_deny' => 'Denegar el acceso al sitio a las redes y hosts especificados',
    'gphd__directory_index' => 'Archivos de índice',
    'gphd__nginx_transparent_mode' => 'El modo cuando Apache gestiona contenido dinámico y estático. Tenga en cuenta que nginx solo transfiere peticiones y respuestas HTTP sin ningún tipo de modificación.',
    'gphd__nginx_serve_static' => 'Servir archivos estáticos directamente mediante nginx',
    'gphd__nginx_static_extensions' => 'Las extensiones de los archivos estáticos que deben gestionarse mediante nginx',
    'gphd__nginx_serve_php' => 'Procesar archivos PHP mediante nginx',
    'gphd__www_root' => 'Directorio raíz WWW',

    'eol__none' => 'no modificar',
    'eol__lf' => 'convertir a estilo Unix',
    'eol__cr' => 'convertir a estilo MacOS',
    'eol__crlf' => 'convertir a estilo Windows',

    'ui__dns_bad_zone' => 'Zona incoherente "%1":',
    'ui__dns_ns_has_no_address_records' => 'El registro NS "%1" no dispone de ningún registro de dirección (A o AAAA).',
    '__dns_bad_zone' => 'Zona incoherente "%1":',
    '__dns_ns_has_no_address_records' => 'El registro NS "%1" no dispone de ningún registro de dirección (A o AAAA).',
    '__dns_ptr_is_wildcard' => 'El registro PTR "%1" no es válido − Este apunta a un dominio wildcard.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Permitir el acceso remoto para el usuario de la base de datos \'%3\' del cliente \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'No se pudieron permitir conexiones remotas para el usuario de la base de datos \'%1\': no se pudo determinar el número de puerto TCP usado por el servidor Microsoft SQL \'%2\'. Esto puede deberse a que: el protocolo TCP/IP no está habilitado en la configuración de red del servidor o bien el servidor se ha configurado para utilizar puertos TCP dinámicos. Configure el servidor para que escuche en un puerto TCP fijo determinado e intente permitir de nuevo las conexiones remotas.',

    'command__convertResellerHasCustomer' => 'La cuenta de revendedor \'%1\' tiene una o varias cuentas de cliente. Para convertir esta cuenta de revendedor en una cuenta de cliente, primero transfiera estas cuentas de cliente a un propietario nuevo o bien conviértalas a cuentas de revendedor.',
    'command__convertResellerNotReseller' => 'Solo las cuentas de revendedor pueden convertirse en cuentas de cliente. \'%1\' no es un revendedor.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'La cuenta \'%1\' es una cuenta de revendedor. Las cuentas de revendedor no pueden transferirse a un propietario nuevo, ya que son propiedad del administrador del servidor.',
    'moveCustomer__wrong_owner_type' => "La cuenta de cliente '%1' solo puede transferirse a una cuenta de revendedor o de administrador, no pudiéndose transferir a otro cliente.",
    'moveCustomer__customer_already_belongs_to_owner' => 'La cuenta de cliente \'%1\' ya pertenece al propietario seleccionado.',
    'upgradeClient__user_is_admin' => 'La cuenta \'%1\' no puede convertirse en cuenta de revendedor porque es una cuenta de administrador.',

    'mail__error_setting_max_connections_courier' => 'No se pudo establecer el número máximo de conexiones (IMAP, POP3, IMAP mediante SSL/TLS o POP3 mediante SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'No se pudo establecer el número máximo de conexiones (IMAP, POP3, IMAP mediante SSL/TLS o POP3 mediante SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'No se pudo establecer el número máximo de conexiones (IMAP, POP3, IMAP mediante SSL/TLS o POP3 mediante SSL/TLS) por dirección IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'No se pudo establecer el número máximo de conexiones (IMAP, POP3, IMAP mediante SSL/TLS o POP3 mediante SSL/TLS) por dirección IP para un usuario de correo específico: %1',
    'mail__error_no_localhost_for_maillists_in_server_white_list' => 'Para utilizar listas de correo es necesario que el  localhost (127.0.0.0/8, ::1/128) esté presente en la lista blanca del servidor de correo. De todos modos, para usar el control del correo saliente, este no debería estar en la lista blanca. Como solución, si ha activado el control del correo saliente, puede utilizar el reenvío de correo en el buzón de correo en vez de usar listas de correo.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv4' => 'Para utilizar listas de correo es necesario que localhost esté presente en la lista blanca del servidor de correo. De todos modos, para usar el control del correo saliente, este no debería estar en la lista blanca.Como solución, si ha activado el control del correo saliente, puede utilizar el reenvío de correo en el buzón de correo en vez de usar listas de correo. Dado que actualmente no hay direcciones localhost IPv4 (127.0.0.0/8) en la lista blanca, el control de correo saliente funcionará para las direcciones IPv4.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv6' => 'Para utilizar listas de correo es necesario que localhost esté presente en la lista blanca del servidor de correo. De todos modos, para usar el control del correo saliente, este no debería estar en la lista blanca. Como solución, si ha activado el control del correo saliente, puede utilizar el reenvío de correo en el buzón de correo en vez de usar listas de correo.Dado que actualmente no hay direcciones localhost IPv6 (::1/128) en la lista blanca, el control de correo saliente funcionará para las direcciones IPv6.',
    'mail__outgoing_messages_with_open_relay_error' => 'Para una correcta limitación del número de correos salientes, cierre la retransmisión.',
    'outgoing_messages_limit_value_invalid' => 'El valor debe estar en el rango de %%MIN%%..%%MAX%%. El administrador de Plesk es la única persona que puede ajustar esta opción.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Los dominios detallados a continuación utilizan direcciones de email externas para el reenvío de los correos enviados a direcciones inexistentes. Los mensajes enviados a estas direcciones no se contabilizarán en el control del correo saliente: %1",
    'outgoing_messages_white_list_not_empty' => 'Los límites del correo saliente no funcionarán en el caso de remitentes cuya dirección IP esté presente en la lista blanca del servidor de correo. Por ejemplo, si en la lista blanca existe localhost (127.0.0.0 / 8, ::1 / 128), todos los correos procedentes del servidor local se enviarán correctamente sean cuales sean las limitaciones establecidas. Aquellos que envíen correos pueden utilizar direcciones IP locales (sitios web y scripts personalizados alojados en el servidor local) o direcciones IP externas (clientes que envían correos a través de clientes de correo instalados en sus ordenadores o dispositivos móviles). Para que se apliquen los límites establecidos para todos los remitentes de correo (tanto locales como externos), elimine todas las direcciones IP y redes de la lista blanca. Tenga en cuenta que la eliminación de localhost (127.0.0.0 / 8, ::1 / 128) de la lista blanca puede ocasionar una interrupción de los sitios web y scripts que envían correos desde este servidor. Si desea más información acerca de las limitaciones del correo saliente, consulte la sección Protección frente a spam saliente de la guía del administrador.',
    'outgoing_messages_relay_open' => 'La retransmisión de correo está abierta. No se aplicarán los límites de correo saliente.',

    'spf_dsnignore' => 'La comprobación SPF sigue en curso aunque se experimenten problemas al realizar la búsqueda en el DNS',
    'spf_dnsignore_hint' => 'En primer lugar, SPF realiza una búsqueda en el DNS. Seleccione esta opción para seguir realizando la comprobación si esta búsqueda resulta fallida. Esta opción está deseleccionada si esta no tiene ningún efecto en el modo de comprobación actual.',
    'spf_behavior_hint' => 'En este caso, SPF aplica reglas locales y de conjetura. El mensaje puede rechazarse en función del modo de comprobación seleccionado y del resultado de dicha comprobación.',

    'notification_aps_app_updates_available' => 'Existen actualizaciones para las siguientes aplicaciones:',
    'notification_aps_app_updates_installed' => 'Se han instalado actualizaciones de forma automática para las siguientes aplicaciones:',
    'notification_aps_app_updates_requirements' => 'Existen actualizaciones para las aplicaciones detalladas a continuación pero estas no pueden instalarse porque la configuración de hosting de los sitios web correspondientes no cumple los requisitos de instalación:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Versión instalada: %%from%%. Versión disponible: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" en %%parentName%% (%%url%%). Versión instalada: %%from%%. Versión disponible: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" en %%parentName%% (%%url%%). Versión instalada: %%from%%. Versión disponible: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Versión instalada: %%from%%. Versión disponible: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" en %%parentName%% (%%url%%). Versión instalada: %%from%%. Versión disponible: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" en %%parentName%% (%%url%%). Versión instalada: %%from%%. Versión disponible: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Su versión: %%from%%. Versión disponible: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" en %%parentName%% (%%url%%). Su versión: %%from%%. Versión disponible: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" en %%parentName%% (%%url%%). Su versión: %%from%%. Versión disponible: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versión nueva: %%to%%. Versión anterior: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versión nueva: %%to%%. Versión anterior: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versión nueva: %%to%%. Versión anterior: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versión instalada: %%from%%. Versión disponible: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versión instalada: %%from%%. Versión disponible: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Su versión: %%from%%. Versión disponible: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'app externa',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Dominios',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Direcciones de email',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Suscripciones',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 mensajes por hora',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Ilimitado',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, el límite es %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 intento(s) de exceder los límites de %2 a %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 intento(s) de exceder los límites desde %2 hasta ahora',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Prohibición de direcciones IP (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'El componente Fail2ban no está instalado en el servidor de destino.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Instale Fail2ban. Tenga en cuenta que esta operación puede tardar unos minutos.',

    'plesk_key__no_reseller_support' => 'No puede administrar revendedores debido a las restricciones de la licencia.',
    'plesk_key__no_customers_support' => 'No puede administrar clientes debido a las restricciones de la licencia.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'No se pudo cambiar al modo de visualización de Proveedor de servicios debido a las restricciones de la licencia.',
    'plesk_key__no_security_core_support' => 'Las principales prestaciones de seguridad (ModSecurity y Fail2Ban) no están disponibles debido a las restricciones de la licencia.',
    'plesk_key__outgoing-antispam' => 'Control del correo saliente',
    'plesk_key__security-core' => 'Principales prestaciones de seguridad (ModSecurity y Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Administración de cuentas',
    'plesk_key__can-manage-subscriptions' => 'Administración de suscripciones',
    'plesk_key__can-manage-customers' => 'Administración de clientes',
    'plesk_key__can-manage-resellers' => 'Administración de revendedores',
    'plesk_key__can-manage-custom-view' => 'Disponibilidad del modo restringido',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'La administración de suscripciones está desactivada pero usted dispone de varias suscripciones (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'La administración de revendedores está desactivada pero usted dispone de varios revendedores (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'La administración de clientes está desactivada pero dispone de varios clientes (%1).',
    'plesk_key__no_subscriptions_support' => 'No puede administrar suscripciones debido a las restricciones de la licencia.',
    'plesk_key__no_custom_view_support' => 'Debido a restricciones de la licencia, no puede usar el modo restringido.',
    'plesk_key__trial_forbidden_region' => 'Lo sentimos, Plesk no está disponible en su región en este momento.',
    'additional_key__main_key' => 'La llave es una llave principal ? Una llave principal no puede cargarse como una llave adicional.',

    'gch__hosting_waf_rule_engine' => 'Modo de firewall para aplicaciones web',

    'backup__fieldset__restoration_options' => 'Opciones de restauración',
    'backup__restore_options__restore' => 'Restaurar',
    'backup__restore_options__domain__domain_configuration' => 'Configuración de dominio',
    'backup__restore_options__domain__virtual_host_content' => 'Contenido del host virtual',
    'backup__restore_options__domain__mail' => 'Correo',
    'backup__restore_options__domain__databases' => 'Bases de datos',
    'backup__restore_options__client__client_configuration' => 'Configuración de cuenta de cliente',
    'backup__restore_options__client__domains' => "Dominios del cliente",
    'backup__restore_options__reseller__reseller_configuration' => 'Configuración de cuenta de revendedor',
    'backup__restore_options__reseller__personal_domains' => "Dominios del revendedor",
    'backup__restore_options__reseller__clients' => "Clientes del revendedor",
    'backup__restore_options__admin__server_configuration' => 'Configuración del servidor',
    'backup__restore_options__admin__administrator_configuration' => 'Configuración de la cuenta de administrador',
    'backup__restore_options__admin__personal_domains' => "Dominios del administrador",
    'backup__restore_options__admin__personal_clients' => "Clientes del administrador",
    'backup__restore_options__admin__resellers' => 'Revendedores',

    'badge_new' => 'Nuevo',
    'upgrade_php_on_subscription' => 'Actualice PHP en su suscripción a la versión 5.3.0 o a una versión posterior.',

    'pkey_notify__body_expiration_notification' => 'La llave de licencia ha expirado, por lo que es posible que algunas prestaciones no estén disponibles. Rogamos se ponga en contacto con su proveedor de hosting.',

    'crontab__crontab_entry_exists' => "La tarea programada ya existe.",
    'crontab__crontab_entry_not_exists' => "La tarea programada no existe.",
    'crontab__invalid_values_found' => "Valores de parámetro incorrectos.",
    'crontab__cmd_max_len' => "El comando no puede tener más de %1 caracteres.",

    'domain__domain_exists' => "Existe un dominio con el prefijo 'www' y el mismo nombre: %1.%2.",
    'domain__subdomain_exists' => "Existe un subdominio con el prefijo 'www' y el mismo nombre: %1.%2.",
    'domain__dalias_exists' => "Existe un alias de dominio con el prefijo 'www' y el mismo nombre: %1.%2.",
    'domain__record_exists' => "Existe un registro DNS que apunta al host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "No es posible establecer el certificado '%1' como certificado predeterminado porque no se ha encontrado la clave privada.",
    'ip_addr__update_dns_error' => 'Se experimentaron problemas mientras se actualizaba la dirección IP en las zonas DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'No es posible añadir la dirección IP. Este interfaz de red obtiene direcciones IP de forma automática.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'No se puede eliminar la dirección IP %1. Este interfaz de red obtiene direcciones IP de forma automática.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'No se puede reparar la dirección IP %1. Este interfaz de red obtiene direcciones IP de forma automática.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'No se puede cambiar el interfaz de la dirección IP %1 porque el interfaz de red %2 obtiene direcciones IP de forma automática.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Se ha superado el límite de %%type%% de la suscripción. El límite establecido es de %%limit%%, mientras que en este momento el uso actual es de %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'No se permite la creación de %%type%% para esta suscripción.',
    'shm_lmsg__resource_title__db-mysql' => 'Bases de datos MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Bases de datos MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Bases de datos PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'usuarios de base de datos',
    'shm_lmsg__resource_title__iis-application-pool' => 'Grupos de aplicaciones IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'cuentas FTP adicionales',

    'db_user_unable_remove_mysql_global_privileges' => 'No se han podido eliminar los privilegios globales de MySQL del usuario de la base de datos %1. Motivo: %2',
    'report__client_description' => 'Descripción',

    'db__user_role_error' => 'Se ha especificado un rol de usuario de la base de datos que no es correcto: %1. Seleccione uno de los siguientes roles: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'No se ha podido establecer el límite de tamaño de archivo de las siguientes bases de datos de Microsoft SQL Server porque su tamaño de archivo es mayor: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'No se ha podido establecer el límite de tamaño de archivo de registro de las siguientes bases de datos de Microsoft SQL Server porque su tamaño de archivo de registro es mayor: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'No es posible configurar una dirección IP pública: debe haber una dirección IP privada.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'No es posible configurar una dirección IPv4 pública para la dirección IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'No es posible configurar una dirección IPv6 pública para la dirección IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'No pudo configurarse una dirección IP pública: la dirección IP no es válida.',

    '__user_already_exists' => "El usuario %1 ya existe.",
    '__user_name_is_empty' => "Especifique un nombre de usuario.",

    'upgrade_php_on_domain' => 'No se ha podido encontrar la versión 5.3.0 o posterior de PHP en ninguno de sus dominios de WordPress. Pruebe a actualizar PHP.',

    'component_name__waf' => 'Firewall para aplicaciones web',
    'component_name__vcs' => 'Sistema de control de versiones',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Se ha detectado un posible intento de falsificación: el enlace ha intentado mostrar contenido irrelevante.',

    'php_handlers_error_no_available_instance' => 'No se pudo crear un dominio porque no hay ningún controlador PHP disponible.',
    'domain_error_unable_to_apply_hosting_settings' => 'No se pudo aplicar la configuración de hosting: %1',

    'plesk_not_configured' => 'Plesk no está configurado. Rogamos vaya al panel de control para proceder con la configuración posterior a la instalación.',
    'cmd_mail__mail_password_duplicated' => 'El par de dirección de email y contraseña especificado ya existe en el servidor de correo. Indique otra dirección de email o contraseña.',

    'extensionRequirementOs' => 'El paquete no ofrece soporte para el sistema operativo (%1).',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 es la versión más antigua para la que el paquete ofrece soporte.',
    'extensionRequirementPleskMaxVersion' => 'El paquete no ofrece soporte para las versiones a partir de Plesk %1.',
    'extensionBlacklisted' => 'No se permite instalar la extensión %1.',
    'extensionDisabled' => 'La extensión está desactivada.',


    'optimization_settings__unable_set_mpm_event' => 'No se ha podido establecer el modo mpm_event: requiere que el módulo PHP5 e Apache esté desactivado, pero hay dominios que utilizan dicho módulo.',
    'optimization_settings__unable_turn_off_php' => 'No se ha podido desactivar el módulo PHP5 de Apache: está siendo usado por algunos dominios.',

    'hst_def__fp_admin_login' =>  'Nombre de usuario FTP',
    'hst_def__fp_admin_passwd' =>  'Contraseña FTP',

    'database_user_orphaned_old_password_wrong' => "No se pudo reparar al usuario huérfano '%1' porque la contraseña no es correcta.",
    'cannot_load_partner_central_property_key_no_exist' => "No se pudieron recuperar las propiedades personalizadas porque la llave de licencia no existe.",
    'extensionScriptFailure' => "La ejecución de %1 ha resultado fallida y se ha obtenido siguiente mensaje:\n%3",
    '__ssl_redirect' => "Redireccionamiento 301 permanente de HTTP a HTTPS preservando SEO",
    'component_name__dotnetcore' => 'Núcleo .NET',
    'mail__dkim_not_supported' => 'No se soporta la gestión de DKIM.',
    'mail__dmarc_not_supported' => 'No se soporta la gestión de DMARC.',
    'mail__relay_white_list_not_supported' => 'No se soporta la gestión de listas blancas de retransmisión.',
    'mail__black_list_not_supported' => 'No se soporta la gestión de listas negras.',
    'mail__autoresponder_not_supported' => 'No se soporta la gestión de respuestas automáticas.',
    'defaultcomponents__not_supported_version' => '(versión no soportada)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'No se ha encontrado el certificado \'%1\'.',
    'certificate__unable_setup_certificate' => 'No se pudo instalar el certificado porque no se encontró el contenido del certificado y la clave privada.',
    'certificate__used_by_panel' => 'Uno de los certificados que va a eliminar se utiliza para proteger Plesk.',
    'certificate__used_by_mail_server' => 'Uno de los certificados que va a eliminar se utiliza para proteger el servidor de correo.',
    'certificate__used_by_domain_service' => 'Uno de los certificados que va a eliminar es usado por el servicio de dominio.',
    'mail_server__not_installed' => 'No se ha podido instalar el certificado para el servidor de correo porque no se ha instalado ningún servidor de correo.',

    'email_activation_mail_subject' => 'Active su cuenta en Plesk',
    'email_activation_mail_body' => "Se ha creado una cuenta en el servidor Plesk %1\n\nDetalles de la cuenta:\nNombre: %2\nDirección de email: %3\n\nSi esta información es correcta y usted ha creado la cuenta, actívela mediante el siguiente enlace:\n\n%4\n\nLa activación de la cuenta implica que usted autoriza al titular del servidor a recopilar, almacenar, procesar y usar sus datos personales (nombre y dirección de email) para crear y soportar su cuenta, de acuerdo con la ley de protección de datos vigente, como parte de un contrato.",

    'backup_transport_permission_name' => 'Gestión de %1',
    'backup_transport_permission_description' => 'Permite usar %1 para almacenar backups.',

    'domain_move_err_target_no_hosting' => 'No ha sido posible mover el dominio a una suscripción sin hosting.',
    'domain_move_err_already_in_target' => 'El dominio ya pertenece a la suscripción de destino.',
    'domain_move_err_main_domain' => 'El dominio principal no puede moverse.',
    'domain_move_err_subdomain_without_parent' => 'No ha sido posible mover el subdominio %1 sin el dominio principal %2.',
    'domain_move_err_root_exists' => 'La ruta de destino para www_root %1 ya existe.',
    'domain_move_err_nested_roots' => 'No ha sido posible mover el dominio porque este comparte la raíz de documentos con otro dominio: %1.',
    'domain_move_err_no_mail_service' => 'No ha sido posible mover el dominio porque el servicio de correo está desactivado en la suscripción de destino.',
    'domain_move_err_app' => "La aplicación instalada en %1 no se movió a la suscripción '%2': %3",
    'domain_move_database_used_by_app' => "La base de datos '%1' en %2 es usada por la aplicación movida. Si desea volver a asignar la base de datos a '%3', ejecute `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "La suscripción de destino '%1' ha sido bloqueada y no se sincronizará.",
    'domain_move_filesharing_disabled' => 'La compartición de archivos ha sido desactivada.',
    'domain_move_website_preview_disabled' => 'La previsualización de sitios web ha sido desactivada.',
    'domain_move_additional_webserver_settings' => "Revise las directivas adicionales del servidor web del dominio para impedir una configuración incorrecta.",
    'domain_move_no_permission' => "%1 no permitido para la suscripción '%2'.",
    'domain_move_no_access' => "Sin acceso a la suscripción '%1'.",
    'domain_split_no_create_permission' => "No se permite la creación de dominios.",
    'domain_split_empty_login' => 'Se precisa el nombre de usuario del usuario del sistema.',
    'domain_split_empty_password' => 'Se precisa la contraseña del usuario del sistema.',
    'domain_split_err_home_exists' => 'El dominio %1 no puede moverse porque su ruta de acceso principal de destino existe en %2. Asigne otro nombre al dominio para así poder moverlo a una suscripción nueva.',
    'domain_split_err_no_hosting_subdomains' => 'El dominio no puede transferirse a una nueva suscripción porque el dominio no dispone de hosting, si bien sí dispone de subdominios. Para transferir el dominio, modifique su valor "Tipo de hosting" a "Hosting de sitios web" (en Configuración de hosting).',
    'domain_split_target_locked' => "La suscripción de destino '%1' está bloqueada y no se sincroniza.",
    'domain_split_target_unsynced' => "La suscripción de destino '%1' no se sincronizó con el plan: %2.",
    'domain_merge_scheduled_backup_deactivated' => "El backup programado se ha desactivado en '%1'.",
    'domain_merge_database_error' => "La base de datos '%1' en %2 no se transfirió a la suscripción '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "El FTP anónimo en '%1' ha sido desactivado.",
    'domain_merge_smb_user_access' => "El usuario adicional '%1' se ha transferido a la suscripción '%2', si bien al usuario se le ha revocado el acceso a la suscripción.",
    'domain_merge_scheduled_tasks' => "Las tareas programadas se han transferido a la suscripción de destino. Revise la configuración de las tareas.",
    'domain_merge_scheduled_tasks_deactivated' => "Las tareas programadas se han transferido a la suscripción de destino y han sido desactivadas. Revise la configuración de las tareas.",
    'domain_merge_no_remove_permission' => "No se permite la eliminación de suscripciones.",
    'domain_merge_err_has_addons' => 'No se puede transferir el dominio principal con sus dominios adicionales. Transfiera primero el/los dominio(s) %1.',
    'domain_merge_err_has_webusers' => 'No es posible transferir el dominio principal con sus usuarios web.',
    'domain_merge_err_root_exists' => 'La ruta de destino %1 ya existe.',

    'database_server_edit_used_for_psa' => 'No se permite la actualización de un servidor de base de datos MySQL local.',
    'suggest_repair_main_suggestion_ui' => '<b>Puede corregir este error</b> con la utilidad `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Puede corregir este error con la utilidad `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'vaya a Diagnosticar y reparar',
    'suggest_repair_using_cli_and_ui' => 'Ejecute el comando `plesk repair %1` mediante el CLI o %2 y haga clic en Reparar al lado de “Base de datos de Plesk”',
    'suggest_repair_using_cli' => 'Ejecute el comando `plesk repair %1` mediante el CLI',
    'verp_style_link' => 'Estilo VERP',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'El servicio DNS no se encontraba disponible cuando se creó el backup. De todos modos, existen zonas DNS activas en el backup y estas se activarán para los siguientes objetos: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Controlador de recursos (cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Soporte de SmarterMail remoto',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(no permitido por la llave de licencia)',
    'plesk_key__validation_failed' => '%1 (Código de error: %2)',
    'promo__button_details' => 'Detalles',
    'promo__extension_catalog_title' => 'Catálogo de extensiones',
    'promo__extension_catalog_description' => '¡Descubra el nuevo catálogo de extensiones y disfrute al máximo de Plesk gracias a una amplia variedad de extensiones!',
    'promo__button_open_catalog' => 'Abrir el catálogo',

    'backup__repository_check_login' => "No ha sido posible acceder al almacenamiento: %1\nCompruebe que ha indicado correctamente las credenciales del almacenamiento.",
    'backup__repository_check_error_list' => "No ha sido posible acceder al almacenamiento: %1\nCompruebe que ha indicado correctamente la configuración del almacenamiento.",
    'backup__repository_check_error_mkdir' => "No ha sido posible crear el directorio: %1\nCompruebe que dispone de permisos para crear carpetas en el almacenamiento.",
    'backup__repository_check_error_upload' => "No ha sido posible cargar el archivo al almacenamiento: %1\nCompruebe que dispone de permisos para cargar archivos al almacenamiento.",
    'backup__repository_check_error_download' => "No ha sido posible descargar el archivo del almacenamiento: %1\nCompruebe si dispone de permisos para cargar y descargar archivos del almacenamiento.",
    'backup__repository_check_error_resume-upload' => "No ha sido posible reanudar una carga del archivo al almacenamiento: %1\nCompruebe si dispone de permisos para reanudar cargas al almacenamiento.",
    'backup__repository_check_error_resume-download' => "No ha sido posible reanudar una descarga del archivo del almacenamiento: %1\nCompruebe si dispone de permisos para reanudar descargas del almacenamiento.",
    'backup__repository_check_error_enable-utf8' => "No ha sido posible operar con el almacenamiento: %1\nCompruebe si este soporta la codificación UTF8.",
    'backup__repository_check_error_rm' => "No ha sido posible operar con el almacenamiento: %1\nCompruebe que dispone de permisos para eliminar archivos del almacenamiento.",
    'backup__repository_check_error_rmdir' => "No ha sido posible operar con el almacenamiento: %1\nCompruebe que dispone de permisos para eliminar carpetas del almacenamiento.",

    'backup__ftp_repository_check_login' => "%1 Puede comprobarlos de forma independiente con el siguiente comando:\n %2",
    'backup__ftp_repository_check_error_list' => "%1 Puede comprobarlos de forma independiente con el siguiente comando:\n %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Puede comprobarlo de forma independiente con el siguiente comando:\n %2",
    'backup__ftp_repository_check_error_upload' => "%1 Puede comprobarlo de forma independiente con los siguientes comandos:\n %2\n %3",
    'backup__ftp_repository_check_error_download' => "%1 Puede comprobarlo de forma independiente con los siguientes comandos:\n %2\n %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Puede comprobarlo de forma independiente con los siguientes comandos:\n %2\n %3\n %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Puede comprobarlo de forma independiente con los siguientes comandos:\n %2\n %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Puede comprobarlo de forma independiente con el siguiente comando:\n %2",
    'backup__ftp_repository_check_error_rm' => "%1 Puede comprobarlo de forma independiente con los siguientes comandos:\n %2\n %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Puede comprobarlo de forma independiente con los siguientes comandos:\n %2\n %3",

    'sfdmarc_server_wide_legend' => 'DMARC',
    'sfdmarc_server_wide_enable_dmarc' => 'Activar DMARC para la comprobación del correo entrante',
    'sfdmarc_server_wide_enable_failed' => 'No ha sido posible modificar la configuración de DMARC. Par activar esta opción, active la protección antispam SPF y DKIM.',
    'sfdmarc_server_wide_enable_hint' => 'Esta opción se encuentra disponible cuando DKIM y SPF están activados para los correos entrantes.',
    'spf_server_wide_enable_hint' => 'Esta opción no puede desactivarse se DMARC se encuentra activado para los correos entrantes.',
    'spf_server_wide_disable_failed' => 'No ha sido posible modificar la configuración para la protección antispam SPF. Para desactivar SPF, desactive DMARC para los correos entrantes.',
    'sfdk_server_wide_enable_hint' => 'Esta opción no puede desactivarse se DMARC se encuentra activado para los correos entrantes.',
    'sfdk_server_wide_verify_disable_failed' => 'No ha sido posible modificar la configuración para la protección antispam DKIM. Para desactivar DKIM, desactive DMARC para los correos entrantes.',

    'ccs_not_supported' => 'El almacenamiento central de certificados IIS no está configurado en el sistema.',
    'ccs_not_enabled' => 'La gestión de almacenamiento central de certificados IIS no se encuentra activada en Plesk.',
    'ad_not_supported' => 'El servidor no está asociado a ningún dominio.',

    'component_name__appinit' => "Inicialización de aplicación",
    'component_name__httpcompression' => 'Compresión de contenido HTTP',
    'common_feature_is_not_supported' => 'Ya no se soporta esta prestación.',
    'common_feature_is_not_supported_in_proto' => 'Ya no se soporta esta prestación para la versión %1 del protocolo.',
    'autoinstaller__plesk_component' => 'Componente de Plesk',
    'plesk_key__key_expired' => 'Su llave de licencia ha expirado. Para seguir usando Plesk, compre una %1 comercial que no expire.',
    'plesk_key__key_purchase' => 'llave de licencia',

    'sa_action_move' => 'Mover spam a la carpeta "Correo electrónico no deseado"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Ya no se soportan aplicaciones Java. Estas no estarán disponibles para los siguientes sitios web: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Ya no se soportan versiones móviles de sitios web alojados con UNITY Mobile. Estas no estarán disponibles para los siguientes sitios web: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'La directiva de uso a nivel del servidor no permite el uso de opciones personales de antivirus. Estas se restauraran de forma incompleta para las cuentas de correo de los siguientes dominios: {{objects}}',

    'server_preferences__ip_logging' => 'Registro de IPs',
    'server_preferences__disable_ip_logging' => 'Desactivar registro de IPs en IIS, FTP y registros de correo',
    'server_preferences__disable_ip_logging_description' => 'De seleccionarse, IIS y MailEnable ya no escribirán direcciones IP en archivos de registro',

    'module__not_installed' => "La extensión %1 no está instalada",

    'mail__mailbox_quota_warning_text' => 'Activar advertencia de cuota de buzón de correo',
    'mail__mailbox_quota_warning_hint' => 'Enviar una notificación a los usuarios de correo cuando su uso de la cuota de correo supere el 95 %',
    'mail__mailbox_quota_warning_customization_text' => 'Personalizar la advertencia de cuota de buzón personalizada',
    'mail__mailbox_fix-incorrectly-set-sender-text' => 'Corregir remitentes establecidos incorrectamente para correo saliente',
    'mail__mailbox_fix-incorrectly-set-sender-hint' => 'Configure encabezados de correo válidos de forma automática así como direcciones de remitentes para correos salientes desde dominios para así reducir la posibilidad de que se consideren spam',
    'mail__mail_autodiscovery' => 'Detección automática de correo',
    'mail__mail_autodiscovery_description_text' => 'Descubra cómo funciona en la %%link%%',
    'mail__mail_autodiscovery_description_text_link' => 'base de conocimiento',
    'mail__mail_autodiscovery_text' => 'Activar detección automática de correo',
    'mail__mail_autodiscovery_hint' => 'De activarse esta prestación, se reconfigurarán todos los dominios que tengan activada la detección automática',
    'mail__mail_autodiscovery_server_text' => 'Indicar un nombre de dominio personalizado para la detección automática de correo',
    'mail__mail_autodiscovery_server_hint' => 'Nota: el nombre de dominio debe estar protegido con un certificado SSL/TLS válido.',
    'mail__mail_autodiscovery_server_error' => 'Indicar un nombre de dominio personalizado para la detección automática de correo',
    'mail__mail_autodiscovery_reconfigure_dns_text' => 'Reconfigurar registros DNS de detección automática',
    'mail__mail_autodiscovery_reconfigure_dns_hint' => 'De activarse esta prestación, se reconfigurarán todos los registros DNS de detección automática de dominios que tengan activada la detección automática',
    'mail__error_mail_autodiscovery_enable' => 'No ha sido posible configurar la detección automática de correo: %1',
    'mail__error_mail_autodiscovery_server' => 'No ha sido posible configurar un nombre de dominio personalizado para la detección automática de correo: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'No ha sido posible reconfigurar los registros DNS de detección automática de dominios: %1',

    '__invalid_url' => 'La URL "%1" no es válida',
    'actionlog__cloning_start' => 'iniciar',
    'actionlog__event_cloning_start' => 'Inicio de clonación de servidores',

        '__show_hide_title' => 'Minimizar/Restaurar',
    '__show_hide_navigation_pane' => 'Ocultar/mostrar el panel de navegación',
    '__UPLOAD_ERR_FORM_SIZE' => "El archivo cargado excede el tamaño permitido",
    '__UPLOAD_ERR_INI_SIZE' => "El archivo cargado excede el tamaño permitido",
    '__UPLOAD_ERR_NO_FILE' => "Ningún archivo recibido",
    '__UPLOAD_ERR_OK' => "Archivo cargado correctamente",
    '__UPLOAD_ERR_PARTIAL' => "Archivo cargado parcialmente, inténtelo de nuevo",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'No se encuentra la carpeta temporal',
    '__UPLOAD_ERR_CANT_WRITE' => 'Error al escribir el archivo en el disco',
    '__UPLOAD_ERR_UNKNOWN' => 'Se ha producido un error desconocido de carga de archivo',
    '__accounts' => "Cuentas",
    '__access' => "Acceso",
    '__address' => "Dirección",
    '__addresses' => "Direcciones",
    '__acl_records' => 'Registros ACL',
    '__admin_repository' => "Repositorio del administrador",
    '__all' => 'Todos',
    '__allowed' => "Permitidos",
    '__anonftp_status' => "FTP anónimo",
    '__antispam' => "Antispam",
    '__apache_restart' => "...el servidor web %1 se está reiniciando. Espere...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Soporte para Microsoft ASP.NET",
    '__asp_win_support' => "Soporte para Microsoft ASP",
    '__attachments' => "Adjuntos",
    '__attachments_list' => "Adjuntos",
    '__author' => 'Autor',
    '__autoresp_name_already_exists' => "Ya existe una respuesta automática denominada %1.",
    '__autoresponder' => "Respuesta automática",
    '__autoresponders' => "Respuestas automáticas",
    '__autoresponders_list' => "Respuestas automáticas",
    '__autoresponder_attachment_files' => "Archivos adjuntos a la respuesta automática",
    '__auto_updates_list' => 'Actualizaciones disponibles',
    '__avail' => "Disponible",
    '__backup_utilites' => "Utilidades de backup",
    '__bind_status' => "Estado del servidor DNS",
    '__bu_is_not_installed' => "Este servicio no está disponible en este momento porque no se han instalado las utilidades de backup.",
    '__bu_not_support_in_key' => "La llave de licencia no soporta la capacidad para crear backups.",
    '__notifications_not_support_in_key' => 'La llave de licencia no soporta notificaciones',
    'disabled_by_key' => 'No soportado por la llave de licencia',
    '__bytes' => "bytes",
    '__can_not_use_reserved_words' => "No puede usar las palabras reservadas.",
    '__certificate' => "Certificado",
    '__cgi_support' => "Soporte para CGI",
    '__change_date' => "Fecha de modificación",
    '__city' => "Ciudad",
    '__cl_not_exist' => "La cuenta de cliente no existe.",
    '__client' => 'Cliente',
    '__client_card' => "Tarjeta del cliente",
    '__client_contact_name' => "Nombre de contacto del cliente",
    '__client_form' => "Información personal",
    '__client_ip_pool' => "Grupo de direcciones IP  del cliente",
    '__client_limits' => "Límites de la cuenta de cliente",
    '__client_permissions' => "Permisos del cliente",
    '__client_preferences' => "Preferencias del cliente",
    '__client_status' => "Estado del cliente",
    '__client_name' => "Nombre del cliente",
    '__client_total' => "Total de clientes",
    '__client_with_login_name_already_exists' => "Ya existe un usuario con nombre de usuario \"%1\".",
    '__client_domuser_with_login_already_exists' => "El nombre de usuario '%1' ya está siendo usado por el administrador del dominio '%1'.",
    '__clients_global_changes' => "Modificar cuentas de cliente seleccionadas",
    '__clients_list' => "Clientes",
    '__cmd_not_found' => "Comando desconocido: %1",
    '__comments' => "Comentarios",
    '__company_name' => "Nombre de la empresa",
    '__component_version' => "Versión del componente",
    '__component_not_installed' => "No se ha instalado el componente %1",
    '__confirm_del' => "Confirme la eliminación.",
    '__confirm_overwrite' => "Confirme la sobrescritura.",
    '__confirm_stop' => "Confirme la detención del proceso.",
    '__confirm_passwd' => "Confirmar contraseña %1",
    '__confirm_removal' => "Confirme la eliminación",
    '__conhelp' => "Descripción",
    '__contact_name' => "Nombre de contacto",
    '__country' => "País",
    '__countries' => 'País',
    '__country_unknown' => 'No se pudo reconocer el subcódigo de país.',
    '__courier-imap' => 'Servidor Courier',
    '__create_domain' => 'Crear un dominio',
    '__crypted' => 'cifrado',
    '__cp_access' => "Acceso a Plesk",
    '__cp_user' => "Usuario de Plesk",
    '__create' => "Crear",
    '__create_client_template_without_template' => "Crear cuenta de usuario sin plantilla",
    '__create_domain_for' => "Crear un dominio para <b>%1</b>",
    '__create_domain_template_without_template' => "Crear dominio sin plantilla",
    '__creation_date' => "Fecha de creación",
    '__crontab_unix' => "Programador",
    '__crontab_win' => "Programador",
    '__ct_month_jan' => 'Enero',
    '__ct_month_feb' => 'Febrero',
    '__ct_month_mar' => 'Marzo',
    '__ct_month_apr' => 'Abril',
    '__ct_month_may' => 'Mayo',
    '__ct_month_jun' => 'Junio',
    '__ct_month_jul' => 'Julio',
    '__ct_month_aug' => 'Agosto',
    '__ct_month_sep' => 'Septiembre',
    '__ct_month_oct' => 'Octubre',
    '__ct_month_nov' => 'Noviembre',
    '__ct_month_dec' => 'Diciembre',
    '__custom_button' => "Botón personalizado",
    '__custom_buttons_list' => "Enlaces a servicios adicionales",
    '__daily' => "Diariamente",
    '__database_not_activated' => "%1 no ha sido activado en la página de administración del servidor.",
    '__database_not_installed' => "La base de datos %1 no está instalada.",
    '__database_not_run' => "La base de datos %1 no está en ejecución.",
    '__database_is_corrupt' => "La base de datos de Plesk está dañada. Use la utilidad Reconfigurator para corregirla.",
    '__databases' => "Bases de datos",
    '__databases_list' => "Bases de datos",
    '__database_type_not_supported_by_key' => 'Para utilizar el servidor %1 es necesario que su llave de licencia incluya soporte para el mismo. Rogamos póngase en contacto con su responsable comercial de Plesk.',
    '__date_immediately' => "hoy",
    '__date_never' => "nunca",
    '__day(s)' => "Día(s)",
    '__day0' => "Dom",
    '__day1' => "Lu",
    '__day2' => "Mar",
    '__day3' => "Mié",
    '__day4' => "Jue",
    '__day5' => "Vie",
    '__day6' => "Sáb",
    '__days' => "%1 día(s)",
    '__db_admin_login_empty' => "Ha indicado un nombre de usuario en blanco, desactivando el control sobre %1 en el interfaz. ¿Desea continuar?",
    '__db_unable_to_unregister' => 'No se han podido eliminar los parámetros de la conexión a la base de datos',
    '__db_db_exists' => 'Hay como mínimo una base de datos en el servidor',
    '__db_unable_to_change_server_name' => 'El nombre del servidor no puede cambiarse',
    '__db_unable_to_change_port' => 'El puerto para el servidor no puede cambiarse',
    '__db_already_exist' => "La base de datos %1 ya existe.",
    '__db_credentials_invalid' => "Las credenciales de acceso no son válidas.",
    '__db_invalid_password_characters' => 'La contraseña contiene caracteres que no son válidos',
    '__db_engine' => "Motor de base de datos", // indirect
    '__db_type' => "Tipo de base de datos",
    '__db_user' => "Usuario de base de datos",
    '__db_server' => 'Servidor de bases de datos',
    '__def_domain' => "Dominio predeterminado",
    '__default_for_mysql' => 'predeterminado para MySQL',
    '__default_for_mariadb' => 'predeterminado para MariaDB',
    '__default_for_percona' => 'predeterminado para Percona',
    '__default_for_postgresql' => 'predeterminado para PostgreSQL',
    '__delete' => "Eliminar",
    '__demo' => "Esta función no está disponible en la versión demo.",
    '__directory' => "Directorio",
    '__disable_lock_screen' => 'Impedir que los usuarios utilicen Plesk hasta que las pantallas del interfaz se hayan cargado completamente',
    '__dismiss_news?' => "¿Está seguro de que desea ocultar completamente el bloque de noticias?\n\nLas noticias no se volverán a mostrar hasta que hayan noticias nuevas.",
    '__description' => "Descripción",
    '__disabled' => "desactivado",
    '__disk_space_limit' => "Límite de espacio en disco",
    '__cgroups_cpu_usage_limit' => 'Límite de uso de CPU',
    '__cgroups_ram_usage_limit' => 'Límite de uso de RAM',
    '__cgroups_disk_read_usage_limit' => 'Límite de ancho de banda de lectura del disco',
    '__cgroups_disk_write_usage_limit' => 'Límite de ancho de banda de escritura del disco',
    '__disk_usage_by' => "Espacio en disco usado por %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "El registro DNS '%1' ya existe.",
    '__dns_master_should_be_remote' => "Debe tener dos servidores de nombres autoritativos distintos en hosts separados.",
    '__dns_record_not_exist' => "El registro DNS no existe.",
    '__dns_server' => "Servidor DNS", // indirect
    '__dom_id_is_undefined' => "ID de dominio no definido.",
    '__dom_name' => "Nombre del dominio",
    '__dom_name_is_invalid' => "El nombre de dominio no es válido. Compruebe que su nombre de dominio solo contiene caracteres alfanuméricos, puntos y guiones y que su longitud no supera los 255 símbolos. Cada parte del nombre de dominio entre puntos no debería tener más de 63 símbolos.",
    '__dom_not_exist' => "El dominio no existe.",
    '__domain' => "Dominio",
    '__domain_' => 'Dominio %1',
    '__domain_form' => "Formulario de dominio",
    '__domain_id' => "ID del dominio",
    '__domain_is_turned_off_for_backup' => "El sitio web %1 está temporalmente deshabilitado porque se está realizando un backup o restauración y no está disponible en este momento.",
    '__domain_limits' => "Límites del dominio",
    '__domain_name' => "Nombre del dominio",
    '__mail_name_in_ASCII_form' => "Nombre de la cuenta de correo en formato ASCII",
    '__message_error' => 'Error',
    '__message_warning' => 'Advertencia',
    '__message_info' => 'Información',
    '__domain_name_in_ASCII_form' => "Nombre del dominio en formato ASCII",
    '__domain_repository' => "Repositorio del dominio %1",
    '__domain_status' => "Estado del dominio",
    '__domain_dns' => 'Zona DNS del dominio',
    '__domain_total' => "Cantidad total para la suscripción",
    '__domain_total_powerUser' => "Cantidad total para la suscripción",
    '__domain_user' => "Administrador del dominio",
    '__domains_global_changes' => "Modificar dominios seleccionados",
    '__mailnames_global_changes' => "Modificar cuentas de correo seleccionadas",
    '__backup_manager' => 'Administrador de backups',
    '__domains_list' => "Dominios",
    'domains_list__list_header' => "dominios", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "El nombre del dominio empieza por www, aunque se usa el prefijo WWW. ¿Desea continuar de todas formas?",
    '__dovecot' => 'Servidor Dovecot IMAP y POP3',
    '__dsmail' => "Servicio de correo",
    '__dsmaillist' => "Servicio de listas de correo",
    '__dsr_db' => "DB",
    '__dsr_dname' => "Nombre del dominio",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "Nombre del cliente",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Tamaño total de los archivos de backup en el almacenamiento local",
    '__email' => "Email",
    '__email_addr_is_invalid' => "La dirección de email no es válida.",
    '__enabled' => "activado",
    '__enter_cert_text' => "Introduzca el texto de certificado",
    '__enter_size' => "Indique el tamaño",
    '__exclusive' => "Dedicada",
    '__expiration_date' => "Fecha de expiración",
    '__fax' => "Fax",
    '__file' => "Archivo",
    '__file_is_empty' => "El archivo está vacío.",
    '__file_name' => "Nombre del archivo",
    '__file_type' => 'Tipo de archivo',
    '__filemanager' => "Administrador de archivos",
    '__filepath_is_empty' => "Ruta al archivo vacía",
    '__files_list' => "Archivos",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Configuración FTP",
    '__ftp_serv' => "Servidor FTP", // indirect
    '__ftp_server_parameters_are_empty' => "¡Primero debe establecer las propiedades de la cuenta FTP!",
    '__ftp_status' => "Estado del servidor FTP",
    '__full_day0' => "Domingo",
    '__full_day1' => "Lunes",
    '__full_day2' => "Martes",
    '__full_day3' => "Miércoles",
    '__full_day4' => "Jueves",
    '__full_day5' => "Viernes",
    '__full_day6' => "Sábado",
    '__full_month1' => "Enero",
    '__full_month10' => "Octubre",
    '__full_month11' => "Noviembre",
    '__full_month12' => "Diciembre",
    '__full_month2' => "Febrero",
    '__full_month3' => "Marzo",
    '__full_month4' => "Abril",
    '__full_month5' => "Mayo",
    '__full_month6' => "Junio",
    '__full_month7' => "Julio",
    '__full_month8' => "Agosto",
    '__full_month9' => "Septiembre",
    '__giga' => "G",
    '__group' => "Grupo",
    '__h' => "H",
    '__hard_disk_quota' => "Cuota de disco duro",
    '__hard_disk_quota_not_supported' => 'la cuota de disco duro no se soporta debido a la configuración del sistema de archivos del servidor',
    '__header_text_is_invalid' => "El nombre del área protegida no es válido.",
    '__help_topic_not_found' => 'El tema de ayuda solicitado (%1) no existe.',
    '__hosting' => "Hosting",
    '__hosting_ip_dns_ip_not_equiv' => "Ninguna de las direcciones IP especificadas en los registros A del DNS coincide con la dirección IP usada para hosting.",
    '__hosting_scripting' => "Soporte para hosting de scripts",
    '__hosting_setup_page_title' => "Configuración de hosting web para el dominio %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Tipo de hosting",
    '__hostname' => "Nombre del host",
    '__hostname_is_empty' => "El nombre de host esta vacío.",
    '__hour(s)' => 'Hora(s)',
    '__hst_type_incorrect' => "El tipo de hosting no es correcto.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Tiempo de inactividad",
    '__iface' => "Interfaz",
    '__image' => "Imagen",
    '__imap_status' => "Estado del servidor IMAP",
    '__in' => "Entrante",
    '__in_%' => "en %",
    '__incorrect_databases_login_pass' => "Las credenciales indicadas para acceder a PostgreSQL no son correctas.",
    '__incorrect_ip_or_network_address' => 'Dirección IP o de red incorrecta.',
    '__info' => 'Información',
    '__install' => "Instalar",
    '__install_prefix' => "Prefijo de instalación",
    '__invalid_cert_id' => "ID del certificado no válido",
    '__invalid_context' => "Contexto no válido: %1",
    '__invalid_db_usr_name' => "Nombre de usuario de la base de datos no válido.",
    '__invalid_dir_name' => "El nombre del directorio no es válido",
    '__invalid_dom_name' => "Nombre de dominio no válido.",
    '__invalid_filename' => "Nombre de archivo no válido. No use comillas y/o la combinación \"../\".",
    '__invalid_id' => "Identificador incorrecto.",
    '__invalid_lines_num' => "El valor para el número de líneas no es correcto. Solo se permite el uso de dígitos.",
    '__invalid_max_letter_size' => "El tamaño máximo del mensaje no es válido.",
    '__invalid_pdir_name' => "Nombre del directorio protegido no válido.",
    '__invalid_restart_apache_interval' => "El intervalo de reinicio de Apache no es válido.",
    '__invalid_tmpl_name' => "Nombre de plantilla no válido.",
    '__invalid_value' => "Valor incorrecto.",
    '__ip_addr' => "Dirección IP",
    '__ip_address_and_mask' => "Dirección IP y máscara de subred",
    '__ip_alias__mask' => "Dirección IP y máscara de subred",
    '__ip_addr_form' => "Formulario de dirección IP",
    '__ip_addr_is_invalid' => "Dirección IP incorrecta.",
    '__ip_addr_list' => "Direcciones IP",
    '__ip_address_does_not_exist' => "La dirección IP no existe.",
    '__ip_addresses' => "Direcciones IP",
    '__ip_address_and_mask_hint' => 'Por ejemplo, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "Su llave de licencia solo puede usarse en Virtuozzo containers.",
    '__key_limits_exceeding' => "Esta acción excede los límites definidos por su licencia de software. Si recibe este mensaje, póngase en contacto con su proveedor para clarificar o ampliar los límites de su licencia.",
    '__kilo' => "K",
    '__keywords' => 'Palabras clave',
    '__lang_unknown' => 'No se puede reconocer el idioma.',
    '__languages' => 'Idioma',
    '__learn_more' => 'Más información',
    '__loading' => 'Cargando...',
    '__locales' => "Paquetes de idioma",
    '__lists' => "Listas de correo",
    '__literal_bytes' => "B",
    '__processing' => "Espere.<br>Cargando...",
    '__locale' => "Idioma del interfaz",
    '__locale_is_not_defined' => "No se ha definido el idioma del interfaz.",
    '__local_server_mysql' => 'Servidor MySQL local',
    '__local_server_postgresql' => 'Servidor PostgreSQL local',
    '__local_server_mssql' => 'Servidor MS SQL local',
    '__log_and_statistics_files' => 'Archivos de registro e informes estadísticos',
    '__config_files' => 'Archivos de configuración',
    '__chroot_files' => 'Entorno chrooted',
    '__login' => "Nombre de usuario %1",
    '__login1' => "Nombre de usuario",
    '__login_disabled' => "Acceso no permitido",
    '__login_enabled' => "Acceso permitido",
    '__login_incorrect' => "Ha introducido un nombre de usuario o contraseña incorrecto.",
    '__login_name' => "Nombre de usuario %1",
    '__login_name_is_invalid' => "Nombre de usuario %1 incorrecto.",
    '__logon_time' => "Hora de inicio de sesión",
    '__ma' => "Alias de correo",
    '__mail' => "Correo",
    '__mail_alias_name' => "Nombre del alias de correo",
    '__mail_autodiscovery' => 'Detección automática de correo',
    '__mail_exchanger_name_is_invalid' => "Nombre del intercambiador de correo no válido.",
    '__mail_groups' => "Grupos de correo",
    '__mail_list_engine' => "Software de lista de correo",
    '__mail_name' => "Cuenta de correo",
    '__mail_name_form' => "Propiedades de la cuenta de correo",
    '__mail_names' => "Cuentas de correo",
    '__mail_serv' => "Servidor de correo",
    '__mail_user' => 'Usuario de correo',
    '__mailgroup' => "Grupo de correo",
    '__maillist' => "Lista de correo",
    '__maillists' => "Listas de correo",
    '__maillist_member' => 'Miembro de lista de correo',
    '__mailname' => "Cuenta de correo",
    '__mailname_redir_self' => "La cuenta de correo no puede reenviarse emails a ella misma.",
    '__max_dom_num_reached_for_cl' => "Se ha alcanzado el número máximo de dominios para esta cuenta de cliente.",
    '__max_file_size_available' => "Tamaño máximo de archivo permitido %1",
    '__max_subdom_num_reached_for_cl' => "Se ha alcanzado el número máximo de subdominios para esta cuenta de cliente.",
    '__max_subdom_num_reached_for_dom' => "Se ha alcanzado el número máximo de subdominios para el dominio.",
    '__max_subdom_num_reached_for_key' => "Se ha alcanzado el número máximo de subdominios permitidos por la llave de licencia.",
    '__max_traffic_limit' => "Límite de tráfico",
    '__maximum_excl_ip_num' => "Cuentas de correo",
    '__mb' => "MB",
    '__mbytes' => "megabytes",
    '__mb_month' => "MB/mes",
    '__mb_sec' => "MB/seg",
    '__gb_sec' => "GB/seg",
    '__tb_sec' => "TB/seg",
    '__mega' => "M",
    '__minute(s)' => 'Minutos(s)',
    '__mls_not_in_key' => "Su llave de producto no soporta un interfaz multidioma.",
    '__modification_date' => "Fecha de modificación",
    '__module' => "Extensión",
    '__month' => "Mes",
    '__month(s)' => "Mes(es)",
    '__month1' => "Ene",
    '__month10' => "Oct",
    '__month11' => "Nov",
    '__month12' => "Dic",
    '__month2' => "Feb",
    '__month3' => "Mar",
    '__month4' => "Abril",
    '__month5' => "Mayo",
    '__month6' => "Junio",
    '__month7' => "Julio",
    '__month8' => "Ago",
    '__month9' => "Set",
    '__monthly' => "Mensualmente",
    '__months' => "Meses",
    '__moved_permanently' => 'Movido permanentemente',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Servidor",
    'mssql__server' => "Nombre del servidor Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "el nombre para el servidor no puede cambiarse: al menos existe una base de datos en este.",
    '__mssql_status' => "Estado de Microsoft SQL Server",
    '__multiply_login_deny' => "No es posible iniciar la sesión. Existe otro usuario con el mismo nombre de usuario (%1) que ya ha iniciado sesión en Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Estado de MySQL Server",
    '__mysql_version' => "Versión de MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Estado del servidor MariaDB",
    '__mariadb_version' => "Versión de MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Estado del servidor Percona",
    '__percona_version' => "Versión de Percona",
    '__name' => "Nombre",
    '__name_invalid' => "Nombre no válido.",
    '__nameserver' => "servidor de nombres",
    '__network' => "Red",
    '__networks' => "Redes",
    '__no' => "No",
    '__no_ip_address_with_properly_type_available' => "No se han podido restaurar los datos copiados porque no existe ninguna dirección IP apropiada para realizar la restauración.",
    '__no_clients_specified' => "No ha indicado ninguna cuenta de cliente.",
    '__no_comments' => "Sin comentarios.",
    '__no_ip_specified' => "No se especificó ninguna IP.",
    '__nologin' => "Prohibido",
    '__none' => "Ninguno",
    '__not_configured' => "No configurado",
    '__not_implemented_yet' => "Aún no implementado",
    '__not_supported_by_ftp' => "(no soportado por el servidor FTP)",
    '__not_supported_by_mailmng' => "no soportada por el servidor de correo",
    '__notification' => "Notificación",
    '__num_displayed' => "%1 de %2 mostrados",
    '__num_is_invalid' => "Número no válido.",
    '__object_not_found' => 'Objeto no encontrado: %1',
    '__of_all' => "% de todos",
    '__off' => "Deshabilitado",
    '__ok' => "ACEPTAR",
    '__old_passwd' => "Contraseña %1 anterior",
    '__on' => "Habilitado",
    '__others' => "Otros",
    '__other_ip__will_be_added' => 'Otras direcciones IP disponibles (se añadirán al grupo de direcciones IP del cliente)',
    '__out' => "Saliente",
    '__p' => "P",
    '__passwd' => "%1 Contraseña",
    '__passwd_is_invalid' => "Contraseña %1 no válida.",
    '__passwd_not_match' => "¡Las contraseñas no coinciden!",
    '__path' => "Ruta",
    '__perl_unix_support' => "Soporte para Perl",
    '__perl_win_support' => "Soporte para Perl",
    '__perm_denied' => "Permiso denegado.",
    '__permissions' => "Permisos",
    '__personal_name' => "Nombre",
    '__pg_admin_not_activated' => "PostgreSQL no se activó en la página de administración del servidor.",
    '__pg_not_inst' => "PostgreSQL no instalado.",
    '__pg_not_run_or_inst' => "PostgreSQL no se instaló o no está en ejecución.",
    '__pg_not_support_in_key' => "La llave de licencia no soporta PostgreSQL.",
    '__phone' => "Teléfono",
    '__phosting' => "Hosting físico",
    '__php_support' => "Soporte para PHP",
    '__php_run_as_isapi' => "ejecutar como extensión ISAPI",
    '__php_safe_mode' => "'modo_seguro' PHP activo",
    '__php_version' => "Versión de PHP",
    '__physical' => "Hosting físico",
    '__plesk_stat_pdir' => "Proteger directorio '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Estadísticas de dominio",
    '__plesk_stat_protect' => "Proteger el acceso a las estadísticas web mediante las credenciales FTP del usuario",
    '__plesk_stat_protect_install' => "accesible vía directorio protegido con contraseña '/plesk-stat/webstat/'",
    '__plesk_stat_webstat_not_activate' => "No seleccionó ningún programa de estadísticas web a usar para este sitio web.",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Estado del servidor POP3",
    '__popen_error' => "Se ha producido un error mientras se llamaba a la función popen.",
    '__port' => 'Puerto',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Estado de PostgreSQL",
    '__preferences' => "Configuración",
    '__account_preferences' => "Configuración de la cuenta",
    '__interface_preferences_general' => 'General',
    '__interface_preferences_default' => 'Preferencias predeterminadas del interfaz',
    '__interface_preferences_admin' => "Preferencias de interfaz del administrador",
    '__interface_template' => 'Plantilla de personalización del interfaz',
    '__interface_preferences' => "Preferencias del interfaz",
    '__proceed?' => "¿Desea continuar?",
    '__protect_dir_user' => "Usuario del directorio protegido",
    '__protect_dir_users' => "Usuarios del directorio protegido",
    '__protect_dirs' => "Directorios protegidos",
    '__provider_contact_name' => "Nombre de contacto del propietario",
    '__python_unix_support' => "Soporte para Python",
    '__python_win_support' => "Soporte para Python",
    '__quota' => "Cuota",
    '__r' => "R",
    '__reconfigure' => "Reconfigurar",
    '__record_type' => "Tipo de registro",
    '__release' => "Versión",
    '__remote_db_not_supported_by_key' => 'Hosting de base de datos remota no soportado por su llave de licencia.',
    '__remove' => "Eliminar",
    '__remove_confirmation' => "Confirme la eliminación",
    '__remove_protection' => 'Eliminar protección',
    '__report' => "Informe",
    '__report_auto' => 'Programación de entrega',
    '__report_form' => "Formulario de informe",
    '__report_size_na' => "Servicio no disponible",
    '__reports_list' => "Informes",
    '__requested' => "Solicitados",
    '__required_fields' => "Campos obligatorios",
    '__resp_name_invalid' => "El nombre de la respuesta automática no es válido. Use únicamente alfanuméricos, puntos, guiones bajos y espacios.",
    '__c' => "A", // Access to panel
    '__s' => "Estado",
    '__server_name_is_invalid' => "El nombre del servidor no es válido.",
    '__screenshots' => 'Capturas de pantalla',
    '__script_warning' => "Si elimina la capacidad de scripts para este dominio, todos los scripts afectados se mostrarán en texto sin formato en el navegador. Se recomienda al administrador eliminar todos los scripts dependientes del dominio.",
    '__sec' => "Segundos",
    '__second(s)' => "Segundo(s)",
    '__see_list_of_logged_in' => "Vea la lista de usuarios conectados en este momento.",
    '__select_certs_to_remove' => "Seleccione los certificados a eliminar.",
    '__select_domains_to_default_host' => "Seleccione el dominio a establecer como predeterminado.",
    '__select_domains_to_remove' => "Seleccione los dominios a eliminar.",
    '__type_domain_name_to_add' => "Introduzca el nombre del dominio a añadir.",
    '__select_files_to_remove' => "Seleccione los archivos a eliminar.",
    '__select_ip' => "Asignar dirección IP",
    '__select_ip_to_remove' => "Seleccione la dirección IP a eliminar.",
    '__select_domain_template' => "Usar configuración de plantilla de dominio",
    '__select_templates_to_remove' => "Seleccione las plantillas a eliminar.",
    '__server' => "Servidor",
    '__server_total' => "Total servidor",
    '__service' => "Servicio",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Servidor de bases de datos MySQL",
    '__service_description__mysql' => "Servidor de bases de datos MySQL",
    '__service_title__web' => "Servidor web",
    '__service_description__web' => "Servidor web",
    '__service_title__smtp' => "Servidor SMTP",
    '__service_description__smtp' => "Servidor SMTP",
    '__service_title__mail' => "Servidor IMAP/POP3",
    '__service_description__mail' => "Servidor IMAP/POP3",
    '__service_title__dns' => "Servidor DNS",
    '__service_description__dns' => "Servidor DNS",
    '__service_title__postgresq' => "Servidor de bases de datos PostgreSQL",
    '__service_description__postgresq' => "Servidor de bases de datos PostgreSQL",
    '__service_title__spamassassin' => "Servicio de filtro antispam SpamAssassin",
    '__service_description__spamassassin' => "Servicio de filtro antispam SpamAssassin",
    '__services' => "Servicios",
    '__all_services' => "Todos los servicios",
    '__sessions' => "Sesiones",
    'sessions__feature_ftp_session_manager_not_supported' => "La prestación Sesiones FTP no es soportada por el servidor FTP actual",
    '__sessions_list' => "Sesiones",
    '__set' => "Activar",
    '__shared' => "Compartida",
    '__shell_access_warning' => "Permitir el acceso al shell al sistema supone un riesgo significativo para la seguridad del sistema. Solo permita el acceso al sistema si entiende los riesgos y los usuarios son de confianza. ¿Realmente desea permitir el acceso?",
    '__siteapp_not_support_in_key' => "La llave de licencia no soporta aplicaciones web",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'La configuración de esta aplicación web se ha modificado de forma manual. Con el fin de proteger las modificaciones manuales, se ha deshabilitado la reconfiguración mediante Plesk.',
    '__site_management' => "Publicación web", // indirect
    '__size' => "Tamaño",
    '__skeleton' => 'Plantilla del host virtual',
    '__skins' => 'Skins',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Estado del servidor SMTP",
    '__some_fields_are_empty_or_invalid' => "Algunos campos están vacíos o contienen un valor incorrecto.",
    '__spamassassin' => "Filtro antispam",
    '__spamassassin_status' => "Estado de SpamAssassin",
    '__spamd_status' => 'Estado del filtro antispam',
    '__splited_backup' => "(backup multivolumen)",
    '__split_backup_file' => "Crear un backup multivolumen",
    '__split_backup_size' => "Tamaño del volumen",
    '__split_backup_less_than_500' => "No se soportan tamaños de volumen inferiores a 500 MB",
    '__ssi' => "SSI",
    '__ssi_support' => "Soporte para SSI",
    '__ssi_with_html' => "usar SSI para archivos *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Soporte para SSL/TLS",
    '__same_ssl' => "Usar un único directorio para el contenido SSL/TLS y el contenido No-SSL/TLS",
    '__same_ssl_cu' => "Contenido normal SSL/TLS y No-SSL/TLS",
    '__state' => "Estado/Provincia",

    '__status__Active' => 'Activos',
    '__status__active' => 'activo',
    '__status__Passive' => 'Desactivado',
    '__status__passive' => 'desactivado',
    '__status__off' => 'desactivado',
    '__status__with_parent' => 'desactivado',
    '__status__backup_restore' => 'suspendido temporalmente para backup o restauración',
    '__status__admin' => 'suspendido por el administrador del servidor',
    '__status__resseler' => 'suspendido por el revendedor',
    '__status__client' => 'suspendido por el cliente',
    '__status__unknown' => 'estado desconocido',

    '__status_of' => "Estado de %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Servidor Stunnel", // indirect
    '__subdomain' => "Subdominio",
    '__subdomain_name' => "Nombre del subdominio",
    '__subdomain_name_in_ASCII_form' => "Nombre del subdominio en formato ASCII",
    '__subdomains' => "Subdominios",
    '__domainaliases' => "Alias de dominio",
    '__subdomains_list' => "Subdominios",
    '__subdomains_not_support_in_key' => "La llave de licencia no soporta operaciones con subdominios",
    '__sys_user_type' => "Usuario FTP",
    '__sys_user_type_main' => "Utilizar la cuenta de usuario FTP del dominio principal",
    '__sys_user_type_native' => "Crear otra cuenta de usuario FTP para este subdominio",
    '__t' => "T",
    '__target_domain' => "Dominio de destino",
    '__template' => "Plantilla",
    '__template_not_accepted' => "La plantilla no puede aceptarse: se han excedido las siguientes limitaciones.",
    '__templates' => "Plantillas",
    '__templates_list' => "Plantillas",
    '__tera' => "T",
    '__title' => "Nombre",
    '__tools' => "Herramientas",
    '__total' => "Total %1",
    '__total_size' => "Tamaño total",
    '__total_used' => "Total usado",
    '__traffic' => "Tráfico",
    '__traffic_by_client' => "Tráfico por cliente",
    '__traffic_by_domain' => "Tráfico por dominio",
    '__traffic_by_service' => "Tráfico por servicio",
    '__traffic_history' => "Historial de tráfico",
    '__unable_change_locale' => "No se puede cambiar el idioma del interfaz: %1",
    '__unable_create_new_dom' => "No se pudo crear un dominio: %1",
    '__unable_define_dom_name' => "No se puede establecer el nombre del dominio: %1",
    '__unable_define_necessary_properties' => "No se pueden definir todas las propiedades requeridas.",
    '__unable_define_properties' => "No se pueden definir las propiedades: %1",
    '__unable_exec_util' => "No se puede ejecutar la utilidad: %1",
    '__unable_get_dns_a_recs' => "No se pueden recuperar las direcciones IP para registros A DNS para esta cuenta de hosting: %1",
    '__unable_get_mbox_quota' => "No se puede recuperar la información acerca del límite de tamaño del buzón.",
    '__unable_redirect_to_myself' => "No se pueden realizar reenvíos a la misma cuenta.",
    '__unable_redirect_to_my_alias' => "No se pudo reenviar el correo a un alias de correo.",
    '__default_domain_redirect_to_myself' => "No se puede establecer el dominio como predeterminado para la dirección IP:\n se ha detectado un redireccionamiento a sí mismo.",
    '__unable_remove_client' => "No se puede eliminar el cliente: %1",
    '__unable_set_up_mbox_quota' => "No se puede configurar el límite de tamaño del buzón para el dominio: %1",
    '__unable_setup_pass' => "No se puede establecer la contraseña: %1",
    '__unable_to_create_new_account' => "No se pudo crear una cuenta: %1",
    '__unable_to_define_db_size' => "No se puede definir el tamaño de la base de datos.",
    '__unable_to_enable_short_names' => "No se puede permitir el uso de nombres de cuenta cortos para cuentas POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "No se pueden recuperar los datos enviados: %1",
    '__unable_to_open_file' => "No se puede abrir el archivo %1: %2",
    '__unable_to_update_subdomain' => "No se pudieron realizar cambios en el subdominio: %1",
    '__unable_update_cl_data' => "No se pudieron guardar los cambios en la cuenta de usuario: %1",
    '__unable_update_db_params' => "No se pudieron actualizar los parámetros de la base de datos: %1",
    '__unable_update_dom_data' => "No se pudieron actualizar los datos del dominio: %1",
    '__undefined' => "no definido",
    '__uninstall' => "Desinstalar",
    '__unknown_error' => "Error desconocido",
    '__unlimited_lower' => "Ilimitado",
    '__unset' => "Desactivar",
    '__update' => "Actualizar",
    '__uploaded_file_is_invalid' => "El archivo cargado no es válido: %1",
    '__url' => "URL",
    '__usage' => "Uso de disco",
    '__user' => 'Usuario',
    '__user_already_logged' => "Existe otro usuario con el mismo nombre de usuario (%1) que ya ha iniciado sesión en Plesk.",
    '__version' => "Versión",
    '__aps_license' => "Llave de licencia",
    '__vh_type' => "Tipo de host virtual",
    '__vhosts_apache_status' => "Estado del servidor web",
    '__wrong_charset_conversion' => 'Codificación errónea. Conversión de "%1" a "%2" no permitida',
    '__warning_' => "¡Advertencia!",
    '__warning_excl_ip_num' => "Dirección IP dedicada",
    '__warning_expiration' => "Fecha de expiración",
    '__web_scripting' => "Scripts web", // indirect
    '__web_serv' => "Servidor web", // indirect
    '__web_statistic' => "Estadísticas web", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer no está instalado en el servidor. Para obtener asistencia con la instalación de esta aplicación, póngase en contacto con su proveedor de servicios.",
    '__webstat_support' => "Estadísticas web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Cuando cambia de programa estadístico, todos los informes creados por el programa anterior son eliminados y se crean informes nuevos de acuerdo con la información leída en los archivos de registro presentes en el servidor. Esto significa que si había configurado el sistema (en Dominios > nombre del dominio > Administrador de registros > Rotación de registros) para que solo se conservaran los archivos de registro del último mes, únicamente dispondrá de las estadísticas web de este último mes. ¿Desea cambiar a otro paquete estadístico?",
    '__webstat_perm_denied' => 'No dispone de los permisos necesarios para administrar estadísticas web.',
    '__webuser' => "Usuario web",
    '__sysusers_list' => "Usuarios del sistema",
    '__sysuser' => "Usuario del sistema",
    '__weekly' => "Semanalmente",
    '__whats_new_in_version' => "¿Qué hay de nuevo en Plesk %1?",
    '__wrong_hosting_type__none' => 'En el dominio %1 no se ha configurado hosting web.',
    '__wrong_hosting_type__std_fwd' => 'El dominio %1 tiene configurado el redireccionamiento estándar. Esta operación solo está disponible en el caso de dominios con hosting web.',
    '__wrong_hosting_type__frm_fwd' => 'El dominio %1 tiene configurado el redireccionamiento por marcos. Esta operación solo está disponible en el caso de dominios con hosting web.',
    '__wu' => "Usuarios web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "El prefijo WWW fue modificado. Modifique el certificado SSL/TLS como corresponda.",
    '__year' => "Año",
    '__year(s)' => "Año(s)",
    '__yes' => "Sí",
    '__you' => "Usted",
    '__zip_code' => "Código postal",
    '__form_normal' => "Normal",
    '__form_advanced' => "Avanzado",

    'admin_ed__edit_administrator_info' => "Edición del perfil del administrador",
    'admin_ed__create_default_client' => "Deseo crear una cuenta de cliente predeterminada.",
    'admin_ed__unable_update' => "No se puede actualizar la información del administrador: %1",

    'auth__update_admin_info' => "Introduzca la información del administrador. Esta información es necesaria para operar %1.",
    'auth__you_not_have_perm' => "No tiene permisos para administrar este dominio.",
    'auth__key_expired_admin' => 'Si licencia de Plesk ha expirado. Para poder seguir usando Plesk, renueve su licencia o compre una licencia nueva.',
    'auth__key_expired_admin_restricted' => 'Si licencia de Plesk ha expirado. Póngase en contacto con su proveedor de servicios para poder seguir usando Plesk.',
    'auth__key_expired_client' => 'La licencia de Plesk ha expirado. Póngase en contacto con su proveedor de hosting.',
    'autoinstaller__not_installed' => 'El componente auto instalador no está instalado.',
    'autoinstaller__release_action' => 'Operaciones disponibles',
    'autoinstaller__release_action_icon' => 'Estado',
    'autoinstaller__release_action_upgrade' => 'Actualizando a la nueva versión de Plesk',
    'autoinstaller__release_action_update' => 'Actualizando o añadiendo componentes',
    'autoinstaller__release_action_up2date' => 'Dispone de una versión actualizada',
    'autoinstaller__component_action' => 'Estado',
    'autoinstaller__component_action_icon' => 'Estado',
    'autoinstaller__component_action_install' => 'No instalado',
    'autoinstaller__component_action_update' => 'Hay actualizaciones disponibles',
    'autoinstaller__component_action_upgrade' => 'Hay una actualización disponible',
    'autoinstaller__component_action_up2date' => 'Dispone de una versión actualizada',
    'autoinstaller__component_action_error' => 'Ninguna actualización disponible',
    'autoinstaller__component_serverbuildtime' => 'Última versión',
    'autoinstaller__component_localbuildtime' => 'Su versión',
    'autoinstaller__component_installed_version' => 'Su versión',
    'autoinstaller__component_available_version' => 'Última versión',
    'autoinstaller__component' => 'Componente',
    'autoinstaller__components' => 'Componentes',
    'autoinstaller__components_title' => '%1 Componentes',
    'autoinstaller__component_dependency_note' => 'requerido para la instalación de los componentes seleccionados',
    'autoinstaller__install_confirm' => 'Sí, deseo instalar estos componentes',
    'autoinstaller__install_confirm_request' => 'Seleccione la casilla para confirmar',
    'autoinstaller__install_title' => 'Confirme la instalación de los componentes seleccionados',
    'autoinstaller__key_update_confirm' => 'Confirme la omisión de actualización de la llave y la instalación de la llave predeterminada',
    'autoinstaller__key_update_confirm_request' => 'Seleccione la casilla para confirmar.',
    'autoinstaller__key_update_failed' => '<p>Plesk no pudo actualizar su licencia de producto.</p><p>%1</p><p>Si procede con la actualización sin disponer de una licencia de producto apropiada, se instalará una licencia predeterminada cuya funcionalidad está limitada. Se recomienda a los administradores que adquieran la llave de licencia pertinentes antes de iniciar la actualización del producto.</p>',
    'autoinstaller__email' => 'Enviar notificación a',
    'autoinstaller__email_admin' => "Dirección de email del administrador",
    'autoinstaller__email_email' => 'Dirección de email personalizada...',
    'autoinstaller__release' => 'Nombre de la versión',
    'autoinstaller__releases' => 'Versiones disponibles',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Seleccione los componentes a instalar',
    'autoinstaller__status_error' => 'Error: %1',
    'autoinstaller__status_install_error' => 'No se ha podido iniciar la instalación: %1',
    'autoinstaller__status_install_busy' => 'No se ha podido iniciar la instalación: existe otro procedimiento de instalación en curso.',
    'autoinstaller__status_install_ok' => 'Instalación iniciada. Se le informará del progreso de instalación por email (%1).',
    'autoinstaller__status_query_busy' => 'Instalación en curso.',
    'autoinstaller__status_query_error' => 'No se puede recuperar el estado de la instalación: %1',
    'autoinstaller__status_unknown' => 'No se puede recuperar el estado del auto instalador.',
    'autoinstaller__status_busy' => 'El auto instalador está ocupado. Espere.',
    'autoinstaller__configure_title' => 'Configuración del actualizador',
    'autoinstaller__preferences_legend' => 'Configuración',
    'autoinstaller__target' => 'Directorio temporal de descargas',
    'autoinstaller__target_invalid' => "Especifique la ruta absoluta",
    'autoinstaller__check_updates' => 'Comprobar la existencia de actualizaciones cuando el administrador acceda a Plesk',
    'autoinstaller__check_updates_warning' => 'Existen<a href="%1">actualizaciones</a> nuevas para %2',
    'autoinstaller__source_type' => 'Tipo de origen',
    'autoinstaller__source' => 'URL de origen',
    'autoinstaller_source__preferences_legend' => 'Configuración',
    'autoinstaller_source__type' => 'Tipo de origen',
    'autoinstaller_source__url_invalid' => 'Origen no válido',
    'autoinstaller_source__url_invalid_network' => 'URL de origen no válida (Ejemplo: http://origen, ftp://origen)',
    'autoinstaller_source__url' => 'URL de origen',
    'autoinstaller__source_invalid_network' => 'Ha indicado una dirección de red incorrecta',
    'backup__repository' => 'Ubicación del almacenamiento de archivos de backup',
    'backup__error_notify_email' => 'En el caso de producirse errores durante la realización del backup, enviar una notificación al email',
    'backup__dump_info' => "Información del backup",
    'backup__dump_file_name_not_defined' => "No se ha indicado el nombre del archivo de backup",
    'backup__local_file' => 'Archivo de backup local',
    'backup__domain_ftp' => 'servidor FTP remoto',
    'backup__wrong_path' => "La ruta al almacenamiento de archivos de backup no es correcta. No utilice la secuencia de caracteres ../../",
    'backup__unable_to_connect_to_ftp_server' => "No se puede conectar con el servidor FTP: %1",
    'backup__unable_to_read_file' => 'No se puede leer el archivo de backup.',
    'backup__backup_task_does_not_exist' => "La tarea de backup no existe. Créela antes de poder activarla.",
    'backup__restore_params' => "Parámetros de restauración",
    'backup__confirmation' => "Advertencia: el dominio no estará disponible durante el backup/restauración.",
    'backup__backup_method' => 'Método de backup',
    'backup__dumpfile_name' => "Nombre del archivo de backup",
    'backup__dumpfile_name_is_invalid' => "El nombre del archivo de backup no es válido. Utilice únicamente símbolos alfanuméricos, guiones, puntos y guiones bajos. No use nombres del tipo descripción.* como nombre de archivo de backup.",
    'backup__email_required' => "Para poder informarle de los progresos de backup y restauración, necesitamos su dirección de email. Introduzca su email en los detalles de la cuenta.",
    'backup__error_during_backup' => "No se pudo crear el archivo de backup: %1",
    'backup__input_email_warning' => "Especifique un email para la notificación o deseleccione la casilla.",
    'backup__make_download' => "no guardar el archivo de backup en el almacenamiento, solo descargarlo",
    'backup__make_dump' => 'crear archivo de backup y guardarlo en el almacenamiento local',
    'backup__makedump_to_ftp' => 'crear archivo de backup y guardarlo en el servidor FTP remoto',
    'backup__restore_ip' => "Dirección IP para la restauración",
    'backup__select_dumpfile' => "Seleccione un archivo de backup.",
    'backup__time' => "Hora del backup",
    'backup__day' => 'Día del backup',
    'backup__view_dump_info' => "Ver la información del backup para el dominio %1",
    'backup__wrong_domain_name' => "El archivo de backup contiene los datos del dominio %1 y por consiguiente no puede ser restaurado en el dominio %2",
    'backup__incorrect_ftp_user_or_passwd' => "Usuario o contraseña FTP incorrectos. Corrija las propiedades de la cuenta FTP",
    'backup__access_denied' => "Acceso denegado. Corrija las propiedades de la cuenta FTP",
    'backup__restore_from' => "Restaurar %1",
    'backup__domain_session_failed' => 'El dominio %1 no se ha copiado',
    'backup__client_session_failed' => 'No se realizó el backup del cliente %1',
    'backup__domain_session_restore_failed' => 'El dominio %1 no se ha restaurado',
    'backup__client_session_restore_failed' => 'No se restauró la cuenta de cliente %1',
    'backup__domain_session_complete' => 'El dominio %1 ha sido copiado',
    'backup__domain_session_backup' => 'Backup del dominio %1',
    'backup__client_session_backup' => 'Backup del cliente %1',
    'backup__domain_stop_title' => 'Cancelación del backup del dominio %1',
    'backup__client_stop_title' => 'Cancelación del backup de la cuenta de cliente %1',
    'backup__domain_restore_stop_title' => 'Cancelación de la restauración del dominio %1',
    'backup__client_restore_stop_title' => 'Cancelación de la restauración de la cuenta de cliente %1',
    'backup__domain_session_backup_stop' => 'Está a punto de cancelar el proceso activo de backup. No se creará ningún archivo de backup.',
    'backup__backup_stop_confirm' => 'Sí, deseo detener el proceso de backup',
    'backup__restore_stop_confirm' => 'Sí, deseo detener el proceso de restauración',
    'backup__domain_session_restore' => 'Restauración del dominio %1',
    'backup__domain_session_restore_stop' => 'Está a punto de cancelar el proceso activo de restauración.',
    'backup__domain_backup_file_info' => 'Información del archivo de backup del dominio',
    'backup__domain_backup_file_list' => 'archivos de backup existentes',
    'backup__domain_backup_progress' => 'Progreso de backup del sitio web %1',
    'backup__domain_restore_progress' => 'Progreso de restauración del sitio web %1',
    'backup__domain_backup_progress_elapsed_time' => 'Tiempo transcurrido: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Tiempo transcurrido: %1',
    'backup__ip_map_legend' => 'Asignación de IP',
    'backup__ip_map_list_count' => 'Direcciones IP',
    'backup__domain_restore_session_complete' => 'Dominio %1 restaurado.',
    'backup__domain_restore_session_complete_message' => 'El dominio %1 ha sido restaurado.',
    'backup__domain_backup_file_delete' => 'Se eliminarán los siguientes archivos de backup:',
    'backup__domain_backup_file_for_remove' => 'Seleccione los archivos de backup que desea eliminar',
    'backup__backup_overwrite_file_confirm' => 'Confirmación de reemplazo',
    'backup__backup_overwrite_file_confirm_text' => 'Ya existe un archivo de backup denominado "%1". ¿Desea reemplazarlo?',
    'backup__backup_confirm_overwrite' => 'Confirmar el reemplazo de archivos',
    'backup__backup_overwrite_legeng' => 'Reemplazar',
    'backup__backup_not_contain_domain' => 'El archivo de backup no contiene información acerca del dominio %1',
    'backup__backup_not_contain_client' => 'El archivo de backup no contiene información acerca de la cuenta de cliente %1',
    'backup__backup_client_info' => "Copiar detalles de la cuenta y configuración del cliente",
    'backup__client_backup_progress' => 'Progreso de backup de la cuenta de cliente %1',
    'backup__client_session_complete' => 'Cuenta de cliente %1 copiada',
    'backup__client_backup_file_info' => 'Información del archivo de backup del cliente',
    'backup__restore_client_info' => "Restaurar los detalles de la cuenta y configuración del cliente",
    'backup__client_session_restore' => 'Restaurando la cuenta de cliente %1',
    'backup__client_db_server_map' => 'Asignación de servidores de bases de datos',
    'backup__domain_db_server_map' => 'Asignación de servidores de bases de datos',
    'backup__client_restore_session_complete_message' => 'La cuenta de cliente %1 ha sido restaurada.',
    'backup__client_restore_session_complete' => 'La cuenta de cliente %1 ha sido restaurada.',
    'backup__restore_select_some' => 'Seleccione los objetos que desea restaurar.',
    'backup__client_restore_progress' => 'Progreso de restauración de la cuenta de cliente %1',
    'backup__new_backup' => 'Creando backup nuevo',
    'backup__done' => 'Hecho:',
    'backup__done_domains' => '%1 dominio(s) de %2',
    'backup__done_clients' => '%1 cliente(s) de %2',
    'backup__remaining' => 'Pendiente:',
    'backup__remaining_domains' => '%1 dominio(s)',
    'backup__remaining_clients' => '%1 cliente(s)',
    'backup__overall_backup_progress' => 'Progreso general de backup',
    'backup__comment_n_a' => 'n/d',
    'backup__command_ignore' => 'El comando "%1" es ignorado',
    'backup__no_objects' => 'no hay objetos a copiar',
    'backup__cli_warning_not_enough_ip' => 'ADVERTENCIA: no hay suficientes direcciones IP para realizar el mapeo de IP:',
    'backup__local_repository' => "Almacenamiento de Plesk",
    'backup__ftp_repository' => 'Almacenamiento FTP',
    'backup__ftp_login' => 'Nombre de usuario',
    'backup__ftp_password' => 'Contraseña',
    'backup__ftp_directory_hint' => 'Ejemplo: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'Configuración de la cuenta FTP',
    'backup__ftp_account_preferences' => 'Configuración de la cuenta FTP',
    'backup__repository_not_exist' => 'El directorio no existe',
    'backup__repository_not_readable' => 'No se puede leer el directorio indicado',
    'backup__ftp_repository_not_configure' => 'Si desea utilizar un almacenamiento de backups FTP, en primer lugar <a href="%1">especifique la cuenta FTP</a>.',
    'backup__ftp_repository_list_not_configure' => 'No se ha especificado la configuración de la cuenta',
    'backup__repository_list_unable_listing' => 'No se puede recuperar la lista de archivos',
    'backup__ftp_repository_unable_listing' => 'No se puede recuperar la lista del directorio "%1":',
    'backup__repository_legend' => 'Almacenamiento de archivos de backup',
    'backup__store_in_repository' => 'Guardar archivos en',
    'backup__local_repository_lable' => 'Almacenamiento local',
    'backup__ftp_repository_lable' => 'Almacenamiento FTP',
    'backup__ftp_repository_not_configure_hint' => '(no se ha indicado la configuración de la cuenta)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(no se ha indicado la cuenta FTP o no es soportada)',
    'backup__ftp_directory_not_exist' => 'El directorio indicado no existe',
    'backup__other_user_process_modified' => 'El proceso de backup o migración ha sido detenido por otro usuario.',
    'backup__another_user_exist' => 'La operación en curso fue iniciada por otro usuario de Plesk. Este usuario aún está conectado a Plesk.',
    'backup__ftp_repository_wait' => 'Rogamos espere mientras se recupera la información acerca del almacenamiento FTP',
    'backup__ftp_write_test_failed' => 'No se ha podido escribir los datos de prueba en la cuenta FTP %1:',
    'bt_upload_to_repository' => 'Cargar archivos al almacenamiento local',
    'bt_new_restore' => "Restaurar",
    'bt_backup_schedule' => "Programar backup",
    'backup_exist_backups' => "Archivos de backup existentes",
    'backup_dialog__page_title' => "Creación de un archivo de backup",
    'backup_dialog__please_wait' => "El proceso de backup está a punto de empezar. Este proceso puede tardar unos minutos. Espere...",
    'backup_conf__page_title' => 'Configuración de backups',
    'bt_accept' => "Aceptar",
    'bt_access' => "Acceso",
    'bt_action_log' => "Registro de acciones",
    'bt_add' => "Añadir",
    'bt_add_client' => "Asignar a usuarios",
    'bt_database_server_add' => 'Añadir servidor de bases de datos',
    'bt_add_services' => "Añadir servicios",
    'bt_anonftp_stats' => "Estadísticas FTP anon.",
    'bt_anonymous_ftp' => "FTP anónimo",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Adjuntar",
    'bt_autoinstaller' => 'Actualizador',
    'bt_auto-updates' => 'Actualizador',
    'bt_back' => "<< Atrás",
    'bt_backup' => "Copiar",
    'bt_backup_configure' => "Configuración de backup",
    'bt_buy_certs' => "Comprar certificados",
    'bt_blocked_domains' => 'Lista negra',
    'bt_blocked_domain_add' => 'Añadir dominio',
    'bt_card' => "Tarjeta",
    'bt_cert' => "Certificado",
    'bt_certificates' => "Certificados",
    'bt_change_passwd' => "Cambiar contraseña",
    'bt_clear' => "Borrar",
    'bt_client_templates' => "Plantillas de cliente",
    'bt_clients' => "Clientes",
    'bt_codepage_change' => 'Cambiar codificación',
    'bt_comp_info' => "Administración de componentes",
    'bt_configure_maillists' => "Configurar Mailman",
    'bt_configure_odbc' => "Orígenes de datos ODBC",
    'bt_configure' => 'Configurar',
    'bt_copy' => "Copiar",
    'bt_copy_move' => "Copiar/Mover",
    'bt_create' => "Crear",
    'bt_create_account' => "Crear una cuenta",
    'bt_create_dir' => "Añadir un directorio",
    'bt_create_file' => "Añadir un archivo",
    'bt_count_size' => "Calcular tamaño",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Programador de tareas",
    'bt_custom_button_new' => "Añadir un botón",
    'bt_custom_buttons' => "Botones personalizados",
    'bt_customize' => "Personalizar",
    'bt_databases' => "Bases de datos",
    'bt_database_servers' => 'Servidores de bases de datos',
    'bt_sqlservers' => "Servidores de bases de datos",
    'bt_db_usr_new' => "Añadir un usuario de base de datos",
    'bt_db_new' => "Añadir una base de datos",
    'bt_db_phpmyadmin' => "Admin MySQL",
    'bt_dbuser_default' => "Predeterminado para DB Webadmin",
    'bt_decline' => "Rechazar",
    'bt_default' => "Predeterminado",
    'bt_defaultcomponents' => "Servicios de terceros",
    'bt_defaults' => "Predeterminados",
    'bt_delete' => "Eliminar",
    'bt_directories' => "Directorios protegidos",
    'bt_disable' => "Desactivar",
    'bt_dns' => "Configuración DNS",
    'bt_dns_enable' => 'Activar',
    'bt_dns_disable' => 'Desactivar',
    'bt_dns_default' => 'Restablecer a predeterminado',
    'bt_dns_zone_sync' => 'Aplicar cambios de plantilla DNS',
    'bt_dnsrecord_add' => 'Añadir registro',
    'bt_do_backup' => "Copiar",
    'bt_do_restore' => "Restaurar",
    'bt_do_upload' => "Cargar",
    'bt_domain_aliases' => "Alias de dominio",
    'bt_domain_templates' => "Plantillas de dominio",
    'bt_domain_user' => "Administrador del dominio",
    'bt_domain_user_passwd' => "Contraseña del administrador del dominio",
    'bt_domains' => "Dominios",
    'bt_domain_alias_add' => 'Añadir alias de dominio',
    'bt_download' => "Descargar",
    'bt_edit' => "Editar",
    'bt_enable' => "Activar",
    'bt_export' => 'Exportar',
    'bt_extras' => "Extras",
    'bt_file_manager' => "Administrador de archivos",
    'bt_finish' => "Finalizar",
    'bt_ftp_account' => "Propiedades de la cuenta FTP",
    'bt_forget_password' => "¿Ha olvidado la contraseña?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Estadísticas FTP",
    'bt_get_password' => "Obtener contraseña",
    'bt_global_changes' => "Modificar",
    'bt_help' => "Ayuda",
    'bt_hide_aliases' => "Ocultar alias",
    'bt_hide_toolbar' => 'Ocultar barra de herramientas',
    'bt_hide_subdomains' => "Ocultar subdominios",
    'bt_hide_domainaliases' => "Ocultar alias de dominio",
    'bt_home' => "Inicio",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Instalar",
    'bt_ip_aliasing' => "Direcciones IP",
    'bt_ip_add' => "Añadir dirección IP",
    'bt_ip_pool' => "Grupo de direcciones IP",
    'bt_key_info' => "Administración de licencias",
    'bt_key_buyonline_addons' => 'Comprar complementos para Plesk',
    'bt_key_buyonline_upgrades' => 'Comprar actualizaciones de Plesk',
    'bt_key_buyonline_new' => 'Comprar llave nueva',
    'bt_key_update' => 'Recuperar llaves',
    'bt_key_upload' => 'Instalar llave',
    'bt_key_download' => 'Descargar llave',
    'bt_key_revert' => 'Revertir llave',
    'bt_limits' => "Límites",
    'bt_locale_add' => 'Añadir idioma',
    'bt_locales' => 'Idiomas',
    'bt_log_manager' => "Administrador de registros",
    'bt_login' => "Iniciar sesión",
    'bt_login_vzpp' => "Acceder a Power Panel",
    'bt_logo' => "Personalización",
    'bt_logo_send_link' => "Adjuntar enlace",
    'bt_logo_send_logo' => "Adjuntar logo",
    'bt_logout' => "Cerrar sesión",
    'bt_logrotation' => "Rotación de registros",
    'bt_mail' => "Correo",
    'bt_mail_alias_add' => "Añadir alias de correo",
    'bt_mail_aliases' => "Alias de correo",
    'bt_mail_group_add' => "Añadir miembro",
    'bt_mail_groups' => "Grupos",
    'bt_mail_name_add' => "Añadir cuenta de correo",
    'bt_mail_preferences' => "Configuración",
    'bt_mail_group' => "Grupo de correo",
    'bt_mail_mailbox' => "Buzón de correo",
    'bt_mail_redirect' => "Redireccionamiento",
    'bt_mail_resp_add' => "Añadir respuesta automática",
    'bt_mail_resp_attach_add' => "Añadir adjunto",
    'bt_mail_resp_files' => "Archivos adjuntos",
    'bt_mail_responders' => "Respuestas automáticas",
    'bt_mail_spamfilter' => "Filtro antispam",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Añadir lista de correo",
    'bt_maillists' => "Listas de correo",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Crear backup",
    'bt_manage' => "Administrar",
    'bt_master' => "Principal",
    'bt_migrate' => 'Migrar',
    'bt_modules_add' => 'Añadir extensión',
    'bt_modules_manage' => 'Administrar extensiones',
    'bt_move' => "Mover",
    'bt_mimetypes' => 'Tipos MIME',
    'bt_mimetype_new' => 'Añadir tipo MIME',
    'bt_new_client' => "Añadir cuenta de cliente",
    'bt_new_domain' => "Añadir dominio",
    'bt_next' => "Siguiente >>",
    'bt_next_page' => "Siguiente",
    'bt_network_add' => "Añadir red",
    'bt_notifications' => "Notificaciones",
    'bt_odbc_dsn_add' => "Añadir DSN ODBC",
    'bt_off' => "Deshabilitado",
    'bt_on' => "Habilitado",
    'bt_on_off' => "Encendido/Apagado",
    'bt_pd_new' => "Añadir directorio protegido",
    'bt_pd_user_new' => "Añadir usuario",
    'bt_performance' => 'Rendimiento',
    'bt_permissions' => "Permisos",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Configuración",
    'bt_prev_page' => "Ant",
    'bt_preview' => 'Previsualizar el sitio',
    'bt_print' => "Imprimir",
    'bt_reboot' => "Reiniciar",
    'bt_reload' => "Volver a cargar",
    'bt_refresh' => "Actualizar",
    'bt_register' => "Registrar",
    'bt_remove' => "Eliminar",
    'bt_enable_selected' => 'Activar',
    'bt_disable_selected' => 'Desactivar',
    'bt_repair_ip' => "Reparar IP",
    'bt_report' => "Informe",
    'bt_report_auto' => 'Entrega de informes',
    'bt_report_auto_new' => 'Añadir programación de entrega',
    'bt_report_new' => "Añadir diseño",
    'bt_reset' => "Restablecer",
    'bt_restart_services' => "Administración de servicios",
    'bt_save' => "Guardar",
    'bt_send_by_email' => "Enviar por email",
    'bt_send_file' => "Enviar archivo",
    'bt_send_mail' => "Enviar correo",
    'bt_send_passwd' => "Enviar contraseña",
    'bt_send_text' => "Enviar texto",
    'bt_server' => "Servidor",
    'bt_server_add' => "Añadir servidor",
    'bt_server_preferences' => "Configuración del servidor",
    'bt_servers_list' => "Servidores",
    'bt_sessions' => "Sesiones",
    'bt_set' => "Establecer",
    'bt_set_as_default' => "Predeterminado",
    'bt_setup' => 'Configurar',
    'bt_show_aliases' => "Mostrar alias",
    'bt_show_subdomains' => "Mostrar subdominios",
    'bt_show_domainaliases' => "Mostrar alias de dominio",
    'bt_shutdown' => "Apagar",
    'bt_site_apppkgs' => "Inventario de aplicaciones",
    'bt_site_apppool' => "Grupo de aplicaciones",
    'bt_application-pool' => "Aplicaciones web",
    'bt_site_apps' => "Aplicaciones web",
    'bt_site_app_add' => "Instalar aplicación",
    'bt_additional_key_upload' => 'Cargar llave nueva',
    'bt_additional_key_download' => 'Descargar llave',
    'bt_additional_key_remove' => 'Eliminar llave',
    'bt_additional_key_activate' => 'Activar',
    'bt_site_builder' => "Soporte de Presence Builder",
    'bt_skeleton' => 'Plantilla de host virtual',
    'bt_skins' => 'Skins',
    'bt_skin_add' => 'Añadir skin',
    'bt_skin_manual' => 'Referencia de skins personalizados de Plesk', // not used
    'bt_skin_download' => 'Descargar skin',
    'bt_skin_replace' => 'Actualizar skin',
    'bt_skip' => 'Omitir',
    'bt_spamassassin' => "Filtro antispam",
    'bt_spamassassin_train' => "Seguimiento",
    'bt_spamfilter' => "Filtro antispam",
    'bt_sshterm' => 'Terminal SSH',
    'bt_start' => "Iniciar",
    'bt_stop' => "Detener",
    'bt_recycle' => "Reciclar",
    'bt_statistics' => "Estadísticas",
    'bt_subdomain_new' => "Añadir subdominio",
    'bt_subdomains' => "Subdominios",
    'bt_submit' => "Enviar",
    'bt_summary_report' => "Informe resumido",
    'bt_support' => "Soporte",
    'bt_switch' => "Cambiar",
    'bt_system_time' => "Fecha y hora del sistema",
    'bt_task_new' => "Añadir tarea",
    'bt_dom_tmpl_add' => 'Añadir plantilla de dominio',
    'bt_cl_tmpl_add' => 'Añadir plantilla de cliente',
    'bt_cron_backup' => 'Configuración de backups programados',
    'bt_test' => "Verificar conexión",
    'bt_text' => "Texto",
    'bt_touch' => "Cambiar fecha",
    'bt_traffic' => "Tráfico",
    'bt_traffic_history' => "Historial de tráfico",
    'bt_update' => "Actualizar",
    'bt_upload' => "Cargar",
    'bt_upload_from_ftp' => "Carga FTP",
    'bt_virtualdirs' => 'Directorios virtuales',
    'bt_virtualdir_new' => 'Añadir directorio virtual',
    'bt_virtualdir_add' => 'Añadir directorio virtual',
    'bt_web_app_new' => "Instalar aplicación en Java",
    'bt_web_stats' => "Estadísticas web",
    'bt_web_stats_ssl' => "SSL/TLS estad Web",
    'bt_web_user_add' => "Añadir usuario web",
    'bt_web_users' => "Usuarios web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "Configuración de estadísticas web",
    'bt_hidden-referrer-add' => 'Ocultar entradas',
    'bt_group-referrer-add' => 'Grupos de referencias',
    'bt_whats_new_full' => "Ver la lista completa de cambios",
    'bt_white_list' => "Lista blanca",
    'bt_white_list_add' => "Añadir red",
    'cert_add__unable_set_ca_cert' => "No se puede establecer el certificado CA: %1",
    'cert_add__unable_set_cert' => "No se puede establecer el certificado: %1",
    'cert_add__unable_set_private_key' => "No se puede establecer la clave privada: %1",
    'certificates_list__certificate_used_as_default' => "Uno de los certificados que va a eliminar se utiliza como certificado predeterminado.",
    'certificates_list__certificates_assigned_on_ip' => "Uno o más certificados están asignados a las direcciones IP/dominios.",
    'ch_pass__admin_pass' => "Cambio de la contraseña del administrador",
    'ch_pass__old_pass' => "Contraseña anterior",
    'ch_pass__pass_confirm' => "Confirmar",
    'ch_pass__unable_change_admin_pass' => "No se pudo cambiar la contraseña del administrador: %1",
    'check_mail_cycle__aliases' => "Ciclo de email detectado, la dirección \"%1\" está incluida en el alias de esta cuenta de correo.",
    'check_mail_cycle__autoresponders' => "Ciclo de email detectado, la dirección \"%1\" se incluye en las respuestas automáticas de esta cuenta de correo.",
    'check_mail_cycle__mail_groups' => "Ciclo de email detectado, la dirección \"%1\" se encuentra dentro del grupo de correo de esta cuenta de correo.",
    'check_mail_cycle__mail_name' => "Ciclo de email detectado, la dirección \"%1\" coincide con esta cuenta de correo.",
    'check_mail_cycle__redirect' => "Ciclo de correo detectado, la dirección \"%1\" coincide con el redireccionamiento de esta cuenta de correo.",
    'check_mail_dup__redirect' => "Redireccionamiento duplicado detectado. La dirección \"%1\" coincide con la dirección de redireccionamiento de esta cuenta de correo.",
    'check_mail_dup__mail_groups' => "Redireccionamiento duplicado detectado. La dirección \"%1\" está incluida en el grupo de correo de esta cuenta de correo.",
    'check_maillist_cycle__admin' => "Bucle de correo detectado. El email del administrador \"%1\" coincide con la dirección de una lista de correo.",
    'check_maillist_cycle__member' => "Bucle de correo detectado. La dirección \"%1\" coincide con la dirección de la lista de correo.",
    'chk_js__enter_login_and_passwd' => "Indique el nombre de usuario y la contraseña.",
    'chk_js__enter_login_name' => "Indique el nombre de usuario.",
    'chk_js__enter_passwd' => "Indique la contraseña.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Información de la cuenta de %1",
    'cl_limits__cl' => "Límites del cliente %1",
    'cl_logo__setup_logo_pref' => "Establecer propiedades del logo para el cliente %1",
    'cl_new__enter_new_cl_data' => "Indique la información del cliente nuevo",
    'cl_new__unable_to_sent_notification' => 'Se ha creado la cuenta de usuario, pero no se ha podido enviar ningún aviso al cliente: %1',
    'cl_perm__all_ip' => "Todas las IPs disponibles",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Todas las cuentas de hosting basadas en IP para el cliente se transferirán a basadas en nombre.",
    'cl_perm__allow_client_create_domain' => "Los campos que intenta seleccionar solo son aplicables en el caso de clientes que puedan crear dominios.",
    'cl_perm__allow_create_nb_w_ip' => "El cliente puede crear hosting basado en nombres utilizando %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Permitir la creación de cuentas de hosting basadas en IP",
    'cl_perm__available_ips' => "IPs disponibles",
    'cl_perm__change_limits' => "Definición de límites",
    'cl_perm__cl_disk_space' => "Total de espacio en disco disponible",
    'cl_perm__cl_expiration' => "Periodo de validez de cuenta de cliente",
    'cl_perm__cl_max_box' => "Buzones de correo",
    'cl_perm__cl_max_db' => "Bases de datos",
    'cl_perm__cl_max_dom' => "Dominios",
    'cl_perm__cl_max_maillists' => "Listas de correo",
    'cl_perm__cl_max_subdom' => "Subdominios",
    'cl_perm__cl_max_traffic' => "Cantidad total de tráfico disponible",
    'cl_perm__cl_max_wu' => "Usuarios web",
    'cl_perm__cl_mbox_quota' => "Límite de tamaño del buzón de correo para esta cuenta de usuario",
    'cl_perm__current_maximum_exp_date' => "El valor actual máximo de periodo de validez del dominio es %1; solicitado %2",
    'cl_perm__current_maximum_mailbox_quota' => "El límite definido en este momento para el espacio en disco asignado para alojar buzones de correo en esta cuenta de usuario es %1; solicitado %2",
    'cl_perm__current_total_requested' => "El valor actual total de límites del dominio para %1 es %2; solicitado %3.",
    'cl_perm__current_total_requested_dom' => "El número actual de %1 perteneciente a este cliente es %2; solicitado %3.",
    'cl_perm__disk_space' => "cantidad máxima de espacio en disco",
    'cl_perm__dashboard_stdgui' => 'Interfaz de usuario',
    'cl_perm__dashboard' => 'Vista de la página principal',
    'cl_perm__stdgui' => 'Vista estándar',
    'cl_perm__manage_dashboard' => 'Administración de la página principal',
    'cl_perm__dashboard_and_stdgui' => 'Se permite la vista de la página principal y la vista estándar',
    'cl_perm__dashboard_only' => 'Solo se permite ver la página principal',
    'cl_perm__stdgui_only' => 'Solo se permite la vista estándar',
    'cl_perm__edit_cl' => "Permisos del cliente %1",
    'cl_perm__exp_date_exceeded' => "El periodo de validez que está intentando establecer excede el límite especificado dentro de los dominios individuales relacionados con este cliente.",
    'cl_perm__invalid_value' => "El valor no es correcto. Solo se permite el uso de dígitos.",
    'cl_perm__limit_disk_space' => "%1 Limitar cantidad total de espacio en disco",
    'cl_perm__limit_expiration' => "%1 Limitar el periodo de validez para la cuenta de cliente",
    'cl_perm__limit_max_box' => "%1 Limitar nº máximo de buzones de correo",
    'cl_perm__limit_max_db' => "%1 Limitar nº máximo de bases de datos",
    'cl_perm__limit_max_dom' => "%1 Limitar nº máximo de dominios",
    'cl_perm__limit_max_maillists' => "%1 Limitar nº máximo de listas de correo",
    'cl_perm__limit_max_subdom' => "%1 Limitar nº máximo de subdominios",
    'cl_perm__limit_max_traffic' => "%1 Limitar cantidad total de tráfico",
    'cl_perm__limit_max_wu' => "%1 Limitar nº máximo de usuarios web",
    'cl_perm__limit_mbox_quota' => "%1 Establecer la cuota de buzón",
    'cl_perm__limits_exceeded' => "Uno o algunos de los límites que está intentando establecer ya han sido excedidos por los límites definidos dentro de los dominios individuales pertenecientes a este cliente. El límite total para el cliente debe ser igual o superior a la suma total de los límites de dominio definidos para esta cuenta de cliente.",
    'cl_perm__mailbox_quota_exceeded' => "El límite de cantidad de espacio en disco asignado para buzones que está intentando establecer excede el límite definido dentro de los dominios individuales relacionados con esta cuenta de cliente.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "El límite de espacio en disco asignado para los buzones que está intentando definir excede la limitación impuesta a nivel de servidor.",
    'cl_perm__make_dumps' => "Copia y restauración de datos",

    'cl_perm__max_box' => "nº máximo de buzones",
    'cl_perm__max_db' => "nº máximo de bases de datos",
    'cl_perm__max_dom' => "dominios",
    'cl_perm__max_maillists' => "nº máximo de listas de correo",
    'cl_perm__max_subdom' => "subdominios",
    'cl_perm__max_traffic' => "cantidad máxima de tráfico",
    'cl_perm__max_wu' => "nº máximo de usuarios web",
    'cl_perm__max_dom_aliases' => "alias de dominio",
    'cl_perm__mbox_quota' => "cuota de buzón",
    'cl_perm__not_allow_create_nb_hst' => "El cliente no puede crear hosting basado en nombres.",
    'cl_perm__select_ip_addrs' => "Seleccionar direcciones IP",
    'cl_perm__this_ip_used_vrt_hst' => "Esta dirección IP es usada por el hosting virtual. Para eliminar esta dirección IP, elimine el servicio de hosting o cambie su tipo a basado en nombres.",
    'cl_perm__unable_off_ipb_creating' => "El cliente ya tiene configurado el servicio de hosting basado en IP. Para desactivar esta prestación para el cliente, deseleccione la casilla \"Creación de dominio\" o elimine todas las cuentas de hosting basadas en IP.",
    'cl_perm__unable_off_nb_creating' => "El cliente ya tiene configurado el servicio de hosting basado en nombres. Para desactivar esta prestación para el cliente, deseleccione la casilla \"Creación de dominio\" o elimine todas las cuentas de hosting basadas en nombres.",
    'cl_perm__unable_set_domain_limit' => "No se pudo limitar el número máximo de dominios porque el cliente ya tiene %1 dominios",
    'cl_perm__unable_update_client_limitations' => "No se han podido modificar los límites de la cuenta de cliente: %1",
    'cl_pref__edit_cl' => "Preferencias del cliente %1",
    'class_anonftp__create_ftp_domain' => "No existe ningún dominio FTP virtual para este dom_id. Intente crearlo primero.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "El límite de espacio en disco que está intentando establecer (%1) no debería exceder el límite total de espacio en disco definido a nivel de dominio (%2).",
    'class_anonftp__invalid_input_only_digits' => "El valor indicado no es válido. Solo se permite el uso de dígitos.",
    'class_anonftp__unable_change_ownerships' => "No se puede cambiar la propiedad o permisos para el archivo de cuota: %1",
    'class_anonftp__unable_copy_quota_file' => "No se puede copiar el archivo de cuota: %1",
    'class_anonftp__unable_get_disk_usage' => "No se puede recuperar la información de uso de disco en el directorio entrante: %1",
    'class_anonftp__unable_parse_quota_file' => "No se puede analizar el archivo de cuotas.",
    'class_anonftp__unable_read_quota_file' => "No se puede leer el archivo de cuotas: %1",
    'class_anonftp__unable_update_quota' => "No se pudo actualizar la cuota porque los archivos del directorio entrante usan %1 KBs de espacio en disco, lo que excede el valor de cuota nuevo.",
    'class_anonftp__unable_write_temp_file' => "No se ha podido escribir en el archivo temporal: %1",
    'class_bsdomain__warn_max_date__' => "La fecha de expiración se estableció a %1",
    'class_cList__empty' => "Ningún elemento.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "No se encontraron coincidencias para <b>\"%1\"</b> en %2 (%3 de %4)",
    'class_cList__search_result' => "Resultado de la búsqueda para <b>\"%1\"</b> en %2 (%3 de %4)",
    'class_client__client_creation_notification' => "Aviso de creación de cliente.",
    'class_client__client_with_contact_name_already_exists' => "Ya existe un cliente denominado %1.",
    'class_client__disk_space' => "Espacio en disco",
    'class_client__invalid_max_dom' => "El valor del número de dominios no es válido. Solo se permite el uso de dígitos.",
    'class_client__limit_exceed' => "La cantidad solicitada de %1 no puede ser asignada porque se excederían las asignaciones para la cuenta %2 del cliente (%3). Si desea asignar más recursos, vaya a Clientes > nombre del cliente > Límites y cambie las asignaciones. Una vez hecho esto, vuelva a esta página e intente modificar las asignaciones de nuevo.",
    'class_client__limit_exceed_unlimited' => "Si desea asignar una cantidad ilimitada de recursos (%1), primero vaya a Clientes > nombre del cliente > Límites y seleccione la casilla Ilimitado correspondiente al tipo de recurso deseado. Una vez hecho esto, vuelva a esta página e intente modificar las asignaciones de nuevo.",
    'class_client__max_box' => "Buzones de correo",
    'class_client__max_db' => "Bases de datos",
    'class_client__max_maillists' => "Listas de correo",
    'class_client__max_subdom' => "Subdominios",
    'class_client__max_traffic' => "Tráfico máximo",
    'class_client__max_wu' => "Usuarios web",
    'class_client__max_dom_aliases' => "Alias de dominio",
    'class_client__mbox_quota' => "Cuota de buzón",
    'class_client__unable_define_cl_status' => "No se puede definir el estado de la cuenta de cliente: %1",
    'class_client__unable_define_inactive_dom' => "No se pueden definir dominios inactivos %1.",
    'class_client__unable_del_ip' => "No se pueden eliminar las IPs: %1",
    'class_db__db_name_not_set' => "Nombre de la base de datos no definido.",
    'class_db__db_not_exist_for_curr_dom' => "La base de datos no existe para este dominio.",
    'class_db__invalid_db_or_dom_name' => "El ID de la base de datos o dominio no es válido o el nombre de la base de datos no está definido.",
    'class_db__invalid_pass' => "Contraseña no válida.",
    'class_db__mailgrp_member_exist' => "El miembro del grupo de correo ya existe.",
    'class_db__access_hosts_notsupport' => 'La opción de acceso a hosts no es soportada para este tipo de base de datos',
    'class_db__unable_add' => 'No se puede añadir el registro de acceso de host: %1',
    'class_db__unable_del' => 'No se puede eliminar el registro de acceso de host: %1',
    'class_db__inc_user_not_exist' => 'El usuario de base de datos "%1" no existe',
    'class_db__inc_access_record_exist' => 'Este registro de acceso ya existe',
    'class_db__inc_access_record_not_exist' => 'El registro de acceso introducido no existe',
    'class_db__inc_unable_del_last_record' => 'No se puede eliminar el último registro de acceso',
    'class_domtmpleditform__dns_master' => "Principal",
    'class_domtmpleditform__dns_slave' => "Secundaria",
    'class_domtmpleditform__dns_type' => "Tipo de zona DNS del dominio",
    'class_traffichistory__no_data_available' => "No hay datos disponibles.",
    'class_traffichistory__reten_pref' => 'Configuración de almacenamiento de estadísticas de tráfico y web',
    'class_traffichistory__traffic_usage' => "Uso de tráfico",
    'clienttrafficlist_header' => "Tráfico en los dominios",
    'clienttrafficlist_header_of_client__' => "Tráfico en los dominios del cliente %1",
    'cmd_dns__a_dns_record_already_exist' => "Este registro entrará en conflicto con el registro A para la zona.",
    'cmd_dns__domain_last_ns' => 'No es posible eliminar el último registro NS DNS para el dominio.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Nombre de dominio canónico no válido.",
    'cmd_dns__cname_dns_record_already_exist' => "Este registro entrará en conflicto con el registro CNAME para la zona.",
    'cmd_dns__cname_in_rr_combination' => 'Existe una combinación incorrecta de registros DNS en la zona DNS',
    'cmd_dns__cname_coexist_with_data' => 'Un registro de zona DNS CNAME no puede coexistir con otros registros DNS en la misma zona.',
    'cmd_dns__dns_record_type_is_invalid' => "Tipo de registro DNS no válido.",
    'cmd_dns__ext_host_is_not_resolved' => "El nombre canónico %1 no resuelve a un registro A o AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'No se pudo añadir el registro %1 a la zona %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Nombre del intercambiador de correo no válido.",
    'cmd_dns__mx_priority_is_invalid' => "Prioridad MX no válida.",
    'cmd_dns__name_server_is_invalid' => "Servidor de nombres no válido.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "El valor de máscara de red debería de ser 24, 16 o 8.",
    'cmd_dns__this_dns_record_already_exists' => "Este registro DNS ya existe.",
    'cmd_dns__unable_add_record' => "No se puede añadir el registro '%1': %2",
    'cmd_dns__unable_add_a_record' => "No se puede añadir registro A: %1",
    'cmd_dns__unable_add_cname_record' => "No se puede añadir el registro CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "No se puede añadir el registro DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "No se puede añadir el registro EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "No se puede añadir el registro NS: %1",
    'cmd_dns__unable_add_ptr_record' => "No se puede añadir el registro PTR: %1",
    'cmd_dns__unable_add_txt_record' => "No se puede añadir el registro TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "No se puede crear la zona DNS %1",
    'cmd_dns__unable_define_dns_record' => "No se puede definir el registro DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "No se puede obtener el estado de la zona DNS predeterminada: %1",
    'cmd_dns__unable_insert_a_record' => "No se puede introducir el registro A: %1",
    'cmd_dns__unable_insert_mx_record' => "No se puede introducir el registro MX: %1",
    'cmd_dns__unable_insert_ns_record' => "No se puede introducir el registro NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "No se puede establecer el estado de la zona DNS: %1",
    'cmd_domains__dom_already_exists' => "El dominio %1 ya existe.",
    'cmd_domains__dns_record_already_exists' => "No se puede crear el dominio %1 porque ya existe un registro DNS que apunta al host %1.",
    'cmd_domains__dom_already_exists1' => "En este dominio existen %2 subdominios. El dominio %1 ya existe.",
    'cmd_domains__dom_already_exists2' => "el subdominio %1 ya existe.",
    'cmd_domains__dalias_already_exists' => "Este alias ya existe.",
    'cmd_domains__domain_alias_already_exists' => 'Ya existe un alias de dominio con este nombre.',
    'cmd_domains__unable_del_mail_for_dom' => "No se pueden eliminar los servicios de correo para el dominio: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "No se pudo eliminar la cuenta FTP anónimo para el dominio: %1",
    'cmd_domains__unable_update_dom_param' => "No se pueden actualizar los parámetros del dominio: %1.",
    'cmd_domains__unable_rename_client_exist' => "el nombre de usuario del administrador del dominio ya está en uso.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "El tipo de hosting no es físico.",
    'cmd_hosting__unable_create_user' => "No se puede crear el usuario %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "No se puede definir la dirección IP para los hosts virtuales basados en nombres: %1",
    'cmd_hosting__unable_del_old_hst' => "No se puede eliminar el hosting configurado previamente: %1",
    'cmd_hosting__unable_del_protected_directory' => "No se puede eliminar el directorio protegido: %1.",
    'cmd_hosting__unable_del_web_user' => "No se puede eliminar el usuario web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "No se puede crear o actualizar el host virtual: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "No se puede configurar el hosting de redireccionamiento por marcos.",
    'cmd_hosting__unable_rebuild_ftp_config' => "No se puede recrear el archivo de configuración de proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "No se puede configurar SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "No se puede eliminar la protección del directorio SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "No se puede actualizar la URL de destino %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "No se puede actualizar la zona DNS para el dominio: error de ejecución de la utilidad.",
    'cmd_hosting__unable_update_ftp_passwd' => "No se puede actualizar la contraseña FTP %1.",
    'cmd_hosting__unable_update_user' => "No se puede actualizar el usuario %2: %1",
    'cmd_hosting__unknown_hst_type' => "Tipo de hosting desconocido.",
    'cmd_hosting__you_not_have_permission_del_hst' => "No tiene permisos para finalizar el servicio de hosting.",
    'cmd_mail__autoresponder__not_configured' => "No se ha configurado la respuesta automática para esta cuenta de correo",
    'cmd_mail__addr_already_used_in_mail_redirect' => "La dirección %1 ya está siendo usada para el reenvío de correo.",
    'cmd_mail__alias_already_exists' => "el alias ya existe.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "El ID de la respuesta automática y el ID de la cuenta de correo no coinciden.",
    'cmd_mail__autoresp_id_is_undefined' => "No se ha definido el ID de la respuesta automática.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Ya existe un alias de correo con este nombre para la cuenta de correo %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "La cuenta de correo %1 ya está suscrita a esta lista de correo.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "La cuenta de correo %1 ya existe en este dominio.",
    'cmd_mail__mail_name_not_exist' => "La cuenta de correo no existe.",
    'cmd_mail__mail_name_passwd_part' => "La contraseña no debe de contener el nombre de la cuenta de correo.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "La lista de correo %1 ya existe en este dominio.",
    'cmd_mail__mailname_already_exist_in_mg' => "La cuenta de correo %1 ya existe en un grupo de correo.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "La cuenta de correo %1 ya existe en este dominio.",
    'cmd_mail__mailname_already_exists' => "La cuenta de correo ya existe.",
    'cmd_mail__mailname_is_invalid' => "El nombre de la cuenta de correo %1 no es válido.",
    'cmd_mail__mailname_unable_update' => "No se pudieron actualizar las propiedades de la cuenta de correo:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Se ha alcanzado el número máximo de respuestas automáticas para este dominio.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Se ha alcanzado el número máximo de grupos de correo para este dominio.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Se ha alcanzado el número máximo de redireccionamientos para este dominio.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Se ha alcanzado el número máximo de buzones de correo.",
    'cmd_mail__no_members_specified' => "ningún miembro especificado.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "La contraseña es demasiado fácil. Elija otra.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Esta dirección de email ya está siendo usada.",
    'cmd_mail__unable_define_autoresp_id' => "No se puede definir el ID de la respuesta automática %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Error al cambiar la configuración del servicio de correo para el dominio %1",
    'cmd_mail__unable_del_mail_for_dom' => "No se puede eliminar el servicio de correo del dominio %1.",
    'cmd_mail__unable_del_mail_redirection' => "No se puede eliminar el servicio de reenvío de correo %1.",
    'cmd_mail__unable_remove_autoresp' => "No se pueden eliminar las respuestas automáticas: %1",
    'cmd_mail__unable_remove_mail_group_members' => "No se pueden eliminar los miembros del grupo de correo: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Error al desactivar el grupo de correo: %1",
    'cmd_mail__unable_update_mail_redirect' => "No se puede volver a configurar el servicio de reenvío de correo %1.",
    'cmd_mail__uploaded_file_is_too_big' => "El archivo cargado es demasiado grande.",
    'cmd_mail__additionally' => "Además:",
    'cmd_pd__invalid_login' => "Nombre de usuario incorrecto.",
    'cmd_pd__this_user_already_exist' => "Este usuario ya existe.",
    'cmd_pd__unable_define_hst_type' => "No se puede definir el tipo de hosting.",
    'cmd_pd__unable_upd_pd_usr' => "No se pueden actualizar las propiedades del usuario del directorio protegido: %1.",
    'cmd_pd__user_is_undefined' => "Usuario no definido.",
    'cmd_server__no_enough_free_disk_space' => "Espacio en disco insuficiente.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "la contraseña anterior es incorrecta. Inténtelo de nuevo.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "se ha alcanzado el nº máximo de usuarios web para este dominio.",
    'cmd_web_usr__unable_create_user' => "no se pudo crear el usuario del sistema: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "no se puede definir el nº máximo de usuarios web: %1",
    'cmd_web_usr__user_already_exists' => "el usuario ya existe.",
    'cmd_web_usr__web_user_name_is_invalid' => "nombre de usuario web %1 no es válido.",
    'cmd_web_usr__web_user_not_exist' => "el usuario web no existe.",
    'common_func__exec_bad_argument' => "El argumento exec no debe contener el símbolo de una sola comilla.",
    '__eol' => 'Saltos de línea',
    'eol__binary_file' => 'No se puede cambiar el estilo de salto de línea en un archivo binario.',
    'comp_info__header' => 'Componentes',
    'comp_info__comp_name' => "Nombre del componente",
    'comp_info__comp_disabled' => 'Desactivado',
    'comp_info__comp_active' => 'Activos',
    'comp_info__comp_not_configured' => 'No configurado',
    'comp_info__comp_not_started' => 'No iniciado, compruebe la configuración del componente',
    'comp_info__comp_version' => "Versión del componente",
    'comp_info__integration_error' => "Error de integración",
    'comp_info__title' => "Componentes de Plesk",
    'comp_info__service_name' => "Servicio",
    'comp_info__last_updated' => '(última actualización: %1)',
    'configure__full_hostname' => "Nombre de host completo",
    'cp_access_admin_deny' => "El acceso del administrador desde la dirección '%1' está restringido de acuerdo con la directiva de restricción de acceso IP usada en este momento.",
    'create_domain_warn__' => "Durante la creación del dominio se realizaron las siguientes excepciones:",
    'create_domain__client_select' => 'Seleccione el cliente para el que desea crear el dominio',

    'dashboard__nav_button_name' => "Inicio",
    'dalias__list_title' => 'Alias de dominio del dominio %1',
    'dalias__list_legend' => 'Alias de dominio',
    'dalias__list_header' => 'Alias de dominio',
    'dalias__list_status' => 'Estado',
    'dalias__list_name' => 'Nombre del alias de dominio',
    'dalias__list_ascii_name' => 'En formato ASCII',
    'dalias__remove_title' => 'Se eliminarán los siguientes alias de dominio del dominio %1:',
    'dalias__select_domain_aliases_to_remove' => 'Seleccione los alias de dominio a eliminar.',
    'dalias__mail_turn_on_failed' => 'No se puede activar el servicio de correo: %1',
    'dalias__web_turn_on_failed' => 'No se puede activar el servicio web: %1',
    'db_usr_edit__db_usr_name_old' => "Nombre de usuario anterior de la base de datos",
    'databases__db_admin_passwd' => "Contraseña del administrador",
    'databases__db_confirm_passwd' => "Confirmar contraseña",
    'database_server_database_list__client' => 'Cliente',
    'database_server_database_list__domain' => 'Dominio',
    'database_server_database_list__header' => 'Bases de datos',
    'database_server_database_list__name' => 'Nombre',
    'database_server_databases_form__databases_list_legend' => 'Bases de datos',
    'database_server_databases_form__remove_empty_selection' => 'No ha seleccionado ninguna base de datos.',
    'database_server_databases_form__remove_title' => 'Se eliminarán las siguientes bases de datos:',
    'database_server_databases_form__tab' => 'Bases de datos (%1)',
    'database_server_edit_form__admin_login' => "Nombre de usuario",
    'database_server_edit_form__admin_password' => "Contraseña",
    'database_server_edit_form__admin_password2' => "Confirmar contraseña",
    'database_server_change_passwd_form__tab' => 'Contraseña del administrador',
    'database_server_edit_form__default' => 'Utilizar este servidor como predeterminado para %1',
    'database_server_edit_form__duplicate' => 'Ya se ha registrado un servidor de bases de datos con esta combinación de dirección de host y número de puerto.',
    'database_server_edit_form__host' => 'Dirección IP o nombre de host',
    'database_server_edit_form__legend_authentication' => 'Autenticación',
    'database_server_edit_form__legend_general' => 'General',
    'database_server_edit_form__port' => 'Nº puerto',
    'database_server_edit_form__port_hint' => 'Déjelo en blanco para usar el número de puerto predeterminado',
    'database_server_edit_form__tab' => 'Servidor de bases de datos',
    'database_server_edit_form__title_new' => 'Servidor de bases de datos nuevo',
    'database_server_edit_form__title_edit' => 'Servidor de bases de datos en %1',
    'database_server_edit_form__type' => 'Tipo de servidor de bases de datos',
    'database_server_edit_form__unix_socket' => '(conexión local)',
    'database_server_edit_form__external_connection' => 'Permitir al servidor MySQL local aceptar conexiones externas',
    'database_server_edit_form__external_connection_hint' => 'De modificar este parámetro, se reiniciará el servidor MySQL local. Si desea activar el acceso remoto a otros servidores MySQL registrados en Plesk, modifique su configuración de forma manual.',
    'database_server_edit_form__external_connection__configured_to_local' => 'El servidor MySQL local ha sido configurado para rechazar conexiones remotas',
    'database_server_edit_form__external_connection__configured_to_remote' => 'El servidor MySQL local ha sido configurado para aceptar conexiones remotas',
    'database_server_error__consult_admin' => 'Póngase en contacto con el administrador del servidor.',
    'database_server_error__last__connection_failed' => 'Error en el último intento de controlar este servidor de bases de datos debido a problemas de red.',
    'database_server_error__last__permission_denied' => 'Error en el último intento de controlar este servidor de bases de datos porque la cuenta indicada no tiene privilegios administrativos.',
    'database_server_error__last__credentials_not_set' => "El último intento de conexión a este servidor experimentó errores porque no se especificaron unas credenciales válidas para el administrador.",
    'database_server_error__last__other_error' => 'Error en el último intento de controlar este servidor de bases de datos.',
    'database_server_error__real__connection_failed' => 'No fue posible conectarse al servidor de bases de datos debido a problemas de red:',
    'database_server_error__real__permission_denied' => 'No fue posible conectarse al servidor de bases de datos porque la cuenta indicada no tiene permisos de administrador:',
    'database_server_error__real__duplicate_object' => 'No fue posible conectarse al servidor de bases de datos debido a un conflicto entre nombres:',
    'database_server_error__real__unacceptable_name' => 'No fue posible conectarse al servidor de bases de datos debido a un nombre de objeto no válido:',
    'database_server_error__real__unacceptable_password' => 'No fue posible conectarse al servidor de bases de datos porque la contraseña no es válida:',
    'database_server_error__real__credentials_not_set' => "Plesk no puede conectarse al servidor de bases de datos porque no se especificaron unas credenciales válidas para el administrador.",
    'database_server_error__real__other_error' => 'Error de conexión al servidor de bases de datos:',
    'database_server_error__test__connection_failed' => 'La conexión de prueba al servidor de bases de datos ha experimentado errores debido a problemas de red:',
    'database_server_error__test__permission_denied' => 'La conexión de prueba al servidor de bases de datos ha experimentado errores porque la cuenta indicada no dispone de privilegios administrativos:',
    'database_server_error__test__duplicate_object' => 'La conexión de prueba al servidor de bases de datos ha experimentado errores debido a un conflicto de nombres:',
    'database_server_error__test__unacceptable_name' => 'La conexión de prueba al servidor de bases de datos ha experimentado errores debido a un nombre de objeto que no es válido:',
    'database_server_error__test__unacceptable_password' => 'La conexión de prueba al servidor de bases de datos ha experimentado errores debido a una contraseña inaceptable:',
    'database_server_error__test__credentials_not_set' => "La conexión de prueba a este servidor ha experimentado errores porque no se especificaron unas credenciales válidas para el administrador.",
    'database_server_error__test__other_error' => 'La conexión de prueba al servidor de bases de datos ha experimentado errores:',

    'db__create_new_db' => "Añadir una base de datos",
    'db__db_add' => "Añadir base de datos",
    'db__db_for_dom' => "Bases de datos del sitio web %1",
    'db__db_id_undefined' => "ID de base de datos no definido.",
    'db__db_name' => "Nombre de la base de datos",
    'db__db_not_exist' => "La base de datos no existe.",
    'db__db_type' => "Tipo",
    'db__db_server' => "Servidor de bases de datos",
    'db_server_not_exist' => "El servidor de bases de datos no existe.",
    'db__db_user_not_exist' => "El usuario de la base de datos no existe.",
    'db__domain_not_exist' => "El dominio no existe.",
    'db__enter_db_name' => "Introduzca el nombre de la base de datos nueva.",
    'db__invalid_db_id' => "El identificador de la base de datos no es válido.",
    'db__invalid_db_name' => "El nombre de la base de datos no es válido. Este solo debe contener símbolos del alfabeto latino, dígitos, guiones o guiones bajos y no puede tener más de 63 símbolos.",
    'db__max_db_reached_for_dom' => "Se ha alcanzado el nº máximo de bases de datos para este dominio.",
    'db__max_mssql_db_reached_for_dom' => "Límite máximo de base de datos Microsoft SQL alcanzado para este dominio",
    'db__postgres_not_connect_for_admin' => "No se puede conectar con PostgreSQL. Active el soporte de PostgreSQL en la página de administración del servidor.",
    'db__postgres_not_connect_for_client' => "No se puede conectar a PostgreSQL. Contacte con su administrador de sistema para obtener ayuda.",
    'db__remove_db_on_domain' => "Se eliminarán las siguientes bases de datos bajo el sitio web %2 propiedad del cliente %1:",
    'db__remove_db_on_domain_of_cl' => "Se eliminarán las siguientes bases de datos para el dominio %2 propiedad del cliente %1:",
    'db__remove_db_linked_resource' => 'Esta base de datos está siendo usada por una aplicación web. Solo puede eliminarse una vez haya desinstalado esta aplicación web.',
    'db__remove_db_users' => "Se eliminarán los siguientes usuarios de la base de datos %3 bajo el sitio web %2 propiedad del cliente %1:",
    'db__remove_db_users_of_cl' => "Se eliminarán los siguientes usuarios de la base de datos %3 bajo el sitio web %2 propiedad del cliente %1:",
    'db__select_db_for_remove' => "Seleccione las bases de datos a eliminar.",
    'db__select_db_users_for_remove' => "Seleccione los usuarios de base de datos a eliminar.",
    'db__unable_create_db_user' => "No se puede crear el usuario de la base de datos: %1",
    'db__unable_define_db_name' => "No se puede definir el nombre de la base de datos: %1",
    'db__unable_define_db_user' => "No se puede definir el usuario de la base de datos: %1",
    'db__unable_define_db_users' => "No se pueden definir usuarios de la base de datos: %1",
    'db__unable_select_dom_name' => "No se puede seleccionar el nombre de dominio: %1",
    'db_edit__db_for_dom' => "Usuarios para la base de datos %1 en el dominio %2",
    'db_edit__invalid_db_name' => "El nombre de la base de datos no es válido.",
    'db_edit__no_users' => "No existe ningún usuario con credenciales para esta base de datos.",
    'db_edit__unable_define_db_usrs' => "No se pueden definir los usuarios de base de datos: %1",
    'db_edit__unable_select_db_usr' => "No se puede seleccionar el usuario de la base de datos.",
    'db_edit__db_user_password_for_' => "Indique la contraseña para acceder a la base de datos como usuario %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Añadir usuario de base de datos",
    'db_usr_edit__db_usr_name' => "Nombre de usuario de la base de datos",
    'db_usr_edit__edit_db_usr' => "Establecer credenciales para la cuenta de usuario de base de datos",
    'db_usr_edit__for_db' => "en la base de datos %1",
    'db_usr_edit__not_create_pass' => "Como resultado de esta operación, se creará un usuario de base de datos sin contraseña. ¿Desea crear un usuario sin asignarle una contraseña?",
    'dbuser__only_one_user_can_be_default' => "Solo puede establecerse un usuario predeterminado.",
    'db_server__cannot_delete_default' => "El servidor de bases de datos predeterminado no puede eliminarse.",
    'db_server__cannot_delete_local' => "El servidor de bases de datos local no puede eliminarse.",
    'db_server__cannot_delete_used' => 'No se puede eliminar un servidor de bases de datos si este aloja bases de datos o usuarios de bases de datos.',
    'demo__disabled_in_demo' => "Operación no soportada en la versión demo.",
    'defaultcomponents__title' => "Seleccionar componentes predeterminados",
    'defaultcomponents__select_default' => "Seleccionar componente %1 predeterminado",//to check
    'defaultcomponents__not_installed' => "(no instalado)",
    'defaultcomponents__not_configured' => "(no configurado)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Algunas categorías de servicio contienen selecciones no válidas o bien no se han realizado selecciones.",
    'defaultcomponents__depends_on' => "(requiere %1)",
    'defaultcomponents__parameters' => "Parámetros de %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Servidor DNS",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "Servidor FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Servidor de correo",
    'component_name__local_mailserver' => "Servidor de correo local",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Scripting web",
    'component_name__spamfilter' => "Filtro antispam",
    'component_name__stats' => "Estadísticas web",
    'component_name__stunnel' => "Contenedor SSL/TLS",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Publicación web",
    'component_name__webserver' => "Servidor web",
    'dns__dns_record_invalid_values' => 'Los valores de registro DNS indicados no son correctos: %1: %2',
    'dns__dns_zone_invalid_values' => 'Los parámetros de zona DNS indicados no son correctos.',

    'dns__soa_mname_title' => 'Servidor de nombres principal',
    'dns__soa_mname_legend' => 'Servidor de Nombres',
    'dns__soa_mname_autoselect' => '(Selección automática)',

    'dns__dns_zone_default' => 'Valores predeterminados de zona',
    'dns__dns_soa_legend' => 'Registro SOA',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'Actualizar',
    'dns__dns_soa_retry' => 'Volver a intentar',
    'dns__dns_soa_expire' => 'Expiración',
    'dns__dns_soa_minimum' => 'Mínimo',
    'dns__dns_soa_ttl_error' => 'El valor TTL no es válido. Debe estar entre 1 segundo y 68 años.',
    'dns__dns_soa_refresh_error' => 'Valor de actualización no válido. Debe estar entre 1 segundo y 68 años.',
    'dns__dns_soa_retry_error' => 'Valor de reintento no válido. Debe estar entre 1 segundo y 68 años.',
    'dns__dns_soa_expire_error' => 'El valor de expiración no es válido. Debe estar entre 1 segundo y 68 años.',
    'dns__dns_soa_minimum_error' => 'El valor mínimo no es válido. Debe estar entre 1 segundo y 68 años.',
    'dns__dns_default_title' => 'Restaurar la zona DNS',
    'dns__dns_default_legend' => "Opciones de restauración de zona",
    'dns__dns_default_text' => "Seleccione las opciones para la restauración de la zona DNS, confírmelas y haga clic en ACEPTAR.",
    'dns__dns_default_confirm' => "Confirme la restauración de la zona DNS",
    'dns__dns_default_confirm_required' => "Confirme la restauración de la zona DNS",
    'dns__dns_default_invalid_ip_address' => 'Dirección IP no válida',

    'dns_t__dns_default_title' => 'Restaurar la plantilla predeterminada de zona DNS',
    'dns_t__dns_default_legend' => "Opciones de restauración",
    'dns_t__dns_default_text' => 'Confirme que desea restaurar la configuración predeterminada de la plantilla de zona DNS.',
    'dns_t__dns_default_confirm' => "Confirme la restauración",
    'dns_t__dns_default_confirm_required' => "Confirme la restauración de la plantilla de zona DNS",
    'dns_t__dns_zone_off_remove_title' => "Se eliminarán los siguientes registros de recursos para la plantilla de zona DNS:",
    'dns_t__dns_zone_master_remove_title' => "Se eliminarán los siguientes registros de recursos de la plantilla de zona DNS:",
    'dns_t__add_dns_record_master_title' => 'Añadir registro de recurso a la plantilla de zona',
    'dns_t__add_dns_record_off_title' => 'Añadir servidor de nombres',
    'dns_t__edit_dns_record_master_title' => 'Editar registro de recurso',
    'dns_t__edit_dns_record_off_title' => 'Editar servidor de nombres',
    'dns_t__select_record_to_remove' => "Seleccione los registros a eliminar de la plantilla de zona DNS",
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__dns_zone_off_remove_title' => "Los siguientes registros de recursos se eliminarán de la zona %1:",
    'dns__dns_zone_master_remove_title' => "Eliminando registros de recurso de la zona DNS %1:",
    'dns__dns_zone_slave_remove_title' => "Se eliminarán los siguientes registros de servidor de nombres principal para %1:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Introducir cadena de registro',
    'dns_add__is_spf_syntax' => 'Registro SPF',
    'dns_add__spf_value_is_invalid' => "El valor del registro SPF no es válido, debe empezar por 'v=spf'",
    'dns__dns_zone_status' => "Estado de la zona DNS.",
    'dns__dns_zone_template' => 'Configuración DNS',
    'dns__host' => "Host",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "La dirección IP del nuevo servidor DNS principal no es válida o está vacía.",
    'dns__ip_address' => "Dirección IP",
    'dns__master_dns_type' => "es un servidor DNS principal",
    'dns__masters' => "Servidores DNS principales",
    'dns__soa_minimum_too_large' => 'No se recomienda copiar en caché las respuestas negativas durante más de tres horas.',
    'dns__select_masters_to_remove' => "Seleccione los servidores DNS principales a eliminar.",
    'dns__select_template_record_to_remove' => 'Seleccione los registros de plantilla DNS a eliminar.',
    'dns__select_record_to_remove' => 'Seleccione los registros DNS a eliminar.',
    'dns__nameservers_for_domain' => "Servidores de nombres para el dominio",
    'dns__ns' => "Servidor de nombres",
    'dns__ns_record' => "Servidores de nombres",
    'dns__remove_dns_zone_of_domain__' => "Eliminación de registros DNS del dominio %1",
    'dns__remove_dns_zone_template__' => "Se eliminarán los siguientes registros DNS de la plantilla:",
    'dns__remove_this_dns_record?' => "¿Está seguro de que desea eliminar este registro DNS?",
    'dns__restore_default' => "Restaurando la zona DNS desde la plantilla",
    'dns__restore_default_confirm' => "La restauración de la zona DNS descartará la configuración actual de la zona DNS. ¿Desea continuar de todas formas?",
    'dns__restore_default_error' => "Error al restaurar la zona DNS:",
    'dns__slave_dns_type' => "es un servidor DNS secundario",
    'dns__soa_refresh_value_is_small' => 'Intervalo de actualización inferior a una hora, lo que incrementará de forma crítica el tráfico y el consumo de recursos en el servidor. ¿Desea usar este valor?',
    'dns__subdomain_dns_rec_removed' => "El registro A ha sido eliminado de la zona de subdominio %1.",
    'dns__zone_switched_off_no_ns' => "La zona se ha desactivado porque no existe ningún registro NS %1, que debe estar presente en la zona. Para añadir el registro a la zona, haga clic en el botón Añadir registro.",
    'dns__cant_switch_on_no_ns' => "La zona no puede activarse porque no existe ningún registro NS %1, que debe estar presente en la zona. Para añadir el registro a la zona, haga clic en el botón Añadir registro.",
    'dns__type' => "Tipo de registro",
    'dns__unable_activate/deactivate_dns' => "No se puede activar/desactivar el DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "No se puede añadir el servidor DNS principal. La entrada está duplicada.",
    'dns__unable_add_dns_master_local_ip' => "No se puede añadir la dirección IP para el servidor DNS principal: este registro crearse en un servidor remoto.",
    'dns__unable_define_dns_record' => "No se puede definir el registro DNS: %1",
    'dns__unable_get_dns_template_status' => "No se puede obtener el estado de la plantilla DNS.",
    'dns__unable_remove_dns_rec' => "No se puede eliminar el registro DNS: %1",
    'dns__val' => "Valor",
    'dns__warnings__' => "El resultado de la modificación de la zona DNS:",
    'dns__you_not_have_perm_manage_dns' => "No tiene permisos para administrar la zona DNS para este dominio.",
    'dns__zone_record' => "Registros DNS",
    'dns__cant_create_record_with_server_ip' => "No se pudo añadir esta dirección IP porque esta coincide con la dirección IP de este servidor gestionado por Plesk.",

    'dns__tabs_acl' => "Transferencias de zona",
    'dns__acl_add_network_legend' => "Añadir red",
    'dns__acl_add_ip_legend' => "Añadir dirección IP",
    'dns__acl_network_not_allowed' => "Esta dirección de red no está permitida por DNS en Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Máscara/dirección IP",
    'dns__acl_enter_ip_address' => "Dirección IP",
    'dns__acl_list_network_legend' => "Redes que pueden obtener una copia de la zona DNS",
    'dns__acl_list_ip_legend' => "Direcciones IP que pueden obtener una copia de la zona DNS",
    'bt_dns_acl_add_network' => "Añadir red",
    'bt_dns_acl_add_ip' => "Añadir dirección IP",

    'dns_add__add_rec_for_zone' => "Añadir %1 para la zona %2",
    'dns_add__canonical_dom_name_is_invalid' => "Nombre de dominio canónico no válido.",
    'dns_add__enter_canonical_name' => "Nombre canónico",
    'dns_add__enter_dom_name' => "Nombre del dominio",
    'dns_add__enter_ip_address' => "Dirección IP",
    'dns_add__enter_ip_mask' => "Dirección IP y máscara de red",
    'dns_add__enter_mail_domain' => "Dominio de correo",
    'dns_add__enter_mail_exchanger' => "Servidor de intercambio de correo",
    'dns_add__enter_nameserver' => "Servidor de nombres",
    'dns_add__enter_txt_record' => "Registro TXT",
    'dns_add__enter_service_name' => "Nombre del servicio",
    'dns_add__hint_service_name' => "Ejemplo: SIP (sin el símbolo de subrayado)",
    'dns_add__enter_protocol' => "Protocolo",
    'dns_add__hint_protocol_name' => "Ejemplo: TCP (sin el símbolo de subrayado)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioridad",
    'dns_add__specify_weight_of_service' => "Peso relativo para los registros con la misma prioridad",
    'dns_add__enter_target_host' => "Host de destino",
    'dns_add__hint_target_host' => "Ejemplo: example.com",
    'dns_add__enter_target_port' => "Puerto de destino",
    'dns_add__caa_tag' => "Etiqueta",
    'dns_add__caa_value' => "Valor",

    'dns_add__invalid_ip' => "Dirección IP incorrecta.",
    'dns_add__low' => "baja",
    'dns_add__mail_dom_name_is_invalid' => "Nombre de dominio de correo no válido.",
    'dns_add__nameserver_is_invalid' => "Servidor de nombres no válido.",
    'dns_add__record' => "registro %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Especificar prioridad del servidor de intercambio de correo",
    'dns_add__unable_insert_new_dns_rec' => "No se puede insertar un nuevo registro DNS: %1",
    'dns_add__very_high' => "muy alto",
    'dns_check__test_dns_zone' => "Probar zona DNS %1 en %2",
    'dns_check__unable_get_dom_properties' => "No se pueden obtener las propiedades del dominio: %1",
    'dom_ctrl__allowed' => "Permitidos",
    'dom_ctrl__db' => "Bases de datos MySQL",
    'dom_ctrl__mssql_db' => "Bases de datos MS SQL",
    'dom_ctrl__disk_space' => "Espacio en disco",
    'dom_ctrl__dom_adm' => "Dominio %1 de %2",
    'dom_ctrl__dom_cl' => "Dominio %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "El dominio tiene configurado el redireccionamiento con una URL de redirección sin definir",
    'dom_ctrl__domain_has_frame_forwarding' => "El dominio tiene redireccionamiento por marcos a la URL %1",
    'dom_ctrl__domain_has_no_hosting' => "El dominio no tiene hosting configurado",
    'dom_ctrl__domain_has_physical_hosting' => "El hosting web para este dominio se ha configurado en la dirección IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "El dominio tiene redireccionamiento estándar a la URL %1",
    'dom_ctrl__maillists' => "Listas de correo",
    'dom_ctrl__mboxes' => "Buzones de correo",
    'dom_ctrl__mg' => "Reenvíos de correo electrónico",
    'dom_ctrl__resource_name' => "Recurso",
    'dom_ctrl__resp' => "Respuestas automáticas",
    'dom_ctrl__subdom' => "Subdominios",
    'dom_ctrl__dom_aliases' => "Alias de dominio",
    'dom_ctrl__traffic' => "Tráfico",
    'dom_ctrl__unable_activate/deactivate_dom' => "No se puede activar/desactivar el dominio: %1",
    'dom_ctrl__used' => "Usado",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Usuarios web",
    'dom_pref__bounce_with_phrase' => "Devolver con un mensaje",
    'dom_pref__bounce' => "Devolver",
    'dom_pref__catch_addr' => "Reenviar a la dirección",
    'dom_pref__reject' => 'Rechazar',
    'dom_pref__confirm_domain_removing' => "No olvide informar a los visitantes del dominio del cambio del nombre de dominio. ¿Está seguro de que desea cambiar el nombre del dominio?",
    'dom_pref__db_inconsystency' => "inconsistencia de base de datos.",
    'dom_pref__dbs' => "bases de datos",
    'dom_pref__delete_traffic_stat' => "Conservar estadísticas de tráfico y web",
    'dom_pref__delete_traffic_stat_older' => "Conservar estadísticas de tráfico y web",
    'dom_pref__dom_level_name_conflict' => "El nombre de usuario del administrador del dominio entra en conflicto con el nombre de usuario de uno de los clientes.",
    'dom_pref__invalid_disk_space_limit' => "Límite de espacio en disco no válido. Valor máximo: %1",
    'dom_pref__invalid_expiration_date_limit' => "Periodo de validez no válido.",
    'dom_pref__invalid_max_traffic_limit' => "Límite de tráfico no válido. Valor máximo: %1",
    'dom_pref__limits_of_dom' => "Límites para el dominio %1",
    'dom_pref__mail_grps' => "grupos de correo",
    'dom_pref__mail_nonexistent_user' => "Gestión de los correos enviados a usuarios inexistentes",
    'dom_pref__mail_redirs' => "reenviadores de correo",
    'dom_pref__mail_resps' => "respuestas automáticas de correo",
    'dom_pref__max_limit_is_invalid' => "%1 no es válido.",
    'dom_pref__max_num_of_%objects_is_invalid' => "El número máximo de %1 no es válido.",
    'dom_pref__new_limit_less_currently_used' => "%1: solicitado - %2, actualmente en uso - %3",
    'dom_pref__older_that' => "para",
    'dom_pref__postboxes' => "buzones de correo",
    'dom_pref__preferences_of_dom' => "Configuración para el dominio %1",
    'dom_pref__redirect_to_itself' => "El dominio se redireccionará a sí mismo",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Ha indicado un tiempo durante el que deben conservarse las estadísticas de tráfico del dominio que es inferior al valor total definido para el servidor (%1 mes(es)). El período de conservación de las estadísticas es el igual al valor predeterminado para el servidor (%1 mes(es)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "No se puede añadir el prefijo www al dominio: %1",
    'dom_pref__unable_define_physical_hst_param' => "No se pueden definir los parámetros de hosting físico: %1",
    'dom_pref__unable_rename_domain' => "No se puede cambiar el nombre del dominio",
    'dom_pref__unable_set_up_mbox_quota' => "No se pudo establecer la cuota de correo para este dominio: %1",
    'dom_pref__unable_set_up_web_user_script' => "No se puede configurar la ejecución de scripts para usuarios web: %1",
    'dom_pref__unlimited' => "Ilimitado",
    'dom_pref__web_usrs' => "usuarios web",
    'dom_pref__you_already_have_%object' => "Ya tiene %1",
    'dom_cli__warning_ignore_quota' => '¡ATENCIÓN! La opción "-hard_quota" ha sido ignorada porque no se soporta la cuota de disco duro',
    'dom_user_client_login_exist' => "No se pudo conceder acceso a Plesk al administrador del dominio en el dominio %1: este nombre de usuario ya está siendo usado.",
    'domain__unable_to_turn_on_service' => "Error al activar el servicio %1.",
    'domains__change_the_status_of_domain?' => "¿Está seguro de que desea cambiar el estado del dominio %1 ?",
    'domains__client_info_hiding_traffic' => "%1 dominios, %2 dominios activos, %3 espacio en disco usado",
    'domains__unable_to_change_client_status' => "No se puede cambiar el estado de la cuenta de cliente: %1",
    'domains__unable_update_apache_settings' => "No se puede actualizar la configuración de Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "No tiene permiso para eliminar dominios.",
    'domains__you_want_change_the_status_of_the_cl??' => "¿Está seguro de que desea cambiar el estado de la cuenta de cliente?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "¿Está seguro de que desea realizar esta operación?",
    'domains_list__unable_remove_doms' => "No se pueden eliminar los dominios: %1",
    'domaintrafficlist_header_of_domain__' => "Tráfico en el dominio %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Seleccione los alias de dominio a eliminar.',
    'domain_aliases_remove__title' => 'Eliminación de alias de dominio',
    'domain_aliases__max_aliases_reached_for_dom' => "El número límite de alias ha sido alcanzado por este dominio.",
    'domain_edit__edit_title' => 'Editar nombre de alias de dominio',
    'domain_alias_edit__type' => 'Tipo de alias de dominio',
    'domain_aliases__list_header' => 'Alias de dominio',
    'domain_aliases__name' => 'Nombre',
    'domain_aliases__type' => 'Tipo',
    'domain_aliases__type_full' => 'Web+FTP+Correo',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Alias de dominio',
    'domain_aliases__legend' => 'Alias de dominio',
    'domain_alias__domain_exists' => 'Ya existe un dominio con este nombre',
    'domain_alias__subdomain_exists' => 'Ya existe un subdominio con este nombre',
    'domain_alias__dns_record_exists' => 'Ya existe un registro DNS con el nombre de alias de dominio especificado',
    'domain_alias__domain_alias_exists' => "Ya existe un alias de dominio con este nombre",
    'domain_alias__invalid_type_full' => 'El servidor de correo no soporta el uso de alias de dominio',
    'domain_alias__redirect_exists' => 'Se ha detectado un redireccionamiento a sí mismo.',

    'ds__anonymous_ftp' => "FTP anónimo",
    'drweb__pagetitle' => 'Configuración del antivirus',
    'drweb__drweb' => 'Detección de virus en el correo',
    'drweb__drweb_direction' => 'Comprobando la existencia de virus en el correo',
    'drweb__drweb_direction_off' => 'No realizar comprobación de viruses',
    'drweb__drweb_direction_any' => 'Correo entrante y saliente',
    'drweb__drweb_direction_from' => 'Solo correo saliente',
    'drweb__drweb_direction_to' => 'Solo correo entrante',
    'drweb__disable_reason_key' => 'El antivirus no es soportado por la llave de licencia.',
    'drweb__disable_reason_perm' => 'No tiene el permiso necesario para administrar el antivirus.',
    'drweb__disable_reason_install' => 'Antivirus no instalado.',
    'drweb__filters' => 'Filtros antivirus',
    'ds__dns' => "Zona DNS",
    'ds__mail' => "Correo",
    'dsr__of_client_title' => "Informe resumido del dominio de %1",
    'dsr__report_has_been_sent_email' => "El informe se ha enviado a la dirección de email:  %1",
    'dsr__title' => "Informe resumido del dominio",
    'dumps_list__deletion_page_title' => "Se eliminarán los siguientes archivos de backup del dominio %1:",
    'dumps_list__dumpfile_is_invalid' => "El archivo %1 no es un archivo de backup de dominio válido.",
    'dumps_list__page_title' => "Almacenamiento de archivos de backup",
    'dumps_upload__page_title' => "Cargando archivos de backup al almacenamiento",
    'dumps_list__repository_is_not_exist' => "El almacenamiento de archivos de backup no existe.",
    'dumps_list__unable_to_remove' => "No se pudo eliminar el archivo de backup: %1",
    'dumps_list__dumpfile_can_conflict' => "El nombre del archivo especificado entra en conflicto con el archivo %1. Especifique otro nombre.",
    'dusr_ed__allow_dl_usr_access' => "Permitir acceso al administrador del dominio",
    'dusr_ed__information' => "Propiedades del administrador del dominio %1",
    'dusr_ed__locale' => "Idioma del administrador del dominio",
    'dusr_ed__skin' => "Skin de interfaz del administrador del dominio",
    'dusr_ed__personal_information' => 'Información personal',
    'ess__error' => "Error",
    'example__' => "Ejemplo: %1",
    'extras__allow_certificate_purchasing' => "Permitir la compra de certificados",
    'extras__allow_domain_registration' => "Permitir el registro de dominios",
    'extras__allow_extras' => "Permitir servicios adicionales",
    'extras__buy_new_key' => "Su licencia actual no le permite modificar estos objetos.",
    'extras__setup_services' => "Establecer servicios adicionales",

    'firewallmainform__title' => 'Administración del firewall',
    'firewallmainform__interfaces_list_legend' => 'Lista de interfaces de red',
    'firewall__interfacelist' => 'Interfaces de red',
    'interfacelist__enabled' => 'R',
    'interfacelist__status' => 'I',

    'interfacelist__interface' => 'Nombre del interfaz',
    'interfacelist__type' => 'Tipo de interfaz',
    'bt_rule_add' => 'Añadir regla del Firewall',
    'bt_panic' => 'Modo pánico',
    'firewallmainform__rules_list_legend' => 'Lista de reglas',
    'firewall__rulelist' => 'Reglas',
    'rulelist__enable' => 'Estado',
    'rulelist__name' => 'Nombre',
    'rulelist__allow_input_from_any_port_profiles' => '[Permitir] conexiones entrantes desde [todos] en el puerto [%1], perfiles: [%2]',
    'rulelist__allow_input_from_port_profiles' => '[Permitir] conexiones entrantes desde [%1] en el puerto [%2], perfiles: [%3]',
    'rulelist__block_input_from_any_port_profiles' => '[Denegar] conexiones entrantes desde [todos] en el puerto [%1], perfiles: [%2]',
    'rulelist__block_input_from_port_profiles' => '[Denegar] conexiones entrantes desde [%1] en el puerto [%2], perfiles: [%3]',
    'rulelist__description' => 'Descripción',
    'ruleeditform__add_title' => 'Adición de una regla nueva',
    'ruleeditform__properties' => 'Propiedades de la regla',
    'ruleeditform__name' => 'Nombre de la regla',
    'ruleeditform__port' => 'Permitir conexiones al siguiente puerto o intervalo de puertos',
    'ruleeditform__protocol_tcp' => 'Protocolo TCP',
    'ruleeditform__protocol_udp' => 'Protocolo UDP',
    'ruleeditform__edit_title' => 'Edición de una regla de firewall',
    'ruleeditform__newrule' => 'Regla Nueva',
    'ruleeditform__enabled' => 'Activar la regla',
    'ruleeditform__profiles_text' => 'Perfiles',
    'ruleeditform__profiles_domain_text' => 'Dominio',
    'ruleeditform__profiles_private_text' => 'Privado',
    'ruleeditform__profiles_public_text' => 'Público',
    'ruleeditform__action' => 'Acción',
    'ruleeditform__action_allow' => 'Permitir',
    'ruleeditform__action_deny' => 'Denegar',
    'ruleeditform__from' => 'Direcciones remotas',
    'ruleeditform__from_add' => 'Añada una red o dirección IP:',
    'ruleeditform__profiles_hint' => 'Seleccione al menos un perfil.',
    'ruleeditform__port_hint' => 'Por ejemplo: 1000 o 1000-1051',
    'ruleeditform__from_hint' => 'Por ejemplo: 192.168.0.1 o 192.168.0.0/16',
    'ruleeditform__ip_any' => 'Todos',
    'firewall_from_add' => 'Añadir',
    'firewall_from_remove' => 'Eliminar',
    'firewall_from_clear' => 'Borrar lista',
    'bt_firewall_from_add' => 'Añadir',
    'bt_firewall_from_remove' => 'Eliminar',
    'bt_firewall_from_clear' => 'Borrar lista',
    'ruleeditform__name_is_required' => 'Especifique el nombre de la regla.',
    'ruleeditform__profiles_is_required' => 'Seleccione al menos un perfil.',
    'ruleeditform__invalid_action' => 'La acción especificada no es válida. Los valores permitidos son "Permitir" o "Denegar".',
    'ruleeditform__invalid_ip' => 'La red o dirección IP indicada no es válida.',
    'ruleeditform__invalid_protocol' => 'El protocolo indicado no es válido. Los valores permitidos son "udp" o "tcp".',
    'ruleeditform__invalid_port' => 'El puerto especificado no es válido. Los valores permitidos son 1000 o 1000-1051',
    'firewall__panic_configuration' => '¿Está seguro de que desea activar el Modo Pánico? Los usuarios no podrán acceder a sus dominios.',
    'firewall__reset_configuration' => '¿Está seguro de que desea restablecer la configuración predeterminada del firewall?',
    'rulelist__remove_selected' => '¿Desea eliminar las reglas seleccionadas?',

    'filemanager__items' => 'elementos en el directorio %1',
    'filemanager__items_paging' => 'elementos en el directorio %1',

    'get_password__encrypted_password' => "No se puede enviar la información de la contraseña: la contraseña está cifrada.",
    'get_password__mail_error' => "Se ha producido un error al intentar enviar la contraseña al email %1:  %2",
    'get_password__mail_ok' => "La contraseña se ha enviado correctamente a la dirección de email:  %1",
    'get_password__message' => "Su nombre de usuario para acceder al sistema: %1\nSu contraseña es %2",
    'get_password__subject' => "Contraseña para acceder al sistema",
    'groups__available' => "Grupos de correo disponibles",
    'groups__groups_for_mailname' => "Grupos de correo a los que está suscrita la cuenta de correo %1",
    'groups__member_of' => "Miembro de los siguientes grupos de correo",
    'help__help_area' => "Área de ayuda.",
    'hst_def__auth_disabled' => "prohibido",
    'hst_def__auth_enabled' => "permitido",
    'hst_def__change_curr_dns_ip' => "La dirección IP actual del registro A DNS será modificada",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Ninguna de las direcciones IP del registro DNS A coincide con la dirección IP asignada a la cuenta de hosting que está creando",
    'hst_def__dest_url' => "URL de destino",
    'hst_def__disk_quota' => "Cuota de disco",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "El espacio en disco que está intentando establecer excede el límite de espacio en disco en el directorio entrante del FTP anónimo. El límite de espacio en disco en el directorio entrante del FTP anónimo no puede exceder el límite de espacio en disco del dominio.",
    'hst_def__frame_forwarding_definition' => "Asignación de redireccionamiento por marcos para el dominio %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Advertencia: el usuario FTP %1 es usado en la configuración de la cuenta de hosting pero no existe en el sistema.",
    'hst_def__hst_type_is_not_defined' => "El tipo de hosting no está definido",
    'hst_def__ip_based' => "Basado en IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Si transfiere esta cuenta de hosting a una dirección IP compartida, el servicio FTP anónimo no estará disponible en este dominio. ¿Desea continuar de todas formas?",
    'hst_def__password_is_invalid_password_syntax' => "Contraseña no válida.No utilice caracteres del alfabeto nacional ni comillas simples en la contraseña. La contraseña debe tener entre 5 y 14 caracteres. Esta no debería de contener el nombre de usuario.",
    'hst_def__shell' => "Acceso SSH al shell del servidor bajo el usuario del sistema de la suscripción",
    'hst_def__shell_windows' => "Acceso al servidor a través de escritorio remoto bajo el usuario del sistema de la suscripción",
    'hst_def__standard_forwarding_definition' => "Asignación de redireccionamiento estándar para el dominio %1",
    'hst_def__title_name_based' => "Basado en nombre",
    'hst_def__unable_create/update_physic_hst' => "No se pudo crear/actualizar el hosting físico: %1",
    'hst_def__unable_create/update_std_fwd' => "No se pudo crear/actualizar redireccionamiento estándar: %1",
    'hst_def__unable_create_forwarding_myself' => "No se pudo crear un redireccionamiento al mismo dominio.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "No se permite el uso de un único directorio para el almacenamiento de contenido SSL/TLS y no SSL/TLS: el soporte de SSL/TLS no está activado.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "No se pudo activar el soporte SSL/TLS: no se ha instalado ningún certificado SSL/TLS.",
    'hst_def__url_is_invalid' => "URL no válida.",
    'hst_def__virtual_host_access' => "Acceso al host virtual para el dominio %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ADVERTENCIA: este host virtual está utilizando una dirección IP inexistente para el hosting.",
    'hst_def__you_have_no_ips' => "No dispone de ninguna dirección IP libre y no puede crear hosting basado en nombres.",
    'hst_sel__header' => "Para alojar un sitio web en este servidor, seleccione la opción Hosting físico. Para configurar un redireccionamiento de dominio a un sitio presente en otra máquina, seleccione la opción Redireccionamiento por marcos o Redireccionamiento estándar. En el caso del redireccionamiento estándar, el usuario es redireccionado al sitio y en el navegador del usuario se muestra la URL del sitio, por lo que el usuario es consciente de este redireccionamiento. En el caso del redireccionamiento por marcos, el usuario es redireccionado al sitio sin ser consciente de que el sitio se encuentra en otra ubicación.",
    'hst_sel__physical_hst' => "Hosting físico",
    'hst_sel__select_hst_type' => "Seleccione el tipo de hosting para el dominio",
    'hst_sel__select_hst_type_warning' => "Seleccione el tipo de hosting para el dominio",
    'hst_sel__hosting_exists' => "No ha sido posible crear hosting, ya que este ya está configurado para este dominio. Será redireccionado a la página de administración de hosting.",
    'hst_sel__standard_frw' => "Redireccionamiento estándar",
    'hst_sel__frame_frw' => "Redireccionamiento por marcos",
    '__frame_frw' => "Redireccionamiento por marcos",
    '__hosting_exists' => "No ha sido posible crear hosting, ya que este ya está configurado para este dominio. Será redireccionado a la página de administración de hosting.",
    '__choose_hst_type' => "Seleccione el tipo de hosting deseado.",
    '__no_hst_conf' => "No se ha configurado hosting para su dominio.",
    '__physical_hst' => "Hosting físico",
    '__select_hst_type' => "Seleccione el tipo de hosting para el dominio",
    '__standard_frw' => "Redireccionamiento estándar",
    '__warning' => "¡Advertencia! Se descartarán todos los parámetros establecidos previamente. ¿Está seguro DE que desea cambiar el tipo de hosting?",
    'i_cl_off' => "Cliente inactivo.",
    'i_cl_off_by_admin' => "La cuenta de cliente ha sido suspendida por el administrador del servidor.",
    'i_cl_off_expired' => "La cuenta del cliente ha expirado.",
    'i_cl_on' => "Cliente activo.",

    'icf__title' => 'Firewall de conexión a Internet',
    'icf__if_legend' => 'Interfaces',
    'icf__mode' => 'Modo',

    'invalid_value' => 'Valor no válido',

    'ip_addr__already_exists' => "La dirección IP %1 ya existe.",
    'ip_addr__cant_add' => "La IP %1 no existe o pertenece al grupo de direcciones IP de otro cliente",
    'ip_addr__cl_list_for_ip' => "Revendedores que utilizan %1 dirección IP %2",
    'ip_addr__cl_list_for_ip_add' => "Añadir dirección IP al grupo de direcciones IP del revendedor",
    'ip_addr__domains_list_for_ip' => "Sitios web que usan %1 dirección IP %2",
    'ip_addr__ip_used_by_hst_or_frw' => "La dirección IP %1 se usa para hosting o redireccionamiento.",
    'ip_addr__only_one_ip_and_client_have_domain' => "No se puede eliminar esta dirección IP porque existen dominios alojados en esta dirección IP.",
    'ip_addr__remove_ip_addr' => "Estas direcciones IP serán eliminadas del sistema:",
    'ip_addr__select_clients' => "Seleccione clientes",
    'ip_addr__select_ip_addr_to_remove' => "Seleccione la dirección IP a eliminar.",
    'ip_addr__unallowed_by_license' => "Esta copia de Plesk no está licenciada para operar en la dirección IP %1.\nLos rangos IP permitidos son los siguientes: %2.",
    'ip_alias__interface' => "Interfaz",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 dirección IP para hosting físico basado en nombres no válida.",
    'ip_alias__invalid_ip_or_netmask' => "Par de máscara de red/dirección IP no válido.",
    'ip_alias__orig_ip_can_not_be_deleted' => "La dirección IP %1 es la IP del servidor original y no puede eliminarla.",
    'ip_alias__ip_is_invalid' => "%1 Dirección IP no válida.",
    'ip_alias__ip_mask_is_invalid' => "%1 máscara de red no es válida.",
    'ip_alias__ip_not_exist' => "La dirección IP %1 no existe.",
    'ip_alias__ip_address_and_mask' => 'Máscara subred y dirección IP',
    'ip_alias__mask' => "Máscara de subred",
    'ip_alias__remove_selected_ip_aliases?' => "¿Está seguro de que desea eliminar las direcciones IP seleccionadas?",
    'ip_alias__select_ip' => "Seleccione al menos una dirección IP de la lista para eliminarla.",
    'ip_alias__this_ip_used_for_domain' => "(%1) esta dirección IP se usa para el dominio %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) esta dirección IP se usa para hosts virtuales basados en nombre.",
    'ip_alias__unable_add_ip' => "No se pudo añadir la IP: %1",
    'ip_alias__unable_remove_ip' => "No se pudo eliminar la IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "No puede cambiar el tipo de dirección IP a compartida porque esto haría que el FTP anónimo no estuviera disponible para el dominio '%1'.",
    'ip_ctrl__ip_addr' => "Dirección IP %2 en el interfaz %1",
    'ip_ctrl__ip_exists_many_pools' => "No puede cambiar el tipo de IP. Esta dirección IP pertenece a los grupos de direcciones IP de múltiples usuarios.",
    'ip_ctrl__ssl_cert' => "Certificado SSL/TLS",
    'ip_pool__ip_address_is_absend_in_pool' => "Dirección IP ausente.",
    'ip_pool__ip_pool_for_client' => "Grupo de direcciones IP del cliente %1",
    'ip_pool__no_cliens_avail' => "Ningún cliente disponible.",
    'ip_pool__no_vacant_ips' => "No existe ninguna IP libre.",
    'ip_pool__pool_is_empty' => "El grupo de direcciones IP está vacío.",
    'ip_pool__remove_ip_addr' => "Estas direcciones IP serán eliminadas del grupo de direcciones IP %1:",
    'ip_pool__select_free_ips' => "IPs disponibles",
    'limit__date_in_past' => "Periodo de validación no válido. %1 anterior a la fecha presente.",
    'limit__enter_date' => "Indicar fecha",
    'limit__max_db' => "Bases de datos",
    'limit__name_disk_space' => "espacio en disco",
    'limit__name_max_box' => "buzones de correo",
    'limit__name_max_db' => "Bases de datos MySQL",
    'limit__name_max_dom' => "dominios",
    'limit__name_max_maillists' => "listas de correo",
    'limit__name_max_subdom' => "subdominios",
    'limit__name_max_traffic' => "tráfico",
    'limit__name_max_wu' => "usuarios web",
    'limit__name_mbox_quota' => "cuota de buzón",
    'limit__name_max_mn' => "cuentas de correo",
    'limit__name_max_cl' => 'clientes',
    'limit__name_total_mboxes_quota' => "cuota total de buzón",
    'limit__name_mysql_dbase_space' => "Espacio para base de datos MySQL",
    'limit__name_mssql_dbase_space' => "Espacio para base de datos MSSQL",
    'limit__name_expiration' => 'fecha de expiración',

    'locale_upload__title' => 'Añadir idioma',
    'locale_upload__file_name' => 'Ruta a la ubicación del archivo del paquete de idiomas',
    'locale_upload__unable_to_install' => 'No se pudo instalar el archivo del paquete de idiomas',
    'locale_upload__wrong_package' => 'El archivo cargado no contiene ningún paquete de idioma válido para esta versión de Plesk.',
    'locale_upload__wrong_locale' => 'El archivo cargado no contiene ningún paquete de idioma válido.',

    'locales_remove__title' => 'Eliminación de idiomas',
    'locales_remove__select_locales_for_remove' => 'Seleccione los idiomas a eliminar.',
    'locales__can_not_remove' => 'No se pudo eliminar el paquete de idioma para el idioma %1: %2',

    'ma__create_title' => 'Crear alias de correo para %1',
    'ma__edit_title' => "Edición del alias de correo %1",
    'ma__enter_new_alias' => "Introducir alias nuevo.",
    'ma__invalid_alias' => "El alias de correo no es válido.",
    'ma__mail_aliases_mailname' => "Alias de correo para la cuenta de correo %1",
    'ma__mailname_does_not_exist' => "La cuenta de correo no existe.",
    'ma__select_ma_for_remove' => "Seleccionar los alias de correo a eliminar.",
    'ma__unable_to_add_new_ma' => "No se pudo añadir un alias de correo: %1",

    'mail__white_list' => "Lista blanca",
    'mail__white_list_add' => 'Añadir red',
    'mail__white_list_remove' => 'Se eliminarán las siguientes redes:',
    'mail__white_list_remove_warning_webmail' => 'La eliminación de las siguientes redes puede impedir el envío de emails desde el webmail: %1.',
    'mail__white_list_member' => 'Redes permitidas',
    'mail__white_list_empty_selection_for_remove' => 'Seleccione las entradas a eliminar.',
    'mail_queue__not_allowed_by_license_key' => 'La administración de colas de correo no está permitida por la llave de licencia.',
    'maillist__' => "Lista de correo %1",
    'maillist__already_exists' => "La lista de correo ya existe.",
    'maillist__mail_alias_already_exists_in_this_domain' => "El alias de correo %1 ya existe en este dominio",
    'maillists__' => "Listas de correo %1",
    'maillists__limit_cl_max_maillists' => "Se ha alcanzado el número máximo de listas de correo para el cliente (límite: %1, usadas: %2)",
    'maillists__limit_dom_max_maillists' => "Se ha alcanzado el número máximo de listas de correo para el dominio.",
    'maillists__list' => "Listas de correo",
    'maillists__mailman_not_installed_or_conf' => "Las extensiones de servidor de Mailman no están instaladas o configuradas en el servidor. Póngase en contacto con el administrador del servidor para que las instale o las configure correctamente.",
    'maillists__status' => "El servicio de listas de correo está activado",
    'maillists__unable_to_delete__' => "No se pudo eliminar la lista de correo: %1",
    'maillists__disabled_text' => 'No puede administrar listas de correo porque el componente de servidor de listas de correo Mailman no está instalado o configurado.',
    'maillist_member__already_exists' => 'El suscriptor de la lista de correo ya existe.',
    'maillist_member__not_exists' => 'En la lista de correo no existe dicho usuario.',
    'mailserver_switching_warning' => "¡Atención!\n\nEl cambio de servidor de correo solo es aconsejable para la configuración inicial. Si el servidor ya está en uso, se experimentarán problemas como la pérdida de configuraciones y del contenido de los buzones de correo, así como varios conflictos cuando el servidor al que cambie ya esté configurado.\nSi su servidor está en producción y está seguro del cambio a otro, puede notificar a sus clientes acerca de esta operación para que así puedan descargar y guardar sus correos.",
    'manager__access_denied' => "Acceso denegado: %1",
    'manager__admin' => "Administrador",
    'manager__client' => 'Cliente',
    'manager__domain' => "Dominio",
    'manager__domain_cl_limit_exceeding' => "Se ha alcanzado el número máximo de dominios para esta cuenta de cliente.",
    'manager__domain_is_not_yours' => "El dominio %1 no le pertenece.",
    'manager__domain_key_limit_exceeding' => "Se ha alcanzado el límite de creación de dominios definido por su llave de licencia.",
    'manager__no_perm_to_call' => "No tiene permiso para llamar %1.",
    'manager__no_perm_to_create_domains' => "No tiene permiso para crear dominios.",
    'manager__no_perm_to_modify_domain' => "No tiene permiso para modificar el dominio %1.",
    'manager__no_perm_to_modify_domains' => "No tiene permiso para modificar dominios.",
    'manager__no_perm_to_remove_domain' => "No tiene permiso para eliminar el dominio %1.",
    'manager__no_perm_to_remove_domains' => "No tiene permiso para eliminar dominios.",
    'manager__node_doesnt_exist' => "%1 no existe.",
    'manager__user_disabled' => "Su cuenta ha sido suspendida. No puede operar en el sistema.",
    'mail_quota_unsupported' => "no soportada por el servidor de correo",
    'mbox_quota_unsupported' => "no soportada por el servidor de correo",
    'mn__create_title' => "Crear cuenta de correo",
    'mn__edit_title' => "Configuración",
    'mn__files_list_title' => "Archivos adjuntos",
    'mn__files_remove' => "Elimine archivos del repositorio de adjuntos. Puede que las respuestas automáticas usen estos archivos. Los archivos se eliminarán del repositorio y de las respuestas automáticas que los usen.",
    'mn__files_select_for_remove' => "Seleccione los archivos a eliminar.",
    'mn__mail_alias_form' => "Formulario de alias de correo",
    'mn__mail_aliases_list' => "Alias de correo",
    'mn__mailbox' => "Administración de buzones",
    'mn__unable_define_mn' => "No se pueden configurar cuentas de correo: %1",
    'mn__unable_remove_mbox_quota' => "No se puede eliminar la cuota de buzón de correo: %1",
    'mn__upload_file' => "Cargar archivo",
    'mn_edit__attach_filename_changed' => 'Se ha cambiado el nombre del archivo cargado %1. Ahora se denomina %2, ya que su nombre contenía caracteres no ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Antes de habilitar el grupo de correo, añada miembros al grupo de correo.",
    'mn_edit__add_resp_or_turn_off_box' => "Añada una respuesta automática o deseleccione la casilla de respuesta automática.",
    'mn_edit__attachments' => "Adjuntos",
    'mn_edit__dom_quota_less_then_quota' => "El tamaño de este buzón de correo no debe exceder al límite de espacio en disco asignado para buzones en este dominio.",
    'mn_edit__enter_external_rcpnt_email' => "Introduzca el email del miembro externo del grupo de correo",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Introduzca una dirección para el reenvío de correo o deseleccione la casilla.",
    'mn_edit__ext_rcpnt_email_invalid' => "La dirección de email del destinatario externo no es válida.",
    'mn_edit__file_exists' => "El archivo ya existe. ¿Desea sobreescribirlo?",
    'mn_edit__files_deld_from_repository' => "Estos archivos se eliminarán del repositorio y de las respuestas automáticas que los incluyan. ¿Desea continuar?",
    'mn_edit__mail_name' => "Cuenta de correo",
    'mn_edit__mail_name_invalid' => "Nombre de cuenta de correo no válido.",
    'mn_edit__mail_redir' => "Reenviadores de correo",
    'mn_edit__mail_redir_add' => "Añadir miembro al grupo de correo",
    'mn_edit__mail_resps' => "Respuestas automáticas de correo",
    'mn_edit__mailbox' => "Buzón de correo",
    'mn_edit__enable_mailbox' => "Buzón de correo",
    'mn_edit__mailgroup' => "Grupo de correo",
    'mn_edit__mailgroup_addresses' => "Miembros del grupo de correo",
    'mn_edit__mailgroup_disabled' => "Solo disponible cuando ya haya añadido la cuenta de correo.",
    'mn_edit__max_dom_quota' => "Predeterminado para el dominio (%1)",
    'mn_edit__mbox_quota_invalid' => "El tamaño de buzón indicado no es correcto.",
    'mn_edit__new_resp_name' => "Nombre de la respuesta automática nueva",
    'mn_edit__no_autoresponders' => "Antes de activar/desactivar el servicio de respuesta automática, añada al menos una respuesta automática.",
    'mn_edit__no_file_sel' => "Ningún archivo seleccionado.",
    'mn_edit__no_mail_addresses' => "No se indicó ni seleccionó ninguna dirección de email.",
    'mn_edit__none' => "Ninguno",
    'mn_edit__not_create_pass' => "Esta acción no creará ninguna contraseña para esta cuenta. Sin una contraseña, el usuario no podrá ver ni enviar correos.",
    'mn_edit__redir_email_invalid' => "La dirección de reenvío no es válida.",
    'mn_edit__redirect_addr' => "Dirección de reenvío",
    'mn_edit__remove_autoresp?' => "¿Está seguro de que desea eliminar la respuesta automática?",
    'mn_edit__remove_rcpnts?' => "¿Está seguro de que desea eliminar estos destinatarios?",
    'mn_edit__repository' => "Repositorio",
    'mn_edit__resps_attach' => "Archivos adjuntos de respuesta automática",
    'mn_edit__select_rcpnt_from_list' => "Seleccione al menos un destinatario de la lista para eliminarlo.",
    'mn_edit__select_registered_users' => "Seleccione usuarios registrados",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Ha seleccionado tener un buzón de correo pero no ha configurado ninguna contraseña para este.",
    'mn_edit__unable_act_deact_mail_group' => "No se pudo activar o desactivar el grupo de correo: %1",
    'mn_edit__unable_act_deact_mail_redir' => "No se pudo activar o desactivar el reenvío de correo: %1",
    'mn_edit__unable_act_deact_postbox' => "No se pudo activar o desactivar el buzón de correo: %1",
    'mn_edit__unable_act_deact_resp' => "No se pudieron activar o desactivar las respuestas automáticas: %1",
    'mn_edit__unable_add_attach' => "No se pudo añadir el archivo adjunto: %1",
    'mn_edit__unable_add_mail_group_member' => "No se pudo añadir el miembro al grupo de correo: %1",
    'mn_edit__unable_add_resp' => "No se pudo añadir la respuesta automática: %1",
    'mn_edit__unable_change_mail_name' => "No pudo cambiar el nombre de la cuenta de correo: %1",
    'mn_edit__unable_deactivate_mail_group' => "No se pudo desactivar el grupo de correo: %1",
    'mn_edit__unable_deactivate_resp' => "No se pudieron desactivar las respuestas automáticas de correo: %1",
    'mn_edit__unable_define_resp_id' => "No se pudo definir el ID de la respuesta automática: %1",
    'mn_edit__unable_remove_attach' => "No se puede(n) eliminar archivo(s) adjunto(s): %1",
    'mn_edit__unable_remove_autoresp' => "No se pudo eliminar la respuesta automática: %1",
    'mn_edit__unable_remove_mail_group_member' => "No se pueden eliminar los miembros del grupo de correo: %1",
    'mn_edit__wrong_way' => 'Los mensajes dirigidos a %1 no serán entregados, ya que esta cuenta de correo no dispone de ningún buzón o reenviador de correo activo.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'El buzón de correo en la dirección %1 ha sido desactivado. Los mensajes presentes en el buzón no han sido eliminados pero no podrá recuperarlos a través del protocolo POP3 o IMAP.',
    'mn_list__mail_names_for_domain' => "Cuentas de correo bajo el dominio %1",
    'mn_list__sa_cannot_unable' => "No se pudo activar la filtración de spam",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Cliente',
    'mn_list__tab_title_domain' => 'Dominio',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nombre",
    'mn_list__tab_title_redirect' => "R",
    'mn_list__tab_title_spamfilter' => "Estado",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "No se pueden eliminar las cuentas de correo: %1",
    'no_psa_mails_matched' => "No se ha encontrado ninguna cuenta de correo que coincida con el patrón introducido.",
    'module_upload__module_was_installed' => 'Este módulo ya está instalado. Si desea instalar una versión más reciente de este módulo, primero desinstale el módulo a través de Plesk y a continuación intente instalarlo.',
    'module_upload__unable_to_install' => 'No se puede instalar el archivo del paquete del módulo',
    'module_upload__wrong_package' => 'El archivo cargado no es un paquete de módulo soportado.',
    'module_upload__wrong_module' => 'El archivo cargado no contiene ningún paquete de módulo.',

    'news_articles_title' => 'Noticias acerca de Plesk',
    'notification_text__invalid_subject_length' => "Longitud del asunto del aviso no válida. Debería tener entre 1 y 255 caracteres.",
    'notification_text__invalid_text_length' => "Longitud del texto de aviso no válida. Debería tener entre 1 y 65533 caracteres.",
    'notification_text__subject' => "Asunto del aviso",
    'notification_text__text' => "Texto de aviso",
    'notification_text__title' => "Editar aviso",
    'notification_text__unable_set_text' => "No se puede modificar el texto de aviso:",

    'odbc__cant_add_dsn' => "No se puede añadir el DSN %1: %2",
    'odbc__cant_build_connection_string' => "No se puede realizar la conexión usando los parámetros indicados. Inténtelo de nuevo utilizando otros parámetros. La utilidad ha devuelto: %1",
    'odbc__cant_connect' => "No se puede conectar con el origen de datos usando los parámetros definidos. El servidor ha devuelto: %1",
    'odbc__cant_delete_dsn' => "No se puede eliminar el DSN %1: %2",
    'odbc__cant_get_drivers_info' => "No se puede obtener la información acerca de los controladores.",
    'odbc__cant_get_drivers' => "No se puede recuperar la lista de controladores ODBC: %1",
    'odbc__cant_get_list' => "No se puede recuperar la lista de DSNs existentes: %1",
    'odbc__cant_get_servers_list' => "No se puede obtener la lista de servidores.",
    'odbc__cant_open_info_file' => "No se puede abrir el archivo con la información de los controladores ODBC.",
    'odbc__cant_parse_string' => "No se puede analizar la cadena de conexión.",
    'odbc__connect_success' => "Conexión correcta",
    'odbc__driver_not_set' => "El controlador no está configurado",
    'odbc__driver_or_name_not_set' => "No se ha definido el controlador o nombre de la conexión ODBC",
    'odbc__dsn_already_exists' => "En el sistema ya existe un DSN con este nombre (%1)",
    'odbc__dsn_not_exists' => "Este DSN no existe",
    'odbc__enter_connection_params' => "Configurar una conexión ODBC",
    'odbc__enter_dsn_name' => "Introduzca el nombre DSN",
    'odbc__invalid_dsn_name' => "Sintaxis incorrecta para el nombre de la conexión ODBC (%1). Use solo caracteres alfanuméricos.",
    'odbc__no_such_driver' => "No se soporta un controlador ODBC con este nombre (%1).",
    'odbc__remove_page_title' => "Se eliminarán las siguientes conexiones DSN ODBC:",
    'odbc__select_dsn_to_remove' => "Seleccione los DSNs a eliminar.",
    'odbc__unknown_driver' => "Nombre de controlador desconocido (%1).",
    'odbc_add_new' => "Añadir una conexión DSN",
    'odbc_driver' => "Controlador",
    'odbc_dsn_description' => "Descripción de la conexión",
    'odbc_dsn_list' => "Conexiones ODBC DSN",
    'odbc_dsn_name' => "Nombre de la conexión",
    'odbc_dsn_system' => "DSN de sistema",
    'odbc_dsn_text' => "DSN de ODBC",
    'odbc_dsn_add__title' => 'Añadir un DNS ODBC',
    'odbc_req_field_not_set' => "No se han indicado los parámetros obligatorios.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'Ruta al archivo de base de datos',
    'odbc__access_pagetimeout' => 'El periodo de tiempo, en decenas de segundos, que una página no usada se mantiene en un búfer. Esta opción se aplica a todos los orígenes de datos que usen el controlador Microsoft Access.',
    'odbc__access_maxbuffersize' => 'El tamaño del búfer interno, en KB, alineado en bloques de 256 KB.',
    'odbc__access_readonly' => 'Designa la base de datos como solo-lectura para prohibir cualquier actualización.',
    'odbc__access_exclusive' => 'Designa la base de datos como exclusiva para prohibir actualizaciones compartidas.',
    'odbc__access_safetransactions' => 'De ser 0 (la opción predeterminada), todas las transacciones se aplican de inmediato. De ser 1, todas las transacciones se guardan al disco una vez finalizada la operación, pero tenga en cuenta que el rendimiento se degrada ligeramente.',
    'odbc__access_threads' => 'El número de subprocesos en segundo plano que usará el motor.',
    'odbc__access_maxscanrows' => "El número de filas a analizar cuando se define el tipo de datos de una columna en base a los datos existentes.",
    'odbc__access_implicitcommitsync' => 'Especifica cómo se aplican a la base de datos aquellos cambios realizados fuera de una transacción .',
    'odbc__access_usercommitsync' => 'Especifica si el controlador de MS Access realizará las transacciones definidas explícitamente por el usuario de forma asincrónica.',
    'odbc__mssql_server' => 'Servidor',
    'odbc__mssql_uid' => 'ID de acceso',
    'odbc__mssql_pwd' => 'Contraseña',
    'odbc__mssql_database' => 'Base de datos predeterminada para el origen de datos ODBC',
    'odbc__mssql_app' => 'Nombre de la aplicación',
    'odbc__mssql_wid' => 'ID de Workstation',
    'odbc__mssql_language' => 'Idioma nacional predeterminado a usar',
    'odbc__mssql_oemtoansi' => 'Conversión de caracteres extendidos a valores OEM',
    'odbc__mysql_server' => 'El nombre de host del servidor MySQL',
    'odbc__mysql_database' => 'Base de datos predeterminada',
    'odbc__mysql_user' => 'El nombre de usuario usado para conectarse a MySQL',
    'odbc__mysql_password' => 'La contraseña para la cuenta de usuario en el servidor',
    'odbc__mysql_port' => 'El puerto TCP/IP a usar si el servidor no es el host local',
    'odbc__mysql_socket' => 'Canalización con nombre de a conectar si el servidor es el host local',
    'odbc__mysql_option' => 'Opciones que especifican cómo debe funcionar MyODBC. Examine <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'Ruta al archivo DB',
    'odbc__excel_defaultdir' => 'Directorio de datos predeterminado',
    'odbc__excel_fil' => 'Versión de base de datos',
    'odbc__excel_maxbuffersize' => 'Tamaño máximo de búfer',
    'odbc__excel_pagetimeout' => 'Tiempo de espera de la página',

    'pb__aliases' => "Alias",
    'pb__anonftp' => "FTP anónimo",
    'pb__autoinstaller_releases' => 'Actualizador',
    'pb__cert' => "Certificados",
    'pb__cl_pool' => "Direcciones IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Configuración",
    'pb__cl_rpt' => "Informe",
    'pb__cl_rpt_list' => "Personalizar",
    'pb__cl_templates' => "Plantillas de cliente",
    'pb__cl_traffic' => "Tráfico",
    'pb__cl_traffic_history' => "Historial de tráfico",
    'pb__cl_traffic_of' => "Tráfico de %1",
    'pb__client' => "%1",
    'pb__clients' => "Clientes",
    'pb__comp_info' => "Componentes del servidor",
    'pb__common_acl' => 'Permitir transferencia ACL',
    'pb__cp_access' => "Acceso",
    'pb__crontab' => "Programador",
    'pb__scheduler' => "Programador",
    'pb__custom_buttons' => "Botones personalizados",
    'pb__databases_db' => 'Bases de datos',
    'pb__sqlservers_db' => 'Servidores SQL',//to check
    'pb__db' => "Bases de datos",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Servidores de bases de datos',
    'pb__dl_usr_ed' => "Administrador del dominio",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Límites del dominio",
    'pb__dom_pref' => "Configuración",
    'pb__dom_sum_report' => "Informe resumido del dominio",
    'pb__dom_templates' => "Plantillas de dominio",
    'pb__dom_traffic' => "Tráfico de %1",
    'pb__dom_traffic_history' => "Historial de tráfico",
    'pb__domains' => "Dominios",
    'pb__domain_aliases' => 'Alias de dominio',
    'pb__dumps_list' => "Almacenamiento de archivos de backup",
    'pb__forwarding_setup' => "Configuración de redirección",
    'pb__filemanager' => "Administrador de archivos",
    'pb__ip_aliasing' => "Direcciones IP",
    'pb__ip_clients' => "Eliminación de direcciones IP",
    'pb__license_management' => 'Administración de licencias',
    'pb__locales' => 'Idiomas',
    'pb__log_files' => "Archivos de registro",
    'pb__mail' => 'Correo',
    'pb__mail_blocked_domains' => 'Lista negra',
    'pb__mail_name_files' => "Archivos adjuntos",
    'pb__mail_name_redirects' => "Reenviadores de correo",
    'pb__mail_name_resp_attach_add' => "Adjunto nuevo",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Respuestas automáticas de correo",
    'pb__mail_names' => "Correo",
    'pb__mail_white_list' => 'Lista blanca',
    'pb__maillists' => "Listas de correo",
    'pb__mimetypes' => 'Tipos MIME',
    'pb__modules' => 'Módulos',
    'pb__modules_management' => 'Administrar módulos',
    'pb__notifications' => "Notificaciones",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Configuración de hosting físico",
    'pb__prtd_dirs' => "Directorios protegidos",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Informe",
    'pb__report_auto' => "Programación de entregas de %1",
    'pb__report_list' => "Personalizar",
    'pb__server' => "Servidor",
    'pb__sessions' => "Sesiones",
    'pb__sapp_pool' => "Grupo de aplicaciones web",
    'pb__siteapp_install' => 'Instalación de aplicación web',
    'pb__site_app_pkgs' => 'Aplicaciones web',
    'pb__site_apps' => "Aplicaciones web",
    'pb__additional_key_info' => 'Propiedades de la llave',
    'pb__additional_key_properties' => 'Propiedades de la llave',
    'pb__skeleton' => 'Plantilla de host virtual',
    'pb__skins' => 'Skins',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtro antispam",
    'pb__statistics' => "Estadísticas",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdominios",
    'pb__templates' => "Plantillas",
    'pb__virtualdirs' => 'Directorios virtuales',
    'pb__web_users' => "Usuarios web",
    'pb__webalizer_preferences' => 'Configuración de estadísticas web',
    'pdir__enter_dir_name' => "Introduzca el nombre del directorio.",
    'pdir__invalid_hst' => "El tipo de hosting no es válido. Este debe ser físico.",
    'pdir__pd_id_is_undefined' => "No se ha definido el ID del directorio protegido.",
    'pdir__pdir_exist' => "El directorio con este nombre ya está protegido.",
    'pdir__pdir_not_exist' => "El directorio protegido no existe.",
    'pdir__pdir_usr_not_exist' => "El usuario del directorio protegido no existe.",
    'pdir__prdirs_for_domain' => "Directorios protegidos bajo el sitio web %1",
    'pdir__prdirs_for_subdomain' => "Directorios protegidos para el subdominio %1",
    'pdir__remove_pdir_usrs' => "Se eliminarán los siguientes usuarios del directorio protegido %2 bajo el sitio web %1:",
    'pdir__remove_pdir_usrs_on_subdom' => "Se eliminarán los siguientes usuarios del directorio protegido %2 en el subdominio %1:",
    'pdir__remove_pdirs_on_dom' => "Como resultado de esta operación, se eliminará la protección de los directorios bajo el sitio web %2 propiedad del cliente %1. Los directorios no serán eliminados.",
    'pdir__remove_pdirs_on_subdom' => "Como resultado de esta operación, se eliminará la protección de los directorios del subdominio %1. Los directorios no serán eliminados.",
    'pdir__select_pdir_usrs_for_remove' => "Seleccione los usuarios del directorio protegido a eliminar.",
    'pdir__select_pdirs_to_remove' => "Seleccione los directorios a los que desea retirar la protección.",
    'pdir__unable_define_pdir_users' => "No se pueden definir los usuarios del directorio protegido.",
    'pdir__unable_define_pdirs_properties' => "No se pueden establecer las propiedades de los directorios protegidos: %1",
    'pdir__unable_select_dom_param' => "No se pueden seleccionar los parámetros de dominio: %1",
    'pdir_ed__create_pdir_for_domain' => "Creación de un directorio protegido bajo el sitio %1",
    'pdir_ed__create_pdir_for_subdomain' => "Crear un directorio protegido bajo el subdominio %1",
    'pdir_ed__dir_already_protect' => "Este directorio ya está protegido.",
    'pdir_ed__head_txt' => "Nombre del área protegida",
    'pdir_ed__invalid_login' => "Ha especificado un nombre de usuario incorrecto.",
    'pdir_ed__login_exists' => "Este usuario ya existe. Intente especificar otro nombre de usuario.",
    'pdir_ed__new_usr' => "Nombre de usuario",
    'pdir_ed__non_ssl' => "No SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Nombre del directorio",
    'pdir_ed__pdir_for_domain' => "Directorio protegido %1 en dominio %2",
    'pdir_ed__pdir_for_subdomain' => "Directorio protegido %1 bajo el subdominio %2",
    'pdir_ed__pdir_location' => "Ubicación del directorio",
    'pdir_ed__pdir_users' => "Usuarios del directorio protegido",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "Este sitio no soporta SSL/TLS o este no se proporciona con su suscripción. Para habilitar el soporte para SSL/TLS, vaya a la pestaña Sitios web y dominios y haga clic en el nombre de su dominio en la lista. Si su suscripción no le proporciona soporte para SSL/TLS, póngase en contacto con su proveedor de hosting para que actualice su plan de hosting.",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "Este sitio no soporta SSL/TLS. Para habilitar el soporte para SSL/TLS, vaya a la pestaña Sitios web y dominios y haga clic en el nombre de dominio en la lista.",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Al menos debería seleccionar una casilla de SSL/TLS y no-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "No se puede crear el usuario del directorio protegido: %1",
    'pdir_ed__unable_create_pdir' => "No se puede crear el directorio protegido: %1",
    'pdir_ed__unable_define_hst_type' => "No se puede definir el tipo de hosting.",
    'pdir_ed__unable_update_pdir' => "No se puede guardar la configuración del directorio protegido: %1",
    'pdir_ed__wrong_symbol_in_header' => "No use el carácter %1 en el nombre del directorio.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Crear usuario para el directorio protegido %1",
    'pdir_usr_ed__not_create_pass' => "Esta acción no creará una contraseña para el usuario nuevo del directorio protegido. Sin contraseña, el usuario no podrá iniciar sesión.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Contraseña para el usuario del directorio protegido %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "No puede seleccionar el usuario del directorio protegido: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "No se pueden definir los usuarios del directorio protegido: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "No se pueden eliminar los usuarios del directorio protegido: %1",
    'pdirs_list__name' => "Nombre",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "Estado",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "No se pueden eliminar los directorios protegidos: %1",
    'phosting__anonftp_disabled' => "Servicio FTP anónimo no disponible para este dominio porque esta dirección IP ya está siendo usada para el servicio FTP anónimo en otro dominio.",
    'phosting__anonftp_encrypt' => 'La contraseña del usuario FTP está cifrada y, por consiguiente, no puede usarse para proteger el directorio /plesk-stat/webstat/. Vuelva a introducir su contraseña FTP o deseleccione la opción "accesible a través del directorio protegido con contraseña \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "El nombre de dominio %%domain_name%% resuelve a la dirección IP %%dns_ip_address%%. Su sitio web está asignado a la dirección IP %%hosting_ip_address%%. Si su sitio web no se abre en un navegador web cuando introduce su nombre de dominio, vaya a la pantalla de administración del DNS (Dominios > Nombre del dominio > DNS) y modifique las propiedades del registro de recurso A: asigne la dirección IP %%hosting_ip_address%% al nombre de dominio %%domain_name%%.",
    'phosting__ip_change_warning' => "Dirección IP modificada. Los cambios correspondientes también se realizaron en la zona DNS del dominio.",
    'phosting__other_hosting_exists_on_ip' => "No se puede cambiar el certificado porque esta dirección IP se está usando en una o más cuentas de hosting.",
    'phosting__unable_to_change_certificate' => "No se puede instalar el certificado: %1",
    'phosting__unable_to_change_ip_address' => "No se puede cambiar la dirección IP: %1",
    'phosting__unable_to_set_cert' => "No se puede establecer el certificado SSL/TLS: %1",
    'phosting__unable_update' => "No se puede actualizar la configuración de hosting: %1",
    'phosting__unable_manage' => "No se puede administrar el hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "No ha podido configurarse fail2ban para efectuar un seguimiento de registros del dominio. Los registros se someterán a seguimiento de forma automática la próxima vez que se reinicie el servicio fail2ban.\n%1",

    'picker_acl_record__tittle' => 'Seleccione un registro ACL',
    'picker_autoresponder__title' => 'Seleccione una respuesta automática',
    'picker_black_list__domain_name' => 'Seleccione un nombre de dominio',
    'picker_certificate' => 'Seleccione un certificado SSL/TLS',

    'picker_dns_zone_template__title' => 'Seleccione un registro de recurso',
    'picker_domain__title' => 'Seleccione un sitio web',
    'picker_domain_alias__title' => 'Selección de un alias de dominio',
    'picker_resource_record__title' => 'Seleccione un registro de recurso',
    'picker_disabled_resource_record__title' => 'Seleccione un servidor de nombres',
    'picker_ip_address__title' => 'Seleccione una dirección IP',
    'picker_ip_address_clients__title' => 'Seleccione los clientes que usan esta dirección IP',
    'picker_mail_queue' => 'Seleccionar emails',
    'picker_site_application__title' => 'Seleccionar una aplicación web',
    'picker_subdomain__title' => 'Seleccione un subdominio',
    'picker_web_user__title' => 'Seleccione un usuario web',
    'picker_custom_button__title' => 'Seleccione un botón personalizado',
    'picker_license_key__title' => "Selección de llave de licencia",
    'picker_spamfilter_address__title' => 'Seleccione una dirección de filtro antispam',
    'picker_white_list__networks' => 'Selección de redes',

    'plesk_key__action_logs' => "Registro de las acciones realizadas por los usuarios de Plesk",
    'plesk_key__app_vault' => "Application Vault",
    'plesk_key__backup' => "Funciones de backup y restauración",
    'plesk_key__client_templs' => "Administración de planes de servicio",
    'plesk_key__clients' => "Cuentas de usuario (revendedores y clientes)",
    'plesk_key__resellers_only' => "Cuentas de usuario (revendedores)",
    'plesk_key__customers_only' => "Cuentas de usuario (clientes)",
    'plesk_key__domains' => "Dominios",
    'plesk_key__domain_aliases' => "Alias de dominio",
    'plesk_key__manage_dashboard' => 'Personalización de la página principal',
    'plesk_key__drweb' => "Administración del antivirus",
    'plesk_key__event_manager' => "Administrador de eventos",
    'plesk_key__expirations' => "Administración de fechas de expiración de cuentas",
    'plesk_key__group_ops' => "Modificación de múltiples objetos a la vez",
    'plesk_key__expiration' => "Fecha de expiración de la llave",
    'plesk_key__edition_name' => "Edición de Plesk",
    'plesk_key__key_number' => "Nº llave",
    'plesk_key__languages' => "Paquetes de idioma",
    'plesk_key__mailnames' => "Cuentas de correo",
    'plesk_key__migration_manager' => "Administrador de migraciones y transferencias",
    'plesk_key__mssql' => "Soporte de Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Enlaces para la compra de certificados SSL/TLS y servicios de registro de dominios",
    'plesk_key__myplesk_server_id' => "Identificador MPC del servidor secundario",
    'plesk_key__notifications' => "Administración de notificaciones",
    'plesk_key__postgresql' => "Soporte para servidor de bases de datos PostgreSQL",
    'plesk_key__qmail_queue' => 'Administración de colas de correo',
    'plesk_key__remote_db' => 'Hosting de base de datos remota',
    'plesk_key__slave_servers' => "Servidores secundarios",
    'plesk_key__spamassassin' => "Administración del filtro antispam",
    'plesk_key__subdomains' => "Administración de subdominios",
    'plesk_key__sys_access' => "Administración del acceso al servidor",
    'plesk_key__traffic_reports' => "Informes de uso de tráfico",
    'plesk_key__tts' => "Servicio de asistencia",
    'plesk_key__virtuozzo' => "Solo válido para Virtuozzo containers",
    'plesk_key__webusers' => "Usuarios web",
    'plesk_key__license_update_date' => 'Próxima actualización de la llave de licencia',
    'plesk_key__autoinstaller_config' => 'Administración de configuración del actualizador',
    'plesk_key_update__title' => 'Estado de actualización de llave',
    'plesk_key_update__legend' => 'Estado de actualización de llave',
    'plesk_key_update__new_additional_key' => 'Llave adicional nueva recibida',
    'plesk_key__check_wrong' => "La llave de licencia no es válida. Para utilizar Plesk es necesario obtener e instalar una nueva llave de licencia válida.",
    'plesk_key__upload_check_wrong' => 'La llave de licencia cargada no es válida.',
    'plesk_key__revert_check_wrong' => 'La llave de licencia instalada previamente no es válida.',
    'plesk_key__update_check_wrong' => 'La llave de licencia actualizada no es válida.',
    'plesk_key__viruozzo_only_key' => 'La llave de licencia solo puede usarse si Plesk opera en Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'Solo puede utilizar esta copia licenciada de Plesk con las siguientes direcciones IP: %2. Las siguientes direcciones IP no están cubiertas por su licencia: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'La cantidad de recursos usada actualmente sobrepasa los límites definidos por su licencia.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'El número de sitios web alojados en el servidor excede los límites definidos por su licencia. Tiene alojados %2 sitios, mientras que su licencia solo permite alojar %1 sitios.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'El número de alias de dominio en el servidor supera el límite definido por su licencia. Tiene %2 alias de dominio, mientras que su licencia solo permite alojar %1 alias de dominio.',
    'plesk_key__limits_exceeded_lim_cl' => 'El número de cuentas de cliente servidas excede los límites definidos por su licencia. Actualmente sirve %2 cuentas de cliente, mientras que su licencia solo le permite servir %1 cuentas de cliente.',
    'plesk_key__limits_exceeded_lim_mn' => 'El número de cuentas de correo servidas excede los límites definidos por su licencia. Actualmente sirve %2 cuentas de correo, mientras que su licencia solo permite servir %1 cuentas de correo.',
    'plesk_key__limits_exceeded_lim_wu' => 'El número de cuentas de usuario web servidas excede los límites definidos por su licencia. Actualmente sirve %2 cuentas de usuario web;su licencia permite servir %1 cuentas de usuario web',
    'plesk_key__limits_exceeded_MLS' => 'El número de paquetes de idioma instalados en este momento excede los límites definidos por su licencia. Tiene instalados %2 paquetes de idioma, mientras que su licencia solo le permite instalar %1 paquetes de idioma.',
    'plesk_key__wrong_version' => 'Está intentando utilizar una llave de licencia creada para otra versión de Plesk. Para obtener una llave de licencia adecuada, póngase en contacto con su responsable comercial de Plesk.',
    'plesk_key__other_product' => 'Está intentando utilizar una llave de licencia creada para otro producto. Para obtener una llave de licencia adecuada, póngase en contacto con su responsable comercial de Plesk.',
    'plesk_key__limits_exceeded_error' => 'No se puede instalar la llave de licencia: las cantidades de recursos usadas en este momento exceden los límites definidos en la llave de licencia cargada.',
    'plesk_key__limits_exceeded_note' => 'Las cantidades de recursos usadas en este momento exceden los límites definidos en la llave de licencia cargada.',
    'plesk_key__key_file_invalid' => 'El archivo de llave de licencia cargado no es válido o no contiene ninguna llave de licencia.',
    'plesk_key__server_request_error' => 'No pudo actualizarse la licencia. Compruebe que las conexiones al servidor de licencias ka.plesk.com en el puerto TCP %1 no están bloqueadas. <a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">Descubra cómo</a>.',
    'key__title' => 'Administración de licencias',
    'key__upload_title' => 'Instalar una llave de licencia',
    'key__no_key_file_in_zip' => 'El archivo .zip cargado no contiene ningún archivo de llave',
    'key__key_upload' => 'Instalación de llave de licencia',
    'key__tabs_plesk' => 'Llave de licencia de Plesk',
    'key__tabs_additional' => 'Llaves de licencia adicionales',
    'key_revert__title' => 'Reversión de la llave de licencia',
    'key_revert__legend' => 'Confirmación de reversión de llave',
    'key_revert__text' => 'Se restaurará la llave de licencia con las siguientes propiedades:',
    'key__license_update_date_hint' => 'La fecha de expiración se ampliará automáticamente el %%license_update_date%%. Si desea realizar una actualización automática, debe permitir las conexiones a %%keyserver_host%%. Para más información, consulte %%help begin:lim_date%%el siguiente tema de la ayuda%%help end:lim_date%%.',
    'additional_key__info' => 'Propiedades de la llave adicional',
    'additional_key__prop_name' => 'Propiedad',
    'additional_key__prop_value' => 'Valor',
    'additional_key__descr_name' => 'Nombre de la llave',
    'additional_key__descr_key_number' => 'Nº llave',
    'additional_key__descr_key_vz' => "Esta llave de licencia solo puede usarse en Virtuozzo containers.",
    'additional_key__descr_lim_date' => 'Fecha de expiración',
    'additional_key__descr_license_update_date' => 'Próxima actualización de la llave de licencia',
    'additional_key__remove_title' => "Se eliminará la llave de aplicación web con las siguientes propiedades:",
    'additional_keys__remove_title' => "Se eliminarán las siguientes llaves adicionales:",
    'additional_keys__select_to_remove' => 'Seleccione las llaves adicionales a eliminar.',
    'additional_key__file_invalid' => 'El archivo de llave de licencia cargado no es válido o no contiene ninguna llave de licencia.',
    'additional_key__file_incompatible' => 'El archivo de llave cargado no es válido para esta aplicación.',
    'additional_key__expired' => 'Esta llave adicional ha expirado.',
    'additional_key__not_exists' => 'No se ha instalado ninguna llave de licencia.',
    'additional_key__viruozzo_only_key' => 'Esta llave de licencia solo puede usarse si Plesk está instalado en Virtuozzo containers.',
    'additional_keys__legend' => 'Llaves adicionales',
    'additional_keys__list_header' => 'Llaves adicionales',
    'additional_key_update__result_response' => 'Respuesta del servidor de licencias: %1',
    'additional_key_update__result_network' => 'No se puede conectar con el servidor de licencias. Compruebe que su red permite la comunicación con %1: %2.',
    'additional_key_update__result_lock' => 'Actualización de llave en curso',
    'additional_key_update__result_internal_error' => 'Se ha producido un error mientras se actualizaba la llave de licencia: %1',

    'additional_key_revert__title' => 'Confirme la operación',
    'additional_key_revert__legend' => 'Propiedades de la llave adicional usada anteriormente',
    'additional_key_revert__confirm_text' => 'Revertir llave',
    'additional_key_revert__confirm_required' => 'Confirme la operación.',

    'proceed_to_cl_pool' => "Configurar el grupo de direcciones IP del cliente",
    'proceed_to_hosting_setup' => "Configurar hosting",
    'removeCerts__remove_certificates_cp' => "Se eliminarán los siguientes certificados:",
    'removeCerts__remove_certificates_domain' => "Se eliminarán los siguientes certificados propiedad de %1:",
    'removeClientsIP_remove_clients_ip' => "Esta dirección IP será eliminada de los grupos de direcciones IP de los siguientes clientes:",
    'removeMailAliases__remove_mail_aliases' => "Se eliminarán los siguientes alias de correo para la cuenta de correo %1:",
    'removeMailNames__remove_mailnames' => "Se eliminarán las siguientes cuentas de correo y alias del dominio %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Las siguientes cuentas de correo y alias serán eliminados del dominio %2 propiedad del cliente %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Estas cuentas de correo no se eliminarán.",
    'removeFtpSessions__remove_title' => "Las siguientes sesiones FTP serán finalizadas:",
    'removeTemplates__remove_templates' => "Se eliminarán las siguientes plantillas:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'Frecuencia',
    'report_auto__list_last' => 'Ultimo envío',
    'report_auto__list_recipient' => 'Enviar a',
    'report_auto__list_select' => 'Informe activo',
    'report_auto__title' => 'Entregas programadas para %1',
    'report_auto__recipient_email' => 'la dirección especificada',
    'report_auto__recipient_admin' => 'administrador del servidor',
    'report_auto__recipient_client' => 'el cliente',
    'report_auto__recipient_domain' => 'el administrador del dominio',
    'report_auto_edit__select' => 'Informe activo',
    'report_auto__select_client_report_all' => 'todos los clientes',
    'report_auto__select_client_report_current' => 'este cliente',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'todos los dominios',
    'report_auto__select_domain_report_other_client' => 'todos los dominios de %1',
    'report_auto__select_domain_report_client' => 'todos los dominios de este cliente',
    'report_auto__select_domain_report_reseller' => 'todos los dominios de este revendedor',
    'report_auto__select_domain_report_current' => 'este dominio',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Programaciones de entrega',
    'report_auto__select_for_remove' => "Seleccione las entregas programadas a eliminar.",
    'report_auto_remove__title' => "Se eliminarán las siguientes entregas programadas de informes:",
    'report_auto_edit__title' => 'Propiedades de entregas programadas',
    'report_auto_edit__recipient' => 'Enviar a',
    'report_auto_edit__target' => 'Informe activo',
    'report_auto_edit__auto' => 'Frecuencia de envío',
    'resp_edit__always_respond' => "responder siempre",
    'resp_edit__reply_subject' => "Asunto del email de respuesta",
    'resp_edit__answer_subject' => "Contestar con asunto",
    'resp_edit__answer_txt' => "Contestar con texto",
    'resp_edit__attach' => "Adjuntar archivos",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "para",
    'resp_edit__frw_rqst_email' => "En caso de respuesta automática, reenviar el mensaje original al email especificado",
    'resp_edit__fwd_email_invalid' => "La dirección de email de destino no es válida.",
    'resp_edit__in_body' => "cuando las palabras indicadas estén en el cuerpo del mensaje",
    'resp_edit__in_subject' => "cuando las palabras indicadas estén en el asunto del mensaje",
    'resp_edit__invalid_resp_freq' => "Frecuencia de respuesta no válida.",
    'resp_edit__invalid_rqst_txt' => "Texto solicitado no válido.",
    'resp_edit__invalid_store_lim_num' => "El valor de límite no es válido.",
    'resp_edit__limits_title' => "Límites",
    'resp_edit__maximum_allowed_resp_freq_reached' => "El número máximo de respuestas por día excede la tasa definida. Permitido: %1, solicitado: %2",
    'resp_edit__no_files_sel' => "Ningún archivo seleccionado.",
    'resp_edit__no_txt_supplied' => "Ningún texto proporcionado.",
    'resp_edit__reply_title' => "Responder",
    'resp_edit__reply_to_address' => "Remite",
    'resp_edit__reply_to_invalid' => "Remite no válido.",
    'resp_edit__reply_uniq_email' => "Contestar a la dirección de email única no más de",
    'resp_edit__conditions_title' => "Condiciones",
    'resp_edit__request_title' => "Solicitar",
    'resp_edit__resp' => "Respuesta automática",
    'resp_edit__resp_name' => "Nombre de la respuesta automática",
    'resp_edit__resp_not_exist' => "La respuesta automática no existe.",
    'resp_edit__resp_status' => "Estado de la respuesta automática",
    'resp_edit__rqst_txt' => 'Indique la condición para esta respuesta automática',
    'resp_edit__select_files_on_server_for_attach' => "Seleccione los archivos que desea adjuntar",
    'resp_edit__store_up_to' => "Guardar hasta",
    'resp_edit__subj_line_invalid' => "La línea de asunto no es correcta.",
    'resp_edit__text_too_big' => "El texto de la respuesta es demasiado grande.",
    'resp_edit__times_in_a_day' => "veces por día.",
    'resp_edit__unable_define_resp_cond' => "No se pudo definir la condición de la respuesta automática: %1",
    'resp_edit__unable_define_resp_status' => "No se pudo definir el estado de la respuesta automática: %1",
    'resp_edit__unable_turn_on_resp' => "No se pudo activar la respuesta automática: %1",
    'resp_edit__uniq_email' => "direcciones de email únicas",
    'resp_edit__content_type' => 'Formato de envío',
    'resp_edit__content_type_text' => 'Texto sin formato',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Codificación',
    'restart__dns' => 'Servidor DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Servidor IMAP/POP3 (%1)",
    'restart__mssql' => "Microsoft SQL Server",
    'restart__mysql' => "Servidor MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Servicios",
    'restart__smtp' => "Servidor SMTP (%1)",
    'restart__spamd' => "Filtro antispam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Servidor web (%1)",
    'restart__ftp' => "Servidor FTP (%1)",
    'restart__service_start' => 'Tenga en cuenta que el servicio necesita unos minutos para iniciarse.',
    'restart__service_stop' => 'Tenga en cuenta que el servicio necesita unos minutos para detenerse.',
    'restart__service_restart' => 'Tenga en cuenta que el servicio necesita unos minutos para reiniciarse.',
    'rm_domains__some_domains_are_not_exist' => "Algunos de los dominios especificados no existen. Posiblemente hayan sido eliminados por otro usuario.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "GruposCorreo",
    'rpt_cl_dom_mail_lists' => "ListasC",
    'rpt_cl_dom_mail_resps' => "Arespondedor.",
    'rpt_cl_dom_mail_antispam' => "Antispam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "Buzones",
    'rpt_cl_dom_redirects' => "Redireccionamientos",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "AlDom",
    'rpt_cl_dom_web_users' => "Wusers",
    'rpt_cl_report_for_admin__' => "Informe para el administrador %1",
    'rpt_cl_report_for_reseller__' => "Informe para el revendedor %1",
    'rpt_cl_report_for_cl__' => "Informe sobre el cliente %1",
    'rpt_cl_section_domains' => "Dominios",
    'rpt_cl_section_full_domains' => "Dominios",
    'rpt_cl_section_general' => "General",
    'rpt_create' => "Crear informe",
    'rpt_empty' => "El informe al menos debe contener una sección",
    'rpt_default_report' => "Usar como informe predeterminado",
    'rpt_dom_report_for_dom__' => "Informe de dominio para %1",
    'rpt_dom_section_databases' => "Bases de datos",
    'rpt_dom_section_full_databases' => "Bases de datos",
    'rpt_dom_section_full_maillists' => "Listas de correo",
    'rpt_dom_section_full_mailnames' => "Cuentas de correo",
    'rpt_dom_section_full_webusers' => "Usuarios web",
    'rpt_dom_section_full_siteapps' => 'Aplicaciones web',
    'rpt_dom_section_full_aspnetapps' => 'Aplicaciones web ASP.NET',
    'rpt_dom_section_general' => "General",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Listas de correo",
    'rpt_dom_section_mailnames' => "Cuentas de correo",
    'rpt_dom_section_siteapps' => 'Aplicaciones web',
    'rpt_dom_section_aspnetapps' => 'Aplicaciones web ASP.NET',
    'rpt_dom_section_webusers' => "Usuarios web",
    'rpt_dom_title_wa_status' => "Estado",
    'rpt_edit__' => "Editar informe %1",
    'rpt_enter_email_address' => "Introduzca la dirección de email donde se enviará el informe.",
    'rpt_list' => "Informes personalizados",
    'rpt_name' => "Nombre del informe",
    'rpt_remove_reports' => "Se eliminarán los siguientes diseños de informes:",
    'rpt_reports' => "Informes",
    'rpt_section_full' => "Completo",
    'rpt_section_none' => "Ninguno",
    'rpt_section_summary' => "Resumen",
    'rpt_select_reports_for_remove' => "Seleccione los diseños de informe a eliminar.",
    'rpt_default_full' => 'Informe completo',
    'rpt_default_summary' => 'Informe resumido',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Error al enviar el informe: %1",
    'rpt_send_report_by_email_ok__' => "El informe se envió a %1",
    'sa_action' => "Acción",
    'sa_action_del' => "Eliminar",
    'sa_action_desc' => "Qué hacer con el correo spam",
    'sa_action_save' => "Marcar como spam y almacenarlo en el buzón",
    'sa_admin_blacklist' => "Lista negra del administrador",
    'sa_admin_whitelist' => "Lista blanca del administrador",
    'sa_blacklist' => "Lista negra",
    'sa_blacklist_desc' => "Marcar siempre como spam el correo procedente de las direcciones",
    'sa_by_tag' => "por etiqueta",
    'sa_conf_list_black' => "¿Está seguro de que desea eliminar los patrones seleccionados de la lista negra?",
    'sa_conf_list_ignore' => "¿Está seguro de que desea eliminar los patrones seleccionados de la lista a ignorar?",
    'sa_conf_list_white' => "¿Está seguro de que desea eliminar los patrones seleccionados de la lista blanca?",
    'sa_db_del_confirm' => "¿Está seguro de que desea vaciar la base de datos del filtro antispam?",
    'sa_disabled__mailserv_not_support_sa_mbox_settings' => "El filtro antispam está desactivado porque el servidor de correo no soporta la configuración del filtro antispam a nivel de buzón de correo.",
    'sa_eml_in_ignorelist' => "La dirección de email está en la lista de ignorados",
    'sa_eml_pattern' => "Patrón de email",
    'sa_empty_email' => "No se pueden añadir patrones vacíos de email.",
    'sa_exists_email' => "Este patrón de email ya existe.",
    'sa_disabled__mailname_not_filtering' => "La configuración actual del servidor no permite usar el filtro de correo para esta cuenta de correo",
    'sa_disabled__filtering_is_disabled' => 'El administrador del servidor ha desactivado la filtración de spam',
    'sa_disabled__hasnt_mailbox' => "No se puede activar la filtración de spam si no dispone de un buzón de correo",
    'sa_enable_filter' => "Activar filtración de spam",
    'bt_sa_clear_db' => 'Vaciar la base de datos del filtro antispam',
    'bt_sa_forget' => 'Olvidar',
    'bt_sa_learn_as_spam' => "¡Es Spam!",
    'bt_sa_learn_as_nonspam' => "No es spam",
    'sa_forget' => "olvidar",
    'sa_from' => "Desde",
    'sa_ham' => "correo deseado",
    'sa_ignorelist' => "Lista de ignorados del servidor",
    'sa_ignorelist_desc' => "No filtrar el correo para estas cuentas",
    'sa_pattern_in_blacklist' => "El patrón ya existe en la lista negra.",
    'sa_pattern_in_ignorelist' => "El patrón ya existe en la lista de ignorados.",
    'sa_pattern_in_whitelist' => "El patrón ya existe en la lista blanca.",
    'sa_pattern_is_invalid' => "El patrón no es válido.",
    'sa_select_email' => "Seleccione al menos un patrón de la lista para eliminarlo.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Aprendizaje del filtro antispam',
    'sa_trainer__tools_legend' => 'Herramientas',
    'sa_trainer__info_legend' => 'Información',
    'sa_trainer__messages_list_legend' => 'Mensajes en su buzón',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Asunto',
    'sa_trainer__from' => 'Desde',
    'sa_trainer__date' => 'Fecha',
    'sa_trainer__info_text' => 'Mensajes aprendidos: %1 como spam, %2 como no spam, %3 en total.',
    'sa_trainer__messages' => 'mensaje(s)',
    'sa_trainer__select__all' => 'Todos',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'No spam',
    'sa_trainer__select__unknown_only' => 'Desconocido',
    'sa_trainer__cannot_remove_messages' => 'No se pueden eliminar los mensajes seleccionados de la bandeja de entrada.',
    'sa_trainer__remove_messages_confirm' => '¿Está seguro de que desea eliminar los mensajes seleccionados del buzón?',
    'sa_srv_blacklist' => "Lista negra a nivel de servidor",
    'sa_srv_whitelist' => "Lista blanca a nivel de servidor",
    'sa_subj' => "Asunto",
    'sa_training' => "Aprendizaje del filtro antispam",
    'sa_training_legend' => "Entrenamiento del filtro bayesiano",
    'sa_use_srv_settings' => "Usar opciones del servidor",
    'sa_user_blacklist' => "Lista negra del usuario",
    'sa_user_whitelist' => "Lista negra del usuario",
    'sa_usr_disabled_by_srv' => "El administrador del servidor no permite aplicar una configuración personalizada para la filtración de spam",
    'sa_usr_no_postbox' => "No es posible activar la filtración de spam porque el buzón de correo está desactivado para esta cuenta de correo.",
    'sa_whitelist' => "Lista blanca",
    'sa_whitelist_desc' => "Nunca marcar como spam el correo procedente de las direcciones",
    'sa_filters' => 'Filtros antispam',
    'sa_max_mail' => 'No filtrar si el correo excede el tamaño especificado',
    'sa_size_limit_text' => 'tamaño máximo',
    'sa_invalid__max_spam_threads' => 'Valor no válido. Introduzca un valor entre 1 y 32.',
    'sa_max_threads' => 'Nº procesos que puede crear el filtro antispam',
    'sa_max_threads_maximum' => '(máximo 32)',
    'sa_disabled__spamfilter_not_support_sa_max_threads_limit' => '(no disponible: el filtro antispam actual no soporta esta opción)',
    'spamfilter__tools_legend' => 'Herramientas',
    'spamfilter__prefs_legend' => 'Configuración',
    'spamfilter__max_children' => 'Número máximo de procesos de trabajo spamd a ejecutar',
    'spamfilter__rewrite_header_subject_hint' => 'Deje este campo en blanco si no desea añadir ningún texto. Introduzca _SCORE_ si desea incluir la puntuación en el asunto del mensaje.',
    'spamfilter__reject_spam' => 'Eliminar correo spam cuando llegue al buzón de entrada',
    'spamfilter__enabled' => 'Activado',
    'spamfilter_addresses_list__tools_legend' => 'Herramientas',
    'spamfilter_addresses_list__list_legend' => 'Direcciones',
    'spamfilter_addresses_list__items' => 'direcciones',
    'spamfilter_addresses_list__status' => 'Estado',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => 'Dirección',
    'spamfilter_addresses__file_legend' => 'Desde archivo',
    'spamfilter_addresses__file_label' => 'Nombre del archivo',
    'spamfilter_addresses__file_hint' => 'Cargue un archivo con codificación UTF-8.',
    'spamfilter_addresses__text_legend' => 'Desde lista',
    'spamfilter_addresses__text_label' => 'Direcciones de email',
    'spamfilter_addresses__remove_title' => 'Las siguientes direcciones se eliminarán de la lista:',
    'spamfilter_addresses__empty_selection' => 'Ninguna dirección seleccionada.',
    'server__admin_info' => "Información del administrador",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Introduzca a continuación la descripción del problema",
    'server__power_management' => "Administración de energía",
    'server__services' => "Servicios",
    'server__system' => "Sistema",
    'server__title' => "Administración del servidor",
    'server_preferences__admin_skin' => "Skin del interfaz del administrador",
    'server_preferences__count_disk_space' => "¿Qué desea incluir en el cálculo de uso de espacio en disco?",
    'server_preferences__count_traffic' => "¿Qué desea incluir en el cálculo de tráfico?",
    'server_preferences__count_type' => 'Al calcular el uso del espacio en disco, contabilizar',
    'server_preferences__count_type__byte' => 'tamaño del archivo',
    'server_preferences__count_type__block' => 'cantidad de espacio en disco usado',
    'server_preferences__default_language' => "Idioma predeterminado",
    'server_preferences__default_skin' => "Skin predeterminado",
    'server_preferences__include_databases' => "bases de datos",
    'server_preferences__include_domaindumps' => "archivos de backup del dominio",
    'server_preferences__include_incoming' => "solo tráfico entrante",
    'server_preferences__include_incoming_and_outgoing' => "tráfico entrante y saliente",
    'server_preferences__include_logs' => "archivos de registro e informes estadísticos",
    'server_preferences__include_mailboxes' => "buzones de correo",
    'server_preferences__include_maillists' => "listas de correo",
    'server_preferences__include_outgoing' => "solo tráfico saliente",
    'server_preferences__include_remote_databases' => 'Bases de datos remotas',
    'server_preferences__keep_stats' => "Conservar estadísticas de tráfico y web durante",
    'server_preferences__restart_apache_interval' => "Intervalo de reinicio de Apache",
    'server_preferences__stat_warning' => "Los cambios realizados en el esquema de cálculo del uso del espacio en disco solo se aplicarán durante el próximo cálculo de estadísticas.",
    'server_preferences__title' => "Configuración del servidor",
    'server_preferences__system' => 'Configuración del sistema',
    'server_mail__title' => "Configuración de correo a nivel de servidor",
    'mail__tabs_preferences' => "Configuración",
    'mail__tabs_white_list' => "Lista blanca",
    'mail__tabs_blocked_domains' => "Lista negra",
    'mail__tabs_mail_queue' => "Cola de correo",
    'server_preferences__use_vocabulary' => "Verificar las contraseñas para buzones en el diccionario",
    'sessions__agreement' => "Si, deseo finalizar estas sesiones.",
    'sessions__select_sessions_for_remove' => "Seleccione las sesiones a finalizar.",
    'sessions__tabs_cp_sessions' => 'Sesiones de Plesk',
    'sessions__tabs_ftp_sessions' => 'Sesiones FTP',
    'sessions__ftp_sessions_login' => 'Nombre de usuario de la cuenta FTP',
    'sessions__ftp_sessions_domain' => 'Nombre del dominio',
    'sessions__ftp_sessions_path' => 'Ubicación actual',
    'sessions__ftp_sessions_file' => 'Nombre del archivo',
    'sessions__ftp_sessions_action' => 'Estado',
    'sessions__ftp_sessions_speed' => 'Velocidad, KB/S',
    'sessions__ftp_sessions_comp' => 'Progreso, %',

    'site_apps__access_level' => 'Nivel de acceso',
    'site_apps__access_level_commercial' => 'Comercial',
    'site_apps__access_level_free' => 'Gratuita',
    'site_apps__action_installer' => "Instalación de aplicación web",
    'site_apps__action_reconfigure' => "Reconfiguración de aplicación web",
    'site_apps__custom_button_level' => '¿Desea crear un botón personalizado para acceder a esta aplicación?',
    'site_apps__custom_button_level_false_domain_user_only' => 'No',
    'site_apps__custom_button_level_domain_user_only' => 'Sí',
    'site_apps__custom_button_level_false' => 'No',
    'site_apps__custom_button_level_domain' => 'Sí, hacerlo disponible solo para el dominio actual',
    'site_apps__custom_button_level_client' => 'Sí, hacerlo disponible para todos los dominios del cliente',
    'site_apps__custom_button_level_admin' => 'Sí, hacerlo disponible para todos los dominios',
    'site_apps__description' => "Descripción",
    'site_apps__dir_used_by_sapp__' => "El directorio \"%1\" es usado por otra aplicación web",
    'site_apps__dir_used_by_unknown__' => "El directorio \"%1\" ya existe. Si continua, se sobrescribirán sus contenidos.",
    'site_apps__dir_invalid_name__' => "El nombre del directorio %1 no es correcto",
    'site_apps__file_name' => 'Nombre de archivo de la aplicación web',
    'site_apps__invalid_install_prefix' => "Prefijo de instalación no válido",
    'site_apps__invalid_package' => "La aplicación web no es válida",
    'site_apps__key_status' => 'Licencia',
    'site_apps__key_status_free' => 'Distribución gratuita. No se requiere ninguna llave de licencia',
    'site_apps__key_status_ok' => 'La llave de licencia requerida está instalada',
    'site_apps__key_status_problem' => 'La llave de licencia requerida no está instalada',
    'site_apps__name' => "Nombre",
    'site_apps__no_domains' => 'La aplicación web no puede instalarse. Ya existe otra aplicación web instalada en el directorio raíz de este dominio. Considere crear un subdominio para la aplicación web.',
    'site_apps__package_info_' => "Info de la aplicación web",
    'site_apps__package_integrated' => "aplicación integrada, no puede eliminarse",
    'site_apps__pool_select_packages_to_add' => 'Seleccione las aplicaciones web a añadir al grupo de aplicaciones',
    'site_apps__release' => "Versión",
    'site_apps__resource_used_by_sapp' => "Este recurso es usado por la aplicación web instalada",
    'site_apps__root_used_by_sapp' => "Este recurso es usado por una aplicación web instalada",
    'site_apps__these_domains_will_not_delete' => 'Estos (sub)dominios no se eliminarán.',
    'site_apps__upload_site_app_pkg_title' => 'Cargar aplicación web nueva',
    'site_apps__version' => "Versión",
    'site_apps__access_to' => "Acceso a %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Plantilla del host virtual",
    'skeleton__client_label' => "%1 plantilla de host virtual",
    'skeleton__admin_page' => "Administrar plantilla del host virtual",
    'skeleton__files_list' => "Archivos y directorios",
    'skeleton__archiver_not_installed' => "No se puede descomprimir el archivo. Puede que el archivador no esté instalado en el servidor. Póngase en contacto con el administrador de {$PROD_NAME} para que se lo instale.",
    'skeleton__client_page' => "Administrar plantilla del host virtual",
    'skeleton__archive_corrupted' => "El test del archivador ha detectado que el archivo está dañado o que este tipo de archivo no es soportado.",
    'skeleton__archive_too_large' => "El test del archivador ha detectado que el archivo es demasiado grande.",
    'skeleton__not_supported_archive_type' => "No se soporta este tipo de archivo (archivo %1).",
    'skeleton__upload_archive_file' => "Cargar archivo",
    'skin_download__title' => 'Descargar skin',
    'skin_download_now__title' => 'Descarga de skin en curso',
    'skin_download_now__text' => 'Creación del paquete de skins en curso. <br>Este proceso puede tardar unos minutos. <br>Cuando aparezca la ventana de diálogo, podrá seguir usando Plesk.',
    'skin_file__help_for_using_types' => "Use los archivos de skin en alguno de los siguientes formatos:",
    'skin_info__title' => 'Propiedades del skin',
    'skin_mng_err__rpm_not_skin' => 'Este RPM no es un paquete de skins de Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Error al instalar skin basado en rpm en la ubicación especificada.',
    'skin_mng_err__already_exists' => 'El directorio de instalación del skin ya existe y ya se ha desplegado un paquete de skins.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'El archivo cargado no es un paquete de skins RPM válido.',
    'skin_mng_err__rpm_upgrade_noskin' => 'El archivo cargado no es un paquete de skins válido.',
    'skin_mng_err__rpm_upgrade_base' => "El archivo cargado no es un paquete de skins válido de {$PROD_NAME}.",
    'skin_mng_err__rpm_upgrade_other' => 'No se puede instalar el skin:formato de skin no válido.',
    'skin_mng_err__no_a_skin' => "El archivo cargado no es un paquete de skins válido de {$PROD_NAME}.",
    'skin_upload__title' => 'Cargar skin nuevo',
    'skin_upload__already_exists' => "El skin '%1' ya existe.",
    'skin_upload__unable_to_apply' => "El archivo cargado no contiene ningún skin de Plesk o no se soporta el formato del archivo comprimido.",
    'skin_upload__unable_to_rename__' => "No se puede cambiar el nombre del skin %2 a %1: %3.",
    'skin_upload__file_name' => 'Ruta hacia el archivo del paquete de skin',
    'skins_list__title' => 'Repositorio de skins',
    'skins_remove__title' => 'Eliminación de skins',
    'skins_remove__select_skins_for_remove' => 'Seleccione los skins a eliminar',

    'spamassassin__title' => "Configuración del filtro antispam",
    'spf_parameters' => 'Protección antispam SPF',
    'spf_enable_label' => 'Activar protección antispam SPF para el análisis del correo entrante',
    'spf_behavior' => 'Modo de verificación SPF',
    'spf_rules' => 'Reglas locales SPF',
    'spf_guess' => 'Reglas de conjetura SPF',
    'spf_exp' => 'Texto de explicación SPF',
    'spf__unable_update' => 'No se pueden actualizar los parámetros SPF',
    'spf_bhv__create_headers_no_block' => 'Solo crear cabeceras SPF de recepción, nunca bloquear',
    'spf_bhv__use_tmp_errors' => 'Usar avisos de error temporal cuando tenga problemas de resolución DNS',
    'spf_bhv__reject_if_fail' => 'Rechazar correo cuando SPF resuelva a "fail" (denegar)',
    'spf_bhv__reject_if_softfail' => 'Rechazar correo cuando SPF resuelva a "softfail"',
    'spf_bhv__reject_if_neutral' => 'Rechazar correo cuando SPF resuelva a "neutral"',
    'spf_bhv__reject_if_no_pass' => 'Rechazar correo cuando SPF no resuelva a "pass"',
    'sshterm__title' => 'Terminal Shell seguro',
    'sshterm__password_authentication_warning' => 'Nota: La autenticación de contraseñas está desactivada en la configuración local del servidor SSH. Si no puede conectarse usando el Terminal SSH, pida al administrador que configure "PasswordAuthentication yes" en el archivo /etc/ssh/sshd_config.',
    'sshterm__password_authentication_warning_admin' => 'Nota: La autenticación de contraseñas está desactivada en la configuración local del servidor SSH. Si no puede conectarse usando el Terminal SSH, pida al administrador que configure "PasswordAuthentication yes" en el archivo /etc/ssh/sshd_config.',
    'statistics__active_domains' => "Dominios activos",
    'statistics__clients' => "Clientes",
    'statistics__subdomains' => "Subdominios",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Bases de datos",
    'statistics__db_users' => "Usuarios de base de datos",
    'statistics__dirs' => "Directorios protegidos",
    'statistics__dom_active' => "Activos",
    'statistics__dom_passive' => "Pasivos",
    'statistics__dom_problem' => "Problema",
    'statistics__domains' => "Dominios",
    'statistics__domains_with_host' => "Dominios con hosting",
    'statistics__doms' => "Dominios",
    'statistics__filesystem' => "Sistema de archivos",
    'statistics__general' => "General",
    'statistics__hdd_available' => "Disponible",
    'statistics__hdd_capacity' => "Capacidad",
    'statistics__hdd_total' => "Total",
    'statistics__hdd_usage' => "Uso del disco duro",
    'statistics__hdd_used' => "Usado",
    'statistics__ip' => "Dirección IP",
    'statistics__key_number' => "Nº llave",
    'statistics__l1' => "Último minuto",
    'statistics__l15' => "Últimos 15 minutos",
    'statistics__l5' => "Últimos 5 minutos",
    'statistics__la' => "Uso de CPU",
    'statistics__mail_autoresponders' => "Respuestas automáticas",
    'statistics__mail_boxes' => "Buzones de correo",
    'statistics__mail_groups' => "Grupos de correo",
    'statistics__mail_lists' => "Listas de correo",
    'statistics__mail_redirects' => "Reenviadores de correo",
    'statistics__mem' => "Uso de memoria",
    'statistics__mem_usage' => "Uso",
    'statistics__memory_available' => "Disponible",
    'statistics__memory_buffer' => "Búfer",
    'statistics__memory_cached' => "En caché",
    'statistics__memory_free' => "Gratuita",
    'statistics__memory_shared' => "Compartida",
    'statistics__memory_total' => "Total",
    'statistics__memory_used' => "Usado",
    'statistics__os' => "SO",
    'statistics__problem_clients' => "Clientes con incidencias",
    'statistics__problem_domains' => "Dominios con incidencias",
    'statistics__swap' => "Uso de swap",
    'statistics__swap_free' => "Gratuita",
    'statistics__swap_total' => "Total",
    'statistics__swap_usage' => "Uso",
    'statistics__swap_used' => "Usado",
    'statistics__system_stat' => "Información del servidor",
    'statistics__unable_define_active_doms' => "No se puede determinar el número de dominios activos: %1",
    'statistics__unable_define_inactive_doms' => "No se puede determinar el número de dominios inactivos: %1",
    'statistics__failed_define_swap_usage' => 'Failed to define Swap Usage',
    'statistics__failed_define_load_averages' => 'Failed to define Load Averages',
    'statistics__up_time' => "Sistema funcionando desde:",
    'statistics__ver' => "Versión",
    'statistics__web_users' => "Usuarios web",
    'statistics__mem_win' => "Uso de memoria física",
    'statistics__memory_total_win' => "Total",
    'statistics__memory_used_win' => "Usado",
    'statistics__memory_free_win' => "Disponible",
    'statistics__swap_win' => "Uso de memoria virtual",
    'statistics__swap_total_win' => "Total",
    'statistics__swap_used_win' => "Usado",
    'statistics__swap_free_win' => "Disponible",
    'status__domain_has_reasons_to_be_off' => "El dominio aún está suspendido por la siguiente razón: %1",
    'subdomain__create__' => "Crear un subdominio en el dominio %1",
    'subdomain__edit__' => "Gestionar subdominio %1",
    'subdomain__invalid_name' => "El nombre del subdominio no es correcto. Use únicamente símbolos alfanuméricos y guiones.",
    'subdomain__incorrect_name' => "Nombre de subdominio no válido.",
    'subdomains__maillists_enabled_in_domain' => "Lista de nombres de subdominios incorrecta.%1: este nombre de dominio ya está siendo usado por listas de correo del dominio %1.",
    'subdomains__dalias_exists' => 'Ya existe un alias de dominio con este nombre.',
    'subdomains__name_exists' => "Ya existe un subdominio con este nombre.",
    'subdomains__regular_domain_exists' => "Ya existe un dominio con este nombre.",
    'subdomains__domain_alias_exists' => 'Ya existe un alias de dominio con este nombre.',
    'subdomains__remove_subdomains_on_domain' => "Se eliminarán los siguientes subdominios del dominio %1:",
    'subdomains__select_subdomains_for_remove' => "Seleccione los subdominios a eliminar.",
    'subdomains__webmail_enabled_in_domain' => "Nombre de webmail del subdominio incorrecto.%1: este nombre de dominio ya está siendo usado para acceder al webmail bajo el dominio %1.",
    'subdomains__dns_record_already_exists' => 'No se puede crear el subdominio %1 porque ya existe un registro DNS que apunta al host %1.',
    'subdomains__www_prefix_in_domain' => "Nombre de subdominio incorrecto www.%1: el dominio %1 ya dispone del prefijo WWW.",
    'subdomains__user_type_quota_exceeds' => 'No se puede cambiar la cuenta de usuario porque excedería el espacio en disco asignado.',
    'subdomains__creation_in_dns_slave' => "El servidor de nombres de Plesk actúa como servidor de nombres secundario (esclavo) para este dominio. Para que su subdominio se resuelva correctamente, compruebe que el archivo de zona en el servidor principal (maestro) contiene el registro %1.",
    'sys_user__attributes_not_changed' => "No se cambiaron los siguientes atributos del usuario del sistema: %1",
    'sys_user__no_access_without_password' => "No estableció ninguna contraseña. El usuario del sistema será creado, pero este no podrá acceder al sistema hasta que disponga de una contraseña. ¿Desea continuar?",
    'sys_user__no_hard_quota' => "no soportados",
    'sysuser__zero_quota_is_unlimited' => "0 para ilimitado",
    'template__num_excl_ips' => "Asignar direcciones IP dedicadas al cliente",
    'template__sel_sh_ips' => "Direcciones IP compartidas seleccionadas",
    'template__av_sh_ips' => "Direcciones IP compartidas disponibles",
    'template__up_to_excl_ip' => "Hasta %1 direcciones IP",
    'templates__all_clients' => "todos los clientes",
    'templates__cl_domain_templates' => "Plantillas para %1",
    'templates__cl_templates' => "Plantillas de cliente",
    'time__day' => "Día",
    'time__dom_name_ip' => "Nombre de dominio o IP",
    'time__hours' => "Horas",
    'time__invalid_ip' => "Dirección IP o nombre de dominio no válido.",
    'time__invalid_year' => "Año no válido. Debe ser un valor entre 1971 y 2036.",
    'time__invalid_month' => "El mes no es válido. Debe ser un valor entre 1 y 12.",
    'time__invalid_day' => "El día no es válido. Debe ser un valor entre 1 y 31.",
    'time__invalid_hours' => "Las horas no son válidas. Debe ser un valor entre 0 y 24.",
    'time__invalid_minutes' => "Los minutos no son válidos. Debe ser un valor entre 0 y 59.",
    'time__invalid_seconds' => "Los segundos no son válidos. Debe ser un valor entre 0 y 59.",
    'time__minutes' => "Min",
    'time__month' => "Mes",
    'time__sec' => "Segundos",
    'time__syn_sys_time' => "Sincronizar fecha y hora del sistema",
    'time__system_datetime' => 'Fecha y hora',
    'time__system_date_update' => 'Actualizar fecha y hora del sistema',
    'time__system_date' => "Fecha (Año-Mes-Día)",
    'time__system_time' => "Hora (Horas:Minutos:Segundos)",
    'time__system_date_title' => "Fecha y hora del sistema",
    'time__timezone_title' => 'Zona horaria',
    'time__network_time' => 'Hora de red',
    'time__timezone' => 'Su zona horaria',
    'time__daylight' => 'Ajustar el reloj automáticamente según el horario de verano',
    'time__please_select_timezone' => 'Seleccione una zona horaria',
    '__please_select_country' => 'Seleccione su país',
    'time__unable_set_time' => "No se puede establecer la hora del sistema: %1",
    'time__year' => "Año",
    'tmpl__create' => "Crear plantilla",
    'tmpl__edit__' => 'Plantilla %1',
    'tmpl__logrotation_warn' => "La rotación de registros en el dominio creado por esta plantilla solo se llevará a cabo en el caso de que se cree una cuenta de hosting físico para este.",
    'tmpl__name' => "Nombre de la plantilla",
    'tmpl__dom_exist' => "En el grupo de plantillas del cliente o del administrador ya existe una plantilla de dominio con este nombre.",
    'tmpl__name_invalid' => "El nombre de la plantilla no es válido o está vacío.",
    'tmpl__use_next_ip_addr' => "Se usará la siguiente dirección IP vacante",
    'tmpl_name_already_exists' => "Ya existe una plantilla denominada '%1'.",
    'traffic__no_periods_found' => "No se pueden mostrar las estadísticas de tráfico y web. Esta función solo estará disponible tras el próximo cálculo estadístico.",

    'vh_based__no_free_ip_for_vh' => "No hay direcciones IP libres para el hosting virtual basado en IP. Añada una dirección IP.",

    'wu__at_domains_text' => "Permitir el formato de acceso webuser@%1",
    'wu__unable_create' => "No se puede crear el usuario web: %1",
    'wu_edit__disk_quota' => "Cuota de disco",
    'wu_edit__invalid_pass' => "Contraseña no válida.",
    'wu_edit__invalid_quota' => "El valor de cuota de espacio en disco especificado no es válido. Introduzca un número entero positivo.",
    'wu_edit__invalid_quota_value' => "La cuota especificada de espacio en disco es inferior a la usada (%1 MB). Puede que algunas funcionalidades no estén disponibles. ¿Realmente desea continuar?",
    'wu_edit__not_create_pass' => "Esta acción no creará una contraseña para el nuevo usuario web. Si no dispone de contraseña, el usuario no se podrá iniciar sesión.",
    'wu_edit__unable_update' => "No se puede actualizar la propiedad del usuario web: %1",

    'bt_webdirs' => 'Directorios virtuales',

    'dns__tabs_general' => 'Configuración de zona',
    'dns__tabs_zone_settings' => 'Registros SOA',
    'soa__seconds' => 'segundos',
    'soa__minutes' => 'minutos',
    'soa__hours' => 'horas',
    'soa__days' => 'días',

    'DomainSubdirectory' => 'Subdirectorio de destino',

    'filemanager__select_codepage' => 'Seleccionar página de códigos:',

    'bt_server_app_add' => 'Añadir aplicación de servidor',
    'packages_list' => 'Aplicaciones de servidor',

    'bt_packages_management' => 'Administración de paquetes',
    'pb__packages_management' => 'Administración de aplicaciones',
    'bt_package_new' => 'Añadir aplicación',
    '__packages' => 'Aplicaciones de servidor',

    'dom_ctrl__mysql_dbase_space' => 'Cuota total de bases de datos MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Cuota total de bases de datos MS SQL',
    'server_preferences__include_mysql_databases' => 'Bases de datos MySQL',
    'server_preferences__include_mssql_databases' => 'Bases de datos Microsoft SQL',

    'check_permissions__domains_selection' => 'Se verificarán los permisos de acceso a carpetas y archivos de los siguientes dominios',

    'dns_add__enter_ixfr_path' => 'Introducir la ruta IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Este registro SPF TXT ya existe. Solo puede existir un registro SPF. Para añadir un registro, elimine primero el registro existente.',

    'component_name__network' => 'Funciones de red',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Establecer skin',
    'bt_set_skin' => 'Establecer skin',
    'firewall__rule_already_exists' => 'Ya existe una regla denominada "%1"',
    'pb__firewall' => 'Firewall',
    'ruleeditform__incorect_port_value' => 'El número de puerto debe estar entre 1 y 65535.',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Ubicación del archivo no válida.',

    'error_doc__erorr_invalid_url_location' =>  'Formato URL erróneo. Introduzca una URL absoluta en el host virtual (sitio).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Protección antivirus',
    'antivirus__antivirus_direction_off' => 'Desactivado',
    'antivirus__antivirus_direction_any' => 'Correo entrante y saliente',
    'antivirus__antivirus_direction_from' => 'Solo correo saliente',
    'antivirus__antivirus_direction_to' => 'Solo correo entrante',
    'antivirus__unable_to_update_settings' => 'No se ha podido actualizar la configuración del antivirus: %1',




    '__normal' => 'Normal',
    '__low' => 'Baja',
    '__high' => 'Alta',

    'mail__antivirus' => "Antivirus interno del servidor de correo",
    'mail__use_internal_antivirus' => 'Utilizar antivirus interno',

    'sa__tabs_general' => 'General',
    'sa__tabs_whitelist' => 'Lista blanca',
    'sa__tabs_blacklist' => 'Lista negra',
    'sa__tabs_trustednetworks' => 'Redes de confianza',
    'sa__alarm_message_text' => 'Texto de alerta cuando se detecte spam',
    'sa__ok_languages' => 'Idiomas de confianza',
    'sa__language_groups_available' => 'Idiomas disponibles',
    'sa__language_groups_belonged' => 'Idiomas seleccionados',
    'sa__ok_locales' => 'Idiomas de confianza',
    'sa__locale_groups_available' => 'Grupos de idiomas disponibles',
    'sa__locale_groups_belonged' => 'Grupos de idiomas seleccionados',

    'sa_trustednetworks' => 'Lista de redes de confianza',
    'sa_tn_address' => 'Red/Máscara',
    'sa_trustednetworks_desc' => 'Redes de confianza seleccionadas',

    '__mysql_databases' => 'Bases de datos MySQL',

    'check_permissions__read_only' => 'Modo comprobación',
    'check_permissions__notification_email' => 'Enviar notificación por email',

    'cl_perm__mysql_dbase_space' => 'Cuota total de bases de datos MySQL',
    'cl_perm__mssql_dbase_space' => 'Cuota total de bases de datos MS SQL',
    'cl_perm__max_mssql_db' => 'nº máximo base de datos Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Cuota total de buzones',



    'time__date' => 'Fecha',
    'time__time' => 'Hora',

    'check_permissions_warning' => 'Este proceso puede tardar unos minutos en finalizar. Espere y no cancele la carga de la página.',

    'i_i_cl_on' => 'Cuenta de cliente activa.',
    'i_i_cl_off_by_admin' => 'Esta cuenta de cliente ha sido suspendida por el administrador.',

    'check_permissions__email_is_invalid' => 'La dirección de email proporcionada no es válida.',

    'sa_invalid_tn_ip' => 'El valor IP no es válido.',
    'sa_invalid_tn_mask' => 'El valor de máscara no es válido.',
    'sa_exists_tn' => 'La red ya está presente en la lista.',
    'sa_select_tn' => 'No se han seleccionado redes para eliminar.',
    'sa_conf_list_tn' => 'Confirme la eliminación de la(s) red(es) seleccionada(s).',

    'firewall__tabs_general' => 'General',
    'firewall_tabs_icmp' => 'Protocolo ICMP',

    'firewallicmpform__title' => 'Reglas de firewall para el protocolo ICMP',
    'firewallicmpform__icmpsettings_list_legend' => 'Reglas de firewall para el protocolo ICMP',
    'firewallicmpform__icmpsettingslist' => 'Reglas',
    'icmpsettingslist__enabled' => 'Estado',
    'icmpsettingslist__type' => 'Nombre de la regla',
    'firewall__icmp_type_allowinboundrouterrequest' => 'Permitir solicitud entrante router',
    'firewall__icmp_type_allowinboundtimestamprequest' => 'Permitir solicitud entrante timestamp',
    'firewall__icmp_type_allowinboundmaskrequest' => 'Permitir solicitud entrante máscara',
    'firewall__icmp_type_allowoutboundsourcequench' => 'Permitir solicitud saliente apagar',
    'firewall__icmp_type_allowoutboundparameterproblem' => 'Permitir problema con parámetro saliente',
    'firewall__icmp_type_allowredirect' => 'Permitir redireccionar',
    'firewall__icmp_type_allowinboundechorequest' => 'Permitir solicitud entrante echo',
    'firewall__icmp_type_allowoutboundtimeexceeded' => 'Permitir solicitud saliente tiempo excedido',
    'firewall__icmp_type_allowoutbounddestinationunreachable' => 'Permitir destino inalcanzable',


    'webdir__select_vdirs_to_remove' => 'Seleccione los directorios que desea eliminar',
    'webdir__select_mime_types_to_remove' => 'Seleccione los tipos MIME que desea eliminar',

    'defaultcomponents__not_activated' => 'no activado',

    'bt_traffic_at_domains' => 'Tráfico',

    'firewall__icmpsettingslist' => 'Reglas',
    'icmpsettingslist__name' => 'Nombre de la regla',

    '__awstats_perl_warning' => 'Si no tiene instalado Perl, AWStats no permitirá a los usuarios revisar las estadísticas de años anteriores.',

    'class_client__mysql_dbase_space' => 'El valor excede el límite del cliente',
    'class_client__mssql_dbase_space' => 'El valor excede el límite del cliente',
    'class_client__max_mssql_db' => 'El valor excede el límite del cliente',

    'firewall__icmp_reset_configuration' => '¿Está seguro de que desea restablecer la configuración predeterminada del firewall?',
    'firewall__icmp_panic_configuration' => '¿Está seguro de que desea activar el Modo Pánico? Algunos servicios de red puede que dejen de funcionar.',


    'dns__remove_transfer_restrictions_list_items' => 'Las siguientes redes serán eliminadas de la lista de control de acceso:',

    'firewall__select_rule_to_remove' => 'Seleccione las reglas a eliminar',

    'bt_up' => "Arriba",
    'bt_down' => "Abajo",
    'virtualdir__type_default_doc_name_to_add' => 'Introduzca el nombre de archivo a añadir a la lista',
    'virtualdir__select_default_doc_to_remove' => 'Seleccione los archivos a eliminar de la lista',

    'bt_install_selected' => 'Instalar las llaves de licencia seleccionadas', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'El dominio resuelve a otra dirección IP: (%1). Corrija la configuración DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'El servidor de correo que se está utilizando no soporta la activación simultánea del buzón y de grupos de correo. Haga clic en ACEPTAR para activar el buzón y desactivar los grupos de correo. Haga clic en Cancelar si no desea realizar ningún cambio.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'El servidor de correo que se está utilizando no soporta la activación simultánea del buzón y de grupos de correo. Haga clic en ACEPTAR para activar los grupos de correo y desactivar el buzón. Haga clic en Cancelar si no desea realizar ningún cambio.',

    'mysql_dbase_space_limit' => 'Límite de espacio de base de datos MySQL',
    'mysql_dbase_usage' => 'Uso de espacio de base de datos MySQL',
    'mssql_dbase_space_limit' => 'Límite de espacio de la base de datos Microsoft SQL Server',
    'mssql_dbase_usage' => 'Uso de espacio de las base de datos Microsoft SQL Server',

    '__statistics' => "estadísticas", //indirect

    'dns__soa_minimum_value_is_big' => 'Establecer el TTL mínimo a más de 3 horas puede hacer que sus dominios no sean accesibles para algunos administradores de dominio. Le recomendamos configurar este valor únicamente si le insiste su registrador de nombres de dominio.',

    'maillists__server_legend' => 'Configuración de Mailman',
    'maillists__secure_links_text' => 'Usar enlaces seguros en las listas de correo',
    'maillists__secure_links_hint' => 'Active o desactive la generación de enlaces seguros (HTTPS) en las listas de correo.',

    'virusfilter__interface_not_available' => 'Ni hay ningún filtro antivirus disponible.',
    'virusfilter__none_virus_filter' => 'Ninguno',
    'virusfilter__server_legend' => 'Configuración del antivirus',
    'virusfilter__server_text' => 'Antivirus usado',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'desactivado',
    'virusfilter__status_any' => 'Correo entrante y saliente',
    'virusfilter__status_outgoing' => 'solo correo saliente',
    'virusfilter__status_incoming' => 'solo correo entrante',

    'visibility__adminonly' => 'Solo Admin',
    'visibility__button_sets' => 'Controles',
    'visibility__control' => 'Haga clic para personalizar este control.',
    'visibility__customization_footnote' => 'Haga clic en ACEPTAR para finalizar la personalización de esta pantalla.',
    'visibility__default' => 'Predeterminado',
    'visibility__export_note' => "Los parámetros de personalización que aplicó van a ser exportados. Ahora se descargará un script shell a su ordenador. Para aplicar esta configuración a otro servidor Plesk, sobrescribiendo así cualquier otra configuración existente de administración del interfaz, cargue y ejecute el script en dicho servidor.\n\nTenga en cuenta que si ha realizado algún cambio en esta pantalla pero aún no ha hecho clic en ACEPTAR, los datos exportados no incluirán estos cambios más recientes.",
    'visibility__hide' => 'Ocultar',
    'visibility__reset_all' => 'Restablecer todo a predeterminado',
    'visibility__reset_screen' => 'Restaurar diseño original de esta pantalla',
    'visibility__root_override_parse_error' => 'Hay un error de sintaxis en el archivo %1 en la línea %2.',
    'visibility__screen_title' => 'Administración del interfaz',
    'visibility__set_billing_enabled' => 'Desconectar Customer & Business Manager',
    'visibility__set_cert_puchasing' => 'Ocultar botones para la compra de certificados',
    'visibility__set_domain_registration' => 'Ocultar botones para el registro de dominios',
    'visibility__set_extras' => 'Ocultar botones para servicios adicionales',
    'visibility__set_mail_bounce' => 'Ocultar controles para mensajes rechazados enviados a direcciones de email inexistentes',
    'visibility__show' => 'Mostrar',
    'visibility__show_toolbar' => 'Mostrar barra de administración del interfaz',
    'visibility__standby_footnote' => 'Haga clic para personalizar los controles en esta pantalla.',
    'visibility__standby_footnote_nocontrols' => 'No hay controles personalizables en esta pantalla.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "El componente no soporta la publicación automatizada",

    'component_name__cphosting' => "Hosting de Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'El servidor de correo actual no soporta la definición de la cuota de buzones de correo.',
    '__unable_get_total_mboxes_quota' => 'El servidor de correo actual no soporta la definición de la cuota de buzones de correo.',

    'install_prefix__parent_not_exists' => "El directorio principal no existe.",

    'bt_change_version' => 'Cambiar la versión',
    'aspdotnet__changeversion_title' => 'Selección de la versión de ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Seleccionar todo",
    '__uncheck_all' => "Deseleccionar todo",

    'dns__editing_domain_controller_zone' => "La edición de los registros de zona DNS para el controlador de dominio puede causar problemas en el funcionamiento del dominio",

    'pb__interface_management' => "Administración del interfaz",
    'interface_management__tabs_skins' => "Skins",
    'interface_management__tabs_interface_templates' => "Plantillas de interfaz",
    'interface_management__tabs_locales' => "Idiomas",
    'locales_list__title' => "Repositorio de paquetes de idioma",
    'locales_list__legend' => "Idiomas disponibles",
    'locales_list__active_title' => "Estado",
    'locales_list__locale_title' => "Paquete de idioma",
    'locales_list__lang_title' => "Idioma",
    'locales_list__country_title' => "País",
    'locales_list__used_title' => "Usado",

    'backup__suspend_warning_during_backup' => "El dominio no estará disponible durante la creación del backup",
    'backup__suspend_warning_during_restore' => "El dominio no estará disponible durante el proceso de restauración",
    'backup__suspend_domain' => "Suspender dominio",

    'locales_list__mls_limit' => "Su licencia actual de Plesk le permite usar %2 idiomas. En este momento sus usuarios disponen de %1 idiomas, lo que excede el número de idiomas proporcionado con la licencia. Seleccione los %2 idiomas que desee usar y desactive los demás haciendo clic en sus iconos en la columna 'S'.",

    'bt_change_owner' => 'Asignar propietario nuevo',
    'chown__new_owner' => 'Propietario nuevo',
    'chown__selected_domains' => 'Suscripciones seleccionadas',
    'chown__limits_legend' => 'Recursos',
    'chown__limit_name' => 'Nombre del recurso',
    'chown__limit_value' => 'Recursos asignados',
    'chown__limit_assigned_before' => 'Antes de la transferencia',
    'chown__limit_assigned_after' => 'Tras la transferencia',
    'chown__error_limits' => "No se pudo proceder con la transferencia de la suscripción. Esta suscripción requiere más recursos de los que puede ofrecer el proveedor del propietario nuevo.",
    'chown__error_no_domains' => 'No se pudo proceder con la transferencia de la suscripción. No se seleccionó ninguna suscripción o las suscripciones seleccionadas ya pertenecen al usuario de destino.',
    'chown__error_empty_ip_pool' => "No se pudo continuar con la transferencia de la suscripción porque el grupo de direcciones IP del proveedor del propietario nuevo está vacío. Compruebe que el proveedor dispone de al menos una dirección IP en el grupo de direcciones IP.",
    'chown__please_select_new_domain_owner' => 'Seleccione el propietario nuevo para esta suscripción',
    'chown__old_ip_address' => 'Dirección IP actual',
    'chown__new_ip_address' => 'Dirección IP nueva',

    'chown__error_ssl_already_used' => "El soporte para SSL/TLS ya está siendo usado en las siguientes IPs de destino: %1 Como consecuencia, no se pudieron transferir los siguientes dominios con soporte para SSL/TLS: %2. Resuelva el problema y vuelva a intentarlo",
    'chown__sitebuilder_not_installed' => 'Presence Builder no está instalado',
    'chown__domain_exclude_sitebuilder_not_installed' => 'El dominio %1 no puede transferirse a otro propietario porque Presence Builder no está instalado.',

    'backup__backup_time' => 'Hora del backup',
    'backup__backup_time_hour' => 'horas',
    'backup__backup_time_minute' => 'minutos',
    'backup__every' => 'cada',
    'backup__day_of_month' => 'día del mes',

    'subdomain__select_hst_type' => 'Seleccionar el tipo de hosting para el subdominio',
    'hst_sel__subdom_subfolder_hst' => 'Subdominio en subcarpeta',
    'subdomain__www_root_folder_not_exists' => 'El directorio principal del sitio %1 no existe',
    '__site_home_dir' => 'Directorio principal del sitio',
    'subdomain__aspnet_disabled_domain' => 'desactivado por dominio',

    'domains__remove_description' => 'Se eliminarán todos los datos del dominio, incluyendo el dominio y el contenido y configuración de los subdominios respectivos, información de aplicaciones web, contenido de buzón de correo, opciones de filtración de spam y virus, archivos de registro, información del repositorio de backups del dominio y certificados SSL/TLS. Si no tiene ningún archivo de backup en su máquina local, todos los datos se perderán permanentemente.',
    'subdomains__remove_description' => 'Se eliminarán todos los datos del subdominio, incluyendo el contenido y la configuración del subdominio, datos de aplicaciones web y archivos de registro. Si no tiene ningún archivo de backup en su máquina local, todos los datos se perderán permanentemente.',

    'mail__no_relay_networks' => 'No usar restricciones de retransmisión para las siguientes redes:',
    'mail__tabs_spam_filtering' => 'Filtración de spam',
    'mail__tabs_antivirus' => 'Antivirus',
    'server_mail__usage_policy_legend' => 'Directiva de uso',
    'server_mail__for_incoming_mail' => 'para correo entrante',
    'server_mail__for_outgoing_mail' => 'para correo saliente',
    'server_mail__antivirus_direction_off' => 'Detección desactivada',
    'server_mail__antivirus_direction_any' => 'Analizar tanto el correo entrante como el correo saliente',
    'server_mail__antivirus_direction_from' => 'Solo analizar correo saliente',
    'server_mail__antivirus_direction_to' => 'Solo analizar correo entrante',
    'antivirus__use_server_settings_scan' => 'Usar configuración predeterminada a nivel de servidor (Analizar)',
    'antivirus__use_server_settings_no_scan' => 'Usar configuración predeterminada a nivel de servidor (No analizar)',
    'antivirus__check_for_viruses' => 'Detectar virus',
    'antivirus__dont_check_for_viruses' => 'No detectar virus',
    'antivirus__incoming_mail' => 'Correo entrante',
    'antivirus__outgoing_mail' => 'Correo saliente',

    'domain_alias__CNAME_dns_record_exists' => 'Ya existe un registro DNS CNAME con este nombre',
    'domain_alias__A_dns_record_exists' => 'Ya existe un registro DNS A con este nombre',
    'domain_alias__bad_prefix' => 'Prefijo erróneo para alias de dominio',
    'domain_alias__domain_doesnt_exist' => "El dominio no existe",

    'dns__zone_ttl_message_info' => 'De no especificarse el valor TTL, para este registro DNS se usará el valor TTL presente en la plantilla del registro SOA (%1).',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Se creará un archivo denominado index.html para el redireccionamiento a la aplicación web seleccionada. Si ya existe un archivo denominado index.html, este se copiará como index.html.old y será sustituido por el nuevo. Haga clic en ACEPTAR para confirmar",

    'bt_ftp_ctrl' => "Cuentas FTP adicionales",
    'ftp_users_no_permission' => "No tiene permiso para administrar cuentas FTP para este dominio",
    'ftp_users_limit_reached' => "Se ha alcanzado el límite de cuentas FTP para este dominio",
    'pb__ftp_ctrl' => "Administración de FTP",
    'class_client__max_subftp_users' => "Cuentas FTP adicionales",

    '__client_form_settings' => "Configuración del cliente",
    '__sbnet_client_keep_sbnet' => "Conservar la cuenta de usuario correspondiente en Presence Builder",
    '__sbnet_cant_add_more_sites' => "Se ha alcanzado el límite de sitios que pueden usar Presence Builder para este cliente",
    '__sbnet_legend_text' => "Integración de Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Crear una cuenta de usuario correspondiente en Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Está intentando eliminar la cuenta de usuario Presence Builder asociada a este cliente. Esta acción hará que se eliminen todos los sitios web del usuario así como todos los demás ajustes relevantes del sistema Presence Builder, eliminándose también la capacidad para editar sitios web existentes a través de Presence Builder, incluso en el caso de que más tarde vuelva a activar esta opción. Si más adelante vuelve a crear una cuenta de usuario Presence Builder, deberá volver a crear y publicar todos sus sitios web. ¿Desea desactivar la creación y publicación de sitios web a través de Presence Builder?",
    'sb__build_site_with_subdomains' => "Crear subdominios de Blog y Galería de Fotos",
    '__sbnet_client_dont_have_sbuser' => "No se puede crear y publicar el sitio con Presence Builder: el usuario de Presence Builder no existe.",

    '__component_disabled' => "Componente desactivado",

    'subdomains__physical_path_not_exist' => "Hay subdominios asociados a carpetas físicas inexistentes",

    'dnsserver_bind_to_msdns_switching_warning' => "¡Importante! Solo se transferirán las primeras 254 direcciones IP de subredes con /8 y /16 máscaras ubicadas en la Lista de Control de Acceso. Estas se transferirán como direcciones IP independientes. ¿Desea continuar?",

    '__sbnet_net_framework_required_for_site' => "Los sitios Presence Builder pueden requerir soporte de ASP.NET 2.0 en su dominio. Si está usando Presence Builder, le recomendamos habilitar el soporte para ASP.NET 2.0.",

    'subdomain_auto_create_dir' => "Crear directorio físico para el subdominio",

    'sa_trainer__unable_to_get_messages_list' => "No se puede obtener la lista de mensajes en el buzón de correo: %1",
    'sa_trainer__pass_doesnt_exist' => "No se ha encontrado la contraseña para esta cuenta de correo",

    '__sitebuilder_error' => "Se ha producido un error mientras se intentaba conectar con Presence Builder. Póngase en contacto con su proveedor de servicios para obtener asistencia.",
    'wsb_error_user_not_exist' => "Esta cuenta de usuario Presence Builder no existe.",
    'wsb_error_site_already_exist' => "Este sitio ya existe en Presence Builder.",
    'wsb_error_site_limit_reached' => "Se ha alcanzado el límite de sitios Presence Builder.",
    'wsb_error_internal_error' => "Error interno de Presence Builder. Póngase en contacto con su proveedor de servicios para obtener asistencia.",
    'wsb_error_user_already_exist' => "En Presence Builder ya existe un usuario de Presence Builder con este nombre.",
    'sb_error_user_not_exist' => "El usuario de Presence Builder no existe.",
    'wsb_error_object_not_found' => "Presence Builder no ha podido encontrar la entrada de host correcta.",

    'mg_no_mail_groups' => "Ningún grupo de correo",

    'drweb__drweb_incoming' => 'Detección de virus en el correo entrante',
    'drweb__drweb_outgoing' => 'Detección de virus en el correo saliente',
    'drweb__disable_reason_serv' => 'El servidor de correo no soporta la configuración del filtro antivirus a nivel de buzón de correo',

    'vz_sitebuilder3_client_cant_be_created' => "No se puede crear la cuenta de cliente: no tiene instalada la versión 3.1 o una versión posterior de SiteBuilder",

    'chown__client_without_sitebuilder_support' => "No se pudo proceder con la transferencia de la suscripción. El servicio Presence Builder no está incluido en el plan de servicio del nuevo propietario o de su proveedor.",

    // new limits

    'class_client__max_odbc' => "Conexiones ODBC",
    'cl_perm__max_odbc' => "nº máximo de conexiones ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'Estado',
    'domain_alias__list_name' => 'Nombre del alias de dominio',
    'domain_alias__list_ascii_name' => 'En formato ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Administración del interfaz',
    'pb__interface_templates' => 'Administración del interfaz',
    'pb__interface_clients' => 'Clientes que usan %1',

    // service management
    'bt_service_showall' => "Ver todos",
    'bt_service_hideall' => "Ocultar todos",
    'bt_service_start' => "Iniciar",
    'bt_service_stop' => "Detener",
    'bt_service_restart' => "Reiniciar",
    'bt_service_disable' => "Desactivar",
    'bt_service_manual' => "Manual",
    'bt_service_auto' => "Auto",
    'comp_info__statup_type' => 'Tipo de inicio',
    'service_startup_auto' => 'Automático',
    'service_startup_manual' => 'Manual',
    'service_startup_disabled' => 'Desactivado',
    'service_action_ok' => "La operación con servicio %1 se ha completado correctamente",
    'service_action_failed_disabled_service' => "No se puede completar la operación con el servicio %1 ya que está desactivado",
    'service_action_failed_error' => "No se puede completar la operación: %1",
    'service_group_action_ok' => "La operación con los siguientes servicios se ha completado correctamente: \n %1",
    'service_group_action_disabled' => "No se puede completar la operación con los siguientes servicios porque estos están desactivados: \n %1",
    'service_group_action_failed' => "No se puede completar la operación con los siguientes servicios: \n %1. \n Para recibir información detallada del error, realice la operación para cada servicio por separado",

    // php 4vs5
    'bt_php' => "Configuración de PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Revendedores disponibles',
    'massmail__resellers_list_selected' => 'Revendedores seleccionados',
    'massmail__clients_list_available_for_select' => 'Clientes disponibles',
    'massmail__clients_list_selected' => 'Clientes seleccionados',
    'massmail__advanced' => 'Avanzado',
    'bt_massmail_send' => 'Enviar',
    'massmail__save_template_name' => 'Guardar texto en una nueva plantilla denominada',
    'massmail__template' => 'Plantilla',
    'massmail__compose_mail' => 'Mensaje',
    'massmail__from' => 'Desde',
    'massmail__to' => 'Para',
    'massmail__subject' => 'Asunto',
    'massmail__body' => 'Texto del mensaje',
    'massmail__body_hint' => 'Use la variable <name> para introducir automáticamente el nombre del usuario en su mensaje.',
    'massmail__send_to_clients' => "Clientes",
    'massmail__send_to_domainusers' => "Administradores de dominio",
    'massmail__send_to_admins' => "Administradores de Plesk",
    'massmail_select' => 'Seleccione direcciones',
    'massmail_showhide_selected' => "Mostrar/Ocultar seleccionadas",
    'massmail_send_all' => "Todos",
    'massmail_send_selected' => "Solo los seleccionados",
    'massmail_send_except' => "Todos excepto los seleccionados",
    'bt_new_mass_mail_template' => "Añadir plantilla de email masivo",
    '__mass_mail_templates_list' => "Lista de plantillas de mensaje de email masivos",
    'massmail__template_name' => 'Nombre de la plantilla',
    'massmail__receivers' => 'Destinatarios',
    'massmail__created' => 'Remitente',
    'massmail__date_created' => 'Fecha de creación',
    'massmail__compose' => 'Enviar',
    'mass_mail__resellers_all' => 'Todos los revendedores',
    'mass_mail__clients_all' => 'Todos los clientes',
    'mass_mail__domainusers_all' => 'Todos los administradores de dominio',
    'mass_mail__resellers_selected' => 'Revendedores seleccionados',
    'mass_mail__clients_selected' => 'Clientes seleccionados',
    'mass_mail__domainusers_selected' => 'Administradores de dominio seleccionados',
    'mass_mail__resellers_except' => 'Todos los revendedores excepto los seleccionados',
    'mass_mail__clients_except' => 'Todos los clientes excepto los seleccionados',
    'mass_mail__domainusers_except' => 'Todos los administradores de dominio excepto los seleccionados',
    'mass_mail__admins_all' => 'Todos los administradores',
    'massmailtemplateslist__title' => 'Plantillas de emails masivos',
    'massmail__insert_from_template' => "Introducir datos de la plantilla",
    'massmail__select_template' => "Seleccione una plantilla",
    'massmail__body_short_hint' => "(solo texto sin formato)",
    'massmail__from_short_hint' => "(email o nombre)",
    'bt_insert' => "Insertar",
    'massmail__mail_send_successfully' => "El mensaje se ha enviado correctamente",
    'massmail__mail_send_successfully_with_some_errors' => "El mensaje se ha enviado, pero se han producido numerosos errores. Puede ser que algunos de los destinatarios no reciban el mensaje. Para más información, consulte el siguiente archivo de registro: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "El mensaje no ha sido enviado. Compruebe que ha seleccionado al menos un destinatario y que el servidor de correo de Plesk funciona correctamente. Para más información, examine el siguiente archivo de registro: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Los datos de la plantilla %1 se han introducido correctamente.",
    'massmail__template_added_successfully' => "La plantilla de mensaje se ha guardado con el nombre %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Error en la base de datos de Presence Builder. Póngase en contacto con su proveedor de servicios para obtener asistencia.",
    'wsb_error_sitebuilder_access_denied_error' => "No se pudo acceder al archivo. Presence Builder no dispone de derechos de acceso al archivo o a la carpeta requeridos. Póngase en contacto con su proveedor de servicios para obtener asistencia.",
    'wsb_error_sitebuilder_connection_failed' => "No fue posible conectarse a Presence Builder porque se ha perdido la conexión. Póngase en contacto con su proveedor de servicios para obtener asistencia.",
    'wsb_error_critical_during_operation' => "Error crítico de Presence Builder: %1",
    'wsb_error_license_during_operation' => "Error de licencia de Presence Builder: %1",
    'wsb_error_during_operation' => "Error de Presence Builder: %1",
    'wsb_error_license_error' => "Se ha detectado una limitación de licencia de Presence Builder.",

    // Other
    '__confrim_service_stop' => "¡Atención! Si detiene el servicio %1, puede que Plesk deje de funcionar. ¿Está seguro de que desea detener el servicio %1?",
    'virtualdir__name_is_reserved' => "Este nombre está reservado",
    'index_redirect_help_text' => 'Ahora se le redireccionará automáticamente al sitio web solicitado. Si su navegador no soporta el redireccionamiento, haga clic %1 aquí %2',
    'bt_default_settings' => "Restaurar predeterminados",
    'logfiles__remove_failed' => "No se puede eliminar el archivo %1: el archivo ha sido bloqueado por otra aplicación. Vuélvalo a intentar transcurridos unos minutos",
    'subdomain__invalid_homedirectory' => "El directorio principal del subdominio indicado no es válido",
    'scheduler_item__empty_filename' => "Indique el archivo a ejecutar",
    'subdomains__overlapped_domain_exists' => 'El subdominio coincide con la zona DNS del dominio %1',
    'subdomains__overlapped_domain_alias_exists' => 'El subdominio coincide con la zona DNS del alias de dominio %1',
    'services_action_none_selected' => 'No se puede completar la operación: seleccione los servicios requeridos',
    'cl_perm__max_subftp_users' => "nº máximo de cuentas FTP adicionales",
    'login_up__access_denied_no_cp_access' => 'Acceso denegado. No dispone del permiso necesario para acceder a Plesk.',
    'drweb__disable_reason_admin' => "La directiva del servidor no permite configurar opciones del filtro antivirus a nivel de buzón de correo.",

    'webdirs__name_is_invalid' => 'En el nombre del directorio, use únicamente caracteres alfanuméricos, guiones bajos y guiones.',
    'webdirs__physical_path_is_invalid' => 'La ruta física no es válida o no existe',
    '__use_default' => 'Usar predeterminado',
    'odbc__dsn_list_legend' => 'Conexiones ODBC DSN',

    'webalizer_preferences__title' => 'Configuración de estadísticas web',
    'webalizer_preferences__tab_hidden_referrers' => 'Referentes ocultos',
    'webalizer_preferences__tab_group_referrers' => 'Referentes agrupados',

    'webalizer_hidden_referrer__edit_title' => 'Propiedades de entrada oculta',
    'webalizer_hidden_referrer__edit_legend' => 'Entradas ocultas',
    'webalizer_hidden_referrer__referrer_type' => 'Tipo de entrada',
    'webalizer_hidden_referrer__referrer' => 'Referente',
    'webalizer_hidden_referrer__list_header' => 'Referentes ocultos',
    'webalizer_hidden_referrer__list_legend' => 'Referentes ocultos',
    'webalizer_hidden_referrer__referrer_direct_request' => 'Petición directa',
    'webalizer_hidden_referrer__referrer_custom_referrer' => 'Referente',
    'webalizer_hidden_referrer__remove_empty_selection' => 'No se ha seleccionado ninguna entrada',
    'webalizer_hidden_referrer__remove_title' => 'Los siguientes referentes ocultos ya no estarán ocultos:',
    'webalizer_hidden_referrer__already_exist' => 'Dicha entrada ya existe.',

    'webalizer_group_referrer__list_header' => 'Grupos de referencias',
    'webalizer_group_referrer__list_legend' => 'Grupos de referencias',
    'webalizer_group_referrer__edit_title' => 'Propiedades del grupo de referentes',
    'webalizer_group_referrer__edit_legend' => 'Propiedades del grupo de referentes',
    'webalizer_group_referrer__group' => 'Grupo',
    'webalizer_group_referrer__referrer' => 'Referente',
    'webalizer_group_referrer__already_exist' => 'Ya existe un grupo de referentes con este nombre.',
    'webalizer_group_referrer__remove_empty_selection' => 'No se ha seleccionado ningún referente',
    'webalizer_group_referrer__remove_title' => 'Se desagruparán los sitios del siguiente referente:',

    'pb__dashboard' => 'Inicio',

    'server_interface__page_title' => 'Configuración del interfaz del servidor',
    'server_interface__tabs_locales' => 'Idiomas',
    'server_interface__tabs_skins' => 'Skins',
    'server_interface__tabs_interface_templates' => 'Plantillas de interfaz',
    'bt_server_interface' => 'Preferencias del interfaz',
    'pb__server_interface' => 'Preferencias del interfaz',

    'bt_wizard_next' => 'Siguiente >>',
    'bt_wizard_prev' => '<< Atrás',

    '__limit_exceeded_max_dom_server' => 'No puede alojar más dominios en este servidor porque se ha alcanzado el número máximo permitido de dominios definido por la llave de licencia. Para resolver esta incidencia, póngase en contacto con su proveedor de servicios.',
    '__limit_exceeded_max_subdom_server' => 'No puede alojar más subdominios en este servidor. Póngase en contacto con su proveedor de servicios.',
    '__limit_exceeded_max_dom_aliases_server' => 'No puede crear más alias de dominio en este servidor. Póngase en contacto con su proveedor de servicios.',
    '__limit_exceeded_max_wu_server' => 'No puede crear más usuarios web porque se ha alcanzado el límite de usuarios web que la llave de licencia permite tener en el servidor. Póngase en contacto con su proveedor de servicios para resolver este problema.',
    '__limit_exceeded_max_mn_server' => 'No puede crear más cuentas de correo porque se ha alcanzado el límite de cuentas de correo que la llave de licencia permite tener en el servidor. Para resolver esta incidencia, póngase en contacto con su proveedor de servicios.',

    '__limit_exceeded_max_cl_useradmin' => 'Ha alcanzado el límite de número de cuentas de cliente definido por su llave de licencia (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Ha alcanzado el límite de número de dominios definido por su llave de licencia (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Ha alcanzado el límite de número de subdominios definido por su llave de licencia (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Ha alcanzado el límite de número de alias de dominio definido por su llave de licencia (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'No tiene suficiente espacio en disco libre',
    '__limit_exceeded_max_wu_useradmin' => 'Ha alcanzado el límite de número de cuentas de usuario web definido por su llave de licencia (%2) .',
    '__limit_exceeded_max_db_useradmin' => 'Ha alcanzado el límite de número de bases de datos definido por su llave de licencia (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Ha alcanzado el límite de número de buzones de correo definido por su llave de licencia (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Ha alcanzado el número máximo de cuentas de email definido por su llave de licencia (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Ha alcanzado el límite de número de listas de correo definido por su llave de licencia (%2).',

    '__limit_exceeded_max_dom_userclient' => 'Ha alcanzado el límite de número de dominios (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Ha alcanzado el límite de número de subdominios (%2) permitido por su proveedor de servicios.',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Ha alcanzado el límite de número de alias de dominio (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Ha alcanzado el límite de uso de espacio en disco (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Ha alcanzado el límite de cantidad de uso de ancho de banda mensual (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Ha alcanzado el límite de número de usuarios web (%2) permitido por su proveedor de servicios.',
    '__limit_exceeded_max_db_userclient' => 'Ha alcanzado el límite de número de bases de datos (%2)',
    '__limit_exceeded_max_box_userclient' => 'Ha alcanzado el límite de número de buzones de correo (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Ha alcanzado el límite de número de listas de correo (%2)',
    '__limit_exceeded_expiration_userclient' => 'Su cuenta expiró el %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Ha alcanzado el límite de número de subdominios (%2) permitido por su proveedor de servicios.',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Ha alcanzado el límite de número de alias de dominio (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Ha alcanzado el límite de uso de espacio en disco (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Ha alcanzado el límite de cantidad de ancho de banda mensual (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Ha alcanzado el límite de número de cuentas de usuarios web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Ha alcanzado el límite de número de bases de datos (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Ha alcanzado el límite de número de buzones de correo (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Ha alcanzado el límite de número de listas de correo (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Su cuenta expiró el %2',

    'mmt__to_none' => 'Ninguno',
    'mmt__to_admin' => 'Administrador',
    'mmt__to_resellers_all' => 'Todos los revendedores',
    'mmt__to_resellers_select' => 'Revendedores seleccionados',
    'mmt__to_resellers_select__available' => 'Revendedores disponibles',
    'mmt__to_resellers_except' => 'Todos los revendedores excepto los seleccionados',
    'mmt__to_clients_all' => 'Todos los clientes',
    'mmt__to_clients_select' => 'Clientes seleccionados',
    'mmt__to_clients_select__available' => 'Clientes disponibles',
    'mmt__to_clients_except' => 'Todos los clientes excepto los seleccionados',

    'mmt__unable_send_empty_selection' => 'No se pueden enviar correos masivos porque no se seleccionó ninguna dirección de email.',
    'mmt__unable_send_to__' => 'No se puede enviar un correo masivo a:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'No se puede validar la aplicación web porque no se ha encontrado uno de los archivos requeridos (%1). Póngase en contacto con su delegado de soporte técnico para obtener ayuda.',
    'sapp_error_validation_spec_failed' => 'La aplicación web cargada no cumple las especificaciones de AppPacks: %1.',
    'sapp_error_validation_register' => 'No se puede registrar la aplicación web en el directorio "%1": %2 Elimine la aplicación web del servidor, ya que no funcionará correctamente.',

    'sapp__install_failed' => 'Error de instalación de la aplicación web: %1',
    'sapp__install_res_failed' => 'Error al crear el recurso solicitado.',

    'server_preferences__subdomains_blog_and_photo' => 'Crear subdominios de galería de fotos y blog por omisión',
    'firewall__info' => 'Por motivos de seguridad, el firewall bloquea todas las conexiones excepto las explícitamente permitidas. Puede permitir una conexión creando una regla. Si desea más información, consulte la documentación',
    'plesk_key__blog_and_photo' => 'Habilidad para gestionar el estado predeterminado de la casilla Crear subdominios Blog y Galería de Fotos',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'No se puede cambiar el tipo de dirección IP a dedicada porque esta está asignada a más de un usuario.',

    // 8.1.1


    'database_server_list__mssql_server_port_undefined' => "No se pudo determinar el número de puerto TCP usado por el servidor Microsoft SQL '%1': El protocolo TCP/IP no está habilitado en la configuración de red del servidor o bien el servidor se ha configurado para utilizar puertos TCP dinámicos.\n Para que los clientes puedan configurar el firewall de forma automática para acceder a la base de datos de forma remota, configure manualmente el servidor SQL para que escuche en un puerto TCP fijo específico.",
    'pb__db_server_databases' => 'Administración de servidores de bases de datos',

    '__write_modify_warning' => 'Si selecciona permisos de escritura/modificación adicionales, algunas aplicaciones web funcionarán correctamente pero también aumentarán los riesgos de seguridad',
    '__write_modify_subdomain_warning' => 'Si selecciona permisos de escritura/modificación adicionales, algunas aplicaciones web funcionarán correctamente pero también aumentarán los riesgos de seguridad',

    'phosting__php_incorrect_version_used' => "Se han detectado problemas con la versión de PHP. Para solucionarlos, seleccione la casilla de la versión PHP y haga clic en ACEPTAR. Si desea desactivar PHP en este dominio, haga clic en ACEPTAR sin seleccionar la versión de PHP",
    'fp__mail_preferences' => 'Configuración de correo',

    'mail__specify_patterns' => 'Direcciones de email',
    'mail__specify_patterns_with_ip' => 'Email o direcciones IP',
    'mail__blocker_action_text' => 'Qué hacer con el correo que coincida con el criterio:',
    'mail__action_delete' => 'Eliminar del servidor',
    'mail__action_spam' => 'Marcar como spam',
    'mail__action_with_mails' => 'Acción',
    'mail__white_list_action_text' => 'Las direcciones de email indicadas aquí no serán reconocidas como spam por parte de SpamAssassin.',
    'mail__smtp_white_list_action_text' => 'Las entradas IP indicadas aquí se añadirán a las excepciones del servidor de correo.',
    'mail__invalid_white_pattern' => 'El valor especificado no es válido. Use los siguientes formatos: mail@example.com para direcciones de email, example.com para dominios.',
    'mail__white_list__text_wildcard_pattern' => 'Las direcciones IP pueden incluir wildcards (por ejemplo, 123.123.*.123).',
    'mail__white_list__text_cidr_pattern' => 'Las direcciones IP pueden contener máscaras CIDR (por ejemplo, 10.0.0.0/8).',
    'mail__invalid_black_pattern' => 'El valor especificado no es válido. Use el siguiente formato: mail@example.com para direcciones de email, example.com para dominios.',
    'mail__black_list_no_sa_warning' => 'Las entradas no se marcarán como spam porque SpamAssassin no está instalado o está desactivado',
    'mail__smtp_white_list__text_hint' => 'Separe múltiples direcciones con una coma o punto y coma. No puede haber caracteres no ASCII a la izquierda de @. Las direcciones pueden contener "*" y "?" (por ejemplo *@domain.com, user?@*.com). Las partes no ASCII de los nombres de dominio no pueden contener caracteres wildcard.',

    'resp_edit__reply_as_html' => 'Enviar como HTML',
    'exception__path_very_long' => "La ruta es demasiado larga. Compruebe que en la ruta hay menos de %1 caracteres.",

    // 8.2


    //SAPP
    'sapp_on' => 'Habilitado',
    'sapp_off' => 'Deshabilitado',
    'sapp_directive_aspect' => 'Requerido',
    'sapp_databases_num' => 'Bases de datos',
    'sapp_db_required' => 'Requerido',
    'sapp_Required' => 'Requerido',
    'sapp_Variant' => 'Variante',
    'sapp_db_id' => 'ID de la base de datos',
    'sapp_db_id_type' => 'Tipo de DB (id: %1)',
    'sapp_db_id_min_version' => 'Versión mín de DB (id: %1)',
    'sapp_db_id_table_prefix' => 'Prefijo de la tabla de DB (id: %1)',
    'sapp_Default' => 'Valor predeterminado',
    'sapp_apache_mod_req' => 'Módulo Apache',
    'sapp_dbtype_not_installed' => 'no instalado',
    'sapp_apache_mod_not_installed' => 'no instalado',
    'sapp__value_error_empty' => 'No se permite el uso de valores vacíos.',
    'sapp_error_invalid_type' => 'La aplicación "%1" no soporta la acción solicitada.',
    'sapp_error_unknown_app_type' => 'Tipo de aplicación no soportada: %1.',
    'sapp__ssl_text' => '¿Desea instalar la aplicación en el host virtual "http://" o "https://"?',
    'sapp__app_to_upgrade' => 'Aplicaciones a actualizar',
    'sapp__upgrade_apps_title' => 'Actualizar aplicaciones',
    'sapp__upgrade_to_ver' => 'Actualizar a versión',
    'sapp__choose_pkg_ver' => 'Seleccione un paquete...',
    'sapp__pkg_cant_upgrade_pkg' => 'El paquete "%1" no puede usarse para actualizar la aplicación web "%2".',
    'sapp__app_ugrade_error' => 'No se puede actualizar la aplicación: %1. Póngase en contacto con el administrador de su sistema.',
    'sapp__no_suitable_db_found' => 'No encontraron bases de datos apropiadas.',
    'sapp__upgrade_success' =>  'La aplicación se ha actualizado correctamente.',
    'sapp__pkg_info_changelog' => 'Historial de cambios',
    'sapp_requirement_legend' => 'Prestaciones de hosting requeridas por la aplicación',

    // other
    'odbc__mssql_wsid' => 'ID de Workstation',
    'odbc__mssql_driver' => 'Controlador',
    'bt_apply' => 'Aplicar',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Si desea crear un alias de correo, debe activar el buzón en esta cuenta de correo. ¿Desea activarlo?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Si desactiva el buzón de correo, se eliminarán los alias de dominio. ¿Desea desactivar el buzón?',
    'odbc__mysql_driver' => 'Controlador ODBC de MySQL',
    'antivirus__disable_reason_install' => 'No puede administrar el antivirus porque no está instalado.',
    'antivirus__disable_reason_key' => 'No puede administrar el antivirus porque este no está activado a través de una llave de licencia válida.',
    'antivirus__disable_reason_deny_personal_settings' => 'No puede administrar el antivirus porque la directiva del servidor prohíbe realizar cambios individuales en la configuración del antivirus.',
    'component_name__sqladminmssql' => 'Microsoft SQL Webadmin',
    'change_foreign_user_password' => 'Cambiar la contraseña',
    'change_foreign_user_password_hint' => "El usuario no pertenece a esta aplicación. Haga clic en el enlace para ir a otra aplicación y cambiar la contraseña del usuario allí. Para ello, debe tener los derechos apropiados en la aplicación.",
    'cf_url_text' => 'URL de JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Formato de cadena',
    'lang_unknown' => 'Idioma desconocido',
    'odbc__access_driver' => 'Controlador',
    'odbc__access_pwd' => 'Contraseña',
    'odbc__access_uid' => 'ID de acceso',
    'odbc__excel_driver' => 'Controlador',
    'pb__cl_ed' => 'Detalles del cliente',
    'pb__actionlog' => 'Registro de acciones',
    'pb__cl_limits' => 'Límites del cliente',
    'pb__edit' => 'Editar',
    'pb__subdom_edit' => 'Configuración de hosting',
    'cf__select_dsn_to_remove' => 'Seleccione al menos un DSN a eliminar',

    // NEW 8.3 FEATURES

    'firewall__port_range_warn_limit' => 'El procesamiento de las reglas para este intervalo de puertos puede tardar unos minutos.\\n¿Desea continuar?',
    'firewall__port_range_exceeds_limit' => 'El intervalo de puertos indicado excede el valor del intervalo de puertos disponible de %1',

    'backup_mail_content' => 'Copiar el contenido de los buzones de correo',

    'maillist_import_result' => "Cantidad total de direcciones de email en el archivo: %1\nnúmero de direcciones de email importadas: %2\nnúmero de direcciones de email existentes: %3\nnúmero de direcciones de email duplicadas en el archivo indicado: %4\nnúmero de direcciones de email no válidas en el archivo: %5",
    'maillist_import_error' => 'No se puede importar la lista de direcciones de email',

    //  spaw

    'spaw__unable_to_edit_no_body' => "El archivo seleccionado está vacío o no es un documento HTML válido en la codificación seleccionada. Seleccione la codificación correcta o añada contenido al archivo.",

    'dom_pref__external_mail_srv' => "Redireccionar a un servidor de correo externo con la dirección IP:",
    'mn_edit__store_messages' => 'Buzón de correo',

    // aps

    'sapp__before_upgrade_notice' => 'Le recomendamos realizar un backup de la aplicación y de los datos de usuario antes de iniciar el proceso de actualización.',
    'sapp__application_properties' => 'Propiedades de la aplicación',
    'sapp__application_root_descr' => 'La página principal de la aplicación',

    'sapp__aps_license_invalid_id' => 'La llave de licencia tiene un ID no válido: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'La licencia con número de llave %1 ya existe en la base de datos.',
    'sapp__aps_lic_del_used' => 'No se puede eliminar la llave de licencia, está siendo usada por una de las aplicaciones instaladas.',
    'sapp__aps_lic_del_unknown' => 'No se puede eliminar la llave de licencia: %1',
    'sapp__aps_cappi_duplicate' => "Esta aplicación ya está presente en el grupo de aplicaciones de este cliente",
    'sapp__appi_not_shared_no_install' => "En el grupo de aplicaciones del cliente no existe ninguna aplicación con estas características. Si desea instalar esta aplicación en un sitio, añádala primero al grupo de aplicaciones del cliente.",
    'sapp__appi_shared_not_client' => "En el grupo de aplicaciones del cliente no existe ninguna aplicación con estas características. Si desea actualizar la aplicación a la versión indicada, añada primero esta versión de la aplicación al grupo de aplicaciones del cliente.",
    'sapp__apply_license_script_not_found' => 'No se puede encontrar el script "apply-license" para esta aplicación web.',
    'sapp__unable_to_activate_key' => 'Se ha producido un error cuando se intentaba activar una llave de licencia: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Hay aplicaciones web instaladas que requieren la presencia de esta aplicación web en el sistema.',
    'sapp__unable_to_delete_ai_in_pool' => 'Esta aplicación aún está presente en el grupo de aplicaciones de un cliente. Si desea eliminarla, primero deberá eliminarla de los grupos de aplicaciones de todos los clientes o hacerla gratuita.',
    'sapp__unable_to_delete_app_template' => 'No se puede eliminar la aplicación #%1: %2',
    'sapp__limit_exceeded_client' => 'Ha alcanzado el límite de número de veces que puede instalar esta aplicación web (%2)',


    // atis module

    '_week_on' => 'semana activa',
    '__week_first' => 'primero',
    '__week_second' => 'segunda',
    '__week_third' => 'tercera',
    '__week_fourth' => 'cuarta',
    '__week_last' => 'último',
    '__not_started' => 'En espera',
    '__started' => 'En ejecución',
    '__cancel_pending' => 'Cancelando',
    '__canceled' => 'Cancelado',
    '__error' => 'Error',
    '__done' => 'Hecho',

    '__php_cgi_handler' => 'Aplicación CGI',
    '__php_isapi_handler' => 'Extensión ISAPI',
    '__php_fastcgi_handler' => 'Aplicación FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'ejecutar como',

    'firewall_tabs_rules' => 'Reglas del firewall',

    'cf_dbfolder_text' =>'Carpeta de la base de datos',
    'cf_isnewdb_text' => 'Crear base de datos',
    'cf_isnewdb_title' => 'Seleccione la casilla si debe crearse la base de datos',

    'pb__site_apps_upgrade' => 'Actualización de aplicaciones web',

    'detach' => 'Cerrar sesión',
    'preferences' => "Cambiar contraseña",

    'toolsbar__switch_user?' => "¿Está seguro de que desea iniciar sesión con otra cuenta de usuario?",
    '__aps_left' => 'Instalaciones disponibles',
    'aps__license_key' => 'Llave de licencia',
    'aps__download_code' => 'Descarga de llave de licencia y código de activación',
    'aps__license_key_hint' => 'Recuperar del servidor de licencias usando el código de activación',
    'aps__database_not_available' => 'no disponible, compruebe los límites del cliente o del dominio',
    'aps__yes' => 'sí',
    'aps__no' => 'no',
    '__click_to_enlarge' => 'Haga clic para maximizar',
    'site_apps__back_to_list' => 'Volver a la lista',
    'sapp__pkg_info_installation_requirements' => 'Requisitos de instalación',
    '__close_window' => 'Cerrar',

    //SAPP END

    'skin_info__already_default' => 'Este skin ya se ha establecido como el predeterminado.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Configuración de Plesk Premium Antivirus para %1',
    'drweb:properties_legend' => 'Configuración',
    'drweb:status' => 'Comprobando la existencia de virus en el correo',

    // sb integration
    'sitebuilder_wizard' => 'Asistente de Presence Builder',
    'dom_site_builder' => 'Haga clic para abrir el asistente de Presence Builder.',
    'sb_plesk_admin_url' => 'URL del servidor Presence Builder. Compruebe que esta dirección resuelve correctamente en DNS',
    'sb_plesk_admin_login' => 'Nombre de usuario para el inicio de sesión del administrador del servidor en Presence Builder',
    'sb_plesk_admin_password' => 'Contraseña del administrador',
    'sb_sitebuilder_preferences' => 'Credenciales del administrador de Presence Builder',
    'sb__server' => 'Preferencias del administrador de sistema de Presence Builder',
    'sb__sitebuilder_support' => 'Soporte de Presence Builder',
    'sb_keep_sb_user' => 'Conservar la cuenta de usuario correspondiente en Presence Builder',
    'sb_create_sb_user' => 'Crear una cuenta de usuario correspondiente en Presence Builder',
    'sb__build_site_using_sitebuilder' => "Crear un sitio web usando Presence Builder",
    'sb_no_current_sb_server_set' => 'La conexión a Presence Builder todavía no está configurada: debe añadir un registro A en la plantilla de zona DNS que apunte al servidor Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "No se puede recuperar la información del sistema Presence Builder:%1",
    'sb_unable_connect_sb_wrong_con_params' => "No se puede conectar a Presence Builder: nombre de usuario o contraseña incorrectos.",
    'sb_init_sb_manager' => "Iniciando administrador de Presence Builder: % %1",
    'sb_err_couldnt_connect_sb' => "Error al conectarse al sistema Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Este cliente no tiene ninguna cuenta de usuario en Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder no está configurado.",
    'sb_err_you_dont_have_sbaccount' => "Error al autorizarle en Presence Builder.",
    'sb_error_critical_during_operation' => "Se ha producido el siguiente error en Presence Builder:%1",
    'sb_err_sso_is_not_enabled' => "El soporte de Single Sign-On no está activado en Plesk.",

    'forbid_create_dns_subzone' => "No permitir a los usuarios crear subzonas DNS en las súper zonas DNS de otros usuarios",
    'warning__super_zone_exist' => "Se ha creado la zona %1, pero este nombre de zona es una subzona de otra zona existente %2, que pertenece a otro usuario %3. Es posible, pero compruebe que ha seleccionado la cuenta de usuario correcta.",
    'error__super_zone_exist' => "No se puede crear la zona DNS porque su súper zona pertenece a otro usuario.",

    'locales__files_not_exits' => 'No se pudo cambiar el idioma porque en el sistema no se han encontrado los archivos del paquete de idioma especificado para el interfaz.',
    'locales__unavailable' => 'No se pudo cambiar el idioma porque el paquete de idioma especificado para el interfaz no está disponible.',

    // DB BU

    'pb__dbbackup_list' => 'Archivos de backup de base de datos',
    // server
    'dbbackup__server_backup_settings' => 'Backup',
    'dbbackup__network_temp_dir' => 'Directorio de red temporal',
    'dbbackup__network_user' => 'Nombre de usuario',
    'dbbackup__network_pass' => 'Contraseña',
    // domain
    'dbbackup__add_database_legend' => 'Restaurar base de datos copiada',
    'dbbackup__add_database_restore' => 'Restaurar base de datos usando un archivo de backup',
    'dbbackup__add_database_file' => 'Archivo de backup de la base de datos',
    'dbbackup__add_database_user' => 'Nombre de usuario predeterminado',
    'dbbackup__add_database_pass' => 'Contraseña de usuario predeterminada',
    'dbbackup__add_database_pass2' => 'Confirmación de contraseña de usuario predeterminada',

    'bt_dbbackup_now' => 'Copiar',

    'bt_repair' => 'Reparar',

    'dbbackup__mssql_dump_upload_not_allowed' => 'El proveedor de hosting prohíbe la carga de volcados de bases de datos SQL Server.',

    // APS categories

    'cf_invalid_password' => 'La contraseña no puede tener más de 16 caracteres',
    'cf_invalid_description_length' => 'La descripción no puede tener más de 256 símbolos',
    'ip_addr__ip_used_by_external_mail_server' => 'La dirección IP %1 ya está siendo usada por un servidor de correo externo',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Nombre de usuario o contraseña de la cuenta FTP incorrectos. Indique las credenciales correctas del usuario FTP.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Se ha alcanzado el límite de cambios en el número de serie. Hoy no puede realizar más cambios en la zona DNS.',
    'dns__zone_apply_changes' => 'Aún no se han guardado los cambios realizados en los registros DNS. A continuación se detallan los cambios realizados. Haga clic en Actualizar para aplicar los cambios en la zona DNS o en Revertir para descartar los cambios.',
    'dns__update_dns_zone' => 'Haga clic para guardar los cambios realizados en los registros DNS',
    'dns__revert_dns_zone' => 'Haga clic para cancelar los cambios realizados en los registros DNS',
    'bt_revert' => 'Revertir',
    'dns__dns_zone_has_beed_updated' => 'Se han guardado los cambios realizados en los registros DNS.',
    'dns__dns_zone_has_beed_reverted' => 'Se han cancelado los cambios realizados en los registros DNS',
    'db__nondefault_server_not_allowed' => 'No se permite el uso de un servidor de bases de datos que no sea el predeterminado',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Cuentas y dominios del cliente %1.',
    'ui__client__disabled-warning' => 'La cuenta de cliente %1 está suspendida.',
    'ui__client__none-available' => 'No se ha configurado ninguna cuenta de cliente.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Cliente %1',
    'ui__client_self__description' => 'Lista de mis dominios',
    'ui__client_self__short-title' => 'Mis dominios',
    'ui__client_self__title' => 'Mis dominios',


    'site_apps__non_removable' => 'Elementos que no pueden eliminarse',
    'site_apps__non_removable_items' => 'No pueden eliminarse las siguientes aplicaciones web:',

    'ui__client/custom-buttons/custom-button__none-available' => 'No existe ningún botón personalizado.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'En el panel del cliente %1 no existe ningún botón personalizado.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Elimine el botón %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Eliminar',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Eliminar el botón %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Eliminar botones personalizados del panel del cliente',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Eliminar',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Eliminar botones personalizados',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Eliminar botones',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Seleccione el cliente cuyos botones personalizados desea eliminar y haga clic en Siguiente >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Seleccione los botones que desea eliminar y haga clic en Siguiente >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Confirme la eliminación de los botones seleccionando la casilla en esta pantalla y haga clic en Finalizar.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Elimine un botón personalizado del panel del cliente.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Eliminar',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Eliminar un botón personalizado',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Eliminar botón personalizado',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyo botón personalizado desea eliminar y haga clic en Siguiente >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Seleccione el botón personalizado que desea eliminar y haga clic en Siguiente >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Confirme la eliminación del botón personalizado seleccionando la casilla en esta pantalla y haga clic en Finalizar.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Edite las propiedades del botón personalizado %1 a nivel del cliente.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Configuración',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Modificar el botón personalizado %1 del cliente',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Añadir botón personalizado',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Seleccione el cliente en cuyo panel desea crear un botón personalizado y haga clic en Siguiente>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Haga clic en Finalizar para crear el botón.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Cambie las propiedades de un botón en el panel del cliente.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Propiedades',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Cambiar las propiedades de un botón en el panel del cliente',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Cambiar propiedades de botón personalizado',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyo botón personalizado desea modificar y haga clic en Siguiente >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Seleccione el botón personalizado que desea modificar y haga clic en Siguiente >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Una vez editadas las propiedades del botón, haga clic en Finalizar para aplicar los cambios y salir del asistente.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Haga que el botón %1 no esté disponible para sus clientes.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Hacer que no esté disponible para sus clientes',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Hacer que el botón %1 no esté disponible para sus clientes',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Haga que los usuarios del cliente puedan ver el botón %1.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Hacer que esté disponible para sus clientes',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Hacer que los usuarios del cliente puedan ver el botón %1',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Haga que un botón personalizado esté disponible/no disponible para sus clientes.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Disponible/no disponible para sus clientes',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Hacer que un botón personalizado esté disponible o no para sus clientes',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Haga que un botón personalizado esté disponible/no disponible para sus clientes.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyo botón personalizado desea que esté disponible para los usuarios del cliente y haga clic en Siguiente >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Seleccione el botón personalizado que desea que esté disponible o no disponible para sus clientes y haga clic en Siguiente >>.',

    'ui__client/domain__description' => 'Administre el dominio %1.',
    'ui__client/domain__disabled-warning' => 'El dominio %1 está suspendido.',
    'ui__client/domain__none-available' => 'Usted no tiene ningún dominio.',
    'ui__client/domain__none-available__1' => 'La cuenta de %1 no tiene ningún dominio.',
    'ui__client/domain__none-available__2' => 'La cuenta de %1 no tiene ningún dominio.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Dominio %1',
    'ui__client/domain_self__description' => 'Administre su dominio.',
    'ui__client/domain_self__disabled-warning' => 'Su dominio está suspendido.',
    'ui__client/domain_self__quick-search' => 'Mis dominios',
    'ui__client/domain_self__short-title' => 'Mi dominio',
    'ui__client/domain_self__title' => 'Mi dominio',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'En el panel del cliente no existe ningún botón personalizado.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'El cliente %1 no tiene ningún botón personalizado en el panel del cliente.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'No existen botones personalizados para el dominio %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Elimine el botón personalizado %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Eliminar',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Eliminar el botón personalizado %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Elimine botones personalizados.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Eliminar botones personalizados',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Eliminar botones personalizados',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Seleccione el cliente cuyos botones del panel de administración de dominio desea eliminar y haga clic en Siguiente >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Seleccione el cliente de cuyo panel de administración de dominio desea eliminar los botones y haga clic en Siguiente >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Seleccione los botones que desea eliminar y haga clic en Siguiente >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Confirme la eliminación de los botones seleccionando la casilla respectiva y haga clic en Finalizar para eliminarlos y salir del asistente.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Elimine un botón personalizado.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Eliminar',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Eliminar un botón personalizado',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Eliminar un botón personalizado',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyo botón personalizado del panel de administración de dominio desea eliminar y haga clic en Siguiente >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Seleccione el dominio de cuyo panel de administración desea eliminar el botón y haga clic en Siguiente >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Seleccione el botón personalizado que desea eliminar y haga clic en Siguiente >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Confirme la eliminación del botón personalizado seleccionando la casilla y haga clic en Finalizar para eliminar el botón y salir del asistente.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Modificar propiedades del botón personalizado %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Propiedades",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Modifique las propiedades del botón personalizado %1 en el panel del cliente.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Añadir un botón',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Seleccione el cliente en cuyo panel desea añadir el botón y haga clic en Siguiente>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Seleccione la suscripción donde desea modificar el botón y haga clic en Siguiente >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Haga clic en Finalizar para crear el botón y salir del asistente.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Cambie las propiedades de un botón en el panel del cliente.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Propiedades',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Cambiar las propiedades de un botón en el panel del cliente',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Modificar propiedades del botón',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Seleccione el botón personalizado cuyos parámetros desea modificar y haga clic en Siguiente >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Una vez cambiadas las propiedades del botón, haga clic en Finalizar para aplicar los cambios y salir del asistente.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Haga que el botón %1 no esté disponible para los usuarios de correo de este dominio.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'No disponible para usuarios de correo',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Hacer que el botón %1 no esté disponible para los usuarios de correo de este dominio',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Haga que el botón %1 sea visible para los usuarios de correo de este dominio.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Accesible para los usuarios de correo de este dominio',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Hacer que el botón personalizado %1 sea visible para los usuarios de correo de este dominio',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Haga que un botón personalizado esté o no disponible para otros usuarios.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Disponible/no disponible para otros usuarios',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Hacer que un botón personalizado esté disponible o no para los usuarios de correo',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Hacer que un botón personalizado esté disponible o no para otros usuarios',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Seleccione el dominio donde está situado el botón y haga clic en Siguiente >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Seleccione el botón que desea que esté disponible o no para otros usuarios y haga clic en Siguiente >>.',

    'ui__client/domain/delete__description' => 'Elimine el dominio %1.',
    'ui__client/domain/delete__short-title' => 'Eliminar',
    'ui__client/domain/delete__title' => 'Eliminar el dominio %1',
    'ui__client/domain/delete_multi__description' => 'Elimine dominios.',

    'ui__client/domain/delete_multi__short-title' => 'Eliminar',
    'ui__client/domain/delete_multi__title' => 'Eliminar dominios',
    'ui__client/domain/delete_multi__wizard-title' => 'Eliminar dominios',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Seleccione los dominios que desea eliminar y haga clic en Siguiente >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Confirme la eliminación de los dominios seleccionando la casilla y haga clic en Finalizar para completar la eliminación y salir del asistente.',
    'ui__client/domain/delete_unknown__description' => 'Elimine un dominio.',
    'ui__client/domain/delete_unknown__short-title' => 'Eliminar',
    'ui__client/domain/delete_unknown__title' => 'Eliminar dominio',
    'ui__client/domain/delete_unknown__wizard-title' => 'Eliminar un dominio',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Seleccione el dominio que desea eliminar y haga clic en Siguiente >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Confirme la eliminación del dominio seleccionando la casilla y haga clic en Finalizar para eliminarlo y salir del asistente.',

    'ui__client/domain/hosting__none-available' => 'No existe ningún dominio con hosting web configurado. Cree un dominio y configure hosting web en él para poder acceder a esta funcionalidad.',
    'ui__client/domain/hosting__none-available__1' => 'Esta cuenta de usuario no tiene ningún dominio con hosting web configurado. Configure hosting web en el dominio requerido para acceder a esta funcionalidad.',
    'ui__client/domain/hosting__none-available__2' => 'Hosting web no configurado para el dominio %1. Configure hosting web en el dominio %1 para acceder a esta funcionalidad.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'Gestionar sus archivos y directorios',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'Seleccione el dominio con cuyos archivos desea usar.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'El hosting aún no se ha configurado en el dominio.Configure hosting físico y haga clic en Siguiente >> para ir al administrador de archivos.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'El hosting aún no se ha configurado en su dominio. Configure hosting físico y haga clic en Siguiente >> para ir al administrador de archivos.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'Una vez acabe de usar los archivos y directorios, haga clic en Finalizar para salir del asistente.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'Una vez acabe de usar los archivos y directorios, haga clic en Finalizar para salir del asistente.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'Ver configuración de rendimiento de hosting',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'Editar la configuración de rendimiento de hosting web',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'Seleccione el dominio para el que desea ver la configuración de rendimiento de hosting y haga clic en Siguiente.>>',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'Seleccione el dominio para el que desea configurar las opciones de rendimiento de hosting y haga clic en Siguiente>>.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'Configure las opciones de rendimiento de hosting en el dominio y haga clic en Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'Una vez revisada la configuración de rendimiento de hosting en el dominio, haga clic en Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'Una vez revisada la configuración de rendimiento de hosting en su dominio, haga clic en Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'Una vez revisada la configuración de rendimiento de hosting en el dominio, haga clic en Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'Una vez configuradas las opciones de rendimiento de hosting en su dominio, haga clic en Finalizar.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'Una vez configuradas las opciones de rendimiento de hosting en el dominio, haga clic en Finalizar.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Clientes",
    'ui__client/domain/hosting/application#list_header__description__title' => "Descripción",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Elementos",
    'ui__client/domain/hosting/application#list_header__name__title' => "Nombre",
    'ui__client/domain/hosting/application#list_header__release__title' => "Versión",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Ordenar por clientes",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Ordenar por descripción",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Ordenar por elementos",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Ordenar por nombre",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Ordenar por versión",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Ordenar por versiones",
    'ui__client/domain/hosting/application#list_header__title' => "Aplicaciones web",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versiones",

    'ui__client/domain/properties__client_ip_address_was_assigned' => 'La dirección IP %%ip_address%% ha sido asignada a %%client_name%%.',
    'ui__client/domain/properties__client_ip_pool_is_empty' => 'El grupo de direcciones IP del usuario está vacío. La dirección IP seleccionada se asignará a la cuenta de usuario correspondiente.',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => 'El dominio nuevo se creará inmediatamente después de que haga clic en Siguiente >>.',

    'ui__client/domain/properties_new__wizard-title' => 'Crear dominio',
    'ui__client/domain/properties_new__wizard__1_unknown' => 'Seleccione el cliente para el que desea crear el dominio.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => 'Seleccione el tipo de servicio de hosting deseado y haga clic en Siguiente >>.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => 'Una vez configurado el redireccionamiento en el dominio, haga clic en Finalizar para aplicar la configuración y salir del asistente.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => 'Una vez configurado el servicio de hosting en el dominio, haga clic en Finalizar para aplicar todos los cambios y salir del asistente.',

    'ui__client/domain/properties_unknown__wizard-title' => 'Configurar la cuenta del administrador del dominio',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => 'Seleccione el dominio para el que desea configurar la cuenta de administrador de dominio.',
    'ui__client/domain/properties_unknown__wizard__3' => 'Para completar la creación de la cuenta de administrador de dominio, haga clic en Finalizar.',
    'ui__client/domain/properties_unknown__wizard__3_self' => 'Para aplicar los cambios y salir del asistente, haga clic en Finalizar.',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => 'Estadísticas de FTP anónimo para un dominio',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => 'Estadísticas FTP anónimo',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => 'Estadísticas de FTP anónimo para un dominio',

    'ui__client/domain/report/ftp-stats_unknown__description' => 'Estadísticas de FTP para un dominio',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'Estadísticas FTP',
    'ui__client/domain/report/ftp-stats_unknown__title' => 'Estadísticas de FTP para un dominio',

    'ui__client/domain/report/traffic__description' => 'Ver el uso del ancho de banda por parte del sitio %1',
    'ui__client/domain/report/traffic__short-title' => 'Uso del ancho de banda',
    'ui__client/domain/report/traffic__title' => 'Ancho de banda usado por el sitio %1',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => 'Estadísticas sobre visitas seguras al sitio',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => 'Estadísticas sobre visitas a través de SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => 'Estadísticas sobre visitas seguras al sitio',

    'rpt_reseller_section_general' => 'General',
    'rpt_reseller_section_domains' => 'Dominios',
    'rpt_reseller_section_clients' => 'Clientes',
    'statistics__cl_active_domains' => "Dominios activos",
    'rpt_reseller_cl_domains' => "Dominios",
    'rpt_reseller_cl_subdomains' => "Subdominios",
    'by__cl_domains' => "dominios de los clientes",
    'dom_ctrl__cl_mboxes' => "Buzones de correo",
    'rpt_reseller_cl_redirects' => "Redireccionamientos",
    'rpt_reseller_cl_mail_groups' => "Grupos de correo",
    'rpt_reseller_cl_mail_resps' => "Respuestas automáticas",
    'rpt_reseller_cl_mail_lists' => "Listas de correo",
    'rpt_reseller_cl_web_users' => "Usuarios web",
    'rpt_reseller_cl_data_bases' => "Bases de datos",

    'statistics__active_clients' => 'Clientes con suscripciones activas',
    'statistics__clients_active_domains' => 'Dominios activos',
    'statistics__clients_doms' => 'Dominios',
    'statistics__cl_doms' => 'Dominios',
    '__clients_subdomains' => 'Subdominios',
    '__clients_domains' => 'Dominios',
    'dom_ctrl__clients_mboxes' => 'Buzones de correo',
    'dom_ctrl__clients_redir' => 'Redireccionamientos',
    'dom_ctrl__clients_mg' => 'Grupos de correo',
    'dom_ctrl__clients_resp' => 'Respuestas automáticas',
    'dom_ctrl__clients_maillists' => 'Listas de correo',
    'dom_ctrl__clients_wu' => 'Usuarios web',
    'dom_ctrl__clients_db' => 'Bases de datos',

    'dom_ctrl__cl_redir' => 'Redireccionamientos', // to resolve!
    'dom_ctrl__cl_mg' => 'Grupos de correo', // to resolve!
    'dom_ctrl__cl_resp' => 'Respuestas automáticas', // to resolve!
    'dom_ctrl__cl_maillists' => 'Listas de correo', // to resolve!
    'dom_ctrl__cl_wu' => 'Usuarios web', // to resolve!
    'dom_ctrl__cl_db' => 'Bases de datos', // to resolve!

    'rpt_cl_section_clients' => 'Clientes',

    'rpt_admin_section_general' => 'General',
    'rpt_admin_section_resellers' => 'Revendedores',
    'rpt_admin_section_clients' => 'Clientes',
    'rpt_admin_section_personal_clients' => 'Mis clientes',
    'rpt_admin_section_domains' => 'Dominios',
    'rpt_admin_section_personal_domains' => 'Dominios personales',

    'rpt_reseller_section_personal_domains' => 'Dominios personales',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Seleccione el dominio que desea suspender o activar.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Suspender o activar un dominio',

    'ui__client/ip-pool__description' => 'Asigne y cancele la asignación de direcciones IP y certificados SSL/TLS al cliente %1.',
    'ui__client/ip-pool__short-title' => 'Grupo de direcciones IP',
    'ui__client/ip-pool__title' => 'Grupo de direcciones IP del cliente %1',
    'ui__client/ip-pool_self__description' => 'Vea su grupo de direcciones IP.',
    'ui__client/ip-pool_self__short-title' => 'Grupo de direcciones IP',
    'ui__client/ip-pool_self__title' => 'Mi grupo de direcciones IP',
    'ui__client/ip-pool/properties__description' => 'Configure el grupo de direcciones IP para el cliente %1.',

    'ui__client/ip-pool/properties__short-title' => 'Grupo de direcciones IP',
    'ui__client/ip-pool/properties__title' => 'Configuración del grupo de direcciones IP para el cliente %1',
    'ui__client/ip-pool/properties_self__description' => 'Vea su grupo de direcciones IP.',

    'ui__client/ip-pool/properties_self__short-title' => 'Mi grupo de direcciones IP',
    'ui__client/ip-pool/properties_self__title' => 'Mi grupo de direcciones IP',
    'ui__client/ip-pool/properties_unknown__description' => 'Asigne o cancele la asignación de direcciones IP y certificados SSL/TLS al cliente.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Grupo de direcciones IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Configuración del grupo de direcciones IP del cliente',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Configuración del grupo de direcciones IP del cliente',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyo grupo de direcciones IP desea configurar.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Una vez configurado el grupo de direcciones IP, haga clic en Finalizar para aplicar los cambios y salir del asistente.',


    'ui__client/limits_readonly-unknown__description' => 'Vea los límites de recursos para un cliente.',
    'ui__client/limits_readonly-unknown__short-title' => 'Límites de recursos',
    'ui__client/limits_readonly-unknown__title' => 'Ver límites de recursos para una cuenta de cliente',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Ver o modificar los límites de recursos para un cliente',

    'ui__client/limits_unknown__wizard-title' => 'Ver o modificar los límites de recursos para un cliente',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Seleccione el cliente deseado.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Seleccione el cliente deseado.',
    'ui__client/limits_unknown__wizard__2' => 'Para aplicar los cambios, haga clic en Finalizar.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Para salir del asistente, haga clic en Finalizar.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Para salir del asistente, haga clic en Finalizar.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Para salir del asistente, haga clic en Finalizar.',

    'ui__client/permissions_unknown__wizard-title' => 'Ver o modificar permisos para un cliente',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Una vez vistos sus permisos, haga clic en Finalizar para aplicar los cambios y salir del asistente.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyos permisos desea ver o modificar.',
    'ui__client/permissions_unknown__wizard__2' => 'Una vez modificados los permisos del cliente, haga clic en Finalizar para aplicar los cambios y salir del asistente.',

    'ui__client/preferences_unknown__wizard-title' => 'Editar las preferencias del cliente',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyas preferencias de sesión e interfaz desea administrar.',
    'ui__client/preferences_unknown__wizard__2' => 'Una vez editadas las preferencias del cliente, haga clic en Finalizar.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Una vez editadas sus preferencias, haga clic en Finalizar.',

    'ui__custom-buttons/custom-button__none-available' => 'No tiene ningún botón personalizado.',
    'ui__custom-buttons/custom-button/delete__description' => 'Elimine el botón personalizado %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Eliminar',
    'ui__custom-buttons/custom-button/delete__title' => 'Eliminar el botón personalizado %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Elimine los botones personalizados.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Eliminar',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Eliminar botones personalizados',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Eliminar botones personalizados',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Seleccione los botones que desea eliminar.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Confirme la eliminación de los botones seleccionando la casilla y haga clic en Finalizar para salir del asistente.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Elimine botones personalizados.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Eliminar',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Eliminar botones personalizados',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Eliminar botones personalizados',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Seleccione el botón personalizado que desea eliminar.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Confirme la eliminación del botón seleccionando la casilla y haga clic en Finalizar para salir del asistente.',
    'ui__custom-buttons/custom-button/properties__description' => 'Edite las propiedades del botón %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Propiedades',
    'ui__custom-buttons/custom-button/properties__title' => 'Modificar las propiedades del botón %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Crear un botón',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Haga clic en Finalizar para crear el botón.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Edite las propiedades de un botón personalizado.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Propiedades',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Modificar las propiedades de un botón personalizado',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Modificar las propiedades de un botón personalizado',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Seleccione el botón personalizado cuyas propiedades desea modificar.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Para aplicar los cambios, haga clic en Finalizar.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Haga que el botón personalizado %1 no esté disponible para otros usuarios.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'No disponible para otros usuarios',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Hacer que el botón personalizado %1 no esté disponible para otros usuarios',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Haga que el botón personalizado %1 esté disponible para otros usuarios.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Disponible para otros usuarios',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Hacer que el botón personalizado %1 esté disponible para otros usuarios',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Haga que el botón personalizado esté disponible o no disponible para otros usuarios.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Disponible o no disponible para otros usuarios',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Hacer que el botón personalizado esté disponible o no disponible para otros usuarios',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Hacer que el botón personalizado esté disponible o no disponible para otros usuarios',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Seleccione el botón personalizado que desea que esté disponible o no disponible para otros usuarios y haga clic en Siguiente >>.',

    'ui__longtasks#list_header__name__title' => "Nombre",
    'ui__longtasks#list_header__owner__title' => "Propietario",
    'ui__longtasks#list_header__start_time__title' => "Hora de creación",
    'ui__longtasks#list_header__status__title' => "Estado",
    'ui__longtasks#list_header__title' => "Tareas",
    'ui__longtasks#list_header__finish_time__title' => "Hora de finalización",
    'ui__longtasks#task_list_legend__title' => "Tareas",
    'ui__longtasks#tools_legend__title' => "Herramientas",
    'ui__longtasks__description' => "Administrar tareas en segundo plano",
    'ui__longtasks__short-title' => "Tareas en segundo plano",
    'ui__longtasks__title' => "Tareas en segundo plano",
    'ui__longtasks/longtask/properties#current_operation__title' => "Operación actual:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Hora de finalización estimada:",
    'ui__longtasks/longtask/properties#general_legend__title' => "General",
    'ui__longtasks/longtask/properties#owner__title' => "Tareas iniciadas por:",
    'ui__longtasks/longtask/properties#progress__title' => "Progreso general:",
    'ui__longtasks/longtask/properties#start_time__title' => "Tareas iniciadas:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Estado de la tarea",
    'ui__longtasks/longtask/properties__description' => "Estado e información de tareas en segundo plano",

    'ui__longtasks/properties__description' => "Configuración de tareas en segundo plano",
    'ui__longtasks/properties__short-title' => "Configuración",
    'ui__longtasks/properties__title' => "Tareas en segundo plano",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Plantillas de emails masivos',
    'ui__mass-mail/template#list_header__name__title' => 'Nombre de la plantilla',
    'ui__mass-mail/template#list_header__from_email__title' => 'Remitente',
    'ui__mass-mail/template#list_header__to__title' => 'Destinatarios',
    'ui__mass-mail/template#list_header__subject__title' => 'Asunto',
    'ui__mass-mail/template#list_header__cdate__title' => 'Fecha de creación',
    'ui__mass-mail/template#list_header__send__title' => 'Enviar',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Editar plantilla de email masivo',
    'ui__mass-mail/template/properties__description' => 'Editar esta plantilla de email masivo.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Añadir plantilla de email masivo',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Añadir plantilla de email masivo',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Añada una plantilla de email masivo.',
    'ui__mass-mail/send__short-title' => 'Enviar email masivo',
    'ui__mass-mail/send__title' => 'Enviar mensaje de email masivo',
    'ui__mass-mail/send__description' => 'Envíe mensajes de email masivo a los destinatarios seleccionados.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Eliminar plantillas de email masivo',
    'ui__mass-mail/template/delete_multi__title' => 'Eliminar las siguientes plantillas de mensajes de email masivo:',
    'ui__mass-mail/template/delete_multi__description' => 'Elimine las plantillas de mensajes de email masivos seleccionadas.',
    'ui__mass-mail/template/delete_multi__done' => 'Las plantillas seleccionadas han sido eliminadas.',
    'ui__mass-mail/template/properties__invalid_values' => 'Los valores indicados no son válidos',


    // old
    'ui__mass-mail#body_text__description' => 'En el texto del mensaje puede utilizar la variable <name>, si bien no puede usarse en el encabezado. Esta será reemplazada por el nombre de contacto del cliente o del revendedor.',
    'ui__mass-mail#body_text__title' => 'Texto del mensaje',
    'ui__mass-mail#compose_legend__title' => 'Mensaje',
    'ui__mass-mail#from_email_text__title' => 'Desde (dirección de email)',
    'ui__mass-mail#list_header__cdate__title' => 'Creada',
    'ui__mass-mail#list_header__from_email__title' => 'Desde',
    'ui__mass-mail#list_header__name__title' => 'Nombre',
    'ui__mass-mail#list_header__send__title' => 'Crear mensaje',
    'ui__mass-mail#list_header__subject__title' => 'Asunto',
    'ui__mass-mail#list_header__title' => 'Plantillas de emails masivos',
    'ui__mass-mail#list_header__to__title' => 'Para',
    'ui__mass-mail#list_legend__title' => 'Plantillas de emails masivos',
    'ui__mass-mail#load_template_text__title' => 'Cargar',
    'ui__mass-mail#name_text__title' => 'Nombre de la plantilla',
    'ui__mass-mail#option_mode_all__title' => 'Todos',
    'ui__mass-mail#option_mode_except__title' => 'Todos excepto los seleccionados',
    'ui__mass-mail#option_mode_select__title' => 'Solo los seleccionados',
    'ui__mass-mail#option_select_template__title' => '---Seleccione una plantilla---',
    'ui__mass-mail#picker_legend__title' => 'Plantillas de mensajes de email',
    'ui__mass-mail#picker_title__title' => 'Seleccione una plantilla',
    'ui__mass-mail#save_as_legend__title' => 'Guardar como plantilla',
    'ui__mass-mail#save_as_text__title' => 'Guardar el mensaje en una plantilla nueva denominada',
    'ui__mass-mail#subject_text__title' => 'Asunto',
    'ui__mass-mail#template_legend__title' => 'Plantilla',
    'ui__mass-mail#to_admin_text__title' => 'Administrador de Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Clientes',
    'ui__mass-mail#to_domains_text__title' => 'Administradores de dominio',
    'ui__mass-mail#to_select_text__title' => 'Seleccione direcciones',
    'ui__mass-mail#to_show_hide_text__title' => 'Mostrar/ocultar seleccionados',
    'ui__mass-mail#to_text__title' => 'Para',
    'ui__mass-mail#tools_legend__title' => 'Herramientas',
    'ui__mass-mail__already_exists' => 'Ya existe una plantilla denominada %1.',
    'ui__mass-mail__none-available' => 'No dispone de ninguna plantilla de email.',

    'ui__mass-mail/delete__description' => 'Eliminar plantilla de mensajes de email masivos %1',

    'ui__mass-mail/delete__empty_selection' => 'Seleccione las plantillas que desea eliminar',
    'ui__mass-mail/delete__short-title' => 'Eliminar %1',
    'ui__mass-mail/delete__title' => 'Eliminar plantilla de mensajes de email masivos %1',
    'ui__mass-mail/delete_multi__description' => 'Eliminar plantillas de mensajes de email masivos.',

    'ui__mass-mail/delete_multi__short-title' => 'Eliminar',
    'ui__mass-mail/delete_multi__title' => 'Eliminar plantillas de mensajes de email masivos',
    'ui__mass-mail/delete_multi__wizard-title' => 'Eliminación de plantillas de mensajes de email masivos',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Seleccione las plantillas de mensajes de email masivos que desea eliminar.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Confirme la eliminación de la plantillas seleccionando la casilla y haga clic en Finalizar para salir del asistente.',
    'ui__mass-mail/delete_unknown__description' => 'Eliminar plantillas de mensajes de email masivos.',
    'ui__mass-mail/delete_unknown__short-title' => 'Eliminar',
    'ui__mass-mail/delete_unknown__title' => 'Eliminar plantillas de mensajes de email masivos',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Eliminación de plantillas de mensajes de email masivos.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Seleccione la plantilla de mensajes de email masivos que desea eliminar.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Confirme la eliminación de la plantilla seleccionando la casilla y haga clic en Finalizar para salir del asistente.',

    'ui__mass-mail/properties__description' => 'Edite la plantilla de mensaje de email %1.',

    'ui__mass-mail/properties__invalid_values' => 'Los valores indicados no son correctos',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Editar plantilla de mensaje de email %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Crear plantilla de mensajes de email masivos',
    'ui__mass-mail/properties_unknown-new__description' => 'Crear una plantilla de mensajes de email.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Añadir una plantilla de mensajes de email',
    'ui__mass-mail/properties_unknown-new__title' => 'Crear una plantilla de mensajes de email',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Editar plantilla de mensajes de email masivos',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Seleccione la plantilla que desea modificar y haga clic en Siguiente >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Una vez editada la plantilla, haga clic en Finalizar para aplicar los cambios y salir del asistente.',

    'ui__mass-mail/send__invalid_values' => 'Ha indicado unos valores incorrectos',

    'ui__mass-mail/send_new__wizard-title' => 'Crear una plantilla de mensajes y enviar un email',
    'ui__mass-mail/send_unknown-new__description' => 'Enviar un email a los destinatarios seleccionados',

    'ui__mass-mail/send_unknown-new__short-title' => 'Enviar email masivo',
    'ui__mass-mail/send_unknown-new__title' => 'Enviar mensaje de email masivo',
    'ui__mass-mail/send_unknown__description' => 'Enviar un email a los destinatarios seleccionados',

    'ui__mass-mail/send_unknown__short-title' => 'Enviar email masivo',
    'ui__mass-mail/send_unknown__title' => 'Enviar mensaje de email masivo',
    'ui__mass-mail/send_unknown__wizard-title' => 'Enviar mensaje de email masivo',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Seleccione la plantilla que deseada y haga clic en Siguiente >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Una vez editadas las propiedades de la plantilla, haga clic en Finalizar para enviar el mensaje y salir del asistente.',

    'ui__mass-email/delete__description' => 'Elimine las plantillas de mensajes de email masivos seleccionadas.',

    'ui__mass-email/delete__empty_selection' => "Seleccione las plantillas que desea eliminar.",
    'ui__mass-email/delete__short-title' => "Eliminar %1",
    'ui__mass-email/delete__title' => "Eliminar plantilla de mensajes de email masivos %1",
    'ui__mass-email/delete_multi__description' => "Eliminar plantillas de mensajes de email masivos.",

    'ui__mass-email/delete_multi__short-title' => "Eliminar",
    'ui__mass-email/delete_multi__title' => "Eliminar plantillas de mensajes de email masivos",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Confirme la eliminación de la plantillas seleccionando la casilla y haga clic en Finalizar para salir del asistente.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Seleccione las plantillas de mensajes de email masivos que desea eliminar.",
    'ui__mass-email/delete_multi__wizard-title' => "Eliminación de plantillas de mensajes de email masivos",
    'ui__mass-email/delete_unknown__description' => "Eliminar plantillas de mensajes de email masivos.",
    'ui__mass-email/delete_unknown__short-title' => "Eliminar",
    'ui__mass-email/delete_unknown__title' => "Eliminar plantillas de mensajes de email masivos",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Confirme la eliminación de la plantilla seleccionando la casilla y haga clic en Finalizar para salir del asistente.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Seleccione la plantilla de mensajes de email masivos que desea eliminar.",
    'ui__mass-email/delete_unknown__wizard-title' => "Eliminación de plantillas de mensajes de email masivos.",
    'ui__mass-email/send__description' => "Enviar un email a los destinatarios seleccionados",
    'ui__mass-email/send__short-title' => "Enviar email masivo",
    'ui__mass-email/send__title' => "Enviar mensaje de email masivo",
    'ui__mass-email/send_main__description' => "Enviar un email a los destinatarios seleccionados",

    'ui__mass-email/send_main__short-title' => "Enviar email masivo",
    'ui__mass-email/send_main__title' => "Enviar mensaje de email masivo",
    'ui__mass-email/send_selectresellers__title' => 'Seleccione revendedores',
    'ui__mass-email/send_selectresellers__short-title' => 'Revendedores',
    'ui__mass-email/send_selectresellers__description' => 'Seleccione cuentas de revendedor',

    'ui__mass-email/send_selectclients__description' => "Seleccione cuentas de cliente",

    'ui__mass-email/send_selectclients__short-title' => "Clientes",
    'ui__mass-email/send_selectclients__title' => "Seleccione clientes",
    'ui__mass-email/send_selectdomainusers__description' => "Seleccione cuentas de administrador de dominio",

    'ui__mass-email/send_selectdomainusers__short-title' => "Administradores de dominio",
    'ui__mass-email/send_selectdomainusers__title' => "Seleccione administradores de dominio",
    'ui__mass-email/template/properties_main__description' => "Crear plantilla de mensajes de email masivos",
    'ui__mass-email/template/properties_main__short-title' => "Editar plantilla",
    'ui__mass-email/template/properties_main__title' => "Editar plantilla de mensajes de email masivos",
    'ui__mass-email/template/properties_new-main__description' => "Cree una plantilla para emails masivos.",
    'ui__mass-email/template/properties_new-main__short-title' => "Crear plantilla de mensajes de email masivos",
    'ui__mass-email/template/properties_new-main__title' => "Crear plantilla de mensajes de email masivos",
    'ui__mass-email/template/properties_new-selectclients__description' => "Seleccione los clientes que deben recibir mensajes de email masivos basados en esta plantilla.",
    'ui__mass-email/template/properties_new-selectclients__title' => "Seleccione los clientes que deben recibir mensajes de email masivos basados en esta plantilla.",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Seleccione los administradores de dominio que deben recibir mensajes de email masivos basados en esta plantilla.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Seleccione los administradores de dominio que deben recibir mensajes de email masivos basados en esta plantilla.",
    'ui__mass-email/template/properties_selectclients__title' => "Seleccione los clientes que deben recibir mensajes de email masivos basados en esta plantilla.",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Seleccione los administradores de dominio que deben recibir mensajes de email masivos basados en esta plantilla.",

    'ui__mass-email/template/properties_unknown-new__description' => "Crear una plantilla de mensaje de email masivo",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Crear plantilla",
    'ui__mass-email/template/properties_unknown-new__title' => "Creación de una plantilla de mensaje de email masivo",
    'ui__news/dismiss__description' => 'Haga clic para cerrar el marco de noticias. Plesk no mostrará este marco hasta que se actualicen los artículos de noticias.',

    'ui__news/dismiss__title' => 'Cerrar las noticias',

    'ui__server__description' => 'Administración del servidor.',
    'ui__server__short-title' => 'Gestione su servidor',
    'ui__server__title' => 'Administración de servidor',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'La dirección IP %1 no está disponible.',
    'ui__server/ip-address__none-available' => 'Ninguna dirección IP.',
    'ui__server/ip-addresses/ip-address__title' => "Direcciones IP",
    'ui__server/ip-address/client/properties_new__description' => "Asigne la dirección IP %1 a revendedores.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Asignar',
    'ui__server/ip-address/client/properties_new__title' => "Asignar la dirección IP %1 a revendedores",
    'ui__server/ip-address/client__none-available' => 'No existe ninguna cuenta de usuario',
    'ui__server/ip-address/client_unknown__quick_search' => 'Usuarios',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Lista de usuarios que usan esta dirección IP.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Seleccione la dirección IP.',
    'ui__server/ip-address/client/delete__description' => 'Cancele la asignación de la dirección IP al revendedor.',
    'ui__server/ip-address/client/delete__short-title' => 'Cancelar asignación',
    'ui__server/ip-address/client/delete__title' => 'Cancelar la asignación de la dirección IP al revendedor',
    'ui__server/ip-address/client/delete_multi__description' => "Cancele la asignación de la dirección IP a los grupos de direcciones de direcciones IP de los revendedores.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Cancelar asignación',
    'ui__server/ip-address/client/delete_multi__title' => 'Cancelar la asignación de una dirección IP a un revendedor',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Elimine la dirección IP de los grupos de direcciones IP de los usuarios.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Seleccione la dirección IP cuya asignación a los usuarios desea cancelar y haga clic en Siguiente >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Seleccione los usuarios para los que desea cancelar la asignación a la dirección IP y haga clic en Siguiente >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Confirme la cancelación de la asignación de la dirección IP a los usuarios seleccionando la casilla y haga clic en Finalizar para salir del asistente.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Cancele la asignación de una dirección IP a revendedores.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Cancelar asignación',
    'ui__server/ip-address/client/delete_unknown__title' => 'Cancelar la asignación de la dirección IP a revendedores',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Cancelar la asignación de una dirección IP a usuarios',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Seleccione la dirección IP cuya asignación a los usuarios desea cancelar y haga clic en Siguiente >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Seleccione el usuario cuya asignación a la dirección IP desea cancelar y haga clic en Siguiente >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Confirme la cancelación de la asignación de la dirección IP a los usuarios seleccionando la casilla y haga clic en Finalizar para salir del asistente.',

    'ui__server/ip-address/domain__description' => "Todos los dominios en la dirección IP %1.",
    'ui__server/ip-address/domain__short-title' => "Dominios",
    'ui__server/ip-address/domain__title' => "Dominios en la dirección IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Todos los dominios en la dirección IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "Dominios",
    'ui__server/ip-address/domain_unknown__title' => "Dominios en la dirección IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Seleccione la dirección IP deseada y haga clic en Siguiente >>.",

    'ui__server/ip-address/properties__description' => 'Edite las propiedades de la dirección IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Propiedades',
    'ui__server/ip-address/properties__title' => 'Editar las propiedades de la dirección IP %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Añadir dirección IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Una vez modificadas las propiedades de la dirección IP, haga clic en Finalizar para aplicar los cambios.',
    'ui__server/ip-address/properties_unknown__description' => 'Edite las propiedades de la dirección IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Propiedades',
    'ui__server/ip-address/properties_unknown__title' => 'Editar las propiedades de la dirección IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Editar las propiedades de la dirección IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Seleccione la dirección IP cuyas propiedades desea editar.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Una vez modificadas las propiedades de la dirección IP, haga clic en Finalizar para aplicar los cambios.',

    'ui__server/spam-filter/black-list__description' => 'Configure una lista negra de filtro antispam a nivel de servidor.',
    'ui__server/spam-filter/black-list__short-title' => 'Lista negra',
    'ui__server/spam-filter/black-list__title' => 'Lista negra de filtro antispam a nivel de servidor',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Únicamente se añadirán las %1 primeras direcciones de email únicas.',
    'ui__server/spam-filter/black-list/address__description' => 'Dirección de la lista negra del filtro antispam.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'No existen direcciones de email en la lista.',
    'ui__server/spam-filter/black-list/address__file_size' => 'El archivo cargado está vacío.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Las siguientes direcciones de email no son válidas: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'En la lista negra del filtro antispam no existe ninguna dirección.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Dirección',
    'ui__server/spam-filter/black-list/address__title' => 'Dirección de la lista negra %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Añada direcciones a la lista negra.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Añadir direcciones',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Añadir direcciones a la lista negra',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Elimine la dirección %1 de la lista negra del servidor.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Eliminar',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Eliminar la dirección %1 de la lista negra del servidor',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Elimine direcciones de la lista negra del servidor.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Eliminar',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Eliminar direcciones de la lista negra del servidor',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Eliminación de direcciones de la lista negra del filtro antispam a nivel de servidor',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Seleccione las direcciones del filtro antispam que desea eliminar y haga clic en Siguiente >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Confirme la eliminación de direcciones del filtro antispam seleccionando la casilla, haga clic en Finalizar para eliminarlas completamente y salga del asistente.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Elimine la dirección de la lista negra del servidor.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Eliminar',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Eliminar la dirección de la lista negra del servidor',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Eliminación de direcciones de la lista negra del filtro antispam a nivel de servidor',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Seleccione la dirección del filtro antispam que desea eliminar y haga clic en Siguiente >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Confirme la eliminación de la dirección del filtro antispam seleccionando la casilla y haga clic en Finalizar para eliminarla y salir del asistente.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Únicamente se añadirán las %1 primeras direcciones de email únicas.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'No existen direcciones de email en la lista.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'No se pudo cargar el archivo. El tamaño máximo del archivo debe ser de %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Las siguientes direcciones de email no son válidas: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Añada direcciones a la lista negra.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Añadir direcciones',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Añadir direcciones a la lista negra',

    'ui__server/spam-filter/properties__description' => 'Configure un filtro antispam a nivel de servidor.',

    'ui__server/spam-filter/properties__short-title' => 'Configuración',
    'ui__server/spam-filter/properties__title' => 'Configuración del filtro antispam',

    'ui__server/spam-filter/toggle_disable__description' => 'Desactive la filtración de spam para todo el sistema.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Desactivar',
    'ui__server/spam-filter/toggle_disable__title' => 'Desactivar filtración de spam',
    'ui__server/spam-filter/toggle_enable__description' => 'Active la filtración de spam para todo el servidor.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Activar',
    'ui__server/spam-filter/toggle_enable__title' => 'Activar filtración de spam',
    'ui__server/spam-filter/toggle_unknown__description' => 'Active o desactive la filtración de spam para todo el servidor.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Activar o desactivar',
    'ui__server/spam-filter/toggle_unknown__title' => 'Activar o desactivar filtración de spam',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Activar o desactivar filtración de spam',

    'ui__server/spam-filter/white-list__description' => 'Configure una lista blanca del filtro antispam a nivel de sistema.',
    'ui__server/spam-filter/white-list__short-title' => 'Lista blanca',
    'ui__server/spam-filter/white-list__title' => 'Lista blanca de filtro antispam a nivel de sistema',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Únicamente se añadirán las %1 primeras direcciones de email únicas.',
    'ui__server/spam-filter/white-list/address__description' => 'Dirección de la lista blanca del filtro antispam.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'No existen direcciones de email en la lista.',
    'ui__server/spam-filter/white-list/address__file_size' => 'El archivo cargado está vacío.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Las siguientes direcciones de email no son válidas: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'La lista blanca a nivel de servidor del filtro antispam no contiene ninguna dirección.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Dirección',
    'ui__server/spam-filter/white-list/address__title' => 'Dirección de la lista blanca %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Añada direcciones a la lista blanca.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Añadir direcciones',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Añadir direcciones a la lista blanca',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Elimine la dirección %1 de la lista blanca del servidor.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Eliminar',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Eliminar la dirección %1 de la lista blanca del servidor',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Elimine direcciones de la lista blanca del servidor.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Eliminar',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Eliminar direcciones de la lista blanca del servidor',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Eliminación de direcciones de la lista blanca del filtro antispam a nivel de servidor',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Seleccione las direcciones del filtro antispam que desea eliminar y haga clic en Siguiente >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Confirme la eliminación de direcciones del filtro antispam seleccionando la casilla, haga clic en Finalizar para eliminarlas completamente y salga del asistente.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Elimine la dirección de la lista blanca del servidor.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Eliminar',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Eliminar dirección de la lista blanca del servidor',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Eliminación de direcciones de la lista blanca del filtro antispam a nivel de servidor',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Seleccione la dirección del filtro antispam que desea eliminar y haga clic en Siguiente >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Confirme la eliminación de la dirección del filtro antispam seleccionando la casilla y haga clic en Finalizar para eliminarla y salir del asistente.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Únicamente se añadirán las %1 primeras direcciones de email únicas.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'No existen direcciones de email en la lista.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'No se pudo cargar el archivo. El tamaño máximo del archivo debe ser de %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Las siguientes direcciones de email no son válidas: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Añada direcciones a la lista blanca.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Añadir direcciones',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Añadir direcciones a la lista blanca',

    'ui__server/mail/statistics#apply__description' => "Aplicar filtro",
    'ui__server/mail/statistics#apply__title' => "Aplicar",
    'ui__server/mail/statistics#custom_from__title' => "de",
    'ui__server/mail/statistics#custom_to__title' => "a",
    'ui__server/mail/statistics#period_all__title' => "Todos",
    'ui__server/mail/statistics#period_custom__title' => "Personalizado",
    'ui__server/mail/statistics#period_month__title' => "Este mes",
    'ui__server/mail/statistics#period_prev_month__title' => "Mes anterior",
    'ui__server/mail/statistics#period_prev_week__title' => "Semana anterior",
    'ui__server/mail/statistics#period_today__title' => "Hoy",
    'ui__server/mail/statistics#period_week__title' => "Esta semana",
    'ui__server/mail/statistics#period_yesterday__title' => "Ayer",
    'ui__server/mail/statistics#show_for_period__title' => "Mostrar para periodo",
    'ui__server/mail/statistics#tools_legend__title' => "Herramientas",
    'ui__server/mail/statistics__description' => "Ver estadísticas de virus y spam",

    'ui__server/mail/statistics__short-title' => "Estadísticas",
    'ui__server/mail/statistics__title' => "Configuración de correo",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Estadísticas spam",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Herramientas",
    'ui__server/mail/statistics/spam__description' => "Ver estadísticas de spam",

    'ui__server/mail/statistics/spam__short-title' => "Estadísticas spam",
    'ui__server/mail/statistics/spam__title' => "Estadísticas spam",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Nombre de correo",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% de todo",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Ordenar por cuenta de correo",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Ordenar por % de todo",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Ordenar por spam recibido",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "cuentas de correo",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Spam recibido",
    'ui__server/mail/statistics/spam/recipients__description' => "Destinatarios",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Destinatarios",
    'ui__server/mail/statistics/spam/recipients__title' => "Destinatarios",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Borrar",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Infectado",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Estado",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% de todo",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Contador",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Protegida",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "No comprobado",
    'ui__server/mail/statistics/spam/summary__description' => "Resumen",

    'ui__server/mail/statistics/spam/summary__short-title' => "Resumen",
    'ui__server/mail/statistics/spam/summary__title' => "Resumen",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Estadísticas de virus",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Herramientas",
    'ui__server/mail/statistics/virus__description' => "Ver estadísticas de virus",

    'ui__server/mail/statistics/virus__short-title' => "Estadísticas de virus",
    'ui__server/mail/statistics/virus__title' => "Estadísticas de virus",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Cuenta de correo",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% de todo",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Ordenar por nombre de correo",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Ordenar por % de todo",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Ordenar por virus recibidos",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Cuentas de correo",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Virus recibidos",
    'ui__server/mail/statistics/virus/recipients__description' => "Destinatarios",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Destinatarios",
    'ui__server/mail/statistics/virus/recipients__title' => "Destinatarios",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Borrar",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Infectado",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Estado",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% de todo",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Contador",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Protegida",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "No comprobado",
    'ui__server/mail/statistics/virus/summary__description' => "Resumen",

    'ui__server/mail/statistics/virus/summary__short-title' => "Resumen",
    'ui__server/mail/statistics/virus/summary__title' => "Resumen",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Nombre",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% de todo",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Ordenar por nombre",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Ordenar por % de todo",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Ordenar por objetos infectados",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Virus",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Objetos infectados",
    'ui__server/mail/statistics/virus/viruses__description' => "Virus",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Virus",
    'ui__server/mail/statistics/virus/viruses__title' => "Virus",

    'ui__support#param_company__title' => "Empresa",
    'ui__support#param_email__title' => "Email",
    'ui__support#param_firstname__title' => "Nombre",
    'ui__support#param_keynumber__title' => "Nº llave del producto",
    'ui__support#param_operatingsystem__title' => "Sistema operativo",
    'ui__support#param_phone__title' => "Teléfono",
    'ui__support#param_psabuild__title' => "Build de Plesk",
    'ui__support#param_psainsttype__title' => "Tipo de instalación de Plesk",
    'ui__support#param_psaversion__title' => "Versión de Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Herramientas",

    'ui__reseller/traffic-history_unknown__short-title' => "Ver tráfico por revendedores",
    'ui__reseller/traffic-history_unknown__title' => "Ver tráfico por revendedores",
    'ui__reseller/traffic-history_unknown__description' => "Vea el tráfico por cuentas de revendedor.",
    'ui__reseller#list__title' => "Revendedores",
    'accounts_list__name__filter_title' => "Nombre",
    'accounts_list__resource__filter_title' => "Uso de recursos",
    'resellers_list__filter_resource_usage_any' => "Cualquiera",
    'resellers_list__filter_resource_usage_overuse' => "Sobreuso",
    'resellers_list__filter_resource_usage_normal' => "Dentro de los límites",
    'accounts_list__status__filter_title' => "Estado",
    'resellers_list__filter_status_any' => "Cualquiera",
    'resellers_list__filter_status_blocked' => "Suspendido",
    'resellers_list__filter_status_active' => "Activos",
    'resellers_list__filter_clients__filter_title' => "Mostrar",
    'resellers_list__filter_clients_on' => "Revendedores con sus clientes",
    'resellers_list__filter_clients_off' => "Solo revendedores",
    '__disk_usage' => "Espacio en disco usado",
    'ui__reseller/traffic_unknown__short-title' => "Ver tráfico por revendedores",
    'ui__reseller/traffic_unknown__title' => "Ver tráfico por revendedores",
    'ui__reseller/traffic#list__title' => "Tráfico por revendedor",
    'ui__reseller/traffic_unknown__description' => "Vea informes de uso de tráfico.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Tráfico por revendedor",

    '__reseller_name' => "Nombre del revendedor",
    '__reseller' => "Revendedores",
    'resellertrafficlist_header' => "Ver tráfico por revendedores",
    '__reseller_personal' => "Tráfico usado por los dominios del revendedor",
    'ui__reseller/traffic-history__short-title' => "Tráfico por revendedores",
    'ui__reseller/traffic-history__title' => "Tráfico por revendedores",
    'ui__reseller/traffic-history__description' => "Vea informes de uso de tráfico.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Permitir sobreventa de recursos",
    'limits__reseller_oversell_description' => "La sobre venta de recursos permite al revendedor vender más recursos de los que tenía asignados. Si se permite la sobre venta de recursos, el revendedor se rige por el uso de recursos actual, en vez de regirse de por la asignación inicial de recursos",
    'limits__overuse_block_text' => "Directiva de sobreuso",
    'limits__overuse_block_true_text' => "Sobreuso no permitido",
    'limits__reseller_overuse_block_true_description' => "Bloquear el sobreuso de recursos. El uso actual de recursos no puede exceder la asignación inicial de recursos.",
    'limits__overuse_block_false_text' => "Sobreuso permitido",
    'limits__reseller_overuse_block_false_description' => "No bloquear el sobreuso de recursos, permitiendo al revendedor usar más recursos de los proporcionados inicialmente. El uso actual de recursos puede exceder la asignación inicial de recursos.",
    'limits__reseller_overuse_notify_text' => "Notificar al revendedor cuando se alcancen los límites de recursos",
    'reseller_perm__manage_sh_access_disabled' => "El revendedor no puede permitir o prohibir el acceso al shell",
    'reseller_perm__manage_sh_access_chrooted' => "El revendedor solo puede permitir acceso a un entorno chrooted",
    'reseller_perm__manage_sh_access_any' => "El revendedor puede permitir acceso a cualquier tipo de shell",
    'template__reseller_num_excl_ips' => "Asignar direcciones IP dedicadas al revendedor",

    // Reseller's Home page
    'client_chown__no_clients_selected' => 'Seleccione las cuentas de cliente a las que desea asignar un propietario nuevo.',
    'ui__reseller#tools2__title' => "Cuenta",
    'ui__reseller#info__title' => "Información",
    'ui__reseller#clientsTab__title' => "Clientes",
    'ui__reseller#domainsTab__title' => "Dominios",
    'ui__reseller__title' => "Administrar la cuenta de revendedor de %1",
    'domains__reseller_info' => "%1 clientes, %2 dominios, %3 de espacio en disco usado, %4 datos transferidos.",
    'domains__reseller_info_hiding_traffic' => "%1 clientes, %2 dominios, %3 espacio en disco utilizado.",
    'ui__reseller__description' => "Administre la cuenta del revendedor.",

    'ui__reseller/limits_unknown__wizard-title' => 'Ver o modificar los límites de recursos para un revendedor',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Seleccione el revendedor deseado.',
    'ui__reseller/limits_unknown__wizard__2' => 'Para aplicar los cambios, haga clic en Finalizar.',

    'ui__client/report_reseller__short-title' => "Informe",
    'ui__client/report_reseller__title' => "Ver informe de cuenta",
    'ui__client/report_reseller__description' => "Vea el informe de la cuenta de revendedor.",
    'ui__client/ip-pool_reseller__short-title' => "Grupo de direcciones IP",
    'ui__client/ip-pool_reseller__description' => "Asigne direcciones IP y certificados SSL/TLS a la cuenta del revendedor.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Especifique la configuración de la cuenta y haga clic en Finalizar.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Ver o modificar permisos para un revendedor',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Seleccione el revendedor cuyos permisos desea ver o modificar.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Una vez modificados los permisos del revendedor, haga clic en Finalizar para aplicar los cambios y salir del asistente.',

    // Customers > create customer account

    '__resellers_list' => 'Revendedores',
    'picker_reseller__title' => 'Seleccione el revendedor',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Herramientas",
    'ui__client#tools2__title' => "Cuenta",
    'ui__client#info__title' => "Información",
    'ui__client#clientslist__title' => "Clientes",
    'ui__client#domainslist__title' => "Dominios",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Ahora todas las aplicaciones web se ordenan por categorías, lo que simplifica la elección de la aplicación a instalar.",
    'feature__domainkeys__reseller' => "Puede usar el mecanismo de autenticación de remitentes de email DKIM para reducir la cantidad de spam y phishing.",

    '__reseller_form' => "Formulario de revendedor",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Seleccione la cuenta de cliente cuya configuración desea modificar.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Para modificar los límites de uso de recursos, haga clic en Límites de recursos.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Para modificar los permisos para las operaciones que el cliente puede realizar en Plesk, haga clic en Permisos.",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "Para crear un dominio que pertenezca a su cuenta, haga clic en Crear dominio. Para crear un dominio para uno de sus clientes, haga clic en el nombre del cliente y a continuación en Crear dominio.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Hacer que esta plantilla esté disponible para otros usuarios",
    'template__shared_description' => "Seleccione esta opción si desea que sus clientes puedan usar esta plantilla.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Herramientas',

    'ui__client/traffic-history_unknown__short-title' => 'Ver tráfico por clientes',
    'ui__client/traffic-history_unknown__title' => 'Tráfico por clientes',
    'ui__client/traffic-history_unknown__description' => 'Ver informe de uso de tráfico para todos los clientes',
    'ui__client/traffic-history__short-title' => 'Tráfico por clientes',
    'ui__client/traffic-history__title' => 'Ver tráfico por clientes',
    'ui__client/traffic-history__description' => 'Ver informe de uso de tráfico para todos los clientes',

    'ui__client/traffic#list__title' => 'Tráfico por clientes',
    'ui__reseller/client/traffic#list__title' => 'Tráfico por clientes',

    'clients_list__filter_type__filter_title' => 'Mostrar',
    'clients_list__filter_type_any' => 'Clientes y revendedores',
    'clients_list__filter_type_clients' => 'Solo clientes',
    'clients_list__filter_type_resellers' => 'Solo revendedores',
    'ui__client/domain_unknown-new__short-title' => "Crear dominio",

    // Customers > View traffic by customers
    '__personal' => "Tráfico usado por los dominios del usuario",
    'PersonalTrafficList_header_of_client__' => "Ver informe de uso de tráfico para su cuenta",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "El administrador del dominio no puede permitir o prohibir el acceso al shell",
    'domain_perm__manage_sh_access_chrooted' => "El administrador del dominio solo puede permitir el acceso a un entorno chrooted",
    'domain_perm__manage_sh_access_any' => "El administrador del dominio puede permitir el acceso a cualquier tipo de shell",

    // APS Catalog
    'bt_add_to_vault' => "Añadir al inventario",
    'bt_hide_updates' => "Ocultar actualizaciones disponibles",
    'bt_show_updates' => "Mostrar actualizaciones disponibles",

    '__site_apps__applications' => "Aplicaciones",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplicaciones seleccionadas para ser añadidas al inventario",
    'site_apps__application_selected' => "Seleccionadas",
    'site_apps__currently_in_vault' => "Otras versiones ya presentes en el inventario:",
    'site_apps__new_versions' => "Versiones nuevas:",
    'site_apps__patches' => "Parches:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Nº aplicaciones programadas para ser añadidas al inventario: %1",
    'site_apps__applications_downloading_now' => "Se están descargando las siguientes aplicaciones: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Ya presente en el inventario",

    // Server > Action Log
    'bt_skin_edit' => "Editar descripción del skin",
    'domains__you_want_change_the_status_of_the_reseller??' => "¿Está seguro de que desea cambiar el estado de la cuenta de revendedor?",
    'limits__oversell_legend' => "Sobre venta de recursos",
    'limitsManager__limit_available_error' => "No se puede asignar la cantidad de recursos requerida (%%quantity%% %%limitName%%). Cantidad disponible: %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "No se puede definir el límite de uso de recursos requerido (%%quantity%% %%limitName%%) porque el valor nuevo es inferior a la cantidad de recursos reservados para sus clientes o usados por usted (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "No se puede definir el límite de uso de recursos requerido (%%quantity%% %%limitName%%) porque el valor nuevo es menor a la cantidad actual de recursos usados por su cuenta y sitios (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Uso del ancho de banda por parte de los servicios",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Ver informe de uso de tráfico",
    'ui__client/domain/traffic_unknown-reseller__title' => "Ver informe de uso de tráfico",

    'ui__client/domain_new__short-title' => "Crear dominio",

    'ui__client_reseller__description' => "Administre la cuenta de revendedor %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Administrar cuenta de revendedor",

    '__owner_name' => "Nombre del propietario",
    'domains_list__resource__filter_title' => "Uso de recursos",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Catálogo de aplicaciones APS",
    'site_apps__applications_have_updates' => "Hay versiones actualizadas disponibles de las siguientes aplicaciones:\n%1\nPara ver las actualizaciones, compruebe que el área Búsqueda es visible, seleccione la casilla <b>Mostrar solo aplicaciones</b> y busque las aplicaciones deseadas.",
    'site_apps__progress_adding_to_vault' => "Añadiendo al inventario:",
    'site_apps__progress_done_message' => "Progreso:",
    'site_apps__progress_applications_left' => "%1 de %2 aplicaciones pendientes",
    'site_apps__download_item_long_task_title' => "Descargar aplicación APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Descargar aplicaciones APS del catálogo APS",
    'site_apps__last_check_for_updates' => "última búsqueda de actualizaciones: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Todas las aplicaciones programadas se han añadido correctamente al Application Vault.",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 aplicaciones programadas se han añadido correctamente al Application Vault.",
    'site_apps__no_search_results' => 'No se ha encontrado ninguna aplicación. Pruebe otro criterio de búsqueda o busque las aplicaciones por categorías.',
    'site_apps__search_results_title' => 'Resultados de la búsqueda',
    '__site_apps__search_by_application' => 'Nombre de la aplicación',
    '__site_apps__search_by_vendor' => 'Fabricante',
    '__site_apps__search_by_vendor__all' => 'Todos los fabricantes',
    '__site_apps__search_by_packager' => 'Empaquetador',
    '__site_apps__search_by_certification_level' => 'Nivel de certificación',
    '__site_apps__search_by_cert__any' => 'Cualquiera',
    '__site_apps__search_by_cert__silver_and_higher' => 'Silver y superior',
    '__site_apps__search_by_cert__gold_and_higher' => 'Gold y superior',
    '__retry' => 'Volver a intentar',
    'site_apps__application_packager_site' => 'Empaquetador',
    'site_apps__add_to_pool_message' => "Las aplicaciones marcadas como \"disponible para todos\"\\ se distribuyen de forma automática a todos los revendedores y clientes con un número ilimitado de instalaciones. Las aplicaciones restringidas se distribuyen a todos los revendedores y clientes de forma manual e individualizada con un número de instalaciones disponibles especificado explícitamente.",
    'site_apps__make_available_for_all' => "Hacer que las aplicaciones seleccionadas estén disponibles para todos los usuarios",

    'site_apps__broadcast_app_text' => "Las aplicaciones marcadas como \"disponible para todos\"\\ se distribuyen de forma automática a todos los revendedores y clientes con un número ilimitado de instalaciones. Las aplicaciones restringidas se distribuyen a todos los revendedores y clientes de forma manual e individualizada con un número de instalaciones disponibles especificado explícitamente.",
    'site_apps__broadcast_app_name' => 'Hacer que la aplicación esté disponible para todos los usuarios',

    // User Application Pool per application
    'site_apps__available_clients' => 'Usuarios disponibles',
    'site_apps__no_more_clients_to_add_to_pool' => 'No existen más cuentas de usuario a las que ofrecer esta aplicación',

    // Installed application instances
    'site_apps__installations' => 'Instalaciones',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Dirección IP y nombre del dominio",
    '__assign_ip_address' => "Asignar dirección IP",
    '__switch_on_service' => "Activar servicio",
    '__hosting_configuration' => "Configuración de hosting",
    '__vrt_hst' => "Hosting de sitio web",
    '__vrt_hst_hint' => "Aloje un sitio web en este servidor.",
    '__fwd' => "Reenvío",
    '__web_hosting_settings' => "Configuración de hosting",
    '__fwd_hint' => "Redireccione visitantes a otro sitio web.",
    '__none_hint' => "No alojar ningún sitio web en este momento.",
    '__login_hint' => "Este nombre de usuario se usa para acceder a su sitio web a través de FTP",
    '__password_hint' => "Esta contraseña se usa para acceder a su sitio web a través de FTP",
    '__advanced_hosting_setup' => "Configurar opciones avanzadas de hosting de sitios web",
    '__domain_creation_successful' => "El dominio ha sido creado.",
    'bt_hosting_settings' => "Configuración de hosting",
    '__change_hosting_type' => "Cambiar tipo de hosting para el dominio %1",
    '__hosting_type_change_warning' => "Cuando cambie el tipo de hosting a redireccionamiento o no hosting, todos los archivos y directorios relacionados con su sitio serán eliminados del servidor. Compruebe que dispone de una copia local de su sitio.",
    '__current_hosting_type' => "Tipo de hosting actual",
    '__new_hosting_type' => "Tipo de hosting nuevo",
    '__fwd_settings' => "Configuración de redireccionamiento",
    '__fwd_settings_legend' => "Configuración de redireccionamiento",
    '__fwd_destination_url' => "URL de destino",
    '__fwd_type' => "Tipo de redireccionamiento",
    '__fwd_type_standart' => "Redireccionamiento estándar",
    '__fwd_type_standart_hint' => "Redireccione los visitantes del sitio web a otro sitio mostrándoles la dirección de destino, para que así sepan que se les está redireccionando.",
    '__fwd_type_frame' => "Redireccionamiento por marcos",
    '__fwd_type_frame_hint' => "Redireccione los visitantes del sitio web a otro sitio, pero no mostrarles la dirección de destino, por lo que estos no serán conscientes de esta redirección.",
    '__hosting_type_template_warning' => "El tipo de hosting seleccionado es distinto del tipo especificado en la plantilla. De continuar, se ignorará la configuración de hosting web en la plantilla seleccionada. ¿Está seguro de que desea configurar el tipo de hosting seleccionado?",

    'ui__client/domain/properties#vrt_hst__title' => "Hosting de sitio web",
    'ui__client/domain/properties#vrt_hst__description' => "Alojar un sitio web en este servidor",
    'ui__client/domain/properties#fwd__title' => "Reenvío",
    'ui__client/domain/properties#fwd__description' => "Redireccionar visitantes a otro sitio web",
    'ui__client/domain/properties#none__title' => "Sin hosting",
    'ui__client/domain/properties#none__description' => "No alojar ningún sitio web en este momento",

    '__no_resellers_selected' => "Seleccione al menos una cuenta de revendedor.",

    'ui__client/logo_unknown__wizard-title' => 'Configurar un logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyas propiedades de logo desea editar.',
    'ui__client/logo_unknown__wizard__2' => 'Haga clic en Finalizar para aplicar los cambios.',
    'ui__client/logo_unknown__wizard__2_self' => 'Haga clic en Finalizar para aplicar los cambios.',

    'ui__client/ipaddress/properties_new__short-title' => "Añadir dirección IP",
    'ui__client/ipaddress/properties_new__title' => 'Añadir dirección IP',
    'ui__client/ipaddress/properties_new__description' => "Añada la dirección IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Añadir dirección IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Añadir dirección IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Añadir dirección IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Eliminar dirección IP",
    'ui__client/ipaddress/delete_multi__description' => "Elimine direcciones IP.",
    'ippool_Manager__no_available_ips' => "En el grupo de direcciones IP no existe ninguna dirección IP vacante.",
    'ippool_Manager__ip_shared' => "compartida",
    'ippool_Manager__ip_exclusive' => "dedicada",
    'ui__client/ipaddress/properties__title' => "Administrar direcciones IP",
    'ui__client/ipaddress/properties__description' => "Vea o edite las propiedades de la dirección IP.",
    'ui__client/ipaddress_unknown-new__title' => "Añadir dirección IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Añadir dirección IP",
    'ui__client/ipaddress_unknown-new__description' => "Añada direcciones IP.",

    'ui__mass-mail#to_resellers_text__title' => "Revendedores",
    'ui__mass-mail#to_domainusers_text__title' => "Administradores de dominio",
    'ui__mass-email#tools_legend__title' => "Herramientas",
    'ui__mass-email#list_legend__title' => 'Plantillas de emails masivos',
    'ui__mass-email#template_legend__title' => "Plantilla",
    'ui__mass-email#from_email_text__title' => "Desde",
    'ui__mass-email#to_text__title' => 'Para',
    'ui__mass-email#to_resellers_text__title' => "Revendedores",
    'ui__mass-email#to_clients_text__title' => "Clientes",
    'ui__mass-email#to_domainusers_text__title' => "Administradores de dominio",
    'ui__mass-email#to_admin_text__title' => "Administrador de Plesk",
    'ui__mass-email#option_mode_all__title' => "Todos",
    'ui__mass-email#option_mode_select__title' => "Solo los seleccionados",
    'ui__mass-email#option_mode_except__title' => "Todos excepto los seleccionados",
    'ui__mass-email#option_select_template__title' => '---Seleccione una plantilla---',
    'ui__mass-email#subject_text__title' => "Asunto",
    'ui__mass-email#body_text__title' => "Texto del mensaje",
    'ui__mass-email#save_as_legend__title' => "Guardar como plantilla",
    'ui__mass-email#save_as_text__title' => "Guardar el mensaje en una plantilla nueva denominada",
    'ui__reseller/preferences_unknown__wizard-title' => "Cambiar configuración de la cuenta",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Seleccione el revendedor cuya configuración de cuenta desea modificar y haga clic en Siguiente.",
    'ui__reseller/preferences_unknown__wizard__2' => "Especifique la configuración de la cuenta y haga clic en ACEPTAR.",
    'ippoolManager__ip_shared' => "compartida",
    'ippoolManager__ip_exclusive' => "dedicada",

    '__users_list' => "Usuarios",
    '__users' => "Usuarios",
    '__user_name' => "Nombre del usuario",

    'clientOwnerChanger__wrong_owner_type' => "A una cuenta de revendedor solo puede transferir las cuentas de cliente seleccionadas.",
    'clientOwnerChanger__wrong_client_type' => 'La cuenta de usuario seleccionada es una cuenta de revendedor. Las cuentas de revendedor no pueden asignarse a un propietario nuevo, ya que son propiedad del administrador del servidor.',
    'ui__client/chowner_multi__description' => "Transfiera cuentas de usuario a otro propietario.",
    'client_chown__clients_list_legend' => "Cuentas de usuario",
    'client_chown__client_name' => "Nombre del usuario",
    'client_chown__old_owner' => "Propietario anterior",
    'client_chown__limits_legend' => "Recursos",
    'client_chown__limit_name' => "Nombre del recurso",
    'client_chown__limit_value' => "Recursos asignados",
    'client_chown__usage_before' => "Antes de la transferencia",
    'client_chown_usage_after' => "Tras la transferencia",
    'limit__name_max_dom_aliases' => "alias de dominio",
    'limit__name_max_subftp_users' => "cuentas FTP adicionales",
    'limit__name_max_mssql_db' => "Bases de datos Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Grupos de aplicaciones IIS",
    'limit__name_max_odbc' => "Conexiones ODBC",
    'total_mboxes_quota_unsupported' => 'no soportada por el servidor de correo',
    'limit_soft__disk_space' => 'Notificar al alcanzar el espacio en disco',
    'limit_soft__max_traffic' => 'Notificar al alcanzar el tráfico',
    'dsr__of_reseller_title' => "Uso de recursos por dominios",
    'client_chown__new_owner' => 'Propietario nuevo',
    'ui__reseller/to-client__has_clients_warning' => 'Algunas de las cuentas de revendedor seleccionadas no pueden convertirse en cuentas de cliente porque tienen clientes suscritos a sus servicios. Elimine las cuentas de cliente suscritas a este revendedor o muévalas a otro revendedor.',
    'limitsManager__commit_failed' => "No se pueden modificar los límites de recursos.",
    'limitsManager__date_in_past' => "Fecha de expiración %1 incorrecta.",
    'limitsManager__limit_not_supported' => "No se pueden definir los límites para el tipo de recurso %1.",
    'limitsManager__limit_oversell_inconsistency' => "No se pueden asignar las cantidades de recursos especificadas si se tiene desactivada la sobre venta de recursos.",
    'limitsManager__limit_overuse_inconsistency' => "El uso de recursos excede los límites definidos.",
    'limitsManager__no_resource_available' => "No hay suficientes recursos disponibles de este tipo (%%limitName%%). Solicitados: %%quantity%%; disponibles: %%unused%%.",
    'limitsManager__no_total_resource_available' => "No hay disponible ningún recurso de este tipo (%%limitName%%) a través de su proveedor de servicios. Solicitados: %%quantity%%; disponibles: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "La fecha de expiración debe ser menor o igual a %1.",
    'limitsManager__invalid_disk_space_limit' => "La cantidad de espacio en disco debe ser inferior o igual a %1.",
    'limitsManager__invalid_max_traffic_limit' => "La cantidad de tráfico debe ser inferior o igual a %1.",
    'ippoolManager__ip_has_suballocations' => "No se puede cambiar el tipo de dirección IP ya asignada a un usuario. La dirección IP %%ip%% ya está asignada a usuario(s) como dirección IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Esta dirección IP ya se ha asignado al usuario.",
    'ippoolManager__ip_is_not_in_pool' => "No existe ninguna dirección IP %%ip%% en el grupo de direcciones IP.",
    'ippoolManager__can_not_allocate_ip' => "La dirección IP %%ip%% solo está disponible como %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "La dirección IP %%ip%% no puede asignarse como dedicada.",
    'ippoolManager__ip_used_by_hst_or_frw' => "La dirección IP %%ip%% ya es usada para hosting.",
    'ippoolManager__active_anon_ftp_on_ip' => "El acceso FTP anónimo ya está activado para la dirección IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "No existe ninguna dirección IP libre.",
    'ippoolManager__no_available_ips' => "No existe ninguna dirección IP disponible.",
    'templates__dublicate_name' => "Ya existe una plantilla con este nombre. Seleccione otro nombre para esta plantilla.",
    'cl_perm__client_limits_exceeded' => "Los valores de límite de recursos indicados exceden los valores permitidos por su plan de hosting o dichos valores ofrecen menos recursos que los usados en este momento por sus sitios.",
    'cl_perm__reseller_limits_exceeded' => "Los valores de límite de recursos indicados exceden los valores permitidos por su plan de hosting o dichos valores proporcionan menos recursos que los usados en este momento por las cuentas de usuario y sitios.",

    'site_apps__preferences_show_all_versions_title' => "Mostrar la lista completa de versiones de cada aplicación recuperada del catálogo",
    'site_apps__preferences_show_all_versions_hint' => "Si selecciona esta opción, puede que tarde mucho en recuperar todas las versiones de cada aplicación cada vez que abra el catálogo. De no seleccionarla, solo se mostrarán las versiones más recientes.",
    '__select_user_template' => "Crear cuenta de usuario basada en una plantilla",
    'ip_already_added_to_all_clients' => "Esta dirección IP ya ha sido asignada a todos los usuarios.",
    'ui__server/ip-address/client/delete#legend__description' => "Las siguientes direcciones IP se eliminarán del sistema y de los grupos de direcciones IP de los usuarios:",

    'site_apps__cancelled_apps' => "Ha cancelado la adición de las siguientes aplicaciones: %2",

    'sb_url_is_not_resolved' => 'No se puede resolver la URL: compruebe la configuración DNS. La URL %1 debe resolver en una dirección IP del servidor que tenga instalado Presence Builder.',

    'ip_addr__is_last_on_interface' => 'No se puede eliminar la dirección IP %%ip%% porque se trata de la última dirección IP presente en un interfaz de red.',
    'ip_addr__used_for_current_session' => 'No se puede eliminar la dirección IP %%ip%% porque está siendo usada por una sesión activa.',
    'ip_addr__used_for_hosting' => 'No se puede eliminar la dirección IP %%ip%% porque está siendo usada para alojar un sitio web.',
    'ip_addr__is_main' => 'No se puede eliminar la dirección IP %%ip%% porque es la dirección IP principal de un interfaz de red.',
    'ip_addr__ip_used_by_message_submission' => 'No puede eliminar la dirección IP %%ip%% porque se usa para el envío de mensajes de correo',

    // RESELLER ACTION LOG

    '__cl_domains' => 'dominios de clientes',
    'excl_ip_num' => 'Dirección IP dedicada',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder no está instalado.',

    '__perm_allow_oversell_can_not_be_revoked' => 'El permiso para poder realizar sobre ventas no puede ser revocado del usuario, ya que este ya ha asignado más recursos de los disponibles, encontrándose en modo de sobre venta.',
    'limitsManager__invalid_limit_value' => 'Valor %%value%% incorrecto indicado para el límite %%limit_name%%',
    'ip_alias__type' => "Dirección IP distribuida como",
    'ip_alias__in_type' => 'Dirección IP asignada como',
    'ui__client/ipaddress/delete_multi__title' => 'Eliminar direcciones IP',
    'ui__client/ipaddress/delete#legend__short-title' => 'Elementos que se eliminarán',
    'ui__client/ipaddress/delete#legend__description' => "Se eliminarán las siguientes direcciones IP del grupo de direcciones IP del usuario:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'Elementos que no pueden eliminarse',
    'ui__client/ipaddress/delete#nlegend__description' => 'No se pueden eliminar las siguientes direcciones IP:',
    'ui__server/ip-address/delete#legend__description' => 'Se eliminarán las siguientes direcciones IP del grupo de direcciones IP del servidor:',
    'confirmationForm_default_agreement_text' => 'Confirme la operación',
    'confirmationForm_default_confirm_message' => 'Confirme la operación.',
    'limit__max_mn' => 'Nº máximo de cuentas de correo',

    'limits__client_overuse_description' => 'La directiva de sobreuso indica a Plesk cómo actuar cuando el uso de recursos exceda la asignación de recursos inicial.',
    'limits__client_overuse_block_true_description' => 'Bloquear el sobreuso de recursos. El uso actual de recursos no puede exceder la asignación inicial de recursos.',
    'limits__client_overuse_block_false_description' => 'No bloquear el sobreuso de recursos, permitiendo al cliente usar más recursos de los proporcionados inicialmente. El uso actual de recursos puede exceder la asignación inicial de recursos',
    'limits__client_overuse_notify_text' => 'Notificar al cliente cuando se excedan los límites de recursos',

    'limits__domain_overuse_description' => 'La directiva de sobreuso indica a Plesk cómo actuar cuando el uso de recursos exceda la asignación de recursos inicial.',
    'limits__domain_overuse_block_true_description' => 'La directiva de sobreuso indica a Plesk cómo actuar cuando se haga un uso excesivo de los recursos.',
    'limits__domain_overuse_block_false_description' => 'No bloquear el sobre uso de recursos, permitiendo al dominio usar más recursos de los ofrecidos inicialmente. El uso actual de recursos puede exceder la asignación inicial de recursos',
    'limits__domain_overuse_notify_text' => 'Notificar al propietario del dominio cuando se alcancen los límites de recursos',


    'cancel_remove' => 'Descartar cualquier cambio y volver a la página anterior.',
    'php_not_installed' => 'PHP no instalado',

    'dns__dns_rr_delete' => 'Elementos que se eliminarán',
    'dns__delete_rr' => 'Se eliminarán los siguientes registros DNS de la zona DNS:',
    'dns__dns_rr_delete_non_removable' => 'Elementos que no pueden eliminarse',
    'dns__non_delete_rr' => 'No se pueden eliminar los siguientes registros DNS:',
    'dns__dns_rr_delete_confirm_message' => 'Confirme la eliminación de registros DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Formato de aplicación web desconocido: puede que la aplicación web no esté disponible para ser instalada y usada.',

    '__php_handler_type_desc' => 'Ejecutar PHP como',
    'sfdk_domain_sign__failed' => 'Se ha producido un error no identificado mientras se intentaba activar la firma de correo con DKIM en el dominio. Si desea más información, consulte el registro de errores del servidor.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notificación de actualización correcta de la llave de Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Notificación de demora de actualización de la llave de Plesk',
    'pkey_notify__subj_update_error_notification' => 'Notificación de error de actualización de la llave de Plesk',
    'pkey_notify__update_successful' => '%1 actualización completada correctamente.',
    'pkey_notify__update_failed_no_more_try' => 'No se pudo actualizar %1. La llave que está intentando enviar no es válida.No vuelva a intentar actualizar esta llave.',
    'pkey_notify__update_failed_try_later' => 'No se pudo actualizar %1: se produjo un error al procesar su llave. Puede intentar recuperar la llave de forma manual en Plesk (Herramientas y configuración > Administración de licencias) o permitir que Plesk intente actualizarla en las próximas 24 horas. Si no desea volver a recibir esta notificación, elimine esta llave de Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'No se pudo desactivar la filtración de spam a nivel de servidor.',
    'ui__server/spam-filter/toggle__unable_enable' => 'No se pudo activar la filtración de spam a nivel de servidor.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Este revendedor',
    'report_auto__select_reseller_report_all' => 'Todos los revendedores',
    'report_auto__select_reseller_report_client' => 'Todos los revendedores de este cliente',
    'report_auto__select_reseller_report_current' => 'Este revendedor',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Todos los clientes de este revendedor',
    'report_auto__select_client_report_client' => 'Este cliente',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Revendedores, clientes y dominios',

    'rpt_reseller_section_full_domains' => 'Dominios',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'AlDom',
    'rpt_reseller_dom_postboxes' => 'Buzones',
    'rpt_reseller_dom_redirects' => 'Redireccionamientos',
    'rpt_reseller_dom_mail_groups' => 'GruposCorreo',
    'rpt_reseller_dom_mail_resps' => 'Arespondedor.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'ListasC',
    'rpt_reseller_dom_web_users' => 'Wusers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Clientes',
    '__cl_name' => 'Nombre del cliente',
    '__cl_creation_date' => 'Fecha de creación',
    '__clients_traffic' => 'Tráfico del cliente',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder no está instalado.',
    'sitebuilder_disabled' => 'Presence Builder está desactivado.',
    'b_sitebuilder_disabled' => 'Presence Builder está desactivado.',
    'webmail_not_installed' => 'Software webmail no instalado.',
    'webmail_disabled' => 'El servicio Webmail está desactivado.',
    'spamassassin_not_installed' => 'SpamAssassin no está instalado.',
    // pfu:
    'anonymous_ftp_shared' => 'No se puede configurar el FTP anónimo: tipo de dirección IP compartida.',
    'anonymous_ftp_used' => 'No se puede configurar el FTP anónimo: la dirección IP es usada por otro dominio para el servicio FTP anónimo.',
    'sshterm__not_installed' => 'Terminal SSH no instalado.',
    'sshterm__empty_shell' => 'Para usar el cliente terminal, debe permitir el acceso al shell para este dominio.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET no está instalado.',
    'site_builder_no_package' => 'Presence Builder no está disponible. Compruebe que Presence Builder está instalado y seleccionado como componente activo.',
    'site_builder_not_configured' => 'Presence Builder no está configurado.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Herramientas',
    'ui__reseller/client#clientslist__title' => 'Clientes',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "Configurar orígenes de datos ODBC para el sitio web",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "Seleccione el sitio web para cuyas aplicaciones desea configurar los orígenes de datos ODBC.",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "Administrar directorios virtuales en el dominio",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "Seleccione el dominio cuyos directorios virtuales desea administrar.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Administrar directorios virtuales en un sitio web',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Seleccione el sitio web cuyos directorios desea administrar.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "Configurar protección hotlink para el dominio",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "Seleccione el dominio cuyos archivos desea proteger de hotlinking.",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "Configurar opciones PHP para el dominio",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "Seleccione el dominio cuyas opciones PHP desea configurar.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Configurar FTP anónimo en el dominio',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Seleccione el dominio para el que desea configurar el FTP anónimo.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Administrar directorios protegidos con contraseña en el dominio',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Seleccione el dominio cuyos directorios protegidos con contraseña desea administrar.',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => 'Ver estadísticas web para el dominio',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => 'Seleccione el dominio cuyas estadísticas web desea ver.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Configurar administrador de registros para el dominio y ver los archivos de registro del dominio',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Seleccione el dominio cuyo administrador de registros desea configurar y cuyos archivos de registro desea ver.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Administrar certificados SSL/TLS para el dominio',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Seleccione el dominio cuyos certificados SSL/TLS desea administrar.',

    'ui__client/to-reseller_multi__wizard-title' => 'Convertir cuentas de cliente a cuentas de revendedor',
    'ui__client/to-reseller_multi__wizard__1_multi' => 'Seleccione las cuentas de cliente que desea convertir en cuentas de revendedor.',

    'ui__reseller/to-client_multi__wizard-title' => 'Convertir cuentas de revendedor a cuentas de cliente',
    'ui__reseller/to-client_multi__wizard__1_multi' => 'Seleccione las cuentas de revendedor que desea convertir a cuentas de cliente.',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => 'Especifique la configuración de hosting para el dominio.',







    'ui__client/domain/disable_multi__wizard-title' => 'Suspender dominios',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Seleccione los dominios que desea suspender.',

    'ui__client/domain/enable_multi__wizard-title' => 'Activar dominios',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Seleccione los dominios que desea activar.',

    'ui__client/domain_unknown__wizard-title' => 'Ver dominios',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Seleccione el cliente cuyos dominios desea examinar.',

    'ui__client/domain/to-client_multi__wizard-title' => 'Convertir cuentas de administrador de dominio a cuentas de cliente',
    'ui__client/domain/to-client_multi__wizard__2_multi' => 'Seleccione los dominios cuyas cuentas de administrador desea convertir a cuentas de cliente',

    'ui__client/domain/register_unknown__wizard-title' => 'Registrar dominios',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Seleccione el dominio que desea registrar.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Usar herramientas de MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Seleccione el dominio que desea gestionar con las herramientas de MyPlesk.com.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'Acceder al servidor vía SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'Seleccione el dominio a cuyo host virtual desea conectarse a través de SSH.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Usuarios de dirección IP',
    'ui__server/ip-address/client_unknown__title' => 'Usuarios de dirección IP',
    'ui__server/ip-address/client_unknown__description' => 'Usuarios de la dirección IP %1',

    'disabled_by_admin' => 'Deshabilitado por el administrador del servidor',






    'ui__client/domain/chowner_multi__short-title' => 'Cambiar propiedad',
    'ui__client/domain/chowner_multi__title' => 'Cambiar propietario de la suscripción',
    'ui__client/domain/chowner_multi__description' => 'Cambie el propietario de la suscripción.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Seleccione el dominio cuyo propietario desea cambiar y haga clic en Siguiente >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Cambiar propiedad',
    'ui__client/domain/chowner_unknown__title' => 'Cambiar propietario de la suscripción',
    'ui__client/domain/chowner_unknown__description' => 'Cambie el propietario de la suscripción.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Cambiar propietario de la suscripción',


    'ui__client/chowner__short-title' => 'Cambiar el propietario del cliente',
    'ui__client/chowner__title' => 'Cambiar el propietario de la cuenta de cliente',
    'ui__client/chowner__description' => 'Asignar propietario nuevo a esta cuenta de cliente',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'No existe ningún botón personalizado.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'En el interfaz del revendedor %1 no existe ningún botón personalizado.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Elimine el botón %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Eliminar',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Eliminar el botón %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Eliminar botones personalizados del interfaz del revendedor',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Eliminar',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Eliminar botones personalizados',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Eliminar botones',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Seleccione el revendedor cuyos botones personalizados desea eliminar y haga clic en Siguiente >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Seleccione los botones que desea eliminar y haga clic en Siguiente >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Confirme la eliminación de los botones seleccionando la casilla en esta pantalla y haga clic en Finalizar.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Elimine un botón personalizado del interfaz del revendedor.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Eliminar',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Eliminar un botón personalizado',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Eliminar botón personalizado',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Seleccione el revendedor cuyo botón personalizado desea eliminar y haga clic en Siguiente >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Seleccione el botón personalizado que desea eliminar y haga clic en Siguiente >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Confirme la eliminación del botón personalizado seleccionando la casilla en esta pantalla y haga clic en Finalizar.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Edite las propiedades del botón personalizado %1 a nivel de revendedor.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Configuración',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Modificar botón personalizado %1 del revendedor',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Añadir botón personalizado',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Seleccione el revendedor en cuyo interfaz desea crear un botón personalizado y haga clic en Siguiente >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Haga clic en Finalizar para crear el botón.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Cambie las propiedades de un botón en el interfaz del revendedor.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Propiedades',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Cambiar las propiedades de un botón en el interfaz del revendedor',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Cambiar propiedades de botón personalizado',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Seleccione el revendedor cuyo botón personalizado desea modificar y haga clic en Siguiente >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Seleccione el botón personalizado que desea modificar y haga clic en Siguiente >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Una vez editadas las propiedades del botón, haga clic en Finalizar para aplicar los cambios y salir del asistente.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Haga que el botón %1 no esté disponible para sus clientes.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Hacer que no esté disponible para sus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Hacer que el botón %1 no esté disponible para sus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Haga que el botón %1 sea visible para los clientes del revendedor.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Hacer que esté disponible para sus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Hacer que el botón %1 sea visible para los clientes del revendedor',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Haga que un botón personalizado esté disponible/no disponible para sus clientes.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Disponible/no disponible para sus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Hacer que un botón personalizado esté disponible o no para sus clientes',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Haga que un botón personalizado esté disponible/no disponible para sus clientes.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Seleccione el revendedor cuyo botón personalizado desea que esté disponible para los clientes del revendedor y haga clic en Siguiente >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Seleccione el botón personalizado que desea que esté disponible o no disponible para sus clientes y haga clic en Siguiente >>.',




    'ui__server/ip-addresses__short-title' => 'Direcciones IP',
    'ui__server/ip-addresses__title' => 'Administración de direcciones IP',
    'ui__server/ip-addresses__description' => 'Añada, elimine y asigne direcciones IP.',

    'ip_ctrl__allow_ftps' => 'Permitir FTP a través de SSL/TLS',
    '__ftps' => 'FTP a través de SSL/TLS',
    '__not_allowed' => 'No permitido',



    'ui__client/ipaddress/domain_unknown__short-title' => 'Dominios que usan %2',
    'ui__client/ipaddress/domain_unknown__title' => 'Dominios que usan la %1 dirección IP %2',
    'ui__client/ipaddress/domain_unknown__description' => 'Ver la lista de dominios que usan la %1 dirección IP %2',

    'ui__client/ipaddress__none-available' => 'No hay ninguna dirección IP disponible',
    'ui__client/ipaddress__none-available__1' => 'No hay ninguna dirección IP disponible',



    'ui__client/domain/report_unknown__wizard-title' => 'Ver informe del dominio',
    'ui__client/domain/report_unknown__wizard__2_unknown' => 'Seleccione el dominio cuyo informe desea ver.',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Seleccione el propietario nuevo del dominio.',

    'ui__client/chowner__wizard__2_select' => 'Seleccione el propietario nuevo de la cuenta de cliente.',

    '__ip_addr_state_unknown' => "La dirección IP no está operativa porque el sistema aún está procesando su petición. Espere un minuto.",


    'resellers_list__accounts' => 'Usuarios',

    'ip_addr__repair_is_not_allowed' => 'La dirección IP no puede repararse en un entorno Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'El revendedor %1 no tiene ningún cliente.',

    'ippoolManager__ip_used_by_nohost_domain' => "La dirección IP %%ip%% no puede eliminarse, puesto que esta es usada por uno o más dominios sin hosting.",
    'ippoolManager__ip_used_for_mail_service' => "La dirección IP %%ip%% no puede eliminarse porque es usada por uno o más dominios para la dirección IP de su servicio de correo.",
    'ippoolManager__ip_used_for_send_emails' => "La dirección IP %%ip%% no puede eliminarse porque es usada para enviar emails desde una IP específica (examine la configuración del servidor de correo).",
    'ippoolManager__ip_used_in_dns_zone' => 'La dirección IP %%ip%% no puede eliminarse porque está siendo usada por la zona DNS de uno o más dominios.',
    'ip_ctrl__cannot_manage_on_vz' => 'Esta instalación de Plesk opera bajo Virtuozzo containers. El administrador del nodo Virtuozzo containers es el único que puede añadir direcciones IP nuevas.',

    'client_template__limits_auto_adjusted' => 'Los límites de la plantilla del cliente se han actualizado automáticamente.',

    '__entries' => 'Entradas',

    '__path_is_not_set' => 'Ruta no especificada. Indique una ruta válida.',

    // license keys
    'key_new_plesk_key_is_uploaded' => 'La nueva llave de Plesk ha sido cargada.',
    'key_new_additional_key_is_uploaded' => 'La llave nueva adicional ha sido cargada.',

    'defaultcomponents__imap_required' => '(El servidor de correo actual no soporta IMAP)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'Protección hotlink activada para este dominio.',
    'i_hotlinkprotection_off' => 'Protección hotlink desactivada para este dominio.',

    '__commercial_web_stats_not_installed' => 'Plesk solo soporta el uso de software comercial de estadísticas web para el cálculo de estadísticas de los subdominios. En este momento no tiene instalado este tipo de software en el sistema.',

    'mail__spamassassin_personal_settings_disallowed' => 'El administrador del servidor ha desactivado la habilidad para aplicar una configuración personalizada de la filtración de spam. Los parámetros de filtración de spam especificados a continuación no podrán ser aplicados',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => 'No se puede crear el objeto %1: %2',
    'cu_dom_pref__invalid_expiration_date' => 'Fecha de expiración no válida: %1',
    'cu_cl_pref__illegal_date_val' => 'Ha indicado un valor de fecha no válido ("%1")',
    'cu_cl_pref__illegal_date_greater_less' => 'Introduzca un año entre "%1" y "%2"',
    'cu_initconf__unable_set_ip_alias_type' => 'No se puede establecer el tipo de alias IP: %1',
    'cu_mlist__unable_change_status' => "No se puede cambiar el estado de la lista de correo: %1",
    'cu_initconf__unable_change_passwd' => "No se puede cambiar la contraseña del administrador: %1",
    'cu_serverpref__option_description_include_remote_databases' => 'Incluye las bases de datos MySQL remotas en el cálculo del uso del espacio en disco.',
    'cu_siteapp_item__add_to_pool_success' => 'La aplicación web se ha añadido al grupo de aplicaciones web.',
    'cu_siteapp_item__remove_from_pool_success' => 'La aplicación web se ha eliminado del grupo de aplicaciones web.',
    'cu_traffic_command_description_add_user' => 'Registra una cantidad de tráfico determinada como si ya estuviera siendo usada por el cliente/revendedor',
    'cu_traffic_command_description_sub_user' => 'Resta una cantidad de tráfico determinada de la cantidad registrada para el cliente/revendedor',
    'cu_traffic_command_description_add_batch_user' => 'Registra una cantidad de tráfico determinada como si ya estuviera siendo usada por el cliente/revendedor (modo batch)',
    'cu_traffic_command_description_del_user' => 'Restaura la cantidad de tráfico registrada para este cliente/revendedor a cero',
    'cu_resellerpref__option_lock_screen' => 'Impide a los usuarios utilizar Plesk hasta que las pantallas del interfaz se hayan cargado completamente',
];