<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx“502無效閘道：上游讀取回應頭時發送了太大的資訊頭”',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '快準備好了。',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache“500內部伺服器錯誤：此處不允許選項 FollowSymLinks”',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '快準備好了。',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "伺服器達到 max_children 設定"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>症狀</h4><ul><li><p>有 PHP 處理常式的網站設定為 <strong>Apache 服務的 FPM 應用程式</strong>或<strong>nginx 服務的 FPM 應用程式</strong>（位於 <strong>功能變數名稱</strong> &gt; <strong>example.com</strong> &gt;）<strong>PHP 設定</strong>遇到以下當中的一個問題：</p><ul><li><p>載入慢</p></li><li><p>不可訪問（永久或定期），web 流覽器中出現50x錯誤：</p><pre>502 無效閘道</pre><hr><pre>503 服務暫時不可用</pre><hr><pre>504 閘道超時</pre></li></ul></li><li><p>以下資訊出現在 PHP-FPM 錯誤日誌檔<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code>中（其中 <em>XX</em> 是網站使用的 PHP 版本）：</p><pre>警告： [pool example.com] 伺服器達到 max_children 設定 (*)，考慮將其提升</pre><ul><li><p>以上資訊通常伴隨此錯誤：</p><pre>無法讀取子代所說的內容：錯誤的檔描述符(9)</pre></li></ul></li><li><p>如果在伺服器上啟用了nginx，則功能變數名稱的錯誤日誌檔中可能會出現以下錯誤消息之一 <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: 資源臨時不可用)，連接上游時，用戶端：203.0.113.2，伺服器：example.com，請求： "GET / HTTP/1.1"，上游："fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:"，主機："example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 從上游讀取回應頭時，上游連接過早關閉連接，用戶端：203.0.113.2，伺服器：example.com，請求："POST /path/to/some/file HTTP/2.0"，上游：</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>網站已達到 PHP-FPM <code>pm.max_children</code>。</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => '增加 pm.max_children 限制',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>提高受影響的域名的 <code>pm.max_children</code> 限制：</p><ol><li><p>連接到 Plesk 伺服器，通過 <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>。</p></li><li><p>使用以下命令查找受影響的域名：</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>注意：</strong> 左邊的資料表示網站已達到 <code>pm.max_children</code> 限制的次數。</div><pre style="white-space: pre-wrap;"># grep -r "伺服器已達到 max_children 設定" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">登入到 Plesk</a>。</p></li><li><p>轉到 <strong>域名</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP 設定</strong> &gt; <strong>PHP-FPM 設定</strong>.</p></li><li><p>增加域名的 <code>pm.max_children</code> 值並應用更改。在第2步驟為所有列出的域名增加此值。</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "太多打開的文件"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx 無法在 Plesk 伺服器上啟動/載入：太多打開的檔</p><h4>症狀</h4><ul><li><p>nginx 服務無法啟動/載入，在 <code>/var/log/nginx/error.log</code> 文件中出現以下問題：</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: 太多打開的檔)</pre></li><li><p>某些或所有的網站不可存取</p></li><li><p>警告在<strong>工具與設定 &gt;診斷與修復</strong>中顯示：</p><pre style="white-space: pre-wrap;">查找nginx ULIMIT 值，在伺服器上找到 N 個域名。可能會出現已打開檔的 nginx 默認限制的問題</pre></li><li><p>NodeJS和Rubyweb應用程式在執行一些Plesk任務時顯示502無效閘道錯誤，例如在創建域名、訂閱或在Apache或Nginx上更改時：</p><pre style="white-space: pre-wrap;">伺服器錯誤<br>502 無效閘道<br>Web伺服器在作為閘道或代理伺服器時收到了一個無效的響應。</pre></li><li><p>在<a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">為域名安裝新的證書後</a>，舊的證書仍會在web 流覽器中顯示，但是會在 <strong>域名 &gt; example.com &gt; 主機設定</strong> 頁面中選定正確的證書。</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx的虛擬主機為帶有物理主機的每個虛擬主機打開了 4 個日誌檔：</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>因域名眾多（通常超過100個）所以會導致超過nginx伺服器可打開的檔的最大數量。</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => '增加打開的檔限制',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>警告：</strong> 執行<code>websrv_ulimits</code> 工具而無<strong>--no-restart</strong> 選項會啟動為所有域名重建 web 設定檔，可能會因為託管網站數量眾多而導致嚴重的宕機。<br><br>在維護期間框架內執行該命令</div><p>最好是將打開的檔限制值設定至少不超過<strong>Plesk * 16</strong> 中域名的數量。在下面的示例中，提供了如何設定限制為4096的操作步驟：</p><ol><li><p>通過<a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH連接到伺服器</a></p></li><li><p>為Apache和 Nginx將打開的檔限制設定為4096：</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>在 <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>工具 &amp; 設定 &gt; 服務管理</strong> 重啟Apache 和 nginx以應用更改。</p></li><li><p>在web服務重啟後檢查 \'打開檔限制最大值\' 是否正確應用：</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>打開檔最大值 4096 4096 個檔</pre></li><li><p>若上述方案沒有幫助，請使用 <code>ulimit</code> 工具設定限制：</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "回應主體太大"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '快準備好了。',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "訪問被拒，代碼 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>問題</h4><ul><li><p>ModSecurity 已安裝且在 <strong>工具與設定 > Web 應用防火牆 (ModSecurity) > Web 應用防火牆模式 > 啟用</strong> 中啟用。</p></li><li>在Plesk中託管的網站無法載入。不可能在網站上執行操作，如管理WordPress、存取web郵箱或存取<code>robots.txt</code>文件。流覽器可能會顯示以下錯誤之一：<pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li> ModSecurity 錯誤資訊，如在 <code>/var/log/modsec_audit.log</code> 日誌檔或 Plesk 日誌頁面(<strong>域名</strong> &gt; <strong>example.com</strong> &gt; <strong>Logs</strong>)：<pre>ModSecurity: 存取被拒，帶有 403 (2期). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web 應用程式防火牆啟用了非常嚴格的規則集，如OWASP、Comodo 或一個自定義規則集，如 Imunify360。限制性規則集可以阻止網站上的某些操作。</p><p><Strong>注意：</storon>ModSecurity錯誤可能表明對伺服器的攻擊。只有當您確定ModSecurity阻止了您的網站的有效使用時，才能使用以下解決方案。</p>',
    'problem-detail.modsec-access-denied.solution1.title' => '禁用通過ID或標記設定的 ModSecurity 規則',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>找到阻止合法使用您網站的規則的ID。您可以在<code>/var/log/modsec_audit.log</code> 日誌檔中找到錯誤消息中的 ID。ID是方括號中帶有首碼 <code>id</code> 的引號中的一個整數，例如，<strong>[id "210831"]</strong>。</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">禁用 Plesk 中的指定規則集</a>。</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => '切換到另一個ModSecurity規則集',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>切換到限制較少的ModSecurity規則集，例如，“Atomic ModSecurity規則集”。要實現此目的，請轉到<strong>工具與設定</strong> > <strong>Web 應用防火牆 (ModSecurity)</strong> > <strong>設定</strong>，選擇 <strong>Atomic Standard</strong>，然後點按 <strong>確定</strong>以應用更改。</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "內部伺服器錯誤 500: 允許的記憶體容量 XXX 已耗盡"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>問題</h4><ul><li><p>在Plesk中託管的網站不可存取：</p><pre>500 內部伺服器錯誤</pre></li><li><p>以下錯誤在網站日誌中顯示：</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/try.me/httpdocs/somethingBig.php on line 3</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>該網站沒有分配足夠的記憶體來進行處理。</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => '增加網站的 memory_limit',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">請參閱 KB 文章和以下說明</a>。</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir 限制有效"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>問題</h4><ul><li><p>如果web流覽器出現以下錯誤之一，則無法存取網站：</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>在域名的“日誌”頁面上，會出現以下錯誤消息(<strong>域名</strong> > <strong>example.com</strong> > <strong>日誌</strong>)：</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'PHP腳本正在嘗試存取不允許存取的目錄。此限制由每個域名的PHP<code>open_basedir</code> 指令單獨定義。默認情況下，<code>open_basedir</code>允許存取 <code>tmp</code> 和域名的文檔根目錄，以及系統的默認會話路徑。',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => '將其它路徑添加到 open_basedir 指令中',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">請參閱 KB 文章並按照說明執行</a>。</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => '禁用open_basedir指令',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>轉到 <strong>域名 &gt example.com &gt PHP 設定</strong> 頁面並設定<code>open_basedir</code> 指令為 "無"。</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403禁止AH01797：用戶端被伺服器配置拒絕"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>問題</h4><ul><li><p>該網站顯示了一個類似錯誤：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p><code>/var/www/vhosts/system/example.com/logs/error_log</code>日誌檔包含如下錯誤：</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>自訂Apache配置不允許存取網站。</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => '檢查伺服器配置和 .htaccess 文件',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">請參閱 KB 文章並按照說明執行</a>。</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache“無法存取Plesk中的網站目錄：403禁止”',
    'problem-detail.apache-no-directory-index.description' => '<h4>問題</h4><ul><li><p>無法存取一個網站的特定位置，例如，<code>http://example.com/some_folder</code>。發生以下錯誤：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>以下錯誤出現在 <code>/var/www/vhosts/example.com/logs/error_log<code/> 文件中：</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>所請求的目錄不包含索引檔，或者未啟用目錄流覽。</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => '添加索引檔到目錄',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">請參閱 KB 文章並按照說明執行</a>。</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => '啟用目錄流覽',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">請參閱 KB 文章並按照說明執行</a>。</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx“無法存取Plesk中的網站目錄：403禁止”',
    'problem-detail.nginx-no-directory-index.description' => '<h4>問題</h4><ul><li><p>無法存取一個網站的特定位置，例如，<code>http://example.com/some_folder</code>。發生以下錯誤：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>以下錯誤出現在 <code>/var/www/vhosts/example.com/logs/error_log file</code>中：</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>所請求的目錄不包含索引檔，或者未啟用目錄流覽。</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => '添加索引檔到目錄',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">請參閱 KB 文章並按照說明執行</a>。</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => '啟用目錄流覽',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">請參閱 KB 文章並按照說明執行</a>。</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "伺服器達到了 MaxRequestWorkers 設定"',
    'problem-detail.apache-reached-max-request-workers.description' => '快準備好了。',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP請求主體限制“用戶端計畫發送過大主體”',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '快準備好了。',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP請求主體限制“用戶端計畫發送過大主體”',
    'problem-detail.nginx-client-sent-too-large-body.description' => '快準備好了。',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP會話“503內部伺服器錯誤”或“讀取會話資料失敗”',
    'problem-detail.php-failed-to-read-session-data.description' => '快準備好了。',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: 無法檢查htaccess檔，以確保其可讀性”',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>問題</h4><ul><li><p>在Plesk中託管的一個網站不工作：</p><pre>您沒有存取此伺服器的許可權。<br> 此外，在嘗試使用 ErrorDocument 處理請求時，遇到了403禁止錯誤。</pre><p>您還可以看到空白頁，而不是上述錯誤。</p></li><li><p>在<strong>域名 &gt example.com &gt 日誌</strong>中的域名錯誤日誌包含以下：</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '域名的檔或資料夾的許可權不正確。',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => '網站內容的修復許可權',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">請參閱 KB 文章並按照說明執行</a>。</p></li></ol>',
];