<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Als uw site wordt gehost op een exclusief IP-adres (niet gedeeld met andere gebruikers of sites), dan kunt u een map binnen de site aanmaken waar andere gebruikers via FTP anoniem bestanden naartoe kunnen uploaden of uit kunnen downloaden. Als anonieme FTP eenmaal is ingeschakeld kunnen gebruikers zich bij de map aanmelden via een adres dat eruitziet als ftp://ftp.uw-domein.com, met als gebruikersnaam "anonymous" en een willekeurig wachtwoord.',
    'anonymous-ftp.displayLogin' => 'Toon bericht bij aanmelding',
    'anonymous-ftp.loginText' => 'Tekst van bericht',
    'anonymous-ftp.incomingDir' => 'Uploaden naar map \\incoming toestaan',
    'anonymous-ftp.incomingSubDir' => 'Aanmaken van mappen in de map \\incoming toestaan',
    'anonymous-ftp.incomingReadable' => 'Downloaden vanuit de map \\incoming toestaan',
    'anonymous-ftp.quota' => 'Beperk schijfruimte van de map \\incoming',
    'anonymous-ftp.maxConnections' => 'Beperk aantal gelijktijdige verbindingen',
    'anonymous-ftp.bandwidth' => 'Beperk bandbreedte voor downloads vanuit dit virtuele FTP-domein',
    'anonymous-ftp.unlimited' => 'Onbeperkt',

    'aps.catalog.loading' => 'Laden',
    'aps.catalog.searchName' => 'Toepassing',
    'aps.catalog.searchVendor' => 'Leverancier',
    'aps.catalog.searchPackager' => 'Pakket maken',
    'aps.catalog.searchLicenseType' => 'Licentietype',
    'aps.catalog.searchLicenseTypeAny' => 'Elk',
    'aps.catalog.searchLicenseTypeFreeware' => 'Vrij',
    'aps.catalog.searchLicenseTypeCommercial' => 'Commercieel',
    'aps.catalog.showSearch' => 'Toon zoekvenster',
    'aps.catalog.hideSearch' => 'Verberg Zoeken',
    'aps.catalog.buttonSearch' => 'Zoeken',
    'aps.catalog.buttonResetSearch' => 'Zoekveld Opnieuw Instellen',
    'aps.catalog.showCategories' => 'Selecteer een categorie hieronder of zoek via het zoekveld naar apps',
    'aps.catalog.searchResults' => 'Zoekresultaten',
    'aps.catalog.buttonInstall' => 'Installeren',
    'aps.catalog.buttonInstallTooltip' => 'Snel de meest recente versie van de app installeren met optimale standaard-parameters.',
    'aps.catalog.buttonAdvancedInstall' => 'Installeren (aangepast)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Installeer de meest recente versie van de app, waarbij u alle parameters aanpast.',
    'aps.catalog.buttonInstallOldVersion' => 'Versie installeren',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Installeer de geselecteerde versie van de app, waarbij u alle parameters aanpast.',
    'aps.catalog.buttonInstallDescription' => 'Installeer de app binnen een site als u al beschikt over een activeringscode, of als u de app wilt uitproberen.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Installeer deze gratis app op een site.',
    'aps.catalog.version' => 'Versie',
    'aps.catalog.moreVersions' => 'Meer versies',
    'aps.catalog.release' => 'Versie',
    'aps.catalog.overview' => 'Overzicht',
    'aps.catalog.noApplicationsInCategory' => 'Er zijn geen toepassingen beschikbaar in deze categorie. Selecteer een andere categorie.',
    'aps.catalog.noCategoriesSelected' => 'Selecteer een categorie om door alle toepassingen in deze categorie heen te bladeren.',
    'aps.catalog.noSearchResults' => 'Uw zoekopdracht heeft geen enkele toepassing opgeleverd.',
    'aps.catalog.connectionFailed' => 'Kan geen verbinding maken met App-catalogus. %%retryLink%%.',
    'aps.catalog.retry' => 'Nieuwe Poging',
    'aps.catalog.categoriesError' => 'Overzicht van categorieën die op dit moment niet kunnen worden geladen.',
    'aps.catalog.applicationsError' => 'Lijst met toepassingen die op het moment niet kunnen worden geladen.',
    'aps.catalog.detailsError' => 'De details van de toepassing kunnen op het moment niet worden geladen.',
    'aps.catalog.searchError' => 'Zoekresultaten kunnen momenteel niet worden geladen.',
    'aps.catalog.changelogEntry' => 'v%%version%% (%%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Overzicht van eerdere wijzigingen',
    'aps.catalog.officialApplicationSite' => 'Leveranciersgegevens',
    'aps.catalog.returnToCategories' => '<< Terug naar lijst met toepassingen',
    'aps.catalog.buttonUninstall' => 'Verwijderen',
    'aps.catalog.gotoHome' => 'Startpagina',
    'aps.catalog.all' => 'Alles',
    'aps.catalog.buttonDetails' => 'Meer weten?',
    'aps.catalog.buttonBuy' => 'Nu aanschaffen',
    'aps.catalog.buttonBuyTooltip' => 'De app aanschaffen',
    'aps.catalog.buttonBuyDescription' => 'Bezoek onze winkel om een activeringscode voor de app aan te schaffen.',
    'aps.catalog.buttonDownload' => 'Downloaden',
    'aps.catalog.buttonDownloadDescription' => 'Download de app als u al beschikt over een activeringscode, of als u deze alleen wilt uitproberen',
    'aps.catalog.marketplaceMoreInfo' => 'Zie %%link%% voor meer informatie.',
    'aps.catalog.marketplaceMoreInfoLink' => 'website van de leverancier van de app',

    'aps.configure.installedAt' => "Geïnstalleerd in",
    'aps.configure.otherSettings' => "Anders",
    'aps.configure.globalSettings' => 'Pakketinstellingen',
    'aps.configure.passwordConfirmation' => 'Bevestig wachtwoord',
    'aps.configure.databaseParams' => 'Databaseparameters',
    'aps.configure.noInstallationUrlAvailable' => 'Geen (externe toepassing)',
    'aps.configure.updateSettingsSection' => 'Instellingen bijwerken',
    'aps.configure.forceUpdates' => 'Deze app automatisch bijwerken als er updates beschikbaar zijn',
    'aps.configure.forceUpdatesHint' => 'De app zal automatisch updates naar nieuwe versies ontvangen. Waarschuwing: Wees voorzichtig met het gebruik van deze optie, omdat updates van grote invloed kunnen zijn op de functionaliteit van de app. Het kan bijvoorbeeld mogelijk zijn dat uitbreidingen van de app niet meer werken in een andere versie van de app.',

    'aps.install.showAllSettings' => 'Alle instellingen weergeven',
    'aps.install.showLessSettings' => 'Minimale instellingen weergeven',
    'aps.install.install' => 'Installeren',
    'aps.install.otherSettings' => 'Overige instellingen',
    'aps.install.globalSettings' => 'Pakketinstellingen',
    'aps.install.passwordConfirmation' => 'Bevestig wachtwoord',
    'aps.install.provisionsSectionLabel' => 'Zoekpad van installatie',
    'aps.install.context' => 'Geef de locatie op waar deze webtoepassing moet worden geïnstalleerd',
    'aps.install.registerAsWebmailSection' => 'Webmail-aanmelding',
    'aps.install.registerAsWebmailDescription' => "Selecteer deze optie als de app een webmailprogramma is. Daarmee zal de app worden opgenomen in de lijst met beschikbare webmaildiensten in de mail-instellingen van abonnementen en dienstenpakketten. De beheerder kan de URL voor algemene toegang tot webmail instellen onder Serverbeheer > Instellingen > Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Aanmelden als webmaildienst',
    'aps.install.addItem' => 'Toevoegen',
    'aps.install.removeItem' => 'Verwijderen',
    'aps.install.updateSettingsSection' => 'Instellingen bijwerken',
    'aps.install.forceUpdates' => 'Deze app automatisch bijwerken als er updates beschikbaar zijn',
    'aps.install.forceUpdatesHint' => 'De app zal automatisch updates naar nieuwe versies ontvangen. Waarschuwing: Wees voorzichtig met het gebruik van deze optie, omdat updates van grote invloed kunnen zijn op de functionaliteit van de app. Het kan bijvoorbeeld mogelijk zijn dat uitbreidingen van de app niet meer werken in een andere versie van de app.',

    'aps.invalid-requirements.requirementsLegend' => 'Vereisten',
    'aps.invalid-requirements.domainLegend' => 'Website',
    'aps.invalid-requirements.context' => 'Een andere website kiezen',
    'aps.invalid-requirements.backToApplicationList' => 'Terug naar de lijst met toepassingen',

    'aps.license.title' => 'Installatie van %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Om deze toepassing te kunnen installeren, moet u de licentieovereenkomst voor eindgebruikers lezen en akkoord gaan met de voorwaarden.',
    'aps.license.licenseAgree' => 'Ik ga akkoord met de voorwaarden van deze licentieovereenkomst',

    'aps.services-list-customization.settings' => 'Instellingen',

    'asp-dot-net.change-version.frameworkVersion' => 'De versie van het ASP.NET-framework',

    'asp-dot-net.settings.casSettingsSection' => "Toegangsbeveiliging door middel van code",
    'asp-dot-net.settings.clientScriptsSection' => "Instellingen Programmabibliotheek",
    'asp-dot-net.settings.connStringsSection' => "Beheer verbindingsstring",
    'asp-dot-net.settings.customErrorsSection' => "Aangepaste foutmeldingsinstellingen",
    'asp-dot-net.settings.frameworkVersionSection' => "Frameworkversie",
    'asp-dot-net.settings.globalizationSection' => "Globaliseringsinstellingen",
    'asp-dot-net.settings.otherSection' => "Sessie-instellingen",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Complicatie en foutopsporing",
    'asp-dot-net.settings.authMode' => "Verificatiemodus",
    'asp-dot-net.settings.connStrings' => "Verbindingsstrings",
    'asp-dot-net.settings.connStringsInvalid' => "Sommige velden zijn leeg of hebben een onjuiste waarde.",
    'asp-dot-net.settings.connStringName' => "Naam",
    'asp-dot-net.settings.connStringValue' => "Verbindingsparameters",
    'asp-dot-net.settings.culture' => "Cultuur",
    'asp-dot-net.settings.customErrMode' => "Aangepaste foutmeldingsmodus",
    'asp-dot-net.settings.customErrorRedirect' => "URL omleiden",
    'asp-dot-net.settings.customErrorStatus' => "Statuscode",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Statuscode moet een geheel getal zijn.",
    'asp-dot-net.settings.customErrors' => "Aangepaste foutmeldingen",
    'asp-dot-net.settings.customErrorsInvalid' => "Sommige velden zijn leeg of hebben een onjuiste waarde.",
    'asp-dot-net.settings.debugMode' => "Foutopsporing inschakelen",
    'asp-dot-net.settings.defLanguage' => "Standaardtaal voor webpagina's",
    'asp-dot-net.settings.tempDirectory' => "Tijdelijke map",
    'asp-dot-net.settings.fileEnc' => "Karakterset van bestand",
    'asp-dot-net.settings.fileEncInvalid' => "De opgegeven waarde van de parameter Karakterset van bestand is ongeldig.",
    'asp-dot-net.settings.pathToLib' => "Zoekpad naar Microsoft-programmabibliotheek",
    'asp-dot-net.settings.pathToLibInstall' => "Installeren",
    'asp-dot-net.settings.reqEnc' => "Karakterset van aanvraag",
    'asp-dot-net.settings.reqEncInvalid' => "De opgegeven waarde van de parameter Karakterset van aanvraag is ongeldig.",
    'asp-dot-net.settings.resEnc' => "Karakterset van antwoord",
    'asp-dot-net.settings.resEncInvalid' => "De opgegeven waarde van de parameter Karakterset van antwoord is ongeldig.",
    'asp-dot-net.settings.sessTimeout' => "Sessie-timeout (minuten)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "De opgegeven waarde van de parameter Sessie time-out is ongeldig. Geef een positief geheel getal op dat kleiner of gelijk is aan %%max%%.",
    'asp-dot-net.settings.trustLevel' => "CAS-vertrouwensniveau",
    'asp-dot-net.settings.uiCulture' => "UI-cultuur",
    'asp-dot-net.settings.version' => "Versie",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Negeren van het CAS-vertrouwensniveau op website toestaan',
    'asp-dot-net.settings.addConnStrings' => 'Verbindingsstring toevoegen',
    'asp-dot-net.settings.addCustomErrors' => 'Aangepaste foutmelding toevoegen',
    'asp-dot-net.settings.buttonRemove' => 'Verwijderen',

    'database.clone.formDescription' => 'Kopieer de inhoud van de database in een nieuwe of bestaande database. Bij het kopiëren naar een bestaande database worden tabellen van de brondatabase toegevoegd aan de lijst met tabellen van de database van bestemming. Waarschuwing: als de namen van bepaalde tabellen samenvallen, dan zal de tabel van de brondatabase die van de database van bestemming vervangen.',
    'database.clone.copyData' => 'Een volledige kopie maken',
    'database.clone.copyDataHint' => 'Als deze optie is geselecteerd, dan zal de gehele database, inclusief de data, worden gekopieerd. Als deze optie niet is geselecteerd, dan zal alleen de tabelstructuur worden gekopieerd.',
    'database.clone.server' => 'Database-server van bestemming',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Overig...',
    'database.clone.database' => 'Database van bestemming',
    'database.clone.newDatabase' => 'Database aanmaken met naam',
    'database.clone.existingDatabase' => 'Kopiëren naar bestaande database',
    'database.clone.externalDbHost' => 'Hostnaam of IP-adres',
    'database.clone.externalDbLogin' => 'Gebruikersnaam',
    'database.clone.externalDbPassword' => 'Wachtwoord',
    'database.clone.subscription' => 'Abonnement van bestemming',
    'database.clone.subscription_powerUser' => 'Webruimte van bestemming',
    'database.clone.cloneInProgress' => 'Database %%source%% wordt gekloond naar database %%destination%%. U wordt van de voortgang op de hoogte gehouden via e-mail (%%email%%).',
    'database.clone.unableToClone' => 'Kan de database %%source%%" niet kopiëren.',
    'database.clone.unableToCreateExternalDatabase' => 'Kan geen database "%%destination%%" aanmaken op de opgegeven server.',
    'database.clone.databaseCloned' => 'De database "%%source%%" is gekopieerd.',
    'database.clone.emailSubjSuccess' => 'Database "%%sourceDatabase%%" is gekopieerd.',
    'database.clone.emailSubjFailure' => 'Kopiëren van database "%%sourceDatabase%%" is mislukt.',
    'database.clone.emailBodySuccess' => 'De database "%%sourceDatabase%%" (%%sourceHost%%) is gekopieerd naar database "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Kan database "%%sourceDatabase%%" (%%sourceHost%%) niet kopiëren naar de database "%%destDatabase%%" (%%destHost%%). Het kopiëren is mislukt.',
    'database.clone.localServer' => 'lokale server',

    'database.repair-orphaned.formDescription' => 'Deze gebruiker is ontkoppeld geraakt na het herstelproces. Geef een wachtwoord voor deze gebruiker op om het probleem op te lossen. Als deze gebruiker een sys-gebruiker zonder wachtwoord moet zijn, voer dan het hulpprogramma voor herstel uit, waarbij u het wachtwoordveld leeg laat.',
    'database.repair-orphaned.login' => 'Databasegebruikersnaam',
    'database.repair-orphaned.pass' => 'Wachtwoord',
    'database.repair-orphaned.pass2' => 'Bevestig wachtwoord',
    'database.repair-orphaned.users' => 'Een aantal gebruikers heeft uw aandacht nodig. Er zijn verschillende ontkoppelde gebruikers die moeten worden gerepareerd om ze op de juiste manier te laten functioneren.',
    'database.repair-orphaned.orphaned' => 'Gebruiker is ontkoppeld. %%gui begin:link%%Nu herstellen%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Herstellen',

    'database.repair.fixSelected' => 'Selectie herstellen',
    'database.repair.fix' => 'Herstellen',

    'database.user.password' => 'Wachtwoord',
    'database.user.passwordConfirmation' => 'Wachtwoord bevestigen',
    'database.user.server' => 'Database-server',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Database',
    'database.user.anyDatabase' => 'Elk',
    'database.user.dataAccess' => 'Toegang tot gegevens',
    'database.user.structureAccess' => 'Toegang tot structuur',
    'database.user.globalAccess' => 'Algemene rechten',
    'database.user.globalAccessHint' => 'Algemene rechten zijn van toepassing op alle databases binnen dit hostingaccount.',
    'database.user.aclRadio' => 'Toegangsbeheer',
    'database.user.aclLocalhost' => 'Alleen lokale verbindingen toestaan',
    'database.user.aclAny' => 'Externe verbindingen toestaan vanaf elke host',
    'database.user.aclCustom' => 'Externe verbindingen toestaan vanaf',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDe opgegeven hosts hebben toegang tot de database namens deze gebruiker.",
    'database.user.remoteAccess' => 'Externe toegang',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDe opgegeven IP-adressen hebben toegang tot de database namens deze gebruiker. Uw wijzigingen in de lijst zullen vooraf worden gemodereerd door uw provider.",
    'database.user.example' => "Bijvoorbeeld:\n%%example%%",
    'database.user.denied' => 'Gebruik de regels van de firewall voor het systeem',
    'database.user.allowed' => 'Externe verbindingen toestaan vanaf',
    'database.user.default' => 'Gebruik standaard de inloggegevens van deze gebruiker voor toegang tot %%webadmin%%',
    'database.user.remoteAccessHint' => 'Neem contact op met uw provider en zorg ervoor dat de optie die u hierboven hebt aangegeven voldoet aan de huidige firewall-regels voor inkomende toegang tot MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.myLittleAdmin' => 'myLittleAdmin',
    'database.user.webAdmin' => 'Web Admin',
    'database.user.role' => 'Rol',
    'database.user.roleReadWrite' => 'Lezen en schrijven',
    'database.user.roleWriteOnly' => 'Alleen schrijven',
    'database.user.roleReadOnly' => 'Alleen lezen',
    'database.user.roleCustom' => 'Aangepast',

    'database.generalSection' => 'Algemeen',
    'database.name' => 'Databasenaam',
    'database.server' => 'Database-server',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Gerelateerde site',
    'database.noDomainRelations' => 'Geen gerelateerde sites',
    'database.userSection' => 'Gebruikers',
    'database.userSectionDescription' => 'Een standaard databasegebruiker aanmaken. Plesk zal namens deze gebruiker verbinding met de database maken. Als er geen databasegebruikers aan de database zijn toegewezen is deze niet bereikbaar.',
    'database.createUser' => 'Een Databasegebruiker aanmaken',
    'database.username' => 'Gebruikersnaam database',
    'database.password' => 'Wachtwoord',
    'database.passwordConfirmation' => 'Bevestig wachtwoord',
    'database.allDbAccess' => 'Gebruiker heeft toegang tot alle databases binnen het geselecteerde abonnement',
    'database.aclRadio' => 'Toegangsbeheer',
    'database.aclLocalhost' => 'Alleen lokale verbindingen toestaan',
    'database.aclAny' => 'Externe verbindingen toestaan vanaf elke host',
    'database.aclCustom' => 'Externe verbindingen toestaan vanaf',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDe opgegeven hosts hebben toegang tot de database namens deze gebruiker.",
    'database.remoteAccess' => 'Externe toegang',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDe opgegeven IP-adressen hebben toegang tot de database namens deze gebruiker. Uw wijzigingen in de lijst zullen vooraf worden gemodereerd door uw provider.",
    'database.example' => "Bijvoorbeeld:\n%%example%%",
    'database.denied' => 'Gebruik de regels van de firewall voor het systeem',
    'database.allowed' => 'Externe verbindingen toestaan vanaf',

    'deployment-section.deploymentDisabledHint' => 'Bestanden uploaden vanuit een Git-repository',
    'deployment-section.deploymentEnabledHint' => 'Ondersteuning voor Git inschakelen',
    'deployment-section.deploymentSectionLegend' => 'Uw bestanden om naar hosting te kopiëren',
    'deployment-section.deploymentSectionDescriptionHint' => 'Als u ondersteuning voor Git uitgeschakeld laat zullen de hoofdmappen (website/toepassingsmap en documentmap) leeg worden aangemaakt en zal de site in de browser de standaardpagina laten zien. U moet de bestanden van uw site uploaden naar de documentmap via FTP of Bestandsbeheer. U kunt in plaats daarvan ook nu of later Git inschakelen (onder Websites & domeinen) en de bestanden uploaden vanuit een Git-repository.',

    'dns-zone.add-acl-record.description' => 'IP-adres toevoegen van een DNS-server die een kopie van deze DNS-zone mag ontvangen.',
    'dns-zone.add-acl-record.ipAddress' => 'IP-adres',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP-adres/masker',

    'dns-zone.record.add-title' => "DNS-record toevoegen aan het zonesjabloon",
    'dns-zone.record.add-ns-title' => "Naamserver toevoegen",
    'dns-zone.record.edit-title' => "DNS-record bewerken",
    'dns-zone.record.type' => "Type record",
    'dns-zone.record.domainName' => "Domeinnaam",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Naamserver",
    'dns-zone.record.protocol' => "Protocol",
    'dns-zone.record.priority' => "Prioriteit",
    'dns-zone.record.priorityLow' => "laag (%%priority%%)",
    'dns-zone.record.priorityHigh' => "zeer hoog (%%priority%%)",
    'dns-zone.record.weightLow' => "laag (%%weight%%)",
    'dns-zone.record.weightHigh' => "zeer hoog (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP-adres",
    'dns-zone.record.ipAddressDescription' => "Bijvoorbeeld 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "For example, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6-adres",
    'dns-zone.record.ipAddressV6Description' => "Bijvoorbeeld 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "For example, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Bijvoorbeeld 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "For example, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Bijvoorbeeld 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Canonieke naam",
    'dns-zone.record.mailDomain' => "Maildomein",
    'dns-zone.record.mxServer' => "Server voor mailexchange",
    'dns-zone.record.mxServerPriority' => "Geef prioriteit op van mail exchange server",
    'dns-zone.record.txtRecord' => "TXT-record",
    'dns-zone.record.txtRecordString' => "Voer recordstring in",
    'dns-zone.record.txtSpfSyntax' => "SPF-record",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Er zijn onjuiste waarden voor het TXT-record opgegeven.",
    'dns-zone.record.dsRecord' => "DS-record",
    'dns-zone.record.dsRecordDescription' => "Bijvoorbeeld 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Er is een onjuiste waarde voor het DS-record opgegeven.",
    'dns-zone.record.serviceName' => "Dienstnaam",
    'dns-zone.record.serviceNameDescription' => "Voorbeeld: SIP (zonder onderstrepingsteken)",
    'dns-zone.record.protocolNameDescription' => "Voorbeeld: TCP (zonder onderstrepingsteken)",
    'dns-zone.record.srvWeight' => "Relatief gewicht voor records met dezelfde prioriteit",
    'dns-zone.record.targetHost' => "Doelhost",
    'dns-zone.record.targetHostDescription' => "Bijvoorbeeld: example.com",
    'dns-zone.record.targetPort' => "Doelpoort",
    'dns-zone.record.retrieveDataError' => "De gegevens van het record zijn niet gevonden.",
    'dns-zone.record.unknownTypeError' => "Onbekend type DNS-record.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Kan het NULL MX-record niet instellen wanneer er andere MX-records aanwezig zijn.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Kan het niet-NULL MX-record niet instellen wanneer er het NULL MX-record aanwezig is.',
    'dns-zone.record.masterShouldBeRemote' => "U moet beschikken over twee verschillende autoritatieve naamservers op afzonderlijke hosts.",
    'dns-zone.record.caaTag' => "Tag",
    'dns-zone.record.caaRecord' => "Waarde",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Seconden",
    'dns-zone.record.invalidValue' => 'Waarde is ongeldig: deze moet liggen tussen de 1 en 2147483647 seconden.',
    'dns-zone.record.ttlDefaultValue' => 'Standaardwaarde: %%value%% seconden',

    'dns-zone.restore-default.formHint' => "Hier kunt u de originele configuratie van de zone herstellen, in overeenstemming met de instellingen van het standaard DNS-sjabloon dat op de server wordt gebruikt. Selecteer de IP-adressen die moeten worden gebruikt voor het herstellen van de zone en geef aan of er een www-alias nodig is voor het domein.",
    'dns-zone.restore-default.ipv4' => "IPv4-adres",
    'dns-zone.restore-default.ipv4Hint' => "Bijvoorbeeld 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6-adres",
    'dns-zone.restore-default.ipv6Hint' => "Bijvoorbeeld 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'De opgegeven IP-adres is ongeldig.',
    'dns-zone.restore-default.customIpHint' => "Records met dit IP-adres worden beschouwd als aangepast door de gebruiker en zullen niet worden gesynchroniseerd met het algemene DNS-sjabloon van de server.",
    'dns-zone.restore-default.wwwPrefix' => "WWW-voorvoegsel",
    'dns-zone.restore-default.previewRecords' => "De records die worden gebruikt voor de voorbeeldweergave van de site herstellen",

    'dns-zone.soa-record.soaMnameSection' => 'Primaire naamserver',
    'dns-zone.soa-record.soaMname' => 'Naam server',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Automatische selectie)',
    'dns-zone.soa-record.soaRecordSection' => 'SOA-record',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Vernieuwen',
    'dns-zone.soa-record.retry' => 'Nieuwe Poging',
    'dns-zone.soa-record.expire' => 'Verlopen',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E-mail (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'Het e-mailadres van degene die verantwoordelijk is voor de DNS-zone van het domein. Teruggegeven door de DNS-server als antwoord op SOA-aanvragen.',
    'dns-zone.soa-record.rnameTypeOwner' => 'E-mailadres van de houder van de website',
    'dns-zone.soa-record.rnameTypeDomain' => 'E-mailadres domein',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Geef alleen de local-part op (het stukje voor @<domein>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Extern e-mailadres',
    'dns-zone.soa-record.invalidValue' => 'Waarde is ongeldig. Deze moet liggen tussen de 1 seconde en 68 jaar.',
    'dns-zone.soa-record.advancedSection' => 'Geavanceerde DNS-functies',
    'dns-zone.soa-record.serialNumberFormat' => 'De serienummer-notatie gebruiken die wordt aanbevolen door IETF en RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Selecteer deze optie wanneer uw domein problemen heeft om de SOA-controle van de registrar door te komen. Veel bedrijven die domeinregistraties verzorgen vereisen deze notatie voor serienummers.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Standaardinstellingen gebruiken',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Standaardwaarden van zone',
    'dns-zone.soa-record.unitSeconds' => 'seconden',
    'dns-zone.soa-record.unitMinutes' => 'minuten',
    'dns-zone.soa-record.unitHours' => 'uren',
    'dns-zone.soa-record.unitDays' => 'dagen',
    'dns-zone.soa-record.unitWeeks' => 'weken',

    'domain-info-section.domainName' => 'Domeinnaam',
    'domain-info-section.emptyDomainName' => 'Geef een domeinnaam op.',
    'domain-info-section.ipAddress' => 'IP-adres',
    'domain-info-section.shared' => 'gedeeld',
    'domain-info-section.exclusive' => 'exclusief',
    'domain-info-section.ipAddressHint' => "Het IP-adres waarop de website wordt gehost is een netwerkadres van de virtuele host van de website. Dit IP-adres zal voor alle websites worden gebruikt, die voor dit abonnement werden gemaakt",
    'domain-info-section.ipAddressHint_powerUser' => "IP-adres waarop de website wordt gehost is een netwerkadres van de virtuele host. Dit IP-adres zal worden gebruikt voor alle websites die binnen de webruimte worden aangemaakt.",
    'domain-info-section.userName' => 'Gebruikersnaam',
    'domain-info-section.userNameHint' => 'Systeemgebruikeraccount gekoppeld aan de webruimte, gebruikt voor het verkrijgen van toegang tot de gehoste bestanden via FTP en SSH.',
    'domain-info-section.emptyLogin' => 'Geef een gebruikersnaam op.',
    'domain-info-section.password' => 'Wachtwoord',
    'domain-info-section.emptyPassword' => 'Geef een wachtwoord op.',
    'domain-info-section.passwordConfirmation' => 'Wachtwoord herhalen',

    'email-address.generalTab' => 'Algemeen',
    'email-address.generalHint' => 'Als dit e-mailaccount is gekoppeld aan een aanvullende gebruiker (toegang tot Hostingbeheer is ingeschakeld), dan zijn de wijzigingen die u op deze pagina maakt van invloed op de instellingen van deze gebruiker. Let er vooral op dat als u het e-mailadres en wachtwoord wijzigt, de gebruikersnaam en het wachtwoord van de aanvullende gebruiker ook zullen worden ingesteld op deze nieuwe waarden.',
    'email-address.redirectTab' => 'Doorsturen',
    'email-address.redirectHint' => 'Het doorsturen van e-mailberichten naar een of meer e-mailadressen instellen.',
    'email-address.aliasesTab' => 'E-mailaliassen',
    'email-address.autoResponderTab' => 'Automatische Beantwoording',
    'email-address.antispamTab' => 'Spamfilter',
    'email-address.autoResponderHint' => 'Stel een automatische beantwoording in voor elk bericht dat bij uw e-mailadres binnenkomt. Automatische beantwoording is een standaard mogelijkheid om de personen die met u corresponderen mee te delen dat u niet op kantoor of met vakantie bent.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'E-mailadres',
    'email-address.externalEmail' => 'Extern e-mailadres',
    'email-address.externalEmailHint' => 'Wordt gebruikt om uw wachtwoord opnieuw in te stellen in het geval u ooit geen toegang meer heeft tot uw primaire e-mailadres.',
    'email-address.user' => 'Toegewezen aan',
    'email-address.password' => 'Wachtwoord',
    'email-address.passwordConfirmation' => 'Bevestig wachtwoord',
    'email-address.responderEnable' => 'Automatische beantwoording activeren',
    'email-address.responderSubject' => 'Onderwerpregel van Automatische Beantwoording',
    'email-address.responderContentType' => 'Berichtformaat',
    'email-address.responderContentTypeHint' => 'Het platte tekstformaat wordt door alle clientprogramma\'s ondersteund, alle ontvangers zien het bericht op dezelfde manier zoals u het bericht ziet. HTML-berichten hebben een betere weergave, omdat hierdoor het invoeren van geformatteerde tekst in verschillende lettertypes mogelijk is. Een aantal mailclients ondersteunen echter geen HTML-berichten en sommige ontvangers kunnen de geformatteerde tekst niet zien.',
    'email-address.responderContentTypeTextPlain' => 'Platte tekst',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Codering',
    'email-address.responderCodepageHint' => 'De codering is bepalend voor de manier waarop de tekens in de tekst worden weergegeven. De aanbevolen codering is UTF-8.',
    'email-address.responderReplyTo' => 'Doorsturen naar',
    'email-address.responderReplyToHint' => 'Als de functie Automatische beantwoording is ingesteld, zal het originele bericht naar het opgegeven e-mailadres worden doorgestuurd.',
    'email-address.responderForwardAddress' => 'Doorsturen naar',
    'email-address.responderForwardAddressHint' => 'Als de functie Automatische beantwoording is ingesteld, zal het originele bericht naar het opgegeven e-mailadres worden doorgestuurd.',
    'email-address.responderMessage' => 'Berichttekst van Automatische Beantwoording',
    'email-address.responderReplyToEqualsEmail' => 'Het opgegeven doorstuuradres is identiek aan het e-mailadres.',
    'email-address.responderForwardAddressEqualsEmail' => 'Het opgegeven doorstuuradres is identiek aan het e-mailadres.',
    'email-address.responderReplyLimit' => 'Stuur automatische antwoorden aan een uniek e-mailadres niet vaker dan (maal per dag)',
    'email-address.buttonAddResponderAttachment' => 'Een bijlage toevoegen',
    'email-address.buttonRemoveResponderAttachment' => 'Verwijderen',
    'email-address.responderAttachment' => 'Een bestand bijvoegen',
    'email-address.redirectEnable' => 'Het doorsturen van e-mailberichten activeren',
    'email-address.redirectRemoveEnable' => 'Geen kopieën van doorgestuurde e-mails afleveren in het postvak van Plesk',
    'email-address.redirectAddress' => 'Inkomende berichten naar het volgende e-mailadres doorsturen',
    'email-address.redirectAddressHint' => 'Voer de e-mailadressen in. U kunt elk adres op een nieuwe regel invoeren, of de adressen d.m.v. spaties, komma\'s of puntkomma\'s scheiden.',
    'email-address.role' => 'Gebruikersrol',
    'email-address.roleHint' => 'Gebruikersrollen geven gebruikers administratieve privileges en toegang tot de toepassingen die u voor de rol hebt geselecteerd.',
    'email-address.errorRedirectAddress' => 'U hebt een ongeldig e-mailadres opgegeven: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'U hebt ongeldige e-mailadressen opgegeven: %value%.',
    'email-address.mailAlias' => "E-mailalias",
    'email-address.mailAliasNone' => 'Geen',
    'email-address.mailAliasHint' => "E-mailaliassen zijn alternatieve e-mailadressen die zijn gekoppeld aan een primair e-mailadres. Alle mails die naar een e-mailalias worden verstuurd zullen worden ontvangen door het primaire e-mailadres.",
    'email-address.buttonAddMailAlias' => 'Mailalias toevoegen',
    'email-address.buttonRemoveMailAlias' => 'Verwijderen',
    'email-address.emptyEmail' => 'Voer een e-mailadres in waarnaar alle inkomende berichten doorgestuurd moeten worden.',
    'email-address.emailsIsEqual' => 'Het externe e-mailadres komt overeen met het primaire e-mailadres. Geef een ander extern e-mailadres op.',
    'email-address.emptyPassword' => 'U moet een wachtwoord opgeven.',
    'email-address.emptyPasswordConfirmation' => 'U moet het wachtwoord bevestigen.',
    'email-address.emptyAlias' => "Voer een e-mailalias voor dit e-mailadres in.",
    'email-address.aliasEqualsEmail' => 'De opgegeven e-mailalias is dezelfde als het e-mailadres.',
    'email-address.passwordHint' => 'Wordt gebruikt voor toegang tot het postvak en om u bij Plesk aan te melden (mits deze optie is ingeschakeld).',
    'email-address.cyclicRedirect' => 'E-mailadres kan niet worden ingesteld om e-mailberichten naar zichzelf door te sturen.',
    'email-address.errorMailnameReserved' => 'Opgegeven e-mailadres is al in gebruik.',
    'email-address.antivirusEnable' => 'Antivirusbescherming inschakelen voor het e-mailadres',
    'email-address.antivirusHint' => 'Antivirus blokkeert e-mails die virussen bevatten en stelt zowel de verzender als de ontvanger hiervan op de hoogte.',
    'email-address.antivirusSettings' => 'Antivirusinstellingen',
    'email-address.antivirusSettingOnlyIncomingMail' => 'alleen inkomende mail',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'alleen uitgaande mail',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'inkomende en uitgaande mail',
    'email-address.antispamHint' => 'Spamfilterdiensten detecteren spamberichten die naar het e-mailadres worden verzonden. U kunt het spamfilter instellen om spamberichten te verwijderen, het als spambericht markeren door het onderwerp te wijzigen, of de berichten naar de speciale map Spam, die via mailclients en IMAP toegankelijk is, te verplaatsen. Het spamfilter gebruikt een breed scala van lokale - en netwerktesten om de spamhandtekeningen te identificeren.',
    'email-address.antispamEnable' => 'Antispambescherming inschakelen voor het e-mailadres',
    'email-address.antispamSettings' => 'Wat er moet gebeuren met berichten die als spam zijn gemarkeerd',
    'email-address.antispamSettingsMark' => 'Spam markeren door de volgende tekst aan het onderwerp van de e-mails toe te voegen',
    'email-address.antispamSettingsMarkHint' => 'Laat dit veld leeg als u geen tekst wilt toevoegen. Type _SCORE_ als u de score aan de onderwerpregel van het bericht wilt toevoegen.',
    'email-address.antispamReportTextHint' => 'Voer de tekst in die u aan de berichtinhoud van het spam-emailbericht wilt toevoegen.',
    'email-address.antispamSettingsDelete' => 'Verwijder alle spamberichten',
    'email-address.antispamSettingsDeleteHint' => 'U zult geen spam ontvangen omdat deze zal worden verwijderd voor het bereiken van uw postvak.',
    'email-address.antispamSettingsMove' => 'Spam naar spammap verplaatsen',
    'email-address.antispamSettingsMoveHint' => 'Verplaats alle spamberichten naar de map met de naam Spam. U hebt via het programma van uw mailclient of webmail toegang tot deze map. Als u een IMAP-mailaccount hebt, kunt u de map Spam gebruiken om het spamfilter te trainen.',
    'email-address.antispamSettingsMoveWarning' => '"Spam naar spammap verplaatsen" werkt niet, tenzij u de optie "Geen kopieën van doorgestuurde e-mails afleveren in het postvak van Plesk" uitschakelt op het tabblad "Doorsturen".',
    'email-address.antispamSettingsMoveJunk' => 'Verplaats spam naar de map "Junk E-mail"',
    'email-address.antispamSettingsMoveJunkHint' => 'Verplaats alle spamberichten naar de map met de naam "Junk E-mail".U hebt via het programma van uw mailclient of webmail toegang tot deze map. Als u gebruik maakt van een IMAP-mailaccount, dan kunt u de map "Junk E-mail" gebruiken voor het trainen van het spamfilter.',
    'email-address.antispamShowAdvancedSection' => 'Geavanceerde bewerkingen tonen',
    'email-address.antispamHideAdvancedSection' => 'Geavanceerde bewerkingen verbergen',
    'email-address.antispamLearnMore' => 'Leer hoe u uw spamfilter handmatig kunt trainen',
    'email-address.antispamFilterScoreTitle' => 'Gevoeligheid van filter',
    'email-address.antispamFilterScoreHint' => 'Het spamfilter voert een aantal verschillende tests uit t.a.v. de content en onderwerpregel van elk bericht. Als gevolg hiervan, wordt aan elk bericht een aantal punten toegekend. Hoe hoger het aantal punten, hoe waarschijnlijker het is dat een bericht spam is. Standaard is de gevoeligheid van het filter zo ingesteld dat alle berichten die 7 of meer punten krijgen, als spam worden gekenmerkt. Als u met de huidige instelling veel spamberichten ontvangt, kunt u het filter gevoeliger instellen door een lagere waarde, bijvoorbeeld 6, in te stellen. Als u e-mailberichten niet ontvangt omdat uw spamfilter denkt dat het ongewenste berichten zijn, kunt u de gevoeligheid van het filter op een hogere waarde, bijvoorbeeld 8, instellen.',
    'email-address.antispamFilterScore' => 'Gevoeligheid spamfilter',
    'email-address.antispamWhiteListTitle' => 'Witte lijst',
    'email-address.antispamWhiteListHint' => 'E-mails van afzenders op de witte lijst worden niet door het spamfilter gecontroleerd.',
    'email-address.antispamWhiteListField' => 'Witte lijst',
    'email-address.antispamWhiteListFieldHint' => 'Voer de domeinnamen in, een domeinnaam per regel. Adressen kunnen "*" en "?" (zgn. zoektekens) bevatten, bijvoorbeeld *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Zwarte lijst',
    'email-address.antispamBlackListHint' => 'E-mails van afzenders op de zwarte lijst worden gekenmerkt als spam.',
    'email-address.antispamBlackListField' => 'Zwarte lijst',
    'email-address.antispamBlackListFieldHint' => 'Voer de domeinnamen in, een domein per regel. Adressen kunnen "*" en "?" (zgn. zoektekens) bevatten, bijvoorbeeld *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Vertrouwde talen',
    'email-address.antispamTrustedLanguagesHint' => 'E-mailberichten in deze talen zullen altijd door het filter worden gehaald.',
    'email-address.antispamTrustedLocalesTitle' => 'Vertrouwde regio\'s',
    'email-address.antispamTrustedLocalesHint' => 'E-mailberichten die de opgegeven lokale groepen gebruiken, zullen te allen tijde het spamfilter passeren. Lokale groepen omvatten de meest gebruikte tekensets. Bijvoorbeeld westerse tekensets maken gebruik van letters die in het Engels en in West-Europese talen worden gebruikt.',
    'email-address.antispamTrustedNetworksTitle' => 'Vertrouwde netwerken',
    'email-address.antispamTrustedNetworksHint' => 'Het wordt aangenomen dat de relay hosts op vertrouwde netwerken in principe niet door spam worden bewerkt, bovendien zijn het geen open relays of open proxies.',
    'email-address.antispamIpAddressesField' => 'IP-adressen',
    'email-address.antispamIpAddressesFieldHint' => 'IP-adres en masker van netwerk opgeven.',
    'email-address.mailBoxQuotaDomainDefault' => 'Standaard grootte (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Standaard',
    'email-address.mailBoxOutgoingMessages' => 'Het maximaal aantal uitgaande e-mailberichten',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Standaard (%%domainOutgoingMessages%% berichten per uur)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Aangepaste waarde voor het postvak',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'berichten',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Standaard',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Standaard',
    'email-address.mailBoxQuotaDomainSpecific' => 'Andere grootte',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Omvang van postvak',
    'email-address.mailBoxQuotaUnlimited' => 'Onbeperkt',
    'email-address.mailBoxLimitReached' => 'De beperking van het aantal postvakken is bereikt.',
    'email-address.postboxEnabled' => 'Postvak',
    'email-address.postboxEnabledYes' => 'Aan',
    'email-address.postboxEnabledNo' => 'Uit',
    'email-address.description' => 'Omschrijving in Plesk',
    'email-address.descriptionHint' => 'De omschrijving is zichtbaar voor iedereen met toegang tot dit e-mailaccount.',
    'email-address.longDescription' => 'De opgegeven omschrijving is te lang. Het mag niet langer zijn dan %%max%% karakters.',
    'email-address.loginAsUser' => 'Kan worden gebruikt om u bij Plesk aan te melden',
    'email-address.loginAsUserDescription' => '(gebruikersnaam: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'De omvang van het postvak kan niet groter zijn dan de standaardomvang.',
    'email-address.endDateEnable' => 'Automatische beantwoording uitschakelen',

    'failed-request.enable-tracing.description' => 'Het traceren van mislukte aanvragen vormt een zware belasting van het systeem. Het traceren zal automatisch worden gestopt over %%days%% dagen. Op elk moment kunt u het handmatig uitschakelen.',
    'failed-request.enable-tracing.statusCodes' => 'Statuscodes',
    'failed-request.enable-tracing.statusCodesDescription' => 'Bijvoorbeeld: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Provider',

    'file-manager.show.buttonReload' => 'Opnieuw laden',
    'file-manager.show.buttonSave' => 'Opslaan',
    'file-manager.show.buttonSaveAs' => 'Opslaan als',
    'file-manager.show.buttonReset' => 'Resetten',
    'file-manager.show.buttonTextCodeEditor' => 'Bewerken in Code Editor',
    'file-manager.show.buttonTextEdit' => 'Bewerken in teksteditor',
    'file-manager.show.buttonWysiwygEdit' => 'Bewerken in HTML-editor',
    'file-manager.show.eolLabel' => 'Type regelafbreking:',
    'file-manager.show.saveAs' => 'Opslaan als:',
    'file-manager.show.saveCodepage' => 'Opslaan met het volgende karakterset:',
    'file-manager.show.loadCodepage' => 'Het originele bestand bekijken in de volgende codering:',
    'file-manager.show.loadCodepageHint' => 'Waarschuwing:Alle niet-opgeslagen wijzigingen verloren gaan bij het opnieuw laden van dit bestand.',
    'file-manager.show.fileExists' => "Het bestand of de map %%fileName%% bestaat al. Een map en een bestand kunnen niet dezelfde naam hebben.",
    'file-manager.show.popupTitle' => 'Opslaan als',
    'file-manager.show.popupFilename' => 'Bestandsnaam:',

    'file-manager.permissions.filePermissions' => 'Bestandsrechten',
    'file-manager.permissions.directoryPermissions' => 'Maprechten',
    'file-manager.permissions.buttonSubmit' => 'Opslaan',
    'file-manager.permissions.buttonApply' => 'Opslaan en doorgaan',
    'file-manager.permissions.buttonCancel' => 'Annuleren',
    'file-manager.permissions.buttonAdvanced' => 'Geavanceerd',

    'file-manager.unix-file-permissions.group' => 'Groep',
    'file-manager.unix-file-permissions.owner' => 'Eigenaar',
    'file-manager.unix-file-permissions.others' => 'Overigen',
    'file-manager.unix-file-permissions.readMode' => 'Lezen',
    'file-manager.unix-file-permissions.writeMode' => 'Schrijven',
    'file-manager.unix-file-permissions.execMode' => 'Uitvoeren/zoeken',
    'file-manager.unix-file-permissions.changeRecursive' => 'Rechten recursief wijzigen',

    'file-manager.windows-permissions.allow' => 'Toestaan',
    'file-manager.windows-permissions.deny' => 'Weigeren',
    'file-manager.windows-permissions.inheritFromParent' => 'Sta de bovenliggende map toe om overdraagbare rechten door te geven aan dit object en alle onderliggende objecten. Voeg deze samen met de ingangen die hier expliciet zijn opgegeven',
    'file-manager.windows-permissions.replaceOnChildren' => 'Rechteningangen van alle onderliggende objecten vervangen door hier getoonde ingangen',
    'file-manager.windows-permissions.buttonAdvanced' => 'Geavanceerd',
    'file-manager.windows-permissions.applyTo' => 'Toepassen op:',
    'file-manager.windows-permissions.folderOnly' => 'Alleen deze map',
    'file-manager.windows-permissions.subfolderOnly' => 'Alleen submappen',
    'file-manager.windows-permissions.filesOnly' => 'Alleen bestanden',
    'file-manager.windows-permissions.permissionsFor' => 'Rechten voor',
    'file-manager.windows-permissions.applyOnto1' => 'Alleen deze map',
    'file-manager.windows-permissions.applyOnto2' => 'Alleen submappen',
    'file-manager.windows-permissions.applyOnto3' => 'Deze map en submappen',
    'file-manager.windows-permissions.applyOnto4' => 'Alleen bestanden',
    'file-manager.windows-permissions.applyOnto5' => 'Deze map en bestanden',
    'file-manager.windows-permissions.applyOnto6' => 'Alleen submappen en bestanden',
    'file-manager.windows-permissions.applyOnto7' => 'Deze map, submappen en bestanden',
    'file-manager.windows-permissions.notInherited' => '<niet overgedragen>',

    'file-manager.editor.titleTextEditor' => 'Teksteditor',
    'file-manager.editor.titleCodeEditor' => 'Code-editor',
    'file-manager.editor.titleCodeViewer' => 'Bekijken',
    'file-manager.editor.buttonSubmit' => 'Opslaan',
    'file-manager.editor.buttonApply' => 'Opslaan en doorgaan',
    'file-manager.editor.buttonSaveAs' => 'Opslaan als ...',
    'file-manager.editor.buttonCancel' => 'Annuleren',
    'file-manager.editor.exitConfirmationYes' => 'Ja',
    'file-manager.editor.exitConfirmationNo' => 'Nee',
    'file-manager.editor.fileOverwrite' => 'Bestand bestaat al.',
    'file-manager.editor.fileOverwriteDescription' => 'Er bestaat al een bestand met deze naam. Weet u zeker dat u deze wilt overschrijven?',
    'file-manager.editor.exitConfirmation' => 'Weet u zeker dat u het bestand wilt sluiten en de niet-opgeslagen wijzigingen verloren wilt laten gaan?',
    'file-manager.editor.buttonCodeEditor' => 'Bewerken in Code Editor',
    'file-manager.editor.buttonTextEditor' => 'Bewerken in teksteditor',
    'file-manager.editor.buttonHtmlEditor' => 'Bewerken in HTML-editor',

    'file-manager.import-file.buttonSubmit' => 'Importeren',
    'file-manager.import-file.fieldUrl' => 'URL voor het bestand',
    'file-manager.import-file.fieldUrlDescription' => 'Geef de URL van de bron op, bijvoorbeeld, \'https://voorbeeld.nl/voorbeeld.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'De volledige notatie van de URL is als volgt: \'https://gebruikersnaam:wachtwoord@voorbeeld.nl/voorbeeld.tgz\', waarbij gebruikersnaam en wachtwoord optioneel zijn. De ondersteunde protocollen zijn http, https, ftp, ftps. Gebruik URL-codering voor speciale tekens of spaties in het adres.',
    'file-manager.import-file.failure' => 'Kan het bestand niet importeren.',

    'file-manager.rotation-settings.title' => 'Instellingen opschoning van prullenbak',
    'file-manager.rotation-settings.rotationBySize' => 'Opschoning op grootte',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Met deze optie worden nieuwe bestanden verwijderd zolang de opgegeven beperking voor de prullenbak wordt overschreden.',
    'file-manager.rotation-settings.rotationByDate' => 'Opschoning op datum',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Dagen',
    'file-manager.rotation-settings.rotationByDateHint' => 'De optie verwijdert bestanden die al langer dan het opgegeven aantal dagen in de prullenbak zitten.',

    'ftp-user.description' => 'Als u aan uw website werkt met iemand anders, of u host subdomeinen voor andere gebruikers, dan wilt u wellicht aparte FTP-accounts voor hen aanmaken.',
    'ftp-user.generalSection' => 'Algemeen',
    'ftp-user.login' => 'Naam FTP-account',
    'ftp-user.home' => 'Hoofdmap',
    'ftp-user.systemArea' => 'Het FTP-account aanmaken met toegang tot bestanden buiten de hoofdmap',
    'ftp-user.password' => 'Wachtwoord',
    'ftp-user.passwordConfirmation' => 'Bevestig wachtwoord',
    'ftp-user.hardQuotaSection' => 'Harde beperking domein',
    'ftp-user.hardQuota' => 'Harde beperking domein',
    'ftp-user.hardQuotaUnlimited' => 'Onbeperkt',
    'ftp-user.permissionsSection' => 'Rechten',
    'ftp-user.permissionRead' => 'Leesrechten',
    'ftp-user.permissionWrite' => 'Schrijfrechten',
    'ftp-user.popupTitle' => 'Map selecteren',

    'mail-list.listName' => 'Verzendlijstadres',
    'mail-list.enabled' => 'Ingeschakeld',
    'mail-list.administratorEmail' => 'E-mail van verzendlijstbeheerder',
    'mail-list.password' => 'Wachtwoord',
    'mail-list.passwordConfirmation' => 'Wachtwoord bevestigen',
    'mail-list.subscribers' => 'Abonnementhouders',
    'mail-list.subscribersHint' => 'Voer de e-mailadressen in. U kunt elk adres op een nieuwe regel invoeren, of adressen scheiden door middel van een spatie, komma of puntkomma.',
    'mail-list.notify' => 'Informeer de beheerder over het aanmaken van de verzendlijst.',
    'mail-list.emptyPassword' => 'Geef een wachtwoord op.',
    'mail-list.emptyPasswordConfirmation' => 'U moet het wachtwoord bevestigen.',
    'mail-list.errorSubscribers' => 'Ongeldig e-mailadres: %value%.',
    'mail-list.errorMaillistReserved' => 'Opgegeven verzendlijstadres is al in gebruik.',

    'mail-settings.hint' => 'Hier kunt u de instellingen van de maildienst wijzigen voor dit domein.',
    'mail-settings.service' => 'Maildienst op domein activeren',
    'mail-settings.nonExist' => 'Wat te doen met mail aan niet-bestaande gebruikers',
    'mail-settings.nonExistBounceWithMessage' => 'Terugsturen met verklaring',
    'mail-settings.nonExistBounce' => 'Afwijzen',
    'mail-settings.nonExistCatch' => 'Doorsturen naar adres',
    'mail-settings.nonExistCatchDescription' => 'Het mailadres moet horen bij het geselecteerde domein. Alleen de beheerder kan een extern adres opgegeven of één adres voor meerdere domeinen.',
    'mail-settings.nonExistExternal' => 'Doorsturen naar externe mailserver met IP-adres',
    'mail-settings.nonExistReject' => 'Afwijzen',
    'mail-settings.nonExistDiscard' => 'Afwijzen',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'Geen',
    'mail-settings.webmailComponentNotInstalled' => 'Het component webmail is niet geïnstalleerd.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Er is een subdomein met naam %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'SSL/TLS-certificaat voor webmail',
    'mail-settings.webmailCertificateNone' => 'Niet geselecteerd',
    'mail-settings.mailCertificate' => 'SSL/TLS-certificaat voor e-mail',
    'mail-settings.mailCertificateNone' => 'Niet geselecteerd',
    'mail-settings.serverCertificateNotSelected' => 'Het certificaat is toegewezen, maar de e-mail voor het domein is niet beveiligd. Om het beveiligen van e-mail voor het domein te voltooien, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'beveiligt u de mailserver',
    'mail-settings.mailLists' => 'Verzendlijsten inschakelen',
    'mail-settings.mailAutodiscovery' => 'Autodiscover voor e-mail inschakelen',
    'mail-settings.mailAutodiscoveryDescription' => 'Bekijk hoe het werkt in de %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'kennisbank',
    'mail-settings.domainKeys' => 'Bescherm tegen spam door met het DKIM-systeem uitgaande berichten te ondertekenen',
    'mail-settings.greyListing' => 'Bescherming tegen spam door middel van greylisting inschakelen voor alle mailaccounts binnen dit domein',
    'mail-settings.howToConfigureExternalDns' => 'Het instellen van externe DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Als u DKIM-ondertekening wilt inschakelen terwijl u een externe DNS-server gebruikt, dan moet u zelf de DNS-records voor DKIM op de DNS-server instellen.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Gebruik daarvoor de onderstaande DKIM DNS-records:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Als u domeinaliassen gebruikt voor het verzenden van e-mail, dan moet u ook daar de DKIM DNS-records toevoegen. Gebruik dezelfde records als voor het hoofddomein, maar nu met de naam van het domeinalias.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Om de DKIM DNS-records die u moet instellen te bekijken, selecteert u het selectievakje "%%option%%", u past deze toe en opent deze popup opnieuw.',

    'role.roleSection' => 'Algemeen',
    'role.name' => 'Naam gebruikersrol',
    'role.description' => 'Omschrijving',
    'role.generalPermissionsSection' => 'Toegang tot diensten van Plesk',
    'role.applicationsAccessSection' => 'Toegang tot toepassingen',
    'role.permissionAllow' => 'Toegekend',
    'role.permissionDeny' => 'Geweigerd',
    'role.emptyRoleName' => 'Geef een naam voor de rol op.',
    'role.installedAt' => 'Geïnstalleerd in',
    'role.noInstallationUrlAvailable' => 'Externe toepassing',
    'role.invalidRoleName' => 'De gespecificeerde naam van de gebruikersrol is niet geldig. De rolnaam mag geen vraagtekens en uitroeptekens bevatten.',
    'role.longRoleName' => 'De naam van de opgegeven gebruikersrol is te lang.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Een aantal bewerkingen kunnen mogelijk niet beschikbaar zijn. De reden hiervoor kan zijn: voor het huidige, geselecteerde abonnement werd geen toestemming voor de bewerking verleend, of het aantal toegewezen middelen is onvoldoende om een bewerking uit te voeren.',
    'role.servicesPermissionsDescription' => 'Stelt de toegang tot geïnstalleerde apps of diensten van Plesk in voor alle gebruikers met deze rol. Als u een gebruiker toegang geeft tot een app, dan zal de app beschikbaar zijn vanuit Hostingbeheer.',
    'role.emailActivation' => 'Activeer de accounts van deze rol via e-mail',

    'service.admin-access.adminAccess' => 'Beheerdertoegang',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Deze combinatie van gebruikersnaam en wachtwoord wordt gebruikt voor beheerdertoegang tot deze toepassing.',
    'service.admin-access.login' => 'Beheerdersgebruikersnaam',
    'service.admin-access.password' => 'Beheerderswachtwoord',
    'service.admin-access.passwordConfirmation' => 'Bevestig wachtwoord',

    'service.info.service-entry-point.availableAt' => 'Beschikbaar op',
    'service.info.service-entry-point.customize' => 'Snelkoppeling aanpassen',
    'service.info.service-entry-point.displayNameLabel' => 'Naam van snelkoppeling',
    'service.info.service-entry-point.displayNameDescription' => 'Geen een naam op voor deze snelkoppeling. Deze naam wordt weergegeven onder het pictogram van de snelkoppeling. Snelkoppelingen worden geplaatst op pagina Mijn diensten van gebruikers die toegang tot deze toepassing hebben.',
    'service.info.service-entry-point.descriptionLabel' => 'Omschrijving van snelkoppeling',
    'service.info.service-entry-point.descriptionDescription' => 'Geef een omschrijving voor deze snelkoppeling. De omschrijving wordt weergegeven wanneer de muisaanwijzer boven de snelkoppeling wordt gehouden.',
    'service.info.service-entry-point.iconLabel' => 'Klik om het pictogram voor de snelkoppeling te selecteren',
    'service.info.service-entry-point.iconCurrent' => 'Huidig pictogram',
    'service.info.service-entry-point.errorEmptyName' => 'U moet een naam voor de snelkoppeling opgeven.',
    'service.info.service-entry-point.errorLongName' => 'De naam van een snelkoppeling moet tussen de 1 en 255 karakters bevatten.',
    'service.info.service-entry-point.errorLongDescription' => 'De omschrijving van een snelkoppeling moet tussen de 0 en 255 karakters bevatten.',
    'service.info.service-entry-point.hiddenLabel' => 'Snelkoppeling verbergen',
    'service.info.service-entry-point.hiddenDescription' => 'Deze snelkoppeling niet aan de gebruikers tonen.',

    'service.info.service-permission.assignedUser' => "Beheerdersrechten aan deze gebruiker toewijzen",
    'service.info.service-permission.assignedUserNone' => 'Geen gebruiker toegewezen',

    'shared-ssl.master-ssl.switchedOn' => 'Gedeeld SSL/TLS inschakelen',
    'shared-ssl.master-ssl.domainName' => 'Domeinnaam voor een site waarvan het SSL/TLS-certificaat zal worden gedeeld met andere sites',
    'shared-ssl.master-ssl.none' => 'Geen',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Gedeeld SSL/TLS kan niet worden ingeschakeld omdat er geen domeinen zijn waarvoor SSL/TLS-ondersteuning is ingeschakeld.',

    'user.email.email' => 'E-mailadres',
    'user.email.emptyEmail' => 'U moet een e-mailadres opgeven.',
    'user.email.internalEmailHint' => 'Maak een nieuw e-mailadres aan in Plesk of gebruik een extern e-mailadres.',
    'user.email.longInternalEmail' => 'Het e-mailadres is te lang.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Het deel van het e-mailadres dat dienst doet als gebruikersnaam is te lang voor deze mailserver. Geef een gebruikersnaam op met maximaal %%max%% karakters.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Het e-mailadres is te lang voor deze mailserver. Geef een e-mailadres op met maximaal %%max%% karakters.',
    'user.email.externalEmail' => 'Extern e-mailadres',
    'user.email.externalEmailHint' => 'Wordt gebruikt om uw wachtwoord opnieuw in te stellen in het geval u ooit geen toegang meer heeft tot uw primaire e-mailadres.',
    'user.email.emailsIsEqual' => 'Het externe e-mailadres komt overeen met het primaire e-mailadres. Geef een ander extern e-mailadres op.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Geef een intern of extern e-mailadres op.',

    'user.profileSection' => 'Algemene Informatie',
    'user.contactName' => 'Naam contactpersoon',
    'user.email' => 'E-mailadres',
    'user.role' => 'Gebruikersrol',
    'user.accountSection' => 'Plesk-voorkeuren',
    'user.login' => 'Gebruikersnaam',
    'user.password' => 'Wachtwoord',
    'user.buttonBack' => 'Terug',
    'user.generalTab' => 'Algemeen',
    'user.applicationsAccessSection' => 'Diensten',
    'user.generalPermissionsSection' => 'Privileges',
    'user.contactsTab' => 'Contactgegevens',
    'user.passwordConfirmation' => 'Bevestig wachtwoord',
    'user.internalEmailPasswordChanged' => 'Als u het wachtwoord wijzigt, wordt ook het wachtwoord van het interne e-mailadres gewijzigd.',
    'user.emailName' => 'E-mailadres',
    'user.emailType' => 'Type e-mail',
    'user.companyName' => 'Bedrijfsnaam',
    'user.phone' => 'Telefoonnummer',
    'user.imNumber' => 'Instant Messenger',
    'user.fax' => 'Faxnummer',
    'user.address' => 'Adres',
    'user.city' => 'Plaats',
    'user.state' => 'Provincie',
    'user.zip' => 'Postcode',
    'user.country' => 'Land',
    'user.additionalInfo' => 'Extra informatie',
    'user.additionalInfoHint' => 'Alleen platte tekst: alle HTML-tags zullen worden genegeerd.',
    'user.language' => 'Taal van Plesk',
    'user.buttonChangePassword' => 'Wijzig Wachtwoord',
    'user.permissionAllow' => 'Toegekend',
    'user.permissionDeny' => 'Geweigerd',
    'user.permissionInherited' => 'Bepaald door rol',
    'user.emptyContactName' => 'U moet een contactnaam opgeven.',
    'user.emptyLogin' => 'U moet een gebruikersnaam opgeven.',
    'user.emptyPassword' => 'U moet een wachtwoord opgeven.',
    'user.emptyPasswordConfirmation' => 'U moet het wachtwoord bevestigen.',
    'user.chooseDomainBoxTitle' => 'Selecteer een ander domein:',
    'user.userIsActive' => 'Gebruiker is actief',
    'user.userIsActiveHint' => 'Actieve gebruikers hebben toegang tot Plesk.',
    'user.emailActivation' => 'Account via e-mail activeren',
    'user.emailHint' => 'Om de gebruiker te voorzien van een e-mailadres dat op deze server wordt gehost, gaat u naar het tabblad Mail, voert u het e-mailadres in en koppelt u het aan deze gebruiker.',
    'user.emailContactHint' => 'Neem contact op met uw provider als u een e-mailadres wilt gebruiken dat op deze server wordt gehost.',
    'user.personalEmailHint' => "Het e-mailadres van deze gebruiker kan worden gewijzigd op het tabblad Mail.",
    'user.externalMailRedirectHint' => 'Het doorsturen van berichten kan alleen worden geactiveerd voor e-mailadressen die op deze server worden gehost. Op het tabblad Mail kunt u een nieuw e-mailadres aanmaken.',
    'user.externalMailRedirectHint2' => 'Het doorsturen van berichten kan alleen worden geactiveerd voor e-mailadressen die op deze server worden gehost.',
    'user.externalMailAutoResponderHint' => 'Automatische Beantwoording kan alleen worden geactiveerd voor e-mailadressen die op deze server worden gehost. Op het tabblad Mail kunt u een nieuw e-mailadres aanmaken.',
    'user.externalMailAutoResponderHint2' => 'Automatische Beantwoording kan alleen worden geactiveerd voor e-mailadressen die op deze server worden gehost.',
    'user.roleHint' => 'Gebruikersrollen geven gebruikers administratieve privileges en toegang tot de toepassingen die u voor de rol hebt geselecteerd.',
    'user.cannotManageMail' => "U hebt geen toestemming om de mailinstellingen en diensten te beheren.",
    'user.longCompanyName' => 'De opgegeven bedrijfsnaam is te lang.',
    'user.longPhone' => 'Het opgegeven telefoonnummer is te lang.',
    'user.longFax' => 'Het opgegeven faxnummer is te lang.',
    'user.longAddress' => 'Het opgegeven adres is te lang.',
    'user.longCity' => 'De opgegeven plaatsnaam is te lang.',
    'user.phoneRegexNotMatch' => 'Het opgegeven telefoonnummer is ongeldig.',
    'user.faxRegexNotMatch' => 'Het opgegeven faxnummer is ongeldig.',
    'user.shortCity' => 'De opgegeven plaatsnaam is te kort.',
    'user.limitSubscription' => 'Toegang tot abonnementen',
    'user.limitSubscriptionHint' => 'Gebruikers alleen toegang tot een specifiek abonnement toestaan. De waarde "Alle" geeft hen toegang tot alle abonnementen binnen uw hostingaccount.',
    'user.limitSubscriptionAll' => 'Alles',
    'user.deletedSubscription' => 'Verwijderd abonnement',

    'web.add-domain-alias.title' => 'Een domeinalias toevoegen',
    'web.add-domain-alias.createdSuccessfully' => "Het domeinalias %%name%% is aangemaakt.",
    'web.add-domain-alias.domainAliasName' => 'Naam domeinalias',
    'web.add-domain-alias.domainAliasNameHint' => 'Bijvoorbeeld voorbeeld.net',
    'web.add-domain-alias.forDomain' => 'voor het domein',
    'web.add-domain-alias.settingsSectionLegend' => 'Instellingen',
    'web.add-domain-alias.settingsDns' => 'Synchroniseer DNS-zone met het primaire domein',
    'web.add-domain-alias.settingsMail' => 'Maildienst',
    'web.add-domain-alias.settingsWeb' => 'Webservice',
    'web.add-domain-alias.settingsSeoRedirect' => 'Doorschakelen met HTTP-code 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Wanneer bezoekers de URL van de alias openen, dan worden zij omgeleid naar de URL van het primaire domein. Plesk maakt gebruik van de zoekmachinevriendelijke HTTP 301-omleiding, want betekent dat de waarde van de site voor zoekmachines niet wordt verdeeld over verschillende URLs.',
    'web.add-domain-alias.settingsTomcat' => 'Java-webtoepassingen',
    'web.add-domain-alias.invalidDomainGuid' => 'Ongeldig domein',

    'web.add-domain.formTitle' => 'Een nieuw domein toevoegen',
    'web.add-domain.portalLink' => 'Dienstenportaal',
    'web.add-domain.domainName' => 'Domeinnaam',
    'web.add-domain.domainNameHint' => "Bijvoorbeeld voorbeeld.nl",
    'web.add-domain.assignToCustomer' => 'Dit domein aan een cliënt toewijzen',
    'web.add-domain.customer' => 'Cliënt selecteren',
    'web.add-domain.createNewCustomer' => 'Een nieuwe cliënt aanmaken',
    'web.add-domain.selectExistingCustomer' => 'Selecteer een bestaande cliënt:',
    'web.add-domain.customerContactInfoHint' => 'Geef de contactgegevens van de cliënt op. Andere informatie, zoals telefoonnummer en adres, kunt u later opgegeven.',
    'web.add-domain.customerLoginInfoHint' => 'Aanmeldgegevens voor Hostingbeheer',
    'web.add-domain.target' => 'Webruimte',
    'web.add-domain.createNewTarget' => 'Nieuw abonnement aanmaken',
    'web.add-domain.createNewTarget_powerUser' => 'Nieuwe Webruimte aanmaken',
    'web.add-domain.selectExistingTarget' => 'Selecteer een bestaand abonnement::',
    'web.add-domain.selectExistingTarget_powerUser' => 'Selecteer een bestaande webruimte::',
    'web.add-domain.dns' => 'De DNS-dienst inschakelen',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'De maildienst inschakelen',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Werkt indien de instellingen van het abonnement het beheren van e-mailrechten per domein toestaan. Als dit niet is toegestaan, dan wordt de daadwerkelijke status van de e-maildienst uit het abonnement afgeleid.',
    'web.add-domain.hostingManagementOptions' => 'Type hosting',
    'web.add-domain.websiteHosting' => 'Websitehosting',
    'web.add-domain.websiteForwarding' => 'Doorschakelen',
    'web.add-domain.websiteNoHosting' => 'Geen hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Hostinginstellingen',
    'web.add-domain.domainCreatedSuccessfully' => 'Het aanmaken van het domein %%domainName%% is geslaagd.',
    'web.add-domain.webspaceLegend' => 'Instellingen webruimte',
    'web.add-domain.addWhmWebsiteTitle' => 'Nieuwe website toevoegen',
    'web.add-domain.addWhmWebsiteHint' => "U kunt een website op deze server te hosten.",
    'web.add-domain.selectWhmDomain' => 'Selecteer domein',
    'web.add-domain.customerLegend' => 'Info over de cliënt',
    'web.add-domain.credentials' => 'Aanmeldgegevens systeemgebruiker',
    'web.add-domain.credentialsHint' => 'voor toegang tot gehoste bestanden via FTP en SSH',
    'web.add-domain.credentialsHintWin' => 'voor toegang tot gehoste bestanden via FTP en RDP',
    'web.add-domain.buttonAddDomain' => 'Domein toevoegen',

    'web.add-subdomain.formTitle' => 'Een subdomein toevoegen',
    'web.add-subdomain.formGeneralHint' => 'Subdomeinen zijn internetadressen voor verschillende secties van uw website. Ze maken gebruik van uw domeinnaam, maar voegen daar een voorvoegsel aan toe. Als uw domein bijvoorbeeld domein.nl is, dan zou een mogelijk subdomein webwinkel.domein.nl kunnen zijn.',
    'web.add-subdomain.formGeneralHintAdditional' => 'U kunt ook een subdomein met een joker aanmaken door het symbool * op te geven in plaats van de naam. Bezoekers van de site worden dan naar dit subdomein omgeleid, ongeacht welk subdomein ze in de browser opgegeven.',
    'web.add-subdomain.subdomainName' => 'Naam subdomein',
    'web.add-subdomain.subdomainNameHint' => 'Voer * in om een subdomein met een joker aan te maken.',
    'web.add-subdomain.forDomain' => 'Bovenliggend domein',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Het subdomein is aangemaakt.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Hostinginstellingen',

    'web.change-hosting.formGeneralHint' => 'U kunt de website op de server hosten (Website hosting), u kunt een doorschakeling naar een andere website instellen (Doorschakelen), of u kunt de DNS-zone van het domein gebruiken om postvakken onder dit domein te plaatsen (Geen hosting).',
    'web.change-hosting.changed' => 'Type hosting voor %%domainName%% is gewijzigd.',
    'web.change-hosting.hostingManagementOptions' => 'Type hosting',
    'web.change-hosting.websiteHosting' => 'Websitehosting',
    'web.change-hosting.websiteForwarding' => 'Doorschakelen',
    'web.change-hosting.websiteNoHosting' => 'Geen webhosting',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Hostinginstellingen',
    'web.change-hosting.userName' => 'Gebruikersnaam',
    'web.change-hosting.userNameHint' => 'Systeemgebruiker voor het beheer van bestanden en mappen binnen het abonnement.',
    'web.change-hosting.userNameHint_powerUser' => 'Systeemgebruiker voor het beheer van bestanden en mappen binnen de webruimte.',
    'web.change-hosting.emptyLogin' => 'U moet een gebruikersnaam opgeven.',
    'web.change-hosting.password' => 'Wachtwoord',
    'web.change-hosting.emptyPassword' => 'U moet een wachtwoord opgeven.',
    'web.change-hosting.passwordConfirmation' => 'Wachtwoord bevestigen',
    'web.change-hosting.warningInstalledApplications' => 'Op de site zijn webtoepassingen geïnstalleerd. Als u van type hosting wisselt, zijn deze toepassingen niet meer beschikbaar.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Warning: De inhoud van de website zal worden verwijderd.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Wilt u het type hosting voor uw website wijzigen?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'De volgende mappen en alle bestanden daarin zullen worden verwijderd :',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'De volledige inhoud van de hoofdmap van de webruimte zal worden verwijderd.',

    'web.change-status.changed' => 'Websitestatus voor %%domainName%% is gewijzigd.',
    'web.change-status.statusManagementOptions' => 'Websitestatus',
    'web.change-status.statusDisabled' => 'Uitgeschakeld (werd voorheen Opgeschort genoemd)',
    'web.change-status.statusSuspended' => 'Opgeschort',
    'web.change-status.statusActive' => 'Actief',
    'web.change-status.statusDisabledHint' => 'De website zal niet langer op de server worden gehost en zal niet langer beschikbaar zijn, anders dan via FTP en Bestandsbeheer. Bezoekers zullen de standaardpagina van de webserver zien. De maildienst zal beschikbaar blijven.',
    'web.change-status.statusSuspendedHint' => 'The website will remain hosted on the server, but visitors will be redirected with the 503 HTTP code to the custom error document page. De maildienst zal beschikbaar blijven.Hier kunt u %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'Bezoekers zullen met de zoekmachinevriendelijke HTTP-statuscode 503 worden omgeleid naar de aangepaste foutmeldingspagina, hoewel de website nog steeds op de server zal zijn gehost. De maildienst zal beschikbaar blijven.',
    'web.change-status.error503PageLink' => 'het aangepaste foutmeldingsdocument bewerken',
    'web.change-status.statusActiveHint' => 'De website zal normaal functioneren.',
    'web.change-status.notActivatedSuspended' => 'Het domein of de website %%domainName%% kan niet worden geactiveerd omdat het is opgeschort door de hostingprovider.',
    'web.change-status.notActivatedDisabled' => 'Het domein of de website %%domainName%% kan niet worden geactiveerd omdat het is uitgeschakeld door de hostingprovider.',

    'web.edit.formTitle' => 'Toegang tot webhosting voor %%name%%',
    'web.edit.formGeneralHint' => 'Hier kunt u de IP-adressen bekijken die aan uw abonnement zijn toegewezen. Ook kunt u de gebruikersnaam en het wachtwoord van uw systeemgebruiker wijzigen.',
    'web.edit.formGeneralHint_powerUser' => 'Hier kunt u de IP-adressen bekijken die aan deze webruimte zijn toegewezen. Ook kunt u de gebruikersnaam en het wachtwoord van uw systeemgebruiker wijzigen.',
    'web.edit.ipAddressesLegend' => 'IP-adressen',
    'web.edit.ipAddresses' => 'IP-adressen',
    'web.edit.certificateLegend' => 'Certificaat',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (eigendom van een andere gebruiker)',
    'web.edit.userAccountLegend' => 'Systeemgebruiker',
    'web.edit.systemUserHint' => 'Hier kunt u een gebruiker van het besturingssysteem opgeven voor het beheer van bestanden en mappen binnen het abonnement, via FTP of met Bestandsbeheer. De systeemgebruiker wordt ook gebruikt voor toegang tot Plesk via SSH (Linux) of RDP (Windows), indien de juiste rechten daarvoor zijn toegekend.',
    'web.edit.systemUserHint_powerUser' => 'Hier kunt u een gebruiker van het besturingssysteem opgeven voor het beheer van bestanden en mappen binnen de webruimte, via FTP of met Bestandsbeheer. De systeemgebruiker wordt ook gebruikt voor toegang tot Plesk via SSH (Linux) of RDP (Windows), indien de juiste rechten daarvoor zijn toegekend.',
    'web.edit.login' => 'Gebruikersnaam',
    'web.edit.emptyLogin' => 'Voer een gebruikersnaam in.',
    'web.edit.password' => 'Wachtwoord',
    'web.edit.passwordConfirmation' => 'Bevestig wachtwoord',
    'web.edit.emptyPassword' => 'U moet een wachtwoord opgeven.',
    'web.edit.emptyPasswordConfirmation' => 'U moet het wachtwoord bevestigen.',
    'web.edit.shellUnix' => "Toegang tot de server via SSH",
    'web.edit.shellHintUnix' => "Toegang tot de server via SSH, met gebruik van de gebruikersnaam en het wachtwoord van de gebruiker.",
    'web.edit.shellWin' => 'Toegang tot de server via het externe bureaublad',
    'web.edit.shellHintWin' => "Toegang tot de server via het externe bureaublad, met gebruik van de gebruikersnaam en het wachtwoord van de gebruiker.",
    'web.edit.diskQuotaLegend' => 'Quotum voor schijfruimte',
    'web.edit.diskQuotaHint' => 'Het quotum voor de schijfruimte is een harde beperking van de hoeveelheid schijfruimte die u kunt gebruiken. Als het quotum is ingesteld en alle toegewezen schijfruimte is gebruikt, dan kunnen bestanden niet meer worden bewerkt.',
    'web.edit.diskQuota' => 'Quotum voor schijfruimte',
    'web.edit.diskQuotaUnlimited' => 'Onbeperkt',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => 'Onbeperkt. De harde schijf quota wordt als gevolg van de configuratie van het bestandssysteem van de server niet ondersteund.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'Bijwerken van de hostinginstellingen is geslaagd.',
    'web.edit.affectedDomainsLegend' => 'Websites waarvoor deze instellingen van toepassing zijn',
    'web.edit.affectedDomainsHint' => 'De volgende websites zijn gekoppeld aan de huidige systeemgebruiker. De wijzigingen die op deze pagina worden gemaakt in de toegangsinstellingen van de webhosting zullen op al deze websites worden toegepast.',

    'web.mobile.create.formTitle' => 'Een mobiele site maken',
    'web.mobile.create.formGeneralHint' => 'Voer de naam van de mobiele site in -- een URL waarmee toegang tot de mobiele site kan worden verkregen. Meestal worden voorvoegsels gebruikt, zoals "m", "mob", "mobi", "mobiel" enz., bijvoorbeeld: mobiel.voorbeeld.com. U kunt deze URL vervolgens in een link of koppeling zoals "Mobiele versie" op uw reguliere site gebruiken, zodat de bezoekers van uw site de mogelijkheid hebben om tussen de mobiele en de reguliere versie te kiezen.',
    'web.mobile.create.prefix' => 'Naam van de site',
    'web.mobile.create.emptySiteName' => 'De naam van een mobile website mag niet leeg zijn, omdat het anders met uw reguliere website kan conflicteren.',

    'web.security-section.securitySectionLegend' => 'Beveiliging',
    'web.security-section.securitySectionHint' => 'Om transacties met uw site te beveiligen kunt u het SSL/TLS-protocol gebruiken, waarmee alle gegevens worden versleuteld en overgedragen via een beveiligde verbinding. Om SSL/TLS te gebruiken verplaatst u deze site naar een exclusief IP-adres, u installeert een SSL/TLS-certificaat op de site en selecteert deze hieronder.',
    'web.security-section.securitySectionSniHint' => 'Om transacties met uw site te beveiligen kunt u het SSL/TLS-protocol gebruiken, waarmee alle gegevens worden versleuteld en overgedragen via een beveiligde verbinding. Om SSL/TLS te gebruikten installeert u SSL/TLS-certificaat op de site, waarna u deze hieronder kunt selecteren.',
    'web.security-section.enableSslSupport' => 'SSL/TLS-ondersteuning',
    'web.security-section.enableSslRedirect' => 'Permanente SEO-vriendelijke 301-redirect van HTTP naar HTTPS',

    'web.seo-settings.seoRedirectDirection' => 'Voorkeursdomein',
    'web.seo-settings.seoRedirectDirectionHint' => 'Selecteer de URL (met of zonder het voorvoegsel www) waarnaar gebruikers worden doorgeschakeld middels een SEO-vriendelijke HTTP 301-doorschakeling.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Geen',

    'web.settings.formGeneralHint' => 'Op deze pagina kunt u de webhostinginstellingen instellen en de voor uw site beschikbare functies selecteren.',
    'web.settings.hostingType' => 'Type hosting',
    'web.settings.websiteHosting' => 'Website',
    'web.settings.forwardingHosting' => 'Doorschakelen',
    'web.settings.noHosting' => 'Geen hosting',
    'web.settings.changeHosting' => 'Wijzigen',
    'web.settings.websiteStatus' => 'Websitestatus',
    'web.settings.changeStatus' => 'Wijzigen',
    'web.settings.active' => 'Actief',
    'web.settings.suspended' => 'Opgeschort',
    'web.settings.disabled' => 'Uitgeschakeld',
    'web.settings.webScriptingSectionLegend' => 'Webscripting en statistieken',
    'web.settings.webScriptingSectionHint' => 'Geef aan welke van de volgende programmeer- en scripttalen moeten worden geïnterpreteerd, uitgevoerd of anderszins door de webserver moeten worden verwerkt.',
    'web.settings.__asp_win_support' => 'Microsoft ASP-ondersteuning',
    'web.settings.__asp_dot_net_support' => 'Microsoft ASP.NET-ondersteuning',
    'web.settings.__asp_dot_net_version' => 'Versie',
    'web.settings.__asp_dot_net_version_readonly' => 'versie %%value%%',
    'web.settings.__ssi_support' => 'SSI-ondersteuning',
    'web.settings.__ssi_with_html' => 'SSI gebruiken voor *.htm, *.html-bestanden',
    'web.settings.__php_support' => 'PHP-ondersteuning',
    'web.settings.__php_run_as' => 'PHP uitvoeren als',
    'web.settings.__php_served_by_apache' => 'bediend door Apache',
    'web.settings.__php_served_by_nginx' => 'bediend door nginx',
    'web.settings.__cgi_support' => 'CGI-ondersteuning',
    'web.settings.__cgi_bin_mode' => 'modus van map cgi-bin: inside',
    'web.settings.__cgi_bin_mode_webspace' => 'hoofdmap van webruimte',
    'web.settings.__cgi_bin_mode_www_root' => 'www-hoofdmap van dit domein',
    'web.settings.__cgi_bin_mode_old_style' => 'de hoofdmap van dit domein, oude stijl',
    'web.settings.__cgi_bin_mode_readonly' => 'modus van map cgi-bin: inside %%value%%',
    'web.settings.__perl_unix_support' => 'Perl-ondersteuning',
    'web.settings.__perl_win_support' => 'Perl-ondersteuning',
    'web.settings.__python_unix_support' => 'Python-ondersteuning',
    'web.settings.__python_win_support' => 'Python-ondersteuning',
    'web.settings.__fastcgi_unix_support' => 'Beheer FastCGI-ondersteuning',
    'web.settings.__webstat_support' => 'Webstatistieken',
    'web.settings.__plesk_stat_protect' => 'De toegang tot uw webstatistieken afschermen met uw FTP-gebruikersnaam en wachtwoord',
    'web.settings.__plesk_stat_protected' => 'De toegang tot uw webstatistieken is afgeschermd door middel van de gebruikersnaam en het wachtwoord dat u ook voor FTP gebruikt',
    'web.settings.__apache_errdocs' => 'Aangepaste foutmeldingdocumenten',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'FastCGI-toepassing',
    'web.settings.__php_cgi_handler' => 'CGI-toepassing',
    'web.settings.__php_isapi_handler' => 'ISAPI-extensie',
    'web.settings.__php_version' => 'PHP-versie',
    'web.settings.__hosting_write_modify' => 'Aanvullende schrijf- en bewerkrechten',
    'web.settings.__hosting_webdeploy' => 'Publiceren met Web Deploy',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Geen',
    'web.settings.activate' => 'Activeren',
    'web.settings.deactivate' => 'Opschorten',
    'web.settings.__php_support_readonly' => 'versie: %%version%%; handler: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'niet ingeschreven',
    'web.settings.domainName' => 'Domeinnaam',
    'web.settings.domainNameHint' => "Bijvoorbeeld voorbeeld.nl",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Compatibiliteitsmodus voor de verouderde optie "SSL/TLS-bestanden en niet-SSL/TLS-bestanden scheiden"',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Voor de website uit in compatibiliteitsmodus voor de verouderde optie "SSL/TLS-bestanden en niet-SSL/TLS-bestanden scheiden"',
    'web.settings.sameSslCompatibilityHint' => 'U ziet deze sectie omdat u voor de upgrade gebruik hebt gemaakt van de optie "SSL/TLS-bestanden en niet-SSL/TLS-bestanden scheiden". In Plesk 11 is deze optie niet meer van toepassing. Alle websites die in Plesk 11 zijn aangemaakt, maken gebruik van dezelfde map voor bestanden die hetzij via HTTP, hetzij via HTTPS-verbindingen beschikbaar zijn. Dit betekent dat de site nog steeds wordt uitgevoerd in compatibiliteitsmodus en dat u deze niet via Plesk kunt beheren. Het wordt ten zeerste aangeraden om al uw bestanden van de map httpsdocs/ naar de map httpdocs/ te verplaatsen en daarna de compatibiliteitsmodus uit te schakelen. Nadat u de compatibiliteitsmodus hebt uitgeschakeld, hebt u geen mogelijkheid om deze modus weer in te schakelen; deze sectie zal dan ook niet meer verschijnen. Merk op dat wanneer u toepassingen installeert in de map httpsdocs/ terwijl de compatibiliteitsmodus is ingeschakeld, deze niet toegankelijk zal zijn vanaf het internet. Om bestanden te installeren in httpsdocs/, moet u de compatibiliteitsmodus uitschakelen.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'De instellingen van de website zullen worden toegepast over %%restartInterval%% minuten.',
    'web.settings.phpSettingsDescription' => 'Deze pagina geeft de PHP-instellingen voor website weer. Deze instellingen horen bij de website en zijn niet van invloed op andere websites binnen het abonnement. U kunt de PHP-instellingen wijzigen als u daartoe het recht heeft gekregen van uw hostingprovider. U kunt aangepaste PHP-instellingen gebruiken, bijvoorbeeld om de systeembelasting door PHP-scripts te beperken, of om te voldoen aan de vereisten van een specifieke webtoepassing. Als u een parameter instelt op de standaardwaarde, dan zal PHP de waarde van de parameter uit de PHP-configuratie voor de server als geheel gebruiken.',
    'web.settings.phpSettingsAvailableVariables' => 'U kunt de volgende variabelen gebruiken in de waarden van parameters:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} voor de hoofdmap (document root) van deze website. De huidige waarde is %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'De hoofdmap voor HTTPS-documenten is gelijk aan die voor HTTP-documenten.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'De hoofdmap voor HTTPS-documenten is %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} als hoofdmap voor de primaire website van het abonnement.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} voor de map waarin tijdelijke bestanden worden opgeslagen.',
    'web.settings.phpSettingsPhpVersion' => 'Uw versie van PHP is %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP is uitgeschakeld.',
    'web.settings.phpHandlerTypeHint' => 'Merk op dat het wijzigen van het PHP-handlertype ervoor kan zorgen dat bestaande PHP-scripts op deze website niet goed meer werken.',
    'web.settings.fpmDedicatedHandlerHint' => 'Het gebruik van deze handler verhoogt de stabiliteit van een website, maar het leidt ook tot extra geheugengebruik.',
    'web.settings.phpHandlerChangeHint' => 'U hebt de instellingen voor de PHP-handler gewijzigd. Als u deze wijzigingen opslaat kunnen de PHP-scripts op uw website voor %%interval%% seconden stoppen vanwege de serverconfiguratie.',
    'web.settings.phpHandlerTypeHelpLink' => 'Meer informatie over het kiezen van de meest geschikte PHP-instellingen',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'Ondersteuning voor PHP kan niet worden ingeschakeld omdat de huidige hosting-instellingen geen versie van PHP voor dit domein beschikbaar stelt.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Ontdek hoe u andere versies van PHP kunt inschakelen.',
    'web.settings.phpHandlerBroken' => 'De momenteel geselecteerde PHP-handler is corrupt. Selecteer een andere handler.',
    'web.settings.phpHandlerOutdated' => '(Verouderd)',
    'web.settings.phpHandlerDeprecated' => '(Verouderd)',

    'web.setupService.formTitle' => 'Dienst instellen: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Het bijwerken van de dienst \'%%serviceReference%%\' is geslaagd.',

    'web.site-copy.subdomainsGroup' => 'Subdomeinen van %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Bestemming kopiëren',
    'web.site-copy.destinationType' => 'Selecteren waar de bestanden van de site naartoe moeten worden gekopieerd',
    'web.site-copy.destinationTypeSite' => 'Website in Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'De bestanden van de site kopiëren naar een van uw andere sites binnen dit hostingaccount. Als u FTP-toegang hebt tot een ander account op deze server, gebruik dan de optie FTP-opslag.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'De bestanden van de site kopiëren naar een andere site die op deze server wordt gehost.',
    'web.site-copy.destinationTypeSiteSelect' => 'Sitenaam',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Bestanden van de site %%source%% kunnen niet worden gekopieerd naar %%destination%%, omdat %%destination%% deel uitmaakt van deze bestanden -- de hoofdmap hiervan is een submap van de hoofdmap van %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Bestanden van de site %%destination%% kunnen niet worden verwijderd, omdat de %%source%%-bestanden hier onderdeel van uitmaken -- de hoofdmap van %%source%% is een submap van %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'FTP-opslag',
    'web.site-copy.destinationTypeFtpDescription' => 'Bestanden van website kopiëren naar een FTP-account op deze of op een externe server.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Bestanden van website kopiëren naar een FTP-account op een externe server.',
    'web.site-copy.destinationTypeFtpHost' => "Hostnaam van server",
    'web.site-copy.destinationTypeFtpPort' => "Poort",
    'web.site-copy.destinationTypeFtpFolder' => 'Map',
    'web.site-copy.destinationTypeFtpUser' => 'Gebruikersnaam',
    'web.site-copy.destinationTypeFtpPassword' => 'Wachtwoord',
    'web.site-copy.destinationTypeFtpMode' => 'Verbindingsmethode FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Actieve modus',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'In de actieve modus verstuurt Plesk het IP-adres en poortnummer waarop het luistert naar een externe server; de server initieert de TCP-verbinding. Deze modus wordt aanbevolen wanneer de door Plesk beheerde server niet wordt beschermd door een firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Passieve modus',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'De passieve modus kan worden gebruikt als de door Plesk-beheerde server zich achter een firewall bevindt en geen inkomende TCP-verbindingen kan accepteren.',
    'web.site-copy.existingFiles' => 'Wat te doen met bestaande bestanden',
    'web.site-copy.existingFilesKeep' => 'Houd bestaande bestanden op de site van bestemming',
    'web.site-copy.existingFilesKeepDescription' => 'Bestaande bestanden met dezelfde naam overschrijven op de site van bestemming.',
    'web.site-copy.existingFilesDelete' => 'Alle bestaande bestanden verwijderen',
    'web.site-copy.existingFilesDeleteDescription' => 'Voor het kopiëren eerst alle bestanden op de site van bestemming verwijderen.',
    'web.site-copy.emptyLogin' => 'Geef de gebruikersnaam van een FTP-account op.',
    'web.site-copy.emptyHost' => 'Geef de hostnaam van een server op.',
    'web.site-copy.emptyPort' => 'Geef een poort op van de hostserver.',
    'web.site-copy.copyInProgress' => 'Kopiëren van de website %%sourceName%% naar %%destinationName%%. U wordt van de voortgang op de hoogte gehouden via e-mail (%%email%%).',
    'web.site-copy.unableToCopy' => 'Kopiëren van de bestanden van de website is mislukt.',
    'web.site-copy.siteCopied' => 'De bestanden van de website zijn gekopieerd.',
    'web.site-copy.emailSubjSuccess' => 'De bestanden van de website "%%source%%" zijn gekopieerd.',
    'web.site-copy.emailSubjFailure' => 'Kopiëren van de bestanden van de website "%%source%%" is mislukt.',
    'web.site-copy.emailBodySuccess' => 'De bestanden van de website "%%source%%" zijn gekopieerd naar "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Kopiëren van de bestanden van de website "%%source%%" naar "%%destination%%" is mislukt: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Doorschakel-instellingen',
    'web._shared.forwardDestination' => 'Adres van bestemming',
    'web._shared.forwardDestinationHint' => 'URL van de website van bestemming.',
    'web._shared.forwardingTypeOptions' => 'Type doorschakeling',
    'web._shared.forwardingFrame' => 'Doorschakelen via frame',
    'web._shared.forwardingFrameHint' => 'Bezoekers doorschakelen naar een andere website, maar daarbij het adres van bestemming niet weergeven zodat de bezoekers niets van de doorschakeling weten.',
    'web._shared.forwardingHttpCode301' => 'Permanent verplaatst (code 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Bezoekers doorschakelen naar een andere website, waarbij zij het adres van bestemming kunnen zien. Op deze manier blijft de waarde van de site in zoekmachines behouden.',
    'web._shared.forwardingHttpCode302' => 'Tijdelijk verplaatst (code 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Leid bezoekers van de website om naar een tijdelijke kopie van de site als u niet wilt dat zoekmachines deze tijdelijke site in hun index opnemen.',
    'web._shared.documentRoot' => 'Hoofdmap (root)',
    'web._shared.documentRootHint' => 'Het zoekpad naar de startpagina van de website.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Het is niet mogelijk om een hoofdmap (root) te wijzigen, omdat er op deze website webtoepassingen zijn geïnstalleerd.',
    'web._shared.ipAddress' => 'IP-adres',
    'web._shared.shared' => 'gedeeld',
    'web._shared.exclusive' => 'exclusief',
    'web._shared.ipAddressHint' => "Het IP-adres waarop de website wordt gehost is een netwerkadres van de virtuele host van de website.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (andere opslag)',
    'web._shared.certificate' => 'Certificaat',
    'web._shared.sameCertificatesHint' => 'Het selecteerde certificaat zal worden gebruikt voor alle sites die op hetzelfde exclusieve IP-adres worden gehost.',
    'web._shared.differentCertificatesHint' => 'Dit abonnement is gekoppeld aan twee exclusieve IP-adressen met twee verschillende certificaten. Het geselecteerde certificaat zal alle certificaten vervangen die zijn geïnstalleerd op sites die op deze twee IP-adressen worden gehost.',
    'web._shared.differentIpTypesCertificateHint' => 'Dit abonnement is gekoppeld aan één gedeeld en één exclusief IP-adres. Het geselecteerde certificaat zal ook worden gebruikt voor alle andere sites die op het exclusieve IP-adres worden gehost.',
    'web._shared.certificateNotSelected' => 'Niet geselecteerd',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'In uw opslag bevinden zich geen SSL/TLS-certificaten. Als u een certificaat wilt toevoegen gaat u naar %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'deze pagina',

    'web-user.settings.allowScripts' => 'Gebruik van scripts door webgebruikers toestaan',

    'web-user.name' => 'Gebruikersnaam voor het maken van verbinding met de server via FTP',
    'web-user.longName' => 'Deze gebruikersnaam is te lang (max. %max% tekens zijn toegestaan).',
    'web-user.password' => 'Wachtwoord',
    'web-user.passwordConfirmation' => 'Bevestig wachtwoord',
    'web-user.hardDiskQuota' => 'Harde beperking domein',
    'web-user.hardDiskQuotaUnlimited' => 'Onbeperkt',
    'web-user.hardDiskQuotaIsNotSupported' => '(Harde beperking van schijfruimte wordt niet ondersteund vanwege de instellingen van het bestandssysteem van de server.)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Vereiste velden',
];