<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "تم رفض الوصول. تم تعليق حسابك.",
    'login_up__login_has_been_locked' => "لقد حاولت تسجيل الدخول باستخدام كلمة مرور خاطئة في الكثير من المرات. لأسباب تتعلق بالأمان، لن تتمكن من تسجيل الدخول باسم المستخدم هذا لبعض الوقت.",
    'login_up__login_label_plesk' => "تسجيل الدخول إلى 1%", // PFU
    'login_up__login_label_parallels' => "تسجيل الدخول إلى Plesk %1",
    'login_up__login_text' => "أدخل كلمة المرور واسم المستخدم.",
    'login_up__unable_to_check_pass' => "يتعذر فحص كلمة المرور: 1%",
    'login_up__warning_limits_licence_key' => "‫لقد تجاوز أحد العناصر التالية الحد المقرر بواسطة مفتاح الترخيص: وهو عدد حسابات المستخدم، والمجالات أو حسابات البريد الإلكتروني أو مستخدمو الويب المستضافون على الخادم الخاص بك.‬\n‫يُرجى الاتصال بقسم مبيعات Plesk من أجل شراء مفتاح يتيح لك استضافة العدد المرغوب فيه من المستخدمين والمجالات.‬ ‫يُرجى الاتصال بقسم الدعم الفني لـ Plesk إذا شعرت بأنك قد تسلمت هذه الرسالة عن طريق الخطأ.‬\n‫الحد المسموح به لحسابات المستخدم/المجالات/حسابات البريد/مستخدمو الويب/حزم اللغات: %2.‬\n‫عدد حسابات المستخدم/المجالات/حسابات البريد الإلكتروني/مستخدمي الويب/حزم اللغات المستضافة حاليًا: %3.‬", // PFW
    'login_up__short_warning_limits_licence_key' => "‫كمية الموارد التي تقوم بالتشغيل باستخدامها تجاوزت الحدود المقررة حسب ترخيص منتجك الحالي.‬ ‫يُرجى الاتصال بقسم مبيعات Plesk وشراء مفتاح ترخيص جديد.‬",
    'login_up__grace_period' => 'أنت تقوم بالتشغيل حاليًا خلال فترة السماح لترخيص منتجك. لتحديث ترخيص منتجك، حدد خيار Retrieve Keys (استرداد المفاتيح) في %1صفحة معلومات الترخيص2%.',
    'login_up__partner_license_message' => 'أنت تقوم بالتشغيل الآن باستخدام ترخيص منتج محدود يتطلب التسجيل قبل التنشيط إلى مجموعة الميزات الكاملة. لتحديث ترخيص منتجك، حدد خيار Retrieve Keys (استرداد المفاتيح) في 1%صفحة إدارة الترخيص2%.',
    'login_up__system_admin_disabled' => 'المستخدم المسؤول (حساب المسؤول أو الجذر) محظور من التسجيل إلى Plesk لأسباب تتعلق بالأمان.',
    'login_up__mobile_application_message' => 'للحصول على تجربة أفضل، نوصيك بتثبيت تطبيق %%name%%.',
    'login_up__mobile_application_install' => '‫تثبيت الآن‬',
    'login_up__mobile_application_hide' => '‫لا، شكرًا‬',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "دليل مسؤول Plesk",
    'plesk_guide_reseller' => "دليل بائع التجزئة لـ Plesk",
    'plesk_guide_client' => "دليل عميل Plesk",
    'plesk_guide_domain_admin' => "دليل مسؤول مجال Plesk",
    'plesk_guide_mailuser' => "دليل مستخدم البريد الإلكتروني لـ Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'بحث', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'العملاء',
    'ui__reseller_unknown__quick-search' => 'بائعو التجزئة',
    'ui__client/domain_unknown__quick-search' => 'المجالات',
    'nav__general' => 'القائمة الرئيسية',
    '__home' => 'الصفحة الرئيسية',
    '__resellers' => 'بائعو التجزئة',
    '__clients' => 'العملاء',
    '__domains' => 'المجالات',
    '__applications' => 'تطبيقات',
    '__settings' => 'الإعدادات',
    'nav__system' => 'النظام',
    '__master' => 'رئيسي',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'المستوى الأعلى',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'إزالة',
    'bt_make_default' => 'تعيين كافتراضي',

    // common list object operation errors
    'class_cList__empty_selection' => 'لم يتم تحديد أي كائنات.',

    // common list object search keys
    'clist__search_show' => 'إظهار البحث',
    'clist__search_hide' => 'إخفاء البحث',

    'bt_show_all' => "إعادة تعيين البحث",

    // common object list info keys
    'clist__first' => 'الأول',
    'clist__last' => 'آخر',
    'clist__prev' => '&gt;&gt;',
    'clist__next' => '/&gt;&gt;',
    'clist__page' => 'الصفحات',
    'clist__page_size' => 'المدخلات حسب الصفحة',
    'clist__info' => 'الإجمالي 1%: %4',
    'clist__info_empty' => 'الرقم 1%',
    'clist__info_filter' => 'تم العثور على 5% 1% (الإجمالي 4%)',
    'clist__info_paging' => '2%-3% 1% من إجمالي 4%',
    'clist__info_paging_filter' => 'تم العثور على 2%-3% 1% من 5% (الإجمالي (4%)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'نشط',
    '__object_off' => 'معلّق',

    '__home_description' => 'العودة إلى الصفحة الرئيسية.',
    'indicator_title' => '%1% مُستخدم، %2% فارغ', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'تم طلب عنوان URL غير صالح.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "حسابات بائع التجزئة",
    'ui__reseller_unknown__title' => "حسابات بائع التجزئة",
    'ui__reseller_unknown__description' => "إدارة حسابات بائع التجزئة.",
    'ui__reseller/client_unknown__short-title' => 'حسابات العميل',
    'ui__reseller/client_unknown__title' => 'حسابات العميل',
    'ui__reseller/client_unknown__description' => 'إدارة حسابات العملاء.',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => 'تعيين مالك جديد لحسابات العميل',
    'ui__reseller/client/chowner_multi-select__short-title' => 'تعيين مالك جديد',
    'ui__reseller/client/chowner_multi-select__description' => 'تعيين مالك جديد لحسابات العميل المحددة.',
    'ui__client/to-reseller_multi__title' => 'تحويل حسابات العميل إلى حسابات بائع تجزئة',
    'ui__client/to-reseller_multi__short-title' => 'تحويل إلى بائعي التجزئة',
    'ui__client/to-reseller_multi__description' => 'تحويل حسابات العميل المحددة إلى حسابات بائع تجزئة.',
    'ui__reseller/to-client_multi__title' => 'تحويل حسابات بائعي التجزئة إلى حسابات العملاء',
    'ui__reseller/to-client_multi__short-title' => 'تحويل إلى العملاء',
    'ui__reseller/to-client_multi__description' => 'تحويل حسابات بائع التجزئة المحدد إلى حسابات عميل',
    'ui__admin-alias_unknown__title' => "حسابات المسؤول الإضافية", // PFW
    'ui__admin-alias_unknown__short-title' => "حسابات المسؤول الإضافية", // PFW
    'ui__admin-alias_unknown__description' => "عرض حسابات المسؤول الإضافية وإدارتها.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "إعدادات خادم البريد",
    'ui__server/mail__title' => "إعدادات خادم البريد",
    'ui__server/mail__description' => "إعداد خادم البريد الخاص بك وتكوين إعدادات البريد على مستوى الخادم.",
    'ui__server/dns__short-title' => 'إعدادات DNS',
    'ui__server/dns__title' => 'إعدادات DNS',
    'ui__server/dns__description' => 'مراجعة وتحديث إعدادات DNS على مستوى الخادم.',
    'ui__server/components__short-title' => 'مكونات الخادم',
    'ui__server/components__title' => 'مكونات الخادم',
    'ui__server/components__description' => 'عرض المعلومات حول مكونات النظام المثبتة على الخادم والتي يستخدمها Plesk.',
    'ui__server/services__short-title' => 'إدارة الخدمات',
    'ui__server/services__title' => 'إدارة الخدمات',
    'ui__server/services__description' => 'بدء خدمات Plesk أو إيقافها أو إعادة تشغيلها.',
    'ui__server/crontab/task_unknown__short-title' => 'المهام المجدولة',
    'ui__server/crontab/task_unknown__title' => 'المهام المجدولة',
    'ui__server/crontab/task_unknown__description' => 'إضافة أو إزالة المهام المجدولة على مستوى الخادم.',
    'ui__server/ip-address_unknown__short-title' => 'عناوين IP',
    'ui__server/ip-address_unknown__title' => 'عناوين IP',
    'ui__server/ip-address_unknown__description' => 'عرض عناوين IP وإضافتها وإزالتها، وتعيين عناوين IP إلى بائعي التجزئة.',
    'ui__promotion/smartermail__short-title' => 'تنزيل SmarterMail',
    'ui__promotion/smartermail__title' => 'تنزيل SmarterMail',
    'ui__promotion/smartermail__description' => '‫فتح نافذة جديدة باستخدام موقع SmarterMail الإلكتروني حيث يمكنك تنزيل أحدث إصدار من خادم بريد SmarterMail.‬ ‫قامت شركة SmarterTools Inc بإنشاء موقع SmarterMail الإلكتروني ودعمه.‬ ‫لا تُعد شركة Plesk مسؤولة قانونيًا عن محتويات موقع SmarterMail الإلكتروني، كما لا توفر دعمًا لخادم البريد SmarterMail Lite.‬',
    // dropdowns
    'ui__server/time__title' => 'وقت النظام',
    'ui__server/time__short-title' => 'وقت النظام',
    'ui__server/time__description' => 'تغيير وقت وتاريخ الخادم، وإعداد المزامنة مع خادم NTP.',
    'ui__server/odbc__title' => 'مصادر بيانات ODBC', // PFW
    'ui__server/odbc__short-title' => 'مصادر بيانات ODBC', // PFW
    'ui__server/odbc__description' => 'إعداد مصادر بيانات ODBC.', // PFW
    'ui__server/ftp-settings__short-title' => "إعدادات FTP", // PFW
    'ui__server/ftp-settings__title' => "إعدادات FTP", // PFW
    'ui__server/ftp-settings__description' => "تكوين إعدادات FTP على مستوى الخادم.", // PFW
    'ui__server/maillists__title' => 'إعداد خادم قوائم المراسلة', // PFU
    'ui__server/maillists__short-title' => 'إعداد خادم قوائم المراسلة', // PFU
    'ui__server/maillists__description' => 'إعداد خادم قوائم المراسلة لـ Mailman.', // PFU
    'ui__mass-email__short-title' => "رسائل البريد الإلكتروني الجماعية", // PFW
    'ui__mass-email__title' => "رسائل البريد الإلكتروني الجماعية", // PFW
    'ui__mass-email__description' => "إرسال رسائل البريد الإلكتروني للعديد من المستخدمين في وقت واحد.", // PFW
    'ui__mass-mail__title' => 'رسائل البريد الإلكتروني الجماعية', // PFU
    'ui__mass-mail__short-title' => 'رسائل البريد الإلكتروني الجماعية', // PFU
    'ui__mass-mail__description' => 'إرسال رسائل البريد الإلكتروني للعديد من المستخدمين في وقت واحد.', // PFU
    'ui__server/spam-filter__title' => 'إعدادات تصفية البريد العشوائي',
    'ui__server/spam-filter__short-title' => 'إعدادات تصفية البريد العشوائي',
    'ui__server/spam-filter__description' => 'إعداد عامل تصفية البريد العشوائي للخادم.',
    'ui__server/preferences__title' => "إعدادات الخادم",
    'ui__server/preferences__short-title' => "إعدادات الخادم",
    'ui__server/preferences__description' => "إعداد حساب إحصائيات الخادم، وتغيير اسم مضيف الخادم وتغيير إعدادات الخادم الأخرى.",

    // help & support
    // icons
    'ui__support__short-title' => 'الدعم',
    'ui__support__title' => 'الدعم',
    'ui__support__description' => 'إرسال طلب للحصول على الدعم الفني أو مراجعة تذاكر الدعم التي أنشأها عملاؤك.',
    'ui__license__short-title' => 'معلومات الترخيص',
    'ui__license__title' => 'معلومات ترخيص منصة Plesk',
    'ui__license__description' => 'عرض المعلومات حول ترخيص Plesk وطلب مفاتيح ترخيص جديدة.',
    'ui__help__short-title' => 'التعليمات',
    'ui__help__title' => 'التعليمات عبر الإنترنت',
    'ui__help__description' => 'عرض التعليمات عبر الإنترنت.',
    'ui__news__short-title' => "ما هو جديد",
    'ui__news__title' => "ما هو جديد",
    'ui__news__description' => "راجع قائمة بالتغييرات في هذا الإصدار من Plesk.",
    'ui__server/autoinstaller__short-title' => 'التحديثات',
    'ui__server/autoinstaller__title' => 'التحديثات',
    'ui__server/autoinstaller__description' => 'تحديث Plesk ومكوناته.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'المجالات',
    'ui__client/domain_unknown__title' => 'المجالات',
    'ui__client/domain_unknown__description' => 'إدارة المجالات.',
    'ui__server/skeleton__short-title' => 'قالب المضيف الظاهري',
    'ui__server/skeleton__title' => 'قالب المضيف الظاهري',
    'ui__server/skeleton__description' => 'حدد الملفات والمجلدات التي يجب وضعها في الدلائل الخاصة بالمجالات التي تم إنشاؤها حديثًا.',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => 'إنشاء مجال',
    'ui__client/domain/properties_unknown-new__short-title' => 'إنشاء مجال',
    'ui__client/domain/properties_unknown-new__description' => 'إنشاء المجال وتكوينه.',
    'ui__client/domain/chowner_multi-select__title' => 'تعيين مالك جديد للاشتراكات',
    'ui__client/domain/chowner_multi-select__short-title' => 'تعيين مالك جديد للاشتراك',
    'ui__client/domain/chowner_multi-select__description' => 'تعيين مالك جديد للاشتراكات المحددة.',
    'ui__client/domain/to-client_multi__title' => 'تحويل حسابات مسؤول المجال إلى حسابات العميل',
    'ui__client/domain/to-client_multi__short-title' => 'تحويل إلى العملاء',
    'ui__client/domain/to-client_multi__description' => 'تحويل حسابات مسؤول المجال المحدد إلى حسابات العميل',
    'ui__client/domain/disable_multi__title' => 'تعليق المجالات',
    'ui__client/domain/disable_multi__short-title' => 'تعليق المجالات',
    'ui__client/domain/disable_multi__description' => 'تعليق المجالات المحددة',
    'ui__client/domain/enable_multi__title' => 'تنشيط المجالات',
    'ui__client/domain/enable_multi__short-title' => 'تنشيط المجالات',
    'ui__client/domain/enable_multi__description' => 'تنشيط المجالات المحددة',

    // icons
    'ui__admin/extras-domain__short-title' => 'أدوات من MyPlesk.com',
    'ui__admin/extras-domain__title' => 'أدوات من MyPlesk.com',
    'ui__admin/extras-domain__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'إعدادات ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'إعدادات ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'تكوين إعدادات ASP.NET على مستوى الخادم.', // PFW
    'ui__server/sitebuilder__short-title' => 'إعدادات Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'إعدادات Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'إعداد Presence Builder من أجل تعديل مواقع الويب المستضافة على هذا الخادم.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'تسجيل المجال',
    'ui__admin/register-domain__short-title' => 'تسجيل المجال',
    'ui__admin/register-domain__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'إدارة المجالات',
    'ui__admin/manage-domain__short-title' => 'إدارة المجالات',
    'ui__admin/manage-domain__description' => 'إدارة أسماء المجال المسجلة من خلال MyPlesk.com.',
    'ui__server/register__title' => 'تسجيل الخادم الخاص بك',
    'ui__server/register__short-title' => 'تسجيل الخادم',
    'ui__server/register__description' => 'تسجيل الخادم لكي ينضم إلى برنامج تابع',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'سجل الإجراء',
    'ui__actionlog__title' => 'سجل الإجراء',
    'ui__actionlog__description' => 'تنزيل سجل الإجراء وإدارة إعدادات سجل الإجراء.',
    'ui__notification_unknown__short-title' => 'الإعلامات',
    'ui__notification_unknown__title' => 'الإعلامات',
    'ui__notification_unknown__description' => 'عرض الإعلامات وتعديلها المُرسلة وفقًا لأحداث Plesk المهمة.',
    'ui__server/resources__short-title' => 'استخدام الموارد',
    'ui__server/resources__title' => 'استخدام الموارد',
    'ui__server/resources__description' => 'عرض استخدام موارد النظام.',
    // dropdowns
    'ui__server/statistics__short-title' => 'معلومات الخادم',
    'ui__server/statistics__title' => 'معلومات الخادم',
    'ui__server/statistics__description' => 'إحصائيات حول الخدمات المُدارة بواسطة Plesk.',
    'ui__admin/report__title' => 'تقرير التلخيص',
    'ui__admin/report__short-title' => 'تقرير التلخيص',
    'ui__admin/report__description' => 'عرض تقرير حول استخدام حركة مرور البيانات والموارد لبائعي التجزئة والعملاء والمجالات.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'وقت وضع الخمول للجلسة',
    'ui__sessions/properties__title' => 'وقت وضع الخمول للجلسة',
    'ui__sessions/properties__description' => 'تعيين وقت الخمول لجلسات عمل Plesk.',
    'ui__cp-access__short-title' => 'الوصول إلى Plesk',
    'ui__cp-access__title' => 'الوصول إلى Plesk',
    'ui__cp-access__description' => 'تقييد الوصول إلى Plesk.',
    'ui__sessions__short-title' => 'جلسات العمل النشطة',
    'ui__sessions__title' => 'جلسات العمل النشطة',
    'ui__sessions__description' => 'عرض جلسات عمل Plesk النشطة.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'شهادات SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'شهادات SSL/TLS',
    'ui__server/certificate_unknown__description' => 'قائمة شهادات SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'البيانات الشخصية',
    'ui__admin-info__title' => 'البيانات الشخصية',
    'ui__admin-info__description' => 'تغيير البيانات الشخصية لحسابك.',
    'ui__admin-password__short-title' => 'تغيير كلمة المرور',
    'ui__admin-password__title' => 'تغيير كلمة المرور',
    'ui__admin-password__description' => 'تغيير كلمة المرور لحسابك.',
    'ui__admin/interface__short-title' => 'تفضيلات الواجهة',
    'ui__admin/interface__title' => 'تفضيلات الواجهة',
    'ui__admin/interface__description' => 'تغيير تفضيلات الواجهة لمسؤول الخادم.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'إدارة الملفات',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'إدارة الملفات',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'تعامل مع الملفات والدلائل عن طريق إدارة الملفات.',
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'الطرف SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'الطرف SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'استخدم الطرف SSH للوصول إلى الخادم.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'أدلة محمية بكلمة مرور',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'أدلة محمية بكلمة مرور',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'حماية الوصول إلى مناطق موقع الويب المحدد.',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => 'إنشاء أدلة ظاهرية وإدارتها على مجال معين.', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'تعامل مع الملفات والدلائل الفعلية والظاهرية في موقع إلكتروني.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => 'إحصائيات الويب',
    'ui__client/domain/report/web-stats_unknown__title' => 'إحصائيات الويب',
    'ui__client/domain/report/web-stats_unknown__description' => 'عرض إحصائيات زيارات موقع الويب.',
    'ui__reseller/limits__short-title' => 'استخدام الموارد',
    'ui__reseller/limits__title' => 'استخدام الموارد',
    'ui__reseller/limits__description' => 'عرض وإدارة استخدام المورد الخاص ببائع التجزئة 1%.',
    'ui__reseller/limits_unknown__short-title' => 'استخدام الموارد',
    'ui__reseller/limits_unknown__title' => 'استخدام الموارد',
    'ui__reseller/limits_unknown__description' => 'عرض وإدارة استخدام المورد الخاص ببائع التجزئة.',
    'ui__reseller/limits_self__short-title' => 'استخدام الموارد',
    'ui__reseller/limits_self__title' => 'استخدام الموارد',
    'ui__reseller/limits_self__description' => "عرض استخدام المورد الخاص بك وإدارته.",
    'ui__reseller/limits_readonly-self__short-title' => 'استخدام الموارد',
    'ui__reseller/limits_readonly-self__title' => 'استخدام الموارد',
    'ui__reseller/limits_readonly-self__description' => "عرض استخدام المورد الخاص بك.",
    'ui__reseller/client/traffic_unknown__short-title' => 'استخدام حركة مرور البيانات بواسطة العملاء',
    'ui__reseller/client/traffic_unknown__title' => 'عرض استخدام حركة مرور البيانات بواسطة العملاء',
    'ui__reseller/client/traffic_unknown__description' => 'عرض تقارير استخدام حركة مرور البيانات لحسابات العميل.',
    'ui__client/traffic_unknown__short-title' => "استخدام حركة مرور البيانات بواسطة العملاء", // temporary for presets
    'ui__client/traffic_unknown__title' => "عرض استخدام حركة مرور البيانات بواسطة العملاء", // temporary for presets
    'ui__client/traffic_unknown__description' => "عرض تقارير استخدام حركة مرور البيانات لحسابات العميل.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'إدارة السجل',
    'ui__client/domain/hosting/logs_unknown__title' => 'إدارة السجل',
    'ui__client/domain/hosting/logs_unknown__description' => 'عرض السجلات وتدوير سجل التكوين.',
    // dropdowns
    'ui__reseller/report__title' => 'تقرير التلخيص',
    'ui__reseller/report__short-title' => 'تقرير التلخيص',
    'ui__reseller/report__description' => 'عرض تقرير حول استخدام حركة مرور والموارد الخاصة ببائع التجزئة هذا.',
    'ui__reseller/report_unknown__title' => 'تقرير التلخيص',
    'ui__reseller/report_unknown__short-title' => 'تقرير التلخيص',
    'ui__reseller/report_unknown__description' => 'عرض تقرير حول استخدام حركة مرور والموارد الخاصة ببائع التجزئة.',
    'ui__reseller/report_self__title' => 'تقرير التلخيص',
    'ui__reseller/report_self__short-title' => 'تقرير التلخيص',
    'ui__reseller/report_self__description' => 'عرض تقرير حول استخدام حركة مرور البيانات والموارد الخاصة بك.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'علامة Plesk التجارية',
    'ui__client/logo_reseller__short-title' => 'علامة Plesk التجارية',
    'ui__client/logo_reseller__description' => 'إعادة وضع علامة Plesk التجارية لبائع التجزئة 1%.',
    'ui__client/logo_unknown__title' => 'علامة Plesk التجارية', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'علامة Plesk التجارية', // temporary for presets
    'ui__client/logo_unknown__description' => 'إعادة وضع علامة Plesk التجارية.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'علامة Plesk التجارية',
    'ui__client/logo_self-reseller__short-title' => 'علامة Plesk التجارية',
    'ui__client/logo_self-reseller__description' => 'إعادة وضع علامة Plesk التجارية.',
    'ui__reseller/permissions__title' => 'الأذونات',
    'ui__reseller/permissions__short-title' => 'الأذونات',
    'ui__reseller/permissions__description' => "عرض أو تغيير الإجراءات التي يمكن أن يجريها بائع التجزئة 1% في Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'الأذونات',
    'ui__reseller/permissions_unknown__title' => 'الأذونات',
    'ui__reseller/permissions_unknown__description' => "عرض أو تغيير الإجراءات التي يمكن أن يجريها بائع التجزئة في Plesk.",
    'ui__reseller/permissions_self__title' => 'الأذونات',
    'ui__reseller/permissions_self__short-title' => 'الأذونات',
    'ui__reseller/permissions_self__description' => 'عرض قائمة بالإجراءات التي يمكنك القيام بها في Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'الأذونات',
    'ui__reseller/permissions_readonly-self__short-title' => 'الأذونات',
    'ui__reseller/permissions_readonly-self__description' => 'عرض قائمة بالإجراءات التي يمكنك القيام بها في Plesk.',
    // dropdowns
    'ui__reseller/to-client__title' => 'تحويل حساب بائع التجزئة إلى حساب عميل',
    'ui__reseller/to-client__short-title' => 'تحويل بائع التجزئة إلى عميل',
    'ui__reseller/to-client__description' => 'تحويل حساب بائع التجزئة هذا إلى حساب عميل.',
    'ui__reseller/to-client_unknown__title' => 'تحويل حساب بائع التجزئة إلى حساب عميل',
    'ui__reseller/to-client_unknown__short-title' => 'تحويل بائع التجزئة إلى عميل',
    'ui__reseller/to-client_unknown__description' => 'تحويل حساب بائع التجزئة إلى حساب عميل.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'قالب المضيف الظاهري',
    'ui__client/skeleton__short-title' => 'قالب المضيف الظاهري',
    'ui__client/skeleton__description' => 'حدد الملفات والمجلدات التي يجب وضعها في الدلائل الخاصة بالمجالات التي تم إنشاؤها حديثًا.',
    'ui__client/skeleton_unknown__short-title' => 'قالب المضيف الظاهري',
    'ui__client/skeleton_unknown__title' => 'قالب المضيف الظاهري',
    'ui__client/skeleton_unknown__description' => 'حدد الملفات والمجلدات التي يجب وضعها في الدلائل الخاصة بالمجالات التي تم إنشاؤها حديثًا.',
    // dropdowns
    'ui__client/domain/properties_new__title' => 'إنشاء مجال',
    'ui__client/domain/properties_new__short-title' => 'إنشاء مجال',
    'ui__client/domain/properties_new__description' => "أنشئ مجالاً لـ 1%.",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'الأسماء المستعارة للمجالات',
    'ui__client/domain/domain-alias_unknown__title' => 'الأسماء المستعارة للمجالات',
    'ui__client/domain/domain-alias_unknown__description' => 'عرض قائمة بالأسماء البديلة لمجالك.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'إعدادات DNS',
    'ui__client/domain/dns_unknown__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_unknown__description' => 'إدارة إعدادات منطقة DNS الخاصة بمجال معين.',
    'ui__client/domain/dns_readonly-unknown__title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'عرض إعدادات منطقة DNS الخاصة بمجال معين.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'أدوات من MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'أدوات من MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'أدوات من MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'أدوات من MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'أدوات من MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'أدوات من MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__client/domain/odbc_unknown__short-title' => 'مصادر بيانات ODBC', // PFW
    'ui__client/domain/odbc_unknown__title' => 'مصادر بيانات ODBC', // PFW
    'ui__client/domain/odbc_unknown__description' => 'قم بإعداد مصادر بيانات ODBC لمجال معين.', // PFW
    'ui__reseller/register-domain__short-title' => 'تسجيل المجال',
    'ui__reseller/register-domain__title' => 'تسجيل المجال',
    'ui__reseller/register-domain__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'تسجيل المجال',
    'ui__reseller/register-domain_unknown__title' => 'تسجيل المجال',
    'ui__reseller/register-domain_unknown__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'تسجيل المجال',
    'ui__reseller/register-domain_self__title' => 'تسجيل المجال',
    'ui__reseller/register-domain_self__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'إدارة المجالات',
    'ui__reseller/manage-domain__short-title' => 'إدارة المجالات',
    'ui__reseller/manage-domain__description' => 'إدارة أسماء المجال المسجلة من خلال MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'إدارة المجالات',
    'ui__reseller/manage-domain_unknown__short-title' => 'إدارة المجالات',
    'ui__reseller/manage-domain_unknown__description' => 'إدارة أسماء المجال المسجلة من خلال MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'إدارة المجالات',
    'ui__reseller/manage-domain_self__short-title' => 'إدارة المجالات',
    'ui__reseller/manage-domain_self__description' => 'إدارة أسماء المجال المسجلة من خلال MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'عناوين IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'عناوين IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'إدارة عناوين IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'شهادات SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'شهادات SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'قم بتثبيت وإدارة شهادات SSL/TLS.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'حماية الارتباط السريع', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'حماية الارتباط السريع', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'قم بحماية الملفات من الارتباط السريع.', // PFW
    'ui__reseller/sessions__short-title' => 'جلسات العمل النشطة',
    'ui__reseller/sessions__title' => 'جلسات العمل النشطة',
    'ui__reseller/sessions__description' => 'عرض جلسات عمل Plesk النشطة.',
    'ui__reseller/sessions_unknown__short-title' => 'جلسات العمل النشطة',
    'ui__reseller/sessions_unknown__title' => 'جلسات العمل النشطة',
    'ui__reseller/sessions_unknown__description' => 'عرض جلسات عمل Plesk النشطة.',
    'ui__reseller/sessions_self__short-title' => 'جلسات العمل النشطة',
    'ui__reseller/sessions_self__title' => 'جلسات العمل النشطة',
    'ui__reseller/sessions_self__description' => 'عرض جلسات عمل Plesk النشطة.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_unknown__title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_unknown__description' => 'عرض وضبط الحد على استخدام النطاق الترددي لمجالك وعدد الاتصالات المتزامنة بموقع ويب معين.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'عرض الحد على استخدام النطاق الترددي لمجالك وعدد الاتصالات المتزامنة بموقع ويب معين.',
    'ui__client/domain/hosting/php_unknown__short-title' => 'إعدادات PHP', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'إعدادات PHP', // PFW
    'ui__client/domain/hosting/php_unknown__description' => 'تكوين PHP على مجال معين.', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'حسابات البريد ضِمن حساب المستخدم 1%',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'قالب المضيف الظاهري',
    'ui__client/skeleton_self__title' => 'قالب المضيف الظاهري',
    'ui__client/skeleton_self__description' => 'حدد الملفات والمجلدات التي يجب وضعها في الدلائل الخاصة بالمجالات التي تم إنشاؤها حديثًا.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'استخدام الموارد',
    'ui__client/limits__title' => 'استخدام الموارد',
    'ui__client/limits__description' => "عرض وإدارة استخدام المورد الخاص بالعميل 1%.",
    'ui__client/limits_unknown__short-title' => 'استخدام الموارد',
    'ui__client/limits_unknown__title' => 'استخدام الموارد',
    'ui__client/limits_unknown__description' => 'عرض وإدارة استخدام المورد الخاص بالعميل.',
    'ui__client/limits_readonly__short-title' => 'استخدام الموارد',
    'ui__client/limits_readonly__title' => 'استخدام الموارد',
    'ui__client/limits_readonly__description' => 'عرض استخدام المورد للعميل 1%.',
    'ui__client/limits_self__short-title' => 'استخدام الموارد',
    'ui__client/limits_self__title' => 'استخدام الموارد',
    'ui__client/limits_self__description' => "عرض استخدام المورد الخاص بك وإدارته.",
    'ui__client/limits_readonly-self__short-title' => 'استخدام الموارد',
    'ui__client/limits_readonly-self__title' => 'استخدام الموارد',
    'ui__client/limits_readonly-self__description' => "عرض استخدام المورد الخاص بك.",
    'ui__client/domain/traffic_unknown__short-title' => "استخدام حركة مرور البيانات بواسطة المجالات 1%",
    'ui__client/domain/traffic_unknown__title' => "عرض استخدام حركة مرور البيانات بواسطة المجالات",
    'ui__client/domain/traffic_unknown__description' => "عرض تقارير استخدام حركة مرور البيانات للمجالات.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'تقرير التلخيص',
    'ui__client/report__short-title' => 'تقرير التلخيص',
    'ui__client/report__description' => 'عرض تقرير حول استخدام حركة مرور والموارد لهذا العميل.',
    'ui__client/report_unknown__short-title' => 'تقرير التلخيص',
    'ui__client/report_unknown__title' => 'تقرير التلخيص',
    'ui__client/report_unknown__description' => 'عرض تقرير حول استخدام حركة مرور والموارد الخاصة بالعميل.',
    'ui__client/report_self__short-title' => 'تقرير التلخيص',
    'ui__client/report_self__title' => 'تقرير التلخيص',
    'ui__client/report_self__description' => 'عرض تقرير حول استخدام حركة مرور البيانات والموارد.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'تفضيلات الواجهة',
    'ui__client/preferences__title' => 'تفضيلات الواجهة',
    'ui__client/preferences__description' => 'تعيين تفضيلات واجهة Plesk للعميل 1%.',
    'ui__client/preferences_unknown__short-title' => 'تفضيلات الواجهة',
    'ui__client/preferences_unknown__title' => 'تفضيلات الواجهة',
    'ui__client/preferences_unknown__description' => "تعيين تفضيلات الواجهة لتطبيق Plesk الخاص بالعميل.",
    'ui__client/preferences_self__short-title' => 'تفضيلات الواجهة',
    'ui__client/preferences_self__title' => 'تفضيلات الواجهة',
    'ui__client/preferences_self__description' => 'تعيين تفضيلات الواجهة لتطبيق Plesk الخاص بك.',
    'ui__client/logo__title' => 'علامة Plesk التجارية',
    'ui__client/logo__short-title' => 'علامة Plesk التجارية',
    'ui__client/logo__description' => "إعادة وضع علامة Plesk التجارية للعميل s '\\1%",
    'ui__client/logo_self__title' => 'علامة Plesk التجارية',
    'ui__client/logo_self__short-title' => 'علامة Plesk التجارية',
    'ui__client/logo_self__description' => 'إعادة وضع علامة Plesk التجارية، وتغيير صورة الشعار وشريط عنوان المستعرض.',
    'ui__client/permissions__title' => 'الأذونات',
    'ui__client/permissions__short-title' => 'الأذونات',
    'ui__client/permissions__description' => "عرض أو تغيير الإجراءات التي يمكن أن يجريها العميل 1% في Plesk.",
    'ui__client/permissions_unknown__short-title' => 'الأذونات',
    'ui__client/permissions_unknown__title' => 'الأذونات',
    'ui__client/permissions_unknown__description' => "عرض أو تغيير الإجراءات التي يمكن أن يجريها العميل في Plesk.",
    'ui__client/permissions_self__title' => 'الأذونات',
    'ui__client/permissions_self__short-title' => 'الأذونات',
    'ui__client/permissions_self__description' => "عرض قائمة بالإجراءات التي يمكنك القيام بها في Plesk.",
    'ui__client/permissions_readonly-self__title' => 'الأذونات',
    'ui__client/permissions_readonly-self__short-title' => 'الأذونات',
    'ui__client/permissions_readonly-self__description' => "عرض قائمة بالإجراءات التي يمكنك القيام بها في Plesk.",
    // dropdowns
    'ui__client/chowner_select__title' => 'تعيين مالك جديد لحساب العميل',
    'ui__client/chowner_select__short-title' => 'تعيين مالك جديد للعميل',
    'ui__client/chowner_select__description' => 'قم بتعيين مالك جديد لحساب العميل.',
    'ui__client/chowner_unknown-select__short-title' => 'تعيين مالك جديد لحساب العميل',
    'ui__client/chowner_unknown-select__title' => 'تعيين مالك جديد للعميل',
    'ui__client/chowner_unknown-select__description' => 'تعيين مالك جديد لحساب العميل.',
    'ui__client/to-reseller__title' => 'تحويل حساب العميل إلى حساب بائع تجزئة',
    'ui__client/to-reseller__short-title' => 'تحويل العميل إلى بائع تجزئة',
    'ui__client/to-reseller__description' => 'تحويل حساب العميل هذا إلى حساب بائع تجزئة.',
    'ui__client/to-reseller_unknown__title' => 'تحويل حساب العميل إلى حساب بائع تجزئة',
    'ui__client/to-reseller_unknown__short-title' => 'تحويل العميل إلى بائع تجزئة',
    'ui__client/to-reseller_unknown__description' => 'تحويل حساب العميل هذا إلى حساب بائع تجزئة.',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'أدوات من MyPlesk.com',
    'ui__client/extras-domain__title' => 'أدوات من MyPlesk.com',
    'ui__client/extras-domain__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'أدوات من MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'أدوات من MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'أدوات من MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'أدوات من MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'تسجيل المجال',
    'ui__client/register-domain__short-title' => 'تسجيل المجال',
    'ui__client/register-domain__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'تسجيل المجال',
    'ui__client/register-domain_unknown__short-title' => 'تسجيل المجال',
    'ui__client/register-domain_unknown__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'تسجيل المجال',
    'ui__client/register-domain_self__short-title' => 'تسجيل المجال',
    'ui__client/register-domain_self__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'إدارة المجالات',
    'ui__client/manage-domain__short-title' => 'إدارة المجالات',
    'ui__client/manage-domain__description' => 'إدارة أسماء المجال المسجلة من خلال MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'إدارة المجالات',
    'ui__client/manage-domain_unknown__short-title' => 'إدارة المجالات',
    'ui__client/manage-domain_unknown__description' => 'إدارة أسماء المجال المسجلة من خلال MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'إدارة المجالات',
    'ui__client/manage-domain_self__short-title' => 'إدارة المجالات',
    'ui__client/manage-domain_self__description' => 'إدارة أسماء المجال المسجلة من خلال MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'عناوين IP',
    'ui__client/ipaddress_unknown__short-title' => "عناوين IP",
    'ui__client/ipaddress_unknown__description' => "إدارة عناوين IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'الأسماء المستعارة للمجالات',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'الأسماء المستعارة للمجالات',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'عرض قائمة بالأسماء البديلة لمجالك.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'جلسات العمل النشطة',
    'ui__client/sessions__title' => 'جلسات العمل النشطة',
    'ui__client/sessions__description' => 'عرض جلسات عمل Plesk النشطة.',
    'ui__client/sessions_unknown__short-title' => 'جلسات العمل النشطة',
    'ui__client/sessions_unknown__title' => 'جلسات العمل النشطة',
    'ui__client/sessions_unknown__description' => 'عرض جلسات عمل Plesk النشطة.',
    'ui__client/sessions_self__short-title' => 'جلسات العمل النشطة',
    'ui__client/sessions_self__title' => 'جلسات العمل النشطة',
    'ui__client/sessions_self__description' => 'عرض جلسات عمل Plesk النشطة.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'إدارة الملفات',
    'ui__client/domain/hosting/file-manager__title' => 'إدارة الملفات على المجال 1%',
    'ui__client/domain/hosting/file-manager__description' => "تعامل مع الملفات والدلائل على المجال 1% عن طريق إدارة الملفات.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'إدارة الملفات',
    'ui__client/domain/hosting/file-manager_self__title' => 'إدارة الملفات',
    'ui__client/domain/hosting/file-manager_self__description' => "تعامل مع ملفاتك والدلائل الخاصة بك عن طريق إدارة الملفات.",
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'الطرف SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'الطرف SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'استخدم الطرف SSH للوصول إلى الخادم.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'الطرف SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'الطرف SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'استخدم الطرف SSH للوصول إلى الخادم.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'أدلة محمية بكلمة مرور',
    'ui__client/domain/hosting/protected-directories__title' => 'أدلة محمية بكلمة مرور',
    'ui__client/domain/hosting/protected-directories__description' => 'حماية الوصول إلى مناطق موقع الويب المحدد.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'أدلة محمية بكلمة مرور',
    'ui__client/domain/hosting/protected-directories_self__title' => 'أدلة محمية بكلمة مرور',
    'ui__client/domain/hosting/protected-directories_self__description' => 'حماية الوصول إلى مناطق موقع الويب المحدد.',
    'ui__client/domain/hosting/virtual-directories__short-title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => 'إنشاء أدلة ظاهرية وإدارتها على المجال 1%.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => 'إنشاء أدلة ظاهرية وإدارتها على المجال الخاص بك.', // PFW
    'ui__client/domain/hosting/web-directories__title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'تعامل مع الملفات والدلائل الفعلية والظاهرية في الموقع 1%.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'أدلة ظاهرية', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'تعامل مع الملفات والدلائل الفعلية والظاهرية في موقعك الإلكتروني.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => 'إحصائيات الويب',
    'ui__client/domain/report/web-stats__title' => 'إحصائيات الويب',
    'ui__client/domain/report/web-stats__description' => 'عرض إحصائيات زيارات موقع الويب.',
    'ui__client/domain/report/web-stats_self__short-title' => 'إحصائيات الويب',
    'ui__client/domain/report/web-stats_self__title' => 'إحصائيات الويب',
    'ui__client/domain/report/web-stats_self__description' => 'عرض إحصائيات زيارات موقع الويب.',
    'ui__client/domain/traffic__short-title' => 'استخدام حركة مرور بيانات 1%',
    'ui__client/domain/traffic__title' => 'إحصائيات نقل البيانات للمجال 1%',
    'ui__client/domain/traffic__description' => 'عرض إحصائيات نقل البيانات للمجال 1%.',
    'ui__client/domain/traffic_self__short-title' => 'استخدام حركة مرور البيانات',
    'ui__client/domain/traffic_self__title' => 'عرض استخدام حركة مرور البيانات للمجال الخاص بك',
    'ui__client/domain/traffic_self__description' => 'عرض تقرير استخدام حركة مرور البيانات للمجال الخاص بك.',
    'ui__client/domain/hosting/logs__short-title' => 'إدارة السجل',
    'ui__client/domain/hosting/logs__title' => 'إدارة السجل',
    'ui__client/domain/hosting/logs__description' => 'عرض السجلات وتدوير سجل التكوين.',
    'ui__client/domain/hosting/logs_self__short-title' => 'إدارة السجل',
    'ui__client/domain/hosting/logs_self__title' => 'إدارة السجل',
    'ui__client/domain/hosting/logs_self__description' => 'عرض السجلات وتدوير سجل التكوين.',
    // dropdowns
    'ui__client/domain/report__title' => 'تقرير التلخيص',
    'ui__client/domain/report__short-title' => 'تقرير التلخيص',
    'ui__client/domain/report__description' =>  'عرض تقرير حول استخدام حركة مرور البيانات والموارد.',
    'ui__client/domain/report_unknown__short-title' => 'تقرير التلخيص',
    'ui__client/domain/report_unknown__title' => 'تقرير التلخيص',
    'ui__client/domain/report_unknown__description' => 'عرض تقرير حول استخدام حركة مرور البيانات والموارد.',
    'ui__client/domain/report_self__short-title' => 'تقرير التلخيص',
    'ui__client/domain/report_self__title' => 'تقرير التلخيص',
    'ui__client/domain/report_self__description' => 'عرض تقرير حول استخدام حركة مرور البيانات والموارد.',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => 'البيانات الشخصية',
    'ui__client/domain/properties__title' => 'البيانات الشخصية',
    'ui__client/domain/properties__description' => 'تغيير البيانات الشخصية لحساب مسؤول المجال.',
    'ui__client/domain/properties_unknown__short-title' => 'البيانات الشخصية',
    'ui__client/domain/properties_unknown__title' => 'البيانات الشخصية',
    'ui__client/domain/properties_unknown__description' => 'تغيير البيانات الشخصية للحساب.',
    'ui__client/domain/properties_self__short-title' => 'البيانات الشخصية',
    'ui__client/domain/properties_self__title' => 'البيانات الشخصية',
    'ui__client/domain/properties_self__description' => 'تغيير البيانات الشخصية لحسابك.',
    // dropdowns
    'ui__client/domain/rename__title' => 'إعادة تسمية مجال',
    'ui__client/domain/rename__short-title' => 'إعادة تسمية مجال',
    'ui__client/domain/rename__description' => 'إعادة تسمية المجال 1%.',
    'ui__client/domain/rename_unknown__short-title' => 'إعادة تسمية مجال',
    'ui__client/domain/rename_unknown__title' => 'إعادة تسمية مجال',
    'ui__client/domain/rename_unknown__description' => 'إعادة تسمية مجال',
    'ui__client/domain/chowner_select__title' => 'تعيين مالك جديد للمجال',
    'ui__client/domain/chowner_select__short-title' => 'تعيين مالك جديد للاشتراك',
    'ui__client/domain/chowner_select__description' => 'تعيين مالك جديد للاشتراك.',
    'ui__client/domain/chowner_unknown-select__short-title' => 'تعيين مالك جديد للاشتراك',
    'ui__client/domain/chowner_unknown-select__title' => 'تعيين مالك جديد للاشتراك',
    'ui__client/domain/chowner_unknown-select__description' => 'تعيين مالك جديد لاشتراك معين.',
    'ui__client/domain/to-client__title' => 'تحويل حساب مسؤول المجال إلى حساب العميل',
    'ui__client/domain/to-client__short-title' => 'تحويل مسؤول المجال إلى عميل',
    'ui__client/domain/to-client__description' => 'تحويل حساب مسؤول المجال هذا إلى حساب عميل',
    'ui__client/domain/to-client_unknown__short-title' => 'تحويل مسؤول المجال إلى عميل',
    'ui__client/domain/to-client_unknown__title' => 'تحويل حساب مسؤول المجال إلى حساب العميل',
    'ui__client/domain/to-client_unknown__description' => 'تحويل حساب مسؤول المجال إلى حساب العميل',
    'ui__client/domain/toggle__title' => 'تعليق المجال أو تنشيطه', // for HP customization
    'ui__client/domain/toggle__short-title' => 'تعليق المجال أو تنشيطه', // for HP customization
    'ui__client/domain/toggle__description' => 'تعليق المجال 1% أو تنشيطه.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'تعليق المجال أو تنشيطه', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'تعليق المجال أو تنشيطه', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'تعليق المجال أو تنشيطه.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'تنشيط المجال',
    'ui__client/domain/toggle_enable__short-title' => 'تنشيط المجال',
    'ui__client/domain/toggle_enable__description' => 'تنشيط المجال 1%.',
    'ui__client/domain/toggle_disable__title' => 'تعليق المجال',
    'ui__client/domain/toggle_disable__short-title' => 'تعليق المجال',
    'ui__client/domain/toggle_disable__description' => 'تعليق المجال 1%.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'إعدادات DNS',
    'ui__client/domain/dns__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns__description' => 'إدارة إعدادات منطقة DNS الخاصة بالمجال 1%.',
    'ui__client/domain/dns_self__title' => 'إعدادات DNS',
    'ui__client/domain/dns_self__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_self__description' => 'إدارة إعدادات منطقة DNS الخاصة بمجالك.',
    'ui__client/domain/dns_disabled__title' => 'إعدادات DNS',
    'ui__client/domain/dns_disabled__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_disabled__description' => 'إدارة إعدادات منطقة DNS الخاصة بالمجال 1%.',
    'ui__client/domain/dns_self-disabled__title' => 'إعدادات DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_self-disabled__description' => 'إدارة إعدادات منطقة DNS الخاصة بمجالك.',
    'ui__client/domain/dns_readonly__title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly__description' => 'عرض إعدادات منطقة DNS الخاصة بالمجال 1%.',
    'ui__client/domain/dns_readonly-self__title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly-self__description' => 'عرض إعدادات منطقة DNS الخاصة بمجالك.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'عرض إعدادات منطقة DNS الخاصة بمجالك.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'عرض إعدادات منطقة DNS الخاصة بمجالك.',
    'ui__client/domain/dns_slave__title' => 'إعدادات DNS',
    'ui__client/domain/dns_slave__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_slave__description' => 'إدارة إعدادات منطقة DNS الخاصة بالمجال 1%.',
    'ui__client/domain/dns_self-slave__title' => 'إعدادات DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'إعدادات DNS',
    'ui__client/domain/dns_self-slave__description' => 'إدارة إعدادات منطقة DNS الخاصة بمجالك.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'أدوات من MyPlesk.com',
    'ui__client/domain/extras__title' => 'أدوات من MyPlesk.com',
    'ui__client/domain/extras__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'أدوات من MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'أدوات من MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'أدوات من MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'أدوات من MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'الحصول على أدوات وخدمات إضافية من الموقع MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'مصادر بيانات ODBC', // PFW
    'ui__client/domain/odbc__title' => 'مصادر بيانات ODBC', // PFW
    'ui__client/domain/odbc__description' => 'قم بإعداد مصادر بيانات ODBC للمجال 1%.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'مصادر بيانات ODBC', // PFW
    'ui__client/domain/odbc_self__title' => 'مصادر بيانات ODBC', // PFW
    'ui__client/domain/odbc_self__description' => 'قم بإعداد مصادر بيانات ODBC للمجال الخاص بك.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'تسجيل المجال',
    'ui__client/domain/register__title' => 'تسجيل المجال',
    'ui__client/domain/register__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'تسجيل المجال',
    'ui__client/domain/register_unknown__title' => 'تسجيل المجال',
    'ui__client/domain/register_unknown__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'تسجيل المجال',
    'ui__client/domain/register_self__title' => 'تسجيل المجال',
    'ui__client/domain/register_self__description' => 'تسجيل اسم المجال من خلال MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'حماية الارتباط السريع', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'حماية الارتباط السريع', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'قم بحماية الملفات على المجال 1% من الارتباط السريع.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'حماية الارتباط السريع', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'حماية الارتباط السريع', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'قم بحماية ملفاتك من الارتباط السريع.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance__title' => 'الحد على استخدام النطاق الترددي وعدد الاتصالات المسموح بها بموقع الويب الخاص بك',
    'ui__client/domain/hosting/performance__description' => 'عرض وتعديل الحد على استخدام النطاق الترددي للمجال 1% وعدد الاتصالات المتزامنة به.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_readonly__title' => 'القيود على استخدام النطاق الترددي وعدد الاتصالات المسموح بها بموقع الويب',
    'ui__client/domain/hosting/performance_readonly__description' => 'عرض الحد على استخدام النطاق الترددي للمجال 1% وعدد الاتصالات المتزامنة به.',
    'ui__client/domain/hosting/performance_self__short-title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_self__title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_self__description' => 'عرض وتعديل الحد على استخدام النطاق الترددي لمجالك وعدد الاتصالات المتزامنة به.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'تحديد النطاق الترددي',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'عرض الحد على استخدام النطاق الترددي لمجالك وعدد الاتصالات المتزامنة به.',
    'ui__client/domain/hosting/php__short-title' => 'إعدادات PHP', // PFW
    'ui__client/domain/hosting/php__title' => 'إعدادات PHP', // PFW
    'ui__client/domain/hosting/php__description' => 'تكوين PHP على المجال 1%.', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'إعدادات PHP', // PFW
    'ui__client/domain/hosting/php_self__title' => 'إعدادات PHP', // PFW
    'ui__client/domain/hosting/php_self__description' => 'تكوين PHP على مجالك.', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => 'سيلزم تحديد حسابات العميل التي تريد تحويلها إلى حسابات بائع تجزئة',
    'ui__client/chowner__empty_selection' => 'سيلزم تحديد حسابات العميل التي تريد تعيينها إلى مالك جديد',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "أدوات",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'عرض الإحصائيات',
    'ui__client/domain-summary-report_unknown__title' => 'عرض الإحصائيات',
    'ui__client/domain-summary-report_unknown__description' => 'عرض معلومات حول استخدام المورد بواسطة المجالات.',
    'ui__client/domain-summary-report__short-title' => "عرض الإحصائيات",
    'ui__client/domain-summary-report__title' => "عرض الإحصائيات",
    'ui__client/domain-summary-report__description' => "عرض معلومات حول استخدام المورد بواسطة المجالات.",
    'ui__client/domain-summary-report_self__short-title' => "عرض الإحصائيات",
    'ui__client/domain-summary-report_self__title' => "عرض الإحصائيات",
    'ui__client/domain-summary-report_self__description' => "عرض معلومات حول استخدام المورد بواسطة المجالات الخاصة بك.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "المجالات", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => 'فحص الأذونات',
    'ui__client/domain/check-permissions_multi__title' => 'فحص الأذونات',
    'ui__client/domain/check-permissions_multi__description' => 'تحقق من أذونات الوصول إلى الملف والمجلد على مجال معين. إذا تم العثور على أي خطأ، فسيتم تصحيحه تلقائيًا.',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'يجب تحديد المجالات التي تريد إزالتها',
    'ui__client/domain/properties__empty_selection' => 'يجب تحديد المجالات التي تريد تعديلها',
    'ui__client/domain/chowner__empty_selection' => 'يجب تحديد المجالات التي تريد تعيينها إلى مالك جديد',
    'ui__client/domain/check-permissions__empty_selection' => 'يجب تحديد المجالات التي تريد فحص أذونات الملف والمجلد الخاص بها',
    'ui__client/domain/to-client__empty_selection' => 'يجب تحديد المجالات التي تريد تحويل حسابات المسؤول الخاص بها إلى حسابات عميل',

    // list objects filtering
    'domains_list__name__filter_title' => 'الاسم',
    'domains_list__state__filter_title' => 'استخدام الموارد',
    'domains_list__filter_state_any' => 'أي',
    'domains_list__filter_state_overuse' => 'الاستخدام الزائد',
    'domains_list__filter_state_normal' => 'ضمن الحدود',
    'domains_list__status__filter_title' => 'الحالة',
    'domains_list__filter_status_any' => 'أي',
    'domains_list__filter_status_blocked' => 'معلّق',
    'domains_list__filter_status_active' => 'نشط',
    'domains_list__ownership__filter_title' => 'الملكية',
    'domains_list__filter_ownership_all' => 'جميع المجالات',
    'domains_list__filter_ownership_personal' => 'مجالاتي فقط',
    'domains_list__filter_owner_pname__filter_title' => 'اسم المالك',
    'domains_list__subrows__filter_title' => 'إظهار',
    'domains_list__subrows_off' => 'مجالات فقط',
    'domains_list__subrows_subdomain_domainaliases' => 'باستخدام مجالات فرعية وأسماء مستعارة',
    'domains_list__subrows_subdomain' => 'باستخدام مجالات فرعية',
    'domains_list__subrows_domainaliases' => 'باستخدام أسماء مستعارة',

    // objects list
    'domains_list__owner__title' => 'المالك',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "استعراض للبحث عن التطبيقات",
    'site_apps__promo_main_text' => "يتضمن كتالوج معيار حزم التطبيق (APS) قائمة بالتطبيقات التي يمكن توفيرها إلى أحد المجالات أو مساحة الويب. إذا أردت توفير تطبيقات ليست موجودة حاليًا في الكتالوج، فيمكنك بسهولة القيام بذلك باتباع إرشادات حزم APS على الموقع www.apsstandard.com",
    'site_apps__promo_download_now' => "تنزيل التطبيقات:",
    'site_apps__promo_close' => "إغلاق هذا التأمين",
    'site_apps__promo_preset__mostused' => '1% الأكثر شهرة',
    'site_apps__promo_preset__lessused' => '1% التالي الأكثر شهرة',
    'site_apps__promo_preset__all' => "الجميع",
    'site_apps__promo_disclaimer_note' => '‫يجب ملاحظة أن التطبيقات المثبتة من كتالوج APS توفرها جهات خارجية غير معتمدة من قِبل Plesk.‬',
    'site_apps__promo_preset__page_title' => '1% من تطبيقات APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'إضافة التطبيقات...',

    // Errors
    'site_apps__no_applications_for_update' => 'لا توجد لديك تطبيقات مثبتة في مخزن التطبيقات.',
    'site_apps__incorrect_download_preset_configuration' => 'تم العثور على أخطاء في تكوين الإعداد المسبق لتنزيل كتالوج APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'عنوان URL المحدد غير صالح.',
    'site_apps__no_updates_at_the_moment' => 'لا توجد تحديثات تطبيق متوفرة حاليًا.',
    'site_apps__incorrect_content_returned_by_catalog' => 'تم استلام معلومات غير صحيحة من كتالوج تطبيقات APS. يُرجى إعادة المحاولة لاحقًا.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'تم حفظ إعدادات كتالوج APS، ولكن لم يتمكن Plesk من إنشاء اتصال إلى كتالوج APS المحدد في إعدادات كتالوج APS ‏(%1). تأكد من صحة عنوان كتالوج APS ومن تنشيط كتالوج APS في هذا العنوان.',
    'site_apps__cannot_retrieve_updates' => 'لا يمكن تنزيل تحديثات التطبيق حاليًا: يتعذر إنشاء اتصال بكتالوج APS ‏(%1). تأكد من صحة عنوان كتالوج APS ومن تنشيط كتالوج APS في هذا العنوان.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'لا توجد تطبيقات ويب متوفرة من أجل تثبيتها.',
    'site_apps__site_applications_already_installed_in_root' => 'تطبيقات الويب الأخرى مثبتة بالفعل في دلائل الجذر لأولئك المضيفين الظاهريين',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "إن تطبيقات الويب الخاصة بـ NET. غير مدعومة على نظام Unix/Linux الأساسي",
    'site_apps__server_wide_packages_not_supported' => 'تطبيقات الويب الخاصة بالخادم غير معتمدة',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "تتم جدولة 1% من تطبيقات الويب الإضافية من أجل الإضافة إلى مخزن التطبيق.",
    'site_apps__applications_all_in_vault' => "تطبيقات الويب المحددة موجودة بالفعل في مخزن التطبيق.",
    'site_apps__applications_already_in_download_queue' => "تتم إضافة 1% من تطبيقات الويب المحددة إلى مخزن التطبيق حاليًا.",
    'site_apps__applications_already_in_valut' => "1% من تطبيقات الويب المحددة موجودة بالفعل في مخزن التطبيق.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'أخطاء أخرى (غير محددة)',

    // Errors
    'site_apps__no_applications_in_category' => 'لا توجد تطبيقات متوفرة في هذه الفئة. يُرجى تحديد فئة أخرى.',
    'site_apps__no_category_selected__please_specify' => 'حدد فئة في القائمة اليسرى. سيتم سرد جميع التطبيقات المتوفرة في الفئة المحددة، في هذه النافذة.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'حساب المسؤول',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'عام',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'تغيير اسم المضيف',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'الأمان',
    'bt_setup_firewall' => 'إعداد جدار الحماية',
    'bt_manage_firewall_rules' => 'إدارة قواعد جدار الحماية',
    'cu_firewall__rule' => 'إنشاء قاعدة جدار حماية',
    'cu_firewall__protocol' => 'تعيين بروتوكول للقاعدة \'tcp\' أو \'\\udp\'\\)',
    'cu_firewall__name' => "تعيين اسم قاعدة",
    'cu_firewall__disabled' => 'إذا كانت القاعدة هي \'true\'، فسيتم تعطيلها بعد الإنشاء',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'تحديد خادم DNS', // PFW
    'bt_soa_records_template' => 'قالب سجلات SOA',
    'bt_restrict_creation_of_subzones' => 'تقييد إنشاء المناطق الفرعية',

    'databases' => 'قواعد البيانات',
    'bt_select_mssqlwebadmin' => 'تحديد مسؤول الويب لـ MS SQL', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'تطبيقات',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'بريد',
    'bt_select_mailserver' => 'تحديد خادم البريد', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'تحديد مكافحة الفيروسات', // PFW
    'bt_virus_protection_settings' => 'إعدادات الحماية من الفيروسات',
    'bt_select_spamfilter' => 'تحديد عامل تصفية البريد العشوائي', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'تحديد بريد الويب',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'السجلات والإحصائيات',
    'bt_server_statistics_settings' => 'إعدادات إحصائيات الخادم',
    'bt_select_web_statistics' => 'برنامج إحصائيات الويب المتوفرة', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'واجهة Plesk',

    'components_and_modules' => 'المكونات والوحدات',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'إعداد Watchdog', // PFU
    'bt_setup_vpn' => 'إعداد VPN', // PFU
    'bt_setup_samba' => 'إعداد سامبا',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'الإعدادات',
    'ui__client/domain/settings_self__short-title' => 'الإعدادات',
    'ui__client/domain/settings_self__description' => 'عرض إعدادات المجال وتغييرها.',

    'domain_administrator_account' => 'حساب مسؤول المجال',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'إعدادات الحساب',

    'domain' => 'المجال',
    'bt_dns_soa_records' => 'سجلات حذف بداية الجهة الموثقة لـ DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'إعدادات برنامج جدولة المهمة',

    'website' => 'موقع ويب',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'البرمجة النصية لمستخدمي الويب',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'حدد شهادة SSL/TLS',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'إحصائيات الويب',
    'bt_log_rotation_settings' => 'إعدادات تدوير السجل',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "الحدود", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "سياسة البيع والاستخدام الزائدين",
    'limits__overuse_policy_legend' => "الاستخدام الزائد",
    'limits__oversell_policy_legend' => "البيع الزائد",
    'limits__reseller_overuse_description' => "تبلغ سياسة الاستخدام الزائد Plesk بما يجب فعله عند زيادة استخدام الموارد.",
    'limits__overuse_text' => "سياسة الاستخدام الزائد",

    // limit names
    'limit_group__disk_space_and_traffic' => 'مساحة القرص وحركة مرور البيانات',
    'limit__disk_space' => 'مساحة القرص',
    'limit__max_traffic' => 'حركة مرور البيانات',
    'limit_group__client' => 'العملاء',
    'limit__max_cl' => 'العملاء',
    'limit_group__domain' => 'المجالات',
    'limit__max_dom' => 'المجالات',
    'limit__max_dom_powerUser' => 'الاشتراكات',
    'limit__max_subdom' => 'المجالات الفرعية',
    'limit__max_dom_aliases' => 'الأسماء المستعارة للمجالات',
    'limit__max_wu' => 'مستخدمو الويب',
    'limit__max_subftp_users' => 'حسابات FTP الإضافية', // PFW
    'limit_group__mail' => 'بريد',
    'limit__max_box' => 'علب البريد',
    'limit__mbox_quota' => 'حجم علبة البريد',
    'limit__total_mboxes_quota' => 'إجمالي حصة علب البريد', // PFW
    'limit__max_maillists' => 'قوائم المراسلة',
    'limit_group__database' => 'قواعد البيانات',
    'limit__max_mssql_db' => 'قواعد بيانات Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'إجمالي حصة قاعدة بيانات MS SQL', // PFW
    'limit__max_odbc' => 'اتصالات ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'حصة قاعدة بيانات MySQL', // PFW?
    'limit_group__application' => 'تطبيقات',
    'limit__max_iis_app_pools' => 'تجمعات تطبيق IIS', // PFW
    'limit_group__security' => 'الأمان',
    'limit_group__validity' => 'تاريخ انتهاء الصلاحية',
    'limit__expiration' => 'تاريخ انتهاء الصلاحية',
    'limit__validity' => 'فترة الصلاحية',
    'limit__max_site_builder' => 'المواقع المنشورة باستخدام Presence Builder',
    'limit__max_site' => 'المجالات',
    'limit__mssql_dbase_filesize' => 'حجم ملف قاعدة بيانات MS SQL',
    'limit__mssql_dbase_log_filesize' => 'حجم ملف سجل قاعدة بيانات MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'الحد الأقصى لحجم ملف قاعدة بيانات Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'الحد الأقصى لملف سجل قاعدة بيانات Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "ميغابايت",
    'limit__units_mssql_dbase_log_filesize' => "ميغابايت",

    'dom_pref__invalid_max_site_limit' => 'حد غير صالح للمجالات. الحد الأدنى للقيمة هو 1.',

    'property__has_wrong_value' => 'الملكية 1% لها قيمة خاطئة.',
    'property__name_outgoing_messages_domain_limit' => 'يحدد الحد على الرسائل الصادرة من أحد المجالات (في الساعة). لتحديد القيمة "Unlimited" (غير محدد)، حدد "-1". حدد "default" (افتراضي) لتحديد القيمة المحددة في الإعدادات على مستوى الخادم.',
    'property__name_outgoing_messages_mbox_limit' => 'يحدد الحد على الرسائل الصادرة من علبة بريد معينة (في الساعة). لتحديد القيمة "Unlimited" (غير محدد)، حدد "-1". حدد "default" (افتراضي) لتحديد القيمة المحددة في الإعدادات على مستوى الخادم.',
    'property__name_outgoing_messages_subscription_limit' => 'يحدد الحد على الرسائل الصادرة من أحد الاشتراكات (في الساعة). لتحديد القيمة "Unlimited" (غير محدد)، حدد "-1". حدد "default" (افتراضي) لتحديد القيمة المحددة في الإعدادات على مستوى الخادم.',

    // for CLI report & email notifications
    '__resource_notify' => 'إعلام',
    '__general' => 'عام',
    '__template_shared' => 'القالب المشترك',
    'limit__overuse' => 'سياسة الاستخدام الزائد',
    'limit__max_traffic_soft' => 'الإخطار عند وصول استخدام حركة مرور البيانات إلى',
    'limit__disk_space_soft' => 'الإخطار عند الوصول إلى حد استخدام مساحة القرص',
    '__overuse' => 'سياسة الاستخدام الزائد',
    'performance__title' => 'الأداء',
    'performance__bandwidth' => 'أقصى استخدام للنطاق الترددي (كيلوبايت/ث)',
    'performance__max_connections' => 'الاتصالات مقيدة بـ',

    'gch__hosting_php_isapi' => 'تشغيل PHP كامتداد ISAPI',
    'gch__hosting_ssi_html' => 'استخدام SSI لملفات .htm*، وhtml.*',
    'gch__hosting_php_handler_type' => 'تشغيل PHP كـ',
    'gch__hosting_php_handler_id' => 'تشغيل PHP كـ',
    'gch__hosting_php_served_by_nginx' => 'يتم توفير PHP عن طريق nginx',
    'gch__hosting_unpaid_website_status' => 'حالة مواقع الويب في الاشتراكات المعلقة',
    'gch__mn_no_autoresponder' => 'لا توجد إعداد لردود تلقائية بالنسبة إلى حساب البريد الإلكتروني.',
    'gch__no_clients_selected' => "لم يتم تحديد حسابات للعميل",
    'gch__no_domains_selected' => "لم يتم تحديد أي مجالات",

    // limit units
    'limit__units_disk_space' => "ميغابايت",
    'limit__units_max_traffic' => "ميغابايت/شهر",
    'limit__units_mbox_quota' => "كيلوبايت",
    'limit__units_mysql_dbase_space' => "ميغابايت", // PFW
    'limit__units_mssql_dbase_space' => "ميغابايت", // PFW
    'limit__units_total_mboxes_quota' => "ميغابايت", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'اسم المورد',
    '__resource_usage' => 'مُستخدَم',
    '__resource_limit' => 'حد',

    '__used' => 'مُستخدَم',
    '__limit' => 'حد',

    '__never_expires' => 'لا تنتهي صلاحيته أبدًا',
    '__resource_free' => '1% خالٍ من 2%',
    '__resource_unlimited' => '1% مُستخدم من غير المحدود',

    '__unlimited' => 'غير محدود',
    '__increment' => "زيادة (+)",
    '__decrement' => "تقليل (-)",
    '__pt' => 'الوحدات',
    '__procent' => '%',
    '__overused' => 'مُستخدم بشكل زائد',
    '__left' => 'اليسار',
    '__available' => 'متوفر',
    '__not_available' => 'غير مشمولة',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'عرض سجل حركة مرور البيانات',
    'ui__admin/report/traffic-history__title' => 'عرض سجل حركة مرور البيانات',
    'ui__admin/report/traffic-history__description' => 'عرض سجل حركة مرور البيانات الخاص ببائعي التجزئة، والعملاء والمجالات.',
    'admin_traffic_history__title' => 'سجل حركة مرور البيانات',

    'ui__admin/report/layout/auto_unknown__short-title' => 'الجدول الزمني للتسليم',
    'ui__admin/report/layout/auto_unknown__title' => 'الجدول الزمني لتسليم التقرير',
    'ui__admin/report/layout/auto_unknown__description' => 'اختر الجدول الزمني لتسليم التقرير للحصول على تخطيط التقرير.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'إضافة جدول زمني لتسليم التقرير',
    'ui__admin/report/layout/auto/properties_new__title' => 'إضافة جدول زمني لتسليم التقرير',
    'ui__admin/report/layout/auto/properties_new__description' => 'إضافة جدول زمني لتسليم التقرير الخاص بالتقرير 1%.',
    'ui__admin/report/layout/auto/properties__short-title' => 'الجدول الزمني لتسليم التقرير',
    'ui__admin/report/layout/auto/properties__title' => 'الجدول الزمني لتسليم التقرير',
    'ui__admin/report/layout/auto/properties__description' => 'عرض الخصائص وتعديلها للجدول الزمني لتسليم التقرير.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'إزالة الجدول الزمني لتسليم التقرير',
    'ui__admin/report/layout/auto/delete_multi__title' => 'إزالة الجدول الزمني لتسليم التقرير',
    'ui__admin/report/layout/auto/delete_multi__description' => 'إزالة الجداول الزمنية لتسليم التقرير المحدد.',

    'ui__admin/report/layout_unknown__short-title' => 'مخططات التقرير',
    'ui__admin/report/layout_unknown__title' => 'مخططات التقرير',
    'ui__admin/report/layout_unknown__description' => 'عرض مخططات التقرير وإدارتها.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'إنشاء مخطط تقرير.',
    'ui__admin/report/layout/properties_unknown-new__title' => 'إنشاء مخطط تقرير.',
    'ui__admin/report/layout/properties_unknown-new__description' => 'إنشاء مخطط تقرير.',
    'ui__admin/report/layout/delete_multi__short-title' => 'إزالة مخططات التقرير',
    'ui__admin/report/layout/delete_multi__title' => 'إزالة مخططات التقرير',
    'ui__admin/report/layout/delete_multi__description' => 'إزالة مخططات التقرير المحدد',
    'ui__admin/report/layout/properties__short-title' => 'الخصائص',
    'ui__admin/report/layout/properties__title' => 'خصائص مخطط التقرير',
    'ui__admin/report/layout/properties__description' => 'تحرير خصائص مخطط التقرير.',

    // reseller
    'reseller_traffic_history__title' => "سجل حركة مرور البيانات لبائع التجزئة 1%",

    'ui__reseller/traffic__short-title' => '1%',
    'ui__reseller/traffic__title' => 'عرض استخدام حركة مرور البيانات لبائع التجزئة 1%',
    'ui__reseller/traffic__description' => 'عرض تقارير استخدام حركة مرور البيانات لحساب بائع التجزئة 1%.',
    'ui__reseller/traffic_self__short-title' => 'خاص بي',
    'ui__reseller/traffic_self__title' => 'عرض استخدام حركة مرور البيانات بواسطة العملاء',
    'ui__reseller/traffic_self__description' => 'عرض تقارير استخدام حركة مرور البيانات لحسابات العميل الخاص بك.',

    'ui__reseller/report/traffic-history__short-title' => 'عرض سجل حركة مرور البيانات',
    'ui__reseller/report/traffic-history__title' => 'عرض سجل حركة مرور البيانات',
    'ui__reseller/report/traffic-history__description' => "عرض سجل حركة مرور البيانات لبائع التجزئة 1%.",
    'ui__reseller/report/traffic-history_self__short-title' => 'عرض سجل حركة مرور البيانات',
    'ui__reseller/report/traffic-history_self__title' => 'عرض سجل حركة مرور البيانات',
    'ui__reseller/report/traffic-history_self__description' => 'عرض سجل حركة مرور البيانات الخاص بك.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'الجدول الزمني للتسليم',
    'ui__reseller/report/layout/auto_unknown__title' => 'الجدول الزمني لتسليم التقرير',
    'ui__reseller/report/layout/auto_unknown__description' => 'اختر الجدول الزمني لتسليم التقرير للحصول على تخطيط التقرير.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'إضافة جدول زمني لتسليم التقرير',
    'ui__reseller/report/layout/auto/properties_new__title' => 'إضافة جدول زمني لتسليم التقرير',
    'ui__reseller/report/layout/auto/properties_new__description' => 'إضافة جدول زمني لتسليم التقرير الخاص بالتقرير 1%.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'الجدول الزمني لتسليم التقرير',
    'ui__reseller/report/layout/auto/properties__title' => 'الجدول الزمني لتسليم التقرير',
    'ui__reseller/report/layout/auto/properties__description' => 'عرض الخصائص وتعديلها للجدول الزمني لتسليم التقرير.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'إزالة الجدول الزمني لتسليم التقرير',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'إزالة الجدول الزمني لتسليم التقرير',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'إزالة الجداول الزمنية لتسليم التقرير المحدد.',

    'ui__reseller/report/layout_unknown__short-title' => 'مخططات التقرير',
    'ui__reseller/report/layout_unknown__title' => 'مخططات التقرير',
    'ui__reseller/report/layout_unknown__description' => 'عرض مخططات التقرير وإدارتها.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'إنشاء مخطط تقرير.',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'إنشاء مخطط تقرير.',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'إنشاء مخطط تقرير.',
    'ui__reseller/report/layout/properties_new__short-title' => 'إنشاء مخطط تقرير.',
    'ui__reseller/report/layout/properties_new__title' => 'إنشاء مخطط تقرير.',
    'ui__reseller/report/layout/properties_new__description' => 'إنشاء مخطط تقرير.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'إزالة مخططات التقرير',
    'ui__reseller/report/layout/delete_multi__title' => 'إزالة مخططات التقرير',
    'ui__reseller/report/layout/delete_multi__description' => 'إزالة مخططات التقرير المحدد',
    'ui__reseller/report/layout/properties__short-title' => 'الخصائص',
    'ui__reseller/report/layout/properties__title' => 'خصائص مخطط التقرير',
    'ui__reseller/report/layout/properties__description' => 'تحرير خصائص مخطط التقرير.',

    // customer
    'cl_traffic_history__title' => "سجل حركة مرور البيانات للعميل 1%",

    'ui__client/traffic__short-title' => '1%',
    'ui__client/traffic__title' => 'عرض استخدام حركة مرور البيانات للعميل1%',
    'ui__client/traffic__description' => 'عرض تقارير استخدام حركة مرور البيانات للحساب 1%.',
    'ui__client/traffic_self__short-title' => 'استخدام حركة مرور البيانات',
    'ui__client/traffic_self__title' => 'استخدام حركة مرور البيانات بواسطة المجالات',
    'ui__client/traffic_self__description' => 'عرض تقارير استخدام حركة مرور البيانات للمجالات الخاصة بك.',

    'ui__client/report/traffic-history__short-title' => 'عرض سجل حركة مرور البيانات',
    'ui__client/report/traffic-history__title' => 'عرض سجل حركة مرور البيانات',
    'ui__client/report/traffic-history__description' => 'عرض سجل حركة مرور البيانات للعميل 1%.',
    'ui__client/report/traffic-history_self__short-title' => 'عرض سجل حركة مرور البيانات',
    'ui__client/report/traffic-history_self__title' => 'عرض سجل حركة مرور البيانات',
    'ui__client/report/traffic-history_self__description' => 'عرض سجل حركة مرور البيانات الخاص بك.',



    // domain
    'dom_traffic_history__title' => "سجل حركة مرور البيانات للمجال 1%",

    'ui__client/domain/report/traffic-history__short-title' => 'عرض سجل حركة مرور البيانات',
    'ui__client/domain/report/traffic-history__title' =>  'عرض سجل حركة مرور البيانات',
    'ui__client/domain/report/traffic-history__description' => 'عرض سجل حركة مرور البيانات للمجال 1%.',
    'ui__client/domain/report/traffic-history_self__short-title' => 'عرض سجل حركة مرور البيانات',
    'ui__client/domain/report/traffic-history_self__title' =>  'عرض سجل حركة مرور البيانات',
    'ui__client/domain/report/traffic-history_self__description' => 'عرض سجل حركة مرور البيانات للمجال الخاص بك.',



    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => 'الإحصائيات حول زيارات الموقع الآمنة',
    'ui__client/domain/report/web-stats-ssl__title' => 'الإحصائيات حول الزيارات الآمنة للموقع 1%',
    'ui__client/domain/report/web-stats-ssl__description' => 'الإحصائيات حول الزيارات الآمنة للموقع 1%.',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => 'إحصائيات SSL/TLS للويب',
    'ui__client/domain/report/web-stats-ssl_self__title' => 'الإحصائيات حول الزيارات الآمنة لموقعك',
    'ui__client/domain/report/web-stats-ssl_self__description' => 'الإحصائيات حول الزيارات الآمنة لموقعك.',
    'ui__client/domain/report/ftp-stats__short-title' => 'إحصائيات FTP',
    'ui__client/domain/report/ftp-stats__title' => 'إحصائيات FTP للمجال 1%',
    'ui__client/domain/report/ftp-stats__description' => 'إحصائيات FTP للمجال 1%',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'إحصائيات FTP',
    'ui__client/domain/report/ftp-stats_self__title' => 'إحصائيات FTP للمجال الخاص بك',
    'ui__client/domain/report/ftp-stats_self__description' => 'إحصائيات FTP للمجال الخاص بك.',
    'ui__client/domain/report/anon-ftp-stats__short-title' => 'إحصائيات FTP المجهول',
    'ui__client/domain/report/anon-ftp-stats__title' => 'إحصائيات FTP المجهول للمجال 1%',
    'ui__client/domain/report/anon-ftp-stats__description' => 'إحصائيات FTP المجهول للمجال 1%',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => 'إحصائيات FTP المجهول',
    'ui__client/domain/report/anon-ftp-stats_self__title' => 'إحصائيات FTP المجهول للمجال 1%',
    'ui__client/domain/report/anon-ftp-stats_self__description' => 'إحصائيات FTP المجهول للمجال 1%',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'إعدادات Webalizer',
    'ui__client/domain/report/webalizer-preferences__title' => 'إعدادات Webalizer لـ 1%',
    'ui__client/domain/report/webalizer-preferences__description' => 'ضبط العرض التقديمي للتقارير الإحصائية بواسطة Webalizer لـ 1%.',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'إعدادات Webalizer',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'إعدادات Webalizer لـ 1%',
    'ui__client/domain/report/webalizer-preferences_self__description' => 'ضبط العرض التقديمي للتقارير الإحصائية بواسطة Webalizer لـ 1%.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => '‫S‬',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'اسم بائع التجزئة', // reseller report
    'report__full_client_name' => 'اسم العميل', // customer report
    'report__full_domain_name' => 'اسم المجال', // domain report
    'report__full_owner' => 'المالك', // customer & domain reports
    'report__full_creation_date' => 'تاريخ الإنشاء',
    'report__full_size' => 'الحجم',
    'report__full_traffic' => 'حركة مرور البيانات',
    'report__full_active_clients' => 'عملاء نشطون', // reseller report
    'report__full_clients' => 'العملاء', // reseller report
    'report__full_active_domains' => 'مجالات نشطة', // reseller & customer reports
    'report__full_domains' => 'المجالات', // reseller & customer reports
    'report__full_subdomains' => 'المجال الفرعي',
    'report__full_mboxes' => 'علب البريد',
    'report__full_disk_space' => 'مساحة القرص',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'قائمة مراسلة',
    'report__full_web_users' => 'مستخدم الويب',
    'report__full_mysql_databases' => 'قاعدة بيانات MySQL',
    'report__full_mssql_databases' => 'قاعدة بيانات MSSQL',

    // common summary report
    'report__section_general' => 'عام',
    'report__version' => 'إصدار المنتج',
    'report__build' => 'بنية المنتج',
    'report__status' => 'الحالة',
    'report__company_name' => 'اسم الشركة',
    'report__personal_name' => 'الاسم الشخصي',
    'report__login' => 'اسم المستخدم',
    'report__phone' => 'الهاتف',
    'report__fax' => 'فاكس',
    'report__email' => 'بريد إلكتروني',
    'report__address' => 'عنوان',
    'report__city' => 'المدينة',
    'report__state' => 'الولاية/المقاطعة',
    'report__zip_code' => 'الرمز البريدي',
    'report__country' => 'البلد',
    'report__creation_date' => 'تاريخ الإنشاء',
    'report__expiration_date' => 'تاريخ انتهاء الصلاحية',
    'report__dumps_total_size' => 'إجمالي حجم ملفات النسخ الاحتياطي',
    'report__section_resellers' => 'بائعو التجزئة',
    'report__active_resellers' => 'بائعو التجزئة أصحاب الاشتراكات النشطة',
    'report__resellers' => 'بائعو التجزئة',
    'report__section_full_resellers' => 'بائعو التجزئة',
    'report__section_clients' => 'العملاء',
    'report__active_clients' => 'العملاء الذين لديهم اشتراكات نشطة',
    'report__clients' => 'العملاء',
    'report__section_full_clients' => 'العملاء',
    'report__section_personal_clients' => 'عملائي',
    'report__active_personal_clients' => 'العملاء التابعون لك أصحاب الاشتراكات النشطة',
    'report__personal_clients' => 'عملائي',
    'report__section_full_personal_clients' => 'عملائي',
    'report__section_domains' => 'المجالات',
    'report__disk_usage' => 'استخدام القرص',
    'report__traffic' => 'حركة مرور البيانات',
    'report__active_domains' => 'مجالات نشطة',
    'report__domains' => 'المجالات',
    'report__subdomains' => 'المجالات الفرعية',
    'report__mboxes' => 'علب البريد',
    'report__mail_groups' => 'عمليات إعادة توجيه البريد',
    'report__mail_autoresp' => 'الردود التلقائية',
    'report__mail_lists' => 'قوائم المراسلة',
    'report__web_users' => 'مستخدمو الويب',
    'report__mysql_databases' => 'قواعد بيانات MySQL',
    'report__mssql_databases' => 'قواعد بيانات MSSQL',
    'report__section_full_domains' => 'المجالات',
    'report__section_personal_domains' => 'المجالات الشخصية',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'المجالات الشخصية',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'المواقع المنشورة باستخدام Presence Builder',
    'report__invalid_email' => 'يُرجى إدخال عنوان بريد إلكتروني صالح.',


    // CLI-specific sections
    'report__section_hosting' => 'الاستضافة',
    'report__section_webusers' => 'مستخدمو الويب',
    'report__section_mailnames' => 'حسابات البريد',
    'report__section_maillists' => 'قوائم المراسلة',
    'report__section_databases' => 'قواعد البيانات',
    'report__section_siteapps' => 'تطبيقات الويب',
    'report__section_aspnetapps' => 'تطبيقات ASP.NET', // PFW
    'report__owner_pname' => "الاسم الشخصي لموفر الخدمة",
    'report__owner_login' => "اسم المستخدم لموفر الخدمة",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'تم تثبيت حزمة اللغة الافتراضية ولكن لم يتم تمكينها في النظام.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'حذف جلسات العمل',
    'ui__sessions/delete__title' => 'حذف جلسات العمل',
    'ui__sessions/delete__description' => 'حذف جلسات العمل المحددة.',
    'ui__ftp-sessions__short-title' => 'جلسات FTP',
    'ui__ftp-sessions__title' => 'جلسات FTP',
    'ui__ftp-sessions__description' => 'عرض جلسات FTP.',
    'ui__ftp-sessions/delete__short-title' => 'حذف جلسات FTP',
    'ui__ftp-sessions/delete__title' => 'حذف جلسات FTP',
    'ui__ftp-sessions/delete__description' => 'حذف جلسات FTP المحددة.',
    'ui__ts-sessions__short-title' => 'جلسات عمل الدعم الفني',
    'ui__ts-sessions__title' => 'جلسات عمل الدعم الفني',
    'ui__ts-sessions__description' => 'عرض جلسات عمل خدمة طرفية.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'حذف جلسات العمل',
    'ui__reseller/sessions/delete__title' => 'حذف جلسات العمل',
    'ui__reseller/sessions/delete__description' => 'حذف جلسات العمل المحددة.',
    'ui__reseller/sessions/delete_self__short-title' => 'حذف جلسات العمل',
    'ui__reseller/sessions/delete_self__title' => 'حذف جلسات العمل',
    'ui__reseller/sessions/delete_self__description' => 'حذف جلسات العمل المحددة.',
    'ui__reseller/ftp-sessions__short-title' => 'جلسات FTP',
    'ui__reseller/ftp-sessions__title' => 'جلسات FTP',
    'ui__reseller/ftp-sessions__description' => 'عرض جلسات FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'جلسات FTP',
    'ui__reseller/ftp-sessions_self__title' => 'جلسات FTP',
    'ui__reseller/ftp-sessions_self__description' => 'عرض جلسات FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'حذف جلسات FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'حذف جلسات FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'حذف جلسات FTP المحددة.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'حذف جلسات FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'حذف جلسات FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'حذف جلسات FTP المحددة.',

    // customer
    'ui__client/sessions/delete__short-title' => 'حذف جلسات العمل',
    'ui__client/sessions/delete__title' => 'حذف جلسات العمل',
    'ui__client/sessions/delete__description' => 'حذف جلسات العمل المحددة.',
    'ui__client/sessions/delete_self__short-title' => 'حذف جلسات العمل',
    'ui__client/sessions/delete_self__title' => 'حذف جلسات العمل',
    'ui__client/sessions/delete_self__description' => 'حذف جلسات العمل المحددة.',

    // domain administrator

    'forgery_token_expired' => 'انتهت صلاحية الرمز المميز للجلسة.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'سيتم تحويل حسابات بائع التجزئة التالية إلى حسابات العميل',
    'downgradeResellers__downgrade' => 'حسابات بائع التجزئة التي سيتم تحويلها',
    // controls
    'downgradeResellers__submit_downgrade' => 'إجراء تحويل الحساب.',
    'downgradeResellers__cancel_downgrade' => 'إلغاء تحويل الحساب.',
    'downgradeResellers__confirm' => 'تأكيد التحويل',
    'downgradeResellers__confirm_message' => 'تأكيد تحويل الحساب من أجل المتابعة',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'تحديد حسابات العملاء',
    'upgradeClients__upgrade_clients' => 'سيتم تحويل حسابات العميل التالية إلى حسابات بائع التجزئة',
    'upgradeClients__upgrade' => 'حسابات العميل التي سيتم تحويلها',
    // controls
    'upgradeClients__submit_upgrade' => 'إجراء تحويل الحساب.',
    'upgradeClients__cancel_upgrade' => 'إلغاء تحويل الحساب.',
    'upgradeClients__confirm' => 'تأكيد التحويل',
    'upgradeClients__confirm_message' => 'تأكيد تحويل الحساب من أجل المتابعة',
    // errors
    'upgradeClient__user_is_already_reseller' => 'يتعذر تحويل الحساب \'\\1%\'\\ إلى حساب بائع تجزئة: إن \'\\1%\'\\ هو بائع تجزئة بالفعل.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'سيتم تحويل حسابات مسؤول المجال التالية إلى حسابات العميل',
    'upgradeDomainUser__upgrade' => 'حسابات مسؤول المجال التي يمكن تحويلها',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'إجراء تحويل الحساب.',
    'upgradeDomainUser__cancel_upgrade' => 'إلغاء تحويل الحساب.',
    'upgradeDomainUser__confirm' => 'تأكيد التحويل',
    'upgradeDomainUser__confirm_message' => 'تأكيد تحويل الحساب من أجل المتابعة',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'حسابات مسؤول المجال التي لا يمكن تحويلها',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'تعذر تحويل حسابات مسؤول المجال التالية إلى حسابات العميل:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'تعذر تحويل العديد من حسابات مسؤول المجال إلى حسابات العميل. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'حساب مسؤول المجال غير موجود',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "يجب أن ينتمي المجال مباشرة إلى مسؤول الخادم أو بائع تجزئة.",
    'upgradeDomainUser__all_logins_already_used' => 'يتعذر إنشاء حساب للعميل الناتج.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'تم تحويل حساب مسؤول المجال',
    'upgradeDomainUser__upgrade_notification_body' => 'تم تحويل حساب مسؤول المجال إلى حساب عميل بالاسم \'\\%%login%%\'\\ وكلمة المرور \'\\%%password%%\'\\.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => 'تعيين مالك جديد لحساب العميل 1%', // customer home
    'ui__client/chowner_multi__wizard-title' => 'تعيين مالك جديد لحسابات العميل المحددة', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => 'تعيين مالك جديد لحسابات المستخدم المحدد', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => 'تحديد حسابات العملاء',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => 'تحديد حسابات العميل التي تريد نقلها إلى مالك آخر.',
    //  owner selection
    'client_chown__select_title' => 'اختر مالكًا جديدًا لحساب العميل',
    'client_chown__select-multi_title' => 'اختر مالكًا جديدًا لحسابات العميل',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "اختر مالكًا جديدًا لحسابات العميل المحددة.", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => 'اختر مالكًا جديدًا لحسابات العميل المحددة.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => 'اختر مالكًا جديدًا لحسابات العميل المحددة.', // reseller & admin home
    // changes check page
    'client_chown__check_title' => 'مراجعة التغييرات وإنهاء المعالج',
    'ui__client/chowner__wizard__2' => 'راجع التغييرات وانقر فوق "Finish" (إنهاء) لإكمال المعالج.', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => 'راجع التغييرات وانقر فوق "Finish" (إنهاء) لإكمال المعالج.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => 'راجع التغييرات وانقر فوق "Finish" (إنهاء) لإكمال المعالج.', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => 'لا بد من اختيار مالك جديد لحسابات العميل المحددة',
    'clientOwnerChanger__unable_to_transfer_some_clients' => 'لا يمكن نقل أحد حسابات المستخدم المحددة أو أكثر إلى مالك جديد.',
    'client_chown__client_warn' => 'الوصف',

    'clientOwnerChanger__owner_has_no_permission' => 'لا يتمتع بائع التجزئة المحدد بالإذن \'\\1%\'\\، ولكن بعض العملاء يتمتعون بهذا الإذن.',
    'clientOwnerChanger__application_not_allowed' => 'التطبيق \'\\1%\'\\ غير متوفر لبائع التجزئة المحدد، ولكنه متوفر لبعض العملاء.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'إعادة تعيين الاشتراكات المحددة',
    // errors
    'domain_chown__empty_selection' => 'لا بد من اختيار مالك جديد للمجالات المحددة',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'الأداء',
    'hosting_performance__traffic_bandwidth_legend' => 'تشغيل تحديد النطاق الترددي',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'تحديد النطاق الترددي',
    'hosting_performance__traffic_bandwidth_label' => 'أقصى استخدام للنطاق الترددي (1%)',
    'hosting_performance__traffic_bandwidth_hint' => 'ينطبق حد استخدام النطاق الترددي على البيانات المنقولة من خلال بروتوكول HTTP.',
    'hosting_performance__max_connection_legend' => 'تشغيل تحديد الاتصالات',
    'hosting_performance__max_connection_legend_ro' => 'تحديد الاتصالات',
    'hosting_performance__max_connection_label' => 'الاتصالات مقيدة بـ',
    'hosting_performance__max_connection_hint' => 'إذا قمت بتحديد استخدام النطاق الترددي، فسنوصيك أيضًا بتحديد عدد الاتصالات المتزامنة بالموقع. أو في حالة وجود طلبات متكررة إلى الموقع، فستزيد عمليات خادم الويب الحِمل على الخادم.',

    // errors:
    'performance__qos_not_installed' => 'تم إيقاف تشغيل الوظيفة بسبب عدم تثبيت QoS',
    'performance__bandwidth_throttling' => 'لا يمكنك التحكم في تقييد النطاق الترددي لأن QoS غير مثبت.',
    'performance__invalid_value' => "القيمة غير صالحة. يجب أن تكون في النطاق من 1% إلى 2%.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'بريد الويب',
    'webmail__server_text' => 'عملاء بريد الويب المتوفرون',
    'webmail__none' => 'بلا',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'تجمع IP للخادم',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'لن تتم استعادة قاعدة البيانات: لا يوجد خادم قاعدة بيانات مناسب',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "النسخ الاحتياطي للخادم.",
    '__default_backup_comment_reseller' => "تم إنشاء النسخ الاحتياطي لحساب بائع التجزئة بواسطة 1%.",
    '__default_backup_comment_client' => "تم إنشاء النسخ الاحتياطي لحساب العميل بواسطة 1%.",
    '__default_backup_comment_domain' => "تم إنشاء النسخ الاحتياطي للاشتراك بواسطة 1%.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'تحديد تخطيط عناوين IP',
    'backup__ip_mapping__download' => 'حفظ عنوان IP الحالي إلى ملف',
    'b_backup__ip_mapping__download' => 'انقر لتنزيل تكوين تعيين IP.',
    'b_backup__ip_mapping__download_is_empty' => 'إن تكوين تعيين IP فارغ.',
    'backup__ip_mapping_upload__title' => 'تحميل ملف تعيين IP',
    'backup__ip_mapping__upload' => 'تحميل ملف تعيين IP',
    'b_backup__ip_mapping__upload' => 'انقر لتحميل تكوين تعيين IP.',
    'backup__ip_mapping__list__header' => 'تعيين IP',
    'backup__ip_mapping__list__adddress' => 'عناوين IP القديمة',
    'backup__ip_mapping__list__select_ip' => 'عناوين IP الجديدة',
    'backup__ip_mapping__clients_ip' => "تجمع IP للعميل 1%",
    'backup__ip_mapping__resellers_ip' => "تجمع IP لبائع التجزئة 1%",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'يجب تخطيط عناوين IP المخصصة إلى عناوين IP فريدة. حدد عنوان IP فريدًا لكل عنوان IP مخصص في القائمة.',
    'backup__ip_mapping__legend' => 'تعيين IP',
    'backup__ip_mapping__upload_legend' => 'تحميل',
    'backup__ip_mapping__upload_file_text' => 'ملف تعيين IP',
    'backup__ip_mapping__upload_file_hint' => 'ملف تعيين IP هو ملف نصي عادي. يحتوي كل سطر في هذا الملف على تعيين IP بالتنسيق التالي: <عنوان IP القديم/> <عنوان IP الجديد/>',
    'backup__ip_mapping__ip_address_not_found' => 'لا تتوفر عناوين IP مجانية لهذا النوع.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'يتعذر إجراء تحويل للبيانات: إن تخطيط عناوين IP غير مكتمل بسبب عدم وجود عناوين IP مجانية في التجمع في خادم الوجهة.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'سيتم حظر اتصالات FTP غير الآمنة على المجالات التي تستخدم عنوان IP هذا.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'سيتم حظر اتصالات FTPS الآمنة على المجالات التي تستخدم عنوان IP هذا.',

    // Conflicts occured
    'legend_conflicts_occured' => 'التعارضات',
    'backup__restore__object_vhost' => 'المضيف الظاهري',
    'backup__restore__object_plesk_admin' => 'مسؤول Plesk',
    'backup__restore__object_ftpuser' => 'حساب FTP',
    'backup__restore__object_frontpageuser' => 'حساب Frontpage',
    'backup__restore__object_webuser' => 'مستخدم الويب',
    'backup__restore__object_domain' => 'المجال',
    'backup__restore__object_subdomain' => 'المجال الفرعي',
    'backup__restore__object_domainalias' => 'اسم مستعار للمجال',
    'backup__restore__object_client' => 'العميل',
    'backup__restore__object_reseller' => 'بائع تجزئة',
    'backup__restore__object_autoresponder' => 'الرد التلقائي',
    'backup__restore__object_mailalias' => 'اسم مستعار للمراسلة',
    'backup__restore__object_database' => 'قاعدة بيانات',
    'backup__restore__object_mailname' => 'حساب البريد',
    'backup__restore__object_db_user' => 'مستخدم قاعدة البيانات',
    'backup__restore__object_ssl_certificate' => 'شهادة SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'لا يمكن استعادة بائعي التجزئة التالين لأنهم قد يتم تحويلهم إلى عملاء: \'%1\'',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'لا يمكن استعادة العملاء التالين لأنهم قد يتم تحويلهم إلى بائعي التجزئة: \'%1\'',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'لا يمكن استعادة العملاء التالين لأنهم يتم تحويلهم إلى مالك آخر: \'%1\'',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'لا توجد مساحة كافية على القرص على خادم الوجهة لنقل جميع الاشتراكات المحددة. متوفر: 1% ميغابايت. ضروري: 2% ميغابايت. لاحظ أن المساحة المطلوبة يتم حسابها كمجموع محتويات الويب والبريد وقاعدة البيانات للمجالات. يتم حساب المساحة المطلوبة مرة واحدة في اليوم ويتم تخزينها في ذاكرة التخزين المؤقت، لذا قد يختلف الحجم الفعلي للمجالات عن الحجم المحسوب. إذا تأكدت من أن المجالات المحددة لا تشغل مساحة أكبر من المتوفرة، فيمكنك متابعة النقل.',
    'backup__restore__capability_not_enough_disk_resolution' => 'يُرجى توفير مساحة خالية على القرص على الخادم الوجهة.',
    'backup__restore__capability_source_not_enough_disk_text' => 'لا توجد مساحة كافية على القرص على الخادم المصدر لتخزين الملفات مؤقتًا من أجل نقلها. متوفر: 1% ميغابايت. ضروري: 2% ميغابايت.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'يُرجى توفير مساحة خالية على القرص على الخادم المصدر.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'معلومات الخادم',

    'backup__restore__capability_not_installed_component_text' => 'لم يتم تثبيت المكون 1% على الخادم الوجهة. لن يتوفر 1% لجميع الكائنات المستعادة.',
    'backup__restore__capability_not_installed_component_resolution' => 'يُرجى تثبيت 1%. لاحظ أن ذلك قد يستغرق دقائق قليلة.',
    'backup__restore__capability_existing_sys_user_text' => 'يوجد بالفعل مستخدم للنظام بالاسم 1% على الخادم الوجهة.',
    'backup__restore__capability_existing_sys_user_resolution' => 'يُرجى إعادة تسمية مستخدم النظام الحالي على الخادم الوجهة.',
    'backup__restore__capability_license_usage_text' => 'سيتم تجاوز القيود على المصدر التالية (المحددة حسب مفتاح الترخيص) على الخادم الوجهة بعد نقل البيانات:',
    'backup__restore__capability_license_usage_resolution' => 'يُرجى تثبيت مفتاح ترخيص آخر على الخادم الوجهة والذي يوفر كمية الموارد الضرورية.',
    'backup__restore__capability_max_allowed_packet_text' => "إن المعلمة '\\max_allowed_packet'\\ على خادم قاعدة البيانات المصدر هي 1% وهي أكبر من خادم الوجهة حيث يكون 2%. قد لا تتم استعادة بعض كائنات قاعدة البيانات للمجالات المحددة أدناه.",
    'backup__restore__capability_max_allowed_packet_resolution' => "يُرجى زيادة قيمة '\\max_allowed_packet'\\ على خادم قاعدة بيانات الوجهة.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'يتعذر نقل قواعد بيانات PostgreSQL لأن إصداره على الخادم الوجهة أقدم من الخادم المصدر. الإصدار الحالي هو 1%، والإصدار المطلوب هو 2%.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'يُرجى تثبيت الإصدار المطلوب من PostgreSQL على الخادم الوجهة.',
    'backup__restore__capability_db_server_connection_problems' => 'يتعذر الاتصال بخادم قاعدة بيانات الوجهة PostgreSQL. لن يتم نقل قواعد البيانات إلا إذا تمت استعادة الاتصال.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'يُرجى التحقق من إعدادات الاتصال على خادم قاعدة بيانات الوجهة.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'المكون 1% قيد إيقاف التشغيل على الخادم الوجهة.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'يُرجى تشغيل 1% على الخادم الوجهة.',
    'backup__restore__capability_not_configured_component_text' => 'لم يتم تكوين المكون 1% على الخادم الوجهة.',
    'backup__restore__capability_not_configured_component_resolution' => 'يُرجى تكوين 1% على صفحة "الأدوات والإعدادات".',

    'backup__restore__capability_webmail_is_not_available' => 'إن خدمة بريد الويب 1% غير متوفرة على الخادم الوجهة. وبدلاً من ذلك، سيستخدم Plesk خدمة بريد الويب التالية: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'لاستخدام نفس بريد الويب الموجود على الخادم المصدر، يجب عليك تثبيته على هذا الخادم.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'لاستخدام بريد الويب نفسه مثلما يتم على الخادم المصدر، يجب تثبيته على الخادم الوجهة.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "إن بريد الويب  '\\ 1%'\\ غير متوفر على الخادم الوجهة. وبدلاً من ذلك، وفي الاشتراكات التالية: 3%، سيستخدم Plesk خدمة بريد الويب التالية: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'يُرجى تثبيت بريد الويب المطلوب على الخادم الوجهة.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'إعدادات بريد الويب',

    'backup__restore__capability_shell_is_not_available' => 'لا يتوفر الوعاء 1% على الخادم الوجهة. سيتم استخدام الأوعية المتوفرة بدلاً من ذلك.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'لاستخدام الوعاء نفسه على الخادم المصدر، يجب تشغيل (in /etc/shells) أو تثبيته على الخادم الوجهة.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'إن خادم DNS للوجهة لا يدعم الشبكات في "قالب القيود على التحويل". لن تتم استعادة السجلات التي تستخدم عناوين IP للشبكة في القيود على التحويل لـ DNS.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'إن خادم DNS الوجهة لا يدعم الشبكات في "قالب القيود على التحويل"، ولكن بعض الاشتراكات تتضمن شبكات في القيود على التحويل لـ DNS. لن تتم استعادة السجلات التي تستخدم عناوين IP للشبكة في القيود على التحويل لـ DNS.',

    'backup__restore__capability_wrong_php_handler_text' => 'لا يتوفر معالج PHP ‎‎ وهو 1% على الخادم الوجهة. وبدلاً من ذلك، سيستخدم Plesk معالج PHP التالي: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'لاستخدام معالج PHP نفسه مثلما يتم على الخادم المصدر، يجب تشغيله أو تثبيته على الخادم الوجهة.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'إن المعالج 1% الخاص بـ PHP غير متوفر. وبدلاً من ذلك، يُرجى استخدام المعالج 2% لخطط الخدمة التالية: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'إن المعالج 1% الخاص بـ PHP غير متوفر. وبدلاً من ذلك، يُرجى استخدام المعالج 2% لمواقع الويب التالية: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'معالج PHP %1 غير متاح. سيكون غير متاح للمواقع الإلكترونية التالية: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'لا يتوفر 1% 2% على الخادم الوجهة. سيتم استخدام الإصدار الافتراضي بدلاً من ذلك.',
    'backup__restore__capability_wrong_component_version_resolution' => 'لاستخدام 1% نفسه مثلما يتم على الخادم المصدر، يجب تشغيله أو تثبيته على الخادم الوجهة.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'لا تسمح سياسة استخدام مكافحة الفيروسات على الخادم الوجهة بالإعدادات الشخصية لمكافحة الفيروسات (حسب عنوان البريد الإلكتروني) للبريد الصادر. لن يتم نقل هذه الإعدادات.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'لا تسمح سياسة استخدام مكافحة الفيروسات على الخادم الوجهة بالإعدادات الشخصية لمكافحة الفيروسات (حسب عنوان البريد الإلكتروني) للبريد الوارد. لن يتم نقل هذه الإعدادات.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'لا تسمح سياسة استخدام مكافحة الفيروسات على الخادم الوجهة بالإعدادات الشخصية لمكافحة الفيروسات (حسب عنوان البريد الإلكتروني). لن يتم نقل هذه الإعدادات.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "لنقل الإعدادات الشخصية لمكافحة الفيروسات (حسب عنوان البريد الإلكتروني)، يُرجى تشغيل الخيارات المقابلة في \"الأدوات والإعدادات> إعدادات الحماية من الفيروسات\".",
    'backup__restore__capability_antivirus_not_active_text' => 'لا يوجد برنامج لمكافحة الفيروسات قيد التشغيل. لن تعمل جميع إعدادات مكافحة الفيروسات من الخادم المصدر حتى يتم تحديد برنامج مكافحة الفيروسات على الخادم الوجهة.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'يُرجى تحديد برنامج مكافحة الفيروسات في جزء "الأدوات والإعدادت> إعدادات الحماية من الفيروسات> إعدادات مكافحة الفيروسات".',

    'backup__restore__capability_antivirus_another_active_text' => 'لا يتوفر برنامج مكافحة الفيروسات 2% على الخادم الوجهة. سيتم استخدام 1% بدلاً من ذلك.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'لاستخدام برنامج مكافحة الفيروسات نفسه مثلما يتم على الخادم المصدر، يُرجى تثبيته وتحديده في جزء "الأدوات والإعدادت> إعدادات الحماية من الفيروسات> إعدادات مكافحة الفيروسات".',
    'backup__restore__capability_not_available_sni_text' => 'لا يتوفر SNI في خادم الوجهة. لن يكون بمقدور مواقع الويب التي لها عنوان IP نفسه استخدام شهادات SSL/TLS فردية.',
    'backup__restore__capability_not_available_sni_resolution' => "يُرجى التحقق من أن نظام التشغيل في خادم الوجهة يدعم SNI فضلاً عن تشغيل دعم SNI في Plesk (علامة الاختيار /\"تشغيل دعم SNI، الذي يسمح باستخدام شهادات SSL/TLS الفردية في مواقع الويب التي لها عنوان IP نفسه/\" في الأدوات & الإعدادات> إعدادات الخادم).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'إعدادات الخادم',

    'backup__restore__capability_vhost_already_exists_text' => 'لا يمكن نقل موقع الويب 1%: يوجد موقع ويب بالاسم نفسه بالفعل على الخادم الوجهة.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'يُرجى إعادة تسمية أو حذف موقع الويب الذي يحمل الاسم نفسه من الخادم.',
    'backup__restore__capability_removed_vhosts' => 'لن تتم استعادة الاشتراكات التالية لأنها تحتوي على أسماء المجال الموجود بالفعل في الخادم الوجهة: 1%',
    'backup__restore__capability_duplicate_php_handler_text' => 'يوجد على الخادم المصدر اختلاف في معالجات PHP بنسبة 3% للنوع 1% والإصدار 2%. وبدلاً منهم، سيتم استخدام أحد المعالجات من النوع والإصدار المناسبين على الخادم الوجهة. لاحظ أن إعدادات PHP على الخادم المصدر والوجهة قد تكون مختلفة.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'لا يدعم تطبيق Plesk Installer تطبيق Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'لا يدعم تطبيق Plesk Installer تطبيق Python. يُرجى تثبيت تطبيق Python يدويًا.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'إعدادات خادم البريد',

    'backup__restore__capability_ftps_disabled' => 'يُسمح باستخدام اتصال FTPS الآمن على الخادم الوجهة، ولكنه ممنوع على الخادم الهدف. قد لا تعمل تطبيقات المستخدم التي تستخدم اتصال FTP بطريقة صحيحة.',
    'backup__restore__capability_ftps_required' => 'يُسمح باستخدام اتصال FTP غير الآمن على الخادم المصدر، ولكنه ممنوع على الخادم الهدف. قد لا تعمل تطبيقات المستخدم التي تستخدم اتصال FTP بطريقة صحيحة.',
    'backup__restore__capability_ftps_policy_resolution' => 'قم بتغيير سياسة اتصال FTP الآمن في "الأدوات والإعدادات> سياسة الأمان".',

    'backup__restore__capability_too_much_download_time_text' => 'سيتم نقل 1% ميغابايت من البيانات من الخادم المصدر إلى الوجهة خلال 2% ساعة (ساعات).',
    'backup__restore__capability_too_much_download_time_resolution' => 'للنقل بشكل أسرع، يُرجى التحقق من اتصال الشبكة بين الخوادم المصدر والوجهة مع حل المشكلات (إن وجدت).',
    'backup__restore__too_low_download_speed' => "أقل من 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'للنقل بشكل أسرع، يُرجى التحقق من اتصال الشبكة بين الخوادم المصدر والوجهة مع حل المشكلات (إن وجدت).',
    'backup__restore__capability_zero_download_speed_text' => 'The minimum acceptable download speed is %1 MBps. سرعة التنزيل بين الخوادم المصدر والوجهة هي "صفر" ميغابايت. قد يحدث ذلك بسبب مشكلات في اتصال الشبكة. النقل غير ممكن.',
    'backup__restore__capability_zero_download_speed_resolution' => 'يُرجى التحقق من اتصال الشبكة بين الخوادم المصدر والوجهة مع حل المشكلات.',
    'backup__restore__capability_too_slow_download_speed_text' => 'إن الحد الأدني المقبول من سرعة التنزيل هو 2% ميغابايت. سرعة التنزيل بين الخادم المصدر والوجهة هي 1% ميغابايت. قد يؤدي ذلك إلى زيادة وقت النقل. في بيئتك الحالية، قد يستغرق ترحيل 3% حوالي 4% ساعة (ساعات).',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'إن الحد الأدني المقبول من سرعة التنزيل هو 2% ميغابايت. سرعة التنزيل بين الخادم المصدر والوجهة هي 1% ميغابايت. قد يؤدي ذلك إلى زيادة وقت النقل.',

    'backup__restore__capability_remote_database_migration' => "تستخدم المجالات التالية قواعد البيانات البعيدة: 1%",
    'backup__restore__capability_remote_database_migration_resolution' => "لا تقم بإزالة هذه المجالات من الخادم المصدر بعد النقل إذا كان إصدار Plesk على الخادم المصدر أقدم من 11.5! قم بإيقافها مؤقتًا بدلاً من ذلك. إذا قمت بإزالة المجالات، فلن تتم إزالة قواعد البيانات من الخادم البعيد. ملاحظة: ستتم استعادة قواعد البيانات البعيدة لملفات التفريغ على الخادم المصدر في الدليل 1%.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'قد لا تتم استعادة ملفات النسخ الاحتياطي لقاعدة بيانات MySQL الأقدم من الإصدار 5.1 (1%) على MySQL 5.1.x لأن MySQL 5.1.x يعالج أحرف Unicode بطريقة مختلفة.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'يُرجى قراءة مقالة قاعدة المعارف ذات الصلة 136850#',

    'backup__restore__capability_firewall_not_installed_text' => 'إن امتداد Firewall (جدار الحماية) غير مثبت على الخادم الوجهة. إذا قمت بتثبيت قواعد القيود على الوصول، فلن تعمل هذه القواعد.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'يُرجى تثبيت امتداد Firewall (جدار الحماية) باستخدام Plesk Installer.',
    'backup__restore__capability_courier_not_installed_text' => 'إن Plesk Installer غير مثبت على الخادم الوجهة.',
    'backup__restore__capability_courier_not_installed_resolution' => 'يُرجى تثبيت Courier-IMAP عن طريق استخدام Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'إن تطبيق Dovecot غير مثبت على الخادم الوجهة.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'يُرجى تثبيت Dovecot باستخدامPlesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'إن وقت الاحتفاظ بالإحصائيات في عمليات التكوين للكائنات التالية أقل من القيمة الخاصة بالخادم على خادم الوجهة.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'يُرجى تغيير القيمة الخاصة بالخادم لوقت الاحتفاظ بالإحصائيات على خادم الوجهة. قم بتعيين هذا الوقت إلى ما يساوي أو يقل عن أصغر قيمة في عمليات تكوين المجالات.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'إن وقت الاحتفاظ بإحصائيات حركة مرور البيانات في بعض المجالات أقل من القيمة الخاصة بالخادم (1%). سيتم تغيير القيمة إلى 1% بالنسبة إلى هذه المجالات.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'إن الوقت الخاص بالاحتفاظ بإحصائيات حركة مرور البيانات أقل من القيمة الخاصة بالخادم (1%). سيتم تغيير القيمة إلى 1% بالنسبة إلى خطط الخدمة هذه.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'سيؤدي تخطيط عنوان IP حصري إلى عنوان IP مشترك إلى تعطيل اتصالات FTP وHTTPS باسم مجهول (حتى يتم تشغيل دعم SNI).',

    'backup__restore__no_postgresql_commands_text' => 'يستخدم هذا الاشتراك قاعدة بيانات PostgreSQL بعيدة، ولا يمكن إنشاء ملف نسخ احتياطي مؤقت لها لأن الأوامر pg_dump وpsql مفقودة على الخادم المصدر.',
    'backup__restore__no_postgresql_commands_resolution' => 'يُرجى تثبيت حزمة عميل PostgreSQL التي تدعم هذه الأوامر.',
    'backup__restore__capability_apache_modules_disabled_text' => 'إن وحدات Apache التالية معطلة على الخادم الوجهة: 1%.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'يُرجى تمكين هذه الوحدات منع المشكلات المحتملة.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'إن وحدات Apache التالية غير مثبتة على الخادم الوجهة: 1%.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'يُرجى تثبيت هذه الوحدات وتمكينها لمنع المشكلات المحتملة.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'إن القيد على الرسائل الصادرة غير معتمد من قبل الترخيص الخاص بك. لن يتم نقل إعدادات التكوين المقابلة.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'يُرجى تثبيت مفتاح ترخيص آخر على الخادم الوجهة والذي يوفر الميزات الضرورية.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'إن القيد على الرسائل الصادرة قيد إيقاف التشغيل على الخادم الوجهة. لن يتم نقل إعدادات التكوين المقابلة.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'يُرجى تشغيل القيد على الرسائل الصادرة على الخادم الوجهة.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'إعدادات البريد على مستوى الخادم',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'إن القيد على الرسائل الصادرة من صندوق الوارد غير معتمد من قِبل خادم البريد والذي يُستخدم على الخادم الوجهة. لن يتم نقل قيمة هذا القيد.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'يُرجى تغيير خادم البريد إلى ما كنت تستخدمه على الخادم المصدر.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'إعدادات البريد على مستوى الخادم',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'إن القيد على الرسائل الصادرة من المجال غير معتمد من قِبل خادم البريد والذي يُستخدم على الخادم الوجهة. لن يتم نقل قيمة هذا القيد.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'يُرجى تغيير خادم البريد إلى ما كنت تستخدمه على الخادم المصدر.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'إعدادات البريد على مستوى الخادم',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'إن القيد على الرسائل الصادرة من الاشتراك غير معتمد من قِبل خادم البريد والذي يُستخدم على الخادم الوجهة. لن يتم نقل قيمة هذا القيد.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'يُرجى تغيير خادم البريد إلى ما كنت تستخدمه على الخادم المصدر.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'إعدادات البريد على مستوى الخادم',

    'bu_conflict_resolver_absent_phosting' => 'تتعذر استعادة الملفات المحددة لأن الاستضافة الفعلية لاستعادتها غير موجودة. يُرجى إنشاء مجال مزود باستضافة فعلية أولاً ثم بدء استعادة النسخ الاحتياطي مجددًا.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'لن تتم استعادة بيانات بائعي التجزئة نظرًا لأن إدارة بائعي التجزئة غير مدعومة.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'إن مكون ModSecurity غير مثبت على الخادم الوجهة.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'يُرجى تثبيت ModSecurity إذا أردت استمرار عمل جدار حماية تطبيق الويب للمواقع المنقولة. لاحظ أن التثبيت قد يستغرق دقائق قليلة.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'قم بتثبيت ModSecurity إذا أردت نقل الإعدادات الخاصة بجدار حماية تطبيق الويب. لاحظ أن التثبيت قد يستغرق دقائق قليلة.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'لم يتم تكوين مكون ModSecurity على الخادم الوجهة.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'قم بتكوين ModSecurity إذا أردت استمرار عمل جدار حماية تطبيق الويب للمواقع المنقولة.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'جدار حماية تطبيق الويب (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'إن ModSecurity قيد إيقاف التشغيل على الخادم الوجهة.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'قم بتنشيط ModSecurity إذا أردت استمرار عمل جدار حماية تطبيق الويب للمواقع المنقولة.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'جدار حماية تطبيق الويب (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'إن مكون ModSecurity غير مثبت. لن تتم استعادة إعدادات جدار حماية الويب للكائنات التالية: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "لا يمكن استعادة مواقع الويب لأنها تنتمي إلى الاشتراك 1% وهو غير موجود في Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'لم يتم تثبيت المكون 1% على الخادم الوجهة. لن تتوفر خدمة DNS وستُفقد إعدادات DNS. ستتعطل جميع مواقع الويب للعملاء.',
    'bu_conflict_resolver_dns_not_installed' => 'لم يتم تثبيت خدمة DNS. لن تتم استعادة إعدادات DNS للكائنات التالية: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'لا يمكن استعادة الاشتراكات التالية لأنه تم نقلها إلى مالكين آخرين: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'لا يمكن استعادة الاشتراكات التالية لأنه تم نقلها إلى موفري خدمة آخرين: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'يتعذر العثور على أداة استعادةWeb Presence Builder لاستعادة بيانات Web Presence Builder. من المحتمل أن يكون Presence Builder غير مثبت.',
    'backup__restore__capability_renamed_db' => 'إن اسم قاعدة البيانات "1%" مُستخدم بالفعل من قِبل اشتراك آخر. سيتم تغيير اسم قاعدة البيانات المستعادة إلى "2%".',
    'backup__restore__capability_renamed_db_user' => 'إن اسم مستخدم قاعدة البيانات "1%" مُستخدم بالفعل من قِبل اشتراك آخر. سيتم تغيير اسم مستخدم قاعدة البيانات المستعادة إلى "2%".',
    'backup__restore__capability_not_installed_perl_resolution' => 'لا يدعم تطبيق Plesk Installer تطبيق Perl. يُرجى تثبيت ActiveState Perl يدويًا.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (المعرّف=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% الذي تقدمه Apache (المعرّف=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% الذي تقدمه nginx (المعرّف=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'برنامج Kaspersky لمكافحة الفيروسات',
    '__drweb' => 'برنامج Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'تعارضات التوقيت',
    'backup__restore__hint_timing_conflicts' => 'تحدث تعارضات التوقيت إما عندما يكون الكائن المستعاد موجود بالفعل في النظام بتاريخ تعديل أحدث، أو عندما لا يكون الكائن المستعاد موجودًا حاليًا في النظام.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'استخدام التكوين والبيانات من النسخ الاحتياطي.',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'الكتابة بشكل كامل فوق تكوين الكائن وبياناته الموجودة حاليًا في النظام باستخدام التكوين والبيانات من ملف النسخ الاحتياطي. إذا كان الكائن المستعاد ينتمي حاليًا إلى مالكٍ آخر، فستتم استعادة الكائن ضِمن المالك السابق.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'استخدام التكوين من النظام الحالي والبيانات من النسخ الاحتياطي',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'قم بالكتابة فوق بيانات الكائن الحالية باستخدام البيانات من ملف النسخ الاحتياطي، ولكن حافظ على تكوين الكائن الموجود حاليًا في النظام. إذا كان الكائن المستعاد ينتمي حاليًا لمالك آخر، فستتم استعادة الكائن ضِمن المالك الحالي.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'عدم الاستعادة',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'لا تقم باستعادة الكائنات التي تتضمن تعارضات في التوقيت.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'تعارضات استخدام المورد',
    'backup__restore__hint_resource_usage_conflicts' => 'تحدث تعارضات في استخدام المورد عندما يتم تجاوز حدود استخدام المورد للكائن المستعاد عند الاستعادة.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'السماح بالاستخدام الشديد',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'قم باستعادة الكائن والسماح له باستخدام المزيد من الموارد عما يتم توفيره بشكل افتراضي.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'عدم الاستعادة',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'لا تقم باستعادة الكائنات التي تتضمن تعارضات في استخدام المورد.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'تعارضات التكوين',
    'backup__restore__hint_configuration_conflicts' => 'تحديث تعارضات التكوين عندما يكون للكائن المستعاد إعدادات معينة وتطبيقات ويب غير متوفرة أو محظورة من قِبل سياسة الخادم الحالي أو سياسة مالك الكائن. على سبيل المثال، ستحدث تعارضات التكوين إذا كان لحسابات البريد المستعادة إعدادات فلترة فردية للبريد العشوائي بينما تمنع السياسة الحالية للخادم حسابات البريد من الحصول على هذه الإعدادات.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'تلقائي',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'قم باستعادة الكائن والتشغيل التلقائي لجميع خيارات التكوين المتعارضة التي تسمح الأذونات الخاصة بك بإدراتها.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'عدم الاستعادة',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'لا تقم باستعادة الكائنات التي تتضمن تعارضات في التكوين.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'إن تجمعات تطبيقات IIS المخصصة غير مسموح بها في إعدادات مجموعة تطبيقات IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'يُرجى تغيير إعدادات مجموعة تطبيقات IIS في "الأدوات والإعدادات> مجموعة تطبيقات IIS> الإعدادات العامة.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'إن تجمعات تطبيق IIS المشتركة غير مسموح بها في إعدادات مجموعة تطبيقات IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'يُرجى تغيير إعدادات مجموعة تطبيقات IIS في "الأدوات والإعدادات> مجموعة تطبيقات IIS> الإعدادات العامة.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'غير مسموح بأسماء حسابات بريد POP3/IMAP القصيرة على الخادم الوجهة.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'لن تكون الأسماء القصيرة لحسابات البريد متوفرة بعد استعادة البيانات.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'يتعذر فتح ملف السجل.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'تتعذر استعادة الاشتراك 1%:  تمت إزالته من حسابك وليس لديك الإذن لإنشاء الاشتراكات. إذا رغبت في استعادته، فيُرجى الاتصال بموفر الخدمة لديك.',

    'backup__error11' => 'مساحة القرص غير كافية للنسخ الاحتياطي.',
    'backup__error3011' => 'تم رفض الاتصال: لا توجد برامج مثبتة على العنوان والمنفذ المحددين.',
    'backup__error3012' => 'مهلة الاتصال.',
    'backup__error3013' => 'لا يمكن الوصول إلى الشبكة.',
    'backup__error3014' => 'لا يوجد مسار إلى المضيف.',
    'backup__error3015' => 'أخفق الاتصال.',
    'backup__error3016' => 'يتعذر حل اسم المضيف.',
    'backup__error3017' => 'اسم المستخدم أو كلمة المرور غير صالحة.',
    'backup__error3018' => 'أخفق اتصال SSH.',

    'backup__error3110' => 'يتعذر الاتصال بوكيل الترحيل البعيد: الاتصال بالمضيف غير متوفر.',
    'backup__error3111' => 'تم تأمين وكيل الترحيل بسبب مهمة ترحيل غير ناجحة أو أنه قيد الاستخدام من قِبل عملية ترحيل أخرى. يُرجى إعادة تشغيل وكيل الترحيل على الخادم المصدر.',
    'backup__error3112' => 'الاتصال بالمضيف غير متوفر أو أن وكيل الترحيل لا يعمل على المضيف المصدر.',
    'backup__error3113' => 'يتعذر نشر وكيل الترحيل إلى مضيف Linux. يُرجى التحقق من اتصال SSH بالمضيف المصدر.',
    'backup__error3114' => 'يتعذر نشر وكيل الترحيل إلى مضيف Linux: أخفق اتصال SSH.',
    'backup__error3115' => 'اسم المستخدم أو كلمة المرور غير صالحة.',
    'backup__error3116' => 'لا يتمتع المستخدم المحدد بامتيازات إدارية.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'جميع عمليات التكوين والمحتوى',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'جميع عمليات التكوين والمحتوى باستثناء البريد',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'تكوين البريد والمحتوى فقط',

    'dns_t__unable_to_remove_ns_record' => 'تتعذر إزالة سجل NS من قالب DNS: يجب أن يكون لكل منطقة DNS سجل NS واحد على الأقل.',
    'dns__unsupported_server_zone_transfer' => 'يتعذر نقل "قالب القيود على النقل" بسبب تكوين DNS الخاص بالخادم: يُسمح في الخادم المصدر بعناوين الشبكة التالية من أجل نقل المنطقة، ولكن هذه العناوين ممنوعة من قبل خادم Microsoft DNS: 1%',
    'dns__unsupported_domain_zone_transfer' => 'يتعذر نقل "قالب القيود على النقل" بسبب تكوين DNS الخاص بالمجال: يُسمح في بعض المجالات بعناوين الشبكة التالية من أجل نقل المنطقة، ولكن هذه العناوين ممنوعة من قبل خادم Microsoft DNS: 1%',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'تحديد تخطيط خوادم قاعدة البيانات',
    'dbbackup__check_network_settings_failed' => 'يتعذر الوصول إلى دليل الشبكة المؤقتة المشتركة للحصول على ملفات النسخ الاحتياطي. يُرجى التحقق من إعدادات دليل الشبكة، واسم المستخدم وكلمة المرور. الخطأ: 1%',

    'migration_select_exist_db_server' => 'حدد خادم قاعدة بيانات الوجهة',

    'dbbackup__temp_dir_wrong_value' => 'تم تحديد القيمة غير الصالحة للدليل المؤقت.',
    'dbbackup__network_temp_dir_wrong_value' => 'تم تحديد القيمة غير الصالحة لدليل الشبكة المؤقتة.',
    'dbbackup__server_backup_not_configured' => 'لم يتم تكوين إعدادات النسخ الاحتياطي لقاعدة البيانات على الخادم.',
    'dbbackup__temp_dir' => 'الدليل المؤقت',
    'dbbackup__temp_dir_hint' => 'المسار إلى المجلد الفعلي على الخادم البعيد حيث يوجد خادم MS SQL. يجب أن يتمكن خادم MS SQL من الوصول إلى هذا المجلد لقراءة ملفات النسخ الاحتياطي المؤقتة وكتابتها. على سبيل المثال، C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => '‫تم تعيين المسار إلى مشاركة الشبكة المعين للمجلد الفعلي المحدد أعلاه.‬ ‫سيصل Plesk إلى المجلد المشترك لتنزيل ملفات النسخ الاحتياطي وتحميلها.‬ ‫على سبيل المثال، \\\\ServerName\\DirectoryPath‬',
    'dbbackup__network_user_hint' => 'اسم المستخدم لمستخدم الشبكة الذي تم إنشاؤه على الخادم البعيد. على سبيل المثال \\ServerName\\UserName. يجب أن يتمكن المستخدم من الوصول إلى المجلد المحدد أعلاه.',
    'dbbackup__network_password_hint' => 'كلمة مرور مستخدم الشبكة',

    'dbbackup__success_import_without_dublicate_users' => 'لم يتم استيراد المستخدمين التالين: 1%. حيث إنهم موجودون بالفعل على خادم قاعدة البيانات.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "ضغط ملفات السجل",
    'log_rot__log_rot_status' => "تسجيل حالة التناوب",
    'log_rot__log_rot_period' => "شرط تدوير السجل",
    'log_rot__log_rot_size' => "حسب الحجم",
    'log_rot__log_rot_time' => "حسب الوقت",
    'log_rot__logrotation_enable' => "تشغيل تدوير السجل",
    'log_rot__mail' => "إرسال ملفات السجل إلى البريد الإلكتروني",
    'log_rot__max_number_of_logfiles' => "الحد الأقصى لعدد ملفات السجل",
    'log_rot__time_period' => "الفترة",
    'log_rot__unable_turn_off' => 'يتعذر إيقاف تشغيل دوران السجل نظرًا لأنه تم فرضه على مستوى الخادم',
    'log_rot__unable_set_period' => 'تعذر تعيين فترة دوران السجل مختلفة عن \\ \'daily \'، لأنه تم فرضه على مستوى الخادم',
    'log_rot__unable_set_max_log_files' => 'تعذر تعيين حدٍ أقصى لعدد ملفات السجل أكبر من الحد 1٪ على مستوى الخادم',

    /// action log
    // common/various
    'actionlog__digit_expected' => "عدد متوقع: 1%",
    'actionlog__incorrect_rotation' => "تم تحديد معلمات تدوير سجل غير صالحة: 1%",
    'actionlog__unknown_rot_period' => "فترة تدوير غير معروفة: 1%",
    'actionlog__unknown_rot_type' => "نوع تدوير غير معروف: 1%",
    'actionlog__session_preferences' => 'إعدادات الجلسة',
    // items (PFU schema)
    'actionlog__admin_info' => 'معلومات المسؤول',
    'actionlog__admin_preferences' => "تفضيلات المسؤول",
    'actionlog__service' => 'الخدمة',
    'actionlog__ip_addr' => 'عنوان IP',
    'actionlog__client' => 'حساب العميل',
    'actionlog__client_status' => 'حالة حساب العميل',
    'actionlog__client_preferences' => "تفضيلات واجهة العميل",
    'actionlog__client_ip_pool' => "تجمع IP للعميل",
    'actionlog__client_siteapp' => "تجمع تطبيق ويب الخاص بالمستخدم",
    'actionlog__client_guid' => "معرف GUID الخاص بالعميل",
    'actionlog__domain' => 'المجال الافتراضي (تمت إضافة أول مجال إلى الاشتراك)',
    'actionlog__domain_owner' => 'مالك الاشتراك',
    'actionlog__domain_plan' => '‫خطة خدمة الاشتراك‬',
    'actionlog__domain_status' => 'حالة المجال الافتراضي',
    'actionlog__domain_dns' => 'منطقة DNS للمجال الافتراضي',
    'actionlog__subdomain' => 'المجال الفرعي للمجال الافتراضي',
    'actionlog__domain_alias' => 'اسم مستعار للمجال الافتراضي',
    'actionlog__domain_alias_dns' => 'منطقة DNS للاسم المستعار للمجال الافتراضي',
    'actionlog__site' => 'المجال',
    'actionlog__site_status' => 'حالة المجال',
    'actionlog__site_dns' => 'منطقة DNS للمجال',
    'actionlog__site_guid' => 'قيمة GUID للمجال',
    'actionlog__site_subdomain' => 'المجال الفرعي',
    'actionlog__site_alias' => 'اسم مستعار للمجال',
    'actionlog__site_alias_dns' => 'منطقة DNS للاسم المستعار للمجال',
    'actionlog__domain_limits' => 'حدود الاشتراك',
    'actionlog__domain_limit_size' => 'حد مساحة القرص الخاصة بالاشتراك',
    'actionlog__domain_limit_traffic' => 'حد حركة مرور البيانات الخاصة بالاشتراك',
    'actionlog__domain_limits_powerUser' => 'حدود الاشتراك',
    'actionlog__domain_limit_size_powerUser' => 'حد مساحة القرص للاشتراك',
    'actionlog__domain_limit_traffic_powerUser' => 'حد حركة المرور للاشتراك',
    'actionlog__domain_guid' => "قيمة GUID للمجال الافتراضي",
    'actionlog__cp_user' => 'مستخدم Plesk',
    'actionlog__mailname' => 'حساب البريد',
    'actionlog__maillist' => 'قائمة المراسلة',
    'actionlog__phosting' => 'إعدادات الاستضافة',
    'actionlog__forwarding' => 'الاستضافة القياسية أو استضافة إعادة توجيه الإطار',
    'actionlog__webuser' => 'حساب مستخدم الويب',
    'actionlog__site_application' => 'تطبيق الويب',
    'actionlog__license' => 'مفتاح الترخيص',
    'actionlog__additional_license' => 'مفتاح ترخيص إضافي',
    'actionlog__template_domain' => "خطة خدمة بائع التجزئة",
    'actionlog__template_admin' => "خطة خدمة للمسؤول",
    'actionlog__template_reseller' => 'خطة بائع التجزئة',
    'actionlog__admin_alias' => 'حساب إضافي للمسؤول', // PFW
    'actionlog__ftpuser' => 'حساب FTP إضافي', // PFW
    'actionlog__db_server' => 'خادم قاعدة البيانات',
    'actionlog__db' => 'قاعدة بيانات',
    'actionlog__db_user' => 'حساب مستخدم قاعدة البيانات',
    'actionlog__client_sapppkg_pool' => "تطبيق ويب الخاص بالمستخدم", // PFW, not used?
    'actionlog__remote_dns' => 'حالة خادم DNS البعيد', // PFW
    'actionlog__reseller' => 'حساب بائع التجزئة',
    'actionlog__reseller_guid' => 'قيمة GUID لبائع التجزئة',
    'actionlog__reseller_ip_pool' => "تجمع IP لبائع التجزئة",
    'actionlog__reseller_limit_size' => 'حد مساحة القرص الخاص بحساب بائع التجزئة',
    'actionlog__reseller_limit_traffic' => 'حد حركة مرور البيانات الخاص بحساب بائع التجزئة',
    'actionlog__reseller_limits' => 'حدود حساب بائع التجزئة',
    'actionlog__reseller_permissions' => 'أذونات بائع التجزئة',
    'actionlog__reseller_preferences' => "تفضيلات واجهة بائع التجزئة",
    'actionlog__reseller_siteapp' => "تطبيقات الويب في التجمع الخاص ببائع التجزئة",
    'actionlog__reseller_status' => 'حالة حساب بائع التجزئة',
    'actionlog__health_status' => 'حالة صيانة الخادم',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'تم الوصول',
    'actionlog__added' => 'مضاف',
    'actionlog__removed' => 'تمت الإزالة',
    'actionlog__change' => 'تم تغييره',
    'actionlog__update' => 'تم التحديث',
    'actionlog__move' => 'تم نقله',
    'actionlog__upgrade' => 'تمت الترقية', // PFU?
    'actionlog__update_or_add' => 'تم التحديث أو الإضافة',
    'actionlog__expired' => 'انتهت الصلاحية',
    'actionlog__create' => 'تم الإنشاء',
    'actionlog__delete' => 'تم الحذف',
    'actionlog__service_stop' => 'متوقف',
    'actionlog__service_restart' => 'تمت إعادة التشغيل',
    'actionlog__service_start' => 'بدأ',
    'actionlog__login' => 'قيد تسجيل الدخول',
    'actionlog__logout' => 'سجّل الخروج',
    'actionlog__install' => 'مثبّت',
    'actionlog__uninstall' => 'تم إلغاء التثبيت',
    'actionlog__reconfigure' => 'تمت إعادة التكوين',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'طلب إعادة تعيين كلمة المرور',
    'actionlog__event_admin_update' => 'تم تحديث معلومات المسؤول',
    'actionlog__event_admin_preferences_update' => "تم تحديث تفضيلات المسؤول",
    'actionlog__event_service_restart' => 'تمت إعادة تشغيل الخدمة',
    'actionlog__event_service_start' => 'تم بدء الخدمة',
    'actionlog__event_service_stop' => 'تم إيقاف الخدمة',
    'actionlog__event_ip_address_create' => 'تم إنشاء عنوان IP',
    'actionlog__event_ip_address_delete' => 'تم حذف عنوان IP',
    'actionlog__event_ip_address_update' => 'تم تحديث عنوان IP',
    'actionlog__event_client_create' => 'تم إنشاء حساب العميل',
    'actionlog__event_client_delete' => 'تم حذف حساب العميل',
    'actionlog__event_client_update' => 'تم تحديث حساب العميل',
    'actionlog__event_client_status_update' => 'تم تحديث حالة حساب العميل',
    'actionlog__event_client_preferences_update' => "تم تحديث تفضيلات واجهة العميل",
    'actionlog__event_client_siteapp_added' => "تم إضافة تطبيق ويب إلى تجمع تطبيقات حساب العميل",
    'actionlog__event_client_siteapp_removed' => "تم حذف تطبيق ويب من تجمع تطبيقات حساب العميل",
    'actionlog__event_domain_limit_size_reached' => 'تم الوصول إلى حد مساحة القرص الخاص بالاشتراك',
    'actionlog__event_domain_limit_traffic_reached' => 'تم الوصول إلى حد حركة مرور البيانات الخاص بالاشتراك',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'تم الوصول إلى حد مساحة القرص للاشتراك',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'تم الوصول إل حد حركة المرور للاشتراك',

    'actionlog__domain_limit_database' => 'حصة قاعدة البيانات الخاصة بالاشتراك',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'تم الوصول إلى حصة قواعد بيانات MySQL الخاصة بالاشتراك',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'تم الوصول إلى الحصة المرنة لقواعد بيانات MySQL الخاصة بالاشتراك',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'تم الوصول إلى حصة قواعد بيانات خادم Microsoft SQL الخاصة بالاشتراك',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'تم الوصول إلى الحصة المرنة لقواعد بيانات خادم Microsoft SQL الخاصة بالاشتراك',
    'actionlog__event_plesk_component_upgrade' => 'تم تحديث مكون منصة Plesk',
    'actionlog__event_plesk_component_install' => 'تم تثبيت مكون منصة Plesk',
    'actionlog__event_plesk_component_uninstall' => 'تم إلغاء تثبيت مكون منصة Plesk',
    'actionlog__event_domain_create' => 'تم إنشاء المجال الافتراضي (تمت إضافة أول مجال إلى الاشتراك)',
    'actionlog__event_domain_delete' => 'تم حذف المجال الافتراضي (تمت إضافة أول مجال إلى الاشتراك)',
    'actionlog__event_domain_update' => 'تم تحديث المجال الافتراضي (تمت إضافة أول مجال إلى الاشتراك)',
    'actionlog__event_domain_owner_change' => 'تم تغيير مالك الاشتراك',
    'actionlog__event_domain_plan_change' => '‫تم تغيير خطة خدمة الاشتراك‬',
    'actionlog__event_domain_status_update' => 'تم تحديث حالة المجال الافتراضي',
    'actionlog__event_domain_dns_update' => 'تم تحديث منطقة DNS للمجال الافتراضي',
    'actionlog__event_subdomain_create' => 'تم إنشاء المجال الفرعي للمجال الافتراضي',
    'actionlog__event_subdomain_delete' => 'تم حذف المجال الفرعي للمجال الافتراضي',
    'actionlog__event_subdomain_update' => 'تم تحديث المجال الفرعي للمجال الافتراضي',
    'actionlog__event_domain_alias_create' => 'تم إنشاء اسم مستعار للمجال الافتراضي',
    'actionlog__event_domain_alias_delete' => 'تم حذف الاسم المستعار للمجال الافتراضي',
    'actionlog__event_domain_alias_update' => 'تم تحديث الاسم المستعار للمجال الافتراضي',
    'actionlog__event_domain_limits_update' => 'تم تحديث حدود الاشتراك',
    'actionlog__event_cp_user_login' => 'قام مستخدم Plesk بتسجيل الدخول',
    'actionlog__event_cp_user_logout' => 'قام مستخدم Plesk بتسجيل الخروج',
    'actionlog__event_mailname_create' => 'تم إنشاء حساب البريد',
    'actionlog__event_mailname_delete' => 'تم حذف حساب البريد',
    'actionlog__event_mailname_update' => 'تم تحديث حساب البريد',
    'actionlog__event_maillist_create' => 'تم إنشاء قائمة مراسلة',
    'actionlog__event_maillist_delete' => 'تم حذف قائمة المراسلة',
    'actionlog__event_maillist_update' => 'تم تحديث قائمة المراسلة',
    'actionlog__event_phys_hosting_create' => 'تم إنشاء الاستضافة المادية',
    'actionlog__event_phys_hosting_delete' => 'تم حذف الاستضافة المادية',
    'actionlog__event_phys_hosting_update' => 'تم تحديث الاستضافة المادية',
    'actionlog__event_forwarding_create' => 'تم إنشاء الاستضافة القياسية أو استضافة إعادة توجيه الإطار',
    'actionlog__event_forwarding_delete' => 'تم حذف الاستضافة القياسية أو استضافة إعادة توجيه الإطار',
    'actionlog__event_forwarding_update' => 'تم تحديث الاستضافة القياسية أو استضافة إعادة توجيه الإطار',
    'actionlog__event_webuser_create' => 'تم إنشاء حساب مستخدم الويب',
    'actionlog__event_webuser_delete' => 'تم حذف حساب مستخدم الويب',
    'actionlog__event_webuser_update' => 'تم تحديث حساب مستخدم الويب',
    'actionlog__event_siteapp_install' => 'تم تثبيت تطبيق الويب',
    'actionlog__event_siteapp_reconfigure' => 'تمت إعادة تكوين تطبيق الويب',
    'actionlog__event_siteapp_uninstall' => 'تم إلغاء تثبيت تطبيق الويب',
    'actionlog__event_license_update' => 'تم تحديث مفتاح الترخيص',
    'actionlog__event_admin_alias_create' => 'تم إنشاء حساب إضافي للمسؤول',
    'actionlog__event_admin_alias_delete' => 'تم حذف حساب إضافي للمسؤول',
    'actionlog__event_admin_alias_update' => 'تم تحديث حساب إضافي للمسؤول',
    'actionlog__event_ftpuser_create' => 'تم إنشاء حساب FTP إضافي',
    'actionlog__event_ftpuser_update' => 'تم تحديث حساب FTP الإضافي',
    'actionlog__event_ftpuser_delete' => 'تم حذف حساب FTP الإضافي',
    'actionlog__event_template_domain_create' => "تم إنشاء خطة خدمة لبائع التجزئة",
    'actionlog__event_template_domain_update' => "تم تحديث خطة خدمة بائع التجزئة",
    'actionlog__event_template_domain_delete' => "تم حذف خطة خدمة بائع التجزئة",
    'actionlog__event_template_admin_create' => "تم إنشاء خطة خدمة للمسؤول",
    'actionlog__event_template_admin_update' => "تم تحديث خطة خدمة المسؤول",
    'actionlog__event_template_admin_delete' => "تم حذف خطة خدمة المسؤول",
    'actionlog__event_database_server_create' => 'تم إنشاء خادم قاعدة البيانات',
    'actionlog__event_database_server_update' => 'تم تحديث خادم قاعدة البيانات',
    'actionlog__event_database_server_delete' => 'تم حذف خادم قاعدة البيانات',
    'actionlog__event_remote_dns_status_update' => 'تم تحديث حالة خادم DNS البعيد',
    'actionlog__event_session_preferences_update' => 'تم تحديث إعدادات الجلسة',
    'actionlog__event_domain_alias_dns_update' => 'تم تحديث منطقة DNS للاسم المستعار للمجال الافتراضي',
    'actionlog__event_domain_move' => 'تم نقل النطاق الافتراضي إلى اشتراك جديد',
    'actionlog__event_site_move' => 'تم نقل النطاق إلى اشتراك جديد',
    'actionlog__event_site_subdomain_move' => 'تم نقل النطاق الفرعي إلى اشتراك جديد',
    'actionlog__event_subdomain_move' => 'تم نقل النطاق الفرعي للنطاق الافتراضي إلى اشتراك جديد',
    'actionlog__event_license_expired' => 'انتهت صلاحية ترخيص تطبيق Plesk',
    'actionlog__event_database_create' => 'تم إنشاء قاعدة البيانات',
    'actionlog__event_database_delete' => 'تم حذف قاعدة البيانات',
    'actionlog__event_database_user_create' => 'تم إنشاء حساب مستخدم قاعدة البيانات',
    'actionlog__event_database_user_update' => 'تم تحديث إعدادات حساب مستخدم قاعدة البيانات',
    'actionlog__event_database_user_delete' => 'تم حذف حساب مستخدم قاعدة البيانات',
    'actionlog__event_client_guid_update' => "تم تحديث قيمة GUID الخاصة بالعميل",
    'actionlog__event_domain_guid_update' => 'تم تحديث قيمة GUID للمجال الافتراضي',
    'actionlog__event_reseller_create' => 'تم إنشاء حساب بائع التجزئة',
    'actionlog__event_reseller_delete' => 'تم حذف حساب بائع التجزئة',
    'actionlog__event_reseller_update' => 'تم تحديث حساب بائع التجزئة',
    'actionlog__event_reseller_guid_update' => 'تم تحديث قيمة GUID لبائع التجزئة',
    'actionlog__event_reseller_ip_pool_update' => "تم تحديث تجمع IP لبائع التجزئة",
    'actionlog__event_reseller_limit_size_reached' => 'تم الوصول إلى حد مساحة القرص الخاص بحساب بائع التجزئة',
    'actionlog__event_reseller_limit_traffic_reached' => 'تم الوصول إلى حد حركة مرور البيانات الخاص بحساب بائع التجزئة',
    'actionlog__event_reseller_limits_update' => 'تم تحديث حدود حساب بائع التجزئة',
    'actionlog__event_reseller_permissions_update' => 'تم تحديث أذونات حساب بائع التجزئة',
    'actionlog__event_reseller_preferences_update' => "تم تحديث تفضيلات واجهة بائع التجزئة",
    'actionlog__event_reseller_siteapp_added' => "تمت إضافة تطبيق إلى تجمع تطبيقات حساب بائع التجزئة",
    'actionlog__event_reseller_siteapp_removed' => "تم حذف التطبيق من تجمع تطبيقات حساب بائع التجزئة",
    'actionlog__event_reseller_status_update' => 'تم تحديث حالة حساب بائع التجزئة',
    'actionlog__event_template_reseller_create' => 'تم إنشاء خطة بائع التجزئة',
    'actionlog__event_template_reseller_delete' => 'تم حذف خطة بائع التجزئة',
    'actionlog__event_template_reseller_update' => 'تم تحديث خطة بائع التجزئة',
    'actionlog__event_health_status_change' => 'تغيرت حالة صيانة الخادم',
    'actionlog__event_siteapp_upgrade' => 'تمت ترقية تطبيق الويب',
    'actionlog__event_extension_install' => 'تم تثبيت الملحق',
    'actionlog__event_extension_uninstall' => 'تم إلغاء تثبيت الملحق',
    'actionlog__event_extension_upgrade' => 'تم ترقية الملحق',
    'actionlog__event_extension_status_update' => 'تم تحديث حالة الملحق',
    'actionlog__event_additional_license_expired' => 'انتهت صلاحية الترخيص الإضافي',
    'actionlog__event_hostname_changed' => 'تم تغيير اسم مضيف الخادم',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "إن Plesk API RPC غير مثبت على المضيف البعيد. اتصل بموفر الخدمة لديك للحصول على المساعدة.",
    'rsession_no_account_errmsg' => "يتعذر الوصول إلى الخدمة البعيدة ضِمن حسابك. السبب الأكثر شيوعًا هو أن الخدمة الخاصة بحسابك غير نشطة بعد. يُرجى الانتظار لعدة دقائق، والمحاولة مجددًا. إذا صادفت هذا الخطأ مرة أخرى، فاتصل بمسؤول النظام لديك.",
    'rsession_no_domain_errmsg' => "يتعذر الوصول إلى الخدمة البعيدة بالنسبة إلى هذا المجال. السبب الأكثر شيوعًا هو أن الخدمة الخاصة بهذا المجال غير نشطة بعد. يُرجى الانتظار لعدة دقائق، والمحاولة مجددًا. إذا صادفت هذا الخطأ مرة أخرى، فاتصل بمسؤول النظام لديك.",
    'rsession_unknown_errmsg' => "رفض الخادم البعيد محاولة إنشاء جلسة عمل. اتصل بمسؤول النظام للحصول على الدعم. كان الخطأ: 1%",
    'rsession_unknown2_errmsg' => "حدث خطأ غير معروف أثناء إنشاء جلسة عمل بعيدة. من المرجح بشكل كبير أن الخادم البعيد لا يستجيب بشكل صحيح أو لا يجيب على الإطلاق. اطلب من مسؤول النظام أن يبحث عن تفاصيل الخطأ في سجل الأخطاء لخادم الويب.",
    'rsession_no_connect_errmsg' => "يتعذر الوصول إلى الخدمة البعيدة: فشل الاتصال بجلسة العمل البعيدة. اتصل بمسؤول النظام للحصول على الدعم.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "السماح بالتحميل إلى دليل الوارد",
    'anonftp__allow_create_dirs' => 'السماح بإنشاء دلائل في دليل الوارد',
    'anonftp__allow_download_incoming' => 'السماح بالتنزيل من دليل الوارد',
    'anonftp__display_login' => 'عرض رسالة تسجيل الدخول',
    'anonftp__login_text' => 'نص الرسالة',
    'anonftp__limit_incoming_disk_space' => "مساحة القرص محدودة في دليل الوارد",
    'anonftp__limit_maximum_bandwidth' => "تحديد النطاق الترددي للتنزيل بالنسبة إلى مجال FTP الظاهري",
    'anonftp__limit_maximum_connections' => "عدد محدود من الاتصالات المتزامنة",
    'anonftp__unable_init' => "يتعذر بدء حساب FTP باسم مجهول: 1%",
    'anonftp__unable_set_quota' => "يتعذر تعيين حد مساحة القرص للدليل: 1%",
    'anonftp__unable_update' => "يتعذر تحديث خصائص حساب FTP باسم مجهول: 1%",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'شهادات SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "إن شهادة CA لا تضيف علامة للشهادة.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "زوج غير متوافق من المفتاح الخاص/الشهادة.",
    'class_sslcertificate__invalid_cert_format' => "تنسيق الشهادة غير صالح.",
    'class_sslcertificate__invalid_private_key_format' => "تنسيق مفتاح خاص غير صالح.",
    'class_sslcertificate__prob_invalid_priv_key' => "ربما يكون تنسيق المفتاح الخاص غير صالح.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'إنشاء دليل ظاهري',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'إنشاء دليل ظاهري',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'إنشاء دليل ظاهري.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'إنشاء دليل ظاهري',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'إنشاء دليل ظاهري',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'إنشاء دليل ظاهري.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'إنشاء دليل',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'إنشاء دليل',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'إنشاء دليل.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'إنشاء دليل',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'إنشاء دليل',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'إنشاء دليل.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'خصائص الدليل',
    'ui__client/domain/hosting/web-directories/properties__title' => 'خصائص الدليل الظاهري',
    'ui__client/domain/hosting/web-directories/properties__description' => 'عرض خصائص الدليل الظاهري وتغييرها.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'خصائص الدليل',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'خصائص الدليل الظاهري',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'عرض خصائص الدليل الظاهري وتغييرها.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'أذونات الوصول إلى الدليل',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'أذونات الوصول إلى الدليل',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'إعداد أذونات الوصول إلى الدليل.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'أذونات الوصول إلى الدليل',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'أذونات الوصول إلى الدليل',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'إعداد أذونات الوصول إلى الدليل.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'إعدادات ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'إعدادات ASP.NET لـ 1%',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'تكوين إعدادات ASP.NET للدليل الظاهري 1%.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'إعدادات ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'إعدادات ASP.NET لـ 1%',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'تكوين إعدادات ASP.NET للدليل الظاهري 1%.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'تغيير الإصدار',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'تغيير الإصدار',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'تغيير إصدار ASP.NET الذي يستخدمه الدليل الظاهري  1%.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'تغيير الإصدار',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'تغيير الإصدار',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'تغيير إصدار ASP.NET الذي يستخدمه الدليل الظاهري  1%.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'إعدادات PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'إعدادات PHP لـ 1%',
    'ui__client/domain/hosting/web-directories/php__description' => 'تكوين إعدادات PHP الخاصة بالدليل الظاهري 1%.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'إعدادات PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'إعدادات PHP لـ 1%',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'تكوين إعدادات PHP الخاصة بالدليل الظاهري 1%.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'إزالة',
    'ui__client/domain/hosting/web-directories/delete__title' => 'إزالة الأدلة الظاهرية',
    'ui__client/domain/hosting/web-directories/delete__description' => 'إزالة الأدلة الظاهرية المحددة.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'إزالة',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'إزالة الأدلة الظاهرية',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'إزالة الأدلة الظاهرية المحددة.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'ستتم إزالة الأدلة الظاهرية التالية:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'يجب تحديد الدلائل التي تريد إزالتها.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'أنواع MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'أنواع MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'عرض قائمة بأنواع MIME المسجلة.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'إضافة نوع MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'إضافة نوع MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'تسجيل نوع MIME جديد.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'مستندات الخطأ',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'مستندات الخطأ',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'عرض مستندات الخطأ وتغييرها.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'الحماية',
    'ui__client/domain/hosting/web-directories/protection__title' => 'حماية الدليل',
    'ui__client/domain/hosting/web-directories/protection__description' => 'تقييد الوصول إلى الدليل باستخدام حماية بكلمة مرور.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'الحماية',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'حماية الدليل',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'تقييد الوصول إلى الدليل باستخدام حماية بكلمة مرور.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'الإعدادات',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'عرض موقع الدليل وتحديد العنوان الخاص بالمنطقة المحمية.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'إضافة مستخدم',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'أضف حساب مستخدم لكي يتم السماح بالوصول إلى الدليل المحمي.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'تم تطبيق الإعدادات الجديدة.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'تمت إضافة حساب المستخدم.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'إزالة',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'إزالة مستخدمي الدليل المحمي.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'إزالة حسابات المستخدم',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'تأكيد الإزالة لحسابات المستخدم.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'تمت إزالة حسابات المستخدم.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => 'تم بدء عملية التحقق من الأذونات. وفقًا لإكمال عملية الفحص، سيتم إرسال تنبيه إلى عنوان البريد الإلكتروني التالية: 1%', // PFW

    // UI
    'ui____done' => 'اكتملت العملية بنجاح.',
    'ui__admin/extras-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__admin/interface__done' => 'تم حفظ التغييرات في تفضيلات الواجهة لمسؤول الخادم.',
    'ui__admin/report/layout/delete_multi__done' => 'تمت إزالة مخططات التقارير المحددة.',
    'ui__admin/report/traffic-history__done' => 'اكتملت العملية بنجاح.',
    'ui__admin/report__done' => 'اكتملت العملية بنجاح.',
    'ui__admin-alias/delete_multi__done' => "تمت إزالة حسابات المسؤول الإضافية المحددة.",
    'ui__admin-alias/properties__done' => "تم تحديث خصائص حساب المسؤول الإضافي.",
    'ui__admin-alias/properties_new__done' => "تم إنشاء حساب المسؤول الإضافي.",
    'ui__admin-alias/properties_unknown__done' => "تم تحديث خصائص حساب المسؤول الإضافي.",
    'ui__admin-alias__done' => "تم تحديث معلومات حساب المسؤول الإضافي بنجاح.",
    'ui__admin/manage-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__admin/register-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'تمت إزالة الجداول الزمنية لتسليم التقارير المحددة.',
    'ui__admin/report/layout/auto/properties__done' => 'تم تحديث الجدول الزمني لتسليم التقرير.',
    'ui__admin/report/layout/auto/properties_new__done' => 'تم إنشاء جدول زمني لتسليم التقرير.',
    'ui__admin/report/layout/properties__done' => 'تم تحديث مخطط التقرير 1%.',
    'ui__admin/report/layout/properties_new__done' => 'تم إنشاء مخطط التقرير 1%.',
    'ui__client/chowner__done' => 'تم تعيين مالك جديد لحساب العميل 1%.',
    'ui__client/chowner_multi__done' => "تم نقل حسابات المستخدم المحددة إلى مالك جديد.",
    'ui__client/chowner_multi-select__done' => 'اكتملت العملية بنجاح.',
    'ui__client/chowner_select__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/certificate/properties__done' => 'تم تحديث خصائص شهادة SSL/TLS.',
    'ui__client/domain/certificate/properties_new__done' => 'تمت إضافة شهادة SSL/TLS جديدة. وليكون الأمر مفيدًا، تأكد من تحديدها في إعدادات استضافة موقع الويب (في مواقع الويب & علامة التبويب نطاقات / > اسم النطاق).',
    'ui__client/domain/certificate__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/certificate_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/check-permissions_multi__done' => 'انتهى فحص الأذونات للمجالات المحددة.', // PFW
    'ui__client/domain/chowner__done' => 'ينتمي الاشتراك 1% الآن إلى مستخدم آخر.',
    'ui__client/domain/chowner_multi__done' => 'تم تغيير ملكية الاشتراك.',
    'ui__client/domain/chowner_multi-select__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/chowner_select__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/dbbackup/create__done' => "تم النسخ الاحتياطي لقاعدة البيانات بنجاح.", // PFW
    'ui__client/domain/dbbackup/get__done' => "تم النسخ الاحتياطي لقاعدة البيانات بنجاح.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "تم إصلاح المستخدم المعزول.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "تم حذف ملفات النسخ الاحتياطي بنجاح.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "تمت استعادة محتوى قاعدة البيانات بنجاح.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "اكتملت العملية بنجاح.", // PFW
    'ui__client/domain/dbbackup__done' => "اكتملت العملية بنجاح.", // PFW
    'ui__client/domain/dbbackup_self__done' => "اكتملت العملية بنجاح.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "اكتملت العملية بنجاح.", // PFW
    'ui__client/domain/delete__done' => "تمت إزالة المجال 1%.",
    'ui__client/domain/delete_multi__done' => "تمت إزالة المجالات.",
    'ui__client/domain/disable__done' => 'تم تعليق المجال 1%.',
    'ui__client/domain/disable_multi__done' => 'تم تعليق المجالات المحددة.',
    'ui__client/domain/enable__done' => 'تم تنشيط موقع الويب 1%.',
    'ui__client/domain/enable_multi__done' => 'تم تنشيط مواقع الويب المحدد.',
    'ui__client/domain/extras__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/domain/extras_self__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'تم نسخ أو نقل الملفات أو الدلائل المحددة.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'تم إنشاء دليل.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'تم إنشاء ملف.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'تم تحديث الملف.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'تم تحديث أذونات الوصول إلى الملف أو الدليل.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'تمت إعادة تسمية الدليل أو الملف.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'تمت إزالة الملفات والأدلة المحددة.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'تمت إزالة الملفات والأدلة المحددة.',
    'ui__client/domain/hosting/file-manager/view__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/hosting/file-manager__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/hosting/file-manager_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'تم تغيير إعدادات تدوير السجل.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'تم تغيير إعدادات تدوير السجل.',
    'ui__client/domain/hosting/logs__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/hosting/logs_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/hosting/performance__done' => 'تم تعديل إعدادات أداء الاستضافة لموقع الويب 1%.',
    'ui__client/domain/hosting/performance_self__done' => 'تم تعديل إعدادات أداء الاستضافة لموقع الويب.',
    'ui__client/domain/hosting/performance_unknown__done' => 'تم تعديل إعدادات أداء استضافة الويب.',
    'ui__client/domain/hosting/php__done' => 'تم تغيير إعدادات PHP.', // PFW
    'ui__client/domain/hosting/php_self__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/hosting/protected-directories__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/hosting/setup__done' => 'تم تكوين الاستضافة لـ 1%.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'اكتملت العملية بنجاح.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'اكتملت العملية بنجاح.', // PFU
    'ui__client/domain/hosting/virtual-directories__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'تم تغيير إصدار ASP.NET.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'تم تغيير إعدادات ASP.NET الخاصة بـ 1%.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'تم إنشاء دليل ظاهري ضِمن موقع الويب 1%.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'تم إنشاء دليل ظاهري.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'تمت إزالة الدلائل المحددة.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'تمت إزالة الدلائل المحددة.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'تم تحديث مستندات الخطأ المخصصة.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'تمت إزالة أنواع MIME المحددة', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'تم تسجيل نوع MIME.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'تم تحديث أذونات الوصول إلى الدليل.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'تم تحديث أذونات الوصول إلى الدليل.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'تم تحديث إعدادات PHP الخاصة بـ 1%.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'تم تحديث إعدادات PHP الخاصة بـ 1%.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'تم تحديث خصائص الدليل.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'تم تحديث خصائص الدليل.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'تم تحديث إعدادات حماية الدليل.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'تم تحديث إعدادات حماية الدليل.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "اكتملت العملية بنجاح.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'شهادات SSL/TLS متوفرة في متجر عبر الإنترنت',
    'ui__client/domain/mpc-certificates_self__done' => 'شهادات SSL/TLS متوفرة في متجر عبر الإنترنت',
    'ui__client/domain/odbc__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/odbc_self__done' => 'اكتملت العملية بنجاح.', // PFW
    'ui__client/domain/properties__done' => "تم تغيير حساب مسؤول المجال.",
    'ui__client/domain/properties_new__done' => "تم إنشاء المجال 1%.",
    'ui__client/domain/properties_self__done' => "لقد تغيرت خصائص المجال الخاص بك.",
    'ui__client/domain/register__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/domain/register_self__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/domain/rename__done' => 'تم تغيير اسم المجال.',
    'ui__client/domain/rename_self__done' => "تم تغيير اسم المجال بنجاح.",
    'ui__client/domain/report/anon-ftp-stats__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/report/ftp-stats__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/report/ftp-stats_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/report/traffic-history__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/report/traffic-history_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/report/webalizer-preferences__done' => 'اكتملت العملية بنجاح.', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => 'اكتملت العملية بنجاح.', // PFU
    'ui__client/domain/report/web-stats__done' => 'تم فتح صفحة إحصائيات الويب.',
    'ui__client/domain/report/web-stats_self__done' => 'تم فتح صفحة إحصائيات الويب.',
    'ui__client/domain/report/web-stats-ssl__done' => 'تم فتح صفحة إحصائيات الويب.',
    'ui__client/domain/report/web-stats-ssl_self__done' => 'تم فتح صفحة إحصائيات الويب.',
    'ui__client/domain/report__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/report_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/settings_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/to-client__done' => 'تم تحويل حساب مسؤول المجال 1% إلى حساب عميل.',
    'ui__client/domain/to-client_multi__done' => 'تم تحويل حسابات مسؤول المجال إلى حسابات العميل.',
    'ui__client/domain/toggle_disable__done' => "تم تعليق المجال 1%.",
    'ui__client/domain/toggle_enable__done' => "تم تنشيط المجال 1%.",
    'ui__client/domain/traffic__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/traffic_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/traffic_unknown__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain/web-stats__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain-summary-report__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain-summary-report_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/domain-summary-report_unknown__done' => 'اكتملت العملية بنجاح.',
    'ui__client/extras-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/extras-domain_self__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/ipaddress/delete_multi__done' => 'اكتملت العملية بنجاح.',
    'ui__client/ipaddress/properties__done' => 'اكتملت العملية بنجاح.',
    'ui__client/ipaddress/properties_new__done' => 'اكتملت العملية بنجاح.',
    'ui__client/ip-pool/properties__done' => "تم تحديث تجمع IP للعميل %1\\.",
    'ui__client/ip-pool/properties_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/limits__done' => "لقد تغيرت القيود على المورد الخاصة بالعميل 1%.",
    'ui__client/limits_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/logo__done' => 'تم تطبيق إعدادات العلامة التجارية الجديدة على العميل1 %.',
    'ui__client/logo_reseller__done' => 'تم تطبيق إعدادات العلامة التجارية للوحة الجديدة.',
    'ui__client/logo_self__done' => 'تم تطبيق إعدادات العلامة التجارية.',
    'ui__client/logo_self-reseller__done' => 'تم تطبيق إعدادات العلامة التجارية للوحة الجديدة الخاصة بك.',
    'ui__client/manage-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/manage-domain_self__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/permissions__done' => "تم تغيير الأذونات الخاصة بالعميل 1%.",
    'ui__client/permissions_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/preferences__done' => "لقد تغيرت التفضيلات الخاصة بالعميل 1%.",
    'ui__client/preferences_self__done' => "تم تغيير التفضيلات الخاصة بك.",
    'ui__client/register-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/register-domain_self__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__client/report/traffic-history__done' => 'اكتملت العملية بنجاح.',
    'ui__client/report/traffic-history_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/report__done' => 'اكتملت العملية بنجاح.',
    'ui__client/report_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/sessions/delete__done' => 'اكتملت العملية بنجاح.',
    'ui__client/sessions/delete_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/sessions__done' => 'اكتملت العملية بنجاح.',
    'ui__client/sessions_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/skeleton__done' => 'اكتملت العملية بنجاح.',
    'ui__client/skeleton_self__done' => 'اكتملت العملية بنجاح.',
    'ui__client/to-reseller__done' => 'تم تحويل حساب العميل 1% إلى حساب بائع تجزئة.',
    'ui__client/to-reseller_multi__done' => "تم تحويل حسابات العميل المحددة إلى حسابات بائع تجزئة.",
    'ui__client/traffic__done' => "اكتملت العملية بنجاح.",
    'ui__client/traffic_unknown__done' => 'اكتملت العملية بنجاح.',
    'ui__cp-access__done' => 'اكتملت العملية بنجاح.',
    'ui__cp-session/properties__done' => 'اكتملت العملية بنجاح.',
    'ui__cp-session__done' => 'اكتملت العملية بنجاح.',
    'ui__ftp-sessions__done' => 'اكتملت العملية بنجاح.',
    'ui__license__done' => 'اكتملت العملية بنجاح.',
    'ui__logo__done' => "تم تغيير خصائص علامة Plesk التجارية.",
    'ui__longtasks/longtask/properties__done' => "تم تغيير إعدادات المهمة الخلفية بنجاح.",
    'ui__mass-email/delete__done' => "تمت إزالة قالب الرسالة 1%.", // PFW
    'ui__mass-email/delete_multi__done' => "تمت إزالة قوالب الرسالة.",  // PFW
    'ui__mass-email/send_main__done' => "اكتملت العملية بنجاح.",  // PFW
    'ui__mass-email/send_selectclients__done' => "تم تحديد حسابات العميل بنجاح.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "تم تحديد حسابات مسؤول المجال بنجاح.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'تم تحديد حسابات بائع التجزئة بنجاح.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'تم حفظ التغييرات في قالب رسالة البريد الإلكتروني المجمع.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'تم إنشاء قالب رسالة البريد الإلكتروني المجمع.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'تم تحديد حسابات العميل لقالب رسالة البريد الإلكتروني المجمع.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'تم تحديد حسابات مسؤول المجال لقالب رسالة البريد الإلكتروني المجمع.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'تم تحديد حسابات بائع التجزئة لقالب رسالة البريد الإلكتروني المجمع.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "تم تغيير قالب رسالة البريد الإلكتروني المجمع.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => '‫تم تحديد قيم غير صالحة.‬', // PFW
    'ui__mass-email__done' => "اكتملت العملية بنجاح.", // PFW
    'ui__mass-mail__done' => "اكتملت العملية بنجاح.", // PFU
    'ui__mass-mail/delete__done' => 'تمت إزالة قالب الرسالة 1%.', // PFU
    'ui__mass-mail/delete_multi__done' => 'تمت إزالة قوالب الرسالة.', // PFU
    'ui__mass-mail/properties__done' => 'تم تغيير القالب 1%.', // PFU
    'ui__mass-mail/properties_new__done' => 'تم إنشاء القالب 1%.', // PFU
    'ui__mass-mail/send__done' => 'تم إرسال الرسائل.', // PFU
    'ui__mass-mail/send_new__done' => 'تم إرسال الرسائل.', // PFU
    'ui__mass-mail/send_unknown__done' => 'تم إرسال الرسائل.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'تم إرسال الرسائل.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'تم إنشاء قالب رسالة جديد.', // PFU
    'ui__mass-mail/template/properties__done' => 'تم تغيير قالب الرسالة.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'تم تطبيق إعدادات مراقبة القرص الجديد.', // PFU
    'ui__modules__done' => 'اكتملت العملية بنجاح.',
    'ui__modules__short-title' => 'الامتدادات',
    'ui__modules__title' => 'الامتدادات',
    'ui__reseller/client/chowner_multi__done' => 'تم نقل حسابات المستخدم المحددة إلى مالك آخر.',
    'ui__reseller/client/chowner_multi-select__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/client/traffic_unknown__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/extras-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__reseller/extras-domain_self__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__reseller/ftp-sessions_self__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/limits__done' => "لقد تغيرت القيود على المورد الخاص ببائع التجزئة وسياسات استخدام المورد.",
    'ui__reseller/limits_readonly-self__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/limits_self__done' => 'لقد تغيرت القيود على المورد وسياسات استخدام المورد.',
    'ui__reseller/manage-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__reseller/manage-domain_self__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__reseller/permissions__done' => 'تم تغيير أذونات بائع التجزئة 1%.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/register-domain__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__reseller/register-domain_self__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'تمت إزالة الجداول الزمنية لتسليم التقارير المحددة.',
    'ui__reseller/report/layout/auto/properties__done' => 'تم تحديث الجدول الزمني لتسليم التقرير.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'تمت إضافة الجدول الزمني لتسليم التقرير.',
    'ui__reseller/report/layout/properties__done' => 'تم تغيير مخطط التقرير.',
    'ui__reseller/report/layout/properties_new__done' => 'تم إنشاء مخطط تقرير جديد.',
    'ui__reseller/report/traffic-history__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/report/traffic-history_self__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/report__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/report_self__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/sessions/delete__done' => 'اكتملت العملية بنجاح',
    'ui__reseller/sessions/delete_self__done' => 'اكتملت العملية بنجاح',
    'ui__reseller/sessions__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/sessions_self__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/to-client__done' => 'تم تحويل حساب بائع التجزئة 1% إلى حساب عميل.',
    'ui__reseller/to-client_multi__done' => "تم تحويل حسابات بائع التجزئة المحددة إلى حسابات عميل.",
    'ui__reseller/traffic__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/traffic_self__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/traffic_unknown__done' => 'اكتملت العملية بنجاح.',
    'ui__reseller/logo_self__title' => 'علامة Plesk التجارية',
    'ui__reseller/logo_self__done' => 'تم تطبيق إعدادات علامة Plesk الخاصة بك.',
    'ui__server/aspdotnet__done' => 'تم تغيير إعدادات ASP.NET على مستوى الخادم.', // PFW
    'ui__server/certificate/default_multi__done' => 'تم إعداد شهادة SSL/TLS المحددة لاستخدامها لتأمين الاتصالات بمواقع الويب التي تمت استضافتها حديثًا.',
    'ui__server/certificate/delete_multi__done' => 'تمت إزالة شهادات SSL/TLS المحددة.',
    'ui__server/certificate/download__done' => 'تم تنزيل شهادة SSL/TLS.',
    'ui__server/certificate/properties__done' => 'تم تحديث خصائص شهادة SSL/TLS.',
    'ui__server/certificate/properties_new__done' => 'تم إنشاء شهادة SSL/TLS %1.',
    'ui__server/certificate/setup_multi__done' => 'تم إعداد شهادة SSL/TLS المحددة لاستخدامها لتأمين الاتصالات لـ Plesk.',
    'ui__server/certificate__done' => 'اكتملت العملية بنجاح.',
    'ui__server/components__done' => 'اكتملت العملية بنجاح.',
    'ui__server/cp-certificate-download__done' => "تم تنزيل شهادة SSL/TLS لـ Plesk.",
    'ui__server/crontab/properties__done' => 'تم تغيير المهام المجدولة لـ 1%.',
    'ui__server/crontab/task/delete__done' => 'تمت إزالة المهمة.',
    'ui__server/crontab/task/delete_multi__done' => 'تمت إزالة المهام.',
    'ui__server/crontab/task/properties__done' => 'تم تحديث المهام المجدولة.',
    'ui__server/crontab/task/properties_new__done' => 'تمت جدولة المهمة الجديدة.',
    'ui__server/crontab/task/toggle_disable__done' => 'تم تعطيل المهمة المجدولة 1%.',
    'ui__server/crontab/task/toggle_enable__done' => 'تم تمكين المهمة المجدولة 1%.',
    'ui__server/crontab__done' => 'اكتملت العملية بنجاح.',
    'ui__server/dns__done' => 'اكتملت العملية بنجاح.',
    'ui__server/ftp-settings__done' => "تم تغيير إعدادات FTP بنجاح.",
    'ui__server/ip-address/client/delete__done' => "تمت إزالة عنوان IP من تجمع IP للمستخدم.",
    'ui__server/ip-address/client/delete_multi__done' => "تمت إزالة عنوان IP من تجمعات IP للمستخدمين.",
    'ui__server/ip-address/client/properties_new__done' => 'تم تعيين عنوان IP إلى مستخدمين.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'تم تعيين عنوان IP وهو 1% الذي تم تعيينه إلى العملاء المحددين.',
    'ui__server/ip-addresses__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail/statistics/spam/recipients__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail/statistics/spam/summary__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail/statistics/spam__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail/statistics/virus/recipients__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail/statistics/virus/summary__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail/statistics/virus/viruses__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail/statistics/virus__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail/statistics__done' => "اكتملت العملية بنجاح.",
    'ui__server/mail__done' => 'تم تغيير إعدادات خادم البريد.',
    'ui__server/maillists__done' => 'اكتملت العملية بنجاح.',
    'ui__server/mpc-certificates__done' => 'تم فتح صفحة المتجر عبر الإنترنت الذي يسرد قائمة بشهادات SSL/TLS المتوفرة.',
    'ui__server/odbc__done' => 'تم تغيير إعدادات ODBC على مستوى الخادم.', // PFW
    'ui__server/pmm__done' => 'اكتملت العملية بنجاح.',
    'ui__server/preferences__done' => "لقد تغيرت إعدادات الخادم.",
    'ui__server/register__done' => 'تم فتح صفحة الموقع MyPlesk.com.',
    'ui__server/resources__done' => 'اكتملت العملية بنجاح.',
    'ui__server/services__done' => 'اكتملت العملية بنجاح.',
    'ui__server/sitebuilder__done' => 'اكتملت العملية بنجاح.',
    'ui__server/skeleton__done' => 'اكتملت العملية بنجاح.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'تمت إزالة العنوان 1% من القائمة السوداء للخادم.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'تمت إزالة العناوين من القائمة السوداء للخادم.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'تمت إضافة العناوين إلى القائمة السوداء.',
    'ui__server/spam-filter/black-list/address__done' => 'تمت إضافة العناوين إلى القائمة السوداء.',
    'ui__server/spam-filter/black-list__done' => 'اكتملت العملية بنجاح.', // PFU
    'ui__server/spam-filter/properties__done' => 'تم تغيير إعدادات تصفية البريد العشوائي.',
    'ui__server/spam-filter/toggle_disable__done' => 'تم تعطيل تصفية البريد العشوائي على مستوى الخادم.',
    'ui__server/spam-filter/toggle_enable__done' => 'تم تمكين تصفية البريد العشوائي على مستوى الخادم.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'تمت إزالة العنوان 1% من القائمة البيضاء للخادم.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'تمت إزالة العناوين من القائمة البيضاء للخادم.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'تمت إضافة العناوين إلى القائمة البيضاء.',
    'ui__server/spam-filter/white-list/address__done' => 'تمت إضافة العناوين إلى القائمة البيضاء.',
    'ui__server/spam-filter/white-list__done' => 'اكتملت العملية بنجاح.', // PFU
    'ui__server/spam-filter__done' => 'اكتملت العملية بنجاح.',
    'ui__server/statistics__done' => 'اكتملت العملية بنجاح.',
    'ui__server/time__done' => "تم تغيير وقت الخادم وتاريخه.",
    'ui__server__done' => "اكتملت العملية بنجاح.",
    'ui__sessions/properties__done' => 'اكتملت العملية بنجاح.',
    'ui__sessions__done' => 'اكتملت العملية بنجاح.',
    'ui__sessions/delete__done' => 'تم حذف جلسات العمل المحددة.',
    'ui__start-page__done' => 'اكتملت العملية بنجاح.',
    'ui__support__done' => 'تم فتح طلب مساعدة في نافذة أو علامة تبويب جديدة في المستعرض.',
    'ui__ts-sessions__done' => 'اكتملت العملية بنجاح.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'لا توجد ملفات لتحميلها.',
    'login_up__access_denied_no_permission' => "تم رفض الوصول. ليس لديك الإذن لتسجيل الدخول.",
    'mail__unable_remove_pattern' => "تتعذر إزالة العنوان من القائمة السوداء للخادم: 1%", // PFW
    'mail__incorrect_network_format' => 'تهيئة الشبكة غير صحيحة: 1%', // PFW
    'initconf__unable_change_passwd' => "يتعذر تغيير كلمة مرور المسؤول: %1",
    'initconf__unable_get_passwd' => 'يتعذر الحصول على كلمة المرور الحالية للمسؤول: تم فشل %1: %2',
    'initconf__invalid_hostname' => 'خطأ في اسم المضيف "%1"',
    'initconf__unable_reconfig' => 'يتعذر تكوين منصة Plesk: فشل إعادة التكوين: %1',
    'initconf__unable_update_admin' => 'يتعذر تحديث معلومات جهة اتصال المسؤول: %1',
    '__refresh' => 'تحديث',
    '__dalias_not_exist' => 'الاسم المستعار للمجال غير موجود.',
    '__bug146523_explanation' => 'لقد سمحت الإصدارات السابقة من Plesk باستخدام 16 حرفًا لأسماء مستخدمي FTP. يحدد هذا الإصدار من Plesk الحد الأقصى لعدد الأحرف المسموح بها في أسماء مستخدمي FTP وهي 15 حرفًا. لحل هذه المشكلة، قم بتقليل طول اسم مستخدم FTP إلى 15 حرفًا بالنسبة إلى أسماء مستخدمي FTP المتأثرة، ثم قم بتغيير حرف واحد على الأقل في أسماء مستخدمي FTP المتأثرين لتجنب مشكلات تضارب اسم المستخدم. نعتذر عن أي مضايقة تحدث بسبب هذا التغيير.',
    'domain__cannot_change_webmail' => 'يتعذر تغيير بريد الويب للمجال: 1%',
    'sb_publish_disable_warning' => 'إذا أوقفت تشغيل إنشاء موقع الويب باستخدام Presence Builder، فإن موقع الويب الذي تم إنشاؤه مسبقًا في Presence Builder ستتم إزالته وستُفقد جميع بياناته. انقر فوق "موافق" إذا أردت المتابعة.',
    '__sbnet_client_use_sbnet' => "إنشاء حساب مستخدم مقابل في Presence Builder",
    'mail_resp_activate' => 'تنشيط الرد التلقائي',
    'limitsManger__limit_available_error' => 'يتعذر تحديد الكم الضروري من الموارد ("%%limitName%%"): يتوفر %%available%% فقط لحسابك.',
    'limitsManger__limit_reserved_error' => 'يتعذر تخصيص موارد أقل ("%%limitName%%") من المستخدمة بالفعل.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'تتعذر إعادة تسمية المجال: يوجد دليل ظاهري بالاسم المحدد بالفعل.',
    'domain_unable_to_rename' => 'تتعذر إعادة تسمية المجال.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'عام',
    'spamfilter__spamassassin_status_legend' => 'تصفية البريد العشوائي لـ SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'إعدادات SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "تشغيل تصفية البريد العشوائي لـ SpamAssassin على مستوى الخادم",
    'spamfilter__spamassassin_user_status_legend' => 'تشغيل تصفية البريد العشوائي لـ SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'تشغيل الحماية من البريد العشوائي للقائمة الرمادية على مستوى الخادم',
    'spamfilter__personal_settings_not_allowed' => 'غير مسموح باستخدام إعدادات تصفية البريد العشوائي الفردي بسبب سياسة النظام.',
    'spamfilter__required_score' => 'عدد النقاط التي يجب أن تتسلمها الرسالة لكي يتم اعتبارها بريدًا عشوائيًا',
    'spamfilter__rewrite_header_subject' => 'تُعد إضافة النص التالي إلى بداية الموضوع لكل رسالة بمثابة بريد عشوائي',
    'spamfilter__use_mailuser_prefs' => 'تطبيق الإعدادات الفردية على تصفية البريد العشوائي',
    'spamfilter_addresses__text_hint' => 'عناوين متعددة منفصلة تشمل سطور جديدة، أو مسافة فارغة، أو علامة تبويب، أو فاصلة أو فاصلة منقوطة. يجب توفر أحرف غير تابعة لمجموعة أحرف ASCII على يسار العلامة @. يمكن أن يتضمن العنوان أحرف البدل "*" و"؟" (مثال: *@domain.com، user?@*.com). يجب ألا تشتمل الأجزاء غير التابعة لمجموعة أحرف ASCII من أسماء المجالات، على أحرف البدل.',
    'spamfilter__score_error' => 'يجب أن يكون عدد النقاط سلبيًا، ويجب أن يكون الجزء قبل الرقم العشري أقل من 100، وقد لا يشمل ما يزيد عن رقمين بعد النقطة العشرية.',
    'spamfilter__rewrite_header_error' => 'يمكن أن يتضمن موضوع الرسالة أي أحرف قابلة للطباعة باستثناء علامة الرقم (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'ارتداد',
    'nonexistent_mail__mode_discard' => 'تجاهل',
    'nonexistent_mail__mode_catch_addr' => 'إعادة توجيه إلى عنوان البريد الإلكتروني',
    'nonexistent_mail__mode_catch_ip' => 'إعادة توجيه إلى عنوان IP',
    'nonexistent_mail__bounce_not_supported' => 'وضع الارتداد غير مدعوم',
    'nonexistent_mail__discard_not_supported' => 'وضع التجاهل غير مدعوم',
    'nonexistent_mail__catch_not_supported' => 'إعادة التوجيه إلى عنوان البريد الإلكتروني غير مدعومة',
    'nonexistent_mail__redirect_not_supported' => 'إعادة التوجيه إلى عنوان IP غير مدعومة',
    'nonexistent_mail__ip_used_on_this_host' => 'يتم حل عنوان IP إلى المضيف المحلي',
    'nonexistent_mail_address_should_be_local_domain' => 'نظرًا لتشغيل التحكم في البريد الصادر، فإن عنوان البريد الإلكتروني 1% للمستقبلين غير الموجودين يجب أن ينتمي إلى المجال المحدد. وإذا لم يكن كذلك، فسيتم تطبيق سياسة "الرفض" بدلاً من إعادة التوجيه.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'نظرًا لتشغيل التحكم في البريد الصادر، فإن عنوان البريد الإلكتروني 1% المجدد لإعادة توجيه البريد يجب أن ينتمي إلى المجال المحدد. وإذا لم يكن الأمر كذلك، فلن يتم احتساب الرسائل المرسلة إلى هذا العنوان في التحكم في البريد الصادر.',
    // mail acc extras
    '__antivirus' => "برنامج مكافحة الفيروسات",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'لا توجد حسابات متوفرة للمسؤول الإضافي.', // PFW
    'ui__client/domain/certificate__none-available' => 'لا يمتلك العميل شهادات SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'لا يمتلك العميل نطاقات لها شهادات SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'لا يوجد للنطاق شهادات SSL/TLS.',
    'ui__reseller/client__none-available' => 'لا يوجد بائعو تجزئة مع العملاء.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'يجب تحديد عناوين IP التي تريد إزالتها من تجمع IP.',
    'ui__reseller/client/chowner__empty_selection' => 'سيلزم تحديد حسابات العميل التي تريد تعيينها إلى مالك جديد.',
    'ui__server/ip-address/client/delete__empty_selection' => 'يجب تحديد حسابات بائع التجزئة الذي تريد استدعاء عنوان IP لتجمعات IP الخاصة به.',
    'ui__server/crontab/task/delete__empty_selection' => 'يجب تحديد المهمة التي تريد إلغاءها.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'دعم PHP قيد إيقاف التشغيل بالنسبة إلى الموقع الإلكتروني هذا.',
    'phosting__aspdotnet_not_enabled' => 'تم إيقاف دعم ASP.NET لموقع الويب هذا.',
    'phosting__php_forced_by_site_isolation' => 'يتعذر تغيير إعدادات PHP: الإذن لتجاوز سياسة الأمان على مستوى الخادم غير ممنوح.',
    'phosting__option_forced_by_site_isolation' => 'يتعذر تغيير إعدادات 1%: الإذن لتجاوز سياسة الأمان على مستوى الخادم غير ممنوح.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'تم تعطيل mod_bw لأن Plesk يعمل في وضع VPS المُحسّن.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'تم تعطيل mod_php لأن Plesk يعمل في وضع VPS المُحسّن.',
    'phosting__perl_disabled_by_vps_optimized' => 'تم تعطيل Perl لأن Plesk يعمل في وضع VPS المُحسّن.',
    'phosting__asp_disabled_by_vps_optimized' => 'تم تعطيل ASP لأن Plesk يعمل في وضع VPS المُحسّن.',
    'phosting__python_disabled_by_vps_optimized' => 'تم تعطيل Python لأن Plesk يعمل في وضع VPS المُحسّن.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'تم تعطيل fastcgi لأن Plesk يعمل في وضع VPS المُحسّن.',
    'phosting__php_handler_id_not_registered' => 'غير مسموح بمعالج PHP في إعدادات عزل الموقع. سيتم استخدام معالج PHP الافتراضي.',
    'phosting__php_served_by_nginx_is_not_available' => 'غير مسموح بمعالج PHP (تطبيق FPM الذي تقدمه nginx) في إعدادات عزل الموقع. سيتم استخدام معالج PHP الافتراضي.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'عرض قائمة بعناوين IP',
    'ui__client/ipaddress/properties_readonly__title' => 'عرض قائمة بعناوين IP',
    'ui__client/ipaddress/properties_readonly__description' => 'عرض قائمة بعناوين IP المتوفرة لهذا المستخدم.',
    'ui__server/certificate__short-title' => 'شهادات SSL/TLS',
    'ui__server/certificate__title' => 'شهادات SSL/TLS',
    'ui__server/certificate__description' => 'قم بإدارة وعرض شهادات SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'إزالة أنواع MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'إزالة أنواع MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'إزالة أنواع MIME المحددة.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'إضافة نوع MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'إضافة نوع MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'تسجيل نوع MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'إزالة عناوين IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'حدد عناوين IP التي تريد إزالتها من تجمع IP للعميل 1%',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'إنشاء ملف',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'إنشاء ملف',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'إنشاء ملف.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'إنشاء مجلد',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'إنشاء مجلد',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'إنشاء مجلد.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'تحرير الملف أو المجلد',
    'ui__client/domain/hosting/file-manager/edit__title' => 'تحرير الملف أو المجلد',
    'ui__client/domain/hosting/file-manager/edit__description' => 'تحرير الملف أو المجلد المحدد.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'إعادة تسمية الملف أو المجلد',
    'ui__client/domain/hosting/file-manager/rename__title' => 'إعادة تسمية الملف أو المجلد',
    'ui__client/domain/hosting/file-manager/rename__description' => 'إعادة تسمية الملف أو المجلد المحدد.',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'أذونات التغيير',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'أذونات التغيير',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'تغيير أذونات الوصول إلى ملف أو مجلد معين.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'إزالة الملف أو المجلد',
    'ui__client/domain/hosting/file-manager/remove__title' => 'إزالة الملف أو المجلد',
    'ui__client/domain/hosting/file-manager/remove__description' => 'إزالة هذا الملف أو المجلد.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'إزالة الملف أو المجلد',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'إزالة الملف أو المجلد',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'إزالة هذا الملف أو المجلد.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'نسخ أو نقل ملف أو دليل.',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'نسخ أو نقل ملف أو دليل.',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'نسخ أو نقل الملفات أو الدلائل المحددة.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'عرض الملف',
    'ui__client/domain/hosting/file-manager/view__title' => 'عرض الملف',
    'ui__client/domain/hosting/file-manager/view__description' => 'عرض الملف المحدد.',

    'ui__client/ipaddress__short-title' => 'عنوان IP',
    'ui__client/ipaddress__title' => 'عنوان IP',
    'ui__client/ipaddress__description' => 'عرض المعلومات حول عنوان IP.',
    'ui__server/ip-address__short-title' => 'عنوان IP',
    'ui__server/ip-address__title' => 'عنوان IP',
    'ui__server/ip-address__description' => 'عرض المعلومات حول عنوان IP.',
    'ui__client/domain/hosting/setup__short-title' => 'إعدادات استضافة الويب',
    'ui__client/domain/hosting/setup__title' => 'إعدادات استضافة الويب',
    'ui__client/domain/hosting/setup__description' => 'إعداد إعدادات استضافة الويب لموقع الويب 1%.',
    'ui__reseller/client/chowner_multi__description' => 'اختر مالكًا جديدًا لحسابات العميل المحددة.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'نوع MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'خصائص نوع MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'عرض خصائص نوع MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'مستند الخطأ', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'مستند الخطأ', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'خصائص مستند الخطأ.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'إزالة مخططات التقرير المحددة.',
    'b_resellerreportslist_search' => 'أدخل نمط بحث وانقر للعثور على مخططات التقرير.',
    'b_resellerreportslist_show_all' => 'عرض جميع مخططات التقرير المتوفرة.',

    'l_resellerreportslist_auto' => 'فرز مخططات التقرير حسب أتمتة التسليم.',
    'l_resellerreportslist_clients' => 'فرز مخططات التقرير حسب وجود معلومات حول العملاء.',
    'l_resellerreportslist_domains' => 'فرز مخططات التقرير حسب وجود معلومات حول المجالات.',
    'l_resellerreportslist_general' => 'فرز مخططات التقرير حسب وجود معلومات عامة.',
    'l_resellerreportslist_name' => 'فرز مخططات التقرير حسب اسم التقرير.',
    'l_resellerreportslist_personal_domains' => 'فرز مخططات التقرير حسب وجود معلومات حول المجالات الشخصية.',

    'b_adminreportslist_remove' => 'إزالة مخططات التقرير المحددة.',
    'b_adminreportslist_search' => 'أدخل نمط بحث وانقر للعثور على مخططات التقرير.',
    'b_adminreportslist_show_all' => 'عرض جميع مخططات التقرير المتوفرة.',

    'l_adminreportslist_auto' => 'فرز مخططات التقرير حسب أتمتة التسليم.',
    'l_adminreportslist_clients' => 'فرز مخططات التقرير حسب وجود معلومات حول العملاء.',
    'l_adminreportslist_domains' => 'فرز مخططات التقرير حسب وجود معلومات حول المجالات.',
    'l_adminreportslist_general' => 'فرز مخططات التقرير حسب وجود معلومات عامة.',
    'l_adminreportslist_name' => 'فرز مخططات التقرير حسب اسم التقرير.',
    'l_adminreportslist_personal_clients' => 'فرز مخططات التقرير حسب وجود معلومات حول العملاء التابعين لك.',
    'l_adminreportslist_personal_domains' => 'فرز مخططات التقرير حسب وجود معلومات حول المجالات الخاصة بك.',
    'l_adminreportslist_resellers' => 'فرز مخططات التقرير حسب وجود معلومات حول بائعي التجزئة.',

    'b_clientsonlylist_remove' => 'إزالة حسابات العميل المحدد.',
    'b_clientsonlylist_search' => 'أدخل نمط بحث وانقر للبحث عن حسابات العملاء.',
    'b_clientsonlylist_show_all' => 'عرض كل حسابات العملاء.',
    'l_clientsonlylist_cname' => 'فرز حسابات العميل حسب اسم الشركة.',
    'l_clientsonlylist_date' => 'فرز حسابات العميل حسب تاريخ الإنشاء.',
    'l_clientsonlylist_domains' => 'فرز حسابات العميل حسب عدد المجالات.',
    'l_clientsonlylist_name' => 'فرز حسابات العميل حسب الاسم.',
    'l_clientsonlylist_owner' => 'فرز حسابات العميل حسب المالك.',
    'l_clientsonlylist_type' => 'فرز حسابات العميل حسب النوع.',

    'b_get_password_cancel' => 'العودة إلى الشاشة السابقة دون إرسال بريد إلكتروني.',
    'b_get_password_send' => 'انقر فوق "موافق" لإرسال رسالة لاستعادة كلمة المرور إلى عنوان البريد الإلكتروني المسجل في النظام.',



    'b_personaltrafficlist_search' => 'أدخل نمط بحث وانقر للعثور على المجالات.',
    'b_personaltrafficlist_show_all' => 'إظهار جميع المجالات.',

    'b_back' => 'العودة إلى الصفحة السابقة.',
    'b_next' => 'الانتقال إلى الصفحة التالية.',

    'b_dnsnstemplatelist_remove' => 'حذف خوادم الأسماء المحددة.',
    'b_dnsnstemplatelist_search' => 'أدخل نمط بحث وانقر للبحث عن خوادم أسماء.',
    'b_dnsnstemplatelist_show_all' => 'عرض كل خوادم الأسماء.',

    'l_dnsnstemplatelist_ns' => 'فرز سجلات قالب DNS حسب خادم الاسم.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'إنشاء روابط آمنة للملفات والمجلدات',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'تمكين الملفات العامة',
    'cu__serverfilesharing_fsPublicFolder' => 'مجلد لتخزين الملفات المحمية بكلمة مرور',
    'cu__serverfilesharing_fsPublicUrl' => 'عنوان URL لوصول الزائر إلى الملفات العامة',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'تمكين الحماية بكلمة مرور للملفات العامة',
    'cu__serverfilesharing_fsPartnerFolder' => 'مجلد لتخزين الملفات المحمية بكلمة مرور',
    'cu__serverfilesharing_fsPartnersLogin' => 'اسم المستخدم للوصول إلى الملف',
    'cu__serverfilesharing_fsPartnersPassword' => 'كلمة المرور للوصول إلى الملف',
    'cu__serverfilesharing_fsDomain' => 'عنوان URL الجذر لمجلد الويب اسم المجال',
    'cu__serverfilesharing_fsPrefix' => 'عنوان URL الجذر لمجلد الويب بادئة',
    'cu__serverfilesharing_commandUpdate' => 'تحديث إعدادات مشاركة الملفات',
    'cu__serverfilesharing_commandInfo' => 'عرض إعدادات مشاركة الملفات الحالية',
    'subscription_rename_is_forbidden' => 'يُحظر تغيير اسم الاشتراكات بسبب السياسة الخاصة بالخادم.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'إدارة المهام المجدولة على الخادم',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'حدد مستخدم النظام الذي تريد إدارة مهامه المجدولة.',

    'ui__server/crontab/task__short-title' => '1%',
    'ui__server/crontab/task__title' => 'المهمة المجدولة 1%',
    'ui__server/crontab/task__description' => 'عرض خصائص المهمة المجدولة 1%.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'مستخدمو النظام',
    'ui__server/crontab_unknown__title' => 'مستخدمو النظام',
    'ui__server/crontab_unknown__description' => 'مستخدمو النظام الذين يمكن أن يصبحوا مالكين للمهام المجدولة.',


    'ui__server/crontab__none-available' => 'لا يوجد لديك حسابات لمستخدم النظام.',
    'ui__server/crontab_readonly-unknown__description' => 'عرض المهام المجدولة.',
    'ui__server/crontab_readonly-unknown__short-title' => 'المهام المجدولة',
    'ui__server/crontab_readonly-unknown__title' => 'عرض المهام المجدولة',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'عرض المهام المجدولة.',
    'ui__server/crontab_readonly__description' => 'عرض المهام المجدولة لـ 1%.',
    'ui__server/crontab_readonly__short-title' => 'المهمة المجدولة لـ 1%',
    'ui__server/crontab_readonly__title' => 'عرض المهام المجدولة لـ 1%',
    'ui__server/crontab_unknown__wizard-title' => 'إدارة المهام المجدولة.',

    'ui__server/crontab/properties__description' => 'تحرير المهام المجدولة لـ 1%.',

    'ui__server/crontab/properties__short-title' => 'الإعدادات',
    'ui__server/crontab/properties__title' => 'تحرير المهام المجدولة لـ 1%',
    'ui__server/crontab/properties_readonly-unknown__description' => 'عرض المهام المجدولة.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'الإعدادات',
    'ui__server/crontab/properties_readonly-unknown__title' => 'عرض المهام المجدولة',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'عرض المهام المجدولة.',
    'ui__server/crontab/properties_readonly__description' => 'عرض المهام المجدولة لـ 1%.',
    'ui__server/crontab/properties_readonly__short-title' => 'الإعدادات',
    'ui__server/crontab/properties_readonly__title' => 'عرض المهام المجدولة لـ 1%',
    'ui__server/crontab/properties_unknown__description' => 'تحرير المهام المجدولة.',
    'ui__server/crontab/properties_unknown__short-title' => 'الخصائص',
    'ui__server/crontab/properties_unknown__title' => 'تحرير المهام المجدولة',
    'ui__server/crontab/properties_unknown__wizard-title' => 'تحرير المهام المجدولة.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'حدد مستخدم النظام الذي تريد رؤية مهامه.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'حدد مستخدم النظام الذي تريد تغيير مهامه.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'انقر فوق "Finish" (إنهاء) لتطبيق التغييرات والخروج من المعالج.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'انقر فوق "Finish" للخروج من المعالج.',

    'ui__server/crontab/task__none-available' => 'لا يوجد لديك مهام مجدولة.',
    'ui__server/crontab/task__none-available__2' => 'لا يوجد لدى مستخدم النظام 1% أي مهام مجدولة.',
    'ui__server/crontab/task_readonly-unknown__description' => 'المهام المجدولة.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'المهام',
    'ui__server/crontab/task_readonly-unknown__title' => 'المهام المجدولة',

    'ui__server/crontab/task/delete__description' => 'إزالة المهمة المجدولة 1%',

    'ui__server/crontab/task/delete__short-title' => 'إزالة',
    'ui__server/crontab/task/delete__title' => 'إزالة المهمة المجدولة 1%',
    'ui__server/crontab/task/delete_multi__description' => 'إزالة المهام المجدولة.',

    'ui__server/crontab/task/delete_multi__short-title' => 'إزالة',
    'ui__server/crontab/task/delete_multi__title' => 'إزالة المهام المجدولة',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'إزالة المهام المجدولة.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'حدد مستخدم النظام الذي تريد إزالة مهامه.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'حدد المهام التي تريد إزالتها.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'قم بالتأكيد على إزالة المهمة عن طريق تحديد خانة الاختيار والنقر فوق "Finish" (إنهاء) لإكمال المعالج.',
    'ui__server/crontab/task/delete_unknown__description' => 'إزالة المهمة المجدولة.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'إزالة',
    'ui__server/crontab/task/delete_unknown__title' => 'إزالة المهمة المجدولة',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'إزالة المهمة المجدولة.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'حدد مستخدم النظام الذي تريد إزالة مهمته.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'حدد المهمة التي تريد إزالتها.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'قم بالتأكيد على إزالة المهمة عن طريق تحديد خانة الاختيار والنقر فوق "Finish" (إنهاء) لإكمال المعالج.',

    'ui__server/crontab/task/properties__description' => 'تحرير المهام المجدولة.',

    'ui__server/crontab/task/properties__short-title' => 'تحرير المهمة 1%',
    'ui__server/crontab/task/properties__title' => 'تحرير المهام المجدولة',
    'ui__server/crontab/task/properties_new__description' => 'إنشاء المهام المجدولة لـ 1%.',

    'ui__server/crontab/task/properties_new__short-title' => 'إضافة مهمة',
    'ui__server/crontab/task/properties_new__title' => 'إنشاء المهام المجدولة لـ 1%',
    'ui__server/crontab/task/properties_new__wizard-title' => 'إنشاء مهمة مجدولة.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'حدد مستخدم النظام الذي تريد إنشاء المهمة المجدولة له.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'انقر فوق "Finish" (إنهاء) لتطبيق التغييرات والخروج من المعالج.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'عرض المهام المجدولة.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'الخصائص',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'عرض المهام المجدولة',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'عرض المهام المجدولة.',
    'ui__server/crontab/task/properties_readonly__description' => 'عرض المهام المجدولة.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'عرض المهمة 1%',
    'ui__server/crontab/task/properties_readonly__title' => 'عرض المهام المجدولة',
    'ui__server/crontab/task/properties_unknown-new__description' => 'إنشاء المهام المجدولة.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'إضافة مهمة',
    'ui__server/crontab/task/properties_unknown-new__title' => 'إنشاء المهام المجدولة',
    'ui__server/crontab/task/properties_unknown__description' => 'تحرير المهام المجدولة.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'الخصائص',
    'ui__server/crontab/task/properties_unknown__title' => 'تحرير المهام المجدولة',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'تحرير المهام المجدولة.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'حدد مستخدم النظام الذي تريد رؤية مهامه.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'حدد مستخدم النظام الذي تريد تغيير مهامه.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'حدد المهمة المجدولة.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'حدد المهمة المجدولة التي تريد تغييرها.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'انقر فوق "Finish" (إنهاء) لتطبيق التغييرات والخروج من المعالج.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'انقر فوق "Finish" للخروج من المعالج.',

    'ui__server/crontab/task/toggle_disable__description' => 'تعطيل المهمة المجدولة 1%.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'تعطيل',
    'ui__server/crontab/task/toggle_disable__title' => 'تعطيل المهمة المجدولة 1%',
    'ui__server/crontab/task/toggle_enable__description' => 'تمكين المهمة المجدولة 1%.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'تمكين',
    'ui__server/crontab/task/toggle_enable__title' => 'تمكين المهمة المجدولة 1%',
    'ui__server/crontab/task/toggle_unknown__description' => 'تمكين المهام المجدولة أو تعطيلها.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'تمكين أو تعطيل',
    'ui__server/crontab/task/toggle_unknown__title' => 'تمكين المهام المجدولة أو تعطيلها',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'تمكين المهام المجدولة أو تعطيلها',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'حدد حساب مستخدم النظام الذي تريد تمكين مهامه أو تعطيلها.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'حدد المهمة التي تريد تمكينها أو تعطيلها.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'حسابات العميل', // not used on HP?
    'ui__client_unknown__title' => 'حسابات العميل', // not used on HP?
    'ui__client_unknown__description' => 'إدارة حسابات العملاء.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'تعليق المجال', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'تعليق المجال', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'تعليق المجال.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'تنشيط المجال', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'تنشيط المجال', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'تنشيط مجال.', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => 'تعيين مالك جديد لحسابات العميل',
    'ui__client/chowner_multi-select__short-title' => 'تعيين مالك جديد',
    'ui__client/chowner_multi-select__description' => 'تعيين مالك جديد لحسابات العميل المحددة.',


    //Additional FTP Accounts
    'directory_browser__select_folder' => 'تحديد مجلد',
    'ftp__management_domain' => "حسابات FTP ضِمن المجال 1%", // for Additional FTP Accounts
    '__ftp_users_list' => "حسابات FTP",
    'ftp__user_name' => "اسم حساب FTP",
    'ftp__user_home' => "دليل الصفحة الرئيسية",
    'ftp__invalid_path' => "تم تحديد مسار غير صالح",
    'ftp__physical_path_not_exist' => "المسار الفعلي غير موجود",
    'i_ftp_ses_sub_user' => 'جلسة عمل حساب FTP.',
    '__new_passwd' => "كلمة مرور 1% الجديدة",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'يتعذر تكوين خادم الويب على المضيف <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "يتعذر إنشاء ملف تكوين خادم الويب على المضيف <%%host%%> بسبب الأخطاء التالية: %%error%% يُرجى حل الأخطاء في قوالب تكوين خادم الويب وإنشاء الملف مرة أخرى.",

    'apacheConfigurationMessageAdminTitle' => 'فشل تكوين خادم الويب',
    'apacheConfigurationMessageClientTitle' => 'تحذير',

    'apacheConfigurationFailedAdminHomeMessage' => 'لم يتم إنشاء ملف تكوين جديد بسبب أخطاء في قوالب التكوين. The detailed error message was sent to your email, so please check the email, fix the errors, and click %1 to retry generating configuration.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'هنا', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'لم يتم إنشاء تكوين جديد للمجال 1% بسبب أخطاء في قوالب التكوين. تم إرسال رسالة مفصلة بالخطأ إلى بريدك الإلكتروني، لذا راجعه وأصلح الأخطاء، وانقر على 2% لإعادة محاولة إنشاء التكوين.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'هنا', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'قد لا يكون تكوين خادم الويب للمجال 1% متسقًا. يُرجى الاتصال بمسؤول الخادم لحل المشكلة.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'لم يتم إنشاء تكوين جديد لبعض المجالات بسبب أخطاء في قوالب التكوين. The detailed error message was sent to your email, so please check the email, fix the errors, and click %1 to retry generating configuration.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'هنا', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'قد لا يكون تكوين خادم الويب لبعض المجالات الخاصة بك متسقًا. يُرجى الاتصال بمسؤول الخادم لحل المشكلة.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "مستندات خطأ مخصصة",
    'dom_pref__webusers_script' => "السماح للمستخدمين باستخدام البرامج النصية",
    '__seoRedirect' => 'تكوين المجال الافتراضي بصفة',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'بلا',

    '__sites' => 'المجالات',
    'domain_plan__perm_denied_manage_phosting' => 'ليس لديك الإذن لإدارة إعدادات الاستضافة.',
    '__owned_by_client' => 'مملوك للعميل',
    'ui__client/permissions_readonly__description' => "عرض الإجراءات التي يمكن أن يجريها العميل 1% في Plesk.",
    'client_chown_subscription_will_be_anonymous' => 'سيلغي العملاء اشتراكهم في خطط الخدمة الحالية.',
    'backup__restore__object_client_template' => 'قالب العميل',
    '__template_name' => 'اسم خطة الخدمة',
    'template__not_exists' => 'لا توجد خطة خدمة كهذه',
    'template__exists' => 'توجد خطة بالاسم 1% بالفعل.',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => 'يمتلك العميل مجالات مشتركة في خطط خدمة %1\'\\s.',
    'clientOwnerChanger__ip_not_in_pool' => 'عنوان البريد الحالي ليس في التجمع الخاص ببائع التجزئة.',

    //// Change owner of subscription
    'chown__select_title' => "اختر مشتركًا جديدًا",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'اختر مالكًا جديدًا للاشتراكات المحددة وانقر فوق "Next" (التالي).',
    'domains__client_info' => "اشتراكات 1%، اشتراكات 2% النشطة، 3% من مساحة القرص المستخدمة، 4% من حركة مرور البيانات المستخدمة",
    '__possible_owners' => 'المالكون المحتملون الجدد للاشتراكات',

    'clients_list__filter_owner__filter_title' => 'الموفر',
    'clients_list__filter_owner_any' => 'جميع المستخدمين',
    'clients_list__filter_owner_my' => 'المشتركون فقط',
    'clients_list__filter_owner_name__filter_title' => 'اسم موفر الخدمة',

    '__owner' => "الموفر",
    'l_clientslist_owner' => 'فرز حسابات المستخدم حسب موفر الخدمة.',
    'l_clientslist_date' => 'فرز حسابات المستخدم حسب تاريخ الإنشاء.',
    'l_clientslist_name' => 'فرز حسابات المستخدم حسب الاسم.',
    'l_clientslist_domains' => 'فرز حسابات المستخدم حسب المجالات.',
    'l_clientslist_cname' => 'فرز حسابات المستخدم حسب اسم الشركة.',

    'ui__client/domain/chowner_multi__wizard-title' => 'إعادة تعيين الاشتراكات المحددة',
    'chown__check_title' => 'تغيير المشترك',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "انقر فوق \"Finish\" لإكمال إعادة التعيين. عند الانتهاء من ذلك، سيتم تعيين الاشتراكات المحددة لمالك جديد، وسيتم تغيير موفر الخدمة إلى موفر الخدمة للمالك الجديد، وسيتم إلغاء الارتباط بخطط الخدمة وستصبح 'مخصصة'.",

    'chown__error_check' => 'تمت مصادفة بعض المشكلات عند محاولة تعيين بعض الاشتراكات إلى مستخدم جديد.',
    'domain_chown_subscription_will_be_anonymous' => "لن تكون الاشتراكات مرتبطة بخطط الخدمة الحالية وستصبح '\\Custom'\\.",
    'chown__error_domains_exclude' => "تمت مصادفة بعض المشكلات عند محاولة تعيين بعض الاشتراكات إلى مستخدم جديد. تم تمييز هذه الاشتراكات.",
    'chown__ip_not_in_client_pool' => "لم تتم إضافة عنوان IP المرتبط بهذا الاشتراك إلى تجمع IP للمالك الجديد.",
    'chown__already_owned_by_client' => "ينتمي هذا الاشتراك بالفعل إلى هذا المستخدم.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '1%/',
    'ui__client/domain/hosting/protected-directories/path__title' => 'الدليل المحمي 1%/',
    'ui__client/domain/hosting/protected-directories/path__description' => 'إدارة الدليل المحمي 1%/',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'إنشاء دليل محمي ضمن الموقع 1%',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'إضافة دليل محمي',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'إنشاء دليل محمي.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'تم إنشاء الدليل المحمي 1%/ بنجاح.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'إعدادات الدليل المحمي 1%/',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'إعدادات الدليل',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'تغيير الموقع، والاسم وعنوان المنطقة الخاصة بالدليل المحمي.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'تم تغيير إعدادات الدليل المحمي.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'تأكيد الإزالة',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'الحماية من الإزالة',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'إزالة الحماية من الأدلة المحددة.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'حدد أحد الدلائل التي تريد إزالة الحماية منها.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'ستؤدي العملية إلى إزالة الحماية من الدلائل. ستصبح الدلائل قابلة للوصول مجانًا بالنسبة إلى مستخدمي الإنترنت.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'تمت إزالة الحماية بنجاح من الدلائل المحددة.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'إضافة مستخدم',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'إضافة مستخدم',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'إعداد حساب مستخدم من أجل الوصول إلى الدليل المحمي 1%',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'تم إنشاء حساب المستخدم من أجل الوصول إلى الدليل المحمي.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "تم حفظ بيانات اعتماد المستخدم.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'إزالة مستخدمي الدليل المحمي',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'حدد المستخدمين الذين تريد إزالتهم.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'إزالة',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'إزالة مستخدمي الدليل.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'تمت إزالة المستخدمين التالين للدليل المحمي:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'تمت إزالة حسابات المستخدم المحددة.',

    '__redirect_hint' => 'ستتم إعادة توجيهك إلى العنوان الجديد خلال 15 ثانية... إذا لم يتم توجيهك تلقائيًا إلى الموقع الجديد، فيُرجى تمكين javascript أو النقر فوق الارتباط التشعبي %%link%%.',

    'backup__restore__object_maillist' => 'قائمة المراسلة',
    'backup__restore__object_site' => 'الموقع',
    'backup__restore__object_user' => 'المستخدم',
    'backup__restore__object_role' => 'الدور',

    'limit__name_max_site' => 'المواقع',

    'iis_pool__unable_rename_client' => "تعذر تسمية مجموعة تطبيقات IIS: 1%.",

    'anonftp__is_not_supported_for_addon_domains' => 'يتم اعتماد خدمة باسم مجهول فقط للمجال الرئيسي للاشتراك.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'خدمة FTP المجهولة مدعومة فقط للمجال الرئيسي للاشتراك.',

    '__gb' => 'غيغابايت',
    '__tb' => 'تيرا بايت',
    '__gb_month' => 'غيغابايت/الشهر',
    '__tb_month' => 'تيرا بايت/الشهر',

    '__customers' => 'العملاء',
    '__customer_name' => 'اسم العميل',
    '__customer_total' => 'إجمالي العملاء',
    '__site' => 'الموقع',
    '__def_site' => 'موقع افتراضي',
    '__subscription_name' => 'اسم الاشتراك',
    '__subscription_name_powerUser' => 'اسم الاشتراك',

    'limit__units_max_traffic_suffix' => '/شهر',

    'dom_pref__discard' => "رفض",

    'mail__pattern_already_exists' => 'النمط "1%" موجود بالفعل في القائمة السوداء.',

    '__not_supported' => 'غير مدعوم',

    'plesk_key__sitebuilder' => 'المواقع المنشورة باستخدام Presence Builder',
    'limit__name_max_site_builder' => 'المواقع المنشورة باستخدام Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'الدعم لمواقع اللغات المتعددة في Presence Builder',

    'ui__client/domain/traffic-hosting__title' => '‫إحصائيات نقل البيانات للمجال 1%‬',
    'ui__client/domain/traffic-hosting__title_powerUser' => '‫إحصائيات نقل البيانات للمجال 1%‬',
    'ui__client/domain/traffic-hosting#list__title' => "نقل البيانات بواسطة الخدمات",

    'login_up__access_denied_no_subscriptions' => "تم رفض الوصول. لا توجد اشتراكات متوفرة لهذا الحساب.",

    'interval__day' => '1% يوم (أيام)',
    'interval__hour' => '1% ساعة (ساعات)',
    'interval__minute' => '1% دقيقة (دقائق)',
    'interval__second' => '1% ثانية (ثوانٍ)',

    ///License options
    'plesk_key__backward_incompatibility' => '‫أنت تحاول استخدام مفتاح ترخيص تم إنشاؤه لإصدار آخر من Plesk.‬ ‫اتصل بممثلي مبيعات Plesk للحصول على مفتاح ترخيص صحيح.‬',
    //Standalone or virtualization
    'virtualization_any' => "الخادم المادي على أي حل للظاهرية",
    'virtualization_pvc' => "حاويات Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "خادم Virtuozzo",
    'plesk_key__virtualization' => "صالح للبيئات التالية:",
    'plesk_key__virtualization_only_key' => 'يُقصد من مفتاح الترخيص الاستخدام فقط مع Plesk الذي يتم تشغيله داخل بيئة 1% الظاهرية.',
    'plesk_key__virtualizations_only_key' => 'يُقصد من مفتاح الترخيص الاستخدام فقط مع Plesk الذي يتم تشغيله داخل البيئات الظاهرية التالية: 1%.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'لا يُسمح باستخدام حزم لغات مخصصة.',
    'plesk_key__allowed-locales' => 'اللغات المتوفرة',
    'plesk_key__allowed-locales-any' => 'أي لغة',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'يوجد دليل cgi-bin في',
    '_cgi_bin_mode_webspace' => 'الدليل الجذر للاشتراك',
    '_cgi_bin_mode_www_root' => 'جذر المستند لهذا المجال',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'إضافة ODBC DSN',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'إضافة مصدر بيانات ODBC.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'إزالة',
    'ui__server/odbc/dsn/delete_multi__title' => 'تأكيد الإزالة',
    'ui__server/odbc/dsn/delete_multi__description' => 'إزالة مصادر بيانات ODBC DSN المحددة.',
    'ui__server/odbc/dsn/delete#legend__description' => 'ستتم إزالة اتصالات ODBC DSN التالية:',
    'ui__server/odbc/dsn/delete__empty_selection' => 'لم يتم تحديد أي من اتصالات ODBC DSN.',
    'ui__server/odbc/dsn/delete_multi__done' => 'تمت إزالة مصادر البيانات المحددة.',
    'ui__server/odbc/dsn__title' => 'اتصال ODBC DSN %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'إضافة ODBC DSN',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'إضافة مصدر بيانات ODBC.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'إزالة',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'تأكيد الإزالة',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'إزالة مصادر بيانات ODBC DSN المحددة.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'ستتم إزالة اتصالات ODBC DSN التالية:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'لم يتم تحديد أي من اتصالات ODBC DSN.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'تمت إزالة مصادر البيانات المحددة.',
    'ui__client/domain/odbc/dsn__title' => 'اتصال ODBC DSN %1',


    /// Custom buttons
    'custom_button__sort_key' => 'الأولوية',
    'custom_button__place' => 'الموقع',
    'custom_button__place_navigation' => 'الوصول العام',
    'custom_button__place_admin' => 'الصفحة الرئيسية للمسؤول',
    'custom_button__place_admin-settings' => 'صفحة الأدوات والإعدادات الخاصة بالمسؤول',
    'custom_button__place_reseller' => "الصفحة الرئيسية لبائع التجزئة",
    'custom_button__place_reseller-settings' => 'صفحة الأدوات والأدوات المساعدة لبائع التجزئة',
    'custom_button__place_client' => 'الصفحة الرئيسية للعميل',
    'custom_button__place_domain' => "صفحة مواقع الويب والمجالات الخاصة بالاشتراك",
    'custom_button__place_domain_powerUser' => "صفحة اشتراك &مجالات المواقع الإلكترونية",
    'custom_button__place_domain-properties' => 'أدوات موقع الويب',
    'custom_button__private' => 'عرض لي فقط',
    'custom_button__image' => 'صورة الخلفية',
    'custom_button__conhelp' => "نص تلميح الأداة",
    'custom_button__edit' => "إعدادات رابط إلى خدمة إضافية",
    'custom_button__include_client_cname' => "تضمين اسم شركة العميل",
    'custom_button__include_client_email' => "تضمين البريد الإلكتروني للعميل",
    'custom_button__include_client_id' => "تضمين معرف العميل",
    'custom_button__include_client_pname' => "تضمين اسم جهة اتصال العميل",
    'custom_button__include_domain_id' => "تضمين معرف الاشتراك، ومعرف المجال ومعرف الاسم المستعار للمجال",
    'custom_button__include_domain_id_powerUser' => "تضمين مُعرِّف الاشتراك ومُعرِّف المجال ومعرِّف الاسم المستعار للمجال",

    'custom_button__include_domain_name' => "تضمين اسم المجال الأساسي",
    'custom_button__include_ftp_user' => "تضمين اسم مستخدم FTP",
    'custom_button__include_ftp_pass' => "تضمين كلمة مرور FTP",
    'custom_button__internal_open' => "فتح عنوان URL في Plesk",
    'custom_button__text' => "تسمية الزر",
    'custom_button__url' => "عنوان URL",

    'custom_button__not_image' => 'الملف ليس ملف صورة.',
    'custom_button__big_image' => 'يجب ألا يتعدى حجم الملف مساحة 100 كيلوبايت.',
    'custom_button__failed_copy_image' => 'يتعذر نسخ الملف: 1%',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'لا يمكن استعادة النسخ الاحتياطي لمن ليس مستخدمًا مالكًا في طريقة عرض المستخدم المالك.',
    '__unknown_network_interface' => 'واجهة شبكة غير معروفة',

    'init_conf__ip_address' => 'عنوان IP',

    //Confirmation page
    'bt_confirm' => 'تأكيد',
    'b_confirm' => 'تأكيد ملكية مواقعك.',

    //// New VZPP Integration
    '__vzpp_integration_warning' => 'إن مثيل Plesk مثبت على حاوية Virtuozzo. إن إعدادات الإدارة دون الاتصال بالإنترنت للحاوية الحالية تمنع توفر Plesk.',
    '__vzpp_integration_contact_admin' => 'إذا كان لديك امتيازات غير كافية لتعديل تكوين الحاوية 1%. أو اتصل بموفر الخدمة للقيام بذلك.',
    '__vzpp_integration_help_link' => 'تغيير إعدادات الإدارة دون الاتصال بالإنترنت',



    'performance__iss_app_pool_forced_by_site_isolation' => 'تم تعيين إعدادات مجموعة تطبيقات IIS المخصصة وفقًا لسياسة الأمان على مستوى الخادم (تكوين عزل الموقع).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'تم تعيين إعدادات مجموعة تطبيقات IIS المخصصة وفقًا لإعدادات الأداء على مستوى الخادم.',

    '__current' => 'حالي',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'تم تحديث خصائص المستخدم.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'لقد استخدمت جميع المجالات المتوفرة باستخدام ترخيص Plesk تقريبًا (%90 أو أكثر).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'لقد استخدمت جميع المجالات تقريبًا.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'لقد استخدمت جميع مواقع Presence Builder باستخدام ترخيص Plesk تقريبًا (%90 أو أكثر).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'لقد استخدمت جميع مواقع Presence Builder.',
    'promo__button_hide' => 'إخفاء',
    'promo__button_next' => 'التالي>>',
    'promo__button_prev' => '<< السابق',
    'promo__button_license' => 'تحديث الترخيص',

    'promo__google_integration_title' => 'التكامل مع خدمات Google',
    'promo__google_integration' => 'تكوين التكامل مع خدمات Google، مثل AdSense، وتطبيقات Apps، وأدوات Webmaster.',
    'promo__google_integration_button' => 'تكوين',

    'promo__button_learn_more' => 'معرفة المزيد',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'يمكنك تخصيص إعدادات مظهر الواجهة والعلامة التجارية عن طريق السمات المخصصة. للحصول على إرشادات حول تخصيص نُسُق Plesk ، راجع 1%.',
    'panel_branding__description_link' => 'مستند المتابعة',

    ///// File Manager new buttons
    'bt_extract_archive' => 'استخراج الملفات',
    'b_filemanager__extract' => 'استخراج الملفات من الأرشيفات المحددة في الدليل الحالي. لاحظ أنه قد يتم عرض أسماء الملف بشكل غير سليم بعد الاستخراج إذا كانت تتضمن أحرفًا وطنية.',
    'filemanager_error_extracting_files' => 'حدث خطأ عند استخراج ملفات الأرشيف: 1%',
    'filemanager_no_archive_files_specified' => 'حدد الملفات التي تريد استخراجها.',
    'filemanager_not_zip_archive_specified' => 'لا يمكن استخراج 1%، حيث إنه ليس ملف ZIP.',
    'filemanager_files_successfully_extracted' => 'تم استخراج ملفات الأرشيف.',
    'filemanager_error_file_download' => 'فشل تنزيل الملف: %1',
    'filemanager__user_poolgrp' => 'مجموعة تجمع التطبيق',

    'loading' => 'جارٍ التحميل...',
    'bt_create_archive' => 'إضافة إلى الأرشيف',
    'filemanager__pack' => "المسار إلى الأرشيف: 1%",
    'filemanager__archive_name' => 'اسم ملف الأرشيف',
    'filemanager__empty_filename' => 'يُرجى إدخال اسم ملف الأرشيف.',
    'filemanager_archive_created' => 'تم إنشاء الأرشيف بنجاح.',
    'filemanager_error_creating_archive' => 'يتعذر إنشاء الأرشيف: 1%',

    'cmd_dns__aaaa_dns_record_already_exist' => "سيتعارض هذا السجل مع سجل AAAA الخاص بالمنطقة.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(لا يدعم خادم FTP عناوين IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'سيتعارض هذا السجل مع سجل اللصق الخاص بالمنطقة \'\\1%\'\\.',
    '__ftp_ipv6_not_supported' => "(لا يدعم خادم FTP عناوين IPv6.)",
    '__ipv6_not_supported' => 'إن IPv6 غير مدعوم.',
    'mail__ipv6_not_supported' => 'IPv6 غير مدعوم من خادم البريد.',
    'mail__relay_while_list_ipv6_not_supported' => 'لا يدعم خادم البريد القائمة البيضاء لترحيل IPv6.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'يجب أن تكون قيمة القناع من مضاعفات الرقم 16.',
    'mail__ip_or_mask_is_invalid' => 'عنوان IP أو القناع غير صالح.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'إعادة التوجيه إلى عناوين IPv6 IP غير مدعوم.',
    'sa__invalid_trusted_networks' => 'شبكات موثوق فيها محددة بشكل غير صحيح: 1%',
    'dns_add__enter_ipv6_address' => "عنوان IPv6",
    'license_trial_days_left' => 'يعمل تطبيق Plesk لديك بترخيص تجريبي تنتهي صلاحيته خلال 1% يومًا (أيام).',
    'excl_ipv6_num' => 'عنوان IPv6 مخصص',
    '__ip_mask' => "قناع الشبكة الفرعية",
    '__ipv4_addr' => 'عنوان IPv4',
    '__ipv6_addr' => 'عنوان IPv6',
    'template__num_excl_ipv6s' => 'تخصيص عناوين IPv6 المخصصة للموزع',
    'anonftp__exclusive_ipv4_required' => 'مطلوب عنوان IPv4 مخصص لإعداد خدمة FTP مجهولة المصدر واستخدامها.',
    'anonftp__ipv4_already_used' => 'لا يجوز لك إعداد خدمة FTP باسم مجهول لهذا الموقع لأنه قد تم تكوينه بالفعل على مجال آخر في عنوان IPv4 نفسه.',


    'restart__kav' => "برنامج Kaspersky لمكافحة الفيروسات",
    '__view_migration_log_detailed_info' => 'عرض السجل',

    'chown__ip_address_warn' => 'قبل نقل الاشتراكات إلى مالك جديد، يجب تحديد عنوان IP لهذا الاشتراك.',
    'chown__no_ip_address' => 'بلا',
    'chown__no_ipv4_address' => 'لا يوجد عنوان IPv4',
    'chown__no_ipv6_address' => 'لا يوجد عنوان IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'ينتمي الاشتراك 1% بالفعل إلى هذا المستخدم.',
    'chown__error_ip_absent_in_ip_pool' => 'عنوان IP وهو %1 غير موجود في تجمع IP للمستخدم الهدف.',
    'chown__error_ip_not_exist' => 'عنوان IP ذو المعرف \'\\1%\'\\ غير موجود.',
    'chown__error_domain_ip_not_selected' => 'يجب تحديد عنوان IP على الأقل للمجال 1%. فحص القيم المحددة لتخطيط IP.',

    '__new_passwd_single' => "كلمة المرور",
    '__confirm_passwd_single' => "تأكيد كلمة المرور",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 address or mask is invalid: يجب أن يكون عنوان IP عنوان بث أحادي صالحًا.',

    '__subscriptions' => 'اشتراكات',

    '__owned_by_reseller' => 'مملوك لبائع التجزئة',
    '__owned_by_provider' => 'مملوك لموفر الخدمة',

    'service_plan__anonymous' => 'مخصص',
    'subscription_not_locked__change_limits_warning' => 'هذا الاشتراك غير مؤمّن: ستتغير القيود على استخدام المورد أثناء المزامنة باستخدام خطة الخدمة.',
    'subscription_not_locked__change_permissions_warning' => 'هذا الاشتراك غير مؤمّن: ستتغير الأذونات أثناء المزامنة باستخدام خطة الخدمة.',

    'subscription__conflict_resolution_policy' => 'سياسة حل التعارضات',
    'subscription__conflict_resolution_policy_lock' => "تأمين الاشتراك",

    'backup__list__backup_warnings' => 'تحذيرات',
    'backup__list__backup_info' => 'المعلومات',
    'backup__restore__object_reseller_template' => 'قالب بائع التجزئة',
    'backup__restore__object_domain_template' => 'قالب المجال',

    'ui__client/permissions_readonly__title' => 'الأذونات',
    'ui__client/permissions_readonly__short-title' => 'الأذونات',

    'subscription__unable_lock_anonymous' => 'هذا الاشتراك غير مرتبط بخطة خدمة، لذا لا يمكن إلغاء تأمينه.',
    'subscription__unable_sync_anonymous' => 'هذا الاشتراك غير مرتبط بخطة خدمة، لذا لا يمكن مزامنته.',
    'subscription__unable_sync_locked' => 'هذا الاشتراك مؤمّن لذا لا يمكن مزامنته.',
    'subscription__locked' => 'الاشتراك مؤمّن.',
    'component_name__urlrewrite' => "إعادة كتابة عنوان URL",
    '__quantity' => 'الكمية',
    'hst__www_root_dir_absent' =>  'تحذير: الدليل المحدد كجذر للمستند غير موجود.',
    'object_creation__domain_is_not_a_webspace' => 'لا يمكن إنشاء هذا الكائن إلا في الاشتراك.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'يحتوي الاشتراك على مواقع، لذلك لا يمكنك تغيير نوع الاستضافة أو حذفها.',
    'phosting__addon_domain_ip_must_match_webspace' => 'خطأ: فشل تحديث عنوان IP. يتعذر تعيين نطاقات الوظيفة الإضافية نظرًا لعدم تعيين عنوان IP إلى النطاق الرئيسي للاشتراك.',
    'domain_plan__unable_change' => 'يتعذر تغيير خطة الخدمة: 1%.',
    'domain_plan__different_hosting_type' => 'يختلف النوع الحالي للاستضافة عن النوع المحدد في خطة الخدمة.',
    'domain_plan__addon_text' => 'الخطة الإضافية',
    'domain_plan__addon_description' => 'تُستخدم الخطة الإضافية لإكمال خطة الاستضافة.',
    'asp_net__managed_runtime_version' => 'إصدار وقت التشغيل المُدار لـ ASP.NET',
    'plan__can_not_change_hosting_type' => 'لا يمكن تغيير نوع الاستضافة عند تحرير خطة معينة.',
    'plan__apply_problems' => 'لم يتم تطبيق الخطة نظرًا لوجود مشكلات في الوظائف التالية: 1.',
    'plan_save__subscription_update_problem' => 'يتعذر تطبيق تغييرات الخطة على 1%.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "تم تعليق الاشتراك مؤقتًا حتى تكتمل عملية النسخ الاحتياطي أو الاستعادة. يُرجى المحاولة مرة أخرى لاحقًا.",
    '__login_incorrect_plain_shadow_password' => 'لقد حددت كلمة مرور غير صالحة لحساب المسؤول. يُرجى استخدام بيانات اعتماد مسؤول النظام (الجذر)، أو الحصول على كلمة المرور الصحيحة. للتعرف على المزيد حول الحصول على كلمة المرور، اقرأ الملف /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'لا يمكنك إرسال عنوان IP الذي لا تملكه',

    'dns__dns_zone_not_synchronized' => 'تم تعديل منطقة DNS. إذا كنت ترغب في تطبيق تغييرات قالب DNS على هذه المنطقة، فيمكنك إما النقر على الزر \'\\Apply DNS Template Changes\'\\ في هذه الصفحة أو اختيار الخيار \'\\Apply the changes to all zones\'\\ في لوحة إدارة الخادم> الأدوات والإعدادات> إعدادات قالب DNS>تطبيق تغييرات قالب DNS.',
    'dns__dns_zone_synchronize_link' => 'انقر',
    'dns__dns_zone_synchronize_done' => 'تم تزامن منطقة DNS بنجاح.',

    'dns__dns_zone_template_not_synchronized' => 'تم تغيير قالب منطقة DNS وسيتم تطبيقه على جميع النطاقات التي تم إنشاؤها حديثًا. يمكنك أيضًا %1.',
    'dns__dns_zone_soa_template_not_synchronized' => 'تم تغيير نموذج SOA وسيتم تطبيقه على جميع النطاقات التي تم إنشاؤها حديثًا. يمكنك أيضًا %1.',
    'dns__dns_zone_template_synchronize_link' => 'تطبيق التغييرات على جميع النطاقات المستضافة',
    'dns__dns_zone_template_error_details' => 'تفاصيل',
    'dns__dns_zone_template_error' => 'حدثت مشكلات أثناء مزامنة مناطق DNS مع قالب منطقة DNS. %1',

    'dns__soa_rname_type_owner' => 'عنوان البريد الإلكتروني لمالك موقع الويب',
    'dns__soa_rname_type_domain' => 'عنوان البريد الإلكتروني للمجال',
    'dns__soa_rname_type_external' => 'عنوان البريد الإلكتروني الخارجي',
    'dns__soa_rname_enforce_email' => 'منع تغيير عنوان البريد الإلكتروني RNAME على أساس كل نطاق',
    'dns__soa_rname_label' => 'البريد الإلكتروني (RNAME)',
    'dns__soa_rname_hint' => 'عنوان البريد الإلكتروني للشخص المسؤول عن منطقة DNS الخاصة بالنطاق. تمت إعادته بواسطة خادم DNS استجابة لاستعلامات SOA.',

    'dns__dns_zone_soa_sync_title' => 'تجاوز إعدادات البنية الخدمية "SOA" لجميع النطاقات الحالية',
    'dns__dns_zone_soa_sync_legend' => 'يلزم التأكيد',
    'dns__dns_zone_soa_sync_text' => 'تحديث سجلات SOA لجميع النطاقات المستضافة من خلال تطبيق التغييرات التي تم إجراؤها على نموذج SOA؟',

    'cu_db__repair_mysql_dbus' => "إصلاح كلمات مرور مستخدم MySQL. تكون هذه العملية ضرورية إذا قمت بالتحديث إلى Plesk 11 من إصدارات أقدم.",

    'scheduled_backup_settings__start_at_hint' => 'الفاصل الزمني للفحص لمهام النسخ الاحتياطي المجدولة هي 15 دقيقة. إذا أردت أن يبدأ Plesk عملية النسخ الاحتياطي في وقت معين، فقم بتحديد جدول للمهمة بحيث تسبق الوقت المحدد بربع ساعة على الأقل.',
    'cu_scheduled_backup_comment' => 'نسخ احتياطي مجدول',
    'cu_scheduled_backup_error' => 'حدث خطأ أثناء عملية النسخ الاحتياطي: %1',
    'cu_scheduled_backup_mail_subject' => '<%1>حدث خطأ أثناء عملية النسخ الاحتياطي المجدول.',
    'cu_scheduled_backup_mail_message' => "%1\nنقطة إدخال Plesk: %2\n\nحدثت الأخطاء التالية أثناء عملية النسخ الاحتياطي المجدولة:\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'النسخ الاحتياطي المجدول. جميع التكوينات والمحتويات.',
    'cu_scheduled_backup_comment_backup_vhost' => 'النسخ الاحتياطي المجدول. جميع التكوينات والمحتويات باستثناء البريد.',
    'cu_scheduled_backup_comment_backup_mail' => 'النسخ الاحتياطي المجدول. تكوين البريد والمحتوى فقط.',
    'cu_scheduled_backup_comment_backup_domain' => 'النسخ الاحتياطي المجدول. تكوين النطاق.',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'يمثل تخزين النسخ الاحتياطية المجدولة في حيز التخزين السحابي البعيد ميزة متميزة. اتصل بمزود الاستضافة لديك لفتحها.',

    'i_backup_invalid_file' => 'هذا ليس نسخًا احتياطيًا صالحًا. لا يمكن استعادة البيانات من هذا الملف. انقر على اسم النسخ الاحتياطي للحصول على التفاصيل.',

    'ui__server/migration/download-agent__short-title' => 'تنزيل Migration & Transfer Agent (وكيل الترحيل والنقل)',
    'ui__server/migration/download-agent__title' => 'تنزيل Migration & Transfer Agent (وكيل الترحيل والنقل)',
    'ui__server/migration/download-agent__description' => '‫يمكنك تنزيل أحدث إصدار متوفر من Migration & Transfer Agent من موقع Plesk الإلكتروني.‬',

    'filemanager_resulting_archive_exists' => 'الملف 1% موجود بالفعل في دليل الهدف.',

    'agent_unable_to_connect' => 'تعذر الاتصال بالوكيل على &apos;\\2%&apos;\\. يُرجى التأكد من تثبيت الوكيل وتشغيله وعدم وجود مشاكل في الاتصالات مع المضيف &apos;\\ 2%&apos;\\.',
    'agent_test_connection_failed' => 'فشل الاتصال بالوكيل في &apos;\\ 2%&apos;\\.',

    'agent_unable_to_resolve_host' => 'يتعذر تحديد موقع المضيف البعيد  &apos;\\ 1%&apos;\\. يُرجى التأكد من عدم وجود مشاكل في الاتصال مع المضيف.',
    'agent_unknown_curl_error' => 'حدث الخطأ  &apos;\\ 1%&apos;\\ أثناء الاتصال بالوكيل على  &apos;\\2%&apos;\\.',
    'agent_unexpected_htp_code' => 'تم استلام رمز HTTP غير المتوقع &apos;\\ 1%&apos;\\ في طلب HTTP إلى الوكيل في &apos;\\ 2%&apos;\\.',
    'agent_unable_to_auth' => '‫تعذرت المصادقة على المضيف &amp;apos;\\\\1%&amp;apos;\\\\.‬ ‫لحل هذه المشكلة، يُرجى اتباع الإرشادات على الموقع http://kb.plesk.com/116606.‬',
    'agent_internal_server_error' => 'حدث خطأ في الخادم الداخلي أثناء تنفيذ الأمر على المضيف البعيد   &apos;\\ 1%&apos;\\.',
    'agent_response_is_empty' => 'تم استلام رد فارغ على طلب HTTP إلى الوكيل في   &apos;\\ 1%&apos;\\.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'يتعذر العثور على وكيل الترحيل والنقل في ذاكرة التخزين المؤقت المحلية. يُرجى إعادة فتح "إدارة الترحيل والنقل" لإصلاح المشكلة.',

    '__hosting_webdeploy' => "نشر Web Deploy",
    'cu_domain__webdeploy' => "نشر Web Deploy (الخيار الافتراضي: 1%)",
    'cu_dom_tpl__webdeploy' => "نشر Web Deploy (الخيار الافتراضي: 1%)",
    'cu_subdomain__webdeploy' => "نشر Web Deploy (الخيار الافتراضي: 1%)",
    'webdeploy__not_installed' => "إن Microsoft Web Deploy غير مثبت على الخادم",
    'webdeploy__forced_by_site_isolation' => "يتعذر تغيير إعدادات نشر Web Deploy (استخدام الويب): ليس لديك الإذن لتجاوز سياسة الأمان على مستوى الخادم. اتصل بموفر الخدمة لديك للحصول على التفاصيل.",



    'backup__restore_options__admin__server_configuration_license' => 'مفتاح الترخيص',
    'migration_start_migrate_server_license' => 'مفتاح ترخيص النقل',

    'defaultcomponents__delegation_rule_not_exist' => '(إن قاعدة التفويض المطلوبة \'\\appPoolPipeline، appPoolNetFx\'\\ غير موجودة)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'تم إنشاء النسخ الاحتياطي بواسطة المسؤول.',
    'i_backup_created_by_reseller' => 'تم إنشاء النسخ الاحتياطي عن طريق بائع التجزئة.',
    'i_backup_created_by_client' => 'تم إنشاء النسخ الاحتياطي بواسطة العميل.',

    'migration__object_exists_on_target_host' => '(موجودة بالفعل على المضيف الهدف)',

    '__customers_total' => 'الإجمالي حسب العملاء',
    '__resellers_total' => 'الإجمالي حسب بائعي التجزئة',
    '__reseller_total' => 'إجمالي بائع التجزئة',


    'cu__mailserver_update_webmail_command' => "يحدد عميل بريد الويب الذي تريد تمكينه أو تعطيله",
    'cu__mailserver_webmail_state' => "يحدد حالة عميل الويب المحدد (تؤدي القيمة \"true\" إلى تمكين العميل، والقيمة \"false\" إلى تعطيله)",

    'cu_db_set_default_user' => 'اجعل مستخدمًا معينًا كمستخدم افتراضي لقاعدة بيانات معينة. يُستخدم الخيار مع الأوامر: add_user، وupdate_user',

    'cu_role__opt_subscription_name' => 'السماح للمستخدمين بالوصول إلى اشتراك محدد فقط',
    'cu_role__opt_for_all_subscription' => 'السماح للمستخدمين بالوصول إلى جميع الاشتراكات من خلال حساب الاستضافة',
    'cu_role__subscription_not_found_role_is_not_limited' => 'يتعذر تطبيق التغييرات على الدور: لم يتم العثور على الاشتراك 1%.',

    'cu_cl_pref__manage_website_maintenance' => 'الوصول إلى العمليات المتقدمة: نسخ موقع ويب',
    'cu_cl_pref__manage_protected_dirs' => 'إدارة الأدلة المحمية بكلمة مرور',
    'cu_cl_pref__manage_mail_settings' => 'إمكانية تغيير إعدادات البريد',


    'cu__command_update_php_settings' => 'يعمل على تحديث إعدادات PHP.',
    'cu__php_settings_option' => 'يؤدي إلى تعيين المسار إلى الملف باستخدام إعدادات PHP.',

    'cu__additional_php_settings_option' => 'يؤدي إلى تعيين المسار إلى الملف باستخدام توجيهات PHP إضافية.',
    'cu__command_show_php_settings' => 'يعرض إعدادات PHP الحالية.',
    'cu__general_settings' => 'الإعدادات العامة:',
    'cu__performance_settings' => 'إعدادات الأداء:',
    'cu__php_fpm_settings' => 'إعدادات PHP-FPM:',
    'cu__additional_directives' => 'التوجيهات الإضافية:',

    'b_filemanager__pack' => 'إضافة الملفات المحددة إلى أرشيف معين.',

    'php_settings_permission_required' => 'إدارة إعدادات PHP العامة',
    'php_settings_performance_permission_required' => 'إدارة إعدادات أداء الاستضافة',
    'php_settings_customized' => 'تم تخصيص إعدادات PHP.',
    'php_settings_synchronized_with_plan' => 'يجب مزامنة إعدادات PHP مع الخطة.',
    'phosting__unknown_shell_type' => 'الغلاف الإلكتروني غير متوفر',

    'login_up__access_denied_subscription_deleted' => 'تم رفض الوصول: تمت إزالة اشتراكك.',

    'role_restricted_to_subscription' => '(منقول مع الاشتراك: 1%)',

    'filemanager__extract' => "استخراج الملفات إلى: 1%",

    'cu__license_command_check_installed_license' => 'فحص صلاحية مفتاح الترخيص المثبت (يؤدي إلى إرجاع رمز الخروج "0" إذا كان المفتاح صالحًا والرقم "1" إذا لم يكن كذلك)',

    'promo__mobile_manager_title' => 'الإدارة المتنقلة لخادم Plesk',
    'promo__mobile_manager' => "زيادة وظائف Plesk بحيث تتمكن من مراقبة الخادم من أجهزة الهاتف المحمول (البلاكبيري، والآيفون، وأجهزة تعمل بنظام أندرويد).",
    'promo__mobile_monitor_title' => 'المراقبة المتنقلة لخادم Plesk',
    'promo__mobile_monitor' => 'الحصول على أكثر المعلومات أهمية حول خوادم Plesk في أي وقت وأي مكان من جهاز الهاتف المحمول (البلاكبيري، والآيفون، وأجهزة تعمل بنظام أندرويد).',
    'promo__mobile_button' => 'معرفة المزيد',

    'ui__server/migration/video__short-title' => 'برامج تعليمية عبر الفيديو',
    'ui__server/migration/video__title' => 'مشاهدة برامج تعليمية عبر الفيديو',
    'ui__server/migration/video__description' => 'مشاهدة برامج تعليمية عبر الفيديو.',

    'subDomainNameHint' => 'أدخل الرمز * كاسم لمجال فرعي لإنشاء مجال فرعي لحرف بدل. ستتم إعادة توجيه زائري الموقع إلى هذا المجال الفرعي بصرف النظر عن اسم المجال الفرعي الذي أدخلوه في المستعرض.',
    'subdomains__wildcard_name_invalid' => "اسم المجال الفرعي غير صالح. يمكنك استخدام الأحرف الأبجدية الرقمية والشرطة (-) والنجمة (*) فقط في أسماء المجال الفرعي.",
    'subdomains__name_invalid' => "اسم المجال الفرعي غير صالح. يمكنك استخدام الأحرف الأبجدية الرقمية والشرطة (-) فقط في أسماء المجال الفرعي.",

    'domain__wildcard_no_www_prefix' => 'لا يمكن استخدام البادئة www للمجالات الفرعية لحروف البدل.',

    '__service_title__milter' => "عامل تصفية Plesk Postfix",
    '__service_description__milter' => "عامل تصفية بريد Plesk Postfix",
    '__milter' => "عامل تصفية Postfix",
    'restart__milter' => "عامل تصفية Plesk ‏(%1)",
    'restart__pop3' => "‫Courier POP3 server‬",
    'restart__pop3s' => "خادم Courier POP3 مع دعم SSL/TLS",
    'restart__imap' => "خادم Courier IMAP",
    'restart__imaps' => "خادم Courier IMAP مع دعم SSL/TLS",
    'restart__authdaemon' => "برنامج مصادقة Courier IMAP الذي يتم تشغيله في الخلفية",
    'restart__imap-pop3' => "‫Dovecot IMAP and POP3 server‬",


    'addon_packages_not_supported' => 'الوظائف الإضافية لتطبيقات الويب المضمنة مع APS غير مضمنة.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'يتعذر التعيين التلقائي لعنوان IP إلى المجال. يُرجى تحديد عنوان IP باستخدام الخيار ip-.',

    'plesk_key__mb_accounts' => 'حسابات المستخدم (بائعو التجزئة والعملاء) في تطبيق "Customer &amp; Business Manager" (إدارة العميل والأعمال)',

    'actionlog__subdomain_dns' => 'منطقة DNS للمجال الفرعي',
    'actionlog__site_subdomain_dns' => 'منطقة DNS للمجال الفرعي ضِمن المجال الافتراضي',

    // PfW only
    'actionlog__event_site_create' => 'تم إنشاء مجال',
    'actionlog__event_site_delete' => 'تم حذف المجال',
    'actionlog__event_site_update' => 'تم تحديث المجال',

    'actionlog__event_site_status_update' => 'تم تحديث حالة المجال',
    'actionlog__event_site_dns_update' => 'تم تحديث منطقة DNS للمجال',
    'actionlog__event_site_guid_update' => 'تم تحديث قيمة GUID للمجال',

    'actionlog__event_site_subdomain_create' => 'تم إنشاء المجال الفرعي',
    'actionlog__event_site_subdomain_delete' => 'تم حذف المجال الفرعي',
    'actionlog__event_site_subdomain_update' => 'تم تحديث المجال الفرعي',

    'actionlog__event_site_alias_create' => 'تم إنشاء اسم مستعار للمجال',
    'actionlog__event_site_alias_delete' => 'تم حذف اسم مستعار للمجال',
    'actionlog__event_site_alias_update' => 'تم تحديث اسم مستعار للمجال',

    'actionlog__event_site_alias_dns_update' => 'تم تحديث منطقة DNS الخاصة بالاسم المستعار للمجال',
    'actionlog__event_subdomain_dns_update' => 'تم تحديث منطقة DNS للمجال الفرعي ضِمن المجال الافتراضي',
    'actionlog__event_site_subdomain_dns_update' => 'تم تحديث منطقة DNS الخاصة بالمجال الفرعي',
    // End of PfW only

    'win_policy__bad_password' => 'فشل التحقق من الصحة. كلمة المرور غير صالحة.',
    'win_policy__password_too_short' => 'فشل التحقق من الصحة. لا تلبي كلمة المرور متطلبات سياسة كلمة المرور لأنها قصيرة جدًا.',
    'win_policy__password_too_long' => 'فشل التحقق من الصحة. لا تلبي كلمة المرور متطلبات سياسة كلمة المرور لأنها طويلة جدًا.',
    'win_policy__password_not_complex_enough' => 'فشل التحقق. كلمة المرور غير معقدة بما فيه الكفاية ولا تلبي متطلبات سياسة كلمة المرور. يجب أن تحتوي كلمات المرور القوية على الأقل على كل ما يلي: ثمانية أحرف؛ حرف واحد كبير أو صغير؛ ثلاثة أرقام وحرف خاص واحد (!، @، #، $، %، ^، &، *، ؟، _، ~) أو رقم واحد وحرفين خاصين.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'تعذر تحديث ترخيص المنتج.',


    'filemanager__error_path_is_not_allowed' => 'غير مسموح بالمسار',
    'filemanager__error_path_is_invalid' => 'المسار غير صالح',
    'filemanager__error_path_not_found' => 'لم يتم العثور على المسار',
    'filemanager__error_path_already_exists' => 'المسار موجود بالفعل',
    'filemanager__error_access_is_denied' => 'تم رفض الوصول',
    'filemanager__error_directory_not_empty' => 'المجلد ليس فارغًا',
    'filemanager__error_sharing_violation' => 'انتهاك المشاركة',
    'filemanager__error_not_same_device' => 'مسار الوجهة ليس على الجهاز نفسه',
    'filemanager__binary_data_access' => 'ربما يكون هذا الملف ثنائيًا. هل تريد فتحه؟',
    'filemanager__unable_to_resolve_realpath' => "يتعذر العثور على الملف 1% في الموقع المحدد",
    'filemanager__access_to_realpath_denied' => "تم رفض الوصول إلى المسار الحقيقي: %1 إلى %2.",
    'bt_exit' => 'خروج',

    'filemanager__chdir_error__' => "يتعذر تغيير الدليل إلى 1%: %2",
    'filemanager__chmod_dir' => "تغيير الأذونات للدليل 1%",
    'filemanager__chmod_error__' => "يتعذر تغيير الأذونات للملف 1%: %2",
    'filemanager__chmod_file' => "تغيير الأذونات للملف 1%",
    'filemanager__copy_error__' => "يتعذر نسخ 1% إلى 2%: %3",
    'filemanager__copy_move' => "نسخ (نقل) الملفات من 1%",
    'filemanager__count_size__' => 'حجم التحديد: 1%',
    'filemanager__count_size_error__' => 'يتعذر حساب الحجم الخاص بـ 1%: %2',
    'filemanager__create_dir' => "إنشاء الدليل",
    'filemanager__create_dir_error__' => "يتعذر إنشاء الدليل 1%: %2",
    'filemanager__dir_not_exists' => "الدليل 1% غير موجود.",
    'filemanager__dirname' => "اسم الدليل",
    'filemanager__filename' => "اسم الملف",
    'filemanager__is_no_such' => "لا يوجد ملف أو دليل بالاسم 1%",
    'filemanager__empty_selection' => "لم يتم تحديد أي ملف (ملفات).",
    'filemanager__file_exists' => "الملف 1% موجود بالفعل.",
    'filemanager__move_error__' => "يتعذر نقل 1% إلى 2%: %3",
    'filemanager__new_dir' => "اسم الدليل",
    'filemanager__not_allowed' => "غير مسموح لك بتغيير الأذونات لهذا الملف.",
    'filemanager__r_perm_dir' => "دليل القائمة",
    'filemanager__r_perm_file' => "قراءة البيانات",
    'filemanager__remove' => "إزالة الملفات من 1%",
    'filemanager__remove_error__' => "تتعذر إزالة الملف 1%: %2",
    'filemanager__rename_dir' => "إعادة تسمية الدليل 1%",
    'filemanager__rename_error__' => "تتعذر إعادة تسمية 1% إلى 2%: %3",
    'filemanager__rename_file' => "إعادة تسمية الملف 1%",
    'filemanager__set_win_permissions_dir' => "تعيين الأذونات للمجلد 1%",
    'filemanager__set_win_permissions_file' => "تعيين الأذونات للملف 1%",
    'filemanager__touch_confirm' => "هل تريد بالتأكيد تغيير الطابع الزمني للملفات المحددة؟",
    'filemanager__no_perms_or_unsupported_file_type' => 'تتعذر قراءة الملف أو أن تنسيق الملف غير مدعوم.',
    'filemanager__upload_error__' => "يتعذر تحميل 1% إلى 2%: %3",
    'filemanager__upload_file' => "تحميل ملف",
    'filemanager__upload_file_src' => "المسار إلى الملف",
    'filemanager__username' => "المستخدم",
    'filemanager__w_perm_dir' => "إنشاء ملفات",
    'filemanager__w_perm_file' => "كتابة البيانات",
    'filemanager__x_perm_dir' => "دليل الاجتياز",
    'filemanager__x_perm_file' => "ملف التنفيذ",
    'filemanager__max_image_size_exceeded' => 'يتعذر عرض الصورة. لا يجوز أن يكون حجم الصورة أكبر من 2% بايت',

    '__fastcgi_unix_support' => 'دعم FastCGI',

    'ts_sessions_list' => 'تعرض هذه الصفحة قائمة بجميع جلسات عمل الخدمات الطرفية.',
    'b_tssessionslist_search' => 'البحث عن جلسات العمل حسب الاسم.',
    'b_tssessionslist_show_all' => 'عرض جميع جلسات عمل الخدمات الطرفية.',
    'l_tssessionslist_state' => 'فرز حسب الدولة.',
    'l_tssessionslist_name' => 'فرز حسب الاسم.',
    'l_tssessionslist_user' => 'فرز حسب المستخدم.',
    'b_tssessionslist_logoff' => 'انقر لتسجيل الخروج من جلسات العمل المحددة.',
    'b_tssessionslist_disconnect' => 'انقر لقطع اتصال جلسات العمل المحددة.',
    'tssessions_info' => 'عرض خصائص جلسة العمل.',
    'tssessions_disconnect' => 'حدد خانة الاختيار "Confirm Removal" (تأكيد الإزالة) وانقر على "OK: (موافق) لقطع اتصال جلسات عمل الخادم الطرفية.',
    'tssessions_logoff' => 'حدد خانة الاختيار "Confirm Removal" (تأكيد الإزالة) وانقر على "OK: (موافق) لتسجيل الخروج من جلسات عمل الخادم الطرفية.',
    'b_tssession_disconnect_submit' => 'انقر لإرسال التغييرات.',
    'b_tssession_logoff' => 'انقر لتسجيل الخروج من جلسة العمل.',
    'b_tssession_logoff_submit' => 'انقر لإرسال التغييرات.',
    'i_tssession_active' => 'نشط',
    'i_tssession_connected' => 'متصل',
    'i_tssession_disconnected' => 'غير متصل',
    'i_tssession_listen' => 'التثبيت',
    'tssessions__tssessionslist' => 'جلسات العمل',
    'tssessionslist__state' => '‫S‬',
    'tssessionslist__name' => 'الاسم',
    'tssessionslist__user' => 'المستخدم',
    'bt_logoff_selected' => 'تسجيل الخروج',
    'bt_logoff' => "تسجيل الخروج",
    'bt_disconnect_selected' => 'قطع الاتصال',
    'bt_tssession_logoff' => 'تسجيل الخروج',
    'bt_tssession_disconnect' => 'قطع الاتصال',
    'bt_tssession_disconect' => 'قطع الاتصال',
    'b_tssession_disconnect' => 'انقر لقطع اتصال جلسة العمل.',
    'b_tssession_logoff_disabled' => 'يتعذر تسجيل الخروج من جلسة العمل.',
    'b_tssession_disconnect_disabled' => 'يتعذر قطع اتصال جلسة العمل.',
    'tssessions_info__title' => 'خصائص جلسة العمل 1%',
    'tssessions_info__property_name' => 'اسم الخاصية',
    'tssessions_info__property_value' => 'قيمة الخاصية',
    'tssessions__disconnect_title' => 'سيتم قطع الاتصال بجلسات عمل الخدمات الطرفية التالية:',
    'tssessions__session_cant_disconnect' => 'لا يمكن قطع الاتصال عن جلسة العمل',
    'tssessions__logoff_title' => 'سيتم تسجيل الخروج من جلسات عمل الخدمات الطرفية التالية:',
    'tssessions__session_cant_logoff' => 'لا يمكن تسجيل الخروج من جلسة العمل',
    'tssessions__select_sessions_to_logoff' => 'يُرجى تحديد جلسات العمل المُراد تسجيل الخروج منها.',
    'tssessions__select_sessions_to_disconnect' => 'يُرجى تحديد جلسات العمل المُراد قطع الاتصال بها.',
    'dns__subdomain_dns_zone_parent' => 'تم تخزين سجلات DNS لهذا المجال الفرعي في منطقة DNS الأصلية. يمكنك تعديل المنطقة الأصلية 1% أو إنشاء منطقة منفصلة للمجال الفرعي.',
    'dns__subdomain_dns_zone_parent_link' => 'هنا',
    'dns__no_dns_zone' => 'لم يتم تعيين أي منطقة DNS مع المجال. لإدارة منطقة DNS للمجال الخاص بك، يجب عليك الضغط على الزر \'\\Restore Defaults\'\\.',
    'dns__unable_turn_on_subdomain_zone' => 'يتعذر تشغيل منطقة المجال الفرعي لأن سجل CNAME لهذا المجال موجود في منطقة المجال الفرعي الأصلي الخاصة به.',

    '__hosting_write_modify' => 'أذونات كتابة/تعديل إضافية',


    'aspdotnet__title' => "تكوين ASP.NET للخادم",
    'aspdotnet__dom_title' => "تكوين ASP.NET لموقع الويب",
    'aspdotnet__wdir_title' => "تكوين ASP.NET للدليل الظاهري 1%",
    'aspdotnet__group_cas_settings' => "أمان الوصول إلى الرمز",
    'aspdotnet__group_client_scripts' => "إعدادات مكتبة البرنامج النصي",
    'aspdotnet__group_conn_strings' => "مدير سلسلة الاتصال",
    'aspdotnet__group_custom_errors' => "إعدادات الخطأ المخصص",
    'aspdotnet__group_framework_version' => "إصدار Framework",
    'aspdotnet__group_globalization' => "إعدادات التعميم",
    'aspdotnet__group_other' => "إعدادات الجلسة",
    'aspdotnet__group_page_and_runtime' => "التجميع وتصحيح الأخطاء",
    'aspdotnet__invalid_dom_config_file' => "ملف تكوين ASP.NET لموقع الويب هذا غير صالح. لاستعادته، استخدم تكوين ASP.NET الافتراضي للخادم بالنقر على \"تعيين كافتراضي\".",
    'aspdotnet__invalid_file_enc' => "قيمة غير صالحة لمعلمة ترميز الملف.",
    'aspdotnet__invalid_req_enc' => "قيمة غير صالحة لمعلمة ترميز الطلب.",
    'aspdotnet__invalid_res_enc' => "قيمة غير صالحة لمعلمة ترميز الرد.",
    'aspdotnet__invalid_parent_wdir_config_file' => "ملف تكوين ASP.NET غير صالح بسبب تلف تكوين ASP.NET الخاص بدليل 1% الأصلي. لحل هذه المشكلة، يجب استعادة تكوين ASP.NET للدليل 1%.",
    'aspdotnet__invalid_global_config_file_admin' => "إن تكوين ASP.NET غير صالح بسبب تلف ملف تكوين ASP.NET للخادم.",
    'aspdotnet__invalid_global_config_file' => "إن تكوين ASP.NET غير صالح بسبب تلف ملف تكوين ASP.NET للخادم. اتصل بموفر الخدمة لديك للحصول على المساعدة.",
    'aspdotnet__invalid_sess_timeout' => "قيمة غير صالحة لمعلمة مهلة جلسة العمل. أدخل عددًا صحيحًا موجبًا أقل من أو يساوي 1%.",
    'aspdotnet__invalid_wdir_config_file' => "ملف تكوين ASP.NET لهذا الدليل الظاهري غير صالح. لاستعادته، استخدم تكوين ASP.NET للدليل الظاهري الأصلي بالنقر على \"تعيين كافتراضي\".",
    'aspdotnet__param_auth_mode' => "وضع المصادقة",
    'aspdotnet__param_conn_strings' => "سلاسل الاتصال",
    'aspdotnet__param_conn_string_name' => "الاسم",
    'aspdotnet__param_conn_string_value' => "معلمات الاتصال",
    'aspdotnet__param_culture' => "الثقافة",
    'aspdotnet__param_custom_err_mode' => "وضع الخطأ المخصص",
    'aspdotnet__param_custom_error_redirect' => "إعادة توجيه عنوان URL",
    'aspdotnet__param_custom_error_status' => "رمز الحالة",
    'aspdotnet__param_custom_errors' => "أخطاء مخصصة",
    'aspdotnet__param_debug_mode' => "تشغيل تصحيح الأخطاء",
    'aspdotnet__param_def_language' => "لغة صفحة الويب الافتراضية",
    'aspdotnet__param_temp_directory' => "دليل مؤقت",
    'aspdotnet__param_file_enc' => "ترميز الملف",
    'aspdotnet__param_req_enc' => "ترميز الطلب",
    'aspdotnet__param_res_enc' => "ترميز الرد",
    'aspdotnet__param_sess_timeout' => "مهلة جلسة العمل (دقائق)",
    'aspdotnet__param_trust_level' => "مستوى ثقة CAS",
    'aspdotnet__param_ui_culture' => "ثقافة واجهة المستخدم",
    'aspdotnet__param_version' => "الإصدار",
    'aspdotnet__param_trust_level_allow_override' => 'السماح بتغيير مستوى ثقة CAS لمواقع الويب الفردية',
    'aspdotnet__restore_default_confirm' => "هل تريد استعادة إعدادات ASP.NET الافتراضية؟",

    'bt_restore_default' => "تعيين كافتراضي",
    'b_aspdotnet' => 'تعديل إعدادات تكوين ASP.NET.',
    'b_aspdotnet__restore_default' => 'استعادة إعدادات ASP.NET الافتراضية.',
    'b_aspdotnet__restore_wdir_default' => "استعادة إعدادات ASP.NET للدليل الأصلي لهذا الدليل الظاهري.",
    'b_aspdotnet__restore_default_disabled' => 'استعادة تكوين ASP.NET الافتراضي غير متوفرة: تكوين ASP.NET غير صالح إما على الخادم أو على مستوى الدليل الأصلي.',
    'b_autoinstaller' => 'تحديث Plesk أو مكوناته.',
    'b_autoinstaller_configure' => 'إعدادات التحديث.',
    'b_autoinstaller_install' => 'تثبيت المكونات المحددة.',

    '__iis_app_pool__use_dedicated' => 'تجمع تطبيقات IIS المخصصة',
    '__iis_app_pool__use_dedicated_addons' => 'مجموعة تطبيقات IIS مخصص لكل موقع ويب',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'تمكين تطبيقات نظام التشغيل 32 بت',
    'bt_iis_app_pool' => "مجموعة تطبيقات IIS",

    'performance__cpu_usage' => 'أقصى استخدام لوحدة المعالجة المركزية (%)',
    'performance__cpu_usage_action' => 'تقييد الإجراء',
    'performance__cpu_usage_interval' => 'تقييد الفاصل (بالدقائق)',
    'performance__cpu_usage_action_not_supported' => 'إن الإجراء المحدد غير مدعوم من قِبل خادم الويب.',

    'performance__idle_timeout_action_not_supported' => 'إن إجراء مهلة وضع الخمول المحدد غير مدعوم من قِبل خادم الويب.',
    'performance__max_worker_processes' => 'أقصى عدد لعمليات العامل',
    'performance__idle_timeout' => 'مهلة وضع الخمول (بالدقائق)',
    'performance__idle_timeout_action' => 'إجراء مهلة وضع الخمول',
    'performance__recycling_by_time' => 'إعادة الاستخدام في فواصل زمنية منتظمة (دقائق)',
    'performance__recycling_by_requests' => 'إعادة استخدام عند الوصول إلى أقصى عدد للطلبات',
    'performance__recycling_by_virtual_memory' => 'إعادة استخدام عند استخدام أقصى كم من الذاكرة الظاهرية',
    'performance__recycling_by_private_memory' => 'إعادة استخدام عند استخدام أقصى كم من الذاكرة الخاصة',
    'performance__managed_pipeline_mode' => 'وضع المسار المُدار',
    'performance__managed_pipeline_mode_not_supported' => 'إن الوضع المحدد غير مدعوم من قِبل خادم الويب.',

    'iis_app_pool' => 'إدارة مجموعة تطبيقات IIS.',
    'b_iis_app_pool' => 'إدارة مجموعة تطبيقات IIS.',
    'iis_app_pool_cl_dom' => 'إدارة مجموعة تطبيقات IIS.',

    'i_webdirs_not_protected' => 'هذا الدليل غير محمي.',
    'i_webdirs_protected' => 'هذا الدليل محمي.',
    'i_webdirs_manage_protection' => 'إدارة الحماية.',
    'i_webdirs_open' => 'فتح الدليل/الملف في المستعرض.',
    'i_webdirs_preferences_disabled' => 'هذا الدليل ليس دليلاً ظاهريًا.',
    'i_webdirs_permissions' => 'إدارة الأذونات.',
    'i_webdirs_permissions_disabled' => 'إدارة أذونات الدليل غير متوفرة.',
    'i_webdirs_type_dir' => 'الدليل المادي',
    'i_webdirs_type_vdir' => 'الدليل الظاهري',
    'i_webdirs_browse' => 'استعراض محتويات الدليل.',
    'i_webdirs_preferences' => 'إدارة إعدادات دليل الويب.',

    'l_webdirslist_type' => 'فرز الدلائل حسب النوع.',
    'l_webdirslist_protected' => 'فرز الدلائل حسب حالة الحماية.',
    'l_webdirslist_name' => 'فرز الدلائل حسب الاسم.',

    'b_webdirslist_remove' => 'حذف الأدلة الظاهرية المحددة.',
    'b_webdirslist_search' => 'أدخل نمط بحث وانقر للبحث عن الأدلة الظاهرية.',
    'b_webdirslist_show_all' => 'عرض جميع الدلائل.',

    'l_webdirerrordocslist_code' => 'فرز مستندات الخطأ حسب رقم رمز الخطأ.',
    'l_webdirerrordocslist_name' => 'فرز مستندات الخطأ حسب وصف الخطأ.',
    'l_webdirerrordocslist_type' => 'فرز مستندات الخطأ حسب نوع مستند الخطأ.',
    'l_webdirerrordocslist_location' => 'فرز مستندات الخطأ حسب موقع مستند الخطأ.',

    'b_webdirerrordocslist_search' => 'أدخل نمط بحث وانقر للعثور على مستندات الخطأ.',
    'b_webdirerrordocslist_remove' => 'حذف مستندات الخطأ المحددة.',
    'b_webdirerrordocslist_show_all' => 'عرض جميع مستندات الخطأ.',

    'l_webdirmimetypeslist_name' => 'فرز أنواع MIME حسب الامتداد.',
    'l_webdirmimetypeslist_content' => 'فرز أنواع MIME حسب المحتوى.',

    'b_webdirmimetypeslist_remove' => 'حذف أنواع MIME المحددة.',
    'b_webdirmimetypeslist_search' => 'أدخل نمط بحث وانقر للبحث عن أنواع MIME.',
    'b_webdirmimetypeslist_show_all' => 'عرض كل أنواع MIME.',

    'b_webdir_preferences' => "إعدادات الدليل الظاهري.",
    'b_webdir_permissions' => "أذونات الدليل الظاهري.",
    'b_webdir_permissions_disabled' => "إدارة أذونات الدليل غير متوفرة.",
    'b_to_webdirs' => 'العودة إلى إدارة الدلائل.',
    'b_to_webdir_mime_types' => 'العودة إلى إدارة أنواع MIME.',
    'b_to_webdir_error_docs' => 'العودة إلى إدارة مستندات الخطأ.',
    'b_to_webdir_protection' => 'العودة إلى إدارة حماية الدليل الظاهري.',

    'webdirs__title' => 'الدليل الظاهري 1%',
    'webdirs__preferences_title' => 'إعدادات الدليل الظاهري',
    'webdirs__list_legend' => 'أدلة ظاهرية',
    'webdirs__list_type' => 'تيرا',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'الاسم',
    'webdirs__list_header' => 'عناصر 1%',
    'webdirs__tabs_general' => 'عام',
    'webdirs__tabs_mime_types' => 'أنواع MIME',
    'webdirs__tabs_error_docs' => 'مستندات الخطأ',

    'webdirs__tabs_permissions' => 'الأذونات',
    'webdir__remove_vdirs' => 'سيتم حذف الأدلة الظاهرية التالية:',
    'webdir__remove_mime_types' => 'سيتم حذف أنواع MIME التالية:',
    'webdir__mime_types_title' => 'أنواع MIME',
    'webdir__protection_disable_confirm' => 'هل تريد بالفعل إزالة الحماية من الدليل؟',
    'webdir__protect_title' => 'مستخدمو عنوان URL المحمي',
    'webdirs__permissions_title' => 'أذونات الدليل الظاهري',
    'webdirs__browse_content_permission_denied' => 'ليس لديك أذونات لعرض محتويات هذا الدليل.',
    'error_doc__list_code' => 'خطأ',
    'error_doc__list_code_description' => 'الوصف',
    'error_doc__list_type' => 'النوع',
    'error_doc__list_location' => 'الموقع',
    'error_doc__code' => 'خطأ',
    'error_doc__type' => 'النوع',
    'error_doc__type_file' => 'الملف',
    'error_doc__type_url' => 'عنوان URL',
    'error_doc__location' => 'الموقع',
    'error_doc__legend' => 'مستند الخطأ',
    'error_doc__edit_title' => 'تحرير مستند الخطأ',
    'error_doc_erorr_invalid_url_location' => 'عنوان URL غير صالح. يرجى تحديد عنوان URL الصحيح.',
    'error_doc_erorr_invalid_file_location' => 'مسار الملف غير صالح. يرجى تحديد مسار الملف الصحيح.',
    'error_doc__type_default' => 'افتراضي',

    'webdirs__tabs_protection' => 'الحماية',
    'pb_webdirs' => 'أدلة ظاهرية',

    'webdirs_remove_title' => 'ستتم إزالة الأدلة الظاهرية التالية:',
    'webdirs_mime_types_remove_title' => 'ستتم إزالة أنواع MIME التالية:',
    'webdirs_preferences_title' => 'إعدادات الدليل الظاهري',
    'webdirs_permissions_title' => 'أذونات خاصة للملفات والمجلدات',
    'webdi_protection_disable_confirm' => 'هل تريد بالتأكيد إزالة الحماية من الدليل الظاهري؟ سيؤدي ذلك إلى إزالة جميع مستخدمي الدليل وإعدادات حماية الدليل.',
    'bt_protect' => 'حماية',
    'bt_unprotect' => 'الحماية من الإزالة',
    'bt_show_additional_users' => 'عرض عدد أكبر من المستخدمين',
    'bt_hide_additional_users' => 'عرض عدد أقل من المستخدمين',
    'error_doc__list_title' => 'مستندات الخطأ',
    'error_doc__list_header' => 'مستندات الخطأ',
    'error_doc__code_400' => 'طلب غير مناسب',
    'error_doc__code_401' => 'غير مخول',
    'error_doc__code_401.1' => 'غير مخول - فشل تسجيل الدخول',
    'error_doc__code_401.2' => 'غير مخول - فشل تسجيل الدخول بسبب تكوين الخادم',
    'error_doc__code_401.3' => 'غير مخول - بسبب ACL في المورد',
    'error_doc__code_401.4' => 'غير مخول - فشل التخويل بسبب عامل التصفية',
    'error_doc__code_401.5' => 'غير مخول - فشل التخويل بسبب تطبيق ISAPI/CGI',
    'error_doc__code_401.7' => 'غير مخول - تم الرفض بسبب سياسة مصادقة عنوان URL',
    'error_doc__code_403' => 'محظور',
    'error_doc__code_403.1' => 'محظور - تم رفض الوصول إلى التنفيذ',
    'error_doc__code_403.2' => 'محظور - تم رفض الوصول إلى القراءة',
    'error_doc__code_403.3' => 'محظور - تم رفض الوصول إلى الكتابة',
    'error_doc__code_403.4' => 'محظور - يجب توفير SSL',
    'error_doc__code_403.5' => 'محظور - يجب توفير SSL 128',
    'error_doc__code_403.6' => 'محظور - تم رفض عنوان IP',
    'error_doc__code_403.7' => 'محظور - يجب توفير شهادة العميل',
    'error_doc__code_403.8' => 'محظور - تم رفض الوصول إلى الموقع',
    'error_doc__code_403.9' => 'محظور - عدد كبير من المستخدمين',
    'error_doc__code_403.10' => 'محظور - تكوين غير صالح',
    'error_doc__code_403.11' => 'محظور - تغيير كلمة المرور',
    'error_doc__code_403.12' => 'محظور - تم رفض الوصول إلى المُخطط',
    'error_doc__code_403.13' => 'محظور - تم استدعاء شهادة العميل',
    'error_doc__code_403.14' => 'محظور - تم رفض سرد الدليل',
    'error_doc__code_403.15' => 'محظور - تم تجاوز تراخيص الوصول إلى العميل',
    'error_doc__code_403.16' => 'محظور - شهادة العميل غير موثوق بها أو غير منظمة',
    'error_doc__code_403.17' => 'محظور - انتهت صلاحية شهادة العميل أو لم تصبح صالحة بعد',
    'error_doc__code_403.18' => 'محظور - لا يمكن تنفيذ الطلب من تجمع التطبيق هذا',
    'error_doc__code_403.19' => 'محظور - تم رفض الوصول إلى CGI',
    'error_doc__code_403.20' => 'محظور - فشل تسجيل الدخول إلى جواز السفر',
    'error_doc__code_404' => 'غير موجود',
    'error_doc__code_404.2' => 'غير موجود - تم الرفض بسبب سياسة التأمين',
    'error_doc__code_404.3' => 'غير موجود - تم الرفض بسبب سياسة MIMEMAP',
    'error_doc__code_405' => 'غير مسموح بالطريقة',
    'error_doc__code_406' => 'غير مقبول',
    'error_doc__code_407' => 'يجب توفير توثيق الوكيل',
    'error_doc__code_412' => 'فشل الشرط المسبق',
    'error_doc__code_414' => 'عنوان URI للطلب طويل جدًا',
    'error_doc__code_415' => 'نوع وسائط غير مدعوم',
    'error_doc__code_500' => 'خطأ داخلي في الخادم',
    'error_doc__code_500.12' => 'خطأ داخلي في الخادم - إعادة تشغيل التطبيق',
    'error_doc__code_500.13' => 'خطأ داخلي في الخادم - الخادم مشغول جدًا',
    'error_doc__code_500.15' => 'خطأ داخلي في الخادم - الطلبات المباشرة الخاصة بـ GLOBAL.ASA ممنوعة',
    'error_doc__code_500.16' => 'خطأ داخلي في الخادم - خطأ في الوصول إلى UNC',
    'error_doc__code_500.17' => 'خطأ داخلي في الخادم - مخزن اعتماد عنوان URL غير موجود',
    'error_doc__code_500.18' => 'خطأ داخلي في الخادم - لا يمكن فتح مخزن اعتماد عنوان URL',
    'error_doc__code_500.19' => 'خطأ داخلي في الخادم - بيانات تعريف الملف غير صالحة',
    'error_doc__code_500.100' => 'خطأ داخلي في الخادم - خطأ ASP',
    'error_doc__code_501' => 'لم يتم التنفيذ',
    'error_doc__code_502' => 'بوابة غير صالحة',
    'error_doc__code_503' => 'الخدمة غير متوفرة مؤقتًا',

    'mimetype__extension' => 'الملحق',
    'mimetype__content' => 'المحتوى',
    'mimetypeslist__title' => 'أنواع MIME',
    'mimetypes__title' => 'أنواع MIME',
    'mimetypes__select_to_remove' => 'حدد أنواع MIME التي تريد إزالتها.',
    'mimetypes__select_for_remove' => "حدد أنواع MIME المُراد إزالتها.",
    'mimetypes_remove__title' => 'إزالة نوع MIME',
    'mimetype__legend' => 'نوع MIME',
    'mimetype_edit__title' => 'تحرير نوع MIME',
    'mimetype_edit__already_exists' => 'نوع MIME محدد بالفعل لهذا الامتداد.',
    'mimetype_edit__not_exists' => 'نوع MIME غير موجود.',
    'mimetype__content_type_other' => 'تخصيص...',

    'b_webdir_protection_enable' => 'جعل عنوان URL الذي يتوافق مع الدليل محميًا بكلمة مرور.',
    'b_webdir_protection_disable' => 'جعل عنوان URL الذي يتوافق مع الدليل قابلاً للوصول بالنسبة إلى الجميع.',
    'b_webdir_protection_disabled' => 'تم تعطيل حماية الدليل الظاهري.',

    'b_pd_usr_create' => 'انقر لإنشاء مستخدم عنوان URL المحمي هذا.',
    'php__changeversion_title' => "تحديد إصدار PHP",
    'php__group_php_version' => "إصدار PHP",

    'virtualdir__name' => 'الاسم',
    'virtualdir__path' => 'المسار',
    'virtualdir__read' => 'إذن القراءة',
    'virtualdir__read_short' => 'الصفحة المرجعية',
    'virtualdir__write' => 'إذن الكتابة',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'الوصول إلى مصدر البرنامج النصي',
    'virtualdir__source_short' => '‫S‬',
    'virtualdir__browse' => 'تصفح الدليل',
    'virtualdir__browse_short' => 'بايت',
    'virtualdir__script_execute' => 'أذونات التنفيذ',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'تسجيل الزيارات',
    'virtualdir__app_create' => 'إنشاء تطبيق',
    'virtualdir__app_create_short' => '‫A‬',
    'virtualdir__auth_anon' => '‫يمكنك تشغيل مصادقة باسم مجهول.‬',
    'virtualdir__auth_windows' => '‫تشغيل مصادقة Windows.‬',
    'virtualdir__auth_not_enabled' => '‫يجب تشغيل المصادقة باسم مجهول أو مصادقة Windows.‬',
    'virtualdir__require_ssl' => 'يتطلب SSL/TLS',
    'virtualdir__enable_default_doc' => 'استخدام المستندات الافتراضية',
    'virtualdir__default_doc' => 'أمر البحث عن المستندات الافتراضية',
    'virtualdir__enable_parent_paths' => 'السماح باستخدام المسارات الأصلية',
    'virtualdir__execute_in_mta' => 'السماح بتنفيذ التطبيق في وضع MTA (متعدد الترابط)',
    'virtualdir_create__title' => 'إنشاء دليل ظاهري في 1%',
    'virtualdir_edit__title' => 'خصائص الدليل الظاهري 1%',
    'virtualdir_edit__legend' => 'الدليل الظاهري',
    'virtualdir_edit__application_legend' => 'إعدادات التطبيق',
    'virtualdir_edit__security_legend' => 'أمان الدليل',
    'virtualdir_edit__documents_legend' => 'مستندات',
    'virtualdir_edit__list_legend' => 'أدلة ظاهرية متداخلة',
    'virtualdir_error__path_not_in__' => 'تم تحديد مسار غير صالح',
    'virtualdir_error__already_exists' => 'يوجد دليل بهذا الاسم بالفعل.',
    'virtualdir_root' => 'أدلة ظاهرية',
    'virtualdir_root__title' => 'أدلة ظاهرية',
    'virtualdir_root__list_legend' => 'أدلة ظاهرية',
    'virtualdir_se__none' => 'بلا',
    'virtualdir_se__script' => 'البرامج النصية فقط',
    'virtualdir_se__script_execute' => 'البرامج النصية والملفات التنفيذية',
    'virtualdirs__title' => 'أدلة ظاهرية',
    'virtualdirs__path_not_exists' => 'مسار غير صالح.',
    'virtualdirs__select_for_remove' => "حدد الأدلة الظاهرية المُراد إزالتها.",
    'virtualdirs_remove__title' => 'إزالة الأدلة الظاهرية',
    'virtualdirs_phys_dir_exist' => 'يوجد دليل مادي بهذا الاسم بالفعل. في حالة المتابعة، سيتعذر الوصول. هل ترغب في المتابعة؟',
    'virtualdir_auto_create_dir' => "إنشاء الدليل المادي بالاسم نفسه كدليل ظاهري",

    'asp_max_default_text' => 'محدد بواسطة الدليل الأصلي (1% كيلو بايت)',
    'asp_max_default_text_site' => 'محدد بواسطة IIS ‏(%1 كيلو بايت)',
    'asp_max_buffer_text' =>'أقصى حجم للمخزن المؤقت لـ ASP (كيلو بايت)',
    'asp_max_body_text' => 'أقصى حجم لنص الكيان لطلب ASP (كيلو بايت)',
    'asp_buffers_legend' =>'إعدادات ASP',

    'asp_debug_default_text' =>'محدد بواسطة الدليل الأصلي',
    'asp_debug_default_text_site' =>'محدد بواسطة IIS',
    'asp_client_debug_text' =>'تمكين تصحيح أخطاء البرنامج النصي لـ ASP من جانب العميل',
    'asp_server_debug_text' =>'تمكين تصحيح أخطاء البرنامج النصي لـ ASP للخادم',

    'webdirs__list_with_broken_dirs' => "توجد دلائل ظاهرية مرتبطة بمجلدات فعلية غير موجودة.",
    'webdirs__vdir_physical_path_not_exist' => "الدليل الظاهري مرتبط بمجلد فعلي غير موجود.",
    'webdirs__physical_path_not_exist' => "المسار المحدد غير موجود.",

    'filemanager__new_dir_title' => 'إنشاء دليل',
    'php__configuration_title' => "تكوين PHP",

    'permissions__title' => 'إعداد أذونات الوصول',
    'permissions__title_advanced' => 'إعداد أذونات الوصول المتقدم',
    'permissions__inherit_from_parent' => 'السماح للأذونات المكتسبة من الأصل بالنشر إلى هذا الكائن وجميع الكائنات الفرعية. تضمين ذلك مع المدخلات الموضحة بشكل صريح هنا.',
    'permissions__replace_on_children' => 'استبدال مدخلات الإذن على جميع الكائنات الفرعية باستخدام المدخلات الموضحة هنا.',
    'permissions__group_or_user_name' => 'أسماء المجموعة والمستخدم',
    'permissions__Permissions_for' => 'الأذونات الخاصة بـ',
    'permissions__allow' => 'السماح',
    'permissions__deny' => 'رفض',
    'permissions__FullControl' => 'التحكم الكامل',
    'permissions__Modify' => 'تعديل',
    'permissions__ReadAndExecute' => 'القراءة والتنفيذ',
    'permissions__ListFolderContents' => 'سرد محتويات المجلد',
    'permissions__Read' => 'القراءة',
    'permissions__Write' => 'كتابة',
    'permissions__ReadControl' => 'التحكم في القراءة',
    'permissions__WriteControl' => 'التحكم في الكتابة',
    'permissions__ExecuteControl' => 'التحكم في التنفيذ',
    'permissions__TraverseFolderOrExecuteFile' => 'اجتياز المجلد / تنفيذ الملف',
    'permissions__ListFolderOrRead' => 'سرد المجلد / قراءة البيانات',
    'permissions__CreateFilesOrWrite' => 'إنشاء الملفات / كتابة البيانات',
    'permissions__CreateFoldersOrAppend' => 'إنشاء المجلدات / البيانات المحلقة',
    'permissions__DeleteSubfoldersandFiles' => 'حذف المجلدات الفرعية والملفات',
    'permissions__Delete' => 'حذف',
    'permissions__ChangePermissions' => 'أذونات التغيير',
    'permissions__TakeOwnership' => 'الحصول على الملكية',
    'permissions__inherited_from' => 'مكتسب من',
    'permissions__not_inherited' => '<غير مكتسب>',
    'permissions__apply_to' => 'تطبيق على',
    'permissions__apply_onto' => 'تطبيق على:',
    'permissions__apply_onto1' => 'هذا المجلد فقط',
    'permissions__apply_onto2' => 'المجلدات الفرعية فقط',
    'permissions__apply_onto3' => 'هذا المجلد والمجدات الفرعية',
    'permissions__apply_onto4' => 'الملفات فقط',
    'permissions__apply_onto5' => 'هذا المجلد والملفات',
    'permissions__apply_onto6' => 'المجلد الفرعي والملفات فقط',
    'permissions__apply_onto7' => 'هذا المجلد والملفات الفرعية والملفات',

    'filemanager__not_allowed_dir' => "غير مسموح لك بتغيير الأذونات لهذا المجلد.",

    'filemanager__allow' => "السماح",
    'filemanager__deny' => "رفض",
    'filemanager__user_domusr' => 'مسؤول موقع الويب',
    'filemanager__user_webusr' => 'مستخدم الويب',
    'filemanager__user_admins' => 'المسؤولون',
    'filemanager__user_system' => 'النظام',
    'filemanager__user_aspnet' => 'مستخدم ASP.NET',
    'filemanager__user_poolusr' => 'مستخدم تجمع التطبيق',
    'filemanager__user_sysaccount' => 'مستخدم النظام الافتراضي',

    'bt_permissions_advanced' => 'خيارات متقدمة',
    'b_permissions_advanced' => 'انقر لعرض أذونات خاصة وتعيينها.',

    'b_hotlinkprotection' => 'إعداد حماية للارتباط السريع الخاص بموقع الويب.',
    'b_hotlinkprotection_on' => 'تمكين حماية الارتباط السريع لمحتوى الموقع الإلكتروني.',
    'b_hotlinkprotection_off' => 'تعطيل حماية الارتباط السريع لمحتوى الموقع الإلكتروني.',

    'bt_hotlinkprotection' => 'حماية الارتباط السريع',
    'hotlinkprotection__title' =>'حماية الارتباط السريع',
    'hotlinkprotection__friend_domains' => 'عناوين مواقع الويب المناسبة',
    'hotlinkprotection__extensions' => 'امتدادات الملفات المحمية',

    'hotlinkprotection_invalid_friend_domains' => 'أسماء غير صالحة للمجالات المناسبة.',
    'hotlinkprotection_invalid_extensions' => 'تتضمن امتدادات الملف أحرفًا غير صالحة.',

    'i_domain_alias_status_on' => 'تم تمكين الاسم المستعار للمجال.',
    'i_domain_alias_status_off' => 'تم تعطيل الاسم المستعار للمجال.',
    'i_domain_alias_status_with_parent' => 'تم تعطيل الاسم المستعار للمجال بسبب إيقاف تشغيل المجال.',
    'i_domain_alias_turn_off' => 'انقر للتعطيل.',
    'i_domain_alias_turn_on' => 'انقر للتمكين.',
    'i_domain_alias_mail_on' => 'تم تمكين خدمة البريد للاسم المستعار لهذا المجال.',
    'i_domain_alias_mail_off' => 'تم تعطيل خدمة البريد للاسم المستعار لهذا المجال.',
    'i_domain_alias_mail_with_parent' => 'تم تعطيل خدمة البريد بسبب إيقاف تشغيل الاسم المستعار للمجال.',
    'i_domain_alias_web_on' => 'تم تمكين خدمة الويب للاسم المستعار لهذا المجال.',
    'i_domain_alias_web_off' => 'تم تعطيل خدمة الويب للاسم المستعار لهذا المجال.',
    'i_domain_alias_web_with_parent' => 'تم تعطيل خدمة الويب بسبب إيقاف تشغيل الاسم المستعار للمجال.',
    'i_domain_alias_dns_on' => 'تم تشغيل خدمة الاسم المستعار DNS لاسم النطاق المستعار هذا.',
    'i_domain_alias_dns_off' => 'تم إيقاف تشغيل خدمة الاسم المستعار DNS لاسم النطاق المستعار هذا.',
    'i_domain_alias_dns_with_parent' => 'تم تعطيل مزامنة DNS مع المجال الأصلي بسبب إيقاف تشغيل الاسم المستعار للمجال.',
    'i_domain_alias_seoRedirect_on' => 'تم تشغيل عملية إعادة التوجيه باستخدام الرمز HTTP 301 لاسم النطاق المستعار هذا.',
    'i_domain_alias_seoRedirect_off' => 'تم إيقاف تشغيل عملية إعادة التوجيه باستخدام الرمز HTTP 301 لاسم النطاق المستعار هذا.',
    'i_domain_alias_seoRedirect_with_parent' => 'تم إيقاف تشغيل عملية إعادة التوجيه باستخدام الرمز HTTP 301 نظرًا لإيقاف تشغيل اسم النطاق المستعار.',

    'domain_alias__control_title' => 'الاسم المستعار 1% للمجال',
    'domain_alias__control_info_legend' => 'المعلومات',
    'domain_alias__control_status_title' => '‫S‬',
    'domain_alias__control_name_title' => 'اسم الخدمة',
    'domain_alias__control_details_title' => 'تفاصيل',

    'domain_alias__invalid_values' => 'اسم المجال الذي حددته غير صالح. يمكن أن تتضمن أسماء المجال كلاً من الحروف والأرقام والشرطات. يجب ألا يزيد طول كل جزء من اسم المجال بين النقط عن 63 رمزًا.',
    'domain_alias__domain_already_exists' => "اسم غير صحيح للاسم المستعار للمجال 1%. المجال 1% موجود بالفعل.",
    'domain_alias__www_prefix_domain_already_exists' => "Incorrect name of the domain alias www.%1. تم إنشاء هذا الاسم المستعار بالفعل للمجال 1%.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'اسم غير صحيح لبريد الويب للاسم المستعار للمجال 1%. تم إنشاء هذا الاسم المستعار بالفعل للمجال 1%.',
    'domain_alias__lists_enabled_domain_already_exists' => 'اسم غير صحيح لقوائم الاسم المستعار للمجال 1%. تم إنشاء هذا الاسم المستعار بالفعل للمجال 1%.',
    'domain_alias__dns_record_already_exists' => 'يتعذر إعداد الاسم المستعار 1% للمجال لأن سجل DNS يشير إلى أن المضيف 1% موجود بالفعل.',
    'domain_alias__domain_alias_already_exists' => "هذا الاسم المستعار للمجال موجود بالفعل.",
    'domain_aliases__mail_server_not_support_aliases' => 'لا يدعم خادم البريد ميزة الأسماء المستعارة للمجال. قد لا تعمل الأسماء المستعارة للمجال بشكل سليم.',
    'domain_alias__restrict_domain_creation' => 'الاسم المحدد للاسم المستعار للمجال محظور بسبب سياسة الخادم. إذا كان الاسم المستعار لهذا المجال ينتمي إليك، فيُرجى الاتصال بموفر خدمة الاستضافة لديك.',
    'domain_alias__restrict_creation_with_www' => 'يُرجي إدخال اسم مجال بدون البادئة \'\\www\'\\ ستتم إضافة البادئة www للمجال تلقائيًا إلى تكوين خادم الويب.',
    'domain_unable_to_set_name' => 'اسم غير صحيح 1%.',

    'domain_alias__domain_service_dns_disabled' => 'يُقدم هذا المجال عن طريق خادم DNS آخر.',
    'domain_alias__domain_service_dns_enabled_master' => 'يعمل خادم DNS هذا كخادم اسم رئيسي لمنطقة DNS هذه.',
    'domain_alias__domain_service_dns_enabled_slave' => 'يعمل خادم DNS هذا كخادم اسم تابع لمنطقة DNS هذه.',
    'domain_alias__domain_service_mail_enabled' => 'خدمة البريد قيد التشغيل بالنسبة إلى المجال.',
    'domain_alias__domain_service_mail_disabled' => 'خدمة البريد قيد إيقاف التشغيل بالنسبة إلى المجال.',
    'domain_alias__domain_service_mail_mx' => 'يُستخدم 1% كخادم البريد.',

    'domain_alias__service_seoRedirect_hint' => 'عندما يقوم الزائرون بفتح عنوان URL للاسم المستعار، ستتم إعادة توجيههم إلى عنوان URL للمجال الأساسي. يستخدم Plesk إعادة التوجيه HTTP 301 المناسب لمحرك البحث، والذي يعني أن تصنيف محرك البحث سيتم تقسيمه بين عناوين URL.',

    'bt_task_run_now' => 'تشغيل الآن',
    'ftp__read_perm' => "إذن القراءة",
    'ftp__write_perm' => "إذن الكتابة",

    'filemanager__upload_backup_file_hint' => 'يمكنك من هنا تحميل ملفات النسخ الاحتياطي إلى مخزن Plesk. يتقيد أقصى حجم للملف باثنين غيغابايت.',

    '__default_for_mssql' => 'افتراضي لـ MS SQL',

    '__login_does_not_pass_validation' => "اسم المستخدم غير صالح. تأكد من تلبيته للمتطلبات التالية: 1%",
    '__login_allowed_symbols' => 'يُسمح بالأحرف الأبجدية الرقمية فقط والتي تشمل النقاط، والشرطات المائلة، والشرطات السفلية فقط. يجب أن يكون الحرف الأول أبجديًا رقميًا.',

    'restart__nginx' => 'عكس خادم الوكيل (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "‫أود الحصول على معلومات عامة وإعلانات حول المنتج من Plesk.‬",
    'admin_ed__i_would_like_recieve_tech_announce' => "‫أود الحصول على معلومات مرتبطة بالأمان وإعلامات تقنية أخرى من Plesk.‬",

    '__login_status_inactive' => 'إن حسابك ليس نشطًا. يُرجى الاتصال بمسؤول Plesk.',

    'migration__task_keep_in_process' => 'موافق',
    'migration__task_keep_in_process_conhelp' => 'العودة إلى صفحة الأدوات والإعدادات. سيستمر الترحيل في الخلفية.',

    'ui__admin-alias-info__description' => "تحرير معلومات جهة الاتصال لحساب المسؤول الإضافي.",
    'ui__admin-alias-info__short-title' => "معلومات جهة الاتصال",
    'ui__admin-alias-info__title' => "معلومات حساب المسؤول الإضافي",
    'ui__admin-alias-password__description' => "تغيير كلمة مرور المسؤول الإضافي.",

    'ui__admin-alias-password__short-title' => "تغيير كلمة المرور",
    'ui__admin-alias-password__title' => "كلمة مرور المسؤول الإضافي",
    'ui__admin-alias__description' => "عرض معلومات المسؤول الإضافي وتغييرها.",

    'chk_js__warning_about_login_syntax' => "يمكنك استخدام رموز الأحرف الأبجدية الرقمية الصغيرة والشرط السفلية والشرط في اسم المستخدم. يجب أن يبدأ اسم المستخدم برمز من الأحرف الأبجدية الرقمية. يجب ألا تحتوي كلمة المرور على اسم المستخدم وعلامة اقتباس.",
    'chk_js__warning_about_ftp_login_syntax' => "يمكنك استخدام رموز الأحرف الأبجدية الرقمية والشرط السفلية والشرط في اسم المستخدم.",
    'chk_js__warning_about_login_syntax_win' => "يمكنك استخدام رموز الأحرف الأبجدية الرقمية الصغيرة والشرطة والنقطة والشرطة السفلية في اسم المستخدم. يجب أن يبدأ اسم المستخدم برمز من الأحرف الأبجدية الرقمية أو رقم. يجب ألا تحتوي كلمة المرور على اسم المستخدم وعلامة اقتباس.",
    'chk_js__warning_about_passwd_syntax' => "لا تستخدم علامات الاقتباس، والمسافة، والأحرف الأبجدية العربية في كلمة المرور.\nيجب أن يتراوح طول كلمة المرور بين %1 و%2 حرفًا، ويجب ألا تحتوي على اسم المُستخدِم.",
    'chk_js__warning_about_plesk_login_syntax' => "يمكنك استخدام رموز الأحرف الأبجدية الرقمية الصغيرة والنقاط والشرط السفلية والشرط في اسم المستخدم.",
    'chk_js__warning_about_plesk_login_syntax_win' => "يمكنك استخدام رموز الأحرف الأبجدية الرقمية الصغيرة والشرط السفلية والشرط في اسم المستخدم. يجب أن يبدأ اسم المستخدم برمز من الأحرف الأبجدية الرقمية.",
    'chk_js__warning_about_plesk_passwd_syntax' => "لا تستخدم علامات الاقتباس، والمسافة، والأحرف الأبجدية العربية في كلمة المرور.\n يجب أن يتراوح طول كلمة المرور بين %1 و%2 حرفًا، ويجب ألا تحتوي على اسم المستخدم.",
    'chk_js__warning_about_pam_passwd_error' => "تم تحديد حساب مستخدم نظام غير صحيح: 1%",

    'cmd_server__admin_alias_not_found' => "يتعذر العثور على حساب إضافي للمسؤول.",

    'panel_branding__skins_already_exists' => "ملاحظة: النسق '\\1%'\\ موجود بالفعل. سيتم استبداله بالنُسُق الذي تقوم بتثبيته حاليًا.",
    'panel_branding__skins_file_exists' => "يتعذر إنشاء دليل للنُسُق '\\1%'\\: يوجد ملف بهذا الاسم بالفعل.",

    'actionlog__login_failed' => 'فشل في تسجيل الدخول',
    'actionlog__event_cp_user_login_failed' => 'فشل مستخدم Plesk في تسجيل الدخول',
    'actionlog__api_login_failed' => 'فشل تسجيل الدخول من خلال واجهة برمجة التطبيقات',
    'actionlog__event_cp_user_api_login_failed' => 'فشل مستخدم Plesk في تسجيل الدخول من خلال واجهة برمجة التطبيقات',
    'actionlog__pw_reset' => 'إعادة تعيين كلمة المرور المطلوبة',

    'ch_pass_by_secret__email_subject' => "تذكير كلمة مرور Plesk",
    'ch_pass_by_secret__email_body' => "مرحبًا %2، لإعداد كلمة مرور جديدة، اتبع الارتباط: %1 تسجيل دخولك: %3",
    'ch_pass_by_secret__message_send_error' => 'يتعذر إرسال الرمز السري: 1%',
    'ch_pass_by_secret__title' => 'تغيير كلمة المرور',
    'ch_pass_by_secret__secret' => 'الرمز السري',

    'custom_button__noframe' => "عدم استخدام الإطارات",

    'custom_button__internal_hint' => 'تحديد فتح عنوان URL إما على صفحة Plesk أو في نافذة مستعرض جديدة.',
    'custom_button__noframe_hint' => 'إذا أضفت زرًا مخصصًا يؤدي إلى امتداد Plesk أو إلى أحد التطبيقات في "لوحة العميل"، فستتمكن من تحديد كيفية عرض هذا الامتداد/التطبيق: في إطار أو كجزء من واجهة المستخدم الرسومية لـ Plesk.',


    'actionlog__patch' => 'تحديث',
    'actionlog__patch_available' => 'متوفر',
    'actionlog__event_patch_available' => 'التحديث متوفر',
    'actionlog__patch_installed' => 'مثبّت',
    'actionlog__event_patch_installed' => 'تم تثبيت التحديث',

    'actionlog__extension' => 'الملحق',
    'actionlog__extension_status' => 'حالة الملحق',
    'actionlog__cloning' => 'استنساخ الخادم',
    'actionlog__cloning_complete' => 'اكتمل',
    'actionlog__event_cloning_complete' => 'اكتمل استنساخ الخادم',

    'actionlog__ssl_web_binding' => 'شهادة SSL/TLS على النطاق',
    'actionlog__ssl_web_binding_update' => 'مُعيّنة/غير مُعيّنة',
    'actionlog__event_ssl_web_binding_update' => 'تم تعيين/لم يتم تعيين شهادة SSL/TLS على النطاق',

    'actionlog__ssl_web_mail_binding' => 'شهادة SSL/TLS على بريد الويب',
    'actionlog__ssl_web_mail_binding_update' => 'مُعيّنة/غير مُعيّنة',
    'actionlog__event_ssl_web_mail_binding_update' => 'شهادة SSL/TLS على لبريد الويب معيّنة/غير معيّنة',

    'actionlog__ssl_mail_binding' => 'شهادة SSL/TLS على خادم البريد',
    'actionlog__ssl_mail_binding_update' => 'مُعيّنة/غير مُعيّنة',
    'actionlog__event_ssl_mail_binding_update' => 'شهادة SSL/TLS على خادم البريد مُعيّنة/غير معيّنة',

    'actionlog__ssl_panel_binding' => 'شهادة SSL/TLS على منصة Plesk',
    'actionlog__ssl_panel_binding_update' => 'مُعيّنة/غير مُعيّنة',
    'actionlog__event_ssl_panel_binding_update' => 'شهادة SSL/TLS على Plesk معيّنة/غير معيّنة',

    'actionlog__hostname' => 'اسم مضيف الخادم',
    'actionlog__hostname_changed' => 'تم تغييره',

    'actionlog__event_mail_management_status_update' => 'تحديث حالة إدارة البريد',
    'actionlog__mail_management' => 'حالة إدارة البريد',
    'actionlog__mail_management_status_update' => 'تم التحديث',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'الإجمالي حسب المجالات',

    'chk_js__warning_about_admin_passwd_syntax' => "لا تستخدم علامة الاقتباس والمسافات والفاصلة المنقوطة ورموز الأبجدية القومية في كلمة المرور. يجب أن يكون طول كلمة المرور بين 1% و2% رمزًا، كما يجب ألا تحتوي على اسم المستخدم.",

    'passwordSecurityLevelCheckFailed' => 'كلمة المرور الخاصة بك ليست صعبة بما يكفي. وفقًا لسياسة الخادم، فإن الحد الأدنى لقوة كلمة المرور هو 1%. لتحسين قوة كلمة المرور، استخدم الأرقام، والأحرف الكبيرة والصغيرة، وأحرفًا خاصة مثل !، @،#،%،^،&،*،؟،_،~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'ضعيفة جدًا',
    'passwordSecurityLevelCheckFailedWeak' => 'ضعيفة',
    'passwordSecurityLevelCheckFailedMediocre' => 'متوسط',
    'passwordSecurityLevelCheckFailedStrong' => 'قوي',
    'passwordSecurityLevelCheckFailedStronger' => 'قوية جدًا',

    'cu__php_settings__command_update_all' => "تحديث إعدادات PHP لكل مجال لجميع المجالات بالتوافق مع ملف php.ini الخاص بالخادم.",
    'cu__php_settings__update_all_done' => "تم تحديث إعدادات PHP لكل مجال لجميع المجالات بنجاح.",

    'filemanager__invalid_path' => "تم تحديد مسار غير صالح",

    'ui__client/domain/dns/sync__description' => 'تطبيق التغييرات من قالب DNS الخاص بالخادم على المنطقة.',
    'ui__client/domain/dns/sync__disabled-warning' => 'يتعذر تطبيق التغييرات الخاصة بقالب DNS على المنطقة لأنه يتم توفيرها عن طريق خادم DNS آخر.',
    'ui__client/domain/dns/sync__short-title' => 'تطبيق تغييرات قالب DNS',
    'ui__client/domain/dns/sync__done' => 'تم تطبيق التغييرات من قالب DNS بنجاح على المنطقة.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'تطبيق التغييرات من قالب DNS الخاص بالخادم على المنطقة.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'يتعذر تطبيق التغييرات الخاصة بقالب DNS على المنطقة لأنه يتم توفيرها عن طريق خادم DNS آخر.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'تطبيق تغييرات قالب DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'تم تطبيق التغييرات من قالب DNS بنجاح على المنطقة.',
    'dns__dns_zone_sync_form' => 'تطبيق تغييرات قالب DNS',
    'dns__dns_zone_sync_legend' => 'خيارات',
    'dns__dns_zone_sync_ways' => 'اختر أيًا مما يلي',
    'dns__dns_zone_sync_way_safe' => 'تطبيق التغييرات على المناطق التي لم يحدث لها تعديل. إذا تم تخصيص منطقة معينة (سجلات جديدة تمت إضافتها أو أخرى موجودة تم تغييرها)، فلن يطبق Plesk التغييرات من القالب على تلك المناطق.',
    'dns__dns_zone_sync_way_forced' => 'تطبيق التغييرات على جميع المناطق. سيطبق Plesk التغييرات من القالب على جميع مناطق DNS ويشمل ذلك المناطق المخصصة. لاحظ أن السجلات المعدلة بواسطة المستخدم تظل كما هي. على سبيل المثال، إذا كان القالب يتضمن سجلاً جديدًا تمت إضافته بالفعل عن طريق أحد العملاء، فسيحتفظ Plesk بسجل العميل.',
    'dns__dns_default_ipv4_modified' => 'سيتم اعتبار السجلات التي تستخدم عنوان IP هذا كسجلات معدلة من قِبل المستخدم ولن تتزامن مع قالب DNS الخاص بالخادم.',
    'dns__dns_default_ipv6_modified' => 'سيتم اعتبار السجلات التي تستخدم عنوان IP هذا كسجلات معدلة من قِبل المستخدم ولن تتزامن مع قالب DNS الخاص بالخادم.',

    'dns__view_dns_record_master_title' => 'عرض سجلات المورد',
    'dns__view_dns_record_off_title' => 'عرض سجلات خادم الاسم',
    'dns__view_dns_record_slave_title' => 'عرض سجلات خادم DNS الأساسي',

    'dns_unable_to_resolve_hostname' => "يتعذر حل الاسم المضيف \"%1\": يتأكد 2% من أنه تم إعداد أ\nداة حل DNS لنظام التشغيل وأنه يعمل بصورة صحيحة.",

    'no_database_server_available' => 'لا توجد خوادم قاعدة بيانات متوفرة لهذا الاشتراك.',

    'database_used_by_application_can_not_be_moved' => 'يتعذر نقل قاعدة البيانات: يستخدم تطبيق موقع الويب قاعدة البيانات هذه.',
    'database_user_update_orphaned_is_restricted' => 'يُحظر تحديث حسابات مستخدم قاعدة بيانات معزولة. يمكنك حذفها أو إصلاحها فقط.',

    'database_unable_to_get_max_filesize_default_message' => 'يتعذر تحديد الحد الأقصى لحجم الملف الخاص بقاعدة البيانات: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'يتعذر تعيين الحد الأقصى لحجم الملف الخاص بقاعدة البيانات: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'يتعذر تحديد الحد الأقصى لحجم ملف السجل الخاص بقاعدة البيانات: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'يتعذر تعيين الحد الأقصى لحجم ملف السجل الخاص بقاعدة البيانات: \'%1\'',

    'database_unable_to_get_max_filesize' => 'يتعذر تحديد الحد الحالي على حجم الملف لقاعدة بيانات Microsoft SQL وهي \'%1\'. لا يمكن تعيين حد جديد.',
    'database_unable_to_set_max_filesize' => 'يتعذر تحديد حد لحجم الملف لقاعدة بيانات Microsoft SQL وهي \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'يتعذر تحديد الحد الحالي على حجم ملف السجل لقاعدة بيانات Microsoft SQL وهي \'%1\'. لا يمكن تعيين حد جديد.',
    'database_unable_to_set_max_log_filesize' => 'يتعذر تعيين حد لحجم ملف السجل لقاعدة بيانات Microsoft SQL وهي \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'يتعذر إنشاء قاعدة بيانات Microsoft SQL وهي \'%1\': إن حجم الملف الخاص بها أكبر من الحد الأقصى للحجم المسموح به.',
    'database_unable_to_move_because_max_filesize' => 'يتعذر نقل قاعدة بيانات Microsoft SQL وهي \'%1\': إن حجم الملف الخاص بها أكبر من الحد الأقصى للحجم المسموح به: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'يتعذر إنشاء قاعدة بيانات Microsoft SQL وهي \'%1\': إن حجم ملف السجل الخاص بها أكبر من الحد الأقصى للحجم المسموح به.',
    'database_unable_to_move_because_max_log_filesize' => 'يتعذر نقل قاعدة بيانات Microsoft SQL وهي \'%1\': إن حجم ملف السجل الخاص بها أكبر من الحد الأقصى للحجم المسموح به: %2.',
    'database_unable_to_restore_because_max_filesize' => 'تتعذر استعادة قاعدة بيانات Microsoft SQL وهي\'%1\': إن حجم الملف الخاص بها أكبر من الحد الأقصى للحجم المسموح به.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'يوجد خادم MS SQL مطابق ومسجل بالفعل في Plesk. يُرجى تحديد خادم MS SQL كآلية وصول.',
    'database_server__mssql_server_registered_as_sandbox' => 'يوجد خادم MS SQL له آلية وصول متطابقة ومسجل بالفعل في Plesk. يُرجى تحديد خادم MS SQL كآلية وصول.',

    'database_server_mysql_unable_to_connect_via_cli' => 'يتعذر الاتصال بالخادم عبر \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'الميزة 1% غير معتمدة من قِبل عُقد الخدمة التالية: %2. سيتم تعطيل هذه الميزة بالنسبة إلى جميع الكائنات التي تم إنشاؤها على هذه العُقد.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'الميزة 1% غير معتمدة من قِبل هذا الخادم. سيتم تعطيل هذه الميزة بالنسبة إلى جميع الكائنات المستعادة.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'المكون 1% غير مثبت. لن يكون متوفرًا لمواقع الويب التالية: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'المكون 1% غير مثبت. سيتم استبداله بـ 2% لمواقع الويب التالية: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'إن إصدار Plesk الحالي لا يدعم أسماء المستخدمين التي تتضمن النقطة (.). ستتم استعادة العملاء وبائعي التجزئة أصحاب مثل تلك الأسماء.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'يتعذر العثور على ملف النسخ الاحتياطي الذي يتضمن بيانات خاصة بـ 1% 2%. لن تتم استعادة البيانات الخاصة بـ 1% 2%.',

    'bu_conflict_resolver_zone_master_removed' => "تتعذر استعادة سجل DNS الرئيسي: يشير السجل في المناطق التابعة إلى عنوان IP الموجود وهو 1%. ستتم إزالة سجل DNS الرئيسي من المنطقة التابعة.",

    'bu_conflict_resolver_not_available_scripting' => 'إن 1% غير مدعوم.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => 'إن 1% غير مدعوم. لن يكون متوفرًا لمواقع الويب التالية: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'المكون 1% غير مثبت.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'لن يكون متوفرًا لعُقد الخدمة التالية: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'لن يكون متوفرًا للكائنات التالية: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'قواعد البيانات التالية غير متوفرة على هذا الخادم: 1%.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'تم تخزين ملف النسخ الاحتياطي لقاعدة بيانات MS SQL في تنسيق MS SQL أصلي، والذي يمكن استعادته إلى خادم MS SQL المحلي فقط أو إلى خادم MS SQL البعيد مع إعدادات النسخ الاحتياطي المكونة بشكل كامل. لم تتم استعادة بعض قواعد البيانات الخاصة بك بسبب عدم وجود خادم MS SQL مناسب مسجل في Plesk. لقد تأثرت المجالات التالية: {{objects}}. يُرجى الاتصال بموفر خدمة الاستضافة.',

    'bu_conflict_resolver_not_available_webmail' => 'خدمة بريد الويب 1% غير متوفرة. سيتم استبدالها بـ 2% للكائنات التالية: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'خدمة بريد الويب 1% غير متوفرة. سيتم استبدالها بـ 2% لخطط الخدمة التالية: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "لا تدعم قواعد البيانات من النوع  '1%' أسماء مستخدم الدعم المتطابقة مع أسماء قواعد البيانات. ستتم إعادة تسمية المستخدم  '2%' بالاسم  '3%' لقاعدة البيانات  '4%'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'لم يتم تعيين الحد الخاص باستخدام مساحة القرص في تكوين خادم الوجهة. سيتم تغيير قيمة هذا الإعداد إلى "غير محدود".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'لم يتم تعيين الحد الخاص برقم الاتصالات في تكوين خادم الوجهة. سيتم تغيير قيمة هذا الإعداد إلى "غير محدود".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'لم يتم تعيين الحد الخاص باستخدام حركة مرور البيانات في تكوين خادم الوجهة. سيتم تغيير قيمة هذا الإعداد إلى "غير محدود".',
    'cu__pleskrestore_backup_file_extracted' => 'تم استخراج ملف النسخ الاحتياطي إلى "1%".',
    '__mod_bw_not_supported' => 'الوحدة النمطية mod_bw لخادم الويب Apache غير معتمدة بسبب تكوين نظام الملف. لن تعمل القيود على استخدام حركة مرور البيانات والحد الأقصى لعدد الاتصالات.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'دعم تخويل POP3 لترحيل البريد غير مدعوم، وسيتم استخدام POP3 قبل ترخيص SMTP بدلاً من ذلك. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'خطة الخدمة  \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => 'إن 1% غير مدعوم. سيتم استبدالها بـ 2% لخطط الخدمة التالية: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => 'إن 1% غير مدعوم. سيتم استبداله بـ 2% لمواقع الويب التالية: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'لم يتم العثور على الكائنات التالية في ملف النسخ الاحتياطي: 1%',
    'bu_conflict_resolver_absent_domains' => 'لا يمكن استعادة بعض الكائنات لأنها تنتمي إلى المجالات التالية غير الموجودة في Plesk: 1%',
    'bu_conflict_resolver_absent_parent_domains' => "لا يمكن استعادة بعض مواقع الويب لأنها تنتمي إلى المجالات الأصلية التالية غير الموجودة في Plesk: 1%",
    'bu_conflict_resolver_dns_not_supported' => 'تتعذر استعادة مناطق DNS: تم إيقاف تشغيل خدمة DNS في تكوين الخدمة.',
    'bu_conflict_resolver_mail_not_supported' => 'تتعذر استعادة علب البريد: تم إيقاف تشغيل خدمة البريد في تكوين الخادم.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'إن مهلة حالة الخمول المحددة غير معتمدة من قِبل خادم الويب IIS. ستتم إعادة تعيين القيمة إلى 1%.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'إن إجراء الحد المخصص لـ CPU غير معتمد من قِبل خادم الويب IIS. ستتم إعادة تعيين القيمة إلى 1%.',
    'bu_conflict_detector_server_ssl_cert_name' => 'شهادة SSL/TLS خادم %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'شهادة SSL/TLS %2 للنطاق %1',
    'bu_conflict_detector_ssl_cert_name' => 'شهادة SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'لا يمكن استعادة محتويات الكائنات التالية لأن الكائنات غير موجودة في Plesk: 1%',
    'bu_conflict_resolver_absent_objects_mailuser' => 'لا يمكن استعادة محتويات علب البريد التالية لأن علب البريد غير موجودة في Plesk: 1%',
    'bu_conflict_resolver_absent_objects_maillist' => 'لا يمكن استعادة قوائم المراسلة التالية لأن قوائم المراسلة غير موجودة في Plesk: 1%',
    'bu_conflict_resolver_absent_objects_database' => 'لا يمكن استعادة محتويات قواعد البيانات التالية لأن قواعد البيانات غير موجودة في Plesk: 1%',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'فشلت استعادة التطبيق "%1" على "%2" حيث هناك تطبيق آخر مثبّت بالفعل على "%3". يمكنك إزالة التطبيق المثبّت والمحاولة مرة أخرى.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'وظيفة الرد التلقائي على البريد غير مدعومة.',
    'bu_conflict_resolver_not_available_mail_content' => 'عملية استعادة محتوى البريد غير مدعومة.',
    'bu_conflict_resolver_invalid_mail_name' => 'لم تتم استعادة صناديق البريد التالية نظرًا لتمكين العنوان الفرعي للبريد الإلكتروني ولأن بعض عناوين البريد الإلكتروني تحتوي على العلامة "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'لم تتم استعادة المستخدمين التالين نظرًا لتمكين العنوان الفرعي للبريد الإلكتروني ولأن بعض عناوين البريد الإلكتروني تحتوي على العلامة "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'انتهت صلاحية التراخيص التالية ولن يتم استعادتها: {{objects}}',
    'expiration_unsupported' => "إن الحد 'expiration'غير مدعوم.",

    'component_name__dbconnector' => "موصل قاعدة البيانات",
    'component_name__mysqlserver' => 'خادم MySQL',
    'component_name__troubleshooting' => 'استكشاف الأخطاء وإصلاحها',

    '__subscription_has_no_license_key' => 'يتم توفير موارد الاشتراك بواسطة عقدة الخدمة1%# والتي ليس لها مفتاح ترخيص ذو صلة.',
    '__subscription_has_expired_license_key' => 'يتم توفير موارد الاشتراك بواسطة عقدة الخدمة 1%# التي قد انتهت صلاحية مفتاح الترخيص الخاص بها وهو 2%.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> يتعذر حفظ ملفات التكوين',
    '__cfgmonConfigurationFileSaveErrorBody' => "يتعذر حفظ بعض ملفات التكوين على المضيف <%%host%%>: وقعت الأخطاء التالية: %%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'يتيح هذا الخيار إمكانية تكوين عناوين البريد الإلكتروني بنمط VERP لقوائم البريد',
    'mail__enter_right_ip_mask' => "أدخل قناع IP بين 1 و32",
    'mail__enter_right_ip_mask_24' => "أدخل قناع IP بين 24 و32",
    'mail__invalid_dom_name' => "اسم المجال %1 غير صالح.",
    'mail__invalid_pop_lock_time' => "وقت قفل POP3 غير صالح.",
    'mail__invalid_rbl_server' => "اسم منطقة DNS غير صالح.",
    'mail__total_files_size' => "المساحة الكلية للمستودع: 1%",
    'mail__filename_already_in_repository' => "يوجد ملف بنفس الاسم بالفعل في المستودع",
    'mail__no_white_list_mask_feature_24' => "استخدم قيمة قناع 24 أو أعلى. لا يدعم خادم البريد أقنعة الإعداد. يمكننا محاكاة قناع الإعداد فقط للقيم التي لا تقل عن 24.",
    'mail__unable_add_new_mail_name' => "تعذر إضافة حساب البريد: %1",
    'mail_server_is_not_installed' => 'خادم البريد (Postfix أو Qmail) غير مثبت. قم بتثبيته لمواصلة العمل.',
    'mail_server_not_available' => 'لا توجد خوادم بريد مدعومة متوفرة في عقدة الخدمة.',
    '__not_installed' => '(غير مثبت)',
    'mail__service_node_outgoing_messages_is_disabled' => 'تصفية البريد العشوائي على رسائل البريد الإلكتروني الصادرة معطلة.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'إن عقدة الخدمة لا تدعم تحديد عدد رسائل البريد الإلكتروني الصادرة من أحد المجالات فيما يخص المجال 1%.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'إن عقدة الخدمة لا تدعم تحديد عدد رسائل البريد الإلكتروني الصادرة من علبة بريد معينة فيما يخص المجال 1%.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'حدد عنوانًا من نوع واحد على الأقل (IPv4 أو IPv6).',

    'mail__outgoing_email_mode_invalid' => 'تم تحديد وضع بريد صادر غير صالح.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'تم تحديد عنوان IPv4 غير صالح.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'تم تحديد عنوان IPv6 غير صالح.',
    'mail__outgoing_email_mode_unavailable' => 'إن تغيير وضع البريد الصادر غير مدعوم، ربما لأن خادم بريد Postfix غير مثبت على هذا الخادم.',

    'mail__autoresponder_attachment_not_supported' => 'لا يدعم خادم البريد المستخدَم حاليًا إدارة مرفقات المجيب التلقائي.',

    'mail__smtp_white_list_not_supported' => 'لا يدعم خادم البريد المُستخدَم حاليًا القائمة البيضاء لعناوين IP.',
    'mail__smtp_whitelist_cidr_not_supported' => 'لا يدعم خادم البريد المحدد حاليًا أقنعة CIDR. حدد عنوان IP بالتنسيق "192.*.0.*".',
    'mail__smtp_whitelist_mask_not_supported' => 'لا يدعم خادم البريد المحدد حاليًا أنماط عنوان IP لأحرف البدل. حدد عنوان IP بتنسيق "192.0.0.0/8".',

    'sfdk_server_wide_verify_failed' => 'يتعذر تغيير الإعدادات الخاصة بخدمة التحقق باستخدام آلية DKIM',

    'sfdk_domain__serverwide_disabled' => 'إيقاف التشغيل وفقًا لسياسة الخادم',
    'feature__domainkeys__serverwide_disabled' => 'تم إيقاف تشغيل نظام الحماية من البريد العشوائي بآلية DKIM على نطاق الخادم',

    'defaultcomponents__error_set_default' => 'يتعذر تعيين 1% كـ 2% الافتراضي',
    'defaultcomponents__required_package_not_default' => 'إن المكون 1% المطلوب لعمله ليس هو المكون الافتراضي.',

    '__percentage' => '%',
    '__seconds' => 'ثوانٍ',
    '__resource_remain' => 'متبقٍ',

    '__not_registered' => '(غير مسجل)',
    '__php_handler_id' => 'إصدار PHP',
    '__php_handler_id_string' => 'PHP %1 ‏(%2)',
    '__php_handler_not_registered' => 'إن معالج PHP وهو "1%" غير مسجل. من المحتمل أن يكون قد حُذف من الخادم. قم بتسجيل المعالج بالخصائص نفسها ثم حاول مجددًا.',
    '__php_handler_not_registered_on_domain' => 'المجال "1%": إن معالج PHP وهو "2%" غير مسجل. من المحتمل أن يكون قد حُذف من الخادم. قم بتسجيل المعالج بالخصائص نفسها ثم حاول مجددًا.',
    '__php_fpm_handler' => 'تطبيق FPM',
    '__php_fpm-dedicated_handler' => 'تطبيق FPM المخصص',

    'mailname_create_assigned_user_dublicate_error' => 'يتعذر إنشاء مستخدم لعلبة البريد. المستخدم صاحب اسم المستخدم 1% موجود بالفعل ويمتلك علبة بريد أخرى.',
    'mailname_create_assigned_user_role_absent_error' => 'يتعذر إنشاء مستخدم لعلبة البريد. الدور الافتراضي 1% للمستخدم غير موجود.',

    'gphd__mime_types' => 'أنواع MIME',
    'gphd__handlers' => 'معالجات Apache',
    'gphd__ip_restrictions_allow' => 'السماح بالوصول إلى الموقع للحصول على المضيفين والشبكات المحددين (باستثناء ما تم رفضه)',
    'gphd__ip_restrictions_deny' => 'رفض الوصول إلى الموقع للحصول على المضيفين والشبكات المحددين',
    'gphd__directory_index' => 'ملفات الفهرس',
    'gphd__nginx_transparent_mode' => 'الوضع عندما يعالج Apache كلاً من المحتوى الثابت والديناميكي، بينما يمرر nginx طلبات HTTP والردود فقط بدون تعديل.',
    'gphd__nginx_serve_static' => 'تقديم ملفات ثابتة مباشرة عن طريق nginx',
    'gphd__nginx_static_extensions' => 'امتدادات الملفات الثابتة والتي يجب أن تتم معالجتها بواسطة nginx',
    'gphd__nginx_serve_php' => 'معالجة ملفات PHP بواسطة nginx',
    'gphd__www_root' => '‫دليل جذر WWW‬',

    'eol__none' => 'عدم التعديل',
    'eol__lf' => 'التحويل إلى نمط Unix',
    'eol__cr' => 'التحويل إلى نمط MacOS',
    'eol__crlf' => 'التحويل إلى نمط Windows',

    'ui__dns_bad_zone' => 'منطقة غير متسقة "1%":',
    'ui__dns_ns_has_no_address_records' => 'السجل NS لـ "1%" لا يتضمن سجلات عنوان (A أو AAAA).',
    '__dns_bad_zone' => 'منطقة غير متسقة "1%":',
    '__dns_ns_has_no_address_records' => 'السجل NS لـ "1%" لا يتضمن سجلات عنوان (A أو AAAA).',
    '__dns_ptr_is_wildcard' => 'سجل PTR وهو "1%" غير صالح: يشير السجل إلى مجال حرف بدل.',

    'firewall_database_user_remote_access_rule_name' => 'يتيح [1%][2%] إمكانية الوصول عن بُعد لمستخدم قاعدة البيانات \'\\3%\'\\ للعميل\'\\4%\'\\',
    'firewall_database_user_remote_access_rule_name_removed' => '[1%][2%] 3%',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'يتعذر السماح بالاتصالات البعيدة لمستخدم قاعدة البيانات\'\\1%\'\\: يتعذر تحديد رقم منفذ TCP المُستخدم من قِبل خادم Microsoft SQL وهو \'\\2%\'\\. الأسباب المحتملة هي ما يلي: عدم تمكين بروتوكول TCP/IP في تكوين شبكة الخادم أو تكوين الخادم لاستخدام منافذ TCP الديناميكية. تكوين الخادم للتثبيت على منفذ TCP ثابت ومحاولة السماح بالاتصالات البعيدة مجددًا.',

    'command__convertResellerHasCustomer' => 'يتضمن حساب بائع التجزئة \'\\1%\'\\ أحد حسابات العميل أو أكثر. لتحويل حساب بائع التجزئة هذا إلى حساب عميل، قم أولاً بنقل حسابات العميل هذا إلى مالك جديد أو قم بتحويلها إلى حسابات بائع التجزئة.',
    'command__convertResellerNotReseller' => 'يمكن تحويل حسابات بائع التجزئة فقط إلى حسابات العميل. إن \'\\1%\'\\ ليس بائع تجزئة.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'يتعذر مزامنة الاشتراك مع خطة الخدمة. تتعارض الإعدادات التالية للاشتراك مع خطة الخدمة: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'الحساب \'\\1%\'\\ هو حساب بائع تجزئة. لا يمكن نقل حسابات بائع التجزئة إلى مالك جديد لأنها ملك لمسؤول الخادم.',
    'moveCustomer__wrong_owner_type' => "يمكن نقل حساب العميل '\\\\1%'\\\\ إلى بائع تجزئة أو مسؤول فقط، وليس إلى عميل آخر.",
    'moveCustomer__customer_already_belongs_to_owner' => 'حساب العميل \'\\1%\'\\ ينتمي بالفعل إلى المالك المحدد.',
    'upgradeClient__user_is_admin' => 'لا يمكن تحويل الحساب \'\\1%\'\\ إلى حساب بائع تجزئة لأنه حساب مسؤول.',

    'mail__error_setting_max_connections_courier' => 'يتعذر تعيين العدد الأقصى للاتصالات (IMAP، أو POP3، أو IMAP عبر SSL/TLS، أو POP3 عبر SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'يتعذر تعيين العدد الأقصى للاتصالات (IMAP، أو POP3، أو IMAP عبر SSL/TLS، أو POP3 عبر SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'يتعذر تعيين العدد الأقصى للاتصالات (IMAP، أو POP3، أو IMAP عبر SSL/TLS، أو POP3 عبر SSL/TLS) لكل عنوان IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'يتعذر تعيين العدد الأقصى للاتصالات (IMAP، أو POP3، أو IMAP عبر SSL/TLS، أو POP3 عبر SSL/TLS) لكل عنوان IP لمستخدم بريد محدد: %1',
    'outgoing_messages_limit_value_invalid' => 'يجب أن تكون القيمة ضِمن النطاق %MIN%%..%%MAX%%. يمكن لمسؤول Plesk فقط تعديل هذا الإعداد.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "تستخدم المجالات التالية عناوين بريد إلكتروني خارجية من أجل إعادة توجيه البريد المُرسل إلى عناوين غير موجودة. لن يتم احتساب الرسائل المرسلة إلى هذه العناوين في التحكم في البريد الصادر: 1%",
    'outgoing_messages_white_list_not_empty' => 'لن تعمل القيود على البريد الصادر بالنسبة إلى مُرسلي البريد الذين توجد عناوين IP الخاصة بهم في القائمة البيضاء لخادم البريد. على سبيل المثال، في حالة وجود مضيف محلي (127.0.0.0 / 8، ::1 / 128) في القائمة البيضاء، سيتم إرسال جميع رسائل البريد الإلكتروني من الخادم المحلي بصرف النظر عن التقييدات. يمكن أن يستخدم مرسلو البريد إما عناوين IP المحلية (مواقع الويب والبرامج النصية المخصصة المستضافة على الخادم المحلي) أو العناوين الخارجية (العملاء الذين يرسلون البريد من عملاء البريد المثبتين على أجهزة الكمبيوتر أو الأجهزة المحمولة الخاصة بهم). لجعل القيود تعمل بالنسبة إلى جميع مرسلي البريد (كل من المحليين والخارجيين)، قم بإزالة جميع عناوين IP والشبكات من القائمة البيضاء. لاحظ أن إزالة المضيف المحلي (127.0.0.0 / 8، ::1 / 128) من القائمة البيضاء قد يعطل تشغيل مواقع الويب والبرامج النصية التي ترسل البريد من هذا الخادم. للحصول على تفاصيل حول التقييدات على البريد الصادر، راجع دليل المسؤول، والحماية من البريد العشوائي الخارجي.',
    'outgoing_messages_relay_open' => 'ترحيل البريد مفتوح: لن تعمل القيود على البريد الصادر.',

    'notification_aps_app_updates_available' => 'تتوفر التحديثات للتطبيقات التالية:',
    'notification_aps_app_updates_installed' => 'تم تثبيت التحديثات تلقائيًا للتطبيقات التالية:',
    'notification_aps_app_updates_requirements' => 'تتوفر التحديثات للتطبيقات التالية ولكن لا يمكن استبدالها لأن إعدادات الاستضافة لمواقع الويب المقابلة لا تلبي معايير التثبيت:',
    'notification_admin_aps_app_updates_available_item' => '(%%name%% (%%url%%. الإصدار المثبت: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_admin_aps_app_updates_available_plugin_item' => 'المكون الإضافي "%%name%%" على  (%%parentName%% (%%url%%. الإصدار المثبت: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_admin_aps_app_updates_available_theme_item' => 'السمة "%%name%%" على (%%parentName%% (%%url%%. الإصدار المثبت: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_reseller_aps_app_updates_available_item' => '(%%name%% (%%url%%. الإصدار المثبت: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'المكون الإضافي "%%name%%" على  (%%parentName%% (%%url%%. الإصدار المثبت: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_reseller_aps_app_updates_available_theme_item' => 'السمة "%%name%%" على (%%parentName%% (%%url%%. الإصدار المثبت: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_client_aps_app_updates_available_item' => '(%%name%% (%%url%%. الإصدار الموجود لديك: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_client_aps_app_updates_available_plugin_item' => 'المكون الإضافي "%%name%%" على  (%%parentName%% (%%url%%. الإصدار الموجود لديك: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_client_aps_app_updates_available_theme_item' => 'السمة "%%name%%" على (%%parentName%% (%%url%%. الإصدار الموجود لديك: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_admin_aps_app_updates_installed_item' => '(%%name%% (%%url%%. الإصدار الجديد: %%to%% الإصدار السابق: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '(%%name%% (%%url%%. الإصدار الجديد: %%to%% الإصدار السابق: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '(%%name%% (%%url%%. الإصدار الجديد: %%to%% الإصدار السابق: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '(%%name%% (%%url%%. الإصدار المثبت: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_reseller_aps_app_updates_requirements_item' => '(%%name%% (%%url%%. الإصدار المثبت: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_client_aps_app_updates_requirements_item' => '(%%name%% (%%url%%. الإصدار الموجود لديك: %%from%%. الإصدار المتوفر: %%to%%',
    'notification_aps_app_updates_no_installation_url' => 'تطبيق خارجي',

    'notification_outgoing_mail_exceeded_limits_domains' => 'المجالات',
    'notification_outgoing_mail_exceeded_limits_mails' => 'عناوين البريد الإلكتروني',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'اشتراكات',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '1% رسالة (رسائل) في الساعة',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'غير محدود',
    'notification_outgoing_mail_exceeded_limits_object' => '1%، الحد هو 2%',
    'notification_outgoing_mail_exceeded_limits_attempt' => '1% محاولة (محاولات) لتجاوز الحدود من 2% إلى 3%',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '1% محاولة (محاولات) لتجاوز الحدود من 2% حتى الآن',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "‫IP Address Banning (Fail2ban)‬",

    'backup__restore__capability_fail2ban_not_installed_text' => 'لم يتم تثبيت مكون Fail2ban على الخادم الوجهة.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Install Fail2ban. لاحظ أن ذلك قد يستغرق دقائق قليلة.',

    'plesk_key__no_reseller_support' => 'لا يمكنك إدارة بائعي التجزئة بسبب القيود على الترخيص.',
    'plesk_key__no_customers_support' => 'لا يمكنك إدارة العملاء بسبب القيود على الترخيص.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'يتعذر التبديل إلى طريقة عرض موفر الخدمة بسبب القيود على الترخيص.',
    'plesk_key__no_security_core_support' => 'ميزات الأمان الأساسية (ModSecurity وFail2Ban) غير متوفرة بسبب قيود الترخيص.',
    'plesk_key__outgoing-antispam' => 'التحكم في البريد الصادر',
    'plesk_key__security-core' => 'Security Core (ModSecurity and Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'إدارة الحسابات',
    'plesk_key__can-manage-subscriptions' => 'إدارة الاشتراكات',
    'plesk_key__can-manage-customers' => 'إدارة العملاء',
    'plesk_key__can-manage-resellers' => 'إدارة بائعي التجزئة',
    'plesk_key__can-manage-custom-view' => 'مدى توافر الوضع المقيد',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'إدارة بائعي الاشتراكات قيد إيقاف التشغيل ولكن يوجد لديك العديد من الاشتراكات (1%).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'إدارة بائعي التجزئة قيد إيقاف التشغيل ولكن يوجد لديك العديد من بائعي التجزئة (1%).',
    'plesk_key__limits_exceeded_no_customers_management' => '‫إدارة العملاء قيد إيقاف التشغيل ولكن يوجد لديك العديد من العملاء (1%).‬',
    'plesk_key__no_subscriptions_support' => 'لا يمكنك إدارة الاشتراكات بسبب القيود على الترخيص.',
    'plesk_key__no_custom_view_support' => 'لا يمكنك استخدام الوضع المقيد نظرًا للقيود المتعلقة بالترخيص.',
    'plesk_key__trial_forbidden_region' => 'عذرًا، منصة Plesk غير متاحة حاليًا في منطقتك.',
    'additional_key__main_key' => 'المفتاح هو المفتاح الرئيسي: لا يجوز لك تحميل مفتاح رئيسي كمفتاح إضافي.',

    'gch__hosting_waf_rule_engine' => 'وضع جدار الحماية لتطبيق الويب',

    'backup__fieldset__restoration_options' => 'خيارات الاستعادة',
    'backup__restore_options__restore' => 'استعادة',
    'backup__restore_options__domain__domain_configuration' => 'تكوين المجال',
    'backup__restore_options__domain__virtual_host_content' => 'محتوى المضيف الظاهري',
    'backup__restore_options__domain__mail' => 'بريد',
    'backup__restore_options__domain__databases' => 'قواعد البيانات',
    'backup__restore_options__client__client_configuration' => 'تكوين حساب العميل',
    'backup__restore_options__client__domains' => "المجالات الخاصة بالعميل",
    'backup__restore_options__reseller__reseller_configuration' => 'تكوين حساب بائع التجزئة',
    'backup__restore_options__reseller__personal_domains' => "المجالات الخاصة ببائع التجزئة",
    'backup__restore_options__reseller__clients' => "عملاء بائع التجزئة",
    'backup__restore_options__admin__server_configuration' => 'إعدادات الخادم',
    'backup__restore_options__admin__administrator_configuration' => 'تكوين حساب المسؤول',
    'backup__restore_options__admin__personal_domains' => "المجالات الخاصة بالمسؤول",
    'backup__restore_options__admin__personal_clients' => "عملاء المسؤول",
    'backup__restore_options__admin__resellers' => 'بائعو التجزئة',

    'badge_new' => 'جديد',
    'upgrade_php_on_subscription' => 'ترقية PHP في الاشتراك الخاص بك إلى الإصدار 5.3.0 أو الأحدث.',

    'pkey_notify__body_expiration_notification' => 'انتهت صلاحية مفتاح الترخيص. قد لا تتوفر بعض الميزات. يُرجى الاتصال بموفر خدمة الاستضافة.',

    'crontab__crontab_entry_exists' => "المهمة المجدولة موجودة بالفعل.",
    'crontab__crontab_entry_not_exists' => "المهمة المجدولة غير موجودة.",
    'crontab__invalid_values_found' => "قيم المعلمة غير صحيحة.",
    'crontab__cmd_max_len' => "لا يمكن أن يكون الأمر أكثر من 1% حرفًا.",

    'domain__domain_exists' => "يوجد مجال يتضمن البادئة '\\www'\\ والاسم نفسه: 1%.2%.",
    'domain__subdomain_exists' => "يوجد مجال فرعي يتضمن البادئة  '\\www'\\ والاسم نفسه: 1%.2%.",
    'domain__dalias_exists' => "يوجد اسم مستعار للمجال يتضمن البادئة '\\www'\\ والاسم نفسه: 1%.2%.",
    'domain__record_exists' => "يوجد سجل DNS يشير إلى المضيف 1%.2%.",

    'ip_addr__cannot_assign_certificate' => "لا يمكن تعيين الشهادة '\\1%'\\ كشهادة افتراضية: المفتاح الخاص مفقود.",
    'ip_addr__update_dns_error' => '‫المشكلات التي حدثت أثناء تحديث عنوان IP في مناطق DNS.‬ %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'يتعذر إضافة عنوان IP. تحصل واجهة الشبكة هذه على عناوين IP تلقائيًا.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'يتعذر إزالة عنوان IP %1. تحصل واجهة الشبكة هذه على عناوين IP تلقائيًا.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'يتعذر إصلاح عنوان IP %1. تحصل واجهة الشبكة هذه على عناوين IP تلقائيًا.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'يتعذر تغيير واجهة عنوان IP %1 نظرًا لحصول واجهة الشبكة %2 على عناوين IP تلقائيًا.',

    'shm_lmsg__limit_for_resource_exceeded' => 'تم تجاوز حد الاشتراكات على عدد %%type%%. الحد هو %%limit%% و%%usage%% قيد الاستخدام حاليًا.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'لا يُسمح بإنشاء %%type%% لهذا الاشتراك.',
    'shm_lmsg__resource_title__db-mysql' => 'قواعد بيانات MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'قواعد بيانات MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'قواعد بيانات PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'مستخدمو قاعدة البيانات',
    'shm_lmsg__resource_title__iis-application-pool' => 'تجمعات تطبيق IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'حسابات FTP الإضافية',

    'db_user_unable_remove_mysql_global_privileges' => 'تتعذر إزالة امتيازات MySQL العامة لمستخدم قاعدة البيانات %1. السبب: %2',
    'report__client_description' => 'الوصف',

    'db__user_role_error' => 'تم تحديد دور مستخدم قاعدة بيانات غير صحيح: 1%. يُرجى اختيار أحد الأدوار التالية: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'يتعذر تعيين حد حجم الملف لقواعد بيانات خادم Microsoft SQL التالية لأنها تحتوي على حجم ملف أكبر: 1%.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'يتعذر تعيين حد حجم ملف السجل لقواعد بيانات خادم Microsoft SQL التالية؛ لأنها تحتوي على حجم ملف سجل أكبر: 1%.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'يتعذر إعداد عنوان IP عام: يجب أن يوجد عنوان IP خاص.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'يتعذر إعداد عنوان IPv4 عام للعنوان IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'يتعذر إعداد عنوان IPv6 عام للعنوان IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'يتعذر إعداد عنوان IP عام: عنوان IP غير صالح.',

    '__user_already_exists' => "المستخدم 1% موجود بالفعل.",
    '__user_name_is_empty' => "يُرجى تحديد اسم مستخدم.",

    'upgrade_php_on_domain' => 'يتعذر العثور على إصدار 5.3.0 أو إصدار أحدث من PHP في أيِ من مجالات WordPress. حاول ترقية PHP.',

    'component_name__waf' => 'جدار حماية تطبيق الويب',
    'component_name__vcs' => '‫نظام التحكم في الإصدار‬',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'تم اكتشاف محاولة انتحال محتملة: حاول الرابط عرض محتوى غير متعلق.',
    'forceResetPasswordUpdated' => 'تم تغيير كلمة مرورك. استخدم كلمة المرور الجديدة لتسجيل الدخول إلى منصة Plesk.',

    'php_handlers_error_no_available_instance' => '‫يتعذر إنشاء مجال: لا توجد معالجات PHP متوفرة.‬',
    'domain_error_unable_to_apply_hosting_settings' => '‫يتعذر تطبيق إعدادات الاستضافة: 1%‬',

    'plesk_not_configured' => '‫خدمة Plesk غير مُكوّنة.‬ ‫انتقل إلى لوحة التحكم لإجراء تكوين ما بعد التثبيت.‬',
    'cmd_mail__mail_password_duplicated' => '‫الزوج المحدد من عنوان البريد الإلكتروني وكلمة المرور موجود بالفعل على خادم البريد.‬ ‫يُرجى تحديد عنوان بريد إلكتروني أو كلمة مرور آخرين.‬',

    'extensionRequirementOs' => 'نظام التشغيل (1%) غير مدعوم بواسطة الحزمة.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 هو الإصدار الأقدم المدعوم بواسطة الحزمة.',
    'extensionRequirementPleskMaxVersion' => 'الإصدارات بداية من Plesk %1 غير مدعومة بواسطة الحزمة.',
    'extensionBlacklisted' => 'الامتداد 1% غير مسموح به للتثبيت.',
    'extensionDisabled' => 'تم تعطيل الملحق.',


    'optimization_settings__unable_set_mpm_event' => 'يتعذر تعيين وضع mpm_event: إنه يقتضي إيقاف تشغيل وحدة Apache PHP5، ولكن يتم استخدام هذه الوحدة بواسطة المجالات.',
    'optimization_settings__unable_turn_off_php' => 'يتعذر إيقاف تشغيل وحدة Apache PHP5: يتم استخدامها بواسطة المجالات.',

    'hst_def__fp_admin_login' =>  '‫اسم مستخدم FTP‬',
    'hst_def__fp_admin_passwd' =>  '‫كلمة مرور FTP‬',

    'database_user_orphaned_old_password_wrong' => "‫يتعذر إصلاح المستخدم المعزول '%1': كلمة المرور غير صحيحة.‬",
    'cannot_load_partner_central_property_key_no_exist' => "‫يتعذر استرداد الخصائص المخصصة: مفتاح الترخيص غير موجود.‬",
    'extensionScriptFailure' => "فشل تنفيذ %1 وظهرت الرسالة التالية: %3",
    '__ssl_redirect' => "إعادة التوجيه الدائم SEO-safe 301 من HTTP إلى HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'إدارة نظام الحماية باستخدام آلية DKIM غير معتمدة.',
    'mail__dmarc_not_supported' => 'لم يتم دعم إدارة DMARC.',
    'mail__relay_white_list_not_supported' => 'إدارة القائمة البيضاء للترحيل غير معتمدة.',
    'mail__black_list_not_supported' => 'إدارة القائمة السوداء غير معتمدة.',
    'mail__autoresponder_not_supported' => 'إدارة المستجيب التلقائي غير معتمدة.',
    'defaultcomponents__not_supported_version' => '(إصدار غير معتمد)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'لم يتم العثور على الشهادة \'%1\'.',
    'certificate__unable_setup_certificate' => 'يتعذر تثبيت الشهادة: المفتاح الخاص ومحتويات الشهادة غير موجودين.',
    'certificate__used_by_panel' => 'تُستخدَم إحدى الشهادات التي أنت على وشك حذفها لتأمين النظام الأساسي Plesk.',
    'certificate__used_by_mail_server' => 'تُستخدَم إحدى الشهادات التي أنت على وشك حذفها لتأمين خادم البريد.',
    'certificate__used_by_domain_service' => 'تُستخدَم إحدى الشهادات التي ستقوم بحذفها بواسطة خدمة النطاق.',
    'mail_server__not_installed' => 'يتعذر تثبيت الشهادة لخادم البريد نظرًا لعدم تثبيت خادم البريد.',

    'email_activation_mail_subject' => 'يرجى تفعيل حسابك في منصة Plesk',
    'email_activation_mail_body' => "تم إنشاء حساب على خادم منصة Plesk %1 تفاصيل الحساب: الاسم: %2 عنوان البريد الإلكتروني: %3 إذا كانت هذه المعلومات صحيحة وتم إنشاء الحساب لك، فيرجى تفعيله باستخدام الرابط التالي: %4 من خلال تفعيل الحساب، فإنك تفوض مالك الخادم بجمع بياناتك الشخصية (الاسم والبريد الإلكتروني) وتخزينها ومعالجتها واستخدامها لإنشاء حسابك ودعمه، وفقًا لقوانين حماية البيانات المعمول بها حاليًا، كجزء من العقد.",

    'backup_transport_permission_name' => 'نسبة %1 للإدارة',
    'backup_transport_permission_description' => 'يتيح استخدام نسبة %1 لتخزين النسخ الاحتياطية.',

    'domain_move_err_target_no_hosting' => 'يتعذر نقل النطاق إلى أي اشتراك دون الاستضافة.',
    'domain_move_err_already_in_target' => 'ينتمي النطاق بالفعل إلى الاشتراك المستهدف.',
    'domain_move_err_main_domain' => 'يتعذر نقل النطاق الرئيسي.',
    'domain_move_err_subdomain_without_parent' => 'يتعذر نقل النطاق الفرعي %1 دون النطاق الأصلي %2.',
    'domain_move_err_root_exists' => 'المسار المستهدف لـ www_root %1 موجود بالفعل.',
    'domain_move_err_nested_roots' => 'يتعذر نقل النطاق نظرًا لأنه يشارك جذر المستند مع نطاق آخر: %1.',
    'domain_move_err_no_mail_service' => 'يتعذر نقل النطاق نظرًا لتعطل خدمة البريد في الاشتراك المستهدف.',
    'domain_move_err_app' => "لم يتم نقل التطبيق المثبت على %1 إلى الاشتراك '%2': %3",
    'domain_move_database_used_by_app' => "يتم استخدام قاعدة البيانات '%1' على %2 بواسطة التطبيق الذي تم نقله. لإعادة تعيين قاعدة البيانات إلى '%3'، شغِّل الأمر \"plesk bin database --assign-to-subscription\"",
    'domain_move_target_locked' => "تم قفل الاشتراك المستهدف '%1' للمزامنة.",
    'domain_move_filesharing_disabled' => 'تم تعطيل مشاركة الملفات.',
    'domain_move_website_preview_disabled' => 'تم تعطيل وظيفة معاينة موقع الويب.',
    'domain_move_additional_webserver_settings' => "راجع توجيهات خادم الويب الإضافية للنطاق لمنع عملية التكوين المعطلة.",
    'domain_move_no_permission' => "غير مسموح بـ %1 للاشتراك '%2'.",
    'domain_move_no_access' => "لا يمكن الوصول إلى الاشتراك '%1'.",
    'domain_split_no_create_permission' => "غير مسموح بإنشاء نطاق.",
    'domain_split_empty_login' => 'يلزم تسجيل دخول مُستخدِم النظام.',
    'domain_split_empty_password' => 'يلزم إدخال كلمة مرور مُستخدِم النظام.',
    'domain_split_err_home_exists' => 'يتعذر نقل النطاق %1 لأن مساره الرئيسي المستهدف موجود بالفعل في %2. أعد تسمية النطاق لنقله إلى اشتراك جديد.',
    'domain_split_err_no_hosting_subdomains' => 'يتعذر نقل النطاق إلى اشتراك جديد نظرًا لعدم احتواء النطاق على استضافة ولكن يتوافر به نطاقات فرعية. لنقل النطاق، غيِّر قيمة "نوع الاستضافة" به إلى "استضافة موقع الويب" (في إعدادات الاستضافة).',
    'domain_split_target_locked' => "يتم قفل الاشتراك المستهدف '%1' للمزامنة.",
    'domain_split_target_unsynced' => "لم تتم مزامنة الاشتراك المستهدف '%1' مع الخطة بسبب: %2.",
    'domain_merge_scheduled_backup_deactivated' => "تم إلغاء تنشيط النسخة الاحتياطية المجدولة على '%1'.",
    'domain_merge_database_error' => "لم يتم نقل قاعدة البيانات '%1' المتوافرة على %2 إلى الاشتراك '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "تم إيقاف تشغيل بروتوكول نقل الملفات المجهول على '%1'.",
    'domain_merge_smb_user_access' => "تم نقل المُستخدِم الإضافي '%1' إلى الاشتراك '%2' ولكن تم إلغاء وصوله إلى الاشتراك.",
    'domain_merge_scheduled_tasks' => "تم نقل المهام المجدولة إلى الاشتراك المستهدف. مراجعة تكوين المهام.",
    'domain_merge_scheduled_tasks_deactivated' => "تم نقل المهام المجدولة إلى الاشتراك المستهدف وإلغاء تنشيطها. مراجعة تكوين المهام.",
    'domain_merge_no_remove_permission' => "غير مسموح بحذف الاشتراكات.",
    'domain_merge_err_has_addons' => 'يتعذر نقل النطاق الرئيسي مع نطاقاته الإضافية؛ انقل النطاق (النطاقات) %1 أولًا.',
    'domain_merge_err_has_webusers' => 'يتعذر نقل النطاق الرئيسي مع مُستخدمي الويب المتوافرين به.',
    'domain_merge_err_root_exists' => 'المسار المستهدف %1 موجود بالفعل.',

    'database_server_edit_used_for_psa' => 'لا يُسمح بتحديث قاعدة بيانات MySQL المحلية.',
    'suggest_repair_main_suggestion_ui' => '<b>يمكنك معالجة هذا الخطأ</b> باستخدام أداة المساعدة "إصلاح قاعدة بيانات plesk".',
    'suggest_repair_main_suggestion_cli' =>  'يمكنك معالجة هذا الخطأ باستخدام أداة المساعدة "إصلاح قاعدة بيانات plesk".',
    'suggest_repair_repair_kit_link_title' => 'انتقل إلى التشخيص &الإصلاح',
    'suggest_repair_using_cli_and_ui' => 'كي يتسنى لك هذا، قم بتشغيل أمر "إصلاح قاعدة بيانات %1" من خلال CLI أو انقر فوق خيار "إصلاح" بجانب "قاعدة بيانات Plesk"',
    'suggest_repair_using_cli' => 'كي يتسنى لك هذا، قم بتشغيل أمر "إصلاح قاعدة بيانات %1" من خلال CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'لم تكن خدمة DNS متوفرة عند إنشاء النسخة الاحتياطية. ومع ذلك، توجد مناطق DNS نشطة في النسخة الاحتياطية وسيتم تمكينها للكائنات التالية: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'مراقب الموارد (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'دعم SmarterMail البعيد',
    'plesk_key__complete-backup-solution' => 'الملحق Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(غير مسموح به بواسطة مفتاح الترخيص)',
    'plesk_key__validation_failed' => '%1 (رمز الخطأ: %2)',
    'promo__button_details' => '‫التفاصيل‬',
    'promo__extension_catalog_title' => 'كتالوج الملحق',
    'promo__extension_catalog_description' => 'تحقق من كتالوج الملحق الجديد وقم بتعزيز منصة Plesk من خلال مجموعة متنوعة من الملحقات الفعالة!',
    'promo__button_open_catalog' => 'افتح الكتالوج',

    'backup__repository_check_login' => "يتعذر الوصول إلى سعة التخزين: %1 تأكد من إدخال بيانات اعتماد التخزين الصحيحة.",
    'backup__repository_check_error_list' => "يتعذر الوصول إلى سعة التخزين: %1 تأكد من إدخال إعدادات التخزين الصحيحة.",
    'backup__repository_check_error_mkdir' => "يتعذر إنشاء الدليل: %1 تحقق مما إذا كان لديك أذونات لإنشاء مجلدات في سعة التخزين.",
    'backup__repository_check_error_upload' => "يتعذر تحميل الملف إلى سعة التخزين: %1 تحقق مما إذا كان لديك أذونات لاستئناف تحميل الملفات إلى سعة التخزين.",
    'backup__repository_check_error_download' => "يتعذر تنزيل الملف من سعة التخزين: %1 تحقق مما إذا كان لديك أذونات لتحميل الملفات وتنزيلها من سعة التخزين.",
    'backup__repository_check_error_resume-upload' => "يتعذر استئناف تحميل الملف إلى سعة التخزين: %1 تحقق مما إذا كان لديك أذونات لاستئناف عمليات التحميل إلى سعة التخزين.",
    'backup__repository_check_error_resume-download' => "يتعذر استئناف تنزيل الملف من سعة التخزين: %1 تحقق مما إذا كان لديك أذونات لاستئناف عمليات التنزيل من سعة التخزين.",
    'backup__repository_check_error_enable-utf8' => "يتعذر تشغيل سعة التخزين: %1 تحقق مما إذا كانت سعة التخزين تدعم ترميز UTF8.",
    'backup__repository_check_error_rm' => "يتعذر تشغيل سعة التخزين: %1 تحقق مما إذا كان لديك أذونات لحذف الملفات من سعة التخزين.",
    'backup__repository_check_error_rmdir' => "يتعذر تشغيل سعة التخزين: %1 تحقق مما إذا كان لديك أذونات لحذف المجلدات من سعة التخزين.",

    'backup__ftp_repository_check_login' => "%1 يمكنك التحقق منهم بشكل مستقل باستخدام الأمر: %2",
    'backup__ftp_repository_check_error_list' => "%1 يمكنك التحقق منهم بشكل مستقل باستخدام الأمر: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 يمكنك التحقق منه بشكل مستقل باستخدام الأمر: %2",
    'backup__ftp_repository_check_error_upload' => "%1 يمكنك التحقق منه بشكل مستقل باستخدام الأمرين: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 يمكنك التحقق منه بشكل مستقل باستخدام الأمرين: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 يمكنك التحقق منه بشكل مستقل باستخدام الأوامر: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 يمكنك التحقق منه بشكل مستقل باستخدام الأمرين: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 يمكنك التحقق منه بشكل مستقل باستخدام الأمر: %2",
    'backup__ftp_repository_check_error_rm' => "%1 يمكنك التحقق منه بشكل مستقل باستخدام الأمرين: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 يمكنك التحقق منه بشكل مستقل باستخدام الأمرين: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'يتعذر تغيير إعدادات DMARC. لتمكين هذا الخيار، يرجى تشغيل حماية DKIM وSPF من البريد العشوائي.',
    'spf_server_wide_disable_failed' => 'يتعذر تغيير إعدادات حماية SPF من البريد العشوائي. لتعطيل SPF، يرجى إيقاف تشغيل DMARC للبريد الوارد.',
    'sfdk_server_wide_verify_disable_failed' => 'يتعذر تغيير إعدادات حماية DKIM من البريد العشوائي. لتعطيل DKIM، يرجى إيقاف تشغيل DMARC للبريد الوارد.',

    'ccs_not_supported' => 'لم يتم تكوين IIS Central Certificate Store في النظام.',
    'ccs_not_enabled' => 'لم يتم تمكين إدارة IIS Central Certificate Store (متجر الشهادات المركزي IIS) في منصة Plesk.',
    'ad_not_supported' => 'الخادم غير مُلحق بالنطاق.',

    'component_name__appinit' => "تهيئة التطبيق",
    'component_name__httpcompression' => 'ضغط محتوى HTTP',
    'common_feature_is_not_supported' => 'لم تعد هذه الميزة مدعومة.',
    'common_feature_is_not_supported_in_proto' => 'هذه الميزة غير مدعومة لإصدار البروتوكول %1.',
    'autoinstaller__plesk_component' => 'مكونات Plesk',
    'plesk_key__key_expired' => 'انتهت صلاحية مفتاح الترخيص الخاص بك. لمتابعة استخدام منصة Plesk، قم بشراء %1 تجاري غير منتهي الصلاحية.',
    'plesk_key__key_purchase' => 'مفتاح الترخيص',

    'sa_action_move' => 'انقل الرسائل غير المرغوب بها إلى مجلد "البريد الإلكتروني غير المهم"',

    'bu_conflict_resolver_tomcat_not_supported' => 'لم تعد تطبيقات جافا مدعومة. لن تكون متاحة لمواقع الويب التالية: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'لم تعد إصدارات مواقع الويب للهواتف المحمولة المستضافة بواسطة UNITY Mobile مدعومة. لن تكون متاحة لمواقع الويب التالية: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'لا تسمح سياسة الاستخدام على مستوى الخادم باستخدام إعدادات مكافحة الفيروسات الشخصية. ستتم استعادتها بشكل غير كامل لحسابات البريد الإلكتروني في النطاقات التالية: {{objects}}',

    'module__not_installed' => "لم يتم تثبيت الملحق %1",

    'mail__mail_autodiscovery_server_error' => 'حدد اسم نطاق مخصص للاكتشاف التلقائي للبريد',
    'mail__error_mail_autodiscovery_enable' => 'يتعذر تعيين الاكتشاف التلقائي للبريد: %1',
    'mail__error_mail_autodiscovery_server' => 'يتعذر تعيين اسم نطاق مخصص للاكتشاف التلقائي للبريد: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'يتعذر إعادة تكوين سجلات DNS للاكتشاف التلقائي للنطاقات: %1',

    '__invalid_url' => 'عنوان URL "%1" غير صالح',
    'actionlog__cloning_start' => 'البدء',
    'actionlog__event_cloning_start' => 'بدء استنساخ الخادم',

        '__show_hide_title' => 'تصغير/استعادة',
    '__show_hide_navigation_pane' => 'إخفاء/إظهار جزء التنقل',
    '__UPLOAD_ERR_FORM_SIZE' => "تجاوز الملف الذي تم تحميله الحجم المسموح",
    '__UPLOAD_ERR_INI_SIZE' => "تجاوز الملف الذي تم تحميله الحجم المسموح",
    '__UPLOAD_ERR_NO_FILE' => "لم يتم استلام أي ملف",
    '__UPLOAD_ERR_OK' => "تم تحميل الملف بنجاح",
    '__UPLOAD_ERR_PARTIAL' => "تم تحميل جزء من الملف، يُرجى إعادة المحاولة",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'المجلد المؤقت مفقود',
    '__UPLOAD_ERR_CANT_WRITE' => 'فشلت كتابة الملف على القرص',
    '__UPLOAD_ERR_UNKNOWN' => 'حدث خطأ غير معروف أثناء تحميل الملف',
    '__accounts' => "الحسابات",
    '__access' => "الوصول",
    '__address' => "عنوان",
    '__addresses' => "العناوين",
    '__acl_records' => 'سجلات ACL',
    '__admin_repository' => "مستودع المسؤول",
    '__all' => 'الكل',
    '__allowed' => "مسموح به",
    '__anonftp_status' => "FTP مجهول",
    '__antispam' => "مكافحة البريد العشوائي",
    '__apache_restart' => "... جار الآن إعادة تشغيل خادم الويب 1%، يُرجى الانتظار ...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "دعم Microsoft ASP.NET",
    '__asp_win_support' => "دعم Microsoft ASP",
    '__attachments' => "المرفقات",
    '__attachments_list' => "المرفقات",
    '__author' => 'المؤلف',
    '__autoresp_name_already_exists' => "الرد التلقائي بالاسم 1% موجود بالفعل.",
    '__autoresponder' => "الرد التلقائي",
    '__autoresponders' => "الردود التلقائية",
    '__autoresponders_list' => "الردود التلقائية",
    '__autoresponder_attachment_files' => "ملفات مرفقات الرد التلقائي",
    '__auto_updates_list' => '‫التحديثات المتوفرة‬',
    '__avail' => "متوفر",
    '__backup_utilites' => "الأدوات المساعدة للنسخ الاحتياطي",
    '__bind_status' => "حالة خادم DNS",
    '__bu_is_not_installed' => "هذه الخدمة غير متوفرة حاليًا، حيث إن الأدوات المساعدة للنسخ الاحتياطي لم يتم تثبيتها.",
    '__bu_not_support_in_key' => "لا يدعم مفتاح الترخيص إمكانية النسخ الاحتياطي غير المدعومة.",
    '__notifications_not_support_in_key' => 'لا يدعم مفتاح الترخيص الإعلامات',
    'disabled_by_key' => 'غير معتمدة من مفتاح الترخيص',
    '__bytes' => "بايت",
    '__can_not_use_reserved_words' => "لا يمكنك استخدام الكلمات المحجوزة.",
    '__certificate' => "الشهادة",
    '__cgi_support' => "دعم CGI",
    '__change_date' => "تاريخ التعديل",
    '__city' => "المدينة",
    '__cl_not_exist' => "حساب العميل غير موجود.",
    '__client' => 'العميل',
    '__client_card' => "بطاقة العميل",
    '__client_contact_name' => "اسم جهة اتصال العميل",
    '__client_form' => "المعلومات الشخصية",
    '__client_ip_pool' => "تجمع IP للعميل",
    '__client_limits' => "حدود حساب العميل",
    '__client_permissions' => "أذونات العميل",
    '__client_preferences' => "تفضيلات العميل",
    '__client_status' => "حالة العميل",
    '__client_name' => "أسماء العملاء",
    '__client_total' => "إجمالي العملاء",
    '__client_with_login_name_already_exists' => "يوجد مستخدم باسم المستخدم  \"\\1%\"\\ هذا بالفعل.",
    '__client_domuser_with_login_already_exists' => "‫اسم المستخدم \"\\1%\"\\ مُستخدم بالفعل من قبل مسؤول المجال \"\\1%\"\\.‬",
    '__clients_global_changes' => "تعديل حسابات العملاء المحددة",
    '__clients_list' => "العملاء",
    '__cmd_not_found' => "أمر غير معروف: 1%",
    '__comments' => "تعليقات",
    '__company_name' => "اسم الشركة",
    '__component_version' => "إصدار المُكوّن",
    '__component_not_installed' => "لم يتم تثبيت المُكوّن 1%",
    '__confirm_del' => "يجب تأكيد الحذف.",
    '__confirm_overwrite' => "تأكيد الاستبدال.",
    '__confirm_stop' => "يجب تأكيد إيقاف العملية.",
    '__confirm_passwd' => "تأكيد كلمة المرور 1%",
    '__confirm_removal' => "تأكيد الإزالة",
    '__conhelp' => "‫الوصف‬",
    '__contact_name' => "اسم جهة الاتصال",
    '__country' => "البلد",
    '__countries' => 'البلد',
    '__country_unknown' => 'تعذّر تمييز الكود الفرعي للدولة.',
    '__courier-imap' => 'خادم Courier',
    '__create_domain' => 'إنشاء مجال',
    '__crypted' => 'مشفر',
    '__cp_access' => "الوصول إلى Plesk",
    '__cp_user' => "مستخدم Plesk",
    '__create' => "إنشاء",
    '__create_client_template_without_template' => "إنشاء حساب مستخدم دون قالب",
    '__create_domain_for' => "إنشاء مجال لـ <b>1%</b>",
    '__create_domain_template_without_template' => "إنشاء مجال دون قالب",
    '__creation_date' => "تاريخ الإنشاء",
    '__crontab_unix' => "برنامج الجدولة",
    '__crontab_win' => "برنامج الجدولة",
    '__ct_month_jan' => 'يناير',
    '__ct_month_feb' => 'فبراير',
    '__ct_month_mar' => 'مارس',
    '__ct_month_apr' => 'أبريل',
    '__ct_month_may' => 'مايو',
    '__ct_month_jun' => 'يونيو',
    '__ct_month_jul' => 'يوليو',
    '__ct_month_aug' => 'أغسطس',
    '__ct_month_sep' => 'سبتمبر',
    '__ct_month_oct' => 'أكتوبر',
    '__ct_month_nov' => 'نوفمبر',
    '__ct_month_dec' => 'ديسمبر',
    '__custom_button' => "الزر المخصص",
    '__custom_buttons_list' => "روابط الخدمات الإضافية",
    '__daily' => "يوميًا",
    '__database_not_activated' => "لم يتم تنشيط 1% على صفحة مسؤول الخادم.",
    '__database_not_installed' => "لم يتم تثبيت قاعدة البيانات 1%.",
    '__database_not_run' => "لم يتم تشغيل قاعدة البيانات 1%.",
    '__database_is_corrupt' => "قاعدة بيانات Plesk تالفة. يُرجى تشغيل الأداة المساعدة Reconfigurator لإصلاح ذلك.",
    '__databases' => "قواعد البيانات",
    '__databases_list' => "قواعد البيانات",
    '__database_type_not_supported_by_key' => '‫لاستخدام خادم 1%، تحتاج أن يكون مدعومًا في مفتاح ترخيصك.‬ ‫يُرجى الرجوع إلى ممثل مبيعات Plesk في منطقتك.‬',
    '__date_immediately' => "اليوم",
    '__date_never' => "مطلقًا",
    '__day(s)' => "يوم (أيام)",
    '__day0' => "الأحد",
    '__day1' => "الاثنين",
    '__day2' => "الثلاثاء",
    '__day3' => "الأربعاء",
    '__day4' => "الخميس",
    '__day5' => "الجمعة",
    '__day6' => "السبت",
    '__days' => "1% يوم (أيام)",
    '__db_admin_login_empty' => "لقد أدخلت اسم مستخدم فارغًا، سيتوقف تشغيل التحكم بـ 1% في واجهة المستخدم. هل ترغب في المتابعة؟",
    '__db_unable_to_unregister' => 'تعذّرت إزالة معلمات اتصال قاعدة البيانات',
    '__db_db_exists' => 'يوجد قاعدة بيانات واحدة على الأقل على الخادم',
    '__db_unable_to_change_server_name' => 'لا يمكن تغيير اسم الخادم',
    '__db_unable_to_change_port' => 'لا يمكن تغيير منفذ الخادم',
    '__db_already_exist' => "قاعدة البيانات 1% موجودة بالفعل.",
    '__db_credentials_invalid' => "بيانات اعتماد قاعدة البيانات غير صالحة.",
    '__db_invalid_password_characters' => 'تحتوي كلمة المرور على أحرف غير صالحة',
    '__db_engine' => "محرك قاعدة البيانات", // indirect
    '__db_type' => "نوع قاعدة البيانات",
    '__db_user' => "مستخدم قاعدة البيانات",
    '__db_server' => 'خادم قاعدة البيانات',
    '__def_domain' => "مجال افتراضي",
    '__default_for_mysql' => 'افتراضي لـ MySQL',
    '__default_for_mariadb' => 'الافتراضي لـ MariaDB',
    '__default_for_percona' => 'الافتراضي لـ Percona',
    '__default_for_postgresql' => 'افتراضي لـ PostgreSQL',
    '__delete' => "حذف",
    '__demo' => "هذه الوظيفة غير متوفرة في الإصدار التجريبي.",
    '__directory' => "دليل",
    '__disable_lock_screen' => 'منع المستخدمين من العمل على Plesk حتى يكتمل تحميل شاشات واجهة المستخدم',
    '__dismiss_news?' => "هل ترغب بالتأكيد في إغلاق مجموعة الأخبار تمامًا؟ لن تتمكن من مشاهدة مجموعة الأخبار حتى يتوفر المزيد من الأخبار.",
    '__description' => "‫الوصف‬",
    '__disabled' => "تم إيقاف التشغيل",
    '__disk_space_limit' => "حد مساحة القرص",
    '__cgroups_cpu_usage_limit' => 'حد استخدام وحدة المعالجة المركزية',
    '__cgroups_ram_usage_limit' => 'حد استخدام ذاكرة الوصول العشوائي',
    '__cgroups_disk_read_usage_limit' => 'حد النطاق الترددي لقراءة القرص',
    '__cgroups_disk_write_usage_limit' => 'حد النطاق الترددي لكتابة القرص',
    '__disk_usage_by' => "مساحة القرص المستخدمة بـ 1%",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "سجل DNS \"نظام أسماء النطاقات\" '%1' موجود بالفعل.",
    '__dns_master_should_be_remote' => "يجب أن يكون لديك خادِمَا اسم معتمَدَان مختلفان على مضيفين منفصلين.",
    '__dns_record_not_exist' => "سجل DNS غير موجود.",
    '__dns_server' => "خادم DNS", // indirect
    '__dom_id_is_undefined' => "مُعرّف المجال غير محدد.",
    '__dom_name' => "اسم النطاق",
    '__dom_name_is_invalid' => "اسم المجال غير صالح. يُرجى التأكد من أن اسم الملف لا يحتوي إلا على أحرف رقمية ونقاط وشُرَط كرموز، وأن طوله لا يزيد عن 255 رمزًا. يجب ألا يتجاوز كل جزء من اسم المجال بين النقاط 63 رمزًا.",
    '__dom_not_exist' => "المجال غير موجود.",
    '__domain' => "المجال",
    '__domain_' => 'المجال 1%',
    '__domain_form' => "نموذج المجال",
    '__domain_id' => "معرِّف المجال",
    '__domain_is_turned_off_for_backup' => "تم إيقاف تشغيل موقع الويب 1% مؤقتًا لإتمام النسخ الاحتياطي أو الاسترداد، وهو غير متوفر حاليًا.",
    '__domain_limits' => "حدود المجال",
    '__domain_name' => "اسم النطاق",
    '__mail_name_in_ASCII_form' => "اسم حساب البريد بتنسيق ASCII",
    '__message_error' => 'خطأ',
    '__message_warning' => 'تحذير',
    '__message_info' => 'المعلومات',
    '__domain_name_in_ASCII_form' => "اسم المجال بتنسيق ASCII",
    '__domain_repository' => "مستودع للمجال 1%",
    '__domain_status' => "حالة المجال",
    '__domain_dns' => 'منطقة DNS للمجال',
    '__domain_total' => "إجمالي الاشتراكات",
    '__domain_total_powerUser' => "إجمالي الاشتراكات",
    '__domain_user' => "مسؤول المجال",
    '__domains_global_changes' => "تعديل المجالات المحددة",
    '__mailnames_global_changes' => "تعديل حسابات البريد المحددة",
    '__backup_manager' => 'إدارة النسخ الاحتياطي',
    '__domains_list' => "المجالات",
    'domains_list__list_header' => "المجالات", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "يبدأ اسم المجال بـ www، مع أن البادئة WWW مستخدمة. هل ترغب في المتابعة على أي حال؟",
    '__dovecot' => '‫Dovecot IMAP and POP3 server‬',
    '__dsmail' => "خدمة البريد",
    '__dsmaillist' => "خدمة قائمة المراسلة",
    '__dsr_db' => "قاعدة البيانات",
    '__dsr_dname' => "اسم النطاق",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "علبة البريد",
    '__dsr_pname' => "اسم العميل",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "الحجم الإجمالي لملفات النسخ الاحتياطي في التخزين المحلي",
    '__email' => "البريد الإلكتروني",
    '__email_addr_is_invalid' => "عنوان البريد الإلكتروني غير صالح.",
    '__enabled' => "قيد التشغيل",
    '__enter_cert_text' => "أدخل نص الشهادة",
    '__enter_size' => "حجم الإدخال",
    '__exclusive' => "مخصص",
    '__expiration_date' => "تاريخ انتهاء الصلاحية",
    '__fax' => "فاكس",
    '__file' => "الملف",
    '__file_is_empty' => "الملف فارغ.",
    '__file_name' => "اسم الملف",
    '__file_type' => 'نوع الملف',
    '__filemanager' => "إدارة الملفات",
    '__filepath_is_empty' => "مسار الملف فارغ",
    '__files_list' => "الملفات",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "بروتوكول نقل الملفات", // +indirect
    '__ftp_settings' => "إعدادات FTP",
    '__ftp_serv' => "خادم FTP", // indirect
    '__ftp_server_parameters_are_empty' => "يجب إعداد خصائص حساب FTP أولاً!",
    '__ftp_status' => "حالة خادم FTP",
    '__full_day0' => "الأحد",
    '__full_day1' => "الاثنين",
    '__full_day2' => "الثلاثاء",
    '__full_day3' => "الأربعاء",
    '__full_day4' => "الخميس",
    '__full_day5' => "الجمعة",
    '__full_day6' => "السبت",
    '__full_month1' => "يناير",
    '__full_month10' => "أكتوبر",
    '__full_month11' => "نوفمبر",
    '__full_month12' => "ديسمبر",
    '__full_month2' => "فبراير",
    '__full_month3' => "مارس",
    '__full_month4' => "أبريل",
    '__full_month5' => "مايو",
    '__full_month6' => "يونيو",
    '__full_month7' => "يوليو",
    '__full_month8' => "أغسطس",
    '__full_month9' => "سبتمبر",
    '__giga' => "غيغا",
    '__group' => "مجموعة",
    '__h' => "H",
    '__hard_disk_quota' => "حصة القرص الثابت",
    '__hard_disk_quota_not_supported' => 'حصة القرص الثابت غير مدعومة بسبب تكوين نظام ملف الخادم',
    '__header_text_is_invalid' => "عنوان المنطقة المحمية غير صالح.",
    '__help_topic_not_found' => 'موضوع المساعدة الذي طلبته (1%) غير موجود.',
    '__hosting' => "الاستضافة",
    '__hosting_ip_dns_ip_not_equiv' => "لا يوجد أي من عناوين IP المحددة في سجلات DNS يطابق عنوان IP المستخدم للاستضافة.",
    '__hosting_scripting' => "دعم البرمجة النصية للاستضافة",
    '__hosting_setup_page_title' => "إعداد استضافة الويب للمجال %1",
    '__hosting_title' => "استضافة (1%)",
    '__hosting_type' => "نوع الاستضافة",
    '__hostname' => "اسم المضيف",
    '__hostname_is_empty' => "اسم المضيف فارغ.",
    '__hour(s)' => 'ساعة (ساعات)',
    '__hst_type_incorrect' => "نوع الاستضافة غير صحيح.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "‫وقت الخمول‬",
    '__iface' => "واجهة المستخدم",
    '__image' => "‫صورة‬",
    '__imap_status' => "حالة خادم IMAP",
    '__in' => "في",
    '__in_%' => "في %",
    '__incorrect_databases_login_pass' => "بيانات الاعتماد التي حددتها للوصول إلى PostgreSQL غير صحيحة.",
    '__incorrect_ip_or_network_address' => 'عنوان IP أو الشبكة غير صحيح.',
    '__info' => 'المعلومات',
    '__install' => "تثبيت",
    '__install_prefix' => "تثبيت بادئة",
    '__invalid_cert_id' => "معرّف شهادة غير صالح",
    '__invalid_context' => "سياق غير صالح: 1%",
    '__invalid_db_usr_name' => "اسم مستخدم قاعدة البيانات غير صالح.",
    '__invalid_dir_name' => "اسم الدليل غير صالح",
    '__invalid_dom_name' => "اسم المجال غير صالح.",
    '__invalid_filename' => "اسم ملف غير صالح. لا تستخدم علامات اقتباس مفردة و/أو تركيب \"../\".",
    '__invalid_id' => "معرّف غير صالح.",
    '__invalid_lines_num' => "قيمة غير مناسبة لعدد الأسطر، لا يُسمح إلا بالأرقام فقط.",
    '__invalid_max_letter_size' => "الحد الأقصى لحجم الرسالة غير صالح.",
    '__invalid_pdir_name' => "اسم الدليل المحمي غير صالح.",
    '__invalid_restart_apache_interval' => "الفترة الفاصلة لإعادة تشغيل Apache غير صالحة.",
    '__invalid_tmpl_name' => "اسم القالب غير صالح.",
    '__invalid_value' => "قيمة غير صحيحة.",
    '__ip_addr' => "عنوان IP",
    '__ip_address_and_mask' => "عنوان IP وقناع الشبكة الفرعية",
    '__ip_alias__mask' => "عنوان IP وقناع الشبكة الفرعية",
    '__ip_addr_form' => "نموذج عنوان IP",
    '__ip_addr_is_invalid' => "عنوان IP غير صالح.",
    '__ip_addr_list' => "عناوين IP",
    '__ip_address_does_not_exist' => "عنوان IP غير موجود.",
    '__ip_addresses' => "عناوين IP",
    '__ip_address_and_mask_hint' => 'على سبيل المثال، 1%',
    '__is_owner' => "O",
    '__java_engine' => "‫Java‬", // indirect
    '__jdk' => "JDK",
    '__kb' => "كيلوبايت",
    '__kbps' => "كيلوبايت/ثانية",
    '__kbytes' => "كيلوبايت",
    '__key_for_virtuozzo_only' => "الغرض من استخدام مفتاح الترخيص هو العمل ضمن حاويات Virtuozzo فقط.",
    '__key_limits_exceeding' => "تجاوز هذا الإجراء الحدود المقررة في ترخيصك. إذا تلقيت هذه الرسالة، فيمكنك الاتصال بموفر الخدمة أو المصنع للحصول على توضيح أو لزيادة حدود هذا الترخيص.",
    '__kilo' => "كيلو",
    '__keywords' => 'كلمات أساسية',
    '__lang_unknown' => 'يتعذّر تمييز اللغة.',
    '__languages' => 'اللغة',
    '__learn_more' => 'معرفة المزيد',
    '__loading' => 'جارٍ التحميل...',
    '__locales' => "حزم اللغة",
    '__lists' => "قوائم المراسلة",
    '__literal_bytes' => "بايت",
    '__processing' => "يُرجى الانتظار.<br>جارٍ التحميل...",
    '__locale' => "‫لغة الواجهة‬",
    '__locale_is_not_defined' => "لغة الواجهة غير محددة.",
    '__local_server_mysql' => 'خادم MSSQL المحلي',
    '__local_server_postgresql' => 'خادم PostgreSQL المحلي',
    '__local_server_mssql' => 'خادم MS SQL المحلي',
    '__log_and_statistics_files' => 'ملفات السجل وتقارير الإحصائيات',
    '__config_files' => 'ملفات التكوين',
    '__chroot_files' => 'بيئة نظام Chroot',
    '__login' => "تسجيل دخول 1%",
    '__login1' => "‫تسجيل الدخول‬",
    '__login_disabled' => "تسجيل الدخول محظور",
    '__login_enabled' => "تسجيل الدخول مسموح به",
    '__login_incorrect' => "لقد أدخلت اسم مستخدم أو كلمة مرور غير صحيحة.",
    '__login_name' => "اسم مستخدم 1%",
    '__login_name_is_invalid' => "اسم مستخدم 1% غير صالح.",
    '__logon_time' => "‫وقت الدخول‬",
    '__ma' => "الأسماء المستعارة للبريد",
    '__mail' => "البريد",
    '__mail_alias_name' => "الاسم المستعار للبريد",
    '__mail_autodiscovery' => 'الاكتشاف التلقائي للبريد',
    '__mail_exchanger_name_is_invalid' => "اسم مبادل البريد غير صالح.",
    '__mail_groups' => "مجموعات البريد",
    '__mail_list_engine' => "برنامج قائمة المراسلة",
    '__mail_name' => "حساب البريد",
    '__mail_name_form' => "خصائص حساب البريد",
    '__mail_names' => "حسابات البريد",
    '__mail_serv' => "خادم البريد",
    '__mail_user' => 'مستخدم البريد',
    '__mailgroup' => "مجموعة البريد",
    '__maillist' => "قائمة المراسلة",
    '__maillists' => "قوائم المراسلة",
    '__maillist_member' => 'عضو بقائمة المراسلة',
    '__mailname' => "حساب البريد",
    '__mailname_redir_self' => "لا يمكن لحساب البريد الإلكتروني أن يعيد توجيه رسالة بريد إلى نفسه.",
    '__max_dom_num_reached_for_cl' => "وصل حساب العميل هذا إلى الحد الأقصى لعدد المجالات.",
    '__max_file_size_available' => "الحد الأقصى المسموح به لحجم الملف 1%",
    '__max_subdom_num_reached_for_cl' => "وصل حساب العميل هذا إلى الحد الأقصى لعدد المجالات الفرعية.",
    '__max_subdom_num_reached_for_dom' => "وصل المجال إلى الحد الأقصى لعدد المجالات الفرعية.",
    '__max_subdom_num_reached_for_key' => "تم الوصول إلى الحد الأقصى لعدد المجالات الفرعية التي يسمح بها مفتاح الترخيص.",
    '__max_traffic_limit' => "حدود حركة مرور البيانات",
    '__maximum_excl_ip_num' => "حسابات البريد",
    '__mb' => "ميجابايت",
    '__mbytes' => "ميغابايت",
    '__mb_month' => "ميغابايت/شهر",
    '__mb_sec' => "ميجابايت/ث",
    '__gb_sec' => "جيجابايت/ث",
    '__tb_sec' => "تيرابايت/ث",
    '__mega' => "ميجا",
    '__minute(s)' => 'دقيقة (دقائق)',
    '__mls_not_in_key' => "لا يدعم مفتاح منتجك واجهة المستخدم متعددة اللغات.",
    '__modification_date' => "تاريخ التعديل",
    '__module' => "الملحق",
    '__month' => "شهر",
    '__month(s)' => "شهر (أشهر)",
    '__month1' => "يناير",
    '__month10' => "أكتوبر",
    '__month11' => "نوفمبر",
    '__month12' => "ديسمبر",
    '__month2' => "فبراير",
    '__month3' => "مارس",
    '__month4' => "أبريل",
    '__month5' => "مايو",
    '__month6' => "يونيو",
    '__month7' => "يوليو",
    '__month8' => "أغسطس",
    '__month9' => "سبتمبر",
    '__monthly' => "شهريًا",
    '__months' => "أشهر",
    '__moved_permanently' => 'تمت إزالته نهائيًا',
    '__mssql' => "خادم Microsoft SQL",
    '__mssql__server' => "الخادم",
    'mssql__server' => "اسم خادم Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "لا يمكن تغيير اسم الخادم: يوجد عليه قاعدة بيانات واحدة على الأقل.",
    '__mssql_status' => "حالة خادم Microsoft SQL",
    '__multiply_login_deny' => "يتعذر تسجيل دخولك. سجّل مستخدم آخر باسم المستخدم نفسه (1%) الدخول بالفعل إلى Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "حالة خادم MySQL",
    '__mysql_version' => "إصدار Mysql",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "حالة خادم MariaDB",
    '__mariadb_version' => "إصدار MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "حالة خادم Percona",
    '__percona_version' => "إصدار Percona",
    '__name' => "الاسم",
    '__name_invalid' => "الاسم غير صالح.",
    '__nameserver' => "Nameserver",
    '__network' => "الشبكة",
    '__networks' => "الشبكات",
    '__no' => "‫لا‬",
    '__no_ip_address_with_properly_type_available' => "تعذّر استرداد البيانات التي تم نسخها نسخًا احتياطيًا لعدم وجود عناوين IP المناسبة اللازمة للاسترداد.",
    '__no_clients_specified' => "لم يتم تحديد حسابات العملاء.",
    '__no_comments' => "لا توجد تعليقات.",
    '__no_ip_specified' => "لم يتم تحديد عنوان IP.",
    '__nologin' => "محظور",
    '__none' => "بلا",
    '__not_configured' => "لم يتم تكوينه",
    '__not_implemented_yet' => "لم يتم الإنشاء بعد",
    '__not_supported_by_ftp' => "(لا يدعم خادم FTP ذلك)",
    '__notification' => "إعلام",
    '__num_displayed' => "عرض 1% من 2%",
    '__num_is_invalid' => "الرقم غير صالح.",
    '__object_not_found' => 'لم يتم العثور على الكائن: 1%',
    '__of_all' => "% من الكل",
    '__off' => "إيقاف تشغيل",
    '__ok' => "موافق",
    '__old_passwd' => "كلمة المرور 1% قديمة",
    '__on' => "‫تشغيل‬",
    '__others' => "أخرى",
    '__other_ip__will_be_added' => 'عناوين IP أخرى صالحة (ستتم إضافتها إلى تجمّع عناوين IP للعميل)',
    '__out' => "خارج",
    '__p' => "P",
    '__passwd' => "كلمة مرور 1%",
    '__passwd_is_invalid' => "كلمة المرور 1% غير صالحة.",
    '__passwd_not_match' => "كلمات المرور غير متطابقة!",
    '__path' => "‫المسار‬",
    '__perl_unix_support' => "دعم Perl",
    '__perl_win_support' => "دعم Perl",
    '__perm_denied' => "تم رفض الإذن.",
    '__permissions' => "الأذونات",
    '__personal_name' => "الاسم الشخصي",
    '__pg_admin_not_activated' => "لم يتم تنشيط PostgreSQL على صفحة مسؤول الخادم.",
    '__pg_not_inst' => "لم يتم تثبيت PostgreSQL.",
    '__pg_not_run_or_inst' => "لم يتم تثبيت PostgreSQL أو أنه لا يعمل.",
    '__pg_not_support_in_key' => "PostgreSQL غير مدعوم من مفتاح الترخيص.",
    '__phone' => "الهاتف",
    '__phosting' => "الاستضافة المادية",
    '__php_support' => "دعم PHP",
    '__php_run_as_isapi' => "تشغيل كملحق ISAPI",
    '__php_safe_mode' => "تشغيل 'PHP 'safe_mode",
    '__php_version' => "إصدار PHP",
    '__physical' => "الاستضافة المادية",
    '__plesk_stat_pdir' => "حماية دليل '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "إحصائيات المجال",
    '__plesk_stat_protect' => "‫حماية الوصول إلى إحصاءات الويب باستخدام اسم مستخدم FTP الخاص بالمستخدم وكلمة المرور الخاصة به.‬",
    '__plesk_stat_protect_install' => "يمكن الوصول إليه عبر الدليل المحمي بكلمة المرور '/plesk-stat/webstat/'",
    '__plesk_stat_webstat_not_activate' => "لم تحدد برنامج إحصائيات الويب لاستخدامه مع موقع الويب هذا.",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "حالة خادم POP3",
    '__popen_error' => "حدث خطأ أثناء استدعاء وظيفة popen.",
    '__port' => 'منفذ',
    '__postgres' => "‫PostgreSQL‬",
    '__postgresql' => "‫PostgreSQL‬",
    '__postgresql_status' => "حالة PostgreSQL",
    '__preferences' => "الإعدادات",
    '__account_preferences' => "إعدادات الحساب",
    '__interface_preferences_general' => 'عام',
    '__interface_preferences_default' => 'تفضيلات الواجهة الافتراضية',
    '__interface_preferences_admin' => "تفضيلات الواجهة للمسؤول",
    '__interface_template' => 'قالب تخصيص واجهة المستخدم',
    '__interface_preferences' => "تفضيلات الواجهة",
    '__proceed?' => "هل ترغب في المتابعة؟",
    '__protect_dir_user' => "مستخدم الدليل المحمي",
    '__protect_dir_users' => "مستخدمو الدليل المحمي",
    '__protect_dirs' => "أدلة محمية",
    '__provider_contact_name' => "اسم جهة اتصال المالك",
    '__python_unix_support' => "دعم Python",
    '__python_win_support' => "دعم Python",
    '__quota' => "الحصة النسبية",
    '__r' => "الصفحة المرجعية",
    '__reconfigure' => "إعادة التكوين",
    '__record_type' => "نوع السجل",
    '__release' => "إصدار",
    '__remote_db_not_supported_by_key' => 'لا يدعم مفتاح الترخيص استضافة قاعدة البيانات عن بُعد.',
    '__remove' => "إزالة",
    '__remove_confirmation' => "تأكيد الإزالة",
    '__remove_protection' => 'الحماية من الإزالة',
    '__report' => "تقرير",
    '__report_auto' => 'الجدول الزمني للتسليم',
    '__report_form' => "نموذج التقرير",
    '__report_size_na' => "الخدمة غير متوفرة",
    '__reports_list' => "التقارير",
    '__requested' => "تم الطلب",
    '__required_fields' => "حقول إلزامية",
    '__resp_name_invalid' => "اسم الرد التلقائي غير صالح. لا تستخدم سوى الرموز الأبجدية الرقمية والنقاط والشرطة السفلية والمسافات الفارغة.",
    '__c' => "‫A‬", // Access to panel
    '__s' => "‫S‬",
    '__server_name_is_invalid' => "اسم الخادم غير صالح.",
    '__screenshots' => 'لقطات الشاشة',
    '__script_warning' => "عند إزالة إمكانية البرمجة النصية من هذا المجال، فسيتم عرض كل البرامج النصية المتأثرة كنص عادي عند طلبها من خلال أحد المتصفحات.  نوصي المسؤول بإزالة كل البرامج النصية المستقلة من المجال المحدد.",
    '__sec' => "ثوانٍ",
    '__second(s)' => "ثانية (ثوانٍ)",
    '__see_list_of_logged_in' => "اطلع على قائمة المستخدمين الذين سجّلوا الدخول حاليًا.",
    '__select_certs_to_remove' => "حدد الشهادات التي ترغب في إزالتها.",
    '__select_domains_to_default_host' => "حدد المجال الذي ترغب في تعيينه كمجال افتراضي.",
    '__select_domains_to_remove' => "حدد المجالات التي ترغب في إزالتها.",
    '__type_domain_name_to_add' => "يُرجى كتابة اسم المجال لإضافته.",
    '__select_files_to_remove' => "حدد الملفات التي ترغب في إزالتها.",
    '__select_ip' => "تعيين عنوان IP",
    '__select_ip_to_remove' => "حدد عنوان IP الذي ترغب في إزالته.",
    '__select_domain_template' => "استخدام إعدادات قالب المجال",
    '__select_templates_to_remove' => "حدد القوالب التي ترغب في إزالتها.",
    '__server' => "الخادم",
    '__server_total' => "إجمالي الخوادم",
    '__service' => "‫الخدمة‬",
    '__service_title__plesk' => "‫Plesk‬",
    '__service_description__plesk' => "‫Plesk‬",
    '__service_title__mysql' => "خادم قاعدة بيانات MySQL",
    '__service_description__mysql' => "خادم قاعدة بيانات MySQL",
    '__service_title__web' => "خادم الويب",
    '__service_description__web' => "خادم الويب",
    '__service_title__smtp' => "خادم SMTP",
    '__service_description__smtp' => "خادم SMTP",
    '__service_title__mail' => "خادم IMAP/POP3",
    '__service_description__mail' => "خادم IMAP/POP3",
    '__service_title__dns' => "خادم DNS",
    '__service_description__dns' => "خادم DNS",
    '__service_title__postgresq' => "خادم قاعدة بيانات PostgreSQL",
    '__service_description__postgresq' => "خادم قاعدة بيانات PostgreSQL",
    '__service_title__spamassassin' => "خادم عوامل تصفية البريد العشوائي SpamAssassin",
    '__service_description__spamassassin' => "خادم عوامل تصفية البريد العشوائي SpamAssassin",
    '__services' => "خدمات",
    '__all_services' => "كل الخدمات",
    '__sessions' => "جلسات العمل",
    'sessions__feature_ftp_session_manager_not_supported' => "لا يدعم خادم FTP الحالي ميزة جلسات FTP",
    '__sessions_list' => "جلسات العمل",
    '__set' => "تشغيل",
    '__shared' => "مشترك",
    '__shell_access_warning' => "يُعد السماح بوصول الوعاء إلى النظام أمرًا في غاية الخطورة على أمان النظام. لا تسمح بالوصول إلى النظام إلا إذا كنت تفهم بوضوح ما تفعله وللمستخدمين الموثوق فيهم فقط. هل ترغب حقًا في السماح بالوصول؟",
    '__siteapp_not_support_in_key' => "لا يدعم مفتاح الترخيص تطبيقات الويب",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'تم تغيير تكوين تطبيق الويب هذا يدويًا. تم جعل إعادة التكوين عبر Plesk غير متوفرة لحماية التعديلات اليدوية.',
    '__site_management' => "‫نشر الويب‬", // indirect
    '__size' => "الحجم",
    '__skeleton' => 'قالب المضيف الظاهري',
    '__skins' => 'الأسطح',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "حالة خادم SMTP",
    '__some_fields_are_empty_or_invalid' => "بعض الحقول فارغة أو تحتوي على قيم غير مناسبة.",
    '__spamassassin' => "عامل تصفية البريد العشوائي",
    '__spamassassin_status' => "حالة SpamAssassin",
    '__spamd_status' => 'حالة عوامل تصفية البريد العشوائي',
    '__splited_backup' => "(النسخ الاحتياطي متعدد الوحدات)",
    '__split_backup_file' => "إنشاء النسخ الاحتياطي متعدد الوحدات",
    '__split_backup_size' => "حجم الوحدة",
    '__split_backup_less_than_500' => "أحجام الوحدة الأقل من 500 ميغابايت غير مدعومة",
    '__ssi' => "SSI",
    '__ssi_support' => "دعم SSI",
    '__ssi_with_html' => "استخدام SSI لملفات .htm*، وhtml.*",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "دعم SSL/TLS",
    '__same_ssl' => "استخدام دليل واحد لاستضافة محتوى SSL/TLS ومحتوى غير SSL/TLS",
    '__same_ssl_cu' => "محتوى SSL/TLS ومحتوى غير SSL/TLS شائع",
    '__state' => "الولاية/المقاطعة",

    '__status__Active' => '‫نشط‬',
    '__status__active' => 'نشط',
    '__status__Passive' => 'تم إيقاف التشغيل',
    '__status__passive' => 'تم إيقاف التشغيل',
    '__status__off' => 'تم إيقاف التشغيل',
    '__status__with_parent' => 'تم إيقاف التشغيل',
    '__status__backup_restore' => 'تم تعليقه مؤقتًا لغرض النسخ الاحتياطي أو الاسترداد',
    '__status__admin' => 'تم تعليقه من قبل مسؤول الخادم',
    '__status__resseler' => 'تم تعليقه من قبل بائع التجزئة',
    '__status__client' => 'تم تعليقه من قبل العميل',
    '__status__unknown' => 'الحالة غير معروفة',

    '__status_of' => "حالة 1%",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "خادم Stunnel", // indirect
    '__subdomain' => "المجال الفرعي",
    '__subdomain_name' => "اسم المجال الفرعي",
    '__subdomain_name_in_ASCII_form' => "اسم المجال الفرعي بتنسيق ASCII",
    '__subdomains' => "المجالات الفرعية",
    '__domainaliases' => "الأسماء المستعارة للمجالات",
    '__subdomains_list' => "المجالات الفرعية",
    '__subdomains_not_support_in_key' => "لا يدعم مفتاح الترخيص عمليات المجالات الفرعية",
    '__sys_user_type' => "مستخدم FTP",
    '__sys_user_type_main' => "استخدام حساب مستخدم FTP للمجال الرئيسي",
    '__sys_user_type_native' => "إنشاء حساب مستخدم FTP منفصل للمجال الفرعي هذا",
    '__t' => "تيرا",
    '__target_domain' => "المجال الهدف",
    '__template' => "قالب",
    '__template_not_accepted' => "تعذّر قبول القالب: تم تجاوز الحدود التالية.",
    '__templates' => "القوالب",
    '__templates_list' => "القوالب",
    '__tera' => "تيرا",
    '__title' => "‫العنوان‬",
    '__tools' => "أدوات",
    '__total' => "إجمالي 1%",
    '__total_size' => "الحجم الكلي",
    '__total_used' => "إجمالي المستخدَم",
    '__traffic' => "نسبة استخدام الشبكة",
    '__traffic_by_client' => "حركة مرور البيانات حسب العملاء",
    '__traffic_by_domain' => "حركة مرور البيانات حسب المجال",
    '__traffic_by_service' => "حركة مرور البيانات حسب الخدمة",
    '__traffic_history' => "سجل حركة مرور البيانات",
    '__unable_change_locale' => "تعذّر تغيير لغة الواجهة: 1%",
    '__unable_create_new_dom' => "تعذّر إنشاء مجال: 1%",
    '__unable_define_dom_name' => "تعذّر تحديد اسم المجال: 1%",
    '__unable_define_necessary_properties' => "تعذّر تحديد كل الخصائص المطلوبة.",
    '__unable_define_properties' => "تعذّر تحديد الخصائص: 1%",
    '__unable_exec_util' => "تعذّر تشغيل الأداة المساعدة: 1%",
    '__unable_get_dns_a_recs' => "تعذّر استرداد عناوين IP الخاصة بسجلات DNS لحساب الاستضافة هذا: 1%",
    '__unable_get_mbox_quota' => "تعذّر استرداد معلومات الحد الأقصى لحجم علبة البريد.",
    '__unable_redirect_to_myself' => "تعذّر التوجيه للحساب نفسه.",
    '__unable_redirect_to_my_alias' => "تعذّر توجيه البريد إلى الاسم المستعار للبريد.",
    '__default_domain_redirect_to_myself' => "تعذّر تعيين المجال كمجال افتراضي لعنوان IP: تم اكتشاف إعادة توجيهه لنفسه.",
    '__unable_remove_client' => "تعذرت إزالة العميل: 1%",
    '__unable_set_up_mbox_quota' => "يتعذّر تعيين الحد الأقصى لحجم علبة البريد للمجال: 1%",
    '__unable_setup_pass' => "تعذّر تعيين كلمة مرور: 1%",
    '__unable_to_create_new_account' => "تعذّر إنشاء حساب: 1%",
    '__unable_to_define_db_size' => "يتعذّر تحديد حجم قاعدة البيانات.",
    '__unable_to_enable_short_names' => "تعذر السماح باستخدام أسماء حسابات البريد القصيرة لحسابات POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "تعذّر إحضار البيانات المرسلة: 1%",
    '__unable_to_open_file' => "تعذّر فتح الملف 1%: %2",
    '__unable_to_update_subdomain' => "تعذّر إجراء تغييرات على المجال الفرعي: 1%",
    '__unable_update_cl_data' => "تعذّر حفظ التغييرات على حساب المستخدم: 1%",
    '__unable_update_db_params' => "تعذر تحديث معلمات قاعدة البيانات: 1%",
    '__unable_update_dom_data' => "تعذر تحديث بيانات المجال: 1%",
    '__undefined' => "غير محدد",
    '__uninstall' => "إلغاء تثبيت",
    '__unknown_error' => "خطأ غير معروف",
    '__unlimited_lower' => "غير محدود",
    '__unset' => "‫إيقاف التشغيل‬",
    '__update' => "تحديث",
    '__uploaded_file_is_invalid' => "الملف الذي تم تحميله غير صالح: 1%",
    '__url' => "‫عنوان URL‬",
    '__usage' => "استخدام القرص",
    '__user' => 'المستخدم',
    '__user_already_logged' => "سجّل مستخدم آخر باسم المستخدم نفسه (1%) الدخول بالفعل إلى Plesk.",
    '__version' => "الإصدار",
    '__aps_license' => "مفتاح الترخيص",
    '__vh_type' => "نوع المضيف الظاهري",
    '__vhosts_apache_status' => "حالة خادم الويب",
    '__wrong_charset_conversion' => 'مجموعة الأحرف غير صحيحة، لا يسمح بالتحويل من "1%" إلى "2%"',
    '__warning_' => "تحذير!",
    '__warning_excl_ip_num' => "عنوان IP مخصص",
    '__warning_expiration' => "تاريخ انتهاء الصلاحية",
    '__web_scripting' => "البرمجة النصية للويب", // indirect
    '__web_serv' => "خادم الويب", // indirect
    '__web_statistic' => "إحصائيات الويب", // indirect
    '__webmail' => "بريد الويب", // +indirect
    '__webstat_not_installed' => "لم يتم تثبيت Webalizer على الخادم. اتصل بموفر الخدمة لديك للحصول على المساعدة في تثبيت Webalizer.",
    '__webstat_support' => "إحصائيات الويب",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "عند التحويل من برنامج إحصائيات إلى آخر، فإن كل التقارير التي تم إنشاؤها عبر برنامج الإحصائيات السابق سيتم حذفها وسيتم إنشاء تقارير جديدة بالتوافق مع قراءة المعلومات من ملفات السجل المحفوظة على الخادم. وهذا يعني أنك إذا كوّنت النظام (على مجالات> اسم المجال> إدارة السجل> تدوير السجل) بحيث تحفظ ملفات السجل للشهر الماضي فقط، حينئذ ستتوفر إحصائيات الويب لهذا الشهر فقط. هل ترغب في التحويل إلى حزمة إحصاءات أخرى؟",
    '__webstat_perm_denied' => 'لا تمتلك الإذن لإدارة إحصائيات الويب.',
    '__webuser' => "مستخدم الويب",
    '__sysusers_list' => "مستخدمو النظام",
    '__sysuser' => "‫مُستخدِم النظام‬",
    '__weekly' => "أسبوعيًا",
    '__whats_new_in_version' => "ما الجديد في Plesk %1 ؟",
    '__wrong_hosting_type__none' => 'لا توجد استضافة ويب مُكوّنة على المجال 1%.',
    '__wrong_hosting_type__std_fwd' => 'يحتوي المجال 1% على إعادة توجيه قياسية مكونة. لا تتوفر هذه العملية إلا للمجالات المزودة باستضافة ويب.',
    '__wrong_hosting_type__frm_fwd' => 'يحتوي المجال 1% على إعادة توجيه إطار مكونة. لا تتوفر هذه العملية إلا للمجالات المزودة باستضافة ويب.',
    '__wu' => "مستخدمو الويب",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "تم تغيير البادئة WWW. احرص على تعديل شهادة SSL/TLS وفقًا لذلك.",
    '__year' => "سنة",
    '__year(s)' => "سنة (سنوات)",
    '__yes' => "‫نعم‬",
    '__you' => "أنت",
    '__zip_code' => "الرمز البريدي",
    '__form_normal' => "عادي",
    '__form_advanced' => "خيارات متقدمة",

    'admin_ed__edit_administrator_info' => "‫تحرير ملف تعريف المسؤول‬",
    'admin_ed__create_default_client' => "أريد إنشاء حساب عميل افتراضي.",
    'admin_ed__unable_update' => "يتعذر تحديث معلومات المسؤول: 1%",

    'auth__update_admin_info' => "يرجى إدخال معلومات مسؤول. هذه المعلومات مطلوبة لتشغيل 1%.",
    'auth__you_not_have_perm' => "ليس لديك إذن لإدارة هذا المجال.",
    'auth__key_expired_admin' => 'انتهت صلاحية ترخيص منصة Plesk الخاص بك. للاستمرار في استخدام منصة Plesk، قم بتجديد ترخيصك أو شراء ترخيصًا جديدًا.',
    'auth__key_expired_admin_restricted' => 'انتهت صلاحية ترخيص منصة Plesk الخاص بك. اتصل بمقدم الخدمة الذي تتعامل معه للاستمرار في استخدام منصة Plesk.',
    'auth__key_expired_client' => 'انتهت صلاحية ترخيص منصة Plesk. يرجى الاتصال بموفر خدمة الاستضافة لديك.',
    'autoinstaller__not_installed' => 'مكونات Autoinstaller غير مثبتة.',
    'autoinstaller__release_action' => 'العمليات المتوفرة',
    'autoinstaller__release_action_icon' => '‫S‬',
    'autoinstaller__release_action_upgrade' => 'الترقية إلى إصدار Plesk الجديد',
    'autoinstaller__release_action_update' => 'تحديث أو إضافة مكونات جديدة',
    'autoinstaller__release_action_up2date' => 'لديك إصدار مُحدَّث',
    'autoinstaller__component_action' => '‫الحالة‬',
    'autoinstaller__component_action_icon' => '‫S‬',
    'autoinstaller__component_action_install' => 'غير مثبت',
    'autoinstaller__component_action_update' => 'التحديثات متوفرة',
    'autoinstaller__component_action_upgrade' => 'تحديث واحد متوفر',
    'autoinstaller__component_action_up2date' => 'لديك إصدار مُحدَّث',
    'autoinstaller__component_action_error' => 'التحديثات غير متوفرة',
    'autoinstaller__component_serverbuildtime' => 'أحدث إصدار',
    'autoinstaller__component_localbuildtime' => 'الإصدار الخاص بك',
    'autoinstaller__component_installed_version' => 'النسخة الخاصة بك',
    'autoinstaller__component_available_version' => 'أحدث إصدار',
    'autoinstaller__component' => 'مكون',
    'autoinstaller__components' => 'مكونات',
    'autoinstaller__components_title' => 'مكونات 1%',
    'autoinstaller__component_dependency_note' => 'مطلوب لتثبيت المكونات التي حددتها',
    'autoinstaller__install_confirm' => 'نعم، أريد تثبيت هذه المكونات',
    'autoinstaller__install_confirm_request' => 'يرجى تحديد خانة الاختيار للتأكيد',
    'autoinstaller__install_title' => 'تأكيد تثبيت المكونات المحددة',
    'autoinstaller__key_update_confirm' => 'تأكيد تخطي تحديث المفتاح وتثبيت المفتاح الافتراضي',
    'autoinstaller__key_update_confirm_request' => 'يرجى تحديد خانة الاختيار للتأكيد.',
    'autoinstaller__key_update_failed' => '<p>يتعذر على Plesk تحديث ترخيص المنتج الخاص بك.</p><p>1%</p><p>ستؤدي متابعة الترقية دون الحصول على ترخيص منتج مناسب إلى تثبيت الترخيص الافتراضي بوظيفة محدودة. يُنصح المسؤولون بالحصول على مفتاح ترخيص مناسب أولًا قبل متابعة ترقية المنتج.</p>',
    'autoinstaller__email' => 'إرسال إخطار إلى',
    'autoinstaller__email_admin' => "البريد الإلكتروني للمسؤول",
    'autoinstaller__email_email' => 'عنوان البريد الإلكتروني المخصص...',
    'autoinstaller__release' => 'اسم الإصدار',
    'autoinstaller__releases' => 'الإصدارات المتوفرة',
    'autoinstaller__releases_title' => 'أداة تحديث Plesk',
    'autoinstaller__select_components_to_install' => 'تحديد المكونات المراد تثبيتها',
    'autoinstaller__status_error' => 'الخطأ: 1%',
    'autoinstaller__status_install_error' => 'يتعذر بدء التثبيت: 1%',
    'autoinstaller__status_install_busy' => 'يتعذر بدء التثبيت: يوجد تثبيت آخر قيد التشغيل حاليًا.',
    'autoinstaller__status_install_ok' => 'بَدَأَ التثبيت. سيتم إعلامك بتقدم التثبيت عبر البريد الإلكتروني (1%).',
    'autoinstaller__status_query_busy' => 'التثبيت قيد التقدم.',
    'autoinstaller__status_query_error' => 'يتعذر استرداد حالة التثبيت: 1%',
    'autoinstaller__status_unknown' => 'يتعذر استرداد حالة autoinstaller.',
    'autoinstaller__status_busy' => 'Autoinstaller مشغول، يرجى الانتظار.',
    'autoinstaller__configure_title' => 'إعدادات أداة التحديث',
    'autoinstaller__preferences_legend' => 'الإعدادات',
    'autoinstaller__target' => 'دليل التنزيل المؤقت',
    'autoinstaller__target_invalid' => "تحديد مسار مطلق",
    'autoinstaller__check_updates' => 'تحقق من التحديثات عند تسجيل دخول مسؤول إلى Plesk',
    'autoinstaller__check_updates_warning' => 'تتوافر <a href="%1">تحديثات</a> جديدة لـ 1%',
    'autoinstaller__source_type' => 'نوع المصدر',
    'autoinstaller__source' => 'عنوان URL للمصدر',
    'autoinstaller_source__preferences_legend' => 'الإعدادات',
    'autoinstaller_source__type' => 'نوع المصدر',
    'autoinstaller_source__url_invalid' => 'مصدر غير صالح',
    'autoinstaller_source__url_invalid_network' => 'عنوان URL للمصدر غير صالح (مثال: http://source، ftp://source)',
    'autoinstaller_source__url' => 'عنوان URL للمصدر',
    'autoinstaller__source_invalid_network' => 'لقد حددت عنوان شبكة غير صالح',
    'backup__repository' => 'موقع تخزين ملفات النسخ الاحتياطي',
    'backup__error_notify_email' => 'إذا حدثت أخطاء أثناء النسخ الاحتياطي، فأرسل إعلامًا إلى البريد الإلكتروني',
    'backup__dump_info' => "معلومات النسخ الاحتياطي",
    'backup__dump_file_name_not_defined' => "اسم ملف النسخ الاحتياطي غير محدد",
    'backup__local_file' => 'ملف النسخ الاحتياطي المحلي',
    'backup__domain_ftp' => 'خادم FTP البعيد',
    'backup__wrong_path' => "مسار غير صحيح إلى تخزين ملفات النسخ الاحتياطي: لا تستخدم تسلسل الأحرف ../../",
    'backup__unable_to_connect_to_ftp_server' => "تعذر الاتصال بخادم FTP: 1%",
    'backup__unable_to_read_file' => 'تتعذر قراءة ملف النسخ الاحتياطي.',
    'backup__backup_task_does_not_exist' => "مهمة النسخ الاحتياطي غير موجودة، يجب عليك إنشاؤها قبل التشغيل.",
    'backup__restore_params' => "معلّمات الاستعادة",
    'backup__confirmation' => "تحذير: لن يكون المجال متوفرًا أثناء النسخ الاحتياطي/الاستعادة.",
    'backup__backup_method' => 'طريقة النسخ الاحتياطي',
    'backup__dumpfile_name' => "اسم ملف النسخ الاحتياطي",
    'backup__dumpfile_name_is_invalid' => "اسم ملف النسخ الاحتياطي غير صالح: استخدم فقط الأحرف الأبجدية الرقمية ورموز الشرطة والنقاط والشرطة السفلية، لا تستخدم الأسماء كوصف.* مثل اسم ملف النسخ الاحتياطي.",
    'backup__email_required' => "بريدك الإلكتروني مطلوب لإبقائك على علم بتقدم النسخ الاحتياطي والاستعادة. يرجى تحديد بريدك الإلكتروني في تفاصيل الحساب.",
    'backup__error_during_backup' => "يتعذر إنشاء ملف النسخ الاحتياطي: 1%",
    'backup__input_email_warning' => "يجب عليك إما تحديد بريد إلكتروني للإعلام أو إلغاء تحديد خانة الاختيار.",
    'backup__make_download' => "لا تخزن ملف النسخ الاحتياطي في التخزين، فقط قم بتنزيله",
    'backup__make_dump' => 'إنشاء ملف نسخ احتياطي وتخزينه في التخزين المحلي',
    'backup__makedump_to_ftp' => 'إنشاء ملف نسخ احتياطي وتخزينه في خادم FTP البعيد',
    'backup__restore_ip' => "عنوان IP للاستعادة",
    'backup__select_dumpfile' => "تحديد ملف نسخ احتياطي.",
    'backup__time' => "وقت النسخ الاحتياطي",
    'backup__day' => 'يوم النسخ الاحتياطي',
    'backup__view_dump_info' => "عرض معلومات النسخ الاحتياطي للمجال 1%",
    'backup__wrong_domain_name' => "يحتوي ملف النسخ الاحتياطي على بيانات المجال %1 وبالتالي لا يمكن استعادتها على المجال 2%",
    'backup__incorrect_ftp_user_or_passwd' => "كلمة مرور أو مستخدم FTP غير صحيح. يرجى تصحيح خصائص حساب FTP",
    'backup__access_denied' => "تم رفض الوصول. يرجى تصحيح خصائص حساب FTP",
    'backup__restore_from' => "استعادة 1%",
    'backup__domain_session_failed' => 'لم يتم النسخ الاحتياطي للمجال 1%',
    'backup__client_session_failed' => 'لم يتم النسخ الاحتياطي للعميل 1%',
    'backup__domain_session_restore_failed' => 'لم تتم استعادة المجال 1%',
    'backup__client_session_restore_failed' => 'لم تتم استعادة حساب العميل 1%',
    'backup__domain_session_complete' => 'تم النسخ الاحتياطي للمجال 1%',
    'backup__domain_session_backup' => 'النسخ الاحتياطي للمجال 1%',
    'backup__client_session_backup' => 'النسخ الاحتياطي للعميل 1%',
    'backup__domain_stop_title' => 'جارٍ إلغاء النسخ الاحتياطي للمجال 1%',
    'backup__client_stop_title' => 'جارٍ إلغاء النسخ الاحتياطي لحساب العميل 1%',
    'backup__domain_restore_stop_title' => 'جارٍ إلغاء استعادة المجال 1%',
    'backup__client_restore_stop_title' => 'جارٍ إلغاء استعادة حساب العميل 1%',
    'backup__domain_session_backup_stop' => 'أنت على وشك إلغاء عملية النسخ الاحتياطي النشطة. لن يتم إنشاء ملف النسخ الاحتياطي.',
    'backup__backup_stop_confirm' => 'نعم، أرغب في إيقاف عملية النسخ الاحتياطي',
    'backup__restore_stop_confirm' => 'نعم، أريد إيقاف عملية الاستعادة',
    'backup__domain_session_restore' => 'استعادة المجال 1%',
    'backup__domain_session_restore_stop' => 'أنت على وشك إلغاء عملية الاستعادة النشطة.',
    'backup__domain_backup_file_info' => 'معلومات ملف النسخ الاحتياطي للمجال',
    'backup__domain_backup_file_list' => 'ملفات النسخ الاحتياطي الحالية',
    'backup__domain_backup_progress' => 'تقدم النسخ الاحتياطي لموقع الويب 1%',
    'backup__domain_restore_progress' => 'تقدم استعادة موقع الويب 1%',
    'backup__domain_backup_progress_elapsed_time' => 'الوقت المنقضي: 1%',
    'backup__domain_restore_progress_elapsed_time' => 'الوقت المنقضي: 1%',
    'backup__ip_map_legend' => 'تعيين IP',
    'backup__ip_map_list_count' => 'عناوين IP',
    'backup__domain_restore_session_complete' => 'تمت استعادة المجال 1%.',
    'backup__domain_restore_session_complete_message' => 'تمت استعادة المجال 1%.',
    'backup__domain_backup_file_delete' => 'ستتم إزالة ملفات النسخ الاحتياطي التالية:',
    'backup__domain_backup_file_for_remove' => 'حدد ملفات النسخ الاحتياطي التي تريد إزالتها',
    'backup__backup_overwrite_file_confirm' => 'تأكيد الاستبدال',
    'backup__backup_overwrite_file_confirm_text' => 'ملف النسخ الاحتياطي باسم "1%" موجود بالفعل. هل ترغب في استبداله؟',
    'backup__backup_confirm_overwrite' => 'تأكيد استبدال الملف',
    'backup__backup_overwrite_legeng' => 'استبدال',
    'backup__backup_not_contain_domain' => 'لا يحتوي ملف النسخ الاحتياطي على معلومات عن المجال 1%',
    'backup__backup_not_contain_client' => 'لا يحتوي ملف النسخ الاحتياطي على معلومات عن حساب العميل 1%',
    'backup__backup_client_info' => "النسخ الاحتياطي لإعدادات العميل وتفاصيل الحساب",
    'backup__client_backup_progress' => 'تقدم النسخ الاحتياطي لحساب العميل 1%',
    'backup__client_session_complete' => 'تم النسخ الاحتياطي لحساب العميل 1%',
    'backup__client_backup_file_info' => 'معلومات ملف النسخ الاحتياطي الخاص بالعميل',
    'backup__restore_client_info' => "استعادة إعدادات العميل وتفاصيل الحساب",
    'backup__client_session_restore' => 'جارٍ استعادة حساب العميل 1%',
    'backup__client_db_server_map' => 'تعيين خوادم قاعدة البيانات',
    'backup__domain_db_server_map' => 'تعيين خوادم قاعدة البيانات',
    'backup__client_restore_session_complete_message' => 'تمت استعادة حساب العميل 1%.',
    'backup__client_restore_session_complete' => 'تمت استعادة حساب العميل 1%.',
    'backup__restore_select_some' => 'يرجى تحديد الكائنات التي تريد استعادتها.',
    'backup__client_restore_progress' => 'تقدم استعادة حساب العميل 1%',
    'backup__new_backup' => 'إنشاء نسخ احتياطي جديد',
    'backup__done' => 'تم:',
    'backup__done_domains' => '1% مجال (مجالات) من 2%',
    'backup__done_clients' => '1% عميل (عملاء) من 2%',
    'backup__remaining' => 'المتبقي:',
    'backup__remaining_domains' => '1% من المجالات',
    'backup__remaining_clients' => '1% من العملاء',
    'backup__overall_backup_progress' => 'تقدم النسخ الاحتياطي الإجمالي',
    'backup__comment_n_a' => 'لا ينطبق',
    'backup__command_ignore' => 'تم تجاهل الأمر "1%"',
    'backup__no_objects' => 'لا توجد كائنات للنسخ الاحتياطي',
    'backup__cli_warning_not_enough_ip' => 'تحذير: لا توجد عناوين IP كافية لإجراء تعيين عنوان IP افتراضي:',
    'backup__local_repository' => "تخزين Plesk",
    'backup__ftp_repository' => 'مخزن FTP',
    'backup__ftp_login' => 'اسم المُستخدِم',
    'backup__ftp_password' => 'كلمة المرور',
    'backup__ftp_directory_hint' => 'مثال: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'إعدادات حساب FTP',
    'backup__ftp_account_preferences' => 'إعدادات حساب FTP',
    'backup__repository_not_exist' => 'الدليل غير موجود',
    'backup__repository_not_readable' => 'الدليل المحدد غير قابل للقراءة',
    'backup__ftp_repository_not_configure' => 'To use an FTP backup storage, <a href="%1">specify the FTP account</a> first.',
    'backup__ftp_repository_list_not_configure' => 'لم يتم تحديد إعدادات الحساب',
    'backup__repository_list_unable_listing' => 'تعذر استرداد قائمة الملفات',
    'backup__ftp_repository_unable_listing' => 'تعذر استرداد قائمة الدليل "1%":',
    'backup__repository_legend' => 'تخزين ملفات النسخ الاحتياطي',
    'backup__store_in_repository' => 'تخزين الملفات في',
    'backup__local_repository_lable' => 'التخزين المحلي',
    'backup__ftp_repository_lable' => 'مخزن FTP',
    'backup__ftp_repository_not_configure_hint' => '(لم يتم تحديد إعدادات الحساب)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(حساب FTP غير محدد أو غير معتمد)',
    'backup__ftp_directory_not_exist' => 'الدليل المحدد غير موجود',
    'backup__other_user_process_modified' => 'قام مستخدم آخر بإيقاف عملية النسخ الاحتياطي أو الترحيل.',
    'backup__another_user_exist' => 'تم بدء العملية قيد التقدم بواسطة مستخدم Plesk آخر. لا يزال هذا المتسخدم قيد تسجيل الدخول إلى Plesk.',
    'backup__ftp_repository_wait' => 'يرجي الانتظار أثناء استرداد معلومات عن تخزين FTP',
    'backup__ftp_write_test_failed' => 'Failed to write test data to the FTP account %1:',
    'bt_upload_to_repository' => 'تحميل الملفات على تخزين محلي',
    'bt_new_restore' => "استعادة",
    'bt_backup_schedule' => "جدولة نسخ احتياطي",
    'backup_exist_backups' => "ملفات النسخ الاحتياطي الحالية",
    'backup_dialog__page_title' => "إنشاء ملف النسخ الاحتياطي",
    'backup_dialog__please_wait' => "عملية النسخ الاحتياطي على وشك البدء. قد تستغرق العملية بعض الوقت. يُرجى الانتظار...",
    'backup_conf__page_title' => 'تكوين النسخ الاحتياطي',
    'bt_accept' => "قبول",
    'bt_access' => "الوصول",
    'bt_action_log' => "سجل الإجراء",
    'bt_add' => "إضافة",
    'bt_add_client' => "تعيين إلى المستخدمين",
    'bt_database_server_add' => 'إضافة خادم قاعدة البيانات',
    'bt_add_services' => "إضافة خدمة",
    'bt_anonftp_stats' => "إحصائيات Anon.FTP",
    'bt_anonymous_ftp' => "FTP مجهول",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "إرفاق",
    'bt_autoinstaller' => 'أداة التحديث',
    'bt_auto-updates' => 'أداة التحديث',
    'bt_back' => "<< رجوع",
    'bt_backup' => "نسخ احتياطي",
    'bt_backup_configure' => "إعدادات النسخ الاحتياطي",
    'bt_buy_certs' => "شراء الشهادات",
    'bt_card' => "بطاقة",
    'bt_cert' => "الشهادة",
    'bt_certificates' => "الشهادات",
    'bt_change_passwd' => "تغيير كلمة المرور",
    'bt_clear' => "مسح",
    'bt_client_templates' => "قوالب العميل",
    'bt_clients' => "العملاء",
    'bt_codepage_change' => 'تغيير الترميز',
    'bt_comp_info' => "إدارة المكونات",
    'bt_configure_maillists' => "إعداد Mailman",
    'bt_configure_odbc' => "مصادر بيانات ODBC",
    'bt_configure' => 'تكوين',
    'bt_copy' => "نسخ",
    'bt_copy_move' => "نسخ / نقل",
    'bt_create' => "إنشاء",
    'bt_create_account' => "إنشاء حساب",
    'bt_create_dir' => "إضافة دليل",
    'bt_create_file' => "إضافة ملف",
    'bt_count_size' => "حساب الحجم",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "مجدول مهام",
    'bt_custom_button_new' => "إضافة زر",
    'bt_custom_buttons' => "أزرار مخصصة",
    'bt_customize' => "تخصيص",
    'bt_databases' => "قواعد البيانات",
    'bt_database_servers' => 'خوادم قاعدة البيانات',
    'bt_sqlservers' => "خوادم قاعدة البيانات",
    'bt_db_usr_new' => "إضافة مستخدم قاعدة البيانات",
    'bt_db_new' => "إضافة قاعدة بيانات",
    'bt_db_phpmyadmin' => "مسؤول MySQL",
    'bt_dbuser_default' => "تعيين افتراضي لـ DB Webadmin",
    'bt_decline' => "رفض",
    'bt_default' => "افتراضي",
    'bt_defaultcomponents' => "خدمات الطرف الثالث",
    'bt_defaults' => "الإعدادات الافتراضية",
    'bt_delete' => "حذف",
    'bt_directories' => "أدلة محمية",
    'bt_disable' => "إيقاف التشغيل",
    'bt_dns' => "إعدادات DNS",
    'bt_dns_enable' => 'تمكين',
    'bt_dns_disable' => 'تعطيل',
    'bt_dns_default' => 'إعادة التعيين إلى الافتراضي',
    'bt_dns_zone_sync' => 'تطبيق تغييرات قالب DNS',
    'bt_dnsrecord_add' => 'إضافة سجل',
    'bt_do_backup' => "نسخ احتياطي",
    'bt_do_restore' => "استعادة",
    'bt_do_upload' => "تحميل",
    'bt_domain_aliases' => "الأسماء المستعارة للمجالات",
    'bt_domain_templates' => "قوالب المجال",
    'bt_domain_user' => "مسؤول المجال",
    'bt_domain_user_passwd' => "كلمة مرور مسؤول المجال",
    'bt_domains' => "المجالات",
    'bt_domain_alias_add' => 'إضافة اسم مستعار للمجال',
    'bt_download' => "تنزيل",
    'bt_edit' => "‫تحرير‬",
    'bt_enable' => "تشغيل",
    'bt_export' => 'تصدير',
    'bt_extras' => "إضافات",
    'bt_file_manager' => "إدارة الملفات",
    'bt_finish' => "إنهاء",
    'bt_ftp_account' => "خصائص حساب FTP",
    'bt_forget_password' => "هل نسيت كلمة المرور؟",
    'bt_fp_ssl_webadmin' => "مسؤول ويب FP-SSL/TLS",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "إحصائيات FTP",
    'bt_get_password' => "الحصول على كلمة المرور",
    'bt_global_changes' => "تعديل",
    'bt_help' => "المساعدة",
    'bt_hide_aliases' => "إخفاء الأسماء المستعارة",
    'bt_hide_toolbar' => 'إخفاء شريط الأدوات',
    'bt_hide_subdomains' => "إخفاء المجالات الفرعية",
    'bt_hide_domainaliases' => "إخفاء الأسماء المستعارة للمجال",
    'bt_home' => "الصفحة الرئيسية",
    'bt_hosting' => "الاستضافة",
    'bt_icf' => 'جدار الحماية',
    'bt_install' => "تثبيت",
    'bt_ip_aliasing' => "عناوين IP",
    'bt_ip_add' => "إضافة عنوان IP",
    'bt_ip_pool' => "تجمع IP",
    'bt_key_info' => "معلومات الترخيص",
    'bt_key_buyonline_addons' => 'طلب وظائف إضافية لـ Plesk',
    'bt_key_buyonline_upgrades' => 'طلب ترقيات Plesk',
    'bt_key_buyonline_new' => 'طلب مفتاح جديد',
    'bt_limits' => "الحدود",
    'bt_locale_add' => 'إضافة موقع',
    'bt_locales' => 'المواقع',
    'bt_log_manager' => "إدارة السجل",
    'bt_login' => "تسجيل الدخول",
    'bt_login_vzpp' => "تسجيل الدخول إلى لوحة الطاقة",
    'bt_logo' => "إدراج العلامة التجارية",
    'bt_logo_send_link' => "إرفاق رابط",
    'bt_logo_send_logo' => "إرفاق شعار",
    'bt_logout' => "تسجيل الخروج",
    'bt_logrotation' => "تناوب التسجيل",
    'bt_mail' => "البريد",
    'bt_mail_alias_add' => "إضافة اسم بريد مستعار",
    'bt_mail_aliases' => "الأسماء المستعارة للبريد",
    'bt_mail_group_add' => "إضافة عضو",
    'bt_mail_groups' => "مجموعات",
    'bt_mail_name_add' => "إضافة حساب بريد",
    'bt_mail_preferences' => "الإعدادات",
    'bt_mail_group' => "مجموعة البريد",
    'bt_mail_mailbox' => "علبة البريد",
    'bt_mail_redirect' => "أداة التوجيه",
    'bt_mail_resp_add' => "إضافة رد تلقائي",
    'bt_mail_resp_attach_add' => "إضافة مرفق",
    'bt_mail_resp_files' => "ملفات المرفقات",
    'bt_mail_responders' => "الردود التلقائية",
    'bt_mail_spamfilter' => "عامل تصفية البريد العشوائي",
    'bt_mail_webmail' => "بريد الويب",
    'bt_maillist_new' => "إضافة قائمة مراسلات",
    'bt_maillists' => "القوائم البريدية",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "إنشاء نسخ احتياطي",
    'bt_manage' => "إدارة",
    'bt_master' => "رئيسي",
    'bt_migrate' => 'ترحيل',
    'bt_modules_add' => 'إضافة ملحق',
    'bt_modules_manage' => 'إدارة الملحقات',
    'bt_move' => "النقل",
    'bt_mimetypes' => 'أنواع MIME',
    'bt_mimetype_new' => 'إضافة نوع MIME',
    'bt_new_client' => "إضافة حساب عميل",
    'bt_new_domain' => "إضافة نطاق",
    'bt_next' => "التالي>>",
    'bt_next_page' => "التالي",
    'bt_network_add' => "‫إضافة شبكة‬",
    'bt_notifications' => "الإشعارات",
    'bt_odbc_dsn_add' => "إضافة ODBC DSN",
    'bt_off' => "إيقاف تشغيل",
    'bt_on' => "تشغيل",
    'bt_on_off' => "تشغيل / إيقاف تشغيل",
    'bt_pd_new' => "إضافة دليل محمي",
    'bt_pd_user_new' => "إضافة مستخدم",
    'bt_performance' => 'الأداء',
    'bt_permissions' => "الأذونات",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "‫PostgreSQL‬",
    'bt_preferences' => "الإعدادات",
    'bt_prev_page' => "معاينة",
    'bt_preview' => 'معاينة الموقع',
    'bt_print' => "طباعة",
    'bt_reboot' => "إعادة التمهيد",
    'bt_reload' => "إعادة تحميل",
    'bt_refresh' => "تحديث",
    'bt_register' => "تسجيل",
    'bt_remove' => "إزالة",
    'bt_enable_selected' => 'تشغيل',
    'bt_disable_selected' => 'إيقاف التشغيل',
    'bt_repair_ip' => "إصلاح IP",
    'bt_report' => "تقرير",
    'bt_report_auto' => 'تسليم التقرير',
    'bt_report_auto_new' => 'إضافة جدول تسليم',
    'bt_report_new' => "إضافة تخطيط",
    'bt_reset' => "إعادة الضبط",
    'bt_restart_services' => "إدارة الخدمات",
    'bt_save' => "‫حفظ‬",
    'bt_send_by_email' => "إرسال عن طريق البريد الإلكتروني",
    'bt_send_file' => "إرسال ملف",
    'bt_send_mail' => "إرسال رسالة بريد",
    'bt_send_passwd' => "إرسال كلمة مرور",
    'bt_send_text' => "إرسال نص",
    'bt_server' => "الخادم",
    'bt_server_add' => "إضافة خادم",
    'bt_server_preferences' => "إعدادات الخادم",
    'bt_servers_list' => "الخوادم",
    'bt_sessions' => "جلسات العمل",
    'bt_set' => "تعيين",
    'bt_set_as_default' => "تعيين كافتراضي",
    'bt_setup' => 'الإعداد',
    'bt_show_aliases' => "إظهار الأسماء المستعارة",
    'bt_show_subdomains' => "إظهار المجالات الفرعية",
    'bt_show_domainaliases' => "إظهار الأسماء المستعارة للمجال",
    'bt_shutdown' => "إيقاف تشغيل",
    'bt_site_apppkgs' => "مخزن التطبيقات",
    'bt_site_apppool' => "تجمع التطبيق",
    'bt_application-pool' => "تطبيقات الويب",
    'bt_site_apps' => "تطبيقات الويب",
    'bt_site_app_add' => "تثبيت التطبيق",
    'bt_site_builder' => "دعم Presence Builder",
    'bt_skeleton' => 'قالب المضيف الظاهري',
    'bt_skins' => 'الأسطح',
    'bt_skin_add' => 'إضافة سطح',
    'bt_skin_manual' => 'مرجع أسطح Plesk المخصصة', // not used
    'bt_skin_download' => 'تنزيل سطح',
    'bt_skin_replace' => 'تحديث السطح',
    'bt_skip' => 'تخطٍ',
    'bt_spamassassin' => "عامل تصفية البريد العشوائي",
    'bt_spamassassin_train' => "تدريب",
    'bt_spamfilter' => "عامل تصفية البريد العشوائي",
    'bt_sshterm' => 'الطرف SSH',
    'bt_start' => "بدء",
    'bt_stop' => "إيقاف",
    'bt_recycle' => "إعادة الاستخدام",
    'bt_statistics' => "إحصائيات",
    'bt_subdomain_new' => "إضافة مجال فرعي",
    'bt_subdomains' => "المجالات الفرعية",
    'bt_submit' => "إرسال",
    'bt_summary_report' => "تقرير التلخيص",
    'bt_support' => "الدعم",
    'bt_switch' => "تبديل",
    'bt_system_time' => "وقت النظام",
    'bt_task_new' => "إضافة مهمة",
    'bt_dom_tmpl_add' => 'إضافة قالب مجال',
    'bt_cl_tmpl_add' => 'إضافة قالب عميل',
    'bt_cron_backup' => 'إعدادات النسخ الاحتياطي المجدول',
    'bt_test' => "اختبار الاتصال",
    'bt_text' => "النص",
    'bt_touch' => "تغيير الطابع الزمني",
    'bt_traffic' => "نسبة استخدام الشبكة",
    'bt_traffic_history' => "سجل حركة مرور البيانات",
    'bt_update' => "تحديث",
    'bt_upload' => "تحميل",
    'bt_upload_from_ftp' => "تحميل FTP",
    'bt_virtualdirs' => 'أدلة ظاهرية',
    'bt_virtualdir_new' => 'إضافة دليل ظاهري',
    'bt_virtualdir_add' => 'إضافة دليل ظاهري',
    'bt_web_app_new' => "تثبيت تطبيق Java",
    'bt_web_stats' => "إحصائيات الويب",
    'bt_web_stats_ssl' => "إحصائيات SSL/TLS للويب",
    'bt_web_user_add' => "إضافة مستخدم ويب",
    'bt_web_users' => "مستخدمو الويب",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "إعدادات إحصائيات الويب",
    'bt_hidden-referrer-add' => 'إخفاء الإدخالات',
    'bt_group-referrer-add' => 'مراجع مجمعة',
    'bt_whats_new_full' => "اطلع على قائمة التغييرات الكاملة",
    'cert_add__unable_set_ca_cert' => "يتعذر تعيين شهادة CA: 1%",
    'cert_add__unable_set_cert' => "يتعذر تعيين الشهادة: 1%",
    'cert_add__unable_set_private_key' => "يتعذر تعيين المفتاح الخاص: 1%",
    'certificates_list__certificate_used_as_default' => "تُستخدَم إحدى الشهادات التي ستقوم بحذفها كالشهادة الافتراضية.",
    'certificates_list__certificates_assigned_on_ip' => "تم تعيين شهادة أو عدة شهادات لعناوين IP / المجالات.",
    'ch_pass__admin_pass' => "‫تغيير كلمة مرور المسؤول‬",
    'ch_pass__old_pass' => "‫كلمة المرور القديمة‬",
    'ch_pass__pass_confirm' => "تأكيد",
    'ch_pass__unable_change_admin_pass' => "يتعذر تغيير كلمة مرور المسؤول: %1",
    'check_mail_cycle__aliases' => "تم اكتشاف تكرار في البريد، تم احتواء العنوان \"\\1%\"\\ في الأسماء المستعارة لحساب البريد هذا.",
    'check_mail_cycle__autoresponders' => "تم اكتشاف تكرار في البريد، تم احتواء العنوان \"\\1%\"\\ في الردود التلقائية لحساب البريد هذا.",
    'check_mail_cycle__mail_groups' => "تم اكتشاف تكرار في البريد، تم احتواء العنوان \"\\1%\"\\ في مجموعة البريد لحساب البريد هذا.",
    'check_mail_cycle__mail_name' => "تم اكتشاف تكرار في البريد، يطابق العنوان \"\\1%\"\\ حساب البريد هذا.",
    'check_mail_cycle__redirect' => "تم اكتشاف تكرار في البريد، يطابق العنوان\"\\1%\"\\ أداة التوجيه في حساب البريد هذا.",
    'check_mail_dup__redirect' => "تم اكتشاف تكرار إعادة توجيه، يطابق العنوان \"\\1%\"\\ عنوان التوجيه في حساب البريد هذا.",
    'check_mail_dup__mail_groups' => "تم اكتشاف تكرار في التوجيه، تم احتواء العنوان  \"\\1%\"\\ في مجموعة البريد لحساب البريد هذا.",
    'check_maillist_cycle__admin' => "تم اكتشاف دورة بريد، يتزامن البريد الإلكتروني \"\\%1\"\\ للمسؤول مع عنوان قائمة المراسلة.",
    'check_maillist_cycle__member' => "تم اكتشاف دورات بريد، يتزامن عنوان البريد الإلكتروني  \"\\1%\"\\ مع عنوان القائمة البريدية.",
    'chk_js__enter_login_and_passwd' => "أدخل اسم مستخدم وكلمة مرور.",
    'chk_js__enter_login_name' => "أدخل اسم مستخدم.",
    'chk_js__enter_passwd' => "إدخال كلمة المرور.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "تفاصيل الحساب %1",
    'cl_limits__cl' => "حدود العميل %1",
    'cl_logo__setup_logo_pref' => "إعداد خصائص الشعار للعميل 1%",
    'cl_new__enter_new_cl_data' => "أدخل المعلومات حول العميل الجديد",
    'cl_new__unable_to_sent_notification' => 'تم إنشاء حساب المستخدم، ومع ذلك فشل إرسال إشعار للعميل: 1%',
    'cl_perm__all_ip' => "جميع عناوين IP المتوفرة",
    'cl_perm__all_ip_based_hst_will_be_nb' => "سيتم تحويل جميع حسابات الاستضافة الخاصة بالعميل القائمة على عناوين IP إلى حسابات تعتمد على الاسم.",
    'cl_perm__allow_client_create_domain' => "الحقول التي تحاول تحديدها تنطبق على العملاء المسموح لهم بإنشاء مجالات فقط.",
    'cl_perm__allow_create_nb_w_ip' => "يمكن أن ينشئ العميل استضافة قائمة على الاسم باستخدام 1%",
    'cl_perm__allow_creation_ip_based_hosting' => "السماح بإنشاء حسابات استضافة قائمة على عناوين IP",
    'cl_perm__available_ips' => "عناوين IP المتوفرة",
    'cl_perm__change_limits' => "تعديل الحدود",
    'cl_perm__cl_disk_space' => "إجمالي مساحة القرص المتوفرة",
    'cl_perm__cl_expiration' => "فترة صلاحية حساب العميل",
    'cl_perm__cl_max_box' => "علب البريد",
    'cl_perm__cl_max_db' => "قواعد البيانات",
    'cl_perm__cl_max_dom' => "المجالات",
    'cl_perm__cl_max_maillists' => "قوائم المراسلة",
    'cl_perm__cl_max_subdom' => "المجالات الفرعية",
    'cl_perm__cl_max_traffic' => "المقدار الإجمالي لنسبة استخدام الشبكة المتوفر",
    'cl_perm__cl_max_wu' => "مستخدمو الويب",
    'cl_perm__cl_mbox_quota' => "حد حجم علبة البريد لحساب المستخدم هذا",
    'cl_perm__current_maximum_exp_date' => "تبلغ القيمة القصوى الحالية لفترة صلاحية المجال 1%؛ والمطلوب 2%.",
    'cl_perm__current_maximum_mailbox_quota' => "يبلغ الحد المحدد حاليًا على مقدار مساحة القرص المخصص لاستضافة علب البريد ضمن حساب المستخدم هذا 1%؛ والمطلوب 2%",
    'cl_perm__current_total_requested' => "إجمالي القيمة الحالية لحدود المجال الخاص بـ 1% تبلغ 2%؛ والمطلوب 3%.",
    'cl_perm__current_total_requested_dom' => "العدد الحالي لـ 1% التي تنتمي إلى هذا العميل يبلغ 2%؛ والمطلوب 3%.",
    'cl_perm__disk_space' => "الحد الأقصى لمساحة القرص",
    'cl_perm__dashboard_stdgui' => 'واجهة المستخدم',
    'cl_perm__dashboard' => 'عرض الصفحة الرئيسية',
    'cl_perm__stdgui' => 'طريقة العرض القياسية',
    'cl_perm__manage_dashboard' => 'إدارة الصفحة الرئيسية',
    'cl_perm__dashboard_and_stdgui' => 'مسموح بعرض الصفحة الرئيسية والعرض القياسي',
    'cl_perm__dashboard_only' => 'مسموح بعرض الصفحة الرئيسية فقط',
    'cl_perm__stdgui_only' => 'لا يُسمح إلا بطريقة العرض القياسية',
    'cl_perm__edit_cl' => "أذونات العميل %1",
    'cl_perm__exp_date_exceeded' => "تتجاوز فترة السماح التي تحاول تعيينها الحد المحدد ضمن المجالات الفردية الخاصة بهذا العميل.",
    'cl_perm__invalid_value' => "قيمة غير صالحة، يسمح بالأرقام فقط.",
    'cl_perm__limit_disk_space' => "1% تحديد المقدار الإجمالي لمساحة القرص",
    'cl_perm__limit_expiration' => "1% تحديد فترة صلاحية حساب العميل",
    'cl_perm__limit_max_box' => "1% تحديد أقصى عدد لعلب البريد",
    'cl_perm__limit_max_db' => "1% تحديد أقصى عدد لقواعد البيانات",
    'cl_perm__limit_max_dom' => "1% تحديد أقصى عدد للمجالات",
    'cl_perm__limit_max_maillists' => "1% تحديد أقصى عدد للقوائم البريدية",
    'cl_perm__limit_max_subdom' => "1% تحديد أقصى عدد للمجالات الفرعية",
    'cl_perm__limit_max_traffic' => "1% تحديد المقدار الإجمالي لنسبة استخدام الشبكة",
    'cl_perm__limit_max_wu' => "1% تحديد أقصى عدد لمستخدمي الويب",
    'cl_perm__limit_mbox_quota' => "1% تحديد حصة علبة البريد",
    'cl_perm__limits_exceeded' => "تجاوز أحد الحدود التي تحاول تعيينها أو العديد منها الحدود المحددة بالفعل داخل المجالات الفردية الخاصة بهذا العميل. يجب أن يكون إجمالي الحد الخاص بالعميل أكبر من إجمالي مجموع حدود المجال المحددة لحساب العميل هذا أو يساويه.",
    'cl_perm__mailbox_quota_exceeded' => "يتجاوز حد مساحة القرص المخصصة لعلب البريد الذي تحاول تعيينه الحد المحدد ضمن المجالات الفردية المرتبطة بحساب العميل هذا.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "حد كمية مساحة القرص المخصصة لعلب البريد الذي تحاول تعيينه يتجاوز الحد المفروض على مستوى الخادم.",
    'cl_perm__make_dumps' => "النسخ الاحتياطي واستعادة البيانات",

    'cl_perm__max_box' => "أقصى عدد لعلب البريد",
    'cl_perm__max_db' => "أقصى عدد لقواعد البيانات",
    'cl_perm__max_dom' => "المجالات",
    'cl_perm__max_maillists' => "أقصى عدد لقوائم المراسلات",
    'cl_perm__max_subdom' => "المجالات الفرعية",
    'cl_perm__max_traffic' => "أقصى مقدار لنسبة استخدام الشبكة",
    'cl_perm__max_wu' => "أقصى عدد لمستخدمي الويب",
    'cl_perm__max_dom_aliases' => "الأسماء المستعارة للمجالات",
    'cl_perm__mbox_quota' => "حصة علبة البريد",
    'cl_perm__not_allow_create_nb_hst' => "لا يمكن للعميل إنشاء استضافة قائمة على الاسم.",
    'cl_perm__select_ip_addrs' => "تحديد عناوين IP",
    'cl_perm__this_ip_used_vrt_hst' => "تستخدم الاستضافة الظاهرية عنوان IP هذا. لحذف عنوان IP هذا، قم بإزالة خدمة الاستضافة أو تغيير نوعها إلى استضافة قائمة على الاسم.",
    'cl_perm__unable_off_ipb_creating' => "يتمتع العميل بالفعل بإعداد خدمة استضافة قائمة على IP. لإلغاء تنشيط هذه الميزة للعميل، قم بإلغاء تحديد خانة الاختيار \"إنشاء المجال\" أو قم بإزالة جميع حسابات الاستضافة القائمة على IP.",
    'cl_perm__unable_off_nb_creating' => "يتمتع العميل بالفعل بإعداد خدمة الاستضافة القائمة على الاسم. لإلغاء تنشيط هذه الميزة للعميل، قم بإلغاء تحديد خانة الاختيار \"إنشاء المجال\" أو قم بإزالة جميع حسابات الاستضافة القائمة على الاسم.",
    'cl_perm__unable_set_domain_limit' => "يتعذر وضع حد لأقصى عدد من المجالات: العميل لديه بالفعل 1% من المجالات",
    'cl_perm__unable_update_client_limitations' => "يتعذر تعديل حدود حساب العميل: 1%",
    'cl_pref__edit_cl' => "تفضيلات العميل %1",
    'class_anonftp__create_ftp_domain' => "لا يوجد مجال FTP ظاهري لـ dom_id، جرب إنشاءه أولًا.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "يجب ألا يتجاوز حد مساحة القرص الذي تحاول إعداده (1%) حد مساحة القرص الكلية المحددة في مستوى المجال (2%).",
    'class_anonftp__invalid_input_only_digits' => "القيمة المحددة غير صالحة، يسمح بالأرقام فقط.",
    'class_anonftp__unable_change_ownerships' => "يتعذر تغيير ملكية أو أذونات ملف الحصة: 1%",
    'class_anonftp__unable_copy_quota_file' => "يتعذر نسخ ملف الحصة: 1%",
    'class_anonftp__unable_get_disk_usage' => "يتعذر استرداد معلومات استخدام القرص في الدليل الوارد: 1%",
    'class_anonftp__unable_parse_quota_file' => "يتعذر تحليل ملف الحصة.",
    'class_anonftp__unable_read_quota_file' => "تتعذر قراءة ملف الحصة: 1%",
    'class_anonftp__unable_update_quota' => "يتعذر تحديث الحصة: تستخدم الملفات في الدليل الوارد %1 كيلو بايت من مساحة القرص، وهذا يتجاوز قيمة الحصة الجديدة.",
    'class_anonftp__unable_write_temp_file' => "تتعذر الكتابة في الملف المؤقت: 1%",
    'class_bsdomain__warn_max_date__' => "تم تعيين تاريخ انتهاء الصلاحية على 1%",
    'class_cList__empty' => "لا توجد عناصر.",
    'class_cList__header' => "1% (2%)",
    'class_cList__not_found' => "لا توجد نتائج مطابقة لـ <b> \"\\1%\"\\</b> في 2% (3% من 4%).",
    'class_cList__search_result' => "البحث عن نتائج لـ <b> \"\\1%\"\\</b> في %2 (%3 من %4).",
    'class_client__client_creation_notification' => "ملاحظة إنشاء العميل.",
    'class_client__client_with_contact_name_already_exists' => "العميل بالاسم 1% موجود بالفعل.",
    'class_client__disk_space' => "مساحة القرص",
    'class_client__invalid_max_dom' => "عدد قيمة مجالات غير صحيح، يسمح بالأرقام فقط.",
    'class_client__limit_exceed' => "لا يمكن تخصيص المساحة المطلوبة %1 لأن هذا قد يتجاوز حصص حساب (%3) العميل 2%. إذا أردت تعيين المزيد من الموارد، فانتقل إلى العملاء> اسم العميل> الحدود ثم قم بتغيير الحصص كما هو مطلوب. ارجع بعد ذلك إلى هذه الشاشة ثم حاول تعديل الحصص مرة أخرى.",
    'class_client__limit_exceed_unlimited' => "إذا أردت تخصيص مساحة غير محدودة للموارد (1%)، فيجب عليك أن تنتقل إلى العملاء> اسم العميل> الحدود، ثم حدد خانة الاختيار \"غير محدودة\" المقابلة لنوع المورد المطلوب. ارجع بعد ذلك إلى هذه الشاشة ثم حاول تعديل الحصص مرة أخرى.",
    'class_client__max_box' => "علب البريد",
    'class_client__max_db' => "قواعد البيانات",
    'class_client__max_maillists' => "قوائم المراسلة",
    'class_client__max_subdom' => "المجالات الفرعية",
    'class_client__max_traffic' => "أقصى عدد زيارات",
    'class_client__max_wu' => "مستخدمو الويب",
    'class_client__max_dom_aliases' => "الأسماء المستعارة للمجالات",
    'class_client__mbox_quota' => "حصة علبة البريد",
    'class_client__unable_define_cl_status' => "يتعذر تحديد حالة حساب العميل: 1%",
    'class_client__unable_define_inactive_dom' => "يتعذر تحديد المجالات غير النشطة 1%.",
    'class_client__unable_del_ip' => "تعذرت إزالة عناوين IP: 1%",
    'class_db__db_name_not_set' => "لم يتم تحديد اسم قاعدة البيانات.",
    'class_db__db_not_exist_for_curr_dom' => "قاعدة البيانات الخاصة بهذا المجال غير موجودة.",
    'class_db__invalid_db_or_dom_name' => "معرّف المجال أو قاعدة البيانات غير صالح أو لم يتم تحديد اسم قاعدة البيانات.",
    'class_db__invalid_pass' => "كلمة المرور غير صالحة.",
    'class_db__mailgrp_member_exist' => "عضو مجموعة البريد موجود بالفعل.",
    'class_db__access_hosts_notsupport' => 'إعداد مضيفي الوصول غير معتمد لنوع قاعدة البيانات هذه',
    'class_db__unable_add' => 'تتعذر إضافة سجل مضيف وصول: 1%',
    'class_db__unable_del' => 'يتعذر حذف سجل مضيف وصول: 1%',
    'class_db__inc_user_not_exist' => 'مستخدم قاعدة البيانات "1%" غير موجود',
    'class_db__inc_access_record_exist' => 'سجل الوصول هذا موجود بالفعل',
    'class_db__inc_access_record_not_exist' => 'سجل الوصول المحدد غير موجود',
    'class_db__inc_unable_del_last_record' => 'يتعذر حذف سجل مضيف الوصول الأخير',
    'class_domtmpleditform__dns_master' => "رئيسي",
    'class_domtmpleditform__dns_slave' => "تابع",
    'class_domtmpleditform__dns_type' => "نوع منطقة مجال DNS",
    'class_traffichistory__no_data_available' => "لا تتوفر أي بيانات.",
    'class_traffichistory__reten_pref' => 'إعدادات الاحتفاظ بإحصائيات الويب ونسبة استخدام الشبكة',
    'class_traffichistory__traffic_usage' => "استخدام حركة مرور البيانات",
    'clienttrafficlist_header' => "نسبة استخدام الشبكة في المجالات",
    'clienttrafficlist_header_of_client__' => "نسبة استخدام الشبكة في مجالات العميل 1%",
    'cmd_dns__a_dns_record_already_exist' => "سيتعارض هذا السجل مع سجل A الخاص بالمنطقة.",
    'cmd_dns__domain_last_ns' => 'لا يمكن حذف آخر سجل NS DNS للنطاق.',
    'cmd_dns__canonical_dom_name_is_invalid' => "اسم المجال المتعارف عليه غير صالح.",
    'cmd_dns__cname_dns_record_already_exist' => "سيتعارض هذا السجل مع سجل CNAME الخاص بالمنطقة.",
    'cmd_dns__cname_in_rr_combination' => 'توجد مجموعة غير صحيحة لسجلات DNS في منطقة DNS',
    'cmd_dns__cname_coexist_with_data' => 'يتعذر وجود سجل منطقة CNAME DNS مع سجلات DNS الأخرى في المنطقة ذاتها.',
    'cmd_dns__dns_record_type_is_invalid' => "نوع سجل DNS غير صالح.",
    'cmd_dns__ext_host_is_not_resolved' => "لا يتم حل الاسم المتعارف عليه %1 إلى أحد السجلات A أو AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'تتعذر إضافة سجل 1% إلى المنطقة 2%: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "اسم مبادل البريد غير صالح.",
    'cmd_dns__mx_priority_is_invalid' => "أولوية MX غير صالحة.",
    'cmd_dns__name_server_is_invalid' => "خادم الاسم غير صالح.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "ينبغي أن تكون قيمة قناع الشبكة 24 أو 16 أو 8.",
    'cmd_dns__this_dns_record_already_exists' => "سجل DNS هذا موجود بالفعل.",
    'cmd_dns__unable_add_record' => "تتعذر إضافة سجل '\\1%'\\: %2",
    'cmd_dns__unable_add_a_record' => "تتعذر إضافة سجل A: 1%",
    'cmd_dns__unable_add_cname_record' => "تتعذر إضافة سجل CNAME: 1%",
    'cmd_dns__unable_add_dns_record' => "تتعذر إضافة سجل DNS: 1%.",
    'cmd_dns__unable_add_ext_ns_record' => "تتعذر إضافة سجل EXT_NS: 1%",
    'cmd_dns__unable_add_ns_record' => "تتعذر إضافة سجل NS: 1%",
    'cmd_dns__unable_add_ptr_record' => "تتعذر إضافة سجل PTR: 1%",
    'cmd_dns__unable_add_txt_record' => "تتعذر إضافة سجل TXT: 1%",
    'cmd_dns__unable_create_dns_zone' => "تعذر إنشاء منطقة DNS %1",
    'cmd_dns__unable_define_dns_record' => "يتعذر تحديد منطقة DNS ‏%1",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "يتعذر استرداد حالة منطقة DNS الافتراضية: 1%",
    'cmd_dns__unable_insert_a_record' => "يتعذر إدراج سجل A: 1%",
    'cmd_dns__unable_insert_mx_record' => "يتعذر إدراج سجل MX: 1%",
    'cmd_dns__unable_insert_ns_record' => "يتعذر إدراج سجل NS: 1%",
    'cmd_dns__unable_set_dns_zone_status' => "يتعذر تعيين حالة منطقة DNS: 1%",
    'cmd_domains__dom_already_exists' => "المجال 1% موجود بالفعل.",
    'cmd_domains__dns_record_already_exists' => "يتعذر إنشاء المجال 1% لأن سجل DNS الذي يشير إلى المضيف 1% موجود بالفعل.",
    'cmd_domains__dom_already_exists1' => "توجد مجالات فرعية 2% في هذا المجال. المجال 1% موجود بالفعل.",
    'cmd_domains__dom_already_exists2' => "المجال الفرعي 1% موجود بالفعل.",
    'cmd_domains__dalias_already_exists' => "هذا الاسم المستعار موجود بالفعل.",
    'cmd_domains__domain_alias_already_exists' => 'هذا الاسم المستعار للمجال موجود بالفعل.',
    'cmd_domains__unable_del_mail_for_dom' => "يتعذر حذف خدمات البريد الخاصة بالمجال: 1%",
    'cmd_domains__unable_delete_anonymous_ftp' => "يتعذر حذف حساب FTP المجهول الخاص بالمجال: 1%",
    'cmd_domains__unable_update_dom_param' => "يتعذر تحديث معلمات المجال: 1%.",
    'cmd_domains__unable_rename_client_exist' => "اسم مستخدم مسؤول المجال مستخدم بالفعل.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "نوع الاستضافة غير فعلي.",
    'cmd_hosting__unable_create_user' => "يتعذر إنشاء المستخدم 2%: 1%",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "يتعذر تحديد عنوان IP الخاص بالمضيفين الظاهريين القائمين على الاسم: 1%",
    'cmd_hosting__unable_del_old_hst' => "يتعذر حذف الاستضافة المُعدَّة سابقًا: 1%",
    'cmd_hosting__unable_del_protected_directory' => "يتعذر حذف الدليل المحمي: 1%.",
    'cmd_hosting__unable_del_web_user' => "يتعذر حذف مستخدم الويب: 1%",
    'cmd_hosting__unable_make/update_virtual_host' => "يتعذر إنشاء أو تحديث المضيف الظاهري: 1%",
    'cmd_hosting__unable_make_frame_forward_hst' => "يتعذر إعداد استضافة إعادة توجيه الإطار.",
    'cmd_hosting__unable_rebuild_ftp_config' => "تتعذر إعادة إنشاء ملف تكوين proftpd. 1%.",
    'cmd_hosting__unable_set_up_ssl' => "تعذر إعداد SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "تعذرت إزالة الحماية من الدليل SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "يتعذر تحديث عنوان URL الوجهة 1%.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "يتعذر تحديث منطقة DNS الخاصة بالمجال: فشل تنفيذ الأداة المساعدة.",
    'cmd_hosting__unable_update_ftp_passwd' => "تعذر تحديث كلمة مرور FTP %1.",
    'cmd_hosting__unable_update_user' => "يتعذر تحديث المستخدم 2%: 1%",
    'cmd_hosting__unknown_hst_type' => "نوع استضافة غير معروف.",
    'cmd_hosting__you_not_have_permission_del_hst' => "ليس لديك الإذن لإنهاء خدمة الاستضافة.",
    'cmd_mail__autoresponder__not_configured' => "لم يتم تكوين الرد التلقائي لحساب البريد هذا",
    'cmd_mail__addr_already_used_in_mail_redirect' => "العنوان 1% مستخدم بالفعل لإعادة توجيه البريد.",
    'cmd_mail__alias_already_exists' => "الاسم المستعار موجود بالفعل.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "لا يتطابق معرف حساب البريد ومعرف الرد التلقائي.",
    'cmd_mail__autoresp_id_is_undefined' => "معرف الرد التلقائي غير محدد.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "اسم البريد المستعار بمثل هذا الاسم موجود بالفعل لحساب البريد 1%.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "حساب البريد 1% مشترك بالفعل في قائمة المراسلة هذه.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "حساب البريد 1% موجود بالفعل في هذا المجال.",
    'cmd_mail__mail_name_not_exist' => "حساب البريد غير موجود.",
    'cmd_mail__mail_name_passwd_part' => "ينبغي ألا تحتوي كلمة المرور على اسم حساب بريد كجزء منه.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "قائمة المراسلة 1% موجودة بالفعل في هذا المجال.",
    'cmd_mail__mailname_already_exist_in_mg' => "حساب البريد 1% موجود بالفعل في مجموعة البريد.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "حساب البريد 1% موجود بالفعل في هذا المجال.",
    'cmd_mail__mailname_already_exists' => "حساب البريد موجود بالفعل.",
    'cmd_mail__mailname_is_invalid' => "اسم حساب البريد 1% غير صالح.",
    'cmd_mail__mailname_unable_update' => "يتعذر تحديث خصائص حساب البريد:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "تم الوصول إلى أقصى عدد للردود التلقائية لهذا المجال.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "تم الوصول إلى أقصى عدد لمجموعات البريد لهذا المجال.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "تم الوصول إلى أقصى عدد لأدوات إعادة التوجيه لهذا المجال.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "تم الوصول إلى أقصى عدد من علب البريد.",
    'cmd_mail__no_members_specified' => "لم يتم تحديد أي أعضاء.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "كلمة المرور سهلة جدًا، يرجى اختيار واحدة أخرى.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "عنوان البريد هذا مستخدم بالفعل.",
    'cmd_mail__unable_define_autoresp_id' => "يتعذر تحديد معرف الرد التلقائي 1%.",
    'cmd_mail__unable_update_mail_for_dom' => "فشل تغيير إعدادات خدمة البريد الخاصة بالمجال 1%",
    'cmd_mail__unable_del_mail_for_dom' => "تتعذر إزالة خدمة البريد من المجال 1%.",
    'cmd_mail__unable_del_mail_redirection' => "تتعذر إزالة خدمة إعادة توجيه البريد 1%.",
    'cmd_mail__unable_remove_autoresp' => "تتعذر إزالة الردود التلقائية: 1%",
    'cmd_mail__unable_remove_mail_group_members' => "تتعذر إزالة أعضاء مجموعة البريد: 1%",
    'cmd_mail__unable_turn_off_mail_group' => "فشل إيقاف مجموعة البريد: 1%",
    'cmd_mail__unable_update_mail_redirect' => "تتعذر إعادة تكوين خدمة إعادة توجيه البريد 1%.",
    'cmd_mail__uploaded_file_is_too_big' => "حجم الملف المحمل كبير للغاية.",
    'cmd_mail__additionally' => "إضافة إلى ذلك:",
    'cmd_pd__invalid_login' => "اسم مستخدم غير صحيح.",
    'cmd_pd__this_user_already_exist' => "هذا المستخدم موجود بالفعل.",
    'cmd_pd__unable_define_hst_type' => "يتعذر تحديد نوع الاستضافة.",
    'cmd_pd__unable_upd_pd_usr' => "يتعذر تحديث خصائص مستخدم الدليل المحمي: 1%.",
    'cmd_pd__user_is_undefined' => "المستخدم غير محدد.",
    'cmd_server__no_enough_free_disk_space' => "لا توجد مساحة قرص كافية.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "كلمة المرور القديمة غير صحيحة. يُرجى المحاولة مجددًا.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "تم الوصول إلى أقصى حد لمستخدمي الويب الخاص بهذا المجال.",
    'cmd_web_usr__unable_create_user' => "يتعذر إنشاء مستخدم النظام: 1%",
    'cmd_web_usr__unable_define_max_web_users_limit' => "يتعذر تحديد أقصى حد لمستخدمي الويب: 1%",
    'cmd_web_usr__user_already_exists' => "المستخدم موجود بالفعل.",
    'cmd_web_usr__web_user_name_is_invalid' => "اسم مستخدم الويب 1% غير صالح.",
    'cmd_web_usr__web_user_not_exist' => "مستخدم الويب غير موجود.",
    'common_func__exec_bad_argument' => "ينبغي ألا تتضمن وسيطة التنفيذ رمز علامة اقتباس مفردة.",
    '__eol' => 'فواصل السطور',
    'eol__binary_file' => 'تعذّر تغيير نمط فاصل الأسطر في الملف الثنائي.',
    'comp_info__header' => 'مكونات',
    'comp_info__comp_name' => "اسم المكون",
    'comp_info__comp_disabled' => 'تم إيقاف التشغيل',
    'comp_info__comp_active' => '‫نشط‬',
    'comp_info__comp_not_configured' => 'لم يتم تكوينه',
    'comp_info__comp_not_started' => 'لم يبدأ، تحقق من إعدادات المكوّن',
    'comp_info__comp_version' => "إصدار المُكوّن",
    'comp_info__integration_error' => "خطأ في التكامل",
    'comp_info__title' => "مكونات Plesk",
    'comp_info__service_name' => "‫الخدمة‬",
    'comp_info__last_updated' => '(آخر تحديث: 1%)',
    'cp_access_admin_deny' => "تم تقييد وصول المسؤول من عنوان '\\1%'\\ وفقًا لسياسة تقييد الوصول إلى IP المطبقة حاليًا.",
    'create_domain_warn__' => "تم إجراء الاستثناءات التالية أثناء إنشاء المجال:",
    'create_domain__client_select' => 'حدد العميل المطلوب إنشاء المجال له',

    'dashboard__nav_button_name' => "الصفحة الرئيسية",
    'dalias__list_title' => 'أسماء المجال المستعارة الخاصة بالمجال 1%',
    'dalias__list_legend' => 'الأسماء المستعارة للمجالات',
    'dalias__list_header' => 'الأسماء المستعارة للمجالات',
    'dalias__list_status' => '‫S‬',
    'dalias__list_name' => 'اسم الاسم المستعار للمجال',
    'dalias__list_ascii_name' => 'بتنسيق ASCII',
    'dalias__remove_title' => 'ستتم إزالة أسماء المجال المستعارة التالية الخاصة بالمجال 1%:',
    'dalias__select_domain_aliases_to_remove' => 'حدد الأسماء المستعارة للمجال المراد إزالتها.',
    'dalias__mail_turn_on_failed' => 'يتعذر تشغيل خدمة البريد: 1%',
    'dalias__web_turn_on_failed' => 'يتعذر تشغيل خدمة الويب: 1%',
    'db_usr_edit__db_usr_name_old' => "اسم مستخدم قاعدة بيانات قديم",
    'database_server_edit_form__duplicate' => 'يوجد خادم قاعدة البيانات يتضمن تركيبة عنوان المضيف ورقم المنفذ هذه مسجل بالفعل.',
    'database_server_edit_form__host_is_invalid' => 'اسم المضيف المحدد غير صالح.',
    'database_server_edit_form__port_is_invalid' => 'رقم المنفذ المحدد غير صالح.',
    'database_server_error__consult_admin' => 'يرجى الاتصال بمسؤول الخادم.',
    'database_server_error__last__connection_failed' => 'فشلت المحاولة الأخيرة للتحكم في خادم قاعدة البيانات هذا بسبب مشكلات الشبكة.',
    'database_server_error__last__permission_denied' => 'فشلت المحاولة الأخيرة للتحكم في خادم قاعدة البيانات هذا لأن الحساب المتوفر لا يتمتع بالامتيازات الإدارية.',
    'database_server_error__last__credentials_not_set' => "فشلت المحاولة الأخيرة للاتصال بهذا الخادم بسبب عدم تحديد اسم مستخدم مسؤول وكلمة مرور صالحين.",
    'database_server_error__last__other_error' => 'فشلت المحاولة الأخيرة للتحكم في خادم قاعدة البيانات هذا.',
    'database_server_error__real__connection_failed' => 'فشل الاتصال بخادم قاعدة البيانات بسبب مشكلات الشبكة:',
    'database_server_error__real__permission_denied' => 'فشل الاتصال بخادم قاعدة البيانات لأن الحساب المتوفر لا يمتلك الامتيازات الإدارية:',
    'database_server_error__real__duplicate_object' => 'فشل الاتصال بخادم قاعدة البيانات بسبب تعارض الأسماء:',
    'database_server_error__real__unacceptable_name' => 'فشل الاتصال بخادم قاعدة البيانات بسبب اسم كائن غير صالح:',
    'database_server_error__real__unacceptable_password' => 'فشل الاتصال بخادم قاعدة البيانات بسبب كلمة مرور غير مقبولة:',
    'database_server_error__real__credentials_not_set' => "لا يمكن أن يتصل Plesk بخادم قاعدة البيانات بسبب عدم تحديد اسم مستخدم مسؤول وكلمة مرور صالحين.",
    'database_server_error__real__other_error' => 'فشل الاتصال بخادم قاعدة البيانات:',
    'database_server_error__test__connection_failed' => 'فشل اختبار الاتصال بخادم قاعدة البيانات بسبب وجود مشكلات في الشبكة:',
    'database_server_error__test__permission_denied' => 'فشل اختبار الاتصال بخادم قاعدة البيانات لأن الحساب المتوفر لا يتمتع بالامتيازات الإدارية:',
    'database_server_error__test__duplicate_object' => 'فشل اختبار الاتصال بخادم قاعدة البيانات بسبب تعارض الأسماء:',
    'database_server_error__test__unacceptable_name' => 'فشل اختبار الاتصال بخادم قاعدة البيانات بسبب اسم كائن غير صالح:',
    'database_server_error__test__unacceptable_password' => 'فشل اختبار الاتصال بخادم قاعدة البيانات بسبب كلمة مرور غير مقبولة:',
    'database_server_error__test__credentials_not_set' => "فشل اختبار الاتصال بهذا الخادم بسبب عدم تحديد اسم مستخدم مسؤول وكلمة مرور صالحين.",
    'database_server_error__test__other_error' => 'فشل اختبار الاتصال بخادم قاعدة البيانات:',

    'db__create_new_db' => "إضافة قاعدة بيانات",
    'db__db_add' => "إضافة قاعدة بيانات",
    'db__db_for_dom' => "قاعدة بيانات موقع الويب 1%",
    'db__db_id_undefined' => "معرف قاعدة البيانات غير محدد.",
    'db__db_name' => "اسم قاعدة البيانات",
    'db__db_not_exist' => "قاعدة البيانات غير موجودة.",
    'db__db_type' => "النوع",
    'db__db_server' => "خادم قاعدة البيانات",
    'db_server_not_exist' => "خادم قاعدة البيانات غير موجود.",
    'db__db_user_not_exist' => "مستخدم قاعدة البيانات غير موجود.",
    'db__domain_not_exist' => "المجال غير موجود.",
    'db__enter_db_name' => "أدخل اسم قاعدة بيانات جديدًا.",
    'db__invalid_db_id' => "معرف قاعدة البيانات غير صالح.",
    'db__invalid_db_name' => "اسم قاعدة البيانات غير صالح. يجب أن يحتوي اسم قاعدة البيانات على رموز أبجدية لاتينية أو أرقام أو شرطة سفلية أو شرطة فقط. لا يمكن أن يزيد طوله على 63 رمزًا.",
    'db__max_db_reached_for_dom' => "تم الوصول إلى حد عدد قواعد البيانات لهذا المجال.",
    'db__max_mssql_db_reached_for_dom' => "تم الوصول إلى حد عدد قواعد بيانات خادم Microsoft SQL لهذا المجال.",
    'db__postgres_not_connect_for_admin' => "تعذر الاتصال بـ PostgreSQL. قم بتشغيل دعم PostgreSQL على صفحة إدارة الخادم.",
    'db__postgres_not_connect_for_client' => "تعذر الاتصال بـ PostgreSQL. قم باستشارة مسؤول النظام لديك لطلب المساعدة.",
    'db__remove_db_on_domain' => "ستتم إزالة قواعد البيانات التالية الموجودة ضمن موقع الويب 2% الذي يمتلكه العميل 1%:",
    'db__remove_db_on_domain_of_cl' => "ستتم إزالة قواعد البيانات التالية الخاصة بالمجال 2% الذي يمتلكه العميل 1%:",
    'db__remove_db_linked_resource' => 'قاعدة البيانات هذه قيد الاستخدام من قِبل تطبيق ويب. لا يمكن إزالتها إلا بعد إلغاء تثبيت تطبيق الويب هذا.',
    'db__remove_db_users' => "ستتم إزالة مستخدمي قاعدة البيانات 3% التالين ضمن موقع الويب 2% الذي يمتلكه العميل 1%:",
    'db__remove_db_users_of_cl' => "ستتم إزالة مستخدمي قاعدة البيانات 3% التالين ضمن موقع الويب 2% الذي يمتلكه العميل 1%:",
    'db__select_db_for_remove' => "تحديد قواعد البيانات المراد إزالتها.",
    'db__select_db_users_for_remove' => "تحديد مستخدمي قاعدة البيانات المراد إزالتهم.",
    'db__unable_create_db_user' => "يتعذر إنشاء مستخدم قاعدة البيانات: 1%",
    'db__unable_define_db_name' => "يتعذر تحديد اسم قاعدة البيانات: 1%",
    'db__unable_define_db_user' => "يتعذر تحديد مستخدم قاعدة البيانات: 1%",
    'db__unable_define_db_users' => "يتعذر تحديد مستخدمي قاعدة البيانات: 1%",
    'db__unable_select_dom_name' => "يتعذر تحديد اسم المجال: 1%",
    'db_edit__db_for_dom' => "مستخدمو قاعدة البيانات 1% في المجال 2%",
    'db_edit__invalid_db_name' => "اسم قاعدة البيانات غير صالح.",
    'db_edit__no_users' => "لا يوجد مستخدمون لديهم بيانات اعتماد لقاعدة البيانات هذه.",
    'db_edit__unable_define_db_usrs' => "يتعذر تحديد مستخدمي قاعدة البيانات: 1%",
    'db_edit__unable_select_db_usr' => "يتعذر تحديد مستخدم قاعدة البيانات.",
    'db_edit__db_user_password_for_' => "يرجى كتابة كلمة المرور لتسجيل الدخول كمستخدم قاعدة البيانات 1%",
    'db_list__tab_title_db_type' => "تيرا",
    'db_usr_edit__add_db_usr' => "إضافة مستخدم قاعدة بيانات",
    'db_usr_edit__db_usr_name' => "اسم مستخدم قاعدة البيانات",
    'db_usr_edit__edit_db_usr' => "إعداد بيانات اعتماد لحساب مستخدم قاعدة البيانات",
    'db_usr_edit__for_db' => "في 1% من قواعد البيانات",
    'db_usr_edit__not_create_pass' => "ستؤدى هذه العملية إلى إنشاء حساب مستخدم قاعدة بيانات بدون كلمة مرور. هل ترغب في إنشاء مستخدم دون تعيين كلمة مرور؟",
    'dbuser__only_one_user_can_be_default' => "يمكن تعيين مستخدم واحد فحسب كمستخدم افتراضي.",
    'db_server__cannot_delete_default' => "يتعذر حذف خادم قاعدة البيانات الافتراضي.",
    'db_server__cannot_delete_local' => "يتعذر حذف خادم قاعدة البيانات المحلي.",
    'db_server__cannot_delete_used' => 'يتعذر حذف خادم قاعدة البيانات في حال وجود قواعد بيانات أو مستخدمي قاعدة بيانات مستضافة عليه.',
    'demo__disabled_in_demo' => "هذه العملية غير معتمدة في الإصدار التجريبي.",
    'defaultcomponents__title' => "تحديد المكونات الافتراضية",
    'defaultcomponents__select_default' => "حدد المكون 1% الافتراضي",//to check
    'defaultcomponents__not_installed' => "(غير مثبت)",
    'defaultcomponents__not_configured' => "غير مكون)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "تحتوي بعض فئات الخدمات على اختيارات غير صالحة، أو أنه لم يتم تحديد أي خيارات.",
    'defaultcomponents__depends_on' => "(يتطلب 1%)",
    'defaultcomponents__parameters' => "معلمات 1%",
    'component_name__antivirus' => "برنامج مكافحة الفيروسات",
    'component_name__database' => "‫خادم SQL‬",
    'component_name__sqladmin' => "‫MySQL Webadmin‬",
    'component_name__sqladminmysql' => "‫MySQL Webadmin‬",
    'component_name__dnsserver' => "‫خادم DNS‬",
    'component_name__firewall' => "جدار الحماية",
    'component_name__ftpserver' => "‫خادم FTP‬",
    'component_name__java' => "‫Java‬",
    'component_name__mailserver' => "‫خادم البريد‬",
    'component_name__local_mailserver' => "خادم البريد المحلي",
    'component_name__psa' => "‫Plesk‬",
    'component_name__script' => "‫البرمجة النصية للويب‬",
    'component_name__spamfilter' => "عامل تصفية البريد العشوائي",
    'component_name__stats' => "إحصائيات الويب",
    'component_name__stunnel' => "غلاف SSL/TLS",
    'component_name__webmail' => "بريد الويب",
    'component_name__webpublish' => "‫نشر الويب‬",
    'component_name__webserver' => "‫خادم الويب‬",
    'dns__dns_record_invalid_values' => 'تم تحديد قيم سجلات DNS غير الصحيحة: %1: %2',
    'dns__dns_zone_invalid_values' => 'تم تحديد معلمات غير صحيحة لمنطقة DNS.',

    'dns__soa_mname_title' => 'خادم الاسم الرئيسي',
    'dns__soa_mname_legend' => 'خادم الاسم',
    'dns__soa_mname_autoselect' => '(التحديد التلقائي)',

    'dns__dns_zone_default' => 'الإعدادات الافتراضية للمنطقة',
    'dns__dns_soa_legend' => 'سجل SOA',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'تحديث',
    'dns__dns_soa_retry' => 'إعادة المحاولة',
    'dns__dns_soa_expire' => 'انتهاء الصلاحية',
    'dns__dns_soa_minimum' => 'الحد الأدنى',
    'dns__dns_soa_ttl_error' => 'قيمة TTL غير صالحة. يمكن أن تتراوح بين ثانية واحدة و68 عامًا.',
    'dns__dns_soa_refresh_error' => 'قيمة التحديث غير صالحة. يمكن أن تتراوح بين ثانية واحدة و68 عامًا.',
    'dns__dns_soa_retry_error' => 'قيمة إعادة المحاولة غير صالحة. يمكن أن تتراوح بين ثانية واحدة و68 عامًا.',
    'dns__dns_soa_expire_error' => 'قيمة انتهاء الصلاحية غير صالحة. يمكن أن تتراوح بين ثانية واحدة و68 عامًا.',
    'dns__dns_soa_minimum_error' => 'قيمة الحد الأدنى غير صالحة. يمكن أن تتراوح بين ثانية واحدة و68 عامًا.',
    'dns__dns_default_title' => 'استعادة منطقة DNS',
    'dns__dns_default_legend' => "خيارات استعادة المنطقة",
    'dns__dns_default_text' => "قم باختيار إعدادات استعادة منطقة DNS وتأكيدها وانقر فوق \"موافق\".",
    'dns__dns_default_confirm' => "تأكيد استعادة منطقة DNS",
    'dns__dns_default_confirm_required' => "يرجى تأكيد استعادة منطقة DNS",
    'dns__dns_default_invalid_ip_address' => 'عنوان IP غير صالح',

    'dns_t__dns_default_title' => 'استعادة قالب منطقة DNS الافتراضي',
    'dns_t__dns_default_legend' => "خيارات الاستعادة",
    'dns_t__dns_default_text' => 'يرجى تأكيد رغبتك في استعادة التكوين الافتراضي لقالب منطقة DNS.',
    'dns_t__dns_default_confirm' => "تأكيد الاستعادة",
    'dns_t__dns_default_confirm_required' => "يرجى تأكيد استعادة قالب منطقة DNS",
    'dns_t__dns_zone_off_remove_title' => "ستتم إزالة سجلات المورد التالية لقالب منطقة DNS:",
    'dns_t__dns_zone_master_remove_title' => "ستتم إزالة سجلات المورد التالية من قالب منطقة DNS:",
    'dns_t__add_dns_record_master_title' => 'إضافة سجل المورد إلى قالب المنطقة',
    'dns_t__add_dns_record_off_title' => 'إضافة خادم الاسم',
    'dns_t__edit_dns_record_master_title' => 'تحرير سجل المورد',
    'dns_t__edit_dns_record_off_title' => 'تحرير خادم الاسم',
    'dns_t__select_record_to_remove' => "تحديد السجلات المراد إزالتها من قالب منطقة DNS",
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__dns_zone_off_remove_title' => "ستتم إزالة سجلات المورد التالية من منطقة 1%:",
    'dns__dns_zone_master_remove_title' => "إزالة سجلات الموارد من منطقة DNS %1",
    'dns__dns_zone_slave_remove_title' => "سجلات خادم الاسم الأساسي التالية الخاصة بـ 1% سيتم إزالتها:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'أدخل سلسلة سجل',
    'dns_add__is_spf_syntax' => 'سجل SPF',
    'dns_add__spf_value_is_invalid' => "قيمة سجل SPF غير صحيحة، يجب أن تبدأ بـ 'v=spf'",
    'dns__dns_zone_status' => "حالة منطقة DNS.",
    'dns__dns_zone_template' => 'إعدادات DNS',
    'dns__host' => "المضيف",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "عنوان IP لخادم DNS الرئيسي الجديد غير صالح أو فارغ.",
    'dns__ip_address' => "عنوان IP",
    'dns__master_dns_type' => "خادم DNS رئيسي",
    'dns__masters' => "خوادم DNS الرئيسية",
    'dns__soa_minimum_too_large' => 'تخزين الردود السلبية لمدة تزيد على ثلاث ساعات غير مستحسن.',
    'dns__select_masters_to_remove' => "حدد خوادم DNS الأساسية المراد إزالتها.",
    'dns__select_template_record_to_remove' => 'حدد سجلات قالب DNS المراد إزالتها.',
    'dns__select_record_to_remove' => 'حدد سجلات DNS المراد إزالتها.',
    'dns__nameservers_for_domain' => "خوادم الاسم الخاصة بالمجال",
    'dns__ns' => "خادم اسم",
    'dns__ns_record' => "خوادم الاسم",
    'dns__remove_dns_zone_of_domain__' => "إزالة سجلات DNS من المجال 1%",
    'dns__remove_dns_zone_template__' => "ستتم إزالة سجلات DNS التالية من القالب:",
    'dns__remove_this_dns_record?' => "هل أنت متأكد من رغبتك في إزالة سجل DNS هذا؟",
    'dns__restore_default' => "استعادة منطقة DNS بواسطة القالب",
    'dns__restore_default_confirm' => "ستتجاهل استعادة منطقة DNS تكوين منطقة DNS الحالي. هل ترغب في المتابعة على أي حال؟",
    'dns__restore_default_error' => "حدث خطأ أثناء استعادة منطقة DNS:",
    'dns__slave_dns_type' => "خادم DNS ثانوي",
    'dns__soa_refresh_value_is_small' => 'قيمة فترة التحديث أقل من ساعة، مما قد يزيد بشكل كبير من استخدام الموارد وعدد زوار الخادم. هل ترغب في متابعة استخدام هذه القيمة؟',
    'dns__subdomain_dns_rec_removed' => "تمت إزالة السجل أ من منطقة المجال الفرعي 1%.",
    'dns__zone_switched_off_no_ns' => "The zone was switched off because there is no NS record %1, which must be present in the zone. لإضافة السجل إلى المنطقة، انقر فوق زر \"إضافة سجل\".",
    'dns__cant_switch_on_no_ns' => "يتعذر تشغيل المنطقة بسبب عدم وجود سجل NS %1 الواجب وجوده في المنطقة. لإضافة السجل إلى المنطقة، انقر فوق زر \"إضافة سجل\".",
    'dns__type' => "نوع السجل",
    'dns__unable_activate/deactivate_dns' => "تعذر تنشيط / إلغاء تنشيط DNS: 1%",
    'dns__unable_add_dns_master_duplicate_entry' => "تتعذر إضافة خادم DNS الأساسي: إدخال متكرر.",
    'dns__unable_add_dns_master_local_ip' => "تعذرت إضافة عنوان IP إلى خادم DNS الرئيسي: يجب إنشاء هذا السجل على خادم بعيد.",
    'dns__unable_define_dns_record' => "يتعذر تعريف سجل DNS: 1%",
    'dns__unable_get_dns_template_status' => "يتعذر استرداد حالة قالب DNS.",
    'dns__unable_remove_dns_rec' => "تتعذر إزالة سجل DNS: 1%",
    'dns__val' => "القيمة",
    'dns__warnings__' => "نتيجة تعديل منطقة DNS:",
    'dns__you_not_have_perm_manage_dns' => "ليس لديك إذن لإدارة منطقة DNS الخاصة بهذا المجال.",
    'dns__zone_record' => "سجلات DNS",
    'dns__cant_create_record_with_server_ip' => "تعذرت إضافة عنوان IP هذا لأنه يطابق عنوان IP لهذا الخادم الذي يديره Plesk.",

    'dns__tabs_acl' => "عمليات نقل المنطقة",
    'dns__acl_add_network_legend' => "‫إضافة شبكة‬",
    'dns__acl_add_ip_legend' => "إضافة عنوان IP",
    'dns__acl_network_not_allowed' => "عنوان الشبكة المحدد غير مسموح به بواسطة DNS في Windows.",
    'dns__acl_enter_ip_address_with_mask' => "عنوان/قناع IP",
    'dns__acl_enter_ip_address' => "‫عنوان IP‬",
    'dns__acl_list_network_legend' => "الشبكات المسموح لها بالحصول على نسخة من منطقة DNS",
    'dns__acl_list_ip_legend' => "عناوين IP المسموح لها بالحصول على نسخة من منطقة DNS",
    'bt_dns_acl_add_network' => "‫إضافة شبكة‬",
    'bt_dns_acl_add_ip' => "إضافة عنوان IP",

    'dns_add__add_rec_for_zone' => "إضافة 1% للمنطقة 2%",
    'dns_add__canonical_dom_name_is_invalid' => "اسم المجال المتعارف عليه غير صالح.",
    'dns_add__enter_canonical_name' => "الاسم المتعارف عليه",
    'dns_add__enter_dom_name' => "اسم النطاق",
    'dns_add__enter_ip_address' => "‫عنوان IP‬",
    'dns_add__enter_ip_mask' => "عنوان IP وقناع الشبكة",
    'dns_add__enter_mail_domain' => "مجال البريد",
    'dns_add__enter_mail_exchanger' => "خادم تبادل البريد",
    'dns_add__enter_nameserver' => "خادم اسم",
    'dns_add__enter_txt_record' => "سجل TXT",
    'dns_add__enter_service_name' => "اسم الخدمة",
    'dns_add__hint_service_name' => "مثال: SIP (بدون رمز تسطير)",
    'dns_add__enter_protocol' => "البروتوكول",
    'dns_add__hint_protocol_name' => "مثال: TCP (بدون رمز تسطير)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "‫الأولوية‬",
    'dns_add__specify_weight_of_service' => "أهمية السجلات النسبية بالأولوية ذاتها",
    'dns_add__enter_target_host' => "المضيف الهدف",
    'dns_add__hint_target_host' => "مثال: example.com",
    'dns_add__enter_target_port' => "المنفذ الهدف",
    'dns_add__caa_tag' => "علامة",
    'dns_add__caa_value' => "القيمة",
    'dns_add-invalid-A_ip' => "عنوان IP غير صالح.",
    'dns_add-invalid-AAAA_ip' => "عنوان IP غير صالح.",
    'dns_add-invalid-PTR_ip_mask' => "زوج عنوان IP/ قناع الشبكة غير صالح.",
    'dns_add-invalid-SRV_service_name' => "Invalid service name",
    'dns_add-invalid-SRV_protocol_name' => "Invalid protocol",
    'dns_add-invalid-SRV_target_port' => "Invalid target port",

    'dns_add__invalid_ip' => "عنوان IP غير صالح.",
    'dns_add__low' => "‫منخفض‬",
    'dns_add__mail_dom_name_is_invalid' => "اسم مجال البريد غير صالح.",
    'dns_add__nameserver_is_invalid' => "خادم الاسم غير صالح.",
    'dns_add__record' => "سجل 1%",
    'dns_add__select_prefer_for_mail_exchange_server' => "تحديد أولوية خادم تبادل البريد",
    'dns_add__unable_insert_new_dns_rec' => "يتعذر إدراج سجل DNS جديد: 1%",
    'dns_add__very_high' => "عالٍ جدًا",
    'dns_check__test_dns_zone' => "اختبار منطقة DNS ‏%1 على 2%",
    'dns_check__unable_get_dom_properties' => "يتعذر استرداد خصائص المجال: 1%",
    'dom_ctrl__allowed' => "مسموح به",
    'dom_ctrl__db' => "قواعد بيانات MySQL",
    'dom_ctrl__mssql_db' => "قواعد بيانات MS SQL",
    'dom_ctrl__disk_space' => "مساحة القرص",
    'dom_ctrl__dom_adm' => "المجال 1% من 2%",
    'dom_ctrl__dom_cl' => "المجال 1%",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "يتضمن المجال إعداد إعادة التوجيه بعنوان URL إعادة توجيه غير محدد",
    'dom_ctrl__domain_has_frame_forwarding' => "يتضمن المجال إعادة توجيه الإطار لعنوان URL %1",
    'dom_ctrl__domain_has_no_hosting' => "لا يتضمن المجال أي استضافة مكونة",
    'dom_ctrl__domain_has_physical_hosting' => "تم تكوين استضافة الويب لهذا المجال على عنوان IP٪ %1",
    'dom_ctrl__domain_has_standard_forwarding' => "يتضمن المجال إعادة توجيه قياسي لعنوان URL ‏%1",
    'dom_ctrl__maillists' => "قوائم المراسلة",
    'dom_ctrl__mboxes' => "علب البريد",
    'dom_ctrl__mg' => "عمليات إعادة توجيه البريد",
    'dom_ctrl__resource_name' => "المورد",
    'dom_ctrl__resp' => "الردود التلقائية",
    'dom_ctrl__subdom' => "المجالات الفرعية",
    'dom_ctrl__dom_aliases' => "الأسماء المستعارة للمجالات",
    'dom_ctrl__traffic' => "نسبة استخدام الشبكة",
    'dom_ctrl__unable_activate/deactivate_dom' => "تعذر تنشيط / إلغاء تنشيط المجال: 1%",
    'dom_ctrl__used' => "مُستخدَم",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "مستخدمو الويب",
    'dom_pref__bounce_with_phrase' => "بريد مرتد باستخدام رسالة",
    'dom_pref__bounce' => "ارتداد",
    'dom_pref__catch_addr' => "إعادة التوجيه إلى عنوان",
    'dom_pref__reject' => 'رفض',
    'dom_pref__confirm_domain_removing' => "يرجى عدم نسيان إعلام زوار المجال بتغيير اسم المجال. هل تريد بالتأكيد إعادة تسمية المجال؟",
    'dom_pref__db_inconsystency' => "عدم اتساق قاعدة البيانات.",
    'dom_pref__dbs' => "‫قواعد البيانات‬",
    'dom_pref__delete_traffic_stat' => "الاحتفاظ بإحصائيات الويب ونسبة استخدام الشبكة",
    'dom_pref__delete_traffic_stat_older' => "الاحتفاظ بإحصائيات الويب ونسبة استخدام الشبكة",
    'dom_pref__dom_level_name_conflict' => "يتعارض اسم مستخدم مسؤول المجال مع اسم المستخدم لأحد العملاء.",
    'dom_pref__invalid_disk_space_limit' => "حد مساحة القرص غير صالح. قيمة الحد الأقصى: 1%",
    'dom_pref__invalid_expiration_date_limit' => "فترة صلاحية غير صالحة.",
    'dom_pref__invalid_max_traffic_limit' => "حد نسبة استخدام الشبكة غير صالح. قيمة الحد الأقصى: 1%",
    'dom_pref__limits_of_dom' => "حدود المجال 1%",
    'dom_pref__mail_grps' => "مجموعات البريد",
    'dom_pref__mail_nonexistent_user' => "ما يجب عليك فعله مع البريد المرسَل إلى مستخدمين غير موجودين",
    'dom_pref__mail_redirs' => "أدوات توجيه البريد",
    'dom_pref__mail_resps' => "الردود التلقائية على البريد",
    'dom_pref__max_limit_is_invalid' => "1% غير صالح.",
    'dom_pref__max_num_of_%objects_is_invalid' => "أقصى عدد لـ 1% غير صالح.",
    'dom_pref__new_limit_less_currently_used' => "1%: مطلوب- 2%، مستخدَم حاليًا - 3%",
    'dom_pref__older_that' => "إلى",
    'dom_pref__postboxes' => "علب البريد",
    'dom_pref__preferences_of_dom' => "إعدادات المجال 1%",
    'dom_pref__redirect_to_itself' => "سيحتوي المجال على مجموعة التوجيه لنفسه",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "لقد حددت تقليل وقت الاحتفاظ بإحصائيات عدد زوار المجال عن إجمالي القيمة المحددة للخادم (1% شهر (أشهر)). يتم تعيين فترة احتفاظ بالإحصائيات مساوية للقيمة الافتراضية للخادم (1% شهر (أشهر)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "تتعذر إضافة بادئة www إلى المجال: 1%",
    'dom_pref__unable_define_physical_hst_param' => "يتعذّر تحديد معلمات الاستضافة الفعلية. 1%",
    'dom_pref__unable_rename_domain' => "Unable to rename the domain %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "يتعذر تعيين حصة علبة البريد لهذا المجال: 1%",
    'dom_pref__unable_set_up_web_user_script' => "يتعذر إعداد البرمجة النصية لمستخدمي الويب: 1%",
    'dom_pref__unlimited' => "غير محدود",
    'dom_pref__web_usrs' => "مستخدمو الويب",
    'dom_pref__you_already_have_%object' => "لديك بالفعل 1%",
    'cu_domain__error_unable_update_ftp_users' => 'Failed to update the domain FTP users: %1',
    'dom_cli__warning_ignore_quota' => 'تحذير: تم تجاهل خيار "-hard_quota": حصة للقرص الثابت غير معتمدة',
    'dom_user_client_login_exist' => "يتعذر السماح بوصول مسؤول المجال إلى Plesk في المجال 1%: اسم المستخدم هذا مستخدَم بالفعل.",
    'domain__unable_to_turn_on_service' => "فشل تشغيل خدمة 1%:",
    'domains__change_the_status_of_domain?' => "هل تريد بالتأكيد تغيير حالة المجال ?1%",
    'domains__client_info_hiding_traffic' => "1% من المجالات، 2% من المجالات النشطة، 3% من مساحة القرص المستخدمة",
    'domains__unable_to_change_client_status' => "يتعذر تغيير حالة حساب العميل: 1%",
    'domains__unable_update_apache_settings' => "يتعذر تحديث إعدادات Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "ليس لديك الإذن لحذف مجالات.",
    'domains__you_want_change_the_status_of_the_cl??' => "هل تريد بالتأكيد تغيير حالة حساب العميل؟",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "هل تريد بالتأكيد إجراء هذه العملية؟",
    'domains_list__unable_remove_doms' => "تتعذر إزالة المجالات: 1%",
    'domaintrafficlist_header_of_domain__' => "نسبة استخدام الشبكة في مجال 1%",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'حدد الأسماء المستعارة للمجال المراد إزالتها.',
    'domain_aliases_remove__title' => 'إزالة الأسماء المستعارة للمجال',
    'domain_aliases__max_aliases_reached_for_dom' => "تم الوصول إلى حد عدد الأسماء المستعارة لهذا المجال.",
    'domain_edit__edit_title' => 'تعديل الاسم المستعار للمجال',
    'domain_alias_edit__type' => 'نوع الاسم المستعار للمجال',
    'domain_aliases__list_header' => 'الأسماء المستعارة للمجالات',
    'domain_aliases__name' => 'الاسم',
    'domain_aliases__type' => 'النوع',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'الأسماء المستعارة للمجالات',
    'domain_aliases__legend' => 'الأسماء المستعارة للمجالات',
    'domain_alias__domain_exists' => 'يوجد بالفعل مجال بهذا الاسم',
    'domain_alias__subdomain_exists' => 'اسم المجال الفرعي موجود بالفعل',
    'domain_alias__dns_record_exists' => 'سجل DNS بالاسم المستعار المحدد للمجال موجود بالفعل',
    'domain_alias__domain_alias_exists' => "هذا الاسم المستعار للمجال موجود بالفعل",
    'domain_alias__invalid_type_full' => 'خادم البريد لا يدعم الأسماء المستعارة للمجال',
    'domain_alias__redirect_exists' => 'تم اكتشاف إعادة توجيهه لنفسه.',

    'ds__anonymous_ftp' => "FTP مجهول",
    'drweb__pagetitle' => 'إعدادات مكافحة الفيروسات',
    'drweb__drweb' => 'التحقق من البريد ببرنامج مكافحة الفيروسات',
    'drweb__drweb_direction' => 'جارٍ فحص البريد بحثًا عن فيروسات',
    'drweb__drweb_direction_off' => 'لا تبحث عن فيروسات',
    'drweb__drweb_direction_any' => 'البريد الوارد والصادر',
    'drweb__drweb_direction_from' => 'البريد الصادر فقط',
    'drweb__drweb_direction_to' => 'البريد الوارد فقط',
    'drweb__disable_reason_key' => 'لا يدعم مفتاح الترخيص برنامج مكافحة الفيروسات.',
    'drweb__disable_reason_perm' => 'ليس لديك تصريح بإدارة برنامج مكافحة الفيروسات.',
    'drweb__disable_reason_install' => 'لم يتم تثبيت برنامج مكافحة الفيروسات.',
    'drweb__filters' => 'عوامل تصفية مكافحة الفيروسات',
    'ds__dns' => "منطقة DNS",
    'ds__mail' => "البريد",
    'dsr__of_client_title' => "تقرير موجز للمجال لـ 1%",
    'dsr__report_has_been_sent_email' => "تم إرسال التقرير إلى البريد: 1%",
    'dsr__title' => "تقرير تلخيص المجال",
    'dumps_list__deletion_page_title' => "ستتم إزالة ملفات النسخ الاحتياطية التالية للمجال 1%:",
    'dumps_list__dumpfile_is_invalid' => "الملف 1% ليس ملفًا صالحًا لملف النسخ الاحتياطي للمجال.",
    'dumps_list__page_title' => "تخزين ملفات النسخ الاحتياطي",
    'dumps_upload__page_title' => "تحميل ملفات النسخ الاحتياطي على وحدة التخزين",
    'dumps_list__repository_is_not_exist' => "وحدة تخزين ملفات النسخ الاحتياطي غير موجودة.",
    'dumps_list__unable_to_remove' => "تعذرت إزالة ملف النسخ الاحتياطي: 1%",
    'dumps_list__dumpfile_can_conflict' => "اسم الملف الذي حددته يتعارض مع الملف 1%، يرجى تحديد اسم ملف آخر.",
    'dusr_ed__allow_dl_usr_access' => "السماح بوصول مسؤول المجال",
    'dusr_ed__information' => "خصائص مسؤول مجال %s'1",
    'dusr_ed__locale' => "لغة مسؤول المجال",
    'dusr_ed__skin' => "سطح واجهة مسؤول المجال",
    'dusr_ed__personal_information' => 'المعلومات الشخصية',
    'ess__error' => "خطأ",
    'example__' => "مثال: 1%",
    'extras__allow_certificate_purchasing' => "السماح بشراء شهادة",
    'extras__allow_domain_registration' => "السماح بتسجيل المجال",
    'extras__allow_extras' => "السماح بالخدمات الإضافية",
    'extras__buy_new_key' => "لا تسمح لك رخصتك الحالية بتعديل هذه الكائنات.",
    'extras__setup_services' => "إعداد الخدمات الإضافية",

    'firewallmainform__title' => 'إدارة جدار الحماية',
    'firewallmainform__interfaces_list_legend' => 'قائمة واجهات المستخدم للشبكة',
    'firewall__interfacelist' => 'واجهات المستخدم للشبكة',
    'interfacelist__enabled' => 'F',
    'interfacelist__status' => 'I',

    'interfacelist__interface' => 'اسم واجهة المستخدم',
    'interfacelist__type' => 'نوع واجهة المستخدم',
    'bt_rule_add' => 'إضافة قاعدة جدار حماية',
    'bt_panic' => 'وضع الذُّعْر',
    'firewallmainform__rules_list_legend' => 'قائمة القواعد',
    'firewall__rulelist' => 'القواعد',
    'rulelist__enable' => '‫S‬',
    'rulelist__name' => 'الاسم',
    'rulelist__allow_input_from_any_port_profiles' => '[السماح] بالاتصالات الواردة من [الكل] على المنفذ [%1]، ملفات التعريف: [2%]',
    'rulelist__allow_input_from_port_profiles' => '[السماح] بالاتصالات الواردة من [1%] على المنفذ [2%]، ملفات التعريف: [%3]',
    'rulelist__block_input_from_any_port_profiles' => '[رفض] الاتصالات الواردة من [الكل] على المنفذ [1%]، ملفات التعريف: [2%]',
    'rulelist__block_input_from_port_profiles' => '[رفض] الاتصالات الواردة من [1%] على المنفذ [2%]، ملفات التعريف: [%3]',
    'rulelist__description' => '‫الوصف‬',
    'ruleeditform__add_title' => 'إضافة قاعدة جديدة',
    'ruleeditform__properties' => 'خصائص القاعدة',
    'ruleeditform__name' => 'اسم القاعدة',
    'ruleeditform__port' => 'السماح بالاتصالات للمنفذ أو نطاق المنفذ التالي',
    'ruleeditform__protocol_tcp' => 'بروتوكول TCP',
    'ruleeditform__protocol_udp' => 'بروتوكول UDP',
    'ruleeditform__edit_title' => 'تعديل قاعدة لجدار الحماية',
    'ruleeditform__newrule' => 'قاعدة جديدة',
    'ruleeditform__enabled' => 'تشغيل القاعدة',
    'ruleeditform__profiles_text' => 'ملفات التعريف',
    'ruleeditform__profiles_domain_text' => 'المجال',
    'ruleeditform__profiles_private_text' => '‫خاص‬',
    'ruleeditform__profiles_public_text' => '‫عام‬',
    'ruleeditform__action' => 'الإجراء',
    'ruleeditform__action_allow' => 'السماح',
    'ruleeditform__action_deny' => 'رفض',
    'ruleeditform__from' => 'العناوين البعيدة',
    'ruleeditform__from_add' => 'إضافة عنوان IP أو شبكة:',
    'ruleeditform__profiles_hint' => 'يجب تحديد ملف تعريف واحد على الأقل.',
    'ruleeditform__port_hint' => 'على سبيل المثال: 1000 أو 1000-1051',
    'ruleeditform__from_hint' => 'على سبيل المثال: 192.168.0.1 أو 192.168.0.0/16',
    'ruleeditform__ip_any' => 'الكل',
    'firewall_from_add' => 'إضافة',
    'firewall_from_remove' => 'إزالة',
    'firewall_from_clear' => 'مسح القائمة',
    'bt_firewall_from_add' => 'إضافة',
    'bt_firewall_from_remove' => 'إزالة',
    'bt_firewall_from_clear' => 'مسح القائمة',
    'ruleeditform__name_is_required' => 'تحديد اسم القاعدة.',
    'ruleeditform__profiles_is_required' => 'حدد ملف تعريف واحدًا على الأقل.',
    'ruleeditform__invalid_action' => 'الإجراء المحدد غير صالح. القيم الممكنة هي "السماح" أو "الرفض".',
    'ruleeditform__invalid_ip' => 'عنوان IP المحدد أو الشبكة غير صالحة.',
    'ruleeditform__invalid_protocol' => 'البروتوكول المحدد غير صالح. القيم الممكنة هي "udp" أو "tcp".',
    'ruleeditform__invalid_port' => 'المنفذ المحدد غير صالح. القيم الممكنة هي 1000 أو 1000-1051',
    'firewall__panic_configuration' => 'هل ترغب بالتأكيد في تشغيل وضع الذعر؟ لن يتمكن المستخدمون من الوصول إلى مجالاتهم.',
    'firewall__reset_configuration' => 'هل ترغب بالتأكيد في إعادة تعيين إعدادات جدار الحماية على الإعدادات الافتراضية؟',
    'rulelist__remove_selected' => 'هل ترغب في إزالة القواعد المحددة؟',

    'filemanager__items' => 'عناصر في دليل 1%',
    'filemanager__items_paging' => 'عناصر في دليل 1%',

    'get_password__encrypted_password' => "تعذر إرسال معلومات كلمة المرور: تم تخزين كلمة المرور بصيغة مشفّرة.",
    'get_password__mail_error' => "حدث خطأ أثناء محاولة إرسال كلمة المرور إلى البريد الإلكتروني 1%: %2",
    'get_password__mail_ok' => "تم إرسال كلمة المرور بنجاح إلى البريد الإلكتروني: 1%",
    'get_password__message' => "اسم المستخدم المخصص لك للوصول إلى النظام: 1% كلمة المرور هي 2%",
    'get_password__subject' => "كلمة المرور للوصول إلى النظام:",
    'groups__available' => "مجموعات بريد متوفرة",
    'groups__groups_for_mailname' => "مجموعات البريد التي تم اشتراك حساب البريد 1% فيها",
    'groups__member_of' => "عضو في مجموعات البريد التالية",
    'help__help_area' => "منطقة المساعدة.",
    'hst_def__auth_disabled' => "محظور",
    'hst_def__auth_enabled' => "مسموح به",
    'hst_def__change_curr_dns_ip' => "سيتم تغيير عنوان IP الحالي لسجل A DNS",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "لا تطابق أيًّا من عناوين IP لسجل A DNS مع عنوان IP المعيّن للحساب المضيف الذي يتم إنشاؤه",
    'hst_def__dest_url' => "عنوان URL للوجهة",
    'hst_def__disk_quota' => "الحصة النسبية للقرص",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "تجاوز حد مساحة القرص الذي تحاول تعيينه حد مساحة القرص الموجود في دليل البريد الوارد لـ FTP المجهول. يجب ألا يتجاوز حد مساحة القرص في الدليل الوارد لـ FTP المجهول حد مساحة قرص المجال.",
    'hst_def__frame_forwarding_definition' => "تعيين إعادة توجيه الإطار للمجال 1%",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "تحذير: تم استخدام مستخدم FTP %1 في إعدادات حساب الاستضافة ولكنه غير موجود في النظام.",
    'hst_def__hst_type_is_not_defined' => "نوع الاستضافة غير محدد",
    'hst_def__ip_based' => "المستندة إلى IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "ستجعل عملية نقل حساب الاستضافة هذا إلى عنوان IP مشترك خدمة FTP المجهول على هذا المجال غير متاحة. هل ترغب في المتابعة على أي حال؟",
    'hst_def__password_is_invalid_password_syntax' => "كلمة المرور غير صالحة. لا تستخدم علامة اقتباس مفردة ورموز الأبجدية القومية في كلمة المرور. يجب أن يكون طول كلمة المرور من 5 إلى 14 رمزًا. يجب ألا تحتوي كلمة المرور على اسم المستخدم.",
    'hst_def__shell' => "وصول SSH إلى وعاء الخادم ضمن مستخدم نظام الاشتراك",
    'hst_def__shell_windows' => "وصول \"سطح المكتب البعيد\" إلى الخادم ضمن مستخدم نظام الاشتراك",
    'hst_def__standard_forwarding_definition' => "تعيين إعادة التوجيه القياسية للمجال 1%",
    'hst_def__title_name_based' => "يعتمد على الاسم",
    'hst_def__unable_create/update_physic_hst' => "تعذّر إنشاء/تحديث استضافة مادية: 1%",
    'hst_def__unable_create/update_std_fwd' => "تعذّر إنشاء/تحديث إعادة التوجيه القياسية: 1%",
    'hst_def__unable_create_forwarding_myself' => "تعذّر إنشاء إعادة التوجيه للمجال نفسه.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "يتعذر السماح باستخدام دليل واحد لتخزين محتوى SSL/TLS ومحتوى غير SSL/TLS: دعم SSL/TLS ليس قيد التشغيل.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "يتعذر تشغيل دعم SSL/TLS: لم يتم تثبيت شهادة SSL/TLS.",
    'hst_def__url_is_invalid' => "رابط URL غير صالح.",
    'hst_def__virtual_host_access' => "وصول المضيف الظاهري للمجال 1%",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "تحذير. يستخدم هذا المضيف الافتراضي عنوان IP غير موجود للاستضافة.",
    'hst_def__you_have_no_ips' => "ليس لديك أي عناوين IP متوفرة وغير مسموح لك بإنشاء استضافة تعتمد على الاسم.",
    'hst_sel__header' => "لاستضافة موقع على هذا الخادم، حدد خيار الاستضافة المادية. لإعداد إعادة توجيه المجال إلى موقع على جهاز آخر، حدد خيار إعادة توجيه الإطار أو إعادة التوجيه القياسي. في حالة استخدام إعادة التوجيه القياسي، ستتم إعادة توجيه المستخدم إلى الموقع وسيتم عرض عنوان URL للموقع الحقيقي في متصفّح المستخدم، وبذلك يتمكن المستخدم من معرفة عملية إعادة التوجيه. عبر استخدام إعادة توجيه الإطار، تتم إعادة توجيه المستخدم للموقع دون معرفة أن الموقع يوجد على موقع آخر بالفعل.",
    'hst_sel__physical_hst' => "الاستضافة المادية",
    'hst_sel__select_hst_type' => "حدد نوع الاستضافة للمجال",
    'hst_sel__select_hst_type_warning' => "حدد نوع الاستضافة للمجال",
    'hst_sel__hosting_exists' => "تعذر إنشاء الاستضافة، حيث تم تكوينها بالفعل لهذا المجال. ستتم إعادة توجيهك لصفحة إدارة الاستضافة.",
    'hst_sel__standard_frw' => "إعادة التوجيه القياسي",
    'hst_sel__frame_frw' => "إعادة توجيه الإطار",
    '__frame_frw' => "إعادة توجيه الإطار",
    '__hosting_exists' => "تعذر إنشاء الاستضافة، حيث تم تكوينها بالفعل لهذا المجال. ستتم إعادة توجيهك لصفحة إدارة الاستضافة.",
    '__choose_hst_type' => "حدد نوع الاستضافة المطلوب.",
    '__no_hst_conf' => "لم يتم تكوين أي استضافة لمجالك.",
    '__physical_hst' => "الاستضافة المادية",
    '__select_hst_type' => "حدد نوع الاستضافة للمجال",
    '__standard_frw' => "إعادة التوجيه القياسي",
    '__warning' => "تحذير! سيتم تجاهل جميع المعلمات التي تم تعيينها قبل ذلك. هل ترغب بالتأكيد في تغيير نوع الاستضافة؟",
    'i_cl_off' => "العميل غير نشط؟",
    'i_cl_off_by_admin' => "حساب العميل معلّق من قبل مسؤول الخادم.",
    'i_cl_off_expired' => "انتهت صلاحية حساب العميل.",
    'i_cl_on' => "العميل نشط.",

    'icf__title' => 'جدار حماية الاتصال بالإنترنت',
    'icf__if_legend' => 'واجهات المستخدم',
    'icf__mode' => 'الوضع',

    'invalid_value' => 'قيمة غير صالحة.',

    'ip_addr__already_exists' => "عنوان IP %1 موجود بالفعل.",
    'ip_addr__cant_add' => "عنوان IP %1 غير موجود أو مخصص لمجموعة IP لعميل آخر",
    'ip_addr__cl_list_for_ip' => "بائعو التجزئة الذين يستخدمون 1% عنوان IP %2",
    'ip_addr__cl_list_for_ip_add' => "إضافة عنوان IP إلى مجموعة بائعي التجزئة",
    'ip_addr__domains_list_for_ip' => "مواقع الويب التي تستخدم 1% عنوان IP %2",
    'ip_addr__ip_used_by_hst_or_frw' => "عنوان IP %1 مستخدم لاستضافة إعادة التوجيه.",
    'ip_addr__only_one_ip_and_client_have_domain' => "لا يمكن إزالة عنوان IP هذا لوجود مجالات أخرى مستضافة على هذا العنوان.",
    'ip_addr__remove_ip_addr' => "ستتم إزالة عناوين IP هذه من النظام:",
    'ip_addr__select_clients' => "حدد عملاء",
    'ip_addr__select_ip_addr_to_remove' => "حدد عناوين IP التي ترغب في إزالتها.",
    'ip_addr__unallowed_by_license' => "هذه النسخة من Plesk غير مرخصة للعمل على عنوان IP %1. نطاقات IP المسموح بها هي: %2.",
    'ip_alias__interface' => "واجهة المستخدم",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "عنوان 1% IP المخصص للاستضافة الظاهرية التي تعتمد على الاسم غير صالح.",
    'ip_alias__invalid_ip_or_netmask' => "زوج عنوان IP/ قناع الشبكة غير صالح.",
    'ip_alias__orig_ip_can_not_be_deleted' => "عنوان IP address %1 هو عنوان IP الخادم الأصلي، لذا لا يمكنك إزالته.",
    'ip_alias__ip_is_invalid' => "عنوان 1% IP غير صالح.",
    'ip_alias__ip_mask_is_invalid' => "قناع 1% IP غير صالح.",
    'ip_alias__ip_not_exist' => "عنوان IP %1 غير موجود.",
    'ip_alias__ip_address_and_mask' => 'عنوان IP وقناع الشبكة الفرعية',
    'ip_alias__mask' => "‫قناع الشبكة الفرعية‬",
    'ip_alias__remove_selected_ip_aliases?' => "هل ترغب بالتأكيد في إزالة عناوين IP المحددة؟",
    'ip_alias__select_ip' => "حدد عنوان IP واحدًا على الأقل من القائمة لإزالته.",
    'ip_alias__this_ip_used_for_domain' => "(1%) عنوان IP هذا مستخدم للمجال 2%.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(1%) عنوان IP هذا مستخدم لعمليات الاستضافة الظاهرية التي تعتمد على الاسم.",
    'ip_alias__unable_add_ip' => "تعذرت إضافة عنوان IP: 1%",
    'ip_alias__unable_remove_ip' => "تعذرت إزالة عنوان IP: 1%",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "لا يمكنك تغيير نوع عنوان IP إلى \"مشترك\"، حيث إن ذلك سيجعل FTP المجهول للمجال'\\1%'\\  غير متوفر.",
    'ip_ctrl__ip_addr' => "عنوان IP %2 على واجهة المستخدم 2%",
    'ip_ctrl__ip_exists_many_pools' => "لا يمكنك تغيير نوع عنوان IP. ينتمي عنوان IP هذا إلى مجموعات من عدة مستخدمين في الوقت نفسه.",
    'ip_ctrl__ssl_cert' => "شهادة SSL/TLS",
    'ip_pool__ip_address_is_absend_in_pool' => "عنوان IP مفقود.",
    'ip_pool__ip_pool_for_client' => "مجموعة عناوين IP للعميل 1%",
    'ip_pool__no_cliens_avail' => "لا يتوفر أي عملاء.",
    'ip_pool__no_vacant_ips' => "لا توجد عناوين IP فارغة.",
    'ip_pool__pool_is_empty' => "مجموعة عناوين IP فارغة.",
    'ip_pool__remove_ip_addr' => "ستتم إزالة عناوين IP هذه من المجموعة 1%:",
    'ip_pool__select_free_ips' => "عناوين IP فارغة",
    'limit__date_in_past' => "فترة الصلاحية غير صالحة. 1% تاريخ ماض.",
    'limit__enter_date' => "أدخل تاريخًا",
    'limit__max_db' => "قواعد البيانات",
    'limit__name_disk_space' => "مساحة القرص",
    'limit__name_max_box' => "علب البريد",
    'limit__name_max_db' => "قواعد بيانات MySQL",
    'limit__name_max_dom' => "المجالات",
    'limit__name_max_maillists' => "قوائم المراسلة",
    'limit__name_max_subdom' => "المجالات الفرعية",
    'limit__name_max_traffic' => "حركة مرور البيانات",
    'limit__name_max_wu' => "مستخدمو الويب",
    'limit__name_mbox_quota' => "حصة علبة البريد",
    'limit__name_max_mn' => "حسابات البريد",
    'limit__name_max_cl' => 'العملاء',
    'limit__name_total_mboxes_quota' => "إجمالي حصة علبة البريد",
    'limit__name_mysql_dbase_space' => "مساحة قاعدة بيانات MySQL",
    'limit__name_mssql_dbase_space' => "مساحة قاعدة البيانات MSSQL",
    'limit__name_expiration' => 'تاريخ انتهاء الصلاحية',

    'locale_upload__title' => 'إضافة موقع',
    'locale_upload__file_name' => 'مسار موقع ملف حزمة اللغة',
    'locale_upload__unable_to_install' => 'يتعذر تثبيت ملف حزمة اللغة',
    'locale_upload__wrong_package' => 'الملف الذي حملته لا يحتوي على حزمة لغة صالحة لهذا الإصدار من Plesk.',
    'locale_upload__wrong_locale' => 'الملف الذي حملته لا يحتوي على حزمة لغة صالحة.',

    'locales_remove__title' => 'إزالة المواقع',
    'locales_remove__select_locales_for_remove' => 'حدد المواقع لإزالتها.',
    'locales__can_not_remove' => 'تتعذر إزالة حزمة اللغة للموقع 1%: %2',

    'ma__create_title' => 'إنشاء أسماء مستعارة للبريد لـ 1%',
    'ma__edit_title' => "تعديل الأسماء المستعارة للبريد 1%",
    'ma__enter_new_alias' => "أدخل اسمًا مستعارًا جديدًا.",
    'ma__invalid_alias' => "الأسماء المستعارة للبريد غير صالحة.",
    'ma__mail_aliases_mailname' => "الأسماء المستعارة للبريد لحساب البريد 1%",
    'ma__mailname_does_not_exist' => "حساب البريد غير موجود.",
    'ma__select_ma_for_remove' => "حدد الأسماء المستعارة للبريد التي ترغب في إزالتها.",
    'ma__unable_to_add_new_ma' => "تعذر إضافة اسم مستعار إلى البريد: 1%",

    'mail_queue__not_allowed_by_license_key' => 'لا يسمح مفتاح الترخيص بإدارة قائمة انتظار البريد.',
    'maillist__' => "قائمة المراسلة 1%",
    'maillist__already_exists' => "قائمة المراسلة موجودة بالفعل.",
    'maillist__mail_alias_already_exists_in_this_domain' => "الأسماء المستعارة للبريد 1% موجودة بالفعل في هذا المجال",
    'maillists__' => "قوائم المراسلة 1%",
    'maillists__limit_cl_max_maillists' => "وصل العميل إلى الحد الأقصى لعدد قوائم المراسلة (الحد: 1%، مستخدم: %2)",
    'maillists__limit_dom_max_maillists' => "وصل المجال إلى الحد الأقصى لعدد قوائم المراسلة.",
    'maillists__list' => "قوائم المراسلة",
    'maillists__mailman_not_installed_or_conf' => "ملحقات خادم Mailman ليست مثبتة حاليًا أو ليست مكوّنة على الخادم. اتصل بمسؤول الخادم لتثبيت ملحقات خادم Mailman أو تكوينها بشكل صحيح.",
    'maillists__status' => "تم تشغيل خدمة قائمة المراسلة",
    'maillists__unable_to_delete__' => "يتعذر حذف قائمة المراسلة: 1%",
    'maillists__disabled_text' => 'لا يمكنك إدارة قوائم المراسلة لأن مكون خادم قوائم مراسلات Mailman غير مثبّت أو غير مكوّن.',
    'maillist_member__already_exists' => 'مشترك قائمة المراسلة موجود بالفعل.',
    'maillist_member__not_exists' => 'لا يوجد مثل هذا المستخدم في قائمة المراسلة.',
    'mailserver_switching_warning' => "تحذير! الغرض من تغيير خادم البريد هو استخدامه في الإعداد الأولي فقط، وإذا كان الخادم مستخدمًا بالفعل، فسيؤدي إلى حدوث المشكلات التالية: فقد الإعدادات ومحتويات علب البريد، وفي بعض تلك الحالات حينما يكون الخادم الذي تحوّله مكوّنًا بالفعل، يحدث العديد من التعارضات. إذا كان هذا الخادم مستخدمًا الآن وكنت عازمًا على التحويل إلى خادم آخر، فيمكنك إبلاغ عملائك بخصوص العملية حتى يتمكنوا من تنزيل رسائل البريد الخاصة بهم وحفظها.",
    'manager__access_denied' => "تم رفض الوصول: 1%",
    'manager__admin' => "المسؤول",
    'manager__client' => 'العميل',
    'manager__domain' => "المجال",
    'manager__domain_cl_limit_exceeding' => "وصل حساب العميل هذا إلى الحد الأقصى لعدد المجالات.",
    'manager__domain_is_not_yours' => "المجال 1% ليس ملكًا لك.",
    'manager__domain_key_limit_exceeding' => "تم الوصول إلى الحد الأقصى لإنشاء المجالات الذي يحدده مفتاح ترخيصك.",
    'manager__no_perm_to_call' => "ليس لديك إذن الاتصال بـ 1%.",
    'manager__no_perm_to_create_domains' => "ليس لديك إذن بإنشاء مجالات.",
    'manager__no_perm_to_modify_domain' => "ليس لديك إذن بتعديل المجال 1%.",
    'manager__no_perm_to_modify_domains' => "ليس لديك إذن بتعديل مجالات.",
    'manager__no_perm_to_remove_domain' => "ليس لديك إذن بإزالة المجال 1%.",
    'manager__no_perm_to_remove_domains' => "ليس لديك إذن بإزالة مجالات.",
    'manager__node_doesnt_exist' => "1% غير موجود.",
    'manager__user_disabled' => "تم تعليق حسابك. لا يمكنك تشغيل النظام.",
    'mail_quota_unsupported' => "لا يدعم خادم البريد الإلكتروني ذلك",
    'mbox_quota_unsupported' => "لا يدعم خادم البريد الإلكتروني ذلك",
    'mn__create_title' => "إنشاء حساب بريد",
    'mn__edit_title' => "الإعدادات",
    'mn__files_list_title' => "ملفات المرفقات",
    'mn__files_remove' => "إزالة الملفات من مستودع المرفقات. من المحتمل استخدام هذه الملفات من خلال الردود التلقائية. ستتم إزالتها من كل من المستودع والردود التلقائية التي تستخدمها.",
    'mn__files_select_for_remove' => "حدد الملفات التي ترغب في إزالتها.",
    'mn__mail_alias_form' => "نموذج الاسم المستعار للبريد",
    'mn__mail_aliases_list' => "الأسماء المستعارة للبريد",
    'mn__mailbox' => "إدارة علبة البريد",
    'mn__unable_define_mn' => "تعذر إعداد حسابات البريد: 1%",
    'mn__unable_remove_mbox_quota' => "تعذرت إزالة حصة علبة البريد: 1%",
    'mn__upload_file' => "تحميل ملف",
    'mn_edit__attach_filename_changed' => 'تمت إعادة تسمية الملف 1% إلى 2% لأن اسمه احتوى على رموز غير أحرف ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "يجب إضافة عضو مجموعة بريد قبل تمكين مجموعة البريد.",
    'mn_edit__add_resp_or_turn_off_box' => "يجب إضافة رد تلقائي أو إلغاء تحديد مربع اختيار الرد التلقائي.",
    'mn_edit__attachments' => "المرفقات",
    'mn_edit__dom_quota_less_then_quota' => "يجب ألا يتجاوز حجم علبة البريد حد مقدار مساحة القرص المخصص لعلب البريد في هذا المجال.",
    'mn_edit__enter_external_rcpnt_email' => "أدخل البريد الإلكتروني لعضو مجموعة البريد الخارجي",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "اكتب عنوانًا لإعادة توجيه البريد أو ألغ تحديد مربع الاختيار.",
    'mn_edit__ext_rcpnt_email_invalid' => "عنوان البريد الإلكتروني للمستقبل الخارجي غير صالح.",
    'mn_edit__file_exists' => "الملف موجود. هل ترغب في الكتابة فوقه؟",
    'mn_edit__files_deld_from_repository' => "سيتم حذف هذه الملفات من المستودع والردود التلقائية التي تحتوي عليها. هل ترغب في المتابعة؟",
    'mn_edit__mail_name' => "حساب البريد",
    'mn_edit__mail_name_invalid' => "اسم حساب البريد غير صالح.",
    'mn_edit__mail_redir' => "أدوات توجيه البريد",
    'mn_edit__mail_redir_add' => "إضافة عضو مجموعة بريد",
    'mn_edit__mail_resps' => "الردود التلقائية على البريد",
    'mn_edit__mailbox' => "علبة البريد",
    'mn_edit__enable_mailbox' => "علبة البريد",
    'mn_edit__mailgroup' => "مجموعة البريد",
    'mn_edit__mailgroup_addresses' => "أعضاء مجموعة بريد",
    'mn_edit__mailgroup_disabled' => "لا يتوفر إلا بعد إضافة حساب البريد بالفعل.",
    'mn_edit__max_dom_quota' => "افتراضي للمجال (1%)",
    'mn_edit__mbox_quota_invalid' => "تم تحديد حجم علبة بريد خاطئ.",
    'mn_edit__new_resp_name' => "اسم رد تلقائي جديد",
    'mn_edit__no_autoresponders' => "يجب إضافة رد تلقائي واحد على الأقل قبل تشغيل/إيقاف تشغيل خدمة الرد التلقائي.",
    'mn_edit__no_file_sel' => "لم يتم تحديد أي ملفات.",
    'mn_edit__no_mail_addresses' => "لم يتم تحديد عناوين بريد إلكتروني أو اختيارها.",
    'mn_edit__none' => "بلا",
    'mn_edit__not_create_pass' => "لن ينشئ ذلك كلمة مرور لهذا الحساب. بدون كلمة المرور، لن يتمكن المستخدم من عرض رسالة البريد أو إرسالها.",
    'mn_edit__redir_email_invalid' => "عنوان إعادة التوجيه غير صالح.",
    'mn_edit__redirect_addr' => "عنوان إعادة التوجيه",
    'mn_edit__remove_autoresp?' => "هل ترغب بالتأكيد في إزالة الرد التلقائي؟",
    'mn_edit__remove_rcpnts?' => "هل ترغب بالتأكيد في إزالة هؤلاء المستلمين؟",
    'mn_edit__repository' => "المستودع",
    'mn_edit__resps_attach' => "ملفات مرفقات الرد التلقائي",
    'mn_edit__select_rcpnt_from_list' => "حدد مستلمًا واحدًا على الأقل من القائمة لإزالته.",
    'mn_edit__select_registered_users' => "حدد المستخدمين المسجلين",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "لقد اخترت أن يكون لديك علبة بريد لكنك لم تعيّن كلمة المرور لها.",
    'mn_edit__unable_act_deact_mail_group' => "تعذر تنشيط أو إلغاء تنشيط مجموعة البريد: 1%",
    'mn_edit__unable_act_deact_mail_redir' => "تعذر تنشيط أو إلغاء تنشيط إعادة توجيه البريد: 1%",
    'mn_edit__unable_act_deact_postbox' => "تعذر تنشيط أو إلغاء تنشيط علبة البريد: 1%",
    'mn_edit__unable_act_deact_resp' => "تعذر تنشيط أو إلغاء تنشيط الردود التلقائية: 1%",
    'mn_edit__unable_add_attach' => "يتعذر إضافة ملف مرفق. 1%",
    'mn_edit__unable_add_mail_group_member' => "تعذرت إضافة عضو مجموعة بريد: 1%",
    'mn_edit__unable_add_resp' => "تعذرت إضافة رد تلقائي: 1%",
    'mn_edit__unable_change_mail_name' => "تعذر تغيير اسم حساب البريد: 1%",
    'mn_edit__unable_deactivate_mail_group' => "تعذر إلغاء تنشيط مجموعة البريد: 1%",
    'mn_edit__unable_deactivate_resp' => "تعذر إلغاء تنشيط الردود التلقائية: 1%",
    'mn_edit__unable_define_resp_id' => "تعذّر تحديد معرّف الرد التلقائي: 1%",
    'mn_edit__unable_remove_attach' => "يتعذر إزالة ملف (ملفات) مرفق: 1%",
    'mn_edit__unable_remove_autoresp' => "تعذرت إزالة رد تلقائي: 1%",
    'mn_edit__unable_remove_mail_group_member' => "تعذرت إزالة أعضاء مجموعة البريد: 1%",
    'mn_edit__wrong_way' => 'لن يتم تسليم الرسائل الموجهة إلى 1%، حيث إن حساب البريد هذا لا يحتوي على علبة بريد أو أداة توجيه البريد قيد التشغيل.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'تم إيقاف تشغيل علبة البريد في العنوان 1%. The messages in the mailbox were not removed, but you will not be able to retrieve them through IMAP or POP3 protocol.',
    'mn_list__mail_names_for_domain' => "حسابات البريد ضمن المجال 1%",
    'mn_list__sa_cannot_unable' => "تعذر تشغيل عوامل تصفية البريد العشوائي",
    'mn_list__tab_cp_access' => "‫L‬",
    'mn_list__tab_title_client' => 'العميل',
    'mn_list__tab_title_domain' => 'المجال',
    'mn_list__tab_title_autoresp' => "‫A‬",
    'mn_list__tab_title_box' => "بايت",
    'mn_list__tab_title_group' => "غيغا",
    'mn_list__tab_title_name' => "الاسم",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "‫S‬",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "تعذرت إزالة حسابات البريد: 1%",
    'module_upload__module_was_installed' => 'هذه الوحدة مثبّتة بالفعل. إذا كنت ترغب في تثبيت نسخة أحدث من هذه الوحدة، فيُرجى إزالة تثبيت الوحدة عبر Plesk، ثم محاولة التثبيت.',
    'module_upload__unable_to_install' => 'تعذر تثبيت ملف حزمة الوحدة',
    'module_upload__wrong_package' => 'الملف الذي تم تحميله ليس حزمة وحدة مدعومة.',
    'module_upload__wrong_module' => 'الملف الذي تم تحميله لا يحتوي على حزمة الوحدة.',

    'news_articles_title' => 'أخبار Plesk',
    'notification_text__invalid_subject_length' => "طول موضوع إشعار غير صالح. ينبغي أن يكون من 1 إلى 255 حرفًا.",
    'notification_text__invalid_text_length' => "طول رسالة الإشعار غير صالح. يجب أن يكون طول الرسالة من 1 إلى 65533 رمزًا.",
    'notification_text__subject' => "موضوع الإشعار",
    'notification_text__text' => "نص الإشعار",
    'notification_text__title' => "تحرير الإشعار",
    'notification_text__unable_set_text' => "تعذر تعديل نص الإشعار:",

    'odbc__cant_add_dsn' => "تعذرت إضافة DSN %1: %2",
    'odbc__cant_build_connection_string' => "تعذر الاتصال باستخدام المعلمات المحددة، يُرجى إعادة المحاولة باستخدام معلمات مختلفة. تم إرجاع الأداة المساعدة: 1%",
    'odbc__cant_connect' => "تعذر الاتصال بمصدر البيانات باستخدام الإعدادت المحددة. تم إرجاع الخادم: 1%",
    'odbc__cant_delete_dsn' => "تعذر حذف DSN %1: %2",
    'odbc__cant_get_drivers_info' => "تعذّر الحصول على معلومات من برامج التشغيل.",
    'odbc__cant_get_drivers' => "تعذر استرداد قائمة برامج تشغيل ODBC: 1%",
    'odbc__cant_get_list' => "تعذر استرداد قائمة معلومات DSN الحالية: 1%",
    'odbc__cant_get_servers_list' => "تعذر استرداد قائمة الخوادم.",
    'odbc__cant_open_info_file' => "تعذّر فتح الملف باستخدام معلومات برامج التشغيل ODBC.",
    'odbc__cant_parse_string' => "تعذّر تحليل سلسلة الاتصال.",
    'odbc__connect_success' => "اتصال ناجح",
    'odbc__driver_not_set' => "لم يتم تعيين برنامج التشغيل",
    'odbc__driver_or_name_not_set' => "لم يتم تعيين برنامج التشغيل أو اسم اتصال ODBC",
    'odbc__dsn_already_exists' => "يوجد DSN بهذا الاسم (%1) بالفعل في النظام",
    'odbc__dsn_not_exists' => "DSN المحدد غير موجود",
    'odbc__enter_connection_params' => "إعداد اتصال ODBC",
    'odbc__enter_dsn_name' => "أدخل اسم DSN",
    'odbc__invalid_dsn_name' => "اسم اتصال ODBC (%1) به خطأ في بناء الجملة: يُرجى استخدام الرموز الأبجدية الرقمية فقط.",
    'odbc__no_such_driver' => "برنامج تشغيل ODBC بهذا الاسم (1%) غير مدعوم.",
    'odbc__remove_page_title' => "ستتم إزالة اتصالات ODBC DSN التالية:",
    'odbc__select_dsn_to_remove' => "حدد اتصالات DSN التي ترغب في إزالتها.",
    'odbc__unknown_driver' => "اسم محرك غير معروف (1%).",
    'odbc_add_new' => "إضافة اتصال DSN:",
    'odbc_driver' => "برنامج تشغيل",
    'odbc_dsn_description' => "وصف الاتصال",
    'odbc_dsn_list' => "اتصالات ODBC DSN",
    'odbc_dsn_name' => "اسم الاتصال",
    'odbc_dsn_system' => "DSN النظام",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => 'إضافة ODBC DSN',
    'odbc_req_field_not_set' => "المعلّمات المطلوبة غير موجودة.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'مسار ملف قاعدة البيانات',
    'odbc__access_pagetimeout' => 'الفترة الزمنية، بجزء من عشرة من الثانية، التي تظل فيها صفحة غير مستخدمة في المخزن المؤقت. ينطبق هذا الخيار على جميع مصادر البيانات التي تستخدم برنامج تشغيل Microsoft Access.',
    'odbc__access_maxbuffersize' => 'حجم المخزن المؤقت الداخلي، بالكيلوبايت، يقارب 256 كيلوبايت.',
    'odbc__access_readonly' => 'تعيين قاعدة البيانات للقراءة فقط لحظر أي تحديثات.',
    'odbc__access_exclusive' => 'تعيين قاعدة البيانات بشكل حصري لحظر التحديثات المشتركة.',
    'odbc__access_safetransactions' => 'عند تعيينها على صفر (الإعداد الافتراضي)، يتم تخصيص جميع المعاملات في الحال. عند تعيينها على 1، يتم حفظ كل التحديثات على القرص فقط بعد عملية تخصيص، في حين يقل الأداء بشكل طفيف.',
    'odbc__access_threads' => 'عدد العمليات الجزئية في الخلفية الذي سيستخدمه المحرك.',
    'odbc__access_maxscanrows' => "عدد الصفوف التي سيتم فحصها عند إعداد نوع بيانات العمود استنادًا إلى البيانات الموجودة.",
    'odbc__access_implicitcommitsync' => 'تحديد كيفية كتابة التغييرات التي تتم خارج أحد التحويلات على قاعدة البيانات.',
    'odbc__access_usercommitsync' => 'يحدد ما إذا كان برنامج تشغيل MS Access سينفذ معاملات يحددها المستخدم صراحة بشكل غير متزامن.',
    'odbc__mssql_server' => 'الخادم',
    'odbc__mssql_uid' => 'معرّف تسجيل الدخول',
    'odbc__mssql_pwd' => 'كلمة المرور',
    'odbc__mssql_database' => 'قاعدة البيانات الافتراضية لمصدر بيانات ODBC',
    'odbc__mssql_app' => 'اسم التطبيق',
    'odbc__mssql_wid' => 'معرّف محطة العمل',
    'odbc__mssql_language' => 'اللغة الوطنية الافتراضية التي سيتم استخدامها',
    'odbc__mssql_oemtoansi' => 'تحويل الرموز الممتدة إلى قيم OEM',
    'odbc__mysql_server' => 'اسم مضيف خادم MySQL',
    'odbc__mysql_database' => 'قاعدة البيانات الافتراضية',
    'odbc__mysql_user' => 'اسم المستخدِم المستخدَم لتوصيل MySQL',
    'odbc__mysql_password' => 'كلمة مرور حساب المستخدم على الخادم',
    'odbc__mysql_port' => 'منفذ TCP/IP الذي سيُستخدم في حالة كون الخادم ليس هو المضيف المحلي',
    'odbc__mysql_socket' => 'أنبوبة الاتصال المسماة Windows للاتصال بها إذا كان الخادم هو المضيف المحلي',
    'odbc__mysql_option' => 'الخيارات التي تحدد طريقة عمل MyODBC. اطلع على <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'مسار ملف قاعدة البيانات',
    'odbc__excel_defaultdir' => 'دليل البيانات الافتراضي',
    'odbc__excel_fil' => 'إصدار قاعدة البيانات',
    'odbc__excel_maxbuffersize' => 'أقصى حجم للمخزن المؤقت',
    'odbc__excel_pagetimeout' => 'مهلة الصفحة',

    'pb__aliases' => "الأسماء المستعارة",
    'pb__anonftp' => "FTP مجهول",
    'pb__autoinstaller_releases' => 'أداة التحديث',
    'pb__cert' => "الشهادات",
    'pb__cl_pool' => "عناوين IP",
    'pb__cl_pool_ctrl' => "1%",
    'pb__cl_pref' => "الإعدادات",
    'pb__cl_rpt' => "تقرير",
    'pb__cl_rpt_list' => "تخصيص",
    'pb__cl_templates' => "قوالب العميل",
    'pb__cl_traffic' => "نسبة استخدام الشبكة",
    'pb__cl_traffic_history' => "سجل حركة مرور البيانات",
    'pb__cl_traffic_of' => "عدد زوار 1%",
    'pb__client' => "1%",
    'pb__clients' => "العملاء",
    'pb__comp_info' => "مكونات الخادم",
    'pb__common_acl' => 'السماح بنقل ACL',
    'pb__cp_access' => "الوصول",
    'pb__crontab' => "برنامج الجدولة",
    'pb__scheduler' => "برنامج الجدولة",
    'pb__custom_buttons' => "أزرار مخصصة",
    'pb__databases_db' => 'قواعد البيانات',
    'pb__sqlservers_db' => 'خوادم SQL',//to check
    'pb__db' => "قواعد البيانات",
    'pb__db_edit' => "1%",
    'pb__db_server_edit' => '1%',
    'pb__db_servers' => 'خوادم قاعدة البيانات',
    'pb__dl_usr_ed' => "مسؤول المجال",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "1%",
    'pb__dom_lim' => "حدود المجال",
    'pb__dom_pref' => "الإعدادات",
    'pb__dom_sum_report' => "تقرير تلخيص المجال",
    'pb__dom_templates' => "قوالب المجال",
    'pb__dom_traffic' => "عدد زوار 1%",
    'pb__dom_traffic_history' => "سجل حركة مرور البيانات",
    'pb__domains' => "المجالات",
    'pb__domain_aliases' => 'الأسماء المستعارة للمجالات',
    'pb__dumps_list' => "تخزين ملفات النسخ الاحتياطي",
    'pb__forwarding_setup' => "إعداد إعادة التوجيه",
    'pb__filemanager' => "إدارة الملفات",
    'pb__ip_aliasing' => "عناوين IP",
    'pb__ip_clients' => "إزالة عناوين IP",
    'pb__license_management' => 'معلومات الترخيص',
    'pb__locales' => 'المواقع',
    'pb__log_files' => "ملفات السجل",
    'pb__mail' => 'البريد',
    'pb__mail_name_files' => "ملفات المرفقات",
    'pb__mail_name_redirects' => "أدوات توجيه البريد",
    'pb__mail_name_resp_attach_add' => "مرفقات جديدة",
    'pb__mail_name_resp_edit' => "1%",
    'pb__mail_name_responders' => "الردود التلقائية على البريد",
    'pb__mail_names' => "البريد",
    'pb__maillists' => "قوائم المراسلة",
    'pb__mimetypes' => 'أنواع MIME',
    'pb__modules' => 'الوحدات',
    'pb__modules_management' => 'إدارة الوحدات',
    'pb__notifications' => "الإشعارات",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "إعداد الاستضافة المادية",
    'pb__prtd_dirs' => "أدلة محمية",
    'pb__prtdir_edit' => "1%",
    'pb__report' => "تقرير",
    'pb__report_auto' => "موعد التسليم لـ 1%",
    'pb__report_list' => "تخصيص",
    'pb__server' => "الخادم",
    'pb__sessions' => "جلسات العمل",
    'pb__sapp_pool' => "مجموعة تطبيقات الويب",
    'pb__siteapp_install' => 'تثبيت تطبيقات الويب',
    'pb__site_app_pkgs' => 'تطبيقات الويب',
    'pb__site_apps' => "تطبيقات الويب",
    'pb__additional_key_info' => 'الخصائص الرئيسية',
    'pb__additional_key_properties' => 'الخصائص الرئيسية',
    'pb__skeleton' => 'قالب المضيف الظاهري',
    'pb__skins' => 'الأسطح',
    'pb__skin_info' => '1%',
    'pb__spamassassin' => "عامل تصفية البريد العشوائي",
    'pb__statistics' => "إحصائيات",
    'pb__subdom_ctrl' => "1%",
    'pb__subdomains' => "المجالات الفرعية",
    'pb__templates' => "القوالب",
    'pb__virtualdirs' => 'أدلة ظاهرية',
    'pb__web_users' => "مستخدمو الويب",
    'pb__webalizer_preferences' => 'إعدادات إحصائيات الويب',
    'pdir__enter_dir_name' => "أدخل اسم الدليل.",
    'pdir__invalid_hst' => "نوع الاستضافة غير صالح. يجب أن يكون من النوع المادي.",
    'pdir__pd_id_is_undefined' => "معرف الدليل المحمي غير معرّف.",
    'pdir__pdir_exist' => "الدليل الذي يحمل هذا الاسم محمي بالفعل.",
    'pdir__pdir_not_exist' => "الدليل المحمي غير موجود.",
    'pdir__pdir_usr_not_exist' => "مستخدم الدليل المحمي غير موجود.",
    'pdir__prdirs_for_domain' => "الأدلة المحمية الموجودة ضمن موقع الويب 1%",
    'pdir__prdirs_for_subdomain' => "الأدلة المحمية للمجال الفرعي 1%",
    'pdir__remove_pdir_usrs' => "ستتم إزالة المستخدمين التالين للدليل المحمي 2% ضمن موقع الويب 1%:",
    'pdir__remove_pdir_usrs_on_subdom' => "ستتم إزالة المستخدمين التالين للدليل المحمي 2% ضمن المجال الفرعي 1%:",
    'pdir__remove_pdirs_on_dom' => "ستؤدي هذه العملية إلى إزالة الحماية من الأدلة ضمن موقع الويب 2% التي يملكها العميل 1%. لن يتم حذف الأدلة.",
    'pdir__remove_pdirs_on_subdom' => "ستؤدي هذه العملية إلى إزالة الحماية من الأدلة ضمن المجال الفرعي 1%. لن يتم حذف الأدلة.",
    'pdir__select_pdir_usrs_for_remove' => "حدد مستخدمي الدليل المحمي لإزالتهم.",
    'pdir__select_pdirs_to_remove' => "حدد الأدلة لإزالة الحماية منها.",
    'pdir__unable_define_pdir_users' => "تعذّر تعريف مستخدمي الدليل المحمي.",
    'pdir__unable_define_pdirs_properties' => "تعذر تعيين خصائص الأدلة المحمية: 1%",
    'pdir__unable_select_dom_param' => "تعذّر تحديد معلمات المجال: 1%",
    'pdir_ed__create_pdir_for_domain' => "إنشاء دليل محمي ضمن الموقع 1%",
    'pdir_ed__create_pdir_for_subdomain' => "إنشاء دليل محمي ضمن المجال الفرعي 1%",
    'pdir_ed__dir_already_protect' => "هذا الدليل محمي بالفعل.",
    'pdir_ed__head_txt' => "عنوان المنطقة المحمية",
    'pdir_ed__invalid_login' => "لقد حددت اسم مستخدم غير صحيح.",
    'pdir_ed__login_exists' => "هذا المستخدم موجود بالفعل. جرب اختيار اسم مستخدم آخر.",
    'pdir_ed__new_usr' => "اسم المُستخدِم",
    'pdir_ed__non_ssl' => "غير SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "اسم الدليل",
    'pdir_ed__pdir_for_domain' => "الدليل المحمي 1% على المجال 2%",
    'pdir_ed__pdir_for_subdomain' => "الأدلة المحمية %1 الموجودة ضمن المجال الفرعي 2%",
    'pdir_ed__pdir_location' => "موقع الدليل",
    'pdir_ed__pdir_users' => "مستخدمو الدليل المحمي",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "SSL/TLS غير مدعومة بواسطة هذا الموقع أو غير متوفرة حسب اشتراكك. لتشغيل دعم SSL/TLS، انتقل إلى مواقع الويب & علامة التبويب النطاقات، وانقر فوق اسم النطاق في القائمة. إذا لم يكن دعم SSL/TLS متوفرًا ضمن اشتراكك، فاتصل بموفر الاستضافة لترقية خطة الاستضافة الخاصة بك.",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "SSL/TLS غير مدعومة بواسطة هذا الموقع. لتشغيل دعم SSL/TLS، انتقل إلى مواقع الويب & علامة التبويب النطاقات، وانقر فوق اسم النطاق في القائمة.",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "يجب تحديد خانة اختيار واحدة على الأقل من خانتي اختيار SSL/TLS وغير SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "تعذّر إنشاء مستخدم الدليل المحمي: 1%",
    'pdir_ed__unable_create_pdir' => "تعذّر إنشاء الدليل المحمي: 1%",
    'pdir_ed__unable_define_hst_type' => "تعذّر تحديد نوع الاستضافة.",
    'pdir_ed__unable_update_pdir' => "تعذّر حفظ إعدادات الدليل المحمي: 1%",
    'pdir_ed__wrong_symbol_in_header' => "يُرجى عدم استخدام الرمز 1% في عنوان الدليل.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "إنشاء مستخدم للدليل المحمي 1%",
    'pdir_usr_ed__not_create_pass' => "لن يؤدي هذا إلى إنشاء كلمة مرور لمستخدم الدليل المحمي الجديد. لن يتمكن المستخدم من تسجيل الدخول دون كلمة المرور.",
    'pdir_usr_ed__pass_for_pdir_usr' => "كلمة المرور لمستخدم الدليل المحمي 1%",
    'pdir_usr_ed__unable_select_pdir_usr' => "تعذّر تحديد مستخدم الدليل المحمي: 1%",
    'pdir_usrs_list__unable_define_pdir_usrs' => "تعذّر إنشاء مستخدمي الدليل المحمي: 1%",
    'pdir_usrs_list__unable_remove_pd_usrs' => "تعذّرت إزالة مستخدمي الدليل المحمي: 1%",
    'pdirs_list__name' => "الاسم",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "‫S‬",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "تعذرت إزالة الأدلة المحمية: 1%",
    'phosting__anonftp_disabled' => "لا تتوافر خدمة FTP مجهول لهذا المجال لأن عنوان IP هذا مستخدم بالفعل لخدمة FTP مجهول على مجال آخر.",
    'phosting__anonftp_encrypt' => 'كلمة مرور مستخدم FTP مشفرة، ولذا لا يمكن استخدامها لحماية الدليل /plesk-stat/webstat/. يُرجى إعادة إدخال كلمة مرور FTP، أو إلغاء تحديد الخيار "يمكن الوصول إليه عبر دليل محمي بكلمة مرور \'\\/plesk-stat/webstat/\'\\',
    'phosting__hosting_and_dns_ip_difference_warning' => "يُحال اسم المجال %%domain_name%% إلى عنوان IP التالي %dns_ip_address%%. تم تعيين عنوان %%IP %%hosting_ip_address لموقعك على الويب. إذا لم يكن موقعك على الويب يفتح في متصفح ويب عند الإشارة إليه باسم مجاله، فانتقل إلى شاشة إدارة DNS عبر (مجالات> اسم المجال> DNS) وغيّر خصائص سجل المورد A: عيّن عنوان %%IP %%hosting_ip_address لاسم المجال %%domain_name%%.",
    'phosting__ip_change_warning' => "تم تغيير عنوان IP. كما تم إجراء تغييرات مقابلة في منطقة DNS للمجال.",
    'phosting__other_hosting_exists_on_ip' => "تعذّر تغيير الشهادة لأن عنوان IP هذا مستخدم في حساب استضافة واحد أو أكثر.",
    'phosting__unable_to_change_certificate' => "يتعذر تثبيت الشهادة: 1%",
    'phosting__unable_to_change_ip_address' => "تعذّر تغيير عنوان IP: 1%",
    'phosting__unable_to_set_cert' => "يتعذر تعيين شهادة SSL/TLS: %1",
    'phosting__unable_update' => "تعذر تحديث إعدادات الاستضافة: 1%",
    'phosting__unable_manage' => "تعذرت إدارة الاستضافة: 1%",
    'phosting__failed_to_add_logs_fail2ban' => "تعذر تكوين fail2ban لتتبع سجلات النطاق. سيتم تتبع السجلات تلقائيًا في المرة التالية التي تتم فيها إعادة تشغيل خدمة fail2ban.\n%1",

    'picker_acl_record__tittle' => 'حدد سجل ACL',
    'picker_autoresponder__title' => 'حدد ردًا تلقائيًا',
    'picker_black_list__domain_name' => 'حدد اسم مجال',
    'picker_certificate' => 'حدد شهادة SSL/TLS',

    'picker_dns_zone_template__title' => 'حدد سجل مصدر',
    'picker_domain__title' => 'حدد موقع ويب',
    'picker_domain_alias__title' => 'حدد اسمًا مستعارًا للمجال',
    'picker_resource_record__title' => 'حدد سجل مصدر',
    'picker_disabled_resource_record__title' => 'حدد خادم اسم',
    'picker_ip_address__title' => 'حدد عنوان IP',
    'picker_ip_address_clients__title' => 'حدد العملاء الذين يستخدمون عنوان IP هذا',
    'picker_mail_queue' => 'حدد رسائل بريد إلكتروني',
    'picker_site_application__title' => 'حدد تطبيق ويب',
    'picker_subdomain__title' => 'حدد مجالاً فرعيًا',
    'picker_web_user__title' => 'حدد مستخدم ويب',
    'picker_custom_button__title' => 'حدد زرًا مخصصًا',
    'picker_license_key__title' => "تحديد مفتاح الترخيص",
    'picker_spamfilter_address__title' => 'حدد عنوان عوامل تصفية البريد العشوائي',
    'picker_white_list__networks' => 'اختيار الشبكات',

    'plesk_key__action_logs' => "الخروج من الإجراءات التي يقوم بها مستخدمو Plesk",
    'plesk_key__app_vault' => "مخزن التطبيقات",
    'plesk_key__backup' => "وظائف الاستعادة والنسخ الاحتياطي",
    'plesk_key__client_templs' => "إدارة خطط الخدمة",
    'plesk_key__clients' => "حسابات المستخدمين (بائعي التجزئة والعملاء)",
    'plesk_key__resellers_only' => "حسابات المستخدمين (بائعي التجزئة)",
    'plesk_key__customers_only' => "حسابات المستخدمين (العملاء)",
    'plesk_key__domains' => "المجالات",
    'plesk_key__domain_aliases' => "الأسماء المستعارة للمجالات",
    'plesk_key__manage_dashboard' => 'تخصيص الصفحة الرئيسية',
    'plesk_key__drweb' => "إدارة مكافحة الفيروسات",
    'plesk_key__event_manager' => "مدير الأحداث",
    'plesk_key__expirations' => "إدارة تواريخ انتهاء الحسابات",
    'plesk_key__group_ops' => "تعديل كائنات متعددة في وقت واحد",
    'plesk_key__expiration' => "تاريخ انتهاء المفتاح",
    'plesk_key__edition_name' => "نسخة منصة Plesk",
    'plesk_key__key_number' => "رقم المفتاح",
    'plesk_key__languages' => "حزم اللغة",
    'plesk_key__mailnames' => "حسابات البريد",
    'plesk_key__migration_manager' => "مدير الترحيل والنقل",
    'plesk_key__mssql' => "دعم Microsoft SQL Server",
    'plesk_key__myplesk_func' => "ارتباطات لشراء شهادات SSL/TLS وخدمات تسجيل النطاقات",
    'plesk_key__myplesk_server_id' => "معرّف الخادم التابع MPC",
    'plesk_key__notifications' => "إدارة الإعلامات",
    'plesk_key__postgresql' => "دعم خادم قاعدة بيانات PostgreSQL",
    'plesk_key__qmail_queue' => 'إدارة قائمة انتظار البريد',
    'plesk_key__remote_db' => 'استضافة قاعدة البيانات عن بعد',
    'plesk_key__slave_servers' => "الخوادم التابعة",
    'plesk_key__spamassassin' => "إدارة عوامل تصفية البريد العشوائي",
    'plesk_key__subdomains' => "إدارة المجالات الفرعية",
    'plesk_key__sys_access' => "إدارة الوصول إلى الخادم",
    'plesk_key__traffic_reports' => "تقارير استخدام حركة مرور البيانات",
    'plesk_key__tts' => "مكتب المساعدة",
    'plesk_key__virtuozzo' => "صالح مع حاويات Virtuozzo فقط",
    'plesk_key__webusers' => "مستخدمو الويب",
    'plesk_key__license_update_date' => 'التحديث التالي لمفتاح الترخيص',
    'plesk_key__autoinstaller_config' => 'إدارة إعدادات أداة التحديث',
    'plesk_key__check_wrong' => "مفتاح الترخيص غير صالح. إذا أردت استخدام Plesk، فيُرجى الحصول على مفتاح ترخيص صالح جديد وتثبيته.",
    'plesk_key__upload_check_wrong' => 'مفتاح الترخيص الذي تم تحميله غير صالح.',
    'plesk_key__revert_check_wrong' => 'مفتاح الترخيص المثبت مسبقًا غير صالح.',
    'plesk_key__update_check_wrong' => 'مفتاح الترخيص المحدّث غير صالح.',
    'plesk_key__viruozzo_only_key' => 'مفتاح الترخيص مخصص للاستخدام مع تشغيل Plesk في حاويات Virtuozzo فقط.',
    'plesk_key__ip_ranges_exceeded' => 'لا يمكنك استخدام سوى نسخة Plesk المرخصة مع عناوين IP التالية: %2. لا يغطي ترخيصك عناوين IP التالية: 1%.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'يتجاوز عدد الموارد المستخدمة حاليًا الحدود المُحددة في الترخيص الخاص بك.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'يتجاوز عدد مواقع الويب المستضافة على الخادم الحدود المقررة في ترخيصك. لديك 2% من المواقع المستضافة؛ لا يسمح ترخيصك إلا باستضافة 1% فقط من المواقع.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'يتجاوز عدد الأسماء المستعارة للمجال الموجودة على الخادم الحدود المقررة في ترخيصك. لديك 2% من الأسماء المستعارة للمجال؛ لا يسمح ترخيصك إلا باستضافة 1% فقط من الأسماء المستعارة للمجال.',
    'plesk_key__limits_exceeded_lim_cl' => 'تتجاوز حسابات العملاء الذين يحصلون على الخدمة الحدود المقررة في ترخيصك. لديك الآن 2% من حسابات العملاء الذين يحصلون على الخدمة؛ لا يسمح ترخيصك إلا بخدمة 1% فقط من حسابات العملاء.',
    'plesk_key__limits_exceeded_lim_mn' => 'يتجاوز عدد حسابات البريد الإلكتروني التي تحصل على الخدمة الحدود المقررة في ترخيصك. لديك الآن 2% من حسابات البريد الإلكتروني التي تحصل على الخدمة؛ لا يسمح ترخيصك إلا بخدمة 1% فقط من حسابات البريد الإلكتروني.',
    'plesk_key__limits_exceeded_lim_wu' => 'يتجاوز عدد حسابات مستخدمي الويب التي تحصل على الخدمة الحدود المقررة في ترخيصك. لديك الآن 2% من حسابات مستخدمي الويب التي تحصل على الخدمة؛ لا يسمح ترخيصك إلا بخدمة 1% فقط من حسابات مستخدمي الويب.',
    'plesk_key__limits_exceeded_MLS' => 'يتجاوز عدد حزم اللغات المثبتة حاليًا الحدود المقررة في ترخيصك. يوجد 2% من حزم اللغات المثبتة؛ لا يسمح ترخيصك إلا بتثبيت 1% فقط من حزم اللغات.',
    'plesk_key__wrong_version' => '‫أنت تحاول استخدام مفتاح ترخيص تم إنشاؤه لإصدار آخر من Plesk.‬ ‫اتصل بممثلي مبيعات Plesk للحصول على مفتاح الترخيص الصحيح.‬',
    'plesk_key__other_product' => '‫أنت تحاول استخدام مفتاح ترخيص تم إنشاؤه لمنتج آخر.‬ ‫اتصل بممثلي مبيعات Plesk للحصول على مفتاح الترخيص الصحيح.‬',
    'plesk_key__limits_exceeded_error' => 'تعذّر تثبيت مفتاح الترخيص: تتجاوز الكميات المستخدمة حاليًا من الموارد الحدود المقررة ضمن مفتاح الترخيص الذي تم تحميله.',
    'plesk_key__limits_exceeded_note' => 'تتجاوز الكميات المستخدمة حاليًا من الموارد الحدود المقررة ضمن مفتاح الترخيص الذي تم تحميله.',
    'plesk_key__key_file_invalid' => 'ملف المفتاح الذي تم تحميله غير صالح أو لا يحتوي على مفتاح ترخيص.',
    'plesk_key__server_request_error' => 'لا يمكن تحديث الترخيص. تأكد من عدم حظر اتصالات خادم الترخيص ka.plesk.com على منفذ TCP٪ 1. <a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">انظر كيفية القيام بذلك</a>.',
    'key__no_key_file_in_zip' => 'ملف .zip المُحمل لا يحتوي على ملف المفتاح',
    'key__key_upload' => 'تثبيت مفتاح الترخيص',
    'additional_key__prop_name' => 'الخاصية',
    'additional_key__prop_value' => 'القيمة',
    'additional_key__descr_name' => 'اسم المفتاح',
    'additional_key__descr_key_number' => 'رقم المفتاح',
    'additional_key__descr_key_vz' => "مفتاح الترخيص هذا مخصص للاستخدام في حاويات Virtuozzo فقط.",
    'additional_key__descr_key_mailboxes' => 'علب البريد',
    'additional_key__descr_lim_date' => 'تاريخ انتهاء الصلاحية',
    'additional_key__descr_license_update_date' => 'التحديث التالي لمفتاح الترخيص',
    'additional_key__file_invalid' => 'ملف المفتاح الذي تم تحميله غير صالح أو لا يحتوي على مفتاح ترخيص.',
    'additional_key__file_incompatible' => 'ملف المفتاح الذي تم تحميله غير صالح لهذا التطبيق.',
    'additional_key__expired' => 'انتهت صلاحية هذا المفتاح الإضافي.',
    'additional_key__not_exists' => 'لا يوجد مفتاح ترخيص مُثبَت.',
    'additional_key__viruozzo_only_key' => 'مفتاح الترخيص هذا مخصص للاستخدام في Plesk المثبت في حاويات Virtuozzo.',
    'additional_key_update__result_response' => 'استجابة خادم الترخيص: 1%',
    'additional_key_update__result_network' => 'تعذر الاتصال بخادم الترخيص. يرجى التأكد من أن الشبكة تسمح بالاتصال بـ 1%: %2.',
    'additional_key_update__result_lock' => 'تحديث المفتاح قيد التقدم',
    'additional_key_update__result_internal_error' => 'حدث خطأ أثناء تحديث مفتاح الترخيص: 1%',

    'proceed_to_cl_pool' => "تابع لتكوين مجموعة IP للعميل",
    'proceed_to_hosting_setup' => "تابع لتثبيت الاستضافة",
    'removeCerts__remove_certificates_cp' => "ستتم إزالة الشهادات التالية:",
    'removeCerts__remove_certificates_domain' => "ستتم إزالة الشهادات التالية المملوكة لـ 1%:",
    'removeClientsIP_remove_clients_ip' => "ستتم إزالة عنوان IP من مجموعات العملاء التالين:",
    'removeMailAliases__remove_mail_aliases' => "ستتم إزالة الأسماء المستعارة للبريد لحساب البريد 1%:",
    'removeMailNames__remove_mailnames' => "ستتم إزالة حسابات البريد والأسماء المستعارة التالية من المجال 1%:",
    'removeMailNames__remove_mailnames_of_cl' => "ستتم إزالة حسابات البريد والأسماء المستعارة التالية من المجال 2% الذي يملكه العميل 1%:",
    'removeMailNames__these_mailnames_will_not_delete' => "لن يتم حذف حسابات البريد هذه.",
    'removeFtpSessions__remove_title' => "سيتم إنهاء جلسات FTP التالية:",
    'removeTemplates__remove_templates' => "ستتم إزالة القوالب التالية:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'المعدل',
    'report_auto__list_last' => 'تاريخ آخر تسليم',
    'report_auto__list_recipient' => 'التسليم إلى',
    'report_auto__list_select' => 'تقرير حول',
    'report_auto__title' => 'الجداول الزمنية للتسليم لـ 1%',
    'report_auto__recipient_email' => 'عنوان البريد الإلكتروني الذي أحدده',
    'report_auto__recipient_admin' => 'مسؤول الخادم',
    'report_auto__recipient_client' => 'العميل',
    'report_auto__recipient_domain' => 'مسؤول المجال',
    'report_auto_edit__select' => 'تقرير حول',
    'report_auto__select_client_report_all' => 'جميع العملاء',
    'report_auto__select_client_report_current' => 'هذا العميل',
    'report_auto__select_client_report_other_client' => '1%',
    'report_auto__select_domain_report_all' => 'جميع المجالات',
    'report_auto__select_domain_report_other_client' => 'جميع مجالات 1%',
    'report_auto__select_domain_report_client' => 'جميع مجالات هذا العميل',
    'report_auto__select_domain_report_reseller' => 'جميع مجالات بائع التجزئة هذا',
    'report_auto__select_domain_report_current' => 'هذا المجال',
    'report_auto__select_domain_report_other_domain' => '1%',
    'report_auto__legend' => 'الجدول الزمني للتسليم',
    'report_auto__select_for_remove' => "حدد الجداول الزمنية للتسليم التي ترغب في إزالتها.",
    'report_auto_remove__title' => "ستتم إزالة مواعيد تسليم التقارير التالية:",
    'report_auto_edit__title' => 'خصائص موعد التسليم',
    'report_auto_edit__recipient' => 'التسليم إلى',
    'report_auto_edit__target' => 'تقرير حول',
    'report_auto_edit__auto' => 'معدل التسليم',
    'resp_edit__always_respond' => "الاستجابة دائمًا",
    'resp_edit__reply_subject' => "عنوان الرد.",
    'resp_edit__answer_subject' => "الإجابة مع الموضوع",
    'resp_edit__answer_txt' => "الرد بنص",
    'resp_edit__attach' => "إرفاق ملفات",
    'resp_edit__default_subject' => "رد: 1%",
    'resp_edit__for' => "إلى",
    'resp_edit__frw_rqst_email' => "في حالة الرد التلقائي، أعد توجيه الرسالة الأصلية إلى البريد الإلكتروني المحدد",
    'resp_edit__fwd_email_invalid' => "البريد الإلكتروني الوجهة غير صالح.",
    'resp_edit__in_body' => "عند العثور على كلمات معينة في نص الرسالة",
    'resp_edit__in_subject' => "عند العثور على كلمات معينة في موضوع الرسالة",
    'resp_edit__invalid_resp_freq' => "معدل الرد غير صالح.",
    'resp_edit__invalid_rqst_txt' => "نص الطلب غير صالح.",
    'resp_edit__invalid_store_lim_num' => "قيمة الحد غير صالحة.",
    'resp_edit__limits_title' => "الحدود",
    'resp_edit__maximum_allowed_resp_freq_reached' => "يتجاوز أقصى عدد للاستجابات في اليوم المعدّل المحدد. مسموح به: 1%، المطلوب: %2",
    'resp_edit__no_files_sel' => "لم يتم تحديد أي ملفات.",
    'resp_edit__no_txt_supplied' => "لم يتم إدخال نص.",
    'resp_edit__reply_title' => "رد",
    'resp_edit__reply_to_address' => "عنوان الإعادة",
    'resp_edit__reply_to_invalid' => "عنوان الإعادة غير صالح.",
    'resp_edit__reply_uniq_email' => "الرد على عنوان البريد الإلكتروني المميز بما لا يزيد عن",
    'resp_edit__conditions_title' => "شروط",
    'resp_edit__request_title' => "طلب",
    'resp_edit__resp' => "الرد التلقائي",
    'resp_edit__resp_name' => "اسم الرد التلقائي",
    'resp_edit__resp_not_exist' => "الرد التلقائي غير موجود.",
    'resp_edit__resp_status' => "حالة الرد التلقائي",
    'resp_edit__rqst_txt' => 'حدد حالة للرد التلقائي هذا',
    'resp_edit__select_files_on_server_for_attach' => "حدد الملفات التي ترغب في إرفاقها",
    'resp_edit__store_up_to' => "تخزين ما يصل إلى",
    'resp_edit__subj_line_invalid' => "سطر العنوان غير صحيح.",
    'resp_edit__text_too_big' => "نص رسالة الرد أكبر مما يجب.",
    'resp_edit__times_in_a_day' => "من المرات يوميًا.",
    'resp_edit__unable_define_resp_cond' => "تعذر تحديد شرط الرد التلقائي: 1%",
    'resp_edit__unable_define_resp_status' => "تعذّر تحديد حالة الرد التلقائي: 1%",
    'resp_edit__unable_turn_on_resp' => "تعذر تشغيل الرد التلقائي: 1%",
    'resp_edit__uniq_email' => "عناوين البريد الإلكتروني المميزة",
    'resp_edit__content_type' => 'تنسيق إرسال البريد',
    'resp_edit__content_type_text' => 'نص عادي',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'ترميز',
    'restart__dns' => 'خادم DNS (%1)',
    'restart__drweb' => '‫برنامج Plesk Premium Antivirus‬',
    'restart__mail' => "خادم IMAP/POP3 (%1)",
    'restart__mssql' => "خادم Microsoft SQL",
    'restart__mysql' => "خادم MySQL",
    'restart__postgresql' => "‫PostgreSQL‬",
    'restart__psa' => "خدمات",
    'restart__smtp' => "خادم SMTP (%1)",
    'restart__spamd' => "عامل تصفية البريد العشوائي",
    'restart__spamassassin' => "‫SpamAssassin‬",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "خادم الويب (1%)",
    'restart__ftp' => "خادم FTP (%1)",
    'restart__service_start' => '‫يُرجى الانتظار لبعض الوقت لتشغيل الخدمة.‬',
    'restart__service_stop' => '‫يُرجى الانتظار لبعض الوقت لإيقاف الخدمة.‬',
    'restart__service_restart' => '‫يُرجى الانتظار لبعض الوقت لإعادة تشغيل الخدمة.‬',
    'rm_domains__some_domains_are_not_exist' => "بعض المجالات المحددة غير موجودة. ربما أزالها مستخدم آخر.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "المجموعات البريدية",
    'rpt_cl_dom_mail_lists' => "القوائم البريدية",
    'rpt_cl_dom_mail_resps' => "مسؤول المنطقة",
    'rpt_cl_dom_mail_antispam' => "مكافحة البريد العشوائي",
    'rpt_cl_dom_mail_antivirus' => "برنامج مكافحة الفيروسات",
    'rpt_cl_dom_postboxes' => "علب البريد",
    'rpt_cl_dom_redirects' => "أدوات التوجيه",
    'rpt_cl_dom_subdomains' => "المجال الفرعي",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "مستخدمو الويب",
    'rpt_cl_report_for_admin__' => "‫إعداد تقرير للمسؤول %1‬",
    'rpt_cl_report_for_reseller__' => "‫إعداد تقرير لبائع التجزئة %1‬",
    'rpt_cl_report_for_cl__' => "‫إعداد تقرير بخصوص العميل 1%‬",
    'rpt_cl_section_domains' => "المجالات",
    'rpt_cl_section_full_domains' => "المجالات",
    'rpt_cl_section_general' => "عام",
    'rpt_create' => "إنشاء تقرير",
    'rpt_empty' => "يجب أن يحتوي التقرير على مقطع واحد على الأقل",
    'rpt_default_report' => "استخدام كتقرير افتراضي",
    'rpt_dom_report_for_dom__' => "تقرير المجال لـ 1%",
    'rpt_dom_section_databases' => "قواعد البيانات",
    'rpt_dom_section_full_databases' => "قواعد البيانات",
    'rpt_dom_section_full_maillists' => "قوائم المراسلة",
    'rpt_dom_section_full_mailnames' => "حسابات البريد",
    'rpt_dom_section_full_webusers' => "مستخدمو الويب",
    'rpt_dom_section_full_siteapps' => 'تطبيقات الويب',
    'rpt_dom_section_full_aspnetapps' => 'تطبيقات ASP.NET للويب',
    'rpt_dom_section_general' => "عام",
    'rpt_dom_section_hosting' => "الاستضافة",
    'rpt_dom_section_maillists' => "قوائم المراسلة",
    'rpt_dom_section_mailnames' => "حسابات البريد",
    'rpt_dom_section_siteapps' => 'تطبيقات الويب',
    'rpt_dom_section_aspnetapps' => 'تطبيقات ASP.NET للويب',
    'rpt_dom_section_webusers' => "مستخدمو الويب",
    'rpt_dom_title_wa_status' => "‫S‬",
    'rpt_edit__' => "تحرير التقرير 1%",
    'rpt_enter_email_address' => "أدخل عنوان البريد الإلكتروني الذي سيتم توصيل التقرير إليه.",
    'rpt_list' => "تخطيطات تقرير مخصصة",
    'rpt_name' => "اسم التقرير",
    'rpt_remove_reports' => "ستتم إزالة تخطيطات التقرير التالية:",
    'rpt_reports' => "التقارير",
    'rpt_section_full' => "كامل",
    'rpt_section_none' => "بلا",
    'rpt_section_summary' => "ملخص",
    'rpt_select_reports_for_remove' => "حدد تخطيطات التقارير التي ترغب في إزالتها.",
    'rpt_default_full' => 'تقرير كامل',
    'rpt_default_summary' => 'تقرير التلخيص',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "خطأ في إرسال التقرير: 1%",
    'rpt_send_report_by_email_ok__' => "تم إرسال التقرير إلى 1%",
    'sa_action' => "الإجراء",
    'sa_action_del' => "حذف",
    'sa_action_desc' => "ما يجب فعله برسائل البريد العشوائية",
    'sa_action_save' => "تحديد كبريد عشوائي وتخزينه في علبة البريد",
    'sa_admin_blacklist' => "القائمة السوداء للمسؤول",
    'sa_admin_whitelist' => "القائمة البيضاء للمسؤول",
    'sa_db_del_confirm' => "هل ترغب بالتأكيد في مسح قاعدة بيانات عوامل تصفية البريد العشوائي؟",
    'sa_eml_in_ignorelist' => "البريد الإلكتروني موجود في قائمة التجاهل",
    'sa_empty_email' => "لا يمكن إضافة نمط بريد إلكتروني فارغ.",
    'sa_exists_email' => "نمط البريد الإلكتروني المحدد موجود بالفعل.",
    'sa_disabled__mailname_not_filtering' => "لا تسمح إعدادات المجال الحالية باستخدام عوامل تصفية البريد لحساب البريد هذا",
    'sa_disabled__filtering_is_disabled' => 'أوقف مسؤول المجال تشغيل عوامل تصفية البريد العشوائي',
    'sa_disabled__hasnt_mailbox' => "لا يمكن تشغيل عوامل تصفية البريد العشوائي دون وجود علبة بريد",
    'sa_enable_filter' => "تشغيل عوامل تصفية البريد العشوائي",
    'sa_forget' => "نسيان",
    'sa_from' => "من",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "النمط غير صالح.",
    'sa_spam' => "بريد عشوائي",
    'sa_trainer__page_title' => 'التدريب على عوامل تصفية البريد العشوائي',
    'sa_trainer__tools_legend' => 'أدوات',
    'sa_trainer__info_legend' => 'المعلومات',
    'sa_trainer__messages_list_legend' => 'رسائل في علبة البريد',
    'sa_trainer__c' => 'تيرا',
    'sa_trainer__l' => '‫L‬',
    'sa_trainer__subject' => 'الموضوع',
    'sa_trainer__from' => 'من',
    'sa_trainer__date' => 'التاريخ',
    'sa_trainer__info_text' => 'الرسائل المستفادة: 1% كبريد عشوائي، 2% كبريد إلكتروني غير عشوائي، 3% إجمالي.',
    'sa_trainer__messages' => 'رسالة (رسائل)',
    'sa_trainer__select__all' => 'الكل',
    'sa_trainer__select__spam_only' => 'بريد عشوائي',
    'sa_trainer__select__ham_only' => 'رسائل غير عشوائية',
    'sa_trainer__select__unknown_only' => 'غير معروف',
    'sa_trainer__cannot_remove_messages' => 'لا يمكن إزالة الرسائل المحددة من علبة البريد.',
    'sa_trainer__remove_messages_confirm' => 'هل ترغب بالتأكيد في إزالة الرسائل المحددة من علبة البريد؟',
    'sa_subj' => "الموضوع",
    'sa_training' => "التدريب على عوامل تصفية البريد العشوائي",
    'sa_training_legend' => "التدريب على عوامل التصفية Bayesian",
    'sa_use_srv_settings' => "استخدام الإعدادات على مستوى الخادم",
    'sa_user_blacklist' => "القائمة السوداء للمستخدم",
    'sa_user_whitelist' => "القائمة البيضاء للمستخدم",
    'sa_usr_disabled_by_srv' => "لا يسمح مسؤول الخادم بإعدادت عوامل تصفية رسائل البريد العشوائية الفردية",
    'sa_usr_no_postbox' => "يتعذر تمكين تصفية البريد العشوائي نظرًا لإيقاف تشغيل صندوق البريد لحساب البريد الإلكتروني هذا.",
    'sa_filters' => 'عوامل تصفية البريد العشوائي',
    'spamfilter__tools_legend' => 'أدوات',
    'spamfilter__prefs_legend' => 'الإعدادات',
    'spamfilter__max_children' => 'الحد الأقصى من عدد عمليات spamd المطلوب تشغيلها',
    'spamfilter__rewrite_header_subject_hint' => 'اترك هذا الحقل فارغًا إذا لم تكن ترغب في إضافة أي نص. اكتب _SCORE_ إذا أردت تضمين النتيجة في موضوع الرسالة.',
    'spamfilter__reject_spam' => 'حذف البريد العشوائي عند وصوله إلى علبة البريد',
    'spamfilter__enabled' => 'قيد التشغيل',
    'spamfilter_addresses_list__tools_legend' => 'أدوات',
    'spamfilter_addresses_list__list_legend' => 'العناوين',
    'spamfilter_addresses_list__items' => 'العناوين',
    'spamfilter_addresses_list__status' => '‫S‬',
    'spamfilter_addresses_list__level' => '‫L‬',
    'spamfilter_addresses_list__address' => 'عنوان',
    'spamfilter_addresses__file_legend' => 'من الملف',
    'spamfilter_addresses__file_label' => 'اسم الملف',
    'spamfilter_addresses__file_hint' => 'تحميل ملف بترميز UTF-8.',
    'spamfilter_addresses__text_legend' => 'من القائمة',
    'spamfilter_addresses__text_label' => 'عناوين البريد الإلكتروني',
    'spamfilter_addresses__remove_title' => 'ستتم إزالة العناوين التالية من القائمة:',
    'spamfilter_addresses__empty_selection' => 'لم يتم تحديد عناوين.',
    'server__admin_info' => "معلومات المسؤول",
    'server__ctrl_panel' => "‫Plesk‬",
    'server__enter_bug_essence_below' => "أدخل وصف الخطأ أدناه",
    'server__power_management' => "إدارة الطاقة",
    'server__services' => "خدمات",
    'server__system' => "النظام",
    'server__title' => "مسؤول الخادم",
    'server_preferences__admin_skin' => "سطح واجهة المسؤول",
    'server_preferences__default_language' => "اللغة الافتراضية",
    'server_preferences__default_skin' => "السطح الافتراضي",
    'server_preferences__restart_apache_interval' => "الفترة الفاصلة لإعادة تشغيل Apache",
    'server_preferences__system' => 'إعدادات النظام',
    'mail__tabs_preferences' => "الإعدادات",
    'mail__tabs_white_list' => "القائمة البيضاء",
    'server_preferences__use_vocabulary' => "تحقق من كلمات مرور علب البريد الموجودة في الدليل",
    'sessions__agreement' => "نعم، أرغب في إنهاء هذه الجلسات.",
    'sessions__select_sessions_for_remove' => "حدد الجلسات التي ترغب في إنهائها.",
    'sessions__tabs_cp_sessions' => 'جلسات Plesk',
    'sessions__tabs_ftp_sessions' => '‫جلسات FTP‬',
    'sessions__ftp_sessions_login' => 'اسم مستخدم حساب FTP',
    'sessions__ftp_sessions_domain' => 'اسم النطاق',
    'sessions__ftp_sessions_path' => '‫الموقع الحالي‬',
    'sessions__ftp_sessions_file' => 'اسم الملف',
    'sessions__ftp_sessions_action' => '‫الحالة‬',
    'sessions__ftp_sessions_speed' => '‫السرعة، كيلوبايت/ثانية‬',
    'sessions__ftp_sessions_comp' => '‫التقدم، %‬',

    'site_apps__access_level' => 'مستوى الوصول',
    'site_apps__access_level_commercial' => 'تجاري',
    'site_apps__access_level_free' => 'مجاني',
    'site_apps__action_installer' => "تثبيت تطبيقات الويب",
    'site_apps__action_reconfigure' => "إعادة تكوين تطبيقات الويب",
    'site_apps__custom_button_level' => 'هل ترغب في إنشاء زر مخصص للوصول إلى هذا التطبيق؟',
    'site_apps__custom_button_level_false_domain_user_only' => '‫لا‬',
    'site_apps__custom_button_level_domain_user_only' => '‫نعم‬',
    'site_apps__custom_button_level_false' => '‫لا‬',
    'site_apps__custom_button_level_domain' => 'نعم، واجعله متوفرًا للمجال الحالي فقط',
    'site_apps__custom_button_level_client' => 'نعم، واجعله متوفرًا لجميع مجالات العملاء',
    'site_apps__custom_button_level_admin' => 'نعم، واجعله متوفرًا لجميع المجالات',
    'site_apps__description' => "‫الوصف‬",
    'site_apps__dir_used_by_sapp__' => "الدليل \"\\1%\"\\ مستخدم بواسطة تطبيق ويب آخر",
    'site_apps__dir_used_by_unknown__' => "الدليل \"\\1%\"\\ موجود بالفعل. إذا تابعت فسيتم استبدال المحتويات.",
    'site_apps__dir_invalid_name__' => "اسم الدليل 1% غير صحيح",
    'site_apps__file_name' => 'اسم ملف تطبيقات الويب',
    'site_apps__invalid_install_prefix' => "بادئة تثبيت غير صالحة",
    'site_apps__invalid_package' => "تطبيق الويب غير صالح",
    'site_apps__key_status' => 'الترخيص',
    'site_apps__key_status_free' => 'تم التوزيع مجانـًا. لا يحتاج مفتاح ترخيص',
    'site_apps__key_status_ok' => 'مفتاح الترخيص المطلوب مثبّت',
    'site_apps__key_status_problem' => 'مفتاح الترخيص المطلوب غير مثبّت',
    'site_apps__name' => "الاسم",
    'site_apps__no_domains' => 'لا يمكن تثبيت تطبيق الويب. يوجد بالفعل تطبيق ويب آخر مثبّت في الدليل الجذر لهذا المجال. يمكنك إنشاء مجال فرعي لتطبيق الويب.',
    'site_apps__package_info_' => "معلومات تطبيقات الويب",
    'site_apps__package_integrated' => "لا يمكن إزالة التطبيق المدمج",
    'site_apps__pool_select_packages_to_add' => 'حدد تطبيقات الويب التي تريد إضافتها إلى المجموعة',
    'site_apps__release' => "إصدار",
    'site_apps__resource_used_by_sapp' => "يُستخدم هذا المورد بواسطة تطبيق ويب مُثبّت",
    'site_apps__root_used_by_sapp' => "يُستخدم هذا المورد بواسطة تطبيق ويب مُثبّت",
    'site_apps__these_domains_will_not_delete' => 'سيتم حذف المجالات (المجالات الفرعية) هذه',
    'site_apps__upload_site_app_pkg_title' => 'تحميل تطبيق ويب جديد',
    'site_apps__version' => "الإصدار",
    'site_apps__access_to' => "الوصول إلى 1%",
    'site_builder_requires' => '1% - %3',
    'skeleton__admin_label' => "قالب المضيف الظاهري",
    'skeleton__client_label' => "قالب المضيف الظاهري 1%",
    'skeleton__admin_page' => "إدارة قالب المضيف الظاهري",
    'skeleton__files_list' => "الملفات والأدلة",
    'skeleton__archiver_not_installed' => "يتعذّر فك حزمة الأرشيف. ربما لم يتم تثبيت برنامج الأرشيف على الخادم. اتصل بمسؤول {$PROD_NAME} لتثبيت برنامج الأرشيف.",
    'skeleton__client_page' => "إدارة قالب المضيف الظاهري",
    'skeleton__archive_corrupted' => "عند التحقق من الأرشيف تم اكتشاف أن ملف الأرشيف إما تالف أو أن هذا النوع من ملفات الأرشيف غير مدعوم.",
    'skeleton__archive_too_large' => "عند التحقق من الأرشيف تم اكتشاف أن ملف الأرشيف كبير جدًا.",
    'skeleton__not_supported_archive_type' => "هذا النوع من ملفات الأرشيف (file %1) غير مدعوم.",
    'skeleton__upload_archive_file' => "تحميل ملف أرشيف",
    'skin_download__title' => 'تنزيل سطح',
    'skin_download_now__title' => 'جارٍ تنزيل السطح',
    'skin_download_now__text' => 'جارٍ إنشاء حزمة الأسطح،<br> قد يستغرق هذا الإجراء بعض الوقت.<br> بمجرد ظهور نافذة مربع الحوار، يمكنك مواصلة العمل على Plesk.',
    'skin_file__help_for_using_types' => "يُرجى استخدام ملفات أرشيف أسطح بأحد التنسيقات التالية:",
    'skin_info__title' => 'خصائص السطح',
    'skin_mng_err__rpm_not_skin' => 'حزمة RPM هذه ليست حزمة أسطح Plesk',
    'skin_mng_err__psa_install_noreloc' => 'فشل تثبيت سطح يعتمد على RPM في المكان المحدد.',
    'skin_mng_err__already_exists' => 'دليل تثبيت السطح موجود بالفعل، وتوجد حزمة سطح تم نشرها.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'الملف الذي تم تحميله ليس حزمة سطح RPM صالحة.',
    'skin_mng_err__rpm_upgrade_noskin' => 'الملف الذي تم تحميله ليس حزمة سطح صالحة.',
    'skin_mng_err__rpm_upgrade_base' => "الملف الذي تم تحميله ليس حزمة سطح {$PROD_NAME} صالحة.",
    'skin_mng_err__rpm_upgrade_other' => 'تعذّر تثبيت السطح: تنسيق السطح غير صالح.',
    'skin_mng_err__no_a_skin' => "الملف الذي تم تحميله ليس حزمة سطح {$PROD_NAME} صالحة.",
    'skin_upload__title' => 'تحميل سطح جديد',
    'skin_upload__already_exists' => "الدليل'\\1%'\\ موجود بالفعل.",
    'skin_upload__unable_to_apply' => "الملف الذي تم تحميله لا يحتوي على سطح Plesk، أو تنسيق الأرشيف غير مدعوم.",
    'skin_upload__unable_to_rename__' => "تعذّرت إعادة تسمية السطح 2% إلى 1%: %3.",
    'skin_upload__file_name' => 'مسار ملف حزمة السطح',
    'skins_list__title' => 'مستودع الأسطح',
    'skins_remove__title' => 'إزالة الأسطح',
    'skins_remove__select_skins_for_remove' => 'حدد الأسطح التي ترغب في إزالتها',

    'spf__unable_update' => 'تعذر تحديث معلمات SPF',
    'sshterm__title' => 'طرف وعاء الأمان',
    'sshterm__password_authentication_warning' => 'ملاحظة: تم إيقاف تشغيل مصادقة كلمة المرور في تكوين خادم SSH المحلي. إذا لم تتمكن من الاتصال باستخدام طرف SSH، فاطلب من المسؤول تعيين الخيار "PasswordAuthentication yes" في ملف /etc/ssh/sshd_config.',
    'sshterm__password_authentication_warning_admin' => 'ملاحظة: تم إيقاف تشغيل مصادقة كلمة المرور في تكوين خادم SSH المحلي. إذا لم تتمكن من الاتصال باستخدام طرف SSH، يُرجى تعيين الخيار "PasswordAuthentication yes" في ملف /etc/ssh/sshd_config.',
    'statistics__active_domains' => "مجالات نشطة",
    'statistics__clients' => "العملاء",
    'statistics__subdomains' => "المجالات الفرعية",
    'statistics__cpu' => "وحدة المعالجة المركزية (CPU)",
    'statistics__databases' => "قواعد البيانات",
    'statistics__db_users' => "مستخدمو قاعدة البيانات",
    'statistics__dirs' => "أدلة محمية",
    'statistics__dom_active' => "‫نشط‬",
    'statistics__dom_passive' => "سلبي",
    'statistics__dom_problem' => "مشكلة",
    'statistics__domains' => "المجالات",
    'statistics__domains_with_host' => "مجالات مع الاستضافة",
    'statistics__doms' => "المجالات",
    'statistics__filesystem' => "نظام الملف",
    'statistics__general' => "عام",
    'statistics__hdd_available' => "متوفر",
    'statistics__hdd_capacity' => "السعة",
    'statistics__hdd_total' => "الإجمالي",
    'statistics__hdd_usage' => "استخدام القرص الصلب",
    'statistics__hdd_used' => "مُستخدَم",
    'statistics__ip' => "‫عنوان IP‬",
    'statistics__key_number' => "رقم المفتاح",
    'statistics__l1' => "منذ دقيقة واحدة",
    'statistics__l15' => "منذ 15 دقيقة",
    'statistics__l5' => "منذ 5 دقائق",
    'statistics__la' => "استخدام وحدة المعالجة المركزية",
    'statistics__mail_autoresponders' => "الردود التلقائية",
    'statistics__mail_boxes' => "علب البريد",
    'statistics__mail_groups' => "مجموعات البريد",
    'statistics__mail_lists' => "قوائم المراسلة",
    'statistics__mail_redirects' => "أدوات توجيه البريد",
    'statistics__mem' => "استخدام الذاكرة",
    'statistics__mem_usage' => "الاستخدام",
    'statistics__memory_available' => "متوفر",
    'statistics__memory_buffer' => "مَخْزَن مؤقت",
    'statistics__memory_cached' => "مُخَزّن مؤقتًا",
    'statistics__memory_free' => "مجاني",
    'statistics__memory_shared' => "مشترك",
    'statistics__memory_total' => "الإجمالي",
    'statistics__memory_used' => "مُستخدَم",
    'statistics__os' => "نظام التشغيل",
    'statistics__problem_clients' => "العملاء الذين يواجهون مشكلات",
    'statistics__problem_domains' => "المجالات التي تعرضت للمشكلة",
    'statistics__swap' => "تبديل الاستخدام",
    'statistics__swap_free' => "مجاني",
    'statistics__swap_total' => "الإجمالي",
    'statistics__swap_usage' => "الاستخدام",
    'statistics__swap_used' => "مُستخدَم",
    'statistics__system_stat' => "معلومات الخادم",
    'statistics__unable_define_active_doms' => "تعذّر تحديد عدد المجالات النشطة: 1%",
    'statistics__unable_define_inactive_doms' => "تعذّر تحديد عدد المجالات غير النشطة: 1%",
    'statistics__failed_define_swap_usage' => 'فشل تحديد استخدام المبادلة',
    'statistics__failed_define_load_averages' => 'فشل تحديد معدلات التحميل',
    'statistics__up_time' => "زمن تشغيل النظام:",
    'statistics__ver' => "الإصدار",
    'statistics__web_users' => "مستخدمو الويب",
    'statistics__mem_win' => "استخدام ذاكرة فعلية",
    'statistics__memory_total_win' => "الإجمالي",
    'statistics__memory_used_win' => "مُستخدَم",
    'statistics__memory_free_win' => "متوفر",
    'statistics__swap_win' => "استخدام ذاكرة ظاهرية",
    'statistics__swap_total_win' => "الإجمالي",
    'statistics__swap_used_win' => "مُستخدَم",
    'statistics__swap_free_win' => "متوفر",
    'status__domain_has_reasons_to_be_off' => "لا يزال المجال معلقًا للسبب التالي: 1%",
    'subdomain__create__' => "إنشاء مجال فرعي في المجال 1%",
    'subdomain__edit__' => "إدارة المجال الفرعي 1%",
    'subdomain__invalid_name' => "اسم المجال الفرعي غير صالح: لا تستخدم إلا رموزًا أبجدية رقمية وشرطة.",
    'subdomain__incorrect_name' => "اسم المجال الفرعي غير صالح.",
    'subdomains__maillists_enabled_in_domain' => "قوائم اسم المجال الفرعي غير صحيحة. 1%: اسم المجال هذا مستخدم بالفعل بواسطة القوائم البريدية ضمن المجال 1%.",
    'subdomains__dalias_exists' => 'هذا الاسم المستعار للمجال موجود بالفعل.',
    'subdomains__name_exists' => "اسم المجال الفرعي موجود بالفعل.",
    'subdomains__regular_domain_exists' => "يوجد بالفعل مجال بهذا الاسم.",
    'subdomains__domain_alias_exists' => 'هذا الاسم المستعار للمجال موجود بالفعل.',
    'subdomains__remove_subdomains_on_domain' => "ستتم إزالة المجالات الفرعية التالية للمجال 1%:",
    'subdomains__select_subdomains_for_remove' => "حدد المجالات الفرعية التي ترغب في إزالتها.",
    'subdomains__webmail_enabled_in_domain' => "بريد الويب لاسم المجال الفرعي غير صحيح. 1%: اسم المجال المحدد مستخدم بالفعل للوصول إلى بريد الويب ضمن المجال 1%.",
    'subdomains__dns_record_already_exists' => 'تعذّر إنشاء المجال الفرعي 1% لأنه يوجد بالفعل سجل DNS موجّه إلى المضيف 1%.',
    'subdomains__www_prefix_in_domain' => "اسم المجال الفرعي غير صحيح www.%1: المجال %1 يحتوي بالفعل على البادئة WWW.",
    'subdomains__user_type_quota_exceeds' => 'تعذّر تغيير حساب المستخدم لأن هذا سيؤدي إلى تجاوز مساحة القرص المحددة.',
    'subdomains__creation_in_dns_slave' => "يتصرف خادم اسم Plesk كخادم اسم ثانوي (تابع) لهذا المجال. لكي يعمل مجالك الفرعي بشكل سليم، تأكد من أن ملف المنطقة على الخادم الأساسي (الرئيسي) يحتوي على السجل 1%.",
    'sys_user__attributes_not_changed' => "لم يتم تغيير سمات مستخدم النظام التالية: 1%",
    'sys_user__no_access_without_password' => "لم تعيّن كلمة مرور. سيتم إنشاء مستخدم النظام، لكنه لن يتمكن من تسجيل الدخول إلى النظام حتى يحصل على كلمة المرور. هل ترغب في المتابعة؟",
    'sys_user__no_hard_quota' => "غير مدعوم",
    'sysuser__zero_quota_is_unlimited' => "0 يرمز لغير المحدود",
    'template__num_excl_ips' => "عيّن عناوين IP مخصصة للعميل",
    'template__sel_sh_ips' => "عناوين IP مشتركة محددة",
    'template__av_sh_ips' => "عناوين IP مشتركة متوفرة",
    'template__up_to_excl_ip' => "ما يصل إلى 1% من عناوين IP",
    'templates__all_clients' => "جميع العملاء",
    'templates__cl_domain_templates' => "لـقوالب 1%",
    'templates__cl_templates' => "قوالب العميل",
    'time__invalid_ip' => "عنوان IP أو اسم المجال غير صالح.",
    '__please_select_country' => 'يُرجى تحديد الدولة',
    'time__unable_set_time' => "تعذر تعيين وقت النظام: 1%",
    'time__sinchronization_setup_error' => 'Unable to set up time synchronization: timemng failed: %1',
    'time__sinchronization_disable_error' => 'تعذر تعطيل مزامنة الوقت: فشل ضبط الوقت: %1',
    'tmpl__create' => "إنشاء قالب",
    'tmpl__edit__' => 'القالب 1%',
    'tmpl__logrotation_warn' => "لن يتم إجراء تدوير السجل على المجال الذي تم إنشاؤه بواسطة هذا القالب إلا في حالة إنشاء حساب استضافة مادي لاحق له.",
    'tmpl__name' => "اسم القالب",
    'tmpl__dom_exist' => "يوجد بالفعل قالب مجال بهذا الاسم في مجموعة قوالب المسؤول أو العميل.",
    'tmpl__name_invalid' => "اسم القالب غير صالح أو أنه فارغ.",
    'tmpl__use_next_ip_addr' => "سيتم استخدام عنوان IP الفارغ التالي",
    'tmpl_name_already_exists' => "القالب بالاسم '\\1%'\\ موجود بالفعل.",
    'traffic__no_periods_found' => "تعذّر عرض إحصائيات الويب وعدد الزوار. لن تتوفر هذه الوظيفة إلا بعد حساب الإحصائيات التالي.",

    'vh_based__no_free_ip_for_vh' => "لا توجد عناوين IP فارغة للاستضافة الظاهرية اعتمادًا على عناوين IP. يُرجى إضافة عنوان IP.",

    'wu__at_domains_text' => "السماح بتنسيق وصول webuser @%1",
    'wu__unable_create' => "تعذّر إنشاء مستخدم الويب: 1%",
    'wu_edit__disk_quota' => "الحصة النسبية للقرص",
    'wu_edit__invalid_pass' => "كلمة المرور غير صالحة.",
    'wu_edit__invalid_quota' => "القيمة المحددة للحصة النسبية لمساحة القرص غير صالحة. يُرجى إدخال عدد صحيح موجب.",
    'wu_edit__invalid_quota_value' => "الحصة النسبية المحددة لمساحة القرص أقل من المستخدم حاليًا (1% ميغابايت). قد تصبح بعض الوظائف غير متوفرة. هل ترغب بالتأكيد في المتابعة؟",
    'wu_edit__not_create_pass' => "لن يؤدي هذا الإجراء إلى إنشاء كلمة مرور لمستخدم جديد للويب. لن يتمكن المستخدم من تسجيل الدخول دون كلمة المرور.",
    'wu_edit__unable_update' => "تعذّر تحديث خاصية مستخدم الويب: 1%",

    'bt_webdirs' => 'أدلة ظاهرية',

    'dns__tabs_general' => 'إعدادات المنطقة',
    'dns__tabs_zone_settings' => 'سجلات SOA',
    'soa__seconds' => 'ثوانٍ',
    'soa__minutes' => 'دقائق',
    'soa__hours' => 'ساعات',
    'soa__days' => 'أيام',

    'DomainSubdirectory' => 'الدليل الفرعي للوجهة',

    'filemanager__select_codepage' => 'تحديد صفحة الرموز:',

    'bt_server_app_add' => 'إضافة تطبيق خادم',
    'packages_list' => 'تطبيقات الخادم',

    'bt_packages_management' => 'إدارة الحزم',
    'pb__packages_management' => 'إدارة التطبيق',
    'bt_package_new' => 'إضافة تطبيق',
    '__packages' => 'تطبيقات الخادم',

    'dom_ctrl__mysql_dbase_space' => 'إجمالي حصة قاعدة بيانات MySQL',
    'dom_ctrl__mssql_dbase_space' => 'إجمالي حصة قاعدة بيانات MS SQL',

    'check_permissions__domains_selection' => 'سيتم التحقق من أذونات الوصول إلى المجلد والملف للمجالات التالية',

    'dns_add__enter_ixfr_path' => 'أدخل مسار IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'سجل SPF TXT موجود بالفعل. لا يمكن أن يوجد سوى سجل SPF واحد. لإضافة سجل، احذف السجل الموجود قبل ذلك.',

    'component_name__network' => 'الشبكات',
    'component_name__sitebuilder' => '‫Presence Builder‬',

    'bt_skin_set' => 'تعيين سطح',
    'bt_set_skin' => 'تعيين سطح',
    'firewall__rule_already_exists' => 'اسم القاعدة "1%" موجود بالفعل',
    'pb__firewall' => 'جدار الحماية',
    'ruleeditform__incorect_port_value' => 'يجب أن يقع رقم المنفذ بين 1 و65535.',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'موقع الملف غير صالح.',

    'error_doc__erorr_invalid_url_location' =>  'تنسيق عنوان URL غير صحيح. يُرجى إدخال عنوان URL مطلق ضمن المضيف الظاهري (الموقع).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'برنامج مكافحة الفيروسات',
    'antivirus__antivirus' => 'حماية مكافحة الفيروسات',
    'antivirus__antivirus_direction_off' => 'تم إيقاف التشغيل',
    'antivirus__antivirus_direction_any' => 'البريد الوارد والصادر',
    'antivirus__antivirus_direction_from' => 'البريد الصادر فقط',
    'antivirus__antivirus_direction_to' => 'البريد الوارد فقط',
    'antivirus__unable_to_update_settings' => 'تعذر تغيير إعدادات برنامج مكافحة الفيروسات: 1%',




    '__normal' => 'عادي',
    '__low' => 'منخفض',
    '__high' => 'عالٍ',

    'mail__antivirus' => "برنامج مكافحة الفيروسات على خادم البريد الداخلي",
    'mail__use_internal_antivirus' => 'استخدام مكافحة الفيروسات الداخلية',

    'sa__tabs_blacklist' => 'القائمة السوداء',

    '__mysql_databases' => 'قواعد بيانات MySQL',

    'check_permissions__read_only' => 'وضع التحقق فقط',
    'check_permissions__notification_email' => 'إرسال إعلام عبر البريد الإلكتروني',

    'cl_perm__mysql_dbase_space' => 'إجمالي حصة قاعدة بيانات MySQL',
    'cl_perm__mssql_dbase_space' => 'إجمالي حصة قاعدة بيانات MS SQL',
    'cl_perm__max_mssql_db' => 'العدد الأقصى لقواعد بيانات خادم Microsoft SQL',
    'cl_perm__total_mboxes_quota' => 'إجمالي حصة علب البريد',

    'check_permissions_warning' => 'قد يستغرق إنهاء هذا الإجراء وقتًا طويلاً، يرجى الانتظار وعدم إلغاء تحميل الصفحة.',

    'i_i_cl_on' => 'حساب العميل نشط.',
    'i_i_cl_off_by_admin' => 'تم تعليق حساب العميل من قِبل المسؤول.',

    'check_permissions__email_is_invalid' => 'البريد الإلكتروني المقدّم غير صالح.',

    'sa_exists_tn' => 'الشبكة موجودة بالفعل في القائمة.',

    'firewall__tabs_general' => 'عام',
    'firewall_tabs_icmp' => 'بروتوكول ICMP',

    'firewallicmpform__title' => 'قواعد جدار الحماية لبروتوكول ICMP',
    'firewallicmpform__icmpsettings_list_legend' => 'قواعد جدار الحماية لبروتوكول ICMP',
    'firewallicmpform__icmpsettingslist' => 'القواعد',
    'icmpsettingslist__enabled' => '‫S‬',
    'icmpsettingslist__type' => 'اسم القاعدة',
    'firewall__icmp_type_allowinboundrouterrequest' => 'السماح بطلب التوجيه الوارد',
    'firewall__icmp_type_allowinboundtimestamprequest' => 'السماح بطلب الطابع الزمني الوارد',
    'firewall__icmp_type_allowinboundmaskrequest' => 'السماح بطلب القناع الوارد',
    'firewall__icmp_type_allowoutboundsourcequench' => 'السماح بكبح مصدر الصادر',
    'firewall__icmp_type_allowoutboundparameterproblem' => 'السماح بمشكلة المعلمات الصادرة',
    'firewall__icmp_type_allowredirect' => 'السماح بإعادة التوجيه',
    'firewall__icmp_type_allowinboundechorequest' => 'السماح بطلب الارتداد الوارد',
    'firewall__icmp_type_allowoutboundtimeexceeded' => 'السماح بوقت الصادر الذي تم تجاوزه',
    'firewall__icmp_type_allowoutbounddestinationunreachable' => 'السماح بالوجهة الصادرة التي لا يمكن الوصول إليها',


    'webdir__select_vdirs_to_remove' => 'حدد الأدلة التي ترغب في حذفها',
    'webdir__select_mime_types_to_remove' => 'حدد نوع MIME الذي ترغب في حذفه',

    'defaultcomponents__not_activated' => 'غير مثبت',

    'bt_traffic_at_domains' => 'نسبة استخدام الشبكة',

    'firewall__icmpsettingslist' => 'القواعد',
    'icmpsettingslist__name' => 'اسم القاعدة',

    '__awstats_perl_warning' => 'دون تثبيت Perl، لن يسمح AWStats للمستخدمين بفحص الإحصائيات للأعوام السابقة.',

    'class_client__mysql_dbase_space' => 'تتجاوز القيمة حد العميل',
    'class_client__mssql_dbase_space' => 'تتجاوز القيمة حد العميل',
    'class_client__max_mssql_db' => 'تتجاوز القيمة حد العميل',

    'firewall__icmp_reset_configuration' => 'هل ترغب بالتأكيد في إعادة تعيين إعدادات جدار الحماية على الإعدادات الافتراضية؟',
    'firewall__icmp_panic_configuration' => 'هل ترغب بالتأكيد في تشغيل وضع الذعر؟ قد تتوقف بعض خدمات الشبكة عن العمل.',


    'dns__remove_transfer_restrictions_list_items' => 'ستتم إزالة الشبكات التالية من قائمة التحكم بالوصول:',

    'firewall__select_rule_to_remove' => 'حدد القواعد التي ترغب في إزالتها',

    'bt_up' => "أعلى",
    'bt_down' => "أسفل",
    'virtualdir__type_default_doc_name_to_add' => 'أدخل اسم ملف لإضافته إلى القائمة',
    'virtualdir__select_default_doc_to_remove' => 'حدد الملفات التي ترغب في إزالتها من القائمة',

    'bt_install_selected' => 'تثبيت مفاتيح الترخيص المحددة', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'يحال المجال إلى عنوان IP آخر: (1%). يُرجى تصحيح إعدادات DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'لا يدعم خادم البريد المستخدم حاليًا كلاً من علبة البريد والمجموعات البريدية التي تعمل معًا بشكل متزامن. انقر فوق موافق لتشغيل علبة البريد على حساب إيقاف تشغيل المجموعات البريدية. انقر فوق إلغاء لترك كل شيء دون تغيير.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'لا يدعم خادم البريد المستخدم حاليًا كلاً من علبة البريد والمجموعات البريدية التي تعمل معًا بشكل متزامن. انقر فوق موافق لتشغيل مجموعات البريد على حساب إيقاف تشغيل علبة البريد. انقر فوق إلغاء لترك كل شيء دون تغيير.',

    'mysql_dbase_space_limit' => 'حد مساحة قاعدة البيانات MySQL',
    'mysql_dbase_usage' => 'استخدام مساحة قاعدة البيانات MySQL',
    'mssql_dbase_space_limit' => 'حد مساحة قاعدة بيانات خادم Microsoft SQL',
    'mssql_dbase_usage' => 'استخدام مساحة قاعدة بيانات خادم Microsoft SQL',

    '__statistics' => "إحصائيات", //indirect

    'dns__soa_minimum_value_is_big' => 'يمكن أن يجعل تعيين الحد الأدنى لقيمة TTL التي هي أكبر من 3 ساعات مجالاتك لا يمكن الوصول إليها لبعض مسؤولي المجال. ينصح بعدم تعيين هذه القيمة إلا إذا كان مسجل أسماء المجال يصر على ذلك.',

    'virusfilter__interface_not_available' => 'لا تتوفر عوامل تصفية الفيروسات.',
    'virusfilter__none_virus_filter' => 'بلا',
    'virusfilter__mailname_status_text' => 'مكافحة الفيروسات (1%)',
    'virusfilter__status_none' => 'تم إيقاف التشغيل',
    'virusfilter__status_any' => 'البريد الوارد والصادر',
    'virusfilter__status_outgoing' => 'البريد الصادر فقط',
    'virusfilter__status_incoming' => 'البريد الوارد فقط',

    'visibility__adminonly' => 'المسؤول فقط',
    'visibility__button_sets' => '‫أدوات التحكم‬',
    'visibility__control' => 'انقر لتخصيص عنصر التحكم هذا.',
    'visibility__customization_footnote' => 'انقر فوق موافق للانتهاء من تخصيص هذه النافذة.',
    'visibility__default' => 'افتراضي',
    'visibility__export_note' => "سيتم تصدير إعدادات التخصيص التي أجريتها بعد قليل. سيتم تنزيل برنامج نصّي للوعاء إلى جهاز الكمبيوتر. لتطبيق هذه الإعدادات على خادم Plesk آخر، والكتابة فوق أي إعدادات موجودة لإدارة الواجهة، يُرجى تحميل النص البرمجي المحدد وتشغيله. يُرجى ملاحظة أنه إذا كنت قد أجريت أي تغييرات على هذه الشاشة ولم تنقر فوق \"موافق\" بعد، فإن البيانات التي تم تصديرها لن تشمل التغييرات الأخيرة التي أجريتها.",
    'visibility__hide' => 'إخفاء',
    'visibility__reset_all' => 'إعادة تعيين الكل إلى الافتراضي',
    'visibility__reset_screen' => 'استعادة التخطيط الأصلي لهذه الشاشة',
    'visibility__root_override_parse_error' => 'يوجد خطأ بنائي في ملف 1% في السطر 2%.',
    'visibility__screen_title' => 'إدارة واجهة المستخدم',
    'visibility__set_billing_enabled' => 'فصل تطبيق Customer and Business Manager',
    'visibility__set_cert_puchasing' => 'إخفاء أزرار شراء الشهادة',
    'visibility__set_domain_registration' => 'إخفاء أزرار الاشتراك بالمجال',
    'visibility__set_extras' => 'إخفاء أزرار الخدمات الإضافية',
    'visibility__set_mail_bounce' => 'إخفاء أدوات التحكم في رفض الرسائل من عناوين بريد غير موجودة',
    'visibility__show' => 'إظهار',
    'visibility__show_toolbar' => 'عرض شريط أدوات إدارة واجهة المستخدم',
    'visibility__standby_footnote' => 'انقر لتخصيص أدوات التحكم في هذه الشاشة.',
    'visibility__standby_footnote_nocontrols' => 'لا توجد أدوات تحكم يمكن تخصيصها في هذه الشاشة.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "لا يدعم المكوّن النشر التلقائي",

    'component_name__cphosting' => "استضافة Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'لا يدعم خادم البريد الحالي إعداد الحصة النسبية لعلب البريد.',
    '__unable_get_total_mboxes_quota' => 'لا يدعم خادم البريد الحالي إعداد الحصة النسبية لعلب البريد.',

    'install_prefix__parent_not_exists' => "الدليل الرئيسي غير موجود.",

    'bt_change_version' => 'تغيير الإصدار',
    'aspdotnet__changeversion_title' => 'تحديد إصدار ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "تحديد الكل",
    '__uncheck_all' => "مسح الكل",

    'dns__editing_domain_controller_zone' => "يمكن أن يؤدي تعديل سجلات منطقة DNS لأداة التحكم بالمجال إلى مشكلات في وظائف المجال.",

    'pb__interface_management' => "إدارة واجهة المستخدم",
    'interface_management__tabs_skins' => "الأسطح",
    'interface_management__tabs_interface_templates' => "قوالب الواجهة",
    'interface_management__tabs_locales' => "المواقع",
    'locales_list__title' => "مستودع حزم اللغة",
    'locales_list__legend' => "اللغات المتوفرة",
    'locales_list__active_title' => "‫S‬",
    'locales_list__locale_title' => "حزمة اللغة",
    'locales_list__lang_title' => "اللغة",
    'locales_list__country_title' => "البلد",
    'locales_list__used_title' => "مُستخدَم",

    'backup__suspend_warning_during_backup' => "لن يكون المجال متوفرًا أثناء عملية النسخ الاحتياطي",
    'backup__suspend_warning_during_restore' => "لن يكون المجال متوفرًا أثناء عملية الاسترداد",
    'backup__suspend_domain' => "تعليق المجال",

    'locales_list__mls_limit' => "يتيح ترخيص Plesk الحالي استخدام 2% من اللغات. في الوقت الحالي، لديك 1% من اللغات تم تعيينها كلغات متوفرة للمستخدمين، وهذا يتجاوز العدد المحدد في الترخيص. يُرجى تحديد 2% من اللغات التي ترغب في استخدامها، وتحديد الباقي كـلغات غير متوفرة للمستخدمين من خلال النقر على رموزها في العمود '\\S'\\.",

    'bt_change_owner' => 'تعيين مالك جديد',
    'chown__new_owner' => 'مالك جديد',
    'chown__selected_domains' => 'الاشتراكات المحددة',
    'chown__limits_legend' => 'الموارد',
    'chown__limit_name' => 'اسم المورد',
    'chown__limit_value' => 'الموارد المخصصة',
    'chown__limit_assigned_before' => 'قبل التحويل',
    'chown__limit_assigned_after' => 'بعد التحويل',
    'chown__error_limits' => "تتعذر متابعة تحويل الاشتراك: يتطلب هذا التحويل موارد أكثر من التي يمكن أن يوفرها موفر المالك الجديد.",
    'chown__error_no_domains' => 'تعذرت متابعة نقل الاشتراك: إما أنه لم يتم تحديد اشتراك أو أن الاشتراك المحدد ينتمي بالفعل إلى المستخدم المستهدف.',
    'chown__error_empty_ip_pool' => "تتعذر متابعة تحويل الاشتراك: تجمع IP الخاص بموفر المالك الجديد فارغ. يرجى التأكد من أن الموفر يحتوي على عنوان IP واحد على الأقل في التجمع.",
    'chown__please_select_new_domain_owner' => 'حدد المالك الجديد لهذا الاشتراك',
    'chown__old_ip_address' => 'عنوان IP الحالي',
    'chown__new_ip_address' => 'عنوان IP جديد',

    'chown__error_ssl_already_used' => "دعم SSL/TLS مستخدم بالفعل في عناوين IP للوجهات التالية: %1 لذلك، تعذر نقل النطاقات التالية ذات دعم SSL/TLS: %2. يُرجى حل المشكلة والمحاولة مرة أخرى",
    'chown__sitebuilder_not_installed' => 'Presence Builder غير مثبت',
    'chown__domain_exclude_sitebuilder_not_installed' => 'تعذر تحويل المجال 1% إلى مالك آخر لأن تطبيق Presence Builder غير مثبت.',

    'backup__backup_time' => 'وقت النسخ الاحتياطي',
    'backup__backup_time_hour' => 'ساعات',
    'backup__backup_time_minute' => 'دقائق',
    'backup__every' => 'كل',
    'backup__day_of_month' => 'اليوم من الشهر',

    'subdomain__select_hst_type' => 'حدد نوع الاستضافة للمجال الفرعي',
    'hst_sel__subdom_subfolder_hst' => 'المجال الفرعي على المجلد الفرعي',
    'subdomain__www_root_folder_not_exists' => 'الدليل الرئيسي للموقع 1% غير موجود',
    '__site_home_dir' => 'الدليل الرئيسي للموقع',
    'subdomain__aspnet_disabled_domain' => 'إيقاف التشغيل بواسطة المجال',

    'domains__remove_description' => 'سيتم حذف جميع بيانات النطاق، والمتضمنة إعدادات ومحتوى النطاق والنطاقات الفرعية ذات الصلة، وبيانات تطبيقات الويب، ومحتويات علب البريد، والبريد، وإعدادات تصفية الرسائل العشوائية ومكافحة الفيروسات، وملفات السجل، وبيانات مستودع النسخ الاحتياطي للنطاق، وشهادات SSL/TLS. إذا لم يكن لديك ملف نسخ احتياطي في الجهاز لديك، فستفقد جميع البيانات للأبد.',
    'subdomains__remove_description' => 'سيتم حذف جميع بيانات المجال الفرعي، بما في ذلك محتويات المجال الفرعي وإعداداته وبيانات تطبيقات الويب وملفات السجل. إذا لم يكن لديك ملف نسخ احتياطي على جهازك المحلي، فستفقد جميع البيانات بشكل نهائي.',

    'mail__tabs_spam_filtering' => 'تصفية البريد العشوائي',
    'mail__tabs_antivirus' => 'برنامج مكافحة الفيروسات',
    'antivirus__use_server_settings_scan' => 'استخدام الإعدادات الافتراضية على مستوى الخادم (البحث)',
    'antivirus__use_server_settings_no_scan' => 'استخدام الإعدادات الافتراضية على مستوى الخادم (لا تبحث)',
    'antivirus__check_for_viruses' => 'البحث عن فيروسات',
    'antivirus__dont_check_for_viruses' => 'لا تبحث عن فيروسات',
    'antivirus__incoming_mail' => 'البريد الوارد',
    'antivirus__outgoing_mail' => 'البريد الصادر',

    'domain_alias__CNAME_dns_record_exists' => 'سجل DNS CNAME بهذا الاسم موجود بالفعل',
    'domain_alias__A_dns_record_exists' => 'سجل DNS A بهذا الاسم موجود بالفعل',
    'domain_alias__bad_prefix' => 'بادئة الاسم المستعار للمجال خاطئة',
    'domain_alias__domain_doesnt_exist' => "المجال غير موجود",

    'dns__zone_ttl_message_info' => 'إذا لم يتم تحديد قيمة TTL، فسيتم استخدام قيمة TTL في قالب سجل SOA (%1) لسجل DNS هذا.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "سيتم إنشاء ملف باسم index.html لإعادة التوجيه إلى تطبيق الويب المحدد. في حالة وجود ملف باسم index.html بالفعل، سيتم نسخه احتياطيًا باسم index.html.old وسيتم استبداله بالملف الجديد. انقر فوق موافق للتأكيد",

    'bt_ftp_ctrl' => "حسابات FTP الإضافية",
    'ftp_users_no_permission' => "ليس لديك إذن لإدارة حسابات FTP الخاصة بهذا المجال.",
    'ftp_users_limit_reached' => "تم الوصول إلى أقصى حد لحسابات FTP الخاصة بهذا المجال.",
    'pb__ftp_ctrl' => "إدارة FTP",
    'class_client__max_subftp_users' => "حسابات FTP الإضافية",

    '__client_form_settings' => "إعدادات العميل",
    '__sbnet_client_keep_sbnet' => "الاحتفاظ بحساب مستخدم مقابل في Presence Builder",
    '__sbnet_cant_add_more_sites' => "وصل هذا العميل إلى الحد الأقصى المسموح به لعدد المواقع التي يمكنها استخدام Presence Builder.",
    '__sbnet_legend_text' => "تكامل Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "إنشاء حساب مستخدم مقابل في Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "أنت تحاول إزالة حساب المستخدم Presence Builder المرتبط بهذا العميل. سيؤدي ذلك إلى حذف كل مواقع ويب المستخدمة والإعدادات ذات الصلة الأخرى من نظام Presence Builder، وإزالة إمكانية تعديل مواقع الويب الموجودة عبر Presence Builder، حتى إذا شغّلت هذا الخيار مرة أخرى بعد ذلك. إذا أنشأت حساب مستخدم Presence Builder مرة أخرى، ستضطر إلى إنشاء جميع مواقع الويب الخاصة بك ونشرها من البداية. هل ترغب في إيقاف تشغيل إنشاء موقع الويب ونشره عبر Presence Builder؟",
    'sb__build_site_with_subdomains' => "إنشاء مجال فرعي لمدونة ومعرض صور",
    '__sbnet_client_dont_have_sbuser' => "لا يمكن إنشاء الموقع ونشره باستخدام Presence Builder: مستخدم Presence Builder غير موجود.",

    '__component_disabled' => "تم إيقاف تشغيل المكوّن",

    'subdomains__physical_path_not_exist' => "توجد مجالات فرعية مرتبطة بمجلدات فعلية غير موجودة",

    'dnsserver_bind_to_msdns_switching_warning' => "تحذير: لن يتم نقل سوى أول 254 عنوان IP بشبكات فرعية بها /8 و/16 قناعًا في قائمة التحكم بالوصول. سيتم نقلها كعناوين IP منفصلة. هل ترغب في المتابعة؟",

    '__sbnet_net_framework_required_for_site' => "قد يتطلب Presence Builder دعم ASP.NET 2.0 على مجالك. نوصي بتمكين دعم ASP.NET 2.0 إذا كنت تستخدم Presence Builder.",

    'subdomain_auto_create_dir' => "إنشاء دليل فعلي للمجال الفرعي",

    'sa_trainer__unable_to_get_messages_list' => "تعذّر الحصول على قائمة الرسائل في علبة البريد: 1%",
    'sa_trainer__pass_doesnt_exist' => "كلمة مرور حساب البريد هذا مفقودة",

    '__sitebuilder_error' => "حدث خطأ أثناء محاولة الاتصال بـ Presence Builder. اتصل بموفر الخدمة لديك للحصول على المساعدة.",
    'wsb_error_user_not_exist' => "حساب مستخدم Presence Builder غير موجود.",
    'wsb_error_site_already_exist' => "هذا الموقع موجود بالفعل في Presence Builder.",
    'wsb_error_site_limit_reached' => "تم الوصول إلى الحد الأقصى المسموح به لعدد مواقع Presence Builder.",
    'wsb_error_internal_error' => "حدث خطأ داخلي في Presence Builder: اتصل بموفر الخدمة لديك للحصول على المساعدة.",
    'wsb_error_user_already_exist' => "اسم مستخدم Presence Builder المحدد موجود بالفعل في Presence Builder.",
    'sb_error_user_not_exist' => "مستخدم Presence Builder غير موجود.",
    'wsb_error_object_not_found' => "لم يتمكن Presence Builder من العثور على إدخال المضيف الصحيح.",

    'mg_no_mail_groups' => "لا توجد مجموعات بريدية",

    'drweb__drweb_incoming' => 'فحص مكافحة الفيروسات للبريد الوارد',
    'drweb__drweb_outgoing' => 'فحص مكافحة الفيروسات للبريد الصادر',
    'drweb__disable_reason_serv' => 'لا يدعم خادم البريد إعدادات عوامل تصفية مكافحة الفيروسات على مستوى علبة البريد',

    'vz_sitebuilder3_client_cant_be_created' => "تعذّر إنشاء حساب عميل: يوجد SiteBuilder الإصدار 3.1 أو أحدث مثبتًا",

    'chown__client_without_sitebuilder_support' => "تتعذر متابعة تحويل الاشتراك: خدمة Presence Builder غير مضمّنة في خطة الخدمة الجديدة للمالك أو مزوديه.",

    // new limits

    'class_client__max_odbc' => "اتصالات ODBC",
    'cl_perm__max_odbc' => "العدد الأقصى لاتصالات ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => '‫S‬',
    'domain_alias__list_name' => 'اسم الاسم المستعار للمجال',
    'domain_alias__list_ascii_name' => 'بتنسيق ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'إدارة واجهة المستخدم',
    'pb__interface_templates' => 'إدارة واجهة المستخدم',
    'pb__interface_clients' => 'العملاء الذين يستخدمون 1%',

    // service management
    'bt_service_showall' => "إظهار الكل",
    'bt_service_hideall' => "إخفاء الكل",
    'bt_service_start' => "بدء",
    'bt_service_stop' => "إيقاف",
    'bt_service_restart' => "إعادة تشغيل",
    'bt_service_disable' => "إيقاف التشغيل",
    'bt_service_manual' => "‫يدوي‬",
    'bt_service_auto' => "تلقائي",
    'comp_info__statup_type' => '‫نوع البدء‬',
    'service_startup_auto' => '‫تلقائي‬',
    'service_startup_manual' => '‫يدوي‬',
    'service_startup_disabled' => 'تم إيقاف التشغيل',
    'service_action_ok' => "تمت العملية مع الخدمة 1% بنجاح",
    'service_action_failed_disabled_service' => "تعذّر استكمال العملية مع الخدمة 1% لأنه تم إيقاف تشغيلها",
    'service_action_failed_error' => "تعذّر استكمال العملية: 1%",
    'service_group_action_ok' => "تمت العملية بنجاح مع الخدمات التالية: 1%",
    'service_group_action_disabled' => "تعذّر استكمال العملية مع الخدمات التالية لأنه تم إيقاف تشغيلها: 1%",
    'service_group_action_failed' => "تعذّر استكمال العملية مع الخدمات التالية: 1%. للحصول على معلومات تفصيلية عن الخطأ، نفذ العملية مع كل خدمة على حدة",

    // php 4vs5
    'bt_php' => "إعدادات PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => '‫بائعو التجزئة المتاحون‬',
    'massmail__resellers_list_selected' => 'بائعو التجزئة المحددون',
    'massmail__clients_list_available_for_select' => '‫العملاء المتاحون‬',
    'massmail__clients_list_selected' => 'العملاء المحددون',
    'massmail__advanced' => 'خيارات متقدمة',
    'bt_massmail_send' => '‫إرسال‬',
    'massmail__save_template_name' => 'حفظ النص لقالب جديد باسم',
    'massmail__template' => 'قالب',
    'massmail__compose_mail' => 'رسالة',
    'massmail__from' => 'من',
    'massmail__to' => 'إلى',
    'massmail__subject' => 'الموضوع',
    'massmail__body' => 'نص الرسالة',
    'massmail__body_hint' => 'استخدم المتغير <name> لإدخال اسم المستخدم تلقائيًا في رسالتك.',
    'massmail__send_to_clients' => "العملاء",
    'massmail__send_to_domainusers' => "مسؤولو المجال",
    'massmail__send_to_admins' => "مسؤولو Plesk",
    'massmail_select' => 'حدد عناوين',
    'massmail_showhide_selected' => "إظهار/إخفاء المحدد",
    'massmail_send_all' => "الكل",
    'massmail_send_selected' => "المحدد فقط",
    'massmail_send_except' => "الكل باستثناء المُحدد",
    'bt_new_mass_mail_template' => "إضافة قالب بريد إلكتروني جماعي",
    '__mass_mail_templates_list' => "قائمة قوالب رسائل البريد الإلكتروني الجماعية",
    'massmail__template_name' => 'اسم القالب',
    'massmail__receivers' => 'المستلمون',
    'massmail__created' => 'مرسِل',
    'massmail__date_created' => 'تاريخ الإنشاء',
    'massmail__compose' => '‫إرسال‬',
    'mass_mail__resellers_all' => 'جميع بائعي التجزئة',
    'mass_mail__clients_all' => 'جميع العملاء',
    'mass_mail__domainusers_all' => 'جميع مسؤولي المجال',
    'mass_mail__resellers_selected' => 'بائعو التجزئة المحددون',
    'mass_mail__clients_selected' => 'العملاء المحددون',
    'mass_mail__domainusers_selected' => 'مسؤولو المجال المحددون',
    'mass_mail__resellers_except' => 'جميع بائعي التجزئة باستثناء المحددين',
    'mass_mail__clients_except' => 'جميع العملاء باستثناء المحددين',
    'mass_mail__domainusers_except' => 'جميع مسؤولي المجال باستثناء المحددين',
    'mass_mail__admins_all' => 'جميع المسؤولين',
    'massmailtemplateslist__title' => 'قوالب رسائل البريد الإلكتروني الجماعية',
    'massmail__insert_from_template' => "إدراج بيانات من القالب",
    'massmail__select_template' => "تحديد قالب",
    'massmail__body_short_hint' => "(النص العادي فقط)",
    'massmail__from_short_hint' => "(البريد الإلكتروني أو الاسم)",
    'bt_insert' => "إدراج",
    'massmail__mail_send_successfully' => "تم إرسال الرسالة بنجاح",
    'massmail__mail_send_successfully_with_some_errors' => "تم إرسال الرسالة، لكن حدثت بعض المشكلات. ربما لم يتلق بعض المستلمين الرسالة. لمزيد من المعلومات اطلع على ملف السجل التالي: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "لم يتم إرسال الرسالة. يُرجى التأكد من أنه تم تحديد مستلم واحد على الأقل وأن خادم بريد Plesk يعمل بشكل صحيح. لمزيد من المعلومات اطلع على ملف السجل التالي: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "تم إدراج البيانات من القالب 1% بنجاح.",
    'massmail__template_added_successfully' => "تم حفظ قالب الرسالة باسم 1%.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "حدث خطأ في قاعدة البيانات Presence Builder. اتصل بموفر الخدمة لديك للحصول على المساعدة.",
    'wsb_error_sitebuilder_access_denied_error' => "تعذر الوصول إلى الملف. لا يمتلك Presence Builder تصريح وصول إلى الملف أو المجلد المطلوب. اتصل بموفر الخدمة لديك للحصول على المساعدة.",
    'wsb_error_sitebuilder_connection_failed' => "تعذّر الاتصال بـ Presence Builder بسبب فقدان الاتصال. اتصل بموفر الخدمة لديك للحصول على المساعدة.",
    'wsb_error_critical_during_operation' => "حدث خطأ كبير في Presence Builder: 1%",
    'wsb_error_license_during_operation' => "حدث خطأ في ترخيص Presence Builder: 1%",
    'wsb_error_during_operation' => "حدث خطأ في Presence Builder: 1%",
    'wsb_error_license_error' => "تم الوصول إلى حدود ترخيص Presence Builder:",

    // Other
    '__confrim_service_stop' => "تحذير! إذا أوقفت تشغيل الخدمة 1%، فقد يتوقف Plesk عن العمل. هل ترغب بالتأكيد في إيقاف الخدمة 1?%",
    'virtualdir__name_is_reserved' => "هذا الاسم محجوز",
    'index_redirect_help_text' => 'ستتم إعادة توجيهك تلقائيًا إلى موقع الويب المطلوب. If your browser does not support redirection, please click %1 here %2',
    'bt_default_settings' => "استرداد الإعدادات الافتراضية",
    'logfiles__remove_failed' => "يتعذّر حذف الملف 1%: الملف مؤمن من قبل تطبيق آخر. يُرجى إعادة المحاولة لاحقًا",
    'subdomain__invalid_homedirectory' => "الدليل الرئيسي للمجال الفرعي المحدد غير صالح",
    'scheduler_item__empty_filename' => "يرجى تحديد ملف تنفيذي لتشغيله",
    'subdomains__overlapped_domain_exists' => 'المجال الفرعي متراكب بواسطة منطقة DNS للمجال 1%',
    'subdomains__overlapped_domain_alias_exists' => 'المجال الفرعي متراكب بواسطة منطقة DNS للاسم المستعار للمجال 1%',
    'services_action_none_selected' => 'تعذّر استكمال العملية: يُرجى تحديد الخدمات المطلوبة',
    'cl_perm__max_subftp_users' => "العدد الأقصى لحسابات FTP الإضافية",
    'login_up__access_denied_no_cp_access' => 'تم رفض الوصول. ليس لديك الإذن بالوصول إلى Plesk.',
    'drweb__disable_reason_admin' => "لا تسمح سياسة الخادم بإعدادات تصفية مكافحة الفيروسات على مستوى علبة البريد.",

    'webdirs__name_is_invalid' => 'لا تستخدم سوى رمز أبجدي رقمي وشرط سفلية وشرطة في اسم الدليل.',
    'webdirs__physical_path_is_invalid' => 'المسار الفعلي غير صالح أو غير موجود',
    '__use_default' => 'استخدام الافتراضي',
    'odbc__dsn_list_legend' => 'اتصالات ODBC DSN',

    'webalizer_preferences__title' => 'إعدادات إحصائيات الويب',
    'webalizer_preferences__tab_hidden_referrers' => 'مراجع مخفية',
    'webalizer_preferences__tab_group_referrers' => 'مراجع مجمعة',

    'webalizer_hidden_referrer__edit_title' => 'خصائص المدخل المخفي',
    'webalizer_hidden_referrer__edit_legend' => 'مدخلات مخفية',
    'webalizer_hidden_referrer__referrer_type' => 'نوع المدخل',
    'webalizer_hidden_referrer__referrer' => 'مرجع',
    'webalizer_hidden_referrer__list_header' => 'مراجع مخفية',
    'webalizer_hidden_referrer__list_legend' => 'مراجع مخفية',
    'webalizer_hidden_referrer__referrer_direct_request' => 'طلب مباشر',
    'webalizer_hidden_referrer__referrer_custom_referrer' => 'مرجع',
    'webalizer_hidden_referrer__remove_empty_selection' => 'لم يتم تحديد مدخلات',
    'webalizer_hidden_referrer__remove_title' => 'لن تظل المراجع التالية مخفية بعد الآن:',
    'webalizer_hidden_referrer__already_exist' => 'هذا المدخل موجود بالفعل.',

    'webalizer_group_referrer__list_header' => 'مراجع مجمعة',
    'webalizer_group_referrer__list_legend' => 'مراجع مجمعة',
    'webalizer_group_referrer__edit_title' => 'خصائص مجموعة المرجع',
    'webalizer_group_referrer__edit_legend' => 'خصائص مجموعة المرجع',
    'webalizer_group_referrer__group' => 'مجموعة',
    'webalizer_group_referrer__referrer' => 'مرجع',
    'webalizer_group_referrer__already_exist' => 'يوجد مرجع مجموعة بالاسم نفسه بالفعل.',
    'webalizer_group_referrer__remove_empty_selection' => 'لم يتم تحديد مراجع',
    'webalizer_group_referrer__remove_title' => 'سيتم فصل مواقع المراجع التالية:',

    'pb__dashboard' => 'الصفحة الرئيسية',

    'server_interface__page_title' => 'إعدادات واجهة الخادم',
    'server_interface__tabs_locales' => 'المواقع',
    'server_interface__tabs_skins' => 'الأسطح',
    'server_interface__tabs_interface_templates' => 'قوالب الواجهة',
    'bt_server_interface' => 'تفضيلات الواجهة',
    'pb__server_interface' => 'تفضيلات الواجهة',

    'bt_wizard_next' => 'التالي>>',
    'bt_wizard_prev' => '<< رجوع',

    '__limit_exceeded_max_dom_server' => 'لا يمكنك استضافة المزيد من المجالات على هذا الخادم حيث إنك وصلت إلى الحد الأقصى لعدد المجالات المسموح بها لمفتاح ترخيصك. اتصل على موفر الخدمة لحل هذه المشكلة.',
    '__limit_exceeded_max_subdom_server' => 'لا يمكنك استضافة المزيد من المجالات الفرعية على هذا الخادم. يُرجى الاتصال على موفر الخدمة الخاص بك.',
    '__limit_exceeded_max_dom_aliases_server' => 'لا يمكنك إعداد المزيد من الأسماء المستعارة للمجال على هذا الخادم. يُرجى الاتصال على موفر الخدمة الخاص بك.',
    '__limit_exceeded_max_wu_server' => 'لا يمكنك إنشاء المزيد من مستخدمي الويب حيث إنك وصلت إلى الحد الأقصى لعدد مستخدمي الويب الذي يسمح به ترخيصك على الخادم. اتصل على موفر الخدمة لحل هذه المشكلة.',
    '__limit_exceeded_max_mn_server' => 'لا يمكنك إنشاء المزيد من حسابات البريد الإلكتروني حيث إنك وصلت إلى أقصى عدد لحسابات البريد على الخادم المسموح بها لمفتاح ترخيصك. اتصل على موفر الخدمة لحل هذه المشكلة.',

    '__limit_exceeded_max_cl_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد حسابات العملاء المُحدد من خلال مفتاح الترخيص (2%)',
    '__limit_exceeded_max_dom_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد المجالات المحدد من خلال مفتاح الترخيص (2%)',
    '__limit_exceeded_max_subdom_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد المجالات الفرعية المحدد من خلال مفتاح الترخيص (2%)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد الأسماء المستعارة للمجال المحدد من خلال مفتاح الترخيص (2%)',
    '__limit_exceeded_disk_space_useradmin' => 'لم يتبق لديك مساحة فارغة على القرص',
    '__limit_exceeded_max_wu_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد حسابات مستخدم الويب المُحدد من خلال مفتاح الترخيص (2%)',
    '__limit_exceeded_max_db_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد قواعد البيانات المحدد من خلال مفتاح الترخيص (%2)',
    '__limit_exceeded_max_box_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد علب البريد المحددة من خلال مفتاح الترخيص (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد حسابات البريد الإلكتروني المُحدد من خلال مفتاح الترخيص (2%)',
    '__limit_exceeded_max_maillists_useradmin' => 'لقد وصلت إلى الحد المسموح به لعدد قوائم المراسلة المُحدد من خلال مفتاح الترخيص (2%)',

    '__limit_exceeded_max_dom_userclient' => 'لقد وصلت إلى الحد الأقصى لعدد المجالات (2%)',
    '__limit_exceeded_max_subdom_userclient' => 'لقد وصلت إلى الحد المسموح به لعدد المجالات الفرعية (2%) المسموح بها من قبل موفر الخدمة',
    '__limit_exceeded_max_dom_aliases_userclient' => 'لقد وصلت إلى الحد الأقصى لعدد الأسماء المستعارة للمجال (2%)',
    '__limit_exceeded_disk_space_userclient' => 'لقد وصلت إلى الحد المسموح به لاستخدام القرص (2%)',
    '__limit_exceeded_max_traffic_userclient' => 'لقد وصلت إلى الحد الأقصى لاستخدام النطاق الترددي شهريًا (2%)',
    '__limit_exceeded_max_wu_userclient' => 'لقد وصلت إلى الحد المسموح به لعدد مستخدمي الويب (2%) المسموح به من قبل موفر الخدمة',
    '__limit_exceeded_max_db_userclient' => 'لقد وصلت إلى الحد الأقصى لعلب قواعد البيانات (2%)',
    '__limit_exceeded_max_box_userclient' => 'لقد وصلت إلى الحد الأقصى لعلب البريد (2%)',
    '__limit_exceeded_max_maillists_userclient' => 'لقد وصلت إلى الحد الأقصى لعدد قوائم المراسلة (2%)',
    '__limit_exceeded_expiration_userclient' => 'انتهت صلاحية حسابك على 2%',

    '__limit_exceeded_max_subdom_userdomain' => 'لقد وصلت إلى الحد المسموح به لعدد المجالات الفرعية (2%) المسموح بها من قبل موفر الخدمة',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'لقد وصلت إلى الحد الأقصى لعدد الأسماء المستعارة للمجال (2%)',
    '__limit_exceeded_disk_space_userdomain' => 'لقد وصلت إلى الحد المسموح به لاستخدام القرص (2%)',
    '__limit_exceeded_max_traffic_userdomain' => 'لقد وصلت إلى الحد الأقصى لمقدار النطاق الترددي المستخدم شهريًا (2%)',
    '__limit_exceeded_max_wu_userdomain' => 'لقد وصلت إلى الحد الأقصى لعدد حسابات مستخدمي الويب (2%)',
    '__limit_exceeded_max_db_userdomain' => 'لقد وصلت إلى الحد الأقصى لعلب قواعد البيانات (2%)',
    '__limit_exceeded_max_box_userdomain' => 'لقد وصلت إلى الحد الأقصى لعلب البريد (2%)',
    '__limit_exceeded_max_maillists_userdomain' => 'لقد وصلت إلى الحد الأقصى لعدد قوائم المراسلة (2%)',
    '__limit_exceeded_expiration_userdomain' => 'انتهت صلاحية حسابك على 2%',

    'mmt__to_none' => 'بلا',
    'mmt__to_admin' => 'المسؤول',
    'mmt__to_resellers_all' => 'جميع بائعي التجزئة',
    'mmt__to_resellers_select' => 'بائعو التجزئة المحددون',
    'mmt__to_resellers_select__available' => '‫بائعو التجزئة المتاحون‬',
    'mmt__to_resellers_except' => 'جميع بائعي التجزئة باستثناء المحددين',
    'mmt__to_clients_all' => 'جميع العملاء',
    'mmt__to_clients_select' => 'العملاء المحددون',
    'mmt__to_clients_select__available' => '‫العملاء المتاحون‬',
    'mmt__to_clients_except' => 'جميع العملاء باستثناء المحددين',

    'mmt__unable_send_empty_selection' => 'تعذر إرسال بريد جماعي، لم يتم تحديد عناوين بريد إلكتروني.',
    'mmt__unable_send_to__' => 'تعذر إرسال بريد جماعي إلى:',
    'mmt__unable_send_to_email' => '1% <2%>',

    'sapp_error_validation_not_found' => 'تعذّر التحقق من تطبيق الويب لعدم العثور على أحد الملفات المطلوبة (1%). اتصل بممثل الدعم الفني في منطقتك للحصول على المساعدة.',
    'sapp_error_validation_spec_failed' => 'تطبيق الويب الذي تم تحميله لا يطابق مواصفات AppPacks: 1%.',
    'sapp_error_validation_register' => 'تعذر تسجيل تطبيق الويب الموجود في الدليل "1%": 2% يجب عليك إزالة تطبيق الويب من الخادم لأنه لن يعمل بشكل صحيح.',

    'sapp__install_failed' => 'فشل تثبيت تطبيق الويب: 1%',
    'sapp__install_res_failed' => 'تعذّر إنشاء المورد المطلوب.',

    'server_preferences__subdomains_blog_and_photo' => 'إنشاء مجال فرعي لمدونة ومعرض صور افتراضيًا',
    'firewall__info' => 'نظرًا لأسباب أمنية، يحظر جدار الحماية جميع الاتصالات باستثناء تلك التي سُمح بها صراحةً. يمكن السماح لأحد الاتصالات بإنشاء قاعدة. راجع المستندات للحصول على مزيد من المعلومات',
    'plesk_key__blog_and_photo' => 'مربع اختيار إمكانية إدارة الحالة الافتراضية للمجالات الفرعية Create Blog وPhoto Gallery.',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'يتعذّر تغيير نوع عنوان IP إلى "مخصص" لأنه معيّن لأكثر من مستخدم واحد.',

    // 8.1.1

    '__write_modify_warning' => 'سيؤدي تحديد أذونات إضافية للكتابة/ التعديل إلى جعل بعض تطبيقات الويب تعمل بشكل صحيح، لكنه أيضًا يزيد المخاطر الأمنية بشكل ملحوظ',
    '__write_modify_subdomain_warning' => 'سيؤدي تحديد أذونات إضافية للكتابة/ التعديل إلى جعل بعض تطبيقات الويب تعمل بشكل صحيح، لكنه أيضًا يزيد المخاطر الأمنية بشكل ملحوظ',

    'phosting__php_incorrect_version_used' => "تم اكتشاف مشكلات بإصدار PHP. لحل هذه المشكلات، حدد مربع الاختيار لإصدار PHP المطلوب أدناه وانقر فوق \"موافق\". لإيقاف تشغيل PHP على هذا المجال، انقر فوق \"موافق\" دون تحديد إصدار PHP.",
    'fp__mail_preferences' => 'إعدادات البريد',

    'mail__invalid_white_pattern' => 'القيمة المحددة غير صالحة. استخدم التنسيقين التاليين: mail@example.com لعناوين البريد الإلكتروني وexample.com للنطاقات.',
    'mail__invalid_black_pattern' => 'القيمة المحددة غير صالحة. استخدم التنسيق التالي: mail@example.com لعناوين البريد الإلكتروني وexample.com للمجالات.',

    'resp_edit__reply_as_html' => 'إرسال كـ HTML',
    'exception__path_very_long' => "المسار طويل جدًا. يُرجى التأكد من وجود أكثر من 1% من الرموز في المسار.",

    // 8.2


    //SAPP
    'sapp_on' => 'تشغيل',
    'sapp_off' => 'إيقاف تشغيل',
    'sapp_directive_aspect' => 'مطلوب',
    'sapp_databases_num' => 'قواعد البيانات',
    'sapp_db_required' => 'مطلوب',
    'sapp_Required' => 'مطلوب',
    'sapp_Variant' => 'متغيّر',
    'sapp_db_id' => 'معرف قاعدة البيانات',
    'sapp_db_id_type' => 'قاعدة البيانات (المعرف: 1%) النوع',
    'sapp_db_id_min_version' => 'قاعدة البيانات (المعرف: 1%) أقل إصدار',
    'sapp_db_id_table_prefix' => 'قاعدة البيانات (المعرف: 1%) بادئة الجدول',
    'sapp_Default' => 'القيمة الافتراضية',
    'sapp_apache_mod_req' => 'وحدة Apache',
    'sapp_dbtype_not_installed' => '‫غير مثبت‬',
    'sapp_apache_mod_not_installed' => '‫غير مثبت‬',
    'sapp__value_error_empty' => 'القيمة الفارغة غير مسموح بها.',
    'sapp_error_invalid_type' => 'لا يدعم التطبيق "1%" الإجراء المطلوب.',
    'sapp_error_unknown_app_type' => 'نوع تطبيق غير مدعوم: 1%.',
    'sapp__ssl_text' => 'هل ترغب في تثبيت التطبيق على المضيف الظاهري "http://" أم "https://"؟',
    'sapp__app_to_upgrade' => 'التطبيقات المقرر ترقيتها',
    'sapp__upgrade_apps_title' => 'ترقية التطبيقات',
    'sapp__upgrade_to_ver' => 'الترقية للإصدار',
    'sapp__choose_pkg_ver' => 'تحديد حزمة...',
    'sapp__pkg_cant_upgrade_pkg' => 'لا يمكن استخدام الحزمة "1%" لترقية تطبيق الويب "2%".',
    'sapp__app_ugrade_error' => 'تعذرت ترقية التطبيق: 1%. يُرجى الاتصال بمسؤول النظام.',
    'sapp__no_suitable_db_found' => 'لم يتم العثور على قاعدة بيانات مناسبة.',
    'sapp__upgrade_success' =>  'تمت ترقية التطبيق بنجاح.',
    'sapp__pkg_info_changelog' => 'سجل التغييرات',
    'sapp_requirement_legend' => 'يتطلب التطبيق ميزات الاستضافة',

    // other
    'odbc__mssql_wsid' => 'معرّف محطة العمل',
    'odbc__mssql_driver' => 'برنامج تشغيل',
    'bt_apply' => 'تطبيق',
    'mn_edit__add_alias_if_mailbox_disabled' => 'لإنشاء اسم مستعار للبريد، يجب تشغيل علبة البريد على حساب البريد هذا. هل ترغب في تشغيل علبة البريد؟',
    'mn_edit__mailbox_disable_if_has_alias' => 'سيؤدي إيقاف تشغيل علبة البريد إلى إزالة الأسماء المستعارة للبريد حيث إنها ستتوقف عن العمل. هل ترغب في إيقاف تشغيل علبة البريد؟',
    'odbc__mysql_driver' => 'محرك أقراص MySQL ODBC',
    'antivirus__disable_reason_install' => 'لا يمكنك إدارة برنامج مكافحة الفيروسات لأنه غير مثبت.',
    'antivirus__disable_reason_key' => 'لا يمكنك إدارة برنامج مكافحة الفيروسات لأنه لم يتم تنشيطه بواسطة مفتاح الترخيص المناسب.',
    'antivirus__disable_reason_deny_personal_settings' => 'لا يمكنك إدارة برنامج مكافحة الفيروسات لأن سياسة الخادم تحظر الإعدادات الفردية لبرنامج مكافحة الفيروسات.',
    'component_name__sqladminmssql' => '‫Microsoft SQL Webadmin‬',
    'change_foreign_user_password' => 'تغيير كلمة المرور',
    'change_foreign_user_password_hint' => "لا ينتمي المستخدم إلى هذا التطبيق. انقر فوق الرابط للانتقال إلى تطبيق آخر وقم بتغيير كلمة مرور المستخدم هناك. للقيام بذلك، يجب أن يكون لديك الحقوق المناسبة في التطبيق.",
    'cf_url_text' => 'عنوان URL لاتصال JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'تنسيق السلسلة',
    'lang_unknown' => 'لغة غير معروفة',
    'odbc__access_driver' => 'برنامج تشغيل',
    'odbc__access_pwd' => 'كلمة المرور',
    'odbc__access_uid' => 'معرّف تسجيل الدخول',
    'odbc__excel_driver' => 'برنامج تشغيل',
    'pb__cl_ed' => 'تفاصيل العميل',
    'pb__actionlog' => 'سجل الإجراء',
    'pb__cl_limits' => 'حدود العميل',
    'pb__edit' => '‫تحرير‬',
    'pb__subdom_edit' => 'إعدادات الاستضافة',
    'cf__select_dsn_to_remove' => 'حدد DSN واحدًا على الأقل لإزالته',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'النسخ الاحتياطي لمحتوى علب البريد',

    'maillist_import_result' => "إجمالي عدد عناوين البريد الإلكتروني في الملف: 1% عدد عناوين البريد الإلكتروني المستوردة: 2% عدد عناوين البريد الإلكتروني الموجودة بالفعل. 3% عدد عناوين البريد الإلكتروني المكررة في الملف المحدد: 4% عدد عناوين البريد الإلكتروني غير الصالحة في الملف: %5",
    'maillist_import_error' => 'يتعذّر استيراد قائمة عناوين البريد الإلكتروني',

    //  spaw

    'spaw__unable_to_edit_no_body' => "الملف الذي حددته إما فارغ أو أنه ليس مستند HTML صالحًا بالترميز المحدد. يُرجى تحديد ترميز صحيح أو ما عليك سوى إضافة محتوى إلى الملف.",

    'dom_pref__external_mail_srv' => "إعادة التوجيه إلى خادم بريد خارجي باستخدام عنوان IP:",
    'mn_edit__store_messages' => 'علبة البريد',

    // aps

    'sapp__before_upgrade_notice' => 'ينصح بعمل نسخة احتياطية من التطبيق وبيانات المستخدم قبل بدء عملية الترقية.',
    'sapp__application_properties' => 'خصائص التطبيق',
    'sapp__application_root_descr' => 'الصفحة الرئيسية للتطبيق',

    'sapp__aps_license_invalid_id' => 'مفتاح الترخيص يحتوي على معرف غير صالح: 1%.',
    'sapp__aps_lic_key_alredy_exists' => 'الترخيص الذي يحتوي على رقم المفتاح 1% موجود بالفعل في قاعدة البيانات.',
    'sapp__aps_lic_del_used' => 'تعذر حذف مفتاح الترخيص، لأنه مستخدم من خلال تطبيق من التطبيقات المثبتة.',
    'sapp__aps_lic_del_unknown' => 'تعذر حذف مفتاح الترخيص: 1%',
    'sapp__aps_cappi_duplicate' => "هذا التطبيق موجود بالفعل في مجموعة تطبيقات العميل.",
    'sapp__appi_not_shared_no_install' => "لا يوجد مثل هذا التطبيق في مجموعة تطبيقات العميل. إذا كنت ترغب في تثبيت هذا التطبيق على موقع ما، فيجب عليك أولاً إضافة هذا التطبيق إلى مجموعة تطبيقات العميل.",
    'sapp__appi_shared_not_client' => "لا يوجد مثل هذا التطبيق في مجموعة تطبيقات العميل. إذا كنت ترغب في ترقية هذا التطبيق للإصدار المُحدد، فيجب عليك أولاً إضافة الإصدار المحدد للتطبيق إلى مجموعة تطبيقات العميل.",
    'sapp__apply_license_script_not_found' => 'تعذر العثور على البرنامج النصي "تطبيق الترخيص" لتطبيق الويب هذا.',
    'sapp__unable_to_activate_key' => 'حدث خطأ أثناء محاولة تنشيط مفتاح الترخيص: 1%',
    'sapp__unable_to_delete_ai_instances_exists' => 'توجد تطبيقات ويب مثبتة تتطلب وجود تطبيق الويب هذا في النظام.',
    'sapp__unable_to_delete_ai_in_pool' => 'هذا التطبيق لا يزال موجودًا في مجموعة تطبيقات العميل. إذا كنت ترغب في إزالة هذا التطبيق، فيجب عليك أولاً إزالته من مجموعات تطبيقات العملاء أو أن تجعله مجانيًا.',
    'sapp__unable_to_delete_app_template' => 'تعذرت إزالة التطبيق 1%#: %2',
    'sapp__limit_exceeded_client' => 'لقد وصلت إلى حد المرات المسموح به لتثبيت تطبيق الويب هذا (2%).',


    // atis module

    '_week_on' => 'الأسبوع التالي',
    '__week_first' => 'الأول',
    '__week_second' => 'الثاني',
    '__week_third' => 'الثالث',
    '__week_fourth' => 'الرابع',
    '__week_last' => 'آخر',
    '__not_started' => 'انتظار',
    '__started' => 'تشغيل',
    '__cancel_pending' => 'إلغاء',
    '__canceled' => 'تم الإلغاء',
    '__error' => 'خطأ',
    '__done' => 'تم',

    '__php_cgi_handler' => 'تطبيق CGI',
    '__php_isapi_handler' => 'امتداد ISAPI',
    '__php_fastcgi_handler' => 'تطبيق FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'تشغيل كـ',

    'firewall_tabs_rules' => 'قواعد جدار الحماية',

    'cf_dbfolder_text' =>'مجلد قاعدة البيانات',
    'cf_isnewdb_text' => 'إنشاء قاعدة بيانات',
    'cf_isnewdb_title' => 'حدد مربع الاختيار إذا لزم الأمر لإنشاء قاعدة بيانات',

    'pb__site_apps_upgrade' => 'ترقية تطبيق الويب',

    'detach' => 'قطع الاتصال',
    'preferences' => "تغيير كلمة المرور",

    'toolsbar__switch_user?' => "هل ترغب بالتأكيد في تسجيل الدخول بحساب مستخدم آخر؟",
    '__aps_left' => 'التثبيتات المتبقية',
    'aps__license_key' => 'مفتاح الترخيص',
    'aps__download_code' => 'تنزيل مفتاح الترخيص ورمز التنشيط',
    'aps__license_key_hint' => 'استرداد من خادم الترخيص باستخدام رمز التنشيط',
    'aps__database_not_available' => 'غير متوفر، يرجى التحقق من المجال أو حدود العميل',
    'aps__yes' => 'نعم',
    'aps__no' => 'لا',
    '__click_to_enlarge' => 'انقر للتكبير',
    'site_apps__back_to_list' => 'العودة إلى القائمة',
    'sapp__pkg_info_installation_requirements' => 'متطلبات التثبيت',
    '__close_window' => 'الإغلاق',

    //SAPP END

    'skin_info__already_default' => 'تم تعيين السطح كسطح افتراضي بالفعل.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => '‫برنامج Plesk Premium Antivirus‬',
    'drweb:properties_page_title' => '‫إعدادات برنامج Plesk Premium Antivirus لـ 1%‬',
    'drweb:properties_legend' => 'الإعدادات',
    'drweb:status' => 'جارٍ فحص البريد بحثًا عن فيروسات',

    // sb integration
    'sitebuilder_wizard' => 'معالج Presence Builder',
    'dom_site_builder' => 'انقر لفتح معالج Presence Builder.',
    'sb_plesk_admin_url' => 'عنوان URL لخادم Presence Builder. تأكد أن هذا العنوان ينحلّ بشكل سليم في DNS',
    'sb_plesk_admin_login' => 'اسم المستخدم لتسجيل دخول المسؤول إلى Presence Builder',
    'sb_plesk_admin_password' => 'كلمة مرور المسؤول',
    'sb_sitebuilder_preferences' => 'بيانات اعتماد مسؤول Presence Builder',
    'sb__server' => 'تفضيلات مسؤول نظام Presence Builder',
    'sb__sitebuilder_support' => 'دعم Presence Builder',
    'sb_keep_sb_user' => 'الاحتفاظ بحساب مستخدم مقابل في Presence Builder',
    'sb_create_sb_user' => 'إنشاء حساب مستخدم مقابل في Presence Builder',
    'sb__build_site_using_sitebuilder' => "إنشاء موقع ويب باستخدام Presence Builder",
    'sb_no_current_sb_server_set' => 'لم يتم تكوين الاتصال بـ Presence Builder بعد: تحتاج إلى إضافة سجل A في قالب منطقة DNS والذي سيشير إلى خادم Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "تعذّر استرداد المعلومات من نظام Presence Builder: 1%",
    'sb_unable_connect_sb_wrong_con_params' => "تعذّر الاتصال بـ Presence Builder: اسم المستخدم أو كلمة المرور غير صحيحة.",
    'sb_init_sb_manager' => "تهيئة مدير Presence Builder: 1%",
    'sb_err_couldnt_connect_sb' => "فشل الاتصال بنظام Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "هذا العميل لا يمتلك حساب مستخدم في Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "لم يتم تكوين Presence Builder.",
    'sb_err_you_dont_have_sbaccount' => "فشل اعتمادك في Presence Builder.",
    'sb_error_critical_during_operation' => "حدث الخطأ التالي في Presence Builder: 1%",
    'sb_err_sso_is_not_enabled' => "لم يتم تشغيل دعم التسجيل المنفرد في Plesk.",

    'warning__super_zone_exist' => "تم إنشاء المنطقة 1%، ومع ذلك فإن اسم المنطقة هذا هو اسم منطقة فرعية تابع لمنطقة أخرى موجودة بالفعل 2%، والتي تنتمي إلى مستخدم آخر 3%. هذا ممكن، لكن يُرجى التأكد من اختيارك حساب المستخدم الصحيح.",
    'error__super_zone_exist' => "يتعذر إنشاء منطقة DNS لأن منطقتها الرئيسية تنتمي إلى مستخدم آخر.",

    'locales__files_not_exits' => 'يتعذر تغيير الموقع: ملفات حزمة لغة الواجهة المحددة غير موجودة في النظام.',
    'locales__unavailable' => 'يتعذر تغيير الموقع: حزمة لغة الواجهة المحددة غير متوفرة.',

    // DB BU

    'pb__dbbackup_list' => 'ملفات النسخ الاحتياطي لقاعدة البيانات',
    // server
    'dbbackup__server_backup_settings' => 'النسخ الاحتياطي',
    'dbbackup__network_temp_dir' => 'دليل الشبكة المؤقت',
    'dbbackup__network_user' => 'اسم المُستخدِم',
    'dbbackup__network_pass' => 'كلمة المرور',
    // domain
    'dbbackup__add_database_legend' => 'استرداد قاعدة بيانات تم نسخها احتياطيًا',
    'dbbackup__add_database_restore' => 'استرداد قاعدة البيانات من ملف النسخ الاحتياطي هذا.',
    'dbbackup__add_database_file' => 'ملف النسخ الاحتياطي لقاعدة البيانات',
    'dbbackup__add_database_user' => 'اسم المستخدم الافتراضي',
    'dbbackup__add_database_pass' => 'كلمة المرور الافتراضية للمستخدم',
    'dbbackup__add_database_pass2' => 'تأكيد كلمة المرور الافتراضية للمستخدم',

    'bt_dbbackup_now' => 'نسخ احتياطي',

    'bt_repair' => 'إصلاح',

    'dbbackup__mssql_dump_upload_not_allowed' => 'يحظر مزود الاستضافة تحميل أعطال قاعدة البيانات لخادم SQL.',

    // APS categories

    'cf_invalid_password' => 'لا يمكن أن تكون كلمة المرور أطول من 16 رمزًا',
    'cf_invalid_description_length' => 'لا يمكن أن يكون الوصف أطول من 256 رمزًا',
    'ip_addr__ip_used_by_external_mail_server' => 'عنوان IP %1 مستخدم بالفعل بواسطة خادم بريد خارجي',

    // 8.4.1

    '__ftp_login_is_invalid' => 'اسم مستخدم FTP أو كلمة المرور غير صحيحة. يُرجى تحديد بيانات اعتماد مستخدم FTP صحيحة.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'تم الوصول إلى حد تغييرات الرقم التسلسلي. لا يمكن تنفيذ المزيد من تغييرات منطقة DNS اليوم.',
    'dns__zone_apply_changes' => 'لم يتم حفظ التغييرات التي أجريت على سجلات DNS حتى الآن. التغييرات التي تم إجراؤها مميزة أدناه. انقر فوق "تحديث" لتطبيق التغييرات على منطقة DNS أو انقر فوق "إرجاع" لإلغائها.',
    'dns__update_dns_zone' => 'انقر لحفظ التغييرات التي تم إجراؤها على سجلات DNS',
    'dns__revert_dns_zone' => 'انقر لإلغاء التغييرات التي تم إجراؤها على سجلات DNS',
    'bt_revert' => 'إرجاع',
    'dns__dns_zone_has_beed_updated' => 'تم حفظ التغييرات على سجلات DNS.',
    'dns__dns_zone_has_beed_reverted' => 'تم إلغاء التغييرات على سجلات DNS',
    'db__nondefault_server_not_allowed' => 'استخدام خادم قاعدة البيانات غير الافتراضي غير مسموح به',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'حساب العميل 1% ومجالاته.',
    'ui__client__disabled-warning' => 'حساب العميل 1% معلّق.',
    'ui__client__none-available' => 'لم يتم تكوين حسابات عميل.',
    'ui__client__short-title' => '1%',
    'ui__client__title' => 'العميل 1%',
    'ui__client_self__description' => 'قائمة مجالاتي.',
    'ui__client_self__short-title' => 'مجالاتي',
    'ui__client_self__title' => 'مجالاتي',


    'site_apps__non_removable' => 'العناصر التي لا يمكن إزالتها',
    'site_apps__non_removable_items' => 'لا يمكن إزالة تطبيقات الويب التالية:',

    'ui__client/custom-buttons/custom-button__none-available' => 'لا توجد أزرار مخصصة.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'لا توجد أزرار مخصصة في لوحة العميل الخاصة بالعميل %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'إزالة الزر 1%',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'إزالة',
    'ui__client/custom-buttons/custom-button/delete__title' => 'إزالة الزر 1%',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'إزالة أزرار مخصصة من لوحة العميل الخاصة بالعميل',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'إزالة',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'إزالة أزرار مخصصة',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'إزالة أزرار',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'حدد العميل الذي ترغب في إزالة أزراره المخصصة ثم انقر فوق التالي>>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'حدد الأزرار التي ترغب في إزالتها ثم انقر فوق التالي>>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'أكّد إزالة الأزرار عبر تحديد مربع الاختيار على هذه الشاشة، ثم انقر فوق "إنهاء".',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'إزالة زر مخصص من لوحة العميل الخاصة بالعميل.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'إزالة',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'إزالة أحد الأزرار المخصصة',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'إزالة زر مخصص',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'حدد العميل الذي ترغب في إزالة زره المخصص ثم انقر فوق التالي>>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'حدد زرًّا مخصصًا ترغب في إزالته ثم انقر فوق التالي>>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'أكّد إزالة الزر المخصص عبر تحديد مربع الاختيار على هذه الشاشة، ثم انقر فوق "إنهاء".',

    'ui__client/custom-buttons/custom-button/properties__description' => 'تعديل خصائص زر مستوى العميل 1%.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'الإعدادات',
    'ui__client/custom-buttons/custom-button/properties__title' => 'تعديل زر مخصص للعميل 1%',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'إضافة زر مخصص',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'حدد عميلاً ترغب في إنشاء أحد الأزرار المخصصة في لوحة العميل لديه، ثم انقر فوق التالي>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'انقر فوق "إنهاء" لإنشاء الزر.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'تغيير خصائص زر في لوحة العميل الخاصة بالعميل.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'الخصائص',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'تغيير خصائص زر في لوحة العميل الخاصة بالعميل',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'تغيير خصائص زر مخصص',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'حدد العميل الذي ترغب في تعديل زره المخصص ثم انقر فوق التالي>>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'حدد زرًّا مخصصًا ترغب في تعديله ثم انقر فوق التالي>>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'عند الانتهاء من تعديل خصائص الزر، انقر فوق "إنهاء" لتطبيق التغييرات والخروج من المعالج.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'اجعل الزر 1% غير متوفر لعملائك.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'اجعله غير متوفر لعملائك',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'اجعل الزر 1% غير متوفر لعملائك',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'اجعل الزر 1% مرئيًا لمستخدمي عميلك.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'اجعله متوفرًا لعملائك',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'اجعل الزر 1% مرئيًا لمستخدمي عميلك',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'اجعل زرًا مخصصًا متوفرًا/ غير متوفر لعملائك.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'متوفر/ غير متوفر لعملائك',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'اجعل زرًا مخصصًا متوفرًا أو غير متوفر لعملائك',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'اجعل زرًا مخصصًا متوفرًا/ غير متوفر لعملائك.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'حدد العميل الذي ترغب في جعل زر مخصص لديه متوفرًا لمستخدمي العميل ثم انقر فوق التالي>>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'حدد زرًا مخصصًا ترغب في جعله متوفرًا أو غير متوفر لعملائك ثم انقر فوق التالي>>.',

    'ui__client/domain__description' => 'إدارة المجال 1%',
    'ui__client/domain__disabled-warning' => 'المجال 1% مُعلّق.',
    'ui__client/domain__none-available' => 'ليس لديك أي مجالات.',
    'ui__client/domain__none-available__1' => 'لا يحتوي الحساب 1% على أي مجالات.',
    'ui__client/domain__none-available__2' => 'لا يحتوي الحساب 1% على أي مجالات.',
    'ui__client/domain__short-title' => '1%',
    'ui__client/domain__title' => 'المجال 1%',
    'ui__client/domain_self__description' => 'إدارة مجالك.',
    'ui__client/domain_self__disabled-warning' => 'تم تعليق مجالك.',
    'ui__client/domain_self__quick-search' => 'مجالاتي',
    'ui__client/domain_self__short-title' => 'مجالي',
    'ui__client/domain_self__title' => 'مجالي',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'لا توجد أزرار مخصصة موضوعة في لوحة العميل الخاصة بالعميل.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'لا توجد لدى العميل 1% أزرار مخصصة في لوحة العميل.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'لا توجد أزرار مخصصة للمجال 1%.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'إزالة الزر المخصص 1%.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'إزالة',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'إزالة الزر المخصص 1%',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'إزالة أزرار مخصصة.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'إزالة',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'إزالة أزرار مخصصة',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'إزالة أزرار مخصصة',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'حدد العميل الذي ترغب في إزالة الأزرار من لوحة مسؤول المجال لديه ثم انقر فوق التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'حدد المجال الذي ترغب في إزالة الأزرار من لوحة مسؤول المجال لديه ثم انقر فوق التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'حدد الأزرار التي ترغب في إزالتها ثم انقر فوق التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'أكّد إزالة الأزرار من خلال تحديد مربع الاختيار المقابل والنقر فوق "إنهاء" لإزالة الأزرار والخروج من المعالج.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'إزالة أحد الأزرار المخصصة.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'إزالة',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'إزالة أحد الأزرار المخصصة',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'إزالة أحد الأزرار المخصصة',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'حدد العميل الذي ترغب في إزالة الزر المخصص من لوحة مسؤول المجال لديه ثم انقر فوق التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في إزالة الزر من لوحة مسؤول المجال لديه ثم انقر فوق التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'حدد الزر المخصص الذي ترغب في إزالته ثم انقر فوق التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'أكّد إزالة الزر المخصص من خلال تحديد مربع الاختيار والنقر فوق "إنهاء" لإزالة الزر والخروج من المعالج.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "تغيير خصائص الزر المخصص 1%",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "الخصائص",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "تغيير خصائص الزر المخصص 1% في لوحة العميل.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'إضافة زر',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'حدد العميل الذي ترغب في وضع الزر في لوحة العميل لديه، ثم انقر فوق التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'حدد الاشتراك الذي ترغب في تعديل الزر فيه ثم انقر فوق التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'انقر فوق إنهاء لإنشاء الزر والخروج من المعالج.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "تغيير خصائص أحد الأزرار في لوحة العميل.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'الخصائص',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'تغيير خصائص أحد الأزرار في لوحة العميل',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'تغيير خصائص أحد الأزرار',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "حدد الزر المخصص الذي ترغب في تعديل إعداداته ثم انقر فوق التالي>>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'عند الانتهاء من تغيير خصائص الزر، انقر فوق "إنهاء" لتطبيق التغييرات والخروج من المعالج.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'اجعل الزر 1% غير متوفر لمستخدمي البريد ضمن هذا المجال.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'غير متوفر لمستخدمي البريد',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'اجعل الزر 1% غير متوفر لمستخدمي البريد ضمن هذا المجال',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'اجعل الزر 1% مرئيًا لمستخدمي البريد ضمن هذا المجال.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'إمكانية الوصول إلى مستخدمي البريد ضمن هذا المجال.',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'اجعل الزر المخصص 1% مرئيًا لمستخدمي البريد ضمن هذا المجال',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'اجعل زرًا مخصصًا متوفرًا أو غير متوفر لمستخدمين آخرين.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'متوفر/ غير متوفر لمستخدمين آخرين',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'اجعل أحد الأزرار المخصصة متوفرًا أو غير متوفر لمستخدمي البريد',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'اجعل زرًا مخصصًا متوفرًا أو غير متوفر لمستخدمين آخرين',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'حدد مجالاً ليوضع فيه الزر واضغط على التالي>>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'حدد زرًا ترغب في جعله متوفرًا أو غير متوفر للمستخدمين الآخرين ثم انقر فوق التالي>>.',

    'ui__client/domain/delete__description' => 'إزالة المجال 1%.',
    'ui__client/domain/delete__short-title' => 'إزالة',
    'ui__client/domain/delete__title' => 'إزالة المجال 1%',
    'ui__client/domain/delete_multi__description' => 'إزالة مجالات.',

    'ui__client/domain/delete_multi__short-title' => 'إزالة',
    'ui__client/domain/delete_multi__title' => 'إزالة مجالات',
    'ui__client/domain/delete_multi__wizard-title' => 'إزالة مجالات',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'حدد المجالات التي ترغب في إزالتها ثم انقر فوق التالي>>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'قم بتأكيد إزالة النطاقات بتحديد خانة الاختيار، ثم النقر فوق إنهاء لإزالتها وإنهاء المعالج.',
    'ui__client/domain/delete_unknown__description' => 'إزالة مجال.',
    'ui__client/domain/delete_unknown__short-title' => 'إزالة',
    'ui__client/domain/delete_unknown__title' => 'إزالة مجال',
    'ui__client/domain/delete_unknown__wizard-title' => 'إزالة مجال',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'حدد مجالاً ترغب في إزالته ثم انقر فوق التالي>>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'أكّد إزالة المجال من خلال تحديد مربع الاختيار والنقر فوق "إنهاء" لإزالته والخروج من المعالج.',

    'ui__client/domain/hosting__none-available' => 'لا توجد مجالات مكوّن عليها استضافة ويب. إنشاء مجال وتكوين استضافة ويب عليه للوصول إلى هذه الوظيفة.',
    'ui__client/domain/hosting__none-available__1' => 'لا يحتوي حساب المستخدم هذا على أي مجالات بها استضافة ويب مكوّنة. تكوين استضافة الويب على المجال المطلوب للوصول إلى هذه الوظيفة.',
    'ui__client/domain/hosting__none-available__2' => 'استضافة الويب غير مكوّنة للمجال 1%. تكوين استضافة الويب على المجال 1% للوصول إلى هذه الوظيفة.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'إدارة ملفاتك والأدلة',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في العمل على الملفات الموجودة عليه.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'لم يتم تكوين الاستضافة بعد على المجال. يُرجى إعداد استضافة مادية والنقر على التالي>> للانتقال إلى إدارة الملفات.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'لم يتم تكوين الاستضافة بعد على مجالك. يُرجى إعداد استضافة مادية والنقر على التالي>> للانتقال إلى إدارة الملفات.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'بعد الانتهاء من العمل على الملفات والأدلة، انقر فوق "إنهاء" للخروج من المعالج.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'بعد الانتهاء من العمل على الملفات والأدلة، انقر فوق "إنهاء" للخروج من المعالج.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'عرض إعدادات أداء الاستضافة',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'تعديل إعدادات أداء استضافة الويب',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'حدد المجال الذي ترغب في عرض إعدادات أداء الاستضافة عليه ثم انقر فوق التالي>>.',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في تكوين إعدادات أداء الاستضافة عليه ثم انقر فوق التالي>>.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'عدّل إعدادات أداء الاستضافة على المجال ثم انقر فوق "إنهاء".',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'بعد الانتهاء من عرض إعدادات أداء الاستضافة على المجال، انقر فوق "إنهاء".',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'بعد الانتهاء من عرض إعدادات أداء الاستضافة على مجالك، انقر فوق "إنهاء".',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'بعد الانتهاء من عرض إعدادات أداء الاستضافة على المجال، انقر فوق "إنهاء".',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'بعد الانتهاء من تكوين إعدادات أداء الاستضافة على مجالك، انقر فوق "إنهاء".',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'بعد الانتهاء من تكوين إعدادات أداء الاستضافة على المجال، انقر فوق "إنهاء".',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "العملاء",
    'ui__client/domain/hosting/application#list_header__description__title' => "‫الوصف‬",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "العناصر",
    'ui__client/domain/hosting/application#list_header__name__title' => "الاسم",
    'ui__client/domain/hosting/application#list_header__release__title' => "إصدار",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "فرز حسب العملاء",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "فرز حسب الوصف",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "فرز حسب العناصر",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "فرز حسب الاسم",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "فرز حسب الإصدار",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "فرز حسب الإصدارات",
    'ui__client/domain/hosting/application#list_header__title' => "تطبيقات الويب",
    'ui__client/domain/hosting/application#list_header__version__title' => "الإصدارات",

    'ui__client/domain/properties__client_ip_address_was_assigned' => 'تم تعيين عنوان IP التالي %%ip_address%% للعميل %%client_name%%.',
    'ui__client/domain/properties__client_ip_pool_is_empty' => 'مجموعة عناوين IP المستخدم فارغة. سيتم تعيين عنوان IP المحدد لحساب المستخدم المقابل.',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => 'سيتم إنشاء المجال الجديد في الحال بعد النقر فوق التالي>>.',

    'ui__client/domain/properties_new__wizard-title' => 'إنشاء مجال',
    'ui__client/domain/properties_new__wizard__1_unknown' => 'حدد العميل الذي ترغب في إنشاء مجال له.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => 'حدد النوع الذي تفضله من خدمة الاستضافة، وانقر فوق التالي>>.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => 'عند الانتهاء من تكوين إعادة التوجيه على المجال، انقر فوق "إنهاء" لتطبيق التكوين والخروج من المعالج.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => 'عند الانتهاء من تكوين خدمة الاستضافة على المجال، انقر فوق "إنهاء" لتطبيق جميع التغييرات والخروج من المعالج.',

    'ui__client/domain/properties_unknown__wizard-title' => 'إعداد حساب مسؤول المجال',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في إعداد حساب مسؤول المجال له.',
    'ui__client/domain/properties_unknown__wizard__3' => 'لاستكمال إنشاء حساب مسؤول المجال، انقر فوق "إنهاء".',
    'ui__client/domain/properties_unknown__wizard__3_self' => 'لتطبيق التغييرات والخروج من المعالج، انقر فوق "إنهاء".',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => 'إحصائيات FTP المجهول للمجال',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => 'إحصائيات FTP المجهول',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => 'إحصائيات FTP المجهول للمجال',

    'ui__client/domain/report/ftp-stats_unknown__description' => 'إحصائياتFTP للمجال',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'إحصائيات FTP',
    'ui__client/domain/report/ftp-stats_unknown__title' => 'إحصائياتFTP للمجال',

    'ui__client/domain/report/traffic__description' => 'عرض استخدام النطاق الترددي حسب الموقع 1%',
    'ui__client/domain/report/traffic__short-title' => 'استخدام النطاق الترددي',
    'ui__client/domain/report/traffic__title' => 'النطاق الترددي حسب الموقع 1%',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => 'إحصائيات عدد الزيارات الآمنة للموقع',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => 'إحصائيات الزيارات عبر SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => 'إحصائيات عدد الزيارات الآمنة للموقع',

    'rpt_reseller_section_general' => 'عام',
    'rpt_reseller_section_domains' => 'المجالات',
    'rpt_reseller_section_clients' => 'العملاء',
    'statistics__cl_active_domains' => "مجالات نشطة",
    'rpt_reseller_cl_domains' => "المجالات",
    'rpt_reseller_cl_subdomains' => "المجالات الفرعية",
    'by__cl_domains' => "مجالات العملاء",
    'dom_ctrl__cl_mboxes' => "علب البريد",
    'rpt_reseller_cl_redirects' => "أدوات التوجيه",
    'rpt_reseller_cl_mail_groups' => "مجموعات البريد",
    'rpt_reseller_cl_mail_resps' => "الردود التلقائية",
    'rpt_reseller_cl_mail_lists' => "قوائم المراسلة",
    'rpt_reseller_cl_web_users' => "مستخدمو الويب",
    'rpt_reseller_cl_data_bases' => "قواعد البيانات",

    'statistics__active_clients' => 'العملاء الذين لديهم اشتراكات نشطة',
    'statistics__clients_active_domains' => 'مجالات نشطة',
    'statistics__clients_doms' => 'المجالات',
    'statistics__cl_doms' => 'المجالات',
    '__clients_subdomains' => 'المجالات الفرعية',
    '__clients_domains' => 'المجالات',
    'dom_ctrl__clients_mboxes' => 'علب البريد',
    'dom_ctrl__clients_redir' => 'أدوات التوجيه',
    'dom_ctrl__clients_mg' => 'مجموعات البريد',
    'dom_ctrl__clients_resp' => 'الردود التلقائية',
    'dom_ctrl__clients_maillists' => 'قوائم المراسلة',
    'dom_ctrl__clients_wu' => 'مستخدمو الويب',
    'dom_ctrl__clients_db' => 'قواعد البيانات',

    'dom_ctrl__cl_redir' => 'أدوات التوجيه', // to resolve!
    'dom_ctrl__cl_mg' => 'مجموعات البريد', // to resolve!
    'dom_ctrl__cl_resp' => 'الردود التلقائية', // to resolve!
    'dom_ctrl__cl_maillists' => 'قوائم المراسلة', // to resolve!
    'dom_ctrl__cl_wu' => 'مستخدمو الويب', // to resolve!
    'dom_ctrl__cl_db' => 'قواعد البيانات', // to resolve!

    'rpt_cl_section_clients' => 'العملاء',

    'rpt_admin_section_general' => 'عام',
    'rpt_admin_section_resellers' => 'بائعو التجزئة',
    'rpt_admin_section_clients' => 'العملاء',
    'rpt_admin_section_personal_clients' => 'عملائي',
    'rpt_admin_section_domains' => 'المجالات',
    'rpt_admin_section_personal_domains' => 'المجالات الشخصية',

    'rpt_reseller_section_personal_domains' => 'المجالات الشخصية',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في تعليقه أو تنشيطه.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'تعليق أو تنشيط أحد المجالات',

    'ui__client/ip-pool__description' => 'تخصيص عناوين IP وشهادات SSL/TLS أو إلغاء تخصيصها للعميل %1.',
    'ui__client/ip-pool__short-title' => 'تجمع IP',
    'ui__client/ip-pool__title' => 'تجمّع IP للعميل %1',
    'ui__client/ip-pool_self__description' => 'عرض مجموعة عناوين IP الخاصة بك.',
    'ui__client/ip-pool_self__short-title' => 'تجمع IP',
    'ui__client/ip-pool_self__title' => 'مجموعة عناوين IP لديّ',
    'ui__client/ip-pool/properties__description' => 'إعداد تجمّع IP للعميل 1%.',

    'ui__client/ip-pool/properties__short-title' => 'تجمع IP',
    'ui__client/ip-pool/properties__title' => 'إعداد تجمّع IP للعميل 1%',
    'ui__client/ip-pool/properties_self__description' => 'عرض مجموعة عناوين IP الخاصة بك.',

    'ui__client/ip-pool/properties_self__short-title' => 'مجموعة عناوين IP لديّ',
    'ui__client/ip-pool/properties_self__title' => 'مجموعة عناوين IP لديّ',
    'ui__client/ip-pool/properties_unknown__description' => 'تخصيص عناوين IP وشهادات SSL/TLS أو إلغاء تخصيصها من العميل.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'تجمع IP',
    'ui__client/ip-pool/properties_unknown__title' => 'إعداد تجمع عناوين IP للعميل',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'إعداد تجمع عناوين IP للعميل',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'حدد العميل الذي ترغب في تكوين تجمّع IP له.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'عند الانتهاء من تكوين تجمّع IP، انقر فوق "إنهاء" لتطبيق التغييرات والخروج من المعالج.',


    'ui__client/limits_readonly-unknown__description' => 'عرض حدود المورد للعميل.',
    'ui__client/limits_readonly-unknown__short-title' => 'حدود المورد',
    'ui__client/limits_readonly-unknown__title' => 'عرض حدود المورد لحساب العميل',
    'ui__client/limits_readonly-unknown__wizard-title' => 'عرض أو تغيير حدود المورد للعميل',

    'ui__client/limits_unknown__wizard-title' => 'عرض أو تغيير حدود المورد للعميل',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'حدد العميل الذي تريده.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'حدد العميل الذي تريده.',
    'ui__client/limits_unknown__wizard__2' => 'لتطبيق التغييرات، انقر فوق "إنهاء".',
    'ui__client/limits_unknown__wizard__2_readonly' => 'للخروج من المعالج، انقر فوق "إنهاء".',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'للخروج من المعالج، انقر فوق "إنهاء".',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'للخروج من المعالج، انقر فوق "إنهاء".',

    'ui__client/permissions_unknown__wizard-title' => 'عرض أو تغيير أذونات العميل',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'عند الانتهاء من عرض أذوناتك، انقر فوق "إنهاء" لتطبيق التغييرات والخروج من المعالج.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'حدد العميل الذي ترغب في عرض أذوناته أو تغييرها.',
    'ui__client/permissions_unknown__wizard__2' => 'عند الانتهاء من تغيير أذونات العميل، انقر فوق "إنهاء" لتطبيق التغييرات والخروج من المعالج.',

    'ui__client/preferences_unknown__wizard-title' => 'تعديل تفضيلات العميل',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'حدد العميل الذي ترغب في إدارة تفضيلات واجهة الواجهة والجلسة لديه.',
    'ui__client/preferences_unknown__wizard__2' => 'عند الانتهاء من تغيير تفضيلات العميل، انقر فوق إنهاء.',
    'ui__client/preferences_unknown__wizard__2_self' => 'عند الانتهاء من تغيير تفضيلاتك، انقر فوق "إنهاء".',

    'ui__custom-buttons/custom-button__none-available' => 'ليس لديك أزرار مخصصة.',
    'ui__custom-buttons/custom-button/delete__description' => 'إزالة الزر المخصص 1%.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'إزالة',
    'ui__custom-buttons/custom-button/delete__title' => 'إزالة الزر المخصص 1%',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'إزالة أزرار مخصصة.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'إزالة',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'إزالة أزرار مخصصة',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'إزالة أزرار مخصصة',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'حدد الأزرار التي ترغب في إزالتها.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'أكّد إزالة الأزرار عبر تحديد مربع الاختيار والنقر فوق "إنهاء" لإكمال المعالج.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'إزالة أزرار مخصصة.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'إزالة',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'إزالة أزرار مخصصة',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'إزالة أزرار مخصصة',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'حدد الزر المخصص الذي ترغب في إزالته.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'أكّد إزالة الزر من خلال تحديد مربع الاختيار والنقر فوق "إنهاء" لإكمال المعالج.',
    'ui__custom-buttons/custom-button/properties__description' => 'تغيير خصائص الزر 1%.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'الخصائص',
    'ui__custom-buttons/custom-button/properties__title' => 'تغيير خصائص الزر 1%',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'إنشاء زر',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'انقر فوق "إنهاء" لإنشاء الزر.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'تغيير خصائص زر مخصص.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'الخصائص',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'تغيير خصائص زر مخصص',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'تغيير خصائص زر مخصص',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'حدد الزر المخصص الذي ترغب في تغيير خصائصه.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'لتطبيق التغييرات، انقر فوق "إنهاء".',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'اجعل الزر المخصص 1% غير متوفر للمستخدمين الآخرين.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'غير متوفر للمستخدمين الآخرين',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'اجعل الزر المخصص 1% غير متوفر للمستخدمين الآخرين',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'اجعل الزر المخصص 1% متوفرًا للمستخدمين الآخرين.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'متوفر للمستخدمين الآخرين',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'اجعل الزر المخصص 1% متوفرًا للمستخدمين الآخرين',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'اجعل الزر المخصص متوفرًا أو غير متوفر لمستخدمين آخرين.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'متوفر أو غير متوفر لمستخدمين آخرين',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'اجعل الزر المخصص متوفرًا أو غير متوفر لمستخدمين آخرين',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'اجعل الزر المخصص متوفرًا أو غير متوفر لمستخدمين آخرين',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'حدد الزر المخصص الذي ترغب في جعله متوفرًا أو غير متوفر للمستخدمين الآخرين ثم انقر فوق التالي>>.',

    'ui__longtasks#list_header__name__title' => "الاسم",
    'ui__longtasks#list_header__owner__title' => "المالك",
    'ui__longtasks#list_header__start_time__title' => "وقت الإنشاء",
    'ui__longtasks#list_header__status__title' => "‫الحالة‬",
    'ui__longtasks#list_header__title' => "المهام",
    'ui__longtasks#list_header__finish_time__title' => "وقت الاكتمال",
    'ui__longtasks#task_list_legend__title' => "المهام",
    'ui__longtasks#tools_legend__title' => "أدوات",
    'ui__longtasks__description' => "إدارة مهام الخلفية",
    'ui__longtasks__short-title' => "مهام الخلفية",
    'ui__longtasks__title' => "مهام الخلفية",
    'ui__longtasks/longtask/properties#current_operation__title' => "العملية الحالية:",
    'ui__longtasks/longtask/properties#finish_time__title' => "وقت الاكتمال المقدّر:",
    'ui__longtasks/longtask/properties#general_legend__title' => "عام",
    'ui__longtasks/longtask/properties#owner__title' => "بدأت المهمة عند:",
    'ui__longtasks/longtask/properties#progress__title' => "التقدّم الكلي:",
    'ui__longtasks/longtask/properties#start_time__title' => "بدأت المهمة:",
    'ui__longtasks/longtask/properties#status_legend__title' => "حالة المهمة",
    'ui__longtasks/longtask/properties__description' => "حالة مهمة الخلفية ومعلوماتها",

    'ui__longtasks/properties__description' => "إعدادات مهام الخلفية",
    'ui__longtasks/properties__short-title' => "الإعدادات",
    'ui__longtasks/properties__title' => "مهام الخلفية",

    // updated
    'ui__mass-mail/template#list_header__title' => 'قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-mail/template#list_header__name__title' => 'اسم القالب',
    'ui__mass-mail/template#list_header__from_email__title' => 'مرسِل',
    'ui__mass-mail/template#list_header__to__title' => 'المستلمون',
    'ui__mass-mail/template#list_header__subject__title' => 'الموضوع',
    'ui__mass-mail/template#list_header__cdate__title' => 'تاريخ الإنشاء',
    'ui__mass-mail/template#list_header__send__title' => '‫إرسال‬',

    'ui__mass-mail/template/properties__short-title' => '1%',
    'ui__mass-mail/template/properties__title' => 'تعديل قالب رسائل بريد إلكتروني جماعية',
    'ui__mass-mail/template/properties__description' => 'تعديل قالب رسائل البريد الإلكتروني الجماعية المحدد.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'إضافة قالب بريد إلكتروني جماعي',
    'ui__mass-mail/template/properties_unknown-new__title' => 'إضافة قالب بريد إلكتروني جماعي',
    'ui__mass-mail/template/properties_unknown-new__description' => 'إضافة قالب رسائل بريد إلكتروني جماعية.',
    'ui__mass-mail/send__short-title' => 'إرسال بريد إلكتروني جماعي',
    'ui__mass-mail/send__title' => 'إرسال رسالة بريد إلكتروني جماعي',
    'ui__mass-mail/send__description' => 'إرسال رسالة بريد إلكتروني جماعية للمستلمين المحددين.',
    'ui__mass-mail/template/delete_multi__short-title' => 'إزالة قوالب بريد إلكتروني جماعية',
    'ui__mass-mail/template/delete_multi__title' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية التالية:',
    'ui__mass-mail/template/delete_multi__description' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية المحددة.',
    'ui__mass-mail/template/delete_multi__done' => 'تمت إزالة قوالب الرسائل المحددة.',
    'ui__mass-mail/template/properties__invalid_values' => 'القيم المحددة غير صالحة',


    // old
    'ui__mass-mail#body_text__description' => 'يمكنك استخدام المتغير <name> في نص الرسالة (وليس في الرأس). سيتم استبداله باسم جهة اتصال العميل أو بائع التجزئة.',
    'ui__mass-mail#body_text__title' => 'نص الرسالة',
    'ui__mass-mail#compose_legend__title' => 'رسالة',
    'ui__mass-mail#from_email_text__title' => 'من (عنوان البريد الإلكتروني)',
    'ui__mass-mail#list_header__cdate__title' => 'تم الإنشاء',
    'ui__mass-mail#list_header__from_email__title' => 'من',
    'ui__mass-mail#list_header__name__title' => 'الاسم',
    'ui__mass-mail#list_header__send__title' => 'إنشاء رسالة',
    'ui__mass-mail#list_header__subject__title' => 'الموضوع',
    'ui__mass-mail#list_header__title' => 'قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-mail#list_header__to__title' => 'إلى',
    'ui__mass-mail#list_legend__title' => 'قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-mail#load_template_text__title' => 'تحميل',
    'ui__mass-mail#name_text__title' => 'اسم القالب',
    'ui__mass-mail#option_mode_all__title' => 'الكل',
    'ui__mass-mail#option_mode_except__title' => 'الكل باستثناء المُحدد',
    'ui__mass-mail#option_mode_select__title' => 'المحدد فقط',
    'ui__mass-mail#option_select_template__title' => '---حدد قالبًا---',
    'ui__mass-mail#picker_legend__title' => 'قوالب رسائل البريد الإلكتروني',
    'ui__mass-mail#picker_title__title' => 'حدد قالبًا',
    'ui__mass-mail#save_as_legend__title' => 'الحفظ كقالب',
    'ui__mass-mail#save_as_text__title' => 'حفظ الرسالة المنشأة إلى قالب جديد باسم',
    'ui__mass-mail#subject_text__title' => 'الموضوع',
    'ui__mass-mail#template_legend__title' => 'قالب',
    'ui__mass-mail#to_admin_text__title' => 'مسؤول Plesk',
    'ui__mass-mail#to_clients_text__title' => 'العملاء',
    'ui__mass-mail#to_domains_text__title' => 'مسؤولو المجال',
    'ui__mass-mail#to_select_text__title' => 'حدد عناوين',
    'ui__mass-mail#to_show_hide_text__title' => 'إظهار/إخفاء المحدد',
    'ui__mass-mail#to_text__title' => 'إلى',
    'ui__mass-mail#tools_legend__title' => 'أدوات',
    'ui__mass-mail__already_exists' => 'القالب بالاسم 1% موجود بالفعل',
    'ui__mass-mail__none-available' => 'ليس لديك قوالب رسائل.',

    'ui__mass-mail/delete__description' => 'إزالة قالب رسائل البريد الإلكتروني الجماعية 1%',

    'ui__mass-mail/delete__empty_selection' => 'يُرجى تحديد القوالب التي ترغب في إزالتها',
    'ui__mass-mail/delete__short-title' => 'إزالة 1%',
    'ui__mass-mail/delete__title' => 'إزالة قالب رسائل البريد الإلكتروني الجماعية 1%',
    'ui__mass-mail/delete_multi__description' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية',

    'ui__mass-mail/delete_multi__short-title' => 'إزالة',
    'ui__mass-mail/delete_multi__title' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-mail/delete_multi__wizard-title' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'حدد قوالب رسائل البريد الإلكتروني الجماعية التي ترغب في إزالتها.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'أكّد إزالة القوالب عبر تحديد مربع الاختيار والنقر فوق "إنهاء" لإكمال المعالج.',
    'ui__mass-mail/delete_unknown__description' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-mail/delete_unknown__short-title' => 'إزالة',
    'ui__mass-mail/delete_unknown__title' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-mail/delete_unknown__wizard-title' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'حدد قالب رسالة البريد الإلكتروني الجماعي الذي ترغب في إزالته.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'أكّد إزالة القالب عبر تحديد مربع الاختيار والنقر فوق "إنهاء" لإكمال المعالج.',

    'ui__mass-mail/properties__description' => 'تعديل قالب رسائل البريد الإلكتروني الجماعية1%.',

    'ui__mass-mail/properties__invalid_values' => 'القيم المحددة غير صحيحة',
    'ui__mass-mail/properties__short-title' => '1%',
    'ui__mass-mail/properties__title' => 'تعديل قالب رسائل البريد الإلكتروني الجماعية 1%',

    'ui__mass-mail/properties_new__wizard-title' => 'إنشاء قالب رسائل بريد إلكتروني جماعية',
    'ui__mass-mail/properties_unknown-new__description' => 'إنشاء قالب رسائل بريد إلكتروني.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'إضافة قالب رسائل بريد إلكتروني',
    'ui__mass-mail/properties_unknown-new__title' => 'إنشاء قالب رسائل بريد إلكتروني',
    'ui__mass-mail/properties_unknown__wizard-title' => 'تعديل قالب رسائل بريد إلكتروني جماعية',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'حدد القالب الذي ترغب في إزالته ثم انقر فوق التالي>>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'عند الانتهاء من تعديل القالب، انقر فوق "إنهاء" لتطبيق التغييرات والخروج من المعالج.',

    'ui__mass-mail/send__invalid_values' => 'لقد حددت قيمًا غير صحيحة',

    'ui__mass-mail/send_new__wizard-title' => 'إنشاء قالب رسائل وإرسال بريد إلكتروني',
    'ui__mass-mail/send_unknown-new__description' => 'إرسال بريد إلكتروني لمستلمين محددين',

    'ui__mass-mail/send_unknown-new__short-title' => 'إرسال بريد إلكتروني جماعي',
    'ui__mass-mail/send_unknown-new__title' => 'إرسال رسالة بريد إلكتروني جماعي',
    'ui__mass-mail/send_unknown__description' => 'إرسال بريد إلكتروني لمستلمين محددين',

    'ui__mass-mail/send_unknown__short-title' => 'إرسال بريد إلكتروني جماعي',
    'ui__mass-mail/send_unknown__title' => 'إرسال رسالة بريد إلكتروني جماعي',
    'ui__mass-mail/send_unknown__wizard-title' => 'إرسال رسالة بريد إلكتروني جماعي',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'حدد القالب المطلوب ثم انقر فوق التالي>>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'عند الانتهاء من تعديل خصائص القالب، انقر فوق "إنهاء" لإرسال الرسالة والخروج من المعالج.',

    'ui__mass-email/delete__description' => 'إزالة قوالب رسائل البريد الإلكتروني الجماعية المحددة.',

    'ui__mass-email/delete__empty_selection' => "حدد القوالب التي ترغب في إزالتها.",
    'ui__mass-email/delete__short-title' => "إزالة 1%",
    'ui__mass-email/delete__title' => "إزالة قالب رسائل البريد الإلكتروني الجماعية 1%",
    'ui__mass-email/delete_multi__description' => "إزالة قوالب رسائل البريد الإلكتروني الجماعية",

    'ui__mass-email/delete_multi__short-title' => "إزالة",
    'ui__mass-email/delete_multi__title' => "إزالة قوالب رسائل البريد الإلكتروني الجماعية",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "أكّد إزالة القوالب عبر تحديد مربع الاختيار والنقر فوق \"إنهاء\" لإكمال المعالج.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "حدد قوالب رسائل البريد الإلكتروني الجماعية التي ترغب في إزالتها.",
    'ui__mass-email/delete_multi__wizard-title' => "إزالة قوالب رسائل البريد الإلكتروني الجماعية",
    'ui__mass-email/delete_unknown__description' => "إزالة قوالب رسائل البريد الإلكتروني الجماعية",
    'ui__mass-email/delete_unknown__short-title' => "إزالة",
    'ui__mass-email/delete_unknown__title' => "إزالة قوالب رسائل البريد الإلكتروني الجماعية",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "أكّد إزالة القالب عبر تحديد مربع الاختيار والنقر فوق \"إنهاء\" لإكمال المعالج.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "حدد قالب رسالة البريد الإلكتروني الجماعي الذي ترغب في إزالته.",
    'ui__mass-email/delete_unknown__wizard-title' => "إزالة قوالب رسائل البريد الإلكتروني الجماعية",
    'ui__mass-email/send__description' => "إرسال بريد إلكتروني لمستلمين محددين",
    'ui__mass-email/send__short-title' => "إرسال بريد إلكتروني جماعي",
    'ui__mass-email/send__title' => "إرسال رسالة بريد إلكتروني جماعي",
    'ui__mass-email/send_main__description' => "إرسال بريد إلكتروني لمستلمين محددين",

    'ui__mass-email/send_main__short-title' => "إرسال بريد إلكتروني جماعي",
    'ui__mass-email/send_main__title' => "إرسال رسالة بريد إلكتروني جماعي",
    'ui__mass-email/send_selectresellers__title' => 'تحديد بائعي التجزئة',
    'ui__mass-email/send_selectresellers__short-title' => 'بائعو التجزئة',
    'ui__mass-email/send_selectresellers__description' => 'تحديد حسابات بائعي التجزئة',

    'ui__mass-email/send_selectclients__description' => "تحديد حسابات العملاء",

    'ui__mass-email/send_selectclients__short-title' => "العملاء",
    'ui__mass-email/send_selectclients__title' => "حدد عملاء",
    'ui__mass-email/send_selectdomainusers__description' => "تحديد حسابات مسؤولي المجال",

    'ui__mass-email/send_selectdomainusers__short-title' => "مسؤولو المجال",
    'ui__mass-email/send_selectdomainusers__title' => "تحديد مسؤولي المجال",
    'ui__mass-email/template/properties_main__description' => "إنشاء قالب رسائل بريد إلكتروني جماعية",
    'ui__mass-email/template/properties_main__short-title' => "تحرير القالب",
    'ui__mass-email/template/properties_main__title' => "تعديل قالب رسائل بريد إلكتروني جماعية",
    'ui__mass-email/template/properties_new-main__description' => "إنشاء قالب لرسائل البريد الإلكتروني الجماعي.",
    'ui__mass-email/template/properties_new-main__short-title' => "إنشاء قالب رسائل بريد إلكتروني جماعية",
    'ui__mass-email/template/properties_new-main__title' => "إنشاء قالب رسائل بريد إلكتروني جماعية",
    'ui__mass-email/template/properties_new-selectclients__description' => "حدد العملاء الذين ينبغي أن يستلموا رسائل البريد الإلكتروني الجماعي حسب هذا القالب",
    'ui__mass-email/template/properties_new-selectclients__title' => "حدد العملاء الذين ينبغي أن يستلموا رسائل البريد الإلكتروني الجماعي حسب هذا القالب",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "حدد مسؤولي المجال الذين ينبغي أن يستلموا رسائل البريد الإلكتروني الجماعي حسب هذا القالب",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "حدد مسؤولي المجال الذين ينبغي أن يستلموا رسائل البريد الإلكتروني الجماعي حسب هذا القالب",
    'ui__mass-email/template/properties_selectclients__title' => "حدد العملاء الذين ينبغي أن يستلموا رسائل البريد الإلكتروني الجماعي حسب هذا القالب",
    'ui__mass-email/template/properties_selectdomainusers__title' => "حدد مسؤولي المجال الذين ينبغي أن يستلموا رسائل البريد الإلكتروني الجماعي حسب هذا القالب",

    'ui__mass-email/template/properties_unknown-new__description' => "إنشاء قالب رسائل بريد إلكتروني جماعية",
    'ui__mass-email/template/properties_unknown-new__short-title' => "إنشاء قالب",
    'ui__mass-email/template/properties_unknown-new__title' => "إنشاء قالب رسائل بريد إلكتروني جماعية",
    'ui__news/dismiss__description' => 'انقر لإغلاق نافذة الأخبار. لن يعرض Plesk هذه النافذة حتى يتم تحديث مقالات الأخبار.',

    'ui__news/dismiss__title' => 'أغلق الأخبار',

    'ui__server__description' => 'إدارة الخادم.',
    'ui__server__short-title' => 'أدر خادمك',
    'ui__server__title' => 'إدارة الخادم',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'عنوان IP 1% غير متوفر.',
    'ui__server/ip-address__none-available' => 'لا توجد عناوين IP.',
    'ui__server/ip-addresses/ip-address__title' => "عناوين IP",
    'ui__server/ip-address/client/properties_new__description' => "تعيين عنوان IP 1% لبائعي التجزئة.",
    'ui__server/ip-address/client/properties_new__short-title' => 'تعيين',
    'ui__server/ip-address/client/properties_new__title' => "تعيين عنوان IP 1% لبائعي التجزئة",
    'ui__server/ip-address/client__none-available' => 'لا توجد حسابات مستخدم',
    'ui__server/ip-address/client_unknown__quick_search' => 'المستخدمين',
    'ui__server/ip-address/client_unknown__wizard-title' => 'قائمة المستخدمين الذين يستخدمون عنوان IP هذا.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'يُرجى تحديد عنوان IP.',
    'ui__server/ip-address/client/delete__description' => 'إلغاء تعيين عنوان IP من بائع التجزئة.',
    'ui__server/ip-address/client/delete__short-title' => 'إلغاء التعيين',
    'ui__server/ip-address/client/delete__title' => 'إلغاء تعيين عنوان IP من بائع التجزئة',
    'ui__server/ip-address/client/delete_multi__description' => "إلغاء تعيين عنوان IP من تجمّع بائعي التجزئة.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'إلغاء التعيين',
    'ui__server/ip-address/client/delete_multi__title' => 'إلغاء تعيين عنوان IP من بائع التجزئة.',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "إزالة عنوان IP تجمعات المستخدمين.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'حدد عنوان IP الذي ترغب في إلغاء تعيينه من المستخدمين ثم انقر فوق التالي>>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'حدد المستخدمين الذين ترغب في إلغاء تعيين عناوين IP المخصصة لهم ثم انقر فوق التالي>>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'أكّد إلغاء تعيين عنوان IP من المستخدمين من خلال تحديد مربع الاختيار والنقر فوق "إنهاء" للخروج من المعالج.',
    'ui__server/ip-address/client/delete_unknown__description' => 'إلغاء تعيين عنوان IP من بائعي التجزئة.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'إلغاء التعيين',
    'ui__server/ip-address/client/delete_unknown__title' => 'إلغاء تعيين عنوان IP من بائعي التجزئة.',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'إلغاء تعيين عنوان IP من المستخدمين.',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'حدد عنوان IP الذي ترغب في إلغاء تعيينه من المستخدمين ثم انقر فوق التالي>>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'حدد المستخدم الذي ترغب في إلغاء تعيين عناوين IP المخصصة له ثم انقر فوق التالي>>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'أكّد إلغاء تعيين عنوان IP من المستخدمين من خلال تحديد مربع الاختيار والنقر فوق "إنهاء" للخروج من المعالج.',

    'ui__server/ip-address/domain__description' => "جميع المجالات على عنوان IP 1%.",
    'ui__server/ip-address/domain__short-title' => "المجالات",
    'ui__server/ip-address/domain__title' => "المجالات على عنوان IP 1%",
    'ui__server/ip-address/domain_unknown__description' => "جميع المجالات على عنوان IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "المجالات",
    'ui__server/ip-address/domain_unknown__title' => "المجالات على عنوان IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "حدد عنوان IP المطلوب ثم انقر فوق التالي>>.",

    'ui__server/ip-address/properties__description' => 'تغيير خصائص عنوان IP 1%.',
    'ui__server/ip-address/properties__short-title' => 'الخصائص',
    'ui__server/ip-address/properties__title' => 'تغيير خصائص عنوان IP 1%',

    'ui__server/ip-address/properties_new__wizard-title' => 'إضافة عنوان IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'عند الانتهاء من تغيير خصائص عنوان IP، انقر فوق "إنهاء" لتطبيق التغييرات.',
    'ui__server/ip-address/properties_unknown__description' => 'تغيير خصائص عنوان IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'الخصائص',
    'ui__server/ip-address/properties_unknown__title' => 'تغيير خصائص عنوان IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'تغيير خصائص عنوان IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'حدد عنوان IP الذي ترغب في تغيير خصائصه.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'عند الانتهاء من تغيير خصائص عنوان IP، انقر فوق "إنهاء" لتطبيق التغييرات.',

    'ui__server/spam-filter/black-list__description' => 'إعداد القائمة السوداء لعوامل البريد العشوائي على مستوى الخادم.',
    'ui__server/spam-filter/black-list__short-title' => 'القائمة السوداء',
    'ui__server/spam-filter/black-list__title' => 'القائمة السوداء لعوامل البريد العشوائي على مستوى الخادم.',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'سيتم إضافة عناوين البريد الإلكتروني الفريدة 1% أولاً.',
    'ui__server/spam-filter/black-list/address__description' => 'عنوان القائمة السوداء لعوامل تصفية البريد العشوائي.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'لا توجد عناوين بريد إلكتروني في القائمة.',
    'ui__server/spam-filter/black-list/address__file_size' => 'الملف الذي تم تحميله فارغ.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'عناوين البريد الإلكتروني التالية غير صالحة: 1%.',
    'ui__server/spam-filter/black-list/address__none-available' => 'لا توجد عناوين في القائمة السوداء لعوامل تصفية البريد العشوائي.',
    'ui__server/spam-filter/black-list/address__short-title' => 'عنوان',
    'ui__server/spam-filter/black-list/address__title' => 'عنوان القائمة السوداء 1%',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'إضافة عناوين إلى القائمة السوداء.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'إضافة عناوين',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'إضافة عناوين إلى القائمة السوداء',

    'ui__server/spam-filter/black-list/address/delete__description' => 'إزالة العنوان 1% من القائمة السوداء على مستوى الخادم.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'إزالة',
    'ui__server/spam-filter/black-list/address/delete__title' => 'إزالة العنوان 1% من القائمة السوداء على مستوى الخادم',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'إزالة عناوين من القائمة السوداء على مستوى الخادم.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'إزالة',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'إزالة عناوين من القائمة السوداء على مستوى الخادم',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'إزالة عناوين من القائمة السوداء لعوامل تصفية رسائل البريد العشوائي على مستوى الخادم.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'حدد عناوين عوامل تصفية رسائل البريد العشوائي التي ترغب في إزالتها ثم انقر فوق التالي>>.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'أكّد إزالة عناوين عوامل تصفية رسائل البريد العشوائي من خلال تحديد مربع الاختيار المقابل والنقر فوق "إنهاء" لإزالتها تمامًا والخروج من المعالج.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'إزالة عنوان من القائمة السوداء على مستوى الخادم.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'إزالة',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'إزالة عنوان من القائمة السوداء على مستوى الخادم',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'إزالة عناوين من القائمة السوداء لعوامل تصفية رسائل البريد العشوائي على مستوى الخادم.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'حدد عنوان عامل تصفية رسائل البريد العشوائي الذي ترغب في إزالته ثم انقر فوق التالي>>.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'أكّد إزالة عنوان عامل تصفية رسائل البريد العشوائي من خلال تحديد مربع الاختيار المقابل والنقر فوق "إنهاء" لإزالته تمامًا والخروج من المعالج.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'سيتم إضافة عناوين البريد الإلكتروني الفريدة 1% أولاً.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'لا توجد عناوين بريد إلكتروني في القائمة.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'تعذر تحميل الملف. أقصى حجم لملف يمكن تحميله هو 1%.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'عناوين البريد الإلكتروني التالية غير صالحة: 1%.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'إضافة عناوين إلى القائمة السوداء.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'إضافة عناوين',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'إضافة عناوين إلى القائمة السوداء',

    'ui__server/spam-filter/properties__description' => 'إعداد عامل تصفية البريد العشوائي للخادم.',

    'ui__server/spam-filter/properties__short-title' => 'الإعدادات',
    'ui__server/spam-filter/properties__title' => 'إعدادات تصفية البريد العشوائي',

    'ui__server/spam-filter/toggle_disable__description' => 'تعطيل عوامل تصفية البريد العشوائي للنظام بأكمله.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'تعطيل',
    'ui__server/spam-filter/toggle_disable__title' => 'تعطيل عوامل تصفية البريد العشوائي',
    'ui__server/spam-filter/toggle_enable__description' => 'تمكين عوامل تصفية البريد العشوائي للخادم بأكمله.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'تمكين',
    'ui__server/spam-filter/toggle_enable__title' => 'تمكين عوامل تصفية البريد العشوائي',
    'ui__server/spam-filter/toggle_unknown__description' => 'تمكين عوامل تصفية البريد العشوائي للخادم بأكمله أو تعطيلها.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'تمكين أو تعطيل',
    'ui__server/spam-filter/toggle_unknown__title' => 'تمكين عوامل تصفية البريد العشوائي أو تعطيلها',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'تمكين عوامل تصفية البريد العشوائي أو تعطيلها',

    'ui__server/spam-filter/white-list__description' => 'إعداد القائمة البيضاء لعوامل تصفية البريد العشوائي على مستوى النظام.',
    'ui__server/spam-filter/white-list__short-title' => 'القائمة البيضاء',
    'ui__server/spam-filter/white-list__title' => 'القائمة البيضاء لعوامل تصفية البريد العشوائي على مستوى النظام.',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'سيتم إضافة عناوين البريد الإلكتروني الفريدة 1% أولاً.',
    'ui__server/spam-filter/white-list/address__description' => 'عنوان القائمة البيضاء لعوامل تصفية البريد العشوائي.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'لا توجد عناوين بريد إلكتروني في القائمة.',
    'ui__server/spam-filter/white-list/address__file_size' => 'الملف الذي تم تحميله فارغ.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'عناوين البريد الإلكتروني التالية غير صالحة: 1%.',
    'ui__server/spam-filter/white-list/address__none-available' => 'لا توجد عناوين في القائمة البيضاء على مستوى الخادم لعوامل تصفية البريد العشوائي.',
    'ui__server/spam-filter/white-list/address__short-title' => 'عنوان',
    'ui__server/spam-filter/white-list/address__title' => 'عنوان القائمة البيضاء 1%',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'إضافة عناوين إلى القائمة البيضاء.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'إضافة عناوين',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'إضافة عناوين إلى القائمة البيضاء',

    'ui__server/spam-filter/white-list/address/delete__description' => 'إزالة العنوان 1% من القائمة البيضاء على مستوى الخادم.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'إزالة',
    'ui__server/spam-filter/white-list/address/delete__title' => 'إزالة العنوان 1% من القائمة البيضاء على مستوى الخادم',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'إزالة عناوين من القائمة البيضاء بالخادم.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'إزالة',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'إزالة عناوين من القائمة البيضاء بالخادم',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'إزالة عناوين من القائمة البيضاء لعوامل تصفية رسائل البريد العشوائي على مستوى الخادم.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'حدد عناوين عوامل تصفية رسائل البريد العشوائي التي ترغب في إزالتها ثم انقر فوق التالي>>.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'أكّد إزالة عناوين عوامل تصفية رسائل البريد العشوائي من خلال تحديد مربع الاختيار المقابل والنقر فوق "إنهاء" لإزالتها تمامًا والخروج من المعالج.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'إزالة عنوان من القائمة البيضاء على مستوى الخادم.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'إزالة',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'إزالة عنوان من القائمة البيضاء على مستوى الخادم',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'إزالة عناوين من القائمة البيضاء لعوامل تصفية رسائل البريد العشوائي على مستوى الخادم.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'حدد عنوان عامل تصفية رسائل البريد العشوائي الذي ترغب في إزالته ثم انقر فوق التالي>>.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'أكّد إزالة عنوان عامل تصفية رسائل البريد العشوائي من خلال تحديد مربع الاختيار المقابل والنقر فوق "إنهاء" لإزالته تمامًا والخروج من المعالج.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'سيتم إضافة عناوين البريد الإلكتروني الفريدة 1% أولاً.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'لا توجد عناوين بريد إلكتروني في القائمة.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'تعذر تحميل الملف. أقصى حجم لملف يمكن تحميله هو 1%.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'عناوين البريد الإلكتروني التالية غير صالحة: 1%.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'إضافة عناوين إلى القائمة البيضاء.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'إضافة عناوين',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'إضافة عناوين إلى القائمة البيضاء',

    'ui__server/mail/statistics#apply__description' => "تطبيق عامل التصفية",
    'ui__server/mail/statistics#apply__title' => "تطبيق",
    'ui__server/mail/statistics#custom_from__title' => "من",
    'ui__server/mail/statistics#custom_to__title' => "إلى",
    'ui__server/mail/statistics#period_all__title' => "الكل",
    'ui__server/mail/statistics#period_custom__title' => "مخصص",
    'ui__server/mail/statistics#period_month__title' => "الشهر الحالي",
    'ui__server/mail/statistics#period_prev_month__title' => "الشهر الماضي",
    'ui__server/mail/statistics#period_prev_week__title' => "الأسبوع الماضي",
    'ui__server/mail/statistics#period_today__title' => "اليوم",
    'ui__server/mail/statistics#period_week__title' => "الأسبوع الحالي",
    'ui__server/mail/statistics#period_yesterday__title' => "أمس",
    'ui__server/mail/statistics#show_for_period__title' => "عرض للفترة",
    'ui__server/mail/statistics#tools_legend__title' => "أدوات",
    'ui__server/mail/statistics__description' => "عرض إحصائيات البريد العشوائي والفيروسات",

    'ui__server/mail/statistics__short-title' => "إحصائيات",
    'ui__server/mail/statistics__title' => "إعدادات البريد",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "إحصائيات البريد العشوائي",
    'ui__server/mail/statistics/spam#tools_legend__title' => "أدوات",
    'ui__server/mail/statistics/spam__description' => "عرض إحصائيات البريد العشوائي",

    'ui__server/mail/statistics/spam__short-title' => "إحصائيات البريد العشوائي",
    'ui__server/mail/statistics/spam__title' => "إحصائيات البريد العشوائي",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Mailname",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% من الكل",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "فرز حسب حساب البريد",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "فرز حسب % من الكل",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "فرز حسب رسائل البريد العشوائي التي تم استلامها",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "حسابات البريد",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "رسائل البريد العشوائي التي تم استلامها",
    'ui__server/mail/statistics/spam/recipients__description' => "المستلمون",

    'ui__server/mail/statistics/spam/recipients__short-title' => "المستلمون",
    'ui__server/mail/statistics/spam/recipients__title' => "المستلمون",
    'ui__server/mail/statistics/spam/summary#clean__title' => "مسح",
    'ui__server/mail/statistics/spam/summary#infected__title' => "مصاب",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "‫الحالة‬",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% من الكل",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "العدد",
    'ui__server/mail/statistics/spam/summary#protected__title' => "محمي",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "لم يتم التحقق",
    'ui__server/mail/statistics/spam/summary__description' => "ملخص",

    'ui__server/mail/statistics/spam/summary__short-title' => "ملخص",
    'ui__server/mail/statistics/spam/summary__title' => "ملخص",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "إحصائيات الفيروسات",
    'ui__server/mail/statistics/virus#tools_legend__title' => "أدوات",
    'ui__server/mail/statistics/virus__description' => "عرض إحصائيات الفيروسات",

    'ui__server/mail/statistics/virus__short-title' => "إحصائيات الفيروسات",
    'ui__server/mail/statistics/virus__title' => "إحصائيات الفيروسات",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "حساب البريد",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% من الكل",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "فرز حسب mailname",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "فرز حسب % من الكل",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "فرز حسب الفيروسات التي تم استلامها",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "حسابات البريد",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "الفيروسات التي تم استلامها",
    'ui__server/mail/statistics/virus/recipients__description' => "المستلمون",

    'ui__server/mail/statistics/virus/recipients__short-title' => "المستلمون",
    'ui__server/mail/statistics/virus/recipients__title' => "المستلمون",
    'ui__server/mail/statistics/virus/summary#clean__title' => "مسح",
    'ui__server/mail/statistics/virus/summary#infected__title' => "مصاب",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "‫الحالة‬",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% من الكل",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "العدد",
    'ui__server/mail/statistics/virus/summary#protected__title' => "محمي",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "لم يتم التحقق",
    'ui__server/mail/statistics/virus/summary__description' => "ملخص",

    'ui__server/mail/statistics/virus/summary__short-title' => "ملخص",
    'ui__server/mail/statistics/virus/summary__title' => "ملخص",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "الاسم",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% من الكل",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "فرز حسب الاسم",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "فرز حسب % من الكل",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "فرز حسب الكائنات المصابة",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "الفيروسات",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "الكائنات المصابة",
    'ui__server/mail/statistics/virus/viruses__description' => "الفيروسات",

    'ui__server/mail/statistics/virus/viruses__short-title' => "الفيروسات",
    'ui__server/mail/statistics/virus/viruses__title' => "الفيروسات",

    'ui__support#param_company__title' => "الشركة",
    'ui__support#param_email__title' => "البريد الإلكتروني",
    'ui__support#param_firstname__title' => "الاسم الأول",
    'ui__support#param_keynumber__title' => "رقم مفتاح المنتج",
    'ui__support#param_operatingsystem__title' => "نظام التشغيل",
    'ui__support#param_phone__title' => "الهاتف",
    'ui__support#param_psabuild__title' => "إصدار Plesk",
    'ui__support#param_psainsttype__title' => "نوع تثبيت Plesk",
    'ui__support#param_psaversion__title' => "إصدار Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "أدوات",

    'ui__reseller/traffic-history_unknown__short-title' => "عرض حركة مرور البيانات حسب بائعي التجزئة",
    'ui__reseller/traffic-history_unknown__title' => "عرض حركة مرور البيانات حسب بائعي التجزئة",
    'ui__reseller/traffic-history_unknown__description' => "عرض حركة مرور البيانات حسب حسابات بائع التجزئة.",
    'ui__reseller#list__title' => "بائعو التجزئة",
    'accounts_list__name__filter_title' => "الاسم",
    'accounts_list__resource__filter_title' => "استخدام الموارد",
    'resellers_list__filter_resource_usage_any' => "أي",
    'resellers_list__filter_resource_usage_overuse' => "الاستخدام الزائد",
    'resellers_list__filter_resource_usage_normal' => "ضمن الحدود",
    'accounts_list__status__filter_title' => "‫الحالة‬",
    'resellers_list__filter_status_any' => "أي",
    'resellers_list__filter_status_blocked' => "تم التوقف مؤقتَا",
    'resellers_list__filter_status_active' => "‫نشط‬",
    'resellers_list__filter_clients__filter_title' => "إظهار",
    'resellers_list__filter_clients_on' => "بائعو التجزئة وعملاؤهم",
    'resellers_list__filter_clients_off' => "بائعو التجزئة فقط",
    '__disk_usage' => "مساحة القرص المستخدمة",
    'ui__reseller/traffic_unknown__short-title' => "عرض حركة مرور البيانات حسب بائعي التجزئة",
    'ui__reseller/traffic_unknown__title' => "عرض حركة مرور البيانات حسب بائعي التجزئة",
    'ui__reseller/traffic#list__title' => "حركة مرور البيانات حسب بائع التجزئة",
    'ui__reseller/traffic_unknown__description' => "عرض تقرير استخدام حركة مرور البيانات.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "حركة مرور البيانات حسب بائع التجزئة",

    '__reseller_name' => "اسم بائع التجزئة",
    '__reseller' => "بائعو التجزئة",
    'resellertrafficlist_header' => "عرض حركة مرور البيانات حسب بائعي التجزئة",
    '__reseller_personal' => "حركة مرور البيانات المستخدم من مجالات بائع التجزئة",
    'ui__reseller/traffic-history__short-title' => "حركة مرور البيانات حسب بائعي التجزئة",
    'ui__reseller/traffic-history__title' => "حركة مرور البيانات حسب بائعي التجزئة",
    'ui__reseller/traffic-history__description' => "عرض تقرير استخدام حركة مرور البيانات.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "1%",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "السماح بزيادة المبيعات",
    'limits__reseller_oversell_description' => "تتيح زيادة المبيعات لبائع التجزئة أن يبيع موارد أكثر مما كان محددًا فعليًا له أو لها. إذا تم السماح بزيادة البيع، يخضع بائع التجزئة لاستخدام المورد الفعلي بدلاً من تخصيص المورد الأولي.",
    'limits__overuse_block_text' => "سياسة الاستخدام الزائد",
    'limits__overuse_block_true_text' => "غير مسموح بالاستخدام الزائد",
    'limits__reseller_overuse_block_true_description' => "حظر الاستخدام الزائد للموارد. لا يمكن أن يتجاوز الاستخدام الفعلي للمورد مقدار المورد المعين بشكل أولي",
    'limits__overuse_block_false_text' => "يُسمح بالاستخدام الزائد",
    'limits__reseller_overuse_block_false_description' => "لا تحظر الاستخدام الزائد للموارد، واسمح لبائع التجزئة باستخدام موارد أكثر من المقدمة بشكل أولي. يمكن أن يتجاوز الاستخدام الفعلي للمورد مقدار المورد المعين بشكل أولي",
    'limits__reseller_overuse_notify_text' => "إشعار بائع التجزئة بوصوله إلى حدود المورد.",
    'reseller_perm__manage_sh_access_disabled' => "لا يمكن لبائع التجزئة السماح بالوصول إلى الوعاء أو منعه",
    'reseller_perm__manage_sh_access_chrooted' => "يمكن لبائع التجزئة السماح بالوصول إلى بيئات نظام Chroot فقط",
    'reseller_perm__manage_sh_access_any' => "يمكن أن يسمح بائع التجزئة بالوصول إلى أي نوع من الأوعية",
    'template__reseller_num_excl_ips' => "عيّن عناوين IP مخصصة لبائع التجزئة",

    // Reseller's Home page
    'client_chown__no_clients_selected' => 'يرجى تحديد حسابات العميل الذي تريد تعيين مالك جديد لها.',
    'ui__reseller#tools2__title' => "الحساب",
    'ui__reseller#info__title' => "المعلومات",
    'ui__reseller#clientsTab__title' => "العملاء",
    'ui__reseller#domainsTab__title' => "المجالات",
    'ui__reseller__title' => "إدارة حساب بائع التجزئة 1%",
    'domains__reseller_info' => "1% من العملاء، 2% من المجالات، 3% من مساحة القرص المستخدمة، 4% من البيانات التي تم نقلها.",
    'domains__reseller_info_hiding_traffic' => "1% من العملاء، 2% من المجالات، 3% من مساحة القرص المستخدمة.",
    'ui__reseller__description' => "إدارة حساب بائع التجزئة.",

    'ui__reseller/limits_unknown__wizard-title' => 'عرض أو تغيير حدود بائع التجزئة',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'حدد بائع التجزئة الذي تريده.',
    'ui__reseller/limits_unknown__wizard__2' => 'لتطبيق التغييرات، انقر فوق "إنهاء".',

    'ui__client/report_reseller__short-title' => "تقرير",
    'ui__client/report_reseller__title' => "عرض تقرير الحساب",
    'ui__client/report_reseller__description' => "عرض تقرير حساب بائع التجزئة.",
    'ui__client/ip-pool_reseller__short-title' => "تجمع IP",
    'ui__client/ip-pool_reseller__description' => "تخصيص عناوين IP وشهادات SSL/TLS لحساب بائع التجزئة.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "حدد إعدادات الحساب وانقر على إنهاء.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'عرض أو تغيير أذونات بائع التجزئة',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'حدد بائع التجزئة الذي ترغب في عرض أذوناته أو تغييرها.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'عند الانتهاء من تغيير أذونات بائع التجزئة، انقر فوق "إنهاء" لتطبيق التغييرات والخروج من المعالج.',

    // Customers > create customer account

    '__resellers_list' => 'بائعو التجزئة',
    'picker_reseller__title' => 'حدد بائع تجزئة',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "أدوات",
    'ui__client#tools2__title' => "الحساب",
    'ui__client#info__title' => "المعلومات",
    'ui__client#clientslist__title' => "العملاء",
    'ui__client#domainslist__title' => "المجالات",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "تم فرز جميع تطبيقات الويب الآن حسب الفئات، مما يسهّل اختيار التطبيق الصحيح لتثبيته.",
    'feature__domainkeys__reseller' => "يمكنك استخدام آلية مصادقة مُرسل رسائل البريد الإلكتروني بآلية DKIM لتقليل كمية البريد العشوائي والرسائل الإلكترونية الاحتيالية.",

    '__reseller_form' => "نموذج بائع التجزئة",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "يُرجى تحديد حساب العميل الذي ترغب في تغيير إعداداته.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "لتغيير حدود استخدام المورد، انقر فوق حدود المورد.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "لتغيير الأذونات للعمليات التي يمكن للعميل إجراؤها في Plesk، انقر فوق أذونات.",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "لإنشاء مجال ينتمي إلى حسابك الخاص، انقر فوق \"إنشاء مجال\". لإنشاء مجال لعميل من عملائك، انقر فوق اسم العميل الذي تريده، ثم انقر فوق \"إنشاء مجال\".",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "اجعل هذا القالب متوفرًا لمستخدمين آخرين",
    'template__shared_description' => "حدد هذا الخيار إذا كنت ترغب في أن يتمكن عملاؤك من استخدام هذا القالب.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'أدوات',

    'ui__client/traffic-history_unknown__short-title' => 'عرض حركة مرور البيانات حسب العملاء',
    'ui__client/traffic-history_unknown__title' => 'حركة مرور البيانات حسب العملاء',
    'ui__client/traffic-history_unknown__description' => 'عرض تقرير استخدام حركة مرور البيانات لجميع العملاء',
    'ui__client/traffic-history__short-title' => 'حركة مرور البيانات حسب العملاء',
    'ui__client/traffic-history__title' => 'عرض حركة مرور البيانات حسب العملاء',
    'ui__client/traffic-history__description' => 'عرض تقرير استخدام حركة مرور البيانات لجميع العملاء',

    'ui__client/traffic#list__title' => 'حركة مرور البيانات حسب العملاء',
    'ui__reseller/client/traffic#list__title' => 'حركة مرور البيانات حسب العملاء',

    'clients_list__filter_type__filter_title' => 'إظهار',
    'clients_list__filter_type_any' => 'العملاء وبائعو التجزئة',
    'clients_list__filter_type_clients' => 'العملاء فقط',
    'clients_list__filter_type_resellers' => 'بائعو التجزئة فقط',
    'ui__client/domain_unknown-new__short-title' => "إنشاء مجال",

    // Customers > View traffic by customers
    '__personal' => "حركة مرور البيانات المستخدم من مجالات المستخدم",
    'PersonalTrafficList_header_of_client__' => "عرض تقرير استخدام حركة مرور البيانات لحسابك",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "لا يمكن أن يسمح مسؤول المجال بالوصول إلى shell أو منعه",
    'domain_perm__manage_sh_access_chrooted' => "يمكن أن يسمح مسؤول المجال بالوصول إلى بيئة نظام Chroot فقط",
    'domain_perm__manage_sh_access_any' => "يمكن أن يسمح مسؤول المجال بالوصول إلى أي نوع من أنواع shell",

    // APS Catalog
    'bt_add_to_vault' => "إضافة إلى المخزن",
    'bt_hide_updates' => "إخفاء التحديثات المتوفرة",
    'bt_show_updates' => "إظهار التحديثات المتوفرة",

    '__site_apps__applications' => "تطبيقات",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "التطبيقات المحددة لإضافتها للمخزن",
    'site_apps__application_selected' => "محدد",
    'site_apps__currently_in_vault' => "الإصدارات الأخرى موجودة بالفعل في المخزن:",
    'site_apps__new_versions' => "الإصدارات الجديدة:",
    'site_apps__patches' => "تصحيحات:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "عدد التطبيقات المجدولة لإضافتها إلى المخزن: 1%",
    'site_apps__applications_downloading_now' => "جار تنزيل التطبيقات التالية الآن: 1%", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "موجود بالفعل في المخزن",

    // Server > Action Log
    'bt_skin_edit' => "تحرير وصف السطح",
    'domains__you_want_change_the_status_of_the_reseller??' => "هل تريد بالتأكيد تغيير حالة حساب بائع التجزئة؟",
    'limits__oversell_legend' => "زيادة المبيعات",
    'limitsManager__limit_available_error' => "تعذر تخصيص المقدار المطلوب للموارد (%%quantity%% %%limitName%%). لا يتوافر سوى %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "تعذّر تعيين حد استخدام المورد المطلوب (%%quantity%% %%limitName%%) حيث إن القيمة الجديدة أقل من مقدار الموارد المحفوظة لعملائك أو التي تستخدمها بنفسك (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "تعذّر تعيين حد استخدام المورد المطلوب (%%quantity%% %%limitName%%) حيث إن القيمة الجديدة أقل من المقدار الفعلي للموارد المستخدمة بالفعل في حسابك ومواقعك (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "استخدام النطاق الترددي بواسطة الخدمات",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "عرض تقرير استخدام حركة مرور البيانات",
    'ui__client/domain/traffic_unknown-reseller__title' => "عرض تقرير استخدام حركة مرور البيانات",

    'ui__client/domain_new__short-title' => "إنشاء مجال",

    'ui__client_reseller__description' => "إدارة حساب بائع التجزئة 1%.",
    'ui__client_reseller__short-title' => "1%",
    'ui__client_reseller__title' => "إدارة حساب بائع التجزئة",

    '__owner_name' => "اسم المالك",
    'domains_list__resource__filter_title' => "استخدام الموارد",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "كتالوج تطبيقات APS",
    'site_apps__applications_have_updates' => "تتوفر الإصدارات المُحدّثة من التطبيقات التالية: 1% لعرض التحديثات، تأكد من أنك ترى خانة \"بحث\" ثم حدد مربع الاختيار <b>عرض التحديثات فقط</b> وابحث عن التطبيقات التي تحتاجها.",
    'site_apps__progress_adding_to_vault' => "إضافة إلى المخزن:",
    'site_apps__progress_done_message' => "التقدّم:",
    'site_apps__progress_applications_left' => "يتبقى %1 من %2 من التطبيقات",
    'site_apps__download_item_long_task_title' => "تنزيل تطبيق APS (%1)",
    'site_apps__download_transaction_long_task_title' => "تنزيل تطبيقات APS من كتالوج APS",
    'site_apps__last_check_for_updates' => "التحقق الأخير من وجود تحديثات: 1%",
    'site_apps__all_sucessfully_added_to_app_vault' => "جميع التطبيقات المحددة تمت إضافتها بنجاح إلى مخزن التطبيقات",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "1% التطبيقات المحددة تمت إضافتها بنجاح إلى مخزن التطبيقات.",
    'site_apps__no_search_results' => 'لم يتم العثور على أي تطبيقات. جرّب طلب بحث آخر أو تصفّح التطبيقات حسب التصنيفات.',
    'site_apps__search_results_title' => 'نتائج البحث',
    '__site_apps__search_by_application' => 'اسم التطبيق',
    '__site_apps__search_by_vendor' => 'البائع',
    '__site_apps__search_by_vendor__all' => 'كل البائعين',
    '__site_apps__search_by_packager' => 'جهة الجمع',
    '__site_apps__search_by_certification_level' => 'مستوى الشهادة',
    '__site_apps__search_by_cert__any' => 'أي',
    '__site_apps__search_by_cert__silver_and_higher' => 'فضية وما فوقها',
    '__site_apps__search_by_cert__gold_and_higher' => 'ذهبية وما فوقها',
    '__retry' => 'إعادة المحاولة',
    'site_apps__application_packager_site' => 'جهة الجمع',
    'site_apps__add_to_pool_message' => "يتم وزيع التطبيقات التي تكون /\"متوفرة للكل/\" تلقائيًا على جميع بائعي التجزئة والعملاء مع عدد غير محدود من التثبيتات. يتم توزيع التطبيقات المقيّدة على جميع بائعي التجزئة والعملاء يدويًا حسب كل حالة فردية مع عدد محدد تمامًا من التثبيتات المتاحة.",
    'site_apps__make_available_for_all' => "اجعل التطبيقات المحددة متوفرة لكل المستخدمين",

    'site_apps__broadcast_app_text' => "يتم وزيع التطبيقات التي تكون /\"متوفرة للكل/\" تلقائيًا على جميع بائعي التجزئة والعملاء مع عدد غير محدود من التثبيتات. يتم توزيع التطبيقات المقيّدة على جميع بائعي التجزئة والعملاء يدويًا حسب كل حالة فردية مع عدد محدد تمامًا من التثبيتات المتاحة.",
    'site_apps__broadcast_app_name' => 'اجعل التطبيقات متوفرة لكل المستخدمين',

    // User Application Pool per application
    'site_apps__available_clients' => 'المستخدمون المتوفرون',
    'site_apps__no_more_clients_to_add_to_pool' => 'لا يوجد المزيد من حسابات المستخدمين يمكنك تقديمها لهذا التطبيق',

    // Installed application instances
    'site_apps__installations' => 'عمليات التثبيت',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "اسم المجال وعنوان IP",
    '__assign_ip_address' => "تعيين عنوان IP",
    '__switch_on_service' => "تشغيل الخدمة",
    '__hosting_configuration' => "تكوين الاستضافة",
    '__vrt_hst' => "استضافة مواقع الويب",
    '__vrt_hst_hint' => "استضافة موقع ويب على هذا الخادم.",
    '__fwd' => "إعادة التوجيه",
    '__web_hosting_settings' => "إعدادات الاستضافة",
    '__fwd_hint' => "إعادة توجيه الزوار لموقع ويب آخر.",
    '__none_hint' => "لا تستضف موقع ويب الآن.",
    '__login_hint' => "اسم المستخدم هذا مستخدم للوصول إلى موقعك على الويب عبر FTP",
    '__password_hint' => "كلمة المرور هذه مستخدمة للوصول إلى موقعك على الويب عبر FTP",
    '__advanced_hosting_setup' => "تكوين الإعدادات المتقدمة لاستضافة موقع الويب",
    '__domain_creation_successful' => "تم إنشاء المجال.",
    'bt_hosting_settings' => "إعدادات الاستضافة",
    '__change_hosting_type' => "تغيير نوع المضيف للمجال 1%",
    '__hosting_type_change_warning' => "عند تغيير نوع الاستضافة لإعادة التوجيه أو عدم الاستضافة، فإن كل الملفات والأدلة ذات الصلة بموقعك تتم إزالتها من الخادم. تأكد من حفظ نسخة من موقعك محليًا.",
    '__current_hosting_type' => "نوع الاستضافة الحالي",
    '__new_hosting_type' => "نوع الاستضافة الجديد",
    '__fwd_settings' => "إعدادات إعادة التوجيه",
    '__fwd_settings_legend' => "إعدادات إعادة التوجيه",
    '__fwd_destination_url' => "عنوان URL للوجهة",
    '__fwd_type' => "نوع إعادة التوجيه",
    '__fwd_type_standart' => "إعادة التوجيه القياسي",
    '__fwd_type_standart_hint' => "أعد توجيه زائري موقع الويب إلى موقع آخر، مع إظهار عنوان الوجهة لهم، حتى يكونوا على دراية بإعادة التوجيه.",
    '__fwd_type_frame' => "إعادة توجيه الإطار",
    '__fwd_type_frame_hint' => "أعد توجيه زائري موقع الويب إلى موقع آخر، مع عدم إظهار عنوان الوجهة لهم، بحيث لا يشعرون بإعادة التوجيه.",
    '__hosting_type_template_warning' => "نوع الاستضافة الذي حددته يختلف عن النوع المحدد في القالب. في حالة الاستمرار سيتم تجاهل إعدادات استضافة الويب في القالب المحدد. هل ترغب بالتأكيد في إعداد نوع الاستضافة المحدد؟",

    'ui__client/domain/properties#vrt_hst__title' => "استضافة مواقع الويب",
    'ui__client/domain/properties#vrt_hst__description' => "استضافة موقع ويب على هذا الخادم",
    'ui__client/domain/properties#fwd__title' => "إعادة التوجيه",
    'ui__client/domain/properties#fwd__description' => "إعادة توجيه الزوار إلى موقع ويب آخر",
    'ui__client/domain/properties#none__title' => "لا توجد استضافة",
    'ui__client/domain/properties#none__description' => "لا تستضف موقع ويب الآن",

    '__no_resellers_selected' => "يجب تحديد حساب بائع تجزئة واحد على الأقل.",

    'ui__client/logo_unknown__wizard-title' => 'إعداد شعار',
    'ui__client/logo_unknown__wizard__1_unknown' => 'يُرجى تحديد العميل الذي ترغب في تغيير خصائص شعاره.',
    'ui__client/logo_unknown__wizard__2' => 'انقر فوق "إنهاء" لتطبيق التغييرات.',
    'ui__client/logo_unknown__wizard__2_self' => 'انقر فوق "إنهاء" لتطبيق التغييرات.',

    'ui__client/ipaddress/properties_new__short-title' => "إضافة عنوان IP",
    'ui__client/ipaddress/properties_new__title' => 'إضافة عنوان IP',
    'ui__client/ipaddress/properties_new__description' => "أضف عنوان IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "إضافة عنوان IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "إضافة عنوان IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "إضافة عنوان IP",
    'ui__client/ipaddress/delete_multi__short-title' => "إزالة عنوان IP",
    'ui__client/ipaddress/delete_multi__description' => "أزل عناوين IP.",
    'ippool_Manager__no_available_ips' => "لا توجد عناوين IP فارغة في مجموعة IP.",
    'ippool_Manager__ip_shared' => "مشترك",
    'ippool_Manager__ip_exclusive' => "مخصص",
    'ui__client/ipaddress/properties__title' => "إدارة عناوين IP",
    'ui__client/ipaddress/properties__description' => "عرض أو تغيير خصائص عنوان IP.",
    'ui__client/ipaddress_unknown-new__title' => "إضافة عنوان IP",
    'ui__client/ipaddress_unknown-new__short-title' => "إضافة عنوان IP",
    'ui__client/ipaddress_unknown-new__description' => "أضف عناوين IP.",

    'ui__mass-mail#to_resellers_text__title' => "بائعو التجزئة",
    'ui__mass-mail#to_domainusers_text__title' => "مسؤولو المجال",
    'ui__mass-email#tools_legend__title' => "أدوات",
    'ui__mass-email#list_legend__title' => 'قوالب رسائل البريد الإلكتروني الجماعية',
    'ui__mass-email#template_legend__title' => "قالب",
    'ui__mass-email#from_email_text__title' => "من",
    'ui__mass-email#to_text__title' => 'إلى',
    'ui__mass-email#to_resellers_text__title' => "بائعو التجزئة",
    'ui__mass-email#to_clients_text__title' => "العملاء",
    'ui__mass-email#to_domainusers_text__title' => "مسؤولو المجال",
    'ui__mass-email#to_admin_text__title' => "مسؤول Plesk",
    'ui__mass-email#option_mode_all__title' => "الكل",
    'ui__mass-email#option_mode_select__title' => "المحدد فقط",
    'ui__mass-email#option_mode_except__title' => "الكل باستثناء المُحدد",
    'ui__mass-email#option_select_template__title' => '---حدد قالبًا---',
    'ui__mass-email#subject_text__title' => "الموضوع",
    'ui__mass-email#body_text__title' => "نص الرسالة",
    'ui__mass-email#save_as_legend__title' => "الحفظ كقالب",
    'ui__mass-email#save_as_text__title' => "حفظ الرسالة المنشأة إلى قالب جديد باسم",
    'ui__reseller/preferences_unknown__wizard-title' => "تغيير إعدادات حساب",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "حدد بائع التجزئة الذي ترغب في تغيير إعدادات حسابه ثم انقر فوق التالي.",
    'ui__reseller/preferences_unknown__wizard__2' => "حدد إعدادات الحساب وانقر فوق \"موافق\".",
    'ippoolManager__ip_shared' => "مشترك",
    'ippoolManager__ip_exclusive' => "مخصص",

    '__users_list' => "المستخدمين",
    '__users' => "المستخدمين",
    '__user_name' => "اسم المستخدم",

    'clientOwnerChanger__wrong_owner_type' => "يمكنك تحويل حسابات العميل المحدد لحساب بائع تجزئة فقط.",
    'clientOwnerChanger__wrong_client_type' => 'حساب المستخدم المحدد هو حساب بائع تجزئة. يتعذر تعيين حسابات بائع التجزئة لمالك جديد نظرًا لأن مسؤول الخادم يمتلكها.',
    'ui__client/chowner_multi__description' => "نقل حسابات المستخدم إلى مالك آخر.",
    'client_chown__clients_list_legend' => "حسابات المستخدم",
    'client_chown__client_name' => "اسم المستخدم",
    'client_chown__old_owner' => "المالك السابق",
    'client_chown__limits_legend' => "الموارد",
    'client_chown__limit_name' => "اسم المورد",
    'client_chown__limit_value' => "الموارد المخصصة",
    'client_chown__usage_before' => "قبل التحويل",
    'client_chown_usage_after' => "بعد التحويل",
    'limit__name_max_dom_aliases' => "الأسماء المستعارة للمجالات",
    'limit__name_max_subftp_users' => "حسابات FTP الإضافية",
    'limit__name_max_mssql_db' => "قواعد بيانات Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "تجمعات تطبيق IIS",
    'limit__name_max_odbc' => "اتصالات ODBC",
    'total_mboxes_quota_unsupported' => 'لا يدعم خادم البريد الإلكتروني ذلك',
    'limit_soft__disk_space' => 'الإشعار بمجرد ملء مساحة القرص',
    'limit_soft__max_traffic' => 'الإشعار بمجرد الوصول حركة مرور البيانات',
    'dsr__of_reseller_title' => "استخدام المورد من قِبل المجالات",
    'client_chown__new_owner' => 'مالك جديد',
    'ui__reseller/to-client__has_clients_warning' => 'لا يمكن تحويل بعض حسابات بائع التجزئة المحددة لحسابات عميل لوجود عملاء مشتركين في خدماتهم. يُرجى إزالة حسابات العملاء الذين اشتركوا لدى بائع التجزئة أو نقلها إلى بائع تجزئة آخر.',
    'limitsManager__commit_failed' => "تعذر تغيير حدود المورد.",
    'limitsManager__date_in_past' => "تاريخ انتهاء الصلاحية غير صحيح 1%.",
    'limitsManager__limit_not_supported' => "لا يمكن تعيين الحدود لنوع المورد 1%.",
    'limitsManager__limit_oversell_inconsistency' => "تعذر تخصيص المقادير المحددة للموارد التي تم إيقاف زيادة المبيعات فيها.",
    'limitsManager__limit_overuse_inconsistency' => "تجاوز استخدام المورد الحدود المحددة.",
    'limitsManager__no_resource_available' => "لا توجد موارد متوفرة متبقية من هذا النوع (%%limitName%%). تم طلب: %%quantity%% متوفر: %%unused%%.",
    'limitsManager__no_total_resource_available' => "لا تتوفر أي موارد لهذا النوع (%%limitName%%) من موفر الخدمة لديك. تم طلب: %%quantity%% متوفر: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "يجب أن يكون تاريخ انتهاء الصلاحية أقل من أو يساوي 1%.",
    'limitsManager__invalid_disk_space_limit' => "يجب أن تكون مساحة القرص أقل من أو تساوي 1%.",
    'limitsManager__invalid_max_traffic_limit' => "يجب أن يكون مقدار حركة مرور البيانات أقل من أو يساوي 1%.",
    'ippoolManager__ip_has_suballocations' => "لا يمكن تغيير نوع عنوان IP المحدد مسبقًا للمستخدم. عنوان %%IP %%ip تم تعيينه مسبقًا لمستخدم (لمستخدمين) كعنوان % IP %%reserved",
    'ippoolManager__ip_is_already_in_pool' => "عنوان IP هذا تم تعيينه بالفعل للمستخدم.",
    'ippoolManager__ip_is_not_in_pool' => "لا يوجد عنوان %%IP %%ip في المجموعة.",
    'ippoolManager__can_not_allocate_ip' => "عنوان %%IP %%ip لا يتوفر إلا كـ %%available%%..",
    'ippoolManager__unable_to_set_default_type' => "لا يمكن تعيين عنوان %%IP %%ip باعتباره مخصصًا.",
    'ippoolManager__ip_used_by_hst_or_frw' => "عنوان %%IP %%ip مستخدم بالفعل للاستضافة.",
    'ippoolManager__active_anon_ftp_on_ip' => "تم بالفعل تشغيل وصول FTP المجهول إلى عنوان %%IP %%ip",
    'ippoolManager__no_vacant_ips' => "لا توجد عناوين IP فارغة.",
    'ippoolManager__no_available_ips' => "لا توجد عناوين IP متوفرة.",
    'templates__dublicate_name' => "يوجد بالفعل قالب بهذا الاسم. يُرجى اختيار اسم آخر لهذا القالب.",
    'cl_perm__client_limits_exceeded' => "تتجاوز قيم حد المورد المحددة القيم التي تسمح بها خطة الاستضافة خاصتك، أو أن هذه القيم توفر موارد أقل من التي تستخدمها مواقعك حاليًا.",
    'cl_perm__reseller_limits_exceeded' => "تتجاوز قيم حد المورد المحددة القيم التي تسمح بها خطة استضافتك أو أن هذه القيم توفر موارد أقل من الموارد التي تستخدمها المواقع والحسابات حاليًا.",

    'site_apps__preferences_show_all_versions_title' => "عرض قائمة كاملة من الإصدارات لكل تطبيق تم استرداده من الكتالوج",
    'site_apps__preferences_show_all_versions_hint' => "عند تحديد هذا الخيار، قد يستغرق الأمر وقتًا طويلاً لاسترداد جميع النسخ لكل تطبيق في كل مرة تفتح الكتالوج. إذا لم يتم تحديد هذا الخيار، فلن يتم عرض سوى الإصدارات الحديثة فقط.",
    '__select_user_template' => "إنشاء حساب مستخدم باستخدام قالب",
    'ip_already_added_to_all_clients' => "عنوان IP المحدد تم تعيينه بالفعل لكل المستخدمين.",
    'ui__server/ip-address/client/delete#legend__description' => "ستتم إزالة عناوين IP التالية من تجمع عناوين IP للمستخدمين والنظام:",

    'site_apps__cancelled_apps' => "لقد ألغيت إضافة التطبيقات التالية: %2",

    'sb_url_is_not_resolved' => 'تعذّر حل URL: تحقق من إعدادات DNS لديك. يجب أن ينحل URL %1 إلى عنوان IP الخادم مع Presence Builder المثبّت.',

    'ip_addr__is_last_on_interface' => 'لا يمكن إزالة عنوان %%IP %%ip لأنه آخر عنوان IP موجود على واجهة المستخدم للشبكة.',
    'ip_addr__used_for_current_session' => 'لا يمكن إزالة عنوان %%IP %%ip لأنه مستخدم من قبل جلسة نشطة.',
    'ip_addr__used_for_hosting' => 'لا يمكن إزالة عنوان %%IP %%ip لأنه مستخدم لاستضافة موقع ويب.',
    'ip_addr__is_main' => 'لا يمكن إزالة عنوان %%IP %%ip لأنه عنوان IP الرئيسي لواجهة المستخدم للشبكة.',
    'ip_addr__ip_used_by_message_submission' => 'لا يمكن إزالة عنوان %%IP %%ip لأنه مستخدم لإرسال رسائل البريد',

    // RESELLER ACTION LOG

    '__cl_domains' => 'مجالات العملاء',
    'excl_ip_num' => 'عنوان IP مخصص',

    'sb_err_sitebuilder_not_installed' => 'لم يتم تثبيت Presence Builder.',

    '__perm_allow_oversell_can_not_be_revoked' => 'لا يمكن سحب الإذن اللازم للسماح بالبيع الزائد من المستخدم لأنه تم تخصيصه بالفعل لعدد من الموارد أكثر من المتاح، سيتم التبديل إلى وضع البيع الزائد.',
    'limitsManager__invalid_limit_value' => 'قيمة %%value%% المحددة للحد %%limit_name%% غير صحيحة.',
    'ip_alias__type' => "عنوان IP موزّع كـ",
    'ip_alias__in_type' => 'عنوان IP مخصص كـ',
    'ui__client/ipaddress/delete_multi__title' => 'إزالة عناوين IP',
    'ui__client/ipaddress/delete#legend__short-title' => 'العناصر التي ستتم إزالتها',
    'ui__client/ipaddress/delete#legend__description' => "ستتم إزالة عناوين IP التالية من تجمع عناوين IP للمستخدم:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'العناصر التي لا يمكن إزالتها',
    'ui__client/ipaddress/delete#nlegend__description' => 'لا يمكن إزالة عناوين IP التالية:',
    'ui__server/ip-address/delete#legend__description' => 'ستتم إزالة عناوين IP التالية من تجمع عناوين IP للخادم:',
    'confirmationForm_default_agreement_text' => 'تأكيد العملية',
    'confirmationForm_default_confirm_message' => 'يرجى تأكيد العملية.',
    'limit__max_mn' => 'أقصى عدد لحسابات البريد',

    'limits__client_overuse_description' => 'تبلغ سياسة الاستخدام الزائد Plesk بما عليه القيام به عندما يتجاوز استخدام المورد مقدار المورد المعين بشكل أولي.',
    'limits__client_overuse_block_true_description' => 'حظر الاستخدام الزائد للموارد. لا يمكن أن يتجاوز الاستخدام الفعلي للمورد مقدار المورد المعين بشكل أولي',
    'limits__client_overuse_block_false_description' => 'لا تحظر الاستخدام الزائد للموارد، واسمح للعميل باستخدام موارد أكثر من المقدمة بشكل أولي. يمكن أن يتجاوز الاستخدام الفعلي للمورد مقدار المورد المعين بشكل أولي',
    'limits__client_overuse_notify_text' => 'إشعار العميل بوصوله إلى حدود المورد.',

    'limits__domain_overuse_description' => 'تبلغ سياسة الاستخدام الزائد Plesk بما عليه القيام به عندما يتجاوز استخدام المورد مقدار المورد المعين بشكل أولي.',
    'limits__domain_overuse_block_true_description' => 'تبلغ سياسة الاستخدام الزائد Plesk بما يجب فعله عند زيادة استخدام الموارد.',
    'limits__domain_overuse_block_false_description' => 'لا تحظر الاستخدام الزائد للموارد، واسمح للمجال باستخدام موارد أكثر من المقدمة بشكل أولي. يمكن أن يتجاوز الاستخدام الفعلي للمورد مقدار المورد المعين بشكل أولي',
    'limits__domain_overuse_notify_text' => 'إشعار مالك المجال بوصوله إلى حدود المورد.',


    'cancel_remove' => 'تجاهل أي تغييرات والعودة إلى الصفحة السابقة.',
    'php_not_installed' => 'لم يتم تثبيت PHP',

    'dns__dns_rr_delete' => 'العناصر التي ستتم إزالتها',
    'dns__delete_rr' => 'ستتم إزالة سجلات DNS التالية من منطقة DNS:',
    'dns__dns_rr_delete_non_removable' => 'العناصر التي لا يمكن إزالتها',
    'dns__non_delete_rr' => 'لا يمكن إزالة سجلات DNS التالية:',
    'dns__dns_rr_delete_confirm_message' => 'تأكيد إزالة سجلات DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'تنسيق تطبيق الويب غير معروف: قد لا يتوفر تطبيق الويب لتثبيته أو استخدامه.',

    '__php_handler_type_desc' => 'تشغيل PHP كـ',
    'sfdk_domain_sign__failed' => 'حدث خطأ غير معروف عند محاولة تسجيل الدخول بالبريد مع استخدام آلية الحماية DKIM في المجال. يرجى الرجوع إلى سجل أخطاء الخادم للحصول على مزيد من المعلومات.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'إعلام نجاح تحديث مفتاح Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'إعلام تأجيل تحديث مفتاح Plesk',
    'pkey_notify__subj_update_error_notification' => 'إعلام خطأ تحديث مفتاح Plesk',
    'pkey_notify__update_successful' => 'اكتمل تحديث 1% بنجاح.',
    'pkey_notify__update_failed_no_more_try' => 'تعذر تحديث 1%. المفتاح الذي تحاول إرساله غير صالح. يجب ألا تحاول تحديث هذا المفتاح بعد ذلك.',
    'pkey_notify__update_failed_try_later' => 'تعذر تحديث %1: حدث خطأ أثناء معالجة مفتاحك. يمكنك محاولة استرداد المفتاح يدويًا في منصة Plesk عبر (الأدوات والإعدادات > معلومات الترخيص) أو اترك منصة Plesk تحاول تحديثه في الـ 24 ساعة القادمة. إذا لم ترغب في تلقي هذا الإشعار مرة أخرى، فأزل هذا المفتاح من منصة Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'تعذر إيقاف تشغيل عوامل تصفية البريد العشوائي على مستوى الخادم.',
    'ui__server/spam-filter/toggle__unable_enable' => 'تعذر تشغيل عوامل تصفية البريد العشوائي على مستوى الخادم.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'بائع التجزئة هذا',
    'report_auto__select_reseller_report_all' => 'جميع بائعي التجزئة',
    'report_auto__select_reseller_report_client' => 'جميع بائعي التجزئة لهذا العميل',
    'report_auto__select_reseller_report_current' => 'بائع التجزئة هذا',
    'report_auto__select_reseller_report_reseller' => '1%',
    'report_auto__select_client_report_reseller' => 'جميع عملاء بائع التجزئة هذا',
    'report_auto__select_client_report_client' => 'هذا العميل',
    'report_auto__select_client_report_other_reseller' => '1%',
    'report_auto__select_admin_report_all' => 'بائعو التجزئة، والعملاء والمجالات',

    'rpt_reseller_section_full_domains' => 'المجالات',
    'rpt_reseller_dom_subdomains' => 'المجال الفرعي',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'علب البريد',
    'rpt_reseller_dom_redirects' => 'أدوات التوجيه',
    'rpt_reseller_dom_mail_groups' => 'المجموعات البريدية',
    'rpt_reseller_dom_mail_resps' => 'مسؤول المنطقة',
    'rpt_reseller_dom_mail_antispam' => 'مكافحة البريد العشوائي',
    'rpt_reseller_dom_mail_antivirus' => 'برنامج مكافحة الفيروسات',
    'rpt_reseller_dom_mail_lists' => 'القوائم البريدية',
    'rpt_reseller_dom_web_users' => 'مستخدمو الويب',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'العملاء',
    '__cl_name' => 'اسم العميل',
    '__cl_creation_date' => 'تاريخ الإنشاء',
    '__clients_traffic' => 'حركة مرور البيانات من العملاء',
    'rpt_reseller_cl_mail_antispam' => 'مكافحة البريد العشوائي',
    'rpt_reseller_cl_mail_antivirus' => 'برنامج مكافحة الفيروسات',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'لم يتم تثبيت Presence Builder.',
    'sitebuilder_disabled' => 'تم إيقاف تشغيل Presence Builder.',
    'b_sitebuilder_disabled' => 'تم إيقاف تشغيل Presence Builder.',
    'webmail_not_installed' => 'برنامج بريد الويب غير مُثبّت.',
    'webmail_disabled' => 'تم إيقاف خدمة بريد الويب.',
    'spamassassin_not_installed' => 'لم يتم تثبيت SpamAssassin.',
    // pfu:
    'anonymous_ftp_shared' => 'يتعذر تثبيت FTP مجهول: نوع عنوان IP مشترك.',
    'anonymous_ftp_used' => 'يتعذر تثبيت FTP مجهول: عنوان IP مستخدم من قِبل مجال آخر لخدمة FTP مجهولة.',
    'sshterm__not_installed' => 'لم يتم تثبيت طرف SSH.',
    'sshterm__empty_shell' => 'لاستخدام العميل الطرفي، يجب أن تسمح بوصول الوعاء إلى هذا المجال.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET غير مُثبّت.',
    'site_builder_no_package' => 'لا يتوفر Presence Builder. يُرجى التأكد من أن Presence Builder مثبّت وتم تحديده كمكوّن نشط.',
    'site_builder_not_configured' => 'لم يتم تكوين Presence Builder.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'أدوات',
    'ui__reseller/client#clientslist__title' => 'العملاء',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "إعداد مصادر بيانات ODBC لموقع الويب",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "حدد موقع الويب الذي ترغب في إعداد مصادر بيانات ODBC لتطبيقاته.",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "إدارة الأدلة الظاهرية على المجال",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "حدد المجال الذي ترغب في إدارة الأدلة الظاهرية عليه.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'إدارة الأدلة الظاهرية ضمن موقع الويب',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "حدد موقع الويب الذي ترغب في إدارة الأدلة عليه.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "إعداد حماية الارتباط السريع للمجال",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "حدد المجال الذي ترغب في حفظ الملفات الموجودة عليه من الارتباط السريع",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "تكوين إعدادات PHP للمجال",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "حدد المجال الذي ترغب في تكوين إعدادات PHP به.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'إعداد FTP المجهول على المجال',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'حدد المجال الذي تريد إعداد FTP مجهول له.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'إدارة الأدلة المحمية بكلمة مرور على المجال',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في إدارة الأدلة المحمية بكلمة مرور به.',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => 'عرض إحصائيات الويب للمجال',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في عرض إحصائيات الويب له.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'إعداد مدير السجلات للمجال وعرض ملفات سجل المجال',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في إعداد مدير السجلات عليه والذي ترغب في عرض ملفات سجلاته.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'إدارة شهادات SSL/TLS للنطاق',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'حدد النطاق الخاص بشهادات SSL/TLS التي تريد إدارتها.',

    'ui__client/to-reseller_multi__wizard-title' => 'تحويل حسابات العميل إلى حسابات بائع تجزئة',
    'ui__client/to-reseller_multi__wizard__1_multi' => 'حدد حسابات العميل الذي ترغب في تحويل حساباته إلى حسابات بائع التجزئة.',

    'ui__reseller/to-client_multi__wizard-title' => 'تحويل حسابات بائعي التجزئة إلى حسابات العملاء',
    'ui__reseller/to-client_multi__wizard__1_multi' => 'حدد حسابات بائع التجزئة الذي ترغب في تحويل حساباته إلى حسابات عميل.',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => 'حدد إعدادات الاستضافة للمجال.',







    'ui__client/domain/disable_multi__wizard-title' => 'تعليق المجالات',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'حدد المجالات التي ترغب في تعليقها.',

    'ui__client/domain/enable_multi__wizard-title' => 'تنشيط المجالات',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'حدد المجالات التي ترغب في تنشيطها.',

    'ui__client/domain_unknown__wizard-title' => 'عرض المجالات',
    'ui__client/domain_unknown__wizard__1_unknown' => 'حدد العميل الذي ترغب في عرض مجالاته.',

    'ui__client/domain/to-client_multi__wizard-title' => 'تحويل حسابات مسؤول المجال إلى حسابات العميل',
    'ui__client/domain/to-client_multi__wizard__2_multi' => 'حدد المجالات التي ترغب في تحويل حسابات المسؤولين فيها إلى حسابات عملاء',

    'ui__client/domain/register_unknown__wizard-title' => 'تسجيل المجالات',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في تسجيله.',

    'ui__client/domain/extras_unknown__wizard-title' => 'استخدم "أدوات" من MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في إدارته باستخدام الأدوات من MyPlesk.com.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'الوصول إلى الخادم عبر SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في الاتصال بالمضيف الظاهري عليه عبر SSH.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'مستخدمو عناوين IP',
    'ui__server/ip-address/client_unknown__title' => 'مستخدمو عناوين IP',
    'ui__server/ip-address/client_unknown__description' => 'مستخدمو عنوان IP 1%',

    'disabled_by_admin' => 'تم تعطيلها من قِبل مسؤول الخادم',






    'ui__client/domain/chowner_multi__short-title' => 'تغيير الملكية',
    'ui__client/domain/chowner_multi__title' => 'تغيير ملكية الاشتراك',
    'ui__client/domain/chowner_multi__description' => 'تغيير ملكية الاشتراك.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'حدد المجالات التي ترغب في تغيير ملكيتها ثم انقر فوق التالي>>.',
    'ui__client/domain/chowner_unknown__short-title' => 'تغيير الملكية',
    'ui__client/domain/chowner_unknown__title' => 'تغيير ملكية الاشتراك',
    'ui__client/domain/chowner_unknown__description' => 'تغيير ملكية الاشتراك.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'تغيير ملكية الاشتراك',


    'ui__client/chowner__short-title' => 'تغيير مالك العميل',
    'ui__client/chowner__title' => 'تغيير مالك حساب العميل',
    'ui__client/chowner__description' => 'تعيين مالك جديد لحساب العميل هذا',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'لا توجد أزرار مخصصة.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'لا توجد أزرار مخصصة في واجهة بائع التجزئة 1%.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'إزالة الزر 1%',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'إزالة',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'إزالة الزر 1%',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'إزالة أزرار مخصصة من واجهة بائع التجزئة',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'إزالة',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'إزالة أزرار مخصصة',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'إزالة أزرار',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'حدد بائع التجزئة الذي ترغب في إزالة أزراره المخصصة ثم انقر فوق التالي>>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'حدد الأزرار التي ترغب في إزالتها ثم انقر فوق التالي>>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'أكّد إزالة الأزرار عبر تحديد مربع الاختيار على هذه الشاشة، ثم انقر فوق "إنهاء".',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'إزالة زر مخصص من واجهة بائع التجزئة.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'إزالة',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'إزالة أحد الأزرار المخصصة',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'إزالة زر مخصص',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'حدد بائع التجزئة الذي ترغب في إزالة الزر المخصص من عنده ثم انقر فوق التالي>>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'حدد زرًّا مخصصًا ترغب في إزالته ثم انقر فوق التالي>>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'أكّد إزالة الزر المخصص عبر تحديد مربع الاختيار على هذه الشاشة، ثم انقر فوق "إنهاء".',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'تعديل خصائص الزر المخصص لمستوى بائع التجزئة 1%.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'الإعدادات',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'تعديل زر مخصص لبائع التجزئة 1%',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'إضافة زر مخصص',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'حدد بائع تجزئة ترغب في إنشاء أحد الأزرار المخصصة في الواجهة الخاصة به ثم انقر فوق التالي>>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'انقر فوق "إنهاء" لإنشاء الزر.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'تغيير خصائص زر في واجهة بائع التجزئة.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'الخصائص',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'تغيير خصائص زر في واجهة بائع التجزئة',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'تغيير خصائص زر مخصص',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'حدد بائع التجزئة الذي ترغب في تعديل الزر المخصص لديه ثم انقر فوق التالي>>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'حدد زرًّا مخصصًا ترغب في تعديله ثم انقر فوق التالي>>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'عند الانتهاء من تعديل خصائص الزر، انقر فوق "إنهاء" لتطبيق التغييرات والخروج من المعالج.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'اجعل الزر 1% غير متوفر لعملائك.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'اجعله غير متوفر لعملائك',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'اجعل الزر 1% غير متوفر لعملائك',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'اجعل الزر 1% مرئيًا لعملاء بائع التجزئة.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'اجعله متوفرًا لعملائك',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'اجعل الزر 1% مرئيًا لعملاء بائع التجزئة',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'اجعل زرًا مخصصًا متوفرًا/ غير متوفر لعملائك.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'متوفر/ غير متوفر لعملائك',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'اجعل زرًا مخصصًا متوفرًا أو غير متوفر لعملائك',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'اجعل زرًا مخصصًا متوفرًا/ غير متوفر لعملائك.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'حدد بائع التجزئة الذي ترغب في جعل زر مخصص لديه متوفرًا لعملاء بائع التجزئة ثم انقر فوق التالي>>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'حدد زرًا مخصصًا ترغب في جعله متوفرًا أو غير متوفر لعملائك ثم انقر فوق التالي>>.',




    'ui__server/ip-addresses__short-title' => 'عناوين IP',
    'ui__server/ip-addresses__title' => 'إدارة عناوين IP',
    'ui__server/ip-addresses__description' => 'إضافة عناوين IP وحذفها وتعيينها.',

    'ip_ctrl__allow_ftps' => 'السماح بـ FTP عبر SSL/TLS',
    '__ftps' => 'FTP عبر SSL/TLS',
    '__not_allowed' => 'غير مسموح',



    'ui__client/ipaddress/domain_unknown__short-title' => 'المجالات التي تستخدم 2%',
    'ui__client/ipaddress/domain_unknown__title' => 'المجالات التي تستخدم 1% عنوان IP %2',
    'ui__client/ipaddress/domain_unknown__description' => 'عرض قائمة بالنطاقات التي تستخدم %1 عنوان IP %2',

    'ui__client/ipaddress__none-available' => 'لا تتوفر عناوين IP',
    'ui__client/ipaddress__none-available__1' => 'لا تتوفر عناوين IP',



    'ui__client/domain/report_unknown__wizard-title' => 'عرض تقرير المجال',
    'ui__client/domain/report_unknown__wizard__2_unknown' => 'حدد المجال الذي ترغب في عرض تقريره.',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'حدد مالكًا جديدًا للمجال.',

    'ui__client/chowner__wizard__2_select' => 'تحديد مالك جديد لحساب العميل.',

    '__ip_addr_state_unknown' => "عنوان IP غير جاهز للعمل الآن لأن النظام سيعالج طلبك. يرجى الانتظار لدقيقة واحدة.",


    'resellers_list__accounts' => 'المستخدمين',

    'ip_addr__repair_is_not_allowed' => 'لا يمكن إصلاح عناوين IP ضمن بيئة Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'لا يمتلك بائع التجزئة 1% أي عملاء.',

    'ippoolManager__ip_used_by_nohost_domain' => "لا يمكن إزالة عنوان IP %%ip%% نظرًا لاستخدامه بواسطة نطاق واحد أو أكثر دون استضافة.",
    'ippoolManager__ip_used_for_mail_service' => "لا يمكن إزالة عنوان IP %%ip%% نظرًا لاستخدامه من قبل نطاق واحد أو أكثر لعنوان IP الخاص بخدمة البريد الخاصة بهم.",
    'ippoolManager__ip_used_for_send_emails' => "لا يمكن إزالة عنوان IP %%ip%% نظرًا لاستخدامه لإرسال رسائل بريد إلكتروني من عنوان IP محدد (راجع إعدادات خادم البريد).",
    'ippoolManager__ip_used_in_dns_zone' => 'لا يمكن إزالة عنوان %%IP %%ip لأنه مستخدم من منطقة DNS المخصصة لمجال واحد أو أكثر.',
    'ip_ctrl__cannot_manage_on_vz' => 'يعمل تثبيت Plesk هذا ضمن حاويات Virtuozzo. لا يمكن إضافة عناوين IP جديدة إلا عبر مسؤول عقدة حاويات Virtuozzo.',

    'client_template__limits_auto_adjusted' => 'تم تعديل الحدود من قالب العميل تلقائيًا.',

    '__entries' => 'المدخلات',

    '__path_is_not_set' => 'المسار غير محدد. يرجى تحديد مسار صالح.',

    'defaultcomponents__imap_required' => '(لا يدعم خادم البريد الحالي IMAP)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'تم تشغيل حماية الارتباط السريع لهذا المجال.',
    'i_hotlinkprotection_off' => 'تم إيقاف تشغيل حماية الارتباط السريع لهذا المجال.',

    '__commercial_web_stats_not_installed' => 'لا تدعم Plesk سوى البرنامج التجاري لإحصائيات الويب لحساب إحصائيات المجال الفرعي. لا يوجد برنامج كهذا مثبّت على النظام.',

    'mail__spamassassin_personal_settings_disallowed' => 'أوقف مسؤول الخادم تشغيل إمكانية تطبيق الإعدادات الشخصية لعوامل تصفية البريد العشوائي. لن يتم تطبيق إعدادات تصفية البريد العشوائي التالية',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => 'يتعذر إنشاء كائن 1%: %2',
    'cu_dom_pref__invalid_expiration_date' => 'تاريخ انتهاء الصلاحية غير صالح: 1%',
    'cu_cl_pref__illegal_date_val' => 'لقد حددت قيمة تاريخ غير قانونية ("1%")',
    'cu_cl_pref__illegal_date_greater_less' => 'أدخل العام من "1%" إلى "2%"',
    'cu_initconf__unable_set_ip_alias_type' => 'يتعذر تعيين نوع اسم IP المستعار: 1%',
    'cu_mlist__unable_change_status' => "يتعذر تغيير حالة قائمة المراسلة: 1%",
    'cu_initconf__unable_change_passwd' => "يتعذر تغيير كلمة مرور المسؤول: 1%",
    'cu_serverpref__option_description_include_remote_databases' => 'إدراج قواعد بيانات MySQL البعيدة في حساب استخدام مساحة القرص.',
    'cu_siteapp_item__add_to_pool_success' => 'تمت إضافة تطبيق الويب إلى تجمع تطبيق الويب.',
    'cu_siteapp_item__remove_from_pool_success' => 'تمت إزالة تطبيق الويب من تجمع تطبيق الويب.',
    'cu_traffic_command_description_add_user' => 'يسجل مقدار معين من نسبة استخدام الشبكة كما لو تم استخدامها بالفعل من قِبل العميل / بائع التجزئة',
    'cu_traffic_command_description_sub_user' => 'يطرح مقدارًا معينًا من نسبة استخدام الشبكة من المقدار المسجل للعميل / لبائع التجزئة',
    'cu_traffic_command_description_add_batch_user' => 'يسجل مقدارًا معينًا من نسبة استخدام الشبكة كما لو تم استخدامها بالفعل من قِبل العميل / بائع التجزئة (وضع الدفعة)',
    'cu_traffic_command_description_del_user' => 'يعيد تعيين مقدار نسبة استخدام الشبكة المسجل لهذا العميل / بائع التجزئة إلى صفر',
    'cu_resellerpref__option_lock_screen' => 'لمنع المستخدمين من العمل على Plesk حتى يكتمل تحميل شاشات الواجهة',

    'server_settings_invalid_traffic_statistics' => 'Invalid retain traffic statistics parameter.',
    'server_settings_invalid_logrotate_period' => 'Invalid log rotation period parameter.',
];