<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx: "502 Bad Gateway: upstream sent too big header while reading response header" (502 – ungültiges Gateway: Upstream hat beim Lesen des Antwort-Headers einen zu großen Header gesendet)',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'In Kürze bereit.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache: "500 Internal Server Error: Option FollowSymLinks not allowed here" (500 – interner Serverfehler: Option FollowSymLinks ist hier nicht zulässig)',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'In Kürze bereit.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM: "server reached max_children setting" (Server hat den Grenzwert für die Einstellung max_children erreicht)',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptome</h4><ul><li><p>Bei Websites, bei denen unter <strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-Einstellungen</strong> als PHP-Handler <strong>Von Apache bereitgestellte FPM-Anwendung</strong> oder <strong>Von Nginx bereitgestellte FPM-Anwendung</strong> festgelegt ist, tritt eines der folgenden Probleme auf:</p><ul><li><p>Wird langsam geladen</p></li><li><p>Ist nicht verfügbar (dauerhaft oder in regelmäßigen Abständen) mit einem 50x-Fehler in einem Webbrowser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Die folgende Fehlermeldung ist im PHP-FPM-Fehlerprotokoll <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> zu finden (hier steht<em>XX</em> für die auf den Websites verwendete PHP-Version):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>Die Nachricht oben wird in der Regel von diesem Fehler begleitet:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Wenn Nginx auf dem Server aktiviert ist, kann eine der folgenden Fehlermeldungen im Fehlerprotokoll der Domain <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code> zu finden sein:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Der PHP-FPM-Grenzwert <code>pm.max_children</code> wurde von den Websites erreicht.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Grenzwert für pm.max_children erhöhen',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Erhöhen Sie den Grenzwert <code>pm.max_children</code> für die betroffenen Domains:</p><ol><li><p>Stellen Sie über <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a> eine Verbindung zum Plesk Server her.</p></li><li><p>Suchen Sie die betroffenen Domains. Verwenden Sie dazu den folgenden Befehl:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Hinweis:</strong> Die Nummer links gibt Aufschluss darüber, wie oft der Grenzwert <code>pm.max_children</code> von der Website erreicht wurde.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Melden Sie sich in Plesk an</a>.</p></li><li><p>Gehen Sie zu <strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-Einstellungen </strong> &gt; <strong>PHP-FPM-Einstellungen</strong>.</p></li><li><p>Erhöhen Sie den Wert für die Domain unter <code>pm.max_children</code> und wenden Sie die Änderungen an. Wiederholen Sie diesen Schritt für alle in Schritt 2 genannten Domains.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx: "Too many open files" (Zu viele Dateien geöffnet)',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Nginx kann nicht auf einem Plesk Server gestartet oder neu geladen werden, weil zu viele Dateien geöffnet sind </p><h4>Symptome</h4><ul><li><p>Der Nginx-Dienst kann nicht gestartet oder neu geladen werden und die folgende Fehlermeldung wird in der Datei <code>/var/log/nginx/error.log</code> ausgegeben:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Auf einige oder alle Websites kann nicht zugegriffen werden </p></li><li><p>Eine Warnmeldung wird unter <strong>Tools &amp; Einstellungen &gt; Diagnose &amp; Reparatur angezeigt</strong>:</p><pre style="white-space: pre-wrap;">Checking for nginx ULIMIT value N domains have been found on server. Problem with nginx default limit for open files is possible</pre></li><li><p>NodeJS- und Ruby-Webanwendungen zeigen bei einigen Aufgaben in Plesk (z. B. Domains oder Abonnements erstellen oder Apache oder Nginx anpassen) den Fehler "502 Bad Gateway":</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>Nachdem Sie <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">ein neues Zertifikat für die Domain installiert haben</a>, ist das bisherige Zertifikat noch im Webbrowser sichtbar, aber das korrekte Zertifikat ist unter <strong>Domains &gt; example.com &gt; Hosting-Einstellungen </strong> ausgewählt.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Der virtuelle Host von Nginx öffnet 4 Protokolldateien für jeden virtuellen Host mit physikalischem Hosting:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p> Dies hat zur Folge, dass der Nginx-Server im Fall von sehr vielen Domains (in der Regel mehr als 100) die maximale Anzahl geöffneter Dateien überschreitet.</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Grenzwert für geöffnete Dateien erhöhen',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Achtung:</strong> Wenn Sie das Dienstprogramm <code>websrv_ulimits</code> ohne die Option <strong>--no-restart</strong> ausführen, werden die Webkonfigurationsdateien für alle Domains neu erstellt. Dies kann bei einer großen Anzahl von gehosteten Websites zu erheblichen Ausfallzeiten führen.<br><br>Führen Sie den Befehl während der Wartung aus.</div><p>Es wird empfohlen, den Grenzwert für geöffnete Dateien auf einen Wert zu setzen, der mindestens dem hier entspricht: <strong>Anzahl der Domains in Plesk x 16</strong>. Im folgenden Beispiel sehen Sie, wie der Grenzwert auf 4096 gesetzt wird:</p><ol><li><p> Stellen Sie über <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a> eine Verbindung zum Server her.</p></li><li><p>Setzen Sie den Grenzwert für geöffnete Dateien für Apache und Nginx auf 4096:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Um die Änderungen anzuwenden, starten Sie Apache und Nginx erneut unter <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Tools &amp; Einstellungen &gt; Service-Verwaltung</strong>.</p></li><li><p>Nachdem die Webdienste neu gestartet wurden, überprüfen Sie, ob der Grenzwert "Max open files" angewendet wurde:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Falls Sie das Problem nicht mit den Schritten oben lösen konnten, legen Sie den Grenzwert über das Dienstprogramm <code>ulimit</code> fest:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity: "Response body too large" (Antworttext zu lang)',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'In Kürze bereit.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity: "Access denied with code 403" (Zugriffsfehler mit dem Code 403)',
    'problem-detail.modsec-access-denied.description' => '<h4>Symptome</h4><ul><li><p>ModSecurity ist unter <strong>Tools & Einstellungen > Web Application Firewall (ModSecurity) > Web Application Firewall Modus > Ein</strong>.</p></li><li>Eine in Plesk gehostete Website kann nicht geladen werden. Es ist nicht möglich, auf der Website Vorgänge wie das Verwalten von WordPress, den Zugriff auf Webmail oder den Zugriff auf die Datei <code>robots.txt</code> durchzuführen. Der Browser kann einen der folgenden Fehler anzeigen:
<pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Eine ModSecurity-Fehlermeldung wie unten erscheint in der <code>/var/log/modsec_audit.log</code> Protokolldatei oder auf der Protokollseite in Plesk (<strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>Logs</strong>): <pre>ModSecurity: Zugriff verweigert mit Code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web Application Firewall wird mit einem sehr restriktiven Regelsatz wie OWASP, Comodo oder einem benutzerdefinierten Regelsatz wie Imunify360 aktiviert. Restriktive Regelsätze können einige Vorgänge auf der Website blockieren.</p><p><Strong>Hinweis:</strong> Der ModSecurity-Fehler weist möglicherweise auf einen Angriff auf Ihren Server hin. Verwenden Sie die folgenden Lösungen nur, wenn Sie sicher sind, dass ModSecurity die gültige Nutzung Ihrer Website blockiert.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Deaktivieren Sie den festgelegten ModSecurity-Regelsatz durch ID oder Tag',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Finden Sie die ID der Regel, die die legitime Nutzung Ihrer Website blockiert. Sie finden die IDs in Fehlermeldungen in der Protokolldatei <code>/var/log/modsec_audit.log</code>. Die ID ist eine ganze Zahl in Anführungszeichen mit dem Präfix <code>id</code> in eckigen Klammern, z.B. <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">Deaktivieren Sie bestimmte Regelsätze in Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Wechseln Sie zu einem anderen ModSecurity-Regelsatz',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Wechseln Sie zu einem weniger restriktiven ModSecurity-Regelsatz, z.B. "Atomic ModSecurity Regelsatz". Gehen Sie zu <strong>Tools & Einstellungen</strong> > <strong>Web Application Firewall (ModSecurity)</strong> > <strong>Einstellungen</strong> und wählen Sie <strong>Atomic Standard</strong> , und klicken Sie dann auf <strong>OK</strong>, um die Änderungen zu übernehmen.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP: "Internal Server error 500: Allowed memory size of XXX exhausted" (Interner Serverfehler 500: Zulässige Speichergröße von XXX erreicht)',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Symptome</h4><ul><li><p>Auf eine in Plesk gehostete Website kann nicht zugegriffen werden:</p><pre>500 Internal Server Error</pre></li><li><p >Der folgende Fehler wird im Website-Protokoll angezeigt:</p><pre>Fehler "PHP message: PHP Fatal error" erhalten: Zulässige Speichergröße 4194304 Bytes wurde erschöpft (es wurde versucht, 4000032 Bytes zuzuweisen) in /var/www/vhosts/ try.me/httpdocs/somethingBig.php auf Zeile 3</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Der Website ist nicht genügend Speicher zur Verarbeitung zugewiesen.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Erhöhen Sie das memory_limit der Website',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">Lesen Sie den KB-Artikel und befolgen Sie die Anweisungen</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP: "open_basedir restriction in effect" (Einschränkung open_basedir gilt)',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Symptome</h4><ul><li><p>Auf eine Website kann durch einen der folgenden Fehler im Webbrowser nicht zugegriffen werden:</p><pre>404-Datei nicht gefunden</pre><hr><pre>500 Interner Serverfehler</pre><hr><pre>Fehler 500 move_uploaded_file(): open_basedir-Einschränkung in Kraft. Datei(/Pfad/zum/Verzeichnis) befindet sich nicht innerhalb der zulässigen Pfade: (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Die folgende Fehlermeldung wird auf der Protokollseite der Domain angezeigt (<strong>Domains</strong> > <strong>example.com</strong> > <strong>Protokolle</strong>):</p><pre><...>open_basedir-Beschränkung in Kraft. Datei (/Pfad/zum/Verzeichnis) befindet sich nicht innerhalb der zulässigen Pfade <...></pre><hr><pre>Nicht erfasste Ausnahme: Sitzung: Konfigurierter Speicherpfad „/Pfad/zum/Verzeichnis /directory" ist kein Verzeichnis, existiert nicht oder kann nicht erstellt werden.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Das PHP-Skript versucht, auf ein Verzeichnis zuzugreifen, für das der Zugriff nicht erlaubt ist. Diese Einschränkung wird durch die PHP <code>open_basedir</code>-Anweisung individuell für jede Domain definiert. Standardmäßig erlaubt <code>open_basedir</code> den Zugriff auf die Dokumentstammverzeichnisse <code>tmp</code> und der Domäne sowie den Standardsitzungspfad des Systems.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Fügen Sie den zusätzlichen Pfad zur Anweisung open_basedir hinzu',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">Lesen Sie den KB-Artikel und befolgen Sie die Anweisungen</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Deaktivieren Sie die open_basedir-Anweisung',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Gehen Sie zur Seite <strong>Domains &gt example.com &gt PHP-Einstellungen</strong> und setzen Sie die Anweisung <code>open_basedir</code> auf "Keine".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess: "403 Forbidden AH01797: client denied by server configuration" (403 – verboten AH01797: Client durch Serverkonfiguration verweigert)',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Symptome</h4><ul><li><p>Die Website zeigt einen Fehler ähnlich dem folgenden:</p><pre>Server Error 403<br>Forbidden</pre></li> <li><p>Die Protokolldatei <code>/var/www/vhosts/system/example.com/logs/error_log</code> enthält Fehler wie den folgenden:</p><pre>AH01797: Client abgelehnt nach Serverkonfiguration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Die benutzerdefinierte Apache-Konfiguration erlaubt keinen Zugriff auf die Website.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Überprüfen Sie die Serverkonfiguration und die .htaccess-Dateien',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Lesen Sie den KB-Artikel und befolgen Sie die Anweisungen</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache: "Cannot access a website directory in Plesk: 403 Forbidden" (Kein Zugriff auf ein Websiteverzeichnis in Plesk: 403 – verboten)',
    'problem-detail.apache-no-directory-index.description' => '<h4>Symptome</h4><ul><li><p>Auf einen bestimmten Ort einer Website kann nicht zugegriffen werden, z. B. <code>http://example.com/some_folder</code>. Der folgende Fehler tritt auf:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Der folgende Fehler erscheint in <code>/var/www/vhosts/example .com/logs/error_log<code/> file:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Verzeichnis /var/www/vhosts kann nicht bereitgestellt werden /example.com/httpdocs/some_folder/: Kein passender DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) gefunden und vom Server generierter Verzeichnisindex durch Optionsrichtlinie verboten</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Das angeforderte Verzeichnis enthält keine Indexdateien oder die Verzeichnissuche ist nicht aktiviert.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Fügen Sie dem Verzeichnis eine Indexdatei hinzu',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Lesen Sie den KB-Artikel und befolgen Sie die Anweisungen</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Aktivieren Sie das Durchsuchen von Verzeichnissen',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Lesen Sie den KB-Artikel und befolgen Sie die Anweisungen</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx: "Cannot access a website directory in Plesk: 403 Forbidden" (Kein Zugriff auf ein Websiteverzeichnis in Plesk: 403 – verboten)',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Symptome</h4><ul><li><p>Auf einen bestimmten Ort einer Website kann nicht zugegriffen werden, z. B. <code>http://example.com/some_folder</code>. Der folgende Fehler tritt auf:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Der folgende Fehler erscheint in <code>/var/www/vhosts/example .com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Verzeichnis /var/www/vhosts kann nicht bereitgestellt werden /example.com/httpdocs/some_folder/: Kein passender DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) gefunden und vom Server generierter Verzeichnisindex durch Optionsrichtlinie verboten</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Das angeforderte Verzeichnis enthält keine Indexdateien oder die Verzeichnissuche ist nicht aktiviert.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Fügen Sie dem Verzeichnis eine Indexdatei hinzu',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Lesen Sie den KB-Artikel und befolgen Sie die Anweisungen</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Aktivieren Sie das Durchsuchen von Verzeichnissen',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Lesen Sie den KB-Artikel und befolgen Sie die Anweisungen</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache: "server reached MaxRequestWorkers setting" (Server hat den Grenzwert MaxRequestWorkers erreicht)',
    'problem-detail.apache-reached-max-request-workers.description' => 'In Kürze bereit.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Grenzwert für PHP-Anfragentext: "client intended to send too large body" (Client beabsichtigt, einen zu großen Text zu senden)',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'In Kürze bereit.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Grenzwert für PHP-Anfragentext: "client intended to send too large body" (Client beabsichtigt, einen zu großen Text zu senden)',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'In Kürze bereit.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP-Sitzungen: "503 Internal Server Error" (503 – interner Serverfehler) oder "Failed to read session data" (Sitzungsdaten konnten nicht gelesen werden)',
    'problem-detail.php-failed-to-read-session-data.description' => 'In Kürze bereit.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess: "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable" (403 – verboten: pcfg_openfile: htaccess-Datei kann nicht überprüft werden; vergewissern Sie sich, dass sie gelesen werden kann)',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Symptome</h4><ul><li><p>Eine in Plesk gehostete Website funktioniert nicht:</p><pre>Sie haben keine Zugriffsberechtigung für / auf diesem Server. <br>Außerdem ist beim Versuch, ein ErrorDocument zur Bearbeitung der Anfrage zu verwenden, ein "403 Forbidden"-Fehler aufgetreten.</pre><p>Statt des obigen Fehlers sehen Sie auch eine leere Seite.</p></li ><li><p>Das Domänenfehlerprotokoll in <strong>Domains &gt example.com &gt Logs</strong> enthält Folgendes:</p><pre>(13)Berechtigung verweigert: [client 203.0.113.2:39024 ] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: htaccess-Datei kann nicht überprüft werden. Stellen Sie sicher, dass sie lesbar ist und "/var/www/vhosts/example.com/httpdocs/" ausführbar ist</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Falsche Berechtigungen für die Dateien oder Ordner der Domäne.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Reparieren Sie die Berechtigungen für den Inhalt der Website',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">Lesen Sie den KB-Artikel und befolgen Sie die Anweisungen</a>.</p></li></ol>',
];