<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Si votre site est hébergé sur une adresse IP dédiée (non partagée avec les autres utilisateurs ou sites), vous pouvez configurer un répertoire dans le site afin que les autres utilisateurs puissent y envoyer ou en télécharger anonymement les fichiers via FTP. Une fois que l\'option FTP anonyme sera activée, les utilisateurs pourront se connecter au répertoire à l\'aide d\'une adresse du type "ftp://ftp.your-domain.com". Pour cela, ils utiliseront le nom d\'utilisateur "anonymous" et un mot de passe.',
    'anonymous-ftp.displayLogin' => 'Afficher le message de connexion',
    'anonymous-ftp.loginText' => 'Texte du message',
    'anonymous-ftp.incomingDir' => 'Autoriser le chargement dans le répertoire incoming',
    'anonymous-ftp.incomingSubDir' => 'Autoriser la création de répertoires dans le répertoire incoming',
    'anonymous-ftp.incomingReadable' => 'Autoriser les téléchargements à partir du répertoire incoming',
    'anonymous-ftp.quota' => 'Limiter l\'espace disque du répertoire incoming',
    'anonymous-ftp.maxConnections' => 'Limiter le nombre de connexions simultanées',
    'anonymous-ftp.bandwidth' => 'Limiter la vitesse de téléchargement pour ce domaine FTP virtuel',
    'anonymous-ftp.unlimited' => 'Illimité',

    'aps.catalog.loading' => 'Chargement en cours...',
    'aps.catalog.searchName' => 'Application',
    'aps.catalog.searchVendor' => 'Vendeur',
    'aps.catalog.searchPackager' => 'Packager',
    'aps.catalog.searchLicenseType' => 'Type de licence',
    'aps.catalog.searchLicenseTypeAny' => 'Tout',
    'aps.catalog.searchLicenseTypeFreeware' => 'Gratuit',
    'aps.catalog.searchLicenseTypeCommercial' => 'Payant',
    'aps.catalog.showSearch' => 'Afficher la recherche',
    'aps.catalog.hideSearch' => 'Masquer la recherche',
    'aps.catalog.buttonSearch' => 'Rechercher',
    'aps.catalog.buttonResetSearch' => 'Réinitialiser la recherche',
    'aps.catalog.showCategories' => 'Sélectionnez une catégorie ci-dessous ou recherchez des apps à l\'aide de la recherche.',
    'aps.catalog.searchResults' => 'Résultats de la recherche',
    'aps.catalog.buttonInstall' => 'Installer',
    'aps.catalog.buttonInstallTooltip' => 'Installez la version la plus récente de l\'app avec les paramètres par défaut optimisés.',
    'aps.catalog.buttonAdvancedInstall' => 'Installer (personnaliser)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Installez la dernière version de l\'app et personnalisez tous les paramètres.',
    'aps.catalog.buttonInstallOldVersion' => 'Installer la version',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Installez la version sélectionnée de l\'app et personnalisez tous les paramètres.',
    'aps.catalog.buttonInstallDescription' => 'Installez l\'app sur un site si vous avez déjà un code d\'activation ou si vous voulez juste l\'essayer.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Installez une app. gratuite sur un site.',
    'aps.catalog.version' => 'Version',
    'aps.catalog.moreVersions' => 'Plus de versions',
    'aps.catalog.release' => 'Sortie',
    'aps.catalog.overview' => 'Présentation',
    'aps.catalog.noApplicationsInCategory' => 'Aucune application n\'est disponible dans cette catégorie. Sélectionnez une autre catégorie.',
    'aps.catalog.noCategoriesSelected' => 'Sélectionnez une catégorie pour parcourir toutes les applications disponibles dans cette catégorie.',
    'aps.catalog.noSearchResults' => 'Votre recherche ne correspond à aucune application.',
    'aps.catalog.connectionFailed' => 'Échec de la connexion au catalogue d\'applications. %%retryLink%%.',
    'aps.catalog.retry' => 'Réessayer',
    'aps.catalog.categoriesError' => 'La liste des catégories n\'a pas pu être chargée pour le moment.',
    'aps.catalog.applicationsError' => 'La liste des applications n\'a pas pu être chargée pour le moment.',
    'aps.catalog.detailsError' => 'Les détails de l\'application n\'ont pas pu être chargés pour le moment.',
    'aps.catalog.searchError' => 'Les résultats de la recherche n\'ont pas pu être chargés pour le moment.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Sortie %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Historique des changements',
    'aps.catalog.officialApplicationSite' => 'Infos du vendeur',
    'aps.catalog.returnToCategories' => '<< Retour à la liste d\'applications',
    'aps.catalog.buttonUninstall' => 'Supprimer',
    'aps.catalog.gotoHome' => 'Accueil',
    'aps.catalog.all' => 'Tout',
    'aps.catalog.buttonDetails' => 'En savoir plus',
    'aps.catalog.buttonBuy' => 'Acheter',
    'aps.catalog.buttonBuyTooltip' => 'Achetez l\'application.',
    'aps.catalog.buttonBuyDescription' => 'Visitez notre boutique pour acheter un code d\'activation pour cette application.',
    'aps.catalog.buttonDownload' => 'Télécharger',
    'aps.catalog.buttonDownloadDescription' => 'Téléchargez l\'app. si vous avez déjà un code d\'activation ou si vous voulez juste l\'essayer.',
    'aps.catalog.marketplaceMoreInfo' => 'Pour en savoir plus, visitez %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'le site Web du vendeur d\'app',

    'aps.configure.installedAt' => "Installé(e) sur",
    'aps.configure.otherSettings' => "Autre",
    'aps.configure.globalSettings' => 'Paramètres du pack',
    'aps.configure.passwordConfirmation' => 'Confirmer le mot de passe',
    'aps.configure.databaseParams' => 'Paramètres de la base de données',
    'aps.configure.noInstallationUrlAvailable' => 'Aucune (application externe)',
    'aps.configure.updateSettingsSection' => 'Paramètres de mise à jour',
    'aps.configure.forceUpdates' => 'Mettre à jour automatiquement cette application lorsque de nouvelles mises à jour sont disponibles',
    'aps.configure.forceUpdatesHint' => 'Cette application recevra automatiquement les mises à jour vers les nouvelles versions. Avertissement : attention, cette option doit être utilisée avec précaution, car elle peut affecter significativement le fonctionnement de l\'application. Par exemple, les extensions de l\'application peuvent cesser de fonctionner avec une autre version de l\'application.',

    'aps.install.showAllSettings' => 'Afficher tous les paramètres',
    'aps.install.showLessSettings' => 'Afficher les paramètres minimum',
    'aps.install.install' => 'Installer',
    'aps.install.otherSettings' => 'Autres paramètres',
    'aps.install.globalSettings' => 'Paramètres du pack',
    'aps.install.passwordConfirmation' => 'Confirmer le mot de passe',
    'aps.install.provisionsSectionLabel' => 'Chemin d\'installation',
    'aps.install.context' => 'Indiquer l\'emplacement où cette application Web doit être installée',
    'aps.install.registerAsWebmailSection' => 'Enregistrement de la messagerie Web',
    'aps.install.registerAsWebmailDescription' => "Sélectionnez cette option si l'application est un client de messagerie Web. L'application apparaîtra alors parmi les services de messagerie Web dans les paramètres Mail des abonnements et packs de services. L'administrateur peut configurer l'URL de l'accès public de la messagerie Web sous Gestion des serveurs > Paramètres > Messagerie Web.",
    'aps.install.registerAsWebmailLabel' => 'Enregistrer en tant que service de messagerie Web',
    'aps.install.addItem' => 'Ajouter',
    'aps.install.removeItem' => 'Supprimer',
    'aps.install.updateSettingsSection' => 'Paramètres de mise à jour',
    'aps.install.forceUpdates' => 'Mettre à jour automatiquement cette application lorsque de nouvelles mises à jour sont disponibles',
    'aps.install.forceUpdatesHint' => 'Cette application recevra automatiquement les mises à jour vers les nouvelles versions. Avertissement : attention, cette option doit être utilisée avec précaution, car elle peut affecter significativement le fonctionnement de l\'application. Par exemple, les extensions de l\'application peuvent cesser de fonctionner avec une autre version de l\'application.',

    'aps.invalid-requirements.requirementsLegend' => 'Requis',
    'aps.invalid-requirements.domainLegend' => 'Site Web',
    'aps.invalid-requirements.context' => 'Choisir un autre site Web',
    'aps.invalid-requirements.backToApplicationList' => 'Retour à la liste d\'applications',

    'aps.license.title' => 'Installation de %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Pour installer cette application, vous devez lire le Contrat de Licence Utilisateur Final et accepter ses conditions.',
    'aps.license.licenseAgree' => 'J\'accepte les conditions du Contrat de licence',

    'aps.services-list-customization.settings' => 'Paramètres',

    'asp-dot-net.change-version.frameworkVersion' => 'Version du Framework ASP.NET',

    'asp-dot-net.settings.casSettingsSection' => "Sécurité d'accès du code",
    'asp-dot-net.settings.clientScriptsSection' => "Paramètres de la bibliothèque de scripts",
    'asp-dot-net.settings.connStringsSection' => "Gestionnaire de chaîne de connexion",
    'asp-dot-net.settings.customErrorsSection' => "Paramètres pour les erreurs personnalisées",
    'asp-dot-net.settings.frameworkVersionSection' => "Version du Framework",
    'asp-dot-net.settings.globalizationSection' => "Paramètres de globalisation",
    'asp-dot-net.settings.otherSection' => "Paramètres de la session",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Compilation et débogage",
    'asp-dot-net.settings.authMode' => "Mode d'authentification",
    'asp-dot-net.settings.connStrings' => "Chaînes de connexion",
    'asp-dot-net.settings.connStringsInvalid' => "Certains champs sont vides ou leur valeur est erronée.",
    'asp-dot-net.settings.connStringName' => "Nom",
    'asp-dot-net.settings.connStringValue' => "Paramètres de connexion",
    'asp-dot-net.settings.culture' => "Langue",
    'asp-dot-net.settings.customErrMode' => "Mode d'erreurs personnalisées",
    'asp-dot-net.settings.customErrorRedirect' => "URL de redirection",
    'asp-dot-net.settings.customErrorStatus' => "Code d'état",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Le code d'état doit être un nombre entier.",
    'asp-dot-net.settings.customErrors' => "Erreurs personnalisées",
    'asp-dot-net.settings.customErrorsInvalid' => "Certains champs sont vides ou leur valeur est erronée.",
    'asp-dot-net.settings.debugMode' => "Activer le débogage",
    'asp-dot-net.settings.defLanguage' => "Langue par défaut de la page Web",
    'asp-dot-net.settings.tempDirectory' => "Répertoire temporaire",
    'asp-dot-net.settings.fileEnc' => "Encodage du fichier",
    'asp-dot-net.settings.fileEncInvalid' => "La valeur pour le paramètre d'encodage du fichier n'est pas valide.",
    'asp-dot-net.settings.pathToLib' => "Chemin d'accès à la bibliothèque de scripts Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Installer",
    'asp-dot-net.settings.reqEnc' => "Encodage de la demande",
    'asp-dot-net.settings.reqEncInvalid' => "La valeur indiquée pour le paramètre Encodage de la demande n'est pas valide.",
    'asp-dot-net.settings.resEnc' => "Encodage de la réponse",
    'asp-dot-net.settings.resEncInvalid' => "La valeur indiquée pour le paramètre Encodage de la réponse n'est pas valide.",
    'asp-dot-net.settings.sessTimeout' => "Délai d'expiration de session (minutes)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "La valeur indiquée pour le paramètre Délai d'expiration de session n'est pas valide. Saisissez un nombre entier positif inférieur ou égal à %%max%%.",
    'asp-dot-net.settings.trustLevel' => "Niveau de confiance CAS",
    'asp-dot-net.settings.uiCulture' => "Langues UI",
    'asp-dot-net.settings.version' => "Version",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Autoriser l\'écrasement du niveau de confiance CAS sur le site Web',
    'asp-dot-net.settings.addConnStrings' => 'Ajouter une chaîne de connexion',
    'asp-dot-net.settings.addCustomErrors' => 'Ajouter une erreur personnalisée',
    'asp-dot-net.settings.buttonRemove' => 'Supprimer',

    'database.clone.formDescription' => 'Copiez le contenu des bases de données vers  une nouvelle base de données ou vers une base de données existante. Lors de la copie vers une base de données existante, les tables de la base de données source sont ajoutées à la liste des tables dans la base de données de destination. Avertissement : si un nom de table est identique, alors la table de la base de données source  remplacera celle de la base de données cible.',
    'database.clone.copyData' => 'Créer une copie complète',
    'database.clone.copyDataHint' => 'Si cette option est sélectionnée, la base de données complète (structure et données incluses) sera copiée. Si cette option n\'est pas sélectionnée, seule la structure des tables est copiée.',
    'database.clone.server' => 'Serveur de base de données de destination',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Autres...',
    'database.clone.database' => 'Base de données source',
    'database.clone.newDatabase' => 'Créer une base de données portant le nom',
    'database.clone.existingDatabase' => 'Copier vers une base de données existante',
    'database.clone.externalDbHost' => 'Nom d\'hôte ou adresse IP',
    'database.clone.externalDbLogin' => 'Nom d\'utilisateur',
    'database.clone.externalDbPassword' => 'Mot de passe',
    'database.clone.subscription' => 'Abonnement cible',
    'database.clone.subscription_powerUser' => 'Espace Web cible',
    'database.clone.cloneInProgress' => 'Clonage de la base de données %%source%% vers la base de données %%destination%%. Vous serez notifié de la progression par mail (%%email%%).',
    'database.clone.unableToClone' => 'Impossible de copier la base de données : "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Impossible de créer une base de données "%%destination%%" sur le serveur indiqué.',
    'database.clone.databaseCloned' => 'La base de données "%%source%%" a été copiée.',
    'database.clone.emailSubjSuccess' => 'La base de données "%%sourceDatabase%%" a été copiée.',
    'database.clone.emailSubjFailure' => 'Échec de la copie de la base de données "%%sourceDatabase%%".',
    'database.clone.emailBodySuccess' => 'La base de données "%%sourceDatabase%%"(%%sourceHost%%) a été copiée vers la base de données "%%destDatabase%%"(%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Impossible de copier la base de données "%%sourceDatabase%%" (%%sourceHost%%) vers la base de données "%%destDatabase%%" (%%destHost%%). Échec de la copie.',
    'database.clone.localServer' => 'serveur local',

    'database.repair-orphaned.formDescription' => 'Cet utilisateur est devenu orphelin après la restauration. Veuillez entrer un mot de passe pour cet utilisateur afin de régler le problème. Si cet utilisateur est censé être un utilisateur système sans mot de passe, exécutez l\'utilitaire de réparation en laissant le champ Mot de passe vide.',
    'database.repair-orphaned.login' => 'Nom d\'utilisateur de la base de données',
    'database.repair-orphaned.pass' => 'Mot de passe',
    'database.repair-orphaned.pass2' => 'Confirmer le mot de passe',
    'database.repair-orphaned.users' => 'Certains utilisateurs requièrent votre attention. Il y a plusieurs utilisateurs orphelins qu\'il faut réparer en vue d\'un fonctionnement correct.',
    'database.repair-orphaned.orphaned' => 'L\'utilisateur est orphelin. %%gui begin:link%%Réparez maintenant%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Réparer',

    'database.repair.fixSelected' => 'Réparer sélectionnée(s)',
    'database.repair.fix' => 'Réparer',

    'database.user.password' => 'Mot de passe',
    'database.user.passwordConfirmation' => 'Confirmer le mot de passe',
    'database.user.server' => 'Serveur de bases de données',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Base de données',
    'database.user.anyDatabase' => 'Tout',
    'database.user.dataAccess' => 'Accès aux données',
    'database.user.structureAccess' => 'Accès à la structure',
    'database.user.globalAccess' => 'Privilèges globaux',
    'database.user.globalAccessHint' => 'Les privilèges globaux fonctionnent pour toutes les bases de données de ce compte d\'hébergement.',
    'database.user.aclRadio' => 'Contrôle de l\'accès',
    'database.user.aclLocalhost' => 'Autoriser uniquement les connexions locales',
    'database.user.aclAny' => 'Autoriser les connexions à distance depuis n\'importe quel hôte',
    'database.user.aclCustom' => 'Autoriser les connexions à distance depuis',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nLes hôtes indiqués sont autorisés à accéder à la base de données au nom de cet utilisateur.",
    'database.user.remoteAccess' => 'Accès à distance',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nLes adresses IP indiquées sont autorisées à accéder à la base de données au nom de cet utilisateur. Les modifications que vous effectuez dans cette liste seront prémodérées par votre hébergeur.",
    'database.user.example' => "Par exemple :\n%%example%%",
    'database.user.denied' => 'Utiliser les règles du pare-feu du système',
    'database.user.allowed' => 'Autoriser les connexions à distance depuis',
    'database.user.default' => 'Utiliser par défaut les identifiants d\'accès de cet utilisateur pour accéder à %%webadmin%%',
    'database.user.remoteAccessHint' => 'Veuillez contacter votre hébergeur. Assurez-vous que l\'option que vous avez indiquée ci-dessus est conforme aux règles de pare-feu actuelles pour les accès entrants à MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.myLittleAdmin' => 'myLittleAdmin',
    'database.user.webAdmin' => 'Admin Web',
    'database.user.role' => 'Rôle',
    'database.user.roleReadWrite' => 'Lecture et Écriture',
    'database.user.roleWriteOnly' => 'Écriture uniquement',
    'database.user.roleReadOnly' => 'En lecture seule',
    'database.user.roleCustom' => 'Personnalisé',

    'database.generalSection' => 'Général',
    'database.name' => 'Nom de la base de données',
    'database.server' => 'Serveur de base de données',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Site associé',
    'database.noDomainRelations' => 'Aucun site associé',
    'database.userSection' => 'Utilisateurs',
    'database.userSectionDescription' => 'Créez un utilisateur de base de données par défaut. Plesk accédera à la base de données au nom de cet utilisateur. Si aucun utilisateur de base de données n\'est affecté à la base de données, elle ne sera pas accessible.',
    'database.createUser' => 'Créer un utilisateur de bases de données',
    'database.username' => 'Nom d\'utilisateur de base de données',
    'database.password' => 'Mot de passe',
    'database.passwordConfirmation' => 'Confirmer le mot de passe',
    'database.allDbAccess' => 'L\'utilisateur dispose d\'un accès à toutes les bases de données au sein de l\'abonnement sélectionné.',
    'database.aclRadio' => 'Contrôle de l\'accès',
    'database.aclLocalhost' => 'Autoriser uniquement les connexions locales',
    'database.aclAny' => 'Autoriser les connexions à distance depuis n\'importe quel hôte',
    'database.aclCustom' => 'Autoriser les connexions à distance depuis',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nLes hôtes indiqués sont autorisés à accéder à la base de données au nom de cet utilisateur.",
    'database.remoteAccess' => 'Accès à distance',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nLes adresses IP indiquées sont autorisées à accéder à la base de données au nom de cet utilisateur. Les modifications que vous effectuez dans cette liste seront prémodérées par votre hébergeur.",
    'database.example' => "Par exemple :\n%%example%%",
    'database.denied' => 'Utiliser les règles du pare-feu du système',
    'database.allowed' => 'Autoriser les connexions à distance depuis',

    'deployment-section.deploymentDisabledHint' => 'Envoyer des fichiers depuis un répertoire Git',
    'deployment-section.deploymentEnabledHint' => 'Activer la prise en charge de Git',
    'deployment-section.deploymentSectionLegend' => 'Liste des fichiers à copier vers l\'hébergement',
    'deployment-section.deploymentSectionDescriptionHint' => 'Si la prise en charge Git est désactivée, les répertoires root (website/application root et document root) seront créés vides et le site affichera la page par défaut dans le navigateur. Vous devrez envoyer les fichiers de votre site dans le répertoire "document root" à l\'aide du FTP ou du Gestionnaire de fichiers. Autre solution : activez la prise en charge Git tout de suite ou ultérieurement (dans Sites Web & Domaines) et envoyez les fichiers depuis un répertoire Git.',

    'dns-zone.add-acl-record.description' => 'Ajoutez une adresse IP d\'un serveur DNS autorisé à recevoir une copie de la zone DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'Adresse IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'Adresse IP/masque',

    'dns-zone.record.add-title' => "Ajouter un enregistrement de ressources au template de zone",
    'dns-zone.record.add-ns-title' => "Ajouter un serveur de noms",
    'dns-zone.record.edit-title' => "Éditer l'enregistrement de ressource",
    'dns-zone.record.type' => "Type d'enregistrement",
    'dns-zone.record.domainName' => "Nom de domaine",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Serveur de noms",
    'dns-zone.record.protocol' => "Protocole",
    'dns-zone.record.priority' => "Priorité",
    'dns-zone.record.priorityLow' => "faible (%%priority%%)",
    'dns-zone.record.priorityHigh' => "très élevée (%%priority%%)",
    'dns-zone.record.weightLow' => "faible (%%weight%%)",
    'dns-zone.record.weightHigh' => "très élevée (%%weight%%)",
    'dns-zone.record.ipAddress' => "Adresse IP",
    'dns-zone.record.ipAddressDescription' => "Par exemple : 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Par exemple : <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Adresse IPv6",
    'dns-zone.record.ipAddressV6Description' => "Par exemple : 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Par exemple : <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Par exemple : 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Par exemple : <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Par exemple : 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nom canonique",
    'dns-zone.record.mailDomain' => "Domaine de messagerie",
    'dns-zone.record.mxServer' => "Serveur d'échange de mails",
    'dns-zone.record.mxServerPriority' => "Priorité du serveur d'échange de mails",
    'dns-zone.record.txtRecord' => "Enregistrement TXT",
    'dns-zone.record.txtRecordString' => "Taper la chaîne de l'enregistrement",
    'dns-zone.record.txtSpfSyntax' => "Enregistrement SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Des valeurs incorrectes ont été indiquées pour l'enregistrement TXT.",
    'dns-zone.record.dsRecord' => "Enregistrement DS",
    'dns-zone.record.dsRecordDescription' => "Par exemple, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Une valeur incorrecte a été indiquée pour l'enregistrement DS.",
    'dns-zone.record.serviceName' => "Nom du service",
    'dns-zone.record.serviceNameDescription' => "Exemple : SIP (sans tiret bas)",
    'dns-zone.record.protocolNameDescription' => "Exemple : TCP (sans tiret bas)",
    'dns-zone.record.srvWeight' => "Poids moyen pour les enregistrements qui ont la même priorité",
    'dns-zone.record.targetHost' => "Hôte cible",
    'dns-zone.record.targetHostDescription' => "Exemple : example.com",
    'dns-zone.record.targetPort' => "Port cible",
    'dns-zone.record.retrieveDataError' => "Impossible de trouver les données de l'enregistrement.",
    'dns-zone.record.unknownTypeError' => "Type d'enregistrement DNS inconnu.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Impossible de configurer l\'enregistrement MX NULL tant que d\'autres enregistrements MX sont présents.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Impossible de configurer l\'enregistrement MX non-NULL tant que l\'enregistrement MX NULL est présent.',
    'dns-zone.record.masterShouldBeRemote' => "Vous devez disposer de deux serveurs de noms d'autorité sur des hôtes distincts.",
    'dns-zone.record.caaTag' => "Balise",
    'dns-zone.record.caaRecord' => "Valeur",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Secondes",
    'dns-zone.record.invalidValue' => 'La valeur n\'est pas valide. Elle peut aller de 1 seconde à 2147483647.',
    'dns-zone.record.ttlDefaultValue' => 'Valeur par défaut : %%value%% secondes',
    'dns-zone.record.invalidTTL' => 'La valeur TTL spécifiée n\'est pas valide.',
    'dns-zone.record.invalidIpAddress' => 'L\'adresse IP indiquée n\'est pas valide.',
    'dns-zone.record.invalidIpMaskPair' => 'La paire adresse IP / masque réseau n\'est pas valide.',
    'dns-zone.record.invalidCName' => 'Le nom canonique spécifié n\'est pas valide.',
    'dns-zone.record.invalidSRVPort' => 'Le port indiqué n\'est pas valide.',

    'dns-zone.restore-default.formHint' => "Sur cette page, vous pouvez restaurer la configuration de la zone originale conformément aux paramètres de templates DNS par défaut utilisés sur le serveur. Sélectionnez les adresses IP à utiliser pour restaurer la zone et spécifiez si un alias www est requis pour le domaine.",
    'dns-zone.restore-default.ipv4' => "Adresse IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Par exemple : 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Adresse IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Par exemple : 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'L\'adresse IP indiquée n\'est pas valide.',
    'dns-zone.restore-default.customIpHint' => "Les enregistrements avec cette adresse IP seront considérés comme modifiés par l'utilisateur et ne seront pas synchronisés avec le template DNS valable pour tout le serveur.",
    'dns-zone.restore-default.wwwPrefix' => "Préfixe www",
    'dns-zone.restore-default.previewRecords' => "Restaurer les enregistrements utilisés pour l'aperçu du site",

    'dns-zone.soa-record.soaMnameSection' => 'Serveur de noms principal',
    'dns-zone.soa-record.soaMname' => 'Serveur de noms',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Sélection automatique)',
    'dns-zone.soa-record.soaRecordSection' => 'Enregistrement SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Actualiser',
    'dns-zone.soa-record.retry' => 'Réessayer',
    'dns-zone.soa-record.expire' => 'Délai d\'expiration',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E-mail (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'Adresse e-mail de la personne responsable de la zone DNS du domaine. Renvoyée par le serveur DNS en réponse aux requêtes SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Adresse mail du propriétaire du site Web',
    'dns-zone.soa-record.rnameTypeDomain' => 'Adresse mail pour le domaine',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Saisissez uniquement la partie locale (avant @<domain>).',
    'dns-zone.soa-record.rnameTypeExternal' => 'Adresse mail externe',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Interdire la modification de l\'adresse mail RNAME sur une base par domaine',
    'dns-zone.soa-record.invalidValue' => 'La valeur n\'est pas valide. Elle peut aller de 1 seconde à 68 ans.',
    'dns-zone.soa-record.advancedSection' => 'Fonctionnalités DNS avancées',
    'dns-zone.soa-record.serialNumberFormat' => 'Utiliser le format du numéro de série recommandé par IETF et RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Sélectionnez cette option si votre domaine rencontre des problèmes avec le passage de la vérification SOA du registraire. De nombreux registraires de domaines requièrent ce format de numéro de série.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Utiliser les paramètres par défaut',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Paramètres par défaut de la zone',
    'dns-zone.soa-record.unitSeconds' => 'secondes',
    'dns-zone.soa-record.unitMinutes' => 'minutes',
    'dns-zone.soa-record.unitHours' => 'heures',
    'dns-zone.soa-record.unitDays' => 'jours',
    'dns-zone.soa-record.unitWeeks' => 'semaines',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'La valeur de l\'intervalle de rafraîchissement est inférieure à une heure, ce qui peut augmenter énormément le trafic et les besoins en ressources.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Si vous fixez une valeur minimum du TTL de plus de 3 heures, certains administrateurs de domaine pourraient ne plus pouvoir accéder vos domaines. Nous vous recommandons de ne prendre cette valeur que si votre registrar insiste.',
    'dns-zone.soa-record.success' => 'Les propriétés de l\'enregistrement SOA ont été mises à jour.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'L\'enregistrement SOA par défaut a été restauré.',

    'domain-info-section.domainName' => 'Nom de domaine',
    'domain-info-section.emptyDomainName' => 'Veuillez indiquer un nom de domaine.',
    'domain-info-section.ipAddress' => 'Adresse IP',
    'domain-info-section.shared' => 'partagé',
    'domain-info-section.exclusive' => 'dédiée',
    'domain-info-section.ipAddressHint' => "L'adresse IP sur laquelle le site Web est hébergé est une adresse réseau de l'hôte virtuel du site Web. Cette adresse IP sera utilisée pour tous les sites Web créés dans l'abonnement.",
    'domain-info-section.ipAddressHint_powerUser' => "L'adresse IP sur laquelle le site Web est hébergé est une adresse réseau de l'hôte virtuel du site Web. Cette adresse IP sera utilisée pour tous les sites Web créés dans l'espace Web.",
    'domain-info-section.userName' => 'Nom d\'utilisateur',
    'domain-info-section.userNameHint' => 'Le compte utilisateur système est associé à l\'espace Web ; il est utilisé pour accéder aux fichiers hébergés via FTP et SSH.',
    'domain-info-section.emptyLogin' => 'Veuillez indiquer un nom d\'utilisateur.',
    'domain-info-section.password' => 'Mot de passe',
    'domain-info-section.emptyPassword' => 'Veuillez indiquer un mot de passe.',
    'domain-info-section.passwordConfirmation' => 'Confirmer le mot de passe',

    'email-address.generalTab' => 'Général',
    'email-address.generalHint' => 'Si ce compte mail est associé à un utilisateur supplémentaire (l\'accès au Panneau Client est activé), alors les modifications effectuées sur cette page affecteront les paramètres de l\'utilisateur. Notez qu\'en cas de changement de l\'adresse mail et du mot de passe, le nom d\'utilisateur et le mot de passe de l\'utilisateur supplémentaire seront également modifiés en fonction des nouvelles valeurs.',
    'email-address.redirectTab' => 'Redirection',
    'email-address.redirectHint' => 'Configurez la redirection des mails vers une ou plusieurs adresses mail.',
    'email-address.aliasesTab' => 'Alias de messagerie',
    'email-address.autoResponderTab' => 'Réponse automatique',
    'email-address.antispamTab' => 'Filtre anti-spam',
    'email-address.autoResponderHint' => 'Configurez une réponse automatique pour tout mail arrivant sur votre adresse mail. Une réponse automatique est un moyen standard de notifier à vos correspondants que vous êtes en déplacement ou en vacances.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'Adresse mail',
    'email-address.externalEmail' => 'Adresse mail externe',
    'email-address.externalEmailHint' => 'Permettra de réinitialiser votre mot de passe si vous perdez l\'accès à l\'adresse mail principale.',
    'email-address.user' => 'Affecté(e) à',
    'email-address.password' => 'Mot de passe',
    'email-address.passwordConfirmation' => 'Confirmer le mot de passe',
    'email-address.responderEnable' => 'Activer la réponse automatique',
    'email-address.responderSubject' => 'Objet de la réponse automatique',
    'email-address.responderContentType' => 'Format du message',
    'email-address.responderContentTypeHint' => 'Le format Texte brut est pris en charge par tous les programmes clients de messagerie. Par conséquent, tous les destinataires verront le message de la même façon que vous le voyez. Les messages HTML sont plus agréables à l\'oeil car ils vous permettent d\'entrer un texte formaté avec différents styles de police. Cependant, certains clients de messagerie ne prennent pas en charge les messages HTML et certains destinataires risquent de ne pas voir le texte formaté.',
    'email-address.responderContentTypeTextPlain' => 'Texte brut',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Codage',
    'email-address.responderCodepageHint' => 'L\'encodage définit comment les caractères textuels s\'affichent. L\'encodage conseillé est UTF-8.',
    'email-address.responderReplyTo' => 'Transférer à',
    'email-address.responderReplyToHint' => 'Une fois la réponse automatique envoyée, le message original sera transféré à l\'adresse mail indiquée.',
    'email-address.responderForwardAddress' => 'Transférer à',
    'email-address.responderForwardAddressHint' => 'Une fois la réponse automatique envoyée, le message original sera transféré à l\'adresse mail indiquée.',
    'email-address.responderMessage' => 'Texte de la réponse automatique',
    'email-address.responderReplyToEqualsEmail' => 'L\'adresse de redirection indiquée est identique à cette adresse mail.',
    'email-address.responderForwardAddressEqualsEmail' => 'L\'adresse de redirection indiquée est identique à cette adresse mail.',
    'email-address.responderReplyLimit' => 'Envoyer une réponse automatique à une adresse mail unique au maximum (nombre de fois par jour)',
    'email-address.buttonAddResponderAttachment' => 'Ajouter une pièce jointe',
    'email-address.buttonRemoveResponderAttachment' => 'Supprimer',
    'email-address.responderAttachment' => 'Joindre un fichier',
    'email-address.redirectEnable' => 'Activer la redirection de mails',
    'email-address.redirectRemoveEnable' => 'Ne pas enregistrer de copie des mails transférés dans la Boîte mail de Plesk',
    'email-address.redirectAddress' => 'Transférer les messages entrants à l\'adresse mail suivante',
    'email-address.redirectAddressHint' => 'Indiquez des adresses mail. Vous pouvez saisir chaque adresse sur une nouvelle ligne ou séparer les adresses avec des espaces blancs, des virgules ou des points virgules.',
    'email-address.role' => 'Rôle de l\'utilisateur',
    'email-address.roleHint' => 'Les rôles de l\'utilisateur accordent aux utilisateurs les privilèges admin et l\'accès aux applications que vous avez sélectionnées pour le rôle.',
    'email-address.errorRedirectAddress' => 'Vous avez indiqué une adresse mail incorrecte : %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Vous avez indiqué des adresses mail incorrectes : %value%.',
    'email-address.mailAlias' => "Alias de messagerie",
    'email-address.mailAliasNone' => 'Aucun(e)',
    'email-address.mailAliasHint' => "Les alias de messagerie sont des adresses mail alternatives associées à une adresse mail primaire. Tous les mails envoyés vers ces alias de messagerie seront reçus par l'adresse mail primaire.",
    'email-address.buttonAddMailAlias' => 'Ajouter un alias de messagerie',
    'email-address.buttonRemoveMailAlias' => 'Supprimer',
    'email-address.emptyEmail' => 'Indiquez une adresse mail vers laquelle les copies de tous les messages entrants doivent être redirigées.',
    'email-address.emailsIsEqual' => 'L\'adresse mail externe correspond à l\'adresse mail principale. Indiquez une autre adresse mail externe.',
    'email-address.emptyPassword' => 'Vous devez indiquer un mot de passe.',
    'email-address.emptyPasswordConfirmation' => 'Vous devez confirmer le mot de passe.',
    'email-address.emptyAlias' => "Précisez l'alias de messagerie pour cette adresse mail.",
    'email-address.aliasEqualsEmail' => 'L\'alias de messagerie indiqué est identique à l\'adresse mail.',
    'email-address.passwordHint' => 'Permettra d\'accéder à la boîte mail et de se connecter à Plesk (si l\'option correspondante est sélectionnée).',
    'email-address.cyclicRedirect' => 'L\'adresse mail ne peut être configurée pour transférer les mails par elle-même.',
    'email-address.errorMailnameReserved' => 'L\'adresse mail indiquée est déjà utilisée.',
    'email-address.antivirusEnable' => 'Activer la protection antivirus pour cette adresse mail',
    'email-address.antivirusHint' => 'Le service antivirus bloque les mails qui contiennent des virus et notifie le destinataire et l\'expéditeur à ce sujet.',
    'email-address.antivirusSettings' => 'Vérifier les virus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'Uniquement les mails entrants',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'Uniquement les mails sortants',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'Mails entrants et sortants',
    'email-address.antispamHint' => 'Le service anti-spam détecte les spams envoyés à l\'adresse mail. Vous pouvez configurer le filtre anti-spam de telle sorte qu\'il supprime les spams, les marque en changeant leur objet ou les déplace vers le dossier dédié aux spams accessible par les clients de messagerie via IMAP. Le filtre anti-spam utilise différents tests locaux et réseaux pour identifier les signatures des spams.',
    'email-address.antispamEnable' => 'Activer le filtre anti-spam pour cette adresse mail',
    'email-address.antispamSettings' => 'Que faire avec les messages classés en tant que spam',
    'email-address.antispamSettingsMark' => 'Marquer comme spam en ajoutant le texte suivant à l\'objet du message',
    'email-address.antispamSettingsMarkHint' => 'Laissez ce champ vide si vous ne voulez pas ajouter de texte. Tapez _SCORE_ si vous voulez inclure le score dans l\'objet du message.',
    'email-address.antispamReportTextHint' => 'Tapez le texte que vous voulez ajouter à réception des mails spams.',
    'email-address.antispamSettingsDelete' => 'Supprimer tous les spams',
    'email-address.antispamSettingsDeleteHint' => 'Les spams seront supprimés de votre boîte mail.',
    'email-address.antispamSettingsMove' => 'Déplacer le spam dans le dossier Spam',
    'email-address.antispamSettingsMoveHint' => 'Déplacez tous les spams dans le dossier Spam. Ce dossier est accessible à partir de votre programme client de messagerie ou messagerie Web. Si vous essayez d\'utiliser un compte mail IMAP, vous pouvez alors utiliser le dossier Spam pour former le filtre anti-spam.',
    'email-address.antispamSettingsMoveWarning' => '"Déplacer le spam dans le dossier Spam" ne fonctionne pas, sauf si vous désactivez l\'option "Ne pas enregistrer de copie des mails transférés dans la Boîte mail de Plesk" depuis l\'onglet "Redirection".',
    'email-address.antispamSettingsMoveJunk' => 'Déplacer le spam dans le dossier "Indésirables"',
    'email-address.antispamSettingsMoveJunkHint' => 'Déplacez tous les spams dans le dossier "Indésirables". Ce dossier est accessible à partir de votre client de messagerie ou de votre messagerie Web. Si vous utilisez un compte mail IMAP, vous pouvez alors utiliser le dossier "Indésirable" pour former le filtre anti-spam.',
    'email-address.antispamShowAdvancedSection' => 'Voir les paramètres avancés',
    'email-address.antispamHideAdvancedSection' => 'Masquer les paramètres avancés',
    'email-address.antispamLearnMore' => 'Découvrez comment former le filtre anti-spam.',
    'email-address.antispamFilterScoreTitle' => 'Intensité du filtre',
    'email-address.antispamFilterScoreHint' => 'Le filtre anti-spam exécute différents tests sur le contenu et la ligne Objet de chaque mail. À la fin des tests, chaque message obtient un nombre de points. Plus le nombre est élevé, plus il est probable que le mail est un spam. Par défaut, la sensibilité du filtre est fixée de telle sorte que tous les messages qui totalisent 7 points voire plus sont classés en spams. Si vous recevez beaucoup de spams avec la configuration actuelle, essayez d\'augmenter l\'intensité du filtre : saisissez une valeur inférieure, par exemple, 6. Si vous constatez l\'absence de vos mails parce que votre filtre anti-spam considère que ce sont des messages non sollicités, essayez de réduire l\'intensité du filtre, par exemple, 8.',
    'email-address.antispamFilterScore' => 'Intensité du filtre anti-spam',
    'email-address.antispamWhiteListTitle' => 'Liste blanche',
    'email-address.antispamWhiteListHint' => 'Les mails issus des expéditeurs dans la liste blanche ne sont pas vérifiés par le filtre anti-spam.',
    'email-address.antispamWhiteListField' => 'Liste blanche',
    'email-address.antispamWhiteListFieldHint' => 'Tapez les noms de domaine, un nom de domaine par ligne. Les adresses peuvent contenir les caractères spéciaux "*" et "?" (par exemple, *@domain.com, user?@*.com).',
    'email-address.antispamBlackListTitle' => 'Liste noire',
    'email-address.antispamBlackListHint' => 'Les mails issus des expéditeurs dans la liste noire sont classés dans le spam.',
    'email-address.antispamBlackListField' => 'Liste noire',
    'email-address.antispamBlackListFieldHint' => 'Tapez les noms de domaine, un domaine par ligne. Les adresses peuvent contenir les caractères spéciaux "*" et "?" (par exemple, *@domain.com, user?@*.com).',
    'email-address.antispamTrustedLanguagesTitle' => 'Langues fiables',
    'email-address.antispamTrustedLanguagesHint' => 'Les mails dans ces langues seront toujours acceptés par le filtre.',
    'email-address.antispamTrustedLocalesTitle' => 'Fichiers de langue de confiance',
    'email-address.antispamTrustedLocalesHint' => 'Les mails qui utilisent des groupes de langues spécifiés seront toujours acceptés par le filtre. Les groupes de fichiers de traduction incluent des jeux de caractères spéciaux les plus communément utilisés. Par exemple, le jeu de caractères occidentaux inclut des encodages pour les lettres utilisées en anglais et dans les langues européennes occidentales.',
    'email-address.antispamTrustedNetworksTitle' => 'Réseaux fiables',
    'email-address.antispamTrustedNetworksHint' => 'Les hôtes relais des réseaux fiables figurant dans la liste sont considérés comme n\'étant potentiellement pas exploités par des spammers. Ils ne sont pas des relais ou des proxy ouverts.',
    'email-address.antispamIpAddressesField' => 'Adresses IP',
    'email-address.antispamIpAddressesFieldHint' => 'Indiquez l\'adresse IP du réseau et le masque réseau.',
    'email-address.mailBoxQuotaDomainDefault' => 'Taille par défaut (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Taille par défaut',
    'email-address.mailBoxOutgoingMessages' => 'Nombre maximum de mails sortants',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Par défaut (%%domainOutgoingMessages%% messages par heure)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Valeur personnalisée pour la boîte mail',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'messages',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Par défaut',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Taille par défaut',
    'email-address.mailBoxQuotaDomainSpecific' => 'Autre taille',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Volume de la boîte mail',
    'email-address.mailBoxQuotaUnlimited' => 'Illimitée',
    'email-address.mailBoxLimitReached' => 'La limite du nombre de boîtes mail a été atteinte.',
    'email-address.postboxEnabled' => 'Boîte mail',
    'email-address.postboxEnabledYes' => 'Activé',
    'email-address.postboxEnabledNo' => 'Désactivé',
    'email-address.description' => 'Description dans Plesk',
    'email-address.descriptionHint' => 'La description est visible à tous les utilisateurs qui ont accès à ce compte mail.',
    'email-address.longDescription' => 'La description indiquée est trop longue. Elle doit être inférieure à %%max%% caractères.',
    'email-address.loginAsUser' => 'Utilisable pour la connexion à Plesk',
    'email-address.loginAsUserDescription' => '(Nom d\'utilisateur : %%username%%)',
    'email-address.maxCustomSizeDesc' => 'La taille de la boîte mail ne peut pas dépasser la taille par défaut.',
    'email-address.endDateEnable' => 'Désactiver la réponse automatique le',

    'failed-request.enable-tracing.description' => 'Le Suivi des demandes ayant échoué est une opération gourmande en ressources. Le Suivi sera automatiquement arrêté dans %%days%% jours. Vous pouvez l\'arrêter manuellement à tout moment.',
    'failed-request.enable-tracing.statusCodes' => 'Code de statuts',
    'failed-request.enable-tracing.statusCodesDescription' => 'Exemple : 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Fournisseur',

    'file-manager.show.buttonReload' => 'Actualiser',
    'file-manager.show.buttonSave' => 'Enregistrer',
    'file-manager.show.buttonSaveAs' => 'Enregistrer sous',
    'file-manager.show.buttonReset' => 'Réinitialiser',
    'file-manager.show.buttonTextCodeEditor' => 'Éditer dans l\'éditeur de code',
    'file-manager.show.buttonTextEdit' => 'Éditer dans l\'éditeur de texte',
    'file-manager.show.buttonWysiwygEdit' => 'Éditer dans l\'éditeur HTML',
    'file-manager.show.eolLabel' => 'Type de retour à la ligne :',
    'file-manager.show.saveAs' => 'Enregistrer sous :',
    'file-manager.show.saveCodepage' => 'Enregistrer sous l\'encodage suivant :',
    'file-manager.show.loadCodepage' => 'Afficher le fichier original dans l\'encodage suivant :',
    'file-manager.show.loadCodepageHint' => 'Avertissement : toute modification du texte non enregistrée sera perdue lors du renvoi du fichier.',
    'file-manager.show.fileExists' => "Le fichier ou dossier %%fileName%% existe déjà. Un fichier et un dossier ne peuvent pas porter le même nom.",
    'file-manager.show.popupTitle' => 'Enregistrer sous',
    'file-manager.show.popupFilename' => 'Nom du fichier :',

    'file-manager.permissions.filePermissions' => 'Droits des fichiers',
    'file-manager.permissions.directoryPermissions' => 'Droits des répertoires',
    'file-manager.permissions.buttonSubmit' => 'Enregistrer',
    'file-manager.permissions.buttonApply' => 'Enregistrer et poursuivre',
    'file-manager.permissions.buttonCancel' => 'Annuler',
    'file-manager.permissions.buttonAdvanced' => 'Avancé',

    'file-manager.unix-file-permissions.group' => 'Groupe',
    'file-manager.unix-file-permissions.owner' => 'Propriétaire',
    'file-manager.unix-file-permissions.others' => 'Autres',
    'file-manager.unix-file-permissions.readMode' => 'Lire',
    'file-manager.unix-file-permissions.writeMode' => 'Écrire',
    'file-manager.unix-file-permissions.execMode' => 'Exécuter/Rechercher',
    'file-manager.unix-file-permissions.changeRecursive' => 'Modifier les droits de manière récursive',

    'file-manager.windows-permissions.allow' => 'Autoriser',
    'file-manager.windows-permissions.deny' => 'Refuser',
    'file-manager.windows-permissions.inheritFromParent' => 'Autoriser les droits hérités du parent à se propager à cet objet et aux objets enfants',
    'file-manager.windows-permissions.replaceOnChildren' => 'Remplacer des entrées relatives à des droits sur tous les objets enfants par des entrées affichées ici',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avancé',
    'file-manager.windows-permissions.applyTo' => 'Appliquer à :',
    'file-manager.windows-permissions.folderOnly' => 'À ce dossier uniquement',
    'file-manager.windows-permissions.subfolderOnly' => 'Aux sous-dossiers uniquement',
    'file-manager.windows-permissions.filesOnly' => 'Aux fichiers uniquement',
    'file-manager.windows-permissions.permissionsFor' => 'Droits pour',
    'file-manager.windows-permissions.applyOnto1' => 'À ce dossier uniquement',
    'file-manager.windows-permissions.applyOnto2' => 'Aux sous-dossiers uniquement',
    'file-manager.windows-permissions.applyOnto3' => 'À ce dossier et aux sous-dossiers',
    'file-manager.windows-permissions.applyOnto4' => 'Aux fichiers uniquement',
    'file-manager.windows-permissions.applyOnto5' => 'À ce dossier et aux fichiers',
    'file-manager.windows-permissions.applyOnto6' => 'Au sous-dossier et aux fichiers uniquement',
    'file-manager.windows-permissions.applyOnto7' => 'À ce dossier, aux sous-dossiers et aux fichiers',
    'file-manager.windows-permissions.notInherited' => '<pas hérité>',

    'file-manager.editor.titleTextEditor' => 'Éditeur de texte',
    'file-manager.editor.titleCodeEditor' => 'Éditeur de code',
    'file-manager.editor.titleCodeViewer' => 'Afficher',
    'file-manager.editor.buttonSubmit' => 'Enregistrer',
    'file-manager.editor.buttonApply' => 'Enregistrer et poursuivre',
    'file-manager.editor.buttonSaveAs' => 'Enregistrer sous...',
    'file-manager.editor.buttonCancel' => 'Annuler',
    'file-manager.editor.exitConfirmationYes' => 'Oui',
    'file-manager.editor.exitConfirmationNo' => 'Non',
    'file-manager.editor.fileOverwrite' => 'Le fichier existe déjà.',
    'file-manager.editor.fileOverwriteDescription' => 'Un fichier portant le même nom existe déjà. Voulez-vous l\'écraser ?',
    'file-manager.editor.exitConfirmation' => 'Voulez-vous vraiment fermer ce fichier et effacer les modifications non enregistrées ?',
    'file-manager.editor.buttonCodeEditor' => 'Éditer dans l\'éditeur de code',
    'file-manager.editor.buttonTextEditor' => 'Éditer dans l\'éditeur de texte',
    'file-manager.editor.buttonHtmlEditor' => 'Éditer dans l\'éditeur HTML',

    'file-manager.import-file.buttonSubmit' => 'Importer',
    'file-manager.import-file.fieldUrl' => 'URL pour le fichier',
    'file-manager.import-file.fieldUrlDescription' => 'Précisez l\'URL source. Par exemple : "https://exemple.com/exemple.tgz".',
    'file-manager.import-file.fieldUrlFullDescription' => 'Le modèle complet de l\'URL est le suivant : "\'https://utilsateur:motdepasse@exemple.com/exemple.tgz". Le nom d\'utilisateur et le mot de passe sont facultatifs. Les protocoles compatibles sont http, https, ftp, ftps. Utilisez l\'encodage de l\'URL pour les parties de l\'URL qui contiennent des caractères spéciaux ou des espaces.',
    'file-manager.import-file.failure' => 'Impossible d\'importer le fichier.',

    'file-manager.rotation-settings.title' => 'Paramètres de rotation de la poubelle',
    'file-manager.rotation-settings.rotationBySize' => 'Rotation par taille',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'Mo',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Cette option supprime les nouveaux fichiers lorsque la limite spécifiée pour la poubelle est dépassée.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotation par date',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Jours',
    'file-manager.rotation-settings.rotationByDateHint' => 'Cette option supprime les fichiers stockés dans la poubelle au-delà d\'un nombre de jours prédéfini.',

    'ftp-user.description' => 'Si une autre personne que vous-même travaille également sur votre site Web ou si vous hébergez des sous-domaines d\'autres utilisateurs, vous voudrez peut-être créer des comptes FTP séparés pour ces derniers.',
    'ftp-user.generalSection' => 'Général',
    'ftp-user.login' => 'Nom du compte FTP',
    'ftp-user.home' => 'Répertoire principal',
    'ftp-user.systemArea' => 'Créer un compte FTP avec accès aux fichiers en dehors du répertoire principal',
    'ftp-user.password' => 'Mot de passe',
    'ftp-user.passwordConfirmation' => 'Confirmer le mot de passe',
    'ftp-user.hardQuotaSection' => 'Quota dur de disque',
    'ftp-user.hardQuota' => 'Quota dur de disque',
    'ftp-user.hardQuotaUnlimited' => 'Illimité',
    'ftp-user.permissionsSection' => 'Droits',
    'ftp-user.permissionRead' => 'Droit de lecture',
    'ftp-user.permissionWrite' => 'Droit d\'écriture',
    'ftp-user.popupTitle' => 'Sélectionner un répertoire',

    'mail-list.listName' => 'Adresse de la liste de diffusion',
    'mail-list.enabled' => 'Activé',
    'mail-list.administratorEmail' => 'Adresse mail de l\'administrateur de la liste de diffusion',
    'mail-list.password' => 'Mot de passe',
    'mail-list.passwordConfirmation' => 'Confirmer le mot de passe',
    'mail-list.subscribers' => 'Abonnés',
    'mail-list.subscribersHint' => 'Indiquez des adresses mail. Vous pouvez saisir chaque adresse sur une nouvelle ligne ou séparer les adresses avec des espaces blancs, des virgules ou des points virgules.',
    'mail-list.notify' => 'Notifier l\'administrateur lors de la création de la liste de diffusion',
    'mail-list.emptyPassword' => 'Veuillez indiquer un mot de passe.',
    'mail-list.emptyPasswordConfirmation' => 'Veuillez confirmer le mot de passe.',
    'mail-list.errorSubscribers' => 'Adresses mail non valides : %value%.',
    'mail-list.errorMaillistReserved' => 'La liste de diffusion est déjà utilisée.',

    'mail-settings.hint' => 'Sur cette page, vous pouvez modifier les paramètres du service de messagerie pour ce domaine.',
    'mail-settings.service' => 'Activer le service de messagerie sur ce domaine',
    'mail-settings.nonExist' => 'Règle pour les mails envoyés à des utilisateurs inexistants',
    'mail-settings.nonExistBounceWithMessage' => 'Rejeter avec un message',
    'mail-settings.nonExistBounce' => 'Rejeter',
    'mail-settings.nonExistCatch' => 'Transférer à l\'adresse',
    'mail-settings.nonExistCatchDescription' => 'Cette adresse doit appartenir au domaine sélectionné. Seul l\'administrateur peut indiquer une adresse externe ou une adresse pour plusieurs domaines.',
    'mail-settings.nonExistExternal' => 'Rediriger vers un serveur de messagerie externe avec l\'adresse IP :',
    'mail-settings.nonExistReject' => 'Rejeter',
    'mail-settings.nonExistDiscard' => 'Rejeter',
    'mail-settings.webmail' => 'Messagerie Web',
    'mail-settings.webmailNone' => 'Aucun(e)',
    'mail-settings.webmailComponentNotInstalled' => 'Le composant du service de messagerie Web n\'a pas été installé.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Il y a un sous-domaine portant le nom %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certificat SSL/TLS pour la messagerie Web',
    'mail-settings.webmailCertificateNone' => 'Non sélectionné',
    'mail-settings.mailCertificate' => 'Certificat SSL/TLS pour la messagerie',
    'mail-settings.mailCertificateNone' => 'Non sélectionné',
    'mail-settings.serverCertificateNotSelected' => 'Le certificat a été attribué mais la messagerie du domaine n\'est pas protégée. Pour protéger la messagerie du domaine, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'protéger le serveur de messagerie',
    'mail-settings.mailLists' => 'Activer les listes de diffusion',
    'mail-settings.mailAutodiscovery' => 'Activer la découverte automatique du courrier',
    'mail-settings.mailAutodiscoveryDescription' => 'Pour en savoir plus sur le fonctionnement, consultez la %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'base de connaissances',
    'mail-settings.domainKeys' => 'Utiliser le système anti-spam DKIM pour signer les mails sortants',
    'mail-settings.greyListing' => 'Activer la protection anti-spam Greylisting pour tous les comptes sous ce domaine',
    'mail-settings.howToConfigureExternalDns' => 'Comment configurer le DNS externe',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Pour activer la signature DKIM si vous utilisez un serveur DNS externe, vous devez configurer vous-même les enregistrements DNS DKIM sur le serveur.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Pour cela, utilisez les enregistrements DNS DKIM suivants :',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Si vous utilisez des alias de domaine pour envoyer des mails, ajoutez également les enregistrements DNS DKIM pour ces alias. Utilisez les mêmes enregistrements que pour le domaine principal, mais avec le nom de l\'alias de domaine.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Pour voir les enregistrements DNS DKIM que vous devez configurer, cochez la case "%%option%%", appliquez et rouvrez ce pop-up.',

    'role.roleSection' => 'Général',
    'role.name' => 'Nom du rôle de l\'utilisateur',
    'role.description' => 'Description',
    'role.generalPermissionsSection' => 'Accès aux services de Plesk',
    'role.applicationsAccessSection' => 'Accéder aux applications',
    'role.permissionAllow' => 'Accordé',
    'role.permissionDeny' => 'Refusé',
    'role.emptyRoleName' => 'Veuillez fournir un nom de rôle.',
    'role.installedAt' => 'Installé(e) sur',
    'role.noInstallationUrlAvailable' => 'Application externe',
    'role.invalidRoleName' => 'Le nom du rôle de l\'utilisateur indiqué n\'est pas correct. Impossible d\'utiliser des points d\'interrogation, des apostrophes et des guillemets dans le nom du rôle.',
    'role.longRoleName' => 'Le nom du rôle de l\'utilisateur indiqué est trop long.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Certaines opérations risquent d\'être indisponibles pour les raisons suivantes : un droit pour exécuter cette opération n\'est pas accordé par l\'abonnement actuellement sélectionné ou la somme de ressources allouées n\'est pas suffisante pour exécuter une opération.',
    'role.servicesPermissionsDescription' => 'Définissez l\'accès aux applications installées ou aux services de Plesk pour tous les utilisateurs avec ce rôle. Si vous accordez un accès utilisateur à une application, cette dernière lui sera disponible dans le Panneau Client.',
    'role.emailActivation' => 'Activer les comptes de ce rôle par mail',

    'service.admin-access.adminAccess' => 'Accès administratif',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Ces identifiants d\'accès seront utilisés pour l\'accès admin à cette application.',
    'service.admin-access.login' => 'Nom d\'utilisateur admin',
    'service.admin-access.password' => 'Mot de passe admin',
    'service.admin-access.passwordConfirmation' => 'Confirmer le mot de passe',

    'service.info.service-entry-point.availableAt' => 'Disponible sur/le',
    'service.info.service-entry-point.customize' => 'Personnaliser le raccourci',
    'service.info.service-entry-point.displayNameLabel' => 'Nom du raccourci',
    'service.info.service-entry-point.displayNameDescription' => 'Indiquez un nom pour ce raccourci. Le nom est indiqué sous l\'icône du raccourci. Les raccourcis sont placés sur la page Mes Services des utilisateurs à qui l\'accès à cette application a été accordé.',
    'service.info.service-entry-point.descriptionLabel' => 'Description du raccourci',
    'service.info.service-entry-point.descriptionDescription' => 'Indiquez une description de ce raccourci. La description est affichée sous forme d\'infos-bulles lorsque le curseur de la souris passe sur le raccourci.',
    'service.info.service-entry-point.iconLabel' => 'Cliquez pour sélectionner l\'icône du raccourci',
    'service.info.service-entry-point.iconCurrent' => 'Icône actuelle',
    'service.info.service-entry-point.errorEmptyName' => 'Vous devez indiquer un nom de raccourci.',
    'service.info.service-entry-point.errorLongName' => 'Le nom du raccourci doit être compris entre 1 et 255 caractères.',
    'service.info.service-entry-point.errorLongDescription' => 'La description du raccourci doit être comprise entre 0 et 255 caractères.',
    'service.info.service-entry-point.hiddenLabel' => 'Masquer le raccourci',
    'service.info.service-entry-point.hiddenDescription' => 'N\'affichez pas ce raccourci pour les utilisateurs.',

    'service.info.service-permission.assignedUser' => "Accorder l'accès de l'administrateur à cet utilisateur",
    'service.info.service-permission.assignedUserNone' => 'Aucun utilisateur affecté',

    'shared-ssl.master-ssl.switchedOn' => 'Activer le SSL/TLS partagé',
    'shared-ssl.master-ssl.domainName' => 'Nom de domaine d\'un site dont le certificat SSL/TLS sera partagé avec d\'autres sites',
    'shared-ssl.master-ssl.none' => 'Aucun(e)',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Le SSL/TLS partagé ne peut pas être activé, car la prise en charge SSL/TLS n\'est activée sur aucun domaine.',

    'user.email.email' => 'Adresse mail',
    'user.email.emptyEmail' => 'Vous devez indiquer une adresse mail.',
    'user.email.internalEmailHint' => 'Créez une adresse mail dans Plesk ou utilisez une adresse mail externe.',
    'user.email.longInternalEmail' => 'L\'adresse mail est trop longue.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Le nom d\'utilisateur inclut dans l\'adresse mail est trop long pour ce serveur de messagerie. Précisez un nom d\'utilisateur de moins de %%max%% caractères.',
    'user.email.longInternalEmailFullAddressMailServer' => 'L\'adresse mail est trop longue pour ce serveur de messagerie. Précisez une adresse de moins de %%max%% caractères.',
    'user.email.externalEmail' => 'Adresse mail externe',
    'user.email.externalEmailHint' => 'Permettra de réinitialiser votre mot de passe si vous perdez l\'accès à l\'adresse mail principale.',
    'user.email.emailsIsEqual' => 'L\'adresse mail externe correspond à l\'adresse mail principale. Indiquez une autre adresse mail externe.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Veuillez saisir une adresse e-mail interne ou externe.',

    'user.profileSection' => 'Informations générales',
    'user.contactName' => 'Nom du contact',
    'user.email' => 'Adresse mail',
    'user.role' => 'Rôle de l\'utilisateur',
    'user.accountSection' => 'Préférences de Plesk',
    'user.login' => 'Nom d\'utilisateur',
    'user.password' => 'Mot de passe',
    'user.buttonBack' => 'Retour',
    'user.generalTab' => 'Général',
    'user.applicationsAccessSection' => 'Services',
    'user.generalPermissionsSection' => 'Privilèges',
    'user.contactsTab' => 'Détails du contact',
    'user.passwordConfirmation' => 'Confirmer le mot de passe',
    'user.internalEmailPasswordChanged' => 'La modification du mot de passe entraîne la modification du mot de passe de l\'adresse e-mail interne.',
    'user.emailName' => 'Adresse mail',
    'user.emailType' => 'Type de mail',
    'user.companyName' => 'Raison sociale',
    'user.phone' => 'Numéro de téléphone',
    'user.imNumber' => 'Messagerie instantanée',
    'user.fax' => 'Numéro de fax',
    'user.address' => 'Adresse',
    'user.city' => 'Ville',
    'user.state' => 'État/Province/Région',
    'user.zip' => 'Code postal ou CP',
    'user.country' => 'Pays',
    'user.additionalInfo' => 'Infos supplémentaires',
    'user.additionalInfoHint' => 'Texte brut uniquement : toutes les balises HTML seront ignorées.',
    'user.language' => 'Langue de Plesk',
    'user.buttonChangePassword' => 'Modifier le mot de passe',
    'user.permissionAllow' => 'Accordé',
    'user.permissionDeny' => 'Refusé',
    'user.permissionInherited' => 'Défini par le rôle',
    'user.emptyContactName' => 'Vous devez indiquer un nom de contact.',
    'user.emptyLogin' => 'Vous devez indiquer un nom d\'utilisateur.',
    'user.emptyPassword' => 'Vous devez indiquer un mot de passe.',
    'user.emptyPasswordConfirmation' => 'Vous devez confirmer le mot de passe.',
    'user.chooseDomainBoxTitle' => 'Sélectionner un autre domaine :',
    'user.userIsActive' => 'Utilisateur actif',
    'user.userIsActiveHint' => 'Les utilisateurs actifs peuvent accéder à Plesk.',
    'user.emailActivation' => 'Activer le compte par mail',
    'user.emailHint' => 'Pour donner à l\'utilisateur une adresse mail hébergée sur ce serveur, allez dans l\'onglet Mail, créez l\'adresse mail indiquée et associez-la à cet utilisateur.',
    'user.emailContactHint' => 'Contactez votre fournisseur de services si vous voulez utiliser une adresse mail hébergée sur ce serveur.',
    'user.personalEmailHint' => "L'adresse mail de cet utilisateur peut être changée dans l'onglet Mail.",
    'user.externalMailRedirectHint' => 'Le transfert ne peut être activé que pour les adresses mail hébergées sur ce serveur. Pour créer une adresse mail, allez dans l\'onglet Mail.',
    'user.externalMailRedirectHint2' => 'Le transfert ne peut être activé que pour les adresses mail hébergées sur ce serveur.',
    'user.externalMailAutoResponderHint' => 'La réponse automatique ne peut être activée que pour les adresses mail hébergées sur ce serveur. Pour créer une adresse mail, allez dans l\'onglet Mail.',
    'user.externalMailAutoResponderHint2' => 'La réponse automatique ne peut être activée que pour les adresses mail hébergées sur ce serveur.',
    'user.roleHint' => 'Rôle de l\'utilisateur',
    'user.cannotManageMail' => "Vous n'avez pas le droit de gérer les services et les paramètres de la messagerie.",
    'user.longCompanyName' => 'La raison sociale indiquée est trop longue.',
    'user.longPhone' => 'Le numéro de tél. indiqué est trop long.',
    'user.longFax' => 'Le numéro de fax indiqué est trop long.',
    'user.longAddress' => 'L\'adresse indiquée est trop longue.',
    'user.longCity' => 'Le nom de la ville indiqué est trop long.',
    'user.phoneRegexNotMatch' => 'Le numéro de téléphone précisé n\'est pas valide.',
    'user.faxRegexNotMatch' => 'Le numéro de fax indiqué n\'est pas valide.',
    'user.shortCity' => 'Le nom de la ville indiqué est trop court.',
    'user.limitSubscription' => 'Accès aux abonnements',
    'user.limitSubscriptionHint' => 'Autorisez les utilisateurs à n\'accéder qu\'à un abonnement indiqué. La valeur "Tout" leur accorde l\'accès à tous les abonnements dans votre compte d\'hébergement.',
    'user.limitSubscriptionAll' => 'Tout',
    'user.deletedSubscription' => 'Abonnement supprimé',

    'web.add-domain-alias.title' => 'Ajouter un alias de domaine',
    'web.add-domain-alias.createdSuccessfully' => "L'alias de domaine %%name%% a été créé.",
    'web.add-domain-alias.domainAliasName' => 'Alias du nom de domaine',
    'web.add-domain-alias.domainAliasNameHint' => 'Par exemple, exemple.net',
    'web.add-domain-alias.forDomain' => 'pour le domaine',
    'web.add-domain-alias.settingsSectionLegend' => 'Paramètres',
    'web.add-domain-alias.settingsDns' => 'Synchroniser la zone DNS avec le domaine primaire',
    'web.add-domain-alias.settingsMail' => 'Service de messagerie',
    'web.add-domain-alias.settingsWeb' => 'Service Web',
    'web.add-domain-alias.settingsSeoRedirect' => 'Utiliser la redirection permanente avec le code HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Lorsque les visiteurs cliquent sur l\'URL alias, ils sont redirigés vers l\'URL du domaine primaire. Plesk utilise la redirection permanente du moteur de recherche HTTP 301, ce qui signifie que le référencement du moteur de recherche est conservé.',
    'web.add-domain-alias.settingsTomcat' => 'Applications Web Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Non de domaine non valide',

    'web.add-domain.formTitle' => 'Ajout d\'un nouveau domaine',
    'web.add-domain.portalLink' => 'Portail de services',
    'web.add-domain.domainName' => 'Nom de domaine',
    'web.add-domain.domainNameHint' => "Par exemple, exemple.com",
    'web.add-domain.assignToCustomer' => 'Affecter ce domaine à un client',
    'web.add-domain.customer' => 'Sélectionner un client',
    'web.add-domain.createNewCustomer' => 'Créer un client',
    'web.add-domain.selectExistingCustomer' => 'Sélectionnez un client existant :',
    'web.add-domain.customerContactInfoHint' => 'Saisissez les informations de contact d\'un client. Vous pouvez préciser toutes les autres informations comme le numéro de téléphone et l\'adresse ultérieurement.',
    'web.add-domain.customerLoginInfoHint' => 'Identifiants d\'accès pour le panneau client',
    'web.add-domain.target' => 'Espace Web',
    'web.add-domain.createNewTarget' => 'Créer un abonnement',
    'web.add-domain.createNewTarget_powerUser' => 'Créer un espace Web',
    'web.add-domain.selectExistingTarget' => 'Sélectionnez un abonnement existant :',
    'web.add-domain.selectExistingTarget_powerUser' => 'Sélectionnez un espace Web existant :',
    'web.add-domain.dns' => 'Activer un service DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Activer un service de messagerie',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Fonctionne si les paramètres de l\'abonnement permettent la gestion des droits pour les mails par domaines. Si ces paramètres ne l\'autorisent pas, le statut réel du service de messagerie est récupéré au niveau de l\'abonnement.',
    'web.add-domain.hostingManagementOptions' => 'Type d\'hébergement',
    'web.add-domain.websiteHosting' => 'Hébergement du site Web',
    'web.add-domain.websiteForwarding' => 'Redirection',
    'web.add-domain.websiteNoHosting' => 'Aucun hébergement',
    'web.add-domain.hostingSettingsSectionLegend' => 'Paramètres d\'hébergement',
    'web.add-domain.domainCreatedSuccessfully' => 'Le domaine %%domainName%% a bien été créé.',
    'web.add-domain.webspaceLegend' => 'Paramètres de l\'espace Web',
    'web.add-domain.addWhmWebsiteTitle' => 'Ajout d\'un nouveau site Web',
    'web.add-domain.addWhmWebsiteHint' => "Vous pouvez choisir d'héberger un site Web sur le serveur.",
    'web.add-domain.selectWhmDomain' => 'Sélectionner le domaine',
    'web.add-domain.customerLegend' => 'Infos client',
    'web.add-domain.credentials' => 'Identifiants d\'accès de l\'utilisateur système',
    'web.add-domain.credentialsHint' => 'Permet l\'accès aux fichiers hébergés via FTP et SSH',
    'web.add-domain.credentialsHintWin' => 'pour accéder aux fichiers hébergés via FTP et RDP',
    'web.add-domain.buttonAddDomain' => 'Ajouter un domaine',

    'web.add-subdomain.formTitle' => 'Ajouter un sous-domaine',
    'web.add-subdomain.formGeneralHint' => 'Les sous-domaines sont des adresses Internet pour différentes sections de votre site Web. Ils utilisent votre nom de domaine principal et un préfixe. Par exemple, si votre domaine est domain.com, un sous-domaine peut être store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Vous pouvez également créer un sous-domaine wildcard en entrant le symbole * au lieu du nom. Les visiteurs du site seront redirigés vers ce sous-domaine indépendamment du sous-domaine qu\'ils indiqueront dans leur navigateur.',
    'web.add-subdomain.subdomainName' => 'Nom du sous-domaine',
    'web.add-subdomain.subdomainNameHint' => 'Entrez * pour créer un sous-domaine wildcard.',
    'web.add-subdomain.forDomain' => 'Domaine parent',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Le sous-domaine a été créé.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Paramètres d\'hébergement',

    'web.change-hosting.formGeneralHint' => 'Vous pouvez choisir d\'héberger le site Web sur le serveur (hébergement de sites Web), de configurer la redirection Web vers un autre site Web (Transfert) ou simplement d\'utiliser une zone DNS de domaine si vous voulez avoir les boîtes mail sous ce nom de domaine (Aucun d\'hébergement).',
    'web.change-hosting.changed' => 'Le type d\'hébergement pour %%domainName%% a bien été changé.',
    'web.change-hosting.hostingManagementOptions' => 'Type d\'hébergement',
    'web.change-hosting.websiteHosting' => 'Hébergement du site Web',
    'web.change-hosting.websiteForwarding' => 'Redirection',
    'web.change-hosting.websiteNoHosting' => 'Aucun hébergement Web',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Paramètres d\'hébergement',
    'web.change-hosting.userName' => 'Nom d\'utilisateur',
    'web.change-hosting.userNameHint' => 'Le compte utilisateur du système est utilisé pour gérer les fichiers et dossiers dans l\'abonnement.',
    'web.change-hosting.userNameHint_powerUser' => 'Le compte utilisateur du système est utilisé pour gérer les fichiers et dossiers dans l\'espace Web.',
    'web.change-hosting.emptyLogin' => 'Vous devez indiquer un nom d\'utilisateur.',
    'web.change-hosting.password' => 'Mot de passe',
    'web.change-hosting.emptyPassword' => 'Vous devez indiquer un mot de passe.',
    'web.change-hosting.passwordConfirmation' => 'Confirmer le mot de passe',
    'web.change-hosting.warningInstalledApplications' => 'Des applications Web sont installées sur le site. Si vous changez le type d\'hébergement, elles ne seront plus accessibles.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Avertissement : Le contenu de votre site Web sera modifié.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Voulez-vous modifier le type d\'hébergement pour votre site Web ?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'Les dossiers suivants et l\'ensemble de leur contenu seront supprimés :',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'L\'ensemble du contenu du dossier racine de l\'espace Web sera supprimé.',

    'web.change-status.changed' => 'Le statut du site Web pour %%domainName%% a bien été changé.',
    'web.change-status.statusManagementOptions' => 'Statut du site Web',
    'web.change-status.statusDisabled' => 'Désactivé (anciennement « suspendu »)',
    'web.change-status.statusSuspended' => 'Suspendu',
    'web.change-status.statusActive' => 'Actif',
    'web.change-status.statusDisabledHint' => 'Le site Web cessera d\'être hébergé sur le serveur et ne sera pas disponible, excepté pour les clients FTP et le Gestionnaire de fichiers. Les visiteurs verront la page par défaut du serveur. Le service de messagerie sera indisponible.',
    'web.change-status.statusSuspendedHint' => 'Le site Web restera hébergé sur le serveur, mais les visiteurs seront redirigés vers la page de document d\'erreur personnalisé à l\'aide du code HTTP 503. Le service de messagerie restera disponible. Ici, vous pouvez %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'Les visiteurs seront redirigés vers la page de document d\'erreur personnalisé à l\'aide du code HTTP 503, même si le site Web reste hébergé sur le serveur. Le service de messagerie restera disponible.',
    'web.change-status.error503PageLink' => 'modifier la page de document d\'erreur personnalisé',
    'web.change-status.statusActiveHint' => 'Le site Web fonctionnera normalement.',
    'web.change-status.notActivatedSuspended' => 'Le domaine ou site Web %%domainName%% n\'a pas pu être activé, car il a été suspendu par votre hébergeur.',
    'web.change-status.notActivatedDisabled' => 'Le domaine ou site Web %%domainName%% n\'a pas pu être activé, car il a été désactivé par votre hébergeur.',

    'web.edit.formTitle' => 'Accès à l\'hébergement Web pour %%name%%',
    'web.edit.formGeneralHint' => 'Dans cette section, vous pouvez voir les adresses IP associées à votre abonnement et changer le nom d\'utilisateur et le mot de passe de votre utilisateur système.',
    'web.edit.formGeneralHint_powerUser' => 'Sur cette page, vous pouvez voir les adresses IP associées à votre espace Web et changer le nom d\'utilisateur et le mot de passe de votre utilisateur système.',
    'web.edit.ipAddressesLegend' => 'Adresses IP',
    'web.edit.ipAddresses' => 'Adresses IP',
    'web.edit.certificateLegend' => 'Certificat',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (possédé par un autre utilisateur)',
    'web.edit.userAccountLegend' => 'Utilisateur système',
    'web.edit.systemUserHint' => 'Dans cette section, vous pouvez définir l\'utilisateur du système d\'exploitation qui gère les fichiers et les dossiers au sein de l\'abonnement, et ce, via FTP ou le Gestionnaire de fichiers. L\'utilisateur système est également autorisé à accéder à Plesk via le protocole SSH (sur Linux) ou via RDP (sur Windows) si les droits correspondants ont été accordés.',
    'web.edit.systemUserHint_powerUser' => 'Dans cette section, vous pouvez définir l\'utilisateur du système d\'exploitation qui gère les fichiers et les dossiers au sein de l\'espace Web, et ce, via FTP ou le Gestionnaire de fichiers. L\'utilisateur système est également autorisé à accéder à Plesk via le protocole SSH (sur Linux) ou via RDP (sur Windows) si les droits correspondants ont été accordés.',
    'web.edit.login' => 'Nom d\'utilisateur',
    'web.edit.emptyLogin' => 'Veuillez indiquer un nom d\'utilisateur.',
    'web.edit.password' => 'Mot de passe',
    'web.edit.passwordConfirmation' => 'Confirmer le mot de passe',
    'web.edit.emptyPassword' => 'Veuillez indiquer un mot de passe.',
    'web.edit.emptyPasswordConfirmation' => 'Veuillez confirmer le mot de passe.',
    'web.edit.shellUnix' => "Accéder au serveur via SSH",
    'web.edit.shellHintUnix' => "Accédez au serveur via SSH avec les identifiants d'accès d'un utilisateur système.",
    'web.edit.shellWin' => 'Accéder au serveur via Remote Desktop',
    'web.edit.shellHintWin' => "Accédez au serveur via Remote Desktop avec les identifiants d'accès d'un utilisateur système.",
    'web.edit.diskQuotaLegend' => 'Quota dur sur l\'espace disque',
    'web.edit.diskQuotaHint' => 'Le quota dur sur l\'espace disque est la limite du total d\'espace disque qui peut être utilisé. Si le quota dur est défini et si tout l\'espace disque alloué est utilisé, aucune autre opération ne pourra être exécutée sur les fichiers.',
    'web.edit.diskQuota' => 'Quota dur sur l\'espace disque',
    'web.edit.diskQuotaUnlimited' => 'Illimité',
    'web.edit.diskQuotaLimited' => '%%limit%% Mo',
    'web.edit.diskQuotaNotSupported' => 'Illimité. Le quota dur de disque n\'est pas pris en charge en raison de la configuration du système de fichiers du serveur.',
    'web.edit.limitMbUnits' => 'Mo',
    'web.edit.successfullyUpdated' => 'Les paramètres d\'hébergement ont bien été mis à jour.',
    'web.edit.affectedDomainsLegend' => 'Sites Web auxquels ces paramètres s\'appliquent',
    'web.edit.affectedDomainsHint' => 'Les espaces Web suivants seront associés à l\'utilisateur système actuel. Les modifications des paramètres d\'accès dans l\'hébergement Web que vous effectuez sur cette page s\'appliqueront à tous ces sites Web.',

    'web.mobile.create.formTitle' => 'Créer le site mobile',
    'web.mobile.create.formGeneralHint' => 'Indiquez le nom du site mobile : une URL qui permettra d\'accéder au site mobile. En général, les préfixes comme "m", "mob", "mobi", "mobile" etc. sont utilisés, par exemple : mobile.exemple.com. Vous pouvez utiliser cette URL dans un lien comme "Version mobile" sur votre site régulier afin que les visiteurs de votre site puissent switcher entre les versions régulière et mobile.',
    'web.mobile.create.prefix' => 'Nom du site',
    'web.mobile.create.emptySiteName' => 'Le nom du site mobile ne peut pas être vide sinon il entrerait en conflit avec votre site Web régulier.',

    'web.security-section.securitySectionLegend' => 'Sécurité',
    'web.security-section.securitySectionHint' => 'Pour protéger les transactions avec votre site, utilisez le protocole SSL/TLS qui chiffre toutes les données et les transfère sur une connexion sûre. Pour utiliser le protocole SSL/TLS, migrez ce site vers une adresse IP dédiée, installez un certificat SSL/TLS sur le site, puis sélectionnez-le ci-après.',
    'web.security-section.securitySectionSniHint' => 'Pour protéger les transactions avec votre site, utilisez le protocole SSL/TLS qui chiffre toutes les données et les transfère sur une connexion sûre. Pour utiliser le protocole SSL/TLS, un certificat SSL/TLS doit être installé sur le site, puis sélectionné ci-après.',
    'web.security-section.enableSslSupport' => 'Prise en charge SSL/TLS',
    'web.security-section.enableSslRedirect' => 'Redirection 301 permanente (SEO vérifié) de HTTP vers HTTPS',

    'web.seo-settings.seoRedirectDirection' => 'Domaine préféré',
    'web.seo-settings.seoRedirectDirectionHint' => 'Sélectionnez l\'URL (avec ou sans le préfixe www.) vers laquelle les visiteurs du site seront redirigés via une redirection HTTP 301 sans risque pour le référencement.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Aucun(e)',

    'web.settings.formGeneralHint' => 'Configurez les paramètres de l\'hébergement du site Web et sélectionnez les fonctions disponibles pour votre site.',
    'web.settings.hostingType' => 'Type d\'hébergement',
    'web.settings.websiteHosting' => 'Site Web',
    'web.settings.forwardingHosting' => 'Redirection',
    'web.settings.noHosting' => 'Aucun hébergement',
    'web.settings.changeHosting' => 'Changer',
    'web.settings.websiteStatus' => 'Statut du site Web',
    'web.settings.changeStatus' => 'Changer',
    'web.settings.active' => 'Actif',
    'web.settings.suspended' => 'Suspendu',
    'web.settings.disabled' => 'Désactivé',
    'web.settings.webScriptingSectionLegend' => 'Statistiques et scripts Web',
    'web.settings.webScriptingSectionHint' => 'Parmi les langages de script et de programmation suivants, indiquez ceux qui doivent être interprétés, exécutés ou traités par le serveur Web.',
    'web.settings.__asp_win_support' => 'Prise en charge de Microsoft ASP',
    'web.settings.__asp_dot_net_support' => 'Prise en charge de Microsoft ASP.NET',
    'web.settings.__asp_dot_net_version' => 'Version',
    'web.settings.__asp_dot_net_version_readonly' => 'version %%value%%',
    'web.settings.__ssi_support' => 'Prise en charge de SSI',
    'web.settings.__ssi_with_html' => 'utiliser SSI pour les fichiers *.htm, *.html',
    'web.settings.__php_support' => 'Prise en charge de PHP',
    'web.settings.__php_run_as' => 'exécuter PHP comme',
    'web.settings.__php_served_by_apache' => 'servi(e) par Apache',
    'web.settings.__php_served_by_nginx' => 'servi(e) par Nginx',
    'web.settings.__cgi_support' => 'Prise en charge de CGI',
    'web.settings.__cgi_bin_mode' => 'le répertoire cgi-bin est situé dans',
    'web.settings.__cgi_bin_mode_webspace' => 'le répertoire root de l\'espace Web',
    'web.settings.__cgi_bin_mode_www_root' => 'le document root de ce domaine',
    'web.settings.__cgi_bin_mode_old_style' => 'la racine de style antérieur de ce domaine',
    'web.settings.__cgi_bin_mode_readonly' => 'le répertoire cgi-bin est situé dans %%value%%',
    'web.settings.__perl_unix_support' => 'Prise en charge de Perl',
    'web.settings.__perl_win_support' => 'Prise en charge de Perl',
    'web.settings.__python_unix_support' => 'Prise en charge de Python',
    'web.settings.__python_win_support' => 'Prise en charge de Python',
    'web.settings.__fastcgi_unix_support' => 'Prise en charge FastCGI',
    'web.settings.__webstat_support' => 'Statistiques Web',
    'web.settings.__plesk_stat_protect' => 'Protéger l\'accès à vos statistiques Web avec votre nom d\'utilisateur et mot de passe FTP',
    'web.settings.__plesk_stat_protected' => 'L\'accès à vos statistiques Web est protégé par votre nom d\'utilisateur et votre mot de passe FTP.',
    'web.settings.__apache_errdocs' => 'Documents d\'erreurs personnalisés',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'Application FastCGI',
    'web.settings.__php_cgi_handler' => 'Application CGI',
    'web.settings.__php_isapi_handler' => 'Extension ISAPI',
    'web.settings.__php_version' => 'Version de PHP',
    'web.settings.__hosting_write_modify' => 'Autres droits d\'écriture et de modification',
    'web.settings.__hosting_webdeploy' => 'Publication Web Deploy',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Aucun(e)',
    'web.settings.activate' => 'Activer',
    'web.settings.deactivate' => 'Suspendre',
    'web.settings.__php_support_readonly' => 'version : %%version%%; gestionnaire : %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'non enregistré',
    'web.settings.domainName' => 'Nom de domaine',
    'web.settings.domainNameHint' => "Par exemple, exemple.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Mode compatibilité pour l\'ancienne option "Séparer le contenu SSL/TLS et non-SSL/TLS"',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Exécuter le site Web en mode compatibilité pour l\'ancienne option "Séparer le contenu SSL/TLS et non-SSL/TLS"',
    'web.settings.sameSslCompatibilityHint' => 'Vous voyez cette section car vous avez utilisé l\'option "Séparer le contenu SSL/TLS et non-SSL/TLS" avant de mettre à niveau. Dans Plesk 11, cette option est obsolète. Tous les sites Web créés dans Plesk 11 utilisent le même répertoire pour stocker le contenu disponible sur des connexions HTTP et HTTPS. Cela signifie que ce site fonctionne toujours en mode de compatibilité, mais vous ne pouvez plus le gérer via Plesk. Il est vivement recommandé de déplacer vos données du répertoire httpsdocs/ vers le répertoire httpdocs/, puis de désactiver le mode de compatibilité. Une fois le mode de compatibilité désactivé, vous ne pourrez plus le réactiver et cette section n\'apparaîtra plus. Notez que si vous installez des applications dans le répertoire httpsdocs/ alors que le mode de compatibilité est activé, ces applications ne seront pas accessibles depuis Internet. Pour installer des applications sous httpsdocs/, désactivez le mode de compatibilité.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'Les paramètres du site Web seront appliqués dans %%restartInterval%% minutes.',
    'web.settings.phpSettingsDescription' => 'Cette page affiche la configuration PHP pour le site Web. Ces paramètres sont spécifiques au site Web et n\'affectent pas les autres sites Web de l\'abonnement. Vous pouvez modifier la configuration PHP si l\'hébergeur vous accorde les droits correspondants. Vous pouvez personnaliser la configuration PHP, par exemple, pour limiter la consommation de ressources du système par les scripts PHP ou pour être conforme aux prérequis d\'une app Web particulière. Lorsque vous définissez la valeur d\'un paramètre sur Par défaut, PHP utilise la valeur du paramètre de la configuration PHP valable pour l\'ensemble du serveur.',
    'web.settings.phpSettingsAvailableVariables' => 'Vous pouvez utiliser les variables suivantes dans les valeurs des paramètres :',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} pour le répertoire racine des documents de ce site Web. La valeur actuelle est %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'Le répertoire root du document HTTPS est identique au HTTP.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'Le répertoire root du document HTTPS est %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} pour le répertoire racine des documents du site Web principal de l\'abonnement.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} pour le répertoire de stockage des fichiers temporaires.',
    'web.settings.phpSettingsPhpVersion' => 'Votre version de PHP : %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP est désactivé.',
    'web.settings.phpHandlerTypeHint' => 'Remarque : changer le type de gestionnaire PHP peut corrompre la fonctionnalité des scripts PHP existants sur ce site Web.',
    'web.settings.fpmDedicatedHandlerHint' => 'L\'utilisation de ce gestionnaire augmente la stabilité d\'un site Web, mais augmente également la consommation de la mémoire.',
    'web.settings.phpHandlerChangeHint' => 'Vous avez changé les paramètres du gestionnaire PHP. Si vous sauvegardez ces modifications, les scripts PHP sur votre site Web risquent de s\'arrêter pendant %%interval%% secondes en raison de la configuration de votre serveur.',
    'web.settings.phpHandlerTypeHelpLink' => 'Découvrir comment choisir les paramètres PHP les plus appropriés',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'Impossible d\'activer la prise en charge de PHP, car la configuration d\'hébergement actuelle n\'inclut aucune version PHP disponible pour ce domaine.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Découvrez comment activer d\'autres versions de PHP.',
    'web.settings.phpHandlerBroken' => 'Le gestionnaire PHP sélectionné actuellement est corrompu. Sélectionnez un autre gestionnaire.',
    'web.settings.phpHandlerOutdated' => '(Obsolète)',
    'web.settings.phpHandlerDeprecated' => '(Dépréciée)',

    'web.setupService.formTitle' => 'Service de configuration : %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Le service \'%%serviceReference%%\' a bien été mis à jour.',

    'web.site-copy.subdomainsGroup' => 'Sous-domaines de %%siteName%% :',
    'web.site-copy.destinationTypeSection' => 'Destination de la copie',
    'web.site-copy.destinationType' => 'Sélectionner l\'emplacement où les fichiers du site doivent être copiés',
    'web.site-copy.destinationTypeSite' => 'Site Web dans Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Copiez les fichiers du site vers un autre site qui vous appartient hébergé sous ce compte. Si vous avez un accès FTP vers un autre compte sur ce serveur, utilisez l\'option Stockage FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Copiez les fichiers du site vers un autre site hébergé sur ce serveur.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nom du site',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Impossible de copier les fichiers du site %%source%% copiés vers %%destination%%, car %%destination%% fait également partie de ces fichiers : la racine de son document est un sous-répertoire de la racine du document %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Impossible de supprimer les fichiers du site %%destination%%, car les fichiers %%source%% en font partie. La racine du document %%source%% est un sous-répertoire de %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Stockage FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Copiez les fichiers du site Web dans un compte FTP sur ce serveur ou un serveur externe.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Copiez les fichiers du site Web dans un compte FTP sur un serveur externe.',
    'web.site-copy.destinationTypeFtpHost' => "Nom d'hôte du serveur",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Répertoire',
    'web.site-copy.destinationTypeFtpUser' => 'Nom d\'utilisateur',
    'web.site-copy.destinationTypeFtpPassword' => 'Mot de passe',
    'web.site-copy.destinationTypeFtpMode' => 'Mode de connexion FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Mode actif',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'En mode actif, Plesk envoie son adresse IP et le numéro de port sur lequel il écoutera un serveur externe et le serveur initie la connexion TCP. Ce mode est conseillé si le serveur géré par Plesk n\'est pas protégé par un pare-feu.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Mode passif',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Le mode passif peut être utilisé lorsque le serveur géré par Plesk est situé derrière un pare-feu et est incapable d\'accepter les connexions TCP entrantes.',
    'web.site-copy.existingFiles' => 'Que faire avec les fichiers existants',
    'web.site-copy.existingFilesKeep' => 'Garder les fichiers existants sur le site cible',
    'web.site-copy.existingFilesKeepDescription' => 'Écrasez les fichiers existants avec les noms de fichiers correspondants sur le site de destination.',
    'web.site-copy.existingFilesDelete' => 'Supprimer tous les fichiers existants',
    'web.site-copy.existingFilesDeleteDescription' => 'Supprimez tous les fichiers sur le site cible avant la copie.',
    'web.site-copy.emptyLogin' => 'Indiquez un nom d\'utilisateur du compte FTP.',
    'web.site-copy.emptyHost' => 'Indiquez un nom d\'hôte du serveur.',
    'web.site-copy.emptyPort' => 'Indiquez un port d\'hôte du serveur.',
    'web.site-copy.copyInProgress' => 'Copie du site Web %%sourceName%% vers %%destinationName%%. Vous serez notifié de la progression par mail (%%email%%).',
    'web.site-copy.unableToCopy' => 'Échec de la copie des fichiers du site Web.',
    'web.site-copy.siteCopied' => 'Les fichiers du site Web ont été copiés.',
    'web.site-copy.emailSubjSuccess' => 'Les fichiers "%%source%%" du site Web ont été copiés.',
    'web.site-copy.emailSubjFailure' => 'Échec de la copie des fichiers "%%source%%" du site Web.',
    'web.site-copy.emailBodySuccess' => 'Les fichiers "%%source%%" du site Web ont été copiés vers "%%destination%%" :',
    'web.site-copy.emailBodyFailure' => 'Échec de la copie des fichiers "%%source%%" du site Web vers "%%destination%%" : %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Paramètres de redirection',
    'web._shared.forwardDestination' => 'Adresse de destination',
    'web._shared.forwardDestinationHint' => 'URL du site Web cible.',
    'web._shared.forwardingTypeOptions' => 'Type de redirection',
    'web._shared.forwardingFrame' => 'Redirection par cadre',
    'web._shared.forwardingFrameHint' => 'Redirigez les visiteurs du site Web vers un autre site mais ne leur indiquez pas l\'adresse de destination. Ils ne doivent rien savoir de la redirection.',
    'web._shared.forwardingHttpCode301' => 'Déplacé de façon permanente (code 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Redirigez les visiteurs du site Web vers un autre site et indiquez-leur l\'adresse de destination. Ce type de redirection préserve le référencement du site dans les moteurs de recherche.',
    'web._shared.forwardingHttpCode302' => 'Déplacé de façon temporaire (code 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Redirigez les visiteurs vers une copie temporaire du site si vous ne voulez pas que ce site temporaire soit indexé par les moteurs de recherche.',
    'web._shared.documentRoot' => 'Racine du document',
    'web._shared.documentRootHint' => 'Chemin d\'accès vers le répertoire principal du site Web.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Vous ne pouvez pas changer la racine du document car des applications Web sont installées sur ce site Web.',
    'web._shared.ipAddress' => 'Adresse IP',
    'web._shared.shared' => 'partagé',
    'web._shared.exclusive' => 'dédiée',
    'web._shared.ipAddressHint' => "L'adresse IP sur lequel le site Web est hébergé est une adresse réseau de l'hôte virtuel du site Web.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (autre répertoire)',
    'web._shared.certificate' => 'Certificat',
    'web._shared.sameCertificatesHint' => 'Le certificat sélectionné sera également utilisé pour tous les sites hébergés sur la même adresse IP dédiée.',
    'web._shared.differentCertificatesHint' => 'Cet abonnement est associé à deux adresses IP dédiées avec deux certificats différents. Le certificat sélectionné remplacera tout certificat installé sur les sites hébergés sur ces deux adresses IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Cet abonnement est associé à une adresse IP dédiée et une adresse IP partagée. Le certificat sélectionné sera également utilisé pour tous les autres sites hébergés sur l\'adresse IP dédiée.',
    'web._shared.certificateNotSelected' => 'Non sélectionné',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Il n\'y a aucun certificat SSL/TLS dans votre répertoire. Si vous voulez ajouter un certificat, allez sur %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'cette page',

    'web-user.settings.allowScripts' => 'Autoriser les utilisateurs Web à utiliser les scripts',

    'web-user.name' => 'Nom d\'utilisateur pour se connecter au serveur via FTP',
    'web-user.longName' => 'Ce nom d\'utilisateur est trop long (maximum %max% caractères sont autorisés).',
    'web-user.password' => 'Mot de passe',
    'web-user.passwordConfirmation' => 'Confirmer le mot de passe',
    'web-user.hardDiskQuota' => 'Quota dur de disque',
    'web-user.hardDiskQuotaUnlimited' => 'Illimité',
    'web-user.hardDiskQuotaIsNotSupported' => '(le quota dur de disque n\'est pas pris en charge en raison de la configuration du système de fichiers du serveur)',
    'web-user.megabytes' => 'Mo',

    'requiredFields' => 'Champs obligatoires',
];