<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'app.instances.title' => 'Aplicativos instalados',
    'app.instances.buttonCheckForUpdates' => 'Verificar atualizações',
    'app.instances.buttonScan' => 'Verificar',
    'app.instances.hintButtonScan' => 'Verificar arquivos na sua assinatura para os aplicativos.',
    'app.instances.taskScan' => 'Verificando por aplicativos...',
    'app.instances.undefinedApp' => 'Indefinido',
    'app.instances.name' => 'Nome',
    'app.instances.installedTo' => 'Caminho de instalação',
    'app.instances.uninstall' => 'Remover',
    'app.instances.update' => 'Atualização disponível',
    'app.instances.noUpdates' => 'Nenhuma atualização encontrada. Todos os aplicativos estão atualizados.',
    'app.instances.foundUpdates' => 'Atualizações disponíveis:',
    'app.instances.noInstallationUrlAvailable' => 'Nenhum',

    'app.packages.title' => 'Aplicativos disponíveis',
    'app.packages.name' => 'Nome',
    'app.packages.version' => 'Versão',
    'app.packages.summary' => 'Resumo',
    'app.packages.install' => 'Instalar',

    'app.services.title' => 'Serviços disponíveis',
    'app.services.serviceID' => 'ID de serviço',
    'app.services.name' => 'Nome',
    'app.services.summary' => 'Resumo',
    'app.services.instantiate' => 'Criar instância',

    'app.subserviceinstances.remove' => 'Remover',
    'app.subserviceinstances.hintRemove' => 'Remover as instâncias de serviço selecionadas.',
    'app.subserviceinstances.confirmOnDelete' => 'Deseja realmente remover as instâncias de serviço selecionadas?',
    'app.subserviceinstances.serviceName' => 'Nome do serviço',
    'app.subserviceinstances.userName' => 'Usuário',

    'contentfiles.name' => 'Nome',
    'contentfiles.changeDate' => 'Modificado',
    'contentfiles.size' => 'Tamanho',
    'contentfiles.permissions' => 'Permissões',
    'contentfiles.user' => 'Usuário',
    'contentfiles.group' => 'Grupo',
    'contentfiles.buttonUploadFiles' => 'Fazer Upload de Arquivo',
    'contentfiles.buttonUploadDirectory' => 'Diretório de Upload',
    'contentfiles.buttonImportFileViaUrl' => 'Importar arquivo via URL',
    'contentfiles.hintUploadFiles' => 'Efetuar upload dos arquivos para o diretório atual.',
    'contentfiles.buttonDeleteFile' => 'Remover',
    'contentfiles.hintDeleteFile' => 'Remover os arquivos selecionados.',
    'contentfiles.buttonPurgeFile' => 'Remover',
    'contentfiles.hintPurgeFile' => 'Remova permanentemente os arquivos selecionados.',
    'contentfiles.buttonPurgeAll' => 'Esvaziar Lixeira',
    'contentfiles.buttonRotationSettings' => 'Configurações de Rotação',
    'contentfiles.hintRotationSettings' => 'Personalize as configurações de rotação',
    'contentfiles.hintPurgeAll' => 'Remova permanentemente todos os arquivos e diretórios da Lixeira.',
    'contentfiles.buttonCopyFiles' => 'Copiar',
    'contentfiles.hintCopyFiles' => 'Copiar arquivos selecionados para outro diretório.',
    'contentfiles.buttonMoveFiles' => 'Mover',
    'contentfiles.hintMoveFiles' => 'Mover os arquivos selecionados para outro diretório.',
    'contentfiles.buttonMoreActions' => 'Mais',
    'contentfiles.buttonCalculateSize' => 'Calcular o tamanho',
    'contentfiles.hintCalculateSize' => 'Calcular o tamanho total dos arquivos selecionados.',
    'contentfiles.buttonChangeTimestamp' => 'Alterar o carimbo de data/hora',
    'contentfiles.hintChangeTimestamp' => 'Alterar a marcação de hora dos arquivos selecionados.',
    'contentfiles.buttonArchiveActions' => 'Arquivar',
    'contentfiles.buttonExtractArchive' => 'Extrair os arquivos',
    'contentfiles.hintExtractArchive' => 'Extrair os arquivos dos arquivos selecionados para o diretório atual.',
    'contentfiles.buttonCreateArchive' => 'Adicionar ao arquivo',
    'contentfiles.hintCreateArchive' => 'Adicionar os arquivos selecionados a um arquivo.',
    'contentfiles.buttonNewActions' => 'Novo',
    'contentfiles.buttonNewFile' => 'Criar o arquivo',
    'contentfiles.hintNewFile' => 'Criar um arquivo.',
    'contentfiles.buttonNewDirectory' => 'Criar o diretório',
    'contentfiles.hintNewDirectory' => 'Criar um diretório.',
    'contentfiles.rootDirectory' => 'Diretório Home',
    'contentfiles.buttonView' => 'Configurações',
    'contentfiles.hintView' => 'Alterar as configurações Gerenciador de Conteúdo.',
    'contentfiles.confirmOnDelete' => 'Tem certeza de que deseja remover permanentemente {count, plural, =1 {{name}} one {o # arquivo e diretório selecionado} other {os # arquivos e diretórios selecionados}}?',
    'contentfiles.confirmOnDeleteToTrash' => 'Mover {count, plural, =1 {{name}} one {o # arquivo e diretório selecionados} other {os # arquivos e diretórios selecionados}} para a Lixeira?',
    'contentfiles.deleteWithForce' => 'Pule a lixeira e remova permanentemente {count, plural, =1 {{name}} one {o # arquivo e diretório selecionado} other {os # arquivos e diretórios selecionados}}.',
    'contentfiles.confirmOnPurge' => 'Remover permanentemente {count, plural, =1 {{name}} one {o # arquivo e diretório selecionados} other {os # arquivos e diretórios selecionados}}?',
    'contentfiles.confirmOnPurgeAll' => 'Remover permanentemente todos os arquivos e diretórios da Lixeira?',
    'contentfiles.waitMessage' => 'Aguarde...',
    'contentfiles.readonlyHint' => 'Este diretório é somente para leitura: Você não pode criar arquivos ou diretórios.',
    'contentfiles.directoryNotFound' => 'Impossível encontrar o diretório %%directory%%: %%error%%',
    'contentfiles.symlinksOutOfWebspaceProhibited' => 'Os symlinks fora do espaço da web são proibidos %%symlink%%: %%error%%',
    'contentfiles.dragAndDropArea' => 'Solte diretórios ou arquivos aqui para fazer upload',
    'contentfiles.nonUTF8' => 'O Gerenciador de Arquivos não pode abrir arquivos e diretórios cujos nomes contenham caracteres que não sejam UTF-8.',
    'contentfiles.non4ByteChar' => 'O Gerenciador de arquivos não pode abrir arquivos e diretórios cujos nomes contenham caracteres de 4 bytes.',
    'contentfiles.searchInFilename' => 'Pesquisar no nome do arquivo',
    'contentfiles.searchInFilenameAndContent' => 'Pesquisar no nome do arquivo e conteúdo',
    'contentfiles.searchInContent' => 'Pesquisar no conteúdo',
    'contentfiles.menuItemFilename' => 'Apenas nome de arquivo',
    'contentfiles.menuItemFilenameAndContent' => 'Nome de arquivo e conteúdo',
    'contentfiles.menuItemContent' => 'Apenas conteúdo',
    'contentfiles.noEntriesFound' => 'Nenhum item encontrado.',
    'contentfiles.loadingTitle' => 'Procurando...',
    'contentfiles.searchError' => 'Impossível pesquisar arquivos no diretório atual.',
    'contentfiles.searchErrorTimeout' => 'A busca demorou muito e foi cancelada.',
    'contentfiles.item-action-view' => 'Exibir',
    'contentfiles.item-action-textCodeEditor' => 'Editar no Editor de Código',
    'contentfiles.item-action-visualEdit' => 'Editar no Editor de HTML',
    'contentfiles.item-action-textEdit' => 'Editar no Editor de Texto',
    'contentfiles.item-action-browse' => 'Abrir no navegador',
    'contentfiles.item-action-logBrowser' => 'Abrir no Navegador de Registro',
    'contentfiles.item-action-download' => 'Transferir',
    'contentfiles.item-action-permissions' => 'Alterar Permissões',
    'contentfiles.item-action-rename' => 'Renomear',
    'contentfiles.item-action-extractArchive' => 'Extrair os arquivos',
    'contentfiles.item-action-imageView' => 'Exibir',
    'contentfiles.imageViewer' => 'Visualizador de imagens',
    'contentfiles.tooltipReadOnly' => 'O diretório atual é somente leitura: você não pode criar arquivos ou diretórios nele.',

    'database.issues.type' => 'Tipo',
    'database.issues.table' => 'Tabela',
    'database.issues.code' => 'Código',
    'database.issues.problem' => 'Problema',
    'database.issues.icon-title-att' => 'Alerta',
    'database.issues.icon-title-warning' => 'Erro',

    'database.users.login' => 'Nome',
    'database.users.server' => 'Servidor do banco de dados',
    'database.users.database' => 'Bancos de dados',
    'database.users.remove' => 'Remover',
    'database.users.hintRemove' => 'Remover os usuários de banco de dados selecionados.',
    'database.users.confirmOnDelete' => 'Tem certeza que deseja remover {count, plural, =1 {o {login} usuários de banco de dados} one {o # usuário do banco de dados selecionado} other {os # usuários de banco de dados selecionados}}?',
    'database.users.disabledSelectHint' => 'Usado por um aplicativo da web instalado',
    'database.users.orphanedHint' => 'Tornado órfão após o processo de restauração, por favor %%orphanedRepairLink%% o usuário.',
    'database.users.orphanedRepairLink' => 'Consertar',
    'database.users.anyDatabase' => 'Qualquer banco de dados',
    'database.users.serverTypeMysql' => 'MySQL',
    'database.users.serverTypeMariadb' => 'MariaDB',
    'database.users.serverTypePercona' => 'Percona',
    'database.users.serverTypePostgresql' => 'PostgreSQL',
    'database.users.serverTypeMssql' => 'MS SQL',

    'databases.assignToSubscription' => 'Mover para a Assinatura',
    'databases.assignToSubscription_powerUser' => 'Mover para o espaço web',
    'databases.assignToSubscriptionPopupTitle' => 'Mover as Bases de Dados para Outra Assinatura',
    'databases.assignToSubscriptionPopupTitle_powerUser' => 'Mover as Bases de Dados para Outro Espaço Web',
    'databases.assignToSubscriptionPopupDesc' => 'Os bancos de dados selecionados serão movidos para a assinatura selecionada. Os usuários de banco de dados serão movidos também a menos que eles tenham acesso a outros bancos de dados.',
    'databases.assignToSubscriptionPopupDesc_powerUser' => 'Os bancos de dados selecionados serão movidos para o espaço web selecionado. Os usuários de banco de dados serão movidos também a menos que eles tenham acesso a outros bancos de dados. Observe que após mover, os usuários anteriores não poderão abrir o banco de dados para gerenciar seus conteúdos com a utilização do link no Plesk.',
    'databases.loading' => 'carregando',
    'databases.name' => 'Nome',
    'databases.type' => 'T',
    'databases.server' => 'Servidor de banco de dados',
    'databases.users' => 'Usuários',
    'databases.remove' => 'Remover',
    'databases.hintRemove' => 'Remover os bancos de dados selecionados.',
    'databases.confirmOnDelete' => 'Tem certeza de remover {count, plural, =1 {o {name} banco de dados} one {o # banco de dado selecionado} other {os # bancos de dados selecionados}}?',
    'databases.typeMysql' => 'MySQL',
    'databases.typeMariadb' => 'MariaDB',
    'databases.typePercona' => 'Percona',
    'databases.typePostgresql' => 'PostgreSQL',
    'databases.typeMssql' => 'Servidor MS SQL',
    'databases.serverMysql' => 'Servidor MySQL local',
    'databases.serverPostgresql' => 'Servidor PostgreSQL local',
    'databases.serverMssql' => 'Servidor MS SQL local',
    'databases.disabledSelectHint' => 'Usado por um aplicativo da web instalado',
    'databases.buttonMakeCopy' => 'Copiar',
    'databases.buttonMakeCopyHint' => 'Criar uma cópia exata do banco de dados ou copiar seu conteúdo para um banco de dados existente.',
    'databases.buttonWebadmin' => 'Webadmin',
    'databases.buttonWebadminHint' => 'Gerenciar os bancos de dados usando uma interface da web.',
    'databases.buttonConnectionInfo' => 'Informações de Conexão',
    'databases.buttonConnectionInfoHint' => 'Informações, como o nome de um host e as credenciais do usuário da base de dados, necessárias para conexão a esta base de dados.',
    'databases.buttonPhpMyAdmin' => 'phpMyAdmin',
    'databases.buttonMSSQLClientInstruction' => 'Baixe um Cliente SQL local',
    'databases.buttonMSSQLClientInstructionHint' => 'Baixe um Cliente SQL local',
    'databases.buttonDownloadDump' => 'Exportar Despejo',
    'databases.buttonDownloadDumpHint' => 'Exportar uma cópia desta base de dados.',
    'databases.buttonUploadDump' => 'Importar Despejo',
    'databases.buttonUploadDumpHint' => 'Importar sua cópia desta base de dados.',
    'databases.buttonDelete' => 'Remover o base de dados',
    'databases.buttonDeleteHint' => 'Remover esta base de dados.',
    'databases.buttonDeleteDisabledHint' => 'Não foi possível remover o banco de dados. Usado por um aplicativo da web instalado.',
    'databases.buttonDeleteConfirmationText' => 'Tem certeza de que deseja remover o banco de dados %%name%%?',
    'databases.buttonActiveList' => 'Lista Ativa',
    'databases.buttonActiveListHint' => 'Alternar entre os modos de visualização',
    'databases.buttonCheckAndFix' => 'Verificação e Reparo',
    'databases.buttonCheckAndFixHint' => 'Verificar problemas, como estrutura da tabela quebrada, e como resolvê-los.',
    'databases.buttonAssignToSubscription' => 'Mover para a Assinatura',
    'databases.buttonAssignToSubscriptionHint' => 'Mover as bases de dados para outra assinatura.',
    'databases.buttonAssignToSubscription_powerUser' => 'Mover para o espaço web',
    'databases.buttonAssignToSubscriptionHint_powerUser' => 'Mover as bases de dados para outro espaço web.',
    'databases.promptPassword' => 'Insira a senha para efetuar o login como o usuário de banco de dados %%login%%.',
    'databases.promptPasswordPopupTitle' => 'Forneça a senha',
    'databases.taskCheckDatabase' => 'Verificar base de dados',
    'databases.taskRepairDatabase' => 'Reparar a base de dados',
    'databases.downloadTask' => 'Preparando um despejo da %%database%% para exportação…',
    'databases.downloadPopupTitle' => 'Exportar Despejo',
    'databases.downloadHint' => 'Você está prestes a criar um despejo da %%database%% e fazer seu download.',
    'databases.downloadRelativePath' => 'Salvar o despejo no próximo diretório',
    'databases.downloadDumpName' => 'Nome do arquivo de despejo',
    'databases.downloadDumpAutomatically' => 'Despejar automaticamente o download após criação',
    'databases.errorDumpNameEmpty' => 'Forneça um nome de descarga.',
    'databases.errorDumpNameInvalid' => 'Um nome de descarga não pode conter nenhum dos seguintes caracteres: %%chars%%.',
    'databases.errorDumpNameTooLong' => 'O nome do arquivo de despejo especificado é muito longo. Um caminho de despejo completo não deve ser maior do que símbolos %%maxLength%%.',
    'databases.uploadTask' => 'Importando um despejo da %%database%%…',
    'databases.uploadPopupTitle' => 'Importar Despejo da Base de Dados',
    'databases.uploadHint' => 'Atualizar um despejo de seu computador local ou importar um despejo armazenado no seu servidor de hospedagem.',
    'databases.uploadFromFile' => 'Upload',
    'databases.uploadFromWebspace' => 'Importar',
    'databases.recreateDatabase' => 'Recriar a base de dados',
    'databases.uploading' => 'Importando...',
    'databases.waitMessage' => 'Aguarde...',
    'databases.rootDirectory' => 'Diretório raiz',
    'databases.connectionInfoTitle' => 'Informações de Conexão para %%database%%',
    'databases.connectionInfoDesc' => 'Você pode utilizar esses detalhes de conexão de base de dados, por exemplo, quando você for questionado sobre especificá-los durante a instalação de um aplicativo da web.',
    'databases.connectionInfoServerAddress' => 'Host',
    'databases.connectionInfoDatabaseName' => 'Nome da base de dados',
    'databases.connectionInfoUserLogin' => 'Nome de usuário',
    'databases.connectionInfoUserPassword' => 'Senha',
    'databases.connectionInfoNoUserLogin' => 'Nenhum usuário padrão',
    'databases.buttonClose' => 'Fechar',
    'databases.nothingFound' => "Nenhuma correspondência encontrada",
    'databases.moreObjectsAvailable' => 'Há %%count%% objetos a mais disponíveis.',

    'dnsaclrecords.value' => 'Endereço IP',
    'dnsaclrecords.add' => 'Adicionar endereço IP',
    'dnsaclrecords.remove' => 'Remover',
    'dnsaclrecords.hintRemove' => 'Remover os endereços de IP selecionados.',
    'dnsaclrecords.confirmOnDelete' => 'Remover os endereços de IP selecionados?',
    'dnsaclrecords.emptyViewTitle' => 'A transferência de zona não é permitida',
    'dnsaclrecords.emptyViewDescription1' => 'Por motivos de segurança, você pode permitir a transferência da zona DNS apenas para servidores especificados nos registros NS da zona.',
    'dnsaclrecords.emptyViewDescription2' => 'Para especificar um ou mais servidores para os quais você permite a transferência, clique em "Adicionar endereço IP".',

    'dnsrecords.host' => 'Host',
    'dnsrecords.type' => 'Tipo de registro',
    'dnsrecords.value' => 'Valor',
    'dnsrecords.nameServer' => 'Servidor de nomes',
    'dnsrecords.ipAddress' => 'Endereço IP',
    'dnsrecords.ttl' => 'TTL',
    'dnsrecords.buttonCheckHint' => 'Teste a zona DNS no servidor de nome.',
    'dnsrecords.remove' => 'Remover',
    'dnsrecords.removeRecord' => 'Remover %%selectedRowTitle%%? Você não pode desfazer esta ação.',
    'dnsrecords.removeRecords' => 'Remover %%selectedRows%% registros? Você não pode desfazer esta ação.',
    'dnsrecords.hintRemove' => 'Excluir os registros DNS selecionados.',
    'dnsrecords.confirmOnDelete' => 'Tem certeza que deseja remover {count, plural, =1 {o {host} registro DNS} one {o # registro DNS selecionado} other {o # registros DNS selecionado}}?',
    'dnsrecords.turnOff' => 'Desabilitar',
    'dnsrecords.hintTurnOff' => 'Desativar o serviço DNS local para a zona DNS %%name%%',
    'dnsrecords.turnOn' => 'Habilitar',
    'dnsrecords.hintTurnOn' => 'Ativar o serviço DNS local para a zona %%name%%',
    'dnsrecords.toggleTypeToSlave' => 'Alternar para Secundário',
    'dnsrecords.toggleTypeToMaster' => 'Alternar para Primário',
    'dnsrecords.hintToggleTypeToMaster' => 'Faça com que este servidor atue como o nome de servidor primário da zona %%name%%.',
    'dnsrecords.hintToggleTypeToSlave' => 'Faça com que este servidor atue como o nome de servidor secundário da zona %%name%%.',
    'dnsrecords.hintToggleTypeDisabled' => 'Não é possível alternar o modo de serviço da zona DNS porque a zona DNS %%name%% é atendida por outro servidor.',
    'dnsrecords.addRecord' => 'Adicionar registro',
    'dnsrecords.hintSpecifyNameServer' => 'Especifique o novo servidor de nomes para %%name%%',
    'dnsrecords.hintAddPrimaryDns' => 'Adicionar um servidor DNS primário para %%name%%',
    'dnsrecords.hintAddRecord' => 'Crie um registro de recursos na zona DNS %%name%%',
    'dnsrecords.restoreDefault' => 'Redefinir para Padrão',
    'dnsrecords.hintRestoreDefault' => 'Recrie a zona DNS de acordo com o modelo DNS de todo o servidor. Todos os registros do recurso personalizados serão removidos, e todas as alterações feitas na zona pelo usuário serão perdidas.',
    'dnsrecords.syncZone' => 'Aplicar o Modelo DNS',
    'dnsrecords.hintSyncZone' => 'Aplicar as alterações realizadas no modelo DNS de todo o servidor para a zona. Novos registros do recurso podem ser adicionados, e os existentes podem ser removidos. Os registros do recurso adicionados ou editados pelo usuário não serão afetados.',
    'dnsrecords.applyChanges' => 'As alterações feitas nos registros DNS ainda não foram salvas. As alterações são marcadas na lista de registros. Clique em atualizar para aceitar as alterações para a zona DNS. Clique em reverter para cancelar as alterações.',
    'dnsrecords.updateButtonTitle' => 'Atualizar',
    'dnsrecords.updateButtonDescription' => 'Salvar as alterações feitas nos registros DNS.',
    'dnsrecords.revertButtonTitle' => 'Reverter',
    'dnsrecords.revertButtonDescription' => 'Cancelar as alterações feitas nos registros DNS.',
    'dnsrecords.syncZoneFrom' => 'Aplicar as alterações do modelo DNS',
    'dnsrecords.moreActions' => 'Mais ações',
    'dnsrecords.search' => 'Buscar',
    'dnsrecords.templateNotSynchronized' => 'O modelo de DNS foi alterado e será aplicado a todos os domínios recém-criados. Você também pode %%link%%',
    'dnsrecords.templateNotSynchronizedLinkText' => 'aplicar as alterações a todos os domínios hospedados',
    'dnsrecords.soaTemplateNotSynchronized' => 'O modelo SOA foi alterado e será aplicado a todos os domínios recém-criados. Você também pode %%link%%',

    'emails.name' => 'Endereço de e-mail',
    'emails.owner' => 'Usuário',
    'emails.remove' => 'Remover',
    'emails.addNewEmail' => 'Criar um Endereço de E-mail',
    'emails.hintAddNewEmail' => 'Criar um endereço de e-mail e atribuir a um usuário.',
    'emails.recalculateUsage' => 'Atualize as estatística de uso',
    'emails.hintRecalculateUsage' => 'Recalcule o espaço de disco real usado pelas caixas de correio.',
    'emails.outgoingSpamSettings' => 'Limitar Mensagens de Saída',
    'emails.hintOutgoingSpamSettings' => 'Definir um limite nas mensagens de saída para as caixas de e-mail selecionadas. Não será possível enviar mais mensagens do que as especificadas em cada caixa de e-mail.',
    'emails.searchByEmail' => 'Endereço de email',
    'emails.hintRemove' => 'Remover os endereços de e-mail selecionados.',
    'emails.webMailDisabledHint' => 'O software de webmail não está instalado.',
    'emails.webMailHint' => 'Abra o webmail para este endereço de e-mail em uma nova janela do navegador.',
    'emails.editHint' => 'Saiba como configurar sua conta de e-mail em um programa cliente de e-mail, tal como o Microsoft Outlook, Outlook Express, Thunderbird e Apple Mail.',
    'emails.confirmOnDelete' => 'Tem certeza que deseja remover {count, plural, =1 {o {name} endereço de e-mail } one {o # endereço de e-mail selecionado} other {os # endereços de e-mail selecionados}}?',
    'emails.redirectDetailsSingle' => '%%firstAddress%%',
    'emails.redirectDetailsMultiple' => '%%firstAddress%% (e %%countLeft%% mais)',
    'emails.autoresponderEnabled' => 'A resposta automática está ativada.',
    'emails.autoresponderEnabledTill' => 'A resposta automática é ativada até %%endDate%%.',
    'emails.spaceUsage' => 'Uso',
    'emails.noMailbox' => 'Não existe caixa de correio',
    'emails.statusNotOperable' => 'O serviço de e-mail está desativado.',

    'failedrequestfiles.downloadZip' => 'Fazer o download do ZIP',
    'failedrequestfiles.downloadZipHint' => 'Fazer o download dos arquivos selecionados em um arquivo ZIP.',
    'failedrequestfiles.name' => 'Nome',
    'failedrequestfiles.modificationDate' => 'Data de modificação',
    'failedrequestfiles.remove' => 'Remover',
    'failedrequestfiles.hintRemove' => 'Excluir os arquivos solicitados com falha selecionados?',
    'failedrequestfiles.confirmOnDelete' => 'Remover os arquivos solicitados com falha selecionados?',
    'failedrequestfiles.viewHint' => 'Clique para visualizar o arquivo solicitado com falha.',
    'failedrequestfiles.buttonChangeTracing' => 'Alterar Opções de Rastreamento',
    'failedrequestfiles.buttonChangeTracingHint' => 'Altere as configurações de rastreamento da solicitação falha definida atualmente.',
    'failedrequestfiles.buttonDisableTracing' => 'Interromper o Rastreamento',
    'failedrequestfiles.buttonDisableTracingHint' => 'Interromper o Rastreamento.',
    'failedrequestfiles.buttonEnableTracing' => 'Iniciar o Rastreamento',
    'failedrequestfiles.buttonEnableTracingHint' => 'Iniciar o Rastreamento.',
    'failedrequestfiles.buttonRefresh' => 'Atualizar',
    'failedrequestfiles.buttonRefreshHint' => 'Clique aqui para exibir todas as solicitações falhas correspondentes aos critérios especificados. Observe que as solicitações falhas recém-inseridas não são exibidas automaticamente.',

    'files.name' => 'Nome',
    'files.modificationDate' => 'Modificado',
    'files.size' => 'Tamanho',
    'files.share' => 'Compartilhar',
    'files.shareHint' => 'Mova os arquivos selecionados para a pasta Arquivos compartilhados, tornando-os acessíveis para todos os funcionários autorizados no Plesk.',
    'files.publish' => 'Publicar',
    'files.publishHint' => 'Copie os arquivos selecionados para a pasta Arquivos públicos, tornando-os publicamente acessíveis para seus clientes e visitantes no website. O acesso aos arquivos pode ser protegido por senha.',
    'files.email' => 'Link de e-mail',
    'files.emailHint' => 'Envie um e-mail com link para acessar os arquivos selecionados para outros funcionários e clientes.',
    'files.delete' => 'Remover',
    'files.deleteHint' => 'Excluir os arquivos selecionados',
    'files.moreActions' => 'Mais',
    'files.createFolder' => 'Nova pasta',
    'files.createFolderHint' => 'Criar pasta na pasta atual',
    'files.copy' => 'Copiar',
    'files.copyHint' => 'Copie os arquivos ou pastas selecionados para um destino de sua escolha.',
    'files.move' => 'Mover',
    'files.moveHint' => 'Mova os arquivos ou pastas selecionados para um destino de sua escolha.',
    'files.protectedDescription' => 'O acesso aos arquivos nesta pasta é protegido por senha. A senha será solicitada aos usuários quando tentarem acessar os arquivos.',
    'files.nothingSelected' => 'Nenhum arquivo ou pasta selecionado.',

    'gitrepositories.lastCommitInfo' => 'Última informação comprometida:',
    'gitrepositories.deploymentActions' => 'Ações de implantação adicionais:',

    'logfiles.name' => 'Nome',
    'logfiles.path' => 'Atalho',
    'logfiles.modificationDate' => 'Data de modificação',
    'logfiles.fileSize' => 'Tamanho',
    'logfiles.logRotation' => 'Rotação de logs',
    'logfiles.logRotationHint' => 'Definir as configurações de rotação de logs para o web site.',
    'logfiles.logRotationTitle' => 'Configurar rotação de log',
    'logfiles.remove' => 'Remover',
    'logfiles.hintRemove' => 'Excluir os arquivos de log selecionados. Você pode excluir somente arquivos de log processados.',
    'logfiles.confirmOnDelete' => 'Remover os arquivos de log selecionados?',
    'logfiles.viewHint' => 'Clique para visualizar o arquivo de log.',
    'logfiles.buttonDownloadHint' => 'Clique para fazer o download do arquivo de log.',
    'logfiles.buttonViewHint' => 'Clique para visualizar o arquivo de log em uma nova janela.',
    'logfiles.addCustomLog' => 'Adicionar um registro personalizado',
    'logfiles.addCustomLogHint' => 'Abrir qualquer arquivo no Registro do Navegador.',
    'logfiles.customLogPopupTitle' => 'Adicionar um registro personalizado',
    'logfiles.invalidLogFormat' => 'O arquivo de registro tem formato não suportado.',
    'logfiles.buttonUnlinkHint' => 'Clique para parar o rastreamento das atualizações neste arquivo no Registro do Navegador',
    'logfiles.buttonUnlinkConfirmationDescription' => 'Tem certeza que deseja parar de rastrear as atualizações neste arquivo no Registro do Navegador?',
    'logfiles.buttonUnlinkConfirmationYes' => 'Sim',
    'logfiles.buttonUnlinkConfirmationNo' => 'Não',
    'logfiles.accessLog' => 'Acesso Apache',
    'logfiles.accessLogProcessed' => 'Acesso Apache (rotacionado)',
    'logfiles.accessSslLog' => 'Acesso Apache SSL/TLS',
    'logfiles.accessSslLogProcessed' => 'Acesso Apache SSL/TLS (rotacionado)',
    'logfiles.errorLog' => 'Erro do Apache',
    'logfiles.proxyAccessLog' => 'Acesso nginx',
    'logfiles.proxyAccessSslLog' => 'Acesso nginx SSL/TLS',
    'logfiles.proxyErrorLog' => 'Erro nginx',
    'logfiles.phpErrorLog' => 'Erro PHP',
    'logfiles.iisAccessLog' => 'Acesso ISS',
    'logfiles.iisLog' => 'IIS (%%name%%)',
    'logfiles.audit' => 'ModSecurity',
    'logfiles.passenger' => 'Node.js',
    'logfiles.iisnode' => 'Node.js',
    'logfiles.laravel' => 'Laravel',
    'logfiles.dotnetcore' => '.NET Core',

    'maillists.title' => 'Malas diretas',
    'maillists.remove' => 'Remover',
    'maillists.name' => 'Endereço',
    'maillists.subscribers' => 'Assinantes',
    'maillists.hintRemove' => 'Remover as malas diretas selecionadas.',
    'maillists.confirmOnDelete' => 'Remover as malas diretas selecionadas?',
    'maillists.openWebPanel' => 'Gerenciar a lista',
    'maillists.statusNotEnabled' => 'Desativado.',
    'maillists.statusNotOperable' => 'O serviço de mala direta está desativado.',

    'mailsettings.name' => 'Nome do domínio',
    'mailsettings.mailService' => 'Serviço de e-mail',
    'mailsettings.webmail' => 'WebMail',
    'mailsettings.nonexist' => 'E-mail enviado para usuários inexistentes',
    'mailsettings.webmailNone' => 'Nenhuma',
    'mailsettings.nonExistBounce' => 'Devolução com mensagem',
    'mailsettings.nonExistCatch' => 'Enviar para %%catchAddress%%',
    'mailsettings.nonExistCatchDescription' => 'O endereço de e-mail deve pertencer ao domínio selecionado. Somente o administrador pode especificar um endereço externo ou um endereço para diversos domínios',
    'mailsettings.nonExistExternal' => 'Enviar para %%catchIp%%',
    'mailsettings.nonExistReject' => 'Rejeitar',
    'mailsettings.nonExistDiscard' => 'Rejeitar',
    'mailsettings.statusEnabled' => 'Liga',
    'mailsettings.statusDisabled' => 'Desliga',
    'mailsettings.statusDisabledIncoming' => 'Entrada desabilitada',
    'mailsettings.statusNotConfigured' => 'Não configurado',
    'mailsettings.searchByName' => 'Nome do domínio',
    'mailsettings.editOutgoingSpamSettings' => 'Editar limite',
    'mailsettings.numberOutgoingMessages' => 'Número de mensagens de saída',

    'roles.title' => 'Funções de usuário',
    'roles.name' => 'Nome da função',
    'roles.description' => 'Descrição',
    'roles.remove' => 'Remover',
    'roles.numberOfUsers' => 'Usuários',
    'roles.hintRemove' => 'Remover as funções de usuário selecionadas. As funções podem ser removidas apenas se não estiverem atribuídas a nenhuma conta de usuário.',
    'roles.disabledSelectHint' => 'Esta função foi atribuída a uma ou mais contas de usuário. As funções podem ser removidas apenas se não estiverem atribuídas a nenhuma conta de usuário.',
    'roles.builtInItemHint' => 'Esta função não pode ser editada ou removida.',
    'roles.confirmOnDelete' => 'Remover as funções de usuário selecionadas?',

    'sites.selectdns.domain' => 'Domínio',
    'sites.selectdns.dnsStatus' => 'Status',
    'sites.selectdns.statusOff' => 'A gestão de zonas de DNS está desativada.',
    'sites.selectdns.statusMaster' => 'A zona de DNS está em modo mestre.',
    'sites.selectdns.statusSlave' => 'A zona de DNS está em modo escravo.',
    'sites.selectdns.linkManage' => 'Gerenciar',

    'sites.selectfrontpage.domain' => 'Domínio',
    'sites.selectfrontpage.linkManage' => 'Gerenciar',

    'sites.selectsimple.domain' => 'Domínio',
    'sites.selectsimple.linkManage' => 'Gerenciar',
    'sites.selectsimple.linkView' => 'Visualizar',

    'sites.selectstatistics.domain' => 'Domínio',
    'sites.selectstatistics.linkView' => 'Visualizar',

    'sites.selecttrafficstatistics.domain' => 'Domínio',
    'sites.selecttrafficstatistics.linkView' => 'Visualizar',

    'sites.selectwebdeploy.domain' => 'Domínio',
    'sites.selectwebdeploy.linkDownload' => 'Efetuar o download',

    'sites.unitymobile.website' => 'Site',
    'sites.unitymobile.mobileSite' => 'Nome do site móvel',
    'sites.unitymobile.createSite' => 'Criar site móvel',
    'sites.unitymobile.launchEditor' => 'Editar o conteúdo do site',
    'sites.unitymobile.changeSiteName' => 'Alterar o nome do site',
    'sites.unitymobile.delete' => 'Remover',
    'sites.unitymobile.confirmDeleteTitle' => 'Deseja realmente remover este site móvel?',
    'sites.unitymobile.confirmDeleteDescription' => 'Todo o conteúdo do site será perdido.',

    'sites.domainHeader' => 'Domínio',
    'sites.hostingHeader' => 'Hospedagem',
    'sites.diskUsage' => 'Uso do Disco',
    'sites.traffic' => 'Tráfego',
    'sites.buttonAddDomain' => 'Adicionar Domínio',
    'sites.buttonAddDomainHint' => 'Você pode hospedar um novo site neste servidor, configurar o redirecionamento de internet para outro site ou configurar uma zona de DNS de domínio, se desejar ter apenas endereços de e-mail em um nome de domínio.',
    'sites.buttonAddSubdomain' => 'Adicionar Subdomínio',
    'sites.buttonAddSubdomainHint' => 'Crie um site identificado por um nome de domínio de terceiro nível, por exemplo, shop.example.com.',
    'sites.buttonAddDomainAlias' => 'Adicionar nomes alternativos de domínio',
    'sites.buttonAddDomainAliasHint' => 'Configurar um nome de domínio adicional para seu site.',
    'sites.buttonRemove' => 'Remover',
    'sites.buttonRemoveHint' => 'Remover os sites selecionados e todo o seu conteúdo web, incluindo aplicativos e dados de e-mail.',
    'sites.buttonActivate' => 'Ativar',
    'sites.buttonSuspend' => 'Suspender',
    'sites.buttonClassicList' => 'Lista Clássico',
    'sites.buttonClassicListHint' => 'Alternar entre os modos de visualização',
    'sites.buttonActiveList' => 'Lista Ativa',
    'sites.buttonActiveListHint' => 'Alternar entre os modos de visualização',
    'sites.buttonDynamicList' => 'Lista Dinâmica',
    'sites.buttonDynamicListHint' => 'Alternar entre os modos de visualização',
    'sites.buttonFileManager' => 'Gerenciador de Arquivo',
    'sites.buttonMail' => 'E-mail',
    'sites.buttonDatabases' => 'Bases de dados',
    'sites.buttonDatabasesCreate' => 'Adicionar Base de Dados',
    'sites.buttonDatabasesTogglerText' => 'ou',
    'sites.buttonDatabasesToggle' => 'Selecionar base de dados existentes',
    'sites.buttonDatabasesEdit' => 'abrir',
    'sites.buttonDatabasesPromptPassword' => 'Insira a senha para efetuar o login como o usuário de banco de dados %%login%%.',
    'sites.removeConfirmation' => 'Tem certeza que deseja remover {count, plural, =1 {o {name} website} one {o # website selecionado} other {os # websites selecionados}}?',
    'sites.removeConfirmationSubscription' => "Os seguintes websites também serão removidos:\n%%domains%%",
    'sites.manageFilesHint' => 'Vá para a pasta de websites para gerenciar arquivos do website.',
    'sites.sitebuilderHint' => 'Editar o site no Presence Builder.',
    'sites.webstatisticsHint' => 'Visualizar estatísticas de visitas ao website.',
    'sites.webstatisticsSslHint' => 'Visualizar os relatórios sobre como seus sites são visitados por meio do SSL/TLS.',
    'sites.certificatesHint' => 'Gerenciar certificados SSL/TLS.',
    'sites.logsHint' => 'Visualizar logs.',
    'sites.previewHint' => 'Visualizar o website em seu navegador. Observe que alguns scripts e animações flash utilizados no site podem não funcionar no modo de pré-visualização.',
    'sites.dnsHint' => 'Alterar as configurações de zona DNS.',
    'sites.disabledSelectHint' => 'O domínio não pode ser removido.',
    'sites.websiteAt' => 'Website em',
    'sites.noHosting' => 'Sem hospedagem web',
    'sites.forwardingTo' => 'Redirecionar para',
    'sites.add' => 'adicionar',
    'sites.name' => 'Nome de domínio',
    'sites.inactive' => 'Inativo',
    'sites.disabled' => 'Desabilitado',
    'sites.suspended' => 'Suspenso',
    'sites.moreActions' => 'Mais ações',
    'sites.domainAliasDescription' => 'Nome alternativo para %%siteDisplayName%% %%servicesDescription%%',
    'sites.domainAliasServiceDescription' => '(Serviços ativados: %%service%%)',
    'sites.domainAliasServicesDescription' => '(Serviços ativados: %%services%%)',
    'sites.web' => 'Web',
    'sites.mail' => 'E-mail',
    'sites.dns' => 'DNS',
    'sites.tomcat' => 'Aplicativos Java',
    'sites.seoRedirect' => 'Redirecionamento',
    'sites.sitebuilder' => 'Presence Builder',
    'sites.sitebuilderLink' => 'Editar Site',
    'sites.error503PageLink' => 'Editar página de erro',
    'sites.modeTitle' => 'Modo de Visualização',
    'sites.quickStart' => 'Comece a criar seu website de uma das seguintes maneiras:',
    'sites.quickStartSitebuilderName' => 'Usar o Presence Builder',
    'sites.quickStartSitebuilderDescription' => 'Criar seu site usando nosso construtor de site profissional.',
    'sites.quickStartSitebuilderLink' => 'Criar Site',
    'sites.quickStartApplicationsName' => 'Instalar um aplicativo',
    'sites.quickStartApplicationsDescription' => 'Comece a criar o seu site instalando um aplicativo da web, como o Joomla ou Drupal.',
    'sites.quickStartApplicationsLink' => 'Instalar aplicativos',
    'sites.quickStartCustomName' => 'Criar um site personalizado',
    'sites.quickStartCustomDescription' => 'Fazer upload de seu conteúdo da web e adicionar bancos de dados.',
    'sites.quickStartCustomFilesLink' => 'Arquivos',
    'sites.quickStartCustomDatabasesLink' => 'Bancos de dados',
    'sites.resellerDescription' => 'Revendedor',
    'sites.ownerDescription' => 'Cliente',

    'sslcertificates.name' => 'Nome',
    'sslcertificates.used' => 'Utilizado',
    'sslcertificates.csrHint' => 'Parte de CSR fornecida.',
    'sslcertificates.noCsrHint' => 'Parte de CSR não fornecida.',
    'sslcertificates.privateKeyHint' => 'Parte da chave privada fornecida.',
    'sslcertificates.noPrivateKeyHint' => 'Parte da chave privada não fornecida.',
    'sslcertificates.certificateHint' => 'Parte do certificado fornecida.',
    'sslcertificates.noCertificateHint' => 'Parte do certificado não fornecida.',
    'sslcertificates.caCertificateHint' => 'Parte do certificado CA fornecida.',
    'sslcertificates.noCaCertificateHint' => 'Parte do certificado CA não fornecida.',
    'sslcertificates.buttonDownloadHint' => 'Fazer o download de todos os componentes de certificado.',
    'sslcertificates.webmail' => 'Proteger Webmail',
    'sslcertificates.hintWebmail' => 'Utilizar o certificado SSL/TLS selecionado para proteger o webmail no domínio.',
    'sslcertificates.remove' => 'Remover',
    'sslcertificates.hintRemove' => 'Remover os certificados SSL/TLS selecionados do repositório de domínios.',
    'sslcertificates.confirmOnDelete' => 'Remover os certificados SSL/TLS selecionados?',
    'sslcertificates.addCertificate' => 'Adicionar certificado SSL/TLS.',
    'sslcertificates.hintAddCertificate' => 'Adicionar um certificado SSL/TLS.',
    'sslcertificates.viewCertificates' => 'Exibir certificados',
    'sslcertificates.hintViewCertificates' => 'Visualizar a lista de certificados SSL/TLS que você comprou de seu fornecedor.',
    'sslcertificates.webmailCertificate' => 'Protege o Webmail',
    'sslcertificates.mailCertificate' => 'Protege o e-mail',
    'sslcertificates.mailAndWebmailCertificate' => 'Protege correio e webmail',
    'sslcertificates.mail' => 'Proteja o e-mail',
    'sslcertificates.hintMail' => 'Utilizar o certificado SSL/TLS selecionado para proteger o e-mail para o domínio.',

    'subscriptions.subscription' => 'Assinatura',
    'subscriptions.price' => 'Taxa',
    'subscriptions.renewalDate' => 'Data de expiração',
    'subscriptions.setupDate' => 'Data de configuração',
    'subscriptions.domains' => 'Websites',
    'subscriptions.systemUser' => 'Nome do usuário do sistema',
    'subscriptions.ipAddress' => 'Endereço IP',
    'subscriptions.addonDomains' => 'Complemento (add-on) de domínios',
    'subscriptions.diskSpace' => 'Espaço em disco',
    'subscriptions.moreDomains' => '… e %%count%% mais domínios',
    'subscriptions.buy' => 'Adquirir nova assinatura',
    'subscriptions.create' => 'Criar assinatura',
    'subscriptions.create_powerUser' => 'Criar espaço web',
    'subscriptions.renew' => 'Renovar',
    'subscriptions.confirmOnCancel' => 'Cancelar a assinatura?',
    'subscriptions.subscriptionSuspended' => 'Suspenso',
    'subscriptions.myResources' => 'Meus recursos',
    'subscriptions.planName' => 'Plano de serviços',
    'subscriptions.switchToLink' => 'Mudar para a assinatura',
    'subscriptions.switchToLinkHint' => 'Mudar para esta assinatura',
    'subscriptions.switchToLinkPowerUser' => 'Mudar para o espaço web',
    'subscriptions.switchToLinkHintPowerUser' => 'Mudar para este espaço web',
    'subscriptions.buttonRemove' => 'Remover',
    'subscriptions.buttonRemoveDescription' => 'Remover os espaços web selecionados',
    'subscriptions.confirmOnDelete' => 'Remover espaços web selecionados?',
    'subscriptions.buttonAddNew' => 'Adicionar espaço web',
    'subscriptions.buttonAddNewDescription' => 'Criar espaço web.',
    'subscriptions.subscription_powerUser' => 'Espaço web',
    'subscriptions.subscriptionPowerUser' => 'Espaço web',
    'subscriptions.confirmOnCancel_powerUser' => 'Cancelar o webspace?',
    'subscriptions.subscriptionSuspended_powerUser' => 'Suspenso',
    'subscriptions.switchToLink_powerUser' => 'Mudar para o espaço web',
    'subscriptions.switchToLinkHint_powerUser' => 'Mudar para este espaço web',
    'subscriptions.primaryDomain' => 'Domínio primário',
    'subscriptions.ftpAccess' => 'Acesso FTP',

    'users.contactName' => 'Nome de contato',
    'users.email' => 'Endereço de e-mail',
    'users.role' => 'Função',
    'users.contacts' => 'Contatos',
    'users.phone' => 'Telefone',
    'users.roleFilter' => 'Função do usuário',
    'users.filterAnyRole' => 'Qualquer',
    'users.activate' => 'Ativar',
    'users.deactivate' => 'Suspender',
    'users.remove' => 'Remover',
    'users.status' => 'Status',
    'users.statusBlocked' => 'Inativo',
    'users.buttonAddNewUser' => 'Criar conta de usuário',
    'users.hintAddNewUser' => 'Criar uma conta de usuário.',
    'users.hintRemove' => 'Remover as contas de usuário selecionadas.',
    'users.disabledSelectHint' => 'Esta conta de usuário não pode ser removida, porque é uma conta de usuário embutida ou sua própria conta de usuário.',
    'users.confirmOnDelete' => 'Remover as contas de usuário selecionadas?',

    'webusers.name' => 'Nome',
    'webusers.add' => 'Adicionar Usuário da Web',
    'webusers.hintAdd' => 'Adicionar uma conta de usuário de internet. %%resourceUsage%%',
    'webusers.settings' => 'Configurações',
    'webusers.hintSettings' => "Configurações do usuário de internet.",
    'webusers.remove' => 'Remover',
    'webusers.hintRemove' => 'Remova os usuário de internet selecionados.',
    'webusers.confirmOnDelete' => 'Remover os usuários de internet selecionados?',
    'webusers.buttonOpenHomepageHint' => "Clique para visualizar a página principal do usuário de internet pelo seu navegador de web.",
];