<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Additional Key Properties',
    'additional-key-info.update' => 'Retrieve Additional Key',
    'additional-key-info.updateDescription' => 'Retrieve the additional key and install them.',
    'additional-key-info.download' => 'Download Key',
    'additional-key-info.downloadDescription' => 'Download the current license key.',
    'additional-key-info.install' => 'Install Key',
    'additional-key-info.installDescription' => 'Install the current license key.',
    'additional-key-info.revert' => 'Roll Back Key',
    'additional-key-info.revertDescription' => 'Revert to the previously installed license key.',
    'additional-key-info.revertNotAvailableDescription' => 'No key installed.',
    'additional-key-info.installSuccess' => 'License key installation has started.',

    'additional-key-revert.title' => 'Additional Key Rollback',
    'additional-key-revert.success' => 'The additional key was rolled back.',

    'additional-key-upload.title' => 'Install a License Key',
    'additional-key-upload.success' => 'The new additional key was uploaded.',

    'additional-keys.title' => 'Additional License Keys',

    'change-owner.title' => 'Reassigning Selected Subscriptions',

    'customers.hint' => 'This is where you manage accounts of your hosting service customers: create accounts along with service subscriptions, manage existing customers, and remove accounts. To administer websites, mail or any other services provided to a customer, go to their Customer Panel by clicking the link in the right column of the list.',

    'customer-domains.hint' => 'This is where you set up and manage websites.',

    'customer-subscriptions.hint' => 'This is where you manage the customer\'s subscriptions.',

    'domains.hint' => 'This is where you view information on all domain names registered in the system and can proceed to managing hosting services. To add a domain for yourself or for hosting customers, just click Add Domain. You will be prompted to create a new customer and subscription while creating a domain, or to select from existing ones.',

    'database-servers.title' => 'Database Servers',

    'database-server-create.title' => 'New database server',

    'database-server-properties.title' => 'Database server',

    'database-server-databases.title' => 'Databases',

    'database-server-change-password.title' => 'Administrator\'s Password',

    'home.title' => 'Home',

    'license.title' => 'License Information',

    'primary-key-info.title' => 'Plesk License Key',
    'primary-key-info.update' => 'Retrieve Keys',
    'primary-key-info.updateDescription' => 'Retrieve the ordered license keys and install them.',
    'primary-key-info.upload' => 'Install Key',
    'primary-key-info.uploadDescription' => 'Upload and install a new license key.',
    'primary-key-info.revert' => 'Roll Back Key',
    'primary-key-info.revertDescription' => 'Revert to the previously installed license key.',

    'primary-key-revert.title' => 'License Key Rollback',
    'primary-key-revert.success' => 'The Plesk key was rolled back.',

    'primary-key-upload.title' => 'Install a License Key',
    'primary-key-upload.success' => 'The new Plesk key was uploaded.',

    'resellers.hint' => 'This is where you manage accounts of resellers — your customers who resell hosting services and host their own websites. Here you create accounts along with service subscriptions, manage existing resellers, and remove accounts.',

    'reseller-customers.hint' => 'This is where you set up and manage customers.',

    'reseller-domains.hint' => 'This is where you set up and manage websites.',

    'reseller-subscriptions.hint' => 'This is where you manage the reseller\'s subscriptions.',

    'subscriptions.hint' => 'Customers obtain hosting services from you by subscribing to a hosting plan. You can manage these subscriptions here, as well as your own subscriptions you create to host your websites. To administer websites, mail or any other services provided with a subscription, go to the subscriber\'s Customer Panel by clicking the link in the right column of the list.',

    'server-mail-settings.title' => 'Settings',
    'server-mail-spam-filter.title' => 'Spam Filtering',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Black List',
    'server-mail-white-list.title' => 'White List',
    'server-mail-queue.title' => 'Mail Queue',
    'server-mail-statistics.title' => 'Statistics',

    'firewall.title' => 'Firewall Management',
    'firewall-general.title' => 'General',
    'firewall-general.toggleStatus' => 'Firewall protection',
    'firewall-general.buttonDefault' => 'Reset to Default',
    'firewall-general.buttonPanic' => 'Panic Mode',
    'firewall-general.confirmationDefault' => 'Reset the firewall settings to the default ones?',
    'firewall-general.confirmationPanic' => 'Turn on Panic Mode? Users will not be able to access their domains and some network services may stop working.',
    'firewall-general.successDefault' => 'The firewall settings were reset to defaults.',
    'firewall-general.successPanic' => 'Panic mode was enabled.',
    'firewall-general.info' => 'For security reasons, the firewall blocks all connections except those explicitly allowed. You can allow a connection by creating a rule. Refer to the documentation for more information',
    'firewall-general.interfaces' => 'Network interfaces',
    'firewall-icmp.title' => 'ICMP Protocol',
    'firewall-rules.title' => 'Firewall Rules',

    'dns.title' => 'DNS Settings',
    'dns-records.title' => 'Zone Records Template',
    'dns-soa-record.title' => 'Zone Settings Template',

    'php-handler.title' => 'Settings for %%name%%',
    'php-handler.extensions.title' => 'Extensions',
    'php-handler.extensions.description' => 'These PHP extensions settings are for this handler only.',
    'php-handler.extensions.descriptionShared' => 'These settings are common to the following PHP handlers: %%handlers%%. The settings apply to all websites that use these handlers.',
    'php-handler.extensions.buttonManage' => 'Manage PECL Packages',
    'php-handler.extensions.manage.title' => 'Manage PECL Packages',
    'php-handler.extensions.manage.risks' => 'PHP extensions are supplied by third-party PECL packages. You are installing them at your own risk.',
    'php-handler.extensions.manage.description' => 'Install, upgrade and uninstall PECL packages. The changes will be applied to all websites running on %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Why is the desired package not on the list?',
    'php-handler.extensions.manage.limitations' => 'PHP extensions shipped by the control panel provider and OS vendors are not shown on the list.',
    'php-handler.php-ini.title' => 'php.ini',

    'ServerAbout.copyright' => '© 2023 Plesk International GmbH. All rights reserved.',
    'ServerAbout.linkLicenseManagement' => 'Go to License Information',
    'ServerAbout.panelVersion' => 'Version',
    'ServerAbout.installedPatchVersion' => 'Update #%%patch%%',
    'ServerAbout.licenseKey' => 'License key',
    'ServerAbout.productDescription' => 'Plesk is the leading WebOps platform to run, automate, and grow applications, websites, and hosting businesses.',
    'ServerAbout.readEula' => 'Read %%link%%.',
    'ServerAbout.linkEula' => 'End-User License Agreement',
    'ServerAbout.visitForum' => 'Visit %%link%%',
    'ServerAbout.linkForum' => 'Plesk forum',
    'ServerAbout.followUs' => 'Follow us',
    'ServerAbout.visitSite' => 'Learn more at %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Find inspiration at %%link%%',
    'ServerAbout.linkBlog' => 'Plesk Blog',

    'ServerAbout.darkThemePromoTitle' => 'Congratulation!',
    'ServerAbout.darkThemePromoDescription' => 'You found a magic kitty added within the anniversary Plesk Obsidian 18.0.50 version.',
    'ServerAbout.darkThemePromoButton' => 'Whoosh! Come to the dark side',
    'ServerAbout.darkThemeTourDescription' => 'Switch this option to enable or disable the dark theme for your interface.',
    'ServerAbout.darkThemeTourButton' => 'Got it',

    'ts-sessions.title' => 'Terminal Server Sessions',
    'ts-sessions-properties.title' => 'Session properties',

    'BandwidthLimiting.title' => 'Bandwidth Limiting for %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'You cannot control bandwidth throttling because QoS is not installed.',
    'BandwidthLimiting.virtualHostingRequired' => 'Bandwidth limiting is available only for domains with web hosting.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximum bandwidth usage',
    'BandwidthLimiting.bandwidthHint' => 'The bandwidth usage limit is only applied to data transferred via the HTTP protocol.',
    'BandwidthLimiting.maxConnectionLabel' => 'Connections limited to',
    'BandwidthLimiting.maxConnectionHint' => 'If you limit bandwidth, we recommend that you also limit the number of simultaneous connections to the website. Otherwise, in case of frequent requests to the website, the web server processes will increase the server load.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Bandwidth limiting settings were changed.',
    'BandwidthLimiting.unlimited' => 'Unlimited',

    'ip-address-domains.title' => 'Websites that use %%type%% IP address %%ipAddress%%',
    'ip-address-domains.site' => 'Site',
    'ip-address-domains.setAsDefault' => 'Set As Default',
    'ip-address-domains.type-SHARED' => 'shared',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicated',

    'HotlinkProtection.title' => 'Hotlink Protection for %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'The Hotlink Protection is available only for domains with web hosting.',
    'HotlinkProtection.enabledLabel' => 'Enable hotlink protection',
    'HotlinkProtection.extensionsLabel' => 'Protected files extensions',
    'HotlinkProtection.friendsLabel' => 'Addresses of friendly websites',
    'HotlinkProtection.success' => 'Hotlink protection settings were changed.',

    'Odbc.serverTitle' => 'ODBC DSN Connections',
    'Odbc.domainTitle' => 'ODBC DSN Connections for %%domainName%%',
    'Odbc.add' => 'Add ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% created / %%allowed%% allowed.',
    'Odbc.limitExceeded' => 'The ODBC DSN Connection limit exceeded.',
    'Odbc.unlimited' => 'Unlimited',
    'Odbc.addTooltip' => 'Add ODBC data source.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Connection name',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Connection description',
    'Odbc.hostname' => 'Hostname',
    'Odbc.statusSystem' => 'It is a system DSN.',
    'Odbc.statusConfigured' => 'DSN is configured.',
    'Odbc.statusNotConfigured' => 'DSN is not configured.',
    'Odbc.noSelectionText' => 'Select one or more items to remove.',
    'Odbc.removeConfirmation' => 'Remove {count, plural, =1 {the {name} connection} other {# selected connections}}?',
    'Odbc.removeSuccess' => 'The selected connections were removed.',

    'DomainAliasSettings.title' => 'Domain Alias Settings',
    'DomainAliasSettings.updateSuccess' => 'The properties of the domain alias %%name%% were changed. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'The website settings will be applied in %%restartInterval%% minutes.',

    'HostingSettings.title' => 'Hosting Settings',
    'HostingSettings.updateSuccess' => 'The settings were updated.',
    'HostingSettings.emptyLogin' => 'You need to specify a username.',
    'HostingSettings.emptyPassword' => 'You need to specify a password.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP server does not support IPv6. Allocate at least one IPv4 address, otherwise the user will not be able to upload files to the server over FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domain settings',
    'HostingSettings.domainSettingsSection.domainName' => 'Domain name',
    'HostingSettings.domainSettingsSection.description' => 'For example, example.com ',

    'HostingSettings.submitPopover.title' => 'Remove the content of %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Switching the "Website" hosting type to "%%type%%" will permanently remove the entire website\'s content, including the following directories:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Do you want to change the hosting type for your website?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'To get the full scope of settings, fill the system user credentials and press "Create webspace"',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'To get the full scope of settings, press "Next" button to create hosting',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Hosting type',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Type',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Website',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Forwarding',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'No web hosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Use the domain\'s DNS zone for having mailboxes under this domain name',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'The path to the website home directory',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Preferred domain',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Visitors will be redirected here via a SEO friendly HTTP 301 redirect.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Forward visitors to',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Forwarding type',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Moved permanently (code 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redirect website visitors to another site and show them the destination address. Such redirection will keep the site\'s search ranking',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Moved temporarily (code 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redirect website visitors to a temporary site copy when you do not want search engines to index this temporary site.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Frame forwarding',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redirect website visitors to another site, but do not show them the destination address, so they do not know about the redirection.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Preferred domain',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'None',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Document root',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'It is impossible to change document root because there are web applications installed on this website.',
    'HostingSettings.domainSettingsSection.save' => 'Save',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Change this setting?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Changing this setting contradicts the server\'s security policy, and may hurt performance or make the server vulnerable to attacks.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Change',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Revert',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Secure settings preset is applied',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'For improved security, apply the secure settings preset. Note that certain permissions allow subscribers to modify these settings.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Apply secure preset',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Learn about secure hosting settings',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS support',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Encrypt connections between the website and the visitor\'s browser.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificate',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'To enable HTTPS, upload an SSL/TLS certificate to the domain\'s repository, then select it here.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redirect visitors from HTTP to HTTPS via a SEO friendly 301 redirect',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'There are no SSL/TLS certificates in your repository. To add a certificate, go to %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'this page',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (other repository)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Not selected',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web scripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Select which programming and scripting languages must be interpreted by the web server.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin directory is located in %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Use SSI for *.htm, *.html files',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET version',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Custom error documents',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin directory is located in',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'the document root of this domain',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'the root directory of webspace',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'the old-style root of this domain',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Custom error documents',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Additional write/modify permissions',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy publishing',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Web statistics',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Tool',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Protect access to your web statistics with your FTP username and password',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Webspace settings',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP addresses',
    'HostingSettings.webspaceSettingsSection.quota' => 'Enable disk space quota',
    'HostingSettings.webspaceSettingsSection.quotaDesc' => 'Forbid operations on website\'s files if the disk space quota set in subscription settings (if any) is exceeded.',
    'HostingSettings.webspaceSettingsSection.quotaUnlimitedDesc' => 'The hard disk quota is not supported because of the server\'s file system configuration.',
    'HostingSettings.webspaceSettingsSection.quotaMbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quotaReadonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'System user\'s credentials',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Manage website\'s files and folders via FTP or File Manager. Access the server via SSH if permitted.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Manage website\'s files and folders via FTP or File Manager. Access the server via Remote Desktop if permitted.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Username',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Password',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Specify a new password here to change the system user\'s password.',
    'HostingSettings.webspaceSettingsSection.shellUnix' => 'Allow SSH access',
    'HostingSettings.webspaceSettingsSection.shellWin' => 'Allow Remote Desktop access',
    'HostingSettings.webspaceSettingsSection.shellDesc' => "Access the server with the system user's credentials.",
    'HostingSettings.webspaceSettingsSection.shellType' => 'Type',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'For {count, plural, other {# domains}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'The following settings are mutual for all {count, plural, other {# domains in the {name} webspace}}:',

    'OdbcAdd.title' => 'Add an ODBC DSN',
    'OdbcAdd.nameLabel' => 'Connection name',
    'OdbcAdd.descriptionLabel' => 'Connection description',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Create ODBC DSN',

    'OdbcEdit.title' => 'Set Up an ODBC Connection',
    'OdbcEdit.saveSuccess' => 'Connection settings were saved.',
    'OdbcEdit.test' => 'Test connection',
    'OdbcEdit.connectSuccess' => 'Connection successful.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Database file path',
    'OdbcEdit.excel.defaultdir.label' => 'Default data directory',
    'OdbcEdit.excel.fil.label' => 'Database version',
    'OdbcEdit.excel.maxbuffersize.label' => 'Max buffer size',
    'OdbcEdit.excel.pagetimeout.label' => 'Page timeout',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Database file path',
    'OdbcEdit.access.uid.label' => 'Login ID',
    'OdbcEdit.access.pwd.label' => 'Password',
    'OdbcEdit.access.pagetimeout.label' => 'Page timeout',
    'OdbcEdit.access.pagetimeout.description' => 'The period of time, in tenths of a second, that an unused page remains in the buffer. This option applies to all data sources that use the Microsoft Access driver.',
    'OdbcEdit.access.maxbuffersize.label' => 'Max buffer size',
    'OdbcEdit.access.maxbuffersize.description' => 'The size of the internal buffer, in KB, aligned on 256 KB boundary.',
    'OdbcEdit.access.readonly.label' => 'Read-only',
    'OdbcEdit.access.readonly.description' => 'Designates the database as read-only to prohibit any updates.',
    'OdbcEdit.access.exclusive.label' => 'Exclusive',
    'OdbcEdit.access.exclusive.description' => 'Designates the database as exclusive to prohibit shared updates.',
    'OdbcEdit.access.safetransactions.label' => 'Safe transactions',
    'OdbcEdit.access.safetransactions.description' => 'If set to 0 (the default setting), all transactions are committed immediately. If set to 1, all transactions are saved to disk only upon a commit operation, but performance is slightly degraded.',
    'OdbcEdit.access.threads.label' => 'Threads',
    'OdbcEdit.access.threads.description' => 'The number of background threads for the engine to use.',
    'OdbcEdit.access.maxscanrows.label' => 'Max rows to scan',
    'OdbcEdit.access.maxscanrows.description' => 'The number of rows to be scanned when setting a column\'s data type based on existing data.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Specifies how changes made outside of a transaction are written to the database.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Specifies whether the MS Access driver will perform explicit user-defined transactions asynchronously.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'Login ID',
    'OdbcEdit.mssql.pwd.label' => 'Password',
    'OdbcEdit.mssql.database.label' => 'Default database',
    'OdbcEdit.mssql.app.label' => 'Application name',
    'OdbcEdit.mssql.wsid.label' => 'Workstation ID',
    'OdbcEdit.mssql.language.label' => 'Default language',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversion of extended characters to OEM values',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC driver',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'The host name of the MySQL server',
    'OdbcEdit.mysql.database.label' => 'Default database',
    'OdbcEdit.mysql.user.label' => 'Username',
    'OdbcEdit.mysql.user.description' => 'The username used for connecting to MySQL',
    'OdbcEdit.mysql.password.label' => 'Password',
    'OdbcEdit.mysql.password.description' => 'The password for the user account on the server',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'The TCP/IP port to use if the server is not the local host',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Windows named pipe to connect to if the server is the local host',
    'OdbcEdit.mysql.option.label' => 'Option',
    'OdbcEdit.mysql.option.description' => 'Options that specify how MyODBC should work. See <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentation</a>',
];
