<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Propriétés de la clé supplémentaire',
    'additional-key-info.update' => 'Récupérer la clé supplémentaire',
    'additional-key-info.updateDescription' => 'Récupérer les clés supplémentaires et les installer.',
    'additional-key-info.download' => 'Télécharger la licence',
    'additional-key-info.downloadDescription' => 'Téléchargez la clé de licence actuelle.',
    'additional-key-info.install' => 'Installer la clé',
    'additional-key-info.installDescription' => 'Installez la clé de licence actuelle.',
    'additional-key-info.revert' => 'Revenir à la clé précédente',
    'additional-key-info.revertDescription' => 'Restaurez la clé précédemment installée.',
    'additional-key-info.revertNotAvailableDescription' => 'Aucune clé n\'est installée.',
    'additional-key-info.installSuccess' => 'L\'installation de la clé de licence a démarré.',

    'additional-key-revert.title' => 'Annulation de la clé supplémentaire',
    'additional-key-revert.success' => 'La clé supplémentaire a été annulée.',

    'additional-key-upload.title' => 'Installer une clé de licence',
    'additional-key-upload.success' => 'La nouvelle clé supplémentaire a été envoyée.',

    'additional-keys.title' => 'Clés de licence supplémentaires',

    'change-owner.title' => 'Réaffecter les abonnements sélectionnés',

    'customers.hint' => 'Sur cette page, vous pouvez gérer les comptes des clients de votre service d\'hébergement : créer de nouveaux comptes avec les abonnements de services, gérer les clients existants et supprimer les comptes. Pour administrer les sites Web, les services de messagerie et autres fournis pour un client, allez dans leur Panneau Client en cliquant sur le lien dans la colonne de droite de la liste.',

    'customer-domains.hint' => 'Sur cette page, vous pouvez configurer et gérer les sites Web.',

    'customer-subscriptions.hint' => 'Sur cette page, vous pouvez gérer les abonnements du client.',

    'domains.hint' => 'Sur cette page, vous pouvez voir les informations sur tous les noms de domaine enregistrés dans le système. Vous pouvez aussi y gérer les services d\'hébergement. Pour ajouter un domaine pour vous-même ou vos clients d\'hébergement, cliquez simplement sur Ajouter un domaine. Lors de la création d\'un domaine, vous êtes invité à créer de nouveaux clients et abonnements ou à sélectionner un client/abonnement existant.',

    'database-servers.title' => 'Serveurs de bases de données',

    'database-server-create.title' => 'Nouveau serveur de base de données',

    'database-server-properties.title' => 'Serveur de bases de données',

    'database-server-databases.title' => 'Bases de données',

    'database-server-change-password.title' => 'Mot de passe de l\'administrateur',

    'home.title' => 'Accueil',

    'license.title' => 'Informations sur la licence',

    'primary-key-info.title' => 'Clé de licence Plesk',
    'primary-key-info.update' => 'Récupérer des clés de licence',
    'primary-key-info.updateDescription' => 'Récupérez les clés de licence commandées et installez-les.',
    'primary-key-info.upload' => 'Installer la clé',
    'primary-key-info.uploadDescription' => 'Envoyez et installez une nouvelle clé de licence.',
    'primary-key-info.revert' => 'Revenir à la clé précédente',
    'primary-key-info.revertDescription' => 'Restaurez la clé précédemment installée.',

    'primary-key-revert.title' => 'Revenir à la clé de licence précédente',
    'primary-key-revert.success' => 'La clé Plesk a été retirée.',

    'primary-key-upload.title' => 'Installer une clé de licence',
    'primary-key-upload.success' => 'La nouvelle clé de Plesk a été envoyée.',

    'resellers.hint' => 'Sur cette page, vous pouvez gérer les comptes revendeur. Autrement dit, il s\'agit de vos clients qui revendent des services d\'hébergement et hébergent leurs propres sites Web. Vous pouvez créer des comptes avec les abonnements de services, gérer les revendeurs existants et supprimer des comptes.',

    'reseller-customers.hint' => 'Sur cette page, vous pouvez configurer et gérer les clients.',

    'reseller-domains.hint' => 'Sur cette page, vous pouvez configurer et gérer les sites Web.',

    'reseller-subscriptions.hint' => 'Sur cette page, vous pouvez gérer les abonnements du revendeur.',

    'subscriptions.hint' => 'Les clients bénéficient de vos services d\'hébergement en s\'abonnant à un pack d\'hébergement. Vous pouvez également gérer vos propres abonnements que vous avez créés pour héberger vos sites Web. Pour administrer un site Web, une messagerie ou d\'autres services fournis dans le cadre d\'un abonnement, allez dans le Panneau Client de l\'abonné en cliquant sur le lien dans la colonne de droite de la liste.',

    'server-mail-settings.title' => 'Paramètres',
    'server-mail-spam-filter.title' => 'Anti-spam',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Liste noire',
    'server-mail-white-list.title' => 'Liste blanche',
    'server-mail-queue.title' => 'File d\'attente des mails',
    'server-mail-statistics.title' => 'Statistiques',

    'firewall.title' => 'Gestion du pare-feu',
    'firewall-general.title' => 'Général',
    'firewall-general.toggleStatus' => 'Protection par pare-feu',
    'firewall-general.buttonDefault' => 'Rétablir le paramétrage initial',
    'firewall-general.buttonPanic' => 'Mode Panique',
    'firewall-general.confirmationDefault' => 'Réinitialiser les paramètres du pare-feu pour récupérer les paramètres d\'origine ?',
    'firewall-general.confirmationPanic' => 'Activer le mode Panique ? Les utilisateurs ne pourront pas accéder à leur domaine et certains services du réseau risquent d\'arrêter de fonctionner.',
    'firewall-general.successDefault' => 'Les paramètres du pare-feu ont été réinitialisés.',
    'firewall-general.successPanic' => 'Le mode Panique a été activé.',
    'firewall-general.info' => 'Pour des raisons de sécurité, le pare-feu bloque toutes les connexions sauf celles explicitement autorisées. Vous pouvez autoriser une connexion en créant une règle. Consultez la documentation pour en savoir plus.',
    'firewall-general.interfaces' => 'Interfaces réseau',
    'firewall-icmp.title' => 'Protocole ICMP',
    'firewall-rules.title' => 'Règles du pare-feu',

    'dns.title' => 'Paramètres DNS',
    'dns-records.title' => 'Template d\'enregistrements de la zone',
    'dns-soa-record.title' => 'Template des paramètres de la zone',

    'php-handler.title' => 'Paramètres pour  %%name%%',
    'php-handler.extensions.title' => 'Extensions',
    'php-handler.extensions.description' => 'Ces paramètres d\'extensions PHP sont uniquement pour ce gestionnaire.',
    'php-handler.extensions.descriptionShared' => 'Ces paramètres sont communs aux gestionnaires PHP suivants : %%handlers%%. Les paramètres s\'appliquent à tous les sites Web qui utilisent ces gestionnaires.',
    'php-handler.extensions.buttonManage' => 'Gérer les packages PECL',
    'php-handler.extensions.manage.title' => 'Gérer les packages PECL',
    'php-handler.extensions.manage.risks' => 'Les extensions PHP sont fournies par les packages tiers PECL. Vous les installez à vos propres risques.',
    'php-handler.extensions.manage.description' => 'Installez, mettez à niveau et désinstallez les packages PECL. Les modifications seront appliquées à tous les sites web exécutés sur %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Pourquoi le package souhaité est-il absent de la liste ?',
    'php-handler.extensions.manage.limitations' => 'Les extensions PHP fournies par le fournisseur du panneau de contrôle et les vendeurs OS ne sont pas affichés dans la liste.',
    'php-handler.php-ini.title' => 'php.ini',

    'ServerAbout.copyright' => '© 2023 Plesk International GmbH. Tous droits réservés.',
    'ServerAbout.linkLicenseManagement' => 'Consulter les Informations sur la licence',
    'ServerAbout.panelVersion' => 'Version',
    'ServerAbout.installedPatchVersion' => 'Mise à jour n° %%patch%%',
    'ServerAbout.licenseKey' => 'Clé de licence',
    'ServerAbout.productDescription' => 'Plesk est la plate-forme WebOps leader pour exécuter, automatiser et développer des applications et des sites Web et pour héberger des sociétés.',
    'ServerAbout.readEula' => 'Lisez %%link%%.',
    'ServerAbout.linkEula' => 'Contrat de Licence Utilisateur final',
    'ServerAbout.visitForum' => 'Visitez %%link%%',
    'ServerAbout.linkForum' => 'Forum Plesk',
    'ServerAbout.followUs' => 'Suivez-nous',
    'ServerAbout.visitSite' => 'Pour en savoir plus... %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Inspirez-vous %%link%%',
    'ServerAbout.linkBlog' => 'Blog Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Félicitations !',
    'ServerAbout.darkThemePromoDescription' => 'Vous avez découvert un chat magique présent dans la version anniversaire de Plesk Obsidian 18.0.50 !',
    'ServerAbout.darkThemePromoButton' => 'Abracadabra... Bienvenue dans le côté obscur !',
    'ServerAbout.darkThemeTourDescription' => 'Utilisez cette option pour activer ou désactiver le thème sombre de votre interface.',
    'ServerAbout.darkThemeTourButton' => 'J\'ai compris.',

    'ts-sessions.title' => 'Sessions Terminal Server',
    'ts-sessions-properties.title' => 'Propriétés de la session',

    'BandwidthLimiting.title' => 'Limitation de la bande passante pour %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Vous ne pouvez pas gérer la réduction de bande passante, car la fonctionnalité Qualité de service n\'est pas installée.',
    'BandwidthLimiting.virtualHostingRequired' => 'La limitation de la bande passante est disponible uniquement pour les domaines avec hébergement web.',
    'BandwidthLimiting.bandwidthLabel' => 'Utilisation maximum de la bande passante',
    'BandwidthLimiting.bandwidthHint' => 'La limite d\'utilisation de la bande passante est appliquée uniquement aux données transférées via le protocole HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Connexions limitées à',
    'BandwidthLimiting.maxConnectionHint' => 'Si vous limitez la bande passante, nous vous recommandons également de limiter le nombre de connexions simultanées au site web. Si vous ne les limitez pas, en cas de requêtes élevées pour le site web, la charge du serveur web augmentera en raison du nombre de processus de serveur web.',
    'BandwidthLimiting.kbps' => 'KO/s',
    'BandwidthLimiting.success' => 'Les paramètres de limitation de la bande passante ont été modifiés.',
    'BandwidthLimiting.unlimited' => 'Illimité',

    'ip-address-domains.title' => 'Sites web qui utilisent l\'adresse IP %%type%% %%ipAddress%%',
    'ip-address-domains.site' => 'Site',
    'ip-address-domains.setAsDefault' => 'Prendre par défaut',
    'ip-address-domains.type-SHARED' => 'partagée',
    'ip-address-domains.type-EXCLUSIVE' => 'dédiée',

    'HotlinkProtection.title' => 'Protection contre les hotlinks pour %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'La protection contre les hotlinks est disponible uniquement pour les domaines avec hébergement web.',
    'HotlinkProtection.enabledLabel' => 'Activer la protection contre les hotlinks',
    'HotlinkProtection.extensionsLabel' => 'Extensions de fichiers protégées',
    'HotlinkProtection.friendsLabel' => 'Adresses de sites web de confiance',
    'HotlinkProtection.success' => 'Les paramètres de la protection contre les hotlinks ont été modifiés.',

    'Odbc.serverTitle' => 'Connexions DSN ODBC',
    'Odbc.domainTitle' => 'Connexions DSN ODBC pour %%domainName%%',
    'Odbc.add' => 'Ajouter un DSN ODBC',
    'Odbc.resourceUsage' => '%%used%% créés / %%allowed%% autorisés.',
    'Odbc.limitExceeded' => 'La limite de connexion DSN ODBC a été dépassée.',
    'Odbc.unlimited' => 'Illimité',
    'Odbc.addTooltip' => 'Ajoutez la source de données ODBC.',
    'Odbc.status' => 'Statut',
    'Odbc.name' => 'Nom connexion',
    'Odbc.driver' => 'Pilote',
    'Odbc.description' => 'Description de la connexion',
    'Odbc.hostname' => 'Nom d\'hôte',
    'Odbc.statusSystem' => 'Il s\'agit d\'un DSN système.',
    'Odbc.statusConfigured' => 'DSN est configuré.',
    'Odbc.statusNotConfigured' => 'DSN n\'est pas configuré.',
    'Odbc.noSelectionText' => 'Sélectionnez un ou plusieurs éléments à supprimer.',
    'Odbc.removeConfirmation' => 'Voulez-vous vraiment supprimer {count, plural, one {}=1 {la connexion {name}} other {les # connexions sélectionnées}} ?',
    'Odbc.removeSuccess' => 'Les connexions sélectionnées ont été supprimées.',

    'DomainAliasSettings.title' => 'Paramètres de l\'alias de domaine',
    'DomainAliasSettings.updateSuccess' => 'Les propriétés de l\'alias de domaine %%name%% ont été modifiées. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Les paramètres du site Web seront appliqués dans %%restartInterval%% minutes.',

    'HostingSettings.title' => 'Paramètres d\'hébergement',
    'HostingSettings.updateSuccess' => 'Les paramètres ont été mis à jour.',
    'HostingSettings.emptyLogin' => 'Vous devez indiquer un nom d\'utilisateur.',
    'HostingSettings.emptyPassword' => 'Vous devez indiquer un mot de passe.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Le serveur FTP ne prend pas en charge d\'adresse IPv6. Allouez au moins une adresse IPv4 sinon l\'utilisateur ne pourra pas envoyer les fichiers au serveur via FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Paramètres du domaine',
    'HostingSettings.domainSettingsSection.domainName' => 'Nom de domaine',
    'HostingSettings.domainSettingsSection.description' => 'Par exemple, exemple.com ',

    'HostingSettings.submitPopover.title' => 'Supprimer le contenu du %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Passer du type d\'hébergement "Site web" à "%%type%%" supprimera définitivement l\'ensemble du contenu du site web, y compris les répertoires suivants :',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Voulez-vous modifier le type d\'hébergement pour votre site Web ?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Pour accéder à plus de paramètres, saisissez les identifiants d\'accès de l\'utilisateur du système, puis cliquez sur "Créer un espace web".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Pour accéder à plus de paramètres, cliquez sur "Suivant" afin de créer l\'hébergement.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Type d\'hébergement',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Type',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Site Web',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Redirection',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Aucun hébergement Web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Utiliser la zone DNS du domaine pour avoir des boîtes mail sous ce nom de domaine',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Chemin d\'accès vers le répertoire principal du site web',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Domaine préféré',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Les internautes seront redirigés vers cette page à l\'aide de la redirection HTTP 301 respectueuse du SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Rediriger les internautes vers',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Type de redirection',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Déplacé de façon permanente (code 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redirigez les internautes vers un autre site et montrez-leur l\'adresse de destination. Ce type de redirection préserve le classement du site dans les résultats de recherche.',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Déplacé de façon temporaire (code 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redirigez les visiteurs vers une copie temporaire du site si vous ne voulez pas que ce site temporaire soit indexé par les moteurs de recherche.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Redirection par cadre',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redirigez les visiteurs du site Web vers un autre site mais ne leur indiquez pas l\'adresse de destination. Ils ne doivent rien savoir de la redirection.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Domaine préféré',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Aucun',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Racine du document',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Vous ne pouvez pas changer la racine du document car des applications Web sont installées sur ce site Web.',
    'HostingSettings.domainSettingsSection.save' => 'Enregistrer',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Modifier ce paramètre ?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'La modification de ce paramètre est contraire à la politique de sécurité du serveur et risque d\'avoir des conséquences sur les performances ou de rendre le serveur vulnérable aux attaques.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Modifier',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Annuler',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Les paramètres de sécurité prédéfinis sont appliqués.',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Pour une sécurité accrue, appliquez les paramètres prédéfinis sécurisés. Remarque : certains droits permettent aux abonnés de modifier ces paramètres.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Appliquer les paramètres prédéfinis sûrs',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'En savoir plus sur les paramètres d\'hébergement sûrs',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Prise en charge SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Activé',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Chiffrez les connexions entre le site web et le navigateur de l\'internaute.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Pour activer le protocole HTTPS, téléversez un certificat SSL/TLS vers le dépôt du domaine, et sélectionnez-le ici.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Rediriger les internautes de HTTP vers HTTPS via une redirection HTTP 301 respectueuse du SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Il n\'y a aucun certificat SSL/TLS dans votre répertoire. Si vous voulez ajouter un certificat, allez sur %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'cette page',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (autre répertoire)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Non sélectionné',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Scripting web',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Sélectionnez les langages de programmation et de script qui doivent être interprétés par le serveur web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'le répertoire cgi-bin est situé dans %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Utiliser SSI pour les fichiers *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Version ASP.NET Microsoft',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documents d\'erreurs personnalisés',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'le répertoire cgi-bin est situé dans',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'le document root de ce domaine',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'le répertoire root de l\'espace Web',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'la racine de style antérieur de ce domaine',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documents d\'erreurs personnalisés',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Autres droits d\'écriture et de modification',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publication Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Statistiques Web',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Outil',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Protéger l\'accès à vos statistiques Web avec votre nom d\'utilisateur et mot de passe FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Désactivé',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Paramètres de l\'espace Web',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Adresses IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Quota de l\'espace disque',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Activé',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Interdisez les opérations sur les fichiers du site web en cas de dépassement du quota de l\'espace disque défini dans les paramètres de l\'abonnement (le cas échéant).',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Le quota de disque dur n\'est pas pris en charge en raison de la configuration du système de fichiers du serveur.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'Mo',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% Mo',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Identifiants d\'accès de l\'utilisateur système',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gérez les fichiers et les dossiers du site web via FTP ou via le Gestionnaire de fichiers. Accédez au serveur via SSH si cette action est autorisée.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gérez les fichiers et les dossiers du site web via FTP ou via le Gestionnaire de fichiers. Accédez au serveur via Remote Desktop si cette action est autorisée.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nom d\'utilisateur',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Mot de passe',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Saisissez un nouveau mot de passe pour remplacer le mot de passe de l\'utilisateur système.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Accès SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Accès Remote Desktop',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Activé',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Accédez au serveur avec les identifiants de l'utilisateur système.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Type',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Désactivé',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Pour {count, plural, other {# domaines}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Les paramètres suivants sont communs pour les {count, plural, other {# domaines de l\'espace web {name}}} :',

    'OdbcAdd.title' => 'Ajouter un DSN ODBC',
    'OdbcAdd.nameLabel' => 'Nom connexion',
    'OdbcAdd.descriptionLabel' => 'Description de la connexion',
    'OdbcAdd.driver' => 'Pilote',
    'OdbcAdd.submit' => 'Créer DSN ODBC',

    'OdbcEdit.title' => 'Configurer une connexion ODBC',
    'OdbcEdit.saveSuccess' => 'Les paramètres de connexion ont été enregistrés.',
    'OdbcEdit.test' => 'Tester la connexion',
    'OdbcEdit.connectSuccess' => 'Connexion réussie.',

    'OdbcEdit.excel.driver.label' => 'Pilote',
    'OdbcEdit.excel.dbq.label' => 'Chemin d\'accès vers le fichier de la base de données',
    'OdbcEdit.excel.defaultdir.label' => 'Répertoire de données par défaut',
    'OdbcEdit.excel.fil.label' => 'Version de la base de données',
    'OdbcEdit.excel.maxbuffersize.label' => 'Taille max de la mémoire tampon',
    'OdbcEdit.excel.pagetimeout.label' => 'Délai de dépassement de la page',

    'OdbcEdit.access.driver.label' => 'Pilote',
    'OdbcEdit.access.dbq.label' => 'Chemin d\'accès vers le fichier de la base de données',
    'OdbcEdit.access.uid.label' => 'ID du nom d\'utilisateur',
    'OdbcEdit.access.pwd.label' => 'Mot de passe',
    'OdbcEdit.access.pagetimeout.label' => 'Délai de dépassement de la page',
    'OdbcEdit.access.pagetimeout.description' => 'Le laps de temps, en dixièmes de seconde, pendant lequel une page inutilisée reste dans le buffer. Cette option s\'applique à toutes les sources de données qui utilisent le pilote de Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Taille max de la mémoire tampon',
    'OdbcEdit.access.maxbuffersize.description' => 'Taille du buffer interne, en Ko, aligné sur la limite 256 Ko.',
    'OdbcEdit.access.readonly.label' => 'Lecture seule',
    'OdbcEdit.access.readonly.description' => 'Caractérise la base de données comme pouvant seulement être lue, pour empêcher toute mise à jour.',
    'OdbcEdit.access.exclusive.label' => 'Exclusive',
    'OdbcEdit.access.exclusive.description' => 'Caractérise la base de données comme étant exclusive pour empêcher des mises à jour concomitantes.',
    'OdbcEdit.access.safetransactions.label' => 'Transactions sécurisées',
    'OdbcEdit.access.safetransactions.description' => 'Si défini sur 0 (paramètre par défaut), toutes les transactions sont automatiquement engagées. Si défini sur 1, toutes les transactions sont enregistrées dans le disque uniquement lors d\'une opération d\'engagement mais la performance est légèrement rétrogradée.',
    'OdbcEdit.access.threads.label' => 'Threads',
    'OdbcEdit.access.threads.description' => 'Nombre de fils d\'arrière-plan que le moteur doit utiliser.',
    'OdbcEdit.access.maxscanrows.label' => 'Nombre max de lignes à analyser',
    'OdbcEdit.access.maxscanrows.description' => 'Nombre de lignes à scruter lors de la définition du type des données d\'une colonne en se basant sur les données existantes.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Précise comment les changements faits en-dehors d\'une transaction sont écrits dans la base de données.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Indique si le pilote de MS Access exécutera de manière asynchrone les transactions configurées explicitement par l\'utilisateur.',

    'OdbcEdit.mssql.driver.label' => 'Pilote',
    'OdbcEdit.mssql.server.label' => 'Serveur',
    'OdbcEdit.mssql.uid.label' => 'ID du nom d\'utilisateur',
    'OdbcEdit.mssql.pwd.label' => 'Mot de passe',
    'OdbcEdit.mssql.database.label' => 'Base de données par défaut',
    'OdbcEdit.mssql.app.label' => 'Nom de l\'application',
    'OdbcEdit.mssql.wsid.label' => 'ID du poste de travail',
    'OdbcEdit.mssql.language.label' => 'Langue par défaut',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversion des caractères étendus pour les valeurs OEM',

    'OdbcEdit.mysql.driver.label' => 'Pilote ODBC MySQL',
    'OdbcEdit.mysql.server.label' => 'Serveur',
    'OdbcEdit.mysql.server.description' => 'Le nom d\'hôte du serveur MySQL',
    'OdbcEdit.mysql.database.label' => 'Base de données par défaut',
    'OdbcEdit.mysql.user.label' => 'Nom d\'utilisateur',
    'OdbcEdit.mysql.user.description' => 'Le nom d\'utilisateur utilisé pour la connexion à MySQL',
    'OdbcEdit.mysql.password.label' => 'Mot de passe',
    'OdbcEdit.mysql.password.description' => 'Mot de passe du compte utilisateur sur le serveur',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Le port TCP/IP à utiliser si le serveur n\'est pas l\'hôte local',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Pipe nommé Windows à connecter si le serveur est l\'hôte local',
    'OdbcEdit.mysql.option.label' => 'Option',
    'OdbcEdit.mysql.option.description' => 'Options qui spécifient le fonctionnement de MyODBC. Pour en savoir plus, consultez la <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentation</a>.',

    'ProtectedDirectoryList.title' => 'Répertoires protégés de %%domainName%%',
    'ProtectedDirectoryList.add' => 'Ajouter un répertoire protégé',
    'ProtectedDirectoryList.addTooltip' => 'Créez un répertoire protégé.',
    'ProtectedDirectoryList.name' => 'Nom',
    'ProtectedDirectoryList.realmTitle' => 'Titre de la zone protégée',
    'ProtectedDirectoryList.noSelectionText' => 'Sélectionnez un ou plusieurs éléments à supprimer.',
    'ProtectedDirectoryList.edit' => 'Éditer',
    'ProtectedDirectoryList.remove' => 'Supprimer la protection',
    'ProtectedDirectoryList.removeTooltip' => 'Supprimez la protection des répertoires sélectionnés.',
    'ProtectedDirectoryList.removeConfirmation' => 'Cette opération entraînera la suppression de la protection {count, plural, =1 {du répertoire {name}} other {des # répertoires sélectionnés}}. {count, plural, =1 {Ce répertoire sera alors accessible} other {Ces répertoires seront alors accessibles}} librement par les internautes.',
    'ProtectedDirectoryList.removeSuccess' => 'Les répertoires sélectionnés ont été supprimés.',

    'ProtectedDirectoryAdd.title' => 'Créez un répertoire protégé',
    'ProtectedDirectoryAdd.submit' => 'Créer',
    'ProtectedDirectoryAdd.success' => 'Le répertoire protégé %%path%% a bien été créé',

    'ProtectedDirectoryEdit.title' => 'Paramètres du répertoire protégé',
    'ProtectedDirectoryEdit.success' => 'Les paramètres du répertoire protégé ont été changés',
];