<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'N° de la clé de licence',
    'additional-keys.keyName' => 'Nom de la licence',
    'additional-keys.keyApp' => 'Application',
    'additional-keys.addGroup' => 'Ajouter',
    'additional-keys.upload' => 'Installer la nouvelle clé',
    'additional-keys.uploadDescription' => 'Envoyez et installez une nouvelle clé de licence.',
    'additional-keys.actionsGroup' => 'Actions',
    'additional-keys.install' => 'Installer',
    'additional-keys.installAll' => 'Tout installer',
    'additional-keys.installDescription' => 'Installez les clés de licence sélectionnées.',
    'additional-keys.installNoSelection' => 'Sélectionnez une ou plusieurs clés de licence supplémentaires à installer ou cliquez sur "Tout installer".',
    'additional-keys.installSuccess' => 'L\'installation de la clé de licence a démarré.',
    'additional-keys.removeGroup' => 'Supprimer',
    'additional-keys.remove' => 'Supprimer',
    'additional-keys.removeDescription' => 'Supprimez les clés de licence sélectionnées.',
    'additional-keys.removeNoSelection' => 'Sélectionnez une ou plusieurs clés de licence à supprimer.',
    'additional-keys.removeConfirmation' => 'Voulez-vous supprimer {count, plural, =1 {la clé de licence {name}} one {# clé de licence sélectionnée} other {les # clés de licences sélectionnées}} ?',
    'additional-keys.removeSuccess' => 'Les clés de licence sélectionnées ont été supprimées.',
    'additional-keys.download' => 'Télécharger la licence',
    'additional-keys.downloadDescription' => 'Téléchargez la clé de licence.',
    'additional-keys.emptyViewTitle' => 'Aucune autre clé de licence',

    'backup.tasks.startDate' => 'Démarrée le',
    'backup.tasks.targetRepo' => 'Emplacement du stockage cible',
    'backup.tasks.progress' => 'Progression de la tâche',
    'backup.tasks.repoTypeLocal' => 'Serveur',
    'backup.tasks.repoTypeFtp' => 'FTP personnel',
    'backup.tasks.buttonRemoveTask' => 'Supprimer',
    'backup.tasks.hintRemoveTask' => 'Supprimez les tâches de sauvegarde sélectionnées.',
    'backup.tasks.buttonReload' => 'Actualiser',
    'backup.tasks.hintReload' => 'Actualisez la liste des tâches pour obtenir le statut réel.',
    'backup.tasks.statusTaskWarnings' => 'Avertissements',
    'backup.tasks.statusTaskInfo' => 'Informations',
    'backup.tasks.statusTaskFailed' => 'Échouée',

    'backup.disabledSelectHint' => 'Impossible de supprimer la sauvegarde. Cette sauvegarde fait partie d\'une sauvegarde serveur, revendeur ou client.',
    'backup.buttonBackup' => 'Sauvegarder',
    'backup.hintBackup' => 'Créez une sauvegarde.',
    'backup.buttonSchedule' => 'Planification',
    'backup.hintSchedule' => 'Indiquez les paramètres de la tâche de sauvegarde planifiée.',
    'backup.buttonReload' => 'Actualiser',
    'backup.hintReload' => 'Actualisez la liste des sauvegardes.',
    'backup.buttonUpload' => 'Envoyer',
    'backup.hintUpload' => 'Envoyez un fichier de sauvegarde depuis votre ordinateur vers le répertoire de stockage du serveur.',
    'backup.buttonSettings' => 'Paramètres',
    'backup.hintSettings' => 'Configurez les paramètres de sauvegarde globale des données pour réduire la charge du CPU du serveur.',
    'backup.buttonRemoteStorages' => 'Paramètres du stockage distant',
    'backup.hintRemoteStorages' => 'Configurez votre stockage distant personnel pour stocker les fichiers de sauvegardes.',
    'backup.buttonRemove' => 'Supprimer',
    'backup.hintRemove' => 'Supprimez les sauvegardes sélectionnées depuis le stockage du serveur.',
    'backup.systemNotes' => 'Notes du système',
    'backup.incremental' => 'Incrémentale.',
    'backup.multiVolume' => 'Multivolume.',
    'backup.remoteStorage' => 'Dans le stockage : %%storage%%',
    'backup.status' => 'S',
    'backup.statusOff' => 'Cette sauvegarde n\'est pas valide. Impossible de restaurer les données à partir de ce fichier. Cliquez sur le nom de la sauvegarde pour voir les détails.',
    'backup.statusWarning' => 'Cette sauvegarde n\'est pas entièrement valide. Cliquez sur le nom de la sauvegarde pour voir les détails.',
    'backup.statusInfo' => 'Il s\'agit d\'une sauvegarde valide. Vous pouvez restaurer les données depuis cette sauvegarde, toutefois, des problèmes mineurs peuvent se produire selon le type de stockage des données.',
    'backup.statusOn' => 'Il s\'agit d\'une sauvegarde valide. Les données peuvent être restaurées à partir de cette sauvegarde.',
    'backup.date' => 'Date de création',
    'backup.name' => 'Nom',
    'backup.comment' => 'Commentaires',
    'backup.size' => 'Taille',
    'backup.download' => 'Téléchargez le fichier de sauvegarde vers votre ordinateur local.',
    'backup.downloadDisabled' => 'Le téléchargement du fichier de sauvegarde est momentanément indisponible. Veuillez réessayer ultérieurement ou contacter votre fournisseur.',
    'backup.total' => 'Nombre total de sauvegardes : %%total%%, taille : %%totalSize%%',
    'backup.totalFound' => 'Sauvegardes trouvées : %%found%% (total : %%total%%), taille : %%totalSize%%',
    'backup.confirmOnDelete' => 'Voulez-vous vraiment supprimer les sauvegardes sélectionnées ?',
    'backup.incrementsRemovalLoading' => 'Chargement...',
    'backup.incrementsRemovalConfirmation' => 'Je confirme vouloir supprimer les sauvegardes sélectionnées.',
    'backup.backupHasIncrements' => 'La sauvegarde %%backupName%% sera supprimée, tout comme ses incrémentations : %%backupIncrements%%.',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Nom d\'utilisateur ou mot de passe incorrect pour le stockage FTP',
    'backup.ftpStorageErrorResolveHost' => "Impossible de résoudre le nom d'hôte",
    'backup.ftpStorageErrorConnection' => "Impossible de se connecter au serveur distant",
    'backup.unableToGetFtpDumpList' => 'Impossible d\'afficher la liste des sauvegardes dans le stockage FTP : %%errorMessage%%. Veuillez vérifier les <a href="%%ftpSettingsUrl%%">Paramètres du stockage FTP</a>.',
    'backup.unableToGetExtDumpList' => 'Impossible d\'afficher la liste des sauvegardes dans le stockage %%storageTitle%% : %%errorMessage%%. Vérifiez les paramètres du stockage.',
    'backup.unableToGetLocalDumpList' => 'Impossible d\'afficher la liste des sauvegardes stockées sur le serveur : %%errorMessage%%.',
    'backup.skippedFilesAtExtStorage' => 'Certains fichiers dans le stockage %%storageTitle%% ne sont pas affichés dans cette liste, car leurs noms ne sont pas conformes à la convention de nommage des fichiers de sauvegarde. Si vous êtes sûr que ces fichiers sont des sauvegardes valides, renommez-les conformément au modèle : "backup_%%objectName%%&lt;YYMMDDHHmm&gt;.%%ext%%".',
    'backup.multiVolumeShow' => 'Afficher les volumes',
    'backup.multiVolumeHide' => 'Masquer les volumes',
    'backup.backEncryptionRequired' => 'Pour des raisons de sécurité, nous vous recommandons de protéger à l\'aide d\'un mot de passe les données confidentielles incluses dans la sauvegarde. Allez sous %%link%% et mettez à jour les paramètres de sécurité de la sauvegarde.',
    'backup.backupSettingPage' => 'Paramètres de sauvegarde',
    'backup.statusTaskProgress' => 'La tâche de sauvegarde est en cours.',
    'backup.statusTaskWarnings' => 'La tâche de sauvegarde a terminé avec des avertissements.',
    'backup.statusTaskInfo' => 'Informations.',
    'backup.statusTaskFailed' => 'La tâche de sauvegarde a échoué.',
    'backup.statusTaskStopping' => 'La tâche de sauvegarde est en cours d\'arrêt.',
    'backup.statusTaskStopped' => 'La tâche de sauvegarde a été arrêtée.',

    'backup.schedule.columnSchedule' => 'Planification',
    'backup.schedule.columnContent' => 'Contenu',
    'backup.schedule.columnStorage' => 'Stockage',
    'backup.schedule.periodHourly' => 'Horaire',
    'backup.schedule.periodHourlySchedule' => '({period, plural, one {chaque heure} other {toutes les # heures}})',
    'backup.schedule.periodDaily' => 'Ts les jours',
    'backup.schedule.periodDailySchedule' => '(à %%hours%%:%%minutes%%)',
    'backup.schedule.periodWeekly' => 'Ttes les semaines',
    'backup.schedule.periodWeeklySchedule' => '(le %%day%% à %%hours%%:%%minutes%%)',
    'backup.schedule.periodMonthly' => 'Ts les mois',
    'backup.schedule.periodMonthlySchedule' => '(le %%day%% à %%hours%%:%%minutes%%)',
    'backup.schedule.periodCustom' => 'Personnalisé',
    'backup.schedule.dayFirst' => 'premier',
    'backup.schedule.dayLast' => 'dernier',
    'backup.schedule.day' => '{day, selectordinal, one {#er} other {#e}}',
    'backup.schedule.storageLocal' => 'Stockage du serveur',
    'backup.schedule.storageBoth' => 'Serveur de stockage et %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'La sauvegarde planifiée a été désactivée.',

    'custombuttons.buttonAdd' => 'Ajouter un lien vers un service',
    'custombuttons.buttonAddDescription' => 'Ajoutez un lien vers un service en ligne et placez-le dans Plesk.',
    'custombuttons.buttonRemove' => 'Supprimer',
    'custombuttons.buttonRemoveDescription' => 'Supprimez les liens sélectionnés.',
    'custombuttons.removeConfirmMessage' => 'Supprimer les liens sélectionnés ?',
    'custombuttons.headerPublic' => 'A',
    'custombuttons.headerLocation' => 'V',
    'custombuttons.headerImage' => 'Image',
    'custombuttons.headerPriority' => 'Priorité',
    'custombuttons.headerLabel' => 'Intitulé',
    'custombuttons.headerUrl' => 'URL',
    'custombuttons.headerDescription' => 'Description',
    'custombuttons.publicEnabledDescription' => 'Les utilisateurs peuvent voir le lien.',
    'custombuttons.publicDisabledDescription' => 'Les utilisateurs ne peuvent pas voir le lien.',
    'custombuttons.altPublicEnabledIcon' => 'Public',
    'custombuttons.altPublicDisabledIcon' => 'Privé',
    'custombuttons.placeNavigationDescription' => 'Le lien est situé sur toutes les pages.',
    'custombuttons.placeAdminDescription' => 'Le lien est situé sur la page d\'accueil de l\'administrateur.',
    'custombuttons.placeAdminSettingsDescription' => 'Le lien est situé sur la page Outils & Paramètres de l\'administrateur.',
    'custombuttons.placeResellerDescription' => 'Le lien est situé sur la page d\'accueil du revendeur.',
    'custombuttons.placeResellerSettingsDescription' => 'Le lien est situé sur la page Outils & Utilitaires du revendeur.',
    'custombuttons.placeClientDescription' => 'Le lien est situé sur la page d\'accueil du client.',
    'custombuttons.placeDomainDescription' => 'Le lien est situé sur la page Sites Web & Domaines de l\'abonnement.',
    'custombuttons.placeDomainPropertiesDescription' => 'Le lien se trouve dans la zone des outils de sites Web. Pour y accéder, allez dans Sites Web & Domaines et cliquez sur Afficher plus sous un nom de domaine.',

    'databaseservers.addGroup' => 'Ajouter',
    'databaseservers.addDatabaseServer' => 'Ajouter un serveur de bases de données',
    'databaseservers.addDatabaseServerDescription' => 'Ajoutez un serveur de bases de données.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'Votre clé de licence n\'inclut pas l\'hébergement distant de bases de données.',
    'databaseservers.actionsGroup' => 'Actions',
    'databaseservers.hostingSettings' => 'Paramètres',
    'databaseservers.hostingSettingsDescription' => 'Configurez les paramètres d\'hébergement de la base de données.',
    'databaseservers.refresh' => 'Actualiser',
    'databaseservers.refreshDescription' => 'Actualisez les informations relatives aux serveurs de bases de données.',
    'databaseservers.removeGroup' => 'Supprimer',
    'databaseservers.remove' => 'Supprimer',
    'databaseservers.removeDescription' => 'Supprimez les serveurs de bases de données sélectionnés.',
    'databaseservers.lastError' => 'S',
    'databaseservers.type' => 'Type de serveur',
    'databaseservers.host' => 'Nom de l\'hôte',
    'databaseservers.hostLink' => 'Affichez ou modifiez les propriétés du serveur de base de données.',
    'databaseservers.port' => 'Port',
    'databaseservers.version' => 'Version',
    'databaseservers.databasesCount' => 'Bases de données',
    'databaseservers.databasesCountLink' => 'Gérez les bases de données hébergées sur ce serveur.',
    'databaseservers.databaseUpgradeLink' => 'Mettez à niveau le serveur de bases de données hébergé sur ce serveur.',
    'databaseservers.webadmin' => 'Admin Web',
    'databaseservers.webadminHint' => 'Accédez ce serveur via DB Webadmin.',
    'databaseservers.downloadMsSqlClient' => 'Télécharger un client SQL local',
    'databaseservers.downloadMsSqlClientHint' => 'Télécharger un client SQL local',
    'databaseservers.changePassword' => 'Changer le mot de passe de l\'administrateur',
    'databaseservers.changePasswordHint' => 'Modifiez le mot de passe de l\'administrateur du serveur de bases de données.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Microsoft SQL Server',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'Par défaut pour MySQL',
    'databaseservers.default_for_mssql' => 'par défaut pour MS SQL',
    'databaseservers.default_for_postgresql' => 'Par défaut pour PostgreSQL',
    'databaseservers.default_for_mariadb' => 'valeurs par défaut de MariaDB',
    'databaseservers.default_for_percona' => 'valeurs par défaut de Percona',
    'databaseservers.status_no_error' => 'La dernière tentative de connexion à ce serveur a réussi.',
    'databaseservers.status_connection_failed' => 'La dernière tentative pour se connecter à ce serveur a échoué à cause de problèmes de réseau.',
    'databaseservers.status_permission_denied' => 'Lors de la dernière tentative de connexion à ce serveur, l\'accès a été refusé. Veuillez vérifier les données d\'accès de l\'administrateur pour ce serveur.',
    'databaseservers.status_other_error' => 'Une erreur est survenue lors de la dernière tentative de connexion à ce serveur.',
    'databaseservers.status_credentials_not_set' => 'Vous devez indiquer un mot de passe et nom d\'utilisateur administrateur valides avant la connexion de Plesk à ce serveur.',
    'databaseservers.mssqlServerPortUndefined' => 'Impossible de déterminer le numéro de port TCP utilisé par Microsoft SQL Server \'%%host%%\' : le protocole TCP/IP n\'est pas activé dans la configuration réseau du serveur ou le serveur est configuré pour utiliser les ports TCP dynamiques.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'Afin de permettre à vos clients de configurer automatiquement le pare-feu pour l\'accès aux bases de données à distance, configurez le serveur SQL manuellement de sorte qu\'il écoute un port TCP fixe spécifique.',
    'databaseservers.removeEmptySelection' => 'Aucun serveur de bases de données n\'est sélectionné.',
    'databaseservers.removeConfirmation' => 'Voulez-vous vraiment supprimer {count, plural, =1 {le serveur de base de données {name}} one {# serveur de bases de données sélectionné} other {les # serveurs de bases de données sélectionnés}}?',
    'databaseservers.removeSuccess' => 'Les serveurs de bases de données sélectionnés ont bien été supprimés.',

    'databaseserverdatabases.actionsGroup' => 'Actions',
    'databaseserverdatabases.assignToSubscription' => 'Déplacer vers l\'abonnement',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'Déplacez les bases de données sélectionnées vers un autre abonnement.',
    'databaseserverdatabases.removeGroup' => 'Supprimer',
    'databaseserverdatabases.remove' => 'Supprimer',
    'databaseserverdatabases.removeDescription' => 'Supprimez les bases de données sélectionnées.',
    'databaseserverdatabases.name' => 'Nom',
    'databaseserverdatabases.subscription' => 'Abonnement',
    'databaseserverdatabases.client' => 'Abonné',
    'databaseserverdatabases.manageDatabase' => 'Gérer l\'hébergement',
    'databaseserverdatabases.manageDatabaseDescription' => 'Gérez la base de données.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Ouvrir dans le Panneau Revendeur',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Gérez la base de données dans le Panneau Revendeur de l\'abonné.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Ouvrir dans le Panneau Client',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Gérez la base de données dans le Panneau Client de l\'abonné.',
    'databaseserverdatabases.emptySelection' => 'Aucune base de données n\'est sélectionnée.',
    'databaseserverdatabases.removeConfirmation' => 'Voulez-vous vraiment supprimer {count, plural, =1 {la base de données {name}} one {la base de données sélectionnée} other {les # bases de données sélectionnées}} ?',
    'databaseserverdatabases.removeSuccess' => 'Les serveurs de bases de données sélectionnés ont bien été supprimés.',

    'logbrowser.issuesFoundInTheLogs' => 'Des problèmes ont été détectés dans les journaux du site Web',
    'logbrowser.learnAboutProblemsFaster' => 'Recevoir plus rapidement les notifications relatives aux problèmes',
    'logbrowser.noProblemsFound' => 'Aucun problème détecté dans les journaux du site Web',
    'logbrowser.lastCheckDetectsProblems' => 'La vérification %%checkType%% des journaux a détecté des problèmes qui peuvent affecter le fonctionnement de votre site Web. Pour voir les détails et les solutions possibles, cliquez sur "Ouvrir le rapport de contrôle".',
    'logbrowser.lastCheckDetectsNoProblems' => 'La vérification %%checkType%% des journaux n\'a pas détecté de problèmes qui peuvent affecter le fonctionnement de votre site Web.',
    'logbrowser.noChecksResults' => 'La vérification quotidienne est activée, mais aucune vérification n\'a été effectuée.',
    'logbrowser.manual' => 'Manuelle',
    'logbrowser.regular' => 'Automatique et quotidienne',
    'logbrowser.enableRegularCheck' => 'Une vérification quotidienne des journaux détecte les problèmes qui peuvent affecter le fonctionnement de votre site Web. Si des problèmes apparaissent, Plesk vous informe et vous propose des solutions possibles.',
    'logbrowser.new' => 'NOUVEAU',
    'logbrowser.openCheckReport' => 'Ouvrir le rapport de contrôle',
    'logbrowser.openCheckSettings' => 'Ouvrir les paramètres des vérifications',

    'logbrowser.buttonStartRealtime' => 'Lancer les mises à jour en temps réel',
    'logbrowser.buttonStartRealtimeHint' => 'Mettez à jour les données du journal en temps réel.',
    'logbrowser.buttonStopRealtime' => 'Arrêter les mises à jour en temps réel',
    'logbrowser.buttonStopRealtimeHint' => 'Arrêtez les mises à jour des données du journal en temps réel.',
    'logbrowser.buttonRefresh' => 'Actualiser',
    'logbrowser.buttonRefreshHint' => 'Actualisez les données du journal.',
    'logbrowser.buttonClear' => 'Effacer',
    'logbrowser.buttonClearHint' => 'Masquez les entrées déjà envoyées.',
    'logbrowser.buttonAddCustom' => 'Ajouter à l\'Explorateur de journaux en tant que fichier personnalisé',
    'logbrowser.buttonAddCustomHint' => 'Le fichier sera affiché dans l\'Explorateur de journaux avec d\'autres fichiers journaux.',
    'logbrowser.date' => 'Date',
    'logbrowser.dateFilterPlaceholder' => 'Du',
    'logbrowser.type' => 'Type',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Code',
    'logbrowser.codeFilterPlaceholder' => 'Code',
    'logbrowser.message' => 'Message',
    'logbrowser.messageFilterPlaceholder' => 'Message',
    'logbrowser.source' => 'Source',
    'logbrowser.sourceFilterFiles' => '%%count%% fichiers',
    'logbrowser.sourceFilterAllLogs' => 'Tous les journaux',
    'logbrowser.sourceFilterNoLogs' => 'Aucun journal',
    'logbrowser.manageLogFiles' => 'Gérer les fichiers journaux',
    'logbrowser.addCustomLogFile' => 'Ajouter un fichier journal personnalisé',
    'logbrowser.customLogPopupTitle' => 'Ajouter un fichier journal personnalisé',
    'logbrowser.invalidLogFormat' => 'Le fichier journal a un format non pris en charge.',
    'logbrowser.referer' => 'Applications récurrentes',
    'logbrowser.refererHint' => 'Référant',
    'logbrowser.agent' => 'Agent',
    'logbrowser.agentHint' => 'Agent de l\'utilisateur',
    'logbrowser.size' => 'Taille',
    'logbrowser.unknown' => 'Inconnu',
    'logbrowser.more' => 'Plus',
    'logbrowser.less' => 'Moins',
    'logbrowser.any' => 'Tou(te)s',
    'logbrowser.none' => 'Aucun',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% ou utiliser des filtres pour réduire la liste des entrées.',
    'logbrowser.loadMore' => 'Charger les entrées précédentes',
    'logbrowser.clear' => 'Effacer',
    'logbrowser.hourAgo' => 'Heure préc.',
    'logbrowser.prevDay' => 'Jour préc.',
    'logbrowser.linkInMessageToViewFile' => 'Cliquez pour voir le fichier.',
    'logbrowser.buttonUnlinkHint' => 'Cliquez pour arrêter de suivre les mises à jour dans ce fichier dans l\'Explorateur de journaux.',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Êtes-vous sûr de vouloir arrêter de suivre les mises à jour dans ce fichier dans l\'Explorateur de journaux ?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Oui',
    'logbrowser.buttonUnlinkConfirmationNo' => 'Non',
    'logbrowser.logRotation' => 'Rotation des journaux',
    'logbrowser.logRotationHint' => 'Configurez les paramètres de rotation des journaux pour le site Web.',
    'logbrowser.logRotationTitle' => 'Configurer la rotation des journaux',

    'notifications.title' => 'Configurer l\'envoi des notifications de messagerie lors d\'événements du système',
    'notifications.legendNotifications' => 'Notifications',
    'notifications.legendSettings' => 'Paramètres',
    'notifications.headerEvent' => 'Événement',
    'notifications.headerSendTo' => 'Envoyer la notification à :',
    'notifications.headerText' => 'Texte',
    'notifications.headerPreview' => 'Aperçu',
    'notifications.headerAdmin' => 'Administrateur',
    'notifications.headerReseller' => 'Revendeur',
    'notifications.headerClient' => 'Client',
    'notifications.headerEmailAddress' => 'Adresse mail',
    'notifications.expirationTime' => 'Envoyer des avertissements d\'expiration',
    'notifications.days' => 'jours à l\'avance',
    'notifications.smtpSettings' => 'Pour activer l\'envoi de notifications de Plesk lorsque le relais est fermé, vous pouvez %%link%%',
    'notifications.smtpSettingsLink' => 'changer les paramètres SMTP.',
    'notifications.editHint' => 'Éditer le texte du message.',
    'notifications.previewHint' => 'Voyez à quoi ressemble la notification dans les e-mails.',
    'notifications.reseller_creation' => 'Création d\'un compte revendeur',
    'notifications.reseller_limits_exceed' => 'Limites d\'utilisation des ressources dépassées par le compte revendeur',
    'notifications.reseller_blocked' => 'Le compte revendeur est suspendu en raison de la sur-utilisation des ressources',
    'notifications.reseller_overuse_block' => 'Les limites des ressources du revendeur ont été atteintes par les abonnements du revendeur à cause d\'une survente.',
    'notifications.client_creation' => 'Création d\'un compte client',
    'notifications.domain_creation' => 'Création du site',
    'notifications.domain_exp_warning' => 'Avertissement d\'expiration de l\'abonnement',
    'notifications.domain_expiration' => 'Expiration de l\'abonnement',
    'notifications.domain_limits_exceed' => 'Limites d\'utilisation des ressources dépassées par l\'abonnement',
    'notifications.domain_blocked' => 'L\'abonnement est suspendu en raison de la sur-utilisation des ressources',
    'notifications.admin_aps_app_updates' => 'Mise à jour de l\'application APS (digest administrateur)',
    'notifications.reseller_aps_app_updates' => 'Mises à jour des applications APS (digest revendeur)',
    'notifications.client_aps_app_updates' => 'Mises à jour des applications APS (digest clients)',
    'notifications.admin_pum_updates' => 'Mises à jour système : notifications de nouvelles mises à jour',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'Limite dépassée pour les mails sortants',
    'notifications.subscription_cgroups_limits_exceed' => 'RAM, CPU et E/S disque (Cgroups)',
    'notifications.admin_postponed_feedback' => 'Rappel de feedback',
    'notifications.errorInvalidEmail' => 'Adresse mail incorrecte.',
    'notifications.errorInvalidExpTime' => 'Nombre de jours incorrect.',
    'notifications.errorUpdate' => 'Mise à jour notification impossible : %%error%%',
    'notifications.updated' => 'Les paramètres des notifications ont été mis à jour',

    'outgoingmail.name' => 'Nom',
    'outgoingmail.maxOutgoingMessages' => 'Limite par heure',
    'outgoingmail.numOfExceedingAttempts' => 'Tentatives après atteinte de la limite',
    'outgoingmail.lastAttemptAt' => 'Dernière tentative',
    'outgoingmail.mailStatus' => 'Statut du mail',
    'outgoingmail.mailStatusSending' => 'Envoi en cours',
    'outgoingmail.mailStatusNotSending' => 'Envoi non lancé',
    'outgoingmail.mailStatusSendingDesc' => 'Le mail est envoyé.',
    'outgoingmail.mailStatusNotSendingDesc' => 'Le mail n\'est pas envoyé.',
    'outgoingmail.limitValueUnlimited' => 'Illimité',

    'scheduler.tasks.headerCommand' => 'Commande',
    'scheduler.tasks.headerSchedule' => 'Planification',
    'scheduler.tasks.headerSubscription' => 'Abonnement',
    'scheduler.tasks.headerSubscription_powerUser' => 'Espace Web',
    'scheduler.tasks.buttonToggleHintOn' => 'La tâche est activée. Cliquez pour désactiver la tâche.',
    'scheduler.tasks.buttonToggleHintOff' => 'La tâche est désactivée. Cliquez pour activer la tâche.',
    'scheduler.tasks.add' => 'Ajouter une tâche',
    'scheduler.tasks.hintAdd' => 'Planifiez une nouvelle tâche.',
    'scheduler.tasks.remove' => 'Supprimer',
    'scheduler.tasks.hintRemove' => 'Supprimez les tâches sélectionnées.',
    'scheduler.tasks.confirmOnDelete' => 'Voulez-vous vraiment supprimer les tâches sélectionnées ?',
    'scheduler.tasks.sync' => 'Actualiser',
    'scheduler.tasks.hintSync' => 'Actualisez la liste des tâches pour obtenir les données réelles.',
    'scheduler.tasks.settings' => 'Paramètres',
    'scheduler.tasks.hintSettings' => 'Modifiez les paramètres des tâches planifiées.',
    'scheduler.tasks.deleteSuccess' => 'Les tâches planifiées ont été supprimées.',
    'scheduler.tasks.serverTask' => 'serveur (utilisateur :%%user%%)',
    'scheduler.tasks.unknownUser' => 'inconnu',
    'scheduler.tasks.runTaskNow' => 'Exécuter maintenant',
    'scheduler.tasks.runTaskNowHint' => 'Exécutez la tâche maintenant.',
    'scheduler.tasks.runningTask' => 'Exécution de la tâche "%%task%%"...',

    'server-components.bcTitle' => 'Composants du serveur',
    'server-components.title' => 'Composants de Plesk',
    'server-components.name' => 'Nom du composant',
    'server-components.version' => 'Version du composant',
    'server-components.refresh' => 'Actualiser',
    'server-components.componentName' => 'Saisissez le nom du composant...',
    'server-components.noComponents' => 'Aucun composant trouvé',
    'server-components.componentsListUpdated' => 'La liste des composants a été mise à jour.',

    'server-components.componentName.urlrewrite' => 'Réécriture de l\'URL',
    'server-components.componentName.dbconnector' => "Connecteur de la base de données",
    'server-components.componentName.mysqlserver' => 'Serveur MySQL',
    'server-components.componentName.troubleshooting' => 'Résolution des problèmes',
    'server-components.componentName.waf' => 'Pare-feu des applications Web',
    'server-components.componentName.vcs' => 'Gestion de versions',
    'server-components.componentName.dotnetcore' => '.NET Core',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Initialisation de l'application",
    'server-components.componentName.httpcompression' => 'Compression de contenu HTTP',
    'server-components.componentName.antivirus' => "Antivirus",
    'server-components.componentName.database' => "Serveur SQL",
    'server-components.componentName.sqladmin' => "MySQL Webadmin",
    'server-components.componentName.sqladminmysql' => "MySQL Webadmin",
    'server-components.componentName.dnsserver' => "Serveur DNS",
    'server-components.componentName.firewall' => "Pare-feu",
    'server-components.componentName.ftpserver' => "Serveur FTP",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "Serveur de messagerie",
    'server-components.componentName.local_mailserver' => "Serveur de messagerie local",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Script Web",
    'server-components.componentName.spamfilter' => "Filtre anti-spam",
    'server-components.componentName.stats' => "Statistiques Web",
    'server-components.componentName.stunnel' => "Wrapper SSL/TLS",
    'server-components.componentName.webmail' => "Messagerie Web",
    'server-components.componentName.webpublish' => "Publication Web",
    'server-components.componentName.webserver' => "Serveur Web",
    'server-components.componentName.network' => 'Mise en réseau',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Hébergement Plesk",
    'server-components.componentName.savi' => 'Interface antivirus Sophos',

    'server-components.tooltip.disabled' => 'Désactivé',
    'server-components.tooltip.active' => 'Actif',
    'server-components.tooltip.notConfigured' => 'Non configuré',
    'server-components.tooltip.notStarted' => 'Non démarré, vérifiez les paramètres du composant.',

    'server-components.defaultComponents.circularDependencies' => "Des dépendances circulaires ont été trouvées entre les catégories %%cat1%% et %%cat2%%.",
    'server-components.defaultComponents.not_installed' => "(n'est pas installé)",
    'server-components.defaultComponents.not_configured' => "(pas configuré)",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Les sélections de certaines catégories de services ne sont pas valables, ou aucune sélection n'a été faite.",
    'server-components.defaultComponents.depends_on' => "(requiert %%name%%)",
    'server-components.defaultComponents.not_activated' => 'pas activé',
    'server-components.defaultComponents.imap_required' => '(Le serveur de messagerie actuel ne prend pas en charge IMAP)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(Le serveur FTP ne prend pas en charge d'adresse IPv6.)",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(la règle de délégation requise \'appPoolPipeline, appPoolNetFx\' n\'existe pas)',
    'server-components.defaultComponents.not_supported_version' => '(version non prise en charge)',
    'server-components.defaultComponents.no_license' => '(Non autorisé par la clé de licence)',
    'server-components.defaultComponents.license_expired' => '(la clé de licence a expiré)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(limite des boîtes de messagerie dépassée pour cette clé de licence)',
    'server-components.defaultComponents.title' => 'Sélectionnez le composant %%name%% par défaut.',
    'server-components.defaultComponents.none' => 'Aucun',
    'server-components.defaultComponents.yes' => 'Oui',
    'server-components.defaultComponents.no' => 'Non',
    'server-components.defaultComponents.warning' => 'Attention !',
    'server-components.defaultComponents.parametersOfComponent' => 'Paramètres de %%component%%',
    'server-components.defaultComponents.success' => 'Le composant par défaut a été mis à jour.',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "La changement de serveur de messagerie est destiné uniquement à la configuration initiale. Si le serveur est déjà en service, cela entraîne les problèmes suivants : perte des paramètres et du contenu des boîtes de messagerie. Et, si le nouveau serveur est déjà configuré, cela génère divers conflits.\nSi le serveur est en service actuellement et si vous voulez vraiment changer pour un autre serveur, vous pouvez informer vos clients de l'opération afin qu'ils puissent télécharger et sauvegarder leurs e-mails.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Seules les 254 premières adresses IP des sous-réseaux avec les masques /8 et /16 dans la liste de contrôle d'accès (ACL, Access Control List) seront transférées. Elles seront transférées en tant qu'adresses IP séparées. Voulez-vous continuer ?",

    'server-components.componentConf.title' => 'Paramètres de %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'Paramètre obligatoire',
    'server-components.componentConf.parameterShouldBeNumber' => 'Le paramètre doit être un nombre',
    'server-components.componentConf.success' => 'Les paramètres ont été mis à jour.',

    'tasks.pollingOff' => 'Désactivé',
    'tasks.pollingDelay' => '%%delay%% s',
    'tasks.stopTaskConfirm' => 'Voulez-vous vraiment arrêter la tâche ?',
    'tasks.stopTaskError' => 'Impossible d\'arrêter la tâche',
    'tasks.stopTask' => 'Arrêter la tâche',
    'tasks.processedLoadFailed' => 'Impossible de charger la liste des processus',
    'tasks.retryTask' => 'Essayer de relancer la tâche',
    'tasks.retryTaskFailed' => 'Impossible de relancer la tâche',
    'tasks.taskCreated' => 'Nouvelle tâche créée',
    'tasks.moreDetails' => 'Consulter le journal du panneau pour en savoir plus',
    'tasks.searchTitle' => 'Rechercher',
    'tasks.searchPlaceholder' => 'Terme recherché',
    'tasks.refresh' => 'Actualiser',
    'tasks.refreshDescription' => 'Actualiser la liste des tâches',
    'tasks.createTask' => 'Créer une tâche',
    'tasks.openSwagger' => 'Ouvrir Swagger',
    'tasks.statusTitle' => 'Statut',
    'tasks.createdTitle' => 'Date de création',
    'tasks.descriptionTitle' => 'Description',
    'tasks.processes.dataLoadFailed' => 'Impossible de récupérer les données du serveur',
    'tasks.processes.commandLineLoadFailed' => 'Impossible d\'obtenir la ligne de commande de la tâche',
    'tasks.processes.stopProcess' => 'Arrêter le processus',
    'tasks.processes.stopProcessFailed' => 'Impossible d\'arrêter le processus',
    'tasks.processes.stopProcessConfirm' => 'Voulez-vous vraiment arrêter le processus ?',
    'tasks.processes.copyToClipboard' => 'Copier dans le presse-papiers',
    'tasks.processes.concurrency' => 'Concurrence',
    'tasks.processes.taskIdSection' => 'ID de la tâche',
    'tasks.processes.requestorIdSection' => 'ID du demandeur',
    'tasks.processes.timeoutSection' => 'Timeout',
    'tasks.processes.createdSection' => 'Date de création',
    'tasks.processes.updatedSection' => 'Mis(e) à jour',
    'tasks.processes.environmentSection' => 'Environnement',
    'tasks.processes.idTitle' => 'ID',
    'tasks.processes.statusTitle' => 'Statut',
    'tasks.processes.startedTitle' => 'Démarré',
    'tasks.processes.completedTitle' => 'Terminé',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Code exit',

    'ts-sessions.columnStateTitle' => 'Statut',
    'ts-sessions.columnUserTitle' => 'Utilisateur',
    'ts-sessions.columnNameTitle' => 'Nom',
    'ts-sessions.refresh' => 'Actualiser',
    'ts-sessions.logoff' => 'Se déconnecter',
    'ts-sessions.logoffConfirmation' => 'Fermer %%count%% session(s) ?',
    'ts-sessions.logoffConfirmationSingle' => 'Fermer la session %%name%% ?',
    'ts-sessions.logoffConfirmationButton' => 'Oui, fermer la session',
    'ts-sessions.logoffNoSelection' => 'Sélectionner une ou plusieurs sessions à fermer',
    'ts-sessions.logoffSuccess' => 'Les sessions sélectionnées ont été fermées.',
    'ts-sessions.disconnect' => 'Déconnecter',
    'ts-sessions.disconnectConfirmation' => 'Déconnecter %%count%% session(s) ?',
    'ts-sessions.disconnectConfirmationSingle' => 'Déconnecter la session %%name%% ?',
    'ts-sessions.disconnectConfirmationButton' => 'Oui, déconnecter',
    'ts-sessions.disconnectSuccess' => 'Les sessions sélectionnées ont été déconnectées.',
    'ts-sessions.disconnectNoSelection' => 'Sélectionner une ou plusieurs sessions à déconnecter',
    'ts-sessions.disconnectNotAvailable' => 'Vous pouvez uniquement déconnecter une session active ou connectée.',

    'client-ip-address.title' => 'Adresses IP',
    'client-ip-address.status' => 'Statut',
    'client-ip-address.type' => 'Type',
    'client-ip-address.ipAddress' => 'Adresse IP',
    'client-ip-address.certificate' => 'Certificat',
    'client-ip-address.hosting' => 'Hébergement',
    'client-ip-address.adminCertificateRepository' => "Référentiel de l'administrateur",
    'client-ip-address.domainCertificateRepository' => 'Dépôt du domaine %%owner%%',
    'client-ip-address.typeShared' => 'Partagé(s)',
    'client-ip-address.typeExclusive' => 'Dédiée',
    'client-ip-address.removeConfirmation' => 'Voulez-vous vraiment supprimer {count, plural, =1 {l\'adresse IP {name}} one {# l\'adresse IP sélectionnée} other {les # adresses IP sélectionnées}} du pool d\'IP de l\'utilisateur ?',
    'client-ip-address.noItemsToRemove' => 'Sélectionnez un ou plusieurs éléments à supprimer.',
    'client-ip-address.ftpOverSSL' => 'FTP sur SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Oui',
    'client-ip-address.ftpOverSSL-no' => 'Non',
    'client-ip-address.ftpOverSSL-allow' => 'Autoriser',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Non autorisé',
    'client-ip-address.add' => 'Ajouter une adresse IP',
    'client-ip-address.noAvailableIps' => 'Il n\'y a aucune adresse IP disponible.',
    'client-ip-address.isOk' => 'L\'Adresse IP fonctionne normalement.',
    'client-ip-address.isBroken' => 'L\'Adresse IP n\'est pas présente sur l\'interface.',
    'client-ip-address.properties.title' => 'Adresse IP %%address%% sur l\'interface %%interface%%',
    'client-ip-address.properties.distributedType' => 'Adresse IP distribuée en tant que',
    'client-ip-address.properties.allocatedType' => 'Adresse IP affectée en tant que',
    'client-ip-address.properties.none' => 'Aucun',
    'client-ip-address.properties.certificate' => 'Certificat SSL/TLS',
    'client-ip-address.properties.defaultSite' => 'Site web par défaut',
    'client-ip-address.assign.title' => 'Sélectionnez les adresses IP',
    'client-ip-address.assign.description' => 'IP libres',
    'client-ip-address.assign.success' => '{count, plural, =1 {L\'adresse IP {name} sélectionnée a bien été ajoutée} one {Les # adresses IP sélectionnées ont bien été ajoutées} other {Les # adresses IP sélectionnées ont bien été ajoutées}} au pool d\'IP de l\'utilisateur.',

    'ip-address-reseller-usage.title' => 'Revendeurs qui utilisent une adresse IP %%type%% %%ipAddress%%',
    'ip-address-reseller-usage.nameColumnHeader' => 'Revendeurs',
    'ip-address-reseller-usage.assignButton' => 'Assigner au revendeur',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'Cette adresse IP exclusive est déjà affectée à tous les utilisateurs.',
    'ip-address-reseller-usage.removeButton' => 'Supprimer',
    'ip-address-reseller-usage.removeSuccess' => 'L\'adresse IP a été supprimée {count, plural, =1 {du pool {name}} one {des # pools de revendeurs sélectionnés} other {des # pools d\'IP des revendeurs sélectionnés}}.',
    'ip-address-reseller-usage.removeConfirmation' => 'Voulez-vous supprimer l\'adresse IP {count, plural, =1 {du pool {name}} one {des # pools de revendeurs sélectionnés} other {des # pools d\'IP des revendeurs sélectionnés}} ',
    'ip-address-reseller-usage.typeSHARED' => 'Partagé(s)',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Dédiée',
    'ip-address-reseller-usage.assign.title' => "Ajouter %%ipAddress%% au pool d'IP du revendeur",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Revendeurs à ajouter',
    'ip-address-reseller-usage.assign.success' => 'L\'adresse IP a été supprimée {count, plural, =1 {du pool {name}} one {des # pools de revendeurs sélectionnés} other {des # pools d\'IP des revendeurs sélectionnés}}.'
];