<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Fișiere jurnal",
    'action-log.fromDate' => "De la:",
    'action-log.toDate' => "Până la:",
    'action-log.clearLog' => "Ștergere jurnal",
    'action-log.downloadLog' => "Descărcare",
    'action-log.loggedActions' => "Acțiuni înregistrate în jurnal",
    'action-log.storeLogsInDb' => "Înregistrările se stochează în baza de date",
    'action-log.storeNumber' => "Intrări",
    'action-log.dontRemoveRecs' => "Înregistrările nu se șterg",
    'action-log.confirmCleanLog' => "Sigur ștergeți înregistrările de acțiuni selectate din fișierele jurnal?",
    'action-log.incorrectDate' => "Data specificată este incorectă.",
    'action-log.incorrectNumPeriods' => "Perioada de rotație specificată este incorectă.",
    'action-log.incorrectNumRecords' => "Numărul de înregistrări specificat este incorect.",
    'action-log.yes' => "Da",
    'action-log.no' => "Nu",
    'action-log.mixed' => "(combinat)",
    'action-log.period' => "Perioada",
    'action-log.invalidDatePeriod' => "Perioadă calendaristică incorectă",
    'action-log.submitDone' => "Modificările setărilor jurnalului de acțiuni au fost salvate.",
    'action-log.clearDone' => "Jurnalul de acțiuni a fost golit.",
    'action-log.periodDay' => "zile",
    'action-log.periodWeek' => "săptămâni",
    'action-log.periodMonth' => "luni",

    'admin-info.adminInfoSection' => 'Informații pentru administrator',
    'admin-info.description-admin' => 'Descrierea administratorului',
    'admin-info.description-reseller' => 'Descrierea resellerului',
    'admin-info.description-owner' => 'Descrierea proprietarului',
    'admin-info.description' => 'Descriere',
    'admin-info.descriptionSuccess' => 'Descrierea a fost actualizată.',
    'admin-info.longDescription' => 'Descrierea specificată este prea lungă. Poate avea cel mult %%max%% simboluri.',
    'admin-info.add' => 'Adăugare descriere',
    'admin-info.edit' => 'Editare',
    'admin-info.remove' => 'Ștergere',
    'admin-info.confirmOnRemove' => 'Sigur ștergeți această descriere?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% al clientului %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% al resellerului %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% al abonamentului %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% pentru %%name%%',
    'admin-info.popupHint-admin' => 'Această descriere este vizibilă doar administratorului.',
    'admin-info.popupHint-reseller' => 'Această descriere este vizibilă resellerului și administratorului.',
    'admin-info.popupHint-owner' => 'Această descriere este vizibilă doar autorului, precum și furnizorului de servicii de găzduire al autorului.',
    'admin-info.customerDescriptionHint' => 'Clienți nu pot vedea această descriere.',
    'admin-info.subscriptionDescriptionHint' => "Această informație este vizibilă doar furnizorului de servicii de găzduire (administrator Plesk sau reseller).",

    'apache-settings.formGeneralHint' => 'Aici puteți specifica setările serverului web Apache pentru acest site. Configurația personalizată de Apache este utilă, de exemplu, atunci când doriți să utilizați un nou tip de fișiere index pe site sau să asociați un anumit tip MIME cu anumite extensii de fișiere. Valoarea implicită înseamnă că Apache va utiliza directiva corespunzătoare din configurația la nivel de server. Dacă Apache funcționează cu nginx ca server frontend, în această pagină puteți specifica și setările nginx.',
    'apache-settings.general' => 'Setări comune Apache',
    'apache-settings.example' => "De exemplu: %%example%%",
    'apache-settings.settingOn' => 'Pornit',
    'apache-settings.settingOff' => 'Oprit (implicit)',
    'apache-settings.settingDefault' => 'Implicit',
    'apache-settings.settingCustom' => 'Introducerea unei valori personalizate',
    'apache-settings.mimeTypes' => 'Tipuri MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'Tipurile MIME asociază extensiile cu tipuri de fișiere. De obicei, acest lucru se folosește la crearea unei extensii personalizate pentru tipurile de fișiere obișnuite.',
    'apache-settings.handlers' => 'Handlere',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Handlerele Apache definesc modul în care serverul web procesează fișierele cu anumite extensii, în momentul în care acestea sunt solicitate. De exemplu, șirul „php-script .script” înseamnă că Apache va prelucra fișierele .script ca scripturi php.",
    'apache-settings.deny' => 'Se refuză accesul la site',
    'apache-settings.allow' => 'Exclusiv',
    'apache-settings.denyExample' => "192.168.0.0/16 192.168.1.110 Gazdele și rețelele specificate nu pot accesa site-ul. Utilizați „*” pentru a refuza toate conexiunile.",
    'apache-settings.allowExample' => "192.168.0.0/16 10.1.1.21 Gazdele și rețelele specificate pot accesa site-ul.",
    'apache-settings.directoryIndex' => 'Fișiere index',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache va căuta fișierele specificate în momentul în care i se solicită pagina index a site-ului.",
    'apache-settings.expires' => 'Expiră',
    'apache-settings.expiresStaticOnly' => 'răspuns cu antete Expiră numai pentru fișierele statice',
    'apache-settings.expiresFullDescription' => 'Serverul web va adăuga antetele de răspuns „Expiră” la paginile web. Marcajul cu timpul de expirare se obține prin adăugarea duratei de timp specificate mai sus la ora la care a fost solicitată pagina web.',
    'apache-settings.expiresStaticOnlyDescription' => 'Antetul „Expiră” se va adăuga numai la fișierele statice. Fișierele considerate statice se identifică în funcție de opțiunile „Procesare inteligentă a fișierelor statice” și „Fișierele statice se deservesc direct din nginx”.',
    'apache-settings.expiresUnitDays' => 'zile',
    'apache-settings.expiresUnitHours' => 'ore',
    'apache-settings.expiresUnitMinutes' => 'minute',
    'apache-settings.expiresUnitSeconds' => 'secunde',
    'apache-settings.headers' => 'Antete suplimentare',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Serverul web va adăuga anteturile de răspuns HTTP specificate.",
    'apache-settings.restrictFollowSymLinks' => 'Se împiedică urmarea linkurilor simbolice',
    'apache-settings.restrictFollowSymLinksDescription' => "Selectați această opțiune pentru a nu le permite utilizatorilor să folosească directiva FollowSymLink în .htaccess și pentru a îmbunătăți securitatea serverului.",
    'apache-settings.nginx' => 'Setări nginx',
    'apache-settings.nginxProxyMode' => 'Mod proxy',
    'apache-settings.nginxProxyModeDescription' => 'Solicitările proxy Nginx către Apache. Opriți pentru a înceta utilizarea Apache.',
    'apache-settings.nginxTransparentMode' => 'Procesare inteligentă a fișierelor statice',
    'apache-settings.nginxTransparentModeDescription' => 'Dacă opțiunea este dezactivată, Apache va procesa toate solicitările de fișiere statice. nginx doar va transmite solicitările și răspunsurile, fără a le modifica. Dezactivați această opțiune numai pentru depanare.',
    'apache-settings.nginxServeStatic' => 'Fișierele statice se deservesc direct din nginx',
    'apache-settings.nginxStaticExtensions' => 'Specificați extensiile de fișiere, separate cu spațiu sau cu simbolul „|”. Solicitările de asemenea fișiere vor fi procesate cu nginx și nu vor ajunge niciodată în Apache. Atenție: Nu se vor aplica regulile de rescriere din Apache.',
    'apache-settings.nginxServePhp' => 'Procesarea PHP cu nginx',
    'apache-settings.nginxServePhpDescription' => 'Fișierele PHP (.php) vor fi procesate cu nginx și PHP-FPM. Dacă dezactivați setarea, fișierele PHP vor fi procesare de Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Dimensiune maximă admisă a corpului de solicitare HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Solicitările cu corpul mai mare decât limita vor fi ignorate și se va returna mesajul HTTP 413 Conținut util prea mare (configurează valoarea de directivă nginx „client_max_body_size”).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'Opțiunea este dezactivată global, printr-o valoare necompletată/zero a directivei „clientMaxBodySize” în panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Activare caching nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'Cachingul poate reduce timpul de răspuns al site-ului și încărcarea serverului, dar trebuie folosit cu grijă.',
    'apache-settings.nginxCacheSize' => 'Dimensiune cache',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Expirare cache',
    'apache-settings.nginxCacheTimeoutDays' => 'zile',
    'apache-settings.nginxCacheTimeoutHours' => 'ore',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minute',
    'apache-settings.nginxCacheTimeoutSeconds' => 'secunde',
    'apache-settings.nginxCacheKey' => 'Cheie cache',
    'apache-settings.nginxCacheCookies' => 'Păstrare solicitări în cache cu fișiere cookie',
    'apache-settings.nginxCacheBypassLocations' => 'Dezactivare caching pentru locații',
    'apache-settings.nginxCacheBypass' => 'Ocolire cache dacă',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'Solicitarea primită conține antete HTTP no-cache',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'Solicitarea primită conține antete de autorizare HTTP',
    'apache-settings.nginxCacheBypassGetNocache' => 'Solicitarea primită conține parametrul GET nocache',
    'apache-settings.nginxCacheUseStale' => 'Returnare înregistrări cache învechite',
    'apache-settings.nginxCacheUseStale5xx' => 'Din amonte se returnează o eroare de server 5xx',
    'apache-settings.nginxCacheUseStale4xx' => 'Din amonte se returnează o eroare de client 4xx',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Se actualizează cache-ul.',
    'apache-settings.additional' => 'Directive Apache suplimentare',
    'apache-settings.additionalSettingsDescription' => 'Dacă nu găsiți anumite setări, adăugați-le în câmpurile de mai jos. Acestea setări vor avea prioritate față de directivele Apache la nivel de server. Directivele din primul câmp se utilizează atunci când un vizitator accesează site-ul prin HTTP. Al doilea câmp conține directivele de HTTPS. În general, se recomandă să scrieți directive în ambele câmpuri. Utilizați aceeași sintaxă ca în httpd.include. De exemplu, dacă doriți să setați o pagină de eroare personalizată, adăugați rândul: ErrorDocument 401 /pagina_mea_de_eroare.html',
    'apache-settings.additionalSettings' => 'Directive suplimentare pentru HTTP',
    'apache-settings.additionalSslSettings' => 'Directive suplimentare pentru HTTPS',
    'apache-settings.additionalSettingsError' => 'Configurație Apache incorectă: %%error%%',
    'apache-settings.rollbackFailed' => 'Imposibil de utilizat fișierul de configurație Apache actual și de revenit la cel anterior, întrucât ambele conțin configurații incorecte.',
    'apache-settings.additionalNginx' => 'Directive nginx suplimentare',
    'apache-settings.additionalNginxSettingsDescription' => 'Aici puteți specifica setările serverului proxy invers nginx care se execută în fața serverului Apache. Directivele dvs. vor avea prioritate față de configurația nginx la nivel de server. De exemplu, puteți modifica timpul de expirare a conexiunii sau puteți alege să comprimați solicitările cu gzip. Utilizați aceeași sintaxă ca în nginx.conf. De exemplu, dacă doriți să arhivați cu gzip toate solicitările prin proxy, adăugați rândul: „gzip_proxied any;”.',
    'apache-settings.additionalNginxSettings' => 'Directive nginx suplimentare',
    'apache-settings.additionalNginxSettingsError' => 'Configurație nginx incorectă: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Imposibil de utilizat fișierul de configurație nginx actual și de revenit la cel anterior, întrucât ambele conțin configurații incorecte.',
    'apache-settings.clearCache' => 'Golire cache',
    'apache-settings.clearCacheHint' => 'Golire cache nginx pentru %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Cache-ul a fost golit cu succes',

    'backup.backup-password-protection.securitySettingsSection' => 'Setări de securitate a copiei de rezervă',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Obținere parolă din setările de Spațiu de stocare la distanță',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Introducerea manuală a parolei',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Introduceți parola',
    'backup.backup-password-protection.backupPassword' => 'Parolă',
    'backup.backup-password-protection.inputPasswordType' => 'Tip parolă',
    'backup.backup-password-protection.confirmBackupPassword' => 'Repetați parola',
    'backup.backup-password-protection.backupPasswordHint' => 'Dacă ați uitat parola, deselectați această opțiune. Rețineți: în acest caz este posibil ca unele date confidențiale să nu fie restaurate corect. De exemplu, parolele utilizatorilor vor fi înlocuite cu parole aleatorii, informațiile despre aplicațiile APS deja instalate se vor pierde etc.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Dacă ați utilizat protecția prin parolă pentru această copie de rezervă, introduceți parola în câmpurile de mai jos. Rețineți: dacă introduceți o parolă greșită, Plesk nu va restaura datele din copia de rezervă. În schimb, copia de rezervă va fi copiată în spațiul de stocare local.',

    'backup.conflict-database.dbMappingLegend' => 'Maparea serverelor de baze de date',
    'backup.conflict-database.serverType' => 'Tip server',
    'backup.conflict-database.hostName' => 'Nume gazdă',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Server de baze de date destinație',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Nu se poate restaura baza de date: Nu există niciun server de baze de date potrivit.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Încărcarea fișierului de mapări IP',
    'backup.conflict-ip.ipMappingLegend' => 'Mapare IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Salvarea mapării IP curente în fișier',
    'backup.conflict-ip.ipAddressNotFound' => 'Nu există adrese IP libere de acest tip.',
    'backup.conflict-ip.sharedIp' => 'partajată',
    'backup.conflict-ip.dedicatedIp' => 'dedicată',
    'backup.conflict-ip.fileNotFound' => 'Fișierul nu poate fi gol.',
    'backup.conflict-ip.invalidIpToMap' => 'Valoare incorectă a adresei IP vechi: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Valoare incorectă a adresei IP noi: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'Adresa IP %%ip%% nu se găsește în baza de date.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Încărcarea unui fișier de mapări IP',
    'backup.conflict-ip.ipMappingFileHint' => 'Fișierul de mapări IP este un fișier text. Fiecare rând al acestui fișier conține o mapare IP în următorul format: <adresa IP veche lion-fake-end="1"> <adresa IP nouă lion-fake-end="1">',
    'backup.conflict-ip.oldIp' => 'Adrese IP vechi',
    'backup.conflict-ip.newIp' => 'Adrese IP noi',

    'backup.copy-to-server.ignoreBackupSign' => 'Se pot încărca fișiere copie de rezervă fără semnătură corectă',
    'backup.copy-to-server.wrongPassword' => 'Parola specificată este incorectă. În timpul restaurării copiei de rezervă, Plesk vă va cere să introduceți din nou parola.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Fișierul copie de rezervă încărcat %%fileName%% a fost modificat, deteriorat, creat pe un alt server sau într-o versiune de Plesk mai veche, care nu acceptă semnarea copiilor de rezervă. Înainte de a restaura datele din fișierul copie de rezervă, asigurați-vă că acesta provine dintr-o sursă de încredere.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Imposibil de încărcat fișierul copie de rezervă %%fileName%%. Fișierul conține date modificate ori deteriorate sau a fost creat pe un alt server sau într-o versiune de Plesk mai veche. Pentru a restaura datele din acest fișier, contactați furnizorul de servicii de găzduire.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Imposibil de încărcat fișierul copie de rezervă %%fileName%%. Fișierul a fost modificat, deteriorat, creat pe un alt server sau într-o versiune de Plesk mai veche, care nu acceptă semnarea copiilor de rezervă. Dacă aveți încredere în această copie de rezervă, selectați opțiunea „Se pot încărca fișiere copie de rezervă fără semnătură corectă” și încărcați din nou.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Imposibil de mutat fișierul copie de rezervă selectat, %%fileName%%, în spațiul de stocare de pe server. Eroare: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Următoarele părți ale copiei de rezervă incrementale nu au fost copiate:%%endl%%%%missedParts%%%%endl%%Copiați părțile lipsă.",

    'backup.ftp-settings.isActive' => 'Se utilizează spațiul de stocare FTP(S)',
    'backup.ftp-settings.host' => 'Nume gazdă sau IP server FTP',
    'backup.ftp-settings.directory' => 'Director pentru fișierele copie de rezervă',
    'backup.ftp-settings.directoryHint' => 'De exemplu, /folderul_meu/copiile_mele/',
    'backup.ftp-settings.ftpLogin' => 'Nume utilizator FTP',
    'backup.ftp-settings.ftpPassword' => 'Parolă FTP',
    'backup.ftp-settings.usePassiveMode' => 'Se utilizează modul pasiv',
    'backup.ftp-settings.useFtps' => 'Se utilizează FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Utilizarea serverului FTP local din Plesk drept spațiul de stocare la distanță este interzisă. Specificați o locație la distanță.',
    'backup.ftp-settings.warningHostIsLocal' => 'Setările spațiului de stocare FTP(S) au fost configurate pentru păstrarea copiilor de rezervă pe server, unde se găsesc fișierele aferente abonamentului. Nu se recomandă o asemenea configurație: se ocupă mult spațiu pe disc și există riscul pierderii datelor.',
    'backup.ftp-settings.enterFtpLogin' => 'Introduceți un nume de utilizator corect.',
    'backup.ftp-settings.enterFtpPassword' => 'Introduceți o parolă corectă.',

    'backup.remote-settings.isActive' => 'Se utilizează spațiul de stocare',
    'backup.remote-settings.initError' => 'Imposibil de inițializat pagina de setări %%extName%%: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Setări de securitate a copiilor de rezervă',

    'backup.restore.detailsSection' => 'Detalii',
    'backup.restore.contentInfoSection' => 'Conținut copie de rezervă',
    'backup.restore.restorationOptionsSection' => 'Opțiuni de restaurare',
    'backup.restore.emailNotification' => 'La terminarea restaurării se trimite notificare la',
    'backup.restore.comments' => 'Comentarii',
    'backup.restore.creationDate' => 'Data creării',
    'backup.restore.systemNotes' => 'Note despre sistem',
    'backup.restore.ownerAdmin' => 'Creată de administrator.',
    'backup.restore.ownerReseller' => 'Creată de un reseller.',
    'backup.restore.ownerCustomer' => 'Creată de un client.',
    'backup.restore.ownerServiceUser' => 'Creată de un utilizator auxiliar.',
    'backup.restore.partOfParentBackup' => 'Parte a copiei de rezervă de tip %%type%%.',
    'backup.restore.server' => 'server',
    'backup.restore.reseller' => 'reseller',
    'backup.restore.client' => 'client',
    'backup.restore.incremental' => 'Incremental.',
    'backup.restore.multiVolume' => 'Multivolum.',
    'backup.restore.backupSize' => 'Dimensiune copie de rezervă',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (această adăugire) + %%base%% (copia de rezervă inițială) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (această adăugire) + %%prev%% (adăugirile anterioare) + %%base%% (copia de rezervă inițială) = %%total%%',
    'backup.restore.download' => 'Descărcare',
    'backup.restore.downloadHint' => 'Descărcați fișierul copie de rezervă pe computerul local.',
    'backup.restore.downloadDisabled' => 'Descărcarea fișierelor copie de rezervă nu este disponibilă în acest moment. Încercați mai târziu sau contactați furnizorul de servicii.',
    'backup.restore.copy' => 'Copiere în spațiul de stocare pe server',
    'backup.restore.copyHint' => 'Copierea fișierelor copie de rezervă selectate în spațiul de stocare de pe server.',
    'backup.restore.contentInfo' => 'Copia de rezervă conține',
    'backup.restore.restoreButton' => 'Restaurare',
    'backup.restore.mail' => 'E-mail',
    'backup.restore.domainConfiguration' => 'Configurările domeniului',
    'backup.restore.virtualHost' => 'Conținutul gazdei virtuală',
    'backup.restore.database' => 'Baze de date',
    'backup.restore.serverConfiguration' => 'Setări de server',
    'backup.restore.serverConfigurationLicense' => 'Cheie de licență',
    'backup.restore.serverPersonalConfiguration' => 'Configurare cont de administrator',
    'backup.restore.serverPersonalDomains' => 'Domeniile administratorului',
    'backup.restore.serverPersonalClients' => 'Clienții administratorului',
    'backup.restore.resellers' => 'Reselleri',
    'backup.restore.resellerPersonalConfiguration' => 'Configurările contului de reseller',
    'backup.restore.resellerPersonalDomains' => 'Domeniile resellerului',
    'backup.restore.resellerPersonalClients' => 'Clienții resellerului',
    'backup.restore.clientPersonalConfiguration' => 'Configurarea contului de client',
    'backup.restore.clientPersonalDomains' => 'Domeniile clientului',
    'backup.restore.restoreModifiedSection' => 'Această copie de rezervă se restaurează, deși semnătura este deteriorată',
    'backup.restore.restoreModifiedDump' => 'Această copie de rezervă se restaurează, deși nu are o semnătură valabilă',
    'backup.restore.resolutionPolicy' => 'Politică de rezolvare',
    'backup.restore.resolutionPolicyDescription' => 'Conflictele de sincronizare apar atunci când obiectul restaurat există deja în sistem (cu o dată a modificării mai recentă) sau nu este prezent în sistem.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Parola specificată este incorectă. Fișierul copie de rezervă va fi copiat în spațiul de stocare local de pe server.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Imposibil de restaurat copia de rezervă. Parola specificată este incorectă.',
    'backup.restore.serverContentAndConfiguration' => 'Configurările și datele serverului',
    'backup.restore.serverConfigurationOnly' => 'Configurările serverului',
    'backup.restore.resellerContentAndConfiguration' => 'Configurările și datele contului de client',
    'backup.restore.resellerConfigurationOnly' => 'Configurările contului de reseller',
    'backup.restore.clientContentAndConfiguration' => 'Configurările și datele contului de client',
    'backup.restore.clientConfigurationOnly' => 'Configurarea contului de client',
    'backup.restore.domainContentAndConfiguration' => 'Configurările și datele domeniului',
    'backup.restore.domainConfigurationOnly' => 'Configurările domeniului',
    'backup.restore.restoreType' => 'Ce doriți să restaurați?',
    'backup.restore.restoreTypeFull' => 'Toate obiectele (întregul sistem)',
    'backup.restore.restoreTypeGranular' => 'Obiectele selectate',
    'backup.restore.restoreObjectType' => 'Tipul obiectului de restaurat',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abonament',
    'backup.restore.restoreObjectTypeCustomers' => 'Client',
    'backup.restore.restoreObjectTypeResellers' => 'Reseller',
    'backup.restore.restoreObjectTypeMailUsers' => 'Cont de e-mail',
    'backup.restore.restoreObjectTypeDatabases' => 'Bază de date',
    'backup.restore.restoreObjectTypeCertificates' => 'Certificate SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'Site-uri',
    'backup.restore.restoreObjectTypeDnsZones' => 'Zonă DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Liste de e-mail',
    'backup.restore.restoreObjectTypeWebContent' => 'Fișiere aferente domeniilor',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Fișiere selectate',
    'backup.restore.restoreSubscriptionLookup' => 'Abonament',
    'backup.restore.restoreComponents' => 'Componente de restaurat.',
    'backup.restore.errorLog' => 'Jurnal de erori',
    'backup.restore.backupDetailsLogDoesntExist' => 'Jurnalul de copii de rezervă nu este disponibil.',
    'backup.restore.dumpFailedSection' => 'Jurnal de erori',
    'backup.restore.dumpFailed' => 'Imposibil de restaurat datele: Fișierul copie de rezervă este incorect.',
    'backup.restore.granularNotSupported' => 'Puteți selecta obiectele de restaurat numai dacă restaurați din copii de rezervă create cu Plesk 12.0 sau cu o versiune ulterioară.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Restaurarea tuturor datelor din copia de rezervă nu se poate face în vizualizarea Utilizator privilegiat a resellerului. Selectați obiectele de restaurat. Puteți schimba vizualizarea de interfață în %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Preferințe de interfață',
    'backup.restore.contentRestoreType' => 'Restaurare',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Doar configurările obiectelor selectate',
    'backup.restore.contentRestoreTypeFull' => 'Configurările și datele obiectelor selectate',
    'backup.restore.errorWrongFormat' => 'Imposibil de restaurat datele din copia de rezervă: fișierul este formatat incorect.',
    'backup.restore.errorContentError' => 'Nu se pot restaura toate datele din copia de rezervă: fișierul are erori în conținut.',
    'backup.restore.warningSignError' => 'Imposibil de validat semnătura copiei de rezervă. Este posibil ca fișierul copie de rezervă să fi fost modificat, deteriorat, creat pe un alt server sau într-o versiune de Plesk mai veche.',
    'backup.restore.warningSignErrorNotAdmin' => 'Această copie de rezervă nu se poate restaura decât de administratorul Plesk.',
    'backup.restore.warningPartial' => "Următoarele părți ale copiei de rezervă incrementale nu au fost găsite:%%endl%%%%missedParts%%%%endl%%Nu se pot restaura toate fișiere. Încărcați părțile lipsă și încercați din nou să restaurați datele.",
    'backup.restore.warningDeprecatedBackupVersion' => 'Copia de rezervă pe care încercați să o restaurați a fost creată cu o versiune Plesk neacceptată și nu se poate restaura. Utilizați extensia Plesk Migrator pentru a transfera datele din versiunile Plesk vechi.',
    'backup.restore.encryptionKeyError' => 'Parolele aferente unui cont sau mai multor conturi nu se pot restaura. Acestea vor fi resetate. Probabil că această copie de rezervă a fost creată pe un alt server Plesk și a fost criptată cu cheia acestuia.',
    'backup.restore.errorCorruptedContent' => 'Următoarele fișiere nu au fost găsite sau au fost deteriorate: ',
    'backup.restore.statusSection' => 'Stare copie de rezervă',
    'backup.restore.statusDetails' => 'Detalii despre stare',
    'backup.restore.restoreBlocked' => 'Nu se pot restaura datele din copia de rezervă.',
    'backup.restore.restoreBlockedDescription' => 'În acest moment nu se pot restaura datele din copia de rezervă de tipul %%backupType%%. Pentru a le restaura, conectați-vă cu utilizatorul care este proprietarul copiei, apoi faceți clic pe numele acesteia în Manager copii de rezervă.',

    'backup.schedule.scheduleSection' => 'Program',
    'backup.schedule.backupEnable' => 'Se activează această sarcină de creare a copiei de rezervă',
    'backup.schedule.backupPeriod' => 'Această sarcină de creare a copiei de rezervă se execută',
    'backup.schedule.on' => 'pe',
    'backup.schedule.at' => 'la',
    'backup.schedule.every' => 'în fiecare',
    'backup.schedule.hours' => '{period, plural, one {oră} few {ore} other {de ore}}',
    'backup.schedule.retainHours' => 'ore',
    'backup.schedule.useIncremental' => 'Se utilizează copiile de rezervă incrementale',
    'backup.schedule.useIncrementalDisableHint' => 'Conținutul selectat pentru copia de rezervă nu permite decât crearea unei copii de rezervă integrale.',
    'backup.schedule.fullBackupPeriod' => 'Se creează o copie de rezervă completă',
    'backup.schedule.hourly' => 'Cu anumite frecvențe orare',
    'backup.schedule.daily' => 'Zilnic',
    'backup.schedule.weekly' => 'Săptămânal',
    'backup.schedule.monthly' => 'Lunar',
    'backup.schedule.yearly' => 'Anual',
    'backup.schedule.days' => 'zile',
    'backup.schedule.weeks' => 'săptămâni',
    'backup.schedule.months' => 'luni',
    'backup.schedule.years' => 'ani',
    'backup.schedule.backupTimeDescription' => 'Fus orar: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Fusul orar implicit al sistemului',
    'backup.schedule.first' => 'prima',
    'backup.schedule.last' => 'ultima',
    'backup.schedule.dayOfMonth' => 'zi',
    'backup.schedule.email' => 'Dacă apar erori în timpul executării acestei sarcini de creare a copiei de rezervă, e-mailul de notificare se trimite la',
    'backup.schedule.invalidFields' => 'Unele câmpuri sunt necompletate sau conțin o valoare incorectă: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Număr maxim de fișiere copie de rezervă complete de stocat (copii create programat și manual)',
    'backup.schedule.retainDumpFilesFor' => 'Păstrare copie de rezervă integrală timp de',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Lăsați acest câmp necompletat dacă nu doriți ștergerea automată a copiilor de rezervă complete.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Limita specificată de furnizorul de servicii de găzduire pentru spațiul de stocare pe server este %%max%%. Limita pe care o setați trebuie să fie mai mică decât sau egală cu %%max%%.',
    'backup.schedule.retainLimitedDescription' => 'Furnizorul de servicii de găzduire a specificat o limită de spațiu de stocare pe server de {max, plural, one {# copie de rezervă integrală} few {# copii de rezervă integrale} other {# de copii de rezervă integrale}} (inclusiv toate copiile de rezervă programate și manuale).',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Stocarea copiilor de rezervă programate într-un spațiu cloud la distanță este o funcție premium, pe care o puteți cumpăra din magazinul online Plesk.',
    'backup.schedule.backupHourlyWarning' => 'Activarea creării copiilor de rezervă cu anumite frecvențe orare duce la creșterea consumului de resurse server.',
    'backup.schedule.titleHourly' => 'Setări de creare a copiilor de rezervă cu anumite frecvențe orare',
    'backup.schedule.titleDaily' => 'Setări de creare zilnică a copiilor de rezervă',
    'backup.schedule.titleWeekly' => 'Setări de creare săptămânală a copiilor de rezervă',
    'backup.schedule.titleMonthly' => 'Setări de creare lunară a copiilor de rezervă',
    'backup.schedule.titleCustom' => 'Setări de creare personalizată a copiilor de rezervă',

    'backup.secure-backup.hint' => 'Puteți folosi o parolă pentru a cripta în copia de rezervă parolele de utilizatori din baza de date Plesk. Rețineți: dacă restaurați o copie de rezervă fără a introduce parola, Plesk va genera parole aleatorii pentru utilizatori.',
    'backup.secure-backup.hintAdmin' => 'Parolele de utilizatori din baza de date Plesk, incluse în copia de rezervă, pot fi criptate cu cheia de criptare Plesk sau cu o parolă. Cheia este unică pentru fiecare instalare Plesk. Copiile de rezervă criptate cu cheia se pot restaura numai în instalarea Plesk cu care au fost create. Nu se pot restaura în nicio altă instalare Plesk. Rețineți că Plesk nu protejează toate datele confidențiale din copiile de rezervă. Vă recomandăm să păstrați copiile de rezervă într-un spațiu cloud la distanță și să activați criptarea copiilor în spațiul respectiv.',
    'backup.secure-backup.usePasswordProtection' => 'Se utilizează protecția prin parolă (recomandat)',
    'backup.secure-backup.backupPasswordSource' => 'Tip parolă',
    'backup.secure-backup.pleskKey' => 'Cheie de criptare Plesk',
    'backup.secure-backup.userPassword' => 'Parolă specificată',
    'backup.secure-backup.password' => 'Parolă',
    'backup.secure-backup.passwordConfirmation' => 'Repetați parola',

    'backup.subform.settingsSection' => 'Setări legate de copiile de rezervă',
    'backup.subform.prefix' => 'Se adaugă un prefix la numele copiei de rezervă',
    'backup.subform.comment' => 'Comentarii',
    'backup.subform.splitSize' => 'Se creează o copie de rezervă multivolum, dimensiunea volumului (MB)',
    'backup.subform.repository' => 'Se stochează în',
    'backup.subform.repositoryDescription' => 'Setările spațiului de stocare FTP(S) nu sunt specificate. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Spațiul de stocare de pe server și %%name%%',
    'backup.subform.remoteRepositoryOption' => 'Spațiu de stocare la distanță',
    'backup.subform.remoteRepository' => 'spațiu de stocare la distanță',
    'backup.subform.remoteRepositoryText' => 'Selectați spațiul de stocare la distanță cloud',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">Configurați spațiul de stocare la distanță</a> pentru a păstra copiile de rezervă în cloud.',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">Configurați spațiul de stocare FTP</a> pentru a păstra copiile de rezervă în altă locație.',
    'backup.subform.configureRemoteDesc' => '%%link%% pentru a păstra copiile de rezervă în cloud.',
    'backup.subform.configureRemoteLink' => 'Configurați spațiul de stocare la distanță',
    'backup.subform.configureFtpDesc' => '%%link%% pentru a păstra copiile de rezervă în altă locație.',
    'backup.subform.configureFtpLink' => 'Configurați spații de stocare FTP',
    'backup.subform.repositoryConfigure' => 'Configurare',
    'backup.subform.email' => 'După crearea copiei de rezervă se trimite e-mail de notificare la',
    'backup.subform.contentSection' => 'Conținutul copiei de rezervă',
    'backup.subform.domainConfiguration' => 'Configurare',
    'backup.subform.domainConfigurationVhost' => 'Fișiere de baze de date utilizator',
    'backup.subform.domainConfigurationFile' => 'Fișiere utilizator',
    'backup.subform.domainConfigurationDatabase' => 'Baze de date',
    'backup.subform.domainConfigurationMail' => 'Mesaje de e-mail',
    'backup.subform.content' => 'Se creează o copie de rezervă cu',
    'backup.subform.backupAll' => 'Toate configurările și datele',
    'backup.subform.backupConfiguration' => 'Doar configurări',
    'backup.subform.backupVhost' => 'Toate configurările și toate datele, cu excepția mesajelor de e-mail',
    'backup.subform.backupMailFile' => 'Toată configurația și tot conținutul, cu excepția bazelor de date utilizator',
    'backup.subform.backupMailDatabase' => 'Toată configurația și tot conținutul, cu excepția fișierelor utilizator',
    'backup.subform.backupMail' => 'Doar configurările și mesajele de e-mail',
    'backup.subform.backupDatabase' => 'Doar configurația și bazele de date utilizator',
    'backup.subform.backupFile' => 'Doar configurația și fișierele utilizator',
    'backup.subform.mssqlNativeBackup' => 'Dacă este posibil, se utilizează funcția de copie de rezervă proprie MS SQL',
    'backup.subform.mssqlNativeBackupAdmin' => 'Se utilizează funcția de copie de rezervă proprie MS SQL (În cazul bazelor de date la distanță, nu uitați să configurați setările legate de copiile de rezervă pe serverul MS SQL la distanță, în Instrumente și setări> Servere de baze de date)',
    'backup.subform.localRepository' => 'Spațiu de stocare pe server',
    'backup.subform.localRepositoryPath' => 'Spațiu de stocare pe server în %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Spațiu de stocare FTP(S) la %%uri%% <a href="%%link%%">Modificare setări</a>',
    'backup.subform.ftpRepositoryText' => 'Spațiu de stocare FTP(S) la %%uri%%',
    'backup.subform.type' => 'Tip',
    'backup.subform.typeFullBackup' => 'Complet',
    'backup.subform.typeIncremental' => 'Incremental',
    'backup.subform.typeIncrementalDescription' => 'Se creează copie de rezervă cu datele de găzduire web și de e-mail, care s-au modificat după ultima copie de rezervă (bazele de date se includ întotdeauna în întregime).',
    'backup.subform.incrementalNotAvailable' => 'Pentru a putea crea copii de rezervă incrementale, întâi creați una completă.',
    'backup.subform.excludeLogs' => 'Excluderea fișierelor jurnal',
    'backup.subform.excludeFiles' => 'Excluderea anumitor fișiere din copia de rezervă',
    'backup.subform.excludeFilesDescription' => 'Nu puteți exclude decât fișiere din spațiile web. Specificați calea sau căile relative față de rădăcina spațiului web. Separați fișierele individuale prin virgule. Puteți utiliza caracterul generic (de exemplu, /undirector/jurnal*).',

    'backup.upload.uploadHint' => 'Aici puteți încărca fișierele copie de rezervă în spațiul de stocare Plesk. Dimensiunea de fișier maximă este limitată la doi gigabyți.',
    'backup.upload.backupFile' => 'Fișier copie de rezervă',
    'backup.upload.removeLink' => 'Ștergere',
    'backup.upload.addFileLink' => 'Încărcarea mai multor fișiere',
    'backup.upload.backupSecuritySettings' => 'Setări de securitate a copiei de rezervă',
    'backup.upload.signatureHint' => 'Plesk verifică fișierele copie de rezervă: dacă au structura și semnătura corecte. Fișierele modificate, deteriorate sau care au fost create pe un alt server nu prezintă încredere. Opțiunea de mai jos vă permite să restaurați datele din asemenea fișiere. Selectați această opțiune numai dacă aveți încredere în sursa copiei de rezervă, întrucât încărcarea unui asemenea fișier poate compromite securitatea serverului sau poate întrerupe funcționarea acestuia. Rețineți: Se consideră că fișierele copie de rezervă create în versiuni Plesk de dinainte de 11.5 nu prezintă încredere, pentru că nu au semnături. Aveți grijă să restaurați asemenea fișiere numai dacă aveți încredere în sursa din care provin.',
    'backup.upload.ignoreSign' => 'Se pot încărca fișiere copie de rezervă fără semnătură corectă',
    'backup.upload.passwordHint' => 'Dacă ați utilizat protecția prin parolă pentru această copie de rezervă, introduceți parola în câmpurile de mai jos. Rețineți: dacă introduceți o parolă greșită, Plesk vă va avertiza, dar va încărca fișierul, copie de rezervă pe server, cu toate acestea. În timpul restaurării copiei de rezervă, vi se va cere să introduceți din nou parola.',
    'backup.upload.alreadyExistsWarning' => 'Fișierul copie de rezervă %%fileName%% există deja în spațiul de stocare de pe server.',
    'backup.upload.incorrectPasswordWarning' => 'Parola specificată este incorectă. În timpul restaurării copiei de rezervă, Plesk vă va cere să introduceți din nou parola.',
    'backup.upload.deprecatedDumpError' => 'Copia de rezervă pe care încercați să o încărcați a fost creată cu o versiune Plesk neacceptată și nu se poate importa. Utilizați extensia Plesk Migrator pentru a transfera datele din versiunile Plesk vechi.',
    'backup.upload.mailFormatWarning' => 'Fișierul copie de rezervă %%fileName%% a fost încărcat în spațiul de stocare. Important: Fișierul copie de rezervă %%fileName%% conține date de e-mail care nu vor fi restaurate pentru că formatul acestora (Plesk 8.3 - 8.6) nu este acceptat. Pentru a putea restaura aceste date de e-mail, creați o copie de rezervă cu instrumentul Plesk Backup, selectați opțiunea Crearea copiei de rezervă a conținutului căsuțelor poștale, apoi selectați opțiunea de restaurare a fișierului dump pe orice server de e-mail.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Fișierul copie de rezervă încărcat (%%fileName%%) a fost modificat, deteriorat, creat pe un alt server sau într-o versiune de Plesk mai veche, care nu acceptă semnarea copiilor de rezervă. Înainte de a restaura datele din fișierul copie de rezervă, asigurați-vă că acesta provine dintr-o sursă de încredere.',
    'backup.upload.corruptedSignatureAdminError' => 'Imposibil de încărcat fișierul copie de rezervă (%%fileName%%). Fișierul a fost modificat, deteriorat, creat pe un alt server sau într-o versiune de Plesk mai veche, care nu acceptă semnarea copiilor de rezervă. Dacă aveți încredere în această copie de rezervă, selectați opțiunea „Se pot încărca fișiere copie de rezervă fără semnătură corectă” și încărcați din nou.',
    'backup.upload.corruptedSignatureUserWarning' => 'Fișierul copie de rezervă încărcat (%%fileName%%) conține date modificate ori deteriorate sau a fost creat pe un alt server sau într-o versiune de Plesk mai veche.',
    'backup.upload.corruptedSignatureUserError' => 'Imposibil de încărcat fișierul copie de rezervă (%%fileName%%). Fișierul conține date modificate ori deteriorate sau a fost creat pe un alt server sau într-o versiune de Plesk mai veche. Pentru a restaura datele din acest fișier, contactați furnizorul de servicii de găzduire.',
    'backup.upload.uploadError' => 'Imposibil de încărcat %%fileName%% în spațiul de stocare de pe server: %%error%%',
    'backup.upload.fileNotSelected' => 'Nu s-a selectat niciun fișier de încărcat. Selectați cel puțin un fișier.',
    'backup.upload.missedPartsWarning' => "Următoarele părți ale copiei de rezervă incrementale nu au fost încărcate:%%endl%%%%missedParts%%%%endl%%Încărcați părțile lipsă.",
    'backup.upload.unknownType' => 'Tip de obiect necunoscut',
    'backup.upload.storageLink' => 'un alt spațiu de stocare',
    'backup.upload.anotherStorage' => 'Fișierul dump a fost încărcat în %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Resellerul %%name%% nu a fost găsit. Pentru a putea restaura fișierul dump încărcat, creați-l în prealabil.',
    'backup.upload.clientNotFound' => 'Clientul %%name%% nu a fost găsit. Pentru a putea restaura fișierul dump încărcat, creați-l în prealabil.',
    'backup.upload.domainNotFound' => 'Domeniul %%name%% nu a fost găsit. Pentru a putea restaura fișierul dump încărcat, creați-l în prealabil.',

    'backup.web-content-dynamic.addButtonTitle' => 'Adăugare fișiere',
    'backup.web-content-dynamic.noItems' => 'Niciun fișier selectat',
    'backup.web-content-dynamic.hint' => 'Selectați fișierele și folderele cu ajutorul casetelor.',
    'backup.web-content-dynamic.title' => 'Selectare fișiere',
    'backup.web-content-dynamic.columnName' => 'Nume',
    'backup.web-content-dynamic.columnChangeDate' => 'Modificat',
    'backup.web-content-dynamic.columnSize' => 'Dimensiune',
    'backup.web-content-dynamic.columnPermissions' => 'Permisiuni',
    'backup.web-content-dynamic.columnUser' => 'Utilizator',
    'backup.web-content-dynamic.columnGroup' => 'Grup',
    'backup.web-content-dynamic.waitButtonTitle' => 'Așteptați',
    'backup.web-content-dynamic.loadingTitle' => 'Așteptați. Se încarcă...',

    'backup.invalidFields' => 'Unele câmpuri sunt necompletate sau conțin o valoare incorectă.',
    'backup.notEnoughDiskSpace' => 'Spațiu pe disc insuficient pentru crearea copiei de rezervă în %%path%%. Este nevoie de cel puțin %%required%% GB spațiu liber (disponibil: %%available%% GB)',

    'change-subscriptions-owner.infoTitle' => 'Informații',
    'change-subscriptions-owner.infoDescription' => '%%total%% abonamente, %%active%% abonamente active, %%diskSpace%% spațiu pe disc ocupat, %%traffic%% trafic utilizat',
    'change-subscriptions-owner.possibleOwnersTitle' => 'Posibili proprietari noi de abonamente',
    'change-subscriptions-owner.selectedSubscriptions' => 'Abonamente selectate',
    'change-subscriptions-owner.subscriptionName' => 'Nume abonament',
    'change-subscriptions-owner.ownerName' => 'Nume proprietar',
    'change-subscriptions-owner.currentIpAddress' => 'Adresa IP curentă',
    'change-subscriptions-owner.newIpAddress' => 'Noua adresă IP',
    'change-subscriptions-owner.submit' => 'Reatribuire',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, I/E disc',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Setarea limitelor în care abonamentul poate consuma resurse de sistem. Plesk împiedică depășirea limitelor folosind o caracteristică a nucleului Linux, numită grupuri de control (cgroups).',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Abonamentele individuale vor fi limitate la volumul de utilizare a CPU specificat.',
    'cgroups-settings.cpuPeriodLimit' => 'Perioadă de verificare a utilizării procesorului',
    'cgroups-settings.percentUsageDescription' => 'Timpul total de CPU este egal cu %%total%%%%units%% pentru server',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Abonamentele individuale vor fi limitate la volumul de utilizare RAM specificat. Rețineți: dacă abonamentul depășește această limită, procesul cu consum maxim va fi oprit.',
    'cgroups-settings.ramPeriodLimit' => 'Perioadă de verificare a utilizării memoriei RAM',
    'cgroups-settings.diskSettings' => 'I/E disc',
    'cgroups-settings.diskReadSettings' => 'Operații de citire de pe disc',
    'cgroups-settings.diskReadSettingsDescription' => 'Abonamentele individuale vor putea utiliza capacitățile de citire de pe disc numai în limitele specificate.',
    'cgroups-settings.diskReadPeriodLimit' => 'Perioadă de verificare a utilizării discului pentru citire',
    'cgroups-settings.diskWriteSettings' => 'Operații de scriere pe disc',
    'cgroups-settings.diskWriteSettingsDescription' => 'Abonamentele individuale vor putea utiliza capacitățile de scriere pe disc numai în limitele specificate.',
    'cgroups-settings.diskWritePeriodLimit' => 'Perioadă de verificare a utilizării discului pentru scriere',
    'cgroups-settings.limit' => 'Limită',
    'cgroups-settings.threshold' => 'Se anunță depășirile',
    'cgroups-settings.limitNotificationEnabled' => 'Notificare activată',
    'cgroups-settings.periodFiveMinutes' => '5 minute',
    'cgroups-settings.periodHour' => '1 oră',
    'cgroups-settings.periodDay' => '1 zi (24 de ore)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sec',

    'custom-button.privateLabel' => 'Vizibil doar mie',
    'custom-button.textLabel' => 'Etichetă de buton',
    'custom-button.tooltipLabel' => 'Text de sfat ecran',
    'custom-button.iconLabel' => 'Imagine de fundal',
    'custom-button.priorityLabel' => 'Nivel de prioritate',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Adăugare parametri la URL',
    'custom-button.placeLabel' => 'Locație',
    'custom-button.internalLabel' => 'Deschidere URL în Plesk',
    'custom-button.internalDescription' => 'Specificați dacă URL-ul se va deschide într-o pagină Plesk sau într-o nouă fereastră de browser.',
    'custom-button.noFrameLabel' => 'Nu se utilizează cadre',
    'custom-button.noFrameDescription' => 'Dacă adăugați un buton personalizat care conduce la o extensie Plesk sau la o aplicație în Panoul de control, puteți specifica modul în care se va afișa extensia/aplicația: într-un cadru sau ca parte a interfeței grafice Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Se includ ID-urile de abonament, de domeniu și de alias de domeniu',
    'custom-button.urlParamLabel_dom_name' => 'Se include numele de domeniu principal',
    'custom-button.urlParamLabel_ftp_user' => 'Se include numele de utilizator FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Se include parola FTP',
    'custom-button.urlParamLabel_cl_id' => 'Se include ID-ul clientului',
    'custom-button.urlParamLabel_cname' => 'Se include numele companiei clientului',
    'custom-button.urlParamLabel_pname' => 'Se include numele de contact al clientului',
    'custom-button.urlParamLabel_email' => 'Se include e-mailul clientului',
    'custom-button.buttonPlace_navigation' => 'Acces comun',
    'custom-button.buttonPlace_admin' => 'Pagina de pornire a administratorului',
    'custom-button.buttonPlace_admin-settings' => 'Pagina Instrumente și setări a administratorului',
    'custom-button.buttonPlace_reseller' => "Pagina de pornire a resellerului",
    'custom-button.buttonPlace_reseller-settings' => 'Pagina Instrumente și utilitare a resellerului',
    'custom-button.buttonPlace_client' => 'Pagina de pornire a clientului',
    'custom-button.buttonPlace_domain' => "Pagina Site-uri web și domenii din Abonament",
    'custom-button.buttonPlace_domain_powerUser' => "Pagina Site-uri web și domenii din Spațiu web",
    'custom-button.buttonPlace_domain-properties' => 'Instrumente de site web',

    'database-server-change-password.adminPassword' => 'Parolă administrator',
    'database-server-change-password.success' => 'Parola de administrator a fost actualizată cu succes.',

    'database-server-create.general' => 'General',
    'database-server-create.type' => 'Tip server de baze de date',
    'database-server-create.unixSocket' => '(conexiune locală)',
    'database-server-create.host' => 'Denumire gazdă sau adresă IP',
    'database-server-create.port' => 'Număr port',
    'database-server-create.portDescription' => 'Lăsați necompletat pentru a folosi numărul de port implicit',
    'database-server-create.version' => 'Versiunea serverului de baze de date',
    'database-server-create.default' => 'Acest server se va utiliza drept implicit pentru %%type%%',
    'database-server-create.externalConnections' => 'Se permite serverului MySQL local să accepte conexiuni externe',
    'database-server-create.externalConnectionsDescription' => 'Modificarea acestei setări va duce la repornirea serverului local MySQL. Pentru a activa accesul de la distanță la alte servere MySQL înregistrate în Plesk, modificați manual configurațiile acestora.',
    'database-server-create.authentication' => 'Autentificare',
    'database-server-create.authenticationAddDescription' => 'Specificați acreditările administratorului de baze de date cu care Plesk va accesa serverul de baze de date. Pe serverul de baze de date trebuie să existe un cont de administrator cu aceste acreditări.',
    'database-server-create.authenticationEditDescription' => 'Aici puteți modifica acreditările cu care Plesk accesează serverul de baze de date. Aceste acreditări trebuie să fie identice cu cele ale administratorului de baze de date. De exemplu, după ce ați modificat acreditările administratorului pe serverul de baze de date, trebuie să le schimbați și în Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Aici puteți modifica acreditările cu care Plesk accesează serverul de baze de date. Dacă schimbați mai jos numele de utilizator și parola, contul de utilizator de bază de date cu drepturi administrative va fi actualizat atât în baza de date, cât și în Plesk.',
    'database-server-create.adminLogin' => 'Nume utilizator',
    'database-server-create.adminPassword' => 'Parolă',
    'database-server-create.createSuccess' => 'Serverul de baze de date a fost creat cu succes.',
    'database-server-create.createError' => 'Serverul de baze de date a fost creat, cu eroarea: %%error%%',
    'database-server-create.updateSuccess' => 'Serverul de baze de date a fost actualizat cu succes.',
    'database-server-create.updateError' => 'Serverul de baze de date a fost actualizat, cu eroarea: %%error%%.',
    'database-server-create.backupSettings' => 'Copii de rezervă',
    'database-server-create.backupTempDir' => 'Director temporar',
    'database-server-create.backupTempDirDescription' => 'Calea către folderul fizic de pe serverul la distanță, în care se află serverul MS SQL. Serverul MS SQL trebuie să aibă acces la acest folder pentru a putea citi din și scrie în fișierele copie de rezervă temporare. De exemplu, C:\\CaleDirector',
    'database-server-create.backupNetworkTempDir' => 'Director temporar de rețea',
    'database-server-create.backupNetworkTempDirDescription' => 'Calea către locația partajată din rețea mapată la folderul fizic specificat de mai sus. Plesk va accesa folderul partajat pentru descărcarea și pentru încărcarea fișierelor copie de rezervă. De exemplu, \\\\NumeServer\\CaleDirector',
    'database-server-create.backupNetworkUser' => 'Nume utilizator',
    'database-server-create.backupNetworkUserDescription' => 'Numele utilizatorului de rețea creat pe serverul la distanță. De exemplu, NumeServer\\NumeUtilizator. Utilizatorul trebuie să aibă acces la folderul partajat specificat mai sus.',
    'database-server-create.backupNetworkPassword' => 'Parolă',

    'domain.connection-info.title' => 'Informații de conexiune',
    'domain.connection-info.systemUserCredentials' => 'Acreditările utilizatorului de sistem',
    'domain.connection-info.systemUserCredentialsHint' => 'Accesul prin FTP este mereu activat, accesul prin SSH sau Desktop la distanță — numai dacă %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 's-a acordat permisiune',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Accesul prin SSH sau Desktop la distanță este activat și nu îi puteți administra starea.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Accesul prin SSH sau Desktop la distanță este dezactivat și nu îi puteți administra starea.',
    'domain.connection-info.ipAddress' => 'Adresă IP',
    'domain.connection-info.copyToClipboard' => 'Copiere în clipboard',
    'domain.connection-info.username' => 'Nume utilizator',
    'domain.connection-info.password' => 'Parolă',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Schimbarea parolei utilizatorului de sistem',
    'domain.connection-info.changePasswordTooltip' => 'Schimbare parolă',
    'domain.connection-info.newPassword' => 'Parola nouă',
    'domain.connection-info.manageAccess' => 'Administrare acces',
    'domain.connection-info.additionalFtpAccounts' => 'Conturi FTP suplimentare',
    'domain.connection-info.database' => 'Bază de date',
    'domain.connection-info.databaseHint' => '1 din %%number%% baze date care aparțin abonamentului.',
    'domain.connection-info.databaseNotCreatedHint' => 'Baza de date nu a fost creată.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Gazdă',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Nume bază de date',
    'domain.connection-info.addDatabase' => 'Adăugare bază de date',
    'domain.connection-info.manageDatabases' => 'Administrarea bazelor de date',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Schimbare parolă utilizator de baze de date',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'După ce schimbați parola aici, nu uitați să o actualizați și în fișierele de configurare ale aplicației.',
    'domain.connection-info.buttonSave' => 'Salvare',
    'domain.connection-info.buttonSaving' => 'Se salvează...',
    'domain.connection-info.buttonCancel' => 'Revocare',

    'domain.move.title' => 'Mutarea domeniului %%name%%',
    'domain.move.hint' => 'Domeniul va fi mutat într-un abonament nou, împreună cu elemente de conținut, fișierele de configurare, fișierele jurnal și aplicațiile APS.',
    'domain.move.hintMain' => 'Domeniul va fi mutat într-un abonament nou, împreună cu elemente de conținut, fișierele de configurare, fișierele jurnal, bazele de date, utilizatorii de baze de date, utilizatorii FTP suplimentari, sarcinile programate, utilizatorii smb și aplicațiile APS.',
    'domain.move.hintSubdomains' => 'Subdomenile %%subdomains%% vor fi mutate împreună cu domeniul părinte.',
    'domain.move.hintAliases' => 'Aliasurile de domeniu %%aliases%% vor fi mutate împreună cu domeniul părinte.',
    'domain.move.hintSubdomainsAndAliases' => 'Subdomeniile %%subdomains%% și aliasurile de domeniu %%aliases%% vor fi mutate împreună cu domeniul părinte.',
    'domain.move.labelDatabases' => 'După ce mutați domeniul, deschideți fila „Baze de date” pentru a muta bazele de date asociate.',
    'domain.move.hintDatabases' => 'Dacă este cazul, mutați separat bazele de date.',

    'domain.move.Form.submitButton' => 'Mutare',
    'domain.move.Form.cancelButton' => 'Revocare',

    'domain.move.selectTarget' => 'Abonamente disponibile',
    'domain.move.nothingFound' => 'Nu s-a găsit niciun element',
    'domain.move.targetIsRequred' => 'Selectați abonamentul în care mutați domeniul.',
    'domain.move.selectNewSubscription' => 'Crearea unui abonament nou',
    'domain.move.ipv4Address' => 'Adresă IPv4',
    'domain.move.ipv4AddressHint' => 'Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului.',
    'domain.move.ipv6Address' => 'Adresă IPv6',
    'domain.move.ipv6AddressHint' => 'Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului.',
    'domain.move.ipAddressIsNotSelected' => 'Trebuie să selectați cel puțin o adresă IP.',
    'domain.move.username' => 'Nume utilizator',
    'domain.move.usernameHint' => 'Contul de utilizator de sistem asociat spațiului web. Utilizat pentru accesarea prin FTP și SSH a fișierelor găzduite.',
    'domain.move.usernameIsRequred' => 'Trebuie să introduceți un nume de utilizator.',
    'domain.move.password' => 'Parolă',
    'domain.move.passwordIsRequred' => 'Trebuie să introduceți o parolă.',
    'domain.move.noAvailableSubscriptions' => 'Nu sunt disponibile abonamente',
    'domain.move.noWebHosting' => 'Domeniul nu are găzduire web, de aceea nu se creează utilizator de sistem.',

    'domain.rename.title' => 'Schimbare nume de domeniu',
    'domain.rename.titleAlias' => 'Modificare denumire alias de domeniu',
    'domain.rename.hint' => 'În acest moment modificați numele de domeniu %%domainName%%',
    'domain.rename.hintAlias' => 'În acest moment modificați denumirea alias de domeniu %%domainName%%',
    'domain.rename.name' => 'Nume domeniu nou',
    'domain.rename.nameAlias' => 'Denumire alias de domeniu nou',
    'domain.rename.domainNameIsRequired' => 'Câmpul obligatoriu este gol. Trebuie să specificați o valoare.',
    'domain.rename.submitButton' => 'Modificare',
    'domain.rename.submitButtonProgress' => 'Modificare în curs',
    'domain.rename.successMessage' => 'Numele de domeniu %%oldName%% a fost schimbat în %%newName%%.',
    'domain.rename.successMessageAlias' => 'Denumirea alias de domeniu %%oldName%% a fost schimbată în %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Revocare',

    'domain.outgoing-messages.hint' => 'Aici puteți modifica numărul limită de mesaje trimise din acest domeniu. Numărul mesajelor trimise nu va putea depăși limita specificată.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Implicit (%%domainOutgoingMessages%% mesaje pe oră)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'mesaje pe oră',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Limita trimiterilor de mesaje',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Valoare personalizată pentru acest domeniu',

    'domain.tech-domain-name.title' => 'Selectați numele de domeniu',
    'domain.tech-domain-name.techDomainTitle' => 'Nume de domeniu temporar',
    'domain.tech-domain-name.customDomainTitle' => 'Nume de domeniu înregistrat',
    'domain.tech-domain-name.techDomainText' => 'Încă nu am un nume de domeniu înregistrat',
    'domain.tech-domain-name.customDomainText' => 'Am un nume de domeniu înregistrat',
    'domain.tech-domain-name.techDomain' => 'Numele de domeniu temporar',
    'domain.tech-domain-name.customDomain' => 'Nume de domeniu înregistrat',
    'domain.tech-domain-name.domainName' => 'Nume domeniu',
    'domain.tech-domain-name.techDomainDesc' => 'Numele de domeniu temporare se folosesc pentru a accesa site-ul înainte de a înregistra și a cumpăra un nume de domeniu real. Acestea sunt oferite gratuit, cu următoarele condiții:',
    'domain.tech-domain-name.techDomainRandom' => 'Numele se generează aleatoriu',
    'domain.tech-domain-name.techDomainDns' => 'Sunt găzduite în zona DNS .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Ulterior, puteți să treceți oricând la numele de domeniu înregistrat: este suficient să redenumiți domeniul în setările de domeniu.',
    'domain.tech-domain-name.error' => 'A apărut o eroare neașteptată.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Trebuie să selectați adresa IP.',
    'domain.tech-domain-name.generating' => 'Generare...',

    'get-password.label' => 'Resetare parolă',
    'get-password.text' => 'Tastați adresa de e-mail sau numele de utilizator înregistrat în Plesk și vă vom trimite un e-mail de resetare a parolei.',
    'get-password.emailLabel' => 'Adresă e-mail',
    'get-password.loginLabel' => 'Nume utilizator',
    'get-password.send' => 'Trimitere',
    'get-password.cancel' => 'Revocare',
    'get-password.errorInvalidEmail' => 'Adresa de e-mail nu a fost recunoscută. Verificați și încercați din nou.',
    'get-password.messageSend' => "E-mailul de resetare a parolei a fost trimis la adresa asociată.\nDacă nu-l primiți, luați legătura cu administratorul Plesk.",

    'iis-settings.formGeneralHint' => 'Aici puteți specifica setările serverului web IIS pentru acest site, prin modificarea valorilor implicite. Configurația personalizată de IIS este utilă, de exemplu, atunci când doriți să utilizați un nou tip de fișiere index pe site sau să asociați un anumit tip MIME cu anumite extensii de fișiere. Valorile implicite sunt definite de furnizorul de servicii de găzduire.',
    'iis-settings.formGeneralHint_powerUser' => 'Aici puteți specifica setările serverului web IIS pentru acest site. Configurația personalizată de IIS este utilă, de exemplu, atunci când doriți să utilizați un nou tip de fișiere index pe site sau să asociați un anumit tip MIME cu anumite extensii de fișiere. Valoarea implicită înseamnă că Apache va utiliza directiva corespunzătoare din configurația la nivel de server.',
    'iis-settings.virtualDirectoryLoadError' => 'Imposibil de obținut proprietățile directorului virtual specificat: %%errorMessage%%',
    'iis-settings.general' => 'Setări comune',
    'iis-settings.example' => "De exemplu: %%example%%",
    'iis-settings.settingOn' => 'Pornit',
    'iis-settings.settingOff' => 'Oprit (implicit)',
    'iis-settings.settingDefault' => 'Implicit',
    'iis-settings.settingCustom' => 'Introducerea unei valori personalizate',
    'iis-settings.mimeTypes' => 'Tipuri MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'Tipurile MIME asociază extensiile cu tipuri de fișiere. De obicei, acest lucru se folosește la crearea unei extensii personalizate pentru tipurile de fișiere obișnuite.',
    'iis-settings.documents' => 'Documente implicite',
    'iis-settings.documentsOff' => 'Dezactivat',
    'iis-settings.documentsCustom' => 'Introduceți valorile',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Dacă browserele nu specifică numele unui anumit document de pe site, IIS va căuta documentele implicite specificate și îl va trimite pe primul găsit. Dacă nu specificați documentele implicite, dar activați navigarea în directoare, browserul va afișa conținutul directorului în locul paginii index.',
    'iis-settings.expires' => 'Expiră',
    'iis-settings.expiresFullDescription' => 'Serverul web va adăuga antetele de răspuns „Expiră” la paginile web. Marcajul cu timpul de expirare se obține prin adăugarea duratei de timp specificate mai sus la ora la care a fost solicitată pagina web.',
    'iis-settings.expiresUnitDays' => 'zile',
    'iis-settings.expiresUnitHours' => 'ore',
    'iis-settings.expiresUnitMinutes' => 'minute',
    'iis-settings.expiresUnitSeconds' => 'secunde',
    'iis-settings.headers' => 'Antete suplimentare',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Serverul web va adăuga anteturile de răspuns HTTP specificate.',
    'iis-settings.directoryBrowsing' => 'Navigare în directoare',
    'iis-settings.directoryBrowsingDescription' => 'Le permite utilizatorilor să vadă în browser lista folderelor și a fișierelor din directorul site-ului, în cazul în care pagina de index implicită nu este disponibilă.',
    'iis-settings.securityTabDirectory' => 'Setări de securitate director',
    'iis-settings.allowAnonymous' => 'Autentificare anonimă',
    'iis-settings.allowAnonymousDescription' => 'Autentificarea anonimă le permite utilizatorilor să acceseze conținutul public al site-ului. Utilizatorii anonimi nu vor avea acces nici la conținutul protejat prin parolă al site-ului, nici la cel protejat la nivelul sistemului de fișiere.',
    'iis-settings.allowWindows' => 'Autentificare Windows',
    'iis-settings.allowWindowsDescription' => 'Autentificarea Windows (denumită în trecut NTLM) protejează conținutul site-ului la nivelul sistemului de fișiere.',
    'iis-settings.requireSsl' => 'Obligatoriu SSL/TLS',
    'iis-settings.requireSslDescription' => 'Dacă ați activat suportul SSL/TLS pentru site, această opțiune va forța programele client web (browserele) să utilizeze numai conexiuni securizate, HTTPS.',
    'iis-settings.securityTabIpDeny' => 'Setări de restricționare a accesului',
    'iis-settings.deny' => 'Se refuză accesul la site',
    'iis-settings.denyOff' => 'Implicit',
    'iis-settings.denyCustom' => 'Introducerea unei valori personalizate',
    'iis-settings.allow' => 'Exclusiv',
    'iis-settings.denyExample' => "192.168.0.0/16 192.168.1.110 Gazdele și rețelele specificate nu pot accesa site-ul. Utilizați „*” pentru a refuza toate conexiunile.",
    'iis-settings.allowExample' => "192.168.0.0/16 10.1.1.21 Gazdele și rețelele specificate pot accesa site-ul.",
    'iis-settings.dynamicIpSecurity' => 'Împiedicarea atacurilor de tip refuz al serviciului (DoS) prin restricționarea dinamică în IIS a adreselor IP',
    'iis-settings.isDenyByConcurrentRequests' => 'Refuzarea adreselor IP în funcție de numărul de solicitări concurente provenite de la aceeași adresă IP',
    'iis-settings.maxConcurrentRequests' => 'Număr maxim de solicitări concurente',
    'iis-settings.isDenyByRequestRate' => 'Refuzarea adreselor IP în funcție de numărul de solicitări primite într-o anumită perioadă de timp',
    'iis-settings.maxRequests' => 'Număr maxim de solicitări',
    'iis-settings.requestInterval' => 'Perioadă de timp (în milisecunde)',

    'ip-addresses-selector.ipAddress' => 'Adresă IP',
    'ip-addresses-selector.ipv4Address' => 'Adresă IPv4',
    'ip-addresses-selector.ipv4AddressHint' => "Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului.",
    'ip-addresses-selector.ipv6Address' => 'Adresă IPv6',
    'ip-addresses-selector.ipv6AddressHint' => "Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului.",
    'ip-addresses-selector.noIpAddressHint' => 'Niciuna',
    'ip-addresses-selector.shared' => 'partajată',
    'ip-addresses-selector.exclusive' => 'dedicată',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'Serverul FTP nu acceptă adresele IPv6. Trebuie să alocați cel puțin o adresă IPv4. În caz contrar, nu veți putea încărca fișierele pe server prin FTP.',

    'license-key-revert.description' => 'Se va restaura cheia de licență cu următoarele proprietăți:',
    'license-key-revert.submitButton' => 'Revenire la versiunea anterioară',

    'license-key-upload.description' => 'Instalați cheia de licență, prin introducerea unui cod de activare.',
    'license-key-upload.descriptionWithFileUpload' => 'Instalați cheia de licență, fie prin introducerea unui cod de activare, fie prin încărcarea unui fișier cu cheie de licență.',
    'license-key-upload.type' => 'Alegeți una dintre următoarele opțiuni:',
    'license-key-upload.code' => 'Introduceți un cod de activare',
    'license-key-upload.codeDescription' => 'Lipiți codul de activare primit.',
    'license-key-upload.file' => 'Încărcarea fișierului cu cheia de licență',
    'license-key-upload.fileDescription' => 'Specificați calea către fișierul cu cheia de licență.',
    'license-key-upload.submitButton' => 'Instalare',

    'log-rotation.customLogsDescription' => 'Rețineți: în cazul jurnalelor personalizate nu se face rotație.',
    'log-rotation.logRotation' => 'Se folosește rotația fișierelor jurnal',
    'log-rotation.logRotationCondition' => 'Condiție de rotație a jurnalelor',
    'log-rotation.logRotationBySize' => 'În funcție de dimensiune',
    'log-rotation.logRotationByTime' => 'În funcție de timp',
    'log-rotation.logRotationDaily' => 'Zilnic',
    'log-rotation.logRotationWeekly' => 'Săptămânal',
    'log-rotation.logRotationMonthly' => 'Lunar',
    'log-rotation.logRotationSizeDescription' => 'Valoarea dimensiunii trebuie să fie cuprinsă între %%min%% și %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Număr maxim de fișiere jurnal',
    'log-rotation.compress' => 'Fișierele jurnal se comprimă',
    'log-rotation.sendLogToEmail' => 'După ce Plesk preia datele din fișierele jurnal ale serverelor de web și de FTP, fișierele respective se trimit prin e-mail la această adresă',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Perioada nu poate depăși limita setată la nivel de server, %%max%%.',

    'login.loginLabel' => 'Nume utilizator',
    'login.passwdLabel' => 'Parola',
    'login.localeLabel' => 'Limba interfeței',
    'login.defaultLocale' => 'Implicit',
    'login.loginButtonLabel' => 'Conectare',
    'login.enterUsername' => 'Introduceți numele de utilizator.',
    'login.enterPassword' => 'Introduceți parola.',
    'login.whatUsernamePassword' => 'Ce nume de utilizator și ce parolă utilizați?',
    'login.forgotPasswordLabel' => 'Ați uitat parola?',
    'login.cookies' => 'Politica de cookie-uri Plesk',
    'login.avoidSSLWarningsMsg' => 'Pentru a evita avertizările SSL în timpul conectării la Plesk, utilizați %%link%%',
    'login.digitalOceanMsg' => 'Nu ați mai folosit Plesk pe DigitalOcean? Conectați-vă cu „root” și parola pe care ați introdus-o atunci când ați creat acest droplet. %%link%%',
    'login.amazonLightsailMsg' => 'Nu ați mai folosit Plesk pe Lightsail? Pentru a vă conecta la Plesk, accesați serverul prin SSH și executați comanda „plesk login”. %%link%%',
    'login.readGuide' => 'Citiți ghidul complet.',
    'login.mobileApplicationMessage' => 'Pentru o experiență mai bună, vă recomandăm să instalați aplicația %%name%%.',
    'login.mobileApplicationInstall' => 'Instalare imediată',
    'login.mobileApplicationHide' => 'Nu, mulțumesc',

    'force-reset-password.saveButton' => 'Salvare',
    'force-reset-password.title' => 'Schimbare parolă',
    'force-reset-password.passwordLabel' => 'Parola nouă',

    'panel-access.title' => 'Personalizarea URL-ului Plesk',
    'panel-access.hint' => 'Alegerea URL-urilor personalizate folosite pentru conectarea la Plesk. Conectarea la Plesk prin portul %%httpsPort%% rămâne posibilă. %%link%%',
    'panel-access.details' => 'Mai multe detalii',
    'panel-access.proxyEnabled' => 'Toate domeniile și subdomeniile a căror rezolvare este adresa IP a serverului, dar care nu sunt folosite pentru găzduire',
    'panel-access.proxyDomain' => 'Domeniul sau subdomeniul specificat, rezolvarea căreia dă adresa IP a serverului, dar care nu este folosit pentru găzduire',
    'panel-access.proxyDisabled' => 'Nu există URL-uri personalizate. Doar https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Salvare',
    'panel-access.Form.cancelButton' => 'Anulare',

    'panel-access.domainNameIsRequired' => 'Trebuie să introduceți un nume de domeniu.',
    'panel-access.successMessage' => 'Metoda de conectare selectată a fost aplicată.',
    'panel-access.notSupported' => 'Plesk nu acceptă metoda de conectare selectată.',
    'panel-access.notViaDomainName' => 'Pentru a folosi această metodă de conectare, alegeți prima opțiune („Toate domeniile și subdomeniile...”), conectați-vă la Plesk prin https://%%domainName%%, apoi selectați cea de-a doua opțiune.',
    'panel-access.notViaPort' => 'Pentru a folosi această modalitate, întâi conectați-vă la Plesk prin https://<server-IP-or-hostname>:%%httpsPort%%.',

    'php-settings.performance' => 'Setări de performanțe și de securitate',
    'php-settings.settings' => 'Setări comune',
    'php-settings.fastCgiSettings' => 'Setări FastCGI',
    'php-settings.fpmSettings' => 'Setări PHP-FPM',
    'php-settings.enableFastcgi' => 'Se activează setările FastCGI',
    'php-settings.plainTextEditing' => 'Directive suplimentare',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Puteți defini orice parametru PHP: doar tastați în câmpul de dedesubt. Directivele vor fi incluse în configurația PHP. Utilizați aceeași sintaxă ca în php.ini. De exemplu, pentru a încărca automat extensia mSQL, adăugați rândul: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Dacă nu găsiți anumiți parametri PHP, adăugați-i în câmpul de mai jos. Aceste directive suplimentare vor fi îmbinate cu cele din planul principal de servicii. Utilizați aceeași sintaxă ca în php.ini. De exemplu, dacă doriți încărcarea automată a extensiei mSQL, adăugați rândul: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Puteți defini orice parametru PHP: doar tastați în câmpul de dedesubt. Directivele vor fi incluse în configurația PHP. Utilizați aceeași sintaxă ca în php.ini. De exemplu, pentru a încărca automat extensia mSQL, adăugați rândul: extension=msql.so. Pentru a personaliza setările de liste PHP-FPM, adăugați separatorul [php-fpm-pool-settings] și tastați dedesubt setările dorite.',
    'php-settings.additionalConfigurationDirectives' => 'Directive de configurare suplimentare',
    'php-settings.defaultValue' => 'Implicit',
    'php-settings.predefinedValue' => 'Selectați valoarea',
    'php-settings.customValue' => 'Introducerea unei valori personalizate',
    'php-settings.phpSettingDescription_memory_limit' => 'Volumul maxim de memorie, în byți, pe care îl poate aloca un script.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Durata maximă de executare a unui script, în secunde. După această perioadă scriptul este oprit.',
    'php-settings.phpSettingDescription_max_input_time' => 'Durata maximă în care un script poate analiza datele de intrare, în secunde.',
    'php-settings.phpSettingDescription_post_max_size' => 'Volumul maxim de date, în byți, care se poate trimite prin metoda POST. De obicei, trebuie să fie mai mare decât upload_max_filesize și mai mic decât memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Dimensiunea maximă, în byți, a fișierului încărcat.',
    'php-settings.phpSettingDescription_safe_mode' => 'Modul PHP sigur impune mai multe restricții legate de executarea scripturilor, în special din motive de securitate.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Dacă directiva safe_mode este activă, scripturile PHP pot accesa fișierele din directoarele specificate. Directorul trebuie să fie specificat și în include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Dacă directiva safe_mode este activă, scripturile PHP pot executa programele din directoarele specificate.',
    'php-settings.phpSettingDescription_include_path' => 'Lista directoarelor în care scripturile caută fișiere (asemănător cu variabila de sistem PATH). Separați numele de directoare prin caractere două puncte (:) pe Linux, respectiv caractere punct și virgulă (;) pe Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Directorul în care se stochează fișierele de sesiuni PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Parametri suplimentari pentru funcția mail().',
    'php-settings.phpSettingDescription_register_globals' => 'Înregistrați conținutul variabilelor EGPCS (Environment (mediu), GET, POST, Cookie, Server) ca variabile globale.',
    'php-settings.phpSettingDescription_open_basedir' => 'Scripturile PHP pot accesa fișierele din directoarele specificate. Separați numele de directoare prin caractere două puncte (:) pe Linux, respectiv caractere punct și virgulă (;) pe Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'Nivelul de raportare a erorilor.',
    'php-settings.phpSettingDescription_display_errors' => 'Determină dacă erorile trebuie să apară în ieșire.',
    'php-settings.phpSettingDescription_log_errors' => 'Activarea înregistrării în jurnal a erorilor PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Permite preluarea datelor din locații la distanță, prin FTP sau HTTP, folosind funcții PHP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Permite încărcarea fișierelor prin HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Permite utilizarea formei prescurtate ( ) a etichetei de deschidere PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Setează starea magic_quotes pentru operațiile GPC (Get/Post/Cookie). Dacă opțiunea magic_quotes este activată, toate caracterele apostrof, toate ghilimelele, toate barele oblice inverse și toate caracterele speciale NULL sunt precedate automat de o bară oblică inversă.',
    'php-settings.phpSettingDescription_disable_functions' => 'Această directivă permite dezactivarea anumitor funcții. Intrarea constă într-o listă de nume de funcții, separate prin virgule',
    'php-settings.phpSupport' => 'Suport PHP',
    'php-settings.phpRunAs' => 'PHP se execută ca',
    'php-settings.phpVersion' => 'Versiune PHP',
    'php-settings.phpHandlerOutdated' => '(Învechit)',
    'php-settings.phpHandlerDeprecated' => '(Abandonat)',
    'php-settings.phpServedByApache' => 'deservit(ă) de Apache',
    'php-settings.phpServedByNginx' => 'deservit(ă) de nginx',
    'php-settings.phpSettingsPhpVersion' => 'Utilizați versiunea de PHP %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP este dezactivat.',
    'php-settings.phpHandlerTypeHint' => 'Mai jos găsiți detaliile configurației PHP a unui site web. Dacă furnizorul de servicii de găzduire vă acordă permisiunea corespunzătoare, puteți schimba configurația PHP.',
    'php-settings.fpmDedicatedHandlerHint' => 'Utilizarea acestui handler crește stabilitatea site-ului, dar și ocuparea memoriei.',
    'php-settings.phpHandlerChangeHint' => 'Ați schimbat setările de handler PHP. Dacă salvați aceste modificări, scripturile PHP de pe site se pot opri timp de %%interval%%, din cauza configurației de server.',
    'php-settings.phpHandlerOutdatedHint' => 'Pentru a verifica dacă este disponibilă vreo versiune de PHP nouă, %%link%% și verificați categoria de componente de produse „Găzduire web”.',
    'php-settings.phpHandlerOutdatedHintLink' => 'deschideți programul de Instalare Plesk',
    'php-settings.phpHandlerTypeHelpLink' => 'Aflați cum se aleg cele mai potrivite setări PHP',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Suportul PHP nu se poate activa: configurația de găzduire actuală nu include nicio versiune PHP disponibilă pentru acest domeniu.',
    'php-settings.phpHandlersNotAvailableHint' => 'Suportul PHP nu se poate activa: configurația Plesk actuală nu include nicio versiune PHP disponibilă.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Aflați cum se activează celelalte versiuni PHP.',
    'php-settings.phpSupportEditable' => '(Versiune PHP version %%version%%, executare PHP ca %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(versiune: %%version%%; handler: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(neînregistrat) %%link%%',
    'php-settings.showPhpInfo' => 'Vizualizarea paginii phpinfo()',
    'php-settings.phpSettingsFormError' => 'Imposibil de preluat setările PHP: lipsesc datele necesare.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Imposibil de preluat setările PHP: această versiune de PHP nu este instalată. Pentru a putea continua, instalați versiunea PHP selectată sau selectați o alta pentru domeniu.',
    'php-settings.showPhpInfoTitle' => 'Vizualizare phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Unele dintre setările PHP au fost modificate, dar schimbările nu au fost salvate încă. Pentru a vede noile valori în pagina phpinfo(), întâi aplicați modificările. În caz contrar veți vedea valorile actuale.',
    'php-settings.showPhpInfoButton' => 'Vizualizare phpinfo()',
    'php-settings.onState' => 'Pornit',
    'php-settings.offState' => 'Oprit',

    'pmm.agent.sync.check' => 'Agentul de migrare și transfer caută actualizări.',
    'pmm.agent.sync.updating' => 'Se sincronizează și se descarcă Agentul de migrare și transfer',
    'pmm.agent.sync.done' => 'Agentul de migrare și transfer a fost sincronizat cu succes.',
    'pmm.agent.sync.downloadLink' => 'Faceți clic pentru a descărca fișierul de Agent de migrare și transfer, pe care trebuie să-l instalați pe gazda sursă înainte de pornirea migrării.',
    'pmm.agent.sync.error' => 'Agent de migrare și transfer nu a putut prelua actualizările. Încercați mai târziu.',

    'restore-password.title' => 'Schimbare parolă',
    'restore-password.passwordLabel' => 'Parola nouă',
    'restore-password.buttonRestore' => 'Salvare',
    'restore-password.buttonCancel' => 'Revocare',
    'restore-password.isEmpty' => 'Câmpul obligatoriu este gol. Trebuie să specificați o valoare.',
    'restore-password.errorInvalidSecret' => 'Cod secret incorect',
    'restore-password.errorNotFoundSecret' => 'Solicitați un nou cod secret',
    'restore-password.restoreSuccess' => 'Parola a fost actualizată. Utilizați noua parolă pentru a vă conecta la Plesk sau la adresa de e-mail.',

    'scheduler.settings.schedulerNotification' => 'Notificare componentă de programare',
    'scheduler.settings.notificationOff' => "Oprit",
    'scheduler.settings.notificationDefault' => "Trimitere la adresa de e-mail implicită (%%email%%)",
    'scheduler.settings.notificationCustom' => "Trimitere la adresa de e-mail pe care o specific",
    'scheduler.settings.crontabSecureShell' => 'Shell crontab',
    'scheduler.settings.schedulerTimezoneSelector' => 'Programul de sarcini se afișează conform unui anumit fus orar',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Se utilizează fusul orar implicit al sistemului (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Se utilizează fusul orar implicit al sistemului',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Se utilizează fusul orar de mai jos',

    'scheduler.task.active' => 'Activă',
    'scheduler.task.subscription' => 'Abonament',
    'scheduler.task.subscription_powerUser' => 'Spațiu web',
    'scheduler.task.type' => 'Tip sarcină',
    'scheduler.task.typeCommand' => 'Executarea unei comenzi',
    'scheduler.task.typeUrl' => 'Preluarea unui URL',
    'scheduler.task.typeScript' => 'Executarea unui script PHP',
    'scheduler.task.command' => 'Comandă',
    'scheduler.task.arguments' => 'cu argumente',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Specificați un URL absolut, de exemplu, http://exemplu.ro. Dacă starea de răspuns este 2xx sau 3xx, se consideră că sarcina a fost executată cu succes.',
    'scheduler.task.script' => 'Calea către script',
    'scheduler.task.scriptRelativePathDescription' => 'Exemplu: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Specificați calea completă către script. Exemplu: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Se utilizează versiunea PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Calea către script',
    'scheduler.task.run' => 'Executare',
    'scheduler.task.on' => 'pe',
    'scheduler.task.at' => 'la',
    'scheduler.task.sysUser' => 'Utilizator de sistem',
    'scheduler.task.hourly' => 'Din oră în oră',
    'scheduler.task.daily' => 'Zilnic',
    'scheduler.task.weekly' => 'Săptămânal',
    'scheduler.task.monthly' => 'Lunar',
    'scheduler.task.yearly' => 'Anual',
    'scheduler.task.cronStyle' => 'Stil cron',
    'scheduler.task.cronStyleError' => 'Sintaxă crontab incorectă',
    'scheduler.task.cronStyleErrorWin' => 'Nu se acceptă bare oblice (/) și cratime (-).',
    'scheduler.task.cronStyleHint' => 'Se utilizează formatul de crontab UNIX „minut oră zi-din-lună lună ziua-săptămânii”. De exemplu, „0 22 * * 1-5”. Plesk va executa sarcina folosind fusul orar implicit al sistemului.',
    'scheduler.task.cronStyleWinHint' => 'Se utilizează formatul „minut oră zi-din-lună lună ziua-săptămânii”, de exemplu, „0 22 * * 6,7”. Plesk va executa sarcina folosind fusul orar implicit al sistemului.',
    'scheduler.task.notify' => 'Se trimite notificare',
    'scheduler.task.notifyIgnore' => 'Nu se trimite notificare',
    'scheduler.task.notifyErrors' => 'Doar dacă apar erori',
    'scheduler.task.notifyAlways' => 'De fiecare dată',
    'scheduler.task.notifyErrorsHint' => 'Notificările conțin fluxul standard de erori din comandă. Dacă fluxul este gol, nu se trimite notificare.',
    'scheduler.task.notifyErrorsHintWin' => 'Notificările conțin rezultatul comenzii și se trimit numai în cazul în care codul de ieșire al comenzii este diferit de zero.',
    'scheduler.task.notifyAlwaysHint' => 'Notificările conțin rezultatul comenzii. Dacă ieșirea este goală, nu se trimite notificare.',
    'scheduler.task.notifyAlwaysHintWin' => 'Notificările conțin rezultatul comenzii și se trimit indiferent de codul de ieșire al comenzii.',
    'scheduler.task.emailType' => 'Notificările se trimit la',
    'scheduler.task.emailTypeDefault' => 'Utilizatorul de sistem implicit (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Proprietar abonament (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrator (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Alți utilizatori',
    'scheduler.task.emailTypeCustomDescription' => 'Puteți specifica mai multe adrese, separate prin virgule.',
    'scheduler.task.minute' => 'minute',
    'scheduler.task.shortMinute' => 'min',
    'scheduler.task.dayOfMonth' => 'zi',
    'scheduler.task.description' => 'Descriere',
    'scheduler.task.scheduleTimezoneHint' => 'Fusul orar pentru executarea sarcinii este %%timezone%%',
    'scheduler.task.runTaskNow' => 'Executare imediată',
    'scheduler.task.runningTask' => 'Se execută sarcina „%%task%%”...',

    'server-settings.submitDone' => "Setările serverului au fost modificate.",
    'server-settings.systemSettings' => "Setări de sistem",
    'server-settings.fullHostName' => "Nume complet gazdă",
    'server-settings.trafficStatisticsPeriod' => "Datele statistice despre web și trafic se păstrează timp de",
    'server-settings.trafficStatisticsPeriodUnit' => "luni",
    'server-settings.diskSpaceUsageCalculation' => "În calculul utilizării spațiului pe disc se includ",
    'server-settings.includeLogs' => "fișierele jurnal și rapoartele statistice",
    'server-settings.includeMysqlDatabases' => "baze de date MySQL",
    'server-settings.includeMssqlDatabases' => "baze de date Microsoft SQL",
    'server-settings.includeDatabases' => "bazele de date",
    'server-settings.includeRemoteDatabases' => "baze de date la distanță",
    'server-settings.includeMailboxes' => "căsuțe poștale",
    'server-settings.includeMailLists' => "liste de e-mail",
    'server-settings.includeDomainDumps' => "fișierele copie de rezervă de domeniu",
    'server-settings.includeAdminDumps' => "fișierele copie de rezervă create de administrator",
    'server-settings.calculatingDiskSpaceUsage' => "La determinarea spațiului pe disc utilizat, se ia în calcul",
    'server-settings.typeByte' => "dimensiunea de fișier",
    'server-settings.typeBlock' => "spațiul pe disc utilizat",
    'server-settings.trafficCalculation' => "În calculul de trafic se includ",
    'server-settings.inboundAndOutbound' => "traficul de intrare și cel de ieșire",
    'server-settings.onlyInbound' => "doar traficul de intrare",
    'server-settings.onlyOutbound' => "doar traficul de ieșire",
    'server-settings.forbidCreateDnsSubZone' => "Utilizatorilor li se interzice să creeze subzone DNS în superzonele DNS ale altor utilizatori",
    'server-settings.webDeployIncludePassword' => "Parola utilizatorului se include în fișierul cu setări de publicare Web Deploy",
    'server-settings.forbidSysUserRename' => "Clienții pot schimba numele utilizatorilor lor de sistem",
    'server-settings.alwaysAllowSysUserRename' => "întotdeauna",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "numai dacă au permisiunea Administrare găzduire",
    'server-settings.neverAllowSysUserRename' => "niciodată",
    'server-settings.forbidSubscriptionRename' => "Clienților și resellerilor li se interzice schimbarea numelui domeniului principal",
    'server-settings.preferredDomain' => "Domeniu preferat pentru site-urile web",
    'server-settings.preferredDomainNone' => "niciunul",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Jurnalizare IP",
    'server-settings.disableIpLogging' => "Dezactivarea înregistrării adreselor IP în jurnalele IIS, FTP și de e-mail",
    'server-settings.disableIpLoggingDescription' => "Dacă opțiunea este selectată, IIS și MailEnable nu mai scriu adresele IP în fișierele jurnal",
    'server-settings.anonymizeIps' => "Anonimizarea adreselor IP",
    'server-settings.logrotateAnonymizeIps' => "Anonimizarea adreselor IP în timpul rotației fișierelor jurnal și colectarea de statistici web",
    'server-settings.logrotateAnonymizeIpsDescription' => 'Înainte de arhivare, scriptul post-rotație înlocuiește cu „0” ultimul octet al adreselor IPv4 în fișierele jurnal cu rotație. În adresele IPv6, scriptul înlocuiește ultima secțiune a adresei (cei doi octeți de după ultimul caracter două puncte) cu „0000” (în forma completă) sau cu „0” (în formatul prescurtat)',
    'server-settings.logrotate' => "Rotația jurnalelor",
    'server-settings.logrotateForce' => "Se forțează rotația zilnică pentru toate domeniile",
    'server-settings.allowToStoreLogs' => "Jurnalele site-ului se pot păstra timp de",
    'server-settings.logrotatePeriod' => "zile",
    'server-settings.configureUpdatePolicy' => "Configurarea politicii de actualizare",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Valoarea implicită la nivel de server (%%default%% mesaje pe oră)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Valoare personalizată pentru plan',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Valoare personalizată pentru abonament',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'mesaje',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Mesaje trimise dintr-o căsuță poștală (pe oră)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Mesaje trimise dintr-un domeniu (pe oră)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Mesaje trimise pentru un abonament (pe oră)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Procentul de mesaje care depășesc limita orară, care trebuie trimise în următoarea oră',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Dacă limita de mesaje de e-mail trimise dintr-o căsuță poștală într-o oră este 100 și procentajul este 10%, utilizatorul poate lansa 110 mesaje pe or; 100 vor fi trimise într-o oră, iar 10 vor fi puse în coada de e-mailuri și vor fi programate pentru trimitere în ora următoare.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Politica de utilizare a funcției Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Setări implicite la nivel de server (Sendmail este permis)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Setări implicite la nivel de server (Sendmail nu este permis)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Setări personalizate pentru plan',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Setări personalizate pentru abonament',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Se permite utilizarea funcției Sendmail pentru scripturile și utilizatorii din acest abonament',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Scripturile și utilizatorii vor putea trimite mesaje de e-mail (în numele utilizatorului de sistem corespunzător abonamentului) prin funcția Sendmail chiar dacă limitele definite pentru o căsuță poștală sau pentru domeniu au fost depășite. Numărul maxim de mesaje care se pot trimite prin Sendmail va fi definit de limita valabilă pentru întregul abonament.',

    'setup.hint' => 'Bun venit to Plesk, un panou de control care vă ajută să vă administrați serverul. Plesk asigură un mediu pregătit pentru dezvoltarea de cod și vă pune la dispoziție o suită de extensii complexe pentru a facilita dezvoltarea site-urilor web și a aplicațiilor. Parcurgeți procesul de configurare pentru a începe să utilizați Plesk (durează foarte puțin).',
    'setup.contactInfoSection' => 'Informații de contact',
    'setup.contactInfoSectionHint' => 'Introduceți numele și adresa de e-mail pentru a vă identifica drept proprietar al serverului și pentru a primi notificări importante despre acesta. Dacă sunteți administratorul unui server de corporație, nu introduceți propriul nume sau adresa de e-mail personală. Specificați ce funcție aveți și introduceți adresa de e-mail a corporației, pentru a nu încălca legea privind protecția datelor.',
    'setup.contactName' => 'Numele dvs. de contact',
    'setup.emptyContactName' => 'Introduceți un nume de contact.',
    'setup.contactNameTooLong' => 'Numele de contact este prea lung (se acceptă cel mult %max% simboluri).',
    'setup.email' => 'E-mail',
    'setup.emptyEmail' => 'Introduceți o adresă de e-mail.',
    'setup.passwordSection' => 'Parolă',
    'setup.passwordSectionHint' => 'La următoarea conectare la Plesk, folosiți numele de utilizator „admin” și parola pe care o introduceți mai jos.',
    'setup.password' => 'Parolă',
    'setup.licenseSection' => 'Licență',
    'setup.licenseSectionHint' => 'Pentru a putea începe să utilizați Plesk, trebuie să instalați o licență.',
    'setup.licenseType' => 'Selectați tipul de licență',
    'setup.licenseTypePaid' => 'Continuare cu licență cumpărată',
    'setup.onlineStoreLink' => 'Magazinul online',
    'setup.licenseTypeTrial' => 'Continuare cu licență completă de evaluare',
    'setup.activationCodeHint' => 'Dacă ați cumpărat deja o licență Plesk, lipiți aici codul de activare primit. Dacă nu, puteți cumpăra o licență nouă din %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Politica de confidențialitate Plesk',
    'setup.trialLicenseAgreement' => 'Pentru a emite o licență de evaluare, Plesk Internațional GmbH va folosi și va procesa în sistemele interne informațiile transmise. În acest demers va respecta %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Confirm că am citit și am acceptat documentul %%link%%',
    'setup.eula' => 'Acord de licență cu utilizatorul final',
    'setup.invalidEulaAgreementValue' => 'Trebuie să acceptați Acordul de licență cu utilizatorul final',
    'setup.sendButton' => 'Intrare în Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Resetarea parolei de administrator la următoarea conectare',

    'ssl-certificate.add.name' => 'Nume certificat',
    'ssl-certificate.add.longName' => 'Numele de certificat specificat este prea lung (se acceptă cel mult %max% simboluri).',
    'ssl-certificate.add.certificateNameUsed' => 'Deja există un certificat cu numele %%name%%.',
    'ssl-certificate.add.certificateAdded' => 'Certificatul SSL/TLS a fost emis. Pentru a-l folosi, atribuiți-l ca să securizați un domeniu, e-mailul sau webmailul.',
    'ssl-certificate.add.certificateUpdated' => 'Certificatul SSL/TLS a fost actualizat cu succes.',
    'ssl-certificate.add.settings' => 'Setări',
    'ssl-certificate.add.settingsHint' => 'Utilizați acest formular pentru a genera o solicitare de certificat, pentru a cumpăra un certificat de la furnizor sau pentru a genera un certificat autosemnat.',
    'ssl-certificate.add.settingsHint2' => 'Solicitarea este un fișier CSR care conține informații despre domeniul pe care l-ați precizat în formulat. Puteți trimite solicitarea unei autorități de certificate, pentru ca aceasta să vă emită un certificat. Îl veți încărca folosind unul dintre formularele de mai jos.',
    'ssl-certificate.add.settingsHint3' => 'Certificatul autosemnat este un certificat de identitate semnat de creatorul său. Dacă utilizați un asemenea certificat, înseamnă că garantați personal identitatea site-urilor. Deși certificatele autosemnate permit utilizarea SSL/TLS, acestea prezintă mai puțină încredere și sunt considerate mai puțin sigure.',
    'ssl-certificate.add.bits' => 'Biți',
    'ssl-certificate.add.country' => 'Țară',
    'ssl-certificate.add.state' => 'Stat sau provincie',
    'ssl-certificate.add.longState' => 'Numele de stat sau de provincie specificat este prea lung.',
    'ssl-certificate.add.city' => 'Locație (localitate)',
    'ssl-certificate.add.longCity' => 'Numele de localitate specificat este prea lung.',
    'ssl-certificate.add.shortCity' => 'Numele de localitate specificat este prea scurt.',
    'ssl-certificate.add.companyName' => 'Nume organizație (companie)',
    'ssl-certificate.add.longCompanyName' => 'Numele de companie specificat este prea lung.',
    'ssl-certificate.add.companyUnitName' => 'Nume departament sau divizie din organizație',
    'ssl-certificate.add.longCompanyUnitName' => 'Numele de departament din organizație, pe care l-ați specificat, este prea lung (se acceptă cel mult %max% simboluri).',
    'ssl-certificate.add.domainName' => 'Nume domeniu',
    'ssl-certificate.add.email' => 'E-mail',
    'ssl-certificate.add.request' => 'Solicitare',
    'ssl-certificate.add.buyCertificate' => 'Cumpărare certificat SSL/TLS',
    'ssl-certificate.add.selfSigned' => 'Autosemnat',
    'ssl-certificate.add.invalidCertificateParams' => 'Unele câmpuri sunt necompletate sau conțin valori necorespunzătoare. Valorile pot avea cel mult 64 de caractere. Dacă utilizați un nume de domeniu internațional, asigurați-vă că nicio parte a acestuia, cuprinsă între puncte, nu depășește 63 de simboluri în momentul transformării în format ASCII. Verificați câmpurile:',
    'ssl-certificate.add.unableCreateCsr' => 'Imposibil de creat CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Imposibil de creat certificatul autosemnat: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Imposibil de setat data certificatului: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Imposibil de salvat certificatul în baza de date: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Încărcarea fișierelor certificat',
    'ssl-certificate.add.uploadFilesHint' => 'Utilizați acest formular pentru încărcarea componentelor unui certificat ca fișiere aparținătoare.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Cheie privată (*.key)",
    'ssl-certificate.add.certificate' => "Certificat (*.crt)",
    'ssl-certificate.add.caCertificate' => "Certificat CA (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Încărcare certificat",
    'ssl-certificate.add.fileNotUploaded' => 'Imposibil de încărcat fișierul certificat: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Imposibil de setat cheia privată: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Imposibil de setat certificatul: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Imposibil de setat certificatul CA: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Imposibil de verificat dacă certificatul CA semnează certificatul: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Ștergere',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Sigur ștergeți certificatul CA?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Imposibil de golit certificatul CA: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'Partea CA a certificatului a fost eliminată.',
    'ssl-certificate.add.rename' => 'Redenumire',
    'ssl-certificate.add.unableRenameCertificate' => 'Imposibil de redenumit certificatul: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Certificatul a fost redenumit în %%name%%.',
    'ssl-certificate.add.uploadText' => "Încărcarea certificatului ca text",
    'ssl-certificate.add.uploadTextHint' => 'Utilizați acest formular pentru încărcarea componentelor unui certificat ca text. Copiați conținutul fișierului și lipiți-l în câmpul corespunzător.',
    'ssl-certificate.add.sendText' => "Încărcare certificat",
    'ssl-certificate.add.componentIsMissing' => 'Componenta lipsește.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Încărcați aici certificatul',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Dacă ați creat o solicitare de semnare a certificatului pe acest server și ați primit fișierul certificat, încărcați-l aici. Dacă doriți să încărcați o pereche certificat-cheie privată pe un alt server sau să generați un certificat autosemnat, faceți clic pe <b>Adăugare certificat SSL/TLS</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'După ce adăugați un certificat SSL/TLS la un domeniu, trebuie să activați suportul SSL/TLS și să selectați certificatul respectiv în setările de găzduire de site-uri web: <b>Site-uri web și domenii</b>> <b>Setări de găzduire</b> ale acestui domeniu/> <b>Securitate</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificat (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Încărcare certificat',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Imposibil de încărcat fișierul certificat.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Format de certificat incorect.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Imposibil de găsit cheia privată corectă pentru certificat.',

    'ssl-certificate.secure.certificate' => 'Selectare certificat',
    'ssl-certificate.secure.serverPool' => 'domeniu disponibil pe server',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Data",
    'system-time.dateAndTime' => "Dată și oră",
    'system-time.daylight' => "Ceasul se reglează automat la trecerea la ora de vară/iarnă",
    'system-time.dayMonthYear' => "Zi-Lună-An",
    'system-time.domainNameOrIp' => "Nume domeniu sau IP",
    'system-time.hoursMinutesSeconds' => "ore:minutes:secunde",
    'system-time.networkTime' => "Oră rețea",
    'system-time.submitDone' => "Setările de oră ale sistemului au fost modificate.",
    'system-time.synchronizedSystemTime' => "Sincronizare oră sistem",
    'system-time.title' => "Ora și data sistemului",
    'system-time.timezone' => "Fus orar",
    'system-time.time' => "Ora",
    'system-time.updateSystemTime' => "Actualizare oră sistem",
    'system-time.yourTimezone' => "Fusul orar al dvs.",

    'web-app-firewall.pageHint' => 'Firewallul de aplicații web protejează aceste aplicații de atacuri prin verificarea și filtrarea solicitărilor HTTP, conform unor reguli definite de utilizator.',
    'web-app-firewall.webSitePageHint' => 'Aici puteți configura firewallul de aplicații web (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Mod firewall de aplicații web',
    'web-app-firewall.ruleEngineOn' => 'Pornit',
    'web-app-firewall.ruleEngineOnDescription' => 'Se verifică fiecare solicitare HTTP primită și răspunsul corespunzător, conform unui set de reguli. Dacă nu apar probleme la verificare, solicitarea HTTP este transmisă conținutului de site web. Dacă apar probleme, se înregistrează un eveniment în jurnal, se trimite o notificare și se dă un răspuns HTTP cu cod de eroare.',
    'web-app-firewall.ruleEngineOff' => 'Oprit',
    'web-app-firewall.ruleEngineOffDescription' => 'Nu se verifică nicio solicitare HTTP primită, nici răspunsurile corespunzătoare.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Doar detectare',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Se verifică fiecare solicitare HTTP primită și răspunsul corespunzător, conform unui set de reguli. Dacă nu apar probleme la verificare, solicitarea HTTP este transmisă conținutului de site web. Dacă apar probleme, se înregistrează un eveniment în jurnal, iar ModSecurity nu face nimic altceva. Alte servicii (de exemplu, Fail2ban) pot declanșa propriile lor acțiuni asupra solicitărilor HTTP care nu au trecut verificarea.',
    'web-app-firewall.ruleSetsSection' => 'Seturi de reguli',
    'web-app-firewall.ruleSetsSectionHint' => 'Selectați ce set de reguli (pachet de fișiere care conțin reguli de securitate) veți folosi pentru verificarea solicitărilor HTTP primite.',
    'web-app-firewall.ruleSet' => 'Set de reguli',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratuit)',
    'web-app-firewall.ruleSetCrsDescription' => 'Setul de reguli esențiale ModSecurity OWASP este foarte restrictiv și poate bloca unele funcții (de exemplu, partajarea de fișiere, webmailul) și unele funcții ale aplicațiilor web (de exemplu, pluginurile WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Aplicați modificările?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'Este posibil ca regulile OWASP să fie prea restrictive și, drept urmare, să blocheze unele funcții, cum ar fi partajarea de fișiere, e-mailul prin web și unele aplicații web.',
    'web-app-firewall.ruleSetTortix' => 'Atomic standard (gratuit, permite upgrade la Atomic avansat)',
    'web-app-firewall.ruleSetTortixDescription' => 'O versiune elementară a setului Reguli ModSecurity de la Atomicorp. Aceste reguli asigură o protecție debază și se actualizează lunar.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Pentru a face upgrade la versiunea Atomic avansat a acestui set de reguli:',
    'web-app-firewall.ruleSetTortixBuy' => 'Cumpărați %%linkPleskStore%% de pe site-ul Plesk și %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Reguli ModSecurity avansate de la Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'instalați cheia de licență suplimentară pe care ați cumpărat-o',
    'web-app-firewall.ruleSetTortixSelect' => 'Selectați acest set de reguli. Numele i se va schimba în „Atomic avansat (cumpărat de la Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic avansat (cumpărat de la Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Setul Reguli avansate ModSecurity de la Atomicorp include regulile Atomic standard, plus mai multe funcții avansate.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic avansat (cumpărat de la Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Setul Reguli avansate ModSecurity de la Atomicorp include regulile Atomic standard, plus mai multe funcții avansate.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Trecere la alt cont Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Setul de reguli este activat.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Dacă aveți deja contul Atomicorp cu regulile Atomic avansat cumpărate, introduceți mai jos acreditările contului pentru a activa setul de reguli respectiv.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Dacă aveți deja contul Atomicorp cu regulile Atomic avansat cumpărate, introduceți mai jos acreditările contului pentru a trece la acesta.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Nume utilizator',
    'web-app-firewall.ruleSetAtomicPassword' => 'Parolă',
    'web-app-firewall.ruleSetComodo' => 'Comodo (abonament gratuit)',
    'web-app-firewall.ruleSetComodoDescription' => 'Reguli ModSecurity gratuite de la Comodo. Asigură o protecție de bază.',
    'web-app-firewall.ruleSetComodoInstall' => 'Trecere la alt cont Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Setul de reguli este activat.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Pentru a activa acest set de reguli:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Pentru a trece la alt cont:',
    'web-app-firewall.ruleSetComodoRegister' => 'Înregistrați-vă pe site-ul Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Introduceți numele de utilizator și parola de acces la site-ul respectiv.',
    'web-app-firewall.ruleSetComodoLogin' => 'Nume utilizator',
    'web-app-firewall.ruleSetComodoPassword' => 'Parolă',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratuit)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Reguli ModSecurity gratuite de la Comodo. Asigură o protecție de bază.',
    'web-app-firewall.ruleSetCustom' => 'Set de reguli personalizat',
    'web-app-firewall.ruleSetCustomDescription' => 'Încărcați un set personalizat de reguli de firewall de aplicație web. Formate acceptate: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Selectați un alt fișier',
    'web-app-firewall.ruleSetError' => 'Instalarea setului de reguli ModSecurity nu a reușit: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'Lipsește setul de reguli OWASP. Reinstalați ModSecurity folosind programul de instalare Plesk.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Lipsește setul de reguli personalizat. Reinstalați setul de reguli.',
    'web-app-firewall.ruleSetAuthError' => 'Numele de utilizator sau parola nu sunt corecte.',
    'web-app-firewall.ruleSetInvalid' => 'Setul de reguli selectat nu se poate executa pe %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Setul de reguli selectat nu se poate executa pe serverul web selectat.',
    'web-app-firewall.webServer' => 'Executare reguli pe',
    'web-app-firewall.webServerHint' => 'Pentru a vedea seturile de reguli compatibile, selectați combinația de server web și versiune ModSecurity dorită.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Serverul proxy invers (nginx) este dezactivat și nu poate fi folosit pentru procesarea solicitărilor. Selectați <a href="%%serverUrl%%">un alt server web</a> sau porniți serverul proxy invers în <a href="%%servicesUrl%%">pagina Administrarea serviciilor</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Dacă selectați o altă versiune de ModSecurity, este posibil ca unele setări să înceteze să fie valabile (de exemplu, nu puteți folosi expresii regulate pentru a decupla regulile de securitate în ModSecurity 3). Înainte de a aplica modificările, asigurați-vă că setările funcționează corect. Alternativă: puteți să resetați la valorile implicite setările care dezactivează regulile de securitate.',
    'web-app-firewall.nginxResetCustomizations' => 'Resetați la valorile implicite setările de server și de domeniu care dezactivează regulile de securitate.',
    'web-app-firewall.ruleSetUpdate' => 'Se actualizează seturile de reguli',
    'web-app-firewall.ruleSetUpdateDaily' => 'Zilnic',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Săptămânal',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Lunar',
    'web-app-firewall.currentRuleSet' => 'Set de reguli',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% se execută pe %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Modificare set de reguli',
    'web-app-firewall.ruleSetRollbackFailed' => 'Imposibil de utilizat setul de reguli ModSecurity actual și de revenit la cel anterior, întrucât ambele conțin reguli incorecte.',
    'web-app-firewall.configurationSection' => 'Configurare',
    'web-app-firewall.configurationSectionHint' => 'Configurați firewallul de aplicație web folosind un set predefinit de parametri sau propriile directive ModSecurity personalizate.',
    'web-app-firewall.configPreset' => 'Set predefinit de valori',
    'web-app-firewall.configPresetFast' => 'Rapid',
    'web-app-firewall.configPresetFastDescription' => 'Din solicitările HTTP se vor analiza URI-ul și părți din antet.',
    'web-app-firewall.configPresetTradeOff' => 'Compromis viteză/detalii',
    'web-app-firewall.configPresetTradeOffDescription' => 'Se vor analiza URI-urile și antetele solicitărilor HTTP precum și datele POST din solicitare.',
    'web-app-firewall.configPresetThrough' => 'Detaliat',
    'web-app-firewall.configPresetThroughDescription' => 'Se vor analiza antetele solicitărilor HTTP în întregime, datele POST din solicitare și conținutul secțiunii „body” a răspunsului HTTP.',
    'web-app-firewall.configCustom' => 'Directive personalizate',
    'web-app-firewall.configCustomDescription' => "Introduceți aici o directivă ModSecurity. Aceasta va avea prioritate față de directivele specificate anterior (seturi de reguli, reguli specifice, setul predefinit de valori etc.). De exemplu: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Configurație ModSecurity incorectă: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Imposibil de utilizat fișierul de configurație ModSecurity actual și de revenit la cel anterior, întrucât ambele conțin configurații incorecte.',
    'web-app-firewall.rulesSection' => 'Dezactivarea regulilor de securitate',
    'web-app-firewall.rulesSectionHint' => 'Aici puteți dezactiva regulile de securitate. Acest lucru este util dacă o regulă de securitate se dovedește a fi prea restrictivă pentru anumite site-uri web. Pentru a dezactiva reguli de securitate, specificați ID-urile (de exemplu, 340003 sau 340005-340007), etichetele (de exemplu, CVE-2011-4898) sau expresiile regulate utilizate în mesajele legate de regulă (de exemplu, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Aici puteți dezactiva regulile de securitate. Acest lucru este util dacă o regulă de securitate se dovedește a fi prea restrictivă pentru anumite site-uri web. Pentru a dezactiva reguli de securitate, specificați ID-urile (de exemplu, 340003 sau 340005-340007), etichetele (de exemplu, CVE-2011-4898) sau mesajele legate de regulă (de exemplu, S-a depistat agent utilizator asociat cu un scanner de securitate).',
    'web-app-firewall.filterById' => 'ID-uri de reguli de securitate',
    'web-app-firewall.filterByIdInvalid' => 'Următoarele valori sunt incorecte: %%values%%. ID-ul regulii trebuie să fie alcătuit din cifre sau șiruri de cifre, de exemplu, 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Următoarele intervale sunt incorecte: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Etichete',
    'web-app-firewall.filterByTagActive' => 'Activă:',
    'web-app-firewall.filterByTagDeactivated' => 'Dezactivată:',
    'web-app-firewall.filterByTagInvalid' => 'Următoarele valori selectate sunt incorecte: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Expresii regulate în mesajele legate de reguli',
    'web-app-firewall.filterByRegexpInvalid' => 'Următoarele valori sunt incorecte: %%values%%. Acestea nu pot conține caracterele \', ".',
    'web-app-firewall.filterByRegexpNginx' => 'Mesaje legate de reguli',
    'web-app-firewall.filterByRegexpNginxHint' => 'Nu se acceptă decât potrivirile stricte.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Următoarele valori sun incorecte: %%values%%. Mesajul despre regulă nu poate conține decât litere, cifre, spații și caracterele -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Jurnal de audit ModSecurity',
    'web-app-firewall.auditLogHint1' => 'Fișierul jurnal de audit ModSecurity conține cele mai utile informații din sistem. În momentul în care ModSecurity detectează producerea unui eveniment oarecare, generează o intrare în fișierul jurnal de audit.',
    'web-app-firewall.auditLogHint2' => 'Dacă schimbați modul de firewall de aplicație web din Oprit sau din Doar detectare în Pornit, este posibil ca site-ul web să înceteze să funcționeze. Într-un asemenea caz, analizați jurnalul de audit ModSecurity pentru a afla ce se petrece. Puteți dezactiva regulile de securitate prea restrictive sau puteți ajusta site-ul.',
    'web-app-firewall.auditLogHint3' => 'Pentru a afla de ce nu se poate executa o solicitare HTTP pentru un site web:',
    'web-app-firewall.auditLogPoint1' => 'Faceți clic pe linkul Fișier jurnal ModSecurity de mai jos și deschideți jurnalul de audit într-o nouă fereastră de browser.',
    'web-app-firewall.auditLogPoint2' => 'Utilizați funcția de Căutare (Ctrl+F în majoritatea browserelor web) pentru a găsi evenimentele corespunzătoare site-ului (numelui de domeniu) care prezintă probleme. De exemplu, domeniul_dvs.tld. Browserul va evidenția intrări ca HOST: domeniul_dvs.tld.',
    'web-app-firewall.auditLogPoint3' => 'Căutați, în cele trei rânduri de deasupra intrării evidențiate, un șir de caractere cum ar fi --eece5138-B--. Cele opt simboluri dintre cratime (în acest exemplu, eece5138) reprezintă ID-ul evenimentului declanșat de solicitarea HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Căutați și alte intrări cu același ID de eveniment. Căutați o intrare în care ID-ul de eveniment este urmat de litera H (în acest exemplu, eece5138-H--). Această intrare conține ID-ul și descrierea regulii de securitate declanșate la verificarea solicitării HTTP. ID-ul regulii de securitate este un număr întreg, scris între ghilimele, care începe cu 3. Apare între paranteze pătrate, împreună cu prefixul „id”. De exemplu, [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'Localizați un ID de regulă de securitate în eveniment: căutați șirul de caractere [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Dezactivați regula de securitate cu acest ID în secțiunea Reguli de securitate de mai jos: introduceți ID-ul regulii (doar cifrele) în câmpul ID-uri de reguli de securitate, apoi faceți clic pe OK.',
    'web-app-firewall.auditLogViewLink' => 'Fișier jurnal ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Arhiva de jurnale',
    'web-app-firewall.errorLogSection' => 'Jurnal de erori',
    'web-app-firewall.errorLogSectionHint' => 'Dacă schimbați modul de firewall de aplicație web din Oprit sau din Doar detectare în Pornit, este posibil ca site-ul web să înceteze să funcționeze. Într-un asemenea caz, analizați jurnalul de erori pentru a afla ce se petrece. Puteți dezactiva regulile de securitate prea restrictive sau puteți ajusta site-ul.',
    'web-app-firewall.errorLogViewLink' => 'Fișier jurnal de erori',
    'web-app-firewall.notificationStateEnabled' => 'Notificările în interfața Plesk despre actualizările seturilor de reguli sunt activate. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Notificările în interfața Plesk despre actualizările seturilor de reguli sunt dezactivate. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Gestionați-le în pagina de notificări',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Dacă selectați opțiunea „Compromis” sau „Detaliat”, este posibil ca site-urile WordPress să nu funcționeze corect și să apară și alte efecte secundare. Cauza: următoarea <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">problemă ModSecurity</a>.',

    'ProtectedDirectory.pathLabel' => 'Nume director',
    'ProtectedDirectory.realmLabel' => 'Titlul zonei protejate',
    'ProtectedDirectory.locationLabel' => 'Locație director',
    'ProtectedDirectory.isNonSslLabel' => 'non-SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'Nume raport',
    'SummaryReport.Layout.isDefault' => 'Utilizare ca raport implicit',
    'SummaryReport.Layout.sections' => 'Secțiuni',
    'SummaryReport.Layout.general' => 'General',
    'SummaryReport.Layout.resellers' => 'Reselleri',
    'SummaryReport.Layout.clients' => 'Clienți',
    'SummaryReport.Layout.personalClients' => 'Clienți proprii',
    'SummaryReport.Layout.domains' => 'Domenii',
    'SummaryReport.Layout.personalDomains' => 'Domenii personale',
    'SummaryReport.Layout.type.full' => 'Complet',
    'SummaryReport.Layout.type.summary' => 'Rezumat',
];