<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'title' => 'Website Log Check',

    'regularCheck' => 'Automatic check',
    'manualCheck' => 'Manual check',

    'promoTitle' => 'Fast detection of unavailability or incorrect work of your websites',
    'promoDescription' => 'Website issues are often visible to visitors but not to administrators unless they constantly analyze website logs. Our brand new Website Log Check automates this routine and helps to resolve found issues efficiently.',
    'promoMore' => 'Learn more',
    'promoButton' => 'Got it!',
    'checkEnabledTitle' => 'Automatic check is on',
    'checkDisabledTitle' => 'Automatic check is off',
    'disabledDescription' => 'Turn on to automatically detect issues that can make websites unavailable or cause their incorrect operation.',
    'websitesAllChecked' => '{count, plural, one {# website gets} other {# websites get}} checked daily',
    'websitesAllCheckedAt' => '{count, plural, one {# website gets} other {# websites get}} checked daily at %%time%%',
    'websitesChecked' => '%%count%% of %%totalCount%% websites get checked daily',
    'websitesCheckedAt' => '%%count%% of %%totalCount%% websites get checked daily at %%time%%',
    'checkedWebsites' => 'List of checked websites',
    'lastCheckDescription' => 'The last check took %%duration%% minutes.',
    'durationLess' => 'less than 0.1',
    'month0' => '%%date%% Jan',
    'month1' => '%%date%% Feb',
    'month2' => '%%date%% Mar',
    'month3' => '%%date%% Apr',
    'month4' => '%%date%% May',
    'month5' => '%%date%% Jun',
    'month6' => '%%date%% Jul',
    'month7' => '%%date%% Aug',
    'month8' => '%%date%% Sep',
    'month9' => '%%date%% Oct',
    'month10' => '%%date%% Nov',
    'month11' => '%%date%% Dec',
    'export' => 'Export the report to CSV',
    'buttonRun' => 'Run manual check',
    'buttonRunDescription' => 'To recheck fixed websites or find issues that did not appear during the last check.',

    'websites.title' => 'Websites to check',
    'websites.description' => '%%selected%% of %%total%% websites are selected',
    'websites.search' => 'Find websites...',
    'websites.new' => 'All newly created websites',
    'websites.newHint' => 'Select to automatically start checking all new websites.',
    'websites.existing' => 'All existing websites',
    'websites.buttonSave' => 'Save',
    'websites.buttonCancel' => 'Cancel',
    'websites.updateSuccess' => 'Settings were updated',

    'tabs.problemDetails' => 'Issue details',
    'tabs.affectedWebsites' => 'Affected websites',

    'chart.requests' => 'Requests',
    'chart.errors' => 'Errors',

    'affected-websites.selected' => '%%selectedCount%% of %%totalCount%% websites are selected',
    'affected-websites.none' => 'None',
    'affected-websites.all' => 'All',
    'affected-websites.searchForWebsite' => 'Search for websites',
    'affected-websites.websites' => 'Websites',
    'affected-websites.showProblemDetails' => 'Show problem details',

    'problem-report.domainTitle' => 'Issue reported on %%domain%%',
    'problem-report.cumulativeTitle' => 'Issue reported on {count, plural, one {# website} other {# websites}}',
    'problem-report.serverwideTitle' => 'Server-wide issue reported',
    'problem-report.problemAppearsOn' => 'The issue appears on {count, plural, one {# website} other {# websites}} in total',
    'problem-report.seeTheConsolidatedReport' => 'See the consolidated report',
    'problem-report.cause' => 'Root cause',
    'problem-report.possibleSolutions' => 'Possible solutions',
    'problem-report.useAnOption' => 'Use an option for automatic solution',
    'problem-report.repairTheWebsite' => 'Repair the website',
    'problem-report.selectAndRepair' => 'Select and repair several websites',
    'problem-report.distributionOfTheProblem' => 'Distribution of the issue over time',
    'problem-report.serverTimezone' => 'Server time zone (UTC%%utcShift%%)',
    'problem-report.yourTimezone' => 'Your time zone (UTC%%utcShift%%)',
    'problem-report.logEntries' => 'Examples of log entries indicating the issue',
    'problem-report.pleaseKeepInMind' => 'Note: Plesk constantly rotates logs and will eventually archive or delete the mentioned log entries.',
    'problem-report.weRecommendToRecheck' => '%%recheckWebsite%%—we recommend it after each fixing attempt.',
    'problem-report.recheckWebsite' => 'Recheck website manually',
    'problem-report.option' => 'Option %%number%%:',
    'problem-report.recommended' => 'recommended',
    'problem-report.numberOfEntries' => 'Number of entries',
    'problem-report.logEntry' => 'Log entry',
    'problem-report.logFile' => 'Log file',
    'problem-report.openWebsiteLogs' => 'Open website logs',
    'problem-report.thisIsServerWideProblem' => 'This is a server-wide issue that affects all hosted websites',
    'problem-report.serverWideTitle' => 'Server-wide issue reported',
    'problem-report.checkDetectedIssue' => 'Check had detected the issue (server time zone - UTC%%timezone%%):',
    'problem-report.todayAt' => 'today at %%time%%',
    'problem-report.yesterdayAt' => 'yesterday at %%time%%',
    'problem-report.dateAt' => '%%date%% at %%time%%',
    'problem-report.firstProblemTime' => 'First time - %%info%%',
    'problem-report.lastProblemTime' => 'Last time - %%info%%',

    'distribution-over-time.title' => 'Distribution of the issue over time',
    'distribution-over-time.titleYesterday' => 'Distribution of the issue over time (Yesterday)',
    'distribution-over-time.titleToday' => 'Distribution of the issue over time (Today)',
    'distribution-over-time.serverTimezone' => 'Server time zone (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Your time zone (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'We recommend that you compare the error distribution chart with %%link%% in Monitoring',
    'distribution-over-time.resourceUsageCharts' => 'Resource usage charts',
    'distribution-over-time.noDataForRecentTime' => 'No data for recent time. %%suggestion%%',
    'distribution-over-time.pleseEnableRegularCheck' => 'Enable automatic check or check the website manually',
    'distribution-over-time.pleseIncludeWebsiteForCheck' => 'Add the website to the list of those checked automatically or check the website manually',
    'distribution-over-time.pleaseWaitUntilRegularCheckWillBeStarted' => 'Wait until the automatic check starts or check the website manually',
    'distribution-over-time.enableRegularCheck' => 'Enable automatic check',
    'distribution-over-time.addWebsiteToRegularCheckList' => 'Add the website to the list of those checked automatically',
    'distribution-over-time.runManualCheck' => 'Run manual check',

    'report.title' => 'Report on the last check',
    'report.groupByWebsites' => 'Grouped by websites',
    'report.groupByProblems' => 'By issues',
    'report.columnWebsite' => 'Website',
    'report.columnStatus' => 'Issues',
    'report.columnProblem' => 'Issue',
    'report.columnAppearedOn' => 'Detected on',
    'report.serverWideName' => 'Server-wide issues',
    'report.serverWideDescription' => 'These issues affect the whole server and its hosted websites.',
    'report.statusProblemsFound' => '%%count%% found',
    'report.statusProblemsFoundFull' => '{count, plural, one {# issue} other {# issues}} found',
    'report.statusProblemsSolved' => '%%count%% disappeared',
    'report.statusProblemsSolvedFull' => '{count, plural, one {# issue} other {# issues}} disappeared',
    'report.statusSuccess' => 'No issues',
    'report.serverWide' => 'The whole server',
    'report.appearedOn' => '{count, plural, one {# website} other {# websites}}',
    'report.recheckWebsite' => 'Recheck website',
    'report.actionOpen' => 'Open',
    'report.actionManage' => 'Manage',
    'report.actionLogs' => 'View logs',
    'report.searchWebsite' => 'Find websites...',
    'report.searchProblem' => 'Find issues...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# issue} other {# issues}} on {websitesCount, plural, one {# website} other {# websites}}',
    'report.noProblemsTitle' => 'No issues were found on {websitesCount, plural, one {# website} other {# websites}}',
    'report.noProblemsDescription' => 'Looks like you keep your websites in good shape. Well done!',

    'problems.columnTitle' => 'Issue',
    'problems.columnRegular' => 'Automatic check',
    'problems.columnManual' => 'Manual check',
    'problems.run' => '%%fromTime%% %%fromDate%% - %%toTime%% %%toDate%%',
    'problems.runSameDay' => '%%fromTime%% - %%toTime%% at %%toDate%%',
    'problems.notRun' => 'not performed yet',
    'problems.resultDetected' => 'Detected',
    'problems.resultNotDetected' => 'Not detected',
    'problems.resultNoProblems' => 'No issues',

    'new-check.title' => 'Manual check',
    'new-check.titleForWebsite' => 'Manual check of %%website%%',
    'new-check.titleRunning' => 'Manual check of {count, plural, one {# website} other {# websites}}',
    'new-check.description' => '%%selected%% of %%total%% websites are selected',
    'new-check.depth' => 'Check period',
    'new-check.checkTheLast' => 'Check the last',
    'new-check.selectHours' => 'Hours',
    'new-check.selectMinutes' => 'Minutes',
    'new-check.ifYouHaveAnyProblemActivities' => 'If you tried fixing the website issues, set the time period after this attempt. Otherwise Plesk can detect issues you have already resolved.',
    'new-check.weAlsoRecommendVisiting' => 'Before running a manual check, we recommend that you %%visitingTheWebsite%% and try to reproduce the issue.',
    'new-check.visitingTheWebsite' => 'visit the website',
    'new-check.hours' => 'last hours',
    'new-check.websites' => 'Websites to check',
    'new-check.buttonSave' => 'Check',
    'new-check.buttonCancel' => 'Cancel',
    'new-check.search' => 'Find websites...',
    'new-check.checkProblems' => 'Websites with issues during the last check',
    'new-check.allWebsites' => 'All websites',
];
