<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => '其他密钥属性',
    'additional-key-info.update' => '检索其它的密钥',
    'additional-key-info.updateDescription' => '检索并安装其他密钥。',
    'additional-key-info.download' => '下载许可证',
    'additional-key-info.downloadDescription' => '下载当前许可证密钥。',
    'additional-key-info.install' => '安装许可证',
    'additional-key-info.installDescription' => '安装当前的许可证密钥。',
    'additional-key-info.revert' => '恢复许可证',
    'additional-key-info.revertDescription' => '恢复到之前安装的许可证密钥。',
    'additional-key-info.revertNotAvailableDescription' => '尚未安装密钥。',
    'additional-key-info.installSuccess' => '许可证秘钥安装已开始。',

    'additional-key-revert.title' => '其他密钥回滚',
    'additional-key-revert.success' => '其他密钥已回滚。',

    'additional-key-upload.title' => '安装许可证密钥',
    'additional-key-upload.success' => '新附加许可证已上传。',

    'additional-keys.title' => '其他许可证密钥',

    'change-owner.title' => '正在重新分配选定的订阅',

    'customers.hint' => '您可在此管理主机服务客户的帐户，包括创建帐户和服务订阅，管理现有客户，以及移除帐户。若要管理客户的网站、邮件或任何其它服务，请点击列表右边的链接进入 客户面板 进行操作。',

    'customer-domains.hint' => '在此处您可以创建并管理网站。',

    'customer-subscriptions.hint' => '在此处您可以管理客户的订阅。',

    'domains.hint' => '您可在此查看系统中注册的所有域名信息，以及管理主机服务。若要为自己或主机客户添加域名，请点击“添加域名”。创建域名时会提示您创建新客户和订阅，也可以选择现有的客户和订阅。',

    'database-servers.title' => '数据库服务器',

    'database-server-create.title' => '新建数据库服务器',

    'database-server-properties.title' => '数据库服务器',

    'database-server-upgrade.title' => '数据库服务器升级',
    'database-server-upgrade.currentVersion' => '当前版本',
    'database-server-upgrade.selectVersion' => '选择版本',
    'database-server-upgrade.information' => '信息',
    'database-server-upgrade.releaseNotes' => '发行说明',
    'database-server-upgrade.releaseDate' => '发行日期',
    'database-server-upgrade.unable' => '无法升级',
    'database-server-upgrade.endOfLifeDate' => '使用寿命终止日期',
    'database-server-upgrade.description' => 'MySQL/MariaDB 是一种常用的关系数据库管理系统，是大多数 Plesk 系统的核心服务。此界面允许您将 MySQL/MariaDB 服务器升级到 10.6 版本。Plesk 会自动将您的 MySQL/MariaDB 安装升级到较新的点版本（版本字符串中的第三个数字），因为这些升级对您的用户数据几乎没有风险。升级到新的主版本（版本字符串中的前两位数字）更复杂，因为存在很大的数据丢失风险。此界面尝试引导您完成主版本升级过程。',
    'database-server-upgrade.warning' => '尽管就地升级通常是安全的，但我们强烈建议您在升级之前执行完整的数据库备份。不支持降级到早期版本。升级数据库服务器后，可能无法恢复到早期版本。用 MySQL 8 替换 MariaDB 被视为降级，不受支持。',

    'database-server-databases.title' => '数据库',

    'database-server-change-password.title' => '管理员密码',

    'home.title' => '首页',

    'license.title' => '许可证信息',

    'primary-key-info.title' => 'Plesk 许可证密钥',
    'primary-key-info.update' => '检索密钥',
    'primary-key-info.updateDescription' => '检索订购的许可证密钥并进行安装。',
    'primary-key-info.upload' => '安装许可证',
    'primary-key-info.uploadDescription' => '上传并安装新的许可证。',
    'primary-key-info.revert' => '恢复许可证',
    'primary-key-info.revertDescription' => '恢复到之前安装的许可证密钥。',

    'primary-key-revert.title' => '许可证密钥回滚',
    'primary-key-revert.success' => 'Plesk 密钥已回滚。',

    'primary-key-upload.title' => '安装许可证密钥',
    'primary-key-upload.success' => '新的 Plesk 密钥已被上传。',

    'resellers.hint' => '您可在此管理代理商，即代理主机服务以及托管自己的网站的客户。您可创建帐户及其服务订阅，管理现有代理商，以及移除帐户。',

    'reseller-customers.hint' => '在此处您可以设置并管理客户。',

    'reseller-domains.hint' => '在此处您可以创建并管理网站。',

    'reseller-subscriptions.hint' => '您可以在此管理代理商的订阅。',

    'subscriptions.hint' => '客户可通过订阅主机方案获取主机服务。您可在此管理此类订阅以及您自行创建用于托管自己网站的订阅。若要管理订阅的网站、邮件或任何其它服务，请点击列表右边的链接进入订阅者的“客户面板”进行操作。',

    'server-mail-settings.title' => '设置',
    'server-mail-spam-filter.title' => '垃圾邮件过滤',
    'server-mail-antivirus.title' => '防病毒程序',
    'server-mail-black-list.title' => '黑名单',
    'server-mail-white-list.title' => '白名单',
    'server-mail-queue.title' => '邮件队列',
    'server-mail-statistics.title' => '统计',

    'firewall.title' => '防火墙管理',
    'firewall-general.title' => '常用',
    'firewall-general.toggleStatus' => '防火墙保护',
    'firewall-general.buttonDefault' => '重设为默认值',
    'firewall-general.buttonPanic' => '应急模式',
    'firewall-general.confirmationDefault' => '将防火墙设置重置为默认的设置？',
    'firewall-general.confirmationPanic' => '打开恐慌模式？用户将无法访问他们的域名，一些网络服务可能会停止工作。',
    'firewall-general.successDefault' => '防火墙设置已被重置为默认值。',
    'firewall-general.successPanic' => '恐慌模式已启用。',
    'firewall-general.info' => '出于安全原因，防火墙阻止了除明确允许的之外所有连接。您可以通过创建某个规则来允许某个连接。更多信息，请参阅相关文档。',
    'firewall-general.interfaces' => '网络接口',
    'firewall-icmp.title' => 'ICMP 协议',
    'firewall-rules.title' => '防火墙规则',

    'dns.title' => 'DNS设置',
    'dns-records.title' => '区域记录模板',
    'dns-soa-record.title' => '区域设置模板',

    'php-handler.title' => ' %%name%% 的设置',
    'php-handler.extensions.title' => '扩展',
    'php-handler.extensions.description' => '这些 PHP 扩展设置仅针对该处理程序。',
    'php-handler.extensions.descriptionShared' => '这些设置通用于以下 PHP 处理程序：%%handlers%%。该设置应用到使用这些处理程序的所有网站。',
    'php-handler.extensions.buttonManage' => '管理 PECL 程序包',
    'php-handler.extensions.manage.title' => '管理 PECL 程序包',
    'php-handler.extensions.manage.risks' => 'PHP扩展由第三方PECL程序包提供。您安装它们的风险将自行承担。',
    'php-handler.extensions.manage.description' => '安装、升级和卸载 PECL 程序包。这些更改将应用于在%%handlers%%上运行的所有网站。',
    'php-handler.extensions.manage.notFound' => '为什么所需的程序包不在列表上？',
    'php-handler.extensions.manage.limitations' => '由控制面板提供商和操作系统供应商提供的PHP扩展没有在列表中显示。',
    'php-handler.php-ini.title' => 'php.ini',

    'ServerAbout.copyright' => '© 2023 Plesk International GmbH。保留所有权利。',
    'ServerAbout.linkLicenseManagement' => '转到许可证信息',
    'ServerAbout.panelVersion' => '版本',
    'ServerAbout.installedPatchVersion' => '更新 #%%patch%%',
    'ServerAbout.licenseKey' => '许可证密钥',
    'ServerAbout.productDescription' => 'Plesk 是实现应用、网站和主机业务的运行、自动化和增长的领导 WebOps 平台。',
    'ServerAbout.readEula' => '阅读 %%link%%。',
    'ServerAbout.linkEula' => '最终用户许可协议',
    'ServerAbout.visitForum' => '访问 %%link%%',
    'ServerAbout.linkForum' => 'Plesk 论坛',
    'ServerAbout.followUs' => '关注我们',
    'ServerAbout.visitSite' => '可访问 %%link%% 了解更多',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => '在 %%link%% 中找到灵感',
    'ServerAbout.linkBlog' => 'Plesk 博客',

    'ServerAbout.darkThemePromoTitle' => '恭喜！',
    'ServerAbout.darkThemePromoDescription' => '您发现了在周年庆 Plesk Obsidian 18.0.50 版本中添加的一只神奇猫咪。',
    'ServerAbout.darkThemePromoButton' => '呼嗖！到黑暗面来吧',
    'ServerAbout.darkThemeTourDescription' => '切换该选项以启用或禁用您界面的深色模式主题。',
    'ServerAbout.darkThemeTourButton' => '明白了',

    'ts-sessions.title' => '终端服务器会话',
    'ts-sessions-properties.title' => '会话属性',

    'BandwidthLimiting.title' => '%%domainName%% 的带宽限制',
    'BandwidthLimiting.bandwidthThrottling' => '您不能控制带宽节流，因为 QoS 尚未安装。',
    'BandwidthLimiting.virtualHostingRequired' => '带宽限制仅适用于具有 web 主机的域名。',
    'BandwidthLimiting.bandwidthLabel' => '带宽最大使用量',
    'BandwidthLimiting.bandwidthHint' => '带宽使用限制仅适用于通过HTTP协议传输的数据。',
    'BandwidthLimiting.maxConnectionLabel' => '最大连接数',
    'BandwidthLimiting.maxConnectionHint' => '如果您限制带宽，则建议您也限制此网站的同时连接数。如果网站请求频率较高，则Web服务器进程会增加服务器负载。',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => '带宽限制设置已被更改。',
    'BandwidthLimiting.unlimited' => '无限',

    'ip-address-domains.title' => '使用%%type%% IP地址%%ipAddress%%的网站',
    'ip-address-domains.site' => '网站',
    'ip-address-domains.setAsDefault' => '设为默认值',
    'ip-address-domains.type-SHARED' => '共享',
    'ip-address-domains.type-EXCLUSIVE' => '独立',

    'HotlinkProtection.title' => '%%domainName%% 的盗链防护',
    'HotlinkProtection.virtualHostingRequired' => '盗链防护只能用于带有 web 主机的域名。',
    'HotlinkProtection.enabledLabel' => '启用盗链防护',
    'HotlinkProtection.extensionsLabel' => '受保护的文件扩展名',
    'HotlinkProtection.friendsLabel' => '友好网站地址',
    'HotlinkProtection.success' => '盗链防护设置已更改。',

    'Odbc.serverTitle' => 'ODBC DSN 连接',
    'Odbc.domainTitle' => '%%domainName%% ODBC DSN 连接',
    'Odbc.add' => '添加 ODBC DSN',
    'Odbc.resourceUsage' => '允许创建 %%allowed%%，已创建 %%used%%。',
    'Odbc.limitExceeded' => '已超出 ODBC DSN 连接限制。',
    'Odbc.unlimited' => '无限',
    'Odbc.addTooltip' => '添加ODBC数据源。',
    'Odbc.status' => '状态',
    'Odbc.name' => '连接名',
    'Odbc.driver' => '驱动程序',
    'Odbc.description' => '连接描述',
    'Odbc.hostname' => '主机名',
    'Odbc.statusSystem' => '这是系统 DSN。',
    'Odbc.statusConfigured' => 'DSN 已配置。',
    'Odbc.statusNotConfigured' => 'DSN 尚未配置。',
    'Odbc.noSelectionText' => '选择要移除的一个或多个项目。',
    'Odbc.removeConfirmation' => '是否移除{count, plural, =1 {{name} 连接} other {#选定的连接}}？',
    'Odbc.removeSuccess' => '选定的连接已被移除。',

    'DomainAliasSettings.title' => '域名别名设置',
    'DomainAliasSettings.updateSuccess' => '域名别名 %%name%% 的属性已更改。%%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => '网站设置将在%%restartInterval%% 分钟后被应用。',

    'HostingSettings.title' => '主机设置',
    'HostingSettings.updateSuccess' => '设置已更新。',
    'HostingSettings.emptyLogin' => '请指定用户名。',
    'HostingSettings.emptyPassword' => '请指定密码。',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP 服务器不支持 IPv6。至少分配一个 IPv4 地址，不然用户将无法通过 FTP 上传文件到服务器。',
    'HostingSettings.domainSettingsSection.sectionTitle' => '域名设置',
    'HostingSettings.domainSettingsSection.domainName' => '域名',
    'HostingSettings.domainSettingsSection.description' => '例如，example.com ',

    'HostingSettings.submitPopover.title' => '移除 %%website%% 内容',
    'HostingSettings.submitPopover.descriptionMainDomain' => '将“网站”主机类型切换为“%%type%%”将永久移除整个网站的内容，包括以下目录：',
    'HostingSettings.submitPopover.descriptionSubDomain' => '您要更改网站的主机类型吗？',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => '要访问更多设置，请输入系统用户验证凭据，然后单击“创建主机空间”。',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => '要访问更多设置，请单击“下一步”以创建主机。',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => '主机类型',
    'HostingSettings.domainSettingsSection.hostingType.title' => '类型',
    'HostingSettings.domainSettingsSection.hostingType.website' => '网站',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => '转发',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => '无主机',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => '使用域名的 DNS 区域在此域名下拥有邮箱',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => '进入网站主目录的路径',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => '偏好域名',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => '访客将通过 SEO 友好的 HTTP301 重定向被重新定向到这里。',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => '将访客转发到',
    'HostingSettings.domainSettingsSection.forwardingType.title' => '转发类型',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => '永久移动（代码 301）',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => '将网站访客重定向到另一个网站，并向他们显示目标地址。这样的重定向将保持网站的搜索排名',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => '暂时移动（代码 302）',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => '当您不想让搜索引擎索引此临时网站时，可重定向访问者到临时网站副本。',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => '帧转发',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => '重定向网站访客到另一网站，但不向访客显示目标地址，让访客不知道被重定向。',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => '偏好域名',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => '无',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => '文档根目录',
    'HostingSettings.domainSettingsSection.documentRootHint' => '因web应用程序安装到此网站上，无法更改文档根目录。',
    'HostingSettings.domainSettingsSection.save' => '保存',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => '更改此设置？',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => '更改此设置与服务器的安全策略相矛盾，可能会降低性能或使服务器易受攻击。',
    'HostingSettings.domainSettingsSection.security.buttonChange' => '更改',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => '还原',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => '已应用安全设置预设',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => '为提高安全性，请应用安全设置预设。请注意，某些权限允许订户修改这些设置。',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => '应用安全预设',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => '了解安全主机设置',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS 支持',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => '启用',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => '加密网站和访客浏览器之间的连接。',
    'HostingSettings.domainSettingsSection.security.certificate' => '证书',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => '要启用 HTTPS，请将 SSL/TLS 证书上传到域名的证书库，然后在此处选择它。',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => '通过 SEO 友好的 301 重定向将访客从 HTTP 重新定向到 HTTPS',
    'HostingSettings.domainSettingsSection.security.noCertificates' => '在您的 repository 中没有 SSL/TLS 证书。要添加证书请进入 %%link%%。',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => '此页面',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%%（其他库）',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => '未选定',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web 脚本',
    'HostingSettings.domainSettingsSection.webScripting.description' => '选择哪些编程和脚本语言必须由 web 服务器解释。',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin目录位于%%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => '在 htm 和 html 文件中使用 SSI',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET 版本',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => '自定义错误文档',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin目录位于',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => '此域名的文档根目录',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => '主机空间的根目录',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => '该域名旧式的根目录',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => '自定义错误文档',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => '其他写入/修改权限',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy 发布',
    'HostingSettings.domainSettingsSection.webStatistics.title' => '网站统计',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => '工具',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => '使用您的 FTP 用户名和密码对您的网站统计访问权限加以保护',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => '禁用',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => '主机空间设置',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP 地址',
    'HostingSettings.webspaceSettingsSection.quota.title' => '磁盘空间配额',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => '启用',
    'HostingSettings.webspaceSettingsSection.quota.description' => '如果超过订阅设置中设定的磁盘空间配额（如有），则禁止对网站的文件进行操作。',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => '由于服务器的文件系统配置，不支持硬盘配额。',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => '系统用户验证凭据',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => '通过 FTP 或文件管理器管理网站的文件和文件夹。如果允许，通过 SSH 访问服务器。',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => '通过 FTP 或文件管理器管理网站的文件和文件夹。如果允许，通过远程桌面访问服务器。',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => '用户名',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => '密码',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => '在此处指定一个新密码以更改系统用户的密码。',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH 访问',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => '远程桌面访问',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => '启用',
    'HostingSettings.webspaceSettingsSection.shell.description' => "使用系统用户凭据访问服务器。",
    'HostingSettings.webspaceSettingsSection.shell.type' => '类型',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => '禁用',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => '对{count, plural, other {#域名}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => '以下设置对所有{count, plural, other {# {name}主机空间中的域名}}来说是共有的：',

    'OdbcAdd.title' => '添加 ODBC DSN',
    'OdbcAdd.nameLabel' => '连接名',
    'OdbcAdd.descriptionLabel' => '连接描述',
    'OdbcAdd.driver' => '驱动程序',
    'OdbcAdd.submit' => '创建 ODBC DSN',

    'OdbcEdit.title' => 'ODBC连接配置',
    'OdbcEdit.saveSuccess' => '已保存连接设置。',
    'OdbcEdit.test' => '测试连接',
    'OdbcEdit.connectSuccess' => '连接成功。',

    'OdbcEdit.excel.driver.label' => '驱动程序',
    'OdbcEdit.excel.dbq.label' => '数据库文件路径',
    'OdbcEdit.excel.defaultdir.label' => '默认数据路径',
    'OdbcEdit.excel.fil.label' => '数据库版本',
    'OdbcEdit.excel.maxbuffersize.label' => '缓冲区最大值',
    'OdbcEdit.excel.pagetimeout.label' => '页面超时',

    'OdbcEdit.access.driver.label' => '驱动程序',
    'OdbcEdit.access.dbq.label' => '数据库文件路径',
    'OdbcEdit.access.uid.label' => '登录 ID',
    'OdbcEdit.access.pwd.label' => '密码',
    'OdbcEdit.access.pagetimeout.label' => '页面超时',
    'OdbcEdit.access.pagetimeout.description' => '未使用页面在缓存中保留的时段以 0.1 秒计。该选项适用于所有使用 Microsoft Access 驱动程序的数据源。',
    'OdbcEdit.access.maxbuffersize.label' => '缓冲区最大值',
    'OdbcEdit.access.maxbuffersize.description' => '内部缓冲区的大小，以 KB 计，按 256 KB 的单位排列。',
    'OdbcEdit.access.readonly.label' => '只读',
    'OdbcEdit.access.readonly.description' => '将数据库指定为只读状态以禁止任何升级。',
    'OdbcEdit.access.exclusive.label' => '独占',
    'OdbcEdit.access.exclusive.description' => '将数据库指定为独占状态以禁止共享更新。',
    'OdbcEdit.access.safetransactions.label' => '安全交易',
    'OdbcEdit.access.safetransactions.description' => '如果是默认值 0，所有的事务会立即 commit。如果是 1，所有的事务会通过一次 commit 操作保存到硬盘，但是性能将会略微下降。',
    'OdbcEdit.access.threads.label' => '线程',
    'OdbcEdit.access.threads.description' => '引擎要使用的后台线程数量。',
    'OdbcEdit.access.maxscanrows.label' => '最大扫描行数',
    'OdbcEdit.access.maxscanrows.description' => '根据现有数据设置列的数据类型时，要扫描的行数。',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => '指定事务外部更改如何写入数据库中。',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => '指定 MS Access 驱动程序是否显式同步执行用户定义的事务。',

    'OdbcEdit.mssql.driver.label' => '驱动程序',
    'OdbcEdit.mssql.server.label' => '服务器',
    'OdbcEdit.mssql.uid.label' => '登录 ID',
    'OdbcEdit.mssql.pwd.label' => '密码',
    'OdbcEdit.mssql.database.label' => '默认数据库',
    'OdbcEdit.mssql.app.label' => '应用程序名称',
    'OdbcEdit.mssql.wsid.label' => '工作站ID',
    'OdbcEdit.mssql.language.label' => '默认语言',
    'OdbcEdit.mssql.oemtoansi.label' => '此参数指定了是否将扩展字符转换为OEM值',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC驱动程序',
    'OdbcEdit.mysql.server.label' => '服务器',
    'OdbcEdit.mysql.server.description' => 'MySQL服务器的主机名',
    'OdbcEdit.mysql.database.label' => '默认数据库',
    'OdbcEdit.mysql.user.label' => '用户名',
    'OdbcEdit.mysql.user.description' => '用于连接到MySQL的用户名',
    'OdbcEdit.mysql.password.label' => '密码',
    'OdbcEdit.mysql.password.description' => '服务器上的用户帐户密码',
    'OdbcEdit.mysql.port.label' => '端口',
    'OdbcEdit.mysql.port.description' => '如果服务器不是本地主机，则使用TCP/IP端口',
    'OdbcEdit.mysql.socket.label' => '套接字',
    'OdbcEdit.mysql.socket.description' => '如果服务器是本地主机，Windows将使用命名管道来连接',
    'OdbcEdit.mysql.option.label' => '选项',
    'OdbcEdit.mysql.option.description' => '指定 MyODBC 如何工作的选项。请参见<a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">文档</a>',

    'ProtectedDirectoryList.title' => '%%domainName%% 的受保护的目录',
    'ProtectedDirectoryList.add' => '添加受保护目录',
    'ProtectedDirectoryList.addTooltip' => '创建受保护目录。',
    'ProtectedDirectoryList.name' => '名称',
    'ProtectedDirectoryList.realmTitle' => '受保护区的标题',
    'ProtectedDirectoryList.noSelectionText' => '选择要移除的一个或多个项目。',
    'ProtectedDirectoryList.edit' => '编辑',
    'ProtectedDirectoryList.remove' => '移除受保护内容',
    'ProtectedDirectoryList.removeTooltip' => '移除所选目录的保护机制。',
    'ProtectedDirectoryList.removeConfirmation' => '此操作将导致移除对{count, plural, =1 {{name} 目录} other {# 选定目录}}的保护。{count, plural, =1 {该目录} other {这些目录}}将可供互联网用户自由访问。',
    'ProtectedDirectoryList.removeSuccess' => '选定目录已被移除。',

    'ProtectedDirectoryAdd.title' => '创建受保护目录',
    'ProtectedDirectoryAdd.submit' => '创建',
    'ProtectedDirectoryAdd.success' => '成功创建受保护目录%%path%%。',

    'ProtectedDirectoryEdit.title' => '受保护URL的设置',
    'ProtectedDirectoryEdit.success' => '已更改受保护目录设置',

    'SummaryReport.Layout.title' => '报告布局属性',
    'SummaryReport.Layout.success' => '报告布局 %%name%% 已更新。',

    'SummaryReport.Layout.Add.title' => '创建报告布局',
    'SummaryReport.Layout.Add.success' => '报告布局 %%name%% 已创建。',
];