<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Proprietățile cheii suplimentare',
    'additional-key-info.update' => 'Obținere cheie suplimentară',
    'additional-key-info.updateDescription' => 'Obținerea cheii suplimentare și instalarea acesteia.',
    'additional-key-info.download' => 'Descărcare cheie',
    'additional-key-info.downloadDescription' => 'Descărcarea cheii de licență curente.',
    'additional-key-info.install' => 'Instalare cheie',
    'additional-key-info.installDescription' => 'Instalarea cheii de licență curente.',
    'additional-key-info.revert' => 'Anularea înregistrării cheii',
    'additional-key-info.revertDescription' => 'Revenire la cheia de licență instalată anterior.',
    'additional-key-info.revertNotAvailableDescription' => 'Nicio cheie instalată.',
    'additional-key-info.installSuccess' => 'Instalarea cheii de licență a început.',

    'additional-key-revert.title' => 'Revenire la o variantă anterioară a cheii suplimentare',
    'additional-key-revert.success' => 'Cheia suplimentară a fost readusă la o variantă anterioară.',

    'additional-key-upload.title' => 'Instalare cheie de licență',
    'additional-key-upload.success' => 'Noua cheie suplimentară a fost încărcată.',

    'additional-keys.title' => 'Chei de licență suplimentare',

    'change-owner.title' => 'Reatribuirea abonamentelor selectate',

    'customers.hint' => 'Aici puteți administra conturile clienților de servicii de găzduire: creați conturi împreună cu abonamentele la servicii, administrați clienții existenți și ștergeți conturi. Pentru a administra site-urile, serviciile de e-mail sau de altă natură, furnizate unui client, accesați Panoul de client al acestuia: faceți clic pe linkul din coloana din dreapta a listei.',

    'customer-domains.hint' => 'Aici puteți crea și administra site-urile web.',

    'customer-subscriptions.hint' => 'Aici puteți administra abonamentele clientului.',

    'domains.hint' => 'Aici puteți vizualiza informații despre toate numele de domenii înregistrate în sistem și puteți trece la administrarea serviciilor de găzduire. Dacă doriți să adăugați un domeniu pentru uz propriu sau pentru găzduirea clienților, doar faceți clic pe Adăugare domeniu. În timpul creării domeniului vi se va solicita să creați un client nou și un abonament nou sau să selectați din listele celor existente.',

    'database-servers.title' => 'Servere de baze de date',

    'database-server-create.title' => 'Server de baze de date nou',

    'database-server-properties.title' => 'Server de baze de date',

    'database-server-upgrade.title' => 'Upgrade de server de baze de date',
    'database-server-upgrade.currentVersion' => 'Versiune curentă',
    'database-server-upgrade.selectVersion' => 'Selectare versiune',
    'database-server-upgrade.noMajorReleases' => 'Nu există versiuni majore',
    'database-server-upgrade.information' => 'Informații',
    'database-server-upgrade.releaseNotes' => 'Note despre versiune',
    'database-server-upgrade.releaseDate' => 'Data lansării',
    'database-server-upgrade.unable' => 'Imposibil de făcut upgrade',
    'database-server-upgrade.endOfLifeDate' => 'Data de sfârșit a ciclului de viață',
    'database-server-upgrade.withDump' => 'Se creează un dump cu bazele de date înainte de a actualiza',
    'database-server-upgrade.withDumpDescription' => 'Înainte de declanșarea procesului de upgrade se va crea un dump cu toate bazele de date găzduite pe server.',
    'database-server-upgrade.preUpgradeCheckers' => 'Vă rugăm să acordați atenție următoarelor informații',
    'database-server-upgrade.preUpgradeCheckersDescription' => 'Au fost depistate probleme. Bifați fiecare casetă de selectare de mai jos pentru a confirma faptul că înțelegeți acest lucru și că doriți să faceți upgrade.',
    'database-server-upgrade.preUpgradeCheckerShouldBeConfirmed' => 'Bifați toate casetele de selectare înainte de a trece la upgrade.',
    'database-server-upgrade.preUpgradeCheckerNotDetected' => 'Upgrade-ul este posibil numai în cazul variantelor de MariaDB livrate de furnizorii de sisteme de operare sau de furnizorul MariaDB.',
    'database-server-upgrade.sshAccess' => 'Asigurați-vă că puteți accesa serverul prin SSH',
    'database-server-upgrade.sshAccessDescription' => 'Utilizați un client SSH sau deschideți %%sshTerminalExtension%% într-o filă de browser nouă (nu închideți fereastra extensiei de terminal SSH până când nu se termină procesul de upgrade). Dacă upgrade-ul nu reușește, accesul prin SSH va fi util pentru repunerea în funcțiune a sistemului.',
    'database-server-upgrade.sshTerminalExtension' => 'Extensie Terminal SSH',
    'database-server-upgrade.repairKitAccess' => 'Asigurați-vă că aveți acces la Repair Kit',
    'database-server-upgrade.repairKitAccessDescription' => 'Deschideți %%repairKit%% într-o filă de browser nouă și conectați-vă cu acreditări de administrator. Nu închideți fereastra de Repair Kit până când nu se termină upgrade-ul.',
    'database-server-upgrade.repairKit' => 'Repair Kit',
    'database-server-upgrade.troubleshootingArticle' => 'articolul din KB',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Urmați indicațiile din %%troubleshootingArticle%% pentru a depana upgrade-ul de MariaDB.',
    'database-server-upgrade.removedSystemVariables' => 'Pentru a asigura compatibilitatea cu noua versiune, se vor elimina următoarele variabile:',
    'database-server-upgrade.webSocketNotAvailable' => 'WebSocket nu este disponibil în Plesk',
    'database-server-upgrade.webSocketNotAvailableDescription' => 'Fără WebSocket nu veți putea vedea în timp real rezultatele procesului de upgrade.',
    'database-server-upgrade.checkConsistency' => 'Raport creat de instrumentul mariadb-check',
    'database-server-upgrade.checkConsistencyDescription' => 'Instrumentul mariadb-check a detectat una sau mai multe probleme.',
    'database-server-upgrade.chooseReleaseStep' => 'Pasul 1: Versiunile disponibile',
    'database-server-upgrade.preUpgradeStep' => 'Pasul 2: Verificări premergătoare upgrade-ului',
    'database-server-upgrade.upgradeStep' => 'Pasul 3: Upgrade',
    'database-server-upgrade.fromFiles' => '{variable} din {count, plural, one {fișierul {files}} few {cele # fișiere: {files}} other {cele # de fișiere: {files}}}',
    'database-server-upgrade.description' => 'MySQL/MariaDB este un sistem de gestiune a bazelor de date relaționale foarte răspândit. Pe majoritatea sistemelor Plesk este un serviciu esențial. Această interfață vă permite să faceți upgrade la versiunea 10.11 a serverului de MySQL/MariaDB. Plesk va face automat upgrade-urile instalării de MySQL/MariaDB la noile versiuni minore (a treia cifră din indicativul versiunii) întrucât aceste upgrade-uri nu prezintă riscuri majore pentru datele utilizatorilor. Upgrade-urile la versiuni majore (primele două cifre ale indicativului) necesită mai multă interacțiune, deoarece prezintă riscuri semnificative de pierdere a datelor. Această interfață încearcă să vă ghideze în procesul de upgrade la o versiune majoră.',
    'database-server-upgrade.warning' => 'De obicei, upgrade-urile sistemelor instalate nu prezintă riscuri, dar se recomandă crearea unei copii de rezervă complete a bazei de date înainte de a face upgrade. Nu se poate face downgrade la o versiune anterioară. Revenirea la o versiune anterioară după un upgrade de server de baze de date este imposibilă. Înlocuirea MariaDB cu MySQL 8 este considerată downgrade și nu este acceptată.',

    'database-server-databases.title' => 'Baze de date',

    'database-server-change-password.title' => 'Parolă administrator',

    'home.title' => 'Pagina de pornire',

    'license.title' => 'Informații despre licență',

    'primary-key-info.title' => 'Cheie de licență Plesk',
    'primary-key-info.update' => 'Obținere chei',
    'primary-key-info.updateDescription' => 'Preluarea cheilor de licență comandate și instalarea acestora.',
    'primary-key-info.upload' => 'Instalare cheie',
    'primary-key-info.uploadDescription' => 'Încărcarea și instalarea unei chei de licență noi.',
    'primary-key-info.revert' => 'Anularea înregistrării cheii',
    'primary-key-info.revertDescription' => 'Revenire la cheia de licență instalată anterior.',

    'primary-key-revert.title' => 'Anularea înregistrării cheii',
    'primary-key-revert.success' => 'Cheia Plesk a fost readusă la o variantă anterioară.',

    'primary-key-upload.title' => 'Instalare cheie de licență',
    'primary-key-upload.success' => 'Noua cheie Plesk a fost încărcată.',

    'resellers.hint' => 'Aici puteți administra conturile de reseller – clienții care revând serviciile de găzduire și găzduiesc propriile site-uri web. Aici puteți să creați conturi împreună cu abonamente la servicii, să administrați clienții existenți și să ștergeți conturi.',

    'reseller-customers.hint' => 'Aici puteți crea și administra clienții.',

    'reseller-domains.hint' => 'Aici puteți crea și administra site-urile web.',

    'reseller-subscriptions.hint' => 'Aici puteți administra abonamentele resellerului.',

    'subscriptions.hint' => 'Clienți pot beneficia de serviciile de găzduire pe care le oferiți prin abonarea la un plan de găzduire. Aici puteți administra abonamentele respective, dar și cele proprii, pe care le creați pentru a găzdui propriile site-uri. Pentru a administra site-urile, serviciile de e-mail sau de altă natură, furnizate cu un abonament, accesați Panoul de client al abonatului: faceți clic pe linkul din coloana din dreapta a listei.',

    'server-mail-settings.title' => 'Setări',
    'server-mail-spam-filter.title' => 'Filtrare antispam',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Listă de interdicții',
    'server-mail-white-list.title' => 'Listă de permisiuni',
    'server-mail-queue.title' => 'Coadă de e-mail',
    'server-mail-statistics.title' => 'Statistici',

    'server-spam-filter.title' => 'Setările filtrului antispam',
    'server-spam-filter.settings' => 'Setări',
    'server-spam-filter.black-list' => 'Listă de interdicții',
    'server-spam-filter.white-list' => 'Listă de permisiuni',

    'firewall.title' => 'Administrare firewall',
    'firewall-general.title' => 'General',
    'firewall-general.toggleStatus' => 'Protecție firewall',
    'firewall-general.buttonDefault' => 'Resetare la valoarea implicită',
    'firewall-general.buttonPanic' => 'Modul Panică',
    'firewall-general.confirmationDefault' => 'Readuceți setările de firewall la valorile implicite?',
    'firewall-general.confirmationPanic' => 'Activați modul Panică? Utilizatorii nu își vor putea accesa domeniile și este posibil ca unele servicii de rețea să înceteze să funcționeze.',
    'firewall-general.successDefault' => 'Setările de firewall au fost readuse la valorile implicite.',
    'firewall-general.successPanic' => 'Modul de panică a fost activat.',
    'firewall-general.info' => 'Din motive de securitate, firewallul blochează toate conexiunile, cu excepția celor permise explicit. Acum puteți permite conectarea prin crearea unei reguli. Pentru informații suplimentare, consultați documentația',
    'firewall-general.interfaces' => 'Interfețe de rețea',
    'firewall-icmp.title' => 'Protocol ICMP',
    'firewall-rules.title' => 'Reguli de firewall',

    'dns.title' => 'Setări DNS',
    'dns-records.title' => 'Șablon de înregistrare de zonă',
    'dns-soa-record.title' => 'Șablon setări de zonă',

    'php-handler.title' => 'Setări pentru %%name%%',
    'php-handler.extensions.title' => 'Extensii',
    'php-handler.extensions.description' => 'Aceste setări de extensie PHP sunt destinate numai acestui handler.',
    'php-handler.extensions.descriptionShared' => 'Aceste setări sunt comune următoarelor handlere PHP: %%handlers%%. Setările sunt valabile pentru toate site-urile web care utilizează aceste handlere.',
    'php-handler.extensions.buttonManage' => 'Administrarea pachetelor PECL',
    'php-handler.extensions.manage.title' => 'Administrarea pachetelor PECL',
    'php-handler.extensions.manage.risks' => 'Extensiile PHP sunt furnizate de pachete PECL terță parte. Instalați-le pe proprie răspundere.',
    'php-handler.extensions.manage.description' => 'Instalarea, upgrade-ul și dezinstalarea de pachete PECL. Modificările se vor face pe toate site-urile care se execută pe %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'De ce nu apare în listă pachetul dorit?',
    'php-handler.extensions.manage.limitations' => 'Extensiile PHP furnizate de furnizorul panoului de control și de furnizorii de SO nu apar în listă.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "Informații server",
    'ServerInformation.refresh' => "Reîmprospătare",
    'ServerInformation.sectionGeneral' => "General",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Versiune",
    'ServerInformation.os' => "Sistem de operare",
    'ServerInformation.key' => "Cheie de licență Plesk",
    'ServerInformation.uptime' => "Timp de funcționare",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# zi} few {# zile} other {# de zile}} {hours, plural, one {# oră} few {# ore} other {# de ore}} {minutes, plural, one {# minut} few {# minute} other {# de minute}}",
    'ServerInformation.sectionCpu' => "Utilizare CPU",
    'ServerInformation.la1min' => "Ultimul minut",
    'ServerInformation.la5min' => "Ultimele 5 minute",
    'ServerInformation.la15min' => "Ultimele 15 minute",
    'ServerInformation.sectionMemory' => "Utilizare memorie",
    'ServerInformation.memoryTotal' => "Total",
    'ServerInformation.memoryUsed' => "Utilizat",
    'ServerInformation.memoryFree' => "Gratuit",
    'ServerInformation.memoryShared' => "Partajat",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Cache",
    'ServerInformation.memoryAvailable' => "Disponibil",
    'ServerInformation.memoryUsage' => "Utilizare",
    'ServerInformation.sectionSwap' => "Utilizare swap",
    'ServerInformation.sectionVirtualMemory' => "Utilizare memorie virtuală",
    'ServerInformation.swapTotal' => "Total",
    'ServerInformation.swapUsed' => "Utilizat",
    'ServerInformation.swapFree' => "Gratuit",
    'ServerInformation.swapUsage' => "Utilizare",
    'ServerInformation.sectionHarddisk' => "Utilizare hard disk",
    'ServerInformation.harddiskDirectory' => "Sistem de fișiere",
    'ServerInformation.harddiskProtectedDir' => "Directoare protejate",
    'ServerInformation.harddiskTotal' => "Total",
    'ServerInformation.harddiskUsed' => "Utilizat",
    'ServerInformation.harddiskAvailable' => "Disponibil",
    'ServerInformation.harddiskCapacity' => "Capacitate",
    'ServerInformation.sectionDomains' => "Domenii",
    'ServerInformation.activeDomains' => "Activ",
    'ServerInformation.inactiveDomains' => "Inactiv",
    'ServerInformation.problemDomains' => "Probleme",
    'ServerInformation.refreshed' => "Informațiile au fost împrospătate.",

    'ServerAbout.title' => 'Despre Plesk',
    'ServerAbout.copyright' => '© 2023 Plesk International GmbH. Toate drepturile rezervate.',
    'ServerAbout.linkLicenseManagement' => 'Accesarea Informațiilor despre licență',
    'ServerAbout.panelVersion' => 'Versiune',
    'ServerAbout.installedPatchVersion' => 'Actualizarea #%%patch%%',
    'ServerAbout.licenseKey' => 'Cheie de licență',
    'ServerAbout.productDescription' => 'Plesk este lider în domeniul platformelor WebOps. Permite executarea, automatizarea și creșterea aplicațiilor, ale site-urilor web și ale firmelor de găzduire.',
    'ServerAbout.readEula' => 'Citiți %%link%%.',
    'ServerAbout.linkEula' => 'Acord de licență cu utilizatorul final',
    'ServerAbout.visitForum' => 'Vizitați %%link%%.',
    'ServerAbout.linkForum' => 'Forum Plesk',
    'ServerAbout.followUs' => 'Urmăriți-ne',
    'ServerAbout.visitSite' => 'Aflați mai multe la %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Găsiți inspirație %%link%%',
    'ServerAbout.linkBlog' => 'Blog Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Felicitări!',
    'ServerAbout.darkThemePromoDescription' => 'Ați găsit pisica fermecată adăugată în versiunea aniversară Plesk Obsidian 18.0.50.',
    'ServerAbout.darkThemePromoButton' => 'Treceți de partea întunericului',
    'ServerAbout.darkThemeTourDescription' => 'Comutați această opțiune pentru a activa sau a dezactiva tema întunecată în interfață.',
    'ServerAbout.darkThemeTourButton' => 'Am înțeles',

    'ts-sessions.title' => 'Sesiune Terminal Server',
    'ts-sessions-properties.title' => 'Proprietățile sesiunii',

    'BandwidthLimiting.title' => 'Limitare de lățime bandă pentru %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Nu puteți controla utilizarea lățimii de bandă pentru că nu este instalat QoS.',
    'BandwidthLimiting.virtualHostingRequired' => 'Limitarea de lățime de bandă este disponibilă numai în cazul domeniilor cu găzduire web.',
    'BandwidthLimiting.bandwidthLabel' => 'Limită maximă de utilizare a lățimii de bandă',
    'BandwidthLimiting.bandwidthHint' => 'Limita de utilizare a lățimii de bandă se aplică doar la datele transferate prin protocolul HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Conexiuni limitate la',
    'BandwidthLimiting.maxConnectionHint' => 'Dacă limitați lățimea de bandă, vă recomandăm să limitați și numărul de conexiuni simultane la site. În caz contrar, dacă se trimit frecvent solicitări către site, procesele de server web vor crește încărcarea serverului.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Setările de limitare a lățimii de bandă au fost modificate.',
    'BandwidthLimiting.unlimited' => 'Nelimitat',

    'ip-address-domains.title' => 'Site-uri web care utilizează adresa IP %%type%% %%ipAddress%%',
    'ip-address-domains.site' => 'Site',
    'ip-address-domains.setAsDefault' => 'Setare ca valoare implicită',
    'ip-address-domains.type-SHARED' => 'partajată',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicată',

    'HotlinkProtection.title' => 'Protecție hotlink pentru %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'Protecția hotlink este disponibilă numai în cazul domeniilor cu găzduire web.',
    'HotlinkProtection.enabledLabel' => 'Activarea protecției de hotlink',
    'HotlinkProtection.extensionsLabel' => 'Extensii de fișiere protejate',
    'HotlinkProtection.friendsLabel' => 'Adresele site-urilor web prietenoase',
    'HotlinkProtection.success' => 'Setările de protecție hotlink au fost modificate.',

    'Odbc.serverTitle' => 'Conexiuni DSN ODBC',
    'Odbc.domainTitle' => 'Conexiuni DSN ODBC pentru %%domainName%%',
    'Odbc.add' => 'Adăugare DSN ODBC',
    'Odbc.resourceUsage' => '%%used%% creat / %%allowed%% permis.',
    'Odbc.limitExceeded' => 'Plafonul de conexiuni DSN ODBC a fost depășit.',
    'Odbc.unlimited' => 'Nelimitat',
    'Odbc.addTooltip' => 'Adăugarea unei surse de date ODBC.',
    'Odbc.status' => 'Stare',
    'Odbc.name' => 'Nume conexiune',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Descrierea conexiunii',
    'Odbc.hostname' => 'Nume gazdă',
    'Odbc.statusSystem' => 'Este un DSN sistem.',
    'Odbc.statusConfigured' => 'DSN-ul este configurat.',
    'Odbc.statusNotConfigured' => 'DSN-ul nu este configurat.',
    'Odbc.noSelectionText' => 'Selectați unu sau mai multe elemente de eliminat.',
    'Odbc.removeConfirmation' => 'Ștergeți {count, plural, one {} few {cele # conexiuni selectate}=1 {conexiunea {name}} other {cele # de conexiuni selectate}}?',
    'Odbc.removeSuccess' => 'Conexiunile selectate au fost șterse.',

    'DomainAliasSettings.title' => 'Setări de alias de domeniu',
    'DomainAliasSettings.updateSuccess' => 'Proprietățile aliasului de domeniu %%name%% s-au schimbat. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Setările site-ului web vor fi aplicate în %%restartInterval%% minute.',

    'HostingSettings.title' => 'Setări de găzduire',
    'HostingSettings.updateSuccess' => 'Setările au fost actualizate.',
    'HostingSettings.emptyLogin' => 'Trebuie să specificați un nume de utilizator.',
    'HostingSettings.emptyPassword' => 'Trebuie să specificați o parolă.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Serverul FTP nu acceptă adresele IPv6. Trebuie să alocați cel puțin o adresă IPv4. În caz contrar, nu veți putea încărca fișierele pe server prin FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Setări de domeniu',
    'HostingSettings.domainSettingsSection.domainName' => 'Nume domeniu',
    'HostingSettings.domainSettingsSection.description' => 'De exemplu, exemplu.com ',

    'HostingSettings.submitPopover.title' => 'Eliminarea conținutului %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Schimbarea tipului de găzduire „Site web” în „%%type%%” va duce la ștergerea definitivă a întregului conținut al site-ului, inclusiv a următoarelor directoare:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Modificați tipul de găzduire al acestui site?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Pentru a accesa mai multe setări, introduceți acreditările utilizatorului de sistem, apoi faceți clic pe „Creare spațiu web”.',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Dacă doriți să accesați mai multe setări, faceți clic pe „Următorul” ca să creați găzduirea.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Tip găzduire',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tip',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Site',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Redirecționare',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Fără găzduire web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Utilizați zona DNS a domeniului pentru a putea avea căsuțe poștale cu acest nume de domeniu',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Calea către directorul de pornire al site-ului',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Domeniu preferat',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Vizitatorii vor fi redirecționați cu HTTP 301, compatibil cu SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Redirecționare vizitatori la',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Tip de redirecționare',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Mutat definitiv (cod 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Vizitatorii sunt redirecționați către un alt site și li se arată adresa destinație. O asemenea redirecționare păstrează locul site-ului în clasamentul de motor de căutare',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Mutat temporar (cod 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Vizitatorii site-ului sunt redirecționați către o copie temporară a site-ului, în cazul în care nu doriți ca motoarele de căutare să indexeze site-ul temporar respectiv.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Redirecționare cu cadre',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Vizitatorii sunt redirecționați către un alt site, dar nu li se arată adresa destinație, deci nu află despre redirecționare.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Domeniu preferat',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Fără',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Rădăcina de documente',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Imposibil de modificat directorul rădăcină de documente, pentru că există aplicații web instalate pe site.',
    'HostingSettings.domainSettingsSection.save' => 'Salvare',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Modificați această setare?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Modificarea acestei setări contrazice politica de securitate a serverului și poate afecta performanțele serverului sau îl poate face vulnerabil la atacuri.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Modificare',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Restabilire',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Presetarea de setări securizate a fost aplicată',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Pentru o securitate mai bună, aplicați presetarea de setări de securitate. Rețineți: dacă au anumite permisiuni, abonații pot modifica aceste setări.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Aplicare presetare de securitate',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Informații despre setările de securitate pentru găzduire',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Suport SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Activat',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Criptarea conexiunilor între site-ul web și browserul utilizatorului.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Pentru a activa HTTPS, încărcați un certificat SSL/TLS în depozitul domeniului, apoi selectați-l aici.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redirecționarea vizitatorilor de la HTTP la HTTPS printr-o redirecționare 301 compatibilă cu SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'În depozit nu există certificate SSL/TLS. Pentru a adăuga un certificat, accesați %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'această pagină',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (alt depozit)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Neselectat',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Scripturi Web',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Selectați limbajele de programare și de scripturi care trebuie să fie interpretate de serverul web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'directorul cgi-bin se află în %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Pentru fișierele *.htm, *.html se utilizează SSI',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versiune Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documente de eroare personalizate',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'directorul cgi-bin se află în',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'rădăcina de documente a acestui domeniu',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'directorul rădăcină al spațiului web',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'rădăcina de tip vechi a acestui domeniu',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documente de eroare personalizate',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Permisiuni de scriere/modificare suplimentare',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publicare Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Statistici web',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Instrument',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Accesul la statisticile web se face cu numele de utilizator FTP și cu parola corespunzătoare',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Dezactivat',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Setări de spațiu web',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Adrese IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Cotă spațiu pe disc',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Activat',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'La depășirea cotei de spațiu pe disc stabilite în setările abonamentului (dacă este cazul) se interzic operațiile cu fișierele site-ului.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Configurația sistemului de fișiere de pe server nu permite utilizarea cotelor de hard disc.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Acreditările utilizatorului de sistem',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gestionarea fișierelor și a folderelor site-ului prin FTP sau Manager de fișiere. Dacă se permite acest lucru, serverul poate fi accesa prin SSH.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gestionarea fișierelor și a folderelor site-ului prin FTP sau Manager de fișiere. Dacă se permite acest lucru, serverul poate fi accesa prin Desktop la distanță.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nume utilizator',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Parolă',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Specificați aici o nouă parolă, pentru a schimba parola utilizatorului de sistem.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Acces SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Acces prin Desktop la distanță',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Activat',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Accesați serverul cu acreditările utilizatorului de sistem.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tip',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Dezactivat',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Pentru {count, plural, one {} few {# domenii} other {# de domenii}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Următoarele setări sunt comune pentru toate cele {count, plural, one {} few {# domenii din spațiul web {name}} other {# de domenii din spațiul web {name}}}:',

    'OdbcAdd.title' => 'Adăugare DSN ODBC',
    'OdbcAdd.nameLabel' => 'Nume conexiune',
    'OdbcAdd.descriptionLabel' => 'Descrierea conexiunii',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Creare DSN ODBC',

    'OdbcEdit.title' => 'Configurarea unei conexiuni ODBC',
    'OdbcEdit.saveSuccess' => 'Setările de conexiune au fost salvate.',
    'OdbcEdit.test' => 'Testarea conexiunii',
    'OdbcEdit.connectSuccess' => 'Conectare reușită.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Cale fișier bază de date',
    'OdbcEdit.excel.defaultdir.label' => 'Director de date implicit',
    'OdbcEdit.excel.fil.label' => 'Versiune bază de date',
    'OdbcEdit.excel.maxbuffersize.label' => 'Dimensiune maximă buffer',
    'OdbcEdit.excel.pagetimeout.label' => 'Expirare pagină',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Cale fișier bază de date',
    'OdbcEdit.access.uid.label' => 'ID de conectare',
    'OdbcEdit.access.pwd.label' => 'Parolă',
    'OdbcEdit.access.pagetimeout.label' => 'Expirare pagină',
    'OdbcEdit.access.pagetimeout.description' => 'Perioada, exprimată în zecimi de secundă, de păstrare a unei pagini nefolosite în buffer. Această opțiune este valabilă pentru toate sursele de date care utilizează driverul Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Dimensiune maximă buffer',
    'OdbcEdit.access.maxbuffersize.description' => 'Dimensiunea bufferului intern, exprimată în KB, se aliniază la 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Doar în citire',
    'OdbcEdit.access.readonly.description' => 'Setarea bazei de date drept „doar în citire” pentru a împiedica toate actualizările.',
    'OdbcEdit.access.exclusive.label' => 'Exclusiv',
    'OdbcEdit.access.exclusive.description' => 'Setarea bazei de date drept exclusivă pentru a împiedica actualizările partajate.',
    'OdbcEdit.access.safetransactions.label' => 'Tranzacții sigure',
    'OdbcEdit.access.safetransactions.description' => 'Dacă opțiunea este setată la 0 (setarea implicită), salvarea definitivă a tuturor tranzacțiilor se face imediat. Dacă este setată la 1, salvarea definitivă a tranzacțiilor se face numai la operația de COMMIT, dar performanțele vor fi ușor mai slabe.',
    'OdbcEdit.access.threads.label' => 'Fire de execuție',
    'OdbcEdit.access.threads.description' => 'Numărul de fire de execuție în fundal pe care le va utiliza motorul de bază de date.',
    'OdbcEdit.access.maxscanrows.label' => 'Număr maxim de rânduri de scanat',
    'OdbcEdit.access.maxscanrows.description' => 'Numărul de rânduri de scanat la setarea tipului de dată al coloanei în funcție de datele existente.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Specifică modul în care se scriu în baza de date modificările făcute în afara unei tranzacții.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Stabilește dacă driverul MS Access execută în mod asincron tranzacțiile definite explicit de utilizator.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'ID de conectare',
    'OdbcEdit.mssql.pwd.label' => 'Parolă',
    'OdbcEdit.mssql.database.label' => 'Bază de date implicită',
    'OdbcEdit.mssql.app.label' => 'Nume aplicație',
    'OdbcEdit.mssql.wsid.label' => 'ID stație de lucru',
    'OdbcEdit.mssql.language.label' => 'Limba implicită',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversia caracterelor extinse în valori OEM',

    'OdbcEdit.mysql.driver.label' => 'Driver ODBC MySQL',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Numele de gazdă al serverului MySQL',
    'OdbcEdit.mysql.database.label' => 'Bază de date implicită',
    'OdbcEdit.mysql.user.label' => 'Nume utilizator',
    'OdbcEdit.mysql.user.description' => 'Numele de utilizator utilizat pentru conectarea la MySQL',
    'OdbcEdit.mysql.password.label' => 'Parolă',
    'OdbcEdit.mysql.password.description' => 'Parola contului de utilizator pe server',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Portul TCP/IP de utilizat dacă serverul nu este gazda locală',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Conductă denumită Windows pentru conectare în cazul în care serverul este gazda locală',
    'OdbcEdit.mysql.option.label' => 'Opțiune',
    'OdbcEdit.mysql.option.description' => 'Opțiunile care specifică modul de funcționare a MyODBC. Afișare <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentație</a>',

    'ProtectedDirectoryList.title' => 'Directoare protejate ale %%domainName%%',
    'ProtectedDirectoryList.add' => 'Adăugare director protejat',
    'ProtectedDirectoryList.addTooltip' => 'Crearea unui director protejat.',
    'ProtectedDirectoryList.name' => 'Nume',
    'ProtectedDirectoryList.realmTitle' => 'Titlul zonei protejate',
    'ProtectedDirectoryList.noSelectionText' => 'Selectați unu sau mai multe elemente de eliminat.',
    'ProtectedDirectoryList.edit' => 'Editare',
    'ProtectedDirectoryList.remove' => 'Ștergere protecție',
    'ProtectedDirectoryList.removeTooltip' => 'Eliminarea protecției directoarelor selectate.',
    'ProtectedDirectoryList.removeConfirmation' => 'Această operație duce la eliminarea protecției {count, plural, =1 {directorului {name}} other {celor # directoare selectate}}. {count, plural, =1 {Acest director va deveni accesibil} other {Directoarele respective vor deveni accesibile}} fără restricții pentru utilizatorii de internet.',
    'ProtectedDirectoryList.removeSuccess' => 'Directoarele selectate au fost eliminate.',

    'ProtectedDirectoryAdd.title' => 'Crearea unui director protejat',
    'ProtectedDirectoryAdd.submit' => 'Creare',
    'ProtectedDirectoryAdd.success' => 'Directorul protejat %%path%% a fost creat cu succes',

    'ProtectedDirectoryEdit.title' => 'Setări de director protejat',
    'ProtectedDirectoryEdit.success' => 'Setările directorului protejat au fost modificate',

    'ProtectedDirectoryUserList.title' => 'Utilizatorii directorului protejat %%directory%%',
    'ProtectedDirectoryUserList.add' => 'Adăugare utilizator',
    'ProtectedDirectoryUserList.addTooltip' => 'Creare de conturi de utilizator care să aibă acces la directorul protejat %%directory%%',
    'ProtectedDirectoryUserList.login' => 'Nume',
    'ProtectedDirectoryUserList.changePassword' => 'Schimbare parolă',
    'ProtectedDirectoryUserList.noSelectionText' => 'Selectați unu sau mai mulți utilizatori de eliminat.',
    'ProtectedDirectoryUserList.remove' => 'Ștergere',
    'ProtectedDirectoryUserList.removeTooltip' => 'Ștergerea utilizatorilor selectați.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Ștergeți {count, plural, one {} few {cei # utilizatori selectați} =1 {utilizatorul {login}} other {cei # de utilizatori selectați}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'Utilizatorii selectați au fost eliminați.',

    'ProtectedDirectoryUserAdd.title' => 'Creare utilizator de director protejat',
    'ProtectedDirectoryUserAdd.subtitle' => 'Directorul %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Nume utilizator',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Parolă',
    'ProtectedDirectoryUserAdd.submit' => 'Creare',
    'ProtectedDirectoryUserAdd.success' => 'Utilizatorul de director protejat %%login%% a fost creat.',

    'ProtectedDirectoryUserPassword.title' => 'Parolă utilizator director protejat',
    'ProtectedDirectoryUserPassword.subtitle' => 'Utilizatorul %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Parolă',
    'ProtectedDirectoryUserPassword.submit' => 'Salvare',
    'ProtectedDirectoryUserPassword.success' => 'Acreditările utilizatorului au fost salvate.',

    'SummaryReport.Layout.title' => 'Proprietățile aspectului de raport',
    'SummaryReport.Layout.success' => 'Aspectul de raport %%name%% a fost actualizat.',
    'SummaryReport.Layouts.title' => 'Aspecte de raport',

    'SummaryReport.Layout.Add.title' => 'Creare aspect de raport',
    'SummaryReport.Layout.Add.success' => 'Aspectul de raport %%name%% a fost creat.',

    'SummaryReport.Report.title' => 'Raport rezumat',
    'SummaryReport.Report.buttonLayouts' => 'Aspecte',
    'SummaryReport.Report.buttonSchedule' => 'Program',
    'SummaryReport.Report.buttonProperties' => 'Proprietăți',
    'SummaryReport.Report.buttonTrafficHistory' => 'Istoric de trafic',
    'SummaryReport.Report.buttonPrint' => 'Imprimare',
    'SummaryReport.Report.buttonSend' => 'Trimitere prin e-mail',
    'SummaryReport.Report.successSent' => 'Raportul a fost trimis la %%email%%',

    'SummaryReport.Schedule.title' => 'Programări de livrare pentru %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Programare de livrare pentru %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Planul de trimitere a rapoartelor a fost actualizat.',

    'SummaryReport.Schedule.Add.title' => 'Creare programări de livrare pentru %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Planul de trimitere a rapoartelor a fost creat.',

    'SummaryReport.TrafficHistory.title' => 'Istoric de trafic',
];