<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Subrețea sau adresă IP',
    'access-network.subnetOrIpAddressHint' => 'De exemplu, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Buletine informative',
    'admin.announcement-settings.getConsentLoading' => 'Se preiau informațiile despre buletinele informative...',
    'admin.announcement-settings.getConsentWarning' => 'Imposibil de determinat starea abonamentului.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Doresc să primesc buletine informative de la Plesk. Acestea pot conține informații despre securitate, date tehnice și informații generale despre produse. Sunt de acord și autorizez Plesk să colecteze, să proceseze și să utilizeze datele mele personale (adresa de e-mail), inclusiv în străinătate, conform legislației în vigoare privind protecția datelor pentru a-mi trimite buletine informative, fie direct, fie printr-un serviciu terță parte. Debifarea acestei casete de selectare revocă prezentul consimțământ și ordonă Plesk să înceteze să-mi trimită e-mailuri și să-mi șteargă definitiv datele personale din sistemele sale.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Da, vreau să primesc buletinul informativ personalizat Plesk. WebPros International GmbH și firmele afiliate pot stoca și procesa datele pe care le comunic, pentru a-mi trimite buletinul informativ, în condițiile stabilite prin %%privacyPolicy%%. Pentru a-și adapta mesajele și ofertele la necesitățile mele, Plesk poate folosi și informații suplimentare în vederea creării unui profil, cum ar fi datele despre modul în care folosesc sistemul și despre acțiunile mele. Pot anula oricând abonamentul la listele de corespondență.',
    'admin.announcement-settings.privacyPolicy' => 'Politica de confidențialitate WebPros',
    'admin.announcement-settings.noConsent' => 'Doresc să-mi anulez abonamentul la buletinul informativ Plesk.',
    'admin.announcement-settings.reportConsentError' => 'Nu a reușit salvarea setărilor de primire a informațiilor din Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'În acest moment nu vă putem actualiza profilul. Încercați din nou mai târziu.',
    'admin.announcement-settings.invalidConsentType' => "Tip de consimțământ necunoscut: „%%type%%”",
    'admin.announcement-settings.retry' => 'Reîncercare',
    'admin.announcement-settings.consentGivenInfo' => 'Sperăm că vă place buletinul informativ generic Plesk. Acum vă putem oferi o variantă mai bună: un buletin informativ personalizat, cu informații și sfaturi adaptate nevoilor dvs. Pentru a primi buletinul informativ personalizat Plesk, alegeți prima variantă de mai jos și faceți clic pe OK.',
    'admin.announcement-settings.consentNotGivenInfo' => 'Se pare că nu v-ați abonat la buletinul informativ generic. Vă putem oferi o variantă mai bună: un buletin informativ personalizat, cu informații și sfaturi adaptate nevoilor dvs.',

    'admin.personal-info.title' => 'Editarea profilului de administrator',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Setări Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Setări',

    'admin-alias.login' => 'Nume utilizator',
    'admin-alias.password' => 'Parolă',
    'admin-alias.passwordConfirmation' => 'Confirmare parolă',
    'admin-alias.email' => 'E-mail',
    'admin-alias.contact' => 'Nume contact',
    'admin-alias.comments' => 'Comentarii',
    'admin-alias.emptyLogin' => 'Introduceți un nume de utilizator.',
    'admin-alias.loginTooLong' => 'Lungimea numelui de utilizator depășește 20 de caractere.',
    'admin-alias.emptyEmail' => 'Introduceți o adresă de e-mail.',
    'admin-alias.emptyContactName' => 'Introduceți un nume de contact.',
    'admin-alias.contactNameTooLong' => 'Lungimea numelui contactului depășește 255 de simboluri.',
    'admin-alias.emptyPassword' => 'Introduceți parola.',
    'admin-alias.commentsTooLong' => 'Lungimea comentariului depășește 255 de simboluri.',
    'admin-alias.emailActivation' => 'Activare cont prin e-mail',
    'admin-alias.simplePanel' => 'Activarea modului Restricționat',
    'admin-alias.simplePanelHint' => 'Selectați această opțiune pentru a limita numărul de acțiuni pe care le poate executa administratorul suplimentar în Plesk. Pentru a modifica acțiunile disponibile, accesați %%link%%.',
    'admin-alias.simplePanelLink' => 'Instrumente și setări> Setările modului restricționat',
    'admin-alias.lockPowerUser' => 'Forțarea vizualizării de utilizator privilegiat pentru administratorul suplimentar',
    'admin-alias.lockPowerUserHint' => 'Posibilitatea de a restricționa vizualizarea la care are acces administratorul Plesk suplimentar (fără acces la clienți, reselleri și planuri de servicii).',

    'admin-info.plesk-settings.multiplyLogin' => 'Se acceptă mai multe sesiuni în acest cont',
    'admin-info.plesk-settings.adminLanguage' => 'Limba interfeței administratorului',
    'admin-info.plesk-settings.password' => 'Parolă',
    'admin-info.plesk-settings.passwordConfirmation' => 'Confirmare parolă',
    'admin-info.plesk-settings.oldPassword' => 'Parola veche',
    'admin-info.plesk-settings.oldPasswordIsIncorrect' => 'Parola veche este incorectă. Încercați mai nou.',

    'admin-panel.form.contact-info.login' => 'Conectare',
    'admin-panel.form.contact-info.contactName' => 'Nume contact',
    'admin-panel.form.contact-info.emptyLogin' => 'Introduceți un nume de conectare.',
    'admin-panel.form.contact-info.emptyContactName' => 'Introduceți un nume de contact.',
    'admin-panel.form.contact-info.loginTooLong' => 'Numele de conectare este prea lung (se acceptă cel mult %max% simboluri).',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Numele de contact este prea lung (se acceptă cel mult %max% simboluri).',
    'admin-panel.form.contact-info.email' => 'Adresă e-mail',
    'admin-panel.form.contact-info.emptyEmail' => 'Introduceți o adresă de e-mail.',
    'admin-panel.form.contact-info.companyName' => 'Nume companie',
    'admin-panel.form.contact-info.longCompanyName' => 'Numele de firmă este prea lung (se acceptă cel mult %max% simboluri).',
    'admin-panel.form.contact-info.phone' => 'Număr de telefon',
    'admin-panel.form.contact-info.longPhone' => 'Numărul de telefon este prea lung (se acceptă cel mult %max% simboluri).',
    'admin-panel.form.contact-info.fax' => 'Număr de fax',
    'admin-panel.form.contact-info.imNumber' => 'Mesaje instant',
    'admin-panel.form.contact-info.longFax' => 'Numărul de fax este prea lung (se acceptă cel mult %max% simboluri).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Numărul de telefon specificat este incorect.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Acest număr de fax este incorect.',
    'admin-panel.form.contact-info.address' => 'Adresă',
    'admin-panel.form.contact-info.longAddress' => 'Adresa este prea lungă (se acceptă cel mult %max% simboluri).',
    'admin-panel.form.contact-info.city' => 'Localitate',
    'admin-panel.form.contact-info.longCity' => 'Numele de localitate este prea lung.',
    'admin-panel.form.contact-info.shortCity' => 'Numele de localitate este prea scurt.',
    'admin-panel.form.contact-info.state' => 'Stat/județ',
    'admin-panel.form.contact-info.postalCode' => 'Cod poștal/ZIP',
    'admin-panel.form.contact-info.country' => 'Țară',
    'admin-panel.form.contact-info.additionalInfo' => 'Informații suplimentare',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Doar text simplu: toate etichetele HTML vor fi ignorate.',
    'admin-panel.form.contact-info.duplicateEmail' => 'În sistem există deja un utilizator cu această adresă de e-mail.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Abonament',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Proprietățile site-ului pus în funcțiune împreună cu abonamentul.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Proprietățile site-ului pus în funcțiune împreună cu abonamentul.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Proprietățile site-ului pus în funcțiune împreună cu abonamentul.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Se creează un abonament pentru client',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Goliți această casetă de selectare dacă deocamdată nu doriți să creați un abonament de servicii de găzduire sau să configurați un site pentru client. Fără abonament, clientul nu se va putea conecta la Panoul de client.',
    'admin-panel.form.domain-info-section.domainName' => 'Nume domeniu',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Trebuie să introduceți un nume de domeniu.',
    'admin-panel.form.domain-info-section.shared' => 'partajată',
    'admin-panel.form.domain-info-section.exclusive' => 'dedicată',
    'admin-panel.form.domain-info-section.userName' => 'Nume utilizator',
    'admin-panel.form.domain-info-section.userNameHint' => 'Contul de utilizator de sistem utilizat în administrarea fișierelor și a folderelor care aparțin site-urilor create în baza abonamentului.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Trebuie să introduceți un nume de utilizator.',
    'admin-panel.form.domain-info-section.password' => 'Parolă',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Trebuie să introduceți o parolă.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Confirmare parolă',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Adresă IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "Adresa IP la care se găzduiește site-ul este o adresă de rețea a gazdei virtuale a site-ului.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Adresă IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Niciuna',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Setări suplimentare pentru abonament',
    'admin-panel.form.domain-info-section.credentials' => 'Acreditările utilizatorului de sistem',
    'admin-panel.form.domain-info-section.credentialsHint' => 'pentru accesarea prin FTP și SSH a fișierelor găzduite',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'pentru accesarea prin FTP și RDP a fișierelor găzduite',

    'admin-panel.form.login-info.userName' => 'Nume utilizator',
    'admin-panel.form.login-info.emptyUserName' => 'Introduceți un nume de utilizator.',
    'admin-panel.form.login-info.password' => 'Parolă',
    'admin-panel.form.login-info.emptyPassword' => 'Introduceți parola.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Repetați parola',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Dacă schimbați parola, se va schimba și parola adresei de e-mail interne',
    'admin-panel.form.login-info.emailActivation' => 'Activare cont prin e-mail',
    'admin-panel.form.login-info.emailActivationHint' => 'Un cont creat este inactiv până când îl activează utilizatorul (cu linkul trimis prin e-mail) sau administratorul (manual).',

    'admin-panel.form.subscription-info-section.subscription' => 'Abonament',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Plan de servicii',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Plan de servicii actual',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Noul plan de servicii',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Plan simplu',
    'admin-panel.form.subscription-info-section.none' => 'Niciunul',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Componente add-on',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Continuați cu particularizarea parametrilor de abonament după modificarea asocierii de planuri. Rețineți: această operație va bloca sincronizarea abonamentului.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'După crearea abonamentului îi puteți personaliza parametrii.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "După crearea clientului puteți personaliza parametrii de abonament.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Continuați cu particularizarea parametrilor de abonament după creare. Rețineți: această operație va bloca sincronizarea abonamentului.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Rețineți: acest lucru va împiedica sincronizarea abonamentului.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Adăugare abonament',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Imposibil de sincronizat abonamentul cu planul de servicii. Următoarele setări ale abonamentului intră în conflict cu planul de servicii: %%problems%%.',

    'app.configure.otherSettings' => 'Altele',
    'app.configure.passwordConfirmation' => 'Confirmare parolă',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Se forțează actualizarea tuturor aplicațiilor instalate',
    'app.update-settings.forceUpdatesHint' => 'Toate aplicațiile clientului se vor actualiza automat, imediat ce actualizările vor fi disponibile. Clienții nu vor putea dezactiva actualizarea automată a aplicațiilor. Avertizare: aveți grijă dacă utilizați această opțiune, pentru că actualizările pot afecta semnificativ funcționarea aplicației. De exemplu, extensiile de aplicație pot înceta să funcționeze în momentul trecerii la o nouă versiune a aplicației.',
    'app.update-settings.suggestUpdates' => 'Opțiunea „Dacă apar actualizări ale acestei aplicații, se vor instala automat” se activează în mod implicit',
    'app.update-settings.suggestUpdatesHint' => 'Pentru aplicațiile nou instalate se va activa opțiunea „Dacă apar actualizări ale acestei aplicații, se vor instala automat” din setări.',

    'backup.server-settings.rotation' => 'Număr maxim de fișiere copie de rezervă complete de stocat (copii create programat și manual)',
    'backup.server-settings.rotationDescription' => 'Utilizatori pot crea cel mult atâtea fișiere de rezervă complete în spațiul de stocare de pe server. Dacă numărul de copii de rezervă existente în spațiul de stocare depășește limita, se păstrează doar copiile de rezervă mai recente. Copiile de rezervă incrementale nu sunt afectate.',
    'backup.server-settings.maxProcesses' => 'Număr maxim de procese de creare a copiilor de rezervă programate, executate simultan',
    'backup.server-settings.niceScheduled' => 'Procesele programate de creare a copiilor de rezervă se execută cu prioritate redusă',
    'backup.server-settings.niceScheduledPriority' => 'Prioritate',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Introduceți o valoare cuprinsă între 1 și 19, inclusiv. Numerele mai mari desemnează prioritățile mai mici.',
    'backup.server-settings.niceScheduledIoPriority' => 'Prioritate IO',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Introduceți o valoare cuprinsă între 0 și 7, inclusiv. Numerele mai mari desemnează prioritățile mai mici.',
    'backup.server-settings.niceAlways' => 'Toate procesele de creare a copiilor de rezervă se execută cu prioritate redusă',
    'backup.server-settings.niceAlwaysPriority' => 'Prioritate',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Introduceți o valoare cuprinsă între 1 și 19, inclusiv. Numerele mai mari desemnează prioritățile mai mici.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Prioritate IO',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Introduceți o valoare cuprinsă între 0 și 7, inclusiv. Numerele mai mari desemnează prioritățile mai mici.',
    'backup.server-settings.compressionLevel' => 'Nivel de comprimare',
    'backup.server-settings.compressionLevelNoCompression' => 'Fără comprimare',
    'backup.server-settings.compressionLevelFastest' => 'Viteză maximă',
    'backup.server-settings.compressionLevelFast' => 'Rapid',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'Comprimare maximă',
    'backup.server-settings.freeSpaceRequired' => 'Crearea copiei de rezervă se activează numai dacă spațiul liber pe discul serverului este la nivelul specificat (în megabyți)',
    'backup.server-settings.checkBackupDiskSpace' => 'Crearea copiei de rezervă pornește numai dacă este destul spațiu liber pe disc',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Se utilizează funcția de copie de rezervă proprie MS SQL (În cazul bazelor de date la distanță, nu uitați să configurați setările legate de copiile de rezervă pe serverul MS SQL la distanță, în Instrumente și setări> Servere de baze de date)',
    'backup.server-settings.localFtpRestriction' => 'Se permite configurarea, pe serverul local, a unui spațiu de stocare FTP pentru copii de rezervă',
    'backup.server-settings.backupSecuritySettings' => 'Setări de securitate a copiei de rezervă',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Dacă nu reușește încărcarea în stocarea la distanță, copiile de rezervă se salvează local, pe server',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Dacă nu reușește încărcarea în spațiul de stocare la distanță, copiile de rezervă (manuale și programate) destinate spațiului respectiv vor fi salvate în spațiul local al serverului. Utilizatorii trebuie să aibă permisiune de salvare a copiilor de rezervă în spațiul de stocare al serverului.',
    'backup.server-settings.AllowScheduleHourly' => 'Clienții și resellerii pot programa copii de rezervă la ora dorită',

    'change-current-subscription.hint' => 'Aici puteți modifica asocierea abonamentului cu planurile de servicii. Rețineți: dacă selectați „niciunul” drept noul plan de servicii, abonamentul va fi desprins de planul de servicii și se va folosi valoarea „Personalizat”.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Imposibil de sincronizat abonamentul cu planul de servicii. Următoarele setări ale abonamentului intră în conflict cu planul de servicii: %%problems%%.',

    'change-password.oldPassword' => 'Parola veche',
    'change-password.password' => 'Parola nouă',
    'change-password.passwordConfirmation' => 'Confirmare parolă',
    'change-password.oldPasswordIsIncorrect' => 'Parola veche este incorectă. Încercați mai nou.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Imposibil de găsit contul de administrator suplimentar.',
    'change-password.warningAboutAdminPasswordSyntax' => "Parola trebuie să aibă o lungime cuprinsă între %%min%% și %%max%% caractere și nu poate conține numele de utilizator.\nNu folosiți ghilimele, spații și diacritice în parolă.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Nu folosiți ghilimele, spații, caractere punct și virgulă și diacritice în parolă.\nLungimea parolei trebuie să fie cuprinsă între %%min%% și %%max%% caractere. Parola nu poate conține numele utilizatorului.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Politică de supravânzare',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Se permite supravânzarea',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Supravânzarea îi permite resellerului să vândă mai multe resurse decât are alocate prin plan. Dacă supravânzarea este permisă, activitatea resellerului este reglementată în funcție de utilizarea efectivă a resurselor, nu de alocarea inițială.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Nu se permite supravânzarea',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Dacă supravânzarea nu este permisă, resellerul nu poate vinde resurse decât în limitele disponibilului care i s-a alocat prin plan, indiferent de volumele utilizate efectiv.',

    'change-reseller-subscription.hint' => 'Aici puteți modifica asocierea planului de servicii cu abonamentul de reseller. Rețineți: dacă selectați „niciunul” drept noul plan de servicii, abonamentul va fi desprins de planurile de servicii și se va folosi valoarea „Personalizat”.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Imposibil de sincronizat abonamentul cu planul de servicii. Următoarele setări ale abonamentului intră în conflict cu planul de servicii: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Plan nou',
    'change-reseller-subscription.oldSubscription' => 'Plan actual',
    'change-reseller-subscription.none' => 'niciunul',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Asocierea abonamentului cu planul de servicii a fost actualizat.',
    'change-reseller-subscription.customizeSubscription' => 'Continuați cu particularizarea parametrilor de abonament după actualizarea asocierii cu planul de servicii. Rețineți: această operație va bloca sincronizarea abonamentului.',

    'change-subscription.hint' => 'Aici puteți modifica asocierea abonamentelor selectate cu planurile de servicii.',
    'change-subscription.selectPlanLegend' => 'Plan de servicii',
    'change-subscription.selectPlanDescription' => 'Pentru a trece la un alt plan de servicii, alegeți-l din listă. Rețineți: dacă selectați „niciunul”, abonamentele vor fi desprinse de planul de servicii și se va folosi valoarea „Personalizat”.',
    'change-subscription.servicePlan' => 'Noul plan de servicii',
    'change-subscription.selectAddonPlansLegend' => 'Planuri add-on',
    'change-subscription.selectAddonPlansDescription' => 'Adăugarea sau ștergerea planurilor add-on.',
    'change-subscription.noChange' => 'nicio modificare',
    'change-subscription.none' => 'niciunul',
    'change-subscription.add' => 'adăugare',
    'change-subscription.del' => 'ștergere',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Subrețea sau adresă IP',
    'control-panel-access.network.subnetOrIpAddressHint' => 'De exemplu, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Acces la Plesk cu privilegii de administrator',
    'control-panel-access.settings.policyAllow' => 'Permis, în afară de rețelele din listă.',
    'control-panel-access.settings.policyDeny' => 'Interzis din rețelele care nu sunt în listă.',

    'create-subscription.title' => 'Adăugare abonament',
    'create-subscription.titleOwn' => 'Adăugarea propriului abonament',
    'create-subscription.poolIsEmpty' => 'Nu se poate crea un abonament pentru că nu există adrese IP partajate și nici adrese IP dedicate disponibile în Plesk.',
    'create-subscription.infoNewSubscriptionCreated' => 'Abonamentul %%name%% a fost creat.',
    'create-subscription.createBeforeAppInstall' => 'Pentru a putea instala aplicația, trebuie să aveți un abonament.',

    'customer.hint' => 'Aici puteți să înregistrați un client nou pentru serviciile de găzduire pe care le oferiți. Prin această înregistrare creați un cont de client în Plesk și un abonament la unul dintre planurile de găzduire precum și, opțional, la componente add-on. Abonamentul poate furniza și un set de resurse și de servicii complet personaliza, nelegat de vreun plan – pentru aceasta, selectați „Niciunul” în dreptul câmpului Plan de servicii.',
    'customer.contactInfoSection' => 'Informații de contact',
    'customer.additionalInfoSection' => 'Informații suplimentare despre client',
    'customer.accessToPanelSection' => 'Acces la Plesk',
    'customer.contactInfoSectionHint' => 'Introduceți informațiile de contact ale clientului.',
    'customer.accessToPanelSectionHint' => 'Acreditările cu care clientul va accesa propriul Panoul de client.',
    'customer.unableCreateSubscription' => 'Imposibil de creat abonament: %%reason%%',
    'customer.poolIsEmpty' => 'Domeniul de adrese IP este gol',
    'customer.buttonOk' => 'Adăugare client',

    'database-settings.dbPrefixRadio' => 'Se adaugă un prefix și un caracter de subliniere înaintea numelor de baze de date',
    'database-settings.dbPrefixNone' => 'Fără prefix',
    'database-settings.dbPrefixUsername' => 'Nume utilizator',
    'database-settings.dbPrefixExternalId' => 'ID-ul extern al abonamentului',
    'database-settings.dbPrefixCustom' => 'Prefix personalizat',
    'database-settings.dbUserPrefixRadio' => 'Se adaugă un prefix și un caracter de subliniere înaintea numelor de utilizatori de baze de date',
    'database-settings.dbUserPrefixHint' => 'Numele de utilizatori de baze de date vor avea forma <prefix>_<database_user_name>. Date fiind restricțiile legate de lungimea numelui de utilizator, <prefix> se poate abrevia.',
    'database-settings.grantAlterDatabase' => 'Se acordă permisiunea de ALTER DATABASE tuturor utilizatorilor de baze de date Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Utilizatorii noi și existenți vor primi această permisiune.',
    'database-settings.aclRadio' => 'Setări implicite pentru accesul de la distanță al utilizatorilor de baze de date MySQL',
    'database-settings.aclLocalhost' => 'Nu se acceptă decât conexiuni locale',
    'database-settings.aclAny' => 'Se acceptă conexiunile la distanță de la orice gazdă',
    'database-settings.aclCustom' => 'Se acceptă conexiunile la distanță de la',
    'database-settings.aclDescription' => 'Această setare modifică doar permisiunile utilizatorilor. Pentru a activa accesul de la distanță la acest server MySQL local, selectați opțiunea corespunzătoare în %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Setări MySQL local',
    'database-settings.example' => "De exemplu:",
    'database-settings.aclExampleDescription' => "Gazdele specificate pot accesa baza de date în numele acestui utilizator.",
    'database-settings.dbPrefixAlphaNumeric' => 'Prefixul nu poate să conțină decât valori alfanumerice și un caracter de subliniere.',

    'dns.add-acl-record.description' => 'Adăugarea adresei IP a unui server DNS autorizat să primească o copie a zonei DNS.',
    'dns.add-acl-record.ipAddress' => 'Adresă IP',
    'dns.add-acl-record.ipAddressWithMask' => 'Adresă IP/mască',

    'dns.settings.recursion' => 'Interogări DNS recursive',
    'dns.settings.recursionOn' => 'Se permite pentru toate solicitările',
    'dns.settings.recursionLocal' => 'Se permite doar pentru solicitările locale',
    'dns.settings.recursionLocalnets' => 'Nu se acceptă solicitări decât din rețelele locale',
    'dns.settings.recursionOff' => 'Se refuză toate solicitările',
    'dns.settings.customConfiguration' => 'Setări DNS suplimentare',
    'dns.settings.customConfigurationPlaceholder' => 'Setările pe care le specificați aici au prioritate față de cele la nivel de server.',
    'dns.settings.customConfigurationHint' => 'Dacă nu găsiți anumite setări, introduceți-le în câmpul de mai sus, folosind sintaxa named.conf.',
    'dns.settings.customConfigurationExample' => 'De exemplu, pentru a ascunde numele de gazdă al serverului DNS, adăugați următorul rând: ',
    'dns.settings.restoreDefaultButton' => 'Se utilizează setările implicite',

    'dns.template.synchronize-done' => 'Șablonul de zonă DNS a fost aplicat cu succes.',
    'dns.template.synchronize-error' => 'Șablonul de zonă DNS nu a fost aplicat anumitor zone DNS.',
    'dns.template.synchronize-progress' => 'Aplicarea șablonului de zonă DNS.',

    'domain-restriction.name' => 'Nume domeniu',
    'domain-restriction.nameDescription' => 'Puteți specifica un model cu caractere generice utilizând asteriscul (*). De exemplu: *.exemplu.ro',
    'domain-restriction.domainAlreadyExists' => 'Numele de domeniu specificat este deja în listă.',

    'event-handler.eventLabel' => 'Eveniment',
    'event-handler.priorityLabel' => 'Nivel de prioritate',
    'event-handler.userLabel' => 'Utilizator',
    'event-handler.commandLabel' => 'Comandă',
    'event-handler.commandHint' => 'Pentru rezultate optime, introduceți în câmpul „comandă” calea completă a unui fișier script. Nu se recomandă introducerea unor comenzi de sistem: este posibil ca acestea să nu funcționeze. De exemplu, nu vor funcționa comenzile cu operatori de redirecționare a ieșirii /&gt; și &lt;.',
    'event-handler.priorityHighestText' => 'maxim',
    'event-handler.priorityHighText' => 'ridicat',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'scăzut',
    'event-handler.priorityLowestText' => 'minim',
    'event-handler.priorityCustomText' => 'personalizat',
    'event-handler.priorityHighestOption' => 'maxim (%%value%%)',
    'event-handler.priorityHighOption' => 'ridicat (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'scăzut (%%value%%)',
    'event-handler.priorityLowestOption' => 'minim (%%value%%)',

    'extension.upload.fileUpload' => 'Calea către fișierul pachet de extensii',

    'external-webmail.hint' => 'După ce înregistrați în Plesk încă un program de mail prin web, acesta va deveni disponibil clienților: va apărea drept opțiune în proprietățile de „E-mail” ale planurilor de găzduire și ale abonamentelor. Numele programului de e-mail prin web va fi afișat în lista opțiunilor de webmail. URL-ul corespunzător se va putea accesa prin clic pe pictograma webmail de lângă o căsuță poștală din Panoul de client.',
    'external-webmail.name' => 'Nume serviciu e-mail prin web',
    'external-webmail.url' => 'URL serviciu e-mail prin web',
    'external-webmail.enabled' => 'Disponibil',

    'ftp-settings.generalSection' => 'General',
    'ftp-settings.portRange' => 'Port sau interval de porturi pentru conexiunile FTP în modul pasiv',
    'ftp-settings.hintPortRange' => '(valoare implicită: %%defaultPortRange%%)',

    'health.upload.hint' => 'Încărcarea configurației de monitorizare a stării de funcționare. Configurația se va aplica imediat după încărcare.',
    'health.upload.selectFile' => 'Fișier de configurare',

    'install-local-package.selectUploadType' => 'Alegeți una dintre următoarele opțiuni:',
    'install-local-package.uploadAsFile' => 'Încărcarea unui pachet APS',
    'install-local-package.downloadFromCatalog' => 'Selectați o aplicație din catalogul de aplicații',
    'install-local-package.formInfo' => "Extindeți lista aplicațiilor disponibile prin încărcarea uneia noi sau adăugați o aplicație din catalog pentru configurare suplimentară.",
    'install-local-package.invalidFileExtension' => 'Aplicația încărcată trebuie să fie o arhivă ZIP cu extensia .zip.',
    'install-local-package.packagesNotSelected' => 'Niciunul dintre pachete nu este selectat.',
    'install-local-package.visible' => 'Se pune la dispoziția clienților',
    'install-local-package.isCommercial' => 'Această aplicație este comercială și necesită cumpărarea unei chei de licență.',
    'install-local-package.visibleDescription' => 'Aplicația va putea fi instalată de către clienți.',

    'ip-address.addTitle' => 'Adăugare adresă IP',
    'ip-address.editTitle' => 'Adresa IP %%address%% pe interfața %%interface%%',
    'ip-address.generalSection' => 'General',
    'ip-address.interface' => 'Interfață',
    'ip-address.addressAndSubnetPrefixLength' => 'Adresă IP și mască de subrețea',
    'ip-address.addressHintIPv4' => 'De exemplu, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'De exemplu, 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Adresă IP publică',
    'ip-address.hintPublicIp' => 'Puteți utiliza o adresă IP publică dacă serverul Plesk este după un NAT',
    'ip-address.distributionType' => 'Adresa IP se distribuie ca',
    'ip-address.distributionTypeShared' => 'Partajată',
    'ip-address.distributionTypeExclusive' => 'Dedicată',
    'ip-address.certificate' => 'Certificat SSL/TLS',
    'ip-address.defaultSite' => 'Site implicit',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Serverul FTP instalat nu acceptă FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Serverul FTP instalat nu acceptă adresele IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'Nu se poate adăuga adresa IP. Această interfață de rețea obține automat adresele IP.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Observație: URL-ul personalizat Plesk este activat pentru toate domeniile necunoscute; pe site-ul implicit de la adresa „https://%%ip%%/” se va afișa interfața implicită Plesk',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'Adaptorul de rețea %%interface%% nu există. Mutarea acestei adrese IP la un alt adaptor de rețea sau eliminarea sa din listă.',
    'ip-address.none' => 'niciunul',

    'ip-ban.filter.name' => 'Nume',
    'ip-ban.filter.content' => 'Conținut',
    'ip-ban.filter.filterExistsError' => 'Deja există un filtru cu acest nume.',

    'ip-ban.jail.name' => 'Nume',
    'ip-ban.jail.filter' => 'Filtru',
    'ip-ban.jail.filterDescription' => 'Selectați filtrul.',
    'ip-ban.jail.action' => 'Acțiune',
    'ip-ban.jail.actionDescription' => 'Selectați o acțiune și faceți clic pe un buton pentru a o adăuga.',
    'ip-ban.jail.logPath' => 'Cale jurnal',
    'ip-ban.jail.banTime' => 'Perioadă de interdicție a adreselor IP',
    'ip-ban.jail.maxRetry' => 'Numărul maxim de tentative de conectare nereușite',
    'ip-ban.jail.timeUnit' => 'secunde',
    'ip-ban.jail.addAction' => 'Adăugare',
    'ip-ban.jail.chooseAction' => 'Selectați:',
    'ip-ban.jail.apache-auth-filter-description' => 'Erori de autorizare Apache (la înscrierea intrării de jurnal în fișier)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Erori de autorizare Apache (la orice înscriere de intrări de jurnal)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Erori de autorizare Apache (la înscrierea intrării în jurnalul de sistem)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Roboți de spam și crawlere web rău intenționate',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Erori de autentificare Courier IMAP și POP3',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Erori de autentificare Dovecot IMAP, POP3 și Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Erori de autentificare Dovecot IMAP, POP3 și Sieve (mod agresiv)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Erori de autentificare webmail Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Încălcări de securitate și control al accesului în firewallul de aplicații web (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Erori de autentificare webmail Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Erori de autentificare QMail SMTP',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Erori de autentificare webmail Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Erori de autentificare WordPress',
    'ip-ban.jail.postfix-filter-description' => 'Erori de client SMTP Postfix (inclusiv RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Erori de client, erori de autentificare și atacuri DDoS SMTP Postfix',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Erori de autentificare Postfix SMTP și SASL',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Atacuri DDoS SMTP Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Erori de client și erori de autentificare SMTP Postfix',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Erori de client SMTP Postfix (inclusiv RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Erori de client SMTP Postfix (numai RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Erori de conectare ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Gazde interzise în mod repetat de Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Erori de conectare SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Erori de conectare SSH, negocieri nereușite și atacuri DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Erori de conectare SSH și atacuri DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Erori de conectare SSH și negocieri nereușite',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Interdicție prin firewall firewalld, pe toate porturile',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Interdicție prin firewall firewalld, pe mai multe porturi',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Interdicție prin firewall firewalld, pe un singur port',
    'ip-ban.jail.iptables-action-description' => 'Interdicție prin firewall iptables, pe un singur port',
    'ip-ban.jail.iptables-allports-action-description' => 'Interdicție prin firewall iptables, pe toate porturile',
    'ip-ban.jail.iptables-multiport-action-description' => 'Interdicție prin firewall iptables, pe mai multe porturi',
    'ip-ban.jail.sendmail-action-description' => 'Trimitere e-mail de notificare prin Sendmail',
    'ip-ban.jail.jailExistsError' => 'Deja există un jail cu acest nume.',
    'ip-ban.jail.invalidInteger' => 'Valoarea specificată este incorectă. Specificați un număr întreg.',

    'ip-ban.settings.pageHint' => 'Aici puteți configura interzicere adreselor IP pentru a vă proteja serverul și site-urile găzduite împotriva traficului rău intenționat.',
    'ip-ban.settings.detectionEnabled' => 'Activare detectare intruziuni',
    'ip-ban.settings.banPeriod' => 'Perioadă de interdicție a adreselor IP',
    'ip-ban.settings.banTimeWindow' => 'Interval de timp pentru detectarea atacurilor succesive',
    'ip-ban.settings.maxRetries' => 'Număr de nereușite după care se interzice adresa IP',
    'ip-ban.settings.timeUnit' => 'secunde',
    'ip-ban.settings.invalidInteger' => 'S-a specificat o valoare incorectă. Introduceți un număr întreg pozitiv.',

    'ip-ban.trusted-ip.ipAddress' => 'Adresă IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'O adresă IP, o mască CIDR sau un nume de gazdă DNS.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'Adresa IP, adresa de rețea sau numele de gazdă este incorect.',
    'ip-ban.trusted-ip.ipAddressIsTooLong' => 'O adresă IP poate avea cel mult %max% caractere.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Descriere',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Explicație: de ce a fost adăugată lista IP în lista de încredere.',
    'ip-ban.trusted-ip.ipAddressDescriptionTooLong' => 'Descrierea poate avea cel mult %max% caractere.',

    'login-info.hint' => 'Aici puteți modifica numele de utilizator și parola cu care clientul va accesa propriul Panoul de client.',
    'login-info.resellerHint' => 'Aici puteți modifica numele de utilizator și/sau parola cu care resellerul va accesa Plesk.',
    'login-info.myProfileHint' => 'Aici puteți schimba parola cu care accesați Plesk.',

    'firewall-rule.titleEdit' => 'Editarea unei reguli de firewall',
    'firewall-rule.titleNew' => 'Adăugarea unei reguli',
    'firewall-rule.isEnabled' => 'Activare regulă',
    'firewall-rule.name' => 'Nume regulă',
    'firewall-rule.profiles' => 'Profiluri',
    'firewall-rule.profilesHint' => 'Trebuie să selectați cel puțin un profil.',
    'firewall-rule.profileDomain' => 'Domeniu',
    'firewall-rule.profilePrivate' => 'Privat',
    'firewall-rule.profilePublic' => 'Public',
    'firewall-rule.action' => 'Acțiune',
    'firewall-rule.actionAllow' => 'Se permite',
    'firewall-rule.actionBlock' => 'Refuzare',
    'firewall-rule.port' => 'Se permit conexiunile la următorul port sau interval de porturi',
    'firewall-rule.portHint' => 'De exemplu: 1000 sau 1000-1051',
    'firewall-rule.protocolTcp' => 'Protocol TCP',
    'firewall-rule.protocolUdp' => 'Protocol UDP',
    'firewall-rule.remoteAddresses' => 'Adrese la distanță',
    'firewall-rule.remoteAddressesHint' => 'De exemplu: 192.168.0.1 sau 192.168.0.0/16',
    'firewall-rule.newRule' => 'Regulă nouă',
    'firewall-rule.successNew' => 'Regula de firewall a fost activată.',
    'firewall-rule.successEdit' => 'Regula de firewall a fost actualizată.',

    'mail.lists-server-settings.email' => "Adresa de e-mail a administratorului de liste de e-mail",
    'mail.lists-server-settings.emptyEmail' => 'Introduceți o adresă de e-mail.',
    'mail.lists-server-settings.newPassword' => 'Parola nouă',
    'mail.lists-server-settings.emptyPassword' => 'Introduceți parola.',
    'mail.lists-server-settings.passwordConfirmation' => 'Confirmare parolă',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Software-ul de liste de e-mail a fost configurat.',

    'mail.outgoing-messages.hint' => 'Aici puteți specifica numărul limită de mesaje trimise dintr-o căsuță poștală.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Numărul maxim de mesaje de e-mail trimise',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Implicit (%%domainOutgoingMessages%% mesaje pe oră)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Valoare personalizată pentru această căsuță poștală',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'mesaje pe oră',

    'mail-gate-settings.host' => 'Denumire gazdă sau adresă IP',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Nume utilizator',
    'mail-gate-settings.password' => 'Parolă',
    'mail-gate-settings.encryption' => 'Serverul SMTP necesită conexiune criptată',
    'mail-gate-settings.allowUsers' => 'Se permite scripturilor utilizator să trimită e-mailuri prin acest server SMTP (folosind numele de utilizator parola specificate)',
    'mail-gate-settings.useDefaultSettings' => 'Se utilizează serverul de e-mail instalat cu Plesk și contul de e-mail implicit creat de Plesk',

    'mail-gate.hint' => 'Aici puteți specifica serverul SMTP care se va utiliza în cazul în care serverul de e-mail Plesk server e-mail nu este instalat sau nu are permisiunea de a trimite e-mailuri. Plesk și scripturile utilizator vor utiliza acest server ca transmițător SMTP pentru trimiterea mesajelor de e-mail, cum ar fi notificările.',
    'mail-gate.enableMailGate' => 'Plesk va putea trimite e-mailuri de notificare prin acest server SMTP',
    'mail-gate.notifications' => 'E-mailuri de notificare prin server SMTP extern',
    'mail-gate.smtpSettings' => 'Setări de server SMTP extern',

    'optimization-settings.apacheModulesSection' => 'Module Apache',
    'optimization-settings.apacheSettingsSection' => 'Setări generale',
    'optimization-settings.additionalPageHint' => 'Activați/dezactivați modulele numai dacă înțelegeți complet ce consecințe pot avea acțiunile respective. Rețineți: unele modificări pot deteriora performanțele Apache sau chiar pot împiedica funcționarea acestuia.',
    'optimization-settings.pageHint' => 'Aici puteți optimiza Plesk prin dezactivarea modulelor Apache nefolosite. Această optimizare îmbunătățește utilizarea memorie și vă permite să deserviți mai mulți clienți cu servicii de găzduire. Rețineți: unele module sunt depind de altele și se pot dezactiva (respectiv activa) numai dacă modulele de care depind sunt dezactivate (respectiv activate).',
    'optimization-settings.advancedUsersOnlyWarning' => 'Această caracteristică este destinată exclusiv utilizatorilor avansați.',
    'optimization-settings.apacheRestartInterval' => 'Interval de repornire Apache (secunde)',
    'optimization-settings.apacheRestartIntervalHint' => 'O dată în perioada specificată, Plesk verifică dacă s-au făcut modificări în domenii și în subdomenii. Dacă detectează modificări care impun repornirea serverului web, Plesk repornește Apache.',
    'optimization-settings.gracefulRestart' => 'Repornire neforțată Apache',
    'optimization-settings.gracefulRestartHint' => 'Selectați pentru a evita oprirea tuturor site-urilor găzduite pe server ori de câte ori modificați setările de găzduire.',
    'optimization-settings.pipedLog' => 'Jurnale prin conductă de proces',
    'optimization-settings.mpmMode' => 'Mod MPM',
    'optimization-settings.moduleDeprecated' => '(Abandonat)',

    'personal-info.contactInfoSection' => 'Informații de contact',
    'personal-info.hint' => 'Aici puteți edita informațiile de contact ale utilizatorului.',
    'personal-info.hintMyProfile' => 'Aici puteți edita propriile informații de contact.',

    'php-handler.extension.title' => 'Instalare pachet PECL',
    'php-handler.extension.description' => "Puteți să instalați o versiune beta a extensiei: specificați parametri suplimentari cu numele pachetului, de exemplu, „msgpack-beta”.",
    'php-handler.extension.name' => 'Nume pachet',

    'php-handler.ini.formHint' => 'Acest fișier php.ini este utilizat doar de acest handler.',
    'php-handler.ini.formHintSharedIni' => 'Acest fișier php.ini este utilizat și de următoarele programe handler: %%handlers%%. Setările sunt valabile pentru toate site-urile web care utilizează aceste handlere.',
    'php-handler.ini.incorrectTextForIniFile' => "Setările specificate sunt incorecte și nu se pot salva în fișierul php.ini. Eroare: %%message%%",

    'plan-item-custom.planItemName' => 'Nume serviciu',
    'plan-item-custom.buttonLabel' => 'Acest nume va fi utilizat și ca etichetă pentru butonul personalizat.',
    'plan-item-custom.planItemDescription' => 'Descrierea serviciului',
    'plan-item-custom.buttonTooltip' => 'Acest text va fi utilizat și ca sfat ecran pentru butonul personalizat',
    'plan-item-custom.url' => 'URL atașat butonului personalizat',
    'plan-item-custom.backgroundImage' => 'Imagina de fundal pentru butonul personalizat',
    'plan-item-custom.emptyItemName' => 'Introduceți eticheta corespunzătoare serviciului.',
    'plan-item-custom.emptyItemDescription' => 'Introduceți textul sfatului ecran corespunzător serviciului.',
    'plan-item-custom.emptyUrl' => 'Specificați un URL.',
    'plan-item-custom.longItemName' => 'Eticheta serviciului este prea lungă. Lungimea maximă permisă este de %max% simboluri.',
    'plan-item-custom.longItemDescription' => 'Textul de descriere a serviciului este prea lung. Lungimea maximă permisă este de %max% simboluri.',
    'plan-item-custom.longUrl' => 'Acest URL este prea lung. Lungimea maximă permisă este de %max% simboluri.',
    'plan-item-custom.useCustomButton' => 'Se utilizează un buton personalizat pentru serviciu',
    'plan-item-custom.useCustomButtonHint' => 'Amplasați un buton personalizat în pagina de pornire a utilizatorului și în paginile de pe site.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Deschidere URL în Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Specificați dacă URL-ul se va deschide într-o pagină Plesk sau într-o nouă fereastră de browser.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Nu se utilizează cadre',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Dacă adăugați un buton personalizat care conduce la o extensie Plesk sau la o aplicație în Panoul de client, puteți specifica modul în care se va afișa extensia/aplicația: într-un cadru sau ca parte a interfeței grafice Plesk.',
    'plan-item-custom.includeDomId' => 'Se include ID-ul abonamentului',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Se include numele domeniului principal',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Se include numele de utilizator FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Se include parola FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Se include ID-ul clientului',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Se include numele companiei clientului",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Se include numele de contact al clientului",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Se include e-mailul clientului",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Alegerea modului de previzualizare a site-urilor',
    'preview-domain-settings.previewQuick' => 'Previzualizare rapidă implicită',
    'preview-domain-settings.previewDisabled' => 'Dezactivare Previzualizare rapidă',
    'preview-domain-settings.previewQuickDescription' => 'O opțiune recomandă care funcționează direct, fără alte intervenții.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Previzualizare rapidă a unui nume de domeniu în Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Selectați unul dintre site-urile deservite de Plesk. Acesta va fi folosit pentru previzualizare.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Pentru a putea utiliza această funcție, %%link%% cel puțin un domeniu.',
    'preview-domain-settings.subscriptionCreateLink' => 'creați',
    'preview-domain-settings.previewZoneTypeExternal' => 'Previzualizare rapidă a unui nume de domeniu extern',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Se utilizează un nume de domeniu extern (Zonă DNS). Dacă utilizați această opțiune, adăugați următoarea înregistrare DNS (de tip A) la zona domeniului extern: *.<Plesk_IP>.external.dom. Aici <Plesk_IP> se găsește adresa IP a serverului Plesk. Punctele (.) în cazul IPv4 și caracterele două puncte (:) în cazul IPv6 sunt înlocuite de cratime (-). De exemplu, *.192-0-2-12.external.dom. Dacă Plesk are mai multe adrese IP înregistrate, adăugați câte o înregistrare pentru fiecare adresă.',
    'preview-domain-settings.sitePreviewProtection' => 'Necesită autentificare',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Previzualizarea se poate accesa cu numele de conectare și parola FTP.',
    'preview-domain-settings.nginxNotInstalled' => 'Previzualizarea rapidă implicită nu este disponibilă pentru că serverul web nginx nu este instalat.',
    'preview-domain-settings.nginxDisabled' => 'Previzualizarea rapidă implicită nu este disponibilă pentru că serverul web nginx este dezactivat.',

    'reseller-preferences.settingsSection' => 'Setări',
    'reseller-preferences.multiLogin' => 'Se acceptă mai multe sesiuni',
    'reseller-preferences.language' => 'Limba interfeței',
    'reseller-preferences.interfaceView' => 'Selectați interfața',
    'reseller-preferences.serviceProviderView' => 'Vizualizarea Furnizor de servicii',
    'reseller-preferences.serviceProviderViewHint' => 'Această vizualizare este destinată administratorilor de server care furnizează și vând servicii de găzduire web clienților, prin intermediul planurilor de servicii.',
    'reseller-preferences.powerUserView' => 'Vizualizarea Utilizator privilegiat',
    'reseller-preferences.powerUserViewHint' => 'Această vizualizare este optimă pentru administrarea de site-uri, fișiere, baze de date, conturi de e-mail, aplicații web și de alte servicii.',

    'reseller.hint' => 'Aici puteți să înregistrați un reseller nou pentru serviciile de găzduire pe care le oferiți.',
    'reseller.contactInfoSection' => 'Informații de contact',
    'reseller.contactInfoSectionHint' => 'Introduceți informațiile de contact ale resellerului.',
    'reseller.accessToPanelSection' => 'Acces la Plesk',
    'reseller.accessToPanelSectionHint' => 'Acreditările cu care resellerul accesează Plesk pentru a administra serviciile la care este abonat.',
    'reseller.subscription' => 'Abonament',
    'reseller.subscriptionSectionHint' => 'Selectați planul de servicii la care se va abona resellerul.',
    'reseller.servicePlan' => 'Plan de servicii',
    'reseller.none' => 'niciunul',
    'reseller.customizeSubscription' => 'Continuați cu particularizarea parametrilor de abonament după crearea resellerului. Rețineți: această operație va bloca sincronizarea abonamentului.',
    'reseller.subscriptionNotSynchronized' => 'Imposibil de sincronizat abonamentul cu planul de servicii. Următoarele setări ale abonamentului intră în conflict cu planul de servicii: %%problems%%.',

    'security-policy.encryptionSection' => 'Mod de securitate îmbunătățită',
    'security-policy.encryptionSectionHint' => 'Modul de securitate îmbunătățită asigură măsuri de protecție avansate pentru datele confidențiale din Plesk. În acest mod, Plesk utilizează mai multe mecanisme de securitate absolut transparente pentru utilizatorii Plesk. Pentru a îmbunătăți securitatea Plesk, vă recomandăm să activați acest mod.',
    'security-policy.encryptionEnable' => 'Mod de securitate îmbunătățită',
    'security-policy.securePassword' => 'Mod de securitate îmbunătățită',
    'security-policy.strengthSection' => 'Nivelul de complexitate a parolei',
    'security-policy.strengthSectionHint' => 'Majoritatea parolelor pe care le pot seta sau schimba utilizatorii în Plesk sunt validate pentru a asigura respectarea criteriilor minime de complexitate configurate aici. Parolele complexe au cel puțin 9-12 caractere și conțin cifre, litere mari și mici, caractere speciale și cuvinte care nu apar în dicționare. Sunt mai greu de ghicit, dar și de ținut minte. <a href="%%link%%" target="_blank">Informații suplimentare despre complexitatea parolelor</a>.',
    'security-policy.passwordStrength' => 'Nivelul minim de complexitate a parolei',
    'security-policy.secureFtpSection' => 'FTP securizat',
    'security-policy.ftpOverSsl' => 'Politica de utilizare FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS se utilizează pentru a proteja comunicațiile dintre serverul FTP și clienții FTP externi, prin intermediul protocolului SSL/TLS. Aici puteți selecta tipurile de conexiune care se acceptă.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS se utilizează pentru a proteja comunicațiile dintre serverul FTP și clienții FTP externi, prin intermediul protocolului SSL/TLS. Aici puteți selecta tipurile de conexiune care se acceptă. Opțiunea selectată se va aplica tuturor adreselor IP de pe server. Pentru a utiliza setări personalizate la nivel de adresă IP, selectați opțiunea corespunzătoare, apoi modificați politica FTPS în Instrumente și setări> Adrese IP.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS se utilizează pentru a proteja comunicațiile dintre serverul FTP și clienții FTP externi, prin intermediul protocolului SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS se utilizează pentru a proteja comunicațiile dintre serverul FTP și clienții FTP externi, prin intermediul protocolului SSL/TLS. Dacă doriți să reglați setările FTPS la nivel de adresă IP, selectați întâi opțiunea „Se utilizează setări FTPS la nivel de adresă IP” în Instrumente și setări> Politică de securitate> FTP securizat.',
    'security-policy.ftpOverSslOptionRequired' => 'Se acceptă doar conexiunile FTPS securizate',
    'security-policy.ftpOverSslOptionEnabled' => 'Se acceptă atât conexiunile FTPS securizate, cât cele FTP nesecurizate',
    'security-policy.ftpOverSslOptionDisabled' => 'Se acceptă doar conexiunile FTP nesecurizate. Nu se utilizează FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Se utilizează politici FTPS personalizate la nivel de adresă IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Politică de handlere personalizate',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Activați această opțiune pentru a împiedica clienții să suprascrie handlerele IIS definite la nivel de server, în fișierul web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Se interzice suprascrierea handlerelor prin web.config',

    'server-mail-antivirus.used' => 'Antivirus utilizat',
    'server-mail-antivirus.policy' => 'Se utilizează setările la nivel de server',
    'server-mail-antivirus.policyOff' => 'Scanarea este dezactivată',
    'server-mail-antivirus.policyAny' => 'Se scanează e-mailurile primite și cele trimise',
    'server-mail-antivirus.policyFrom' => 'Se scanează doar e-mailurile trimise',
    'server-mail-antivirus.policyTo' => 'Se scanează doar e-mailurile primite',
    'server-mail-antivirus.allowPersonalSettings' => 'Se permit setările personale',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Setările la nivel de server se pot suprascrie în fiecare adresă de e-mail',
    'server-mail-antivirus.incoming' => 'pentru e-mailurile primite',
    'server-mail-antivirus.outgoing' => 'pentru e-mailurile trimise',
    'server-mail-antivirus.success' => 'Setările de antivirus s-au modificat.',

    'server-mail-black-list.title' => 'Adăugarea domeniului în lista de interdicții',
    'server-mail-black-list.domainName' => 'Nume domeniu',
    'server-mail-black-list.emailAddress' => 'Adrese de e-mail',
    'server-mail-black-list.emailAddressHint' => 'În stânga semnului @ nu pot apărea caractere non-ASCII. Adresele pot conține caracterele generice „*” și „?” (de exemplu, *@domeniu.ro, utilizator?@*.ro). Porțiunile non-ASCII ale numelor de domenii nu pot conține caractere generice.',
    'server-mail-black-list.action' => 'Ce se întâmplă cu mesajele care îndeplinesc criteriile:',
    'server-mail-black-list.actionDelete' => 'Ștergere de pe server',
    'server-mail-black-list.actionSpam' => 'Marcare ca spam',
    'server-mail-black-list.success' => 'Domeniul a fost adăugat în lista de interdicții.',

    'server-mail-white-list.title' => 'Adăugarea rețelei în lista de permisiuni',
    'server-mail-white-list.descEmailAddress' => 'Adresele de e-mail specificate aici nu vor fi recunoscute ca spam de SpamAssassin.',
    'server-mail-white-list.descIpAddress' => 'Intrările de IP specificate aici vor fi adăugate la excepțiile serverului de e-mail.',
    'server-mail-white-list.ipAddress' => 'Adresă IP/mască',
    'server-mail-white-list.ipAddressHint' => 'Adresa IP poate conține caractere generice sau mască CIDR.',
    'server-mail-white-list.emailAddress' => 'Adrese de e-mail',
    'server-mail-white-list.emailAddressHint' => 'În stânga semnului @ nu pot apărea caractere non-ASCII. Adresele pot conține caracterele generice „*” și „?” (de exemplu, *@domeniu.ro, utilizator?@*.ro). Porțiunile non-ASCII ale numelor de domenii nu pot conține caractere generice.',
    'server-mail-white-list.emailAddressOrIp' => 'Adrese de e-mail sau IP',
    'server-mail-white-list.wildcardPattern' => 'Adresele IP pot conține caractere generice (de exemplu, 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'Adresele IP pot conține măști CIDR (de exemplu, 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Rețeaua a fost adăugată în lista de interdicții.',

    'server-mail-settings.general.title' => 'Opțiuni generale',
    'server-mail-settings.general.mailUiEnabled' => 'Se activează funcțiile de administrare e-mail în Plesk',
    'server-mail-settings.general.serverName' => 'Server e-mail instalat',
    'server-mail-settings.general.changeServerName' => 'să instalați și să utilizați un alt server de e-mail',
    'server-mail-settings.general.imapServerName' => 'Server IMAP/POP3 instalat',
    'server-mail-settings.general.changeImapServerName' => 'instalarea și utilizarea unui alt server IMAP/POP3',
    'server-mail-settings.general.changeServerHint' => 'Puteți să %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Dimensiunea maximă a mesajului',
    'server-mail-settings.general.kbytes' => 'Kbyți',
    'server-mail-settings.general.maxConnections' => 'Numărul maxim de conexiuni (IMAP, POP3, IMAP prin SSL/TLS sau POP3 prin SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'Deja a fost atins numărul maxim de servere (IMAP sau POP3) pornite.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'Numărul maxim de utilizatori de e-mail care se pot conecta în același timp.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Numărul maxim de conexiuni per adresă IP',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Numărul maxim de conexiuni pentru un utilizator, per adresă IP',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'Numărul maxim de conexiuni (IMAP, POP3, IMAP prin SSL/TLS sau POP3 prin SSL/TLS) care se acceptă de la aceeași adresă IP.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'Numărul maxim de conexiuni (IMAP, POP3, IMAP prin SSL/TLS sau POP3 prin SSL/TLS) care se acceptă pentru un anumit utilizator de e-mail de la fiecare adresă IP.',
    'server-mail-settings.general.messageSubmission' => 'Activarea serviciului SMTP pe portul 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Activarea serviciului SMTP pe portul 587 la toate adresele IP',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Pornit',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'la toate adresele IP',
    'server-mail-settings.general.outgoingEmailMode' => 'Modul de trimitere a e-mailurilor',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Se trimit de la adresele IP ale domeniului',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Se trimit de la adresele IP ale domeniului și se utilizează numele de domenii în întâmpinările SMTP',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Se trimit de la adresele IP specificate',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Niciunul',
    'server-mail-settings.general.subaddressing' => 'Activare lucru cu subadrese de e-mail',
    'server-mail-settings.general.subaddressingHint' => 'Această opțiune activează posibilitatea de a configura adrese de e-mail %%verpStyleLink%% pentru listele de e-mail',
    'server-mail-settings.general.verpStyleLink' => 'VERP',
    'server-mail-settings.general.mboxQuotaWarning' => 'Activarea avertizării despre cota de căsuță poștală',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Trimitere de notificare utilizatorilor de e-mail utilizatori când ocuparea cotei de căsuță poștală depășește 95%',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Personalizarea avertizării implicite despre cota de căsuță poștală',
    'server-mail-settings.general.fixSender' => 'Corectare expeditor setat incorect în e-mailurile trimise',
    'server-mail-settings.general.fixSenderHint' => 'Antetele de e-mail și adresele de răspuns se setează automat în e-mailurile trimise pentru a reduce șansele ca acestea să fie tratate drept spam',

    'server-mail-settings.autodiscover.title' => 'Descoperire automată e-mail',
    'server-mail-settings.autodiscover.description' => 'Aflați cum funcționează, din %%link%%',
    'server-mail-settings.autodiscover.link' => 'baza de cunoștințe',
    'server-mail-settings.autodiscover.enabled' => 'Activare descoperire automată e-mail',
    'server-mail-settings.autodiscover.enabledHint' => 'Activarea acestei funcții reconfigurează toate domeniile care au descoperirea automată activată',
    'server-mail-settings.autodiscover.customServer' => 'Specificați un nume de domeniu personalizat pentru descoperirea automată de e-mail',
    'server-mail-settings.autodiscover.customServerHint' => 'Observație: Numele de domeniu trebuie să fie securizat cu un certificat SSL/TLS valabil.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Reconfigurare înregistrări DNS de descoperire automată',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Activarea acestei funcții reconfigurează toate înregistrările DNS de domenii care au descoperirea automată activată',

    'server-mail-settings.relay.title' => 'Opțiuni de transmitere',
    'server-mail-settings.relay.type' => "Mod de transmitere",
    'server-mail-settings.relay.open' => "deschis",
    'server-mail-settings.relay.openSpamWarning' => "Deschiderea serviciului de retransmitere a e-mailurilor expune serverul de e-mail la spam.",
    'server-mail-settings.relay.openSpamChange' => "Păstrați setarea numai dacă doriți să testați temporar serverul de e-mail sau dacă serverul Plesk este într-o rețea internă, inaccesibilă prin internet.",
    'server-mail-settings.relay.closed' => "închis",
    'server-mail-settings.relay.auth' => "este necesară autorizarea:",
    'server-mail-settings.relay.notSupported' => "nu este acceptat de serverul de e-mail",
    'server-mail-settings.relay.change' => 'Pentru a permite trimiterea de notificări din Plesk atunci când transmiterea este dezactivată, aveți posibilitatea să %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'să modificați setările SMTP',
    'server-mail-settings.relay.pop3' => "POP3 înainte de SMTP",
    'server-mail-settings.relay.lockTime' => "timp de blocare",
    'server-mail-settings.relay.min' => "min",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Următoarelor rețele nu li se impun restricții de transmitere:',
    'server-mail-settings.relay.noRelayNetworksHint' => "Adresă IP/mască",

    'server-mail-settings.outgoing.title' => 'Limitarea numărului de mesaje de e-mail trimise',
    'server-mail-settings.outgoing.description' => 'Limitele de mai jos sunt cele implicite. Acestea pot fi suprascrise în fiecare plan de servicii și în fiecare abonament. Limitele nu sunt valabile pentru întregul server, ci au rol de șablon pentru planurile și abonamentele în care nu se definesc limite personalizate. Rețineți: activarea limitării numărului de mesaje de e-mail trimise poate afecta performanțele serverului de e-mail.%%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Informații suplimentare despre limitarea numărului de e-mailuri trimise',
    'server-mail-settings.outgoing.enabled' => 'Se limitează numărul de mesaje de e-mail trimise',
    'server-mail-settings.outgoing.countRecipients' => 'Se numără destinatarii, nu mesajele',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Activează modul în care limitele de trimitere de e-mailuri și statisticile se calculează după numărul de destinatari, nu de mesaje. De exemplu, un mesaj trimis la 10 destinatari se numără ca zece mesaje.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Limita implicită a trimiterilor de mesaje dintr-o căsuță poștală (pe oră)',
    'server-mail-settings.outgoing.domainLimit' => 'Limita implicită a trimiterilor de mesaje dintr-un domeniu (pe oră)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Limita implicită a trimiterilor de mesaje pentru un abonament (pe oră)',
    'server-mail-settings.outgoing.unlimited' => 'Nelimitat',
    'server-mail-settings.outgoing.sendmail' => 'Utilizatorii și scripturile pot folosi Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Scripturile și utilizatorii vor putea trimite mesaje de e-mail (în numele utilizatorului de sistem corespunzător abonamentului) prin funcția Sendmail chiar dacă limitele definite pentru o căsuță poștală sau pentru domeniu au fost depășite. Numărul maxim de mesaje care se pot trimite prin Sendmail va fi definit de limita valabilă pentru întregul abonament. Această setarea nu permite utilizarea funcției Sendmail din toate scripturile de pe server, ci are rol de valoare implicită pentru planurile de servicii și pentru abonamente.',
    'server-mail-settings.outgoing.reportPeriod' => 'Se afișează rapoarte cu date statistice din ultima perioadă de',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Se creează rapoartele și se afișează o avertizare în pagina de pornire în legătură cu încercările de a depăși limitele setate pentru trimiterile de mesaje, din perioada specificată.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Se trimite o notificare e-mail la fiecare',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Notificările conțin date statistice despre încercările de a depăși limitele setate pentru trimiterile de mesaje, din perioada specificată.',
    'server-mail-settings.outgoing.periodP1D' => '1 zi',
    'server-mail-settings.outgoing.periodP1W' => '1 săptămână',
    'server-mail-settings.outgoing.periodP2W' => '2 săptămâni',
    'server-mail-settings.outgoing.periodP1M' => '1 lună',
    'server-mail-settings.outgoing.periodPT15M' => '15 minute',
    'server-mail-settings.outgoing.periodPT1H' => '1 oră',
    'server-mail-settings.outgoing.periodPT6H' => '6 ore',
    'server-mail-settings.outgoing.periodPT12H' => '12 ore',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Este posibil ca limitele de trimitere a mesajelor de e-mail să nu funcționeze în cazul programelor de trimitere ale căror adrese apar în lista de permisiuni a serverului de e-mail. De exemplu, dacă gazda localhost (127.0.0.0 / 8, ::1 / 128) se află în lista de permisiuni, toate e-mailurile de le serverul local vor fi trimise cu succes, indiferent de limitări. Programele de trimitere pot folosi adrese IP locale (site-uri web sau scripturi găzduite pe serverul local) sau externe (clienții care trimit mesaje din programe client de e-mail instalate pe propriile computere sau dispozitive mobile). Pentru a putea impune limitele tuturor programelor de trimitere (locale și externe), eliminați din lista de permisiuni toate adresele IP și rețelele. Rețineți: eliminarea gazdei localhost (127.0.0.0 / 8, ::1 / 128) din lista de permisiuni poate împiedica funcționarea site-urilor web și a scripturilor care trimit e-mailuri de pe acest server. Pentru detalii despre limitele impuse trimiterilor de e-mail, consultați Ghidul Administratorului, Protecție împotriva trimiterilor de spam.',
    'server-mail-settings.outgoing.relayIsOpen' => 'Funcția de transmitere a mesajelor de e-mail este deschisă? Limitele de trimitere a mesajelor de e-mail nu vor funcționa.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'Valoarea limitei de mesaje trimise dintr-un domeniu (%%value%%) nu poate fi mai mare decât limita stabilită pentru abonament (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'Valoarea limitei de mesaje trimise de la o adresă de e-mail (%%value%%) nu poate fi mai mare decât limita stabilită pentru domeniu (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'Valoarea limitei de mesaje trimise de la o adresă de e-mail (%%value%%) nu poate fi mai mare decât limita stabilită pentru abonament (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Setări Mailman',
    'server-mail-settings.mailman.secureLinks' => 'Utilizare linkuri securizate în listele de corespondență',
    'server-mail-settings.mailman.secureLinksHint' => 'Activați sau dezactivați generarea de linkuri securizate (HTTPS) în listele de corespondență.',
    'server-mail-settings.mailman.noLocalhost' => 'Pentru a utiliza listele de e-mail, trebuie să aveți localhost (127.0.0.0/8, ::1/128) în lista de permisiuni a serverului de e-mail. În schimb, controlul mesajelor de e-mail trimise este posibil și fără a avea localhost în lista de permisiuni. Ca un compromis, dacă ați activat controlul de mesaje de e-mail trimise, pentru căsuța poștală puteți utiliza redirecționarea în locul listelor de e-mail.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Pentru a utiliza listele de e-mail, trebuie să aveți localhost în lista de permisiuni a serverului de e-mail. În schimb, controlul mesajelor de e-mail trimise este posibil și fără a avea localhost în lista de permisiuni. Ca un compromis, dacă ați activat controlul de mesaje de e-mail trimise, pentru căsuța poștală puteți utiliza redirecționarea în locul listelor de e-mail. Rețineți că în lista de permisiuni de acum nu există adrese IPv4 de localhost (127.0.0.0/8). Drept urmare, controlul trimiterilor de mesaje de e-mail va funcționa pentru adresele IPv4.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Pentru a utiliza listele de e-mail, trebuie să aveți localhost în lista de permisiuni a serverului de e-mail. În schimb, controlul mesajelor de e-mail trimise este posibil și fără a avea localhost în lista de permisiuni. Ca un compromis, dacă ați activat controlul de mesaje de e-mail trimise, pentru căsuța poștală puteți utiliza redirecționarea în locul listelor de e-mail. Rețineți că în lista de permisiuni de acum nu există adrese IPv6 de localhost (::1/128). Drept urmare, controlul trimiterilor de mesaje de e-mail va funcționa pentru adresele IPv6.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Activare DMARC pentru verificarea e-mailurilor primite',
    'server-mail-settings.spam-filter.dmarcHint' => 'Această opțiune este disponibilă atunci când DKIM și SPF sunt activate pentru e-mailurile primite.',
    'server-mail-settings.spam-filter.dkim' => 'Protecție antispam DKIM',
    'server-mail-settings.spam-filter.singOutgoing' => 'Se permite semnarea e-mailurilor trimise',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Se verifică mesajele primite',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Această opțiune nu se poate dezactiva cât timp DMARC este activat pentru e-mailurile primite.',
    'server-mail-settings.spam-filter.spf' => 'Protecție antispam SPF',
    'server-mail-settings.spam-filter.spfEnabled' => 'Activarea protecției antispam SPF pentru e-mailurile primite',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Această opțiune nu se poate dezactiva cât timp DMARC este activat pentru e-mailurile primite.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'Dacă apar probleme la căutarea DNS, verificarea SPF continuă',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'În primul rând, SPF execută o căutare DNS. Selectați această opțiune pentru a continua în cazul în care căutarea DNS nu reușește. Această opțiune se deselectează dacă nu are niciun efect în modul de verificare actual.',
    'server-mail-settings.spam-filter.behavior' => 'Mod de verificare SPF',
    'server-mail-settings.spam-filter.behaviorHint' => 'Ulterior, SPF aplică regulile locale și cele de aproximare Mesajul poate fi respins în funcție de modul de verificare selectat și de rezultatul verificării.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Se creează numai antete de primire SPF, nu se blochează niciodată',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Dacă apar probleme DNS, se utilizează mesaje de eroare temporare',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'E-mailul se refuză dacă rezolvarea SPF duce la „fail” (refuz)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'E-mailul se refuză dacă rezolvarea SPF duce la „softfail”',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'E-mailul se refuză dacă rezolvarea SPF duce la „neutral”',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'E-mailul se refuză dacă rezolvarea SPF nu duce la „pass”',
    'server-mail-settings.spam-filter.localRules' => 'Reguli locale SPF',
    'server-mail-settings.spam-filter.guessRules' => 'Reguli de aproximare SPF',
    'server-mail-settings.spam-filter.explanationText' => 'Text de explicații SPF',
    'server-mail-settings.spam-filter.rbl' => "Protecție antispam cu liste negre DNS",
    'server-mail-settings.spam-filter.rblEnabled' => "Activarea protecției antispam în funcție de listele negre DNS",
    'server-mail-settings.spam-filter.rblServer' => "Zone DNS pentru serviciul DNSBL",
    'server-mail-settings.spam-filter.rblServerHint' => "Separați intrările cu caractere punct și virgulă, de exemplu: „zen.spamhaus.org;dnsbl.example.net”",

    'server-mail-settings.auto-reply-headers.title' => 'Anteturi suplimentare de răspuns automat',
    'server-mail-settings.auto-reply-headers.description' => 'Configurați anteturi suplimentare pentru eventualele mesaje de răspuns automat care vin de pe serverul Plesk.',
    'server-mail-settings.auto-reply-headers.extra' => 'Anteturi suplimentare',

    'server-mail-settings.pop3-names.title' => "Numele conturilor de e-mail POP3/IMAP",
    'server-mail-settings.pop3-names.disabled' => "Nu se pot folosi decât numele complete ale conturilor de e-mail POP3/IMAP",
    'server-mail-settings.pop3-names.enabled' => "Se pot folosi numele scurte (webmaster) și cele complete (webmaster@domeniu.com) ale conturilor de e-mail POP3/IMAP.",

    'server-mail-settings.success' => 'Setările serverului de e-mail au fost modificate.',

    'server-mail-spam-filter.general' => 'General',
    'server-mail-spam-filter.isEnabled' => 'Se activează filtrul antispam SpamAssassin la nivel de server',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin nu este instalat.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'Se activează protecția antispam la nivel de server cu liste gri',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Se aplică setări individuale pentru filtrarea de spam',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "Filtrul antispam este dezactivat: serverul de e-mail nu acceptă setările de filtrare antispam la nivel de căsuță poștală.",
    'server-mail-spam-filter.settings' => 'Setări SpamAssassin',
    'server-mail-spam-filter.maxChildrenTitle' => 'Număr maxim de procese',
    'server-mail-spam-filter.maxChildrenDescription' => 'Numărul maxim de procese spamd care se pot executa.',
    'server-mail-spam-filter.requiredHitsTitle' => 'Punctaj necesar',
    'server-mail-spam-filter.requiredHitsDescription' => 'Punctajul de la care mesajul este considerat spam.',
    'server-mail-spam-filter.maxMailLimit' => 'Fără filtrare dacă e-mailul depășește această dimensiune',
    'server-mail-spam-filter.maxMailLimitText' => 'limită de dimensiune',
    'server-mail-spam-filter.kbytes' => "Kbyți",
    'server-mail-spam-filter.maxThreadsLimit' => 'Numărul de fire de execuție pe care le poate crea filtrul antispam',
    'server-mail-spam-filter.tagTitle' => 'Etichetă de spam',
    'server-mail-spam-filter.tagDescription' => 'Sistemul va adăuga acest text la începutul subiectului fiecărui mesaj considerat a fi spam.',
    'server-mail-spam-filter.alarmMessage' => 'Textul avertizării de spam detectat',
    'server-mail-spam-filter.languages' => 'Limbi de încredere',
    'server-mail-spam-filter.locales' => 'Setări regionale de încredere',
    'server-mail-spam-filter.success' => 'Setările filtrului antispam au fost modificate.',
    'server-mail-spam-filter.personalSettingsWarning' => 'Administratorul de server a dezactivat posibilitatea de a aplica setări de filtrare antispam personale. Setările de filtrare antispam specificate nu vor fi aplicate',

    'service-plan.admin-plan.subscription_section' => 'Comun',
    'service-plan.admin-plan.tools_section' => 'Instrumente și resurse',
    'service-plan.admin-plan.apps_section' => 'Aplicații și baze de date',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Aspect Plesk',
    'service-plan.admin-plan.statistics_section' => 'Statistici',
    'service-plan.admin-plan.general_section' => 'General',
    'service-plan.admin-plan.mail_section' => 'E-mail',
    'service-plan.admin-plan.server_section' => 'Server',
    'service-plan.admin-plan.modules_section' => 'Extensii',
    'service-plan.admin-plan.troubleshooting_section' => 'Asistență și depanare',
    'service-plan.admin-plan.simplePanel' => 'Mod restricționat',
    'service-plan.admin-plan.enabled' => 'Activarea modului restricționat',
    'service-plan.admin-plan.enabledDescription' => 'Selectați această opțiune pentru a limita numărul de acțiuni pe care le poate executa administratorul în Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Selectați această opțiune pentru a limita numărul de acțiuni pe care le poate executa administratorul suplimentar în Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Vor fi disponibile doar aplicațiile pe care le selectez',
    'service-plan.applications-subscription.useFilterDescription' => 'Utilizați această opțiune pentru a selecta aplicațiile care trebuie să fie disponibile abonatului.',
    'service-plan.applications-subscription.applications' => 'Aplicații',
    'service-plan.applications-subscription.isCommercial' => 'Această aplicație este comercială și necesită cumpărarea unei chei de licență.',

    'service-plan.applications.useFilterLabel' => 'Vor fi disponibile doar aplicațiile pe care le selectez',
    'service-plan.applications.useFilterDescription' => 'Utilizați această opțiune pentru a selecta aplicațiile care trebuie să fie disponibile abonatului.',
    'service-plan.applications.applications' => 'Aplicații',
    'service-plan.applications.isCommercial' => 'Această aplicație este comercială și necesită cumpărarea unei chei de licență.',

    'service-plan.dns.dnsZoneType' => 'Zona DNS a domeniului',
    'service-plan.dns.dnsZoneTypeMaster' => 'Principal',
    'service-plan.dns.dnsZoneTypeSlave' => 'Secundar',

    'service-plan.extras.groupOtherServices' => 'Alte servicii',
    'service-plan.extras.none' => 'Fără',

    'service-plan.hosting.enablePhysicalHosting' => 'Se activează găzduirea',
    'service-plan.hosting.sectionCoreHosting' => 'Proprietăți generale',
    'service-plan.hosting.sectionScripting' => 'Scripturi',
    'service-plan.hosting.defaultDatabaseServer' => 'Server de baze de date implicit',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avansat',
    'service-plan.hosting.phpSettingsHelpLink' => 'Aflați cum se aleg cele mai potrivite setări PHP',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Stare site-urilor dacă se suspendă acest abonament',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Starea site-urilor web în abonamentele suspendate',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Starea selectată va fi aplicată tuturor site-urilor web din abonamentele asociate planului în momentul suspendării abonamentului (de exemplu, expiră sau trece perioada plătită).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Starea selectată va fi aplicată site-urilor web în momentul suspendării abonamentului (de exemplu, expiră sau trece perioada plătită).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Dezactivat',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Vizitatorii site-urilor vor fi redirecționați către pagina implicită a serverului web.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Suspendat',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Vizitatorii site-urilor vor fi redirecționați către pagina cu documentul de eroare personalizat, cu codul HTTP 503, care poate fi analizat de motoarele de căutare.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Activ',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Site-urile rămân accesibile prin internet.',

    'service-plan.ip.sharedIpAddresses' => 'Alocare de adrese IP partajate',
    'service-plan.ip.allocateExclusiveIp' => 'Alocare de adrese IP dedicate',
    'service-plan.ip.allocateExclusiveIpV4' => 'Alocare de adrese IPv4 dedicate',
    'service-plan.ip.allocateExclusiveIpV6' => 'Alocare de adrese IPv6 dedicate',

    'service-plan.mail.mailService' => 'Serviciu de e-mail',
    'service-plan.mail.mailServiceDisabled' => 'Dezactivat',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Dezactivat pentru e-mailurile primite',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk nu va asigura niciun serviciu de e-mail în domenii.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Domeniile nu permit decât trimiterea de e-mailuri și numai prin Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Activat',
    'service-plan.mail.mailServiceEnabledHint' => 'Domeniile permit trimiterea și primirea de e-mailuri.',
    'service-plan.mail.mailServiceNotConfigured' => 'Neconfigurat',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk nu va asigura niciun serviciu de e-mail în domenii.',
    'service-plan.mail.webMail' => 'Webmail',
    'service-plan.mail.mailingLists' => 'Activarea listelor de e-mail',
    'service-plan.mail.mailToNonExistentUser' => 'Politica privind mesajele trimise unor utilizator inexistenți',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Se refuză cu mesaj',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Se redirecționează la adresa',
    'service-plan.mail.mailToNonExistentUserReject' => 'Se refuză',
    'service-plan.mail.mailAutodiscovery' => 'Activare descoperire automată e-mail',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Aflați cum funcționează, din <a href="%%link%%" target="_blank">baza de cunoștințe</a>',
    'service-plan.mail.bounceMessage' => 'Această adresă nu mai primește e-mailuri.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Se redirecționează către un server de e-mail extern cu adresa IP',
    'service-plan.mail.webmailDisabled' => '%%webmail%% – dezactivat',

    'service-plan.misc.retainEnabled' => 'Datele statistice despre web și trafic se păstrează timp de',
    'service-plan.misc.logRotation' => 'Se folosește rotația fișierelor jurnal',
    'service-plan.misc.logRotationCondition' => 'Condiție de rotație a jurnalelor',
    'service-plan.misc.logRotationBySize' => 'În funcție de dimensiune',
    'service-plan.misc.logRotationByTime' => 'În funcție de timp',
    'service-plan.misc.logRotationDaily' => 'Zilnic',
    'service-plan.misc.logRotationWeekly' => 'Săptămânal',
    'service-plan.misc.logRotationMonthly' => 'Lunar',
    'service-plan.misc.logRotationSizeDescription' => 'Valoarea dimensiunii trebuie să fie cuprinsă între %%min%% și %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Număr maxim de fișiere jurnal',
    'service-plan.misc.compress' => 'Fișierele jurnal se comprimă',
    'service-plan.misc.sendLogToEmail' => 'După ce Plesk preia datele din fișierele jurnal ale serverelor web și FTP, acestea se trimit prin e-mail la următoarea adresă',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'luni',
    'service-plan.misc.logRotationPeriodGreater' => 'Perioada de rotație a jurnalelor nu poate fi mai lungă decât limita setată la nivel de server, %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Dacă opțiunea este dezactivată, toate site-urile web asociate unui abonament utilizează aceeași listă de aplicații IIS dedicată abonamentului.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Selectarea serviciilor și a privilegiilor furnizate cu abonamentul.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Se afișează mai multe permisiuni disponibile',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Se afișează mai puține permisiuni',
    'service-plan.permissions-subscription.noShellManagement' => 'Nu se permite',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Administrarea accesului la server prin SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Clienții pot activa SSH pentru propriul utilizator de sistem. Conferă parametrului de găzduire „Acces prin SSH la shellul de pe server pentru utilizatorul de sistem al abonamentului” rol de presetare.',

    'service-plan.permissions.permissionsTabDescription' => 'Selectați serviciile și permisiunile furnizate cu planul.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Selectarea serviciilor și a privilegiilor care vor fi adăugate la abonamente cu acest plan add-on. Rețineți: permisiunile neselectate în add-on nu vor modifica în niciun fel parametrii de abonament.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Permisiunile le asigură clienților posibilitatea de a modifica anumite setări ale abonamentelor lor. La crearea abonamentului, Plesk folosește valorile implicite din plan pentru setările pe care clientul le poate schimba. Actualizarea ulterioară sau aplicarea unui plan add-on nu suprascrie schimbările făcute de client.',
    'service-plan.permissions.showMorePermissions' => 'Se afișează mai multe permisiuni disponibile',
    'service-plan.permissions.hideMorePermissions' => 'Se afișează mai puține permisiuni',
    'service-plan.permissions.noShellManagement' => 'Nu se permite',
    'service-plan.permissions.systemAccessLabel' => 'Administrarea accesului la server prin SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Conferă parametrului de găzduire „Acces prin SSH la shellul de pe server pentru utilizatorul de sistem al abonamentului” rol de presetare.',

    'service-plan.resources-subscription.overusePolicy' => 'Politică de suprautilizare',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Nu se permite suprautilizarea',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Interzicerea suprautilizării de resurse. Abonamentul se suspendă automat dacă utilizarea resurselor depășește anumite valori limită.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Se permite suprautilizarea spațiului pe disc și a traficului',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Autorizarea suprautilizării spațiului pe disc și a traficului. Interzicerea suprautilizării celorlalte resurse.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Se permite suprautilizarea (nerecomandat)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Abonatului i se permite să utilizeze mai multe resurse decât cele alocate inițial prin abonament.',
    'service-plan.resources-subscription.overuseNotify' => 'În caz de suprautilizare doresc să primesc o notificare prin e-mail.',
    'service-plan.resources-subscription.oversellPolicy' => 'Politică de supravânzare',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Se permite supravânzarea',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Supravânzarea îi permite resellerului să vândă mai multe resurse decât are alocate prin abonament. Dacă supravânzarea este permisă, activitatea resellerului este reglementată în funcție de utilizarea efectivă a resurselor, nu de alocarea inițială.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Nu se permite supravânzarea',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Dacă supravânzarea nu este permisă, resellerul nu poate vinde resurse decât în limitele disponibilului care i s-a alocat prin abonament, indiferent de volumele utilizate efectiv.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Definirea limitelor de utilizare a resurselor furnizate cu abonamentul.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Se afișează mai multe resurse disponibile',
    'service-plan.resources-subscription.hideMoreResources' => 'Se afișează mai puține resurse',

    'service-plan.resources.overusePolicy' => 'Politică de suprautilizare',
    'service-plan.resources.overusePolicyNotAllowed' => 'Nu se permite suprautilizarea',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Interzicerea suprautilizării de resurse. Abonamentul se suspendă automat dacă utilizarea resurselor depășește anumite valori limită.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Se permite suprautilizarea spațiului pe disc și a traficului',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Autorizarea suprautilizării spațiului pe disc și a traficului. Interzicerea suprautilizării celorlalte resurse.',
    'service-plan.resources.overusePolicyAllowed' => 'Se permite suprautilizarea (nerecomandat)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Clienților li se permite să utilizeze mai multe resurse decât cele alocate inițial în plan.',
    'service-plan.resources.overuseNotify' => 'În caz de suprautilizare doresc să primesc o notificare prin e-mail.',
    'service-plan.resources.oversellPolicy' => 'Politică de supravânzare',
    'service-plan.resources.oversellPolicyAllowed' => 'Se permite supravânzarea',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Supravânzarea îi permite resellerului să vândă mai multe resurse decât are alocate prin plan. Dacă supravânzarea este permisă, activitatea resellerului este reglementată în funcție de utilizarea efectivă a resurselor, nu de alocarea inițială.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Nu se permite supravânzarea',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Dacă supravânzarea nu este permisă, resellerul nu poate vinde resurse decât în limitele disponibilului care i s-a alocat prin plan, indiferent de volumele utilizate efectiv.',
    'service-plan.resources.mainGroupTitle' => 'Definirea resurselor oferite cu planul.',
    'service-plan.resources.additionalGroupTitle' => 'Se afișează mai multe resurse disponibile',
    'service-plan.resources.hideMoreResources' => 'Se afișează mai puține resurse',
    'service-plan.resources.allowSitebuilderUpsell' => 'Clientului i se permite să creeze site-uri de încercare cu Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Această setare le permite clienților să creeze mai multe site-uri Presence Builder decât prevede planul de servicii. Clientul va trebui să cumpere site-urile respective pentru a le putea publica.',

    'service-plan.servicePlanName' => 'Nume plan de servicii',
    'service-plan.resellerPlanName' => 'Nume plan reseller',
    'service-plan.addonPlanName' => 'Nume plan add-on',
    'service-plan.adminPlanPermissionsTab' => 'Instrumente administrative',
    'service-plan.adminPlanPermissionsTabDescription' => 'Selectați caracteristicile care vor fi accesibile administratorului atunci când modul restricționat este activat.',
    'service-plan.hostingPermissionsTab' => 'Instrumente de găzduire',
    'service-plan.hostingPermissionsTabDescription' => 'Selectați instrumentele și setările de găzduire web accesibile administratorului în vizualizarea de utilizator privilegiat, atunci când modul restricționat este activat.',
    'service-plan.resourcesTab' => 'Resurse',
    'service-plan.resourcesTabDescription' => 'Definirea resurselor oferite cu planul și a politicii legate de utilizarea resurselor.',
    'service-plan.subscriptionResourcesTabDescription' => 'Definirea resurselor oferite cu abonamentul și a politicii legate de utilizarea resurselor.',
    'service-plan.hostingTab' => 'Parametri de găzduire',
    'service-plan.hostingTabDescription' => 'Specificarea parametrilor serviciului de găzduire oferit cu planul. Rețineți: setările de găzduire specificate în planul add-on nu se aplică abonamentelor cărora li s-a acordat permisiunea „Administrarea setărilor de găzduire” fie prin planul de servicii, fie prin planul add-on.',
    'service-plan.secureSettingsDescription' => 'Dacă doriți să oferiți servicii de găzduire la cel mai înalt nivel de securitate, %%link%%. Rețineți că, dacă au anumite permisiuni, abonații pot modifica aceste setări. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'aplicați presetarea de setări securizate',
    'service-plan.secureSettingsHelpLink' => 'Informații despre setarea de găzduire securizată',
    'service-plan.mailTab' => 'E-mail',
    'service-plan.mailTabDescription' => 'Specificarea parametrilor serviciului de e-mail oferit cu planul.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Specificarea parametrilor serviciului DNS oferit cu planul.',
    'service-plan.performanceTab' => 'Performanță',
    'service-plan.performanceTabDescription' => 'Specificarea parametrilor de sistem care afectează performanțele tuturor serviciilor furnizate conform planului.',
    'service-plan.permissionsTab' => 'Permisiuni',
    'service-plan.miscTab' => 'Jurnale și statistici',
    'service-plan.miscTabDescription' => 'Specificarea modului de stocare a statisticilor și a jurnalelor abonamentelor asociate planului. Rețineți că aceste setări nu se sincronizează în abonamente.',
    'service-plan.miscTabAdminPlanDescription' => 'Specificați modul în care se vor stoca datele statistice și jurnalele.',
    'service-plan.extrasTab' => 'Servicii suplimentare',
    'service-plan.extrasTabDescription' => 'Selectarea serviciilor care trebuie incluse în plan, în afară de găzduirea, DNS și serviciile de e-mail.',
    'service-plan.ipTab' => 'Adrese IP',
    'service-plan.ipTabDescription' => 'Definirea parametrilor de resurse IP oferite cu planul.',
    'service-plan.applicationsTab' => 'Aplicații',
    'service-plan.applicationsTabDescription' => 'Selectarea aplicațiilor care trebuie să fie disponibile în plan. Puteți alege să oferiți toate aplicațiile disponibile din catalogul de aplicații, plus cele pe care le încărcați pe server. De asemenea, puteți selecta manual aplicațiile. Dacă doriți să oferiți toate aplicațiile disponibile, nu trebuie să faceți nimic în această filă, doar să accesați fila Permisiuni și să selectați opțiunea Acces la catalogul de aplicații. Dacă doriți să selectați manual aplicațiile, o puteți face în această filă.',
    'service-plan.applicationsTabDescription-addon' => 'Selectarea aplicațiilor care trebuie să fie disponibile în add-on.',
    'service-plan.applicationsTabDescription-subscription' => 'Selectarea aplicațiilor care trebuie să fie disponibile în abonament. Puteți alege să oferiți toate aplicațiile disponibile din catalogul de aplicații, plus cele pe care le încărcați pe server. De asemenea, puteți selecta manual aplicațiile. Dacă doriți să oferiți toate aplicațiile disponibile, nu trebuie să faceți nimic în această filă, doar să accesați fila Permisiuni și să selectați opțiunea Acces la catalogul de aplicații. Dacă doriți să selectați manual aplicațiile, o puteți face în această filă.',
    'service-plan.planSyncSubsriptionWarning' => 'Unele abonamente nu au fost sincronizate cu planul. Acestea au fost marcate cu „Nesincronizat” în lista de abonamente. Pentru a face o nouă tentativă de sincronizare, accesați pagina de prezentare generală a abonamentului și faceți clic pe butonul Sincronizare.',
    'service-plan.planSyncResellerWarning' => 'Unii reselleri nu au fost sincronizați cu planul. Aceștia au fost marcați cu „Nesincronizat” în lista de reselleri. Pentru a face o nouă tentativă de sincronizare, accesați pagina de prezentare generală a resellerului și faceți clic pe butonul Sincronizare.',
    'service-plan.planSyncAdminWarning' => 'Nu se pot face modificările în abonamente, pentru că unele dintre serviciile sau resursele afectate de schimbări nu sunt furnizate de Plesk. Motivul: %%reason%%',
    'service-plan.duplicateName' => 'Deja există un plan cu acest nume.',
    'service-plan.phpSettingsTab' => 'Setări PHP',
    'service-plan.phpHandlerNotFound' => 'Imposibil de preluat informații despre versiunea PHP a planului. Reinstalați-o sau selectați o altă versiune PHP pentru planul de servicii.',
    'service-plan.phpHandlerNotRegistered' => "Versiunea PHP %%fullVersion%% nu este instalată. În domeniile care folosesc acest plan de servicii nu se pot folosi scripturi PHP. Instalați <nobr>versiunea de PHP %%fullVersion%%</nobr> sau selectați o altă versiune PHP pentru planul de servicii.",

    'service-plan.phpSettingsTabDescription' => 'Aici puteți specifica, pentru fiecare abonament, setările PHP care să aibă prioritate față de cele definite în fișierul php.ini la nivel de server. Această funcție poate fi utilă, de exemplu, în cazul în care doriți să impuneți limite consumului de resurse de sistem prin scripturi PHP ale clienților. Clienții (dacă li se acordă acest drept) pot suprascrie această configurare PHP prin propriile setări la nivel de domeniu. Dacă setați un parametru la valoarea implicită, PHP va prelua valoarea corespunzătoare din configurația PHP la nivel de server. Rețineți că se acceptă substituenții de mai jos: {DOCROOT} și {WEBSPACEROOT} reprezintă directorul rădăcină pentru documente al unui domeniu, respectiv directorul rădăcină al unui abonament cu configurație PHP personalizată; {TMP} reprezintă directorul în care se păstrează fișierele temporare.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Aici puteți specifica, pentru fiecare abonament, setările PHP care să aibă prioritate față de cele definite în planul de servicii principal. Acesta poate fi util, de exemplu, dacă doriți să eliminați anumite limitări PHP setate prin planul de servicii principal. Dacă setați un parametru la valoarea implicită, PHP va prelua valoarea corespunzătoare din configurația PHP aferentă planului de servicii. Rețineți că se acceptă substituenții de mai jos: {DOCROOT} și {WEBSPACEROOT} reprezintă directorul rădăcină pentru documente al unui domeniu, respectiv directorul rădăcină al unui abonament cu configurație PHP personalizată; {TMP} reprezintă directorul în care se păstrează fișierele temporare.',
    'service-plan.phpSettingsPhpVersion' => 'Utilizați versiunea de PHP %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Aici puteți specifica, pentru fiecare abonament, setările PHP care să aibă prioritate față de cele definite în fișierul php.ini la nivel de server. Dacă setați un parametru la valoarea implicită, PHP va prelua valoarea corespunzătoare din configurația PHP la nivel de server.',
    'service-plan.webServerSettingsTab' => 'Server web',
    'service-plan.webServerSettingsTabDescription' => 'Aici puteți specifica setările serverului web Apache pentru acest plan de servicii. Dacă Apache funcționează cu nginx ca server frontend, în această pagină puteți specifica și setările nginx. Toate domeniile nou create vor primi setările specificate. Cu toate acestea, dacă modificați acestea setări, domeniile existente nu vor fi afectate de schimbări.',
    'service-plan.servicesTab' => 'Servicii',
    'service-plan.servicesTabDescription' => 'Aici puteți specifica serviciile atribuite planului de servicii.',
    'service-plan.servicePropertiesTab' => 'Proprietăți %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Aici puteți specifica proprietățile serviciului %%serviceName%%, atribuite planului de servicii.',
    'service-plan.longTaskWarning' => 'Aveți %%subscriptionsCount%% abonamente cu acest plan. Rețineți: sarcina de sincronizare poate necesita mult timp și va fi executată în fundal.',
    'service-plan.hostingParametersTab' => 'Parametri de găzduire',
    'service-plan.adminInfoSection' => 'Informații pentru administrator',
    'service-plan.descriptionInPanel' => 'Descriere',
    'service-plan.longDescription' => 'Descrierea specificată este prea lungă.',
    'service-plan.conflictPermissions' => 'Imposibil de acordat următoarele permisiuni, din cauza unui conflict cu planul de reseller: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Tip de pornire',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automat',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manual',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Oprire',
    'services.change-startup-type.autoActionError' => 'Tipul de pornire nu se poate seta la „automat”: %%error%%',
    'services.change-startup-type.manualActionError' => 'Tipul de pornire nu se poate seta la „manual”: %%error%%',
    'services.change-startup-type.disableActionError' => 'Tipul de pornire nu se poate seta la „dezactivat”: %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Resetare la valoarea implicită',
    'sessions.settings.restoreDefaultButtonDescription' => 'Parametrii de sesiune se readuc la valorile implicite.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Parametrii de sesiune au valorile implicite.',
    'sessions.settings.idleTime' => 'Timp de inactivitate sesiune',
    'sessions.settings.disableCheckSessionIp' => 'Se permite modificarea adresei IP în timpul unei sesiuni',
    'sessions.settings.minuteShortTitle' => 'min',

    'settings-ui.controls.title' => 'Controale',

    'settings-ui.interface-views.description' => "Aveți la dispoziție mai multe vizualizări ale interfeței de produs. În funcție de vizualizarea aleasă, funcțiile și setările pot fi dispuse diferit și pot fi activate/dezactivate. Diferitele vizualizări se potrivesc unor tipuri de utilizatori diferite.",
    'settings-ui.interface-views.panelSimpleLink' => 'Instrumente și setări> Setările modului restricționat',
    'settings-ui.interface-views.useCustomView' => 'Activarea modului restricționat',
    'settings-ui.interface-views.useCustomViewHint' => 'Selectați această opțiune pentru a limita numărul de acțiuni pe care le poate executa administratorul în Panoul Plesk. Pentru a modifica disponibilitatea acțiunilor, accesați %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Această vizualizare este optimă pentru administrarea de site-uri, fișiere, baze de date, conturi de e-mail, aplicații web și de alte servicii.',
    'settings-ui.interface-views.selectUiModeTitle' => "Selectați interfața",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Vizualizarea de utilizatori avansați (pentru dezvoltatori și agenții web)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Vizualizarea de furnizor de servicii (pentru furnizorii de servicii de găzduire web)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Această vizualizare este destinată administratorilor de server care furnizează și vând servicii de găzduire web clienților, prin intermediul planurilor de servicii.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Ascundere controale de refuzuri',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Ascunde butonul care permite configurarea procesării e-mailurilor trimise la adrese inexistente',

    'settings-ui.branding.description' => 'Adaptați interfața Plesk la marca proprie: schimbați aspectul paginii în bara de titlu a browserului și/sau înlocuiți sigla Plesk din colțul din stânga, sus.',
    'settings-ui.branding.buttonDefault' => 'Siglă implicită',
    'settings-ui.branding.sectionTitle' => 'Titlu personalizat',
    'settings-ui.branding.enableCustomTitle' => 'Activare titlu personalizat pentru paginile Plesk',
    'settings-ui.branding.customTitle' => 'Textul titlului',
    'settings-ui.branding.sectionLogo' => 'Siglă personalizată',
    'settings-ui.branding.enableCustomLogo' => 'Activare siglă de panou personalizată',
    'settings-ui.branding.logo' => 'Fișier siglă',
    'settings-ui.branding.logoUrl' => 'URL siglă',
    'settings-ui.branding.logoUrlEnabled' => 'Personalizat',
    'settings-ui.branding.logoUrlDisabled' => 'Implicit',
    'settings-ui.branding.sectionFavicon' => 'Favicon personalizat',
    'settings-ui.branding.enableCustomFavicon' => 'Activare favicon personalizat',
    'settings-ui.branding.sectionFaviconDesc' => 'Același favicon a fost încărcat în ambele formate, pentru o mai bună compatibilitate cu diferitele browsere.',
    'settings-ui.branding.faviconSvg' => 'Fișier favicon SVG',
    'settings-ui.branding.faviconSvgHint' => 'Format acceptat: SVG',
    'settings-ui.branding.faviconIco' => 'Fișier favicon ICO',
    'settings-ui.branding.faviconIcoHint' => 'Format acceptat: ICO',
    'settings-ui.branding.show' => 'Afișare',
    'settings-ui.branding.updateSuccess' => 'Proprietățile de branding ale sistemului Plesk au fost modificate.',
    'settings-ui.branding.sectionBackground' => 'Fundal personalizat',
    'settings-ui.branding.enableCustomBackground' => 'Activare imagine de fundal',
    'settings-ui.branding.backgroundFile' => 'Imagine de fundal',
    'settings-ui.branding.backgroundColor' => 'Culoare fundal',
    'settings-ui.branding.backgroundResetColor' => 'Resetare',
    'settings-ui.branding.backgroundFit' => 'Potrivire fundal',
    'settings-ui.branding.background.fit.fill' => 'Umplere ecran',
    'settings-ui.branding.background.fit.fit' => 'Potrivire pe ecran',
    'settings-ui.branding.background.fit.center' => 'Centrare',
    'settings-ui.branding.background.fit.tile' => 'Dale',

    'sitebuilder.trial.description' => 'Această pagină vă permite să configurați modul Încercare și cumpărare (fostul scenariu Achiziție de către client). În acest mod, clientul poate crea un site web cu toate funcțiile disponibile în aplicația Presence Builder inclusă. Cu toate acestea, clientul nu poate publica site-urile de încercare până când nu cumpără un plan de servicii de găzduire sau un plan add-on. Modul Încercare și cumpărare se poate acorda și clienților existenți, prin intermediul unui plan de găzduire și al unui plan add-on. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Pentru informații suplimentare, consultați documentația.',
    'sitebuilder.trial.lifetimeLabel' => 'Durata de viață a site-urilor de încercare',
    'sitebuilder.trial.lifetimeUnits' => 'zile',
    'sitebuilder.trial.lifetimeDescription' => 'Site-urile de încercare necumpărate de clienți sunt șterse de pe server după trecerea acestei perioade de timp.',
    'sitebuilder.trial.signupLabel' => 'Activare acces public la modul de încercare',
    'sitebuilder.trial.signupDescription' => 'Dacă doriți să atrageți clienți prin promovarea găzduirii cu Presence Builder și prin oferirea unei versiuni demo a Presence Builder, activați accesul public la modul de încercare și publicați pe site URL-ul de acces la modul respectiv.',
    'sitebuilder.trial.signupLinkLabel' => 'URL de acces la modul de încercare',
    'sitebuilder.trial.signupLinkDescription' => 'Acest URL va deschide Presence Builder în modul de încercare. Publicați acest URL pe site pentru a promova găzduirea cu Presence Builder și pentru a atrage clienți.',
    'sitebuilder.trial.promotionLabel' => 'Afișarea unei notificări în editorul Presence Builder în legătură cu modul de încercare',
    'sitebuilder.trial.promotionDescription' => 'Utilizați această opțiune dacă doriți să afișați o notificare suplimentară despre funcționarea Presence Builder în modul de încercare.',

    'update-settings.policyHintForPum' => 'Aici puteți configura instalarea automată a actualizărilor. Se pot trimite e-mailuri de notificare atunci când actualizările devin disponibile pentru instalare manuală sau au fost instalate automat.',
    'update-settings.policyHint' => 'Se pot trimite e-mailuri de notificare atunci când actualizările devin disponibile pentru instalare manuală sau au fost instalate automat.',
    'update-settings.branchDisabledDescription' => 'Nu doresc notificare despre actualizările disponibile',
    'update-settings.automaticPatchesInstallation' => 'Instalarea automată a actualizărilor Plesk (recomandat)',
    'update-settings.automaticPatchesThirdParty' => 'Instalarea automată a actualizărilor componentelor de la terțe părți livrare cu Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Instalarea automată a actualizărilor de pachete de sistem',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Rețineți faptul că și actualizările componentelor de la terțe părți, livrate de Plesk, se vor instala automat',
    'update-settings.installerProxyMode' => 'Accesare Plesk Installer prin numele de gazdă Plesk și portul corespunzător',
    'update-settings.installerProxyModeHint' => 'Accesarea interfeței web Plesk Installer fără a deschide în plus portul TCP 8447 în firewall.',
    'update-settings.automaticPatchesNotification' => 'Se trimite notificare despre actualizările de pachete sistem disponibile, respectiv instalate',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Adresă e-mail',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Frecvența e-mailurilor de notificare',
    'update-settings.daily' => 'Zilnic',
    'update-settings.weekly' => 'Săptămânal',
    'update-settings.generalSection' => 'General',
    'update-settings.notificationsSection' => 'Notificări',
    'update-settings.safeUpdatesSection' => 'Actualizări sigure',
    'update-settings.safeUpdatesSectionHint' => 'Plesk asigură instalarea actualizărilor de pachetele sistem din depozitul din care s-a făcut instalarea inițială a acestora. Asemenea actualizări sunt considerate sigure. Dacă dezactivați actualizările sigure, este posibil ca managerul de pachete din sistem să instaleze actualizările din orice depozit din sistem.',
    'update-settings.safeUpdatesSectionWarn' => 'Vă recomandăm să nu dezactivați actualizările sigure, decât dacă sunteți utilizator avansat. Actualizările necontrolate ale pachetelor de sistem, din diferite depozite, pot afecta negativ funcționarea serverului.',
    'update-settings.allowSafeUpdates' => 'Activarea actualizării sigure a pachetelor de sistem',

    'requiredFields' => 'Câmpuri obligatorii',
];