<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Доступ заборонено. Ваш обліковий запис призупинено.",
    'login_up__login_has_been_locked' => "Ви спробували увійти за допомогою невірного паролю занадто багато разів. З міркувань безпеки якийсь час ви не зможете входити під цим користувачем.",
    'login_up__unable_to_check_pass' => "Неможливо перевірити пароль: %1",
    'login_up__warning_limits_licence_key' => "Один з наступних пунктів вийшов за межі, визначені вашим ліцензійним ключем: кількість користувацьких облікових записів, доменів, поштових облікових записів або веб-користувачів, розташованих на вашому сервері.\nЗверніться до торгового відділу Plesk, щоб купити ключ, який дозволить вам розташувати бажану кількість користувачів і доменів. Зверніться до відділу технічної підтримки Plesk, якщо вважаєте, що отримали цього листа помилково.\nЛіцензійне обмеження для користувацьких облікових записів/доменів/поштових облікових записів/веб-користувачів/мовних пакетів: %2.\nКількість розміщених на даний момент користувацьких облікових записів/доменів/поштових облікових записів/веб-користувачів/мовних пакетів: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Об’єм ресурсів, з яким ви працюєте, вийшов за межі, визначені вашою поточною ліцензією на продукт. Зверніться до торгового відділу Plesk та купіть новий ліцензійний ключ.",
    'login_up__grace_period' => 'Зараз ви працюєте у пільговому періоді ліцензії на продукт. Щоб оновити ліцензію, виберіть опцію «Отримати ключі» на сторінці %1Інформація про ліцензію%2.',
    'login_up__partner_license_message' => 'Зараз ви працюєте з обмеженою ліцензією на продукт, яка вимагає реєстрації перед активацією повного набору функцій. Щоб оновити ліцензію на продукт, виберіть опцію «Отримати ключі» на сторінці %1Інформація про ліцензію%2.',
    'login_up__system_admin_disabled' => 'З міркувань безпеки суперкористувачу (обліковий запис root або обліковий запис з правами адміністратора) заборонено входити до Plesk.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Посібник адміністратора Plesk.",
    'plesk_guide_reseller' => "Посібник посередника Plesk.",
    'plesk_guide_client' => "Посібник замовника Plesk.",
    'plesk_guide_domain_admin' => "Посібник адміністратора домену Plesk.",
    'plesk_guide_mailuser' => "Посібник користувача електронної пошти Plesk.",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Пошук', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Замовники',
    'ui__reseller_unknown__quick-search' => 'Посередники',
    'ui__client/domain_unknown__quick-search' => 'Домени',
    'nav__general' => 'Головне меню',
    '__home' => 'Головна сторінка',
    '__resellers' => 'Посередники',
    '__clients' => 'Замовники',
    '__domains' => 'Домени',
    '__applications' => 'Застосунки',
    '__settings' => 'Налаштування',
    'nav__system' => 'Система',
    '__master' => 'Майстер',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Верхній рівень',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Видалити',
    'bt_make_default' => 'Встановіть за замовчуванням',

    // common list object operation errors
    'class_cList__empty_selection' => 'Не вибрано жодні об’єкти.',

    // common list object search keys
    'clist__search_show' => 'Показати пошук',
    'clist__search_hide' => 'Сховати пошук',

    'bt_show_all' => "Скинути параметри пошуку",

    // common object list info keys
    'clist__first' => 'Перша',
    'clist__last' => 'Остання',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Сторінки',
    'clist__page_size' => 'Записів на сторінці',
    'clist__info' => 'Усього %1: %4',
    'clist__info_empty' => 'Немає %1',
    'clist__info_filter' => '%5 %1 знайдено (%4 в цілому)',
    'clist__info_paging' => 'в цілому %2-%3 %1 з %4',
    'clist__info_paging_filter' => '%2-%3 %1 з %5 знайдено (%4 в цілому)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Працює',
    '__object_off' => 'Призупинений',

    '__home_description' => 'Повернутись до головної сторінки.',
    'indicator_title' => '%1% використано, %2% вільно', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Надіслано запит на недійсний URL.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Облікові записи посередника",
    'ui__reseller_unknown__title' => "Облікові записи посередника",
    'ui__reseller_unknown__description' => "Управляти обліковими записами посередника.",
    'ui__reseller/client_unknown__short-title' => 'Облікові записи замовника',
    'ui__reseller/client_unknown__title' => 'Облікові записи замовника',
    'ui__reseller/client_unknown__description' => 'Управляти обліковими записами замовника.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Облікові записи додаткового адміністратора", // PFW
    'ui__admin-alias_unknown__short-title' => "Облікові записи додаткового адміністратора", // PFW
    'ui__admin-alias_unknown__description' => "Перегляд та управління обліковими записами додаткового адміністратора.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Загальносерверні параметри пошти",
    'ui__server/mail__title' => "Загальносерверні параметри пошти",
    'ui__server/mail__description' => "Встановити ваш поштовий сервер та конфігурувати глобальні поштові налаштування.",
    'ui__server/dns__short-title' => 'Налаштування DNS',
    'ui__server/dns__title' => 'Налаштування DNS',
    'ui__server/dns__description' => 'Переглянути та оновити глобальні налаштування DNS.',
    'ui__server/services__title' => 'Управління сервісами',
    'ui__server/services__description' => 'Запустити, зупинити або перезапустити сервіси Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Заплановані завдання',
    'ui__server/crontab/task_unknown__title' => 'Заплановані завдання',
    'ui__server/crontab/task_unknown__description' => 'Додати та видалити глобальні заплановані завдання.',
    'ui__server/ip-address_unknown__short-title' => 'ІР-адреси',
    'ui__server/ip-address_unknown__title' => 'ІР-адреси',
    'ui__server/ip-address_unknown__description' => 'Переглянути, редагувати та видалити ІР-адреси, назначити ІР-адреси посередникам.',
    // dropdowns
    'ui__server/time__title' => 'Системний час',
    'ui__server/time__short-title' => 'Системний час',
    'ui__server/time__description' => 'Змінити системні дату та час, встановити синхронізацію з NTP-сервером.',
    'ui__server/maillists__title' => 'Встановити сервер поштових розсилань', // PFU
    'ui__server/maillists__short-title' => 'Встановити сервер поштових розсилань', // PFU
    'ui__server/maillists__description' => 'Встановити сервер поштових розсилань Mailman.', // PFU
    'ui__mass-email__short-title' => "Масові електронні повідомлення", // PFW
    'ui__mass-email__title' => "Масові електронні повідомлення", // PFW
    'ui__mass-email__description' => "Відправити електронні повідомлення декільком користувачам одночасно.", // PFW
    'ui__mass-mail__title' => 'Масові електронні повідомлення', // PFU
    'ui__mass-mail__short-title' => 'Масові електронні повідомлення', // PFU
    'ui__mass-mail__description' => 'Відправити електронні повідомлення декільком користувачам одночасно.', // PFU
    'ui__server/spam-filter__title' => 'Налаштування спам-фільтру',
    'ui__server/spam-filter__short-title' => 'Налаштування спам-фільтру',
    'ui__server/spam-filter__description' => 'Встановити глобальний спам-фільтр.',
    'ui__server/preferences__title' => "Налаштування сервера",
    'ui__server/preferences__short-title' => "Налаштування сервера",
    'ui__server/preferences__description' => "Встановити лічильник глобальної статистики, змінити ім’я хосту сервера та змінити інші налаштування сервера.",

    // help & support
    // icons
    'ui__support__short-title' => 'Підтримка',
    'ui__support__title' => 'Підтримка',
    'ui__support__description' => 'Подати запит до служби технічної підтримки або переглянути запити до служби підтримки, створені вашими замовниками.',
    'ui__license__short-title' => 'Інформація про ліцензію',
    'ui__license__title' => 'Інформація про ліцензію Plesk',
    'ui__license__description' => 'Переглянути інформацію про ліцензію вашого Plesk та замовити нові ліцензійні ключі.',
    'ui__help__short-title' => 'Довідка',
    'ui__help__title' => 'Довідкова онлайн-система',
    'ui__help__description' => 'Переглянути довідкову онлайн-систему.',
    'ui__news__short-title' => "Що нового?",
    'ui__news__title' => "Що нового?",
    'ui__news__description' => "Переглянути список змін у цій версії Plesk.",
    'ui__server/autoinstaller__short-title' => 'Оновлення',
    'ui__server/autoinstaller__title' => 'Оновлення',
    'ui__server/autoinstaller__description' => 'Оновити Plesk і його компоненти.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Домени',
    'ui__client/domain_unknown__title' => 'Домени',
    'ui__client/domain_unknown__description' => 'Управління доменами.',
    'ui__server/skeleton__short-title' => 'Шаблон віртуального хосту',
    'ui__server/skeleton__title' => 'Шаблон віртуального хосту',
    'ui__server/skeleton__description' => 'Вказати файли та папки, які потрібно перенести до каталогів новостворених доменів.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Призначити нового власника для підписок',
    'ui__client/domain/chowner_multi-select__short-title' => 'Призначити нового власника підписки',
    'ui__client/domain/chowner_multi-select__description' => 'Призначити нового власника для вибраних підписок',
    'ui__client/domain/disable_multi__title' => 'Призупинити домени',
    'ui__client/domain/disable_multi__short-title' => 'Призупинити домени',
    'ui__client/domain/disable_multi__description' => 'Призупинити вибрані домени',
    'ui__client/domain/enable_multi__title' => 'Активувати домени',
    'ui__client/domain/enable_multi__short-title' => 'Активувати домени',
    'ui__client/domain/enable_multi__description' => 'Активувати вибрані домени',

    // icons
    'ui__admin/extras-domain__short-title' => 'Інструменти MyPlesk.com.',
    'ui__admin/extras-domain__title' => 'Інструменти MyPlesk.com.',
    'ui__admin/extras-domain__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    'ui__server/sitebuilder__short-title' => 'Налаштування Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Налаштування Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Налаштування Presence Builder для редагування веб-сайтів, розміщених на цьому сервері.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Зареєструвати домен',
    'ui__admin/register-domain__short-title' => 'Зареєструвати домен',
    'ui__admin/register-domain__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Управління доменом',
    'ui__admin/manage-domain__short-title' => 'Управління доменом',
    'ui__admin/manage-domain__description' => 'Управління зареєстрованими іменами доменів на MyPlesk.com.',
    'ui__server/register__title' => 'Зареєструвати ваш сервер',
    'ui__server/register__short-title' => 'Зареєструвати сервер',
    'ui__server/register__description' => 'Зареєструвати ваш сервер для приєднання до партнерської програми',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Журнал операцій',
    'ui__actionlog__title' => 'Журнал операцій',
    'ui__actionlog__description' => 'Завантажте журнал реєстрації операцій для налаштування параметрів реєстрації операцій.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Інформація сервера',
    'ui__server/statistics__title' => 'Інформація сервера',
    'ui__server/statistics__description' => 'Статистика з сервісів, якими управляє Plesk.',
    'ui__admin/report__title' => 'Зведений звіт',
    'ui__admin/report__short-title' => 'Зведений звіт',
    'ui__admin/report__description' => 'Переглянути звіт з використання трафіку та ресурсів для посередників, замовників та доменів.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Час очікування сеансу.',
    'ui__sessions/properties__title' => 'Час очікування сеансу.',
    'ui__sessions/properties__description' => 'Встановити час простою для сеансів Plesk.',
    'ui__cp-access__short-title' => 'Доступ до Plesk',
    'ui__cp-access__title' => 'Доступ до Plesk',
    'ui__cp-access__description' => 'Обмежити доступ до Plesk.',
    'ui__sessions__short-title' => 'Активні сеанси',
    'ui__sessions__title' => 'Активні сеанси',
    'ui__sessions__description' => 'Переглянути активні сеанси Plesk.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Сертифікати SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Сертифікати SSL/TLS',
    'ui__server/certificate_unknown__description' => 'Список сертифікатів SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Особисті дані',
    'ui__admin-info__title' => 'Особисті дані',
    'ui__admin-info__description' => 'Змінити персональні дані вашого облікового запису.',
    'ui__admin-password__short-title' => 'Змінити пароль',
    'ui__admin-password__title' => 'Змінити пароль',
    'ui__admin-password__description' => 'Змінити пароль вашого облікового запису',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Віртуальні каталоги', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Віртуальні каталоги', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Робота з фізичними та віртуальними файлами і каталогами на вашому веб-сайті.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Використання ресурсів',
    'ui__reseller/limits__title' => 'Використання ресурсів',
    'ui__reseller/limits__description' => 'Перегляд та управління використанням ресурсів посередника %1.',
    'ui__reseller/limits_unknown__short-title' => 'Використання ресурсів',
    'ui__reseller/limits_unknown__title' => 'Використання ресурсів',
    'ui__reseller/limits_unknown__description' => 'Перегляд та управління використанням ресурсів посередника.',
    'ui__reseller/limits_self__short-title' => 'Використання ресурсів',
    'ui__reseller/limits_self__title' => 'Використання ресурсів',
    'ui__reseller/limits_self__description' => "Перегляд та управління використанням вашого ресурсу.",
    'ui__reseller/limits_readonly-self__short-title' => 'Використання ресурсів',
    'ui__reseller/limits_readonly-self__title' => 'Використання ресурсів',
    'ui__reseller/limits_readonly-self__description' => "Переглянути використання вашого ресурсу.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Використання трафіку замовниками',
    'ui__reseller/client/traffic_unknown__title' => 'Переглянути використання трафіку замовниками',
    'ui__reseller/client/traffic_unknown__description' => 'Переглянути звіти з використання трафіку для облікових записів замовника.',
    'ui__client/traffic_unknown__short-title' => "Використання трафіку замовниками", // temporary for presets
    'ui__client/traffic_unknown__title' => "Переглянути використання трафіку замовниками", // temporary for presets
    'ui__client/traffic_unknown__description' => "Переглянути звіти з використання трафіку для облікових записів замовника.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Менеджер журналів',
    'ui__client/domain/hosting/logs_unknown__title' => 'Менеджер журналів',
    'ui__client/domain/hosting/logs_unknown__description' => 'Переглянути журнали а конфігурувати обробку файлів журналу.',
    // dropdowns
    'ui__reseller/report__title' => 'Підсумковий звіт',
    'ui__reseller/report__short-title' => 'Підсумковий звіт',
    'ui__reseller/report__description' => 'Переглянути звіт з використання трафіку та ресурсів для цього посередника.',
    'ui__reseller/report_unknown__title' => 'Підсумковий звіт',
    'ui__reseller/report_unknown__short-title' => 'Підсумковий звіт',
    'ui__reseller/report_unknown__description' => 'Переглянути звіт з використання трафіку та ресурсів для посередника.',
    'ui__reseller/report_self__title' => 'Підсумковий звіт',
    'ui__reseller/report_self__short-title' => 'Підсумковий звіт',
    'ui__reseller/report_self__description' => 'Переглянути звіт з вашого використання трафіку та ресурсів.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Брендінг Plesk',
    'ui__client/logo_reseller__short-title' => 'Брендінг Plesk',
    'ui__client/logo_reseller__description' => 'Змінити оформлення Plesk для посередника %1.',
    'ui__client/logo_unknown__title' => 'Брендінг Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Брендінг Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Змінити оформлення Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Брендінг Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Брендінг Plesk',
    'ui__client/logo_self-reseller__description' => 'Змінити оформлення свого Plesk.',
    'ui__reseller/permissions__title' => 'Права доступу',
    'ui__reseller/permissions__short-title' => 'Права доступу',
    'ui__reseller/permissions__description' => "Переглянути або змінити дії, які посередник %1 може виконувати в Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Права доступу',
    'ui__reseller/permissions_unknown__title' => 'Права доступу',
    'ui__reseller/permissions_unknown__description' => "Переглянути або змінити дії, які посередник може виконувати в Plesk.",
    'ui__reseller/permissions_self__title' => 'Права доступу',
    'ui__reseller/permissions_self__short-title' => 'Права доступу',
    'ui__reseller/permissions_self__description' => 'Переглянути список дій, які можна виконувати в Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Права доступу',
    'ui__reseller/permissions_readonly-self__short-title' => 'Права доступу',
    'ui__reseller/permissions_readonly-self__description' => 'Переглянути список дій, які можна виконувати в Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Шаблон віртуального хосту',
    'ui__client/skeleton__short-title' => 'Шаблон віртуального хосту',
    'ui__client/skeleton__description' => 'Вказати файли та папки, які потрібно перенести до каталогів новостворених доменів.',
    'ui__client/skeleton_unknown__short-title' => 'Шаблон віртуального хосту',
    'ui__client/skeleton_unknown__title' => 'Шаблон віртуального хосту',
    'ui__client/skeleton_unknown__description' => 'Вказати файли та папки, які потрібно перенести до каталогів новостворених доменів.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Псевдоніми домена',
    'ui__client/domain/domain-alias_unknown__title' => 'Псевдоніми домена',
    'ui__client/domain/domain-alias_unknown__description' => 'Перегляд списку альтернативних імен для вашого домену.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Налаштування DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_unknown__description' => 'Управління налаштуваннями зони DNS для домену.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Переглянути налаштування зони DNS для домену.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Інструменти MyPlesk.com.',
    'ui__reseller/extras-domain__title' => 'Інструменти MyPlesk.com.',
    'ui__reseller/extras-domain__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Інструменти MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__title' => 'Інструменти MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Інструменти MyPlesk.com.',
    'ui__reseller/extras-domain_self__title' => 'Інструменти MyPlesk.com.',
    'ui__reseller/extras-domain_self__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Зареєструвати домен',
    'ui__reseller/register-domain__title' => 'Зареєструвати домен',
    'ui__reseller/register-domain__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Зареєструвати домен',
    'ui__reseller/register-domain_unknown__title' => 'Зареєструвати домен',
    'ui__reseller/register-domain_unknown__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Зареєструвати домен',
    'ui__reseller/register-domain_self__title' => 'Зареєструвати домен',
    'ui__reseller/register-domain_self__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Управління доменом',
    'ui__reseller/manage-domain__short-title' => 'Управління доменом',
    'ui__reseller/manage-domain__description' => 'Управління зареєстрованими іменами доменів на MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Управління доменом',
    'ui__reseller/manage-domain_unknown__short-title' => 'Управління доменом',
    'ui__reseller/manage-domain_unknown__description' => 'Управління зареєстрованими іменами доменів на MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Управління доменом',
    'ui__reseller/manage-domain_self__short-title' => 'Управління доменом',
    'ui__reseller/manage-domain_self__description' => 'Управління зареєстрованими іменами доменів на MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'ІР-адреси',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'ІР-адреси',
    'ui__client/ipaddress_unknown-reseller__description' => 'Управляти ІР-адресами.',
    'ui__client/domain/certificate_unknown__short-title' => 'Сертифікати SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Сертифікати SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Установка та управління сертифікатами SSL/TLS.',
    'ui__reseller/sessions__short-title' => 'Активні сеанси',
    'ui__reseller/sessions__title' => 'Активні сеанси',
    'ui__reseller/sessions__description' => 'Переглянути активні сеанси Plesk.',
    'ui__reseller/sessions_unknown__short-title' => 'Активні сеанси',
    'ui__reseller/sessions_unknown__title' => 'Активні сеанси',
    'ui__reseller/sessions_unknown__description' => 'Переглянути активні сеанси Plesk.',
    'ui__reseller/sessions_self__short-title' => 'Активні сеанси',
    'ui__reseller/sessions_self__title' => 'Активні сеанси',
    'ui__reseller/sessions_self__description' => 'Переглянути активні сеанси Plesk.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Поштові облікові записи в обліковому записі користувача %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Шаблон віртуального хосту',
    'ui__client/skeleton_self__title' => 'Шаблон віртуального хосту',
    'ui__client/skeleton_self__description' => 'Вказати файли та папки, які потрібно перенести до каталогів новостворених доменів.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Використання ресурсу',
    'ui__client/limits__title' => 'Використання ресурсу',
    'ui__client/limits__description' => "Перегляд та управління використанням ресурсу замовником %1.",
    'ui__client/limits_unknown__short-title' => 'Використання ресурсу',
    'ui__client/limits_unknown__title' => 'Використання ресурсу',
    'ui__client/limits_unknown__description' => 'Перегляд та управління використанням ресурсу замовником.',
    'ui__client/limits_readonly__short-title' => 'Використання ресурсу',
    'ui__client/limits_readonly__title' => 'Використання ресурсу',
    'ui__client/limits_readonly__description' => 'Переглянути використання ресурсу замовника %1.',
    'ui__client/limits_self__short-title' => 'Використання ресурсу',
    'ui__client/limits_self__title' => 'Використання ресурсу',
    'ui__client/limits_self__description' => "Перегляд та управління використанням вашого ресурсу.",
    'ui__client/limits_readonly-self__short-title' => 'Використання ресурсу',
    'ui__client/limits_readonly-self__title' => 'Використання ресурсу',
    'ui__client/limits_readonly-self__description' => "Переглянути використання вашого ресурсу.",
    'ui__client/domain/traffic_unknown__short-title' => "Використання трафіку доменами %1",
    'ui__client/domain/traffic_unknown__title' => "Переглянути використання трафіку доменами",
    'ui__client/domain/traffic_unknown__description' => "Переглянути звіти з використання трафіку для доменів.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Підсумковий звіт',
    'ui__client/report__short-title' => 'Підсумковий звіт',
    'ui__client/report__description' => 'Переглянути звіт з використання трафіку та ресурсів для цього замовника.',
    'ui__client/report_unknown__short-title' => 'Підсумковий звіт',
    'ui__client/report_unknown__title' => 'Підсумковий звіт',
    'ui__client/report_unknown__description' => 'Переглянути звіт з використання трафіку та ресурсів для замовника.',
    'ui__client/report_self__short-title' => 'Підсумковий звіт',
    'ui__client/report_self__title' => 'Підсумковий звіт',
    'ui__client/report_self__description' => 'Переглянути звіт з використання трафіку та ресурсів.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Параметри інтерфейсу',
    'ui__client/preferences__title' => 'Параметри інтерфейсу',
    'ui__client/preferences__description' => 'Встановити параметри інтерфейсу Plesk для замовника %1.',
    'ui__client/preferences_unknown__short-title' => 'Параметри інтерфейсу',
    'ui__client/preferences_unknown__title' => 'Параметри інтерфейсу',
    'ui__client/preferences_unknown__description' => "Встановити параметри інтерфейсу для Plesk замовника.",
    'ui__client/preferences_self__short-title' => 'Параметри інтерфейсу',
    'ui__client/preferences_self__title' => 'Параметри інтерфейсу',
    'ui__client/preferences_self__description' => 'Встановити параметри інтерфейсу для вашого Plesk.',
    'ui__client/logo__title' => 'Брендінг Plesk',
    'ui__client/logo__short-title' => 'Брендінг Plesk',
    'ui__client/logo__description' => "Змінити оформлення Plesk клієнта %1.",
    'ui__client/logo_self__title' => 'Брендінг Plesk',
    'ui__client/logo_self__short-title' => 'Брендінг Plesk',
    'ui__client/logo_self__description' => 'Змінити оформлення Plesk через зміну зображення логотипу і рядка заголовку оглядача.',
    'ui__client/permissions__title' => 'Права доступу',
    'ui__client/permissions__short-title' => 'Права доступу',
    'ui__client/permissions__description' => "Переглянути або змінити дії, які клієнт %1 може виконати в Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Права доступу',
    'ui__client/permissions_unknown__title' => 'Права доступу',
    'ui__client/permissions_unknown__description' => "Переглянути або змінити дії, які замовник може виконувати в Plesk.",
    'ui__client/permissions_self__title' => 'Права доступу',
    'ui__client/permissions_self__short-title' => 'Права доступу',
    'ui__client/permissions_self__description' => "Переглянути список дій, які можна виконувати в Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Права доступу',
    'ui__client/permissions_readonly-self__short-title' => 'Права доступу',
    'ui__client/permissions_readonly-self__description' => "Переглянути список дій, які можна виконувати в Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Інструменти MyPlesk.com.',
    'ui__client/extras-domain__title' => 'Інструменти MyPlesk.com.',
    'ui__client/extras-domain__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Інструменти MyPlesk.com.',
    'ui__client/extras-domain_unknown__title' => 'Інструменти MyPlesk.com.',
    'ui__client/extras-domain_unknown__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Інструменти MyPlesk.com.',
    'ui__client/extras-domain_self__title' => 'Інструменти MyPlesk.com.',
    'ui__client/extras-domain_self__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Зареєструвати домен',
    'ui__client/register-domain__short-title' => 'Зареєструвати домен',
    'ui__client/register-domain__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Зареєструвати домен',
    'ui__client/register-domain_unknown__short-title' => 'Зареєструвати домен',
    'ui__client/register-domain_unknown__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Зареєструвати домен',
    'ui__client/register-domain_self__short-title' => 'Зареєструвати домен',
    'ui__client/register-domain_self__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Управління доменом',
    'ui__client/manage-domain__short-title' => 'Управління доменом',
    'ui__client/manage-domain__description' => 'Управління зареєстрованими іменами доменів на MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Управління доменом',
    'ui__client/manage-domain_unknown__short-title' => 'Управління доменом',
    'ui__client/manage-domain_unknown__description' => 'Управління зареєстрованими іменами доменів на MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Управління доменом',
    'ui__client/manage-domain_self__short-title' => 'Управління доменом',
    'ui__client/manage-domain_self__description' => 'Управління зареєстрованими іменами доменів на MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'ІР-адреси',
    'ui__client/ipaddress_unknown__short-title' => "ІР-адреси",
    'ui__client/ipaddress_unknown__description' => "Управляти ІР-адресами.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Псевдоніми домена',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Псевдоніми домена',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Перегляд списку альтернативних імен для вашого домену.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Активні сеанси',
    'ui__client/sessions__title' => 'Активні сеанси',
    'ui__client/sessions__description' => 'Переглянути активні сеанси Plesk.',
    'ui__client/sessions_unknown__short-title' => 'Активні сеанси',
    'ui__client/sessions_unknown__title' => 'Активні сеанси',
    'ui__client/sessions_unknown__description' => 'Переглянути активні сеанси Plesk',
    'ui__client/sessions_self__short-title' => 'Активні сеанси',
    'ui__client/sessions_self__title' => 'Активні сеанси',
    'ui__client/sessions_self__description' => 'Переглянути активні сеанси Plesk.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/web-directories__title' => 'Віртуальні каталоги', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Віртуальні каталоги', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Робота із фізичними та віртуальними файлами і каталогами на веб-сайті %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Віртуальні каталоги', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Віртуальні каталоги', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Робота з фізичними та віртуальними файлами і каталогами на вашому веб-сайті.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => 'Використання рафіку %1',
    'ui__client/domain/traffic__title' => 'Статистика передавання даних для <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Переглянути статистику передачі даних для домену %1.',
    'ui__client/domain/traffic_self__short-title' => 'Використання трафіку',
    'ui__client/domain/traffic_self__title' => 'Переглянути використання трафіку для вашого домену',
    'ui__client/domain/traffic_self__description' => 'Переглянути звіт з використання трафіку для вашого домену.',
    'ui__client/domain/hosting/logs__short-title' => 'Менеджер журналів',
    'ui__client/domain/hosting/logs__title' => 'Менеджер журналів',
    'ui__client/domain/hosting/logs__description' => 'Переглянути журнали а конфігурувати обробку файлів журналу.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Менеджер журналів',
    'ui__client/domain/hosting/logs_self__title' => 'Менеджер журналів',
    'ui__client/domain/hosting/logs_self__description' => 'Переглянути журнали а конфігурувати обробку файлів журналу.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Змінити ім’я домену',
    'ui__client/domain/rename__short-title' => 'Змінити ім’я домену',
    'ui__client/domain/rename__description' => 'Змінити ім’я домену %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Змінити ім’я домену',
    'ui__client/domain/rename_unknown__title' => 'Змінити ім’я домену',
    'ui__client/domain/rename_unknown__description' => 'Змінити ім’я домену',
    'ui__client/domain/chowner_select__title' => 'Призначити нового власника для домену',
    'ui__client/domain/chowner_select__short-title' => 'Призначити нового власника для підписки',
    'ui__client/domain/chowner_select__description' => 'Призначити нового власника для підписки',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Призначити нового власника для підписки',
    'ui__client/domain/chowner_unknown-select__title' => 'Призначити нового власника для підписки',
    'ui__client/domain/chowner_unknown-select__description' => 'Призначити нового власника для підписки.',
    'ui__client/domain/toggle__title' => 'Призупинити або активувати домен', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Призупинити або активувати домен', // for HP customization
    'ui__client/domain/toggle__description' => 'Призупинити або активувати домен %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Призупинити або активувати домен', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Призупинити або активувати домен', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Призупинити або активувати домен.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Активувати домен',
    'ui__client/domain/toggle_enable__short-title' => 'Активувати домен',
    'ui__client/domain/toggle_enable__description' => 'Активувати домен %1.',
    'ui__client/domain/toggle_disable__title' => 'Призупинити домен',
    'ui__client/domain/toggle_disable__short-title' => 'Призупинити домен',
    'ui__client/domain/toggle_disable__description' => 'Призупинити домен %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Налаштування DNS',
    'ui__client/domain/dns__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns__description' => 'Управління налаштуваннями зони DNS для домену %1.',
    'ui__client/domain/dns_self__title' => 'Налаштування DNS',
    'ui__client/domain/dns_self__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_self__description' => 'Управління налаштуваннями зони DNS для вашого домену.',
    'ui__client/domain/dns_disabled__title' => 'Налаштування DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_disabled__description' => 'Управління налаштуваннями зони DNS для домену %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Налаштування DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Управління налаштуваннями зони DNS для вашого домену.',
    'ui__client/domain/dns_readonly__title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly__description' => 'Переглянути налаштування зони DNS для домену %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Переглянути налаштування зони DNS для вашого домену.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Переглянути налаштування зони DNS для вашого домену.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Переглянути налаштування зони DNS для вашого домену.',
    'ui__client/domain/dns_slave__title' => 'Налаштування DNS',
    'ui__client/domain/dns_slave__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_slave__description' => 'Управління налаштуваннями зони DNS для домену %1.',
    'ui__client/domain/dns_self-slave__title' => 'Налаштування DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Налаштування DNS',
    'ui__client/domain/dns_self-slave__description' => 'Управління налаштуваннями зони DNS для вашого домену.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Інструменти MyPlesk.com.',
    'ui__client/domain/extras__title' => 'Інструменти MyPlesk.com.',
    'ui__client/domain/extras__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Інструменти MyPlesk.com.',
    'ui__client/domain/extras_unknown__title' => 'Інструменти MyPlesk.com.',
    'ui__client/domain/extras_unknown__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Інструменти MyPlesk.com.',
    'ui__client/domain/extras_self__title' => 'Інструменти MyPlesk.com.',
    'ui__client/domain/extras_self__description' => 'Отримайте додаткові інструменти та сервіси на MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Зареєструвати домен',
    'ui__client/domain/register__title' => 'Зареєструвати домен',
    'ui__client/domain/register__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Зареєструвати домен',
    'ui__client/domain/register_unknown__title' => 'Зареєструвати домен',
    'ui__client/domain/register_unknown__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Зареєструвати домен',
    'ui__client/domain/register_self__title' => 'Зареєструвати домен',
    'ui__client/domain/register_self__description' => 'Зареєструвати им’я домену за допомогою MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Інструменти",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Переглянути статистику',
    'ui__client/domain-summary-report_unknown__title' => 'Переглянути статистику',
    'ui__client/domain-summary-report_unknown__description' => 'Переглянути інформацію про використання ресурсів доменами.',
    'ui__client/domain-summary-report__short-title' => "Переглянути статистику",
    'ui__client/domain-summary-report__title' => "Переглянути статистику",
    'ui__client/domain-summary-report__description' => "Переглянути інформацію про використання ресурсів доменами.",
    'ui__client/domain-summary-report_self__short-title' => "Переглянути статистику",
    'ui__client/domain-summary-report_self__title' => "Переглянути статистику",
    'ui__client/domain-summary-report_self__description' => "Переглянути інформацію про використання ресурсів вашими доменами.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Домени", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Необхідно вибрати домени для видалення',
    'ui__client/domain/chowner__empty_selection' => 'Необхідно вибрати домени для призначення їх новому власнику',

    // list objects filtering
    'domains_list__name__filter_title' => 'Ім’я',
    'domains_list__state__filter_title' => 'Використання ресурсів',
    'domains_list__filter_state_any' => 'Будь-який',
    'domains_list__filter_state_overuse' => 'Надмірне використання',
    'domains_list__filter_state_normal' => 'У межах',
    'domains_list__status__filter_title' => 'Статус',
    'domains_list__filter_status_any' => 'Будь-який',
    'domains_list__filter_status_blocked' => 'Призупинений',
    'domains_list__filter_status_active' => 'Працює',
    'domains_list__ownership__filter_title' => 'Власництво',
    'domains_list__filter_ownership_all' => 'Всі домени',
    'domains_list__filter_ownership_personal' => 'Тільки мої домени',
    'domains_list__filter_owner_pname__filter_title' => 'Ім’я власника',
    'domains_list__subrows__filter_title' => 'Показати',
    'domains_list__subrows_off' => 'Тільки домени',
    'domains_list__subrows_subdomain_domainaliases' => 'З субдоменами та альтернативними іменами',
    'domains_list__subrows_subdomain' => 'З субдоменами',
    'domains_list__subrows_domainaliases' => 'З альтернативними іменами',

    // objects list
    'domains_list__owner__title' => 'Власник',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Пошук застосунків",
    'site_apps__promo_main_text' => "Каталог Application Packaging Standard (APS) містить список застосунків, які можуть бути встановлені на домені чи веб-просторі. Якщо бажаєте встановити застосунки, яких наразі не має в каталозі, ви можете це з легкістью зробити за допомогою інструкцій щодо роботи з APS на сайті www.apsstandard.com",
    'site_apps__promo_download_now' => "Завантажте застосунки:",
    'site_apps__promo_close' => "Закрити цей блок",
    'site_apps__promo_preset__mostused' => '%1 Найбільш популярні',
    'site_apps__promo_preset__lessused' => 'такі   %1 Найбільш популярні',
    'site_apps__promo_preset__all' => "Всі",
    'site_apps__promo_disclaimer_note' => 'Зауважте, що застосунки, встановлені з каталогу APS, забезпечені третіми особами, і компанія Plesk за них не відповідає.',
    'site_apps__promo_preset__page_title' => '%1 застосунки APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Додавання застосунків…',

    // Errors
    'site_apps__no_applications_for_update' => 'У вашому Сховищі застосунків немає встановлених застосунків.',
    'site_apps__incorrect_download_preset_configuration' => 'У налаштуваннях пресету завантажування файлів каталогу APS були виявлені помилки.',
    'site_apps__aps_catalog_url_is_invalid' => 'Вказаний URL не дійсний.',
    'site_apps__no_updates_at_the_moment' => 'На даний момент оновлення для застосунку відсутні.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Невірна інформація була отримана з каталогу APS-застосунків. Будь ласка, спробуйте пізніше.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Налаштування APS-каталогу були збережені, але Plesk не вдалося встановити з\'єднання з APS-каталогом, зазначеним у налаштуваннях APS-каталогу (%1). Пересвідчтеся, що адреса APS-каталогу вірна, і що APS-каталогу за цією адресою є активним.',
    'site_apps__cannot_retrieve_updates' => 'Наразі неможливо завантажити оновлення застосунку: неможливо встановити зв’язок з каталогом APS (%1). Пересвідчтеся, що адреса каталогу APS вірна, і що каталог APS за цією адресою є активним.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Немає доступних веб-застосунків для інсталяції.',
    'site_apps__site_applications_already_installed_in_root' => 'Інші веб-застосунки вже встановлені в кореневому каталозі цих віртуальних хостів.',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET веб-застосунки не підтримуються платформою Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Серверні веб-застосунки не підтримуються',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "До сховища застосунків планується додати ще %1 веб-застосунків",
    'site_apps__applications_all_in_vault' => "вибрані веб-застосунки вже існують у Сховищі застосунків.",
    'site_apps__applications_already_in_download_queue' => "На даний момент до сховища застосунків додаються %1 вибраних веб-застосунків.",
    'site_apps__applications_already_in_valut' => "%1 вибраних веб-застосунків вже знаходиться у сховищі застосунків.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Інші (не категоризовані)',

    // Errors
    'site_apps__no_applications_in_category' => 'Немає доступних застосунків у цій категорії. Будь ласка, Виберіть іншу категорію.',
    'site_apps__no_category_selected__please_specify' => 'Виберіть категорію в лівому меню. Усі застосунки, доступні в вибраній категорії, будуть зазначені в цьому вікні.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Обліковий запис адміністратора',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Загальні дані',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Змінити ім’я вузла',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Безпека',
    'bt_setup_firewall' => 'Встановити мережевий екран',
    'bt_manage_firewall_rules' => 'Управління правилами мережевого екрану',
    'cu_firewall__rule' => 'Створіть правило мережевого екрану',
    'cu_firewall__protocol' => 'Вкажіть протокол для правила (\'tcp\' or \'udp\')',
    'cu_firewall__name' => "Вкажіть ім’я правила",
    'cu_firewall__disabled' => 'Якщо \'true\', то після створення це правило вимикається',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Вибрати DNS-сервер', // PFW
    'bt_soa_records_template' => 'Шаблон записів SOA',
    'bt_restrict_creation_of_subzones' => 'Обмежити створення субзон',

    'databases' => 'Бази даних',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Застосунки',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Пошта',
    'bt_select_mailserver' => 'Вибрати поштовий сервер', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Вибрати антивірус', // PFW
    'bt_virus_protection_settings' => 'Параметри захисту від вірусів',
    'bt_select_spamfilter' => 'Вибрати фільтр спаму', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Вибрати Webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Журнали і статистика',
    'bt_server_statistics_settings' => 'Параметри статистики сервера',
    'bt_select_web_statistics' => 'Доступні програми роботи з веб-статистикою', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Інтерфейс Plesk',

    'components_and_modules' => 'Компоненти та модулі',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Встановити Watchdog', // PFU
    'bt_setup_vpn' => 'Встановити VPN', // PFU
    'bt_setup_samba' => 'Встановити samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Налаштування',
    'ui__client/domain/settings_self__short-title' => 'Налаштування',
    'ui__client/domain/settings_self__description' => 'Переглянути та змінити налаштування домену.',

    'domain_administrator_account' => 'Обліковий запис адміністратора домена',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Параметри облікового запису',

    'domain' => 'Домен',
    'bt_dns_soa_records' => 'SOA-записи DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Параметри планувальника завдань',

    'website' => 'Веб-сайт',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Створення сценаріїв для веб-користувачів',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Виберіть сертифікат SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Веб-статистика',
    'bt_log_rotation_settings' => 'Налаштування ротації журналів',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Обмеження", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Політика надмірного використання і продажу",
    'limits__overuse_policy_legend' => "Надмірне використання",
    'limits__oversell_policy_legend' => "Надмірний продаж",
    'limits__reseller_overuse_description' => "Політика надмірного використання вказує Plesk, що робити при надмірному використанні ресурсів.",
    'limits__overuse_text' => "Політика надмірного використання",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Дисковий простір і трафік',
    'limit__disk_space' => 'Дисковий простір',
    'limit__max_traffic' => 'Трафік',
    'limit_group__client' => 'Замовники',
    'limit__max_cl' => 'Замовники',
    'limit_group__domain' => 'Домени',
    'limit__max_dom' => 'Домени',
    'limit__max_dom_powerUser' => 'Підписки',
    'limit__max_subdom' => 'Субдомени',
    'limit__max_dom_aliases' => 'Псевдоніми домена',
    'limit__max_wu' => 'Веб-користувачі',
    'limit__max_subftp_users' => 'Додаткові облікові записи FTP', // PFW
    'limit_group__mail' => 'Пошта',
    'limit__max_box' => 'Поштові скриньки',
    'limit__mbox_quota' => 'Розмір поштової скриньки',
    'limit__total_mboxes_quota' => 'Загальна квота поштових скриньок', // PFW
    'limit__max_maillists' => 'Переліки поштових розсилок',
    'limit_group__database' => 'Бази даних',
    'limit__max_mssql_db' => 'Бази даних Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Квота бази даних Microsoft SQL', // PFW
    'limit__max_odbc' => 'З’єднання ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Квота баз даних MySQL', // PFW
    'limit__pgsql_dbase_space' => 'Квота баз даних PostgreSQL', // PFW
    'limit_group__application' => 'Застосунки',
    'limit__max_iis_app_pools' => 'Пули застосунків IIS', // PFW
    'limit_group__security' => 'Безпека',
    'limit_group__validity' => 'Дата закінчення строку дії',
    'limit__expiration' => 'Дата закінчення строку дії',
    'limit__validity' => 'строк дії',
    'limit__max_site_builder' => 'Сайти, опубліковані за допомогою Presence Builder',
    'limit__max_site' => 'Домени',
    'limit__mssql_dbase_filesize' => 'Розмір файлу бази даних MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Розмір файлу журналу бази даних MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Максимальний розмір файлу бази даних Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'Максимальний розмір журналу реєстрації бази даних Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "Мбайт",
    'limit__units_mssql_dbase_log_filesize' => "Мбайт",

    'dom_pref__invalid_max_site_limit' => 'Невірний ліміт доменів. Мінімальне значення – 1.',

    'property__has_wrong_value' => 'Властивість %1 має невірне значення.',
    'property__name_outgoing_messages_domain_limit' => 'Встановлює обмеження на вихідні повідомлення з домену (за годину). Щоб встановити Необмежене значення, слід вказати "-1". Вказати "за замовчуванням", щоб встановити значення, зазначене в загально-серверних налаштуваннях.',
    'property__name_outgoing_messages_mbox_limit' => 'Встановлює обмеження на вихідні повідомлення з поштової скриньки (за годину). Щоб встановити Необмежене значення, слід вказати "-1". Вказати "за замовчуванням", щоб встановити значення, зазначене в загально-серверних налаштуваннях.',
    'property__name_outgoing_messages_subscription_limit' => 'Встановлює обмеження на вихідні повідомлення з підписки (за годину). Щоб встановити Необмежене значення, слід вказати "-1". Вказати "за замовчуванням", щоб встановити значення, зазначене в загально-серверних налаштуваннях.',

    // for CLI report & email notifications
    '__resource_notify' => 'Повідомляти',
    '__general' => 'Загальні дані',
    '__template_shared' => 'Загальний шаблон',
    'limit__overuse' => 'Політика надмірного використання',
    'limit__max_traffic_soft' => 'Сповіщати, коли використання трафіку досягає',
    'limit__disk_space_soft' => 'Сповіщати, коли використання дискового простору досягає',
    '__overuse' => 'Політика надмірного використання',
    'performance__title' => 'Продуктивність',
    'performance__bandwidth' => 'Максимальне використання смуги пропускання (КБ/с)',
    'performance__max_connections' => 'З’єднання обмежені до',

    'gch__hosting_php_isapi' => 'Запустити PHP як розширення ISAPI',
    'gch__hosting_ssi_html' => 'Використовувати SSI для файлів *.htm, *.html',
    'gch__hosting_php_handler_type' => 'запустити PHP як',
    'gch__hosting_php_handler_id' => 'запустити PHP як',
    'gch__hosting_php_served_by_nginx' => 'PHP обслуговується nginx',
    'gch__hosting_unpaid_website_status' => 'Статус веб-сайтів у призупинених підписках',
    'gch__mn_no_autoresponder' => 'Для поштового облікового запису немає налаштованих автовідповідей.',
    'gch__no_clients_selected' => "Не обрано жодні облікові записи замовника",
    'gch__no_domains_selected' => "Не обрано жодні домени",

    // limit units
    'limit__units_disk_space' => "Мбайт",
    'limit__units_max_traffic' => "МБ/місяць",
    'limit__units_mbox_quota' => "Кбайт",
    'limit__units_mysql_dbase_space' => "Мбайт", // PFW
    'limit__units_mssql_dbase_space' => "Мбайт", // PFW
    'limit__units_pgsql_dbase_space' => "Мбайт", // PFW
    'limit__units_total_mboxes_quota' => "Мбайт", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Ім’я ресурсу',
    '__resource_usage' => 'Використано',
    '__resource_limit' => 'Обмеження',

    '__used' => 'Використано',
    '__limit' => 'Обмеження',

    '__never_expires' => 'Без терміну дії',
    '__resource_free' => '%1 вільний від %2',
    '__resource_unlimited' => '%1 використано з Необмеженого',

    '__unlimited' => 'Необмежений',
    '__increment' => "Збільшити (+)",
    '__decrement' => "Зменшити (-)",
    '__pt' => 'сегменти',
    '__procent' => '%',
    '__overused' => 'Надмірне використання',
    '__left' => 'Лівий',
    '__available' => 'доступне',
    '__not_available' => 'Не включено',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Розклад доставки',
    'ui__admin/report/layout/auto_unknown__title' => 'Розклад доставки звіту',
    'ui__admin/report/layout/auto_unknown__description' => 'Оберіть розклад доставки звіту для шаблона звіту.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Додати розклад доставки звіту',
    'ui__admin/report/layout/auto/properties_new__title' => 'Додати розклад доставки звіту',
    'ui__admin/report/layout/auto/properties_new__description' => 'Додати новий розклад доставки звіту для звіту %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Розклад доставки звіту',
    'ui__admin/report/layout/auto/properties__title' => 'Розклад доставки звіту',
    'ui__admin/report/layout/auto/properties__description' => 'Перегляд та редагування параметрів розкладу доставки звіту.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Видалити розклад доставки звіту',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Видалити розклад доставки звіту',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Видаліть вибрані розклади доставки звітів.',

    'ui__admin/report/layout_unknown__short-title' => 'Шаблони звітів',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Переглянути використання трафіку для <b>%1</b>',
    'ui__reseller/traffic__description' => 'Переглянути звіти з використання трафіку для облікового запису посередника %1.',
    'ui__reseller/traffic_self__short-title' => 'Мій',
    'ui__reseller/traffic_self__title' => 'Переглянути використання трафіку замовниками.',
    'ui__reseller/traffic_self__description' => 'Переглянути звіти з використання трафіку для облікових записів вашого замовника.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Ім’я посередника', // reseller report
    'report__full_client_name' => 'Ім\'я замовника', // customer report
    'report__full_domain_name' => 'Ім\'я домену', // domain report
    'report__full_owner' => 'Власник', // customer & domain reports
    'report__full_creation_date' => 'Дата створення',
    'report__full_size' => 'Розмір',
    'report__full_traffic' => 'Трафік',
    'report__full_active_clients' => 'Активні замовники', // reseller report
    'report__full_clients' => 'Замовники', // reseller report
    'report__full_active_domains' => 'Активні домени', // reseller & customer reports
    'report__full_domains' => 'Домени', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Mboxes',
    'report__full_disk_space' => 'Дисковий простір',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'БД PostgreSQL',

    // common summary report
    'report__section_general' => 'Загальні дані',
    'report__version' => 'Версія продукту',
    'report__build' => 'Складання продукту',
    'report__status' => 'Статус',
    'report__company_name' => 'Назва компанії',
    'report__personal_name' => 'Ім’я',
    'report__login' => 'Ім\'я користувача',
    'report__phone' => 'Телефон',
    'report__fax' => 'Факс',
    'report__email' => 'Електронна пошта',
    'report__address' => 'Адреса',
    'report__city' => 'Місто',
    'report__state' => 'Регіон/Область',
    'report__zip_code' => 'Поштовий індекс',
    'report__country' => 'Країна',
    'report__creation_date' => 'Дата створення',
    'report__expiration_date' => 'Дата закінчення строку дії',
    'report__dumps_total_size' => 'Загальний розмір файлів резервного копіювання',
    'report__section_resellers' => 'Посередники',
    'report__active_resellers' => 'Посередники з активними підписками',
    'report__resellers' => 'Посередники',
    'report__section_full_resellers' => 'Посередники',
    'report__section_clients' => 'Замовники',
    'report__active_clients' => 'Замовники з активними підписками',
    'report__clients' => 'Замовники',
    'report__section_full_clients' => 'Замовники',
    'report__section_personal_clients' => 'Власні замовники',
    'report__active_personal_clients' => 'ваші власні замовники з активними підписками',
    'report__personal_clients' => 'Власні замовники',
    'report__section_full_personal_clients' => 'Власні замовники',
    'report__section_domains' => 'Домени',
    'report__disk_usage' => 'Використання диску',
    'report__traffic' => 'Трафік',
    'report__active_domains' => 'Активні домени',
    'report__domains' => 'Домени',
    'report__subdomains' => 'Субдомени',
    'report__mboxes' => 'Поштові скриньки',
    'report__mail_groups' => 'Пересилання пошти',
    'report__mail_autoresp' => 'Автовідповіді',
    'report__mail_lists' => 'Переліки поштових розсилок',
    'report__web_users' => 'Веб-користувачі',
    'report__mysql_databases' => 'Бази даних MySQL',
    'report__mssql_databases' => 'Бази даних MSSQL',
    'report__pgsql_databases' => 'Бази даних PostgreSQL',
    'report__section_full_domains' => 'Домени',
    'report__section_personal_domains' => 'Персональні домени',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Персональні домени',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Сайти, опубліковані за допомогою Presence Builder',
    'report__invalid_email' => 'Вкажіть дійсну адресу електронної пошти.',


    // CLI-specific sections
    'report__section_hosting' => 'Хостинг',
    'report__section_webusers' => 'Веб-користувачі',
    'report__section_mailnames' => 'Облікові записи електронної пошти',
    'report__section_maillists' => 'Переліки поштових розсилок',
    'report__section_databases' => 'Бази даних',
    'report__section_siteapps' => 'Веб-застосунки',
    'report__section_aspnetapps' => 'Застосунки ASP.NET', // PFW
    'report__owner_pname' => "Власне ім’я постачальника",
    'report__owner_login' => "Ім’я користувача постачальника",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Розклад доставки',
    'ui__reseller/report/layout/auto_unknown__title' => 'Розклад доставки звіту',
    'ui__reseller/report/layout/auto_unknown__description' => 'Оберіть розклад доставки звіту для шаблона звіту.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Додати розклад доставки звіту',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Додати розклад доставки звіту',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Додати новий розклад доставки звіту для звіту %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Розклад доставки звіту',
    'ui__reseller/report/layout/auto/properties__title' => 'Розклад доставки звіту',
    'ui__reseller/report/layout/auto/properties__description' => 'Перегляд та редагування параметрів розкладу доставки звіту.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Видаліть розклад доставки звіту',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Видаліть розклад доставки звіту',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Видаліть вибрані розклади доставки звітів.',

    'ui__reseller/report/layout_unknown__short-title' => 'Шаблони звітів',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Переглянути використання трафіку для <b>%1</b>',
    'ui__client/traffic__description' => 'Переглянути звіти з використання трафіку для облікового запису замовника %1.',
    'ui__client/traffic_self__short-title' => 'Використання трафіку',
    'ui__client/traffic_self__title' => 'Використання трафіку доменами',
    'ui__client/traffic_self__description' => 'Переглянути звіти з використання трафіку для ваших доменів.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Зазначений мовний пакет встановлено, але в системі не ввімкнено.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Видалити сеанси',
    'ui__sessions/delete__title' => 'Видалити сеанси',
    'ui__sessions/delete__description' => 'Видалити вибрані сеанси.',
    'ui__ftp-sessions__short-title' => 'Сеанси FTP',
    'ui__ftp-sessions__title' => 'Сеанси FTP',
    'ui__ftp-sessions__description' => 'Переглянути сеанси FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Видаліть сеанси FTP',
    'ui__ftp-sessions/delete__title' => 'Видаліть сеанси FTP',
    'ui__ftp-sessions/delete__description' => 'Видаліть вибрані сеанси FTP.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Видалити сеанси',
    'ui__reseller/sessions/delete__title' => 'Видалити сеанси',
    'ui__reseller/sessions/delete__description' => 'Видалити вибрані сеанси.',
    'ui__reseller/sessions/delete_self__short-title' => 'Видалити сеанси',
    'ui__reseller/sessions/delete_self__title' => 'Видалити сеанси',
    'ui__reseller/sessions/delete_self__description' => 'Видаліть вибрані сеанси.',
    'ui__reseller/ftp-sessions__short-title' => 'Сеанси FTP',
    'ui__reseller/ftp-sessions__title' => 'Сеанси FTP',
    'ui__reseller/ftp-sessions__description' => 'Переглянути сеанси FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Сеанси FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Сеанси FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Переглянути сеанси FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Видаліть сеанси FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Видаліть сеанси FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Видаліть вибрані сеанси FTP.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Видаліть сеанси FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Видаліть сеанси FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Видаліть вибрані сеанси FTP.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Видалити сеанси',
    'ui__client/sessions/delete__title' => 'Видалити сеанси',
    'ui__client/sessions/delete__description' => 'Видаліть вибрані сеанси.',
    'ui__client/sessions/delete_self__short-title' => 'Видалити сеанси',
    'ui__client/sessions/delete_self__title' => 'Видалити сеанси',
    'ui__client/sessions/delete_self__description' => 'Видаліть вибрані сеанси.',

    // domain administrator

    'forgery_token_expired' => 'Маркер сесії втратив чинність',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Такі облікові записи посередника буде змінено на облікові записи замовника',
    'downgradeResellers__downgrade' => 'Облікові записи посередника, які буде змінено',
    // controls
    'downgradeResellers__submit_downgrade' => 'Виконати зміну облікового запису',
    'downgradeResellers__cancel_downgrade' => 'Скасувати перетворення облікового запису.',
    'downgradeResellers__confirm' => 'Підтвердити зміну',
    'downgradeResellers__confirm_message' => 'Для продовження, підтвердьте зміну облікового запису',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Вибрати облікові записи замовників',
    'upgradeClients__upgrade_clients' => 'Такі облікові записи замовників будуть перетворені на облікові записи посередників',
    'upgradeClients__upgrade' => 'Облікові записи замовників, що підлягають перетворенню',
    // controls
    'upgradeClients__submit_upgrade' => 'Виконати зміну облікового запису',
    'upgradeClients__cancel_upgrade' => 'Скасувати перетворення облікового запису.',
    'upgradeClients__confirm' => 'Підтвердити зміну',
    'upgradeClients__confirm_message' => 'Для продовження, підтвердьте зміну облікового запису',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Не вдалося перетворити обліковий запис \'%1\' на обліковий запис посередника: \'%1\' вже є посередником.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Такі облікові записи адміністратора домену будут перетворені на облікові записи замовника',
    'upgradeDomainUser__upgrade' => 'Облікові записи адміністратора домену, що будуть перетворені',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Виконати зміну облікового запису.',
    'upgradeDomainUser__cancel_upgrade' => 'Скасувати перетворення облікового запису.',
    'upgradeDomainUser__confirm' => 'Підтвердити зміну',
    'upgradeDomainUser__confirm_message' => 'Для продовження, підтвердьте зміну облікового запису',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Облікові записи адміністратора домену, які неможливо перетворити',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Такі облікові записи адміністратора домену неможливо перетворити на облікові записи замовника:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Деякі облікові записи адміністратора домену неможливо перетворити на облікові записи замовника. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Обліковий запис адміністратора домену не існує',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Домен повинен належати безпосередньо серверному адміністратору або посереднику.",
    'upgradeDomainUser__all_logins_already_used' => 'Неможливо створити обліковий запис для кінцевого замовника.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Обліковий запис адміністратора домену перетворено',
    'upgradeDomainUser__upgrade_notification_body' => 'Обліковий запис адміністратора вашого домену перетворено на обліковий запис замовника з ім’ям користувача \'%%login%%\' та паролем \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Вибрати облікові записи замовників',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Вибраний посередник не має прав доступу \'%1\', але деякі замовники ці права мають.',
    'clientOwnerChanger__application_not_allowed' => 'Застосунок \'%1\' недоступний для вибраного посередника, але доступний для деяких замовників.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Призначення нового власника для вибраних підписок',
    // errors
    'domain_chown__empty_selection' => 'Вам необхідно обрати нового власника обраних доменів',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Максимальне використання смуги пропускання (%1)',
    'hosting_performance__max_connection_label' => 'З’єднання обмежені до',
    'performance__invalid_value' => "Некоректне значення. Значення має бути в діапазоні від %1 до %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Поштовий веб-інтерфейс',
    'webmail__server_text' => 'Доступні клієнти поштового веб-інтерфейсу',
    'webmail__none' => 'Немає',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'IP-пул серверу',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'База даних не буде відновлена — відсутній відповідний сервер бази даних.',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Резервна копія сервера.",
    '__default_backup_comment_reseller' => "Резервну копію облікового запису посередника створено %1.",
    '__default_backup_comment_client' => "Резервну копію облікового запису замовника створено %1.",
    '__default_backup_comment_domain' => "Резервну копію підписки створено %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "IP-пул замовника %1",
    'backup__ip_mapping__resellers_ip' => "ІР-пул посередника %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Віртуальний вузол',
    'backup__restore__object_plesk_admin' => 'Адміністратор Plesk',
    'backup__restore__object_ftpuser' => 'Обліковий запис FTP',
    'backup__restore__object_frontpageuser' => 'Обліковий запис FrontPage',
    'backup__restore__object_webuser' => 'веб-користувач',
    'backup__restore__object_domain' => 'домен',
    'backup__restore__object_subdomain' => 'субдомен',
    'backup__restore__object_domainalias' => 'префікс домену',
    'backup__restore__object_client' => 'замовник',
    'backup__restore__object_reseller' => 'посередник',
    'backup__restore__object_autoresponder' => 'авто-повтор',
    'backup__restore__object_mailalias' => 'псевдонім поштового сервісу',
    'backup__restore__object_database' => 'база даних',
    'backup__restore__object_mailname' => 'обліковий запис поштової служби',
    'backup__restore__object_db_user' => 'користувач бази даних',
    'backup__restore__object_ssl_certificate' => 'Сертифікат SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Такі посередники не можуть бути відновлені, тому що їх перетворено на замовників: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Таких замовників неможливо відновити, тому що їх перетворено на посередників: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Таких замовників неможливо відновити, тому що їх перенесено до іншого власника: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Недостатньо дискового простору на цільовому сервері для передачі всіх вибраних підписок. Доступно: %1 МБ. Потрібно: %2 МБ. Зауважте, що потрібний простір розраховується як сума змісту вебових сторінок, пошти і бази даних доменів. Необхідний простір розраховується один раз на день і зберігається в кеші, так що фактичний розмір доменів може відрізнятися від розрахункового розміру. Якщо ви переконані, що вибрані домени не займають більше місця, ніж доступно, ви можете розпочати передачу.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Звільніть дисковий простір на цільовому сервері.',
    'backup__restore__capability_source_not_enough_disk_text' => 'На вихідному сервері недостатньо дискового простору для зберігання тимчасових файлів для передачі. Доступно: %1 МБ. Необхідно %2 МБ.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Звільніть дисковий простір на вихідному сервері.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Інформація про сервер',

    'backup__restore__capability_not_installed_component_text' => 'Компонент %1 не встановлений на цільовому сервері. %1 буде недоступний для всіх відновлених об’єктів.',
    'backup__restore__capability_not_installed_component_resolution' => 'Необхідно встановити %1. Зауважте, що це може зайняти декілька хвилин.',
    'backup__restore__capability_existing_sys_user_text' => 'На цільовому сервері вже існує системний користувач з ім\'ям %1.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Необхідно змінити ім’я існуючого системного користувача на цільовому сервері.',
    'backup__restore__capability_license_usage_text' => 'Після передачі даних на цільовому сервері будуть перевищені такі ліміти ресурсів (визначаються ліцензійним ключем):',
    'backup__restore__capability_license_usage_resolution' => 'Встановіть на цільовому сервері інший ліцензійний ключ, який забезпечить необхідну кількість ресурсів.',
    'backup__restore__capability_max_allowed_packet_text' => "Значення параметру 'max_allowed_packet' на вихідному сервері бази даних становить %1 та є більшим, ніж на цільовому сервері ‒ %2. Деякі об’єкти бази даних для нижченаведених доменів можуть не відновитись.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Збільшіть значення параметру 'max_allowed_packet' на цільовому сервері бази даних.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Неможливо передати бази даних PostgreSQL, тому що версія PostgreSQL на цільовому сервері раніша за версію на вихідному сервері. Поточна версія PostgreSQL — %1, необхідна версія — %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Установіть на цільовому сервері необхідну версію PostgreSQL.',
    'backup__restore__capability_db_server_connection_problems' => 'Неможливо підключитися до цільового сервера бази даних PostgreSQL. Для передачі баз даних необхідно відновити з’єднання.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Перевірте налаштування з’єднання на цільовому сервері бази даних.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Компонент %1 вимкнений на цільовому сервері.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Ввімкніть %1 на цільовому сервері.',
    'backup__restore__capability_not_configured_component_text' => 'Компонент %1 не налаштований на цільовому сервері.',
    'backup__restore__capability_not_configured_component_resolution' => 'Налаштуйте %1 на сторінці Інструменти та налаштування.',

    'backup__restore__capability_webmail_is_not_available' => '%1 сервіс веб-пошти не доступний на цільовому сервері. Замість цього, Plesk використає такий сервіс веб-пошти: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Для використання тієї самої веб-пошти, що й на вихідному сервері, необхідно встановити її на цьому сервері.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Для використання такої ж веб-пошти, як і на вихідному сервері, необхідно установити її на цільовому сервері.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "'%1' веб-пошта не доступна на цільовому сервері. Замість цього, на підписках: %3, Plesk використає такий сервіс веб-пошти: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Встановіть на цільовому сервері необхідну веб-пошту.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Налаштування веб-пошти',

    'backup__restore__capability_shell_is_not_available' => 'На цільовому сервері не доступна оболонка %1. Буде використана одна з наявних оболонок.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Для використання такої ж оболонки, як і на вихідному сервері, необхідно її ввімкнути (в /etc/shells) або встановити на цільовий сервер.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Цільовий DNS-сервер не підтримує мережі, зазначені в Шаблоні обмеження передачі зони. Записи з мережевими IP-адресами, що входять до обмежень DNS на передачу, відновлюватися не будуть.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Цільовий DNS-сервер не підтримує мережі, зазначені в Шаблоні обмеження передачі зони, але деякі підписки містять мережі, що входять до обмеження DNS на передачу. Записи з мережевими IP-адресами, що входять до обмежень DNS на передачу, відновлюватися не будуть.',

    'backup__restore__capability_wrong_php_handler_text' => 'Обробник PHP %1 недоступний на цільовому сервері. Замість цього, Plesk використає такий обробник PHP: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Для використання такої ж програми обробки PHP, як на вихідному сервері, необхідно ввімкнути її або установити на цільовому сервері.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP обробник %1 недоступний. Замість нього Plesk використовуватиме %2 для таких сервісних планів: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP обробник %1 недоступний. Замість нього Plesk використовуватиме %2 для таких вебсайтів: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Обробник PHP %1 недоступний. Він буде недоступний для наступних вебсайтів: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 та %2 не доступні на цільовому сервері. Замість них буде використовуватись версія за замовчуванням.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Для використання такої ж %1, як на вихідному сервері, необхідно ввімкнути її або установити на цільовий сервер.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Політика використання антивірусного захисту на цільовому сервері забороняє персональні (для кожної електронної адреси) налаштування антивірусного захисту для вихідної пошти. Ці налаштування не будуть передані.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Політика використання антивірусного захисту на цільовому сервері забороняє персональні (для кожної електронної адреси) налаштування антивірусного захисту для вхідної пошти. Ці налаштування не будуть передані.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Політика використання антивірусного захисту на цільовому сервері забороняє персональні (для кожної електронної адреси) налаштування антивірусного захисту. Ці налаштування не будуть передані.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Для передачі персональних (для кожної електронної адреси) налаштувань антивірусного захисту включіть відповідні опції в меню Інструменти та налаштування > Налаштування захисту від вірусів.",
    'backup__restore__capability_antivirus_not_active_text' => 'Не знайдено працюючі антивірусні програми. Жодне антивірусне налаштування вихідного сервера не буде працювати, поки ви не виберете антивірусну програму на цільовому сервері.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Виберіть антивірусну програму в меню Інструменти та налаштування > Налаштування захисту від вірусів > Налаштування антивірусу.',

    'backup__restore__capability_antivirus_another_active_text' => 'Антивірусна програма %2 недоступна на цільовому сервері. Замість неї буде використано %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Щоб використовувати такий самий антивірус, як на вихідному сервері, встановіть цей антивірус та вмберіть його в меню Інструменти та налаштування > Налаштування захисту від вірусів > Налаштування антивірусу.',
    'backup__restore__capability_not_available_sni_text' => 'SNI на цільовому сервері не встановлено. Вебсайти з однаковою IP-адресою не зможуть використовувати окремі сертифікати SSL/TLS.',
    'backup__restore__capability_not_available_sni_resolution' => "Перевірте, що операційна система на цільовому сервері підтримує SNI, і що підтримка SNI ввімкнена в Plesk (позначка 'Ввімкнути підтримку SNI, яка дозволяє використовувати окремі сертифікати SSL/TLS для вебсайтів з однаковою IP-адресою' в меню Інструменти та налаштування> Параметри сервера).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Налаштування сервера',

    'backup__restore__capability_vhost_already_exists_text' => 'Неможливо передати веб-сайт %1 — на цільовому сервері вже існує веб-сайт з таким ім’ям.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Видаліть з серверу веб-сайт з таким самим ім’ям або перейменуйте його.',
    'backup__restore__capability_removed_vhosts' => 'Наступні підписки не будуть відновлені, оскільки вони містять імена доменів, які вже існують на цільовому сервері: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'На вихідному сервері встановлено %3 різних PHP-обробника типу %1 версії %2. Замість них на цільовому сервері буде використовуватися один обробник відповідного типу та версії. Зауваєте, що налаштування PHP на вихідному та цільовому серверах можуть відрізнятися.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer не підтримує Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer не підтримує Python. Встановіть Python вручну.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Налаштування поштового сервера',

    'backup__restore__capability_ftps_disabled' => 'Використання безпечних FTPS дозволено на вихідному сервері, але заборонено на цільовому сервері. Застосунки користувача, що використовують FTP, можуть працювати неналежним чином.',
    'backup__restore__capability_ftps_required' => 'Використання незахищеного FTP дозволено на вихідному сервері, але заборонено на цільовому сервері. Застосунки користувача, що використовують FTP, можуть працювати неналежним чином.',
    'backup__restore__capability_ftps_policy_resolution' => 'Змініть параметри розділу Політика безпеки FTP в меню Інструменти та налаштування > Політика безпеки.',

    'backup__restore__capability_too_much_download_time_text' => '%1 мегабайт даних буде переміщено з вихідного сервера на цільовий за %2 години.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Для швидшої передачі перевірте мережеве з’єднання між вихідним та цільовим серверами та усуньте неполадки (за їх наявності).',
    'backup__restore__too_low_download_speed' => "не більше 0, 01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Для швидшої передачі перевірте мережеве з’єднання між вихідним та цільовим серверами та усуньте неполадки (за їх наявності).',
    'backup__restore__capability_zero_download_speed_text' => 'Мінімально припустима швидкість завантаження — %1 МБ/с. Швидкість завантаження між вихідним та цільовим серверами складає 0 МБ/с. Це може бути пов’язано з неполадками мережевого з’єднання. Передача неможлива.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Перевірте мережеве з’єднання між вихідним та цільовим серверами та вирішіть неполадки.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Мінімальна прийнятна швидкість завантаження - %2 МБ/с. Швидкість завантаження між вихідним і цільовим сервером складає %1 МБ/с. Це може збільшити час передачі. У вашому поточному середовищі міграція %3 МБ займе %4 години.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Мінімальна прийнятна швидкість завантаження - %2 МБ/с. Швидкість завантаження між вихідним і цільовим сервером складає %1 МБ/с. Це може збільшити час передачі.',

    'backup__restore__capability_remote_database_migration' => "Наступні домени використовують віддалені бази даних: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Не видаляйте ці домени з вихідного серверу після передачі, якщо версія Plesk на вихідному сервері ранніша за 11.5! Замість цього призупиніть їх. Якщо ви видалите домени, бази даних будуть видалені з віддаленого сервера. Примітка: файли дампу віддалених баз даних будуть зберігатися на вихідному сервері в %1 каталозі.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Резервні копії серверів з базою даних MySQL версії ранішою за 5.1 (%1) можуть не відновлюватися на сервері з MySQL версією 5.1.x, тому що MySQL 5.1.x іншим чином обробляє символи Юнікоду.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Докладна інформація наведена в статті #136850 бази знань',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP на цільовому сервері не встановлено.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Встановіть Courier-IMAP, використовуючи Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot на цільовому сервері не встановлено.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Встановіть Dovecot, використовуючи Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'В конфігурації таких об’єктів встановлене значення часу зберігання статистики трафіку є меншим, ніж загальносерверне значення на цільовому сервері.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Змініть на цільовому сервері загальносерверне значення часу зберігання статистики. Встановіть значення не більше, ніж вказано в налаштуваннях домену.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Значення часу зберігання статистики для деяких доменів менше ніж загальне для сервера значення (%1). Для цих доменів значення буде змінене на %1.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Час для збереження статистики трафіку по деяким планам обслуговування менший, ніж загально-серверне значення (%1). Значення буде змінено на %1 для цих планів обслуговування.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Здійснюючи мапування конкретної ІР-адреси до загальнодоступного файлу ви знімаєте анонімність FTP та HTTPS (в разі, якщо SNI-підтримка ввімкнена).',

    'backup__restore__no_postgresql_commands_text' => 'Підписка використовує віддалену базу даних PostgreSQL; її тимчасову резервну копію файлу неможливо створити, тому що на вихідному сервері команди pg_dump та psql відсутні.',
    'backup__restore__no_postgresql_commands_resolution' => 'Будь ласка, встановіть будь-який клієнтський пакет PostgreSQL, який підтримує ці команди.',
    'backup__restore__capability_apache_modules_disabled_text' => 'На цільовому сервері відключені такі модулі Apache: %1',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Ввімкніть зазначені модулі для уникнення можливих проблем.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'На цільовому сервері не встановлені такі модулі Apache: %1',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Встановіть та увімкніть вказані модулі для уникнення можливих проблем.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Обмеження вихідних повідомлень не підпримується вашою ліцензією. Відповідні параметри конфігурації не будуть передані.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Будь ласка, встановіть на цільовому сервері інший ліцензійний ключ, який забезпечує необхідні функції.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Обмеження вихідних повідомлень вимкнено на цільовому сервері. Відповідні параметри конфігурації не будуть передані.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Будь ласка, увімкніть обмеження вихідних повідомлень на цільовому сервері.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Загальносерверні налаштування пошти',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Обмеження вихідних повідомлень з поштової скриньки не підтримується поштовим сервером, який використовується на цільовому сервері. Значення цього обмеження не буде передано.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Будь ласка, змініть поштовий сервер на той самий, який ви використовуєте на вихідному сервері.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Загальносерверні налаштування пошти',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Обмеження вихідних повідомлень з домену не підтримується поштовим сервером, який використовується на цільовому сервері. Значення цього обмеження не буде передано.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Будь ласка, змініть поштовий сервер на той самий, який ви використовуєте на вихідному сервері.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Загальносерверні налаштування пошти',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Обмеження вихідних повідомлень з підписки не підтримується поштовим сервером, який використовується на цільовому сервері. Значення цього обмеження не буде передано.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Будь ласка, змініть поштовий сервер на той самий, який ви використовуєте на вихідному сервері.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Загальносерверні налаштування пошти',

    'bu_conflict_resolver_absent_phosting' => 'Не вдалося відновити зазначені файли, оскільки фізичний хостинг для їх відновлення не існує. Будь ласка, створіть спочатку домен з фізичним хостингом, а потім повторно розпочніть відновлення резервної копії.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Дані посередників не будуть відновлені: керування посередниками не підтримується.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Компонент ModSecurity не встановлено на цільовому сервері.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Будь ласка, встановіть ModSecurity, щоб забезпечити роботу мережевого екрану веб-застосунків на переданих ділянках. Зауважте, що установка може зайняти кілька хвилин.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Встановіть ModSecurity, якщо ви бажаєте передати налаштування мережевого екрану веб-застосунка. Зауважте, що установка може зайняти кілька хвилин.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Компонент ModSecurity не налаштовано на цільовому сервері.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Налаштовуйте ModSecurity, якщо бажаєте забезпечити роботу мережевого екрану веб-застосунків на переданих ділянках.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Мережевий екран веб-застосунку (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity вимкнено на цільовому сервері.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Активуйте ModSecurity, якщо ви бажаєте забезпечити роботу мережевого екрану веб-застосунків на переданих сайтах.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Мережевий екран веб-застосунку (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Компонент ModSecurity не встановлено. Налаштування мережевого екрану веб-застосунку не будуть відновлені для таких об\'єктів: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Веб-сайти неможливо відновити, оскільки вони належать до підписки %1, яку в Plesk не знайдено.",
    'backup__restore__capability_not_installed_dns_text' => 'Компонент %1 на цільвому сервері не встановлено. DNS-сервіс буде недоступний, а налаштування DNS будуть втрачені. Всі веб-сайти замовників вийдуть із ладу.',
    'bu_conflict_resolver_dns_not_installed' => 'Службу DNS не встановлено. Налаштування DNS не будуть відновлені для таких об\'єктів: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Такі підписки не можна відновити, тому що їх перенесено до інших власників: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Такі підписки не можна відновити, тому що їх перенесено до інших постачальників: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Неможливо знайти відновлюючу утиліту Web Presence Builder для відновлення даних Web Presence Builder. Ймовірно, Web Presence Builder не було встановлено.',
    'backup__restore__capability_renamed_db' => 'Ім\'я бази даних "%1" вже використовується іншою підпискою. Назву відновленої бази даних буде змінено на "%2".',
    'backup__restore__capability_renamed_db_user' => 'Ім\'я користувача бази даних "%1" вже використовується іншою підпискою. Ім\'я відновлюваного користувача бази даних буде змінено на "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer не підтримує Perl. Встановіть ActiveState Perl вручну.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% обслуговується з Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% обслуговується nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Антивірус Касперського',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Конфлікти використання ресурсів',
    'backup__restore__hint_resource_usage_conflicts' => 'Конфлікти використання ресурсів виникають при перевищенні відновленими об’єктами обмежень використання ресурсів.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Дозволити перевантаження',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Відновити об’єкт та встановити для нього більше значення ресурсів для використання, ніж було раніше встановлено.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Не відновлювати',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Не слід відновлювати об’єкти, які мають конфлікти використання ресурсів.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Конфлікти конфігурації',
    'backup__restore__hint_configuration_conflicts' => 'Конфлікти конфігурації виникають, коли відновлений об’єкт має параметри та веб-застосунки, які недоступні або заборонені поточною політикою сервера або політикою власника об’єкта. Наприклад, конфлікти конфігурації виникають, якщо відновлені облікові записи електронної пошти мають індивідуальні налаштування фільтрації спаму, а поточна загальносерверна політика забороняє такі налаштування для облікових записів електронної пошти.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Автоматично',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Відновіть об’єкти та включіть в автоматичному режимі всі конфліктні опції конфігурації, які дозволені вашими правами.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Не відновлювати',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Не слід відновлювати об’єкти, які мають конфлікти конфігурації.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Налаштування пула застосунків IIS не дозволяють виділити пули застосунків IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Змініть ваші налаштування пула застосунків IIS в меню Інструменти та налаштування > Пул застосунків IIS > Глобальні налаштування.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Спільні пулі застосунків IIS заборонені налаштуваннями для пулу застосунків IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Змініть ваші налаштування пула застосунків IIS в меню Інструменти та налаштування > Пул застосунків IIS > Глобальні налаштування.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Скорочені імена для поштових облікових записів POP3/IMAP недоступні на цільовому сервері.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Після відновлення скорочені імена для поштових облікових записів будуть недоступні.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Неможливо відкрити журнал реєстрації.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Неможливо відновити підписку %1 — її було видалено з вашого облікового запису і ви не маєте дозвіл на створення нових підписок. Для відновлення цієї підписки зверніться до свого постачальника послуг.',

    'backup__error11' => 'Недостатньо дискового простору для проведення резервного копіювання.',
    'backup__error3011' => 'У з’єднанні було відмовлено: жодна програма не очікує сигналу за вказаною адресою та портом.',
    'backup__error3012' => 'Час очікування з\'єднання.',
    'backup__error3013' => 'Мережа недосяжна.',
    'backup__error3014' => 'Жодного маршруту для розміщення.',
    'backup__error3015' => 'Помилка з’єднання.',
    'backup__error3016' => 'Неможливо перетворити ім’я хосту.',
    'backup__error3017' => 'Невірне ім\'я користувача або пароль.',
    'backup__error3018' => 'Помилка SSH-з’єднання.',

    'backup__error3110' => 'Не вдається з’єднатися з віддаленим міграційним агентом: з’єднання з хостом недоступне.',
    'backup__error3111' => 'Міграційний агент заблокований невдалим завданням міграції або використовується іншим процесом міграції. Будь ласка, перезавантажте міграційного агента на вихідному сервері.',
    'backup__error3112' => 'З’єднання з хостом недоступне або міграційний агент не запущений на вихідному хості.',
    'backup__error3113' => 'Не вдалося використати міграційний агент на хості Linux. Будь ласка, перевірте SSH-з\'єднання з вихідним хостом.',
    'backup__error3114' => 'Не вдалося використати міграційний агент на хості Linux: помилка SSH-з’єднання.',
    'backup__error3115' => 'Невірне ім\'я користувача або пароль.',
    'backup__error3116' => 'Зазначений користувач не має права адміністратора.',

    'dns_t__unable_to_remove_ns_record' => 'Неможливо видалити запис NS з шаблону DNS: кожна зона DNS повинна мати хоча б один запис NS.',
    'dns__unsupported_server_zone_transfer' => 'Неможливо передати шаблон Обмеження передачі  через загально-серверне налаштування DNS: на вихідному сервері такі мережеві адреси доступні для передачі між зонами, але ці адреси заборонені  Microsoft DNS-сервером: %1',
    'dns__unsupported_domain_zone_transfer' => 'Неможливо передати шаблон Обмеження передачі через налаштування DNS домена: на деяких доменах такі мережеві адреси доступні для передачі між зонами, але ці адреси заборонені Microsoft DNS-сервером: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Не вдалося отримати доступ до спільного тимчасового мережевого каталогу для використання резервних копій файлів. Будь ласка, перевірте налаштування мережевого каталогу, імені користувача та паролю. Помилка: %1',

    'migration_select_exist_db_server' => 'Вибрати цільовий сервер бази даних',

    'dbbackup__temp_dir_wrong_value' => 'Було вказано невірне значення для тимчасового каталогу.',
    'dbbackup__network_temp_dir_wrong_value' => 'Було вказано невірне значення для тимчасового мережевого каталогу .',
    'dbbackup__server_backup_not_configured' => 'Налаштування резервного копіювання бази даних на цьому сервері не сконфігуровані.',
    'dbbackup__temp_dir' => 'Тимчасова директорія',
    'dbbackup__temp_dir_hint' => 'Шлях до фізичної папки на віддаленому сервері, де розташований MS SQL сервер. MS SQL сервер повинен мати доступ до цієї папки для прочитання та запису тимчасових файлів резервного копіювання. Наприклад, C:\\\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Шлях до мережевого ресурсу повинен бути прив\'язаний до вищезазначеної фізичної папки. Plesk отримає доступ до мережевої папки для завантаження та завантаження файлів. (наприклад, \\ServerName\\DirectoryPath)',
    'dbbackup__network_user_hint' => 'На віддаленому сервері створено користувацьке ім’я користувача мережі. Наприклад, ServerName\\UserName. Користувач повинен мати доступ до вищезазначеної спільної папки.',
    'dbbackup__network_password_hint' => 'Пароль користувача мережі',

    'dbbackup__success_import_without_dublicate_users' => 'Такі користувачі не були імпортовані: %1. Вони вже існують на сервері бази даних.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Стиснути журнали",
    'log_rot__log_rot_status' => "Стан обертання журналів",
    'log_rot__log_rot_period' => "Умова ротації журналів",
    'log_rot__log_rot_size' => "за розміром",
    'log_rot__log_rot_time' => "за часом",
    'log_rot__logrotation_enable' => "Включити ротацію журналів реєстрації",
    'log_rot__mail' => "Надіслати оброблені журнали реєстрації на електронну пошту",
    'log_rot__max_number_of_logfiles' => "Максимальна кількість журналів реєстрації",
    'log_rot__time_period' => "період",
    'log_rot__unable_turn_off' => 'Не вдалося вимкнути ротацію логів, тому що це встановлено на рівні сервера',
    'log_rot__unable_set_period' => 'Не вдалося встановити період ротації логів відмінний від \'щодня\', тому що це встановлено на рівні сервера',
    'log_rot__unable_set_max_log_files' => 'Не вдалося встановити максимальну кількість лог-файлів вище за обмеження по серверу %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Очікувана кількість: %1",
    'actionlog__incorrect_rotation' => "Вказано невірні параметри ротації журналу: %1",
    'actionlog__unknown_rot_period' => "Невідомий період ротації: %1",
    'actionlog__unknown_rot_type' => "Невідомий тип ротації: %1",
    'actionlog__session_preferences' => 'Налаштування сеансу',
    'actionlog__nis2_delete_prohibited' => 'Видалення записів журналу заборонено через діючі обмеження директиви NIS2.',
    'actionlog__nis2_forbidden_rot_type' => "Тип ротації журналу '%1' не можна використовувати через діючі обмеження директиви NIS2.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Інформація про адміністратора',
    'actionlog__admin_preferences' => "Налаштування адміністратора",
    'actionlog__service' => 'Сервіс',
    'actionlog__ip_addr' => 'IP-адреса',
    'actionlog__client' => 'Обліковий запис замовника',
    'actionlog__client_status' => 'Статус облікового запису замовника',
    'actionlog__client_preferences' => "Налаштування інтерфейсу замовника",
    'actionlog__client_ip_pool' => "IP-пул замовника",
    'actionlog__client_siteapp' => "Пул веб-застосунків замовника",
    'actionlog__client_guid' => "GUID замовника",
    'actionlog__domain' => 'Домен за замовчуванням (перший домен, доданий до підписки)',
    'actionlog__domain_owner' => 'Власник підписки',
    'actionlog__domain_plan' => 'Сервісний план підписки',
    'actionlog__domain_status' => 'Домен за замовчуванням, статус',
    'actionlog__domain_dns' => 'Домен за замовчуванням, DNS-зона',
    'actionlog__subdomain' => 'Субдомен домену за замовчуванням',
    'actionlog__domain_alias' => 'Домен за замовчуванням, псевдонім',
    'actionlog__domain_alias_dns' => 'Домен за замовчуванням, псевдонім DNS-зони',
    'actionlog__site' => 'Домен',
    'actionlog__site_status' => 'Статус домену',
    'actionlog__site_dns' => 'DNS-зона домену',
    'actionlog__site_guid' => 'GUID домену',
    'actionlog__site_subdomain' => 'Субдомен',
    'actionlog__site_alias' => 'Псевдонім домену',
    'actionlog__site_alias_dns' => 'DNS-зона псевдоніму домену',
    'actionlog__domain_limits' => 'Обмеження підписки',
    'actionlog__domain_limit_size' => 'Обмеження простору диску для підписки',
    'actionlog__domain_limit_traffic' => 'Обмеження трафіку для підписки',
    'actionlog__domain_limits_powerUser' => 'Обмеження підписки',
    'actionlog__domain_limit_size_powerUser' => 'Обмеження простору диску для підписки',
    'actionlog__domain_limit_traffic_powerUser' => 'Обмеження трафіку для підписки',
    'actionlog__domain_guid' => "Домен за замовчуванням, GUID",
    'actionlog__cp_user' => 'Користувач Plesk',
    'actionlog__mailname' => 'Обліковий запис електронної пошти',
    'actionlog__maillist' => 'Список електронних адрес',
    'actionlog__phosting' => 'Налаштування хостингу',
    'actionlog__forwarding' => 'Стандартний хостингу чи хостинг переадресації у фреймі',
    'actionlog__webuser' => 'Обліковий запис веб-користувача',
    'actionlog__site_application' => 'Веб-застосунок',
    'actionlog__license' => 'Ліцензійний ключ',
    'actionlog__additional_license' => 'Додатковий ліцензійний ключ',
    'actionlog__template_domain' => "Сервісний план посередника",
    'actionlog__template_admin' => "Сервісний план адміністратора",
    'actionlog__template_reseller' => 'План посередника',
    'actionlog__admin_alias' => 'Додатковий обліковій запис адміністратора', // PFW
    'actionlog__ftpuser' => 'Додатковий обліковий запис FTP', // PFW
    'actionlog__db_server' => 'Сервер бази даних',
    'actionlog__db' => 'База даних',
    'actionlog__db_user' => 'Обліковий запис користувача бази даних',
    'actionlog__client_sapppkg_pool' => "Веб-застосунок користувача", // PFW, not used?
    'actionlog__remote_dns' => 'Статус віддаленого DNS-серверу', // PFW
    'actionlog__reseller' => 'Обліковий запис посередника',
    'actionlog__reseller_guid' => 'GUID посередника',
    'actionlog__reseller_ip_pool' => "IP-пул посередника",
    'actionlog__reseller_limit_size' => 'Обмеження на дисковий простір для облікового запису посередника',
    'actionlog__reseller_limit_traffic' => 'Обмеження на трафік для облікового запису посередника',
    'actionlog__reseller_limits' => 'Обмеження облікового запису посередника',
    'actionlog__reseller_permissions' => 'Права доступу посередника',
    'actionlog__reseller_preferences' => "Налаштування інтерфейсу посередника",
    'actionlog__reseller_siteapp' => "Веб-застосунки, в пулі посередника",
    'actionlog__reseller_status' => 'Статус облікового запису посередника',
    'actionlog__health_status' => 'Статус стану сервера',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'досягнуто',
    'actionlog__added' => 'додано',
    'actionlog__removed' => 'видалено',
    'actionlog__change' => 'змінено',
    'actionlog__update' => 'оновлено',
    'actionlog__move' => 'переміщено',
    'actionlog__upgrade' => 'модернізовано', // PFU?
    'actionlog__update_or_add' => 'оновлено або додано',
    'actionlog__expired' => 'закінчився строк дії',
    'actionlog__create' => 'створено',
    'actionlog__delete' => 'видалено',
    'actionlog__service_stop' => 'не працює',
    'actionlog__service_restart' => 'перезапускається',
    'actionlog__service_start' => 'працює',
    'actionlog__login' => 'на сайті',
    'actionlog__logout' => 'немає на сайті',
    'actionlog__install' => 'встановлено',
    'actionlog__uninstall' => 'видалено',
    'actionlog__reconfigure' => 'переналаштовано',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Запит на скидання пароля',
    'actionlog__event_admin_update' => 'Оновлено інформацію про адміністратора',
    'actionlog__event_admin_preferences_update' => "Налаштування адміністратора оновлено",
    'actionlog__event_service_restart' => 'Сервіс перезапускається',
    'actionlog__event_service_start' => 'Сервіс запустився',
    'actionlog__event_service_stop' => 'Сервіс припинив роботу',
    'actionlog__event_ip_address_create' => 'IP-адресу створено',
    'actionlog__event_ip_address_delete' => 'IP-адресу видалено',
    'actionlog__event_ip_address_update' => 'IP-адресу оновлено',
    'actionlog__event_client_create' => 'Створено обліковий запис замовника',
    'actionlog__event_client_delete' => 'Видалено обліковий запис замовника',
    'actionlog__event_client_update' => 'Обліковий запис замовника оновлено',
    'actionlog__event_client_status_update' => 'Статус облікового запису замовника оновлено',
    'actionlog__event_client_preferences_update' => "Оновлено налаштування інтерфейсу замовника",
    'actionlog__event_client_siteapp_added' => "Веб-застосунок додано до пулу застосунків облікового запису замовника",
    'actionlog__event_client_siteapp_removed' => "Веб-застосунок видалено з пулу застосунків облікового запису замовника",
    'actionlog__event_domain_limit_size_reached' => 'Досягнуто обмеження на дисковий простір для підписки',
    'actionlog__event_domain_limit_traffic_reached' => 'Досягнуто обмеження на трафік для підписки',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Досягнуто обмеження на дисковий простір для підписки',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Досягнуто обмеження на трафік для підписки',

    'actionlog__domain_limit_database' => 'Квота баз даних для підписки',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Досягнуто квоти баз даних MySQL на підписки',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Досягнуто м\'якої квоти баз даних MySQL на підписки',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Досягнуто квоти баз даних серверу Microsoft SQL на підписки',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Досягнуто м\'якої квоти баз даних серверу Microsoft SQL на підписки',
    'actionlog__event_plesk_component_upgrade' => 'Компонент Plesk оновлено',
    'actionlog__event_plesk_component_install' => 'Компонент Plesk встановлено',
    'actionlog__event_plesk_component_uninstall' => 'Компонент Plesk деінстальовано',
    'actionlog__event_domain_create' => 'Домен за замовчуванням (перший домен, доданий до підписки) створено',
    'actionlog__event_domain_delete' => 'Домен за замовчуванням (перший домен, доданий до підписки) видалено',
    'actionlog__event_domain_update' => 'Домен за замовчуванням (перший домен, доданий до підписки) оновлено',
    'actionlog__event_domain_owner_change' => 'Змінено власника підписки',
    'actionlog__event_domain_plan_change' => 'Сервісний план підписки змінено',
    'actionlog__event_domain_status_update' => 'Домен за замовчуванням, статус оновлено',
    'actionlog__event_domain_dns_update' => 'Домен за замовчуванням, DNS-зону оновлено',
    'actionlog__event_subdomain_create' => 'Створено субдомен домену за замовчуванням',
    'actionlog__event_subdomain_delete' => 'Видалено субдомен домену за замовчуванням',
    'actionlog__event_subdomain_update' => 'Оновлено субдомен домену за замовчуванням',
    'actionlog__event_domain_alias_create' => 'Домен за замовчуванням, псевдонім створено',
    'actionlog__event_domain_alias_delete' => 'Домен за замовчуванням, псевдонім видалено',
    'actionlog__event_domain_alias_update' => 'Домен за замовчуванням, псевдонім оновлено',
    'actionlog__event_domain_limits_update' => 'Обмеження підписки оновлено',
    'actionlog__event_cp_user_login' => 'Користувач Plesk увійшов до системи',
    'actionlog__event_cp_user_logout' => 'Користувач Plesk вийшов з системи',
    'actionlog__event_mailname_create' => 'Створено обліковий запис електронної пошти',
    'actionlog__event_mailname_delete' => 'Видалено обліковий запис електронної пошти',
    'actionlog__event_mailname_update' => 'Оновлено обліковий запис електронної пошти',
    'actionlog__event_maillist_create' => 'Список поштових адрес створено',
    'actionlog__event_maillist_delete' => 'Список поштових адрес видалено',
    'actionlog__event_maillist_update' => 'Список поштових адрес оновлено',
    'actionlog__event_phys_hosting_create' => 'Фізичний хостінг створено',
    'actionlog__event_phys_hosting_delete' => 'Фізичний хостинг видалено',
    'actionlog__event_phys_hosting_update' => 'Фізичний хостинг оновлено',
    'actionlog__event_forwarding_create' => 'Стандартний хостинг або хостинг переадресації у фреймі створено',
    'actionlog__event_forwarding_delete' => 'Стандартний хостинг або хостинг переадресації у фреймі видалено',
    'actionlog__event_forwarding_update' => 'Стандартний хостинг або хостинг переадресації у фреймі оновлено',
    'actionlog__event_webuser_create' => 'Створено обліковий запис веб-користувача',
    'actionlog__event_webuser_delete' => 'Видалено обліковий запис веб-користувача',
    'actionlog__event_webuser_update' => 'Оновлено обліковий запис веб-користувача',
    'actionlog__event_siteapp_install' => 'Веб-застосунок встановлено',
    'actionlog__event_siteapp_reconfigure' => 'Веб-застосунок переналаштовано',
    'actionlog__event_siteapp_uninstall' => 'Веб-застосунок деінстальовано',
    'actionlog__event_license_update' => 'Ліцензійний ключ оновлено',
    'actionlog__event_admin_alias_create' => 'Створено додатковий обліковий запис адміністратора',
    'actionlog__event_admin_alias_delete' => 'Видалено додатковий обліковий запис адміністратора',
    'actionlog__event_admin_alias_update' => 'Оновлено додатковий обліковий запис адміністратора',
    'actionlog__event_ftpuser_create' => 'Створено додатковий обліковий запис FTP',
    'actionlog__event_ftpuser_update' => 'Оновлено додатковий обліковий запис FTP',
    'actionlog__event_ftpuser_delete' => 'Видалено додатковий обліковий запис FTP',
    'actionlog__event_template_domain_create' => "Сервісний план посередника створено",
    'actionlog__event_template_domain_update' => "Сервісний план посередника оновлено",
    'actionlog__event_template_domain_delete' => "Сервісний план посередника видалено",
    'actionlog__event_template_admin_create' => "Сервісний план адміністратора створено",
    'actionlog__event_template_admin_update' => "Сервісний план адміністратора оновлено",
    'actionlog__event_template_admin_delete' => "Сервісний план адміністратора видалено",
    'actionlog__event_database_server_create' => 'Сервер бази даних створено',
    'actionlog__event_database_server_update' => 'Сервер бази даних оновлено',
    'actionlog__event_database_server_delete' => 'Сервер бази даних видалено',
    'actionlog__event_remote_dns_status_update' => 'Оновлено статус віддаленого DNS-серверу',
    'actionlog__event_session_preferences_update' => 'Оновлено налаштування сеансу',
    'actionlog__event_domain_alias_dns_update' => 'Домен за замовчуванням, DNS-зону псевдоніму домену оновлено',
    'actionlog__event_domain_move' => 'Стандартний домен переміщено у нову підписку',
    'actionlog__event_site_move' => 'Домен переміщено у нову підписку',
    'actionlog__event_site_subdomain_move' => 'Піддомен переміщено у нову підписку',
    'actionlog__event_subdomain_move' => 'Піддомен стандартного домену переміщено у нову підписку',
    'actionlog__event_license_expired' => 'Ліцензійний строк дії ліцензії Plesk закінчився',
    'actionlog__event_database_create' => 'Базу даних створено',
    'actionlog__event_database_delete' => 'Базу даних видалено',
    'actionlog__event_database_user_create' => 'Обліковий запис користувача бази даних створено',
    'actionlog__event_database_user_update' => 'Налаштування облікового запису користувача бази даних оновлено',
    'actionlog__event_database_user_delete' => 'Обліковий запис користувача бази даних видалено',
    'actionlog__event_client_guid_update' => "Оновлено GUID замовника",
    'actionlog__event_domain_guid_update' => 'Домен за замовчуванням, GUID оновлено',
    'actionlog__event_reseller_create' => 'Створено обліковий запис посередника',
    'actionlog__event_reseller_delete' => 'Видалено обліковий запис посередника',
    'actionlog__event_reseller_update' => 'Обліковий запис посередника оновлено',
    'actionlog__event_reseller_guid_update' => 'Оновлено GUID посередника',
    'actionlog__event_reseller_ip_pool_update' => "IP-пул посередника оновлено",
    'actionlog__event_reseller_limit_size_reached' => 'Досягнуто обмеження на дисковий простор для облікового запису посередника',
    'actionlog__event_reseller_limit_traffic_reached' => 'Досягнуто обмеження на трафік для облікового запису посередника',
    'actionlog__event_reseller_limits_update' => 'Обмеження облікового запису посередника оновлено',
    'actionlog__event_reseller_permissions_update' => 'Права доступу облікового запису посередника оновлено',
    'actionlog__event_reseller_preferences_update' => "Налаштування інтерфейсу посередника оновлено",
    'actionlog__event_reseller_siteapp_added' => "Застосунок додано до пулу застосунків облікового запису посередника",
    'actionlog__event_reseller_siteapp_removed' => "Застосунок видалено з пулу застосунків облікового запису посередника",
    'actionlog__event_reseller_status_update' => 'Статус облікового запису посередника оновлено',
    'actionlog__event_template_reseller_create' => 'План посередника створено',
    'actionlog__event_template_reseller_delete' => 'План посередника видалено',
    'actionlog__event_template_reseller_update' => 'План посередника оновлено',
    'actionlog__event_health_status_change' => 'Змінено статус стану сервера',
    'actionlog__event_siteapp_upgrade' => 'Веб-застосунок оновлено',
    'actionlog__event_extension_install' => 'Розширення установлено',
    'actionlog__event_extension_uninstall' => 'Розширення деінстальовано',
    'actionlog__event_extension_upgrade' => 'Установку розширення скасовано',
    'actionlog__event_extension_status_update' => 'Статус розширення оновлено',
    'actionlog__event_additional_license_expired' => 'Строк дії додаткової ліцензії закінчився',
    'actionlog__event_hostname_changed' => 'Серверне ім\'я розміщувача змінилося',
    'actionlog__event_smb_user_create' => 'Додаткового користувача створено',
    'actionlog__event_smb_user_delete' => 'Додаткового користувача видалено',
    'actionlog__event_smb_user_update' => 'Додаткового користувача оновлено',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesk API RPC не встановлено на віддаленому хості. Зверніться до постачальника послуги про допомогу.",
    'rsession_no_account_errmsg' => "Неможливо отримати доступ до віддаленої служби з вашого облікового запису. Скоріше за все, для вашого облікового запису послуга ще не була активована. Будь ласка, зачекайте кілька хвилин та спробуйте ще раз. Якщо у вас знову виникне ця помилка, зверніться до вашого системного адміністратора.",
    'rsession_no_domain_errmsg' => "Неможливо отримати доступ до віддаленої служби для цього домену. Скоріше за все, для цього домену послуга ще не була активована. Будь ласка, зачекайте кілька хвилин та спробуйте ще раз. Якщо у вас знову виникне ця помилка, зверніться до вашого системного адміністратора.",
    'rsession_unknown_errmsg' => "Віддалений сервер відмовив у спробі встановити сесію. Зверніться про допомогу до вашого системного адміністратора. Код помилки: %1",
    'rsession_unknown2_errmsg' => "Невідома помилка виникла підчас встановлення віддаленої сеанси. Скоріше за все, віддалений сервер відповідає некоректно або взагалі не дає відповіді. Зверніться до вашого системного адміністратора з проханням перевірити деталі помилки в журналі реєстрації помилок веб-серверу.",
    'rsession_no_connect_errmsg' => "Неможливо отримати доступ до віддаленого сервісу: зв’язок з віддаленою сесією встановити не вдалося. Зверніться до постачальника послуги про допомогу.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Дозволити вивантажування до вхідного каталогу",
    'anonftp__allow_create_dirs' => 'Дозволити створення каталогів у вхідному каталозі',
    'anonftp__allow_download_incoming' => 'Дозволити завантажування з вхідного каталогу',
    'anonftp__display_login' => 'Показати повідомлення входу',
    'anonftp__login_text' => 'Текст повідомлення',
    'anonftp__limit_incoming_disk_space' => "Обмежити дисковий простір для вхідного каталогу",
    'anonftp__limit_maximum_bandwidth' => "Обмежити смугу пропускання завантажування для даного віртуального FTP-домену",
    'anonftp__limit_maximum_connections' => "Обмежити кількість одночасних підключень",
    'anonftp__unable_init' => "Неможливо ініціалізувати анонімний обліковий запис FTP: %1",
    'anonftp__unable_set_quota' => "Неможливо встановити обмеження дискового простору для вхідного каталогу: %1",
    'anonftp__unable_update' => "Неможливо оновити параметри анонімного облікового запису FTP: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Сертифікати SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Сертифікат ЦС не підписує сам сертифікат.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Несумісна пара індивідуальний ключ/сертифікат.",
    'class_sslcertificate__invalid_cert_format' => "Невірний формат сертифіката.",
    'class_sslcertificate__invalid_private_key_format' => "Невірний формат індивідуального ключа.",
    'class_sslcertificate__prob_invalid_priv_key' => "Можливо, формат індивідуального ключа невірний.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Створіть віртуальний каталог',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Створіть віртуальний каталог',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Створити новий віртуальний каталог.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Створіть віртуальний каталог',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Створіть віртуальний каталог',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Створити новий віртуальний каталог.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Властивості каталогу',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Властивості віртуального каталогу',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Переглянути та змінити властивості віртуального каталогу.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Властивості каталогу',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Властивості віртуального каталогу',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Переглянути та змінити властивості віртуального каталогу.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Типи MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Типи MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Перегляд списку зареєстрованих типів MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Додати тип МІМЕ',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Додати тип МІМЕ',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Зареєструвати новий тип МІМЕ.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Документи помилок',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Документи помилок',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Переглянути та змінити сторінку про помилки.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Захист',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Захист каталогу',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Обмежити доступ до каталогу, захищеного паролем.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Захист',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Захист каталогу',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Обмежити доступ до каталогу, захищеного паролем.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Налаштування',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Переглянути розташування каталогу та вказати ім’я захищеної області.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Налаштування користувача',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Додати користувача',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Додати користувача',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Додати обліковий запис користувача для надання доступу до захищеного каталогу.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Були застосовані нові налаштування.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Додано обліковий запис користувача.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Видалити',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Видаліть користувачів захищеного каталогу.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Видаліть облікові записи користувача',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Підтвердити видалення облікових записів користувача.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Облікові записи користувача вилучено.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Операцію успішно завершено.',
    'ui__admin/extras-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__admin/report/layout/delete_multi__done' => 'Видалено вибрані шаблони звітів.',
    'ui__admin/report/traffic-history__done' => 'Операцію успішно завершено.',
    'ui__admin/report__done' => 'Операцію успішно завершено.',
    'ui__admin-alias/delete_multi__done' => "Видалено вибрані облікові записи додаткового адміністратора.",
    'ui__admin-alias/properties__done' => "Оновлено параметри облікового запису додаткового адміністратора.",
    'ui__admin-alias/properties_new__done' => "Створено обліковий запис додаткового адміністратора.",
    'ui__admin-alias/properties_unknown__done' => "Оновлено параметри облікового запису додаткового адміністратора.",
    'ui__admin-alias__done' => "Інформація облікового запису додаткового адміністратора успішно оновлена.",
    'ui__admin/manage-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__admin/register-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Видалено вибрані розклади доставки звітів.',
    'ui__admin/report/layout/auto/properties__done' => 'Оновлено розклад доставки звіту.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Створено розклад доставки звіту.',
    'ui__client/domain/certificate/properties__done' => 'Властивості сертифікату SSL/TLS оновлені.',
    'ui__client/domain/certificate/properties_new__done' => 'Додано новий сертифікат SSL/TLS. Для роботи сертифікату необхідно вибрати його в параметрах хостингу вебсайту (закладка Вебсайти та домени> ім’я домену).',
    'ui__client/domain/certificate__done' => 'Операцію успішно завершено.',
    'ui__client/domain/certificate_self__done' => 'Операцію успішно завершено.',
    'ui__client/domain/chowner__done' => 'Тепер підписка %1 належить іншому користувачу.',
    'ui__client/domain/chowner_multi__done' => 'Власника підписки змінено.',
    'ui__client/domain/chowner_multi-select__done' => 'Операцію успішно завершено.',
    'ui__client/domain/chowner_select__done' => 'Операцію успішно завершено.',
    'ui__client/domain/dbbackup/create__done' => "Успішно створено резервну копію бази даних.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Успішно створено резервну копію бази даних.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Втраченого користувача успішно відновлено.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Файли резервних копій успішно видалені.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Вміст бази даних успішно відновлено.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Операцію успішно завершено.", // PFW
    'ui__client/domain/dbbackup__done' => "Операцію успішно завершено.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Операцію успішно завершено.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Операцію успішно завершено.", // PFW
    'ui__client/domain/delete__done' => "Домен %1 видалено.",
    'ui__client/domain/delete_multi__done' => "Домени видалено.",
    'ui__client/domain/disable__done' => 'Домен %1 призупинено.',
    'ui__client/domain/disable_multi__done' => 'Вибрані домени призупинено.',
    'ui__client/domain/enable__done' => 'Веб-сайт %1 активовано.',
    'ui__client/domain/enable_multi__done' => 'Вибрані веб-сайти активовано.',
    'ui__client/domain/extras__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/domain/extras_self__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Налаштування обробки файлів журналу було змінено.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Налаштування обробки файлів журналу було змінено.',
    'ui__client/domain/hosting/logs__done' => 'Операцію успішно завершено.',
    'ui__client/domain/hosting/logs_self__done' => 'Операцію успішно завершено.',
    'ui__client/domain/hosting/setup__done' => 'Хостинг для %1 сконфігуровано.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Операцію успішно завершено.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Операцію успішно завершено.', // PFU
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Віртуальний каталог було створено для веб-сайту %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Віртуальний каталог створено.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'вибрані каталоги вилучено.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'вибрані каталоги вилучено.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Персоналізовані документи помилок оновлені.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'вибрані типи МІМЕ видалено', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Новий тип МІМЕ зареєстровано.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Операцію успішно завершено.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Права доступу до каталогу оновлено.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Права доступу до каталогу оновлено.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'Налаштування РНР для %1 оновлено.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'Налаштування РНР для %1 оновлено.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Властивості каталогу оновлено.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Властивості каталогу оновлено.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Налаштування захисту каталогу оновлено.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Налаштування захисту каталогу оновлено.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Операцію успішно завершено.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Операцію успішно завершено.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Сертифікати SSL/TLS доступні в інтернет-магазині',
    'ui__client/domain/mpc-certificates_self__done' => 'Сертифікати SSL/TLS доступні в інтернет-магазині',
    'ui__client/domain/register__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/domain/register_self__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/domain/rename__done' => 'Ім’я домену змінено.',
    'ui__client/domain/rename_self__done' => "Доменне ім'я успішно змінено.",
    'ui__client/domain/settings_self__done' => 'Операцію успішно завершено.',
    'ui__client/domain/toggle_disable__done' => "Домен %1 призупинено.",
    'ui__client/domain/toggle_enable__done' => "Домен %1 було активовано.",
    'ui__client/domain/traffic__done' => 'Операцію успішно завершено.',
    'ui__client/domain/traffic_self__done' => 'Операцію успішно завершено.',
    'ui__client/domain/traffic_unknown__done' => 'Операцію успішно завершено.',
    'ui__client/domain-summary-report__done' => 'Операцію успішно завершено.',
    'ui__client/domain-summary-report_self__done' => 'Операцію успішно завершено.',
    'ui__client/domain-summary-report_unknown__done' => 'Операцію успішно завершено.',
    'ui__client/extras-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/extras-domain_self__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/ipaddress/delete_multi__done' => 'Операцію успішно завершено.',
    'ui__client/ipaddress/properties__done' => 'Операцію успішно завершено.',
    'ui__client/ipaddress/properties_new__done' => 'Операцію успішно завершено.',
    'ui__client/ip-pool/properties__done' => "ІР-пул замовника %1 оновлено.",
    'ui__client/ip-pool/properties_self__done' => 'Операцію успішно завершено.',
    'ui__client/limits__done' => "Обмеження ресурсу для замовника %1 змінено.",
    'ui__client/limits_self__done' => 'Операцію успішно завершено.',
    'ui__client/logo__done' => 'Застосовано нові налаштування оформлення для замовника %1.',
    'ui__client/logo_reseller__done' => 'Застосовано нові налаштування брендингу для Plesk.',
    'ui__client/logo_self__done' => 'Застосовано налаштування брендингу.',
    'ui__client/logo_self-reseller__done' => 'Застосовано ваші налаштування брендингу.',
    'ui__client/manage-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/manage-domain_self__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/permissions__done' => "Права доступу замовника %1 змінено.",
    'ui__client/permissions_self__done' => 'Операцію успішно завершено.',
    'ui__client/preferences__done' => "Параметри для замовника %1 змінено.",
    'ui__client/preferences_self__done' => "Ваші параметри змінено.",
    'ui__client/register-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/register-domain_self__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__client/report/traffic-history__done' => 'Операцію успішно завершено.',
    'ui__client/report/traffic-history_self__done' => 'Операцію успішно завершено.',
    'ui__client/report__done' => 'Операцію успішно завершено.',
    'ui__client/report_self__done' => 'Операцію успішно завершено.',
    'ui__client/sessions/delete__done' => 'Операцію успішно завершено.',
    'ui__client/sessions/delete_self__done' => 'Операцію успішно завершено.',
    'ui__client/sessions__done' => 'Операцію успішно завершено.',
    'ui__client/sessions_self__done' => 'Операцію успішно завершено.',
    'ui__client/skeleton__done' => 'Операцію успішно завершено.',
    'ui__client/skeleton_self__done' => 'Операцію успішно завершено.',
    'ui__client/traffic__done' => "Операцію успішно завершено.",
    'ui__client/traffic_unknown__done' => 'Операцію успішно завершено.',
    'ui__cp-access__done' => 'Операцію успішно завершено.',
    'ui__cp-session/properties__done' => 'Операцію успішно завершено.',
    'ui__cp-session__done' => 'Операцію успішно завершено.',
    'ui__ftp-sessions__done' => 'Операцію успішно завершено.',
    'ui__license__done' => 'Операцію успішно завершено.',
    'ui__logo__done' => "Властивості брендингу Plesk змінено.",
    'ui__longtasks/longtask/properties__done' => "Налаштування фонової програми успішно змінено.",
    'ui__mass-email/delete__done' => "Шаблон повідомлення %1 видалено.", // PFW
    'ui__mass-email/delete_multi__done' => "Шаблони повідомлень видалено.",  // PFW
    'ui__mass-email/send_main__done' => "Операцію успішно завершено.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Облікові записи замовника успішно вибрано.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Облікові записи адміністратора домену вибрано успішно.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Облікові записи посередника обрано успішно.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Зміни до шаблону масового електронного повідомлення збережено.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Створено шаблон масового електронного повідомлення.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Вибрано облікові записи замовника для шаблону масового електронного повідомлення.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Вибрано облікові записи адміністратора домену для шаблону масового електронного повідомлення.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Обрано облікові записи посередника для шаблону масового електронного повідомлення.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Змінено шаблон масового електронного повідомлення.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Неприпустимі значення, вказані.', // PFW
    'ui__mass-email__done' => "Операцію успішно завершено.", // PFW
    'ui__mass-mail__done' => "Операцію успішно завершено.", // PFU
    'ui__mass-mail/delete__done' => 'Шаблон повідомлення %1 видалено.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Шаблони повідомлень видалено.', // PFU
    'ui__mass-mail/properties__done' => 'Шаблон %1 змінено.', // PFU
    'ui__mass-mail/properties_new__done' => 'Шаблон %1 створено.', // PFU
    'ui__mass-mail/send__done' => 'Повідомлення відправлені.', // PFU
    'ui__mass-mail/send_new__done' => 'Повідомлення відправлені.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Повідомлення відправлені.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Повідомлення відправлені.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Створено новий шаблон повідомлення.', // PFU
    'ui__mass-mail/template/properties__done' => 'Змінено шаблон повідомлення.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Застосовані нові налаштування моніторингу диска.', // PFU
    'ui__modules__done' => 'Операцію успішно завершено.',
    'ui__modules__short-title' => 'Розширення',
    'ui__modules__title' => 'Розширення',
    'ui__reseller/client/traffic_unknown__done' => 'Операцію успішно завершено.',
    'ui__reseller/extras-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__reseller/extras-domain_self__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__reseller/ftp-sessions_self__done' => 'Операцію успішно завершено.',
    'ui__reseller/limits__done' => "Змінено обмеження ресурсів посередника та політику використання ресурсів.",
    'ui__reseller/limits_readonly-self__done' => 'Операцію успішно завершено.',
    'ui__reseller/limits_self__done' => 'Змінено обмеження ваших ресурсів та політику використання ресурсів.',
    'ui__reseller/manage-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__reseller/manage-domain_self__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__reseller/permissions__done' => 'Змінено права доступу посередника %1.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Операцію успішно завершено.',
    'ui__reseller/register-domain__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__reseller/register-domain_self__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Вибрані розклади доставки звітів видалено.',
    'ui__reseller/report/layout/auto/properties__done' => 'Розклад доставки звіту оновлено',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Додано розклад доставки звітів.',
    'ui__reseller/report/traffic-history__done' => 'Операцію успішно завершено.',
    'ui__reseller/report/traffic-history_self__done' => 'Операцію успішно завершено.',
    'ui__reseller/report__done' => 'Операцію успішно завершено.',
    'ui__reseller/report_self__done' => 'Операцію успішно завершено.',
    'ui__reseller/sessions/delete__done' => 'Операцію успішно завершено.',
    'ui__reseller/sessions/delete_self__done' => 'Операцію успішно завершено.',
    'ui__reseller/sessions__done' => 'Операцію успішно завершено.',
    'ui__reseller/sessions_self__done' => 'Операцію успішно завершено.',
    'ui__reseller/traffic__done' => 'Операцію успішно завершено.',
    'ui__reseller/traffic_self__done' => 'Операцію успішно завершено.',
    'ui__reseller/traffic_unknown__done' => 'Операцію успішно завершено.',
    'ui__reseller/logo_self__title' => 'Брендінг Plesk',
    'ui__reseller/logo_self__done' => 'Застосовані ваші налаштування брендингу  Plesk.',
    'ui__server/certificate/default_multi__done' => 'Вибраний сертифікат SSL/TLS було встановлено з метою забезпечення з\'єднання з щойно розміщеними вебсайтами.',
    'ui__server/certificate/delete_multi__done' => 'Вибрані сертифікати SSL/TLS видалено.',
    'ui__server/certificate/download__done' => 'Завантажено сертифікатSSL/TLS.',
    'ui__server/certificate/properties__done' => 'Властивості сертифікату SSL/TLS оновлені.',
    'ui__server/certificate/properties_new__done' => 'Створено сертифікат SSL/TLS %1.',
    'ui__server/certificate/setup_multi__done' => 'Вибраний сертифікат SSL/TLS було встановлено з метою захисту з\'єднання з Plesk.',
    'ui__server/certificate__done' => 'Операцію успішно завершено.',
    'ui__server/cp-certificate-download__done' => "Завантажено сертифікат SSL/TLS.",
    'ui__server/crontab/properties__done' => 'Змінено заплановані завдання %1.',
    'ui__server/crontab/task/delete__done' => 'Завдання видалено.',
    'ui__server/crontab/task/delete_multi__done' => 'Завдання видалено.',
    'ui__server/crontab/task/properties__done' => 'Оновлено заплановані завдання.',
    'ui__server/crontab/task/properties_new__done' => 'Нове завдання було заплановано.',
    'ui__server/crontab/task/toggle_disable__done' => 'Заплановане завдання %1 було вимкнуто.',
    'ui__server/crontab/task/toggle_enable__done' => 'Заплановане завдання %1 було увімкнено.',
    'ui__server/crontab__done' => 'Операцію успішно завершено.',
    'ui__server/dns__done' => 'Операцію успішно завершено.',
    'ui__server/ip-address/client/delete__done' => "ІР-адресу було видалено з ІР-пулу користувача.",
    'ui__server/ip-address/client/delete_multi__done' => "ІР-адресу було видалено з ІР-пулів користувачів.",
    'ui__server/ip-address/client/properties_new__done' => 'ІР-адресу було призначено користувачам.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'ІР-адресу %1 було призначено вибраним замовникам.',
    'ui__server/ip-addresses__done' => "Операцію успішно завершено.",
    'ui__server/mail/statistics/spam/recipients__done' => "Операцію успішно завершено.",
    'ui__server/mail/statistics/spam/summary__done' => "Операцію успішно завершено.",
    'ui__server/mail/statistics/spam__done' => "Операцію успішно завершено.",
    'ui__server/mail/statistics/virus/recipients__done' => "Операцію успішно завершено.",
    'ui__server/mail/statistics/virus/summary__done' => "Операцію успішно завершено.",
    'ui__server/mail/statistics/virus/viruses__done' => "Операцію успішно завершено.",
    'ui__server/mail/statistics/virus__done' => "Операцію успішно завершено.",
    'ui__server/mail/statistics__done' => "Операцію успішно завершено.",
    'ui__server/mail__done' => 'Змінено налаштування поштового серверу.',
    'ui__server/maillists__done' => 'Операцію успішно завершено.',
    'ui__server/mpc-certificates__done' => 'Відкрито сторінку в інтернет-магазині з переліком доступних сертифікатів SSL/TLS.',
    'ui__server/pmm__done' => 'Операцію успішно завершено.',
    'ui__server/preferences__done' => "Змінено налаштування сервера.",
    'ui__server/register__done' => 'Відкрито сторінку MyPlesk.com.',
    'ui__server/services__done' => 'Операцію успішно завершено.',
    'ui__server/sitebuilder__done' => 'Операцію успішно завершено.',
    'ui__server/skeleton__done' => 'Операцію успішно завершено.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Адресу %1 видалено з глобального чорного списку.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Адреси видалено з глобального чорного списку.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Адреси додано до чорного списку.',
    'ui__server/spam-filter/black-list/address__done' => 'Адреси додано до чорного списку.',
    'ui__server/spam-filter/black-list__done' => 'Операцію успішно завершено.', // PFU
    'ui__server/spam-filter/properties__done' => 'Налаштування спам-фільтра змінено.',
    'ui__server/spam-filter/toggle_disable__done' => 'Фільтрацію спаму вимкнено для всієї системи.',
    'ui__server/spam-filter/toggle_enable__done' => 'Фільтрацію спаму увімкнено для всієї системи.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Адресу %1 видалено з глобального білого списку.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Адреси видалено з глобального білого списку.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Адреси додано до білого списку.',
    'ui__server/spam-filter/white-list/address__done' => 'Адреси додано до білого списку.',
    'ui__server/spam-filter/white-list__done' => 'Операцію успішно завершено.', // PFU
    'ui__server/spam-filter__done' => 'Операцію успішно завершено.',
    'ui__server/statistics__done' => 'Операцію успішно завершено.',
    'ui__server/time__done' => "Системну дату та час змінено.",
    'ui__server__done' => "Операцію успішно завершено.",
    'ui__sessions/properties__done' => 'Операцію успішно завершено.',
    'ui__sessions__done' => 'Операцію успішно завершено.',
    'ui__sessions/delete__done' => 'Вибрані сеанси видалено.',
    'ui__support__done' => 'Формуляр запиту про підтримку відкрито в новому вікні або вкладці оглядача.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Файли для завантаження відсутні.',
    'login_up__access_denied_no_permission' => "Доступ заборонено. У вас немає прав доступу на вхід.",
    'mail__unable_remove_pattern' => "Неможливо видалити адресу з чорного списку — %1", // PFW
    'mail__incorrect_network_format' => 'Невірний формат мережі: %1', // PFW
    'initconf__unable_change_passwd' => "Не можу змінити пароль адміністратора: %1",
    'initconf__unable_get_passwd' => 'Неможливо отримати поточний пароль адміністратора: %1 failed: %2',
    'initconf__invalid_hostname' => 'Помилка в імені хосту "%1"',
    'initconf__unable_reconfig' => 'Неможливо налаштувати Plesk: reconfig не вдався: %1',
    'initconf__unable_update_admin' => 'Неможливо оновити контактну інформацію адміністратора: %1',
    '__refresh' => 'Оновити',
    '__dalias_not_exist' => 'Альтернативні домени відсутні.',
    '__bug146523_explanation' => 'У попередніх версіях Plesk дозволялося використовувати до 16 символів для користувацьких імен FTP. Ця версія Plesk обмежує максимально дозволену кількість символів у користувацьких іменах FTP до 15. Для вирішення цієї проблеми необхідно скоротити довжину користувацького імені FTP до 15 символів для встановлених користувацьких імен FTP та змінити принаймні один символ у встановлених користувацьких іменах FTP з метою уникнення конфлікту користувацького імені. Приносимо вибачення за можливі незручності, викликані цією зміною.',
    'domain__cannot_change_webmail' => 'Неможливо змінити електронну пошту для домена: %1',
    'sb_publish_disable_warning' => 'Якщо ви вимкнете процес створення веб-сайту за допомогою Presence Builder, то сайт, який вже був створений у Presence Builder, буде видалено, і всі дані з веб-сайту будуть втрачені. Натисніть ОК, якщо бажаєте продовжити.',
    '__sbnet_client_use_sbnet' => "Створіть відповідний обліковий запис користувача в Presence Builder",
    'mail_resp_activate' => 'Активувати авто-повтор',
    'limitsManger__limit_available_error' => 'Неможливо виділити потрібну кількість ресурсів ("%%limitName%%"): лише %%available%% доступно для вашого облікового запису.',
    'limitsManger__limit_reserved_error' => 'Неможливо виділити менше ресурсів ("%%limitName%%"), ніж вже використано.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Неможливо перейменувати домен: віртуальний каталог з цим ім\'ям вже існує.',
    'domain_unable_to_rename' => 'Неможливо перейменувати домен.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Загальні дані',
    'spamfilter__spamassassin_status_legend' => 'Спам-фільтр SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Параметри SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Ввімкнути спам-фільтр SpamAssassin для всього сервера",
    'spamfilter__spamassassin_user_status_legend' => 'Ввімкнути загально- серверний спам-фільтр SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Перемикнутися на серверну систему спам-захисту на основі сірих списків',
    'spamfilter__personal_settings_not_allowed' => 'Використання індивідуальних налаштування спам-фільтру не дозволено політикою системи.',
    'spamfilter__required_score' => 'Рахунок, який повинно отримати повідомлення, щоб його перевели в розряд "спам"',
    'spamfilter__rewrite_header_subject' => 'Додати наступний текст у початок теми повідомлення, визначеного як спам',
    'spamfilter__use_mailuser_prefs' => 'Застосувати індивідуальні параметри спам-фільтру',
    'spamfilter__score_error' => 'Значення оцінки має бути додатним, його ціла частина повинна бути менше 100; частина після коми повинна мати не більше двох чисел.',
    'spamfilter__rewrite_header_error' => 'Тема повідомлення може складатися з будь-яких друкарських символів, окрім решітки (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Повернути',
    'nonexistent_mail__mode_discard' => 'Відхилити',
    'nonexistent_mail__mode_catch_addr' => 'Переадресувати на електронну поштову скриньку',
    'nonexistent_mail__mode_catch_ip' => 'Переадресувати на IP-адресу',
    'nonexistent_mail__bounce_not_supported' => 'Режим повернення недоставлених повідомлень не підтримується',
    'nonexistent_mail__discard_not_supported' => 'Режим відхилення не підтримується',
    'nonexistent_mail__catch_not_supported' => 'Переадресація електронної пошти не підтримується',
    'nonexistent_mail__redirect_not_supported' => 'Переадресація на IP-адреси не підтримується',
    'nonexistent_mail__ip_used_on_this_host' => 'IP-адреса відповідає імені локального вузла',
    'nonexistent_mail_address_should_be_local_domain' => 'Оскільки увімкнено контроль вихідної пошти, адреса електронної пошти %1 для неіснуючих одержувачів повинна належати вибраному домену. В протилежному випадку замість надсилання повідомлень буде застосовано правило "Відмова".',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Оскільки увімкнено контроль вихідної пошти, адреса електронної пошти, вказана для переспрямування пошти (%1), повинна належати вибраному домену. В протилежному випадку повідомлення, надіслані на цю адресу, не враховуватимуться контролем вихідної пошти.',
    // mail acc extras
    '__antivirus' => "Антивірус",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Немає доступних облікових записів додаткового адміністратора.', // PFW
    'ui__client/domain/certificate__none-available' => 'Замовник не має сертифікатів SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Замовник не має доменів з сертифікатами SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Домен не має сертифікатів SSL/TLS.',
    'ui__reseller/client__none-available' => 'У замовників відсутні посередники.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Вибрати ІР-адресу для видалення з ІР-пулу.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Необхідно вибрати облікові записи посередника, з ІР-пулів якого ви бажаєте відновити ІР-адресу.',
    'ui__server/crontab/task/delete__empty_selection' => 'Необхідно вибрати завдання для скасування.',

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'Підтримка ASP.NET відключена для цього веб-сайту.',
    'phosting__php_forced_by_site_isolation' => 'Неможливо змінити налаштування PHP: не надано дозвіл на обхід політики безпеки для усього сервера.',
    'phosting__option_forced_by_site_isolation' => 'Неможливо змінити налаштування %1: не надано дозвіл на обхід політики безпеки для усього сервера.',
    'phosting__php_handler_id_not_registered' => 'Обробник PHP недозволений у налаштуваннях ізоляції сайту. Використовуватиметься обробник PHP за замовчуванням.',
    'phosting__php_served_by_nginx_is_not_available' => 'Обробник PHP (програма FPM, що обслуговується nginx) не є дозволений при параметрах ізоляції веб-сайту. Використовуватиметься обробник PHP за замовчуванням.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Перегляд списку ІР-адрес',
    'ui__client/ipaddress/properties_readonly__title' => 'Перегляд списку ІР-адрес',
    'ui__client/ipaddress/properties_readonly__description' => 'Перегляд списку ІР-адрес доступних для користувача.',
    'ui__server/certificate__short-title' => 'Сертифікати SSL/TLS',
    'ui__server/certificate__title' => 'Сертифікати SSL/TLS',
    'ui__server/certificate__description' => 'Переглядайте та управляйте сертифікатами SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Видаліть типи МІМЕ',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Видаліть типи МІМЕ',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Видалити вибрані типи МІМЕ.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Додати тип МІМЕ',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Додати тип MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Зареєструвати новий тип МІМЕ.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Видалити ІР-адресу',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Вибрати ІР-адресу для видалення з ІР-пулу замовника %1',

    // mail

    'ui__client/ipaddress__short-title' => 'IP-адреса',
    'ui__client/ipaddress__title' => 'IP-адреса',
    'ui__client/ipaddress__description' => 'Переглянути інформацію щодо ІР-адрес.',
    'ui__server/ip-address__short-title' => 'IP-адреса',
    'ui__server/ip-address__title' => 'IP-адреса',
    'ui__server/ip-address__description' => 'Переглянути інформацію щодо ІР-адрес.',
    'ui__client/domain/hosting/setup__short-title' => 'Налаштування веб-хостингу',
    'ui__client/domain/hosting/setup__title' => 'Налаштування веб-хостингу',
    'ui__client/domain/hosting/setup__description' => 'Налаштуйте веб-хостинг для веб-сайту %1.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Тип MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Властивості типу МІМЕ', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Переглянути властивості типу МІМЕ.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Документ помилок', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Документ помилок', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Властивості документу помилок.', // PFW

    // tooltips

    'b_get_password_cancel' => 'Повернутися до попереднього екрану без відправки електронного листа.',
    'b_get_password_send' => 'Натисніть ОК, щоб відправити повідомлення про відновлення паролю на електронну адресу, зареєстровану в системі.',



    'b_personaltrafficlist_search' => 'Введіть пошуковий шаблон та натисніть кнопку для пошуку доменів.',
    'b_personaltrafficlist_show_all' => 'Показати всі домени.',

    'b_back' => 'Перейти на попередню сторінку.',
    'b_next' => 'Перейти на наступну сторінку.',

    'b_dnsnstemplatelist_remove' => 'Видаліть вибрані сервера імен.',
    'b_dnsnstemplatelist_search' => 'Введіть пошуковий шаблон та натисніть кнопку для пошуку серверів доменних імен.',
    'b_dnsnstemplatelist_show_all' => 'Показати всі сервера доменних імен.',

    'l_dnsnstemplatelist_ns' => 'Упорядкувати шаблони DNS-записів за ім\'ям сервера.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Створити захищені посилання на файли та папки',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Активувати публічні файли',
    'cu__serverfilesharing_fsPublicFolder' => 'Папка для зберігання публічних файлів',
    'cu__serverfilesharing_fsPublicUrl' => 'URL для доступу до публічних файлів для відвідувачів',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Включіть захист паролем публічних файлів',
    'cu__serverfilesharing_fsPartnerFolder' => 'Папка для зберігання файлів, захищених паролем',
    'cu__serverfilesharing_fsPartnersLogin' => 'Ім’я користувача для доступу до файлів',
    'cu__serverfilesharing_fsPartnersPassword' => 'Пароль для доступу до файлів',
    'cu__serverfilesharing_fsDomain' => 'URL кореневої папки. Ім’я домена',
    'cu__serverfilesharing_fsPrefix' => 'URL кореневої папки. Префікс',
    'cu__serverfilesharing_commandUpdate' => 'Оновити налаштування спільного використання файла',
    'cu__serverfilesharing_commandInfo' => 'Показати поточні налаштування спільного використання файлів',
    'subscription_rename_is_forbidden' => 'Перейменування підписок заборонено загально-серверною політикою.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Управління запланованими завданнями на сервері',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Вибрати користувача системи, заплановані завдання якого потребують керування.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Заплановане завдання %1',
    'ui__server/crontab/task__description' => 'Переглянути властивості запланованого завдання %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Системні користувачі',
    'ui__server/crontab_unknown__title' => 'Системні користувачі',
    'ui__server/crontab_unknown__description' => 'Системні користувачі, що можуть бути власниками запланованих завдань.',


    'ui__server/crontab__none-available' => 'Ви не маєте жодного облікового запису користувача системи.',
    'ui__server/crontab_readonly-unknown__description' => 'Перегляд запланованих завдань.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Заплановані завдання',
    'ui__server/crontab_readonly-unknown__title' => 'Перегляд запланованих завдань',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Перегляд запланованих завдань.',
    'ui__server/crontab_readonly__description' => 'Перегляд запланованих завдань %1.',
    'ui__server/crontab_readonly__short-title' => 'Заплановане завдання %1',
    'ui__server/crontab_readonly__title' => 'Перегляд запланованих завдань %1',
    'ui__server/crontab_unknown__wizard-title' => 'Управління запланованими завданнями.',

    'ui__server/crontab/properties__description' => 'Редагувати заплановані завдання %1.',

    'ui__server/crontab/properties__short-title' => 'Налаштування',
    'ui__server/crontab/properties__title' => 'Редагувати заплановані завдання %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Перегляд запланованих завдань.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Налаштування',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Перегляд запланованих завдань',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Перегляд запланованих завдань.',
    'ui__server/crontab/properties_readonly__description' => 'Перегляд запланованих завдань %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Налаштування',
    'ui__server/crontab/properties_readonly__title' => 'Перегляд запланованих завдань %1',
    'ui__server/crontab/properties_unknown__description' => 'Редагувати заплановані завдання.',
    'ui__server/crontab/properties_unknown__short-title' => 'Параметри',
    'ui__server/crontab/properties_unknown__title' => 'Редагувати заплановані завдання',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Редагувати заплановані завдання.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Вибрати користувача системи, завдання якого ви бажаєте переглянути.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Вибрати користувача системи, завдання якого ви бажаєте змінити.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Натисніть Завершити, щоб застосувати зміни та завершити роботу майстра.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Натисніть Завершити, щоб завершити роботу майстра.',

    'ui__server/crontab/task__none-available' => 'ви не маєте заплановані завдання.',
    'ui__server/crontab/task__none-available__2' => 'Користувач системи %1 не має жодного запланованого завдання.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Заплановані завдання.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Завдання',
    'ui__server/crontab/task_readonly-unknown__title' => 'Заплановані завдання',

    'ui__server/crontab/task/delete__description' => 'Видалити заплановане завдання %1',

    'ui__server/crontab/task/delete__short-title' => 'Видалити',
    'ui__server/crontab/task/delete__title' => 'Видалити заплановане завдання %1',
    'ui__server/crontab/task/delete_multi__description' => 'Видалити заплановані завдання.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Видалити',
    'ui__server/crontab/task/delete_multi__title' => 'Видалити заплановані завдання',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Видалити заплановані завдання.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Вибрати користувача системи, завдання якого потрібно видалити.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Вибрати завдання для видалення.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Підтвердьте видалення завдання, вибравши відповідний прапорець, та натисніть Закінчити (Finish), щоб завершити роботу майстра.',
    'ui__server/crontab/task/delete_unknown__description' => 'Видалити заплановане завдання.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Видалити',
    'ui__server/crontab/task/delete_unknown__title' => 'Видалити заплановане завдання',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Видалити заплановане завдання.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Вибрати користувача системи, завдання якого потрібно видалити.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Вибрати завдання для видалення.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Підтвердьте видалення завдання, вибравши відповідний прапорець, та натисніть Закінчити (Finish), щоб завершити роботу майстра.',

    'ui__server/crontab/task/properties__description' => 'Редагувати заплановані завдання.',

    'ui__server/crontab/task/properties__short-title' => 'Редагувати завдання %1',
    'ui__server/crontab/task/properties__title' => 'Редагувати заплановані завдання',
    'ui__server/crontab/task/properties_new__description' => 'Створіть заплановані завдання для %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Додати завдання',
    'ui__server/crontab/task/properties_new__title' => 'Створити нове заплановане завдання для %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Створити нове заплановане завдання.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Вибрати користувача системи, для якого необхідно створити заплановане завдання.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Натисніть Завершити, щоб застосувати зміни та завершити роботу майстра.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Перегляд запланованих завдань.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Параметри',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Перегляд запланованих завдань',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Перегляд запланованих завдань.',
    'ui__server/crontab/task/properties_readonly__description' => 'Перегляд запланованих завдань.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Переглянути завдання %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Перегляд запланованих завдань',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Створити нові заплановані завдання.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Додати завдання',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Створіть заплановані завдання',
    'ui__server/crontab/task/properties_unknown__description' => 'Редагувати заплановані завдання.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Параметри',
    'ui__server/crontab/task/properties_unknown__title' => 'Редагувати заплановані завдання',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Редагувати заплановані завдання.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Вибрати користувача системи, завдання якого ви бажаєте переглянути.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Вибрати користувача системи, завдання якого ви бажаєте змінити.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Вибрати заплановане завдання.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Вибрати заплановане завдання для змінювання.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Натисніть Завершити, щоб застосувати зміни та завершити роботу майстра.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Натисніть Завершити, щоб завершити роботу майстра.',

    'ui__server/crontab/task/toggle_disable__description' => 'Вимкнути заплановане завдання %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Вимкнути',
    'ui__server/crontab/task/toggle_disable__title' => 'Вимкнути заплановане завдання %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Вимкнути заплановане завдання %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Увімкнути',
    'ui__server/crontab/task/toggle_enable__title' => 'Увімкнути заплановане завдання %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Увімкнути або вимкнути заплановані завдання.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Увімкнути або вимкнути',
    'ui__server/crontab/task/toggle_unknown__title' => 'Увімкнути або вимкнути заплановані завдання',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Увімкнути або вимкнути заплановані завдання',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Вибрати обліковий запис користувача системи, завдання якого необхідно ввімкнути або вимкнути.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Вибрати завдання, яке необхідно ввімкнути або вимкнути.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Облікові записи замовника', // not used on HP?
    'ui__client_unknown__title' => 'Облікові записи замовника', // not used on HP?
    'ui__client_unknown__description' => 'Управляти обліковими записами замовника.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Призупинити домен', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Призупинити домен', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Призупинити домен.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Активувати домен', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Активувати домен', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Активувати домен.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "Облікові записи FTP під доменом %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Облікові записи FTP",
    'ftp__user_name' => "Ім’я облікового запису FTP",
    'ftp__user_home' => "Домашній каталог",
    'ftp__invalid_path' => "Визначений недійсний шлях",
    'i_ftp_ses_sub_user' => 'Сесія облікового запису FTP.',
    '__new_passwd' => "Новий пароль %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Неможливо налаштувати веб-сервер на хості <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Неможливо створити файл конфігурації веб-сервера на вузлі <%%host%%> внаслідок помилок: \n\n%%error%% \n\nВиправте помилки в шаблонах конфігурації веб-сервера та спробуйте створити файл конфігурації.",

    'apacheConfigurationMessageAdminTitle' => 'Помилка створення конфігурації веб-сервера',
    'apacheConfigurationMessageClientTitle' => 'Попередження',

    'apacheConfigurationFailedAdminHomeMessage' => 'Неможливо створити новий файл конфігурації внаслідок наявності помилок у шаблонах конфігурації. На вашу електронну пошту було надіслано докладне повідомлення про помилку. Перевірте пошту, виправте помилки та натисніть %1 для повторної спроби створити конфігурацію.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'тут', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Неможливо створити нову конфігурацію для домену %1 внаслідок наявності помилок у шаблонах конфігурації. На вашу електронну пошту було надіслано докладне повідомлення про помилку. Перевірте пошту, виправте помилки та натисніть %2 для повторної спроби створити конфігурацію.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'тут', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Можливо, конфігурація веб-сервера для домену %1 є непослідовною. Для вирішення проблеми зверніться до адміністратора сервера.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Неможливо створити нову конфігурацію для деяких доменів внаслідок наявності помилок у шаблонах конфігурації. На вашу електронну пошту було надіслано докладне повідомлення про помилку. Перевірте пошту, виправте помилки та натисніть %1 для повторної спроби створити конфігурацію.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'тут', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Можливо, конфігурація веб-сервера для деяких ваших доменів є непослідовною. Для вирішення проблеми зверніться до адміністратора сервера.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Персоналізовані документи помилок",
    'dom_pref__webusers_script' => "Дозволити веб-користувачам користуватися скриптами",
    '__seoRedirect' => 'Конфігурувати переважний домен як',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Немає',

    '__sites' => 'Домени',
    'domain_plan__perm_denied_manage_phosting' => 'У вас немає дозволу для управління налаштуваннями хостингу.',
    '__owned_by_client' => 'Належить замовнику',
    'ui__client/permissions_readonly__description' => "Переглянути дії, які замовник %1 може виконувати в Plesk.",
    'backup__restore__object_client_template' => 'Шаблон замовника',
    '__template_name' => 'Ім’я сервісного плану',
    'template__not_exists' => 'Такий сервісний план не знайдено',
    'template__exists' => 'Сервісний план з ім\'ям %1 вже існує.',
    'clientOwnerChanger__ip_not_in_pool' => 'Зазначена IP-адреса не знаходиться в пулі посередника.',

    //// Change owner of subscription
    'chown__select_title' => "Виберіть нового передплатника",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Оберіть нового власника для вибраних підписок та натисніть Далі >>.',
    'domains__client_info' => "%1 підписки, %2 активні підписки, %3 використано дискового простору, %4 використано трафіку",
    '__possible_owners' => 'Можливі нові власники підписок',

    'clients_list__filter_owner__filter_title' => 'Постачальник',
    'clients_list__filter_owner_any' => 'Всі користувачі',
    'clients_list__filter_owner_my' => 'Лише мої передплатники',
    'clients_list__filter_owner_name__filter_title' => 'Ім’я постачальника',

    '__owner' => "Постачальник",
    'l_clientslist_owner' => 'Упорядкувати облікові записи користувачів за назвою постачальника.',
    'l_clientslist_date' => 'Упорядкувати облікові записи користувачів за датою створення.',
    'l_clientslist_name' => 'Упорядкувати облікові записи користувачів за ім\'ям облікового запису.',
    'l_clientslist_domains' => 'Упорядкувати облікові записи користувачів за доменом.',
    'l_clientslist_cname' => 'Упорядкувати облікові записи користувачів за назвою компанії.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Призначення нового власника для вибраних підписок',
    'chown__check_title' => 'Змінити передплатника',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Натисніть Закінчити для завершення призначення нового власника. Після завершення, вибраним підпискам буде призначено нового власника, а їх постачальника буде змінено на постачальника нового власника; вони будуть виведені зі своїх сервісних планів і стануть 'Custom'.",

    'chown__error_check' => 'Виникли проблеми при спробі призначити деякі підписки новому власнику.',
    'domain_chown_subscription_will_be_anonymous' => "Підписки будуть відв’язані від своїх нинішніх сервісних планів та перейдуть в режим 'Custom'.",
    'chown__error_domains_exclude' => "Виникли проблеми при спробі призначити деякі підписки новому власнику. Ці підписки було виділено.",
    'chown__ip_not_in_client_pool' => "IP-адресу, пов’язану з цією підпискою, не було додано до IP-пула нового власника.",
    'chown__already_owned_by_client' => "Ця підписка вже належить цьому користувачу.",

    '__redirect_hint' => 'вас буде перенаправлено до нової адреси за 15 секунд… Якщо автоматичного переходу до нового розташування не відбудеться, будь ласка, увімкніть javascript або натисніть гіперпосилання %%link%%.',

    'backup__restore__object_maillist' => 'Список електронних адрес',
    'backup__restore__object_site' => 'Сайт',
    'backup__restore__object_user' => 'Користувач',
    'backup__restore__object_role' => 'Роль',

    'limit__name_max_site' => 'сайти',

    'iis_pool__unable_rename_client' => "Неможливо перейменувати Пул застосунків IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Сервіс анонімного FTP підтримується лише для основного домену підписки.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Сервіс анонімного FTP підтримується лише для основного домену підписки.',

    '__gb' => 'Гбайт',
    '__tb' => 'ТВ',
    '__gb_month' => 'GB/місяць',
    '__tb_month' => 'ТВ/місяць',

    '__customers' => 'Замовники',
    '__customer_name' => 'Ім\'я замовника',
    '__customer_total' => 'Загалом за замовником',
    '__site' => 'Сайт',
    '__def_site' => 'Сайт за замовчуванням',
    '__subscription_name' => 'Ім’я підписки',
    '__subscription_name_powerUser' => 'Ім’я підписки',

    'limit__units_max_traffic_suffix' => '/місяць',

    'dom_pref__discard' => "Відмовити",

    'mail__pattern_already_exists' => 'Шаблон "%1" вже є в чорному списку.',

    '__not_supported' => 'Не підтримується',

    'plesk_key__sitebuilder' => 'Сайти, опубліковані за допомогою Presence Builder',
    'limit__name_max_site_builder' => 'Сайти, опубліковані за допомогою Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Підтримка багатомовних сайтів у Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Статистика передавання даних для <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Статистика передавання даних для <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Передача даних за сервісами",

    'login_up__access_denied_no_subscriptions' => "Доступ заборонено. Для цього облікового запису нема доступних підписок.",

    'interval__day' => '%1 день(днів)',
    'interval__hour' => '%1 годин(а, и)',
    'interval__minute' => '%1 хвилин(а, и)',
    'interval__second' => '%1 секунд(а, и)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Ви спробували використовувати ліцензійний ключ, створений для іншої версії Plesk. Зверніться до торгового відділу Plesk для отримання належного ліцензійного ключа.',
    //Standalone or virtualization
    'virtualization_any' => "Фізичний сервер або будь-яке рішення з віртуалізації",
    'virtualization_pvc' => "Virtuozzo сontainers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Сервер Virtuozzo",
    'plesk_key__virtualization' => "Дійсний для наступних середовищ:",
    'plesk_key__virtualization_only_key' => 'Ліцензійний ключ призначений для використання тільки з Plesk, працюючи всередині віртуального середовища %1.',
    'plesk_key__virtualizations_only_key' => 'Ліцензійний ключ призначений для використання тільки з Plesk, працюючи всередині таких віртуальних середовищ: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Використання користувацьких мовних пакетів заборонено.',
    'plesk_key__allowed-locales' => 'Доступні мови',
    'plesk_key__allowed-locales-any' => 'Будь-яка мова',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'каталог cgi-bin розташований у',
    '_cgi_bin_mode_webspace' => 'кореневий каталог підписки',
    '_cgi_bin_mode_www_root' => 'корінь документа цього домену',

    /// Custom buttons
    'custom_button__sort_key' => 'Пріоритетність',
    'custom_button__place' => 'Положення',
    'custom_button__place_navigation' => 'Загальний доступ',
    'custom_button__place_admin' => 'Головна сторінка адміністратора',
    'custom_button__place_admin-settings' => 'Сторінка інструментів та налаштувань адміністратора',
    'custom_button__place_reseller' => "Головна сторінка посередника",
    'custom_button__place_reseller-settings' => 'Сторінка Інструменти та утиліти посередника',
    'custom_button__place_client' => 'Головна сторінка замовника',
    'custom_button__place_domain' => "Веб-сайти та сторінка доменів підписки",
    'custom_button__place_domain_powerUser' => "Веб-сайти та сторінка доменів підписки",
    'custom_button__place_domain-properties' => 'Інструменти веб-сайту',
    'custom_button__private' => 'Відображати лише для мене',
    'custom_button__image' => 'Фонова картинка',
    'custom_button__conhelp' => "Текст-підказка",
    'custom_button__edit' => "Налаштування посилання на додаткову послугу",
    'custom_button__include_client_cname' => "Включіть назву компанії замовника",
    'custom_button__include_client_email' => "Включіть електронну адресу замовника",
    'custom_button__include_client_id' => "Включіть ID замовника",
    'custom_button__include_client_pname' => "Включіть контактне ім’я замовника",
    'custom_button__include_domain_id' => "Додайте ідентифікатор підписки, ідентифікатор домену та ідентифікатор псевдоніму домену",
    'custom_button__include_domain_id_powerUser' => "Додайте ідентифікатор підписки, ідентифікатор домену та ідентифікатор псевдоніму домену",

    'custom_button__include_domain_name' => "Включити ім’я основного домену",
    'custom_button__include_ftp_user' => "Включити ім’я користувача FTP",
    'custom_button__include_ftp_pass' => "Включити пароль FTP",
    'custom_button__internal_open' => "Відкрити URL в Plesk",
    'custom_button__text' => "Ярлик кнопки",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Цей файл не є графічним файлом.',
    'custom_button__big_image' => 'Розмір файлу не повинен перевищувати 100 KB.',
    'custom_button__failed_copy_image' => 'Неможливо скопіювати файл: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'В режимі Power User неможливо відновити резервну копію, створену не в режимі Power User.',
    '__unknown_network_interface' => 'Невідомий мережевий інтерфейс',

    'init_conf__ip_address' => 'IP-адреса',

    //Confirmation page
    'bt_confirm' => 'Підтвердити',
    'b_confirm' => 'Підтвердіть ваше право власності на сайти.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Параметри виділеного IIS-застосунків  встановлені згідно з загально-серверною політикою безпеки (конфігурація ізоляції між сайтами)',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Параметри виділеного пулу IIS-застосунків встановлені згідно з загально-серверними налаштуваннями продуктивності.',

    '__current' => 'Поточний',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Властивості користувача оновлено.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Ви використали майже всі домени, що поставляються з вашою ліцензією Plesk (90% або навіть більше).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Ви використали майже всі домени.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Ви використали майже всі сайти Presence Builder, що поставляються з вашою ліцензією Plesk (90% або навіть більше).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Ви використали майже всі сайти Presence Builder.',
    'promo__button_hide' => 'Приховати',
    'promo__button_next' => 'Далі >>',
    'promo__button_prev' => '<< Назад',
    'promo__button_license' => 'Оновити ліцензію',

    'promo__google_integration_title' => 'Інтеграція з сервісами Google',
    'promo__google_integration' => 'Сконфігурувати інтеграцію з сервісами Google, такими, як AdSense, Google Apps, Інструменти веб-майстра.',
    'promo__google_integration_button' => 'Конфігурувати',

    'promo__button_learn_more' => 'Дізнатися більше',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'ви можете персоналізувати оформлення інтерфейсу і налаштування брендингу за допомогою користувацьких тем. Для отримання інструкцій з персоналізації тем Plesk, зверніться до %1.',
    'panel_branding__description_link' => 'наступний документ',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Розпакувати файли',
    'b_filemanager__extract' => 'Витягніть файли з вибраних архівів до поточного каталогу. Зверніть увагу, що після витягнення імена файлів можуть відображатися неправильно, якщо в них є знаки, відсутні в латиниці.',
    'filemanager_error_extracting_files' => 'В процесі разархівації виникла помилка: %1',
    'filemanager_no_archive_files_specified' => 'Визначте архів, який ви бажаєте разархівувати.',
    'filemanager_not_zip_archive_specified' => '%1 не можна разархівувати, це не ZIP-архів.',
    'filemanager_files_successfully_extracted' => 'Файли було разархівовано.',
    'filemanager_error_file_download' => 'Завантаження файлу не вдалося: %1',
    'filemanager__user_poolgrp' => 'Група пула застосунків',

    'loading' => 'Завантаження...',
    'bt_create_archive' => 'Додати до архіву',
    'filemanager__pack' => "Шлях до архіву: %1",
    'filemanager__archive_name' => 'Назва файлу архіва',
    'filemanager__empty_filename' => 'Будь ласка, введіть назву файлу архіву',
    'filemanager_archive_created' => 'Архів було успішно створено.',
    'filemanager_error_creating_archive' => 'Неможливо створити архів: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Цей запис буде конфліктувати з АААА-записом для зони.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP сервер не підтримує IPv6 адреси).",
    'cmd_dns__glue_dns_record_conflict' => 'Даний запис буде конфліктувати з прив’язаним до зони \'%1\' записом.',
    '__ftp_ipv6_not_supported' => "(FTP-сервер не підтримує IPv6-адреси).",
    '__ipv6_not_supported' => 'IPv6 не підтримується.',
    'mail__ipv6_not_supported' => 'IPv6 не підтримується поштовим сервером.',
    'mail__relay_while_list_ipv6_not_supported' => 'Білий список IPv6 не підтримується поштовим сервером.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Значення маски має бути кратним 16.',
    'mail__ip_or_mask_is_invalid' => 'Некоректна IP-адреса або маска.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Переадресація на IP-адреси IPv6 не підтримується',
    'sa__invalid_trusted_networks' => 'Невірно вказані довірені мережі: %1',
    'dns_add__enter_ipv6_address' => "IPv6 адреса",
    'license_trial_days_left' => 'Ваш Plesk працює з ліцензією на пробне використання, яка закінчується через %1 днів.',
    'excl_ipv6_num' => 'Виділена IPv6-адреса',
    '__ip_mask' => "Маска підмережі",
    '__ipv4_addr' => 'Адреса IPv4',
    '__ipv6_addr' => 'IPv6 адреса',
    'template__num_excl_ipv6s' => 'Призначити виділені IPv6-адреси посереднику.',
    'anonftp__exclusive_ipv4_required' => 'Для встановлення та використання сервісу анонімного FTP необхідна виділена адреса IPv4.',
    'anonftp__ipv4_already_used' => 'Для даного сайту неможливо встановити сервіс анонімного FTP ‒ сервіс створено на іншому домені з такою самою адресою IPv4.',


    'restart__kav' => "Антивірус Касперського",
    '__view_migration_log_detailed_info' => 'Переглянути журнал',

    'chown__ip_address_warn' => 'Перед тим як перемістити підписку до нового власника, вам необхідно для цієї підписки вибрати нову IP-адресу.',
    'chown__no_ip_address' => 'Немає',
    'chown__no_ipv4_address' => 'Немає IPv4 адреси',
    'chown__no_ipv6_address' => 'Немає IPv6 адреси',
    'chown__domain_exclude_already_owned_by_client' => 'Підписка %1 вже належить цьому користувачу.',
    'chown__error_ip_absent_in_ip_pool' => 'IP-адреса %1 неприсутня в IP-пулі цільового користувача.',
    'chown__error_ip_not_exist' => 'IP-адреса з ID \'%1\' не існує.',
    'chown__error_domain_ip_not_selected' => 'Потрібно вибрати принаймні одну IP-адресу домену %1. Перевірте значення, вибрані для IP-мапування.',

    '__new_passwd_single' => "Пароль",
    '__confirm_passwd_single' => "Підтвердіть пароль",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Некоректна IPv6-адреса або маска — має бути коректна однопунктова IP-адреса.',

    '__subscriptions' => 'Підписки',

    '__owned_by_reseller' => 'Належить посереднику',
    '__owned_by_provider' => 'Належить постачальнику',

    'service_plan__anonymous' => 'Користувацький',
    'subscription_not_locked__change_limits_warning' => 'Ця підписка не заблокована: обмеження використання ресурсів буде змінено під час синхронізації з сервісним планом.',
    'subscription_not_locked__change_permissions_warning' => 'Ця підписка не заблокована ‒ повноваження будуть змінені під час синхронізації з сервісним планом.',

    'subscription__conflict_resolution_policy' => 'Політика вирішення конфліктів',
    'subscription__conflict_resolution_policy_lock' => "Заблокувати підписку",

    'backup__list__backup_warnings' => 'Попередження',
    'backup__list__backup_info' => 'Інформація',
    'backup__restore__object_reseller_template' => 'Шаблон посередника',
    'backup__restore__object_domain_template' => 'Шаблон домену',

    'ui__client/permissions_readonly__title' => 'Права доступу',
    'ui__client/permissions_readonly__short-title' => 'Права доступу',

    'subscription__unable_lock_anonymous' => 'Підписка не прив\'язана до сервісного плану, тому  розблокувати її неможливо.',
    'subscription__unable_sync_anonymous' => 'Підписка не прив\'язана до сервісного плану, тому  синхронізовувати її неможливо.',
    'subscription__unable_sync_locked' => 'Підписку заблоковано, тому її неможливо синхронізувати.',
    'subscription__locked' => 'Підписка заблокована.',
    'component_name__urlrewrite' => "Переписати URL",
    '__quantity' => 'Кількість',
    'hst__www_root_dir_absent' =>  'Попередження: папка, вказана в якості кореневої для документів, не існує.',
    'object_creation__domain_is_not_a_webspace' => 'Цей об’єкт може бути створений лише в підписці.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Підписка містить сайти, тому неможливо змінити тип хостингу або видалити її.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Помилка: Не вдалося оновити ІР-адресу. Додатковим доменам неможливо призначити ІР-адресу, яка не призначена головному домену підписки.',
    'domain_plan__unable_change' => 'Неможливо змінити сервісний %1',
    'domain_plan__different_hosting_type' => 'Поточний тип хостингу відрізняється від типу, зазначеного в сервісному плані.',
    'domain_plan__addon_text' => 'Додатковий план',
    'domain_plan__addon_description' => 'Додатковий план використовується для підтримки плану хостингу.',
    'asp_net__managed_runtime_version' => 'Версія ASP.NET з контрольованим часом виконання',
    'plan__can_not_change_hosting_type' => 'Неможливо змінити тип хостингу при редагуванні плану.',
    'plan__apply_problems' => 'План не був застосований через проблеми з функціональністю: %1',
    'plan_save__subscription_update_problem' => 'Неможливо застосувати зміни планів до %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Підписка тимчасово призупинена до завершення процесу резервного копіювання або відновлення. Будь ласка, зайдіть пізніше.",
    '__login_incorrect_plain_shadow_password' => 'ви вказали невірний пароль до облікового запису адміністратора. Будь ласка, скористайтеся (кореневими) обліковими даними системного адміністратора або отримайте вірний пароль. Щоб дізнатися більше про отримання пароля, прочитайте файл /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Неможливо надіслати IP-адресу, яка вам не належить',

    'dns__dns_zone_not_synchronized' => 'зона DNS була змінена. Якщо бажаєте використати шаблон DNS для цієї зони, натисніть \' Застосувати зміни шаблону DNS\' на цій сторінці, або Виберіть опцію \' Застосувати зміни до всіх зон\' на Панель адміністратора сервера > Інструменти та налаштування> Налаштування шаблону DNS > Застосувати зміни шаблону DNS.',
    'dns__dns_zone_synchronize_link' => 'Натисніть',
    'dns__dns_zone_synchronize_done' => 'Зона DNS була успішно синхронізована.',

    'dns__dns_zone_template_error' => 'Виникли проблеми під час синхронізації зон DNS з шаблоном зони DNS.%1',

    'dns__soa_rname_type_owner' => 'Електронна пошта власника сайту',
    'dns__soa_rname_type_domain' => 'Електронна поштова адреса домену',
    'dns__soa_rname_type_external' => 'Додаткова електронна пошта',
    'dns__soa_rname_enforce_email' => 'Заборонити змінювати електронну пошту RNAME на рівні доменів',
    'dns__soa_rname_label' => 'Електронна поштова адреса (RNAME)',
    'dns__soa_rname_hint' => 'Електронна пошта людини, що відповідає за DNS-зону домену. Повернено сервером DNS у відповідь на запити SOA.',

    'dns__dns_zone_soa_sync_title' => 'Заміщення налаштування SOA для усіх існуючих доменів',
    'dns__dns_zone_soa_sync_legend' => 'Необхідно підтвердження',
    'dns__dns_zone_soa_sync_text' => 'Бажаєте оновити записи SOA усіх розміщених доменів з використанням зміненого шаблону?',

    'cu_db__repair_mysql_dbus' => "Відновити паролі користувачів MySQL. Ця операція необхідна, якщо ви виконали модернізацію з більш ранньої версії Plesk до версії Plesk 11.",

    'cu_scheduled_backup_comment' => 'Заплановане резервне копіювання',
    'cu_scheduled_backup_error' => 'Під час резервного копіювання сталася помилка: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Помилка сталася під час запланованого резервного копіювання.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk entry point: %2\n\nПід час запланованого резервного копіювання сталися такі помилки:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Погодинне резервне копіювання',
    'cu_scheduled_backup_daily' => 'Щоденне резервне копіювання',
    'cu_scheduled_backup_weekly' => 'Щотижневе резервне копіювання',
    'cu_scheduled_backup_monthly' => 'Щомісячне резервне копіювання',
    'cu_scheduled_backup_comment_backup_all' => '%1. Уся конфігурація й вміст.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Уся конфігурація й вміст, окрім електронних листів.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Лише конфігурація й електронні листи.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Уся конфігурація й вміст, окрім користувацьких баз даних.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Уся конфігурація й вміст, окрім користувацьких файлів.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Лише конфігурація й користувацькі бази даних.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Лише конфігурація й користувацькі файли.',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Конфігурація домену.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Зберігання запланованих резервних копій у віддаленому хмарному сховищі - це преміальна функція. Зв\'яжіться з вашим надавачем розміщення, аби відкрити її.',

    'i_backup_invalid_file' => 'Ця резервна копія недійсна. Неможливо відновити дані з цього файлу. Натисніть на назву резервної копії для отримання детальної інформації.',

    'ui__server/migration/download-agent__short-title' => 'Завантажити Migration & Transfer Agent',
    'ui__server/migration/download-agent__title' => 'Завантажити Migration & Transfer Agent',
    'ui__server/migration/download-agent__description' => 'Завантажити останні доступні версії Migration & Transfer Agent з веб-сайту Plesk.',

    'filemanager_resulting_archive_exists' => 'Файл %1 вже існує в кінцевому каталозі.',

    'agent_unable_to_connect' => 'Помилка підключення до агента на \'%2\'. Переконайтеся, що агент встановлено та запущено, а також немає проблем з’єднання з вузлом \'%2\'.',
    'agent_test_connection_failed' => 'Помилка підключення до агента на \'%2\'.',

    'agent_unable_to_resolve_host' => 'Дистанційний вузол \'%1\' не знайдено. Переконайтеся, що немає проблем із з’єднанням.',
    'agent_unknown_curl_error' => 'Під час підключення до агента на \'%2\' виникла помилка \'%1\'.',
    'agent_unexpected_htp_code' => 'На HTTP-запит до агента на \'%2\' отримано непередбачений HTTP-код \'%1\'.',
    'agent_unable_to_auth' => 'Помилка автентифікації на вузлі \'%1\'. Для виріщення цієї проблеми, будь ласка, дотримуйтесь інструкцій на http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Під час виконання команди на дистанційному вузлі \'%1\' виникла внутрішня помилка сервера.',
    'agent_response_is_empty' => 'На HTTP-запит до агента на \'%1\' отримано порожню відповідь.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Не вдалося знайти Migration & Transfer Agent в локальному кеші. Перезапустіть Migration & Transfer Agent для усунення проблеми.',

    '__hosting_webdeploy' => "Публікування Web Deploy",
    'cu_domain__webdeploy' => "Публікую розгортання мережі (за стандартом: %1)",
    'cu_dom_tpl__webdeploy' => "Публікую розгортання мережі (за стандартом: %1)",
    'cu_subdomain__webdeploy' => "Публікую розгортання мережі (за замовчуванням: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy  на сервері не встановлено.",
    'webdeploy__forced_by_site_isolation' => "Неможливо змінити налаштування публікування Web Deploy: ви не маєте права доступу до перевизначення політики глобальної безпеки. За детальною інформацією зверніться до вашого постачальника.",



    'backup__restore_options__admin__server_configuration_license' => 'Ліцензійний ключ',
    'migration_start_migrate_server_license' => 'Передати ліцензійний ключ',

    'defaultcomponents__delegation_rule_not_exist' => '(необхідне правило розгортання \'appPoolPipeline, appPoolNetFx\' не існує)',

    '__o' => 'О',

    'i_backup_created_by_admin' => 'Резервна копія створена адміністратором.',
    'i_backup_created_by_reseller' => 'Резервна копія створена посередником.',
    'i_backup_created_by_client' => 'Резервна копія створена замовником.',

    'migration__object_exists_on_target_host' => '(вже існує на цільовому вузлі)',

    '__customers_total' => 'Разом за замовниками',
    '__resellers_total' => 'Разом по посередникам',
    '__reseller_total' => 'Разом по посереднику',


    'cu_cl_pref__manage_website_maintenance' => 'Доступ до додаткових операцій: копіювання веб-сайту',
    'cu_cl_pref__manage_protected_dirs' => 'Управління каталогами, захищеними паролями',
    'cu_cl_pref__manage_mail_settings' => 'Можливість змінювати налаштування пошти',


    'cu__command_update_php_settings' => 'Оновлює налаштування PHP.',
    'cu__php_settings_option' => 'Розраховує шлях до файлу з налаштуваннями PHP.',

    'cu__additional_php_settings_option' => 'Зазначає шлях до файлу з додатковими PHP директивами.',
    'cu__command_show_php_settings' => 'Відображає поточні налаштування PHP.',
    'cu__general_settings' => 'Загальні налаштування:',
    'cu__performance_settings' => 'Налаштування продуктивності:',
    'cu__php_fpm_settings' => 'Налаштування PHP-FPM:',
    'cu__additional_directives' => 'Додаткові настанови:',

    'php_settings_permission_required' => 'Управління загальними налаштуваннями PHP',
    'php_settings_performance_permission_required' => 'Управління налаштуваннями продуктивності хостинга',
    'php_settings_customized' => 'Налаштування PHP були персоналізовано.',
    'php_settings_synchronized_with_plan' => 'Налаштування PHP повинні синхронізуватися з планом.',
    'phosting__unknown_shell_type' => 'Недоступна оболонка',

    'login_up__access_denied_subscription_deleted' => 'Доступ заборонено. Вашу підписку вилучено.',

    'role_restricted_to_subscription' => '(передано з підпискою: %1)',

    'filemanager__extract' => "Витягніть файли до: %1",

    'cu__license_command_check_installed_license' => 'Перевірити вірність встановленого ліцензійного ключа (відповідає вихідним кодом "0" у разі, якщо ключ вірний, і "1", якщо він невірний)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Розширте функціональність Plesk, щоб мати можливість керувати та моніторити сервер з мобільних пристроїв (BlackBerry, iPhone, Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Отримати найважливішу інформацію про сервери Plesk у будь-який час і в будь-якому місці з мобільного пристрою (BlackBerry, iPhone та Android).',
    'promo__mobile_button' => 'Дізнатися більше',

    'ui__server/migration/video__short-title' => 'Навчальне відео',
    'ui__server/migration/video__title' => 'Переглянути навчальне відео',
    'ui__server/migration/video__description' => 'Переглянути навчальне відео.',

    'subDomainNameHint' => 'Для створення спільного субдомену введіть в якості його імені символ "*" . Відвідувачі сайту будуть потрапляти на цей субдомен незалежно від імені субдомену, введеного в оглядачі.',
    'subdomains__wildcard_name_invalid' => "Некоректне ім’я субдомену. В іменах спільних субдоменів дозволено використовувати лише чисельно-буквені символи, дефіс (-) та зірочку (*).",
    'subdomains__name_invalid' => "Некоректне ім’я субдомену. В іменах субдоменів дозволено використовувати лише чисельно-буквені символи та дефіс (-).",

    'domain__wildcard_no_www_prefix' => 'Неможливо використовувати www префікс для субдоменів wildcard.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Поштовий фільтр Plesk Postfix",
    '__milter' => "Postfix Milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Сервер Courier POP3",
    'restart__pop3s' => "Сервер Courier POP3 з підтримкою SSL/TLS",
    'restart__imap' => "Сервер кур’єра IMAP",
    'restart__imaps' => "Сервер кур’єра IMAP з підтримкою SSL/TLS",
    'restart__authdaemon' => "Daemon кур’єр IMAP ідентифікації",
    'restart__imap-pop3' => "Dovecot IMAP та POP3-сервер",


    'addon_packages_not_supported' => 'Додатки до застосунків, упакованих за стандартом APS, не підтримуються.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Неможливо автоматично призначити IP-адресу домену. Будь ласка, вкажіть IP-адресу, використовуючи –ip функцію.',

    'plesk_key__mb_accounts' => 'Облікові записи користувачів (посередників та замовників) у Customer and Business Manager',

    'actionlog__subdomain_dns' => 'DNS-зона субдомену',
    'actionlog__site_subdomain_dns' => 'DNS-зона субдомену додаткового домену',

    // PfW only
    'actionlog__event_site_create' => 'Домен створено',
    'actionlog__event_site_delete' => 'Домен видалено',
    'actionlog__event_site_update' => 'Домен оновлено',

    'actionlog__event_site_status_update' => 'Статус домену оновлено',
    'actionlog__event_site_dns_update' => 'DNS-зону домену оновлено',
    'actionlog__event_site_guid_update' => 'GUID домену оновлено',

    'actionlog__event_site_subdomain_create' => 'Субдомен створено',
    'actionlog__event_site_subdomain_delete' => 'Субдомен видалено',
    'actionlog__event_site_subdomain_update' => 'Субдомен оновлено',

    'actionlog__event_site_alias_create' => 'Створено псевдонім домену',
    'actionlog__event_site_alias_delete' => 'Видалено псевдонім домену',
    'actionlog__event_site_alias_update' => 'Псевдонім домену оновлено',

    'actionlog__event_site_alias_dns_update' => 'DNS-зону псевдоніму домену оновлено',
    'actionlog__event_subdomain_dns_update' => 'Оновлено DNS-зону субдомену домену за замовчуванням',
    'actionlog__event_site_subdomain_dns_update' => 'DNS-зону субдомену оновлено',
    // End of PfW only

    'win_policy__bad_password' => 'Збій перевірки. Пароль невірний.',
    'win_policy__password_too_short' => 'Збій перевірки. Введений пароль не відповідає вимогам політики паролів, тому що він занадто короткий.',
    'win_policy__password_too_long' => 'Збій перевірки. Введений пароль не відповідає вимогам політики паролів, тому що він занадто довгий.',
    'win_policy__password_not_complex_enough' => 'Перевірка не вдалася. Пароль недостатньо складний та не відповідає вимогам політики паролів. Сильні паролі мають містити, як мінімум, усе з наступного: вісім символів; один великий або малий символ; три цифри та один особливий символ (!, @, #, $, %, ^, &, *, ?, _, ~) або одну цифру та два особливих символи.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Неможливо оновити ліцензію продукта.',


    'filemanager__error_path_is_not_allowed' => 'Шлях недозволений',
    'filemanager__error_path_is_invalid' => 'Шлях недійсний',
    'filemanager__error_path_not_found' => 'Шлях не знайдений',
    'filemanager__error_path_already_exists' => 'Шлях вже існує',
    'filemanager__error_access_is_denied' => 'У доступі відмовлено',
    'filemanager__error_directory_not_empty' => 'Папка не є порожньою',
    'filemanager__error_sharing_violation' => 'Порушення спільного доступу',
    'filemanager__error_not_same_device' => 'Шлях призначення знаходиться не на тому ж самому пристрої',
    'filemanager__binary_data_access' => 'Це може бути двійковий файл. Бажаєте відкрити його?',
    'filemanager__unable_to_resolve_realpath' => "Неможливо знайти файл %1 за вказаним місцем",
    'filemanager__access_to_realpath_denied' => "Відмовлено у доступі до realpath: %1 (%2)",
    'bt_exit' => 'Вийти',

    'filemanager__chdir_error__' => "Неможливо змінити каталог на %1: %2",
    'filemanager__chmod_dir' => "Змінити права доступу для каталогу %1",
    'filemanager__chmod_error__' => "Неможливо змінити права доступу для файлу %1: %2",
    'filemanager__chmod_file' => "Змінити права доступу до файлу %1",
    'filemanager__copy_error__' => "Неможливо скопіювати %1 %2: %3",
    'filemanager__copy_move' => "Копіювати (перемістити) файли з %1",
    'filemanager__count_size__' => 'Розмір виділеного: %1',
    'filemanager__count_size_error__' => 'Неможливо розрахувати розмір для %1: %2',
    'filemanager__create_dir_error__' => "Неможливо створити каталог %1: %2",
    'filemanager__dir_not_exists' => "Каталог %1 не існує",
    'filemanager__dirname' => "Назва каталогу",
    'filemanager__filename' => "Назва файлу",
    'filemanager__is_no_such' => "Файл з таким ім'ям %1 в каталозі не існує",
    'filemanager__empty_selection' => "Не вибрано жодного(-их) файлу (-ів)",
    'filemanager__move_error__' => "Неможливо перемістити %1 в %2: %3",
    'filemanager__not_allowed' => "вам не дозволено змінювати права доступу для цього файлу.",
    'filemanager__remove' => "Видалити файли з: %1",
    'filemanager__remove_error__' => "Неможливо видалити файл %1: %2",
    'filemanager__rename_dir' => "Перейменувати каталог %1",
    'filemanager__rename_error__' => "Неможливо перейменувати %1 на %2: %3",
    'filemanager__rename_file' => "Перейменувати файл %1",
    'filemanager__set_win_permissions_dir' => "Встановити права доступу для %1 папки",
    'filemanager__set_win_permissions_file' => "Встановити права доступу для %1 файлу",
    'filemanager__touch_confirm' => "Ви впевнені, що бажаєте змінити часову мітку вибраних файлів?",
    'filemanager__upload_error__' => "Неможливо завантажити %1 у %2: %3",
    'filemanager__upload_file' => "Завантажити файл",
    'filemanager__upload_file_src' => "Шлях до файлу",
    'filemanager__max_image_size_exceeded' => 'Неможливо відобразити зображення. Розмір зображення не може бути більше ніж %2 байтів',

    '__fastcgi_unix_support' => 'Підтримка FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Записи DNS для даного субдомена зберігаються в кореневій зоні DNS. ви можете змінити кореневу зону %1 або створити окрему зону для цього субдомену.',
    'dns__subdomain_dns_zone_parent_link' => 'тут',
    'dns__no_dns_zone' => 'Немає зон DNS, призначених цьому домену. Для управління зоною DNS для вашого домену вам необхідно натиснути кнопку \'Відновити параметри за замовчуванням\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Неможливо переключитися на зону субдомену, тому що для цього субдомену  в зоні його батьківського домену існує запис CNAME.',

    '__hosting_write_modify' => 'Додаткові права запису/ модифікування',

    'aspdotnet__group_framework_version' => "Версія Framework",

    'bt_restore_default' => "Встановити за замовчуванням",
    'b_autoinstaller' => 'Оновити Plesk або його компоненти.',
    'b_autoinstaller_configure' => 'Оновити параметри.',
    'b_autoinstaller_install' => 'Встановіть вибрані компоненти.',

    '__iis_app_pool__use_dedicated' => 'Виділений пул застосунків IIS',
    '__iis_app_pool__use_dedicated_addons' => 'Виділений пул застосунків IIS для кожного веб-сайту',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Увімкнути 32-бітні програми',
    '__iis_app_pool__load_user_profile' => 'Завантажити профіль користувача',
    'bt_iis_app_pool' => "Пул застосунків IIS",

    'performance__cpu_usage' => 'Максимальне завантаження ЦП (%)',
    'performance__cpu_usage_action' => 'Дія обмеження',
    'performance__cpu_usage_interval' => 'Інтервал обмеження (хвилини)',
    'performance__cpu_usage_action_not_supported' => 'Зазначена дія не підтримується веб-сервером.',

    'performance__idle_timeout_action_not_supported' => 'Зазначена дія тайм-ауту простою не підтримується веб-сервером.',
    'performance__max_worker_processes' => 'Максимальна кількість робочих процесів',
    'performance__idle_timeout' => 'Тайм-аут простою (хвилини)',
    'performance__idle_timeout_action' => 'Дія тайм-ауту простою',
    'performance__recycling_by_time' => 'Переробка через рівні проміжки часу (у хвилинах)',
    'performance__recycling_by_requests' => 'Переробка при досягненні максимальної кількості запитів',
    'performance__recycling_by_virtual_memory' => 'Переробка при використанні максимальної кількості віртуальної пам\'яті',
    'performance__recycling_by_private_memory' => 'Переробка при використанні максимальної кількості власної пам\'яті',
    'performance__managed_pipeline_mode' => 'Режим керованого конвеєру',
    'performance__managed_pipeline_mode_not_supported' => 'Зазначений режим не підтримується веб-сервером.',

    'iis_app_pool' => 'Управління пулом застосунків IIS.',
    'b_iis_app_pool' => 'Управління пулом застосунків IIS.',
    'iis_app_pool_cl_dom' => 'Управління пулом застосунків IIS.',

    'l_webdirerrordocslist_code' => 'Упорядкувати документи про помилки за кількістю кодів помилки.',
    'l_webdirerrordocslist_name' => 'Упорядкувати документи про помилки за описом помилки.',
    'l_webdirerrordocslist_type' => 'Упорядкувати документи про помилки за типом документу про помилки.',
    'l_webdirerrordocslist_location' => 'Упорядкувати окументи про помилки за місцем розташування документів персоналізованих помилок.',

    'b_webdirerrordocslist_search' => 'Введіть пошуковий шаблон та натисніть кнопку для пошуку документів помилок.',
    'b_webdirerrordocslist_remove' => 'Видаліть вибрані документи помилок.',
    'b_webdirerrordocslist_show_all' => 'Показати всі документи про помилки.',

    'l_webdirmimetypeslist_name' => 'Упорядкувати типи MIME за розширенням.',
    'l_webdirmimetypeslist_content' => 'Упорядкувати типи MIME за вмістом.',

    'b_webdirmimetypeslist_remove' => 'Видаліть вибрані типи MIME.',
    'b_webdirmimetypeslist_search' => 'Введіть пошуковий шаблон та натисніть кнопку для пошуку типів MIME.',
    'b_webdirmimetypeslist_show_all' => 'Показати всі типи MIME.',

    'b_webdir_preferences' => "Налагодження віртуального каталогу.",
    'b_webdir_permissions' => "Дозволи віртуальних каталогів.",
    'b_webdir_permissions_disabled' => "Управління правами доступу до каталогу недоступно.",
    'b_to_webdirs' => 'Повернутися до управління каталогами.',
    'b_to_webdir_mime_types' => 'Повернутися до управління моделями MIME.',
    'b_to_webdir_error_docs' => 'Повернутися до управління документами про помилки.',
    'b_to_webdir_protection' => 'Повернутися до управління захистом віртуального каталогу.',

    'webdirs__title' => 'Віртуальний каталог %1',
    'webdirs__preferences_title' => 'Налаштування віртуального каталогу',
    'webdirs__tabs_general' => 'Загальні дані',
    'webdirs__tabs_mime_types' => 'Типи MIME',
    'webdirs__tabs_error_docs' => 'Документи помилок',

    'webdirs__tabs_permissions' => 'Права доступу',
    'webdir__remove_vdirs' => 'Буде видалено такі віртуальні каталоги:',
    'webdir__remove_mime_types' => 'Буде видалено такі типи MIME:',
    'webdir__mime_types_title' => 'Типи MIME',
    'webdir__protection_disable_confirm' => 'Ви дійсно бажаєте зняти захист з каталогу?',
    'webdir__protect_title' => 'Захищені користувачі URL',
    'webdirs__permissions_title' => 'Права доступу віртуального каталогу',
    'error_doc__list_code' => 'Помилка',
    'error_doc__list_code_description' => 'Опис',
    'error_doc__list_type' => 'Тип',
    'error_doc__list_location' => 'Положення',
    'error_doc__code' => 'Помилка',
    'error_doc__type' => 'Тип',
    'error_doc__type_file' => 'Файл',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Положення',
    'error_doc__legend' => 'Документ помилок',
    'error_doc__edit_title' => 'Редагувати документ помилок',
    'error_doc_erorr_invalid_url_location' => 'Невірна веб-адреса. Будь-ласка, введіть правильну веб-адресу.',
    'error_doc_erorr_invalid_file_location' => 'Невірний шлях до файлу. Будь ласка, вкажіть правильний шлях до файлу.',
    'error_doc__type_default' => 'За замовчуванням',

    'webdirs__tabs_protection' => 'Захист',
    'pb_webdirs' => 'Віртуальні каталоги',

    'webdirs_mime_types_remove_title' => 'Буде видаленот такі типи МІМЕ:',
    'webdirs_preferences_title' => 'Налаштування віртуального каталогу',
    'webdirs_permissions_title' => 'Спеціальні права доступу до файлів та папок',
    'webdi_protection_disable_confirm' => 'Ви впевнені, що бажаєте зняти захист з віртуального каталогу? Це також призведе до видалення всіх користувачів захищеного каталогу та налаштувань захисту каталогу.',
    'bt_protect' => 'Захистити',
    'bt_unprotect' => 'Зняти захист',
    'bt_show_additional_users' => 'Показати більше користувачів',
    'bt_hide_additional_users' => 'Приховати користувачів',
    'error_doc__list_title' => 'Документи помилок',
    'error_doc__list_header' => 'Документи помилок',
    'error_doc__code_400' => 'Невірний запит',
    'error_doc__code_401' => 'Несанкціонований доступ',
    'error_doc__code_401.1' => 'Несанкціонований доступ – Невдалий вхід',
    'error_doc__code_401.2' => 'Несанкціонований доступ – Невдалий вхід внаслідок конфігурації сервера',
    'error_doc__code_401.3' => 'Несанкціонований доступ – Вхід не санкціоновано ACL ресурсу',
    'error_doc__code_401.4' => 'Несанкціонований доступ – Вхід заблоковано фільтром',
    'error_doc__code_401.5' => 'Несанкціонований доступ – ISAPI/CGI блокує вхід',
    'error_doc__code_401.7' => 'Несанкціонований доступ – Відхилено внаслідок політики дозволених URL',
    'error_doc__code_403' => 'Заборонено',
    'error_doc__code_403.1' => 'Заборонено – У доступі відмовлено',
    'error_doc__code_403.2' => 'Заборонено – Відмовлено в доступі для читання',
    'error_doc__code_403.3' => 'Заборонено – Відмовлено в доступі для запису',
    'error_doc__code_403.4' => 'Заборонено – Необхідний SSL',
    'error_doc__code_403.5' => 'Заборонено – Необхідний SSL 128',
    'error_doc__code_403.6' => 'Заборонено – IP-адреса відхилена',
    'error_doc__code_403.7' => 'Заборонено – Потрібен сертифікат клієнта',
    'error_doc__code_403.8' => 'Заборонено – Немає доступу до сайту',
    'error_doc__code_403.9' => 'Заборонено – Забагато користувачів',
    'error_doc__code_403.10' => 'Заборонено – Недійсна конфігурація',
    'error_doc__code_403.11' => 'Заборонено – Зміна паролю',
    'error_doc__code_403.12' => 'Заборонено – Доступ закритий MAPPER’ом',
    'error_doc__code_403.13' => 'Заборонено – Сертифікат клієнта відкликано',
    'error_doc__code_403.14' => 'Заборонено – Внесення до списку каталогу відхилено',
    'error_doc__code_403.15' => 'Заборонено – Перевищено клієнтську ліцензію на доступ',
    'error_doc__code_403.16' => 'Заборонено – Сертифікат клієнта недостовірний та неприпустимий',
    'error_doc__code_403.17' => 'Заборонено – Період використання сертифіката клієнта вже закінчився або ще не настав',
    'error_doc__code_403.18' => 'Заборонено – Неможливо виконати запит з цього пулу застосунків',
    'error_doc__code_403.19' => 'Заборонено – Відмовлено в доступі до CGI',
    'error_doc__code_403.20' => 'Заборонено – Невірний логін паспорту',
    'error_doc__code_404' => 'Не знайдено',
    'error_doc__code_404.2' => 'Не знайдено – Відмовлено через політику ізоляції',
    'error_doc__code_404.3' => 'Не знайдено – Відмовлено через політику MIMEMAP',
    'error_doc__code_405' => 'Метод недозволений',
    'error_doc__code_406' => 'Неприйнятно',
    'error_doc__code_407' => 'Необхідна автентифікація проксі',
    'error_doc__code_412' => 'Передумова не була виконана',
    'error_doc__code_414' => 'Занадто довгий період запиту',
    'error_doc__code_415' => 'Формат мультимедійного файлу не підтримується',
    'error_doc__code_500' => 'Внутрішня помилка серверу',
    'error_doc__code_500.12' => 'Внутрішня помилка серверу – Перезапуск застосунку',
    'error_doc__code_500.13' => 'Внутрішня помилка серверу – Сервер зайнятий',
    'error_doc__code_500.15' => 'Внутрішня помилка серверу – Прямий запит на GLOBAL.ASA заборонено',
    'error_doc__code_500.16' => 'Внутрішня помилка серверу – Помилка доступу UNC',
    'error_doc__code_500.17' => 'Внутрішня помилка серверу – Пам’ять URL не знайдено',
    'error_doc__code_500.18' => 'Внутрішня помилка серверу – Пам’ять URL неможливо відкрити',
    'error_doc__code_500.19' => 'Внутрішня помилка серверу – Неправильні метадані файлу',
    'error_doc__code_500.100' => 'Внутрішня помилка серверу – Помилка ASP',
    'error_doc__code_501' => 'Не здійснено',
    'error_doc__code_502' => 'Неправильний шлюз',
    'error_doc__code_503' => 'Сервіс тимчасово недоступний',

    'mimetype__extension' => 'Модуль',
    'mimetype__content' => 'Вміст',
    'mimetypeslist__title' => 'Типи MIME',
    'mimetypes__title' => 'Типи MIME',
    'mimetypes__select_to_remove' => 'Виберіть типи MIME, які необхідно Видаліть',
    'mimetypes__select_for_remove' => "Вибрати типи MIME, які необхідно Видаліть",
    'mimetypes_remove__title' => 'Видаліть тип MIME',
    'mimetype__legend' => 'Тип MIME',
    'mimetype_edit__title' => 'Редагувати тип MIME',
    'mimetype_edit__already_exists' => 'Тип MIME вже визначний для цього розширення.',
    'mimetype_edit__not_exists' => 'Тип MIME не існує',
    'mimetype__content_type_other' => 'Користувацький...',

    'b_webdir_protection_enable' => 'URL каталогу повинен бути захищений паролем.',
    'b_webdir_protection_disable' => 'Встановіть URL, який відповідає каталогу, що є доступним усім.',
    'b_webdir_protection_disabled' => 'Захист віртуального каталогу вимкнено.',

    'b_pd_usr_create' => 'Натисніть, щоб створити цього захищеного користувача URL.',
    'php__group_php_version' => "Версія PHP",

    'virtualdir__name' => 'Ім’я',
    'virtualdir__path' => 'Шлях',
    'virtualdir__read' => 'Дозвіл на читання',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Написати дозвіл',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Доступ до джерела скрипту',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Перегляд каталогу',
    'virtualdir__browse_short' => 'Б',
    'virtualdir__script_execute' => 'Виконати права доступу',
    'virtualdir__script_execute_short' => 'Е',
    'virtualdir__log_visits' => 'Реєструвати відвідування',
    'virtualdir__app_create' => 'Створіть застосунок',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Вмикає анонімну перевірку автентичності.',
    'virtualdir__auth_windows' => 'Вмикає перевірку автентичності Windows.',
    'virtualdir__auth_not_enabled' => 'Анонімна перевірка автентичності або перевірка автентичності Windows повинні бути ввімкнені.',
    'virtualdir__require_ssl' => 'Потребує SSL/TLS',
    'virtualdir__enable_default_doc' => 'Використати документи за замовчуванням',
    'virtualdir__default_doc' => 'Порядок пошуку документів за замовчуванням',
    'virtualdir__enable_parent_paths' => 'Дозволити використання батьківських шляхів',
    'virtualdir__execute_in_mta' => 'Дозволити виконання застосунку в режимі МТА (багатопотоковий підрозділ)',
    'virtualdir_create__title' => 'Створити віртуальний каталог у %1',
    'virtualdir_edit__title' => 'Властивості віртуального каталогу %1',
    'virtualdir_edit__legend' => 'Віртуальний каталог',
    'virtualdir_edit__application_legend' => 'Налаштування застосунку',
    'virtualdir_edit__security_legend' => 'Безпека каталогу',
    'virtualdir_edit__documents_legend' => 'Документи',
    'virtualdir_edit__list_legend' => 'Вкладені віртуальні каталоги',
    'virtualdir_error__path_not_in__' => 'Визначено недійсний шлях',
    'virtualdir_error__already_exists' => 'Каталог з таким ім\'ям вже існує.',
    'virtualdir_root' => 'Віртуальні каталоги',
    'virtualdir_root__title' => 'Віртуальні каталоги',
    'virtualdir_root__list_legend' => 'Віртуальні каталоги',
    'virtualdir_se__none' => 'Немає',
    'virtualdir_se__script' => 'Тільки скрипти',
    'virtualdir_se__script_execute' => 'Скрипти та виконувані програми',
    'virtualdirs__title' => 'Віртуальні каталоги',
    'virtualdirs__path_not_exists' => 'Невірний шлях.',
    'virtualdirs__select_for_remove' => "Виберіть віртуальні каталоги для видалення.",
    'virtualdirs_remove__title' => 'Видалити віртуальні каталоги',
    'virtualdirs_phys_dir_exist' => 'Фізичний каталог з таким ім\'ям вже існує. Якщо ви продовжите, він стане недоступним. Бажаєте продовжити?',
    'virtualdir_auto_create_dir' => "Створити фізичний каталог з ім’ям віртуального каталогу",

    'asp_max_default_text' => 'Визначено батьківським каталогом (%1 KB)',
    'asp_max_default_text_site' => 'Визначено IIS (%1 KB)',
    'asp_max_buffer_text' =>'Максимальний розмір буферу ASP (KB)',
    'asp_max_body_text' => 'Максимальний розмір об’єкту запиту ASP (KB)',
    'asp_buffers_legend' =>'Налаштування ASP',

    'asp_debug_default_text' =>'Визначено батьківським каталогом',
    'asp_debug_default_text_site' =>'Визначено IIS',
    'asp_client_debug_text' =>'Ввімкнути налагодження клієнтського скрипту ASP',
    'asp_server_debug_text' =>'Ввімкнути загально-серверний ASP скрипт налагодження',

    'webdirs__physical_path_not_exist' => "Зазначений шлях не існує.",

    'permissions__group_or_user_name' => 'Імена груп або користувачів',
    'permissions__FullControl' => 'Повне управління',
    'permissions__Modify' => 'Змінити',
    'permissions__ReadAndExecute' => 'Зчитати і виконати',
    'permissions__ListFolderContents' => 'Список  вмісту папкаи',
    'permissions__Read' => 'Зчитати',
    'permissions__Write' => 'Записати',
    'permissions__ReadControl' => 'Зчитати управління',
    'permissions__WriteControl' => 'Записати управління',
    'permissions__ExecuteControl' => 'Запустити управління',
    'permissions__TraverseFolderOrExecuteFile' => 'Пройти папку / Виконати файл',
    'permissions__ListFolderOrRead' => 'Список папки/ Зчитати дані',
    'permissions__CreateFilesOrWrite' => 'Створити файли / Записати дані',
    'permissions__CreateFoldersOrAppend' => 'Створіть папки / Доєднайте дані',
    'permissions__DeleteSubfoldersandFiles' => 'Видаліть підпапки і файли',
    'permissions__Delete' => 'Видалити',
    'permissions__ChangePermissions' => 'Змінити права доступу',
    'permissions__TakeOwnership' => 'Забрати право власності',
    'permissions__inherited_from' => 'Успадковано від',
    'permissions__not_inherited' => '<не успадковано>',
    'permissions__apply_to' => 'Застосувати до',
    'permissions__apply_onto' => 'Застосувати для:',
    'permissions__apply_onto1' => 'Лише цієї папки',
    'permissions__apply_onto2' => 'Лише вкладених папок',
    'permissions__apply_onto3' => 'Цієї папки та вкладених папок',
    'permissions__apply_onto4' => 'Лише файлів',
    'permissions__apply_onto5' => 'Ця папка і файли',
    'permissions__apply_onto6' => 'Лише підпапка і файли',
    'permissions__apply_onto7' => 'Ця папка, підпапка і файли',

    'filemanager__not_allowed_dir' => "вам не дозволено змінювати права доступу для цієї папки.",

    'filemanager__allow' => "Дозволити",
    'filemanager__deny' => "Скасувати",
    'filemanager__user_domusr' => 'Адміністратор веб-сайту',
    'filemanager__user_webusr' => 'Користувач мережі',
    'filemanager__user_admins' => 'Адміністратори',
    'filemanager__user_system' => 'СИСТЕМА',
    'filemanager__user_aspnet' => 'Користувач ASP.NET',
    'filemanager__user_poolusr' => 'Користувач пула застосунків',
    'filemanager__user_sysaccount' => 'Додатковий користувач системи',

    'bt_permissions_advanced' => 'Додаткові параметри',
    'b_permissions_advanced' => 'Натисніть кнопку для того, щоб передивитися і встановити спеціальні права доступу.',

    'hotlink-protection_invalid_friend_domain' => 'Неприпустиме ім’я дружнього домену.',
    'hotlink-protection_duplicate_friend_domain' => 'Це ім’я дружнього домену вже використовується.',
    'hotlink-protection_invalid_extensions' => 'Розширення файлів містять неприпустимі символи.',

    'i_domain_alias_status_on' => 'Псевдонім домену включений.',
    'i_domain_alias_status_off' => 'Псевдонім домену відключений.',
    'i_domain_alias_status_with_parent' => 'Поштовий сервіс відключений, тому що відключений домен.',
    'i_domain_alias_turn_off' => 'Натисніть для відключення.',
    'i_domain_alias_turn_on' => 'Натисніть для включення.',
    'i_domain_alias_mail_on' => 'Поштовий сервіс включений для цього псевдоніма домену.',
    'i_domain_alias_mail_off' => 'Поштовий сервіс відключений для цього псевдоніма домену.',
    'i_domain_alias_mail_with_parent' => 'Поштовий сервіс відключений, тому що відключений псевдонім домену.',
    'i_domain_alias_web_on' => 'Веб-сервіс включений для цього псевдоніма домену.',
    'i_domain_alias_web_off' => 'Веб-сервіс відключений для цього псевдоніма домену.',
    'i_domain_alias_web_with_parent' => 'Веб-сервіс відключений, тому що відключений псевдонім домену.',
    'i_domain_alias_dns_on' => 'Сервіс псевдування DNS ввімкнено для цього псевдоніма домену.',
    'i_domain_alias_dns_off' => 'Сервіс псевдування DNS вимкнено для цього псевдоніма домену.',
    'i_domain_alias_dns_with_parent' => 'Синхронізація DNS з батьківським доменом відключена, тому що відключений псевдонім домену.',
    'i_domain_alias_seoRedirect_on' => 'Перенаправлення з кодом HTTP 301 ввімкнено для цього псевдоніма домену.',
    'i_domain_alias_seoRedirect_off' => 'Перенаправлення з кодом HTTP 301 вимкнено для цього псевдоніма домену.',
    'i_domain_alias_seoRedirect_with_parent' => 'Перенаправлення з кодом HTTP 301 вимкнено, оскільки псевдонім домену відключений.',

    'domain_alias__control_title' => 'Альтернативне ім’я домену %1',
    'domain_alias__control_info_legend' => 'Інформація',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Ім’я сервісу',
    'domain_alias__control_details_title' => 'Деталі',

    'domain_alias__invalid_values' => 'Зазначене вами ім’я домену невірне. Ім’я домену може складатися з літер, цифр та дефісів. Кожна частина імені домену між крапками повинна складати не більше ніж 63 символи.',
    'domain_alias__domain_already_exists' => "Невірне ім’я альтернативного імені домену %1. Домен %1 вже існує.",
    'domain_alias__www_prefix_domain_already_exists' => "Невірне ім’я псевдоніму домену www.%1. Цей псевдонім вже зайнятий доменом %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Невірне ім’я веб-пошти псевдоніму домену.%1. Цей псевдонім вже зайнятий доменом %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Невірне ім’я псевдоніму домену .%1. Це псевдонім вже зайняте доменом %1.',
    'domain_alias__dns_record_already_exists' => 'Неможливо встановити псевдонім домену %1, оскільки записи DNS вказують, що хост %1 вже існує.',
    'domain_alias__domain_alias_already_exists' => "Псевдонім домену з таким ім’ям вже існує.",
    'domain_aliases__mail_server_not_support_aliases' => 'Поштовий сервер не підтримує функцію альтернативного імені домену. Альтернативні імена домену можуть функціонувати некоректно.',
    'domain_alias__restrict_domain_creation' => 'Зазначене ім\'я альтернативного імені домену заборонене політикою сервера. Якщо це альтернативне ім\'я домену належить вам, зверніться до вашого постачальника хостингу.',
    'domain_alias__restrict_creation_with_www' => 'Будь ласка, введіть ім\'я домену без префіксу \'www\'. Префікс www для домену буде автоматично доданий до конфігурації веб-серверу.',
    'domain_unable_to_set_name' => 'Неправильне ім\'я %1.',

    'domain_alias__domain_service_dns_disabled' => 'Цей домен обслуговується іншим DNS-сервером.',
    'domain_alias__domain_service_dns_enabled_master' => 'Цей DNS-сервер діє в якості первинного серверу для цієї зони DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Цей DNS-сервер діє в якості вторинного серверу для цієї зони DNS.',
    'domain_alias__domain_service_mail_enabled' => 'Поштовий сервіс для цього домену було ввімкнено.',
    'domain_alias__domain_service_mail_disabled' => 'Поштовий сервіс для цього домену було вимкнено.',
    'domain_alias__domain_service_mail_mx' => '%1 використовується в якості поштового сервера.',

    'domain_alias__service_seoRedirect_hint' => 'Коли відвідувачі відкриють URL псевдоніму, вони будуть перенаправлені на URL первинного домену. Plesk використовує переадресацію HTTP 301, яка є дружньою по відношенню до пошукових систем; це означає, що ранжування пошуковою системою не буде розділятися між URL.',

    'bt_task_run_now' => 'Запустити зараз',
    'ftp__read_perm' => "Дозвіл на читання",
    'ftp__write_perm' => "Написати дозвіл",

    'filemanager__upload_backup_file_hint' => 'Тут можна завантажити резервні файли до сховища Plesk. Максимальний розмір файлу обмежено до двох гігабайт.',

    '__default_for_mssql' => 'за замовчуванням для MS SQL',

    '__login_does_not_pass_validation' => "Невірне ім’я користувача. Переконайтеся, що воно відповідає таким вимогам: %1",
    '__login_allowed_symbols' => 'Дозволяються тільки алфавітно-цифрові символи, включно з точками, тире і підкресленнями. Перший символ повинен бути алфавітно-цифровим.',

    'restart__nginx' => 'Зворотній Проксі Сервер (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Я хочу отримувати сповіщення та загальну інформацію про продукти від Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Я хочу отримувати інформацію про безпеку та іншу технічну інформацію від Plesk.",

    '__login_status_inactive' => 'Ваш обліковий запис неактивний.  Будь ласка, зверніться до адміністратора Plesk.',

    'migration__task_keep_in_process' => 'ОК',
    'migration__task_keep_in_process_conhelp' => 'Повернутись на сторінку Інструменти та налаштування. Міграція буде продовжена у фоновому режимі.',

    'ui__admin-alias-info__description' => "Редагувати контактну інформацію облікового запису додаткового адміністратора.",
    'ui__admin-alias-info__short-title' => "Контактна інформація",
    'ui__admin-alias-info__title' => "Інформація про обліковий запис додаткового адміністратора",
    'ui__admin-alias-password__description' => "Змінити пароль облікового запису додаткового адміністратора.",

    'ui__admin-alias-password__short-title' => "Змінити пароль",
    'ui__admin-alias-password__title' => "Пароль додаткового адміністратора",
    'ui__admin-alias__description' => "Перегляд та редагування інформації облікових записів додаткового адміністратора.",

    'chk_js__warning_about_login_syntax' => "ви можете використовувати нижній регістр чисельно-буквених символів, тире і символ підкреслення в імені користувача. Ім'я користувача повинно починатися з алфавітного символу. Пароль не повинен містити ім'я користувача і лапки.",
    'chk_js__warning_about_ftp_login_syntax' => "Ім’я користувача може містити чисельно-буквені символи, дефіс та символ підкреслювання.",
    'chk_js__warning_about_login_syntax_win' => "ви можете використовувати нижній регістр чисельно-буквених  символів, тире, крапку і символ підкреслення в імені користувача. Ім'я користувача повинно починатися з алфавітного символу або числа. Пароль не повинен містити ім'я користувача і лапки.",
    'chk_js__warning_about_passwd_syntax' => "Не використовуйте в паролі лапки, пробіл та символи національного алфавіту.\nПароль має бути між %1 та %2 символами у довжину та не має містити ім'я користувача.",
    'chk_js__warning_about_plesk_login_syntax' => "ви можете використовувати нижній регістр чисельно-буквених символів, точку, тире і символ підкреслення в імені користувача.",
    'chk_js__warning_about_plesk_login_syntax_win' => "ви можете використовувати нижній регістр чисельно-буквених символів, тире і символ підкреслення в імені користувача. Ім'я користувача повинно починатися з буквеного символу.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Не використовуйте у паролі лапки, пробіл та символи національних алфавітів.\nПароль має бути довжиною між %1 та %2 символами та не має містити ім'я користувача.",
    'chk_js__warning_about_pam_passwd_error' => "Було вказано невірний обліковий запис користувача системи: %1",

    'cmd_server__admin_alias_not_found' => "Не можу знайти додатковий обліковий запис адміністратора.",

    'panel_branding__skins_already_exists' => "Примітка: тема '%1' вже існує. Вона буде замінена на тему, яку ви зараз встановлюєте.",
    'panel_branding__skins_file_exists' => "Неможливо створити каталог для теми '%1': файл з такою назвою вже існує.",

    'actionlog__login_failed' => 'невдала спроба зайти на сайт',
    'actionlog__event_cp_user_login_failed' => 'Користувачу Plesk не вдалося увійти до системи',
    'actionlog__api_login_failed' => 'не зміг увійти через API',
    'actionlog__event_cp_user_api_login_failed' => 'Користувачу Plesk не вдалося увійти до системи через API',
    'actionlog__pw_reset' => 'відправлено запит на скидання пароля',
    'actionlog__pw_admin_force_reset' => 'було запрошено примусове скидання пароля адміністратора',

    'ch_pass_admin__email_subject' => "Нагадування про пароль Plesk",
    'ch_pass_admin__email_body' => "Вітаємо! %1.\n\nПароль адміністратора не можна надіслати електронною поштою з міркувань безпеки.\n\nЩоб увійти як 'admin', скористайтеся командою 'plesk login'.\n\nЩоб установити новий пароль 'admin', скористайтеся командою 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Неможливо надіслати листа: %1',

    'ch_pass_by_secret__email_subject' => "Нагадування про пароль Plesk",
    'ch_pass_by_secret__email_body' => "Добрий день, %2! \n\nЩоб встановити новий пароль, будь ласка, перейдіть за посиланням: %1 \n\nВаш логін: %3",
    'ch_pass_by_secret__message_send_error' => 'Не можу вислати секретний код: %1',
    'ch_pass_by_secret__title' => 'Змінити свій пароль',
    'ch_pass_by_secret__secret' => 'Секретний код',

    'custom_button__noframe' => "Не використовуйте фрейми",

    'custom_button__internal_hint' => 'Вказати, чи слід відкрити URL на сторінці Plesk або в новому вікні оглядача.',
    'custom_button__noframe_hint' => 'Якщо ви додаєте користувацьку кнопку, яка веде до розширення Plesk, або застосунок до розділу Панель замовника, то ви можете визначити як саме це розширення/застосунок буде відображатися: в окремій рамці, чи в якості частини Plesk GUI.',


    'actionlog__patch' => 'Оновлення',
    'actionlog__patch_available' => 'доступне',
    'actionlog__event_patch_available' => 'Доступні нові оновлення',
    'actionlog__patch_installed' => 'встановлено',
    'actionlog__event_patch_installed' => 'Встановлено оновлення',

    'actionlog__extension' => 'Модуль',
    'actionlog__extension_status' => 'Статус розширення',
    'actionlog__cloning' => 'Клонування сервера',
    'actionlog__cloning_complete' => 'завершено',
    'actionlog__event_cloning_complete' => 'Клонування сервера завершено',

    'actionlog__ssl_web_binding' => 'Сертифікат SSL/TLS для домену',
    'actionlog__ssl_web_binding_update' => 'призначено/не призначено',
    'actionlog__event_ssl_web_binding_update' => 'Сертифікат SSL/TLS для домену призначено/скасовано',

    'actionlog__ssl_web_mail_binding' => 'Сертифікат SSL/TLS для веб-пошти',
    'actionlog__ssl_web_mail_binding_update' => 'призначено/не призначено',
    'actionlog__event_ssl_web_mail_binding_update' => 'Сертифікат SSL/TLS для веб-пошти призначено/не призначено',

    'actionlog__ssl_mail_binding' => 'Сертифікат SSL/TLS для поштового сервера',
    'actionlog__ssl_mail_binding_update' => 'призначено/не призначено',
    'actionlog__event_ssl_mail_binding_update' => 'Сертифікат SSL/TLS для поштового сервера призначено/не призначено',

    'actionlog__ssl_panel_binding' => 'Сертифікат SSL/TLS для Plesk',
    'actionlog__ssl_panel_binding_update' => 'призначено/не призначено',
    'actionlog__event_ssl_panel_binding_update' => 'Сертифікат SSL/TLS для Plesk призначено/не призначено',

    'actionlog__hostname' => 'Серверне ім\'я розміщувача',
    'actionlog__hostname_changed' => 'змінено',

    'actionlog__smb_user' => 'Додатковий користувач',
    'actionlog__smb_user_create' => 'Додаткового користувача створено',
    'actionlog__smb_user_delete' => 'Додаткового користувача видалено',
    'actionlog__smb_user_update' => 'Додаткового користувача оновлено',

    'actionlog__event_mail_management_status_update' => 'Оновлення статусу керування поштою',
    'actionlog__mail_management' => 'Статус керування поштою',
    'actionlog__mail_management_status_update' => 'оновлено',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Разом за доменами',

    'chk_js__warning_about_admin_passwd_syntax' => "Не слід використовувати у паролі лапки, пробіли, крапку з комою та символи національного алфавіту.\nДовжина паролю має бути від %1 до %2 символів, пароль не повинен містити ім’я користувача.",

    'passwordSecurityLevelCheckFailed' => 'Ваш пароль недостатньо складний. Згідно з політикою сервера мінімальна довжина паролю складає %1. Для збільшення довжини паролю можна використати числа, символи верхнього та нижнього регістру або спеціальні символи (наприклад, !, @, #, $, %, ^, &, *, ?, _, ~)',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Дуже ненадійний',
    'passwordSecurityLevelCheckFailedWeak' => 'Ненадійний',
    'passwordSecurityLevelCheckFailedMediocre' => 'Середній',
    'passwordSecurityLevelCheckFailedStrong' => 'Надійний',
    'passwordSecurityLevelCheckFailedStronger' => 'Дуже надійний',

    'ui__client/domain/dns/sync__description' => 'Застосувати зміни з загальносерверного DNS-шаблону до зони.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Неможливо застосувати зміни DNS-шаблону до зони, тому що зону обслуговує інший DNS-сервер.',
    'ui__client/domain/dns/sync__short-title' => 'Застосувати зміни DNS-шаблону',
    'ui__client/domain/dns/sync__done' => 'Зміни з DNS-шаблону успішно застосовано до зони.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Застосувати зміни з загальносерверного DNS-шаблону до зони.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Неможливо застосувати зміни DNS-шаблону до зони, тому що зону обслуговує інший DNS-сервер.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Застосувати зміни DNS-шаблону',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Зміни з DNS-шаблону успішно застосовано до зони.',
    'dns__dns_default_ipv4_modified' => 'Записи з цією IP-адресою будуть розглядатися як відкоректовані користувачем і не будуть синхронізовані с загально-серверним DNS-шаблоном.',
    'dns__dns_default_ipv6_modified' => 'Записи з цією IP-адресою будуть розглядатися як відкоректовані користувачем і не будуть синхронізовані с загально-серверним DNS-шаблоном.',

    'dns__view_dns_record_master_title' => 'Переглядаю записи ресурсу',
    'dns__view_dns_record_off_title' => 'Переглядаю записи вказаного сервера',
    'dns__view_dns_record_slave_title' => 'Переглядаю записи первинного DNS-сервера',

    'dns_unable_to_resolve_hostname' => "Неможливо вирішити ім'я хосту \"%1\": %2",

    'no_database_server_available' => 'Для цієї підписки немає доступних серверів бази даних.',

    'database_used_by_application_can_not_be_moved' => 'Не вдалося перемістити базу даних: її використовує застосунок веб-сайту.',
    'database_user_update_orphaned_is_restricted' => 'Оновлення загублених облікових записів користувачів баз даних заборонено. Ви можете їх лише видалити або виправити.',

    'database_unable_to_get_max_filesize_default_message' => 'Неможливо визначити максимальний розмір файлу бази даних: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Неможливо встановити максимальний розмір файлу бази даних: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Неможливо визначити максимальний розмір файлу журналу бази даних: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Неможливо встановити максимальний розмір файлу журналу бази даних: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Не вдається визначити поточний граничний розмір файлу бази даних Microsoft SQL \'%1\'. Задати новий граничний розмір неможливо.',
    'database_unable_to_set_max_filesize' => 'Не вдається встановити граничний розмір файлу бази даних Microsoft SQL \'%1\':',
    'database_unable_to_get_max_log_filesize' => 'Не вдається визначити поточний граничний розмір файлу бази даних Microsoft SQL \'%1\'. Задати новий граничний розмір неможливо.',
    'database_unable_to_set_max_log_filesize' => 'Не вдається встановити граничний розмір файлу бази даних Microsoft SQL \'%1\':',

    'database_unable_to_create_because_max_filesize' => 'Неможливо створити базу даних Microsoft SQL \'%1\': розмір файлу перевищує максимально допустиме значення.',
    'database_unable_to_move_because_max_filesize' => 'Неможливо перемістити базу даних Microsoft SQL \'%1\': розмір файлу перевищує максимально допустиме значення: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Неможливо створити базу даних Microsoft SQL \'%1\': розмір журналу реєстраціїперевищує максимально допустиме значення.',
    'database_unable_to_move_because_max_log_filesize' => 'Неможливо перемістити базу даних Microsoft SQL \'%1\': розмір файлу журналу перевищує максимально допустиме значення: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Неможливо відновити базу даних Microsoft SQL \'%1\': розмір файлу перевищує максимально допустиме значення.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Ідентичний сервер MS SQL вже зареєстрований у Plesk. Будь ласка, зазначте інший сервер MS SQL в якості тестового середовища.',
    'database_server__mssql_server_registered_as_sandbox' => 'Ідентичний sandbox MS SQL-сервер вже зареєстрований в Plesk. Будь ласка, вкажіть інший sandbox MS SQL-сервер.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Неможливо підключитися до сервера через %1: %2',

    'bu_conflict_resolver_feature_not_available' => 'Сервіс %1 не підтримується такими вузлами: %2. Даний сервіс буде відключений для всіх об’єктів, створених на цих вузлах.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Даний сервер не підтримує сервіс %1. Сервіс буде відключений на всіх відновлюваних об’єктах.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Компонент %1 не установлений. Буде відключено для таких вебсайтів: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Компонент %1 не установлений. Його буде замінено на %2 для таких веб-сайтів: {{objects}} {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Поточна версія Plesk не підтримує імена користувачів із символом крапки (.). Клієнти і посередники з такими користувацькими іменами не будуть відновлені.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Неможливо знайти файл резервної копії з даними для %1 %2. Дані для %1 %2 не будуть відновлені.',

    'bu_conflict_resolver_zone_master_removed' => "Неможливо відновити запис первинного DNS: запис у вторинній зоні вказує на існуючу IP-адресу %1. Запис первинного DNS буде видалено з вторинної зони.",

    'bu_conflict_resolver_not_available_scripting' => '%1 не підтримується.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 не підтримується. Буде відключено для таких вебсайтів: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Компонент %1 не установлений.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Буде відключено для таких сервісних вузлів: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Буде відключено для таких об\'єктів: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Такі сервери бази даних недоступні на цьому сервері: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Файл резервної копії бази даних MS SQL зберігається в рідному форматі MS SQL, що може бути відновлений лише на локальному сервері MS SQL або на віддаленому сервері MS SQL з повним налаштуванням резервного копіювання. Деякі з ваших баз даних не були відновлені, тому що в Plesk не зареєстровано відповідний сервер MS SQL. Це впливає на такі домени: {{objects}}. Зверніться до вашого постачальника хостингу.',

    'bu_conflict_resolver_not_available_webmail' => 'Поштова служба %1 недоступна. ЇЇ буде замінено на %2 для таких об’єктів: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Поштова служба %1 недоступна. ЇЇ буде замінено на %2 для таких сервісних планів: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Бази даних типу '%1' не підтримують імена користувачів, які співпадають з іменами бази даних. Ім’я користувача '%2' бази даних '%4' буде змінено на '%3'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'В налаштуваннях цільового сервера не задане обмеження використання дискового простору. Значення цього параметру буде змінено на "Необмежено".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'В налаштуваннях цільового сервера не задане обмеження кількості підключень. Значення цього параметру буде змінено на "Необмежено".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'В налаштуваннях цільового сервера не задане обмеження використання трафіку. Значення цього параметру буде змінено на "Необмежено".',
    'cu__pleskrestore_backup_file_extracted' => 'Файл резервної копії було розвернуто в "%1".',
    '__mod_bw_not_supported' => 'Модуль mod_bw для веб-сервера Apache не підтримується через конфігурацію файлової системи. Обмеження з використання трафіку та максимальної кількості з’єднань працювати не будуть.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Авторизація POP3 для ретрансляції пошти не підтримується. Замість неї буде використовуватись авторизація POP3 before SMTP. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Сервіс-план \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 не підтримується. Його буде замінено на %2 для таких сервісних планів: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 не підтримується. Його буде замінено на %2 для таких веб-сайтів: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Наступні об\'єкти не було знайдено у файлі резервної копії: %1',
    'bu_conflict_resolver_absent_domains' => 'Деякі об\'єкти не можуть бути відновлені, тому що вони належать до наступних доменів, які не знайдено у Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Деякі веб-сайти неможливо відновити, оскільки вони належать до наступних батьківських доменів, які не знайдено у Plesk: %1",
    'bu_conflict_resolver_dns_not_supported' => 'Не вдалося відновити DNS-зони: Послугу DNS вимкнено в конфігурації серверу.',
    'bu_conflict_resolver_mail_not_supported' => 'Не вдалося відновити поштові скриньки: Поштову послугу вимкнено в конфігурації серверу.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Зазначена обмежена дія ЦП не підтримується веб-сервером IIS. Значення буде обнульовано до %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Сертифікат SSL/TLS %1 сервера',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Сертифікат SSL/TLS %2 домену %1',
    'bu_conflict_detector_ssl_cert_name' => 'Сертифікат SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Зміст наступних об\'єктів неможливо відновити, оскільки об\'єкти не знайдено у Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Зміст наступних поштових скриньок неможливо відновити, оскільки поштові скриньки не знайдено у Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Зміст наступних списків поштової розсилки неможливо відновити, оскільки списки поштової розсилки не знайдено у Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Зміст наступних баз даних неможливо відновити, оскільки бази даних не знайдено у Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Відновлення застосунку "%1" на "%2" не вдалося, тому що вже є встановлений інший застосунок на "%3". Можете видалити встановлений застосунок та спробувати знову.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Функція поштової автовідповіді не підтримується.',
    'bu_conflict_resolver_not_available_mail_content' => 'Функція відновлення поштового контенту не підтримується.',
    'bu_conflict_resolver_invalid_mail_name' => 'Наступні поштові скриньки не були відновлені через увімкнену субадресацію пошти та наявність символу "%1" у деяких електронних адресах: %2',
    'bu_conflict_resolver_invalid_user_name' => 'Наступні користувачі не були відновлені через увімкнену субадресацію пошти та наявність символу "%1" у деяких електронних адресах: %2',
    'bu_conflict_resolver_licenses_expired' => 'Термін дії таких ліцензій закінчився і не буде поновлений: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Наступні ліцензії є недійсними чи простроченими та не будуть відновлені: {{objects}}',
    'expiration_unsupported' => "Обмеження 'expiration' не підтримується",

    'component_name__dbconnector' => "Конектор бази даних",
    'component_name__mysqlserver' => 'MySQL Сервер',
    'component_name__troubleshooting' => 'Пошук проблеми',
    'component_name__savi' => 'Інтерфейс антивіруса Sophos',

    '__subscription_has_no_license_key' => 'Ресурси підписки надані сервісним вузлом #%1, який не має пов’язаного ліцензійного ключа.',
    '__subscription_has_expired_license_key' => 'Ресурси підписки надані сервісним вузлом #%1, ліцензійний ключ %2 якого Зовнішня оболонкачився.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Неможливо зберегти конфігураційні файли',
    '__cfgmonConfigurationFileSaveErrorBody' => "Неможливо зберегти деякі конфігураційні файли на хості <%%host%%>: Виникли наступні помилки:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Ця опція вмикає можливість конфігурувати електронні адреси VERP для списків розсилки',
    'mail__enter_right_ip_mask' => "Введіть маску IP-адреси в межах від 1 до 32",
    'mail__enter_right_ip_mask_24' => "Введіть маску IP-адреси в межах від 24 до 32",
    'mail__invalid_dom_name' => "Ім'я домену %1 некоректне.",
    'mail__invalid_pop_lock_time' => "Час блокування POP3 некоректний.",
    'mail__invalid_rbl_server' => "Ім'я зони DNS некоректне.",
    'mail__total_files_size' => "Загальний розмір сховища: %1",
    'mail__filename_already_in_repository' => "Файл з таким ім'ям вже знаходиться у сховищі",
    'mail__no_white_list_mask_feature_24' => "Використовуйте значення маски від 24 і вище. Ваш поштовий сервер не підтримує налаштування маски. Ми можемо тільки імітувати налаштування маски для значень вищих за 24.",
    'mail__unable_add_new_mail_name' => "Неможливо додати поштовий обліковий запис: %1",
    'mail_server_is_not_installed' => 'Поштовий сервер (Postfix або Qmail) не встановлено. Виконайте встановлення, щоб продовжити роботу.',
    'mail_server_not_available' => 'На вузлі немає необхідних поштових сервісів.',
    '__not_installed' => '(не встановлено)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Фільтрацію спаму у вихідних поштових повідомленнях вимкнено.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Сервісний вузол не підтримує обмеження кількості вихідних поштових повідомлень з домену для домену %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Сервісний вузол не підтримує обмеження кількості вихідних поштових повідомлень з поштової скриньки для домену %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Вказати адресу, щонайменше, одного типу (IPv4 або IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Вказано невірний режим вихідної пошти.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Вказано невірну IPv4-адресу.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Вказано невірну IPv6-адресу.',
    'mail__outgoing_email_mode_unavailable' => 'Зміна режиму вихідної пошти не підтримується, ймовірно тому, що на цьому сервері не встановлений поштовий сервер Postfix.',

    'mail__autoresponder_attachment_not_supported' => 'Поточний сервер електронної пошти не підтримує управління додатком автовідповідача.',

    'mail__smtp_white_list_not_supported' => 'Поштовий сервер, який зараз використовується, не підтримує створення білого списку IP-адрес.',
    'mail__smtp_whitelist_cidr_not_supported' => 'CIDR маски не підтримуються поточним поштовим сервером. Вкажіть IP-адресу у форматі \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'IP-шаблони wildcard-сертифіката не підтримуються поточним поштовим сервером. Вкажіть IP-адресу у форматі \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Неможливо змінити налаштування для верифікаційної служби DKIM',

    'sfdk_domain__serverwide_disabled' => 'Вимкнено у зв’язку з політикою сервера',
    'feature__domainkeys__serverwide_disabled' => 'Захист від спаму DKIM для всього сервера вимкнено',

    'defaultcomponents__error_set_default' => 'Неможливо налаштувати %1, як %2 за умовчанням: %3',
    'defaultcomponents__error_set_default_none' => 'Неможливо налаштувати відсутність компонента за умовчанням для %1: %2',
    'defaultcomponents__required_package_not_default' => 'Компонент %1, необхідний для його роботи, не виставлений за замовчуванням.',

    '__percentage' => '%',
    '__seconds' => 'Секунди',
    '__resource_remain' => 'Решта',

    '__not_registered' => '(не зареєстровано)',
    '__php_handler_id' => 'Версія РНР',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Обробник PHP "%1" не зареєстровано. Ймовірно, він був видалений із сервера. Зареєструйте обробник з тими ж властивостями і спробуйте знову.',
    '__php_handler_not_registered_on_domain' => 'Домен "%1": обробник PHP "%2" не зареєстровано. Ймовірно, він був видалений із сервера. Зареєструйте обробник з тими ж властивостями і спробуйте знову.',
    '__php_fpm_handler' => 'FPM-застосунок',
    '__php_fpm-dedicated_handler' => 'Спеціалізований застосунок FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Неможливо створити користувача поштової скриньки. Користувач з ім\'ям %1 вже існує і має іншу поштову скриньку.',
    'mailname_create_assigned_user_role_absent_error' => 'Неможливо створити користувача поштової скриньки. Роль за замовчуванням %1 користувача не існує.',

    'gphd__mime_types' => 'Типи MIME',
    'gphd__handlers' => 'Обробники Apache',
    'gphd__ip_restrictions_allow' => 'Надати доступ до сайту для окремих хостів та мереж (за винятком заборонених)',
    'gphd__ip_restrictions_deny' => 'Заборонити доступ до сайту для окремих хостів та мереж',
    'gphd__directory_index' => 'Індексні файли',
    'gphd__nginx_transparent_mode' => 'Режим, в якому Apache обробляє статичний і динамічний контент, в той час як nginx лише передає HTTP-запити та відповіді без змін.',
    'gphd__nginx_serve_static' => 'Обслуговувати статичні файли за допомогою nginx',
    'gphd__nginx_static_extensions' => 'Розширення статичних файлів, які повинні оброблятися за допомогою nginx',
    'gphd__nginx_serve_php' => 'Обробляти файли PHP за допомогою nginx',
    'gphd__www_root' => 'Кореневий каталог WWW',

    'eol__none' => 'не змінювати',
    'eol__lf' => 'перетворити у стиль Unix',
    'eol__cr' => 'перетворити у стиль MacOS',
    'eol__crlf' => 'перетворити у стиль ОС Windows',

    'ui__dns_bad_zone' => 'Неузгоджена зона "%1":',
    'ui__dns_ns_has_no_address_records' => 'Запис NS "%1" не має записів адреси (A або AAAA).',
    '__dns_bad_zone' => 'Неузгоджена зона "%1":',
    '__dns_ns_has_no_address_records' => 'Запис NS "%1" не має записів адреси (A або AAAA).',
    '__dns_ptr_is_wildcard' => 'PTR запис "%1" недійсний: запис вказує на wildcard домен.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Дозволити віддалений доступ для користувача бази даних \'%3\'замовника \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Неможливо дозволити віддалені з’єднання для користувача бази даних \'%1\':  неможливо визначити номер TCP-порту, який використовується сервером Microsoft SQL \'%2\'. Можливі причини полягають у наступному: протокол TCP/IP не увімкнено в конфігурації мережі серверу, або сервер налаштований на використання динамічних TCP-портів. Налаштувати сервер на очікування сигналу від певного фіксованого TCP-порту і спробувати ще раз дозволити віддалені з’єднання.',

    'command__convertResellerHasCustomer' => 'Обліковий запис посередника \'%1\' має один або кілька облікових записів замовника. Щоб перетворити обліковий запис посередника на обліковий запис замовника, насаперед необхідно перенести ці облікові записи замовників до нового власника або перетворити їх на облікові записи посередників.',
    'command__convertResellerNotReseller' => 'Лише облікові записи посередників можуть бути перетворені на облікові записи замовників. \'%1\' не є посередником.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Неможливо синхронізувати підписку з сервісним планом через конфлікт з наступними налаштуваннями: %%problems%%',

    'moveCustomer__wrong_customer_type' => 'Обліковий запис \'%1\' є обліковим записом посередника. Облікові записи посередника не можуть бути переміщені до нового власника через те, що вони належать адміністратору сервера.',
    'moveCustomer__wrong_owner_type' => "Обліковий запис замовника '%1' може бути переміщений тільки до посередника або адміністратора, але не до іншого замовника.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Обліковий запис замовника \'%1\' вже належить вибраному власнику.',
    'upgradeClient__user_is_admin' => 'Обліковий запис \'%1\' неможливо перетворити на обліковий запис посередника, тому що він є обліковим записом адміністратора.',

    'mail__error_setting_max_connections_courier' => 'Неможливо встановити максимальну кількість з\'єднань (IMAP, POP3, IMAP через SSL/TLS, або POP3 через SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Неможливо встановити максимальну кількість з\'єднань (IMAP, POP3, IMAP через SSL/TLS, або POP3 через SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Неможливо встановити максимальну кількість з\'єднань (IMAP, POP3, IMAP через SSL/TLS, або POP3 через SSL/TLS) на IP-адресу: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Неможливо встановити максимальну кількість з\'єднань (IMAP, POP3, IMAP через SSL/TLS, або POP3 через SSL/TLS) на IP-адресу для конкретного користувача пошти: %1',
    'outgoing_messages_limit_value_invalid' => 'Значення має знаходитись у діапазоні %%MIN%%..%%MAX%%.  Тільки адміністратор Plesk може змінити це налаштування.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Наступні домени використовують зовнішні поштові адреси для пересилання пошти: Повідомлення, відправлені на ці адреси, не враховуватимуться в Управлінні Вихідною Поштою: %1",
    'outgoing_messages_white_list_not_empty' => 'Обмеження на вихідну пошту не будуть працювати для тих відправників електронної пошти, чиї ІР-адреси знаходяться у білому списку поштового серверу. Наприклад, якщо у білому списку зазначена робоча станція (127.0.0.0 / 8, ::1 / 128), вся пошта з локального серверу буде успішно відправлена, не зважаючи на обмеження. Відправники пошти можуть використовувати або локальні ІР-адреси (веб-сайти та скрипти замовників, розміщені на локальному сервері) або зовнішні ІР-адреси (замовники, які надсилають пошту з поштових клієнтів, встановлених на їхніх комп’ютерах або мобільних пристроях). Для того, щоб обмеження працювали для всіх відправників пошти (як локальних, так і зовнішніх), видаліть із білого списку всі ІР-адреси та мережі. Майте на увазі, що Видалення з білого списку робочої станції (127.0.0.0 / 8, ::1 / 128) може порушити роботу веб-сайтів та скриптів, які надсилають пошту з цього серверу. За додатковою інформацією щодо обмежень на вихідну пошту читайте посібник адміністратора, секція "Захист від вихідного спаму".',
    'outgoing_messages_relay_open' => 'Поштове реле відкрите: Обмеження на вихідну пошту не працюватиме.',

    'notification_aps_app_updates_available' => 'Оновлення доступні для таких застосунків:',
    'notification_aps_app_updates_installed' => 'Оновлення були автоматично встановлені для таких застосунків:',
    'notification_aps_app_updates_requirements' => 'Оновлення доступні для таких застосунків, але не можуть бути встановлені через те, що налаштування хостингу відповідних веб-сайтів не відповідають вимогам з установки:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%).   Встановлена версія: %%from%%.  Доступна версія: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Плагін "%%name%%" на %%parentName%% (%%url%%). Встановлена версія: %%from%%.  Доступна версія: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Тема "%%name%%" на %%parentName%% (%%url%%). Встановлена версія: %%from%%.  Доступна версія: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Встановлена версія: %%from%%. Доступна версія: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Плагін "%%name%%" на %%parentName%% (%%url%%). Встановлена версія: %%from%%. Доступна версія: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Тема "%%name%%" на %%parentName%% (%%url%%). Встановлена версія: %%from%%. Доступна версія: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Ваша версія: %%from%%. Доступна версія: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Плагін "%%name%%" на %%parentName%% (%%url%%). Ваша версія: %%from%%. Доступна версія: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Тема "%%name%%" на %%parentName%% (%%url%%). Ваша версія: %%from%%. Доступна версія: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Нова версія: %%to%%. Попередня версія: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Нова версія: %%to%%. Попередня версія: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%).   Нова версія: %%to%%.  Попередня версія: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Встановлена версія: %%from%%. Доступна версія: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Встановлена версія: %%from%%. Доступна версія: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%).   Ваша версія: %%from%%. Доступна версія: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'зовнішній застосунок',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Домени',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Поштові адреси',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Підписки',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 повідомлень на годину',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Необмежений',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, обмеження складає %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 спроба(и) для перевищення обмеження від %2 до %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 спроба(и) для перевищення обмеження від %2 до теперішнього часу',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Заборона IP-адреси (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Компонент Fail2ban не встановлено на цільовому сервері.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Встановіть Fail2ban. Зверніть увагу, що це може зайняти кілька хвилин.',

    'plesk_key__no_reseller_support' => 'Ви не можете управляти посередниками у зв\'язку з ліцензійними обмеженнями.',
    'plesk_key__no_customers_support' => 'ви не можете управляти замовниками у зв\'язку з ліцензійними обмеженнями.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Неможливо переключитися до режиму Service Provider у зв\'язку з ліцензійними обмеженнями.',
    'plesk_key__no_security_core_support' => 'Основні засоби безпеки (ModSecurity та Fail2Ban) недоступні через ліцензійні обмеження.',
    'plesk_key__outgoing-antispam' => 'Управління вихідною поштою',
    'plesk_key__security-core' => 'Основні засоби безпеки (ModSecurity та Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Управління обліковими записами',
    'plesk_key__can-manage-subscriptions' => 'Управління підписками',
    'plesk_key__can-manage-customers' => 'Управління замовниками',
    'plesk_key__can-manage-resellers' => 'Управління посередниками',
    'plesk_key__can-manage-custom-view' => 'Наявність режиму обмеженого доступу',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Управління підписками вимкнено, але у вас є кілька підписок (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Управління посередниками вимкнено, але у вас є кілька посередників (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Управління замовниками вимкнено, але ви маєте кілька замовників (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Деякі ресурси підписки, якими ви більше не можете керувати в інтерфейсі Plesk (наприклад, обмеження поштових скриньок і дисковий простір доменів), тепер установлено як необмежені.',
    'plesk_key__no_subscriptions_support' => 'Ви не можете управляти підписками через ліцензійні обмеження.',
    'plesk_key__no_custom_view_support' => 'Неможливо ввімкнути режим обмеженого доступу через ліцензійні обмеження.',
    'plesk_key__trial_forbidden_region' => 'Вибачте, Plesk наразі недоступний у вашому регіоні.',
    'additional_key__main_key' => 'Цей ключ є головним ключем: Ви не можете завантажувати основний ключ у якості додаткового ключа.',

    'gch__hosting_waf_rule_engine' => 'Режим мережевого екрану веб-застосунку',

    'backup__fieldset__restoration_options' => 'Опції відновлення',
    'backup__restore_options__restore' => 'Відновити',
    'backup__restore_options__domain__domain_configuration' => 'Конфігурація домену',
    'backup__restore_options__domain__virtual_host_content' => 'Вміст віртуального хосту',
    'backup__restore_options__domain__mail' => 'Пошта',
    'backup__restore_options__domain__databases' => 'Бази даних',
    'backup__restore_options__client__client_configuration' => 'Конфігурація облікового запису замовника',
    'backup__restore_options__client__domains' => "Домени замовника",
    'backup__restore_options__reseller__reseller_configuration' => 'Конфігурація облікового запису посередника',
    'backup__restore_options__reseller__personal_domains' => "Домени посередника",
    'backup__restore_options__reseller__clients' => "Замовники посередника",
    'backup__restore_options__admin__server_configuration' => 'Налаштування сервера',
    'backup__restore_options__admin__administrator_configuration' => 'Конфігурація облікового запису адміністратора',
    'backup__restore_options__admin__personal_domains' => "Домени адміністратора",
    'backup__restore_options__admin__personal_clients' => "Замовники адміністратора",
    'backup__restore_options__admin__resellers' => 'Посередники',

    'badge_new' => 'Нові',
    'upgrade_php_on_subscription' => 'Оновити РНР на вашій підписці до версії 5.3.0 або пізнішої.',

    'pkey_notify__body_expiration_notification' => 'Сплинув час дії ліцензійного ключа. Деякі функції можуть бути недоступні. Будь ласка, зверніться до вашого постачальника хостингу.',

    'crontab__crontab_entry_exists' => "Заплановане завдання вже існує.",
    'crontab__crontab_entry_not_exists' => "Заплановане завдання не існує.",
    'crontab__invalid_values_found' => "Невірні значення параметрів.",
    'crontab__cmd_max_len' => "Команда не може перевищувати %1 символів.",

    'domain__domain_exists' => "Існує альтернативний домен з префіксом 'www' та таким самим ім'ям %1.%2.",
    'domain__subdomain_exists' => "Існує субдомен з префіксом 'www' та таким самим ім'ям %1.%2.",
    'domain__dalias_exists' => "Існує альтернативний домен з префіксом 'www' та таким самим ім'ям %1.%2.",
    'domain__record_exists' => "Існує DNS-запис, який вказує на хост %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Сертифікат '%1' не можна встановити в якості за замовчуванням: відсутній приватний ключ.",
    'ip_addr__update_dns_error' => 'Під час оновлення IP-адреси в DNS-зонах виникли проблеми. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Неможливо додати ІР-адресу. Цей мережевий інтерфейс отримує IP-адреси автоматично.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Неможливо видалити IP-адресу %1. Цей мережевий інтерфейс отримує IP-адреси автоматично.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Неможливо налагодити IP-адресу %1. Цей мережевий інтерфейс отримує IP-адреси автоматично.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Неможливо змінити інтерфейс IP-адреси %1, тому що мережевий інтерфейс %2 отримує IP-адреси автоматично.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Перевищено ліміт підписки на кількість %%type%%. Ліміт є %%limit%%, і на даний момент використовується %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Для цієї підписки створення %%type%% не дозволено.',
    'shm_lmsg__resource_title__db-mysql' => 'Бази даних MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Бази даних Microsoft SQL Server',
    'shm_lmsg__resource_title__db-postgresql' => 'Бази даних PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'користувачі бази даних',
    'shm_lmsg__resource_title__iis-application-pool' => 'Пули застосунків IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'додаткові облікові записи FTP',

    'db_user_unable_remove_mysql_global_privileges' => 'Неможливо видалити глобальні привілеї MySQL користувача бази даних %1 Причина: %2',
    'report__client_description' => 'Опис',

    'db__user_role_error' => 'Вказано некоректну роль користувача бази даних: %1. Виберіть одну з таких ролей: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Для таких баз даних Microsoft SQL Server неможливо встановити ліміт на розмір файлу, тому що вони мають більший розмір файлу: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Для таких баз даних Microsoft SQL Server неможливо встановити ліміт на розмір журналу реєстрації, тому що вони мають більший розмір лог-файлу: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Неможливо налаштувати загальнодоступну IP-адресу: повинна існувати приватна IP-адреса.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Неможливо налаштувати загальнодоступну IPv4-адресу для IPv6-адреси.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Неможливо налаштувати загальнодоступну IPv6-адресу для IPv4-адреси.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Не вдається налаштувати публічну IP-адресу: недійсна IP-адреса.',

    '__user_already_exists' => "Користувач %1 вже існує.",
    '__user_name_is_empty' => "Будь ласка, вкажіть ім'я користувача.",

    'upgrade_php_on_domain' => 'На жодному з вашіх доменів WordPress неможливо знайти версію PHP 5.3.0 або пізнішу версію. Спробуйте оновити PHP.',

    'component_name__waf' => 'Мережевий екран веб-застосунку',
    'component_name__vcs' => 'Система управління версіями',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Виявлено можливу спробу спуфінгу: посилання спробувало відобразити нерелевантний зміст.',
    'forceResetPasswordUpdated' => 'Ваш пароль змінено. Для входу в Plesk використовуйте новий пароль.',

    'php_handlers_error_no_available_instance' => 'Не можу створити новий домен: немає доступних обробників PHP.',
    'domain_error_unable_to_apply_hosting_settings' => 'Неможливо оновити налаштування хостингу: %1',

    'plesk_not_configured' => 'Plesk не сконфігуровано. Перейдіть на Панель Управління для виконання післяінсталляційної конфігурації.',
    'cmd_mail__mail_password_duplicated' => 'Вказана пара електронної адреси та паролю вже існує на поштовому сервері. Вкажіть іншу електронну адресу та пароль.',

    'extensionRequirementOs' => 'Операційна система (%1) не підтримується пакетом.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 є найновішою версією, що підтримується пакетом.',
    'extensionRequirementPleskMaxVersion' => 'Версії, починаючи з Plesk (%1), не підтримуються пакетом.',
    'extensionBlacklisted' => 'Розширення %1 до установки не допускається.',
    'extensionDisabled' => 'Розширення деактивовано.',


    'optimization_settings__unable_set_mpm_event' => 'Неможливо встановити режим mpm_event: потрібно, щоб модуль Apache PHP5 був вимкнутий, але цей модуль використовується доменами.',
    'optimization_settings__unable_turn_off_php' => 'Неможливо вимкнути модуль Apache PHP5: він використовується доменами.',

    'hst_def__fp_admin_login' =>  'Ім’я користувача FTP',
    'hst_def__fp_admin_passwd' =>  'Пароль FTP',

    'database_user_orphaned_old_password_wrong' => "Неможливо відновити втраченого користувача '%1': не вірний пароль.",
    'cannot_load_partner_central_property_key_no_exist' => "Неможливо отримати користувацькі властивості: ліцензійний ключ не існує.",
    'extensionScriptFailure' => "Виконання %1 завершилося з наступним повідомленням: %3",
    '__ssl_redirect' => "Постійна переадресація 301 з HTTP на HTTPS, що підходить для SEO",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Управління DKIM не підтримується.',
    'mail__dmarc_not_supported' => 'Управління DMARC не підтримується.',
    'mail__relay_white_list_not_supported' => 'Управління білим списком реле не підтримується.',
    'mail__black_list_not_supported' => 'Управління чорним списком не підтримується.',
    'mail__autoresponder_not_supported' => 'Управління авто-відповідачем не підтримується.',
    'defaultcomponents__not_supported_version' => '(непідтримувана версія)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Сертифікат \'%1\' не знайдено.',
    'certificate__unable_setup_certificate' => 'Неможливо встановити сертифікат: Відсутній вміст персонального ключа та сертифікату.',
    'certificate__used_by_panel' => 'Один із сертифікатів, які ви збираєтесь видалити, використовується для забезпечення захисту Plesk.',
    'certificate__used_by_mail_server' => 'Один із сертифікатів, які ви збираєтесь видалити, використовується для забезпечення захисту поштового сервера.',
    'certificate__used_by_domain_service' => 'Один із сертифікатів, які ви збираєтесь видалити, використовується службою домену.',
    'mail_server__not_installed' => 'Неможливо встановити сертифікат на поштовий сервер, тому що поштовий сервер не встановлено.',

    'email_activation_mail_subject' => 'Будь ласка активуйте ваш обліковий запис у Plesk',
    'email_activation_mail_body' => "Обліковий запис було створено на сервері Plesk %1 Деталі облікового запису: Ім’я: %2 Електронна поштова адреса: %3 Якщо ця інформація вірна та обліковий запис було створено для вас, будь ласка активуйте його через наступне посилання: %4 Активуючи цей обліковий запис, ви надаєте право власникові сервера збирати, зберігати, обробляти та використовувати ваші особові дані (ім'я та електронна пошта) для створення та підтримки вашого облікового запису, відповідно до наразі дійсних законів захисту даних. Це є частиною контракту.",

    'backup_transport_permission_name' => 'Управління %1',
    'backup_transport_permission_description' => 'Дозволяє використовувати %1 для зберігання резервних копій.',

    'domain_move_err_target_no_hosting' => 'Неможливо перемістити домен до підписки без хостингу.',
    'domain_move_err_already_in_target' => 'Домен вже належить до обраної підписки.',
    'domain_move_err_main_domain' => 'Неможливо перемістити головний домен.',
    'domain_move_err_subdomain_without_parent' => 'Неможливо перемістити субдомен %1 без батьківського домену %2.',
    'domain_move_err_root_exists' => 'Цільовий шлях для www_root %1 вже існує.',
    'domain_move_err_nested_roots' => 'Неможливо перемістити домен, оскільки він має спільний корінь документа з іншим доменом: %1.',
    'domain_move_err_no_mail_service' => 'Неможливо перемістити домен, оскільки поштовий сервіс на обраній підписці вимкнений.',
    'domain_move_err_app' => "Програма, встановлена на %1, не була переміщена до підписки '%2': %3",
    'domain_move_database_used_by_app' => "База даних '%1' на %2 використовується переміщеною програмою. Для перепризначення бази даних на '%3', виконайте `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Обрана підписка '%1' була зарезервована для синхронізації.",
    'domain_move_filesharing_disabled' => 'Обмін файлами було вимкнено.',
    'domain_move_website_preview_disabled' => 'Перегляд веб-сайту вимкнено.',
    'domain_move_additional_webserver_settings' => "Переглянути додаткові директиви веб-сервера домену, аби запобігти помилковій конфігурації.",
    'domain_move_no_permission' => "%1 забороняється для підписки '%2'.",
    'domain_move_no_access' => "Немає доступу до підписки '%1'.",
    'domain_split_no_create_permission' => "Створення доменів недозволено.",
    'domain_split_empty_login' => 'Необхідний логін користувача системи.',
    'domain_split_empty_password' => 'Необхідний пароль користувача системи.',
    'domain_split_err_home_exists' => 'Неможливо перемістити домен %1, оскільки шлях до його каталогу вже існує у %2. Змініть назву домена, щоб перемістити його до нової підписки.',
    'domain_split_err_no_hosting_subdomains' => 'Домен не може бути переміщено на нову підписку, тому що домена не має хостингу, проте має піддомени. Для переміщення домену змініть його значення «Тип хостингу» на «Хостинг веб-сайту» (у налаштуваннях хостингу).',
    'domain_split_target_locked' => "Обрана підписка '%1' зарезервована для синхронізації.",
    'domain_split_target_unsynced' => "Обрана підписка '%1' не була синхронізована з планом через: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Заплановане резервне копіювання вимкнено на '%1'.",
    'domain_merge_database_error' => "База даних '%1' на %2 не була переміщена до підписки '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Анонімний FTP на '%1' вимкнено.",
    'domain_merge_smb_user_access' => "Користувача '%1' переміщено до підписки '%2', але його доступ до підписки був анульований.",
    'domain_merge_scheduled_tasks' => "Заплановані завдання були переміщені до цільової підписки. Перевірте конфігурацію завдань.",
    'domain_merge_scheduled_tasks_deactivated' => "Заплановані завдання були переміщені до цільової підписки та вимкнені. Перевірте конфігурацію завдань.",
    'domain_merge_no_remove_permission' => "Видалення підписки заборонено.",
    'domain_merge_err_has_addons' => 'Неможливо перемістити головний домен з його додатковими доменами. Спочатку перемістіть домен(и) %1.',
    'domain_merge_err_has_webusers' => 'Неможливо перемістити головний домен з його веб-користувачами.',
    'domain_merge_err_root_exists' => 'Цільовий шлях %1 вже існує.',

    'database_server_edit_used_for_psa' => 'Оновлення місцевого сервера бази даних MySQL не дозволене.',
    'suggest_repair_main_suggestion_ui' => '<b>Ви можете виправити цю помилку,</b> скориставшись утилітою `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Ви можете виправити цю помилку, скориставшись утилітою `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'перейдіть до Виявити та виправити',
    'suggest_repair_using_cli_and_ui' => 'Аби зробити це, виконайте команду `plesk repair %1` через ІКР, або %2 та натисніть Виправити поруч з «База даних Plesk»',
    'suggest_repair_using_cli' => 'Аби зробити це, виконайте команду `plesk repair %1` через ІКР',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Під час створення резервної копії служба DNS була недоступна. Проте, у резервній копії наявні активні DNS-зони, що будуть увімкнені для наступних об\'єктів: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Контролер ресурсів (cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Підтримка віддаленого SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(обмежено ліцензійним ключем)',
    'plesk_key__validation_failed' => '%1 (Код помилки: %2)',
    'promo__button_details' => 'Деталі',
    'promo__extension_catalog_title' => 'Каталог розширень',
    'promo__extension_catalog_description' => 'Оцініть новий каталог розширень та наповніть ваш Plesk різноманітними потужними розширеннями!',
    'promo__button_open_catalog' => 'Відкрити каталог',

    'backup__repository_check_login' => "Не вдалося відкрити сховище: %1 Пересвідчіться, що ви вказали правильні реквізити сховища.",
    'backup__repository_check_error_list' => "Не вдалося відкрити сховище: %1 Пересвідчіться, що ви вказали правильні налаштування сховища.",
    'backup__repository_check_error_mkdir' => "Не вдалося створити каталог: %1 Перевірте, чи у вас є повноваження на створення каталогів у сховищі.",
    'backup__repository_check_error_upload' => "Не вдалося вивантажити файл до сховища: %1 Перевірте, чи у вас є повноваження на вивантаження файлів до сховища.",
    'backup__repository_check_error_download' => "Не вдалося завантажити файл зі сховища: %1 Перевірте, чи у вас є повноваження на вивантаження та завантаження файлів зі сховища.",
    'backup__repository_check_error_resume-upload' => "Не вдалося відновити вивантаження файлу до сховища: %1 Перевірте, чи у вас є повноваження відновляти вивантаження до сховища.",
    'backup__repository_check_error_resume-download' => "Не вдалося відновити завантаження файлу зі сховища: %1 Перевірте, чи у вас є повноваження відновляти завантаження зі сховища.",
    'backup__repository_check_error_enable-utf8' => "Не вдалося налаштувати сховище: %1 Перевірте, чи це сховище підтримує кодування UTF8.",
    'backup__repository_check_error_rm' => "Не вдалося налаштувати сховище: %1 Перевірте, чи у вас є повноваження на видалення файлів зі сховища.",
    'backup__repository_check_error_rmdir' => "Не вдалося налаштувати сховище: %1 Перевірте, чи у вас є повноваження на видалення каталогів зі сховища.",

    'backup__ftp_repository_check_login' => "%1 Можна перевірити незалежно за допомогою команди: %2",
    'backup__ftp_repository_check_error_list' => "%1 Можна перевірити незалежно за допомогою команди: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Можна перевірити незалежно за допомогою команди: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Можна перевірити незалежно за допомогою команд: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Можна перевірити незалежно за допомогою команд: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Можна перевірити незалежно за допомогою команд: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Можна перевірити незалежно за допомогою команд: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Можна перевірити незалежно за допомогою команди: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Можна перевірити незалежно за допомогою команд: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Можна перевірити незалежно за допомогою команд: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Не вдалося змінити налаштування для DMARC. Щоб увімкнути цю опцію, будь ласка, підключіть DKIM та SPF-захист від спаму.',
    'spf_server_wide_disable_failed' => 'Не вдалося змінити налаштування для захисту від спаму SPF. Щоб вимкнути SPF, будь ласка, відключіть DMARC для вхідної пошти.',
    'sfdk_server_wide_verify_disable_failed' => 'Не вдалося змінити налаштування для захисту від спаму DKIM. Щоб вимкнути DKIM, будь ласка, відключіть DMARC для вхідної пошти.',

    'ccs_not_supported' => 'Центральне сховище сертифікатів IIS не налаштовано у системі.',
    'ccs_not_enabled' => 'Керування центральним сховищем сертифікатів IIS не ввімкнено у Plesk.',
    'ad_not_supported' => 'Сервер не приєднано до домену.',

    'component_name__appinit' => "Ініціалізація застосунку",
    'component_name__cors' => "Спільне використання ресурсів між різними джерелами",
    'component_name__httpcompression' => 'Стиснення вмісту HTTP',
    'common_feature_is_not_supported' => 'Ця функція більше не підтримується.',
    'common_feature_is_not_supported_in_proto' => 'Ця функція не підтримується версією %1 протоколу.',
    'autoinstaller__plesk_component' => 'Plesk компонент',
    'plesk_key__key_expired' => 'Термін дії вашого ліцензійного ключа закінчився. Щоб продовжити використання Plesk, придбайте комерційний %1 без терміну дії.',
    'plesk_key__key_purchase' => 'ліцензійний ключ',

    'sa_action_move' => 'Перемістити спам до папки «Небажана пошта»',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java-застосунки більше не підтримуються. Вони будуть відключені для наступних веб-сайтів: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Мобільні версії веб-сайтів, розміщені за допомогою UNITY Mobile, більше не підтримуються. Вони будуть відключені для наступних веб-сайтів: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Політика використання сервера не передбачає персональні налаштування антивірусу. Вони будуть неповністю відновлені для облікових записів електронної пошти на наступних доменах: {{objects}}',

    'module__not_installed' => "Розширення %1 не встановлено",

    'mail__mail_autodiscovery_server_error' => 'Зазначити користувацьке ім\'я домену для автовиявлення пошти',
    'mail__error_mail_autodiscovery_enable' => 'Не вдалося встановити автовиявлення пошти: %1',
    'mail__error_mail_autodiscovery_server' => 'Не вдалося встановити користувацьке ім\'я домену для автовиявлення пошти: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Не вдалося переналаштувати автовиявлення DNS-записів доменів: %1',

    '__invalid_url' => 'URL "%1" недійсний',
    'actionlog__cloning_start' => 'запуск',
    'actionlog__event_cloning_start' => 'Запуск клонування сервера',

    '__UPLOAD_ERR_FORM_SIZE' => "Вивантажений файл перевищує дозволений розмір",
    '__UPLOAD_ERR_INI_SIZE' => "Вивантажений файл перевищує дозволений розмір",
    '__UPLOAD_ERR_NO_FILE' => "Файл не отримано",
    '__UPLOAD_ERR_OK' => "Файл успішно вивантажено",
    '__UPLOAD_ERR_PARTIAL' => "Файл вивантажений не повністю, будь ласка, спробуйте ще",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Тимчасова папка відсутня',
    '__UPLOAD_ERR_CANT_WRITE' => 'Не вдалося записати файл на диск',
    '__UPLOAD_ERR_UNKNOWN' => 'Виникла невідома помилка вивантаження файлу',
    '__accounts' => "Облікові записи",
    '__access' => "Доступ",
    '__address' => "Адреса",
    '__addresses' => "Адреси",
    '__acl_records' => 'ACL Записи',
    '__admin_repository' => "Сховище адміністратора",
    '__all' => 'Всі',
    '__allowed' => "Дозволено",
    '__anonftp_status' => "Анонімний FTP",
    '__antispam' => "Антиспам",
    '__apache_restart' => "...%1 веб-сервер перезапускається, будь ласка, почекайте...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Підтримка Microsoft ASP.NET",
    '__asp_win_support' => "Підтримка Microsoft ASP",
    '__attachments' => "Вкладення",
    '__attachments_list' => "Вкладення",
    '__author' => 'Автор',
    '__autoresp_name_already_exists' => "Автовідповідь з ім'ям %1 вже існує.",
    '__autoresponder' => "Автовідповідач",
    '__autoresponders' => "Автовідповіді",
    '__autoresponders_list' => "Автовідповіді",
    '__autoresponder_attachment_files' => "Файли вкладення автовідповідача",
    '__auto_updates_list' => 'Доступні оновлення',
    '__avail' => "Доступний",
    '__backup_utilites' => "Сервіси резервного копіювання",
    '__bind_status' => "Статус серверу DNS",
    '__bu_is_not_installed' => "Цей сервіс наразі недоступний, тому що сервіси резервного копіювання не встановленні.",
    '__bu_not_support_in_key' => "Створення резервних копій не підтримується ліцензійним ключем.",
    '__notifications_not_support_in_key' => 'Повідомлення не підтримуються ліцензійним ключем',
    'disabled_by_key' => 'Не підтримується ліцензійним ключем',
    '__bytes' => "байти",
    '__can_not_use_reserved_words' => "Ви не можете використовувати зарезервовані слова",
    '__certificate' => "Сертифікат",
    '__cgi_support' => "Підтримка CGI",
    '__change_date' => "Дата модифікації",
    '__city' => "Місто",
    '__cl_not_exist' => "Обліковий запис замовника не існує.",
    '__client' => 'Замовник',
    '__client_card' => "Карта замовника",
    '__client_contact_name' => "Контактне ім’я замовника",
    '__client_form' => "Особиста інформація",
    '__client_ip_pool' => "IP-пул замовника",
    '__client_limits' => "Обмеження облікового запису замовника",
    '__client_permissions' => "Права доступу замовника",
    '__client_preferences' => "Налаштування замовника",
    '__client_status' => "Статус замовника",
    '__client_name' => "Ім'я замовника",
    '__client_total' => "Загалом за замовником",
    '__client_with_login_name_already_exists' => "Користувач з ім'ям користувача \"%1\" вже існує.",
    '__client_domuser_with_login_already_exists' => "Ім'я користувача '%1' вже використовується адміністратором домену '%1'.",
    '__clients_global_changes' => "Змінити дані вибраного облікового запису замовника",
    '__clients_list' => "Замовники",
    '__cmd_not_found' => "Невідома команда: %1",
    '__comments' => "Коментарі",
    '__company_name' => "Назва компанії",
    '__component_version' => "Версія компонента",
    '__component_not_installed' => "Компонент %1 не встановлений",
    '__confirm_del' => "Необхідно підтвердити видалення.",
    '__confirm_overwrite' => "Підтвердити перезапис.",
    '__confirm_stop' => "Ви повинні підтвердити зупинку процесу.",
    '__confirm_passwd' => "Підтвердить пароль %1",
    '__confirm_removal' => "Підтвердить видалення",
    '__conhelp' => "Опис",
    '__contact_name' => "Ім’я контакту",
    '__country' => "Країна",
    '__countries' => 'Країна',
    '__country_unknown' => 'Неможливо ідентифікувати індекс країни.',
    '__courier-imap' => 'Cервер Courier',
    '__create_domain' => 'Створити новий домен',
    '__crypted' => 'зашифрований',
    '__cp_access' => "Доступ до Plesk",
    '__cp_user' => "Користувач Plesk",
    '__create' => "Створити",
    '__create_client_template_without_template' => "Створити обліковий запис користувача без шаблону",
    '__create_domain_for' => "Створити новий домен для <b>%1</b>",
    '__create_domain_template_without_template' => "Створити домен без шаблону",
    '__creation_date' => "Дата створення",
    '__crontab_unix' => "Планувальник",
    '__crontab_win' => "Планувальник",
    '__ct_month_jan' => 'Січень',
    '__ct_month_feb' => 'Лютий',
    '__ct_month_mar' => 'Березень',
    '__ct_month_apr' => 'Квітень',
    '__ct_month_may' => 'Трав',
    '__ct_month_jun' => 'Червень',
    '__ct_month_jul' => 'Липень',
    '__ct_month_aug' => 'Серпень',
    '__ct_month_sep' => 'Вересень',
    '__ct_month_oct' => 'Жовтень',
    '__ct_month_nov' => 'Листопад',
    '__ct_month_dec' => 'Грудень',
    '__custom_button' => "Користувацька кнопка",
    '__custom_buttons_list' => "Посилання на додаткові сервіси",
    '__daily' => "Щодня",
    '__database_not_activated' => "%1 не активована на сторінці адміністрування серверу.",
    '__database_not_installed' => "База даних %1 не встановлена.",
    '__database_not_run' => "База даних %1 не запущена.",
    '__database_is_corrupt' => "Базу даних Plesk пошкоджено.  Для виправлення бази даних запустіть утіліту Reconfigurator.",
    '__databases' => "Бази даних",
    '__databases_list' => "Бази даних",
    '__database_type_not_supported_by_key' => 'Для користування сервером %1 вам потрібна його підтримка вашим ліцензійним ключем. Проконсультуйтеся з вашим торговим представником Plesk.',
    '__date_immediately' => "сьогодні",
    '__date_never' => "ніколи",
    '__day(s)' => "День(днів)",
    '__day0' => "Нд",
    '__day1' => "Пн",
    '__day2' => "Вівт",
    '__day3' => "Ср",
    '__day4' => "Четв",
    '__day5' => "Пт",
    '__day6' => "Сб",
    '__days' => "%1 день(днів)",
    '__db_admin_login_empty' => "При відключенні елементу управління %1 в інтерфейсі ви ввели порожнє ім’я користувача. Бажаєте продовжити?",
    '__db_unable_to_unregister' => 'Неможливо видалити параметри підключення бази даних',
    '__db_db_exists' => 'На сервері є хоча б одна база даних',
    '__db_unable_to_change_server_name' => 'Ім’я серверу не може бути змінено',
    '__db_unable_to_change_port' => 'Порт серверу не може бути змінений',
    '__db_already_exist' => "База даних %1 вже існує.",
    '__db_credentials_invalid' => "Облікові дані для входу в базу даних некоректні.",
    '__db_invalid_password_characters' => 'Пароль містить недійсні символи',
    '__db_engine' => "Рушій бази даних", // indirect
    '__db_type' => "Тип бази даних",
    '__db_user' => "Користувач бази даних",
    '__db_server' => 'Сервер бази даних',
    '__def_domain' => "Домен за замовчуванням",
    '__default_for_mysql' => 'за замовчуванням для MySQL',
    '__default_for_mariadb' => 'стандартно для MariaDB',
    '__default_for_percona' => 'стандартно для Percona',
    '__default_for_postgresql' => 'за замовчуванням для PostgreSQL',
    '__delete' => "Видалити",
    '__demo' => "Ця функція недоступна у пробній версії.",
    '__directory' => "Каталог",
    '__disable_lock_screen' => 'Заборонити користувачам працювати в Plesk, до того як будуть повністю завантажені сторінки інтерфейсу',
    '__dismiss_news?' => "Ви впевнені, що хочете повністю закрити блок новин? \n\nВи не зможете бачити блок новин поки не з’являться нові новини.",
    '__description' => "Опис",
    '__disabled' => "вимкнено",
    '__disk_space_limit' => "Обмеження дискового простору",
    '__cgroups_cpu_usage_limit' => 'Обмеження на використання ЦП',
    '__cgroups_ram_usage_limit' => 'Обмеження на використання RAM',
    '__cgroups_disk_read_usage_limit' => 'Обмеження пропускної здатності диска для зчитування',
    '__cgroups_disk_write_usage_limit' => 'Обмеження пропускної здатності диска для запису',
    '__disk_usage_by' => "Використання дискового простору %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Запис DNS '%1' вже існує.",
    '__dns_master_should_be_remote' => "Вам обхідно мати два різних авторитетних сервери імен на різних вузлах.",
    '__dns_record_not_exist' => "DNS-запис не існує.",
    '__dns_server' => "DNS-сервер", // indirect
    '__dom_id_is_undefined' => "Ідентифікатор домену не визначений.",
    '__dom_name' => "Ім'я домену",
    '__dom_name_is_invalid' => "Ім’я домену некоректне. Переконайтесь, що ім’я домену містить лише чисельно-буквені символи, крапки та дефіси, та його довжина не перевищує 255 символів. Довжина кожної частини імені домену, відокремленої крапками, не повинна перевищувати 63 символи.",
    '__dom_not_exist' => "Домен не існує.",
    '__domain' => "Домен",
    '__domain_' => 'Домен %1',
    '__domain_form' => "Форма домену",
    '__domain_id' => "ІД домену",
    '__domain_is_turned_off_for_backup' => "Сайт %1 тимчасово відключений для резервного копіювання або відновлення, і в даний час недоступний.",
    '__domain_limits' => "Обмеження домену",
    '__domain_name' => "Ім'я домену",
    '__mail_name_in_ASCII_form' => "Ім’я поштового облікового запису в форматі ASCII",
    '__message_error' => 'Помилка',
    '__message_warning' => 'Попередження',
    '__message_info' => 'Інформація',
    '__domain_name_in_ASCII_form' => "Ім’я домену у форматі ASCII",
    '__domain_repository' => "Сховище домену %1",
    '__domain_status' => "Статус домену",
    '__domain_found_tech' => "Технологія, знайдена в домені",
    '__domain_dns' => 'DNS-зона домену',
    '__domain_total' => "Загальна кількість для підписки",
    '__domain_total_powerUser' => "Загальна кількість для підписки",
    '__domain_user' => "Адміністратор домену",
    '__domains_global_changes' => "Модифікувати вибрані домени",
    '__mailnames_global_changes' => "Редагувати вибрані поштові облікові записи",
    '__backup_manager' => 'Менеджер резервного копіювання',
    '__domains_list' => "Домени",
    'domains_list__list_header' => "домени",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Ім’я домену має починатись з символів www, але в імені використаний префікс WWW.\nПродовжити, незважаючи на це?",
    '__dovecot' => 'Dovecot IMAP та POP3-сервер',
    '__dsmail' => "Поштовий сервіс",
    '__dsmaillist' => "Сервіс поштової розсилки",
    '__dumps_tot_size' => "Загальний розмір резервних копій у локальному сховищі",
    '__email' => "Електронна пошта",
    '__email_addr_is_invalid' => "Адреса електронної пошти некоректна.",
    '__enabled' => "ввімкнено",
    '__enter_cert_text' => "Введіть текст сертифікату",
    '__enter_size' => "Введіть розмір",
    '__exclusive' => "Призначений",
    '__expiration_date' => "Дата закінчення строку дії",
    '__fax' => "Факс",
    '__file' => "Файл",
    '__file_is_empty' => "Файл порожній.",
    '__file_name' => "Назва файлу",
    '__file_type' => 'Тип файлу',
    '__filemanager' => "Файловий менеджер",
    '__filepath_is_empty' => "Шлях до файлу порожній",
    '__files_list' => "Файли",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Налаштування FTP",
    '__ftp_serv' => "FTP-сервер", // indirect
    '__ftp_server_parameters_are_empty' => "Спочатку ви повинні встановити властивості облікового запису FTP!",
    '__ftp_status' => "Статус FTP-серверу",
    '__full_day0' => "Неділя",
    '__full_day1' => "Понеділок",
    '__full_day2' => "Вівторок",
    '__full_day3' => "Середа",
    '__full_day4' => "Четвер",
    '__full_day5' => "П’ятниця",
    '__full_day6' => "Субота",
    '__full_month1' => "Січень",
    '__full_month10' => "Жовтень",
    '__full_month11' => "Листопад",
    '__full_month12' => "Грудень",
    '__full_month2' => "Лютий",
    '__full_month3' => "Березень",
    '__full_month4' => "Квітень",
    '__full_month5' => "Трав",
    '__full_month6' => "Червень",
    '__full_month7' => "Липень",
    '__full_month8' => "Серпень",
    '__full_month9' => "Вересень",
    '__giga' => "ГБ",
    '__group' => "Група",
    '__h' => "H",
    '__hard_disk_quota' => "Квота жорсткого диску",
    '__hard_disk_quota_not_supported' => 'квота жорсткого диску не підтримується конфігурацією файлової системи серверу',
    '__header_text_is_invalid' => "Назва захищеної території недійсна.",
    '__help_topic_not_found' => 'Розділ довідки, до якого Ви звернулись (%1), не існує.',
    '__hosting_ip_dns_ip_not_equiv' => "Жодна з IP-адрес, вказаних у DNS-записі А, не співпадає з IP-адресою, яка використовується для хостингу.",
    '__hosting_scripting' => "Підтримка скриптів хостингу",
    '__hosting_setup_page_title' => "Установка веб-хостингу для домену %1",
    '__hosting_title' => "Хостинг (%1)",
    '__hosting_type' => "Тип хостингу",
    '__hostname_is_empty' => "Ім’я вузла порожнє",
    '__hour(s)' => 'Година(и)',
    '__hst_type_incorrect' => "Некоректний тип хостингу",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Час очікування",
    '__iface' => "Інтерфейс",
    '__image' => "Зображення",
    '__imap_status' => "Статус серверу IMAP",
    '__in' => "В",
    '__in_%' => "у %",
    '__incorrect_databases_login_pass' => "Вказані облікові дані для входу у PostgreSQL некоректні.",
    '__incorrect_ip_or_network_address' => 'Неправильна IP-адреса або мережа.',
    '__info' => 'Інформація',
    '__install' => "Встановити",
    '__install_prefix' => "Префікс установки",
    '__invalid_cert_id' => "Некоректний ідентифікатор сертифікату",
    '__invalid_context' => "Некоректний контекст: %1",
    '__invalid_db_usr_name' => "Ім'я користувача бази даних недійсне.",
    '__invalid_dir_name' => "Ім'я каталогу недійсне",
    '__invalid_dom_name' => "Некоректне ім’я домену.",
    '__invalid_filename' => "Некоректне ім’я файлу. Не слід використовувати символи одинарних лапок та/або комбінацію\"../\".",
    '__invalid_id' => "Некоректний ідентифікатор",
    '__invalid_lines_num' => "Невірне значення кількості рядків ‒ допускаються лише цифри.",
    '__invalid_max_letter_size' => "Некоректний максимальний розмір повідомлення.",
    '__invalid_pdir_name' => "Некоректне ім’я захищеного каталогу",
    '__invalid_restart_apache_interval' => "Некоректний інтервал перезапуску Apache",
    '__invalid_tmpl_name' => "Некоректне ім’я шаблону.",
    '__invalid_value' => "Невірне значення",
    '__ip_addr' => "ІР-адреси",
    '__ip_address_and_mask' => "IP-адреса та маска підмережі",
    '__ip_alias__mask' => "IP-адреса та маска підмережі",
    '__ip_addr_is_invalid' => "ІР-адреса недійсна.",
    '__ip_addr_list' => "IP-адреси",
    '__ip_address_and_mask_hint' => 'Наприклад, %1',
    '__is_owner' => "О",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK (пакет для розробників Java)",
    '__kb' => "Кбайт",
    '__kbps' => "КБ/с",
    '__kbytes' => "КБайт",
    '__key_for_virtuozzo_only' => "Ваш ліцензійний ключ призначений лише для використання у Virtuozzo Containers.",
    '__key_limits_exceeding' => "Ця дія призведе до перевищення обмежень, визначених ліцензією вашого програмного забезпечення. Якщо ви отримали це повідомлення, ви можете звернутись до свого постачальника послуг або до виробника для уточнення або розширення  обмежень, встановлених цією ліцензією.",
    '__kilo' => "КБ",
    '__keywords' => 'Ключові слова',
    '__lang_unknown' => 'Неможливо розпізнати мову.',
    '__languages' => 'Мова',
    '__learn_more' => 'Дізнатися більше',
    '__loading' => 'Завантаження...',
    '__locales' => "Мовні пакети",
    '__lists' => "Переліки поштових розсилок",
    '__literal_bytes' => "Б",
    '__processing' => "Зачекайте, будь ласка.<br>Завантаження…",
    '__locale' => "Мова інтерфейсу",
    '__locale_is_not_defined' => "Мова інтерфейсу не визначена.",
    '__local_server_mysql' => 'Локальний сервер MS SQL',
    '__local_server_postgresql' => 'Локальний сервер PostgreSQL',
    '__local_server_mssql' => 'Локальний сервер MS SQL',
    '__log_and_statistics_files' => 'Журнали та статистичні звіти',
    '__config_files' => 'Файли конфігурації',
    '__chroot_files' => 'Середовище зі зміненим кореневим каталогом',
    '__login' => "Вхід у систему %1",
    '__login1' => "Вхід у систему",
    '__login_disabled' => "Вхід у систему заборонений",
    '__login_enabled' => "Вхід у систему дозволений",
    '__login_incorrect' => "Ви ввели неправильне ім’я користувача або пароль.",
    '__login_name' => "Ім’я користувача %1",
    '__login_name_is_invalid' => "Неправильне ім’я користувача %1.",
    '__logon_time' => "Час входу в систему",
    '__ma' => "Псевдоніми поштових адрес",
    '__mail' => "Пошта",
    '__mail_alias_name' => "Ім'я псевдоніму поштового облікового запису",
    '__mail_autodiscovery' => 'Автовиявлення пошти',
    '__mail_exchanger_name_is_invalid' => "Некоректне ім’я поштового шлюза.",
    '__mail_groups' => "Поштова група",
    '__mail_list_engine' => "Програмне забезпечення для поштової розсилки",
    '__mail_name' => "Обліковий запис електронної пошти",
    '__mail_name_form' => "Параметри поштового облікового запису",
    '__mail_names' => "Облікові записи електронної пошти.",
    '__mail_serv' => "Поштовий сервер",
    '__mail_user' => 'Користувач пошти',
    '__mailgroup' => "Поштова група",
    '__maillist' => "Список електронних адрес",
    '__maillists' => "Переліки поштових розсилок",
    '__maillist_member' => 'Член списку розсилки',
    '__mailname' => "Обліковий запис електронної пошти",
    '__mailname_redir_self' => "Поштовий обліковий запис не може пересилати пошту собі.",
    '__max_dom_num_reached_for_cl' => "Досягнуто ліміту на кількість доменів для цього облікового запису замовника.",
    '__max_file_size_available' => "Максимально дозволений розмір файлу %1",
    '__max_subdom_num_reached_for_cl' => "Досягнуто ліміту на кількість субдоменів для цього облікового запису замовника.",
    '__max_subdom_num_reached_for_dom' => "Досягнуто ліміту на кількість субдоменів для домену.",
    '__max_subdom_num_reached_for_key' => "Досягнуто ліміту на кількість субдоменів, встановленого ліцензійним ключем.",
    '__max_traffic_limit' => "Обмеження трафіку",
    '__maximum_excl_ip_num' => "Облікові записи електронної пошти.",
    '__mb' => "Мбайт",
    '__mbytes' => "мегабайти",
    '__mb_month' => "МБ/місяць",
    '__mb_sec' => "МБ/сек",
    '__gb_sec' => "ГБ/сек",
    '__tb_sec' => "ТБ/сек",
    '__mega' => "МБ",
    '__minute(s)' => 'Хвилина(и)',
    '__mls_not_in_key' => "Ваш ключ продукту не підтримує багатомовний інтерфейс",
    '__modification_date' => "Дата модифікації",
    '__module' => "Модуль",
    '__month' => "Місяць",
    '__month(s)' => "Місяць(ів)",
    '__month1' => "Січ",
    '__month10' => "Жовт",
    '__month11' => "Лист",
    '__month12' => "Груд",
    '__month2' => "Лют",
    '__month3' => "Бер",
    '__month4' => "Квітень",
    '__month5' => "Трав",
    '__month6' => "Червень",
    '__month7' => "Липень",
    '__month8' => "Серп",
    '__month9' => "Вер",
    '__monthly' => "Щомісяця",
    '__months' => "Місяці",
    '__moved_permanently' => 'Перенесений назавжди',
    '__mssql' => "Сервер Microsoft SQL",
    '__mssql__server' => "Сервер",
    'mssql__server' => "Ім’я серверу Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "неможливо змінити ім’я серверу — на ньому існує як найменше одна база даних.",
    '__mssql_status' => "Статус серверу Microsoft SQL",
    '__multiply_login_deny' => "Вхід в систему неможливий. Інший користувач з тим самим ім’ям (%1) вже увійшов до Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Статус серверу MySQL",
    '__mysql_version' => "Версія MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Статус сервера MariaDB",
    '__mariadb_version' => "Версія MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Статус сервера Percona",
    '__percona_version' => "Версія Percona",
    '__name' => "Ім’я",
    '__name_invalid' => "Некоректне ім’я.",
    '__nameserver' => "сервер імен",
    '__network' => "Мережа",
    '__networks' => "Мережі",
    '__no' => "Ні",
    '__no_ip_address_with_properly_type_available' => "Неможливо відновити резервну копію даних ‒ немає відповідної IP-адреси, необхідної для відновлення.",
    '__no_clients_specified' => "Не вказано жодного облікового запису замовника.",
    '__no_comments' => "Без коментарів.",
    '__nologin' => "Заборонено",
    '__none' => "Немає",
    '__not_configured' => "Не налаштовано",
    '__not_implemented_yet' => "Ще не впроваджений",
    '__not_supported_by_ftp' => "(не підтримується сервером FTP)",
    '__notification' => "Повідомлення",
    '__num_displayed' => "Показано %1 з %2",
    '__num_is_invalid' => "Невірна кількість.",
    '__object_not_found' => 'Об’єкт не знайдений: %1',
    '__of_all' => "% від всіх",
    '__off' => "Вимкнути",
    '__ok' => "ОК",
    '__old_passwd' => "Пароль старого %1",
    '__on' => "Увімкнути",
    '__others' => "Інші",
    '__other_ip__will_be_added' => 'Інші доступні IP-адреси (будуть додані у пул IP-адрес клієнта)',
    '__out' => "Вихід",
    '__p' => "P",
    '__passwd' => "Пароль %1",
    '__passwd_is_invalid' => "Некоректний пароль %1.",
    '__passwd_not_match' => "Пароль не співпадає!",
    '__path' => "Шлях",
    '__perl_unix_support' => "Підтримка Perl",
    '__perl_win_support' => "Підтримка Perl",
    '__perm_denied' => "Право скасовано.",
    '__permissions' => "Права доступу",
    '__personal_name' => "Ім’я",
    '__pg_admin_not_activated' => "PostgreSQL не активований на сторінці адміністрування серверу.",
    '__pg_not_inst' => "PostgreSQL не встановлений.",
    '__pg_not_run_or_inst' => "PostgreSQL не встановлений або не запущений.",
    '__pg_not_support_in_key' => "PostgreSQL не підтримується ліцензійним ключем.",
    '__phone' => "Телефон",
    '__phosting' => "Фізичний хостинг",
    '__php_support' => "Підтримка PHP",
    '__php_run_as_isapi' => "запустити як розширення ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' на",
    '__php_version' => "Версія РНР",
    '__physical' => "Фізичний хостинг",
    '__plesk_stat_pdir' => "Захистити каталог '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Статистика домену",
    '__plesk_stat_protect' => "Заблокуйте доступ до статистики вашого вебсайту, використовуючи ваше користувацьке ім'я FTP та пароль",
    '__plesk_stat_protect_install' => "доступно через захищений паролем каталог '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Статус серверу POP3",
    '__popen_error' => "Під час виклику функції popen виникла помилка.",
    '__port' => 'Порт',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Статус PostgreSQL",
    '__preferences' => "Налаштування",
    '__account_preferences' => "Налаштування облікового запису",
    '__interface_preferences_general' => 'Загальні дані',
    '__interface_preferences_default' => 'Параметри інтерфейсу за замовчуванням',
    '__interface_preferences_admin' => "Параметри інтерфейсу адміністратора",
    '__interface_template' => 'Шаблон налаштування інтерфейсу',
    '__interface_preferences' => "Параметри інтерфейсу",
    '__proceed?' => "Ви бажаєте продовжити?",
    '__protect_dir_user' => "Користувач захищеного каталогу",
    '__protect_dir_users' => "Користувачі захищеного каталогу",
    '__provider_contact_name' => "Контактна персона власника",
    '__python_unix_support' => "Підтримка Python",
    '__python_win_support' => "Підтримка Python",
    '__quota' => "Квота",
    '__r' => "R",
    '__reconfigure' => "Реконфігурувати",
    '__record_type' => "Тип запису",
    '__release' => "Позбавляти",
    '__remote_db_not_supported_by_key' => 'Віддалений хостинг баз даних не підтримується вашим ліцензійним ключем.',
    '__remove' => "Видалити",
    '__remove_confirmation' => "Підтвердити видалення",
    '__remove_protection' => 'Зняти захист',
    '__report' => "Звіт",
    '__report_size_na' => "Сервіс недоступний",
    '__reports_list' => "Звіти",
    '__requested' => "Очікується",
    '__required_fields' => "Поля обов'язкові для заповнення",
    '__resp_name_invalid' => "Ім’я автовідповіді недійсне. Використовуйте тільки чисельно-буквені символи, точки, підкреслення і пробіли.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Невірне ім’я серверу.",
    '__screenshots' => 'Знімок екрану',
    '__script_warning' => "Якщо відключити підтримку скриптів на цьому домені, всі скрипти, на які це вплине, будуть відображатись в оглядачі як простий текст. Рекомендуємо адміністратору видалити всі пов’язані скрипти з даного домену.",
    '__sec' => "Секунди",
    '__second(s)' => "Секунда(и)",
    '__see_list_of_logged_in' => "Дивись список користувачів, які знаходяться у системі на даний момент.",
    '__select_certs_to_remove' => "Виберіть сертифікати, які потрібно видалити.",
    '__select_files_to_remove' => "Виберіть файли, які необхідно видалити.",
    '__select_ip' => "Призначити IP-адресу",
    '__select_ip_to_remove' => "Виберіть IP-адресу, яку потрібно видалити.",
    '__select_domain_template' => "Застосувати параметри шаблону домену",
    '__select_templates_to_remove' => "Виберіть шаблони, які потрібно видалити.",
    '__server' => "Сервер",
    '__server_total' => "Загалом по Серверу",
    '__service' => "Сервіс",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Сервер баз даних MySQL",
    '__service_description__mysql' => "Сервер баз даних MySQL",
    '__service_title__web' => "Веб-сервер",
    '__service_description__web' => "Веб-сервер",
    '__service_title__smtp' => "SMTP-сервер",
    '__service_description__smtp' => "SMTP-сервер",
    '__service_title__mail' => "Сервер IMAP/POP3",
    '__service_description__mail' => "Сервер IMAP/POP3",
    '__service_title__dns' => "DNS-сервер",
    '__service_description__dns' => "DNS-сервер",
    '__service_title__postgresq' => "Сервер баз даних PostgreSQL",
    '__service_description__postgresq' => "Сервер баз даних PostgreSQL",
    '__service_title__spamassassin' => "SpamAssassin служба фільтрації спаму",
    '__service_description__spamassassin' => "SpamAssassin служба фільтрації спаму",
    '__services' => "Сервіси",
    '__all_services' => "Всі сервіси",
    '__sessions' => "Сеанси",
    'sessions__feature_ftp_session_manager_not_supported' => "Функція сеансів FTP не підстримується поточним FTP сервером",
    '__sessions_list' => "Сеанси",
    '__set' => "Увімкнути",
    '__shared' => "Спільного користування",
    '__shell_access_warning' => "Забезпечення дозволу на доступ оболонки до системи є дуже небезпечним для системи безпеки. Надавайте доступ до системи тільки якщо ви чітко розумієте, що ви робите, і тільки довіреним користувачам. Ви дійсно хочете надати доступ?",
    '__siteapp_not_support_in_key' => "Веб-застосунки не мають у комплекті ліцензійного ключа",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Конфігурація цього веб-застосунку була змінена вручну. Щоб захистити виконані вручну зміни, повторна конфігурація через Plesk є недоступною.',
    '__site_management' => "Веб-публікації", // indirect
    '__size' => "Розмір",
    '__skeleton' => 'Віртуальний шаблон хосту',
    '__skins' => 'Зовнішня оболонка',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Статус серверу SMTP",
    '__some_fields_are_empty_or_invalid' => "Деякі поля порожні або заповнені непідходящими значеннями.",
    '__unable_to_set_parameters' => "Неможливо налаштувати параметри компонента.",
    '__spamassassin' => "Спам-фільтр",
    '__spamassassin_status' => "Статус SpamAssassin",
    '__spamd_status' => 'Статус спам-фільтру',
    '__splited_backup' => "(багатотомний архів)",
    '__split_backup_file' => "Створити багатотомний архів",
    '__split_backup_size' => "Загальний об’єм",
    '__split_backup_less_than_500' => "Розміри обсягу менші за 500 мегабайт не підтримуються",
    '__ssi' => "SSI",
    '__ssi_support' => "Підтримка SSI",
    '__ssi_with_html' => "використати SSI для файлів формату *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Підтримка SSL/TLS",
    '__same_ssl' => "Використовуйте один каталог для розміщення SSL/TLS та non-SSL/TLS контенту",
    '__same_ssl_cu' => "Спільний контент SSL/TLS та не-SSL/TLS",
    '__state' => "Країна/провінція",

    '__status__Active' => 'Працює',
    '__status__active' => 'активний',
    '__status__Passive' => 'Вимкнено',
    '__status__passive' => 'вимкнено',
    '__status__off' => 'вимкнено',
    '__status__with_parent' => 'вимкнено',
    '__status__backup_restore' => 'тимчасово призупинено для резервного копіювання або відновлення',
    '__status__admin' => 'призупинено адміністратором сервера',
    '__status__resseler' => 'призупинено посередником',
    '__status__client' => 'призупинено ззамовником',
    '__status__unknown' => 'статус невідомий',

    '__status_of' => "статус %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Сервер Stunnel", // indirect
    '__subdomain' => "Субдомен",
    '__subdomain_name' => "Ім’я субдомену",
    '__subdomain_name_in_ASCII_form' => "Ім’я субдомену в форматі ASCII",
    '__subdomains' => "Субдомени",
    '__domainaliases' => "Псевдоніми домена",
    '__subdomains_list' => "Субдомени",
    '__subdomains_not_support_in_key' => "Операції субдомену не підтримуються ліцензійним ключем",
    '__sys_user_type' => "Користувач FTP",
    '__sys_user_type_main' => "Скористуйтесь обліковим записом користувача FTP головного домену",
    '__sys_user_type_native' => "Створити окремий обліковий запис користувача FTP для цього субдомену",
    '__t' => "Т",
    '__target_domain' => "Цільовий домен",
    '__template' => "Шаблон",
    '__template_not_accepted' => "Не можу прийняти шаблон: перевищені вказані обмеження.",
    '__templates' => "Шаблони",
    '__templates_list' => "Шаблони",
    '__tera' => "Т",
    '__title' => "Назва",
    '__tools' => "Інструменти",
    '__total' => "Усього %1",
    '__total_size' => "Загальний розмір",
    '__total_used' => "Усього Використано",
    '__traffic' => "Трафік",
    '__traffic_by_client' => "Трафік за замовниками",
    '__traffic_by_domain' => "Трафік за доменами",
    '__traffic_by_service' => "Трафік за сервісами",
    '__traffic_history' => "Історія трафіку",
    '__unable_change_locale' => "Не можу змінити мову інтерфейсу: %1",
    '__unable_create_new_dom' => "Не можу створити новий домен: %1",
    '__unable_define_dom_name' => "Не можу визначити ім’я домену: %1",
    '__unable_define_necessary_properties' => "Не можу визначити всі необхідні властивості.",
    '__unable_define_properties' => "Не можу визначити властивості: %1",
    '__unable_exec_util' => "Не можу запустити утиліту: %1",
    '__unable_get_dns_a_recs' => "Не можу отримати IP-адреси записів A DNS для цього облікового запису хостингу: %1",
    '__unable_get_mbox_quota' => "Неможливо отримати інформацію про обмеження розміру поштової скриньки.",
    '__unable_redirect_to_myself' => "Неможливо переадресувати на той же обліковий запис.",
    '__unable_redirect_to_my_alias' => "Неможливо надіслати лист на альтернативну пошту.",
    '__default_domain_redirect_to_myself' => "Неможливо встановити домен за замовчуванням для IP-адреси ‒\n виявлене переспрямовування на самого себе.",
    '__unable_remove_client' => "Не можу видалити замовника: %1",
    '__unable_set_up_mbox_quota' => "Неможливо встановити обмеження розміру поштової скриньки для домену: %1",
    '__unable_setup_pass' => "Неможливо встановити пароль: %1",
    '__unable_to_create_new_account' => "Неможливо створити новий обліковий запис: %1",
    '__unable_to_define_db_size' => "Неможливо визначити розмір бази даних.",
    '__unable_to_enable_short_names' => "Неможливо дозволити використання коротких імен поштових облікових записів для облікових записів POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Неможливо вилучити надані дані: %1",
    '__unable_to_open_file' => "Неможливо відкрити файл %1: %2",
    '__unable_to_update_subdomain' => "Неможливо внести зміни до субдомену: %1",
    '__unable_update_cl_data' => "Неможливо зберегти зміни в обліковому записі користувача: %1",
    '__unable_update_db_params' => "Неможливо оновити параметри бази даних: %1",
    '__unable_update_dom_data' => "Неможливо оновити дані домену: %1",
    '__undefined' => "невизначено",
    '__uninstall' => "Видалити",
    '__unknown_error' => "Невідома помилка",
    '__unlimited_lower' => "Необмежений",
    '__unset' => "Вимкнути",
    '__update' => "Оновлення",
    '__uploaded_file_is_invalid' => "Вивантажений файл некоректний: %1",
    '__url' => "URL",
    '__usage' => "Використання диску",
    '__user' => 'Користувач',
    '__user_already_logged' => "Інший користувач с тим же ім’ям (%1) вже увійшов у Plesk.",
    '__version' => "Версія",
    '__aps_license' => "Ліцензійний ключ",
    '__vh_type' => "Тип віртуального вузла",
    '__vhosts_apache_status' => "Статус веб-серверу",
    '__wrong_charset_conversion' => 'Неправильне кодування, перетворення з "%1" на "%2" не дозволяється',
    '__warning_' => "Попередження!",
    '__warning_excl_ip_num' => "Виділена ІР-адреса",
    '__warning_expiration' => "Дата закінчення строку дії",
    '__web_scripting' => "Написання веб-скриптів", // indirect
    '__web_serv' => "Веб-сервер", // indirect
    '__web_statistic' => "Веб-статистика", // indirect
    '__webmail' => "Поштовий веб-інтерфейс", // +indirect
    '__webstat_not_installed' => "Webalizer не встановлений на сервері. Зверніться до постачальника послуг за допомогою з установкою Webalizer.",
    '__webstat_support' => "Веб-статистика",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "При перемиканні з однієї статистичної програми на іншу всі звіти, створені раніше використовуваною статистичною програмою, будуть видалені, а нові звіти будуть створені відповідно до інформації, взятої з журналів, що зберігаються на сервері. Це означає, що якщо ви налаштували систему (у Домени > ім'я домену > Менеджер журналів > Ротація журналів) зберігати журнали тільки за останній місяць, то веб-статистика буде доступна тільки за останній місяць. Ви бажаєте переключитись на інший пакет статистики?",
    '__webstat_perm_denied' => 'Ви не маєте права на управління веб-статистикою.',
    '__webuser' => "Користувач мережі",
    '__sysusers_list' => "Користувачі системи",
    '__sysuser' => "Системний користувач",
    '__weekly' => "Щотижня",
    '__whats_new_in_version' => "Що нового в Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Ця операція доступна тільки для доменів із веб-хостингом.",
    '__wrong_hosting_type__none' => 'Веб-хостинг для домену %1 не налаштований.',
    '__wrong_hosting_type__std_fwd' => 'Для домену %1 налаштована стандартна переадресація. Ця операція доступна тільки для доменів з веб-хостингом.',
    '__wrong_hosting_type__frm_fwd' => 'Для домену %1 налаштовано переадресацію фреймів. Ця операція доступна лише для доменів з веб-хостингом.',
    '__wu' => "Веб-користувачі",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Префікс WWW був змінений. Переконайтесь у тому, що до сертифікату SSL/TLS внесені відповідні зміни.",
    '__year' => "Рік",
    '__year(s)' => "Рік(Роки)",
    '__yes' => "Так",
    '__you' => "Ви",
    '__zip_code' => "Поштовий індекс",
    '__form_normal' => "Нормальний",
    '__form_advanced' => "Додаткові параметри",

    'admin_ed__edit_administrator_info' => "Редагування профілю адміністратора",
    'admin_ed__create_default_client' => "Я би хотів створити обліковий запис замовника за замовчуванням.",
    'admin_ed__unable_update' => "Не можу оновити інформацію адміністратора: %1",

    'auth__update_admin_info' => "Будь ласка, введіть інформацію адміністратора. Ця інформація необхідна для роботи %1.",
    'auth__you_not_have_perm' => "У вас немає дозволу на управління цим доменом.",
    'auth__key_expired_admin' => 'Строк дії ліцензії Plesk закінчився. Відновіть існуючу ліцензію або придбайте нову, щоб надалі використовувати Plesk.',
    'auth__key_expired_admin_restricted' => 'Строк дії ліцензії Plesk закінчився. Зверніться до свого провайдеру послуги.',
    'auth__key_expired_client' => 'Строк дії ліцензії Plesk закінчився. Зверніться до свого хостинг-провайдера.',
    'autoinstaller__not_installed' => 'Компонент Autoinstaller не встановлений.',
    'autoinstaller__release_action' => 'Доступні операції',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Модернізація до нової версії Plesk',
    'autoinstaller__release_action_update' => 'Оновлення або додавання нових компонентів',
    'autoinstaller__release_action_up2date' => 'У вас оновлена версія',
    'autoinstaller__component_action' => 'Статус',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Не встановлено',
    'autoinstaller__component_action_update' => 'Оновлення доступні',
    'autoinstaller__component_action_upgrade' => 'Доступне оновлення',
    'autoinstaller__component_action_up2date' => 'У вас оновлена версія',
    'autoinstaller__component_action_error' => 'Оновлення не доступні',
    'autoinstaller__component_serverbuildtime' => 'Останній випуск',
    'autoinstaller__component_localbuildtime' => 'Ваш випуск',
    'autoinstaller__component_installed_version' => 'Ваша версія',
    'autoinstaller__component_available_version' => 'Остання версія',
    'autoinstaller__component' => 'Компонент',
    'autoinstaller__components' => 'Компоненти',
    'autoinstaller__components_title' => '%1 Компоненти',
    'autoinstaller__component_dependency_note' => 'необхідне для встановлення компонентів, які ви вибрали',
    'autoinstaller__install_confirm' => 'Так, я хотів би встановити ці компоненти',
    'autoinstaller__install_confirm_request' => 'Будь ласка, виберіть прапорець для підтвердження',
    'autoinstaller__install_title' => 'Підтвердьте установку вибраних компонентів',
    'autoinstaller__key_update_confirm' => 'Підтвердіть пропуск оновлення ключа і установку ключа за замовчуванням',
    'autoinstaller__key_update_confirm_request' => 'Будь ласка, встановіть прапорець для підтвердження.',
    'autoinstaller__key_update_failed' => '<p> Plesk не в змозі оновити ліцензію на ваш продукт.</p> <p> %1</p> <p> Продовження оновлення без наявності відповідної ліцензії на продукт призведе до установки ліцензії за замовчуванням з обмеженою функціональністю. Адміністраторам рекомендується спочатку придбати відповідний ліцензійний ключ перед продовженням процесу оновлення продукту.</p>',
    'autoinstaller__email' => 'Відправити сповіщення',
    'autoinstaller__email_admin' => "Електронна адреса адміністратора",
    'autoinstaller__email_email' => 'Користувацька електронна адреса…',
    'autoinstaller__release' => 'Ім’я випуску',
    'autoinstaller__releases' => 'Доступні випуски',
    'autoinstaller__releases_title' => 'Модуль оновлення Plesk',
    'autoinstaller__select_components_to_install' => 'Виберіть компоненти, що мають бути встановлені',
    'autoinstaller__status_error' => 'Помилка: %1',
    'autoinstaller__status_install_error' => 'Не вдалося розпочати встановлення: %1',
    'autoinstaller__status_install_busy' => 'Не вдалося розпочати встановлення: на даний момент проходить інша процедура встановлення.',
    'autoinstaller__status_install_ok' => 'Процес встановлення розпочато. Вас сповістять про хід встановлення електронною поштою (%1).',
    'autoinstaller__status_query_busy' => 'Відбувається процес встановлення.',
    'autoinstaller__status_query_error' => 'Неможливо отримати статус процесу встановлення: %1',
    'autoinstaller__status_unknown' => 'Неможливо отримати статус Autoinstaller.',
    'autoinstaller__status_busy' => 'Autoinstaller зайнятий, будь ласка, зачекайте.',
    'autoinstaller__configure_title' => 'Налаштування системи оновлення',
    'autoinstaller__preferences_legend' => 'Налаштування',
    'autoinstaller__target' => 'Тимчасовий каталог завантаження',
    'autoinstaller__target_invalid' => "Вкажіть абсолютний шлях",
    'autoinstaller__check_updates' => 'Перевірте оновлення від імені адміністратора Plesk',
    'autoinstaller__check_updates_warning' => 'Нові <a href="%1">updates</a> доступні для %2',
    'autoinstaller__source_type' => 'Вихідний тип',
    'autoinstaller__source' => 'Вихідне URL',
    'autoinstaller_source__preferences_legend' => 'Налаштування',
    'autoinstaller_source__type' => 'Вихідний тип',
    'autoinstaller_source__url_invalid' => 'Невірне джерело',
    'autoinstaller_source__url_invalid_network' => 'Невірне URL джерела (Приклад: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Вихідне URL',
    'autoinstaller__source_invalid_network' => 'ви вказали неправильну адресу мережі',
    'backup__repository' => 'Місце зберігання резервних файлів',
    'backup__error_notify_email' => 'У разі виникнення помилок при виконанні резервного копіювання, відправте повідомлення електронною поштою',
    'backup__dump_info' => "Інформація про резервну копію",
    'backup__dump_file_name_not_defined' => "Не вказано ім’я резервної копії",
    'backup__local_file' => 'Локальна резервна копія файлу',
    'backup__domain_ftp' => 'віддалений FTP-сервер',
    'backup__wrong_path' => "Невірний шлях до сховища резервної копії файлу: не слід використовувати послідовність символів ../../",
    'backup__unable_to_connect_to_ftp_server' => "Неможливо підключитись до серверу FTP: %1",
    'backup__unable_to_read_file' => 'Неможливо прочитати резервну копію файлу.',
    'backup__backup_task_does_not_exist' => "Завдання з резервного копіювання не існує. Перед запуском необхідно створити завдання з резервного копіювання.",
    'backup__restore_params' => "Параметри відновлення",
    'backup__confirmation' => "Попередження: домен не буде доступний протягом резервного копіювання/відновлення.",
    'backup__backup_method' => 'Метод резервного копіювання',
    'backup__dumpfile_name' => "Ім’я резервної копії файлу",
    'backup__dumpfile_name_is_invalid' => "Некоректне ім’я резервної копії файлу: слід використовувати лише чисельно-буквені символи, тире, крапку та символ підкреслювання; імена резервних копій типу \"опис.*\" не допускаються.",
    'backup__email_required' => "Потрібна ваша адреса електронної пошти для того, щоб інформувати вас щодо процесу виконання резервного копіювання і відновлення. Будь ласка, вкажіть вашу електронну адресу в даних облікового запису.",
    'backup__error_during_backup' => "Неможливо створити резервну копію файлу: %1",
    'backup__input_email_warning' => "Вкажіть адресу електронної пошти для сповіщення або зніміть прапорець.",
    'backup__make_download' => "не слід зберігати резервну копію файлу в сховищі, її необхідно завантажувати",
    'backup__make_dump' => 'створіть резервну копію файлу та зберігайте її в локальному сховищі',
    'backup__makedump_to_ftp' => 'створіть резервну копію файлу та зберігайте її на дистанційному сервері FTP',
    'backup__restore_ip' => "IP-адреса для відновлення",
    'backup__select_dumpfile' => "Вибрати резервну копію файлу.",
    'backup__time' => "Тривалість створення резервної копії",
    'backup__day' => 'День створення резервної копії',
    'backup__view_dump_info' => "Переглянути інформацію про резервну копію домену %1",
    'backup__wrong_domain_name' => "Резервна копія містить дані домену %1 та може бути відновлена на домені %2",
    'backup__incorrect_ftp_user_or_passwd' => "Невірний користувач FTP або пароль. Будь ласка, виправте властивості облікового запису FTP",
    'backup__access_denied' => "Доступ заборонений. Будь ласка, виправте властивості облікового запису FTP",
    'backup__restore_from' => "Відновити %1",
    'backup__domain_session_failed' => 'Не було створено резервної копії домену %1',
    'backup__client_session_failed' => 'Не було виконано резервне копіювання облікового запису замовника %1',
    'backup__domain_session_restore_failed' => 'Домен %1 не був відновлений',
    'backup__client_session_restore_failed' => 'Обліковий запис замовника %1 не було відновлено',
    'backup__domain_session_complete' => 'Було створено резервну копію домену %1',
    'backup__domain_session_backup' => 'Резервне копіювання домену %1',
    'backup__client_session_backup' => 'Резервне копіювання замовника %1',
    'backup__domain_stop_title' => 'Скасування резервного копіювання домену %1',
    'backup__client_stop_title' => 'Скасування резервного копіювання облікового запису замовника %1',
    'backup__domain_restore_stop_title' => 'Скасування відновлення домену %1',
    'backup__client_restore_stop_title' => 'Скасування відновлення облікового запису замовника %1',
    'backup__domain_session_backup_stop' => 'ви збираєтесь скасувати активний процес резервного копіювання. Резервна копія файлу не буде створена.',
    'backup__backup_stop_confirm' => 'Так, я хочу зупинити процес резервного копіювання',
    'backup__restore_stop_confirm' => 'Так, я хочу зупинити процес відновлення',
    'backup__domain_session_restore' => 'Відновлення домену %1',
    'backup__domain_session_restore_stop' => 'Ви збираєтесь скасувати активний процес відновлення.',
    'backup__domain_backup_file_info' => 'Інформація щодо резервних копій файлів домену',
    'backup__domain_backup_file_list' => 'існуючі резервні копії файлів',
    'backup__domain_backup_progress' => 'Перебіг виконання резервного копіювання веб-сайту %1',
    'backup__domain_restore_progress' => 'Хід відновлення сайту %1',
    'backup__domain_backup_progress_elapsed_time' => 'Витрачений час: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Витрачений час: %1',
    'backup__domain_restore_session_complete' => 'Домен %1 відновлюється.',
    'backup__domain_restore_session_complete_message' => 'Домен %1 був відновлений.',
    'backup__domain_backup_file_delete' => 'Такі резервні копії файлів будуть видалені:',
    'backup__domain_backup_file_for_remove' => 'Виберіть резервні копії файлів, які ви бажаєте видалити',
    'backup__backup_overwrite_file_confirm' => 'Підтвердження заміни',
    'backup__backup_overwrite_file_confirm_text' => 'Резервна копія файлів з ім\'ям "%1" вже існує. Бажаєте його замінити?',
    'backup__backup_confirm_overwrite' => 'Підтвердіть заміну файлу',
    'backup__backup_overwrite_legeng' => 'Замінити',
    'backup__backup_not_contain_domain' => 'Резервне копіювання файлів не містить інформації про домен %1',
    'backup__backup_not_contain_client' => 'Резервна копія файлу не містить інформації про обліковий запис замовника %1',
    'backup__backup_client_info' => "Провести резервне копіювання налаштувань замовника та даних облікового запису",
    'backup__client_backup_progress' => 'Перебіг виконання резервного копіювання облікового запису замовника %1',
    'backup__client_session_complete' => 'Виконано резервне копіювання облікового запису замовника %1',
    'backup__client_backup_file_info' => 'Інформація щодо резервної копії файла',
    'backup__restore_client_info' => "Відновлення налаштувань замовника і даних облікового запису",
    'backup__client_session_restore' => 'Відновлення облікового запису замовника %1',
    'backup__client_db_server_map' => 'Мапування серверів баз даних',
    'backup__domain_db_server_map' => 'Мапування серверів баз даних',
    'backup__client_restore_session_complete_message' => 'Обліковий запис замовника %1 було відновлено.',
    'backup__client_restore_session_complete' => 'Обліковий запис замовника %1 було відновлено.',
    'backup__restore_select_some' => 'Будь ласка, виберіть об\'єкти, які ви хочете відновити.',
    'backup__client_restore_progress' => 'Відновлення перебігу виконання для облікового запису замовника %1',
    'backup__new_backup' => 'Створення нової резервної копії',
    'backup__done' => 'Виконано:',
    'backup__done_domains' => '%1 замовник(и) з %2',
    'backup__done_clients' => '%1 замовник(и) з %2',
    'backup__remaining' => 'Залишилося:',
    'backup__remaining_domains' => '%1 домен(и)',
    'backup__remaining_clients' => '%1 замовник(и)',
    'backup__overall_backup_progress' => 'Загальний перебіг виконання резервного копіювання',
    'backup__comment_n_a' => 'н/д',
    'backup__command_ignore' => 'Команда "%1" ігнорується',
    'backup__no_objects' => 'немає об\'єктів для резервного копіювання',
    'backup__cli_warning_not_enough_ip' => 'ПОПЕРЕДЖЕННЯ: не вистачає IP-адрес для виконання відображення IP-адрес за замовчуванням:',
    'backup__local_repository' => "Сховище Plesk",
    'backup__ftp_repository' => 'Сховище FTP',
    'backup__ftp_login' => 'Ім\'я користувача',
    'backup__ftp_password' => 'Пароль',
    'backup__ftp_account_settings' => 'Налаштування облікового запису FTP',
    'backup__ftp_account_preferences' => 'Налаштування облікового запису FTP',
    'backup__repository_not_exist' => 'Каталог не існує',
    'backup__repository_not_readable' => 'Вказаний каталог не читається',
    'backup__ftp_repository_not_configure' => 'Щоб використовувати сховище резервного копіювання FTP, <a href="%1">вкажіть обліковий запис FTP</a>спочатку.',
    'backup__ftp_repository_list_not_configure' => 'Налаштування облікового запису не вказано',
    'backup__repository_list_unable_listing' => 'Не вдалося отримати список файлів',
    'backup__ftp_repository_unable_listing' => 'Не вдалося отримати список каталогів "%1":',
    'backup__repository_legend' => 'Сховище резервних файлів',
    'backup__store_in_repository' => 'Зберігайте файли в',
    'backup__local_repository_lable' => 'Локальне сховище',
    'backup__ftp_repository_lable' => 'Сховище FTP',
    'backup__ftp_repository_not_configure_hint' => '(налаштування облікового запису не вказані)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(обліковий запис FTP не вказаний або не підтримується)',
    'backup__other_user_process_modified' => 'Інший користувач зупинив резервне копіювання або процес міграції.',
    'backup__another_user_exist' => 'Операцію, що триває, було ініційовано іншим користувачем Plesk. Цей користувач все ще знаходиться в системі Plesk.',
    'backup__ftp_repository_wait' => 'Будь ласка, зачекайте при отриманні інформації про сховище FTP',
    'backup__ftp_write_test_failed' => 'Не вдалося записати дані тестування до облікового запису FTP %1:',
    'backup__ftp_storage' => 'Сховище FTP(S)',
    'bt_upload_to_repository' => 'Додати файли до локального сховища',
    'bt_new_restore' => "Відновити",
    'bt_backup_schedule' => "Резервне копіювання за план-графіком",
    'backup_exist_backups' => "Існуючі резервні копії файлів",
    'backup_dialog__page_title' => "Створення резервної копії файлу",
    'backup_dialog__please_wait' => "Зараз розпочнеться процес створення резервної копії. Це може зайняти деякий час. Зачекайте, будь ласка...",
    'backup_conf__page_title' => 'Налаштування резервного копіювання',
    'bt_accept' => "Прийняти",
    'bt_access' => "Доступ",
    'bt_action_log' => "Журнал операцій",
    'bt_add' => "Додати",
    'bt_add_client' => "Призначити користувачам",
    'bt_database_server_add' => 'Додати сервер бази даних',
    'bt_add_services' => "Додати сервіси",
    'bt_anonftp_stats' => "Статистика анонімного FTP",
    'bt_anonymous_ftp' => "Анонімний FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Приєднати",
    'bt_autoinstaller' => 'Модуль оновлення',
    'bt_auto-updates' => 'Модуль оновлення',
    'bt_back' => "<< Назад",
    'bt_backup' => "Створити резервну копію",
    'bt_backup_configure' => "Налаштування резервного копіювання",
    'bt_buy_certs' => "Придбати сертифікати",
    'bt_card' => "Карта",
    'bt_cert' => "Сертифікат",
    'bt_certificates' => "Сертифікати",
    'bt_change_passwd' => "Змінити пароль",
    'bt_clear' => "Очистити",
    'bt_client_templates' => "Шаблони замовника",
    'bt_clients' => "Замовники",
    'bt_codepage_change' => 'Змінити кодування',
    'bt_comp_info' => "Управління компонентами",
    'bt_configure_maillists' => "Встановити Mailman",
    'bt_configure' => 'Конфігурувати',
    'bt_copy' => "Копіювати",
    'bt_copy_move' => "Копіювати/перемістити",
    'bt_create' => "Створити",
    'bt_create_account' => "Створити новий обліковий запис",
    'bt_create_dir' => "Додати каталог",
    'bt_create_file' => "Додати файл",
    'bt_count_size' => "Вирахувати розмір",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Планувальник завдань",
    'bt_custom_button_new' => "Додати кнопку",
    'bt_custom_buttons' => "Користувацькі кнопки",
    'bt_customize' => "Персоналізувати",
    'bt_databases' => "Бази даних",
    'bt_database_servers' => 'Сервери бази даних',
    'bt_sqlservers' => "Сервери бази даних",
    'bt_db_usr_new' => "Додати нового користувача бази даних",
    'bt_db_new' => "Додати нову базу даних",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Встановити за замовчуванням для DB Webadmin",
    'bt_decline' => "Відхилити",
    'bt_default' => "За замовчуванням",
    'bt_defaultcomponents' => "Сервіси третьої сторони",
    'bt_defaults' => "Налаштування за замовчуванням",
    'bt_delete' => "Видалити",
    'bt_directories' => "Захищені каталоги",
    'bt_disable' => "Вимкнути",
    'bt_dns_zone_sync' => 'Застосувати зміни шаблону DNS',
    'bt_dnsrecord_add' => 'Додати запис',
    'bt_do_backup' => "Зробити резервну копію",
    'bt_do_restore' => "Відновити",
    'bt_do_upload' => "Вивантажити",
    'bt_domain_aliases' => "Псевдоніми доменів",
    'bt_domain_templates' => "Шаблони доменів",
    'bt_domain_user' => "Адміністратор домену",
    'bt_domain_user_passwd' => "Пароль адміністратора домену",
    'bt_domains' => "Домени",
    'bt_domain_alias_add' => 'Додати псевдонім домену',
    'bt_download' => "Завантажити",
    'bt_edit' => "Редагувати",
    'bt_enable' => "Увімкнути",
    'bt_export' => 'Експортувати',
    'bt_extras' => "Додаткові",
    'bt_finish' => "Завершити",
    'bt_ftp_account' => "Параметри облікового запису FTP",
    'bt_forget_password' => "Забули пароль?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Статистика FTP",
    'bt_get_password' => "Отримати пароль",
    'bt_global_changes' => "Змінити",
    'bt_help' => "Довідка",
    'bt_hide_aliases' => "Сховати псевдоніми",
    'bt_hide_toolbar' => 'Приховати панель інструментів',
    'bt_hide_subdomains' => "Приховати субдомени",
    'bt_hide_domainaliases' => "Сховати псевдоніми доменів",
    'bt_home' => "Головна сторінка",
    'bt_hosting' => "Хостинг",
    'bt_icf' => 'Мережевий екран',
    'bt_install' => "Встановити",
    'bt_ip_aliasing' => "IP-адреси",
    'bt_ip_add' => "Додати IP-адресу",
    'bt_ip_pool' => "Пул IP-адрес",
    'bt_key_info' => "Інформація про ліцензію",
    'bt_key_buyonline_addons' => 'Замовити надбудови Plesk',
    'bt_key_buyonline_upgrades' => 'Замовити оновлення Plesk',
    'bt_key_buyonline_new' => 'Замовити новий ключ',
    'bt_limits' => "Обмеження",
    'bt_locale_add' => 'Додати локаль',
    'bt_locales' => 'Локалі',
    'bt_log_manager' => "Менеджер журналів",
    'bt_login' => "Увійти",
    'bt_logo' => "Брендинг",
    'bt_logo_send_link' => "Приєднати посилання",
    'bt_logo_send_logo' => "Приєднати логотип",
    'bt_logout' => "Вийти",
    'bt_logrotation' => "Ротація логів",
    'bt_mail' => "Пошта",
    'bt_mail_alias_add' => "Додати нову альтернативну адресу поштової скриньки",
    'bt_mail_aliases' => "Альтернативні адреси поштових скриньок",
    'bt_mail_group_add' => "Додати нового члена",
    'bt_mail_groups' => "Групи",
    'bt_mail_name_add' => "Додати новий поштовий обліковий запис",
    'bt_mail_preferences' => "Налаштування",
    'bt_mail_group' => "Поштова група",
    'bt_mail_mailbox' => "Поштова скринька",
    'bt_mail_redirect' => "Переадресатор",
    'bt_mail_resp_add' => "Додати новий автовідповідач",
    'bt_mail_resp_attach_add' => "Додати нове вкладення",
    'bt_mail_resp_files' => "Вкладені файли",
    'bt_mail_responders' => "Автовідповіді",
    'bt_mail_spamfilter' => "Спам-фільтр",
    'bt_mail_webmail' => "Поштовий веб-інтерфейс",
    'bt_maillist_new' => "Додати новий список поштової розсилки",
    'bt_maillists' => "Переліки поштових розсилок",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Створити резервну копію",
    'bt_manage' => "Управління",
    'bt_master' => "Майстер",
    'bt_migrate' => 'Мігрувати',
    'bt_modules_add' => 'Додати розширення',
    'bt_modules_manage' => 'Управління розширеннями',
    'bt_move' => "Перемістити",
    'bt_mimetypes' => 'Типи MIME',
    'bt_mimetype_new' => 'Додати тип МІМЕ',
    'bt_new_client' => "Додати обліковий запис замовника",
    'bt_new_domain' => "Додати домен",
    'bt_next' => "Далі >>",
    'bt_next_page' => "Наступний",
    'bt_network_add' => "Додати мережу",
    'bt_notifications' => "Сповіщення",
    'bt_off' => "Вимкнути",
    'bt_on' => "Увімкнути",
    'bt_on_off' => "Вимкнути/Увімкнути",
    'bt_pd_new' => "Додати захищений каталог",
    'bt_pd_user_new' => "Додати користувача",
    'bt_performance' => 'Продуктивність',
    'bt_permissions' => "Права доступу",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Налаштування",
    'bt_prev_page' => "Попередній перегляд",
    'bt_preview' => 'Попередній перегляд сайту',
    'bt_print' => "Друкувати",
    'bt_reboot' => "Перезавантажити",
    'bt_reload' => "Перезавантажити",
    'bt_refresh' => "Оновити",
    'bt_register' => "Зареєструвати",
    'bt_remove' => "Видалити",
    'bt_enable_selected' => 'Увімкнути',
    'bt_disable_selected' => 'Вимкнути',
    'bt_repair_ip' => "Виправити IP",
    'bt_report' => "Звіт",
    'bt_report_new' => "Додати новий шаблон",
    'bt_reset' => "Скинути",
    'bt_restart_services' => "Управління сервісами",
    'bt_save' => "Зберегти",
    'bt_send_by_email' => "Надіслати електронною поштою",
    'bt_send_file' => "Надіслати файл",
    'bt_send_mail' => "Надіслати листа",
    'bt_send_passwd' => "Надіслати пароль",
    'bt_send_text' => "Надіслати текст",
    'bt_server' => "Сервер",
    'bt_server_add' => "Додати новий сервер",
    'bt_server_preferences' => "Налаштування сервера",
    'bt_servers_list' => "Сервери",
    'bt_sessions' => "Сеанси",
    'bt_set' => "Встановити",
    'bt_set_as_default' => "Встановити за замовчуванням",
    'bt_setup' => 'Установити',
    'bt_show_aliases' => "Показати псевдоніми",
    'bt_show_subdomains' => "Показати субдомени",
    'bt_show_domainaliases' => "Показати псевдоніми доменів",
    'bt_shutdown' => "Завершити",
    'bt_site_apppkgs' => "Сховище застосунків",
    'bt_site_apppool' => "Пул застосунків",
    'bt_application-pool' => "Веб-застосунки",
    'bt_site_apps' => "Веб-застосунки",
    'bt_site_app_add' => "Встановити застосунок",
    'bt_site_builder' => "Підтримка Presence Builder",
    'bt_skeleton' => 'Шаблон віртуального хосту',
    'bt_skins' => 'Зовнішня оболонка',
    'bt_skin_add' => 'Додати зовнішню оболонку',
    'bt_skin_manual' => 'Посилання на користувацькі зовнішні оболонки Plesk', // not used
    'bt_skin_download' => 'Завантажити зовнішню оболонку',
    'bt_skin_replace' => 'Оновити  зовнішню оболонку',
    'bt_skip' => 'Пропустити',
    'bt_spamassassin' => "Спам-фільтр",
    'bt_spamassassin_train' => "Навчальний",
    'bt_spamfilter' => "Спам-фільтр",
    'bt_start' => "Запустити",
    'bt_stop' => "Зупинити",
    'bt_recycle' => "Повторити",
    'bt_statistics' => "Статистика",
    'bt_subdomain_new' => "Додати новий субдомен",
    'bt_subdomains' => "Субдомени",
    'bt_submit' => "Підтвердити",
    'bt_summary_report' => "Зведений звіт",
    'bt_support' => "Підтримка",
    'bt_switch' => "Переключити",
    'bt_system_time' => "Системний час",
    'bt_task_new' => "Додати завдання",
    'bt_dom_tmpl_add' => 'Додати новий шаблон домену',
    'bt_cl_tmpl_add' => 'Додати шаблон замовника',
    'bt_cron_backup' => 'Параметри запланованого резервного копіювання',
    'bt_test' => "Перевірити з’єднання",
    'bt_text' => "Текст",
    'bt_touch' => "Змінити мітку часу",
    'bt_traffic' => "Трафік",
    'bt_traffic_history' => "Історія трафіку",
    'bt_update' => "Оновлення",
    'bt_upload' => "Вивантажити",
    'bt_upload_from_ftp' => "Вивантаження FTP",
    'bt_virtualdirs' => 'Віртуальні каталоги',
    'bt_virtualdir_new' => 'Додати новий віртуальний каталог',
    'bt_virtualdir_add' => 'Додати новий віртуальний каталог',
    'bt_web_app_new' => "Встановити Java-застосунок",
    'bt_web_stats' => "Веб-статистика",
    'bt_web_stats_ssl' => "Веб-статистика SSL/TLS",
    'bt_web_user_add' => "Додати нового веб-користувача",
    'bt_web_users' => "Веб-користувачі",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Переглянути повний список змін",
    'cert_add__unable_set_ca_cert' => "Неможливо установити сертифікат центру сертифікації: %1",
    'cert_add__unable_set_cert' => "Неможливо установити сертифікат: %1",
    'cert_add__unable_set_private_key' => "Неможливо установити персональний ключ: %1",
    'certificates_list__certificate_used_as_default' => "Один з сертифікатів, які ви збираєтесь видалити, використовується в якості усталеного сертифіката.",
    'certificates_list__certificates_assigned_on_ip' => "Один або декілька сертифікатів призначені IP-адресам/доменам.",
    'ch_pass__admin_pass' => "Зміна паролю адміністратора",
    'ch_pass__old_pass' => "Старий пароль",
    'ch_pass__pass_confirm' => "Підтвердити",
    'ch_pass__unable_change_admin_pass' => "Не можу змінити пароль адміністратора: %1",
    'check_mail_cycle__aliases' => "Виявлене зациклення пошти, адреса електронної пошти \"%1\" є у списку альтернативних імен цього поштового облікового запису.",
    'check_mail_cycle__autoresponders' => "Виявлено періодичне повторювання електронної пошти, адреса \"%1\" міститься в автоматичній відповіді цього облікового запису електронної пошти.",
    'check_mail_cycle__mail_groups' => "Виявлене зациклення пошти, адреса електронної пошти \"%1\" є у поштовій групі цього поштового облікового запису.",
    'check_mail_cycle__mail_name' => "Виявлене зациклення пошти, адреса електронної пошти \"%1\" співпадає з цим поштовим обліковим записом.",
    'check_mail_cycle__redirect' => "Виявлене зациклення пошти, адреса \"%1\" співпадає з переадресатором цього облікового запису електронної пошти.",
    'check_mail_dup__redirect' => "Виявлене дублювання переадресації, адреса \"%1\" співпадє з адресою переадресації цього поштового облікового запису.",
    'check_mail_dup__mail_groups' => "Виявлено дублювання переадресації, адреса \"%1\" є у поштовій групі цього поштового облікового запису.",
    'check_maillist_cycle__admin' => "Виявлене зациклення пошти, адреса електронної пошти адміністратора \"%1\" співпадає з адресою у списку поштової розсилки.",
    'check_maillist_cycle__member' => "Виявлене зациклення пошти, адреса електронної пошти \"%1\" співпадає з адресою у списку поштової розсилки.",
    'chk_js__enter_login_and_passwd' => "Введіть ім’я користувача та пароль.",
    'chk_js__enter_login_name' => "Введіть ім’я користувача.",
    'chk_js__enter_passwd' => "Введіть пароль.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Деталі облікового запису %1",
    'cl_limits__cl' => "Обмеження замовника %1",
    'cl_logo__setup_logo_pref' => "Встановити властивості логотипу для замовника %1",
    'cl_new__enter_new_cl_data' => "Введіть інформацію про нового замовника",
    'cl_new__unable_to_sent_notification' => 'Обліковий запис користувача було створено, однак, відправити повідомлення замовнику не вдалося: %1',
    'cl_perm__all_ip' => "Усі доступні IP",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Всі облікові записи хостингу з доступом через IP-адресу для замовників будуть переведені в режим доступу за ім'ям.",
    'cl_perm__allow_client_create_domain' => "Поля, які ви намагаєтесь вибрати, доступні лише для замовників, яким дозволено створювати домени.",
    'cl_perm__allow_create_nb_w_ip' => "Замовник може створити хостинг з доступом за ім'ям, використовуючи %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Дозволити створення облікових записів хостингу з доступом по IP",
    'cl_perm__available_ips' => "Доступні IP",
    'cl_perm__change_limits' => "Регулювання лімітів",
    'cl_perm__cl_disk_space' => "Усього доступно дискового простору",
    'cl_perm__cl_expiration' => "Строк дії облікового запису замовника",
    'cl_perm__cl_max_box' => "Поштові скриньки",
    'cl_perm__cl_max_db' => "Бази даних",
    'cl_perm__cl_max_dom' => "Домени",
    'cl_perm__cl_max_maillists' => "Переліки поштових розсилок",
    'cl_perm__cl_max_subdom' => "Субдомени",
    'cl_perm__cl_max_traffic' => "Усього доступно трафіку",
    'cl_perm__cl_max_wu' => "Веб-користувачі",
    'cl_perm__cl_mbox_quota' => "Максимальний розмір повідомлення для цього облікового запису користувача",
    'cl_perm__current_maximum_exp_date' => "Поточне максимальне значення строку дії домену складає %1; запитано %2.",
    'cl_perm__current_maximum_mailbox_quota' => "В даний час визначається обмеження на обсяг дискового простору, виділеного для житлових поштових скриньок під цим обліковим записом користувача %1; запитано %2",
    'cl_perm__current_total_requested' => "Поточне загальне значення лімітів домену для %1 складає %2; запитано %3.",
    'cl_perm__current_total_requested_dom' => "Поточна кількість %1, що належить цьому замовнику, складає %2; запитано %3.",
    'cl_perm__disk_space' => "максимальна кількість дискового простору",
    'cl_perm__dashboard_stdgui' => 'Інтерфейс користувача',
    'cl_perm__dashboard' => 'Вид домашньої сторінки',
    'cl_perm__stdgui' => 'Стандартний вид',
    'cl_perm__manage_dashboard' => 'Управління головною сторінкою',
    'cl_perm__dashboard_and_stdgui' => 'Дозволено вид головної сторінки та стандартний вид',
    'cl_perm__dashboard_only' => 'Доступний лише вид головної сторінки',
    'cl_perm__stdgui_only' => 'Дозволений лише стандартний вид',
    'cl_perm__edit_cl' => "Права доступу замовника %1",
    'cl_perm__exp_date_exceeded' => "Строк дії, який ви намагаєтесь встановити, перевищує ліміт вказаний для індивідуальних доменів пов’язаних з цим замовником.",
    'cl_perm__invalid_value' => "Невірне значення, дозволені лише цифри.",
    'cl_perm__limit_disk_space' => "%1 ліміт на загальний об’єм дискового простору",
    'cl_perm__limit_expiration' => "%1 обмеження на строк дії облікового запису замовника",
    'cl_perm__limit_max_box' => "%1 ліміт на максимальну кількість поштових скриньок",
    'cl_perm__limit_max_db' => "%1 ліміт на максимальну кількість баз даних",
    'cl_perm__limit_max_dom' => "%1 ліміт на максимальну кількість доменів",
    'cl_perm__limit_max_maillists' => "%1 ліміт на максимальну кількість поштових списків",
    'cl_perm__limit_max_subdom' => "%1 ліміт на максимальну кількість субдоменів",
    'cl_perm__limit_max_traffic' => "%1 ліміт на загальну кількість трафіку",
    'cl_perm__limit_max_wu' => "%1 ліміт на максимальну кількість веб-користувачів",
    'cl_perm__limit_mbox_quota' => "%1 встановити квоту поштових скриньок",
    'cl_perm__limits_exceeded' => "Один, або кілька лімітів, що ви намагаєтесь встановити вже перевищені лімітами, вказаними для індивідуальних доменів, що належать цьому клієнту.\nЗагаьний ліміт для клієнта має бути рівним, чи перевищувати загальну сумму лімітів домену, визначених для цього обліковому запису клієнта.",
    'cl_perm__mailbox_quota_exceeded' => "Ліміт на виділений дисковий простір для поштових скриньок, який ви намагаєтеся встановити, перевищує ліміт, вказаний на рівні індивідуальних доменів, пов’язаних з обліковим записом замовника.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Ліміт на виділений дисковий простір для поштових скриньок, який ви намагаєтеся встановити, перевищує обмеження, встановлені на рівні серверу.",
    'cl_perm__make_dumps' => "Провести резервне копіювання та відновлення даних",

    'cl_perm__max_box' => "максимальна кількість поштових скриньок",
    'cl_perm__max_db' => "максимальна кількість баз даних",
    'cl_perm__max_dom' => "домени",
    'cl_perm__max_maillists' => "максимальна кількість поштових списків",
    'cl_perm__max_subdom' => "субдомени",
    'cl_perm__max_traffic' => "максимальна кількість трафіку",
    'cl_perm__max_wu' => "максимальна кількість веб-користувачів",
    'cl_perm__max_dom_aliases' => "псевдоніми домену",
    'cl_perm__mbox_quota' => "квота поштової скриньки",
    'cl_perm__not_allow_create_nb_hst' => "Замовник не може створити хостинг з доступом за ім'ям.",
    'cl_perm__this_ip_used_vrt_hst' => "IP-адреса використовується віртуальним хостингом. \nДля видалення цієї IP-адреси, видаліть сервіс хостингу, або змініть його тип на Name-based.",
    'cl_perm__unable_off_ipb_creating' => "Замовник вже встановив сервіс хостингу на основі IP. Щоб деактивувати замовнику цю функцію, зніміть прапорець з поля \"Domain creation\" або видаліть всі облікові записи хостингу на основі IP.",
    'cl_perm__unable_off_nb_creating' => "Замовник вже встановив послугу хостингу за іменем. Щоб деактивувати замовнику цю функцію, зніміть прапорець з поля \"Domain creation\" або видаліть всі облікові записи хостингу за іменем.",
    'cl_perm__unable_set_domain_limit' => "Неможливо обмежити максимальну кількість доменів: замовник вже має %1 доменів",
    'cl_perm__unable_update_client_limitations' => "Неможливо модифікувати обмеження облікового запису замовника: %1",
    'cl_pref__edit_cl' => "Параметри замовника %1",
    'class_anonftp__create_ftp_domain' => "Немає віртуального FTP-домену для даного dom_id, спробуйте спочатку створити його.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Ліміт дискового простору, який ви намагаєтеся встановити (%1), не має перевищувати загальний ліміт дискового простору, встановлений на рівні домену (%2).",
    'class_anonftp__invalid_input_only_digits' => "Вказано невірне значення, доступні лише цифри.",
    'class_anonftp__unable_change_ownerships' => "Не можу змінити власника, чи доступ до файлу квоти: %1",
    'class_anonftp__unable_copy_quota_file' => "Не можу скопіювати файл квоти: %1",
    'class_anonftp__unable_get_disk_usage' => "Не можу отримати інформацію щодо використання диску для вихідного каталогу: %1",
    'class_anonftp__unable_parse_quota_file' => "Не можу проаналізувати файл квоти.",
    'class_anonftp__unable_read_quota_file' => "Не можу прочитати файл квоти: %1",
    'class_anonftp__unable_update_quota' => "Не можу оновити квоту: файли у вихідному каталозі використовують %1 Кб дискового простору, що перевищує нові значення квоти.",
    'class_anonftp__unable_write_temp_file' => "Не можу записати в тимчасовий файл: %1",
    'class_bsdomain__warn_max_date__' => "Строк дії був налаштований на %1",
    'class_cList__empty' => "Немає вибраних.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Немає збігів для <b>\"%1\"</b> in %2 (%3 of %4).",
    'class_cList__search_result' => "Шукати результати для <b>\"%1\"</b> in %2 (%3 of %4).",
    'class_client__client_creation_notification' => "Сповіщення про створення замовника.",
    'class_client__client_with_contact_name_already_exists' => "Замовник з ім’ям %1 вже існує.",
    'class_client__disk_space' => "Дисковий простір",
    'class_client__invalid_max_dom' => "Невірне число значення доменів, дозволені лише цифри.",
    'class_client__limit_exceed' => "Запитувана кількість %1 не може бути виділена, тому що це перевищуватиме обсяг, виділений обліковому запису (%3) замовника %2. Якщо ви бажаєте виділити більше ресурсів, перейдіть в розділ Замовники > ім'я замовника > Обмеження і змініть виділений обсяг відповідно до ваших потреб. Тоді поверніться до цього екрану і спробуйте змінити виділений обсяг знову.",
    'class_client__limit_exceed_unlimited' => "Якщо ви бажаєте виділити необмежену кількість ресурсів (%1), ви повинні спочатку перейти до розділу Замовники > ім'я замовника > Обмеження і вибрати прапорець Необмежений, що відповідає потрібному типу ресурсу. Потім поверніться до цього екрану і спробуйте змінити виділений обсяг знову.",
    'class_client__max_box' => "Поштові скриньки",
    'class_client__max_db' => "Бази даних",
    'class_client__max_maillists' => "Переліки поштових розсилок",
    'class_client__max_subdom' => "Субдомени",
    'class_client__max_traffic' => "Максимальний трафік",
    'class_client__max_wu' => "Веб-користувачі",
    'class_client__max_dom_aliases' => "Псевдоніми домена",
    'class_client__mbox_quota' => "Квота поштової скриньки",
    'class_client__unable_define_cl_status' => "Неможливо визначити статус облікового запису замовника: %1",
    'class_client__unable_define_inactive_dom' => "Неможливо визначити неактивні домени: %1.",
    'class_client__unable_del_ip' => "Неможливо видалити IP: %1",
    'class_db__db_name_not_set' => "Ім’я бази даних не було встановлено.",
    'class_db__db_not_exist_for_curr_dom' => "Не існує бази даних для цього домену.",
    'class_db__invalid_db_or_dom_name' => "ID цього домену, чи бази даних невірне, або не було встановлено ім’я бази даних.",
    'class_db__invalid_pass' => "Невірний пароль.",
    'class_db__mailgrp_member_exist' => "Член цієї поштової групи вже існує.",
    'class_db__access_hosts_notsupport' => 'Налаштування доступу хостів не підтримується для цього типу бази даних',
    'class_db__unable_add' => 'Неможливо додати запис доступу хосту: %1',
    'class_db__unable_del' => 'Неможливо видалити запис доступу хосту: %1',
    'class_db__inc_user_not_exist' => 'Користувач бази даних "%1" не існує',
    'class_db__inc_access_record_exist' => 'Цей запис доступу вже існує',
    'class_db__inc_access_record_not_exist' => 'Наданий запис доступу не існує',
    'class_db__inc_unable_del_last_record' => 'Неможливо видалити останній запис доступу хосту',
    'class_domtmpleditform__dns_master' => "Первинний",
    'class_domtmpleditform__dns_slave' => "Вторинний",
    'class_domtmpleditform__dns_type' => "Тип доменної зони DNS",
    'clienttrafficlist_header' => "Трафік домену",
    'clienttrafficlist_header_of_client__' => "Трафік домену замовника %1",
    'cmd_dns__a_dns_record_already_exist' => "Цей запис буде конфліктувати із записом типу \"А\" зони.",
    'cmd_dns__domain_last_ns' => 'Не вдалося видалити останній запис СІ СДІ для домену.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Канонічне ім'я домену недійсне.",
    'cmd_dns__cname_dns_record_already_exist' => "Такий CNAME DNS запис вже існує.",
    'cmd_dns__cname_in_rr_combination' => 'У DNS-зоні присутня невірна комбінація DNS-записів',
    'cmd_dns__cname_coexist_with_data' => 'Запис CNAME DNS-зони не може співіснувати з іншими DNS-записами в одній зоні.',
    'cmd_dns__dns_record_type_is_invalid' => "Невірний тип DNS-запису.",
    'cmd_dns__ext_host_is_not_resolved' => "Канонічне ім'я %1 не розділюється на запис A або AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Неможливо додати %1 запис до зони %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Некоректне ім’я поштового шлюза.",
    'cmd_dns__mx_priority_is_invalid' => "Невірний MX пріоритет",
    'cmd_dns__name_server_is_invalid' => "Невірне ім’я серверу.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Значення маски мережі повинно бути 24, 16 або 8.",
    'cmd_dns__this_dns_record_already_exists' => "Такий DNS запис вже існує.",
    'cmd_dns__unable_add_record' => "Неможливо додати запис '%1': %2",
    'cmd_dns__unable_add_a_record' => "Неможливо додати А запис: %1",
    'cmd_dns__unable_add_cname_record' => "Неможливо додати CNAME запис: %1",
    'cmd_dns__unable_add_dns_record' => "Неможливо додати DNS запис: %1",
    'cmd_dns__unable_add_ext_ns_record' => "Неможливо додати EXT_NS запис: %1",
    'cmd_dns__unable_add_ns_record' => "Неможливо додати NS запис: %1",
    'cmd_dns__unable_add_ptr_record' => "Неможливо додати PTR запис: %1",
    'cmd_dns__unable_add_txt_record' => "Неможливо додати TXT запис: %1",
    'cmd_dns__unable_create_dns_zone' => "Неможливо створити DNS зону %1",
    'cmd_dns__unable_define_dns_record' => "Неможливо визначити DNS запис %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Неможливо отримати статус DNS зони на замовчуванням: %1",
    'cmd_dns__unable_insert_a_record' => "Неможливо вставити А запис: %1",
    'cmd_dns__unable_insert_mx_record' => "Неможливо вставити MX запис: %1",
    'cmd_dns__unable_insert_ns_record' => "Неможливо вставити NS запис: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Неможливо налаштувати статус DNS зони: %1",
    'cmd_domains__dom_already_exists' => "Домен %1 вже існує.",
    'cmd_domains__dns_record_already_exists' => "Неможливо створити домен %1, оскільки запис DNS, що вказує на хост %1, вже існує.",
    'cmd_domains__dom_already_exists1' => "Цей домен має %2 субдомени. Домен %1 вже існує.",
    'cmd_domains__dom_already_exists2' => "субдомен %1 вже існує.",
    'cmd_domains__dalias_already_exists' => "Цей псевдонім вже існує.",
    'cmd_domains__domain_alias_already_exists' => 'Псевдонім домену з таким ім’ям вже існує.',
    'cmd_domains__unable_del_mail_for_dom' => "Неможливо видалити служби електронної пошти для домену: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Неможливо видалити анонімний обліковий запис FTP для домену: %1",
    'cmd_domains__unable_update_dom_param' => "Неможливо оновити параметри домену: %1.",
    'cmd_domains__unable_rename_client_exist' => "користувацьке ім’я адміністратору домену вже використовується.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Тип хостингу не фізичний.",
    'cmd_hosting__unable_create_user' => "Неможливо створити користувача %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Неможливо визначити ІР-адресу для віртуальних хостів за іменем: %1",
    'cmd_hosting__unable_del_old_hst' => "Неможливо видалити попередньо встановлений хостинг: %1",
    'cmd_hosting__unable_del_protected_directory' => "Неможливо видалити захищений каталог: %1.",
    'cmd_hosting__unable_del_web_user' => "Неможливо видалити веб-користувача: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Неможливо створити або оновити Віртуальний Хост: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Неможливо встановити хостинг переадресації фреймів.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Неможливо відновити файл конфігурації ProFTPD: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Неможливо налаштувати SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Неможливо видалити захист з SSL/TLS каталогу: %1",
    'cmd_hosting__unable_update_dest_url' => "Неможливо оновити цільовий URL %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Неможливо оновити DNS зону для домену: не вдалося запустити утиліту.",
    'cmd_hosting__unable_update_ftp_passwd' => "Не вдалося оновити пароль FTP %1.",
    'cmd_hosting__unable_update_user' => "Не вдалося оновити користувача %2: %1",
    'cmd_hosting__unknown_hst_type' => "Невідомий тип хостингу.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Ви не маєте прав на припинення послуг хостингу.",
    'cmd_mail__autoresponder__not_configured' => "Автоматична відповідь для цього облікового запису електронної пошти не налаштована",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Адреса %1 вже використовується для відправки електронної пошти.",
    'cmd_mail__alias_already_exists' => "псевдонім вже існує.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID автоматичної відповіді і ID облікового запису електронної пошти не співпадають.",
    'cmd_mail__autoresp_id_is_undefined' => "ID автоматичної відповіді не визначено.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Псевдонім поштової пошти з таким ім’ям вже існує для поштового облікового запису %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Обліковий запис електронної пошти %1 вже підписаний на цей список розсилки повідомлень.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Обліковий запис електронної пошти %1 вже існує на цьому домені.",
    'cmd_mail__mail_name_not_exist' => "Обліковий запис електронної пошти не існує.",
    'cmd_mail__mail_name_passwd_part' => "Пароль не повинен містити назву облікового запису електронної пошти.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Список розсилки повідомлень %1 вже існує на цьому домені.",
    'cmd_mail__mailname_already_exist_in_mg' => "Обліковий запис електронної пошти %1 вже знаходиться в групі електронної пошти.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Обліковий запис електронної пошти %1 вже існує на цьому домені.",
    'cmd_mail__mailname_already_exists' => "Обліковий запис електронної пошти вже існує.",
    'cmd_mail__mailname_is_invalid' => "Недійсне ім’я облікового запису електронної пошти %1.",
    'cmd_mail__mailname_unable_update' => "Неможливо оновити властивості облікового запису електронної пошти:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Для цього домену було досягнуто максимальну кількість автоматичних відповідей.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Для цього домену було досягнуто максимальну кількість груп електронної пошти.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Була досягнута максимальна кількість переадресаторів для цього домену.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Було досягнуто максимальну кількість поштових скриньок.",
    'cmd_mail__no_members_specified' => "не вказано жодного члену.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Пароль занадто простий, будь ласка, виберіть інший.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Адреса електронної пошти вже використовується.",
    'cmd_mail__unable_define_autoresp_id' => "Неможливо визначити ID %1 автоматичної відповіді.",
    'cmd_mail__unable_update_mail_for_dom' => "Не вдалося змінити налаштування сервісів електронної пошти для домену %1",
    'cmd_mail__unable_del_mail_for_dom' => "Неможливо видалити сервіс електронної пошти з домену %1.",
    'cmd_mail__unable_del_mail_redirection' => "Не вдалося видалити сервіс з переадресації пошти %1.",
    'cmd_mail__unable_remove_autoresp' => "Неможливо видалити автоматичні відповіді: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Неможливо видалити членів групи електронної пошти: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Не вдалося відключити поштову групу: %1",
    'cmd_mail__unable_update_mail_redirect' => "Неможливо переналаштувати сервіс переадресації електронної пошти %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Розмір оновленого файлу занадто великий.",
    'cmd_mail__additionally' => "Додатково:",
    'cmd_pd__invalid_login' => "Неправильне ім'я користувача.",
    'cmd_pd__this_user_already_exist' => "Такий користувач вже існує.",
    'cmd_pd__unable_define_hst_type' => "Неможливо визначити тип хостингу.",
    'cmd_pd__unable_upd_pd_usr' => "Неможливо оновити властивості користувача захищеного каталогу: %1.",
    'cmd_pd__user_is_undefined' => "Користувача невизначено.",
    'cmd_server__no_enough_free_disk_space' => "Недостатньо дискового простору.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "старий пароль невірний. Будь ласка, спробуйте ще раз.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "для цього домену було досягнено максимальну кількість веб-користувачів.",
    'cmd_web_usr__unable_create_user' => "неможливо створити користувача системи: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "неможливо визначити максимальну кількість веб-користувачів: %1",
    'cmd_web_usr__user_already_exists' => "користувач вже існує.",
    'cmd_web_usr__web_user_name_is_invalid' => "ім’я веб-користувача %1 недійсне.",
    'cmd_web_usr__web_user_not_exist' => "веб-користувача не існує.",
    'common_func__exec_bad_argument' => "аргумент exec не повинен містити символ одинарної лапки.",
    '__eol' => 'Переноси рядків',
    'eol__binary_file' => 'Неможливо змінити стиль розриву рядка у бінарному файлі.',
    'cp_access_admin_deny' => "Доступ до адміністратора з адреси '%1' заборонений у відповідності до політики обмежування ІР-доступу, що наразі застосовується.",
    'create_domain_warn__' => "Такі винятки було зроблено під час створення домену:",
    'create_domain__client_select' => 'Виберіть замовника для створення домену для',

    'dashboard__nav_button_name' => "Головна сторінка",
    'dalias__list_title' => 'Псевдоніми домену %1',
    'dalias__list_legend' => 'Псевдоніми домена',
    'dalias__list_header' => 'Псевдоніми домена',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Псевдонім домену',
    'dalias__list_ascii_name' => 'У форматі ASCII',
    'dalias__remove_title' => 'такі   псевдоніми домену %1 будуть вилучені:',
    'dalias__select_domain_aliases_to_remove' => 'Виберіть альтернативні домени для видалення.',
    'dalias__mail_turn_on_failed' => 'Неможливо включити послугу електронної пошти: %1',
    'dalias__web_turn_on_failed' => 'Неможливо включити веб-послугу: %1',
    'db_usr_edit__db_usr_name_old' => "Ім’я користувача старої бази даних",
    'database_server_edit_form__cannot_infer_type' => 'Неможливо визначити спосіб підключення за допомогою наданих даних. Укажіть 127.0.0.1 у якості імені хоста сервера бази даних для з’єднання через TCP/IP з наданим портом або залиште поле порту порожнім, щоб використовувати сокет Unix %1.',
    'database_server_edit_form__duplicate' => 'Сервер бази даних з цією комбінацією адреси хосту та номера порту вже зареєстровано.',
    'database_server_edit_form__host_is_invalid' => 'Указане ім’я хоста недійсне.',
    'database_server_edit_form__port_is_invalid' => 'Указаний номер порту недійсний.',
    'database_server_error__consult_admin' => 'Будь ласка, зверніться до адміністратора серверу.',
    'database_server_error__last__connection_failed' => 'Остання спроба контролювати цей сервер бази даних не вдалася через проблеми мережі.',
    'database_server_error__last__permission_denied' => 'Остання спроба контролювати цей сервер бази даних не вдалася через відсутність прав адміністратора у наданого облікового запису.',
    'database_server_error__last__credentials_not_set' => "Остання спроба з’єднання з сервером була невдалою через невірно вказане діюче користувацьке ім’я та пароль адміністратора.",
    'database_server_error__last__other_error' => 'Остання спроба контролювати цей сервер бази даних не вдалася.',
    'database_server_error__real__connection_failed' => 'З’єднання з сервером бази даних не вдалося через проблеми мережі:',
    'database_server_error__real__permission_denied' => 'З’єднання з сервером бази даних не вдалося через відсутність прав адміністратора у наданого облікового запису:',
    'database_server_error__real__duplicate_object' => 'З’єднання з сервером бази даних не вдалося через конфлікт імен:',
    'database_server_error__real__unacceptable_name' => 'З’єднання з сервером бази даних не вдалося через невірне ім’я об’єкту:',
    'database_server_error__real__unacceptable_password' => 'З’єднання з сервером бази даних не вдалося через неприйнятний пароль:',
    'database_server_error__real__credentials_not_set' => "Plesk не вдається з’єднатися з сервером бази даних через невірно вказане діюче користувацьке ім’я та пароль адміністратора.",
    'database_server_error__real__other_error' => 'Підключення до сервера бази даних не вдалося:',
    'database_server_error__test__connection_failed' => 'Тестове з’єднання із базою даних серверу не вдалося через проблеми мережі:',
    'database_server_error__test__permission_denied' => 'Тестове з’єднання з базою даних серверу не вдалося через відсутність прав адміністратора у має адміністративних привілеїв:',
    'database_server_error__test__duplicate_object' => 'Тестове з’єднання із сервером бази даних не вдалося через конфлікт імен:',
    'database_server_error__test__unacceptable_name' => 'Тестове з’єднання з базою даних серверу не вдалося через недійсне ім\'я об\'єкта:',
    'database_server_error__test__unacceptable_password' => 'Тестове з’єднання з базою даних серверу не вдалося через неприйнятний пароль:',
    'database_server_error__test__credentials_not_set' => "Тестове з’єднання з цим сервером не вдалося через невірно вказане діюче користувацьке ім’я та пароль адміністратора.",
    'database_server_error__test__other_error' => 'Помилка тестового з’єднання з базою даних серверу:',

    'db__create_new_db' => "Додати базу даних",
    'db__db_add' => "Додати нову базу даних",
    'db__db_for_dom' => "Бази даних веб-сайту %1",
    'db__db_id_undefined' => "ID бази даних невизначений.",
    'db__db_name' => "Ім’я бази даних",
    'db__db_not_exist' => "База даних не існує.",
    'db__db_type' => "Тип",
    'db__db_server' => "Сервер бази даних",
    'db_server_not_exist' => "Сервер бази даних не існує.",
    'db__db_user_not_exist' => "Користувач бази даних не існує.",
    'db__domain_not_exist' => "Домен не існує.",
    'db__enter_db_name' => "Ввести нове ім’я бази даних.",
    'db__invalid_db_id' => "Недійсний ідентифікатор бази даних.",
    'db__invalid_db_name' => "Недійсне ім’я бази даних. Ім'я бази даних повинне містити тільки символи латинського алфавіту, цифри, підкреслення або тире. Воно не може бути довше за 63 символи.",
    'db__max_db_reached_for_dom' => "Для цього домену було досягнуто обмеження за кількістю баз даних.",
    'db__max_mssql_db_reached_for_dom' => "Для цього домену було досягнуто ліміт на кількість баз даних Microsoft SQL Сервера",
    'db__postgres_not_connect_for_admin' => "Неможливо під'єднатись до PostgreSQL. Увімкніть підтримку PostgreSQL на адміністративній сторінці серверу.",
    'db__postgres_not_connect_for_client' => "Неможливо під'єднатись до PostgreSQL. Зверніться за допомогою до вашого системного адміністратора.",
    'db__remove_db_on_domain' => "Будуть видалені такі бази даних на веб-сайті %2, що належать замовнику %1:",
    'db__remove_db_on_domain_of_cl' => "такі   бази даних для домену %2, що належить клієнту %1 будуть видалені:",
    'db__remove_db_linked_resource' => 'Ця база даних знаходиться у використанні веб-застосунком. Вна може бути вилучена тільки після видалення цього веб-застосунку.',
    'db__remove_db_users' => "Будуть видалені такі   користувачі бази даних %3 на веб-сайті %2, що належать клієнту %1:",
    'db__remove_db_users_of_cl' => "Будуть видалені такі   користувачі бази даних %3 на веб-сайті %2, що належать клієнту %1:",
    'db__select_db_for_remove' => "Виберіть бази даних для видалення.",
    'db__select_db_users_for_remove' => "Виберіть користувачів бази даних для видалення.",
    'db__unable_create_db_user' => "Неможливо створити користувача бази даних: %1",
    'db__unable_define_db_name' => "Неможливо визначити ім’я бази даних: %1",
    'db__unable_define_db_user' => "Неможливо визначити користувача бази даних: %1",
    'db__unable_define_db_users' => "Неможливо визначити користувачів бази даних: %1",
    'db__unable_select_dom_name' => "Неможливо вибрати ім’я домену: %1",
    'db_edit__db_for_dom' => "Користувачі для бази даних %1 на домені %2",
    'db_edit__invalid_db_name' => "Ім’я бази даних недійсне.",
    'db_edit__no_users' => "Не існує жодного користувача із обліковими даними для цієї бази даних.",
    'db_edit__unable_define_db_usrs' => "Неможливо визначити користувача бази даних: %1",
    'db_edit__unable_select_db_usr' => "Неможливо вибрати користувача бази даних.",
    'db_edit__db_user_password_for_' => "Будь ласка, введіть пароль, щоб увійти до системи у якості користувача бази даних %1",
    'db_list__tab_title_db_type' => "Т",
    'db_usr_edit__add_db_usr' => "Додати користувача бази даних",
    'db_usr_edit__db_usr_name' => "Ім’я користувача бази даних",
    'db_usr_edit__edit_db_usr' => "Встановити облікові дані для облікового запису користувача бази даних",
    'db_usr_edit__for_db' => "у бази даних %1",
    'db_usr_edit__not_create_pass' => "Ця операція призведе до створення облікового запису користувача бази даних без паролю.\nВи хочете створити користувача без призначення паролю?",
    'dbuser__only_one_user_can_be_default' => "Лише один користувач може бути встановлений за замовчуванням.",
    'db_server__cannot_delete_default' => "Неможливо видалити сервер бази даних за замовчуванням.",
    'db_server__cannot_delete_local' => "Локальний сервер бази даних не може бути видалений.",
    'db_server__cannot_delete_used' => 'Неможливо видалити сервер бази даних, поки на ньому розташовані бази даних чи розміщені користувачі баз даних.',
    'demo__disabled_in_demo' => "Ця операція не підтримується у демо версії.",
    'defaultcomponents__title' => "Вибір Компонентів за замовчуванням",
    'defaultcomponents__select_default' => "Виберіть компонент %1 за замовчуванням",//to check
    'defaultcomponents__not_installed' => "(не встановлено)",
    'defaultcomponents__not_configured' => "(не налаштовано)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Деякі категорії сервісів містять неприпустимі вибори, або жодного вибору не було зроблено.",
    'defaultcomponents__depends_on' => "(потребує %1)",
    'defaultcomponents__parameters' => "Параметри %1",
    'component_name__antivirus' => "Антивірус",
    'component_name__database' => "Сервер SQL",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Сервер DNS",
    'component_name__firewall' => "Мережевий екран",
    'component_name__ftpserver' => "Сервер FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Сервер електронної пошти",
    'component_name__local_mailserver' => "Локальний поштовий сервер",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Розробка веб-скриптів",
    'component_name__spamfilter' => "Спам-фільтр",
    'component_name__stats' => "Веб-статистика",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Поштовий веб-інтерфейс",
    'component_name__webpublish' => "Веб-публікації",
    'component_name__webserver' => "Веб-сервер",
    'dns__dns_record_invalid_values' => 'Вказано некоректні значення DNS запису: %1: %2',
    'dns__dns_record_not_found' => 'Запис DNS не знайдено',
    'dns__dns_zone_invalid_values' => 'Вказано невірні параметри DNS зони.',

    'dns__soa_mname_title' => 'Основне ім\'я сервера',
    'dns__soa_mname_legend' => 'Ім\'я сервера',
    'dns__soa_mname_autoselect' => '(Автовибір)',

    'dns__dns_zone_off_remove_title' => "Такі записи ресурсу будуть видалені із зони %1:",
    'dns__dns_zone_master_remove_title' => "Видалення записів ресурсу з DNS-зони %1",
    'dns__dns_zone_slave_remove_title' => "Такі записи первинного серверу імен для %1 будуть видалені:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Введіть рядок запису',
    'dns_add__is_spf_syntax' => 'Запис SPF',
    'dns_add__spf_value_is_invalid' => "Значення запису SPF невірне, воно повинно починатись із 'v=spf'",
    'dns__dns_zone_status' => "Статус зони DNS.",
    'dns__invalid_ip_address' => "ІР-адреса нового первинного DNS-сервера невірна або порожня.",
    'dns__ip_address' => "ІР-адреси",
    'dns__master_dns_type' => "є первинним DNS-сервером",
    'dns__masters' => "первинні DNS-сервери",
    'dns__soa_minimum_too_large' => 'Кешування негативних відповідей протягом більше трьох годин не рекомендується.',
    'dns__select_masters_to_remove' => "Виберіть первинні сервери DNS для видалення.",
    'dns__select_template_record_to_remove' => 'Виберіть записи шаблону DNS для видалення.',
    'dns__nameservers_for_domain' => "Сервери імен для доменів",
    'dns__remove_dns_zone_of_domain__' => "Видалення записів DNS із домену %1",
    'dns__remove_dns_zone_template__' => "Наступні записи DNS будуть видалені із шаблону:",
    'dns__remove_this_dns_record?' => "Ви впевнені, що хочете видалити DNS запис?",
    'dns__restore_default' => "Відновлення зони DNS за допомогою шаблону",
    'dns__restore_default_confirm' => "Відновлення зони DNS спричинить скидання поточної конфігурації зони DNS. Продовжити в будь-якому разі?",
    'dns__restore_default_error' => "Помилка відновлення зони DNS:",
    'dns__slave_dns_type' => "є вторинним сервером DNS",
    'dns__subdomain_dns_rec_removed' => "Запис А було видалено із субдоменної зони %1.",
    'dns__zone_switched_off_no_ns' => "Зону було вимкнено, тому що немає NS запису %1, який повинен бути присутнім в зоні. Щоб додати запис до зони, натисніть кнопку Додати запис.",
    'dns__cant_switch_on_no_ns' => "Зона не може бути включена, оскільки немає NS запису %1, який повинен бути присутнім у зоні. Щоб додати запис до зони, натисніть кнопку Додати запис.",
    'dns__unable_activate/deactivate_dns' => "Неможливо активувати/деактивувати DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Неможливо додати первинний DNS-сервер: запис-дублікат.",
    'dns__unable_add_dns_master_local_ip' => "Неможливо додати ІР-адресу для первинного DNS- сервера: цей запис має бути створений на віддаленому сервері.",
    'dns__unable_define_dns_record' => "Неможливо визначити DNS-запис: %1",
    'dns__unable_get_dns_template_status' => "Неможливо отримати статус шаблону DNS.",
    'dns__unable_remove_dns_rec' => "Неможливо видалити запис DNS: %1",
    'dns__warnings__' => "Результат модифікації зони DNS:",
    'dns__you_not_have_perm_manage_dns' => "Ви не маєте прав для управління зоною DNS для цього домену.",
    'dns__cant_create_record_with_server_ip' => "Не вдалося додати цю IP-адресу, тому що вона співпадає із IP-адресою цього Plesk-керованого серверу.",

    'dns__tabs_acl' => "Передачі зони",
    'dns__acl_add_network_legend' => "Додати мережу",
    'dns__acl_add_ip_legend' => "Додати IP-адресу",
    'dns__acl_network_not_allowed' => "Адреса цієї мережі не має дозволу від DNS у Windows.",
    'dns__acl_enter_ip_address_with_mask' => "ІР-адреса/маска",
    'dns__acl_enter_ip_address' => "IP-адреса",
    'dns__acl_list_network_legend' => "Мережі з дозволом на отримання DNS-зони",
    'dns__acl_list_ip_legend' => "ІР-адреси з дозволом на отримання копії DNS-зони",
    'bt_dns_acl_add_network' => "Додати мережу",
    'bt_dns_acl_add_ip' => "Додати IP-адресу",

    'dns_add__add_rec_for_zone' => "Додайте %1 для зони %2",
    'dns_add__canonical_dom_name_is_invalid' => "Канонічне ім'я домену недійсне.",
    'dns_add__enter_canonical_name' => "Канонічне ім'я",
    'dns_add__enter_dom_name' => "Ім'я домену",
    'dns_add__enter_ip_address' => "IP-адреса",
    'dns_add__enter_ip_mask' => "ІР-адреса та маска мережі",
    'dns_add__enter_mail_domain' => "Домен електронної пошти",
    'dns_add__enter_mail_exchanger' => "Сервер обміну електронної пошти",
    'dns_add__enter_nameserver' => "Ім’я серверу",
    'dns_add__enter_txt_record' => "TXT запис",
    'dns_add__enter_service_name' => "Ім’я сервісу",
    'dns_add__hint_service_name' => "Приклад: SIP (без символу підкреслення)",
    'dns_add__enter_protocol' => "Протокол",
    'dns_add__hint_protocol_name' => "Приклад: TCP (без символу підкреслення)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Пріоритетність",
    'dns_add__specify_weight_of_service' => "Відносна вага для записів з однаковим пріоритетом",
    'dns_add__enter_target_host' => "Хост призначення",
    'dns_add__hint_target_host' => "Приклад: example.com",
    'dns_add__enter_target_port' => "Цільовий порт",
    'dns_add__caa_tag' => "Тег",
    'dns_add__caa_value' => "Значення",
    'dns_add-invalid-A_ip' => "ІР-адреса недійсна.",
    'dns_add-invalid-AAAA_ip' => "ІР-адреса недійсна.",
    'dns_add-invalid-PTR_ip_mask' => "Невірна пара ІР-адреса/мережева маска.",
    'dns_add-invalid-SRV_service_name' => "Недійсна назва служби",
    'dns_add-invalid-SRV_protocol_name' => "Недійсний протокол",
    'dns_add-invalid-SRV_target_port' => "Недійсний цільовий порт",

    'dns_add__invalid_ip' => "ІР-адреса недійсна.",
    'dns_add__low' => "низька",
    'dns_add__mail_dom_name_is_invalid' => "Ім’я домену електронної пошти недійсне.",
    'dns_add__nameserver_is_invalid' => "Невірне ім’я серверу.",
    'dns_add__record' => "%1 запис",
    'dns_add__select_prefer_for_mail_exchange_server' => "Вказати пріоритет сервера обміну електронною поштою",
    'dns_add__unable_insert_new_dns_rec' => "Неможливо вставити новий запис DNS: %1",
    'dns_add__very_high' => "дуже високий",
    'dom_ctrl__allowed' => "Дозволено",
    'dom_ctrl__db' => "Бази даних MySQL",
    'dom_ctrl__mssql_db' => "Бази даних Microsoft SQL Server",
    'dom_ctrl__disk_space' => "Дисковий простір",
    'dom_ctrl__dom_adm' => "Домен %1 із %2",
    'dom_ctrl__dom_cl' => "Домен %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Домен має переадресацію, налаштовану з невизначеним URL переадресації",
    'dom_ctrl__domain_has_frame_forwarding' => "Домен має переадресацію фреймів до URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Домен не має налаштованого хостингу",
    'dom_ctrl__domain_has_physical_hosting' => "Для цього домену веб-хостинг є налаштований за IP-адресою %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Домен має стандартну переадресацію до URL %1",
    'dom_ctrl__maillists' => "Переліки поштових розсилок",
    'dom_ctrl__mboxes' => "Поштові скриньки",
    'dom_ctrl__mg' => "Пересилання пошти",
    'dom_ctrl__resource_name' => "Ресурс",
    'dom_ctrl__resp' => "Автовідповіді",
    'dom_ctrl__subdom' => "Субдомени",
    'dom_ctrl__dom_aliases' => "Псевдоніми домена",
    'dom_ctrl__traffic' => "Трафік",
    'dom_ctrl__unable_activate/deactivate_dom' => "Неможливо активувати/деактивувати домен: %1",
    'dom_ctrl__used' => "Використано",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Веб-користувачі",
    'dom_pref__bounce_with_phrase' => "Недоставка з повідомленням",
    'dom_pref__bounce' => "Повернути",
    'dom_pref__catch_addr' => "Переспрямування на адресу",
    'dom_pref__reject' => 'Відмовити',
    'dom_pref__confirm_domain_removing' => "Будь ласка, не забудьте повідомити відвідувачам домену про зміну доменного імені. Ви впевнені, що хочете перейменувати домен?",
    'dom_pref__db_inconsystency' => "неузгодженість бази даних.",
    'dom_pref__dbs' => "бази даних",
    'dom_pref__delete_traffic_stat' => "Зберігати веб-статистику і статистику трафіку",
    'dom_pref__delete_traffic_stat_older' => "Зберігати веб-статистику і статистику трафіку",
    'dom_pref__dom_level_name_conflict' => "Користувацьке ім’я адміністратору домену конфліктує з користувацьким іменем одного з замовників.",
    'dom_pref__invalid_disk_space_limit' => "Недійсний ліміт дискового простору. Максимальне значення: %1",
    'dom_pref__invalid_expiration_date_limit' => "Невірний термін дії.",
    'dom_pref__invalid_max_traffic_limit' => "Невірний ліміт трафіку. Максимальне значення: %1",
    'dom_pref__limits_of_dom' => "Ліміти для домену %1",
    'dom_pref__mail_grps' => "групи електронної пошти",
    'dom_pref__mail_nonexistent_user' => "Що робити з поштою, надісланою неіснуючим користувачам",
    'dom_pref__mail_redirs' => "переадресатори електронної пошти",
    'dom_pref__mail_resps' => "автоматичні відповіді електронної пошти",
    'dom_pref__max_limit_is_invalid' => "%1 недійсний.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Максимальна кількість %1 недійсна.",
    'dom_pref__new_limit_less_currently_used' => "%1: запитано - %2, наразі використано - %3",
    'dom_pref__older_that' => "для",
    'dom_pref__postboxes' => "поштові скриньки",
    'dom_pref__preferences_of_dom' => "Налаштування для домену %1",
    'dom_pref__redirect_to_itself' => "Переадресація домену буде встановлена на нього",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Ви вказали час утримування статистики трафіку домену менший ніж загальне визначене значення для сервера (%1 місяць(і)). Встановлений період утримування статистики дорівнює значенню за замовчуванням для сервера (%1 місяць(і)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Неможливо додати префікс www до домену: %1",
    'dom_pref__unable_define_physical_hst_param' => "Неможливо визначити фізичні параметри хостингу: %1",
    'dom_pref__unable_rename_domain' => "Неможливо перейменувати домен %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Неможливо встановити квоту поштової скриньки для цього домену: %1",
    'dom_pref__unable_set_up_web_user_script' => "Неможливо встановити створення скриптів для веб-користувачів: %1",
    'dom_pref__unlimited' => "Необмежений",
    'dom_pref__web_usrs' => "веб-користувачі",
    'dom_pref__you_already_have_%object' => "Ви вже маєте %1",
    'cu_domain__error_unable_update_ftp_users' => 'Збій оновлення користувачів домену FTP: %1',
    'dom_cli__warning_ignore_quota' => 'УВАГА: Опція "-hard_quota" ігнорується: Квота дискового простору не підтримується',
    'dom_user_client_login_exist' => "Неможливо дозволити права доступу адміністратора домену до Plesk на домені %1: це користувацьке ім’я вже використовується.",
    'domain__unable_to_turn_on_service' => "Не вдалося увімкнути сервіс %1.",
    'domains__change_the_status_of_domain?' => "Ви впевнені, що хочете змінити статус домену %1?",
    'domains__client_info_hiding_traffic' => "%1 домени, %2 активні домени, %3 використаний дисковий простір",
    'domains__unable_to_change_client_status' => "Неможливо змінити статус облікового запису замовника: %1",
    'domains__unable_update_apache_settings' => "Неможливо оновити налаштування Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Ви не маєте прав для видалення доменів.",
    'domains__you_want_change_the_status_of_the_cl??' => "Ви впевнені, що бажаєте змінити стан облікового запису замовника?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Ви впевнені, що хочете виконати цю операцію?",
    'domains_list__unable_remove_doms' => "Неможливо видалити домени: %1",
    'domaintrafficlist_header_of_domain__' => "Трафік на домені %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Виберіть альтернативні домени для видалення.',
    'domain_aliases_remove__title' => 'Видалення псевдонімів доменів',
    'domain_aliases__max_aliases_reached_for_dom' => "Було досягнуто максимальну кількість псевдонімів для цього домену.",
    'domain_edit__edit_title' => 'Редагувати ім’я альтернативного домену',
    'domain_alias_edit__type' => 'Тип псевдоніму домену',
    'domain_aliases__list_header' => 'Псевдоніми домена',
    'domain_aliases__name' => 'Ім’я',
    'domain_aliases__type' => 'Тип',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Псевдоніми домена',
    'domain_aliases__legend' => 'Псевдоніми домена',
    'domain_alias__domain_exists' => 'Домен з таким ім\'ям вже існує',
    'domain_alias__subdomain_exists' => 'Субдомен з таким ім\'ям вже існує',
    'domain_alias__dns_record_exists' => 'DNS-запис із вказаним псевдонімом домену вже існує',
    'domain_alias__domain_alias_exists' => "Псевдонім домену з таким ім'ям вже існує",
    'domain_alias__invalid_type_full' => 'Сервер електронної пошти не підтримує псевдоніми доменів',
    'domain_alias__redirect_exists' => 'Було виявлено перенаправлення на себе.',

    'ds__anonymous_ftp' => "Анонімний FTP",
    'drweb__pagetitle' => 'Налаштування антивірусу',
    'drweb__drweb' => 'Перевірка електронної пошти антивірусом',
    'drweb__drweb_direction' => 'Перевірка електронної пошти на віруси',
    'drweb__drweb_direction_off' => 'Не перевіряти на віруси',
    'drweb__drweb_direction_any' => 'Вхідна та вихідна пошта',
    'drweb__drweb_direction_from' => 'Тільки вихідна пошта',
    'drweb__drweb_direction_to' => 'Тільки вхідна пошта',
    'drweb__disable_reason_key' => 'Антивірус не підтримується ліцензійним ключем.',
    'drweb__disable_reason_perm' => 'Ви не маєте дозволу на управління антивірусом.',
    'drweb__disable_reason_install' => 'Антивірус не встановлено.',
    'drweb__filters' => 'Антивірусні фільтри',
    'ds__dns' => "Зона DNS",
    'ds__mail' => "Пошта",
    'dumps_list__deletion_page_title' => "Такі резервні копії домену %1 будуть видалені:",
    'dumps_list__dumpfile_is_invalid' => "Файл %1 не є допустимою резервною копією домену.",
    'dumps_list__page_title' => "Сховище резервних файлів",
    'dumps_upload__page_title' => "Завантаження резервних копій до сховища",
    'dumps_list__repository_is_not_exist' => "Сховище резервних копій не існує.",
    'dumps_list__unable_to_remove' => "Неможливо видалити резервну копію: %1",
    'dumps_list__dumpfile_can_conflict' => "Вказане вами ім’я файлу конфліктує з файлом %1. Будь ласка, вкажіть інше ім'я файлу.",
    'dusr_ed__allow_dl_usr_access' => "Дозволити доступ адміністратора домену",
    'dusr_ed__information' => "Властивості адміністратора %1 домену",
    'dusr_ed__locale' => "Мова адміністратора домену",
    'dusr_ed__skin' => "Зовнішня оболонка інтерфейсу адміністратора домену",
    'dusr_ed__personal_information' => 'Особиста інформація',
    'ess__error' => "Помилка",
    'example__' => "Приклад: %1",
    'extras__allow_certificate_purchasing' => "Дозволити придбання сертифікату",
    'extras__allow_domain_registration' => "Дозволити реєстрацію домену",
    'extras__allow_extras' => "Дозволити додаткові сервіси",
    'extras__buy_new_key' => "Ваша поточна ліцензія не дозволяє змінювати ці об’єкти.",
    'extras__setup_services' => "Встановити додаткові сервіси",

    'ruleeditform__error' => 'Неможливо оновити правило брандмауера.',
    'ruleeditform__name_is_required' => 'Вказати ім\'я правила.',
    'ruleeditform__profiles_is_required' => 'Вибрати хоча б один профіль.',
    'ruleeditform__invalid_ip' => 'Зазначені IP-адреса або мережа недійсні.',
    'ruleeditform__invalid_port' => 'Зазначений порт недійсний. Можливі значення - це 1000 або 1000-1051',

    'filemanager__items' => 'елементи в каталозі %1',
    'filemanager__items_paging' => 'елементи в каталозі %1',

    'get_password__encrypted_password' => "Неможливо відправити інформацію про пароль: пароль зберігається в зашифрованому вигляді.",
    'get_password__mail_error' => "Помилка виникла під час спроби надіслати пароль на електронну пошту %1: %2",
    'get_password__mail_ok' => "Пароль було успішно надіслано на електронну пошту: %1",
    'get_password__message' => "Ваше користувацьке ім’я для доступу до системи: %1\nВаш пароль %2",
    'get_password__subject' => "Пароль для доступу до системи",
    'groups__available' => "Доступні групи електронної пошти",
    'groups__groups_for_mailname' => "Групи електронної пошти, до яких підписаний обліковий запис електронної пошти %1",
    'groups__member_of' => "Член наступних груп електронної пошти",
    'help__help_area' => "Область довідки.",
    'hst_def__auth_disabled' => "заборонено",
    'hst_def__auth_enabled' => "дозволено",
    'hst_def__change_curr_dns_ip' => "Нинішня ІР-адреса запису А DNS буде змінена",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Жодна з ІР-адрес запису А DNS не співпадає з ІР-адресою, призначеною обліковому запису хостингу, що створюється",
    'hst_def__dest_url' => "Цільовий URL",
    'hst_def__disk_quota' => "Дискова квота",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Ліміт дискового простору, який ви намагаєтесь встановити, перевищено лімітом дискового простору у вхідному каталогу анонімного FTP. Ліміт дискового простору у вхідному каталогу анонімного FTP не повинен перевищувати ліміт дискового простору домену.",
    'hst_def__frame_forwarding_definition' => "Призначення переадресації фреймів для домену %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Попередження: користувач FTP %1 використовується в налаштуваннях облікового запису хостингу, але не існує в системі.",
    'hst_def__hst_type_is_not_defined' => "Не визначено тип хостингу",
    'hst_def__ip_based' => "За IP-адресою",
    'hst_def__name_based_power_anonymous_ftp_down' => "Передача облікового запису цього хостингу до загальної ІР-адреси зробіть недоступним сервіс анонімного FTP. Продовжувати в будь-якому разі?",
    'hst_def__password_is_invalid_password_syntax' => "Пароль недійсний.\nНе використовувати одинарні лапки і символи національного алфавіту у паролі.\nДовжина пароля повинна бути від 5 до 14 символів. Пароль не повинен містити ім’я користувача.",
    'hst_def__shell' => "SSH-доступ до оболонки сервера під системним користувачем підписки",
    'hst_def__shell_windows' => "Доступ віддаленого робочого столу до сервера під записом системного користувача підписки",
    'hst_def__standard_forwarding_definition' => "Призначення стандартної переадресації для домену %1",
    'hst_def__title_name_based' => "За іменем",
    'hst_def__unable_create/update_physic_hst' => "Неможливо створити/оновити фізичний хостинг: %1",
    'hst_def__unable_create/update_std_fwd' => "Неможливо створити/оновити стандартну переадресацію: %1",
    'hst_def__unable_create_forwarding_myself' => "Неможливо створити переадресацію на сам домен.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Неможливо дозволити використання одного каталогу для зберігання контенту SSL/TLS і non-SSL/TLS: Підтримка SSL/TLS не включена.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Неможливо ввімкнути підтримку SSL/TLS: невстановлено сертифікат SSL/TLS.",
    'hst_def__url_is_invalid' => "URL недійсний.",
    'hst_def__virtual_host_access' => "Доступ віртуального хоста для домена %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ПОПЕРЕДЖЕННЯ. Цей віртуальний хост використовує неіснуючу IP-адресу для хостингу.",
    'hst_def__you_have_no_ips' => "У вас немає доступних ІР-адрес і вам недозволено створювати хостинг на основі імен.",
    'hst_sel__header' => "Щоб розмістити веб-сайт на цьому сервері, виберіть опцію Фізичний хостинг.\n Для налаштувати переадресації доменів на сайт на іншій робочій станції, виберіть Переадресація у фреймі або Стандартна переадресація.\n При стандартній переадресації відбувається перенаправлення користувача на сайт і фактичне URL сайту відображається у браузері користувача, так що користувач знає про переадресацію. При переадресації у фреймі користувач перенаправляється на сайт, не знаючи, що сам сайт фактично розташовується за іншою адресою.",
    'hst_sel__physical_hst' => "Фізичний хостинг",
    'hst_sel__select_hst_type' => "Вибрати тип хостинга для домена",
    'hst_sel__select_hst_type_warning' => "Вибрати тип хостинга для домена",
    'hst_sel__hosting_exists' => "Неможливо створити хостинг, оскільки він вже сконфігурований для цього домена. Вас буде перенаправлено на сторінку управління хостингу.",
    'hst_sel__standard_frw' => "Стандартна переадресація",
    'hst_sel__frame_frw' => "Переадресація фрейму",
    '__frame_frw' => "Переадресація фрейму",
    '__hosting_exists' => "Неможливо створити хостинг, оскільки він вже сконфігурований для цього домена. Вас буде перенаправлено на сторінку управління хостингу.",
    '__choose_hst_type' => "Виберіть необхідний тип хостингу.",
    '__no_hst_conf' => "Для вашого домену немає налаштованого хостингу.",
    '__physical_hst' => "Фізичний хостинг",
    '__select_hst_type' => "Вибрати тип хостинга для домена",
    '__standard_frw' => "Стандартна переадресація",
    '__warning' => "Попередження! Всі раніше встановлені параметри будуть скинуті. Ви впевнені, що бажаєте змінити тип хостингу?",
    'i_cl_off' => "Замовник неактивний.",
    'i_cl_off_by_admin' => "Обліковий запис замовника призупинено адміністратором серверу.",
    'i_cl_off_expired' => "Скінчився строк дії облікового запису замовника.",
    'i_cl_on' => "Замовник активний.",

    'icf__title' => 'Мережевий екран інтернет-з’єднання',
    'icf__if_legend' => 'Інтерфейси',
    'icf__mode' => 'Режим',

    'invalid_value' => 'Значення невірне',

    'ip_addr__already_exists' => "ІР-адреса %1 вже існує.",
    'ip_addr__cant_add' => "ІР %1 не існує або належить ІР-пулу іншого клієнта.",
    'ip_alias__interface' => "Інтерфейс",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 ІР-адреса для віртуального хостинга на основі імен невірна.",
    'ip_alias__invalid_ip_or_netmask' => "Невірна пара ІР-адреса/мережева маска.",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP-адреса %1 є оригінальною IP серверу, так що ви не можете її видалити.",
    'ip_alias__ip_is_invalid' => "%1 ІР-адреса невірна.",
    'ip_alias__ip_mask_is_invalid' => "%1 ІР-маска невірна.",
    'ip_alias__ip_not_exist' => "ІР-адреса %1 не існує.",
    'ip_alias__ip_address_and_mask' => 'ІР-адреса та маска підмережі',
    'ip_alias__mask' => "Маска підмережі",
    'ip_alias__remove_selected_ip_aliases?' => "Впевнені, що бажаєте видалити вибрані ІР-адреси?",
    'ip_alias__select_ip' => "Виберіть принаймні одну ІР-адресу з списку для видалення.",
    'ip_alias__this_ip_used_for_domain' => "(%1) ця ІР-адреса використовується для домену %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) ця ІР-адреса використовується для віртуальних хостів на основі імен.",
    'ip_alias__unable_add_ip' => "Неможливо додати ІР: %1",
    'ip_alias__unable_remove_ip' => "Неможливо видалити ІР: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Ви не можете змінити тип IP-адреси на спільну, тому що після цього анонімний FTP-доступ стане недоступний для домену '%1'.",
    'ip_ctrl__ip_addr' => "IP-адреса %2 на мережевому адаптері %1.",
    'ip_ctrl__ip_exists_many_pools' => "ви не можете змінити тип IP-адреси. Ця IP-адреса входить до пулів декількох користувачів одночасно.",
    'ip_ctrl__ssl_cert' => "Сертифікат SSL/TLS",
    'limit__date_in_past' => "Некоректний строк дії. %1 вже минуло.",
    'limit__enter_date' => "Введіть дату",
    'limit__max_db' => "Бази даних",
    'limit__name_disk_space' => "дисковий простір",
    'limit__name_max_box' => "поштові скриньки",
    'limit__name_max_db' => "Бази даних MySQL",
    'limit__name_max_dom' => "домени",
    'limit__name_max_maillists' => "поштові розсилки",
    'limit__name_max_subdom' => "субдомени",
    'limit__name_max_traffic' => "трафік",
    'limit__name_max_wu' => "веб-користувачі",
    'limit__name_mbox_quota' => "квота поштової скриньки",
    'limit__name_max_mn' => "поштові облікові записи",
    'limit__name_max_cl' => 'клієнти',
    'limit__name_total_mboxes_quota' => "загальна квота поштових скриньок",
    'limit__name_mysql_dbase_space' => "простір бази даних MySQL",
    'limit__name_mssql_dbase_space' => "простір бази даних MSSQL",
    'limit__name_pgsql_dbase_space' => "Простір бази даних PostgreSQL",
    'limit__name_expiration' => 'дата закінчення строку дії',

    'locale_upload__unable_to_install' => 'Не вдається встановити файл мовного пакету',
    'locale_upload__wrong_package' => 'Файл, який ви вивантажили, не містить мовного пакету, дійсного для цієї версії Plesk.',
    'locale_upload__wrong_locale' => 'Вивантажений вами файл не містить дійсний мовний пакет.',

    'ma__create_title' => 'Створення псевдоніму електронної пошти для %1',
    'ma__edit_title' => "Редагуйте псевдонім електронної пошти %1",
    'ma__enter_new_alias' => "Ввести новий псевдонім",
    'ma__invalid_alias' => "Невірний псевдонім електронної пошти",
    'ma__mail_aliases_mailname' => "Псевдоніми для поштового облікового запису %1",
    'ma__mailname_does_not_exist' => "Поштовий обліковий запис не існує.",
    'ma__select_ma_for_remove' => "Виберіть псевдоніми поштового облікового запису, які потрібно видалити.",
    'ma__unable_to_add_new_ma' => "Неможливо додати новмй псевдонім поштового облікового запису: %1",

    'mail_queue__not_allowed_by_license_key' => 'Управління чергою електронної пошти не допускається умовами ліцензійного ключа.',
    'maillist__' => "Розсилка %1",
    'maillist__already_exists' => "Список розсилки повідомлень вже існує.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Псевдонім електронної пошти %1 вже існує в домені",
    'maillists__' => "Розсилки %1",
    'maillists__limit_cl_max_maillists' => "Кількість поштових розсилок замовника досягла встановленого ліміту (ліміт: %1, використано: %2)",
    'maillists__limit_dom_max_maillists' => "Кількість поштових розсилок домену досягла встановленого ліміту.",
    'maillists__list' => "Переліки поштових розсилок",
    'maillists__mailman_not_installed_or_conf' => "\nНа даний момент серверне розширення Mailman не встановлене або не налаштоване\nна сервері. Зверніться до адміністратора сервера для встановлення або налаштування серверного розширення Mailman.",
    'maillists__status' => "Служба поштової розсилки ввімкнена",
    'maillists__unable_to_delete__' => "Неможливо видалити розсилку: %1",
    'maillists__disabled_text' => 'ви не можете управляти списками розсилки, тому що компонент серверу списку розсилок Mailman не встановлений або не налаштований.',
    'maillist_member__already_exists' => 'Передплатник розсилки вже існує.',
    'maillist_member__not_exists' => 'Такий користувач відсутній у розсилці.',
    'mailserver_switching_warning' => "Попередження! \n\nЗміна поштового сереверу виконується лише при виконанні початкового налаштування. Зміна серверу під час його роботи призведе до наступних проблем: втрата налаштувань та вмісту поштових скриньок, а також, якщо сервер, на який Ви переходете, вже використовується — до різних конфліктів.\nЯкщо, незважаючи на це, Ви вирішете переключитись з серверу, який вже використовується, на інший, повідомьте про це своїх клієнтів, щоб вони могли зберегти свою пошту.",
    'manager__access_denied' => "Немає доступу: %1",
    'manager__admin' => "Адміністратор",
    'manager__client' => 'Замовник',
    'manager__domain' => "Домен",
    'manager__domain_cl_limit_exceeding' => "Кількість доменів для цього облікового запису клієнту досягла встановленого ліміту.",
    'manager__domain_is_not_yours' => "Домен %1 не належить вам.",
    'manager__domain_key_limit_exceeding' => "Кількість створених доменів досягла ліміту, встановленого вашим ліцензійним ключем.",
    'manager__no_perm_to_call' => "ви не маєте прав на виклик %1.",
    'manager__no_perm_to_create_domains' => "ви не маєте прав на створення доменів.",
    'manager__no_perm_to_modify_domain' => "ви не маєте прав на модифікацію домену %1.",
    'manager__no_perm_to_modify_domains' => "ви не маєте прав на модифікацію доменів.",
    'manager__no_perm_to_remove_domain' => "ви не маєте прав на видалення домену %1.",
    'manager__no_perm_to_remove_domains' => "ви не маєте прав на видалення доменів.",
    'manager__node_doesnt_exist' => "%1 не існує.",
    'manager__user_disabled' => "Ваш обліковий запис тимчасово відключений. Ви не можете працювати в системі.",
    'mail_quota_unsupported' => "не підтримується поштовим сервером",
    'mbox_quota_unsupported' => "не підтримується поштовим сервером",
    'mn__create_title' => "Створити поштовий обліковий запис",
    'mn__edit_title' => "Налаштування",
    'mn__files_list_title' => "Вкладені файли",
    'mn__files_remove' => "Видаліть файли зі сховища вкладень. Ці файли, можливо, використовуються автоматичними відповідями. Вони будуть видалені як зі сховища, так і з автоматичних відповідей, які їх використовують.",
    'mn__files_select_for_remove' => "Виберіть файли, які необхідно видалити.",
    'mn__mail_alias_form' => "Формуляр псевдоніму поштової скриньки",
    'mn__mail_aliases_list' => "Псевдоніми поштових адрес",
    'mn__mailbox' => "Управління поштовою скринькою",
    'mn__unable_define_mn' => "Неможливо установити поштові облікові записи: %1",
    'mn__unable_remove_mbox_quota' => "Неможливо видалити квоту поштової скриньки: %1",
    'mn__upload_file' => "Завантажити файл",
    'mn_edit__attach_filename_changed' => 'Вивантажений файл %1 був перейменований у %2, тому що його ім\'я містить символи, що не входять до набору ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Для активації поштової групи необхідно додати члена поштової групи.",
    'mn_edit__add_resp_or_turn_off_box' => "Необхідно додати автовідповідач або зняти позначку автовідповідача.",
    'mn_edit__attachments' => "Вкладення",
    'mn_edit__dom_quota_less_then_quota' => "Розмір цієї поштової скриньки не перевищує ліміту дискового простору для поштових скриньок, встановленого на цьому домені.",
    'mn_edit__enter_external_rcpnt_email' => "Введіть адресу електронної пошти члена зовнішньої поштової групи",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Введіть адресу для пересилання пошти або зніміть прапорець.",
    'mn_edit__ext_rcpnt_email_invalid' => "Адреса електронної пошти зовнішнього одержувача некоректна.",
    'mn_edit__file_exists' => "Файл вже існує. Перезаписати?",
    'mn_edit__files_deld_from_repository' => "Ці файли будуть видалені зі сховища та автовідповідачів, в яких вони містяться. Продовжити?",
    'mn_edit__mail_name' => "Обліковий запис електронної пошти",
    'mn_edit__mail_name_invalid' => "Некоректне ім’я поштового облікового запису.",
    'mn_edit__mail_redir' => "Відправники пошти",
    'mn_edit__mail_redir_add' => "Додати члена поштової групи",
    'mn_edit__mail_resps' => "Автовідповідачі",
    'mn_edit__mailbox' => "Поштова скринька",
    'mn_edit__enable_mailbox' => "Поштова скринька",
    'mn_edit__mailgroup' => "Поштова група",
    'mn_edit__mailgroup_addresses' => "Члени поштової групи",
    'mn_edit__mailgroup_disabled' => "Доступно лише після додання поштового облікового запису.",
    'mn_edit__max_dom_quota' => "За замовчуванням для домену (%1)",
    'mn_edit__mbox_quota_invalid' => "Вказаний розмір поштової скриньки некоректний.",
    'mn_edit__new_resp_name' => "Ім’я нового автовідповідача",
    'mn_edit__no_autoresponders' => "Необхідно додати хоча б один автовідповідач перед ввімкненням/вимкненням сервісу автоматичної відповіді на повідомлення.",
    'mn_edit__no_file_sel' => "Не вибрано жодного файлу.",
    'mn_edit__no_mail_addresses' => "Жодної адреси електронної пошти не було вказано або вибрано.",
    'mn_edit__none' => "Немає",
    'mn_edit__not_create_pass' => "Це не створить пароль для цього облікового запису.\nБез паролю, користувач не зможе переглядати і відправляти пошту.",
    'mn_edit__redir_email_invalid' => "Адреса переадресації недійсна.",
    'mn_edit__redirect_addr' => "Адреса відправника",
    'mn_edit__remove_autoresp?' => "Ви впевнені, що бажаєте видалити автовідповідь?",
    'mn_edit__remove_rcpnts?' => "Ви впевнені, що бажаєте видалити цих одержувачів?",
    'mn_edit__repository' => "Сховище",
    'mn_edit__resps_attach' => "Вкладені файли автовідповідача",
    'mn_edit__select_rcpnt_from_list' => "Оберіть зі списку хоча б одного одержувача, якого потрібно видалити.",
    'mn_edit__select_registered_users' => "Вибрати зареєстрованих користувачів",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Ви вибрали створення для вас поштової скриньки, але не вказали пароль для неї.",
    'mn_edit__unable_act_deact_mail_group' => "Неможливо активувати або деактивувати поштову групу: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Неможливо активувати або деактивувати переадресацію пошти: %1",
    'mn_edit__unable_act_deact_postbox' => "Неможливо активувати або деактивувати поштову скриньку: %1",
    'mn_edit__unable_act_deact_resp' => "Неможливо активувати або деактивувати автовідповідач: %1",
    'mn_edit__unable_add_attach' => "Неможливо додати вкладений файл: %1",
    'mn_edit__unable_add_mail_group_member' => "Неможливо додати члена поштової групи: %1",
    'mn_edit__unable_add_resp' => "Неможливо додати автовідповідач: %1",
    'mn_edit__unable_change_mail_name' => "Неможливо змінити ім’я поштовго облікового запису: %1",
    'mn_edit__unable_deactivate_mail_group' => "Неможливо деактивувати поштову групу: %1",
    'mn_edit__unable_deactivate_resp' => "Неможливо деактивувати поштовий автовідповідач: %1",
    'mn_edit__unable_define_resp_id' => "Неможливо визначити ідентифікатор автовідповідача: %1",
    'mn_edit__unable_remove_attach' => "Неможливо видалити вкладений файл(и): %1",
    'mn_edit__unable_remove_autoresp' => "Неможливо видалити автовідповідач: %1",
    'mn_edit__unable_remove_mail_group_member' => "Неможливо видалити членів поштової групи: %1",
    'mn_edit__wrong_way' => 'Повідомлення, надіслані %1, не будуть доставлені, тому що цей поштовий обліковий запис не має поштової скриньки або ввімкненого одержувача пошти.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Поштову скриньку за адресою %1 було вимкнено. Повідомлення в поштовій скриньці не були видалені, але ви не будете мати можливість отримати їх через протоколи IMAP або POP3.',
    'mn_list__mail_names_for_domain' => "Поштові облікові записи домену %1",
    'mn_list__sa_cannot_unable' => "Неможливо включити фільтрацію спаму",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Замовник',
    'mn_list__tab_title_domain' => 'Домен',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "Б",
    'mn_list__tab_title_group' => "ГБ",
    'mn_list__tab_title_name' => "Ім’я",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Неможливо видалити поштові облікові записи: %1",
    'module_upload__module_was_installed' => 'Цей модуль вже встановлено. Якщо Ви бажаєте встановити новішу версію цього модуля, будь ласка деінсталюйте модуль через Plesk, а потім спробуйте виконати установку.',
    'module_upload__unable_to_install' => 'Не вдається встановити файл пакету модуля',
    'module_upload__wrong_package' => 'Вивантажений файл не є підтримуваним пакетом модулю.',
    'module_upload__wrong_module' => 'Вивантажений файл не містить пакету модуля.',

    'news_articles_title' => 'Новини Plesk',
    'notification_text__invalid_subject_length' => "Некоректна довжина теми повідомлення. Допускається від 1 до 255 символів.",
    'notification_text__invalid_text_length' => "Некоректна довжина тексту повідомлення. Має бути в межах від 1 до 65 533 символів.",
    'notification_text__subject' => "Тема повідомлення",
    'notification_text__text' => "Текст повідомлення",
    'notification_text__title' => "Редагувати повідомлення",
    'notification_text__unable_set_text' => "Неможливо змінити текст повідомлення:",

    'odbc__cant_add_dsn' => "Неможливо додати DSN %1: %2",
    'odbc__cant_connect' => "Не вдається підключитися до джерела даних на підставі заданих параметрів. Сервер повернув: %1",
    'odbc__cant_delete_dsn' => "Неможливо видалити DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Неможливо отримати інформацію про драйвери.",
    'odbc__cant_get_drivers' => "Неможливо відновити список драйверів ODBC: %1",
    'odbc__cant_open_info_file' => "Неможливо відкрити файл з інформацією про драйвери ODBC.",
    'odbc__cant_parse_string' => "Неможливо інтерпретувати рядок підключення.",
    'odbc__driver_not_set' => "Драйвер не встановлено",
    'odbc__driver_or_name_not_set' => "Драйвер або ім'я з'єднання ODBC було встановлено",
    'odbc__dsn_already_exists' => "DSN з таким ім'ям (%1) вже існує в системі",
    'odbc__dsn_not_exists' => "Цей DSN не існує",
    'odbc__enter_dsn_name' => "Введіть ім’я DSN-з’єднання",
    'odbc__invalid_dsn_name' => "Неправильний синтаксис імені підключення ODBC (%1) — слід використовувати лише чисельно-буквені символи.",
    'odbc__no_such_driver' => "Драйвер ODBC з таким ім’ ям (%1) не підтримується.",
    'odbc__unknown_driver' => "Невідоме ім’я драйверу (%1).",
    'odbc_dsn_system' => "Системне DSN-з’єднання",

    'pb__aliases' => "Псевдоніми",
    'pb__anonftp' => "Анонімний FTP",
    'pb__autoinstaller_releases' => 'Модуль оновлення',
    'pb__cert' => "Сертифікати",
    'pb__cl_pool' => "ІР-адреси",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Налаштування",
    'pb__cl_rpt' => "Звіт",
    'pb__cl_rpt_list' => "Персоналізувати",
    'pb__cl_templates' => "Шаблони замовника",
    'pb__cl_traffic' => "Трафік",
    'pb__cl_traffic_history' => "Історія трафіку",
    'pb__cl_traffic_of' => "Трафік %1",
    'pb__client' => "%1",
    'pb__clients' => "Замовники",
    'pb__comp_info' => "Серверні компоненти",
    'pb__common_acl' => 'Дозволити передачу ACL',
    'pb__cp_access' => "Доступ",
    'pb__crontab' => "Планувальник",
    'pb__scheduler' => "Планувальник",
    'pb__custom_buttons' => "Користувацькі кнопки",
    'pb__databases_db' => 'Бази даних',
    'pb__sqlservers_db' => 'Сервери SQL',//to check
    'pb__db' => "Бази даних",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Сервери бази даних',
    'pb__dl_usr_ed' => "Адміністратор домену",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Обмеження домену",
    'pb__dom_pref' => "Налаштування",
    'pb__dom_sum_report' => "Зведений звіт домену",
    'pb__dom_templates' => "Шаблони доменів",
    'pb__dom_traffic' => "Трафік %1",
    'pb__domains' => "Домени",
    'pb__domain_aliases' => 'Псевдоніми доменів',
    'pb__dumps_list' => "Сховище резервних файлів",
    'pb__forwarding_setup' => "Налаштування переадресації",
    'pb__filemanager' => "Файловий менеджер",
    'pb__ip_aliasing' => "IP-адреси",
    'pb__ip_clients' => "Видалення IP-адрес",
    'pb__license_management' => 'Інформація про ліцензію',
    'pb__locales' => 'Локалі',
    'pb__log_files' => "Журнали",
    'pb__mail' => 'Пошта',
    'pb__mail_name_files' => "Файли вкладення",
    'pb__mail_name_redirects' => "Відправники пошти",
    'pb__mail_name_resp_attach_add' => "Нове вкладення",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Автовідповідачі",
    'pb__mail_names' => "Пошта",
    'pb__maillists' => "Переліки поштових розсилок",
    'pb__mimetypes' => 'Типи MIME',
    'pb__modules' => 'Модулі',
    'pb__modules_management' => 'Управління модулями',
    'pb__notifications' => "Сповіщення",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Установка фізичного вузла",
    'pb__prtd_dirs' => "Захищені каталоги",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Персоналізувати",
    'pb__server' => "Сервер",
    'pb__sessions' => "Сеанси",
    'pb__sapp_pool' => "Пул веб-застосунків",
    'pb__siteapp_install' => 'Установка веб-застосунку',
    'pb__site_app_pkgs' => 'Веб-застосунки',
    'pb__site_apps' => "Веб-застосунки",
    'pb__additional_key_info' => 'Параметри ключа',
    'pb__additional_key_properties' => 'Параметри ключа',
    'pb__skeleton' => 'Шаблон віртуального хосту',
    'pb__skins' => 'Зовнішня оболонка',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Спам-фільтр",
    'pb__statistics' => "Статистика",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Субдомени",
    'pb__templates' => "Шаблони",
    'pb__virtualdirs' => 'Віртуальні каталоги',
    'pb__web_users' => "Веб-користувачі",
    'pdir__enter_dir_name' => "Ввести ім’я каталога.",
    'pdir__invalid_hst' => "Невірний тип хостингу. Має бути фізичний.",
    'pdir__pd_id_is_undefined' => "Ідентифікатор захищеного каталога не визначений.",
    'pdir__pdir_exist' => "Каталог з таким ім'ям вже захищений.",
    'pdir__pdir_not_exist' => "Захищений каталог не існує.",
    'pdir__pdir_usr_not_exist' => "Користувач захищеного каталога не існує.",
    'pdir__remove_pdir_usrs' => "Будуть видалені такі користувачі захищеного каталога %2 на сайті %1:",
    'pdir__remove_pdir_usrs_on_subdom' => "Такі користувачі захищеного каталогу %2 субдомену %1 будуть видалені:",
    'pdir__select_pdir_usrs_for_remove' => "Виберіть користувачів захищеного каталога, яких потрібно видалити.",
    'pdir__select_pdirs_to_remove' => "Виберіть каталоги, з яких потрібно зняти захист.",
    'pdir__unable_define_pdir_users' => "Неможливо призначити користувачів захищеного каталога.",
    'pdir__unable_define_pdirs_properties' => "Неможливо задати параметри захищених каталогів: %1",
    'pdir__unable_select_dom_param' => "Неможливо вибрати параметри домену: %1",
    'pdir_ed__create_pdir_for_domain' => "Створити захищений каталог у %1",
    'pdir_ed__create_pdir_for_subdomain' => "Створіть захищений каталог в субдомені %1",
    'pdir_ed__dir_already_protect' => "Цей каталог вже захищений.",
    'pdir_ed__head_txt' => "Заголовок захищеної зони",
    'pdir_ed__invalid_login' => "Ви вказали некоректне ім’я користувача",
    'pdir_ed__login_exists' => "Такий користувач вже існує. Спробуйте вказати інше ім'я.",
    'pdir_ed__new_usr' => "Ім'я користувача",
    'pdir_ed__non_ssl' => "non-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Назва каталогу",
    'pdir_ed__pdir_for_domain' => "Захищений каталог %1 на домені %2",
    'pdir_ed__pdir_for_subdomain' => "Захищений каталог %1 у субдомені %2",
    'pdir_ed__pdir_location' => "Розташування каталогу",
    'pdir_ed__pdir_users' => "Користувачі захищеного каталогу",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Потрібно вибрати хоча б один прапорець SSL/TLS або non-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Неможливо створити користувача захищеного каталогу: %1",
    'pdir_ed__unable_create_pdir' => "Неможливо створити захищений каталог: %1",
    'pdir_ed__unable_define_hst_type' => "Неможливо визначити тип хостингу.",
    'pdir_ed__unable_update_pdir' => "Неможливо зберегти налаштування захищеного каталогу: %1",
    'pdir_ed__wrong_symbol_in_header' => "Не слід використовувати символ %1 у заголовку каталога.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Створіть користувача для захищеного каталога: %1",
    'pdir_usr_ed__not_create_pass' => "Пароль нового користувача захищеної папки не буде створений.\nБез паролю користувач не зможе увійти у систему.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Пароль користувача захищеного каталога: %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Неможливо вибрати користувача захищеного каталога: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Неможливо призначити користувачів захищеного каталога: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Неможливо видалити користувачів захищеного каталога: %1",
    'phosting__anonftp_encrypt' => 'Пароль користувача FTP в зашифрованому вигляді, і, отже, не може бути використаним для захисту каталогу /plesk-stat/webstat/. Будь ласка, повторно введіть FTP пароль, або зніміть прапорець "доступно через захищений паролем каталог \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Доменне ім'я %%domain_name%% дозволяється в IP-адресу %%dns_ip_address%%. Вашому сайту призначено IP-адресу %%hosting_ip_address%%. Якщо ваш сайт не відкривається в оглядачі, коли ви звернетеся до нього за іменем домену, перейдіть до екрана управління DNS (Домени > Ім'я домену > DNS) і змініть властивості запису А ресурсу: призначте IP-адресу %%hosting_ip_address%% до доменного імені %%domain_name%%.",
    'phosting__ip_change_warning' => "IP-адреса змінена. Відповідні зміни також внесені до зони DNS домену.",
    'phosting__other_hosting_exists_on_ip' => "Неможливо змінити сертифікат ‒ дана IP-адреса вже використовується на одному чи декількох облікових записах вузла.",
    'phosting__unable_to_change_certificate' => "Неможливо встановити сертифікат: %1",
    'phosting__unable_to_change_ip_address' => "Неможливо змінити IP-адресу: %1",
    'phosting__unable_to_set_cert' => "Неможливо встановити сертифікат SSL/TLS: %1",
    'phosting__unable_update' => "Не можливо оновити параметри вузла: %1",
    'phosting__unable_manage' => "Управління вузлом неможливе: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Не вдалося налаштувати fail2ban на відстеження журналів домену. Вони будуть відстежуватися автоматично після наступного перезапуску сервісу fail2ban.\n%1",

    'picker_acl_record__tittle' => 'Виберіть запис ACL',
    'picker_autoresponder__title' => 'Виберіть автоматичну відповідь',
    'picker_black_list__domain_name' => 'Виберіть ім\'я домену',
    'picker_certificate' => 'Виберіть сертифікат SSL/TLS',

    'picker_dns_zone_template__title' => 'Виберіть запис ресурсу',
    'picker_domain__title' => 'Вибір веб-сайту',
    'picker_domain_alias__title' => 'Виберіть псевдонім домену',
    'picker_resource_record__title' => 'Виберіть запис ресурсу',
    'picker_disabled_resource_record__title' => 'Вибрати ім\'я серверу',
    'picker_ip_address__title' => 'Виберіть IP-адресу',
    'picker_ip_address_clients__title' => 'Виберіть замовників, які використовують цю IP-адресу',
    'picker_mail_queue' => 'Виберіть повідомлення електронної пошти',
    'picker_site_application__title' => 'Виберіть веб-застосунок',
    'picker_subdomain__title' => 'Виберіть мубдомен',
    'picker_web_user__title' => 'Виберіть веб-користувача',
    'picker_custom_button__title' => 'Виберіть користувацьку кнопку',
    'picker_license_key__title' => "Вибір ліцензійного ключа",
    'picker_spamfilter_address__title' => 'Виберіть адресу спам-фільтру',
    'picker_white_list__networks' => 'Вибір мережі',

    'plesk_key__action_logs' => "Реєстрація дій, які виконуються користувачами Plesk, у журналі",
    'plesk_key__app_vault' => "Сховище застосунків",
    'plesk_key__backup' => "Функції резервного копіювання та оновлення",
    'plesk_key__client_templs' => "Управління сервісними планами",
    'plesk_key__clients' => "Облікові записи користувачів (посередників та замовників)",
    'plesk_key__resellers_only' => "Облікові записи користувачів (посередників)",
    'plesk_key__customers_only' => "Облікові записи користувачів (замовників)",
    'plesk_key__domains' => "Домени",
    'plesk_key__domain_aliases' => "Псевдоніми домена",
    'plesk_key__manage_dashboard' => 'Налаштування домашньої сторінки',
    'plesk_key__drweb' => "Управління антивірусом",
    'plesk_key__event_manager' => "Менеджер подій",
    'plesk_key__expirations' => "Управління строками дії облікових записів",
    'plesk_key__group_ops' => "Модифікація кількох об’єктів одразу",
    'plesk_key__expiration' => "Строк дії ключа",
    'plesk_key__edition_name' => "Видання Plesk",
    'plesk_key__key_number' => "Ключовий номер",
    'plesk_key__languages' => "Мовні пакети",
    'plesk_key__mailnames' => "Облікові записи електронної пошти.",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Підтримка серверу Microsoft SQL",
    'plesk_key__myplesk_func' => "Посилання для придбання сертифікатів SSL/TLS та послуг з реєстрації доменів",
    'plesk_key__myplesk_server_id' => "Ідентифікатор допоміжного серверу MPC",
    'plesk_key__notifications' => "Управління повідомленнями",
    'plesk_key__postgresql' => "Підтримка серверу бази даних PostgreSQL",
    'plesk_key__qmail_queue' => 'Управління чергою електронної пошти',
    'plesk_key__remote_db' => 'Хостинг віддаленої бази даних',
    'plesk_key__slave_servers' => "Допоміжні сервери",
    'plesk_key__spamassassin' => "Управління спам-фільтром",
    'plesk_key__subdomains' => "Управління субдоменами",
    'plesk_key__sys_access' => "Управління доступом до сервера",
    'plesk_key__traffic_reports' => "Звіти про використання трафіку",
    'plesk_key__tts' => "Help Desk",
    'plesk_key__virtuozzo' => "Дійсний лише для Virtuozzo Containers",
    'plesk_key__webusers' => "Веб-користувачі",
    'plesk_key__license_update_date' => 'Наступне оновлення ліцензійного ключа',
    'plesk_key__autoinstaller_config' => 'Управління параметрами модулю оновлення',
    'plesk_key__check_wrong' => "Ліцензійний ключ недійсний. Для використання Plesk, будь ласка, отримайте та встановіть новий дійсний ліцензійний ключ.",
    'plesk_key__upload_check_wrong' => 'Вивантажений ліцензійний ключ не дійсний.',
    'plesk_key__revert_check_wrong' => 'Попередній встановлений ліцензійний ключ не дійсний.',
    'plesk_key__update_check_wrong' => 'Оновлений ліцензійний ключ не дійсний.',
    'plesk_key__viruozzo_only_key' => 'Ліцензійний ключ призначений для використання тільки з Plesk, працюючи всередині Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'Ви можете використовувати цю ліцензійну копію Plesk тільки за такими IP-адресами: %2 т. Наступні IP-адреси не забезпечуються вашою ліцензією: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Кількість ресурсів, що наразі використовуються, перевищує обмеження, встановлені вашою ліцензією.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Кількість розміщених на сервері веб-сайтів перевищує значення, встановлене вашою ліцензією. На даний момент на сервері розміщені %2 веб-сайти; ваша ліцензія дозволяє розмістити лише %1 веб-сайти.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Кількість псевдонімів доменів на сервері перевищує ліміт, визначений ліцензією. У вас є %2 псевдонімів доменів; ваша ліцензія дозволяє розміщувати лише %1 псевдонім доменів.',
    'plesk_key__limits_exceeded_lim_cl' => 'Кількість обслуговуваних облікових записів замовників перевищує значення, встановлене вашою ліцензією. На даний момент обслуговується %2 облікових записів замовників; ваша ліцензія дозволяє обслуговувати лише %1 облікових записів замовників.',
    'plesk_key__limits_exceeded_lim_mn' => 'Кількість обслуговуваних поштових облікових записів перевищує значення, встановлене вашою ліцензією. На даний момент обслуговується %2 поштових облікових записа; ваша ліцензія дозволяє обслуговувати лише %1 поштових облікових записів.',
    'plesk_key__limits_exceeded_lim_wu' => 'Кількість обслуговуваних облікових записів веб-користувачів перевищує значення, встановлене вашою ліцензією. На даний момент обслуговується %2 облікових записів веб-користувачів; ваша ліцензія дозволяє обслуговувати лише %1 облікових записів веб-користувачів.',
    'plesk_key__limits_exceeded_MLS' => 'Кількість встановлених на даний момент мовних пакетів перевищує значення, визначене вашою ліцензією. На даний момент встановлено %2 мовних пакетів; ваша ліцензія дозволяє лише %1 мовних пакета.',
    'plesk_key__wrong_version' => 'Ви спробували використовувати ліцензійний ключ, створений для іншої версії Plesk. Зверніться до торгових представників Plesk для отримання належного ліцензійного ключа.',
    'plesk_key__other_product' => 'Ви спробували використовувати ліцензійний ключ, створений для іншого продукту. Зверніться до торгових представників Plesk для отримання належного ліцензійного ключа.',
    'plesk_key__invalid_machine_id_trial' => 'Ваша поточна ліцензія недійсна, оскільки її вже активовано на іншому сервері Plesk. Аби продовжити користуватися Plesk, установіть нову ліцензію чи знову встановіть поточну ліцензію, ввівши відповідний код активації (за наявності).',
    'plesk_key__invalid_machine_id_retail' => 'Ваша поточна ліцензія недійсна, оскільки її вже активовано на іншому сервері Plesk. Ліцензійна угода WebPros (https://www.plesk.com/legal/) забороняє одночасне використання однієї ліцензії на двох або більше серверах. Аби продовжити користуватися Plesk, установіть нову ліцензію чи встановіть поточну ліцензію ще раз, ввівши її код активації. Його було надіслано вам електронною поштою при придбанні ліцензії. <br>Не можете знайти код активації? Відновіть його за допомогою Plesk 360. Для цього ввійдіть у систему на сайті https://platform360.io/, ввівши електронну адресу, яку ви використали для придбання ліцензії, потім перейдіть на вкладку "Licenses" та подивіться код активації вашої ліцензії. Також можна зв’язатися зі службою підтримки ліцензування та придбання Plesk за допомогою онлайн-форми (https://www.plesk.com/licensing-and-purchase-support/). Вкажіть номер ліцензії в розділі форми "How can we help you?".',
    'plesk_key__limits_exceeded_error' => 'Неможливо установити ліцензійний ключ — кількість ресурсів, які використовуються зараз, перевищує обмеження, встановлені вивантаженим ліцензійним ключем.',
    'plesk_key__limits_exceeded_note' => 'Кількість ресурсів, які використовуються зараз, перевищує обмеження, встановлені вивавантаженим ліцензійним ключем.',
    'plesk_key__key_file_invalid' => 'Вивантажений файл ключа не дійсний або не містить ліцензійного ключа.',
    'plesk_key__server_request_error' => 'Не вдалося оновити ліцензію. Переконайтеся, що з\'єднання з ліцензійним сервером ka.plesk.com на TCP-порті %1 не заблоковані. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Дізнайтеся, як це зробити</a>.',
    'key__no_key_file_in_zip' => 'Завантажений файл .zip не містить файлу ключа',
    'key__key_upload' => 'Установка ліцензійного ключа',
    'additional_key__prop_name' => 'Властивість',
    'additional_key__prop_value' => 'Значення',
    'additional_key__descr_name' => 'Ключове ім’я',
    'additional_key__descr_key_number' => 'Ключовий номер',
    'additional_key__descr_key_vz' => "Цей ліцензійний ключ призначений для використання тільки в Virtuozzo сontainers.",
    'additional_key__descr_key_mailboxes' => 'Поштові скриньки',
    'additional_key__descr_lim_date' => 'Дата закінчення строку дії',
    'additional_key__descr_license_update_date' => 'Наступне оновлення ліцензійного ключа',
    'additional_key__file_invalid' => 'Вивантажений файл ключа не дійсний або не містить ліцензійного ключа.',
    'additional_key__file_incompatible' => 'Вивантажений файл ключа не підходить для цього застосунку.',
    'additional_key__expired' => 'Строк дії додаткового ключа закінчився.',
    'additional_key__not_exists' => 'Ліцензійний ключ не встановлено.',
    'additional_key__viruozzo_only_key' => 'Цей ліцензійний ключ призначений для використання тільки з Plesk, встановленим в Virtuozzo сontainers.',
    'additional_key_update__result_response' => 'Відповідь серверу ліцензування: %1',
    'additional_key_update__result_network' => 'Не вдається підключитися до сервера ліцензування. Будь ласка, переконайтеся, що ваша мережа забезпечує зв\'язок для %1: %2.',
    'additional_key_update__result_lock' => 'Оновлення ключа вже виконується',
    'additional_key_update__result_internal_error' => 'Помилка при оновленні ліцензійного ключа: %1',

    'proceed_to_cl_pool' => "Продовжити налаштування пулу IP-адрес замовника",
    'proceed_to_hosting_setup' => "Продовжити налаштування параметрів хостингу",
    'removeCerts__remove_certificates_cp' => "Такі сертифікати будуть видалені:",
    'removeCerts__remove_certificates_domain' => "Такі сертифікати, які належать %1, будуть видалені:",
    'removeClientsIP_remove_clients_ip' => "IP-адреса буде видалена з пулів таких замовиків:",
    'removeMailAliases__remove_mail_aliases' => "Такі псевдоніми поштового облікового запису %1 будуть видалені:",
    'removeMailNames__remove_mailnames' => "Такі облікові записі електронної пошти та псевдоніми будуть видалені з домену %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Такі облікові записи електронної пошти та псеадоніми будуть видалені з домену %2, що належить замовнику %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Ці поштові облікові записи не будуть видалені.",
    'removeFtpSessions__remove_title' => "Такі сеанси FTP будуть завершені:",
    'removeTemplates__remove_templates' => "Такі шаблони будуть видалені:",
    'resp_edit__always_respond' => "відповідати завжди",
    'resp_edit__reply_subject' => "Тема відповіді",
    'resp_edit__answer_subject' => "Відповісти з вказанням теми",
    'resp_edit__answer_txt' => "Відповісти з текстом",
    'resp_edit__attach' => "Вкласти файли",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "для",
    'resp_edit__frw_rqst_email' => "Після автоматичної відповіді переслати вихідний лист на вказану електронну поштову адресу",
    'resp_edit__fwd_email_invalid' => "Некоректна електронна поштова адреса призначення.",
    'resp_edit__in_body' => "якщо вказані слова знайдені в тексті повідомлення",
    'resp_edit__in_subject' => "якщо вказані слова знайдені в темі повідомлення",
    'resp_edit__invalid_resp_freq' => "Некоректна частота відповіді.",
    'resp_edit__invalid_rqst_txt' => "Некоректний текст відповіді.",
    'resp_edit__invalid_store_lim_num' => "Некоректне значення ліміту",
    'resp_edit__limits_title' => "Обмеження",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Максимальна кількість відповідей за день перевищує визначену частоту відповіді. Дозволено: %1, очікується: %2",
    'resp_edit__no_files_sel' => "Не вибрано жодного файлу.",
    'resp_edit__no_txt_supplied' => "Текст не підтримується",
    'resp_edit__reply_title' => "Відповісти",
    'resp_edit__reply_to_address' => "Адреса повернення",
    'resp_edit__reply_to_invalid' => "Некоректна адреса повернення.",
    'resp_edit__reply_uniq_email' => "Відповісти на унікальну адресу електронної пошти не більше, ніж",
    'resp_edit__conditions_title' => "Умови",
    'resp_edit__request_title' => "Надіслати запит",
    'resp_edit__resp' => "Автовідповідач",
    'resp_edit__resp_name' => "Ім’я автовідповідача",
    'resp_edit__resp_not_exist' => "Автовідповідач не існує",
    'resp_edit__resp_status' => "Статус автовідповідача",
    'resp_edit__rqst_txt' => 'Вкажіть стан цього автовідповідача',
    'resp_edit__select_files_on_server_for_attach' => "Виберіть файли, які будуть вкладені",
    'resp_edit__store_up_to' => "Зберігати не більше",
    'resp_edit__subj_line_invalid' => "Некоректний рядок теми.",
    'resp_edit__text_too_big' => "Текст відповіді занадто великий",
    'resp_edit__times_in_a_day' => "разів на день",
    'resp_edit__unable_define_resp_cond' => "Неможливо визначити стан автовідповідача: %1",
    'resp_edit__unable_define_resp_status' => "Неможливо визначити статус автовідповідача: %1",
    'resp_edit__unable_turn_on_resp' => "Неможливо ввімкнути автовідповідач: %1",
    'resp_edit__uniq_email' => "унікальна адреса електронної пошти",
    'resp_edit__content_type' => 'Формат відправки електронної пошти',
    'resp_edit__content_type_text' => 'Звичайний текст',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Кодування',
    'restart__dns' => 'Сервер DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Сервер IMAP/POP3 (%1)",
    'restart__mssql' => "Сервер Microsoft SQL",
    'restart__mysql' => "Сервер MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Сервіси",
    'restart__smtp' => "Сервер SMTP (%1)",
    'restart__spamd' => "Спам-фільтр",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Веб-сервер (%1)",
    'restart__ftp' => "Сервер FTP (%1)",
    'restart__service_start' => 'Будь ласка, надайте сервісу якийсь час на запуск.',
    'restart__service_stop' => 'Будь ласка, надайте сервісу якийсь час на зупинення.',
    'restart__service_restart' => 'Будь ласка, надайте сервісу якийсь час на перезапуск.',
    'rm_domains__some_domains_are_not_exist' => "Деякі з зазначених доменів не існують. Можливо, вони були видалені іншим користувачем.",
    'rpt_cl_dom_data_bases' => "База даних MySQL",
    'rpt_cl_dom_mssql_data_bases' => "База даних MSSQL",
    'rpt_cl_dom_mail_groups' => "Поштові групи",
    'rpt_cl_dom_mail_lists' => "Списки розсилки",
    'rpt_cl_dom_mail_resps' => "Автовідповідач",
    'rpt_cl_dom_mail_antispam' => "Антиспам",
    'rpt_cl_dom_mail_antivirus' => "Антивірус",
    'rpt_cl_dom_postboxes' => "Поштові скриньки",
    'rpt_cl_dom_redirects' => "Переадресатори",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "Псевдоніми домену",
    'rpt_cl_dom_web_users' => "Веб-користувачі",
    'rpt_cl_report_for_admin__' => "Надайте звіт про адміністратора %1",
    'rpt_cl_report_for_reseller__' => "Надайте звіт про посередника %1",
    'rpt_cl_report_for_cl__' => "Надайте звіт про замовника %1",
    'rpt_cl_section_domains' => "Домени",
    'rpt_cl_section_full_domains' => "Домени",
    'rpt_cl_section_general' => "Загальні дані",
    'rpt_create' => "Створити звіт",
    'rpt_empty' => "Звіт має містити хоча б один розділ",
    'rpt_dom_report_for_dom__' => "Звіт про домен для %1",
    'rpt_dom_section_databases' => "Бази даних",
    'rpt_dom_section_full_databases' => "Бази даних",
    'rpt_dom_section_full_maillists' => "Переліки поштових розсилок",
    'rpt_dom_section_full_mailnames' => "Облікові записи електронної пошти.",
    'rpt_dom_section_full_webusers' => "Веб-користувачі",
    'rpt_dom_section_full_siteapps' => 'Веб-застосунки',
    'rpt_dom_section_full_aspnetapps' => 'Веб-застосунки ASP.NET',
    'rpt_dom_section_general' => "Загальні дані",
    'rpt_dom_section_hosting' => "Хостинг",
    'rpt_dom_section_maillists' => "Переліки поштових розсилок",
    'rpt_dom_section_mailnames' => "Облікові записи електронної пошти.",
    'rpt_dom_section_siteapps' => 'Веб-застосунки',
    'rpt_dom_section_aspnetapps' => 'Веб-застосунки ASP.NET',
    'rpt_dom_section_webusers' => "Веб-користувачі",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Редагувати звіт %1",
    'rpt_enter_email_address' => "Введіть адресу електронної пошти, на яку буде надісланий звіт.",
    'rpt_list' => "Шаблони спеціальних звітів",
    'rpt_section_full' => "Повний",
    'rpt_section_none' => "Немає",
    'rpt_section_summary' => "Сумарний",
    'rpt_default_full' => 'Повний звіт',
    'rpt_default_summary' => 'Зведений звіт',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Помилка посилки звіту: %1",
    'rpt_send_report_by_email_ok__' => "Звіт був відправлений до %1",
    'sa_action' => "Операція",
    'sa_action_del' => "Видалити",
    'sa_action_desc' => "Що робити зі спам-листом",
    'sa_action_save' => "Позначте як спам і збережіть в поштовій скрині",
    'sa_admin_blacklist' => "Чорний список адміністратора",
    'sa_admin_whitelist' => "Білий список адміністратора",
    'sa_db_del_confirm' => "Ви впевнені, що бажаєте очистити базу даних спам-фільтру?",
    'sa_eml_in_ignorelist' => "Лист в списку ігнорування",
    'sa_empty_email' => "Неможливо додати порожній шаблон електронного листа.",
    'sa_exists_email' => "Такий зразок електронної пошти вже існує.",
    'sa_disabled__mailname_not_filtering' => "Поточні налаштування серверу не дозволяють використовувати фільтрування листів для цього обліковому запису",
    'sa_disabled__filtering_is_disabled' => 'Фільтрування спаму було вимкнено адміністратором серверу',
    'sa_disabled__hasnt_mailbox' => "Неможливо увімкнути фільтрування спаму без поштового ящика",
    'sa_enable_filter' => "Увімкнути фільтрування спаму",
    'sa_forget' => "забути",
    'sa_from' => "Від",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Шаблон некоректний",
    'sa_spam' => "спам",
    'sa_trainer__page_title' => 'Тренування спам-фільтру',
    'sa_trainer__tools_legend' => 'Інструменти',
    'sa_trainer__info_legend' => 'Інформація',
    'sa_trainer__messages_list_legend' => 'Повідомлення у вашій поштовій скрині',
    'sa_trainer__c' => 'Т',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Тема',
    'sa_trainer__from' => 'Від',
    'sa_trainer__date' => 'Дата',
    'sa_trainer__info_text' => 'Повідомлення вивчене:%1 як спам, %2 як не спам, %3 загальне.',
    'sa_trainer__messages' => 'повідомлення',
    'sa_trainer__select__all' => 'Всі',
    'sa_trainer__select__spam_only' => 'Спам',
    'sa_trainer__select__ham_only' => 'Не спам',
    'sa_trainer__select__unknown_only' => 'Невідомий',
    'sa_trainer__cannot_remove_messages' => 'Неможливо видалити обрані листи з поштової скрині',
    'sa_trainer__remove_messages_confirm' => 'Ви впевнені, що бажаєте видалити вибрані повідомлення з поштової скрині?',
    'sa_subj' => "Тема",
    'sa_training' => "Тренування спам-фільтру",
    'sa_training_legend' => "Базове тренування фільтру",
    'sa_use_srv_settings' => "Застосувати загальносерверні параметри",
    'sa_user_blacklist' => "Чорний список користувача",
    'sa_user_whitelist' => "Білий список користувача",
    'sa_usr_disabled_by_srv' => "Індивідуальні спам-фільтри для користувача не дозволені адміністратором серверу",
    'sa_usr_no_postbox' => "Не вдалося увімкнути фільтрацію спаму, оскільки до цього облікового запису не підключена поштова скринька.",
    'sa_filters' => 'Спам-фільтри',
    'spamfilter__tools_legend' => 'Інструменти',
    'spamfilter__prefs_legend' => 'Налаштування',
    'spamfilter__max_children' => 'Максимальна кількість робочих процесів spamd для запуску',
    'spamfilter__rewrite_header_subject_hint' => 'Залиште це поле порожнім, якщо ви не бажаєте додава текст. Введіть _SCORE_, якщо ви бажаєте включити оцінювання до теми повідомлення.',
    'spamfilter__reject_spam' => 'Видаляти спам, коли він надходить до поштової скриньки',
    'spamfilter__enabled' => 'Увімкнено',
    'spamfilter_addresses_list__items' => 'адреси',
    'spamfilter_addresses__remove_title' => 'Такі адреси будуть видалені зі списку:',
    'spamfilter_addresses__empty_selection' => 'Жодної адреси не вибрано.',
    'server__admin_info' => "Інформація про адміністратора",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Введіть опис помилки нижче",
    'server__power_management' => "Управління продуктивністю",
    'server__services' => "Сервіси",
    'server__system' => "Система",
    'server__title' => "Адміністрування серверу",
    'server_preferences__admin_skin' => "Шкала інтерфейсу адміністратора",
    'server_preferences__default_language' => "Відсутність мови",
    'server_preferences__default_skin' => "Відсутність",
    'server_preferences__restart_apache_interval' => "Інтервал перезапуску Apache",
    'server_preferences__system' => 'Налаштування системи',
    'mail__tabs_preferences' => "Налаштування",
    'mail__tabs_white_list' => "Білий список",
    'server_preferences__use_vocabulary' => "Перевірте паролі для поштових скринь у словниках",
    'sessions__agreement' => "Так, я бажаю закінчити ці сеанси.",
    'sessions__select_sessions_for_remove' => "Оберіть сеанси, які мають буди закінчені",
    'sessions__tabs_cp_sessions' => 'Сеанси Plesk',
    'sessions__tabs_ftp_sessions' => 'Сеанси FTP',
    'sessions__ftp_sessions_login' => 'FTP ім’я користувача облікового запису',
    'sessions__ftp_sessions_domain' => 'Ім\'я домену',
    'sessions__ftp_sessions_path' => 'Поточне місце розташування',
    'sessions__ftp_sessions_file' => 'Назва файлу',
    'sessions__ftp_sessions_action' => 'Статус',
    'sessions__ftp_sessions_speed' => 'Швидкість, Кб/с',
    'sessions__ftp_sessions_comp' => 'Прогрес, %',

    'site_apps__access_level' => 'Рівень доступу',
    'site_apps__access_level_commercial' => 'Комерційний',
    'site_apps__access_level_free' => 'Вільний',
    'site_apps__action_installer' => "Установка веб-застосунку",
    'site_apps__action_reconfigure' => "Зміна конфігурації веб-застосунку",
    'site_apps__custom_button_level' => 'Ви бажаєте створити нову кнопку користувача для доступу до цього застосунку?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Ні',
    'site_apps__custom_button_level_domain_user_only' => 'Так',
    'site_apps__custom_button_level_false' => 'Ні',
    'site_apps__custom_button_level_domain' => 'Так, і зробіть її доступною тільки для поточного домену',
    'site_apps__custom_button_level_client' => 'Так, і зробіть її доступною для всіх доменів замовника',
    'site_apps__custom_button_level_admin' => 'Так, і зробіть її доступною для всіх доменів',
    'site_apps__description' => "Опис",
    'site_apps__dir_used_by_sapp__' => "Каталог \"%1\" використовується іншим веб-застосунком",
    'site_apps__dir_used_by_unknown__' => "Каталог \"%1\" вже існує. Його зміст перезапишеться, якщо ви продовжите.",
    'site_apps__dir_invalid_name__' => "Ім'я каталогу %1 невірне",
    'site_apps__file_name' => 'Файлове ім’я веб-застосунку',
    'site_apps__invalid_install_prefix' => "Невірний префікс установки",
    'site_apps__invalid_package' => "Веб-застосунок невірний",
    'site_apps__key_status' => 'Ліцензування',
    'site_apps__key_status_free' => 'Розповсюджується безкоштовно. Не треба жодного ліцензійного ключа',
    'site_apps__key_status_ok' => 'Необхідний ліцензійний ключ встановлено',
    'site_apps__key_status_problem' => 'Необхідний ліцензійний ключ не встановлено',
    'site_apps__name' => "Ім’я",
    'site_apps__no_domains' => 'Веб-застосунок не може бути встановлений. Існує вже інший веб-застосунок, встановлений в кореневому каталозі домену. Розгляньте можливість створення субдомену для веб-застосунку.',
    'site_apps__package_info_' => "Інформація щодо веб-застосунків",
    'site_apps__package_integrated' => "вбудований застосунок, неможливо видалити",
    'site_apps__pool_select_packages_to_add' => 'Виберіть веб-застосунки для додавання в пул',
    'site_apps__release' => "Позбавляти",
    'site_apps__resource_used_by_sapp' => "Цей ресурс використовується встановленим веб-застосунком",
    'site_apps__root_used_by_sapp' => "Цей ресурс використовується встановленим веб-застосунком",
    'site_apps__these_domains_will_not_delete' => 'Ці субдомени не будуть видалені',
    'site_apps__upload_site_app_pkg_title' => 'Вивантажте нові веб-застосунки',
    'site_apps__version' => "Версія",
    'site_apps__access_to' => "Доступ до %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Віртуальний шаблон хосту",
    'skeleton__client_label' => "%1 віртуальний хост шаблон",
    'skeleton__admin_page' => "Налаштуйте віртуальний шаблон хосту",
    'skeleton__files_list' => "Файли та каталоги",
    'skeleton__archiver_not_installed' => "Неможливо розпакувати архів. Архіватор, можливо, не установлений на сервері. Зверніться до {$PROD_NAME} адміністратора, щоб встановити програмне забезпечення архіватора.",
    'skeleton__client_page' => "Налаштуйте віртуальний шаблон хосту",
    'skeleton__archive_corrupted' => "Перевірка архіву виявила, що архівний файл пошкоджено або цей тип архіву не підтримується.",
    'skeleton__archive_too_large' => "Перевірка архіву виявила, що архівний файл занадто великий.",
    'skeleton__not_supported_archive_type' => "Цей тип архіву (file %1) не підтримується.",
    'skeleton__upload_archive_file' => "Додати архівний файл",
    'skin_download__title' => 'Завантажити зовнішню оболонку',
    'skin_download_now__title' => 'Відбувається завантаження зовнішньої оболонки',
    'skin_download_now__text' => 'Відбувається створення зовнішньої оболонки пакету. <br>Процедура може зайняти деякий час.<br> Коли з’явиться діалогове вікно, ви зможете продовжити роботу з Plesk.',
    'skin_file__help_for_using_types' => "Будь-ласка, користуйтесь зовнішніми оболонками архівів в таких форматах:",
    'skin_info__title' => 'Властивості зовнішньої оболонки',
    'skin_mng_err__rpm_not_skin' => 'Цей RPM не є пакетом зовнішньої оболонки Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Не вдалося встановити rpm-based зовнішню оболонку в зазначеному місці.',
    'skin_mng_err__already_exists' => 'Інсталяційний каталог зовнішньої оболонки вже існує, а також було запроваджено пакет зовнішньої оболонки.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Вивантажений файл не є допустимим пакетом зовнішньої оболонки RPM.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Вивантажений файл не є допустимим пакетом зовнішньої оболонки.',
    'skin_mng_err__rpm_upgrade_base' => "Вивантажений файл не є допустимим пакетом зовнішньої оболонки {$PROD_NAME}.",
    'skin_mng_err__rpm_upgrade_other' => 'Не вдається встановити зовнішню оболонку: невірний формат зовнішньої оболонки.',
    'skin_mng_err__no_a_skin' => "Вивантажений файл не є допустимим пакетом зовнішньої оболонки {$PROD_NAME}.",
    'skin_upload__title' => 'Вивантажити нову зовнішню оболонку',
    'skin_upload__already_exists' => "Зовнішня оболонка '%1' вже існує.",
    'skin_upload__unable_to_apply' => "Вивантажений файл не містить зовнішню оболонку Plesk, або ж не підтримується архівний формат.",
    'skin_upload__unable_to_rename__' => "Неможливо перейменувати зовнішню оболонку %2 на %1: %3.",
    'skin_upload__file_name' => 'Шлях до зовнішньої оболонки пакету файлу',
    'skins_list__title' => 'Сховище зовнішніх оболонок',
    'skins_remove__title' => 'Видалення зовнішніх оболонок',
    'skins_remove__select_skins_for_remove' => 'Виберіть зовнішні оболонки для видалення',

    'spf__unable_update' => 'Неможливо оновити параметри SPF',
    'statistics__active_domains' => "Активні домени",
    'statistics__clients' => "Замовники",
    'statistics__subdomains' => "Субдомени",
    'statistics__cpu' => "ЦП",
    'statistics__databases' => "Бази даних",
    'statistics__db_users' => "Користувачі бази даних",
    'statistics__dirs' => "Захищені каталоги",
    'statistics__dom_active' => "Працює",
    'statistics__dom_passive' => "Пасивний",
    'statistics__dom_problem' => "Проблема",
    'statistics__domains' => "Домени",
    'statistics__domains_with_host' => "Домени з хостингом",
    'statistics__doms' => "Домени",
    'statistics__filesystem' => "Система файлів",
    'statistics__general' => "Загальні дані",
    'statistics__hdd_available' => "Доступний",
    'statistics__hdd_capacity' => "Ємкість",
    'statistics__hdd_total' => "Повний",
    'statistics__hdd_usage' => "Використання жорсткого диску",
    'statistics__hdd_used' => "Використано",
    'statistics__ip' => "IP-адреса",
    'statistics__key_number' => "Ключовий номер",
    'statistics__l1' => "Останню хвилину",
    'statistics__l15' => "Останні 15 хвилин",
    'statistics__l5' => "Останні 5 хвилин",
    'statistics__la' => "CPU використання",
    'statistics__mail_autoresponders' => "Автовідповіді",
    'statistics__mail_boxes' => "Поштові скриньки",
    'statistics__mail_groups' => "Поштова група",
    'statistics__mail_lists' => "Переліки поштових розсилок",
    'statistics__mail_redirects' => "Відправники пошти",
    'statistics__mem' => "Використання пам’яті",
    'statistics__mem_usage' => "Використання",
    'statistics__memory_available' => "Доступний",
    'statistics__memory_buffer' => "Буфер",
    'statistics__memory_cached' => "Збережено",
    'statistics__memory_free' => "Вільний",
    'statistics__memory_shared' => "Спільного користування",
    'statistics__memory_total' => "Повний",
    'statistics__memory_used' => "Використано",
    'statistics__os' => "ОС",
    'statistics__problem_clients' => "Проблемні замовники",
    'statistics__problem_domains' => "Проблемні домени",
    'statistics__swap' => "Користування обміном",
    'statistics__swap_free' => "Вільний",
    'statistics__swap_total' => "Повний",
    'statistics__swap_usage' => "Використання",
    'statistics__swap_used' => "Використано",
    'statistics__system_stat' => "Інформація сервера",
    'statistics__unable_define_active_doms' => "Неможливо визначити кількість активних доменів : %1",
    'statistics__unable_define_inactive_doms' => "Неможливо визначити кількість неактивних доменів : %1",
    'statistics__failed_define_swap_usage' => 'Не вдалося визначити використання переключення',
    'statistics__failed_define_load_averages' => 'Не вдалося визначити середнє навантаження',
    'statistics__up_time' => "Час роботи системи:",
    'statistics__ver' => "Версія",
    'statistics__web_users' => "Веб-користувачі",
    'statistics__mem_win' => "Використання фізичної пам’яті",
    'statistics__memory_total_win' => "Повний",
    'statistics__memory_used_win' => "Використано",
    'statistics__memory_free_win' => "Доступний",
    'statistics__swap_win' => "Використання віртуальної пам’яті",
    'statistics__swap_total_win' => "Повний",
    'statistics__swap_used_win' => "Використано",
    'statistics__swap_free_win' => "Доступний",
    'status__domain_has_reasons_to_be_off' => "Робота домену все ще призупинена з певних причин : %1",
    'subdomain__create__' => "Створити субдомен в домені %1",
    'subdomain__edit__' => "Управляти субдоменом %1",
    'subdomain__invalid_name' => "Невірне ім’я субдомену: користуйтеся тільки чисельно-буквеними символами і символами тире.",
    'subdomain__incorrect_name' => "Неможливе ім’я субдомену",
    'subdomains__maillists_enabled_in_domain' => "Неправильні списки імен субдомену .%1: це ім’я домену уже використовується списками листування під доменом %1.",
    'subdomains__dalias_exists' => 'Псевдонім домену з таким ім’ям вже існує.',
    'subdomains__name_exists' => "Субдомен з таким ім’ям вже існує.",
    'subdomains__regular_domain_exists' => "Домен з таким ім’ям вже існує.",
    'subdomains__domain_alias_exists' => 'Псевдонім домену з таким ім’ям вже існує.',
    'subdomains__remove_subdomains_on_domain' => "Такі субдомени для домену %1 будуть видалені:",
    'subdomains__select_subdomains_for_remove' => "Оберіть субдомени для видалення",
    'subdomains__webmail_enabled_in_domain' => "Неправильне ім'я субдомену веб-пошти.%1: це доменне ім'я використовується для доступу до веб-пошти під доменом %1.",
    'subdomains__dns_record_already_exists' => 'Неможливо створити субдомен %1, оскільки вже є запис DNS, що вказує на хост %1.',
    'subdomains__www_prefix_in_domain' => "Неправильне ім’я субдомену www.%1: домен %1 вже має префікс WWW",
    'subdomains__user_type_quota_exceeds' => 'Неможливо змінити обліковий запис користувача, тому що це призведе до перевищення відведеного місця на диску.',
    'subdomains__creation_in_dns_slave' => "Іменний сервер Plesk діє як вторинний іменний сервер для цього домену. Для належного дозволу вашого субдомену переконайтесь, що файл зони на первинному сервері містить запис %1.",
    'sys_user__attributes_not_changed' => "\nАтрибути наступного системного користувача не були змінені: %1",
    'sys_user__no_access_without_password' => "Ви не налаштували пароль. Системний користувач буде створений, але не буде мати можливості увійти до системи, поки він/вона не надасть пароль. Бажаєте продовжувати?",
    'sys_user__no_hard_quota' => "не підтримується",
    'sysuser__zero_quota_is_unlimited' => "0 для необмежених",
    'template__num_excl_ips' => "Призначити виділені IP-адреси замовнику",
    'template__sel_sh_ips' => "Вибрані IP адреси спільного користування",
    'template__av_sh_ips' => "Доступні IP адреси спільного користування",
    'template__up_to_excl_ip' => "До %1 IP адрес",
    'templates__all_clients' => "всі замовники",
    'templates__cl_domain_templates' => "Шаблони для %1",
    'templates__cl_templates' => "Шаблони замовника",
    'time__invalid_ip' => "Невірна IP-адреса чи ім’я домену",
    '__please_select_country' => 'Оберіть країну',
    'time__unable_set_time' => "Неможливо налаштувати час системи: %1",
    'time__sinchronization_setup_error' => 'Неможливо налаштувати синхронізацію часу: збій timemng: %1',
    'time__sinchronization_disable_error' => 'Неможливо вимкнути синхронізацію часу: збій timemng: %1',
    'tmpl__create' => "Створіть шаблон",
    'tmpl__edit__' => 'Шаблон %1',
    'tmpl__logrotation_warn' => "Ротація журналів на домен, створений цим шаблоном, буде виконуватись тільки у випадку подальшого створення облікового запису фізичного хостингу для нього.",
    'tmpl__name' => "Ім'я шаблону",
    'tmpl__dom_exist' => "Шаблон домену з таким ім’ям вже існує в пулі шаблону адміністратора або замовника.",
    'tmpl__name_invalid' => "Ім’я шаблона недіюче чи порожнє",
    'tmpl__use_next_ip_addr' => "Буде використана наступна вільна IP-адреса",
    'tmpl_name_already_exists' => "Шаблон з ім'ям '%1' вже існує.",
    'traffic__no_periods_found' => "Не вдається відобразити веб-статистику і статистику трафіку. Ця функція буде доступна тільки після наступного підрахунку статистики.",

    'vh_based__no_free_ip_for_vh' => "Немає IP-адрес для реалізації віртуального хостингу на базі IP-адреси. Додайте, будь ласка, IP-адресу.",

    'wu__at_domains_text' => "Дозволити веб-користувачу@%1 формат доступу",
    'wu__unable_create' => "Неможливо створити веб-користувача: %1",
    'wu_edit__disk_quota' => "Дискова квота",
    'wu_edit__invalid_pass' => "Некоректний пароль.",
    'wu_edit__invalid_quota' => "Вказане значення квоти дискового простору некоректне. Вкажіть додатне ціле число.",
    'wu_edit__invalid_quota_value' => "Вказане значення квоти дискового простору менше, ніж те, що використовується зараз (%1 МБ). Деякі функції можуть стати недоступними. Ви впевнені, що бажаєте продовжити?",
    'wu_edit__not_create_pass' => "Ця операція не створить пароль нового веб-користувача. \nБез паролю користувач не зможе увійти у систему.",
    'wu_edit__unable_update' => "Неможливо оновити властивість веб-користувача: %1",

    'bt_webdirs' => 'Віртуальні каталоги',

    'dns__tabs_general' => 'Налаштування зони',
    'dns__tabs_zone_settings' => 'Записи SOA',
    'soa__seconds' => 'секунди',
    'soa__minutes' => 'хвилини',
    'soa__hours' => 'години',
    'soa__days' => 'дні',

    'DomainSubdirectory' => 'Цільовий підкаталог',

    'filemanager__select_codepage' => 'Вибрати кодову сторінку:',

    'bt_server_app_add' => 'Додати новий серверний застосунок',
    'packages_list' => 'Серверні застосунки',

    'bt_packages_management' => 'Управління пакетами',
    'pb__packages_management' => 'Управління застосунками',
    'bt_package_new' => 'Додати застосунок',
    '__packages' => 'Серверні застосунки',

    'dom_ctrl__mysql_dbase_space' => 'Квота бази даних MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Квота бази даних Microsoft SQL',

    'dns_add__enter_ixfr_path' => 'Введіть Шлях IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT-запис вже існує. Можливий тільки один SPF- запис. Щоб додати новий запис, видаліть попередній.',

    'component_name__network' => 'Комп’ютерна мережа',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Встановити зовнішню оболонку',
    'bt_set_skin' => 'Встановити зовнішню оболонку',
    'firewall__rule_already_exists' => 'Правило з ім\'ям "%1" вже існує',
    'firewall__rule_readonly' => 'Правило "%1" лише для читання',
    'pb__firewall' => 'Мережевий екран',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Недійсне розташування файлу.',

    'error_doc__erorr_invalid_url_location' =>  'Невірний формат URL. Будь ласка, введіть абсолютну URL-адресу в межах віртуального хосту (сайту).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Антивірус',
    'antivirus__antivirus' => 'Антивірусний захист',
    'antivirus__antivirus_direction_off' => 'Вимкнено',
    'antivirus__antivirus_direction_any' => 'Вхідна та вихідна пошта',
    'antivirus__antivirus_direction_from' => 'Тільки вихідна пошта',
    'antivirus__antivirus_direction_to' => 'Тільки вхідна пошта',
    'antivirus__unable_to_update_settings' => 'Не можу змінити налаштування антивірусу: %1',




    '__normal' => 'Нормальний',
    '__low' => 'Низький',
    '__high' => 'Високий',

    'mail__antivirus' => "Внутрішній антивірус поштового серверу",
    'mail__use_internal_antivirus' => 'Використовувати внутрішній антивірус',

    'sa__tabs_blacklist' => 'Чорний список',

    '__mysql_databases' => 'Бази даних MySQL',

    'cl_perm__mysql_dbase_space' => 'Квота бази даних MySQL',
    'cl_perm__mssql_dbase_space' => 'Квота бази даних Microsoft SQL',
    'cl_perm__max_mssql_db' => 'Максимальна кількість баз даних Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Загальна квота поштових скриньок',

    'i_i_cl_on' => 'Обліковий запис замовника активний.',
    'i_i_cl_off_by_admin' => 'Обліковий запис замовника призупинено адміністратором.',

    'sa_exists_tn' => 'Мережа уже в списку',

    'webdir__select_mime_types_to_remove' => 'Виберіть типи MIME, які потрібно видалити',

    'defaultcomponents__not_activated' => 'не активовано',

    'bt_traffic_at_domains' => 'Трафік',

    '__awstats_perl_warning' => 'Без установленого Perl, AWStats не дозволяє користвачам перевіряти статистику за попередні роки.',

    'class_client__mysql_dbase_space' => 'Значення перевищує ліміт клієнта.',
    'class_client__mssql_dbase_space' => 'Значення перевищує ліміт клієнта.',
    'class_client__max_mssql_db' => 'Значення перевищує ліміт клієнта.',

    'dns__remove_transfer_restrictions_list_items' => 'Такі мережі будуть видалені зі списку регулювання доступу:',

    'bt_up' => "Нагору",
    'bt_down' => "Зупинити",
    'virtualdir__type_default_doc_name_to_add' => 'Введіть назву файлу, який потрібно додати до списку',
    'virtualdir__select_default_doc_to_remove' => 'Виберіть файли, які будуть видалені зі списку',
    'virtualdir__select_directory' => 'Виберіть каталог',

    'bt_install_selected' => 'Встановити вибрані ліцензійні ключі', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Домен перетворює в іншу ІР-адресу: (%1). Будь ласка, виправте налаштування DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Поштовий сервер, що використовується на даний момент, не підтримує одночасного ввімкнення поштових скриньок та поштових груп. Натисніть ОК для ввімкнення поштових скриньок за рахунок вимкнення поштових груп. Натисніть Скасувати, щоб залишити все як є.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Поштовий сервер, що використовується на даний момент, не підтримує одночасного ввімкнення поштових скриньок та поштових груп. Натисніть ОК для ввімкнення поштових скриньок за рахунок вимкнення поштових груп. Натисніть Скасувати, щоб залишити все як є.',

    'mysql_dbase_space_limit' => 'Обмеження дискового простору для бази даних MySQL',
    'mysql_dbase_usage' => 'Використання дискового простору базою даних MySQL',
    'mssql_dbase_space_limit' => 'Обмеження дискового простору для бази даних серверу Microsoft SQL',
    'mssql_dbase_usage' => 'Використання дискового простору базою даних серверу Microsoft SQL',

    '__statistics' => "статистика", //indirect

    'dns__soa_minimum_value_is_big' => 'Встановлення мінімального TTL-значення, що є більшим за 3 години, може закрити доступ до ваших доменів деяким адміністраторам домену. Рекомендовано встановлювати таке значення тільки в разі, якщо на цьому наполягає реєстратор доменних імен.',

    'virusfilter__interface_not_available' => 'Недоступний жодний фільтр вірусів.',
    'virusfilter__none_virus_filter' => 'Немає',
    'virusfilter__mailname_status_text' => 'Антивірус (%1)',
    'virusfilter__status_none' => 'вимкнено',
    'virusfilter__status_any' => 'вхідна та вихідна електронна пошта',
    'virusfilter__status_outgoing' => 'тільки вихідна електронна пошта',
    'virusfilter__status_incoming' => 'тільки вхідна електронна пошта',

    'visibility__root_override_parse_error' => 'У файлі %1, рядок %2, знайдено синтаксичну помилку',

    'sb__not_support_publishing_api' => "Автоматична публікація не підтримується компонентами",

    'component_name__cphosting' => "Plesk хостинг",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Встановлення квоти для скриньок електронної пошти не підтримується поточним поштовим сервером.',
    '__unable_get_total_mboxes_quota' => 'Встановлення квоти для скриньок електронної пошти не підтримується поточним поштовим сервером.',

    'install_prefix__parent_not_exists' => "Батьківський каталог не існує.",

    'bt_change_version' => 'Змінити версію',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Вибрати все",
    '__uncheck_all' => "Очистити все",

    'dns__editing_domain_controller_zone' => "Редагування записів DNS-зони для контролера доменів можуть викликати проблеми у функціонуванні домену",

    'pb__interface_management' => "Управління інтерфейсом",
    'interface_management__tabs_skins' => "Зовнішня оболонка",
    'interface_management__tabs_interface_templates' => "Шаблони інтерфейсу",
    'interface_management__tabs_locales' => "Локалі",
    'locales_list__title' => "Сховище мовних пакетів",
    'locales_list__legend' => "Доступні мови",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Мовний пакет",
    'locales_list__lang_title' => "Мова",
    'locales_list__country_title' => "Країна",
    'locales_list__used_title' => "Використано",

    'backup__suspend_warning_during_backup' => "Домен буде недоступний протягом процесу резервного копіювання",
    'backup__suspend_warning_during_restore' => "Домен буде недоступний протягом процесу відновлення",
    'backup__suspend_domain' => "Призупинити домен",

    'locales_list__mls_limit' => "Ваша поточна ліцензія Plesk дозволяє використовувати %2 мов. На даний момент встановлено %1 мов, доступних для користувачів, що перевищує кількість мов, надану ліцензією. Вибиріть %2 мов, які ви будете використовувати та зробіть решту мов недоступними для користувачів, натиснувши на їх значки у стовпчику 'S'.",

    'bt_change_owner' => 'Призначити нового власника',
    'chown__new_owner' => 'Новий власник',
    'chown__selected_domains' => 'Вибрати підписки',
    'chown__limits_legend' => 'Ресурси',
    'chown__limit_name' => 'Ім’я ресурсу',
    'chown__limit_value' => 'Виділені ресурси',
    'chown__limit_assigned_before' => 'До передачі',
    'chown__limit_assigned_after' => 'Після передачі',
    'chown__error_limits' => "Неможливо продовжити передачу підписки ‒ для підписки потрібно більше ресурсів, ніж може надати постачальник нового власника.",
    'chown__error_no_domains' => 'Неможливо продовжити передачу підписки ‒ не вибрано жодної підписки або вибрані підписки вже належать кінцевому користувачу.',
    'chown__error_empty_ip_pool' => "Неможливо продовжити передачу підписки ‒ пул IP-адрес постачальника нового власника порожній. Переконайтесь, що постачальник має хоча б одну IP-адресу в пулі.",
    'chown__please_select_new_domain_owner' => 'Вибрати нового власника для цієї підписки',
    'chown__old_ip_address' => 'Поточна IP-адреса',
    'chown__new_ip_address' => 'Нова IP-адреса',

    'chown__error_ssl_already_used' => "Підтримка SSL/TLS вже використовується на таких цільових IP-адресах: %1 Тому наступні домени з підтримкою SSL/TLS не можуть бути передані: %2. Сконфігуруйте та спробуйте знову",
    'chown__sitebuilder_not_installed' => 'Presence Builder не встановлено',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Домен %1 не може бути переданий новому власнику, тому що Presence Builder не встановлений.',

    'backup__backup_time' => 'Тривалість створення резервної копії',
    'backup__backup_time_hour' => 'години',
    'backup__backup_time_minute' => 'хвилини',
    'backup__every' => 'кожний',
    'backup__day_of_month' => 'день місяця',

    'subdomain__select_hst_type' => 'Введіть тип хостингу для субдомену',
    'hst_sel__subdom_subfolder_hst' => 'Субдомен на субпапці',
    'subdomain__www_root_folder_not_exists' => 'Домашній каталог сайту %1 не існує',
    '__site_home_dir' => 'Домашній каталог сайту',
    'subdomain__aspnet_disabled_domain' => 'вимкнено доменом',

    'domains__remove_description' => 'Усі дані домену, в том числі налаштування та вміст домену і відповідних субдоменів, дані веб-застосунків, вміст поштових скриньок, електронна пошта, налаштування антивірусів та фільтрації спаму, журнали, дані сховища резервного копіювання домену та сертифікати SSL/TLS будуть видалені. Якщо ви не маєте резервну копію файлу на вашій локальній машині, всі дані будуть назавжди втрачені.',
    'subdomains__remove_description' => 'Всі дані субдомену, включаючи вміст і налаштування субдомену, дані веб-застосунків та журнали буде видалено. Якщо у вас немає резервної копії на місцевій машині, всі дані будуть назавжди втрачені.',

    'mail__tabs_spam_filtering' => 'Фільтрація спаму',
    'mail__tabs_antivirus' => 'Антивірус',
    'antivirus__use_server_settings_scan' => 'Використовувати налаштування сервера за замовчуванням (сканувати)',
    'antivirus__use_server_settings_no_scan' => 'Використовувати налаштування сервера за замовчуванням (не сканувати)',
    'antivirus__check_for_viruses' => 'Просканувати на наявність вірусів',
    'antivirus__dont_check_for_viruses' => 'Не сканувати на наявність вірусів',
    'antivirus__incoming_mail' => 'Вхідна пошта',
    'antivirus__outgoing_mail' => 'Вихідна пошта',

    'domain_alias__CNAME_dns_record_exists' => 'DNS CNAME-запис з таким ім\'ям вже існує',
    'domain_alias__A_dns_record_exists' => 'DNS А-запис з таким ім\'ям вже існує',
    'domain_alias__bad_prefix' => 'Неправильний префікс для псевдоніму домену',
    'domain_alias__domain_doesnt_exist' => "Домен не існує",

    'dns__zone_ttl_message_info' => 'Якщо значення TTL не вказано, для цього запису DNS буде використано значення TTL у шаблоні SOA-запису (%1).',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Файл з ім'ям index.html буде створений для перенаправлення до вибраного веб-застосунку. Якщо файл з ім'ям index.html вже існує, буде створена його резервна копія як index.html.old і замінена на новий. Натисніть ОК для підтвердження",

    'bt_ftp_ctrl' => "Додаткові облікові записи FTP",
    'ftp_users_no_permission' => "У вас не має прав для управління обліковими записами FTP для цього домену",
    'ftp_users_limit_reached' => "Для цього домену було досягнуто ліміт на кількість облікових записів FTP",
    'pb__ftp_ctrl' => "Управління FTP",
    'class_client__max_subftp_users' => "Додаткові облікові записи FTP",

    '__client_form_settings' => "Налаштування замовника",
    '__sbnet_client_keep_sbnet' => "Зберегти у Presence Builder відповідний обліковий запис користувача",
    '__sbnet_cant_add_more_sites' => "Для цього замовника досягнуто ліміту на кількість сайтів, які може використовувати Presence Builder",
    '__sbnet_legend_text' => "Інтеграція Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Створіть відповідний обліковий запис користувача в Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Ви намагаєтесь видалити обліковий запис користувача Presence Builder, пов’язаний з цим замовникаом. Це призведе до видалення з Presence Builder всіх веб-сайтів користувача та пов’язаних з ними параметрів, і втрати можливості редагувати існуючі веб-сайти за допомогою Presence Builder, навіть якщо ви ввімкнете цю опцію пізніше. Якщо створити обліковий запис користувача Presence Builder пізніше, доведеться створювати та розміщати всі ваші веб-сайти з нуля. Бажаєте вимкнути створення та розміщення веб-сайтів за допомогою Presence Builder?",
    'sb__build_site_with_subdomains' => "Створити блог і фотогалерею субдоменів",
    '__sbnet_client_dont_have_sbuser' => "Неможливо створити та опублікувати сайт за допомогою Presence Builder ‒ користувач Presence Builder не існує",

    '__component_disabled' => "Компонент вимкнений",

    'subdomains__physical_path_not_exist' => "Існують субдомени, приєднані до неіснуючих фізичних папок",

    'dnsserver_bind_to_msdns_switching_warning' => "Попередження: будуть передані тільки перші 254 ІР-адреси підмереж із /8 та /16 масками, розташованими у списку регулювання доступу. Вони будуть передані як окремі ІР-адреси. Бажаєте продовжити?",

    '__sbnet_net_framework_required_for_site' => "Сайти Presence Builder можуть вимагати підтримку ASP.NET 2.0 на вашому домені. Рекомендуємо ввімкнути підтримку ASP.NET 2.0, якщо ви використовуєте Presence Builder.",

    'subdomain_auto_create_dir' => "Створіть фізичну адресу для субдомену",

    'sa_trainer__unable_to_get_messages_list' => "Неможливо отримати список повідомлень в скрині: %1",
    'sa_trainer__pass_doesnt_exist' => "Пароль для цього поштового облікового запису втрачено",

    '__sitebuilder_error' => "Під час спроби під’єднатися до Presence Builder виникла помилка. Зверніться до постачальника послуг для вирішення проблеми.",
    'wsb_error_user_not_exist' => "Обліковий запис користувача Presence Builder не існує.",
    'wsb_error_site_already_exist' => "Цей сайт вже існує в Presence Builder.",
    'wsb_error_site_limit_reached' => "Досягнуто ліміт на кількість сайтів у Presence Builder.",
    'wsb_error_internal_error' => "Виникла внутрішня помилка Presence Builder. Зверніться до постачальника сервісів за допомогою.",
    'wsb_error_user_already_exist' => "Користувач Presence Builder з таким ім'ям вже існує в Presence Builder.",
    'sb_error_user_not_exist' => "Presence Builder користувач не існує.",
    'wsb_error_object_not_found' => "Presence Builder не знайшов коректний запис вузла.",

    'mg_no_mail_groups' => "Немає поштових груп",

    'drweb__drweb_incoming' => 'Антивірусна перевірка вхідної пошти',
    'drweb__drweb_outgoing' => 'Антивірусна перевірка вихідної пошти',
    'drweb__disable_reason_serv' => 'Сервер електронної пошти не підтримує налаштування фільтру антивірусу на рівні поштової скриньки',

    'vz_sitebuilder3_client_cant_be_created' => "Неможливо створити обліковий запис замовника — необхідно встановити SiteBuilder версії 3.1 або пізнішої",

    'chown__client_without_sitebuilder_support' => "Неможливо продовжити передачу підписки ‒ сервіс Presence Builder не включений у сервісний план нових власників або їх постачальників.",

    // new limits

    'class_client__max_odbc' => "З’єднання ODBC",
    'cl_perm__max_odbc' => "максимальна кількість ODBC зв’язків",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Псевдонім домену',
    'domain_alias__list_ascii_name' => 'У форматі ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Управління інтерфейсом',
    'pb__interface_templates' => 'Управління інтерфейсом',
    'pb__interface_clients' => 'Замовники, що використовують %1',

    // service management
    'bt_service_showall' => "Показати все",
    'bt_service_hideall' => "Приховати все",
    'bt_service_start' => "Запустити",
    'bt_service_stop' => "Зупинити",
    'bt_service_restart' => "Перезапуск",
    'bt_service_disable' => "Вимкнути",
    'bt_service_manual' => "Вручну",
    'bt_service_auto' => "Автоматично",
    'service_startup_auto' => 'Автоматично',
    'service_startup_manual' => 'Вручну',
    'service_startup_disabled' => 'Вимкнено',
    'service_action_ok' => "Операція з %1 сервісом завершена успішно",
    'service_action_failed_disabled_service' => "Неможливо завершити операцію з %1 сервісом тому, що він вимкнений.",
    'service_action_failed_error' => "Неможливо завершити операцію %1",
    'service_group_action_ok' => "Операція з даними сервісами була завершена успішно: \n %1",
    'service_group_action_disabled' => "Неможливо закінчити операцію з даними сервісами тому, що вони вимкнені: \n %1",
    'service_group_action_failed' => "Неможливо закінчити операцію з даними сервісами: \n %1. \n Для отримання детальної інформації про помилку, виконайте операцію з кожним сервісом окремо.",

    // php 4vs5
    'bt_php' => "РНР налаштування",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Доступні посередники',
    'massmail__resellers_list_selected' => 'Вибрані посередники',
    'massmail__clients_list_available_for_select' => 'Доступні замовники',
    'massmail__clients_list_selected' => 'Вибрані замовники',
    'massmail__advanced' => 'Додаткові параметри',
    'bt_massmail_send' => 'Надіслати',
    'massmail__save_template_name' => 'Зберегти текст в новому шаблоні з іменем',
    'massmail__template' => 'Шаблон',
    'massmail__compose_mail' => 'Повідомлення',
    'massmail__from' => 'Від',
    'massmail__to' => 'Одержувачі',
    'massmail__subject' => 'Тема',
    'massmail__body' => 'Текст повідомлення',
    'massmail__body_hint' => 'Змінна <name> використовується для автоматичної вставки імені користувача у повідомлення.',
    'massmail__send_to_clients' => "Замовники",
    'massmail__send_to_domainusers' => "Адміністратори домену",
    'massmail__send_to_admins' => "Адміністратори Plesk",
    'massmail_select' => 'Вибрати адреси',
    'massmail_showhide_selected' => "Показати/Сховати вибрані",
    'massmail_send_all' => "Всі",
    'massmail_send_selected' => "Лише вибрані",
    'massmail_send_except' => "Всі, крім вибраних",
    'bt_new_mass_mail_template' => "Додати шаблон групової розсилки",
    '__mass_mail_templates_list' => "Список шаблонів групової розсилки",
    'massmail__template_name' => 'Ім\'я шаблону',
    'massmail__receivers' => 'Одержувачі',
    'massmail__created' => 'Відправник',
    'massmail__date_created' => 'Дата створення',
    'massmail__compose' => 'Надіслати',
    'mass_mail__resellers_all' => 'Всі посередники',
    'mass_mail__clients_all' => 'Всі замовники',
    'mass_mail__domainusers_all' => 'Всі адміністратори домену',
    'mass_mail__resellers_selected' => 'Вибрані посередники',
    'mass_mail__clients_selected' => 'Вибрані замовники',
    'mass_mail__domainusers_selected' => 'Вибрати адміністраторів домену',
    'mass_mail__resellers_except' => 'Всі посередники, крім вибраних',
    'mass_mail__clients_except' => 'Всі замовники, крім вибраних',
    'mass_mail__domainusers_except' => 'Всі адміністратори домену, крім вибраних',
    'mass_mail__admins_all' => 'Всі адміністратори',
    'massmailtemplateslist__title' => 'Шаблони масових поштових повідомлень',
    'massmail__insert_from_template' => "Вставити дані з шаблону",
    'massmail__select_template' => "Вибрати шаблон",
    'massmail__body_short_hint' => "(лише у вигляді тексту)",
    'massmail__from_short_hint' => "(адреса пошти або ім’я)",
    'bt_insert' => "Вставити",
    'massmail__mail_send_successfully' => "Повідомлення надіслано успішно",
    'massmail__mail_send_successfully_with_some_errors' => "Повідомлення надіслано, але виникло декілька помилок. Деякі одержувачі можуть не отримати повідомлення. Більш детальна інформація наведена в журналі реєстрації: %plesk_dir%\\admin\\logs\\\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Повідомлення не надіслано. Будь ласка, переконайтеся, що вибрано принаймні одного одержувача ,і що поштовий сервер Plesk функціонує належним чином. Більш детальна інформація наведена у файлі реєстрації: %plesk_dir%\\\\admin\\\\logs\\\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Дані з шаблону %1 вставлені успішно.",
    'massmail__template_added_successfully' => "Шаблон повідомлення збережений під іменем %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Виникла помилка бази даних Presence Builder. Зверніться до свого постачальника послуг про допомогу.",
    'wsb_error_sitebuilder_access_denied_error' => "Помилка доступу до файлу ‒ Presence Builder не має прав для доступу до необхідного файлу або папки. Зверніться до свого постачальника послуг про допомогу.",
    'wsb_error_sitebuilder_connection_failed' => "Неможливо підключитись до Presence Builder, тому що з’єднання втрачено. Зверніться до свого постачальника послуг про допомогу.",
    'wsb_error_critical_during_operation' => "Виникла критична помилка Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "Виникла помилка ліцензії Presence Builder:\n%1",
    'wsb_error_during_operation' => "Виникла помилка Presence Builder:\n%1",
    'wsb_error_license_error' => "Виявлені обмеження ліцензії Presence Builder.",

    // Other
    '__confrim_service_stop' => "Попередження! Якщо ви зупините сервіс %1, Plesk може перестати працювати. Ви впевнені, що бажаєте зупинити сервіс %1?",
    'virtualdir__name_is_reserved' => "Це ім’я зарезервоване",
    'index_redirect_help_text' => 'Зараз ви автоматично переадресуєтесь на необхідний веб-сайт. Якщо ваш оглядач не підтримує переадресацію, натисніть %1 тут %2',
    'bt_default_settings' => "Відновити налаштування за замовчуванням",
    'logfiles__remove_failed' => "Неможливо видалити файл %1 — файл заблокований іншим застосунком. Спробуйте ще раз пізніше",
    'subdomain__invalid_homedirectory' => "Зазначений субдомен домашнього каталогу є недійсним",
    'scheduler_item__empty_filename' => "Будь-ласка, визначте файл для виконання",
    'subdomains__overlapped_domain_exists' => 'Домен перекривається DNS-зоною домену %1',
    'subdomains__overlapped_domain_alias_exists' => 'Домен перекривається DNS-зоною псевдоніма домену %1',
    'services_action_none_selected' => 'Неможливо завершити операцію: виберіть потрібні сервіси',
    'cl_perm__max_subftp_users' => "максимальна кількість додаткових облікових записів FTP",
    'login_up__access_denied_no_cp_access' => 'Доступ заборонено. Ви не маєте дозволу на доступ до Plesk.',
    'drweb__disable_reason_admin' => "Налаштування фільтру антивірусу на рівні поштової скриньки не дозволяються політикою серверу.",

    'webdirs__name_is_invalid' => 'В імені каталога слід використовувати лише чисельно-буквені символи, дефіс та символ підкреслювання.',
    'webdirs__physical_path_is_invalid' => 'Фізичний шлях некоректний або не існує',
    '__use_default' => 'Застосувати налаштування за замовчуванням',

    'webalizer_hidden_referrer__already_exist' => 'Такий запис вже існує.',
    'webalizer_group_referrer__already_exist' => 'Групове посилання з таким ім’ям вже існує.',

    'pb__dashboard' => 'Головна сторінка',

    'server_interface__page_title' => 'Налаштування інтерфейсу сервера',
    'server_interface__tabs_locales' => 'Локалі',
    'server_interface__tabs_skins' => 'Зовнішня оболонка',
    'server_interface__tabs_interface_templates' => 'Шаблони інтерфейсу',
    'bt_server_interface' => 'Параметри інтерфейсу',
    'pb__server_interface' => 'Параметри інтерфейсу',

    'bt_wizard_next' => 'Далі >>',
    'bt_wizard_prev' => '<< Назад',

    '__limit_exceeded_max_dom_server' => 'Неможливо розмістити більше доменів на цьому сервері ‒ досягнуте обмеження кількості доменів на сервері, яке визначається ліцензійним ключем. Зверніться до свого постачальника послуг для вирішення цієї проблеми.',
    '__limit_exceeded_max_subdom_server' => 'Ви не можете розташовувати більше субдоменів на цьому сервері. Будь ласка, зверніться до постачальника послуг.',
    '__limit_exceeded_max_dom_aliases_server' => 'Ви не можете більше встановлювати псевдоніми доменів на цьому сервері. Будь ласка, зверніться до постачальника послуг.',
    '__limit_exceeded_max_wu_server' => 'Неможливо розмістити більше веб-користувачів ‒ досягнуто ліміту на кількість веб-користувачів на сервері, яке визначається ліцензійним ключем. Зверніться до свого постачальника послуг для вирішення цієї проблеми.',
    '__limit_exceeded_max_mn_server' => 'Неможливо розмістити більше поштових облікових записів ‒ досягнуто ліміту на кількість поштових облікових записів на сервері, яке визначається ліцензійним ключем. Зверніться до свого постачальника послуг для вирішення цієї проблеми.',

    '__limit_exceeded_max_cl_useradmin' => 'Ви досягли ліміту на кількість поштових скриньок, визначених вашим ліцензійним ключем (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Ви досягли ліміту на кількість псевдонімів доменів, яке визначається ліцензійним ключем (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Ви досягли ліміту на кількість субдоменів, визначених вашим ліцензійним ключем (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Ви досягли ліміту на кількість псевдонімів доменів, яке визначається ліцензійним ключем (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'У вас не залишилось вільного дискового простору',
    '__limit_exceeded_max_wu_useradmin' => 'Ви досягли ліміту на кількість облікових записів веб-користувачів, визначених вашим ліцензійним ключем (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Ви досягли ліміту на кількість баз даних, визначених вашим ліцензійним ключем (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Ви досягли ліміту на кількість поштових скриньок, визначених вашим ліцензійним ключем (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Ви досягли ліміту на кількість облікових записів електронної пошти, визначених вашим ліцензійним ключем (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Ви досягли ліміту на кількість списків поштових розсилок, визначених вашим ліцензійним ключем (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Ви досягли ліміту на кількість доменів (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Ви досягли ліміту на кількість субдоменів (%2), дозволених вашим постачальником послуг',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Ви досягли ліміту на кількість псевдонімів доменів (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Ви досягли ліміту на використання дискового простору (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Ви досягли ліміту на ступінь використання смуги пропускання на місяць (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Ви досягли ліміту на кількість облікових записів веб-користувачів (%2), визначеного вашим постачальником послуг.',
    '__limit_exceeded_max_db_userclient' => 'Ви досягли ліміту на кількість баз даних (%2)',
    '__limit_exceeded_max_box_userclient' => 'Ви досягли ліміту на кількість поштових скриньок (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Ви досягли ліміту на кількість списків поштових розсилок (%2)',
    '__limit_exceeded_expiration_userclient' => 'Строк дії вашого облікового запису закінчився %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Ви досягли ліміту на кількість субдоменів (%2), дозволених вашим постачальником послуг',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Ви досягли ліміту на кількість псевдонімів доменів (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Ви досягли ліміту на використання дискового простору (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Ви досягли ліміту на ступінь використаної смуги пропускання на місяць (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Ви досягли ліміту на кількість облікових записів веб-користувачів (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Ви досягли ліміту на кількість баз даних (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Ви досягли ліміту на кількість поштових скриньок (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Ви досягли ліміту на кількість списків поштових розсилок (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Строк дії вашого облікового запису закінчився %2',

    'mmt__to_none' => 'Немає',
    'mmt__to_admin' => 'Адміністратор',
    'mmt__to_resellers_all' => 'Всі посередники',
    'mmt__to_resellers_select' => 'Вибрані посередники',
    'mmt__to_resellers_select__available' => 'Доступні посередники',
    'mmt__to_resellers_except' => 'Всі посередники, крім вибраних',
    'mmt__to_clients_all' => 'Всі замовники',
    'mmt__to_clients_select' => 'Вибрані замовники',
    'mmt__to_clients_select__available' => 'Доступні замовники',
    'mmt__to_clients_except' => 'Всі замовники, крім вибраних',

    'mmt__unable_send_empty_selection' => 'Неможливо відправити масову електронну пошту, жодної адреси електронної пошти не вибрано.',
    'mmt__unable_send_to__' => 'Неможливо відправити масову електронну пошту:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Не можу затвердити веб-застосунок, оскільки один з необхідних файлів (%1) не було знайдено. Зверніться до представника технічної служби для вирішення проблеми.',
    'sapp_error_validation_spec_failed' => 'Вивантажений веб-застосунок не відповідає технічним умовам AppPacks: %1.',
    'sapp_error_validation_register' => 'Не можу зареєструвати веб-застосунок, що знаходиться в каталозі "%1": %2 Вам необхідно видалити веб-застосунок з серверу, оскільки він не буде коректно функціонувати.',

    'sapp__install_failed' => 'Установку веб-застосунка не завершено %1',
    'sapp__install_res_failed' => 'Не вдалося створити запитаний ресурс.',

    'server_preferences__subdomains_blog_and_photo' => 'Створіть блог і фотогалерею замовчуванням',
    'plesk_key__blog_and_photo' => 'Прапорець, який дає можливість управляти станом за замовчуванням субдоменів Створити блог та Фотогалерея',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Ви не можете змінити тип IP-адреси на виділену, тому що вона призначена декільком користувачам.',

    // 8.1.1

    '__write_modify_warning' => 'Вибір додаткових прав на запис/редагування призведе до більш коректної роботи деяких веб-застосунків, але також значно збільшить ризик порушення безпеки',
    '__write_modify_subdomain_warning' => 'Вибір додаткових прав на запис/редагування призведе до більш коректної роботи деяких веб-застосунків, але також значно збільшить ризик порушення безпеки',

    'phosting__php_incorrect_version_used' => "Виявлені проблеми версії PHP. Для вирішення проблем виберіть нижче прапорець з необхідною версією PHP та натиснути ОК. Для вимкнення PHP на цьому домені натисніть, не вибираючи версію PHP",
    'fp__mail_preferences' => 'Налаштування пошти',

    'mail__invalid_white_pattern' => 'Вказане ім’я некоректне. Слід використовувати такі формати: "mail@example.com" для адрес електронної пошти, "example.com" для доменів.',
    'mail__invalid_black_pattern' => 'Вказане ім’я некоректне. Слід використовувати наступний формат: "mail@example.com" для адрес електронної пошти, "example.com" для доменів.',

    'resp_edit__reply_as_html' => 'Надіслати як HTML',
    'exception__path_very_long' => "Шлях занадто довгий. Будь ласка, переконайтесь, що кількість символів шляху менша, ніж %1.",

    // 8.2


    //SAPP
    'sapp_on' => 'Увімкнути',
    'sapp_off' => 'Вимкнути',
    'sapp_directive_aspect' => 'Необхідно',
    'sapp_databases_num' => 'Бази даних',
    'sapp_db_required' => 'Необхідно',
    'sapp_Required' => 'Необхідно',
    'sapp_Variant' => 'Варіант',
    'sapp_db_id' => 'Ідентифікатор бази даних',
    'sapp_db_id_type' => 'Тип бази даних (ідентифікатор: %1)',
    'sapp_db_id_min_version' => 'Мінімальна версія бази даних (ідентифікатор: %1)',
    'sapp_db_id_table_prefix' => 'Префікс таблиць бази даних (ідентифікатор: %1)',
    'sapp_Default' => 'Значення за замовчуванням',
    'sapp_apache_mod_req' => 'Модуль Apache',
    'sapp_dbtype_not_installed' => 'не установлений',
    'sapp_apache_mod_not_installed' => 'не установлений',
    'sapp__value_error_empty' => 'Порожні значення не допускаються',
    'sapp_error_invalid_type' => 'Застосунок "%1" не підтримує запитану операцію.',
    'sapp_error_unknown_app_type' => 'Тип застосунку не підтримується: %1.',
    'sapp__ssl_text' => 'Встановити застосунок для http:// чи https:// віртуального хосту?',
    'sapp__app_to_upgrade' => 'Застосунки, які потрібно оновити до новішої версії',
    'sapp__upgrade_apps_title' => 'Оновити застосунки до новішої версії',
    'sapp__upgrade_to_ver' => 'Оновити до версії',
    'sapp__choose_pkg_ver' => 'Виберіть пакет ...',
    'sapp__pkg_cant_upgrade_pkg' => 'Цей пакет "%1" не може бути використаний для оновлення веб-застосунка до новішої версії "%2".',
    'sapp__app_ugrade_error' => 'Неможливо оновити застосунок до новішої версії: %1. Будь-ласка, зверніться до вашого системного адміністратора.',
    'sapp__no_suitable_db_found' => 'Підходяща база даних не знайдена',
    'sapp__upgrade_success' =>  'Застосунок успішно оновлено до новішої версії',
    'sapp__pkg_info_changelog' => 'Історія змін',
    'sapp_requirement_legend' => 'Особливості хостингу, необхідні для застосунка',

    // other
    'bt_apply' => 'Застосувати',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Для створення псевдоніму поштового облікового запису поштова скринька повинна бути ввімкнена у цьому поштовому обліковому записі. Увімкнути поштову скриньку?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Вимкнення поштової скриньки призведе до видалення псевдонімів, після того як вони перестануть працювати. Вимкнути поштову скриньку?',
    'antivirus__disable_reason_install' => 'Ви не можете управляти антивірусом, тому що він не встановлений.',
    'antivirus__disable_reason_key' => 'Ви не можете управляти антивірусом, тому що він ще не активований за допомогою ліцензійного ключа.',
    'antivirus__disable_reason_deny_personal_settings' => 'Ви не можете управляти антивірусом, тому ще політика серверу забороняє індивідуальні налаштування антивірусу.',
    'change_foreign_user_password' => 'Змінити пароль',
    'change_foreign_user_password_hint' => "Користувач не належить цьому застосунку. Натисніть на посилання для переходу до іншго застосунку і змініть пароль користувача там. Для виконання цього вам потрібно мати відповідні права в застосунку.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Формат рядка',
    'lang_unknown' => 'Невідома мова',
    'pb__cl_ed' => 'Детальна інформація користувача',
    'pb__actionlog' => 'Журнал операцій',
    'pb__cl_limits' => 'Обмеження користувача',
    'pb__edit' => 'Редагувати',
    'pb__subdom_edit' => 'Налаштування хостингу',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Зберегти вміст поштових скриньок',

    'maillist_import_result' => "\nЗагальна кількість адрес електронної пошти в файлі: %1\nкількість імпортованих адрес електронної пошти: %2\nкількість вже існуючих адрес електронної пошти: %3\nкількість дубльованих адрес електронної пошти у вказаному файлі: %4\nкількість некоректних адрес електронної пошти у файлі: %5",
    'maillist_import_error' => 'Неможливо імпортувати список адрес електронної пошти',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Файл, який ви обрали, є порожній чи недійсний HTML документ в вибраному декодуванні. Будь-ласка, виберіть правильне декодування чи просто додайте до файлу вміст.",

    'dom_pref__external_mail_srv' => "Перенаправити до зовнішнього поштового серверу з IP-адресою:",
    'mn_edit__store_messages' => 'Поштова скринька',

    // aps

    'sapp__before_upgrade_notice' => 'Рекомендується створити резервну копію застосунка та даних користувача, перш ніж почати процес оновлення.',
    'sapp__application_properties' => 'Властивості застосунка',
    'sapp__application_root_descr' => 'Головна сторінка застосунка',

    'sapp__aps_license_invalid_id' => 'Ліцензійний ключ має неприпустимий ID: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Ліцензія з номером ключу %1 вже існує в базі даних.',
    'sapp__aps_lic_del_used' => 'Неможливо видалити ліцензійний ключ, він використовується одним зі встановлених застосунків.',
    'sapp__aps_lic_del_unknown' => 'Неможливо видалити ліцензійний ключ: %1',
    'sapp__aps_cappi_duplicate' => "Цей застосунок вже є в пулі застосунів замовника",
    'sapp__appi_not_shared_no_install' => "Немає такого застосунка в пулі застосунків замовника. Якщо ви бажаєте встановити цей застосунок на сайт, вам треба спершу додати цей застосунок до пулу застосунків замовника.",
    'sapp__appi_shared_not_client' => "Немає такого застосунка в пулі застосунків замовника. Якщо ви бажаєте оновити застосунок до вибраної версії, вам треба спершу додати цю версію застосунка до пулу застосунків замовника.",
    'sapp__apply_license_script_not_found' => 'Неможливо найти напис "Застосувати-ліцензію" для цього веб-застосунка.',
    'sapp__unable_to_activate_key' => 'Сталася помилка при спробі активувати ліцензійний ключ %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Є встановлені веб-застосунки, які вимагають присутності цього веб-застотсунку в системі.',
    'sapp__unable_to_delete_ai_in_pool' => 'Цей застосунок все ще перебуває в пулі замовника. Якщо ви бажаєте видалити цей застосунок, вам в першу чергу необхідно видалити його з усіх пулів застосунків замовника або зробити його безкоштовним.',
    'sapp__unable_to_delete_app_template' => 'Неможливо видалити застосунок #%1: %2',
    'sapp__limit_exceeded_client' => 'Ви досягли ліміту на кількість разів установки цього застосунка (%2).',


    // atis module

    '_week_on' => 'тиждень на',
    '__week_first' => 'перший',
    '__week_second' => 'другий',
    '__week_third' => 'третій',
    '__week_fourth' => 'четвертий',
    '__week_last' => 'останній',
    '__not_started' => 'Очікування',
    '__started' => 'Працює',
    '__cancel_pending' => 'Скасовується',
    '__canceled' => 'Скасовано',
    '__error' => 'Помилка',
    '__done' => 'Завершено',

    '__php_cgi_handler' => 'Застосунок CGI',
    '__php_isapi_handler' => 'Розширення ISAPI',
    '__php_fastcgi_handler' => 'Застосунок FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'запустити як',

    'cf_dbfolder_text' =>'Папка бази даних',
    'cf_isnewdb_text' => 'Створити базу даних',
    'cf_isnewdb_title' => 'Виберіть прапорець, якщо необхідно створити базу даних',

    'pb__site_apps_upgrade' => 'Оновлення веб-застосунків',

    'detach' => 'Роз’єднати',
    'preferences' => "Змінити пароль",

    'toolsbar__switch_user?' => "Ви впевнені, що бажаєте увійти до системи під ім’ям іншого користувача?",
    '__aps_left' => 'Залишилось установити',
    'aps__license_key' => 'Ліцензійний ключ',
    'aps__download_code' => 'Завантаження ліцензійного ключа та активаційного коду',
    'aps__license_key_hint' => 'Отримайте з ліцензійного серверу, використовуючи активаційний код',
    'aps__database_not_available' => 'недоступний, будь ласка, перевірте обмеження домену або замовника',
    'aps__yes' => 'так',
    'aps__no' => 'ні',
    '__click_to_enlarge' => 'Натисніть для збільшення',
    'site_apps__back_to_list' => 'Повернутись до списку',
    'sapp__pkg_info_installation_requirements' => 'Вимоги для установки',
    '__close_window' => 'Закрити',

    //SAPP END

    'skin_info__already_default' => 'Зовнішню оболонку вже зазначено як непрацюючу.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Налаштування Plesk Premium Antivirus для %1',
    'drweb:properties_legend' => 'Налаштування',
    'drweb:status' => 'Перевірка електронної пошти на віруси',

    // sb integration
    'sitebuilder_wizard' => 'Майстер налаштування Presence Builder',
    'dom_site_builder' => 'Натисніть, щоб відкрити майстер Presence Builder.',
    'sb_plesk_admin_url' => 'URL серверу Presence Builder. Переконайтеся, що ця адреса дозволяється належним чином у DNS',
    'sb_plesk_admin_login' => 'Ім\'я користувача для входу адміністратора сервера до системи Presence Builder',
    'sb_plesk_admin_password' => 'Пароль адміністратора',
    'sb_sitebuilder_preferences' => 'Облікові дані адміністратора Presence Builder',
    'sb__server' => 'Параметри адміністратору системи Presence Builder',
    'sb__sitebuilder_support' => 'Presence Builder підтримка',
    'sb_keep_sb_user' => 'Зберегти у Presence Builder відповідний обліковий запис користувача',
    'sb_create_sb_user' => 'Створіть відповідний обліковий запис користувача в Presence Builder',
    'sb__build_site_using_sitebuilder' => "Створити сайт за допомогою Presence Builder",
    'sb_no_current_sb_server_set' => 'Підключення до Presence Builder ще не налаштовано: вам потрібно додати запис A до шаблону зони DNS, який буде вказувати на сервер Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Не вдалося отримати інформацію з системи Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Не вдається підключитися до Presence Builder: Неправильне ім'я користувача або пароль.",
    'sb_init_sb_manager' => "Менеджер Initializing Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Не вдалося підключитися до системи Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Цей клієнт не має облікового запису користувача в Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder не налаштований.",
    'sb_err_you_dont_have_sbaccount' => "Не вдалося авторизувати вас у Presence Builder.",
    'sb_error_critical_during_operation' => "Наступна помилка трапилась в Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Підтримку єдиного входу не увімкнено в Plesk.",

    'warning__super_zone_exist' => "Зона %1 створена, але ім’я цієї зони є допоміжною зоною іншої існуючої зони %2, яка належить іншому користувачу %3. Це можливо, але переконайтесь, що Ви вибрали правильний обліковий запис користувача.",
    'error__super_zone_exist' => "Неможливо створити зону DNS через приналежність її надзони до іншого користувача.",

    'locales__files_not_exits' => 'Неможливо змінити мовний стандарт — файли вказаного мовного пакету інтерфейсу відсутні в системі.',
    'locales__unavailable' => 'Неможливо змінити мовний стандарт — вказаний мовний пакет інтерфейсу недоступний.',

    // DB BU

    'pb__dbbackup_list' => 'Резервні копії файлів бази даних',
    // server
    'dbbackup__server_backup_settings' => 'Резервне копіювання',
    'dbbackup__network_temp_dir' => 'Каталог тимчасової мережі',
    'dbbackup__network_user' => 'Ім\'я користувача',
    'dbbackup__network_pass' => 'Пароль',
    // domain
    'dbbackup__add_database_legend' => 'Відновити резервну копію бази даних',
    'dbbackup__add_database_restore' => 'Відновити базу даних із файлу резервної копії',
    'dbbackup__add_database_file' => 'Резервна копія файлу бази даних',
    'dbbackup__add_database_user' => 'Ім’я користувача за замовчуванням',
    'dbbackup__add_database_pass' => 'Пароль користувача за замовчуванням',
    'dbbackup__add_database_pass2' => 'Підтвердження паролю користувача за замовчуванням',

    'bt_dbbackup_now' => 'Зробити резервну копію',

    'bt_repair' => 'Відновити',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Завантаження дампу з бази даних SQL-сервера заборонено хостинг-постачальником.',

    // APS categories

    'cf_invalid_password' => 'Пароль має складатись не більше, ніж з 16 символів',
    'cf_invalid_description_length' => 'Опис має складатись не більше, ніж з 256 символів',
    'ip_addr__ip_used_by_external_mail_server' => 'ІР-адреса %1 уже використовується зовнішнім поштовим сервером',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Некоректне ім’я користувача або пароль облікового запису FTP. Введіть правильні облікові дані користувача FTP.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Було досягнуто максимальної кількості змін серійного номеру. На сьогодні виконання змін DNS зони неможливе.',
    'dns__zone_apply_changes' => 'Зміни, внесені до записів DNS, ще не було збережено. Внесені зміни виделені нижче. Натисніть Оновити, щоб застосувати зміни до зони DNS, або натисніть Повернутись, щоб скасувати зміни.',
    'dns__update_dns_zone' => 'Натисніть, щоб зберегти зміни, внесені до записів DNS',
    'dns__revert_dns_zone' => 'Натисніть для скасування змін, зроблених у записах DNS',
    'bt_revert' => 'Повернути',
    'dns__dns_zone_has_beed_updated' => 'Зміни до DNS-записів збережено.',
    'dns__dns_zone_has_beed_reverted' => 'Зміни до DNS-записів скасовано',
    'db__nondefault_server_not_allowed' => 'Не дозволяється використання сервера бази даних не за замовчуванням',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Обліковий запис та домени замовника %1.',
    'ui__client__disabled-warning' => 'Обліковий запис клієнта %1 призупинено.',
    'ui__client__none-available' => 'Немає налаштованих облікових записів замовника.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Замовник %1',
    'ui__client_self__description' => 'Перелік моїх доменів.',
    'ui__client_self__short-title' => 'Мої домени',
    'ui__client_self__title' => 'Мої домени',


    'site_apps__non_removable' => 'Елементи, що можуть бути видалені',
    'site_apps__non_removable_items' => 'Поточні веб-застосунки  не можуть бути видалені',

    'ui__client/custom-buttons/custom-button__none-available' => 'Немає користувацьких кнопок',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'В розділі Панель замовника немає користувацьких кнопок замовника%1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Видалити кнопку %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Видалити',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Видалити кнопку %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Видаліть користувацькі кнопки з розділу Панель замовника замовника',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Видалити',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Видалити кнопки користувача',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Видалити кнопки',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Виберіть замовника,  користувацькі кнопки якого ви бажаєте видалити, і натисніть Далі>>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Виберіть кнопки, які ви бажаєте видалити, і натисніть Далі>>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Підтвердіть видалення кнопок натисненням на прапорець на екрані, а потім натисніть Завершити.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Видаліть користувацьку кнопку з розділу Панель замовника замовника',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Видалити',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Видалити користувацьку кнопку',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Видалити користувацьку кнопку',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Виберіть замовника,  користувацькі кнопки якого ви бажаєте видалити, і натисніть Далі>>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Виберіть користувацьку кнопку, яку ви бажаєте видалити, і натисніть Далі>>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Підтвердьте видалення користувацької кнопки натисненням на прапорець на екрані, і потім натисніть Закінчити.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Редагуйте властивості кнопки замовницького рівня %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Налаштування',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Змінити користувацьку кнопку замовника %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Додати користувацьку кнопку',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Виберіть замовника, в розділі Панель замовника якого ви бажаєте створити користувацьку кнопку, і натисніть Далі>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Натисніть Закінчити, щоб створити кнопку.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Змініть властивості кнопки в розділі Панель замовника замовника.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Параметри',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Змініть властивості кнопки в розділі Панель замовника замовника.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Змінити властивості користувацької кнопки',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Оберіть клієнта, користувацьку кнопку якого ви хочете змінити, і натисніть Далі >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Оберіть користувацьку кнопку, яку ви хочете змінити, і натисніть Далі >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Коли закінчите з редагуванням властивостей кнопки, натисніть Закінчити, щоб встановити зміни і вийти з майстра.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Зробити кнопку %1 недоступною для ваших замовників.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Зробити недоступним для ваших замовників',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Зробити кнопку %1 недоступною для ваших замовників',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Зробити кнопку %1 видимою для користувачів замовникіа.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Зробити доступним для ваших замовників',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Зробити кнопку %1 видимою для користувачів замовника',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Зробити користувацьку кнопку доступною/недоступною для ваших замовників.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Доступні/недоступні для ваших замовників.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Зробити користувацьку кнопку доступною чи недоступною для ваших замовників',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Зробити користувацьку кнопку доступною/недоступною для ваших замовників.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Виберіть замовника, користувацьку кнопку якого ви бажаєте зробити доступною для користувачів замовника, і натисніть Далі >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Виберіть користувацьку кнопку, яку ви бажаєте зробити доступною чи недоступною для ваших замовників і натисніть Далі >>.',

    'ui__client/domain__description' => 'Управляйте доменом %1.',
    'ui__client/domain__disabled-warning' => 'Домен %1 відсторонено.',
    'ui__client/domain__none-available' => 'У вас немає жодних доменів.',
    'ui__client/domain__none-available__1' => 'Обліковий запис %1 немає жодних доменів.',
    'ui__client/domain__none-available__2' => 'Обліковий запис %1 немає жодних доменів.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Домен %1',
    'ui__client/domain_self__description' => 'Управляйте своїм доменом.',
    'ui__client/domain_self__disabled-warning' => 'Ваш домен призупинено.',
    'ui__client/domain_self__quick-search' => 'Мої домени',
    'ui__client/domain_self__short-title' => 'Мій домен',
    'ui__client/domain_self__title' => 'Мій домен',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'В розділі Панель замовника замовника немає жодних користувацьких кнопок.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Замовник %1 немає користувацьких кнопок в розділі Панель замовника.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Там немає користувацьких кнопок для домену %1',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Видалити користувацьку кнопку %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Видалити',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Видалити користувацьку кнопку %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Видалити користувацькі кнопки',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Видалити',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Видалити кнопки користувача',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Видалити кнопки користувача',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Виберіть замовникіа, з домену якого ви бажаєте видалити користувацьку кнопку, і натисніть Далі >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Виберіть домен, з адміністративної панелі якого ви бажаєте видалити кнопки, і натисніть Далі >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Виберіть кнопки, які ви бажаєте видалити, і натисніть Далі>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Підтвердьте видалення кнопок натисканням на відповідні прапорці і натисніть Закінчити, щоб видалити кнопки і вийти з майстра',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Видалити користувацьку кнопку',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Видалити',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Видалити користувацьку кнопку',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Видалити користувацьку кнопку',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Виберіть замовника, з домену якого ви бажаєте видалити користувацьку кнопку, і натисніть Далі >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Виберіть домен, з адміністративної панелі якого ви бажаєте видалити кнопку, і натисніть Далі >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Виберіть користувацьку кнопку, яку бажаєте видалити, і натисніть Далі >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Підтвердьте видалення користувацької кнопки натисненням на прапорець і натисніть Закінчити, щоб видалити кнопку і вийти з майстра налаштувань.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Змінити властивості кнопки користувача %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Параметри",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Змінити властивості користувацької кнопки %1 в розділі Панель замовника.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Додати кнопку',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Оберіть замовника, на Панелі Замовника якого ви бажаєте розташувати кнопку, і натисніть Далі >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Виберіть підписку, в якій ви бажаєте змінити кнопку, і натисніть Далі >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Натисніть Закінчити щоб створити кнопку і вийти з майстра налаштувань',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Змінити властивості кнопки на Панелі Замовника.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Параметри',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Змінити властивості кнопки в розділі Панель замовника',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Змініть властивості кнопки',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Виберіть кнопку користувача з налаштуваннями, які ви бажаєте змінити, і натисніть Далі >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Коли закінчите зі змінами властивостей кнопки, натисніть Закінчити, щоб застосувати зміни і вийти з майстра',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Зробіть кнопку %1 неможливою для користувачів поштою під цим доменом',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Неможливо листуватись з користувачами',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Зробіть кнопку %1 неможливою для користувачів поштою під цим доменом',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Зробіть кнопку %1 видимою для користувачів поштою під цим доменом',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Дозволено листуватись з користувачами під цим доменом',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Зробити кнопку користувача %1 видимою для користувачів поштою під цим доменом',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Зробити кнопку користувача доступною чи недоступною для інших користувачів.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Доступний/недоступний для інших користувачів',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Зробити кнопку користувача доступною чи недоступною для користувачів поштою',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Зробити кнопку користувача доступною чи недоступною для інших користувачів',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Виберіть домен, де розташована кнопка, і натисніть Далі >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Виберіть кнопку, яку бажаєте зробити доступною чи недоступною для інших користувачів, і натисніть Далі >>.',

    'ui__client/domain/delete__description' => 'Видалити домен %1',
    'ui__client/domain/delete__short-title' => 'Видалити',
    'ui__client/domain/delete__title' => 'Видалити домен %1',
    'ui__client/domain/delete_multi__description' => 'Видалити домени.',

    'ui__client/domain/delete_multi__short-title' => 'Видалити',
    'ui__client/domain/delete_multi__title' => 'Видалити домени',
    'ui__client/domain/delete_multi__wizard-title' => 'Видалити домени',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Виберіть домени, які бажаєте видалити, і натисніть Далі >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Підтвердіть видалення доменів натисканням на прапорець і натисніть Закінчити, щоб видалити їх та вийти з майстру.',
    'ui__client/domain/delete_unknown__description' => 'Видалити домен.',
    'ui__client/domain/delete_unknown__short-title' => 'Видалити',
    'ui__client/domain/delete_unknown__title' => 'Видалити домен',
    'ui__client/domain/delete_unknown__wizard-title' => 'Видалити домен',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Виберіть домен, який ви бажаєте видалити, і натисніть Далі >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Підтвердіть видалення домену натисканням на прапорець і натисніть Закінчити, щоб видалити і вийти з майстру',

    'ui__client/domain/hosting__none-available' => 'Нема доменів із сконфігурованим веб-хостингом. Створіть домен і сконфігуруйте на ньому веб-хостинг для доступу до цієї функціональності.',
    'ui__client/domain/hosting__none-available__1' => 'Цей обліковий запис користувача не має жодних доменів зі сконфігурованим веб-хостингом. Сконфігуруйте веб-хостинг на потрібному домені для доступу до цієї функціональності.',
    'ui__client/domain/hosting__none-available__2' => 'Веб-хостинг не сконфігуровано для домена %1. Сконфігуруйте веб-хостинг на домені %1 для доступу до цієї функціональності.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Замовники",
    'ui__client/domain/hosting/application#list_header__description__title' => "Опис",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Пункти",
    'ui__client/domain/hosting/application#list_header__name__title' => "Ім’я",
    'ui__client/domain/hosting/application#list_header__release__title' => "Позбавляти",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Сортувати за замовниками",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Сортувати за описом",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Сортувати за пунктами",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Сортувати за ім'ям",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Сортувати за випуском",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Сортувати за версіями",
    'ui__client/domain/hosting/application#list_header__title' => "Веб-застосунки",
    'ui__client/domain/hosting/application#list_header__version__title' => "Версії",

    'rpt_reseller_section_general' => 'Загальні дані',
    'rpt_reseller_section_domains' => 'Домени',
    'rpt_reseller_section_clients' => 'Замовники',
    'statistics__cl_active_domains' => "Активні домени",
    'rpt_reseller_cl_domains' => "Домени",
    'rpt_reseller_cl_subdomains' => "Субдомени",
    'by__cl_domains' => "домени клієнтів",
    'dom_ctrl__cl_mboxes' => "Поштові скриньки",
    'rpt_reseller_cl_redirects' => "Переадресатори",
    'rpt_reseller_cl_mail_groups' => "Поштова група",
    'rpt_reseller_cl_mail_resps' => "Автовідповіді",
    'rpt_reseller_cl_mail_lists' => "Переліки поштових розсилок",
    'rpt_reseller_cl_web_users' => "Веб-користувачі",
    'rpt_reseller_cl_data_bases' => "Бази даних",

    'statistics__active_clients' => 'Замовники з активними підписками',
    'statistics__clients_active_domains' => 'Активні домени',
    'statistics__clients_doms' => 'Домени',
    'statistics__cl_doms' => 'Домени',
    '__clients_subdomains' => 'Субдомени',
    '__clients_domains' => 'Домени',
    'dom_ctrl__clients_mboxes' => 'Поштові скриньки',
    'dom_ctrl__clients_redir' => 'Переадресатори',
    'dom_ctrl__clients_mg' => 'Поштова група',
    'dom_ctrl__clients_resp' => 'Автовідповіді',
    'dom_ctrl__clients_maillists' => 'Переліки поштових розсилок',
    'dom_ctrl__clients_wu' => 'Веб-користувачі',
    'dom_ctrl__clients_db' => 'Бази даних',

    'dom_ctrl__cl_redir' => 'Переадресатори', // to resolve!
    'dom_ctrl__cl_mg' => 'Поштова група', // to resolve!
    'dom_ctrl__cl_resp' => 'Автовідповіді', // to resolve!
    'dom_ctrl__cl_maillists' => 'Переліки поштових розсилок', // to resolve!
    'dom_ctrl__cl_wu' => 'Веб-користувачі', // to resolve!
    'dom_ctrl__cl_db' => 'Бази даних', // to resolve!

    'rpt_cl_section_clients' => 'Замовники',

    'rpt_admin_section_general' => 'Загальні дані',
    'rpt_admin_section_resellers' => 'Посередники',
    'rpt_admin_section_clients' => 'Замовники',
    'rpt_admin_section_personal_clients' => 'Власні замовники',
    'rpt_admin_section_domains' => 'Домени',
    'rpt_admin_section_personal_domains' => 'Персональні домени',

    'rpt_reseller_section_personal_domains' => 'Персональні домени',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Виберіть домен, який бажаєте призупинити або активувати.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Призупинити або активувати домен',

    'ui__client/ip-pool__description' => 'Призначити або скасувати призначення ІР-адрес та сертифікатів SSL/TLS замовнику %1.',
    'ui__client/ip-pool__short-title' => 'ІР-пул',
    'ui__client/ip-pool__title' => 'ІР-пул замовника %1',
    'ui__client/ip-pool_self__description' => 'Переглянути свій ІР-пул.',
    'ui__client/ip-pool_self__short-title' => 'ІР-пул',
    'ui__client/ip-pool_self__title' => 'Мій ІР-пул.',
    'ui__client/ip-pool/properties__description' => 'Налаштувати ІР-пул для замовника  %1.',

    'ui__client/ip-pool/properties__short-title' => 'ІР-пул',
    'ui__client/ip-pool/properties__title' => 'Налаштувати ІР-пул для замовника %1',
    'ui__client/ip-pool/properties_self__description' => 'Переглянути свій ІР-пул.',

    'ui__client/ip-pool/properties_self__short-title' => 'Мій ІР-пул.',
    'ui__client/ip-pool/properties_self__title' => 'Мій ІР-пул.',
    'ui__client/ip-pool/properties_unknown__description' => 'Призначити або скасувати призначення ІР-адрес та сертифікатів SSL/TLS від замовника.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'ІР-пул',
    'ui__client/ip-pool/properties_unknown__title' => 'Налаштувати ІР-пул замовника',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Налаштувати ІР-пул замовника',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Виберіть замовника, ІР-пул якого бажаєте налаштувати.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Після закінчення конфігурування ІР-пула, натисніть Закінчити (Finish), щоб застосувати зміни і вийти з майстра.',


    'ui__client/limits_readonly-unknown__description' => 'Переглянути обмеження ресурсів для замовника.',
    'ui__client/limits_readonly-unknown__short-title' => 'Обмеження ресурсів',
    'ui__client/limits_readonly-unknown__title' => 'Переглянути обмеження ресурсів для облікового запису замовника',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Переглянути або змінити обмеження ресурсів для замовника',

    'ui__client/limits_unknown__wizard-title' => 'Переглянути або змінити обмеження ресурсів для замовника',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Виберіть потрібного вам замовника.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Виберіть потрібного вам замовника.',
    'ui__client/limits_unknown__wizard__2' => 'Щоб застосувати зміни, натисніть Закінчити (Finish).',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Щоб вийти з майстра, натисніть Закінчити (Finish).',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Щоб вийти з майстра, натисніть Закінчити (Finish).',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Щоб вийти з майстра, натисніть Закінчити (Finish).',

    'ui__client/permissions_unknown__wizard-title' => 'Переглянути або змінити дозволи для замовника',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Після закінчення перегляду своїх дозволів, натисніть Закінчити (Finish), щоб застосувати зміни і вийти з майстра.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Виберіть замовника, дозволи якого бажаєте переглянути або змінити.',
    'ui__client/permissions_unknown__wizard__2' => 'Після закінчення зміни дозволів замовника, натисніть Закінчити (Finish), щоб застосувати зміни і вийти з майстра.',

    'ui__client/preferences_unknown__wizard-title' => 'Редагувати параметри замовника',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Виберіть замовника, налаштуваннями сеансів та інтерфейсу якого ви бажаєте управляти.',
    'ui__client/preferences_unknown__wizard__2' => 'По завершенні внесення змін до параметрів замовника, натисніть на кнопку Закінчити.',
    'ui__client/preferences_unknown__wizard__2_self' => 'По завершенні внесення змін до ваших параметрів, натисніть на кнопку Закінчити.',

    'ui__custom-buttons/custom-button__none-available' => 'У вас немає користувацьких кнопок.',
    'ui__custom-buttons/custom-button/delete__description' => 'Видалити користувацьку кнопку %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Видалити',
    'ui__custom-buttons/custom-button/delete__title' => 'Видалити користувацьку кнопку %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Видалити користувацькі кнопки.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Видалити',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Видалити кнопки користувача',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Видалити кнопки користувача',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Виберіть кнопки, які бажаєте видалити.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Підтвердьте видалення кнопок, вибравши прапорець, та натисніть Закінчити (Finish), щоб завершити майстра.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Видалити користувацькі кнопки',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Видалити',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Видалити кнопки користувача',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Видалити кнопки користувача',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Оберіть користувацьку кнопку, яку хочете видалити.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Щоб підтвердити видалення кнопки, виберіть прапорець та натисніть Закінчити для завершення роботи майстра.',
    'ui__custom-buttons/custom-button/properties__description' => 'Змініть властивості кнопки %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Параметри',
    'ui__custom-buttons/custom-button/properties__title' => 'Змінити властивості кнопки %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Створити кнопку',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Натисніть Закінчити, щоб створити кнопку.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Змінити властивості користувацької кнопки.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Параметри',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Змінити властивості користувацької кнопки.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Змінити властивості користувацької кнопки.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Виберіть користувацьку кнопку, властивості якої бажаєте змінити.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Щоб застосувати зміни, натисніть Закінчити (Finish).',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Зробити користувацьку кнопку %1 недоступною іншим користувачам.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Недоступна іншим користувачам',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Зробити користувацьку кнопку %1 недоступною іншим користувачам',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Зробити користувацьку кнопку %1 доступною іншим користувачам.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Доступна іншим користувачам',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Зробити користувацьку кнопку %1 доступною іншим користувачам',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Зробити користувацьку кнопку доступною або недоступною іншим користувачам.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Доступна або недоступна іншим користувачам',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Зробити користувацьку кнопку доступною або недоступною іншим користувачам',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Зробити користувацьку кнопку доступною або недоступною іншим користувачам',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Оберіть користувацьку кнопку, яку хочете зробити доступною або недоступною іншим користувачам, та натисніть Далі >>.',

    'ui__longtasks#list_header__name__title' => "Ім’я",
    'ui__longtasks#list_header__owner__title' => "Власник",
    'ui__longtasks#list_header__start_time__title' => "Час створення",
    'ui__longtasks#list_header__status__title' => "Статус",
    'ui__longtasks#list_header__title' => "Завдання",
    'ui__longtasks#list_header__finish_time__title' => "Час завершення",
    'ui__longtasks#task_list_legend__title' => "Завдання",
    'ui__longtasks#tools_legend__title' => "Інструменти",
    'ui__longtasks__description' => "Управляти фоновими завданнями",
    'ui__longtasks__short-title' => "Фонові завдання",
    'ui__longtasks__title' => "Фонові завдання",
    'ui__longtasks/longtask/properties#current_operation__title' => "Поточна операція:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Очікуваний час завершення:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Загальні дані",
    'ui__longtasks/longtask/properties#owner__title' => "Завдання розпочав:",
    'ui__longtasks/longtask/properties#progress__title' => "Загальний прогрес:",
    'ui__longtasks/longtask/properties#start_time__title' => "Завдання розпочалося:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Статус завдання",
    'ui__longtasks/longtask/properties__description' => "Статус та інформація щодо фонових завдань",

    'ui__longtasks/properties__description' => "Налаштування фонових завдань",
    'ui__longtasks/properties__short-title' => "Налаштування",
    'ui__longtasks/properties__title' => "Фонові завдання",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Шаблони масових поштових повідомлень',
    'ui__mass-mail/template#list_header__name__title' => 'Ім\'я шаблону',
    'ui__mass-mail/template#list_header__from_email__title' => 'Відправник',
    'ui__mass-mail/template#list_header__to__title' => 'Одержувачі',
    'ui__mass-mail/template#list_header__subject__title' => 'Тема',
    'ui__mass-mail/template#list_header__cdate__title' => 'Дата створення',
    'ui__mass-mail/template#list_header__send__title' => 'Надіслати',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Редагувати шаблон масового електронного повідомлення',
    'ui__mass-mail/template/properties__description' => 'Редагувати цей шаблон масового повідомлення електронної пошти.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Додати шаблон групової розсилки',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Додати шаблон групової розсилки',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Додати новий шаблон масового повідомлення електронної пошти.',
    'ui__mass-mail/send__short-title' => 'Надіслати масові повідомлення електронною поштою',
    'ui__mass-mail/send__title' => 'Надіслати повідомлення масових розсилок',
    'ui__mass-mail/send__description' => 'Надіслати масове повідомлення електронною поштою вибраним одержувачам.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Видаліть шаблони масових повідомлень',
    'ui__mass-mail/template/delete_multi__title' => 'Видалити шаблони цих масових повідомлень електронної пошти:',
    'ui__mass-mail/template/delete_multi__description' => 'Видаліть вибрані шаблони повідомлень масових розсилок.',
    'ui__mass-mail/template/delete_multi__done' => 'Вибрані шаблони повідомлень були видалені.',
    'ui__mass-mail/template/properties__invalid_values' => 'Неприпустимі значення, вказані',


    // old
    'ui__mass-mail#body_text__description' => 'Ви можете використати перемінну <name> в тексті повідомлення (але не в заголовку). Вона буде замінена на контактне ім\'я замовника чи посередника.',
    'ui__mass-mail#body_text__title' => 'Текст повідомлення',
    'ui__mass-mail#compose_legend__title' => 'Повідомлення',
    'ui__mass-mail#from_email_text__title' => 'З (електронної адреси)',
    'ui__mass-mail#list_header__cdate__title' => 'Створено',
    'ui__mass-mail#list_header__from_email__title' => 'Від',
    'ui__mass-mail#list_header__name__title' => 'Ім’я',
    'ui__mass-mail#list_header__send__title' => 'Створити повідомлення',
    'ui__mass-mail#list_header__subject__title' => 'Тема',
    'ui__mass-mail#list_header__title' => 'Шаблони масових поштових повідомлень',
    'ui__mass-mail#list_header__to__title' => 'Одержувачі',
    'ui__mass-mail#list_legend__title' => 'Шаблони масових поштових повідомлень',
    'ui__mass-mail#load_template_text__title' => 'Навантаження',
    'ui__mass-mail#name_text__title' => 'Ім\'я шаблону',
    'ui__mass-mail#option_mode_all__title' => 'Всі',
    'ui__mass-mail#option_mode_except__title' => 'Всі, крім вибраних',
    'ui__mass-mail#option_mode_select__title' => 'Лише вибрані',
    'ui__mass-mail#option_select_template__title' => '---Обрати шаблон---',
    'ui__mass-mail#picker_legend__title' => 'Шаблони електронних повідомлень',
    'ui__mass-mail#picker_title__title' => 'Виберіть шаблон',
    'ui__mass-mail#save_as_legend__title' => 'Зберегти як шаблон',
    'ui__mass-mail#save_as_text__title' => 'Зберегти написане повідомлення в новий шаблон під назвою',
    'ui__mass-mail#subject_text__title' => 'Тема',
    'ui__mass-mail#template_legend__title' => 'Шаблон',
    'ui__mass-mail#to_admin_text__title' => 'Адміністратор Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Замовники',
    'ui__mass-mail#to_domains_text__title' => 'Адміністратори доменів',
    'ui__mass-mail#to_select_text__title' => 'Виберіть адреси',
    'ui__mass-mail#to_show_hide_text__title' => 'Показати/сховати вибране',
    'ui__mass-mail#to_text__title' => 'Одержувачі',
    'ui__mass-mail#tools_legend__title' => 'Інструменти',
    'ui__mass-mail__already_exists' => 'Шаблон із іменем %1 вже існує',
    'ui__mass-mail__none-available' => 'У вас немає шаблонів повідомлень.',

    'ui__mass-mail/delete__description' => 'Видаліть шаблон повідомлень масових розсилок %1',

    'ui__mass-mail/delete__empty_selection' => 'Будь ласка, виберіть шаблони, які необхідно видалити',
    'ui__mass-mail/delete__short-title' => 'Видаліть %1',
    'ui__mass-mail/delete__title' => 'Видаліть шаблон повідомлень масових розсилок %1',
    'ui__mass-mail/delete_multi__description' => 'Видаліть шаблони повідомлень масових розсилок.',

    'ui__mass-mail/delete_multi__short-title' => 'Видалити',
    'ui__mass-mail/delete_multi__title' => 'Видаліть шаблони повідомлень масових розсилок',
    'ui__mass-mail/delete_multi__wizard-title' => 'Видалення шаблонів повідомлень масових розсилок',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Виберіть шаблони повідомлень масових розсилок, які бажаєте видалити .',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Підтвердьте видалення шаблонів, вибравши відповідний прапорець, та натисніть Закінчити (Finish), щоб завершити роботу майстра.',
    'ui__mass-mail/delete_unknown__description' => 'Видаліть шаблони повідомлень масових розсилок.',
    'ui__mass-mail/delete_unknown__short-title' => 'Видалити',
    'ui__mass-mail/delete_unknown__title' => 'Видаліть шаблони повідомлень масових розсилок',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Видалення шаблонів повідомлень масових розсилок.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Виберіть шаблон повідомлень масових розсилок, який бажаєте видалити .',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Підтвердьте видалення шаблону, вибравши відповідний прапорець, та натисніть Закінчити (Finish), щоб завершити роботу майстра.',

    'ui__mass-mail/properties__description' => 'Редагувати шаблон повідомлення електронної пошти %1.',

    'ui__mass-mail/properties__invalid_values' => 'Вказані значення невірні',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Редагувати шаблон повідомлення електронної пошти %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Створити шаблон повідомлення масових розсилок',
    'ui__mass-mail/properties_unknown-new__description' => 'Створіть шаблон повідомлення електронної пошти.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Додати шаблон повідомлення електронної пошти',
    'ui__mass-mail/properties_unknown-new__title' => 'Створити шаблон повідомлення електронної пошти',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Редагувати шаблон повідомлення масових розсилок',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Виберіть шаблон, який хочете змінити, і натисніть кнопку Далі >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'По завершенні редагування шаблону, натисніть кнопку Закінчити, щоб застосувати зміни і завершити роботу майстра.',

    'ui__mass-mail/send__invalid_values' => 'Ви вказали неправильні значення',

    'ui__mass-mail/send_new__wizard-title' => 'Створіть шаблон повідомлення і надішліть електронною поштою',
    'ui__mass-mail/send_unknown-new__description' => 'Надіслати електронну пошту вибраним одержувачам',

    'ui__mass-mail/send_unknown-new__short-title' => 'Надіслати масові повідомлення електронною поштою',
    'ui__mass-mail/send_unknown-new__title' => 'Надіслати повідомлення масових розсилок',
    'ui__mass-mail/send_unknown__description' => 'Надіслати електронну пошту вибраним одержувачам',

    'ui__mass-mail/send_unknown__short-title' => 'Надіслати масові повідомлення електронною поштою',
    'ui__mass-mail/send_unknown__title' => 'Надіслати повідомлення масових розсилок',
    'ui__mass-mail/send_unknown__wizard-title' => 'Надіслати повідомлення масових розсилок',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Виберіть шаблон, який вам потрібен, і натисніть Далі >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'По закінченні редагування властивостей шаблону натисніть кнопку Закінчити, щоб відправити повідомлення і завершити роботу майстра.',

    'ui__mass-email/delete__description' => 'Видаліть вибрані шаблони повідомлень масових розсилок.',

    'ui__mass-email/delete__empty_selection' => "Виберіть шаблони, які бажаєте видалити.",
    'ui__mass-email/delete__short-title' => "Видаліть %1",
    'ui__mass-email/delete__title' => "Видаліть шаблон повідомлень масових розсилок %1",
    'ui__mass-email/delete_multi__description' => "Видаліть шаблони повідомлень масових розсилок.",

    'ui__mass-email/delete_multi__short-title' => "Видалити",
    'ui__mass-email/delete_multi__title' => "Видаліть шаблони повідомлень масових розсилок",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Підтвердьте видалення шаблонів, вибравши відповідний прапорець, та натисніть Закінчити (Finish), щоб завершити роботу майстра.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Виберіть шаблони повідомлень масових розсилок, які бажаєте видалити .",
    'ui__mass-email/delete_multi__wizard-title' => "Видалення шаблонів повідомлень масових розсилок",
    'ui__mass-email/delete_unknown__description' => "Видаліть шаблони повідомлень масових розсилок.",
    'ui__mass-email/delete_unknown__short-title' => "Видалити",
    'ui__mass-email/delete_unknown__title' => "Видаліть шаблони повідомлень масових розсилок",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Підтвердьте видалення шаблону, вибравши відповідний прапорець, та натисніть Закінчити (Finish), щоб завершити роботу майстра.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Виберіть шаблон повідомлень масових розсилок, який бажаєте видалити .",
    'ui__mass-email/delete_unknown__wizard-title' => "Видалення шаблонів повідомлень масових розсилок.",
    'ui__mass-email/send__description' => "Надіслати електронну пошту вибраним одержувачам",
    'ui__mass-email/send__short-title' => "Надіслати масову розсилку",
    'ui__mass-email/send__title' => "Надіслати повідомлення масових розсилок",
    'ui__mass-email/send_main__description' => "Надіслати електронну пошту вибраним одержувачам",

    'ui__mass-email/send_main__short-title' => "Надіслати масову розсилку",
    'ui__mass-email/send_main__title' => "Надіслати повідомлення масових розсилок",
    'ui__mass-email/send_selectresellers__title' => 'Обрати посередників',
    'ui__mass-email/send_selectresellers__short-title' => 'Посередники',
    'ui__mass-email/send_selectresellers__description' => 'Обрати облікові записи посередника',

    'ui__mass-email/send_selectclients__description' => "Вибрати облікові записи замовника",

    'ui__mass-email/send_selectclients__short-title' => "Замовники",
    'ui__mass-email/send_selectclients__title' => "Вибрати замовників",
    'ui__mass-email/send_selectdomainusers__description' => "Обрати облікові записи адміністраторів домену",

    'ui__mass-email/send_selectdomainusers__short-title' => "Адміністратори доменів",
    'ui__mass-email/send_selectdomainusers__title' => "Обрати адміністраторів домену",
    'ui__mass-email/template/properties_main__description' => "Створити шаблон повідомлення масових розсилок",
    'ui__mass-email/template/properties_main__short-title' => "Редагувати шаблон",
    'ui__mass-email/template/properties_main__title' => "Редагувати шаблон повідомлення масових розсилок",
    'ui__mass-email/template/properties_new-main__description' => "Створити шаблон для повідомлень масових розсилок.",
    'ui__mass-email/template/properties_new-main__short-title' => "Створити шаблон повідомлення масових розсилок",
    'ui__mass-email/template/properties_new-main__title' => "Створити шаблон повідомлення масових розсилок",
    'ui__mass-email/template/properties_new-selectclients__description' => "Вибрати замовників, які повинні отримувати повідомлення масових розсилок на основі цього шаблону",
    'ui__mass-email/template/properties_new-selectclients__title' => "Вибрати замовників, які повинні отримувати повідомлення масових розсилок на основі цього шаблону",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Обрати адміністраторів домену, які повинні отримувати повідомлення масових розсилок на основі цього шаблону.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Обрати адміністраторів домену, які повинні отримувати повідомлення масових розсилок на основі цього шаблону.",
    'ui__mass-email/template/properties_selectclients__title' => "Вибрати замовників, які повинні отримувати повідомлення масових розсилок на основі цього шаблону",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Обрати адміністраторів домену, які повинні отримувати повідомлення масових розсилок на основі цього шаблону.",

    'ui__mass-email/template/properties_unknown-new__description' => "Створити новий шаблон повідомлення масових розсилок",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Створіть шаблон",
    'ui__mass-email/template/properties_unknown-new__title' => "Створення шаблону повідомлення масових розсилок",
    'ui__news/dismiss__description' => 'Натисніть, щоб закрити блок новин. Plesk не відображатиме цей фрейм, доки статті з новинами не буде оновлено.',

    'ui__news/dismiss__title' => 'Закрити новини',

    'ui__server__description' => 'Управління сервером.',
    'ui__server__short-title' => 'Управління вашим сервером',
    'ui__server__title' => 'Управління сервером',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP-адреса %1 недоступна.',
    'ui__server/ip-address__none-available' => 'Немає IP-адрес.',
    'ui__server/ip-addresses/ip-address__title' => "ІР-адреси",
    'ui__server/ip-address/client/properties_new__description' => "Призначити посередникам IP-адресу %1.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Призначити',
    'ui__server/ip-address/client/properties_new__title' => "Призначити посередникам IP-адресу %1",
    'ui__server/ip-address/client__none-available' => 'Немає облікових записів користувачів',
    'ui__server/ip-address/client_unknown__quick_search' => 'Користувачі',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Список користувачів, які використовують цю IP-адресу.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Виберіть IP-адресу.',
    'ui__server/ip-address/client/delete__description' => 'Скасуйте призначення IP-адреси посереднику.',
    'ui__server/ip-address/client/delete__short-title' => 'Скасувати призначення',
    'ui__server/ip-address/client/delete__title' => 'Скасуйте призначення IP-адреси посереднику.',
    'ui__server/ip-address/client/delete_multi__description' => "Скасуйте призначення IP-адреси пулам посередників.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Скасувати призначення',
    'ui__server/ip-address/client/delete_multi__title' => 'Скасуйте призначення IP-адреси посереднику',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Видалити IP-адресу з пулів користувачів",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Виберіть IP-адресу, призначення якої бажаєте скасувати користувачам, та натисніть Далі>>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Виберіть користувачів, яким бажаєте скасувати призначення IP-адреси, та натисніть Далі>>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Щоб підтвердити скасування призначення IP-адреси користувачам, виберіть прапорець та натисніть Закінчити для завершення роботи майстра.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Скасуйте призначення IP-адреси посередникам.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Скасувати призначення',
    'ui__server/ip-address/client/delete_unknown__title' => 'Скасуйте призначення IP-адреси посередникам',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Скасуйте призначення IP-адреси користувачам',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Виберіть IP-адресу, призначення якої бажаєте скасувати користувачам, та натисніть Далі>>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Виберіть користувачів, яким бажаєте скасувати призначення IP-адреси, та натисніть Далі>>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Щоб підтвердити скасування призначення IP-адреси користувачам, виберіть прапорець та натисніть Закінчити для завершення роботи майстра.',

    'ui__server/ip-address/domain__description' => "Всі домени з IP-адресою %1.",
    'ui__server/ip-address/domain__short-title' => "Домени",
    'ui__server/ip-address/domain__title' => "Домени з IP-адресою %1",
    'ui__server/ip-address/domain_unknown__description' => "Всі домени з IP-адресою.",
    'ui__server/ip-address/domain_unknown__short-title' => "Домени",
    'ui__server/ip-address/domain_unknown__title' => "Домени з IP-адресою",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Виберіть необхідну IP-адресу та натисніть Далі>>.",

    'ui__server/ip-address/properties__description' => 'Змінити властивості IP-адреси %1.',
    'ui__server/ip-address/properties__short-title' => 'Параметри',
    'ui__server/ip-address/properties__title' => 'Змінити властивості IP-адреси %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Додати IP-адресу',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'По завершенні змінювання властивостей IP-адреси, натисніть кнопку Закінчити, щоб застосувати зміни.',
    'ui__server/ip-address/properties_unknown__description' => 'Змінити властивості IP-адреси.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Параметри',
    'ui__server/ip-address/properties_unknown__title' => 'Змінити властивості IP-адреси',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Змінити властивості IP-адреси',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Вибрати IP-адресу, властивості якої ви хочете змінити.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'По завершенні змінювання властивостей IP-адреси, натисніть кнопку Закінчити, щоб застосувати зміни.',

    'ui__server/spam-filter/black-list__description' => 'Налаштувати чорний список для загально-серверного спам-фільтру.',
    'ui__server/spam-filter/black-list__short-title' => 'Чорний список',
    'ui__server/spam-filter/black-list__title' => 'Чорний список для загальносерверного спам-фільтру',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Буде додано тільки перші %1 унікальні адреси електронної пошти.',
    'ui__server/spam-filter/black-list/address__description' => 'Адрес чорного списку спам-фільтру.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'У списку немає жодної адреси електронної пошти.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Вивантажений файл є порожній.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Такі адреси електронної пошти є недійсними: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'У чорному списку спам-фільтру немає жодної адреси.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Адреса',
    'ui__server/spam-filter/black-list/address__title' => 'Адреса чорного списку %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Додати адреси до чорного списку.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Додати адреси',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Додати адреси до чорного списку',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Видаліть адресу %1 з загально-серверного чорного списку',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Видалити',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Видаліть адресу %1 з загально-серверного чорного списку',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Видаліть адреси з загально-серверного чорного списку.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Видалити',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Видаліть адреси з загально-серверного чорного списку.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Видалення адрес з загально-серверного чорного списку спам-фільтру',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Виберіть адреси спам-фільтру, які необхідно видалити, і натисніть кнопку Далі >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Підтвердьте видалення адрес спам-фільтру, вибравши відповідний прапорець, і натисніть кнопку Закінчити (Finish), щоб повністю їх видалити і завершити роботу майстра.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Видаліть адресу з загально-серверного чорного списку.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Видалити',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Видаліть адресу з загально-серверного чорного списку',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Видалення адрес з загально-серверного чорного списку спам-фільтру',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Виберіть адресу спам-фільтру, яку ви бажаєте видалити, і натисніть кнопку Далі >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Підтвердьте видалення адреси спам-фільтра, встановивши прапорець, і натисніть кнопку Закінчити, щоб повністю її видалити і завершити роботу майстра.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Буде додано тільки перші %1 унікальні адреси електронної пошти.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'У списку немає жодної адреси електронної пошти.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Неможливо вивантажити файл. Максимальний розмір файла для вивантаження дорівнює %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Такі адреси електронної пошти є недійсними: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Додати адреси до чорного списку.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Додати адреси',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Додати адреси до чорного списку',

    'ui__server/spam-filter/properties__description' => 'Встановити глобальний спам-фільтр.',

    'ui__server/spam-filter/properties__short-title' => 'Налаштування',
    'ui__server/spam-filter/properties__title' => 'Налаштування спам-фільтру',

    'ui__server/spam-filter/toggle_disable__description' => 'Вимкнути фільтрацію спаму для всієї системи.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Вимкнути',
    'ui__server/spam-filter/toggle_disable__title' => 'Вимкнути фільтрацію спаму',
    'ui__server/spam-filter/toggle_enable__description' => 'Увімкнути фільтрацію спаму для всього серверу.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Увімкнути',
    'ui__server/spam-filter/toggle_enable__title' => 'Увімкнути фільтрацію спаму',
    'ui__server/spam-filter/toggle_unknown__description' => 'Увімкнути або вимкнути фільтрацію спаму для всього серверу.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Увімкнути або вимкнути',
    'ui__server/spam-filter/toggle_unknown__title' => 'Увімкнути або вимкнути фільтрацію спаму',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Увімкнути або вимкнути спам-фільтр',

    'ui__server/spam-filter/white-list__description' => 'Налаштувати білий список загальносистемного спам-фільтру.',
    'ui__server/spam-filter/white-list__short-title' => 'Білий список',
    'ui__server/spam-filter/white-list__title' => 'Білий список загальносистемного спам-фільтру',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Буде додано тільки перші %1 унікальні адреси електронної пошти.',
    'ui__server/spam-filter/white-list/address__description' => 'Адреса білого списку спам-фільтру.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'У списку немає жодної адреси електронної пошти.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Вивантажений файл є порожній.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Такі адреси електронної пошти є недійсними: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'У загально-серверному білому списку спам-фільтру немає жодної адреси.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Адреса',
    'ui__server/spam-filter/white-list/address__title' => 'Адреса %1 білого списку',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Додати адреси до білого списку.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Додати адреси',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Додати адреси до білого списку',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Видаліть адресу %1 з загально-серверного білого списку.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Видалити',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Видаліть адресу %1 з загально-серверного білого списку.',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Видаліть адреси з загально-серверного білого списку.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Видалити',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Видаліть адреси з загально-серверного білого списку.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Видалення адрес з загально-серверного білого списку спам-фільтру',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Виберіть адреси спам-фільтру, які необхідно видалити, і натисніть кнопку Далі >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Підтвердьте видалення адрес спам-фільтру, вибравши відповідний прапорець, і натисніть кнопку Закінчити (Finish), щоб повністю їх видалити і завершити роботу майстра.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Видаліть адресу з загально-серверного білого списку.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Видалити',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Видаліть адресу з загально-серверного білого списку.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Видалення адрес з загально-серверного білого списку спам-фільтру',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Виберіть адресу спам-фільтру, яку ви бажаєте видалити, і натисніть кнопку Далі >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Підтвердьте видалення адреси спам-фільтра, встановивши прапорець, і натисніть кнопку Закінчити, щоб повністю її видалити і завершити роботу майстра.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Буде додано тільки перші %1 унікальні адреси електронної пошти.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'У списку немає жодної адреси електронної пошти.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Неможливо вивантажити файл. Максимальний розмір файла для вивантаження дорівнює %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Такі адреси електронної пошти є недійсними: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Додати адреси до білого списку.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Додати адреси',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Додати адреси до білого списку',

    'ui__server/mail/statistics#apply__description' => "Застосувати фільтр",
    'ui__server/mail/statistics#apply__title' => "Застосувати",
    'ui__server/mail/statistics#custom_from__title' => "від",
    'ui__server/mail/statistics#custom_to__title' => "до",
    'ui__server/mail/statistics#period_all__title' => "Всі",
    'ui__server/mail/statistics#period_custom__title' => "Користувацький",
    'ui__server/mail/statistics#period_month__title' => "Поточний місяць",
    'ui__server/mail/statistics#period_prev_month__title' => "Попередній місяць",
    'ui__server/mail/statistics#period_prev_week__title' => "Попередній тиждень",
    'ui__server/mail/statistics#period_today__title' => "Сьогодні",
    'ui__server/mail/statistics#period_week__title' => "Поточний тиждень",
    'ui__server/mail/statistics#period_yesterday__title' => "Вчора",
    'ui__server/mail/statistics#show_for_period__title' => "Показати за період",
    'ui__server/mail/statistics#tools_legend__title' => "Інструменти",
    'ui__server/mail/statistics__description' => "Переглянути статистику спаму та вірусів",

    'ui__server/mail/statistics__short-title' => "Статистика",
    'ui__server/mail/statistics__title' => "Статистика",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Статистика спаму",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Інструменти",
    'ui__server/mail/statistics/spam__description' => "Переглянути статистику спаму",

    'ui__server/mail/statistics/spam__short-title' => "Статистика спаму",
    'ui__server/mail/statistics/spam__title' => "Статистика спаму",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Поштова скринька",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% від усіх",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Сортувати за іменем поштового облікового запису",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Сортувати за % від усіх",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Сортувати за кількістю отриманого спаму",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "поштові облікові записи",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Отримано спаму",
    'ui__server/mail/statistics/spam/recipients__description' => "Одержувачі",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Одержувачі",
    'ui__server/mail/statistics/spam/recipients__title' => "Одержувачі",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Очистити",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Інфіковано",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Статус",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% від усіх",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Рахувати",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Захищено",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Не перевірено",
    'ui__server/mail/statistics/spam/summary__description' => "Сумарний",

    'ui__server/mail/statistics/spam/summary__short-title' => "Сумарний",
    'ui__server/mail/statistics/spam/summary__title' => "Сумарний",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Статистика зараження вірусами",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Інструменти",
    'ui__server/mail/statistics/virus__description' => "Переглянути статистику вірусів",

    'ui__server/mail/statistics/virus__short-title' => "Статистика зараження вірусами",
    'ui__server/mail/statistics/virus__title' => "Статистика зараження вірусами",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Обліковий запис електронної пошти",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% від усіх",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Сортувати за іменем поштової скриньки",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Сортувати за % від усіх",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Сортувати за кількістю отриманих вірусів",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Облікові записи електронної пошти.",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Отримано вірусів",
    'ui__server/mail/statistics/virus/recipients__description' => "Одержувачі",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Одержувачі",
    'ui__server/mail/statistics/virus/recipients__title' => "Одержувачі",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Очистити",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Інфіковано",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Статус",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% від усіх",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Рахувати",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Захищено",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Не перевірено",
    'ui__server/mail/statistics/virus/summary__description' => "Сумарний",

    'ui__server/mail/statistics/virus/summary__short-title' => "Сумарний",
    'ui__server/mail/statistics/virus/summary__title' => "Сумарний",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Ім’я",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% від усіх",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Сортувати за ім'ям",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Сортувати за % від усіх",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Сортувати за кількістю інфікованих об’єктів",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Віруси",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Інфіковані об’єкти",
    'ui__server/mail/statistics/virus/viruses__description' => "Віруси",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Віруси",
    'ui__server/mail/statistics/virus/viruses__title' => "Віруси",

    'ui__support#param_company__title' => "Компанія",
    'ui__support#param_email__title' => "Електронна пошта",
    'ui__support#param_firstname__title' => "Ім’я",
    'ui__support#param_keynumber__title' => "Номер ключа продукту",
    'ui__support#param_operatingsystem__title' => "Операційна система",
    'ui__support#param_phone__title' => "Телефон",
    'ui__support#param_psabuild__title' => "Складання Plesk",
    'ui__support#param_psainsttype__title' => "Тип установки Plesk",
    'ui__support#param_psaversion__title' => "Версія Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Інструменти",

    'ui__reseller/traffic-history_unknown__short-title' => "Переглянути трафік посередників",
    'ui__reseller/traffic-history_unknown__title' => "Переглянути трафік посередників",
    'ui__reseller/traffic-history_unknown__description' => "Переглянути трафік облікових записів посередника.",
    'ui__reseller#list__title' => "Посередники",
    'accounts_list__name__filter_title' => "Ім’я",
    'accounts_list__resource__filter_title' => "Використання ресурсу",
    'resellers_list__filter_resource_usage_any' => "Будь-який",
    'resellers_list__filter_resource_usage_overuse' => "Надмірне використання",
    'resellers_list__filter_resource_usage_normal' => "У межах",
    'accounts_list__status__filter_title' => "Статус",
    'resellers_list__filter_status_any' => "Будь-який",
    'resellers_list__filter_status_blocked' => "Призупинений",
    'resellers_list__filter_status_active' => "Працює",
    'resellers_list__filter_clients__filter_title' => "Показати",
    'resellers_list__filter_clients_on' => "Посередники та їх замовники",
    'resellers_list__filter_clients_off' => "Тільки для посередників",
    '__disk_usage' => "Використання дискового простору",
    'ui__reseller/traffic_unknown__short-title' => "Переглянути трафік посередників",
    'ui__reseller/traffic_unknown__title' => "Переглянути трафік посередників",
    'ui__reseller/traffic#list__title' => "Трафік посередника",
    'ui__reseller/traffic_unknown__description' => "Переглянути звіт про використання трафіку.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Трафік посередника",

    '__reseller_name' => "Ім’я посередника",
    '__reseller' => "Посередники",
    'resellertrafficlist_header' => "Переглянути трафік посередників",
    '__reseller_personal' => "Трафік, використаний доменами посередника",
    'ui__reseller/traffic-history__short-title' => "Трафік посередників",
    'ui__reseller/traffic-history__title' => "Трафік посередників",
    'ui__reseller/traffic-history__description' => "Переглянути звіт про використання трафіку.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Дозволити продаж понад запаси",
    'limits__reseller_oversell_description' => "Продаж понад запаси дозволяє посереднику продавати більше ресурсів, ніж було виділено для нього або неї. Якщо продаж понад запаси дозволений,  при управлінні посередником буде враховуватись кількість фактично використаних ресурсів замість кількості виділених ресурсів.",
    'limits__overuse_block_text' => "Політика надмірного використання",
    'limits__overuse_block_true_text' => "Надмірне використання недозволено",
    'limits__reseller_overuse_block_true_description' => "Заблокуйте перевитрату ресурсів. Фактична кількість використаних ресурсів не може перевищувати надану кількість",
    'limits__overuse_block_false_text' => "Надмірне використання дозволено",
    'limits__reseller_overuse_block_false_description' => "Не блокуйте перевитрату ресурсів, щоб дозволити посереднику використовувати більше ресурсів, ніж було надано спочатку. Фактичний рівень використання ресурсів може перевищувати первинний розподіл ресурсів",
    'limits__reseller_overuse_notify_text' => "Повідомити посередника про досягнення обмеження з використання ресурсів",
    'reseller_perm__manage_sh_access_disabled' => "Посередник не може заборонити доступ до оболонки",
    'reseller_perm__manage_sh_access_chrooted' => "Посередник може дозволити доступ лише до середовища chrooted",
    'reseller_perm__manage_sh_access_any' => "Посередник може дозволити доступ до будь-якого типу оболонки",
    'template__reseller_num_excl_ips' => "Призначити виділені IP-адреси посереднику",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Обліковий запис",
    'ui__reseller#info__title' => "Інформація",
    'ui__reseller#clientsTab__title' => "Замовники",
    'ui__reseller#domainsTab__title' => "Домени",
    'ui__reseller__title' => "Управління обліковим записом посередника %1",
    'domains__reseller_info' => "%1 замовників, %2 доменів, %3 з використаного дискового простору, %4 з переданих даних.",
    'domains__reseller_info_hiding_traffic' => "%1 замовників, %2 доменів, %3 з використаного дискового простору.",
    'ui__reseller__description' => "Управління обліковим записом посередника.",

    'ui__reseller/limits_unknown__wizard-title' => 'Переглянути або змінити обмеження ресурсів для посередника',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Оберіть потрібного вам посередника.',
    'ui__reseller/limits_unknown__wizard__2' => 'Щоб застосувати зміни, натисніть Закінчити (Finish).',

    'ui__client/report_reseller__short-title' => "Звіт",
    'ui__client/report_reseller__title' => "Переглянути звіт про обліковий запис",
    'ui__client/report_reseller__description' => "Перегляньте звіт про обліковий запис посередника.",
    'ui__client/ip-pool_reseller__short-title' => "ІР-пул",
    'ui__client/ip-pool_reseller__description' => "Призначити ІР-адреси та сертифікати SSL/TLS обліковому запису посередника.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Вкажіть параметри облікового запису та натисніть Завершити.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Переглянути або змінити дозволи для посередника',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Оберіть посередника, дозволи якого хочете переглянути або змінити.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Після закінчення зміни дозволів посередника, натисніть Закінчити (Finish), щоб застосувати зміни та вийти з майстра.',

    // Customers > create customer account

    '__resellers_list' => 'Посередники',
    'picker_reseller__title' => 'Вибрати посередника',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Інструменти",
    'ui__client#tools2__title' => "Обліковий запис",
    'ui__client#info__title' => "Інформація",
    'ui__client#clientslist__title' => "Замовники",
    'ui__client#domainslist__title' => "Домени",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Усі веб-застосунки наразі зберігаються за категоріями, що спрощує вибір потрібного застосунка для встановлення.",
    'feature__domainkeys__reseller' => "Ви можете використовувати механізм аутентифікації відправника електронної пошти DKIM, щоб зменшити кількість спаму і фішингових листів.",

    '__reseller_form' => "Форма посередника",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Виберіть обліковий запис замовника, налаштування якого бажаєте змінити.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Щоб змінити обмеження використання ресурсів, натисніть Обмеження ресурсів.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Щоб змінити дозволи на операції, які замовник може виконувати в Plesk, натисніть кнопку Дозволи.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Зробіть цей шаблон доступним для інших користувачів",
    'template__shared_description' => "Введіть цю опцію, якщо ви бажаєте, щоб ваші замовники могли користуватись цим шаблоном.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Інструменти',

    'ui__client/traffic-history_unknown__short-title' => 'Переглянути Трафік за замовниками',
    'ui__client/traffic-history_unknown__title' => 'Трафік за замовниками',
    'ui__client/traffic-history_unknown__description' => 'Переглянути звіт про використання трафіку усіма замовниками',
    'ui__client/traffic-history__short-title' => 'Трафік за замовниками',
    'ui__client/traffic-history__title' => 'Переглянути Трафік за замовниками',
    'ui__client/traffic-history__description' => 'Переглянути звіт про використання трафіку усіма замовниками',

    'ui__client/traffic#list__title' => 'Трафік за замовниками',
    'ui__reseller/client/traffic#list__title' => 'Трафік за замовниками',

    'clients_list__filter_type__filter_title' => 'Показати',
    'clients_list__filter_type_any' => 'Замовники та посередники',
    'clients_list__filter_type_clients' => 'Тільки для замовників',
    'clients_list__filter_type_resellers' => 'Тільки для посередників',
    'ui__client/domain_unknown-new__short-title' => "Створити домен",

    // Customers > View traffic by customers
    '__personal' => "Трафік, використаний доменами користувача",
    'PersonalTrafficList_header_of_client__' => "Переглянути звіт про використання трафіку для вашого облікового запису",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Адміністратор домену не може дозволити або заборонити доступ до оболонки",
    'domain_perm__manage_sh_access_chrooted' => "Адміністратор домену може дозволити доступ тільки до середовища зі зміненим кореневим каталогом",
    'domain_perm__manage_sh_access_any' => "Адміністратор домену може дозволити доступ до будь-якого типу оболонки",

    // APS Catalog
    'bt_add_to_vault' => "Додати до сховища",
    'bt_hide_updates' => "Приховати доступні оновлення",
    'bt_show_updates' => "Показати доступні оновлення",

    '__site_apps__applications' => "Застосунки",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Застосунки, вибрані для додавання до сховища",
    'site_apps__application_selected' => "Вибрано",
    'site_apps__currently_in_vault' => "Інші версії вже в сховищі :",
    'site_apps__new_versions' => "Нові версії:",
    'site_apps__patches' => "Патчі:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Кількість застосунків, запланованих для додавання до сховища: %1",
    'site_apps__applications_downloading_now' => "В даний час завантажуються такі застосунки: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Вже в сховищі",

    // Server > Action Log
    'bt_skin_edit' => "Редагувати опис зовнішньої оболонки",
    'domains__you_want_change_the_status_of_the_reseller??' => "Ви впевнені, що ви хочете змінити статус облікового запису посередника?",
    'limits__oversell_legend' => "Продаж понад запаси",
    'limitsManager__limit_available_error' => "Неможливо виділити необхідну кількість ресурсів (%%quantity%% %%limitName%%). Доступно лише %%available%% %%limitName%%",
    'limitsManager__limit_reserved_error' => "Неможливо встановити обмеження на використання потрібного ресурсу (%%quantity%% %%limitName%%), тому що нове значення менше, ніж обсяг ресурсів, зарезервованих для ваших замовників або використовуваних безпосередньо вами (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Неможливо встановити необхідне обмеження використання ресурсів (%%quantity%% %%limitName%%), тому що нове значення менше, ніж фактична кількість ресурсів, яка використовується Вашим обліковим записом та сайтами (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Використання смуги пропускання сервісами",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Переглянути звіт з використання трафіка",
    'ui__client/domain/traffic_unknown-reseller__title' => "Переглянути звіт з використання трафіка",

    'ui__client/domain_new__short-title' => "Створити домен",

    'ui__client_reseller__description' => "Управляйте обліковим записом посередника %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Управляти обліковим записом посередника",

    '__owner_name' => "Ім’я власника",
    'domains_list__resource__filter_title' => "Використання ресурсів",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Каталог застосунків APS",
    'site_apps__applications_have_updates' => "Покращені версії наступних додатків доступні:\n%1\n Щоб подивитись покращення, впевніться, що пошукова зона вільна, оберіть <b>показати тільки покращення</b> прапорець і шукайте додатки, які ви потребуєте.",
    'site_apps__progress_adding_to_vault' => "Додавання до сховища:",
    'site_apps__progress_done_message' => "Прогрес:",
    'site_apps__progress_applications_left' => "залишилося %1 з %2 застосунків",
    'site_apps__download_item_long_task_title' => "Завантажте застосунок APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Завантажте застосунки APS з APS-каталогу",
    'site_apps__last_check_for_updates' => "остання перевірка покращень: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Всі заплановані застосунки успішно додано до сховища застосунків",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 планованих застосунків успішно додано до сховища застосунків.",
    'site_apps__no_search_results' => 'Не знайдено жодних застосунків. Спробуйте інший пошуковий запит або завантажте застосунки за категоріями.',
    'site_apps__search_results_title' => 'Пошук результатів',
    '__site_apps__search_by_application' => 'Назва програми',
    '__site_apps__search_by_vendor' => 'Продавець',
    '__site_apps__search_by_vendor__all' => 'Усі продавці',
    '__site_apps__search_by_packager' => 'Пакувальник',
    '__site_apps__search_by_certification_level' => 'Рівень сертифікації',
    '__site_apps__search_by_cert__any' => 'Будь-який',
    '__site_apps__search_by_cert__silver_and_higher' => 'Срібний і вище',
    '__site_apps__search_by_cert__gold_and_higher' => 'Золотий і вище',
    '__retry' => 'Повторити',
    'site_apps__application_packager_site' => 'Пакувальник',
    'site_apps__add_to_pool_message' => "Застосунки, позначені як \" доступні для всіх\", автоматично надаються всім посередникам та замовникам з необмеженою кількістю установок. Обмежені застосунки надаються всім посередникам та замовникам вручну на індивідуальній основі з чітко зазначеною кількістю доступних установок.",
    'site_apps__make_available_for_all' => "Зробіть вибрані застосунки доступними для всіх користувачів",

    'site_apps__broadcast_app_text' => "Застосунки, позначені як \" доступні для всіх\", автоматично надаються всім посередникам та замовникам з необмеженою кількістю установок. Обмежені застосунки надаються всім посередникам та замовникам вручну на індивідуальній основі з чітко зазначеною кількістю доступних установок.",
    'site_apps__broadcast_app_name' => 'Зробити застосунки доступними для всіх користувачів',

    // User Application Pool per application
    'site_apps__available_clients' => 'Доступні користувачі',
    'site_apps__no_more_clients_to_add_to_pool' => 'Немає більше облікових записів користувачів, яким ви можете надати цей застосунок',

    // Installed application instances
    'site_apps__installations' => 'Установки',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Ім’я та IP-адреса домену",
    '__assign_ip_address' => "Призначити IP-адресу",
    '__switch_on_service' => "Увімкнути послугу",
    '__hosting_configuration' => "Конфігурація хостингу",
    '__vrt_hst' => "Хостинг веб-сайту",
    '__vrt_hst_hint' => "Розмістити сайт на цьому сервері.",
    '__fwd' => "Пересилання",
    '__web_hosting_settings' => "Налаштування хостингу",
    '__fwd_hint' => "Переспрямувати відвідувачів на інший веб-сайт",
    '__none_hint' => "Не слід зараз розміщувати сайт.",
    '__login_hint' => "Це ім'я користувача використовується для доступу до вашого веб-сайту через FTP",
    '__password_hint' => "Цей пароль використовується для доступу до веб-сайту через FTP",
    '__advanced_hosting_setup' => "Налаштування додаткових параметрів хостингу веб-сайтів",
    '__domain_creation_successful' => "Домен створений.",
    'bt_hosting_settings' => "Параметри хостингу",
    '__change_hosting_type' => "Змінити тип хостингу для домену %1",
    '__hosting_type_change_warning' => "При зміні типу хостингу на \"переспрямовування\" або \"без хостингу\", всі файли та каталоги вашого сайту будуть видалені з серверу. Переконайтесь, що ви створили локальну копію вашого сайту.",
    '__current_hosting_type' => "Поточний тип хостингу",
    '__new_hosting_type' => "Новий тип хостингу",
    '__fwd_settings' => "Параметри переспрямування",
    '__fwd_settings_legend' => "Параметри переспрямування",
    '__fwd_destination_url' => "Цільовий URL",
    '__fwd_type' => "Тип переспрямування",
    '__fwd_type_standart' => "Стандартна переадресація",
    '__fwd_type_standart_hint' => "Переспрямувати відвідувачів на інший сайт та показати адресу призначення, щоб користувачі знали про переспрямування.",
    '__fwd_type_frame' => "Переадресація фрейму",
    '__fwd_type_frame_hint' => "Переспрямувати відвідувачів на інший сайт, але сховати цільову адресу, щоб користувачі про переспрямування не знали.",
    '__hosting_type_template_warning' => "Вибраний тип хостингу відрізняється від вказаного у шаблоні. Якщо продовжити, параметри веб-хостингу вибраного шаблону будуть проігноровані. Ви впевнені, що бажаєте встановити вибраний тип хостингу?",

    '__no_resellers_selected' => "Необхідно вибрати хоча б один обліковий запис посередника.",

    'ui__client/logo_unknown__wizard-title' => 'Налаштувати логотип',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Виберіть замовника, властивості логотипа якого бажаєте змінити.',
    'ui__client/logo_unknown__wizard__2' => 'Натисніть Закінчити (Finish), щоб застосувати зміни.',
    'ui__client/logo_unknown__wizard__2_self' => 'Натисніть Закінчити (Finish), щоб застосувати зміни.',

    'ui__client/ipaddress/properties_new__short-title' => "Додати IP-адресу",
    'ui__client/ipaddress/properties_new__title' => 'Додати IP-адресу',
    'ui__client/ipaddress/properties_new__description' => "Додайте ІР-адресу.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Додати IP-адресу",
    'ui__client/ipaddress/properties_unknown-new__title' => "Додати IP-адресу",
    'ui__client/ipaddress/properties_unknown-new__description' => "Додати IP-адресу",
    'ui__client/ipaddress/delete_multi__short-title' => "Видаліть ІР-адресу",
    'ui__client/ipaddress/delete_multi__description' => "Видаліть ІР-адреси.",
    'ippool_Manager__no_available_ips' => "Немає вільних ІР-адрес у ІР-пулі.",
    'ippool_Manager__ip_shared' => "спільна",
    'ippool_Manager__ip_exclusive' => "виділена",
    'ui__client/ipaddress/properties__title' => "Управляти ІР-адресами",
    'ui__client/ipaddress/properties__description' => "Переглянути або змінити властивості ІР-адреси.",
    'ui__client/ipaddress_unknown-new__title' => "Додати IP-адресу",
    'ui__client/ipaddress_unknown-new__short-title' => "Додати IP-адресу",
    'ui__client/ipaddress_unknown-new__description' => "Додайте нові ІР-адреси.",

    'ui__mass-mail#to_resellers_text__title' => "Посередники",
    'ui__mass-mail#to_domainusers_text__title' => "Адміністратори доменів",
    'ui__mass-email#tools_legend__title' => "Інструменти",
    'ui__mass-email#list_legend__title' => 'Шаблони масових поштових повідомлень',
    'ui__mass-email#template_legend__title' => "Шаблон",
    'ui__mass-email#from_email_text__title' => "Від",
    'ui__mass-email#to_text__title' => 'Одержувачі',
    'ui__mass-email#to_resellers_text__title' => "Посередники",
    'ui__mass-email#to_clients_text__title' => "Замовники",
    'ui__mass-email#to_domainusers_text__title' => "Адміністратори доменів",
    'ui__mass-email#to_admin_text__title' => "Адміністратор Plesk",
    'ui__mass-email#option_mode_all__title' => "Всі",
    'ui__mass-email#option_mode_select__title' => "Лише вибрані",
    'ui__mass-email#option_mode_except__title' => "Всі, крім вибраних",
    'ui__mass-email#option_select_template__title' => '---Обрати шаблон---',
    'ui__mass-email#subject_text__title' => "Тема",
    'ui__mass-email#body_text__title' => "Текст повідомлення",
    'ui__mass-email#save_as_legend__title' => "Зберегти як шаблон",
    'ui__mass-email#save_as_text__title' => "Зберегти написане повідомлення в новий шаблон під назвою",
    'ui__reseller/preferences_unknown__wizard-title' => "Змінити налаштування облікового запису",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Оберіть посередника, налаштування облікового запису якого хочете змінити, та натисніть Закінчити (Finish)",
    'ui__reseller/preferences_unknown__wizard__2' => "Вкажіть параметри облікового запису та натисніть OK.",
    'ippoolManager__ip_shared' => "спільна",
    'ippoolManager__ip_exclusive' => "виділена",

    '__users_list' => "Користувачі",
    '__users' => "Користувачі",
    '__user_name' => "Ім’я користувача",

    'limit__name_max_dom_aliases' => "псевдоніми домену",
    'limit__name_max_subftp_users' => "додаткові облікові записи FTP",
    'limit__name_max_mssql_db' => "Бази даних Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Пули застосунків IIS",
    'limit__name_max_odbc' => "З’єднання ODBC",
    'total_mboxes_quota_unsupported' => 'не підтримується поштовим сервером',
    'limit_soft__disk_space' => 'Повідомити про досягнення обмеження дискового простору',
    'limit_soft__max_traffic' => 'Повідомити про досягнення обмеження трафіку',
    'limitsManager__commit_failed' => "Неможливо змінити обмеження ресурсів.",
    'limitsManager__date_in_past' => "Некоректна дата закінчення ліцензії %1.",
    'limitsManager__limit_not_supported' => "Неможливо встановити обмеження для типу ресурсів %1.",
    'limitsManager__limit_oversell_inconsistency' => "Неможливо виділити вказану кількість ресурсів при відключеному продажу понад наявних запасів.",
    'limitsManager__limit_overuse_inconsistency' => "Використання ресурсів перевищує встановлені обмеження.",
    'limitsManager__no_resource_available' => "Не залишилось доступних ресурсів цього типу(%%limitName%%). Необхідно: %%quantity%%; доступно: %%unused%%.",
    'limitsManager__no_total_resource_available' => "У вашого постачальника послуг немає доступних ресурсів цього типу(%%limitName%%). Необхідно: %%quantity%%; доступно: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Дата закінчення ліцензії повинна бути не більше %1.",
    'limitsManager__invalid_disk_space_limit' => "Об’єм дискового простору повинен бути не більше %1.",
    'limitsManager__invalid_max_traffic_limit' => "Кількість трафіку повинна бути не більше %1.",
    'ippoolManager__ip_has_suballocations' => "Неможливо змінити тип ІР-адреси, вже виділеної користувачу. ІР-адреса %%ip%% вже виділена користувачу(ам) як %%reserved%% ІР-адреса.",
    'ippoolManager__ip_is_already_in_pool' => "ІР-адреса уже призначена користувачу.",
    'ippoolManager__ip_is_not_in_pool' => "В пулі немає ІР-адреси %%ip%%.",
    'ippoolManager__can_not_allocate_ip' => "ІР-адреса %%ip%% доступна лише як %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "ІР-адресу %%ip%% не можна зробити виділеною.",
    'ippoolManager__ip_used_by_hst_or_frw' => "ІР-адреса %%ip%% уже використовується для хостинга.",
    'ippoolManager__active_anon_ftp_on_ip' => "Анонімний FTP-доступ уже включено для ІР-адреси %%ip%%",
    'ippoolManager__no_vacant_ips' => "Немає вільних ІР-адрес.",
    'ippoolManager__no_available_ips' => "Немає доступних ІР-адрес.",
    'templates__dublicate_name' => "Шаблон з таким ім’ям вже існує. Будь ласка, введіть інше ім’я для цього шаблону.",
    'cl_perm__client_limits_exceeded' => "Вказані значення лімітів ресурсів перевищують значення, дозволені вашим планом хостингу, або ж ці значення надають менше ресурсів, ніж ті, що на даний момент використовуються вашими сайтами.",
    'cl_perm__reseller_limits_exceeded' => "Вказані значення ліміту ресурсів перевищують значення, дозволені вашим планом хостингу, або ці значення забезпечують ресурсами менше, ніж в даний момент використовують облікові записи та сайти користувача.",

    'site_apps__preferences_show_all_versions_title' => "Покажіть повний список версій для кожного застосунка, відновленого з каталогу",
    'site_apps__preferences_show_all_versions_hint' => "Якщо вибрано цю опцію, отримання всіх версій кожного застосунка займатиме багато часу щоразу, коли ви відкриваєте каталог. Якщо цю опцію не вибрано, то будуть показуватися лише найпізніші версії.",
    '__select_user_template' => "Створити обліковий запис користувача, основуючись на шаблоні",
    'ip_already_added_to_all_clients' => "Ця IP-адреса вже призначена всім користувачам.",
    'ui__server/ip-address/client/delete#legend__description' => "Такі IP-адреси будуть видалені з системного пулу та пулів користувачів:",

    'site_apps__cancelled_apps' => "Ви скасували додавання поточних застосунків: %2",

    'sb_url_is_not_resolved' => 'URL не може бути перетворено: перевірте налаштування DNS. URL %1 має перетворитися на IP-адресу сервера, на якому встановлений Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Неможливо видалити ІР-адресу %%ip%%, тому що це остання ІР-адреса, наявна на мережевому інтерфейсі.',
    'ip_addr__used_for_current_session' => 'Неможливо видалити ІР-адресу %%ip%%, тому що вона використовується активною сесією.',
    'ip_addr__used_for_hosting' => 'Неможливо видалити ІР-адресу %%ip%%, тому що вона використовується для хостингу веб-сайту.',
    'ip_addr__is_main' => 'Неможливо видалити ІР-адресу %%ip%%, тому що це первинна ІР-адреса мережевого інтерфейсу.',
    'ip_addr__ip_used_by_message_submission' => 'Неможливо видалити ІР-адресу %%ip%%, тому що вона використовується для відправки поштового повідомлення',

    // RESELLER ACTION LOG

    '__cl_domains' => 'домени замовників',
    'excl_ip_num' => 'Виділена ІР-адреса',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder невстановлений',

    '__perm_allow_oversell_can_not_be_revoked' => 'Неможливо скасувати право на продаж понад запаси для користувача, який вже надав більше ресурсів, ніж доступно, та перейшов у режим продажу понад запаси.',
    'limitsManager__invalid_limit_value' => 'Для обмеження %%limit_name%% встановлено некоректне значення %%value%%.',
    'confirmationForm_default_agreement_text' => 'Підтвердіть операцію',
    'confirmationForm_default_confirm_message' => 'Будь ласка, підтвердіть операцію.',
    'limit__max_mn' => 'Максимальна кількість поштових облікових записів',

    'limits__client_overuse_description' => 'Політика перевитрат повідомляє Plesk, що робити, коли використання ресурсів перевищує первинний розподіл ресурсів.',
    'limits__client_overuse_block_true_description' => 'Заблокуйте перевитрату ресурсів. Фактична кількість використаних ресурсів не може перевищувати надану кількість',
    'limits__client_overuse_block_false_description' => 'Не блокувати перевитрату ресурсів, що дозволить вашому замовнику використовувати більше ресурсів, ніж було надано спочатку. Фактична кількість використаних ресурсів може перевищувати первинний розподіл ресурсів',
    'limits__client_overuse_notify_text' => 'Повідомити замовника про досягнення обмежень використання ресурсів',

    'limits__domain_overuse_description' => 'Політика перевитрат повідомляє Plesk, що робити, коли використання ресурсів перевищує первинний розподіл ресурсів.',
    'limits__domain_overuse_block_true_description' => 'Політика надмірного використання вказує Plesk, що робити при надмірному використанні ресурсів.',
    'limits__domain_overuse_block_false_description' => 'Не блокуйте перевитрату ресурсів, що дозволить домену використовувати більше ресурсів, ніж було надано спочатку. Фактичний рівень використання ресурсів може перевищувати первинний розподіл ресурсів',
    'limits__domain_overuse_notify_text' => 'Повідомити власника домену про досягнення обмежень використання ресурсів',


    'cancel_remove' => 'Скасуйте всі зміни та поверніться до попередньої сторінки.',

    'dns__dns_rr_delete' => 'Елементи, що будуть видалені',
    'dns__delete_rr' => 'такі   записи DNS будуть видалені із DNS-зони :',
    'dns__dns_rr_delete_non_removable' => 'Елементи, що можуть бути видалені',
    'dns__non_delete_rr' => 'Такі записи DNS не можуть бути видалені:',
    'dns__dns_rr_delete_confirm_message' => 'Підтвердьте видалення DNS-записів',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Невідомий формат веб-застосунку: веб-застосунок має бути недоступним для установки і використання.',

    '__php_handler_type_desc' => 'Запустити PHP як',
    'sfdk_domain_sign__failed' => 'Сталася невизначена помилка при спробі увімкнути підписання електронної пошти з DKIM на домені. Для отримання додаткової інформації зверніться до журналу помилок сервера.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Повідомлення про успішне оновлення ключа Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Повідомлення про відстрочення оновлення ключа Plesk',
    'pkey_notify__subj_update_error_notification' => 'Повідомлення про помилку оновлення ключа Plesk',
    'pkey_notify__update_successful' => 'Оновлення %1 завершено успішно.',
    'pkey_notify__update_failed_no_more_try' => 'Не вдалося оновити %1. Ключ, який ви намагаєтеся відправити, є недійсним. Ви не можете більше намагатися оновити цей ключ.',
    'pkey_notify__update_failed_try_later' => 'Неможливо оновити %1: під час обробки вашого ключа сталася помилка. Можна спробувати отримати ключ у Plesk вручну (меню «Інструменти та налаштування > Інформація про ліцензію») чи дозволити Plesk спробувати оновити його протягом наступних 24 годин. Якщо ви більше не хочете отримувати це сповіщення, видаліть цей ключ із Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Неможливо вимкнути загально-серверну фільтрацію спаму.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Неможливо ввімкнути загально-серверну фільтрацію спаму.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Домени',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'Псевдоніми домену',
    'rpt_reseller_dom_postboxes' => 'Поштові скриньки',
    'rpt_reseller_dom_redirects' => 'Переадресатори',
    'rpt_reseller_dom_mail_groups' => 'Поштові групи',
    'rpt_reseller_dom_mail_resps' => 'Автовідповідач',
    'rpt_reseller_dom_mail_antispam' => 'Антиспам',
    'rpt_reseller_dom_mail_antivirus' => 'Антивірус',
    'rpt_reseller_dom_mail_lists' => 'Списки розсилки',
    'rpt_reseller_dom_web_users' => 'Веб-користувачі',
    'rpt_reseller_dom_data_bases' => 'База даних MySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'База даних MSSQL',

    'rpt_reseller_section_full_clients' => 'Замовники',
    '__cl_name' => 'Ім\'я замовника',
    '__cl_creation_date' => 'Дата створення',
    '__clients_traffic' => 'Трафік замовника',
    'rpt_reseller_cl_mail_antispam' => 'Антиспам',
    'rpt_reseller_cl_mail_antivirus' => 'Антивірус',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder невстановлений',
    'sitebuilder_disabled' => 'Presence Builder відключений',
    'b_sitebuilder_disabled' => 'Presence Builder відключений',
    'webmail_not_installed' => 'Програмне забезпечення для електронної пошти не встановлене.',
    'webmail_disabled' => 'Сервіс електронної пошти вимкнено.',
    'spamassassin_not_installed' => 'SpamAssassin не встановлено.',
    // pfu:
    'anonymous_ftp_shared' => 'Неможливо налаштувати анонімний FTP: тип загальної IP-адреси.',
    'anonymous_ftp_used' => 'Неможливо налаштувати анонімний FTP: IP-адреса використовується іншим доменом для обслуговування анонімного FTP.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET не встановлено.',
    'site_builder_no_package' => 'Presence Builder (редактор) недоступний. Будь-ласка, перевірте, чи Presence Builder встановлений, і чи є він активним компонентом',
    'site_builder_not_configured' => 'Presence Builder не налаштований.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Інструменти',
    'ui__reseller/client#clientslist__title' => 'Замовники',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Управляти віртуальними каталогами під веб-сайтом',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Виберіть веб-сайт, каталогами якого бажаєте управляти.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Налаштувати анонімний FTP на домені',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Оберіть домен, на якому ви хочете налаштувати анонімний FTP.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Налаштувати менеджер журналів для домену та переглянути журнали домена',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Виберіть домен, менеджер журналів якого бажаєте налаштувати і журнали якого бажаєте переглянути.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Управляйте сертифікатами SSL/TLS для домену',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Виберіть домен, сертифікатами SSL/TLS якого ви хочете управляти.',

    'ui__client/domain/disable_multi__wizard-title' => 'Призупинені домени',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Оберіть домени, які ви хочете призупинити',

    'ui__client/domain/enable_multi__wizard-title' => 'Активувати домени',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Оберіть домени, які хочете активувати.',

    'ui__client/domain_unknown__wizard-title' => 'Переглянути домени',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Виберіть замовника, домени якого бажаєте переглянути.',

    'ui__client/domain/register_unknown__wizard-title' => 'Зареєструвати домени',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Оберіть домен, який хочете зареєструвати.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Використати Інструменти з MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Оберіть домен, яким хочете управляти за допомогою інструментів з MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Користувачі з IP-адресою',
    'ui__server/ip-address/client_unknown__title' => 'Користувачі з IP-адресою',
    'ui__server/ip-address/client_unknown__description' => 'Користувачі IP-адреси %1',

    'disabled_by_admin' => 'Вимкнено адміністратором серверу',






    'ui__client/domain/chowner_multi__short-title' => 'Змініть право власності',
    'ui__client/domain/chowner_multi__title' => 'Змініть підписку права власності',
    'ui__client/domain/chowner_multi__description' => 'Змініть підписку права власності.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Оберіть домени, яким хочете змінити власника та натисніть Далі >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Змініть право власності',
    'ui__client/domain/chowner_unknown__title' => 'Змініть підписку права власності',
    'ui__client/domain/chowner_unknown__description' => 'Змініть підписку права власності.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Змініть підписку права власності',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Немає користувацьких кнопок',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'В інтерфейсі посередника %1 відсутні користувацькі кнопки.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Видалити кнопку %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Видалити',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Видалити кнопку %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Видалити користувацькі кнопки з інтерфейсу посередника',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Видалити',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Видалити кнопки користувача',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Видалити кнопки',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Виберіть посередника, користувацькі кнопки якого хочете видалити, та натисніть Далі >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Виберіть кнопки, які ви бажаєте видалити, і натисніть Далі>>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Підтвердіть видалення кнопок натисненням на прапорець на екрані, а потім натисніть Завершити.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Видалити користувацьку кнопку з інтерфейсу посередника.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Видалити',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Видалити користувацьку кнопку',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Видалити користувацьку кнопку',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Оберіть посередника, користувацьку кнопку якого хочете видалити, та натисніть Далі >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Виберіть користувацьку кнопку, яку ви бажаєте видалити, і натисніть Далі>>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Підтвердьте видалення користувацької кнопки натисненням на прапорець на екрані, і потім натисніть Закінчити.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Редагуйте властивості користувацької кнопки %1 рівня посередника.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Налаштування',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Змінити користувацьку кнопку %1 посередника.',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Додати користувацьку кнопку',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Виберіть посередника, в інтерфейсі якого ви бажаєте створити користувацьку кнопку, і натисніть кнопку Далі >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Натисніть Закінчити, щоб створити кнопку.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Змінити властивості кнопки в інтерфейсі посередника.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Параметри',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Змінити властивості кнопки в інтерфейсі посередника',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Змінити властивості користувацької кнопки',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Оберіть посередника, користувацьку кнопку якого хочете змінити, та натисніть Далі >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Оберіть користувацьку кнопку, яку ви хочете змінити, і натисніть Далі >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Коли закінчите з редагуванням властивостей кнопки, натисніть Закінчити, щоб встановити зміни і вийти з майстра.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Зробити кнопку %1 недоступною для ваших замовників.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Зробити недоступним для ваших замовників',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Зробити кнопку %1 недоступною для ваших замовників',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Зробити кнопку %1 видимою замовникам посередника.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Зробити доступним для ваших замовників',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Зробити кнопку %1 видимою  для замовників посередника',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Зробити користувацьку кнопку доступною/недоступною для ваших замовників.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Доступні/недоступні для ваших замовників.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Зробити користувацьку кнопку доступною чи недоступною для ваших замовників',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Зробити користувацьку кнопку доступною/недоступною для ваших замовників.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Виберіть посередника, користувацьку кнопку якого бажаєте зробити доступною для замовників посередника, та натисніть Далі >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Виберіть користувацьку кнопку, яку ви бажаєте зробити доступною чи недоступною для ваших замовників і натисніть Далі >>.',

    '__not_allowed' => 'Заборонений',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Виберіть нового власника домену',

    '__ip_addr_state_unknown' => "На даний момент IP-адреса не працює, тому що система не завершила обробку вашого запиту. Зачекайте хвилинку, будь ласка.",


    'resellers_list__accounts' => 'Користувачі',

    'ip_addr__repair_is_not_allowed' => 'ІР-адресу неможливо скоректувати під середовище Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Посередник %1 не має замовників.',

    'ippoolManager__ip_used_by_nohost_domain' => "ІР-адресу %%ip%% неможливо видалити, тому що вона використовується одним або кількома доменами без хостингу.",
    'ippoolManager__ip_used_for_mail_service' => "ІП-адресу %%ip%% неможливо видалити, тому що вона використовується одним або кількома доменами для їхньої ІП-адреси поштової послуги.",
    'ippoolManager__ip_used_for_send_emails' => "ІП-адресу %%ip%% неможливо видалити, тому що вона використовується для надсилання епошти з певної ІП (перегляньте Налаштування поштового сервера).",
    'ippoolManager__ip_used_in_dns_zone' => 'ІР-адресу %%ip%% неможливо видалити, тому що вона використовується DNS-зоною одного або більше доменів.',
    'ip_ctrl__cannot_manage_on_vz' => 'Ця установка Plesk працює в рамках Virtuozzo Containers. Нові IP-адреси можуть бути додані тільки адміністратором вузла Virtuozzo Containers.',

    'client_template__limits_auto_adjusted' => 'Обмеження від шаблону замовника було автоматично відрегульовано.',

    '__entries' => 'Записи',

    '__path_is_not_set' => 'Не вказаний путь. Вкажіть коректний путь.',

    'defaultcomponents__imap_required' => '(Поточний сервер електронної пошти не підтримує протокол IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk підтримує лише комерційне програмне забезпечення для обліку веб-статистики субдоменів. На даний момент у системі таке програмне забезпечення не встановлене.',


    'server_settings_invalid_traffic_statistics' => 'Недійсний параметр статистики трафіку.',
    'server_settings_invalid_logrotate_period' => 'Недійсний параметр періоду ротації журналу.',

    'spam_filter/address/file_size' => 'Неможливо вивантажити файл. Максимальний розмір файла для вивантаження дорівнює %1.',
    'spam_filter/address/file_empty_content' => 'Виникла проблема з читанням адрес електронної пошти з файлу. Переконайтеся, що ви завантажуєте файл у кодуванні UTF-8, а файл містить одну або кілька електронних адрес, і повторіть спробу.',
    'spam_filter/address/addresses_empty_content' => 'У списку немає жодної адреси електронної пошти.',
    'spam_filter/address/addresses_available' => 'Буде додано тільки перші %1 унікальні адреси електронної пошти.',
    'spam_filter/address/invalid_addresses' => 'Такі адреси електронної пошти є недійсними: %1.',
];