<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx „502 Hibás átjáró: Túl nagy élőlábat küldött a felsőbb szintű válasz fejléc olvasása közben.”',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Hamarosan elkészül.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache „500 Belső kiszolgáló hiba: FollowSymLinks beállítás itt nem engedélyezett.”',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Hamarosan elkészül.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM „kiszolgáló elérte a beállított max_children értéket.”',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Hibajelenségek</h4><ul><li><p>A következő beállítású PHP-kezelővel rendelkező webhelyek <strong>Apache által kiszolgált FPM alkalmazás</strong> vagy <strong>nginx által kiszolgált FPM alkalmazás</strong> <strong>domaineknél</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-beállítások esetén</strong> a következő problémák egyikét tapasztalja:</p><ul><li><p>lassú betöltés</p></li><li><p>nem érhető el (tartósan vagy időközönként) 50x hibával a webböngészőben:</p><pre>502 Hibás átjáró</pre><hr><pre>503 Ideiglenesen nem érhető el a szolgáltatás.</pre><hr><pre>504 Átjáró időtúllépés</pre></li></ul></li><li><p>A következő üzenet jelenik meg a PHP-FPM hiba naplófájlban <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (ahol <em>XX</em> a webhelyek által használt PHP-verzió):</p><pre>FIGYELMEZTETÉS: [pool example.com] kiszolgáló elérte a max_children beállítást (*), fontolja meg az emelését.</pre><ul><li><p>A fenti üzenetet általában ezen hiba kíséri:</p><pre>nem olvasható, amit a gyermek mond: Hibás fájlleíró (9)</pre></li></ul></li><li><p>Ha a kiszolgálón engedélyezve van az nginx, akkor a következő hibaüzenetek egyike jelenhet meg domain hiba naplófájljában <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 nem sikerült a kapcsolódás unix:///var/www/vhosts/system/example.com/php-fpm.sock esetén (11: Erőforrás ideiglenesen nem érhető el), amíg a felsőbb szinthez kapcsolódik, ügyfél: 203.0.113.2, kiszolgáló: example.com, kérelem: "GET / HTTP/1.1", felső szint: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", állomás: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 a felső szint idő előtt bezárta a kapcsolatot, a felsőbb szintű válasz fejléc olvasása közben, ügyfél: 203.0.113.2, kiszolgáló: example.com, kérelem: "POST /path/to/some/file HTTP/2.0", felsőbb szint:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>A webhely(ek) elérték a PHP-FPM <code>pm.max_children</code> értéket.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'A pm.max_children korlát emelése',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Az érintett domainek<code>pm.max_children</code> korlátjának az emelése:</p><ol><li><p>Kapcsolódás Plesk kiszolgálóhoz <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a> útján.</p></li><li><p>Az alábbi parancs segítségével keresse meg az érintett domaineket:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Megjegyzés:</strong> A bal oldali szám jelzi, hogy hányszor érte el <code>pm.max_children</code> korlátot a webhely.</div><pre style="white-space: pre-wrap;"># grep -r "kiszolgáló elérte a max_children beállítást" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Bejelentkezés a Plesk kiszolgálóba</a>.</p></li><li><p>Ugrás <strong>domainekre</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-beállítások</strong> &gt; <strong>PHP-FPM beállítások</strong>.</p></li><li><p>Növelje a domain<code>pm.max_children</code> értékét, és alkalmazza a változtatásokat. A 2. lépésben összes domain esetén növelje ezen értéket.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx „Túl sok a megnyitott fájl.”',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Nem sikerül nginx szolgáltatás indítása/újratöltése egy Plesk kiszolgálón: Túl sok fájl van megnyitva</p><h4>Hibajelenségek</h4><ul><li><p>Nem sikerül az nginx szolgáltatás indítása/újratöltése a következő hibák miatt <code>/var/log/nginx/error.log</code> fájlban:</p><pre style="white-space: pre-wrap;">nginx: [emerg] Nem sikerült () "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" megnyitása (24: Túl sok fájl van megnyitva.)</pre></li><li><p>Nem érhető el néhány vagy az összes webhely.</p></li><li><p>Figyelmeztetés jelenik meg az <strong>Eszközök és beállítások &gt; Diagnózis és javítás</strong> menüpontban:</p><pre style="white-space: pre-wrap;">Az nginx ULIMIT érték ellenőrzésekor N domain volt található a kiszolgálón. Valószínűleg a megnyitott fájlok nginx alapérelmezett korlátja miatt jelentkezik a hiba</pre></li><li><p>NodeJS és Ruby webalkamazások esetén 502 Hibás átjáró hiba jelentkezik néhány Plesk feladat végzése során, mint például domainek létrehozása, előfizetések, változtatás az Apache vagy Nginx esetén stb:</p><pre style="white-space: pre-wrap;">Kiszolgáló hiba<br>502 Hibás átjáró <br>Érvénytelen választ kapott a webkiszolgáló, amíg átjárókét vagy proxy kiszolgálóként működott.</pre></li><li><p>A <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer"> által a domain számára történt új tanúsítvány telepítését követően </a>, a régi még látható a böngészőben, azonbna a helyes tanúsítvány van kiválasztva a <strong>Domainek &gt; example.com &gt; Üzemeltetési beállítások</strong> oldalon.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Az nginx virtuális állomása 4 naplófájlt nyit meg mindegyik fizikai üzemeltetésű virtuális állomás számára:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Ennek eredményeként a domainek nagy száma (általában 100-nál több) miatt az nginx kiszolgálók túllépték a megnyitott fájlok maximális számát.</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Megnyitott fájl szám korlát emelése',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Figyelmeztetés:</strong> <code>websrv_ulimits</code> segédprogram <strong>--no-restart</strong> beállítása nélküli végrehajtása valamennyi domain webkonfigurációs fájljának újraépítését kezdeményezi, és jelentős állásidőt okozhat nagy számú üzemeltetett webhely esetében.<br><br>Karbantartási időszakban hajtsa végre a parancsot.</div><p>Jó gyakorlat a megnyitott fájl korlátnak <strong> a Plesk domainjei számánál nagyobbra való beállítása * legalább 16-ra</strong>. Az alábbi példában kerül ismertetésre a korlát 4096-ra való beállítása:</p><ol><li><p>Kapcsolódás a kiszolgálóhoz <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH útján</a></p></li><li><p>A megnyitott fájl korlát 4096-ra állítása Apache és Nginx esetén:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Apache és nginx szolgáltatás újraindítása <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk helyen</a> &gt;</strong> <strong>Eszközök és beállítások &gt; Szolgáltatások kezelése</strong> a változtatások alkalmazására.</p></li><li><p>Ellenőrizze, hogy megfelelően történt-e a „Maximálisan megnyitott fájl korlát” alkalmazása a webszolgáltatások újraindítása után:</p><pre># grep „Megnyitott fájlok maximális száma” /proc/$(cat /var/run/nginx.pid)/limits<br>4096 a megnyitott fájlok maximális száma, 4096 fájl</pre></li><li><p>Ha nem segít a fenti megoldás, akkor az <code>ulimit</code> segédprogram használatával végezz el a korlát beállítását:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity „Túl nagy a válasz szövegtörzse.”',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Hamarosan elkészül.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "403 kóddal elutasítva a hozzáférés."',
    'problem-detail.modsec-access-denied.description' => '<h4>Hibajelenségek</h4><ul><li><p>A ModSecurity telepítve és engedélyezve van az <strong>Eszközök és beállítások > Webalkalmazás tűzfala (ModSecurity) > Webalkalmazás tűzfal mód > Be</strong> beállítással.</p></li><li>Nem sikerült betölteni a Plesk kiszolgálón üzemeltetett egyik webhelyet. Nem lehet olyan műveleteket végezni a webhelyen, mint a WordPress kezelése, webes levelezéshez való hozzáférés, vagy <code>robots.txt</code> fájlhoz való hozzáférés. A következő hibák egyikét jelezheti a böngésző: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Tiltott</pre><hr><pre>500 Belső kiszolgálóhiba</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Egy az alábbihoz hasonló ModSecurity hibaüzenet jelenik meg <code>/var/log/modsec_audit.log</code> naplófájlban, vagy Plesk (<strong>Domainek</strong> &gt; <strong>example.com</strong> &gt; <strong>Naplók</strong>) oldalán: <pre>ModSecurity: Hozzáférés megtagadva 403-as kóddal (2. fázis). 5 a nagyobb vagy egyenlő műveleti jel utáni bejövő anomália pontszám. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Bejövő anomália pontszám túllépése történt (Összes pontszám: 5)"] [severity "KRITIKUS"] [címke "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [egyedi azonosító "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity webalkalmazás tűzfala engedélyezett egy olyan nagyon korlátozó szabálykészlet által, mint az OWASP, Comodo vagy egy olyan egyéni szabálykészlet, mint az Imunify360. A korlátozó szabálykészleek blokkolhatnak néhány műveletet a webhelyen.</p><p><Strong>Megjegyzés:</strong> A kiszolgáló elleni támadást jelezhet a ModSecurity hiba. Kizárólag az alábbi megoldásokat használja, ha biztos abban, hogy a webhelye jogos használatát blokkolja.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'ModSecurity szabálykészlet azonosítóval vagy címkével való letiltása',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Keresse meg azon szabálykészlet azonosítóját, amely a webhelye jogos használatát blokkolja. A <code>/var/log/modsec_audit.log</code> naplófájlban a hibaüzenetekben találhatóak meg az azonosítók. Az azonosító <code>id</code> előtaggal együtt zárójelekben szereplő egész szám, például, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Megadott szabálykészletek letiltása a Plesk kiszolgálóban</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Másik ModSecurity szabálykészletre átkapcsolás',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Kapcsoljon át egy kevésbé szigorú ModSecurity szabálykészletre, például, "Atomic ModSecurity szabálykészlet". Ehhez ugorjon az <strong>Eszközök és beállítások</strong> > <strong>Webalkalmazás tűzfal (ModSecurity)</strong> > <strong>Beállítások</strong> menüpontra és válassz aki az <strong>Atomic Standard</strong> szabálykészletet, majd kattintson az <strong>OK</strong> gombra a változtatások alkalmazásához.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "500-as belső kiszolgáló hiba: Elfogyott az engedélyezett XXX memóriaméret."',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Hibajelenségek</h4><ul><li><p>Nem érhető el a Plesk kiszolgálón üzemeltetett egyik webhely:</p><pre>500 Belső kiszolgálóhiba</pre></li><li><p>A következő hiba látható a webhely naplójában:</p><pre>Kapott hibaüzenet "PHP üzenet: PHP súlyos hiba: Betelt az engedélyezett a 4194304 bájtos memóriaméret (4000032 bájtot próbált lefoglalni) /var/www/vhosts/example.com/httpdocs/somethingBig.php esetén a 3. sorban."</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Nem rendelkezik a webhely elegendő lefoglalt területtel a feldolgozáshoz.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Emelje meg a webhely memóriakorlátját.',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Olvassa el a Tudásbázis cikket, és tartsa be az utasításokat</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP „open_basedir korlátozás van érvényben.”',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Hibajelenségek</h4><ul><li><p>A webböngésző egyik alábbi hibája miatt nem érhető el a webhely:</p><pre>404 Nem található a fájl.</pre><hr><pre>500 Belső kiszolgálóhiba</pre><hr><pre>500 move_uploaded_file() hiba: a hatályos open_basedir korlátozás. Fájl (/path/to/the/directory) nincs az engedélyezett elérési út(ak)on: (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>A következő hibaüzenet jelenik meg a domain Naplók oldalán (<strong>Domainek</strong> > <strong>example.com</strong> > <strong>Naplók</strong>):</p><pre><...> a hatályos open_basedir korlátozás. Fájl (/path/to/the/directory) nincs az engedélyezett elérési út(ak)on <...></pre><hr><pre>Kezeletlen kivétel: Munkamenet: A konfigurált mentett elérési út "/path/to/the/directory" nem egy könyvtár, nem létezik vagy nem hozható létre.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'A PHP-parancsprogram próbál olyan könyvtárhoz férni, amely nem engedélyezett a számára. Ez a korlátozás domainenként egyénileg van meghatározva a PHP <code>open_basedir</code> irányelvben. Alapértelmezés szerint, <code>open_basedir</code> hozzáférést engedélyez a <code>ideiglenes</code> és domain dokumentum gyökérkönyvtárhoz, illetve a rendszer alapértelmezett munkamenet elérési útjához.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'További elérési út adása open_basedir irányelvhez',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Olvassa el a Tudásbázis cikket, és tartsa be az utasításokat</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'open_basedir irányelv letiltása',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Ugorjon a <strong>Domainek, example.com és PHP-beállítások</strong> oldalra, és "none" beállítást válasszon ki <code>open_basedir</code> irányelv számára.</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Tiltott AH01797: a kiszolgáló elutasított az ügyfelet."',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Hibajelenségek</h4><ul><li><p>A következőhöz hasonló hiba jelentkezik a webhelyen:</p><pre>403 Kiszolgáló hiba<br>Tiltott</pre></li><li><p>A <code>/var/www/vhosts/system/example.com/logs/error_log</code> naplófájl tartalmaz a következőhöz hasonló hibákat:</p><pre>AH01797: ügyfél a kiszolgáló konfigurációja miatt lett elutasítva: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>A jelenlegi Apache konfiguráció nem engedélyezi a webhelyhez való hozzáférést.</p><p>Az olyan fájlok esetén, mint .htaccess és .htpasswd, ere szükség van, mivel ezek a fájlok nem érhetőek el a webkiszolgálón keresztül.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Ellenőrizze a kiszolgáló konfigurációját és a .htaccess fájlokat.',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Olvassa el a Tudásbázis cikket, és tartsa be az utasításokat</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache „Nem lehet hozzáférni a webhely könyvtárához a Plesk kiszolgálóban: 403 tiltott”',
    'problem-detail.apache-no-directory-index.description' => '<h4>Hibajelenségek</h4><ul><li><p>Nem érhető el a webhely megadott helye, például, <code>http://example.com/some_folder</code>. A következő hiba áll fenn:</p><pre>403 Kiszolgáló hiba<br>Tiltott</pre></li><li><p>A következő hibaüzenet jelenik meg <code>/var/www/vhosts/example.com/logs/error_log<code/> fájlban:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Nem lehet könyvtárat használni /var/www/vhosts/example.com/httpdocs/some_folder/: Nem található egyező könyvtár index (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml), és a Beállítások irányelv letiltotta a kiszolgáló által generált könyvtár indexek használatát.</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Nem tartalmaz indexfájlokat a kért könyvtár, vagy nem engedélyezett a könyvtár böngészése.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Indexfájl könyvtárhoz adása',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Olvassa el a Tudásbázis cikket, és tartsa be az utasításokat.</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Könyvtárböngészés engedélyezése',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Olvassa el a Tudásbázis cikket, és tartsa be az utasításokat</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx „Nem lehet hozzáférni a webhely könyvtárához a Plesk kiszolgálóban: 403 tiltott”',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Hibajelenségek</h4><ul><li><p>Nem érhető el a webhely megadott helye, például, <code>http://example.com/some_folder</code>. A következő hiba áll fenn:</p><pre>403 Kiszolgáló hiba<br>Tiltott</pre></li><li><p>A következő hibaüzenet jelenik meg <code>/var/www/vhosts/example.com/logs/error_log fájlban</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Nem lehet könyvtárat használni /var/www/vhosts/example.com/httpdocs/some_folder/: Nem található egyező könyvtár index (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml), és a Beállítások irányelv letiltotta a kiszolgáló által generált könyvtár indexek használatát.</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Nem tartalmaz indexfájlokat a kért könyvtár, vagy nem engedélyezett a könyvtár böngészése.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Indexfájl könyvtárhoz adása',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Olvassa el a Tudásbázis cikket, és tartsa be az utasításokat.</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Könyvtárböngészés engedélyezése',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Olvassa el a Tudásbázis cikket, és tartsa be az utasításokat.</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache „kiszolgáló elérte a MaxRequestWorkers beállítást”.',
    'problem-detail.apache-reached-max-request-workers.description' => 'Hamarosan elkészül.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'A PHP-kérelem szövegtörzs korlátja „túl nagy szövegtörzset akar az ügyfél küldeni.”',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Hamarosan elkészül.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'A PHP-kérelem szövegtörzs korlátja „túl nagy szövegtörzset akar az ügyfél küldeni.”',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Hamarosan elkészül.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP-munkamenetek „ 503 Belső kiszolgáló hiba” vagy „Nem sikerült a munkamenet adatainak az olvasás.”',
    'problem-detail.php-failed-to-read-session-data.description' => 'Hamarosan elkészül.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess „403 Tiltott: pcfg_openfile: nem ellenőrizhető htaccess fájl, gondoskodjon arról, hogy olvasható legyen.”',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Hibajelenségek</h4><ul><li><p>Nem működik a Plesk kiszolgálón üzemeltetett egyik webhely:</p><pre>Nem rendelkezik e kiszolgálóhoz való hozzáféréshez szükséges engedéllyel/ezen a kiszolgálón. <br> Tivébbé egy 403 Tiltott hiba jelentkezett, amikor a kérés teljesítése érdekében megpróbált egy Hiba dokumentumot használni.</pre><p>A fenti hiba helyett az üres oldalt is láthatja.</p></li><li><p>A következőket tartalmazza a domain hibanapló a <strong>Domainek, example.com és Naplók</strong> helyen:</p><pre>(13) Engedélykérés elutasítva: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: nem tudja ellenőrizni htaccess fájlt, gondoskodjon arról, hogy olvasható "/var/www/vhosts/example.com/httpdocs/" és végrehajtható legyen.</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Helytelenek a domain fájlok vagy mappák engedélyei.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Webhely tartalom javítási engedélyek',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Olvassa el a Tudásbázis cikket, és tartsa be az utasításokat</a>.</p></li></ol>',
];