<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.title' => 'Instellingen bewerkingslogboek',
    'action-log.logFiles' => "Logbestanden",
    'action-log.fromDate' => "van:",
    'action-log.toDate' => "Aan:",
    'action-log.clearLog' => "Logbestand leegmaken",
    'action-log.downloadLog' => "Downloaden",
    'action-log.loggedActions' => "In logboek vastgelegde bewerkingen",
    'action-log.storeLogsInDb' => "Records opslaan in de database",
    'action-log.storeNumber' => "Ingangen",
    'action-log.dontRemoveRecs' => "Geen records verwijderen",
    'action-log.confirmCleanLog' => "Weet u zeker dat u de geselecteerde ingangen uit het bewerkingslogboek wilt verwijderen?",
    'action-log.incorrectDate' => "Ongeldige datum opgegeven.",
    'action-log.incorrectNumPeriods' => "Ongeldige periode voor opschoning opgegeven.",
    'action-log.incorrectNumRecords' => "Ongeldig aantal records opgegeven.",
    'action-log.yes' => "Ja",
    'action-log.no' => "Nee",
    'action-log.mixed' => "(gemengd)",
    'action-log.period' => "Periode",
    'action-log.invalidDatePeriod' => "Ongeldige datumperiode",
    'action-log.submitDone' => "Wijzigingen in de instellingen van het bewerkingslogboek zijn opgeslagen.",
    'action-log.clearDone' => "Bewerkingslogboek opgeschoond.",
    'action-log.periodDay' => "dagen",
    'action-log.periodWeek' => "weken",
    'action-log.periodMonth' => "maanden",

    'admin-info.adminInfoSection' => 'Informatie voor de beheerder',
    'admin-info.description-admin' => 'Omschrijving van beheerder',
    'admin-info.description-reseller' => 'Omschrijving van reseller',
    'admin-info.description-owner' => 'Omschrijving van houder',
    'admin-info.description' => 'Omschrijving',
    'admin-info.descriptionSuccess' => 'Het omschrijving is bijgewerkt.',
    'admin-info.longDescription' => 'De opgegeven omschrijving is te lang. Het mag niet langer zijn dan %%max%% karakters.',
    'admin-info.add' => 'Omschrijving toevoegen',
    'admin-info.edit' => 'Bewerken',
    'admin-info.remove' => 'Verwijderen',
    'admin-info.confirmOnRemove' => 'Wilt u deze omschrijving verwijderen?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% van cliënt %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% van reseller %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% van abonnement %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% van %%name%%',
    'admin-info.popupHint-admin' => 'Deze omschrijving is alleen zichtbaar voor de beheerder.',
    'admin-info.popupHint-reseller' => 'Deze omschrijving is zichtbaar voor de reseller en beheerder.',
    'admin-info.popupHint-owner' => 'Deze omschrijving is zichtbaar voor de auteur en voor de hostingprovider van de auteur.',
    'admin-info.customerDescriptionHint' => 'Cliënten kunnen deze omschrijving niet zien.',
    'admin-info.subscriptionDescriptionHint' => "Deze informatie is alleen zichtbaar voor de hostingprovider (de beheerder of reseller van Plesk).",

    'apache-settings.formGeneralHint' => 'Hier kunt u de instellingen voor de Apache-webserver voor deze website configureren. Een aangepaste configuratie voor Apache kan nuttig zijn als u een nieuw soort index-bestand wilt gebruiken voor uw website of u wilt een specifiek MIME-type koppelen aan bepaalde bestandextensies. De waarde Standaard betekent dat Apache de bijbehorende opdrachten zal gebruiken uit de configuratie voor de server als geheel. Als Apache gebruik maakt van nginx als frontend-server, dan kunt u op deze pagina ook de instellingen voor nginx opgeven.',
    'apache-settings.general' => 'Algemene Apache-instellingen',
    'apache-settings.example' => "Bijvoorbeeld:\n%%example%%",
    'apache-settings.settingOn' => 'Aan',
    'apache-settings.settingOff' => 'Uit (Standaard)',
    'apache-settings.settingDefault' => 'Standaard',
    'apache-settings.settingCustom' => 'Aangepaste waarde invoeren',
    'apache-settings.mimeTypes' => 'MIME-typen',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME-typen koppelen bestandsextensies aan bestandstypen. Dit wordt meestal gebruikt om een aangepaste bestandsextensie aan te maken voor veel voorkomende bestandstypen.',
    'apache-settings.handlers' => 'Handlers',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache-handlers bepalen hoe bestanden met bepaalde extensies door de webserver worden verwerkt wanneer ze worden opgehaald. De tekenreeks \\'php-script .script\\' betekent dat Apache .script-bestanden zal behandelen als PHP-scripts.",
    'apache-settings.deny' => 'Toegang tot de site weigeren',
    'apache-settings.allow' => 'Exclusief',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDe opgegeven hosts en netwerken hebben geen toegang tot de site. Gebruik \\'*\\' te weigeren alle verbindingen .",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nDe opgegeven hosts en netwerken hebben geen toegang tot de site.",
    'apache-settings.directoryIndex' => 'Index-bestanden',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache zal op zoek gaan naar de opgegeven bestanden wanneer de index-pagina van de site wordt opgevraagd.",
    'apache-settings.expires' => 'Verloopt',
    'apache-settings.expiresStaticOnly' => 'alleen een antwoord met Expires-headers versturen voor statische bestanden',
    'apache-settings.expiresFullDescription' => 'De webserver zal de responseheader “Expires” aan webpagina\'s toevoegen.Het tijdstempel voor het verloopmoment wordt berekend door de hoeveelheid tijd die hierboven is opgegeven toe te voegen aan de tijdstip waarop de webpagina werd opgevraagd.',
    'apache-settings.expiresStaticOnlyDescription' => 'De header "Expires" zal alleen worden toegevoegd aan statische bestanden.Welke bestanden worden beschouwd als statisch wordt bepaald door de opties "Slimme verwerking van statische bestanden" en "Statische bestanden rechtstreeks door nginx laten afleveren".',
    'apache-settings.expiresUnitDays' => 'dagen',
    'apache-settings.expiresUnitHours' => 'uren',
    'apache-settings.expiresUnitMinutes' => 'minuten',
    'apache-settings.expiresUnitSeconds' => 'seconden',
    'apache-settings.headers' => 'Aanvullende headers',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "De webserver zal de opgegeven HTTP-antwoordheaders toevoegen.",
    'apache-settings.restrictFollowSymLinks' => 'De mogelijkheid tot het volgen van symbolische links beperken',
    'apache-settings.restrictFollowSymLinksDescription' => "Selecteer deze optie om het gebruik van de opdracht FollowSymLink in .htaccess door gebruikers te verbieden en daarmee de beveiliging van de server te vergroten.",
    'apache-settings.nginx' => 'instellingen voor nginx',
    'apache-settings.nginxProxyMode' => 'Proxy-modus',
    'apache-settings.nginxProxyModeDescription' => 'Aanvragen bij Apache door Nginx-proxies. Uitschakelen als u Apache niet langer wilt gebruiken.',
    'apache-settings.nginxTransparentMode' => 'Slimme verwerking van statische bestanden',
    'apache-settings.nginxTransparentModeDescription' => 'Indien uitgeschakeld, zal Apache alle verzoeken voor statische bestanden verwerken; nginx zal alleen verzoeken en antwoorden doorgeven zonder deze aan te passen. Schakel deze optie alleen uit tijdens het oplossen van problemen.',
    'apache-settings.nginxServeStatic' => 'Statische bestanden rechtstreeks door nginx laten afleveren',
    'apache-settings.nginxStaticExtensions' => 'Geef bestandextensies op die zijn gescheiden met een spatie of met het symbool "|". Verzoeken om deze bestanden zullen worden verwerkt door nginx en nooit terecht komen bij Apache. Voorzichtig: de rewrite rules van Apache zullen nooit worden toegepast.',
    'apache-settings.nginxServePhp' => 'PHP-verwerking door nginx',
    'apache-settings.nginxServePhpDescription' => 'PHP-files (.php) zullen worden verwerkt door nginx en PHP-FPM. Indien uitgeschakeld worden PHP-bestanden verwerkt door Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Maximaal toegestane grootte van body van HTTP-verzoek',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Aanvragen waarvan de body groter is dan de beperking worden genegeerd met HTTP 413 Payload Too Large (stelt de waarde van de nginx-richtlijn "client_max_body_size" in).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'Optie is uitgeschakeld voor het hele systeem via een lege waarde of nulwaarde bij de instructie "clientMaxBodySize" in panel.ini',
    'apache-settings.nginxCacheEnabled' => 'nginx-caching inschakelen',
    'apache-settings.nginxCacheEnabledDescription' => 'Caching kan de snelheid waarmee de website wordt geladen verhogen en de belasting van de server verminderen, maar u moet oppassen met het gebruik.',
    'apache-settings.nginxCacheSize' => 'Cache-omvang',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Cache-timeout',
    'apache-settings.nginxCacheTimeoutDays' => 'dagen',
    'apache-settings.nginxCacheTimeoutHours' => 'uren',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minuten',
    'apache-settings.nginxCacheTimeoutSeconds' => 'seconden',
    'apache-settings.nginxCacheKey' => 'Cache-sleutel',
    'apache-settings.nginxCacheCookies' => 'Cache-verzoeken met cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Caching uitschakelen voor locaties',
    'apache-settings.nginxCacheBypass' => 'Cache niet gebruiken in geval van',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'er HTTP no-cache-headers met het verzoek zijn meegestuurd',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'er HTTP autorisatie-headers met het verzoek zijn meegestuurd',
    'apache-settings.nginxCacheBypassGetNocache' => 'de parameter GET nocache met het verzoek is meegestuurd',
    'apache-settings.nginxCacheUseStale' => 'Oude records uit de cache terugsturen',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream geeft een 5xx-foutmelding aan de zijde van de server',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream geeft een 4xx-foutmelding aan de zijde van de client',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Cache wordt nu bijgewerkt',
    'apache-settings.additional' => 'Aanvullende opdrachten voor Apache',
    'apache-settings.additionalSettingsDescription' => 'Als u een specifieke instellingen niet kunt vinden, dan kunt u deze toevoegen in de onderstaande velden. Deze instellingen zullen de plaats innemen van de Apache-opdrachten voor de server als geheel. De opdrachten uit het eerste veld zullen worden gebruikt wanneer een bezoeker de site benadert via HTTP. Het tweede veld bevat de opdrachten voor HTTPS. Meestal wilt u uw opdrachten aan beide velden toevoegen. Gebruik dezelfde syntax als die u voor httpd.include gebruikt. Als u bijvoorbeeld een aangepaste foutmeldingspagina wilt instellen, voeg dan de volgende regel toe: ErrorDocument 401 /mijn_foutmeldingspagina.html',
    'apache-settings.additionalSettings' => 'Aanvullende opdrachten voor HTTP',
    'apache-settings.additionalSslSettings' => 'Aanvullende opdrachten voor HTTPS',
    'apache-settings.additionalSettingsError' => 'Ongeldige Apache-configuratie: %%error%%',
    'apache-settings.rollbackFailed' => 'Kan het huidige configuratiebestand van Apache niet gebruiken maar ook niet terugkeren naar de vorige versie van het bestand omdat deze ongeldige instellingen bevatten.',
    'apache-settings.additionalNginx' => 'Aanvullende opdrachten voor nginx',
    'apache-settings.additionalNginxSettingsDescription' => 'Hier kunt u de instellingen opgeven voor de nginx reverse proxyserver die nog voor Apache wordt uitgevoerd. Uw opdrachten zullen in de plaats komen van de nginx-configuratie voor de server als geheel. Bijvoorbeeld: u wilt de time-out van verbindingen wijzigen, of u wilt aanvragen comprimeren met gzip. Gebruik dezelfde syntax als die u voor nginx.conf gebruikt. Om bijvoorbeeld alle aanvragen via proxies te comprimeren met gzip, voegt u de volgende regel toe: \\\'gzip_proxied any;\\\'.',
    'apache-settings.additionalNginxSettings' => 'Aanvullende opdrachten voor nginx',
    'apache-settings.additionalNginxSettingsError' => 'Ongeldige nginx-configuratie: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Kan het huidige configuratiebestand van nginx niet gebruiken maar ook niet terugkeren naar de vorige versie van het bestand omdat deze ongeldige instellingen bevatten.',
    'apache-settings.clearCache' => 'Cache leegmaken',
    'apache-settings.clearCacheHint' => 'nginx-cache leegmaken voor %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Het leegmaken van de cache is geslaagd',

    'backup.backup-password-protection.securitySettingsSection' => 'Instellingen voor beveiliging reservekopieën',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Wachtwoord ophalen uit de instellingen van de externe opslag',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Wachtwoord handmatig opgeven',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Wachtwoord geven',
    'backup.backup-password-protection.backupPassword' => 'Wachtwoord',
    'backup.backup-password-protection.inputPasswordType' => 'Type wachtwoord',
    'backup.backup-password-protection.confirmBackupPassword' => 'Wachtwoord herhalen',
    'backup.backup-password-protection.backupPasswordHint' => 'Als u uw wachtwoord bent vergeten, zorg dan dat deze optie niet is geselecteerd. Merk op dat in dit geval sommige gevoelige gegevens niet juist zullen worden teruggeplaatst. Wachtwoorden van gebruikers zullen bijvoorbeeld worden vervangen door nieuwe, willekeurig gekozen wachtwoorden, informatie over geïnstalleerde apps zal verloren gaan, enzovoorts.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Als u deze reservekopie met een wachtwoord hebt afgeschermd, geef dan het wachtwoord op in de velden hieronder. Merk op dat als u een onjuist wachtwoord opgeeft, de reservekopie niet zal worden teruggeplaatst. In plaats daarvan zal er een kopie worden gemaakt in de lokale opslag.',

    'backup.conflict-database.dbMappingLegend' => 'Mapping van database-server',
    'backup.conflict-database.serverType' => 'Servertype',
    'backup.conflict-database.hostName' => 'Hostnaam',
    'backup.conflict-database.port' => 'Poort',
    'backup.conflict-database.destinationDbServer' => 'Database-server van bestemming',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'De database kan niet worden teruggeplaatst: er is geen geschikte database-server.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'IP-toewijzingsbestand uploaden',
    'backup.conflict-ip.ipMappingLegend' => 'IP-toewijzing',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Huidige IP-toewijzingen opslaan in bestand',
    'backup.conflict-ip.ipAddressNotFound' => 'Er zijn geen beschikbare IP-adressen van dit type.',
    'backup.conflict-ip.sharedIp' => 'gedeeld',
    'backup.conflict-ip.dedicatedIp' => 'exclusief',
    'backup.conflict-ip.fileNotFound' => 'Het bestand kan niet leeg zijn.',
    'backup.conflict-ip.invalidIpToMap' => 'Een ongeldige waarde voor een oud IP-adres: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Een ongeldige waarde voor een nieuwe IP-adres: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'Het IP-adres %%ip%% is niet gevonden in de database.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'IP-toewijzingsbestand uploaden',
    'backup.conflict-ip.ipMappingFileHint' => 'Het bestand met IP-toewijzingen bevat slechts platte tekst. Elke regel van dit bestand bevat een IP-toewijzing in het formaat: <oud IP-adres> <nieuw IP-adres>',
    'backup.conflict-ip.oldIp' => 'Oude IP-adressen',
    'backup.conflict-ip.newIp' => 'Nieuwe IP-adressen',

    'backup.copy-to-server.ignoreBackupSign' => 'Reservekopieën uploaden zonder geldige handtekening',
    'backup.copy-to-server.wrongPassword' => 'Het opgegeven wachtwoord is onjuist. Tijdens het terugplaatsen van de reservekopie zal Plesk u vragen om uw wachtwoord opnieuw in te voeren.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'De reservekopie %%fileName%% is aangepast, beschadigd, of aangemaakt op een andere server of in een oudere versie van Plesk Panel die het ondertekenen van reservekopieën niet ondersteunt. Voordat u de gegevens uit deze reservekopie kunt terugplaatsen moet u er zeker van zijn dat u de bron van dit bestand kunt vertrouwen.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Kan reservekopie niet uploaden %%fileName%%. Het bestand bevat gewijzigde of beschadigde gegevens, of is aangemaakt op een andere server of in een oudere versie van Plesk. Om gegevens uit dit bestand terug te plaatsen moet u contact opnemen met de uw hostingprovider.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Kan reservekopie niet uploaden %%fileName%%. Het bestand is aangepast, beschadigd, of aangemaakt op een andere server of in een oudere versie van Plesk die het ondertekenen van reservekopieën niet ondersteunt. Als u deze reservekopie vertrouwt, selecteer dan het selectievakje "Reservekopieën uploaden zonder geldige handtekening" en herhaal het uploaden.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Kan de geselecteerde reservekopie %%fileName%% niet naar de opslag van de server verplaatsen. Foutmelding: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "De volgende delen van de incrementele reservekopie zijn niet gekopieerd:%%endl%%%%missedParts%%%%endl%%Kopieer de ontbrekende onderdelen.",

    'backup.ftp-settings.isActive' => 'Gebruik FTP(S)-opslag',
    'backup.ftp-settings.host' => 'Hostnaam of IP van FTP-server',
    'backup.ftp-settings.directory' => 'Map voor opslag van reservekopieën',
    'backup.ftp-settings.directoryHint' => 'Bijvoorbeeld /mijnmap/mijnreservekopieen/',
    'backup.ftp-settings.ftpLogin' => 'FTP-gebruikersnaam',
    'backup.ftp-settings.ftpPassword' => 'FTP-wachtwoord',
    'backup.ftp-settings.usePassiveMode' => 'Passieve modus gebruiken',
    'backup.ftp-settings.useFtps' => 'FTPS gebruiken',
    'backup.ftp-settings.errorHostIsLocal' => 'Het gebruik van de lokale FTP-server van Plesk als externe opslag is niet toegestaan. Geef een daadwerkelijk externe locatie op.',
    'backup.ftp-settings.warningHostIsLocal' => 'De instellingen voor FTP(S)-opslag zijn ingesteld voor het opslaan van reservekopieën op dezelfde server waar ook de bestanden van uw abonnementen zich bevinden. Deze configuratie is niet aan te raden, omdat het een risico van dataverlies en meerverbruik van schijfruimte met zich meebrengt.',
    'backup.ftp-settings.enterFtpLogin' => 'Geef een juiste gebruikersnaam op.',
    'backup.ftp-settings.enterFtpPassword' => 'Geef een correct wachtwoord op.',

    'backup.remote-settings.isActive' => 'De opslag gebruiken',
    'backup.remote-settings.initError' => 'Kan de pagina met instellingen voor %%extName%% niet initialiseren: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Instellingen voor beveiliging reservekopieën',

    'backup.restore.detailsSection' => 'Details',
    'backup.restore.contentInfoSection' => 'Inhoud van reservekopie',
    'backup.restore.restorationOptionsSection' => 'Herstelopties',
    'backup.restore.emailNotification' => 'Als het terugplaatsen is voltooid, stuur dan een melding naar',
    'backup.restore.comments' => 'Opmerkingen',
    'backup.restore.creationDate' => 'Datum van aanmaken',
    'backup.restore.systemNotes' => 'Systeem-opmerkingen',
    'backup.restore.ownerAdmin' => 'Aangemaakt door de beheerder.',
    'backup.restore.ownerReseller' => 'Aangemaakt door een reseller.',
    'backup.restore.ownerCustomer' => 'Aangemaakt door een cliënt.',
    'backup.restore.ownerServiceUser' => 'Aangemaakt door een aanvullende gebruiker.',
    'backup.restore.partOfParentBackup' => 'Onderdeel van de %%type%%-reservekopie.',
    'backup.restore.server' => 'server',
    'backup.restore.reseller' => 'reseller',
    'backup.restore.client' => 'cliënt',
    'backup.restore.incremental' => 'Incrementeel.',
    'backup.restore.multiVolume' => 'Meerdelig.',
    'backup.restore.backupSize' => 'Omvang van reservekopie',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (deze toevoeging) + %%base%% (initiële reservekopie) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (deze toevoeging) + %%prev%% (eerdere toevoegingen) + %%base%% (initiële reservekopie) = %%total%%',
    'backup.restore.download' => 'Downloaden',
    'backup.restore.downloadHint' => 'Download reservekopie naar uw lokale computer.',
    'backup.restore.downloadDisabled' => 'Het is tijdelijk niet mogelijk om reservekopieën te downloaden. Probeert u het later opnieuw of neem contact op met uw provider.',
    'backup.restore.copy' => 'Naar serveropslag kopiëren',
    'backup.restore.copyHint' => 'Geselecteerde reservekopieën naar serveropslag kopiëren.',
    'backup.restore.contentInfo' => 'Reservekopie bevat',
    'backup.restore.restoreButton' => 'Terugplaatsen',
    'backup.restore.mail' => 'Mail',
    'backup.restore.domainConfiguration' => 'Domein-instellingen',
    'backup.restore.virtualHost' => 'Bestanden van virtuele host',
    'backup.restore.database' => 'Databases',
    'backup.restore.serverConfiguration' => 'Server-instellingen',
    'backup.restore.serverConfigurationLicense' => 'Licentiesleutel',
    'backup.restore.serverPersonalConfiguration' => 'Instellingen beheerderaccount',
    'backup.restore.serverPersonalDomains' => 'Domeinen van de beheerder',
    'backup.restore.serverPersonalClients' => 'Cliënten van de beheerder',
    'backup.restore.resellers' => 'Resellers',
    'backup.restore.resellerPersonalConfiguration' => 'Instellingen reselleraccount',
    'backup.restore.resellerPersonalDomains' => 'Domeinen van de reseller',
    'backup.restore.resellerPersonalClients' => 'Cliënten van reseller',
    'backup.restore.clientPersonalConfiguration' => 'Instellingen cliëntaccount',
    'backup.restore.clientPersonalDomains' => 'Domeinen van cliënt',
    'backup.restore.restoreModifiedSection' => 'De reservekopie terugplaatsen ondanks de beschadigde handtekening',
    'backup.restore.restoreModifiedDump' => 'Deze reservekopie terugplaatsen ondanks dat deze niet beschikt over een geldige handtekening',
    'backup.restore.resolutionPolicy' => 'Oplossingsbeleid',
    'backup.restore.resolutionPolicyDescription' => 'Datumconflicten doen zich voor als het herstelde object al in het systeem aanwezig is, maar met een recentere datum waarop het voor het laatst is bewerkt, of als herstelde objecten momenteel niet in het systeem aanwezig zijn.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Het opgegeven wachtwoord is onjuist. De reservekopie zal worden gekopieerd naar de lokale opslag van de server.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Kan de reservekopie niet terugplaatsen. Het opgegeven wachtwoord is onjuist.',
    'backup.restore.serverContentAndConfiguration' => 'Serverinstellingen en -gegevens',
    'backup.restore.serverConfigurationOnly' => 'Serverinstellingen',
    'backup.restore.resellerContentAndConfiguration' => 'Instellingen en gegevens reselleraccount',
    'backup.restore.resellerConfigurationOnly' => 'Instellingen reselleraccount',
    'backup.restore.clientContentAndConfiguration' => 'Instellingen en bestanden van cliëntaccount',
    'backup.restore.clientConfigurationOnly' => 'Instellingen cliëntaccount',
    'backup.restore.domainContentAndConfiguration' => 'Instellingen en gegevens van domein',
    'backup.restore.domainConfigurationOnly' => 'Domein-instellingen',
    'backup.restore.restoreType' => 'Wat wilt u terugplaatsen?',
    'backup.restore.restoreTypeFull' => 'Alle objecten (het hele systeem)',
    'backup.restore.restoreTypeGranular' => 'Geselecteerde objecten',
    'backup.restore.restoreObjectType' => 'Soort objecten om terug te plaatsen',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abonnement',
    'backup.restore.restoreObjectTypeCustomers' => 'Cliënt',
    'backup.restore.restoreObjectTypeResellers' => 'Reseller',
    'backup.restore.restoreObjectTypeMailUsers' => 'Mailaccount',
    'backup.restore.restoreObjectTypeDatabases' => 'Database',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS-certificaten',
    'backup.restore.restoreObjectTypeSites' => 'Sites',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS-zone',
    'backup.restore.restoreObjectTypeMailLists' => 'Verzendlijsten',
    'backup.restore.restoreObjectTypeWebContent' => 'Bestanden of domeinen',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Geselecteerde bestanden',
    'backup.restore.restoreSubscriptionLookup' => 'Abonnement',
    'backup.restore.restoreComponents' => 'Terug te plaatsen componenten',
    'backup.restore.errorLog' => 'Foutmelding-log',
    'backup.restore.backupDetailsLogDoesntExist' => 'Het logbestand van reservekopieën is niet beschikbaar.',
    'backup.restore.dumpFailedSection' => 'Foutmelding-log',
    'backup.restore.dumpFailed' => 'Kan de gegevens niet terugplaatsen: de reservekopie is ongeldig.',
    'backup.restore.granularNotSupported' => 'U kunt alleen objecten selecteren om terug te plaatsen vanuit een reservekopie die is aangemaakt in Plesk 12.0 of later.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Het terugplaatsen van alle gegevens uit reservekopieën wordt niet ondersteund in de Power User-weergave van resellers. Selecteer de objecten die u wilt herstellen. U kunt de weergave van uw interface wijzigen via %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Schermvoorkeuren',
    'backup.restore.contentRestoreType' => 'Terugplaatsen',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Alleen instellingen van de geselecteerde objecten',
    'backup.restore.contentRestoreTypeFull' => 'Instellingen en inhoud van de geselecteerde objecten',
    'backup.restore.errorWrongFormat' => 'Kan de reservekopie niet terugplaatsen: het bestand is niet op de juiste manier opgemaakt.',
    'backup.restore.errorContentError' => 'Kan de reservekopie niet terugplaatsen: het bestand bevat fouten in de inhoud.',
    'backup.restore.warningSignError' => 'Kan de handtekening van de reservekopie niet valideren. De reservekopie is wellicht aangepast, beschadigd, aangemaakt in een eerdere versie of op een andere Plesk-server.',
    'backup.restore.warningSignErrorNotAdmin' => 'Deze reservekopie kan alleen worden teruggeplaatst door de beheerder van Plesk.',
    'backup.restore.warningPartial' => "De volgende delen van de incrementele reservekopie zijn niet gevonden :%%endl%%%%missedParts%%%%endl%%Wellicht kunnen niet alle bestanden worden teruggeplaatst. Upload de ontbrekende delen en probeer het terugplaatsen opnieuw.",
    'backup.restore.warningDeprecatedBackupVersion' => 'De reservekopie die u probeert terug te plaatsen is aangemaakt in een niet-ondersteunde versie van Plesk en kan niet worden teruggeplaatst. Gebruik de uitbreiding Plesk Migrator om uw gegevens over te zetten vanaf oudere versies van Plesk.',
    'backup.restore.encryptionKeyError' => 'Het wachtwoord voor een of meer accounts in deze reservekopie kon niet worden teruggeplaatst en zal daarom opnieuw worden ingesteld (wachtwoord-reset). Deze reservekopie is waarschijnlijk aangemaakt en versleuteld door een andere Plesk-server.',
    'backup.restore.errorCorruptedContent' => 'Kan de gegevens niet terugplaatsen. De volgende bestanden zijn beschadigd:',
    'backup.restore.statusSection' => 'Status reservekopie',
    'backup.restore.statusDetails' => 'Details van status',
    'backup.restore.restoreBlocked' => 'De reservekopie kan niet worden teruggeplaatst.',
    'backup.restore.restoreBlockedDescription' => 'De reservekopie van het type %%backupType%% kan op dit moment niet worden teruggeplaatst. Om deze terug te plaatsen meldt u zich aan als de eigenaar van de reservekopie en u klikt op de naam van deze reservekopie in het Beheer van reservekopieën.',

    'backup.schedule.scheduleSection' => 'Rooster',
    'backup.schedule.backupEnable' => 'Activeer deze ingeroosterde reservekopie',
    'backup.schedule.backupPeriod' => 'Deze reservekopie-taak uitvoeren',
    'backup.schedule.on' => 'aan',
    'backup.schedule.at' => 'om',
    'backup.schedule.every' => 'elke',
    'backup.schedule.hours' => '{period, plural, one {uur} other {uur}}',
    'backup.schedule.retainHours' => 'uren',
    'backup.schedule.useIncremental' => 'Incrementele reservekopieën maken',
    'backup.schedule.useIncrementalDisableHint' => 'Met deze selectie van content kan er alleen een volledige reservekopie worden gemaakt.',
    'backup.schedule.fullBackupPeriod' => 'Volledige reservekopie maken',
    'backup.schedule.hourly' => 'Vaste uur-interval',
    'backup.schedule.daily' => 'Dagelijks',
    'backup.schedule.weekly' => 'Wekelijks',
    'backup.schedule.monthly' => 'Maandelijks',
    'backup.schedule.yearly' => 'Jaarlijks',
    'backup.schedule.days' => 'dagen',
    'backup.schedule.weeks' => 'weken',
    'backup.schedule.months' => 'maanden',
    'backup.schedule.years' => 'jaren',
    'backup.schedule.backupTimeDescription' => 'Tijdzone: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Standaard tijdzone van het systeem',
    'backup.schedule.first' => 'eerste',
    'backup.schedule.last' => 'laatste',
    'backup.schedule.dayOfMonth' => 'dag',
    'backup.schedule.email' => 'Als er fouten optreden tijdens het uitvoeren van deze taak, stuur dan een melding per e-mail naar',
    'backup.schedule.invalidFields' => 'Sommige velden zijn leeg of bevatten een onjuiste waarde: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Maximaal aantal volledige reservekopieën dat kan worden opgeslagen (zowel ingeroosterde als handmatige reservekopieën)',
    'backup.schedule.retainDumpFilesFor' => 'Volledige reservekopie behouden voor',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Laat dit veld leeg wanneer u oude reservekopieën niet automatisch wilt verwijderen.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'De beperking die door de hostingprovider voor de serveropslag is opgegeven is %%max%%.Uw beperking moet lager zijn dan of gelijk aan %%max%%.',
    'backup.schedule.retainLimitedDescription' => 'De door de hostingprovider opgegeven beperking van de serveropslag bevat {max, plural, one {# volledige reservekopie} other {# volledige reservekopieën}} (inclusief alle geplande en handmatige reservekopieën).',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Het opslaan van ingeroosterde reservekopieën in een externe cloud-opslag is een premium feature die u kunt aanschaffen via de webwinkel van Plesk.',
    'backup.schedule.backupHourlyWarning' => 'Het inschakelen van reservekopieën met een vaste uur-interval kan een hogere belasting voor de server betekenen.',
    'backup.schedule.titleHourly' => 'Instellingen reservekopieën met vaste uur-interval',
    'backup.schedule.titleDaily' => 'Instellingen dagelijkse reservekopieën',
    'backup.schedule.titleWeekly' => 'Instellingen wekelijkse reservekopieën',
    'backup.schedule.titleMonthly' => 'Instellingen maandelijkse reservekopieën',
    'backup.schedule.titleCustom' => 'Instellingen aangepaste reservekopieën',

    'backup.secure-backup.hint' => 'U kunt een wachtwoord instellen om gebruikerswachtwoorden in de Plesk-database te versleutelen in de reservekopie. Merk op dat het terugplaatsen van een met een wachtwoord beveiligde reservekopie zonder daarbij het wachtwoord op te geven ertoe leidt dat Plesk voor alle gebruikers willekeurige wachtwoorden zal genereren.',
    'backup.secure-backup.hintAdmin' => 'U kunt Plesk-databasewachtwoorden in reservekopieën versleutelen met de encryptiesleutel van Plesk of met een wachtwoord. De sleutel is uniek voor elke Plesk-installatie. Reservekopieën waarvoor de encryptiesleutel is gebruikt kunnen alleen worden teruggeplaatst binnen de Plesk-installatie waarin ze zijn aangemaakt; ze kunnen niet worden teruggeplaatst in een andere Plesk-installatie. Merk op dat Plesk niet alle gevoelige gegevens in een reservekopie afschermt. We raden u aan reservekopieën op te slaan in externe cloudopslag en om daarbij gebruik te maken van de mogelijkheden tot encryptie van die cloudopslag.',
    'backup.secure-backup.usePasswordProtection' => 'Wachtwoordbescherming gebruiken (aanbevolen)',
    'backup.secure-backup.backupPasswordSource' => 'Type wachtwoord',
    'backup.secure-backup.pleskKey' => 'Encryptiesleutel van Plesk',
    'backup.secure-backup.userPassword' => 'Opgegeven wachtwoord',
    'backup.secure-backup.password' => 'Wachtwoord',
    'backup.secure-backup.passwordConfirmation' => 'Wachtwoord herhalen',

    'backup.subform.settingsSection' => 'Instellingen reservekopieën',
    'backup.subform.prefix' => 'Voorvoegsel toevoegen aan naam van reservekopie',
    'backup.subform.comment' => 'Opmerkingen',
    'backup.subform.splitSize' => 'Een reservekopie in meerdere delen maken, grootte van elk deel (MB)',
    'backup.subform.repository' => 'Opslaan in',
    'backup.subform.repositoryDescription' => 'Er zijn geen instellingen voor FTP(S)-opslag opgegeven. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Zowel serveropslag als %%name%%',
    'backup.subform.remoteRepositoryOption' => 'Externe opslag',
    'backup.subform.remoteRepository' => 'externe opslag',
    'backup.subform.remoteRepositoryText' => 'Selecteer externe cloudopslag',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">Stel externe opslag in</a> voor het opslaan van uw reservekopieën in de cloud.',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">Stel FTP-opslag in</a> om uw reservekopieën extern op te slaan.',
    'backup.subform.configureRemoteDesc' => '%%link%% om uw reservekopieën in de cloud op te slaan.',
    'backup.subform.configureRemoteLink' => 'Externe opslag instellen',
    'backup.subform.configureFtpDesc' => '%%link%% om uw reservekopieën extern op te slaan.',
    'backup.subform.configureFtpLink' => 'FTP-opslag instellen',
    'backup.subform.repositoryConfigure' => 'Instellen',
    'backup.subform.email' => 'Als de reservekopietaak is voltooid, stuur melding per e-mail naar',
    'backup.subform.contentSection' => 'Inhoud van reservekopie',
    'backup.subform.domainConfiguration' => 'Instellingen',
    'backup.subform.domainConfigurationVhost' => 'Bestanden en databases van gebruikers',
    'backup.subform.domainConfigurationFile' => 'Gebruikersbestanden',
    'backup.subform.domainConfigurationDatabase' => 'Databases',
    'backup.subform.domainConfigurationMail' => 'Mailberichten',
    'backup.subform.content' => 'Reservekopieën',
    'backup.subform.backupAll' => 'Alle instellingen en bestanden',
    'backup.subform.backupConfiguration' => 'Alleen instellingen',
    'backup.subform.backupVhost' => 'Alle instellingen en bestanden, uitgezonderd mailberichten',
    'backup.subform.backupMailFile' => 'Alle instellingen en bestanden, uitgezonderd databases van gebruikers',
    'backup.subform.backupMailDatabase' => 'Alle instellingen en bestanden, uitgezonderd gebruikersbestanden',
    'backup.subform.backupMail' => 'Alleen instellingen en mailberichten',
    'backup.subform.backupDatabase' => 'Alleen instellingen en databases van gebruikers',
    'backup.subform.backupFile' => 'Alleen instellingen en gebruikersbestanden',
    'backup.subform.mssqlNativeBackup' => 'Maak indien mogelijk gebruik van de systeemeigen functionaliteit voor het maken van MS SQL-reservekopieën',
    'backup.subform.mssqlNativeBackupAdmin' => 'Maak gebruik van de eigen functionaliteit voor het maken van reservekopieën van MS SQL (Zorg er bij externe databases voor dat u de instellingen voor reservekopieën van de externe MS SQL-server hebt ingesteld onder Hulpprogramma\'s & instellingen> Database-servers)',
    'backup.subform.localRepository' => 'Server-opslag',
    'backup.subform.localRepositoryPath' => 'Server-opslag op %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP(S)-opslag op %%uri%% <a href="%%link%%">Instellingen wijzigen</a>',
    'backup.subform.ftpRepositoryText' => 'FTP(S)-opslag op %%uri%%',
    'backup.subform.type' => 'Type',
    'backup.subform.typeFullBackup' => 'Volledig',
    'backup.subform.typeIncremental' => 'Incrementeel',
    'backup.subform.typeIncrementalDescription' => 'Maak een reservekopie van de web- en mailgegevens op de hostingserver die zijn gewijzigd na het maken van de laatste reservekopie. Merk op dat van databases altijd een volledige reservekopie wordt gemaakt.',
    'backup.subform.incrementalNotAvailable' => 'Om een incrementele reservekopie te kunnen maken moet u eerst een volledige reservekopie hebben gemaakt.',
    'backup.subform.excludeLogs' => 'Logbestanden uitsluiten',
    'backup.subform.excludeFiles' => 'Specifieke bestanden buiten de reservekopie houden',
    'backup.subform.excludeFilesDescription' => 'U kunt alleen bestanden binnen webruimtes uitzonderen. Geef het zoekpad of de zoekpaden op relatief aan de hoofdmap van de webruimte, waarbij u individuele bestanden met een komma scheidt. Het is toegestaan het maskeringsteken te gebruiken (bijvoorbeeld /een-of-andere-map/log*).',

    'backup.upload.uploadHint' => 'Hier kunt u reservekopieën uploaden naar de opslag van Plesk. De maximale bestandsgrootte is twee gigabyte.',
    'backup.upload.backupFile' => 'Reservekopie',
    'backup.upload.removeLink' => 'Verwijderen',
    'backup.upload.addFileLink' => 'Meer bestanden uploaden',
    'backup.upload.backupSecuritySettings' => 'Instellingen voor beveiliging reservekopieën',
    'backup.upload.signatureHint' => 'Plesk controleert of reservekopieën beschikken over een geldige structuur en handtekening. Bestanden die zijn aangepast, beschadigd of aangemaakt op een andere server worden niet meteen vertrouwd. De optie hieronder stelt u in staat om gegevens uit dergelijke bestanden toch terug te plaatsen. Selecteer deze optie alleen als u de bron van de reservekopie vertrouwt, omdat het uploaden van een dergelijk bestand een inbreuk kan betekenen op de beveiliging die een bedreiging vormt voor het goed functioneren van uw server. Opmerking: Reservekopieën die zijn gemaakt in een versie van Plesk Panel ouder dan 11.5 worden ook niet direct vertrouwd, omdat deze geen handtekening kennen. Zorg dat u zeker weet dat u deze bestanden kunt vertrouwen voordat u ze op de server plaatst.',
    'backup.upload.ignoreSign' => 'Reservekopieën uploaden zonder geldige handtekening',
    'backup.upload.passwordHint' => 'Als u deze reservekopie met een wachtwoord hebt afgeschermd, geef dan het wachtwoord op in de velden hieronder. Merk op dat als u een onjuist wachtwoord opgeeft u wel een waarschuwing van Plesk zult ontvangen, maar dat de reservekopie toch naar de server zal worden geüpload. Tijdens het terugplaatsen van de reservekopie zult u nogmaals om het wachtwoord worden gevraagd.',
    'backup.upload.alreadyExistsWarning' => 'De reservekopie %%fileName%% bestaat al in de lokale opslag van de server.',
    'backup.upload.incorrectPasswordWarning' => 'Het opgegeven wachtwoord is onjuist. Tijdens het terugplaatsen van de reservekopie zal Plesk u vragen om uw wachtwoord opnieuw in te voeren.',
    'backup.upload.deprecatedDumpError' => 'De reservekopie die u probeert terug te plaatsen is aangemaakt in een niet-ondersteunde versie van Plesk en kan niet worden geïmporteerd. Gebruik de uitbreiding Plesk Migrator om uw gegevens over te zetten vanaf oudere versies van Plesk.',
    'backup.upload.mailFormatWarning' => 'De reservekopie %%fileName%% is in de opslag geplaatst. Belangrijk: De reservekopie %%fileName%% bevat mailberichten die niet zullen worden teruggeplaatst omdat het formaat (Plesk 8.3 - 8.6) wordt niet ondersteund. Om deze mailberichten te kunnen terugplaatsen maakt u een reservekopie met het hulpprogramma Plesk Backup, u selecteert de optie Back up mailboxes content, en u selecteert de optie waarbij de dump wordt teruggeplaatst naar elke mailserver.',
    'backup.upload.corruptedSignatureAdminWarning' => 'De reservekopie (%%fileName%%) is aangepast, beschadigd, of aangemaakt op een andere server of in een oudere versie van Plesk die het ondertekenen van reservekopieën niet ondersteunt. Voordat u de gegevens uit deze reservekopie kunt terugplaatsen moet u er zeker van zijn dat u de bron van dit bestand kunt vertrouwen.',
    'backup.upload.corruptedSignatureAdminError' => 'Kan reservekopie niet uploaden (%%fileName%%). Het bestand is aangepast, beschadigd, of aangemaakt op een andere server of in een oudere versie van Plesk die het ondertekenen van reservekopieën niet ondersteunt. Als u deze reservekopie vertrouwt, selecteer dan het selectievakje "Reservekopieën uploaden zonder geldige handtekening" en herhaal het uploaden.',
    'backup.upload.corruptedSignatureUserWarning' => 'De reservekopie (%%fileName%%) bevat gewijzigde of beschadigde gegevens, of is aangemaakt op een andere server of in een oudere versie van Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'Kan reservekopie niet uploaden (%%fileName%%). Het bestand bevat gewijzigde of beschadigde gegevens, of is aangemaakt op een andere server of in een oudere versie van Plesk. Om gegevens uit dit bestand terug te plaatsen moet u contact opnemen met de uw hostingprovider.',
    'backup.upload.uploadError' => 'Kan %%fileName%% niet uploaden naar de opslag van de server: %%error%%',
    'backup.upload.fileNotSelected' => 'Er zijn geen bestanden geselecteerd om te uploaden. Selecteer ten minste een bestand .',
    'backup.upload.missedPartsWarning' => "Het uploaden van de volgende delen van de incrementele reservekopie is mislukt:%%endl%%%%missedParts%%%%endl%%Upload de ontbrekende onderdelen.",
    'backup.upload.unknownType' => 'Onbekend object-type',
    'backup.upload.storageLink' => 'andere opslag',
    'backup.upload.anotherStorage' => 'De dump is geüpload naar %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Het reseller %%name%% is niet gevonden. Deze eerst aanmaken om de geüploade dump terug te plaatsen.',
    'backup.upload.clientNotFound' => 'Het klant %%name%% is niet gevonden. Deze eerst aanmaken om de geüploade dump terug te plaatsen.',
    'backup.upload.domainNotFound' => 'Het domein %%name%% is niet gevonden. Deze eerst aanmaken om de geüploade dump terug te plaatsen.',

    'backup.web-content-dynamic.addButtonTitle' => 'Bestanden toevoegen',
    'backup.web-content-dynamic.noItems' => 'Er zijn geen bestanden geselecteerd',
    'backup.web-content-dynamic.hint' => 'Gebruik selectievakjes om bestanden en mappen te selecteren.',
    'backup.web-content-dynamic.title' => 'Selecteer bestanden',
    'backup.web-content-dynamic.columnName' => 'Naam',
    'backup.web-content-dynamic.columnChangeDate' => 'Aangepast',
    'backup.web-content-dynamic.columnSize' => 'Grootte',
    'backup.web-content-dynamic.columnPermissions' => 'Rechten',
    'backup.web-content-dynamic.columnUser' => 'Gebruiker',
    'backup.web-content-dynamic.columnGroup' => 'Groep',
    'backup.web-content-dynamic.waitButtonTitle' => 'Even geduld',
    'backup.web-content-dynamic.loadingTitle' => 'Een ogenblik geduld. Bezig met laden...',

    'backup.invalidFields' => 'Sommige velden zijn leeg of bevatten een onjuiste waarde.',
    'backup.notEnoughDiskSpace' => 'Er is onvoldoende schijfruimte op %%path%% om een reservekopie te maken. Er is minimaal %%required%% GB vrije ruimte vereist (%%available%% GB is beschikbaar)',

    'change-subscriptions-owner.infoTitle' => 'Info',
    'change-subscriptions-owner.infoDescription' => '%%total%% abonnementen, %%active%% actieve abonnementen, %%diskSpace%% aan schijfruimte gebruikt, %%traffic%% aan dataverkeer verbruikt',
    'change-subscriptions-owner.possibleOwnersTitle' => 'Mogelijke nieuwe abonnementhouders',
    'change-subscriptions-owner.selectedSubscriptions' => 'Geselecteerde pakketten',
    'change-subscriptions-owner.subscriptionName' => 'Naam van abonnement',
    'change-subscriptions-owner.ownerName' => 'Naam van houder',
    'change-subscriptions-owner.currentIpAddress' => 'Huidig IP-adres',
    'change-subscriptions-owner.newIpAddress' => 'Nieuw IP-adres',
    'change-subscriptions-owner.submit' => 'Opnieuw toewijzen',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, disk I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Beperkingen stellen aan de hoeveelheid middelen die door een abonnement gebruikt kan worden. Plesk maakt gebruik van een feature van de Linux-kernel die control groups (cgroups) heet om ervoor te zorgen dat de beperkingen niet worden overschreden.',
    'cgroups-settings.cpuSettings' => 'Processor',
    'cgroups-settings.cpuSettingsDescription' => 'Beperkt individuele abonnementen tot een specifiek gebruik van de processor.',
    'cgroups-settings.cpuPeriodLimit' => 'Periode waarin processorgebruik moet worden gecontroleerd',
    'cgroups-settings.percentUsageDescription' => 'De totale hoeveelheid CPU-tijd is gelijk aan %%total%%%%units%% voor uw server',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Beperkt individuele abonnementen tot een specifiek RAM-gebruik. Merk op: wanneer een abonnement deze beperking overschrijdt wordt het proces met het hoogste gebruik gestopt.',
    'cgroups-settings.ramPeriodLimit' => 'Periode waarin geheugengebruik moet worden gecontroleerd',
    'cgroups-settings.diskSettings' => 'Disk I/O',
    'cgroups-settings.diskReadSettings' => 'Lezen van schijf',
    'cgroups-settings.diskReadSettingsDescription' => 'Individuele abonnementen alleen toestaan bandbreedte voor het lezen van de harde schijf te gebruiken binnen de opgegeven beperking.',
    'cgroups-settings.diskReadPeriodLimit' => 'Periode waarin het lezen van de harde schijf moet worden gecontroleerd',
    'cgroups-settings.diskWriteSettings' => 'Schrijven naar harde schijf',
    'cgroups-settings.diskWriteSettingsDescription' => 'Individuele abonnementen alleen toestaan bandbreedte voor het schrijven naar de harde schijf te gebruiken binnen de opgegeven beperking.',
    'cgroups-settings.diskWritePeriodLimit' => 'Periode waarin het schrijven naar de harde schijf moet worden gecontroleerd',
    'cgroups-settings.limit' => 'Beperking',
    'cgroups-settings.threshold' => 'Meld indien overschreden',
    'cgroups-settings.limitNotificationEnabled' => 'Meldingen ingeschakeld',
    'cgroups-settings.periodFiveMinutes' => '5 minuten',
    'cgroups-settings.periodHour' => '1 uur',
    'cgroups-settings.periodDay' => '1 dag (24 uur)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sec',

    'custom-button.privateLabel' => 'Alleen aan mij tonen',
    'custom-button.textLabel' => 'Knoptekst',
    'custom-button.tooltipLabel' => 'Tekst van knopinfo',
    'custom-button.iconLabel' => 'Achtergrondafbeelding',
    'custom-button.priorityLabel' => 'Prioriteit',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Parameters aan URL toevoegen',
    'custom-button.placeLabel' => 'Locatie',
    'custom-button.internalLabel' => 'URL openen in Plesk',
    'custom-button.internalDescription' => 'Geef aan of de URL moet worden geopend in Plesk of in een nieuw venster van de browser.',
    'custom-button.noFrameLabel' => 'Geen frames gebruiken',
    'custom-button.noFrameDescription' => 'Wanneer u een aangepaste knop toevoegt die leidt naar een Plesk-extensie of naar een app in Hostingbeheer, dan kunt u hier aangeven hoe deze uitbreiding/app moet worden weergegeven: in een frame of als onderdeel van de grafische interface van Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Inclusief kenmerk van abonnement, domein en domeinalias',
    'custom-button.urlParamLabel_dom_name' => 'Primaire domeinnaam toevoegen',
    'custom-button.urlParamLabel_ftp_user' => 'FTP-gebruikersnaam toevoegen',
    'custom-button.urlParamLabel_ftp_pass' => 'FTP-wachtwoord toevoegen',
    'custom-button.urlParamLabel_cl_id' => 'Kenmerk van cliënt toevoegen',
    'custom-button.urlParamLabel_cname' => 'Bedrijfsnaam van cliënt toevoegen',
    'custom-button.urlParamLabel_pname' => 'Contactnaam van cliënt toevoegen',
    'custom-button.urlParamLabel_email' => 'E-mail van cliënt toevoegen',
    'custom-button.buttonPlace_navigation' => 'Gedeelde toegang',
    'custom-button.buttonPlace_admin' => 'Startpagina van beheerder',
    'custom-button.buttonPlace_admin-settings' => 'Pagina met hulpprogramma\'s & instellingen van beheerder',
    'custom-button.buttonPlace_reseller' => "Startpagina van Reseller",
    'custom-button.buttonPlace_reseller-settings' => 'Pagina met hulpprogramma\'s & instellingen van reseller',
    'custom-button.buttonPlace_client' => 'Startpagina van cliënt',
    'custom-button.buttonPlace_domain' => "Pagina met websites & domeinen van abonnement",
    'custom-button.buttonPlace_domain_powerUser' => "Pagina met websites & domeinen van webruimte",
    'custom-button.buttonPlace_domain-properties' => 'Hulpprogramma\'s voor websites',

    'database-server-change-password.adminPassword' => 'Wachtwoord van beheerder',
    'database-server-change-password.success' => 'Het bijwerken van het wachtwoord van de beheerder is geslaagd.',

    'database-server-create.general' => 'Algemeen',
    'database-server-create.type' => 'Type database-server',
    'database-server-create.unixSocket' => '(lokale verbinding)',
    'database-server-create.host' => 'Hostnaam of IP-adres',
    'database-server-create.port' => 'Poortnummer',
    'database-server-create.portDescription' => 'Laat leeg voor het standaard poortnummer',
    'database-server-create.version' => 'Versie database-server',
    'database-server-create.default' => 'Deze server gebruiken als standaard voor %%type%%',
    'database-server-create.externalConnections' => 'Accepteren van externe verbindingen met de lokale MariaDB/MySQL-server toestaan',
    'database-server-create.externalConnectionsDescription' => 'Als u deze instelling wijzigt dan wordt de lokale MariaDB/MySQL-server opnieuw opgestart. Als u externe toegang tot andere in Plesk geregistreerde MariaDB/MySQL-servers wilt inschakelen, dan wijzigt u de instellingen daarvan met de hand.',
    'database-server-create.authentication' => 'Verificatie',
    'database-server-create.authenticationAddDescription' => 'Geef de gebruikersnaam en het wachtwoord op van de beheerder namens wie Plesk verbinding zal maken met de database-server. Er moet een beheerderaccount met deze gebruikersnaam en dit wachtwoord op de database-server aanwezig zijn.',
    'database-server-create.authenticationEditDescription' => 'Hier kunt u de gebruikersnaam en het wachtwoord wijzigen waarmee Plesk verbinding maakt met de database-server. Deze gegevens moeten overeenkomen met de gebruikersnaam en het wachtwoord van de beheerder van de database. Nadat u de gebruikersnaam of het wachtwoord van de beheerder hebt gewijzigd in de database-server is het noodzakelijk om dezelfde wijziging ook door te voeren in Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Hier kunt u de gebruikersnaam en het wachtwoord wijzigen waarmee Plesk verbinding maakt met de database-server. Als u hieronder de gebruikersnaam en het wachtwoord aanpast, dan zal het databasegebruikeraccount met beheerrechten worden bijgewerkt in zowel de database-server als in Plesk.',
    'database-server-create.adminLogin' => 'Gebruikersnaam',
    'database-server-create.adminPassword' => 'Wachtwoord',
    'database-server-create.createSuccess' => 'Het aanmaken van de database-server is geslaagd.',
    'database-server-create.createError' => 'Database-server is aangemaakt maar met een foutmelding: %%error%%',
    'database-server-create.updateSuccess' => 'Het bijwerken van de database-server is geslaagd.',
    'database-server-create.updateError' => 'Database-server is bijgewerkt maar met een foutmelding: %%error%%.',
    'database-server-create.backupSettings' => 'Reservekopie',
    'database-server-create.backupTempDir' => 'Tijdelijke map',
    'database-server-create.backupTempDirDescription' => 'Het zoekpad naar een fysieke map op de externe server waar de MS SQL-server zich bevindt. De MS SQL-server moet toegang tot deze map hebben om tijdelijke reservekopieën te kunnen lezen en schrijven. Bijvoorbeeld C:\\mapnaam',
    'database-server-create.backupNetworkTempDir' => 'Tijdelijke netwerkmap',
    'database-server-create.backupNetworkTempDirDescription' => 'Het zoekpad naar de netwerk share die is gekoppeld aan de fysieke map die hierboven is opgegeven. Plesk zal de gedeelde map gebruiken voor het down- en uploaden van reservekopieën. Bijvoorbeeld \\\\ServerNaam\\ZoekpadNaarDeMap',
    'database-server-create.backupNetworkUser' => 'Gebruikersnaam',
    'database-server-create.backupNetworkUserDescription' => 'De gebruikersnaam van een netwerkgebruiker die op de externe server is aangemaakt. Bijvoorbeeld \\servernaam\\gebruikersnaam. De gebruiker moet toegang hebben tot de gedeelde map die hierboven is opgegeven.',
    'database-server-create.backupNetworkPassword' => 'Wachtwoord',

    'domain.connection-info.title' => 'Verbindingsinformatie',
    'domain.connection-info.systemUserCredentials' => 'Aanmeldgegevens systeemgebruiker',
    'domain.connection-info.systemUserCredentialsHint' => 'Toegang via FTP is altijd ingeschakeld, toegang via SSH of Extern bureaublad — alleen als de %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'rechten daarvoor zijn toegekend',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Toegang via SSH of Extern bureaublad is ingeschakeld en u kunt de status daarvan niet beheren.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Toegang via SSH of Extern bureaublad is uitgeschakeld en u kunt de status daarvan niet beheren.',
    'domain.connection-info.ipAddress' => 'IP-adres',
    'domain.connection-info.username' => 'Gebruikersnaam',
    'domain.connection-info.password' => 'Wachtwoord',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Wijziging wachtwoord systeemgebruiker',
    'domain.connection-info.changePasswordTooltip' => 'Wachtwoord wijzingen',
    'domain.connection-info.newPassword' => 'Nieuw wachtwoord',
    'domain.connection-info.manageAccess' => 'Toegang beheren',
    'domain.connection-info.additionalFtpAccounts' => 'Extra FTP-accounts',
    'domain.connection-info.database' => 'Database',
    'domain.connection-info.databaseHint' => '1 van %%number%% databases die bij het abonnement horen.',
    'domain.connection-info.databaseNotCreatedHint' => 'Database is niet aangemaakt.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Host',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Databasenaam',
    'domain.connection-info.addDatabase' => 'Database toevoegen',
    'domain.connection-info.manageDatabases' => 'Databases beheren',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Wijziging wachtwoord databasegebruiker',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Vergeet niet om het wachtwoord in de configuratiebestanden van uw toepassing bij te werken nadat u het op deze plek heeft aangepast.',
    'domain.connection-info.buttonSave' => 'Opslaan',
    'domain.connection-info.buttonSaving' => 'Opslaan...',
    'domain.connection-info.buttonCancel' => 'Annuleren',

    'domain.move.title' => 'Verplaats domein %%name%%',
    'domain.move.hint' => 'Het domein zal worden verplaatst naar een nieuw abonnement, met daarbij alle bestanden (inclusief configuratiebestanden en logbestanden) en APS-toepassingen.',
    'domain.move.hintMain' => 'Het domein zal worden verplaatst naar een nieuw abonnement, inclusief alle inhoud, configuratiebestanden, logboekbestanden, databases, databasegebruikers, extra FTP-gebruikers, ingeroosterde taken, smb-gebruikers en APS-toepassingen.',
    'domain.move.hintSubdomains' => 'De subdomeinen %%subdomains%% zullen met het bovenliggende domein worden verplaatst.',
    'domain.move.hintAliases' => 'De domeinaliassen %%aliases%% zullen met het bovenliggende domein worden verplaatst.',
    'domain.move.hintSubdomainsAndAliases' => 'De subdomeinen %%subdomains%% en de domeinaliassen %%aliases%% zullen met het bovenliggende domein worden verplaatst.',
    'domain.move.labelDatabases' => 'Nadat u het domein hebt verplaatst, opent u het tabblad "Databases" om de bijbehorende databases te verplaatsen.',
    'domain.move.hintDatabases' => 'Verplaats de databases apart van elkaar, indien nodig.',

    'domain.move.Form.submitButton' => 'Verplaatsen',
    'domain.move.Form.cancelButton' => 'Annuleren',

    'domain.move.selectTarget' => 'Beschikbare abonnementen',
    'domain.move.nothingFound' => 'Niets gevonden',
    'domain.move.targetIsRequred' => 'Selecteer het abonnement waar u het domein naar wilt verplaatsen.',
    'domain.move.selectNewSubscription' => 'Nieuw abonnement aanmaken',
    'domain.move.ipv4Address' => 'IPv4-adres',
    'domain.move.ipv4AddressHint' => 'Het IP-adres waarop de website wordt gehost is een netwerkadres van de virtuele host van de website.',
    'domain.move.ipv6Address' => 'IPv6-adres',
    'domain.move.ipv6AddressHint' => 'Het IP-adres waarop de website wordt gehost is een netwerkadres van de virtuele host van de website.',
    'domain.move.ipAddressIsNotSelected' => 'Er moet minimaal één IP-adres zijn geselecteerd.',
    'domain.move.username' => 'Gebruikersnaam',
    'domain.move.usernameHint' => 'Het account van de systeemgebruiker die aan de webruimte is gekoppeld. Gebruikt voor toegang tot de gehoste bestanden via FTP en SSH.',
    'domain.move.usernameIsRequred' => 'U moet een gebruikersnaam opgeven.',
    'domain.move.password' => 'Wachtwoord',
    'domain.move.passwordIsRequred' => 'U moet een wachtwoord opgeven.',
    'domain.move.noAvailableSubscriptions' => 'Er zijn geen abonnementen beschikbaar',
    'domain.move.noWebHosting' => 'Er wordt nu geen systeemgebruiker aangemaakt, omdat het domein niet beschikt over webhosting.',

    'domain.rename.title' => 'Domeinnaam wijzigen',
    'domain.rename.titleAlias' => 'Naam domeinalias wijzigen',
    'domain.rename.hint' => 'U wijzigt nu de domeinnaam %%domainName%%',
    'domain.rename.hintAlias' => 'U wijzigt nu het domeinalias %%domainName%%',
    'domain.rename.name' => 'Nieuwe domeinnaam',
    'domain.rename.nameAlias' => 'Nieuw domeinalias',
    'domain.rename.domainNameIsRequired' => 'Dit vereiste veld is leeg; u moet een waarde opgeven.',
    'domain.rename.submitButton' => 'Wijzigen',
    'domain.rename.submitButtonProgress' => 'Wijzigen',
    'domain.rename.successMessage' => 'Domeinnaam %%oldName%% is gewijzigd naar %%newName%%.',
    'domain.rename.successMessageAlias' => 'Domeinalias %%oldName%% is gewijzigd naar %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Annuleren',

    'domain.outgoing-messages.hint' => 'Hier kunt u de beperking wijzigen van het aantal uitgaande berichten voor dit domein. Het is niet mogelijk om meer berichten te verzenden dan bepaald door de opgegeven limiet.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Standaard (%%domainOutgoingMessages%% berichten per uur)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'berichten per uur',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Beperking van uitgaande berichten',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Aangepaste waarde voor dit domein',

    'domain.tech-domain-name.title' => 'Selecteer uw domeinnaam',
    'domain.tech-domain-name.techDomainTitle' => 'Tijdelijk domeinnaam',
    'domain.tech-domain-name.customDomainTitle' => 'Geregistreerde domeinnaam',
    'domain.tech-domain-name.techDomainText' => 'Ik heb nog geen domeinnaam geregistreerd',
    'domain.tech-domain-name.customDomainText' => 'Ik heb al een domeinnaam geregistreerd',
    'domain.tech-domain-name.techDomain' => 'Uw tijdelijk domeinnaam',
    'domain.tech-domain-name.customDomain' => 'Geregistreerde domeinnaam',
    'domain.tech-domain-name.domainName' => 'Domeinnaam',
    'domain.tech-domain-name.techDomainDesc' => 'Tijdelijke domeinnamen worden gebruikt om toegang te krijgen tot uw site voordat u uw uiteindelijke domeinnaam registreert en aanschaft. Ze worden gratis verstrekt, onder de volgende voorwaarden:',
    'domain.tech-domain-name.techDomainRandom' => 'Deze namen worden willekeurig aangemaakt',
    'domain.tech-domain-name.techDomainDns' => 'Ze worden gehost in de DNS-zone .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'U kunt op elk moment overschakelen naar een geregistreerde domeinnaam door de naam van uw domein te wijzigen in de instellingen van het domein.',
    'domain.tech-domain-name.error' => 'Er is een onverwachte fout opgetreden.',
    'domain.tech-domain-name.errorNoIpAddress' => 'U moet het IP-adres selecteren.',
    'domain.tech-domain-name.generating' => 'Genereren...',

    'get-password.label' => 'Wachtwoord opnieuw instellen',
    'get-password.text' => 'Geef uw e-mailadres op, of de gebruikersnaam waarmee u zich bij Plesk aanmeldt, en we sturen u een e-mail waarmee u uw wachtwoord opnieuw kunt instellen.',
    'get-password.emailLabel' => 'E-mailadres',
    'get-password.loginLabel' => 'Gebruikersnaam',
    'get-password.send' => 'Verzenden',
    'get-password.cancel' => 'Annuleren',
    'get-password.errorInvalidEmail' => 'Het e-mailadres is niet herkend. Controleer en probeer het opnieuw.',
    'get-password.messageSend' => "De e-mail voor het opnieuw instellen van het wachtwoord is naar het gekoppelde e-mailadres gestuurd.\nAls de e-mail niet aankomt, neem dan contact op met uw Plesk-beheerder.",

    'iis-settings.formGeneralHint' => 'Hier kunt u de instellingen van de IIS-webserver voor uw website bepalen door de standaardwaarden aan te passen. Een aangepaste configuratie voor IIS kan nuttig zijn als u een nieuw soort index-bestand wilt gebruiken voor uw website of u wilt een specifiek MIME-type koppelen aan bepaalde bestandextensies. De standaardwaarden zijn ingesteld door uw hostingprovider.',
    'iis-settings.formGeneralHint_powerUser' => 'Hier kunt u de instellingen voor de IIS-webserver voor deze website configureren. Een aangepaste configuratie voor IIS kan nuttig zijn als u een nieuw soort index-bestand wilt gebruiken voor uw website of u wilt een specifiek MIME-type koppelen aan bepaalde bestandextensies. De waarde Standaard betekent dat Apache de bijbehorende opdrachten zal gebruiken uit de configuratie voor de server als geheel.',
    'iis-settings.virtualDirectoryLoadError' => 'Kan de eigenschappen van de opgegeven virtuele map niet lezen: %%errorMessage%%',
    'iis-settings.general' => 'Algemene Instellingen',
    'iis-settings.example' => "Bijvoorbeeld:\n%%example%%",
    'iis-settings.settingOn' => 'Aan',
    'iis-settings.settingOff' => 'Uit (Standaard)',
    'iis-settings.settingDefault' => 'Standaard',
    'iis-settings.settingCustom' => 'Aangepaste waarde invoeren',
    'iis-settings.mimeTypes' => 'MIME-typen',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME-typen koppelen bestandsextensies aan bestandstypen. Dit wordt meestal gebruikt om een aangepaste bestandsextensie aan te maken voor veel voorkomende bestandstypen.',
    'iis-settings.documents' => 'Standaarddocumenten',
    'iis-settings.documentsOff' => 'Uitgeschakeld',
    'iis-settings.documentsCustom' => 'Waarden opgeven',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Als browsers geen naam aangeven van een document binnen uw site, dan zal IIS op zoek gaan naar het opgegeven standaarddocument en het eerste gevonden document weergeven. Als u geen standaarddocumenten instelt maar het bladeren door mappen inschakelt, dan zal er in plaats van de index-pagina een lijst met alle mappen en bestanden in de browser worden weergegeven.',
    'iis-settings.expires' => 'Verloopt',
    'iis-settings.expiresFullDescription' => 'De webserver zal de responseheader “Expires” aan webpagina\'s toevoegen.Het tijdstempel voor het verloopmoment wordt berekend door de hoeveelheid tijd die hierboven is opgegeven toe te voegen aan de tijdstip waarop de webpagina werd opgevraagd.',
    'iis-settings.expiresUnitDays' => 'dagen',
    'iis-settings.expiresUnitHours' => 'uren',
    'iis-settings.expiresUnitMinutes' => 'minuten',
    'iis-settings.expiresUnitSeconds' => 'seconden',
    'iis-settings.headers' => 'Aanvullende headers',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'De webserver zal de opgegeven HTTP-antwoordheaders toevoegen.',
    'iis-settings.directoryBrowsing' => 'Door mappen bladeren',
    'iis-settings.directoryBrowsingDescription' => 'Gebruikers toestaan om de lijst met bestanden en mappen van de site te bekijken in de browser, bijvoorbeeld wanneer er geen index-pagina beschikbaar is.',
    'iis-settings.securityTabDirectory' => 'Instellingen voor mapbeveiliging',
    'iis-settings.allowAnonymous' => 'Anonieme authenticatie',
    'iis-settings.allowAnonymousDescription' => 'Met anonieme authenticatie kunnen gebruikers toegang krijgen tot het publieke deel van uw site. Bestanden van uw site die met een wachtwoord zijn afgeschermd, evenals bestanden die worden afgeschermd door het bestandssysteem, zijn niet beschikbaar voor anonieme gebruikers.',
    'iis-settings.allowWindows' => 'Windows-verificatie',
    'iis-settings.allowWindowsDescription' => 'Windows-verificatie (voorheen NTLM genoemd) schermt de inhoud van uw site af op het niveau van het bestandsysteem.',
    'iis-settings.requireSsl' => 'SSL/TLS vereist',
    'iis-settings.requireSslDescription' => 'Als u ondersteuning voor SSL/TLS voor uw site hebt ingeschakeld, dan zal deze optie de webclients (browsers) dwingen om alleen beveiligde HTTPS-verbindingen te gebruiken.',
    'iis-settings.securityTabIpDeny' => 'Instellingen toegangsbeperking',
    'iis-settings.deny' => 'Toegang tot de site weigeren',
    'iis-settings.denyOff' => 'Standaard',
    'iis-settings.denyCustom' => 'Aangepaste waarde opgeven',
    'iis-settings.allow' => 'Exclusief',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDe opgegeven hosts en netwerken hebben geen toegang tot de site. Gebruik \\'*\\' te weigeren alle verbindingen .",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nDe opgegeven hosts en netwerken hebben geen toegang tot de site.",
    'iis-settings.dynamicIpSecurity' => 'Voorkomen van DoS-aanvallen via IIS Dynamic IP Restriction',
    'iis-settings.isDenyByConcurrentRequests' => 'IP-adressen niet toelaten op basis van het aantal gelijktijdige aanvragen vanaf een uniek IP-adres',
    'iis-settings.maxConcurrentRequests' => 'Maximaal aantal gelijktijdige aanvragen',
    'iis-settings.isDenyByRequestRate' => 'IP-adressen niet toelaten op basis van het aantal aanvragen in een bepaald tijdvak',
    'iis-settings.maxRequests' => 'Maximaal aantal aanvragen',
    'iis-settings.requestInterval' => 'Tijdsduur (in milliseconden)',

    'ip-addresses-selector.ipAddress' => 'IP-adres',
    'ip-addresses-selector.ipv4Address' => 'IPv4-adres',
    'ip-addresses-selector.ipv4AddressHint' => "Het IP-adres waarop de website wordt gehost is een netwerkadres van de virtuele host van de website.",
    'ip-addresses-selector.ipv6Address' => 'IPv6-adres',
    'ip-addresses-selector.ipv6AddressHint' => "Het IP-adres waarop de website wordt gehost is een netwerkadres van de virtuele host van de website.",
    'ip-addresses-selector.noIpAddressHint' => 'Geen',
    'ip-addresses-selector.shared' => 'gedeeld',
    'ip-addresses-selector.exclusive' => 'exclusief',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP-server ondersteunt geen IPv6. Wijs ten minste één IPv4-adres toe, anders kan de gebruiker geen bestanden naar de server uploaden met FTP.',

    'license-key-revert.description' => 'De licentiesleutel met de volgende eigenschappen zal worden teruggezet:',
    'license-key-revert.submitButton' => 'Terugdraaien',

    'license-key-upload.description' => 'Installeer uw licentiesleutel installeren door een activatiecode in te voeren.',
    'license-key-upload.descriptionWithFileUpload' => 'Installeer uw licentiesleutel door ofwel een activeringscode in te voeren, of door het uploaden van een licentiesleutelbestand.',
    'license-key-upload.type' => 'Kies een van de volgende opties:',
    'license-key-upload.code' => 'Voer een activeringscode in',
    'license-key-upload.codeDescription' => 'Plak de ontvangen activatiecode.',
    'license-key-upload.file' => 'Een licentiesleutelbestand uploaden',
    'license-key-upload.fileDescription' => 'Geef het zoekpad op naar het bestand dat de licentiesleutel bevat.',
    'license-key-upload.submitButton' => 'Installeren',

    'log-rotation.customLogsDescription' => 'Merk op dat uw aangepaste logbestanden niet worden opgeschoond.',
    'log-rotation.logRotation' => 'Logopschoning',
    'log-rotation.logRotationCondition' => 'Voorwaarde logopschoning',
    'log-rotation.logRotationBySize' => 'Op grootte',
    'log-rotation.logRotationByTime' => 'Op tijd',
    'log-rotation.logRotationDaily' => 'Dagelijks',
    'log-rotation.logRotationWeekly' => 'Wekelijks',
    'log-rotation.logRotationMonthly' => 'Maandelijks',
    'log-rotation.logRotationSizeDescription' => 'De grootte moet liggen tussen de %%min%% en %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Maximaal aantal logbestanden',
    'log-rotation.compress' => 'Logbestanden comprimeren',
    'log-rotation.sendLogToEmail' => 'Nadat Plesk de gegevens heeft opgehaald uit de logbestanden van web- en FTP-servers, verstuur dan de logbestanden naar dit e-mailadres',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'De periode kan niet groter zijn dan de beperking van %%max%% die geldt voor de server als geheel.',

    'login.loginLabel' => 'Gebruikersnaam',
    'login.passwdLabel' => 'Wachtwoord',
    'login.localeLabel' => 'Schermtaal',
    'login.defaultLocale' => 'Standaard',
    'login.loginButtonLabel' => 'Aanmelden',
    'login.enterUsername' => 'Uw gebruikersnaam opgeven.',
    'login.enterPassword' => 'Uw wachtwoord opgeven.',
    'login.whatUsernamePassword' => 'Welke combinatie van gebruikersnaam en wachtwoord moet worden gebruikt?',
    'login.forgotPasswordLabel' => 'Wachtwoord vergeten?',
    'login.cookies' => 'Cookie-beleid in Plesk',
    'login.avoidSSLWarningsMsg' => 'Gebruik %%link%% om SSL-waarschuwingen tijdens het aanmelden bij Plesk te voorkomen',
    'login.digitalOceanMsg' => 'Nieuw bij Plesk op DigitalOcean? Meld u aan met "root" en het wachtwoord dat is ingevoerd bij het maken van deze droplet. %%link%%',
    'login.amazonLightsailMsg' => 'Nieuw bij Plesk op Lightsail? Om u bij Plesk aan te melden gaat u naar de server via SSH en geeft u de opdracht "plesk login". %%link%%',
    'login.readGuide' => 'Lees de complete handleiding.',
    'login.mobileApplicationMessage' => 'Voor een betere ervaring raden wij u aan %%name%% te installeren.',
    'login.mobileApplicationInstall' => 'Nu installeren',
    'login.mobileApplicationHide' => 'Nee, bedankt',

    'force-reset-password.saveButton' => 'Opslaan',
    'force-reset-password.title' => 'Uw wachtwoord wijzigen',
    'force-reset-password.passwordLabel' => 'Nieuw wachtwoord',

    'panel-access.title' => 'Plesk-URL aanpassen',
    'panel-access.hint' => 'Aangepaste URL\' s gebruiken voor aanmelden bij Plesk. U kunt daarnaast nog altijd gebruik maken van de mogelijkheid om u bij Plesk aan te melden via poort %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Meer informatie',
    'panel-access.proxyEnabled' => 'Alle domeinen en subdomeinen die verwijzen naar het IP-adres van de server, maar die niet voor hosting worden gebruikt',
    'panel-access.proxyDomain' => 'Het opgegeven domein of subdomein dat verwijst naar het IP-adres van de server, maar dat niet voor hosting wordt gebruikt',
    'panel-access.proxyDisabled' => 'Geen aangepaste URL\'s. Alleen https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Opslaan',
    'panel-access.Form.cancelButton' => 'Annuleren',

    'panel-access.domainNameIsRequired' => 'U moet een domeinnaam opgeven.',
    'panel-access.successMessage' => 'De geselecteerde manier van aanmelden is toegepast.',
    'panel-access.notSupported' => 'Uw Plesk biedt geen ondersteuning voor de geselecteerde manier van aanmelden.',
    'panel-access.notViaDomainName' => 'Om deze methode van aanmelden toe te passen kiest u de eerste optie ("Alle domeinen en subdomeinen..."), aanmelden bij Plesk via https://%%domainName%%, en kies tenslotte de tweede optie.',
    'panel-access.notViaPort' => 'Om deze manier van aanmelden bij Plesk mogelijk te maken, moet u zich eerst aanmelden bij Plesk via https://<server-IP-of-hostnaam>:%%httpsPort%%.',

    'php-settings.performance' => 'Instellingen prestaties en beveiliging',
    'php-settings.settings' => 'Algemene instellingen',
    'php-settings.fastCgiSettings' => 'FastCGI-instellingen',
    'php-settings.fpmSettings' => 'Instellingen PHP-FPM',
    'php-settings.enableFastcgi' => 'FastCGI-instellingen inschakelen',
    'php-settings.plainTextEditing' => 'Aanvullende instructies',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'U kunt elke PHP-parameter definiëren door deze in het onderstaande veld in te voeren.De opdrachten zullen worden ingevoegd in de PHP-configuratie.Maak gebruik van dezelfde syntax als die u zou gebruiken voor php.ini.Om bijvoorbeeld automatisch de mSQL-extensie te laden, voegt u de volgende regel toe:extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Als u een specifieke PHP-parameter niet kunt vinden, dan kunt u deze toevoegen in het onderstaande veld. Deze aanvullende opdrachten zullen worden samengevoegd met de opdrachten van het hostingpakket. Gebruik dezelfde syntax als die u voor php.ini gebruikt. Als u bijvoorbeeld automatisch de mSQL-extensie wilt laden, voeg dan de volgende regel toe: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'U kunt elke PHP-parameter definiëren door deze in het onderstaande veld in te voeren.De opdrachten zullen worden ingevoegd in de PHP-configuratie.Maak gebruik van dezelfde syntax als die u zou gebruiken voor php.ini.Om bijvoorbeeld automatisch de mSQL-extensie te laden, voegt u de volgende regel toe:extension=msql.so. Om de instellingen van de PHP-FPM-voorziening aan te passen voegt u het [php-fpm-pool-settings]-scheidingsteken toe en geeft u de gewenste instellingen hieronder op.',
    'php-settings.additionalConfigurationDirectives' => 'Aanvullende configuratie-instructies',
    'php-settings.defaultValue' => 'Standaard',
    'php-settings.predefinedValue' => 'Selecteer waarde',
    'php-settings.customValue' => 'Geef een aangepaste waarde op',
    'php-settings.phpSettingDescription_memory_limit' => 'De maximale hoeveelheid geheugen in bytes dat een script mag toewijzen.',
    'php-settings.phpSettingDescription_max_execution_time' => 'De maximale tijd in seconden dat een script kan worden uitgevoerd voordat deze wordt afgebroken.',
    'php-settings.phpSettingDescription_max_input_time' => 'De maximale tijd in seconden dat een script gegevens mag verwerken.',
    'php-settings.phpSettingDescription_post_max_size' => 'De maximale grootte in bytes van gegevens die via de POST-methode kunnen worden gepost. Normaal gesproken is dit groter dan de waarde van upload_max_filesize maar kleiner dan memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'De maximale grootte in bytes van een bestand dat is geüpload.',
    'php-settings.phpSettingDescription_safe_mode' => 'De veilige modus van PHP plaatst een aantal restricties aan het uitvoeren van scripts, voornamelijk vanwege veiligheidsoverwegingen.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'PHP-scripts hebben toegang tot bestanden in de opgegeven mappen wanneer de opdracht safe_mode van kracht is. Deze moet ook zijn opgenomen in het include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Programma\'s in de opgegeven map kunnen worden uitgevoerd door PHP-scripts wanneer de opdracht safe_mode van kracht is.',
    'php-settings.phpSettingDescription_include_path' => 'De lijst met mappen waarin scripts naar bestanden zoeken (vergelijkbaar met de PATH-systeemvariabele). Om mappen van elkaar te scheiden gebruikt u onder Linux een dubbele punt (:) en onder Windows een puntkomma (;).',
    'php-settings.phpSettingDescription_sessionsave_path' => 'De map waarin PHP-sessiebestanden worden opgeslagen.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Aanvullende parameters voor de functie mail().',
    'php-settings.phpSettingDescription_register_globals' => 'De inhoud van EGPCS-variabelen (Environment, GET, POST, Cookie, Server) opslaan als globale variabelen.',
    'php-settings.phpSettingDescription_open_basedir' => 'PHP-scripts hebben toegang tot bestanden in de opgegeven mappen. Om mappen van elkaar te scheiden gebruikt u onder Linux een dubbele punt (:) en onder Windows een puntkomma (;).',
    'php-settings.phpSettingDescription_error_reporting' => 'Het niveau van verslaglegging van foutmeldingen.',
    'php-settings.phpSettingDescription_display_errors' => 'Bepaalt of foutmeldingen moeten worden weergegeven als onderdeel van de uitvoer.',
    'php-settings.phpSettingDescription_log_errors' => 'In logbestand vastleggen van PHP-foutmeldingen inschakelen.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Stelt PHP-bestandsfuncties in staat om gegevens op te halen vanaf externe locaties via FTP of HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Staat het uploaden van bestanden via HTTP toe.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Staat de verkorte vorm toe ( ) van de openingstag van PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Stelt de status magic_quotes in voor GPC-bewerkingen (Get/Post/Cookie). Wanneer magic_quotes is ingeschakeld wordt aan alle enkele aanhalingstekens, dubbele aanhalingstekens, backslashes, en NULL-karakters automatisch het escapeteken backslash toegevoegd.',
    'php-settings.phpSettingDescription_disable_functions' => 'Deze opdracht stelt u in staat om bepaalde functies uit te schakelen.Het maakt gebruik van een met komma\'s gescheiden lijst met functienamen',
    'php-settings.phpSupport' => 'PHP-ondersteuning',
    'php-settings.phpRunAs' => 'PHP uitvoeren als',
    'php-settings.phpVersion' => 'PHP-versie',
    'php-settings.phpHandlerOutdated' => '(Verouderd)',
    'php-settings.phpHandlerDeprecated' => '(Verouderd)',
    'php-settings.phpServedByApache' => 'bediend door Apache',
    'php-settings.phpServedByNginx' => 'bediend door nginx',
    'php-settings.phpSettingsPhpVersion' => 'Uw versie van PHP is %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP is uitgeschakeld.',
    'php-settings.phpHandlerTypeHint' => 'Hieronder vind u de details van de PHP-instellingen van de website. U kunt de PHP-instellingen wijzigen als u daartoe het recht heeft gekregen van uw hostingprovider.',
    'php-settings.fpmDedicatedHandlerHint' => 'Het gebruik van deze handler verhoogt de stabiliteit van een website, maar het leidt ook tot extra geheugengebruik.',
    'php-settings.phpHandlerChangeHint' => 'U hebt de instellingen voor de PHP-handler gewijzigd. Als u deze wijzigingen opslaat kunnen de PHP-scripts op uw website voor %%interval%% seconden stoppen vanwege de serverconfiguratie.',
    'php-settings.phpHandlerOutdatedHint' => 'Om te controleren of de nieuwe PHP-versie beschikbaar is, %%link%% en kijk in de categorie "Webhosting" van de componenten.',
    'php-settings.phpHandlerOutdatedHintLink' => 'open Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Meer informatie over het kiezen van de meest geschikte PHP-instellingen',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Ondersteuning voor PHP kan niet worden ingeschakeld omdat de huidige hosting-instellingen geen versie van PHP voor dit domein beschikbaar stelt.',
    'php-settings.phpHandlersNotAvailableHint' => 'Er kan geen ondersteuning voor PHP inschakelen omdat de huidige Plesk-instellingen geen enkele versie van PHP bevatten.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Ontdek hoe u andere versies van PHP kunt inschakelen.',
    'php-settings.phpSupportEditable' => '(PHP-versie %%version%%, PHP uitvoeren als %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(versie: %%version%%; handler: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(niet geregistreerd) %%link%%',
    'php-settings.showPhpInfo' => 'Bekijk de pagina phpinfo()',
    'php-settings.phpSettingsFormError' => 'Kan geen PHP-instellingen ophalen omdat de vereiste gegevens niet aanwezig zijn.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Kan de PHP-instellingen niet ophalen omdat deze versie van PHP niet is geïnstalleerd. Om verder te gaan, installeert u de geselecteerde PHP-versie of selecteert u een andere versie voor het domein.',
    'php-settings.showPhpInfoTitle' => 'Bekijk phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Er zijn een aantal PHP-instellingen gewijzigd, maar de wijzigingen zijn nog niet opgeslagen. Om de nieuwe waarden te kunnen zien op de pagina phpinfo() moet u de wijzigingen eerst toepassen,. anders krijgt u de huidige waarden te zien.',
    'php-settings.showPhpInfoButton' => 'Bekijk phpinfo()',
    'php-settings.onState' => 'Aan',
    'php-settings.offState' => 'Uit',

    'pmm.agent.sync.check' => 'De migratie- en verhuisagent controleert of er nieuwe updates zijn.',
    'pmm.agent.sync.updating' => 'Migratie- en verhuisagent synchroniseren en downloaden.',
    'pmm.agent.sync.done' => 'Het synchroniseren van de Migratie- en verhuisagent is geslaagd.',
    'pmm.agent.sync.downloadLink' => 'Klik om de Migratie- en verhuisagent te downloaden die op de bronhost moet worden geïnstalleerd voordat de migratie wordt gestart.',
    'pmm.agent.sync.error' => 'Ophalen van updates voor Migratie- en verhuisagent is mislukt. Probeert u het later opnieuw.',

    'restore-password.title' => 'Uw wachtwoord wijzigen',
    'restore-password.passwordLabel' => 'Nieuw wachtwoord',
    'restore-password.buttonRestore' => 'Opslaan',
    'restore-password.buttonCancel' => 'Annuleren',
    'restore-password.isEmpty' => 'Het verplichte veld is leeg. U moet een waarde opgeven.',
    'restore-password.errorInvalidSecret' => 'Ongeldige geheime code',
    'restore-password.errorNotFoundSecret' => 'Vraag een nieuwe geheime code aan',
    'restore-password.restoreSuccess' => 'Uw wachtwoord is bijgewerkt. Gebruik het nieuwe wachtwoord om u bij Plesk of bij uw e-mailadres aan te melden.',

    'scheduler.settings.schedulerNotification' => 'Melding van takenrooster',
    'scheduler.settings.notificationOff' => "Uitgeschakeld",
    'scheduler.settings.notificationDefault' => "Versturen naar het standaard e-mailadres (%%email%%)",
    'scheduler.settings.notificationCustom' => "Versturen naar het e-mailadres dat ik opgeef",
    'scheduler.settings.crontabSecureShell' => 'Crontab-shell',
    'scheduler.settings.schedulerTimezoneSelector' => 'Geef het takenrooster weer in een specifieke tijdzone',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Gebruik de standaard tijdzone van het systeem (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Gebruik de standaard tijdzone van het systeem',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Gebruik de tijdzone die ik opgeef',

    'scheduler.task.active' => 'Actief',
    'scheduler.task.subscription' => 'Abonnement',
    'scheduler.task.subscription_powerUser' => 'Webruimte',
    'scheduler.task.type' => 'Soort taak',
    'scheduler.task.typeCommand' => 'Een opdracht uitvoeren',
    'scheduler.task.typeUrl' => 'Een URL ophalen',
    'scheduler.task.typeScript' => 'Een PHP-script uitvoeren',
    'scheduler.task.command' => 'Opdracht',
    'scheduler.task.arguments' => 'met argumenten',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Geef een absolute URL op, zoals http://voorbeeld.nl. Als de statuscode die wordt teruggegeven 2xx of 3xx is, dan wordt ervan uitgegaan dat het uitvoeren van de taak is geslaagd.',
    'scheduler.task.script' => 'Zoekpad naar script',
    'scheduler.task.scriptRelativePathDescription' => 'Bijvoorbeeld: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Geef volledig zoekpad naar het script op. Bijvoorbeeld: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Gebruik PHP-versie',
    'scheduler.task.scriptPathPopupTitle' => 'Zoekpad naar script',
    'scheduler.task.run' => 'Uitvoeren',
    'scheduler.task.on' => 'aan',
    'scheduler.task.at' => 'om',
    'scheduler.task.sysUser' => 'Systeemgebruiker',
    'scheduler.task.hourly' => 'Elk uur',
    'scheduler.task.daily' => 'Dagelijks',
    'scheduler.task.weekly' => 'Wekelijks',
    'scheduler.task.monthly' => 'Maandelijks',
    'scheduler.task.yearly' => 'Jaarlijks',
    'scheduler.task.cronStyle' => 'Cron-stijl',
    'scheduler.task.cronStyleError' => 'Ongeldige crontab-syntax.',
    'scheduler.task.cronStyleErrorWin' => 'De slash (/) en het verbindingsstreepje (-) zijn niet toegestaan.',
    'scheduler.task.cronStyleHint' => 'Gebruik de UNIX crontab-notatie "minuut uur dag-van-de-maand maand dag-van-de-week". Bijvoorbeeld "0 22 * * 1-5". Plesk zal voor het uitvoeren van de taak gebruik maken van de standaard tijdzone van het systeem.',
    'scheduler.task.cronStyleWinHint' => 'Gebruik de notatie "minuut uur dag-van-de-maand maand dag-van-de-week", bijvoorbeeld "0 22 * * 6,7". Plesk zal voor het uitvoeren van de taak gebruik maken van de standaard tijdzone van het systeem.',
    'scheduler.task.notify' => 'Melding versturen',
    'scheduler.task.notifyIgnore' => 'Geen melding maken',
    'scheduler.task.notifyErrors' => 'Alleen foutmeldingen',
    'scheduler.task.notifyAlways' => 'Elke keer',
    'scheduler.task.notifyErrorsHint' => 'Meldingen bevatten de standaard uitvoer van foutmeldingen van de opdracht. Als de uitvoer leeg is, wordt er geen melding verstuurd.',
    'scheduler.task.notifyErrorsHintWin' => 'Meldingen bevatten de uitvoer van de opdracht en worden alleen verstuurd als de exit-code geen nul is.',
    'scheduler.task.notifyAlwaysHint' => 'Meldingen bevatten de uitvoer van de opdracht. Als de uitvoer leeg is, wordt er geen melding verstuurd.',
    'scheduler.task.notifyAlwaysHintWin' => 'Meldingen bevatten de uitvoer van de opdracht en worden verstuurd ongeacht de exit-code van de opdracht.',
    'scheduler.task.emailType' => 'Meldingen sturen naar',
    'scheduler.task.emailTypeDefault' => 'Standaard systeemgebruiker (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Abonnement van de eigenaar (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Beheerder (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Andere gebruikers',
    'scheduler.task.emailTypeCustomDescription' => 'U kunt meerdere adressen opgegeven; scheid deze met komma\'s.',
    'scheduler.task.minute' => 'minuut',
    'scheduler.task.shortMinute' => 'min',
    'scheduler.task.dayOfMonth' => 'dag',
    'scheduler.task.description' => 'Omschrijving',
    'scheduler.task.scheduleTimezoneHint' => 'De tijdzone waarbinnen de taak is ingeroosterd is %%timezone%%',
    'scheduler.task.runTaskNow' => 'Nu uitvoeren',
    'scheduler.task.runningTask' => 'De taak "%%task%%" uitvoeren...',

    'server-settings.title' => "Server-instellingen",
    'server-settings.submitDone' => "De serverinstellingen zijn gewijzigd.",
    'server-settings.systemSettings' => "Systeeminstellingen",
    'server-settings.fullHostName' => "Volledige hostnaam",
    'server-settings.trafficStatisticsPeriod' => "Web- en dataverkeerstatistieken behouden gedurende",
    'server-settings.trafficStatisticsPeriodUnit' => "maanden",
    'server-settings.diskSpaceUsageCalculation' => "Meenemen bij de berekening van het schijfruimtegebruik",
    'server-settings.includeLogs' => "logbestanden",
    'server-settings.includeLogsAndStats' => "logbestanden en statistische overzichten",
    'server-settings.includeMysqlDatabases' => "MariaDB/MySQL-databases",
    'server-settings.includeMssqlDatabases' => "Microsoft SQL-databases",
    'server-settings.includePgsqlDatabases' => "PostgreSQL-databases",
    'server-settings.includeDatabases' => "databases",
    'server-settings.includeRemoteDatabases' => "externe databases",
    'server-settings.includeMailboxes' => "postvakken",
    'server-settings.includeMailLists' => "verzendlijsten",
    'server-settings.includeDomainDumps' => "reservekopieën van domeinen",
    'server-settings.includeAdminDumps' => "door de beheerder aangemaakte reservekopieën",
    'server-settings.calculatingDiskSpaceUsage' => "Bij het berekenen van de schijfruimte, reken",
    'server-settings.typeByte' => "bestandsgrootte",
    'server-settings.typeBlock' => "hoeveelheid verbruikte schijfruimte",
    'server-settings.trafficCalculation' => "Meenemen bij de berekening van het dataverkeer",
    'server-settings.inboundAndOutbound' => "binnenkomend en uitgaand dataverkeer",
    'server-settings.onlyInbound' => "alleen inkomend dataverkeer",
    'server-settings.onlyOutbound' => "alleen uitgaand dataverkeer",
    'server-settings.forbidCreateDnsSubZone' => "Gebruikers mogen geen DNS-subzones aanmaken in de DNS-superzones van andere gebruikers",
    'server-settings.webDeployIncludePassword' => "Het wachtwoord van de gebruiker opslaan in het bestand met de publicatie-instellingen van Web Deploy",
    'server-settings.forbidSysUserRename' => "Cliënten kunnen de naam van hun systeemgebruikers wijzigen",
    'server-settings.alwaysAllowSysUserRename' => "altijd",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "alleen als het recht Hostingbeheer is toegekend",
    'server-settings.neverAllowSysUserRename' => "nooit",
    'server-settings.forbidSubscriptionRename' => "Verbied cliënten en resellers de naam van hun hoofddomein te wijzigen",
    'server-settings.preferredDomain' => "Voorkeursdomein voor websites",
    'server-settings.preferredDomainNone' => "geen",
    'server-settings.preferredDomainToLanding' => "domein.tld",
    'server-settings.preferredDomainToWww' => "www.domein.tld",
    'server-settings.ipLogging' => "IP-logboekregistratie",
    'server-settings.disableIpLogging' => "IP-registratie in de IIS-, FTP- en e-maillogboeken uitschakelen",
    'server-settings.disableIpLoggingDescription' => "Als deze optie is geselecteerd zullen IIS en MailEnable geen IP-adressen meer in logbestanden opslaan",
    'server-settings.anonymizeIps' => "IP-adressen anonimiseren",
    'server-settings.logrotateAnonymizeIps' => "Anonimiseer IP-adressen tijdens logopschoning en tijdens het verzamelen van webstatistieken",
    'server-settings.logrotateAnonymizeIpsDescription' => 'Het post-opschoningscript vervangt voor het archiveren het laatste octet van IPv4-adressen in de logbestanden met "0". In IPv6-adressen vervangt het script de laatste sectie van het adres (twee octetten na de laatste dubbele punt) met "0000" (in de volledige vorm) of "0" (in de verkorte vorm)',
    'server-settings.logrotate' => "Logopschoning",
    'server-settings.logrotateForce' => "Forceer dagelijkse logopschoning voor alle domeinen",
    'server-settings.allowToStoreLogs' => "Het opslaan van logbestanden van websites toestaan voor",
    'server-settings.logrotatePeriod' => "dagen",
    'server-settings.configureUpdatePolicy' => "Het updatebeleid instellen",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Standaardwaarde voor server als geheel (%%default%% berichten per uur)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Aangepaste waarde voor het pakket',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Aangepaste waarde voor het abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'berichten',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Uitgaande berichten van een postvak (per uur)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Uitgaande berichten van een domein (per uur)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Uitgaande berichten van een abonnement (per uur)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Het percentage berichten dat uitstijgt boven de beperking per uur dat in het volgende uur zal worden verstuurd',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Als de beperking van het aantal uitgaande e-mailberichten vanuit een postvak per uur is ingesteld op 100 en het percentage is 10%, dan mag de gebruiker maar 110 berichten per uur versturen; 100 berichten worden gedurende het eerste uur verstuurd, en 10 berichten worden in de wachtrij opgeslagen om in het volgende uur te worden verwerkt.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Gebruikersbeleid Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Standaard instellingen voor server als geheel (Sendmail toegestaan)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Standaard instellingen voor server als geheel (Sendmail niet toegestaan)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Aangepaste instellingen voor het pakket',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Aangepaste instellingen voor het abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Sta het gebruik van Sendmail toe voor scripts en voor gebruikers van dit abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Scripts en gebruikers kunnen via Sendmail e-mailberichten versturen (namens de systeemgebruiker van het abonnement), zelfs als de beperkingen van een postvak of domein zijn overschreden. Het maximaal aantal berichten dat kan worden verstuurd via Sendmail zal worden bepaald door de beperking van het abonnement als geheel.',

    'setup.hint' => 'Welkom bij Plesk, het configuratiescherm dat u helpt uw server te beheren. Plesk biedt u een ready-to-code-omgeving en een reeks aan krachtige uitbreidingen die u helpen bij het ontwikkelen van websites en apps. Als u de configuratie voltooid kunt u direct aan de slag met Plesk (het duurt maar een minuut).',
    'setup.contactInfoSection' => 'Contactgegevens',
    'setup.contactInfoSectionHint' => 'Geef uw naam en e-mailadres op om uzelf te identificeren als eigenaar van de server en om belangrijke meldingen over de server te ontvangen. Als u beheerder bent van een zakelijke server, geef dan niet uw persoonlijke naam of e-mailadres op. Gebruik in plaats daarvan uw functie en uw zakelijke e-mailadres om te voorkomen dat u mogelijk wetgeving voor gegevensbescherming schendt.',
    'setup.contactName' => 'Uw contactnamen',
    'setup.emptyContactName' => 'Geef een contactnaam op.',
    'setup.contactNameTooLong' => 'De naam van de contactpersoon is te lang (max. %max% tekens zijn toegestaan).',
    'setup.email' => 'E-mail',
    'setup.emptyEmail' => 'Geef een e-mailadres op.',
    'setup.passwordSection' => 'Wachtwoord',
    'setup.passwordSectionHint' => 'De volgende keer wanneer u zich bij Plesk aanmeldt kunt u gebruik maken van de gebruikersnaam \'admin\' en het wachtwoord dat hieronder is opgegeven.',
    'setup.password' => 'Wachtwoord',
    'setup.licenseSection' => 'Licentie',
    'setup.licenseSectionHint' => 'U moet een licentie installeren als u Plesk wilt gaan gebruiken.',
    'setup.licenseType' => 'Selecteer het soort licentie dat u wilt gebruiken',
    'setup.licenseTypePaid' => 'Ga verder met een betaalde licentie',
    'setup.onlineStoreLink' => 'Webwinkel',
    'setup.licenseTypeTrial' => 'Ga verder met een proeflicentie met volledige functionaliteit',
    'setup.activationCodeHint' => 'Als u al een licentie van Plesk hebt aangeschaft, dan kunt u hier de activatiecode plakken die u hebt ontvangen. Zo niet, dan kunt u een nieuwe licentie aanschaffen in onze %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Privacybeleid WebPros',
    'setup.trialLicenseAgreement' => 'Voor het verstrekken van een proeflicentie gebruikt en verwerkt WebPros International GmbH de verstrekte informatie in zijn interne systemen volgens het %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Ik bevestig dat ik de %%link%% heb gelezen en dat ik deze accepteer',
    'setup.eula' => 'Licentieovereenkomst voor eindgebruikers',
    'setup.invalidEulaAgreementValue' => 'U moet de Licentieovereenkomst voor eindgebruikers accepteren',
    'setup.sendButton' => 'Naar Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Het beheerderswachtwoord opnieuw instellen bij de volgende aanmelding',

    'spam-filter.add.titleBlack' => 'Adressen aan de zwarte lijst toevoegen',
    'spam-filter.add.titleWhite' => 'Adressen aan de whitelist toevoegen',
    'spam-filter.add.fileDescription' => 'Upload een tekstbestand in UTF-8 codering (bijvoorbeeld een *.txt of *.csv bestand).',
    'spam-filter.add.listDescription' => 'Regels voor notatie: <ul><li>Scheidt verschillende adressen met een komma, puntkomma of een nieuwe regel, spatie of tab</li><li>Gebruik geen niet-ASCII-karakters links van het apenstaartje (@).</li><li>Je kunt gebruik maken van de jokers "*" en "?" (bijvoorbeeld, <nobr>*@domein.nl,</nobr> <nobr>gebruiker?@*.nl</nobr>).</li><li>Maak geen gebruik van jokers in niet-ASCII-delen van domeinnamen.</li></ul>',
    'spam-filter.add.fromFile' => 'Uit bestand',
    'spam-filter.add.fromList' => 'Uit lijst',
    'spam-filter.add.success' => 'Adressen zijn toegevoegd',

    'ssl-certificate.add.name' => 'Certificaatnaam',
    'ssl-certificate.add.longName' => 'De opgegeven certificaatnaam is te lang (er zijn maximaal %max% karakters toegestaan).',
    'ssl-certificate.add.certificateNameUsed' => 'Er bestaat al een certificaat met de naam %%name%%.',
    'ssl-certificate.add.certificateAdded' => 'Het SSL/TLS-certificaat is uitgegeven. U kunt het certificaat nu toewijzen voor het beveiligen van een domein, e-mail of webmail.',
    'ssl-certificate.add.certificateUpdated' => 'Het bijwerken van het SSL/TLS-certificaat is geslaagd.',
    'ssl-certificate.add.settings' => 'Instellingen',
    'ssl-certificate.add.settingsHint' => 'Gebruik dit formulier om een certificaataanvraag te genereren, om een certificaat aan te schaffen bij uw provider of om een zelfgetekend certificaat aan te maken.',
    'ssl-certificate.add.settingsHint2' => 'Een verzoek is een CSR-bestand dat de gegevens van uw domein bevat zoals u deze hebt opgegeven in het formulier. U kunt het verzoek opsturen naar een certificaatautoriteit die een certificaat voor u zal uitgeven. U kunt deze vervolgens uploaden via een van de onderstaande formulieren.',
    'ssl-certificate.add.settingsHint3' => 'Een zelfgetekend certificaat is een identiteitscertificaat dat is ondertekend door de uitgever zelf. Als u een dergelijk certificaat gebruikt betekent dit dat u zelf de identiteit van uw sites controleert. Hoewel zelfgetekende certificaten het gebruik van SSL/TLS toestaan worden ze minder vertrouwd en gelden ze als minder veilig.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'Land',
    'ssl-certificate.add.state' => 'Staat of provincie',
    'ssl-certificate.add.longState' => 'De opgegeven naam van de staat of provincie is te lang.',
    'ssl-certificate.add.city' => 'Locatie (plaats)',
    'ssl-certificate.add.longCity' => 'De opgegeven plaatsnaam is te lang.',
    'ssl-certificate.add.shortCity' => 'De opgegeven plaatsnaam is te kort.',
    'ssl-certificate.add.companyName' => 'Naam van de organisatie (bedrijf)',
    'ssl-certificate.add.longCompanyName' => 'De opgegeven bedrijfsnaam is te lang.',
    'ssl-certificate.add.companyUnitName' => 'Naam van afdeling/divisie binnen organisatie',
    'ssl-certificate.add.longCompanyUnitName' => 'De opgegeven naam voor de afdeling van uw organisatie is te lang (er zijn maximaal %max% karakters toegestaan).',
    'ssl-certificate.add.domainName' => 'Domeinnaam',
    'ssl-certificate.add.email' => 'E-mail',
    'ssl-certificate.add.request' => 'Aanvragen',
    'ssl-certificate.add.buyCertificate' => 'SSL/TLS-certificaat aanschaffen',
    'ssl-certificate.add.selfSigned' => 'Zelfgetekend',
    'ssl-certificate.add.invalidCertificateParams' => 'Sommige velden zijn leeg of bevatten ongeldige waarden. De waarden mogen niet meer dan 64 karakters bevatten. Mocht u een geïnternationaliseerde domeinnaam gebruiken, zorg er dan voor dat elk deel van de naam tussen de punten niet langer is dan 63 symbolen wanneer deze wordt omgezet naar ASCII-formaat. Controleer de velden:',
    'ssl-certificate.add.unableCreateCsr' => 'Kan geen CSR aanmaken: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Kan geen zelfgetekend certificaat aanmaken: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Kan de gegevens van het certificaat niet instellen: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Kan het certificaat niet in de database opslaan: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Certificaatbestanden uploaden',
    'ssl-certificate.add.uploadFilesHint' => 'Gebruik dit formulier voor het uploaden van de componenten van een certificaat als afzonderlijke bestanddelen.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Private sleutel (*.key)",
    'ssl-certificate.add.certificate' => "Certificaat (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA-certificaat (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Certificaat uploaden",
    'ssl-certificate.add.fileNotUploaded' => 'Kan het certificaatbestand niet uploaden: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Kan private sleutel niet instellen: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Kan certificaat niet instellen: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Kan CA-certificaat niet instellen: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Kan niet controleren of het CA-certificaat het certificaat ondertekent: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Verwijderen',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Wilt u het CA-certificaat verwijderen?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Het CA-certificaat komt niet door de controle: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'The CA-deel van het certificaat is verwijderd.',
    'ssl-certificate.add.rename' => 'Naam wijzigen',
    'ssl-certificate.add.unableRenameCertificate' => 'Kan de naam van het certificaat niet wijzigen: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'De naam van het certificaat is gewijzigd naar %%name%%.',
    'ssl-certificate.add.uploadText' => "Certificaat uploaden als tekst",
    'ssl-certificate.add.uploadTextHint' => 'Gebruik dit formulier voor het uploaden van de componenten van een certificaat in tekstformaat. Kopieer de inhoud van een bestand en plak deze in het bijbehorende veld.',
    'ssl-certificate.add.sendText' => "Certificaat uploaden",
    'ssl-certificate.add.componentIsMissing' => 'Component ontbreekt.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Upload het certificaat hier',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Als u een tekenverzoek voor een certificaat hebt aangemaakt op deze server en u ontvangt het certificaatbestand, dan kunt u deze hier uploaden. Als u een certificaat met een private sleutel wilt uploaden die op een andere server is aangemaakt, of u wilt een zelfgetekend certificaat aanmaken, klik dan op <b>SSL/TLS-certificaat toevoegen</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Als u een SSL/TLS-certificaat aan een domein hebt toegevoegd moet u de ondersteuning voor SSL/TLS inschakelen en het juiste certificaat selecteren in de hosting-instellingen van de website: <b>Websites & domeinen</b>> <b>Hosting-instellingen</b> van dit domein> <b>Beveiliging</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificaat (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Certificaat uploaden',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Kan het certificaatbestand niet uploaden.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Ongeldig certificaatformaat.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Kan geen passende private sleutel voor het certificaat vinden.',

    'ssl-certificate.secure.certificate' => 'Selecteer Certificaat',
    'ssl-certificate.secure.serverPool' => 'serverpool',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Datum",
    'system-time.dateAndTime' => "Datum en tijd",
    'system-time.daylight' => "Klok automatisch aanpassen aan zomer- en wintertijd",
    'system-time.dayMonthYear' => "Dag-Maand-Jaar",
    'system-time.domainNameOrIp' => "Domeinnaam of IP",
    'system-time.hoursMinutesSeconds' => "Uren:Minuten:Seconden",
    'system-time.networkTime' => "Netwerktijd",
    'system-time.submitDone' => "Instellingen van de systeemtijd zijn gewijzigd.",
    'system-time.synchronizedSystemTime' => "Systeemtijd synchroniseren",
    'system-time.title' => "Systeemdatum en -tijd",
    'system-time.timezone' => "Tijdzone",
    'system-time.time' => "Tijd",
    'system-time.updateSystemTime' => "Systeemtijd bijwerken",
    'system-time.yourTimezone' => "Uw tijdzone",

    'web-app-firewall.pageHint' => 'De Firewall voor webtoepassingen beschermt webtoepassingen tegen aanvallen door inkomende HTTP-aanvragen te controleren en te filteren op basis van door de gebruiker aangegeven regels.',
    'web-app-firewall.webSitePageHint' => 'Hier kunt u de firewall voor webtoepassingen instellen (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Modus firewall voor webtoepassingen',
    'web-app-firewall.ruleEngineOn' => 'Aan',
    'web-app-firewall.ruleEngineOnDescription' => 'Elke inkomende HTTP-aanvraag en het antwoord daarop worden gecontroleerd aan de hand van een set van regels. Als de controle slaagt, zal de HTTP-aanvraag worden doorgezet naar de inhoud van de website. Als de controle mislukt wordt het event vastgelegd in een logboek, er wordt een melding verzonden en het HTTP-antwoord krijgt een foutcode.',
    'web-app-firewall.ruleEngineOff' => 'Uit',
    'web-app-firewall.ruleEngineOffDescription' => 'Inkomende HTTP-aanvragen en gerelateerde antwoorden worden niet gecontroleerd.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Alleen detecteren',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Elke inkomende HTTP-aanvraag en het antwoord daarop worden gecontroleerd aan de hand van een set van regels. Als de controle slaagt, zal de HTTP-aanvraag worden doorgezet naar de inhoud van de website. Als de controle mislukt, dan wordt het event vastgelegd in een logboek en ModSecurity doet verder niets. Andere diensten (bijvoorbeeld Fail2Ban) kunnen nog steeds hun eigen acties uitvoeren op HTTP-aanvragen die de controle niet doorkomen.',
    'web-app-firewall.ruleSetsSection' => 'Regelsets',
    'web-app-firewall.ruleSetsSectionHint' => 'Selecteer welke regelset (een pakket bestanden die de beveiligingseregels bevatten) moeten worden gebruikt voor het controleren van inkomende HTTP-aanvragen.',
    'web-app-firewall.ruleSet' => 'Regelset',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratis)',
    'web-app-firewall.ruleSetCrsDescription' => 'De set met basisregels van OWASP ModSecurity is erg restrictief en doordoor kunnen sommige functies worden geblokkeerd (bijvoorbeeld het delen van bestanden, webmail), inclusief functies van webtoepassingen (bijvoorbeeld WordPress-plugins).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Wijzigingen toepassen?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'De OWASP-regels zijn wellicht erg beperkend en kunnen daarom bepaalde functies blokkeren, zoals Bestandsdeling en het gebruik van bepaalde webtoepassingen.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratis, upgrade naar Atomic Advanced mogelijk)',
    'web-app-firewall.ruleSetTortixDescription' => 'Een basisversie van ModSecurity Rules by Atomicorp. Deze bieden basisbescherming en worden maandelijks bijgewerkt.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Upgrade van deze regelset naar Atomic Advanced uitvoeren:',
    'web-app-firewall.ruleSetTortixBuy' => 'Schaf %%linkPleskStore%% aan op de Plesk-website en %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity Rules door Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'Installeer de aangeschafte aanvullende licentiesleutel',
    'web-app-firewall.ruleSetTortixSelect' => 'Selecteer deze regelset, waarvan de naam wordt gewijzigd naar "Atomic Advanced (aangeschaft bij Plesk)"',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (aangeschaft bij Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules by Atomicorp bevat de standaardregels van Atomic, plus een aantal geavanceerde mogelijkheden.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (aangeschaft bij Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules by Atomicorp bevat de standaardregels van Atomic, plus een aantal geavanceerde mogelijkheden.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Overschakelen naar een ander Atomicorp-account.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Regelset is geactiveerd.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Als u al beschikt over een Atomicorp-account met aangeschafte Atomic Advanced-regels, dan geeft u hieronder de aanmeldgegevens van dit account op om deze regelset in te schakelen.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Als u al beschikt over een Atomicorp-account met Atomic Advanced-regels die u hebt aangeschaft, geef dan de onderstaande accountgegevens op om van account te wisselen.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Gebruikersnaam',
    'web-app-firewall.ruleSetAtomicPassword' => 'Wachtwoord',
    'web-app-firewall.ruleSetComodo' => 'Comodo (gratis abonnement)',
    'web-app-firewall.ruleSetComodoDescription' => 'Gratis ModSecurity-regels van Comodo Deze bieden basisbescherming.',
    'web-app-firewall.ruleSetComodoInstall' => 'Overschakelen naar een ander Comodo-account.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Regelset is geactiveerd.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Deze regelset inschakelen:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Overschakelen naar een ander account.',
    'web-app-firewall.ruleSetComodoRegister' => 'Registreer u op de website van Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Geef uw gebruikersnaam en wachtwoord van die site op.',
    'web-app-firewall.ruleSetComodoLogin' => 'Gebruikersnaam',
    'web-app-firewall.ruleSetComodoPassword' => 'Wachtwoord',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratis)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Gratis ModSecurity-regels van Comodo Deze bieden basisbescherming.',
    'web-app-firewall.ruleSetCustom' => 'Aangepaste regelset',
    'web-app-firewall.ruleSetCustomDescription' => 'Een aangepaste regelset voor de firewall van de webapplicatie uploaden. Ondersteunde formaten: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Selecteer een ander bestand',
    'web-app-firewall.ruleSetError' => 'Het installeren van de ModSecurity-regelset is mislukt: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'De OWASP-regelset ontbreekt. Installeer ModSecurity opnieuw via het installatieprogramma van Plesk.',
    'web-app-firewall.ruleSetCustomMissingError' => 'De aangepaste regelset ontbreekt. Installeer de regelset opnieuw.',
    'web-app-firewall.ruleSetAuthError' => 'Het opgegeven gebruikersnaam en wachtwoord is ongeldig.',
    'web-app-firewall.ruleSetInvalid' => 'De geselecteerde regelset kan niet worden uitgevoerd op %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'De geselecteerde regelset kan niet worden uitgevoerd op de geselecteerde webserver.',
    'web-app-firewall.webServer' => 'Regels uitvoeren op',
    'web-app-firewall.webServerHint' => 'Selecteer de gewenste combinatie van webserver- en ModSecurity-versie om te zien welke regelsets compatibel zijn.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'De reverse proxy server (nginx) is uitgeschakeld en kan niet worden gebruikt voor het verwerken van verzoeken. Selecteer <a href="%%serverUrl%%">een andere webserver</a> of schakel de reserve proxy server in vanaf de pagina <a href="%%servicesUrl%%"> Beheer diensten</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Als u een andere versie van ModSecurity selecteert, dan kan het voorkomen dat sommige instellingen niet langer geldig zijn (u kunt bijvoorbeeld geen reguliere expressies meer gebruiken om beveiligingsregels uit te schakelen met ModSecurity 3). Zorg ervoor dat, nadat u de wijzigingen hebt aangebracht, uw instellingen nog werken zoals bedoeld. Als alternatief kunt u de standaardwaarden terugplaatsen voor de instellingen die beveiligingsregels uitschakelen.',
    'web-app-firewall.nginxResetCustomizations' => 'De standaardwaarden terugplaatsen voor server- en domeininstellingen die beveiligingsregels uitschakelen.',
    'web-app-firewall.ruleSetUpdate' => 'Regelsets bijwerken',
    'web-app-firewall.ruleSetUpdateDaily' => 'Dagelijks',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Wekelijks',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Maandelijks',
    'web-app-firewall.currentRuleSet' => 'Regelset',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% uitgevoerd op %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Regelset wijzigen',
    'web-app-firewall.ruleSetRollbackFailed' => 'Kan de huidige regelset van ModSecurity niet gebruiken en kan ook niet terugkeren naar de vorige versie, omdat beide ongeldige regels bevatten.',
    'web-app-firewall.configurationSection' => 'Instellingen',
    'web-app-firewall.configurationSectionHint' => 'U kunt de firewall voor webtoepassingen instellen via ofwel een vooraf ingestelde set van parameters of via uw eigen aangepaste ModSecurity-opdrachten.',
    'web-app-firewall.configPreset' => 'Vooraf ingestelde set van waarden',
    'web-app-firewall.configPresetFast' => 'Snell',
    'web-app-firewall.configPresetFastDescription' => 'De URI van de HTTP-aanvraag en delen van de headers zullen worden geanalyseerd.',
    'web-app-firewall.configPresetTradeOff' => 'Gebalanceerd',
    'web-app-firewall.configPresetTradeOffDescription' => 'De URI van de HTTP-aanvraag, de headers en de POST-data van de aanvraag zullen worden geanalyseerd.',
    'web-app-firewall.configPresetThrough' => 'Grondig',
    'web-app-firewall.configPresetThroughDescription' => 'De volledige HTTP-headers en de POST-data van de aanvraag en de inhoud van het HTTP-antwoord zullen worden geanalyseerd.',
    'web-app-firewall.configCustom' => 'Aangepaste instructies',
    'web-app-firewall.configCustomDescription' => "Voer hier een ModSecurity-opdracht in. Deze komt in de plaats van eerder opgegeven opdrachten (regelsets, specifieke regels, de vooraf ingestelde set van waarden, enzovoorts).\nBijvoorbeeld: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Ongeldige configuratie van ModSecurity: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Kan het huidige configuratiebestand van ModSecurity niet gebruiken om terug te keren naar de vorige versie van het bestand omdat deze een ongeldige configuratie bevat.',
    'web-app-firewall.rulesSection' => 'Beveiligingsregels uitschakelen',
    'web-app-firewall.rulesSectionHint' => 'Hier kunt u beveiligingsregels uitschakelen. Dit kan handig zijn wanneer u merkt dat een beveiligingsregel voor bepaalde websites te restrictief is. Om beveiligingsregels te deactiveren, geeft u deze op aan de hand van hun kenmerk (bijvoorbeeld 340003 of 340005-340007), tags (bijvoorbeeld CVE-2011-4898) of de reguliere expressies die in regelberichten worden gebruikt (bijvoorbeeld XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Hier kunt u beveiligingsregels uitschakelen. Dit kan handig zijn wanneer u merkt dat een beveiligingsregel voor bepaalde websites te restrictief is. Om beveiligingsregels te deactiveren, geeft u deze op aan de hand van hun kenmerk (bijvoorbeeld 340003 of 340005-340007), tags (bijvoorbeeld CVE-2011-4898) of de reguliere expressies die in regelberichten worden gebruikt (bijvoorbeeld Found User-Agent associated with security scanner).',
    'web-app-firewall.filterById' => 'Kenmerken beveiligingsregels',
    'web-app-firewall.filterByIdInvalid' => 'De volgende waarden zijn niet geldig: %%values%%. Het kenmerk een regel moet bestaan uit getallen of een getalreeks, zoals 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'De volgende reeksen zijn niet geldig: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Tags',
    'web-app-firewall.filterByTagActive' => 'Actief:',
    'web-app-firewall.filterByTagDeactivated' => 'Uitgeschakeld:',
    'web-app-firewall.filterByTagInvalid' => 'De volgende geselecteerde waarden zijn niet geldig: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Reguliere expressies in regelberichten',
    'web-app-firewall.filterByRegexpInvalid' => 'De volgende waarden zijn niet geldig: %%values%%; hier mogen geen van de tekens \', " in voorkomen.',
    'web-app-firewall.filterByRegexpNginx' => 'Regelberichten',
    'web-app-firewall.filterByRegexpNginxHint' => 'Alleen exacte overeenkomsten worden ondersteund.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'De volgende waarden zijn niet geldig: %%values%%. Het regelbericht moet bestaan uit letters, cijfers, spaties of de tekens -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Auditlog van ModSecurity',
    'web-app-firewall.auditLogHint1' => 'Het auditlogbestand ModSecurity levert de nuttigste informatie in het systeem. Als ModSecurity vaststelt dat er een iets gebeurt, dan wordt er een ingang aangemaakt in het auditlogbestand.',
    'web-app-firewall.auditLogHint2' => 'Het is mogelijk dat een website niet meer goed functioneert nadat u de modus van de firewall voor webtoepassingen hebt gewijzigd naar Aan vanaf Uit of Alleen detecteren. Analyseer in dat geval het auditlog van ModSecurity met foutmeldingen om erachter te komen wat er gebeurt. Beveiligingsregels die te restrictief zijn kunt u uitschakelen of u kunt de website aanpassen.',
    'web-app-firewall.auditLogHint3' => 'Onderzoeken waarom een HTTP-aanvraag voor een website niet kan worden voltooid:',
    'web-app-firewall.auditLogPoint1' => 'Klik op de link ModSecurity-logbestand hieronder en open het auditlogbestand in een nieuw venster van de browser.',
    'web-app-firewall.auditLogPoint2' => 'Gebruik de zoekfunctie (Ctrl+F in de meeste browsers) om events te vinden voor de website (de domeinnaam) met problemen. Bijvoorbeeld: uw_domein.nl. De browser zal de ingangen aangeven zoals HOST: uw_domein.nl.',
    'web-app-firewall.auditLogPoint3' => 'Drie regels boven de aangegeven ingang ziet u een tekenreeks die eruit ziet als --eece5138-B--. De acht karakters tussen de streepjes (in dit voorbeeld is dat eece5138) zijn het kenmerk van het event dat door de HTTP-aanvraag in het leven is geroepen.',
    'web-app-firewall.auditLogPoint4' => 'Zoeker verder naar andere ingangen met hetzelfde event-kenmerk. Zoek naar een ingang met de letter H achter het event-kenmerk (in het bovenstaande voorbeeld eece5138-H--). Deze ingang bevat het kenmerk en de omschrijving van de beveiligingsregel die is toegepast tijdens de controle van de HTTP-aanvraag. Het kenmerk van de beveilingsregel is een geheel getal in aanhalingstekens dat begint met het voorvoegsel id dat tussen rechte haken is geplaatst. Bijvoorbeeld, [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'Zoek naar het kenmerk van een beveiligingsregel in het event door middel van een substring (bijvoorbeeld, [id "3).',
    'web-app-firewall.auditLogPoint6' => 'Schakel de beveiligingsregel met dit kenmerk uit in de sectie Beveiligingsregels hieronder: geef het kenmerk van de beveiligingsregel (alleen getallen) op in het veld Kenmerken beveiligingsregels en klik op OK.',
    'web-app-firewall.auditLogViewLink' => 'Logbestand van ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Archief logbestanden',
    'web-app-firewall.errorLogSection' => 'Foutmelding-log',
    'web-app-firewall.errorLogSectionHint' => 'Het is mogelijk dat een website niet meer goed functioneert nadat u de modus van de firewall voor webtoepassingen hebt gewijzigd naar Aan vanaf Uit of Alleen detecteren. Analyseer in dat geval het logbestand met foutmeldingen om erachter te komen wat er gebeurt. Beveiligingsregels die te restrictief zijn kunt u uitschakelen of u kunt de website aanpassen.',
    'web-app-firewall.errorLogViewLink' => 'Logbestand met foutmeldingen',
    'web-app-firewall.notificationStateEnabled' => 'Meldingen in Plesk wanneer regelsets worden bijgewerkt zijn ingeschakeld. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Meldingen in Plesk wanneer regelsets worden bijgewerkt zijn uitgeschakeld. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'U kunt deze beheren op de pagina met meldingen',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Het selecteren van de opties "Gebalanceerd" of "Grondig" kan ertoe leiden dat WordPress-sites niet goed werken; het kan ook andere ongewenste bijwerkingen hebben vanwege het volgende <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity-probleem</a>.',

    'ProtectedDirectory.pathLabel' => 'Mapnaam',
    'ProtectedDirectory.realmLabel' => 'Titel van de afgeschermde omgeving',
    'ProtectedDirectory.locationLabel' => 'Maplocatie',
    'ProtectedDirectory.isNonSslLabel' => 'niet-SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'Verslagnaam',
    'SummaryReport.Layout.isDefault' => 'Gebruik als standaardverslag',
    'SummaryReport.Layout.sections' => 'Secties',
    'SummaryReport.Layout.general' => 'Algemeen',
    'SummaryReport.Layout.resellers' => 'Resellers',
    'SummaryReport.Layout.clients' => 'Cliënten',
    'SummaryReport.Layout.personalClients' => 'Eigen cliënten',
    'SummaryReport.Layout.domains' => 'Domeinen',
    'SummaryReport.Layout.personalDomains' => 'Persoonlijke domeinen',
    'SummaryReport.Layout.type.full' => 'Volledig',
    'SummaryReport.Layout.type.summary' => 'Samenvatting',

    'SummaryReport.Schedule.enable' => 'Activeren',
    'SummaryReport.Schedule.period' => 'Bezorgfrequentie',
    'SummaryReport.Schedule.daily' => 'Dagelijks',
    'SummaryReport.Schedule.weekly' => 'Wekelijks',
    'SummaryReport.Schedule.monthly' => 'Maandelijks',
    'SummaryReport.Schedule.email' => 'Bezorgen aan',
    'SummaryReport.Schedule.isEmpty' => 'Voer een geldig e-mail adres in.',
];