<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'cgroups.size' => 'Valor inválido: "%value%". O valor deve ser igual ou superior a %unitMin%, menor ou igual a %unitMax% e não pode ser igual a 0.',
    'cgroups.unlimited' => 'Ilimitado',
    'cgroups.period' => 'Valor inválido: "%value%". O valor deve ser 5 minutos, uma hora ou um dia, especificado em segundos (300, 3600, ou 86400).',

    'file.fileIsImageFalseType' => 'O ficheiro que está a carregar não é uma imagem.',
    'file.fileUploadErrorIniSize' => 'O ficheiro que você está a tentar carregar excede o tamanho ini definido.',
    'file.fileUploadErrorFormSize' => 'O ficheiro que você está a tentar carregar excede o tamanho de formulário definido.',
    'file.fileUploadErrorPartial' => 'O ficheiro foi carregado apenas parcialmente.',
    'file.fileUploadErrorNoFile' => 'O ficheiro não foi carregado.',
    'file.fileUploadErrorNoTmpDir' => 'Nenhum diretório temporário foi encontrado para o ficheiro que está a tentar carregar.',
    'file.fileUploadErrorCantWrite' => 'O ficheiro que você está a tentar carregar não pode ser escrito.',
    'file.fileUploadErrorExtension' => 'A extensão retornou um erro enquanto carregava o ficheiro.',
    'file.fileUploadErrorAttack' => '" O ficheiro foi carregado ilegalmente; pode ser uma tentativa de invasão."',
    'file.fileUploadErrorFileNotFound' => 'O ficheiro que você está a tentar carregar não foi encontrado.',
    'file.fileUploadErrorUnknown' => 'Um erro desconhecido ocorreu ao carregar o ficheiro.',
    'file.fileExtensionFalse' => 'O ficheiro que está a tentar carregar possui uma extensão não permitida.',
    'file.fileExistsDoesNotExist' => 'O ficheiro ou diretório especificado não existe.',

    'hostname.hostnameIpAddressNotAllowed' => "'%value%' parece ser um endereço IP, mas endereços IP não são permitidos.",
    'hostname.hostnameUnknownTld' => "'%value%' parece ser um nome de host de DNS, mas não corresponde a TLD numa lista conhecida",
    'hostname.hostnameDashCharacter' => "'%value%' parece ser um nome de host de DNS, mas tem um traço (-) numa posição inválida.",
    'hostname.hostnameInvalidHostnameSchema' => "'%value%' parece ser um nome de host de DNS, mas não corresponde ao esquema de nome de servidor para TLD '%tld%'",
    'hostname.hostnameUndecipherableTld' => "'%value%' parece ser um nome de host de DNS, mas não pode extrair a parte de TLD",
    'hostname.hostnameInvalidHostname' => "'%value%' não corresponde à estrutura esperada para um nome de host de DNS",
    'hostname.hostnameInvalidLocalName' => "'%value%' não parece ser um nome de rede local válido",
    'hostname.hostnameLocalNameNotAllowed' => "'%value%' parece ser um nome de rede local, mas nomes de rede local não são permitidos.",

    'port.notBetween' => 'O valor de porta especificado é inválido. Devem estar entre 1 e 65535, inclusivamente',

    'dns.invalidSoaValue' => 'O valor é inválido. Pode ser de 1 segundo a 68 anos.',

    'isEmpty' => 'Este campo necessário está vazio. É necessário especificar um valor.',
    'stringLengthTooShort' => "'%value%' é menor que %min% carateres.",
    'stringLengthTooLong' => "'%value%' é maior que %max% carateres.",
    'regexNotMatch' => "'%value%' não corresponde ao padrão '%pattern%'.",
    'notAlnum' => "'%value%' possui carateres que não são alfanuméricos. Certifique-se de que está a utilizar apenas carateres alfanuméricos.",
    'alnumStringEmpty' => "O valor está vazio.",
    'stringEmpty' => "'%value%\\ está vazio.",
    'loginSyntax' => 'Pode utilizar símbolos alfanuméricos, traços (-), pontos (.), aspas simples (‘), percentagens (%) e sublinhados (_) no nome de utilizador. O nome de utilizador deverá ser iniciado com um símbolo alfanumérico.',
    'loginExists' => 'A conta de utilizador %value% já existe.',
    'cu_admin_alias__login_exists' => 'A conta de utilizador já existe.',
    'loginPassword' => 'A palavra-passe não pode conter o nome de utilizador.',
    'passwordSyntax' => 'A palavra-passe contém carateres que não são permitidos.',
    'passwordLength' => 'A palavra-passe deve ter entre %minLength% e %maxLength% caracteres.',
    'domain_invalid_name' => 'O nome de domínio especificado não é válido. É necessário especificar um nome de domínio válido, como domain.com.',
    'dns_domain_invalid_name' => 'O nome de domínio especificado não é válido.',
    'dns_domain_template_invalid_name' => 'O modelo de nome de domínio especificado não é válido.',
    'not_ascii_string' => 'O valor não é uma cadeia ASCII válida.',
    'virtual_directory_name_invalid' => 'Utilize apenas carateres alfanuméricos, traço e sublinhado no nome do diretório.',
    'virtual_directory_name_reserved' => 'Este nome está reservado.',
    'invalid_city_name' => 'O nome da cidade introduzido não é válido',
    'invalid_country_code' => 'Código de país inválido',
    'not_specified_country_code' => 'País é um campo obrigatório, deve ser especificado explicitamente.',
    'invalid_system_user_login' => 'O início de sessão do utilizador no sistema é inválido',
    'invalid_rfc_domain_name' => 'O nome do domínio especificado não é um domínio RFC válido',
    'idn_name_conversion' => 'Falha ao converter o nome do domínio de IDN para Punycode',
    'domain_label_too_long' => 'Nenhuma das partes do nome do domínio pode exceder 63 caracteres de comprimento.',
    'domain_label_too_long_idn' => 'O domínio utiliza um nome de domínio internacionalizado. Nenhuma das partes do seu nome, quando convertido para Punycode, pode exceder 63 caracteres de comprimento.',
    'domain_starts_with_www' => 'Por favor introduza um nome de domínio sem o prefixo \'www\'\\. O prefixo www para o domínio será adicionado automaticamente à configuração do servidor web.',
    'domain_already_exists' => 'Este nome de domínio já existe.',
    'domain_without_www_already_exists' => 'O nome de domínio já existe sem o prefixo \'www\'\\ .',
    'domain_with_www_already_exists' => 'O nome de domínio já existe com o prefixo \'www\'\\.',
    'subdomain_conflicts_with_existing_domain' => 'Existe um domínio com o mesmo nome que o subdomínio \'%value%\'.',
    'restrict_domain_creation' => 'O nome de domínio especificado não é permitido pela política geral do servidor. Se este domínio lhe pertence, entre em contacto com o seu fornecedor de alojamento.',
    'dns_record_already_exists' => 'Este registo DNS já existe.',
    'domain_like_hostname' => 'O nome de domínio é igual ao nome de host do servidor.',
    'passwordsNotMatch' => 'As palavras-passe inseridas não são iguais.',
    'stringsNotEqual' => 'Os valores não são iguais.',
    'equalMailAliases' => 'O apelido do e-mail especificado é igual o outro apelido de e-mail.',
    'mailAliasExist' => 'O apelido de e-mail especificado já existe.',
    'mailNameExist' => 'O endereço de e-mail especificado já existe.',
    'mailListExist' => 'O endereço especificado já está atribuído a uma lista de envio.',
    'mailAutoReplyHeadersSpaceError' => "Os cabeçalhos de resposta automática não podem conter espaços",
    'mailAutoReplyHeadersInvalidValueError' => 'Alguns campos estão vazios ou contêm valores impróprios.',
    'sysUserExist' => 'O nome de utilizador especificado já é utilizado por outro utilizador do sistema. Por favor, introduza outro nome de utilizador.',
    'emailAddressInvalid' => 'O endereço de e-mail especificado não é válido. Especifique um válido que corresponda ao padrão seguinte: johndoe@example.com.',
    'emailAddressInvalidLocal' => 'O endereço de e-mail especificado não é válido. O endereço de e-mail deve pertencer ao domínio selecionado. Apenas o administrador pode especificar endereços de e-mail externos neste caso.',
    'emailAddressSpecialNames' => 'O endereço de e-mail especificado é inválido. A parte do nome de utilizador do endereço não deve começar com um nome de sistema reservado (como con, lpt1, prn) separando o resto do nome de utilizador pelo símbolo ponto (.).',
    'dkimSelectorInvalid' => 'O seletor DKIM não é válido: %value%',
    'longAddress' => 'O endereço de e-mail é demasiado longo.',
    'longMailboxAddressMailServer' => 'A parte do nome de utilizador do endereço de e-mail é demasiado longa para este servidor de correio. Especifique um nome de utilizador com um máximo de %%max%% símbolos.',
    'longFullAddressMailServer' => 'O endereço de e-mail é demasiado longo para este servidor de correio. Especifique um endereço com um máximo de %%max%% símbolos.',
    'dir_invalid_name' => 'Diretório de destino inválido.',
    'directoryHidesDomain' => 'O diretório não pode ser utilizado porque iria sobrepor o site web localizado em %path%. Tal sobreposição faria a página web tornar-se indisponível.',
    'directoryHidesAnotherApplication' => 'O diretório não pode ser utilizado porque iria sobrepor-se a outra aplicação instalada em %path%. Tal sobreposição faria a aplicação instalada tornar-se indisponível.',
    'directoryIsBehindAnotherApplication' => 'Este diretório não pode ser utilizado porque iria sobrepor-se a outra aplicação instalada em %path%. Tal sobreposição faria a aplicação tornar-se indisponível.',
    'domainLoginSyntaxWindows' => 'O nome de utilizador deve começar com um caractere alfabético e não pode exceder %%maxlength%% de comprimento. Todos os caracteres, exceto os iniciais, podem ser alfanuméricos minúsculos, o traço, o ponto e o sublinhado. O nome de utilizador não pode terminar com um ponto.',
    'domainLoginSyntaxUnix' => 'O nome de utilizador não pode ter mais de %%maxlength%% caracteres e deve conter apenas caracteres alfanuméricos minúsculos e os caracteres de traço e sublinhado. O nome de utilizador deve começar por um caractere alfabético minúsculo',
    'notLocalMssqlHost' => 'Não é um nome de anfitrião MSSQL local',
    'invalidMailTo' => 'Não é uma ligação mailto: válida',
    'passwordsNotEqual' => 'As palavras-passe introduzidas não coincidem.',
    'passwordPolicy' => '%policyError%',
    'fileImageSizeWidthTooBig' => "A imagem '%value%' que está a carregar é muito larga ('%width%'). Imagens carregadas não podem ser maiores que '%maxwidth%' de largura.",
    'fileImageSizeWidthTooSmall' => "A imagem '%value%' que está a carregar não é larga o suficiente ('%width%'). Imagens carregadas devem ter pelo menos '%minwidth%' de largura.",
    'fileImageSizeHeightTooBig' => "A altura da imagem '%value%' que está a carregar é muito alta ('%height%'). Imagens carregadas não podem exceder '%maxheight%' de altura.",
    'fileImageSizeHeightTooSmall' => "A altura da imagem '%value%' que está a carregar é muito baixa ('%height%'). Imagens carregadas não podem menores que '%minheight%' de altura.",
    'fileImageSizeNotDetected' => "O tamanho da imagem '%value%' que está a carregar não pode ser detetado.",
    'fileImageSizeNotReadable' => "A imagem '%value%' que está a carregar não pode ser lida.",
    'passwordConfirmation' => 'Confirmar a palavra-passe',
    'databaseUserNameExists' => 'Já existe um nome de utilizador da base de dados com o nome %value%.',
    'invalidUserName' => 'O nome de utilizador de base de dados contém carateres não permitidos.',
    'longUserName' => 'O nome de utilizador da base de dados excede os %%max%% caracteres.',
    'forbiddenName' => 'O nome de utilizador da base de dados "%value%" não é permitido.',
    'invalidAdminLogin' => 'Impossível utilizar as credenciais do utilizador selecionadas para o acesso de administrador. O nome de utilizador especificado não é válido: %%cause%%',
    'invalidAdminPassword' => 'Impossível utilizar as credenciais do utilizador selecionadas para o acesso de administrador. A palavra-passe especificada não é válida: %%cause%%',
    'passwordLengthTooShort' => "a palavra-passe é menor do que %min% carateres.",
    'passwordLengthTooLong' => "a palavra-passe é maior do que %max% carateres.",
    'passwordRegexNotMatch' => "a palavra-passe não corresponde ao padrão '%pattern%'.",
    'fileSharingEmptyFolderName' => "É necessário especificar um nome de pasta.",
    'fileSharingInvalidFolderName' => "O nome de pasta especificado não é válido. Não pode conter qualquer um dos seguintes carateres: \\ / : * ? \" < > |",
    'fileSharingFolderExists' => "Não é possível criar uma pasta com o nome especificado porque já existe uma pasta com o mesmo nome.",
    'invalidUrl' => 'O endereço especificado não é válido. É necessário especificar um endereço válido, como http://domain.com.',
    'domainVirtualdirectoryReservedName' => 'Este nome de diretório está reservado. Por favor, introduza outro nome para o seu diretório virtual.',
    'domainVirtualdirectoryInvalidName' => 'Um nome de diretório deve conter apenas carateres alfanuméricos, sublinhados e traço.',
    'filesharingPathUnavailable' => 'Um diretório com este nome já existe no domínio especificado. Por favor, utilize outro nome de diretório.',
    'filesharingSslNotAvailableOnDomain' => 'Foi selecionada a utilização de botões seguros, mas o domínio não tem um SSL/TLS ativado. Por favor, selecione um domínio com suporte ao SSL/TLS, ou não selecione a caixa de verificação Gerar botões seguros.',
    'filesharingSslRedirectOnDomain' => 'O domínio selecionado tem a opção "Permanent SEO-safe 301 redirect from HTTP to HTTPS" ativada. Para configurar a partilha de ficheiros, selecione um domínio que tenha essa opção desativada ou assinale a caixa de seleção "Gerar hiperligações seguras para ficheiros e pastas".',
    'filesharingSslNotAvailableOnDefaultDomain' => 'Foi selecionada a utilização de botões seguros no endereço IP ou nome de host do servidor, mas tais botões só podem ser criados em páginas web com suporte ao SSL/TLS. Por favor, configure um site web com suporte ao SSL/TLS, ou não selecione a caixa de verificação Gerar botões seguros.',
    'filesharingDefaultDomainSelectedOnServerIp' => 'Foi selecionado o endereço IP do servidor para o qual um domínio predefinido é atribuído. Por favor, selecione um site web como URL raiz ao invés de endereço IP.',
    'physicalPathOnDomainAlreadyExists' => 'Já existe um diretório com esse nome.',
    'virtualPathOnDomainAlreadyExists' => 'Já existe um diretório com esse nome.',
    'sysUserLoginSyntaxWindows' => 'Você pode usar símbolos alfanuméricos, hífen (-), ponto (.) e sublinhado (_) no nome do utilizador. O nome de utilizador deve começar com um símbolo alfanumérico.',
    'sysUserLoginSyntaxUnix' => 'Você pode usar símbolos alfanuméricos minúsculos, hífen (-), ponto (.) e sublinhado (_) no nome do utilizador. O nome de utilizador deve começar com um símbolo alfanumérico.',
    'docrootNotInWebspaceRoot' => 'O diretório definido não está localizado no diretório de raiz da assinatura.',
    'docrootContainsSpecialCharacters' => 'O nome do diretório especificado contém símbolos que não podem ser utilizados.',
    'docrootWithinProhibitedDirectory' => 'O diretório especificado contém um diretório de serviço.',
    'docrootWithinInstalledApplication' => 'O diretório especificado é sobreposto por uma aplicação web instalada em %path%.',
    'docrootIsNotDirectory' => 'Não é possível usar o caminho especificado porque a sua parte refere-se a um ficheiro.',
    'docrootTooLongPart' => 'O nome do diretório especificado é muito longo.',
    'subdomainWrongName' => '%errorDescription%',
    'subdomainWrongDomain' => 'O domínio incorreto foi selecionado.',
    'domainAliasWrongName' => '%errorDescription%',
    'phoneRegexNotMatch' => 'Foi especificado um número de telefone incorreto, continha símbolos não permitidos.',
    'stateInvalid' => 'Foi especificado o estado ou província incorreto.',
    'zipRegexNotMatch' => 'Foi especificado o CEP ou caixa postal incorreto.',
    'limitValueInvalid' => 'O limite especificado é inválido.',
    'softLimitValueInvalid' => 'O valor deve situar-se no intervalo %%MIN%%..%%MAX%%.',
    'outgoingMessagesLimitValueInvalid' => 'O valor deve situar-se no intervalo %%MIN%%..%%MAX%%. Apenas o administrador Plesk pode ajustar essa configuração.',
    'limitMssqlDatabaseFileSizeValueInvalid' => 'O tamanho de um ficheiro da base de dados MS SQL deve ser um número inteiro entre 0 e 16 TB.',
    'limitMssqlDatabaseLogFileSizeValueInvalid' => 'O tamanho de um ficheiro de registo da base de dados MS SQL deve ser um número inteiro entre 0 e 2 TB.',
    'limitDiskspaceValueInvalid' => 'O limite de espaço de disco deve ser um número inteiro entre 0 e 4095 TB.',
    'limitTrafficValueInvalid' => 'O limite de tráfego deve ser um número inteiro entre 0 e 4095 TB/mês.',
    'limitMboxQuotaValueInvalid' => 'O limite de tamanho da caixa de correio deve ser um número inteiro entre 0 e 4095 TB.',
    'limitRetainPeriodValueInvalid' => 'O valor de "Manter estatísticas de rede e de tráfego" nos planos de serviços não pode ser menor do que o valor de "Manter estatísticas de rede e de tráfego" em Ferramentas e configurações> Configurações do servidor. Especifique um número inteiro maior ou igual a %%MIN%% e menor do que %%MAX%%.',
    'limitValueOverused' => 'A quantidade de recursos atualmente utilizada excede o valor de limite especificado. Não pode especificar um valor menor que %%used%%',
    'limitValueOverselled' => 'O limite de utilização de recursos do %%reserved%% já está atribuído para assinaturas. Não pode especificar um valor menor que %%reserved%%',
    'lessThan' => "'%value%' é menor que '%min%'",
    'greaterThan' => "'%value%' é maior que '%max%'",
    'greaterThanDiskQuota' => "%value% é maior do que a quota de disco (%max%)",
    'notDigits' => 'O valor deve ser um número inteiro.',
    'digitsInvalid' => 'O valor deve ser um número inteiro.',
    'digitsStringEmpty' => 'O valor deve ser um número inteiro.',
    'isEqual' => "O valor não pode ser igual a '%invalidValue%'.",
    'notInt' => 'O valor deve ser um número inteiro.',
    'maillistNameInvalid' => 'O endereço de lista de envio especificado não é válido.',
    'maillistReservedNameAlreadyExists' => 'O endereço especificado já está reservado.',
    'maillistAlreadyExists' => 'O endereço especificado já é utilizado por uma lista de envio.',
    'maillistAlreadyExistsOnServer' => 'O nome especificado de lista de envio já é utilizado por outra assinatura',
    'mailnameAlreadyExists' => 'O endereço de e-mail especificado já existe.',
    'mailaliasAlreadyExists' => 'O endereço especificado já é utilizado por um nome alternativo de e-mail.',
    'autoresponderEndDateIsInvalid' => 'A data especificada deve encontrar-se no futuro.',
    'mailPostboxLimit' => '%message%',
    'userEmailLimitExceeded' => '%limitManagerMessage%',

    'zxcvbnEstimator.passwordStrength' => 'A sua palavra-passe não é suficientemente complexa. De acordo com a política do servidor, a força da palavra-passe mínima é %strength%.',
    'zxcvbnEstimator.passwordStrengthVeryWeak' => 'Muito fraca (não é recomendada)',
    'zxcvbnEstimator.passwordStrengthWeak' => 'Fraca (não é recomendada)',
    'zxcvbnEstimator.passwordStrengthMediocre' => 'Média',
    'zxcvbnEstimator.passwordStrengthStrong' => 'Forte (recomendada)',
    'zxcvbnEstimator.passwordStrengthStronger' => 'Muito forte',
    'zxcvbnEstimator.passwordStrengthVeryWeakHint' => 'Pode ser descoberta facilmente através de força bruta. Vulnerável a "credential stuffing" e ataques por dicionário.',
    'zxcvbnEstimator.passwordStrengthWeakHint' => 'Não pode ser descoberta facilmente através de força bruta. Menos vulnerável a "credential stuffing" e ataques por dicionário.',
    'zxcvbnEstimator.passwordStrengthMediocreHint' => 'Pode ser descoberta através de força bruta.',
    'zxcvbnEstimator.passwordStrengthStrongHint' => 'Dificilmente descoberta através de força bruta. Alguma proteção contra ataques offline.',
    'zxcvbnEstimator.passwordStrengthStrongerHint' => 'Pouco prática de descobrir através de força bruta. Proteção razoável contra ataques offline.',

    'emailCantBeRenamed' => "O servidor não suporta a renomeação das contas de correio.",
    'emailOwnedByAnotherUser' => "Este endereço de e-mail é de propriedade de outro utilizador.",
    'maillistAdminEmailShouldExistsOnDomain' => 'O endereço de e-mail do administrador de lista de mailing deve ser registado no mesmo domínio da lista de mailing.',
    'webmailExists' => "O serviço de webmail '%value%' já existe.",
    'invalidDbName' => 'O nome da base de dados pode conter unicamente símbolos alfanuméricos, pontos, traços e sublinhados.',
    'longDbName' => 'O nome de base de dados é muito longo.',
    'dbNameClash' => 'O nome da base de dados e o nome de utilizador da base de dados devem ser diferentes.',
    'dbConnectFailed' => 'Impossível ligar ao servidor de base de dados. Por favor, verifique as credenciais de utilizador de base de dados e as restrições de acesso.',
    'databaseNameAlreadyExists' => 'Já existe uma base de dados com o nome %value%.',
    'wrongUrlSyntax' => 'O endereço especificado não é válido. É necessário especificar um endereço válido, como http://domain.com, relative/path ou mailto:address.',
    'connectionRefused' => 'Ligação recusada.',
    'loginIncorrect' => 'Nome de utilizador incorreto',
    'failedToChangeDirectory' => 'O diretório não existe',
    'failedToChangeMode' => 'Falha na alteração do modo',
    'failedToCreateDirectory' => 'A criação de ficheiros não é permitida',
    'failedToRenameDirectory' => 'A renomeação de ficheiros não é permitida',
    'failedToDeleteDirectory' => 'A eliminação de ficheiros não é permitida',
    'ipInvalid' => "'%value%' parece não ser um endereço IP válido ou pertence ao tipo errado.",
    'ipv6IsNotGlobal' => "'%value%' is not a global IP address.",
    'ipMaskInvalid' => "'%value%' não parece ser uma máscara de endereço IP válida.",
    'ipInvalidForInterface' => 'O endereço IP especificado não pode ser utilizado na interface de rede. É necessário especificar um endereço IP válido com intervalo ou máscara de prefixo de sub-rede.',
    'ipInvalidForInterfaceIpv6NotAvailable' => 'O endereço IP especificado não pode ser utilizado na interface de rede selecionada porque o suporte ao IPv6 é desligado para esta interface.',
    'ipAlreadyExists' => 'Endereço IP %value% já existe.',
    'notInArray' => 'Esta opção não é suportada.',
    'ipAddressIsNotSelected' => 'Pelo menos um endereço IP deve ser selecionado.',
    'noServiceNodeSpecified' => 'Erro interno: não foi especificado um nó de serviço.',
    'serviceNodeInvalidName' => 'Nome de nó de serviço inválido "%value%".',
    'serviceNodeNameAlreadyExists' => 'O nó de serviço com o nome "%value%" já existe.',
    'serviceNodeIpUsed' => "Impossível remover o nó de serviço: o endereço IP está registado.",
    'serviceNodeIpAddressAlreadyExists' => 'O nó de serviço com o endereço IP "%value%" já existe.',
    'serviceNodeInvalidTransport' => 'Nome de transporte inválido "%value%".',
    'app_non_unique_setting_value' => 'Outro objeto tem o mesmo valor de configuração. Esta configuração deve ser única à este objeto.',
    'wrongLocalUrlSyntax' => 'O endereço especificado é inválido. Por favor, introduza um endereço local válido, como /smb/web/view.',
    'phpIsapiHandlerTypeNotSupported' => 'O tipo de manipulador ISAPI não é suportado pela versão atual de PHP.',
    'dbNameNotExist' => 'A base de dados especificada não existe.',
    'invalidBooleanValue' => 'Os valores permitidos são "true" ou "false".',
    'invalidMimeType' => 'O tipo MIME especificado é inválido: "%value%".',
    'invalidHeaders' => 'O cabeçalho especificado é inválido: "%value%".',
    'invalidHandler' => 'O manipulador especificado é inválido: "%value%".',
    'invalidAllowDeny' => 'A diretiva de Permitir/Negar especificada é inválida: "%value%".',
    'nonUniqueAllowDeny' => 'O valor especificado para a diretiva de Permitir/Negar já existe: "%value%".',
    'maxItemsCountExeededAllowDeny' => 'O número de endereços IP na lista deve ser inferior ou igual a %value%.',
    'invalidDirectoryIndex' => 'O ficheiro de índice do diretório raiz selecionado é inválido.',
    'invalidNginxProxyMode' => 'O valor especificado para a propriedade nginxProxyMode é inválido. Os valores permitidos são "true" ou "false".',
    'invalidNginxTransparentMode' => 'O valor especificado para a propriedade nginxTransparentMode é inválido. Os valores permitidos são "true" ou "false".',
    'invalidNginxServeStatic' => 'O valor especificado para a propriedade nginxServeStatic é inválido. Os valores permitidos são "true" ou "false".',
    'invalidStaticFilesExtensions' => 'As extensões dos ficheiros estáticos especificados são inválidos: "%value%".',
    'invalidNginxServePhp' => 'O valor especificado para a propriedade nginxServePhp é inválido. Os valores permitidos são "true" ou "false".',
    'invalidDocuments' => 'O nome de documento não deve conter vírgulas (",").',
    'duplicateDocuments' => 'Os seguintes documentos já existem na lista de documentos predefinidos: "%value%"',
    'protected_directory_invalid_name' => 'Nome de directório protegido é inválido.',
    'protected_directory_invalid_login' => 'O login de um utilizador de diretório protegido por palavra-passe não deve ser maior que 20 carateres alfanuméricos. O login também pode ter o símbolo traço ("-"), mas não pode começar com ele.',
    'notARelativePath' => 'O caminho deve ser relativo',
    'cannotUseJunctions' => 'Não é possível utilizar junções fora do webspace como diretório temporário para compilação',
    'notBetween' => '"%value%" não está entre "%min%" e "%max%", inclusivamente',
    'notBetweenStrict' => '"%value%" não está entre estritamente "%min%" e "%max%"',
    'redirectToMyself' => 'A página web não pode redirecionar para si próprio. Insira o endereço de destino diferente do URL do site principal.',
    'redirectToAlias' => 'A página web não pode ser redirecionada para o seu nomes alternativos. Insira o endereço de destino diferente do endereço do nome alternativo do site principal.',
    'relativePathInvalid' => 'O caminho especificado é inválido.',
    'aspDotNetSettingsInvalid' => 'Um ou mais dos valores especificados para as configurações do ASP.NET são inválidos.',
    'mboxOutgoingMessagesLimitValueInvalid' => '" O valor do limite de mensagens enviadas por uma caixa de mensagens deve ser superior a ""%%MIN%%""."',
    'domainOutgoingMessagesLimitValueInvalid' => '" O valor do limite de mensagens enviadas por um domínio deve ser superiores a""%%MIN%%""."',
    'subscriptionOutgoingMessagesLimitValueInvalid' => '" O valor do limite de mensagens enviadas por uma assinatura deve ser superior a ""%%MIN%%""."',
    'iisAuthNotEnabled' => 'A autenticação anónima ou do Windows precisa ser ativada nas configurações do servidor web para o domínio.',
    'mboxOutgoingMessagesLimitValueInvalidDigit' => 'O valor do limite de mensagens enviadas para a caixa de correio deve ser um número inteiro positivo ou \'por defeito\'. Também pode ser \'-1\' para o valor \'Ilimitado\'.',
    'domainOutgoingMessagesLimitValueInvalidDigit' => 'O valor do limite de mensagens enviadas para um domínio deve ser um número inteiro positivo ou \'por defeito\'. Também pode ser \'-1\' para o valor \'Ilimitado\'.',
    'subscriptionOutgoingMessagesLimitValueInvalidDigit' => 'O valor do limite de mensagens enviadas para uma assinatura deve ser um número inteiro positivo ou \'por defeito\'. Também pode ser \'-1\' para o valor \'Ilimitado\'.',
    'outgoingMessagesReportPeriodValueInvalid' => 'O valor especificado para o período de referência não é suportado.',
    'outgoingMessagesNotificationPeriodValueInvalid' => 'O valor especificado para o período de notificação não é suportado.',
    'textItemsListInvalid' => '" O item especificado é inválido: ""%value%""."',
    'textItemsListInvalidMulti' => 'Os elementos especificados são inválidos: "%value%".',
    'textItemsListNonUnique' => '" O valor especificado já existe: ""%value%""."',
    'textItemsListMaxItemsCountExeeded' => 'O número de itens não deve exceder %value%.',
    'invalidAcl' => '" O endereço especificado é inválido: ""%value%""."',
    'nonUniqueAcl' => '" O valor especificado para o host já existe: ""%value%""."',
    'httpInvalidStatusFormat' => 'Os códigos de estado devem ser números no formato 400 ou 400.1',
    'httpInvalidStatusCode' => 'Os códigos de estado devem estar entre %%minCode%% e %%maxCode%%',
    'httpInvalidStatusSubCode' => 'Os códigos de subestado devem estar entre %%minSubCode%% e %%maxSubCode%%',
    'httpInvalidStatusRange' => 'Os intervalos de estado devem definir um intervalo de um valor mínimo a um valor máximo',
    'phpSettingValueByteRegexNotMatch' => 'Foi definido um valor incorreto. Introduza um valor inteiro e um caratere de abreviatura (K para kilobyte, M para megabyte, G para gigabyte, por exemplo, 128M)',
    'phpFpmServersAmountNotPositive' => "O valor deve ser um número positivo.",
    'phpFpmServersAmountLessThan' => "'%value%' é menor do que '%%min%%' (%%field%%)",
    'phpFpmServersAmountGreaterThan' => "'%value%' é maior do que '%%max%%' (%%field%%)",
    'phpInvalidIniSyntax' => "Sintaxe INI inválida detetada na linha %%line%%: '%%text%%'",
    'portRangeInvalid' => 'O intervalo de portas especificado é inválido. O valor esquerdo deve ser menor do que o direito.',
    'portRangeValueInvalid' => 'O valor %value% no intervalo de porta é inválido. Deve ser entre %min% - %max%.',
    'domainResolvesToAnotherIp' => 'O domínio resolve-se para o endereço de IP incorreto (%value%). Para colocar o seu website online, corrija %%dnsSettingsLink%%.',
    'domainNotResolved' => 'Não é possível resolver o domínio. Para colocar o seu website online, corrija %%dnsSettingsLink%%.',
    'dnsSettingsLink' => 'Definições de DNS',
    'backupRotationSingleValueInvalid' => 'O limite foi ultrapassado.',
    'backupRotationMultipleValueInvalid' => 'O limite foi ultrapassado por todas as cópias de segurança agendadas para o armazenamento local: %%details%%.',
    'backupRotationDetail' => '{count, plural, one {# cópia de segurança do tipo {type} } other {# cópias de segurança do tipo {type}}}',
    'backupRotationTypeHourly' => 'intervalo de horas',
    'backupRotationTypeDaily' => 'diariamente',
    'backupRotationTypeWeekly' => 'semanalmente',
    'backupRotationTypeMonthly' => 'mensalmente',

    'backupPathInvalidCharacters' => '"%value%" contém carateres inválidos.',
    'backupPathInvalidDot' => '"%value%" contém um caminho inválido "." ou "..".',
    'networkAccessAlreadyExists' => 'A rede já está na lista de restrições de acesso IP.',
    'codeRegexNotMatch' => 'O código de ativação não é válido.',
    'nameUsedForPlesk' => 'Impossível criar o domínio porque o seu nome é encontrado no URL que utilizou para iniciar sessão no Plesk. Para criar o domínio, inicie sessão no Plesk em https://%value%:8443 ou https://plesk.%value%.',
    'invalidNameDirectory' => 'O nome especificado é inválido.',
    'invalidPasswordCharacters' => 'A palavra-passe não pode conter aspas, espaços ou caracteres nacionais.',
    'invalidPasswordLength' => 'A palavra-passe deve ter entre %%min%%-%%max%% caracteres de comprimento.',
    'passwordContainsLogin' => 'A palavra-passe não deve conter o login.',

    'invalidPhpExtensionName' => 'O nome da extensão é inválido.',
    'hexStringNotMatch' => 'Os valores indicados não parecem ser uma cadeia hexadecimal válida.',
    'invalidCertificateData' => 'O valor indicado não parece ser um dado de certificado válido.',
    'invalidSha256Hash' => 'O valor indicado não parece ser um hash SHA-256 válido.',
    'invalidSha512Hash' => 'O valor indicado não parece ser um hash SHA-512 válido.',
    'invalidTlsaMatchingType' => 'Foi facultado um tipo inválido de correspondência TLSA.',
];