<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Installerar %%name%% i %%path%%...',
    'aps-install.queueNoPath' => 'Installerar %%name%%...',
    'aps-install.done' => '%%name%% har installerats på %%path%%. Du kan se dina autentiseringsuppgifter för att logga in på applikationen nedan. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% installerades korrekt. Du kan se dina autentiseringsuppgifter för att logga in på applikationen nedan. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% har installerats på %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% installerades korrekt. %%additionalMessage%%',
    'aps-install.error' => 'Installationen av %%name%% på %%path%% misslyckades. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Installationen av %%name%% misslyckades. %%errorMessage%%',

    'aps-update.queueDownload' => 'Nedladdning %%packageName%%...',
    'aps-update.errorDownload' => 'Nerladdningen av %%packageName%% misslyckades:',
    'aps-update.queueInstall' => 'Uppdaterar en installation av %%name%% for %%domainName%%...',
    'aps-update.doneInstall' => 'Installationen av %%name%% för %%domainName%% uppdaterades korrekt.',
    'aps-update.errorInstall' => 'Uppdaterar en installation av %%name%% för %%domainName%% misslyckades:',
    'aps-update.queueInstallMulti' => 'Uppdaterar %%instances%% installationer av %%name%%…',
    'aps-update.doneInstallMulti' => '%%successes%% installationer av %%name%% uppdaterades korrekt.',
    'aps-update.errorInstallMulti' => 'Uppdateringen av %%failures%% installationer av %%name%% misslyckades:',
    'aps-update.incorrectUpdateInformation' => 'Uppdateringsinformationen är felaktig.',

    'common.hideCompletedTasks' => 'gömmande klart',
    'common.progressBarHide' => 'Dölj',
    'common.progressBarShow' => 'Visa',
    'common.close' => 'Stäng',
    'common.refresh' => 'Uppdatera sidan',
    'common.taskInProgress' => '%%count%% uppgifter pågår...',
    'common.percentCompleted' => '%%percent%%% färdigt',
    'common.allTasksCompleted' => 'Alla %%num%% uppgifter har slutförts korrekt.',
    'common.minimize' => 'Minimera',
    'common.statusDone' => 'Klart',
    'common.statusError' => 'Misslyckad',
    'common.statusNotStarted' => 'Köad',
    'common.statusCanceled' => 'Annullerad',
    'common.progressDialogLink' => 'Detaljerat förlopp',

    'database-check.queue' => 'Kontroll av %%database%% databastabellerna…',
    'database-check.done' => '%%database%% databasen har inte några fel.',
    'database-check.error' => 'Kan inte kontrollera %%database%% databasen för fel.',
    'database-check.done-with-errors' => "%%database%% databasen har %%number%% problem. \n %%link%%",
    'database-check.info-link-title' => 'Se detaljerna och lös uppgifterna',

    'database-download.queue' => 'Förbereder en %%database%%-dump för export...',
    'database-download.done' => 'Dumpen av %%database%% är klar. Du kan %%downloadLink%% den.',
    'database-download.downloadLink' => 'nedladdning',
    'database-download.error' => 'Kan inte exportera en dump av %%database%%:',

    'database-repair.queue' => 'Reparation av %%database%% databastabeller…',
    'database-repair.done' => '%%database%% databasen har inte några fel.',
    'database-repair.error' => 'Kan inte reparera %%database%% dumpen.',
    'database-repair.done-with-errors' => "%%database%% databasen har %%number%% problem. \n %%link%%",
    'database-repair.info-link-title' => 'Visa Detaljer',

    'database-upload.queue' => 'Importerar en dump av %%database%%...',
    'database-upload.done' => 'Dumpen av %%database%% importerades.',
    'database-upload.error' => 'Kan inte importera en dump%%database%%:',
    'database-upload.done-with-errors' => "Dumpen av %%database%% importerades med fel.",
    'database-upload.orphanedUsersSuccess' => 'Databasen %%database%% importerades korrekt. Men vissa användare blir föräldralösa (de har inga associerade inloggningar till databasservern). För att komma åt dina databaser, tilldela inloggningar till dessa användare. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Följande användare blir föräldralösa (de har inga associerade inloggningar till databasservern): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Visa användare',

    'domain-app-scan.queue' => 'Skannar efter applikationer...',
    'domain-app-scan.done' => 'Skanningen efter applikationer slutfördes.',
    'domain-app-scan.error' => 'Skanningen efter applikationer avslutades med fel.',

    'domain-move.queue' => 'Flyttar %%domainName%% till %%webspaceName%%',
    'domain-move.done' => '%%domainName%% flyttades till %%webspaceName%%',
    'domain-move.error' => '%%domainName%% flyttades inte till %%webspaceName%%',

    'domain-split.queue' => 'Flyttar %%domainName%% till en ny prenumeration',
    'domain-split.done' => '%%domainName%% flyttades till en ny prenumeration',
    'domain-split.error' => '%%domainName%% flyttades inte till en ny prenumeration',

    'file-manager-import-file.done' => 'Filen %%fileName%% har importerats till <a href="%%listUrl%%">mappen %%fileDir%%</a>.',
    'file-manager-import-file.error' => 'Kan inte importera filen %%fileName%%: %%errorMessage%%.<br><a href="%%url%%">Ladda ner till min dator</a>',
    'file-manager-import-file.queue' => 'Importerar filen %%fileName%% från %%host%%.',
    'file-manager-import-file.progress' => 'Importerar filen %%fileName%% från %%host%% (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'Ett autentiseringsfel inträffade. Se till att du anger rätt användarnamn och lösenord',
    'file-manager-import-file.errors.resolve' => 'Kunde inte koppla värdnamnet %%host%%. Se till att du anger rätt URL',
    'file-manager-import-file.errors.connect' => 'Kunde inte ansluta till servern %%host%%. Se till att du anger rätt URL',
    'file-manager-import-file.errors.notFound' => 'Fjärrfilen hittades inte eller är inte tillgänglig. Se till att du anger rätt URL och att filen är åtkomlig',
    'file-manager-import-file.errors.maxSize' => 'Gränsen för diskutrymme eller det lediga utrymmet %%diskSpaceLimit%% har överskridits',
    'file-manager-import-file.errors.lowSpeedTime' => 'Kunde inte importera filen eftersom överföringshastigheten var för långsam: mindre än %%lowSpeedLimit%% bytes överfördes under de senaste %%lowSpeedTime%% sekunderna. Webbplatsen filen ligger på kanske upplever mycket trafik för stunden. Försök att importera filen senare',
    'file-manager-import-file.errors.certificate' => 'Kunde inte importera filen eftersom SSL/TLS-certifikatet hos servern %%host%% inte är pålitligt. Se till att webbplatsen som filen ligger på är säkrad med ett pålitligt certifikat',
    'file-manager-import-file.errors.redirects' => 'Maxantalet omdirigeringar (%%maxRedirects%%) har överskridits. Se till att servern %%host%% fungerar som den ska',

    'force-log-rotation.queue' => 'Applicerar globala loggrotationsinställningar',
    'force-log-rotation.done' => 'Globala loggrotationsinställningar har applicerats.',
    'force-log-rotation.error' => 'Appliceringen av den globala loggrotationen har avslutats med fel',
    'force-log-rotation.systemLogRotationError' => 'Systemloggar: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Tjänsteplan %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domän %%name%%: %%error%%',

    'initial-setup.queue' => 'Initierar Plesk...',
    'initial-setup.done' => 'Plesk har initierats',
    'initial-setup.doneWithErrors' => 'Ett fel inträffade under initieringen av Plesk.',
    'initial-setup.error' => 'Initieringen av Plesk misslyckades.',
    'initial-setup.step.setupPanel' => 'Upprättande av Plesk Panel',
    'initial-setup.step.requestLicense' => 'Begära licens',
    'initial-setup.step.configureServer' => 'Konfigurera webbserver',
    'initial-setup.step.secureServer' => 'Säkra servern',

    'ip-update.queue' => 'Uppdatera IP-adress',
    'ip-update.done' => 'IP-adress uppdaterad.',
    'ip-update.error' => 'IP-adressens uppdatering avslutades med fel',
    'ip-update.updating' => 'Uppdatera IP-adress',
    'ip-update.updatingWebServer' => 'Uppdatera IP-adress: uppdatera webbservern',
    'ip-update.updatingFtpServer' => 'Uppdatera IP-adress: uppdatera FTP-servern',
    'ip-update.updatingDnsZones' => 'Uppdatera IP-adress: uppdatera DNS-zoner',
    'ip-update.restartingDnsService' => 'Uppdatera IP-adress: starta om DNS-server',

    'ip-reload-public.queue' => 'Uppdaterar publika IP-adresser med metadata i molnet',
    'ip-reload-public.done' => 'Publika IP-adresser uppdaterades',

    'logrotate_anonymize_ips.queue' => 'Anonymisera IP-adresser i loggar',
    'logrotate_anonymize_ips.queueRevert' => 'Avanonymisera IP-adresser i loggar',
    'logrotate_anonymize_ips.done' => 'IP-adresserna har anonymiserats.',
    'logrotate_anonymize_ips.doneRevert' => 'IP-adresserna har avanonymiserats.',
    'logrotate_anonymize_ips.error' => 'IP-adressens anonymisering avslutades med fel',
    'logrotate_anonymize_ips.errorRevert' => 'IP-adressens avanonymisering avslutades med fel',

    'panel-components-install.queue' => 'Installera de valda komponenterna.',
    'panel-components-install.done' => 'De valda komponenterna har installerats.',
    'panel-components-install.error' => 'Det gick inte att installera komponenterna. Meddelandet med felbeskrivningen skickades till din e-postadress.',

    'panel-update.queue' => 'Plesk installerar uppdateringar. Detta kan ta lite tid. %%warning%%',
    'panel-update.warning' => 'Gör inga hanteringsåtgärder i Plesk förrän uppdateringen är klar.',
    'panel-update.done' => 'Plesk uppdaterades. Se mer information i %%changelog%%.',
    'panel-update.changelog' => 'Plesks förändringslogg',
    'panel-update.error' => 'Kunde inte uppdatera Plesk. %%errorDetails%%',
    'panel-update.support' => 'För att lösa detta problem kan du skicka uppdateringsloggen till Plesks support. %%failedLog%% Kopiera loggen till datorn innan du stänger det här meddelandet.',
    'panel-update.failedLog' => 'Visa uppdateringsloggen från %%date%%.',

    'pum-update-packages.queue' => 'Uppdaterar %%count%% paket...',
    'pum-update-packages.done' => '%%count%% paketen har uppdaterats korrekt.',
    'pum-update-packages.error' => 'Uppdateringen misslyckades.',

    'scheduler-run-task.queue' => 'Kör uppgiften &quot;%%task%%&quot;...',
    'scheduler-run-task.done' => 'Uppgiften "%%task%%" har slutförts på %%seconds%% sekunder.',
    'scheduler-run-task.error' => 'Uppgiften "%%task%%" har slutförts med fel på %%seconds%% sekunder.',
    'scheduler-run-task.popupSeeDetails' => 'Visa Detaljer',
    'scheduler-run-task.popupTitle' => 'Kör schemalagd uppgift',
    'scheduler-run-task.popupDone' => 'Uppgiften "%%task%%" har slutförts på %%seconds%% sekunder, resultat:',
    'scheduler-run-task.popupError' => 'Uppgiften "%%task%%" har slutförts med fel på %%seconds%% sekunder, resultat:',
    'scheduler-run-task.popupClose' => 'Stäng',

    'sdk.queue' => 'Uppgiften "%%name%%" pågår...',
    'sdk.error' => 'Uppgiften "%%name%%" har misslyckats.',
    'sdk.done' => 'Uppgiften "%%name%%" har avslutats.',
    'sdk.canceled' => 'Uppgiften "%%name%%" har avbrutits.',

    'sync-php-settings.queue' => 'Tillämpar globala PHP %%version%%-inställningar på domäner',
    'sync-php-settings.done' => 'Globala PHP %%version%%-inställningar tillämpades på domänerna',
    'sync-php-settings.error' => 'Ett fel inträffade när globala PHP %%version%%-inställningar tillämpades på domäner',

    'sync-service-plan.queue' => 'Synkar tjänstplan %%name%% med prenumerationer',
    'sync-service-plan.done' => 'Tjänsteplan %%name%% synkades med prenumerationer',
    'sync-service-plan.doneWithErrors' => 'Synkningen av tjänsteplanen %%name%% slutfördes. Vissa prenumerationer synkades inte med planen',
    'sync-service-plan.error' => 'Ett fel inträffade vid synkning av tjänsteplan %%name%% med prenumerationer',

    'domain-create.queue' => 'Skapar domänen %%domainName%%',
    'domain-create.done' => 'Domänen %%domainName%% skapas',
    'domain-create.error' => 'Skapandet av domänen %%domainName%% misslyckades',
    'domain-create.warning' => 'Domänen %%domainName%% skapades med vissa problem:<br> %%problems%%',
    'domain-create.refreshUrl' => 'Visa',
    'domain-create.steps.createCustomer' => 'Skapar kund',
    'domain-create.steps.createSubscription' => 'Skapar en prenumeration',
    'domain-create.steps.createDomain' => 'Lägger till en domän',
    'domain-create.steps.configureDns' => 'Konfigurerar DNS-zonen',
    'domain-create.steps.createHosting' => 'Skapar fysisk hosting',
    'domain-create.steps.configurePhp' => 'Konfigurerar PHP',
    'domain-create.steps.configureMail' => 'Konfigurerar e-post',

    'domain-delete.queue' => 'Radering av domäner bearbetas',
    'domain-delete.done' => 'Domäner raderade',
    'domain-delete.error' => 'Kunde inte radera domäner',
    'domain-delete.step.domains' => 'Raderar domäner…',

    'domain-resolve-checking.warning' => 'Problem med domänlösning för %%domainName%% upptäckta: <br> %%errors%%',

    'customer-create.queue' => 'Skapandet av kunden %%customerName%% bearbetas',
    'customer-create.done' => 'Kunden %%customerName%% har skapats',
    'customer-create.error' => 'Skapande av kunden %%customerName%% misslyckades',
    'customer-create.warning' => 'Kunden %%customerName%% skapades med vissa problem:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Du kan testa att synkronisera den manuellt.',

    'customer-delete.queue' => 'Radering av kunder bearbetas',
    'customer-delete.done' => 'Kunder raderade',
    'customer-delete.error' => 'Kunde inte radera kunder',

    'reseller-delete.queue' => 'Radering av återförsäljare bearbetas',
    'reseller-delete.done' => 'Återförsäljare raderade',
    'reseller-delete.error' => 'Kunde inte radera återförsäljare',

    'subscription-create.queue' => 'Skapandet av prenumerationen %%subscriptionName%% bearbetas',
    'subscription-create.done' => 'Prenumerationen %%subscriptionName%% skapades',
    'subscription-create.error' => 'Skapandet av prenumerationen %%subscriptionName%% misslyckades',
    'subscription-create.warning' => 'Prenumerationen %%subscriptionName%% skapades med vissa problem:<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Du kan testa att synkronisera den manuellt.',

    'subscription-delete.queue' => 'Radering av prenumerationer bearbetas',
    'subscription-delete.done' => 'Prenumerationer raderade',
    'subscription-delete.error' => 'Kunde inte radera prenumerationer',

    'websites-diagnostic.queue' => 'Kör webbplatsdiagnostik',
    'websites-diagnostic.done' => 'Webbplatsdiagnostik är klar',
    'websites-diagnostic.error' => 'Webbplatsdiagnostik är klar med fel',

    'install-php-extension.queue' => 'Installerar paketet %%extensionName%% på PHP-hanteraren %%phpHandlerName%%',
    'install-php-extension.done' => 'Paketet %%extensionName%% installerades på PHP-hanteraren %%phpHandlerName%%',
    'install-php-extension.error' => 'Kunde inte installera paketet %%extensionName%% på PHP-hanteraren %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Kontrollerar krav',
    'install-php-extension.step.dependencies' => 'Löser beroenden',
    'install-php-extension.step.process' => 'Installerar paket',
    'install-php-extension.step.enable' => 'Aktiverar tillägg',
    'install-php-extension.step.sync' => 'Synkroniserar webbplatser',
    'install-php-extension.errorReason' => 'Listan över tillgängliga paket tillhandahålls av PECL. De vanligaste anledningarna till misslyckad installation är följande:',
    'install-php-extension.errorReasonDependencies' => '- Paketet har externa beroenden av ytterligare bibliotek.',
    'install-php-extension.errorReasonRequirements' => '- Paketet uppfyller inte installationskraven (OS, PHP-version och så vidare).',
    'install-php-extension.errorReasonOutdated' => '- Paketet är föråldrat.',
    'install-php-extension.errorOutput' => 'För att identifiera anledningen till den misslyckade installationen, undersök utdatan för verktyget.',

    'uninstall-php-extension.queue' => 'Avinstallerar paketet %%extensionName%% från PHP-hanteraren %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'Paketet %%extensionName%% avinstallerades från PHP-hanteraren %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Kunde inte avinstallera paketet %%extensionName%% från PHP-hanteraren %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Kontrollerar krav',
    'uninstall-php-extension.step.process' => 'Avinstallerar paket',
    'uninstall-php-extension.step.sync' => 'Synkroniserar webbplatser',

    'upgrade-database-server.queue' => 'Uppgraderar databasservern',
    'upgrade-database-server.error' => 'Kunde inte uppgradera databasservern',
    'upgrade-database-server.done' => 'Databasservern uppgraderades',
    'upgrade-database-server.step.validate' => 'Kontrollerar systemet',
    'upgrade-database-server.step.dump' => 'Skapar en dump av databaser',
    'upgrade-database-server.step.disableService' => 'Inaktiverar gammal systemtjänst',
    'upgrade-database-server.step.configureRepo' => 'Konfigurerar ny katalog',
    'upgrade-database-server.step.upgradePackages' => 'Uppgraderar databasservern',
    'upgrade-database-server.step.updateConfiguration' => 'Uppdaterar serverkonfigurationen',
    'upgrade-database-server.step.startService' => 'Startar ny systemtjänst',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Uppgraderar strukturen för alla tabeller',
    'upgrade-database-server.step.sync' => 'Synkroniserar systemkomponenter',

    'update-spam-filter-individual-settings.queue' => 'Uppdaterar inställningar för skräppostfilter',
    'update-spam-filter-individual-settings.done' => 'Inställningar för skräpppostfilter uppdaterades',
    'update-spam-filter-individual-settings.error' => 'Kunde inte uppdatera inställningar för skräppostfilter',
    'update-spam-filter-individual-settings.mailNameError' => 'E-postadress %%name%%: %%error%%',

    'update-default-cert.queue' => 'Uppdaterar standardcertifikatet',
    'update-default-cert.done' => 'Standardcertifikatet uppdaterades.',
    'update-default-cert.error' => 'Uppdatering av standardcertifikatet slutfördes med fel.',
    'update-default-cert.step.updating' => 'Uppdaterar standardcertifikatet…',
];