<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'Nyckelnummer',
    'additional-keys.keyName' => 'Nyckelnamn',
    'additional-keys.keyApp' => 'Program',
    'additional-keys.addGroup' => 'Lägg till',
    'additional-keys.upload' => 'Installera ny nyckel',
    'additional-keys.uploadDescription' => 'Ladda upp och installera en ny licensnyckel.',
    'additional-keys.actionsGroup' => 'Åtgärder',
    'additional-keys.install' => 'Installera',
    'additional-keys.installAll' => 'Installera alla',
    'additional-keys.installDescription' => 'Installera valda licensnycklar.',
    'additional-keys.installNoSelection' => 'Välj en eller flera ytterligare licensnycklar att installera eller klicka på "Installera alla".',
    'additional-keys.installSuccess' => 'Installation av licensnyckel har påbörjats.',
    'additional-keys.removeGroup' => 'Ta bort',
    'additional-keys.remove' => 'Ta bort',
    'additional-keys.removeDescription' => 'Ta bort valda licensnycklar.',
    'additional-keys.removeNoSelection' => 'Välj en eller flera ytterligare licensnycklar att ta bort.',
    'additional-keys.removeConfirmation' => 'Ta bort {count, plural, =1 {licensnyckeln {name}} one {den # valda licensnyckeln} other {de # valda licensnycklarna}}?',
    'additional-keys.removeSuccess' => 'De valda licensnycklarna togs bort.',
    'additional-keys.download' => 'Hämtningsnyckel',
    'additional-keys.downloadDescription' => 'Ladda ner licensnyckeln.',
    'additional-keys.emptyViewTitle' => 'Inga ytterligare licensnycklar',

    'backup.tasks.startDate' => 'Startat',
    'backup.tasks.targetRepo' => 'Mållagring',
    'backup.tasks.progress' => 'Processen körs',
    'backup.tasks.repoTypeLocal' => 'Server',
    'backup.tasks.repoTypeFtp' => 'Personlig FTP',
    'backup.tasks.buttonRemoveTask' => 'Ta bort',
    'backup.tasks.hintRemoveTask' => 'Ta bort markerade säkerhetskopi- uppgifter.',
    'backup.tasks.buttonReload' => 'Läsa in igen',
    'backup.tasks.hintReload' => 'Läsa in igen uppgiftslistan för att få den aktuella statusen.',
    'backup.tasks.statusTaskWarnings' => 'Varningar',
    'backup.tasks.statusTaskInfo' => 'Information',
    'backup.tasks.statusTaskFailed' => 'Misslyckad',

    'backup.disabledSelectHint' => 'Säkerhetskopian kan inte tas bort eftersom den ingår i en säkerhetskopiering på server-, återförsäljar- eller kundnivå.',
    'backup.buttonBackup' => 'Säkerhetskopiera',
    'backup.hintBackup' => 'Skapa en säkerhetskopia.',
    'backup.buttonSchedule' => 'Schema',
    'backup.hintSchedule' => 'Ange inställningar för schemalagd säkerhetskopiering.',
    'backup.buttonReload' => 'Läsa in igen',
    'backup.hintReload' => 'Läsa in listan med säkerhetskopior igen',
    'backup.buttonUpload' => 'Ladda upp',
    'backup.hintUpload' => 'Ladda upp en säkerhetskopierad fil från din dator till serverns säkerhetskopierade lagring.',
    'backup.buttonSettings' => 'Inställningar',
    'backup.hintSettings' => 'Konfigurera globala inställningar för datasäkerhetskopiering, för att reducera serverns CPU-belastning.',
    'backup.buttonRemoteStorages' => 'Fjärrlagringsinställningar',
    'backup.hintRemoteStorages' => 'Konfigurera din personliga fjärrlagring för lagring av säkerhetskopierade filer.',
    'backup.buttonRemove' => 'Ta bort',
    'backup.hintRemove' => 'Ta bort valda säkerhetskopior från serverlagringen.',
    'backup.systemNotes' => 'Systemanteckningar',
    'backup.incremental' => 'Inkrementell.',
    'backup.multiVolume' => 'Multivolym.',
    'backup.remoteStorage' => 'I lagringen: %%storage%%',
    'backup.status' => 'S',
    'backup.statusOff' => 'Detta är en ogiltig säkerhetskopia. Kan inte hämta data från den här filen. Klicka på säkerhetskopians namn för närmare uppgifter.',
    'backup.statusWarning' => 'Denna säkerhetskiopia är inte helt giltig. Klicka på säkerhetskopians namn för närmare uppgifter.',
    'backup.statusInfo' => 'Detta är en giltig säkerhetskopia. Data kan återställas från denna säkerhetskopia men mindre problem kan uppstå med sättet uppgifterna lagras på.',
    'backup.statusOn' => 'Detta är en giltig säkerhetskopia. Data kan återställas från denna säkerhetskopia.',
    'backup.date' => 'Skapandedatum',
    'backup.name' => 'Namn',
    'backup.comment' => 'Kommentarer',
    'backup.size' => 'Storlek',
    'backup.download' => 'Ladda ner säkerhetskopiefil till din lokala dator.',
    'backup.downloadDisabled' => 'Nerladdningen av den säkerhetskopierade filen är inte tillgänglig för tillfället. Försök igen senare eller kontakta din serviceleverantör.',
    'backup.total' => 'Totala säkerhetskopior: %%total%%, size: %%totalSize%%',
    'backup.totalFound' => '%%found%% säkerhetskopior hittade (%%total%% totalt), storlek: %%totalSize%%',
    'backup.confirmOnDelete' => 'Vill du verkligen ta bort markerad säkerhetskopia?',
    'backup.incrementsRemovalLoading' => 'Laddar...',
    'backup.incrementsRemovalConfirmation' => 'Jag bekräftar att jag vill ta bort markerade säkerhetskopior.',
    'backup.backupHasIncrements' => 'Säkerhetskopieringen %%backupName%% tas bort tillsammans med ökningarna: %%backupIncrements%%',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Felaktigt användarnamn elelr lösenord för FTP-lagringen',
    'backup.ftpStorageErrorResolveHost' => "Det gick inte att lösa värddatornamnet",
    'backup.ftpStorageErrorConnection' => "Kan inte ansluta till fjärrservern",
    'backup.unableToGetFtpDumpList' => 'Kunde inte visa listan med säkerhetskopior i FTP-lagring: %%errorMessage%%. Kontrollera <a href="%%ftpSettingsUrl%%">FTP-lagringsinställingarna</a>.',
    'backup.unableToGetExtDumpList' => 'Kunde inte visa listan med säkerhetskopior i %%storageTitle%% lagring: %%errorMessage%%. Kontrollera lagringens inställningar.',
    'backup.unableToGetLocalDumpList' => 'Kunde inte visa listan med säkerhetskopior i servern: %%errorMessage%%.',
    'backup.skippedFilesAtExtStorage' => 'Vissa av filerna i lagret %%storageTitle%% visas inte i listan eftersom namnen på de filerna inte överensstämmer med benämningskonventionen för säkerhetskopierade filer. Om du är säker på att de filerna är giltiga säkerhetskopierade filer, byt namn på dem enlgt följande mönster: "backup_%%objectName%%&lt;YYMMDDHHmm&gt;.%%ext%%"',
    'backup.multiVolumeShow' => 'Visa volymer',
    'backup.multiVolumeHide' => 'Göm volymer',
    'backup.backEncryptionRequired' => 'Av säkerhetsskäl, rekommenderar vi att du skyddar känsliga uppgifter som finns i säkerhetskopieringsnamn. Gå till %%link%% och uppdatera inställningarna för säkerhetskopieringen.',
    'backup.backupSettingPage' => 'Inställningar för säkerhetskopiering',
    'backup.statusTaskProgress' => 'Säkerhetskopieringsuppgiften pågår.',
    'backup.statusTaskWarnings' => 'Säkerhetskopieringsuppgiften har avslutats med varningar.',
    'backup.statusTaskInfo' => 'Information.',
    'backup.statusTaskFailed' => 'Säkerhetskopieringsuppgiften misslyckades.',
    'backup.statusTaskStopping' => 'Säkerhetskopieringsuppgiften stoppas.',
    'backup.statusTaskStopped' => 'Säkerhetskopieringsuppgiften stoppades.',

    'backup.schedule.columnSchedule' => 'Schema',
    'backup.schedule.columnContent' => 'Innehåll',
    'backup.schedule.columnStorage' => 'Lagring',
    'backup.schedule.periodHourly' => 'Timvis',
    'backup.schedule.periodHourlySchedule' => 'varje {period, plural, one {# timme} other {# timmar}}',
    'backup.schedule.periodDaily' => 'Dagens',
    'backup.schedule.periodDailySchedule' => 'kl. %%hours%%:%%minutes%%',
    'backup.schedule.periodWeekly' => 'Veckovis',
    'backup.schedule.periodWeeklySchedule' => 'den %%day%% kl. %%hours%%:%%minutes%%',
    'backup.schedule.periodMonthly' => 'Månadsvis',
    'backup.schedule.periodMonthlySchedule' => 'den %%day%% dagen kl. %%hours%%:%%minutes%%',
    'backup.schedule.periodCustom' => 'Anpassad',
    'backup.schedule.dayFirst' => 'första',
    'backup.schedule.dayLast' => 'sist',
    'backup.schedule.day' => '{day, selectordinal, one {#:a} other {#:e}}',
    'backup.schedule.storageLocal' => 'Serverlagring',
    'backup.schedule.storageBoth' => 'Både serverlagring och %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'Schemalagd säkerhetskopiering inaktiverades',

    'custombuttons.buttonAdd' => 'Lägg till länk till tjänsten',
    'custombuttons.buttonAddDescription' => 'Lägg till en länk till en tjänst online och placera den i Plesk.',
    'custombuttons.buttonRemove' => 'Ta bort',
    'custombuttons.buttonRemoveDescription' => 'Radera markerade länkar.',
    'custombuttons.removeConfirmMessage' => 'Ta bort valda länkar?',
    'custombuttons.headerPublic' => 'A',
    'custombuttons.headerLocation' => 'L',
    'custombuttons.headerImage' => 'Bild',
    'custombuttons.headerPriority' => 'Prioritet',
    'custombuttons.headerLabel' => 'Etikett',
    'custombuttons.headerUrl' => 'URL',
    'custombuttons.headerDescription' => 'Beskrivning',
    'custombuttons.publicEnabledDescription' => 'Länken är synlig för användare.',
    'custombuttons.publicDisabledDescription' => 'Länken är inte synlig för användare.',
    'custombuttons.altPublicEnabledIcon' => 'Publik',
    'custombuttons.altPublicDisabledIcon' => 'Privat',
    'custombuttons.placeNavigationDescription' => 'Länken finns på alla sidor.',
    'custombuttons.placeAdminDescription' => 'Länken finns på administratörens startsida.',
    'custombuttons.placeAdminSettingsDescription' => 'Länken finns på administratörssidan Verktyg & inställningar.',
    'custombuttons.placeResellerDescription' => 'Länken finns på återförsäljarens startsida',
    'custombuttons.placeResellerSettingsDescription' => 'Länken finns på återförsäljarens sida Verktyg och hjälpprogram.',
    'custombuttons.placeClientDescription' => 'Länken finns på kundens startsida.',
    'custombuttons.placeDomainDescription' => 'Länken finns på sidan Webbplatser och domäner i abonnemanget.',
    'custombuttons.placeDomainPropertiesDescription' => 'Länken finns i webbplats verktyg området, som öppnas på siden Webbplatser & Domäner genom att klicka på Visa mer under ett domännamn.',

    'databaseservers.addGroup' => 'Lägg till',
    'databaseservers.addDatabaseServer' => 'Lägg tilll databasserver',
    'databaseservers.addDatabaseServerDescription' => 'Lägg till en databasserver.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'Fjärrdatabasens värdtjänst stöds inte av licensnyckeln.',
    'databaseservers.actionsGroup' => 'Åtgärder',
    'databaseservers.hostingSettings' => 'Inställningar',
    'databaseservers.hostingSettingsDescription' => 'Databasens värdtjänstinställningar.',
    'databaseservers.refresh' => 'Uppdatera',
    'databaseservers.refreshDescription' => 'Uppdatera information om databasservrar.',
    'databaseservers.removeGroup' => 'Ta bort',
    'databaseservers.remove' => 'Ta bort',
    'databaseservers.removeDescription' => 'Radera markerade databasservrar.',
    'databaseservers.lastError' => 'S',
    'databaseservers.type' => 'Servertyp',
    'databaseservers.host' => 'Värdnamn',
    'databaseservers.hostLink' => 'Visa eller modifiera databasserverns egenskaper.',
    'databaseservers.port' => 'Port',
    'databaseservers.version' => 'Version',
    'databaseservers.databasesCount' => 'Databaser',
    'databaseservers.databasesCountLink' => 'Hantera databaserna som hostas på denna server.',
    'databaseservers.databaseUpgradeLink' => 'Uppgradera databasservern som hostas på denna server.',
    'databaseservers.databasesLTSVersion' => 'Du har redan LTS-versionen. Plesk uppgraderar automatiskt din MariaDB/MySQL-installation till nyare punktversioner.',
    'databaseservers.webadmin' => 'Webadmin',
    'databaseservers.webadminHint' => 'Sök åtkomst till denna server via DB Webadmin.',
    'databaseservers.downloadMsSqlClient' => 'Ladda ner en lokal SQL-klient',
    'databaseservers.downloadMsSqlClientHint' => 'Ladda ner en lokal SQL-klient',
    'databaseservers.changePassword' => 'Ändra administratörslösenord',
    'databaseservers.changePasswordHint' => 'Ändra lösenord för serverns databasadministratör.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Microsoft SQL Server',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'standard för MySQL',
    'databaseservers.default_for_mssql' => 'standard för MS SQL',
    'databaseservers.default_for_postgresql' => 'som standard för PostgreSQL',
    'databaseservers.default_for_mariadb' => 'standard för MariaDB',
    'databaseservers.default_for_percona' => 'standard för Percona',
    'databaseservers.status_no_error' => 'Det senaste försöket att ansluta till denna server lyckades.',
    'databaseservers.status_connection_failed' => 'Det senaste försöket att ansluta till denna server misslyckades till följd av nätproblem.',
    'databaseservers.status_permission_denied' => 'Under det senaste försöket att ansluta till denna server, nekades åtkomsten. Kontrollera administratörens inloggningsuppgifter för servern.',
    'databaseservers.status_other_error' => 'Under det senaste försöket att ansluta till denna server uppstod ett fel.',
    'databaseservers.status_credentials_not_set' => 'Du måste ange ett giltigt användarnamn och lösenord för administratören innan Plesk kan ansluta till denna server.',
    'databaseservers.mssqlServerPortUndefined' => 'Kan inte slå fast TCP-portnummer som används av Microsoft SQL-servern "%%host%%": TCP/IP-protokoll är inte aktiverat i serverns nätverkskonfiguration eller så är servern konfigurerad att använda dynamiska TCP-portar.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'För att låta dina kunder automatiskt konfigurera brandväggen för fjärråtkomst av databas, konfigurera manuellt SQL-servern för att lyssna på en specifik, fixerad TCP-port.',
    'databaseservers.removeEmptySelection' => 'Inga databasservrar valda.',
    'databaseservers.removeConfirmation' => 'Är du säker på att du vill ta bort {count, plural, =1 {databasservern {name}} one {# vald databasserver} other {de # valda databasservrarna}}?',
    'databaseservers.removeSuccess' => 'De valda databasservrarna har tagits bort.',
    'databaseservers.upgradeNow' => 'Uppgradera nu',


    'databaseserverdatabases.actionsGroup' => 'Åtgärder',
    'databaseserverdatabases.assignToSubscription' => 'Flytta till abonnemanget',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'Flytta de valda databaserna till en annan prenumeration.',
    'databaseserverdatabases.removeGroup' => 'Ta bort',
    'databaseserverdatabases.remove' => 'Ta bort',
    'databaseserverdatabases.removeDescription' => 'Ta bort markerade databaser.',
    'databaseserverdatabases.name' => 'Namn',
    'databaseserverdatabases.subscription' => 'Abonnemang',
    'databaseserverdatabases.client' => 'Abonnent',
    'databaseserverdatabases.manageDatabase' => 'Hantera värdtjänster',
    'databaseserverdatabases.manageDatabaseDescription' => 'Hantera databasen.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Öppna i Återförsäljarpanelen',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Hantera databasen i prenumerantens Återförsäljarpanel.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Öppna i Kundpanelen',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Hantera databasen i abonnentens Kundpanel.',
    'databaseserverdatabases.emptySelection' => 'Inga databaser har valts.',
    'databaseserverdatabases.removeConfirmation' => 'Är du säker på att du vill ta bort {count, plural, =1 {databasen {name}} one {# vald databas} other {de # valda databaserna}}?',
    'databaseserverdatabases.removeSuccess' => 'De valda databasservrarna har tagits bort.',

    'logbrowser.issuesFoundInTheLogs' => 'Problem i webbplatsloggarna',
    'logbrowser.learnAboutProblemsFaster' => 'Upptäck webbplatsproblem tidigare',
    'logbrowser.noProblemsFound' => 'Inga problem i webbplatsloggarna',
    'logbrowser.lastCheckDetectsProblems' => '%%checkType%%-kontroll av loggarna har upptäckt problem som kan påverka din webbplats drift. För att se detaljer och möjliga lösningar, klicka på "Öppna kontrollrapport".',
    'logbrowser.lastCheckDetectsNoProblems' => '%%checkType%%-kontroll av loggen har inte upptäckt några problem som kan påverka din webbplats drift.',
    'logbrowser.noChecksResults' => 'En automatisk daglig kontroll är aktiverad, men inga kontroller genomfördes.',
    'logbrowser.manual' => 'En manuell',
    'logbrowser.regular' => 'En automatisk daglig',
    'logbrowser.enableRegularCheck' => 'En daglig kontroll av loggarna upptäcker fel som kan påverka din webbplats drift. Om några problem dyker upp kommer Plesk att informera dig och ge möjliga lösningar.',
    'logbrowser.new' => 'NYTT',
    'logbrowser.openCheckReport' => 'Öppna kontrollrapport',
    'logbrowser.openCheckSettings' => 'Öppna kontrollinställningar',

    'logbrowser.buttonStartRealtime' => 'Starta uppdateringar i realtid',
    'logbrowser.buttonStartRealtimeHint' => 'Uppdatera loggdata i realtid.',
    'logbrowser.buttonStopRealtime' => 'Stoppa uppdateringarna i realtid',
    'logbrowser.buttonStopRealtimeHint' => 'Stoppa uppdateringen loggdata i realtid.',
    'logbrowser.buttonRefresh' => 'Uppdatera',
    'logbrowser.buttonRefreshHint' => 'Uppdatera loggdata.',
    'logbrowser.buttonClear' => 'Rensa',
    'logbrowser.buttonClearHint' => 'Dölj redan laddade poster.',
    'logbrowser.buttonAddCustom' => 'Lägg till Loggwebbläsare som anpassad fil',
    'logbrowser.buttonAddCustomHint' => 'Filen visas i loggwebbläsaren med andra loggfiler.',
    'logbrowser.date' => 'Datum',
    'logbrowser.dateFilterPlaceholder' => 'Från',
    'logbrowser.type' => 'Typ',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Kod',
    'logbrowser.codeFilterPlaceholder' => 'Kod',
    'logbrowser.message' => 'Meddelande',
    'logbrowser.messageFilterPlaceholder' => 'Meddelande',
    'logbrowser.source' => 'Källa',
    'logbrowser.sourceFilterFiles' => '%%count%% filer',
    'logbrowser.sourceFilterAllLogs' => 'Alla loggar',
    'logbrowser.sourceFilterNoLogs' => 'Inga loggar',
    'logbrowser.manageLogFiles' => 'Hantera loggfiler',
    'logbrowser.addCustomLogFile' => 'Lägg till anpassad logg',
    'logbrowser.customLogPopupTitle' => 'Lägg till anpassad logg',
    'logbrowser.invalidLogFormat' => 'Loggfilen har ett format som inte stöds',
    'logbrowser.referer' => 'R',
    'logbrowser.refererHint' => 'Referer',
    'logbrowser.agent' => 'Agent',
    'logbrowser.agentHint' => 'Användaragent',
    'logbrowser.size' => 'Storlek',
    'logbrowser.unknown' => 'Okänt',
    'logbrowser.more' => 'Mer',
    'logbrowser.less' => 'Mindre',
    'logbrowser.any' => 'Valfri',
    'logbrowser.none' => 'Ingen',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% eller använd filter för att minska listan med poster.',
    'logbrowser.loadMore' => 'Ladda tidigare poster',
    'logbrowser.clear' => 'Rensa',
    'logbrowser.hourAgo' => 'Timme sedan',
    'logbrowser.prevDay' => 'Föreg. dag',
    'logbrowser.linkInMessageToViewFile' => 'Klicka för att visa filen.',
    'logbrowser.buttonUnlinkHint' => 'Klicka för att sluta spåra uppdateringar i denna fil i loggwebbläsaren',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Är du säker på att du vill sluta spåra uppdateringar i denna fil i loggwebbläsaren?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Ja',
    'logbrowser.buttonUnlinkConfirmationNo' => 'Nej',
    'logbrowser.logRotation' => 'Loggrotering',
    'logbrowser.logRotationHint' => 'Ställ in loggrotationsinställningarna för webbplatsen.',
    'logbrowser.logRotationTitle' => 'Konfigurera loggrotation',

    'notifications.title' => 'Inställning av utskick av e-postmeddelanden i systemhändelser',
    'notifications.legendNotifications' => 'Meddelanden',
    'notifications.legendSettings' => 'Inställningar',
    'notifications.headerEvent' => 'Händelse',
    'notifications.headerSendTo' => 'Sänd meddelande till:',
    'notifications.headerText' => 'Text',
    'notifications.headerPreview' => 'Förhandsvisning',
    'notifications.headerAdmin' => 'Administratör',
    'notifications.headerReseller' => 'Återförsäljare',
    'notifications.headerClient' => 'Kund',
    'notifications.headerEmailAddress' => 'E-postadress',
    'notifications.expirationTime' => 'Sänd förfallovarningar',
    'notifications.days' => 'dagar i förväg',
    'notifications.smtpSettings' => 'För att Plesk ska kunna skicka meddelanden när reläet är stängt, kan du %%link%%',
    'notifications.smtpSettingsLink' => 'ändra SMTP-inställningarna',
    'notifications.editHint' => 'Redigera meddelandetexten.',
    'notifications.previewHint' => 'Se hur meddelandet ser ut i e-posten.',
    'notifications.reseller_creation' => 'Återförsäljarens kontoskapande',
    'notifications.reseller_limits_exceed' => 'Resursanvändningsgränserna har överskridits av återförsäljarkontot',
    'notifications.reseller_blocked' => 'Återförsäljarkontot upphävdes på grund av överanvändning av resursen',
    'notifications.reseller_overuse_block' => 'Återförsäljarens resursanvändningsgränser nåddes av återförsäljarens abonnemang på grund av översäljning',
    'notifications.client_creation' => 'Kundens kontoskapande',
    'notifications.domain_creation' => 'Skapa webbplatser',
    'notifications.domain_exp_warning' => 'Varning om abonnemangets utgång',
    'notifications.domain_expiration' => 'Förfallotid för abonnemang',
    'notifications.domain_limits_exceed' => 'Resursanvändningsgränserna har överskridits av abonnemanget',
    'notifications.domain_blocked' => 'Abonnemanget upphävdes på grund av överanvändning av resursen',
    'notifications.admin_aps_app_updates' => 'APS programuppdateringar (administratörens sammandrag )',
    'notifications.reseller_aps_app_updates' => 'APS programuppdateringar (återförsäljarnas sammandrag )',
    'notifications.client_aps_app_updates' => 'APS programuppdateringar (kundens sammandrag )',
    'notifications.admin_pum_updates' => 'Systemuppdateringar: meddelanden om nya uppdateringar',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'Utgående e-post har överskridit gränserna',
    'notifications.subscription_cgroups_limits_exceed' => 'RAM, CPU och Disk I/O (C-grupper)',
    'notifications.admin_postponed_feedback' => 'Påminnelse om feedback',
    'notifications.errorInvalidEmail' => 'Felaktig e-postadress.',
    'notifications.errorInvalidExpTime' => 'Antal dagar är ogiltigt.',
    'notifications.errorUpdate' => 'Det gick inte att uppdatera meddelande: %%error%%',
    'notifications.updated' => 'Meddelandeinställningar uppdaterades',

    'outgoingmail.name' => 'Namn',
    'outgoingmail.maxOutgoingMessages' => 'Gräns per timme',
    'outgoingmail.numOfExceedingAttempts' => 'Försök efter att gränsen är uppnådd',
    'outgoingmail.lastAttemptAt' => 'Senaste försök',
    'outgoingmail.mailStatus' => 'E-poststatus',
    'outgoingmail.mailStatusSending' => 'Skickas',
    'outgoingmail.mailStatusNotSending' => 'Skickar inte',
    'outgoingmail.mailStatusSendingDesc' => 'E-post skickas.',
    'outgoingmail.mailStatusNotSendingDesc' => 'E-post skickas inte.',
    'outgoingmail.limitValueUnlimited' => 'Obegränsat',

    'scheduler.tasks.headerCommand' => 'Kommando',
    'scheduler.tasks.headerSchedule' => 'Schema',
    'scheduler.tasks.headerSubscription' => 'Abonnemang',
    'scheduler.tasks.headerSubscription_powerUser' => 'Webbutrymme',
    'scheduler.tasks.buttonToggleHintOn' => 'Uppgiften är aktiverad. Klicka om du vill inaktivera hela aktiviteten.',
    'scheduler.tasks.buttonToggleHintOff' => 'Uppgiften är inaktiverad. Klicka om du vill aktivera hela aktiviteten.',
    'scheduler.tasks.add' => 'Lägg till uppgift',
    'scheduler.tasks.hintAdd' => 'Skapa en ny aktivitet.',
    'scheduler.tasks.remove' => 'Ta bort',
    'scheduler.tasks.hintRemove' => 'Ta bort markerade uppgifter.',
    'scheduler.tasks.confirmOnDelete' => 'Vill du verkligen ta bort de markerade uppgifterna?',
    'scheduler.tasks.sync' => 'Uppdatera',
    'scheduler.tasks.hintSync' => 'Läsa in igen uppgiftslistan för att få aktuella data.',
    'scheduler.tasks.settings' => 'Inställningar',
    'scheduler.tasks.hintSettings' => 'Redigera inställningar för schemalagda uppgifter.',
    'scheduler.tasks.deleteSuccess' => 'De schemalagda uppgifterna har tagits bort.',
    'scheduler.tasks.serverTask' => 'server (användare:%%user%%)',
    'scheduler.tasks.unknownUser' => 'okänt',
    'scheduler.tasks.runTaskNow' => 'Kör nu',
    'scheduler.tasks.runTaskNowHint' => 'Kör uppgiften nu.',
    'scheduler.tasks.runningTask' => 'Kör uppgiften "%%task%%"...',

    'server-components.bcTitle' => 'Serverkomponenter',
    'server-components.title' => 'Plesk-komponenter',
    'server-components.name' => 'Komponentnamn',
    'server-components.version' => 'Komponentversion',
    'server-components.refresh' => 'Uppdatera',
    'server-components.componentName' => 'Ange komponentnamn...',
    'server-components.noComponents' => 'Inga komponenter hittades',
    'server-components.componentsListUpdated' => 'Komponentlistan uppdaterades',

    'server-components.componentName.urlrewrite' => 'URL-omskrivning',
    'server-components.componentName.dbconnector' => "Databasanslutare",
    'server-components.componentName.mysqlserver' => 'MariaDB/MySQL-server',
    'server-components.componentName.troubleshooting' => 'Felsökning',
    'server-components.componentName.waf' => 'Webbprogram brandvägg',
    'server-components.componentName.vcs' => 'Versionens kontrollsystem',
    'server-components.componentName.dotnetcore' => '.NET kärna',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Applikationsinitiering",
    'server-components.componentName.cors' => "Ursprungsöverskridande resursdelning",
    'server-components.componentName.httpcompression' => 'Kompression av HTTP-innehåll',
    'server-components.componentName.antivirus' => "Antivirus",
    'server-components.componentName.database' => "SQL Server",
    'server-components.componentName.sqladmin' => "MariaDB/MySQL-webadmin",
    'server-components.componentName.sqladminmysql' => "MariaDB/MySQL-webadmin",
    'server-components.componentName.dnsserver' => "DNS-server",
    'server-components.componentName.firewall' => "Brandvägg",
    'server-components.componentName.ftpserver' => "FTP server",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "E-postserver",
    'server-components.componentName.local_mailserver' => "Lokal-e-postserver",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Skript för webben",
    'server-components.componentName.spamfilter' => "Skräppostfilter",
    'server-components.componentName.stats' => "Webbstatistik",
    'server-components.componentName.stunnel' => "SSL/TLS Wrapper",
    'server-components.componentName.webmail' => "Webbpost",
    'server-components.componentName.webpublish' => "Webbpublicering",
    'server-components.componentName.webserver' => "Webbserver",
    'server-components.componentName.network' => 'Nätverk',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Plesk Hosting",
    'server-components.componentName.savi' => 'Sophos Anti-Virus gränssnitt',

    'server-components.tooltip.disabled' => 'Avstängd',
    'server-components.tooltip.active' => 'Aktiva',
    'server-components.tooltip.notConfigured' => 'Inte konfigurerad',
    'server-components.tooltip.notStarted' => 'Inte startat, kontrollera komponentinställningar',

    'server-components.defaultComponents.circularDependencies' => "Cirkulära beroenden hittades mellan kategorierna %%cat1%% och %%cat2%%",
    'server-components.defaultComponents.not_installed' => "(inte installerad)",
    'server-components.defaultComponents.not_configured' => "(inte konfigurerat)",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Vissa tjänstekategorier innehåller ogiltiga markeringar eller inga markeringar har gjorts.",
    'server-components.defaultComponents.depends_on' => "(kräver %%name%% )",
    'server-components.defaultComponents.not_activated' => 'inte aktiverad',
    'server-components.defaultComponents.imap_required' => '(Den aktuella e-postservern stöder inte IMAP)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(FTP-servern stödjer inte IPv6-adresser.)",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(den nödvändiga delegeringsregeln \'appPoolPipeline, appPoolNetFx\' finns inte)',
    'server-components.defaultComponents.not_supported_version' => '(Versionen stöds inte)',
    'server-components.defaultComponents.no_license' => '(inte tillåtet enligt licensnyckeln)',
    'server-components.defaultComponents.license_expired' => '(licensnyckel har utgått)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(inkorgsgräns för licesnyckel överskrids)',
    'server-components.defaultComponents.title' => 'Välj standard %%name%%-komponent',
    'server-components.defaultComponents.none' => 'Ingen',
    'server-components.defaultComponents.yes' => 'Ja',
    'server-components.defaultComponents.no' => 'Nej',
    'server-components.defaultComponents.warning' => 'Varning!',
    'server-components.defaultComponents.parametersOfComponent' => 'Parametrar för %%component%%',
    'server-components.defaultComponents.success' => 'Standardkomponent uppdaterades',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "Ändring av e-postservern är endast avsedd för den inledande installationen, och om servern redan används leder det till följande problem: förlust av inställningar och e-postinkorgarnas innehåll och, i fall när servern du byter till redan har konfigurerats, olika konflikter.\nOm denna server används nu och du är säker på att du vill byta till en annan, kan du meddela dina kunder om åtgärden så att de kan ladda ner och spara e-posten.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Endast de första 254 IP-adresserna av subnät med /8 och /16 masker i Åtkomstkontrollistan kommer att överföras. De överförs som separata IP-adresser. Vill du fortsätta?",

    'server-components.componentConf.title' => 'Parametrar för %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'Parameter krävs',
    'server-components.componentConf.parameterShouldBeNumber' => 'Parameter bör vara ett nummer',
    'server-components.componentConf.success' => 'Parametrar uppdaterades',

    'spam-filter.groupAdd' => 'Lägg till',
    'spam-filter.buttonAdd' => 'Lägg till domän',
    'spam-filter.buttonAddAddress' => 'Lägg till adress',
    'spam-filter.buttonAddToBlackListHint' => 'Lägg till domän i svartlistan',
    'spam-filter.buttonAddToWhiteListHint' => 'Lägg till en domän i vita listan',
    'spam-filter.buttonAddAddressToBlackListHint' => 'Lägg till adress i svarta listan',
    'spam-filter.buttonAddAddressToWhiteListHint' => 'Lägg till adress i vita listan',
    'spam-filter.groupActions' => 'Åtgärder',
    'spam-filter.buttonRemove' => 'Ta bort',
    'spam-filter.entries' => 'Poster',
    'spam-filter.removeEmptySelection' => 'Inga poster valda.',
    'spam-filter.removeConfirmation' => 'Ta bort {count, plural, =1 {posten {name}} one {den # valda posten} other {de # valda posterna}}?',
    'spam-filter.removeSuccess' => 'Valda poster togs bort.',
    'spam-filter.addAddressToBlackListEmptyTitle' => 'Lista med kända skräppostadresser',
    'spam-filter.addAddressToWhiteListEmptyTitle' => 'Lista med betrodda adresser',
    'spam-filter.addAddressToBlackListEmptyDescription' => 'Post från e-postadresser på den här listan behandlas som skräppost.',
    'spam-filter.addAddressToWhiteListEmptyDescription' => 'Post från e-postadresser på den här listan hoppar över skräppostfiltret.',

    'tasks.pollingOff' => 'Av',
    'tasks.pollingDelay' => '%%delay%% s',
    'tasks.stopTaskConfirm' => 'Vill du verkligen stoppa uppgiften?',
    'tasks.stopTaskError' => 'Kunde inte stoppa uppgift',
    'tasks.stopTask' => 'Stoppa uppgift',
    'tasks.processedLoadFailed' => 'Kunde inte ladda processlista',
    'tasks.retryTask' => 'Försök igen',
    'tasks.retryTaskFailed' => 'Kunde inte försöka igen',
    'tasks.taskCreated' => 'Ny uppgift har skapats',
    'tasks.moreDetails' => 'Se panellogg för detaljer',
    'tasks.searchTitle' => 'Sök',
    'tasks.searchPlaceholder' => 'Sök sträng',
    'tasks.refresh' => 'Uppdatera',
    'tasks.refreshDescription' => 'Uppdatera uppgiftslista',
    'tasks.createTask' => 'Skapa uppgift',
    'tasks.openSwagger' => 'Öppna Swagger',
    'tasks.statusTitle' => 'Status',
    'tasks.createdTitle' => 'Skapad',
    'tasks.descriptionTitle' => 'Beskrivning',
    'tasks.processes.dataLoadFailed' => 'Kunde inte hämta data från server',
    'tasks.processes.commandLineLoadFailed' => 'Kunde inte hämta kommandorad för uppgift',
    'tasks.processes.stopProcess' => 'Stoppa process',
    'tasks.processes.stopProcessFailed' => 'Kunde inte stoppa process',
    'tasks.processes.stopProcessConfirm' => 'Vill du verkligen stoppa processen?',
    'tasks.processes.copyToClipboard' => 'Kopiera till urklipp',
    'tasks.processes.concurrency' => 'Samtidighet',
    'tasks.processes.taskIdSection' => 'Uppgifts-ID',
    'tasks.processes.requestorIdSection' => 'Begärar-ID',
    'tasks.processes.timeoutSection' => 'Timeout',
    'tasks.processes.createdSection' => 'Skapad',
    'tasks.processes.updatedSection' => 'Uppdaterad',
    'tasks.processes.environmentSection' => 'Miljö',
    'tasks.processes.idTitle' => 'ID',
    'tasks.processes.statusTitle' => 'Status',
    'tasks.processes.startedTitle' => 'Startat',
    'tasks.processes.completedTitle' => 'Slutförd',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Utgångskod',

    'ts-sessions.columnStateTitle' => 'Stat',
    'ts-sessions.columnUserTitle' => 'Användare',
    'ts-sessions.columnNameTitle' => 'Namn',
    'ts-sessions.refresh' => 'Uppdatera',
    'ts-sessions.logoff' => 'Logga ut',
    'ts-sessions.logoffConfirmation' => 'Logga ut %%count%% session(er)?',
    'ts-sessions.logoffConfirmationSingle' => 'Logga ut sessionen %%name%%?',
    'ts-sessions.logoffConfirmationButton' => 'Ja, logga ut',
    'ts-sessions.logoffNoSelection' => 'Välj en eller flera sessioner att logga ut',
    'ts-sessions.logoffSuccess' => 'Valda sessioner loggades ut.',
    'ts-sessions.disconnect' => 'Koppla från',
    'ts-sessions.disconnectConfirmation' => 'Koppla ner %%count%% session(er)?',
    'ts-sessions.disconnectConfirmationSingle' => 'Koppla ner sessionen %%name%%?',
    'ts-sessions.disconnectConfirmationButton' => 'Ja, koppla ner',
    'ts-sessions.disconnectSuccess' => 'Valda sessioner kopplades ner.',
    'ts-sessions.disconnectNoSelection' => 'Välj en eller flera sessioner att koppla ner',
    'ts-sessions.disconnectNotAvailable' => 'Du kan bara koppla ner aktiva eller anslutna sessioner.',

    'client-ip-address.title' => 'IP-adresser',
    'client-ip-address.status' => 'Status',
    'client-ip-address.type' => 'Typ',
    'client-ip-address.ipAddress' => 'IP-adress',
    'client-ip-address.certificate' => 'Certifikat',
    'client-ip-address.hosting' => 'Värding',
    'client-ip-address.adminCertificateRepository' => "Adminsitratörsmagasin",
    'client-ip-address.domainCertificateRepository' => 'Katalog för domän %%owner%%',
    'client-ip-address.typeShared' => 'Delad',
    'client-ip-address.typeExclusive' => 'Dedikerad',
    'client-ip-address.removeConfirmation' => 'Ta bort {count, plural, =1 {IP-adresserna för {name}} one {de # valda IP-adresserna} other {de # valda IP-adresserna}} från användarens IP-pool?',
    'client-ip-address.noItemsToRemove' => 'Välj ett eller flera objekt att ta bort.',
    'client-ip-address.ftpOverSSL' => 'FTP över SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Ja',
    'client-ip-address.ftpOverSSL-no' => 'Nej',
    'client-ip-address.ftpOverSSL-allow' => 'Tillåt',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Tillåts inte',
    'client-ip-address.add' => 'Lägg till IP-adress',
    'client-ip-address.noAvailableIps' => 'Det finns inga tillgängliga IP-adresser.',
    'client-ip-address.isOk' => 'IP-adressen fungerar korrekt.',
    'client-ip-address.isBroken' => 'IP-adress finns inte på gränssnittet.',
    'client-ip-address.properties.title' => 'IP-adress %%address%% på gränssnittet %%interface%%',
    'client-ip-address.properties.distributedType' => 'IP-adress distribuerad som',
    'client-ip-address.properties.allocatedType' => 'IP-adress allokerad som',
    'client-ip-address.properties.none' => 'Ingen',
    'client-ip-address.properties.certificate' => 'SSL/TLS-certifikat',
    'client-ip-address.properties.defaultSite' => 'Standardwebbplats',
    'client-ip-address.assign.title' => 'Välj IP-adresser',
    'client-ip-address.assign.description' => 'Lediga IP',
    'client-ip-address.assign.success' => '{count, plural, =1 {IP-adressen {name}} one {De # valda IP-adresserna} other {De # valda IP-adresserna}} har lagts till i användarens IP-pool',

    'ip-address-reseller-usage.title' => 'Återförsäljare som använder %%type%% IP-adress %%ipAddress%%',
    'ip-address-reseller-usage.nameColumnHeader' => 'Återförsäljare',
    'ip-address-reseller-usage.assignButton' => 'Tilldela återförsäljare',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'Denna IP-adress är redan tilldelad alla användare.',
    'ip-address-reseller-usage.removeButton' => 'Ta bort',
    'ip-address-reseller-usage.removeSuccess' => 'IP-adressen togs bort från {count, plural, =1 {poolen {name}} one {de # valda poolerna för återförsäljare} other {de # valda IP-poolerna för återförsäljare}}.',
    'ip-address-reseller-usage.removeConfirmation' => 'Ta bort IP-adressen från {count, plural, =1 {IP-poolen {name}} one {de # valda IP-poolerna för återförsäljare} other {de # valda IP-poolerna för återförsäljare}}?',
    'ip-address-reseller-usage.typeSHARED' => 'Delad',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Dedikerad',
    'ip-address-reseller-usage.assign.title' => "Lägg till %%ipAddress%% till IP-poolen för återförsäljare",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Återförsäljare att lägga till',
    'ip-address-reseller-usage.assign.success' => 'IP-adressen lades till i {count, plural, =1 {IP-poolen {name}} one {de # valda IP-poolerna för återförsäljare} other {de # valda IP-adresserna för återförsäljare}}.'
];