<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "Lỗi cổng vào 502: ngược dòng gửi tiêu đề quá lớn khi đọc tiêu đề phản hồi"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Sắp sẵn sàng.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache"Lỗi nội bộ máy chủ 500: Tùy chọn FollowSymLinks không được cho phép ở đây"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Sắp sẵn sàng.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "máy chủ đã đạt cài đặt max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Biểu hiện</h4><ul><li><p>Trang web có trình xử lý PHP được đặt làm <strong>ứng dụng FPM do Apache cung cấp</strong> hoặc <strong>ứng dụng FPM do nginx cung cấp</strong> tại <strong>Miền</strong> &gt; <strong>example.com</strong> &gt; <strong>Cài đặt PHP</strong> gặp phải một trong các vấn đề sau:</p><ul><li><p>tải chậm</p></li><li><p>không thể truy cập (vĩnh viễn hoặc định kỳ) với lỗi 50x trong trình duyệt web:</p><pre>Lỗi cổng vào 502</pre><hr><pre>Dịch vụ tạm thời không khả dụng 503</pre><hr><pre>Hết thời gian chờ cổng 504</pre></li> </ul></li><li><p>Thông báo sau xuất hiện trong tập tin nhật ký lỗi PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (trong đó <em>XX</em> là phiên bản PHP được các trang web sử dụng): </p><pre>CẢNH BÁO: Máy chủ [pool example.com] đã đạt cài đặt max_children (*), hãy cân nhắc tăng thêm</pre><ul><li> <p>Thông báo ở trên thường kèm theo lỗi này:</p><pre> không thể đọc nội dung tiến trình con: Trình mô tả tập tin không hợp lệ(9)</pre></li></ul></li><li><p>Nếu nginx được bật trên máy chủ, một trong các thông báo lỗi sau có thể xuất hiện trong tập tin nhật ký lỗi của miền<code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() với unix: ///var/www/vhosts/system/example.com/php-fpm.sock không thành công (11: Tài nguyên tạm thời không có) trong khi kết nối với ngược dòng, máy khách: 203.0.113.2, máy chủ: example.com, yêu cầu: "GET / HTTP /1.1", ngược dòng: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", máy chủ lưu trữ: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 kết nối ngược dòng bị đóng sớm trong khi đọc tiêu đề phản hồi từ ngược dòng, máy khách: 203.0.113.2, máy chủ: example.com, yêu cầu: "POST /path/to/some/file HTTP/2.0", ngược dòng:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Trang web đã đạt giới hạn PHP-FPM <code>pm.max_children</code>.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Tăng giới hạn pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Tăng giới hạn <code>pm.max_children</code> cho những miền bị ảnh hưởng:</p><ol><li><p>Kết nối với máy chủ Plesk qua <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Tìm những miền bị ảnh hưởng bằng lệnh dưới:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Lưu ý:</strong> Số bên trái biểu thị số lần trang web đã đạt giới hạn <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "máy chủ đã đạt cài đặt max_children" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Đăng nhập vào Plesk</a>.</p></li><li><p>Đi đến<strong>Miền</strong> &gt; <strong>example.com</strong> &gt; <strong>Cài đặt PHP</strong> &gt; <strong>Cài đặt PHP-FPM</strong>.</p></li><li><p>Tăng giá trị <code>pm.max_children</code> cho miền và áp dụng thay đổi. Tăng giá trị này cho tất cả các miền được liệt kê trong bước 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Quá nhiều tập tin đang mở"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx không thể khởi động/tải lại trên máy chủ Plesk: Quá nhiều tập tin đang mở</p><h4>Biểu hiện</h4><ul><li><p>Dịch vụ nginx không thể khởi động/tải lại với những lỗi sau lỗi trong tập tin <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" không thành công (24: Quá nhiều tập tin đang mở)</pre></li><li><p>Một số hoặc tất cả các trang web không thể truy cập</p></li><li><p>Cảnh báo được hiển thị trong <strong>Công cụ &amp; Cài đặt &gt; Chẩn đoán &amp; sửa chữa</strong>:</p><pre style="white-space: pre-wrap;">Tìm thấy kiểm tra miền N giá trị ULIMIT nginx trên máy chủ. Có thể xảy ra sự vấn đề với giới hạn mặc định nginx cho các tập tin đang mở</pre></li><li><p>Ứng dụng web NodeJS và Ruby hiển thị Lỗi cổng vào 502 khi thực hiện một số tác vụ Plesk như tạo miền, đăng ký, thay đổi trên Apache hoặc Nginx, v.v.:</p><pre style="white-space: pre-wrap;">Lỗi máy chủ<br>Lỗi cổng vào 502 <br>Máy chủ web nhận được phản hồi không hợp lệ khi làm cổng hoặc máy chủ proxy.</pre></li><li><p>Sau khi <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">cài đặt chứng chỉ mới cho miền</a>, chứng chỉ cũ vẫn hiển thị trong trình duyệt web, tuy nhiên, chứng chỉ chính xác được chọn trong trang <strong>Miền &gt; example.com &gt; Cài đặt lưu trữ</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Máy chủ ảo của Nginx mở 4 tập tin nhật ký cho mỗi máy chủ ảo bằng máy chủ vật lý:</p><ul><li>proxy_access_log</li><li> proxy_access_ssl_log</li><li>webmail_access_log</li>< li>webmail_access_ssl_log</li></ul><p>Do đó, máy chủ nginx đã vượt quá số lượng tập tin đang mở tối đa do số lượng miền lớn (thường là hơn 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Tăng giới hạn tập tin mở',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Cảnh báo:</strong> Quá trình thực thi tiện ích <code>websrv_ulimits</code> mà không có tùy chọn <strong>--no-restart</strong> sẽ bắt đầu xây dựng lại tập tin cấu hình web cho tất cả các miền và có thể gây ra thời gian ngừng hoạt động đáng kể trong trường hợp có nhiều trang web được lưu trữ.<br><br>Thực thi lệnh trong khung thời gian bảo trì.</div><p>Bạn nên đặt giá trị giới hạn tập tin đang mở ở mức tối thiểu là nhiều hơn <strong>số lượng miền trong Plesk * 16</strong>. Ví dụ bên dưới cung cấp hướng dẫn đặt giới hạn thành 4096:</p><ol><li><p>Kết nối với máy chủ qua <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Đặt giới hạn tập tin đang mở thành 4096 cho cả Apache và Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Khởi động lại dịch vụ Apache và nginx tại <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Công cụ &amp; Cài đặt &gt; Quản lý dịch vụ</strong> để áp dụng thay đổi.</p></li><li><p>Kiểm tra xem "Giới hạn tập tin đang mở tối đa" đã được áp dụng đúng chưa, sau khi dịch vụ web khởi động lại:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Tập tin đang mở tối đa 4096 tập tin 4096</pre></li><li><p>Nếu giải pháp trên không có tác dụng, hãy đặt giới hạn bằng tiện ích <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Nội dung phản hồi quá lớn"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Sắp sẵn sàng.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Từ chối truy cập với mã 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Biểu hiện</h4><ul><li><p>ModSecurity được cài đặt và bật trong <strong>Công cụ & Thiết lập > Tường lửa ứng dụng web (ModSecurity) > Chế độ tường lửa ứng dụng web > Bật</strong>.</p></li><li>Không tải được trang web được lưu trữ trong Plesk. Không thể thực hiện các thao tác trên trang web như quản lý WordPress, truy cập webmail hoặc truy cập tập tin <code>robots.txt</code>. Trình duyệt có thể hiển thị một trong các lỗi sau: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Thông báo lỗi ModSecurity như thông báo bên dưới xuất hiện trong tập tin nhật ký <code>/var/log/modsec_audit.log</code> hoặc trên trang Nhật ký trong Plesk (<strong>Miền</strong> &gt; <strong>example.com</strong> &gt; <strong>Nhật ký</strong>): <pre>ModSecurity: Quyền truy cập bị từ chối với mã 403 (giai đoạn 2). Toán tử GE đã khớp 5 tại TX: anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Điểm bất thường đầu vào đã vượt quá (Tổng Điểm: 5) "] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Tường lửa ứng dụng web ModSecurity được bật với bộ quy tắc rất hạn chế như OWASP, Comodo hoặc bộ quy tắc tùy chỉnh như Imunify360. Các bộ quy tắc hạn chế có thể chặn một số hoạt động trên trang web.</p><p><Strong>Lưu ý:</strong> Lỗi ModSecurity có thể chỉ báo một cuộc tấn công vào máy chủ của bạn. Chỉ sử dụng các giải pháp bên dưới nếu bạn chắc chắn rằng ModSecurity chặn cách sử dụng hợp lệ trang web của bạn.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Tắt bộ quy tắc ModSecurity theo ID hoặc Nhãn',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Tìm ID của quy tắc chặn cách sử dụng hợp pháp trang web của bạn. Bạn có thể tìm thấy các ID trong thông báo lỗi của tập tin nhật ký <code>/var/log/modsec_audit.log</code>. ID là một số nguyên trong dấu ngoặc kép với tiền tố <code>id</code> trong dấu ngoặc vuông, ví dụ: <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Tắt bộ quy tắc cụ thể trong Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Chuyển sang bộ quy tắc ModSecurity khác',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Chuyển sang bộ quy tắc ModSecurity ít hạn chế hơn, ví dụ: "Bộ quy tắc Atomic ModSecurity". Để làm điều này, hãy đi tới <strong>Công cụ & Thiết lập</strong> > <strong>Tường lửa ứng dụng web (ModSecurity)</strong> > <strong>Thiết lập</strong>, chọn <strong>Atomic Standard</strong>, sau đó nhấp vào <strong>OK</strong> để áp dụng các thay đổi.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Lỗi nội bộ máy chủ 500: Kích thước bộ nhớ cho phép là XXX đã cạn kiệt"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Biểu hiện</h4><ul><li><p>Không thể truy cập trang web được lưu trữ trong Plesk:</p><pre>500 Internal Server Error</pre></li><li><p>Lỗi sau được hiển thị trong nhật ký trang web:</p><pre> Đã xảy ra lỗi "Thông báo PHP: Lỗi nghiêm trọng PHP: Kích thước bộ nhớ cho phép là 4194304 byte đã dùng hết (đã cố gắng phân bổ 4000032 byte) trong /var/www/vhosts/example.com/httpdocs/somethingBig.php trên dòng 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Trang web không có đủ bộ nhớ được phân bổ để xử lý.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Tăng memory_limit của trang web',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Đọc bài KB và làm theo hướng dẫn</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "hạn chế open_basedir có hiệu lực"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Biểu hiện</h4><ul><li><p>Không thể truy cập trang web do một trong các lỗi sau trong trình duyệt web:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): hạn chế open_basedir có hiệu lực. Tập tin(/path/to/the/directory) không nằm trong (các) đường dẫn được phép: (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Thông báo lỗi sau xuất hiện trên trang Nhật ký của miền (<strong>Miền</strong> > <strong>example.com</strong> > <strong>Nhật ký</strong>):</p><pre><...> hạn chế open_basedir có hiệu lực. Tập tin(/path/to/the/directory) không nằm trong (các) đường dẫn được phép<...></pre><hr><pre>Ngoại lệ bỏ qua: Phiên: Đường dẫn lưu đã định cấu hình "/path/to/the/directory" không phải là một thư mục, không tồn tại hoặc không thể tạo được.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Tập lệnh PHP đang cố truy cập thư mục không cho phép quyền truy cập. Hạn chế này là do chỉ thị <code>open_basedir</code> PHP xác định riêng lẻ cho từng miền. Theo mặc định, <code>open_basedir</code> cho phép truy cập vào thư mục gốc tài liệu của miền và <code>tmp</code>, cũng như đường dẫn phiên mặc định của hệ thống.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Thêm đường dẫn bổ sung vào chỉ thị open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Đọc bài KB và làm theo hướng dẫn</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Tắt chỉ thị open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Đi tới trang <strong>Miền &gt example.com &gt Thiết lập PHP</strong> và đặt chỉ thị <code>open_basedir</code> thành "không có".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "Lỗi cấm 403 AH01797: máy khách bị cấu hình máy chủ từ chối"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Biểu hiện</h4><ul><li><p>Trang web hiển thị lỗi tương tự như lỗi sau:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Tập tin nhật ký <code>/var/www/vhosts/system/example.com/logs/error_log</code> chứa các lỗi như sau:</p><pre>AH01797: máy khách bị từ chối theo cấu hình máy chủ: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Cấu hình Apache hiện tại không cho phép truy cập vào trang web.</p><p>Đây là điều bình thường đối với các tập tin như .htaccess và .htpasswd vì các tập tin này không thể truy cập được qua máy chủ web.</p >',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Kiểm tra cấu hình máy chủ và tập tin .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Đọc bài KB và làm theo hướng dẫn</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Không thể truy cập danh mục trang web trong Plesk: Lỗi cấm 403"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Biểu hiện</h4><ul><li><p>Không thể truy cập vị trí cụ thể của trang web, ví dụ: <code>http://example.com/some_folder</code>. Lỗi sau xảy ra:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Lỗi sau xuất hiện trong tập tin <code>/var/www/vhosts/example.com/logs/error_log<code/>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714]AH01276: Không thể cung cấp thư mục /var/www/vhosts/example.com/httpdocs/some_folder/: Không tìm thấy DirectoryIndex trùng khớp (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml), và chỉ mục thư mục do máy chủ tạo bị chỉ thị Tùy chọn cấm</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Thư mục yêu cầu không chứa tập tin chỉ mục hoặc không bật duyệt thư mục.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Thêm một tập tin chỉ mục vào thư mục',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Đọc bài KB và làm theo hướng dẫn</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Bật duyệt thư mục',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Đọc bài KB và làm theo hướng dẫn</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Không thể truy cập danh mục trang web trong Plesk: Lỗi cấm 403"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Biểu hiện</h4><ul><li><p>Không thể truy cập vị trí cụ thể của trang web, ví dụ: <code>http://example.com/some_folder</code>. Lỗi sau xảy ra:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Lỗi sau xuất hiện trong tập tin <code>/var/www/vhosts/example.com/logs/error_log</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714]AH01276: Không thể cung cấp thư mục /var/www/vhosts/example.com/httpdocs/some_folder/: Không tìm thấy DirectoryIndex trùng khớp (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml), và chỉ mục thư mục do máy chủ tạo bị chỉ thị Tùy chọn cấm</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Thư mục yêu cầu không chứa tập tin chỉ mục hoặc không bật duyệt thư mục.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Thêm một tập tin chỉ mục vào thư mục',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Đọc bài KB và làm theo hướng dẫn</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Bật duyệt thư mục',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Đọc bài KB và làm theo hướng dẫn</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "máy chủ đã đạt cài đặt MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Sắp sẵn sàng.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Giới hạn nội dung yêu cầu PHP "máy khách định gửi nội dung quá lớn"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Sắp sẵn sàng.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Giới hạn nội dung yêu cầu PHP "máy khách định gửi nội dung quá lớn"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Sắp sẵn sàng.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Phiên PHP "Lỗi nội bộ máy chủ 503" hoặc "Không thể đọc dữ liệu phiên"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Sắp sẵn sàng.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "Lỗi cấm 403: pcfg_openfile: không thể kiểm tra tập tin htaccess , đảm bảo tập tin có thể đọc"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Biểu hiện</h4><ul><li><p>Trang web được lưu trữ trong Plesk không hoạt động:</p><pre>Bạn không có quyền truy cập / vào máy chủ này.<br> Ngoài ra, đã gặp phải lỗi 403 Forbidden khi cố gắng sử dụng ErrorDocument để xử lý yêu cầu.</pre><p>Thay vì lỗi ở trên, bạn cũng có thể thấy trang trống.</p></li><li><p>Nhật ký lỗi miền trong <strong>Miền &gt example.com &gt Nhật ký</strong> có nội dung sau:</p><pre>(13)Quyền bị từ chối: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: không thể kiểm tra tập tin htaccess, hãy đảm bảo tập tin có thể đọc được và "/var/www/vhosts/example.com/httpdocs/" có thể thực thi được</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Quyền không chính xác đối với tập tin hoặc thư mục của miền.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Sửa lại quyền cho nội dung trang web',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Đọc bài KB và làm theo hướng dẫn</a>.</p></li></ol>',
];