<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Propietats de la clau addicional',
    'additional-key-info.update' => 'Recuperar clau addicional',
    'additional-key-info.updateDescription' => 'Recuperi la clau addicional i instal·li-la.',
    'additional-key-info.download' => 'Descarregar clau',
    'additional-key-info.downloadDescription' => 'Descarregui la clau de llicència actual.',
    'additional-key-info.install' => 'Instal·lar clau',
    'additional-key-info.installDescription' => 'Instal·li la clau de llicència actual.',
    'additional-key-info.revert' => 'Revertir clau',
    'additional-key-info.revertDescription' => 'Reverteixi a la clau de llicència instal·lada anteriorment.',
    'additional-key-info.revertNotAvailableDescription' => 'No s\'ha instal·lat cap clau.',
    'additional-key-info.installSuccess' => 'L\'instal·lació de la clau de llicència ha estat iniciada.',

    'additional-key-revert.title' => 'Reversió de clau addicional',
    'additional-key-revert.success' => 'La clau addicional ha estat revertida.',

    'additional-key-upload.title' => 'Instal·lació d\'una clau de llicència',
    'additional-key-upload.success' => 'La nova clau addicional ha estat carregada.',

    'additional-keys.title' => 'Claus de llicència addicionals',

    'change-owner.title' => 'Reassignació de les subscripcions seleccionades',

    'customers.hint' => 'Aquí pot gestionar els comptes dels seus clients de hosting − crear comptes juntament amb subscripcions de serveis, gestionar la cartera de clients i eliminar comptes. Per tal d\'administrar llocs web, correu o qualsevol altre servei proporcionat a un client, vagi al seu panell del client fent clic a la columna dreta de la llista.',

    'customer-domains.hint' => 'Aquí pot configurar i gestionar llocs web.',

    'customer-subscriptions.hint' => 'Aquí pot gestionar les subscripcions del client.',

    'domains.hint' => 'Aquí pot veure la informació sobre tots els noms de domini registrats al sistema i pot gestionar els serveis de hosting. Per a afegir un domini per vostè o pels seus clients de hosting, simplement faci clic a Afegir domini. Se li demanarà que creï un client i una subscripció mentre es crea un domini o bé que seleccioni un dels existents.',

    'database-servers.title' => 'Servidors de base de dades',

    'database-server-create.title' => 'Nou servidor de base de dades',

    'database-server-properties.title' => 'Servidor de base de dades',

    'database-server-upgrade.drawerTitle' => 'Actualització de MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Actualització completada',
    'database-server-upgrade.drawerSubTitle.line1' => 'El calaix no es pot tancar durant el procés d\'actualització.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Si hi ha algun problema durant l\'actualització, consulta %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'El servidor de bases de dades de MariaDB s\'ha actualitzat a la versió %%releaseVersion%%. Si hi ha cap problema, segueix les instruccions que trobaràs en %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Ja tens la versió LTS instal·lada.',
    'database-server-upgrade.troubleshootingArticle' => 'aquest article de la base de coneixement',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Utilitza %%troubleshootingArticle%% per a detectar els errors d\'actualització de MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Actualitza el teu servidor de bases de dades de MariaDB local a la versió LTS (versió amb suport a llarg termini) més recent.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Et recomanem que facis còpies del servidor abans d\'actualitzar i que iniciïs l\'actualització fora de les hores punta dels llocs web.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Durant l\'actualització de MariaDB, el servidor de Plesk i els llocs web allotjats deixaran d\'estar disponibles. Normalment, l\'actualització de MariaDB transcorre sense problemes i està llesta en 10 minuts, però pot afectar el servidor de totes maneres.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Avís: Si estàs fent servir MariaDB 5.5, el primer que farà Plesk és actualitzar a MariaDB 10.5. Quan l\'actualització s\'hagi complert, torna a iniciar aquest assistent i actualitza a la versió LTS de MariaDB més recent.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Versió actual',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Selecciona la versió a la qual vols actualitzar',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'No hi ha cap actualització important',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Notes de la versió',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Data de publicació: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Data de fi: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Només es poden actualitzar les bifurcacions de MariaDB enviades pels proveïdors del SO o pel proveïdor de MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Comprovacions prèvies',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Analitzant els arxius de configuració de MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analitzant les bases de dades amb mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analitzant la configuració de l\'administrador de paquets',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Consultant WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Per a poder continuar amb l\'actualització, cal que seleccionis totes les caselles. Amb aquest pas, confirmes que estàs d\'acord amb els canvis de configuració que l\'actualització comporta i que tens accés a alguna opció de recuperació.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Per tal de garantir la compatibilitat amb la nova versió, s\'eliminaran les següents variables:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} {count, plural, one {de l\'arxiu {files}} other {dels # arxius: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Opcions de recuperació de l\'accés (Repair Kit i la consola de línies d\'ordres del servidor)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Confirmo que tinc accés SSH al servidor',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Utilitza un client SSH o obra %%sshTerminalExtension%% a una nova pestanya del navegador (no tanquis la finestra de l\'extensió SSH Terminal fins que no finalitzi l\'actualització). Si l\'actualització falla, tenir accés SSH facilita la recuperació.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Extensió SSH Terminal',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Confirmo que tinc accés a Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Obre %%repairKit%% en una nova pestanya del navegador i inicia sessió fent servir les dades credencials d\'administrador. No tanquis l\'extensió Repair Kit fins que no acabi l\'actualització.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Fer còpies de les bases de dades',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Crear una còpia de totes les bases de dades allotjades abans d\'iniciar l\'actualització',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk emmagatzemarà les còpies de les bases de dades al directori %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket no està disponible a Plesk',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Sense WebSocket, no podràs veure els resultats del procés d\'actualització en temps real.',

    'database-server-upgrade.submitPopover.title' => 'Per tal de prevenir una possible pèrdua de dades, et recomanem que, abans de continuar, facis un buidatge de les bases de dades allotjades. Vols continuar sense crear un buidatge?',

    'database-server-databases.title' => 'Bases de dades',

    'database-server-change-password.title' => 'Contrasenya de l\'administrador',

    'home.title' => 'Inici',

    'license.title' => 'Informació de la llicència',

    'primary-key-info.title' => 'Clau de llicència de Plesk',
    'primary-key-info.update' => 'Recuperar claus',
    'primary-key-info.updateDescription' => 'Recuperi les claus de llicència comprades i instal·li-les.',
    'primary-key-info.upload' => 'Instal·lar clau',
    'primary-key-info.uploadDescription' => 'Carregui i instal·li una clau de llicència nova.',
    'primary-key-info.revert' => 'Revertir clau',
    'primary-key-info.revertDescription' => 'Reverteixi a la clau de llicència instal·lada anteriorment.',

    'primary-key-revert.title' => 'Reversió de clau de llicència',
    'primary-key-revert.success' => 'La clau de Plesk ha estat revertida.',

    'primary-key-upload.title' => 'Instal·lació d\'una clau de llicència',
    'primary-key-upload.success' => 'La nova clau de Plesk ha estat carregada.',

    'resellers.hint' => 'Aquí pot gestionar comptes de revenedor — els seus clients que revenen serveis de hosting i que allotgen els seus propis llocs web. Pot crear comptes juntament amb subscripcions de serveis, gestionar els revenedors existents i eliminar comptes.',

    'reseller-customers.hint' => 'Aquí pot configurar i gestionar clients.',

    'reseller-domains.hint' => 'Aquí pot configurar i gestionar llocs web.',

    'reseller-subscriptions.hint' => 'Aquí pot gestionar les subscripcions del revenedor.',

    'subscriptions.hint' => 'Els clients poden obtenir els seus serveis de hosting subscrivint-se a un pla de hosting. Aquí pot gestionar aquestes subscripcions, així com les seves pròpies subscripcions creades per a allotjar els seus llocs web. Per tal d\'administrar llocs web, correu o qualsevol altre servei proporcionat amb una subscripció, vagi al panell del client del subscriptor en qüestió fent clic a l\'enllaç present a la columna dreta de la llista.',

    'server-mail-settings.title' => 'Configuració',
    'server-mail-spam-filter.title' => 'Filtració d\'spam',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Llista negra',
    'server-mail-white-list.title' => 'Llista blanca',
    'server-mail-queue.title' => 'Cua de correu',
    'server-mail-statistics.title' => 'Estadístiques',

    'server-spam-filter.settings' => 'Configuració',
    'server-spam-filter.black-list' => 'Llista negra',
    'server-spam-filter.white-list' => 'Llista blanca',

    'firewall.title' => 'Gestió del firewall',
    'firewall-general.title' => 'General',
    'firewall-general.toggleStatus' => 'Protecció amb firewall',
    'firewall-general.buttonDefault' => 'Restablir al valor predeterminat',
    'firewall-general.buttonPanic' => 'Mode de pànic',
    'firewall-general.confirmationDefault' => 'Està segur que desitja restablir la configuració del firewall als valors predeterminats?',
    'firewall-general.confirmationPanic' => 'Està segur que desitja activar el mode pànic? Els usuaris no podran accedir als seus dominis i és possible que alguns serveis de xarxa deixin de funcionar.',
    'firewall-general.successDefault' => 'La configuració de firewall s\'ha restablert als valors predeterminats.',
    'firewall-general.successPanic' => 'El mode de pànic ha estat activat.',
    'firewall-general.info' => 'A causa de problemes de seguretat, el firewall bloqueja totes les connexions, excepte aquelles permeses de manera explícita. Pot permetre una connexió a través de la creació d\'una regla. Si desitja més informació al respecte, consulti la documentació',
    'firewall-general.interfaces' => 'Interfícies de xarxa',
    'firewall-icmp.title' => 'Protocol ICMP',
    'firewall-rules.title' => 'Regles de firewall',

    'dns.title' => 'Configuració de DNS',
    'dns-records.title' => 'Plantilla de registres de zona',
    'dns-soa-record.title' => 'Plantilla de configuració de la zona',

    'php-handler.title' => 'Configuració per %%name%%',
    'php-handler.extensions.title' => 'Extensions',
    'php-handler.extensions.description' => 'La configuració d\'aquestes extensions PHP només es aplicable a aquest controlador.',
    'php-handler.extensions.descriptionShared' => 'Aquesta configuració és comuna pels següents controladors de PHP: %%handlers%%. La configuració és aplicable a tots els llocs web que utilitzen aquests controladors.',
    'php-handler.extensions.buttonManage' => 'Administrar paquets PECL',
    'php-handler.extensions.manage.title' => 'Administrar paquets PECL',
    'php-handler.extensions.manage.risks' => 'Les extensions PHP són proporcionades per paquets PECL de tercers. Instal·li-les sota la seva pròpia responsabilitat.',
    'php-handler.extensions.manage.description' => 'Instal·li, actualitzi i desinstal·li paquets PECL. Els canvis s\'aplicaran a tots els llocs web que s\'executin sota %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Per què el paquet desitjat no apareix a la llista?',
    'php-handler.extensions.manage.limitations' => 'Les extensions PHP proporcionades pel proveïdor del panell de control i els proveïdors del SO no es mostren a la llista.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Actualitzar",
    'ServerInformation.sectionGeneral' => "General",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Versió",
    'ServerInformation.os' => "Sistema operatiu",
    'ServerInformation.key' => "Clau de llicència de Plesk",
    'ServerInformation.uptime' => "Temps d'activitat",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dia} other {# dies}} {hours, plural, one {# hora} other {# hores}} {minutes, plural, one {# minut} other {# minuts}}",
    'ServerInformation.sectionCpu' => "Ús de la CPU",
    'ServerInformation.la1min' => "Últim minut",
    'ServerInformation.la5min' => "Últims 5 minuts",
    'ServerInformation.la15min' => "Últims 15 minuts",
    'ServerInformation.sectionMemory' => "Ús de la memòria",
    'ServerInformation.memoryHardware' => "Maquinari",
    'ServerInformation.memoryTotalNoKernel' => "Total (sense el kernel)",
    'ServerInformation.memoryTotal' => "Total",
    'ServerInformation.memoryUsed' => "Utilitzat",
    'ServerInformation.memoryFree' => "Buit",
    'ServerInformation.memoryShared' => "compartida",
    'ServerInformation.memoryBuffer' => "Búfer",
    'ServerInformation.memoryCached' => "En memòria cau",
    'ServerInformation.memoryAvailable' => "Disponible",
    'ServerInformation.memoryUsage' => "Ús",
    'ServerInformation.sectionSwap' => "Ús d'swap",
    'ServerInformation.sectionVirtualMemory' => "Ús de la memòria virtual",
    'ServerInformation.swapTotal' => "Total",
    'ServerInformation.swapUsed' => "Utilitzat",
    'ServerInformation.swapFree' => "Buit",
    'ServerInformation.swapUsage' => "Ús",
    'ServerInformation.sectionHarddisk' => "Ús del disc dur",
    'ServerInformation.harddiskDirectory' => "Sistema d'arxius",
    'ServerInformation.harddiskProtectedDir' => "Directoris protegits",
    'ServerInformation.harddiskTotal' => "Total",
    'ServerInformation.harddiskUsed' => "Utilitzat",
    'ServerInformation.harddiskAvailable' => "Disponible",
    'ServerInformation.harddiskCapacity' => "Capacitat",
    'ServerInformation.sectionDomains' => "Dominis",
    'ServerInformation.activeDomains' => "Actiu",
    'ServerInformation.inactiveDomains' => "Inactiu",
    'ServerInformation.problemDomains' => "Problemes",
    'ServerInformation.refreshed' => "Informació actualitzada.",

    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Tots els drets reservats.',
    'ServerAbout.linkLicenseManagement' => 'Anar a la informació de la llicència',
    'ServerAbout.panelVersion' => 'Versió',
    'ServerAbout.installedPatchVersion' => 'Actualització #%%patch%%',
    'ServerAbout.licenseKey' => 'Clau de llicència',
    'ServerAbout.productDescription' => 'Plesk és la plataforma líder per a WebOps per a l\'execució, automatització i escalació de negocis de hosting, aplicacions i llocs web.',
    'ServerAbout.readEula' => 'Llegeixi el %%link%%.',
    'ServerAbout.linkEula' => 'Contracte de llicència de l\'usuari final',
    'ServerAbout.visitForum' => 'Visiti %%link%%',
    'ServerAbout.linkForum' => 'Fòrum de Plesk',
    'ServerAbout.followUs' => 'Segueixi\'ns',
    'ServerAbout.visitSite' => 'Més informació a %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Inspiri\'s a %%link%%',
    'ServerAbout.linkBlog' => 'Blog de Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Felicitats!',
    'ServerAbout.darkThemePromoDescription' => 'Ha trobat un gatet màgic afegit durant l\'aniversari de Plesk Obsidian 18.0.50.',
    'ServerAbout.darkThemePromoButton' => 'Apa! Vingui al costat fosc',
    'ServerAbout.darkThemeTourDescription' => 'Canviï a aquesta opció per activar o desactivar el tema fosc per la seva interfície.',
    'ServerAbout.darkThemeTourButton' => 'Entesos',

    'ts-sessions.title' => 'Sessions de servidor de terminals',
    'ts-sessions-properties.title' => 'Propietats de la sessió',

    'BandwidthLimiting.bandwidthThrottling' => 'No pot controlar la limitació de l\'amplada de banda perquè no s\'ha instal·lat QoS.',
    'BandwidthLimiting.virtualHostingRequired' => 'La limitació d\'amplada de banda només està disponible per dominis amb hosting web.',
    'BandwidthLimiting.bandwidthLabel' => 'Ús màxim d\'amplada de banda',
    'BandwidthLimiting.bandwidthHint' => 'El límit d\'ús d\'amplada de banda només s\'aplica a les dades transferides mitjançant el protocol HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Connexions limitades a',
    'BandwidthLimiting.maxConnectionHint' => 'Si limita l\'amplada de banda, li recomanem que també limiti el nombre de connexions simultànies al lloc web. En cas contrari, en cas d\'experimentar sol·licituds freqüents al lloc web, els processos del servidor web augmentaran la càrrega del servidor.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'La configuració de limitació d\'amplada de banda ha estat modificada.',
    'BandwidthLimiting.unlimited' => 'Il·limitats',

    'ip-address-domains.title' => 'Llocs web que utilitzen l\'adreça IP %%ipAddress%% %%type%%',
    'ip-address-domains.site' => 'Lloc',
    'ip-address-domains.setAsDefault' => 'Establir com a predeterminat',
    'ip-address-domains.type-SHARED' => 'compartida',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicada',

    'HotlinkProtection.virtualHostingRequired' => 'La protecció hotlink només es troba disponible per dominis amb hosting web.',
    'HotlinkProtection.enabledLabel' => 'Activar protecció hotlink',
    'HotlinkProtection.extensionsLabel' => 'Extensions d\'arxiu protegides',
    'HotlinkProtection.friendsLabel' => 'Adreces de llocs web coneguts',
    'HotlinkProtection.success' => 'La configuració de protecció hotlink ha estat actualitzada.',

    'Odbc.add' => 'Afegir ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% creat / %%allowed%% permès.',
    'Odbc.limitExceeded' => 'S\'ha excedit el límit de la connexió DSN ODBC.',
    'Odbc.unlimited' => 'Il·limitats',
    'Odbc.addTooltip' => 'Afegeixi un origen de dades ODBC.',
    'Odbc.status' => 'Estat',
    'Odbc.name' => 'Nom de la connexió',
    'Odbc.driver' => 'Controlador',
    'Odbc.description' => 'Descripció de la connexió',
    'Odbc.hostname' => 'Nom del host',
    'Odbc.statusSystem' => 'És un DSN de sistema.',
    'Odbc.statusConfigured' => 'DSN configurat.',
    'Odbc.statusNotConfigured' => 'DSN no configurat.',
    'Odbc.noSelectionText' => 'Seleccioni un o més elements a eliminar.',
    'Odbc.removeConfirmation' => 'Està segur que desitja eliminar {count, plural, one {}=1 {la connexió {name}} other {les # connexions seleccionades}}?',
    'Odbc.removeSuccess' => 'Les connexions seleccionades han estat eliminades.',

    'DomainAliasSettings.title' => 'Configuració d\'àlies de domini',
    'DomainAliasSettings.updateSuccess' => 'Les propietats de l\'àlies de domini %%name%% han estat modificades. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'La configuració del lloc web s\'aplicarà d\'aquí a %%restartInterval%% minuts.',

    'Home.Backup.title' => 'Últim backup del servidor',
    'Home.Backup.offStatus' => 'Aquest backup no és vàlid. No es poden restaurar les dades d\'aquest arxiu.',
    'Home.Backup.task-failedStatus' => 'Error en la tasca de backup.',
    'Home.Backup.activeSchedule' => 'Programació: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Programació: %%schedules%%',
    'Home.Backup.noSchedule' => "No s'ha determinat una programació de backups",
    'Home.Backup.period_hourly' => 'Més d\'un cop al dia %%schedule%%',
    'Home.Backup.period_daily' => 'Diàriament %%schedule%%',
    'Home.Backup.period_weekly' => 'Semanalment %%schedule%%',
    'Home.Backup.period_monthly' => 'Mensualment %%schedule%%',
    'Home.Backup.create' => 'Creï un backup',
    'Home.Backup.schedule' => 'Programació',
    'Home.ChangeLog.title' => 'Novetats',
    'Home.ChangeLog.seeHistory' => 'Veure l\'historial de canvis',
    'Home.CustomButtons.title' => 'Botons personalitzats',
    'Home.CustomButtons.add' => 'Afegir botó personalitzat',
    'Home.CustomButtons.noButtons' => 'No hi ha cap botó personalitzat',
    'Home.Customization.title' => 'Tauler',
    'Home.Customization.description' => 'Esculli quines opcions desitja veure',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Servidor',
    'Home.Customization.securitySection' => 'Seguretat',
    'Home.Customization.backup' => 'Últim backup',
    'Home.Customization.ipBan' => 'Prohibició d\'adreces IP',
    'Home.Customization.mailQueue' => 'Cua de correu',
    'Home.Customization.mySubscriptions' => 'Les meves subscripcions',
    'Home.Customization.overusedSubscriptions' => 'Subscripcions amb sobreús',
    'Home.Customization.serverInfo' => 'Informació del servidor',
    'Home.Customization.updates' => 'Actualitzacions de Plesk',
    'Home.Customization.promo' => 'Promoció',
    'Home.Customization.changeLog' => 'Novetats',
    'Home.Customization.customButtons' => 'Botons personalitzats',
    'Home.EmptyView.title' => 'Per a treure-li tot el partit possible al panell, esculli quines opcions vol veure i quines no.',
    'Home.EmptyView.titleLocked' => 'El seu proveïdor de serveis ha bloquejat el panell.',
    'Home.EmptyView.customize' => 'Personalitzar',
    'Home.Extension.title' => 'Extensió',
    'Home.IpBan.title' => 'Prohibició d\'adreces IP',
    'Home.IpBan.banned' => 'Prohibides',
    'Home.IpBan.trusted' => 'De confiança',
    'Home.IpBan.more' => 'Veure\'n més',
    'Home.MailQueue.title' => 'Cua de correu',
    'Home.MailQueue.total' => 'Total',
    'Home.MailQueue.deferred' => 'Ajornats',
    'Home.MailQueue.held' => 'En espera',
    'Home.MailQueue.more' => 'Veure\'n més',
    'Home.MailQueue.clean' => 'Esborrar cua de correu',
    'Home.MailQueue.checkLogs' => 'Comprovar registres',
    'Home.MailQueue.repair' => 'Reparar',
    'Home.MailQueue.cleanConfirmQuestion' => 'Desitja esborrar la cua de correu?',
    'Home.MailQueue.cleanConfirmYes' => 'Sí',
    'Home.MailQueue.cleanConfirmNo' => 'No',
    'Home.MailQueue.queueCleaned' => 'La cua de correu s\'ha esborrat correctament.',
    'Home.OverusedSubscriptions.title' => 'Subscripcions amb sobreús',
    'Home.OverusedSubscriptions.empty' => 'No s\'han trobat subscripcions amb sobreús',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% de %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Veure totes les que tenen sobreús: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Obrir a la llista',
    'Home.PromoNewHomeView.title' => 'Li donem la benvinguda a la nova pàgina inicial!',
    'Home.PromoNewHomeView.description' => 'En cas d\'experimentar algun problema, faci\'ns arribar els detalls d\'aquest. Això ens ajudarà a implementar futures millores.',
    'Home.PromoNewHomeView.feedback' => 'Comparteixi els seus comentaris',
    'Home.PromoNewHomeView.switch' => 'Tonar a "Inici"',
    'Home.ServerInfo.title' => 'Informació del servidor',
    'Home.ServerInfo.hostname' => 'Nom del host',
    'Home.ServerInfo.ipAddress' => 'Adreça IP',
    'Home.ServerInfo.publicIpAddress' => 'Adreça IP pública',
    'Home.ServerInfo.os' => 'SO',
    'Home.ServerInfo.uptime' => 'Temps d\'activitat',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dia} other {# dies}} {hours, plural, one {# hora} other {# hores}} {minutes, plural, one {# minut} other {# minuts}}",
    'Home.ServerInfo.more' => 'Veure\'n més',
    'Home.Subscriptions.title' => 'Les meves subscripcions',
    'Home.Subscriptions.add' => 'Afegir nova',
    'Home.Subscriptions.empty' => 'Crea subscripcions per a allotjar múltiples llocs web en un espai aïllat del servidor. %%link%%',
    'Home.Subscriptions.help' => 'Més informació',
    'Home.Updates.title' => 'Actualitzacions de producte',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%%, actualització %%patch%%',
    'Home.Updates.manageComponents' => 'Afegir o eliminar components',
    'Home.Updates.lastUpdated' => 'Darrera actualització el %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Cercar actualitzacions',
    'Home.Updates.enableAutoupdate' => 'Permetre actualitzacions automàtiques',
    'Home.Updates.lastChecked' => 'Darrera comprovació: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% disponible',
    'Home.Updates.installNewVersion' => 'Instal·lar ara',
    'Home.Updates.patchAvailable' => 'Hi ha actualitzacions menors disponibles',
    'Home.Updates.patchAvailableVersion' => 'Hi ha actualitzacions menors disponibles per %%currentVersion%%',
    'Home.Updates.installPatch' => 'Actualitzar ara',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Hi ha una actualització per a {package} disponible} other {Hi ha actualitzacions per a {package} disponibles}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# paquet} other {# paquets}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Actualitzar} other {Actualitzar-ho tot}}',
    'Home.Promo.Customize.title' => 'Personalitzi el panell al seu gust!',
    'Home.Promo.Customize.content' => 'Amb el nou panell personalitzable, tindrà les seves aplicacions preferides a l\'abast en tot moment',
    'Home.Promo.Customize.action' => 'Personalitzar',
    'Home.Promo.SwitchToPuv.title' => 'Coneix les vistes d\'interfície a Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Si no proporciona serveis de hosting als seus clients emprant plans de servei, potser desitja provar la interfície més convenient per a administrar els llocs web, els seus arxius, bases de dades, comptes d\'email i aplicacions web.',
    'Home.Promo.SwitchToPuv.action' => 'Provar',
    'Home.Status.error' => 'Error',
    'Home.Status.warning' => 'Advertiment',
    'Home.Status.info' => 'Informació',

    'HostingSettings.title' => 'Configuració de hosting',
    'HostingSettings.updateSuccess' => 'La configuració ha estat actualitzada.',
    'HostingSettings.emptyLogin' => 'Indiqui un nom d\'usuari.',
    'HostingSettings.emptyPassword' => 'Indiqui una contrasenya.',
    'HostingSettings.ipV6OnlyNotSupported' => 'El servidor FTP no suporta IPv6. Assigni almenys una adreça IPv4, ja que sinó l\'usuari no podrà carregar arxius al servidor mitjançant FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Configuració del domini',
    'HostingSettings.domainSettingsSection.domainName' => 'Nom de domini',
    'HostingSettings.domainSettingsSection.description' => 'Per exemple, example.com ',

    'HostingSettings.submitPopover.title' => 'Eliminar el contingut de %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'En cas de canviar el tipus En cas de hosting "Lloc web" a "%%type%%", el contingut En cas de tot el lloc web serà eliminat En cas de forma permanent, incloent-hi els següents directoris:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Desitja modificar el tipus de hosting pel seu lloc web?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Para accedir a més opcions de configuració, indiqui les credencials de l\'usuari del sistema i faci clic a "Crear espai web".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Para accedir a més opcions de configuració, faci clic a "Següent" para crear hosting.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Tipus de hosting',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tipus',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Lloc web',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Reenviament',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Sense hosting web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Utilitzi la zona DNS del domini per tenir bústies de correu sota aquest nom de domini',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'La ruta al directori inicial del lloc web',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Domini preferit',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Els visitants seran redireccionats aquí mitjançant un redireccionament HTTP 301 respectuós amb el SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Reenviar visitants a',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Tipus de redireccionament',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Mogut de forma permanent (codi 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redireccioni els visitants del lloc web a un altre lloc i mostri l\'adreça de destí. Aquest redireccionament preservarà el posicionament de cerca del lloc',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Mogut de forma temporal (codi 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redireccioni els visitants del lloc web a una còpia temporal del lloc quan no desitgi que els buscadors indexin aquest lloc temporal.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Redireccionament per marcs',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redireccioni els visitants del lloc web a un altre lloc sense mostrar l\'adreça de destí perquè així no siguin conscients d\'aquest redireccionament.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Domini preferit',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Cap',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Arrel del document',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'No és possible modificar l\'arrel del document perquè en aquest lloc web s\'han instal·lat aplicacions web.',
    'HostingSettings.domainSettingsSection.save' => 'Desar',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Mode de compatibilitat',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Operar el lloc web en mode de compatibilitat per l\'opció en desús "Separar contingut SSL/TLS i no SSL/TLS"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Aquest lloc web s\'està executant amb el mode de compatibilitat i no es pot gestionar a través de la interfície de Plesk. Això ha succeït perquè has fet servir l\'opció obsoleta "SSL/TLS separats i contingut no SSL/TLS" abans de l\'actualització. A partir de Plesk 11, els llocs web emmagatzemen tot el seu contingut disponible a través de connexions HTTP i HTTPS al mateix directori. Et recomanem que traslladis totes les dades del directori \'httpsdocs/\' a \'httpdocs/\' i, després, desactivis el mode de compatibilitat. Això també provocarà que les aplicacions instal·lades al directori \'httpsdocs/\' siguin accessibles per internet. Recorda que no podràs tornar a activar el mode de compatibilitat.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Canviar aquesta opció?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'El canvi d\'aquesta opció contradiu la directiva de seguretat del servidor i pot afectar negativament al rendiment o exposar el servidor a atacs.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Canviar',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Revertir',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'S\'aplica la configuració de seguretat predeterminada',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Si desitja gaudir d\'una millor seguretat, apliqui la configuració de seguretat predeterminada. Tingui en compte que alguns permisos permeten als subscriptors modificar aquestes opcions.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Aplicar configuració segura',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Obtingui més informació sobre la configuració de hosting segura',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Suport d\'SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Activat',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Xifri les connexions entre el lloc web i el navegador del visitant.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Per activar HTTPS, carregui un certificat SSL/TLS al repositori del domini i seleccioni\'l aquí.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redireccionar els visitants de HTTP a HTTPS mitjançant un redireccionament 301 respectuós amb el SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Al seu repositori no hi ha cap certificat SSL/TLS. Si desitja afegir un certificat, vagi a %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'aquesta pàgina',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (un altre repositori)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'No seleccionat',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Scripting web',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Seleccioni els idiomes de scripting i programació que ha d\'interpretar el servidor web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'el directori cgi-bin es troba a %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Utilitzar SSI per arxius *.htm i *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versió de Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documents d\'error personalitzats',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'el directori cgi-bin es troba a',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'l\'arrel del document d\'aquest domini',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'el directori arrel de l\'espai web',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'l\'arrel d\'aquest domini en l\'estil anterior',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documents d\'error personalitzats',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Permisos d\'escriptura/modificació addicionals',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publicació Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Estadístiques web',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Eina',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Protegir l\'accés a les seves estadístiques web amb les seves credencials FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Desactivat',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Configuració de l\'espai web',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Adreces IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Quota d\'espai en disc',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Activat',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Prohibeixi operacions sobre els arxius del lloc web en cas que s\'excedeixi la quota d\'espai en disc definida a la configuració de la subscripció (si ho està).',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'No se suporta la quota de disc dur a causa de la configuració del sistema d\'arxius del servidor.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Credencials de l\'usuari del sistema',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gestioni carpetes i arxius del lloc web mitjançant FTP o l\'administrador d\'arxius. Accedeixi al servidor mitjançant SSH, si es permet.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gestioni carpetes i arxius del lloc web mitjançant FTP o l\'administrador d\'arxius. Accedeixi al servidor mitjançant Escriptori Remot, si es permet.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nom d\'usuari',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Contrasenya',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Indiqui aquí una contrasenya nova per canviar la contrasenya de l\'usuari del sistema.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Accés SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Accés a Escriptori remot',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Activat',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Accedeixi al servidor amb les credencials de l'usuari del sistema.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tipus',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Desactivat',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Per {count, plural, one {}other {# dominis}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Les següents opcions són mútues per {count, plural, one {}other {tots els # dominis presents a l\'espai web {name}}}:',

    'OdbcAdd.title' => 'Afegir un ODBC DSN',
    'OdbcAdd.nameLabel' => 'Nom de la connexió',
    'OdbcAdd.descriptionLabel' => 'Descripció de la connexió',
    'OdbcAdd.driver' => 'Controlador',
    'OdbcAdd.submit' => 'Crear DSN ODBC',

    'OdbcEdit.title' => 'Configurar una connexió ODBC',
    'OdbcEdit.saveSuccess' => 'La configuració de connexió ha estat desada.',
    'OdbcEdit.test' => 'Verificar la connexió',
    'OdbcEdit.connectSuccess' => 'Connexió establerta correctament.',

    'OdbcEdit.excel.driver.label' => 'Controlador',
    'OdbcEdit.excel.dbq.label' => 'Ruta a l\'arxiu de la base de dades',
    'OdbcEdit.excel.defaultdir.label' => 'Directori de dades predeterminat',
    'OdbcEdit.excel.fil.label' => 'Versió de la base de dades',
    'OdbcEdit.excel.maxbuffersize.label' => 'Tamany màx del buffer',
    'OdbcEdit.excel.pagetimeout.label' => 'Temps d\'espera de la pàgina',

    'OdbcEdit.access.driver.label' => 'Controlador',
    'OdbcEdit.access.dbq.label' => 'Ruta a l\'arxiu de la base de dades',
    'OdbcEdit.access.uid.label' => 'ID d\'accés',
    'OdbcEdit.access.pwd.label' => 'Contrasenya',
    'OdbcEdit.access.pagetimeout.label' => 'Temps d\'espera de la pàgina',
    'OdbcEdit.access.pagetimeout.description' => 'El període de temps, en desenes de segons, que una pàgina no utilitzada pot romandre al buffer. Aquesta opció s\'aplica a tots els orígens de dades que utilitzin el controlador de Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Tamany màx del buffer',
    'OdbcEdit.access.maxbuffersize.description' => 'El tamany del buffer intern (en KB) alineat en blocs de 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Només lectura',
    'OdbcEdit.access.readonly.description' => 'Designa la base de dades com a només de lectura per tal de no permetre cap actualització.',
    'OdbcEdit.access.exclusive.label' => 'Exclusiva',
    'OdbcEdit.access.exclusive.description' => 'Designa la base de dades com a exclusiva per tal de no permetre actualitzacions compartides.',
    'OdbcEdit.access.safetransactions.label' => 'Transaccions segures',
    'OdbcEdit.access.safetransactions.description' => 'Si s\'estableix a 0 (l\'opció predeterminada), totes les transaccions s\'apliquen d\'immediat. Si s\'estableix a 1, totes les transaccions es desen al disc un cop finalitzada l\'operació, si bé cal que tingui en compte que el rendiment es degradarà lleugerament.',
    'OdbcEdit.access.threads.label' => 'Fils',
    'OdbcEdit.access.threads.description' => 'El número de subprocessos en segon terme que utilitzarà el motor.',
    'OdbcEdit.access.maxscanrows.label' => 'Màx. de files a analitzar',
    'OdbcEdit.access.maxscanrows.description' => 'El número de files a examinar quan s\'estableix el tipus de dades d\'una columna segons les dades existents.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Especifica la forma en que s\'escriuen a la base de dades els canvis efectuats fora d\'una transacció.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Especifica si el controlador de MS Access efectuarà les transaccions definides explícitament per l\'usuari de forma asincrònica.',

    'OdbcEdit.mssql.driver.label' => 'Controlador',
    'OdbcEdit.mssql.server.label' => 'Servidor',
    'OdbcEdit.mssql.uid.label' => 'ID d\'accés',
    'OdbcEdit.mssql.pwd.label' => 'Contrasenya',
    'OdbcEdit.mssql.database.label' => 'Base de dades predeterminada',
    'OdbcEdit.mssql.app.label' => 'Nom de l\'aplicació',
    'OdbcEdit.mssql.wsid.label' => 'ID de la workstation',
    'OdbcEdit.mssql.language.label' => 'Idioma predeterminat',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversió de caràcters ampliats a valors OEM',

    'OdbcEdit.mysql.driver.label' => 'Controlador ODBC de MySQL',
    'OdbcEdit.mysql.server.label' => 'Servidor',
    'OdbcEdit.mysql.server.description' => 'El nom de host del servidor MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'Base de dades predeterminada',
    'OdbcEdit.mysql.user.label' => 'Nom d\'usuari',
    'OdbcEdit.mysql.user.description' => 'El nom d\'usuari utilitzat per a connectar-se a MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Contrasenya',
    'OdbcEdit.mysql.password.description' => 'La contrasenya del compte d\'usuari al servidor',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'El port TCP/IP a utilitzar si el servidor no és el host local',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Canal amb nom Windows al que connectar-se si el servidor és el host local',
    'OdbcEdit.mysql.option.label' => 'Opció',
    'OdbcEdit.mysql.option.description' => 'Opcions que especifiquen com ha de funcionar MyODBC. Examini la <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentació</a>',

    'ProtectedDirectoryList.add' => 'Afegir directori protegit',
    'ProtectedDirectoryList.addTooltip' => 'Creï un directori protegit.',
    'ProtectedDirectoryList.name' => 'Nom',
    'ProtectedDirectoryList.realmTitle' => 'Títol de l\'àrea protegida',
    'ProtectedDirectoryList.noSelectionText' => 'Seleccioni un o més elements a eliminar.',
    'ProtectedDirectoryList.edit' => 'Editar',
    'ProtectedDirectoryList.remove' => 'Eliminar protecció',
    'ProtectedDirectoryList.removeTooltip' => 'Elimini la protecció dels directoris seleccionats.',
    'ProtectedDirectoryList.removeConfirmation' => 'Como a resultat d\'aquesta operació, s\'eliminarà la protecció {count, plural, one {}=1 {del directori {name}} other {dels # directoris seleccionats}}. {count, plural, one {}=1 {Els usuaris d\'Internet podran accedir a aquest directori} other {Els usuaris d\'Internet podran accedir a aquests directoris}}.',
    'ProtectedDirectoryList.removeSuccess' => 'Els directoris seleccionats han estat eliminats.',

    'ProtectedDirectoryAdd.title' => 'Crear directori protegit',
    'ProtectedDirectoryAdd.submit' => 'Crear',
    'ProtectedDirectoryAdd.success' => 'El directori protegit %%path%% s\'ha creat correctament',

    'ProtectedDirectoryEdit.title' => 'Configuració de directori protegit',
    'ProtectedDirectoryEdit.success' => 'La configuració del directori protegit ha estat modificada',

    'ProtectedDirectoryUserList.add' => 'Afegir usuari',
    'ProtectedDirectoryUserList.addTooltip' => 'Crea comptes d\'usuari que puguin accedir al directori protegit %%directory%%',
    'ProtectedDirectoryUserList.login' => 'Nom',
    'ProtectedDirectoryUserList.changePassword' => 'Canviar contrasenya',
    'ProtectedDirectoryUserList.noSelectionText' => 'Selecciona l\'usuari o usuaris que vulguis eliminar.',
    'ProtectedDirectoryUserList.remove' => 'Eliminar',
    'ProtectedDirectoryUserList.removeTooltip' => 'Elimina els usuaris seleccionats.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Vols eliminar {count, plural, =1 {l\'usuari {login}} other {els # usuaris}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'S\'han eliminat els usuaris seleccionats.',

    'ProtectedDirectoryUserAdd.title' => 'Crear un usuari de directori protegit',
    'ProtectedDirectoryUserAdd.subtitle' => 'Directori %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Nom d\'usuari',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Contrasenya',
    'ProtectedDirectoryUserAdd.submit' => 'Crear',
    'ProtectedDirectoryUserAdd.success' => 'S\'ha creat l\'usuari de directori protegit %%login%%.',

    'ProtectedDirectoryUserPassword.title' => 'Contrasenya per l\'usuari del directori protegit',
    'ProtectedDirectoryUserPassword.subtitle' => 'Usuari %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Contrasenya',
    'ProtectedDirectoryUserPassword.submit' => 'Desar',
    'ProtectedDirectoryUserPassword.success' => 'Les credencials de l\'usuari han estat desades.',

    'SummaryReport.Layout.title' => 'Propietats de la presentació d\'informe',
    'SummaryReport.Layout.success' => 'La presentació d\'informe %%name%% ha estat actualitzada.',
    'SummaryReport.Layouts.title' => 'Presentacions d\'informe',

    'SummaryReport.Layout.Add.title' => 'Crear presentació d\'informe',
    'SummaryReport.Layout.Add.success' => 'La presentació d\'informe %%name%% ha estat creada.',

    'SummaryReport.Report.title' => 'Informe resumit',
    'SummaryReport.Report.buttonLayouts' => 'Dissenys',
    'SummaryReport.Report.buttonSchedule' => 'Programació',
    'SummaryReport.Report.buttonProperties' => 'Propietats',
    'SummaryReport.Report.buttonTrafficHistory' => 'Historial de trànsit',
    'SummaryReport.Report.buttonPrint' => 'Imprimir',
    'SummaryReport.Report.buttonSend' => 'Enviar per correu electrònic',
    'SummaryReport.Report.successSent' => 'L\'informe s\'ha enviat a %%email%%',

    'SummaryReport.Schedule.title' => 'Programacions d\'entrega per %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Programació d\'entrega per %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'La programació d\'entrega d\'informes ha estat actualitzada.',

    'SummaryReport.Schedule.Add.title' => 'Crear programacions d\'entrega per a %%name%%',
    'SummaryReport.Schedule.Add.success' => 'La programació d\'entrega d\'informes ha estat creada.',

    'SummaryReport.TrafficHistory.title' => 'Historial de trànsit',

    'VirtualDirectory.errNotExist' => 'El directori virtual està vinculat a una carpeta física que no existeix.',
    'VirtualDirectory.errNoPermissions' => 'No disposa del permís necessari per a veure el contingut d\'aquest directori.',
    'VirtualDirectory.buttonProperties' => 'Propietats del directori',
    'VirtualDirectory.buttonPropertiesHint' => 'Vegi i canviï les propietats del directori virtual.',
    'VirtualDirectory.buttonPermissions' => 'Permisos d\'accés al directori',
    'VirtualDirectory.buttonPermissionsHint' => 'Configuri els permisos d\'accés al directori.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Configurar opcions d\'ASP.NET.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Configurar opcions de PHP.',
    'VirtualDirectory.buttonMimeTypes' => 'Tipus MIME',
    'VirtualDirectory.buttonMimeTypesHint' => 'Administrar els tipus MIME registrats.',
    'VirtualDirectory.buttonErrorDocs' => 'Documents d\'error',
    'VirtualDirectory.buttonErrorDocsHint' => 'Administrar els documents d\'error.',
    'VirtualDirectory.buttonProtection' => 'Protecció',
    'VirtualDirectory.buttonProtectionHint' => 'Restringeixi l\'accés al directori establint una contrasenya.',

    'VirtualDirectory.CreateDirectory.title' => 'Creació de directori',
    'VirtualDirectory.CreateDirectory.name' => 'Nom del directori',
    'VirtualDirectory.CreateDirectory.success' => 'S\'ha creat el directori %%name%%.',
    'VirtualDirectory.CreateDirectory.errExists' => 'El directori %%name%% ja existeix.',

    'VirtualDirectory.AspDotNet.title' => 'Configurar opcions d\'ASP.NET',

    'VirtualDirectory.Php.title' => 'Versió de PHP',
    'VirtualDirectory.Php.version' => 'Versió',
    'VirtualDirectory.Php.success' => 'La versió de PHP s\'ha actualitzat.',
];