<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => '正在 %%path%% 安装 %%name%%...',
    'aps-install.queueNoPath' => '正在安装 %%name%%...',
    'aps-install.done' => '%%name%% 已被成功安装于 %%path%%。您可以看到用于登录以下应用程序的验证凭据。%%additionalMessage%%',
    'aps-install.doneNoPath' => '已成功安装 %%name%%。您可以看到用于登录以下应用程序的验证凭据。%%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% 已被成功安装于 %%path%%。%%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '已成功安装 %%name%%。%%additionalMessage%%',
    'aps-install.error' => '在 %%path%% 安装 %%name%% 失败。%%errorMessage%%',
    'aps-install.errorNoPath' => '安装 %%name%% 失败。%%errorMessage%%',

    'aps-update.queueDownload' => '正在下载 %%packageName%%...',
    'aps-update.errorDownload' => '下载 %%packageName%% 失败：',
    'aps-update.queueInstall' => '正在更新 %%domainName%% 的 %%name%% 安装实例...',
    'aps-update.doneInstall' => '%%domainName%% 的 %%name%% 安装实例已成功更新。',
    'aps-update.errorInstall' => '更新 %%domainName%% 的 %%name%% 安装实例失败：',
    'aps-update.queueInstallMulti' => '更新 %%name%% 的 %%instances%% 安装实例...',
    'aps-update.doneInstallMulti' => '%%name%% 的 %%successes%% 安装实例已成功更新。',
    'aps-update.errorInstallMulti' => '更新 %%name%% 的 %%failures%% 安装实例失败：',
    'aps-update.incorrectUpdateInformation' => '更新信息不正确。',

    'common.hideCompletedTasks' => '个完成项目被隐藏',
    'common.progressBarHide' => '隐藏',
    'common.progressBarShow' => '显示',
    'common.close' => '关闭',
    'common.refresh' => '刷新页面',
    'common.taskInProgress' => '%%count%% 项任务正在进行中...',
    'common.percentCompleted' => '已完成 %%percent%%%',
    'common.allTasksCompleted' => '已成功完成 %%num%% 项任务。',
    'common.minimize' => '最小化',
    'common.statusDone' => '完成',
    'common.statusError' => '失败',
    'common.statusNotStarted' => '进入队列',
    'common.statusCanceled' => '已取消',
    'common.progressDialogLink' => '详细的进程',

    'database-check.queue' => '正在检查 %%database%% 数据库表格...',
    'database-check.done' => '%%database%% 数据库没有错误。',
    'database-check.error' => '无法查看 %%database%% 数据库找出错误。',
    'database-check.done-with-errors' => "%%database%% 数据库有 %%number%% 问题。\n %%link%%",
    'database-check.info-link-title' => '查看详情并解决',

    'database-download.queue' => '正在准备用于导出的 %%database%% 转储...',
    'database-download.done' => '%%database%% 的转储已准备就绪。您可以访问 %%downloadLink%% 下载它。',
    'database-download.downloadLink' => '下载',
    'database-download.error' => '无法导出 %%database%% 的转储：',

    'database-repair.queue' => '正在修复 %%database%% 数据库表格...',
    'database-repair.done' => '%%database%% 数据库没有错误。',
    'database-repair.error' => '%%database%% 数据库。',
    'database-repair.done-with-errors' => "%%database%% 数据库有 %%number%% 问题。\n %%link%%",
    'database-repair.info-link-title' => '查看详情',

    'database-upload.queue' => '正在导入 %%database%% 的转储...',
    'database-upload.done' => '%%database%% 的转储已导入。',
    'database-upload.error' => '无法导入 %%database%% 转储：',
    'database-upload.done-with-errors' => "%%database%% 的转储已导入但出现错误。",
    'database-upload.orphanedUsersSuccess' => '已成功导入数据库 %%database%%。但是，一些用户被孤立（没有在数据库服务器上相关联的登录名）。若要能够访问您的数据库，请给这些用户分配登录名。%%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => '下面的用户被孤立（没有在数据库服务器上相关联的登录名）：%%orphanedUsers%%。',
    'database-upload.orphanedUsersLink' => '查看用户',

    'domain-app-scan.queue' => '正在扫描应用程序...',
    'domain-app-scan.done' => '扫描应用程序已完成。',
    'domain-app-scan.error' => '扫描应用程序已完成但出现错误。',

    'domain-move.queue' => '将 %%domainName%% 移动到 %%webspaceName%%',
    'domain-move.done' => '%%domainName%% 已被移动到 %%webspaceName%%',
    'domain-move.error' => '%%domainName%% 未被移动到 %%webspaceName%%',

    'domain-split.queue' => '将 %%domainName%% 移动到新的订阅',
    'domain-split.done' => '%%domainName%% 已被移动到新的订阅',
    'domain-split.error' => '%%domainName%% 未被移动到新的订阅',

    'file-manager-import-file.done' => '%%fileName%% 文件已导入至 <a href="%%listUrl%%">%%fileDir%% 文件夹</a>。',
    'file-manager-import-file.error' => '无法导入 %%fileName%% 文件：%%errorMessage%%。<br><a href="%%url%%">下载到我的电脑</a>',
    'file-manager-import-file.queue' => '从 %%host%% 导入 %%fileName%% 文件。',
    'file-manager-import-file.progress' => '从 %%host%% (%%value%% MB) 导入 %%fileName%% 文件。',
    'file-manager-import-file.errors.auth' => '发生了验证错误。请确保提供正确的登录名和密码',
    'file-manager-import-file.errors.resolve' => '无法解析 %%host%% 主机名。请确保提供正确的 URL',
    'file-manager-import-file.errors.connect' => '无法连接到 %%host%% 服务器。请确保提供正确的 URL',
    'file-manager-import-file.errors.notFound' => '远程文件未找到或不可访问。请确保提供正确的 URL 且文件可访问',
    'file-manager-import-file.errors.maxSize' => '已超过磁盘空间上限或可用空间 %%diskSpaceLimit%%',
    'file-manager-import-file.errors.lowSpeedTime' => '无法导入文件因为传输速度太慢：在最近 %%lowSpeedTime%% 秒内传输了少于 %%lowSpeedLimit%% 字节。托管文件的网站在此刻可能遇到了大量流量。请稍后尝试导入文件',
    'file-manager-import-file.errors.certificate' => '无法导入文件因为 %%host%% 服务器的 SSL/TLS 证书是不可信的。请确保托管文件的网站使用的是可信证书。',
    'file-manager-import-file.errors.redirects' => '已超过重定向最大数量 (%%maxRedirects%%)。请确保 %%host%% 服务器运行正常。',

    'force-log-rotation.queue' => '應用全球日誌輪轉設定',
    'force-log-rotation.done' => '已經應用了全球日誌輪轉設定。',
    'force-log-rotation.error' => '應用錯誤已得到糾正的全球日誌輪轉',
    'force-log-rotation.systemLogRotationError' => '系統日誌：%%error%%',
    'force-log-rotation.planLogRotationError' => '服務方案 %%name%%：%%error%%',
    'force-log-rotation.domainLogRotationError' => '域名 %%name%%：%%error%%',

    'initial-setup.queue' => '正在初始化 Plesk...',
    'initial-setup.done' => 'Plesk 已被初始化。',
    'initial-setup.doneWithErrors' => '初始化 Plesk 时出现了一个错误。',
    'initial-setup.error' => '初始化 Plesk 失败：',
    'initial-setup.step.setupPanel' => '设置 Plesk Panel',
    'initial-setup.step.requestLicense' => '申请许可证',
    'initial-setup.step.configureServer' => '配置 Web 服务器',
    'initial-setup.step.secureServer' => '保护服务器的安全',

    'ip-update.queue' => '更新 IP 地址',
    'ip-update.done' => '已更新 IP 地址。',
    'ip-update.error' => '更新 IP 地址已完成但出现错误',
    'ip-update.updating' => '更新 IP 地址',
    'ip-update.updatingWebServer' => '更新 IP 地址：更新 Web 服务器',
    'ip-update.updatingFtpServer' => '更新 IP 地址：更新 FTP 服务器',
    'ip-update.updatingDnsZones' => '更新 IP 地址：更新 DNS 区域',
    'ip-update.restartingDnsService' => '更新 IP 地址：重启 DNS 服务器',

    'ip-reload-public.queue' => '使用云元数据更新公共 IP 地址',
    'ip-reload-public.done' => '公共 IP 地址已更新',

    'logrotate_anonymize_ips.queue' => '在日志中隐藏IP 地址',
    'logrotate_anonymize_ips.queueRevert' => '取消日志中的 IP 地址匿名',
    'logrotate_anonymize_ips.done' => 'IP 地址是隐藏的。',
    'logrotate_anonymize_ips.doneRevert' => 'IP 地址取消匿名。',
    'logrotate_anonymize_ips.error' => 'IP 地址隐藏处理错误',
    'logrotate_anonymize_ips.errorRevert' => '取消 IP 地址匿名已完成但出错',

    'panel-components-install.queue' => '正在安装已选的组件。',
    'panel-components-install.done' => '成功安装已选的组件。',
    'panel-components-install.error' => '安装组件失败。含有错误描述的通知已发送至您的邮箱。',

    'panel-update.queue' => 'Plesk 正在安装更新。这可能需要一些时间。%%warning%%',
    'panel-update.warning' => '在更新完成之前，请不要在 Plesk 中执行任何管理操作。',
    'panel-update.done' => 'Plesk 已更新。请在 %%changelog%% 中查看更多信息。',
    'panel-update.changelog' => 'Plesk 更新日志',
    'panel-update.error' => '更新 Plesk 失败。%%errorDetails%%',
    'panel-update.support' => '要解决此问题，请发送更新日志给 Plesk 技术支持。%%failedLog%% 您关闭此信息之前请复制日志到您的电脑上。',
    'panel-update.failedLog' => '查看自 %%date%% 的更新日志。',

    'pum-update-packages.queue' => '正在更新 %%count%% 程序包...',
    'pum-update-packages.done' => '已成功更新 %%count%% 程序包。',
    'pum-update-packages.error' => '更新失败。',

    'scheduler-run-task.queue' => '正在运行任务 "%%task%%"...',
    'scheduler-run-task.done' => '"%%task%%" 任务已在 %%seconds%% 秒内成功完成。',
    'scheduler-run-task.error' => '"%%task%%" 任务已在 %%seconds%% 秒内完成但出现错误。',
    'scheduler-run-task.popupSeeDetails' => '查看详情',
    'scheduler-run-task.popupTitle' => '运行已计划的任务',
    'scheduler-run-task.popupDone' => '"%%task%%" 任务已在 %%seconds%% 秒内成功完成，输出：',
    'scheduler-run-task.popupError' => '"%%task%%" 任务已在 %%seconds%% 秒内完成但出现错误，输出：',
    'scheduler-run-task.popupClose' => '关闭',

    'sdk.queue' => '任务 "%%name%%" 正在进行中...',
    'sdk.error' => '任务 "%%name%%" 失败。',
    'sdk.done' => '已完成任务 "%%name%%"。',
    'sdk.canceled' => '已取消任务 "%%name%%"。',

    'sync-php-settings.queue' => '将全局 PHP %%version%% 设置应用于域名',
    'sync-php-settings.done' => '全局 PHP %%version%% 设置已成功应用于域名',
    'sync-php-settings.error' => '将全局 PHP %%version%% 设置应用于域名时发生错误',

    'sync-service-plan.queue' => '与订阅同步服务方案 %%name%%',
    'sync-service-plan.done' => '服务方案 %%name%% 已成功与订阅同步',
    'sync-service-plan.doneWithErrors' => '同步服务方案 %%name%% 已完成。一些订阅未与方案同步',
    'sync-service-plan.error' => '在与订阅同步服务方案 %%name%% 时发生错误',

    'domain-create.queue' => '创建域名 %%domainName%%',
    'domain-create.done' => '域名 %%domainName%% 已创建',
    'domain-create.error' => '域名 %%domainName%% 创建失败',
    'domain-create.warning' => '域名 %%domainName%% 已创建但有一些问题：<br> %%problems%%',
    'domain-create.refreshUrl' => '查看',
    'domain-create.steps.createCustomer' => '正在创建客户',
    'domain-create.steps.createSubscription' => '创建订阅',
    'domain-create.steps.createDomain' => '添加域名',
    'domain-create.steps.configureDns' => '配置 DNS 区域',
    'domain-create.steps.createHosting' => '创建物理主机',
    'domain-create.steps.configurePhp' => '配置 PHP',
    'domain-create.steps.configureMail' => '配置邮件',

    'domain-delete.queue' => '删除域名处理',
    'domain-delete.done' => '域名已删除',
    'domain-delete.error' => '域名删除失败',
    'domain-delete.step.domains' => '正在删除域名……',

    'domain-resolve-checking.warning' => '检测到域名 %%domainName%% 解析问题：<br> %%errors%%',

    'customer-create.queue' => '创建客户 %%customerName%% 正在处理中',
    'customer-create.done' => '客户 %%customerName%% 已创建',
    'customer-create.error' => '客户 %%customerName%% 创建失败',
    'customer-create.warning' => '客户 %%customerName%% 已创建但有一些问题：<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => '您可以尝试手动将其同步。',

    'customer-delete.queue' => '删除客户处理',
    'customer-delete.done' => '客户已删除',
    'customer-delete.error' => '客户删除失败',

    'reseller-delete.queue' => '删除代理商处理',
    'reseller-delete.done' => '代理商已删除',
    'reseller-delete.error' => '代理商删除失败',

    'subscription-create.queue' => '创建订阅 %%subscriptionName%% 正在处理中',
    'subscription-create.done' => '订阅%%subscriptionName%%已创建',
    'subscription-create.error' => '订阅%%subscriptionName%%创建失败',
    'subscription-create.warning' => '订阅 %%subscriptionName%% 已创建但有一些问题：<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => '您可以尝试手动将其同步。',

    'subscription-delete.queue' => '删除订阅处理',
    'subscription-delete.done' => '订阅已删除',
    'subscription-delete.error' => '订阅删除失败',

    'websites-diagnostic.queue' => '运行网站诊断',
    'websites-diagnostic.done' => '网站诊断完毕',
    'websites-diagnostic.error' => '网站诊断完毕但出错',

    'install-php-extension.queue' => '在 %%phpHandlerName%% PHP 处理程序上安装 %%extensionName%% 包',
    'install-php-extension.done' => '已在 %%phpHandlerName%% PHP 处理程序上安装 %%extensionName%% 包',
    'install-php-extension.error' => '在 %%phpHandlerName%% PHP 处理程序上安装 %%extensionName%% 包失败',
    'install-php-extension.step.validate' => '检查要求',
    'install-php-extension.step.dependencies' => '解决依赖项',
    'install-php-extension.step.process' => '安装程序包',
    'install-php-extension.step.enable' => '启用扩展',
    'install-php-extension.step.sync' => '同步站点',
    'install-php-extension.errorReason' => '可用程序包的列表由PECL提供。安装失败的最常见原因如下：',
    'install-php-extension.errorReasonDependencies' => '- 该程序包对其他库有外部依赖项。',
    'install-php-extension.errorReasonRequirements' => '- 该程序包不满足安装要求（OS、PHP版本等）。',
    'install-php-extension.errorReasonOutdated' => '- 程序包已过时。',
    'install-php-extension.errorOutput' => '若要确定安装失败的原因，请检查实用工具的输出。',

    'uninstall-php-extension.queue' => '从 %%phpHandlerName%% PHP 处理程序上卸载 %%extensionName%% 包',
    'uninstall-php-extension.done' => '已从 %%phpHandlerName%% PHP 处理程序上卸载 %%extensionName%% 包',
    'uninstall-php-extension.error' => '从 %%phpHandlerName%% PHP 处理程序上卸载 %%extensionName%% 包失败',
    'uninstall-php-extension.step.validate' => '检查要求',
    'uninstall-php-extension.step.process' => '卸载程序包',
    'uninstall-php-extension.step.sync' => '同步网站',

    'upgrade-database-server.queue' => '升级数据库服务器',
    'upgrade-database-server.error' => '无法升级数据库服务器',
    'upgrade-database-server.done' => '数据库服务器已升级',
    'upgrade-database-server.step.validate' => '检查系统',
    'upgrade-database-server.step.dump' => '正在创建数据库转储',
    'upgrade-database-server.step.disableService' => '正在禁用旧系统服务',
    'upgrade-database-server.step.configureRepo' => '正在配置新的 repository',
    'upgrade-database-server.step.upgradePackages' => '升级数据库服务器',
    'upgrade-database-server.step.updateConfiguration' => '正在更新服务器配置',
    'upgrade-database-server.step.startService' => '正在启动新系统服务',
    'upgrade-database-server.step.upgradeTablesStructure' => '正在升级所有表格结构',
    'upgrade-database-server.step.sync' => '正在同步系统组件',
    'upgrade-database-server.step.validateInstallation' => '正在验证安装',

    'update-spam-filter-individual-settings.queue' => '正在更新垃圾邮件过滤器设置',
    'update-spam-filter-individual-settings.done' => '垃圾邮件过滤器设置已更新',
    'update-spam-filter-individual-settings.error' => '更新垃圾邮件过滤器设置失败',
    'update-spam-filter-individual-settings.mailNameError' => '电子邮件地址 %%name%%：%%error%%',

    'update-default-cert.queue' => '更新默认证书',
    'update-default-cert.done' => '默认证书已更新。',
    'update-default-cert.error' => '更新默认证书时出错。',
    'update-default-cert.step.updating' => '更新默认证书…',
];