<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'adminaliases.statusActive' => 'アカウントはアクティブです。',
    'adminaliases.statusInactive' => 'このアカウントは一時停止されています。この管理者は Plesk にログインできません。',
    'adminaliases.buttonRemoveAdminAlias' => '削除',
    'adminaliases.hintRemoveAdminAlias' => '選択した管理者アカウントを削除します。',
    'adminaliases.confirmOnRemove' => '選択した管理者アカウントを削除しますか？',
    'adminaliases.buttonAddNewAdminAlias' => '管理者アカウントを追加',
    'adminaliases.hintAddNewAdminAlias' => '追加の管理者アカウントを作成します。',
    'adminaliases.buttonMoreActions' => 'その他',
    'adminaliases.buttonActivateAdminAlias' => 'アクティブ化',
    'adminaliases.hintActivateAdminAlias' => '一時停止された管理者アカウントをアクティブ化します。',
    'adminaliases.buttonDeactivateAdminAlias' => '一時停止',
    'adminaliases.hintDeactivateAdminAlias' => '選択した管理者アカウントを一時停止します。Plesk はこれらの管理者のアクセスを拒否します。',
    'adminaliases.confirmOnDelete' => '選択した管理者アカウントを削除しますか？',
    'adminaliases.login' => 'ユーザー名',
    'adminaliases.contact' => '担当者名',
    'adminaliases.email' => 'メール',
    'adminaliases.comments' => 'コメント',

    'appinfo.installedAt' => 'インストールパス',
    'appinfo.noInstallationUrlAvailable' => 'なし',
    'appinfo.subscriptionName' => '契約',
    'appinfo.subscriptionOwner' => '契約の所有者',
    'appinfo.buttonLogin' => '顧客パネルで開く',
    'appinfo.buttonLoginClassicMode' => 'ホスティング管理',
    'appinfo.hintLogin' => '契約者の顧客パネルを開きます。',
    'appinfo.hintAdminLogin' => '特定のホスティングアカウントに紐付けられたホスティングサービスを管理します（ドメインおよび DNS、ウェブアプリケーションおよびデータベース、メールなど）。',
    'appinfo.hintLoginClassicMode' => '特定のホスティングアカウントに紐付けられたホスティングサービスを管理します（ドメインおよび DNS、ウェブアプリケーションおよびデータベース、メールなど）。',
    'appinfo.update' => 'アップデートが提供されています。',
    'appinfo.updateFailed' => 'アップデートに失敗しました。',
    'appinfo.noUpdates' => 'アップデートが提供されていません。',
    'appinfo.foundUpdates' => '以下のアプリケーションはアップデートが提供されています：',
    'appinfo.buttonCheckForUpdates' => 'アップデートの確認',
    'appinfo.buttonCheckForUpdatesDescription' => '使用可能なアップデートをチェック',
    'appinfo.buttonChangeSettings' => '設定',
    'appinfo.buttonChangeSettingsDescription' => 'アプリケーションについてサーバ全体の設定を変更する',
    'appinfo.appNotConfigured' => '未構成',

    'appuploaded.name' => '名前',
    'appuploaded.numberOfInstances' => 'インストール数',
    'appuploaded.buttonUploadNewApp' => 'アプリケーションを追加',
    'appuploaded.buttonUploadNewAppDescription' => 'アプリケーションパッケージをサーバに追加します。',
    'appuploaded.buttonRemove' => '削除',
    'appuploaded.buttonRemoveDescription' => '選択したパッケージを削除します。',
    'appuploaded.confirmOnDelete' => '選択したパッケージを削除しますか？',
    'appuploaded.appInvisible' => '顧客に対して提供されていません',
    'appuploaded.appGlobalSettingsNotSet' => '未構成',
    'appuploaded.buttonMakeAppVisible' => '使用可能にする',
    'appuploaded.buttonMakeAppVisibleDescription' => 'アプリケーションを顧客がインストールできるようにします。',
    'appuploaded.buttonMakeAppInvisible' => '使用不可にする',
    'appuploaded.buttonMakeAppInvisibleDescription' => 'アプリケーションを顧客がインストールできないようにします。',

    'appusage.name' => '名前',
    'appusage.numberOfInstances' => 'インストール数',
    'appusage.buttonCleanApplicationCache' => 'キャッシュを消去',
    'appusage.buttonCleanApplicationCacheDescription' => 'アプリケーションのインストール中にダウンロードした一時ファイルを削除します。',
    'appusage.buttonRedirectToMarket' => 'オンラインストアに移動',
    'appusage.buttonRedirectToMarketDescription' => 'ウェブサイトにインストールするアプリケーションライセンスを購入します。',
    'appusage.updateFailed' => 'アップデートに失敗しました。',
    'appusage.noUpdates' => 'アップデートが提供されていません。',
    'appusage.foundUpdates' => '以下のアプリケーションはアップデートが提供されています：',
    'appusage.buttonCheckForUpdates' => 'アップデートの確認',
    'appusage.buttonCheckForUpdatesDescription' => 'アプリケーションカタログから利用可能なアップデートを確認します。',
    'appusage.buttonUpdateSettings' => 'アップデート設定',
    'appusage.buttonUpdateSettingsDescription' => 'サーバ全体のアプリケーション更新設定',

    'controlpanelaccessnetworks.ipAddress' => 'IP アドレス',
    'controlpanelaccessnetworks.subnetMask' => 'サブネットマスク',
    'controlpanelaccessnetworks.buttonAddNewNetwork' => 'ネットワークを追加',
    'controlpanelaccessnetworks.buttonAddNewNetworkDescription' => 'クリックして、アクセス制限リストにネットワークを追加します。',
    'controlpanelaccessnetworks.buttonRemove' => '削除',
    'controlpanelaccessnetworks.buttonRemoveDescription' => 'クリックして、選択したネットワークをリストから削除します。',
    'controlpanelaccessnetworks.confirmOnDelete' => '選択したネットワークを削除しますか？',
    'controlpanelaccessnetworks.buttonSettings' => '設定',
    'controlpanelaccessnetworks.buttonSettingsDescription' => 'クリックして、アクセス制限ポリシーを変更します。',
    'controlpanelaccessnetworks.loadingTitle' => '読み込み中...しばらくお待ちください。',

    'customers.filterCustomerName' => '顧客名',
    'customers.filterSubscription' => '契約',
    'customers.filterOptionSubscriptionAny' => 'すべて',
    'customers.filterOptionSubscriptionMy' => 'マイ・プラン',
    'customers.filterOptionSubscriptionReseller' => '%%planOwnerContactName%%のプラン', // Note for translators: you can use here structure like "Plans of Reseller <name>" or alike if it is more convenient
    'customers.filterOptionSubscriptionCustom' => 'カスタム',
    'customers.filterOwnership' => 'プロバイダ',
    'customers.filterOptionOwnershipAny' => 'すべての顧客',
    'customers.filterOptionOwnershipMy' => 'マイ顧客',
    'customers.filterOwnershipReseller' => '%%resellerContactName%%の顧客', //Note for translators: see 'filterOptionSubscriptionReseller'
    'customers.filterResourceUsage' => 'リソース使用状況',
    'customers.filterOptionResourceUsageAny' => 'すべて',
    'customers.filterOptionResourceUsageOveruse' => '利用超過リソース',
    'customers.filterOptionResourceUsageOk' => '制限内',
    'customers.filterStatus' => 'ステータス',
    'customers.filterOptionStatusAny' => 'すべて',
    'customers.filterOptionStatusSuspended' => '一時停止',
    'customers.filterOptionStatusActive' => 'アクティブ',
    'customers.filterDescription' => '説明',
    'customers.statusOk' => '顧客アカウントは有効です。',
    'customers.statusInactive' => '顧客アカウントは非アクティブです。この顧客に対し、顧客パネルへのアクセスはブロックされます。',
    'customers.statusSuspended' => 'この顧客アカウントは一時停止されています。この顧客とそのすべてのユーザに対し、顧客パネルへのアクセスはブロックされます。顧客のドメインは一時停止され、そのウェブ、FTP、メールサービスにインターネットユーザがアクセスできなくなります。',
    'customers.customerName' => '顧客名',
    'customers.subscription' => '契約',
    'customers.setupDate' => 'セットアップ日',
    'customers.ownerName' => 'プロバイダ',
    'customers.buttonLogin' => '顧客としてログイン',
    'customers.buttonLoginClassicMode' => 'ホスティング管理',
    'customers.hintLogin' => '顧客としてログインします。',
    'customers.hintLoginClassicMode' => '顧客のホスティングアカウントに紐付けられたホスティングサービスを管理します（ドメインおよび DNS、ウェブアプリケーションおよびデータベース、メールなど）。',
    'customers.buttonRemoveCustomer' => '削除',
    'customers.hintRemoveCustomer' => '選択した顧客を削除します。',
    'customers.confirmOnRemove' => '選択した顧客アカウントを削除しますか？',
    'customers.buttonConvertCustomersToReseller' => 'リセラーに変換',
    'customers.hintConvertCustomersToReseller' => '選択した顧客アカウントをリセラーアカウントに変換します。',
    'customers.buttonAddNewCustomer' => '顧客の追加',
    'customers.hintAddNewCustomer' => '契約に顧客アカウントを作成します。',
    'customers.buttonChangeStatus' => 'ステータスを変更',
    'customers.hintChangeStatus' => '顧客のステータスを「アクティブ」または「一時停止」に変更する',
    'customers.buttonSuspendCustomers' => '一時停止',
    'customers.hintSuspendCustomers' => '選択した顧客アカウントを一時停止します。この顧客とそのすべてのユーザに対し、顧客パネルへのアクセスはブロックされます。顧客のドメインは一時停止され、この顧客のウェブ、FTP、メールサービスにインターネットユーザがアクセスできなくなります。',
    'customers.buttonActivateCustomers' => 'アクティブ化',
    'customers.hintActivateCustomers' => '選択した顧客アカウントをアクティブ化します。',
    'customers.buttonChangeOwner' => '移動',
    'customers.hintChangeOwner' => '選択した顧客を別のリセラーに移動します。',
    'customers.customPlanName' => 'カスタム',
    'customers.selectNewIp' => 'IP アドレスを選択',
    'customers.selectAnotherOwner' => '所有者を選択',
    'customers.shared' => '共用',
    'customers.exclusive' => '専用',
    'customers.confirmOnDelete' => '{count, plural, =1 {顧客アカウント {name} } one {# 件の選択された顧客アカウント} other {# 件の選択された顧客アカウント}}を削除してよろしいですか？',
    'customers.hintInfo' => '(?)',

    'customerserviceplans.planName' => 'プラン名',
    'customerserviceplans.planTraffic' => 'トラフィック',
    'customerserviceplans.planDiskSpace' => 'ディスクスペース',
    'customerserviceplans.planSubscriptions' => '契約',
    'customerserviceplans.planOwner' => 'プロバイダ',
    'customerserviceplans.filterPlanItem' => 'カスタムプランアイテム',
    'customerserviceplans.filterOptionPlanItemAny' => 'すべて',
    'customerserviceplans.filterOwnership' => 'プランの所有者',
    'customerserviceplans.filterOptionOwnershipAny' => 'すべてのプラン',
    'customerserviceplans.filterOptionOwnershipMy' => 'マイ・プラン',
    'customerserviceplans.filterOwnershipReseller' => '%%resellerContactName%% のプラン',
    'customerserviceplans.unlimited' => '無制限',
    'customerserviceplans.addonPlanType' => '（アドオン）',
    'customerserviceplans.buttonAddNewPlan' => 'プランを追加',
    'customerserviceplans.hintAddNewPlan' => 'ホスティングプランを作成します。',
    'customerserviceplans.buttonDuplicatePlans' => 'プランを複製',
    'customerserviceplans.hintDuplicatePlans' => '選択したサービスプランのコピーを作成します。',
    'customerserviceplans.buttonAddNewAddonPlan' => 'アドオンを追加',
    'customerserviceplans.hintAddNewAddonPlan' => 'ホスティングプランのアドオンを作成します。',
    'customerserviceplans.buttonRemove' => '削除',
    'customerserviceplans.hintRemove' => '選択したサービスプランを削除します。',
    'customerserviceplans.buttonMoreActions' => 'その他のアクション',
    'customerserviceplans.confirmOnDelete' => '選択したサービスプランを削除しますか？',
    'customerserviceplans.disabledSelectHint' => 'このサービスプランで使用している契約があるため、削除できません',

    'domains.filterHint' => 'ドメインを条件でフィルタリングする',
    'domains.filterDomainName' => '名前',
    'domains.filterStatus' => 'ステータス',
    'domains.filterOptionStatusAny' => 'すべて',
    'domains.filterOptionStatusSuspended' => '一時停止',
    'domains.filterOptionStatusDisabled' => '無効',
    'domains.filterOptionStatusActive' => 'アクティブ',
    'domains.filterHostingType' => 'ホスティングタイプ',
    'domains.filterPhpHandler' => 'PHP ハンドラ',
    'domains.filterOptionPhpHandlerAny' => 'すべて',
    'domains.filterOptionHostingTypeAny' => 'すべて',
    'domains.filterOptionHostingTypeNone' => 'ホスティングなし',
    'domains.filterOptionHostingTypeForward' => 'ドメイン移管',
    'domains.filterOptionHostingTypeAlias' => 'ドメインエイリアス',
    'domains.filterOptionHostingTypeVirtualHost' => 'ドメインホスティング',
    'domains.filterOptionHostingTypeSubdomain' => 'サブドメインホスティング',
    'domains.filterSubscriberName' => '契約者',
    'domains.filterServiceNode' => 'サービスノード',
    'domains.filterServiceNodeOptionAny' => 'すべて',
    'domains.filterDescription' => '説明',
    'domains.filterTitlePlaceholder' => 'ドメインを検索...',
    'domains.filterTitle' => 'フィルタ',
    'domains.filterApply' => 'フィルタの適用',
    'domains.filterClear' => 'クリア',
    'domains.statusDisabled' => 'ドメインは無効です。',
    'domains.statusSuspended' => 'ドメインは一時停止されています。',
    'domains.domainName' => 'ドメイン名',
    'domains.hostingType' => 'ホスティングタイプ',
    'domains.ownerName' => '契約者',
    'domains.setupDate' => 'セットアップ日',
    'domains.expirationDate' => '有効期限',
    'domains.diskUsage' => 'ディスク使用状況',
    'domains.traffic' => 'トラフィック',
    'domains.status' => 'ステータス',
    'domains.description' => '説明',
    'domains.resellerDescription' => 'リセラー',
    'domains.ownerDescription' => '顧客',
    'domains.openSite' => '開く',
    'domains.previewSite' => 'プレビュー',
    'domains.manageInResellerPanel' => 'リセラーパネルで管理',
    'domains.manageInCustomerPanel' => '顧客パネルで管理',
    'domains.customPlanName' => 'カスタム',
    'domains.website' => 'ウェブサイト',
    'domains.subdomainWebsite' => 'サブドメインでのウェブサイト',
    'domains.noHosting' => 'ホスティングなし',
    'domains.forwardingTo' => '移管先',
    'domains.aliasFor' => 'エイリアス -',
    'domains.forwardingToDomain' => '%%domain%% に転送',
    'domains.aliasForDomain' => '%%domain%% のエイリアス',
    'domains.add' => '追加',
    'domains.buttonAddDomain' => 'ドメインを追加',
    'domains.hintAddDomain' => 'このサーバで新規ウェブサイトをホスティングするか、別のサイトへのウェブ転送をセットアップするか、ドメイン DNS ゾーンだけセットアップします（このドメインにメールアドレスしか存在しない場合）。',
    'domains.buttonAddSubdomain' => 'サブドメインを追加',
    'domains.hintAddSubdomain' => 'サードレベルドメイン名のサイトを作成します（例：shop.example.com）',
    'domains.buttonAddDomainAlias' => 'ドメインエイリアスを追加',
    'domains.hintAddDomainAlias' => 'サイトの追加ドメイン名をセットアップします。',
    'domains.hintRemove' => '選択されたウェブサイトを、そのウェブコンテンツ、アプリケーション、データベース、メールごと削除します。',
    'domains.removeConfirmation' => '{count, plural, =1 {ドメイン {name} } one {# 件の選択されたドメイン} other {# 件の選択されたドメイン}}を削除してよろしいですか？',
    'domains.removeConfirmationSubscription' => "次のドメインも削除されます：\n%%domains%%",
    'domains.buttonSetStatus' => 'ステータスを設定',
    'domains.hintSetStatus' => 'ドメインのステータスを「アクティブ」「一時停止」または「無効」に変更する',
    'domains.activateActionStatus' => 'アクティブ',
    'domains.hintActivateDomains' => '選択したドメインをアクティブにします。',
    'domains.disableActionStatus' => '無効',
    'domains.hintDisableDomains' => '選択したドメインを無効化します。',
    'domains.suspendActionStatus' => '一時停止',
    'domains.hintSuspendDomains' => '選択したドメインを一時停止します。',
    'domains.changeStatusNoItems' => 'ステータスを変更するドメインを 1 つ以上選択してください',
    'domains.removeNoItems' => '削除するドメインを 1 つ以上選択してください',
    'domains.activated' => '選択したドメインとエイリアスはアクティブ化されました',
    'domains.disabled' => '選択されたドメインとエイリアスは無効化されました',
    'domains.suspended' => '選択されたドメインとエイリアスは一時停止されました',

    'dnsaclrecords.value' => 'IP アドレス',
    'dnsaclrecords.add' => 'IP アドレスを追加',
    'dnsaclrecords.remove' => '削除',
    'dnsaclrecords.hintRemove' => '選択した IP アドレスを削除します。',
    'dnsaclrecords.confirmOnDelete' => '選択した IP アドレスを削除しますか？',
    'dnsaclrecords.emptyViewTitle' => 'ゾーン転送は許可されません',
    'dnsaclrecords.emptyViewDescription1' => 'セキュリティ上の理由から、DNS ゾーンの転送が許可されるのは、ゾーンの NS レコードに指定されているサーバへのみです。',
    'dnsaclrecords.emptyViewDescription2' => '転送先として許可するサーバを 1 つ以上指定するには、［IP アドレスを追加］をクリックします。',

    'eventhandlers.event' => 'イベント',
    'eventhandlers.priority' => '優先度',
    'eventhandlers.priorityHighest' => '最高（%%value%%）',
    'eventhandlers.priorityHigh' => '高（%%value%%）',
    'eventhandlers.priorityNormal' => '中（%%value%%）',
    'eventhandlers.priorityLow' => '低（%%value%%）',
    'eventhandlers.priorityLowest' => '最低（%%value%%）',
    'eventhandlers.user' => 'ユーザ',
    'eventhandlers.command' => 'コマンド',
    'eventhandlers.buttonAddNewEventHandler' => 'イベントハンドラを追加',
    'eventhandlers.buttonAddNewEventHandlerDescription' => '新規イベントハンドラをセットアップします。',
    'eventhandlers.buttonRemove' => '削除',
    'eventhandlers.buttonRemoveDescription' => '選択したイベントハンドラを削除します。',
    'eventhandlers.confirmOnDelete' => '選択したイベントハンドラを削除しますか？',

    'firewallicmprules.status' => 'ステータス',
    'firewallicmprules.on' => 'ルールは有効です',
    'firewallicmprules.off' => 'ルールは無効です',
    'firewallicmprules.name' => 'ルール名',
    'firewallicmprules.allowinboundrouterrequest' => '受信ルータ要求を許可する',
    'firewallicmprules.allowinboundtimestamprequest' => '着信タイムスタンプ保持要求を許可する',
    'firewallicmprules.allowinboundmaskrequest' => '着信マスク要求を許可する',
    'firewallicmprules.allowoutboundsourcequench' => '送信元抑制を許可する',
    'firewallicmprules.allowoutboundparameterproblem' => '発信パラメータの問題を許可する',
    'firewallicmprules.allowredirect' => 'リダイレクトを許可する',
    'firewallicmprules.allowinboundechorequest' => '着信エコー要求を許可する',
    'firewallicmprules.allowoutboundtimeexceeded' => '発信時間超過を許可する',
    'firewallicmprules.allowoutbounddestinationunreachable' => '発信先到達不能を許可する',

    'firewallinterfaces.firewall' => 'ファイアウォールのステータス',
    'firewallinterfaces.firewallOn' => 'このネットワークインターフェースに対してファイアウォールはオンになっています。',
    'firewallinterfaces.firewallOff' => 'このネットワークインターフェースに対してファイアウォールはオフになっています。',
    'firewallinterfaces.connection' => 'インターフェースのステータス',
    'firewallinterfaces.connectionOn' => 'ネットワークインターフェース接続はオンになっています。',
    'firewallinterfaces.connectionOff' => 'ネットワークインターフェース接続はオフになっています。',
    'firewallinterfaces.name' => 'インターフェース名',
    'firewallinterfaces.type' => 'インターフェースタイプ',
    'firewallinterfaces.statusOn' => 'オン',
    'firewallinterfaces.statusOff' => 'オフ',

    'firewallrules.status' => 'ステータス',
    'firewallrules.on' => 'ルールは有効です',
    'firewallrules.off' => 'ルールは無効です',
    'firewallrules.name' => 'ルール名',
    'firewallrules.description' => '説明',
    'firewallrules.descriptionText' => 'ポート %%port%% で %%from%% から %%action%% の受信接続、プロファイル：%%profiles%%',
    'firewallrules.allow' => '許可',
    'firewallrules.block' => '拒否',
    'firewallrules.fromAll' => 'すべて',
    'firewallrules.groupAdd' => '追加',
    'firewallrules.buttonAdd' => 'ルールを追加',
    'firewallrules.buttonAddHint' => 'ファイアウォールルールを追加',
    'firewallrules.groupActions' => 'アクション',
    'firewallrules.buttonRemove' => '削除',
    'firewallrules.removeEmptySelection' => 'ファイアウォールルールが選択されていません。',
    'firewallrules.removeConfirmation' => '{count, plural, =1 {{name} という名前のファイアウォールルール} other {# 件の選択されたファイアウォールルール}}を削除しますか？',
    'firewallrules.removeSuccess' => '選択されたファイアウォールルールは削除されました。',

    'ftpsessions.buttonRemove' => '閉じる',
    'ftpsessions.buttonRemoveDescription' => '選択した FTP セッションを閉じる',
    'ftpsessions.buttonRefresh' => '更新',
    'ftpsessions.buttonRefreshDescription' => '画面の情報を更新',
    'ftpsessions.typeColumnName' => 'T',
    'ftpsessions.statusColumnName' => 'S',
    'ftpsessions.loginColumnName' => 'ログイン名',
    'ftpsessions.domainColumnName' => 'ドメイン名',
    'ftpsessions.currentLocationColumnName' => '現在のロケーション',
    'ftpsessions.fileNameColumnName' => 'ファイル名',
    'ftpsessions.speedColumnName' => '速度（KB/秒）',
    'ftpsessions.progressColumnName' => '進捗（%）',
    'ftpsessions.ipAddressColumnName' => 'IP アドレス',
    'ftpsessions.logonTimeColumnName' => 'ログオン時間',
    'ftpsessions.idleTimeColumnName' => 'アイドル時間',
    'ftpsessions.sessionTypeDomainAdminTooltip' => 'ドメイン管理者のセッション',
    'ftpsessions.sessionTypeSubDomainAdminTooltip' => 'サブドメイン管理者のセッション',
    'ftpsessions.sessionTypeWebUserTooltip' => 'ウェブユーザのセッション',
    'ftpsessions.sessionTypeFtpAccountTooltip' => 'FTP アカウントのセッション',
    'ftpsessions.sessionTypeAnonymousTooltip' => '匿名 FTP ユーザのセッション',
    'ftpsessions.sessionTypeNotPleskUserTooltip' => 'Plesk に登録されていない FTP ユーザです。',
    'ftpsessions.sessionStatusIdle' => 'アイドル（実行中のトランザクションなし）。',
    'ftpsessions.sessionStatusUploadInProgress' => 'アップロード中です。',
    'ftpsessions.sessionStatusDownloadInProgress' => 'ダウンロード中です。',
    'ftpsessions.sessionStatusDownloadingDirsList' => 'ディレクトリ一覧をダウンロードしています。',
    'ftpsessions.sessionStatusLastCmdIsType' => '顧客が最後に送信したコマンドは TYPE です。',
    'ftpsessions.sessionStatusLastCmdIsPass' => '顧客が最後に送信したコマンドは PASS です。',
    'ftpsessions.sessionStatusLastCmdIsNoop' => '顧客が最後に送信したコマンドは NOOP です。',
    'ftpsessions.sessionStatusNotKnown' => '認識されていない FTP アクティビティです。',
    'ftpsessions.confirmOnDelete' => '選択したセッションを閉じてよろしいですか？',

    'ipaddresses.buttonAddNewIpAddress' => 'IP アドレスを追加',
    'ipaddresses.buttonAddNewIpAddressDescription' => 'サーバの IP アドレスプールに IP アドレスを追加します。',
    'ipaddresses.buttonRereadConfiguration' => 'IP 再読み込み',
    'ipaddresses.buttonRereadConfigurationDescription' => 'IP アドレスの一覧をネットワークアダプタの構成と同期します。',
    'ipaddresses.buttonReloadPublic' => 'パブリック IP を更新',
    'ipaddresses.buttonReloadPublicDescription' => 'ハイパースケーラーインスタンスのメタデータに基づいてパブリック IP アドレスを更新します',
    'ipaddresses.buttonFirewall' => 'ファイアウォール',
    'ipaddresses.buttonFirewallDescription' => 'ファイアウォールをセットアップします。',
    'ipaddresses.buttonRemove' => '削除',
    'ipaddresses.buttonRemoveDescription' => '削除',
    'ipaddresses.confirmOnDelete' => '選択した IP アドレスを削除しますか？',
    'ipaddresses.address' => 'IP アドレス',
    'ipaddresses.publicAddress' => 'パブリック IP アドレス',
    'ipaddresses.type' => 'IP タイプ',
    'ipaddresses.interface' => 'インターフェース',
    'ipaddresses.resellerCount' => 'リセラー',
    'ipaddresses.subscriptionCount' => 'サイト',
    'ipaddresses.typeAny' => 'すべて',
    'ipaddresses.typeShared' => '共有',
    'ipaddresses.typeExclusive' => '専用',
    'ipaddresses.typeSharedHint' => '共有',
    'ipaddresses.typeExclusiveHint' => '専用',
    'ipaddresses.ipAddressBroken' => 'IP アドレスが正しく構成されていません。',
    'ipaddresses.ipAddressBlacklisted' => 'この IP アドレスはブラックリストに登録されています。',
    'ipaddresses.repair' => '修復',
    'ipaddresses.buttonSearch' => '検索',
    'ipaddresses.buttonResetSearch' => '検索結果をリセット',
    'ipaddresses.removeConfirmation' => '{count, plural, =1 {IP アドレス {name} } other {選択された # 件の IP アドレス}}を削除してよろしいですか？',
    'ipaddresses.hint' => 'IP アドレスを表示、追加、削除します。',
    'ipaddresses.hintWithResellers' => 'IP アドレスを表示、追加、削除し、リセラーに IP アドレスに割り当てます。',
    'ipaddresses.repairSuccess' => 'IP アドレス %%address%% がシステムと同期されました。',
    'ipaddresses.removeSuccess' => '選択した IP アドレスは削除されました。',

    'resourceusage.clientName' => '顧客の名前',
    'resourceusage.domainName' => 'ドメイン名',
    'resourceusage.diskUsage' => 'DU',
    'resourceusage.traffic' => 'TR',
    'resourceusage.subDomainsCount' => 'SD',
    'resourceusage.webUsersCount' => 'WU',
    'resourceusage.databasesCount' => 'DB',
    'resourceusage.mailBoxesCount' => 'MBox',
    'resourceusage.autoRepliesCount' => 'MA',
    'resourceusage.mailForwardingsCount' => 'MF',
    'resourceusage.mailListsCount' => 'ML',
    'resourceusage.sendByEmail' => 'クリックすると、このレポートがメールで送信されます',
    'resourceusage.buttonSendByEmail' => 'メールで送信',
    'resourceusage.noResults' => 'ドメインのリソース利用状況についての情報がありません',
    'resourceusage.reportWasSent' => '情報: レポートは次のメールアドレスに送信されます: %%email%%',

    'languages.headerStatus' => 'S',
    'languages.headerCode' => '言語パック',
    'languages.headerLanguage' => '言語',
    'languages.headerCountry' => '国',
    'languages.headerUsed' => '使用中',
    'languages.filterCode' => '言語パック',
    'languages.buttonDisable' => '無効化',
    'languages.buttonDisableDescription' => '選択した言語をユーザに対して使用不可にします。',
    'languages.disableDone' => '選択した言語はユーザに対して使用不可になりました。',
    'languages.buttonEnable' => '有効化',
    'languages.buttonEnableDescription' => '選択した言語をユーザに対して使用可能にします。',
    'languages.enableDone' => '選択した言語はユーザに対して使用可能になりました。',
    'languages.buttonMakeDefault' => 'デフォルトに指定',
    'languages.buttonMakeDefaultDescription' => '選択した言語が Plesk のデフォルト言語になります。',
    'languages.makeDefaultDone' => '選択した言語が Plesk のデフォルト言語に設定されました。',
    'languages.makeDefaultSelectOne' => 'Plesk のデフォルト言語にする言語を選択します。',
    'languages.statusActive' => 'この言語は Plesk ユーザに対して使用可能になっています。',
    'languages.statusActiveUnavailable' => '許可される言語数の上限に達したため、この言語はユーザに対して使用不可になりました。',
    'languages.buttonHintStatusActive' => 'このアイコンをクリックすると、ユーザに対してこの言語が使用不可になります。',
    'languages.statusInactive' => 'この言語はユーザに対して使用不可になっています。',
    'languages.buttonHintStatusInactive' => 'このアイコンをクリックすると、ユーザに対してこの言語が使用可能になります。',
    'languages.buttonHintStatusDefaultLangugage' => 'これはデフォルト言語です。ユーザに対して使用不可にすることはできません。',
    'languages.langUnknown' => '言語を認識できません',
    'languages.countryUnknown' => '国サブコードを認識できません',

    'mailqueue.filterQueue' => 'キュー',
    'mailqueue.filterSubject' => '件名',
    'mailqueue.filterSender' => '送信者',
    'mailqueue.filterRecipients' => '受信者',
    'mailqueue.subject' => '件名',
    'mailqueue.sender' => '送信者',
    'mailqueue.recipients' => '受信者',
    'mailqueue.date' => '日付',
    'mailqueue.age' => '滞留期間',
    'mailqueue.size' => 'サイズ',
    'mailqueue.buttonRefresh' => '更新',
    'mailqueue.buttonRefreshHint' => '画面上のデータを更新します。',
    'mailqueue.buttonRemove' => '削除',
    'mailqueue.buttonRemoveHint' => '選択したメッセージをメールキューから削除します。',
    'mailqueue.confirmOnDelete' => '選択したメッセージをメールキューから削除しますか？',
    'mailqueue.buttonClean' => 'クリア',
    'mailqueue.buttonCleanHint' => 'メールキューのすべてのメッセージをクリアします。',
    'mailqueue.confirmOnClean' => 'メールキューをクリアしますか？',
    'mailqueue.queueAll' => 'すべて',
    'mailqueue.queueTodo' => '前処理実行前',
    'mailqueue.queueRemote' => 'リモート',
    'mailqueue.queueLocal' => 'ローカル',
    'mailqueue.queueLocalAndRemote' => 'ローカルおよびリモート',
    'mailqueue.queueActive' => 'アクティブメッセージキュー',
    'mailqueue.queueCorrupted' => '破損メッセージキュー',
    'mailqueue.queueDeferred' => '遅延メッセージキュー',
    'mailqueue.queueHold' => '保留メッセージキュー',
    'mailqueue.queueIncoming' => '受信メッセージキュー',
    'mailqueue.postfixHint' => 'キュー内のメッセージ：遅延 - %%deferred%% 件、保留 - %%hold%% 件、受信 - %%incoming%% 件、アクティブ - %%active%% 件、破損 - %%corrupted%% 件、合計 - %%total%% 件',
    'mailqueue.qmailHint' => 'キュー内のメッセージ：前処理実行前 - %%todo%% 件、ローカル - %%local%% 件、リモート - %%remote%% 件、合計 - %%total%% 件',
    'mailqueue.messagesDeleted' => '選択したメッセージがメールキューから削除されました。',
    'mailqueue.messagesNotDeleted' => 'いくつかのメッセージをメールキューから削除できません。%%error%%',
    'mailqueue.queueCleaned' => 'メールキューが正常にクリアされました。',
    'mailqueue.queueNotCleaned' => 'メールキューをクリアできません: %%error%%',

    'phpextensions.enable' => '拡張を有効にする',
    'phpextensions.disable' => '拡張を無効にする',

    'phpextensions.installable.status' => 'ステータス',
    'phpextensions.installable.notInstalled' => '未インストール',
    'phpextensions.installable.outdated' => '古いバージョンです。最新バージョンは %%latestVersion%% です',
    'phpextensions.installable.latest' => '最新',
    'phpextensions.installable.name' => 'パッケージ',
    'phpextensions.installable.description' => '説明',
    'phpextensions.installable.actionInstall' => 'インストール',
    'phpextensions.installable.actionUpgrade' => '%%version%%にアップグレード',
    'phpextensions.installable.actionDocs' => 'マニュアル',
    'phpextensions.installable.actionUninstall' => 'アンインストール',
    'phpextensions.installable.uninstallConfirmation' => '%%name%% パッケージをアンインストールしてよろしいですか？',
    'phpextensions.installable.groupInstall' => 'インストール',
    'phpextensions.installable.groupReload' => 'リロード',
    'phpextensions.installable.buttonInstallCustom' => 'パッケージをインストール',
    'phpextensions.installable.buttonInstallCustomHint' => 'PECL パッケージをインストール',
    'phpextensions.installable.buttonReload' => 'リロード',
    'phpextensions.installable.buttonReloadHint' => 'PECL パッケージをリロード',
    'phpextensions.installable.emptyViewFilteredTitle' => 'フィルタと一致するパッケージは見つかりませんでした',
    'phpextensions.installable.emptyViewFilteredDescription' => 'お探しのパッケージのインストールを試みます。',

    'phphandlers.name' => 'ハンドラ',
    'phphandlers.domains' => 'ドメイン',
    'phphandlers.statusBroken' => 'このハンドラは破損しています。',
    'phphandlers.statusDisallowedApacheModule' => 'ハンドラを有効にできません。関連する Apache モジュールがオフになっています。',
    'phphandlers.domainsTitle' => '%%domains%% ドメインが PHP %%handler%% を使用しています。',
    'phphandlers.closeTitle' => '閉じる',
    'phphandlers.handlerOutdated' => '（サポート終了）',
    'phphandlers.handlerDeprecated' => '（非推奨）',
    'phphandlers.handlerOutdatedAndDeprecated' => '（サポート終了、非推奨）',

    'planitems.name' => '名前',
    'planitems.numberOfPlans' => 'サービスプラン',
    'planitems.numberOfSubscriptions' => '契約',
    'planitems.itemInvisible' => 'リセラーに対して提供しない',
    'planitems.buttonMakeItemVisible' => '使用可能にする',
    'planitems.buttonMakeItemVisibleDescription' => 'リセラーが、選択したサービスをホスティングプランで提供できるようにします。 これらのサービスに関連するオプションが、ホスティングプランのプロパティで［追加サービス］タブに表示されます。',
    'planitems.buttonMakeItemInvisible' => '使用不可にする',
    'planitems.buttonMakeItemInvisibleDescription' => 'リセラーが、選択したサービスをホスティングプランで提供できないようにします。 これらのサービスに関連するオプションがホスティングプランのプロパティから削除されます。',
    'planitems.buttonAddNewCustomItemButton' => 'サービスを追加',
    'planitems.buttonAddNewCustomItemButtonDescription' => 'サービスをプランオプションに追加します。',
    'planitems.buttonRemoveCustomItem' => 'サービスを削除',
    'planitems.buttonRemoveCustomItemDescription' => '選択したサービスに関連するオプションをホスティングプランのプロパティから削除します。',
    'planitems.confirmOnDeleteSupportButton' => '選択したオプションを削除しますか？',

    'pumpackages.buttonUpdate' => '更新',
    'pumpackages.buttonUpdateDescription' => '選択したパッケージを更新します。',
    'pumpackages.buttonLock' => 'ロック',
    'pumpackages.buttonLockDescription' => '選択したパッケージが更新されないようにロックします。',
    'pumpackages.buttonUnlock' => 'ロック解除',
    'pumpackages.buttonUnlockDescription' => '選択したパッケージが更新されるようにロックを解除します。',
    'pumpackages.buttonCheckUpdates' => 'アップデートの確認',
    'pumpackages.buttonCheckUpdatesDescription' => 'パッケージアップデートの確認',
    'pumpackages.name' => 'パッケージ',
    'pumpackages.summary' => '説明',
    'pumpackages.updates' => 'アップデート',
    'pumpackages.lockedCut' => 'L',
    'pumpackages.lockedHint' => 'パッケージはロックされています。',
    'pumpackages.unlockedHint' => 'パッケージはロック解除されています。',
    'pumpackages.updated' => '最新',
    'pumpackages.update' => '%%version%% に更新',
    'pumpackages.unknownRepo' => '不明',
    'pumpackages.allUpToDate' => 'すべてのアプリケーションが最新状態です',
    'pumpackages.allUpToDateLastChecked' => 'チェック日時 %%date%%',
    'pumpackages.recheckUpdates' => '今すぐ再チェック',
    'pumpackages.popupInfoTitle' => '%%package%% パッケージの詳細',
    'pumpackages.loading' => 'お待ちください...',
    'pumpackages.error' => 'パッケージリストを取得できません。%%message%%',
    'pumpackages.currentVersion' => '現在のバージョン：%%version%%',
    'pumpackages.notInstalled' => '未インストール',
    'pumpackages.popupUpdateTitle' => 'パッケージを更新',
    'pumpackages.popupUpdatePackagesListTitle' => '以下のアップデートをインストールします。',
    'pumpackages.popupUpdateLockedPackagesListTitle' => '以下の必須パッケージは、更新されないようにロックされています。',
    'pumpackages.popupUpdateDependencies' => '%%count%% 件の依存パッケージ',
    'pumpackages.unlockPackagesForUpdateOnly' => 'パッケージをロック解除して、このアップデートのみを許可する',
    'pumpackages.lockedError' => 'システムアップデートツールが既にアップデートを自動モードでインストール中です。後でやり直してください。',
    'pumpackages.duplicatesError' => 'エラー：一部のパッケージに重複があるため、アップデートの情報を受信できません。以下のパッケージの重複を削除してください：%%duplicates%%',
    'pumpackages.updateInfoError' => 'エラー：パッケージのアップデート情報を取得できません',
    'pumpackages.selectedPackagesUpToDate' => '選択されたすべてのアプリケーションが最新状態です。',
    'pumpackages.taskUpdatingPackages' => '%%count%% パッケージを更新しています...',
    'pumpackages.popupLockTitle' => 'パッケージのロック',
    'pumpackages.popupLockDescription' => 'パッケージをロックすると、当該パッケージは（Plesk 本体を更新しない限り）システム更新マネージャによって更新されなくなります他のパッケージのアップデートのために当該パッケージの最新バージョンが必要な場合、それらのパッケージは更新されません。ロックされたパッケージは、コンソールからネイティブな方法で更新できます。ロックされたパッケージを Plesk インターフェースから更新するには、まずロック解除する必要があります。',
    'pumpackages.popupLockPackagesListTitle' => '以下のパッケージをロックします。',
    'pumpackages.popupUnlockTitle' => 'パッケージのロック解除',
    'pumpackages.popupUnlockDescription' => 'これらのパッケージは、更新されないようにロックされているため更新できません。ロックされたパッケージは、コンソールからネイティブな方法で更新することや、Plesk 本体の更新によって更新することができます。ロックされたパッケージを Plesk インターフェースから更新するには、まずロック解除する必要があります。',
    'pumpackages.popupUnlockPackagesListTitle' => '以下のパッケージをロック解除します。',
    'pumpackages.updatesAvailable' => '%%count%% システムパッケージでアップデートが使用可能です。',
    'pumpackages.lastedChecked' => '（チェック日時 %%date%%）',
    'pumpackages.updateAll' => 'すべて更新',
    'pumpackages.packageManagerDbInconsistent' => '一部のパッケージの情報が現実に即していない可能性があります。システムのパッケージマネージャデータベースで不整合が検出されました。この問題を手作業で解決してください。',

    'resellers.filterResellerName' => 'リセラー名',
    'resellers.filterSubscription' => '契約',
    'resellers.filterOptionSubscriptionAny' => 'すべて',
    'resellers.filterOptionSubscriptionCustom' => 'カスタム',
    'resellers.filterResourceUsage' => 'リソース使用状況',
    'resellers.filterOptionResourceUsageAny' => 'すべて',
    'resellers.filterOptionResourceUsageOveruse' => '利用超過リソース',
    'resellers.filterOptionResourceUsageOk' => '制限内',
    'resellers.filterStatus' => 'ステータス',
    'resellers.filterOptionStatusAny' => 'すべて',
    'resellers.filterOptionStatusSuspended' => '一時停止',
    'resellers.filterOptionStatusActive' => 'アクティブ',
    'resellers.filterSubscriptionStatus' => '契約の状態',
    'resellers.filterOptionSubscriptionStatusAny' => 'すべて',
    'resellers.filterOptionSubscriptionStatusLocked' => 'ロック済み',
    'resellers.filterOptionSubscriptionStatusUnsynchronized' => '非同期',
    'resellers.filterDescription' => '説明',
    'resellers.buttonAddNewReseller' => 'リセラーを追加',
    'resellers.hintAddNewReseller' => 'リセラーアカウントを作成します。',
    'resellers.buttonRemove' => '削除',
    'resellers.hintRemove' => '選択したリセラーおよびそのサービスプラン、顧客、契約を削除します。',
    'resellers.confirmOnDelete' => '{count, plural, =1 {リセラーアカウント {name}} one {# 件の選択されたリセラーアカウント} other {# 件の選択されたリセラーアカウント}}と{count, plural, one {その} other {その}}サービスプラン、顧客、契約をすべて削除してよろしいですか？',
    'resellers.buttonConvertToCustomer' => '顧客に変換',
    'resellers.hintConvertToCustomer' => '選択したリセラーを顧客に変換します。',
    'resellers.buttonChangeStatus' => 'ステータスを変更',
    'resellers.hintChangeStatus' => 'リセラーのステータスを「アクティブ」または「一時停止」に変更する',
    'resellers.buttonActivateResellers' => 'アクティブ化',
    'resellers.hintActivateResellers' => '選択したリセラーアカウントをアクティブ化します。',
    'resellers.buttonSuspendResellers' => '一時停止',
    'resellers.hintSuspendResellers' => '選択したリセラーアカウントを一時停止します。リセラーとそのすべての顧客に対し、顧客パネルへのアクセスがブロックされます。リセラーおよび顧客のドメインは一時停止され、そのウェブサービス、FTP サービス、メールサービスにインターネットユーザがアクセスすることはできなくなります。',
    'resellers.resellerName' => 'リセラー名',
    'resellers.planName' => 'サービスプラン',
    'resellers.setupDate' => 'セットアップ日',
    'resellers.customers' => '顧客',
    'resellers.customPlanName' => 'カスタム',
    'resellers.buttonLogin' => 'リセラーとしてログイン',
    'resellers.hintLogin' => 'リセラーのホスティングアカウントに紐付けられたホスティングサービスを管理します。',
    'resellers.statusOk' => 'このリセラーアカウントステータスは OK です。このアカウントはアクティブであり、契約はプランと同期されます。',
    'resellers.statusSuspended' => 'このリセラーアカウントは一時停止されています。このリセラーとそのすべての顧客に対し、顧客パネルへのアクセスはブロックされます。リセラーおよびその顧客のドメインは一時停止され、そのウェブ、FTP、メールサービスにインターネットユーザがアクセスできなくなります。',
    'resellers.statusLocked' => '同期に対して契約をロックしました。 契約パラメータがカスタマイズされているため、サービスプランとの同期から除外されます。',
    'resellers.statusUnsynchronized' => '契約はリセラープランと同期されていません。リセラープランで提供されているサービスまたはリソースの 一部が契約では提供されていません。',

    'resellerserviceplans.planName' => 'プラン名',
    'resellerserviceplans.planTraffic' => 'トラフィック',
    'resellerserviceplans.planDiskSpace' => 'ディスクスペース',
    'resellerserviceplans.planSubscriptions' => 'リセラー',
    'resellerserviceplans.unlimited' => '無制限',
    'resellerserviceplans.buttonAddNewPlan' => 'プランを追加',
    'resellerserviceplans.hintAddNewPlan' => 'リセラープランを作成します。',
    'resellerserviceplans.buttonDuplicatePlans' => 'プランを複製',
    'resellerserviceplans.hintDuplicatePlans' => '選択したリセラープランのコピーを作成',
    'resellerserviceplans.buttonRemove' => '削除',
    'resellerserviceplans.hintRemove' => '選択したリセラープランを削除します。',
    'resellerserviceplans.confirmOnDelete' => '選択したリセラープランを削除しますか？',
    'resellerserviceplans.disabledSelectHint' => '契約のあるリセラープランは削除できません',

    'restricteddomains.name' => 'ドメイン名',
    'restricteddomains.buttonAddNewDomain' => 'ドメイン名を追加',
    'restricteddomains.buttonEnableList' => '有効化',
    'restricteddomains.hintAddNewDomain' => '禁止ドメイン名を追加します。',
    'restricteddomains.hintEnableList' => 'ドメイン作成時のドメイン名のチェックをオンにします。',
    'restricteddomains.buttonDisableList' => '無効化',
    'restricteddomains.hintDisableList' => 'ドメイン作成時のドメイン名のチェックをオフにします。',
    'restricteddomains.buttonRemoveDomain' => '削除',
    'restricteddomains.hintRemoveDomain' => '選択したドメイン名を削除します。',
    'restricteddomains.confirmOnRemove' => '選択されたドメイン名を削除しますか？',
    'restricteddomains.buttonMoreActions' => 'その他',

    'servermailblacklist.groupAdd' => '追加',
    'servermailblacklist.buttonAdd' => 'ドメインを追加',
    'servermailblacklist.buttonAddHint' => 'ドメインをブラックリストに追加',
    'servermailblacklist.groupActions' => 'アクション',
    'servermailblacklist.buttonRemove' => '削除',
    'servermailblacklist.entries' => 'エントリ',
    'servermailblacklist.action' => 'アクション',
    'servermailblacklist.deleteAction' => 'サーバから削除する',
    'servermailblacklist.spamAction' => 'スパムとしてマークする',
    'servermailblacklist.spamAssassinDisabled' => 'エントリはスパム判定されません。SpamAssassin がインストールされていないか、オフになっています',
    'servermailblacklist.removeEmptySelection' => 'エントリが選択されていません。',
    'servermailblacklist.removeConfirmation' => '{count, plural, =1 {{name} というエントリ} other {# 件の選択されたエントリ}}を削除しますか？',
    'servermailblacklist.removeSuccess' => '選択されたエントリは削除されました。',

    'servermailwhitelist.groupAdd' => '追加',
    'servermailwhitelist.buttonAdd' => 'ネットワークを追加',
    'servermailwhitelist.buttonAddHint' => 'ネットワークをホワイトリストに追加',
    'servermailwhitelist.groupActions' => 'アクション',
    'servermailwhitelist.buttonRemove' => '削除',
    'servermailwhitelist.entries' => 'エントリ',
    'servermailwhitelist.whiteListNotEmpty' => '送信メールの上限は、メールサーバのホワイトリストに IP アドレスが含まれているメール送信者に対しては適用されません。例えば、ホワイトリストにローカルホスト（127.0.0.0 / 8, ::1 / 128）が含まれる場合、ローカルサーバからのすべてのメールが上限を問わず正常に送信されます。メール送信者は、ローカル IP アドレス（ローカルサーバ上でホストされるウェブサイトおよびカスタムスクリプト）または外部 IP アドレス（自分のコンピュータまたはモバイルデバイスにインストールしたメールクライアントからメールを送信する顧客）のいずれかを使用できます。すべてのメール送信者（ローカルと外部の両方）に対して上限を機能させるには、ホワイトリストからすべての IP アドレスとネットワークを削除してください。ホワイトリストからローカルホスト（127.0.0.0 / 8, ::1 / 128）を削除すると、このサーバからメールを送信するウェブサイトやスクリプトの動作に支障をきたす可能性があります。送信メールの上限について詳しくは、管理者ガイドの「アウトバウンドパムから防御する」を参照してください。',
    'servermailwhitelist.removeEmptySelection' => 'エントリが選択されていません。',
    'servermailwhitelist.removeConfirmation' => '{count, plural, =1 {{name} というエントリ} other {# 件の選択されたエントリ}}を削除しますか？',
    'servermailwhitelist.webmailAffected' => '以下の{count, plural, =1 {ネットワーク} other {ネットワーク}}を削除すると、ウェブメールからメールを送信できなくなります：%%list%%',
    'servermailwhitelist.webmailAffectedSingle' => 'このネットワークを削除すると、ウェブメールからのメール送信ができなくなる可能性があります。',
    'servermailwhitelist.removeSuccess' => '選択されたエントリは削除されました。',

    'serverprotection.bannedips.pageHint' => 'アクセス制限中の IP アドレスの確認、アクセス制限の解除、信頼する IP アドレスリストへの移動を実行できます。',
    'serverprotection.bannedips.ip' => 'IP アドレス',
    'serverprotection.bannedips.banDate' => '禁止日時',
    'serverprotection.bannedips.jail' => '使用 jail',
    'serverprotection.bannedips.buttonRemoveIp' => '禁止を解除',
    'serverprotection.bannedips.hintRemoveIp' => '選択された IP アドレスをアクセス制限アドレスのリストから削除します。',
    'serverprotection.bannedips.hintRemoveIpFail2BanDisabled' => 'IP アドレスのアクセス制限を解除するには、Fail2Ban をアクティブ化する必要があります。',
    'serverprotection.bannedips.buttonMoveToTrustedIp' => '信頼する IP に移動',
    'serverprotection.bannedips.hintMoveToTrustedIp' => '選択した IP アドレスを、信頼するアドレスのリストに移動します。',
    'serverprotection.bannedips.hintMoveToTrustedIpFail2BanDisabled' => 'IP アドレスを信頼するアドレスにするには、Fail2Ban をアクティブ化する必要があります。',
    'serverprotection.bannedips.buttonEnable' => 'IP アドレスによるアクセス制限をオンにする',
    'serverprotection.bannedips.hintEnable' => 'サーバへの悪意あるトラフィックを生成する IP アドレスおよびネットワークの自動禁止をオンにします。',
    'serverprotection.bannedips.buttonDisable' => 'IP アドレスによるアクセス制限をオフにする',
    'serverprotection.bannedips.hintDisable' => 'サーバへの悪意あるトラフィックを生成する IP アドレスおよびネットワークの自動禁止をオフにします。',
    'serverprotection.bannedips.errorEnableFailed' => 'IP アドレスによるアクセス制限をオンにできません: %%error%%',
    'serverprotection.bannedips.errorDisableFailed' => 'IP アドレスによるアクセス制限をオフにできません: %%error%%。',
    'serverprotection.bannedips.buttonBanIp' => 'IP をアクセス制限',
    'serverprotection.bannedips.hintBanIp' => 'アクセス制限するアドレスのリストに IP アドレスを追加します。',
    'serverprotection.bannedips.hintBanIpFail2BanDisabled' => 'IP アドレスをアクセス制限するには、Fail2Ban をアクティブ化する必要があります。',
    'serverprotection.bannedips.hintBanIpNoActiveManualJails' => 'IP アドレスをアクセス制限するには、次の jail の少なくとも 1 つをアクティブ化する必要があります: %%manualJailList%%。',

    'serverprotection.filters.pageHint' => 'jail フィルタを管理します。',
    'serverprotection.filters.buttonAddFilter' => 'フィルタを追加',
    'serverprotection.filters.hintAddFilter' => 'フィルタを追加します。',
    'serverprotection.filters.buttonRemoveFilter' => '削除',
    'serverprotection.filters.hintRemoveFilter' => '選択したフィルタを削除します。',
    'serverprotection.filters.name' => 'フィルタ名',

    'serverprotection.jails.pageHint' => '不正な IP アドレスの検知に使用する jail のリストが表示されます。',
    'serverprotection.jails.buttonAddJail' => 'jail を追加',
    'serverprotection.jails.hintAddJail' => 'jail を追加します。',
    'serverprotection.jails.buttonDisableJails' => 'オフにする',
    'serverprotection.jails.hintDisableJails' => '選択した jail をオフにします。',
    'serverprotection.jails.buttonActivateJails' => 'オンにする',
    'serverprotection.jails.hintActivateJails' => '選択した jail をオンにします。',
    'serverprotection.jails.buttonRemoveJail' => '削除',
    'serverprotection.jails.hintRemoveJail' => '選択した jail を削除します。',
    'serverprotection.jails.buttonManageFilters' => 'フィルタ管理',
    'serverprotection.jails.hintManageFilters' => 'jail フィルタを管理します。',
    'serverprotection.jails.name' => 'jail 名',
    'serverprotection.jails.disabled' => '非アクティブ',
    'serverprotection.jails.active' => 'アクティブ',
    'serverprotection.jails.status' => 'ステータス',
    'serverprotection.jails.confirmOnDelete' => '選択した jail を削除しますか？',

    'serverprotection.logs.pageHint' => 'Fail2ban のログが表示されます。',
    'serverprotection.logs.name' => 'ファイル',
    'serverprotection.logs.viewHint' => 'ログファイルを表示します。',
    'serverprotection.logs.buttonDownloadHint' => 'ログファイルをダウンロード',

    'serverprotection.trustedips.pageHint' => '信頼する IP アドレスの確認、信頼する IP アドレスのリストへの IP アドレスの追加と削除を実行できます。',
    'serverprotection.trustedips.ip' => 'IP アドレス',
    'serverprotection.trustedips.ipDesc' => '説明',
    'serverprotection.trustedips.addDate' => '追加された日時',
    'serverprotection.trustedips.comment' => 'コメント',
    'serverprotection.trustedips.buttonRemoveIp' => '削除',
    'serverprotection.trustedips.hintRemoveIp' => '選択した IP アドレスを、信頼するアドレスのリストから削除します。',
    'serverprotection.trustedips.buttonAddTrustedIp' => '信頼する IP を追加',
    'serverprotection.trustedips.hintAddTrustedIp' => '信頼するアドレスのリストに IP アドレスを追加します。',
    'serverprotection.trustedips.buttonEditTrustedIp' => '説明を編集',
    'serverprotection.trustedips.buttonEditHint' => 'IP アドレスの説明を編集します。',

    'services.stateColumnHeader' => '状態',
    'services.nameColumnHeader' => 'サービス',
    'services.startupTypeColumnHeader' => '起動タイプ',
    'services.autoStartupType' => '自動',
    'services.manualStartupType' => '手動',
    'services.disabledStartupType' => '無効',
    'services.changeStartupTypeTooltip' => 'サービスの起動タイプを変更',
    'services.drwebName' => 'Plesk Premium Antivirus',
    'services.postgresqlName' => 'PostgreSQL',
    'services.tomcatName' => 'Tomcat Java',
    'services.imap-pop3Name' => 'Dovecot IMAP および POP3 サーバ',
    'services.pop3Name' => 'Courier POP3 サーバ',
    'services.pop3sName' => 'Courier POP3 サーバ、SSL/TLS サポート',
    'services.imapName' => 'Courier IMAP サーバ',
    'services.imapsName' => 'Courier IMAP サーバ、SSL/TLS サポート',
    'services.authdaemonName' => 'Courier IMAP 認証デーモン',
    'services.dnsName' => 'DNS サーバ（%%displayName%%）',
    'services.fail2banName' => 'IP アドレスによるアクセス制限 (Fail2ban)',
    'services.kavName' => 'Kaspersky アンチウイルス',
    'services.milterName' => "Plesk milter（%%displayName%%）",
    'services.nginxName' => 'リバースプロキシサーバ（nginx）',
    'services.smtpName' => 'SMTP サーバ（%%displayName%%）',
    'services.spamassassinName' => "SpamAssassin",
    'services.webName' => "ウェブサーバ（%%displayName%%）",
    'services.resctrlName' => "リソースコントローラ（cgroups）",
    'services.activeState' => 'オン',
    'services.inActiveState' => 'オフ',
    'services.do-restart' => '再起動中',
    'services.do-start' => '起動中',
    'services.do-stop' => 'オフに切り替え中',
    'services.do-changeStartup' => '処理中',
    'services.notConfiguredState' => '未構成',
    'services.notInstalledState' => '未インストール',
    'services.running-start' => 'サービスは既に起動しています。',
    'services.notRunning-start' => 'サービスを起動します。',
    'services.running-stop' => 'サービスを停止します。',
    'services.notRunning-stop' => 'サービスは既に停止しています。',
    'services.running-restart' => 'サービスを再起動します。',
    'services.notRunning-restart' => 'サービスは停止しています。',
    'services.startServiceDrWeb' => 'アンチウイルスサービスを起動するには、ウイルスチェックを有効にしたメールボックスが 1 つ以上必要です。',
    'services.serviceDisabled' => 'この機能は使用できません。ライセンスキーでサポートされていないか、サービスがインストールされていないか、適切に構成されていません。',
    'services.serviceDisabledStartupType' => 'サービスは無効です。',
    'services.phpHandlerSettingsByOsVendor' => '%%displayName%%（OS ベンダー提供）',
    'services.phpFpm' => 'PHP-FPM %%displayName%%',
    'services.urlrewriteComponentName' => "URL Rewrite",
    'services.dbconnectorComponentName' => "データベースコネクタ",
    'services.tomcatComponentName' => 'Apache Tomcat',
    'services.mysqlserverComponentName' => 'MariaDB/MySQL サーバ',
    'services.troubleshootingComponentName' => 'トラブルシューティング',
    'services.wafComponentName' => 'ウェブアプリケーションファイアウォール',
    'services.vcsComponentName' => 'バージョン管理システム',
    'services.antivirusComponentName' => "アンチウイルス",
    'services.databaseComponentName' => "SQL Server",
    'services.sqladminComponentName' => "MySQL Webadmin",
    'services.sqladminmysqlComponentName' => "MySQL Webadmin",
    'services.dnsserverComponentName' => "DNS サーバ",
    'services.firewallComponentName' => "ファイアウォール",
    'services.ftpserverComponentName' => "FTP サーバ",
    'services.javaComponentName' => "Java",
    'services.mailserverComponentName' => "メールサーバ",
    'services.pleskagentComponentName' => "Plesk エージェント",
    'services.psaComponentName' => "Plesk",
    'services.scriptComponentName' => "ウェブスクリプティング",
    'services.spamfilterComponentName' => "スパムフィルタ",
    'services.statsComponentName' => "ウェブ統計",
    'services.stunnelComponentName' => "SSL/TLS ラッパ",
    'services.webmailComponentName' => "ウェブメール",
    'services.webpublishComponentName' => "Web 発行",
    'services.webserverComponentName' => "ウェブサーバ",
    'services.backupsystemComponentName' => 'バックアップシステム',
    'services.networkComponentName' => 'ネットワーク',
    'services.sitebuilderComponentName' => 'Presence Builder',
    'services.saviComponentName' => 'Sophos Anti-Virus インターフェース',
    'services.waitMessage' => 'お待ちください',
    'services.buttonRefreshComponents' => '更新',
    'services.searchTitle' => 'サービス検索...',
    'services.hintRefreshComponents' => 'コンポーネント一覧を更新',

    'sessions.searchTitle' => 'アクティブセッションを検索',
    'sessions.buttonRefresh' => '更新',
    'sessions.buttonRefreshDescription' => '現在オープンなセッションとセッションリストを同期します。',
    'sessions.buttonRemove' => '閉じる',
    'sessions.buttonRemoveDescription' => '選択したセッションを閉じます。',
    'sessions.removeConfirmMessage' => '選択したセッションを閉じてよろしいですか？',
    'sessions.buttonSettings' => 'セッション設定',
    'sessions.buttonSettingsDescription' => 'セッションパラメータを変更します。',
    'sessions.headerType' => 'T',
    'sessions.headerLogin' => 'ログイン名',
    'sessions.headerIpAddress' => 'IP アドレス',
    'sessions.headerLogonTime' => 'ログオン時間',
    'sessions.headerIdleTime' => 'アイドル時間',
    'sessions.typeAdmin' => '管理者のセッション',
    'sessions.typeReseller' => 'リセラーのセッション',
    'sessions.typeClient' => '顧客のセッション',
    'sessions.altAdminIcon' => '管理者',
    'sessions.altResellerIcon' => 'リセラー',
    'sessions.altClientIcon' => '顧客',

    'sslcertificates.name' => '名前',
    'sslcertificates.used' => '使用中',
    'sslcertificates.csrHint' => 'CSR コンポーネントが提供されています。',
    'sslcertificates.noCsrHint' => 'CSR コンポーネントが提供されていません。',
    'sslcertificates.privateKeyHint' => '秘密キーコンポーネントが提供されています。',
    'sslcertificates.noPrivateKeyHint' => '秘密キーコンポーネントが提供されていません。',
    'sslcertificates.certificateHint' => '証明書コンポーネントが提供されています。',
    'sslcertificates.noCertificateHint' => '証明書コンポーネントが提供されていません。',
    'sslcertificates.caCertificateHint' => 'CA 証明書コンポーネントが提供されています。',
    'sslcertificates.noCaCertificateHint' => 'CA 証明書コンポーネントが提供されていません。',
    'sslcertificates.buttonDownloadHint' => 'すべての証明書コンポーネントをダウンロードします。',
    'sslcertificates.remove' => '削除',
    'sslcertificates.hintRemove' => '選択した SSL/TLS 証明書をドメインリポジトリから削除します。',
    'sslcertificates.confirmOnDelete' => '選択した SSL/TLS 証明書を削除しますか？',
    'sslcertificates.addCertificate' => '追加',
    'sslcertificates.hintAddCertificate' => 'SSL/TLS 証明書を追加します。',
    'sslcertificates.viewCertificates' => '表示',
    'sslcertificates.hintViewCertificates' => 'プロバイダから購入した SSL/TLS 証明書の一覧を表示します。',
    'sslcertificates.unableSetupPanelCertificate' => 'Plesk に証明書をインストールできません。秘密キーおよび証明書のコンテンツがありません。',
    'sslcertificates.makeDefault' => 'デフォルトに指定',
    'sslcertificates.hintMakeDefault' => '選択した SSL/TLS 証明書を使用して、新規作成されたウェブサイトへの接続をセキュリティ強化します。',
    'sslcertificates.unableMakeDefault' => 'デフォルト証明書をインストールできません。秘密キー付きの証明書が選択されていません。',
    'sslcertificates.successMakeDefault' => '選択された SSL/TLS 証明書は、デフォルトとして構成されています。既存のウェブサイトと新規作成されるウェブサイトの両方のセキュリティ強化に使用できます。以前のデフォルト証明書を使用しているウェブサイトは、引き続きその証明書を使用します。',
    'sslcertificates.selectOne' => 'SSL/TLS 証明書を 1 つ選択します。',

    'subscriptions.filterDomainName' => '名前',
    'subscriptions.filterSubscription' => 'サービスプラン',
    'subscriptions.filterOptionSubscriptionAny' => 'すべて',
    'subscriptions.filterOptionSubscriptionMy' => 'マイ・プラン',
    'subscriptions.filterOptionSubscriptionReseller' => '%%planOwnerContactName%%のプラン',
    'subscriptions.filterOptionSubscriptionCustom' => 'カスタム',
    'subscriptions.filterOptionSubscriptionAddonType' => '（アドオン）',
    'subscriptions.filterResourceUsage' => 'リソース使用状況',
    'subscriptions.filterOptionResourceUsageAny' => 'すべて',
    'subscriptions.filterOptionResourceUsageOveruse' => '利用超過リソース',
    'subscriptions.filterOptionResourceUsageOk' => '制限内',
    'subscriptions.filterPlanItem' => 'カスタムプランアイテム',
    'subscriptions.filterOptionPlanItemAny' => 'すべて',
    'subscriptions.filterProvider' => 'プロバイダ',
    'subscriptions.filterOptionProviderAny' => 'すべての契約',
    'subscriptions.filterOptionProviderMy' => '自社用の契約',
    'subscriptions.filterProviderReseller' => '%%resellerContactName%%の契約',
    'subscriptions.filterStatus' => 'ステータス',
    'subscriptions.filterOptionStatusAny' => 'すべて',
    'subscriptions.filterOptionStatusSuspended' => '一時停止',
    'subscriptions.filterOptionStatusActive' => 'アクティブ',
    'subscriptions.filterSubscriptionStatus' => '契約の状態',
    'subscriptions.filterOptionSubscriptionStatusAny' => 'すべて',
    'subscriptions.filterOptionSubscriptionStatusLocked' => 'ロック済み',
    'subscriptions.filterOptionSubscriptionStatusUnsynchronized' => '非同期',
    'subscriptions.filterSubscriberName' => '契約者',
    'subscriptions.filterDescription' => '説明',
    'subscriptions.subscriptionName' => '契約',
    'subscriptions.subscriberName' => '契約者',
    'subscriptions.setupDate' => 'セットアップ日',
    'subscriptions.expirationDate' => '有効期限',
    'subscriptions.description' => '説明',
    'subscriptions.resellerDescription' => 'リセラー',
    'subscriptions.ownerDescription' => '顧客',
    'subscriptions.manageInResellerPanel' => 'リセラーパネルで管理',
    'subscriptions.manageInCustomerPanel' => '顧客パネルで管理',
    'subscriptions.buttonAddNewOwnSubscription' => '自社用の契約を追加',
    'subscriptions.hintAddNewOwnSubscription' => '自分で使用する契約を作成します。',
    'subscriptions.buttonAddNewSubscription' => '契約を追加',
    'subscriptions.hintAddNewSubscription' => '契約を作成します。',
    'subscriptions.buttonChangeSubscription' => 'プランを変更',
    'subscriptions.hintChangeSubscription' => '選択した契約を別のサービスプランに関連付けて、その契約のプロバイダが提供しているプランアドオンを追加または削除します。',
    'subscriptions.buttonRemove' => '削除',
    'subscriptions.hintRemove' => '選択した契約を削除します。',
    'subscriptions.confirmOnRemove' => '選択した契約を削除しますか？',
    'subscriptions.buttonSetStatus' => 'ステータスを設定',
    'subscriptions.hintSetStatus' => '契約のステータスを「アクティブ」または「一時停止」に変更する',
    'subscriptions.buttonActivateSubscriptions' => 'アクティブ',
    'subscriptions.hintActivateSubscriptions' => '選択した契約を有効にします。',
    'subscriptions.buttonSuspendSubscriptions' => '一時停止',
    'subscriptions.hintSuspendSubscriptions' => '選択した契約を一時停止します。 契約で提供しているサービスはすべて凍結され、インターネットからアクセスできなくなります。',
    'subscriptions.buttonChangeOwner' => '契約者を変更',
    'subscriptions.hintChangeOwner' => '選択した契約を別の契約者に割り当て直します。 これによって契約者のプロバイダも変更され、契約からサービスプランが解除され、「カスタム」になります。',
    'subscriptions.customPlanName' => 'カスタム',
    'subscriptions.statusOk' => '契約のステータスは OK です。契約は有効であり、プランと同期されています。',
    'subscriptions.statusSuspended' => 'この契約は一時停止されています。契約で提供されるサービスはすべて凍結されており、インターネットユーザがアクセスできなくなっています。',
    'subscriptions.statusSuspendedReasonExpired' => 'この契約は期限切れにより一時停止されています。契約で提供されるサービスはすべて凍結されており、インターネットユーザがアクセスできなくなっています。',
    'subscriptions.statusLocked' => '同期に対して契約をロックしました。 契約パラメータがカスタマイズされているため、サービスプランとの同期から除外されます。',
    'subscriptions.statusUnsynchronized' => 'この契約はサービスプランと同期されていません。プランで提供されているサービスまたはリソースの一部が契約では提供されていません。',
    'subscriptions.confirmOnDelete' => '{count, plural, =1 {契約 {name} } one {# 件の選択された契約} other {# 件の選択された契約}}を削除してよろしいですか？',
    'subscriptions.hintInfo' => '(?)',
    'subscriptions.webserverConfigurationDomainHintAdmin' => "この契約ドメインのウェブサーバ設定に矛盾がある可能性があります。Apache 設定のテンプレートのエラーを修正して、もう一度構成ファイルを作成してください。",
    'subscriptions.webserverConfigurationDomainHintReseller' => "この契約ドメインのウェブサーバ設定に矛盾がある可能性があります。サーバ管理者に連絡して問題を解決してください。",
    'subscriptions.unlinkedDomainHint' => '一部のドメイン IP アドレスは無効であり、サーバ構成から除外されています。ドメインの IP 禁止を確認し、必要に応じて更新してください。',
    'subscriptions.hintTitle' => '契約の概要',
    'subscriptions.hintWaitMessage' => '読み込み中...',
    'subscriptions.removeConfirmationSubscription' => "次のドメインも削除されます：\n%%domains%%",

    'summaryreportlayouts.delivery' => '配信',
    'summaryreportlayouts.name' => '名前',
    'summaryreportlayouts.general' => '全般',
    'summaryreportlayouts.clients' => '顧客',
    'summaryreportlayouts.resellers' => 'リセラー',
    'summaryreportlayouts.personalClients' => '個人クライアント',
    'summaryreportlayouts.domains' => 'ドメイン',
    'summaryreportlayouts.personalDomains' => '個人ドメイン',
    'summaryreportlayouts.section.FULL' => 'フル',
    'summaryreportlayouts.section.NONE' => 'なし',
    'summaryreportlayouts.section.SUMMARY' => '概要',
    'summaryreportlayouts.groupRemove' => '削除',
    'summaryreportlayouts.buttonRemove' => '削除',
    'summaryreportlayouts.buttonRemoveHint' => '選択されたレイアウトを削除します。',
    'summaryreportlayouts.removeEmptySelection' => '削除するレイアウトを 1 つ以上選択してください',
    'summaryreportlayouts.removeConfirmation' => '{count, plural, =1 {レイアウト {name}} other {# 件のレイアウト}}を削除しますか？',
    'summaryreportlayouts.groupAdd' => '追加',
    'summaryreportlayouts.buttonAdd' => 'レイアウトを追加',
    'summaryreportlayouts.buttonAddHint' => 'レポートレイアウトを追加',
    'summaryreportlayouts.autoDeliveryOn' => 'このレポートは送信されるようにスケジュールされています。',
    'summaryreportlayouts.autoDeliveryOff' => 'このレポートは自動的には送信されません',
    'summaryreportlayouts.removeSuccess' => '選択されたレイアウトは削除されました。',

    'summaryreportschedules.status' => 'S',
    'summaryreportschedules.on' => '有効',
    'summaryreportschedules.off' => '無効',
    'summaryreportschedules.period' => '頻度',
    'summaryreportschedules.lastSentDate' => '最終配信日',
    'summaryreportschedules.email' => '宛先',
    'summaryreportschedules.disabled' => 'オフ',
    'summaryreportschedules.day' => '毎日',
    'summaryreportschedules.week' => '毎週',
    'summaryreportschedules.month' => '毎月',
    'summaryreportschedules.groupAdd' => '追加',
    'summaryreportschedules.buttonAdd' => 'スケジュールを追加',
    'summaryreportschedules.buttonAddHint' => '配信スケジュールを追加',
    'summaryreportschedules.groupRemove' => '削除',
    'summaryreportschedules.buttonRemove' => '削除',
    'summaryreportschedules.buttonRemoveHint' => '選択されたスケジュールを削除します。',
    'summaryreportschedules.removeEmptySelection' => '削除する配信スケジュールを 1 つ以上選択します。',
    'summaryreportschedules.removeConfirmation' => '{count, plural, =1 {選択された配信スケジュール} other {選択された配信スケジュール # 件}}を削除しますか？',
    'summaryreportschedules.removeSuccess' => '選択した配信スケジュールが削除されました。',

    'traffichistory.year' => '年',
    'traffichistory.month' => '月',
    'traffichistory.trafficUsage' => 'トラフィック使用状況',
    'traffichistory.noData' => '履歴データがありません。',

    'webappfirewalllogfiles.name' => '名前',
    'webappfirewalllogfiles.modificationDate' => '変更日時',
    'webappfirewalllogfiles.fileSize' => 'サイズ',
    'webappfirewalllogfiles.remove' => '削除',
    'webappfirewalllogfiles.hintRemove' => '選択したログファイルを削除します。処理したログファイルのみを削除できます。',
    'webappfirewalllogfiles.confirmOnDelete' => '選択したログファイルを削除しますか？',
    'webappfirewalllogfiles.viewHint' => 'ログファイルを表示します。',
    'webappfirewalllogfiles.buttonDownloadHint' => 'ログファイルをダウンロードします。',

    'webmails.name' => '名前',
    'webmails.url' => 'URL',
    'webmails.buttonAddNewWebmail' => 'ウェブメールを登録',
    'webmails.hintAddNewWebmail' => '追加ウェブメールサービスを Plesk に登録します。',
    'webmails.buttonEnableWebmail' => '有効化',
    'webmails.hintEnableWebmail' => '選択したウェブメールサービスを顧客が使用できるようにします。',
    'webmails.buttonDisableWebmail' => '無効化',
    'webmails.hintDisableWebmail' => '選択したウェブメールサービスを顧客が使用できないようにします。',
    'webmails.buttonRemoveWebmail' => '削除',
    'webmails.hintRemoveWebmail' => '選択した追加ウェブメールサービスの登録を削除します。Plesk インストーラでインストールされたウェブメールをここで削除することはできません。［ツール］ > ［アップデート］で行ってください。',
    'webmails.confirmOnDelete' => '選択したウェブメール登録を Plesk から削除しますか？',
    'webmails.statusSuspended' => 'ウェブメールを使用できません。',
    'webmails.statusOk' => 'ウェブメールを使用できます。',
];