<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'adminaliases.statusActive' => 'Kontot är aktivt.',
    'adminaliases.statusInactive' => 'Kontot är upphävt: denna administratör kan inte logga in till Plesk.',
    'adminaliases.buttonRemoveAdminAlias' => 'Ta bort',
    'adminaliases.hintRemoveAdminAlias' => 'Ta bort valda administratörskonton.',
    'adminaliases.confirmOnRemove' => 'Vill du verkligen ta bort markerade administratörskonton?',
    'adminaliases.buttonAddNewAdminAlias' => 'Lägg till administratörskonto',
    'adminaliases.hintAddNewAdminAlias' => 'Skapa ett extra administratörskonto.',
    'adminaliases.buttonMoreActions' => 'Mer',
    'adminaliases.buttonActivateAdminAlias' => 'Aktivera',
    'adminaliases.hintActivateAdminAlias' => 'Aktivera upphävda administratörskonton.',
    'adminaliases.buttonDeactivateAdminAlias' => 'Stäng',
    'adminaliases.hintDeactivateAdminAlias' => 'Upphäv valda administratörskonton. Plesk nekar åtkomst för dessa administratörer.',
    'adminaliases.confirmOnDelete' => 'Vill du verkligen ta bort markerade administratörskonton?',
    'adminaliases.login' => 'Användarnamn',
    'adminaliases.contact' => 'Kontakt namn',
    'adminaliases.email' => 'E-post',
    'adminaliases.comments' => 'Kommentarer',

    'appinfo.installedAt' => 'Installationssökväg',
    'appinfo.noInstallationUrlAvailable' => 'Ingen',
    'appinfo.subscriptionName' => 'Abonnemang',
    'appinfo.subscriptionOwner' => 'Abonnemangets ägare',
    'appinfo.buttonLogin' => 'Öppna i Kundpanelen',
    'appinfo.buttonLoginClassicMode' => 'Hantera värdtjänster',
    'appinfo.hintLogin' => 'Öppna abonnentens Kundpanel.',
    'appinfo.hintAdminLogin' => 'Hantera värdtjänsttjänster som är associerade med ett visst värdtjänstkonto: domäner och DNS, webbprogram och databaser, e-post osv.',
    'appinfo.hintLoginClassicMode' => 'Hantera värdtjänsttjänster som är associerade med ett visst värdtjänstkonto: domäner och DNS, webbprogram och databaser, e-post osv.',
    'appinfo.update' => 'Uppdateringar är tillgängliga.',
    'appinfo.updateFailed' => 'Uppdateringen misslyckades.',
    'appinfo.noUpdates' => 'Inga uppdateringar är tillgängliga.',
    'appinfo.foundUpdates' => 'Uppdateringar är tillgängligt för följande appar:',
    'appinfo.buttonCheckForUpdates' => 'Sök efter uppdateringar',
    'appinfo.buttonCheckForUpdatesDescription' => 'Sök efter tillgängliga uppdateringar',
    'appinfo.buttonChangeSettings' => 'Inställningar',
    'appinfo.buttonChangeSettingsDescription' => 'Ändra serveromfattande inställningar för appen.',
    'appinfo.appNotConfigured' => 'Inte konfigurerad',

    'appuploaded.name' => 'Namn',
    'appuploaded.numberOfInstances' => 'Antal installationer',
    'appuploaded.buttonUploadNewApp' => 'Lägg till app',
    'appuploaded.buttonUploadNewAppDescription' => 'Lägg till ett app-paket till servern.',
    'appuploaded.buttonRemove' => 'Ta bort',
    'appuploaded.buttonRemoveDescription' => 'Ta bort markerade paket.',
    'appuploaded.confirmOnDelete' => 'Är du säker på att du vill ta bort valda paket?',
    'appuploaded.appInvisible' => 'Inte tillgänglig för kunderna',
    'appuploaded.appGlobalSettingsNotSet' => 'Inte konfigurerad',
    'appuploaded.buttonMakeAppVisible' => 'Gör tillgänglig',
    'appuploaded.buttonMakeAppVisibleDescription' => 'Gör apparna tillgängliga för installation av kunderna.',
    'appuploaded.buttonMakeAppInvisible' => 'Gör otillgängligt',
    'appuploaded.buttonMakeAppInvisibleDescription' => 'Gör apparna otillgängliga för installation av kunderna.',

    'appusage.name' => 'Namn',
    'appusage.numberOfInstances' => 'Antal installationer',
    'appusage.buttonCleanApplicationCache' => 'Rensa cache',
    'appusage.buttonCleanApplicationCacheDescription' => 'Ta bort temporära filer nedladdade under installation av appar.',
    'appusage.buttonRedirectToMarket' => 'Gå till webbutiken',
    'appusage.buttonRedirectToMarketDescription' => 'Köp programlicenser för installation på webbplatser.',
    'appusage.updateFailed' => 'Uppdateringen misslyckades.',
    'appusage.noUpdates' => 'Inga uppdateringar är tillgängliga.',
    'appusage.foundUpdates' => 'Uppdateringar är tillgängligt för följande appar:',
    'appusage.buttonCheckForUpdates' => 'Sök efter uppdateringar',
    'appusage.buttonCheckForUpdatesDescription' => 'Kontrollera tillgängliga uppdateringar i programkatalogen.',
    'appusage.buttonUpdateSettings' => 'Uppdatera inställningar',
    'appusage.buttonUpdateSettingsDescription' => 'Serveromfattande app-uppdateringsinställningar.',

    'controlpanelaccessnetworks.ipAddress' => 'IP-adress',
    'controlpanelaccessnetworks.subnetMask' => 'Subnätmask',
    'controlpanelaccessnetworks.buttonAddNewNetwork' => 'Lägg till nätverk',
    'controlpanelaccessnetworks.buttonAddNewNetworkDescription' => 'Klicka för att lägga till nätverket till åtkomstlistan över begränsningar.',
    'controlpanelaccessnetworks.buttonRemove' => 'Ta bort',
    'controlpanelaccessnetworks.buttonRemoveDescription' => 'Klicka för att ta bort de valda nätverken från listan.',
    'controlpanelaccessnetworks.confirmOnDelete' => 'Vill du ta bort valda nätverk?',
    'controlpanelaccessnetworks.buttonSettings' => 'Inställningar',
    'controlpanelaccessnetworks.buttonSettingsDescription' => 'Klicka för att ändra åtkomstens begränsningspolicy.',
    'controlpanelaccessnetworks.loadingTitle' => 'Vänta. Laddar...',

    'customers.filterCustomerName' => 'Kundens namn',
    'customers.filterSubscription' => 'Abonnemang',
    'customers.filterOptionSubscriptionAny' => 'Valfri',
    'customers.filterOptionSubscriptionMy' => 'Mina planer',
    'customers.filterOptionSubscriptionReseller' => '%%planOwnerContactName%% planer', // Note for translators: you can use here structure like "Plans of Reseller <name>" or alike if it is more convenient
    'customers.filterOptionSubscriptionCustom' => 'Anpassad',
    'customers.filterOwnership' => 'Leverantör',
    'customers.filterOptionOwnershipAny' => 'Alla kunder',
    'customers.filterOptionOwnershipMy' => 'Mina kunder',
    'customers.filterOwnershipReseller' => '%%resellerContactName%% kunder', //Note for translators: see 'filterOptionSubscriptionReseller'
    'customers.filterResourceUsage' => 'Resurs-användning',
    'customers.filterOptionResourceUsageAny' => 'Valfri',
    'customers.filterOptionResourceUsageOveruse' => 'Överanvända resurser',
    'customers.filterOptionResourceUsageOk' => 'Inom gränserna',
    'customers.filterStatus' => 'Status',
    'customers.filterOptionStatusAny' => 'Valfri',
    'customers.filterOptionStatusSuspended' => 'Avstängd',
    'customers.filterOptionStatusActive' => 'Aktiva',
    'customers.filterDescription' => 'Beskrivning',
    'customers.statusOk' => 'Kundkontot är aktivt.',
    'customers.statusInactive' => 'Kundkontot är inaktivt: åtkomsten till Kundpanelen är blockerad för kunden.',
    'customers.statusSuspended' => 'Kundkontot är upphävt: åtkomsten till Kundpanelen är blockerad för kunden och alla användare. Kundens domäner är upphävda och deras webb-, FTP- och e-posttjänster kommer inte längre att vara tillgängliga för Internet-användare.',
    'customers.customerName' => 'Kundens namn',
    'customers.subscription' => 'Abonnemang',
    'customers.setupDate' => 'Konfigurationsdatum',
    'customers.ownerName' => 'Leverantör',
    'customers.buttonLogin' => 'Logga in som kund',
    'customers.buttonLoginClassicMode' => 'Hantera värdtjänster',
    'customers.hintLogin' => 'Logga in som kund.',
    'customers.hintLoginClassicMode' => 'Hantera värdtjänsttjänster som är associerade med kundens värdtjänstkonto: domäner och DNS, webbprogram och databaser, e-post osv.',
    'customers.buttonRemoveCustomer' => 'Ta bort',
    'customers.hintRemoveCustomer' => 'Ta bort markerade kunder.',
    'customers.confirmOnRemove' => 'Vill du verkligen ta bort markerade kundkonton?',
    'customers.buttonConvertCustomersToReseller' => 'Omvandla till återförsäljare',
    'customers.hintConvertCustomersToReseller' => 'Omvandla valda kundkonton till återförsäljarkonton.',
    'customers.buttonAddNewCustomer' => 'Lägg till kund',
    'customers.hintAddNewCustomer' => 'Skapa ett kundkonto med abonnemang.',
    'customers.buttonChangeStatus' => 'Ändra status',
    'customers.hintChangeStatus' => 'Byt kundens status till "Aktiv" eller "Avstängd"',
    'customers.buttonSuspendCustomers' => 'Stäng',
    'customers.hintSuspendCustomers' => 'Upphäv valda kundkonton. Åtkomsten till Kundpanelen blockeras för kunderna och alla användare: kundernas domäner upphävs och deras webb-, FTP- och e-posttjänster kommer inte längre att vara tillgängliga för Internet-användare.',
    'customers.buttonActivateCustomers' => 'Aktivera',
    'customers.hintActivateCustomers' => 'Aktivera valda kundkonton.',
    'customers.buttonChangeOwner' => 'Flytta',
    'customers.hintChangeOwner' => 'Flytta valda kunder till annan återförsäljare.',
    'customers.customPlanName' => 'Anpassad',
    'customers.selectNewIp' => 'Markera en IP-adress',
    'customers.selectAnotherOwner' => 'Välj en ägare.',
    'customers.shared' => 'delad',
    'customers.exclusive' => 'dedikerad',
    'customers.confirmOnDelete' => 'Är du säker på att du vill ta bort {count, plural, =1 {kundkontot {name}} one {det # valda kundkontot} other {de # valda kundkontona}}?',
    'customers.hintInfo' => '(?)',

    'customerserviceplans.planName' => 'Plan Namn',
    'customerserviceplans.planTraffic' => 'Trafik',
    'customerserviceplans.planDiskSpace' => 'Diskutrymme',
    'customerserviceplans.planSubscriptions' => 'Abonnemang',
    'customerserviceplans.planOwner' => 'Leverantör',
    'customerserviceplans.filterPlanItem' => 'Anpassad planpost',
    'customerserviceplans.filterOptionPlanItemAny' => 'Valfri',
    'customerserviceplans.filterOwnership' => 'Plan Ägare',
    'customerserviceplans.filterOptionOwnershipAny' => 'Alla planer',
    'customerserviceplans.filterOptionOwnershipMy' => 'Mina planer',
    'customerserviceplans.filterOwnershipReseller' => '%%resellerContactName%% planer',
    'customerserviceplans.unlimited' => 'Obegränsat',
    'customerserviceplans.addonPlanType' => '(tillägg)',
    'customerserviceplans.buttonAddNewPlan' => 'Lägga till en Plan',
    'customerserviceplans.hintAddNewPlan' => 'Skapa en värdtjänstplan.',
    'customerserviceplans.buttonDuplicatePlans' => 'Klona planer',
    'customerserviceplans.hintDuplicatePlans' => 'Skapa kopior på valda tjänsteplaner.',
    'customerserviceplans.buttonAddNewAddonPlan' => 'Lägg till en Add-on',
    'customerserviceplans.hintAddNewAddonPlan' => 'Skapa ett värdtjänstplantillägg.',
    'customerserviceplans.buttonRemove' => 'Ta bort',
    'customerserviceplans.hintRemove' => 'Ta bort valda tjänsteplaner.',
    'customerserviceplans.buttonMoreActions' => 'Fler åtgärder',
    'customerserviceplans.confirmOnDelete' => 'Vill du verkligen ta bort markerade tjänsteplaner?',
    'customerserviceplans.disabledSelectHint' => 'Tjänsteplanen har minst ett abonnemang associerat till det och kan inte tas bort.',

    'domains.filterHint' => 'Filtrera domäner efter kriterier',
    'domains.filterDomainName' => 'Namn',
    'domains.filterStatus' => 'Status',
    'domains.filterOptionStatusAny' => 'Valfri',
    'domains.filterOptionStatusSuspended' => 'Avstängd',
    'domains.filterOptionStatusDisabled' => 'Inaktiverad',
    'domains.filterOptionStatusActive' => 'Aktiva',
    'domains.filterHostingType' => 'Tjänstetyp',
    'domains.filterPhpHandler' => 'PHP-hanterare',
    'domains.filterOptionPhpHandlerAny' => 'Valfri',
    'domains.filterOptionHostingTypeAny' => 'Valfri',
    'domains.filterOptionHostingTypeNone' => 'Inga värdtjänster',
    'domains.filterOptionHostingTypeForward' => 'Domänvidarebefordran',
    'domains.filterOptionHostingTypeAlias' => 'Domänalias',
    'domains.filterOptionHostingTypeVirtualHost' => 'Domänvärdtjänst',
    'domains.filterOptionHostingTypeSubdomain' => 'Underdomänens värdtjänst',
    'domains.filterSubscriberName' => 'Abonnent',
    'domains.filterServiceNode' => 'Tjänstenod',
    'domains.filterServiceNodeOptionAny' => 'Valfri',
    'domains.filterDescription' => 'Beskrivning',
    'domains.filterTitlePlaceholder' => 'Hitta domäner...',
    'domains.filterTitle' => 'Filter',
    'domains.filterApply' => 'Använd filter',
    'domains.filterClear' => 'Rensa',
    'domains.statusDisabled' => 'Domänen är inaktiverad.',
    'domains.statusSuspended' => 'Domänen är avstängd.',
    'domains.domainName' => 'Domännamn',
    'domains.hostingType' => 'Tjänstetyp',
    'domains.ownerName' => 'Abonnent',
    'domains.setupDate' => 'Konfigurationsdatum',
    'domains.expirationDate' => 'Utgångsdatum',
    'domains.diskUsage' => 'Diskanvändning',
    'domains.traffic' => 'Trafik',
    'domains.status' => 'Status',
    'domains.description' => 'Beskrivning',
    'domains.resellerDescription' => 'Återförsäljare',
    'domains.ownerDescription' => 'Kund',
    'domains.openSite' => 'Öppen',
    'domains.previewSite' => 'Förhandsgranska',
    'domains.manageInResellerPanel' => 'Hantera i Återförsäljarpanelen',
    'domains.manageInCustomerPanel' => 'Hantera i Kundpanelen',
    'domains.customPlanName' => 'Anpassad',
    'domains.website' => 'Webbsida',
    'domains.subdomainWebsite' => 'Underdomänens webbplats',
    'domains.noHosting' => 'Inga värdtjänster',
    'domains.forwardingTo' => 'Vidarebefordra till',
    'domains.aliasFor' => 'Alias för',
    'domains.forwardingToDomain' => 'vidarebefordra till %%domain%%',
    'domains.aliasForDomain' => 'alias för %%domain%%',
    'domains.add' => 'lägg till',
    'domains.buttonAddDomain' => 'Lägg till domän',
    'domains.hintAddDomain' => 'Webbasera en ny webbplats på denna server, ställ in webben för vidarebefordran till en annan webbpalts eller ställ in en domäns DNS-zon du vill endast ha e-postadresser på under ett domännamn.',
    'domains.buttonAddSubdomain' => 'Lägg till subdomän',
    'domains.hintAddSubdomain' => 'Skapa en site som adresseras med ett tredjenivå-domännamn, som shop.example.com.',
    'domains.buttonAddDomainAlias' => 'Lägg till domänalias',
    'domains.hintAddDomainAlias' => 'Konfigurera ytterligare ett domännamn för din site.',
    'domains.hintRemove' => 'Ta bort valda webbplatser och alla deras webbinnehåll, appar, databaser och e-post.',
    'domains.removeConfirmation' => 'Är du säker på att du vill ta bort {count, plural, =1 {domänen {name}} one {den # valda domänen} other {de # valda domänerna}}?',
    'domains.removeConfirmationSubscription' => "Följande domäner kommer också att tas bort:\n%%domains%%",
    'domains.buttonSetStatus' => 'Ställ in status',
    'domains.hintSetStatus' => 'Byt domänens status till "Aktiv", "Avstängd" eller "Inaktiverad"',
    'domains.activateActionStatus' => 'Aktiv',
    'domains.hintActivateDomains' => 'Gör de valda domänerna aktiva.',
    'domains.disableActionStatus' => 'Inaktiverad',
    'domains.hintDisableDomains' => 'Inaktivera valda domäner.',
    'domains.suspendActionStatus' => 'Avstängd',
    'domains.hintSuspendDomains' => 'Stäng av de valda domänerna.',
    'domains.changeStatusNoItems' => 'Välj en eller fler domäner för att ändra deras status',
    'domains.removeNoItems' => 'Välj en eller flera domäner att ta bort',
    'domains.activated' => 'Valda domäner och alias har aktiverats',
    'domains.disabled' => 'Valda domäner och alias har inaktiverats',
    'domains.suspended' => 'Valda domäner och alias har stängts av',

    'dnsaclrecords.value' => 'IP-adress',
    'dnsaclrecords.add' => 'Lägg till IP-adress',
    'dnsaclrecords.remove' => 'Ta bort',
    'dnsaclrecords.hintRemove' => 'Ta bort valda IP-adresser.',
    'dnsaclrecords.confirmOnDelete' => 'Ta bort de valda IP-adresserna?',
    'dnsaclrecords.emptyViewTitle' => 'Zonöverföring tillåts inte',
    'dnsaclrecords.emptyViewDescription1' => 'Av säkerhetsskäl kan du endast tillåta en överföring av DNS-zonen till servrar som angetts i zonens NS-poster.',
    'dnsaclrecords.emptyViewDescription2' => 'För att ange en eller flera servrar du tillåter överföringen till, klicka på "Lägg till IP-adresser".',

    'eventhandlers.event' => 'Händelse',
    'eventhandlers.priority' => 'Prioritet',
    'eventhandlers.priorityHighest' => 'högst (%%value%%)',
    'eventhandlers.priorityHigh' => 'hög (%%value%%)',
    'eventhandlers.priorityNormal' => 'normal (%%value%%)',
    'eventhandlers.priorityLow' => 'låg (%%value%%)',
    'eventhandlers.priorityLowest' => 'lägst (%%value%%)',
    'eventhandlers.user' => 'Användare',
    'eventhandlers.command' => 'Kommando',
    'eventhandlers.buttonAddNewEventHandler' => 'Lägg till Händelsehanterare',
    'eventhandlers.buttonAddNewEventHandlerDescription' => 'Ställa in en ny händelsehanterare.',
    'eventhandlers.buttonRemove' => 'Ta bort',
    'eventhandlers.buttonRemoveDescription' => 'Ta bort de valda händelsehanterarna.',
    'eventhandlers.confirmOnDelete' => 'Ta bort de valda händelsehanterarna?',

    'firewallicmprules.status' => 'Status',
    'firewallicmprules.on' => 'Regeln är aktiv.',
    'firewallicmprules.off' => 'Regeln är inte aktiv.',
    'firewallicmprules.name' => 'Regelnamn',
    'firewallicmprules.allowinboundrouterrequest' => 'Tillåt inkommande begäran om router',
    'firewallicmprules.allowinboundtimestamprequest' => 'Tillåt inkommande begäran om tidstämpling',
    'firewallicmprules.allowinboundmaskrequest' => 'Tillåt inkommande maskbegäran',
    'firewallicmprules.allowoutboundsourcequench' => 'Tillåt utgående källavstängning',
    'firewallicmprules.allowoutboundparameterproblem' => 'Tillåt utgående parameterproblem',
    'firewallicmprules.allowredirect' => 'Tillåt omdirigering',
    'firewallicmprules.allowinboundechorequest' => 'Tillåt inkommande ekobegäran',
    'firewallicmprules.allowoutboundtimeexceeded' => 'Tillåt överskridning av utgående tid',
    'firewallicmprules.allowoutbounddestinationunreachable' => 'Tillåt utgående där mål inte kan nås',

    'firewallinterfaces.firewall' => 'Brandväggsstatus',
    'firewallinterfaces.firewallOn' => 'Brandväggen är påslagen för detta nätverksgränssnitt.',
    'firewallinterfaces.firewallOff' => 'Brandväggen är avslagen för detta nätverksgränssnitt.',
    'firewallinterfaces.connection' => 'Gränssnittsstatus',
    'firewallinterfaces.connectionOn' => 'Nätverksgränssnittsanslutningen är påslagen.',
    'firewallinterfaces.connectionOff' => 'Nätverksgränssnittsanslutningen är avstängd.',
    'firewallinterfaces.name' => 'Gränssnittsnamn',
    'firewallinterfaces.type' => 'Gränssnittstyp',
    'firewallinterfaces.statusOn' => 'På',
    'firewallinterfaces.statusOff' => 'Av',

    'firewallrules.status' => 'Status',
    'firewallrules.on' => 'Regeln är aktiv.',
    'firewallrules.off' => 'Regeln är inte aktiv.',
    'firewallrules.name' => 'Regelnamn',
    'firewallrules.description' => 'Beskrivning',
    'firewallrules.descriptionText' => '%%action%% inkommande anslutningar från %%from%% på port %%port%%, profiler: %%profiles%%',
    'firewallrules.allow' => 'Tillåt',
    'firewallrules.block' => 'Förneka',
    'firewallrules.fromAll' => 'alla',
    'firewallrules.groupAdd' => 'Lägg till',
    'firewallrules.buttonAdd' => 'Lägg till regel',
    'firewallrules.buttonAddHint' => 'Lägg till brandväggsregel',
    'firewallrules.groupActions' => 'Åtgärder',
    'firewallrules.buttonRemove' => 'Ta bort',
    'firewallrules.removeEmptySelection' => 'Inga brandväggsregler har valts.',
    'firewallrules.removeConfirmation' => 'Ta bort {count, plural, =1 {brandväggsregeln {name}} one {den # valda brandväggsregeln} other {de # valda brandväggsreglerna}}?',
    'firewallrules.removeSuccess' => 'Valda brandväggsregler togs bort.',

    'ftpsessions.buttonRemove' => 'Stäng',
    'ftpsessions.buttonRemoveDescription' => 'Stäng valda FTP-sessioner',
    'ftpsessions.buttonRefresh' => 'Uppdatera',
    'ftpsessions.buttonRefreshDescription' => 'Uppdatera data på skärmen',
    'ftpsessions.typeColumnName' => 'T',
    'ftpsessions.statusColumnName' => 'S',
    'ftpsessions.loginColumnName' => 'Inloggning',
    'ftpsessions.domainColumnName' => 'Domännamn',
    'ftpsessions.currentLocationColumnName' => 'Aktuell plats',
    'ftpsessions.fileNameColumnName' => 'Filnamn',
    'ftpsessions.speedColumnName' => 'Hastighet, KB/S',
    'ftpsessions.progressColumnName' => 'Förlopp, %',
    'ftpsessions.ipAddressColumnName' => 'IP-adress',
    'ftpsessions.logonTimeColumnName' => 'Inloggningstid',
    'ftpsessions.idleTimeColumnName' => 'Inaktivitet',
    'ftpsessions.sessionTypeDomainAdminTooltip' => 'Domänens administratörssession.',
    'ftpsessions.sessionTypeSubDomainAdminTooltip' => 'Underdomänens administratörssession.',
    'ftpsessions.sessionTypeWebUserTooltip' => 'Webbanvändarens session.',
    'ftpsessions.sessionTypeFtpAccountTooltip' => 'FTP-kontosession.',
    'ftpsessions.sessionTypeAnonymousTooltip' => 'Anonym FTP-användarsession.',
    'ftpsessions.sessionTypeNotPleskUserTooltip' => 'FTP-användare som inte är registrerad i Plesk.',
    'ftpsessions.sessionStatusIdle' => 'Ledig (inga transaktioner).',
    'ftpsessions.sessionStatusUploadInProgress' => 'Uppladdning pågår.',
    'ftpsessions.sessionStatusDownloadInProgress' => 'Hämtning pågår.',
    'ftpsessions.sessionStatusDownloadingDirsList' => 'Laddar ner en lista över kataloger.',
    'ftpsessions.sessionStatusLastCmdIsType' => 'Det senaste kommandot som har skickats av kunden är TYPE.',
    'ftpsessions.sessionStatusLastCmdIsPass' => 'Det senaste kommandot som har skickats av kunden är PASS.',
    'ftpsessions.sessionStatusLastCmdIsNoop' => 'Det senaste kommandot som har skickats av kunden är NOOP.',
    'ftpsessions.sessionStatusNotKnown' => 'Oidentifierad FTP-aktivitet.',
    'ftpsessions.confirmOnDelete' => 'Vill du verkligen avsluta valda sessioner?',

    'ipaddresses.buttonAddNewIpAddress' => 'Lägg till IP-adress',
    'ipaddresses.buttonAddNewIpAddressDescription' => 'Lägg till en IP-adress till serverpoolen för IP-adresser.',
    'ipaddresses.buttonRereadConfiguration' => 'Läs om IP',
    'ipaddresses.buttonRereadConfigurationDescription' => 'Synkronisera listan över IP-adresser med konfigurationen av nätverkskorten.',
    'ipaddresses.buttonReloadPublic' => 'Uppdatera publika IP:n',
    'ipaddresses.buttonReloadPublicDescription' => 'Uppdatera publika IP-adresser baserat på metadata för hyperscaler-instansen',
    'ipaddresses.buttonFirewall' => 'Brandvägg',
    'ipaddresses.buttonFirewallDescription' => 'Konfigurera brandvägg.',
    'ipaddresses.buttonRemove' => 'Ta bort',
    'ipaddresses.buttonRemoveDescription' => 'Ta bort',
    'ipaddresses.confirmOnDelete' => 'Ta bort valda IP-adresser?',
    'ipaddresses.address' => 'IP-adress',
    'ipaddresses.publicAddress' => 'Offentlig IP-adress',
    'ipaddresses.type' => 'IP-typ',
    'ipaddresses.interface' => 'Gränssnitt',
    'ipaddresses.resellerCount' => 'Återförsäljare',
    'ipaddresses.subscriptionCount' => 'Platser',
    'ipaddresses.typeAny' => 'Valfri',
    'ipaddresses.typeShared' => 'Delad',
    'ipaddresses.typeExclusive' => 'Dedikerad',
    'ipaddresses.typeSharedHint' => 'delad',
    'ipaddresses.typeExclusiveHint' => 'dedikerad',
    'ipaddresses.ipAddressBroken' => 'Denna IP-adress är inte ordentligt konfigurerad.',
    'ipaddresses.ipAddressBlacklisted' => 'Denna IP-adress är svartlistad.',
    'ipaddresses.repair' => 'Reparera',
    'ipaddresses.buttonSearch' => 'Sök',
    'ipaddresses.buttonResetSearch' => 'Återställ sökning',
    'ipaddresses.removeConfirmation' => 'Är du säker på att du vill ta bort {count, plural, =1 {IP-addressen {name}} one {# vald IP-adress} other {de # valda IP-adresserna}}?',
    'ipaddresses.hint' => 'Visa, lägga till, ta bort IP-adresser.',
    'ipaddresses.hintWithResellers' => 'Visa, lägg till och ta bort IP-adresser samt tilldela IP-adresser till återförsäljare.',
    'ipaddresses.repairSuccess' => 'IP-adressen %%address%% har synkroniserats med systemet.',
    'ipaddresses.removeSuccess' => 'De valda IP-adresserna har tagits bort.',

    'resourceusage.clientName' => 'Kundens namn',
    'resourceusage.domainName' => 'Domännamn',
    'resourceusage.diskUsage' => 'DU',
    'resourceusage.traffic' => 'TR',
    'resourceusage.subDomainsCount' => 'SD',
    'resourceusage.webUsersCount' => 'WU',
    'resourceusage.databasesCount' => 'DB',
    'resourceusage.mailBoxesCount' => 'MBox',
    'resourceusage.autoRepliesCount' => 'MA',
    'resourceusage.mailForwardingsCount' => 'Vidarebef.',
    'resourceusage.mailListsCount' => 'ML',
    'resourceusage.sendByEmail' => 'Klicka för att skicka denna rapport via e-post',
    'resourceusage.buttonSendByEmail' => 'Skicka med e-post',
    'resourceusage.noResults' => 'Ingen information om domäners resursanvändning.',
    'resourceusage.reportWasSent' => 'Information: rapporten skickades till e-post: %%email%%',

    'languages.headerStatus' => 'S',
    'languages.headerCode' => 'Språkpaket',
    'languages.headerLanguage' => 'Språk',
    'languages.headerCountry' => 'Land',
    'languages.headerUsed' => 'Används',
    'languages.filterCode' => 'Språkpaket',
    'languages.buttonDisable' => 'Inaktivera',
    'languages.buttonDisableDescription' => 'Gör de valda språken otillgängliga för användare.',
    'languages.disableDone' => 'De valda språken är inte längre tillgängliga för användare.',
    'languages.buttonEnable' => 'Aktivera',
    'languages.buttonEnableDescription' => 'Gör de valda språken tillgängliga för användare.',
    'languages.enableDone' => 'De valda språken blir tillgängliga för användare.',
    'languages.buttonMakeDefault' => 'Ange som standard',
    'languages.buttonMakeDefaultDescription' => 'Gör det valda språket till standard för Plesk.',
    'languages.makeDefaultDone' => 'Valt språk har angetts som standard för Plesk.',
    'languages.makeDefaultSelectOne' => 'Välj ett språk som du vill ange som standard för Plesk.',
    'languages.statusActive' => 'Detta språk är tillgängligt för Plesk-användare.',
    'languages.statusActiveUnavailable' => 'Detta språk har blivit otillgängligt för att användare eftersom din gräns för antalet tillåtna språk är överskriden.',
    'languages.buttonHintStatusActive' => 'Klicka på denna ikon för att göra språket otillgängligt för användare.',
    'languages.statusInactive' => 'Detta språk är inte tillgängligt för användare.',
    'languages.buttonHintStatusInactive' => 'Klicka på denna ikon för att göra språket tillgängligt för användare.',
    'languages.buttonHintStatusDefaultLangugage' => 'Detta är standardspråket, du kan inte göra det otillgängligt för användare.',
    'languages.langUnknown' => 'Kan inte känna igen språket',
    'languages.countryUnknown' => 'Kunde inte känna igen landets underkod',

    'mailqueue.filterQueue' => 'Köer',
    'mailqueue.filterSubject' => 'Ämne',
    'mailqueue.filterSender' => 'Avsändare',
    'mailqueue.filterRecipients' => 'Mottagare',
    'mailqueue.subject' => 'Ämne',
    'mailqueue.sender' => 'Avsändare',
    'mailqueue.recipients' => 'Mottagare',
    'mailqueue.date' => 'Datum',
    'mailqueue.age' => 'Ålder',
    'mailqueue.size' => 'Storlek',
    'mailqueue.buttonRefresh' => 'Uppdatera',
    'mailqueue.buttonRefreshHint' => 'Uppdatera data på skärmen.',
    'mailqueue.buttonRemove' => 'Ta bort',
    'mailqueue.buttonRemoveHint' => 'Ta bort valda meddelanden ur e-postkön.',
    'mailqueue.confirmOnDelete' => 'Vill du verkligen ta bort valda meddelanden ur e-postkön?',
    'mailqueue.buttonClean' => 'Rensa',
    'mailqueue.buttonCleanHint' => 'Radera e-postkön för alla meddelanden.',
    'mailqueue.confirmOnClean' => 'Vill du verkligen radera e-postkön?',
    'mailqueue.queueAll' => 'Alla',
    'mailqueue.queueTodo' => 'Inte förprocessad',
    'mailqueue.queueRemote' => 'Fjärr',
    'mailqueue.queueLocal' => 'Lokalt',
    'mailqueue.queueLocalAndRemote' => 'Lokal och fjärrplacerad',
    'mailqueue.queueActive' => 'Aktiv meddelandekö',
    'mailqueue.queueCorrupted' => 'Kö med korrupta meddelanden',
    'mailqueue.queueDeferred' => 'Kö med uppskjutna meddelanden',
    'mailqueue.queueHold' => 'Kö med meddelanden som hålls',
    'mailqueue.queueIncoming' => 'Kö med inkommande meddelanden',
    'mailqueue.postfixHint' => 'Meddelanden i kön: %%deferred%% deferred, %%hold%% held, %%incoming%% incoming, %%active%% active, %%corrupted%% corrupted, %%total%% total.',
    'mailqueue.qmailHint' => 'Meddelanden i kön: %%todo%% not preprocessed, %%local%% local, %%remote%% remote, %%total%% total.',
    'mailqueue.messagesDeleted' => 'Ta bort valda meddelanden ur e-postkön.',
    'mailqueue.messagesNotDeleted' => 'Kan inte ta bort vissa meddelanden från e-postkön: %%error%%',
    'mailqueue.queueCleaned' => 'E-postkön raderades korrekt.',
    'mailqueue.queueNotCleaned' => 'Kan inte radera e-postkön: %%error%%.',

    'phpextensions.enable' => 'Aktivera tillägg',
    'phpextensions.disable' => 'Inaktivera tillägg',

    'phpextensions.installable.status' => 'Status',
    'phpextensions.installable.notInstalled' => 'Inte installerat',
    'phpextensions.installable.outdated' => 'Föråldrad, senaste versionen är %%latestVersion%%',
    'phpextensions.installable.latest' => 'Senaste',
    'phpextensions.installable.name' => 'Paket',
    'phpextensions.installable.description' => 'Beskrivning',
    'phpextensions.installable.actionInstall' => 'Installera',
    'phpextensions.installable.actionUpgrade' => 'Uppgradera till %%version%%',
    'phpextensions.installable.actionDocs' => 'Dokumentation',
    'phpextensions.installable.actionUninstall' => 'Avinstallera',
    'phpextensions.installable.uninstallConfirmation' => 'Vill du verkligen avinstallera paketet %%name%%?',
    'phpextensions.installable.groupInstall' => 'Installera',
    'phpextensions.installable.groupReload' => 'Läsa in igen',
    'phpextensions.installable.buttonInstallCustom' => 'Installera paket',
    'phpextensions.installable.buttonInstallCustomHint' => 'Installera valfritt PECL-paket',
    'phpextensions.installable.buttonReload' => 'Läsa in igen',
    'phpextensions.installable.buttonReloadHint' => 'Ladda om PECL-paket',
    'phpextensions.installable.emptyViewFilteredTitle' => 'Kunde inte hitta några paket som matchar filtret',
    'phpextensions.installable.emptyViewFilteredDescription' => 'Testa att installera paketet du söker efter.',

    'phphandlers.name' => 'hanterare',
    'phphandlers.domains' => 'Domäner',
    'phphandlers.statusBroken' => 'Denna hanterare är korrupt.',
    'phphandlers.statusDisallowedApacheModule' => 'Hanteraren kan inte aktiveras eftersom motsvarande Apache-modul är avstängd.',
    'phphandlers.domainsTitle' => '%%domains%% domäner använder PHP %%handler%%',
    'phphandlers.closeTitle' => 'Stäng',
    'phphandlers.handlerOutdated' => '(Föråldrad)',
    'phphandlers.handlerDeprecated' => '(Avrådd)',
    'phphandlers.handlerOutdatedAndDeprecated' => '(Föråldrad, avrådd)',

    'planitems.name' => 'Namn',
    'planitems.numberOfPlans' => 'Tjänsteplans',
    'planitems.numberOfSubscriptions' => 'Abonnemang',
    'planitems.itemInvisible' => 'Inte tillgänglig för återförsäljare',
    'planitems.buttonMakeItemVisible' => 'Gör tillgänglig',
    'planitems.buttonMakeItemVisibleDescription' => 'Låt inte återförsäljare tillhandahålla valda tjänster med sina egna värdtjänstplaner. Tillvalen som motsvarar dessa tjänster visas i värdtjänstplanens egenskaper på fliken Extratjänster.',
    'planitems.buttonMakeItemInvisible' => 'Gör otillgängligt',
    'planitems.buttonMakeItemInvisibleDescription' => 'Låt inte återförsäljare tillhandahålla valda tjänster med sina värdtjänstplaner. Åtgärderna som motsvarar dessa tjänster kommer att tas bort från värdtjänstplanens egenskaper.',
    'planitems.buttonAddNewCustomItemButton' => 'Lägg till tjänst',
    'planitems.buttonAddNewCustomItemButtonDescription' => 'Lägg till en tjänst för planalternativen.',
    'planitems.buttonRemoveCustomItem' => 'Ta bort tjänst',
    'planitems.buttonRemoveCustomItemDescription' => 'Ta bort tillvalen som motsvarar valda tjänster från värdtjänstplanens egenskaper.',
    'planitems.confirmOnDeleteSupportButton' => 'Är du säker på att du vill ta bort valda tillval?',

    'pumpackages.buttonUpdate' => 'Uppdatera',
    'pumpackages.buttonUpdateDescription' => 'Uppdatera de valda paketen.',
    'pumpackages.buttonLock' => 'Lås',
    'pumpackages.buttonLockDescription' => 'Lås de valda paketen för att förhindra uppdateringar.',
    'pumpackages.buttonUnlock' => 'Lås upp',
    'pumpackages.buttonUnlockDescription' => 'Lås upp de valda paketen för att tillåta uppdateringar.',
    'pumpackages.buttonCheckUpdates' => 'Sök efter uppdateringar',
    'pumpackages.buttonCheckUpdatesDescription' => 'Sök efter paketuppdateringar.',
    'pumpackages.name' => 'Paket',
    'pumpackages.summary' => 'Beskrivning',
    'pumpackages.updates' => 'Uppdateringar',
    'pumpackages.lockedCut' => 'L',
    'pumpackages.lockedHint' => 'Paketet är låst.',
    'pumpackages.unlockedHint' => 'Paketet är upplåst.',
    'pumpackages.updated' => 'Uppdaterad',
    'pumpackages.update' => 'Uppdatera till %%version%%',
    'pumpackages.unknownRepo' => 'okänt',
    'pumpackages.allUpToDate' => 'Alla paket är uppdaterade',
    'pumpackages.allUpToDateLastChecked' => 'Kontrollerades den %%date%%',
    'pumpackages.recheckUpdates' => 'Kontrollera igen nu',
    'pumpackages.popupInfoTitle' => '%%package%% paketdetaljer',
    'pumpackages.loading' => 'Var god vänta...',
    'pumpackages.error' => 'Kan inte få paketlistan: %%message%%',
    'pumpackages.currentVersion' => 'aktuell version: %%version%%',
    'pumpackages.notInstalled' => 'inte installerat',
    'pumpackages.popupUpdateTitle' => 'Uppdatera paket',
    'pumpackages.popupUpdatePackagesListTitle' => 'Installera följande uppdateringar:',
    'pumpackages.popupUpdateLockedPackagesListTitle' => 'Följande begärda paket är låsta för uppdatering:',
    'pumpackages.popupUpdateDependencies' => '%%count%% beroende paket',
    'pumpackages.unlockPackagesForUpdateOnly' => 'Lås upp paketen för att möjliggöra endast denna uppdatering',
    'pumpackages.lockedError' => 'Systemets uppdateringsverktyg installerar redan uppdateringarna i automatiskt läge. Försök senare.',
    'pumpackages.duplicatesError' => 'Fel: Kunde inte ta emot uppdateringsinformation eftersom vissa paket har dubbletter. Ta bort dubbletter i följande paket: %%duplicates%%',
    'pumpackages.updateInfoError' => 'Fel: kan inte ta emot uppdateringsinformation för paket',
    'pumpackages.selectedPackagesUpToDate' => 'Alla valda paket är uppdaterade.',
    'pumpackages.taskUpdatingPackages' => 'Uppdaterar %%count%% paket...',
    'pumpackages.popupLockTitle' => 'Låsta paket',
    'pumpackages.popupLockDescription' => 'Om du låser ett paket, uppdateras den inte av System Updates Tool (om du inte uppdaterar Plesk själv). Om andra paket kräver en nyare version av detta paket för sina uppdateringar, kommer de inte att uppdateras. Observera att du fortfarande kan uppdatera ett låst paket via en nativ enhet i konsolen. För att uppdatera ett låst paket från Plesk-gränssnittet, lås upp det först.',
    'pumpackages.popupLockPackagesListTitle' => 'Lås följande paket:',
    'pumpackages.popupUnlockTitle' => 'Låsa upp paket',
    'pumpackages.popupUnlockDescription' => 'Dessa paket kan inte uppdateras eftersom de låstes för att förhindra uppdateringar. Observera att du fortfarande kan uppdatera ett låst paket via en nativ enhet i konsolen eller medan du uppdaterar Plesk. För att uppdatera ett låst paket från Plesk-gränssnittet, lås upp det först.',
    'pumpackages.popupUnlockPackagesListTitle' => 'Lås upp följande paket:',
    'pumpackages.updatesAvailable' => 'Uppdateringar för systempaketen %%count%% är tillgängliga',
    'pumpackages.lastedChecked' => '(kontrollerades den %%date%%)',
    'pumpackages.updateAll' => 'Uppdatera alla',
    'pumpackages.packageManagerDbInconsistent' => 'Information om vissa paket kanske inte är aktuell: inkongruenser har detekterats i systemet pakethanterares databas. Lös problemet manuellt.',

    'resellers.filterResellerName' => 'Återförsäljarens namn',
    'resellers.filterSubscription' => 'Abonnemang',
    'resellers.filterOptionSubscriptionAny' => 'Valfri',
    'resellers.filterOptionSubscriptionCustom' => 'Anpassad',
    'resellers.filterResourceUsage' => 'Resurs-användning',
    'resellers.filterOptionResourceUsageAny' => 'Valfri',
    'resellers.filterOptionResourceUsageOveruse' => 'Överanvända resurser',
    'resellers.filterOptionResourceUsageOk' => 'Inom gränserna',
    'resellers.filterStatus' => 'Status',
    'resellers.filterOptionStatusAny' => 'Valfri',
    'resellers.filterOptionStatusSuspended' => 'Avstängd',
    'resellers.filterOptionStatusActive' => 'Aktiva',
    'resellers.filterSubscriptionStatus' => 'Abonnemangets status',
    'resellers.filterOptionSubscriptionStatusAny' => 'Valfri',
    'resellers.filterOptionSubscriptionStatusLocked' => 'Låst',
    'resellers.filterOptionSubscriptionStatusUnsynchronized' => 'Osynkat',
    'resellers.filterDescription' => 'Beskrivning',
    'resellers.buttonAddNewReseller' => 'Lägg till återförsäljare',
    'resellers.hintAddNewReseller' => 'Skapa ett återförsäljarkonto.',
    'resellers.buttonRemove' => 'Ta bort',
    'resellers.hintRemove' => 'Ta bort de valda återförsäljarna och alla deras tjänsteplaner, kunder och abonnemang.',
    'resellers.confirmOnDelete' => 'Är du säker på att du vill ta bort {count, plural, =1 {återförsäljarkontot {name}} one {det # valda återförsäljarkontot} other {de # valda återförsäljarkontona}} och alla {count, plural, one {dess} other {deras}} tjänsteplaner, kunder och prenumerationer?',
    'resellers.buttonConvertToCustomer' => 'Omvandla till kunder',
    'resellers.hintConvertToCustomer' => 'Konvertera de markerade återförsäljarna till kunder.',
    'resellers.buttonChangeStatus' => 'Ändra status',
    'resellers.hintChangeStatus' => 'Byt återförsäljarens status till "Aktiv" eller "Avstängd"',
    'resellers.buttonActivateResellers' => 'Aktivera',
    'resellers.hintActivateResellers' => 'Aktivera valda återförsäljarkonton.',
    'resellers.buttonSuspendResellers' => 'Stäng',
    'resellers.hintSuspendResellers' => 'Upphäv valda återförsäljarkonton. Åtkomsten till Kundpanelen blockeras för återförsäljarna och alla deras användare: återförsäljarnas domäner och deras kunder upphävs och deras webb-, FTP- och e-posttjänster kommer inte längre att vara tillgängliga för Internet-användare.',
    'resellers.resellerName' => 'Återförsäljarens namn',
    'resellers.planName' => 'Tjänsteplan',
    'resellers.setupDate' => 'Konfigurationsdatum',
    'resellers.customers' => 'Kunder',
    'resellers.customPlanName' => 'Anpassad',
    'resellers.buttonLogin' => 'Logga in som återförsäljare',
    'resellers.hintLogin' => 'Hantera hostingtjänster associerade med återförsäljarens hostingkonto.',
    'resellers.statusOk' => 'Återförsäljarens status är OK: kontot är aktivt, abonnemanget är synkroniserat med planen.',
    'resellers.statusSuspended' => 'Återförsäljarens konto är upphävd: åtkomsten till Kundpanelen blockeras för återförsäljaren och alla dennes kunder: återförsäljarnas och dennes kunders domäner upphävs och deras webb-, FTP- och e-posttjänster kommer inte längre att vara tillgängliga för Internet-användare.',
    'resellers.statusLocked' => 'Abonnemanget är låst för synkroniserin: det är uteslutet från synkronisering med tjänsteplanen eftersom abonnemangsparametrarna har anpassats.',
    'resellers.statusUnsynchronized' => 'Abonnemanget är inte synkroniserat med återförsäljarplanen: det finns några tjänste reller resurser som återförsäljarplanen erbjuder men abonnemanget gör det inte.',

    'resellerserviceplans.planName' => 'Plan Namn',
    'resellerserviceplans.planTraffic' => 'Trafik',
    'resellerserviceplans.planDiskSpace' => 'Diskutrymme',
    'resellerserviceplans.planSubscriptions' => 'Återförsäljare',
    'resellerserviceplans.unlimited' => 'Obegränsat',
    'resellerserviceplans.buttonAddNewPlan' => 'Lägg till Plan',
    'resellerserviceplans.hintAddNewPlan' => 'Skapa en återförsäljarplan.',
    'resellerserviceplans.buttonDuplicatePlans' => 'Klona planer',
    'resellerserviceplans.hintDuplicatePlans' => 'Skapa kopior på valda återförsäljarplaner.',
    'resellerserviceplans.buttonRemove' => 'Ta bort',
    'resellerserviceplans.hintRemove' => 'Ta bort valda återförsäljarplaner.',
    'resellerserviceplans.confirmOnDelete' => 'Vill du verkligen ta bort markerade återförsäljarplaner?',
    'resellerserviceplans.disabledSelectHint' => 'Återförsäljarplaner med minst ett tillhörande abonnemang kan inte tas bort.',

    'restricteddomains.name' => 'Domännamn',
    'restricteddomains.buttonAddNewDomain' => 'Lägg till domännamn',
    'restricteddomains.buttonEnableList' => 'Aktivera',
    'restricteddomains.hintAddNewDomain' => 'Lägg till ett förbjudet domännamn.',
    'restricteddomains.hintEnableList' => 'Slå på kontrollen av domännamn medan domänen skapas.',
    'restricteddomains.buttonDisableList' => 'Inaktivera',
    'restricteddomains.hintDisableList' => 'Stäng av kontrollen av domännamn medan domänen skapas.',
    'restricteddomains.buttonRemoveDomain' => 'Ta bort',
    'restricteddomains.hintRemoveDomain' => 'Ta bort de valda domännamnen.',
    'restricteddomains.confirmOnRemove' => 'Ta bort de valda domännamnen?',
    'restricteddomains.buttonMoreActions' => 'Mer',

    'servermailblacklist.groupAdd' => 'Lägg till',
    'servermailblacklist.buttonAdd' => 'Lägg till domän',
    'servermailblacklist.buttonAddHint' => 'Lägg till domän i svartlistan',
    'servermailblacklist.groupActions' => 'Åtgärder',
    'servermailblacklist.buttonRemove' => 'Ta bort',
    'servermailblacklist.entries' => 'Poster',
    'servermailblacklist.action' => 'Action',
    'servermailblacklist.deleteAction' => 'Ta bort från servern',
    'servermailblacklist.spamAction' => 'Mark som skräppost',
    'servermailblacklist.spamAssassinDisabled' => 'Poster kommer inte att markeras som skräppost eftersom SpamAssassin inte är installerat eller avstängt',
    'servermailblacklist.removeEmptySelection' => 'Inga poster valda.',
    'servermailblacklist.removeConfirmation' => 'Ta bort {count, plural, =1 {posten {name}} one {den # valda posten} other {de # valda posterna}}?',
    'servermailblacklist.removeSuccess' => 'Valda poster togs bort.',

    'servermailwhitelist.groupAdd' => 'Lägg till',
    'servermailwhitelist.buttonAdd' => 'Lägg till nätverk',
    'servermailwhitelist.buttonAddHint' => 'Lägg till nätverk i vitlistan',
    'servermailwhitelist.groupActions' => 'Åtgärder',
    'servermailwhitelist.buttonRemove' => 'Ta bort',
    'servermailwhitelist.entries' => 'Poster',
    'servermailwhitelist.whiteListNotEmpty' => 'Gränserna för utgående post fungerar inte för e-postsändare vars IP-adresser fins på e-postserverns vita lista. Til exempel, om det finns en lokal värddator (127.0.0.0 / 8, ::1 / 128) i den vita listan, skickas alla e-postmeddelanden korrekt från den lokala servern oavsett begränsningarna. E-postsändare kan använda antingen lokala IP-adresser (webbplatser och anpassade script som finns i den lokala värddatorn) eller externa adresser (kunder som skickar e-post från e-postklienter som har installerats i deras datorer eller mobila enheter). För att gränserna ska fungera för alla e-postsändare (både lokala och externa), ta bort alla IP-adresser och nätverk från den vita listan. Observera att om du tar bort den lokala värddatorn (127.0.0.0 / 8, ::1 / 128) från den vita listan, kan åtgärden på webbplatser och script som skickar e-post från denna server avbrytas. För ytterligare detaljer om begränsningarna för utgående e-post, se Administratörsvägledningen, Skydd mot utgående spam.',
    'servermailwhitelist.removeEmptySelection' => 'Inga poster valda.',
    'servermailwhitelist.removeConfirmation' => 'Ta bort {count, plural, =1 {posten {name}} one {den # valda posten} other {de # valda posterna}}?',
    'servermailwhitelist.webmailAffected' => 'Att ta bort följande {count, plural, =1 {nätverk} one {nätverk} other {nätverk}} kan göra det omöjligt att skicka e-post från webbmail: %%list%%',
    'servermailwhitelist.webmailAffectedSingle' => 'Att ta bort detta nätverk kan göra det omöjligt att skicka e-post från webbmail.',
    'servermailwhitelist.removeSuccess' => 'Valda poster togs bort.',

    'serverprotection.bannedips.pageHint' => 'Här kan du se bannlyste IP-adresser, ta bort bannlysningen, eller överföra till listan över betrodda IP-adresser.',
    'serverprotection.bannedips.ip' => 'IP-adress',
    'serverprotection.bannedips.banDate' => 'Bannlyst på',
    'serverprotection.bannedips.jail' => 'Användt fängelse',
    'serverprotection.bannedips.buttonRemoveIp' => 'Ta bort bannlysning',
    'serverprotection.bannedips.hintRemoveIp' => 'Ta bort valda IP-adresser ur listan över bannlyste adresser.',
    'serverprotection.bannedips.hintRemoveIpFail2BanDisabled' => 'För att häva bannlysning av IP-adresser måste du aktivera Fail2Ban.',
    'serverprotection.bannedips.buttonMoveToTrustedIp' => 'Överföra till betrodda IP-adresser',
    'serverprotection.bannedips.hintMoveToTrustedIp' => 'Överföra valde IP-adresser till listan över betrodda IP-adresser.',
    'serverprotection.bannedips.hintMoveToTrustedIpFail2BanDisabled' => 'För att göra IP-adresser betrodda måste du aktivera Fail2Ban.',
    'serverprotection.bannedips.buttonEnable' => 'Slå på bannlysning av IP-adress',
    'serverprotection.bannedips.hintEnable' => 'Slå på automatisk bannlysning av IP-adresser och nätverk som genererar skadelig trafik för din server.',
    'serverprotection.bannedips.buttonDisable' => 'Stäng av bannlysning av IP-adress',
    'serverprotection.bannedips.hintDisable' => 'Stäng av automatisk bannlysning av IP-adresser och nätverk som genererar skadelig trafik för din server.',
    'serverprotection.bannedips.errorEnableFailed' => 'Kan inte sätta på bannlysning av IP-adress: %%error%%.',
    'serverprotection.bannedips.errorDisableFailed' => 'Kan inte stänga av bannlysning av IP-adress: %%error%%.',
    'serverprotection.bannedips.buttonBanIp' => 'Bannlys IP',
    'serverprotection.bannedips.hintBanIp' => 'Lägg till en IP-adress till listan över bannlysta adresser.',
    'serverprotection.bannedips.hintBanIpFail2BanDisabled' => 'För att bannlysa IP-adresser måste du aktivera Fail2Ban.',
    'serverprotection.bannedips.hintBanIpNoActiveManualJails' => 'För att bannlysa IP-adresser måste du aktivera minst ett av följande fängelser: %%manualJailList%%.',

    'serverprotection.filters.pageHint' => 'Här kan du hantera fängelse filter.',
    'serverprotection.filters.buttonAddFilter' => 'Lägg till filter',
    'serverprotection.filters.hintAddFilter' => 'Lägg till ett filter',
    'serverprotection.filters.buttonRemoveFilter' => 'Ta bort',
    'serverprotection.filters.hintRemoveFilter' => 'Ta bort valda filtre.',
    'serverprotection.filters.name' => 'Filternamn',

    'serverprotection.jails.pageHint' => 'Här kan du se listan over fängelser användt till detektering av stötande IP-adresser.',
    'serverprotection.jails.buttonAddJail' => 'Lägg till fängelse',
    'serverprotection.jails.hintAddJail' => 'Lägg till fängelse',
    'serverprotection.jails.buttonDisableJails' => 'Stänga av',
    'serverprotection.jails.hintDisableJails' => 'Stäng av valda fängelser.',
    'serverprotection.jails.buttonActivateJails' => 'Slå på',
    'serverprotection.jails.hintActivateJails' => 'Slå på valda fängelser.',
    'serverprotection.jails.buttonRemoveJail' => 'Ta bort',
    'serverprotection.jails.hintRemoveJail' => 'Ta bort valda fängelser.',
    'serverprotection.jails.buttonManageFilters' => 'Hantera filter',
    'serverprotection.jails.hintManageFilters' => 'Här kan du hantera fängelse filter.',
    'serverprotection.jails.name' => 'Fängelsenamn',
    'serverprotection.jails.disabled' => 'Inaktiva',
    'serverprotection.jails.active' => 'Aktiva',
    'serverprotection.jails.status' => 'Status',
    'serverprotection.jails.confirmOnDelete' => 'Vill du verkligen ta bort markerade fängelser?',

    'serverprotection.logs.pageHint' => 'Här kan du se Fail2ban loggar.',
    'serverprotection.logs.name' => 'Fil',
    'serverprotection.logs.viewHint' => 'Visa loggfilen.',
    'serverprotection.logs.buttonDownloadHint' => 'Ladda ner loggfilen.',

    'serverprotection.trustedips.pageHint' => 'Här kan du se betrodda IP-adresser, lägga till och ta bort IP-adresser från listan över betrodda adresser',
    'serverprotection.trustedips.ip' => 'IP-adress',
    'serverprotection.trustedips.ipDesc' => 'Beskrivning',
    'serverprotection.trustedips.addDate' => 'Lägg till betrodda vid',
    'serverprotection.trustedips.comment' => 'Kommentar',
    'serverprotection.trustedips.buttonRemoveIp' => 'Ta bort',
    'serverprotection.trustedips.hintRemoveIp' => 'Ta bort valda IP-adresser ur listan över betrodda adresser.',
    'serverprotection.trustedips.buttonAddTrustedIp' => 'Lägg till betrodd IP',
    'serverprotection.trustedips.hintAddTrustedIp' => 'Lägg till IP-adress till listan över betrodda IP-adresser',
    'serverprotection.trustedips.buttonEditTrustedIp' => 'Redigera beskrivning',
    'serverprotection.trustedips.buttonEditHint' => 'Redigera en IP-adress beskrivning.',

    'services.stateColumnHeader' => 'Stat',
    'services.nameColumnHeader' => 'Tjänst',
    'services.startupTypeColumnHeader' => 'Startmetod',
    'services.autoStartupType' => 'Automatisk',
    'services.manualStartupType' => 'Manuell',
    'services.disabledStartupType' => 'Inaktiverad',
    'services.changeStartupTypeTooltip' => 'Ändra uppstarttyp för tjänsten',
    'services.drwebName' => 'Plesk Premium Antivirus',
    'services.postgresqlName' => 'PostgreSQL',
    'services.tomcatName' => 'Tomcat Java',
    'services.imap-pop3Name' => 'Dovecot IMAP och POP3-server',
    'services.pop3Name' => 'Courier POP3-server',
    'services.pop3sName' => 'Courier POP3-server med SSL/TLS-stöd',
    'services.imapName' => 'Courier IMAP-server',
    'services.imapsName' => 'Courier IMAP3-server med SSL/TLS-stöd',
    'services.authdaemonName' => 'Courier IMAP-autentiseringsdaemon',
    'services.dnsName' => 'DNS-server (%%displayName%%)',
    'services.fail2banName' => 'Bannlysning av IP-adresser (Fail2ban)',
    'services.kavName' => 'Kaspersky Antivirus',
    'services.milterName' => "Plesk milter (%%displayName%%)",
    'services.nginxName' => 'Reverse-proxyserver (nginx)',
    'services.smtpName' => 'SMTP-server (%%displayName%%)',
    'services.spamassassinName' => "SpamAssassin",
    'services.webName' => "Webbserver (%%displayName%%)",
    'services.resctrlName' => "Resurskontrollenhet (Cgroups)",
    'services.activeState' => 'På',
    'services.inActiveState' => 'Av',
    'services.do-restart' => 'Startar om',
    'services.do-start' => 'Startar',
    'services.do-stop' => 'Stänger av',
    'services.do-changeStartup' => 'Bearbetar',
    'services.notConfiguredState' => 'Inte konfigurerad',
    'services.notInstalledState' => 'Inte installerat',
    'services.running-start' => 'Tjänsten har redan startats.',
    'services.notRunning-start' => 'Starta tjänsten.',
    'services.running-stop' => 'Stoppa tjänsten.',
    'services.notRunning-stop' => 'Tjänsten har redan stoppats.',
    'services.running-restart' => 'Starta om tjänsten.',
    'services.notRunning-restart' => 'Tjänsten är stoppad.',
    'services.startServiceDrWeb' => 'För att starta antivirustjänsten bör du ha minst en e-postlåda med antiviruskontrollen aktiverad.',
    'services.serviceDisabled' => 'Denna funktion är inte tillgänglig eftersom din licensnyckel inte stödjer den eller tjänsten har inte installerats eller konfigurerats korrekt.',
    'services.serviceDisabledStartupType' => 'Tjänsten är inaktiverad.',
    'services.phpHandlerSettingsByOsVendor' => '%%displayName%% av OS-säljare',
    'services.phpFpm' => 'PHP-FPM %%displayName%%',
    'services.urlrewriteComponentName' => "URL-omskrivning",
    'services.dbconnectorComponentName' => "Databasanslutare",
    'services.tomcatComponentName' => 'Apache Tomcat',
    'services.mysqlserverComponentName' => 'MariaDB/MySQL-server',
    'services.troubleshootingComponentName' => 'Felsökning',
    'services.wafComponentName' => 'Webbprogram brandvägg',
    'services.vcsComponentName' => 'Versionens kontrollsystem',
    'services.antivirusComponentName' => "Antivirus",
    'services.databaseComponentName' => "SQL Server",
    'services.sqladminComponentName' => "MySQL Webadmin",
    'services.sqladminmysqlComponentName' => "MySQL Webadmin",
    'services.dnsserverComponentName' => "DNS-server",
    'services.firewallComponentName' => "Brandvägg",
    'services.ftpserverComponentName' => "FTP server",
    'services.javaComponentName' => "Java",
    'services.mailserverComponentName' => "E-postserver",
    'services.pleskagentComponentName' => "Plesk Agent",
    'services.psaComponentName' => "Plesk",
    'services.scriptComponentName' => "Skript för webben",
    'services.spamfilterComponentName' => "Skräppostfilter",
    'services.statsComponentName' => "Webbstatistik",
    'services.stunnelComponentName' => "SSL/TLS Wrapper",
    'services.webmailComponentName' => "Webbpost",
    'services.webpublishComponentName' => "Webbpublicering",
    'services.webserverComponentName' => "Webbserver",
    'services.backupsystemComponentName' => 'Säkerhetskopiasystem',
    'services.networkComponentName' => 'Nätverk',
    'services.sitebuilderComponentName' => 'Presence Builder',
    'services.saviComponentName' => 'Sophos Anti-Virus gränssnitt',
    'services.waitMessage' => 'Var god vänta',
    'services.buttonRefreshComponents' => 'Uppdatera',
    'services.searchTitle' => 'Hitta tjänster ...',
    'services.hintRefreshComponents' => 'Uppdatera komponentlistan',

    'sessions.searchTitle' => 'Sök aktiva sessioner',
    'sessions.buttonRefresh' => 'Uppdatera',
    'sessions.buttonRefreshDescription' => 'Synkronisera listan med sessioner med de aktuellt öppna sessionerna.',
    'sessions.buttonRemove' => 'Stäng',
    'sessions.buttonRemoveDescription' => 'Stäng valda sessioner.',
    'sessions.removeConfirmMessage' => 'Vill du verkligen stänga valda sessioner?',
    'sessions.buttonSettings' => 'Sessionsinställningar',
    'sessions.buttonSettingsDescription' => 'Ändra sessionsparametrarna.',
    'sessions.headerType' => 'T',
    'sessions.headerLogin' => 'Inloggning',
    'sessions.headerIpAddress' => 'IP-adress',
    'sessions.headerLogonTime' => 'Inloggningstid',
    'sessions.headerIdleTime' => 'Inaktivitet',
    'sessions.typeAdmin' => 'Administratörssession.',
    'sessions.typeReseller' => 'Återförsäljarens session.',
    'sessions.typeClient' => 'Kundsession.',
    'sessions.altAdminIcon' => 'Admin',
    'sessions.altResellerIcon' => 'Återförsäljare',
    'sessions.altClientIcon' => 'Kund',

    'sslcertificates.name' => 'Namn',
    'sslcertificates.used' => 'Används',
    'sslcertificates.csrHint' => 'CSR komponenten har angetts.',
    'sslcertificates.noCsrHint' => 'CSR komponenten har inte angetts.',
    'sslcertificates.privateKeyHint' => 'Den privata nyckel komponenten har angetts.',
    'sslcertificates.noPrivateKeyHint' => 'Den privata nyckel komponenten har inte angetts.',
    'sslcertificates.certificateHint' => 'Certificate komponenten har angetts.',
    'sslcertificates.noCertificateHint' => 'Certificate komponenten har inte angetts.',
    'sslcertificates.caCertificateHint' => 'CA Certificate komponenten har angetts.',
    'sslcertificates.noCaCertificateHint' => 'CA Certificate komponenten har inte angetts.',
    'sslcertificates.buttonDownloadHint' => 'Hämta alla certifikatkomponenter.',
    'sslcertificates.remove' => 'Ta bort',
    'sslcertificates.hintRemove' => 'Ta bort det valda SSL/TLS-certifikat från domänkatalogen.',
    'sslcertificates.confirmOnDelete' => 'Ta bort de valda SSL/TLS-certifikat?',
    'sslcertificates.addCertificate' => 'Lägg till',
    'sslcertificates.hintAddCertificate' => 'Lägg till et SSL/TLS-certifikat',
    'sslcertificates.viewCertificates' => 'Visa',
    'sslcertificates.hintViewCertificates' => 'Visa listan över SSL/TLS-certifikat du har köpt från din leverantör.',
    'sslcertificates.unableSetupPanelCertificate' => 'Det gick inte att installera certifikatet %1 i Plesk: Den privata nyckeln och certifikatsinnehållet saknas.',
    'sslcertificates.makeDefault' => 'Ange som standard',
    'sslcertificates.hintMakeDefault' => 'Använd det valda SSL/TLS-certifikatet för säkra anslutningar till nyligen skapade webbplatser.',
    'sslcertificates.unableMakeDefault' => 'Kan inte installera standardcertifikatet: Inget certifikat med privat nyckel valt.',
    'sslcertificates.successMakeDefault' => 'Valt SSL/TLS-certifikat har konfigurerats som standard. Det kan användas för att säkra både befintliga och nyss skapade webbplatser. Webbplatser som använder föregående standardcertifikat fortsätter att använda det certifikatet.',
    'sslcertificates.selectOne' => 'Markera ett SSL/TLS-certifikat',

    'subscriptions.filterDomainName' => 'Namn',
    'subscriptions.filterSubscription' => 'Tjänsteplan',
    'subscriptions.filterOptionSubscriptionAny' => 'Valfri',
    'subscriptions.filterOptionSubscriptionMy' => 'Mina planer',
    'subscriptions.filterOptionSubscriptionReseller' => '%%planOwnerContactName%% planer',
    'subscriptions.filterOptionSubscriptionCustom' => 'Anpassad',
    'subscriptions.filterOptionSubscriptionAddonType' => '(tillägg)',
    'subscriptions.filterResourceUsage' => 'Resurs-användning',
    'subscriptions.filterOptionResourceUsageAny' => 'Valfri',
    'subscriptions.filterOptionResourceUsageOveruse' => 'Överanvända resurser',
    'subscriptions.filterOptionResourceUsageOk' => 'Inom gränserna',
    'subscriptions.filterPlanItem' => 'Anpassad planpost',
    'subscriptions.filterOptionPlanItemAny' => 'Valfri',
    'subscriptions.filterProvider' => 'Leverantör',
    'subscriptions.filterOptionProviderAny' => 'Alla abonnemang',
    'subscriptions.filterOptionProviderMy' => 'Mina abonnemanger',
    'subscriptions.filterProviderReseller' => '%%resellerContactName%%s abonnemang',
    'subscriptions.filterStatus' => 'Status',
    'subscriptions.filterOptionStatusAny' => 'Valfri',
    'subscriptions.filterOptionStatusSuspended' => 'Avstängd',
    'subscriptions.filterOptionStatusActive' => 'Aktiva',
    'subscriptions.filterSubscriptionStatus' => 'Abonnemangets status',
    'subscriptions.filterOptionSubscriptionStatusAny' => 'Valfri',
    'subscriptions.filterOptionSubscriptionStatusLocked' => 'Låst',
    'subscriptions.filterOptionSubscriptionStatusUnsynchronized' => 'Osynkat',
    'subscriptions.filterSubscriberName' => 'Abonnent',
    'subscriptions.filterDescription' => 'Beskrivning',
    'subscriptions.subscriptionName' => 'Abonnemang',
    'subscriptions.subscriberName' => 'Abonnent',
    'subscriptions.setupDate' => 'Konfigurationsdatum',
    'subscriptions.expirationDate' => 'Utgångsdatum',
    'subscriptions.description' => 'Beskrivning',
    'subscriptions.resellerDescription' => 'Återförsäljare',
    'subscriptions.ownerDescription' => 'Kund',
    'subscriptions.manageInResellerPanel' => 'Hantera i Återförsäljarpanelen',
    'subscriptions.manageInCustomerPanel' => 'Hantera i Kundpanelen',
    'subscriptions.buttonAddNewOwnSubscription' => 'Lägg till eget abonnemang',
    'subscriptions.hintAddNewOwnSubscription' => 'Skapa ett abonnemang för eget bruk.',
    'subscriptions.buttonAddNewSubscription' => 'Lägg till Abonnemang',
    'subscriptions.hintAddNewSubscription' => 'Skapa ett abonnemang.',
    'subscriptions.buttonChangeSubscription' => 'Ändra plan',
    'subscriptions.hintChangeSubscription' => 'Associera valda abonnemang med en annan tjänsteplan och lägg till eller ta bort planens tillägg om abonnemangens leverantör erbjuder dem.',
    'subscriptions.buttonRemove' => 'Ta bort',
    'subscriptions.hintRemove' => 'Ta bort markerade abonnemang.',
    'subscriptions.confirmOnRemove' => 'Vill du verkligen ta bort markerade abonnemang?',
    'subscriptions.buttonSetStatus' => 'Ställ in status',
    'subscriptions.hintSetStatus' => 'Byt abonnentens status till "Aktiv" eller "Avstängd"',
    'subscriptions.buttonActivateSubscriptions' => 'Aktiv',
    'subscriptions.hintActivateSubscriptions' => 'Gör valda abonnemang aktiva.',
    'subscriptions.buttonSuspendSubscriptions' => 'Avstängd',
    'subscriptions.hintSuspendSubscriptions' => 'Upphäv markerade abonnemang. Alla tjänster som tillhandahålls med abonnemangen kommer att frysas och inte vara tillgängliga för Internet-användare.',
    'subscriptions.buttonChangeOwner' => 'Ändra abonnent',
    'subscriptions.hintChangeOwner' => 'Tilldela om valda abonnemang till en annan abonnent. Detta ändrar också abonnemangsleverantör, löser abonnemang från tjänsteplanerna och gör dem \'Markerade\'.',
    'subscriptions.customPlanName' => 'Anpassad',
    'subscriptions.statusOk' => 'Abonnemangets status är OK: abonnemanget är aktivt och synkroniserat med planen.',
    'subscriptions.statusSuspended' => 'Abonnemanget är upphävt: alla tjänster som tillhandahålls med abonnemanget kommer att frysas och inte vara tillgängliga för Internet-användare.',
    'subscriptions.statusSuspendedReasonExpired' => 'Abonnemanget är upphävt eftersom det har gått ut: alla tjänster som tillhandahålls med abonnemanget kommer att frysas och inte vara tillgängliga för Internet-användare.',
    'subscriptions.statusLocked' => 'Abonnemanget är låst för synkroniserin: det är uteslutet från synkronisering med tjänsteplanen eftersom abonnemangsparametrarna har anpassats.',
    'subscriptions.statusUnsynchronized' => 'Abonnemanget är inte synkroniserat med tjänsteplanen: det finns några tjänster eller resurser som planen erbjuder men abonnemanget gör det inte.',
    'subscriptions.confirmOnDelete' => 'Är du säker på att du vill ta bort {count, plural, =1 {prenumerationen {name}} one {den # valda prenumerationen} other {de # valda prenumerationerna}}?',
    'subscriptions.hintInfo' => '(?)',
    'subscriptions.webserverConfigurationDomainHintAdmin' => "Webbserverns konfiguration för abonnemangets domäner kan vara inkonsekvent. Fixa fel i mallarna på Apache-konfigurationen och försök att regenerera konfigurationsfilen igen.",
    'subscriptions.webserverConfigurationDomainHintReseller' => "Webbserverns konfiguration för abonnemangets domäner kan vara inkonsekvent. Kontakta serveradministratören för att lösa detta problem.",
    'subscriptions.unlinkedDomainHint' => 'Vissa av domänens IP-adresser är inoperativa och uteslutna från serverkonfigurationen. Kontrollera domänens IP-bindningar och uppdatera vid behov.',
    'subscriptions.hintTitle' => 'Abonnemangssammanfattning',
    'subscriptions.hintWaitMessage' => 'Laddar…',
    'subscriptions.removeConfirmationSubscription' => "Följande domäner kommer också att tas bort:\n%%domains%%",

    'summaryreportlayouts.delivery' => 'Leverans',
    'summaryreportlayouts.name' => 'Namn',
    'summaryreportlayouts.general' => 'Allmänt',
    'summaryreportlayouts.clients' => 'Kunder',
    'summaryreportlayouts.resellers' => 'Återförsäljare',
    'summaryreportlayouts.personalClients' => 'Personliga klienter',
    'summaryreportlayouts.domains' => 'Domäner',
    'summaryreportlayouts.personalDomains' => 'Personliga domäner',
    'summaryreportlayouts.section.FULL' => 'Full',
    'summaryreportlayouts.section.NONE' => 'Ingen',
    'summaryreportlayouts.section.SUMMARY' => 'Sammanfattning',
    'summaryreportlayouts.groupRemove' => 'Ta bort',
    'summaryreportlayouts.buttonRemove' => 'Ta bort',
    'summaryreportlayouts.buttonRemoveHint' => 'Ta bort valda layouter.',
    'summaryreportlayouts.removeEmptySelection' => 'Välj en eller flera layouter att ta bort',
    'summaryreportlayouts.removeConfirmation' => 'Ta bort {count, plural, =1 {layouten {name}} one {den valda layouten} other {# layouter}}?',
    'summaryreportlayouts.groupAdd' => 'Lägg till',
    'summaryreportlayouts.buttonAdd' => 'Lägg till layout',
    'summaryreportlayouts.buttonAddHint' => 'Lägg till en rapportlayout',
    'summaryreportlayouts.autoDeliveryOn' => 'Denna rapport är schemalagd för leverans.',
    'summaryreportlayouts.autoDeliveryOff' => 'Denna rapport levereras inte automatiskt.',
    'summaryreportlayouts.removeSuccess' => 'Valda layouter togs bort.',

    'summaryreportschedules.status' => 'S',
    'summaryreportschedules.on' => 'Aktiverad',
    'summaryreportschedules.off' => 'Inaktiverat',
    'summaryreportschedules.period' => 'Frekvens',
    'summaryreportschedules.lastSentDate' => 'Senaste leveransdatum',
    'summaryreportschedules.email' => 'Skicka till',
    'summaryreportschedules.disabled' => 'Avstängd',
    'summaryreportschedules.day' => 'Dagens',
    'summaryreportschedules.week' => 'Veckovis',
    'summaryreportschedules.month' => 'Månadsvis',
    'summaryreportschedules.groupAdd' => 'Lägg till',
    'summaryreportschedules.buttonAdd' => 'Lägg till schema',
    'summaryreportschedules.buttonAddHint' => 'Lägg till ett leveransschema',
    'summaryreportschedules.groupRemove' => 'Ta bort',
    'summaryreportschedules.buttonRemove' => 'Ta bort',
    'summaryreportschedules.buttonRemoveHint' => 'Ta bort valda scheman.',
    'summaryreportschedules.removeEmptySelection' => 'Välj ett eller flera leveransscheman att ta bort.',
    'summaryreportschedules.removeConfirmation' => 'Ta bort {count, plural, =1 {det valda leveransschemat} other {de # valda leveransschemana}}?',
    'summaryreportschedules.removeSuccess' => 'Valda leveransscheman togs bort.',

    'traffichistory.year' => 'År',
    'traffichistory.month' => 'Månad',
    'traffichistory.trafficUsage' => 'Trafikanvändning',
    'traffichistory.noData' => 'Ingen historisk data tillgänglig.',

    'webappfirewalllogfiles.name' => 'Namn',
    'webappfirewalllogfiles.modificationDate' => 'Ändringsdatum',
    'webappfirewalllogfiles.fileSize' => 'Storlek',
    'webappfirewalllogfiles.remove' => 'Ta bort',
    'webappfirewalllogfiles.hintRemove' => 'Ta bort valda loggfiler. Bara behandlade loggfiler kan tas bort.',
    'webappfirewalllogfiles.confirmOnDelete' => 'Ta bort valda loggfiler?',
    'webappfirewalllogfiles.viewHint' => 'Klicka för att visa loggfilen.',
    'webappfirewalllogfiles.buttonDownloadHint' => 'Klicka för att hämta loggfilen.',

    'webmails.name' => 'Namn',
    'webmails.url' => 'URL',
    'webmails.buttonAddNewWebmail' => 'Registrera webbmail',
    'webmails.hintAddNewWebmail' => 'Regsistrera en extra webbbposttjänst i Plesk.',
    'webmails.buttonEnableWebmail' => 'Aktivera',
    'webmails.hintEnableWebmail' => 'Gör valda webbposttjänster tillgängliga för kunderna.',
    'webmails.buttonDisableWebmail' => 'Inaktivera',
    'webmails.hintDisableWebmail' => 'Gör valda webbposttjänster otillgängliga för kunderna.',
    'webmails.buttonRemoveWebmail' => 'Ta bort',
    'webmails.hintRemoveWebmail' => 'Ta bort registreringen av valda extra webbposttjänster. Notera att en webbmail installerad med Plesk installationsprogram inte kan tas bort här; använd Verktyg > Uppdateringar istället.',
    'webmails.confirmOnDelete' => 'Vill du verkligen ta bort markerade webbpostregistreringar från Plesk?',
    'webmails.statusSuspended' => 'Webbmail är inte tillgängligt.',
    'webmails.statusOk' => 'Webbmail är tillgängligt.',
];