<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Extra nyckelegenskaper',
    'additional-key-info.update' => 'Återhämta extranyckel',
    'additional-key-info.updateDescription' => 'Hämta den ytterligare nyckeln och installera den.',
    'additional-key-info.download' => 'Hämtningsnyckel',
    'additional-key-info.downloadDescription' => 'Ladda ner den aktuella licensnyckeln.',
    'additional-key-info.install' => 'Installera nyckel',
    'additional-key-info.installDescription' => 'Installera nuvarande licensnyckel.',
    'additional-key-info.revert' => 'Återskapa nyckel',
    'additional-key-info.revertDescription' => 'Återgå till tidigare installerad licensnyckel.',
    'additional-key-info.revertNotAvailableDescription' => 'Ingen nyckel installerad.',
    'additional-key-info.installSuccess' => 'Installation av licensnyckel har påbörjats.',

    'additional-key-revert.title' => 'Rollback av ytterligare nyckel',
    'additional-key-revert.success' => 'Rollback utförd för ytterligare nyckel.',

    'additional-key-upload.title' => 'Installera en licensnyckel',
    'additional-key-upload.success' => 'Den nya ytterligare nyckeln har laddats upp.',

    'additional-keys.title' => 'Ytterligare licensnycklar',

    'change-owner.title' => 'Tilldela om markerade abonnemang',

    'customers.hint' => 'Det är här du hanterar konton på dina värdtjänstkunder: skapa konton tillsammans med tjänsteabonnemangen, hantera befintliga kunder och ta bort konton. För att administrera webbplatser, e-post eller andra tjänster som tillhandahålls till en kund, gå till Kundpanelen genom att klicka på länken i den högra spalten i listan.',

    'customer-domains.hint' => 'Det är här du ställer in och hanterar webbplatserna.',

    'customer-subscriptions.hint' => 'Det är här du hanterar kundens abonnemang.',

    'domains.hint' => 'Här ser du information om alla domännamn som registrerats i systemet och kan hantera hosting-tjänsterna. För att lägga till en domän för dig själv eller för hosting-kunder, klicka bara på Lägg till domän. Du kommer att ombes skapa en ny kund och ett nytt abonnemang medan domänen skapas eller att välja ett bland de befintliga.',

    'database-servers.title' => 'Databasservrar',

    'database-server-create.title' => 'Nytt databasservernamn',

    'database-server-properties.title' => 'Databasserver',

    'database-server-upgrade.drawerTitle' => 'MariaDB-uppgradering',
    'database-server-upgrade.drawerTitle.completed' => 'Uppgradering slutförd',
    'database-server-upgrade.drawerSubTitle.line1' => 'Lådan kan inte stängas medan uppgraderingen körs.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Om problem uppstår under uppgraderingen, hänvisa till %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'MariaDB-databasserver har uppgraderats till version %%releaseVersion%%. Om du har några problem, följ instruktionerna i %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'LTS-versionen är redan installerad.',
    'database-server-upgrade.troubleshootingArticle' => 'denna KB-artikel',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Använd %%troubleshootingArticle%% för att felsöka uppgraderingsproblem med MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Uppgradera din lokala MariaDB-databasserver till den nuvarande versionen med långsiktigt stöd (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Vi rekommenderar starkt att du säkerhetskopierar din server innan uppgraderingen och påbörjar uppgraderingen när webbplatserna har få besökare.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Under MariaDB-uppgraderingen blir Plesk-servern och webbplatser den är värd för otillgängliga. MariaDB-uppgraderingen är vanligtvis felfri och tar runt tio minuter, men kan fortfarande påverka hela servern.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Obs: Om du kör MariaDB 5.5 så kommer Plesk att uppgradera den till MariaDB 10.5 först. När uppgraderingen är klar startar du denna guide igen för att uppgradera till nuvarande LTS-version av MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Nuvarande version',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Välj version att uppgradera till',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Det finns inga stora släpp',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Versionsinfo',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Släppdatum: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'End of Life-datum: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Endast MariaDB-grenar som skeppats av OS-leverantörer eller MariaDB-leverantören kan uppgraderas.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Kontroller inför uppgradering',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Parsar MariaDB-konfigurationsfiler',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analyserar databaser med mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analyserar konfiguration för pakethanterare',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Kontrollerar systemkompatibilitet',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Kontrollerar WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'För att gå vidare med uppgraderingen, bocka i alla rutor. Det är nödvändigt för att se till att du godkänner konfigurationsändringarna som uppgraderingen gör och att du har tillgång till återställningsalternativ.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Följande variabler kommer att tas bort, för kompatibilitet med den nya versionen:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} från {count, plural, one {filen {files}} other {de # filerna: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Alternativ för åtkomståterställning (serverns kommandokonsol och Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Jag bekräftar att jag har SSH-åtkomst till servern',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Använd en SSH-klient eller öppna %%sshTerminalExtension%% i en ny webbläsarflik (stäng inte SSH Terminal-tilläggsfönstret förrän uppgraderingen är klar). Om uppgraderingen misslyckas kommer SSH-åtkomst hjälpa till med återställning.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal-tillägg',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Jag bekräftar att jag har åtkomst till Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Öppna %%repairKit%% i en ny webbläsarflik och logga in med administratöruppgifterna. Stäng inte Repair Kit-tilläggsfönstret förrän uppgraderingen är klar.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Säkerhetskopiera databaser',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Säkerhetskopiera alla databaser som servern är värd för innan uppgraderingen',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk lagrar säkerhetskopian av databaser i katalogen %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket i Plesk är inte tillgänglig',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Du kommer inte att kunna se uppgraderingsprocessens utmatning i realtid utan WebSocket.',

    'database-server-upgrade.submitPopover.title' => 'För att förebygga potentiell dataförlust rekommenderar vi starkt att du skapar en dump av databaser servern är värd för innan du går vidare. Fortsätt utan att skapa en dump?',

    'database-server-databases.title' => 'Databaser',

    'database-server-change-password.title' => 'Administratörslösenord',

    'home.title' => 'Hem',

    'license.title' => 'Licensinformation',

    'primary-key-info.title' => 'Plesk-licensnyckel',
    'primary-key-info.update' => 'Hämta nycklar',
    'primary-key-info.updateDescription' => 'Hämta den beställda licensnyckeln och installera dem.',
    'primary-key-info.upload' => 'Installera nyckel',
    'primary-key-info.uploadDescription' => 'Ladda upp och installera en ny licensnyckel.',
    'primary-key-info.revert' => 'Återskapa nyckel',
    'primary-key-info.revertDescription' => 'Återgå till tidigare installerad licensnyckel.',

    'primary-key-revert.title' => 'Licensnyckel-rollback',
    'primary-key-revert.success' => 'Rollback utförd för Plesk-nyckel.',

    'primary-key-upload.title' => 'Installera en licensnyckel',
    'primary-key-upload.success' => 'Den nya Plesk-nyckeln har laddats upp.',

    'resellers.hint' => 'Det är här du hanterar återförsäljarkonton — dina kunder som är återförsäljare av hosting-tjänster och har egna webbplatser. Här skapar du konton tillsammans med tjänsteabonnemang, hanterar befintliga återförsäljare och tar bort konton.',

    'reseller-customers.hint' => 'Det är här du ställer in och hanterar kunderna.',

    'reseller-domains.hint' => 'Det är här du ställer in och hanterar webbplatserna.',

    'reseller-subscriptions.hint' => 'Det är här du hanterar återförsäljarens abonnemang.',

    'subscriptions.hint' => 'Kunderna får hosting-tjänster från dig genom att abonnera på en hosting-plan. Du kan hantera dessa abonnemang här, såväl som dina egna abonnemang som du skapar för att vara värd åt dina webbplatser. För att administrera webbplatser, e-post eller andra tjänster som tillhandahålls med ett abonnemang, gå till Kundpanelen genom att klicka på länken i den högra spalten i listan.',

    'server-mail-settings.title' => 'Inställningar',
    'server-mail-spam-filter.title' => 'Skräppostfiltrering',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Svarta listan',
    'server-mail-white-list.title' => 'White List',
    'server-mail-queue.title' => 'E-postko',
    'server-mail-statistics.title' => 'Statistik',

    'server-spam-filter.settings' => 'Inställningar',
    'server-spam-filter.black-list' => 'Svarta listan',
    'server-spam-filter.white-list' => 'Vita listan',

    'firewall.title' => 'Brandväggshantering',
    'firewall-general.title' => 'Allmänt',
    'firewall-general.toggleStatus' => 'Brandväggsskydd',
    'firewall-general.buttonDefault' => 'Återställ till standard',
    'firewall-general.buttonPanic' => 'Panikläge',
    'firewall-general.confirmationDefault' => 'Återställ brandväggsinställningar till standard?',
    'firewall-general.confirmationPanic' => 'Aktivera Panikläge? Användare kommer inte kunna komma åt sina domäner och vissa nätverkstjänster kan sluta fungera.',
    'firewall-general.successDefault' => 'Brandväggsinställningarna återställdes till standard.',
    'firewall-general.successPanic' => 'Panikläge aktiverades.',
    'firewall-general.info' => 'Av säkerhetsskäl blockerar brandväggen alla anslutningar förutom de som uttryckligen tillåts. Du kan tillåta en anslutning genom att skapa en regel. Se dokumentationen för ytterligare information',
    'firewall-general.interfaces' => 'Nätverksgränssnitt',
    'firewall-icmp.title' => 'ICMP-protokoll',
    'firewall-rules.title' => 'Brandväggsregler',

    'dns.title' => 'DNS-inställningar',
    'dns-records.title' => 'Zondatamall',
    'dns-soa-record.title' => 'Zoninställningsmall',

    'php-handler.title' => 'Inställningar för %%name%%',
    'php-handler.extensions.title' => 'Anknytningar',
    'php-handler.extensions.description' => 'Inställningarna för dessa PHP-extensioner gäller endast för denna hanterare.',
    'php-handler.extensions.descriptionShared' => 'Dessa inställningar är gemensamma för följande PHP-hanterare: %%handlers%%. Inställningarna gäller alla webbplatser som använder dessa hanterare.',
    'php-handler.extensions.buttonManage' => 'Hantera PECL--paket',
    'php-handler.extensions.manage.title' => 'Hantera PECL--paket',
    'php-handler.extensions.manage.risks' => 'PHP-tillägg tillhandahålls av PECL-paket från tredje part. Du installerar dem på egen risk.',
    'php-handler.extensions.manage.description' => 'Installera, uppgradera och avinstallera PECL-paket. Ändringarna tillämpas på alla webbplatser som körs på %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Varför är det önskade paketet inte på listan?',
    'php-handler.extensions.manage.limitations' => 'PHP-tillägg som tillhandahålls av kontrollpaneleverantörer och OS-leverantörer visas inte på listan.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Uppdatera",
    'ServerInformation.sectionGeneral' => "Allmänt",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Version",
    'ServerInformation.os' => "Operativsystem",
    'ServerInformation.key' => "Plesk-licensnyckel",
    'ServerInformation.uptime' => "Upptid",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dag} other {# dagar}} {hours, plural, one {# timme} other {# timmar}} {minutes, plural, one {# minut} other {# minuter}}",
    'ServerInformation.sectionCpu' => "CPU-användning",
    'ServerInformation.la1min' => "Den senaste minuten",
    'ServerInformation.la5min' => "De senaste 5 minuterna",
    'ServerInformation.la15min' => "De senaste 15 minuterna",
    'ServerInformation.sectionMemory' => "Minnesanvändning",
    'ServerInformation.memoryHardware' => "Hårdvara",
    'ServerInformation.memoryTotalNoKernel' => "Totalt (exklusive kärna)",
    'ServerInformation.memoryTotal' => "Totalt",
    'ServerInformation.memoryUsed' => "Används",
    'ServerInformation.memoryFree' => "Ledigt",
    'ServerInformation.memoryShared' => "Delad",
    'ServerInformation.memoryBuffer' => "Buffert",
    'ServerInformation.memoryCached' => "Cachelagrad",
    'ServerInformation.memoryAvailable' => "Tillgänglig",
    'ServerInformation.memoryUsage' => "Användning",
    'ServerInformation.sectionSwap' => "Växlingsanvändning",
    'ServerInformation.sectionVirtualMemory' => "Användning av virtuellt minne",
    'ServerInformation.swapTotal' => "Totalt",
    'ServerInformation.swapUsed' => "Används",
    'ServerInformation.swapFree' => "Ledigt",
    'ServerInformation.swapUsage' => "Användning",
    'ServerInformation.sectionHarddisk' => "Hårddiskanvändning",
    'ServerInformation.harddiskDirectory' => "Filsystem",
    'ServerInformation.harddiskProtectedDir' => "Skyddade kataloger",
    'ServerInformation.harddiskTotal' => "Totalt",
    'ServerInformation.harddiskUsed' => "Används",
    'ServerInformation.harddiskAvailable' => "Tillgänglig",
    'ServerInformation.harddiskCapacity' => "Kapacitet",
    'ServerInformation.sectionDomains' => "Domäner",
    'ServerInformation.activeDomains' => "Aktiv",
    'ServerInformation.inactiveDomains' => "Inaktiv",
    'ServerInformation.problemDomains' => "Problem",
    'ServerInformation.refreshed' => "Information uppdaterad.",

    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Med ensamrätt.',
    'ServerAbout.linkLicenseManagement' => 'Gå till Licensinformation',
    'ServerAbout.panelVersion' => 'Version',
    'ServerAbout.installedPatchVersion' => 'Uppdatera #%%patch%%',
    'ServerAbout.licenseKey' => 'Licensnyckel',
    'ServerAbout.productDescription' => 'Plesk är den ledande WebOps-plattformen som kör, automatiserar och utvecklar applikationer, webbplatser och värdserververksamheter.',
    'ServerAbout.readEula' => 'Läs %%link%%.',
    'ServerAbout.linkEula' => 'Licensavtal (EULA)',
    'ServerAbout.visitForum' => 'Besök %%link%%',
    'ServerAbout.linkForum' => 'Plesk forum',
    'ServerAbout.followUs' => 'Följ oss',
    'ServerAbout.visitSite' => 'Läs mer på %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Hitta inspiration på %%link%%',
    'ServerAbout.linkBlog' => 'Plesk Blogg',

    'ServerAbout.darkThemePromoTitle' => 'Grattis!',
    'ServerAbout.darkThemePromoDescription' => 'Du har hittat en magisk kisse.',
    'ServerAbout.darkThemePromoButton' => 'Svisch! Kom till den mörka sidan',
    'ServerAbout.darkThemeTourDescription' => 'Ändra detta reglage för att aktivera eller inaktivera det mörka temat för ditt gränssnitt.',
    'ServerAbout.darkThemeTourButton' => 'Jag fattar',

    'ts-sessions.title' => 'Sessioner för terminalserver',
    'ts-sessions-properties.title' => 'Sessionsegenskaper',

    'BandwidthLimiting.bandwidthThrottling' => 'Du kan inte kontrollera bandbreddsbegränsningen eftersom QoS (tjänstkvalitet) inte är installerat.',
    'BandwidthLimiting.virtualHostingRequired' => 'Bandbreddsbegränsning är endast tillgänglig för domäner med webbvärdbasering.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximal bandbreddsanvändning',
    'BandwidthLimiting.bandwidthHint' => 'Gränsen för bandbreddsanvändning gäller bara data som överförs med HTTP-protokollet.',
    'BandwidthLimiting.maxConnectionLabel' => 'Begränsa anslutningar till',
    'BandwidthLimiting.maxConnectionHint' => 'Om du begränsar bandbredden så rekommenderar vi att du även begränsar antalet samtidiga anslutningar till webbplatsen. Vid frekventa anrop till webbplatsen kan webbserverprocesserna annars öka serverbelastningen.',
    'BandwidthLimiting.kbps' => 'kB/s',
    'BandwidthLimiting.success' => 'Inställningar för bandbreddsbegränsning ändrade.',
    'BandwidthLimiting.unlimited' => 'Obegränsat',

    'ip-address-domains.title' => 'Webbplatser som använder %%type%% IP-adress %%ipAddress%%',
    'ip-address-domains.site' => 'Plats',
    'ip-address-domains.setAsDefault' => 'Ange som standard',
    'ip-address-domains.type-SHARED' => 'delad',
    'ip-address-domains.type-EXCLUSIVE' => 'dedikerad',

    'HotlinkProtection.virtualHostingRequired' => 'Hotlink-skydd är endast tillgängligt för domäner med webbvärdbasering.',
    'HotlinkProtection.enabledLabel' => 'Aktivera hotlink-skydd',
    'HotlinkProtection.extensionsLabel' => 'Skyddade filtillägg',
    'HotlinkProtection.friendsLabel' => 'Adresser till vänliga webbplatser',
    'HotlinkProtection.success' => 'Inställningar för Hotlink-skydd ändrades.',

    'Odbc.add' => 'Lägg till OBDC DSN',
    'Odbc.resourceUsage' => '%%used%% skapat / %%allowed%% tillåtet.',
    'Odbc.limitExceeded' => 'Gränsen för ODBC DSN-anslutningar överskrids.',
    'Odbc.unlimited' => 'Obegränsat',
    'Odbc.addTooltip' => 'Lägg till ODBC-datakälla.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Anslutningsnamn',
    'Odbc.driver' => 'Drivrutin',
    'Odbc.description' => 'Anslutningsbeskrivning',
    'Odbc.hostname' => 'Värdnamn',
    'Odbc.statusSystem' => 'Det är ett system-DSN.',
    'Odbc.statusConfigured' => 'DSN är konfigurerat.',
    'Odbc.statusNotConfigured' => 'DSN är inte konfigurerat.',
    'Odbc.noSelectionText' => 'Välj ett eller flera objekt att ta bort.',
    'Odbc.removeConfirmation' => 'Ta bort {count, plural, =1 {anslutningen {name}} other {de # valda anslutningarna}}?',
    'Odbc.removeSuccess' => 'De valda anslutningarna togs bort.',

    'DomainAliasSettings.title' => 'Inställningar för domänalias',
    'DomainAliasSettings.updateSuccess' => 'Egenskaperna hos domänaliaset %%name%% ändrades. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Webbplatsinställningarna kommer att tillämpas om %%restartInterval%% minuter.',

    'Home.Backup.offStatus' => 'Detta är inte en giltig säkerhetskopia. Data kan inte återställas från denna fil.',
    'Home.Backup.task-failedStatus' => 'Säkerhetskopieringsuppgiften misslyckades.',
    'Home.Backup.activeSchedule' => 'Schema: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Scheman: %%schedules%%',
    'Home.Backup.noSchedule' => "Schema för säkerhetskopiering ej inställt",
    'Home.Backup.period_hourly' => 'Timvis %%schedule%%',
    'Home.Backup.period_daily' => 'Dagsvis %%schedule%%',
    'Home.Backup.period_weekly' => 'Veckovis %%schedule%%',
    'Home.Backup.period_monthly' => 'Månadsvis %%schedule%%',
    'Home.Backup.create' => 'Skapa säkerhetskopia',
    'Home.Backup.schedule' => 'Schema',
    'Home.ChangeLog.seeHistory' => 'Se ändringshistoriken',
    'Home.CustomButtons.add' => 'Lägg till anpassad knapp',
    'Home.CustomButtons.noButtons' => 'Det finns inga anpassade knappar',
    'Home.Customization.title' => 'Instrumentpanel',
    'Home.Customization.description' => 'Välja vilka alternativ du vill se',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Server',
    'Home.Customization.securitySection' => 'Säkerhet',
    'Home.Customization.backup' => 'Senaste säkerhetskopiering av server',
    'Home.Customization.ipBan' => 'Bannlysning av IP-adresser',
    'Home.Customization.mailQueue' => 'E-postko',
    'Home.Customization.mySubscriptions' => 'Mina abonnemanger',
    'Home.Customization.overusedSubscriptions' => 'Abonnemang med överanvändning',
    'Home.Customization.serverInfo' => 'Serverinformation',
    'Home.Customization.updates' => 'Plesk-uppdateringar',
    'Home.Customization.promo' => 'Erbjudande',
    'Home.Customization.changeLog' => 'Vad som är nytt',
    'Home.Customization.customButtons' => 'Anpassade knappar',
    'Home.EmptyView.title' => 'Få ut det mesta av din instrumentpanel genom att välja vilka alternativ som visas.',
    'Home.EmptyView.titleLocked' => 'Instrumentpanelen har låsts av din tjänsteleverantör.',
    'Home.EmptyView.customize' => 'Anpassa',
    'Home.Extension.title' => 'Anknytning',
    'Home.IpBan.banned' => 'Förbjudna',
    'Home.IpBan.trusted' => 'Betrodda',
    'Home.IpBan.more' => 'Se mer',
    'Home.MailQueue.total' => 'Totalt',
    'Home.MailQueue.deferred' => 'Uppskjutna',
    'Home.MailQueue.held' => 'Hålls',
    'Home.MailQueue.more' => 'Se mer',
    'Home.MailQueue.clean' => 'Rensa e-postkö',
    'Home.MailQueue.checkLogs' => 'Kolla loggar',
    'Home.MailQueue.repair' => 'Reparera',
    'Home.MailQueue.cleanConfirmQuestion' => 'Rensa e-postkö?',
    'Home.MailQueue.cleanConfirmYes' => 'Ja',
    'Home.MailQueue.cleanConfirmNo' => 'Nej',
    'Home.MailQueue.queueCleaned' => 'E-postkön raderades korrekt.',
    'Home.MailQueue.Promo.title' => 'Kom enkelt åt leveransstatus och loggar',
    'Home.MailQueue.Promo.link' => 'Testa den nya e-postkön nu',
    'Home.OverusedSubscriptions.empty' => 'Inga abonnemang med överanvändning funna',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% av %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Se alla med överanvändning: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Öppna i listan',
    'Home.PromoNewHomeView.title' => 'Välkommen till den nya startsidan!',
    'Home.PromoNewHomeView.description' => 'Om du stöter på något problem med den får du gärna dela din feedback. Den är till stor hjälp när vi gör ytterligare förbättringar.',
    'Home.PromoNewHomeView.feedback' => 'Dela feedback',
    'Home.PromoNewHomeView.switch' => 'Byt tillbaka till "Hem"',
    'Home.ServerInfo.hostname' => 'Värdnamn',
    'Home.ServerInfo.ipAddress' => 'IP-adress',
    'Home.ServerInfo.publicIpAddress' => 'Offentlig IP-adress',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.uptime' => 'Upptid',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dag} other {# dagar}} {hours, plural, one {# timme} other {# timmar}} {minutes, plural, one {# minut} other {# minuter}}",
    'Home.ServerInfo.more' => 'Se mer',
    'Home.Subscriptions.add' => 'Lägg till nytt',
    'Home.Subscriptions.empty' => 'Skapa abonnemang för att kunna vara värd åt flera webbplatser i ett isolerat utrymme på servern. %%link%%',
    'Home.Subscriptions.help' => 'Läs mer',
    'Home.Updates.title' => 'Produktuppdateringar',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%%-uppdatering #%%patch%%',
    'Home.Updates.manageComponents' => 'Lägg till eller ta bort komponenter',
    'Home.Updates.lastUpdated' => 'Senast uppdaterad %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Sök efter uppdateringar',
    'Home.Updates.enableAutoupdate' => 'Tillåt automatiska uppdateringar',
    'Home.Updates.lastChecked' => 'Senast kontrollerad %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% är tillgänglig',
    'Home.Updates.installNewVersion' => 'Installera nu',
    'Home.Updates.patchAvailable' => 'Mindre uppdateringar tillgängliga',
    'Home.Updates.patchAvailableVersion' => 'Mindre uppdateringar %%currentVersion%% tillgängliga',
    'Home.Updates.installPatch' => 'Uppdatera nu',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Uppdatering för {package} är tillgänglig} other {Uppdateringar för {package} är tillgängliga}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# paket} other {# paket}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Uppdatera nu} other {Uppdatera alla}}',
    'Home.Promo.Customize.title' => 'Gör instrumentpanelen till din egen!',
    'Home.Promo.Customize.content' => 'Dina favoritfunktioner precis där du vill ha dem med den nya, anpassningsbara instrumentpanelen',
    'Home.Promo.Customize.action' => 'Anpassa',
    'Home.Promo.SwitchToPuv.title' => 'Känner du till gränssnittsvyer i Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Om du inte tillhandahåller webbhotelltjänster till dina kunder med tjänsteplaner, kanske du vill prova ett gränssnitt som är behändigare för hantering av webbplatser, deras filer, databaser, e-postkonton och webbapplikationer.',
    'Home.Promo.SwitchToPuv.action' => 'Prova nu',
    'Home.Status.error' => 'Fel',
    'Home.Status.warning' => 'Varning',
    'Home.Status.info' => 'Info',

    'HostingSettings.title' => 'Värdtjänst-inställningar',
    'HostingSettings.updateSuccess' => 'Inställningarna har uppdaterats.',
    'HostingSettings.emptyLogin' => 'Du måste ange ett användarnamn.',
    'HostingSettings.emptyPassword' => 'Du måste ange ett lösenord.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP-servern stödjer inte IPv6. Tilldela åtminstone en IPv4-adress, annars kommer användaren inte kunna ladda upp filer till servern över FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domäninställningar',
    'HostingSettings.domainSettingsSection.domainName' => 'Domännamn',
    'HostingSettings.domainSettingsSection.description' => 'Exempelvis, example.com ',

    'HostingSettings.submitPopover.title' => 'Ta bort innehållet på %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Att byta "Webbplats" värdtjänsttyp till "%%type%%" tar permanent bort hela webbplatsens innehåll, inklusive följande kataloger:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Vill du ändra värdbaseringstyp för din webbplat?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'För att komma åt fler inställningar, ange systemets användaruppgifter och klicka på "Skapa webbutrymme".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'För att komma åt fler inställningar, klicka "Nästa" för att skapa värdtjänst.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Hosting typ',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Typ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Webbplats',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Vidarebefordran',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Ingen webbasering',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Använd domänens DNS-zon för att ha inkorgar under detta domännamn',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Sökvägen till webbplatsens hemkatalog',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Prioriterad domän',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Besökare kommer att omdirigeras hit via SEO-vänlig HTTP 301-omdirigering.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Vidarebefordra besökare till',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Vidarebefordringstyp',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Flyttade permanent (kod 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Omdirigera webbplatsbesökare till en annan webbplats och visa dem destinationsadressen. En sådan omdirigering bibehåller sidans sökrankning',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Flyttade temporärt (kod 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Omdirigera besökare till en tillfällig webbplatskopia, när du inte vill att sökmotorer indexerar denna tillfälliga webbplats.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Frame vidarebefordran',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Omdirigera webbplatsbesökare till en annan webbplats, men visa dem inte destinationsadressen så att de inte får reda på omdirigeringen.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Prioriterad domän',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Ingen',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Dokumentrot',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Det går inte att ändra dokumentroten eftersom det finns webbprogram installerade på denna webbplats.',
    'HostingSettings.domainSettingsSection.save' => 'Spara',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Kompatiblitetsläge',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Kör webbplatsen i kompatibilitetsläge för det nedärvda tillvalet "Separat SSL/TLS och icke-SSL/TLS innehåll"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Den här webbplatsen verkar i kompatibilitetsläge och du kan inte hantera den med Plesk-gränssnittet. Detta eftersom du använde det utfasade alternativet "Separat SSL/TLS- och icke SSL/TLS-iunnehåll" innan uppgraderingen. Med start från Plesk 11 lagrar en webbplats sitt innehåll som är tillgängligt över HTTP- och HTTPS -anslutningar i samma katalog. Vi rekommenderar att du flyttar alla data från katalogen "httpsdocs/" till "httpdocs/" och sedan stänger av kompatibilitetsläget. Det gör även appar som installerats i katalogen "httpsdocs/" tillgängliga över internet. Tänk på att du inte kommer att kunna aktivera kompatibilitetsläget igen.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Ändra denna inställning?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Att ändra denna inställning strider mot serverns säkerhetspolicy och kan försämra prestandan eller göra servern sårbar för attacker.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Ändra',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Återställ',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Säkra förinställningar har tillämpats',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'För bättre säkerhet, tillämpa de säkra förinställningarna. Tänk på att vissa behörigheter tillåter prenumeranter att modifiera dessa inställningar.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Tillämpa säkra förinställningar',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Lär dig om säkra värdtjänstinställningar',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS-stöd',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Aktiverad',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Kryptera anslutningar mellan webbplatsen och besökarens webbläsare.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certifikat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'För att aktivera HTTPS, ladda upp ett SSL/TLS-certifikat till domänens katalog och välj det sedan här.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Omdirigera besökare från HTTP till HTTPS via en SEO-vänlig 301-omdirigering',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Det finns inga SSL/TLS-certifikat i din katalog. För att lägga till ett certifikat, gå till %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'Den här sidan',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (annan katalog)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Inte valt',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Skript för webben',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Välj vilken programmering och vilket skriptspråk som måste tolkas av webbservern.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin-katalogen finns i %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Använd SSI för *.htm- och *.html-filer',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP-NET-version',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Anpassade feldokument',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin-katalogen finns i',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'dokumentroten för denna domän',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'rotkatalogen för webbutrymmet',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'den gamla rottypen för denna domän',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Anpassade feldokument',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Ytterligare behörigheter för att skriva/ändra',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy-publicering',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Webbstatistik',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Verktyg',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Skydda åtkomsten till din webbstatistik med ditt FTP användarnamn och lösenord',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Inaktiverad',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Webbutrymme inställningar',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-adresser',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Kvot för diskutrymme',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Aktiverad',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Förbjud operationer på webbplatsens filer om kvoten för diskutrymme som ställts in i prenumerationsinställningarna (om någon) överskrids.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Hårddiskkvoten stöds inte på grund av konfigurationen hos serverns filsystem.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Uppgifter för systemanvändare',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Hantera webbplatsens filer och mappar via FTP eller Filhanteraren. Kom åt servern via SSH om det tillåts.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Hantera webbplatsens filer och mappar via FTP eller Filhanteraren. Kom åt servern via Remote Desktop om det tillåts.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Användarnamn',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Lösenord',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Ange ett nytt lösenord här för att ändra systemanvändarens lösenord.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH-åtkomst',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Remote Desktop-åtkomst',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Aktiverad',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Kom åt servern med systemanvändarens uppgifter.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Typ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Inaktiverad',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'För {count, plural, other {# domäner}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Följande inställningar är gemensamma för samtliga {count, plural, other {# domäner i webbutrymmet {name}}}:',

    'OdbcAdd.title' => 'Lägg till en OBDC DSN',
    'OdbcAdd.nameLabel' => 'Anslutningsnamn',
    'OdbcAdd.descriptionLabel' => 'Anslutningsbeskrivning',
    'OdbcAdd.driver' => 'Drivrutin',
    'OdbcAdd.submit' => 'Skapa ODBC DSN',

    'OdbcEdit.title' => 'Ställ in en ODBC-anslutning',
    'OdbcEdit.saveSuccess' => 'Anslutningsinställningar sparades.',
    'OdbcEdit.test' => 'Testa anslutning',
    'OdbcEdit.connectSuccess' => 'Anslutningen lyckades.',

    'OdbcEdit.excel.driver.label' => 'Drivrutin',
    'OdbcEdit.excel.dbq.label' => 'Databasfilens sökväg',
    'OdbcEdit.excel.defaultdir.label' => 'Standard datumkatalog',
    'OdbcEdit.excel.fil.label' => 'Databasversion',
    'OdbcEdit.excel.maxbuffersize.label' => 'Max bufferstorlek',
    'OdbcEdit.excel.pagetimeout.label' => 'Timeout för sida',

    'OdbcEdit.access.driver.label' => 'Drivrutin',
    'OdbcEdit.access.dbq.label' => 'Databasfilens sökväg',
    'OdbcEdit.access.uid.label' => 'Inloggnings-ID',
    'OdbcEdit.access.pwd.label' => 'Lösenord',
    'OdbcEdit.access.pagetimeout.label' => 'Timeout för sida',
    'OdbcEdit.access.pagetimeout.description' => 'Tidsperioden, i tiondelar av en sekund, som en oanvänd sida förblir i bufferten. Detta alternativ gäller alla datakällor som använder Microsoft Access driver.',
    'OdbcEdit.access.maxbuffersize.label' => 'Max bufferstorlek',
    'OdbcEdit.access.maxbuffersize.description' => 'Storlek av intern buffert, i KB, inrymd inom gränsen 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Skrivskyddad',
    'OdbcEdit.access.readonly.description' => 'Klassar databasen som enbart läsbar, för att förhindra eventuella uppdateringar.',
    'OdbcEdit.access.exclusive.label' => 'Exklusivt',
    'OdbcEdit.access.exclusive.description' => 'Betecknar databasen som exklusiv för att förbjuda delade uppdateringar.',
    'OdbcEdit.access.safetransactions.label' => 'Säkra transaktioner',
    'OdbcEdit.access.safetransactions.description' => 'Om satt till 0 (standardinställningen), verkställs alla transaktioner omedelbart. Om satt till 1, sparas alla transaktioner till hårddisken endast vid en verkställande operation, men prestandan blir något försämrad.',
    'OdbcEdit.access.threads.label' => 'Trådar',
    'OdbcEdit.access.threads.description' => 'Antalet bakgrundstrådar som motorn ska använda.',
    'OdbcEdit.access.maxscanrows.label' => 'Max rader att skanna',
    'OdbcEdit.access.maxscanrows.description' => 'Antalet rader att scanna när man ställer in en kolumns datatyp, baserat på befintliga data.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Anger hur ändringar gjorda utanför en transaktion skrivs till databasen.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Specificerar om MS Access-driver ska utföra uttalade användardefinierade transaktioner asynkront.',

    'OdbcEdit.mssql.driver.label' => 'Drivrutin',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'Inloggnings-ID',
    'OdbcEdit.mssql.pwd.label' => 'Lösenord',
    'OdbcEdit.mssql.database.label' => 'Standarddatabas',
    'OdbcEdit.mssql.app.label' => 'Programnamn',
    'OdbcEdit.mssql.wsid.label' => 'Arbetsstations-ID',
    'OdbcEdit.mssql.language.label' => 'Grundspråk',
    'OdbcEdit.mssql.oemtoansi.label' => 'Omvandling av utökade tecken till OEM-värden',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC-drivrutin',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Värddatornamnet för MariaDB/MySQL-server',
    'OdbcEdit.mysql.database.label' => 'Standarddatabas',
    'OdbcEdit.mysql.user.label' => 'Användarnamn',
    'OdbcEdit.mysql.user.description' => 'Användarnamnet som används för att ansluta till MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Lösenord',
    'OdbcEdit.mysql.password.description' => 'Lösenordet för användarkontot i servern',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'TCP/IP-porten som används om servern inte är den lokala värddatorn',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Windows namngivna rör för anslutning om servern är den lokala värddatorn',
    'OdbcEdit.mysql.option.label' => 'Alternativ',
    'OdbcEdit.mysql.option.description' => 'Alternativ som anger hur MyODBC bör fungera. Se <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">dokumentation</a>',

    'ProtectedDirectoryList.add' => 'Lägg till Skyddad katalog',
    'ProtectedDirectoryList.addTooltip' => 'Skapa en skyddad katalog.',
    'ProtectedDirectoryList.name' => 'Namn',
    'ProtectedDirectoryList.realmTitle' => 'Titeln på det skyddade området.',
    'ProtectedDirectoryList.noSelectionText' => 'Välj ett eller flera objekt att ta bort.',
    'ProtectedDirectoryList.edit' => 'Redigera',
    'ProtectedDirectoryList.remove' => 'Ta bort skydd',
    'ProtectedDirectoryList.removeTooltip' => 'Ta bort skyddet från de valda katalogerna.',
    'ProtectedDirectoryList.removeConfirmation' => 'Denna åtgärd kommer att ta bort skyddet från {count, plural, =1 {katalogen {name}} other {# valda kataloger}}. {count, plural, =1 {Denna katalog kommer att bli fritt tillgänglig} other {Katalogerna kommer att bli fritt tillgängliga}} för internetanvändarna.',
    'ProtectedDirectoryList.removeSuccess' => 'Valda kataloger togs bort.',

    'ProtectedDirectoryAdd.title' => 'Skapa en Skyddad katalog',
    'ProtectedDirectoryAdd.submit' => 'Skapa',
    'ProtectedDirectoryAdd.success' => 'Den skyddade katalogen %%path%% har skapats korrekt',

    'ProtectedDirectoryEdit.title' => 'Inställningar för den Skyddade katalogen',
    'ProtectedDirectoryEdit.success' => 'Skyddade kataloginställningar har förändrats',

    'ProtectedDirectoryUserAdd.title' => 'Skapa användare för skyddad katalog',
    'ProtectedDirectoryUserAdd.subtitle' => 'Katalog %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Användarnamn',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Lösenord',
    'ProtectedDirectoryUserAdd.submit' => 'Skapa',
    'ProtectedDirectoryUserAdd.success' => 'Skyddad katalog-användaren %%login%% skapades.',

    'ProtectedDirectoryUserPassword.title' => 'Lösenord för skyddad katalog-användaren',
    'ProtectedDirectoryUserPassword.subtitle' => 'Användare %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Lösenord',
    'ProtectedDirectoryUserPassword.submit' => 'Spara',
    'ProtectedDirectoryUserPassword.success' => 'Användarens uppgifter sparades.',

    'SummaryReport.Layout.title' => 'Redigera egenskaper för layout',
    'SummaryReport.Layout.success' => 'Rapportlayout %%name%% har uppdaterats.',
    'SummaryReport.Layouts.title' => 'Rapportlayouter',

    'SummaryReport.Layout.Add.title' => 'Skapa rapportlayout',
    'SummaryReport.Layout.Add.success' => 'Rapportlayout %%name%% har skapats.',

    'SummaryReport.Report.title' => 'Sammanfattningsrapport',
    'SummaryReport.Report.buttonLayouts' => 'Layouter',
    'SummaryReport.Report.buttonSchedule' => 'Schema',
    'SummaryReport.Report.buttonProperties' => 'Egenskaper',
    'SummaryReport.Report.buttonTrafficHistory' => 'Trafikhistorik',
    'SummaryReport.Report.buttonPrint' => 'Skriv ut',
    'SummaryReport.Report.buttonSend' => 'Skicka med e-post',
    'SummaryReport.Report.successSent' => 'Rapporten skickades till %%email%%',

    'SummaryReport.Schedule.title' => 'Leveransscheman för %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Leveransschema för %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Rapportleveransschema har uppdaterats.',

    'SummaryReport.Schedule.Add.title' => 'Skapa leveransscheman för %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Rapportleveransschema har skapats.',

    'SummaryReport.TrafficHistory.title' => 'Trafikhistorik',

    'VirtualDirectory.errNotExist' => 'Denna virtuella katalog är kopplad till en fysisk mapp som inte existerar.',
    'VirtualDirectory.errNoPermissions' => 'Du har inte behörighet för att se denna katalogs innehåll.',
    'VirtualDirectory.buttonProperties' => 'Katalogegenskaper',
    'VirtualDirectory.buttonPropertiesHint' => 'Visa och ändra den virtuella katalogens egenskaper.',
    'VirtualDirectory.buttonPermissions' => 'Katalogens åtkomstbehörigheter',
    'VirtualDirectory.buttonPermissionsHint' => 'Ställ in katalogens åtkomstbehörigheter.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Konfigurera ASP.NET-inställningar.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Konfigurera PHP-inställningar.',
    'VirtualDirectory.tabBrowse' => 'Kataloger',
    'VirtualDirectory.tabBrowseHint' => 'Arbeta med fysiska och virtuella filer och kataloger på webbplatsen %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'MIME-typer',
    'VirtualDirectory.tabMimeTypesHint' => 'Hantera registrerade MIME-typer.',
    'VirtualDirectory.buttonErrorDocs' => 'Feldokument',
    'VirtualDirectory.buttonErrorDocsHint' => 'Hantera feldokument.',
    'VirtualDirectory.tabProtection' => 'Skydd',
    'VirtualDirectory.tabProtectionHint' => 'Begränsa åtkomsten till katalogen med lösenordsskydd.',

    'VirtualDirectory.CreateDirectory.title' => 'Skapa katalog',
    'VirtualDirectory.CreateDirectory.name' => 'Katalognamn',
    'VirtualDirectory.CreateDirectory.success' => 'Katalogen %%name%% skapades.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Katalogen %%name%% existerar redan.',

    'VirtualDirectory.MimeTypeList.add' => 'Lägg till MIME-typ',
    'VirtualDirectory.MimeTypeList.edit' => 'Redigera MIME-typ',
    'VirtualDirectory.MimeTypeList.addHint' => 'Registrera en ny MIME-typ.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Anknytning',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Innehåll',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Välj ett eller flera objekt att ta bort.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Ta bort {count, plural, =1 {vald MIME-typ} one {# vald MIME-typ} other {# valda MIME-typer}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Valda MIME-typer togs bort.',

    'VirtualDirectory.CreateMimeType.title' => 'Lägg till MIME-typ',
    'VirtualDirectory.CreateMimeType.success' => 'Den nya MIME-typen registrerades.',

    'VirtualDirectory.EditMimeType.title' => 'Redigera MIME-typ',
    'VirtualDirectory.EditMimeType.success' => 'MIME-typen redigerades.',

    'VirtualDirectory.Protection.notSupported' => 'Katalogskydd stöds inte för denna katalog, eftersom namnet överskrider 245 tecken eller innehåller såna som inte stöds.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Det virtuella katalogskyddet är inaktiverat',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Skydda',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'Katalogen %%path%% skyddades.',
    'VirtualDirectory.Protection.tools' => 'Verktyg',
    'VirtualDirectory.Protection.removeProtection' => 'Ta bort skydd',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Gör URL som svarar mot katalogen som är åtkomlig för alla.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Ta bort skydd från den virtuella katalogen? Det kommer även att ta bort alla användare av skyddade kataloger och inställningar för skyddade kataloger.',
    'VirtualDirectory.Protection.settings' => 'Inställningar',
    'VirtualDirectory.Protection.settingsTooltip' => 'Visa katalogplats och ange en titel för det skyddade området.',

    'VirtualDirectory.AspDotNet.title' => 'Konfigurera ASP.NET-inställningar',

    'VirtualDirectory.Php.title' => 'PHP-version',
    'VirtualDirectory.Php.version' => 'Version',
    'VirtualDirectory.Php.success' => 'PHP-version uppdaterades.',


    'MassMailPage.sendEmail' => 'Skicka massutskick med e-post',
    'MassMailPage.selectAtLeastOneTemplate' => 'Välj minst en mall',
    'MassMailPage.confirmRemoval' => 'Är du säker på att du vill ta bort {count, select, 1 {vald mall} other {valda mallar}}?',
    'MassMailPage.remove' => 'Ta bort',
    'MassMailPage.filters' => 'Filter',
    'MassMailPage.name' => 'Mallnamn',
    'MassMailPage.sender' => 'Avsändare',
    'MassMailPage.recipients' => 'Mottagare',
    'MassMailPage.subject' => 'Ämne',
    'MassMailPage.created' => 'Skapat den',
    'MassMailPage.send' => 'Skicka',
    'MassMailPage.recipientsNone' => 'Ingen',
    'MassMailPage.recipientsAdmins' => 'Administratör',
    'MassMailPage.recipientsResellers' => 'Alla återförsäljare',
    'MassMailPage.recipientsResellersSelected' => 'Markerade återförsäljare',
    'MassMailPage.recipientsResellersExcept' => 'Alla återförsäljare utom markerade',
    'MassMailPage.recipientsClients' => 'Alla kunder',
    'MassMailPage.recipientsClientsSelected' => 'Markerade kunder',
    'MassMailPage.recipientsClientsExcept' => 'Alla kunder utom markerade',
    'MassMailPage.templatesRemoved' => 'Tog bort {count, select, 1 {mall} other {mallar}}.',
    'MassMailPage.emptyViewTitle' => 'Inga e-postmallar för massutskick',
    'MassMailPage.addNew' => 'Skapa mall',
    'CreateMassMailTemplatePage.templateCreated' => 'Mallen skapades.',
    'EditMassMailTemplatePage.templateUpdated' => 'Mallen uppdaterades.',
    'SendMassMailPage.emailSent' => 'E-postmeddelandet skickades.',
    'SendMassMailPage.fieldIsRequired' => 'Fältet får inte vara tomt',
    'SendMassMailPage.saveAsTemplate' => 'Spara det författade meddelandet i en ny mall',
    'SendMassMailPage.newTemplateName' => 'Nytt mallnamn',
    'SendMassMailPage.selectedTemplate' => 'Vald mall',
    'SendMassMailPage.send' => 'Skicka',
];