<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    //===============Button conhelp================//

    'b_disabled' => 'Esta prestación no está disponible en este momento.',
    'b_disabled_by_key' => 'La llave de licencia no soporta esta prestación.',
    'b_disabled_by_permissions' => 'No dispone del permiso necesario para realizar operaciones de backup.',
    'b_accept' => "Para poder usar {$PROD_NAME}, debe aceptar los términos de este contrato de licencia.",
    'b_action_log' => 'Configuración del registro de acciones.',
    'b_add_ip' => "Añada direcciones IP al grupo de direcciones IP del cliente.",
    'b_database_server_add' => 'Añada un servidor de bases de datos.',
    'b_adm_skeleton' => 'Administre la plantilla de host virtual.',

    'b_auto-updates' => "Actualice Plesk o sus componentes.",

    'b_codepage_change' => 'Haga clic para cambiar la codificación.',
    'b_configure_maillists' => 'Configuración postinstalación de la lista de correo.',
    'b_comp_info' => 'Información acerca de los componentes.',
    'b_decline' => "Si no acepta esta licencia, no podrá usar {$PROD_NAME}.",
    'b_dumps_list' => 'Acceda a las funciones de backup y restauración y gestione el almacenamiento de archivos de backup.',
    'b_dumps_list_disabled' => 'El servicio no está disponible porque no se han instalado las utilidades de backup.',
    'b_add_services' => 'Página de administración de servicios adicionales.',
    'b_add_ip_for_clients' => "Añada un propietario para esta dirección IP.",
    'b_anonymous_ftp' => 'Configure un FTP anónimo para el dominio.',
    'b_attach_add' => 'Añada el archivo adjunto.',
    'b_attach_remove' => 'Eliminar archivo adjunto.',
    'b_backup_ok' => 'Backup completado. Haga clic para ir al almacenamiento de archivos de backup.',
    'b_restore_ok' => 'Restauración completada. Haga clic para ir al almacenamiento de archivos de backup.',
    'b_cancel' => 'Descartar cualquier cambio y volver a la página anterior.',
    'b_card' => 'Edite la información personal.',
    'b_clean_log' => 'Borre el registro.',
    'b_cl_skeleton' => 'Administre la plantilla de host virtual.',
    'b_dashboard' => 'Vaya a la página principal.',
    'b_dashboard_shortcut_remove' => 'Elimine el acceso directo de la página principal.',
    'b_domain_restore' => 'Restaure el dominio usando este archivo de backup.',
    'b_domain_user' => 'Permitir y configurar el acceso del administrador del dominio.',
    'b_do_backup' => 'Realice un backup del dominio. Durante este proceso, no podrá acceder a las funciones de administración del dominio del panel del cliente.',
    'b_do_upload' => 'Cargue un volcado al almacenamiento.',
    'b_backup_configure' => 'Configuración del administrador de backups.',
    'b_domain_alias_add' => 'Cree un nombre de dominio adicional para su sitio web.',
    'b_domain_aliases_limit_reached' => 'Se ha alcanzado el límite de alias de dominio.',
    'b_create_client_back' => 'Descartar los parámetros sugeridos y volver a la página anterior.',
    'b_create_client_update' => 'Aplique los parámetros sugeridos y proceda con la creación del cliente.',
    'b_create_domain_back' => 'Descartar los parámetros sugeridos y volver a la página anterior.',
    'b_create_domain_update' => 'Aplicar los parámetros sugeridos y crear el dominio.',
    'b_create_domain_client_select' => 'Seleccione el cliente y haga clic en ACEPTAR para crear el dominio.',
    'b_crontab_unix' => 'Administre tareas del programador.',
    'b_crontab_win' => 'Administre tareas del programador.',
    'b_crontab_unix_turn_on' => 'Haga clic para activar la tarea programada.',
    'b_crontab_win_turn_on' => 'Haga clic para activar la tarea programada.',
    'b_crontab_unix_turn_off' => 'Haga clic para suspender la tarea programada.',
    'b_crontab_win_turn_off' => 'Haga clic para suspender la tarea programada.',
    'b_extcert_send_file' => 'Cargue un certificado comprado previamente del archivo especificado.',
    'b_extras_admin' => 'Herramientas adicionales de servidor.',
    'b_extras_client' => 'Herramientas adicionales de dominio.',
    'b_cl_ed' => "Haga clic para editar la información del cliente.",
    'b_cl_ed_update' => "Haga clic para actualizar la información del cliente.",
    'b_cl_limits' => 'Vea o defina los límites de la cuenta de cliente.',
    'b_cl_new_update' => 'Haga clic para crear la cuenta de cliente.',
    'b_cl_not_cr_dom' => 'El cliente no puede crear dominios.',
    'b_cl_on' => "Active la cuenta del cliente y todos los sitios web del cliente.",
    'b_cl_off' => "Suspenda la cuenta del cliente y todos los sitios web del cliente.",
    'b_cl_permissions' => 'Vea o configure permisos para los recursos asignados al cliente.',
    'b_cl_pref_up_level' => "Haga clic para volver a la página de configuración del cliente sin realizar la actualización.",
    'b_default_db_user' => "Use las credenciales del usuario de la base de datos seleccionado para acceder a la interfaz de administración de la base de datos.",
    'b_edit_tpl__add_ip' => 'Haga clic para añadir direcciones IP.',
    'b_edit_tpl__cancel_ip' => 'Haga clic para cancelar.',
    'b_icf' => 'Configure el firewall.',
    'b_ip_clients__add' => 'Haga clic para añadir.',
    'b_ip_clients__cancel' => 'Haga clic para cancelar.',
    'b_client_templates' => 'Administración de plantillas de cliente.',
    'b_create_login' => 'Haga clic para crear una cuenta en MyPlesk.com.',
    'b_skins_managment' => 'Haga clic para administrar skins.',
    'b_skin_add' => 'Cargue un skin nuevo a Plesk.',
    'b_skin_manual' => "Abra el manual del usuario acerca de la creación de skins personalizados para Plesk.",
    'b_skin_manual_not_installed' => "El manual del usuario acerca de la creación de skins personalizados para Plesk no está instalado.",
    'b_skin_download' => 'Haga clic para descargar el skin.',
    'b_skin_replace' => 'Haga clic para reemplazar el skin actual por el nuevo.',
    'b_spamassassin' => 'Configuración de servidor SpamAssassin.',

    'b_subdom_update' => 'Haga clic para actualizar la configuración.',
    'b_subdom_create' => 'Haga clic para crear el subdominio.',
    'b_switch_user' => 'Inicie sesión con otra cuenta.',
    'b_clients' => 'Administre cuentas de cliente.',
    'b_client_traffic' => "Tráfico del cliente.",
    'b_change_passwd' => "Haga clic para cambiar la contraseña del administrador.",
    'b_change_cert_name' => 'Cambie el nombre del certificado.',
    'b_databases' => 'Cree y administre bases de datos y usuarios de bases de datos.',
    'b_databases__change_server_passwd' => 'Haga clic para ir a la página donde cambiar la contraseña.',
    'b_directories' => 'Cree directorios SSL/TLS o no SSL/TLS protegidos con contraseña.',
    'b_db_access' => "Establezca las credenciales del administrador de la base de datos.",
    'b_pgsql_access' => "Establezca las credenciales del administrador de PostgreSQL.",
    'b_pgsql_not_access' => 'PostgreSQL no está instalado.',
    'b_db_add' => 'Añada una base de datos.',
    'b_db_add__lim' => 'No puede añadir bases de datos a este dominio porque se ha alcanzado el número máximo permitido de bases de datos.',
    'b_db_add_update' => 'Indique el nombre de la base de datos nueva y haga clic para añadirla.',
    'b_db_del' => 'Eliminar base de datos.',
    'b_db_admin_not_installed' => 'Webadmin no está instalado. Para obtener asistencia, póngase en contacto con su proveedor de servicios de hosting.',
    'b_db_no_default_user' => 'No se puede acceder a Webadmin. No se ha indicado el usuario predeterminado de Webadmin.',
    'b_db_dbserver_not_configured' => 'No se puede acceder a Webadmin. El servidor de bases de datos no está configurado.',
    'b_db_usr_add' => 'Añada un usuario a la base de datos.',
    'b_db_user_del' => 'Eliminar el usuario de la base de datos.',
    'b_db_usr_update' => 'Cambie la contraseña.',
    'b_db_rm_submit' => 'Eliminar las bases de datos seleccionadas.',
    'b_db_not_started' => 'El servidor de bases de datos no se ha iniciado',
    'b_db_not_configured' => 'El servidor de bases de datos no está configurado',
    'b_db_not_installed' => 'El servidor de bases de datos no está instalado',
    'b_default_text' => 'Establezca el texto de notificación predeterminado.',
    'b_du_rm_submit' => 'Eliminar usuarios de la base de datos.',
    'b_dns' => 'Administre la configuración DNS para el dominio.',
    'b_dns_soa_set' => 'Aplique todos los cambios.',
    'b_dns_acl_add' => 'Haga clic para añadir una dirección IP o una máscara subred.',
    'b_dns_rec_del' => 'Eliminar este registro de la zona DNS.', //to remove
    'b_dns_rec_new' => 'Seleccione el tipo de registro nuevo y haga clic para añadir.', //to remove
    'b_dnsrecord_add' => 'Haga clic para añadir un registro de recurso a la zona DNS',
    'b_dns_soa' => 'Haga clic para configurar las opciones de SOA',
    'b_dns_soa_default' => 'Haga clic para restaurar la configuración predeterminada de SOA.',
    'b_dns_default' => 'Haga clic para restaurar la zona DNS.',

    'b_dns_master_add' => 'Añadir servidor DNS principal.', //to remove
    'b_dns_new_ns' => 'Añada un servidor de nombres.', //to remove
    'b_dns_on' => 'Active el servicio DNS local para la zona.',
    'b_dns_off' => 'Desactive el servicio DNS local para la zona.',
    'b_dns_not_perm' => 'No dispone del permiso necesario para administrar la zona DNS para este dominio.',

    'b_dom_deact' => 'No disponible para dominios suspendidos.',
    'b_dom_del' => 'Eliminar toda la información del dominio.',
    'b_log_manager' => 'Administre archivos de registro y las opciones para procesarlos.',
    'b_dom_new' => 'Haga clic para crear un dominio.',
    'b_dom_new_no_clients' => 'No se pudo crear un dominio. No dispone de ninguna cuenta de cliente.',
    'b_dom_new_update' => 'Haga clic para crear un dominio.',
    'b_dom_on' => 'Active el dominio.',
    'b_dom_off' => 'Desactive el dominio.',
    'b_dom_pref' => 'Establezca la configuración para el dominio.',
    'b_dom_limits' => 'Vea o configure límites para el dominio.',
    'b_domain_traffic' => 'Tráfico del dominio.',
    'b_dom_reg' => 'Registre este dominio.',
    'b_dom_usr_del' => 'Elimine el acceso de usuario a nivel de dominio.',
    'b_doms_mng' => 'Administre los dominios registrados a través de Plesk.',
    'b_doms_reg' => 'Registre un dominio.',
    'b_report' => 'Vea el informe.',
    'b_report_saem' => 'Envíe el informe de estado a la dirección indicada.',
    'b_domains' => 'Administre dominios.',
    'b_domain_templates' => 'Cree, edite y elimine plantillas de dominio.',
    'b_download_log' => 'Descargue el archivo de registro a la máquina local.',
    'b_dumps_rm_submit' => 'Haga clic para eliminar los archivos de backup.',
    'b_edit_adm' => 'Haga clic para editar la información del administrador.',
    'b_custom_buttons' => 'Administración de botones personalizados.',
    'b_custom_button_add' => 'Haga clic para añadir un botón personalizado.',
    'b_custom_buttons_rm_submit' => 'Haga clic para eliminar los botones personalizados seleccionados.',
    'b_hide_aliases' => 'Oculte alias.',
    'b_hide_domainaliases' => 'Oculte los alias de dominio.',
    'b_hide_subdomains' => 'Oculte subdominios.',
    'b_home' => 'Volver a la página principal.',
    'b_hosting' => 'Administre y configure hosting web para el dominio.',
    'b_hst_del' => 'Eliminar la configuración actual de hosting.',
    'b_hst_not_set' => 'Hosting no configurado.',
    'b_hst_wo_ip' => 'Hosting no basado en IP.',
    'b_hst_wo_ip_or_not_ssl' => 'Hosting no basado en IP o soporte SSL/TLS no activado.',
    'b_not_phys_hst' => 'El hosting no es físico.',
    'b_web_stat_not_set' => "Las estadísticas web no se conservan. Si desea conservarlas, vaya a propiedades de la cuenta de hosting (Dominios > nombre de dominio > Configuración > menú de Estadísticas web) y seleccione el programa estadístico que desee usar.",
    'b_white_list' => 'Administre la lista blanca.',
    'b_white_list_add' => 'Añada un dominio a la lista blanca.',
    'b_hst_sel_next' => 'Configure el tipo de hosting seleccionado.',
    'b_hst_update' => 'Aplique todos los cambios.',
    'b_int_ip_del' => 'Seleccione las direcciones IP de la lista y haga clic para eliminarlas de la interfaz.',
    'b_ip_new' => 'Haga clic para añadir una dirección IP.',
    'b_ip_new_virtuozzo' => 'No se pudo añadir una dirección IP a Virtuozzo containers.',
    'b_ip_new_lycos' => 'No se pudo añadir una dirección IP a Lycos.',
    'b_ip_aliasing' => 'Administre las direcciones IP en el servidor.',
    'b_ip_del' => 'Seleccione las máscaras/direcciones IP de la lista y haga clic para eliminarlas.',
    'b_ip_rm_submit' => 'Haga clic para eliminar direcciones IP.',
    'b_ip_cl_rm_submit' => 'Haga clic para eliminar la dirección IP del grupo de direcciones IP.',
    'b_ip_pool' => "Administración del grupo de direcciones IP del cliente.",
    'b_language' => 'Establezca el idioma de la interfaz.',
    'b_login' => 'Acceda a Plesk.',
    'b_logo' => 'Administre el logo que aparece en la parte superior de la interfaz.',
    'b_logo_default' => 'Haga clic para restaurar el logo predeterminado.',
    'b_logo_send_file' => 'Introduzca un nombre de archivo para el logo y haga clic para cargarlo.',
    'b_logo_send_link' => 'Introduzca el nuevo vínculo para el logo y haga clic para adjuntarlo.',
    'b_logo_send_logo' => 'Introduzca nuevo nombre de archivo para el logo y haga clic para cargarlo.',
    'b_log_rm_submit' => 'Haga clic para eliminar archivos de registro.',
    'b_ma_rm_submit' => 'Haga clic para eliminar alias de correo.',

    'b_mail' => 'Configure las opciones del sistema de correo a nivel de servidor.',
    'b_mail_disabled_by_admin' => 'El servicio de correo para este dominio ha sido desactivado por el administrador del servidor.',

    'b_mail_resp_on' => 'Active la respuesta automática.',
    'b_mail_resp_off' => 'Desactive la respuesta automática.',
    'b_mail_resp_add' => 'Cree una respuesta automática.',
    'b_mail_resp_files' => 'Administre el repositorio de adjuntos.',
    'b_mail_resp_files_no_mailbox' => 'Esta prestación no está disponible en este momento porque no ha creado ningún buzón de correo bajo esta cuenta de correo.',
    'b_mail_resp_upload' => 'Cargue el archivo al repositorio de adjuntos.',
    'b_mail_resp_attach_add' => 'Cree un adjunto.',

    'b_mail_names' => 'Administre servicios de mensajería − Buzones POP3, redireccionamientos, grupos y respuestas automáticas.',
    'b_mail_name_resp_attach_selected' => 'Haga clic para adjuntar los archivos seleccionados a la respuesta automática.',

    'b_mail_on' => 'Active los servicios de correo para este dominio.',
    'b_mail_off' => 'Desactive los servicios de correo para este dominio.',
    'b_mail_preferences' => 'Configure las opciones de recepción de correo para usuarios inexistentes.',

    'b_mn_alias_new' => 'Añada un alias de correo.',
    'b_mn_mail_group' => 'Administre el grupo de correo.',
    'b_mn_mailbox' => 'Administre el buzón de correo.',
    'b_mn_preferences' => 'Configure la cuenta de correo.',
    'b_mn_responders' => 'Administre respuestas automáticas.',
    'b_mn_resp_rm_submit' => 'Elimine respuestas automáticas.',
    'b_mn_redir_rm_submit' => 'Elimine redireccionamientos de correo.',
    'b_mn_redirect' => 'Gestione reenvíos de correo.',
    'b_mn_files_rm_submit' => 'Haga clic para eliminar archivos.',
    'b_mn_attach_rm_submit' => 'Haga clic para eliminar adjuntos.',
    'b_mn_groups' => 'Haga clic para administrar grupos de correo.',
    'b_mn_spamfilter_on' => 'Haga clic para administrar la filtración de spam.',
    'b_mn_spamfilter_off' => 'El servicio de filtración de spam no está disponible en este momento. Para activarlo es necesario tener instalado el software de filtración de spam y activar el soporte para la filtración de spam a nivel de usuario en la página Buzón de correo -> Filtro antispam.',
    'b_mn_spamfilter_srv' => 'El administrador ha desactivado la opción que permite a los usuarios configurar la filtración de spam.',

    'b_make_dump' => 'Realice un backup del dominio.',
    'b_ftp_account_for_dumps_repository' => 'Para poder usar un servidor FTP externo para almacenar los backups del dominio, especifique las propiedades de la cuenta FTP usada para acceder al servidor.',
    'b_cron_task_backup' => 'Administre la realización de backups programados.',

    'b_mg_mem_del' => 'Seleccione los miembros del grupo en la lista y haga clic para eliminarlos.',
    'b_mg_add' => 'Añada la cuenta de correo a los grupos de correo seleccionados.',
    'b_mg_cancel' => 'Haga clic para cancelar.',
    'b_mg_del' => 'Elimine la cuenta de correo de los grupos de correo seleccionados.',
    'b_mg_mem_new' => 'Haga clic para añadir un miembro al grupo de correo.',
    'b_mg_turn_on' => 'Haga clic para activar el grupo de correo.',
    'b_mg_turn_off' => 'Haga clic para desactivar el grupo de correo.',
    'b_mg_update' => 'Haga clic para aplicar los cambios.',
    'b_mn_rm_submit' => 'Haga clic para eliminar cuentas de correo.',
    'b_mn_webmail_on' => 'Haga clic para abrir el webmail.',
    'b_mn_webmail_off' => 'En este momento no puede usar esta prestación porque el soporte para webmail no está activado en la configuración de correo o porque el buzón no está activado.',

    'b_modules_manage' => 'Administre los módulos instalados en Plesk y acceda a las funciones que estos proporcionan.',
    'b_notifications' => 'Edite notificaciones.',
    'b_permissions' => 'Vea o defina permisos para el cliente.',
    'b_performance' => 'Administre el rendimiento del dominio.',
    'b_first_page' => 'Ya se encuentra en la primera página.',
    'b_anonftp_stats' => 'Estadísticas de transacciones de FTP anónimo.',
    'b_ftp_stats' => 'Estadísticas de transacciones del servidor FTP.',
    'b_ftp_stats_disable' => 'Las estadísticas web no se conservan, el servicio FTP anónimo no está activado o el hosting no es físico.',
    'b_last_page' => 'Ya se encuentra en la última página.',
    'b_next_page' => 'Ir a la próxima página.',
    'b_prs_rm_submit' => 'Haga clic para eliminar prioridades.',
    'b_preferences' => "Configure las preferencias de la interfaz.",
    'b_prev_page' => 'Vaya a la página anterior.',
    'b_preview' => 'Previsualice el sitio antes de la propagación DNS.',
    'b_qus_rm_submit' => 'Haga clic para eliminar prioridades.',
    'b_repair_ip' => 'Haga clic para añadir la dirección IP.',
    'b_repair_ip_status_ok' => 'Esta dirección IP no necesita ser reparada.',
    'b_reboot' => 'Reinicie el servidor.',
    'b_refresh' => 'Actualice los datos en pantalla.',
    'b_key_buyonline_addons' => 'Compre complementos para Plesk.',
    'b_key_buyonline_upgrades' => 'Compre actualizaciones de Plesk.',
    'b_key_buyonline_new' => 'Compre una nueva llave de licencia.',
    'b_quick_search' => 'Vea la lista de elementos que coinciden con el criterio de búsqueda.',
    'b_remove_ip' => "Seleccione las direcciones IP de la lista y haga clic para eliminarlas del grupo de direcciones IP del cliente.",
    'b_restart_services' => "Gestionar servicios de {$PROD_NAME}.",
    'b_send_passwd' => 'Haga clic para recibir la contraseña por email.',
    'b_server' => 'Configure las preferencias a nivel de servidor.',
    'b_database_servers' => 'Administre servidores de bases de datos.',
    'b_server_pref' => 'Configuración de sistema e interfaz.',
    'b_sessions' => 'Administre sesiones.',
    'b_sess_rm_submit' => 'Haga clic para eliminar sesiones.',
    'b_set_time' => 'Establezca la fecha y hora de sistema.',
    'b_set_time_virtuozzo' => 'No se ha podido cambiar la fecha/hora de sistema en Virtuozzo containers.',
    'b_site_apps' => 'Administración de aplicaciones web.',
    'b_site_apppkgs' => 'Administración de paquetes de aplicación web.',
    'b_site_apppkgs_pool' => 'Administración de paquetes de aplicación web.',
    'b_site_apps_rm_submit' => 'Haga clic para eliminar las aplicaciones web seleccionadas.',
    'b_additional_key_is_active' => 'La llave de licencia ya está activa.',
    'b_additional_key_activate' => 'Haga clic para activar la llave de licencia.',
    'b_site_builder' => 'Haga clic para habilitar la integración con Presence Builder.',
    'b_dom_site_builder' => 'Haga clic para abrir el asistente de Presence Builder.',
    'site_builder_no_permission' => 'No tiene permisos para usar Mambo CMS.',
    'b_site_builder_no_package' => 'Mambo CMS no está instalado.',
    'b_site_builder_no_requires' => 'No se puede ejecutar Mambo CMS porque no se cumplen los requisitos de hosting.',
    'b_site_builder_no_vrt_hst' => 'Para poder usar Mambo CMS, configure hosting físico para este dominio.',
    'b_site_builder_setup' => 'Ejecutar Mambo CMS (si esta es la primera ejecución - la aplicación será configurada)',
    'b_show_aliases' => 'Mostrar alias.',
    'b_show_domainaliases' => 'Vea los alias de dominio.',
    'b_show_subdomains' => 'Mostrar subdominios.',
    'b_shutdown' => 'Apague el servidor.',
    'b_statistics' => 'Revise las estadísticas del servidor.',
    'b_system_time' => 'Administre la fecha y hora del sistema.',
    'b_support' => 'Solicite soporte técnico.',
    'b_summary_report' => 'Haga clic para ver el informe resumido.',
    'b_subdom_hosting' => 'Administre y configure hosting web para el subdominio.',
    'b_subdomains' => 'Cree y administre subdominios.',
    'b_traffic_history' => 'Vea el historial de tráfico.',
    'b_set_timezone' => 'Haga clic para establecer la zona horaria.',
    'b_set_timezone_virtuozzo' => 'No se ha podido cambiar la zona horaria en Virtuozzo containers.',
    'b_uninst_submit' => "Haga clic para desinstalar {$PROD_NAME}.",
    'b_uninst_cancel' => 'Haga clic para cancelar la desinstalación.',
    'b_upload_from_ftp' => 'Haga clic para ver la lista de backups presentes en el servidor FTP.',
    'b_ok' => 'Aplique todos los cambios.',
    'b_update' => 'Aplique todos los cambios.',
    'b_update_db_access' => 'Guarde los cambios realizados en las credenciales de acceso a la base de datos.',
    'b_updtntp' => 'Active/desactive la sincronización de hora con el servidor NTP.',
    'b_updtntp_virtuozzo' => 'No se pudo configurar la sincronización de fecha y hora con el servidor NTP en Virtuozzo containers.',
    'b_updtpswd' => "Cambie la contraseña del administrador.",
    'b_upload_dump' => 'Cargue el archivo de backup al almacenamiento de backups.',
    'b_no_dumps_on_ftp' => 'El almacenamiento remoto está vacío.',
    'b_web_stats' => 'Estadísticas de transacciones del servidor web.',
    'b_web_stats_disable' => 'Las estadísticas web no están activadas o el hosting no es físico.',
    'b_web_stats_ssl' => 'Estadísticas de transacciones seguras del servidor web.',
    'b_web_stats_ssl_disable' => 'Las estadísticas web no están activadas, el servidor web seguro no está configurado o el hosting no es físico.',
    'b_web_users' => 'Configure usuarios web para el dominio.',
    'b_vhost_app_add' => 'Instale aplicación web en el dominio.',
    'b_vhost_app_add_no_domains' => 'Ya existen aplicaciones web instaladas en los directorios root de estos hosts virtuales.',
    'b_interface_management' => 'Oculte o muestre varios elementos de Plesk.',
    'b_virtualdirs' => 'Administre directorios virtuales.',
    'b_virtualdir_add' => 'Añada un directorio virtual.',
    'b_zone_switch_master' => 'Cambie el tipo de zona DNS a principal.',
    'b_zone_switch_slave' => 'Cambie el tipo de zona DNS a secundaria.',

    'b_logrotation_update' => 'Edite la configuración de rotación de registros.',
    'b_logrotation_on' => 'Active la rotación de registros.',
    'b_logrotation_off' => 'Desactive la rotación de registros.',

    'b_dom_tmpl_add' => 'Cree una plantilla de dominio.',
    'b_cl_tmpl_add' => 'Cree una plantilla de cliente.',
    'b_tmpl_update' => 'Actualice las propiedades de la plantilla.',
    'b_tmpl_rm_subm' => 'Haga clic para eliminar las plantillas.',

    'b_defaultcomponents' => 'Selección de servicios de terceros.',
    'b_defaultcomponents__update' => 'Confirme la selección y configure los servicios de terceros.',
    'b_defaultcomponents__cancel' => 'Descartar cualquier cambio y volver a la página anterior.',

    'b_locale_add' => 'Haga clic para cargar un paquete de idioma nuevo.',
    'b_locales_managment' => 'Haga clic para administrar los idiomas de la interfaz.',

    'b_subdom_performance' => 'Administre el rendimiento del subdominio.',

    'b_anon_on' => 'Active el servicio FTP anónimo para el dominio.',
    'b_anon_off' => 'Desactive el servicio FTP anónimo para el dominio.',

    'b_maillists' => 'Haga clic para administrar listas de correo.',
    'b_maillist_new' => 'Haga clic para crear una lista de correo.',
    'b_maillist_edit' => 'Haga clic para acceder a las funciones de administración de listas de correo.',
    'b_maillist_turn_on_off' => 'Haga clic para cambiar el estado de la lista de correo.',
    'b_maillists_on' => 'Active el servicio de listas de correo.',
    'b_maillists_off' => 'Desactive el servicio de listas de correo.',
    'b_maillist_off_disabled' => 'La desactivación de listas de correo no es soportada por el servidor de correo actual.',
    'b_maillists_invert_on_off' => 'Haga clic para cambiar el estado de las listas de correo seleccionadas.',

    'b_dom_performance_edit' => 'Gestione el rendimiento del dominio.',
    'b_dom_performance_readonly' => 'Vea la configuración de rendimiento del dominio.',
    'b_dom_performance_disabled' => 'Prestación desactivada mientras QoS no se aplique al dispositivo de red.',
    'b_subdom_performance_disabled' => 'Prestación desactivada mientras QoS no se aplique al dispositivo de red.',

    //=============return to up level conhelp =====================

    'b_to_admin' => "Vuelva a la administración del servicio de asistencia.",
    'b_to_aliases' => 'Vuelva a la página de gestión de alias de correo.',
    'b_to_autoinstaller_components' => 'Vuelva a la página de selección de componentes.',
    'b_to_autoinstaller_releases' => 'Vuelva a la página de selección de versiones.',
    'b_to_custom_buttons' => 'Vuelva a la página de administración de botones personalizados.',
    'b_to_cl_traffic' => "Vuelva a la página de tráfico del cliente.",
    'b_to_cl_templates' => "Vuelva a la lista de plantillas de cliente.",
    'b_to_cl_pref' => 'Vuelva a la configuración del cliente.',
    'b_to_comp_info' => "Vuelva a la gestión de componentes de Plesk.",
    'b_to_dom_rep' => 'Vuelva a la página de información del dominio.',
    'b_to_filemanager' => 'Vuelva al administrador de archivos.',
    'b_to_subdomains' => 'Vuelva a la lista de subdominios.',
    'b_to_sessions' => 'Vuelva a las sesiones.',
    'b_to_databases_db' => "Vuelva a la página de herramientas y credenciales del administrador de la base de datos.",
    'b_to_dumps_list' => 'Vuelva al almacenamiento de archivos de backup del dominio.',
    'b_to_backup_manager' => 'Vuelva a la página de administración de backups.',
    'b_to_log_files' => 'Vuelva a la lista de archivos de registro.',
    'b_to_domains' => 'Vuelva a la lista de dominios.',
    'to_domain_aliases' => 'Vuelva a la página de alias de dominio',
    'b_to_clients' => 'Vuelva a la lista de clientes.',
    'b_to_client_home' => "Vuelva a la página principal del cliente.",
    'b_to_cp_access' => 'Volver a la página de administración de las restricciones de acceso.',
    'b_to_crontab_unix' => 'Vuelva a la página de administración de la tabla Cron.',
    'b_to_crontab_win' => 'Vuelva a la página de administración del programador.',
    'b_to_dns' => 'Vuelva a la administración de la zona DNS.',
    'b_to_dom_ctrl' => 'Vuelva a la página de administración de dominios.',
    'b_to_license_management' => 'Vuelva a la información de la licencia.',
    'b_to_mail' => 'Vuelva a la configuración de las opciones de correo a nivel de servidor.',
    'b_to_maillists' => 'Vuelva a la administración de listas de correo.',
    'b_to_maillist_members' => 'Vuelva a la administración de miembros de la lista de correo.',
    'b_to_mail_names' => 'Vuelva a la administración de cuentas de correo.',
    'b_to_mail_name_responders' => 'Vuelva a la administración de respuestas automáticas.',
    'b_to_mail_name_resp_edit' => 'Vuelva a la edición de las propiedades de la respuesta automática.',
    'b_to_mail_name_resp_attach_add' => 'Vuelva a la creación de un adjunto nuevo.',
    'b_to_mail_name_redirects' => 'Vuelva a la administración de reenvíos de correo.',
    'b_to_mail_name_files' => 'Vuelva al repositorio de adjuntos de la cuenta de correo.',
    'b_to_mail_white_list' => 'Vuelva a la administración de entradas de la lista blanca.',
    'b_to_notifications' => 'Vuelva a la edición de notificaciones.',
    'b_to_server' => 'Vuelva a la página de administración del servidor.',
    'b_to_spamassassin' => 'Vuelva a la configuración del filtro antispam.',
    'b_to_skins' => 'Vuelva a la administración de skins.',
    'b_to_skin_info' => 'Vuelva a visualizar las propiedades del skin.',
    'b_to_scheduler' => 'Vuelva a la página de administración del programador.',
    'b_to_subdom_ctrl' => 'Vuelva a la página de administración del subdominio.',
    'b_to_prs' => 'Vuelva a las prioridades.',
    'b_to_responders' => 'Vuelva a la administración de respuestas automáticas.',
    'b_to_virtualdirs' => 'Vuelva a la administración de directorios virtuales.',
    'b_to_virtualdir_edit' => 'Vuelva al directorio virtual anterior.',
    'b_to_virtualdir_root' => 'Vuelva a la lista de directorios virtuales.',
    'b_to_web_users' => 'Vuelva a la lista de usuarios web.',
    'b_to_cert' => 'Vuelva a la administración de certificados.',
    'b_to_cl_rep' => "Vuelva a la información del cliente.",
    'b_to_report' => 'Vuelva al informe.',
    'b_to_report_list' => 'Vuelva a la página de diseños de informe personalizados.',
    'b_to_db_list' => 'Vuelva a la lista de bases de datos.',
    'b_to_db_usr_lst' => 'Vuelva a la lista de usuarios de base de datos.',
    'b_to_db_servers' => 'Vuelva a la lista de servidores de bases de datos.',
    'b_to_dns_template' => 'Vuelva a la lista de registros de plantillas DNS.', //to remove
    'b_to_log_files_list' => 'Vuelva a la administración de archivos de registro.',
    'b_to_log_rotation' => 'Vuelva a la configuración de rotación de registros.',
    'b_to_locales' => 'Vuelva a la administración de los idiomas de Plesk.',
    'b_to_modules' => 'Vuelva a la administración de módulos.',
    'b_to_modules_management' => 'Vuelva a la administración de módulos.',
    'b_to_cl_pool' => 'Vuelva a la administración del grupo de direcciones IP.',
    'b_to_db' => 'Vuelva a la administración de bases de datos.',
    'b_to_db_edit' => 'Vuelva a la administración de usuarios de base de datos.',
    'b_to_dom_templates' => 'Vuelva a la administración de plantillas de dominio.',
    'b_to_dom_sum_report' => 'Vuelva al informe resumido del dominio.',
    'b_to_statistics' => 'Vuelva a las estadísticas de tráfico.',
    'b_to_ip_aliasing' => 'Vuelva a la administración de direcciones IP.',
    'b_to_qus' => 'Vuelva a la lista de colas.',
    'b_to_site_apps' => 'Vuelva a la lista de aplicaciones web.',
    'b_to_site_app_pkgs' => 'Vuelva al Application Vault.',
    'b_to_siteapp_install' => 'Vuelva al asistente de instalación de aplicaciones web.',
    'b_to_siteapppackage_info' => 'Vuelva a las propiedades del paquete de aplicación web.',
    'b_to_additional_key_info' => 'Vuelva a las propiedades de la llave de licencia.',
    'b_to_additional_key_properties' => 'Vuelva a las propiedades de la llave de licencia.',


    //===============Href conhelp==================//
    'b_components_choice_default' => 'Cambie el componente predeterminado para esta prestación.',
    'b_components_configure' => "Establezca los parámetros de configuración para este componente.",


    //===============Icon conhelp==================//

    'i_db_conn_none' => 'Esta prestación no está disponible porque su llave de licencia no la soporta o el servicio no está instalado.',
    'i_db_conn_ok' => 'Se ha establecido la conexión a la base de datos.',
    'i_db_conn_att' => 'El servidor de bases de datos no está en ejecución o se han indicado unas credenciales incorrectas.',
    'i_db_conn_stopped' => 'El servidor de bases de datos no ha sido iniciado.',
    'i_db_conn_login_failed' => 'Se han indicado unas credenciales incorrectas para la conexión a la base de datos.',

    'i_drweb_off' => "La comprobación de virus no está activada para la cuenta de correo.",
    'i_drweb_any' => 'La comprobación de virus está activada para el correo entrante/saliente.',
    'i_drweb_from' => 'La comprobación de virus está activada para el correo saliente.',
    'i_drweb_to' => 'La comprobación de virus está activada para el correo entrante.',
    'i_drweb_turn_key' => 'El antivirus no es soportado por la llave de licencia.',
    'i_drweb_turn_perm' => 'No tiene permisos para el antivirus.',
    'i_drweb_turn_install' => 'Antivirus no instalado.',
    'i_drweb_turn_pref' => 'Haga clic para administrar la configuración del antivirus.',

    'i_client_ok' => 'El uso de recursos del cliente está dentro de los límites.',
    'i_cl_ok' => 'El uso de recursos del cliente está dentro de los límites.',
    'i_cl_!' => "El uso de recursos del cliente excede los límites.",
    'i_client_on' => 'Esta cuenta de usuario está activa.',

    'i_client_cp_access_on' => 'El cliente tiene permiso para acceder al panel.',
    'i_client_cp_access_off' => 'El cliente no tiene permiso para acceder al panel.',
    'i_click_to_cl_cp_access_on_off' => "Haga clic para permitir o prohibir el acceso al panel del cliente.",

    'i_custom_errors_del' => 'Haga clic para eliminar el elemento de la lista.',
    'i_custom_errors_del_disabled' => 'No se pueden eliminar los errores predeterminados y personalizados del servidor.',

    'i_open_subdomain' => 'Haga clic para ver el sitio en el navegador web.',
    'i_open_domain' => 'Haga clic para ver el sitio en el navegador web.',
    'i_open_domain_disabled' => 'El dominio no tiene hosting configurado.',

    'i_dom_ok' => 'El uso de recursos de este dominio está dentro de los límites asignados.',

    'i_dom_tmpl__owner_admin' => 'Esta plantilla es creada por el administrador',
    'i_dom_tmpl__owner_client' => 'Esta plantilla ha sido creada por el cliente.',

    'i_dns_on' => 'Esta zona DNS está servida por el servidor DNS local.',
    'i_dns_off' => 'Esta zona DNS está servida por un servidor DNS externo.',
    'i_click_to_dom_on_off' => 'Haga clic para activar/desactivar el dominio.',
    'i_click_to_cl_on_off' => "Haga clic para activar/desactivar la cuenta de cliente y los dominios del cliente.",
    'i_dom_!' => 'Este dominio ha excedido los límites de uso de recursos.',
    'i_dom_on' => 'Dominio activo.',
    'i_dom_off' => 'Dominio inactivo.',
    'i_dom_off_by_admin' => 'El dominio ha sido suspendido por el administrador.',
    'i_dom_off_by_reseller' => 'El dominio ha sido suspendido por el revendedor.',
    'i_dom_off_by_client' => 'El dominio ha sido suspendido por el cliente.',
    'i_dom_off_expired' => 'Dominio expirado.',
    'i_dom_off_with_parent' => "Se ha suspendido esta cuenta de usuario y el dominio del usuario.",
    'i_dom_off_backup_restore' => 'Dominio suspendido temporalmente para finalidades de backup o restauración.',

    'i_locale_active_true' => 'Este idioma está disponible para los usuarios de Plesk.',
    'i_locale_active_att' => 'Este idioma ya no está disponible para los usuarios porque se ha excedido el número máximo de idiomas permitidos.',
    'i_locale_active_false' => 'Este idioma no está disponible para los usuarios.',
    'i_locale_set_active_true' => 'Haga clic en este icono para que el idioma esté disponible para los usuarios.',
    'i_locale_set_active_false' => 'Haga clic en este icono para que el idioma no esté disponible para los usuarios.',
    'i_locale_default_locale' => 'Este es el idioma predeterminado: no puede deshabilitarlo para los usuarios.',

    'i_log_rot_enabled' => 'La rotación de registros está activada.',
    'i_log_rot_disabled' => 'La rotación de registros está desactivada.',
    'i_log_rot_disabled_by_parent' => 'La rotación de registros está desactivada porque se deshabilitó el sitio web.',

    'i_spamfilter_on' => 'La filtración de spam está activada.',
    'i_spamfilter_off' => 'La filtración de spam está desactivada.',
    'i_spamfilter_turn_srv' => 'La directiva del servidor no permite el uso de opciones de protección antispam individuales.',
    'i_spamfilter_turn_key' => 'SpamAssassin no es soportado por la llave de licencia.',
    'i_spamfilter_turn_component' => 'El componente SpamAssassin no está instalado.',
    'i_spamfilter_service_off' => 'El servicio SpamAssassin no está en ejecución.',
    'i_spamfilter_turn_is_disabled_system_wide' => "La protección antispam ha sido desactivada por su proveedor de servicios de hosting.",
    'i_spamfilter_turn_permission' => 'No dispone del permiso necesario para administrar el filtro antispam.',

    'i_additional_key_free' => 'Distribución gratuita. No requiere ninguna llave de licencia.',
    'i_additional_key_ok' => 'La llave de licencia requerida está instalada.',
    'i_additional_key_problem' => 'La llave de licencia requerida no está instalada.',
    'i_additional_key_info' => 'Haga clic en el icono para acceder a las funciones de administración de llaves de licencia.',
    'i_additional_key_download' => 'Haga clic para descargar la llave de licencia.',

    'i_vcard' => 'Añada un contacto a su libreta de direcciones.',

    'i_autoinstaller_component_action_error' => 'Ninguna actualización disponible.',

    'i_autoinstaller_release_action_upgrade' => 'Actualizando a la nueva versión de Plesk.',
    'i_autoinstaller_release_action_update' => 'Actualizando o añadiendo componentes nuevos.',
    'i_autoinstaller_release_action_up2date' => 'Dispone de la versión más reciente.',
    'i_autoinstaller_release_action_error' => 'Error al recuperar la información acerca de la versión.',

    'i_autoinstaller_component_action_install' => 'No instalado',
    'i_autoinstaller_component_action_update' => 'Hay actualizaciones disponibles',
    'i_autoinstaller_component_action_upgrade' => 'Hay actualizaciones disponibles',
    'i_autoinstaller_component_action_up2date' => 'Dispone de la versión más reciente',

    'i_mail_resp_on' => 'La respuesta automática está activada.',
    'i_mail_resp_turn_off' => 'Haga clic en este icono para desactivarlo.',
    'i_mail_resp_off' => 'La respuesta automática está desactivada.',
    'i_mail_resp_turn_on' => 'Haga clic en este icono para activarlo.',
    'i_mail_resp_att' => 'Todas las respuestas automáticas para esta cuenta de correo están desactivadas.',

    'i_anonftp_on' => 'La cuenta FTP anónima para el dominio está activada.',
    'i_anonftp_off' => 'La cuenta FTP anónima para el dominio está desactivada.',

    'i_sapp_ssl' => 'La aplicación web está instalada en un directorio SSL/TLS.',
    'i_sapp_non_ssl' => 'La aplicación web está instalada en un directorio no-SSL/TLS.',
    'i_serv_drweb_up_dis' => "Inicie el servicio.",
    'i_serv_none' => 'El servicio no está instalado.',
    'i_serv_not_configured' => 'El servicio no está configurado.',
    'i_serv_on' => 'Servicio en ejecución.',
    'i_serv_off' => 'El servicio no está en ejecución.',
    'i_serv_up' => 'Inicie el servicio.',
    'i_serv_up_dis' => 'El servicio ya está en ejecución.',
    'i_serv_down' => 'Detenga el servicio.',
    'i_serv_down_dis' => 'El servicio ya ha está detenido.',
    'i_serv_up_n_down' => 'Reinicie el servicio.',
    'i_serv_up_n_down_dis' => 'El servicio está detenido.',
    'i_serv_key_dsbld_not_inst' => 'Esta función no está disponible porque su llave de licencia no la soporta o bien porque el servicio no está instalado o configurado correctamente.',

    'i_skin_download' => 'Haga clic para descargar el skin.',

    'i_virtualdirs_read_enabled' => 'Permiso de lectura para el directorio virtual activo.',
    'i_virtualdirs_read_disabled' => 'Permiso de lectura para el directorio virtual desactivado.',
    'i_virtualdirs_write_enabled' => 'Permiso de escritura para el directorio virtual activado.',
    'i_virtualdirs_write_disabled' => 'Permiso de escritura para el directorio virtual desactivado.',
    'i_virtualdirs_source_enabled' => 'Permiso de acceso a la fuente de los scripts para el directorio virtual activado.',
    'i_virtualdirs_source_disabled' => 'Permiso de acceso a la fuente de los scripts para el directorio virtual desactivado.',
    'i_virtualdirs_browse_enabled' => 'Permiso de navegación para el directorio virtual activado.',
    'i_virtualdirs_browse_disabled' => 'Permiso de navegación para el directorio virtual desactivado.',
    'i_virtualdirs_change_status' => 'Haga clic para activar/desactivar el permiso.',

    'b_show_additional_users' => 'Amplía la lista de grupos de usuarios, mostrando los usuarios para los que no se ha definido ningún permiso.',
    'b_hide_additional_users' => 'Reduce la lista de grupos de usuario, ocultando usuarios sin permisos definidos.',

    'i_prtd_ssl' => 'El directorio SSL/TLS está protegido con contraseña.',
    'i_prtd_no_ssl' => 'El directorio SSL/TLS no está protegido con contraseña.',
    'i_prtd_nonssl' => 'El directorio no SSL/TLS está protegido con contraseña.',
    'i_prtd_no_nonssl' => 'El directorio no SSL/TLS no está protegido con contraseña.',
    'i_prtd_cgi_bin' => 'el directorio cgi-bin está protegido con contraseña.',
    'i_prtd_no_cgi_bin' => 'el directorio cgi-bin no está protegido con contraseña.',

    'i_htype_none' => 'Hosting no configurado.',
    'i_htype_vrt_hst' => 'Hosting físico.',
    'i_htype_frm_fwd' => 'Redireccionamiento por marcos.',
    'i_htype_std_fwd' => 'Redirección estándar.',

    'i_click_to_hosting' => 'Haga clic para configurar el hosting.',

    'i_ftp_ses_domain' => 'Sesión de administrador de dominio.',
    'i_ftp_ses_sub_domain' => 'Sesión de administrador del subdominio.',
    'i_ftp_ses_web_user' => 'Sesión de usuario web.',
    'i_ftp_ses_anonymous' => 'Sesión de usuario FTP anónimo.',
    'i_ftp_ses_not_plesk' => 'Usuario FTP no registrado en Plesk.',
    'i_ftp_ses_idle' => 'Inactivo (sin transacciones).',
    'i_ftp_ses_upload' => 'Carga en curso.',
    'i_ftp_ses_download' => 'Descarga en curso.',
    'i_ftp_ses_list' => 'Descargando una lista de directorios.',
    'i_ftp_ses_not_know' => 'Actividad FTP no reconocida.',


    //===============Page conhelp==================//

    'admin_ed' => 'Información del administrador.',
    'anonftp' => 'Configure el servicio FTP anónimo.',
    'actionlog' => 'Gestione la configuración del registro de acciones.',
    'auto_updates' => "Actualizaciones disponibles de {$PROD_NAME}.",
    'autoinstaller_releases' => 'Seleccione el nombre de la versión deseada para acceder a la lista de componentes disponibles.',
    'autoinstaller_components' => 'Seleccione los componentes requeridos y haga clic en Instalar para instalarlos.',
    'autoinstaller_install' => 'Confirme la instalación y haga clic en ACEPTAR para empezar.',
    'autoinstaller_configure' => 'Configuración del actualizador.',
    'backup_dialog' => 'En esta página puede realizar un backup del dominio. El archivo de backup resultante puede guardarse en el almacenamiento de backups local o remoto o bien descargarse al disco local.',
    'backup_configure' => 'Página de configuración del administrador de backups.',
    'card' => 'Edite la información personal.',
    'cat_edit' => 'Página de configuración de categorías.',
    'cert' => 'Repositorio de certificados.',
    'cert_dom' => 'Repositorio de certificados.',
    'cert_add' => 'Añada un certificado.',
    'cert_add_dom' => 'Añada un certificado.',
    'cert_edit' => 'Página de edición de certificados.',
    'cl_ed' => "Edite la información del cliente y haga clic en ACEPTAR.",
    'cl_home' => 'Página principal del cliente.',
    'cl_new' => "Indique la información del cliente y haga clic en ACEPTAR para crear una cuenta de cliente.",
    'cl_perm' => "Configure los permisos del cliente.",
    'cl_limits' => "Configure los límites del cliente.",
    'cl_logo' => "Establezca un logo para el panel del cliente.",
    'cl_pool' => 'El rango de direcciones IP asignado al cliente.',
    'cl_pool_add' => "Asignación de direcciones IP al cliente.",
    'cl_pool_first_time' => 'Asignación de direcciones IP al cliente.',
    'cl_pool_ctrl' => 'Propiedades de dirección IP.',
    'cl_pref' => "Configuración del cliente.",
    'cl_traffic_history' => 'Página de historial de tráfico del cliente.',
    'cl_templates' => 'Esta página muestra la lista de plantillas del cliente.',
    'cl_traffic' => "Tráfico del cliente",
    'clients' => 'En esta página se muestra la lista de todas las cuentas de cliente registradas en el sistema.',
    'component_conf' => "Configurando los parámetros de los componentes.",
    'custom_buttons_admin' => 'Cree y administre sus botones personalizados.',
    'custom_buttons_domain' => 'Cree y administre sus botones personalizados.',
    'custom_buttons_client' => 'Cree y administre sus botones personalizados.',
    'custom_buttons_reseller' => 'Cree y administre sus botones personalizados.',
    'custom_buttons_remove' => 'Elimine los botones seleccionados.',
    'custom_button_admin_edit' => 'Edite el botón personalizado.',
    'custom_button_domain_edit' => 'Edite el botón personalizado.',
    'custom_button_client_edit' => 'Edite el botón personalizado.',
    'custom_button_reseller_edit' => 'Edite el botón personalizado.',
    'configure' => 'Página de configuración posterior a instalación.',
    'comp_info' => 'Información acerca de los componentes.',
    'common_acl' => 'Esta página muestra la lista de todas las IP y direcciones de red para las cuales se permite la transferencia de zona.',
    'to_common_acl' => 'Vuelva a la lista de control de acceso común.',
    'common_acl_add' => 'En esta página puede añadir un registro a la ACL de transferencia de zona.',
    'common_acl_remove' => 'Eliminación de los registros ACL seleccionados.',
    'cp_access' => 'Gestión del acceso a Plesk.',
    'cp_access_add_edit' => 'Propiedades de red.',
    'cp_access_remove' => 'Eliminación de redes de la lista de restricción de acceso.',
    'crontab_unix' => 'Esta página muestra todas las tareas programadas en el sistema.',
    'crontab_win' => 'Esta página muestra todas las tareas programadas en el sistema.',
    'crontab_unix_add_edit' => 'Rellene los campos requeridos y haga clic en ACEPTAR para programar la tarea.',
    'crontab_win_add_edit' => 'Rellene los campos requeridos y haga clic en ACEPTAR para programar la tarea.',
    'crontab_unix_remove' => 'Eliminación de las tareas seleccionadas.',
    'crontab_win_remove' => 'Eliminación de las tareas seleccionadas.',
    'scheduler' => 'Esta página muestra una lista de las tareas programadas en el sistema.',
    'scheduler_edit' => 'Rellene los campos requeridos y haga clic en ACEPTAR para añadir la tarea a las tareas programadas',
    'scheduler_remove' => 'Eliminación de las tareas programadas seleccionadas.',
    'b_databases_access' => 'Establezca credenciales de acceso a servidores de bases de datos externos.',
    'databases_db' =>  'Configuración de acceso a la base de datos y herramientas de gestión.',
    'databases_server' =>  'Esta página permite cambiar la contraseña usada para acceder al servidor de base de datos.',
    'db' => 'En esta página se muestran todas las bases de datos gestionadas por Plesk.',
    'db_add' => 'Adición de una base de datos nueva.',
    'db_edit' => 'En esta página se muestran todos los usuarios de esta base de datos.',
    'db_usr_edit' => 'Establezca una contraseña para el usuario de base de datos.',
    'defaultcomponents' => 'Seleccione los componentes predeterminados para los servicios.',
    'dl_usr_ed' => "Administre la cuenta del administrador del dominio.",
    'dns_add' => 'Añada un registro a la zona DNS para el dominio.',
    'dns_soa' => 'Configuración de opciones SOA.',
    'dns_check' => 'Resultados de las pruebas de zona DNS.',
    'dns_rec_edit' => 'Edite un registro de recurso.',
    'dns_default' => 'Restaure la zona DNS.',
    'mail_name_drweb' => 'Configuración de opciones del antivirus.',
    'dom_ctrl' => 'Administración de dominios.',
    'dom_traffic' => 'Tráfico en el dominio.',
    'dom_templates' => 'Una plantilla de dominio es un conjunto predefinido de restricciones, opciones y parámetros de hosting específicos del dominio, cuya finalidad es simplificar la creación de dominios gracias a la asignación automática de determinadas opciones.',
    'create_domain' => 'Introduzca un nuevo nombre de dominio para crear un dominio para el cliente.',
    'create_domain_client_select' => 'Seleccione el cliente para el que desea crear el dominio.',
    'dom_pref' => 'Configuración del dominio.',
    'dom_lim' => 'Límites del dominio.',
    'domain_report' => 'Información del dominio.',
    'domain_aliases' => 'Administre los alias de dominio.',
    'client_app_item_info' => 'Información de la aplicación web.',
    'client_report' => 'Información del cliente.',
    'cl_rpt_list' => 'Diseños de informes personalizados.',
    'dom_rpt_list' => 'Diseños de informes personalizados.',
    'dom_rpt_edit' => 'Edite el informe.',
    'dom_sum_report' => 'Esta página muestra información resumida acerca de todos los dominios servidos por el sistema.',
    'domains' => 'Esta página muestra la lista de todos los dominios servidos por el sistema.',
    'dumps_list' => 'Use las funciones de backup del dominio y gestione el almacenamiento de archivos de backup.',
    'download_dialog' => 'Creación de archivos de backup.',
    'extras' => 'Página de administración de servicios adicionales.',
    'edit_dom_tmpl' => 'Edite una plantilla de dominio en esta página.',
    'edit_cl_tmpl' => 'Edite una plantilla de cliente en esta página.',

    'interface_templates' => 'Administración de plantillas de interfaz.',
    'interface_templates_remove' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",

    'b_to_interface_templates' => 'Vuelva a la lista de plantillas de interfaz.',
    'b_interface_template_make_default' => 'Seleccione una plantilla de interfaz y haga clic para establecerla como predeterminada.',
    'interface_template_upload' => 'Cargue su plantilla de interfaz.',
    'interface_clients' => 'Lista de los clientes que usan esta plantilla de interfaz.',
    'b_to_interface_clients' => 'Vuelva a la lista de clientes que usan esta plantilla de interfaz.',
    'interface_clients_add' => 'Indique los clientes que deberían usar esta plantilla de interfaz.',
    'interface_clients_remove' => 'Especifique los clientes que no deberían usar la plantilla de interfaz.',

    'ftp_account' => 'Si usa un servidor FTP externo para el almacenamiento de archivos de backup, indique aquí las propiedades de la cuenta FTP usada en este servidor.',
    'ftp_dumps_list' => "Aquí puede ver el contenido del almacenamiento de archivos de backup en el servidor FTP. Puede seleccionar un archivo de backup para cargarlo al almacenamiento del dominio.",

    'filemanager' => 'Administre sus archivos y directorios en esta página.',
    'filemanager_rename_file' => 'Cambio de nombre de un archivo.',
    'filemanager_rename_dir' => 'Cambio de nombre de un directorio.',
    'filemanager_chmod' => 'Cambie los permisos de acceso al archivo.',
    'filemanager_copy_move' => 'Copia de archivo (mover).',
    'filemanager_create_file' => 'Creación de archivos.',
    'filemanager_show' => 'Visualización de archivos.',
    'filemanager_edit' => 'Edición de archivos.',
    'filemanager_remove' => 'Eliminación de archivos.',
    'filemanager_owner_row' => 'Propietario del archivo.',
    'filemanager_new_file' => 'Creación de archivos.',
    'filemanager_new_dir' => 'Creación de directorios.',

    'gl_list' => 'Servicio de asistencia global.',
    'groups' => 'Administración de grupos de correo.',
    'icf' => 'Configuración del firewall.',
    'ip_clients' => 'La lista de usuarios que disponen de esta dirección IP en el grupo de direcciones IP.',
    'ip_clients_add' => 'Seleccione los clientes y haga clic en ACEPTAR para añadir esta dirección IP a sus grupos de direcciones IP.',

    'frm_fwd' => 'Introduzca la dirección URL de destino para la redirección.',
    'std_fwd' => 'Introduzca la dirección URL de destino para la redirección.',
    'performance' => 'Configuración del rendimiento del dominio.',
    'phosting_setup' => 'Configuración de cuenta de hosting. Seleccione el tipo de dirección IP (dedicada o compartida), las credenciales de la cuenta FTP y otros parámetros relacionados con el hosting.',
    'phosting_setup_dom_usr' => 'Configuración de parámetros de cuenta de hosting.',
    'webusers' => 'Esta página muestra los usuarios web de este dominio.',
    'hst_type_sel' => 'Seleccione el tipo de hosting a configurar.',
    'key_update' => 'Estado de actualización de la llave de licencia.',
    'key_revert' => 'Reversión de llaves de licencia.',
    'interface_management' => 'Aquí puede controlar los elementos de la interfaz de usuario que son visibles y los que no lo son.',
    'ip_aliasing' => 'Añada y elimine direcciones IP de los interfaces de red.',
    'ip_aliasing_clients' => 'Vea la lista de usuarios que disponen de esta dirección IP en sus grupos de direcciones IP',
    'ip_aliasing_hosting' => 'Vea los dominios alojados o redireccionados desde esta dirección IP',
    'ip_add' => 'Adición de dirección IP.',
    'ip_ctrl' => 'Cambio de parámetros de dirección IP.',
    'license' => 'Lea el contrato de licencia detenidamente.',
    'logo' => 'Cambiar imagen y URL del logo.',
    'log_files' => 'Esta página muestra todos los archivos de registro para este dominio.',
    'log_rotation' => 'Configuración de rotación de registros.',

    'locale_upload' => 'Carga de paquetes de idioma.',
    'locales' => 'Administre los idiomas de Plesk.',
    'locales_remove' => 'Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.',
    'mail_blocked_domains' => 'Administre la lista negra.',

    'mail_white_list' => 'Administre la lista blanca.',
    'mail_white_list_edit' => 'Añada dominios a la lista blanca.',
    'mail_white_list_remove' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",

    'mail_name_alias_edit' => 'Cree o edite un alias de correo.',
    'mail_name_groups' => 'Administración de miembros del grupo de correo.',
    'mail_name_mailbox' => 'Administración del buzón.',
    'mail_name_preferences' => 'Configuración de la cuenta de correo.',
    'mail_name_redirects' => 'Administración de redirección de correo.',
    'mail_name_redirects_add' => 'Añada miembros al grupo de correo.',
    'mail_name_redirects_remove' => 'Eliminación de miembros del grupo de correo.',
    'mail_name_resp_edit' => 'Configure la respuesta automática.',
    'mail_name_resp_attach_add' => 'Seleccione los archivos a adjuntar.',
    'mail_name_resp_attach_del' => 'Elimine adjuntos de respuesta automática.',
    'mail_name_resp_remove' => 'Elimine respuestas automáticas.',
    'mail_name_responders' => 'Administración de respuestas automáticas.',
    'mail_name_files' => 'Repositorio de adjuntos de la cuenta de correo.',
    'mail_name_files_remove' => 'Eliminación de archivos.',
    'mail_names' => 'Cuentas de correo (buzones, redireccionamientos y grupos de correo, respuestas automáticas).',
    'mail_preferences' => 'Configuración de correo.',

    'maillists' => 'Esta página muestra todas las listas de correo en este dominio.',
    'maillists_conf' => 'La página principal de creación de listas de correo.',
    'maillist_edit' => 'Configuración de listas de correo.',
    'maillist_new' => 'Adición de listas de correo.',
    'maillist_del' => 'Eliminación de listas de correo.',

    'maillist_members' => 'Suscriptores de la lista de correo.',
    'maillist_members_remove' => 'Eliminación de suscriptores de la lista de correo.',
    'maillist_member_edit' => 'Adición de usuarios a la lista de correo.',

    'upload_module' => 'Carga de extensiones.',
    'modules_management' => 'Administración de extensiones.',

    'b_modules_add' => 'Añada una extensión.',
    'modules_manaege' => 'Añada y elimine extensiones.',
    'modules' => 'Desde esta página puede acceder a las prestaciones proporcionadas por las extensiones instaladas en su Plesk.',

    'notifications' => 'Administre el sistema de notificaciones.',
    'notification_text' => 'Edite el texto de aviso.',
    'pg_manage' => 'Añadiendo/modificando la información del administrador de PostgreSQL.',
    'prtd_dirs' => 'Directorios protegidos con contraseña.',
    'reboot' => 'Ahora se reiniciará el sistema.',
    'responders' => 'Respuestas automáticas de correo.',
    'redirects' => 'Reenvío de correo.',
    'restart_services' => 'Administración de servicios.',
    'server' => 'Administración de servidor.',
    'sessions' => 'Cambie la configuración de la sesión.',
    'sessions_list' => 'Esta página muestra la lista de todas las sesiones.',
    'ftp_sessions_list' => 'Esta página muestra la lista de todas las sesiones FTP.',
    'cl_skeleton' => 'Administre la plantilla de host virtual.',
    'skeleton' => 'Administre la plantilla de host virtual.',
    'skins' => 'Administre los skins de Plesk.',
    'skin_info' => 'Información del skin.',
    'skin_download' => 'Descarga de skin.',
    'skin_download_now' => 'Descarga de skin en curso.',
    'skin_upload' => 'Carga de skin.',
    'skins_remove' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'shutdown' => 'El sistema se está apagando.',
    'site_app_pkgs_add' => 'Añada un paquete de aplicación web.',
    'site_app_pkgs_list' => 'Paquetes de aplicación web disponibles.',
    'site_app_pkgs_instances' => 'Instalaciones de la aplicación.',
    'siteapp_install' => 'Instalación de aplicación web.',
    'siteapp_reconfigure' => 'Reconfiguración de aplicación web.',
    'sitepackage_install_config' => 'Configuración de instalación de aplicación web.',
    'sitepackage_install_agreement' => 'Contrato de licencia de la aplicación web.',
    'siteapp_extra_files' => 'Especifique qué desea hacer con los archivos.',
    'siteapppackage_info_server' => 'Propiedades del paquete de aplicación web.',
    'siteapppackage_info_domain' => 'Propiedades del paquete de aplicación web.',

    'statistics' => 'Estadísticas de sistema.',
    'sys_time' => 'Establezca la fecha/hora del sistema y configure la sincronización con el servidor NTP.',
    'subdomains' => 'Administración de subdominios. En esta página puede añadir, editar y eliminar subdominios.',
    'subdom_ctrl' => 'Página de administración de subdominios.',
    'subdom_edit' => 'Configuración de propiedades del subdominio.',
    'subdom_create' => 'Creación de subdominios.',
    'subdom_remove' => 'Eliminación de los subdominios seleccionados.',
    'templates' => 'Esta página muestra la lista de todas las plantillas de dominio que pueden usarse para crear un dominio nuevo.',
    'view_info' => 'En esta página puede ver las propiedades del archivo de backup y restaurar este backup.',

    'visibility_adminonly' => 'Haga este control visible solo para el administrador.',
    'visibility_cancel' => 'Cancele la personalización de los controles en esta pantalla.',
    'visibility_control' => 'Haga clic para personalizar este control.',
    'visibility_customize' => 'Personalice controles individuales en esta pantalla.',
    'visibility_default' => 'Aplique la configuración predeterminada a este control.',
    'visibility_export' => 'Exporte la configuración realizada en esta pantalla en forma de script shell. Para importarla, ejecute este script en un servidor gestionado por Plesk.',
    'visibility_hide' => 'Oculte este control.',
    'visibility_hide_toolbar' => 'Oculte esta barra de herramientas.',
    'visibility_ok' => 'Guarde personalizaciones de controles en esta pantalla.',
    'visibility_reset_all' => 'Restablezca todos los controles de todas las pantallas a sus opciones predeterminadas.',
    'visibility_reset_screen' => 'Restablezca todos los controles de esta pantalla a sus opciones predeterminadas.',
    'visibility_show' => 'Mostrar este control.',

    'virtualdirs' => 'Administración de directorios virtuales.',
    'virtualdir_create' => 'Creación de directorios virtuales.',
    'virtualdir_edit' => 'Edición de directorios virtuales.',
    'virtualdirs_remove' => 'Eliminación de directorios virtuales.',
    'web_users' => 'Gestión de usuarios web del dominio.',
    'web_users_preferences' => "Configuración de usuarios web adicionales.",
    'wu_edit' => 'Establezca la contraseña FTP para el usuario web.',
    'lang' => 'Establezca el idioma predeterminado de la interfaz en esta página.',
    'ch_pass' => "Cambie la contraseña del administrador en esta página.",
    'dns_template' => 'Administración de plantillas de zona DNS.', //to remove
    'dns_template_add' => 'Añada un registro a la plantilla de zona DNS.', //to remove

    'dns_t' => 'Esta pantalla muestra los registros de recursos en la plantilla de zonas DNS del servidor.',
    'dns_t_add' => 'Añada un registro a la plantilla de zona DNS.',
    'dns_t_soa' => 'Configuración de opciones SOA.',
    'dns_t_rec_edit' => 'Edite un registro de recurso.',
    'dns_t_rec_remove' => 'Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.',
    'dns_t_default' => 'Restaure la plantilla de zona DNS.',
    'b_to_dns_t' => 'Vuelva a la lista de registros de plantillas DNS.',

    'web_app_add' => 'Añada una aplicación Java.',

    'qu_edit' => 'Página de configuración de colas.',
    'qus' => 'Esta página muestra la lista de colas.',

    'remove_modules' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeServers' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeCerts' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeMailAliases' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeDataBases' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeDataBaseUsers' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeCrontabTask' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeDomains' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeDNS' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeClients' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeLogFiles' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeDumps' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeMailNames' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeWebUsers' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeSessions' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeTemplates' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeIPAddress' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'removeClientsIP' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",

    'cat_remove' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'pr_remove' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'qu_remove' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",

    'pr_edit' => 'Configuración de prioridad.',
    'prs' => 'Esta página muestra las prioridades.',

    'spamassassin' => 'Configuración de SpamAssassin.',
    'spamassassin_train' => 'Seguimiento de las estadísticas de las bases de datos usados por el filtro Bayesiano. Clasificar el contenido del buzón como spam y correo deseado.',
    'spamassassin_train_view_message_source' => 'Haga clic para ver la fuente del mensaje.',
    'spamassassin_user_conf' => 'Configuración personal de SpamAssassin.',
    'spaw' => 'Editor HTML.',
    'upload_dump' => "Seleccione un archivo de backup y haga clic en 'Cargar' para subir el archivo al almacenamiento. Para cargar un backup multivolumen, especifique la primera parte del volumen, haga clic en el enlace 'Indicar el siguiente volumen' y especifique el próximo volumen. Repita estos pasos hasta que haya especificado todas los volúmenes del backup. Para finalizar, haga clic en 'Cargar'.",
    'subdom_performance' => 'Configuración de rendimiento del subdominio.',

    'dom_performance_edit' => 'Configuración del rendimiento del dominio.',
    'dom_performance_readonly' => 'Visualizando la configuración de rendimiento del dominio.',

    //===============List table header conhelp==================//

    'l_inv' => 'Invierta la selección de casillas.',
    'l_rad' => 'Seleccione el botón de opción.',

    'b_wizard_prev' => 'Vuelva al paso anterior del asistente.',
    'b_wizard_next' => 'Vaya al siguiente paso del asistente.',
    'b_finish' => 'Aplicar los cambios realizados en esta pantalla y salir del asistente.',

    // pacif add

    'b_backup_ftp_settings' => 'Haga clic para indicar la configuración de la cuenta FTP.',
    'b_backup_scheduled_settings' => 'Haga clic para programar la realización de backups.',
    'b_backup_ftp_not_configured' => 'La cuenta FTP no está configurada.',
    'backup_client_front' => 'Copie y restaure cuentas de usuario y programe la realización de backups.',
    'backup_domain_front' => 'Copie y restaure sitios web y programe la realización de backups.',
    'backup_client_new' => 'Copie una cuenta de usuario.',
    'backup_domain_new' => 'Copie un sitio web.',
    'backup_ftp_settings' => 'Indique la configuración para la cuenta FTP que se usará como almacenamiento remoto.',

    'backup_overwrite' => 'Seleccione la casilla para confirmar el reemplazo y haga clic en ACEPTAR para sustituir el archivo.',
    'b_backup_file_overwrite' => 'Haga clic para reemplazar el archivo de backup existente por uno nuevo.',
    'b_backup_file_overwrite_cancel' => 'Haga clic para cancelar el reemplazo de archivos y volver a la configuración de propiedades de backup.',
    'b_backup_cancel' => 'Haga clic para detener el proceso de backup.',

    'b_backup_cancel_creating' => 'Haga clic para cancelar la creación del backup y volver a la página anterior.',
    'b_backup_cancel_ftp_settings' => 'Haga clic para descartar la configuración de la cuenta FTP y volver a la pantalla anterior.',
    'b_restore_cancel' => 'Detenga la restauración.',
    'backup_progress' => 'Visualizando el progreso del backup. Haga clic en Cancelar para detener el proceso de backup.',
    'restore_progress' => 'Visualizando el progreso de restauración. Haga clic en Cancelar para detener la restauración.',
    'b_backup_new_restore' => 'Inicie la restauración.',
    'b_restore_cancel_creating' => 'Haga clic para cancelar la restauración y volver a la página anterior.',
    'b_backup_file_delete' => 'Haga clic para eliminar el archivo de backup.',
    'backup_delete' => 'Seleccione la casilla para confirmar la eliminación de los archivos de backup y haga clic en ACEPTAR.',
    'backup_result' => 'Una vez examinados los resultados del backup, haga clic en ACEPTAR para finalizar y volver al administrador de backups.',
    'backup_restore_results' => 'Una vez examinados los resultados de la restauración, haga clic en ACEPTAR para volver al administrador de backups.',

    'i_backup_domain_can_restore' => 'Este dominio puede ser restaurado.',
    'i_backup_domain_exist_other_client' => 'Este dominio no puede restaurarse porque ya existe otro dominio con este nombre, que pertenece a otro usuario.',
    'backup_failed' => 'Error en el backup.',
    'backup_stop' => 'Haga clic en ACEPTAR para detener el proceso de backup. Haga clic en Cancelar para seguir realizando el backup.',
    'restore_stop' => 'Haga clic ACEPTAR para detener la restauración. Haga clic en Cancelar para continuar con la restauración.',
    'backup_info_domain' => 'Para restaurar los datos de este backup, haga clic en Siguiente >>.',
    'backup_info_domain_restore' => 'Para restaurar los datos de este archivo de backup, haga clic en Restaurar.',
    'backup_info_client' => 'Para restaurar los datos de este backup, seleccione los elementos a restaurar y haga clic en Siguiente >>.',
    'backup_ip_mapping_domain' => 'Mapee la dirección IP registrada en el archivo de backup a otra dirección IP disponible.',
    'backup_ip_mapping_client' => 'Mapee las direcciones IP registradas en el archivo de backup a direcciones IP disponibles.',
    'backup__db_server_mapping' => 'Seleccione el servidor de bases de datos configurado en Plesk al que desea asignar el servidor de bases de datos del backup.',

    'b_restore_ip_mapping' => 'Haga clic para configurar la asignación de IP para la restauración.',
    'learn_more' => 'Más información acerca de esta prestación nueva.',
    'try_new_feature' => '!Pruebe esta nueva prestación!',
    'whats_new_full' => 'Una descripción detallada de las prestaciones nuevas y los cambios implementados en esta versión.',
    'b_migration_dump_all' => 'Migre todas las cuentas del host remoto.',
    'i_migration_not_exist_account' => 'Esta cuenta puede migrarse.',
    'i_migration_exist_account' => "Esta cuenta no puede migrarse: ya se encuentra en {$PROD_NAME}",
    'i_migration_not_exist_domain' => 'Este dominio puede migrarse.',
    'i_migration_exist_domain' => "No se puede migrar este dominio: ya se encuentra en {$PROD_NAME}",
    'i_migration_bad_domain' => 'Este dominio no puede migrarse: el nombre del dominio no es válido',
    'i_migration_con_exist_domain' => 'Algunos de los dominios ya fueron migrados a esta cuenta.',
    'i_migration_all_domain_exist' => "Solo se migrarán los datos de la cuenta: todos los dominios relacionados con esta cuenta ya se encuentran en {$PROD_NAME}",
    'migration_upload' => 'Seleccione la plataforma de origen, especifique el nombre del host de origen y las credenciales de acceso y haga clic en Siguiente para cargar el agente de migraciones y transferencias al host.',
    'migration_progress' => 'Vea el progreso de migración y detenga la migración si así lo desea.',
    'b_migration_host_info' => 'Vea la información acerca del host remoto y seleccione objetos a migrar.',
    'b_migration_single_info' => 'Puede importar todos los datos desde el volcado o seleccionar los objetos a importar. En esta página también puede definir la configuración de despliegue.',
    'migration_content_download' => 'Vea el progreso de la descarga de contenido y detenga la descarga si así lo desea.',
    'migration_content_download_not_space' => 'No hay suficiente espacio en disco para descargar el contenido del host remoto.',
    'migration_objects_select' => 'Seleccione las cuentas y dominios a migrar.',
    'migration_account_select' => 'Seleccione la cuenta de usuario en Plesk a la que desea migrar los dominios seleccionados.',
    'migration_ip_mapping' => 'Seleccione la dirección IP en Plesk a la que desea asignar las direcciones IP del host remoto.',
    'migration_stop' => 'Seleccione la casilla para confirmar que desea detener la migración y eliminar el agente de migraciones y transferencias del host remoto y haga clic en ACEPTAR.',
    'migration_result' => 'Una vez revisados los resultados de la migración, haga clic en Finalizar.',
    'migration_failed' => 'Error en la migración.',
    'b_migrate' => 'Inicie la migración.',
    'b_migrate_cancel' => 'Detenga el proceso de migración.',
    'b_migration_reload' => 'Haga clic para actualizar los datos.',
    'b_migrate_domains' => 'Haga clic para migrar los dominios seleccionados.',
    'b_migrate_accounts' => 'Haga clic para migrar las cuentas seleccionadas.',
    'b_migrate_set_accounts' => 'Haga clic para definir las cuentas para la migración de objetos.',
    'b_migrate_set_ip_map' => 'Haga clic para definir la asignación de IP para la migración de objetos.',
    'b_migrate_set_db_server_map' => 'Haga clic para configurar la asignación para las bases de datos migradas.',
    'b_migration_begin' => 'Haga clic para iniciar una nueva migración.',
    'b_migration_more' => 'Haga clic para migrar más objetos de este host.',
    'b_migration_retry' => 'Haga clic para continuar con la migración una vez liberado espacio en disco.',
    'b_migration_ignore' => 'Haga clic para continuar la migración de todas formas.',
    'b_migrate_single' => 'Migración de host único.',

    'b_migration_session_add' => 'Haga clic para crear una sesión de migración.',
    'b_to_migration_manager' => 'Vuelva a la lista de sesiones de migración.',
    'b_to_ip_map_page' => 'Vuelva a la asignación de IPs.',
    'migration_upload_ipmap_file' => 'Cargue un archivo de asignación de IP.',
    'b_ipmap_download' => 'Descargue el archivo map IP.',
    'b_ipmap_upload' => 'Cargue un archivo de asignación de IP.',

    'b_install' => 'Instalar aplicación web',

    'b_sb_menu_desktop' => "Ir a la página principal del administrador de sistema de Presence Builder.",
    'b_sb_menu_users' => "Añada y administre cuentas de usuario y planes de servicio para sus clientes.",
    'b_sb_menu_sites' => "Añada y administre sitios web.",
    'b_sb_menu_server' => "Configurar el sistema de Presence Builder.",
    'b_sb_menu_logs' => "Ver los registros de seguridad y sistema de Presence Builder.",
    'b_sb_server_configure' => "Configurar la integración con Presence Builder.",
    'sb_server_configure_page_description' => "Indique el nombre de usuario y la contraseña que debería utilizar Plesk para autorizarse en Presence Builder. Primero deberá establecer estas credenciales en Presence Builder.",
    'b_sb_site_wizard' => "Ir a Presence Builder para crear y administrar sitios web.",

    'b_connect' => 'Conecte su cuenta local a una cuenta global.',
    'b_disconnect' => 'Desconecte su cuenta local de una cuenta global.',
    'b_fi_change_passwd' => 'Cambie la contraseña de la cuenta global.',
    'connect' => 'Conecte su cuenta local con su cuenta global.',
    'disconnect' => 'Desconecte su cuenta local de su cuenta global.',
    'fi_change_passwd' => 'Cambie la contraseña de su cuenta global.',

    'sapp__no_license_key' => 'No puede crear paquetes de aplicaciones hasta que haya añadido una licencia al repositorio de llaves de licencia',

    'b_dns__tabs_general' => 'Página de configuración general del DNS.',
    'sessions__tabs_soa_record' => 'Personalización de registros SOA.',

    'packages_preinstall' => 'Configuración de instalación de aplicación web.',

    'packages_info_server' => 'Viendo la información del paquete de aplicaciones.',
    'packages_info_domain' => 'Viendo la información del paquete de aplicaciones.',
    'b_to_packages_info' => 'Vuelva a la página de información del paquete.',
    'packages_install' => 'La instalación del paquete de aplicaciones.',

    'b_server_app_add' => 'Haga clic para ir a la página de instalación de aplicaciones de servidor.',
    'b_help_install' => 'Iniciar instalación de la aplicación.',
    'b_help_cancel' => 'Cancelar instalación de la aplicación.',
    'packages_reconfigure' => 'Reconfiguración de aplicación de servidor.',
    'packages_remove' => 'Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.',

    'b_packages_management' => 'Administración de aplicaciones del servidor',
    'packages_management' => 'Aquí puede instalar y eliminar aplicaciones de servidor del servidor.',
    'b_to_packages_management' => 'Vuelva a la página de administración de aplicaciones del servidor.',

    'i_ftp_ses_type' => 'El último comando enviado por el cliente es TYPE.',
    'i_ftp_ses_pass' => 'El último comando enviado por el cliente es PASS.',
    'i_ftp_ses_noop' => 'El último comando enviado por el cliente es NOOP.',

    'virtualdirs__remove_submit' => 'Haga clic para eliminar los directorios virtuales seleccionados. Los directorios físicos no serán eliminados.',

    'b_set_skin' => 'Haga clic para que el skin actual sea el skin predeterminado de Plesk.',
    'set_skin__already_default' => 'El skin actual ya es el skin predeterminado de Plesk.',

    'i_custom_errors_add' => 'Introduzca la información necesaria y haga clic para añadir un mensaje de error personalizado.',

    'i_antivirus_off' => 'La protección antivirus no está activada para este buzón.',
    'i_antivirus_on' => 'La protección antivirus está activada para este buzón.',
    'i_antivirus_turn_pref' => 'Haga clic para configurar la protección antivirus.',
    'i_antivirus_turn_key' => 'La llave de licencia actual no soporta la protección antivirus.',
    'i_antivirus_turn_perm' => 'No tiene permisos para administrar el antivirus.',

    'b_acl_add' => 'Haga clic para añadir una dirección a la ACL de transferencia de zona.',
    'dns_acl' => 'Esta página muestra la lista de todas las IP y direcciones de red para las cuales se permite la transferencia de zona.',

    'i_antivirus_any' => 'La protección antivirus está activada para el correo entrante y saliente.',
    'i_antivirus_from' => 'La protección antivirus está activada para el correo saliente.',
    'i_antivirus_to' => 'La protección antivirus está activada para el correo entrante.',

    'i_ip_fail_no_interface' => 'No se encuentra la interfaz asociada con la dirección IP.',

    'b_test' => 'Compruebe la conexión.',

    'b_language_groups_add' => 'Añadir grupo de idiomas a la lista de idiomas de confianza.',
    'b_language_groups_del' => 'Eliminar grupo de idiomas de la lista de idiomas de confianza.',
    'b_locale_groups_add' => 'Añada el grupo de idiomas a la lista de idiomas de confianza.',
    'b_locale_groups_del' => 'Elimine el grupo de idiomas de la lista de idiomas de confianza.',
    'spam_trustednetworks_new' => 'Añada la red a la lista de redes de confianza.',
    'spam_trustednetworks_remove' => 'Elimine la red de la lista de redes de confianza.',


    'i_i_client_on' => 'Cuenta de cliente activa.',
    'i_i_client_off_by_admin' => 'Cuenta de cliente desactivada por el administrador.',


    'b_virtualdir_add_disabled' => 'La creación de directorios virtuales no está disponible.',

    'b_db_add_disabled' => 'La conexión a su servidor de base de datos no está configurada. Puede configurarla en la página Servidor->Base de datos.',

    'b_databases__change_server_passwd_disabled' => "Está usando el servidor interno de bases de datos de Plesk porque ha configurado la conexión con el puerto 8306. Es por este motivo que es necesario cambiar la contraseña en Configuración > Cambiar contraseña.",

    'b_traffic_at_domains' => 'Mostrando estadísticas de tráfico en los dominios del servidor.',
    'traffic_at_domains' => 'Estadísticas de tráfico para todos los dominios registrados en el sistema.',

    'b_rdp_session__open_new' => 'Abra una nueva sesión de terminal.',

    'removeDNS_acl' => 'Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.',

    'i_additional_key_installed' => 'La llave está instalada en la aplicación.',
    'i_additional_key_not_installed' => 'La llave no está instalada en la aplicación.',

    'b_unhandlederror_showinfo' => 'Haga clic para ver información detallada acerca del error.',
    'b_unhandlederror_hideinfo' => 'Haga clic para ocultar la información adicional acerca del error.',
    'b_unhandlederror_submitticket' => 'Haga clic para informar del error al servicio de soporte.',
    'unhandlederror' => 'Error en la operación.',

    'permissions' => 'Establecimiento de permisos de archivo o carpeta.',

    'permissions_advanced' => 'Establecimiento de permisos avanzados de archivo o carpeta.',

    'i_conn_strings_add' => 'Haga clic para añadir la cadena de conexión',
    'i_conn_strings_add_disabled' => 'Adición de cadenas de conexión no disponible.',
    'i_conn_strings_del' => 'Haga clic para eliminar la cadena de conexión.',
    'i_conn_strings_del_disabled' => 'Eliminación de cadenas de conexión no disponible.',

    'dns_acl_remove' => 'Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.',

    'to_interface_management' => "Vuelva a la página de administración de la interfaz.",
    't_locales' => "Haga clic para administrar los idiomas de la interfaz.",
    't_skins' => "Haga clic para administrar skins.",
    't_interface_templates' => "Haga clic para gestionar las plantillas de interfaz.",
    'b_locale_make_default' => "Seleccione un paquete de idioma y haga clic para que sea el paquete de idioma predeterminado.",
    'b_skin_make_default' => "Seleccione un skin y haga clic para establecerlo como predeterminado.",

    'wu_limits_exceeding' => "No puede crear usuarios web porque se ha excedido el número máximo de usuarios web soportados para este dominio.",

    'mail_setenable_off' => 'Esta prestación no es soportada por el servidor de correo.',
    'domain_aliases__status_ok' => 'El alias de dominio funciona correctamente.',

    'i_htype_sub_hst' => 'Subdominio en subcarpeta.',
    'mail_antivirus' => 'Configuración del antivirus.',

    'dom_new_no_clients' => 'Antes de poder añadir dominios, es necesario crear una cuenta de cliente.',

    'dns_t_acl' => 'Configuración de la lista de control de acceso.',

    'dns_t_acl_remove' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",

    'b_sapp_make_default' => "Hacer que la aplicación web seleccionada sea la predeterminada",

    'b_ftp_ctrl' => "Administre cuentas FTP adicionales bajo un dominio.",
    'ftp_ctrl' => "Gestionando cuentas FTP adicionales bajo el dominio.",
    'b_ftp_user_add' => "Haga clic para añadir una cuenta FTP.",
    'b_ftp_users_limit_reached' => "Se ha alcanzado el número máximo de cuentas FTP.",
    'ftp_user_edit' => "Configuración de la cuenta FTP.",
    'ftp_users' => "Administre cuentas FTP adicionales bajo un dominio.",
    'removeFtpUsers' => "Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.",
    'to_ftp_ctrl' => "Vuelva a la página de administración de cuentas FTP.",

    'b_sb_desktop' => "Descripción de las principales funciones de Presence Builder.",
    'b_sb_users' => "Administrar cuentas de usuario registradas en Presence Builder.",
    'b_sb_sites' => "Añadir y administrar distintos tipos de sitios Presence Builder.",
    'b_sb_server' => "Administración de Presence Builder.",
    'b_sb_logs' => "Vea registros de seguridad y sistema de Presence Builder.",

    'dns_recursion' => "Administración de la recursión DNS.",

    'subdom_hst_type_sel' => "Seleccione el tipo de hosting a configurar para el subdominio.",

    'i_wu_open_help' => "Haga clic para abrir la página de usuario web en el navegador.",

    'i_i_client_off_expired' => "El periodo de validez para esta cuenta de cliente ha expirado.",

    'i_antivirus_turn_install' => 'El antivirus no está instalado o no está configurado correctamente.',

    'b_ftp_users_no_permission' => "No tiene permisos para administrar cuentas FTP adicionales.",

    // Plesk 8 keys

    'b_search' => "Busque clientes, dominios y cuentas de correo.",

    // services management
    'b_service_showall' => 'Mostrar todos los servicios.',
    'b_service_hideall' => "Oculte todos los servicios.",
    'b_service_start' => "Inicie los servicios seleccionados.",
    'b_service_stop' => "Detenga los servicios seleccionados.",
    'b_service_restart' => "Reinicie los servicios seleccionados.",
    'b_service_disable' => "Desactive los servicios seleccionados.",
    'b_service_manual' => "Seleccione inicio manual para los servicios seleccionados.",
    'b_service_auto' => "Seleccione el inicio automático para los servicios seleccionados.",
    'i_serv_group_on' => 'Todos los servicios del grupo están en ejecución.',
    'i_serv_group_none' => 'Algunos de los servicios del grupo están desactivados o detenidos.',
    'i_serv_group_off' => 'Todos los servicios del grupo están desactivados o detenidos.',
    'i_serv_key_disabled' => 'Servicio deshabilitado.',

    // php4v5
    'php' => "Vea y edite la configuración PHP para el directorio virtual actual.",
    'php_changeversion' => "Configuración PHP del directorio actual.",
    'php_dom' => "Edite la configuración PHP del dominio.",
    'php_subdom' => "Edite la configuración PHP del subdominio.",
    'php_changeversion_dom' => "Configuración PHP del dominio.",
    'php_changeversion_subdom' => "Configuración PHP del subdominio.",

    // mass mail
    'b_new_mass_mail_template' => 'Añadir una plantilla de mensajes de email masivos',
    'b_massmail_send' => "Enviar email a todos los destinatarios seleccionados",

    // Other
    'b_additional_key_is_install' => 'Instale una llave adicional.',
    'i_domain_sitebuilder_disabled' => "El soporte de Presence Builder está desactivado para este dominio.",
    'i_subdomain_sitebuilder_disabled' => "El soporte de Presence Builder está desactivado para este subdominio.",
    'i_subdomain_sitebuilder_wizard' => "Vaya al asistente de Presence Builder para este subdominio.",
    'i_domain_sitebuilder_wizard' => "Vaya al asistente de Presence Builder para este dominio.",
    'sitebuilder_page' => 'Ahora está trabajando en la ventana de Presence Builder. Para más información, consulte la documentación de Presence Builder.',
    'removeFpseUsers' => 'Seleccione la casilla para confirmar la eliminación y haga clic en ACEPTAR para eliminar. Haga clic en Cancelar para cancelar la eliminación.',
    'b_insert' => 'Haga clic para introducir datos de la plantilla seleccionada al mensaje de email masivo',
    'i_spamfilter_turn_install' => 'El filtro antispam no está instalado.',

    // help desk

    // 8.2

    // other

    'b_db_preferences' => 'Cambiar parámetros de conexión de la base de datos',
    'b_disabled_hosting' => 'Esta prestación no está disponible porque el hosting físico no está configurado',
    'net_apps' => 'Administrar aplicaciones web ASP.NET 1.1',
    'site_apps' => "Administrar aplicaciones web estándar",

    'b_default_cert' => 'Usar el certificado seleccionado para proteger las conexiones a los sitios web nuevos.',
    'b_setup_cp' => 'Usar el certificado seleccionado para proteger las conexiones a Plesk',
    'b_to_actionlog' => 'Vuelva al registro de acciones',

    // 8.3

    'additional_key_update' => 'Estado de recuperación o actualización de la llave adicional',
    'admin_alias_password_update' => 'Confirmar cambio de contraseña',
    'removeTasks' => "Confirme la eliminación de las tareas seleccionadas y haga clic en ACEPTAR",

    'b_license_key_remove' => 'Haga clic para eliminar la llave de licencia.',
    'fi-attach' => 'Indique la cuenta global a la que desea conectarse.',
    'fi-detach' => 'Confirme la desconexión de la cuenta local actual de una cuenta global y haga clic para desconectar.',
    'fi-update' => 'Actualice la configuración de la cuenta global.',

    // 8.4
    // RESELLERS
    'b_resellers' => 'Administrar cuentas de revendedor',
    'i_reseller_on' => "Esta cuenta de usuario está activa.",
    'i_reseller_off_by_parent' => "Esta cuenta de usuario ha sido suspendida por el proveedor de servicios.",
    'i_reseller_off_by_expired' => "El periodo de suscripción para esta cuenta de usuario ha expirado.",
    'i_reseller_off_backup_restore' => "Esta cuenta de usuario ha sido suspendida temporalmente para finalidades de backup o restauración de datos.",
    'i_reseller_ok' => "El uso de recursos del revendedor está dentro de los límites.",
    'i_reseller_cp_access_on' => "El revendedor puede acceder a Plesk.",
    'i_reseller_cp_access_off' => "El revendedor no puede acceder a Plesk.",
    'i_click_to_reseller_cp_access_on_off' => "Haga clic para permitir o prohibir el acceso a Plesk al revendedor.",

    // CLIENTS (upgraded for resellers)

    // 'upgradeclients__submit_update' => 'Click',
    'b_upgradeClients__cancel_upgrade' => 'Descartar cualquier cambio y volver a la página anterior.',
    'b_upgradeClients__submit_upgrade' => 'Haga clic para convertir cuentas de cliente a cuentas de revendedor.',
    'b_upgradeDomainUser__cancel_upgrade' => 'Descartar cualquier cambio y volver a la página anterior.',
    'b_upgradeDomainUser__submit_upgrade' => 'Haga clic para convertir cuentas de administrador de dominio a cuentas de cliente.',

    //APS Catalog
    'b_hide_updates' => "Oculte las actualizaciones.",
    'b_show_updates' => "Muestre las actualizaciones.",
    'b_add_to_vault' => "Añada las aplicaciones seleccionadas al Application Vault.",

    // new and unsorted
    'b_to_server_interface' => "Vuelva a la lista de skins disponibles.",
    'b_skin_edit' => "Edite la descripción de un skin.",
    'b_to_phosting_setup' => "Vuelva a la configuración de hosting.",
    // Hosting setup redesign
    'b_dom_hosting_update' => "Guarde la configuración de hosting.",
    'b_downgradeResellers__submit_downgrade' => "Haga clic para completar la operación.",
    'b_rs_pool_add' => "Asigne direcciones IP al revendedor.",
    'b_cl_pool_add' => "Asigne direcciones IP al cliente.",
    'b_ippoolManager__no_available_ips' => "En el grupo de direcciones IP no existe ninguna dirección IP vacante.",
    'b_ip_already_added_to_all_clients' => "Esta dirección IP ya está presente en los grupos de direcciones IP de todos los usuarios.",

    // SERVER/SETTINGS
    'b_change_hostname_conhelp' => 'Cambie el nombre de host del servidor.',
    'b_setup_firewall_conhelp' => 'Configure el firewall para proteger el servidor.',
    'b_setup_firewall_none_available_conhelp' => 'Funcionalidad firewall no disponible: firewall no instalado.',
    'b_manage_firewall_rules_conhelp' => 'Cree, edite y elimine reglas del firewall.',
    'b_manage_firewall_rules_none_available_conhelp' => 'Funcionalidad firewall no disponible: firewall no instalado.',
    'b_select_dns_server_conhelp' => 'Seleccione el software de servidor DNS que debería utilizar el servidor y ser gestionado por Plesk.',
    'b_select_dns_server_none_available_conhelp' => 'No hay ningún otro servidor DNS disponible.',
    'b_soa_records_template_conhelp' => 'Configure registros SOA que se usarán como plantilla cuando se cree una zona DNS para los dominios.',
    'b_dns_recursion_conhelp' => 'Configure las opciones de recursión DNS que se usarán como plantilla cuando se cree una zona DNS para los dominios.',
    'b_restrict_creation_of_subzones_conhelp' => "Restrinja la creación de subzonas DNS en súper zonas DNS de otros usuarios",
    'b_select_mailserver_conhelp' => 'Seleccione el software de servidor de correo que debería utilizar el servidor y ser gestionado por Plesk.',
    'b_select_mailserver_none_available_conhelp' => 'No hay ningún otro servidor de correo disponible.',
    'b_select_antivirus_conhelp' => 'Seleccione el software antivirus que debería utilizar el servidor y ser gestionado por Plesk.',
    'b_select_antivirus_none_available_conhelp' => 'No hay ningún otro programa antivirus disponible.',
    'b_virus_protection_settings_conhelp' => 'Configure las opciones de la protección antivirus a nivel del servidor.',
    'b_select_spamfilter_conhelp' => 'Seleccione el software de filtración de spam que debería utilizar el servidor y ser gestionado por Plesk.',
    'b_select_spamfilter_none_available_conhelp' => 'No existe ningún otro programa de filtración de spam disponible.',
    'b_select_webmail_conhelp' => 'Seleccione el software de webmail que debería ponerse a disposición de los usuarios de email.',
    'b_select_webmail_none_available_conhelp' => 'No hay disponible ningún otro programa de webmail.',
    'b_server_statistics_settings_conhelp' => 'Seleccione qué debe incluirse en los cálculos de las estadísticas a nivel de servidor.',
    'b_select_ssl_certificate_conhelp' => 'Seleccione el certificado SSL/TLS a usar para proteger su dominio.',
    'b_select_ssl_certificate_none_available_conhelp' => 'Para poder acceder a esta prestación, es necesario disponer de hosting web.',
    'b_select_web_statistics_conhelp' => 'Seleccione el software de estadísticas web que debería estar a disposición de los propietarios de dominio.',
    'b_select_web_statistics_none_available_conhelp' => 'No hay ningún otro programa de estadísticas web disponible.',
    'b_interface_management_conhelp' => 'Configure varias opciones de la interfaz de Plesk.',
    'b_setup_watchdog_conhelp' => 'Configure el módulo de monitorización de servidor Watchdog.',
    'b_setup_watchdog_none_available_conhelp' => 'Módulo Watchdog no instalado.',
    'b_setup_vpn_conhelp' => 'Configure el acceso VPN en el servidor.',
    'b_setup_vpn_none_available_conhelp' => 'La extensión de acceso VPN no está instalada.',
    'b_setup_samba_conhelp' => 'Configure el acceso a Samba en el servidor.',
    'b_setup_samba_none_available_conhelp' => 'La extensión de acceso Samba no está instalada.',

    // DOMAIN/SETTINGS
    'b_account_settings_conhelp' => 'Vea y cambie la configuración de su cuenta.',
    'b_dns_soa_records_conhelp' => 'Vea y edite los registros SOA del DNS para su dominio.',
    'b_task_scheduler_settings_conhelp' => 'Configure el programador de tareas para su dominio.',
    'b_task_scheduler_settings_none_available_conhelp' => 'Para poder acceder a esta prestación, es necesario disponer de hosting web.',
    'b_web_users_scripting_conhelp' => 'Permita o prohíba el uso de scripts a usuarios web.',
    'b_web_statistics_conhelp' => 'Vea las estadísticas de visitas para su dominio.',
    'b_log_rotation_settings_conhelp' => 'Configure la rotación de registros en su dominio.',

    // navbar
    'b_mailnames' => 'Vaya a la lista de cuentas de correo.',
    'b_applications' => 'Vaya a la lista de aplicaciones web.',
    'b_settings' => 'Configure múltiples parámetros.',

    // templates
    'i_tmpl__shared_template' => 'Esta plantilla ha sido creada por su proveedor de hosting. Usted puede usarla, ya que su proveedor de hosting está compartiéndola.',
    'i_tmpl__owned_template' => 'Esta plantilla ha sido creada por usted. Esta puede ser usada por usted y sus usuarios, si así lo permite.',

    'b_load' => 'Cargue el mensaje de la plantilla guardada anteriormente.',

    'b_sh_ip_add' => 'Añadir dirección IP a la lista de direcciones IP compartidas',
    'b_sh_ip_del' => 'Eliminar dirección IP de la lista de direcciones IP compartidas',
];