<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Podsieć albo adres IP',
    'access-network.subnetOrIpAddressHint' => 'Na przykład, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newslettery',
    'admin.announcement-settings.getConsentLoading' => 'Pobieranie informacji o newsletterach...',
    'admin.announcement-settings.getConsentWarning' => 'Nie można pobrać statusu subskrypcji.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Chciałbym otrzymywać newslettery od firmy WebPros. Mogą zawierać informacje dotyczące bezpieczeństwa, techniczne i ogólne informacje o produkcie. Wyrażam zgodę i udzielam jej firmie WebPros na zbieranie, przetwarzanie i wykorzystywanie moich danych osobowych (e-mail), w tym przetwarzanie transgraniczne, zgodnie z obowiązującymi przepisami o ochronie danych, które obowiązują obecnie w zakresie przesyłania mi biuletynów bezpośrednio lub za pośrednictwem usługi zewnętrznej. Usunięcie zaznaczenia tego pola wyboru powoduje odebranie mojej zgody i nakazuje firmie WebPros zaprzestanie wysyłania mi e-maili i trwałe usunięcie moich danych osobowych z systemów.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Wymienione tutaj firmy WebPros mogą wykorzystywać moje imię i nazwisko oraz adres e-mail (%%adminEmail%%) w celu dostarczania mi spersonalizowanych treści marketingowych, takich jak biuletyny i indywidualne oferty związane z produktami WebPros. Firmy proszące o zgodę to: WebPros International LLC i WebPros International GmbH. Informacje będą wykorzystywane zgodnie z %%privacyPolicy%% do czasu wycofania mojej zgody i mogą być udostępniane wewnętrznie innym podmiotom z grupy WebPros. Mogę zmodyfikować lub wycofać moją zgodę w dowolnym momencie, odznaczając pole wyboru, klikając łącze w otrzymanej korespondencji lub wysyłając wiadomość e-mail na adres privacy@plesk.com',
    'admin.announcement-settings.privacyPolicy' => 'Polityka prywatności WebPros',
    'admin.announcement-settings.noConsent' => 'Zrezygnuj z subskrypcji biuletynu WebPros.',
    'admin.announcement-settings.reportConsentError' => 'Nie można zapisać ustawień związanych z pobieraniem informacji z Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Niestety nie możemy obecnie zaktualizować Twojego profilu. Spróbuj ponownie później.',
    'admin.announcement-settings.invalidConsentType' => "Nieznany typ zgody: '%%type%%'",
    'admin.announcement-settings.retry' => 'Potwórz',
    'admin.announcement-settings.consentGivenInfo' => 'Mamy nadzieję, że podobał Ci się nasz ogólny biuletyn WebPros. Możemy teraz zaoferować ulepszoną alternatywę – wersję spersonalizowaną z przydatnymi informacjami i wskazówkami, dostosowaną do Twoich potrzeb. Aby otrzymać spersonalizowany biuletyn WebPros, wybierz pierwsze oświadczenie poniżej i kliknij OK.',

    'admin.personal-info.title' => 'Edytuj informacje o administratorze',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Ustawienia Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Ustawienia',

    'admin-alias.login' => 'Nazwa użytkownika',
    'admin-alias.password' => 'Hasło',
    'admin-alias.passwordConfirmation' => 'Potwierdź hasło',
    'admin-alias.email' => 'E-mail',
    'admin-alias.contact' => 'Kontakt',
    'admin-alias.comments' => 'Komentarze',
    'admin-alias.emptyLogin' => 'Podaj nazwę użytkownika.',
    'admin-alias.loginTooLong' => 'Długość nazwy użytkownika przekracza 20 znaków.',
    'admin-alias.emptyEmail' => 'Proszę podać adres e-mail.',
    'admin-alias.emptyContactName' => 'Proszę podać dane kontaktowe.',
    'admin-alias.contactNameTooLong' => 'Długość nazwy osoby do kontaktu przekracza 255 znaków.',
    'admin-alias.emptyPassword' => 'Proszę podać hasło.',
    'admin-alias.commentsTooLong' => 'Długość komentarza przekracza 255 znaków.',
    'admin-alias.emailActivation' => 'Aktywuj konto przez e-mail',
    'admin-alias.simplePanel' => 'Włącz tryb ograniczonego dostępu',
    'admin-alias.simplePanelHint' => 'Wybierz tę opcję, aby ograniczyć liczbę działań, które może podjąć dodatkowy administrator w systemie Plesk. Aby zmienić, które akcje są dostępne, przejdź do %%link%%.',
    'admin-alias.simplePanelLink' => 'Narzędzia i ustawienia> Ustawienia trybu ograniczonego',
    'admin-alias.lockPowerUser' => 'Wymuś wyświetlenie trybu zaawansowanego dla dodatkowego administratora',
    'admin-alias.lockPowerUserHint' => 'Możliwość ograniczenia widoku dla dodatkowego administratora Plesk (brak dostępu do klientów, sprzedawców i planów usługowych).',

    'admin-info.plesk-settings.multiplyLogin' => 'Zezwalaj na wiele sesji dla tego konta',
    'admin-info.plesk-settings.adminLanguage' => 'Język interfejsu administratora',
    'admin-info.plesk-settings.password' => 'Hasło',
    'admin-info.plesk-settings.passwordConfirmation' => 'Potwierdź hasło',
    'admin-info.plesk-settings.oldPassword' => 'Stare hasło',
    'admin-info.plesk-settings.oldPasswordIsIncorrect' => 'Stare hasło jest niepoprawne. Proszę spróbować ponownie.',

    'admin-panel.form.contact-info.login' => 'Login',
    'admin-panel.form.contact-info.contactName' => 'Kontakt',
    'admin-panel.form.contact-info.emptyLogin' => 'Proszę podać login.',
    'admin-panel.form.contact-info.emptyContactName' => 'Proszę podać dane kontaktowe.',
    'admin-panel.form.contact-info.loginTooLong' => 'Login jest za długi (dozwolona maksymalna liczba symboli to: %max%).',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Kontakt jest zbyt długi (maksymalnie %max% znaków).',
    'admin-panel.form.contact-info.email' => 'Adres e-mail',
    'admin-panel.form.contact-info.emptyEmail' => 'Proszę podać adres e-mail.',
    'admin-panel.form.contact-info.companyName' => 'Nazwa firmy',
    'admin-panel.form.contact-info.longCompanyName' => 'Podana nazwa firmy jest zbyt długa (maksymalnie %max% znaków).',
    'admin-panel.form.contact-info.phone' => 'Numer telefonu',
    'admin-panel.form.contact-info.longPhone' => 'Podany numer telefonu jest zbyt długi (maksymalnie %max%znaków).',
    'admin-panel.form.contact-info.fax' => 'Numer faksu',
    'admin-panel.form.contact-info.imNumber' => 'Komunikator',
    'admin-panel.form.contact-info.longFax' => 'Podany numer faksu jest zbyt długi (maksymalnie %max%znaków).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Podany numer telefonu jest niepoprawny.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Podany numer faksu jest niepoprawny.',
    'admin-panel.form.contact-info.address' => 'Adres',
    'admin-panel.form.contact-info.longAddress' => 'Podany adres jest zbyt długi (maksymalnie %max% znaków).',
    'admin-panel.form.contact-info.city' => 'Miasto',
    'admin-panel.form.contact-info.longCity' => 'Nazwa miasta jest zbyt długa.',
    'admin-panel.form.contact-info.shortCity' => 'Nazwa miasta jest za krótka.',
    'admin-panel.form.contact-info.state' => 'Województwo',
    'admin-panel.form.contact-info.postalCode' => 'Kod pocztowy',
    'admin-panel.form.contact-info.country' => 'Kraj',
    'admin-panel.form.contact-info.additionalInfo' => 'Informacje dodatkowe',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Tylko zwykły tekst: wszystkie tagi HTML będą ignorowane.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Użytkownik o takim adresie e-mail już istnieje.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Subskrypcja',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Właściwości strony WWW są zapewnione przez subskrypcję.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Właściwości strony WWW są zapewnione przez subskrypcję.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Właściwości strony WWW są zapewnione przez subskrypcję.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Utwórz subskrypcję dla klienta',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Odznacz zaznaczenia, jeśli w tej chwili nie chcesz utworzyć subskrypcji usługi hostingowej lub wprowadzać ustawień dla klienta. Bez subskrypcji klient nie będzie mógł zalogować się w Panelu klienta.',
    'admin-panel.form.domain-info-section.domainName' => 'Nazwa domeny',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Musisz podać nazwę domeny.',
    'admin-panel.form.domain-info-section.shared' => 'współdzielony',
    'admin-panel.form.domain-info-section.exclusive' => 'dedykowany',
    'admin-panel.form.domain-info-section.userName' => 'Nazwa użytkownika',
    'admin-panel.form.domain-info-section.userNameHint' => 'Konto użytkownika systemu wykorzystywane do zarządzania plikami i folderami stron WWW stworzonych w ramach tej subskrypcji.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Musisz podać nazwę użytkownika.',
    'admin-panel.form.domain-info-section.password' => 'Hasło',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Musisz podać hasło.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Potwierdź hasło',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "Adres IP, na którym hostowana jest strona jest adresem sieciowym wirtualnego hosta strony.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Adres Ipv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "Adres IP, na którym hostowana jest strona jest adresem sieciowym wirtualnego hosta strony.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Adres IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Żaden',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Dodatkowe ustawienia subskrypcji',
    'admin-panel.form.domain-info-section.credentials' => 'Dane dostępowe użytkownika',
    'admin-panel.form.domain-info-section.credentialsHint' => 'aby uzyskać dostęp do hostowanych plików przez FTP i SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'aby uzyskać dostęp do hostowanych plików przez FTP i RDP',

    'admin-panel.form.login-info.userName' => 'Nazwa użytkownika',
    'admin-panel.form.login-info.emptyUserName' => 'Podaj nazwę użytkownika.',
    'admin-panel.form.login-info.password' => 'Hasło',
    'admin-panel.form.login-info.emptyPassword' => 'Proszę podać hasło.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Powtórz hasło',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Zmiana hasła spowoduje również zmianę hasła wewnętrznego adresu e-mail',
    'admin-panel.form.login-info.emailActivation' => 'Aktywuj konto przez e-mail',
    'admin-panel.form.login-info.emailActivationHint' => 'Utworzone konto jest nieaktywne do momentu aktywowania przez użytkownika linkiem wysłanym pocztą e-mail lub kiedy administrator aktywuje konto ręcznie.',

    'admin-panel.form.subscription-info-section.subscription' => 'Subskrypcja',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Plan usługi',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Obecny plan usługi',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Nowy plan usługi',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Prosty plan',
    'admin-panel.form.subscription-info-section.none' => 'Żaden',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Dodatki',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Kontynuuj personalizowanie parametrów subskrypcji po zmianie powiązanego planu. Uwaga - ta czynność uniemożliwi synchronizację subskrypcji.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Przejdź do dostosowywania parametrów subskrypcji po jej utworzeniu.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Przejdź do dostosowywania parametrów subskrypcji po utworzeniu klienta.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Kontynuuj personalizowanie parametrów subskrypcji po jej stworzeniu. Uwaga - ta czynność uniemożliwi synchronizację subskrypcji.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Pamiętaj, że wykonanie tej czynności spowoduje zablokowanie subskrypcji na potrzeby synchronizacji.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Dodaj subskrypcję',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Nie można zsynchronizować subskrypcji z planem usługi. Następujące ustawienia subskrypcji są w konflikcie z planem usługi: %%problems%%.',

    'app.configure.otherSettings' => 'Inne',
    'app.configure.passwordConfirmation' => 'Potwierdź hasło',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Wymuś aktualizacje dla wszystkich zainstalowanych aplikacji',
    'app.update-settings.forceUpdatesHint' => 'Wszyscy klienci aplikacji otrzymają automatyczne powiadomienia, jak tylko aplikacje bedą dostępne. Klienci nie bedą mogli włączyc automatycznych aplikacji dla swoich aplikacji. Ostrzeżenie: Korzystaj z tej opcji ostrożnie, ponieważ aktualizacja mogą znacząco wpłynąć na funkcjonalność aplikacji. Na przykład, rozszerzenia aplikacji mogą przestać działać z inną wersją aplikacji.',
    'app.update-settings.suggestUpdates' => 'Włącz domyślnie opcję "Automatycznie aktualizuj tę aplikację"',
    'app.update-settings.suggestUpdatesHint' => 'Dla nowozainstalowanych aplikacji, opcja "Automatycznie aktualizuj tę aplikację" będzie włączona.',

    'backup.server-settings.rotation' => 'Maksymalna liczba przechowywanych plików kopii zapasowych (łącznie z zaplanowanymi i ręcznymi kopiami zapasowymi)',
    'backup.server-settings.rotationDescription' => 'Użytkownicy mogą przechowywać tyle pełnych kopii zapasowych w pamięci serwera. Jeśli liczba pełnych kopii zapasowych znajdujących się już w pamięci przekracza limit, zachowywane są tylko najnowsze kopie zapasowe. Nie ma to wpływu na przyrostowe kopie zapasowe.',
    'backup.server-settings.maxProcesses' => 'Maksymalna liczba zaplanowanych równoległych procesów kopii zapasowej',
    'backup.server-settings.niceScheduled' => 'Uruchom z niskim priorytetem zaplanowany proces archiwizacji',
    'backup.server-settings.niceScheduledPriority' => 'Priorytet',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Wprowadź wartość od 1 do 19 włącznie, przy czym wyższa liczba ma niższy priorytet.',
    'backup.server-settings.niceScheduledIoPriority' => 'Priorytet operacji IO',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Wprowadź wartość od 0 do 7 włącznie, przy czym wyższa liczba ma niższy priorytet.',
    'backup.server-settings.niceAlways' => 'Uruchom wszystkie procesy wykonywania kopii zapasowych z niskim priorytetem',
    'backup.server-settings.niceAlwaysPriority' => 'Priorytet',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Wprowadź wartość od 1 do 19 włącznie, przy czym wyższa liczba ma niższy priorytet.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Priorytet operacji IO',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Wprowadź wartość od 0 do 7 włącznie, przy czym wyższa liczba ma niższy priorytet.',
    'backup.server-settings.compressionLevel' => 'Poziom kompresji',
    'backup.server-settings.compressionLevelNoCompression' => 'Brak kompresji',
    'backup.server-settings.compressionLevelFastest' => 'Najszybsza',
    'backup.server-settings.compressionLevelFast' => 'Szybki',
    'backup.server-settings.compressionLevelNormal' => 'Normalny',
    'backup.server-settings.compressionLevelMaximum' => 'Maksymalna',
    'backup.server-settings.freeSpaceRequired' => 'Rozpocznij tworzenie kopii zapasowej tylko jeśli serwer ma określoną ilość wolnej przestrzeni dyskowej (w megabajtach)',
    'backup.server-settings.checkBackupDiskSpace' => 'Uruchom kopię zapasową tylko wtedy, gdy serwer ma wystarczającą ilość wolnego miejsca na dysku',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Użyj oryginalnegej funkcjonalności kopii zapasowej MS SQL (Dla zdalnych baz danych upewnij się, że skonfigurowane są ustawienia kopii zapasowej zdalnego serwera MS SQL w Narzędzia i ustawienia >  Serwer baz danych)',
    'backup.server-settings.localFtpRestriction' => 'Zezwalaj na konfigurację przechowywania kopii zapasowych FTP na serwerze lokalnym',
    'backup.server-settings.backupSecuritySettings' => 'Ustawienia zabezpieczeń kopii zapasowej',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Zapisz kopie zapasowe w pamięci serwera, jeśli przesyłanie do zasobu zdalnego nie powiedzie się',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Ręczne i zaplanowane kopie zapasowe przeznaczone do wysłania na zdalny zasób zostaną zapisane w lokalnej pamięci serwera, jeśli przesyłanie do zasobu zdalnego nie powiedzie się. Użytkownicy muszą mieć pozwolenie na przechowywanie kopii zapasowych w przechowalni serwera.',
    'backup.server-settings.AllowScheduleHourly' => 'Pozwól klientom i sprzedawcom planować godzinne kopie zapasowe',

    'change-current-subscription.hint' => 'Tutaj zmień plan usługi związany z subskrypcją. Wybranie \'żaden\' jako planu usługi rozdziela subskrypcję od planu usługi i czyni go \'Spersonalizowany\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Nie można zsynchronizować subskrypcji z planem usługi. Następujące ustawienia subskrypcji są w konflikcie z planem usługi: %%problems%%.',

    'change-password.oldPassword' => 'Stare hasło',
    'change-password.password' => 'Nowe hasło',
    'change-password.passwordConfirmation' => 'Potwierdź hasło',
    'change-password.oldPasswordIsIncorrect' => 'Stare hasło jest niepoprawne. Proszę spróbować ponownie.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Nie udało się znaleźć dodatkowego konta administratora.',
    'change-password.warningAboutAdminPasswordSyntax' => "Hasło powinno mieć długość %%min%% - %%max%% znaków i nie powinno zawierać nazwy użytkownika.\nNie używaj cudzysłowu, spacji, średników oraz narodowych znaków alfabetu w haśle.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Nie używaj cudzysłowu, spacji, średników oraz narodowych znaków alfabetu w haśle.\nHasło powinno mieć długość %%min%% - %%max%% znaków i nie powinno zawierać nazwy użytkownika.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Polityka sprzedaży ponad posiadany zapas',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Sprzedaż ponad posiadany zapas jest dozwolona',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Sprzedaż ponad posiadany zapas pozwala sprzedawcy na sprzedaż większej ilości zasobów niż te przyznane zgodnie z planem. Jeżeli sprzedaż ponad posiadany zapas jest dozwolona, sprzedawca powinien kierować się rzeczywistym wykorzystaniem zasobów, a nie ilością zasobów przyznaną na początku.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Sprzedaż ponad posiadany zapas jest zabroniona',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Jeżeli sprzedaż ponad posiadany zapas jest zabroniona, sprzedawca może sprzedać tylko tyle zasobów, ile przyznano mu na początku, bez względu na rzeczywiste wykorzystanie zasobów.',

    'change-reseller-subscription.hint' => 'Tutaj można zmienić plan usługi przypisany do subskrypcji sprzedawcy. Wybranie \'żaden\' jako planu usługi rozdziela subskrypcję od planu usługi i czyni go \'Spersonalizowany\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Nie można zsynchronizować subskrypcji z planem usługi. Następujące ustawienia subskrypcji są w konflikcie z planem usługi: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Nowy plan usługi',
    'change-reseller-subscription.oldSubscription' => 'Obecny plan usługi',
    'change-reseller-subscription.none' => 'Żaden',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Zaktualizowano przypisanie planu usługi do subskrypcji.',
    'change-reseller-subscription.customizeSubscription' => 'Kontynuuj dostosowywanie parametrów subskrypcji po aktualizacji przypisanego jej planu. Uwaga - ta czynność uniemożliwi synchronizację subskrypcji.',

    'change-subscription.hint' => 'Tutaj można zmienić plan usługi przypisany do wybranych subskrypcji.',
    'change-subscription.selectPlanLegend' => 'Plan usługi',
    'change-subscription.selectPlanDescription' => 'Aby zmienić plan usługi na inny, wybierz nowy plan z listy. Wybranie \'żaden\' jako planu usługi rozdziela subskrypcję od planu usługi i czyni go \'Spersonalizowany\'.',
    'change-subscription.servicePlan' => 'Nowy plan usługi',
    'change-subscription.selectAddonPlansLegend' => 'Dodatkowe plany',
    'change-subscription.selectAddonPlansDescription' => 'Dodaj lub usuń dodatkowe plany.',
    'change-subscription.noChange' => 'bez zmian',
    'change-subscription.none' => 'Żaden',
    'change-subscription.add' => 'dodaj',
    'change-subscription.del' => 'usuń',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Podsieć albo adres IP',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Na przykład, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Dostęp do Plesku kontrolnego z uprawnieniami administratora',
    'control-panel-access.settings.policyAllow' => 'Dozwolony, wyłączając sieci zawarte na liście.',
    'control-panel-access.settings.policyDeny' => 'Zabroniony z sieci nie występujących na liście.',

    'create-subscription.title' => 'Dodawanie subskrypcji',
    'create-subscription.titleOwn' => 'Dodawanie twojej nowej subskrypcji',
    'create-subscription.poolIsEmpty' => 'Nie można utworzyć subskrypcji, ponieważ w Plesku nie ma współużytkowanych adresów IP i żadnych wolnych dedykowanych adresów IP.',
    'create-subscription.infoNewSubscriptionCreated' => 'Subskrypcja %%name%% została utworzona.',
    'create-subscription.createBeforeAppInstall' => 'Musisz mieć subskrypcję, aby zainstalować aplikację.',

    'customer.hint' => 'Tutaj można przypisać nowego klienta do usług hostingowych. Przypisując klienta, tworzysz konto klienta w Plesku oraz subskrypcję jednego z twoich planów i, opcjonalnie, dodatki. Subskrypcja może również obejmować zestaw całkowicie spersonalizowanych zasobów i usług niezwiązanych z żadnym planem - dla tej opcji wybierz \'żaden\' w zakładce Plan usługi.',
    'customer.contactInfoSection' => 'Dane kontaktowe',
    'customer.additionalInfoSection' => 'Dodatkowe informacje o kliencie',
    'customer.accessToPanelSection' => 'Dostęp do Pleska',
    'customer.contactInfoSectionHint' => 'Wpisz informacje o kontakcie do klienta.',
    'customer.accessToPanelSectionHint' => 'Dane dostępowe używane przez klienta do Panelu klienta.',
    'customer.unableCreateSubscription' => 'Subskrypcja nie może być utworzona: %%reason%%',
    'customer.poolIsEmpty' => 'Pula adresów IP jest pusta',
    'customer.buttonOk' => 'Dodaj klienta',

    'database-settings.dbPrefixRadio' => 'Dodaj prefiks użytkownika i podkreślenie na początek nazw baz danych',
    'database-settings.dbPrefixNone' => 'Żaden',
    'database-settings.dbPrefixUsername' => 'Nazwa użytkownika',
    'database-settings.dbPrefixExternalId' => 'Zewnętrzne ID subskrypcji',
    'database-settings.dbPrefixCustom' => 'Dedykowany prefiks',
    'database-settings.dbUserPrefixRadio' => 'Dodaj prefiks i podkreślenie na początku nazw użytkowników bazy danych',
    'database-settings.dbUserPrefixHint' => 'Nazwy użytkowników bazy danych będą wyglądać jak <prefix>_<database_user_name>. Ze względu na ograniczenia bazy danych dotyczące długości nazwy użytkownika, <prefiks> może być skrócony.',
    'database-settings.grantAlterDatabase' => 'Nadaj uprawnienie ZMIEŃ BAZĘ DANYCH wszystkim użytkownikom bazy danych serwera Microsoft SQL',
    'database-settings.grantAlterDatabaseHint' => 'Nowi i istniejący użytkownicy otrzymają to uprawnienie.',
    'database-settings.aclRadio' => 'Domyślne ustawienia zdalnego dostępu użytkowników bazy danych MariaDB/MySQL',
    'database-settings.aclLocalhost' => 'Zezwalaj tylko na lokalne połaczenia',
    'database-settings.aclAny' => 'Zezwalaj na zdalne połączenia od każdego hosta',
    'database-settings.aclCustom' => 'Zezwalaj na zdalne połaczenia od',
    'database-settings.aclDescription' => 'To ustawienie modyfikuje tylko uprawnienia użytkowników. Aby umożliwić zdalny dostęp do lokalnego serwera MariaDB/MySQL, wybierz odpowiednią opcję w %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Lokalne ustawienia MariaDB/MySQL',
    'database-settings.example' => "Na przykład:",
    'database-settings.aclExampleDescription' => "Określone hosty mogą uzyskiwać dostęp do bazy danych w imieniu tego użytkownika.",
    'database-settings.dbPrefixAlphaNumeric' => 'Prefiks może zawierać tylko wartości alfanumeryczne i podkreślenie.',

    'dns.add-acl-record.description' => 'Dodaj adres IP serwera DNS, który może otrzymac kopię strefy DNS.',
    'dns.add-acl-record.ipAddress' => 'Adres IP',
    'dns.add-acl-record.ipAddressWithMask' => 'Adres IP/maska',

    'dns.settings.recursion' => 'Rekurencyjne zapytania DNS',
    'dns.settings.recursionOn' => 'Zezwól na wszystkie połączenia',
    'dns.settings.recursionLocal' => 'Zezwól tylko na połączenia lokalne',
    'dns.settings.recursionLocalnets' => 'Zezwalaj tylko na żądania z sieci lokalnej',
    'dns.settings.recursionOff' => 'Odmów dla wszystkich próśb',
    'dns.settings.customConfiguration' => 'Dodatkowe ustawienia DNS',
    'dns.settings.customConfigurationPlaceholder' => 'Ustawienia, które tutaj określisz, zastąpią ustawienia dla całego serwera.',
    'dns.settings.customConfigurationHint' => 'Jeśli nie możesz znaleźć konkretnych ustawień, dodaj je do powyższego pola, używając składni named.conf.',
    'dns.settings.customConfigurationExample' => 'Na przykład, aby ukryć nazwę hosta serwera DNS, dodaj następujący wiersz: ',
    'dns.settings.restoreDefaultButton' => 'Użyj ustawień domyślnych',

    'dns.template.synchronize-done' => 'Szablon strefy DNS został zastosowany.',
    'dns.template.synchronize-error' => 'Szablon strefy DNS nie został zastosowany do niektórych stref DNS.',
    'dns.template.synchronize-progress' => 'Zastosowywanie szablonu DNS.',

    'domain-restriction.name' => 'Nazwa domeny',
    'domain-restriction.nameDescription' => 'Możesz podać wieloznaczny wzór, używając znaku asterisk (*). Przykład, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'Podana nazwa domeny jest już na liście.',

    'event-handler.eventLabel' => 'Zdarzenie',
    'event-handler.priorityLabel' => 'Priorytet',
    'event-handler.userLabel' => 'Użytkownik',
    'event-handler.commandLabel' => 'Komenda',
    'event-handler.commandHint' => 'Dla najlepszych rezultatów wpisz pełną ścieżkę do pliku skryptu w polu \'command\'. Nie zalecamy wpisywania komend systemowych, ponieważ mogą nie działać. Na przykład komendy z operatorami przekierowania informacji wychodzących  > or < nie będa działały.',
    'event-handler.priorityHighestText' => 'najwyższy',
    'event-handler.priorityHighText' => 'wysoki',
    'event-handler.priorityNormalText' => 'normalny',
    'event-handler.priorityLowText' => 'niski',
    'event-handler.priorityLowestText' => 'najniższy',
    'event-handler.priorityCustomText' => 'personalizownay',
    'event-handler.priorityHighestOption' => 'najwyższy (%%value%%)',
    'event-handler.priorityHighOption' => 'wysoki (%%value%%)',
    'event-handler.priorityNormalOption' => 'normalny (%%value%%)',
    'event-handler.priorityLowOption' => 'niski (%%value%%)',
    'event-handler.priorityLowestOption' => 'najniższy (%%value%%)',

    'extension.upload.fileUpload' => 'Ścieżka do pliku pakietu rozszerzeń',

    'external-webmail.hint' => 'Po zarejestrowaniu dodatkowego klienta poczty online w Panelu klienta, stanie się on dostępny dla klientów; pojawi się jako opcja w właściwościach \'Poczty\' planu hostingowego i subskrypcji. Nazwa klienta poczty online będzie wyświetlana na liście opcji klienta poczty online, a URL będzie otwierane po kliknięciu ikony klienta poczty online obok skrzynki pocztowej w Panelu klienta.',
    'external-webmail.name' => 'Nazwa klienta poczty online',
    'external-webmail.url' => 'URL klienta poczty online',
    'external-webmail.enabled' => 'Dostępne',

    'ftp-settings.generalSection' => 'Ogólny',
    'ftp-settings.portRange' => 'Port lub zakres portów dla połączeń pasywnego FTP',
    'ftp-settings.hintPortRange' => '(wartość domyślna: %%defaultPortRange%%)',

    'health.upload.hint' => 'Wgraj konfigurację monitorowania statusu serwera. Zostanie ona zastosowana zaraz po wgraniu.',
    'health.upload.selectFile' => 'Plik konfiguracyjny',

    'install-local-package.selectUploadType' => 'Wybierz jeden z poniższych:',
    'install-local-package.uploadAsFile' => 'Wgraj pakiet APS',
    'install-local-package.downloadFromCatalog' => 'Wybierz aplikację z Katalogu aplikacji',
    'install-local-package.formInfo' => "Rozszerz listę dostępnych aplikacji poprzez wgranie nowej aplikacji lub dodaj aplikację z katalogu aplikacji do dalszej konfiguracji.",
    'install-local-package.invalidFileExtension' => 'Wgrywana aplikacja musi być archiwum ZIP z rozszerzeniem .zip.',
    'install-local-package.packagesNotSelected' => 'Nie wybrano żadnego pakietu.',
    'install-local-package.visible' => 'Udostępnij klientom',
    'install-local-package.isCommercial' => 'To jest komercyjna aplikacja i wymaga zakupu klucza licencyjnego.',
    'install-local-package.visibleDescription' => 'Udostępnij klientom aplikację do instalacji.',

    'ip-address.addTitle' => 'Dodaj adres IP',
    'ip-address.editTitle' => 'Adres IP %%address%% na interfejsie %%interface%%',
    'ip-address.generalSection' => 'Ogólny',
    'ip-address.interface' => 'Interfejs',
    'ip-address.addressAndSubnetPrefixLength' => 'Adres IP i Maska podsieci',
    'ip-address.addressHintIPv4' => 'Na przykład: 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Na przykład, 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Publiczny adres IP',
    'ip-address.hintPublicIp' => 'Możesz użyć publicznego adresu IP, jeśli twój serwer Plesk znajduje się za NAT-em',
    'ip-address.distributionType' => 'Adres IP jest dystrybuowany jako',
    'ip-address.distributionTypeShared' => 'Współdzielony',
    'ip-address.distributionTypeExclusive' => 'Dedykowany',
    'ip-address.certificate' => 'Certyfikat SSL/TLS',
    'ip-address.defaultSite' => 'Strona domyślna',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Zainstalowany serwer FTP nie obsługuje FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Zainstalowany serwer FTP nie obsługuje adresów IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'Nie można dodać adresu IP. Ten interfejs sieciowy uzyskuje adresy IP automatycznie.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Uwaga: Niestandardowy URL Plesk jest włączony dla wszystkich nieznanych domen; interfejs Plesk będzie wyświetlany zamiast domyślnej witryny pod adresem "https://%%ip%%/"',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'Adapter sieciowy %%interface%% nie istnieje. Przenieś ten adres IP do innego adaptera lub usuń go z listy.',
    'ip-address.none' => 'Żaden',

    'ip-ban.filter.name' => 'Nazwa',
    'ip-ban.filter.content' => 'Zawartość',
    'ip-ban.filter.filterExistsError' => 'Filtr o takiej nazwie już istnieje.',

    'ip-ban.jail.name' => 'Nazwa',
    'ip-ban.jail.filter' => 'Filtruj',
    'ip-ban.jail.filterDescription' => 'Wybierz filtr.',
    'ip-ban.jail.action' => 'Operacja',
    'ip-ban.jail.actionDescription' => 'Wybierz działanie i kliknij przycisk, by je dodać.',
    'ip-ban.jail.logPath' => 'Ścieżka logu',
    'ip-ban.jail.banTime' => 'Okres blokady adresu IP',
    'ip-ban.jail.maxRetry' => 'Maksymalna liczba nieudanych logowań',
    'ip-ban.jail.timeUnit' => 'sekundy',
    'ip-ban.jail.addAction' => 'Dodaj',
    'ip-ban.jail.chooseAction' => 'Wybierz:',
    'ip-ban.jail.apache-auth-filter-description' => 'Błędy podczas autoryzacji serwera Apache (przy logowaniu do pliku)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Błędy podczas autoryzacji serwera Apache (dowolne logowanie)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Błędy podczas autoryzacji serwera Apache (przy logowaniu do logów systemowych)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Boty spamowe i złośliwe roboty sieciowe',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Autentykacja courier IMAP i POP3 nie udała się',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Nieudana autentykacja serwerów Dovecot IMAP, POP3 i Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Błąd podczas autentykacji Dovecot IMAP, POP3 oraz Sieve (tryb agresywny)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Nieudana autentykacja poczty Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Bezpieczeństwo zapory sieciowej (ModSecurity) i naruszenia kontroli dostępu',
    'ip-ban.jail.plesk-panel-filter-description' => 'Nieudane autentykacje Pleska',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Nieudana autentykacja SMTP QMail',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Nieudana autentykacja poczty Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Błędy uwierzytelniania WordPress',
    'ip-ban.jail.plesk-manual-filter-description' => 'Atrapa filtra do ręcznego blokowania',
    'ip-ban.jail.postfix-filter-description' => 'Błędy serwera Postfix SMTP (w tym RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Błędy klientów Postfix SMTP, awarie uwierzytelniania i ataki DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Nieudane autentykacje postfiksu SMTP i SASL',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Ataki DDoS na Postfix SMTP',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Błędy i awarie serwera SMTP Postfix',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Błędy serwera Postfix SMTP (w tym RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Błędy klienta SMTP Postfix (tylko RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Nieudane logowanie do ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Hosty stale blokowane przez Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Nieudane logowanie SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Błędne logowania SSH, niepowodzenia negocjacji i ataki DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Błędne logowania SSH i ataki DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Logowanie SSH i niepowodzenie negocjacji',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Blokada przez zaporę firewalld na wszystkich portach',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Blokada przez zaporę firewalld na wielu portach',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Blokada przez zaporę firewalld na jednym porcie',
    'ip-ban.jail.iptables-action-description' => 'Zabroń poprzez zaporę ogniową iptables, na pojedyńczym porcie',
    'ip-ban.jail.iptables-allports-action-description' => 'Zabroń poprzez zaporę ogniową iptables, na wszystkich portach',
    'ip-ban.jail.iptables-multiport-action-description' => 'Zabroń poprzez zaporę ogniową iptables, na wielu portach',
    'ip-ban.jail.sendmail-action-description' => 'Wyślij powiadomienie e-mail przez Sendmail',
    'ip-ban.jail.jailExistsError' => 'Jail o takiej nazwie już istnieje.',
    'ip-ban.jail.invalidInteger' => 'Określona wartość jest nieprawidłowa. Podaj liczbę.',

    'ip-ban.settings.pageHint' => 'Tutaj możesz blokady adresów IP, chroniąc w ten sposób serwer i hostowane serwery przed złośliwym ruchem.',
    'ip-ban.settings.detectionEnabled' => 'Odblokuj wykrywanie intruzów',
    'ip-ban.settings.banPeriod' => 'Okres blokady adresu IP',
    'ip-ban.settings.banTimeWindow' => 'Interwał wykrywania następujących po sobie ataków',
    'ip-ban.settings.maxRetries' => 'Liczba nieudanych operacji, zanim adres IP został zablokowany',
    'ip-ban.settings.timeUnit' => 'sekundy',
    'ip-ban.settings.invalidInteger' => 'Wpisano niepoprawną wartość. Wpisz liczbę dodatnią.',

    'ip-ban.trusted-ip.ipAddress' => 'Adres IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'Adres IP, maska ​​CIDR lub nazwa hosta DNS.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Opis',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Wyjaśnienie, dlaczego adres IP został dodany do listy zaufanych.',

    'login-info.hint' => 'Tutaj można zmienić nazwę użytkownika i hasło stanowiące dostęp klienta do Panelu klienta.',
    'login-info.resellerHint' => 'Tutaj można zmienić nazwę użytkownika i/lub hasło stanowiące dostęp sprzedawcy do Pleskontrolnego.',
    'login-info.myProfileHint' => 'Tutaj można zmienić hasło stanowiące dostęp do Plesku.',

    'firewall-rule.titleEdit' => 'Edytuj regułę zapory ogniowej',
    'firewall-rule.titleNew' => 'Dodawanie reguły',
    'firewall-rule.isEnabled' => 'Włącz regułę',
    'firewall-rule.name' => 'Nazwa reguły',
    'firewall-rule.profiles' => 'Profile',
    'firewall-rule.profilesHint' => 'Musisz wybrać przynajmniej jeden profil.',
    'firewall-rule.profileDomain' => 'Domena',
    'firewall-rule.profilePrivate' => 'Prywatne',
    'firewall-rule.profilePublic' => 'Ogólnodostępny',
    'firewall-rule.action' => 'Operacja',
    'firewall-rule.actionAllow' => 'Pozwól',
    'firewall-rule.actionBlock' => 'Zabroń',
    'firewall-rule.port' => 'Zezwalaj na połączenia z następującym portem lub portami w tym zakresie',
    'firewall-rule.portHint' => 'Na przykład: 1000 lub 1000-1051',
    'firewall-rule.protocolTcp' => 'Protokół TCP',
    'firewall-rule.protocolUdp' => 'Protokół UDP',
    'firewall-rule.remoteAddresses' => 'Zdalne adresy',
    'firewall-rule.remoteAddressesHint' => 'Na przykład: 192.168.0.1 lub 192.168.0.0/16',
    'firewall-rule.newRule' => 'Nowa reguła',
    'firewall-rule.successNew' => 'Dodano regułę zapory.',
    'firewall-rule.successEdit' => 'Zaktualizowano regułę zapory.',

    'mail.lists-server-settings.email' => "E-mail administratora listy mailingowej",
    'mail.lists-server-settings.emptyEmail' => 'Proszę podać adres e-mail.',
    'mail.lists-server-settings.newPassword' => 'Nowe hasło',
    'mail.lists-server-settings.emptyPassword' => 'Proszę podać hasło.',
    'mail.lists-server-settings.passwordConfirmation' => 'Potwierdź hasło',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Oprogramowanie listy mailingowej zostało skonfigurowane.',

    'mail.outgoing-messages.hint' => 'Tutaj możesz określić limit poczty wychodzącej ze skrzynki pocztowej.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Maksymalna liczba wychodzących wiadomości e-mail',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Domyślnie (%%domainOutgoingMessages%% wiadomości na godzinę)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Spersonalizowana wartość dla tej skrzynki pocztowej',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'wiadomości na godzinę',

    'mail-gate-settings.host' => 'Nazwa hosta lub adres IP',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Nazwa użytkownika',
    'mail-gate-settings.password' => 'Hasło',
    'mail-gate-settings.encryption' => 'Serwer SMTP wymaga szyfrowanego połączenia',
    'mail-gate-settings.allowUsers' => 'Zezwalaj skryptom użytkowników na wysyłanie maili poprzez serwer SMTP (z użyciem określonej nazwy użytkownika i hasła)',
    'mail-gate-settings.useDefaultSettings' => 'Użyj serwera poczty zainstalowanego w Plesku i domyślnego konta poczty utworzonego przez Plesk',

    'mail-gate.hint' => 'Tutaj możesz określić serwer SMTP, który ma być używany, kiedy serwer pocztowy Plesku nie jest zainstalowany lub kiedy nie może wysyłać poczty wychodzącej. Ten serwer będzie używany jako relay SMTP przez Plesk i skrypty użytkownika do wysyłania poczty wychodzącej, np. powiadomień mailowych.',
    'mail-gate.enableMailGate' => 'Zezwalaj Pleskowi na przesyłanie powiadomień e-mailem poprzez serwer SMTP',
    'mail-gate.notifications' => 'Powiadomienia mailem przez zewnętrzny serwer SMTP',
    'mail-gate.smtpSettings' => 'Ustawienia zewnętrznego serwera SMTP',

    'optimization-settings.apacheModulesSection' => 'Moduły Apache',
    'optimization-settings.apacheSettingsSection' => 'Ustawienia ogólne',
    'optimization-settings.additionalPageHint' => 'Przełącz moduły tylko jeśli w pełni rozumiesz konsekwencje swoich działań. Zauważ, że niektóre modyfikacje mogą obniżyć poziom działania Apache, a nawet prowadzić do jego unieruchomienia.',
    'optimization-settings.pageHint' => 'Tutaj możesz zoptymalizować Plesk poprzez wyłączenie nieużywanych modułów Apache. Ta optymalizacja poprawia wykorzystanie pamięci i pozwala na obsłużenie większej liczby klientów hostingowych. Zauważ, że niektóre moduły są współzależne i mogą być włączone/wyłączone, jeśli moduły, od których są zależne są włączone/wyłączone.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Ta funkcjonalność przeznaczona jest tylko dla zaawansowanych użytkowników.',
    'optimization-settings.apacheRestartInterval' => 'Interwał restartu serwera Apache (sekundy)',
    'optimization-settings.apacheRestartIntervalHint' => 'Raz w określonym okresie czasu Plesk szuka zmian dokonanych w domenach i poddomenach. Jeśli pojawią się zmiany, które wymagają ponownego uruchomienia serwera, Plesk zrestartuje Apache.',
    'optimization-settings.gracefulRestart' => 'Poprawny restart Apache',
    'optimization-settings.gracefulRestartHint' => 'Wybierz, aby uniknąć przestojów wszystkich witryn hostowanych na serwerze za każdym razem, gdy zmieniasz ustawienia hostingu.',
    'optimization-settings.pipedLog' => 'Logi przetworzone potokowo',
    'optimization-settings.mpmMode' => 'Tryb MPM',
    'optimization-settings.moduleDeprecated' => '(Przestarzałe)',

    'personal-info.contactInfoSection' => 'Dane kontaktowe',
    'personal-info.hint' => 'Tutaj można edytować dane kontaktowe użytkownika.',
    'personal-info.hintMyProfile' => 'Tutaj można edytować twoje dane kontaktowe.',

    'php-handler.extension.title' => 'Zainstaluj pakiet PECL',
    'php-handler.extension.description' => "Możesz zainstalować wersję beta rozszerzenia, określając dodatkowe parametry w nazwie pakietu, na przykład 'msgpack-beta'.",
    'php-handler.extension.name' => 'Nazwa pakietu',

    'php-handler.ini.formHint' => 'Ten plik php.ini file jest używany tylko przez ten uchwyt.',
    'php-handler.ini.formHintSharedIni' => 'Ten plik php.ini jest także używany przez następujące uchwyty PHP: %%handlers%%. Ustawienia mają zastosowanie do wszystkich serwisów WWW, które używają tych uchwytów.',
    'php-handler.ini.incorrectTextForIniFile' => "Podane ustawienia są niepoprawne i nie mogą być zapisane w pliku php.ini. Błąd: %%message%%.",

    'plan-item-custom.planItemName' => 'Nazwa usługi',
    'plan-item-custom.buttonLabel' => 'Ta nazwa będzie używana również jako nazwa spersonalizowanego przycisku.',
    'plan-item-custom.planItemDescription' => 'Opis usługi',
    'plan-item-custom.buttonTooltip' => 'Ten tekst będzie używany również jako podpowiedź dla spersonalizowanego przycisku',
    'plan-item-custom.url' => 'URL dołączone do spersonalizowanego przycisku',
    'plan-item-custom.backgroundImage' => 'Obraz tła dla spersonalizowanego przycisku',
    'plan-item-custom.emptyItemName' => 'Podaj nazwę dla usługi.',
    'plan-item-custom.emptyItemDescription' => 'Podaj tekst podpowiedzi dla usługi.',
    'plan-item-custom.emptyUrl' => 'Proszę określić URL.',
    'plan-item-custom.longItemName' => 'Maksymalna dopuszczalna długość to %max% znaków. Maksymalna dopuszczalna długość to %max% znaków.',
    'plan-item-custom.longItemDescription' => 'Tekst dotyczący usługi jest zbyt długi. Maksymalna dopuszczalna długość to %max% znaków.',
    'plan-item-custom.longUrl' => 'To URL jest zbyt długie. Maksymalna dopuszczalna długość to %max% znaków.',
    'plan-item-custom.useCustomButton' => 'Użyj spersonalizowanego przycisku dla usługi',
    'plan-item-custom.useCustomButtonHint' => 'Umieść spersonalizowany przycisk na stronie domowej użytkownika i na stronach WWW.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Otwórz URL w Plesku',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Określ, czy otworzyć URL na stronie Plesk czy w nowym oknie przeglądarki.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Nie używaj ramek',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Jeśli dodasz spersonalizowany przycisk, który prowadzi do rozszerzenia Plesku lub do aplikacji w Panelu klienta, możesz okreslić, w jaki sposób rozszerzenie lub aplikacja mają być wyświetlane: w ramce czy jako część interfejsu użytkownika Plesk.',
    'plan-item-custom.includeDomId' => 'Dołącz ID subskrypcji',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Dołącz nazwę głównej domeny',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Dołącz nazwę użytkownika FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Dołącz hasło FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Dołącz ID klienta',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Dołącz nazwę firmy klienta",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Dołącz kontakt klienta",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Dołącz adres e-mail klienta",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Wybierz sposób wyświetlania podglądu stron WWW',
    'preview-domain-settings.previewQuick' => 'Domyślny szybki podgląd',
    'preview-domain-settings.previewDisabled' => 'Zablokuj szybki podgląd',
    'preview-domain-settings.previewQuickDescription' => 'Zalecana opcja, która działa niestandardowo.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Szybki podgląd na nazwie domeny w Plesku',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Wybierz jeden z serwisów WWW obsługiwanych przez Plesk, aby był użyty do podglądu.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Aby użyć tej funkcji, %%link%% przynajmniej jedną domenę.',
    'preview-domain-settings.subscriptionCreateLink' => 'utwórz',
    'preview-domain-settings.previewZoneTypeExternal' => 'Szybki podgląd na zewnętrznej domenie',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Użyj zewnętrznej nazwy domeny (strefa DNS). Jeśli użyjesz tej opcji, dodaj następujący rekord DNS (typ A) do zewnętrznej strefy domeny: *.<Plesk_IP>.external.dom. Tutaj <Plesk_IP>znajduje się IP serwera Plesku, gdzie kropki (.) dla IPv4 lub dwukropki (:) dla IPv6 są zastąpione przez kreski (-). Na przykład, *.192-0-2-12.external.dom. Jeśli Plesk ma więcej niż jeden zarejestrowany adres IP, dodaj rekord dla każdego adresu.',
    'preview-domain-settings.sitePreviewProtection' => 'Wymaga autentykacji',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Wymaga loginu i hasła FTP, aby uzyskać dostęp do podglądu.',
    'preview-domain-settings.nginxNotInstalled' => 'Domyślny Szybki podgląd nie jest dostępny, ponieważ serwer WWW nginx nie jest zainstalowany.',
    'preview-domain-settings.nginxDisabled' => 'Domyślny Szybki podgląd nie jest dostępny, ponieważ serwer WWW nginx jest zablokowany.',

    'reseller-preferences.settingsSection' => 'Ustawienia',
    'reseller-preferences.multiLogin' => 'Pozwól na wiele sesji',
    'reseller-preferences.language' => 'Język interfejsu',
    'reseller-preferences.interfaceView' => 'Wybierz interfejs',
    'reseller-preferences.serviceProviderView' => 'Widok dostawcy usług',
    'reseller-preferences.serviceProviderViewHint' => 'Ten widok jest przeznaczony dla administratorów serwerów, którzy dostarczają i sprzedają usługi hostingowe swoim klientom za pomocą planów usług.',
    'reseller-preferences.powerUserView' => 'Widok użytkownika w trybie Power',
    'reseller-preferences.powerUserViewHint' => 'Ten widok najlepiej nadaje się do zarządzania witrynami internetowymi, ich plikami, bazami danych, kontami e-mail, aplikacjami internetowymi i innymi usługami.',

    'reseller.hint' => 'Tutaj można przypisać nowego klienta do usług hostingowych.',
    'reseller.contactInfoSection' => 'Dane kontaktowe',
    'reseller.contactInfoSectionHint' => 'Wpisz informacje kontaktowe sprzedawcy.',
    'reseller.accessToPanelSection' => 'Dostęp do Pleska',
    'reseller.accessToPanelSectionHint' => 'Dane dostępowe używane przez klienta do Plesku w celu zarządzania usługami, do których są przypisani.',
    'reseller.subscription' => 'Subskrypcja',
    'reseller.subscriptionSectionHint' => 'Wybierz plan usługi dla sprzedawcy.',
    'reseller.servicePlan' => 'Plan usługi',
    'reseller.none' => 'Żaden',
    'reseller.customizeSubscription' => 'Kontynuuj dostosowywanie parametrów subskrypcji po utworzeniu sprzedawcy. Uwaga - ta czynność uniemożliwi synchronizację subskrypcji.',
    'reseller.subscriptionNotSynchronized' => 'Nie można zsynchronizować subskrypcji z planem usługi. Następujące ustawienia subskrypcji są w konflikcie z planem usługi: %%problems%%.',

    'security-policy.encryptionSection' => 'Tryb zwiększonego bezpieczeństwa',
    'security-policy.encryptionSectionHint' => 'Tryb zwiększonego bezpieczeństwa wprowadza zaawansowaną ochronę danych wrażliwych w Plesku. W tym trybie Plesk stosuje wiele mechanizmów bezpieczeństwa, które są absolutnie transparentne dla użytkowników Plesku. Aby poprawić bezpieczeństwo Plesku, zalecamy włączenie trybu zwiększonego bezpieczeństwa.',
    'security-policy.encryptionEnable' => 'Tryb zwiększonego bezpieczeństwa',
    'security-policy.securePassword' => 'Tryb zwiększonego bezpieczeństwa',
    'security-policy.strengthSection' => 'Siła hasła',
    'security-policy.strengthSectionHint' => 'Większość haseł, które użytkownicy mogą ustawić lub zmienić w Plesku, jest weryfikowana, aby upewnić się, że spełniają one minimalne wymagania dotyczące siły hasła określone tutaj. Silne hasła mają co najmniej 9-12 znaków i zawierają cyfry, duże i małe litery, znaki specjalne i nie zawierają słów słownikowych. Są trudniejsze do odgadnięcia, ale też do zapamiętania. <a href="%%link%%" target="_blank">Dowiedz się więcej o sile haseł</a>.',
    'security-policy.passwordStrength' => 'Minimalna siła hasła',
    'security-policy.secureFtpSection' => 'Zabezpiecz FTP',
    'security-policy.ftpOverSsl' => 'Polityka wykorzystania FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS jest używane do ochrony komunikacji pomiędzy serwerem FTP i zewnętrznymi klientami FTP przy użyciu protokołu SSL/TLS. Tutaj możesz określić jaki rodzaj połączeń jest dozwolony.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS jest używane do ochrony komunikacji pomiędzy serwerem FTP i zewnętrznymi klientami FTP przy użyciu protokołu SSL/TLS. Tutaj możesz określić jaki rodzaj połączeń jest dozwolony. Wybrana opcja zostanie zastosowana do wszystkich adresów IP na serwerze. Aby skorzystać ze spersanolizowanych ustawień dla każdego adresu IP, wybierz odpowiednią opcję i zmień politykę FTPS w Narzędzia i ustawienia> Adresy IP.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS jest używane do ochrony komunikacji pomiędzy serwerem FTP i zewnętrznymi klientami FTP przy użyciu protokołu SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS jest używane do ochrony komunikacji pomiędzy serwerem FTP i zewnętrznymi klientami FTP przy użyciu protokołu SSL/TLS. Jeśli chcesz dostosować ustawienia dla adresu IP, najpierw wybierz opcję "Użyj spersonalizowanych ustawień FTP dla adresu IP" w Narzędzia i Ustawienia> Polityka bezpieczeństwa> Zabezpiecz FTP.',
    'security-policy.ftpOverSslOptionRequired' => 'Zezwalaj tylko na połączenia FTPS',
    'security-policy.ftpOverSslOptionEnabled' => 'Zezwalaj na bezpieczne i niezabezpieczone połączenia FTP',
    'security-policy.ftpOverSslOptionDisabled' => 'Zezwalaj tylko na niezabezpieczone połączenia FTP. Nie używaj FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Użyj spersonalizowanej polityki FTPS dla każdego adresu IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Polityka spersonalizowanych handlerów',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Włącz tę opcję by uniemożliwic użytkownikom nadpisanie IIS handlerów zdefiniowanych na poziomie serwara przez plik web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Zakaż możliwości nadpisywania handlerów poprzez web.config',

    'server-mail-antivirus.used' => 'Używany antywirus',
    'server-mail-antivirus.policy' => 'Użyj ustawień serwera',
    'server-mail-antivirus.policyOff' => 'Skanowanie zostało wyłączone',
    'server-mail-antivirus.policyAny' => 'Skanuj pocztę wychodzącą i przychodzącą',
    'server-mail-antivirus.policyFrom' => 'Skanuj tylko pocztę wychodzącą',
    'server-mail-antivirus.policyTo' => 'Skanuj tylko pocztę przychodzącą',
    'server-mail-antivirus.allowPersonalSettings' => 'Ustawienia osobiste',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Zezwalaj na zastępowanie ustawień ogólnoserwerowych w każdym adresie e-mail',
    'server-mail-antivirus.incoming' => 'Dla poczty przychodzącej',
    'server-mail-antivirus.outgoing' => 'Dla poczty wychodzącej',
    'server-mail-antivirus.success' => 'Ustawienia antywirusa zostały zmienione.',

    'server-mail-black-list.title' => 'Dodaj domenę do czarnej listy',
    'server-mail-black-list.domainName' => 'Nazwa domeny',
    'server-mail-black-list.emailAddress' => 'Adres e-mail',
    'server-mail-black-list.emailAddressHint' => 'Po lewej stronie znaku @ nie może być znaków spoza zestawu ASCII. Adresy mogą zawierać „*” i „?” symbole wieloznaczne (na przykład *@domena.com, użytkownik?@*.com). Części nazw domen inne niż ASCII nie mogą zawierać symboli wieloznacznych.',
    'server-mail-black-list.action' => 'Co zrobić z e-mailem, który spełnia kryteria:',
    'server-mail-black-list.actionDelete' => 'Skasuj z serwera',
    'server-mail-black-list.actionSpam' => 'Oznacz jako spam',
    'server-mail-black-list.success' => 'Domena została dodana do czarnej listy.',

    'server-mail-white-list.title' => 'Dodaj sieć do białej listy',
    'server-mail-white-list.descEmailAddress' => 'Podane tutaj adresy e-mail nie będą rozpoznawane przez SpamAssassin jako spam.',
    'server-mail-white-list.descIpAddress' => 'Określone tutaj wpisy IP zostaną dodane do wyjątków serwera pocztowego.',
    'server-mail-white-list.ipAddress' => 'Adres IP/maska',
    'server-mail-white-list.ipAddressHint' => 'Adres IP może zawierać symbol wieloznaczny lub maskę CIDR.',
    'server-mail-white-list.emailAddress' => 'Adres e-mail',
    'server-mail-white-list.emailAddressHint' => 'Po lewej stronie znaku @ nie może być znaków spoza zestawu ASCII. Adresy mogą zawierać „*” i „?” symbole wieloznaczne (na przykład *@domena.com, użytkownik?@*.com). Części nazw domen inne niż ASCII nie mogą zawierać symboli wieloznacznych.',
    'server-mail-white-list.emailAddressOrIp' => 'Adresy e-mail lub IP',
    'server-mail-white-list.wildcardPattern' => 'Adresy IP mogą zawierać symbole wieloznaczne (na przykład 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'Adresy IP mogą zawierać maski CIDR (na przykład 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Sieć została dodana do białej listy.',

    'server-mail-settings.general.title' => 'Opcje ogólne',
    'server-mail-settings.general.mailUiEnabled' => 'Włącz funkcje zarządzania pocztą w Plesk',
    'server-mail-settings.general.serverName' => 'Zainstalowany serwer pocztowy',
    'server-mail-settings.general.changeServerName' => 'instaluj i użyj innego serwera pocztowego',
    'server-mail-settings.general.imapServerName' => 'Zainstalowany serwer IMAP/POP3',
    'server-mail-settings.general.changeImapServerName' => 'zainstaluj inny serwer IMAP/POP3 i używaj go',
    'server-mail-settings.general.changeServerHint' => 'Możesz %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Maksymalna wielkość listu',
    'server-mail-settings.general.kbytes' => 'KBajty',
    'server-mail-settings.general.maxConnections' => 'Maksymalna liczba połączeń (IMAP, POP3, IMAP poprzez SSL/TLS lub POP3 poprzez SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'Maksymalna liczba uruchomionych serwerów (IMAP lub POP3).',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'Maksymalna liczba użytkowników poczty, która może być zalogowana w tym samym czasie.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Maksymalna liczba połączeń na adres IP',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Maksymalna liczba połączeń dla użytkownika na adres IP',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'Maksymalna liczba połączeń (IMAP, POP3, IMAP poprzez SSL/TLS lub POP3 poprzez SSL/TLS), które można akceptować z tego samego adresu IP.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'Maksymalna liczba połączeń (IMAP, POP3, IMAP poprzez SSL/TLS lub POP3 poprzez SSL/TLS) dozwolona dla jednego użytkownika poczty z każdego adresu IP.',
    'server-mail-settings.general.messageSubmission' => 'Włącz usługę SMTP na porcie 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Odblokuj usługę SMTP w porcie 587 dla wszystkich adresów IP',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Wł',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'wszystkie adresy IP',
    'server-mail-settings.general.outgoingEmailMode' => 'Tryb poczty wychodzącej',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Wyślij adresy IP domeny',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Wyślij z adresów IP domeny i użyj nazw domen w powitaniu SMTP',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Wyślij z podanych adresów IP',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Brak',
    'server-mail-settings.general.subaddressing' => 'Włącz subadresowanie e-maili',
    'server-mail-settings.general.subaddressingHint' => 'Ta opcja umożliwia konfigurację adresów e-mail %%verpStyleLink%% dla list mailingowych',
    'server-mail-settings.general.verpStyleLink' => 'Styl VERP',
    'server-mail-settings.general.mboxQuotaWarning' => 'Włącz ostrzeżenie o limicie skrzynki pocztowej',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Wysyłaj powiadomienia do użytkowników poczty, gdy wykorzystanie ich przydziału na skrzynki pocztowe przekroczy 95%',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Dostosuj domyślne ostrzeżenie o limicie skrzynki pocztowej',
    'server-mail-settings.general.fixSender' => 'Napraw nieprawidłowo ustawionego nadawcę poczty wychodzącej',
    'server-mail-settings.general.fixSenderHint' => 'Automatycznie ustaw prawidłowe nagłówki wiadomości e-mail i adres nadawcy dla poczty wychodzącej z domen, aby zmniejszyć ryzyko traktowania ich jako spamu',
    'server-mail-settings.general.maxMessageSizeHint' => 'W przypadku wiadomości e-mail z załącznikiem wartość powinna być o 35-40% większa niż rozmiar załącznika. %%kbLink%%.',
    'server-mail-settings.general.maxMessageSizeHintLink' => 'Aby uzyskać więcej informacji, zobacz artykuł w bazie wiedzy',

    'server-mail-settings.autodiscover.title' => 'Automatyczne wykrywanie poczty',
    'server-mail-settings.autodiscover.description' => 'Zobacz, jak to działa w %%link%%',
    'server-mail-settings.autodiscover.link' => 'baza wiedzy',
    'server-mail-settings.autodiscover.enabled' => 'Włącz automatyczne wykrywanie poczty',
    'server-mail-settings.autodiscover.enabledHint' => 'Włączenie tej funkcji powoduje ponowną konfigurację wszystkich domen, dla których włączono automatyczne wykrywanie',
    'server-mail-settings.autodiscover.customServer' => 'Niestandardowa nazwa domeny',
    'server-mail-settings.autodiscover.customServerHint' => 'Określ niestandardową nazwę domeny, która będzie używana jako serwer poczty przychodzącej i wychodzącej na potrzeby konfiguracji automatycznego wykrywania poczty.',
    'server-mail-settings.autodiscover.customServerCertHint' => 'Uwaga: Nazwa domeny musi być zabezpieczona ważnym certyfikatem SSL/TLS.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Ponownie skonfiguruj rekordy DNS automatycznego wykrywania',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Włączenie tej funkcji powoduje ponowną konfigurację wszystkich rekordów DNS automatycznego wykrywania domen, które mają włączone automatyczne wykrywanie',

    'server-mail-settings.relay.title' => 'Opcje przekazywania',
    'server-mail-settings.relay.type' => "Przekazywanie",
    'server-mail-settings.relay.open' => "otwarty",
    'server-mail-settings.relay.openSpamWarning' => "Otwarcie przekaźnika poczty naraża serwer poczty na spam.",
    'server-mail-settings.relay.openSpamChange' => "Zachowaj to ustawienie tylko wtedy, gdy chcesz tymczasowo przetestować serwer pocztowy lub serwer Plesk znajduje się w sieci wewnętrznej niedostępnej przez Internet.",
    'server-mail-settings.relay.closed' => "zamknięte",
    'server-mail-settings.relay.auth' => "wymagana autoryzacja:",
    'server-mail-settings.relay.notSupported' => "nie obsługiwany przez serwer pocztowy",
    'server-mail-settings.relay.change' => 'Aby umożliwić Plesk wysyłanie powiadomień, gdy przekaźnik jest zamknięty, możesz %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'zmień ustawienia SMTP',
    'server-mail-settings.relay.pop3' => "POP3 przed SMTP",
    'server-mail-settings.relay.lockTime' => "czas blokady",
    'server-mail-settings.relay.min' => "Min",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Nie używaj ograniczeń typu relay dla następujących sieci:',
    'server-mail-settings.relay.noRelayNetworksHint' => "Adres IP/maska",

    'server-mail-settings.outgoing.title' => 'Ograniczenia dotyczące wychodzących wiadomości e-mail',
    'server-mail-settings.outgoing.description' => 'Poniższe limity są domyślne. Można je zastąpić w każdym planie usług i subskrypcji. Limity nie działają na całym serwerze, ale działają jako szablon dla planów i subskrypcji, dla których nie określono limitów niestandardowych. Pamiętaj, że włączenie ograniczenia wychodzących wiadomości e-mail może wpłynąć na wydajność serwera pocztowego. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Dowiedz się więcej o ograniczaniu poczty wychodzącej',
    'server-mail-settings.outgoing.enabled' => 'Włącz ograniczenia dotyczące wychodzących wiadomości e-mail',
    'server-mail-settings.outgoing.countRecipients' => 'Policz liczbę odbiorców zamiast wiadomości',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Włącza tryb, który zlicza adresatów zamiast wiadomości podczas ograniczania poczty wychodzącej i zliczania statystyk. Na przykład jedna wiadomość wysłana do 10 odbiorców będzie liczona jako dziesięć wiadomości.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Domyślny limit wiadomości wychodzących ze skrzynki pocztowej (na godzinę)',
    'server-mail-settings.outgoing.domainLimit' => 'Domyślny limit wiadomości wychodzących z domeny (na godzinę)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Domyślny limit wiadomości wychodzących z subskrypcji (na godzinę)',
    'server-mail-settings.outgoing.unlimited' => 'Nieograniczone',
    'server-mail-settings.outgoing.sendmail' => 'Zezwalaj użytkownikom i skryptom na używanie Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Skrypty i użytkownicy będą mogli wysyłać wiadomości e-mail (w imieniu użytkownika systemu subskrypcji), używając Sendmail, nawet jeśli limity skrzynki pocztowej i domeny zostały przekroczone. Maksymalna liczba wiadomości, którą można wysłać poprzez Sendmail zostanie zdefiniowana w limicie dla całej subskrypcji. To ustawienie nie pozwala skryptom na używanie Sendmail na całym serwerze, ale działa jako domyślne ustawienie dla planu usługi i subskrypcji.',
    'server-mail-settings.outgoing.reportPeriod' => 'Pokaż raporty na bazie statystyk dla ostatniego',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Raporty są tworzone, a alert jest wyświetlony na stronie domowej o próbach przekroczenia limitów poczty wychodzącej w określonym okresie czasu.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Wyślij powiadomienie e-mail',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Powiadomienia dostarczają informacji o statystykach prób przekroczenia limitów poczty wychodzącej w określonym okresie czasu.',
    'server-mail-settings.outgoing.periodP1D' => '1 dzień',
    'server-mail-settings.outgoing.periodP1W' => '1 tydzień',
    'server-mail-settings.outgoing.periodP2W' => '2 tygodnie',
    'server-mail-settings.outgoing.periodP1M' => '1 miesiąc',
    'server-mail-settings.outgoing.periodPT15M' => '15 minuty',
    'server-mail-settings.outgoing.periodPT1H' => '1 godzina',
    'server-mail-settings.outgoing.periodPT6H' => '6 godzin',
    'server-mail-settings.outgoing.periodPT12H' => '12 godzin',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Limity poczty wychodzącej nie będą działały dla wysyłających, których adresy IP są na białej liście serwera. Na przykład, jeśli lokalny host (127.0.0.0 / 8, ::1 / 128) znajduje się na białej liście, cała poczta z lokalnego serwera zostanie wysłana bez względu na ograniczenia.Nadawcy poczty mogą używać lokalnych adresów IP (serwisów WWW i spersonalizowanych skryptów na lokalnym serwerze) lub zewnętrznych adresów (klienci, którzy wysyłają poczte z klientów pocztowych zainstalowanych na ich komputerach lub na urządzeniach mobilnych).Aby zastosować limity dla wszystkich nadawców poczty (lokalnych i zewnętrznych), usuń wszystkie adresy IP i sieci z białej listy. Zauważ, że usunięcie lokalnego hosta (127.0.0.0 / 8, ::1 / 128) z białej listy może przerwać działanie serwisów WWW i skryptów, które wysyłają pocztę z tego serwera. Aby poznać szczegóły dotyczące ograniczeń poczty wychodzącej, zajrzyj do przewodnika administratora do sekcji dotyczącej ochrony przed spamem wychodzącym.',
    'server-mail-settings.outgoing.relayIsOpen' => 'Przekazywanie poczty jest otwarte: Limity poczty wychodzącej nie będą działały:.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'Limit wiadomości wychodzących dla domeny (%%value%%) nie może być większa niż limit dla subskrypcji (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'Limit wiadomości wychodzących dla adresu e-mail (%%value%%) nie może być większa niż limit dla domeny (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'Limit wiadomości wychodzących dla adresu e-mail (%%value%%) nie może być większa niż limit dla subskrypcji (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Ustawienia programu Mailman',
    'server-mail-settings.mailman.secureLinks' => 'Użyj bezpiecznych linków w listach mailingowych',
    'server-mail-settings.mailman.secureLinksHint' => 'Włącz lub wyłącz tworzenie bezpiecznych linków (HTTPS) w listach mailingowych.',
    'server-mail-settings.mailman.noLocalhost' => 'Aby użyć list mailingowych, potrzebujesz lokalnego hosta (127.0.0.0/8, ::1/128) na białej liście serwera poczty. Jednak aby użyć kontroli poczty wychodzącej, nie powinieneś posiadać lokalnego hosta na białej liście. W ramach kompromisu jesli aktywujesz kontrolę poczty wychodzącej, możesz użyć przekazywania poczty na skrzynce zamiast list mailingowych.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Aby użyć list mailingowych, potrzebujesz lokalnego hosta na białej liście serwera poczty. Jednak aby użyć kontroli poczty wychodzącej, nie powinieneś posiadać lokalnego hosta na białej liście. W ramach kompromisu jesli aktywujesz kontrolę poczty wychodzącej, możesz użyć przekazywania poczty na skrzynce zamiast list mailingowych. Zauważ, że nie adresów IPv4 (127.0.0.0/8) lokalnego hosta w tej chwili na białej liście, więc kontrola poczty wychodzącej będzie działała dla adresów IPv4.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Aby użyć list mailingowych, potrzebujesz lokalnego hosta na białej liście serwera poczty. Jednak aby użyć kontroli poczty wychodzącej, nie powinieneś posiadać lokalnego hosta na białej liście. W ramach kompromisu jesli aktywujesz kontrolę poczty wychodzącej, możesz użyć przekazywania poczty na skrzynce zamiast list mailingowych. Zauważ, że nie adresów IPv6 (1/128) lokalnego hosta w tej chwili na białej liście, więc kontrola poczty wychodzącej będzie działała dla adresów IPv6.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Włącz DMARC, aby sprawdzać pocztę przychodzącą',
    'server-mail-settings.spam-filter.dmarcHint' => 'Ta opcja jest dostępna, gdy włączone są DKIM i SPF dla poczty przychodzącej.',
    'server-mail-settings.spam-filter.dkim' => 'Ochrona przed spamem DKIM',
    'server-mail-settings.spam-filter.singOutgoing' => 'Zezwalaj na podpisywanie maili wychodzšcych',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Zweryfikuj pocztę przychodzšcš',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Tej opcji nie można wyłączyć, gdy DMARC jest włączone dla poczty przychodzącej.',
    'server-mail-settings.spam-filter.spf' => 'Ochrona antyspamowa SPF',
    'server-mail-settings.spam-filter.spfEnabled' => 'Odblokuj ochronę antyspamową, aby sprawdzać wiadomości przychodzące.',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Tej opcji nie można wyłączyć, gdy DMARC jest włączone dla poczty przychodzącej.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'Sprawdzanie SPF trwa, kiedy wystąpią problemy wyszukiwania DNS',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'Najpierw SPF wykonuje wyszukiwanie DNS. Wybierz tę opcję, aby kontynuować sprawdzanie, czy wyszukiwanie DNS się nie powiodło. Ta opcja jest wyłączona, jeśli nie ma żadnego wpływu w bieżącym trybie sprawdzania.',
    'server-mail-settings.spam-filter.behavior' => 'Tryb sprawdzania SPF',
    'server-mail-settings.spam-filter.behaviorHint' => 'Następnie, SPF stosuje lokalne i odgadniete reguły. Wiadomość może być odrzucona w zależności od wybranego trybu sprawdzania i wyniku sprawdzania.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Stwórz jedynie otrzymane nagłówki SPF, nigdy nie blokuj',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Użyj tymczasowych błędów gdy masz problemy z DNS-em',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Odrzuć pocztę, jeli SPF zwraca "fail" (zabroń)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Odrzuć pocztę, jeli SPF zwraca "softfail"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Odrzuć pocztę, jeli SPF zwraca "neutral"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Odrzuć pocztę, jeli SPF nie zwraca "pass"',
    'server-mail-settings.spam-filter.localRules' => 'Użyj lokalnych reguł SPF',
    'server-mail-settings.spam-filter.guessRules' => 'Odgadywanie SPF',
    'server-mail-settings.spam-filter.explanationText' => 'Tekst objanienia SPF',
    'server-mail-settings.spam-filter.rbl' => "Ochrona przed spamem w oparciu o czarne listy DNS",
    'server-mail-settings.spam-filter.rblEnabled' => "Włącz ochronę przed spamem na podstawie czarnych list DNS",
    'server-mail-settings.spam-filter.rblServer' => "Strefy DNS dla DNSBL usługi",
    'server-mail-settings.spam-filter.rblServerHint' => "Oddziel wpisy przecinkami. Przykład: 'zen.spamhaus.org;dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Dodatkowe nagłówki automatycznej odpowiedzi',
    'server-mail-settings.auto-reply-headers.description' => 'Ustaw dodatkowe nagłówki dla każdej automatycznej odpowiedzi przychodzącej z serwera Plesk.',
    'server-mail-settings.auto-reply-headers.extra' => 'Dodatkowe nagłówki',

    'server-mail-settings.pop3-names.title' => "Nazwy dla kont pocztowych POP3/IMAP",
    'server-mail-settings.pop3-names.disabled' => "Można używać tylko pełnych nazw kont pocztowych POP3/IMAP",
    'server-mail-settings.pop3-names.enabled' => "Można używać krótkich (webmaster) i pełnych (webmaster@domain.com) kont pocztowych POP3/IMAP.",

    'server-mail-settings.success' => 'Ustawienia serwera pocztowego zostały zmienione.',

    'server-mail-spam-filter.general' => 'Ogólny',
    'server-mail-spam-filter.isEnabled' => 'Włącz filtrowanie spamu za pomocą SpamAssassin dla całego serwera',
    'server-mail-spam-filter.notInstalled' => '(SpamAssasin nie jest zainstalowany.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'Włącz ochronę przed spamem typu szara lista dla całego serwera',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Pozwól edycję właściwości per użytkownik',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "Filtrowanie spamu jest wyłączone: serwer poczty nie obsługuje ustawień filtra spamu na poziomie skrzynki pocztowej.",
    'server-mail-spam-filter.settings' => 'Ustawienia SpamAssassin',
    'server-mail-spam-filter.maxChildrenTitle' => 'Maksymalna liczba procesów',
    'server-mail-spam-filter.maxChildrenDescription' => 'Maksymalna liczba procesów spamd do uruchomienia.',
    'server-mail-spam-filter.requiredHitsTitle' => 'Wymagany wynik',
    'server-mail-spam-filter.requiredHitsDescription' => 'Liczba punktów jaką wiadomość musi uzyskać aby zostać zakwalifikowana jako spam.',
    'server-mail-spam-filter.maxMailLimit' => 'Nie filtruj, jeżeli wielkość e-maila przekracza tę wartość',
    'server-mail-spam-filter.maxMailLimitText' => 'limit wielkości',
    'server-mail-spam-filter.kbytes' => "KBajty",
    'server-mail-spam-filter.maxThreadsLimit' => 'Liczba wątków, którą może wytworzyć filtr spamu',
    'server-mail-spam-filter.tagTitle' => 'Oznaczenie spamu',
    'server-mail-spam-filter.tagDescription' => 'Poniższy tekst zostanie dodany na początku tematu każdej wiadomości uznanej za spam.',
    'server-mail-spam-filter.alarmMessage' => 'Tekst ostrzeżenia o wykryciu spamu',
    'server-mail-spam-filter.languages' => 'Zaufane języki',
    'server-mail-spam-filter.locales' => 'Zaufane ustawienia lokalne',
    'server-mail-spam-filter.success' => 'Ustawienia filtra spamu zostały zmienione.',
    'server-mail-spam-filter.personalSettingsWarning' => 'Możliwoć zastosowania osobistych ustawień filtra antyspamowego jest wyłšczona przez administratora. Okrelone poniżej ustawienia filtracji nie zostanš zastosowane',

    'service-plan.admin-plan.subscription_section' => 'Wpólne',
    'service-plan.admin-plan.tools_section' => 'Narzędzia i zasoby',
    'service-plan.admin-plan.apps_section' => 'Aplikacje & bazy danych',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Wygląd Pleska',
    'service-plan.admin-plan.statistics_section' => 'Statystyki',
    'service-plan.admin-plan.general_section' => 'Ogólny',
    'service-plan.admin-plan.mail_section' => 'Poczta',
    'service-plan.admin-plan.server_section' => 'Serwer',
    'service-plan.admin-plan.modules_section' => 'Rozszerzenia',
    'service-plan.admin-plan.troubleshooting_section' => 'Pomoc i rozwiązywanie problemów',
    'service-plan.admin-plan.simplePanel' => 'Tryb ograniczonego dostępu',
    'service-plan.admin-plan.enabled' => 'Włącz tryb ograniczonego dostępu',
    'service-plan.admin-plan.enabledDescription' => 'Wybierz tę opcję, aby ograniczyć liczbę działań, które administrator może podjąć w systemie Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Wybierz tę opcję, aby ograniczyć liczbę działań, które może podjąć dodatkowy administrator w systemie Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Udostępnij tylko te aplikacje, które wybiorę',
    'service-plan.applications-subscription.useFilterDescription' => 'Użyj tej opcji do wybrania aplikacji dostępnych dla subskrybenta.',
    'service-plan.applications-subscription.applications' => 'Aplikacje',
    'service-plan.applications-subscription.isCommercial' => 'To jest komercyjna aplikacja i wymaga zakupu klucza licencyjnego.',

    'service-plan.applications.useFilterLabel' => 'Udostępnij tylko te aplikacje, które wybiorę',
    'service-plan.applications.useFilterDescription' => 'Użyj tej opcji do wybrania aplikacji dostępnych dla subskrybentów.',
    'service-plan.applications.applications' => 'Aplikacje',
    'service-plan.applications.isCommercial' => 'To jest komercyjna aplikacja i wymaga zakupu klucza licencyjnego.',

    'service-plan.dns.dnsZoneType' => 'Strefa DNS domeny',
    'service-plan.dns.dnsZoneTypeMaster' => 'Nadrzędny',
    'service-plan.dns.dnsZoneTypeSlave' => 'Podrzędny',

    'service-plan.extras.groupOtherServices' => 'Inne usługi',
    'service-plan.extras.none' => 'Żaden',

    'service-plan.hosting.enablePhysicalHosting' => 'Uruchom hosting',
    'service-plan.hosting.sectionCoreHosting' => 'Właściwości ogólne',
    'service-plan.hosting.sectionScripting' => 'Skrypty',
    'service-plan.hosting.defaultDatabaseServer' => 'Domyślny serwer bazy danych',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Zaawansowane',
    'service-plan.hosting.phpSettingsHelpLink' => 'Dowiedz się, jak wybrać najodpowiedniejsze ustawienia PHP',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Status serwisów, jeśli subskrypcja jest zawieszona',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Status serwisów w zawieszonych subskrypcjach',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Wybrany status zoastanie zastosowany do wszystkich serwisów w subskrypcjach planu, kiedy subskrypcja jest zawieszona (np. wygaśnie lub minie termin płatności).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Wybrany status zoastanie zastosowany do wszystkich serwisów, kiedy subskrypcja jest zawieszona (np. wygaśnie lub minie termin płatności).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Wyłączony',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Odwiedzający serwisy beda przekierowani na domyślną stronę serwera.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Zawieszone',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Odwiedzający strony internetowe zostaną przekierowani za pomocą przyjaznego dla wyszukiwarek kodu 503 HTTP na stronę z niestandardowym dokumentem błędu.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Aktywne',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Serwisy będą dostępne przez internet.',

    'service-plan.ip.sharedIpAddresses' => 'Nadaj współdzielone adresy IP',
    'service-plan.ip.allocateExclusiveIp' => 'Nadaj dedykowane adresy IP',
    'service-plan.ip.allocateExclusiveIpV4' => 'Nadaj dedykowane adresy IP v4',
    'service-plan.ip.allocateExclusiveIpV6' => 'Nadaj dedykowane adresy IP v6',

    'service-plan.mail.mailService' => 'Usługa pocztowa',
    'service-plan.mail.mailServiceDisabled' => 'Wyłączony',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Wyłączone dla poczty przychodzącej',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk nie świadczy żadnych usług pocztowych na domenach.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Domeny mogą wysyłać tylko pocztę i tylko za pomocą usługi Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Włączona',
    'service-plan.mail.mailServiceEnabledHint' => 'Domeny mogą wysyłać i odbierać pocztę.',
    'service-plan.mail.mailServiceNotConfigured' => 'Nie skonfigurowany',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk nie świadczy żadnych usług pocztowych na domenach.',
    'service-plan.mail.webMail' => 'Poczta webowa',
    'service-plan.mail.mailingLists' => 'Wlącz listy mailingowe',
    'service-plan.mail.mailToNonExistentUser' => 'Polityka dotycząca poczty nieistniejących użytkowników',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Odbij z wiadomością',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Przechwyć do adresu',
    'service-plan.mail.mailToNonExistentUserReject' => 'Odrzuć',
    'service-plan.mail.mailAutodiscovery' => 'Włącz automatyczne wykrywanie poczty',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Zobacz, jak to działa w naszej <a href="%%link%%" target="_blank">bazie wiedzy</a>',
    'service-plan.mail.bounceMessage' => 'Ten adres już nie przyjmuje poczty.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Przekieruj na zewnętrzny serwer pocztowy z adresem IP',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - wyłączony',

    'service-plan.misc.manualSubscriptionUpdateWarning' => 'Uwaga: ustawienie Zachowaj statystyki sieci i ruchu nie zmienia się w przypadku subskrypcji po aktualizacji do planu usług. Jedynym sposobem na aktualizację tego ustawienia dla każdej domeny jest jego zmiana w bazie danych Plesk. Zobacz <a href="https://support.plesk.com/hc/en-us/articles/12377479274007-How-to-configure-a-storage-period-for-statistics" target="_blank">ten artykuł z bazy wiedzy</a>, aby uzyskać więcej informacji.',
    'service-plan.misc.retainEnabled' => 'Zachowaj statystyki sieci i ruchu przez',
    'service-plan.misc.logRotation' => 'Rotacja logów',
    'service-plan.misc.logRotationCondition' => 'Stan rotacji logów',
    'service-plan.misc.logRotationBySize' => 'według rozmiaru',
    'service-plan.misc.logRotationByTime' => 'Według czasu',
    'service-plan.misc.logRotationDaily' => 'Dziennie',
    'service-plan.misc.logRotationWeekly' => 'Tygodniowo',
    'service-plan.misc.logRotationMonthly' => 'Miesięcznie',
    'service-plan.misc.logRotationSizeDescription' => 'Wartość rozmiaru musi być pomiędzy %%min%% i %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Maksymalna liczba plików logów',
    'service-plan.misc.compress' => 'Skompresuj pliki logów',
    'service-plan.misc.sendLogToEmail' => 'Kiedy Plesk odzyska dane z plików logów i serwerów FTP, prześlij logi na ten adres',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'miesiące',
    'service-plan.misc.logRotationPeriodGreater' => 'Okres rotacji dziennika nie może być dłuższy niż limit serwera %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Jeśli wyłączone, wszystkie serwisy WWW subskrypcji używają tej samej puli aplikacji IIS dedykowanej dla subskrypcji.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Wybierz usługi i uprawnienia dostępne w subskrypcji.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Pokaż więcej dostępnych uprawnień',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Pokaż mniej uprawnień',
    'service-plan.permissions-subscription.noShellManagement' => 'Niedozwolone',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Zarządzanie dostępem do serwera poprzez SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Zezwalaj klientom na włączanie SSH dla użytkowników systemowych. Sprawia, że parametr "Dostęp SSH do skorupy serwera dla użytkownika systemowego subskrypcji\'" zachowuje się jak domyślny.',

    'service-plan.permissions.permissionsTabDescription' => 'Wybierz usługi i uprawnienia przewidziane w planie.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Wybierz usługi i uprawnienia, które będą dodane do subskrypcji wraz z dodatkowym planem. Niektóre uprawnienia pozwalają subskrybentowi na modyfikację ustawień dostępnych usług (to znaczy właściwości hostingu, poczty itd.).',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Uprawnienia umożliwiają klientom zmianę określonych ustawień ich subskrypcji. Po utworzeniu subskrypcji Plesk stosuje wstępnie wybrane wartości z planu do ustawień, które klient może zmienić. Później aktualizacja planu lub zastosowanie planu dodatkowego nie zastępuje zmian wprowadzonych przez klienta.',
    'service-plan.permissions.showMorePermissions' => 'Pokaż więcej dostępnych uprawnień',
    'service-plan.permissions.hideMorePermissions' => 'Pokaż mniej uprawnień',
    'service-plan.permissions.noShellManagement' => 'Niedozwolone',
    'service-plan.permissions.systemAccessLabel' => 'Zarządzanie dostępem do serwera poprzez SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Sprawia, że parametr hostingu "Dostęp SSH do powłoki shella dla użytkownika systemu subskrypcji" działa jako ustawienie początkowe.',

    'service-plan.resources-subscription.overusePolicy' => 'Polityka nadużyć',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Nadmiarowe zużycie jest niedozwolone',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Nie zezwalaj na nadużycie zasobów. Subskrypcja będzie automatycznie zawieszona, jeśli wykorzystanie zasobów przekroczy ograniczenia.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Nadmiarowe zużycie przestrzeni dyskowej i ruchu jest dozwolone',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Zezwalaj na nadużycie przestrzeni dyskowej i ruchu. Nie zezwalaj na nadużycie innych zasobów.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Nadużycie jest dozwolone (nie zalecane)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Zezwalaj subskrybentowi na użycie większej ilości zasobów niż te przyznane na początku wraz z subskrypcją.',
    'service-plan.resources-subscription.overuseNotify' => 'Powiadom mnie przez e-mail o przypadkach nadużyć.',
    'service-plan.resources-subscription.oversellPolicy' => 'Regulamin sprzedaży ponad posiadane zasoby',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Sprzedaż ponad posiadany zapas jest dozwolona',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Sprzedaż ponad posiadany zapas pozwala sprzedawcy na sprzedaż większej ilości zasobów niż te przyznane zgodnie z planem. Jeżeli sprzedaż ponad posiadany zapas jest dozwolona, sprzedawca powinien kierować się rzeczywistym wykorzystaniem zasobów, a nie ilością zasobów przyznaną na początku.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Sprzedaż ponad posiadany zapas jest zabroniona',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Jeśli sprzedaz ponad posiadane zasoby jest niedozwolona, sprzedawca może sprzedać tylko tyle zasobów, ile przyznano mu na początku wraz z subskrypcją bez względu na rzeczywiste wykorzystanie tych zasobów.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Zdefiniuj ograniczenia wykorzystania zasobów dostępnych w subskrypcji.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Pokaż więcej dostępnych zasobów',
    'service-plan.resources-subscription.hideMoreResources' => 'Pokaż mniej zasobów',

    'service-plan.resources.overusePolicy' => 'Polityka nadużyć',
    'service-plan.resources.overusePolicyNotAllowed' => 'Nadmiarowe zużycie jest niedozwolone',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Nie zezwalaj na nadużycie zasobów. Subskrypcja będzie automatycznie zawieszona, jeśli wykorzystanie zasobów przekroczy ograniczenia.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Nadmiarowe zużycie przestrzeni dyskowej i ruchu jest dozwolone',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Zezwalaj na nadużycie przestrzeni dyskowej i ruchu. Nie zezwalaj na nadużycie innych zasobów.',
    'service-plan.resources.overusePolicyAllowed' => 'Nadużycie jest dozwolone (nie zalecane)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Zezwalaj klientom na wykorzystanie większej ilości zasobów niż ta przyznana na początku wraz z planem.',
    'service-plan.resources.overuseNotify' => 'Powiadom mnie przez e-mail o przypadkach nadużyć.',
    'service-plan.resources.oversellPolicy' => 'Regulamin sprzedaży ponad posiadane zasoby',
    'service-plan.resources.oversellPolicyAllowed' => 'Sprzedaż ponad posiadany zapas jest dozwolona',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Sprzedaż ponad posiadany zapas pozwala sprzedawcy na sprzedaż większej ilości zasobów niż te przyznane zgodnie z planem. Jeżeli sprzedaż ponad posiadany zapas jest dozwolona, sprzedawca powinien kierować się rzeczywistym wykorzystaniem zasobów, a nie ilością zasobów przyznaną na początku.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Sprzedaż ponad posiadany zapas jest zabroniona',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Jeżeli sprzedaż ponad posiadany zapas jest zabroniona, sprzedawca może sprzedać tylko tyle zasobów, ile przyznano mu na początku, bez względu na rzeczywiste wykorzystanie zasobów.',
    'service-plan.resources.mainGroupTitle' => 'Zdefiniuj zasoby dostępne w planie.',
    'service-plan.resources.additionalGroupTitle' => 'Pokaż więcej dostępnych zasobów',
    'service-plan.resources.hideMoreResources' => 'Pokaż mniej zasobów',
    'service-plan.resources.allowSitebuilderUpsell' => 'Pozwól klientowi na tworzenie stron WWW przy pomocy Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'To ustawienie pozwala klientowi na tworzenie większej liczby stron WWW przy pomocy Presence Builder niż jest to określone w planie. Klient będzie musiał kupić te strony WWW, aby je opublikować.',

    'service-plan.servicePlanName' => 'Nazwa planu usługi',
    'service-plan.resellerPlanName' => 'Nazwa planu sprzedawcy',
    'service-plan.addonPlanName' => 'Nazwa dodatkowego planu',
    'service-plan.adminPlanPermissionsTab' => 'Narzędzia administracyjne',
    'service-plan.adminPlanPermissionsTabDescription' => 'Wybierz funkcje dostępne dla administratora, gdy włączony jest tryb ograniczonego dostępu.',
    'service-plan.hostingPermissionsTab' => 'Narzędzia hostingu',
    'service-plan.hostingPermissionsTabDescription' => 'Wybierz narzędzia i ustawienia hostingu dostępne dla administratora w widoku zaawansowanego użytkownika, gdy włączony jest tryb ograniczonego dostępu.',
    'service-plan.resourcesTab' => 'Zasoby',
    'service-plan.resourcesTabDescription' => 'Zdefiniuj zasoby dostępne w planie oraz politykę wykorzystania zasobów.',
    'service-plan.subscriptionResourcesTabDescription' => 'Zdefiniuj zasoby dostępne w subskrypcji oraz politykę wykorzystania zasobów.',
    'service-plan.hostingTab' => 'Parametry hosting',
    'service-plan.hostingTabDescription' => 'Określ parametry usługi hostingowej dostępnej w planie. Zauważ, że ustawienia hostingu określone w tym planie dodatkowym nie są zastosowane do subskrypcji, które otrzymały uprawnienia "Zarządzanie ustawieniami hostingu" w ramach planu usługi lub planu dodatkowego.',
    'service-plan.secureSettingsDescription' => 'Jeśli chcesz zapewnić najbezpieczniejszy hosting, %%link%%. Niektóre uprawnienia, jeśli nadane, pozwalają subskrybentom na zmianę tych ustawień. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'zastosuj bezpieczne ustawienia początkowe',
    'service-plan.secureSettingsHelpLink' => 'Dowiedz się więcej o ustawieniach bezpiecznego hostingu',
    'service-plan.mailTab' => 'Poczta',
    'service-plan.mailTabDescription' => 'Określ parametry usługi pocztowej dostępnej w planie.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Określ parametry usługi DNS dostępnej w planie.',
    'service-plan.performanceTab' => 'Wydajność',
    'service-plan.performanceTabDescription' => 'Określ parametry systemu wpływające na wydajność wszystkich usług dostępnych w planie.',
    'service-plan.permissionsTab' => 'Uprawnienia',
    'service-plan.miscTab' => 'Logi i statystyki',
    'service-plan.miscTabDescription' => 'Określ w jaki sposób statystyki i logi w subskrypcjach planów powinny być przechowywane. Zauważ, że te ustawienia nie synchronizują się w subskrypcjach.',
    'service-plan.miscTabAdminPlanDescription' => 'Określ, w jaki sposób statystyki i logi subskrypcji powinny być przechowywane.',
    'service-plan.extrasTab' => 'Dodatkowe usługi',
    'service-plan.extrasTabDescription' => 'Wybierz usługi, które powinny być dołączone do planu oprócz hostingu, DNS i usług pocztowych.',
    'service-plan.ipTab' => 'Adresy IP',
    'service-plan.ipTabDescription' => 'Zdefiniuj parametry zasobów IP dostępnych w planie.',
    'service-plan.applicationsTab' => 'Aplikacje',
    'service-plan.applicationsTabDescription' => 'Wybierz aplikacje dostępne w planie. Możesz udostępnić wszystkie aplikacje z Katalogu aplikacji oraz te, które wgrałeś na serwer lub wybrać aplikacje ręcznie. Jeśli chcesz udostępnić wszystkie aplikacje, nie musisz wykonywać żadnych działań w tej zakładce. Otwórz zakładkę Uprawnienia, wybierz opcję Dostęp do Katalogu aplikacji. Jeśli chcesz wybrać aplikacje ręcznie, możesz to zrobić w tej zakładce.',
    'service-plan.applicationsTabDescription-addon' => 'Wybierz aplikacje, które powinny być dostępne jako dodatki.',
    'service-plan.applicationsTabDescription-subscription' => 'Wybierz aplikacje dostępne w tej subskrypcji. Możesz udostępnić wszystkie aplikacje z Katalogu aplikacji oraz te, które wgrałeś na serwer lub wybrać aplikacje ręcznie. Jeśli chcesz udostępnić wszystkie aplikacje, nie musisz wykonywać żadnych działań w tej zakładce. Otwórz zakładkę Uprawnienia, wybierz opcję Dostęp do Katalogu aplikacji. Jeśli chcesz wybrać aplikacje ręcznie, możesz to zrobić w tej zakładce.',
    'service-plan.planSyncSubsriptionWarning' => 'Niektóre subskrypcje nie zostały zsynchronizowane z planem. Zostały oznaczone jako \'Niezsynchronizowane\' na liście subskrypcji. Aby ponownie synchronizować, wejdź na ogólną listę subskrypcji i kliknij przycisk Synchronizacja.',
    'service-plan.planSyncResellerWarning' => 'Niektórzy sprzedawcy nie zostali zsynchronizowani z planem. Zostali oznaczeni jako \'Niezsynchronizowani\' na liście sprzedawców. Aby ponownie synchronizować, wejdź na ogólną listę sprzedawców i kliknij przycisk Synchronizacja.',
    'service-plan.planSyncAdminWarning' => 'Nie udało się zastosować zmian do subskrypcji, poniewaz Plesk nie dostarcza niektórych usług i zasobów, na które wpłynęły te zmiany. Przyczyna: %%reason%%',
    'service-plan.duplicateName' => 'Plan o takiej nazwie już istnieje.',
    'service-plan.phpSettingsTab' => 'Ustawienia PHP',
    'service-plan.phpHandlerNotFound' => 'Nie można pobrać informacji o wersji PHP w tym planie. Zainstaluj go ponownie lub wybierz inną wersję PHP dla tego planu usług.',
    'service-plan.phpHandlerNotRegistered' => "Wersja PHP %%fullVersion%% nie jest zainstalowana. Skrypty PHP dla domen korzystających z tego planu usług będą niedostępne. Zainstaluj <nobr>wersję PHP %%fullVersion%%</nobr> lub wybierz inną wersję PHP dla tego planu usług.",

    'service-plan.phpSettingsTabDescription' => 'Tutaj możesz określić ustawienia PHP dla każdej subskrypcji, które zastępują ustawienia zdefiniowane w pliku php.ini obejmujące cały serwer. Może się to przydać, np. gdy chcemy ograniczyć zużycie zasobów systemowych przez skrypty PHP klientów. Klienci (jeśli jest to dozwolone) mogą zastąpić tę konfigurację PHP własną konfiguracją dla domeny. Kiedy ustawisz parametr na wartość domyślną, PHP użyje wartości parametru z konfiguracji PHP dla całego serwera. Należy pamiętać, że obsługiwane są następujące symbole zastępcze: {DOCROOT} i {WEBSPACEROOT}, które oznaczają katalog główny dokumentu domeny i katalog główny subskrypcji, która otrzymuje niestandardową konfigurację PHP; {TMP} oznacza katalog, w którym przechowywane są pliki tymczasowe. Uwaga: Poniższe ustawienia można zastąpić parametrami określonymi w plikach .htaccess, php.ini lub .user.ini.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Tutaj możesz określić ustawienia PHP dla każdej subskrypcji, które napiszą ustawienia PHP zdefiniowane w głównym planie usługi. Może to być przydatne, kiedy chcesz usunąć ograniczenia PHP ustawione w głównym planie usługi. Jesli ustawisz parametry na wartości domyślne, PHP wykorzysta wartości parametrów z konfiguracji PHP w planie usługi. Zauważ, że następujące symbole zastępcze są obsługiwane: {DOCROOT} ai {WEBSPACEROOT} oznaczają katalog root domeny i katalog root subskrypcji, które otrzymują spersonalizowaną konfigurację PHP; TMP oznacza katalog, który przechowuje pliki tymczasowe.',
    'service-plan.phpSettingsPhpVersion' => 'Twoja obecna wersja PHP to %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Tutaj możesz określić ustawienia PHP w presubskrypcji, które nadpiszą ustawienia zdefiniowane dla całego serwera w pliku php.ini. Jesli ustawisz parametry na wartości domyślne, PHP wykorzysta wartości parametrów z konfiguracji PHP na serwerze.',
    'service-plan.webServerSettingsTab' => 'Serwer WWW',
    'service-plan.webServerSettingsTabDescription' => 'Tutaj możesz okreslić ustawienia serwera sieciowego Apache dla planu usługi. Jeśli Apache jest uruchomiony z nginx jako początkowym serwerem (front-end), również możesz określić ustawienia nginx na tej stronie. Wszystkie nowoutworzone domeny otrzymają określone ustawienia. Jednak jeśli zmienisz te ustawienia, istniejące domeny nie otrzymają tych zmian.',
    'service-plan.servicesTab' => 'Usługi',
    'service-plan.servicesTabDescription' => 'Tutaj możesz określić usługi przypisane do planu usługi.',
    'service-plan.servicePropertiesTab' => 'Właściwości %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Tutaj możesz określić właściwości usługi %%serviceName%% przypisane do planu usługi.',
    'service-plan.longTaskWarning' => 'Masz %%subscriptionsCount%% subskrypcji w tym planie. Zauważ, że zadanie synchronizacji może zająć sporo czasu i dlatego zostanie wykonane w tle.',
    'service-plan.hostingParametersTab' => 'Parametry hosting',
    'service-plan.adminInfoSection' => 'Informacja dla administratora',
    'service-plan.descriptionInPanel' => 'Opis',
    'service-plan.longDescription' => 'Podany opis jest za długi.',
    'service-plan.conflictPermissions' => 'Nie udało się zapewnić następujących uprawnień, ponieważ są w konflikcie z planem sprzedawcy: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Typ uruchomienia',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automatycznie',
    'services.change-startup-type.manualStartupTypeLabel' => 'Ręcznie',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Zablokuj',
    'services.change-startup-type.autoActionError' => 'Nie udało się skonfigurować typu uruchomienia na \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Nie udało się skonfigurować typu uruchomienia na \'ręczny\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Nie udało się skonfigurować typu uruchomienia na \'zablokowano\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Przywróć ustawienia domyślne',
    'sessions.settings.restoreDefaultButtonDescription' => 'Przwróć parametry sesji do wartości domyślnych.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Parametry sesji mają wartości domyślne.',
    'sessions.settings.idleTime' => 'Czas bezczynności sesji',
    'sessions.settings.disableCheckSessionIp' => 'Zezwalaj na zmiany adresu IP podczas pojedynczej sesji',
    'sessions.settings.minuteShortTitle' => 'Min',

    'settings-ui.controls.title' => 'Kontrole',

    'settings-ui.interface-views.description' => "Istnieje wiele dostępnych interfejsów użytkownika. W zależności od używanego interfejsu, funkcjonalności i ustawienia mogą być zlokalizowane w różnych miejscach lub mogą być włączone/wyłączone. Różne interfejsy są przeznaczone dla różnych typów użytkowników.",
    'settings-ui.interface-views.panelSimpleLink' => 'Narzędzia i ustawienia> Ustawienia trybu ograniczonego',
    'settings-ui.interface-views.useCustomView' => 'Włącz tryb ograniczonego dostępu',
    'settings-ui.interface-views.useCustomViewHint' => 'Wybierz tę opcję, aby ograniczyć liczbę działań, które administrator może podjąć w panelu Plesk. Aby zmienić dostępność działań, przejdź do %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Ten widok najlepiej nadaje się do zarządzania witrynami internetowymi, ich plikami, bazami danych, kontami e-mail, aplikacjami internetowymi i innymi usługami.',
    'settings-ui.interface-views.selectUiModeTitle' => "Wybierz interfejs",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Widok super użytkownika (dla programistów i agencji internetowych)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Widok dostawcy usług (dla dostawców usług hostingowych)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Ten widok jest przeznaczony dla administratorów serwerów, którzy dostarczają i sprzedają usługi hostingowe swoim klientom za pomocą planów usług.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Ukryj elementy sterujące odbijania',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Ukrywa przycisk, który pozwala skonfigurować sposób przetwarzania poczty wysyłanej na nieistniejące adresy e-mail',

    'settings-ui.branding.description' => 'Spersonalizuj interfejs Plesk, zmieniając sposób wyświetlania strony na pasku tytułu przeglądarki i/lub zastępując logo Plesk w lewym górnym rogu.',
    'settings-ui.branding.buttonDefault' => 'Domyślne logo',
    'settings-ui.branding.sectionTitle' => 'Dostosuj tytuł',
    'settings-ui.branding.enableCustomTitle' => 'Włącz niestandardowy tytuł na stronach Plesk',
    'settings-ui.branding.customTitle' => 'Tekst paska tytułu',
    'settings-ui.branding.sectionLogo' => 'Dostosuj logo',
    'settings-ui.branding.enableCustomLogo' => 'Włącz niestandardowe logo panelu',
    'settings-ui.branding.logo' => 'Plik logo',
    'settings-ui.branding.logoUrl' => 'Logo URL',
    'settings-ui.branding.logoUrlEnabled' => 'Personalizuj',
    'settings-ui.branding.logoUrlDisabled' => 'Domyślny',
    'settings-ui.branding.sectionFavicon' => 'Dostosuj faviconę',
    'settings-ui.branding.enableCustomFavicon' => 'Włącz niestandardową faviconę',
    'settings-ui.branding.sectionFaviconDesc' => 'Ta sama favicona musi zostać przesłana w obu formatach, aby zapewnić lepszą obsługę w różnych przeglądarkach.',
    'settings-ui.branding.faviconSvg' => 'Plik SVG favicony',
    'settings-ui.branding.faviconSvgHint' => 'Dozwolony format: SVG',
    'settings-ui.branding.faviconIco' => 'Plik ICO favicony',
    'settings-ui.branding.faviconIcoHint' => 'Dozwolony format: ICO',
    'settings-ui.branding.show' => 'Pokaż',
    'settings-ui.branding.updateSuccess' => 'Zmieniono własności personalizacji Plesk.',
    'settings-ui.branding.sectionBackground' => 'Niestandardowe tło ekranu logowania',
    'settings-ui.branding.enableCustomBackground' => 'Włącz obraz tła',
    'settings-ui.branding.backgroundFile' => 'Obrazek tła',
    'settings-ui.branding.backgroundColor' => 'Kolor tła',
    'settings-ui.branding.backgroundResetColor' => 'Zresetuj',
    'settings-ui.branding.backgroundFit' => 'Dopasowanie tła',
    'settings-ui.branding.background.fit.fill' => 'Wypełnij ekran',
    'settings-ui.branding.background.fit.fit' => 'Dopasuj do ekranu',
    'settings-ui.branding.background.fit.center' => 'Wycentruj',
    'settings-ui.branding.background.fit.tile' => 'Kafelek',

    'sitebuilder.trial.description' => 'Ta strona pozwala na konfigurację trybu Try and Buy (poprzednio Customer Acquisition Scenario). W tym trybie klient może stworzyć stronę WWW przy pomocy wszystkich dostępnych w Presence Builderze funkcjonalności. Jednak publikacja testowych stron WWW nie jest dostępna dla klientów dopóki nie kupią planu usługi hostingowej lub dodatku do planu. Tryb Try and Buy może również być dostępny dla istniejących klientów w planie hostingowym lub w planie dodatkowym. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Więcej informacji znajdziesz w dokumentacji.',
    'sitebuilder.trial.lifetimeLabel' => 'Czas istnienia testowej strony WWW',
    'sitebuilder.trial.lifetimeUnits' => 'dni',
    'sitebuilder.trial.lifetimeDescription' => 'Tyle czasu powinno upłynąć zanim testowe strony WWW, które nie zostały kupione przez klientów, będą usunięte z serwera.',
    'sitebuilder.trial.signupLabel' => 'Uruchom publiczny dostęp do trybu testowego',
    'sitebuilder.trial.signupDescription' => 'Jeśli chcesz przyciągnąć klientów poprzez reklamowanie hostingu w Presence Builder i udostępnienie im wersji demo Presence Builder, uruchom publiczny dostęp do wersji testowej i opublikuj URL dostępu do wersji testowej na swojej stronie WWW.',
    'sitebuilder.trial.signupLinkLabel' => 'URL dostępu do trybu testowego',
    'sitebuilder.trial.signupLinkDescription' => 'Ten URL otwiera Presence Builder w trybie testowym. Opublikuj ten URL na swojej stronie, aby reklamować hosting w Presence Builder i przyciągnąć klientów.',
    'sitebuilder.trial.promotionLabel' => 'Wyświetl powiadomienia o trybie testowym w edytorze Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Użyj tej opcji, jeśli chcesz wyświetlić dodatkowe powiadomienia o Presence Builder pracującym w trybie testowym.',

    'update-settings.policyHintForPum' => 'Tutaj możesz skonfigurować automatyczne instalacje dla aktualizacji. E-mail z powiadomieniem może być wysłany, kiedy aktualizacje są dostępne dla ręcznych instalacji lub zostały zainstalowane automatycznie.',
    'update-settings.policyHint' => 'E-mail z powiadomieniem może być wysłany, kiedy aktualizacje są dostępne dla ręcznych instalacji lub zostały zainstalowane automatycznie.',
    'update-settings.branchDisabledDescription' => 'Nie powiadamiaj mnie o możliwości podniesienia parametrów',
    'update-settings.automaticPatchesInstallation' => 'Automatycznie zainstaluj aktualizacje Pleska (Zalecane)',
    'update-settings.automaticPatchesThirdParty' => 'Automatycznie instaluj aktualizacje zewnętrznych komponentów przesyłanych do Pleska',
    'update-settings.automaticSystemPackageUpdates' => 'Automatycznie instaluj pakiety aktualizacji systemowych',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Proszę zauważyć że to automatycznie zainstaluje aktualizacje komponentów stron trzecich Plesk',
    'update-settings.installerProxyMode' => 'Uzyskaj dostęp do Instalatora Plesk poprzez nazwę hosta i port Plesk',
    'update-settings.installerProxyModeHint' => 'Uzyskaj dostęp do interfejsu internetowego Instalatora Plesk bez konieczności otwierania dodatkowego portu TCP 8447 w zaporze ogniowej.',
    'update-settings.automaticPatchesNotification' => 'Powiadom o dostępnych i zainstalowanych aktualizacjach pakietu systemowego.',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Adres e-mail',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Częstotliwość e-maili z powiadomieniem',
    'update-settings.daily' => 'Dziennie',
    'update-settings.weekly' => 'Tygodniowo',
    'update-settings.generalSection' => 'Ogólny',
    'update-settings.notificationsSection' => 'Powiadomienia',
    'update-settings.safeUpdatesSection' => 'Bezpieczne aktualizacje',
    'update-settings.safeUpdatesSectionHint' => 'Plesk upewnia się, że aktualizacje pakietu systemu są instalowane z tego samego repozytorium, z którego pierwotnie instalowano pakiety. Takie aktualizacje uważane są za bezpieczne. Jeśli wyłączy się bezpieczne aktualizacje,manager pakietów systemu może zainstalować aktualizacje z jakiegokolwiek repozytorium w systemie.',
    'update-settings.safeUpdatesSectionWarn' => 'Zalecamy pozostawienie włączonych bezpiecznych aktualizacji, o ile nie jestes zaawansowanym użytkownikiem. Aktualizacje pakietów systemu z różnych repozytoriów moga negatywnie wpłynąć na funkcjonowanie Twego serwera.',
    'update-settings.allowSafeUpdates' => 'Włącz bezpieczne aktualizacje dla pakietów systemu',

    'requiredFields' => 'Wymagane pola',

    'ip-ban.banned-ip.ipAddress' => 'Adres IP',
    'ip-ban.banned-ip.hintIpAddress' => 'Adres IP lub maska ​​CIDR.',
    'ip-ban.banned-ip.banType' => 'Zablokuj adres IP: ',
    'ip-ban.banned-ip.banType_plesk-one-week-ban' => 'Na jeden tydzień',
    'ip-ban.banned-ip.banType_plesk-permanent-ban' => 'Na stałe',

    'server-mail-smarthost.settings.title' => 'Ustawienia inteligentnego hosta',
    'server-mail-smarthost.settings.useSmarthost' => 'Wysyłaj e-maile użytkowników przez inteligentny host',
    'server-mail-smarthost.configuration.title' => 'Konfiguracja inteligentnego hosta',
    'server-mail-smarthost.configuration.hostnameOrIP' => 'Nazwa hosta lub adres IP',
    'server-mail-smarthost.configuration.hostnameOrIP.unixHint' => 'Aby wyłączyć wyszukiwanie MX lub SRV, umieść nazwę hosta lub adres IP w nawiasach kwadratowych, na przykład [example.com]',
    'server-mail-smarthost.configuration.checkConnection' => 'Sprawdź połączenie',
    'server-mail-smarthost.configuration.port' => 'Port',
    'server-mail-smarthost.configuration.username' => 'Nazwa użytkownika',
    'server-mail-smarthost.configuration.password' => 'Hasło',
    'server-mail-smarthost.configuration.encryption' => 'Zaszyfrowane połączenie',
    'server-mail-smarthost.configuration.encryption.Unix.on' => 'Wymagane',
    'server-mail-smarthost.configuration.encryption.Unix.off' => 'Niewymagana',
    'server-mail-smarthost.configuration.encryption.Windows.off' => 'Żaden',
    'server-mail-smarthost.configuration.encryption.Windows.tls' => 'TLS',
    'server-mail-smarthost.configuration.encryption.Windows.ssl' => 'SSL',
    'server-mail-smarthost.configuration.authRequired' => 'Autentykacja wymagana',
    'server-mail-smarthost.configuration.checkConnection.success' => 'Połączenie z inteligentnym hostem zostało nawiązane.',
    'server-mail-smarthost.success' => 'Konfiguracja inteligentnego hosta została zmieniona.',
    'server-mail-smarthost.settings.noteTitle' => 'Uwaga:',
    'server-mail-smarthost.settings.note' => '%%title%% Jeśli skonfigurujesz wysyłanie poczty za pośrednictwem inteligentnego hosta, musisz ręcznie zaktualizować SPF i inne powiązane rekordy DNS w szablonie DNS oraz w strefach DNS istniejących domen. Jest to konieczne, aby zapobiec błędom weryfikacji poczty wysyłanej za pośrednictwem inteligentnego hosta. %%link%%',
    'server-mail-smarthost.settings.noteLinkTitle' => 'Więcej szczegółów.',
];