<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Arquivos de log",
    'action-log.fromDate' => "De:",
    'action-log.toDate' => "Para:",
    'action-log.clearLog' => "Limpar log",
    'action-log.downloadLog' => "Download",
    'action-log.loggedActions' => "Ações registradas",
    'action-log.storeLogsInDb' => "Registros da loja no banco de dados",
    'action-log.storeNumber' => "Entradas",
    'action-log.dontRemoveRecs' => "Não remova os registros",
    'action-log.confirmCleanLog' => "Tem certeza de que deseja excluir os registros de ação selecionados?",
    'action-log.incorrectDate' => "Data inválida especificada.",
    'action-log.incorrectNumPeriods' => "Período de rotação inválido especificado.",
    'action-log.incorrectNumRecords' => "Número inválido de registros especificado.",
    'action-log.yes' => "Sim",
    'action-log.no' => "Não",
    'action-log.mixed' => "(misturado)",
    'action-log.period' => "Período",
    'action-log.invalidDatePeriod' => "Período de data inválido",
    'action-log.submitDone' => "As alterações nas configurações do registro de ação foram salvas.",
    'action-log.clearDone' => "Log de ação limpo.",
    'action-log.periodDay' => "dias",
    'action-log.periodWeek' => "semanas",
    'action-log.periodMonth' => "meses",

    'admin-info.adminInfoSection' => 'Informação para o administrador',
    'admin-info.description-admin' => 'Descrição do Administrador',
    'admin-info.description-reseller' => 'Descrição do revendedor',
    'admin-info.description-owner' => 'Descrição do proprietário',
    'admin-info.description' => 'Descrição',
    'admin-info.descriptionSuccess' => 'A descrição foi atualizada.',
    'admin-info.longDescription' => 'A descrição especificada é muito longo. Ele não pode ter mais que %%max%% símbolos.',
    'admin-info.add' => 'Adicionar descrição',
    'admin-info.edit' => 'Editar',
    'admin-info.remove' => 'Remover',
    'admin-info.confirmOnRemove' => 'Você quer remover esta descrição?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% do cliente %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% do revendedor %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% da assinatura %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% da/do %%name%%',
    'admin-info.popupHint-admin' => 'Essa descrição é visível somente para o administrador.',
    'admin-info.popupHint-reseller' => 'Essa descrição é visível somente para o revendedor e o administrador.',
    'admin-info.popupHint-owner' => 'Essa descrição é visível para o seu autor e para o autor do provedor de hospedagem.',
    'admin-info.customerDescriptionHint' => 'Clientes não podem ver essa descrição.',
    'admin-info.subscriptionDescriptionHint' => "Esta informação é visível apenas para o provedor de hospedagem (administrador do Plesk ou revendedor).",

    'apache-settings.formGeneralHint' => 'Aqui, você pode especificar as configurações do servidor da internet Apache para este site.  A configuração Apache customizada é útil, por exemplo, quando você deseja usar um novo tipo de arquivos de índice no seu site ou para associar um determinado tipo MIME com determinadas extensões de nome de arquivos. O valor-padrão significa que o Apache usará a diretiva correspondente de sua configuração do servidor. Se o Apache estiver executando com o nginx como servidor frontend, você também poderá especificar as configurações do nginx nesta página.',
    'apache-settings.general' => 'Configurações Apache comuns',
    'apache-settings.example' => "Por exemplo:\n%%example%%",
    'apache-settings.settingOn' => 'Ligar',
    'apache-settings.settingOff' => 'Desligado (Padrão)',
    'apache-settings.settingDefault' => 'Padrão',
    'apache-settings.settingCustom' => 'Inserir valor customizado',
    'apache-settings.mimeTypes' => 'Tipos de MIME',
    'apache-settings.mimeTypesExample' => "texto/simples .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'Os tipos MIME associam extensões de arquivo a tipos de arquivo. Normalmente, isso é usado para criar uma extensão de arquivo personalizada para tipos de arquivo comuns.',
    'apache-settings.handlers' => 'Handlers',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Os manipuladores do Apache definem como o servidor da Web processa arquivos com determinadas extensões quando são solicitados. Por exemplo, a string 'php-script .script' significa que o Apache manipulará arquivos .script como scripts php.",
    'apache-settings.deny' => 'Negar acesso ao site',
    'apache-settings.allow' => 'Excluindo',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nOs hosts e as redes especificadas são proibidos de acessar o site. Utilize o '*' para rejeitar todas as conexões.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nOs hosts e as redes especificadas são permitidos para acessar o site.",
    'apache-settings.directoryIndex' => 'Arquivos de índice',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "O Apache procurará os arquivos especificados quando a página de índice do website for solicitada.",
    'apache-settings.expires' => 'Expira em',
    'apache-settings.expiresStaticOnly' => 'resposta com cabeçalhos Expira em somente para arquivos estáticos',
    'apache-settings.expiresFullDescription' => 'O servidor Web irá adicionar os cabeçalhos de resposta “Expira em” às páginas da Web. O carimbo de data/hora de expiração é obtido ao adicionar a quantidade de tempo especificada acima ao tempo em que uma página da Web é solicitada.',
    'apache-settings.expiresStaticOnlyDescription' => 'O cabeçalho "Expira em" será adicionado apenas nos arquivos estáticos. Os arquivos considerados estáticos são controlados pelas opções "Processamento de arquivos estáticos inteligentes" e "Servir arquivos estáticos diretamente pelo nginx".',
    'apache-settings.expiresUnitDays' => 'dias',
    'apache-settings.expiresUnitHours' => 'horas',
    'apache-settings.expiresUnitMinutes' => 'minutos',
    'apache-settings.expiresUnitSeconds' => 'segundos',
    'apache-settings.headers' => 'Cabeçalhos adicionais',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "O servidor web adicionará os cabeçalhos de resposta HTTP especificados.",
    'apache-settings.restrictFollowSymLinks' => 'Restringir habilidade de seguir links simbólicos',
    'apache-settings.restrictFollowSymLinksDescription' => "Selecione esta opção para proibir que os usuários utilizem a diretiva FollowSymLink no arquivo .htaccess e remodele a segurança do servidor.",
    'apache-settings.nginx' => 'configurações do nginx',
    'apache-settings.nginxProxyMode' => 'Modo proxy',
    'apache-settings.nginxProxyModeDescription' => 'Pedidos proxy Nginx para Apache. Desligar para parar de usar o Apache.',
    'apache-settings.nginxTransparentMode' => 'Processamento de arquivos estáticos inteligentes',
    'apache-settings.nginxTransparentModeDescription' => 'Se desligado, Apache processará todas as solicitações para arquivos estáticos. nginx somente passarão as solicitações e as respostas sem modificação. Desative esta opção somente para soluções de problemas.',
    'apache-settings.nginxServeStatic' => 'Fornecer arquivos estáticos diretamente pelo nginx',
    'apache-settings.nginxStaticExtensions' => 'Especifique as extensões de arquivos separadas por espaços e pelo símbolo "|". As solicitações para esses arquivos serão tratadas por nginx e nunca por Apache. Cuidado: As regras de revisão não serão aplicadas.',
    'apache-settings.nginxServePhp' => 'Processar PHP por nginx',
    'apache-settings.nginxServePhpDescription' => 'Os arquivos PHP (.php) serão tratados por nginx e PHP-FPM. Se desativado, os arquivos PHP serão processados por Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Tamanho máximo permitido do corpo da solicitação HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Solicitações com corpo acima do limite serão descartadas com HTTP 413 Payload Too Large (configura o valor da diretiva nginx "client_max_body_size").',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'A opção é desabilitada globalmente por meio de um valor vazio/zero da diretiva "clientMaxBodySize" em panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Habilitar o cache do nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'O cache pode reduzir o tempo de resposta do site e carregar do servidor, deve ser usado com cuidado.',
    'apache-settings.nginxCacheSize' => 'Tamanho da memória cache',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Tempo limite de cache',
    'apache-settings.nginxCacheTimeoutDays' => 'dias',
    'apache-settings.nginxCacheTimeoutHours' => 'horas',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minutos',
    'apache-settings.nginxCacheTimeoutSeconds' => 'segundos',
    'apache-settings.nginxCacheKey' => 'Chave de cache',
    'apache-settings.nginxCacheCookies' => 'Solicitações de cache utilizado cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Desativar o armazenamento em cache para os locais',
    'apache-settings.nginxCacheBypass' => 'Ignorar cache quando',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'Os cabeçalhos de autorização HTTP nocache são recebidos no pedido',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'Os cabeçalhos de autorização HTTP são recebidos no pedido',
    'apache-settings.nginxCacheBypassGetNocache' => 'O parâmetro GET nocache é recebido no pedido',
    'apache-settings.nginxCacheUseStale' => 'Retorna registros obsoletos em cache',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream retorna o erro do servidor 5xx',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream retorna o erro do cliente 4xx',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Cache está sendo atualizado',
    'apache-settings.additional' => 'Diretivas Apache adicionais',
    'apache-settings.additionalSettingsDescription' => 'Se não for possível encontrar configurações específicas, adicione-as nos campos abaixo. Essas configurações anularão as diretivas Apache do servidor. As diretivas do primeiro campo são usadas quando um visitante acessa o site pelo HTTP. O segundo campo contém as diretivas para HTTPS. Geralmente, você deve adicionar suas diretivas em ambos os campos. Use a mesma sintaxe que você usa para httpd.include. Por exemplo, se você deseja configurar uma página de erro customizada, adicione a linha: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Diretivas adicionais para HTTP',
    'apache-settings.additionalSslSettings' => 'Diretivas adicionais para HTTPS',
    'apache-settings.additionalSettingsError' => 'Configuração Apache inválida: %%error%%',
    'apache-settings.rollbackFailed' => 'Não foi possível usar o arquivo de configuração Apache atual e voltar para a versão anterior do arquivo, pois ambos contêm configuração inválida.',
    'apache-settings.additionalNginx' => 'Diretivas nginx adicionais',
    'apache-settings.additionalNginxSettingsDescription' => 'Aqui, você pode especificar as configurações para o servidor proxy reverso nginx que executa à frente do Apache. Suas diretivas anularão a configuração nginx do servidor. Por exemplo, talvez você queira alterar o tempo limite de conexão ou compactar as solicitações com o gzip. Use a mesma sintaxe que você usa para nginx.conf. Por exemplo, se você deseja compactar todas as solicitações de proxy com o gzip, adicione a linha: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Diretivas nginx adicionais',
    'apache-settings.additionalNginxSettingsError' => 'Configuração nginx inválida: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Não foi possível usar o arquivo de configuração nginx atual e voltar para a versão anterior do arquivo, pois ambos contêm configuração inválida.',
    'apache-settings.clearCache' => 'Limpar cache',
    'apache-settings.clearCacheHint' => 'Limpe o cache do nginx para %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'O cache foi limpo com sucesso',

    'backup.backup-password-protection.securitySettingsSection' => 'Configurações de segurança de backup',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Obter a senha a partir das configurações de armazenamentos Remotos',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Inserir senha manualmente',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Fornecer senha',
    'backup.backup-password-protection.backupPassword' => 'Senha',
    'backup.backup-password-protection.inputPasswordType' => 'Tipo de senha',
    'backup.backup-password-protection.confirmBackupPassword' => 'Repita a senha',
    'backup.backup-password-protection.backupPasswordHint' => ' Se inserir uma senha incorreta, o backup será restaurado com sucesso mas as senhas de usuário (com exceção de senhas nas contas do Panel) não serão compatíveis com as originais devido à decodificação errada. A lista de novas senhas serão disponibilizadas quando a restauração estiver terminada. Decodifique senhas de usuários. Se esqueceu sua senha de criptografia, limpe essa opção. As senhas de usuário (com exceção de senhas em contas de Panel) serão regeneradas.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Se as senhas de usuário no backup estiverem criptografadas, insira a senha que você utilizou para criptografia nos campos abaixo. Observe que, se uma senha incorreta for fornecida, o Plesk não restaurará o backup. Em vez disso, o backup será copiado para o armazenamento local.',

    'backup.conflict-database.dbMappingLegend' => 'Mapeamento do servidor de banco de dados',
    'backup.conflict-database.serverType' => 'Tipo de servidor',
    'backup.conflict-database.hostName' => 'Nome do host',
    'backup.conflict-database.port' => 'Porta',
    'backup.conflict-database.destinationDbServer' => 'Servidor de banco de dados de destino',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'O banco de dados não pode ser restaurado: Não há nenhum servidor de base de dados.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Upload do arquivo de mapeamento de IP',
    'backup.conflict-ip.ipMappingLegend' => 'Mapeamento de IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Salvar o mapeamento de IP atual no arquivo',
    'backup.conflict-ip.ipAddressNotFound' => 'Não existem endereços IP gratuitos deste tipo.',
    'backup.conflict-ip.sharedIp' => 'compartilhado',
    'backup.conflict-ip.dedicatedIp' => 'dedicado',
    'backup.conflict-ip.fileNotFound' => 'O arquivo não pode estar vazio.',
    'backup.conflict-ip.invalidIpToMap' => 'Um valor inválido para um endereço de IP velho: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Um valor inválido para o novo endereço de IP: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'O endereço IP %%ip%% não foi encontrado no banco de dados.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Upload do arquivo de mapeamento de IP',
    'backup.conflict-ip.ipMappingFileHint' => 'O arquivo de mapeamento de IP é um arquivo de texto simples. Cada linha desse arquivo contém o mapeamento de IP no formato: <antigo endereço de IP> <novo endereço de IP>',
    'backup.conflict-ip.oldIp' => 'Endereços de IP antigos',
    'backup.conflict-ip.newIp' => 'Novos endereços de IP',

    'backup.copy-to-server.ignoreBackupSign' => 'Upload dos arquivos de backup sem uma assinatura válida',
    'backup.copy-to-server.wrongPassword' => 'A senha especificada está incorreta. Durante a restauração do backup, o Plesk o avisará para inserir a senha novamente.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'O arquivo de backup baixado %%fileName%% foi modificado, corrompido, criado em outro servidor ou em uma versão Plesk antiga que não suporta a assinatura de backups. Antes de restaurar os dados deste arquivo de backup, certifique-se de que você pode confiar na fonte deste arquivo.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Não foi possível fazer o upload o arquivo de backup %%fileName%%. O arquivo contém dados modificados ou corrompidos, ou foi criado em outro servidor ou em uma versão Plesk antiga. Para restaurar os dados deste arquivo, entre em contato com seu provedor de hospedagem.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Não foi possível fazer o upload o arquivo de backup %%fileName%%. O arquivo foi modificado, corrompido, criado em outro servidor ou em uma versão Plesk antiga que não suporta a assinatura de backups. Se você confia neste backup, selecione a opção "Upload dos arquivos de backup sem uma assinatura válida" e repita o upload.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Não é possível mover o backup selecionado %%fileName%% para o armazenamento do servidor. Erro: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "As partes seguintes do backup progressivo não foram copiadas:%%endl%%%%missedParts%%%%endl%%Copie as partes ausentes.",

    'backup.ftp-settings.isActive' => 'Usar armazenamento do FTP(S)',
    'backup.ftp-settings.host' => 'IP ou nome do host do servidor de FTP',
    'backup.ftp-settings.directory' => 'Diretório para armazenagem de arquivos de backup',
    'backup.ftp-settings.directoryHint' => 'Por exemplo, /minhapasta/meusbackups/',
    'backup.ftp-settings.ftpLogin' => 'Nome de usuário do FTP',
    'backup.ftp-settings.ftpPassword' => 'Senha do FTP',
    'backup.ftp-settings.usePassiveMode' => 'Utilizar o modo passivo',
    'backup.ftp-settings.useFtps' => 'Utilize FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'É proibido utilizar o servidor de FTP do Plesk local como um armazenamento remoto. Por favor, especifique um local remoto.',
    'backup.ftp-settings.warningHostIsLocal' => 'As configurações do armazenamento do FTP(S) foram ajustadas para armazenar backups no servidor onde seus arquivos de assinaturas estão localizados. Essa configuração não é recomendada em razão do risco de perda de dados e uso exagerado do espaço em disco.',
    'backup.ftp-settings.enterFtpLogin' => 'Insira um nome de usuário correto.',
    'backup.ftp-settings.enterFtpPassword' => 'Insira uma senha correta.',

    'backup.remote-settings.isActive' => 'Usar o armazenamento',
    'backup.remote-settings.initError' => 'Incapaz de iniciar página de configurações %%extName%%: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Configurações de segurança de backup',

    'backup.restore.detailsSection' => 'Detalhes',
    'backup.restore.contentInfoSection' => 'Conteúdo de backup',
    'backup.restore.restorationOptionsSection' => 'Opções de restauração',
    'backup.restore.emailNotification' => 'Quando a restauração estiver completa, envie uma notificação para',
    'backup.restore.comments' => 'Comentários',
    'backup.restore.creationDate' => 'Data de criação',
    'backup.restore.systemNotes' => 'Notas do sistema',
    'backup.restore.ownerAdmin' => 'Criador pelo administrador.',
    'backup.restore.ownerReseller' => 'Criado por um revendedor.',
    'backup.restore.ownerCustomer' => 'Criado pelo cliente.',
    'backup.restore.ownerServiceUser' => 'Criado por um usuário adicional.',
    'backup.restore.partOfParentBackup' => 'Parte do backup %%type%%',
    'backup.restore.server' => 'servidor',
    'backup.restore.reseller' => 'revendedor',
    'backup.restore.client' => 'cliente',
    'backup.restore.incremental' => 'Acréscimo.',
    'backup.restore.multiVolume' => 'Multivolume.',
    'backup.restore.backupSize' => 'Tamanho do backup',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (esta adição) + %%base%% (backup inicial) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (esta adição) + %%prev%% (adições anteriores) + %%base%% (backup inicial) = %%total%%',
    'backup.restore.download' => 'Download',
    'backup.restore.downloadHint' => 'Efetue o download do arquivo de backup para seu computador local.',
    'backup.restore.downloadDisabled' => 'O download dos arquivos de backup está indisponível temporariamente. Tente novamente mais tarde ou entre em contato com seu prestador de serviços.',
    'backup.restore.copy' => 'Copiar para armazenamento do servidor',
    'backup.restore.copyHint' => 'Copiar os arquivos de backup selecionados para o armazenamento do servidor.',
    'backup.restore.contentInfo' => 'O backup contém',
    'backup.restore.restoreButton' => 'Restaurar',
    'backup.restore.mail' => 'E-mail',
    'backup.restore.domainConfiguration' => 'Configuração de domínio',
    'backup.restore.virtualHost' => 'Conteúdo do host virtual',
    'backup.restore.database' => 'Bancos de dados',
    'backup.restore.serverConfiguration' => 'Configurações do servidor',
    'backup.restore.serverConfigurationLicense' => 'Chave de licença',
    'backup.restore.serverPersonalConfiguration' => 'Configuração da conta do administrador',
    'backup.restore.serverPersonalDomains' => 'Domínios do administrador',
    'backup.restore.serverPersonalClients' => 'Clientes do administrador',
    'backup.restore.resellers' => 'Revendedores',
    'backup.restore.resellerPersonalConfiguration' => 'Configuração de conta do revendedor',
    'backup.restore.resellerPersonalDomains' => 'Domínios do revendedor',
    'backup.restore.resellerPersonalClients' => 'Clientes do revendedor',
    'backup.restore.clientPersonalConfiguration' => 'Configuração da conta do cliente',
    'backup.restore.clientPersonalDomains' => 'Domínios do cliente',
    'backup.restore.restoreModifiedSection' => 'Restaure o arquivo de backup independente da assinatura corrompida',
    'backup.restore.restoreModifiedDump' => 'Restaurar este backup apesar de ele não ter uma assinatura válida',
    'backup.restore.resolutionPolicy' => 'Política de resolução',
    'backup.restore.resolutionPolicyDescription' => 'Conflitos relacionados ao tempo ocorrem quando o objeto restaurado já existe no sistema com uma data de modificação mais recente ou quando o objeto restaurado não está atualmente presente no sistema.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'A senha especificada está incorreta. O arquivo de backup será copiado para o armazenamento local do servidor.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Impossível restaurar os dados de backup. A senha especificada está incorreta.',
    'backup.restore.serverContentAndConfiguration' => 'Configuração do servidor e conteúdo',
    'backup.restore.serverConfigurationOnly' => 'Configuração do servidor',
    'backup.restore.resellerContentAndConfiguration' => 'Configuração da conta do revendedor e conteúdo',
    'backup.restore.resellerConfigurationOnly' => 'Configuração de conta do revendedor',
    'backup.restore.clientContentAndConfiguration' => 'Configuração da conta do cliente e conteúdo',
    'backup.restore.clientConfigurationOnly' => 'Configuração da conta do cliente',
    'backup.restore.domainContentAndConfiguration' => 'Configuração de domínio e conteúdo',
    'backup.restore.domainConfigurationOnly' => 'Configuração de domínio',
    'backup.restore.restoreType' => 'O que você quer restaurar?',
    'backup.restore.restoreTypeFull' => 'Todos os objetos (todo o sistema)',
    'backup.restore.restoreTypeGranular' => 'Objetos selecionados',
    'backup.restore.restoreObjectType' => 'Tipo de objeto para restaurar',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Assinatura',
    'backup.restore.restoreObjectTypeCustomers' => 'Cliente',
    'backup.restore.restoreObjectTypeResellers' => 'Revendedor',
    'backup.restore.restoreObjectTypeMailUsers' => 'Conta de e-mail',
    'backup.restore.restoreObjectTypeDatabases' => 'Banco de dados',
    'backup.restore.restoreObjectTypeCertificates' => 'Certificados SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'Sites',
    'backup.restore.restoreObjectTypeDnsZones' => 'Zona DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Mala direta',
    'backup.restore.restoreObjectTypeWebContent' => 'Arquivos de domínios',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Arquivos selecionados',
    'backup.restore.restoreSubscriptionLookup' => 'Assinatura',
    'backup.restore.restoreComponents' => 'Componentes para restauração',
    'backup.restore.errorLog' => 'Log de erros',
    'backup.restore.backupDetailsLogDoesntExist' => 'O servidor de log não está disponível.',
    'backup.restore.dumpFailedSection' => 'Log de erros',
    'backup.restore.dumpFailed' => 'Impossível restaurar os dados: O arquivo de backup é inválido.',
    'backup.restore.granularNotSupported' => 'Você pode selecionar apenas os objetos que deseja restaurar quando você estiver restaurando a partir de backups criados no Plesk 12.0 ou posterior.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Restauração de todos os dados dos backups não é suportado pela visualização do usuário com autorização do revendedor. Selecione os objetos para restaurar. Você pode alterar sua exibição da interface em %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Preferências de interface',
    'backup.restore.contentRestoreType' => 'Restaurar',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Apenas a configuração dos objetos selecionados',
    'backup.restore.contentRestoreTypeFull' => 'Configuração e conteúdo dos objetos selecionados',
    'backup.restore.errorWrongFormat' => 'Falha na restauração de backup: o arquivo contém formatação errada.',
    'backup.restore.errorContentError' => 'Falha na restauração de backup: o arquivo contém erros de conteúdo.',
    'backup.restore.warningSignError' => 'Impossível validar a assinatura do backup. O arquivo de backup pode ter sido modificado, corrompido, criado na versão Panel anterior ou em outro servidor Plesk.',
    'backup.restore.warningSignErrorNotAdmin' => 'Este backup pode ser restaurado apenas pelo administrador do Plesk.',
    'backup.restore.warningPartial' => "As partes seguintes do backup progressivo não foram encontradas:%%endl%%%%missedParts%%%%endl%%Nem todos os arquivos podem ser restaurados. Faça o upload das partes ausentes e tente restaurar novamente.",
    'backup.restore.warningDeprecatedBackupVersion' => 'O backup que você está tentando restaurar foi criado em uma versão Plesk não suportada e não pode ser restaurado. Use a extensão Plesk Migrator para transferir seus dados de antigas versões do Plesk.',
    'backup.restore.encryptionKeyError' => 'As senhas para uma ou mais contas neste backup não podem ser restauradas e serão redefinidas. Provavelmente este backup foi criado em um servidor Plesk diferente e criptografado com sua chave de criptografia.',
    'backup.restore.errorCorruptedContent' => 'Não foi possível restaurar os dados. Os arquivos a seguir estão corrompidos: ',
    'backup.restore.statusSection' => 'Status de backup',
    'backup.restore.statusDetails' => 'Detalhes do status',
    'backup.restore.restoreBlocked' => 'O backup não pode ser restaurado.',
    'backup.restore.restoreBlockedDescription' => 'O backup do tipo %%backupType%% não pode ser restaurado agora. Para restaurá-lo, faça o login como proprietário do backup e clique neste nome de backup no Gerenciador de Backup.',

    'backup.schedule.scheduleSection' => 'Cronograma',
    'backup.schedule.backupEnable' => 'Ative a tarefa de backup',
    'backup.schedule.backupPeriod' => 'Executar a tarefa de backup',
    'backup.schedule.on' => 'em',
    'backup.schedule.at' => 'em',
    'backup.schedule.every' => 'cada',
    'backup.schedule.hours' => '{period, plural, one {hora} other {horas}}',
    'backup.schedule.retainHours' => 'horas',
    'backup.schedule.useIncremental' => 'Utilizar um Backup Adicional',
    'backup.schedule.useIncrementalDisableHint' => 'O conteúdo do backup selecionado permite apenas a criação de um backup completo.',
    'backup.schedule.fullBackupPeriod' => 'Realizar backup completo',
    'backup.schedule.hourly' => 'Por hora',
    'backup.schedule.daily' => 'Diário',
    'backup.schedule.weekly' => 'Semanal',
    'backup.schedule.monthly' => 'Mensal',
    'backup.schedule.yearly' => 'Anual',
    'backup.schedule.days' => 'dias',
    'backup.schedule.weeks' => 'semanas',
    'backup.schedule.months' => 'meses',
    'backup.schedule.years' => 'anos',
    'backup.schedule.backupTimeDescription' => 'Fuso horário: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Fuso horário do sistema padrão',
    'backup.schedule.first' => 'primeiro',
    'backup.schedule.last' => 'último',
    'backup.schedule.dayOfMonth' => 'dia',
    'backup.schedule.email' => 'Se ocorrerem erros durante a execução dessa tarefa de backup, enviar um e-mail de notificação para',
    'backup.schedule.invalidFields' => 'Alguns campos estão vazios ou contêm um valor incorreto: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Número máximo de arquivos de backup completo a serem armazenados (incluindo backups agendados e manuais)',
    'backup.schedule.retainDumpFilesFor' => 'Manter backup completo para',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Deixar este campo em branco se você não quiser remover todos os backups automaticamente.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'O limite especificado pelo provedor de hospedagem para o armazenamento do servidor é %%max%%. Seu limite deve ser menor ou igual a %%max%%.',
    'backup.schedule.retainLimitedDescription' => 'O limite especificado pelo provedor de hospedagem para o armazenamento do servidor é {max, plural, one {# backup completo} other {# backups completos}} (incluindo todos os backups agendados e manuais).',
    'backup.schedule.backupToCloudIsNotAllowed' => 'O armazenamento de backups de assinaturas agendadas em um armazenamento em nuvem remoto é um recurso premium que pode ser adquirido na Plesk Online Store.',
    'backup.schedule.backupHourlyWarning' => 'Habilitar a opção de criação de backups por hora pode resultar em consumo aumentado dos recursos do servidor.',
    'backup.schedule.titleHourly' => 'Configurações de backup por hora',
    'backup.schedule.titleDaily' => 'Configurações de backup diário',
    'backup.schedule.titleWeekly' => 'Configurações de backup semanal',
    'backup.schedule.titleMonthly' => 'Configurações de backup mensal',
    'backup.schedule.titleCustom' => 'Configurações de backup personalizado',

    'backup.secure-backup.hint' => 'Você pode usar uma senha para criptografar as senhas dos usuários contidas no banco de dados Plesk em um backup. Observe que restaurar um backup protegido por senha sem fornecê-la fará com que o Plesk gere senhas de usuário aleatoriamente.',
    'backup.secure-backup.hintAdmin' => 'Você pode criptografar senhas do banco de dados Plesk contidas em backups com a chave de criptografia Plesk ou com uma senha. A chave é exclusiva para cada instalação do Plesk. Os backups criptografados com a chave podem ser restaurados apenas na instalação do Plesk em que foram criados e não podem ser restaurados em outra instalação do Plesk. Observe que o Plesk não protege todos os dados confidenciais em um backup. Recomendamos que você armazene backups no armazenamento em nuvem remoto e ative a criptografia de backup no lado do armazenamento em nuvem.',
    'backup.secure-backup.usePasswordProtection' => 'Utilize senha de proteção (recomendado).',
    'backup.secure-backup.backupPasswordSource' => 'Tipo de senha',
    'backup.secure-backup.pleskKey' => 'Chave de criptografia do Plesk',
    'backup.secure-backup.userPassword' => 'Senha especificada',
    'backup.secure-backup.password' => 'Senha',
    'backup.secure-backup.passwordConfirmation' => 'Repita a senha',

    'backup.subform.settingsSection' => 'Configurações de backup',
    'backup.subform.prefix' => 'Acrescentar o prefixo ao nome do backup',
    'backup.subform.comment' => 'Comentários',
    'backup.subform.splitSize' => 'Criar um backup multivolume, tamanho do volume (MB)',
    'backup.subform.repository' => 'Armazenar em',
    'backup.subform.repositoryDescription' => 'Configurações do armazenamento do FTP(S) não especificadas. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Armazenamento do servidor e %%name%%',
    'backup.subform.remoteRepositoryOption' => 'Armazenamento remoto',
    'backup.subform.remoteRepository' => 'armazenamento remoto',
    'backup.subform.remoteRepositoryText' => 'Selecionar armazenamento em nuvem remoto',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">Configurar armazenamento remoto</a> para armazenar seus backups na nuvem.',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">Configurar armazenamento FTP</a> para armazenar seus backups de forma externa.',
    'backup.subform.configureRemoteDesc' => '%%link%% para manter seus backups na nuvem.',
    'backup.subform.configureRemoteLink' => 'Configurar armazenamento remoto',
    'backup.subform.configureFtpDesc' => '%%link%% para manter seus backups de forma externa.',
    'backup.subform.configureFtpLink' => 'Configurar armazenamento no FTP',
    'backup.subform.repositoryConfigure' => 'Configurar',
    'backup.subform.email' => 'Quando a tarefa de backup estiver concluída, envie um e-mail de notificação para',
    'backup.subform.contentSection' => 'Conteúdo de backup',
    'backup.subform.domainConfiguration' => 'Configuração',
    'backup.subform.domainConfigurationVhost' => 'Os arquivos e bancos de dados',
    'backup.subform.domainConfigurationFile' => 'Arquivos do usuário',
    'backup.subform.domainConfigurationDatabase' => 'Bancos de dados',
    'backup.subform.domainConfigurationMail' => 'Mensagens de e-mail',
    'backup.subform.content' => 'Fazer backup',
    'backup.subform.backupAll' => 'Todas as configurações e conteúdos',
    'backup.subform.backupConfiguration' => 'Apenas configuração',
    'backup.subform.backupVhost' => 'Toda a configuração e conteúdo, exceto mensagens de e-mail',
    'backup.subform.backupMailFile' => 'Toda a configuração e conteúdo, exceto bancos de dados do usuário',
    'backup.subform.backupMailDatabase' => 'Toda a configuração e conteúdo, exceto arquivos do usuário',
    'backup.subform.backupMail' => 'Apenas configuração e mensagens de e-mail',
    'backup.subform.backupDatabase' => 'Apenas a configuração e os bancos de dados do usuário',
    'backup.subform.backupFile' => 'Apenas a configuração e os arquivos do usuário',
    'backup.subform.mssqlNativeBackup' => 'Utilizar a funcionalidade de backup MS SQL nativo se possível',
    'backup.subform.mssqlNativeBackupAdmin' => 'Utilizar a funcionalidade de backup MS SQL nativo (Para bancos de dados remotos, certifique-se de configurar as configurações do backup do servidor remoto MS SQL em Ferramentas e Configurações> Servidores do Banco de Dados)',
    'backup.subform.localRepository' => 'Armazenamento do servidor',
    'backup.subform.localRepositoryPath' => 'Armazenamento do servidor em %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Armazenamento do FTP(S) em %%uri%% <a href="%%link%%">Alterar Configurações</a>',
    'backup.subform.ftpRepositoryText' => 'Armazenamento do FTP(S) em %%uri%%',
    'backup.subform.type' => 'Tipo',
    'backup.subform.typeFullBackup' => 'Completo',
    'backup.subform.typeIncremental' => 'Acréscimo',
    'backup.subform.typeIncrementalDescription' => 'Faça o backup de dados de hospedagem da web e e-mail que foram alterados desde o último backup (os backups dos bancos de dados são sempre feitos por completo).',
    'backup.subform.incrementalNotAvailable' => 'Para criar backups adicionais, crie primeiro um backup completo.',
    'backup.subform.excludeLogs' => 'Excluir arquivos de registro',
    'backup.subform.excludeFiles' => 'Excluir arquivos específicos dentro de webspaces.',
    'backup.subform.excludeFilesDescription' => 'Você pode excluir apenas arquivos em webspaces. Especifique o caminho ou caminhos relacionados à raiz do webspace, separando os arquivos individuais com vírgulas. É permitido utilizar o símbolo da máscara (p. ex. /somedir/log*).',

    'backup.upload.uploadHint' => 'Aqui você pode fazer o upload de arquivos de backup para armazenamento do Plesk. O tamanho máximo do arquivo é limitado a dois gigabytes.',
    'backup.upload.backupFile' => 'Arquivo de backup',
    'backup.upload.removeLink' => 'Remover',
    'backup.upload.addFileLink' => 'Efetue o upload de mais arquivos',
    'backup.upload.backupSecuritySettings' => 'Configurações de segurança de backup',
    'backup.upload.signatureHint' => 'O Plesk verifica os arquivos de backup para uma estrutura e assinatura válida. Os arquivos que foram modificados, corrompidos ou criados em outro servidor não são confiáveis. A opção abaixo permite que você restaure os dados destes arquivos. Selecione esta opção se você confia na fonte de backup, porque fazer o upload de um arquivo destes pode comprometer a segurança ou interromper a operação do servidor. Observação: Os arquivos de backup feitos nas versões Plesk anteriores à 11.5 são considerados como não confiáveis porque não possuem assinaturas. Certifique-se de restaurar esses arquivos se você confia em sua fonte.',
    'backup.upload.ignoreSign' => 'Upload dos arquivos de backup sem uma assinatura válida',
    'backup.upload.passwordHint' => 'Se as senhas de usuário no backup estiverem criptografadas, insira a senha que você utilizou para criptografia nos campos abaixo. Observe que, se você colocar uma senha incorreta, o Plesk o advertirá, mas fará o upload do backup no servidor mesmo assim. Durante a restauração do backup, será solicitado que insira a senha novamente.',
    'backup.upload.alreadyExistsWarning' => 'O arquivo de backup %%fileName%% já existe no armazenamento local do servidor.',
    'backup.upload.incorrectPasswordWarning' => 'A senha especificada está incorreta. Durante a restauração do backup, o Plesk o avisará para inserir a senha novamente.',
    'backup.upload.deprecatedDumpError' => 'O backup que você está tentando fazer o upload foi criado em uma versão Plesk não suportada e não pode ser importado. Use a extensão Plesk Migrator para transferir seus dados de antigas versões do Plesk.',
    'backup.upload.mailFormatWarning' => 'O upload do arquivo de backup %%fileName%% para o armazenamento foi concluído. Importante: O arquivo de backup %%fileName%% contém conteúdo de e-mail que não será restaurado, pois o seu formato (Plesk 8.3 - 8.6) não é suportado. Para ser capaz de restaurar o conteúdo de e-mail, faça o backup utilizando a ferramenta Plesk Backup, selecione a opção Efetuar o backup das caixas de e-mail.&gt; com o arquivo de despejo restaurado para qualquer servidor de e-mail.',
    'backup.upload.corruptedSignatureAdminWarning' => 'O arquivo de backup baixado (%%fileName%%) foi modificado, corrompido, criado em outro servidor ou em uma versão Plesk antiga que não suporta a assinatura de backups. Antes de restaurar os dados deste arquivo de backup, certifique-se de que você pode confiar na fonte deste arquivo.',
    'backup.upload.corruptedSignatureAdminError' => 'Não foi possível fazer o upload o arquivo de backup (%%fileName%%). O arquivo foi modificado, corrompido, criado em outro servidor ou em uma versão Plesk antiga que não suporta a assinatura de backups. Se você confia neste backup, selecione a opção "Upload dos arquivos de backup sem uma assinatura válida" e repita o upload.',
    'backup.upload.corruptedSignatureUserWarning' => 'O arquivo de backup baixado (%%fileName%%) contém dados modificados ou corrompidos, ou foi criado em outro servidor ou em uma versão Plesk antiga.',
    'backup.upload.corruptedSignatureUserError' => 'Não foi possível fazer o upload o arquivo de backup (%%fileName%%). O arquivo contém dados modificados ou corrompidos, ou foi criado em outro servidor ou em uma versão Plesk antiga. Para restaurar os dados deste arquivo, entre em contato com seu provedor de hospedagem.',
    'backup.upload.uploadError' => 'Não é possível fazer o upload do %%fileName%% para o armazenamento do servidor: %%error%%',
    'backup.upload.fileNotSelected' => 'Nenhum arquivo foi selecionado para upload. Selecione pelo menos um arquivo.',
    'backup.upload.missedPartsWarning' => "O upload das partes seguintes do backup progressivo não foi feito:%%endl%%%%missedParts%%%%endl%%Faça o upload das partes ausentes.",
    'backup.upload.unknownType' => 'Tipo de objeto desconhecido',
    'backup.upload.storageLink' => 'outro armazenamento',
    'backup.upload.anotherStorage' => 'A descarga foi carregada para %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'O revendedor %%name%% não foi criado. Criar primeiro para restaurar a informação atualizada.',
    'backup.upload.clientNotFound' => 'O cliente %%name%% não foi criado. Criar primeiro para restaurar a informação atualizada.',
    'backup.upload.domainNotFound' => 'O domínio %%name%% não foi criado. Criar primeiro para restaurar a informação atualizada.',

    'backup.web-content-dynamic.addButtonTitle' => 'Adicionar arquivos',
    'backup.web-content-dynamic.noItems' => 'Nenhum arquivo selecionado',
    'backup.web-content-dynamic.hint' => 'Use as caixas de seleção para selecionar os arquivos e pastas.',
    'backup.web-content-dynamic.title' => 'Selecione os arquivos',
    'backup.web-content-dynamic.columnName' => 'Nome',
    'backup.web-content-dynamic.columnChangeDate' => 'Modificado',
    'backup.web-content-dynamic.columnSize' => 'Tamanho',
    'backup.web-content-dynamic.columnPermissions' => 'Permissões',
    'backup.web-content-dynamic.columnUser' => 'Usuário',
    'backup.web-content-dynamic.columnGroup' => 'Grupo',
    'backup.web-content-dynamic.waitButtonTitle' => 'Aguarde',
    'backup.web-content-dynamic.loadingTitle' => 'Aguarde. Carregando...',

    'backup.invalidFields' => 'Alguns campos estão vazios ou contêm um valor incorreto.',
    'backup.notEnoughDiskSpace' => 'Não há espaço em disco suficiente no %%path%% para criar o backup. Pelo menos %%required%% GB é necessário espaço livre (%%available%% GB está disponível)',

    'change-subscriptions-owner.ownerSection' => 'Novo Proprietário',
    'change-subscriptions-owner.subscriptionsSection' => 'Assinaturas Selecionadas',
    'change-subscriptions-owner.owner' => 'Proprietário',
    'change-subscriptions-owner.subscriptionName' => 'Assinatura',
    'change-subscriptions-owner.ownerName' => 'Proprietário',
    'change-subscriptions-owner.currentIpAddress' => 'Endereços IP atuais',
    'change-subscriptions-owner.newIpAddress' => 'Novos endereços de IP',
    'change-subscriptions-owner.noIpAddress' => 'Nenhum endereço IP disponível',
    'change-subscriptions-owner.submit' => 'Reatribuir',
    'change-subscriptions-owner.warningCustom' => "A assinatura será desvinculada do plano de serviço atual e se tornará \"Personalizada\".",
    'change-subscriptions-owner.warningEmptyPool' => "O pool de IP do provedor do novo proprietário está vazio. Certifique-se de que o provedor tenha pelo menos um endereço IP no pool.",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, Disk I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Configure limites para o consumo dos recursos do sistema por uma assinatura. Plesk usa um recurso do kernel Linux chamado de controle de grupos (cgroups) para garantir que os limites não se excedam.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Limitar assinaturas individuais para a quantidade especificada de uso da CPU.',
    'cgroups-settings.cpuPeriodLimit' => 'Período para verificar o uso de CPU',
    'cgroups-settings.percentUsageDescription' => 'A quantidade total de tempo de CPU para o seu servidor é igual a %%total%%%%units%%',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Limitar assinaturas individuais para a quantidade especificada de uso da RAM. Observe que, se uma assinatura de exceder esse limite, o processo que consome mais será interrompido.',
    'cgroups-settings.ramPeriodLimit' => 'Período para verificar o uso de RAM',
    'cgroups-settings.diskSettings' => 'Disco I/O',
    'cgroups-settings.diskReadSettings' => 'Leitura de disco',
    'cgroups-settings.diskReadSettingsDescription' => 'Permitir que as assinaturas individuais usem somente a leitura do disco da largura da banda dentro do limite especificado.',
    'cgroups-settings.diskReadPeriodLimit' => 'Período para verificar o uso da Leitura em disco',
    'cgroups-settings.diskWriteSettings' => 'Gravação em Disco',
    'cgroups-settings.diskWriteSettingsDescription' => 'Permitir que as assinaturas individuais usem somente a gravação do disco da largura da banda dentro do limite especificado.',
    'cgroups-settings.diskWritePeriodLimit' => 'Período para verificar o uso da Gravação em disco',
    'cgroups-settings.limit' => 'Limite',
    'cgroups-settings.threshold' => 'Notificar quando excedido',
    'cgroups-settings.limitNotificationEnabled' => 'Notificação habilitada',
    'cgroups-settings.periodFiveMinutes' => '5 minutos',
    'cgroups-settings.periodHour' => '1 hora',
    'cgroups-settings.periodDay' => '1 dias (24 horas)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sec',

    'custom-button.privateLabel' => 'Mostre-me apenas',
    'custom-button.textLabel' => 'Rótulo do botão',
    'custom-button.tooltipLabel' => 'Texto da dica de ferramenta',
    'custom-button.iconLabel' => 'Imagem do plano de fundo',
    'custom-button.priorityLabel' => 'Prioridade',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Adicionar parâmetros a URL',
    'custom-button.placeLabel' => 'Localização',
    'custom-button.internalLabel' => 'Abrir a URL no Plesk',
    'custom-button.internalDescription' => 'O URL será aberto na mesma janela de navegador do Plesk.',
    'custom-button.noFrameLabel' => 'Não use quadros',
    'custom-button.noFrameDescription' => 'Se você adicionar um botão personalizado que leva a um serviço (como um aplicativo ou módulo do Plesk) no Painel do Cliente, pode especificar como esse serviço deve ser apresentado: em um quatro ou parte de um Plesk GUI.',
    'custom-button.urlParamLabel_dom_id' => 'Incluir a ID de assinatura, ID de domínio e ID de apelido de domínio',
    'custom-button.urlParamLabel_dom_name' => 'Incluir o nome de Domínio Primário',
    'custom-button.urlParamLabel_ftp_user' => 'Incluir o nome de usuário de FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Incluir senha FTP',
    'custom-button.urlParamLabel_cl_id' => 'Incluir a ID do cliente',
    'custom-button.urlParamLabel_cname' => 'Incluir o nome da empresa do cliente',
    'custom-button.urlParamLabel_pname' => 'Incluir o nome do contato do cliente',
    'custom-button.urlParamLabel_email' => 'Inclua o e-mail do cliente',
    'custom-button.buttonPlace_navigation' => 'Acesso comum',
    'custom-button.buttonPlace_admin' => 'Página inicial do administrador',
    'custom-button.buttonPlace_admin-settings' => 'Página de configurações e ferramentas de administração',
    'custom-button.buttonPlace_reseller' => "Página inicial do revendedor",
    'custom-button.buttonPlace_reseller-settings' => 'Página de utilidades e ferramentas de revendedor',
    'custom-button.buttonPlace_client' => 'Página inicial do cliente',
    'custom-button.buttonPlace_domain' => "Página de Websites e Domínios da Assinatura",
    'custom-button.buttonPlace_domain_powerUser' => "Página de Websites e Domínios do espaço Web",
    'custom-button.buttonPlace_domain-properties' => 'Ferramentas de web site',

    'database-server-change-password.adminPassword' => 'Senha do administrador',
    'database-server-change-password.success' => 'A senha do administrador foi atualizada com sucesso.',

    'database-server-create.general' => 'Geral',
    'database-server-create.type' => 'Tipo de servidor de banco de dados',
    'database-server-create.unixSocket' => '(conexão local)',
    'database-server-create.host' => 'Nome do host ou endereço IP',
    'database-server-create.port' => 'Número da porta',
    'database-server-create.portDescription' => 'Deixe em branco para o número da porta-padrão',
    'database-server-create.version' => 'Versão do servidor de banco de dados',
    'database-server-create.default' => 'Utilize este servidor como padrão para %%type%%',
    'database-server-create.externalConnections' => 'Permitir que o servidor MariaDB/MySQL local aceite conexões externas',
    'database-server-create.externalConnectionsDescription' => 'A alteração dessa configuração resultará na reinicialização do servidor MariaDB/MySQL local. Para habilitar o acesso remoto a outros servidores MariaDB/MySQL registrados no Plesk, altere sua configuração manualmente.',
    'database-server-create.authentication' => 'Autenticação',
    'database-server-create.authenticationAddDescription' => 'Especifique as credenciais do administrador do banco de dados, qual Plesk usará para acessar o servidor do banco de dados. Uma conta de administrador com essas credenciais deve constar no servidor de banco de dados.',
    'database-server-create.authenticationEditDescription' => 'Aqui você pode alterar as credenciais, qual Plesk usar para acessar o servidor do banco de dados. Essas credenciais devem corresponder às credenciais do administrador do banco de dados. Por exemplo, depois de alterar as credenciais do administrador no servidor de banco de dados, é necessário alterá-las no Plesk também.',
    'database-server-create.authenticationChangeDescription' => 'Aqui você pode alterar as credenciais, qual Plesk usar para acessar o servidor do banco de dados. Se você alterar o nome de usuário ou a senha abaixo, a conta de usuário com direitos administrativos será atualizada tanto no servidor de banco de dados quanto no Plesk.',
    'database-server-create.adminLogin' => 'Nome do usuário',
    'database-server-create.adminPassword' => 'Senha',
    'database-server-create.createSuccess' => 'O servidor de banco de dados foi criado com sucesso.',
    'database-server-create.createError' => 'O servidor de banco de dados foi criado com erro: %%error%%',
    'database-server-create.updateSuccess' => 'O servidor de banco de dados foi atualizado com sucesso.',
    'database-server-create.updateError' => 'O servidor de banco de dados foi atualizado com o erro: %%error%%.',
    'database-server-create.backupSettings' => 'Backup',
    'database-server-create.backupTempDir' => 'Diretório temporário',
    'database-server-create.backupTempDirDescription' => 'O caminho para uma pasta física no servidor remoto onde o servidor MS SQL está localizado. O servidor MS SQL deve poder acessar esta pasta para ler e gravar os arquivos de backup temporários. Por exemplo, C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => 'Diretório de rede temporário',
    'database-server-create.backupNetworkTempDirDescription' => 'O caminho para o compartilhamento de rede mapeado da pasta física está especificado acima. O Plesk irá acessar a pasta de compartilhamento para download e upload dos arquivos de backup. Por exemplo, \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'Nome do usuário',
    'database-server-create.backupNetworkUserDescription' => 'O nome de usuário de um usuário da rede criado no servidor da rede. Por exemplo, ServerName\\UserName. O usuário deve ter acesso à pasta compartilhada especificada acima.',
    'database-server-create.backupNetworkPassword' => 'Senha',

    'domain.connection-info.title' => 'Informação de conexão',
    'domain.connection-info.systemUserCredentials' => 'Credenciais de usuário do sistema',
    'domain.connection-info.systemUserCredentialsHint' => 'O acesso via FTP está sempre habilitado, o acesso via SSH ou Desktop Remoto - somente se o %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'permissão é concedida',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Seu SSH ou acesso à área de trabalho remota está habilitado e você não pode gerenciar seu estado.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Seu SSH ou acesso à área de trabalho remota está desabilitado e você não pode gerenciar seu estado.',
    'domain.connection-info.ipAddress' => 'Endereço IP',
    'domain.connection-info.username' => 'Nome do usuário',
    'domain.connection-info.password' => 'Senha',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Alteração de senha de usuário do sistema',
    'domain.connection-info.changePasswordTooltip' => 'Alterar senha',
    'domain.connection-info.newPassword' => 'Nova senha',
    'domain.connection-info.manageAccess' => 'Gerenciar acesso',
    'domain.connection-info.additionalFtpAccounts' => 'Contas de FTP adicionais',
    'domain.connection-info.database' => 'Banco de dados',
    'domain.connection-info.databaseHint' => '1 de %%number%% dos bancos de dados pertencentes à assinatura.',
    'domain.connection-info.databaseNotCreatedHint' => 'O banco de dados não foi criado.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'Servidor MS SQL',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Host',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Nome do banco de dados',
    'domain.connection-info.addDatabase' => 'Adicionar base de dados',
    'domain.connection-info.manageDatabases' => 'Gerenciar bancos de dados',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Alteração da senha do usuário do banco de dados',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Não se esqueça de atualizar a senha nos arquivos de configuração do seu aplicativo após alterá-la aqui.',
    'domain.connection-info.buttonSave' => 'Salvar',
    'domain.connection-info.buttonSaving' => 'Salvando...',
    'domain.connection-info.buttonCancel' => 'Cancelar',

    'domain.move.title' => 'Mover domínio %%name%%',
    'domain.move.hint' => 'O domínio será movido para uma nova assinatura com seu conteúdo, arquivos de configuração, arquivos de log e aplicativos APS.',
    'domain.move.hintMain' => 'O domínio será movido para uma nova assinatura com seu conteúdo, arquivos de configuração, arquivos de log, bancos de dados, usuários de banco de dados, usuários adicionais de FTP, tarefas agendadas, usuários SMB e aplicativos APS.',
    'domain.move.hintSubdomains' => 'Os subdomínio(s) %%subdomains%% será movido junto com o domínio pai.',
    'domain.move.hintAliases' => 'O(s) alias(es) do domínio %%aliases%% será movido juntamente com o domínio pai.',
    'domain.move.hintSubdomainsAndAliases' => 'O(s) subdomínio(s) %%subdomains%% e o(s) alias(es) de domínio %%aliases%% serão movidos juntos com o domínio pai.',
    'domain.move.labelDatabases' => 'Depois de mover o domínio, abra a guia "Bancos de dados" para mover os bancos de dados associados.',
    'domain.move.hintDatabases' => 'Se necessário, mova os bancos de dados separadamente.',

    'domain.move.Form.submitButton' => 'Mover',
    'domain.move.Form.cancelButton' => 'Cancelar',

    'domain.move.selectTarget' => 'Assinaturas disponíveis',
    'domain.move.nothingFound' => 'Nada encontrado',
    'domain.move.targetIsRequred' => 'Selecione a assinatura para mover o domínio para.',
    'domain.move.selectNewSubscription' => 'Criar uma nova assinatura',
    'domain.move.ipv4Address' => 'Endereço IPv4',
    'domain.move.ipv4AddressHint' => 'O endereço IP no qual o website está hospedado é um endereço de rede do host virtual do website.',
    'domain.move.ipv6Address' => 'Endereço IPv6',
    'domain.move.ipv6AddressHint' => 'O endereço IP no qual o website está hospedado é um endereço de rede do host virtual do website.',
    'domain.move.ipAddressIsNotSelected' => 'No mínimo um endereço IP deveria ser selecionado',
    'domain.move.username' => 'Nome do usuário',
    'domain.move.usernameHint' => 'A conta de usuário do sistema associada ao espaço web. Usado para acessar os arquivos hospedados via FTP e SSH.',
    'domain.move.usernameIsRequred' => 'Você deve fornecer um nome de usuário.',
    'domain.move.password' => 'Senha',
    'domain.move.passwordIsRequred' => 'Você deve fornecer uma senha.',
    'domain.move.noAvailableSubscriptions' => 'Nenhuma inscrição disponível',
    'domain.move.noWebHosting' => 'Nenhum usuário do sistema será criado neste momento porque o domínio não possui hospedagem na web.',

    'domain.rename.title' => 'Alterar nome de domínio',
    'domain.rename.titleAlias' => 'Alterar nome do alias de domínio',
    'domain.rename.hint' => 'Agora você está mudando o nome do domínio %%domainName%%',
    'domain.rename.hintAlias' => 'Agora você está alterando o nome do alias do domínio %%domainName%%',
    'domain.rename.name' => 'Novo nome de domínio',
    'domain.rename.nameAlias' => 'Novo nome de alias de domínio',
    'domain.rename.domainNameIsRequired' => 'Este campo obrigatório está vazio. Você precisa especificar um valor.',
    'domain.rename.submitButton' => 'Alterar',
    'domain.rename.submitButtonProgress' => 'Mudando',
    'domain.rename.successMessage' => 'Nome do domínio %%oldName%% foi alterado para %%newName%%.',
    'domain.rename.successMessageAlias' => 'Nome do alias do domínio %%oldName%% foi alterado para %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Cancelar',

    'domain.outgoing-messages.hint' => 'Aqui você pode alterar o limite do número de mensagens enviadas para este domínio. Não será possível enviar mais mensagens do que o limite especificado.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Padrão (%%domainOutgoingMessages%% mensagens por hora)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'mensagens por hora',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Limite das mensagens de saída',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Valor customizado para este domínio',

    'domain.tech-domain-name.title' => 'Selecione o seu nome de domínio',
    'domain.tech-domain-name.techDomainTitle' => 'Nome de domínio temporário',
    'domain.tech-domain-name.customDomainTitle' => 'Nome de domínio registrado',
    'domain.tech-domain-name.techDomainText' => 'Eu não tenho um nome de domínio registrado ainda',
    'domain.tech-domain-name.customDomainText' => 'Eu já tenho um nome de domínio registrado',
    'domain.tech-domain-name.techDomain' => 'Seu nome de domínio temporário',
    'domain.tech-domain-name.customDomain' => 'Nome de domínio registrado',
    'domain.tech-domain-name.domainName' => 'Nome do domínio',
    'domain.tech-domain-name.techDomainDesc' => 'Nomes de domínio temporários são usados para acessar seu site antes de você se registrar e comprar um nome de domínio adequado. Eles são fornecidos gratuitamente com as seguintes condições:',
    'domain.tech-domain-name.techDomainRandom' => 'Os nomes são gerados aleatoriamente',
    'domain.tech-domain-name.techDomainDns' => 'Eles estão hospedados na zona DNS .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Você pode mudar para um nome de domínio registrado a qualquer momento mais tarde, renomeando seu domínio nas configurações de domínio.',
    'domain.tech-domain-name.error' => 'Um erro inesperado ocorreu.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Você precisa selecionar o endereço IP.',
    'domain.tech-domain-name.generating' => 'Gerando...',

    'get-password.label' => 'Redefinir a senha',
    'get-password.text' => 'Digite seu endereço de e-mail ou nome de usuário registrado no Plesk e enviaremos um e-mail de redefinição de senha.',
    'get-password.emailLabel' => 'Endereço de e-mail',
    'get-password.loginLabel' => 'Nome do usuário',
    'get-password.send' => 'Enviar',
    'get-password.cancel' => 'Cancelar',
    'get-password.errorInvalidEmail' => 'O endereço de email não foi reconhecido. Por favor, verifique e tente novamente.',
    'get-password.messageSend' => "O e-mail de redefinição de senha foi enviado para o endereço de e-mail associado.\nCaso o e-mail não chegue, entre em contato com o administrador do Plesk.",

    'iis-settings.formGeneralHint' => 'Aqui, você pode especificar as configurações de servidor da internet do IIS para o seu site alterando os valores-padrão. A configuração IIS customizada é útil, por exemplo, quando você deseja usar um novo tipo de arquivos de índice no seu site ou para associar um determinado tipo MIME com determinadas extensões de nome de arquivos. Os valores-padrão são definidos pelo seu provedor de hospedagem.',
    'iis-settings.formGeneralHint_powerUser' => 'Aqui, você pode especificar as configurações do servidor da internet IIS para este site. A configuração IIS customizada é útil, por exemplo, quando você deseja usar um novo tipo de arquivos de índice no seu site ou para associar um determinado tipo MIME com determinadas extensões de nome de arquivos. Os valores-padrão significam que o IIS usará as diretivas correspondentes a partir de sua configuração-padrão.',
    'iis-settings.virtualDirectoryLoadError' => 'Não foi possível obter as propriedades do diretório virtual especificado: %%errorMessage%%',
    'iis-settings.general' => 'Configurações comuns',
    'iis-settings.example' => "Por exemplo:\n%%example%%",
    'iis-settings.settingOn' => 'Ligar',
    'iis-settings.settingOff' => 'Desligado (Padrão)',
    'iis-settings.settingDefault' => 'Padrão',
    'iis-settings.settingCustom' => 'Inserir valor customizado',
    'iis-settings.mimeTypes' => 'Tipos de MIME',
    'iis-settings.mimeTypesExample' => "texto/simples .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'Os tipos MIME associam extensões de arquivo a tipos de arquivo. Normalmente, isso é usado para criar uma extensão de arquivo personalizada para tipos de arquivo comuns.',
    'iis-settings.documents' => 'Documentos padrão',
    'iis-settings.documentsOff' => 'Desabilitado',
    'iis-settings.documentsCustom' => 'Insira valores',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Quando os navegadores não fornecem o nome de um documento em seu website, o IIS procurará os documentos padrão especificados e exibirá o primeiro encontrado. Se você não especificar os documentos padrão, mas ativar a navegação no diretório, a listagem do diretório será exibida nos navegadores em vez da página de índice.',
    'iis-settings.expires' => 'Expira em',
    'iis-settings.expiresFullDescription' => 'O servidor Web irá adicionar os cabeçalhos de resposta “Expira em” às páginas da Web. O carimbo de data/hora de expiração é obtido ao adicionar a quantidade de tempo especificada acima ao tempo em que uma página da Web é solicitada.',
    'iis-settings.expiresUnitDays' => 'dias',
    'iis-settings.expiresUnitHours' => 'horas',
    'iis-settings.expiresUnitMinutes' => 'minutos',
    'iis-settings.expiresUnitSeconds' => 'segundos',
    'iis-settings.headers' => 'Cabeçalhos adicionais',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'O servidor web adicionará os cabeçalhos de resposta HTTP especificados.',
    'iis-settings.directoryBrowsing' => 'Pesquisa no diretório',
    'iis-settings.directoryBrowsingDescription' => 'Permite que usuários vejam a listagem de diretórios do site em navegadores da web, por exemplo, quando a página de índice padrão não estiver disponível.',
    'iis-settings.securityTabDirectory' => 'Configurações de segurança do diretório',
    'iis-settings.allowAnonymous' => 'Autenticação anônima',
    'iis-settings.allowAnonymousDescription' => 'Autenticação anônima permite que usuários acessem o conteúdo público do seu site. O conteúdo protegido com senha do seu site, bem como o conteúdo protegido em um nível de sistema de arquivo, não estará disponível para usuários anônimos.',
    'iis-settings.allowWindows' => 'Autenticação do Windows',
    'iis-settings.allowWindowsDescription' => 'A autenticação do Windows (formalmente chamado NTLM) protege o conteúdo do seu site em nível de sistema de arquivo.',
    'iis-settings.requireSsl' => 'Exigir SSL/TLS',
    'iis-settings.requireSslDescription' => 'Se você habilitou o suporte ao SSL/TLS para o seu site, esta opção forçará os clientes da web (navegadores) a usarem somente as conexões HTTPS seguras.',
    'iis-settings.securityTabIpDeny' => 'Configurações de restrição de acesso',
    'iis-settings.deny' => 'Negar acesso ao site',
    'iis-settings.denyOff' => 'Padrão',
    'iis-settings.denyCustom' => 'Inserir valor customizado',
    'iis-settings.allow' => 'Excluindo',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nOs hosts e as redes especificadas são proibidos de acessar o site. Utilize o '*' para rejeitar todas as conexões.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nOs hosts e as redes especificadas são permitidos para acessar o site.",
    'iis-settings.dynamicIpSecurity' => 'Prevenindo ataques DoS por restrição de IP dinâmico do IIS',
    'iis-settings.isDenyByConcurrentRequests' => 'Negar endereços IP baseados no número de solicitações simultâneas de um endereço IP único',
    'iis-settings.maxConcurrentRequests' => 'Número máximo de solicitações simultâneas',
    'iis-settings.isDenyByRequestRate' => 'Negar endereços IP baseados no número de solicitações ao longo de um período de tempo',
    'iis-settings.maxRequests' => 'Número máximo de solicitações',
    'iis-settings.requestInterval' => 'Período de tempo (em milissegundos)',

    'ip-addresses-selector.ipAddress' => 'Endereço IP',
    'ip-addresses-selector.ipv4Address' => 'Endereço IPv4',
    'ip-addresses-selector.ipv4AddressHint' => "O endereço IP no qual o web site está hospedado é um endereço de rede do host virtual do web site.",
    'ip-addresses-selector.ipv6Address' => 'Endereço IPv6',
    'ip-addresses-selector.ipv6AddressHint' => "O endereço IP no qual o web site está hospedado é um endereço de rede do host virtual do web site.",
    'ip-addresses-selector.noIpAddressHint' => 'Nenhum',
    'ip-addresses-selector.shared' => 'compartilhado',
    'ip-addresses-selector.exclusive' => 'dedicado',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'O servidor de FTP não suporta IPv6. Efetue a alocação de um endereço IPv4 no mínimo; caso contrário, o usuário não poderá efetuar upload dos arquivos para o servidor via FTP.',

    'license-key-revert.description' => 'A chave de licença com as seguintes propriedades será restaurada:',
    'license-key-revert.submitButton' => 'Reverter',

    'license-key-upload.description' => 'Instale sua chave de licença inserindo um código de ativação.',
    'license-key-upload.descriptionWithFileUpload' => 'Instale sua chave de licença inserindo um código de ativação ou ao efetuar o upload de um arquivo de chave de licença.',
    'license-key-upload.type' => 'Escolha uma das seguintes opções:',
    'license-key-upload.code' => 'Insira o código de ativação',
    'license-key-upload.codeDescription' => 'Cole o código de ativação recebido.',
    'license-key-upload.file' => 'Efetue o upload do arquivo de chave de licença:',
    'license-key-upload.fileDescription' => 'Especifique o caminho para o arquivo que contém a chave de licença.',
    'license-key-upload.submitButton' => 'Instalar',

    'log-rotation.customLogsDescription' => 'Note que seus registros personalizados não estão alternados.',
    'log-rotation.logRotation' => 'Rotação de logs',
    'log-rotation.logRotationCondition' => 'Condição de rotação de logs',
    'log-rotation.logRotationBySize' => 'Por tamanho',
    'log-rotation.logRotationByTime' => 'Por horário',
    'log-rotation.logRotationDaily' => 'Diário',
    'log-rotation.logRotationWeekly' => 'Semanal',
    'log-rotation.logRotationMonthly' => 'Mensal',
    'log-rotation.logRotationSizeDescription' => 'Valor de tamanho deve ser entre %%min%% e %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Número máximo de arquivos de log',
    'log-rotation.compress' => 'Comprima os arquivos de log',
    'log-rotation.sendLogToEmail' => 'Após o Plesk recuperar os dados dos arquivos de registro de internet e servidores de FTP, envie um e-mail com os registros para este endereço',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'O período não pode ser maior que o limite de todo o servidor %%max%%.',

    'login.loginLabel' => 'Nome do usuário',
    'login.passwdLabel' => 'Senha',
    'login.localeLabel' => 'Idioma da interface',
    'login.defaultLocale' => 'Padrão',
    'login.loginButtonLabel' => 'Login',
    'login.enterUsername' => 'Entre com seu nome de usuário.',
    'login.enterPassword' => 'Coloque sua senha.',
    'login.whatUsernamePassword' => 'Qual nome de usuário e senha usar?',
    'login.forgotPasswordLabel' => 'Esqueceu sua senha?',
    'login.cookies' => 'Política de cookies no Plesk',
    'login.avoidSSLWarningsMsg' => 'Para evitar avisos de SSL durante o login no Plesk, use %%link%%',
    'login.digitalOceanMsg' => 'Novo no Plesk no DigitalOcean? Use "root" e a senha inserida ao criar este droplet para fazer login. %%link%%',
    'login.amazonLightsailMsg' => 'Novo no Plesk no Lightsail? Para fazer login no Plesk, acesse o servidor via SSH e use o comando "plesk login". %%link%%',
    'login.readGuide' => 'Leia o guia completo.',
    'login.mobileApplicationMessage' => 'Para uma experiência melhor, recomendamos que você instale o aplicativo %%name%%.',
    'login.mobileApplicationInstall' => 'Instalar agora',
    'login.mobileApplicationHide' => 'Não, obrigado',

    'force-reset-password.saveButton' => 'Salvar',
    'force-reset-password.title' => 'Alterar Sua Senha',
    'force-reset-password.passwordLabel' => 'Nova Senha',

    'panel-access.title' => 'Personalizando o URL do Plesk',
    'panel-access.hint' => 'Escolha URLs personalizadas para fazer login no Plesk. Isso não tira a possibilidade de efetuar login no Plesk via porta %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Mais detalhes',
    'panel-access.proxyEnabled' => 'Todos os domínios e subdomínios que resolvem para o endereço IP do servidor, mas não são usados para hospedar',
    'panel-access.proxyDomain' => 'O domínio ou subdomínio especificado que resolve para o endereço IP do servidor, mas não é usado para hospedar',
    'panel-access.proxyDisabled' => 'Nenhuma URL personalizada. Somente https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Salvar',
    'panel-access.Form.cancelButton' => 'Cancelar',

    'panel-access.domainNameIsRequired' => 'Você deve fornecer um nome de domínio.',
    'panel-access.successMessage' => 'A maneira selecionada de efetuar login foi aplicada.',
    'panel-access.notSupported' => 'O Plesk não suporta a forma de login selecionada.',
    'panel-access.notViaDomainName' => 'Para aplicar essa forma de login, escolha a primeira opção ("Todos os domínios e subdomínios..."), faça login no Plesk via https://%%domainName%%, e escolha a segunda opção.',
    'panel-access.notViaPort' => 'Para aplicar essa forma de login, faça login no Plesk via https://<server-IP-or-hostname>:%%httpsPort%% primeiro.',

    'php-settings.performance' => 'Configurações de desempenho e segurança',
    'php-settings.settings' => 'Configurações comuns',
    'php-settings.fastCgiSettings' => 'Configurações FastCGI',
    'php-settings.fpmSettings' => 'Configurações PHP-FPM',
    'php-settings.enableFastcgi' => 'Ativar configurações FastCGI',
    'php-settings.plainTextEditing' => 'Diretrizes adicionais',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'É possível definir quaisquer parâmetros de PHP digitando-os no campo abaixo. As diretrizes serão incluídas na configuração do PHP. Utilize a mesma sintaxe que você utiliza para php.ini. Por exemplo, para carregar automaticamente a extensão mSQL, adicione a linha: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Se não for possível encontrar parâmetros PHP específicos, adicione-os no campo abaixo. As diretrizes serão incluídas na configuração final PHP. Por exemplo, se deseja carregar automaticamente a extensão mSQL, adicionar a linha: extension=msql.so. Essas diretrizes adicionais serão consolidadas com as diretrizes do plano de serviço principal.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'É possível definir quaisquer parâmetros de PHP digitando-os no campo abaixo. As diretrizes serão incluídas na configuração do PHP. Utilize a mesma sintaxe que você utiliza para php.ini. Por exemplo, para carregar automaticamente a extensão mSQL, adicione a linha: extension=msql.so. Para personalizar a configuração do pool PHP-FPM, adicione o separador [php-fpm-pool-settings] e digite as configurações desejadas abaixo.',
    'php-settings.additionalConfigurationDirectives' => 'Diretrizes de configuração adicional',
    'php-settings.defaultValue' => 'Padrão',
    'php-settings.predefinedValue' => 'Selecione um valor',
    'php-settings.customValue' => 'Inserir valor customizado',
    'php-settings.phpSettingDescription_memory_limit' => 'A quantidade máxima de memória, em bytes, em permitida para que um texto seja atribuído.',
    'php-settings.phpSettingDescription_max_execution_time' => 'O tempo máximo, em segundos, permitido para que um texto seja executado antes de ser concluído.',
    'php-settings.phpSettingDescription_max_input_time' => 'O tempo máximo, em segundos, permitido para que um texto analise os dados de entrada.',
    'php-settings.phpSettingDescription_post_max_size' => 'O tamanho máximo, em bytes, de dados que podem ser enviados por e-mail com o método POST. Em geral, devem ser maior do que upload_max_filesize e menor do que memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'O tamanho máximo, em bytes, de um arquivo de upload.',
    'php-settings.phpSettingDescription_safe_mode' => 'O modo de segurança PHP coloca inúmeras restrições na execução de scripts, sobretudo por razões de segurança.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Os arquivos no diretório especificado podem ser executados por scripts PHP quando a diretiva safe_mode estiver em vigor. O diretório também deve estar em include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Os programas no diretório especificado podem ser executados por scripts PHP quando a diretiva safe_mode estiver em vigor.',
    'php-settings.phpSettingDescription_include_path' => 'A lista de diretórios onde os textos procuram por arquivos (similar à variável de CAMINHO do sistema). Para separar diretórios, usar dois pontos (:) no Linux e ponto e vírgula (;) no Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'O diretório para armazenar arquivos da sessão PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Parâmetros adicionais para a função de e-mail().',
    'php-settings.phpSettingDescription_register_globals' => 'Registra os conteúdos das variáveis EGPCS (Environment, GET, POST, Cookie, Server) como variáveis globais.',
    'php-settings.phpSettingDescription_open_basedir' => 'Os arquivos nos diretórios especificados podem ser acessados por scripts PHP. Para separar diretórios, usar dois pontos (:) no Linux e ponto e vírgula (;) no Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'O nível de relatório de erro.',
    'php-settings.phpSettingDescription_display_errors' => 'Determina se os erros devem ser exibidos como uma parte do resultado.',
    'php-settings.phpSettingDescription_log_errors' => 'Habilita o registro em log dos erros PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Permite que as funções de arquivo PHP recuperem os dados de locais remotos por meio de FTP ou HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Permite fazer upload de arquivos por meio de HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Permite a forma curta ( ) da tag aberta PHP\'s.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Configura a condição magic_quotes para as operações GPC (Get/Post/Cookie). Quando magaic_quotes estiver ativado, todas as aspas simples, aspas duplas, barra invertida, e caracteres especiais NULOS serão representados por sequência de escape com barra invertida automaticamente.',
    'php-settings.phpSettingDescription_disable_functions' => 'A diretriz permite que você desabilite determinadas funções. Ela recebe uma lista delimitada por virgulas dos nomes da função.',
    'php-settings.phpSupport' => 'Suporte a PHP',
    'php-settings.phpRunAs' => 'executar o PHP como',
    'php-settings.phpVersion' => 'Versão do PHP',
    'php-settings.phpHandlerOutdated' => '(Desatualizada)',
    'php-settings.phpHandlerDeprecated' => '(Descontinuada)',
    'php-settings.phpServedByApache' => 'servido por Apache',
    'php-settings.phpServedByNginx' => 'servido por nginx',
    'php-settings.phpSettingsPhpVersion' => 'Sua versão PHP é %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP está desativado.',
    'php-settings.phpHandlerTypeHint' => 'Abaixo encontram-se os detalhes da configuração do PHP do site. É possível alterar a configuração do PHP se o provedor de hospedagem conceder a permissão correspondente.',
    'php-settings.fpmDedicatedHandlerHint' => 'O uso desse manipulador aumenta a estabilidade de um website, mas também causa um consumo adicional de memória.',
    'php-settings.phpHandlerChangeHint' => 'Você alterou as configurações do manipulador PHP. Se você salvar essas alterações, os scripts PHP no seu site poderão parar por %%interval%% segundos devido à configuração do servidor.',
    'php-settings.phpHandlerOutdatedHint' => 'Para verificar se a nova versão do PHP está disponível, %%link%% e procure na categoria "Web Hosting" dos componentes do produto.',
    'php-settings.phpHandlerOutdatedHintLink' => 'abrir Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Saiba como escolher as configurações de PHP mais adequadas',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'O suporte a PHP não pode ser ativado porque a configuração atual de hospedagem não inclui nenhuma versão de PHP disponível para este domínio.',
    'php-settings.phpHandlersNotAvailableHint' => 'O suporte a PHP não pode ser ativado porque as configurações atuais do Plesk não inclui nenhuma versão do PHP disponível.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Descubra como habilitar outras versões do PHP.',
    'php-settings.phpSupportEditable' => '(versão do PHP %%version%%, execute o PHP como %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(versão: %%version%%; handler: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(não registrado) %%link%%',
    'php-settings.showPhpInfo' => 'Ver a página phpinfo()',
    'php-settings.phpSettingsFormError' => 'Impossível recuperar as configurações do PHP porque os dados necessários estão ausentes.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Não foi possível recuperar as configurações do PHP porque esta versão do PHP não está instalada. Para continuar, instale a versão PHP selecionada ou selecione outra para o domínio.',
    'php-settings.showPhpInfoTitle' => 'Ver phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Algumas de suas configurações PHP foram alteradas, mas as alterações não foram salvas ainda. Aplique as alterações para visualizar os novos valores na página phpinfo(). Caso contrário, os valores atuais serão exibidos.',
    'php-settings.showPhpInfoButton' => 'Ver phpinfo()',
    'php-settings.onState' => 'Ligar',
    'php-settings.offState' => 'Desliga',
    'php-settings.description' => 'Esta página exibe a configuração do PHP para o site. Estas configurações são específicas para o site e não afetam outros sites da assinatura. É possível alterar a configuração do PHP se o provedor de hospedagem conceder a permissão correspondente. A configuração personalizada do PHP pode ser utilizada, por exemplo, para limitar o consumo de recursos do sistema por scripts do PHP ou para atender aos requisitos de um determinado aplicativo da web. Ao estabelecer um parâmetro para o valor Padrão, o PHP irá usar o valor do parâmetro da configuração PHP de todo o servidor.',
    'php-settings.availableVariables' => 'Você pode utilizar as seguintes variáveis em valores de parâmetro:',
    'php-settings.variableDocroot' => '{DOCROOT} - o caminho absoluto para o diretório raiz do documento desse website. O valor atual é %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'O diretório raiz do documento HTTPS é o mesmo para o http.',
    'php-settings.variableDocrootHttpsDifferent' => 'O diretório raiz do documento HTTPS é %%DOCROOT%%.',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT} para o diretório raiz do documento do site primário da assinatura.',
    'php-settings.variableTmp' => '{TMP}  - o caminho absoluto para o diretório utilizado para arquivos temporários.',
    'php-settings.note' => 'Observação: As configurações abaixo podem ser substituídas por parâmetros especificados nos arquivos .htaccess, php.ini ou .user.ini.',

    'pmm.agent.sync.check' => 'Verificações de Agentes de Migração e Transferência para atualizações.',
    'pmm.agent.sync.updating' => 'Sincronização e download dos agentes de migração e transferência.',
    'pmm.agent.sync.done' => 'O Agente de migração e transferência foi sincronizado com êxito.',
    'pmm.agent.sync.downloadLink' => 'Clique para fazer o download do arquivo do agente de migração e transferência que deve ser instalado no host de origem antes de a migração iniciar.',
    'pmm.agent.sync.error' => 'Agente de Migração e Transferência falhou em obter as atualizações. Tente novamente mais tarde.',

    'restore-password.title' => 'Alterar Sua Senha',
    'restore-password.passwordLabel' => 'Nova senha',
    'restore-password.buttonRestore' => 'Salvar',
    'restore-password.buttonCancel' => 'Cancelar',
    'restore-password.isEmpty' => 'O campo obrigatório está vazio. Você precisa especificar um valor.',
    'restore-password.errorInvalidSecret' => 'Código secreto inválido!',
    'restore-password.errorNotFoundSecret' => 'Por favor, solicite um novo código secreto',
    'restore-password.restoreSuccess' => 'Sua senha foi atualizada. Use a nova senha para fazer login no Plesk ou em seu e-mail.',

    'scheduler.settings.schedulerNotification' => 'Notificação do agendador',
    'scheduler.settings.notificationOff' => "Desativado",
    'scheduler.settings.notificationDefault' => "Envie para o e-mail-padrão (%%email%%)",
    'scheduler.settings.notificationCustom' => "Envie para o e-mail que eu especificar",
    'scheduler.settings.crontabSecureShell' => 'Shell Crontab',
    'scheduler.settings.schedulerTimezoneSelector' => 'Mostrar programação de tarefas utilizando um fuso horário',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Utilizar o fuso horário do sistema padrão (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Utilizar o fuso horário do sistema padrão',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Utilizar o fuso horário que eu especificar',

    'scheduler.task.active' => 'Ativo',
    'scheduler.task.subscription' => 'Assinatura',
    'scheduler.task.subscription_powerUser' => 'Espaço web',
    'scheduler.task.type' => 'Tipo de tarefa',
    'scheduler.task.typeCommand' => 'Executar um comando',
    'scheduler.task.typeUrl' => 'Obter uma URL',
    'scheduler.task.typeScript' => 'Executar um script PHP',
    'scheduler.task.command' => 'Comando',
    'scheduler.task.arguments' => 'com argumentos',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Especifique um URL absoluto, por exemplo, http://exemplo.com.br Se o código de status da resposta for 2xx ou 3xx, a tarefa é considerada como tendo sido executada com sucesso.',
    'scheduler.task.script' => 'Caminho do script',
    'scheduler.task.scriptRelativePathDescription' => 'Exemplo: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Especificar o caminho completo para o script. Exemplo: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Utilizar a versão PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Caminho do script',
    'scheduler.task.run' => 'Executar',
    'scheduler.task.on' => 'em',
    'scheduler.task.at' => 'em',
    'scheduler.task.sysUser' => 'Usuário do sistema',
    'scheduler.task.hourly' => 'Por hora',
    'scheduler.task.daily' => 'Diário',
    'scheduler.task.weekly' => 'Semanal',
    'scheduler.task.monthly' => 'Mensal',
    'scheduler.task.yearly' => 'Anual',
    'scheduler.task.cronStyle' => 'Estilo Cron',
    'scheduler.task.cronStyleHint' => 'Utilizar o formato UNIX crontab format "minuto hora dia do mês mês dia da semana". Por exemplo "0 22 * * 1-5". O Plesk irá utilizar o fuso horário do sistema padrão para executar a tarefa.',
    'scheduler.task.cronStyleWinHint' => 'Utilizar o formato "minuto hora dia do mês mês dia da semana". Por exemplo "0 22 * * 6,7". O Plesk irá utilizar o fuso horário do sistema padrão para executar a tarefa.',
    'scheduler.task.notify' => 'Notificar',
    'scheduler.task.notifyIgnore' => 'Não notificar',
    'scheduler.task.notifyErrors' => 'Apenas erros',
    'scheduler.task.notifyAlways' => 'A cada ocorrência',
    'scheduler.task.notifyErrorsHint' => 'As notificações contêm a corrente de erro padrão do comando. Se a corrente estiver vazia, nenhuma notificação será enviada.',
    'scheduler.task.notifyErrorsHintWin' => 'As notificações contêm a saída do comando e são enviadas apenas se o código de saída for não zero.',
    'scheduler.task.notifyAlwaysHint' => 'As notificações contêm a saída do comando. Se a saída estiver vazia, nenhum notificação é enviada.',
    'scheduler.task.notifyAlwaysHintWin' => 'As notificações contêm a saída do comando e são enviadas independentemente do código de saída do comando.',
    'scheduler.task.emailType' => 'Enviar notificações para',
    'scheduler.task.emailTypeDefault' => 'Usuário do sistema padrão (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Proprietário da assinatura (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrador (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Outros usuários',
    'scheduler.task.emailTypeCustomDescription' => 'Você pode especificar diversos endereços separados com vírgulas.',
    'scheduler.task.minute' => 'minuto',
    'scheduler.task.shortMinute' => 'mín',
    'scheduler.task.dayOfMonth' => 'dia',
    'scheduler.task.description' => 'Descrição',
    'scheduler.task.scheduleTimezoneHint' => 'O fuso horário para a execução da tarefa é %%timezone%%',
    'scheduler.task.runTaskNow' => 'Executar agora',
    'scheduler.task.runningTask' => 'Executando a tarefa "%%task%%"...',

    'server-settings.submitDone' => "As configurações do servidor foram alteradas.",
    'server-settings.systemSettings' => "Configurações de sistema",
    'server-settings.fullHostName' => "Nome de host completo",
    'server-settings.trafficStatisticsPeriod' => "Manter estatísticas de tráfego e web para",
    'server-settings.trafficStatisticsPeriodUnit' => "meses",
    'server-settings.diskSpaceUsageCalculation' => "Incluir no cálculo de uso do espaço em disco",
    'server-settings.includeLogs' => "arquivos de log",
    'server-settings.includeLogsAndStats' => "arquivos de log e relatórios de estatísticas",
    'server-settings.includeMysqlDatabases' => "Bancos de dados MariaDB/MySQL",
    'server-settings.includeMssqlDatabases' => "Bancos de dados Microsoft SQL",
    'server-settings.includePgsqlDatabases' => "bases de dados PostgreSQL",
    'server-settings.includeDatabases' => "bancos de dados",
    'server-settings.includeRemoteDatabases' => "banco de dados remotos",
    'server-settings.includeMailboxes' => "caixas de e-mail",
    'server-settings.includeMailLists' => "mala direta",
    'server-settings.includeDomainDumps' => "arquivos de backup de domínio",
    'server-settings.includeAdminDumps' => "arquivos de backup criados pelo administrador",
    'server-settings.calculatingDiskSpaceUsage' => "Ao calcular o uso de espaço em disco, conte",
    'server-settings.typeByte' => "tamanho do arquivo",
    'server-settings.typeBlock' => "quantidade de espaço em disco utilizado",
    'server-settings.trafficCalculation' => "Incluir no cálculo de tráfego",
    'server-settings.inboundAndOutbound' => "tráfego de entrada e saída",
    'server-settings.onlyInbound' => "somente o tráfego de entrada",
    'server-settings.onlyOutbound' => "somente tráfego de saída",
    'server-settings.forbidCreateDnsSubZone' => "Não permitir que usuários criem subzonas DNS em superzonas DNS dos outras usuários",
    'server-settings.webDeployIncludePassword' => "Inclua a senha de usuário em um arquivo com configurações de publicação do Web Deploy",
    'server-settings.forbidSysUserRename' => "Os clientes podem mudar o nome de seus usuários do sistema",
    'server-settings.alwaysAllowSysUserRename' => "sempre",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "somente se a permissão ao gerenciamento de hospedagem for concedida",
    'server-settings.neverAllowSysUserRename' => "nunca",
    'server-settings.forbidSubscriptionRename' => "Proibir clientes e revendedores de alterar seu nome de domínio principal",
    'server-settings.preferredDomain' => "Domínio preferido para websites",
    'server-settings.preferredDomainNone' => "nenhum",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Registro de IP",
    'server-settings.disableIpLogging' => "Desative o registro de IP no IIS, FTP e registros de e-mail",
    'server-settings.disableIpLoggingDescription' => "Se selecionado, IIS e MailEnable não gravam mais endereços IP em arquivos de log",
    'server-settings.anonymizeIps' => "Anonimizar endereços IP",
    'server-settings.logrotateAnonymizeIps' => "Anonimizar os endereços IP durante a rotação de log e coletar estatísticas da web",
    'server-settings.logrotateAnonymizeIpsDescription' => 'O script de pós-rotação substitui o último octeto dos endereços IPv4 nos arquivos de log rotacionados por "0" antes do arquivamento. Nos endereços IPv6, o script substitui a última seção do endereço (dois octetos após os últimos dois pontos) por "0000" (no formato completo) ou "0" (no formato abreviado)',
    'server-settings.logrotate' => "Rotacionar log",
    'server-settings.logrotateForce' => "Forçar a rotação de log diária para todos os domínios",
    'server-settings.allowToStoreLogs' => "Permitir armazenar logs do website por",
    'server-settings.logrotatePeriod' => "dias",
    'server-settings.configureUpdatePolicy' => "Configurar política de atualização",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Valor padrão de todo o servidor (%%default%% mensagens por hora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Valor customizado para o plano',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Valor customizado para a assinatura',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'mensagens',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Mensagens de saída de uma caixa de e-mail (por hora)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Mensagens de saída de um domínio (por hora)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Mensagens de saída de uma assinatura (por hora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'A porcentagem de mensagens acima do limite por hora que será enviada na próxima hora',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Se o limite de envio de mensagens de uma caixa de e-mail é 100 por hora, e a porcentagem é de 10%, então o usuário tem permissão para enviar 110 mensagens por hora; 100 mensagens serão enviadas durante a primeira hora, e as outras 10 serão colocadas na fila e programadas para serem enviadas na próxima hora.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Política de utilização do Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Configurações padrões de todo o servidor (Sendmail é permitido)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Configurações padrões de todo o servidor (Sendmail não é permitido)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Configurações customizadas para o plano',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Configurações customizadas para a assinatura',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Permite a utilização do Sendmail para scripts e usuários nesta assinatura',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Scripts e usuários poderão enviar mensagens de e-mail (em nome do usuário de sistema da assinatura) utilizando o Sendmail, mesmo se os limites da caixa e e-mail e do domínio forem excedidos. O número máximo de mensagens que podem ser enviadas através do Sendmail será definido pelo limite na assinatura inteira.',

    'setup.hint' => 'Bem vindo ao Plesk, um painel de controle que te ajuda a gerenciar o servidor. A Plesk oferece um ambiente pronto para codificar e oferece uma série de extensões poderosas para ajudá-lo a desenvolver sites e aplicativos. Complete o processo de configuração para começar a usar o Plesk (só levará um minuto).',
    'setup.contactInfoSection' => 'Informações de contato',
    'setup.contactInfoSectionHint' => 'Insira seu nome e endereço de e-mail para identificar-se como o proprietário do servidor e receber notificações importantes sobre o servidor. Caso você seja um administrador de servidor corporativo, não insira seu nome ou endereço de e-mail pessoal. Utilize seu cargo e endereço de e-mail corporativo para evitar possíveis violações da lei de proteção de dados.',
    'setup.contactName' => 'Seu nome de contato',
    'setup.emptyContactName' => 'Forneça um nome de contato.',
    'setup.contactNameTooLong' => 'O nome de contato é muito longo (são permitidos, no máximo, %max% símbolos).',
    'setup.email' => 'E-mail',
    'setup.emptyEmail' => 'Forneça um endereço de e-mail.',
    'setup.passwordSection' => 'Senha',
    'setup.passwordSectionHint' => 'Da próxima vez que você efetuar o login no Plesk, use o nome de usuário \\ \'admin \' e a senha inserida abaixo.',
    'setup.password' => 'Senha',
    'setup.licenseSection' => 'Licença',
    'setup.licenseSectionHint' => 'É necessário instalar a licença para começar a utilizar a Plesk.',
    'setup.licenseType' => 'Selecione o tipo da licença',
    'setup.licenseTypePaid' => 'Prossiga com o pagamento da licença',
    'setup.onlineStoreLink' => 'Loja Online',
    'setup.licenseTypeTrial' => 'Prossiga com a licença de avaliação completa',
    'setup.activationCodeHint' => 'Se você já adquiriu uma licença Plesk, cole o código de ativação que você recebeu aqui. Caso não, você pode adquirir uma nova licença em nossa %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Política de Privacidade WebPros',
    'setup.trialLicenseAgreement' => 'Para emitir uma licença teste, a WebPros International GmbH utilizará e processará as informações fornecidas em seus sistemas internos, de acordo com a %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Eu confirmo que li e aceito o %%link%%',
    'setup.eula' => 'Contrato de Licença do Usuário Final',
    'setup.invalidEulaAgreementValue' => 'Você deve aceitar o Contrato de Licença do Usuário Final.',
    'setup.sendButton' => 'Entrar no Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Redefinir a senha do administrador no próximo login',

    'spam-filter.add.titleBlack' => 'Adicionar Endereços à Black List',
    'spam-filter.add.titleWhite' => 'Adicionar Endereços à White List',
    'spam-filter.add.fileDescription' => 'Faça o upload de um arquivo de texto na codificação UTF-8 (por exemplo, um arquivo *.txt ou *.csv).',
    'spam-filter.add.listDescription' => 'Regras de formatação: <ul><li>Separe endereços individuais com vírgulas, ponto e vírgula ou caracteres de nova linha, espaço em branco ou tabulação.</li><li>Não use caracteres não ASCII à esquerda do sinal @.</li><li>Você pode usar "*" e "?" curingas (por exemplo, <nobr>*@domain.com,</nobr> <nobr>user?@*.com</nobr>).</li><li>Não use curingas em partes não ASCII de nomes de domínio.</li></ul>',
    'spam-filter.add.fromFile' => 'Do arquivo',
    'spam-filter.add.fromList' => 'Da lista',
    'spam-filter.add.success' => 'Endereços foram adicionados',

    'ssl-certificate.add.name' => 'Nome do certificado',
    'ssl-certificate.add.longName' => 'O nome do certificado especificado é muito extenso (%max% símbolos máximos são permitidos).',
    'ssl-certificate.add.certificateNameUsed' => 'Um certificado com o nome %%name%% já existe.',
    'ssl-certificate.add.certificateAdded' => 'O certificado SSL/TLS foi emitido. Para fazê-lo funcionar, atribua o certificado para proteger um domínio, e-mail ou webmail.',
    'ssl-certificate.add.certificateUpdated' => 'O certificado SSL/TLS foi atualizado com êxito.',
    'ssl-certificate.add.settings' => 'Configurações',
    'ssl-certificate.add.settingsHint' => 'Utilize este formulário para gerar um pedido de certificado, comprar um certificado de seu provedor ou gerar um certificado autoassinado.',
    'ssl-certificate.add.settingsHint2' => 'Uma solicitação é um arquivo CSR que contém as informações sobre o domínio que você especificou no formulário. Você pode enviar a solicitação à uma autoridade certificadora para que ela faça a emissão de um certificado para você. Então, você deverá efetuar seu upload utilizando um dos formulários de upload abaixo.',
    'ssl-certificate.add.settingsHint3' => 'O certificado auto assinado é um certificado de identidade assinado por seu próprio criador. Se você usa um certificado, isso significa que você mesmo pode verificar a identidade dos seu sites. Embora os certificados auto assinados permitam o uso de SSL/TLS, eles são menos confiáveis e considerados menos seguros.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'País',
    'ssl-certificate.add.state' => 'Estado ou província',
    'ssl-certificate.add.longState' => 'O nome especificado do estado ou província é muito longo.',
    'ssl-certificate.add.city' => 'Localização (cidade)',
    'ssl-certificate.add.longCity' => 'O nome de cidade especificado é muito longo.',
    'ssl-certificate.add.shortCity' => 'O nome de cidade especificado é muito curto.',
    'ssl-certificate.add.companyName' => 'Nome da organização (empresa)',
    'ssl-certificate.add.longCompanyName' => 'O nome da empresa especificado é muito longo.',
    'ssl-certificate.add.companyUnitName' => 'Nome da divisão ou do departamento da organização',
    'ssl-certificate.add.longCompanyUnitName' => 'O nome do departamento da organização especificado é muito extenso (%max% símbolos máximos são permitidos).',
    'ssl-certificate.add.domainName' => 'Nome do domínio',
    'ssl-certificate.add.email' => 'E-mail',
    'ssl-certificate.add.request' => 'Solicitar',
    'ssl-certificate.add.buyCertificate' => 'Comprar certificado SSL/TLS.',
    'ssl-certificate.add.selfSigned' => 'Autoassinado',
    'ssl-certificate.add.invalidCertificateParams' => 'Alguns campos estão vazios ou contêm valores incorretos. Os valores devem ser limitados a 64 caracteres. Se você estiver usando um nome de domínio internacionalizado, certifique-se de que cada parte do nome de domínio entre os pontos não exceda 63 símbolos ao ser transformado em formato ASCII. Verifique os campos: ',
    'ssl-certificate.add.unableCreateCsr' => 'Não é possível criar um CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Não é possível criar um certificado autoassinado: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Não foi possível configurar os dados do certificado: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Não é possível salvar o certificado em um banco de dados: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Fazer upload de arquivos de certificado',
    'ssl-certificate.add.uploadFilesHint' => 'Utilizar este formulário para fazer o upload dos componentes de um certificado como arquivos constituintes.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Chave privativa (*.key)",
    'ssl-certificate.add.certificate' => "Certificado (*.crt)",
    'ssl-certificate.add.caCertificate' => "Certificado CA (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Fazer upload do Certificado",
    'ssl-certificate.add.fileNotUploaded' => 'Não foi possível fazer o upload do arquivo de certificado: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Não é possível definir a chave privada: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Não é possível definir o certificado: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Não é possível definir o certificado da CA: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Não é possível verificar se o certificado da CA assina o certificado: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Remover',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Você quer remover um certificado CA?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Não é possível limpar o certificado da CA: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'Foi removida parte do certificado CA.',
    'ssl-certificate.add.rename' => 'Renomear',
    'ssl-certificate.add.unableRenameCertificate' => 'Não é possível renomear o certificado: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'O certificado foi renomeado para %%name%%.',
    'ssl-certificate.add.uploadText' => "Fazer upload de certificado como texto",
    'ssl-certificate.add.uploadTextHint' => 'Utilizar este formulário para fazer o upload dos componentes de um certificado como texto. Copie o conteúdo de um arquivo e cole no campo correspondente.',
    'ssl-certificate.add.sendText' => "Fazer upload do Certificado",
    'ssl-certificate.add.componentIsMissing' => 'O componente está ausente.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Fazer upload do certificado aqui',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Se você criou uma solicitação de assinatura do certificado no servidor e recebeu o arquivo de certificado, carregue-o aqui. Se você deseja carregar um certificado e um par de chave privada gerado em um servidor diferente, ou gerar um certificado autoassinado, clique em <b>Adicionar certificado SSL/TLS</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Depois de adicionar um certificado SSL/TLS a um domínio, você precisa ativar o suporte ao SSL/TLS e selecionar esse certificado nas configurações de hospedagem do site: <b>Websites e Domínios</b> > <b>Configurações de hospedagem</b> deste domínio > <b>Segurança</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificado (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Fazer upload do Certificado',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Não foi possível fazer o upload do arquivo de certificado.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Formato de certificado inválido.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Não foi possível encontrar a chave privada apropriada para o certificado.',

    'ssl-certificate.secure.certificate' => 'Selecionar Certificado',
    'ssl-certificate.secure.serverPool' => 'grupo de servidores',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Data",
    'system-time.dateAndTime' => "Data e hora",
    'system-time.daylight' => "Ajustar automaticamente o relógio para o horário de verão",
    'system-time.dayMonthYear' => "Dia-Mês-Ano",
    'system-time.domainNameOrIp' => "Nome de domínio ou IP",
    'system-time.hoursMinutesSeconds' => "Horas:Minutos:Segundos",
    'system-time.networkTime' => "Tempo de rede",
    'system-time.submitDone' => "As configurações de hora do sistema foram alteradas.",
    'system-time.synchronizedSystemTime' => "Sincronizar a hora do sistema",
    'system-time.title' => "Data e hora do sistema",
    'system-time.timezone' => "Fuso horário",
    'system-time.time' => "Hora",
    'system-time.updateSystemTime' => "Atualizar a hora do sistema",
    'system-time.yourTimezone' => "Seu fuso horário",

    'web-app-firewall.pageHint' => 'O firewall de aplicativos da Web protege os aplicativos da Web contra ataques, verificando e filtrando solicitações HTTP de entrada com base em regras definidas pelo usuário.',
    'web-app-firewall.webSitePageHint' => 'Aqui você pode configurar o firewall do aplicativo da web (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Modo de firewall de aplicativo web',
    'web-app-firewall.ruleEngineOn' => 'Liga',
    'web-app-firewall.ruleEngineOnDescription' => 'Cada solicitação HTTP recebida e a resposta relacionada são verificadas em relação a um conjunto de regras. Se a verificação for bem-sucedida, a solicitação HTTP é enviada ao conteúdo do site. Se a verificação falhar, o evento será registrado, uma notificação será enviada e a resposta HTTP será fornecida com um código de erro.',
    'web-app-firewall.ruleEngineOff' => 'Desligar',
    'web-app-firewall.ruleEngineOffDescription' => 'Solicitações de HTTP de entrada e suas respostas relacionadas não são verificadas.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Somente detecção',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Cada solicitação HTTP recebida e a resposta relacionada são verificadas em relação a um conjunto de regras. Se a verificação for bem-sucedida, a solicitação HTTP é enviada ao conteúdo do site. Se a verificação falhar, o evento é registrado e o ModSecurity não executará nenhuma outra ação. Outros serviços (por exemplo, Fail2ban) ainda podem executar suas próprias ações em solicitações HTTP que falharem na verificação.',
    'web-app-firewall.ruleSetsSection' => 'Conjuntos de regras',
    'web-app-firewall.ruleSetsSectionHint' => 'Selecione qual conjunto de regras (um pacote de arquivos contendo regras de segurança) para verificar as solicitações HTTP de entrada.',
    'web-app-firewall.ruleSet' => 'Conjunto de regras',
    'web-app-firewall.ruleSetCrs' => 'OWASP (grátis)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set é muito restritivo e pode bloquear algumas funções (por exemplo, compartilhamento de arquivo, webmail) e alguns recursos de aplicativos da web (por exemplo, plugins do WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Aplicar alterações?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'As regras OWASP podem ser muito restritivas e bloquear algumas funções, como: Compartilhamento de Arquivos, webmail e alguns aplicativos da web.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (grátis, pode ser atualizado para o Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Uma versão inicial das regras do ModSecurity da Atomicorp. Eles fornecem proteção básica e tem atualizações mensais.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Para atualizar este conjunto de regras para o Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Adquira %%linkPleskStore%% do site da Plesk e %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Regras Avançadas do ModSecurity pela Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'instalar a chave de licença adicional comprada',
    'web-app-firewall.ruleSetTortixSelect' => 'Selecione este conjunto de regras, que mudará seu nome para “Atomic Advanced (comprado da Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (comprado da Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'As regras avançadas de ModSecurity da Atomicorp incluem regras Atomic Standard, além de vários recursos avançados.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (comprado da Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'As regras avançadas de ModSecurity da Atomicorp incluem regras Atomic Standard, além de vários recursos avançados.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Mude para outra conta Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'O conjunto de regras está ativado.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Se você já possui a conta Atomicorp com as regras Atomic Advanced adquiridas, insira as credenciais da conta abaixo para ativar esse conjunto de regras.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Se você já possui a conta Atomicorp com as regras Atomic Advanced adquiridas, insira as credenciais da conta abaixo para alternar a conta.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Nome do usuário',
    'web-app-firewall.ruleSetAtomicPassword' => 'Senha',
    'web-app-firewall.ruleSetComodo' => 'Comodo (assinatura gratuita)',
    'web-app-firewall.ruleSetComodoDescription' => 'Regras de ModSecurity grátis da Comodo. Eles fornecem proteção básica.',
    'web-app-firewall.ruleSetComodoInstall' => 'Alterne para outra conta Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'O conjunto de regras está ativado.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Para habilitar este conjunto de regras:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Para mudar para outra conta:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registre-se no site da Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Digite seu nome de usuário e senha do site.',
    'web-app-firewall.ruleSetComodoLogin' => 'Nome do usuário',
    'web-app-firewall.ruleSetComodoPassword' => 'Senha',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (grátis)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Regras de ModSecurity grátis da Comodo. Eles fornecem proteção básica.',
    'web-app-firewall.ruleSetCustom' => 'Conjunto de regras customizadas',
    'web-app-firewall.ruleSetCustomDescription' => 'Fazer upload de um conjunto de regras de firewall do aplicativo web customizado. Formatos suportados: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Selecione outro arquivo',
    'web-app-firewall.ruleSetError' => 'Falha ao instalar o conjunto de regras do ModSecurity: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'O conjunto de regras OWASP está ausente. Reinstale o ModSecurity usando o instalador do Plesk.',
    'web-app-firewall.ruleSetCustomMissingError' => 'O conjunto de regras personalizadas está ausente. Reinstale o conjunto de regras.',
    'web-app-firewall.ruleSetAuthError' => 'O nome de usuário e senha especificadosé inválido.',
    'web-app-firewall.ruleSetInvalid' => 'O conjunto de regras selecionado não pode ser executado em %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'O conjunto de regras selecionado não pode ser executado no servidor da web selecionado.',
    'web-app-firewall.webServer' => 'Executar regras em',
    'web-app-firewall.webServerHint' => 'Selecione a combinação desejada de servidor da web e versão do ModSecurity para ver os conjuntos de regras compatíveis.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'O servidor proxy reverso (nginx) está desligado e não pode ser usado para processar solicitações. Selecione <a href="%%serverUrl%%">outro servidor web</a> ou ligue o servidor proxy reverso na <a href="%%servicesUrl%%">página de Gerenciamento de Serviços</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Selecionar uma versão diferente do ModSecurity pode fazer com que algumas configurações não sejam mais válidas (por exemplo, você não pode usar expressões regulares para desligar as regras de segurança com o ModSecurity 3). Certifique-se de que suas configurações funcionem conforme o esperado após aplicar as alterações. Como alternativa, você pode redefinir as configurações que desligam as regras de segurança para os valores padrão.',
    'web-app-firewall.nginxResetCustomizations' => 'Redefina as configurações de servidor e domínios que desligam as regras de segurança para os valores padrão.',
    'web-app-firewall.ruleSetUpdate' => 'Atualizar os conjuntos de regras',
    'web-app-firewall.ruleSetUpdateDaily' => 'Diário',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Semanal',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Mensal',
    'web-app-firewall.currentRuleSet' => 'Conjunto de regras',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% em execução em %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Alterar conjunto de regras',
    'web-app-firewall.ruleSetRollbackFailed' => 'Não foi possível usar o conjunto de regras ModSecurity atual e reverter para a versão anterior, pois eles contêm regras inválidas.',
    'web-app-firewall.configurationSection' => 'Configuração',
    'web-app-firewall.configurationSectionHint' => 'Configure o firewall de aplicativo da web usando um conjunto predefinido de parâmetros ou suas diretivas ModSecurity personalizadas.',
    'web-app-firewall.configPreset' => 'Conjunto predefinido de valores',
    'web-app-firewall.configPresetFast' => 'Rápido',
    'web-app-firewall.configPresetFastDescription' => 'O URI de solicitação HTTP e partes dos cabeçalhos serão analisados.',
    'web-app-firewall.configPresetTradeOff' => 'Compensação',
    'web-app-firewall.configPresetTradeOffDescription' => 'O URI de solicitação HTTP, cabeçalhos e a solicitação de dados POST serão analisados.',
    'web-app-firewall.configPresetThrough' => 'Completo',
    'web-app-firewall.configPresetThroughDescription' => 'Todo conteúdo dos cabeçalhos de solicitação HTTP, os pedidos de dados POST e o conteúdo do corpo da resposta HTTP serão analisados.',
    'web-app-firewall.configCustom' => 'Diretivas customizadas',
    'web-app-firewall.configCustomDescription' => "Entre com uma diretiva do ModSecurity aqui. Ela substituirá as diretivas especificadas anteriormente (conjuntos de regras, regras específicas, o conjunto predefinido de valores, e assim por diante).\nPor exemplo: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Configuração ModSecurity inválida: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Não foi possível usar o arquivo de configuração atual do ModSecurity e reverter para a versão anterior do arquivo porque eles contêm uma configuração inválida.',
    'web-app-firewall.rulesSection' => 'Desativar as regras de segurança',
    'web-app-firewall.rulesSectionHint' => 'Aqui você pode desativar as regras de segurança. É útil se você descobrir que uma regra de segurança é muito restritiva para alguns sites. Para desativar as regras de segurança, especifique seus IDs (por exemplo, 340003 ou 340005-340007), tags (por exemplo, CVE-2011-4898) ou expressões regulares usadas em mensagens de regra (por exemplo, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Aqui você pode desativar as regras de segurança. É útil se você descobrir que uma regra de segurança é muito restritiva para alguns sites. Para desativar as regras de segurança, especifique seus IDs (por exemplo, 340003 ou 340005-340007), tags (por exemplo, CVE-2011-4898) ou mensagens de regra (por exemplo, User-Agent encontrado associado ao analisador de segurança).',
    'web-app-firewall.filterById' => 'IDs da regra de segurança',
    'web-app-firewall.filterByIdInvalid' => 'Os seguintes valores não são válidos: %%values%%. O ID da regra deve consistir em dígitos ou intervalo de dígitos como 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Os seguintes intervalos não são válidos: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Tags',
    'web-app-firewall.filterByTagActive' => 'Ativo:',
    'web-app-firewall.filterByTagDeactivated' => 'Desativado:',
    'web-app-firewall.filterByTagInvalid' => 'Os seguintes valores selecionados não são válidos: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Expressões regulares em mensagens de regra',
    'web-app-firewall.filterByRegexpInvalid' => 'Os seguintes valores não são válidos: %%values%%. Eles não devem conter os símbolos \', ".',
    'web-app-firewall.filterByRegexpNginx' => 'Mensagens de regra',
    'web-app-firewall.filterByRegexpNginxHint' => 'Apenas correspondências estritas são suportadas.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Os seguintes valores não são válidos: %%values%%. A mensagem da regra deve consistir em letras, dígitos, espaços ou caracteres -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Log de auditoria do ModSecurity',
    'web-app-firewall.auditLogHint1' => 'O arquivo de log de auditoria do ModSecurity é a parte mais importante da informação no sistema. O ModSecurity gera uma entrada no arquivo de log de auditoria na ocorrência de qualquer evento.',
    'web-app-firewall.auditLogHint2' => 'Um web site pode parar de funcionar depois que você alterar o modo de firewall do aplicativo web de Off para On ou como Detecção apenas. Neste caso, analise o log de auditoria do ModSecurity para descobrir o que está acontecendo. Você pode desligar as regras de segurança restritivas ou ajustar o web site.',
    'web-app-firewall.auditLogHint3' => 'Para descobrir por que uma solicitação HTTP não pôde ser concluída para um site:',
    'web-app-firewall.auditLogPoint1' => 'Clique no link do arquivo de log do ModSecurity abaixo e abra o log de auditoria em uma nova janela do navegador.',
    'web-app-firewall.auditLogPoint2' => 'Use a pesquisa (Ctrl+F na maioria dos navegadores) para encontrar os eventos para o website (o nome de domínio) que apresentam problemas. Por exemplo, seu_domínio.tld. O navegador irá destacar as entradas, como o HOST: seu_domínio.tld.',
    'web-app-firewall.auditLogPoint3' => 'Nas três linhas acima da entrada realçada, localize uma string como --eece5138-B--. Os oito símbolos entre os hifens (em nosso exemplo, eece5138) são o ID do evento acionado por uma solicitação de HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Pesquise outras entradas com o mesmo ID de evento. Procure uma entrada com a letra H após o ID do evento (no nosso exemplo, eece5138-H--). Esta entrada contém o ID e a descrição da regra de segurança acionada durante a verificação da solicitação HTTP. O ID da regra de segurança é um número inteiro entre aspas com o prefixo id entre colchetes (por exemplo, [id "340003"]).',
    'web-app-firewall.auditLogPoint5' => 'Encontre um ID de regra de segurança no evento usando uma substring (por exemplo, [id "3).',
    'web-app-firewall.auditLogPoint6' => 'Desativar a regra de segurança com este ID na seção de regras de segurança abaixo: entre com o ID da regra de segurança (somente dígitos) no campo de IDs de regra de segurança e clique em OK.',
    'web-app-firewall.auditLogViewLink' => 'Arquivo de log do ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Arquivo dos logs',
    'web-app-firewall.errorLogSection' => 'Log de erros',
    'web-app-firewall.errorLogSectionHint' => 'Um web site pode parar de funcionar depois que você alterar o modo de firewall do aplicativo web de Off para On ou como Detecção apenas. Neste caso, analise o log de erros para descobrir o que está acontecendo. Você pode desligar as regras de segurança restritivas ou ajustar o web site.',
    'web-app-firewall.errorLogViewLink' => 'Arquivo de log de erro',
    'web-app-firewall.notificationStateEnabled' => 'As notificações da IU do Plesk sobre atualizações do conjunto de regras estão ativadas. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'As notificações da IU do Plesk sobre atualizações do conjunto de regras estão desativadas. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Gerencie-os na página de notificação',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Selecionar as opções "Tradeoff" ou "Thorough" pode fazer com que os websites WordPress funcionem mal, entre outros efeitos colaterais indesejados, devido ao seguinte <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">Problema ModSecurity</a>.',

    'ProtectedDirectory.pathLabel' => 'Nome do diretório',
    'ProtectedDirectory.realmLabel' => 'Título da área protegida',
    'ProtectedDirectory.locationLabel' => 'Local do diretório',
    'ProtectedDirectory.isNonSslLabel' => 'Não SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'Nome do relatório',
    'SummaryReport.Layout.isDefault' => 'Usar como relatório padrão',
    'SummaryReport.Layout.sections' => 'Seções',
    'SummaryReport.Layout.general' => 'Geral',
    'SummaryReport.Layout.resellers' => 'Revendedores',
    'SummaryReport.Layout.clients' => 'Clientes',
    'SummaryReport.Layout.personalClients' => 'Clientes próprios',
    'SummaryReport.Layout.domains' => 'Domínios',
    'SummaryReport.Layout.personalDomains' => 'Domínios pessoais',
    'SummaryReport.Layout.type.full' => 'Completo',
    'SummaryReport.Layout.type.summary' => 'Resumo',

    'SummaryReport.Schedule.enable' => 'Habilitar',
    'SummaryReport.Schedule.period' => 'Frequência de entrega',
    'SummaryReport.Schedule.daily' => 'Diário',
    'SummaryReport.Schedule.weekly' => 'Semanal',
    'SummaryReport.Schedule.monthly' => 'Mensal',
    'SummaryReport.Schedule.email' => 'Entregar a',
    'SummaryReport.Schedule.isEmpty' => 'Digite um endereço de e-mail válido.',

    'MassMailForm.name' => 'Nome do modelo',
    'MassMailForm.fromEmail' => 'De (endereço de e-mail)',
    'MassMailForm.sendToAdmins' => 'Enviar para o administrador do Plesk',
    'MassMailForm.sendToResellers' => 'Enviar para revendedores',
    'MassMailForm.sendToClients' => 'Enviar para clientes',
    'MassMailForm.subject' => 'Assunto',
    'MassMailForm.body' => 'Texto da mensagem',
    'MassMailForm.bodyDescription' => '
É possível utilizar <name>a variável no texto da mensagem (mas não no cabeçalho). Ele será substituído pelo nome de contato do cliente ou do revendedor.',
    'MassMailForm.sendToResellersMode' => 'Enviar para',
    'MassMailForm.sendToResellersModeAll' => 'Todos os revendedores',
    'MassMailForm.sendToResellersModeSelect' => 'Revendedores selecionados',
    'MassMailForm.sendToResellersModeExcept' => 'Todos, exceto revendedores selecionados',
    'MassMailForm.sendToClientsMode' => 'Enviar para',
    'MassMailForm.sendToClientsModeAll' => 'Todos os clientes',
    'MassMailForm.sendToClientsModeSelect' => 'Clientes selecionados',
    'MassMailForm.sendToClientsModeExcept' => 'Todos, exceto clientes selecionados',

    'VirtualDirectory.DirectorySection.title' => 'Diretório Virtual',
    'VirtualDirectory.DirectorySection.name' => 'Nome',
    'VirtualDirectory.DirectorySection.accessSource' => 'Acesso à fonte do script',
    'VirtualDirectory.DirectorySection.accessRead' => 'Permissão de leitura',
    'VirtualDirectory.DirectorySection.accessWrite' => 'Permissão de gravação',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => 'Pesquisa no diretório',
    'VirtualDirectory.DirectorySection.log' => 'Visitas de log',
    'VirtualDirectory.Path.path' => 'Atalho',
    'VirtualDirectory.Path.autoPathLabel' => 'Crie um diretório físico com o mesmo nome do virtual',
    'VirtualDirectory.ApplicationSettingsSection.title' => 'Configurações do aplicativo',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => 'Criar aplicativo',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => 'Permitir uso de caminhos pai',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => 'Permitir a execução de aplicativos em modo MTA (compartimento com vários segmentos)',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => 'Executar permissões',
    'VirtualDirectory.SecuritySection.title' => 'Segurança de diretório',
    'VirtualDirectory.SecuritySection.authAnonymous' => 'Aciona autenticação anônima',
    'VirtualDirectory.SecuritySection.authNTLM' => 'Aciona autenticação do Windows',
    'VirtualDirectory.SecuritySection.requireSSL' => 'Exigir SSL/TLS',
    'VirtualDirectory.scriptExecuteOption.none' => 'Nenhum',
    'VirtualDirectory.scriptExecuteOption.script' => 'Somente scripts',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => 'Scripts e executáveis',
    'VirtualDirectory.AspSection.title' => 'Configurações do ASP',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'Tamanho máximo do buffer (KB) do ASP',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'Tamanho máximo do corpo da entidade de uma solicitação (KB) do ASP',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => 'Habilitar a depuração de script ASP do lado do servidor',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => 'Habilitar a depuração de script ASP do lado do cliente',
    'VirtualDirectory.AspSection.definedByIis' => 'Definido pela IIS',
    'VirtualDirectory.AspSection.definedByIisWithSize' => 'Definido pela IIS (%%size%% KB)',
    'VirtualDirectory.AspSection.definedByParent' => 'Definido pelo diretório pai',
    'VirtualDirectory.AspSection.definedByParentWithSize' => 'Definido pelo diretório pai (%%size%% KB)',
    'VirtualDirectory.AspSection.kbytes' => 'KB',
    'VirtualDirectory.CheckboxField.true' => 'Sim',
    'VirtualDirectory.CheckboxField.false' => 'Não',
    'VirtualDirectory.DocumentsSection.title' => 'Documentos',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => 'Usar documentos-padrão',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => 'Ordem de busca de documentos-padrão',
    'VirtualDirectory.DefaultDocsField.remove' => 'Remover',
    'VirtualDirectory.NewDefaultDoc.add' => 'Adicionar',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => 'Clicar para adicionar um arquivo à lista.',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => 'Digite um nome de arquivo para adicionar à lista.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => 'Um diretório físico com o mesmo nome já existe. Se você continuar, o diretório ficará inacessível. Continuar mesmo assim?',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => 'Continuar',

    'VirtualDirectoryMimeType.extension' => 'Extensão',
    'VirtualDirectoryMimeType.content' => 'Conteúdo',
    'VirtualDirectoryMimeType.custom' => 'Customizar',
];