<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Propriedades da Chave Adicional',
    'additional-key-info.update' => 'Recupere a chave adicional',
    'additional-key-info.updateDescription' => 'Recuperar a chave adicional e instalá-la.',
    'additional-key-info.download' => 'Fazer download da chave',
    'additional-key-info.downloadDescription' => 'Efetuar o download da chave de licença atual.',
    'additional-key-info.install' => 'Instale a chave',
    'additional-key-info.installDescription' => 'Instale a chave de licença atual.',
    'additional-key-info.revert' => 'Reverta a chave',
    'additional-key-info.revertDescription' => 'Reverta para a chave de licença instalada anteriormente.',
    'additional-key-info.revertNotAvailableDescription' => 'Nenhuma chave instalada.',
    'additional-key-info.installSuccess' => 'A instalação da chave de licença foi iniciada.',

    'additional-key-revert.title' => 'Reversão de Chave adicional',
    'additional-key-revert.success' => 'A chave adicional foi revertida.',

    'additional-key-upload.title' => 'Instalar uma Chave de Licença',
    'additional-key-upload.success' => 'A nova chave adicional foi carregada.',

    'additional-keys.title' => 'Chaves de Licença Adicionais',

    'change-subscriptions-owner.title' => 'Reatribuição de assinaturas selecionadas',
    'change-subscriptions-owner.success' => 'A propriedade da assinatura foi alterada',

    'customers.hint' => 'Você pode gerenciar as contas de seus clientes de serviços de hospedagem aqui: criar contas juntamente com assinaturas de serviços, gerenciar clientes existentes e remover contas. Para administrar websites, e-mails e quaisquer outros serviços fornecidos a um cliente, vá até seus painéis de controle clicando no link Painel do Cliente na lista.',

    'customer-domains.hint' => 'Esta é a área em que você configura e gerencia web sites.',

    'customer-subscriptions.hint' => 'Você pode gerenciar as assinaturas do cliente aqui.',

    'domains.hint' => 'Aqui é onde você visualiza as informações sobre todos os nomes de domínios registrados no sistema e pode continuar a gerenciar os serviços de hospedagem. Para adicionar um domínio para si ou para os clientes da hospedagem, apenas clique em Adicionar Domínio. Você poderá criar um novo cliente e assinatura enquanto cria um domínio, ou selecionar de domínios existentes.',

    'database-servers.title' => 'Servidores do banco de dados',

    'database-server-create.title' => 'Novo servidor de banco de dados',

    'database-server-properties.title' => 'Servidor do banco de dados',

    'database-server-upgrade.drawerTitle' => 'Upgrade do MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Upgrade completo',
    'database-server-upgrade.drawerSubTitle.line1' => 'O menu lateral não pode ser fechada enquanto a atualização estiver em execução.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Se ocorrerem problemas durante a atualização, consulte %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'O servidor de banco de dados MariaDB foi atualizado para a versão %%releaseVersion%%. Caso você enfrente algum problema, siga as instruções em %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Você já tem a versão LTS instalada.',
    'database-server-upgrade.troubleshootingArticle' => 'este artigo da base de conhecimento',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Use %%troubleshootingArticle%% para solucionar problemas de atualização do MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Atualize seu servidor de banco de dados MariaDB local para a versão atual de suporte de longo prazo (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Recomendamos fortemente que você faça backup do seu servidor antes da atualização e inicie a atualização fora dos horários de pico dos websites.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Durante a atualização do MariaDB, o servidor Plesk e os websites hospedados estarão indisponíveis. A atualização do MariaDB geralmente não contém erros e leva cerca de 10 minutos, mas ainda pode afetar todo o servidor.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Nota: Se você estiver executando o MariaDB 5.5, o Plesk irá atualizá-lo primeiro para o MariaDB 10.5. Após a conclusão da atualização, inicie este assistente novamente para atualizar para a versão LTS atual do MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Versão atual',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Selecione a versão para a qual atualizar',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Não há grandes lançamentos',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Notas de lançamento',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Data de lançamento: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Data do fim da vida útil: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Somente forks do MariaDB enviados por fornecedores de Sistema Operacional ou pelo fornecedor do MariaDB podem ser atualizados.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Verificações pré-upgrade',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Analisando arquivos de configuração do MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analisando bancos de dados com mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analisando a configuração do gerenciador de pacotes',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Verificando a compatibilidade do sistema',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Verificando WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Para prosseguir com a atualização, marque todas as caixas de seleção. É necessário ter certeza de que você concorda com as alterações de configuração que a atualização fará e que tem acesso às opções de recuperação.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'As seguintes variáveis serão removidas para compatibilidade com a nova versão:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} de {count, plural, one {o arquivo {files}} other {os # arquivos: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Acessar opções de recuperação (console de linha de comando do servidor e kit de reparo)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Confirmo que tenho acesso SSH ao servidor',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Use um cliente SSH ou abra %%sshTerminalExtension%% em uma nova aba do navegador (não feche a janela de extensão do Terminal SSH até que a atualização seja concluída). Se a atualização falhar, ter acesso SSH ajudará na recuperação.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Extensão do Terminal SSH',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Confirmo que tenho acesso ao Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Abra %%repairKit%% em uma nova guia do navegador e faça login usando as credenciais de administrador. Não feche a janela de extensão do Repair Kit até que a atualização seja concluída.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Faça o backup de bancos de dados',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Faça backup de todos os bancos de dados hospedados no servidor antes de fazer o upgrade',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'O Plesk armazenará o backup dos bancos de dados no diretório %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket no Plesk não está disponível',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Você não poderá ver a saída do processo de atualização em tempo real sem o WebSocket.',

    'database-server-upgrade.submitPopover.title' => 'Para evitar possíveis perdas de dados, recomendamos fortemente que você crie um dump dos bancos de dados hospedados antes de continuar. Continuar sem criar um dump?',

    'database-server-databases.title' => 'Bancos de dados',

    'database-server-change-password.title' => 'Senha do Administrador',

    'home.title' => 'Página inicial',

    'license.title' => 'Informações de licença',

    'primary-key-info.title' => 'Chave de Licença do Plesk',
    'primary-key-info.update' => 'Recuperar Chaves',
    'primary-key-info.updateDescription' => 'Recuperar chaves de licença solicitadas e instalá-las.',
    'primary-key-info.upload' => 'Instale a chave',
    'primary-key-info.uploadDescription' => 'Fazer upload e instalar uma nova chave de licença.',
    'primary-key-info.revert' => 'Reverta a chave',
    'primary-key-info.revertDescription' => 'Reverta para a chave de licença instalada anteriormente.',

    'primary-key-revert.title' => 'Reversão da Chave de Licença',
    'primary-key-revert.success' => 'A chave Plesk foi revertida.',

    'primary-key-upload.title' => 'Instalar uma Chave de Licença',
    'primary-key-upload.success' => 'A nova chave do Plesk foi carregada.',

    'resellers.hint' => 'Aqui é onde você gerencia as contas de revendedores — de seus clientes que revendem serviços de hospedagem e hospedam seus próprios websites. Aqui você cria contas juntamente com assinaturas de serviços, gerencia clientes existentes e remove contas.',

    'reseller-customers.hint' => 'Esta é a área em que você configura e gerencia clientes.',

    'reseller-domains.hint' => 'Esta é a área em que você configura e gerencia web sites.',

    'reseller-subscriptions.hint' => 'É aqui que você gerencia as assinaturas do revendedor.',

    'subscriptions.hint' => 'Os clientes obtêm os serviços de hospedagem de você assinando um plano de hospedagem. É possível gerenciar essas assinaturas aqui, bem como suas próprias assinaturas criadas para hospedar seus websites. Para administrar websites, e-mails e quaisquer outros serviços fornecidos com uma assinatura, vá até o Painel do Cliente do assinante clicando no link Painel de Controle na lista.',

    'server-mail-settings.title' => 'Configurações',
    'server-mail-spam-filter.title' => 'Filtragem de spam',
    'server-mail-antivirus.title' => 'Antivírus',
    'server-mail-black-list.title' => 'Lista negra',
    'server-mail-white-list.title' => 'Lista branca',
    'server-mail-queue.title' => 'Fila de e-mails',
    'server-mail-statistics.title' => 'Estatísticas',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => 'Configurações',
    'server-spam-filter.black-list' => 'Lista negra',
    'server-spam-filter.white-list' => 'Lista branca',

    'firewall.title' => 'Gerenciamento do firewall',
    'firewall-general.title' => 'Geral',
    'firewall-general.toggleStatus' => 'Proteção de firewall',
    'firewall-general.buttonDefault' => 'Redefinir para Padrão',
    'firewall-general.buttonPanic' => 'Modo de pânico',
    'firewall-general.confirmationDefault' => 'Redefinir as configurações do firewall para os padrões?',
    'firewall-general.confirmationPanic' => 'Ativar o modo de pânico? Os usuários não poderão acessar seus domínios e alguns serviços de rede podem parar de funcionar.',
    'firewall-general.successDefault' => 'As configurações do firewall foram redefinidas para os padrões.',
    'firewall-general.successPanic' => 'O modo de pânico foi ativado.',
    'firewall-general.info' => 'Por motivos de segurança, o firewall bloqueia todas as conexões, com exceção daquelas explicitamente permitidas. Você pode permitir uma conexão criando uma regra. Consultar a documentação para mais informações',
    'firewall-general.interfaces' => 'Interfaces de rede',
    'firewall-icmp.title' => 'Protocolo ICMP',
    'firewall-rules.title' => 'Regras do firewall',

    'dns.title' => 'Configurações de DNS',
    'dns-records.title' => 'Modelo de Registros de Zona',
    'dns-soa-record.title' => 'Modelo de configurações de zona',

    'php-handler.title' => 'Configurações para %%name%%',
    'php-handler.extensions.title' => 'Extensões',
    'php-handler.extensions.description' => 'Estas configurações das extensões do PHP são apenas para este manipulador.',
    'php-handler.extensions.descriptionShared' => 'Estas configurações são comuns para os seguintes manipuladores PHP: %%handlers%%. As configurações aplicam-se a todos os sites que utilizam estes manipuladores.',
    'php-handler.extensions.buttonManage' => 'Gerenciar Pacotes PECL',
    'php-handler.extensions.manage.title' => 'Gerenciar Pacotes PECL',
    'php-handler.extensions.manage.risks' => 'As extensões PHP são fornecidas por pacotes PECL de terceiros. Você os está instalando por sua conta e risco.',
    'php-handler.extensions.manage.description' => 'Instalar, atualizar e desinstalar pacotes PECL. As alterações serão aplicadas a todos os websites em execução no %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Por que o pacote desejado não está na lista?',
    'php-handler.extensions.manage.limitations' => 'As extensões PHP enviadas pelo provedor do painel de controle e pelos fornecedores do sistema operacional não são mostradas na lista.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Atualizar",
    'ServerInformation.sectionGeneral' => "Geral",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Versão",
    'ServerInformation.os' => "Sistema Operacional",
    'ServerInformation.key' => "Chave de licença do Plesk",
    'ServerInformation.uptime' => "Tempo de atividade",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dia} other {# dias}} {hours, plural, one {# hora} other {# horas}} {minutes, plural, one {# minuto} other {# minutos}}",
    'ServerInformation.sectionCpu' => "Utilização da CPU",
    'ServerInformation.la1min' => "Último minuto",
    'ServerInformation.la5min' => "Últimos 5 minutos",
    'ServerInformation.la15min' => "Últimos 15 minutos",
    'ServerInformation.sectionMemory' => "Uso de memória",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "Total (excluindo kernel)",
    'ServerInformation.memoryTotal' => "Total",
    'ServerInformation.memoryUsed' => "Utilizado",
    'ServerInformation.memoryFree' => "Livre",
    'ServerInformation.memoryShared' => "Compartilhado",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Em cache",
    'ServerInformation.memoryAvailable' => "Disponível",
    'ServerInformation.memoryUsage' => "Uso",
    'ServerInformation.sectionSwap' => "Uso de troca",
    'ServerInformation.sectionVirtualMemory' => "Uso de memória virtual",
    'ServerInformation.swapTotal' => "Total",
    'ServerInformation.swapUsed' => "Utilizado",
    'ServerInformation.swapFree' => "Livre",
    'ServerInformation.swapUsage' => "Uso",
    'ServerInformation.sectionHarddisk' => "Uso do disco rígido",
    'ServerInformation.harddiskDirectory' => "Sistema de arquivos",
    'ServerInformation.harddiskProtectedDir' => "Diretórios importantes",
    'ServerInformation.harddiskTotal' => "Total",
    'ServerInformation.harddiskUsed' => "Utilizado",
    'ServerInformation.harddiskAvailable' => "Disponível",
    'ServerInformation.harddiskCapacity' => "Capacidade",
    'ServerInformation.sectionDomains' => "Domínios",
    'ServerInformation.activeDomains' => "Ativo",
    'ServerInformation.inactiveDomains' => "Inativo",
    'ServerInformation.problemDomains' => "Problemas",
    'ServerInformation.refreshed' => "Informações atualizadas.",

    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Todos os direitos reservados.',
    'ServerAbout.linkLicenseManagement' => 'Vá para Informações de Licença',
    'ServerAbout.panelVersion' => 'Versão',
    'ServerAbout.installedPatchVersion' => 'Atualização nº%%patch%%',
    'ServerAbout.licenseKey' => 'Chave de licença',
    'ServerAbout.productDescription' => 'Plesk é a principal plataforma WebOPS usada para executar, automatizar e desenvolver aplicativos, sites e empresas de hospedagem.',
    'ServerAbout.readEula' => 'Leia %%link%%.',
    'ServerAbout.linkEula' => 'Contrato de Licença do Usuário Final',
    'ServerAbout.visitForum' => 'Visite %%link%%',
    'ServerAbout.linkForum' => 'Fórum Plesk',
    'ServerAbout.followUs' => 'Siga-nos',
    'ServerAbout.visitSite' => 'Aprenda mais em %%link%%.',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Encontre inspiração em %%link%%.',
    'ServerAbout.linkBlog' => 'Blog Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Parabéns!',
    'ServerAbout.darkThemePromoDescription' => 'Você encontrou um gatinho mágico.',
    'ServerAbout.darkThemePromoButton' => 'Vruum! Venha para o lado obscuro',
    'ServerAbout.darkThemeTourDescription' => 'Mude esta opção para habilitar ou desabilitar o tema escuro para sua interface.',
    'ServerAbout.darkThemeTourButton' => 'Consegui',

    'ts-sessions.title' => 'Sessões do Terminal do Servidor',
    'ts-sessions-properties.title' => 'Propriedades da sessão',

    'BandwidthLimiting.bandwidthThrottling' => 'Não é possível controlar a limitação da largura de banda porque o QoS não está instalado.',
    'BandwidthLimiting.virtualHostingRequired' => 'A limitação de largura de banda está disponível apenas para domínios com hospedagem na web.',
    'BandwidthLimiting.bandwidthLabel' => 'Uso máximo da largura de banda',
    'BandwidthLimiting.bandwidthHint' => 'O limite de uso de largura de banda é aplicado apenas aos dados transferidos por meio do protocolo HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Conexões limitadas a',
    'BandwidthLimiting.maxConnectionHint' => 'Se você limitar a largura de banda, recomendamos que também limite o número de conexões simultâneas ao website. Caso contrário, em caso de solicitações frequentes ao website, os processos do servidor da Web aumentarão a carga do servidor.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'As configurações de limitação de largura de banda foram alteradas.',
    'BandwidthLimiting.unlimited' => 'Ilimitado',

    'ip-address-domains.title' => 'Websites que usam %%type%% endereço IP %%ipAddress%%',
    'ip-address-domains.site' => 'Website',
    'ip-address-domains.setAsDefault' => 'Definir como padrão',
    'ip-address-domains.type-SHARED' => 'compartilhado',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicado',

    'HotlinkProtection.virtualHostingRequired' => 'A Proteção Hotlink está disponível apenas para domínios com hospedagem na web.',
    'HotlinkProtection.enabledLabel' => 'Ativar proteção hotlink',
    'HotlinkProtection.extensionsLabel' => 'Extensões de arquivo protegidos',
    'HotlinkProtection.friendsLabel' => 'Endereços de websites amigáveis',
    'HotlinkProtection.success' => 'As configurações de proteção de hotlink foram alteradas.',

    'Odbc.add' => 'Adicionar ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% criado / %%allowed%% permitido.',
    'Odbc.limitExceeded' => 'O limite de conexão ODBC DSN foi excedido.',
    'Odbc.unlimited' => 'Ilimitado',
    'Odbc.addTooltip' => 'Adicionar a fonte de dados ODBC.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Nome da conexão',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Descrição da conexão',
    'Odbc.hostname' => 'Hostname',
    'Odbc.statusSystem' => 'É um sistema DSN.',
    'Odbc.statusConfigured' => 'O DSN está configurado.',
    'Odbc.statusNotConfigured' => 'O DSN não está configurado.',
    'Odbc.noSelectionText' => 'Selecione um ou mais itens para remover.',
    'Odbc.removeConfirmation' => 'Remover {count, plural, one {}=1 {a conexão {name}} other {# conexões selecionadas}}?',
    'Odbc.removeSuccess' => 'As conexões selecionadas foram removidas.',

    'DomainAliasSettings.title' => 'Configurações de Alias de Domínio',
    'DomainAliasSettings.updateSuccess' => 'As propriedades do alias de domínio %%name%% foram alteradas. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'As configurações de website serão aplicadas em %%restartInterval%% minutos.',

    'Home.Backup.offStatus' => 'Este não é um backup válido. Os dados deste arquivo não podem ser restaurados.',
    'Home.Backup.task-failedStatus' => 'Falha na tarefa de backup.',
    'Home.Backup.activeSchedule' => 'Programação: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Programações: %%schedules%%',
    'Home.Backup.noSchedule' => "A programação de backup não está definida",
    'Home.Backup.period_hourly' => '%%schedule%% por hora',
    'Home.Backup.period_daily' => '%%schedule%% diária',
    'Home.Backup.period_weekly' => '%%schedule%% semanal',
    'Home.Backup.period_monthly' => '%%schedule%% mensal',
    'Home.Backup.create' => 'Criar um backup',
    'Home.Backup.schedule' => 'Cronograma',
    'Home.ChangeLog.seeHistory' => 'Ver o Histórico de Alterações',
    'Home.CustomButtons.add' => 'Adicionar botão customizado',
    'Home.CustomButtons.noButtons' => 'Não há nenhum botão customizado',
    'Home.Customization.title' => 'Painel',
    'Home.Customization.description' => 'Escolha quais opções você gostaria de ver',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Servidor',
    'Home.Customization.securitySection' => 'Segurança',
    'Home.Customization.backup' => 'Último Backup do Servidor',
    'Home.Customization.ipBan' => 'Proibindo endereço IP',
    'Home.Customization.mailQueue' => 'Fila de e-mails',
    'Home.Customization.mySubscriptions' => 'Minhas assinaturas',
    'Home.Customization.overusedSubscriptions' => 'Assinaturas com uso Excessivo',
    'Home.Customization.serverInfo' => 'Informações do servidor',
    'Home.Customization.updates' => 'Atualizações do Plesk',
    'Home.Customization.promo' => 'Promo',
    'Home.Customization.changeLog' => 'O que há de Novo',
    'Home.Customization.customButtons' => 'Botões customizados',
    'Home.EmptyView.title' => 'Aproveite ao máximo seu painel escolhendo quais opções deseja ver.',
    'Home.EmptyView.titleLocked' => 'O painel está bloqueado pelo seu provedor de serviços.',
    'Home.EmptyView.customize' => 'Customizar',
    'Home.Extension.title' => 'Extensão',
    'Home.IpBan.banned' => 'Banido',
    'Home.IpBan.trusted' => 'Confiável',
    'Home.IpBan.more' => 'Veja mais',
    'Home.MailQueue.total' => 'Total',
    'Home.MailQueue.deferred' => 'Adiado',
    'Home.MailQueue.held' => 'Mantido',
    'Home.MailQueue.more' => 'Veja mais',
    'Home.MailQueue.clean' => 'Limpar fila de e-mail',
    'Home.MailQueue.checkLogs' => 'Verifique os registros',
    'Home.MailQueue.repair' => 'Reparar',
    'Home.MailQueue.cleanConfirmQuestion' => 'Limpar a fila de e-mail?',
    'Home.MailQueue.cleanConfirmYes' => 'Sim',
    'Home.MailQueue.cleanConfirmNo' => 'Não',
    'Home.MailQueue.queueCleaned' => 'A fila de e-mail foi apagada com sucesso.',
    'Home.MailQueue.Promo.title' => 'Acesse o status de entrega e os registros facilmente',
    'Home.MailQueue.Promo.link' => 'Experimente a nova fila de e-mail agora',
    'Home.OverusedSubscriptions.empty' => 'Nenhuma assinatura com uso excessivo encontrada',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% de %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Ver tudas com uso excessivo: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Abrir na lista',
    'Home.PromoNewHomeView.title' => 'Bem-vindo à nova página inicial!',
    'Home.PromoNewHomeView.description' => 'Se você enfrentar algum problema com ele, por favor, compartilhe seus comentários. Isso nos ajudará muito com outras melhorias.',
    'Home.PromoNewHomeView.feedback' => 'Compartilhar comentários',
    'Home.PromoNewHomeView.switch' => 'Voltar para "Início"',
    'Home.ServerInfo.hostname' => 'Hostname',
    'Home.ServerInfo.ipAddress' => 'Endereço IP',
    'Home.ServerInfo.publicIpAddress' => 'Endereço de IP público',
    'Home.ServerInfo.os' => 'SO',
    'Home.ServerInfo.uptime' => 'Tempo de atividade',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dia} other {# dias}} {hours, plural, one {# hora} other {# horas}} {minutes, plural, one {# minuto} other {# minutos}}",
    'Home.ServerInfo.more' => 'Veja mais',
    'Home.Subscriptions.add' => 'Adicionar novo',
    'Home.Subscriptions.empty' => 'Criar assinaturas para hospedar vários websites em um espaço isolado no servidor. %%link%%',
    'Home.Subscriptions.help' => 'Saiba mais',
    'Home.Updates.title' => 'Atualizações de Produto',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Atualização #%%patch%%',
    'Home.Updates.manageComponents' => 'Adicionar ou remover componentes',
    'Home.Updates.lastUpdated' => 'Última atualização em %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Verificar atualizações',
    'Home.Updates.enableAutoupdate' => 'Permitir atualizações automáticas',
    'Home.Updates.lastChecked' => 'Última verificação em %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% está disponível',
    'Home.Updates.installNewVersion' => 'Instalar agora',
    'Home.Updates.patchAvailable' => 'Pequenas atualizações estão disponíveis',
    'Home.Updates.patchAvailableVersion' => 'Pequenas atualizações para %%currentVersion%% estão disponíveis',
    'Home.Updates.installPatch' => 'Atualizar agora',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Atualização para {package} está disponível} other {Atualizações para {package} estão disponíveis}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# pacote} other {# pacotes}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Atualizar Agora} other {Atualizar Todos}}',
    'Home.Promo.Customize.title' => 'Personalize o seu painel!',
    'Home.Promo.Customize.content' => 'Acesse suas funcionalidades favoritas rapidamente com o novo painel personalizável',
    'Home.Promo.Customize.action' => 'Customizar',
    'Home.Promo.SwitchToPuv.title' => 'Você conhece as visualizações de interface no Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Se você não oferece serviços de hospedagem aos seus clientes usando planos de serviço, talvez queira experimentar a interface mais conveniente para gerenciar websites, seus arquivos, bancos de dados, contas de e-mail e aplicações web.',
    'Home.Promo.SwitchToPuv.action' => 'Experimente agora',
    'Home.Status.error' => 'Erro',
    'Home.Status.warning' => 'Aviso',
    'Home.Status.info' => 'Info',

    'HostingSettings.title' => 'Configurações de hospedagem',
    'HostingSettings.updateSuccess' => 'As configurações foram atualizadas.',
    'HostingSettings.emptyLogin' => 'Você precisa especificar um nome de usuário.',
    'HostingSettings.emptyPassword' => 'Você precisa especificar uma senha.',
    'HostingSettings.ipV6OnlyNotSupported' => 'O servidor de FTP não suporta IPv6. Efetue a alocação de um endereço IPv4 no mínimo; caso contrário, o usuário não poderá efetuar upload dos arquivos para o servidor via FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Configurações de domínio',
    'HostingSettings.domainSettingsSection.domainName' => 'Nome do domínio',
    'HostingSettings.domainSettingsSection.description' => 'Por exemplo, exemplo.com ',

    'HostingSettings.submitPopover.title' => 'Remover o conteúdo de %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Mudar o tipo de hospedagem do "Site" para "%%type%%" removerá permanentemente todo o conteúdo do site, incluindo os seguintes diretórios:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Você deseja mudar o tipo de hospedagem para seu site?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Para acessar mais configurações, insira as credenciais de usuário do sistema e clique em "Criar espaço na web".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Para acessar mais configurações, clique em "Próximo" para criar a hospedagem.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Tipo de hospedagem',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tipo',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Site',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Redirecionamento',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Sem hospedagem web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Use a zona DNS do domínio para ter caixas de e-mail sob este nome de domínio',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Especifique o caminho para o diretório principal do website',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Domínio preferido',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Os visitantes serão redirecionados usando um redirecionamento HTTP 301 amigável de SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Encaminhar visitantes para',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Tipo de redirecionamento',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Movido permanentemente (código 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redirecione os vistantes do site para outro site e mostre o endereço de destino. Esse redirecionamento manterá a classificação de pesquisa do website',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Movido permanentemente (código 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redirecione os visitantes do site para uma cópia temporária do site quando você não quiser buscar os mecanismos para indexar este site temporário.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Redirecionamento de quadro',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redirecionar os visitantes do site para outro site, mas não mostrar-lhes o endereço de destino, para que não saibam sobre o redirecionamento.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Domínio preferido',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Nenhum',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Documento raiz',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Não é possível alterar o documento raiz, porque existem aplicativos web instalados neste website.',
    'HostingSettings.domainSettingsSection.save' => 'Salvar',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Modo de compatibilidade',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Executar o website em modo de compatibilidade para a opção legada "Separar conteúdos SSL/TLS e não SSL/TLS".',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Este website está funcionando em modo de compatibilidade e você não pode gerenciá-lo usando a interface do Plesk. Isso ocorre porque você usou a opção obsoleta “Separar conteúdo SSL/TLS e não-SSL/TLS” antes da atualização. A partir do Plesk 11, um website armazena seu conteúdo disponível em conexões HTTP e HTTPS no mesmo diretório. Recomendamos que você mova todos os dados do diretório `httspdocs/` para `httpdocs/` e, em seguida, desative o modo de compatibilidade. Isso também tornará os aplicativos instalados no diretório `httpsdocs/` acessíveis pela Internet. Fique atento, pois você não conseguirá ativar o modo de compatibilidade novamente.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Alterar esta configuração?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Alterar essa configuração contradiz a política de segurança do servidor e pode prejudicar o desempenho ou tornar o servidor vulnerável a ataques.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Alterar',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Reverter',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'A predefinição de configurações seguras é aplicada',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Para maior segurança, aplique a predefinição de configurações seguras. Observe que certas permissões permitem que os assinantes modifiquem essas configurações.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Aplicar predefinição segura',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Saiba mais sobre as configurações de hospedagem segura',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Suporte SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Habilitado',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Conexões criptografadas entre o site e o navegador do visitante.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificado',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Para habilitar o HTTPS, faça o upload de um certificado SSL/TLS no repositório do domínio, depois selecione-o aqui.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redirecionar visitantes de HTTP ára HTTPS usando um redirecionamento 301 amigável do SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Não há certificados SSL/TLS no seu repositório. Para adicionar um certificado, vá em %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'esta página',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (outro repositório)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Não selecionado',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web scripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Selecione quais linguagens de programação e script devem ser interpretadas pelo servidor web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'o diretório cgi-bin está localizado em %%value%%.',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Utilizar o SSI para arquivos *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versão do Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documentos de erro customizados',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'o diretório cgi-bin está localizado em',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'o documento raiz deste domínio',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'o diretório raiz do espaço web',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'o documento raiz de estilo antigo deste domínio',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documentos de erro customizados',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Permissões adicionais de gravação/modificação',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publicação do Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Estatísticas da web',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Ferramenta',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Proteger o acesso às suas estatísticas da web com seu nome de usuário e senha FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Desabilitado',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Configurações de espaço web',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Endereços IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Cota de espaço em disco',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Habilitado',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Proibir operações nos arquivos do site se a cota de espaço em disco definida nas configurações de assinatura (caso houver) for excedida.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'A cota do disco rígido não é suportada devido à configuração do sistema de arquivos do servidor.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Credenciais de usuário do sistema',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gerencie os arquivos e pastas do site via FTP ou Gerenciador de arquivos. Acesse o servidor via SSH, se permitido.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gerencie os arquivos e pastas do site via FTP ou Gerenciador de arquivos. Acesse o servidor via Área de trabalho remota, se permitido.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nome do usuário',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Senha',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Especifique uma nova senha aqui para mudar a senha do usuário do sistema.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Acesso SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Acesso à Área de Trabalho remota',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Habilitado',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Acesse o servidor com as credenciais do usuário do sistema.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tipo',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Desabilitado',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'For {count, plural, one {}other {# domínios}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'As seguintes configurações são mútuas para todos {count, plural, one {}other {# domínios no espaço web {name}}}:',

    'OdbcAdd.title' => 'Adicionar um ODBC DSN',
    'OdbcAdd.nameLabel' => 'Nome da conexão',
    'OdbcAdd.descriptionLabel' => 'Descrição da conexão',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Criar ODBC DSN',

    'OdbcEdit.title' => 'Configurar uma Conexão ODBC',
    'OdbcEdit.saveSuccess' => 'As configurações de conexão foram salvas.',
    'OdbcEdit.test' => 'Conexão de teste',
    'OdbcEdit.connectSuccess' => 'Conexão com êxito.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Caminho do arquivo de banco de dados',
    'OdbcEdit.excel.defaultdir.label' => 'Diretório de dados padrão',
    'OdbcEdit.excel.fil.label' => 'Versão do banco de dados',
    'OdbcEdit.excel.maxbuffersize.label' => 'Tamanho máx. de buffer',
    'OdbcEdit.excel.pagetimeout.label' => 'Timeout de página',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Caminho do arquivo de banco de dados',
    'OdbcEdit.access.uid.label' => 'ID de login',
    'OdbcEdit.access.pwd.label' => 'Senha',
    'OdbcEdit.access.pagetimeout.label' => 'Timeout de página',
    'OdbcEdit.access.pagetimeout.description' => 'O período, em décimos de segundo, que uma página não utilizada permanece no buffer. Esta opção se aplica para todas as fontes de dados que utilizam o driver do Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Tamanho máx. de buffer',
    'OdbcEdit.access.maxbuffersize.description' => 'O tamanho do buffer interno, em KB, alinhado no limite de 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Somente leitura',
    'OdbcEdit.access.readonly.description' => 'Designar o banco de dados como somente leitura e proibir qualquer atualização.',
    'OdbcEdit.access.exclusive.label' => 'Exclusivo',
    'OdbcEdit.access.exclusive.description' => 'Designar o banco de dados como exclusivo para proibir atualizações compartilhadas.',
    'OdbcEdit.access.safetransactions.label' => 'Transações seguras',
    'OdbcEdit.access.safetransactions.description' => 'Se definido para 0 (a configuração-padrão), todas as transações são confirmadas imediatamente. Se definido para 1, todas as transações são salvas para o disco apenas mediante uma operação de confirmação, mas o desempenho cai um pouco.',
    'OdbcEdit.access.threads.label' => 'Tópicos',
    'OdbcEdit.access.threads.description' => 'O número de threads em segundo plano para o mecanismo utilizar.',
    'OdbcEdit.access.maxscanrows.label' => 'Máx. de linhas para escanear',
    'OdbcEdit.access.maxscanrows.description' => 'O número de linhas a ser escaneado ao definir o tipo de dados de uma coluna com base nos dados existentes.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Especificar como as alterações feitas fora de uma transação são gravadas no banco de dados.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Especificar se o driver do MS Access realizará transações definidas pelo usuário explícitas assincronicamente.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Servidor',
    'OdbcEdit.mssql.uid.label' => 'ID de login',
    'OdbcEdit.mssql.pwd.label' => 'Senha',
    'OdbcEdit.mssql.database.label' => 'Banco de Dados padrão',
    'OdbcEdit.mssql.app.label' => 'Nome do aplicativo',
    'OdbcEdit.mssql.wsid.label' => 'ID de estação de trabalho',
    'OdbcEdit.mssql.language.label' => 'Idioma-padrão',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversão de caracteres estendidos para os valores OEM',

    'OdbcEdit.mysql.driver.label' => 'Driver do MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Servidor',
    'OdbcEdit.mysql.server.description' => 'O nome do host do servidor MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'Banco de Dados padrão',
    'OdbcEdit.mysql.user.label' => 'Nome do usuário',
    'OdbcEdit.mysql.user.description' => 'O nome de usuário utilizado para a conexão ao MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Senha',
    'OdbcEdit.mysql.password.description' => 'A senha para a conta de usuário no servidor',
    'OdbcEdit.mysql.port.label' => 'Porta',
    'OdbcEdit.mysql.port.description' => 'A porta TCP/IP a ser utilizada se o servidor não for o host local',
    'OdbcEdit.mysql.socket.label' => 'Soquete',
    'OdbcEdit.mysql.socket.description' => 'Pipe nomeado do Windows a ser conectado se o servidor for o host local',
    'OdbcEdit.mysql.option.label' => 'Opção',
    'OdbcEdit.mysql.option.description' => 'Opções que especificam como o MyODBC deve funcionar. Consulte a <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentação</a>',

    'ProtectedDirectoryList.add' => 'Acrescente o diretório protegido',
    'ProtectedDirectoryList.addTooltip' => 'Criar um diretório protegido.',
    'ProtectedDirectoryList.name' => 'Nome',
    'ProtectedDirectoryList.realmTitle' => 'Título da área protegida',
    'ProtectedDirectoryList.noSelectionText' => 'Selecione um ou mais itens para remover.',
    'ProtectedDirectoryList.edit' => 'Editar',
    'ProtectedDirectoryList.remove' => 'Remover a proteção',
    'ProtectedDirectoryList.removeTooltip' => 'Remover a proteção dos diretórios selecionados.',
    'ProtectedDirectoryList.removeConfirmation' => 'Esta operação resultará na remoção da proteção de {count, plural, one {}=1 {o diretório {name}} other {# diretórios selecionados}}. {count, plural, one {}=1 {Este diretório} other {Os diretórios}} se tornará acessível aos usuários da Internet.',
    'ProtectedDirectoryList.removeSuccess' => 'Os diretórios selecionados foram removidos.',

    'ProtectedDirectoryAdd.title' => 'Criar um Diretório Protegido',
    'ProtectedDirectoryAdd.submit' => 'Criar',
    'ProtectedDirectoryAdd.success' => 'O diretório protegido %%path%% foi criado com êxito',

    'ProtectedDirectoryEdit.title' => 'Configurações de Diretório Protegido',
    'ProtectedDirectoryEdit.success' => 'As configurações do diretório protegido foram alteradas',

    'ProtectedDirectoryUserAdd.title' => 'Criar Usuário de Diretório Protegido',
    'ProtectedDirectoryUserAdd.subtitle' => 'Diretório %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Nome do usuário',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Senha',
    'ProtectedDirectoryUserAdd.submit' => 'Criar',
    'ProtectedDirectoryUserAdd.success' => 'O usuário do diretório protegido %%login%% foi criado.',

    'ProtectedDirectoryUserPassword.title' => 'Senha para o usuário de diretório protegido',
    'ProtectedDirectoryUserPassword.subtitle' => 'Usuário %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Senha',
    'ProtectedDirectoryUserPassword.submit' => 'Salvar',
    'ProtectedDirectoryUserPassword.success' => 'As credenciais do usuário foram salvas.',

    'SummaryReport.Layout.title' => 'Propriedades do layout de relatório',
    'SummaryReport.Layout.success' => 'O layout de relatório %%name%% foi atualizado.',

    'SummaryReport.Layout.Add.title' => 'Criar um layout de relatório',
    'SummaryReport.Layout.Add.success' => 'O layout de relatório %%name%% foi criado.',

    'SummaryReport.Report.buttonLayouts' => 'Layouts',
    'SummaryReport.Report.buttonSchedule' => 'Cronograma',
    'SummaryReport.Report.buttonProperties' => 'Propriedades',
    'SummaryReport.Report.buttonTrafficHistory' => 'Histórico de tráfego',
    'SummaryReport.Report.buttonPrint' => 'Impressão',
    'SummaryReport.Report.buttonSend' => 'Envie por e-mail',
    'SummaryReport.Report.successSent' => 'O relatório foi enviado para %%email%%',

    'SummaryReport.Schedule.Properties.title' => 'Cronograma de Entrega para %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'O horário de entrega de relatório foi atualizado.',

    'SummaryReport.Schedule.Add.title' => 'Criar Cronogramas de Entrega para %%name%%',
    'SummaryReport.Schedule.Add.success' => 'O horário de entrega de relatório foi criado.',

    'VirtualDirectory.errNotExist' => 'Este diretório virtual está vinculado a uma pasta física que não existe.',
    'VirtualDirectory.errNoPermissions' => 'Você não tem permissão para visualizar o conteúdo deste diretório.',
    'VirtualDirectory.buttonProperties' => 'Propriedades do diretório',
    'VirtualDirectory.buttonPropertiesHint' => 'Visualizar e alterar as propriedades do diretório virtual.',
    'VirtualDirectory.buttonPermissions' => 'Permissões de acesso do diretório',
    'VirtualDirectory.buttonPermissionsHint' => 'Configurar as permissões de acesso do diretório.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Defina as configurações do ASP.NET.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Defina as configurações do PHP.',
    'VirtualDirectory.tabBrowse' => 'Diretórios',
    'VirtualDirectory.tabBrowseHint' => 'Trabalhe com os arquivos e diretórios físicos e virtuais sob o site %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'Tipos de MIME',
    'VirtualDirectory.tabMimeTypesHint' => 'Gerenciar tipos MIME registrados.',
    'VirtualDirectory.tabErrorDocs' => 'Documentos de erro',
    'VirtualDirectory.tabErrorDocsHint' => 'Gerenciar documentos de erro.',
    'VirtualDirectory.tabProtection' => 'Proteção',
    'VirtualDirectory.tabProtectionHint' => 'Acesso restrito ao diretório com proteção de senha.',

    'VirtualDirectory.errorDocType.default' => 'Padrão',
    'VirtualDirectory.errorDocType.file' => 'Arquivo',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.CreateDirectory.title' => 'Criar o diretório',
    'VirtualDirectory.CreateDirectory.name' => 'Nome do diretório',
    'VirtualDirectory.CreateDirectory.success' => 'O diretório %%name%% foi criado.',
    'VirtualDirectory.CreateDirectory.errExists' => 'O diretório %%name%% já existe.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Criar um diretório virtual',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'O diretório %%name%% foi criado.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Propriedades do diretório virtual',
    'VirtualDirectory.EditVirtualDirectory.success' => 'O diretório virtual foi editado.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Fechar',

    'VirtualDirectory.MimeTypeList.add' => 'Adicionar o tipo de MIME',
    'VirtualDirectory.MimeTypeList.edit' => 'Editar o tipo de MIME',
    'VirtualDirectory.MimeTypeList.addHint' => 'Registrar um novo tipo de MIME.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Extensão',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Conteúdo',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Selecione um ou mais itens para remover.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Remover {count, plural, =1 {o tipo MIME selecionado} one {# tipo MIME selecionado} other {# tipos MIME selecionados}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Os tipos MIME selecionados foram removidos.',

    'VirtualDirectory.CreateMimeType.title' => 'Adicionar o tipo de MIME',
    'VirtualDirectory.CreateMimeType.success' => 'Os tipos MIME selecionados foram removidos.',

    'VirtualDirectory.EditMimeType.title' => 'Editar o tipo de MIME',
    'VirtualDirectory.EditMimeType.success' => 'O tipo MIME foi editado.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Erro',
    'VirtualDirectory.ErrorDocList.columnName' => 'Descrição',
    'VirtualDirectory.ErrorDocList.columnType' => 'Tipo',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Localização',
    'VirtualDirectory.ErrorDocList.edit' => 'Editar',

    'VirtualDirectory.EditErrorDoc.title' => 'Editar Documento de Erro',
    'VirtualDirectory.EditErrorDoc.success' => 'O documento de erro foi editado.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Erro',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Tipo',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Localização',

    'VirtualDirectory.Protection.notSupported' => 'A proteção de diretório não é suportada para este diretório porque seu nome excede 245 caracteres ou contém caracteres não suportados.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'A proteção do diretório virtual está desativada',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Proteger',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'O diretório %%path%% foi protegido.',
    'VirtualDirectory.Protection.tools' => 'Ferramentas',
    'VirtualDirectory.Protection.removeProtection' => 'Remover proteção',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Tornar a URL correspondente ao diretório acessível para todos.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Remover proteção do diretório virtual? Isso também removerá todos os usuários protegidos do diretório e as configurações de proteção do diretório.',
    'VirtualDirectory.Protection.settings' => 'Configurações',
    'VirtualDirectory.Protection.settingsTooltip' => 'Visualizar a localização do diretório e especificar um título para a área protegida.',

    'VirtualDirectory.AspDotNet.title' => 'Defina Configurações do ASP.NET',

    'VirtualDirectory.Php.title' => 'Versão do PHP',
    'VirtualDirectory.Php.version' => 'Versão',
    'VirtualDirectory.Php.success' => 'A versão do PHP foi atualizada.',


    'MassMailPage.sendEmail' => 'Envie e-mail em massa',
    'MassMailPage.selectAtLeastOneTemplate' => 'Selecione pelo menos um modelo',
    'MassMailPage.confirmRemoval' => 'Tem certeza de que deseja remover o {count, select, 1 {modelo} other {modelos}} selecionado(s)?',
    'MassMailPage.remove' => 'Remover',
    'MassMailPage.filters' => 'Filtros',
    'MassMailPage.name' => 'Nome do Modelo',
    'MassMailPage.sender' => 'Remetente',
    'MassMailPage.recipients' => 'Destinatários',
    'MassMailPage.subject' => 'Assunto',
    'MassMailPage.created' => 'Data de Criação',
    'MassMailPage.send' => 'Enviar',
    'MassMailPage.recipientsNone' => 'Nenhum',
    'MassMailPage.recipientsAdmins' => 'Administrador',
    'MassMailPage.recipientsResellers' => 'Todos os revendedores',
    'MassMailPage.recipientsResellersSelected' => 'Revendedores selecionados',
    'MassMailPage.recipientsResellersExcept' => 'Todos os revendedores, exceto os selecionados',
    'MassMailPage.recipientsClients' => 'Todos os clientes',
    'MassMailPage.recipientsClientsSelected' => 'Clientes selecionados',
    'MassMailPage.recipientsClientsExcept' => 'Todos os clientes, exceto os selecionados',
    'MassMailPage.templatesRemoved' => '{count, select, 1 {Modelo} other {Modelos}} Removido(s).',
    'MassMailPage.emptyViewTitle' => 'Nenhum modelo de mensagem de e-mail em massa',
    'MassMailPage.addNew' => 'Criar modelo',
    'CreateMassMailTemplatePage.templateCreated' => 'O modelo foi criado.',
    'EditMassMailTemplatePage.templateUpdated' => 'O modelo foi atualizado.',
    'SendMassMailPage.emailSent' => 'O e-mail foi enviado.',
    'SendMassMailPage.fieldIsRequired' => 'O campo não pode estar vazio',
    'SendMassMailPage.saveAsTemplate' => 'Salvar a mensagem composta em um novo modelo',
    'SendMassMailPage.newTemplateName' => 'Novo nome do modelo',
    'SendMassMailPage.selectedTemplate' => 'Modelo selecionado',
    'SendMassMailPage.send' => 'Enviar',
    'VirtualHostTemplatePage.name' => 'Nome',
    'VirtualHostTemplatePage.sizeInBytes' => 'Tamanho',
    'VirtualHostTemplatePage.modified' => 'Data de modificação',
    'VirtualHostTemplatePage.permissions' => 'Permissões',
    'VirtualHostTemplatePage.user' => 'Usuário',
    'VirtualHostTemplatePage.group' => 'Grupo',
    'VirtualHostTemplatePage.uploadTemplate' => 'Upload',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'O modelo foi carregado.',
    'VirtualHostTemplatePage.root' => 'Diretório de Modelos Virtuais',
    'VirtualHostTemplatePage.emptyViewTitle' => 'Nenhum arquivo no modelo',
    'VirtualHostTemplatePage.total' => 'Total de itens no diretório {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Definir padrão',
    'VirtualHostTemplatePage.successfullyReset' => 'O modelo foi alterado para padrão.',

    'TrafficUsageByDomain.List.service' => 'Serviço',
    'TrafficUsageByDomain.List.usage' => 'Utilizado',
    'TrafficUsageByDomain.List.incoming' => 'Em',
    'TrafficUsageByDomain.List.outgoing' => 'Fora',
    'TrafficUsageByDomain.List.percentOfAll' => '% de todos',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Nome do domínio',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Nome do proprietário",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Utilizado',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Limite',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Disponível',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Usado (em %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Apenas meus domínios',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'Somente domínios de revendedor',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Nome do proprietário',

    'TrafficUsageByReseller.emptyView' => 'O revendedor não tem clientes',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "Domínios próprios do revendedor",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "Domínios dos clientes revendedores: %%usage%%",

    'InfoAndStatistics.Main.title' => 'Informação e Estatísticas',
    'InfoAndStatistics.Main.overview' => 'Visão geral',
    'InfoAndStatistics.Main.domains' => 'Domínios',
    'InfoAndStatistics.Main.trafficUsage' => 'Uso de tráfego',
    'InfoAndStatistics.Main.reports' => 'Relatórios',
    'InfoAndStatistics.Main.serverSettings' => 'Configurações do servidor',
    'InfoAndStatistics.TrafficUsage.customers' => 'Clientes',
    'InfoAndStatistics.TrafficUsage.resellers' => 'Revendedores',
    'InfoAndStatistics.TrafficUsage.domains' => 'Domínios',
];