<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'Lizenznummer',
    'additional-keys.keyName' => 'Name des Schlüssels',
    'additional-keys.keyApp' => 'Anwendung',
    'additional-keys.addGroup' => 'Hinzufügen',
    'additional-keys.upload' => 'Neuen Schlüssel installieren',
    'additional-keys.uploadDescription' => 'Neuen Lizenzschlüssel hochladen und installieren.',
    'additional-keys.actionsGroup' => 'Aktionen',
    'additional-keys.install' => 'Installieren',
    'additional-keys.installAll' => 'Alle installieren',
    'additional-keys.installDescription' => 'Installieren Sie die ausgewählten Lizenzschlüssel.',
    'additional-keys.installNoSelection' => 'Wählen Sie einen oder mehrere zusätzliche Lizenzschlüssel aus, die Sie installieren möchten, oder klicken Sie auf "Alle installieren".',
    'additional-keys.installSuccess' => 'Die Installation des Lizenzschlüssels ist gestartet.',
    'additional-keys.removeGroup' => 'Entfernen',
    'additional-keys.remove' => 'Entfernen',
    'additional-keys.removeDescription' => 'Die ausgewählten Lizenzschlüssel löschen.',
    'additional-keys.removeNoSelection' => 'Wählen Sie einen oder mehrere zusätzliche Lizenzschlüssel zum Löschen aus.',
    'additional-keys.removeConfirmation' => 'Möchten Sie {count, plural, =1 {den Lizenzschlüssel {name}} one {den # ausgewählten Lizenzschlüssel} other {die # ausgewählten Lizenzschlüssel}} entfernen?',
    'additional-keys.removeSuccess' => 'Die ausgewählten Lizenzschlüssel wurden entfernt.',
    'additional-keys.download' => 'Schlüssel herunterladen',
    'additional-keys.downloadDescription' => 'Lizenzschlüssel herunterladen.',
    'additional-keys.emptyViewTitle' => 'Keine zusätzlichen Lizenzschlüssel',

    'backup.tasks.startDate' => 'Gestartet am',
    'backup.tasks.targetRepo' => 'Zielspeicher',
    'backup.tasks.progress' => 'Aufgabenfortschritt',
    'backup.tasks.repoTypeLocal' => 'Server',
    'backup.tasks.repoTypeFtp' => 'Persönlicher FTP',
    'backup.tasks.buttonRemoveTask' => 'Entfernen',
    'backup.tasks.hintRemoveTask' => 'Entfernen Sie die ausgewählten Backup-Aufgaben.',
    'backup.tasks.buttonReload' => 'Neu laden',
    'backup.tasks.hintReload' => 'Laden Sie die Aufgabenliste neu, um den aktuellen Status zu sehen.',
    'backup.tasks.statusTaskWarnings' => 'Warnungen',
    'backup.tasks.statusTaskInfo' => 'Information',
    'backup.tasks.statusTaskFailed' => 'Fehlgeschlagen',

    'backup.disabledSelectHint' => 'Das Backup kann nicht entfernt werden, da es Teil eines Server-, Reseller- oder Kundenbackups ist.',
    'backup.buttonBackup' => 'Backup erstellen',
    'backup.hintBackup' => 'Erstellen Sie ein Backup.',
    'backup.buttonSchedule' => 'Zeitplan',
    'backup.hintSchedule' => 'Geben Sie die Einstellungen für eine geplante Backup-Aufgabe an.',
    'backup.buttonReload' => 'Neu laden',
    'backup.hintReload' => 'Laden Sie die Backup-Liste neu.',
    'backup.buttonUpload' => 'Hochladen',
    'backup.hintUpload' => 'Laden Sie eine Backupdatei aus Ihrem Computer in den Server-Backupspeicher hoch.',
    'backup.buttonSettings' => 'Einstellungen',
    'backup.hintSettings' => 'Konfigurieren Sie die globalen Datenbackupeinstellungen, um die CPU-Auslastung des Servers zu reduzieren.',
    'backup.buttonRemoteStorages' => 'Einstellungen für den Remote-Speicher',
    'backup.hintRemoteStorages' => 'Konfigurieren Sie Ihren persönlichen Remote-Speicher zur Aufbewahrung von Backupdateien.',
    'backup.buttonRemove' => 'Entfernen',
    'backup.hintRemove' => 'Entfernen Sie die ausgewählten Backups aus dem Serverspeicher.',
    'backup.systemNotes' => 'Systemhinweise',
    'backup.incremental' => 'Inkrementell.',
    'backup.multiVolume' => 'Auf mehreren Datenträgern.',
    'backup.remoteStorage' => 'Im Speicher: %%storage%%',
    'backup.status' => 'S',
    'backup.statusOff' => 'Dies ist kein gültiges Backup. Es können keine Daten von dieser Datei wiederhergestellt werden. Klicken Sie auf den Backupnamen, um Einzelheiten zu erfahren.',
    'backup.statusWarning' => 'Dieses Backup ist nicht ganz gültig. Klicken Sie auf den Backupnamen, um Einzelheiten zu erfahren.',
    'backup.statusInfo' => 'Dies ist ein gültiges Backup. Anhand dieses Backups können Daten wiederhergestellt werden, jedoch könnten mit der Art, wie die Daten gespeichert sind, geringfügige Probleme auftreten.',
    'backup.statusOn' => 'Dies ist ein gültiges Backup. Die Daten können aus dieser Datei wiederhergestellt werden.',
    'backup.date' => 'Erstellungsdatum',
    'backup.name' => 'Name',
    'backup.comment' => 'Anmerkungen',
    'backup.size' => 'Größe',
    'backup.download' => 'Laden Sie die Backupdatei auf Ihren lokalen Computer.',
    'backup.downloadDisabled' => 'Das Herunterladen der Backupdatei ist temporär nicht möglich. Versuchen Sie es später erneut, oder wenden Sie sich an Ihren Service-Provider.',
    'backup.total' => 'Backups gesamt: %%total%%, Größe: %%totalSize%%',
    'backup.totalFound' => '%%found%% Backups gefunden (%%total%% gesamt), Größe: %%totalSize%%',
    'backup.confirmOnDelete' => 'Möchten Sie die ausgewählten Backups entfernen?',
    'backup.incrementsRemovalLoading' => 'Lade...',
    'backup.incrementsRemovalConfirmation' => 'Ich bestätige, dass ich die ausgewählten Backups entfernen will.',
    'backup.backupHasIncrements' => 'Das Backup %%backupName%% wird zusammen mit den inkrementellen Sicherungsabschnitten entfernt: %%backupIncrements%%',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Inkorrekter Benutzername oder inkorrektes Passwort für FTP-Speicher',
    'backup.ftpStorageErrorResolveHost' => "Hostname kann nicht aufgelöst werden",
    'backup.ftpStorageErrorConnection' => "Verbindung zum Remoteserver nicht möglich",
    'backup.unableToGetFtpDumpList' => 'Die Liste der Backups im FTP-Speicher kann nicht angezeigt werden: %%errorMessage%%. Überprüfen Sie die <a href="%%ftpSettingsUrl%%">Einstellungen zum FTP-Speicher</a>.',
    'backup.unableToGetExtDumpList' => 'Die Liste der Backups im Speicher %%storageTitle%% konnte nicht angezeigt werden: %%errorMessage%%. Bitte überprüfen Sie die Speichereinstellungen.',
    'backup.unableToGetLocalDumpList' => 'Die Liste der im Server gespeicherten Backups kann nicht angezeigt werden: %%errorMessage%%',
    'backup.skippedFilesAtExtStorage' => 'Einige Dateien im Speicher %%storageTitle%% werden nicht in der Liste angezeigt, da ihre Namen nicht der Namenskonvention für Backupdateien entsprechen. Wenn Sie sich sicher sind, dass die Dateien gültige Backups sind, benennen Sie sie nach dem folgenden Muster: "backup_%%objectName%%<YYMMDDHHmm>.%%ext%%"',
    'backup.multiVolumeShow' => 'Laufwerke einblenden',
    'backup.multiVolumeHide' => 'Laufwerke ausblenden',
    'backup.backEncryptionRequired' => 'Aus Sicherheitsgründen empfehlen wir, die Daten, die in den Backups enthalten sind, zu schützen. Bitte gehen Sie zu %%link%% und aktualisieren Sie die Einstellungen zur Backupsicherheit.',
    'backup.backupSettingPage' => 'Backup-Einstellungen',
    'backup.statusTaskProgress' => 'Die Backup-Aufgabe wird ausgeführt.',
    'backup.statusTaskWarnings' => 'Die Backup-Aufgabe wurde mit Warnmeldungen fertiggestellt.',
    'backup.statusTaskInfo' => 'Informationen.',
    'backup.statusTaskFailed' => 'Die Backup-Aufgabe ist fehlgeschlagen.',
    'backup.statusTaskStopping' => 'Die Backup-Aufgabe wird angehalten.',
    'backup.statusTaskStopped' => 'Die Backup-Aufgabe wurde angehalten.',

    'backup.schedule.columnSchedule' => 'Zeitplan',
    'backup.schedule.columnContent' => 'Inhalt',
    'backup.schedule.columnStorage' => 'Speicher',
    'backup.schedule.periodHourly' => 'Mehrmals täglich',
    'backup.schedule.periodHourlySchedule' => 'nach {period, plural, one {# Stunde} other {# Stunden}}',
    'backup.schedule.periodDaily' => 'Täglich',
    'backup.schedule.periodDailySchedule' => 'um %%hours%%:%%minutes%%',
    'backup.schedule.periodWeekly' => 'Wöchentlich',
    'backup.schedule.periodWeeklySchedule' => 'am %%day%% um %%hours%%:%%minutes%%',
    'backup.schedule.periodMonthly' => 'Monatlich',
    'backup.schedule.periodMonthlySchedule' => 'am %%day%% Tag um %%hours%%:%%minutes%%',
    'backup.schedule.periodCustom' => 'Benutzerdefiniert',
    'backup.schedule.dayFirst' => 'erster',
    'backup.schedule.dayLast' => 'letzter',
    'backup.schedule.day' => '{day, selectordinal, other {#.}}',
    'backup.schedule.storageLocal' => 'Serverspeicher',
    'backup.schedule.storageBoth' => 'Sowohl Serverspeicher als auch %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'Das geplante Backup wurde deaktiviert',

    'custombuttons.buttonAdd' => 'Link zu Service hinzufügen',
    'custombuttons.buttonAddDescription' => 'Fügen Sie einen Link zu einem Online-Service hinzu und platzieren Sie diesen in Plesk.',
    'custombuttons.buttonRemove' => 'Entfernen',
    'custombuttons.buttonRemoveDescription' => 'Löschen Sie die ausgewählten Links.',
    'custombuttons.removeConfirmMessage' => 'Ausgewählte Links entfernen?',
    'custombuttons.headerPublic' => 'A',
    'custombuttons.headerLocation' => 'L',
    'custombuttons.headerImage' => 'Bild',
    'custombuttons.headerPriority' => 'Priorität',
    'custombuttons.headerLabel' => 'Beschriftung',
    'custombuttons.headerUrl' => 'URL',
    'custombuttons.headerDescription' => 'Beschreibung',
    'custombuttons.publicEnabledDescription' => 'Der Links ist für Benutzer sichtbar.',
    'custombuttons.publicDisabledDescription' => 'Der Links ist nicht für Benutzer sichtbar.',
    'custombuttons.altPublicEnabledIcon' => 'Öffentlich',
    'custombuttons.altPublicDisabledIcon' => 'Privat',
    'custombuttons.placeNavigationDescription' => 'Der Link befindet sich auf allen Seiten.',
    'custombuttons.placeAdminDescription' => 'Der Link befindet sich auf der Homepage des Administrators.',
    'custombuttons.placeAdminSettingsDescription' => 'Der Link befindet sich auf der Administratorseite der Tools & Einstellungen.',
    'custombuttons.placeResellerDescription' => 'Der Link befindet sich auf der Homepage des Resellers',
    'custombuttons.placeResellerSettingsDescription' => 'Der Link befindet sich auf der Resellerseite der Tools & Dienstprogramme.',
    'custombuttons.placeClientDescription' => 'Der Link befindet sich auf der Homepage des Kunden.',
    'custombuttons.placeDomainDescription' => 'Der Link befindet sich auf der Seite "Websites & Domains" des Abonnements.',
    'custombuttons.placeDomainPropertiesDescription' => 'Der Link befindet sich im Bereich der Website-Tools, der sich auf der Seite "Websites & Domains" durch einen Klick auf "Mehr anzeigen" unter einem Domainnamen öffnet.',

    'databaseservers.addGroup' => 'Hinzufügen',
    'databaseservers.addDatabaseServer' => 'Datenbankserver hinzufügen',
    'databaseservers.addDatabaseServerDescription' => 'Fügen Sie einen Datenbankserver hinzu.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'Remote-Datenbankhosting wird mit diesem Lizenzschlüssel nicht unterstützt.',
    'databaseservers.actionsGroup' => 'Aktionen',
    'databaseservers.hostingSettings' => 'Einstellungen',
    'databaseservers.hostingSettingsDescription' => 'Datenbank-Hosting-Einstellungen.',
    'databaseservers.refresh' => 'Aktualisieren',
    'databaseservers.refreshDescription' => 'Informationen zu Datenbankservern aktualisieren.',
    'databaseservers.removeGroup' => 'Entfernen',
    'databaseservers.remove' => 'Entfernen',
    'databaseservers.removeDescription' => 'Ausgewählte Datenbankserver löschen.',
    'databaseservers.lastError' => 'S',
    'databaseservers.type' => 'Servertyp',
    'databaseservers.host' => 'Hostname',
    'databaseservers.hostLink' => 'Eigenschaften des Datenbankservers anzeigen oder ändern.',
    'databaseservers.port' => 'Port',
    'databaseservers.version' => 'Version',
    'databaseservers.databasesCount' => 'Datenbanken',
    'databaseservers.databasesCountLink' => 'Auf diesem Server gehostete Datenbanken verwalten.',
    'databaseservers.databaseUpgradeLink' => 'Auf diesem Server gehosteten Datenbankserver upgraden.',
    'databaseservers.databasesLTSVersion' => 'Sie haben bereits eine Version für die langfristige Unterstützung. Plesk aktualisiert Ihre MariaDB/MySQL-Installation automatisch auf neuere kleinere Releases.',
    'databaseservers.webadmin' => 'Webadmin',
    'databaseservers.webadminHint' => 'Greifen Sie via DB Webadmin auf diesen Server zu.',
    'databaseservers.downloadMsSqlClient' => 'Lokalen SQL-Client herunterladen',
    'databaseservers.downloadMsSqlClientHint' => 'Lokalen SQL-Client herunterladen',
    'databaseservers.changePassword' => 'Administratorpasswort ändern',
    'databaseservers.changePasswordHint' => 'Passwort des Datenbankserveradministrators ändern.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Microsoft SQL-Server',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'Standard für MySQL',
    'databaseservers.default_for_mssql' => 'Standard für MS SQL',
    'databaseservers.default_for_postgresql' => 'Standard für PostgreSQL',
    'databaseservers.default_for_mariadb' => 'Standard für MariaDB',
    'databaseservers.default_for_percona' => 'Standard für Percona',
    'databaseservers.status_no_error' => 'Der letzte Verbindungsversuch zu diesem Server war erfolgreich.',
    'databaseservers.status_connection_failed' => 'Der letzte Versuch, eine Verbindung zu diesem Server herzustellen, schlug aufgrund von Netzwerkproblemen fehl.',
    'databaseservers.status_permission_denied' => 'Beim letzten Verbindungsversuch zu diesem Server wurde der Zugriff verweigert. Bitte überprüfen Sie die Administrator-Zugangsdaten für den Server.',
    'databaseservers.status_other_error' => 'Während des letzten Verbindungsversuches zu diesem Server ist ein Fehler aufgetreten.',
    'databaseservers.status_credentials_not_set' => 'Sie müssen einen gültigen Administratorbenutzernamen und ein gültiges Passwort eingeben, damit Plesk eine Verbindung zu diesem Server herstellen kann.',
    'databaseservers.mssqlServerPortUndefined' => 'Die von Microsoft SQL Server %%host%% genutzte TCP-Portnummer kann nicht bestimmt werden: In der Netzwerkkonfiguration des Servers ist das TCP/IP-Protokoll nicht aktiviert oder der Server ist für die Nutzung von dynamischen TCP-Ports konfiguriert.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'Um Ihren Kunden zu ermöglichen, die Firewall automatisch für den Remote-Zugriff auf Datenbanken zu konfigurieren, müssen Sie den SQL Server manuell so konfigurieren, dass er immer über einen bestimmten TCP-Port kommuniziert.',
    'databaseservers.removeEmptySelection' => 'Keine Datenbankserver ausgewählt.',
    'databaseservers.removeConfirmation' => 'Möchten Sie {count, plural, =1 {den Datenbankserver {name}} one {den # ausgewählten Datenbankserver} other {die # ausgewählten Datenbankserver}} wirklich entfernen?',
    'databaseservers.removeSuccess' => 'Die ausgewählten Datenbankserver wurden entfernt.',
    'databaseservers.upgradeNow' => 'Jetzt upgraden',


    'databaseserverdatabases.actionsGroup' => 'Aktionen',
    'databaseserverdatabases.assignToSubscription' => 'Zu Abonnement verschieben',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'Verschieben Sie die ausgewählten Datenbanken zu einem anderen Abonnement.',
    'databaseserverdatabases.removeGroup' => 'Entfernen',
    'databaseserverdatabases.remove' => 'Entfernen',
    'databaseserverdatabases.removeDescription' => 'Ausgewählte Datenbanken löschen',
    'databaseserverdatabases.name' => 'Name',
    'databaseserverdatabases.subscription' => 'Abonnement',
    'databaseserverdatabases.client' => 'Abonnent',
    'databaseserverdatabases.manageDatabase' => 'Hosting verwalten',
    'databaseserverdatabases.manageDatabaseDescription' => 'Verwalten Sie den Datenbankserver.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Im Reseller-Panel öffnen',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Verwalten Sie die Datenbank im Reseller-Panel des Abonnenten.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Im Kunden-Panel öffnen',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Verwalten Sie die Datenbank im Kunden-Panel des Abonnenten.',
    'databaseserverdatabases.emptySelection' => 'Keine Datenbanken ausgewählt.',
    'databaseserverdatabases.removeConfirmation' => 'Möchten Sie {count, plural, =1 {die Datenbank {name}} one {die # ausgewählte Datenbank} other {die # ausgewählten Datenbanken}} wirklich entfernen?',
    'databaseserverdatabases.removeSuccess' => 'Die ausgewählten Datenbankserver wurden entfernt.',

    'logbrowser.issuesFoundInTheLogs' => 'Probleme in den Website-Protokollen',
    'logbrowser.learnAboutProblemsFaster' => 'Probleme mit der Website schneller erkennen',
    'logbrowser.noProblemsFound' => 'Keine Probleme in den Website-Protokollen',
    'logbrowser.lastCheckDetectsProblems' => 'Bei der Überprüfung der Protokolle "%%checkType%%" wurden Probleme erkannt, die den Betrieb Ihrer Website beeinträchtigen können. Um die Details und mögliche Lösungen zu sehen, klicken Sie auf "Prüfbericht öffnen".',
    'logbrowser.lastCheckDetectsNoProblems' => 'Bei der Überprüfung der Protokolle "%%checkType%%" wurden keine Probleme erkannt, die den Betrieb Ihrer Website beeinträchtigen könnten.',
    'logbrowser.noChecksResults' => 'Eine automatische tägliche Überprüfung ist aktiviert und wird innerhalb der nächsten 24 Stunden durchgeführt.',
    'logbrowser.manual' => 'Manuell',
    'logbrowser.regular' => 'Automatisch täglich',
    'logbrowser.enableRegularCheck' => 'Dank der täglichen Überprüfung der Protokolle werden Probleme erkannt, die den Betrieb Ihrer Website beeinträchtigen können. Falls Probleme auftreten, informiert Plesk Sie und bietet mögliche Lösungen an.',
    'logbrowser.new' => 'NEU',
    'logbrowser.openCheckReport' => 'Prüfbericht öffnen',
    'logbrowser.openCheckSettings' => 'Prüfungseinstellungen öffnen',

    'logbrowser.buttonStartRealtime' => 'Echtzeitaktualisierung starten',
    'logbrowser.buttonStartRealtimeHint' => 'Aktualisieren Sie die Protokolldaten in Echtzeit.',
    'logbrowser.buttonStopRealtime' => 'Echtzeitaktualisierung beenden',
    'logbrowser.buttonStopRealtimeHint' => 'Beenden Sie die Aktualisierung der Protokolldaten in Echtzeit.',
    'logbrowser.buttonRefresh' => 'Aktualisieren',
    'logbrowser.buttonRefreshHint' => 'Aktualisieren Sie die Protokolldaten.',
    'logbrowser.buttonClear' => 'Auswahl aufheben',
    'logbrowser.buttonClearHint' => 'Bereits geladene Einträge ausblenden.',
    'logbrowser.buttonAddCustom' => 'Als benutzerdefinierte Datei zum Protokollbrowser hinzufügen',
    'logbrowser.buttonAddCustomHint' => 'Die Datei wird zusammen mit anderen Protokolldateien im Protokollbrowser angezeigt.',
    'logbrowser.date' => 'Datum',
    'logbrowser.dateFilterPlaceholder' => 'Ab',
    'logbrowser.type' => 'Typ',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Code',
    'logbrowser.codeFilterPlaceholder' => 'Code',
    'logbrowser.message' => 'Nachricht',
    'logbrowser.messageFilterPlaceholder' => 'Nachricht',
    'logbrowser.source' => 'Quelle',
    'logbrowser.sourceFilterFiles' => '%%count%% Dateien',
    'logbrowser.sourceFilterAllLogs' => 'Alle Protokolle',
    'logbrowser.sourceFilterNoLogs' => 'Keine Protokolle',
    'logbrowser.manageLogFiles' => 'Protokolldateien verwalten',
    'logbrowser.addCustomLogFile' => 'Benutzerdefiniertes Protokoll hinzufügen',
    'logbrowser.customLogPopupTitle' => 'Benutzerdefiniertes Protokoll hinzufügen',
    'logbrowser.invalidLogFormat' => 'Das Format der Protokolldatei wird nicht unterstützt',
    'logbrowser.referer' => 'R',
    'logbrowser.refererHint' => 'Referrer',
    'logbrowser.agent' => 'Agent',
    'logbrowser.agentHint' => 'Benutzer-Agent',
    'logbrowser.size' => 'Größe',
    'logbrowser.unknown' => 'Unbekannt',
    'logbrowser.more' => 'Mehr',
    'logbrowser.less' => 'Weniger',
    'logbrowser.any' => 'Beliebig',
    'logbrowser.none' => 'Keiner',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% oder verwenden Sie die Filter, um die angezeigten Einträge einzugrenzen.',
    'logbrowser.loadMore' => 'Laden Sie vorherige Einträge',
    'logbrowser.clear' => 'Auswahl aufheben',
    'logbrowser.hourAgo' => 'Letzte Stunde',
    'logbrowser.prevDay' => 'Vorheriger Tag',
    'logbrowser.linkInMessageToViewFile' => 'Klicken Sie, um die Datei anzuzeigen.',
    'logbrowser.buttonUnlinkHint' => 'Klicken Sie, um Updates in dieser Datei nicht mehr im Protokollbrowser zu verfolgen',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Möchten Sie wirklich Updates in dieser Datei nicht mehr im Protokollbrowser verfolgen?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Ja',
    'logbrowser.buttonUnlinkConfirmationNo' => 'Nein',
    'logbrowser.logRotation' => 'Protokollrotation',
    'logbrowser.logRotationHint' => 'Konfigurieren Sie die Einstellungen zur Protokollrotation für die Website.',
    'logbrowser.logRotationTitle' => 'Protokollrotation konfigurieren',

    'notifications.title' => 'Versenden von E-Mail-Benachrichtigungen über Systemereignisse einrichten',
    'notifications.legendNotifications' => 'Benachrichtigungen',
    'notifications.legendSettings' => 'Einstellungen',
    'notifications.headerEvent' => 'Ereignis',
    'notifications.headerSendTo' => 'Hinweis senden an:',
    'notifications.headerText' => 'Text',
    'notifications.headerPreview' => 'Vorschau',
    'notifications.headerAdmin' => 'Administrator',
    'notifications.headerReseller' => 'Reseller',
    'notifications.headerClient' => 'Kunde',
    'notifications.headerEmailAddress' => 'E-Mail-Adresse',
    'notifications.expirationTime' => 'Ablaufwarnungen senden',
    'notifications.days' => 'Tage im Voraus',
    'notifications.smtpSettings' => 'Damit Plesk Benachrichtigungen senden kann, wenn das Relay geschlossen ist, können Sie %%link%%',
    'notifications.smtpSettingsLink' => 'die SMTP-Einstellungen ändern',
    'notifications.editHint' => 'Notiztext bearbeiten.',
    'notifications.previewHint' => 'Sehen Sie sich an, wie die Benachrichtigung in E-Mails aussieht.',
    'notifications.reseller_creation' => 'Erstellen von Reseller-Konto',
    'notifications.reseller_limits_exceed' => 'Grenzwert des Ressourcenverbrauchs vom Reseller-Konto überschritten',
    'notifications.reseller_blocked' => 'Reseller-Konto aufgrund von Ressourcen-Überbeanspruchung gesperrt',
    'notifications.reseller_overuse_block' => 'Ressourcenverbrauchsgrenzen des Resellers von den Abonnements des Resellers aufgrund von Overselling erreicht',
    'notifications.client_creation' => 'Erstellen von Kundenkonto',
    'notifications.domain_creation' => 'Erstellen von Websites',
    'notifications.domain_exp_warning' => 'Warnung zum Ablauf des Abonnements',
    'notifications.domain_expiration' => 'Ablauf des Abonnements',
    'notifications.domain_limits_exceed' => 'Grenzwert des Ressourcenverbrauchs vom Abonnement überschritten',
    'notifications.domain_blocked' => 'Abonnement aufgrund von Überbeanspruchung der Ressourcen gesperrt',
    'notifications.admin_aps_app_updates' => 'Updates für APS-Anwendungen (Übersicht für Administratoren)',
    'notifications.reseller_aps_app_updates' => 'Updates für APS-Anwendungen (Übersicht für Reseller)',
    'notifications.client_aps_app_updates' => 'Updates für APS-Anwendungen (Übersicht für Kunden)',
    'notifications.admin_pum_updates' => 'Systemupdates: Benachrichtigungen zu neuen Updates',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'Die ausgehenden E-Mails haben den Grenzwert überschritten',
    'notifications.subscription_cgroups_limits_exceed' => 'RAM, CPU, Datenträger-E/A (Cgroups)',
    'notifications.admin_postponed_feedback' => 'Feedback-Erinnerung',
    'notifications.errorInvalidEmail' => 'Ungültige E-Mail-Adresse.',
    'notifications.errorInvalidExpTime' => 'Anzahl der Tage ist ungültig.',
    'notifications.errorUpdate' => 'Benachrichtigung kann nicht aktualisiert werden: %%error%%',
    'notifications.updated' => 'Einstellungen für die Benachrichtigungen wurden aktualisiert',

    'outgoingmail.name' => 'Name',
    'outgoingmail.maxOutgoingMessages' => 'Grenze pro Stunde',
    'outgoingmail.numOfExceedingAttempts' => 'Versuche nach Erreichen der Grenze',
    'outgoingmail.lastAttemptAt' => 'Letzter Versuch',
    'outgoingmail.mailStatus' => 'E-Mail-Status',
    'outgoingmail.mailStatusSending' => 'Wird gesendet',
    'outgoingmail.mailStatusNotSending' => 'Wird nicht gesendet',
    'outgoingmail.mailStatusSendingDesc' => 'E-Mails werden gesendet.',
    'outgoingmail.mailStatusNotSendingDesc' => 'E-Mails werden nicht gesendet.',
    'outgoingmail.limitValueUnlimited' => 'Unbegrenzt',

    'scheduler.tasks.headerCommand' => 'Befehl',
    'scheduler.tasks.headerSchedule' => 'Zeitplan',
    'scheduler.tasks.headerSubscription' => 'Abonnement',
    'scheduler.tasks.headerSubscription_powerUser' => 'Webspace',
    'scheduler.tasks.buttonToggleHintOn' => 'Die Aufgabe ist aktiviert. Klicken Sie hier, um die Aufgabe zu deaktivieren.',
    'scheduler.tasks.buttonToggleHintOff' => 'Die Aufgabe ist deaktiviert. Klicken Sie hier, um die Aufgabe zu aktivieren.',
    'scheduler.tasks.add' => 'Aufgabe hinzufügen',
    'scheduler.tasks.hintAdd' => 'Planen Sie eine neue Aufgabe.',
    'scheduler.tasks.remove' => 'Entfernen',
    'scheduler.tasks.hintRemove' => 'Entfernen Sie die ausgewählten Aufgaben.',
    'scheduler.tasks.confirmOnDelete' => 'Möchten Sie die ausgewählten Aufgaben entfernen?',
    'scheduler.tasks.sync' => 'Aktualisieren',
    'scheduler.tasks.hintSync' => 'Laden Sie die Aufgabenliste neu, um die aktuellen Daten zu sehen.',
    'scheduler.tasks.settings' => 'Einstellungen',
    'scheduler.tasks.hintSettings' => 'Bearbeiten Sie die Einstellungen für geplante Aufgaben.',
    'scheduler.tasks.deleteSuccess' => 'Die geplanten Aufgaben wurden entfernt.',
    'scheduler.tasks.serverTask' => 'Server (Benutzer: %%user%%)',
    'scheduler.tasks.unknownUser' => 'nicht bekannt',
    'scheduler.tasks.runTaskNow' => 'Jetzt ausführen',
    'scheduler.tasks.runTaskNowHint' => 'Lassen Sie die Aufgabe jetzt ausführen.',
    'scheduler.tasks.runningTask' => 'Führe Aufgabe "%%task%%" aus...',

    'server-components.bcTitle' => 'Serverkomponenten',
    'server-components.title' => 'Plesk Komponenten',
    'server-components.name' => 'Komponentenname',
    'server-components.version' => 'Komponentenversion',
    'server-components.refresh' => 'Aktualisieren',
    'server-components.componentName' => 'Name der Plesk Komponente eingeben ...',
    'server-components.noComponents' => 'Keine Komponenten gefunden',
    'server-components.componentsListUpdated' => 'Die Liste der Komponenten wurde aktualisiert',

    'server-components.componentName.urlrewrite' => 'URL neu schreiben',
    'server-components.componentName.dbconnector' => "Datenbank-Connector",
    'server-components.componentName.mysqlserver' => 'MariaDB/MySQL Server',
    'server-components.componentName.troubleshooting' => 'Problembehandlung',
    'server-components.componentName.waf' => 'Web Application Firewall',
    'server-components.componentName.vcs' => 'Versionskontrollsystem',
    'server-components.componentName.dotnetcore' => '.NET Core',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Anwendungsinitialisierung",
    'server-components.componentName.cors' => "Cross-Origin Resource Sharing",
    'server-components.componentName.httpcompression' => 'Komprimierung von HTTP-Inhalt',
    'server-components.componentName.antivirus' => "Virenschutz",
    'server-components.componentName.database' => "SQL-Server",
    'server-components.componentName.sqladmin' => "MariaDB/MySQL Webadmin",
    'server-components.componentName.sqladminmysql' => "MariaDB/MySQL Webadmin",
    'server-components.componentName.dnsserver' => "DNS-Server",
    'server-components.componentName.firewall' => "Firewall",
    'server-components.componentName.ftpserver' => "FTP-Server",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "Mailserver",
    'server-components.componentName.local_mailserver' => "Lokaler Mailserver",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Web-Scripting",
    'server-components.componentName.spamfilter' => "Spamfilter",
    'server-components.componentName.stats' => "Webstatistiken",
    'server-components.componentName.stunnel' => "SSL/TLS-Wrapper",
    'server-components.componentName.webmail' => "WebMail",
    'server-components.componentName.webpublish' => "Web-Publishing",
    'server-components.componentName.webserver' => "Webserver",
    'server-components.componentName.network' => 'IP-Verwaltung',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Plesk-Hosting",
    'server-components.componentName.savi' => 'Benutzeroberfläche der Antivirensoftware Sophos',

    'server-components.tooltip.disabled' => 'Ausgeschaltet',
    'server-components.tooltip.active' => 'Aktiv',
    'server-components.tooltip.notConfigured' => 'Nicht konfiguriert',
    'server-components.tooltip.notStarted' => 'Nicht gestartet, Komponenteneinstellungen überprüfen',

    'server-components.defaultComponents.circularDependencies' => "Es wurden zirkuläre Abhängigkeiten zwischen den Kategorien %%cat1%% und %%cat2%% festgestellt",
    'server-components.defaultComponents.not_installed' => "(nicht installiert)",
    'server-components.defaultComponents.not_configured' => "(nicht konfiguriert)",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Manche Service-Kategorien enthalten ungültige Abschnitte oder es wurde keine Auswahl getroffen.",
    'server-components.defaultComponents.depends_on' => "(erfordert %%name%%)",
    'server-components.defaultComponents.not_activated' => 'nicht aktiviert',
    'server-components.defaultComponents.imap_required' => '(Aktueller Mailserver unterstützt IMAP nicht)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(Der FTP-Server unterstützt keine IPv6-Adressen.)",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(die erforderliche Delegationsregel \'appPoolPipeline, appPoolNetFx\' existiert nicht)',
    'server-components.defaultComponents.not_supported_version' => '(nicht unterstützte Version)',
    'server-components.defaultComponents.no_license' => '(aufgrund des Lizenzschlüssels nicht zulässig)',
    'server-components.defaultComponents.license_expired' => '(Lizenzschlüssel ist abgelaufen)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(Postfach-Limit des Lizenzschlüssels überschritten)',
    'server-components.defaultComponents.title' => 'Standard-%%name%%-Komponente auswählen',
    'server-components.defaultComponents.none' => 'Ohne',
    'server-components.defaultComponents.yes' => 'Ja',
    'server-components.defaultComponents.no' => 'Nein',
    'server-components.defaultComponents.warning' => 'Warnung!',
    'server-components.defaultComponents.parametersOfComponent' => 'Parameter von %%component%%',
    'server-components.defaultComponents.success' => 'Die Standardkomponente wurde aktualisiert',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "Die Änderung des Mailservers ist nur für die Erstkonfiguration vorgesehen. Wenn der Server bereits verwendet wird, verursacht dies die folgenden Probleme: Verlust der Einstellungen und des Postfachinhalts sowie verschiedene Konflikte in Fällen, in denen der Server, auf den Sie wechseln, bereits konfiguriert ist.\nWenn dieser Server gerade verwendet wird und Sie zu einem anderen Server wechseln möchten, können Sie Ihre Kunden über den Vorgang informieren, so dass sie ihre E-Mails herunterladen und speichern können.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Es werden nur die ersten 254 IP-Adressen von Subnetzen mit /8- und /16-Masken, die sich in der Zugriffskontrollliste befinden, übertragen. Sie werden als separate IP-Adressen übertragen. Möchten Sie fortfahren?",

    'server-components.componentConf.title' => 'Parameter von %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'Parameter erforderlich',
    'server-components.componentConf.parameterShouldBeNumber' => 'Der Parameter muss eine Zahl sein',
    'server-components.componentConf.success' => 'Parameter wurden aktualisiert',

    'spam-filter.groupAdd' => 'Hinzufügen',
    'spam-filter.buttonAdd' => 'Domain hinzufügen',
    'spam-filter.buttonAddAddress' => 'Adresse hinzufügen',
    'spam-filter.buttonAddToBlackListHint' => 'Domains zur Sperrliste hinzufügen',
    'spam-filter.buttonAddToWhiteListHint' => 'Fügen Sie eine Domain zur Whitelist hinzu',
    'spam-filter.buttonAddAddressToBlackListHint' => 'Adresse zur Sperrliste hinzufügen',
    'spam-filter.buttonAddAddressToWhiteListHint' => 'Adresse zur Zulassungsliste hinzufügen',
    'spam-filter.groupActions' => 'Aktionen',
    'spam-filter.buttonRemove' => 'Entfernen',
    'spam-filter.entries' => 'Einträge',
    'spam-filter.removeEmptySelection' => 'Keine Einträge ausgewählt.',
    'spam-filter.removeConfirmation' => 'Entfernen Sie {count, plural, =1 {der {name} Eintrag} one {der # ausgewählte Eintrag} other {die # ausgewählten Einträge}}?',
    'spam-filter.removeSuccess' => 'Die ausgewählten Einträge wurden entfernt.',
    'spam-filter.addAddressToBlackListEmptyTitle' => 'Liste der bekannten Spamadressen',
    'spam-filter.addAddressToWhiteListEmptyTitle' => 'Liste der vertrauenswürdigen Adressen',
    'spam-filter.addAddressToBlackListEmptyDescription' => 'E-Mails von den E-Mail-Adressen auf dieser Liste werden als Spam eingestuft.',
    'spam-filter.addAddressToWhiteListEmptyDescription' => 'E-Mails von den E-Mail-Adressen auf dieser Liste umgehen den Spamfilter.',

    'tasks.pollingOff' => 'Aus',
    'tasks.pollingDelay' => '%%delay%% Sek.',
    'tasks.stopTaskConfirm' => 'Möchten Sie die Aufgabe wirklich abbrechen?',
    'tasks.stopTaskError' => 'Aufgabe konnte nicht gestoppt werden',
    'tasks.stopTask' => 'Aufgabe stoppen',
    'tasks.buttonStopConfirm' => 'Ja, anhalten',
    'tasks.processedLoadFailed' => 'Prozessliste konnte nicht geladen werden',
    'tasks.retryTask' => 'Aufgabe erneut versuchen',
    'tasks.retryTaskFailed' => 'Aufgabe konte nicht erneut versucht werden',
    'tasks.taskCreated' => 'Neue Aufgabe erstellt',
    'tasks.moreDetails' => 'Siehe Panelprotokoll für Einzelheiten',
    'tasks.searchTitle' => 'Suchen',
    'tasks.searchPlaceholder' => 'Suchbegriff',
    'tasks.refresh' => 'Aktualisieren',
    'tasks.refreshDescription' => 'Aufgabenliste aktualisieren',
    'tasks.createTask' => 'Aufgabe erstellen',
    'tasks.openSwagger' => 'Swagger öffnen',
    'tasks.statusTitle' => 'Status',
    'tasks.createdTitle' => 'Erstellt',
    'tasks.descriptionTitle' => 'Beschreibung',
    'tasks.processes.dataLoadFailed' => 'Daten konnten vom Server nich abgerufen werden',
    'tasks.processes.commandLineLoadFailed' => 'Aufgaben-Befehlszeile konnte nicht abgerufen werden',
    'tasks.processes.buttonStopConfirm' => 'Ja, anhalten',
    'tasks.processes.stopProcess' => 'Prozess anhalten',
    'tasks.processes.stopProcessFailed' => 'Prozess konnte nicht gestoppt werden',
    'tasks.processes.stopProcessConfirm' => 'Möchten Sie den Prozess wirklich stoppen?',
    'tasks.processes.copyToClipboard' => 'In die Zwischenablage kopieren',
    'tasks.processes.concurrency' => 'Gleichzeitigkeit',
    'tasks.processes.taskIdSection' => 'Aufgaben-ID',
    'tasks.processes.requestorIdSection' => 'ID des Antragstellers',
    'tasks.processes.timeoutSection' => 'Zeitüberschreitung',
    'tasks.processes.createdSection' => 'Erstellt',
    'tasks.processes.updatedSection' => 'Aktualisiert',
    'tasks.processes.environmentSection' => 'Umgebung',
    'tasks.processes.idTitle' => 'ID',
    'tasks.processes.statusTitle' => 'Status',
    'tasks.processes.startedTitle' => 'Gestartet',
    'tasks.processes.completedTitle' => 'Geschlossen',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Exitcode',

    'ts-sessions.columnStateTitle' => 'Staat',
    'ts-sessions.columnUserTitle' => 'Benutzer',
    'ts-sessions.columnNameTitle' => 'Name',
    'ts-sessions.refresh' => 'Aktualisieren',
    'ts-sessions.logoff' => 'Abmelden',
    'ts-sessions.logoffConfirmation' => 'Aus %%count%% Sitzung(en) abmelden?',
    'ts-sessions.logoffConfirmationSingle' => 'Aus der Sitzung %%name%% abmelden?',
    'ts-sessions.logoffConfirmationButton' => 'Ja, abmelden',
    'ts-sessions.logoffNoSelection' => 'Wählen Sie mindestens eine Sitzung aus, aus der Sie abgemeldet werden möchten',
    'ts-sessions.logoffSuccess' => 'Abmeldung aus den ausgewählten Sitzungen abgeschlossen.',
    'ts-sessions.disconnect' => 'Trennen',
    'ts-sessions.disconnectConfirmation' => 'Verbindung zu %%count%% Sitzung(en) trennen?',
    'ts-sessions.disconnectConfirmationSingle' => 'Verbindung zur Sitzung %%name%% trennen?',
    'ts-sessions.disconnectConfirmationButton' => 'Ja, Verbindung trennen',
    'ts-sessions.disconnectSuccess' => 'Die Verbindung zu den ausgewählten Sitzungen wurde getrennt.',
    'ts-sessions.disconnectNoSelection' => 'Wählen Sie mindestens eine Sitzung aus, deren Verbindung getrennt werden soll',
    'ts-sessions.disconnectNotAvailable' => 'Sie können die Verbindung nur von aktiven oder verbundenen Sitzungen trennen.',

    'client-ip-address.title' => 'IP-Adressen',
    'client-ip-address.status' => 'Status',
    'client-ip-address.type' => 'Typ',
    'client-ip-address.ipAddress' => 'IP-Adresse',
    'client-ip-address.certificate' => 'Zertifikat',
    'client-ip-address.hosting' => 'Hosting',
    'client-ip-address.adminCertificateRepository' => "Administrator-Repository",
    'client-ip-address.domainCertificateRepository' => 'Repository von Domain %%owner%%',
    'client-ip-address.typeShared' => 'Gemeinsam genutzt',
    'client-ip-address.typeExclusive' => 'Dediziert',
    'client-ip-address.removeConfirmation' => 'Möchten Sie {count, plural, =1 {die IP-Adresse {name}} one {die # ausgewählte IP-Adresse} other {die # ausgewählten IP-Adressen}} aus dem IP-Pool des Benutzers entfernen?',
    'client-ip-address.noItemsToRemove' => 'Wählen Sie mindestens ein Element aus, das entfernt werden soll.',
    'client-ip-address.ftpOverSSL' => 'FTP über SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Ja',
    'client-ip-address.ftpOverSSL-no' => 'Nein',
    'client-ip-address.ftpOverSSL-allow' => 'Zulassen',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Nicht zulässig',
    'client-ip-address.add' => 'IP-Adresse hinzufügen',
    'client-ip-address.noAvailableIps' => 'Es sind keine IP-Adressen verfügbar.',
    'client-ip-address.isOk' => 'IP-Adresse funktioniert ordnungsgemäß.',
    'client-ip-address.isBroken' => 'IP-Adresse ist auf der Oberfläche nicht aktiv.',
    'client-ip-address.properties.title' => 'IP-Adresse %%address%% auf der Schnittstelle %%interface%%',
    'client-ip-address.properties.distributedType' => 'IP-Adresse verfügbar als',
    'client-ip-address.properties.allocatedType' => 'IP-Adresse zugewiesen als',
    'client-ip-address.properties.none' => 'Keine',
    'client-ip-address.properties.certificate' => 'SSL/TLS-Zertifikat',
    'client-ip-address.properties.defaultSite' => 'Standardwebsite',
    'client-ip-address.assign.title' => 'Wählen Sie die IP-Adressen aus',
    'client-ip-address.assign.description' => 'Freie IP-Adressen',
    'client-ip-address.assign.success' => '{count, plural, =1 {Die IP-Adresse {name} wurde} one {Die # ausgewählte IP-Adresse wurde} other {Die # ausgewählten IP-Adressen wurden}} zum IP-Pool des Benutzers hinzugefügt.',

    'ip-address-reseller-usage.title' => 'Reseller, die die IP-Adresse %%ipAddress%% (%%type%%) verwenden',
    'ip-address-reseller-usage.nameColumnHeader' => 'Reseller',
    'ip-address-reseller-usage.assignButton' => 'Dem Reseller zuweisen',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'Diese IP-Adresse ist bereits allen Benutzern zugewiesen.',
    'ip-address-reseller-usage.removeButton' => 'Entfernen',
    'ip-address-reseller-usage.removeSuccess' => 'Die IP-Adresse wurde aus {count, plural, =1 {dem Pool "{name}"} one {dem # ausgewählten Reseller-Pool} other {den # ausgewählten Reseller-IP-Pools}} entfernt.',
    'ip-address-reseller-usage.removeConfirmation' => 'IP-Adresse aus {count, plural, =1 {dem IP-Pool "{name}"} one {dem # ausgewählten Reseller-IP-Pool} other {den # ausgewählten Reseller-IP-Pools}} entfernen?',
    'ip-address-reseller-usage.typeSHARED' => 'Gemeinsam genutzt',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Dediziert',
    'ip-address-reseller-usage.assign.title' => "%%ipAddress%% zum Reseller-IP-Pool hinzufügen",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Reseller, die hinzugefügt werden sollen',
    'ip-address-reseller-usage.assign.success' => 'Die IP-Adresse wurde {count, plural, =1 {dem Pool "{name}"} one {dem # ausgewählten Reseller-IP-Pool} other {den # ausgewählten Reseller-IP-Pools}} hinzugefügt.',

    'ProtectedDirectoryUser.emptyViewTitle' => 'Fügen Sie ein Benutzerkonto hinzu, um Zugriff auf das geschützte Verzeichnis zu ermöglichen',
    'ProtectedDirectoryUser.addTooltip' => 'Erstellen Sie Benutzerkonten, die auf das geschützte Verzeichnis %%directory%% zugreifen können',
    'ProtectedDirectoryUser.add' => 'Benutzer hinzufügen',
    'ProtectedDirectoryUser.login' => 'Name',
    'ProtectedDirectoryUser.changePassword' => 'Passwort ändern',
    'ProtectedDirectoryUser.noSelectionText' => 'Wählen Sie mindestens einen Benutzer aus, der entfernt werden soll.',
    'ProtectedDirectoryUser.remove' => 'Entfernen',
    'ProtectedDirectoryUser.removeTooltip' => 'Ausgewählte Benutzer entfernen.',
    'ProtectedDirectoryUser.removeConfirmation' => '{count, plural, one {}=1 {Den Benutzer {login}} other {# ausgewählte Benutzer}} entfernen?',
    'ProtectedDirectoryUser.removeSuccess' => 'Die ausgewählten Benutzer wurden entfernt.',

    'TrafficUsageByClients.customerName' => 'Kundenname',
    'TrafficUsageByClients.resellerName' => 'Reseller-Name',
    'TrafficUsageByClients.totalUsage' => 'Verwendet',
    'TrafficUsageByClients.limit' => 'Grenzwert',
    'TrafficUsageByClients.limitRemaining' => 'Verfügbar',
    'TrafficUsageByClients.limitUsagePercent' => 'Verbrauch (in %)',
];