<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    //===============Button conhelp================//

    'b_disabled' => 'Denne tjenesten er ikke tilgjengelig for øyeblikket.',
    'b_disabled_by_key' => 'Denne funksjonen støttes ikke av lisensnøkkelen.',
    'b_disabled_by_permissions' => 'Du ikke har tillatelse til å utføre sikkerhetskopioperasjon.',
    'b_accept' => "Du bør godta vilkår for denne lisensavtalen for å kunne bruke {$PROD_NAME}.",
    'b_action_log' => 'Handlingslogg konfigurering.',
    'b_add_ip' => "Legg til IP adresser til klientens IP gruppe.",
    'b_database_server_add' => 'Legg til en databaseserver.',
    'b_adm_skeleton' => 'Administrer mal for virtuell vert.',

    'b_auto-updates' => "Oppdater Plesk eller dets komponenter.",

    'b_codepage_change' => 'Klikk her for å endre kodingen.',
    'b_configure_maillists' => 'Konfigurering av adresselister etter installasjon',
    'b_comp_info' => 'Informasjon om komponenter.',
    'b_decline' => "Hvis du avslå denne lisensen, vil du ikke kunne bruke {$PROD_NAME}.",
    'b_dumps_list' => 'Få tilgang til sikkerhetskopierings- og gjenopprettingsfunksjoner og administrer lagring av sikkerhetskopifiler.',
    'b_dumps_list_disabled' => 'Tjenesten er ikke tilgjengelig fordi sikkerhetskopieringsprogrammene ikke ble installert.',
    'b_add_services' => 'Side for administrasjon av ytterligere tjenester.',
    'b_add_ip_for_clients' => "Legg til eier for denne IP adressen.",
    'b_anonymous_ftp' => 'Sett opp Anonym FTP for domenet.',
    'b_attach_add' => 'Legg til vedlagt fil.',
    'b_attach_remove' => 'Fjern vedlagt fil.',
    'b_backup_ok' => 'Sikkerhetskopiering ble fullført. Klikk for å gå til lager for sikkerhetskopier.',
    'b_restore_ok' => 'Gjenoppretting ble fullført. Klikk for å gå til lager for sikkerhetskopier.',
    'b_cancel' => 'Forkaste hvilken som helst endring og gå tilbake til forrige side.',
    'b_card' => 'Rediger personlig informasjon.',
    'b_clean_log' => 'Tøm logg.',
    'b_cl_skeleton' => 'Administrer mal for virtuell vert.',
    'b_dashboard' => 'Gå til startside.',
    'b_dashboard_shortcut_remove' => 'Fjern snarveien fra hjemmesiden.',
    'b_domain_restore' => 'Gjenopprett domenet fra denne sikkerhetskopien.',
    'b_domain_user' => 'Tillat og konfigurer tilgang for domeneadministrator.',
    'b_do_backup' => 'Sikkerhetskopier domenet. Ved hjelp av denne prosedyren, vil administrasjonsfunksjoner for domenet ikke være tilgjengelig på Kundepanelet.',
    'b_do_upload' => 'Last opp dump til lager.',
    'b_backup_configure' => 'Sikkerhetskopi administrator konfigurasjon.',
    'b_domain_alias_add' => 'Sett opp et ytterligere domenenavn for nettstedet ditt.',
    'b_domain_aliases_limit_reached' => 'Grensen for antall domenealias ble nådd.',
    'b_create_client_back' => 'Forkaste foreslåtte parametere og gå tilbake til forrige side.',
    'b_create_client_update' => 'Bruk de foreslåtte parameterene og fortsett med oppretting av kunde.',
    'b_create_domain_back' => 'Forkaste foreslåtte parametere og gå tilbake til forrige side.',
    'b_create_domain_update' => 'Bruk foreslåtte parametere og fortsett med opprettelse av domenet.',
    'b_create_domain_client_select' => 'Velg kunden og klikk OK for å opprette domenet.',
    'b_crontab_unix' => 'Administrer planlagte oppgaver.',
    'b_crontab_win' => 'Administrer planlagte oppgaver.',
    'b_crontab_unix_turn_on' => 'Klikk for å bytte til den planlagte oppgaven.',
    'b_crontab_win_turn_on' => 'Klikk for å bytte til den planlagte oppgaven.',
    'b_crontab_unix_turn_off' => 'Klikk for å avbryte den planlagte oppgaven.',
    'b_crontab_win_turn_off' => 'Klikk for å avbryte den planlagte oppgaven.',
    'b_extcert_send_file' => 'Last opp tidligere innkjøpt sertifikat fra angitt fil.',
    'b_extras_admin' => 'Tilleggsverktøy for server.',
    'b_extras_client' => 'Ytterligere domeneverktøy.',
    'b_cl_ed' => "Klikk for å redigere kundens informasjon.",
    'b_cl_ed_update' => "Klikk for å oppdatere kundens informasjon.",
    'b_cl_limits' => 'Vis eller definer kundens kontogrenser.',
    'b_cl_new_update' => 'Klikk for å opprette kundekonto.',
    'b_cl_not_cr_dom' => 'Kunden har ikke tillatelse til å opprette domener.',
    'b_cl_on' => "Aktiver kundekonto og alle kundens nettsteder.",
    'b_cl_off' => "Suspender kundekonto og alle kundens nettsteder.",
    'b_cl_permissions' => 'Vis eller sett tillatelser for ressursene som er tildelt kunden.',
    'b_cl_pref_up_level' => "Klikk for å gå tilbake til kundens innstillingsside uten oppdatering.",
    'b_default_db_user' => "Bruk valgte databasebrukers påloggingsinformasjon for å logge inn til database administrasjon grensesnitt.",
    'b_edit_tpl__add_ip' => 'Klikk for å legge til IP adresser.',
    'b_edit_tpl__cancel_ip' => 'Klikk for å avbryte.',
    'b_icf' => 'Sett opp brannvegg.',
    'b_ip_clients__add' => 'Klikk for å legge til.',
    'b_ip_clients__cancel' => 'Klikk for å avbryte.',
    'b_client_templates' => 'Administrasjon av kundemaler.',
    'b_create_login' => 'Klikk for å opprette en MyPlesk.com konto.',
    'b_skins_managment' => 'Klikk for å administrere skins.',
    'b_skin_add' => 'Last opp nytt skin til Plesk.',
    'b_skin_manual' => "Åpne en brukerhåndbok om opprettelse av brukerdefinerte skall for Plesk.",
    'b_skin_manual_not_installed' => "Brukerhåndbok om opprettelse av brukerdefinerte skall for Plesk er ikke installert.",
    'b_skin_download' => 'Klikk for å laste ned skin\'et.',
    'b_skin_replace' => 'Klikk for å bytte ut det nåværende skin med et nytt.',
    'b_spamassassin' => 'SpamAssassin serverkonfigurasjon',

    'b_subdom_update' => 'Klikk for å sende inn innstillinger.',
    'b_subdom_create' => 'Klikk for å opprette underdomene.',
    'b_switch_user' => 'Logg inn under en annen konto.',
    'b_clients' => 'Behandle klientkontoer.',
    'b_client_traffic' => "Klientens trafikk.",
    'b_change_passwd' => "Klikk for å endre administratorpassord.",
    'b_change_cert_name' => 'Endre sertifikatnavnet.',
    'b_databases' => 'Opprett og behandle databaser og databasebrukere.',
    'b_databases__change_server_passwd' => 'Klikk for å gå til siden for å endre passord.',
    'b_directories' => 'Opprett en SSL/TLS eller ikke-SSL/TLS passordbeskyttede mapper.',
    'b_db_access' => "Sett opp databaseadministratorens påloggingsinformasjon.",
    'b_pgsql_access' => "Sett opp PostgreSQL administratorpåloggingsinformasjon.",
    'b_pgsql_not_access' => 'PostgreSQL er ikke installert.',
    'b_db_add' => 'Legg til en database.',
    'b_db_add__lim' => 'Du kan ikke legge databaser til dette domenet: grensen for antall databaser er nådd.',
    'b_db_add_update' => 'Skriv inn nytt databasenavn og klikk for å legge til.',
    'b_db_del' => 'Fjern database.',
    'b_db_admin_not_installed' => 'Webadmin er ikke installert. Ta kontakt med tjenesteleverandør for hosting for assistanse.',
    'b_db_no_default_user' => 'Kan ikke få tilgang til Webadmin: standard Webadmin-bruker er ikke oppgitt.',
    'b_db_dbserver_not_configured' => 'Kan ikke tilgang Webadmin: databaseservere er ikke konfigurert.',
    'b_db_usr_add' => 'Legg til en databasebruker.',
    'b_db_user_del' => 'Fjern databasebruker.',
    'b_db_usr_update' => 'Endre passord.',
    'b_db_rm_submit' => 'Slett de valgte databaser.',
    'b_db_not_started' => 'Databaseserveren er ikke startet',
    'b_db_not_configured' => 'Databaseserveren er ikke konfigurert',
    'b_db_not_installed' => 'Databaseserveren er ikke installert',
    'b_default_text' => 'Sett opp standard beskjedtekst.',
    'b_du_rm_submit' => 'Slett databasebrukere.',
    'b_dns' => 'Administrer DNS-innstillinger for domenet.',
    'b_dns_soa_set' => 'Bruk alle endringene.',
    'b_dns_acl_add' => 'Klikk her for å legge til IP adresse eller nettverksmaske.',
    'b_dns_rec_del' => 'Fjern denne oppføringen fra DNS-sonen.', //to remove
    'b_dns_rec_new' => 'Velg ny oppføringstype og klikk for å legge til.', //to remove
    'b_dnsrecord_add' => 'Klikk for å legge ressursoppføring til DNS-sonen',
    'b_dns_soa' => 'Klikk for å konfigurere SOA innstillinger',
    'b_dns_soa_default' => 'Klikk for å gjenopprette standard SOA-innstillinger.',
    'b_dns_default' => 'Klikk for å gjenopprette DNS-sonen.',

    'b_dns_master_add' => 'Legg til primær DNS-server.', //to remove
    'b_dns_new_ns' => 'Legg til navnetjener.', //to remove
    'b_dns_on' => 'Slå på lokal DNS-tjeneste for sonen.',
    'b_dns_off' => 'Slå av lokal DNS-tjeneste for sonen.',
    'b_dns_not_perm' => 'Du har ikke tillatelse til å behandle DNS-sonen for dette domenet.',

    'b_dom_deact' => 'Ikke tilgjengelig for suspenderte domener.',
    'b_dom_del' => 'Slett all domeneinformasjon.',
    'b_log_manager' => 'Administrer loggfiler og loggbehandling muligheter.',
    'b_dom_new' => 'Klikk for å opprette en domene.',
    'b_dom_new_no_clients' => 'Kunne ikke opprette en domene. Du har ingen klientkontoer.',
    'b_dom_new_update' => 'Klikk for å opprette en domene.',
    'b_dom_on' => 'Slå domenet på.',
    'b_dom_off' => 'Slå domenet av.',
    'b_dom_pref' => 'Sett opp innstillinger for domenet.',
    'b_dom_limits' => 'Vis eller sett opp grenser for domenet.',
    'b_domain_traffic' => 'Domenetrafikk.',
    'b_dom_reg' => 'Registrer dette domenet.',
    'b_dom_usr_del' => 'Slett brukertilgang på domenenivå.',
    'b_doms_mng' => 'Administrer domenene som er registrert ved hjelp av Plesk.',
    'b_doms_reg' => 'Registrer et domene.',
    'b_report' => 'Vis rapport.',
    'b_report_saem' => 'Send statusrapporten til den spesifiserte adressen.',
    'b_domains' => 'Administrer domener.',
    'b_domain_templates' => 'Opprett, rediger og slett domenemaler.',
    'b_download_log' => 'Last ned loggfilen til den lokale maskinen.',
    'b_dumps_rm_submit' => 'Klikk for å slette sikkerhetskopi filene.',
    'b_edit_adm' => 'Klikk for å redigere administrator informasjon.',
    'b_custom_buttons' => 'Administrasjon av brukerdefinerte knapper.',
    'b_custom_button_add' => 'Klikk for å legge til en brukerdefinert knapp.',
    'b_custom_buttons_rm_submit' => 'Klikk for å fjerne de valgte brukerdefinerte knappene.',
    'b_hide_aliases' => 'Skjul aliaser.',
    'b_hide_domainaliases' => 'Skjul domenealias.',
    'b_hide_subdomains' => 'Skjul underdomener.',
    'b_home' => 'Tilbake til hjemmesiden.',
    'b_hosting' => 'Administrer og sett opp webhosting for domenet.',
    'b_hst_del' => 'Slett aktiv konfigurasjon for hosting.',
    'b_hst_not_set' => 'Hosting er ikke satt opp.',
    'b_hst_wo_ip' => 'Hosting er ikke IP-basert.',
    'b_hst_wo_ip_or_not_ssl' => 'Hosting er ikke IP-basert eller SSL/TLS-støtte er ikke aktivert.',
    'b_not_phys_hst' => 'Hosting er ikke fysisk.',
    'b_web_stat_not_set' => "Webstatistikk er ikke beholdt. Hvis du ønsker å beholde statistikken, gå til egenskaper for hostingkonto (Domener > domenenavn > Oppsett > Meny for webstatistikk) og velg det statistikkprogrammet du trenger.",
    'b_white_list' => 'Behandle hviteliste',
    'b_white_list_add' => 'Legg et domene til hvitelisten.',
    'b_hst_sel_next' => 'Sett opp valgt hostingtype.',
    'b_hst_update' => 'Bruk alle endringene.',
    'b_int_ip_del' => 'Velg IP-adresser fra listen og klikk for å fjerne dem fra grensesnittet.',
    'b_ip_new' => 'Klikk her for å legge til IP adresse.',
    'b_ip_new_virtuozzo' => 'Kan ikke addere en IP adresse i Virtuozzo-beholdere.',
    'b_ip_new_lycos' => 'Kunne ikke legge til en IP-adresse i Lycos.',
    'b_ip_aliasing' => 'Behandle IP-adresser på serveren.',
    'b_ip_del' => 'Velg IP-adresser fra listen og klikk for å fjerne.',
    'b_ip_rm_submit' => 'Klikk for å slette IP adresser.',
    'b_ip_cl_rm_submit' => 'Klikk for å fjerne IP adressene fra IP gruppen.',
    'b_ip_pool' => "Administrasjon av kundens IP-utvalg.",
    'b_language' => 'Sett opp grensesnitt språk.',
    'b_login' => 'Logg inn i Plesk.',
    'b_logo' => 'Administrer logo fremvist i øvre det grensesnittsområdet.',
    'b_logo_default' => 'Klikk for å gjenopprettte standard logoen.',
    'b_logo_send_file' => 'Skriv inn filnavnet for den nye logoen og klikk for å laste opp.',
    'b_logo_send_link' => 'Skriv inn koblingen for den nye logoen og klikk for å vedlegge.',
    'b_logo_send_logo' => 'Skriv inn filnavnet for den nye logoen og klikk for å laste opp.',
    'b_log_rm_submit' => 'Klikk her for å slette loggfiler.',
    'b_ma_rm_submit' => 'Klikk for å slett e-postaliaser.',

    'b_mail' => 'Konfigurere globale e-postsysteminnstillinger.',
    'b_mail_disabled_by_admin' => 'Eposttjeneste for dette domenet er avslått av serveradministrator.',

    'b_mail_resp_on' => 'Aktiver autosvar.',
    'b_mail_resp_off' => 'Deaktiver autosvar.',
    'b_mail_resp_add' => 'Opprett et autosvar.',
    'b_mail_resp_files' => 'Administrer lagret av vedlegg.',
    'b_mail_resp_files_no_mailbox' => 'Denne funksjonen er ikke tilgjengelig nå fordi du ikke satte opp postboks for denne e-postkontoen.',
    'b_mail_resp_upload' => 'Last opp filen til lagret for vedleggene.',
    'b_mail_resp_attach_add' => 'Opprett et vedlegg.',

    'b_mail_names' => 'Administrer eposttjenester: POP3-postbokser, viderekoblere, grupper og automatisk besvaring.',
    'b_mail_name_resp_attach_selected' => 'Klikk for å legge ved valgte filer til autosvaret.',

    'b_mail_on' => 'Aktiver eposttjenester for dette domenet.',
    'b_mail_off' => 'Deaktiver eposttjenester for dette domenet.',
    'b_mail_preferences' => 'Konfigurer innstillinger for e-postmottak for ikke-eksisterende brukere.',

    'b_mn_alias_new' => 'Legg til e-postalias.',
    'b_mn_mail_group' => 'Behandle e-postgruppe.',
    'b_mn_mailbox' => 'Administrer postboks.',
    'b_mn_preferences' => 'Konfigurer e-postkonto.',
    'b_mn_responders' => 'Administrer autosvar.',
    'b_mn_resp_rm_submit' => 'Slett autosvar.',
    'b_mn_redir_rm_submit' => 'Slett videresendere for e-post.',
    'b_mn_redirect' => 'Behandle videresendere for e-post.',
    'b_mn_files_rm_submit' => 'Klikk for å slette filer.',
    'b_mn_attach_rm_submit' => 'Klikk for å slette vedlegg.',
    'b_mn_groups' => 'Klikk for å behandle e-postgruppe.',
    'b_mn_spamfilter_on' => 'Klikk for å behandle spamfiltrering.',
    'b_mn_spamfilter_off' => 'Spamfiltrering er ikke tilgjengelig nå. For å aktivere spam-filtrering må du ha Spam Filter-programmet installert, og støtte for spamfiltrering på brukernivå må være aktivert på Postboks > Spam Filter- siden.',
    'b_mn_spamfilter_srv' => 'Administrator har deaktivert brukeres mulighet til konfigurere spamfiltrering.',

    'b_make_dump' => 'Sikkerhetskopier domenet.',
    'b_ftp_account_for_dumps_repository' => 'For å kunne bruke en ekstern FTP-server til å lagre siikkerhetskopier av domenet, må du spesifisere egenskaper for den FTP-kontoen som brukes til å gå inn på serveren.',
    'b_cron_task_backup' => 'Administrer planlagt sikkerhetskopiering.',

    'b_mg_mem_del' => 'Velg e-postgruppe medlem-mer fra liste og klikk for å fjerne.',
    'b_mg_add' => 'Legg til e-postkonto til valgte e-postgruppe.',
    'b_mg_cancel' => 'Klikk for å avbryte.',
    'b_mg_del' => 'Fjern e-postkonto fra valgte e-postgruppe.',
    'b_mg_mem_new' => 'Klikk for å legge til e-postgruppe medlem.',
    'b_mg_turn_on' => 'Klikk for å slå på e-postgruppe.',
    'b_mg_turn_off' => 'Klikk for å slå av e-postgruppe.',
    'b_mg_update' => 'Klikk her for å oversende endringene.',
    'b_mn_rm_submit' => 'Klikk for å slette e-postkonto.',
    'b_mn_webmail_on' => 'Klikk for å åpne webmail.',
    'b_mn_webmail_off' => 'Denne funksjonen er ikke tilgjengelig nå fordi webmailstøtte ikke er slått på i e-postinnstillinger, eller postboksen ikke er aktivert.',

    'b_modules_manage' => 'Behandle moduler installert i Plesk og få tilgang til funksjoner som leveres av disse modulene.',
    'b_notifications' => 'Rediger kunngjøringer.',
    'b_permissions' => 'Vis eller sett tillatelser for kunden.',
    'b_performance' => 'Administrer domeneytelse.',
    'b_first_page' => 'Du er allerede på den første siden.',
    'b_anonftp_stats' => 'Anonym FTP transaksjonsstatistikk.',
    'b_ftp_stats' => 'FTP-server transaksjonsstatistikk.',
    'b_ftp_stats_disable' => 'Webstatistikk oppbevares ikke, eller anonym FTP-tjeneste er ikke slått på eller hosting er ikke fysisk.',
    'b_last_page' => 'Du er allerede på den siste siden..',
    'b_next_page' => 'Gå til neste side.',
    'b_prs_rm_submit' => 'Klikk for å slette prioriteter.',
    'b_preferences' => "Sett opp grensesnitt preferanser.",
    'b_prev_page' => 'Gå til forrige side.',
    'b_preview' => 'Forhåndsvis område før DNS overføring.',
    'b_qus_rm_submit' => 'Klikk for å slette prioriteter.',
    'b_repair_ip' => 'Klikk her for å legge til IP adressen.',
    'b_repair_ip_status_ok' => 'Denne IP adressen behøver ikke repareres.',
    'b_reboot' => 'Start serveren på nytt',
    'b_refresh' => 'Oppdater data på skjermen',
    'b_key_buyonline_addons' => 'Bestill Plesk-tillegg.',
    'b_key_buyonline_upgrades' => 'Bestill Plesk-oppgraderinger.',
    'b_key_buyonline_new' => 'Bestill en ny lisensnøkkel.',
    'b_quick_search' => 'Vis liste av element som matcher søkekriterier.',
    'b_remove_ip' => "Velg IP-adresser fra listen og klikk for å fjerne fra kundens IP-utvalg.",
    'b_restart_services' => "Administrer {$PROD_NAME}-tjenester.",
    'b_send_passwd' => 'Klikk for å få passord i e-post.',
    'b_server' => 'Sett opp serverinnstillinger.',
    'b_database_servers' => 'Administrer databaseservere',
    'b_server_pref' => 'System- og grensesnittinnstillinger.',
    'b_sessions' => 'Administrer økter.',
    'b_sess_rm_submit' => 'Klikk for å slette økter.',
    'b_set_time' => 'Angi systemdato og tid.',
    'b_set_time_virtuozzo' => 'Kan ikke endre systemdato/tid i Virtuozzo-beholdere.',
    'b_site_apps' => 'Behandling av webprogrammer.',
    'b_site_apppkgs' => 'Administrasjon av webprogrampakker.',
    'b_site_apppkgs_pool' => 'Administrasjon av webprogrampakker.',
    'b_site_apps_rm_submit' => 'Klikk for å slette valgte webprogrammer.',
    'b_additional_key_is_active' => 'Lisensnøkkel er allerede aktiv.',
    'b_additional_key_activate' => 'Klikk for å aktivere lisensnøkkel.',
    'b_site_builder' => 'Klikk for å aktivere integrasjon med Presence Builder.',
    'b_dom_site_builder' => 'Klikk for å åpne Presence Builder veiviseren.',
    'site_builder_no_permission' => 'Du ikke har tillatelse til å bruke Mambo CMS.',
    'b_site_builder_no_package' => 'Mambo CMS er ikke installert.',
    'b_site_builder_no_requires' => 'Kunne ikke kjøre Mambo CMS ettersom krav til hosting ikke er oppfylt.',
    'b_site_builder_no_vrt_hst' => 'For å kunne bruke Mambo CMS, bør du sette opp fysisk hosting for dette domenet.',
    'b_site_builder_setup' => 'Kjør Mambo CMS (hvis dette er den første kjøringen vil programmet bli konfigurert)',
    'b_show_aliases' => 'Vis aliaser.',
    'b_show_domainaliases' => 'Vis domenealias.',
    'b_show_subdomains' => 'Vis underdomener.',
    'b_shutdown' => 'Slå av serveren.',
    'b_statistics' => 'Gå gjennom serverstatistikk',
    'b_system_time' => 'Administrer systemdato og tid.',
    'b_support' => 'Send inn et ønske for teknisk støtte.',
    'b_summary_report' => 'Klikk her for å vise oppsummerings rapporten.',
    'b_subdom_hosting' => 'Administrer og sett opp webhosting for underdomenet.',
    'b_subdomains' => 'Opprett og behandle underdomener.',
    'b_traffic_history' => 'Vis trafikk historikk.',
    'b_set_timezone' => 'Klikk for å angi tidssone.',
    'b_set_timezone_virtuozzo' => 'Kan ikke endre tidssonen i Virtuozzo-beholdere.',
    'b_uninst_submit' => "Klikk her for å avinstallere {$PROD_NAME}.",
    'b_uninst_cancel' => 'Klikk her for å avbryte avinstalleringen.',
    'b_upload_from_ftp' => 'Klikk for å vise liste over sikkerhetskopi lagret på FTP-server.',
    'b_ok' => 'Bruk alle endringene.',
    'b_update' => 'Bruk alle endringene.',
    'b_update_db_access' => 'Lagre endringene i påloggingsinformasjon for databasetilgang.',
    'b_updtntp' => 'Slå på tidssynkronisering med NTP-server.',
    'b_updtntp_virtuozzo' => 'Kan ikke sette opp tidssynkronisering med NTP-server i Virtuozzo-beholdere.',
    'b_updtpswd' => "Endre administratorpassord.",
    'b_upload_dump' => 'Last opp sikkerhetskopi til lager for sikkerhetskopier.',
    'b_no_dumps_on_ftp' => 'Eksternt lager er tomt.',
    'b_web_stats' => 'Webserver transaksjonsstatistikk.',
    'b_web_stats_disable' => 'Webstatistikk er ikke aktivert eller hosting er ikke fysisk.',
    'b_web_stats_ssl' => 'Transaksjonsstatistikk for sikker webserver.',
    'b_web_stats_ssl_disable' => 'Webstatistikk er ikke aktivert eller sikker webserver er ikke konfigurert eller hosting er ikke fysisk.',
    'b_web_users' => 'Sett opp webbrukere for domenet.',
    'b_vhost_app_add' => 'Installer webprogram på domene.',
    'b_vhost_app_add_no_domains' => 'Det finnes allerede webprogrammer installert i rotkatalogene på disse virtuelle vertene.',
    'b_interface_management' => 'Skjul eller vis diverse elementer av Plesk.',
    'b_virtualdirs' => 'Behandle virtuelle kataloger',
    'b_virtualdir_add' => 'Legg til virtuell mappe.',
    'b_zone_switch_master' => 'Endre DNS-sonetype til primær.',
    'b_zone_switch_slave' => 'Endre DNS-sonetype til sekundær.',

    'b_logrotation_update' => 'Endre loggrotasjonsinnstillinger.',
    'b_logrotation_on' => 'Skru på logg rotasjonen.',
    'b_logrotation_off' => 'Skru av logg rotasjonen.',

    'b_dom_tmpl_add' => 'Opprett en domenemal.',
    'b_cl_tmpl_add' => 'Opprett en klient mal.',
    'b_tmpl_update' => 'Oppdaterer egenskaper for mal.',
    'b_tmpl_rm_subm' => 'Klikk for å slette malene.',

    'b_defaultcomponents' => 'Valg av tredjeparts tjenester.',
    'b_defaultcomponents__update' => 'Bekreft valgtet og fortsett med tredjeparts tjenester.',
    'b_defaultcomponents__cancel' => 'Forkaste hvilken som helst endring og gå tilbake til forrige side.',

    'b_locale_add' => 'Klikkk for å laste opp ny språkpakke.',
    'b_locales_managment' => 'Klikk for å administrere språk for grensesnitt.',

    'b_subdom_performance' => 'Behandle ytelse for underdomene.',

    'b_anon_on' => 'Slå på anonym FTP-tjeneste for domenet.',
    'b_anon_off' => 'Slå av anonym FTP-tjeneste for domenet.',

    'b_maillists' => 'Klikk for å behandle adresseliste.',
    'b_maillist_new' => 'Klikk for å opprette adresseliste.',
    'b_maillist_edit' => 'Klikk for å tilgang til administrasjonsfunksjonen for adresselister.',
    'b_maillist_turn_on_off' => 'Klikk for å endre adresselistestatus.',
    'b_maillists_on' => 'Aktiver adresselistetjeneste.',
    'b_maillists_off' => 'Deaktiver adresselistetjeneste.',
    'b_maillist_off_disabled' => 'Deaktivering av adresselister er ikke støttet av den gjeldende e-postserver.',
    'b_maillists_invert_on_off' => 'Klikk for å endre tilstand for valgte adresseliste.',

    'b_dom_performance_edit' => 'Administrer ytelsen til domenet.',
    'b_dom_performance_readonly' => 'Vis ytelsesinnstillinger for domenet.',
    'b_dom_performance_disabled' => 'Egenskapen er utilgjengelig så lenge QoS ikke er i bruk på nettverksenheten.',
    'b_subdom_performance_disabled' => 'Egenskapen er utilgjengelig så lenge QoS ikke er i bruk på nettverksenheten.',

    //=============return to up level conhelp =====================

    'b_to_admin' => "Returner til administrering av Kundestøtte.",
    'b_to_aliases' => 'Gå tilbake til administrasjonssiden for e-postaliaser.',
    'b_to_autoinstaller_components' => 'Gå tilbake til komponentvalg-siden.',
    'b_to_autoinstaller_releases' => 'Gå tilbake til versjonsvalg-siden.',
    'b_to_custom_buttons' => 'Gå tilbake til administrasjon av brukerdefinerte knapper.',
    'b_to_cl_traffic' => "Gå tilbake til kundens trafikkside.",
    'b_to_cl_templates' => "Gå tilbake til listen over kundemaler.",
    'b_to_cl_pref' => 'Gå tilbake til kundeinnstillingene.',
    'b_to_comp_info' => "Gå tilbake til komponentbehandling i Plesk.",
    'b_to_dom_rep' => 'Gå tilbake til visning av domeneinformasjonen.',
    'b_to_filemanager' => 'Gå tilbake til filbehandleren.',
    'b_to_subdomains' => 'Gå tilbake til listen over underdomener.',
    'b_to_sessions' => 'Gå tilbake til økter.',
    'b_to_databases_db' => "Gå tilbake til Påloggingsinformasjon og verktøy for databaseadministrator.",
    'b_to_dumps_list' => 'Gå tilbake til lageret for sikkerhetskopier av domenet.',
    'b_to_backup_manager' => 'Gå tilbake til administrasjonssiden for sikkerhetskopier.',
    'b_to_log_files' => 'Gå tilbake til listen over loggfiler.',
    'b_to_domains' => 'Gå tilbake til domenelisten.',
    'to_domain_aliases' => 'Gå tilbake til domenealiassiden',
    'b_to_clients' => 'Gå tilbake til kundelisten.',
    'b_to_client_home' => "Gå tilbake til kundens startside.",
    'b_to_cp_access' => 'Gå tilbake til administrasjonssiden for tilgangsrestriksjoner.',
    'b_to_crontab_unix' => 'Gå tilbake til administrasjonssiden for Crontab.',
    'b_to_crontab_win' => 'Gå tilbake til Tidsplanlegger-siden',
    'b_to_dns' => 'Gå tilbake til administrasjon av DNS-sone.',
    'b_to_dom_ctrl' => 'Gå tilbake til siden for domeneadministrasjon.',
    'b_to_license_management' => 'Tilbake til lisensinformasjon.',
    'b_to_mail' => 'Gå tilbake til konfigurasjon av globale e-postinnstillinger.',
    'b_to_maillists' => 'Gå tilbake til e-post liste administrasjon.',
    'b_to_maillist_members' => 'Gå tilbake til administrering av adresseliste-abonnenter.',
    'b_to_mail_names' => 'Returner til behandling av e-postkontoer.',
    'b_to_mail_name_responders' => 'Gå tilbake til behandling av autosvar.',
    'b_to_mail_name_resp_edit' => 'Gå tilbake til redigering av autosvar-egenskaper.',
    'b_to_mail_name_resp_attach_add' => 'Gå tilbake til å opprette nytt vedlegg.',
    'b_to_mail_name_redirects' => 'Returner til behandling av videresendere for e-post.',
    'b_to_mail_name_files' => 'Gå tilbake til e-postkontoens vedleggsdepot.',
    'b_to_mail_white_list' => 'Gå tilbake til administrering av hvitelisteoppføringer.',
    'b_to_notifications' => 'Gå tilbake til redigering av varslinger.',
    'b_to_server' => 'Gå tilbake til serveradministrasjonssiden.',
    'b_to_spamassassin' => 'Gå tilbake til konfigurasjon av spamfilter.',
    'b_to_skins' => 'Gå tilbake til behandling av skins.',
    'b_to_skin_info' => 'Gå tilbake til å se skin-egenskaper.',
    'b_to_scheduler' => 'Gå tilbake til Tidsplanlegger-siden',
    'b_to_subdom_ctrl' => 'Gå tilbake til liste over administrasjonssiden for underdomener.',
    'b_to_prs' => 'Gå tilbake til prioriteringer.',
    'b_to_responders' => 'Gå tilbake til behandling av autosvar.',
    'b_to_virtualdirs' => 'Gå tilbake til behandling av Virtuell mapper.',
    'b_to_virtualdir_edit' => 'Gå tilbake til forrige Virtuelle Mappe.',
    'b_to_virtualdir_root' => 'Gå tilbake til listen over virtuelle mapper.',
    'b_to_web_users' => 'Gå tilbake til listen over webbruker.',
    'b_to_cert' => 'Gå tilbake til sertifikat administrasjon.',
    'b_to_cl_rep' => "Gå tilbake til klientinformasjon.",
    'b_to_report' => 'Gå tilbake til rapporten.',
    'b_to_report_list' => 'Gå tilbake til brukerdefinerte rapportlayouter.',
    'b_to_db_list' => 'Gå tilbake til listen over databaser.',
    'b_to_db_usr_lst' => 'Gå tilbake til listen over databasebrukere.',
    'b_to_db_servers' => 'Gå tilbake til listen over databaseservere.',
    'b_to_dns_template' => 'Gå tilbake til DNS-mal post liste.', //to remove
    'b_to_log_files_list' => 'Gå tilbake til administrasjon av loggfiler.',
    'b_to_log_rotation' => 'Returner til loggrotasjonsinnstillinger.',
    'b_to_locales' => 'Gå tilbake til behandling av Plesk-språk.',
    'b_to_modules' => 'Gå tilbake til behandling av moduler.',
    'b_to_modules_management' => 'Gå tilbake til behandling av moduler.',
    'b_to_cl_pool' => 'Gå tilbake til administrasjon av IP-utvalg.',
    'b_to_db' => 'Gå tilbake til administrasjonssiden for databaser.',
    'b_to_db_edit' => 'Gå tilbake til administrasjonssiden for databasebruker.',
    'b_to_dom_templates' => 'Gå tilbake til administrasjon for domenemaler.',
    'b_to_dom_sum_report' => 'Gå tilbake til oppsummeringsrapport for domene.',
    'b_to_statistics' => 'Gå tilbake til trafikkstatistikk.',
    'b_to_ip_aliasing' => 'Gå tilbake til administrasjon av IP-adresser.',
    'b_to_qus' => 'Gå tilbake til listen over køer.',
    'b_to_site_apps' => 'Gå tilbake til listen over webprogrammer.',
    'b_to_site_app_pkgs' => 'Gå tilbake til programhvelvet.',
    'b_to_siteapp_install' => 'Gå tilbake til installasjonsveiviser for webprogrammer.',
    'b_to_siteapppackage_info' => 'Gå tilbake til egenskaper for webprogrampakker.',
    'b_to_additional_key_info' => 'Gå tilbake til egenskaper for lisensnøkkel.',
    'b_to_additional_key_properties' => 'Gå tilbake til egenskaper for lisensnøkkel.',


    //===============Href conhelp==================//
    'b_components_choice_default' => 'Endre standardkomponenten for denne egenskapen.',
    'b_components_configure' => "Sett opp konfigurasjonsparameterene for denne komponenten.",


    //===============Icon conhelp==================//

    'i_db_conn_none' => 'Denne funksjonen er ikke tilgjengelig fordi lisensnøkkelen ikke støtter den eller tjenesten er ikke installert.',
    'i_db_conn_ok' => 'Tilkobling til database er etablert.',
    'i_db_conn_att' => 'Databaseserveren er ikke startet eller feil påloggingsinformasjon er oppgitt.',
    'i_db_conn_stopped' => 'Databaseserveren er ikke startet.',
    'i_db_conn_login_failed' => 'Feil påloggingsinformasjon ble angitt for databasetilkoblingen.',

    'i_drweb_off' => "Antivirussjekk er ikke aktivert for e-postkonto.",
    'i_drweb_any' => 'Antivirussjekk er aktivert for utgående/innkommende e-post.',
    'i_drweb_from' => 'Antivirussjekk er aktivert for utgående e-post.',
    'i_drweb_to' => 'Antivirussjekk er aktivert for innkommende e-post.',
    'i_drweb_turn_key' => 'Antivirus støttes ikke av lisensnøkkelen.',
    'i_drweb_turn_perm' => 'Du ikke har tillatelse til behandle antivirus.',
    'i_drweb_turn_install' => 'Antivirus er ikke innstallert.',
    'i_drweb_turn_pref' => 'Klikk for å behandle antivirusinnstillinger.',

    'i_client_ok' => 'Klientens ressursbruk er innenfor grensene.',
    'i_cl_ok' => 'Klientens ressursbruk er innenfor grensene.',
    'i_cl_!' => "Klientens ressursbruk overskrider grensene.",
    'i_client_on' => 'Denne brukerkontoen er aktiv.',

    'i_client_cp_access_on' => 'Tilgang til Kundepanelet er tillatt for kunden.',
    'i_client_cp_access_off' => 'Tilgang til Kundepanelet er ikke tillatt for kunden.',
    'i_click_to_cl_cp_access_on_off' => "Klikk for å tillate eller hindre kunden tilgang til Kundepanelet.",

    'i_custom_errors_del' => 'Klikk for å fjerne element fra liste.',
    'i_custom_errors_del_disabled' => 'Fjerning av serverens standard brukerdefinerte feil er ikke tilgjengelig.',

    'i_open_subdomain' => 'Klikk for å vise området i nettleser.',
    'i_open_domain' => 'Klikk for å vise området i nettleser.',
    'i_open_domain_disabled' => 'Domenet har ingen hosting konfigurert.',

    'i_dom_ok' => 'Ressursforbruk for dette domenet er innenfor tildelte grenser.',

    'i_dom_tmpl__owner_admin' => 'Denne malen er opprettet av administrator',
    'i_dom_tmpl__owner_client' => 'Denne malen er opprettet av en kunde.',

    'i_dns_on' => 'Denne DNS-sonen tjenes av en lokal DNS-server.',
    'i_dns_off' => 'Denne DNS-sonen tjenes av en ekstern DNS-server.',
    'i_click_to_dom_on_off' => 'Klikk for å aktivere/deaktivere domenet.',
    'i_click_to_cl_on_off' => "Klikk for å aktivere/deakitvere kundens konto og domener.",
    'i_dom_!' => 'Grenser for ressursbruk er overskredet av dette domenet.',
    'i_dom_on' => 'Domenet er aktivt.',
    'i_dom_off' => 'Domenet er ikke aktivt.',
    'i_dom_off_by_admin' => 'Domenet ble suspendert av administrator.',
    'i_dom_off_by_reseller' => 'Domene ble suspendert av forhandler.',
    'i_dom_off_by_client' => 'Domenet ble suspendert av klient.',
    'i_dom_off_expired' => 'Domenet er utløpt.',
    'i_dom_off_with_parent' => "Denne brukerkontoen og brukerens domene ble suspendert",
    'i_dom_off_backup_restore' => 'Domenet er midlertidig suspendert for sikkerhetskopiering eller gjenoppretting.',

    'i_locale_active_true' => 'Dette språket er tilgjengelig for Plesk-brukere.',
    'i_locale_active_att' => 'Dette språket ble utilgjengelig for brukere fordi din grense for antall tillatte språk er overskredet.',
    'i_locale_active_false' => 'Dette språket er ikke tilgjengelig for brukere.',
    'i_locale_set_active_true' => 'Klikk på dette ikonet for å gjøre språket tilgjengelig for brukere.',
    'i_locale_set_active_false' => 'Klikk på dette ikonet for å gjøre språket utilgjengelig for brukere.',
    'i_locale_default_locale' => 'Dette er standardspråket: du kan ikke gjøre det utilgjengelig for brukere.',

    'i_log_rot_enabled' => 'Loggrotasjon er slått på.',
    'i_log_rot_disabled' => 'Loggrotasjon er slått av.',
    'i_log_rot_disabled_by_parent' => 'Loggrotasjon er slått av fordi nettstedet ble slått av.',

    'i_spamfilter_on' => 'Spamfiltrering er slått på.',
    'i_spamfilter_off' => 'Spamfiltrering er slått av.',
    'i_spamfilter_turn_srv' => 'Bruke av personlige spambeskyttelsesinnstillinger er ikke tillatt av serverpolicyen.',
    'i_spamfilter_turn_key' => 'SpamAssassin støttes ikke av lisensnøkkelen.',
    'i_spamfilter_turn_component' => 'SpamAssassin komponenten er ikke installert.',
    'i_spamfilter_service_off' => 'SpamAssassin-tjenesten kjører ikke.',
    'i_spamfilter_turn_is_disabled_system_wide' => "Spambeskyttelse ble avslått av leverandøren av hostingtjenesten.",
    'i_spamfilter_turn_permission' => 'Du ikke har tillatelse til behandle spamfilter.',

    'i_additional_key_free' => 'Distribueres fritt. Det kreves ingen lisensnøkkel.',
    'i_additional_key_ok' => 'Den nødvendige lisensnøkkelen er installert.',
    'i_additional_key_problem' => 'Den nødvendige lisensnøkkelen er ikke installert.',
    'i_additional_key_info' => 'Klikk på ikonet for å få tilgang til administrasjonsfunksjoner for lisensnøkkelen.',
    'i_additional_key_download' => 'Klikk for å laste ned lisensnøkkelen.',

    'i_vcard' => 'Legg til person i adresseboken din.',

    'i_autoinstaller_component_action_error' => 'Ingen oppdateringer tilgjengelig.',

    'i_autoinstaller_release_action_upgrade' => 'Oppgraderer til ny Plesk-versjon.',
    'i_autoinstaller_release_action_update' => 'Oppdatering eller legg til nytt komponent.',
    'i_autoinstaller_release_action_up2date' => 'Du har oppdatert versjon.',
    'i_autoinstaller_release_action_error' => 'Feil under henting av informasjon for denne versjonen.',

    'i_autoinstaller_component_action_install' => 'Ikke installert',
    'i_autoinstaller_component_action_update' => 'Oppdateringer er tilgjengelig',
    'i_autoinstaller_component_action_upgrade' => 'Oppdateringer er tilgjengelig',
    'i_autoinstaller_component_action_up2date' => 'Du har en oppdatert versjon',

    'i_mail_resp_on' => 'Autosvaret er slått på.',
    'i_mail_resp_turn_off' => 'Klikk dette ikonet for å slå det av.',
    'i_mail_resp_off' => 'Autosvaret er slått av.',
    'i_mail_resp_turn_on' => 'Klikk dette ikonet for å slå det på.',
    'i_mail_resp_att' => 'Alle autosvar er slått av for denne e-postkontoen.',

    'i_anonftp_on' => 'Anonym FTP-konto for domenet er slått på.',
    'i_anonftp_off' => 'Anonym FTP-konto for domenet er slått av.',

    'i_sapp_ssl' => 'Webprogram er installert i SSL/TLS-mappe.',
    'i_sapp_non_ssl' => 'Webprogram er installert i  mappe som er ikke-SSL/TLS.',
    'i_serv_drweb_up_dis' => "Start tjenesten.",
    'i_serv_none' => 'Tjenesten er ikke installert.',
    'i_serv_not_configured' => 'Tjenesten er ikke konfigurert.',
    'i_serv_on' => 'Tjenesten kjører.',
    'i_serv_off' => 'Tjenesten kjører ikke.',
    'i_serv_up' => 'Start tjenesten.',
    'i_serv_up_dis' => 'Tjenesten kjører allerede.',
    'i_serv_down' => 'Stopp tjenesten.',
    'i_serv_down_dis' => 'Tjenesten er allerede stoppet.',
    'i_serv_up_n_down' => 'Start tjenesten på nytt.',
    'i_serv_up_n_down_dis' => 'Tjenesten er stanset.',
    'i_serv_key_dsbld_not_inst' => 'Denne funksjonen er ikke tilgjengelig fordi den enten ikke støttes av lisensnøkkelen din eller tjenesten er ikke riktig konfigurert.',

    'i_skin_download' => 'Klikk for å laste ned skin\'et.',

    'i_virtualdirs_read_enabled' => 'Lesetillatelsen for den virtuelle mappen er aktivert.',
    'i_virtualdirs_read_disabled' => 'Lesetillatelsen for den virtuelle mappen er deaktivert.',
    'i_virtualdirs_write_enabled' => 'Skrivetillatelsen for den virtuelle mappen er aktivert.',
    'i_virtualdirs_write_disabled' => 'Skrivetillatelsen for den virtuelle mappen er deaktivert.',
    'i_virtualdirs_source_enabled' => 'Skript-kildetilgangstillatelser for den virtuelle mappen er aktivert.',
    'i_virtualdirs_source_disabled' => 'Skript-kildetilgangstillatelser for den virtuelle mappen er deaktivert.',
    'i_virtualdirs_browse_enabled' => 'Gjennomgangstillatelsen for den virtuelle mappen er aktivert.',
    'i_virtualdirs_browse_disabled' => 'Gjennomgangstillatelsen for den virtuelle mappen er deaktivert.',
    'i_virtualdirs_change_status' => 'Klikk for å koble tillatelse på/av.',

    'b_show_additional_users' => 'Utvider listen over brukere/brukergrupper til å vise brukere med udefinerte tillatelser.',
    'b_hide_additional_users' => 'Reduserer liste av brukere/brukeres grupper ved å skjule brukere med udefinerte tillatelser.',

    'i_prtd_ssl' => 'SSL/TLS-mappen er passordbeskyttet.',
    'i_prtd_no_ssl' => 'SSL/TLS-mappen er ikke passordbeskyttet.',
    'i_prtd_nonssl' => 'Ikke-SSL/TLS- mappen er passordbeskyttet.',
    'i_prtd_no_nonssl' => 'Ikke-SSL/TLS-mappen er ikke passordbeskyttet.',
    'i_prtd_cgi_bin' => 'cgi-bin mappen er passordbeskyttet.',
    'i_prtd_no_cgi_bin' => 'cgi-bin-mappen er ikke passordbeskyttet.',

    'i_htype_none' => 'Hosting er ikke satt opp.',
    'i_htype_vrt_hst' => 'Fysisk hosting.',
    'i_htype_frm_fwd' => 'Ramme videresending.',
    'i_htype_std_fwd' => 'Standard videresending.',

    'i_click_to_hosting' => 'Klikk for å fortsette til oppsett av hosting.',

    'i_ftp_ses_domain' => 'Domeneadministratorøkt.',
    'i_ftp_ses_sub_domain' => 'Administratorøkt for underdomene.',
    'i_ftp_ses_web_user' => 'Webbrukerøkt.',
    'i_ftp_ses_anonymous' => 'Anonym FTP brukerøkt.',
    'i_ftp_ses_not_plesk' => 'FTP-bruker som ikke er registrert i Plesk.',
    'i_ftp_ses_idle' => 'Tomgang (ingen transaksjoner).',
    'i_ftp_ses_upload' => 'Opplasting pågår.',
    'i_ftp_ses_download' => 'Nedlasting pågår.',
    'i_ftp_ses_list' => 'Laster ned en liste over mapper.',
    'i_ftp_ses_not_know' => 'Ukjent FTP aktivitet.',


    //===============Page conhelp==================//

    'admin_ed' => 'Administrator informasjon.',
    'anonftp' => 'Konfigurer anonym FTP-tjeneste.',
    'actionlog' => 'Behandle innstillinger for Handlingslogg.',
    'auto_updates' => "Tilgjengelige {$PROD_NAME} oppdateringer.",
    'autoinstaller_releases' => 'Velg ønsket utgivelsesnavn for å få tilgang til listen over tilgjengelige komponenter.',
    'autoinstaller_components' => 'Velg påkrevd komponent og klikk Installer for å installere dem.',
    'autoinstaller_install' => 'Vennligst bekreft installasjonen og klikk på OK for å begynne.',
    'autoinstaller_configure' => 'Innstillinger for Oppdaterer.',
    'backup_dialog' => 'Du kan sikkerhetskopiere domenet på denne siden. Den resulterende sikkerhetskopien kan plasseres i det lokale eller det eksterne lageret eller lastes ned til den lokale disken.',
    'backup_configure' => 'Konfigurasjonside for sikkerhetskopi administrator.',
    'card' => 'Rediger personlig informasjon.',
    'cat_edit' => 'Side for oppsett av Category.',
    'cert' => 'Sertifikatdepot.',
    'cert_dom' => 'Sertifikatdepot.',
    'cert_add' => 'Legg til sertifikat.',
    'cert_add_dom' => 'Legg til sertifikat.',
    'cert_edit' => 'Sertifikatsredigeringsside',
    'cl_ed' => "Rediger kundens informasjon og klikk OK.",
    'cl_home' => 'Kundens startside.',
    'cl_new' => "Legg inn kundens informasjon og klikk på OK for å opprette en kundekonto.",
    'cl_perm' => "Konfigurer kundens tillatelser.",
    'cl_limits' => "Konfigurer kundens grenser.",
    'cl_logo' => "Sett opp en logo for kundens Kundepanel.",
    'cl_pool' => 'Rekkevidde for IP-adresser tildelt kunden.',
    'cl_pool_add' => "Tildeling av IP-adresser til kunden.",
    'cl_pool_first_time' => 'Tildeling av IP-adresser til kunden.',
    'cl_pool_ctrl' => 'IP adresseegenskaper.',
    'cl_pref' => "Kundens innstillinger.",
    'cl_traffic_history' => 'Side med kundens trafikkhistorikk.',
    'cl_templates' => 'Denne siden lister opp kundens maler.',
    'cl_traffic' => "Kundens trafikk",
    'clients' => 'Denne siden viser en liste over alle kundekontoer som er registrert i systemet.',
    'component_conf' => "Konfigurerer komponent parameterene.",
    'custom_buttons_admin' => 'Opprett og administrer de brukerdefinerte knappene dine for.',
    'custom_buttons_domain' => 'Opprett og administrer de brukerdefinerte knappene dine for.',
    'custom_buttons_client' => 'Opprett og administrer de brukerdefinerte knappene dine for.',
    'custom_buttons_reseller' => 'Opprett og administrer de brukerdefinerte knappene dine for.',
    'custom_buttons_remove' => 'Fjern valgte brukerdefinerte knapper.',
    'custom_button_admin_edit' => 'Rediger brukerdefinert knapp.',
    'custom_button_domain_edit' => 'Rediger brukerdefinert knapp.',
    'custom_button_client_edit' => 'Rediger brukerdefinert knapp.',
    'custom_button_reseller_edit' => 'Rediger brukerdefinert knapp.',
    'configure' => 'Etterinstaller konfigurasjonssiden.',
    'comp_info' => 'Informasjon om komponenter.',
    'common_acl' => 'Denne siden viser liste over alle IP- og nettverksadresser hvor soneoverføring er tillatt.',
    'to_common_acl' => 'Gå tilbake til den generelle tilgangskontrollisten.',
    'common_acl_add' => 'På denne siden kan du legge til oppføringer til generell soneoverføring ACL.',
    'common_acl_remove' => 'Fjerning av de valgte ACL oppføringene.',
    'cp_access' => 'Administrasjon av tilgang til Plesk.',
    'cp_access_add_edit' => 'Nettverksegenskaper.',
    'cp_access_remove' => 'Fjerne nettverk fra tilgangsbegrensningslisten.',
    'crontab_unix' => 'Denne siden lister opp alle oppgavene som er planlagt i systemet.',
    'crontab_win' => 'Denne siden lister opp alle oppgavene som er planlagt i systemet.',
    'crontab_unix_add_edit' => 'Fyll ut de påkrevede feltene og klikk OK for å planlegge oppgaven.',
    'crontab_win_add_edit' => 'Fyll ut de påkrevede feltene og klikk OK for å planlegge oppgaven.',
    'crontab_unix_remove' => 'Fjerning av de valgte oppgaver.',
    'crontab_win_remove' => 'Fjerning av de valgte oppgaver.',
    'scheduler' => 'Denne siden inneholder liste over planlagte oppgaver i systemet.',
    'scheduler_edit' => 'Fyll ut de påkrevde feltene og klikk OK for å legge til oppgaven i Planleggeren.',
    'scheduler_remove' => 'Fjerning av de valgte planlagte oppgavene.',
    'b_databases_access' => 'Sett opp påloggingsinformasjon for tilgang til ekstern databaseservere.',
    'databases_db' =>  'Databasetilgang konfigurasjon og administrasjonsverktøy.',
    'databases_server' =>  'Denne siden endrer passordet som brukes for tilgang til databaseserveren.',
    'db' => 'Alle databaser som behandles av Plesk er listet på denne siden.',
    'db_add' => 'Legge til en ny database.',
    'db_edit' => 'Alle brukere av denne databasen er listet på denne siden.',
    'db_usr_edit' => 'Sett opp passord for databasebruker.',
    'defaultcomponents' => 'Valg av standardkomponenter for tjenestene.',
    'dl_usr_ed' => "Administrer domeneadministratorens konto.",
    'dns_add' => 'Legg en oppføring til DNS-sonen til domenet.',
    'dns_soa' => 'Konfigurasjonsinnstillinger for SOA',
    'dns_check' => 'Testresultater for DNS-sone.',
    'dns_rec_edit' => 'Rediger en ressurs oppføring.',
    'dns_default' => 'Gjenopprett DNS-sonen.',
    'mail_name_drweb' => 'Oppsett av antivirusinnstillinger.',
    'dom_ctrl' => 'Domeneadministrasjon.',
    'dom_traffic' => 'Trafikk på domenet.',
    'dom_templates' => 'Domenemalen er et forhåndsdefinert sett domenespesifikke begrensninger, alternativer og hostingparametere, ment for forenklet opprettelse av domener med automatisk tildeling av innstillinger.',
    'create_domain' => 'Legg inn et nytt domenenavn for å opprette et domene for kunden.',
    'create_domain_client_select' => 'Velg den kunden du ønsker å opprette domenet for.',
    'dom_pref' => 'Domeneinnstillinger.',
    'dom_lim' => 'Domenegrenser.',
    'domain_report' => 'Domeneinformasjon.',
    'domain_aliases' => 'Administrer domenealias.',
    'client_app_item_info' => 'Informasjon om webprogram.',
    'client_report' => 'Kundeinformasjon.',
    'cl_rpt_list' => 'Brukerdefinerte rapportlayouter.',
    'dom_rpt_list' => 'Brukerdefinerte rapportlayouter.',
    'dom_rpt_edit' => 'Rediger rapport.',
    'dom_sum_report' => 'Denne siden viser domenets oppsummeringsrapport om alle domener som tjenes av systemet.',
    'domains' => 'Denne siden viser en liste over alle domener som tjenes av systemet.',
    'dumps_list' => 'Bruk funksjoner for sikkerhetskopiering av domene og administrer lagring av sikkerhetskopier.',
    'download_dialog' => 'Etablering av en sikkerhetskopi fil.',
    'extras' => 'Side for administrasjon av ytterligere tjenester.',
    'edit_dom_tmpl' => 'Rediger en domenemal på denne siden.',
    'edit_cl_tmpl' => 'Rediger en kundemal på denne siden.',

    'interface_templates' => 'Administrasjon av grensesnitt maler.',
    'interface_templates_remove' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",

    'b_to_interface_templates' => 'Gå tilbake til listen over grensesnitt-mal.',
    'b_interface_template_make_default' => 'Velg grensesnitt-mal og klikk for å sette det som standard.',
    'interface_template_upload' => 'Last opp malen for ditt grensesnitt.',
    'interface_clients' => 'Liste over klienter som bruke denne grensesnitt-malen.',
    'b_to_interface_clients' => 'Gå tilbake til listen over klienter som bruke denne grensesnitt-malen.',
    'interface_clients_add' => 'Spesifiser klientene som skal bruke denne grensesnitt malen.',
    'interface_clients_remove' => 'Spesifiser klientene som ikke skal bruke denne grensesnitt malen.',

    'ftp_account' => 'Hvis du bruker en ekstern FTP-server for lagring av sikkerhetskopifiler, angi egenskaper for FTP-kontoen som brukes på denne server.',
    'ftp_dumps_list' => "Innholdet av sikkerhetskoplageret på FTP-serveren er oppført. Du kan velge en sikkerhetskopi som skal lastes opp til domenelageret.",

    'filemanager' => 'Behandle dine filer og mapper på denne siden.',
    'filemanager_rename_file' => 'Endring av filnavn.',
    'filemanager_rename_dir' => 'Gi mapper nytt navn.',
    'filemanager_chmod' => 'Endrer tilgangsrettigheter til filen.',
    'filemanager_copy_move' => 'Filkopiering (flytting).',
    'filemanager_create_file' => 'Filetablering.',
    'filemanager_show' => 'Visning av fil.',
    'filemanager_edit' => 'Filredigering.',
    'filemanager_remove' => 'Fjerning av filer.',
    'filemanager_owner_row' => 'Fileier.',
    'filemanager_new_file' => 'Filetablering.',
    'filemanager_new_dir' => 'Opprettelse av mappe.',

    'gl_list' => 'Global Help Desk.',
    'groups' => 'Administrasjon av E-postgruppe',
    'icf' => 'Brannvegg konfigurering.',
    'ip_clients' => 'Liste over brukere som har denne IP-adresse i sitt utvalg.',
    'ip_clients_add' => 'Velg klienter og klikk OK for å legge til denne IP-adressen i deres utvalg.',

    'frm_fwd' => 'Skriv inn destinasjons URL for videresending.',
    'std_fwd' => 'Skriv inn destinasjons URL for videresending.',
    'performance' => 'Konfigurasjon av domeneytelser.',
    'phosting_setup' => 'Oppsett av hostingkonto. Velg IP-adressetype (dedikert eller delt), brukernavn og passord for FTP-konto og andre hostingrelaterte parametere.',
    'phosting_setup_dom_usr' => 'Parameteroppsett av hostingkonto.',
    'webusers' => 'Denne viser webbrukere for dette domenet.',
    'hst_type_sel' => 'Velg hostingtype du skal sette opp.',
    'key_update' => 'Status for nøkkeloppdatering.',
    'key_revert' => 'Tilbakerulling av lisensnøkkel.',
    'interface_management' => 'Denne siden lar deg kontrollere hvilke elementer av brukergrensesnittet som er synlig og hvilke som ikke er det.',
    'ip_aliasing' => 'Legg til og ta bort IP adresser fra nettverks grensesnittene.',
    'ip_aliasing_clients' => 'Se liste over brukere som har denne IP-adressen i deres IP-utvalg',
    'ip_aliasing_hosting' => 'Se domenene som er hostet på eller viderekoblet fra denne IP-adressen',
    'ip_add' => 'Tillegging av IP adresse.',
    'ip_ctrl' => 'IP adresse parameterene endres.',
    'license' => 'Les lisensavtalen nøye.',
    'logo' => 'Endre logo bilde og logo URL.',
    'log_files' => 'Denne siden viser alle loggfiler for domenet.',
    'log_rotation' => 'Loggrotasjonsinnstillinger',

    'locale_upload' => 'Opplasting av språkpakke.',
    'locales' => 'Administrer språk i Plesk.',
    'locales_remove' => 'Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.',
    'mail_blocked_domains' => 'Behandle svarteliste.',

    'mail_white_list' => 'Behandle hviteliste',
    'mail_white_list_edit' => 'Legg domener til hvitelisten.',
    'mail_white_list_remove' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",

    'mail_name_alias_edit' => 'Opprett eller rediger e-postalias.',
    'mail_name_groups' => 'Administrasjon av postgruppe-medlemskap .',
    'mail_name_mailbox' => 'Administrasjon av postboks.',
    'mail_name_preferences' => 'Innstillinger for e-postkonto.',
    'mail_name_redirects' => 'Administrasjon av e-post-videresendere.',
    'mail_name_redirects_add' => 'Legg til e-postgruppemedlem.',
    'mail_name_redirects_remove' => 'Fjerning av e-postgruppemedlemmer.',
    'mail_name_resp_edit' => 'Konfigurere autosvar.',
    'mail_name_resp_attach_add' => 'Velg filer som skal legges ved.',
    'mail_name_resp_attach_del' => 'Fjern autosvar vedlegg.',
    'mail_name_resp_remove' => 'Ta bort autosvar.',
    'mail_name_responders' => 'Administrasjon av autosvar.',
    'mail_name_files' => 'E-postkonto vedleggsdepot.',
    'mail_name_files_remove' => 'Fjerning av filer.',
    'mail_names' => 'E-postkontoer (postbokser, videresendere for e-post, e-postgrupper, autosvar).',
    'mail_preferences' => 'E-postinnstillinger.',

    'maillists' => 'Denne siden viser alle adresselister i dette domenet.',
    'maillists_conf' => 'Hovedside for opprettelse av adresselister',
    'maillist_edit' => 'Innstillinger for adresseliste.',
    'maillist_new' => 'Legge til adresseliste',
    'maillist_del' => 'Fjerning av adresseliste',

    'maillist_members' => 'Adresseliste-abonnenter.',
    'maillist_members_remove' => 'Fjerning av adresseliste-abonnenter.',
    'maillist_member_edit' => 'Legge til brukere i adresseliste',

    'upload_module' => 'Opplasting av utvidelser.',
    'modules_management' => 'Administrasjon av utvidelser.',

    'b_modules_add' => 'Legg til en utvidelser.',
    'modules_manaege' => 'Legg til og fjern utvidelser.',
    'modules' => 'Fra denne siden kan du tilgang til funksjoner som leveres av utvidelsene installert i Plesk.',

    'notifications' => 'Administrer meldingssystemet.',
    'notification_text' => 'Rediger meldingstekst.',
    'pg_manage' => 'Legg til PostgreSQL administratorinformasjon.',
    'prtd_dirs' => 'Passord-beskyttede mapper.',
    'reboot' => 'Datamaskinen vil nå bli startet på nytt.',
    'responders' => 'E-post-autosvar.',
    'redirects' => 'E-post-videresendere',
    'restart_services' => 'Tjenestebehandling.',
    'server' => 'Serveradministrasjon.',
    'sessions' => 'Endre øktinnstillinger.',
    'sessions_list' => 'Denne siden viser liste over alle økter.',
    'ftp_sessions_list' => 'Denne siden viser liste over alle FTP-økter.',
    'cl_skeleton' => 'Administrer mal for virtuell vert.',
    'skeleton' => 'Administrer mal for virtuell vert.',
    'skins' => 'Administrer Plesk-skall.',
    'skin_info' => 'Skin informasjon.',
    'skin_download' => 'Skin nedlastning.',
    'skin_download_now' => 'Nedlasting av skin pågår.',
    'skin_upload' => 'Opplasting av skin.',
    'skins_remove' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'shutdown' => 'Systemet er i ferd med å stenges ned.',
    'site_app_pkgs_add' => 'Legg til webprogrampakke.',
    'site_app_pkgs_list' => 'Tilgjengelige webprogrampakker.',
    'site_app_pkgs_instances' => 'Programinstallasjoner.',
    'siteapp_install' => 'Installasjon av webprogram.',
    'siteapp_reconfigure' => 'Omkonfigurering av webprogram.',
    'sitepackage_install_config' => 'Installasjonsinnstillinger for webprogrammer.',
    'sitepackage_install_agreement' => 'Lisensavtale for webprogram.',
    'siteapp_extra_files' => 'Vennligst presiser hva som skal gjøres med filene.',
    'siteapppackage_info_server' => 'Egenskaper for webprogrampakke.',
    'siteapppackage_info_domain' => 'Egenskaper for webprogrampakke.',

    'statistics' => 'Systemstatistikk',
    'sys_time' => 'Sett opp system dato/tid og synkronisering med NTP-server.',
    'subdomains' => 'Administrasjon av underdomener. Du kan legge til, redigere og fjerne underdomener fra denne siden.',
    'subdom_ctrl' => 'Administrasjonsside for underdomener.',
    'subdom_edit' => 'Konfigurer egenskaper for underdomene.',
    'subdom_create' => 'Opprettelse av underdomener.',
    'subdom_remove' => 'Fjerning av de valgte underdomenene.',
    'templates' => 'Denne siden viser en liste med alle domenemaler, som kan benyttes under opprettelse av et nytt domene.',
    'view_info' => 'Fra denne siden kan du se sikkerhetskopifilens egenskaper og gjenopprette denne sikkerhetskopien.',

    'visibility_adminonly' => 'Gjør denne kontrollen kun synlig på siden til administrator.',
    'visibility_cancel' => 'Avbryt tilpasning av kontroller på denne skjermen.',
    'visibility_control' => 'Klikk for å tilpasse denne kontrollen.',
    'visibility_customize' => 'Skreddersy individuelle kontroller på denne skjermen.',
    'visibility_default' => 'Bruk standard innstillinger for denne kontrollen.',
    'visibility_export' => 'Eksporter innstillingene gjort på denne skjermen i form av et skall-skript. Kjør dette skriptet på en Plesk-administrert server for å importere innstillingene.',
    'visibility_hide' => 'Skjul denne kontrollen.',
    'visibility_hide_toolbar' => 'Skjul denne verktøylinjen.',
    'visibility_ok' => 'Lagre tilpasningene av kontroller på denne skjermen.',
    'visibility_reset_all' => 'Tilbakestill kontroller på alle skjermer til deres standard innstillinger.',
    'visibility_reset_screen' => 'Tilbakestill kontroller på denne skjerme til deres standard innstillinger.',
    'visibility_show' => 'Vis denne kontrollen.',

    'virtualdirs' => 'Administrasjon av virtuelle mapper.',
    'virtualdir_create' => 'Opprettelse av virtuell mappe.',
    'virtualdir_edit' => 'Redigering av virtuell mappe.',
    'virtualdirs_remove' => 'Fjerning av virtuelle mapper.',
    'web_users' => 'Administrer webbrukere av domenet.',
    'web_users_preferences' => "Ekstra webbruker-innstillinger.",
    'wu_edit' => 'Sett opp FTP-passord for webbruker.',
    'lang' => 'Sett standard grensesnitt språk på denne siden.',
    'ch_pass' => "Endre administrators passord på denne siden.",
    'dns_template' => 'Administrasjon av mal for DNS-sone.', //to remove
    'dns_template_add' => 'Legg en oppføring til mal for DNS-sone.', //to remove

    'dns_t' => 'Dette skjermbildet viser ressursoppføringer på DNS-sonemal for hele serveren.',
    'dns_t_add' => 'Legg en oppføring til mal for DNS-sone.',
    'dns_t_soa' => 'Konfigurasjonsinnstillinger for SOA',
    'dns_t_rec_edit' => 'Rediger en ressurs oppføring.',
    'dns_t_rec_remove' => 'Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.',
    'dns_t_default' => 'Gjenopprett mal for DNS-sone.',
    'b_to_dns_t' => 'Gå tilbake til DNS-mal post liste.',

    'web_app_add' => 'Legg til Java-program.',

    'qu_edit' => 'Side for oppsett av kø.',
    'qus' => 'Siden vise liste over køer.',

    'remove_modules' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeServers' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeCerts' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeMailAliases' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeDataBases' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeDataBaseUsers' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeCrontabTask' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeDomains' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeDNS' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeClients' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeLogFiles' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeDumps' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeMailNames' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeWebUsers' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeSessions' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeTemplates' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeIPAddress' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'removeClientsIP' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",

    'cat_remove' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'pr_remove' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'qu_remove' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",

    'pr_edit' => 'Oppsett av prioritet.',
    'prs' => 'Denne siden lister opp prioriteter.',

    'spamassassin' => 'Innstillinger for SpamAssassin',
    'spamassassin_train' => 'Opplæring av statistikkdatabaser som brukes for Bayesisk filter. Klassifiser innholdet i din postboks som spam og god e-post.',
    'spamassassin_train_view_message_source' => 'Klikk for å vise meldingskilde.',
    'spamassassin_user_conf' => 'Personlig konfigurasjon av SpamAssassin-innstillinger.',
    'spaw' => 'HTML-redigeringsprogram.',
    'upload_dump' => "Velg en sikkerhetskopi og klikk på 'Last opp' for å laste opp filen til lageret. For å laste opp en sikkerhetskopi over flere volumer, spesifiser første del av volumet, klikk så på koblingen 'Angi neste volum' og spesifiser det neste volumet. Gjenta til du har oppgitt alle volumer av sikkerhetskopien. Når dette er klart, klikk på 'Last opp'.",
    'subdom_performance' => 'Konfigurer ytelse for underdomene.',

    'dom_performance_edit' => 'Konfigurasjon av domeneytelser.',
    'dom_performance_readonly' => 'Vis konfigurasjon av domeneytelse.',

    //===============List table header conhelp==================//

    'l_inv' => 'Inverter valget av avmerkingsbokser.',
    'l_rad' => 'velg alternativknapp.',

    'b_wizard_prev' => 'Gå tilbake til forrige trinn i veiviseren.',
    'b_wizard_next' => 'Fortsett til neste trinn i veiviseren.',
    'b_finish' => 'Benytt endringene som er gjort på denne skjermen og avslutt veiviseren.',

    // pacif add

    'b_backup_ftp_settings' => 'Klikk for å angi FTP-kontoinnstillinger.',
    'b_backup_scheduled_settings' => 'Klikk for å sette opp sikkerhetskopiering på tidsplanen.',
    'b_backup_ftp_not_configured' => 'FTP-konto er ikke konfigurert.',
    'backup_client_front' => 'Sikkerhetskopier og gjenopprett brukerkonto og sett opp tidsplan for sikkerhetskopiering.',
    'backup_domain_front' => 'Sikkerhetskopier og gjenopprett nettsted og sett opp tidsplan for sikkerhetskopiering.',
    'backup_client_new' => 'Sikkerhetskopier en brukerkonto.',
    'backup_domain_new' => 'Sikkerhetskopier et nettsted.',
    'backup_ftp_settings' => 'Angi innstillinger for FTP-konto som skal brukes som et eksternt lager.',

    'backup_overwrite' => 'Velg avmerkingsboksen for å bekrefte overskriving, og klikk OK for å overskrive filen.',
    'b_backup_file_overwrite' => 'Klikk for å bytte ut den nåværende sikkerhetskopi filen med en ny.',
    'b_backup_file_overwrite_cancel' => 'Klikk for å avbryte overskriving av filen og gå tilbake til oppsett av sikkerhetskopiegenskaper.',
    'b_backup_cancel' => 'Klikk for å stoppe sikkerhetskopi prosessen.',

    'b_backup_cancel_creating' => 'Klikk for å avbryte opprettelsen av sikkerhetskopi og gå tilbake til forrige side.',
    'b_backup_cancel_ftp_settings' => 'Klikk for å forkaste innstillinger for FTP-konto og gå tilbake til forrige skjermbilde.',
    'b_restore_cancel' => 'Stopp gjenoppretting.',
    'backup_progress' => 'Viser sikkerhetskopi fremdriften. Klikk Avbryt for å avbryte sikkerhetskopi prosessen.',
    'restore_progress' => 'Viser fremdriften for gjenopprettingen. Klikk Kanseller for å stoppe gjenoppretting.',
    'b_backup_new_restore' => 'Start gjenoppretting.',
    'b_restore_cancel_creating' => 'Klikk for å avbryte gjenoppretting og gå tilbake til forrige side.',
    'b_backup_file_delete' => 'Klikk her for å slette sikkerhetskopi filen.',
    'backup_delete' => 'Velg avmerkingsboksen for å bekrefte fjerning av sikkerhetskopifilen og klikk OK.',
    'backup_result' => 'Etter at du har sett over gjenopprettingsresultatet, klikk OK for å fullføre og gå tilbake til sikkerhetskopiadministrasjon.',
    'backup_restore_results' => 'Etter at du har sett over gjenopprettingsresultatet, klikk OK for å gå tilbake til sikkerhetskopiadministrasjon.',

    'i_backup_domain_can_restore' => 'Domenet kan gjenopprettes.',
    'i_backup_domain_exist_other_client' => 'Dette domenet kan ikke gjenopprettes fordi det finnes et annet domene med dette navnet som tilhører en annen bruker.',
    'backup_failed' => 'Sikkerhetskopiering mislyktes.',
    'backup_stop' => 'Klikk OK for å starte sikkerhetskopi prosessen. Klikk Kanseller for å fortsette sikkerhetskopieringen.',
    'restore_stop' => 'Klikk OK for å stoppe gjenoppretting. Klikk Kanseller for å fortsette gjenoppretting.',
    'backup_info_domain' => 'For å gjenopprette data fra denne sikkerhetskopi filen, klikk på Neste>>.',
    'backup_info_domain_restore' => 'For å gjenopprette data fra denne sikkerhetskopi filen, klikk på Gjenopprett>>.',
    'backup_info_client' => 'For å gjenopprette data fra denne sikkerhetskopifilen, velg påkrevde elementer og klikk Neste >>.',
    'backup_ip_mapping_domain' => 'Tilordne IP adressen registrert i sikkerhetskopi filen til en annen tilgjengelig IP adresse.',
    'backup_ip_mapping_client' => 'Tilordne IP adressene registrert i sikkerhetskopi filen til tilgjengelige IP adresser.',
    'backup__db_server_mapping' => 'Velg databaseserveren konfigurert i Plesk som du ønsker å tilordne til databaseserveren fra sikkerhetskopien.',

    'b_restore_ip_mapping' => 'Klikk for å sette opp IP tilordning for gjenoppretting.',
    'learn_more' => 'Les mer om denne nye egenskapen.',
    'try_new_feature' => 'Prøv denne nye egenskapen!',
    'whats_new_full' => 'En detaljert beskrivelse av nye egenskaper og endringer i denne utgaven.',
    'b_migration_dump_all' => 'Migrer alle kontoer fra ekstern vert.',
    'i_migration_not_exist_account' => 'Denne kontoen kan bli overført.',
    'i_migration_exist_account' => "Denne kontoen kan ikke overføres: den er allerede i {$PROD_NAME}",
    'i_migration_not_exist_domain' => 'Dette domenet kan migreres.',
    'i_migration_exist_domain' => "Dette domenet kan ikke migreres: det er allerede i {$PROD_NAME}",
    'i_migration_bad_domain' => 'Dette domenet kan ikke bli migrert: domenenavnet er ugyldig',
    'i_migration_con_exist_domain' => 'Noen av domenene er allerede migrert til denne kontoen.',
    'i_migration_all_domain_exist' => "Kun kontoinformasjonen vil bli migrert: alle domener relatert til denne kontoen er allerede i {$PROD_NAME}",
    'migration_upload' => 'Velg kildeplattform, angi navn på kildevert og påloggingsinformasjon og klikk på Neste for å laste opp Migration & Transfer Agent til verten.',
    'migration_progress' => 'Vis fremdriften for migrering og stopp migreringen om det ønskes.',
    'b_migration_host_info' => 'Vis informasjon om ekstern vert og velg objekter for migrering.',
    'b_migration_single_info' => 'Du har mulighet til å importere alle data fra dumpen eller velge objektene som skal importeres. Fra denne siden kan du også definer distribusjon innstillinger.',
    'migration_content_download' => 'Vis fremdriften for nedlastning av innhold og stopp nedlastningen om det ønskes.',
    'migration_content_download_not_space' => 'Ikke nok diskplass til å laste ned innhold fra den eksterne verten.',
    'migration_objects_select' => 'Velg kontoer og domener for migrering.',
    'migration_account_select' => 'Velg den brukerkontoen på Plesk som du ønsker å migrere de valgte domenene til.',
    'migration_ip_mapping' => 'Velg IP-adressen på Plesk du ønsker å kartlegge til IP-adresser på den eksterne verten.',
    'migration_stop' => 'Sett kryss for å bekrefte at du ønsker å stoppe migreringen og fjerne Migration & Transfer Agent fra den eksterne verten og klikk på OK.',
    'migration_result' => 'Etter å ha sett migreringsresultatene, klikk på Fullfør for å sluttføre.',
    'migration_failed' => 'Overføring feilet.',
    'b_migrate' => 'Start overføring.',
    'b_migrate_cancel' => 'Avslutt overføringsprosessen.',
    'b_migration_reload' => 'Klikk her for å oppdatere dataene.',
    'b_migrate_domains' => 'Klikk for å migrere de valgte domenene.',
    'b_migrate_accounts' => 'Klikk for å overføre valgte konto.',
    'b_migrate_set_accounts' => 'Klikk for å definer konto for overført objekt.',
    'b_migrate_set_ip_map' => 'Klikk for å sette opp IP tilordning for å overføre objektet.',
    'b_migrate_set_db_server_map' => 'Klikk for å sette opp tilordning for overførte databaser.',
    'b_migration_begin' => 'Klikk for å begynne ny overføring.',
    'b_migration_more' => 'Klikk for å migrere flere objekter fra denne verten.',
    'b_migration_retry' => 'Klikk for å fortsette overføring etter du har frigitt diskplass.',
    'b_migration_ignore' => 'Klikk for å fortsette overføring likevel.',
    'b_migrate_single' => 'Migrering på enkel vert.',

    'b_migration_session_add' => 'Klikk for å opprette en overførings økt.',
    'b_to_migration_manager' => 'Gå tilbake til listen over overføring økt.',
    'b_to_ip_map_page' => 'Gå tilbake til IP-tilordning.',
    'migration_upload_ipmap_file' => 'Last opp IP tilordningsfilen.',
    'b_ipmap_download' => 'Last ned IP tilordningsfilen.',
    'b_ipmap_upload' => 'Last opp IP tilordningsfilen.',

    'b_install' => 'Installer webapplikasjon',

    'b_sb_menu_desktop' => "Gå til hjemmesiden til Presence Builder systemadministrator.",
    'b_sb_menu_users' => "Legg til og administrer brukerkontoer og tjenesteplaner for kundene dine.",
    'b_sb_menu_sites' => "Legg til og administrer nettsteder.",
    'b_sb_menu_server' => "Sett opp Presence Builder systemet.",
    'b_sb_menu_logs' => "Se oppføringer for system- og sikkerhetslogger for Presence Builder.",
    'b_sb_server_configure' => "Sett opp integrasjon med Presence Builder.",
    'sb_server_configure_page_description' => "Angi brukernavn og passord som Plesk skal bruke for godkjenning i Presence Builder. Disse brukernavnene og passordene må først settes opp i Presence Builder.",
    'b_sb_site_wizard' => "Gå til til Presence Builder for å opprette og behandle nettsted.",

    'b_connect' => 'Koble din lokale konto til en global konto.',
    'b_disconnect' => 'Koble din lokale konto fra en global konto.',
    'b_fi_change_passwd' => 'Endre passord for den global kontoen.',
    'connect' => 'Koble din lokale konto til din global konto.',
    'disconnect' => 'Frakoble din lokale konto fra din globale konto.',
    'fi_change_passwd' => 'Endre passord for din globale konto.',

    'sapp__no_license_key' => 'Du kan ikke opprette programpakker før du legger til en lisensnøkkel til repositoriet for lisensnøkler',

    'b_dns__tabs_general' => 'Generelle DNS-innstillinger-siden.',
    'sessions__tabs_soa_record' => 'Tilpasning av SOA oppføring.',

    'packages_preinstall' => 'Installasjonsinnstillinger for webprogrammer.',

    'packages_info_server' => 'Vis informasjon om programpakken.',
    'packages_info_domain' => 'Vis informasjon om programpakken.',
    'b_to_packages_info' => 'Gå tilbake til pakkeinformasjonssiden.',
    'packages_install' => 'Installasjon av programpakken.',

    'b_server_app_add' => 'Klikk for å gå til installasjonssiden for det nye serverprogrammet.',
    'b_help_install' => 'Start programinstallasjon.',
    'b_help_cancel' => 'Avbryt programinstallasjon.',
    'packages_reconfigure' => 'Omkonfigurering av serverprogram.',
    'packages_remove' => 'Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.',

    'b_packages_management' => 'Administrasjon av serverprogrammer.',
    'packages_management' => 'Denne siden lar deg installere på og fjerne serverprogrammer fra serveren.',
    'b_to_packages_management' => 'Gå tilbake til side for administrasjon av serverprogrammer.',

    'i_ftp_ses_type' => 'Siste kommando som ble sendt av kunden er TYPE.',
    'i_ftp_ses_pass' => 'Siste kommando som ble sendt av kunden er PASS.',
    'i_ftp_ses_noop' => 'Siste kommando som ble sendt av kunden er NOOP.',

    'virtualdirs__remove_submit' => 'Klikk for å slette valgte virtuelle mapper. De faktiske fysiske mappene er ikke slettet.',

    'b_set_skin' => 'Klikk for å gjøre det gjeldende skinet til standardskin for Plesk.',
    'set_skin__already_default' => 'Gjeldende skin er allerede satt som standard Plesk skin.',

    'i_custom_errors_add' => 'Legg inn nødvendig informasjon og klikk for å legge til en brukerdefinert melding.',

    'i_antivirus_off' => 'Antivirus beskyttelse er ikke aktivert for denne postboksen.',
    'i_antivirus_on' => 'Antivirus beskyttelse er aktivert for denne postboksen.',
    'i_antivirus_turn_pref' => 'Klikk for å sette opp antivirusbeskyttelsesinnstillinger.',
    'i_antivirus_turn_key' => 'Antivirusbeskyttelse støttes ikke av aktiv lisensnøkkel.',
    'i_antivirus_turn_perm' => 'Du ikke har tillatelse for å behandle antivirus.',

    'b_acl_add' => 'Klikk for å legge til en adresse til Allow Zone Transfer ACL.',
    'dns_acl' => 'Denne siden viser liste over alle IP- og nettverksadresser hvor soneoverføring er tillatt.',

    'i_antivirus_any' => 'Antivirusbeskyttelse er slått på for innkommende og utgående e-post.',
    'i_antivirus_from' => 'Antivirusbeskyttelse er slått på for utgående e-post.',
    'i_antivirus_to' => 'Antivirusbeskyttelse er satt opp for innkommende e-post.',

    'i_ip_fail_no_interface' => 'Grensesnittet som er assosiert med IP adressen mangler.',

    'b_test' => 'Test tilkobling.',

    'b_language_groups_add' => 'Legg til språkgruppen i listen over klarerte språk.',
    'b_language_groups_del' => 'Slett språkgruppe i liste over klarerte språk.',
    'b_locale_groups_add' => 'Legg til lokalitetsgruppe i listen over klarerte lokaliteter.',
    'b_locale_groups_del' => 'Slett lokalitetsgruppe i liste over klarerte lokaliteter.',
    'spam_trustednetworks_new' => 'Legg til nettverket i listen over klarerte nettverk.',
    'spam_trustednetworks_remove' => 'Slett nettverket i liste over klarerte nettverk.',


    'i_i_client_on' => 'Kundekontoen er aktiv.',
    'i_i_client_off_by_admin' => 'Kundekonto er deaktivert av administrator.',


    'b_virtualdir_add_disabled' => 'Opprettelse av virtuell mappe er ikke tilgjengelig.',

    'b_db_add_disabled' => 'Din databaseservertilkobling er ikke konfigurert. Det kan settes opp på siden Server > Database.',

    'b_databases__change_server_passwd_disabled' => "Du bruker Plesks interne databaseserver fordi du har konfigurert tilkobling med port 8306. Passordet må derfor byttes på siden Innstillinger > Bytt passord.",

    'b_traffic_at_domains' => 'Viser trafikkstatistikk for serverdomenene.',
    'traffic_at_domains' => 'Trafikkstatistikk for alle domener er registrert i systemet.',

    'b_rdp_session__open_new' => 'Åpne en ny terminal økt.',

    'removeDNS_acl' => 'Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.',

    'i_additional_key_installed' => 'Nøkkelen er installert i programmet.',
    'i_additional_key_not_installed' => 'Nøkkelen er ikke installert i programmet.',

    'b_unhandlederror_showinfo' => 'Klikk for å se tilleggsinformasjon om feilen.',
    'b_unhandlederror_hideinfo' => 'Klikk for å skjule tilleggsinformasjon om feilen.',
    'b_unhandlederror_submitticket' => 'Klikk for å rapportere feilen til kundestøttetjenesten.',
    'unhandlederror' => 'Feil i operasjon.',

    'permissions' => 'Sette opp fil- eller mappetillatelse.',

    'permissions_advanced' => 'Sette opp avanserte fil- eller mappetillatelser.',

    'i_conn_strings_add' => 'Klikk for å legge til koblingsstrengen.',
    'i_conn_strings_add_disabled' => 'Tillegging av koblingsstrenger er ikke tilgjengelig.',
    'i_conn_strings_del' => 'Klikk for å slette koblingsstrengen.',
    'i_conn_strings_del_disabled' => 'Sletting av koblingsstrenger er ikke tilgjengelig.',

    'dns_acl_remove' => 'Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.',

    'to_interface_management' => "Gå tilbake til administrasjonssiden for grensesnitt.",
    't_locales' => "Klikk for å administrere språk for grensesnitt.",
    't_skins' => "Klikk for å administrere skins.",
    't_interface_templates' => "Klikk for å administrere maler for grensesnitt.",
    'b_locale_make_default' => "Velg språkpakke og klikk for å opprette standard.",
    'b_skin_make_default' => "Velg skin og klikk for å opprette som standard.",

    'wu_limits_exceeding' => "Du kan ikke opprette webbrukere fordi grensen for antall støttede webbrukere er overskredet for dette domenet.",

    'mail_setenable_off' => 'Denne funksjon støttes ikke av e-postserver.',
    'domain_aliases__status_ok' => 'Domenealias fungerer riktig.',

    'i_htype_sub_hst' => 'Underdomene på undermappe.',
    'mail_antivirus' => 'Antivirusinnstillinger.',

    'dom_new_no_clients' => 'Du må opprette en kundekonto før du kan legge til domener.',

    'dns_t_acl' => 'Tilgangskontroll-liste innstillinger.',

    'dns_t_acl_remove' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",

    'b_sapp_make_default' => "Gjør det valgte webprogrammet til standard",

    'b_ftp_ctrl' => "Administrer ytterligere FTP-kontoer under et domene.",
    'ftp_ctrl' => "Administrere ytterligere FTP-kontoer under et domene.",
    'b_ftp_user_add' => "Klikk for å legge til FTP-konto.",
    'b_ftp_users_limit_reached' => "Begrensning av antall FTP-kontoer ble nådd.",
    'ftp_user_edit' => "FTP-kontoinnstillinger.",
    'ftp_users' => "Administrer ytterligere FTP-kontoer under et domene.",
    'removeFtpUsers' => "Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.",
    'to_ftp_ctrl' => "Gå tilbake til administrasjonssiden for FTP-kontoer.",

    'b_sb_desktop' => "Oversikt over hovedfunksjonene til Presence Builder.",
    'b_sb_users' => "Behandle brukerkontoer registrert i Presence Builder.",
    'b_sb_sites' => "Legg til og behandle diverse typer av Presence Builder-områder.",
    'b_sb_server' => "Presence Builder administrasjon.",
    'b_sb_logs' => "Se oppføringer for system- og sikkerhetslogger for Presence Builder.",

    'dns_recursion' => "DNS rekursjon administrasjon.",

    'subdom_hst_type_sel' => "Velg hostingtypen du skal sette opp for underdomenet.",

    'i_wu_open_help' => "Klikk for å åpne webbrukersiden i nettleseren.",

    'i_i_client_off_expired' => "Gyldighetsperioden for denne kunden er utløpt.",

    'i_antivirus_turn_install' => 'Antivirus er ikke installert eller ordentlig konfigurert.',

    'b_ftp_users_no_permission' => "Du ikke har tillatelse til å behandle ekstra FTP-konto.",

    // Plesk 8 keys

    'b_search' => "Søk etter kunder, domener og epostkontoer.",

    // services management
    'b_service_showall' => 'Vis alle tjenester.',
    'b_service_hideall' => "Skjul alle tjenester.",
    'b_service_start' => "Start valgte tjenester.",
    'b_service_stop' => "Stopp valgte tjenester.",
    'b_service_restart' => "Start valgte tjenester om igjen.",
    'b_service_disable' => "Deaktiver valgte tjenester.",
    'b_service_manual' => "Velg manuell oppstartstype for valgte tjenester.",
    'b_service_auto' => "Velg automatisk oppstartstype for valgte tjenester.",
    'i_serv_group_on' => 'Alle tjenester i gruppen kjører.',
    'i_serv_group_none' => 'Noen av tjenestene i gruppen er deaktivert eller stoppet.',
    'i_serv_group_off' => 'Alle tjenester i gruppen er deaktivert eller stoppet.',
    'i_serv_key_disabled' => 'Tjeneste deaktivert.',

    // php4v5
    'php' => "Vis og endre PHP-innstillinger for gjeldende virtuell mappe.",
    'php_changeversion' => "PHP-konfigurasjon for gjeldende mappe.",
    'php_dom' => "Endre PHP-innstillinger for domenet.",
    'php_subdom' => "Endre PHP-innstillinger for underdomene.",
    'php_changeversion_dom' => "PHP-konfigurasjon av domenet.",
    'php_changeversion_subdom' => "PHP-konfigurasjon for underdomene.",

    // mass mail
    'b_new_mass_mail_template' => 'Legg til meldingsmal for masseutsendelse av e-post',
    'b_massmail_send' => "Send e-post til valgte mottaker",

    // Other
    'b_additional_key_is_install' => 'Installer ekstranøkkel.',
    'i_domain_sitebuilder_disabled' => "Støtte for Presence Builder er deaktivert for dette domenet.",
    'i_subdomain_sitebuilder_disabled' => "Presence Builder-støtte er deaktivert for dette underdomene.",
    'i_subdomain_sitebuilder_wizard' => "Gå til Presence Builder Wizard for dette underdomenet.",
    'i_domain_sitebuilder_wizard' => "Gå til veiviser for Presence Builder for dette domenet.",
    'sitebuilder_page' => 'Du er kjører nå i et Presence Builder-vindu. Se dokumentasjonen for Presence Builder for mer informasjon.',
    'removeFpseUsers' => 'Velg avmerkingsboks for å bekrefte fjerning, og klikk OK for å fjerne. Klikk Avbryt for å avbryte borttagningen.',
    'b_insert' => 'Klikk for å sette inn data fra valgte-mal inn din masseutsendelse av e-post melding',
    'i_spamfilter_turn_install' => 'Spamfiltrering er ikke installert.',

    // help desk

    // 8.2

    // other

    'b_db_preferences' => 'Endre tilkoblingsparametere for database',
    'b_disabled_hosting' => 'Denne funksjonen er ikke tilgjengelig fordi fysisk hosting ikke er konfigurert',
    'net_apps' => 'Administrer ASP.NET 1.1 webprogrammer',
    'site_apps' => "Administrer standard webprogrammer",

    'b_default_cert' => 'Bruk valgt sertifikat for sikker tilkobling til nytt vertsbasert nettsted.',
    'b_setup_cp' => 'Bruk valgte sertifikat for sikrer tilkobling til Plesk',
    'b_to_actionlog' => 'Gå tilbake til handlingslogg',

    // 8.3

    'additional_key_update' => 'Status for oppdatering eller innhenting av ekstranøkkel',
    'admin_alias_password_update' => 'Bekreft passordendringen',
    'removeTasks' => "Bekreft fjerningen av valgte oppgaver og klikk OK",

    'b_license_key_remove' => 'Klikk for å fjerne lisensnøkkelen.',
    'fi-attach' => 'Angi global konto som du vil koble til.',
    'fi-detach' => 'Bekreft frakobling av den gjeldende lokale konto fra en global konto og klikk for å koble fra',
    'fi-update' => 'Oppdater globale kontoinnstillinger.',

    // 8.4
    // RESELLERS
    'b_resellers' => 'Administrer forhandlerkontoer',
    'i_reseller_on' => "Denne brukerkontoen er aktiv.",
    'i_reseller_off_by_parent' => "Denne brukerkontoen ble suspendert av tjenesteleverandøren.",
    'i_reseller_off_by_expired' => "Abonnementsperioden for brukerkontoen er utløpt.",
    'i_reseller_off_backup_restore' => "Denne brukerkontoen ble midlertidig deaktivert for sikkerhetskopiering eller gjenoppretting av data.",
    'i_reseller_ok' => "Forhandlerens ressursbruk er innenfor grensene.",
    'i_reseller_cp_access_on' => "Tilgang til Plesk er tillatt for forhandleren.",
    'i_reseller_cp_access_off' => "Tilgang til Plesk er ikke tillatt for forhandleren.",
    'i_click_to_reseller_cp_access_on_off' => "Klikk for å tillate eller forby forhandleren tilgang til Plesk.",

    // CLIENTS (upgraded for resellers)

    // 'upgradeclients__submit_update' => 'Click',
    'b_upgradeClients__cancel_upgrade' => 'Forkaste hvilken som helst endring og gå tilbake til forrige side.',
    'b_upgradeClients__submit_upgrade' => 'Klikk for å konvertere kvalifiserte kundekontoer til forhandlerkontoer.',
    'b_upgradeDomainUser__cancel_upgrade' => 'Forkaste hvilken som helst endring og gå tilbake til forrige side.',
    'b_upgradeDomainUser__submit_upgrade' => 'Klikk for å konvertere kvalifiserte domeneadministratorkontoer til kundekontoer.',

    //APS Catalog
    'b_hide_updates' => "Skjul oppdateringer.",
    'b_show_updates' => "Vis oppdateringer.",
    'b_add_to_vault' => "Legg de valgte programmene til Programhvelvet.",

    // new and unsorted
    'b_to_server_interface' => "Gå tilbake til listen over tilgjengelige skall.",
    'b_skin_edit' => "Rediger beskrivelse av skin.",
    'b_to_phosting_setup' => "Gå tilbake til hostinginnstillinger.",
    // Hosting setup redesign
    'b_dom_hosting_update' => "Lagre innstillinger for hosting.",
    'b_downgradeResellers__submit_downgrade' => "Klikk for å fullføre denne operasjonen.",
    'b_rs_pool_add' => "Tildel IP-adresser til forhandleren.",
    'b_cl_pool_add' => "Tilordne IP adresser til klienten.",
    'b_ippoolManager__no_available_ips' => "Det finnes ingen ledige IP adresser i IP utvalget.",
    'b_ip_already_added_to_all_clients' => "Denne IP adressen er allerede i IP utvalgene for alle brukere.",

    // SERVER/SETTINGS
    'b_change_hostname_conhelp' => 'Endre vertsnavn på server.',
    'b_setup_firewall_conhelp' => 'Sett opp brannmur for å beskytte serveren.',
    'b_setup_firewall_none_available_conhelp' => 'Brannvegg funksjonalitet er ikke tilgjengelig; brannvegg er ikke installert.',
    'b_manage_firewall_rules_conhelp' => 'Opprett, editer og fjern brannvegg regler.',
    'b_manage_firewall_rules_none_available_conhelp' => 'Brannvegg funksjonalitet er ikke tilgjengelig; brannvegg er ikke installert.',
    'b_select_dns_server_conhelp' => 'Velg DNS-serverprogram som skal brukes av serveren og behandles av Plesk.',
    'b_select_dns_server_none_available_conhelp' => 'Ingen andre DNS-servere er tilgjengelige.',
    'b_soa_records_template_conhelp' => 'Konfigurer SOA-oppførelser som vil bli brukt som mal under opprettelse av DNS-sone for domener.',
    'b_dns_recursion_conhelp' => 'Konfigurer innstillinger for DNS-rekursjon som skal brukes som mal når du oppretter DNS-sone for domener.',
    'b_restrict_creation_of_subzones_conhelp' => "Begrens opprettelsen av DNS undersoner i andre brukeres DNS supersoner",
    'b_select_mailserver_conhelp' => 'Velg e-postserverprogram som skal brukes av serveren og behandles av Plesk.',
    'b_select_mailserver_none_available_conhelp' => 'Ingen andre e-postserver er tilgjengelige.',
    'b_select_antivirus_conhelp' => 'Velg antivirusprogramvare som skal brukes av serveren og behandles av Plesk.',
    'b_select_antivirus_none_available_conhelp' => 'Ingen andre antivirusprogrammer er tilgjengelige.',
    'b_virus_protection_settings_conhelp' => 'Konfigurere globale virusbeskyttelsesinnstillinger.',
    'b_select_spamfilter_conhelp' => 'Velg spamfiltrering programvare som skal brukes av serveren og behandles av Plesk.',
    'b_select_spamfilter_none_available_conhelp' => 'Ingen andre spamfiltreringsprogrammer er tilgjengelige.',
    'b_select_webmail_conhelp' => 'Velg webmailprogram som skal være tilgjengelig for e-postbrukere.',
    'b_select_webmail_none_available_conhelp' => 'Ingen andre epostprogrammer er tilgjengelige.',
    'b_server_statistics_settings_conhelp' => 'Velg hva som skal tas med i beregningen av globale statistikker.',
    'b_select_ssl_certificate_conhelp' => 'Valgt SSL/TLS-sertifikat skal brukes for å beskytte domenet ditt.',
    'b_select_ssl_certificate_none_available_conhelp' => 'Det kreves webhosting for å få tilgang til denne funksjonen.',
    'b_select_web_statistics_conhelp' => 'Velg programmer for webstatistikk som skal være tilgjengelige for domeneeiere.',
    'b_select_web_statistics_none_available_conhelp' => 'Ingen andre programmer for webstatistikk er tilgjengelige.',
    'b_interface_management_conhelp' => 'Sett opp diverse Plesk grensesnittalternativer.',
    'b_setup_watchdog_conhelp' => 'Sett opp Watchdog serverovervåkingsmodulen.',
    'b_setup_watchdog_none_available_conhelp' => 'Watchdog modulen er ikke installert.',
    'b_setup_vpn_conhelp' => 'Sett opp VPN tilgang på serveren.',
    'b_setup_vpn_none_available_conhelp' => 'VPN tilgang utvidelse er ikke installert.',
    'b_setup_samba_conhelp' => 'Sett opp samba tilgang på serveren.',
    'b_setup_samba_none_available_conhelp' => 'Samba tilgang utvidelse er ikke installert.',

    // DOMAIN/SETTINGS
    'b_account_settings_conhelp' => 'Vis og endre dine kontoinnstillinger.',
    'b_dns_soa_records_conhelp' => 'Vis og endre DNS SOA-oppføringer for domenet ditt.',
    'b_task_scheduler_settings_conhelp' => 'Sett opp oppgaveplanlegger for domenet ditt.',
    'b_task_scheduler_settings_none_available_conhelp' => 'Det kreves webhosting for å få tilgang til denne funksjonen.',
    'b_web_users_scripting_conhelp' => 'Tillat eller forby webbruker å bruke skript.',
    'b_web_statistics_conhelp' => 'Vis besøkstatistikk for domenet ditt.',
    'b_log_rotation_settings_conhelp' => 'Sett opp rotasjon av logger på domenet ditt.',

    // navbar
    'b_mailnames' => 'Gå til i listen over e-postkonto.',
    'b_applications' => 'Gå til listen over webprogrammer.',
    'b_settings' => 'Konfigurere en mengde forskjellige av innstillinger.',

    // templates
    'i_tmpl__shared_template' => 'Malen ble laget av hostingleverandøren. Den kan brukes av deg, siden hostingleverandøren deler den.',
    'i_tmpl__owned_template' => 'Denne malen ble laget av deg. Den kan brukes av deg og dine brukere, hvis du tillater det.',

    'b_load' => 'Last inn melding fra tidligere lagret mal.',

    'b_sh_ip_add' => 'Legg til IP-adresse i listen over delt IP-adresser',
    'b_sh_ip_del' => 'Fjern IP-adresse i liste over delt IP-adresser',
];