<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Pokud je váš web hostován na vyhrazené IP adrese (nesdílené s ostatními uživateli nebo weby), můžete na webu vytvořit adresář, kam mohou ostatní uživatelé prostřednictvím FTP anonymně nahrávat soubory nebo je odtamtud stahovat. Jakmile se zapne anonymní FTP, uživatelé se budou moci přihlašovat do adresáře na adrese například ftp://ftp.your-domain.com prostřednictvím "anonymního" přihlašovacího jména a libovolného hesla.',
    'anonymous-ftp.displayLogin' => 'Zobrazit přihlašovací zprávu',
    'anonymous-ftp.loginText' => 'Text zprávy',
    'anonymous-ftp.incomingDir' => 'Povolit přenos do příchozího adresáře',
    'anonymous-ftp.incomingSubDir' => 'Povolit vytvoření adresářů v příchozím adresáři',
    'anonymous-ftp.incomingReadable' => 'Povolit stahování z příchozího adresáře',
    'anonymous-ftp.quota' => 'Omezit prostor na disku v příchozím adresáři',
    'anonymous-ftp.maxConnections' => 'Limit počtu současných připojení',
    'anonymous-ftp.bandwidth' => 'Omezit šířku pásma stahování pro tuto virtuální FTP doménu',
    'anonymous-ftp.unlimited' => 'Neomezeno',

    'aps.catalog.loading' => 'Načítání...',
    'aps.catalog.searchName' => 'Aplikace',
    'aps.catalog.searchVendor' => 'Dodavatel',
    'aps.catalog.searchPackager' => 'Balíčkovač',
    'aps.catalog.searchLicenseType' => 'Typ licence',
    'aps.catalog.searchLicenseTypeAny' => 'Jakýkoliv',
    'aps.catalog.searchLicenseTypeFreeware' => 'Zdarma',
    'aps.catalog.searchLicenseTypeCommercial' => 'Komerční',
    'aps.catalog.showSearch' => 'Zobrazit hledání',
    'aps.catalog.hideSearch' => 'Skrýt hledání',
    'aps.catalog.buttonSearch' => 'Hledat',
    'aps.catalog.buttonResetSearch' => 'Resetovat hledání',
    'aps.catalog.showCategories' => 'Vybrat kategorii níže nebo vyhledat aplikace prostřednictvím vyhledávacího pole',
    'aps.catalog.searchResults' => 'Výsledky hledání',
    'aps.catalog.buttonInstall' => 'Instalovat',
    'aps.catalog.buttonInstallTooltip' => 'Rychle nainstalovat nejnovější verzi aplikace s optimálními výchozími parametry.',
    'aps.catalog.buttonAdvancedInstall' => 'Instalovat (vlastní)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Instalovat nejnovější verzi aplikace, s přizpůsobením všech parametrů.',
    'aps.catalog.buttonInstallOldVersion' => 'Instalovat verzi',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Instalovat vybranou verzi aplikace, s přizpůsobením všech parametrů.',
    'aps.catalog.buttonInstallDescription' => 'Aplikaci nainstalujte na web, pokud již máte aktivační kód nebo si ji chcete jenom vyzkoušet.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Nainstalovat tuto bezplatnou aplikaci na web.',
    'aps.catalog.version' => 'Verze',
    'aps.catalog.moreVersions' => 'Další verze',
    'aps.catalog.release' => 'Uvolnit',
    'aps.catalog.overview' => 'Přehled',
    'aps.catalog.noApplicationsInCategory' => 'V této kategorii nejsou k dispozici žádné aplikace. Vybrat jinou kategorii.',
    'aps.catalog.noCategoriesSelected' => 'Vybrat kategorii a procházet všechny aplikace dostupné v této kategorii.',
    'aps.catalog.noSearchResults' => 'Vaše hledání neodpovídá žádným aplikacím.',
    'aps.catalog.connectionFailed' => 'Připojení ke katalogu aplikací se nezdařilo. %%retryLink%%.',
    'aps.catalog.retry' => 'Zkusit znovu',
    'aps.catalog.categoriesError' => 'Seznam kategorií nelze momentálně načíst.',
    'aps.catalog.applicationsError' => 'Seznam aplikací nelze momentálně načíst.',
    'aps.catalog.detailsError' => 'Podrobnosti o aplikaci nelze momentálně načíst.',
    'aps.catalog.searchError' => 'Výsledky vyhledávání nelze momentálně načíst.',
    'aps.catalog.changelogEntry' => 'v%%version%% (vydání %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Historie změn',
    'aps.catalog.officialApplicationSite' => 'Informace o dodavateli',
    'aps.catalog.returnToCategories' => '<< Zpět na seznam aplikací',
    'aps.catalog.buttonUninstall' => 'Odebrat',
    'aps.catalog.gotoHome' => 'Domů',
    'aps.catalog.all' => 'Vše',
    'aps.catalog.buttonDetails' => 'Další informace',
    'aps.catalog.buttonBuy' => 'Koupit',
    'aps.catalog.buttonBuyTooltip' => 'Zakoupit aplikaci',
    'aps.catalog.buttonBuyDescription' => 'Navštivte náš obchod a zakupte si aktivační kód pro aplikaci.',
    'aps.catalog.buttonDownload' => 'Stáhnout',
    'aps.catalog.buttonDownloadDescription' => 'Stáhněte si aplikaci, pokud již máte aktivační kód nebo si ji chcete jenom vyzkoušet.',
    'aps.catalog.marketplaceMoreInfo' => 'Další informace získáte na %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'webové stránky dodavatele aplikace',

    'aps.configure.installedAt' => "Nainstalováno dne",
    'aps.configure.otherSettings' => "Ostatní",
    'aps.configure.globalSettings' => 'Nastavení balíčku',
    'aps.configure.passwordConfirmation' => 'Potvrdit heslo',
    'aps.configure.databaseParams' => 'Parametry databáze',
    'aps.configure.noInstallationUrlAvailable' => 'Žádná (externí aplikace)',
    'aps.configure.updateSettingsSection' => 'Aktualizovat nastavení',
    'aps.configure.forceUpdates' => 'Automaticky aktualizovat tuto aplikaci, až budou dostupné aktualizace',
    'aps.configure.forceUpdatesHint' => 'Aplikace přijme automatické aktualizace na vyšší verzi. Varování: tuto možnost použijte uvážlivě, protože aktualizace mohou významně ovlivnit funkčnost aplikace. Například rozšíření aplikace může zastavit činnost jiné verze aplikace.',

    'aps.install.showAllSettings' => 'Zobrazit všechna nastavení',
    'aps.install.showLessSettings' => 'Zobrazit minimální nastavení',
    'aps.install.install' => 'Instalovat',
    'aps.install.otherSettings' => 'Další nastavení',
    'aps.install.globalSettings' => 'Nastavení balíčku',
    'aps.install.passwordConfirmation' => 'Potvrdit heslo',
    'aps.install.provisionsSectionLabel' => 'Instalační cesta',
    'aps.install.context' => 'Zadejte umístění, kam se má tato webová aplikace nainstalovat',
    'aps.install.registerAsWebmailSection' => 'Registrace webového rozhraní pošty',
    'aps.install.registerAsWebmailDescription' => "Tuto možnost vyberte, pokud je aplikace klientem webového rozhraní pošty. Díky tomu se aplikace objeví mezi dostupnými službami webového rozhraní pošty v Nastavení pošty předplacených služeb a plánů služeb. Správce může nakonfigurovat adresu URL pro veřejný přístup k webovému rozhraní pošty v nabídce Správa serveru> Nastavení> Webové rozhraní pošty.",
    'aps.install.registerAsWebmailLabel' => 'Registrovat jako službu webového rozhraní pošty',
    'aps.install.addItem' => 'Přidat',
    'aps.install.removeItem' => 'Odebrat',
    'aps.install.updateSettingsSection' => 'Aktualizovat nastavení',
    'aps.install.forceUpdates' => 'Automaticky aktualizovat tuto aplikaci, až budou dostupné aktualizace',
    'aps.install.forceUpdatesHint' => 'Aplikace přijme automatické aktualizace na vyšší verzi. Varování: tuto možnost použijte uvážlivě, protože aktualizace mohou významně ovlivnit funkčnost aplikace. Například rozšíření aplikace může zastavit činnost jiné verze aplikace.',

    'aps.invalid-requirements.requirementsLegend' => 'Požadavky',
    'aps.invalid-requirements.domainLegend' => 'Web',
    'aps.invalid-requirements.context' => 'Vybrat jiný web',
    'aps.invalid-requirements.backToApplicationList' => 'Zpět do seznamu aplikací',

    'aps.license.title' => 'Instalace %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Chcete-li nainstalovat tuto aplikaci, musíte si přečíst licenční smlouvu s koncovým uživatelem a souhlasit s jejími podmínkami.',
    'aps.license.licenseAgree' => 'Souhlasím s podmínkami licenční smlouvy',

    'aps.services-list-customization.settings' => 'Nastavení',

    'asp-dot-net.change-version.title' => 'Výběr verze ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'Verze rozhraní ASP.NET',
    'asp-dot-net.change-version.success' => 'Verze ASP.NET se změnila.',

    'asp-dot-net.settings.casSettingsSection' => "Zabezpečení přístupu ke kódu",
    'asp-dot-net.settings.clientScriptsSection' => "Nastavení knihovny skriptů",
    'asp-dot-net.settings.connStringsSection' => "Správce řetězců připojení",
    'asp-dot-net.settings.customErrorsSection' => "Nastavení vlastních chyb",
    'asp-dot-net.settings.frameworkVersionSection' => "Verze Frameworku",
    'asp-dot-net.settings.globalizationSection' => "Nastavení globalizace",
    'asp-dot-net.settings.otherSection' => "Nastavení relace",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Kompilace a ladění",
    'asp-dot-net.settings.authMode' => "Režim ověřování",
    'asp-dot-net.settings.connStrings' => "Připojovací řetězce",
    'asp-dot-net.settings.connStringsInvalid' => "Některá pole jsou prázdná nebo obsahují nesprávnou hodnotu.",
    'asp-dot-net.settings.connStringName' => "Jméno",
    'asp-dot-net.settings.connStringValue' => "Parametry připojení",
    'asp-dot-net.settings.connStringsDescription' => "Název / parametry připojení",
    'asp-dot-net.settings.culture' => "Kultura",
    'asp-dot-net.settings.customErrMode' => "Režim vlastních chyb",
    'asp-dot-net.settings.customErrorRedirect' => "URL adresa přesměrování",
    'asp-dot-net.settings.customErrorStatus' => "Stavový kód",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Stavový kód musí být celé číslo.",
    'asp-dot-net.settings.customErrors' => "Vlastní chyby",
    'asp-dot-net.settings.customErrorsDescription' => "Stavový kód / adresa URL pro přesměrování",
    'asp-dot-net.settings.customErrorsInvalid' => "Některá pole jsou prázdná nebo obsahují nesprávnou hodnotu.",
    'asp-dot-net.settings.debugMode' => "Zapnout ladění",
    'asp-dot-net.settings.defLanguage' => "Výchozí jazyk webové stránky",
    'asp-dot-net.settings.tempDirectory' => "Dočasná složka",
    'asp-dot-net.settings.fileEnc' => "Kódování souboru",
    'asp-dot-net.settings.fileEncInvalid' => "Hodnota zadaná pro parametr Kódování souboru není platná.",
    'asp-dot-net.settings.pathToLib' => "Cesta ke knihovně skriptů Microsoft.",
    'asp-dot-net.settings.pathToLibInstall' => "Instalovat",
    'asp-dot-net.settings.reqEnc' => "Kódování požadavku",
    'asp-dot-net.settings.reqEncInvalid' => "Hodnota zadaná pro parametr Kódování požadavku není platná.",
    'asp-dot-net.settings.resEnc' => "Kódování odpovědi",
    'asp-dot-net.settings.resEncInvalid' => "Hodnota zadaná pro parametr Kódování odpovědi není platná.",
    'asp-dot-net.settings.sessTimeout' => "Časový limit relace (minuty)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Hodnota zadaná pro parametr Časový limit relace je neplatná. Zadat kladné celé číslo menší nebo rovno %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Název řetězce připojení se již používá.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Stavový kód musí být v rozmezí 100 až 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Stavový kód se již používá.",
    'asp-dot-net.settings.trustLevel' => "Úroveň důvěryhodnosti kódu (Code Access Security)",
    'asp-dot-net.settings.uiCulture' => "Kultura uživatelského rozhraní",
    'asp-dot-net.settings.version' => "Verze",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Povolit potlačení úrovně důvěryhodnosti CAS na webu',
    'asp-dot-net.settings.updateSuccess' => 'Aktualizace proběhla',

    'database.clone.formDescription' => 'Kopírovat obsah databáze do nové nebo stávající databáze. Při kopírování do existující databáze se tabulky zdrojové databáze přidají do seznamu tabulek v cílové databázi. Varování: pokud se tabulková jména shodují, tabulka ze zdroje nahradí tabulku v cíli.',
    'database.clone.copyData' => 'Vytvořit úplnou kopii',
    'database.clone.copyDataHint' => 'V případě výběru bude zkopírována celá databáze (včetně struktury a data). V případě vymazání bude zkopírována pouze struktura tabulek.',
    'database.clone.server' => 'Server cílové databáze',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Jiný…',
    'database.clone.database' => 'Cílová databáze',
    'database.clone.newDatabase' => 'Vytvořit databázi s názvem',
    'database.clone.existingDatabase' => 'Kopírovat do existující databáze',
    'database.clone.externalDbHost' => 'Název hostitele nebo IP adresa',
    'database.clone.externalDbLogin' => 'Uživatelské jméno',
    'database.clone.externalDbPassword' => 'Heslo',
    'database.clone.subscription' => 'Cílová předplacená služba',
    'database.clone.subscription_powerUser' => 'Cílový webový prostor',
    'database.clone.cloneInProgress' => 'Klonování databáze %%source%% na databázi %%destination%%. O průběhu budete informování e-mailem (%%email%%).',
    'database.clone.unableToClone' => 'Nelze zkopírovat databázi: „%%source%%“.',
    'database.clone.unableToCreateExternalDatabase' => 'Nelze vytvořit databázi „%%destination%%“ na zadaném serveru.',
    'database.clone.databaseCloned' => 'Databáze „%%source%%“ byla zkopírována.',
    'database.clone.emailSubjSuccess' => 'Databáze "%%sourceDatabase%%" byla zkopírována.',
    'database.clone.emailSubjFailure' => 'Kopírování databáze "%%sourceDatabase%%" se nezdařilo.',
    'database.clone.emailBodySuccess' => 'Databáze "%%sourceDatabase%%" (%%sourceHost%%) byla zkopírována do databáze "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Databázi "%%sourceDatabase%%" (%%sourceHost%%) nelze zkopírovat do databáze "%%destDatabase%%" (%%destHost%%). Kopírování se nezdařilo.',
    'database.clone.localServer' => 'místní server',

    'database.repair-orphaned.formDescription' => 'Uživatel osaměl po procesu obnovení. Zadejte heslo pro tohoto uživatele, aby se problém vyřešil. Pokud má být tento uživatel uživatelem systému bez hesla, spusťte opravný nástroj s prázdným polem pro heslo.',
    'database.repair-orphaned.login' => 'Uživatelské jméno databáze',
    'database.repair-orphaned.pass' => 'Heslo',
    'database.repair-orphaned.pass2' => 'Potvrdit heslo',
    'database.repair-orphaned.users' => 'Někteří uživatelé vyžadují vaši pozornost. Existuje několik osamocených uživatelů, které je nutno opravit, aby pracovali správně.',
    'database.repair-orphaned.orphaned' => 'Uživatel je osamocený. %%gui begin:link%%Repair now%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Opravit',

    'database.repair.fixSelected' => 'Opravit vybrané',
    'database.repair.fix' => 'Opravit',

    'database.user.password' => 'Heslo',
    'database.user.passwordConfirmation' => 'Potvrdit heslo',
    'database.user.server' => 'Databázový server',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Databáze',
    'database.user.anyDatabase' => 'Každý',
    'database.user.dataAccess' => 'Přístup k datům',
    'database.user.structureAccess' => 'Přístup ke struktuře',
    'database.user.globalAccess' => 'Globální oprávnění',
    'database.user.globalAccessHint' => 'Globální oprávnění pracuje pro všechny databáze v rámci tohoto hostitelského účtu.',
    'database.user.aclRadio' => 'Řízení přístupu',
    'database.user.aclLocalhost' => 'Povolit pouze místní připojení',
    'database.user.aclAny' => 'Povolit vzdálené připojení z libovolného hostitele',
    'database.user.aclCustom' => 'Povolit vzdálené připojení od',
    'database.user.aclExample' => "thomas.loc.gov %.loc.gov x.y.% 144.155.166.177 144.155.166.% 144.155.166.0/255.255.255.0 Zadané hostitelé mají povolen přístup do databáze jménem tohoto uživatele.",
    'database.user.remoteAccess' => 'Vzdálený přístup',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nUvedené IP adresy mají povolený přístup do serveru databáze prostřednictvím pravidla ve firewallu. Změny, které v tomto seznamu provedete, budou předmoderovány vaším poskytovatelem hostingu.",
    'database.user.example' => "Například: %%example%%",
    'database.user.denied' => 'Použít pravidla brány firewall v systému',
    'database.user.allowed' => 'Povolit vzdálené připojení od',
    'database.user.default' => 'Použít tato uživatelská oprávnění standardně pro přístup %%webadmin%%',
    'database.user.remoteAccessHint' => 'Obraťte se na svého poskytovatele hostingu a ujistěte se, že možnost, kterou jste zadali, bude splňovat aktuální pravidla brány firewall pro příchozí přístup k MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Správce webu',
    'database.user.role' => 'Role',
    'database.user.roleReadWrite' => 'Čtení a zápis',
    'database.user.roleWriteOnly' => 'Jen pro zápis',
    'database.user.roleReadOnly' => 'Jen pro čtení',
    'database.user.roleCustom' => 'Vlastní',

    'database.generalSection' => 'Obecné',
    'database.name' => 'Název databáze',
    'database.server' => 'Databázový server',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Související web',
    'database.noDomainRelations' => 'Žádné související weby',
    'database.userSection' => 'Uživatelé',
    'database.userSectionDescription' => 'Vytvořit výchozího uživatele databáze. Plesk má přístup do databáze jménem tohoto uživatele. Pokud nejsou k databázi přiřazeni žádní uživatelé, databáze není přístupná.',
    'database.createUser' => 'Vytvořit uživatele databáze',
    'database.username' => 'Jméno uživatele databáze',
    'database.password' => 'Heslo',
    'database.passwordConfirmation' => 'Potvrdit heslo',
    'database.allDbAccess' => 'Uživatel má přístup do všech databází v rámci vybraného předplatného',
    'database.aclRadio' => 'Řízení přístupu',
    'database.aclLocalhost' => 'Povolit pouze místní připojení',
    'database.aclAny' => 'Povolit vzdálené připojení z libovolného hostitele',
    'database.aclCustom' => 'Povolit vzdálené připojení od',
    'database.aclExample' => "thomas.loc.gov %.loc.gov x.y.% 144.155.166.177 144.155.166.% 144.155.166.0/255.255.255.0 Zadané hostitelé mají povolen přístup do databáze jménem tohoto uživatele.",
    'database.remoteAccess' => 'Vzdálený přístup',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nUvedené IP adresy mají povolený přístup do serveru databáze prostřednictvím pravidla ve firewallu. Změny, které v tomto seznamu provedete, budou předmoderovány vaším poskytovatelem hostingu.",
    'database.example' => "Například: %%example%%",
    'database.denied' => 'Použít pravidla brány firewall v systému',
    'database.allowed' => 'Povolit vzdálené připojení od',

    'deployment-section.deploymentDisabledHint' => 'Nahrát soubory z úložiště systému Git',
    'deployment-section.deploymentEnabledHint' => 'Povolit podporu systému Git',
    'deployment-section.deploymentSectionLegend' => 'Kopírování vašich souborů na hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'Pokud ponecháte podporu systému Git vypnutou, kořenové adresáře (kořenový adresář webu/aplikace a kořen dokumentu) se vytvoří prázdný a v prohlížeči se zobrazí výchozí stránka. K nahrání souborů vašeho webu do kořene dokumentu budete potřebovat službu FTP nebo Správce souborů. Další možnost: zapněte systém Git nyní nebo později (v nabídce Weby a domény) a nahrajte soubory z úložiště systému Git.',

    'dns-zone.add-acl-record.description' => 'Přidat IP adresu serveru DNS, který má povoleno přijmout kopii zóny DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'IP adresa',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP adresa/maska',

    'dns-zone.record.add-title' => "Přidat záznamu o prostředku do šablony zóny.",
    'dns-zone.record.add-ns-title' => "Přidat názvový server",
    'dns-zone.record.edit-title' => "Upravit záznam o prostředku",
    'dns-zone.record.edit-success' => "Záznam DNS aktualizován.",
    'dns-zone.record.add-success' => "Záznam DNS vytvořen.",
    'dns-zone.record.type' => "Typ záznamu",
    'dns-zone.record.domainName' => "Název domény",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Jmenný server",
    'dns-zone.record.optionOff' => 'Vypnout',
    'dns-zone.record.optionOn' => 'Zapnout',
    'dns-zone.record.protocol' => "Protokol",
    'dns-zone.record.priority' => "Priorita",
    'dns-zone.record.priorityLow' => "malá (%%priority%%)",
    'dns-zone.record.priorityHigh' => "velmi vysoká (%%priority%%)",
    'dns-zone.record.weightLow' => "nízká (%%weight%%)",
    'dns-zone.record.weightHigh' => "velmi vysoká (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP adresa",
    'dns-zone.record.ipAddressDescription' => "Například 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Například, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Adresa IPv6",
    'dns-zone.record.ipAddressV6Description' => "Například 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Například, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Například 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Například, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Například 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Kanonický název",
    'dns-zone.record.mailDomain' => "Poštovní doména",
    'dns-zone.record.mxServer' => "Server Mail exchange",
    'dns-zone.record.mxServerPriority' => "Specifikujte prioritu MX serveru",
    'dns-zone.record.txtRecord' => "Záznam TXT",
    'dns-zone.record.txtRecordString' => "Zadat řetězec záznamu",
    'dns-zone.record.txtSpfSyntax' => "Záznam SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Pro záznam TXT byly zadány nesprávné hodnoty.",
    'dns-zone.record.quotedTxtRecord' => "Hodnota záznamu TXT musí být jeden samostatný řetězec bez uvozovek.",
    'dns-zone.record.dsRecord' => "Záznam DS",
    'dns-zone.record.dsRecordDescription' => "Například 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "Pro záznam DS byla zadána nesprávná hodnota.",
    'dns-zone.record.serviceName' => "Název služby",
    'dns-zone.record.serviceNameDescription' => 'Například SIP (bez znaku podtržítka).',
    'dns-zone.record.protocolNameDescription' => 'Například tcp (bez znaku podtržítka).',
    'dns-zone.record.portDescription' => 'Například 25 (bez znaku podtržítka).',
    'dns-zone.record.srvWeight' => "Relativní hmotnost pro záznamy se stejnou prioritou",
    'dns-zone.record.targetHost' => "Cílový hostitel",
    'dns-zone.record.targetHostDescription' => "Například priklad.com",
    'dns-zone.record.targetPort' => "Cílový port",
    'dns-zone.record.targetPortDescription' => 'Například 8443.',
    'dns-zone.record.retrieveDataError' => "Data záznamu nebyla nalezena.",
    'dns-zone.record.unknownTypeError' => "Typ záznamu DNS je neznámý.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Jestliže existuje jiný záznam MX, nelze nastavit záznam NULL MX.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Jestliže existuje záznam NULL MX, nelze nastavit záznam non-NULL MX.',
    'dns-zone.record.masterShouldBeRemote' => "Musíte mít dva různé autoritativní názvové servery na samostatných hostitelích.",
    'dns-zone.record.caaTag' => "Značka",
    'dns-zone.record.caaRecord' => "Hodnota",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protokol',
    'dns-zone.record.tlsaUsage' => 'Využití',
    'dns-zone.record.tlsaSelector' => 'Nástroj pro výběr',
    'dns-zone.record.tlsaMatching' => 'Typ spojování',
    'dns-zone.record.tlsaCertData' => 'Data pro přiřazování certifikátu',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Podrobnosti najdete zde: %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, sekce 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, sekce 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, sekce 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, sekce 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Například example.com. Prázdná hodnota znamená, že host je stejný jako název domény.',
    'dns-zone.record.httpsProtocols' => 'Protokoly',
    'dns-zone.record.httpsProtocolsDescription' => 'Čárkami oddělený seznam protokolů, které cíl podporuje. Například h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Vynutit používání jen uvedených protokolů. Seznam protokolů výš nesmí být prázdný.',
    'dns-zone.record.httpsIpv4hint' => 'Nápověda pro IPv4 adresy',
    'dns-zone.record.httpsIpv4hintDescription' => 'Čárkami oddělený seznam IPv4 adres, které může klient použít pro dosažení služby.',
    'dns-zone.record.httpsIpv6hint' => 'Nápověda pro IPv6 adresy',
    'dns-zone.record.httpsIpv6hintDescription' => 'Čárkami oddělený seznam IPv6 adres, které může klient použít pro dosažení služby.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Sekundy",
    'dns-zone.record.invalidValue' => 'Hodnota je neplatná. Může být v rozmezí od 1 sekundy do 2147483647 sekund.',
    'dns-zone.record.ttlDefaultValue' => 'Výchozí hodnota: %%value%% sekund',
    'dns-zone.record.invalidTTL' => 'Zadaná hodnota TTL je neplatná.',
    'dns-zone.record.invalidIpAddress' => 'Zadaná adresa IP je neplatná.',
    'dns-zone.record.invalidIpMaskPair' => 'Zadaný pár adresy IP / masky sítě je neplatný.',
    'dns-zone.record.invalidCName' => 'Zadaný oficiální název je neplatný.',
    'dns-zone.record.invalidPort' => 'Zadaný port je neplatný.',
    'dns-zone.record.invalidTLSACertData' => 'Uvedená data pro přiřazování certifikátu jsou neplatná.',
    'dns-zone.record.invalidTLSAProtocol' => 'Zadaný protokol je neplatný.',
    'dns-zone.record.invalidTLSAUsage' => 'Uvedené využití je neplatné.',
    'dns-zone.record.invalidTLSASelector' => 'Uvedený nástroj pro výběr je neplatný.',
    'dns-zone.record.invalidTLSAMatching' => 'Uvedený typ spojování je neplatný.',

    'dns-zone.restore-default.formHint' => "Zde můžete obnovit původní konfiguraci zóny v souladu s výchozím nastavením šablony DNS použitým na serveru. Vyberte IP adresy, které se použijí k obnovení zóny a zadejte, zda bude doména vyžadovat alias www.",
    'dns-zone.restore-default.ipv4' => "Adresa IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Například 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Adresa IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Například 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Zadaná adresa IP je neplatná.',
    'dns-zone.restore-default.customIpHint' => "Záznamy s touto IP adresou budou považovány za modifikovány uživatelem a nebudou synchronizovány se šablonou DNS na celém serveru.",
    'dns-zone.restore-default.wwwPrefix' => "předpona www",
    'dns-zone.restore-default.previewRecords' => "Obnovit záznamy používané pro zobrazení náhledu webu",

    'dns-zone.soa-record.soaMnameSection' => 'Primární jmenný server',
    'dns-zone.soa-record.soaMname' => 'Jmenný server',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Automatický výběr)',
    'dns-zone.soa-record.soaRecordSection' => 'Záznam SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Obnovit',
    'dns-zone.soa-record.retry' => 'Zkusit znovu',
    'dns-zone.soa-record.expire' => 'Vypršení platnosti',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E-mail (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'E‑mailová adresa osoby odpovědného za zónu DNS domény. Vráceno serverem DNS v reakci na dotazy SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'E-mailová adresa vlastníka webu',
    'dns-zone.soa-record.rnameTypeDomain' => 'E-mailová adresa domény',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Zadejte pouze místní část (před @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Externí e-mailová adresa',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Zakázat změnu e‑mailové adresy RNAME za doménu',
    'dns-zone.soa-record.invalidValue' => 'Hodnota je neplatná. Může být od 1 sekundy do 68 let.',
    'dns-zone.soa-record.advancedSection' => 'Pokročilé funkce DNS',
    'dns-zone.soa-record.serialNumberFormat' => 'Použít formát sériového čísla doporučený IETF a RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Tuto možnost vyberte, pokud má vaše doména problémy se splněním kontroly SOA registrátora. Tento formát sériového čísla vyžaduje mnoho registrátorů domén.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Použít výchozí nastavení',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Výchozí nastavení zóny',
    'dns-zone.soa-record.unitSeconds' => 'sekundy',
    'dns-zone.soa-record.unitMinutes' => 'minuty',
    'dns-zone.soa-record.unitHours' => 'hodiny',
    'dns-zone.soa-record.unitDays' => 'dny',
    'dns-zone.soa-record.unitWeeks' => 'týdny',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Interval aktualizace je kratší než hodina, což může kriticky zvýšit datové přenosy serveru a využití prostředků.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Při nastavení hodnoty Minimální TTL na dobu delší než 3 hodiny může být vaše doména pro některé ze správců domén nepřístupná. Doporučuje se nastavit tyto hodnoty, pouze pokud na nich trvá váš registrátor názvů domén.',
    'dns-zone.soa-record.success' => 'Vlastnosti záznamu SOA byly aktualizovány.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Výchozí záznam SOA byl obnoven.',

    'domain-info-section.domainName' => 'Název domény',
    'domain-info-section.emptyDomainName' => 'Zadejte název domény.',
    'domain-info-section.ipAddress' => 'IP adresa',
    'domain-info-section.shared' => 'Sdílený',
    'domain-info-section.exclusive' => 'vyhrazený',
    'domain-info-section.ipAddressHint' => "IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu. Tato IP adresa se použije pro všechny weby vytvořené v rámci předplatného.",
    'domain-info-section.ipAddressHint_powerUser' => "IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu. Tato IP adresa se použije pro všechny weby vytvořené v rámci webového prostoru.",
    'domain-info-section.userName' => 'Uživatelské jméno',
    'domain-info-section.userNameHint' => 'Účet uživatele systému přidružený k webovému prostoru a používaný k přístupu k hostovaným souborům prostřednictvím FTP a SSH.',
    'domain-info-section.emptyLogin' => 'Zadejte přihlašovací jméno.',
    'domain-info-section.password' => 'Heslo',
    'domain-info-section.emptyPassword' => 'Zadejte heslo.',
    'domain-info-section.passwordConfirmation' => 'Zopakovat heslo',

    'email-address.generalTab' => 'Obecné',
    'email-address.generalHint' => 'Pokud je tento emailový účet přidružen k dalšímu uživateli (přístup na Panel zákazníka je povolen), změny, které jste udělali na této stránce, ovlivní nastavení tohoto uživatele. Zejména pokud změníte e-mailovou adresu a heslo, další přihlašovací jméno a heslo se rovněž změní na nové hodnoty.',
    'email-address.redirectTab' => 'Předávání',
    'email-address.redirectHint' => 'Nastavit předávání e-mailových zpráv na jednu nebo více e-mailových adres.',
    'email-address.aliasesTab' => 'E-mailové aliasy',
    'email-address.autoResponderTab' => 'Automatická odpověď',
    'email-address.antispamTab' => 'Filtr nevyžádané pošty',
    'email-address.autoResponderHint' => 'Nastavit automatickou odpověď na každou e-mailovou zprávu přicházející na vaši e-mailovou adresu. Automatická odpověď je standardním prostředkem, jak upozornit vaše korespondenty, že jste mimo kancelář nebo na dovolené.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'E-mailová adresa',
    'email-address.externalEmail' => 'Externí e-mailová adresa',
    'email-address.externalEmailHint' => 'Bude použito k resetování vašeho hesla v případě ztráty přístupu k primární e-mailové adrese.',
    'email-address.user' => 'Přiřazeno',
    'email-address.password' => 'Heslo',
    'email-address.passwordConfirmation' => 'Potvrdit heslo',
    'email-address.clientConfigurationLink' => 'Odkaz na konfigurátor pošty',
    'email-address.responderEnable' => 'Zapnout automatickou odpověď',
    'email-address.responderSubject' => 'Předmět automatické odpovědi na vaši zprávu',
    'email-address.responderContentType' => 'Formát zprávy',
    'email-address.responderContentTypeHint' => 'Formát Prostý text je podporován všemi e-mailovými programy, proto všichni příjemci uvidí zprávu stejným způsobem, jako ji uvidíte vy. HTML zprávy vypadají lépe, protože umožňují vkládat formátovaný text s rozdílnými styly písma. Někteří e-mailoví klienti však nepodporují zprávy HTML a někteří příjemci možná neuvidí formátovaný text.',
    'email-address.responderContentTypeTextPlain' => 'Prostý text',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Kódování',
    'email-address.responderCodepageHint' => 'Kódování definuje, se budou zobrazovat textové znaky. Doporučené kódování je UTF-8.',
    'email-address.responderReplyTo' => 'Předat',
    'email-address.responderReplyToHint' => 'Když bude odeslána automatická odpověď, originální zpráva bude předána na zadanou e-mailovou adresu.',
    'email-address.responderForwardAddress' => 'Předat',
    'email-address.responderForwardAddressHint' => 'Když bude odeslána automatická odpověď, originální zpráva bude předána na zadanou e-mailovou adresu.',
    'email-address.responderMessage' => 'Text automatické odpovědi',
    'email-address.responderReplyToEqualsEmail' => 'Zadaná adresa pro předávání je stejná jako tato e-mailová adresa.',
    'email-address.responderForwardAddressEqualsEmail' => 'Zadaná adresa pro předávání je stejná jako tato e-mailová adresa.',
    'email-address.responderReplyLimit' => 'Odeslat automatickou odpověď na jedinečnou e-mailovou adresu ne více než (počet za den)',
    'email-address.buttonAddResponderAttachment' => 'Přidat přílohu',
    'email-address.buttonRemoveResponderAttachment' => 'Odebrat',
    'email-address.responderAttachment' => 'Připojit soubor',
    'email-address.redirectEnable' => 'Zapnout předávání pošty',
    'email-address.redirectRemoveEnable' => 'Nedoručovat kopie přeposlaných e-mailů do poštovní schránky platformy Plesk',
    'email-address.redirectAddress' => 'Předávat příchozí zprávy na následující e-mailovou adresu',
    'email-address.redirectAddressHint' => 'Zadat e-mailové adresy. Každou adresu lze psát na nový řádek nebo oddělovat adresy prázdnými znaky, čárkami nebo středníky.',
    'email-address.role' => 'Role uživatele',
    'email-address.roleHint' => 'Uživatelské role zaručují uživatelům oprávnění ke správě a k přístupu k aplikacím, které jste pro roli vybrali.',
    'email-address.errorRedirectAddress' => 'Zadali jste neplatnou e-mailovou adresu: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Zadali jste neplatné e-mailové adresy: %value%.',
    'email-address.mailAlias' => "E-mailový alias",
    'email-address.mailAliasNone' => 'Žádné',
    'email-address.mailAliasHint' => "Aliasy e-mailu jsou alternativní e-mailové adresy přidružené k primární e-mailová adrese. Všechny zprávy odeslané na aliasy e-mailu budou přijaty na primární e-mailové adrese.",
    'email-address.buttonAddMailAlias' => 'Přidat e-mailový alias',
    'email-address.buttonRemoveMailAlias' => 'Odebrat',
    'email-address.emptyEmail' => 'Zadat e-mailovou adresu, na kterou se musí předávat všechny příchozí zprávy.',
    'email-address.emailsIsEqual' => 'Externí e-mailová adresa odpovídá adrese primární. Zadejte jinou externí emailovou adresu.',
    'email-address.emptyPassword' => 'Musíte zadat heslo.',
    'email-address.emptyPasswordConfirmation' => 'Musíte potvrdit heslo.',
    'email-address.emptyAlias' => "Zadat alias e-mailu pro tuto e-mailovou adresu.",
    'email-address.aliasEqualsEmail' => 'Zadaný alias e-mailu je stejný jako e-mailová adresa.',
    'email-address.passwordHint' => 'Bude použito pro přístup k poštovní schránce a k přihlášení do prostředí Plesk (pokud je aktivována odpovídající možnost).',
    'email-address.cyclicRedirect' => 'E-mailovou adresu nelze nastavit tak, aby předávala e-mailové zprávy sama sobě.',
    'email-address.errorMailnameReserved' => 'Zadaná e-mailová adresa se již používá.',
    'email-address.antivirusEnable' => 'Zapnout antivirovou ochranu pro tuto e-mailovou adresu',
    'email-address.antivirusHint' => 'Antivirový program blokuje e-mailové zprávy obsahující virusy a upozorňuje na ně odesílatele i příjemce.',
    'email-address.antivirusSettings' => 'Kontrolovat na přítomnost virů',
    'email-address.antivirusSettingOnlyIncomingMail' => 'pouze příchozí pošta',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'pouze odchozí pošta',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'příchozí a odchozí pošta',
    'email-address.antispamHint' => 'Služba filtrování nevyžádané pošty detekuje nevyžádané zprávy odeslané na emailovou adresu. Chcete-li odstranit nevyžádané zprávy, můžete nastavit filtr nevyžádané pošty, zprávy označit jako nevyžádané změnou jejich předmětu nebo je přemístit do zvláštní složky přístupné e-mailovými klienty prostřednictvím IMAP. Filtr nevyžádané pošty používá k identifikaci spamu řadu místních a síťových testů.',
    'email-address.antispamEnable' => 'Toto je vlastní nastavení limitu pro tuto e-mailovou adresu',
    'email-address.antispamSettings' => 'Co dělat se zprávami vyhodnocenými jako nevyžádané',
    'email-address.antispamSettingsMark' => 'Označte nevyžádané zprávy následujícím textem přidaným k předmětu zprávy',
    'email-address.antispamSettingsMarkHint' => 'Pokud nechcete žádný text přidávat, ponechte toto pole prázdné. Pokud chcete zahrnout počet bodů do předmětu zprávy, napište _SCORE_.',
    'email-address.antispamReportTextHint' => 'Napište text, který chcete přidat do nevyžádané zprávy.',
    'email-address.antispamSettingsDelete' => 'Odstranit všechny zprávy nevyžádané pošty',
    'email-address.antispamSettingsDeleteHint' => 'Nevyžádané zprávy budou z vaší poštovní schránky odstraněny.',
    'email-address.antispamSettingsMove' => 'Přesunout nevyžádanou poštu do složky Spam',
    'email-address.antispamSettingsMoveHint' => 'Přesunout všechny nevyžádané zprávy do složky s názvem Spam. Tato složka je přístupná z vašeho emailového klienta nebo webového rozhraní pošty. Pokud používáte e-mailový účet IMAP, můžete použít složku nevyžádaná pošta k přípravnému zaškolení filtru nevyžádané pošty.',
    'email-address.antispamSettingsMoveWarning' => '„Přesunutí spamu do složky na spam“ nefunguje, pokud nezakážete možnost „Nedoručovat kopie přeposlaných e-mailů“ na kartě „Přeposílání“.',
    'email-address.antispamSettingsMoveJunk' => 'Přesunout nevyžádanou poštu do složky "Nevyžádaná pošta"',
    'email-address.antispamSettingsMoveJunkHint' => 'Přesunout všechny nevyžádané zprávy do složky s názvem "Nevyžádaná pošta". Tato složka je přístupná z vašeho emailového klienta nebo webového rozhraní pošty. Pokud používáte e-mailový účet IMAP, můžete použít složku "Nevyžádaná pošta" k přípravnému zaškolení filtru nevyžádané pošty.',
    'email-address.antispamShowAdvancedSection' => 'Zobrazit upřesňující nastavení',
    'email-address.antispamHideAdvancedSection' => 'Skrýt upřesňující nastavení',
    'email-address.antispamLearnMore' => 'Naučte se, jak připravit filtr nevyžádané pošty.',
    'email-address.antispamFilterScoreTitle' => 'Citlivost filtru',
    'email-address.antispamFilterScoreHint' => 'Filtr nevyžádané pošty vykonává řadu různých testů obsahu a řádku předmětu každé zprávy. Ve výsledku každá zpráva obdrží počet bodů. Čím vyšší číslo, tím pravděpodobnější je, že je jedná o nevyžádanou poštu. Standardně je citlivost filtru nastavena tak, aby všechny zprávy ohodnocené 7 a více body, byly ohodnoceny jako nevyžádané. Pokud při aktuálním nastavení dostáváte mnoho zpráv vyhodnocených jako nevyžádané, zvyšte citlivost filtru a zkuste nastavit nižší hodnotu, například 6. Pokud zprávy schází, protože si filtr myslí, že se jedná o nevyžádanou poštu, zkuste citlivost filtru snížit a nastavit vyšší hodnotu, například 8.',
    'email-address.antispamFilterScore' => 'Citlivost filtru nevyžádané pošty',
    'email-address.antispamWhiteListTitle' => 'Bílá listina',
    'email-address.antispamWhiteListHint' => 'E-maily od odesílatelů uvedených na bílé listině nebude filtr nevyžádané pošty kontrolovat.',
    'email-address.antispamWhiteListField' => 'Bílá listina',
    'email-address.antispamWhiteListFieldHint' => 'Zadejte názvy domén, po jednom názvu domény na řádek. Adresy mohu obsahovat zástupné znaky "*" a "?", například *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Černá listina',
    'email-address.antispamBlackListHint' => 'E-maily od odesílatelů uvedených na černé listině jsou vyhodnoceny jako nevyžádané.',
    'email-address.antispamBlackListField' => 'Černá listina',
    'email-address.antispamBlackListFieldHint' => 'Zadejte názvy domén, po jedné doméně na řádek. Adresy mohu obsahovat zástupné znaky "*" a "?", například *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Důvěryhodné jazyky',
    'email-address.antispamTrustedLanguagesHint' => 'E-mailové zprávy psané v těchto jazycích vždy projdou filtrem.',
    'email-address.antispamTrustedLocalesTitle' => 'Důvěryhodná národní prostředí',
    'email-address.antispamTrustedLocalesHint' => 'E-mailové zprávy, které používají zadané skupiny národních prostředí, vždy projdou filtrem. Skupiny národních prostředí zahrnují nejčastěji používané znakové sady. Například západní znaková sada obsahuje kódování pro písmena použitá v angličtině a západoevropských jazycích.',
    'email-address.antispamTrustedNetworksTitle' => 'Důvěryhodné sítě',
    'email-address.antispamTrustedNetworksHint' => 'Hostitelé předávání na důvěryhodných sítích jsou považováni za bezpečné, bez vlivu spammerů, nemají otevřené přenosy ani otevřené proxy servery.',
    'email-address.antispamIpAddressesField' => 'IP adresy',
    'email-address.antispamIpAddressesFieldHint' => 'Zadejte IP adresu a masku sítě.',
    'email-address.mailBoxQuotaDomainDefault' => 'Výchozí velikost (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Výchozí velikost',
    'email-address.mailBoxOutgoingMessages' => 'Maximální počet odchozích emailových zpráv:',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Výchozí (%%domainOutgoingMessages%% zpráv za hodinu)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Vlastní hodnota pro poštovní schránku',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'zprávy',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Výchozí',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Výchozí velikost',
    'email-address.mailBoxQuotaDomainSpecific' => 'Jiná velikost',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Velikost poštovní schránky',
    'email-address.mailBoxQuotaUnlimited' => 'Neomezeno',
    'email-address.mailBoxLimitReached' => 'Bylo dosaženo limitu v počtu poštovních schránek.',
    'email-address.postboxEnabled' => 'Poštovní schránka',
    'email-address.postboxEnabledYes' => 'Zapnuto',
    'email-address.postboxEnabledNo' => 'Vypnuto',
    'email-address.description' => 'Popis v prostředí Plesk',
    'email-address.descriptionHint' => 'Popis je viditelný pro každého, kdo má přístup k tomuto e-mailovému účtu.',
    'email-address.longDescription' => 'Zadaný popis je příliš dlouhý. Nesmí být delší než %%max%% symbolů.',
    'email-address.loginAsUser' => 'Lze použít k přihlášení do prostředí Plesk',
    'email-address.loginAsUserDescription' => '(přihlašovací jméno: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Velikost poštovní schránky nemůže překročit výchozí hodnotu.',
    'email-address.endDateEnable' => 'Vypnout automatickou odpověď při',

    'failed-request.enable-tracing.description' => 'Sledování zamítnutých žádostí je operace náročná na prostředky. Sledování se automaticky zastaví za %%days%% dní. Lze kdykoli zastavit ručně.',
    'failed-request.enable-tracing.statusCodes' => 'Stavové kódy',
    'failed-request.enable-tracing.statusCodesDescription' => 'Příklad: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Poskytovatel',

    'file-manager.show.buttonReload' => 'Načíst znovu',
    'file-manager.show.buttonSave' => 'Uložit',
    'file-manager.show.buttonSaveAs' => 'Uložit jako',
    'file-manager.show.buttonReset' => 'Resetovat',
    'file-manager.show.buttonTextCodeEditor' => 'Upravit v editoru kódu',
    'file-manager.show.buttonTextEdit' => 'Upravit v textovém editoru',
    'file-manager.show.buttonWysiwygEdit' => 'Upravit v editoru HTML',
    'file-manager.show.eolLabel' => 'Typ zalomení řádků:',
    'file-manager.show.saveAs' => 'Uložit jako:',
    'file-manager.show.saveCodepage' => 'Uložit v následujícím kódování:',
    'file-manager.show.loadCodepage' => 'Zobrazit původní soubor s následujícím kódováním:',
    'file-manager.show.loadCodepageHint' => 'Varování: veškeré neuložené změny se při znovunačtení souboru ztratí.',
    'file-manager.show.fileExists' => "Soubor nebo složka %%fileName%% již existuje. Nelze mít složku a soubor se stejným názvem.",
    'file-manager.show.popupTitle' => 'Uložit jako',
    'file-manager.show.popupFilename' => 'Název souboru:',

    'file-manager.permissions.filePermissions' => 'Oprávnění k souboru',
    'file-manager.permissions.directoryPermissions' => 'Oprávnění k adresáři',
    'file-manager.permissions.buttonSubmit' => 'Uložit',
    'file-manager.permissions.buttonApply' => 'Uložit a pokračovat',
    'file-manager.permissions.buttonCancel' => 'Zrušit',
    'file-manager.permissions.buttonAdvanced' => 'Rozšířený',

    'file-manager.unix-file-permissions.group' => 'Skupina',
    'file-manager.unix-file-permissions.owner' => 'Vlastník',
    'file-manager.unix-file-permissions.others' => 'Další',
    'file-manager.unix-file-permissions.readMode' => 'Přečteno',
    'file-manager.unix-file-permissions.writeMode' => 'Zápis',
    'file-manager.unix-file-permissions.execMode' => 'Spustit/vyhledat',
    'file-manager.unix-file-permissions.changeRecursive' => 'Změnit oprávnění rekurzivně',

    'file-manager.windows-permissions.allow' => 'Povolit',
    'file-manager.windows-permissions.deny' => 'Odepřít',
    'file-manager.windows-permissions.inheritFromParent' => 'Povolit přenesení dědičných oprávnění z nadřazeného objektu na tento objekt a všechny podřízené objekty. Zahrnout je spolu s explicitně definovanými položkami',
    'file-manager.windows-permissions.replaceOnChildren' => 'Nahradit položky oprávnění na všech podřízených objektech zde zobrazenými záznamy',
    'file-manager.windows-permissions.buttonAdvanced' => 'Rozšířený',
    'file-manager.windows-permissions.applyTo' => 'Použít:',
    'file-manager.windows-permissions.folderOnly' => 'Pouze tato složka',
    'file-manager.windows-permissions.subfolderOnly' => 'Jen podsložky',
    'file-manager.windows-permissions.filesOnly' => 'Jen soubory',
    'file-manager.windows-permissions.permissionsFor' => 'Oprávnění pro',
    'file-manager.windows-permissions.applyOnto1' => 'Pouze tato složka',
    'file-manager.windows-permissions.applyOnto2' => 'Jen podsložky',
    'file-manager.windows-permissions.applyOnto3' => 'Tato složka a podsložky',
    'file-manager.windows-permissions.applyOnto4' => 'Jen soubory',
    'file-manager.windows-permissions.applyOnto5' => 'Tato složka a soubory',
    'file-manager.windows-permissions.applyOnto6' => 'Pouze podsložka a soubory',
    'file-manager.windows-permissions.applyOnto7' => 'Tato složka, podsložky a soubory',
    'file-manager.windows-permissions.notInherited' => '<není zděděno>',

    'file-manager.editor.titleTextEditor' => 'Textový editor',
    'file-manager.editor.titleCodeEditor' => 'Editor kódu',
    'file-manager.editor.titleCodeViewer' => 'Zobrazit',
    'file-manager.editor.buttonSubmit' => 'Uložit',
    'file-manager.editor.buttonApply' => 'Uložit a pokračovat',
    'file-manager.editor.buttonSaveAs' => 'Uložit jako...',
    'file-manager.editor.buttonCancel' => 'Zrušit',
    'file-manager.editor.exitConfirmationYes' => 'Ano',
    'file-manager.editor.exitConfirmationNo' => 'Ne',
    'file-manager.editor.fileOverwrite' => 'Soubor již existuje.',
    'file-manager.editor.fileOverwriteDescription' => 'Soubor se stejným názvem již existuje. Chcete ho přepsat?',
    'file-manager.editor.exitConfirmation' => 'Opravdu chcete uzavřít soubor a zrušit neuložené změny?',
    'file-manager.editor.buttonCodeEditor' => 'Upravit v editoru kódu',
    'file-manager.editor.buttonTextEditor' => 'Upravit v textovém editoru',
    'file-manager.editor.buttonHtmlEditor' => 'Upravit v editoru HTML',

    'file-manager.import-file.buttonSubmit' => 'Importovat',
    'file-manager.import-file.fieldUrl' => 'URL pro soubor',
    'file-manager.import-file.fieldUrlDescription' => 'Zadejte adresu URL zdroje, například „https://example.com/example.tgz“.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Úplný vzorec pro adresu URL je následující: „https://uzivatel:heslo@example.com/example.tgz“. Uživatelské jméno a heslo jsou volitelné. Podporovanými protokoly jsou http, https, ftp, ftps. Pro části URL obsahující speciální znaky nebo mezery použijte kódování URL.',
    'file-manager.import-file.failure' => 'Soubor nelze importovat.',

    'file-manager.rotation-settings.title' => 'Nastavení rotace koše',
    'file-manager.rotation-settings.rotationBySize' => 'Rotování podle velikosti',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Tato možnost odstraní nové soubory v případě překročení zadaného limitu pro zaplnění koše.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotování podle data',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Dny',
    'file-manager.rotation-settings.rotationByDateHint' => 'Tato možnost odstraní soubory uložené v koši déle než zadaný počet dnů.',
    'file-manager.rotation-settings.save' => 'Uložit',
    'file-manager.rotation-settings.cancel' => 'Zrušit',

    'ftp-user.description' => 'Pokud pracujete na svém webu společně s někým dalším nebo hostíte subdomény pro jiné uživatele, možná pro ně budete chtít vytvořit samostatné účty FTP.',
    'ftp-user.generalSection' => 'Obecné',
    'ftp-user.login' => 'Název účtu FTP',
    'ftp-user.home' => 'Domovský adresář',
    'ftp-user.systemArea' => 'Vytvořit účet FTP s přístupem k souborům mimo domovský adresář',
    'ftp-user.password' => 'Heslo',
    'ftp-user.passwordConfirmation' => 'Potvrdit heslo',
    'ftp-user.hardQuotaSection' => 'Kvóta pevného disku',
    'ftp-user.hardQuota' => 'Kvóta pevného disku',
    'ftp-user.hardQuotaUnlimited' => 'Neomezeno',
    'ftp-user.permissionsSection' => 'Oprávnění',
    'ftp-user.permissionRead' => 'Oprávnění ke čtení',
    'ftp-user.permissionWrite' => 'Oprávnění k zápisu',
    'ftp-user.popupTitle' => 'Vybrat adresář',
    'ftp-user.limitMbUnits' => 'MB',

    'mail-list.listName' => 'Adresa seznamu adresátů',
    'mail-list.enabled' => 'Zapnuto',
    'mail-list.administratorEmail' => 'E‑mail správce seznamu adresátů',
    'mail-list.password' => 'Heslo',
    'mail-list.passwordConfirmation' => 'Potvrdit heslo',
    'mail-list.subscribers' => 'Odběratelé',
    'mail-list.subscribersHint' => 'Zadat e-mailové adresy. Každou adresu lze psát na nový řádek nebo oddělovat adresy mezerou, čárkou nebo středníkem.',
    'mail-list.notify' => 'Upozornit správce na vytvoření seznamu adresátů',
    'mail-list.emptyPassword' => 'Zadat heslo.',
    'mail-list.emptyPasswordConfirmation' => 'Potvrďte heslo.',
    'mail-list.errorSubscribers' => 'Neplatná e-mailová adresa: %value%.',
    'mail-list.errorMaillistReserved' => 'Zadaná adresa seznamu adresátů se již používá.',

    'mail-settings.copyToClipboard' => 'Zkopírovat záznam DNS do schránky.',
    'mail-settings.copySuccess' => 'Záznam DNS byl zkopírován do schránky.',
    'mail-settings.hint' => 'Zde lze změnit nastavení poštovních služeb pro tuto doménu.',
    'mail-settings.service' => 'Poštovní služba na této doméně',
    'mail-settings.nonExist' => 'Co dělat se zprávami pro neexistující uživatele',
    'mail-settings.nonExistBounceWithMessage' => 'Vrátit odesílateli se zprávou',
    'mail-settings.nonExistBounce' => 'Vrátit',
    'mail-settings.nonExistCatch' => 'Předat na adresu',
    'mail-settings.nonExistCatchDescription' => 'Adresa musí patřit na vybranou doménu. Externí adresu nebo jednu adresu pro několik domén může zadat pouze správce.',
    'mail-settings.nonExistExternal' => 'Přesměrovat na externí e-mailový server s IP adresou',
    'mail-settings.nonExistReject' => 'Zamítnout',
    'mail-settings.nonExistDiscard' => 'Zamítnout',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'Žádné',
    'mail-settings.webmailComponentNotInstalled' => 'Součást webové rozhraní pošty nebyla nainstalována.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Existuje subdoména s názvem %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certifikát SSL/TLS pro webové rozhraní pošty',
    'mail-settings.webmailCertificateNone' => 'Nevybráno',
    'mail-settings.mailCertificate' => 'Certifikát SSL/TLS pro e-mail',
    'mail-settings.mailCertificateNone' => 'Nevybráno',
    'mail-settings.serverCertificateNotSelected' => 'Certifikát byl přiřazen, ale mail pro doménu nebyl zabezpečen. Chcete-li dokončit zabezpečení pošty pro doménu, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'zabezpečit poštovní server',
    'mail-settings.mailLists' => 'Povolit seznamy adresátů',
    'mail-settings.mailAutodiscovery' => 'Povolit funkci automatického zjišťování pošty',
    'mail-settings.mailAutodiscoveryDescription' => 'Na %%link%% si prohlédněte, jak pracuje',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'znalostní báze',
    'mail-settings.domainKeys' => 'Ke kontrole odchozích e-mailových zpráv použijte antispamovou ochranu DKIM',
    'mail-settings.activeDkimSelector' => 'Aktivní volič DKIM',
    'mail-settings.defaultDkimSelector' => ' (výchozí nastavení Plesk)',
    'mail-settings.dkimSelectorName' => 'Název voliče',
    'mail-settings.buttonCreateSelector' => 'Vytvořit nový volič DKIM',
    'mail-settings.createSelectorDialogTitle' => 'Vytvořit volič DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Odstranit volič DKIM',
    'mail-settings.removeSelectorConfirmation' => "Odstranit volič '%%selector%%' a přidružené klíče a záznamy DNS?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Vytvořit',
    'mail-settings.buttonCancel' => 'Zrušit',
    'mail-settings.labelRemoveSelector' => 'Odebrat',
    'mail-settings.labelActiveSelector' => 'Aktivní',
    'mail-settings.greyListing' => 'Zapněte antispamovou ochranu Greylisting pro všechny e-mailové účty pod toto doménou',
    'mail-settings.howToConfigureExternalDns' => 'Jak nakonfigurovat externí DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Za účelem povolení podepisování DKIM při použití externího serveru DNS musíte nakonfigurovat záznamy DKIM DNS na serveru DNS sami.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'K tomu využijte níže uvedené záznamy DKIM DNS:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Pokud máte doménové aliasy, které používáte k zasílání e-mailů, připojte k nim také záznamy DKIM DNS. Použijte stejné záznamy jako pro hlavní doménu, ale použijte alias názvu domény.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Abyste viděli, které záznamy DKIM DNS musíte upravit, vyberte zaškrtávací pole „%%option%%“, použijte jej a znovu otevřete toto vyskakovací okno.',
    'mail-settings.mailServiceDisabled' => 'Zakázáno',
    'mail-settings.mailServiceDisabledIncoming' => 'Zakázáno pro příchozí poštu',
    'mail-settings.mailServiceDisabledHint' => 'Platforma Plesk nebude na této doméně poskytovat žádné poštovní služby.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Tato doména může odesílat pouze poštu, a to pouze pomocí služby Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Povoleno',
    'mail-settings.mailServiceEnabledHint' => 'Tato doména může rozesílat a přijímat e-maily.',
    'mail-settings.mailServiceNotConfigured' => 'Nenakonfigurováno',
    'mail-settings.mailServiceNotConfiguredHint' => 'Platforma Plesk nebude na této doméně poskytovat žádné poštovní služby.',
    'mail-settings.warning' => 'Tímto dojde na doméně k trvalému odebrání poštovních schránek se všemi přijatými a odeslanými e-maily.',
    'mail-settings.show.title' => 'Odebrat všechny poštovní schránky a e-maily domény %%domain%%',
    'mail-settings.show.checkbox' => 'Trvale odebere všechny poštovní schránky domény <b>%%domain%%</b>, a to včetně přijatých a odeslaných e-mailů.',

    'role.roleSection' => 'Obecné',
    'role.name' => 'Název role uživatele',
    'role.description' => 'Popis',
    'role.generalPermissionsSection' => 'Přístup ke službám Plesk',
    'role.applicationsAccessSection' => 'Přístup k aplikacím',
    'role.permissionAllow' => 'Poskytnuto',
    'role.permissionDeny' => 'Odepřeno',
    'role.emptyRoleName' => 'Zadejte název role.',
    'role.installedAt' => 'Nainstalováno dne',
    'role.noInstallationUrlAvailable' => 'Externí aplikace',
    'role.invalidRoleName' => 'Zadaný název role uživatele není platný. V názvu role nelze použít otazníky a uvozovky.',
    'role.longRoleName' => 'Zadaný název role uživatele je příliš dlouhý.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Některé operace nemusí být dostupné z následujících důvodů: oprávnění pro operace není zaručeno s právě vybraným předplatným nebo je množství přidělených prostředků nedostačující k provedení operace.',
    'role.servicesPermissionsDescription' => 'Definovat přístup k nainstalovaným aplikacím nebo službám Plesk pro všechny uživatele s touto rolí. Pokud udělíte přístup uživatele aplikaci, aplikace bude dostupná na panelu zákazníka.',
    'role.emailActivation' => 'Aktivovat účty této role prostřednictvím e-mailu',

    'service.admin-access.adminAccess' => 'Přístup pro správu',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Tato pověření budou použita k přístupu pro správu k této aplikaci.',
    'service.admin-access.login' => 'Přihlašovací jméno pro správu',
    'service.admin-access.password' => 'Heslo správy',
    'service.admin-access.passwordConfirmation' => 'Potvrdit heslo',

    'service.info.service-entry-point.availableAt' => 'Dostupný ve',
    'service.info.service-entry-point.customize' => 'Upravit zástupce',
    'service.info.service-entry-point.displayNameLabel' => 'Název zástupce',
    'service.info.service-entry-point.displayNameDescription' => 'Zadat název pro tohoto zástupce. Název se zobrazuje pod ikonou zástupce. Zástupci jsou umístěni na stránkách Mé služby uživatelů, kterým byl udělen přístup k této aplikaci.',
    'service.info.service-entry-point.descriptionLabel' => 'Popis zástupce',
    'service.info.service-entry-point.descriptionDescription' => 'Zadat popis pro tohoto zástupce. Popis se zobrazuje jako kontextová nápověda, když kurzor myši setrvá nad zástupcem.',
    'service.info.service-entry-point.iconLabel' => 'Kliknutím vyberte ikonu zástupce',
    'service.info.service-entry-point.iconCurrent' => 'Aktuální ikona',
    'service.info.service-entry-point.errorEmptyName' => 'Musíte zadat název zástupce',
    'service.info.service-entry-point.errorLongName' => 'Název zástupce by měl být mezi 1 až 255 znaky.',
    'service.info.service-entry-point.errorLongDescription' => 'Popis zástupce by měl být mezi 0 až 255 znaky.',
    'service.info.service-entry-point.hiddenLabel' => 'Skrýt zástupce',
    'service.info.service-entry-point.hiddenDescription' => 'Nezobrazovat tohoto zástupce uživatelům.',

    'service.info.service-permission.assignedUser' => "Udělit tomuto uživateli oprávnění k přístupu",
    'service.info.service-permission.assignedUserNone' => 'Žádný přiřazený uživatel',

    'shared-ssl.master-ssl.switchedOn' => 'Zapnout sdílené SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Název domény webu, jehož certifikát SSL/TLS bude sdílený mezi ostatními weby',
    'shared-ssl.master-ssl.none' => 'Žádné',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Sdílené SSL/TLS nelze zapnout, protože neexistují žádné domény, které mají povolenou podporu SSL/TLS.',

    'user.email.email' => 'E-mailová adresa',
    'user.email.emptyEmail' => 'Musíte zadat e-mailovou adresu.',
    'user.email.internalEmailHint' => 'Vytvořte novou e-mailovou adresu v prostředí Plesk nebo použijte externí e-mailovou adresu.',
    'user.email.longInternalEmail' => 'E-mailová adresa je příliš dlouhá.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Uživatelské jméno e-mailové adresy je pro tento e-mailový server příliš dlouhé. Zadejte přihlašovací jméno, které není delší než %%max%% znaků.',
    'user.email.longInternalEmailFullAddressMailServer' => 'E-mailová adresa je pro tento e-mailový server příliš dlouhá. Zadejte adresu, která není delší než %%max%% symbolů.',
    'user.email.externalEmail' => 'Externí e-mailová adresa',
    'user.email.externalEmailHint' => 'Bude použito k resetování vašeho hesla v případě ztráty přístupu k primární e-mailové adrese.',
    'user.email.emailsIsEqual' => 'Externí e-mailová adresa odpovídá adrese primární. Zadejte jinou externí emailovou adresu.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Zadejte interní nebo externí e-mailovou adresu.',

    'user.profileSection' => 'Obecné informace',
    'user.contactName' => 'Jméno kontaktu',
    'user.email' => 'E-mailová adresa',
    'user.role' => 'Role uživatele',
    'user.accountSection' => 'Předvolby prostředí Plesk',
    'user.login' => 'Uživatelské jméno',
    'user.password' => 'Heslo',
    'user.oldPassword' => 'Staré heslo',
    'user.buttonBack' => 'Zpět',
    'user.generalTab' => 'Obecné',
    'user.applicationsAccessSection' => 'Služby',
    'user.generalPermissionsSection' => 'Oprávnění',
    'user.contactsTab' => 'Kontaktní údaje',
    'user.passwordConfirmation' => 'Potvrdit heslo',
    'user.internalEmailPasswordChanged' => 'Změna hesla také změní interní heslo k e-mailové adrese.',
    'user.emailName' => 'E-mailová adresa',
    'user.emailType' => 'Typ e-mailu',
    'user.companyName' => 'Název společnosti',
    'user.phone' => 'Telefonní číslo',
    'user.imNumber' => 'Rychlé zasílání zpráv',
    'user.fax' => 'Faxové číslo',
    'user.address' => 'Adresa',
    'user.city' => 'Město',
    'user.state' => 'Země/oblast nebo kraj',
    'user.zip' => 'PSČ',
    'user.country' => 'Země',
    'user.additionalInfo' => 'Doplňující údaje',
    'user.additionalInfoHint' => 'Pouze Prostý text: všechny značky jazyka HTML budou ignorovány.',
    'user.language' => 'Jazyk prostředí Plesk',
    'user.buttonChangePassword' => 'Změnit heslo',
    'user.permissionAllow' => 'Poskytnuto',
    'user.permissionDeny' => 'Odepřeno',
    'user.permissionInherited' => 'Definováno podle role',
    'user.emptyContactName' => 'Musíte zadat jméno kontaktu.',
    'user.emptyLogin' => 'Musíte zadat přihlašovací jméno.',
    'user.emptyPassword' => 'Musíte zadat heslo.',
    'user.emptyPasswordConfirmation' => 'Musíte potvrdit heslo.',
    'user.oldPasswordIsIncorrect' => 'Staré heslo je chybné. Zkuste to znovu.',
    'user.chooseDomainBoxTitle' => 'Vybrat jinou doménu:',
    'user.userIsActive' => 'Uživatel je aktivní',
    'user.userIsActiveHint' => 'Aktivní uživatelé mají přístup do prostředí Plesk.',
    'user.emailActivation' => 'Aktivovat účet prostřednictvím e-mailu',
    'user.emailHint' => 'Chcete-li poskytnout uživateli e-mailovou adresu hostovanou na tomto serveru, přejděte na záložku Mail, vytvořte zadanou e-mailovou adresu a přidružte ji k tomuto uživateli.',
    'user.emailContactHint' => 'Obraťte se na svého poskytovatele služeb, pokud chcete použít e-mailovou adresu hostovanou na tomto serveru.',
    'user.personalEmailHint' => "Tuto e-mailovou adresu uživatele lze změnit na záložce Pošta.",
    'user.externalMailRedirectHint' => 'Předávání lze aktivovat pouze pro e-mailové adresy hostované na tomto serveru. Chcete-li vytvořit e-mailovou adresu, přejděte na záložku Pošta.',
    'user.externalMailRedirectHint2' => 'Předávání lze aktivovat pouze pro e-mailové adresy hostované na tomto serveru.',
    'user.externalMailAutoResponderHint' => 'Automatickou odpověď lze aktivovat pouze pro e-mailové adresy hostované na tomto serveru. Chcete-li vytvořit e-mailovou adresu, přejděte na záložku Pošta.',
    'user.externalMailAutoResponderHint2' => 'Automatickou odpověď lze aktivovat pouze pro e-mailové adresy hostované na tomto serveru.',
    'user.roleHint' => 'Uživatelské role zaručují uživatelům oprávnění ke správě a k přístupu k aplikacím, které jste pro roli vybrali.',
    'user.cannotManageMail' => "Nemáte oprávnění spravovat nastavení pošty a služeb.",
    'user.longCompanyName' => 'Zadaný název společnosti je příliš dlouhý.',
    'user.longPhone' => 'Zadané telefonní číslo je příliš dlouhé.',
    'user.longFax' => 'Zadané číslo faxu je příliš dlouhé.',
    'user.longAddress' => 'Zadaná adresa je příliš dlouhá.',
    'user.longCity' => 'Zadaný název města je příliš dlouhý.',
    'user.phoneRegexNotMatch' => 'Zadané telefonní číslo je neplatné.',
    'user.faxRegexNotMatch' => 'Zadané číslo faxu je neplatné.',
    'user.shortCity' => 'Zadaný název města je příliš krátký.',
    'user.limitSubscription' => 'Přístup k předplaceným službám',
    'user.limitSubscriptionHint' => 'Povolit uživatelům přístup pouze ke specifikované předplacené službě. Hodnota "Vše" jim uděluje přístupové oprávnění ke všem předplaceným službám v rámci účtu hostitele.',
    'user.limitSubscriptionAll' => 'Vše',
    'user.deletedSubscription' => 'Odebrat předplacenou službu',

    'web.add-domain-alias.title' => 'Přidat alias domény',
    'web.add-domain-alias.createdSuccessfully' => "Alias domény %%name%% byl vytvořen.",
    'web.add-domain-alias.domainAliasName' => 'Název doménového aliasu',
    'web.add-domain-alias.domainAliasNameHint' => 'Například priklad.net',
    'web.add-domain-alias.forDomain' => 'pro doménu',
    'web.add-domain-alias.settingsSectionLegend' => 'Nastavení',
    'web.add-domain-alias.settingsDns' => 'Synchronizovat zónu DNS s primární doménou',
    'web.add-domain-alias.settingsMail' => 'Poštovní služba',
    'web.add-domain-alias.settingsWeb' => 'Webová služba',
    'web.add-domain-alias.settingsSeoRedirect' => 'Přesměrovat s kódem HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Když návštěvníci otevřou adresu URL aliasu, budou přesměrováni adresu URL hlavní domény. Plesk používá vyhledávač s uživatelsky přívětivým přesměrováním na HTTP 301, což znamená, že se hodnocení vyhledávače nebude dělit mezi adresami URL.',
    'web.add-domain-alias.settingsTomcat' => 'Webové aplikace Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Neplatná doména',

    'web.add-domain.formTitle' => 'Přidávání nové domény',
    'web.add-domain.portalLink' => 'Portál služeb',
    'web.add-domain.domainName' => 'Název domény',
    'web.add-domain.domainNameHint' => "Například priklad.com",
    'web.add-domain.assignToCustomer' => 'Přiřadit tuto doménu zákazníkovi',
    'web.add-domain.customer' => 'Vybrat zákazníka',
    'web.add-domain.createNewCustomer' => 'Vytvořit nového odběratele',
    'web.add-domain.selectExistingCustomer' => 'Vybrat existujícího zákazníka:',
    'web.add-domain.customerContactInfoHint' => 'Zadat kontaktní údaje zákazníka. Všechny ostatní informace, jako je telefonní číslo a adresa, můžete zadat později.',
    'web.add-domain.customerLoginInfoHint' => 'Pověření pro panel zákazníka',
    'web.add-domain.target' => 'Webový prostor',
    'web.add-domain.createNewTarget' => 'Vytvořit nové předplatné',
    'web.add-domain.createNewTarget_powerUser' => 'Vytvořit nový webový prostor',
    'web.add-domain.selectExistingTarget' => 'Vybrat existující předplatné:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Vybrat existující webový prostor:',
    'web.add-domain.dns' => 'Aktivovat službu DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Aktivovat poštovní službu',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Funguje, pokud nastavení předplatného umožňuje spravovat oprávnění pošty v rámci domény. Pokud to umožněno není, aktuální stav poštovní služby bude převzat z nastavení předplatného.',
    'web.add-domain.hostingManagementOptions' => 'Typ hostingu',
    'web.add-domain.websiteHosting' => 'Hostování webu',
    'web.add-domain.websiteForwarding' => 'Předávání',
    'web.add-domain.websiteNoHosting' => 'Žádný hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Nastavení hostování',
    'web.add-domain.domainCreatedSuccessfully' => 'Doména %%domainName%% byla úspěšně vytvořena.',
    'web.add-domain.webspaceLegend' => 'Nastavení webového prostoru',
    'web.add-domain.addWhmWebsiteTitle' => 'Přidání nového webu',
    'web.add-domain.addWhmWebsiteHint' => "Můžete zvolit hostitele webu na serveru.",
    'web.add-domain.selectWhmDomain' => 'Vybrat doménu',
    'web.add-domain.customerLegend' => 'Informace o zákazníkovi',
    'web.add-domain.credentials' => 'Pověření uživatele systému',
    'web.add-domain.credentialsHint' => 'pro přístup k souborům hostovaným na FTP a SSH',
    'web.add-domain.credentialsHintWin' => 'pro přístup k souborům hostovaným na FTP a RDP',
    'web.add-domain.buttonAddDomain' => 'Přidat doménu',

    'web.add-subdomain.formTitle' => 'Přidat subdoménu',
    'web.add-subdomain.formGeneralHint' => 'Subdomény jsou internetové adresy pro různé oddíly vašeho webu. Používají hlavní název vaší domény a příponu. Pokud máte například doménu domain.com, subdoména může být store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Zadáním symbolu * místo názvu můžete také vytvořit subdoménu se zástupným znakem. Návštěvník webu bude přesměrován na tuto subdoménu bez ohledu na název subdomény zadaný do prohlížeče.',
    'web.add-subdomain.subdomainName' => 'Název subdomény',
    'web.add-subdomain.subdomainNameHint' => 'Chcete-li vytvořit subdoménu se zástupným znakem, zadejte *.',
    'web.add-subdomain.forDomain' => 'Nadřazená doména',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Subdoména byla vytvořena.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Nastavení hostování',

    'web.setupService.formTitle' => 'Nastavení služby: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Služba \'%%serviceReference%%\' byla úspěšně aktualizována.',

    'web.site-copy.subdomainsGroup' => 'Subdomény %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Cíl kopírování',
    'web.site-copy.destinationType' => 'Vyberte, kam se mají soubory webu kopírovat',
    'web.site-copy.destinationTypeSite' => 'Web v prostředí Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Zkopírujte soubory webu server na svůj jiný web, který hostuje pod tímto účtem. Pokud máte přístup FTP k jinému účtu na tomto serveru, použijte možnost úložiště FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Zkopírujte soubory webu na jiný web, který hostuje na tomto serveru.',
    'web.site-copy.destinationTypeSiteSelect' => 'Název webu',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Soubory z webu %%source%% nelze kopírovat do %%destination%%, protože %%destination%% je také součástí těchto souborů — jeho kořen dokumentu je podadresářem %%source%% kořene dokumentu.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Soubory z webu %%source%% nelze odebrat, protože soubory %%source%% jsou jejich součástí — kořen dokumentu %%source%% je podadresářem %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Úložiště FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Kopírovat soubory webu na účet FTP na tento nebo na externí server.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Kopírovat soubory webu na účet FTP na externím serveru.',
    'web.site-copy.destinationTypeFtpHost' => "Název hostitele serveru",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Adresář',
    'web.site-copy.destinationTypeFtpUser' => 'Uživatelské jméno',
    'web.site-copy.destinationTypeFtpPassword' => 'Heslo',
    'web.site-copy.destinationTypeFtpMode' => 'Metoda připojení FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Aktivní režim',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'V aktivním režimu Plesk odesílá svou IP adresu a číslo portu, na kterém bude poslouchat externí server, a server vyvolá připojení TCP. Tento režim se doporučuje, pokud server řízený v prostředí Plesk není chráněn bránou firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Pasivní režim',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Pasivní režim lze použít, pokud je server řízený v prostředí Plesk za bránou firewall a není schopen přijímat příchozí připojení TCP.',
    'web.site-copy.existingFiles' => 'Co udělat se stávajícími soubory',
    'web.site-copy.existingFilesKeep' => 'Zachovat existující soubory na cílovém webu',
    'web.site-copy.existingFilesKeepDescription' => 'Přepsat existující soubory se shodnými názvy na cílovém webu.',
    'web.site-copy.existingFilesDelete' => 'Odstranit všechny stávající soubory',
    'web.site-copy.existingFilesDeleteDescription' => 'Před kopírováním odstranit všechny soubory na cílovém webu.',
    'web.site-copy.emptyLogin' => 'Zadejte přihlašovací jméno účtu FTP.',
    'web.site-copy.emptyHost' => 'Zadejte název hostitele serveru.',
    'web.site-copy.emptyPort' => 'Zadejte port hostitele serveru.',
    'web.site-copy.copyInProgress' => 'Kopírování webu %%sourceName%% do %%destinationName%%. O průběhu budete informování e-mailem (%%email%%).',
    'web.site-copy.unableToCopy' => 'Kopírování souborů webu se nezdařilo.',
    'web.site-copy.siteCopied' => 'Soubory webu byly zkopírovány.',
    'web.site-copy.emailSubjSuccess' => 'Soubory webu "%%source%%" byly zkopírovány.',
    'web.site-copy.emailSubjFailure' => 'Kopírování souborů webu "%%source%%" se nezdařilo.',
    'web.site-copy.emailBodySuccess' => 'Soubory webu "%%source%%" byly zkopírovány do "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Kopírování souborů webu "%%source%%" do "%%destination%%" se nezdařilo: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Nastavení předávání',
    'web._shared.forwardDestination' => 'Cílová adresa',
    'web._shared.forwardDestinationHint' => 'Adresa URL cílového webu.',
    'web._shared.forwardingTypeOptions' => 'Typ přesměrování',
    'web._shared.forwardingFrame' => 'Rámcové přesměrování',
    'web._shared.forwardingFrameHint' => 'Přesměrujte návštěvníky webu na jiný web, ale neukazujte jim cílovou adresu, aby o přesměrování nevěděli.',
    'web._shared.forwardingHttpCode301' => 'Přesunuto trvale (kód 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Přesměrujte návštěvníky webových stránek na jiný web a ukažte jim cílovou adresu. Takové přesměrování zachová hodnocení webu pro vyhledávače.',
    'web._shared.forwardingHttpCode302' => 'Přesunuto dočasně (kód 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Pokud nechcete, aby vyhledávače indexovaly tyto dočasné stránky, přesměrujte návštěvníky webu na kopii dočasného webu.',
    'web._shared.documentRoot' => 'Kořen dokumentu',
    'web._shared.documentRootHint' => 'Cesta k domovskému adresáři webu.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Kořen dokumentu nelze změnit, protože jsou na tomto webu nainstalovány webové aplikace.',
    'web._shared.ipAddress' => 'IP adresa',
    'web._shared.shared' => 'Sdílený',
    'web._shared.exclusive' => 'vyhrazený',
    'web._shared.ipAddressHint' => "IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (jiné úložiště)',
    'web._shared.certificate' => 'Certifikát',
    'web._shared.sameCertificatesHint' => 'Vybraný certifikát se použije pro všechny weby hostované na stejné vyhrazené IP adrese.',
    'web._shared.differentCertificatesHint' => 'Toto předplatné je přidruženo ke dvěma vyhrazeným IP adresám se dvěma rozdílnými certifikáty. Vybrané certifikáty nahradí všechny certifikáty nainstalované na webech hostovaných na těchto dvou IP adresách.',
    'web._shared.differentIpTypesCertificateHint' => 'Toto předplatné je přidruženo k jedné sdílené a k jedné vyhrazené IP adrese. Vybraný certifikát se použije také pro všechny ostatní weby hostované na vyhrazené IP adrese.',
    'web._shared.certificateNotSelected' => 'Nevybráno',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Ve vašem úložišti nejsou žádné certifikáty SSL/TLS. Chcete-li přidat certifikát, přejděte na %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'tato stránka',
    'web._shared.seoRedirectDirection' => 'Upřednostňovaná doména',
    'web._shared.seoRedirectDirectionHint' => 'Vyberte URL (buď včetně nebo bez www.) na kterou budou návštěvníci webu přesměrováni pomocí přesměrování HTTP 301, které nenaruší SEO.',
    'web._shared.seoRedirectDirectionNone' => 'Žádný',
    'web._shared.limitMbUnits' => 'MB',

    'web-user.settings.allowScripts' => 'Povolit webovým uživatelům použití skriptů',

    'web-user.name' => 'Přihlašovací jméno k připojení k serveru prostřednictvím FTP',
    'web-user.longName' => 'Toto přihlašovací jméno je příliš dlouhé (je povoleno maximálně %max% symbolů).',
    'web-user.password' => 'Heslo',
    'web-user.passwordConfirmation' => 'Potvrdit heslo',
    'web-user.hardDiskQuota' => 'Kvóta pevného disku',
    'web-user.hardDiskQuotaUnlimited' => 'Neomezeno',
    'web-user.hardDiskQuotaIsNotSupported' => '(kvóta pevného disku není podporována kvůli konfiguraci souborového systému serveru)',
    'web-user.megabytes' => 'MB',

    'web-user.__asp_win_support' => 'Podpora Microsoft ASP',
    'web-user.__asp_dot_net_support' => 'Podpora Microsoft ASP.NET',
    'web-user.__ssi_support' => 'Podpora SSI',
    'web-user.__php_support' => 'Podpora PHP',
    'web-user.__cgi_support' => 'Podpora CGI',
    'web-user.__perl_unix_support' => 'Podpora Perlu',
    'web-user.__perl_win_support' => 'Podpora Perlu',
    'web-user.__python_unix_support' => 'Podpora Pythonu',
    'web-user.__python_win_support' => 'Podpora Pythonu',
    'web-user.__fastcgi_unix_support' => 'Podpora FastCGI',
    'web-user.__webstat_support' => 'Webová statistika',
    'web-user.__apache_errdocs' => 'Vlastní chybové dokumenty',
    'web-user.__hosting_write_modify' => 'Další oprávnění pro zápis/úpravy',
    'web-user.__hosting_webdeploy' => 'Nástroj pro publikování na webu Web Deploy',


    'requiredFields' => 'Požadovaná pole',
];