<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    //===============Button conhelp================//

    'b_disabled' => 'Este recurso não está disponível no momento.',
    'b_disabled_by_key' => 'Este recurso não é suportado pela chave de licença.',
    'b_disabled_by_permissions' => 'Você não tem permissão para executar operações de backup.',
    'b_accept' => "Você deve concordar com os termos deste acordo de licença para usar {$PROD_NAME}.",
    'b_action_log' => 'Configuração de logs de ação.',
    'b_add_ip' => "Adicionar endereços IP ao pool de IP do cliente.",
    'b_database_server_add' => 'Adicionar um servidor de base de dados.',
    'b_adm_skeleton' => 'Gerenciar modelo de host virtual.',

    'b_auto-updates' => "Atualizar o Plesk ou seus componentes.",

    'b_codepage_change' => 'Clique para alterar a codificação.',
    'b_configure_maillists' => 'Configuração de instalação de postagem de lista de endereçamento.',
    'b_comp_info' => 'Informações sobre componentes.',
    'b_decline' => "Com a recusa desta licença não será possível usar {$PROD_NAME}.",
    'b_dumps_list' => 'Acessar as funções de backup e restauração e gerenciar o armazenamento de arquivos de backup.',
    'b_dumps_list_disabled' => 'O serviço não está disponível porque os utilitários de backup não foram instalados.',
    'b_add_services' => 'Página de gerenciamento de serviços adicionais.',
    'b_add_ip_for_clients' => "Adicionar um proprietário para este endereço IP.",
    'b_anonymous_ftp' => 'Configurar FTP anônimo para o domínio.',
    'b_attach_add' => 'Adicionar arquivo anexado.',
    'b_attach_remove' => 'Remover arquivo anexado.',
    'b_backup_ok' => 'O backup foi concluído. Clique para ir ao armazenamento de arquivos de backup.',
    'b_restore_ok' => 'A restauração foi concluída. Clique para ir ao armazenamento de arquivos de backup.',
    'b_cancel' => 'Descartar todas as alterações e retornar à página anterior.',
    'b_card' => 'Editar informações pessoais.',
    'b_clean_log' => 'Limpar log.',
    'b_cl_skeleton' => 'Gerenciar modelo de host virtual.',
    'b_dashboard' => 'Ir para a página inicial.',
    'b_dashboard_shortcut_remove' => 'Remover o atalho da página inicial.',
    'b_domain_restore' => 'Restaurar o domínio deste arquivo de backup.',
    'b_domain_user' => 'Permitir e configurar o acesso do administrador do domínio.',
    'b_do_backup' => 'Fazer backup do domínio. Durante este processo, as funções de gerenciamento de domínio no Painel do Cliente não estarão acessíveis.',
    'b_do_upload' => 'Fazer upload de despejo para o armazenamento.',
    'b_backup_configure' => 'Configuração do gerenciador de backup.',
    'b_domain_alias_add' => 'Configurar um nome de domínio adicional para o seu site.',
    'b_domain_aliases_limit_reached' => 'O limite para o número de nomes alternativos de domínios foi alcançado.',
    'b_create_client_back' => 'Descartar os parâmetros sugeridos e retornar à página anterior.',
    'b_create_client_update' => 'Aplique os parâmetros sugeridos e prossiga com a criação do cliente.',
    'b_create_domain_back' => 'Descartar os parâmetros sugeridos e retornar à página anterior.',
    'b_create_domain_update' => 'Aplicar os parâmetros sugeridos e prosseguir com a criação do domínio.',
    'b_create_domain_client_select' => 'Selecionar o cliente e clicar em OK para criar o domínio.',
    'b_crontab_unix' => 'Gerenciar tarefas do agendador.',
    'b_crontab_win' => 'Gerenciar tarefas do agendador.',
    'b_crontab_unix_turn_on' => 'Clique para ativar a tarefa agendada.',
    'b_crontab_win_turn_on' => 'Clique para ativar a tarefa agendada.',
    'b_crontab_unix_turn_off' => 'Clique para suspender a tarefa agendada.',
    'b_crontab_win_turn_off' => 'Clique para suspender a tarefa agendada.',
    'b_extcert_send_file' => 'Fazer upload de certificado adquirido anteriormente a partir do arquivo especificado.',
    'b_extras_admin' => 'Ferramentas de servidor adicionais.',
    'b_extras_client' => 'Ferramentas de domínio adicionais.',
    'b_cl_ed' => "Clique para editar as informações do cliente.",
    'b_cl_ed_update' => "Clicar para atualizar as informações do cliente.",
    'b_cl_limits' => 'Visualizar ou definir os limites de contas do cliente.',
    'b_cl_new_update' => 'Clicar para criar a conta de cliente.',
    'b_cl_not_cr_dom' => 'O cliente não tem permissão para criar domínios.',
    'b_cl_on' => "Ativar a conta do cliente e os sites de todos os clientes.",
    'b_cl_off' => "Suspender a conta do cliente e os sites de todos os clientes.",
    'b_cl_permissions' => 'Visualizar ou definir as permissões para os recursos alocados para o cliente.',
    'b_cl_pref_up_level' => "Clicar para retornar à página de configurações do cliente sem atualizar.",
    'b_default_db_user' => "Use as credenciais do usuário do banco de dados selecionado para fazer login na interface de administração do banco de dados.",
    'b_edit_tpl__add_ip' => 'Clique para adicionar endereços IP.',
    'b_edit_tpl__cancel_ip' => 'Clique para cancelar.',
    'b_icf' => 'Configurar o firewall',
    'b_ip_clients__add' => 'Clique para adicionar.',
    'b_ip_clients__cancel' => 'Clique para cancelar.',
    'b_client_templates' => 'Gerenciamento de modelos de cliente.',
    'b_create_login' => 'Clique para criar uma conta do MyPlesk.com.',
    'b_skins_managment' => 'Clique para gerenciar aparências.',
    'b_skin_add' => 'Fazer upload de uma nova aparência para o Plesk.',
    'b_skin_manual' => "Abrir o manual do usuário sobre a criação de aparências personalizadas para o Plesk.",
    'b_skin_manual_not_installed' => "O manual do usuário sobre a criação de aparências personalizadas para o Plesk não está instalado.",
    'b_skin_download' => 'Clique para fazer download de skin.',
    'b_skin_replace' => 'Clique para substituir a aparência atual pela nova.',
    'b_spamassassin' => 'Configuração de servidor SpamAssassin.',

    'b_subdom_update' => 'Clique para enviar as configurações.',
    'b_subdom_create' => 'Clique para criar o subdomínio.',
    'b_switch_user' => 'Efetuar login em outra conta.',
    'b_clients' => 'Gerenciar contas de clientes.',
    'b_client_traffic' => "Tráfego do cliente.",
    'b_change_passwd' => "Clique para alterar a senha do administrador.",
    'b_change_cert_name' => 'Alterar o nome do certificado.',
    'b_databases' => 'Criar e gerenciar bancos de dados e usuários de banco de dados.',
    'b_databases__change_server_passwd' => 'Clicar para ir para a página de alteração de senha.',
    'b_directories' => 'Criar diretórios protegidos por senha SSL/TLS ou não SSL/TLS.',
    'b_db_access' => "Configurar as credenciais do administrador do banco de dados.",
    'b_pgsql_access' => "Configurar as credenciais do administrador de PostgreSQL.",
    'b_pgsql_not_access' => 'O PostgreSQL não está instalado.',
    'b_db_add' => 'Adicionar uma base de dados.',
    'b_db_add__lim' => 'Não é possível adicionar bancos de dados a este domínio: o limite do número de bancos de dados foi atingido.',
    'b_db_add_update' => 'Digite o novo nome do banco de dados e clique para adicionar.',
    'b_db_del' => 'Remover o banco de dados.',
    'b_db_admin_not_installed' => 'O webadmin não foi instalado. Entrar em contato com seu provedor de serviços de hospedagem para obter assistência.',
    'b_db_no_default_user' => 'Impossível acessar o Webadmin: o usuário Webadmin padrão não foi especificado.',
    'b_db_dbserver_not_configured' => 'Impossível acessar o Webadmin: o servidor do banco de dados não foi configurado.',
    'b_db_usr_add' => 'Adicionar um usuário da base de dados.',
    'b_db_user_del' => 'Remover o usuário do banco de dados.',
    'b_db_usr_update' => 'Alterar senha.',
    'b_db_rm_submit' => 'Excluir os bancos de dados selecionados.',
    'b_db_not_started' => 'O servidor de banco de dados não foi iniciado.',
    'b_db_not_configured' => 'O servidor de banco de dados não está configurado',
    'b_db_not_installed' => 'O servidor de banco de dados não está instalado',
    'b_default_text' => 'Configure o texto de notificação padrão.',
    'b_du_rm_submit' => 'Excluir os usuários de banco de dados.',
    'b_dns' => 'Administre as configurações de DNS para o domínio.',
    'b_dns_soa_set' => 'Aplicar toldas as alterações.',
    'b_dns_acl_add' => 'Clicar para adicionar o endereço de IP ou máscara de sub-rede.',
    'b_dns_rec_del' => 'Remover este registro da zona DNS.', //to remove
    'b_dns_rec_new' => 'Selecione um novo tipo de registro e clique para adicionar.', //to remove
    'b_dnsrecord_add' => 'Clique para adicionar um registro de recursos à zona DNS',
    'b_dns_soa' => 'Clique para configurar definições de SOA',
    'b_dns_soa_default' => 'Clique para restaurar as configurações-padrão de SOA.',
    'b_dns_default' => 'Clique para restaurar a zona DNS.',

    'b_dns_master_add' => 'Adicionar servidor DNS primário.', //to remove
    'b_dns_new_ns' => 'Adicionar servidor de nomes.', //to remove
    'b_dns_on' => 'Ativar serviço DNS local para a zona.',
    'b_dns_off' => 'Desativar o serviço DNS local para a zona.',
    'b_dns_not_perm' => 'Você não tem permissões para gerenciar a zona DNS para este domínio.',

    'b_dom_deact' => 'Não disponível para domínios suspensos.',
    'b_dom_del' => 'Excluir todas as informações do domínio.',
    'b_log_manager' => 'Gerenciar arquivos de log e opções de processamento de log.',
    'b_dom_new' => 'Clique para criar um domínio.',
    'b_dom_new_no_clients' => 'Não é possível criar um domínio. Você não tem contas de cliente.',
    'b_dom_new_update' => 'Clique para criar um domínio.',
    'b_dom_on' => 'Ativar o domínio.',
    'b_dom_off' => 'Desativar o domínio.',
    'b_dom_pref' => 'Configurar configurações para o domínio.',
    'b_dom_limits' => 'Exibir ou configurar limites para o domínio.',
    'b_domain_traffic' => 'Tráfego de domínio.',
    'b_dom_reg' => 'Registrar este domínio.',
    'b_dom_usr_del' => 'Excluir o acesso de usuário de nível de domínio.',
    'b_doms_mng' => 'Gerenciar os domínios registrados por meio do Plesk.',
    'b_doms_reg' => 'Registrar um domínio.',
    'b_report' => 'Exibir relatório.',
    'b_report_saem' => 'Enviar o relatório de status ao endereço especificado.',
    'b_domains' => 'Gerenciar os domínios.',
    'b_domain_templates' => 'Criar, editar e excluir modelos de domínio.',
    'b_download_log' => 'Fazer o download do arquivo de log para a máquina local.',
    'b_dumps_rm_submit' => 'Clique para excluir os arquivos de backup.',
    'b_edit_adm' => 'Clique para editar informações do administrador.',
    'b_custom_buttons' => 'Gerenciamento de botões personalizados.',
    'b_custom_button_add' => 'Clique para adicionar um botão personalizado.',
    'b_custom_buttons_rm_submit' => 'Clique para remover os botões personalizados selecionados.',
    'b_hide_aliases' => 'Ocultar nomes alternativos.',
    'b_hide_domainaliases' => 'Ocultar nomes alternativos de domínio.',
    'b_hide_subdomains' => 'Ocultar subdomínios.',
    'b_home' => 'Retornar à última tela.',
    'b_hosting' => 'Administrar e configurar a hospedagem da web para o domínio.',
    'b_hst_del' => 'Excluir a configuração atual de hospedagem.',
    'b_hst_not_set' => 'A hospedagem não está configurada.',
    'b_hst_wo_ip' => 'A hospedagem não se baseia em ip.',
    'b_hst_wo_ip_or_not_ssl' => 'A hospedagem não baseia-se no ip ou o suporte SSL/TLS não está ativado.',
    'b_not_phys_hst' => 'A hospedagem não é física.',
    'b_web_stat_not_set' => "As estatísticas da Web não são mantidas. Se você deseja manter as estatísticas, vá para propriedades da conta de hospedagem (Domínios > Nome de domínio > Configuração > Menu de estatísticas da Web) e selecione o programa de estatísticas que necessária.",
    'b_white_list' => 'Gerenciar lista branca.',
    'b_white_list_add' => 'Adicionar um domínio à lista branca.',
    'b_hst_sel_next' => 'Definir o tipo de hospedagem selecionada.',
    'b_hst_update' => 'Aplicar toldas as alterações.',
    'b_int_ip_del' => 'Selecione endereços IP na lista e clique para removê-los da interface.',
    'b_ip_new' => 'Clique para adicionar endereço IP.',
    'b_ip_new_virtuozzo' => 'Não é possível adicionar um endereço IP no Virtuozzo containers.',
    'b_ip_new_lycos' => 'Impossível adicionar um endereço de IP no Lycos.',
    'b_ip_aliasing' => 'Gerenciar endereços IP no servidor.',
    'b_ip_del' => 'Selecione máscaras/endereços IP na lista e clique para remover.',
    'b_ip_rm_submit' => 'Clique para excluir endereços IP.',
    'b_ip_cl_rm_submit' => 'Clique para remover o endereço IP do pool de IP.',
    'b_ip_pool' => "Gestão do pool de IP do cliente.",
    'b_language' => 'Configurar o idioma da interface.',
    'b_login' => 'Efetue login no Plesk.',
    'b_logo' => 'Gerenciar logotipo exibido na área superior da interface.',
    'b_logo_default' => 'Clique para restaurar o logo-padrão.',
    'b_logo_send_file' => 'Digite o novo nome do arquivo do log e clique para fazer o upload.',
    'b_logo_send_link' => 'Digite o novo link do logo e clique para anexar.',
    'b_logo_send_logo' => 'Inserir um novo nome de arquivo de logotipo e clicar para efetuar o upload.',
    'b_log_rm_submit' => 'Clique para excluir arquivos de log.',
    'b_ma_rm_submit' => 'Clique para excluir os nomes alternativos de e-mail.',

    'b_mail' => 'Configurar configurações de sistema de mensagens em todo o servidor.',
    'b_mail_disabled_by_admin' => 'O serviço de e-mail para este domínio foi desativado pelo administrador do servidor.',

    'b_mail_resp_on' => 'Ativar a resposta automática.',
    'b_mail_resp_off' => 'Desativar a resposta automática.',
    'b_mail_resp_add' => 'Criar uma resposta automática.',
    'b_mail_resp_files' => 'Gerenciar repositório de anexos.',
    'b_mail_resp_files_no_mailbox' => 'Esse recurso não está disponível no momento porque você não definiu uma caixa de correio nesta conta de e-mail.',
    'b_mail_resp_upload' => 'Fazer upload de arquivo para o repositório de anexos.',
    'b_mail_resp_attach_add' => 'Criar um anexo.',

    'b_mail_names' => 'Gerenciar serviços de e-mail: Caixas de correio POP3, páginas de encaminhamento, grupos e respostas automáticas.',
    'b_mail_name_resp_attach_selected' => 'Clique para anexar os arquivos selecionados à resposta automática.',

    'b_mail_on' => 'Ativar serviços de e-mail para este domínio.',
    'b_mail_off' => 'Desativar serviços de e-mail para este domínio.',
    'b_mail_preferences' => 'Configurar definições de recepção de e-mail para usuários não-existentes.',

    'b_mn_alias_new' => 'Adicionar um alias do e-mail.',
    'b_mn_mail_group' => 'Gerenciar grupo de e-mail.',
    'b_mn_mailbox' => 'Gerenciar caixas de correio.',
    'b_mn_preferences' => 'Configurar conta de e-mail.',
    'b_mn_responders' => 'Gerenciar respostas automáticas.',
    'b_mn_resp_rm_submit' => 'Excluir respostas automáticas.',
    'b_mn_redir_rm_submit' => 'Excluir páginas de redirecioinamento de e-mail.',
    'b_mn_redirect' => 'Gerenciar as páginas de redirecionamento de e-mail.',
    'b_mn_files_rm_submit' => 'Clique para excluir arquivos.',
    'b_mn_attach_rm_submit' => 'Clique para excluir anexos.',
    'b_mn_groups' => 'Clique para gerenciar grupos de e-mail.',
    'b_mn_spamfilter_on' => 'Clique para gerenciar filtragem de spam.',
    'b_mn_spamfilter_off' => 'A filtragem de spam está atualmente indisponível. Para habilitar a filtragem de spam, você precisa instalar o software do filtro de spam e suportar a filtragem de spam em nível de usuário, habilitada na página Caixa Postal -> Filtro de Spam.',
    'b_mn_spamfilter_srv' => 'O administrador desabilitou a capacidade dos usuários de configurar a filtragem de spam.',

    'b_make_dump' => 'Fazer backup do domínio.',
    'b_ftp_account_for_dumps_repository' => 'Para conseguir usar um servidor FTP externo para armazenar os backups de domínio, você deve especificar as propriedades da conta FTP utilizada para acessar o servidor.',
    'b_cron_task_backup' => 'Gerenciar a programação do backup.',

    'b_mg_mem_del' => 'Selecione membros de grupo de e-mail da lista e clique para remover.',
    'b_mg_add' => 'Adicionar a conta de e-mail aos grupos de e-mail selecionados.',
    'b_mg_cancel' => 'Clique para cancelar.',
    'b_mg_del' => 'Remover a conta de e-mail dos grupos de e-mail selecionados.',
    'b_mg_mem_new' => 'Clique para adicionar um membro do grupo de e-mail.',
    'b_mg_turn_on' => 'Clique para ativar o grupo de e-mail.',
    'b_mg_turn_off' => 'Clique para desativar o grupo de e-mail.',
    'b_mg_update' => 'Clique para enviar alterações.',
    'b_mn_rm_submit' => 'Clique para excluir contas de e-mail.',
    'b_mn_webmail_on' => 'Clique para abrir o webmail.',
    'b_mn_webmail_off' => 'Esse recurso não está disponível no momento porque o suporte a webmail não está ativado nas configurações de e-mail ou a caixa de correio não está ativada.',

    'b_modules_manage' => 'Gerenciar módulos instalados no Plesk e acessar as funções fornecidas por esses módulos.',
    'b_notifications' => 'Editar notificações.',
    'b_permissions' => 'Visualizar ou definir as permissões para o cliente.',
    'b_performance' => 'Gerenciar o desempenho do domínio.',
    'b_first_page' => 'Você já está na primeira página.',
    'b_anonftp_stats' => 'Estatísticas de transações FTP anônimas.',
    'b_ftp_stats' => 'Estatísticas de transações do servidor de FTP.',
    'b_ftp_stats_disable' => 'As estatísticas da Web não estão mantidas, o serviço FTP anônimo não está ativado ou a hospedagem não é física.',
    'b_last_page' => 'Você já está na última página.',
    'b_next_page' => 'Ir para a próxima página.',
    'b_prs_rm_submit' => 'Clique para excluir prioridades.',
    'b_preferences' => "Configurar as preferências da interface.",
    'b_prev_page' => 'Ir para a página anterior.',
    'b_preview' => 'Visualizar o site antes da propagação de DNS.',
    'b_qus_rm_submit' => 'Clique para excluir prioridades.',
    'b_repair_ip' => 'Clique para adicionar o endereço IP.',
    'b_repair_ip_status_ok' => 'Este endereço IP não precisa ser reparado.',
    'b_reboot' => 'Reiniciar o servidor.',
    'b_refresh' => 'Atualizar os dados na tela.',
    'b_key_buyonline_addons' => 'Fazer pedido de complementos para o Plesk.',
    'b_key_buyonline_upgrades' => 'Fazer pedido de upgrades para o Plesk.',
    'b_key_buyonline_new' => 'Fazer pedido de uma nova chave de licença.',
    'b_quick_search' => 'Ver a lista de itens que correspondem aos critérios de pesquisa.',
    'b_remove_ip' => "Selecionar os endereços de IP da lista e clicar para removê-los do pool de IP do cliente.",
    'b_restart_services' => "Gerenciar serviços de {$PROD_NAME}.",
    'b_send_passwd' => 'Clique para obter a senha por e-mail.',
    'b_server' => 'Definir configurações em todo o servidor.',
    'b_database_servers' => 'Gerenciar servidores de banco de dados.',
    'b_server_pref' => 'Configurações de sistema e interface.',
    'b_sessions' => 'Gerenciar sessões.',
    'b_sess_rm_submit' => 'Clique para excluir sessões.',
    'b_set_time' => 'Definir data e hora do sistema.',
    'b_set_time_virtuozzo' => 'Não é possível alterar a data/hora do sistema no Virtuozzo containers.',
    'b_site_apps' => 'Gerenciamento de aplicativos da web.',
    'b_site_apppkgs' => 'Gerenciamento de pacotes de aplicativos da web.',
    'b_site_apppkgs_pool' => 'Gerenciamento de pacotes de aplicativos da web.',
    'b_site_apps_rm_submit' => 'Clique para excluir os aplicativos da web selecionados.',
    'b_additional_key_is_active' => 'A chave de licença já está ativa.',
    'b_additional_key_activate' => 'Clique para ativar a chave de licença.',
    'b_site_builder' => 'Clique para ativar a integração com o Presence Builder.',
    'b_dom_site_builder' => 'Clique para abrir o Assistente do Presence Builder.',
    'site_builder_no_permission' => 'Você não tem permissão para usar o Mambo CMS.',
    'b_site_builder_no_package' => 'O Mambo CMS não está instalado.',
    'b_site_builder_no_requires' => 'Não é possível executar Mambo CMS, já que os requisitos de hospedagem não foram satisfeitos.',
    'b_site_builder_no_vrt_hst' => 'Para conseguir usar o Mambo CMS, você deve configurar a hospedagem física para este domínio.',
    'b_site_builder_setup' => 'Executar o Mambo CMS (se esta for a primeira execução - o aplicativo será configurado)',
    'b_show_aliases' => 'Mostrar nomes alternativos.',
    'b_show_domainaliases' => 'Mostrar nomes alternativos de domínio.',
    'b_show_subdomains' => 'Mostrar subdomínios.',
    'b_shutdown' => 'Desativar o servidor.',
    'b_statistics' => 'Revisar estatísticas do servidor.',
    'b_system_time' => 'Gerenciar data e hora do sistema.',
    'b_support' => 'Arquive um pedido para o suporte técnico.',
    'b_summary_report' => 'Clique para visualizar o relatório de resumo.',
    'b_subdom_hosting' => 'Administrar e configurar a hospedagem na web para o subdomínio.',
    'b_subdomains' => 'Criar e gerenciar subdomínios.',
    'b_traffic_history' => 'Ver histórico de tráfego.',
    'b_set_timezone' => 'Clique para definir o fuso horário.',
    'b_set_timezone_virtuozzo' => 'Não é possível alterar o fuso horário no Virtuozzo containers.',
    'b_uninst_submit' => "Clique para desinstalar {$PROD_NAME}.",
    'b_uninst_cancel' => 'Clique para cancelar a desinstalação.',
    'b_upload_from_ftp' => 'Clique para ver uma lista de backups armazenados no servidor de FTP.',
    'b_ok' => 'Aplicar toldas as alterações.',
    'b_update' => 'Aplicar toldas as alterações.',
    'b_update_db_access' => 'Salvar as alterações feitas para as credenciais de acesso de banco de dados.',
    'b_updtntp' => 'Ativar ou desativar a sincronização de data/hora com o servidor NTP.',
    'b_updtntp_virtuozzo' => 'Não é possível configurar a sincronização de data/hora com o servidor NTP no Virtuozzo containers.',
    'b_updtpswd' => "Alterar senha do administrador.",
    'b_upload_dump' => 'Fazer upload de arquivo de backup para o armazenamento de backup.',
    'b_no_dumps_on_ftp' => 'O armazenamento remoto está vazio.',
    'b_web_stats' => 'Estatísticas de transações do servidor da Web.',
    'b_web_stats_disable' => 'As estatísticas da web não estão ativadas ou a hospedagem não é física.',
    'b_web_stats_ssl' => 'Estatísticas de transações do servidor da web protegido.',
    'b_web_stats_ssl_disable' => 'As estatísticas da web não estão ativadas, o servidor da web protegido não está configurado ou a hospedagem não é física.',
    'b_web_users' => 'Configurar usuários da web para o domínio.',
    'b_vhost_app_add' => 'Instalar o aplicativo da web no domínio.',
    'b_vhost_app_add_no_domains' => 'Existem aplicativos da web já instalados nos diretórios-raiz desses hosts virtuais.',
    'b_interface_management' => 'Ocultar ou mostrar vários elementos do Plesk.',
    'b_virtualdirs' => 'Gerenciar os diretórios virtuais.',
    'b_virtualdir_add' => 'Adicionar um Diretório Virtual.',
    'b_zone_switch_master' => 'Mude o tipo de zona DNS para primário.',
    'b_zone_switch_slave' => 'Mude o tipo de zona DNS para secundário.',

    'b_logrotation_update' => 'Alterar configurações de rotação de log.',
    'b_logrotation_on' => 'Ative a rotação de logs.',
    'b_logrotation_off' => 'Desative a rotação de logs.',

    'b_dom_tmpl_add' => 'Criar um Modelo de Domínio.',
    'b_cl_tmpl_add' => 'Criar um Modelo de Cliente.',
    'b_tmpl_update' => 'Atualizar propriedades do modelo.',
    'b_tmpl_rm_subm' => 'Clique para excluir os modelos.',

    'b_defaultcomponents' => 'Seleção de serviços de terceiros.',
    'b_defaultcomponents__update' => 'Confirmar a seleção e prosseguir com a configuração de serviços de terceiros.',
    'b_defaultcomponents__cancel' => 'Descartar todas as alterações e retornar à página anterior.',

    'b_locale_add' => 'Clique para carregar o novo pacote de idiomas.',
    'b_locales_managment' => 'Clicar para gerenciar os idiomas de interface.',

    'b_subdom_performance' => 'Gerenciar o desempenho do subdomínio.',

    'b_anon_on' => 'Ativar o serviço FTP anônimo para o domínio.',
    'b_anon_off' => 'Desativar o serviço FTP anônimo para o domínio.',

    'b_maillists' => 'Clique para gerenciar listas de endereçamento.',
    'b_maillist_new' => 'Clique para criar a mala direta.',
    'b_maillist_edit' => 'Clique para acessar as funções de administração de malas direta.',
    'b_maillist_turn_on_off' => 'Clique para alterar o status da mala direta.',
    'b_maillists_on' => 'Ativar o serviço de malas direta.',
    'b_maillists_off' => 'Desativar o serviço de malas direta.',
    'b_maillist_off_disabled' => 'A desabilitação de malas diretas não é suportada pelo servidor de e-mail atual.',
    'b_maillists_invert_on_off' => 'Clique para alterar o estado das malas diretas selecionadas.',

    'b_dom_performance_edit' => 'Gerenciar o desempenho do domínio.',
    'b_dom_performance_readonly' => 'Visualizar as configurações de desempenho do domínio.',
    'b_dom_performance_disabled' => 'O recurso não está disponível enquanto o QoS não é aplicado ao dispositivo de rede.',
    'b_subdom_performance_disabled' => 'O recurso não está disponível enquanto o QoS não é aplicado ao dispositivo de rede.',

    //=============return to up level conhelp =====================

    'b_to_admin' => "Retornar para gerenciamento de Help Desk.",
    'b_to_aliases' => 'Retornar para a página de gerenciamento de nomes alternativos de correio.',
    'b_to_autoinstaller_components' => 'Retornar para a página de seleção de componentes.',
    'b_to_autoinstaller_releases' => 'Retornar para a página de seleção de lançamentos.',
    'b_to_custom_buttons' => 'Retornar ao gerenciamento de botões customizados.',
    'b_to_cl_traffic' => "Volte para a página de tráfego do cliente.",
    'b_to_cl_templates' => "Retornar para a lista de modelos de cliente.",
    'b_to_cl_pref' => 'Retorne às configurações do cliente.',
    'b_to_comp_info' => "Retornar para o gerenciamento dos componentes do Plesk.",
    'b_to_dom_rep' => 'Retornar para a visualização de informações de domínio.',
    'b_to_filemanager' => 'Retornar para o gerenciador de arquivos.',
    'b_to_subdomains' => 'Retornar para a lista de subdomínios.',
    'b_to_sessions' => 'Retornar para sessões.',
    'b_to_databases_db' => "Retornar para a página de credenciais e ferramentas do administrador do banco de dados.",
    'b_to_dumps_list' => 'Retornar para o armazenamento de arquivos de backup do domínio.',
    'b_to_backup_manager' => 'Retornar para a página de Gerenciamento de Backup.',
    'b_to_log_files' => 'Retornar para a lista de arquivos de log.',
    'b_to_domains' => 'Retornar para a lista de domínios.',
    'to_domain_aliases' => 'Retornar para a página de nomes alternativos do domínio',
    'b_to_clients' => 'Retornar para a lista de clientes.',
    'b_to_client_home' => "Retornar para a página inicial do cliente.",
    'b_to_cp_access' => 'Retornar para a página de gerenciamento de restrição de acesso.',
    'b_to_crontab_unix' => 'Retornar para a página de gerenciamento do Crontab.',
    'b_to_crontab_win' => 'Retornar para a página de gerenciamento do Agendador.',
    'b_to_dns' => 'Retornar para o gerenciamento de zona DNS.',
    'b_to_dom_ctrl' => 'Retornar para a página de administração do domínio.',
    'b_to_license_management' => 'Retorne às informações de licença.',
    'b_to_mail' => 'Retornar para definir as configurações de e-mail em todo o servidor.',
    'b_to_maillists' => 'Retornar para o gerenciamento de listas de endereçamento.',
    'b_to_maillist_members' => 'Retornar para o gerenciamento dos assinantes de listas de endereçamento.',
    'b_to_mail_names' => 'Retornar para o gerenciamento de contas de e-mail.',
    'b_to_mail_name_responders' => 'Retornar para o gerenciamento de respostas automáticas.',
    'b_to_mail_name_resp_edit' => 'Retornar para a edição das propriedades de resposta automática.',
    'b_to_mail_name_resp_attach_add' => 'Retornar para a criação de um novo anexo.',
    'b_to_mail_name_redirects' => 'Retornar para o gerenciamento de encaminhadores de e-mail.',
    'b_to_mail_name_files' => 'Retornar para o repositório de anexos de conta de e-mail.',
    'b_to_mail_white_list' => 'Retornar para o gerenciamento de entradas de lista branca.',
    'b_to_notifications' => 'Retornar para a edição de notificações.',
    'b_to_server' => 'Retornar para a página de administração do servidor.',
    'b_to_spamassassin' => 'Retornar para a configuração de filtro de spam.',
    'b_to_skins' => 'Retornar para o gerenciamento de aparências.',
    'b_to_skin_info' => 'Retornar para a exibição de propriedades de aparências.',
    'b_to_scheduler' => 'Retornar para a página de gerenciamento do agendador.',
    'b_to_subdom_ctrl' => 'Retornar para a página de administração do subdomínio.',
    'b_to_prs' => 'Retornar para as prioridades.',
    'b_to_responders' => 'Retornar para o gerenciamento de respostas automáticas.',
    'b_to_virtualdirs' => 'Retornar para o gerenciamento de diretórios virtuais.',
    'b_to_virtualdir_edit' => 'Retornar para o diretório virtual anterior.',
    'b_to_virtualdir_root' => 'Retornar para a lista de diretórios virtuais.',
    'b_to_web_users' => 'Retornar para a lista de usuários da web.',
    'b_to_cert' => 'Retornar para o gerenciamento de certificados.',
    'b_to_cl_rep' => "Retornar para as informações do cliente.",
    'b_to_report' => 'Retornar para o relatório.',
    'b_to_report_list' => 'Retornar para os layouts de relatório personalizado.',
    'b_to_db_list' => 'Retornar para a lista de bancos de dados.',
    'b_to_db_usr_lst' => 'Retornar para a lista de usuários de banco de dados.',
    'b_to_db_servers' => 'Retornar para a lista de servidores de banco de dados.',
    'b_to_dns_template' => 'Retornar para a lista de registros de modelos DNS.', //to remove
    'b_to_log_files_list' => 'Retorno para o gerenciamento de arquivos de log.',
    'b_to_log_rotation' => 'Retornar para efetuar as configurações de rotação de log.',
    'b_to_locales' => 'Retornar para o gerenciamento de idiomas do Plesk.',
    'b_to_modules' => 'Retornar para o gerenciamento de módulos.',
    'b_to_modules_management' => 'Retornar para o gerenciamento de módulos.',
    'b_to_cl_pool' => 'Retornar para gerenciamento do pool de IP.',
    'b_to_db' => 'Retornar para o gerenciamento de bancos de dados.',
    'b_to_db_edit' => 'Retornar para o gerenciamento de usuários do banco de dados.',
    'b_to_dom_templates' => 'Retornar para o gerenciamento de modelos de domínio.',
    'b_to_dom_sum_report' => 'Retornar para o relatório de resumo de domínio.',
    'b_to_statistics' => 'Retornar para as estatísticas de tráfego.',
    'b_to_ip_aliasing' => 'Retornar para gerenciamento de endereços IP.',
    'b_to_qus' => 'Retornar para a lista de filas.',
    'b_to_site_apps' => 'Retornar para a lista de aplicativos da web.',
    'b_to_site_app_pkgs' => 'Retornar para o cofre do aplicativo.',
    'b_to_siteapp_install' => 'Retornar para o assistente de instalação de aplicativos da web.',
    'b_to_siteapppackage_info' => 'Retornar para as propriedades do pacote de aplicativo da web.',
    'b_to_additional_key_info' => 'Retornar para as propriedades de chave de licença.',
    'b_to_additional_key_properties' => 'Retornar para as propriedades de chave de licença.',


    //===============Href conhelp==================//
    'b_components_choice_default' => 'Alterar o componente-padrão para este recurso.',
    'b_components_configure' => "Definir os parâmetros de configuração para este componente.",


    //===============Icon conhelp==================//

    'i_db_conn_none' => 'Esse recurso não está disponível porque a chave de licença não o suporta ou o serviço não está instalado.',
    'i_db_conn_ok' => 'A conexão com o banco de dados está estabelecida.',
    'i_db_conn_att' => 'O servidor de banco de dados não foi iniciado ou as credenciais incorretas foram especificadas.',
    'i_db_conn_stopped' => 'O servidor de banco de dados não foi iniciado.',
    'i_db_conn_login_failed' => 'Credenciais incorretas foram fornecidas para a conexão do banco de dados.',

    'i_drweb_off' => "A verificação do antivírus não foi ativada para esta conta de e-mail.",
    'i_drweb_any' => 'A verificação do antivírus está desabilitada para o e-mail de entrada/saída.',
    'i_drweb_from' => 'A verificação do antivírus está desabilitada para o e-mail de saída.',
    'i_drweb_to' => 'A verificação do antivírus está desabilitada para o e-mail de entrada.',
    'i_drweb_turn_key' => 'O antivírus não é suportado pela chave de licença.',
    'i_drweb_turn_perm' => 'Você não tem permissão para gerenciar o antivírus.',
    'i_drweb_turn_install' => 'O antivírus não foi instalado.',
    'i_drweb_turn_pref' => 'Clicar para gerenciar as configurações do antivírus.',

    'i_client_ok' => 'O uso de recursos do cliente está dentro dos limites.',
    'i_cl_ok' => 'O uso de recursos do cliente está dentro dos limites.',
    'i_cl_!' => "O uso de recursos do cliente ultrapassou os limites.",
    'i_client_on' => 'Esta conta de usuário está ativa.',

    'i_client_cp_access_on' => 'O acesso ao Painel do Cliente é permitido para o cliente.',
    'i_client_cp_access_off' => 'O acesso ao Painel do Cliente não é permitido para o cliente.',
    'i_click_to_cl_cp_access_on_off' => "Clique para permitir ou proibir o acesso ao Painel do Cliente para o cliente.",

    'i_custom_errors_del' => 'Clicar para remover o item da lista.',
    'i_custom_errors_del_disabled' => 'A remoção de erros customizados padrão do servidor está indisponível.',

    'i_open_subdomain' => 'Clique para visualizar o site no navegador da web.',
    'i_open_domain' => 'Clique para visualizar o site no navegador da web.',
    'i_open_domain_disabled' => 'O domínio não tem nenhuma hospedagem configurada.',

    'i_dom_ok' => 'O uso de recursos deste domínio está dentro dos limites alocados.',

    'i_dom_tmpl__owner_admin' => 'Este modelo é criado pelo administrador',
    'i_dom_tmpl__owner_client' => 'Este modelo é criado pelo cliente.',

    'i_dns_on' => 'Esta zona DNS é atendida pelo servidor DNS local.',
    'i_dns_off' => 'Esta zona DNS é atendida por um servidor DNS externo.',
    'i_click_to_dom_on_off' => 'Clique para ativar/desativar o domínio.',
    'i_click_to_cl_on_off' => "Clique para ativar/desativar a conta do cliente e os domínios do cliente.",
    'i_dom_!' => 'Os limites de uso do recurso foram ultrapassados por este domínio.',
    'i_dom_on' => 'O domínio está ativo.',
    'i_dom_off' => 'O domínio é inativo.',
    'i_dom_off_by_admin' => 'O domínio foi suspenso pelo administrador.',
    'i_dom_off_by_reseller' => 'O domínio foi suspenso pelo revendedor.',
    'i_dom_off_by_client' => 'O domínio foi suspenso pelo cliente.',
    'i_dom_off_expired' => 'O domínio está expirado.',
    'i_dom_off_with_parent' => "Esta conta de usuário e o domínio do usuário foram suspensos",
    'i_dom_off_backup_restore' => 'O domínio está temporariamente suspenso para fazer backup ou restaurar.',

    'i_locale_active_true' => 'Este idioma está disponível para os usuários do Plesk.',
    'i_locale_active_att' => 'Este idioma não está disponível para os usuários porque seu limite de número de idiomas permitidos foi excedido.',
    'i_locale_active_false' => 'Este idioma não está disponível para os usuários.',
    'i_locale_set_active_true' => 'Clique neste ícone para disponibilizar o idioma aos usuários.',
    'i_locale_set_active_false' => 'Clique neste ícone para indisponibilizar o idioma aos usuários.',
    'i_locale_default_locale' => 'Este é o idioma padrão: não é possível indisponibilizá-lo aos usuários.',

    'i_log_rot_enabled' => 'A rotação de logs está ativada.',
    'i_log_rot_disabled' => 'A rotação de logs está desativada.',
    'i_log_rot_disabled_by_parent' => 'A rotação de logs está desativada porque o site foi desativado.',

    'i_spamfilter_on' => 'A filtragem de spam está ativada.',
    'i_spamfilter_off' => 'A filtragem de spam está desativada.',
    'i_spamfilter_turn_srv' => 'O uso de configurações de proteção contra spam individuais não é permitido pela política do sistema.',
    'i_spamfilter_turn_key' => 'O SpamAssassin não é suportado pela chave de licença.',
    'i_spamfilter_turn_component' => 'O componente SpamAssassin não está instalado.',
    'i_spamfilter_service_off' => 'O serviço SpamAssassin não está sendo executado.',
    'i_spamfilter_turn_is_disabled_system_wide' => "A proteção contra spam foi desativada pelo seu provedor de serviços de hospedagem.",
    'i_spamfilter_turn_permission' => 'Você não tem permissão para gerenciar o filtro de spam.',

    'i_additional_key_free' => 'Distribuído livremente. Nenhuma chave de licença é necessária.',
    'i_additional_key_ok' => 'A chave de licença necessária está instalada.',
    'i_additional_key_problem' => 'A chave de licença necessária não está instalada.',
    'i_additional_key_info' => 'Clique no ícone para acessar as funções de gerenciamento de chave de licença.',
    'i_additional_key_download' => 'Clique para fazer o download da chave de licença.',

    'i_vcard' => 'Adicionar uma pessoa ao seu catálogo de endereços.',

    'i_autoinstaller_component_action_error' => 'Não há atualizações disponíveis.',

    'i_autoinstaller_release_action_upgrade' => 'Atualização para a nova versão do Plesk.',
    'i_autoinstaller_release_action_update' => 'Atualização ou adição de novos componentes.',
    'i_autoinstaller_release_action_up2date' => 'Você tem uma versão atualizada.',
    'i_autoinstaller_release_action_error' => 'Erro ao recuperar informações sobre o lançamento.',

    'i_autoinstaller_component_action_install' => 'Não instalado',
    'i_autoinstaller_component_action_update' => 'As atualizações estão disponíveis',
    'i_autoinstaller_component_action_upgrade' => 'As atualizações estão disponíveis',
    'i_autoinstaller_component_action_up2date' => 'Você tem uma versão atualizada',

    'i_mail_resp_on' => 'A resposta automática está ativada.',
    'i_mail_resp_turn_off' => 'Clique neste ícone para desativá-la.',
    'i_mail_resp_off' => 'A resposta automática está desativada.',
    'i_mail_resp_turn_on' => 'Clique neste ícone para ativá-la.',
    'i_mail_resp_att' => 'Todas as respostas automáticas são desativadas para esta conta de correio.',

    'i_anonftp_on' => 'A conta FTP anônima para o domínio está ativada.',
    'i_anonftp_off' => 'A conta FTP anônima para o domínio está desativada.',

    'i_sapp_ssl' => 'O aplicativo da web está instalado no diretório SSL/TLS.',
    'i_sapp_non_ssl' => 'O aplicativo da web está instalado no diretório não SSL/TLS.',
    'i_serv_drweb_up_dis' => "Iniciar o serviço.",
    'i_serv_none' => 'O serviço não está instalado.',
    'i_serv_not_configured' => 'O serviço não está configurado.',
    'i_serv_on' => 'O serviço está sendo executado.',
    'i_serv_off' => 'O serviço não está sendo executado.',
    'i_serv_up' => 'Iniciar o serviço.',
    'i_serv_up_dis' => 'O serviço já está sendo executado.',
    'i_serv_down' => 'Interrompa o serviço.',
    'i_serv_down_dis' => 'O serviço já foi interrompido.',
    'i_serv_up_n_down' => 'Reiniciar o serviço.',
    'i_serv_up_n_down_dis' => 'O serviço foi interrompido.',
    'i_serv_key_dsbld_not_inst' => 'Esse recurso não está disponível ou porque sua chave de licença não o suporta ou o serviço não está instalado ou propriamente configurado.',

    'i_skin_download' => 'Clique para fazer download da aparência.',

    'i_virtualdirs_read_enabled' => 'A permissão de Leitura do diretório virtual foi habilitada.',
    'i_virtualdirs_read_disabled' => 'A permissão de Leitura do diretório virtual foi desabilitada.',
    'i_virtualdirs_write_enabled' => 'A permissão de Escrita do diretório virtual foi habilitada.',
    'i_virtualdirs_write_disabled' => 'A permissão de Escrita do diretório virtual foi desabilitada.',
    'i_virtualdirs_source_enabled' => 'A permissão de acesso à fonte de scripts do diretório virtual foi habilitada.',
    'i_virtualdirs_source_disabled' => 'A permissão de acesso à fonte de scripts do diretório virtual foi desabilitada.',
    'i_virtualdirs_browse_enabled' => 'A permissão de navegação do diretório virtual foi habilitada.',
    'i_virtualdirs_browse_disabled' => 'A permissão de navegação do diretório virtual foi desabilitada.',
    'i_virtualdirs_change_status' => 'Clicar para ativar/desativar a permissão.',

    'b_show_additional_users' => 'Estender a lista de usuários/grupos de usuários exibindo os usuários com permissões não definidas.',
    'b_hide_additional_users' => 'Reduzir a lista de usuários/grupos de usuários ocultando os usuários com permissões não definidas.',

    'i_prtd_ssl' => 'O diretório SSL/TLS é protegido por senha.',
    'i_prtd_no_ssl' => 'O diretório SSL/TLS não é protegido por senha.',
    'i_prtd_nonssl' => 'O diretório não SSL/TLS é protegido por senha.',
    'i_prtd_no_nonssl' => 'O diretório não SSL/TLS não é protegido por senha.',
    'i_prtd_cgi_bin' => 'o diretório cgi-bin é protegido por senha.',
    'i_prtd_no_cgi_bin' => 'o diretório cgi-bin não é protegido por senha.',

    'i_htype_none' => 'A hospedagem não está configurada.',
    'i_htype_vrt_hst' => 'Hospedagem física.',
    'i_htype_frm_fwd' => 'Encaminhamento de quadro.',
    'i_htype_std_fwd' => 'Encaminhamento-padrão.',

    'i_click_to_hosting' => 'Clique para continuar a instalação da hospedagem.',

    'i_ftp_ses_domain' => 'Sessão do administrador do domínio.',
    'i_ftp_ses_sub_domain' => 'Sessão do administrador do subdomínio.',
    'i_ftp_ses_web_user' => 'Sessão do usuário da web.',
    'i_ftp_ses_anonymous' => 'Sessão de usuário FTP anônimo.',
    'i_ftp_ses_not_plesk' => 'Usuário FTP que não está registrado no Plesk.',
    'i_ftp_ses_idle' => 'Ocioso (nenhuma transação).',
    'i_ftp_ses_upload' => 'O upload está em andamento.',
    'i_ftp_ses_download' => 'O download está em andamento.',
    'i_ftp_ses_list' => 'Download de uma lista de diretórios.',
    'i_ftp_ses_not_know' => 'Atividade FTP não reconhecida.',


    //===============Page conhelp==================//

    'admin_ed' => 'Informações do administrador.',
    'anonftp' => 'Configure o serviço de FTP anônimo.',
    'actionlog' => 'Gerenciar configurações de log de ação.',
    'auto_updates' => "Atualizações {$PROD_NAME} disponíveis.",
    'autoinstaller_releases' => 'Selecione o nome da versão desejado para acessar a lista de componentes disponíveis.',
    'autoinstaller_components' => 'Selecione os componentes necessários e clique em Instalar para instalá-los.',
    'autoinstaller_install' => 'Confirme a instalação e clique em OK para começar.',
    'autoinstaller_configure' => 'Configurações do atualizador.',
    'backup_dialog' => 'Você pode efetuar o backup do domínio sobre esta página. O arquivo de backup resultante pode ser colocado no armazenamento de backups local ou remoto ou baixado para o disco local.',
    'backup_configure' => 'Página de configuração do gerenciador de backup.',
    'card' => 'Editar informações pessoais.',
    'cat_edit' => 'Página de configuração de categoria.',
    'cert' => 'Repositório de certificados.',
    'cert_dom' => 'Repositório de certificados.',
    'cert_add' => 'Adicionar um certificado.',
    'cert_add_dom' => 'Adicionar um certificado.',
    'cert_edit' => 'Página de edição de certificado.',
    'cl_ed' => "Edite as informações do cliente e clique em OK.",
    'cl_home' => 'Página inicial do cliente.',
    'cl_new' => "Inserir as informações sobre o cliente e clicar em OK para criar uma conta de cliente.",
    'cl_perm' => "Configure as permissões do cliente.",
    'cl_limits' => "Defina os limites do cliente.",
    'cl_logo' => "Configurar um logotipo para o Painel do Cliente do cliente.",
    'cl_pool' => 'O intervalo de endereços IP atribuídos ao cliente.',
    'cl_pool_add' => "Alocação de endereços IP para o cliente.",
    'cl_pool_first_time' => 'Alocação de endereços IP para o cliente.',
    'cl_pool_ctrl' => 'Propriedades do endereço IP.',
    'cl_pref' => "Configurações do cliente.",
    'cl_traffic_history' => 'Página do histórico de tráfego para o cliente.',
    'cl_templates' => 'Esta página lista modelos de clientes.',
    'cl_traffic' => "Tráfego do cliente",
    'clients' => 'Esta página lista todas as contas de cliente registradas no sistema.',
    'component_conf' => "Configuração dos parâmetros do componente.",
    'custom_buttons_admin' => 'Criar e gerenciar seus botões customizados.',
    'custom_buttons_domain' => 'Criar e gerenciar seus botões customizados.',
    'custom_buttons_client' => 'Criar e gerenciar seus botões customizados.',
    'custom_buttons_reseller' => 'Criar e gerenciar seus botões customizados.',
    'custom_buttons_remove' => 'Remover botões customizados selecionados.',
    'custom_button_admin_edit' => 'Editar botão customizado.',
    'custom_button_domain_edit' => 'Editar botão customizado.',
    'custom_button_client_edit' => 'Editar botão customizado.',
    'custom_button_reseller_edit' => 'Editar botão customizado.',
    'configure' => 'Página de configuração do Postinstall.',
    'comp_info' => 'Informações sobre componentes.',
    'common_acl' => 'Esta página exibe uma lista de todos os endereços de IP ou Redes para os quais a transferência de zonas é permitida.',
    'to_common_acl' => 'Retornar para a lista de controle de acesso comum.',
    'common_acl_add' => 'Nesta página é possível adicionar um registro para a ACL de transferência de zona de permissão comum.',
    'common_acl_remove' => 'Remoção dos registros ACL selecionados.',
    'cp_access' => 'Gerenciamento de acesso ao Plesk.',
    'cp_access_add_edit' => 'Propriedades de rede.',
    'cp_access_remove' => 'Remoção de rede da lista de restrições de acesso.',
    'crontab_unix' => 'Esta página lista todas as tarefas agendadas no sistema.',
    'crontab_win' => 'Esta página lista todas as tarefas agendadas no sistema.',
    'crontab_unix_add_edit' => 'Preencha os dados necessários e clique em OK para agendar a tarefa.',
    'crontab_win_add_edit' => 'Preencha os dados necessários e clique em OK para agendar a tarefa.',
    'crontab_unix_remove' => 'Remoção das tarefas selecionadas.',
    'crontab_win_remove' => 'Remoção das tarefas selecionadas.',
    'scheduler' => 'Esta página contém a lista das tarefas agendadas no sistema.',
    'scheduler_edit' => 'Preencher os campos exigidos e clicar em OK para adicionar a tarefa ao Agendador.',
    'scheduler_remove' => 'Remoção das tarefas agendadas selecionadas.',
    'b_databases_access' => 'Configurar credenciais para acesso aos servidores externos de banco de dados.',
    'databases_db' =>  'Configuração de acesso ao banco de dados e ferramentas de gerenciamento.',
    'databases_server' =>  'Esta página permite alterar a senha utilizada para acessar o servidor do banco de dados.',
    'db' => 'Todos os bancos de dados gerenciados pelo Plesk estão listados nesta página.',
    'db_add' => 'Adição de um novo banco de dados.',
    'db_edit' => 'Todos os usuários deste banco de dados estão listados nesta página.',
    'db_usr_edit' => 'Configurar senha para o usuário de banco de dados.',
    'defaultcomponents' => 'Seleção de componentes-padrão para os serviços.',
    'dl_usr_ed' => "Gerenciar conta do administrador de domínio.",
    'dns_add' => 'Adicionar um registro à zona DNS para o domínio.',
    'dns_soa' => 'Definição de configurações de SOA.',
    'dns_check' => 'Resultados dos testes de zona DNS.',
    'dns_rec_edit' => 'Editar um registro de recursos.',
    'dns_default' => 'Restaurar a zona DNS.',
    'mail_name_drweb' => 'Configurações do antivírus.',
    'dom_ctrl' => 'Administração do domínio.',
    'dom_traffic' => 'Tráfego no domínio.',
    'dom_templates' => 'O modelo de domínio é um conjunto predefinido de restrições, opções e parâmetros de hospedagem  específicos de domínio, destinados a simplificar a criação de domínios com atribuição automática de configurações para eles.',
    'create_domain' => 'Digite um novo nome de domínio para criar um domínio para o cliente.',
    'create_domain_client_select' => 'Selecionar o cliente para o qual deseja criar o domínio.',
    'dom_pref' => 'Configurações de domínio.',
    'dom_lim' => 'Limites de domínio.',
    'domain_report' => 'Informações sobre o domínio.',
    'domain_aliases' => 'Gerenciar os nomes alternativos do domínio.',
    'client_app_item_info' => 'Informações do aplicativo da web.',
    'client_report' => 'Informações sobre o cliente.',
    'cl_rpt_list' => 'Layouts de relatório personalizado.',
    'dom_rpt_list' => 'Layouts de relatório personalizado.',
    'dom_rpt_edit' => 'Editar relatório.',
    'dom_sum_report' => 'Esta página exibe o relatório de resumo de domínio em todos os domínios atendidos pelo sistema.',
    'domains' => 'Esta página exibe uma lista de todos os domínios atendidos pelo sistema.',
    'dumps_list' => 'Usar as funções de backup de domínio e gerenciar o armazenamento de arquivos de backup.',
    'download_dialog' => 'Criação de arquivo de backup.',
    'extras' => 'Página de gerenciamento de serviços adicionais.',
    'edit_dom_tmpl' => 'Editar um modelo de domínio nesta página.',
    'edit_cl_tmpl' => 'Editar um modelo do cliente nesta página.',

    'interface_templates' => 'Gerenciamento de modelos de interface.',
    'interface_templates_remove' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",

    'b_to_interface_templates' => 'Retornar para a lista de modelos de interface.',
    'b_interface_template_make_default' => 'Selecione um modelo de interface e clique para torná-lo padrão.',
    'interface_template_upload' => 'Fazer upload de seu modelo de interface.',
    'interface_clients' => 'Lista de clientes que usam esse modelo de interface.',
    'b_to_interface_clients' => 'Retornar para a lista de clientes que usam esse modelo de interface.',
    'interface_clients_add' => 'Especificar os clientes que devem usar este modelo de interface.',
    'interface_clients_remove' => 'Especificar os clientes que não devem usar o modelo de interface.',

    'ftp_account' => 'Se você usar um servidor FTP externo para armazenar arquivos de backup, nesta página especifique as propriedades da conta FTP utilizada neste servidor.',
    'ftp_dumps_list' => "O conteúdo do armazenamento de arquivos de backup no servidor de FTP está listado. Você pode selecionar um arquivo de backup para fazer o upload no armazenamento do domínio.",

    'filemanager' => 'Gerenciar seus arquivos e diretórios nesta página.',
    'filemanager_rename_file' => 'Mudança de nome de arquivo.',
    'filemanager_rename_dir' => 'Mudança de nome de diretório.',
    'filemanager_chmod' => 'Alterar direitos de acesso ao arquivo.',
    'filemanager_copy_move' => 'Cópia de arquivo (mover).',
    'filemanager_create_file' => 'Criação de arquivos.',
    'filemanager_show' => 'Visualização de arquivo.',
    'filemanager_edit' => 'Edição de arquivos.',
    'filemanager_remove' => 'Remoção de arquivos.',
    'filemanager_owner_row' => 'Proprietário do arquivo.',
    'filemanager_new_file' => 'Criação de arquivos.',
    'filemanager_new_dir' => 'Criação de diretório.',

    'gl_list' => 'Help Desk global.',
    'groups' => 'Gerenciamento de grupos de e-mail.',
    'icf' => 'Configuração do firewall.',
    'ip_clients' => 'A lista de usuários que têm este endereço IP no pool.',
    'ip_clients_add' => 'Selecione clientes e clique em OK para adicionar este endereço IP a seus pools.',

    'frm_fwd' => 'Insira o URL de destino para encaminhamento.',
    'std_fwd' => 'Insira o URL de destino para encaminhamento.',
    'performance' => 'Configuração de desempenho do domínio.',
    'phosting_setup' => 'Configuração da conta de hospedagem. Escolha o tipo de endereço IP (dedicado ou compartilhado), nome de usuário e senha de conta FTP e outros parâmetros de hospedagem relacionados.',
    'phosting_setup_dom_usr' => 'Configuração de parâmetros da conta de hospedagem.',
    'webusers' => 'Esta página lista os usuários da web deste domínio.',
    'hst_type_sel' => 'Selecione o tipo de hospedagem para configurar.',
    'key_update' => 'Status da atualização de chave.',
    'key_revert' => 'Reversão da chave de licença.',
    'interface_management' => 'Esta página permite que você controle quais elementos da interface do usuário estão visíveis e quais não estão.',
    'ip_aliasing' => 'Adicionar e remover endereços IP das interfaces de rede.',
    'ip_aliasing_clients' => 'Consultar a lista de usuários que têm este endereço IP em seus pools IP',
    'ip_aliasing_hosting' => 'Consultar os domínios hospedados neste endereço IP ou encaminhados a partir dele',
    'ip_add' => 'Adição de endereço IP.',
    'ip_ctrl' => 'Alteração de parâmetros de endereço IP.',
    'license' => 'Leia atentamente o contrato de licença.',
    'logo' => 'Mudar imagem de logotipo e URL de logotipo.',
    'log_files' => 'Esta página lista todos os arquivos de log para esse domínio.',
    'log_rotation' => 'Configurações de rotação de log.',

    'locale_upload' => 'Upload do pacote de idiomas.',
    'locales' => 'Gerenciar idiomas do Plesk.',
    'locales_remove' => 'Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.',
    'mail_blocked_domains' => 'Gerenciar a lista negra.',

    'mail_white_list' => 'Gerenciar lista branca.',
    'mail_white_list_edit' => 'Adicionar domínios à lista branca.',
    'mail_white_list_remove' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",

    'mail_name_alias_edit' => 'Crie ou edite um nome alternativo de e-mail.',
    'mail_name_groups' => 'Gerenciamento de associação de grupo de e-mail.',
    'mail_name_mailbox' => 'Gerenciamento de caixa de correio.',
    'mail_name_preferences' => 'Configurações de conta de e-mail.',
    'mail_name_redirects' => 'Gerenciamento da página de redirecionamento de  e-mail.',
    'mail_name_redirects_add' => 'Adicionar membro de grupo de e-mail.',
    'mail_name_redirects_remove' => 'Remoção de membros do grupo de e-mail.',
    'mail_name_resp_edit' => 'Configurar a resposta automática.',
    'mail_name_resp_attach_add' => 'Selecione os arquivos a anexar.',
    'mail_name_resp_attach_del' => 'Remover anexos de respostas automáticas.',
    'mail_name_resp_remove' => 'Remover respostas automáticas.',
    'mail_name_responders' => 'Gerenciamento de respostas automáticas.',
    'mail_name_files' => 'Repositório de anexos de conta de e-mail.',
    'mail_name_files_remove' => 'Remoção de arquivos.',
    'mail_names' => 'Contas de e-mail (caixas de correio, páginas de redirecionamento de e-mail, grupos de mensagens, respostas automáticas).',
    'mail_preferences' => 'Configurações de e-mail.',

    'maillists' => 'Esta página exibe todas as malas diretas  neste domínio.',
    'maillists_conf' => 'A página de criação da mala direta principal.',
    'maillist_edit' => 'Configurações mala direta.',
    'maillist_new' => 'Adição de mala direta.',
    'maillist_del' => 'Remoção da mala direta.',

    'maillist_members' => 'Inscritos na mala direta.',
    'maillist_members_remove' => 'Remoção de inscritos da mala direta.',
    'maillist_member_edit' => 'Adição de usuário da mala direta',

    'upload_module' => 'Upload de módulo.',
    'modules_management' => 'Gerenciamento de módulos.',

    'b_modules_add' => 'Adicionar módulo.',
    'modules_manaege' => 'Adicionar e remover módulos.',
    'modules' => 'Nesta página você pode acessar os recursos fornecidos pelos módulos instalados no seu Plesk.',

    'notifications' => 'Gerenciar sistema de notificação.',
    'notification_text' => 'Editar o texto de aviso.',
    'pg_manage' => 'Adição/alteração das informações de administrador do PostgreSQL.',
    'prtd_dirs' => 'Diretórios protegidos por senha.',
    'reboot' => 'O sistema será reinicializado agora.',
    'responders' => 'Respostas automáticas de e-mail.',
    'redirects' => 'Páginas de redirecionamento de e-mail.',
    'restart_services' => 'Gerenciamento de serviços.',
    'server' => 'Administração do servidor.',
    'sessions' => 'Alterar configurações de sessão.',
    'sessions_list' => 'Esta página exibe uma lista de todas as sessões.',
    'ftp_sessions_list' => 'Esta página exibe uma lista de todas as sessões FTP.',
    'cl_skeleton' => 'Gerenciar modelo de host virtual.',
    'skeleton' => 'Gerenciar modelo de host virtual.',
    'skins' => 'Gerenciar aparências do Plesk.',
    'skin_info' => 'Informações sobre skin.',
    'skin_download' => 'Download de skin.',
    'skin_download_now' => 'Download de skin em andamento.',
    'skin_upload' => 'Upload de skin.',
    'skins_remove' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'shutdown' => 'O sistema está sendo desligado.',
    'site_app_pkgs_add' => 'Adicione um pacote de aplicativos da web.',
    'site_app_pkgs_list' => 'Pacotes de aplicativos da web disponíveis.',
    'site_app_pkgs_instances' => 'Instalações de aplicativo.',
    'siteapp_install' => 'Instalação de aplicativo da web.',
    'siteapp_reconfigure' => 'Reconfiguração do aplicativo da web.',
    'sitepackage_install_config' => 'Configurações de instalação do aplicativo da web.',
    'sitepackage_install_agreement' => 'Contrato de licença do aplicativo da web.',
    'siteapp_extra_files' => 'Especifique o que fazer com os arquivos.',
    'siteapppackage_info_server' => 'Propriedades de pacote de aplicativo da Web.',
    'siteapppackage_info_domain' => 'Propriedades de pacote de aplicativo da Web.',

    'statistics' => 'Estatísticas do sistema.',
    'sys_time' => 'Defina data/hora do sistema e sincronização com o servidor NTP.',
    'subdomains' => 'Gerenciamento de subdomínios. É possível adicionar, editar e remover subdomínios desta página.',
    'subdom_ctrl' => 'Página de administração de subdomínios.',
    'subdom_edit' => 'Configuração de propriedades do subdomínio.',
    'subdom_create' => 'Criação de subdomínio.',
    'subdom_remove' => 'Remoção dos subdomínios selecionados.',
    'templates' => 'Esta página exibe uma lista de todos os modelos de domínio que podem ser usados na criação de um novo domínio.',
    'view_info' => 'A partir desta página você pode ver as propriedades do arquivo de backup e restaurar este backup.',

    'visibility_adminonly' => 'Deixar este controle visível apenas para o administrador.',
    'visibility_cancel' => 'Cancelar personalização de controles nesta tela.',
    'visibility_control' => 'Clique para personalizar este controle.',
    'visibility_customize' => 'Personalizar controles individuais nesta tela.',
    'visibility_default' => 'Aplicar configurações-padrão a este controle.',
    'visibility_export' => 'Exportar as configurações feitas nesta tela na forma de um shell script. Execute esse script em um servidor gerenciado por Plesk para importar as configurações.',
    'visibility_hide' => 'Ocultar este controle.',
    'visibility_hide_toolbar' => 'Ocultar esta barra de ferramentas.',
    'visibility_ok' => 'Salvar personalizações de controles nesta tela.',
    'visibility_reset_all' => 'Redefinir todos os controles em todas as telas para suas configurações-padrão.',
    'visibility_reset_screen' => 'Redefinir todos os controles nessa tela para suas configurações-padrão.',
    'visibility_show' => 'Mostrar esse controle.',

    'virtualdirs' => 'Gerenciamento de diretórios virtuais.',
    'virtualdir_create' => 'Criação de diretório virtual.',
    'virtualdir_edit' => 'Edição do diretório virtual.',
    'virtualdirs_remove' => 'Remoção de diretórios virtuais.',
    'web_users' => 'Gerenciamento de usuários da web do domínio.',
    'web_users_preferences' => "Configurações de usuário da web adicionais.",
    'wu_edit' => 'Definir senhas de FTP para o usuário da web.',
    'lang' => 'Defina o idioma da interface-padrão nesta página.',
    'ch_pass' => "Altere senha do Administrador nesta página.",
    'dns_template' => 'Gerenciamento de modelo de zona DNS.', //to remove
    'dns_template_add' => 'Adicionar um registro ao modelo de zona DNS.', //to remove

    'dns_t' => 'Esta tela mostra os registros de recursos no modelo de zona DNS em todo o servidor.',
    'dns_t_add' => 'Adicionar um registro ao modelo de zona DNS.',
    'dns_t_soa' => 'Definição de configurações de SOA.',
    'dns_t_rec_edit' => 'Editar um registro de recursos.',
    'dns_t_rec_remove' => 'Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.',
    'dns_t_default' => 'Restaurar o modelo de zona DNS.',
    'b_to_dns_t' => 'Retornar para a lista de registros de modelos DNS.',

    'web_app_add' => 'Adicionar um aplicativo Java.',

    'qu_edit' => 'Página de configuração da fila.',
    'qus' => 'Esta página exibe uma lista de filas.',

    'remove_modules' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeServers' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeCerts' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeMailAliases' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeDataBases' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeDataBaseUsers' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeCrontabTask' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeDomains' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeDNS' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeClients' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeLogFiles' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeDumps' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeMailNames' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeWebUsers' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeSessions' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeTemplates' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeIPAddress' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'removeClientsIP' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",

    'cat_remove' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'pr_remove' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'qu_remove' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",

    'pr_edit' => 'Configuração de prioridade.',
    'prs' => 'Esta página lista as prioridades.',

    'spamassassin' => 'Configurações do SpamAssassin.',
    'spamassassin_train' => 'Formação de bancos de dados de estatísticas usados para filtragem bayesiana. Classificar conteúdo da sua caixa de correio como spam e e-mail bom.',
    'spamassassin_train_view_message_source' => 'Clique para ver origem das mensagens.',
    'spamassassin_user_conf' => 'Definição de configurações pessoais do SpamAssassin.',
    'spaw' => 'Editor de HTML.',
    'upload_dump' => "Selecione um arquivo de backup e clique em 'Upload' para fazer o upload do arquivo para o armazenamento. Para fazer o upload de um backup multivolume, especifique a primeira parte do volume e, em seguida, clique no link 'Especifique o próximo volume' e especifique o próximo volume. Repita até que você tenha especificado todos os volumes do backup. Ao terminar, clique em 'Upload'.",
    'subdom_performance' => 'Configuração de desempenho do subdomínio.',

    'dom_performance_edit' => 'Configuração de desempenho do domínio.',
    'dom_performance_readonly' => 'Visualização da configuração de desempenho do domínio.',

    //===============List table header conhelp==================//

    'l_inv' => 'Inverter seleção das caixas de seleção.',
    'l_rad' => 'Selecione o botão de opção.',

    'b_wizard_prev' => 'Retornar para a etapa anterior do assistente.',
    'b_wizard_next' => 'Ir para a próxima etapa do assistente.',
    'b_finish' => 'Aplicar as alterações feitas nesta tela e sair do assistente.',

    // pacif add

    'b_backup_ftp_settings' => 'Clique para especificar as configurações da conta FTP.',
    'b_backup_scheduled_settings' => 'Clique para configurar a programação de backup.',
    'b_backup_ftp_not_configured' => 'A conta FTP não está configurada.',
    'backup_client_front' => 'Fazer backup e restaurar contas de usuário e configurar a programação de backup.',
    'backup_domain_front' => 'Fazer backup e restaurar sites e configurar a programação de backup.',
    'backup_client_new' => 'Fazer backup de uma conta de usuário.',
    'backup_domain_new' => 'Fazer backup de um site.',
    'backup_ftp_settings' => 'Especifique as configurações para a conta de FTP que será utilizada como um armazenamento remoto.',

    'backup_overwrite' => 'Marque a caixa de seleção para confirmar a substituição e clique em OK para remover o arquivo.',
    'b_backup_file_overwrite' => 'Clique para substituir o arquivo de backup existente por um novo.',
    'b_backup_file_overwrite_cancel' => 'Clique aqui para cancelar a substituição do arquivo e retornar à configuração das propriedades de backup.',
    'b_backup_cancel' => 'Clique para interromper o processo de backup.',

    'b_backup_cancel_creating' => 'Clique para cancelar a criação de backup e retornar à página anterior.',
    'b_backup_cancel_ftp_settings' => 'Clique para descartar as configurações de conta FTP e retornar à tela anterior.',
    'b_restore_cancel' => 'Interromper restauração.',
    'backup_progress' => 'Exibição do progresso de backup. Clique em Cancelar para interromper o processo de backup.',
    'restore_progress' => 'Exibição do progresso de restauração. Clique em Cancelar para continuar a restauração.',
    'b_backup_new_restore' => 'Iniciar restauração.',
    'b_restore_cancel_creating' => 'Clique para cancelar a restauração e retornar à página anterior.',
    'b_backup_file_delete' => 'Clique para excluir o arquivo de backup.',
    'backup_delete' => 'Marque a caixa de seleção para confirmar a remoção de arquivos de backup e clique em OK.',
    'backup_result' => 'Depois de visualizar os resultados de backup, clique em OK para completar e retornar ao Gerenciador de Backup.',
    'backup_restore_results' => 'Depois de visualizar os resultados de restauração, clique em OK para retornar ao Gerenciador de Backup.',

    'i_backup_domain_can_restore' => 'Este domínio pode ser restaurado.',
    'i_backup_domain_exist_other_client' => 'Este domínio não pode ser restaurado porque não há outro domínio com esse nome que pertence a outro usuário.',
    'backup_failed' => 'Falha no backup.',
    'backup_stop' => 'Clique em OK para interromper o processo de backup. Clique em Cancelar para continuar o backup.',
    'restore_stop' => 'Clique em OK para interromper a restauração. Clique em Cancelar para continuar a restauração.',
    'backup_info_domain' => 'Para restaurar os dados deste arquivo de backup, clique em Próximo >>.',
    'backup_info_domain_restore' => 'Para restaurar os dados deste arquivo de backup, clique em Restaurar.',
    'backup_info_client' => 'Para restaurar os dados deste arquivo de backup, selecione os itens necessários e clique em Próximo>>.',
    'backup_ip_mapping_domain' => 'Mapear o endereço IP registrado no arquivo de backup para outros endereços IP disponíveis.',
    'backup_ip_mapping_client' => 'Mapear os endereços IP registrados no arquivo de backup para endereços IP disponíveis.',
    'backup__db_server_mapping' => 'Selecione o servidor de banco de dados configurado no Plesk no qual você deseja mapear o servidor de banco de dados de backup.',

    'b_restore_ip_mapping' => 'Clique para definir o mapeamento de IP para a restauração.',
    'learn_more' => 'Leia mais sobre esse novo recurso.',
    'try_new_feature' => 'Experimente este novo recurso!',
    'whats_new_full' => 'Uma descrição detalhada dos novos recursos e alterações neste lançamento.',
    'b_migration_dump_all' => 'Migrar todas as contas do host remoto.',
    'i_migration_not_exist_account' => 'Esta conta pode ser migrada.',
    'i_migration_exist_account' => "Esta conta não pode ser migrada: ela já está em {$PROD_NAME}",
    'i_migration_not_exist_domain' => 'Este domínio pode ser migrado.',
    'i_migration_exist_domain' => "Este domínio não pode ser migrado: ela já está em {$PROD_NAME}",
    'i_migration_bad_domain' => 'Este domínio não pode ser migrado: o nome de domínio é inválido',
    'i_migration_con_exist_domain' => 'Alguns dos domínios já foram migrados para esta conta.',
    'i_migration_all_domain_exist' => "Somente as informações de conta serão migradas: todos os domínios relacionados a esta conta já estão em {$PROD_NAME}",
    'migration_upload' => 'Selecione a plataforma de origem, especifique o nome de host de origem e as credenciais para login e clique em Avançar para carregar o agente de migração para o host.',
    'migration_progress' => 'Veja o andamento da migração e interrompa a migração se desejado.',
    'b_migration_host_info' => 'Ver informações sobre o host remoto e selecionar objetos para migração.',
    'b_migration_single_info' => 'Você tem uma opção para importar todos os dados do despejo ou selecionar os objetos a serem importados. A partir desta página também é possível definir as configurações de implantação.',
    'migration_content_download' => 'Veja o conteúdo de progresso do download e interrompa o download se desejado.',
    'migration_content_download_not_space' => 'Não há espaço em disco para fazer o download do conteúdo do host remoto.',
    'migration_objects_select' => 'Selecione as contas e domínios para migração.',
    'migration_account_select' => 'Selecione a conta de usuário no Plesk na qual você deseja migrar os domínios selecionados.',
    'migration_ip_mapping' => 'Selecione o endereço IP no Plesk no qual deseja mapear os endereços IP do host remoto.',
    'migration_stop' => 'Selecione o checkbox para confirmar a parada do processo de migração e remover o cliente de migração do host remoto, e clique OK.',
    'migration_result' => 'Depois de visualizar os resultados da migração, clique em Concluir para completar.',
    'migration_failed' => 'Falha na migração.',
    'b_migrate' => 'Iniciar migração.',
    'b_migrate_cancel' => 'Interromper o processo de migração.',
    'b_migration_reload' => 'Clique para atualizar os dados.',
    'b_migrate_domains' => 'Clique para migrar os domínios selecionados.',
    'b_migrate_accounts' => 'Clique para migrar as contas selecionadas.',
    'b_migrate_set_accounts' => 'Clique para definir contas para migração de objeto.',
    'b_migrate_set_ip_map' => 'Clique para definir o mapeamento de IP para a migração de objeto.',
    'b_migrate_set_db_server_map' => 'Clique para definir o mapeamento para os bancos de dados migrados.',
    'b_migration_begin' => 'Clique para começar uma nova migração.',
    'b_migration_more' => 'Clique para migrar mais objetos deste host.',
    'b_migration_retry' => 'Clique para continuar a migração após ter liberado o espaço em disco.',
    'b_migration_ignore' => 'Clique para continuar a migração de qualquer maneira.',
    'b_migrate_single' => 'Migração de host único.',

    'b_migration_session_add' => 'Clique para criar uma sessão de migração.',
    'b_to_migration_manager' => 'Retornar para a lista de sessões de migração.',
    'b_to_ip_map_page' => 'Retornar para o mapeamento de IP.',
    'migration_upload_ipmap_file' => 'Fazer upload do arquivo de mapa IP.',
    'b_ipmap_download' => 'Fazer download do arquivo de mapa IP.',
    'b_ipmap_upload' => 'Fazer upload do arquivo de mapa IP.',

    'b_install' => 'Instalar o aplicativo da web',

    'b_sb_menu_desktop' => "Ir à página inicial do administrador de sistema do Presence Builder.",
    'b_sb_menu_users' => "Adicionar e gerenciar contas de usuário e planos de serviço para seus clientes.",
    'b_sb_menu_sites' => "Adicionar e gerenciar sites.",
    'b_sb_menu_server' => "Configurar sistema do Presence Builder.",
    'b_sb_menu_logs' => "Exibir logs de segurança e sistema do Presence Builder.",
    'b_sb_server_configure' => "Configurar integração com o Presence Builder.",
    'sb_server_configure_page_description' => "Especifique o nome de usuário e a senha que o Plesk deve usar para autorização no Presence Builder. Estes nome de usuário e senha devem ser definidos primeiramente no Presence Builder.",
    'b_sb_site_wizard' => "Ir ao Presence Builder para criar e gerenciar sites.",

    'b_connect' => 'Conectar sua conta local a uma conta global.',
    'b_disconnect' => 'Desconectar sua conta local de uma conta global.',
    'b_fi_change_passwd' => 'Alterar a senha para a conta global.',
    'connect' => 'Conectar sua conta local à sua conta global.',
    'disconnect' => 'Desconectar sua conta local da sua conta global.',
    'fi_change_passwd' => 'Alterar a senha de sua conta global.',

    'sapp__no_license_key' => 'Não é possível criar pacotes de aplicativos até que você adicione uma chave de licença ao repositório de chaves de licença',

    'b_dns__tabs_general' => 'Página de configurações DNS gerais.',
    'sessions__tabs_soa_record' => 'Customização do registro de SOA.',

    'packages_preinstall' => 'Configurações de instalação do aplicativo da web.',

    'packages_info_server' => 'Visualização das informações sobre o pacote de aplicativos.',
    'packages_info_domain' => 'Visualização das informações sobre o pacote de aplicativos.',
    'b_to_packages_info' => 'Retornar para a página de informações sobre o pacote.',
    'packages_install' => 'Instalação do pacote de aplicativos.',

    'b_server_app_add' => 'Clicar para ir para a página de instalação de aplicativos do novo servidor.',
    'b_help_install' => 'Iniciar a instalação de aplicativos.',
    'b_help_cancel' => 'Cancelar a instalação de aplicativos.',
    'packages_reconfigure' => 'Reconfiguração de aplicativos do servidor.',
    'packages_remove' => 'Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.',

    'b_packages_management' => 'Gerenciamento de aplicativos do servidor.',
    'packages_management' => 'Esta página permite instalar e remover aplicativos do servidor do servidor.',
    'b_to_packages_management' => 'Retornar para a página de gerenciamento de aplicativos do servidor.',

    'i_ftp_ses_type' => 'O último comando enviado pelo cliente é TYPE.',
    'i_ftp_ses_pass' => 'O último comando enviado pelo cliente é PASS.',
    'i_ftp_ses_noop' => 'O último comando enviado pelo cliente é NOOP.',

    'virtualdirs__remove_submit' => 'Clicar para excluir os diretórios virtuais selecionados. Os diretórios físicos reais não são excluídos.',

    'b_set_skin' => 'Clicar para tornar a skin atual uma skin do Plesk-padrão.',
    'set_skin__already_default' => 'A skin atual já está configurada para ser uma skin de Plesk-padrão.',

    'i_custom_errors_add' => 'Inserir as informações necessárias e clicar para adicionar uma mensagem de erro customizada.',

    'i_antivirus_off' => 'A proteção de antivírus não foi configurada para esta caixa postal.',
    'i_antivirus_on' => 'A proteção de antivírus foi configurada para esta caixa postal.',
    'i_antivirus_turn_pref' => 'Clicar para definir as configurações de proteção antivírus.',
    'i_antivirus_turn_key' => 'A proteção de antivírus não é suportada com a chave de licença atual.',
    'i_antivirus_turn_perm' => 'Você não tem permissões para gerenciar o antivírus.',

    'b_acl_add' => 'clicar para adicionar um endereço para Permitir a ACL (lista de controle de acesso) de Transferência da Zona.',
    'dns_acl' => 'Esta página exibe uma lista de todos os endereços de IP ou Redes para os quais a transferência de zonas é permitida.',

    'i_antivirus_any' => 'A proteção de antivírus foi configurada para os e-mails de entrada e saída.',
    'i_antivirus_from' => 'A proteção de antivírus foi configurada para os e-mails de saída.',
    'i_antivirus_to' => 'A proteção de antivírus foi configurada para os e-mails de entrada.',

    'i_ip_fail_no_interface' => 'A interface associada com o endereço de IP está faltando.',

    'b_test' => 'Teste de conexão.',

    'b_language_groups_add' => 'Adicionar o grupo de idiomas à lista de idiomas confiáveis.',
    'b_language_groups_del' => 'Excluir o grupo de idiomas da lista de idiomas confiáveis.',
    'b_locale_groups_add' => 'Adicionar o grupo de localidades à lista de localidades confiáveis.',
    'b_locale_groups_del' => 'Excluir o grupo de localidades da lista de localidades confiáveis.',
    'spam_trustednetworks_new' => 'Adicionar a rede à lista de redes confiáveis.',
    'spam_trustednetworks_remove' => 'Excluir a rede da lista de redes confiáveis.',


    'i_i_client_on' => 'A conta do cliente está ativa.',
    'i_i_client_off_by_admin' => 'A conta de cliente foi desabilitada pelo administrador.',


    'b_virtualdir_add_disabled' => 'A criação do diretório virtual não está disponível.',

    'b_db_add_disabled' => 'A conexão de seu servidor de banco de dados não foi configurada. Ela pode ser configurada na página Servidor->Banco de dados.',

    'b_databases__change_server_passwd_disabled' => "Você está utilizando o servidor do banco de dados interno do Plesk porque configurou a conexão com a porta 8306. Portanto, a senha deve ser alterada na página Configurações > Alterar Senha.",

    'b_traffic_at_domains' => 'Visualizar as estatísticas nos domínios do servidor.',
    'traffic_at_domains' => 'Estatísticas de tráfego de todos os domínios registrados no sistema.',

    'b_rdp_session__open_new' => 'Abrir uma nova sessão de terminal.',

    'removeDNS_acl' => 'Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.',

    'i_additional_key_installed' => 'A chave está instalada no aplicativo.',
    'i_additional_key_not_installed' => 'A chave não está instalada no aplicativo.',

    'b_unhandlederror_showinfo' => 'Clicar para visualizar informações detalhadas sobre o erro.',
    'b_unhandlederror_hideinfo' => 'Clicar para ocultar as informações adicionais sobre o erro.',
    'b_unhandlederror_submitticket' => 'Clicar para relatar o erro ao serviço de suporte.',
    'unhandlederror' => 'Falha de operação.',

    'permissions' => 'Configuração de permissões do arquivo ou pasta.',

    'permissions_advanced' => 'Configuração de permissões avançados do arquivo ou pasta.',

    'i_conn_strings_add' => 'Clicar e adicionar a string de conexão.',
    'i_conn_strings_add_disabled' => 'A inclusão de strings de conexão está indisponível.',
    'i_conn_strings_del' => 'Clicar e excluir a string de conexão.',
    'i_conn_strings_del_disabled' => 'A exclusão de strings de conexão está indisponível.',

    'dns_acl_remove' => 'Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.',

    'to_interface_management' => "Retornar para a página de gerenciamento de interface.",
    't_locales' => "Clicar para gerenciar os idiomas de interface.",
    't_skins' => "Clique para gerenciar aparências.",
    't_interface_templates' => "Clicar para gerenciar os modelos de interface.",
    'b_locale_make_default' => "Selecionar um pacote de idiomas e clicar para torná-lo padrão.",
    'b_skin_make_default' => "Selecionar uma skin e clicar para torná-la padrão.",

    'wu_limits_exceeding' => "Não é possível criar usuários da web porque o limite para o número de usuários da web suportados está excedido para este domínio.",

    'mail_setenable_off' => 'Este recurso não é suportado pelo servidor de e-mail.',
    'domain_aliases__status_ok' => 'O nome alternativo do domínio está funcionando corretamente.',

    'i_htype_sub_hst' => 'Subdomínio em subpasta.',
    'mail_antivirus' => 'Configurações do antivírus.',

    'dom_new_no_clients' => 'É necessário criar uma conta de cliente antes que você possa adicionar domínios.',

    'dns_t_acl' => 'Configurações da Lista de Controle de Acesso.',

    'dns_t_acl_remove' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",

    'b_sapp_make_default' => "Tornar o aplicativo da web selecionado um aplicativo-padrão",

    'b_ftp_ctrl' => "Gerenciar contas de FTP adicionais sob um domínio.",
    'ftp_ctrl' => "Gerenciamento de contas de FTP adicionais sob o domínio.",
    'b_ftp_user_add' => "Clicar para adicionar uma conta de FTP.",
    'b_ftp_users_limit_reached' => "O limite sobre o número de contas de FTP foi atingido.",
    'ftp_user_edit' => "Configurações da conta de FTP.",
    'ftp_users' => "Gerenciar contas de FTP adicionais sob um domínio.",
    'removeFtpUsers' => "Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.",
    'to_ftp_ctrl' => "Retornar para a página de gerenciamento das contas de FTP.",

    'b_sb_desktop' => "Visão geral das principais funcionalidades do Presence Builder.",
    'b_sb_users' => "Gerenciar as contas de usuário registradas no Presence Builder.",
    'b_sb_sites' => "Adicionar e gerenciar vários tipos de sites do Presence Builder.",
    'b_sb_server' => "Administração do Presence Builder.",
    'b_sb_logs' => "Visualizar os registros do sistema Presence Builder e os logs de segurança.",

    'dns_recursion' => "Gerenciamento de recursão do DNS.",

    'subdom_hst_type_sel' => "Selecionar o tipo de hospedagem a ser configurado para o subdomínio.",

    'i_wu_open_help' => "Clicar para abrir a página de usuário da web no navegador.",

    'i_i_client_off_expired' => "O período de validade para a conta do cliente expirou.",

    'i_antivirus_turn_install' => 'O antivírus não foi instalado ou configurado adequadamente.',

    'b_ftp_users_no_permission' => "Você não tem permissões para gerenciar as contas de FTP adicionais.",

    // Plesk 8 keys

    'b_search' => "Buscar clientes, domínios e contas de e-mail.",

    // services management
    'b_service_showall' => 'Mostrar todos os serviços.',
    'b_service_hideall' => "Ocultar todos os serviços.",
    'b_service_start' => "Iniciar os serviços selecionados.",
    'b_service_stop' => "Interromper os serviços selecionados.",
    'b_service_restart' => "Reiniciar os serviços selecionados.",
    'b_service_disable' => "Desabilitar os serviços selecionados.",
    'b_service_manual' => "Selecionar o tipo de inicialização manual para os serviços selecionados.",
    'b_service_auto' => "Selecionar o tipo de inicialização automática para os serviços selecionados.",
    'i_serv_group_on' => 'Todos os serviços no grupo estão funcionando.',
    'i_serv_group_none' => 'Alguns dos serviços no grupo estão desabilitados ou foram interrompidos.',
    'i_serv_group_off' => 'Todos os serviços no grupo estão desabilitados ou foram interrompidos.',
    'i_serv_key_disabled' => 'O serviço foi desabilitado.',

    // php4v5
    'php' => "Visualizar e alterar as configurações do PHP para o diretório virtual atual.",
    'php_changeversion' => "Configuração do PHP para o diretório atual.",
    'php_dom' => "Alterar as configurações do PHP para o domínio.",
    'php_subdom' => "Alterar as configurações do PHP para o subdomínio.",
    'php_changeversion_dom' => "Configuração do PHP para o domínio.",
    'php_changeversion_subdom' => "Configuração do PHP para o subdomínio.",

    // mass mail
    'b_new_mass_mail_template' => 'Adicione um modelo de mensagem de e-mail em massa',
    'b_massmail_send' => "Envie um e-mail para todos os destinatários selecionados",

    // Other
    'b_additional_key_is_install' => 'Instalar a chave adicional.',
    'i_domain_sitebuilder_disabled' => "O suporte do Presence Builder está desabilitado para este domínio.",
    'i_subdomain_sitebuilder_disabled' => "O suporte do Presence Builder está desabilitado para este subdomínio.",
    'i_subdomain_sitebuilder_wizard' => "Ir para o Assistente do Presence Builder para este subdomínio.",
    'i_domain_sitebuilder_wizard' => "Vá para o Assistente do Presence Builder para este domínio.",
    'sitebuilder_page' => 'Atualmente, você está operando na janela do Presence Builder. Consultar a documentação do Presence Builder para mais informações.',
    'removeFpseUsers' => 'Selecionar a caixa de seleção para confirmar a remoção e Clicar em OK para remover. Clicar em Cancelar para cancelar a remoção.',
    'b_insert' => 'Clique para inserir dados do modelo selecionado em sua mensagem de e-mail em massa',
    'i_spamfilter_turn_install' => 'O filtro de spam não foi instalado.',

    // help desk

    // 8.2

    // other

    'b_db_preferences' => 'Alterar os parâmetros de conexão do banco de dados',
    'b_disabled_hosting' => 'Este recurso não está disponível porque a hospedagem física não está configurada',
    'net_apps' => 'Gerenciar os aplicativos da web do ASP.NET 1.1',
    'site_apps' => "Gerenciar os aplicativos da web padrão",

    'b_default_cert' => 'Utilizar o certificado selecionado para proteger as conexões para websites hospedados recentemente.',
    'b_setup_cp' => 'Usar o certificado selecionado para proteger as conexões para o Plesk',
    'b_to_actionlog' => 'Retornar para o registro de ação.',

    // 8.3

    'additional_key_update' => 'Status da atualização ou recuperação da chave adicional',
    'admin_alias_password_update' => 'Confirmar a alteração da senha',
    'removeTasks' => "Confirmar a remoção das tarefas selecionadas e clicar em OK",

    'b_license_key_remove' => 'Clique para remover a chave de licença.',
    'fi-attach' => 'Especificar a conta global à qual você deseja se conectar.',
    'fi-detach' => 'Confirme a desconexão da conta local atual de uma conta global e clique para desconectar.',
    'fi-update' => 'Atualizar as configurações da conta global.',

    // 8.4
    // RESELLERS
    'b_resellers' => 'Gerenciar contas de revendedor',
    'i_reseller_on' => "Esta conta de usuário está ativa.",
    'i_reseller_off_by_parent' => "Esta conta de usuário foi suspensa pelo provedor de serviços.",
    'i_reseller_off_by_expired' => "O prazo para assinatura para esta conta de usuário expirou.",
    'i_reseller_off_backup_restore' => "Esta conta de usuário foi temporariamente suspensa para fazer backup ou restaurar dados.",
    'i_reseller_ok' => "O uso de recursos do revendedor está dentro dos limites.",
    'i_reseller_cp_access_on' => "O acesso ao Plesk é permitido para o revendedor.",
    'i_reseller_cp_access_off' => "O acesso ao Plesk não é permitido para o revendedor.",
    'i_click_to_reseller_cp_access_on_off' => "Clique para permitir ou proibir o acesso ao Plesk para o revendedor.",

    // CLIENTS (upgraded for resellers)

    // 'upgradeclients__submit_update' => 'Click',
    'b_upgradeClients__cancel_upgrade' => 'Descartar todas as alterações e retornar à página anterior.',
    'b_upgradeClients__submit_upgrade' => 'Clicar para converter contas de clientes elegíveis em contas de revendedores.',
    'b_upgradeDomainUser__cancel_upgrade' => 'Descartar todas as alterações e retornar à página anterior.',
    'b_upgradeDomainUser__submit_upgrade' => 'Clicar para converter contas de administrador de domínio elegíveis em contas de clientes.',

    //APS Catalog
    'b_hide_updates' => "Ocultar atualizações.",
    'b_show_updates' => "Mostrar atualizações.",
    'b_add_to_vault' => "Adicione os aplicativos selecionados ao Application Vault.",

    // new and unsorted
    'b_to_server_interface' => "Retornar para a lista de aparências disponíveis.",
    'b_skin_edit' => "Editar descrição de skin.",
    'b_to_phosting_setup' => "Retornar para configurações de hospedagem.",
    // Hosting setup redesign
    'b_dom_hosting_update' => "Salvar configurações de hospedagem.",
    'b_downgradeResellers__submit_downgrade' => "Clique para concluir a operação.",
    'b_rs_pool_add' => "Alocar endereços IP para o revendedor.",
    'b_cl_pool_add' => "Alocar endereços IP para o cliente.",
    'b_ippoolManager__no_available_ips' => "Não há endereços IP vagos no pool de IP.",
    'b_ip_already_added_to_all_clients' => "Este endereço IP já está em pools de IP de todos os usuários.",

    // SERVER/SETTINGS
    'b_change_hostname_conhelp' => 'Alterar nome do servidor.',
    'b_setup_firewall_conhelp' => 'Configurar firewall para proteger o servidor.',
    'b_setup_firewall_none_available_conhelp' => 'A funcionalidade de firewall não está disponível: firewall não está instalado.',
    'b_manage_firewall_rules_conhelp' => 'Criar, editar e remover regras de firewall.',
    'b_manage_firewall_rules_none_available_conhelp' => 'A funcionalidade de firewall não está disponível: firewall não está instalado.',
    'b_select_dns_server_conhelp' => 'Selecionar o software do servidor de DNS que deve ser utilizado pelo servidor e gerenciado pelo Plesk.',
    'b_select_dns_server_none_available_conhelp' => 'Nenhum outro servidor de DNS está disponível.',
    'b_soa_records_template_conhelp' => 'Configurar registros SOA que serão usados como modelo ao criar a zona DNS para domínios.',
    'b_dns_recursion_conhelp' => 'Configurar definições de recursão de DNS que serão usadas como modelo ao criar a zona DNS para domínios.',
    'b_restrict_creation_of_subzones_conhelp' => "Restringir a criação de subzonas DNS em outras superzonas DNS dos usuários",
    'b_select_mailserver_conhelp' => 'Selecionar o software do servidor de e-mail que deve ser utilizado pelo servidor e gerenciado pelo Plesk.',
    'b_select_mailserver_none_available_conhelp' => 'Nenhum outro servidor de e-mail está disponível.',
    'b_select_antivirus_conhelp' => 'Selecionar o software do antivírus que deve ser utilizado pelo servidor e gerenciado pelo Plesk.',
    'b_select_antivirus_none_available_conhelp' => 'Nenhum outro programa de antivírus está disponível.',
    'b_virus_protection_settings_conhelp' => 'Configurar configurações de proteção de vírus em todo o servidor.',
    'b_select_spamfilter_conhelp' => 'Selecionar o software de filtragem de spam que deve ser utilizado pelo servidor e gerenciado pelo Plesk.',
    'b_select_spamfilter_none_available_conhelp' => 'Nenhum outro programa de filtragem de spam está disponível.',
    'b_select_webmail_conhelp' => 'Selecione o software de webmail que deve estar disponível para os usuários de e-mail.',
    'b_select_webmail_none_available_conhelp' => 'Nenhum outro programa de webmail está disponível.',
    'b_server_statistics_settings_conhelp' => 'Selecionar o que deve ser incluído nos cálculos das estatísticas de todo o servidor.',
    'b_select_ssl_certificate_conhelp' => 'Selecione o certificado SSL/TLS a ser usado para proteger seu domínio.',
    'b_select_ssl_certificate_none_available_conhelp' => 'É necessária hospedagem na web para ter acesso a esse recurso.',
    'b_select_web_statistics_conhelp' => 'Selecionar o software de estatísticas da web que deve estar disponível para os proprietários de domínios.',
    'b_select_web_statistics_none_available_conhelp' => 'Nenhum outro programa de estatística da web está disponível.',
    'b_interface_management_conhelp' => 'Configure várias opções de interface do Plesk.',
    'b_setup_vpn_conhelp' => 'Configurar o acesso ao VPN no servidor.',
    'b_setup_vpn_none_available_conhelp' => 'O módulo de acesso ao VPN não está instalado.',
    'b_setup_samba_conhelp' => 'Configurar o acesso ao samba no servidor.',
    'b_setup_samba_none_available_conhelp' => 'O módulo de acesso ao samba não está instalado.',

    // DOMAIN/SETTINGS
    'b_account_settings_conhelp' => 'Exibir e alterar suas configurações de conta.',
    'b_dns_soa_records_conhelp' => 'Exibir e alterar registros DNS SOA para seu domínio.',
    'b_task_scheduler_settings_conhelp' => 'Configurar o agendador de tarefas para seu domínio.',
    'b_task_scheduler_settings_none_available_conhelp' => 'É necessária hospedagem na web para ter acesso a esse recurso.',
    'b_web_users_scripting_conhelp' => 'Permitir ou proibir os usuários da web de usar scripts.',
    'b_web_statistics_conhelp' => 'Exibir estatísticas de visitantes para o seu domínio.',
    'b_log_rotation_settings_conhelp' => 'Configurar rotação de logs em seu domínio.',

    // navbar
    'b_mailnames' => 'Ir para a lista de contas de e-mail.',
    'b_applications' => 'Ir para a lista de aplicativos da web.',
    'b_settings' => 'Configurar uma variedade de configurações.',

    // templates
    'i_tmpl__shared_template' => 'Este modelo foi feito por seu provedor de hospedagem. Ele pode ser usado por você, desde que seu provedor de hospedagem o esteja compartilhando.',
    'i_tmpl__owned_template' => 'Este modelo foi feito por você. Ele pode ser usado por você e seus usuários, se você permitir.',

    'b_load' => 'Carregar mensagem do modelo salvo anteriormente.',

    'b_sh_ip_add' => 'Adicionar o endereço de IP à lista de endereços de IP compartilhados',
    'b_sh_ip_del' => 'Remover o endereço de IP da lista de endereços de IP compartilhados',
];