<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'cgroups.size' => 'Valor inválido: "%value%". O valor deve ser igual ou maior que %unitMin%, menor ou igual a %unitMax% e não pode ser 0.',
    'cgroups.unlimited' => 'Ilimitado',
    'cgroups.period' => 'Valor inválido: "%value%". O valor deve ser 5 minutos, uma hora ou dia, especificados em segundos (300, 3600 ou 86400).',

    'file.fileIsImageFalseType' => 'O arquivo que você está tentando efetuar upload não é uma imagem.',
    'file.fileUploadErrorIniSize' => 'O arquivo que você está tentando efetuar upload excede o tamanho ini definido.',
    'file.fileUploadErrorFormSize' => 'O arquivo que você está tentando efetuar upload excede o tamanho de forma definido.',
    'file.fileUploadErrorPartial' => 'O upload do arquivo foi efetuado parcialmente.',
    'file.fileUploadErrorNoFile' => 'O upload do arquivo não foi efetuado.',
    'file.fileUploadErrorNoTmpDir' => 'Nenhum diretório temporário foi encontrado para o arquivo que você esta tentando efetuar upload.',
    'file.fileUploadErrorCantWrite' => 'O arquivo que você está tentando efetuar upload não pode ser editado.',
    'file.fileUploadErrorExtension' => 'A extensão retornou um erro durante o upload do arquivo.',
    'file.fileUploadErrorAttack' => 'O arquivo foi carregado ilegalmente; isto pode ter sido uma tentativa de invasão.',
    'file.fileUploadErrorFileNotFound' => 'O arquivo que você está tentando efetuar upload não foi encontrado.',
    'file.fileUploadErrorUnknown' => 'Ocorreu um erro desconhecido durante o upload do arquivo.',
    'file.fileExtensionFalse' => 'O arquivo cujo upload você está tentando efetuar tem uma extensão não permitida.',
    'file.fileExistsDoesNotExist' => 'O arquivo ou diretório especificado não existe.',

    'hostname.hostnameIpAddressNotAllowed' => "'%value%' parece ser um endereço IP, porém endereços IP não são permitidos",
    'hostname.hostnameUnknownTld' => "'%value%' parece ser um nome de host de DNS, porém não é possível fazer a correspondência do TLD contra lista conhecida",
    'hostname.hostnameDashCharacter' => "'%value%' parece ser um nome de host de DNS, mas contém um traço (-) em uma posição inválida",
    'hostname.hostnameInvalidHostnameSchema' => "'%value%' parece ser um nome de host de DNS, mas não pode ser equivalente ao esquema de nomes de host para TLD '%tld%'",
    'hostname.hostnameUndecipherableTld' => "'%value%' parece ser um nome de host de DNS, porém não é possível extrair a parte de TLD",
    'hostname.hostnameInvalidHostname' => "'%value%' não corresponde à estrutura esperada para um nome de host de DNS",
    'hostname.hostnameInvalidLocalName' => "'%value%' não parece ser um nome válido de rede local",
    'hostname.hostnameLocalNameNotAllowed' => "'%value%' parece ser um nome de rede local, porém nomes de redes locais não são permitidos",

    'port.notBetween' => 'O valor da porta especificada é inválida. Deve estar entre 1 e 65535, inclusive.',

    'dns.invalidSoaValue' => 'O valor é inválido. Ele pode ser de 1 segundo a 68 anos.',

    'isEmpty' => 'Este campo obrigatório está vazio. Você precisa especificar um valor.',
    'stringLengthTooShort' => "'%value%' tem menos de %min% caracteres.",
    'stringLengthTooLong' => "'%value%' tem mais de %max% caracteres.",
    'regexNotMatch' => "'%value%' não corresponde ao padrão '%pattern%'.",
    'notAlnum' => "'%value%' tem caracteres não alfanuméricos. Certifique-se de utilizar somente caracteres alfanuméricos.",
    'alnumStringEmpty' => "O valor está vazio.",
    'stringEmpty' => "'%value%' está vazio.",
    'loginSyntax' => 'Você pode utilizar símbolos alfanuméricos, traço, ponto e sublinhado no nome do usuário. O nome do usuário deverá começar com um símbolo alfabético ou um número.',
    'loginExists' => 'A conta de usuário %value% já existe.',
    'cu_admin_alias__login_exists' => 'A conta de usuário já existe.',
    'loginPassword' => 'A senha não poderá conter o nome do usuário.',
    'passwordSyntax' => 'A senha contém caracteres que não são permitidos.',
    'passwordLength' => 'A extensão da senha deve ter entre %minLength% e %maxLength% caracteres.',
    'domain_invalid_name' => 'O nome do domínio especificado não é válido. É preciso especificar um nome de domínio válido como domain.com.',
    'dns_domain_invalid_name' => 'O nome de domínio especificado não é válido.',
    'dns_domain_template_invalid_name' => 'O modelo de nome de domínio especificado não é válido.',
    'not_ascii_string' => 'O valor deve ser uma string ASCII válida e não deve conter os seguintes caracteres: %value%.',
    'not_printable_string' => 'O valor não deve incluir nenhum caractere não imprimível.',
    'invalid_locale' => "O idioma de interface especificado '%value%' não está disponível ou não está instalado.",
    'virtual_directory_name_invalid' => 'Use apenas caracteres alfanuméricos, sublinhado e traço no nome do diretório.',
    'virtual_directory_name_reserved' => 'Este nome está reservado.',
    'virtualDirectoryAlreadyExists' => 'Já existe um diretório com o mesmo nome.',
    'virtualDirectoryPathIsInvalid' => 'O caminho físico é inválido ou não existe.',
    'virtualDirectoryErrorDocFileLocation' => 'O local do arquivo é inválido.',
    'virtualDirectoryErrorDocAbsoluteUrl' => 'Formato de URL errôneo. Inserir uma URL absoluta no host virtual (site).',
    'invalid_city_name' => 'O nome da cidade inserido não é válido',
    'invalid_country_code' => 'Código de país inválido',
    'not_specified_country_code' => 'País é um campo obrigatório e deve ser especificado explicitamente.',
    'invalid_system_user_login' => 'O login do usuário do sistema é inválido',
    'invalid_rfc_domain_name' => 'O nome de domínio especificado não é um domínio RFC válido',
    'idn_name_conversion' => 'Falha ao converter nome de domínio de IDN para Punycode',
    'domain_label_too_long' => 'Nenhuma das partes do nome do domínio pode exceder 63 caracteres de comprimento.',
    'domain_label_too_long_idn' => 'O domínio usa um nome de domínio internacionalizado. Nenhuma das partes de seu nome, quando convertida para Punycode, pode exceder 63 caracteres de comprimento.',
    'domain_starts_with_www' => 'Insira o nome de um domínio sem o prefixo \'www\'. O prefixo www para o domínio será automaticamente adicionado à configuração do servidor da web.',
    'domain_already_exists' => 'Esse nome de domínio já existe.',
    'domain_without_www_already_exists' => 'Este nome de domínio já existe sem o prefixo \'www\'.',
    'domain_with_www_already_exists' => 'Este nome de domínio já existe com o prefixo \'www\'.',
    'subdomain_conflicts_with_existing_domain' => 'Há um domínio com o mesmo nome do subdomínio \'%value%\'.',
    'restrict_domain_creation' => 'O nome de domínio especificado é proibido pela política de todo o servidor. Entre em contato com seu provedor de hospedagem, se este domínio lhe pertencer.',
    'dns_record_already_exists' => 'Este registro de DNS já existe.',
    'domain_like_hostname' => 'O nome do domínio é o mesmo que o nome de host do servidor.',
    'passwordsNotMatch' => 'As senhas inseridas não são iguais.',
    'stringsNotEqual' => 'Os valores não são iguais.',
    'equalMailAliases' => 'O nome alternativo especificado é o mesmo de outro endereço de e-mail.',
    'mailAliasExist' => 'O nome alternativo do e-mail especificado já existe.',
    'mailNameExist' => 'O endereço de e-mail especificado já existe.',
    'mailListExist' => 'O endereço especificado já está atribuído a uma mala direta.',
    'mailAutoReplyHeadersSpaceError' => "Os cabeçalhos de resposta automática não devem conter espaço",
    'mailAutoReplyHeadersInvalidValueError' => 'Alguns campos estão vazios ou contêm um valor incorreto.',
    'sysUserExist' => 'O nome de usuário especificado já é utilizado por outro usuário do sistema. Especifique outro nome de usuário.',
    'emailAddressInvalid' => 'O endereço de e-mail especificado não é válido. Especifique um válido que corresponda ao seguinte padrão: joao@exemplo.com.',
    'emailAddressInvalidLocal' => 'O endereço de e-mail especificado não é válido. O endereço de e-mail deve pertencer ao domínio selecionado. Somente o administrador pode especificar os endereços de e-mail externos neste caso.',
    'emailAddressSpecialNames' => 'O endereço de e-mail especificado é inválido. A parte do endereço com o nome do usuário não deve começar com um nome de sistema reservado (como con, lpt1, prn) separado por um ponto (.) do resto do nome do usuário.',
    'dkimSelectorInvalid' => 'O seletor DKIM especificado não é válido: %value%',
    'longAddress' => 'O endereço de e-mail é muito longo.',
    'longMailboxAddressMailServer' => 'A parte do nome de usuário do endereço de e-mail é muito longa para este servidor de e-mail. Especifique um nome de usuário com até %%max%% símbolos.',
    'longFullAddressMailServer' => 'O endereço de e-mail é muito longo para este servidor do e-mail. Especifique um endereço com até %%max%% símbolos.',
    'dir_invalid_name' => 'Diretório de destino inválido.',
    'directoryHidesDomain' => 'Este diretório não pode ser utilizado pois ele iria sobrepor o web site localizado em %path%. Essa sobreposição tornaria o web site indisponível.',
    'directoryHidesAnotherApplication' => 'Este diretório não pode ser utilizado pois ele iria sobrepor outro aplicativo instalado em %path%. Essa sobreposição tornaria o aplicativo instalado indisponível.',
    'directoryIsBehindAnotherApplication' => 'Este diretório não pode ser utilizado pois ele iria sofrer sobreposição de outro aplicativo instalado em %path%. Essa sobreposição tornaria o aplicativo indisponível.',
    'domainLoginSyntaxWindows' => 'O nome de usuário deve começar com um caractere alfabético e não pode exceder %%maxlength%% caracteres de comprimento. Todos, exceto os primeiros caracteres, podem ser alfanuméricos minúsculos, o traço, o ponto e o sublinhado. O nome de usuário não pode terminar com um ponto.',
    'domainLoginSyntaxUnix' => 'O nome de usuário não deve ter mais do que %%maxlength%% caracteres e conter apenas caracteres alfanuméricos minúsculos, traço e sublinhado. O nome de usuário deve começar com um caractere alfabético minúsculo',
    'notLocalMssqlHost' => 'Não é um nome de host MSSQL local',
    'invalidMailTo' => 'Não é um mailto: link válido',
    'passwordsNotEqual' => 'As senhas inseridas não são iguais.',
    'passwordPolicy' => '%policyError%',
    'fileImageSizeWidthTooBig' => "A imagem '%value%' que você está tentando efetuar upload é muito larga ('%width%'). Imagens transferidas via upload não podem ser mais largas do que '%maxwidth%'.",
    'fileImageSizeWidthTooSmall' => "A imagem '%value%' que você está tentando efetuar upload não é suficientemente larga ('%width%'). Imagens transferidas via upload deverão ter largura mínima de '%minwidth%'.",
    'fileImageSizeHeightTooBig' => "A altura da imagem '%value%' que você está tentando efetuar upload é muito grande ('%height%'). Imagens transferidas via upload não podem exceder '%maxheight%' de altura.",
    'fileImageSizeHeightTooSmall' => "A altura da imagem '%value%' que você está tentando efetuar upload é muito pequena ('%height%'). As imagens transferidas via upload não podem ter altura inferior a '%minheight%'.",
    'fileImageSizeNotDetected' => "O tamanho da imagem '%value%' que você está tentando efetuar upload não pôde ser detectado.",
    'fileImageSizeNotReadable' => "A imagem '%value%' que você está tentando efetuar upload não pode ser lida.",
    'passwordConfirmation' => 'Confirmar senha',
    'databaseUserNameExists' => 'Um nome de usuário do banco de dados com o nome %value% já existe.',
    'invalidUserName' => 'O nome do usuário do banco de dados contém caracteres não permitidos.',
    'longUserName' => 'O nome do usuário da base de dados é maior que %%max%% caracteres.',
    'forbiddenName' => 'O nome de usuário do banco de dados "%value%" não é permitido.',
    'invalidAdminLogin' => 'Impossível utilizar as credenciais do usuário selecionado para acesso de administrador. O nome de usuário especificado é inválido: %%cause%%',
    'invalidAdminPassword' => 'Impossível utilizar as credenciais do usuário selecionado para acesso de administrador. A senha especificada é inválida: %%cause%%',
    'passwordLengthTooShort' => "a senha é menor do que %min% caracteres.",
    'passwordLengthTooLong' => "a senha é maior do que %max% caracteres.",
    'passwordRegexNotMatch' => "a senha não corresponde ao padrão '%pattern%'.",
    'fileSharingEmptyFolderName' => "Você precisa especificar um nome de pasta.",
    'fileSharingInvalidFolderName' => "O nome da pasta especificada não é válido. Ele não pode conter os caracteres a seguir: \\ / : * ? \" < > |",
    'fileSharingFolderExists' => "Não é possível criar uma pasta com o nome especificado porque já existe uma pasta com esse nome.",
    'invalidUrl' => 'O endereço especificado não é válido. É preciso especificar um endereço válido como http://domain.com.',
    'domainVirtualdirectoryReservedName' => 'Este nome de diretório está reservado Especifique outro nome para o seu diretório virtual.',
    'domainVirtualdirectoryInvalidName' => 'Um nome de diretório deverá conter somente caracteres alfanuméricos, sublinhado e traço.',
    'filesharingPathUnavailable' => 'Um diretório com esse nome já existe sob o domínio especificado. Use outro nome de diretório.',
    'filesharingSslNotAvailableOnDomain' => 'Você selecionou usar links seguros mas o domínio não tem nenhum SSL/TLS habilitado. Selecione um domínio com suporte ao SSL/TLS ou desmarque as caixa de seleção Gerar links seguros.',
    'filesharingSslRedirectOnDomain' => 'O domínio selecionado tem a opção "Permanent SEO-safe 301 redirecionar de HTTP para HTTPS" ativada. Para configurar o compartilhamento de arquivos, selecione um domínio que tenha essa opção desativada ou marque a caixa de seleção "Gerar links seguros para arquivos e pastas".',
    'filesharingSslNotAvailableOnDefaultDomain' => 'Você selecionou usar links seguros no endereço de IP ou nome do host do servidor, mas esses links podem ser criados somente em websites com suporte para SSL/TLS. Configure um website com suporte a SSL/TLS ou desmarque as caixa de seleção Gerar links seguros.',
    'filesharingDefaultDomainSelectedOnServerIp' => 'Você selecionou o endereço IP do servidor para o qual um domínio-padrão está atribuído. Selecione um web site como URL raiz em vez do endereço IP.',
    'physicalPathOnDomainAlreadyExists' => 'Um diretório com esse nome já existe.',
    'virtualPathOnDomainAlreadyExists' => 'Um diretório virtual com esse nome já existe.',
    'sysUserLoginSyntaxWindows' => 'Você pode usar símbolos alfanuméricos, traço (-), ponto (.) e sublinhado (_) no nome do usuário. O nome do usuário deve começar com um símbolo alfanumérico.',
    'sysUserLoginSyntaxUnix' => 'Você pode usar símbolos alfanuméricos minúsculos, traço (-), ponto (.) e sublinhado (_) no nome do usuário. O nome do usuário deve começar com um símbolo alfanumérico.',
    'docrootNotInWebspaceRoot' => 'O diretório especificado não está localizado dentro do diretório raiz da assinatura.',
    'docrootContainsSpecialCharacters' => 'O nome de diretório especificado contém símbolos que não podem ser utilizados.',
    'docrootWithinProhibitedDirectory' => 'O diretório especificado contém um diretório de serviço.',
    'docrootWithinInstalledApplication' => 'O diretório especificado sofre sobreposição de um aplicativo web instalado em %path%.',
    'docrootIsNotDirectory' => 'O caminho especificado não pode ser usado porque sua parte se refere a um arquivo.',
    'docrootTooLongPart' => 'O nome do diretório especificado é muito longo.',
    'subdomainWrongName' => '%errorDescription%',
    'subdomainWrongDomain' => 'Um domínio incorreto foi selecionado.',
    'domainAliasWrongName' => '%errorDescription%',
    'phoneRegexNotMatch' => 'Um número de telefone incorreto foi especificado, ele continha símbolos não permitidos.',
    'stateInvalid' => 'Um estado incorreto foi especificado.',
    'zipRegexNotMatch' => 'Um código postal ou CEP incorreto foi especificado.',
    'limitValueInvalid' => 'Um valor de limite incorreto foi especificado.',
    'softLimitValueInvalid' => 'O valor deve estar na faixa %%MIN%%..%%MAX%%.',
    'outgoingMessagesLimitValueInvalid' => 'O valor deve estar na faixa %%MIN%%..%%MAX%%. Somente o administrador do Plesk pode ajustar essa configuração.',
    'limitMssqlDatabaseFileSizeValueInvalid' => 'O tamanho de um arquivo do banco de dados MS SQL deve ser um número inteiro entre 0 e 16 TB.',
    'limitMssqlDatabaseLogFileSizeValueInvalid' => 'O tamanho de um arquivo do banco de dados MS SQL deve ser um número inteiro entre 0 e 2 TB.',
    'limitDiskspaceValueInvalid' => 'O limite de espaço em disco deverá ficar entre 0 e 4095 TB.',
    'limitTrafficValueInvalid' => 'O limite de tráfego deverá ficar entre 0 e 4095 TB/mês.',
    'limitMboxQuotaValueInvalid' => 'O limite de tamanho da caixa postal deverá ficar entre 0 e 4095 TB.',
    'limitRetainPeriodValueInvalid' => 'O valor para "Reter as estatísticas de internet e de tráfego" nos planos de serviço não podem ser menores do que o valor para "Reter as estatísticas de internet e de tráfego" em Ferramentas e Configurações > Configuração do Servidor. Especifique um número inteiro maior ou igual a %%MIN%% e .menos que %%MAX%%.',
    'limitValueOverused' => 'A quantidade de recursos atualmente em uso excede o valor de limite especificado. Não é possível especificar um valor menor do que %%used%%',
    'limitValueOverselled' => 'O limite de uso de recursos de %%reserved%% já está atribuído às assinaturas. Não é possível especificar um valor menor do que %%reserved%%',
    'lessThan' => "'%value%' é menor do que '%min%'",
    'greaterThan' => "'%value%' é maior do que '%max%'",
    'greaterThanDiskQuota' => "%value% é maior que a cota do disco (%max%)",
    'notDigits' => 'O valor deve ser um número inteiro.',
    'digitsInvalid' => 'O valor deve ser um número inteiro.',
    'digitsStringEmpty' => 'O valor deve ser um número inteiro.',
    'isEqual' => "O valor não deve ser igual a '%invalidValue%'.",
    'notInt' => 'O valor deve ser um número inteiro.',
    'maillistNameInvalid' => 'O endereço de mala direta especificado não é válido.',
    'maillistReservedNameAlreadyExists' => 'O endereço especificado já está reservado.',
    'maillistAlreadyExists' => 'O endereço especificado já é utilizado por uma mala direta.',
    'maillistAlreadyExistsOnServer' => 'O nome especificado da mala direta já é utilizado por outra assinatura.',
    'mailnameAlreadyExists' => 'O endereço de e-mail especificado já existe.',
    'mailaliasAlreadyExists' => 'O endereço especificado já é utilizado por um nome alternativo de e-mail.',
    'autoresponderEndDateIsInvalid' => 'A data especificada deve ser no futuro.',
    'mailPostboxLimit' => '%message%',
    'userEmailLimitExceeded' => '%limitManagerMessage%',
    'resourceCannotBeAllocated' => 'O valor solicitado excede os limites do plano de revendedor (%value%).',
    'permissionCannotBeChecked' => 'Não é possível conceder a permissão porque ela entra em conflito com o plano do revendedor.',

    'dump.nameEmpty' => 'Forneça um nome de descarga.',
    'dump.nameInvalid' => 'Um nome de descarga não pode conter nenhum dos seguintes caracteres: %%chars%%.',
    'dump.nameTooLong' => 'O nome do arquivo de despejo especificado é muito longo. Um caminho de despejo completo não deve ser maior do que símbolos %%maxLength%%.',

    'zxcvbnEstimator.passwordStrength' => 'Sua senha não é complexa o suficiente. De acordo com a política do servidor, a força mínima da senha é %strength%.',
    'zxcvbnEstimator.passwordStrengthVeryWeak' => 'Muito fraca (não recomendado)',
    'zxcvbnEstimator.passwordStrengthWeak' => 'Fraca (não recomendado)',
    'zxcvbnEstimator.passwordStrengthMediocre' => 'Média',
    'zxcvbnEstimator.passwordStrengthStrong' => 'Forte (recomendado)',
    'zxcvbnEstimator.passwordStrengthStronger' => 'Muito forte',
    'zxcvbnEstimator.passwordStrengthVeryWeakHint' => 'Pode ser facilmente forçado. Vulnerável a preenchimento de credenciais e ataques de dicionário.',
    'zxcvbnEstimator.passwordStrengthWeakHint' => 'Pode ser facilmente forçado. Menos vulnerável a preenchimento de credenciais e ataques de dicionário.',
    'zxcvbnEstimator.passwordStrengthMediocreHint' => 'Pode ser por força bruta.',
    'zxcvbnEstimator.passwordStrengthStrongHint' => 'Difícil de força bruta. Alguma proteção contra ataques offline.',
    'zxcvbnEstimator.passwordStrengthStrongerHint' => 'Impraticável à força bruta. Proteção razoável contra ataques offline.',

    'emailCantBeRenamed' => "O servidor não suporta a renomeação de contas de e-mail.",
    'emailOwnedByAnotherUser' => "Este endereço de e-mail é de propriedade de outro usuário.",
    'maillistAdminEmailShouldExistsOnDomain' => 'O endereço de e-mail do administrador da mala direta deverá estar registrado no mesmo domínio que o da mala direta.',
    'webmailExists' => "O serviço de webmail '%value%' já existe.",
    'invalidDbName' => 'O nome do banco de dados pode conter somente caracteres alfanuméricos, símbolos de traço e sublinhado.',
    'longDbName' => 'O nome do banco de dados é muito longo.',
    'dbNameClash' => 'O nome do banco de dados e o nome de usuário do banco de dados devem ser diferentes.',
    'dbConnectFailed' => 'Não foi possível conectar com o servidor de banco de dados. Verifique as credenciais de usuário de base de dados e as restrições de acesso.',
    'databaseNameAlreadyExists' => 'Um banco de dados com o nome %value% já existe.',
    'wrongUrlSyntax' => 'O endereço especificado não é válido. É preciso especificar um endereço válido como http://domain.com, caminho/relativo ou mailto:endereço',
    'connectionRefused' => 'Conexão recusada.',
    'loginIncorrect' => 'Nome de usuário incorreto',
    'failedToChangeDirectory' => 'O diretório não existe.',
    'failedToChangeMode' => 'Falha na mudança de modo',
    'failedToCreateDirectory' => 'Não é permitida a criação de arquivos',
    'failedToRenameDirectory' => 'Não é permitida a renomeação de arquivos',
    'failedToDeleteDirectory' => 'Não é permitida a exclusão de arquivos',
    'ipInvalid' => "'%value%' não parece ser um endereço de IP válido ou ele pertence a um tipo errado.",
    'ipv6IsNotGlobal' => "'%value%' não é um endereço IP público.",
    'ipMaskInvalid' => "'%value%' não parece ser uma máscara de endereço IP válida.",
    'ipInvalidForInterface' => 'O endereço IP especificado não pode ser utilizado na interface de rede. É preciso especificar um endereço IP válido com faixa de prefixos ou máscara de subrede.',
    'ipInvalidForInterfaceIpv6NotAvailable' => 'O endereço IP especificado não pode ser utilizado na interface de rede selecionada, pois o suporte de IPv6 está desligado para essa interface.',
    'ipAlreadyExists' => 'O endereço IP %value% já´existe.',
    'notInArray' => 'Essa opção não é suportada.',
    'ipAddressIsNotSelected' => 'No mínimo um endereço IP deveria ser selecionado',
    'noServiceNodeSpecified' => 'Erro interno: nenhum Nó de Serviço especificado',
    'serviceNodeInvalidName' => 'Nome do nó de serviço "%value%" inválido.',
    'serviceNodeNameAlreadyExists' => 'Nó de serviço de nome "%value%" já foi registrado.',
    'serviceNodeIpUsed' => "Nó de serviço não pode ser removido: endereço de ip registrado.",
    'serviceNodeIpAddressAlreadyExists' => 'Nó de serviço no endereço de ip "%value%" já foi registrado.',
    'serviceNodeInvalidTransport' => 'Nome do transporte "%value%" inválido.',
    'app_non_unique_setting_value' => 'Outro objeto tem o mesmo valor de configuração. Esta configuração deverá ser única para este objeto.',
    'wrongLocalUrlSyntax' => 'O endereço especificado é inválido. Especifique um endereço local válido como /smb/web/view.',
    'phpIsapiHandlerTypeNotSupported' => 'O tipo de manipulador ISAPI não é suportado pela versão PHP atual.',
    'dbNameNotExist' => 'O caminho do banco de dados especificado não existe.',
    'invalidBooleanValue' => 'Os valores permitidos são "true" ou "false".',
    'invalidMimeType' => 'O tipo MIME especificado é inválido: "%value%".',
    'invalidHeaders' => 'O cabeçalho especificado é inválido. "%value%".',
    'invalidHandler' => 'O handler especificado é inválido: "%value%".',
    'invalidAllowDeny' => 'A diretiva Permitir/ Negar especificada é inválida: "%value%".',
    'nonUniqueAllowDeny' => 'A diretiva Permitir/ Negar especificada não é exclusiva: "%value%".',
    'maxItemsCountExeededAllowDeny' => 'O número de endereços IP na lista deve ser menor ou igual a %value%.',
    'invalidDirectoryIndex' => 'O arquivo de índice do diretório raiz especificado é inválido.',
    'invalidNginxProxyMode' => 'O valor especificado para a propriedade nginxProxyMode é inválido. Os valores permitidos são "true" ou "false".',
    'invalidNginxTransparentMode' => 'O valor especificado para a propriedade nginxTransparentMode é inválido. Os valores permitidos são "true" ou "false".',
    'invalidNginxServeStatic' => 'O valor especificado para a propriedade nginxServeStatic é inválido. Os valores permitidos são "true" ou "false".',
    'invalidStaticFilesExtensions' => 'As extensões de arquivos estáticos especificados são inválidas: "%value%".',
    'invalidNginxServePhp' => 'O valor especificado para a propriedade nginxServePhp é inválido. Os valores permitidos são "true" ou "false".',
    'invalidDocuments' => 'O nome do documento não deve conter o caractere ",".',
    'duplicateDocuments' => 'Os documentos a seguir já existem na lista: "%value%"',
    'protected_directory_invalid_name' => 'O nome do diretório protegido é inválido.',
    'protected_directory_invalid_login' => 'O login de um usuário de diretório protegido por senha deve ter no máximo 20 caracteres alfanuméricos. O login pode também conter os símbolos de travessão ("-"), mas não pode começar por ele.',
    'notARelativePath' => 'O caminho deve ser relativo',
    'cannotUseJunctions' => 'Não é possível usar junções fora do espaço web como diretório temporário de compilação',
    'notBetween' => '"%value%" não está entre "%min%" e "%max%", inclusive',
    'notBetweenStrict' => '"%value%" não está estritamente entre "%min%" e "%max%"',
    'redirectToMyself' => 'O site não pode ser encaminhado para ele mesmo. Digite o endereço de destino diferente dos principais URL do site.',
    'redirectToAlias' => 'O site não pode ser encaminhado aos seus respectivos alias. Digite o endereço de destino diferente dos principais endereços de alias do site.',
    'relativePathInvalid' => 'O caminho especificado é inválido.',
    'aspDotNetSettingsInvalid' => 'Um ou mais valores especificados para as configurações ASP.NET são inválidos.',
    'mboxOutgoingMessagesLimitValueInvalid' => 'O valor do limite de mensagens enviadas para uma caixa postal deve ser maior que "%%MIN%%".',
    'domainOutgoingMessagesLimitValueInvalid' => 'O valor do limite de mensagens enviadas para um domínio deve ser maior que "%%MIN%%".',
    'subscriptionOutgoingMessagesLimitValueInvalid' => 'O valor do limite de mensagens enviadas para uma assinatura deve ser maior que "%%MIN%%".',
    'iisAuthNotEnabled' => 'Autenticação do Windows ou anônima deve estar ligada nas configurações do servidor web para o domínio.',
    'mboxOutgoingMessagesLimitValueInvalidDigit' => 'O valor do limite de mensagens enviadas para caixa de e-mail deve ser um número inteiro ou \'por padrão\'. Também pode ser \'-1\' para o valor \'Ilimitado\'.',
    'domainOutgoingMessagesLimitValueInvalidDigit' => 'O valor do limite de mensagens enviadas para um domínio deve ser um número inteiro ou \'por padrão\'. Também pode ser \'-1\' para o valor \'Ilimitado\'.',
    'subscriptionOutgoingMessagesLimitValueInvalidDigit' => 'O valor do limite de mensagens enviadas para uma assinatura deve ser um número inteiro ou \'por padrão\'. Também pode ser \'-1\' para o valor \'Ilimitado\'.',
    'outgoingMessagesReportPeriodValueInvalid' => 'O valor especificado para o período de referência não é suportado.',
    'outgoingMessagesNotificationPeriodValueInvalid' => 'O valor especificado para o período de notificação não é suportado.',
    'textItemsListInvalid' => 'O item especificado é inválido: "%value%".',
    'textItemsListInvalidMulti' => 'Os itens especificados são inválidos: "%value%".',
    'textItemsListNonUnique' => 'O valor especificado já existe: "%value%".',
    'textItemsListMaxItemsCountExeeded' => 'O número de itens não deve exceder %value%.',
    'invalidAcl' => 'O host especificado é inválido. "%value%".',
    'nonUniqueAcl' => 'O valor especificado para este host já existe: "%value%".',
    'httpInvalidStatusFormat' => 'Os códigos de status devem ser números na forma 400 ou 400.1',
    'httpInvalidStatusCode' => 'Os códigos de status devem estar entre %%minCode%% e %%maxCode%%',
    'httpInvalidStatusSubCode' => 'Os códigos de substatus devem estar entre %%minSubCode%% e %%maxSubCode%%',
    'httpInvalidStatusRange' => 'Os intervalos de status devem especificar um intervalo de um valor mínimo para um valor máximo',
    'phpSettingValueByteRegexNotMatch' => 'Um valor incorreto foi especificado. Digite um número inteiro e um caractere de taquigrafia (K para kilobyte, M para megabyte, G para gigabyte, por exemplo, 128M) ',
    'phpFpmServersAmountNotPositive' => "O valor deve ser um número positivo.",
    'phpFpmServersAmountLessThan' => "'%value%' tem menos de '%%min%%' (%%field%%)",
    'phpFpmServersAmountGreaterThan' => "'%value%' tem mais de '%%max%%' (%%field%%)",
    'phpInvalidIniSyntax' => "Sintaxe INI inválida detectada online %%line%%: '%%text%%'",
    'portRangeInvalid' => 'O limite especificado da porta é inválido. O valor a esquerda deve ser menor do que o da direita.',
    'portRangeValueInvalid' => 'O valor %value% no limite da porta é inválido. Ele deve estar em %min% - %max%.',
    'domainResolvesToAnotherIp' => 'O domínio determinado para o endereço IP incorreto (%value%). Para colocar seu site online, corrija %%dnsSettingsLink%%.',
    'domainResolvesToAnotherServer' => 'Não é possível usar o nome de domínio porque ele resolve para outro servidor. Para corrigir o problema, altere a política em Ferramentas e Configurações > Nomes de Domínio Proibidos (em "Segurança") ou entre em contato com seu provedor de hospedagem.',
    'domainNotResolved' => 'O domínio não pode ser corrigido. Para colocar seu site online, corrija %%dnsSettingsLink%%.',
    'dnsSettingsLink' => 'Configurações de DNS',

    'backupRotationSingleValueInvalid' => 'O limite foi excedido.',
    'backupRotationMultipleValueInvalid' => 'O limite é excedido por todos os backups agendados para serem armazenados localmente: %%details%%.',
    'backupRotationDetail' => '{count, plural, one {# {type} backup} other {# {type} backups}}',
    'backupRotationTypeHourly' => 'por hora',
    'backupRotationTypeDaily' => 'diário',
    'backupRotationTypeWeekly' => 'semanal',
    'backupRotationTypeMonthly' => 'mensal',
    'backupPathInvalidCharacters' => '"%value%" contém caracteres inválidos.',
    'backupPathInvalidDot' => '"%value%" contém um caminho inválido "." ou "..".',
    'backup.outputFile.invalidCharacters' => 'O nome do arquivo de backup não deve terminar com um número.',
    'backup.outputFile.empty' => 'O caminho de backup não deve estar vazio.',

    'networkAccessAlreadyExists' => 'A rede já está na lista de restrições de acesso IP.',
    'codeRegexNotMatch' => 'O código de ativação não é válido.',
    'nameUsedForPlesk' => 'Não é possível criar o domínio porque seu nome foi encontrado na URL que você usou para efetuar o login no Plesk. Para criar um domínio, faça o login no Plesk via https://%value%:8443 ou https://plesk.%value%.',
    'invalidNameDirectory' => 'O nome especificado é inválido.',
    'invalidPasswordCharacters' => 'A senha não pode conter aspas, espaços ou caracteres nacionais.',
    'invalidPasswordLength' => 'A senha deve ter %%min%% -%%max%% caracteres de comprimento.',
    'passwordContainsLogin' => 'A senha não deve conter login.',

    'invalidPhpExtensionName' => 'O nome da extensão é inválido.',
    'hexStringNotMatch' => 'O valor especificado não parece ser uma string hexadecimal válida.',
    'invalidCertificateData' => 'O valor especificado não parece ser um dado de certificado válido.',
    'invalidSha256Hash' => 'O valor especificado não parece ser um hash SHA-256 válido.',
    'invalidSha512Hash' => 'O valor especificado não parece ser um hash SHA-512 válido.',
    'invalidTlsaMatchingType' => 'Tipo de correspondência TLSA inválido fornecido.',

    'invalidHttpsIpv4hint' => 'O valor especificado deve estar vazio ou conter uma lista de endereços IPv4 separados por vírgula.',
    'invalidHttpsIpv6hint' => 'O valor especificado deve estar vazio ou conter uma lista de endereços IPv6 separados por vírgula.',
    'invalidHttpsProtocols' => 'O valor especificado não deve conter espaços em branco e caracteres \'=\', \'\\\' e não deve ter mais de 255 bytes.',
    'invalidHttpsVal' => 'O valor do registro DNS HTTPS deve estar em conformidade com o padrão RFC 9460.',
    'invalidHttpsValHost' => 'O valor da opção de host de destino deve ser um nome de domínio válido ou estar vazio.',
    'invalidHttpsValPort' => 'O valor da opção \'porta\' deve estar entre 0 e 65535 inclusive.',
    'invalidHttpsValProtocols' => 'O valor da opção \'alpn\' não deve conter espaços em branco e caracteres \'=\', \'\\\' e não deve ter mais de 255 bytes.',
    'invalidHttpsValIpv4hint' => 'O valor da opção \'ipv4hint\' deve estar vazio ou conter uma lista de endereços IPv4 separados por vírgula.',
    'invalidHttpsValIpv6hint' => 'O valor da opção \'ipv6hint\' deve estar vazio ou conter uma lista de endereços IPv6 separados por vírgula.',

    'fail2ban.invalidIpsWithJailsList' => 'A lista de endereços IP e nomes de jails deve ser especificada no formulário \'IP,JAIL[;IP,JAIL...]\'.',
    'fail2ban.invalidIp' => 'Endereços IP na lista devem ser endereços IP válidos ou máscaras CIDR.',
    'fail2ban.invalidIpList' => 'A lista de endereços IP deve ser especificada no formulário \'IP[;IP...]\'.',
    'fail2ban.invalidJail' => 'As jails na lista devem existir e estar ativas no servidor.',
    'fail2ban.ipTooLong' => 'Os endereços IP na lista não devem ser maiores que {max, plural, one {# caracter} other {# caracteres}}.',
    'fail2ban.ipTrusted' => 'Os endereços IP na lista não devem ser endereços IP confiáveis.',
    'fail2ban.banTrustedIp' => 'O endereço IP é marcado como confiável e não pode ser banido.',

    'notifyInvalid' => 'Os seguintes valores são esperados: %value%.',

    'cronStyleError' => 'crontab syntax inválido.',
    'cronStyleErrorWin' => 'Barra (/) e hífen (-) não são permitidos.',

    'scheduler.sysUserLoginInvalid' => 'O usuário do sistema com o nome %value% não é permitido ou não existe.',

    'smarthost.invalidHostname' => 'O valor especificado deve ser um nome de domínio válido ou um endereço IP.',
    'smarthost.invalidUsernameCharacters' => 'O nome de usuário só pode conter letras, números e caracteres especiais, exceto %%invalid%%.',
    'smarthost.invalidUsernameLength' => 'O comprimento do nome de usuário deve estar entre %%minLength%% e %%maxLength%% caracteres.',
    'smarthost.invalidEncryption' => 'Essa opção não é suportada.',

    'serverComponents.componentNotExists' => "O componente '%%value%%' não existe.",
    'serverComponents.packageNotExists' => "O pacote '%%value%%' não existe.",
];