<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'calculate-size.totalSelectionSize' => 'Selection size: %%totalSize%%',
    'calculate-size.invalidFileName' => 'Improper file name',
    'calculate-size.actionError' => 'Unable to calculate the size of the file or directory %%file%%: %%reason%%',

    'code-editor.title' => "Code Editor: %%file%%",
    'code-editor.successSaved' => 'The file was saved successfully.',
    'code-editor.exitConfirmation' => 'Are you sure you want to close the file and discard the unsaved changes?',
    'code-editor.exitConfirmationDescription' => '',

    'copy-files.title' => 'Copy Files',
    'copy-files.hintFile' => 'You are going to copy: %%file%%',
    'copy-files.hintFiles' => 'You are going to copy %%number%% files/directories.',
    'copy-files.destinationFolderHint' => 'Copy to the following directory:',
    'copy-files.overwriteExisting' => 'Replace existing files',
    'copy-files.errorFileExists' => 'A file or directory with the same name already exists in the destination directory.',
    'copy-files.actionSuccess' => 'Selected files and directories were successfully copied.',
    'copy-files.actionError' => 'Unable to copy %%file%%: %%reason%%',
    'copy-files.invalidSourceFileName' => 'Invalid original file name.',
    'copy-files.invalidDestinationFileName' => 'Invalid file name.',
    'copy-files.destinationRequired' => 'Destination directory is not specified.',

    'create-archive.title' => 'Add Files to Archive',
    'create-archive.hint' => 'The path to the archive file: %%folder%%',
    'create-archive.archiveName' => 'Archive file name',
    'create-archive.errorEmptyArchiveName' => 'Enter the archive file name.',
    'create-archive.errorEmptySelection' => 'No file(s) selected.',
    'create-archive.errorArchiveExists' => 'An archive with the same file name already exists.',
    'create-archive.archiveCreated' => '%%archive%% was successfully created.',
    'create-archive.actionError' => 'Unable to create the archive: %%reason%%.',

    'create-directory.title' => 'Create a Directory',
    'create-directory.hint' => 'Add a directory to: %%folder%%',
    'create-directory.folderName' => 'Directory name',
    'create-directory.errorEmptyDirectoryName' => 'Enter a directory name.',
    'create-directory.errorDirectoryExists' => 'A directory or a file with the same name already exists. Please choose a different name.',
    'create-directory.actionError' => 'Unable to create the directory %%directory%%: %%reason%%',
    'create-directory.folderCreated' => 'The %%folder%% directory was successfully created.',
    'create-directory.errorInvalidPath' => 'Invalid path specified.',

    'create-file.title' => 'Create a File',
    'create-file.hint' => 'Add a file to: %%folder%%',
    'create-file.fileName' => 'File name',
    'create-file.htmlTemplate' => 'Use the HTML template',
    'create-file.htmlTemplateHint' => 'Create a blank HTML page.',
    'create-file.errorEmptyFileName' => 'Enter the file name.',
    'create-file.errorFileExists' => 'A file or directory with the same name already exists. Please choose a different name.',
    'create-file.actionError' => 'Unable to create %%file%%: %%reason%%',
    'create-file.fileCreated' => '%%file%% was successfully created.',

    'delete.actionSuccess' => 'Selected files and directories were removed.',
    'delete.invalidFileName' => 'Invalid file name.',
    'delete.actionError' => 'Failed to remove %%file%%',

    'moveToTrash.actionSuccess' => 'Selected files and directories were removed.',
    'moveToTrash.invalidFileName' => 'Invalid file name.',
    'moveToTrash.actionError' => 'Failed to move %%file%% to recycle bin',

    'purge.actionSuccess' => 'The selected files and directories were removed.',
    'purge.actionError' => 'Failed to remove %%file%%: %%reason%%',
    'purgeAll.actionSuccess' => 'All files and directories were removed from the Recycle Bin.',

    'edit.title' => "Edit the File %%file%%",
    'edit.successSaved' => 'The file was saved successfully.',

    'extract-archive.title' => 'Extract Files',
    'extract-archive.hintFile' => 'Selected archive: %%file%%',
    'extract-archive.hintFiles' => '%%number%% archives selected.',
    'extract-archive.destinationFolderHint' => 'Extract files to the following directory:',
    'extract-archive.actionSuccess' => 'Files from the selected archives were successfully extracted.',
    'extract-archive.actionError' => 'Unable to extract %%file%%: %%reason%%',
    'extract-archive.invalidSourceFileType' => 'The file type is not supported. Only ZIP, TAR, TAR.GZ, TGZ, RAR archives are allowed.',
    'extract-archive.overwriteExisting' => 'Replace existing files',
    'extract-archive.unrarNotInstalled-admin' => 'To extract RAR archives, <a target="_blank" href="https://support.plesk.com/hc/en-us/articles/12376970580759">install RAR unarchiver</a>.',
    'extract-archive.unrarNotInstalled-customer' => 'To extract RAR archives, contact your hosting provider.',

    'import-file.invalidUrl' => 'Invalid URL.',

    'index.title' => 'Files',
    'index.pageHint' => 'This is where you can manage files of webspaces.',

    'list-data.actionError' => 'Unable to open the directory: %%reason%%',

    'search-data.actionError' => 'Could not search for the files: %%reason%%',
    'search-data.limitReached' => 'The limit on the number of found files was reached.',

    'list.title' => 'File Manager',
    'list.titleForObject' => 'File Manager for %%name%%',

    'move-files.title' => 'Move Files',
    'move-files.hintFile' => 'You are going to move: %%file%%',
    'move-files.hintFiles' => 'You are going to move %%number%% files/directories.',
    'move-files.destinationFolderHint' => 'Move to the following directory:',
    'move-files.overwriteExisting' => 'Replace existing files',
    'move-files.errorFileExists' => 'A file or directory with the same name already exists in the destination directory.',
    'move-files.actionSuccess' => 'Selected files and directories were successfully moved.',
    'move-files.actionError' => 'Unable to move %%file%%: %%reason%%',
    'move-files.invalidSourceFileName' => 'Invalid original file name.',
    'move-files.invalidDestinationFileName' => 'Invalid file name.',
    'move-files.destinationRequired' => 'Destination directory is not specified.',

    'permissions.titleFile' => "Change Permissions for the File %%file%%",
    'permissions.titleDir' => "Change Permissions for the Directory %%file%%",
    'permissions.successUpdatePermissions' => "File or directory access permissions were successfully updated.",

    'rename.title' => 'Rename',
    'rename.waitButtonTitle' => 'Please wait',
    'rename.hint' => 'You are going to rename: %%file%%',
    'rename.fileName' => 'New name',
    'rename.errorFileExists' => 'A file or directory with the same name already exists in this directory.',
    'rename.actionSuccess' => 'The file was renamed.',
    'rename.actionError' => 'Unable to rename %%file%%: %%reason%%',
    'rename.invalidSourceFileName' => 'Invalid original file name.',
    'rename.invalidDestinationFileName' => 'Invalid file name.',

    'show.title' => "Show the File %%file%%",
    'show.failedReadContent' => 'Unable to display the file %%file%%: Unable to read the file due to insufficient permissions.',
    'show.unsupportedFileType' => 'Unable to display the file %%file%%: Unsupported file format.',
    'show.maxFileSizeExceeded' => 'Unable to display the file. The file size cannot be greater than %%max%% bytes.',

    'show-image.errorShowImage' => 'There is no way to show the image: %%msg%%',

    'touch.actionSuccess' => 'The time of the last modification for the selected files and directories was successfully updated.',
    'touch.invalidFileName' => 'Invalid file name.',
    'touch.actionError' => 'Unable to change the timestamp for the file %%file%%: %%reason%%',

    'tree-data.actionError' => 'Unable to open the directory: %%reason%%',

    'upload.title' => 'Select Files To Upload',
    'upload.hint' => 'Select Files To Upload',
    'upload.addFileItem' => 'Add one more file',
    'upload.buttonCancelUploadClicked' => 'Canceling...',
    'upload.buttonClose' => 'Close',
    'upload.buttonReplace' => 'Replace',
    'upload.buttonSkip' => 'Skip',
    'upload.noFilesSelectedForUpload' => 'No files selected. To upload the files, you have to select them.',
    'upload.uploadDialogTitle' => 'Uploading Files...',
    'upload.uploadDialogHint' => 'Please wait until the selected files are uploaded to the server.',
    'upload.replaceExistingFilesDialogTitle' => 'Replace the existing files?',
    'upload.replaceExistingFilesDialogHint' => 'The following files already exist in this directory. Do you want to replace them?',
    'upload.statusNotStarted' => 'Not started',
    'upload.statusUploading' => 'Uploading...',
    'upload.statusCompleted' => 'Completed',
    'upload.statusFailed' => 'Failed',
    'upload.statusCanceled' => 'Canceled',
    'upload.descriptionUploadProgress' => '%%completed%% of %%total%% files were uploaded',
    'upload.failed' => 'Some files were not uploaded due to an error. The remaining files will not be uploaded.',
    'upload.errorDialogTitle' => 'Error',
    'upload.errorFileExists' => '%%file%% already exists',
    'upload.errorFileIsLarger' => 'The file "%%filename%%" is too big. Try to upload this file via FTP.',
    'upload.errorInvalidPath' => 'Invalid path specified.',
    'upload.uploadFinished' => '%%completed%% files were uploaded to %%folder%%.',
    'upload.uploadFinishedSingleFile' => '%%file%% was uploaded to %%folder%%.',
    'upload.uploadFailedSingleFile' => '%%file%% was not uploaded to %%folder%%.',
    'upload.uploadFinishedNoFiles' => 'No files were uploaded.',
    'upload.uploadCanceled' => 'The upload was canceled. %%completed%% files were uploaded to %%folder%%.',
    'upload.totalProgressText' => '%%percent%% completed',
    'upload.progressText' => '%%loaded%% of %%total%%',
    'upload.bytes' => 'B',
    'upload.kbytes' => 'KB',
    'upload.mbytes' => 'MB',
    'upload.gbytes' => 'GB',

    'view-settings.title' => 'File Manager Settings',
    'view-settings.hint' => 'Here you can change the layout of File Manager as well as how the content in your directories is displayed.',
    'view-settings.folderTree' => 'Show the navigation pane',
    'view-settings.previewPanel' => 'Show preview',
    'view-settings.showAdvanced' => 'Show advanced settings',
    'view-settings.hideAdvanced' => 'Hide advanced settings',
    'view-settings.systemFiles' => 'Show system files and directories',
    'view-settings.permissions' => 'Show permissions',
    'view-settings.userAndGroup' => 'Show users and groups',
    'view-settings.actionError' => 'Unable to update view settings: %%reason%%',
    'view-settings.actionSuccess' => 'View settings were successfully updated.',

    'wysiwyg.title' => "HTML Editor: %%file%%",
    'wysiwyg.successSaved' => 'The file was saved successfully.',
    'wysiwyg.waitButtonTitle' => 'Please wait',

    'form.buttonReload' => 'Reload',
    'form.buttonSave' => 'Save',
    'form.buttonSaveAs' => 'Save As',
    'form.buttonReset' => 'Reset',
    'form.buttonOk' => 'OK',
    'form.buttonApply' => 'Apply',
    'form.buttonCancel' => 'Cancel',
    'form.buttonTextCodeEditor' => 'Edit in Code Editor',
    'form.buttonTextEdit' => 'Edit in Text Editor',
    'form.buttonWysiwygEdit' => 'Edit in HTML Editor',
    'form.eolLabel' => 'Line break type:',
    'form.saveAs' => 'Save as:',
    'form.saveCodepage' => 'Save in the following encoding:',
    'form.loadCodepage' => 'View the original file in the following encoding:',
    'form.loadCodepageHint' => 'Warning: Any unsaved changes will be lost on reloading the file.',
    'form.fileExists' => "The file or directory %%fileName%% already exists. Please choose a different name.",
    'form.exitConfirmation' => 'Are you sure you want to close the file and discard the unsaved changes?',
    'form.exitConfirmationDescription' => '',
    'form.exitConfirmationYes' => 'Yes',
    'form.exitConfirmationNo' => 'No',
    'form.fileOverwrite' => 'File already exists.',
    'form.fileOverwriteDescription' => 'A file with the same name already exists. Do you want to overwrite it?',
];
